/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.io.FileAssociation;
import genj.io.InputSource;
import genj.io.input.FileInput;
import genj.io.input.URLInput;
import genj.util.Origin;
import genj.util.swing.ImageIcon;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.openide.util.NbPreferences;

public class PropertyFile
extends Property {
    private static final Logger LOG = Logger.getLogger("ancestris.app");
    public static final ImageIcon DEFAULT_IMAGE = Grammar.V55.getMeta(new TagPath("INDI:OBJE:FILE")).getImage();
    private String file;
    private boolean isLocal = true;
    private boolean isRemote = false;
    private boolean isRelative = false;
    private boolean isFound = true;
    private Optional<InputSource> input = Optional.empty();
    private static final MimeTypes allTypes = MimeTypes.getDefaultMimeTypes();

    public PropertyFile(String tag) {
        super(tag);
    }

    public boolean isIsLocal() {
        return this.isLocal;
    }

    public boolean isIsRemote() {
        return this.isRemote;
    }

    public boolean isFound() {
        return this.isFound;
    }

    public void setFound(boolean set) {
        this.isFound = set;
    }

    public boolean isRelative() {
        return this.isRelative;
    }

    @Override
    public boolean isValid() {
        if (!NbPreferences.forModule(Gedcom.class).getBoolean("isFileNotFoundValid", false)) {
            this.forceInput();
            return this.isFound;
        }
        return super.isValid();
    }

    @Override
    public boolean addFile(InputSource is) {
        String absolute = is.getLocation();
        String relative = null;
        if (GedcomOptions.getInstance().isForceRelative() && this.getGedcom() != null) {
            relative = this.getGedcom().getOrigin().calcRelativeLocation(absolute);
        }
        this.setValue(relative != null ? relative : absolute, true);
        return true;
    }

    @Override
    public String getValue() {
        return this.file == null ? "" : this.file;
    }

    @Override
    public synchronized void setValue(String value) {
        String old = this.getValue();
        this.file = value.replace('\\', '/');
        if (!value.equals(old)) {
            this.input = Optional.empty();
        }
        String path = Origin.getPath(this.file);
        this.isRelative = Origin.isRelative(path);
        Gedcom gedcom = this.getGedcom();
        if (gedcom != null) {
            boolean isUnder;
            String underneathPath = this.isRelative ? path : gedcom.getOrigin().calcRelativeLocation(path);
            boolean isG7 = gedcom.isGrammar7();
            boolean bl = isUnder = underneathPath != null && !underneathPath.contains("..");
            if (isUnder && (this.isRelative || GedcomOptions.getInstance().isForceRelative())) {
                this.file = underneathPath;
                this.isRelative = true;
            } else if (!isUnder && this.isRelative) {
                this.file = (isG7 ? "file://" : "") + path;
            } else if (!this.isRelative && isG7 && this.file.replaceAll("^.*\\/\\/", "").equals(this.file)) {
                this.file = "file://" + this.file;
            }
        }
        this.forceInput();
        this.propagatePropertyChanged(this, old);
    }

    private void forceInput() {
        File fichier = this.getFile();
        if (fichier == null) {
            this.isLocal = false;
            this.isRemote = false;
            this.input = Optional.empty();
            this.isFound = false;
            return;
        }
        if (fichier.exists()) {
            this.isLocal = true;
            this.isFound = true;
            this.isRemote = false;
            this.input = InputSource.get(fichier);
        } else {
            try {
                URL remote = new URL(Origin.getPath(this.file));
                this.isLocal = false;
                this.isRemote = true;
                if (this.input.equals(Optional.empty())) {
                    this.input = InputSource.get(remote);
                }
                this.isFound = true;
            }
            catch (MalformedURLException mfue) {
                LOG.log(Level.FINEST, "URL exception.", mfue.getLocalizedMessage());
                this.isLocal = false;
                this.isRemote = false;
                this.input = Optional.empty();
                this.isFound = false;
            }
        }
    }

    public synchronized void setValueAsIs(String value) {
        String old = this.getValue();
        if (!value.equals(old)) {
            this.input = Optional.empty();
        }
        this.file = value.replace('\\', '/');
        this.propagatePropertyChanged(this, old);
    }

    public void setValue(String value, boolean updateMeta) {
        Property form;
        this.setValue(value);
        Property media = this.getParent();
        if (!updateMeta || !media.getTag().equals("OBJE")) {
            return;
        }
        Property parent = this;
        if (!this.getMetaProperty().allows("FORM")) {
            if (!media.getMetaProperty().allows("FORM")) {
                return;
            }
            parent = media;
        }
        if ((form = parent.getProperty("FORM", false)) == null) {
            parent.addProperty("FORM", this.getSuffix());
        } else {
            form.setValue(this.getSuffix());
        }
    }

    public File getFile() {
        Gedcom gedcom = this.getGedcom();
        return gedcom != null ? gedcom.getOrigin().getFile(this.file) : null;
    }

    public Optional<InputSource> getInput() {
        if (!this.input.isPresent()) {
            this.forceInput();
        }
        return this.input;
    }

    public static int getMaxValueAsIconSize(boolean kb) {
        return (kb ? 1 : 1024) * GedcomOptions.getInstance().getMaxImageFileSizeKB();
    }

    public String getSuffix() {
        String ret = "";
        this.getInput();
        ret = this.input.isPresent() ? this.input.get().getExtension() : PropertyFile.getSuffix(this.file);
        if (this.isGrammar7()) {
            ret = PropertyFile.getMimeType(ret);
        }
        return ret;
    }

    private static String getSuffix(String value) {
        int j;
        int i;
        String result = "";
        if (value != null && (i = value.lastIndexOf(46)) >= 0 && (j = (result = value.substring(i + 1)).indexOf(63)) > 0) {
            result = result.substring(0, j);
        }
        return result;
    }

    public boolean isOpenable() {
        Optional<InputSource> oInput = this.getInput();
        if (!oInput.isPresent()) {
            return false;
        }
        InputSource inputSource = oInput.get();
        return inputSource instanceof FileInput || inputSource instanceof URLInput;
    }

    public void openFile() {
        Optional<InputSource> oInput = this.getInput();
        if (!oInput.isPresent()) {
            return;
        }
        InputSource inputSource = oInput.get();
        if (inputSource instanceof FileInput) {
            FileInput fileInput = (FileInput)inputSource;
            FileAssociation.getDefault().execute(fileInput.getFile());
        }
        if (inputSource instanceof URLInput) {
            URLInput uRLInput = (URLInput)inputSource;
            FileAssociation.getDefault().execute(uRLInput.getURL());
        }
    }

    public static String getMimeType(String value) {
        String retour;
        block6: {
            retour = value.toLowerCase();
            try {
                for (MediaType mt : allTypes.getMediaTypeRegistry().getTypes()) {
                    MimeType mit = allTypes.getRegisteredMimeType(mt.toString());
                    for (String extent : mit.getExtensions()) {
                        if (!extent.equals("." + value)) continue;
                        retour = mit.getName();
                        break block6;
                    }
                }
            }
            catch (MimeTypeException e) {
                retour = value;
            }
        }
        if ("image/jpeg".equals(retour)) {
            retour = "image/jpg";
        }
        if ("web".equals(retour)) {
            retour = "text/html";
        }
        return retour;
    }
}

