/*
 * Decompiled with CFR 0.152.
 */
package ancestris.gedcom;

import ancestris.core.actions.JumpToEntityAction;
import ancestris.core.actions.SubMenuAction;
import ancestris.gedcom.AbstractPropertyFinder;
import ancestris.gedcom.Bundle;
import ancestris.gedcom.PropertyFinder;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class Relative {
    private static final Map<PropertyFinder, Relative> RELATIVES = new HashMap<PropertyFinder, Relative>(20);
    private String description = "";
    private PropertyFinder finder = null;
    private static final int POSITION = 1500;

    private Relative(String desc, PropertyFinder finder) {
        this.description = desc;
        this.finder = finder;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static Relative create(String Desc, PropertyFinder finder) {
        Relative result = RELATIVES.get(finder);
        if (result == null) {
            result = new Relative(Desc, finder);
            RELATIVES.put(finder, result);
        }
        return result;
    }

    public static Relative get(PropertyFinder key) {
        return RELATIVES.get(key);
    }

    public Collection<Entity> find(Collection<Entity> roots) {
        Collection<Entity> result = new ArrayList<Entity>();
        if (this.finder != null) {
            result = this.finder.find(roots);
        }
        return result;
    }

    public Collection<Entity> find(Entity root) {
        Collection<Entity> result = new ArrayList<Entity>();
        if (this.finder != null) {
            result = this.finder.find(root);
        }
        return result;
    }

    private static SubMenuAction createSubmenuAction(String description, Icon icon, Collection<Entity> entities) {
        SubMenuAction result = new SubMenuAction();
        if (entities != null) {
            for (Entity entity : entities) {
                result.addAction(new JumpToEntityAction(entity));
            }
            result.setText(description + " (" + entities.size() + ")");
            result.setImage(icon);
        } else {
            result.clearActions();
            result.setText("");
            result.putValue("hideWhenDisabled", true);
        }
        return result;
    }

    static {
        Relative.create(NbBundle.getMessage(Relative.class, (String)"father"), PropertyFinder.Constants.FATHER);
        Relative.create(NbBundle.getMessage(Relative.class, (String)"mother"), PropertyFinder.Constants.MOTHER);
        Relative.create(NbBundle.getMessage(Relative.class, (String)"parent"), PropertyFinder.Constants.PARENT);
        Relative.create(NbBundle.getMessage(Relative.class, (String)"grandparent"), PropertyFinder.Constants.GRANDPARENT);
        Relative.create(NbBundle.getMessage(Relative.class, (String)"sibling"), PropertyFinder.Constants.SIBLING);
        Relative.create(NbBundle.getMessage(Relative.class, (String)"brother"), PropertyFinder.Constants.BROTHER);
        Relative.create(NbBundle.getMessage(Relative.class, (String)"sister"), PropertyFinder.Constants.SISTER);
        Relative.create(NbBundle.getMessage(Relative.class, (String)"husband"), PropertyFinder.Constants.HUSBAND);
        Relative.create(NbBundle.getMessage(Relative.class, (String)"wife"), PropertyFinder.Constants.WIFE);
        Relative.create(NbBundle.getMessage(Relative.class, (String)"spouse"), PropertyFinder.Constants.SPOUSE);
        Relative.create(Bundle.child(), PropertyFinder.Constants.CHILD);
        Relative.create(NbBundle.getMessage(Relative.class, (String)"daughter"), PropertyFinder.Constants.DAUGHTER);
        Relative.create(NbBundle.getMessage(Relative.class, (String)"son"), PropertyFinder.Constants.SON);
        Relative.create(NbBundle.getMessage(Relative.class, (String)"grandchild"), PropertyFinder.Constants.GRANDCHILD);
        Relative.create(NbBundle.getMessage(Relative.class, (String)"grandson"), PropertyFinder.Constants.GRANDSON);
        Relative.create(NbBundle.getMessage(Relative.class, (String)"granddaughter"), PropertyFinder.Constants.GRANDDAUGHTER);
        Relative.create(NbBundle.getMessage(Relative.class, (String)"uncle.aunt"), PropertyFinder.Constants.UNCLE_AUNT);
        Relative.create(NbBundle.getMessage(Relative.class, (String)"nephews"), PropertyFinder.Constants.NEPHEW);
        Relative.create(NbBundle.getMessage(Relative.class, (String)"first.cousin"), PropertyFinder.Constants.FIRSTCOUSIN);
        Relative.create(NbBundle.getMessage(Relative.class, (String)"great.uncles"), PropertyFinder.Constants.GREAT_UNCLE_AUNT);
    }

    private static class NavigateAction
    extends SubMenuAction {
        private List<Relative> relatives;
        private String description = "";

        public NavigateAction(Relative relative) {
            this.relatives = new ArrayList<Relative>(Collections.singletonList(relative));
            this.description = relative.getDescription();
            this.putValue("hideWhenDisabled", false);
        }

        public void addGroup(Relative relative) {
            this.relatives.add(relative);
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        protected List<Action> buildActions(Entity entity, Collection<Entity> entities) {
            ArrayList<Action> result = new ArrayList<Action>();
            for (Entity e : entities) {
                result.add(new JumpToEntityAction(e));
            }
            return result;
        }

        @Override
        public Action createContextAwareInstance(Lookup context) {
            Entity entity = (Entity)context.lookup(Entity.class);
            if (entity != null && entity instanceof Indi) {
                int count = 0;
                this.clearActions();
                this.putValue("hideWhenDisabled", false);
                for (Relative relative : this.relatives) {
                    Collection<Entity> find = relative.find(entity);
                    count += find.size();
                    this.addActions(this.buildActions(entity, find));
                    this.addAction(null);
                }
                this.setText(this.description + " (" + count + ")");
            } else {
                this.clearActions();
                this.setText("");
                this.putValue("hideWhenDisabled", true);
            }
            return super.createContextAwareInstance(context);
        }
    }

    public static class GrandParentNavigateAction
    extends NavigateAction {
        public GrandParentNavigateAction() {
            super(Relative.get(PropertyFinder.Constants.GRANDPARENT));
        }
    }

    public static class GreatUnclesNavigateAction
    extends NavigateAction {
        public GreatUnclesNavigateAction() {
            super(Relative.get(PropertyFinder.Constants.GREAT_UNCLE_AUNT));
        }
    }

    public static class CousinNavigateAction
    extends NavigateAction {
        public CousinNavigateAction() {
            super(Relative.get(PropertyFinder.Constants.FIRSTCOUSIN));
        }
    }

    public static class UncleAuntNavigateAction
    extends NavigateAction {
        public UncleAuntNavigateAction() {
            super(Relative.create(NbBundle.getMessage(Relative.class, (String)"uncle.aunt"), PropertyFinder.Constants.UNCLE_AUNT));
        }
    }

    public static class SpouseNavigateAction
    extends NavigateAction {
        public SpouseNavigateAction() {
            super(Relative.create(NbBundle.getMessage(Relative.class, (String)"spouse"), new AbstractPropertyFinder.TagPathFinder(Indi.class, "INDI:FAMS:*")));
        }

        @Override
        protected List<Action> buildActions(Entity entity, Collection<Entity> entities) {
            if (!(entity instanceof Indi)) {
                return super.buildActions(entity, entities);
            }
            ArrayList<Action> result = new ArrayList<Action>();
            for (Entity e : entities) {
                Fam fams = (Fam)e;
                Indi spouse = fams.getOtherSpouse((Indi)entity);
                if (spouse != null) {
                    result.add(new JumpToEntityAction(spouse));
                    result.add(Relative.createSubmenuAction(Bundle.parents_law(), null, PropertyFinder.Constants.PARENT.find(spouse)));
                    result.add(Relative.createSubmenuAction(Bundle.sibling_law(), null, PropertyFinder.Constants.SIBLING.find(spouse)));
                }
                ArrayList<Entity> children = new ArrayList<Entity>(Arrays.asList(fams.getChildren()));
                result.add(Relative.createSubmenuAction(Bundle.child(), null, children));
                result.add(Relative.createSubmenuAction(Bundle.child_law(), null, PropertyFinder.Constants.SPOUSE.find(children)));
                result.add(Relative.createSubmenuAction(Bundle.grandchild(), null, new ArrayList<Entity>(PropertyFinder.Constants.CHILD.find(children))));
                result.add(null);
            }
            return result;
        }
    }

    public static class SiblingNavigateAction
    extends NavigateAction {
        public SiblingNavigateAction() {
            super(Relative.get(PropertyFinder.Constants.SIBLING));
        }

        @Override
        protected List<Action> buildActions(Entity entity, Collection<Entity> entities) {
            if (!(entity instanceof Indi)) {
                return super.buildActions(entity, entities);
            }
            ArrayList<Action> result = new ArrayList<Action>();
            for (Entity e : entities) {
                result.add(new JumpToEntityAction(e));
            }
            result.add(Relative.createSubmenuAction(NbBundle.getMessage(Relative.class, (String)"nephews"), null, PropertyFinder.Constants.NEPHEW.find(entity)));
            return result;
        }
    }

    public static class ParentNavigateAction
    extends NavigateAction {
        public ParentNavigateAction() {
            super(Relative.get(PropertyFinder.Constants.PARENT));
        }
    }
}

