/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core.actions;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.core.resources.Images;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.UnitOfWork;
import genj.util.Resources;
import genj.util.swing.ImageIcon;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.LookupEvent;

public class Prefer
extends AbstractAncestrisContextAction {
    protected static final Resources RESOURCES = Resources.get(Prefer.class);
    protected static final Logger LOG = Logger.getLogger("ancestris.core.actions");
    private static ImageIcon IMAGE;
    private Fam fam;
    private boolean isPreferred = false;

    @Override
    public void resultChanged(LookupEvent ev) {
        if (this.lkpInfo != null) {
            this.fam = null;
            for (Property prop : this.lkpInfo.allInstances()) {
                if (!(prop instanceof Fam)) continue;
                this.fam = (Fam)prop;
                this.isPreferred = this.fam.isPreferred();
            }
            super.resultChanged(ev);
        }
    }

    @Override
    protected void contextChanged() {
        super.contextChanged();
        if (this.fam != null) {
            IMAGE = this.fam.getImage(false);
            if (this.isPreferred) {
                super.setImage(IMAGE.getOverLayed(Images.imgPref));
            } else {
                super.setImage(IMAGE);
            }
        }
        this.setText(this.getLabel());
        this.setTip(RESOURCES.getString("xref.prefer.tip"));
        this.setEnabled(this.fam != null);
    }

    public Prefer() {
    }

    public Prefer(Fam fam) {
        this.fam = fam;
        super.setText(this.getLabel());
        super.setImage(Images.imgPref);
        super.setTip(RESOURCES.getString("xref.prefer.tip"));
        this.setEnabled(fam != null);
    }

    private String getLabel() {
        return RESOURCES.getString(this.isPreferred ? "xref.preferoff" : "xref.preferon");
    }

    @Override
    public void actionPerformedImpl(ActionEvent event) {
        if (this.fam == null) {
            return;
        }
        try {
            this.fam.getGedcom().doUnitOfWork(new UnitOfWork(){

                @Override
                public void perform(Gedcom gedcom) throws GedcomException {
                    Prefer.this.isPreferred = !Prefer.this.isPreferred;
                    Prefer.this.fam.setPreferred(Prefer.this.isPreferred);
                }
            });
        }
        catch (GedcomException ge) {
            DialogManager.create(this.getText(), ge.getMessage()).setMessageType(2).show();
            LOG.log(Level.FINER, ge.getMessage(), ge);
        }
    }
}

