/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.gexf;

import java.lang.reflect.Array;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.graphstream.stream.SinkAdapter;
import org.graphstream.stream.file.gexf.GEXF;
import org.graphstream.stream.file.gexf.GEXFElement;
import org.graphstream.stream.file.gexf.GEXFNode;
import org.graphstream.stream.file.gexf.SmartXMLWriter;

public class GEXFNodes
extends SinkAdapter
implements GEXFElement {
    GEXF root;
    HashMap<String, GEXFNode> nodes;

    public GEXFNodes(GEXF root) {
        this.root = root;
        this.nodes = new HashMap();
        root.addSink(this);
    }

    private float[] convertToXYZ(Object value) {
        if (value == null || !value.getClass().isArray()) {
            return null;
        }
        float[] xyz = new float[Array.getLength(value)];
        int i = 0;
        while (i < xyz.length) {
            Object o = Array.get(value, i);
            if (!(o instanceof Number)) {
                return null;
            }
            xyz[i] = ((Number)o).floatValue();
            ++i;
        }
        return xyz;
    }

    @Override
    public void export(SmartXMLWriter stream) throws XMLStreamException {
        stream.startElement("nodes");
        for (GEXFNode node : this.nodes.values()) {
            node.export(stream);
        }
        stream.endElement();
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        GEXFNode node = this.nodes.get(nodeId);
        if (node == null) {
            node = new GEXFNode(this.root, nodeId);
            this.nodes.put(nodeId, node);
        }
        node.spells.start();
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        GEXFNode node = this.nodes.get(nodeId);
        if (node == null) {
            System.err.printf("node removed but not added\n", new Object[0]);
            return;
        }
        node.spells.end();
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        GEXFNode node = this.nodes.get(nodeId);
        if (("ui.label".equals(attribute) || "label".equals(attribute)) && value != null) {
            node.label = value.toString();
        }
        if ("xyz".equals(attribute)) {
            float[] xyz = this.convertToXYZ(value);
            switch (xyz.length) {
                default: {
                    node.z = xyz[2];
                }
                case 2: {
                    node.y = xyz[1];
                }
                case 1: {
                    node.x = xyz[0];
                }
                case 0: 
            }
            node.position = true;
        }
        node.attvalues.attributeUpdated(this.root.getNodeAttribute(attribute), value);
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.nodeAttributeAdded(sourceId, timeId, nodeId, attribute, newValue);
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        GEXFNode node = this.nodes.get(nodeId);
        node.attvalues.attributeUpdated(this.root.getNodeAttribute(attribute), null);
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
        for (GEXFNode node : this.nodes.values()) {
            node.spells.end();
        }
    }
}

