/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree;

import ancestris.report.svgtree.graphics.GraphicsRenderer;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class RotateRenderer
implements GraphicsRenderer {
    private final GraphicsRenderer renderer;
    private int rotation = 0;

    public RotateRenderer(GraphicsRenderer renderer) {
        this.renderer = renderer;
    }

    public void setRotation(int set) {
        this.rotation = set;
    }

    @Override
    public int getImageHeight() {
        if (this.rotation == 0 || this.rotation == 2) {
            return this.renderer.getImageHeight();
        }
        return this.renderer.getImageWidth();
    }

    @Override
    public int getImageWidth() {
        if (this.rotation == 0 || this.rotation == 2) {
            return this.renderer.getImageWidth();
        }
        return this.renderer.getImageHeight();
    }

    @Override
    public void render(Graphics2D graphics) {
        AffineTransform transform = graphics.getTransform();
        switch (this.rotation) {
            case 3: {
                graphics.translate(this.renderer.getImageHeight(), 0);
                graphics.rotate(1.5707963267948966);
                break;
            }
            case 2: {
                graphics.translate(this.renderer.getImageWidth(), this.renderer.getImageHeight());
                graphics.rotate(Math.PI);
                break;
            }
            case 1: {
                graphics.translate(0, this.renderer.getImageWidth());
                graphics.rotate(-1.5707963267948966);
            }
        }
        this.renderer.render(graphics);
        graphics.setTransform(transform);
    }
}

