/*
 * Decompiled with CFR 0.152.
 */
package vrpn;

import java.util.Enumeration;
import java.util.Vector;
import vrpn.ForceDeviceRemote;
import vrpn.VRPNDevice;

public class ForceDeviceRemote
extends VRPNDevice
implements Runnable {
    public static final int NO_CONSTRAINT = 0;
    public static final int POINT_CONSTRAINT = 1;
    public static final int LINE_CONSTRAINT = 2;
    public static final int PLANE_CONSTRAINT = 3;
    protected Vector forceListeners = new Vector();
    protected Vector scpListeners = new Vector();
    protected Vector errorListeners = new Vector();
    protected static final Object notifyingForceListenersLock = new Object();
    protected static final Object notifyingSCPListenersLock = new Object();
    protected static final Object notifyingErrorListenersLock = new Object();

    public ForceDeviceRemote(String string, String string2, String string3, String string4, String string5) throws InstantiationException {
        super(string, string2, string3, string4, string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSurface() {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.sendSurface_native();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSurface() {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.startSurface_native();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSurface() {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.stopSurface_native();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVertex(int n, float f, float f2, float f3) {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.setVertex_native(n, f, f2, f3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNormal(int n, float f, float f2, float f3) {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.setNormal_native(n, f, f2, f3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTriangle(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.setTriangle_native(n, n2, n3, n4, n5, n6, n7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTriangle(int n) {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.removeTriangle_native(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTrimeshChanges() {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.updateTrimeshChanges_native();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrimeshTransform(float[] fArray) {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.setTrimeshTransform_native(fArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTrimesh() {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.clearTrimesh_native();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useHcollide() {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.useHcollide_native();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useGhost() {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.useGhost_native();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enableConstraint(int n) {
        boolean bl = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            bl = this.enableConstraint_native(n);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConstraintMode(int n) {
        boolean bl = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            bl = this.setConstraintMode_native(n);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConstraintPoint(float[] fArray) {
        boolean bl = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            bl = this.setConstraintPoint_native(fArray);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConstraintLinePoint(float[] fArray) {
        boolean bl = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            bl = this.setConstraintLinePoint_native(fArray);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConstraintLineDirection(float[] fArray) {
        boolean bl = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            bl = this.setConstraintLineDirection_native(fArray);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConstraintPlanePoint(float[] fArray) {
        boolean bl = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            bl = this.setConstraintPlanePoint_native(fArray);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConstraintPlaneNormal(float[] fArray) {
        boolean bl = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            bl = this.setConstraintPlaneNormal_native(fArray);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConstraintKSpring(float f) {
        boolean bl = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            bl = this.setConstraintKSpring_native(f);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendForceField(float[] fArray, float[] fArray2, float[][] fArray3, float f) {
        boolean bl = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            bl = this.sendForceField_native(fArray, fArray2, fArray3, f);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendForceField() {
        boolean bl = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            bl = this.sendForceField_native();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopForceField() {
        boolean bl = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            bl = this.stopForceField_native();
        }
        return bl;
    }

    public synchronized void addForceChangeListener(ForceChangeListener forceChangeListener) {
        this.forceListeners.addElement(forceChangeListener);
    }

    public synchronized boolean removeForceChangeListener(ForceChangeListener forceChangeListener) {
        return this.forceListeners.removeElement(forceChangeListener);
    }

    public synchronized void addSCPChangeListener(SCPChangeListener sCPChangeListener) {
        this.scpListeners.addElement(sCPChangeListener);
    }

    public synchronized boolean removeSCPChangeListener(SCPChangeListener sCPChangeListener) {
        return this.scpListeners.removeElement(sCPChangeListener);
    }

    public synchronized void addForceErrorListener(ForceErrorListener forceErrorListener) {
        this.errorListeners.addElement(forceErrorListener);
    }

    public synchronized boolean removeForceErrorListener(ForceErrorListener forceErrorListener) {
        return this.errorListeners.removeElement(forceErrorListener);
    }

    protected native void sendSurface_native();

    protected native void startSurface_native();

    protected native void stopSurface_native();

    protected native void setVertex_native(int var1, float var2, float var3, float var4);

    protected native void setNormal_native(int var1, float var2, float var3, float var4);

    protected native void setTriangle_native(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected native void removeTriangle_native(int var1);

    protected native void updateTrimeshChanges_native();

    protected native void setTrimeshTransform_native(float[] var1);

    protected native void clearTrimesh_native();

    protected native void useHcollide_native();

    protected native void useGhost_native();

    protected native boolean enableConstraint_native(int var1);

    protected native boolean setConstraintMode_native(int var1);

    protected native boolean setConstraintPoint_native(float[] var1);

    protected native boolean setConstraintLinePoint_native(float[] var1);

    protected native boolean setConstraintLineDirection_native(float[] var1);

    protected native boolean setConstraintPlanePoint_native(float[] var1);

    protected native boolean setConstraintPlaneNormal_native(float[] var1);

    protected native boolean setConstraintKSpring_native(float var1);

    protected native boolean sendForceField_native(float[] var1, float[] var2, float[][] var3, float var4);

    protected native boolean sendForceField_native();

    protected native boolean stopForceField_native();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stoppedRunning() {
        this.forceListeners.removeAllElements();
        this.scpListeners.removeAllElements();
        this.errorListeners.removeAllElements();
        Object object = downInVrpnLock;
        synchronized (object) {
            this.shutdownForceDevice();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleForceChange(long l, long l2, double d, double d2, double d3) {
        Object object = notifyingForceListenersLock;
        synchronized (object) {
            ForceChange forceChange = new ForceChange(this);
            forceChange.msg_time.setTime(l * 1000L + (long)((int)((double)l2 / 1000.0)));
            forceChange.force[0] = d;
            forceChange.force[1] = d2;
            forceChange.force[2] = d3;
            Enumeration enumeration = this.forceListeners.elements();
            while (enumeration.hasMoreElements()) {
                ForceChangeListener forceChangeListener = (ForceChangeListener)enumeration.nextElement();
                forceChangeListener.forceUpdate(forceChange, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSCPChange(long l, long l2, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        Object object = notifyingSCPListenersLock;
        synchronized (object) {
            SCPChange sCPChange = new SCPChange(this);
            sCPChange.msg_time.setTime(l * 1000L + (long)((int)((double)l2 / 1000.0)));
            sCPChange.pos[0] = d;
            sCPChange.pos[1] = d2;
            sCPChange.pos[2] = d3;
            sCPChange.quat[0] = d4;
            sCPChange.quat[1] = d5;
            sCPChange.quat[2] = d6;
            sCPChange.quat[3] = d7;
            Enumeration enumeration = this.scpListeners.elements();
            while (enumeration.hasMoreElements()) {
                SCPChangeListener sCPChangeListener = (SCPChangeListener)enumeration.nextElement();
                sCPChangeListener.scpUpdate(sCPChange, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleForceError(long l, long l2, int n) {
        Object object = notifyingErrorListenersLock;
        synchronized (object) {
            ForceError forceError = new ForceError(this);
            forceError.msg_time.setTime(l * 1000L + (long)((int)((double)l2 / 1000.0)));
            forceError.errorCode = n;
            Enumeration enumeration = this.errorListeners.elements();
            while (enumeration.hasMoreElements()) {
                ForceErrorListener forceErrorListener = (ForceErrorListener)enumeration.nextElement();
                forceErrorListener.forceError(forceError, this);
            }
        }
    }

    protected native boolean init(String var1, String var2, String var3, String var4, String var5);

    protected native void shutdownForceDevice();

    protected native void mainloop();
}

