/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.util.StringUtils;
import java.util.regex.Pattern;

public class EnglishPatterns {
    public static final String[] copularVerbs = new String[]{"be", "being", "been", "am", "are", "r", "is", "ai", "was", "were", "'m", "\u2019m", "m", "'re", "\u2019re", "'s", "\u2019s", "s", "`s", "art", "ar", "wase"};
    public static final String[] beGetVerbs = new String[]{"be", "being", "been", "am", "are", "r", "is", "ai", "was", "were", "'m", "\u2019m", "m", "'re", "\u2019re", "'s", "\u2019s", "s", "`s", "art", "ar", "wase", "get", "getting", "gets", "got", "gotten"};
    public static final String[] auxiliaries = new String[]{"will", "wo", "shall", "sha", "may", "might", "should", "would", "can", "could", "ca", "must", "'ll", "\u2019ll", "ll", "-ll", "cold", "has", "have", "had", "having", "'ve", "\u2019ve", "ve", "v", "of", "hav", "hvae", "as", "get", "gets", "getting", "got", "gotten", "do", "does", "did", "'d", "\u2019d", "d", "du", "to", "2", "na", "a", "ot", "ta", "the", "too"};
    public static final String timeWordRegex = "/^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/";
    public static final String timeWordLotRegex = "/^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter|lot)$/";
    public static final String copularWordRegex = "/^(?i:" + StringUtils.join(copularVerbs, "|") + ")$/";
    public static final String clausalComplementRegex = "/^(?i:seem|seems|seemed|seeming|resemble|resembles|resembled|resembling|become|becomes|became|becoming|remain|remains|remained|remaining)$/";
    public static final String passiveAuxWordRegex = "/^(?i:" + StringUtils.join(beGetVerbs, "|") + ")$/";
    public static final String beAuxiliaryRegex = "/^(?i:am|is|are|r|be|being|'s|\u2019s|'re|\u2019re|'m|\u2019m|was|were|been|s|ai|m|art|ar|wase)$/";
    public static final String haveRegex = "/^(?i:have|had|has|having|'ve|\u2019ve|ve|v|'d|\u2019d|d|hvae|hav|as)$/";
    public static final String selfRegex = "/^(?i:myself|yourself|himself|herself|itself|ourselves|yourselves|themselves)$/";
    public static final String xcompVerbRegex = "/^(?i:(?:allow|ask|demand|expect|help|order|prompt)(?:s|ed|ing)?|(?:advis|convinc|declar|defin|desir|encourag|forc|implor|nam|persuad|pressur|requir|urg)(?:e|es|ed|ing)|beg|begs|begged|begging|compel|compels|compelled|compelling|lobby|lobbies|lobbied|lobbying|permit|permits|permitted|permitting|tell|tells|told|telling)$/";
    public static final String xcompNoObjVerbRegex = "/^(?i:advis|afford|allow|am$|appear|are$|ask|attempt|avoid|be$|bec[oa]m|beg[ia]n|believ|call|caus[ei]|ceas[ei]|choos[ei]|chose|claim|consider|continu|convinc|decid|decline|end|enjoy|expect|feel|felt|find|forb[ia]d|forc[ei]|forg[eo]t|found|going|gon|g[eo]t|happen|hat[ei]|ha[vds]|help|hesitat|hop[ei]|intend|instruct|invit|['\u2019i]s$|keep|kept|learn|leav[ei]|left|let|lik[ei]|look|lov[ei]|made|mak[ei]|manag|nam[ei]|need|offer|order|plan|pretend|proceed|promis|prov[ei]|rate|recommend|refus|regret|remember|requir|sa[iy]|seem|sound|start|stop|suggest|suppos|tell|tend|threaten|told|tr[yi]|turn|used|wan|was$|willing|wish)/";
    public static final String ccompVerbRegex = "/^(?i:ask|asks|asked|asking|know|knows|knew|knowing|specify|specifies|specified|specifying|tell|tells|told|telling|understand|understands|understood|understanding|wonder|wonders|wondered|wondering)$/";
    public static final String ccompObjVerbRegex = "/^(?i:tell|tells|told|telling)$/";
    public static final String sayVerbRegex = "/^(?i:say|says|said|saying|(?:add|boast|counsel|explain|inform|interject|recall|remark|respond|proclaim|report|claim|shout|whisper|yell)(?:s|ed|ing)?|(?:advis|announc|acknowledg|conced|conclud|decid|declar|observ|stat|not|inton)(?:e|es|ed|ing)|(?:confess)(?:es|ed|ing)?|(?:agree)(?:s|d|ing)?|reply|replied|replies|replying|admit|admits|admitted|admitting|hold|holds|holding|held|write|writes|writing|wrote|tell|tells|telling|told|quipped|quip|quips|quipping|think|thinks|thinking|thought)$/";
    public static final String RELATIVIZING_WORD_REGEX = "(?i:that|what|which|who|whom|whose)";
    public static final Pattern RELATIVIZING_WORD_PATTERN = Pattern.compile("(?i:that|what|which|who|whom|whose)");
    public static final String NP_V_S_INF_VERBS_REGEX = "(?i:acquiesce|submit|bow|defer|accede|succumb|yield|capitulate|despise|disdain|dislike|regret|like|love|enjoy|fear|hate|pledge|proceed|begin|start|commence|recommence|resume|undertake|ally|collaborate|collude|conspire|discriminate|legislate|partner|protest|rebel|retaliate|scheme|sin|befriend|continue|broadcast|cable|e-mail|fax|modem|netmail|phone|radio|relay|satellite|semaphore|sign|signal|telecast|telegraph|telephone|telex|wire|wireless|ache|crave|fall|hanker|hope|hunger|itch|long|lust|pine|pray|thirst|wish|yearn|dangle|hanker|lust|thirst|yearn|babble|bark|bawl|bellow|bleat|blubber|boom|bray|burble|bluster|cackle|call|carol|chant|chatter|chirp|chortle|chuckle|cluck|coo|croak|croon|crow|cry|drawl|drone|gabble|gasp|gibber|groan|growl|grumble|grunt|hiss|holler|hoot|howl|jabber|keen|lilt|lisp|mewl|moan|mumble|murmur|mutter|nasal|natter|pant|prattle|purr|quaver|rage|rant|rasp|roar|rumble|scream|screech|shout|shriek|sibilate|simper|sigh|sing|smatter|smile|snap|snarl|snivel|snuffle|splutter|squall|squawk|squeak|squeal|stammer|stemmer|stutter|thunder|tisk|trill|trumpet|twang|twitter|vociferate|wail|warble|wheeze|whimper|whine|whisper|whistle|witter|whoop|yammer|yap|yell|yelp|yodel|blare|gurgle|hum|neglect|fail|forego|forgo|flub|overleap|manage|omit|seem|appear|prove|manage|fail|flub|try|attempt|intend|enjoy|expect|wish|hope|intend|mean|plan|propose|think|aim|dream|imagine|yen)";
    public static final String NOT_PAT_WORD = "^(?i:n[o'\u2019]?t|never)$";
    public static final String NOT_PAT = "/^(?i:n[o'\u2019]?t|never)$/";
    public static final String ETC_PAT = "(FW < /^(?i:(etc|ect))$/)";
    public static final String ETC_PAT_target = "(FW=target < /^(?i:(etc|ect))$/)";
    public static final String FW_ETC_PAT = "(ADVP|NP <1 (FW < /^(?i:(etc|ect))$/))";
    public static final String FW_ETC_PAT_target = "(ADVP|NP=target <1 (FW < /^(?i:(etc|ect))$/))";
    public static final String WESTERN_SMILEY = "/^(?:[<>]?[:;=8][\\-o\\*'\u2019]?(?:-RRB-|-LRB-|[()DPdpO\\/\\\\\\:}{@\\|\\[\\]])|(?:-RRB-|-LRB-|[()DPdpO\\/\\\\\\:}{@\\|\\[\\]])[\\-o\\*'\u2019]?[:;=8][<>]?)$/";
    public static final String ASIAN_SMILEY = "/(?!^--$)^(?:-LRB-|[(])?[\\-\\^x=~<>'\u2019][_.]?[\\-\\^x=~<>'\u2019](?:-RRB-|[)])?$/";

    private EnglishPatterns() {
    }
}

