/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.Rule;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;

public class BinaryRule
implements Rule,
Comparable<BinaryRule>,
Serializable {
    public int parent;
    public float score;
    public int leftChild;
    public int rightChild;
    private int hashCode = -1;
    private static final char[] charsToEscape = new char[]{'\"'};
    private transient String cached;
    private static final long serialVersionUID = 1L;

    public BinaryRule(int parent, int leftChild, int rightChild) {
        this.parent = parent;
        this.leftChild = leftChild;
        this.rightChild = rightChild;
        this.score = Float.NaN;
    }

    public BinaryRule(int parent, int leftChild, int rightChild, double score) {
        this.parent = parent;
        this.leftChild = leftChild;
        this.rightChild = rightChild;
        this.score = (float)score;
    }

    public BinaryRule(String s, Index<String> index) {
        String[] fields = StringUtils.splitOnCharWithQuoting(s, ' ', '\"', '\\');
        this.parent = index.addToIndex(fields[0]);
        this.leftChild = index.addToIndex(fields[2]);
        this.rightChild = index.addToIndex(fields[3]);
        this.score = Float.parseFloat(fields[4]);
    }

    @Override
    public float score() {
        return this.score;
    }

    @Override
    public int parent() {
        return this.parent;
    }

    public int hashCode() {
        if (this.hashCode < 0) {
            this.hashCode = this.parent << 16 ^ this.leftChild << 8 ^ this.rightChild;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BinaryRule) {
            BinaryRule br = (BinaryRule)o;
            if (this.parent == br.parent && this.leftChild == br.leftChild && this.rightChild == br.rightChild) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.parent + " -> " + this.leftChild + ' ' + this.rightChild + ' ' + this.score;
    }

    public String toString(Index<String> index) {
        return '\"' + StringUtils.escapeString(index.get(this.parent), charsToEscape, '\\') + "\" -> \"" + StringUtils.escapeString(index.get(this.leftChild), charsToEscape, '\\') + "\" \"" + StringUtils.escapeString(index.get(this.rightChild), charsToEscape, '\\') + "\" " + this.score;
    }

    public String toStringNoScore(Index<String> index) {
        if (this.cached == null) {
            this.cached = '\"' + StringUtils.escapeString(index.get(this.parent), charsToEscape, '\\') + "\" -> \"" + StringUtils.escapeString(index.get(this.leftChild), charsToEscape, '\\') + "\" \"" + StringUtils.escapeString(index.get(this.rightChild), charsToEscape, '\\');
        }
        return this.cached;
    }

    @Override
    public int compareTo(BinaryRule br) {
        if (this.parent < br.parent) {
            return -1;
        }
        if (this.parent > br.parent) {
            return 1;
        }
        if (this.leftChild < br.leftChild) {
            return -1;
        }
        if (this.leftChild > br.leftChild) {
            return 1;
        }
        if (this.rightChild < br.rightChild) {
            return -1;
        }
        if (this.rightChild > br.rightChild) {
            return 1;
        }
        return 0;
    }
}

