/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.dvparser;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.parser.dvparser.DVModel;
import edu.stanford.nlp.parser.dvparser.DVParserCostAndGradient;
import edu.stanford.nlp.parser.dvparser.UnknownWordPrinter;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.Reranker;
import edu.stanford.nlp.parser.lexparser.RerankerQuery;
import edu.stanford.nlp.parser.metrics.Eval;
import edu.stanford.nlp.trees.DeepTree;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.util.Generics;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.ejml.simple.SimpleMatrix;

public class DVModelReranker
implements Reranker {
    private final Options op;
    private final DVModel model;
    private static final long serialVersionUID = 7897546308624261207L;

    public DVModelReranker(DVModel model) {
        this.op = model.op;
        this.model = model;
    }

    public DVModel getModel() {
        return this.model;
    }

    @Override
    public Query process(List<? extends HasWord> sentence) {
        return new Query();
    }

    @Override
    public List<Eval> getEvals() {
        UnknownWordPrinter eval = new UnknownWordPrinter(this.model);
        return Collections.singletonList(eval);
    }

    public class Query
    implements RerankerQuery {
        private final TreeTransformer transformer;
        private final DVParserCostAndGradient scorer;
        private List<DeepTree> deepTrees;

        public Query() {
            this.transformer = LexicalizedParser.buildTrainTransformer(DVModelReranker.this.op);
            this.scorer = new DVParserCostAndGradient(null, null, DVModelReranker.this.model, DVModelReranker.this.op);
            this.deepTrees = Generics.newArrayList();
        }

        @Override
        public double score(Tree tree) {
            IdentityHashMap<Tree, SimpleMatrix> nodeVectors = Generics.newIdentityHashMap();
            Tree transformedTree = this.transformer.transformTree(tree);
            if (((DVModelReranker)DVModelReranker.this).op.trainOptions.useContextWords) {
                Trees.convertToCoreLabels(transformedTree);
                transformedTree.setSpans();
            }
            double score = this.scorer.score(transformedTree, nodeVectors);
            this.deepTrees.add(new DeepTree(tree, nodeVectors, score));
            return score;
        }

        public List<DeepTree> getDeepTrees() {
            return this.deepTrees;
        }
    }
}

