/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.common;

import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Trees;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ParserUtils {
    private ParserUtils() {
    }

    public static Tree xTree(List<? extends HasWord> words) {
        LabeledScoredTreeFactory treeFactory = new LabeledScoredTreeFactory();
        ArrayList<Tree> lst2 = new ArrayList<Tree>();
        for (HasWord hasWord : words) {
            String s = hasWord.word();
            Tree t = treeFactory.newLeaf(s);
            String tag = "XX";
            if (hasWord instanceof HasTag && ((HasTag)((Object)hasWord)).tag() != null) {
                tag = ((HasTag)((Object)hasWord)).tag();
            }
            Tree t2 = treeFactory.newTreeNode(tag, Collections.singletonList(t));
            lst2.add(t2);
        }
        return treeFactory.newTreeNode("X", lst2);
    }

    public static List<Tree> flattenTallTrees(int maxHeight, List<Tree> trees) {
        if (maxHeight <= 0) {
            return trees;
        }
        return trees.stream().map(tree -> Trees.height(tree) > maxHeight ? ParserUtils.xTree(tree.taggedYield()) : tree).collect(Collectors.toList());
    }

    public static void printOutOfMemory(PrintWriter pw) {
        pw.println();
        pw.println("*******************************************************");
        pw.println("***  WARNING!! OUT OF MEMORY! THERE WAS NOT ENOUGH  ***");
        pw.println("***  MEMORY TO RUN ALL PARSERS.  EITHER GIVE THE    ***");
        pw.println("***  JVM MORE MEMORY, SET THE MAXIMUM SENTENCE      ***");
        pw.println("***  LENGTH WITH -maxLength, OR PERHAPS YOU ARE     ***");
        pw.println("***  HAPPY TO HAVE THE PARSER FALL BACK TO USING    ***");
        pw.println("***  A SIMPLER PARSER FOR VERY LONG SENTENCES.      ***");
        pw.println("*******************************************************");
        pw.println();
    }
}

