
(* The type of tokens. *)

type token = 
  | WHILE
  | VOID
  | VECTOR
  | UPPER
  | UNREACHABLE
  | UNITVECTOR
  | TUPLE
  | TRUNCATE
  | TRANSPOSE
  | TRANSFORMEDPARAMETERSBLOCK
  | TRANSFORMEDDATABLOCK
  | TIMESASSIGN
  | TIMES
  | TILDE
  | TARGET
  | STRINGLITERAL of (string)
  | SIMPLEX
  | SEMICOLON
  | RPAREN
  | ROWVECTOR
  | RETURN
  | REJECT
  | REALNUMERAL of (string)
  | REAL
  | RBRACK
  | RBRACE
  | RABRACK
  | QMARK
  | PROFILE
  | PRINT
  | POSITIVEORDERED
  | PLUSASSIGN
  | PLUS
  | PARAMETERSBLOCK
  | ORDERED
  | OR
  | OFFSET
  | NEQUALS
  | MULTIPLIER
  | MODULO
  | MODELBLOCK
  | MINUSASSIGN
  | MINUS
  | MATRIX
  | LPAREN
  | LOWER
  | LEQ
  | LDIVIDE
  | LBRACK
  | LBRACE
  | LABRACK
  | JACOBIAN
  | INTNUMERAL of (string)
  | INT
  | IN
  | IMAGNUMERAL of (string)
  | IF
  | IDIVIDE
  | IDENTIFIER of (string)
  | HAT
  | GEQ
  | GENERATEDQUANTITIESBLOCK
  | FUNCTIONBLOCK
  | FOR
  | FATAL_ERROR
  | EQUALS
  | EOF
  | ELTTIMESASSIGN
  | ELTTIMES
  | ELTPOW
  | ELTDIVIDEASSIGN
  | ELTDIVIDE
  | ELSE
  | DOTNUMERAL of (string)
  | DIVIDEASSIGN
  | DIVIDE
  | DATABLOCK
  | COVMATRIX
  | CORRMATRIX
  | CONTINUE
  | COMPLEXVECTOR
  | COMPLEXROWVECTOR
  | COMPLEXMATRIX
  | COMPLEX
  | COMMA
  | COLON
  | CHOLESKYFACTORCOV
  | CHOLESKYFACTORCORR
  | BREAK
  | BAR
  | BANG
  | ASSIGN
  | ARRAY
  | AND

(* This exception is raised by the monolithic API functions. *)

exception Error

(* The monolithic API. *)

val program: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.program)

val functions_only: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Ast.untyped_statement Ast.program)

module MenhirInterpreter : sig
  
  (* The incremental API. *)
  
  include MenhirLib.IncrementalEngine.INCREMENTAL_ENGINE
    with type token = token
  
end

(* The entry point(s) to the incremental API. *)

module Incremental : sig
  
  val program: Lexing.position -> ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.program) MenhirInterpreter.checkpoint
  
  val functions_only: Lexing.position -> (Ast.untyped_statement Ast.program) MenhirInterpreter.checkpoint
  
end
