/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.RequestScope;
import org.springframework.web.context.request.SessionScope;
import org.springframework.web.portlet.context.PortletRequestAttributes;

public abstract class PortletApplicationContextUtils {
    public static ApplicationContext getWebApplicationContext(PortletContext pc) {
        Assert.notNull((Object)pc, (String)"PortletContext must not be null");
        Object attr = pc.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (attr == null) {
            return null;
        }
        if (attr instanceof RuntimeException) {
            throw (RuntimeException)attr;
        }
        if (attr instanceof Error) {
            throw (Error)attr;
        }
        if (!(attr instanceof ApplicationContext)) {
            throw new IllegalStateException("Root context attribute is not of type WebApplicationContext: " + attr);
        }
        return (ApplicationContext)attr;
    }

    public static ApplicationContext getRequiredWebApplicationContext(PortletContext pc) throws IllegalStateException {
        ApplicationContext wac = PortletApplicationContextUtils.getWebApplicationContext(pc);
        if (wac == null) {
            throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener registered?");
        }
        return wac;
    }

    static void registerPortletApplicationScopes(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.registerScope("request", (Scope)new RequestScope());
        beanFactory.registerScope("session", (Scope)new SessionScope(false));
        beanFactory.registerScope("globalSession", (Scope)new SessionScope(true));
        beanFactory.registerResolvableDependency(PortletRequest.class, (Object)new ObjectFactory(){

            public Object getObject() {
                RequestAttributes requestAttr = RequestContextHolder.currentRequestAttributes();
                if (!(requestAttr instanceof PortletRequestAttributes)) {
                    throw new IllegalStateException("Current request is not a portlet request");
                }
                return ((PortletRequestAttributes)requestAttr).getRequest();
            }
        });
        beanFactory.registerResolvableDependency(PortletSession.class, (Object)new ObjectFactory(){

            public Object getObject() {
                RequestAttributes requestAttr = RequestContextHolder.currentRequestAttributes();
                if (!(requestAttr instanceof PortletRequestAttributes)) {
                    throw new IllegalStateException("Current request is not a portlet request");
                }
                return ((PortletRequestAttributes)requestAttr).getRequest().getPortletSession();
            }
        });
    }
}

