/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SourceFilteringListener;
import org.springframework.web.portlet.GenericPortletBean;
import org.springframework.web.portlet.context.ConfigurablePortletApplicationContext;
import org.springframework.web.portlet.context.PortletApplicationContextUtils;
import org.springframework.web.portlet.context.PortletRequestHandledEvent;
import org.springframework.web.portlet.context.XmlPortletApplicationContext;

public abstract class FrameworkPortlet
extends GenericPortletBean
implements ApplicationListener {
    public static final Class DEFAULT_CONTEXT_CLASS = XmlPortletApplicationContext.class;
    public static final String DEFAULT_NAMESPACE_SUFFIX = "-portlet";
    public static final String PORTLET_CONTEXT_PREFIX = FrameworkPortlet.class.getName() + ".CONTEXT.";
    public static final String[] DEFAULT_USERINFO_ATTRIBUTE_NAMES = new String[]{"user.login.id", "user.name"};
    private Class contextClass = DEFAULT_CONTEXT_CLASS;
    private String namespace;
    private String contextConfigLocation;
    private boolean publishContext = true;
    private boolean publishEvents = true;
    private String[] userinfoUsernameAttributes = DEFAULT_USERINFO_ATTRIBUTE_NAMES;
    private ApplicationContext portletApplicationContext;
    private boolean refreshEventReceived = false;

    public void setContextClass(Class contextClass) {
        this.contextClass = contextClass;
    }

    public Class getContextClass() {
        return this.contextClass;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace != null ? this.namespace : this.getPortletName() + DEFAULT_NAMESPACE_SUFFIX;
    }

    public void setContextConfigLocation(String contextConfigLocation) {
        this.contextConfigLocation = contextConfigLocation;
    }

    public String getContextConfigLocation() {
        return this.contextConfigLocation;
    }

    public void setPublishContext(boolean publishContext) {
        this.publishContext = publishContext;
    }

    public boolean isPublishContext() {
        return this.publishContext;
    }

    public void setPublishEvents(boolean publishEvents) {
        this.publishEvents = publishEvents;
    }

    public boolean isPublishEvents() {
        return this.publishEvents;
    }

    public void setUserinfoUsernameAttributes(String[] userinfoUsernameAttributes) {
        this.userinfoUsernameAttributes = userinfoUsernameAttributes;
    }

    public String[] getUserinfoUsernameAttributes() {
        return this.userinfoUsernameAttributes;
    }

    protected final void initPortletBean() throws PortletException, BeansException {
        this.getPortletContext().log("Initializing Spring FrameworkPortlet '" + this.getPortletName() + "'");
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("FrameworkPortlet '" + this.getPortletName() + "': initialization started"));
        }
        long startTime = System.currentTimeMillis();
        try {
            this.portletApplicationContext = this.initPortletApplicationContext();
            this.initFrameworkPortlet();
        }
        catch (PortletException ex) {
            this.logger.error((Object)"Context initialization failed", (Throwable)ex);
            throw ex;
        }
        catch (BeansException ex) {
            this.logger.error((Object)"Context initialization failed", (Throwable)ex);
            throw ex;
        }
        if (this.logger.isInfoEnabled()) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            this.logger.info((Object)("FrameworkPortlet '" + this.getPortletName() + "': initialization completed in " + elapsedTime + " ms"));
        }
    }

    protected ApplicationContext initPortletApplicationContext() throws BeansException {
        ApplicationContext parent = PortletApplicationContextUtils.getWebApplicationContext(this.getPortletContext());
        ApplicationContext pac = this.createPortletApplicationContext(parent);
        if (!this.refreshEventReceived) {
            this.onRefresh(pac);
        }
        if (this.isPublishContext()) {
            String attName = this.getPortletContextAttributeName();
            this.getPortletContext().setAttribute(attName, (Object)pac);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Published ApplicationContext of portlet '" + this.getPortletName() + "' as PortletContext attribute with name [" + attName + "]"));
            }
        }
        return pac;
    }

    protected ApplicationContext createPortletApplicationContext(ApplicationContext parent) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Portlet with name '" + this.getPortletName() + "' will try to create custom ApplicationContext context of class '" + this.getContextClass().getName() + "'" + ", using parent context [" + parent + "]"));
        }
        if (!ConfigurablePortletApplicationContext.class.isAssignableFrom(this.getContextClass())) {
            throw new ApplicationContextException("Fatal initialization error in portlet with name '" + this.getPortletName() + "': custom ApplicationContext class [" + this.getContextClass().getName() + "] is not of type ConfigurablePortletApplicationContext");
        }
        ConfigurablePortletApplicationContext pac = (ConfigurablePortletApplicationContext)BeanUtils.instantiateClass((Class)this.getContextClass());
        pac.setParent(parent);
        pac.setPortletContext(this.getPortletContext());
        pac.setPortletConfig(this.getPortletConfig());
        pac.setNamespace(this.getNamespace());
        pac.setConfigLocation(this.getContextConfigLocation());
        pac.addApplicationListener((ApplicationListener)new SourceFilteringListener((Object)pac, (ApplicationListener)this));
        this.postProcessPortletApplicationContext(pac);
        pac.refresh();
        return pac;
    }

    protected void postProcessPortletApplicationContext(ConfigurableApplicationContext pac) {
    }

    public String getPortletContextAttributeName() {
        return PORTLET_CONTEXT_PREFIX + this.getPortletName();
    }

    public final ApplicationContext getPortletApplicationContext() {
        return this.portletApplicationContext;
    }

    protected void initFrameworkPortlet() throws PortletException, BeansException {
    }

    public void refresh() throws BeansException {
        ApplicationContext pac = this.getPortletApplicationContext();
        if (!(pac instanceof ConfigurableApplicationContext)) {
            throw new IllegalStateException("Portlet ApplicationContext does not support refresh: " + pac);
        }
        ((ConfigurableApplicationContext)pac).refresh();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.refreshEventReceived = true;
            this.onRefresh(((ContextRefreshedEvent)event).getApplicationContext());
        }
    }

    protected void onRefresh(ApplicationContext context) throws BeansException {
    }

    protected String getTitle(RenderRequest renderRequest) {
        try {
            return super.getTitle(renderRequest);
        }
        catch (NullPointerException ex) {
            return this.getPortletName();
        }
    }

    protected final void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response);
    }

    public final void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void processRequest(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        Throwable failureCause;
        long startTime;
        block14: {
            block12: {
                startTime = System.currentTimeMillis();
                failureCause = null;
                try {
                    try {
                        if (request instanceof ActionRequest) {
                            this.doActionService((ActionRequest)request, (ActionResponse)response);
                        } else {
                            this.doRenderService((RenderRequest)request, (RenderResponse)response);
                        }
                    }
                    catch (PortletException ex) {
                        failureCause = ex;
                        throw ex;
                    }
                    catch (IOException ex) {
                        failureCause = ex;
                        throw ex;
                    }
                    catch (Throwable ex) {
                        failureCause = ex;
                        throw new PortletException("Request processing failed", ex);
                    }
                    Object var8_5 = null;
                    if (failureCause == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    if (failureCause != null) {
                        this.logger.error((Object)"Could not complete request", failureCause);
                    } else {
                        this.logger.debug((Object)"Successfully completed request");
                    }
                    if (!this.isPublishEvents()) throw throwable;
                    long processingTime = System.currentTimeMillis() - startTime;
                    this.portletApplicationContext.publishEvent((ApplicationEvent)new PortletRequestHandledEvent((Object)this, this.getPortletConfig().getPortletName(), request.getPortletMode().toString(), request instanceof ActionRequest ? "action" : "render", request.getRequestedSessionId(), this.getUsernameForRequest(request), processingTime, failureCause));
                    throw throwable;
                }
                this.logger.error((Object)"Could not complete request", failureCause);
                break block14;
            }
            this.logger.debug((Object)"Successfully completed request");
        }
        if (!this.isPublishEvents()) return;
        long processingTime = System.currentTimeMillis() - startTime;
        this.portletApplicationContext.publishEvent((ApplicationEvent)new PortletRequestHandledEvent((Object)this, this.getPortletConfig().getPortletName(), request.getPortletMode().toString(), request instanceof ActionRequest ? "action" : "render", request.getRequestedSessionId(), this.getUsernameForRequest(request), processingTime, failureCause));
    }

    protected String getUsernameForRequest(PortletRequest request) {
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal != null) {
            return userPrincipal.getName();
        }
        String userName = request.getRemoteUser();
        if (userName != null) {
            return userName;
        }
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        if (userInfo != null) {
            int n = this.userinfoUsernameAttributes.length;
            for (int i = 0; i < n; ++i) {
                userName = (String)userInfo.get(this.userinfoUsernameAttributes[i]);
                if (userName == null) continue;
                return userName;
            }
        }
        return null;
    }

    protected abstract void doRenderService(RenderRequest var1, RenderResponse var2) throws Exception;

    protected abstract void doActionService(ActionRequest var1, ActionResponse var2) throws Exception;

    public void destroy() {
        this.getPortletContext().log("Destroying Spring FrameworkPortlet '" + this.getPortletName() + "'");
        if (this.portletApplicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.portletApplicationContext).close();
        }
    }
}

