/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.support;

import java.beans.PropertyDescriptor;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.DynamicMBean;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MXBean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.JdkVersion;
import org.springframework.jmx.MBeanServerNotFoundException;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class JmxUtils {
    public static final String IDENTITY_OBJECT_NAME_KEY = "identity";
    private static final String MBEAN_SUFFIX = "MBean";
    private static final String MXBEAN_SUFFIX = "MXBean";
    private static final String MXBEAN_ANNOTATION_CLASS_NAME = "javax.management.MXBean";
    private static final boolean mxBeanAnnotationAvailable = ClassUtils.isPresent("javax.management.MXBean", JmxUtils.class.getClassLoader());
    private static final Log logger = LogFactory.getLog((Class)JmxUtils.class);
    static /* synthetic */ Class class$javax$management$MXBean;

    public static MBeanServer locateMBeanServer() throws MBeanServerNotFoundException {
        return JmxUtils.locateMBeanServer(null);
    }

    public static MBeanServer locateMBeanServer(String agentId) throws MBeanServerNotFoundException {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(agentId);
        MBeanServer server = null;
        if (servers != null && servers.size() > 0) {
            if (servers.size() > 1 && logger.isWarnEnabled()) {
                logger.warn((Object)("Found more than one MBeanServer instance" + (agentId != null ? " with agent id [" + agentId + "]" : "") + ". Returning first from list."));
            }
            server = (MBeanServer)servers.get(0);
        }
        if (server == null && agentId == null && JdkVersion.isAtLeastJava15()) {
            try {
                server = ManagementFactory.getPlatformMBeanServer();
            }
            catch (SecurityException ex) {
                throw new MBeanServerNotFoundException("No specific MBeanServer found, and not allowed to obtain the Java platform MBeanServer", ex);
            }
        }
        if (server == null) {
            throw new MBeanServerNotFoundException("Unable to locate an MBeanServer instance" + (agentId != null ? " with agent id [" + agentId + "]" : ""));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found MBeanServer: " + server));
        }
        return server;
    }

    public static Class[] parameterInfoToTypes(MBeanParameterInfo[] paramInfo) throws ClassNotFoundException {
        return JmxUtils.parameterInfoToTypes(paramInfo, ClassUtils.getDefaultClassLoader());
    }

    public static Class[] parameterInfoToTypes(MBeanParameterInfo[] paramInfo, ClassLoader classLoader) throws ClassNotFoundException {
        Class[] types = null;
        if (paramInfo != null && paramInfo.length > 0) {
            types = new Class[paramInfo.length];
            for (int x = 0; x < paramInfo.length; ++x) {
                types[x] = ClassUtils.forName(paramInfo[x].getType(), classLoader);
            }
        }
        return types;
    }

    public static String[] getMethodSignature(Method method) {
        Class<?>[] types = method.getParameterTypes();
        String[] signature = new String[types.length];
        for (int x = 0; x < types.length; ++x) {
            signature[x] = types[x].getName();
        }
        return signature;
    }

    public static String getAttributeName(PropertyDescriptor property, boolean useStrictCasing) {
        if (useStrictCasing) {
            return StringUtils.capitalize(property.getName());
        }
        return property.getName();
    }

    public static ObjectName appendIdentityToObjectName(ObjectName objectName, Object managedResource) throws MalformedObjectNameException {
        Hashtable<String, String> keyProperties = objectName.getKeyPropertyList();
        keyProperties.put(IDENTITY_OBJECT_NAME_KEY, ObjectUtils.getIdentityHexString(managedResource));
        return ObjectNameManager.getInstance(objectName.getDomain(), keyProperties);
    }

    public static Class getClassToExpose(Object managedBean) {
        return ClassUtils.getUserClass(managedBean);
    }

    public static Class getClassToExpose(Class beanClass) {
        return ClassUtils.getUserClass(beanClass);
    }

    public static boolean isMBean(Class beanClass) {
        return beanClass != null && (DynamicMBean.class.isAssignableFrom(beanClass) || JmxUtils.getMBeanInterface(beanClass) != null || JmxUtils.getMXBeanInterface(beanClass) != null);
    }

    public static Class getMBeanInterface(Class clazz) {
        if (clazz.getSuperclass() == null) {
            return null;
        }
        String mbeanInterfaceName = clazz.getName() + MBEAN_SUFFIX;
        Class<?>[] implementedInterfaces = clazz.getInterfaces();
        for (int x = 0; x < implementedInterfaces.length; ++x) {
            Class<?> iface = implementedInterfaces[x];
            if (!iface.getName().equals(mbeanInterfaceName)) continue;
            return iface;
        }
        return JmxUtils.getMBeanInterface(clazz.getSuperclass());
    }

    public static Class getMXBeanInterface(Class clazz) {
        if (clazz.getSuperclass() == null) {
            return null;
        }
        Class<?>[] implementedInterfaces = clazz.getInterfaces();
        for (int x = 0; x < implementedInterfaces.length; ++x) {
            Boolean checkResult;
            Class<?> iface = implementedInterfaces[x];
            boolean isMxBean = iface.getName().endsWith(MXBEAN_SUFFIX);
            if (mxBeanAnnotationAvailable && (checkResult = MXBeanChecker.hasMXBeanAnnotation(iface)) != null) {
                isMxBean = checkResult;
            }
            if (!isMxBean) continue;
            return iface;
        }
        return JmxUtils.getMXBeanInterface(clazz.getSuperclass());
    }

    private static class MXBeanChecker {
        private MXBeanChecker() {
        }

        public static Boolean hasMXBeanAnnotation(Class iface) {
            MXBean mxBean = (MXBean)iface.getAnnotation(class$javax$management$MXBean == null ? (class$javax$management$MXBean = JmxUtils.class$(JmxUtils.MXBEAN_ANNOTATION_CLASS_NAME)) : class$javax$management$MXBean);
            if (mxBean != null) {
                return mxBean.value();
            }
            return null;
        }
    }
}

