/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.ui.freemarker.FreeMarkerConfigurationFactory;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;

public class FreeMarkerConfigurer
extends FreeMarkerConfigurationFactory
implements FreeMarkerConfig,
InitializingBean,
ResourceLoaderAware,
ServletContextAware {
    private Configuration configuration;
    private TaglibFactory taglibFactory;

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setServletContext(ServletContext servletContext) {
        this.taglibFactory = new TaglibFactory(servletContext);
    }

    public void afterPropertiesSet() throws IOException, TemplateException {
        if (this.configuration == null) {
            this.configuration = this.createConfiguration();
        }
    }

    protected void postProcessTemplateLoaders(List templateLoaders) {
        templateLoaders.add(new ClassTemplateLoader(FreeMarkerConfigurer.class, ""));
        this.logger.info((Object)"ClassTemplateLoader for Spring macros added to FreeMarker configuration");
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public TaglibFactory getTaglibFactory() {
        return this.taglibFactory;
    }
}

