/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

public abstract class AbstractSessionFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean,
PersistenceExceptionTranslator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private DataSource dataSource;
    private boolean useTransactionAwareDataSource = false;
    private boolean exposeTransactionAwareSessionFactory = true;
    private SQLExceptionTranslator jdbcExceptionTranslator;
    private SessionFactory sessionFactory;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setUseTransactionAwareDataSource(boolean useTransactionAwareDataSource) {
        this.useTransactionAwareDataSource = useTransactionAwareDataSource;
    }

    protected boolean isUseTransactionAwareDataSource() {
        return this.useTransactionAwareDataSource;
    }

    public void setExposeTransactionAwareSessionFactory(boolean exposeTransactionAwareSessionFactory) {
        this.exposeTransactionAwareSessionFactory = exposeTransactionAwareSessionFactory;
    }

    protected boolean isExposeTransactionAwareSessionFactory() {
        return this.exposeTransactionAwareSessionFactory;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public void afterPropertiesSet() throws Exception {
        SessionFactory rawSf = this.buildSessionFactory();
        this.sessionFactory = this.wrapSessionFactoryIfNecessary(rawSf);
        this.afterSessionFactoryCreation();
    }

    protected SessionFactory wrapSessionFactoryIfNecessary(SessionFactory rawSf) {
        return rawSf;
    }

    protected final SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            throw new IllegalStateException("SessionFactory not initialized yet");
        }
        return this.sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws HibernateException {
        this.logger.info((Object)"Closing Hibernate SessionFactory");
        try {
            this.beforeSessionFactoryDestruction();
        }
        finally {
            this.sessionFactory.close();
        }
    }

    public Object getObject() {
        return this.sessionFactory;
    }

    public Class getObjectType() {
        return this.sessionFactory != null ? this.sessionFactory.getClass() : SessionFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof HibernateException) {
            return this.convertHibernateAccessException((HibernateException)ex);
        }
        return null;
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (this.jdbcExceptionTranslator != null && ex instanceof JDBCException) {
            JDBCException jdbcEx = (JDBCException)ex;
            return this.jdbcExceptionTranslator.translate("Hibernate operation: " + jdbcEx.getMessage(), jdbcEx.getSQL(), jdbcEx.getSQLException());
        }
        return SessionFactoryUtils.convertHibernateAccessException(ex);
    }

    protected abstract SessionFactory buildSessionFactory() throws Exception;

    protected void afterSessionFactoryCreation() throws Exception {
    }

    protected void beforeSessionFactoryDestruction() {
    }
}

