private rule architecture {
	meta:
		bits = 64
		endianness = "little"
		architecture = "ARM"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "_wcsnset"
		size = 124
	strings:
		$1 = { FF C3 00 D1 E0 0F 00 F9 E1 03 00 79 E2 13 00 F9 E8 0F 40 F9 E8 07 00 F9 08 00 80 D2 E8 0B 00 F9 07 00 00 14 E8 0B 40 F9 08 05 00 91 E8 0B 00 F9 E8 07 40 F9 08 09 00 91 E8 07 00 F9 E9 13 40 F9 E8 0B 40 F9 1F 01 09 EB 40 01 00 54 E8 07 40 F9 08 01 40 79 08 01 00 11 1F 01 00 71 A0 00 00 54 E9 07 40 F9 E8 03 40 79 28 01 00 79 EE FF FF 17 E0 0F 40 F9 FF C3 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
		size = 156
		refs = "0024 __acrt_locale_changed_data 0030 __acrt_initial_locale_pointers 0044 __acrt_getptd 0060 __acrt_update_locale_info 006c __acrt_update_multibyte_info"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 7F 62 00 39 81 00 00 B4 28 24 40 A9 68 A6 00 A9 1B 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? C8 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 29 40 A9 69 AA 00 A9 13 00 00 14 ?? ?? ?? ?? 61 22 00 91 60 02 00 F9 08 48 40 F9 68 06 00 F9 09 44 40 F9 69 0A 00 F9 ?? ?? ?? ?? 60 02 40 F9 61 42 00 91 ?? ?? ?? ?? 69 02 40 F9 28 A9 43 B9 A8 00 08 37 08 01 1F 32 2A 00 80 52 28 A9 03 B9 6A 62 00 39 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_1_1_0 {
	meta:
		name = "??1_LocaleUpdate@@QEAA@XZ"
		size = 28
	strings:
		$1 = { 08 60 40 39 A8 00 00 34 0A 00 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 C0 03 5F D6 }
	condition:
		$1
}

rule file_1_3_0 {
	meta:
		name = "__acrt_locale_changed"
		size = 20
		refs = "0000 __acrt_locale_changed_data"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 1F 01 00 71 E0 07 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_53_101_0 {
	meta:
		name = "__acrt_eagerly_load_locale_apis"
		size = 60
		refs = "0008 ?try_get_AreFileApisANSI@@YAP6AHXZXZ 000c ?try_get_CompareStringEx@@YAP6AHPEB_WK0H0HPEAU_nlsversioninfo@@PEAX_J@ZXZ 0010 ?try_get_EnumSystemLocalesEx@@YAP6AHP6AHPEA_WK_J@ZK1PEAX@ZXZ 0014 ?try_get_GetDateFormatEx@@YAP6AHPEB_WKPEBU_SYSTEMTIME@@0PEA_WH0@ZXZ 0018 ?try_get_GetLocaleInfoEx@@YAP6AHPEB_WKPEA_WH@ZXZ 001c ?try_get_GetTimeFormatEx@@YAP6AHPEB_WKPEBU_SYSTEMTIME@@0PEA_WH@ZXZ 0020 ?try_get_GetUserDefaultLocaleName@@YAP6AHPEA_WH@ZXZ 0024 ?try_get_IsValidLocaleName@@YAP6AHPEB_W@ZXZ 0028 ?try_get_LCMapStringEx@@YAP6AHPEB_WK0HPEA_WHPEAU_nlsversioninfo@@PEAX_J@ZXZ 002c ?try_get_LCIDToLocaleName@@YAP6AHKPEA_WHK@ZXZ 0030 ?try_get_LocaleNameToLCID@@YAP6AKPEB_WK@ZXZ"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_553_6_4 {
	meta:
		name = "__acrt_has_user_matherr"
		size = 92
		refs = "0008 ?user_matherr@@3V?$dual_state_global@P6AHPEAU_exception@@@Z@__crt_state_management@@A 0010 ?value@?$dual_state_global@P6AHPEAU_exception@@@Z@__crt_state_management@@QEAAAEAP6AHPEAU_exception@@@ZXZ 0020 ??$__crt_fast_decode_pointer@P6AHPEAU_exception@@@Z@@YAP6AHPEAU_exception@@@ZQ6AH0@Z@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 0F 00 F9 E8 0F 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 F9 E8 13 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 13 00 B9 03 00 00 14 08 00 80 52 E8 13 00 B9 E8 13 40 B9 00 1D 00 53 00 00 00 11 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_447_62_4 {
	meta:
		name = "__acrt_initialize_ptd"
		size = 108
		refs = "0008 ?destroy_fls@@YAXPEAX@Z 0010 __acrt_FlsAlloc 0018 ?__acrt_flsindex@@3KA 003c __acrt_getptd_noexit 0054 __acrt_uninitialize_ptd"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 13 00 B9 ?? ?? ?? ?? E8 13 40 B9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 1F 05 00 31 61 00 00 54 00 00 80 52 0B 00 00 14 ?? ?? ?? ?? E0 0F 00 F9 E8 0F 40 F9 1F 01 00 F1 A1 00 00 54 00 00 80 52 ?? ?? ?? ?? 00 00 80 52 02 00 00 14 20 00 80 52 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_383_37_4 {
	meta:
		name = "__acrt_update_thread_multibyte_data"
		size = 64
		refs = "0008 __acrt_current_multibyte_data 0010 ?value@?$dual_state_global@PEAU__crt_multibyte_data@@@__crt_state_management@@QEAAAEAPEAU__crt_multibyte_data@@XZ 0018 __acrt_getptd 002c ?update_thread_multibyte_data_internal@@YAPEAU__crt_multibyte_data@@QEAU__acrt_ptd@@QEAU1@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 0B 00 F9 ?? ?? ?? ?? E0 0F 00 F9 E8 0B 40 F9 01 01 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 F9 E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_422_8_4 {
	meta:
		name = "__daylight"
		size = 36
		refs = "0008 ?_daylight@@3V?$dual_state_global@H@__crt_state_management@@A 0010 ?value@?$dual_state_global@H@__crt_state_management@@QEAAAEAHXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 0B 00 F9 E0 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_435_0_2 {
	meta:
		name = "__dcrt_lowio_initialize_console_input"
		size = 72
		refs = "0008 ??_C@_1O@PNMIMBDD@?$AAC?$AAO?$AAN?$AAI?$AAN?$AA$?$AA?$AA@ 000c __imp_CreateFileW 0038 __dcrt_lowio_console_input_handle"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 06 00 80 D2 05 00 80 52 64 00 80 52 03 00 80 D2 62 00 80 52 01 00 B8 52 20 01 3F D6 ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "__dcrt_lowio_initialize_console_output"
		size = 72
		refs = "0008 ??_C@_1BA@BALFACEM@?$AAC?$AAO?$AAN?$AAO?$AAU?$AAT?$AA$?$AA?$AA@ 000c __imp_CreateFileW 0038 __dcrt_lowio_console_output_handle"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 06 00 80 D2 05 00 80 52 64 00 80 52 03 00 80 D2 62 00 80 52 01 00 A8 52 20 01 3F D6 ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_422_9_2 {
	meta:
		name = "__dstbias"
		size = 36
		refs = "0008 ?_dstbias@@3V?$dual_state_global@J@__crt_state_management@@A 0010 ?value@?$dual_state_global@J@__crt_state_management@@QEAAAEAJXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 0B 00 F9 E0 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_574_2_0 {
	meta:
		name = "__p__fmode"
		size = 36
		refs = "0008 _fmode 0010 ?value@?$dual_state_global@H@__crt_state_management@@QEAAAEAHXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 0B 00 F9 E0 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_383_38_2 {
	meta:
		name = "__p__mbcasemap"
		size = 40
		refs = "0008 _mbcasemap 0010 ?value@?$dual_state_global@PEAE@__crt_state_management@@QEAAAEAPEAEXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 0B 00 F9 E8 0B 40 F9 00 01 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_383_39_4 {
	meta:
		name = "__p__mbctype"
		size = 40
		refs = "0008 _mbctype 0010 ?value@?$dual_state_global@PEAE@__crt_state_management@@QEAAAEAPEAEXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 0B 00 F9 E8 0B 40 F9 00 01 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_422_10_0 {
	meta:
		name = "__timezone"
		size = 36
		refs = "0008 ?_timezone@@3V?$dual_state_global@J@__crt_state_management@@A 0010 ?value@?$dual_state_global@J@__crt_state_management@@QEAAAEAJXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 0B 00 F9 E0 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_422_11_4 {
	meta:
		name = "__tzname"
		size = 40
		refs = "0008 ?_tzname@@3V?$dual_state_global@PEAPEAD@__crt_state_management@@A 0010 ?value@?$dual_state_global@PEAPEAD@__crt_state_management@@QEAAAEAPEAPEADXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 0B 00 F9 E8 0B 40 F9 00 01 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_521_19_4 {
	meta:
		name = "__tzset"
		size = 144
		refs = "0008 ?first_time@?1??__tzset@@9@4JA 0010 ??$__crt_interlocked_read@J@@YAJPEDJ@Z 002c __acrt_lock 0050 ?tzset_nolock@@YAXXZ 0080 __acrt_unlock"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A0 13 00 B9 A8 13 40 B9 1F 01 00 71 40 00 00 54 18 00 00 14 C0 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A0 17 00 B9 A8 17 40 B9 1F 01 00 71 40 00 00 54 0C 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 4A 01 00 91 49 FD 5F 88 29 01 00 11 29 05 00 11 49 FD 08 88 1F 01 00 71 61 FF FF 54 BF 3B 03 D5 C0 00 80 52 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_432_8_2 {
	meta:
		name = "_get_invalid_parameter_handler"
		size = 52
		refs = "0008 ?__acrt_invalid_parameter_handler@@3V?$dual_state_global@P6AXPEB_W00I_K@Z@__crt_state_management@@A 0010 ?value@?$dual_state_global@P6AXPEB_W00I_K@Z@__crt_state_management@@QEAAAEAP6AXPEB_W00I_K@ZXZ 0020 ??$__crt_fast_decode_pointer@P6AXPEB_W00I_K@Z@@YAP6AXPEB_W00I_K@ZQ6AX000I1@Z@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 0B 00 F9 E8 0B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_256_0_3 {
	meta:
		name = "_heapchk"
		size = 64
		refs = "0008 __acrt_heap 000c __imp_HeapValidate"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 02 00 80 D2 01 00 80 52 20 01 3F D6 69 00 80 12 28 00 80 12 1F 00 00 71 20 01 88 1A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_280_0_3 {
	meta:
		name = "_heapmin"
		size = 56
		refs = "0008 __acrt_heap 000c __imp_HeapCompact"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 01 00 80 52 20 01 3F D6 08 00 80 12 1F 00 00 F1 00 01 9F 1A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_51_38_3 {
	meta:
		name = "_is_c_termination_complete"
		size = 36
		refs = "0008 ?c_termination_complete@@3JA 0010 ??$__crt_interlocked_read@J@@YAJPEDJ@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_533_4_3 {
	meta:
		name = "_query_new_mode"
		size = 48
		refs = "0008 ?__acrt_global_new_mode@@3V?$dual_state_global@J@__crt_state_management@@A 0010 ?value@?$dual_state_global@J@__crt_state_management@@QEAAAEAJXZ 001c ??$__crt_interlocked_read@J@@YAJPEDJ@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_579_1_3 {
	meta:
		name = "initialize_c"
		size = 44
		refs = "0008 __acrt_atexit_table 0010 _initialize_onexit_table 0014 __acrt_at_quick_exit_table"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 20 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_579_0_3 {
	meta:
		name = "initialize_global_variables"
		size = 40
		refs = "0008 __acrt_initial_locale_data 0010 __acrt_current_locale_data 0018 ?initialize@?$dual_state_global@PEAU__crt_locale_data@@@__crt_state_management@@QEAAXQEAU__crt_locale_data@@@Z"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 20 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_691_93_4 {
	meta:
		name = "sync_legacy_variables_lk"
		size = 144
		refs = "0008 __acrt_current_locale_data 0010 ?value@?$dual_state_global@PEAU__crt_locale_data@@@__crt_state_management@@QEAAAEAPEAU__crt_locale_data@@XZ 0024 __acrt_lconv 0050 _pctype 007c __mb_cur_max"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 0B 00 F9 E8 0B 40 F9 08 01 40 F9 08 E1 03 91 ?? ?? ?? ?? 08 01 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 0F 00 F9 E8 0F 40 F9 08 01 40 F9 08 01 00 91 08 01 00 91 ?? ?? ?? ?? 08 01 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 13 00 F9 E8 13 40 F9 08 01 40 F9 08 01 00 91 08 21 00 91 ?? ?? ?? ?? 08 01 40 B9 ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_1_5_0 {
	meta:
		name = "_mbscmp_l"
		size = 412
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0024 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0028 ??_C@_1BM@ODEBGPLG@?$AAs?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 002c ??_C@_1GO@IGMKIECK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0048 _CrtDbgReportW 0058 _errno 0078 ??_C@_1BM@BBBGICEO@?$AAs?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 00bc ??_C@_1BE@DOKJHEJA@?$AA_?$AAm?$AAb?$AAs?$AAc?$AAm?$AAp?$AA_?$AAl?$AA?$AA@ 00cc _invalid_parameter 00ec strcmp"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 33 00 00 91 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? 94 02 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 06 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 63 06 80 52 ?? ?? ?? ?? 14 00 00 14 53 03 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 06 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 83 06 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 B0 12 29 00 00 14 ED 13 40 F9 A8 09 40 B9 A8 00 00 35 61 02 00 91 80 02 00 91 ?? ?? ?? ?? 22 00 00 14 8A 16 40 38 48 1D 00 53 A8 C1 28 8B 09 65 40 39 09 01 10 36 8B 02 40 39 6B 00 00 35 0B 00 80 52 03 00 00 14 6B 21 0A 2A 94 06 00 91 6A 3D 00 53 6B 16 40 38 68 1D 00 53 A8 C1 28 8B 09 65 40 39 09 01 10 36 6C 02 40 39 6C 00 00 35 0C 00 80 52 03 00 00 14 8C 21 0B 2A 73 06 00 91 8B 3D 00 53 5F 01 0B 6B 81 00 00 54 CA FC FF 35 00 00 80 52 05 00 00 14 5F 01 0B 6B 29 00 80 52 08 00 80 12 20 81 88 1A E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_2_5_0 {
	meta:
		name = "_mbsncat_l"
		size = 476
		refs = "0028 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 002c ??_C@_1BO@GCPMHDON@?$AAd?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0030 ??_C@_1HA@IJCJEBKI@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 004c _CrtDbgReportW 005c _errno 0070 ??_C@_1BG@OHIMALLN@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAc?$AAa?$AAt?$AA_?$AAl?$AA?$AA@ 0080 _invalid_parameter 0094 ??_C@_1BO@NEBGDLJE@?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 00e4 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0100 strncat 0128 _ismbslead_l 0184 _mbsbtype_l"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BD A9 FD 03 00 91 14 00 00 91 37 00 00 91 56 00 00 91 56 0D 00 B4 54 03 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 06 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 63 06 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? 00 00 80 D2 50 00 00 14 97 02 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 06 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 83 06 80 52 ?? ?? ?? ?? E6 FF FF 17 61 00 00 91 E0 43 00 91 ?? ?? ?? ?? E8 13 40 F9 08 09 40 B9 E8 00 00 35 C2 02 00 91 E1 02 00 91 80 02 00 91 ?? ?? ?? ?? 15 00 00 91 29 00 00 14 95 02 00 91 93 02 00 91 88 16 40 38 C8 FF FF 35 E2 63 00 91 61 02 00 91 A0 02 00 91 ?? ?? ?? ?? 40 00 00 34 73 06 00 D1 ED 13 40 F9 EA 16 40 38 D6 06 00 D1 48 01 0D 8B 09 65 40 39 89 02 10 36 6A 02 00 39 EA 02 40 39 F7 06 00 91 6A 06 00 39 73 0A 00 91 0A 02 00 35 7F E2 1F 38 7F 02 15 EB E0 01 00 54 69 02 15 4B 2A 05 00 51 41 7D 40 93 E2 63 00 91 A0 02 00 91 ?? ?? ?? ?? 1F 04 00 71 E1 00 00 54 7F F2 1F 38 06 00 00 14 6A 16 00 38 6A FE FF 34 56 FE FF B4 E5 FF FF 17 7F 02 00 39 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 A0 02 00 91 FD 7B C3 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "??$common_splitpath@D@@YAXQEBDQEAD111@Z"
		size = 296
		refs = "011c ??$common_splitpath_internal@DV<lambda_53a6356d19cc262edbc98b4248a685b4>@@V<lambda_040cbb5784310d69116e1bf4e70bcac8>@@@@YAHQEBDQEAU?$component_buffers@D@?A0x95109fda@@V<lambda_53a6356d19cc262edbc98b4248a685b4>@@V<lambda_040cbb5784310d69116e1bf4e70bcac8>@@@Z"
	strings:
		$1 = { FD 7B B7 A9 FD 03 00 91 E0 27 00 F9 E1 17 00 F9 E2 1B 00 F9 E3 1F 00 F9 E4 23 00 F9 E8 17 40 F9 E8 2B 00 F9 E8 17 40 F9 1F 01 00 F1 80 00 00 54 68 00 80 52 E8 17 00 B9 03 00 00 14 08 00 80 52 E8 17 00 B9 E8 17 40 B9 08 7D 40 93 E8 2F 00 F9 E8 1B 40 F9 E8 33 00 F9 E8 1B 40 F9 1F 01 00 F1 80 00 00 54 08 20 80 52 E8 1B 00 B9 03 00 00 14 08 00 80 52 E8 1B 00 B9 E8 1B 40 B9 08 7D 40 93 E8 37 00 F9 E8 1F 40 F9 E8 3B 00 F9 E8 1F 40 F9 1F 01 00 F1 80 00 00 54 08 20 80 52 E8 1F 00 B9 03 00 00 14 08 00 80 52 E8 1F 00 B9 E8 1F 40 B9 08 7D 40 93 E8 3F 00 F9 E8 23 40 F9 E8 43 00 F9 E8 23 40 F9 1F 01 00 F1 80 00 00 54 08 20 80 52 E8 23 00 B9 03 00 00 14 08 00 80 52 E8 23 00 B9 E8 23 40 B9 08 7D 40 93 E8 47 00 F9 E9 43 00 91 29 01 00 91 08 00 80 52 28 01 00 39 E9 47 00 91 29 01 00 91 08 00 80 52 28 01 00 39 E3 43 40 39 E2 47 40 39 E1 43 01 91 E0 27 40 F9 ?? ?? ?? ?? FD 7B C9 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_3_1_0 {
	meta:
		name = "??$common_splitpath@_W@@YAXQEB_WQEA_W111@Z"
		size = 296
		refs = "011c ??$common_splitpath_internal@_WV<lambda_9fe510dc9fc28f0f48835de8b1506c83>@@V<lambda_215ce41ea8e549d39a53f9f91343d9df>@@@@YAHQEB_WQEAU?$component_buffers@_W@?A0x95109fda@@V<lambda_9fe510dc9fc28f0f48835de8b1506c83>@@V<lambda_215ce41ea8e549d39a53f9f91343d9df>@@@Z"
	strings:
		$1 = { FD 7B B7 A9 FD 03 00 91 E0 27 00 F9 E1 17 00 F9 E2 1B 00 F9 E3 1F 00 F9 E4 23 00 F9 E8 17 40 F9 E8 2B 00 F9 E8 17 40 F9 1F 01 00 F1 80 00 00 54 68 00 80 52 E8 17 00 B9 03 00 00 14 08 00 80 52 E8 17 00 B9 E8 17 40 B9 08 7D 40 93 E8 2F 00 F9 E8 1B 40 F9 E8 33 00 F9 E8 1B 40 F9 1F 01 00 F1 80 00 00 54 08 20 80 52 E8 1B 00 B9 03 00 00 14 08 00 80 52 E8 1B 00 B9 E8 1B 40 B9 08 7D 40 93 E8 37 00 F9 E8 1F 40 F9 E8 3B 00 F9 E8 1F 40 F9 1F 01 00 F1 80 00 00 54 08 20 80 52 E8 1F 00 B9 03 00 00 14 08 00 80 52 E8 1F 00 B9 E8 1F 40 B9 08 7D 40 93 E8 3F 00 F9 E8 23 40 F9 E8 43 00 F9 E8 23 40 F9 1F 01 00 F1 80 00 00 54 08 20 80 52 E8 23 00 B9 03 00 00 14 08 00 80 52 E8 23 00 B9 E8 23 40 B9 08 7D 40 93 E8 47 00 F9 E9 43 00 91 29 01 00 91 08 00 80 52 28 01 00 39 E9 47 00 91 29 01 00 91 08 00 80 52 28 01 00 39 E3 43 40 39 E2 47 40 39 E1 43 01 91 E0 27 40 F9 ?? ?? ?? ?? FD 7B C9 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_3_6_0 {
	meta:
		name = "??$common_splitpath_s@D@@YAHQEBDQEAU?$component_buffers@D@?A0x95109fda@@@Z"
		size = 84
		refs = "0040 ??$common_splitpath_internal@DV<lambda_83031056ba654f505b43b9a7be717f27>@@V<lambda_7224c10e0d9cf27ffd5accaa7469d6af>@@@@YAHQEBDQEAU?$component_buffers@D@?A0x95109fda@@V<lambda_83031056ba654f505b43b9a7be717f27>@@V<lambda_7224c10e0d9cf27ffd5accaa7469d6af>@@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E9 43 00 91 29 01 00 91 08 00 80 52 28 01 00 39 E9 47 00 91 29 01 00 91 08 00 80 52 28 01 00 39 E3 43 40 39 E2 47 40 39 E1 0F 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 17 00 B9 E0 17 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_3_7_0 {
	meta:
		name = "??$common_splitpath_s@_W@@YAHQEB_WQEAU?$component_buffers@_W@?A0x95109fda@@@Z"
		size = 84
		refs = "0040 ??$common_splitpath_internal@_WV<lambda_6db719bd719b7ee2efde762101b1367f>@@V<lambda_b90d8f84996fccaedfcae156869b1630>@@@@YAHQEB_WQEAU?$component_buffers@_W@?A0x95109fda@@V<lambda_6db719bd719b7ee2efde762101b1367f>@@V<lambda_b90d8f84996fccaedfcae156869b1630>@@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E9 43 00 91 29 01 00 91 08 00 80 52 28 01 00 39 E9 47 00 91 29 01 00 91 08 00 80 52 28 01 00 39 E3 43 40 39 E2 47 40 39 E1 0F 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 17 00 B9 E0 17 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_3_12_0 {
	meta:
		name = "??$tcsncpy_s@AEAPEAD_KAEAPEBDAEB_K@?$__crt_char_traits@D@@SAHAEAPEAD$$QEA_KAEAPEBDAEB_K@Z"
		size = 76
		refs = "0038 strncpy_s"
		altNames = "??$tcsncpy_s@AEAPEAD_KAEAPEADAEB_K@?$__crt_char_traits@D@@SAHAEAPEAD$$QEA_K0AEB_K@Z ??$tcsncpy_s@PEADAEB_KAEBQEBDAEB_K@?$__crt_char_traits@D@@SAH$$QEAPEADAEB_KAEBQEBD1@Z ??$tcsncpy_s@PEAD_KAEBQEBDAEB_K@?$__crt_char_traits@D@@SAH$$QEAPEAD$$QEA_KAEBQEBDAEB_K@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 F9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_565_20_3 {
	meta:
		name = "??$tcsncat_s@AEAPEADAEB_KAEBQEBD_K@?$__crt_char_traits@D@@SAHAEAPEADAEB_KAEBQEBD$$QEA_K@Z"
		size = 76
		refs = "0038 strncat_s"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 F9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_565_21_3 {
	meta:
		name = "??$tcsncat_s@AEAPEA_WAEB_KAEBQEB_W_K@?$__crt_char_traits@_W@@SAHAEAPEA_WAEB_KAEBQEB_W$$QEA_K@Z"
		size = 76
		refs = "0038 wcsncat_s"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 F9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_424_35_0 {
	meta:
		name = "??$tcsncat_s@AEBQEADAEB_KAEAPEBD_K@?$__crt_char_traits@D@@SAHAEBQEADAEB_KAEAPEBD$$QEA_K@Z"
		size = 76
		refs = "0038 strncat_s"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 F9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_424_36_4 {
	meta:
		name = "??$tcsncat_s@AEBQEADAEB_KAEBQEBDAEB_K@?$__crt_char_traits@D@@SAHAEBQEADAEB_KAEBQEBD1@Z"
		size = 76
		refs = "0038 strncat_s"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 F9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_424_37_2 {
	meta:
		name = "??$tcsncat_s@AEBQEADAEB_KPEBD_K@?$__crt_char_traits@D@@SAHAEBQEADAEB_K$$QEAPEBD$$QEA_K@Z"
		size = 76
		refs = "0038 strncat_s"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 F9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_424_38_2 {
	meta:
		name = "??$tcsncat_s@AEBQEA_WAEB_KAEAPEB_W_K@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_KAEAPEB_W$$QEA_K@Z"
		size = 76
		refs = "0038 wcsncat_s"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 F9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_424_39_4 {
	meta:
		name = "??$tcsncat_s@AEBQEA_WAEB_KAEBQEB_WAEB_K@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_KAEBQEB_W1@Z"
		size = 76
		refs = "0038 wcsncat_s"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 F9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_424_40_4 {
	meta:
		name = "??$tcsncat_s@AEBQEA_WAEB_KPEB_W_K@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_K$$QEAPEB_W$$QEA_K@Z"
		size = 76
		refs = "0038 wcsncat_s"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 F9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_612_22_0 {
	meta:
		name = "??$tcsncpy_s@AEAPEA_W_KAEAPEA_WAEB_K@?$__crt_char_traits@_W@@SAHAEAPEA_W$$QEA_K0AEB_K@Z"
		size = 76
		refs = "0038 wcsncpy_s"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 F9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_3_14_3 {
	meta:
		name = "??$tcsncpy_s@AEAPEA_W_KAEAPEB_WAEB_K@?$__crt_char_traits@_W@@SAHAEAPEA_W$$QEA_KAEAPEB_WAEB_K@Z"
		size = 76
		refs = "0038 wcsncpy_s"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 F9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_612_25_3 {
	meta:
		name = "??$tcsncpy_s@PEA_WAEB_KAEBQEB_WAEB_K@?$__crt_char_traits@_W@@SAH$$QEAPEA_WAEB_KAEBQEB_W1@Z"
		size = 76
		refs = "0038 wcsncpy_s"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 F9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_612_26_3 {
	meta:
		name = "??$tcsncpy_s@PEA_W_KAEBQEB_WAEB_K@?$__crt_char_traits@_W@@SAH$$QEAPEA_W$$QEA_KAEBQEB_WAEB_K@Z"
		size = 76
		refs = "0038 wcsncpy_s"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 F9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_3_13_0 {
	meta:
		name = "??$tcsncpy_s@AEAPEAD_KAEAPEBDH@?$__crt_char_traits@D@@SAHAEAPEAD$$QEA_KAEAPEBD$$QEAH@Z"
		size = 84
		refs = "0040 strncpy_s"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 08 01 40 B9 03 7D 40 93 63 00 00 91 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_3_15_0 {
	meta:
		name = "??$tcsncpy_s@AEAPEA_W_KAEAPEB_WH@?$__crt_char_traits@_W@@SAHAEAPEA_W$$QEA_KAEAPEB_W$$QEAH@Z"
		size = 84
		refs = "0040 wcsncpy_s"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 08 01 40 B9 03 7D 40 93 63 00 00 91 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_3_24_0 {
	meta:
		name = "?is_lead_byte@@YA_ND@Z"
		size = 84
		refs = "0018 _ismbblead"
		altNames = "?should_copy_another_character@@YA_ND@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 39 E0 43 C0 39 00 00 00 11 00 00 00 11 ?? ?? ?? ?? E0 1B 00 B9 E8 1B 40 B9 1F 01 00 71 80 00 00 54 28 00 80 52 E8 17 00 B9 03 00 00 14 08 00 80 52 E8 17 00 B9 E8 17 40 B9 00 1D 00 53 00 00 00 11 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_3_25_0 {
	meta:
		name = "?is_lead_byte@@YA_N_W@Z"
		size = 20
		altNames = "?should_copy_another_character@@YA_N_W@Z"
	strings:
		$1 = { FF 43 00 D1 E0 03 00 79 00 00 80 52 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_3_26_0 {
	meta:
		name = "_splitpath"
		size = 60
		refs = "0030 ??$common_splitpath@D@@YAXQEBDQEAD111@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E4 0B 00 F9 E4 0B 40 F9 E3 0F 40 F9 E2 13 40 F9 E1 17 40 F9 E0 1B 40 F9 ?? ?? ?? ?? FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_3_28_0 {
	meta:
		name = "_wsplitpath"
		size = 60
		refs = "0030 ??$common_splitpath@_W@@YAXQEB_WQEA_W111@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E4 0B 00 F9 E4 0B 40 F9 E3 0F 40 F9 E2 13 40 F9 E1 17 40 F9 E0 1B 40 F9 ?? ?? ?? ?? FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_3_27_0 {
	meta:
		name = "_splitpath_s"
		size = 132
		refs = "0070 ??$common_splitpath_s@D@@YAHQEBDQEAU?$component_buffers@D@?A0x95109fda@@@Z"
	strings:
		$1 = { FD 7B B6 A9 FD 03 00 91 E0 2B 00 F9 E1 0F 00 F9 E2 13 00 F9 E3 17 00 F9 E4 1B 00 F9 E5 1F 00 F9 E6 23 00 F9 E7 27 00 F9 E8 0F 40 F9 E8 2F 00 F9 E8 13 40 F9 E8 33 00 F9 E8 17 40 F9 E8 37 00 F9 E8 1B 40 F9 E8 3B 00 F9 E8 1F 40 F9 E8 3F 00 F9 E8 23 40 F9 E8 43 00 F9 E8 27 40 F9 E8 47 00 F9 E8 53 40 F9 E8 4B 00 F9 E1 63 01 91 E0 2B 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B CA A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_3_29_0 {
	meta:
		name = "_wsplitpath_s"
		size = 132
		refs = "0070 ??$common_splitpath_s@_W@@YAHQEB_WQEAU?$component_buffers@_W@?A0x95109fda@@@Z"
	strings:
		$1 = { FD 7B B6 A9 FD 03 00 91 E0 2B 00 F9 E1 0F 00 F9 E2 13 00 F9 E3 17 00 F9 E4 1B 00 F9 E5 1F 00 F9 E6 23 00 F9 E7 27 00 F9 E8 0F 40 F9 E8 2F 00 F9 E8 13 40 F9 E8 33 00 F9 E8 17 40 F9 E8 37 00 F9 E8 1B 40 F9 E8 3B 00 F9 E8 1F 40 F9 E8 3F 00 F9 E8 23 40 F9 E8 43 00 F9 E8 27 40 F9 E8 47 00 F9 E8 53 40 F9 E8 4B 00 F9 E1 63 01 91 E0 2B 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B CA A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "??$common_ctime@JD@@YAPEADQEBJ@Z"
		size = 348
		refs = "0008 __security_push_cookie 0048 ??_C@_1DA@FIGBFGOM@?$AAt?$AAi?$AAm?$AAe?$AA_?$AAt?$AA_?$AAv?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0050 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0060 ??_C@_1FM@GNABIEEL@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 006c _CrtDbgReportW 0094 _errno 00b8 ??_C@_1BK@FFKKLBJF@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAc?$AAt?$AAi?$AAm?$AAe?$AA?$AA@ 00c8 _invalid_parameter 0110 ??$localtime_s@PEAUtm@@AEBQEBJ@?$__crt_integer_traits@J@@SAH$$QEAPEAUtm@@AEBQEBJ@Z 0140 ??$tasctime@PEAUtm@@@?$__crt_char_traits@D@@SAPEAD$$QEAPEAUtm@@@Z 0150 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF C3 01 D1 E0 0F 00 F9 E8 0F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 E8 07 00 B9 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 0B 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 0B 00 B9 E9 0B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 13 00 F9 E9 13 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 0B 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 1F 00 00 14 E8 0F 40 F9 08 01 40 B9 1F 01 00 71 0A 01 00 54 ?? ?? ?? ?? E0 17 00 F9 E9 17 40 F9 C8 02 80 52 28 01 00 B9 00 00 80 D2 14 00 00 14 E8 23 01 91 E8 1B 00 F9 E1 63 00 91 E0 C3 00 91 ?? ?? ?? ?? E0 0F 00 B9 E8 0F 40 B9 E8 13 00 B9 E8 13 40 B9 1F 01 00 71 60 00 00 54 00 00 80 D2 07 00 00 14 E8 23 01 91 E8 1F 00 F9 E0 E3 00 91 ?? ?? ?? ?? E0 23 00 F9 E0 23 40 F9 FF C3 01 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_1_0 {
	meta:
		name = "??$common_ctime@J_W@@YAPEA_WQEBJ@Z"
		size = 348
		refs = "0008 __security_push_cookie 0048 ??_C@_1DA@FIGBFGOM@?$AAt?$AAi?$AAm?$AAe?$AA_?$AAt?$AA_?$AAv?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0050 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0060 ??_C@_1FM@GNABIEEL@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 006c _CrtDbgReportW 0094 _errno 00b8 ??_C@_1BK@FFKKLBJF@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAc?$AAt?$AAi?$AAm?$AAe?$AA?$AA@ 00c8 _invalid_parameter 0110 ??$localtime_s@PEAUtm@@AEBQEBJ@?$__crt_integer_traits@J@@SAH$$QEAPEAUtm@@AEBQEBJ@Z 0140 ??$tasctime@PEAUtm@@@?$__crt_char_traits@_W@@SAPEA_W$$QEAPEAUtm@@@Z 0150 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF C3 01 D1 E0 0F 00 F9 E8 0F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 E8 07 00 B9 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 0B 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 0B 00 B9 E9 0B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 13 00 F9 E9 13 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 0B 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 1F 00 00 14 E8 0F 40 F9 08 01 40 B9 1F 01 00 71 0A 01 00 54 ?? ?? ?? ?? E0 17 00 F9 E9 17 40 F9 C8 02 80 52 28 01 00 B9 00 00 80 D2 14 00 00 14 E8 23 01 91 E8 1B 00 F9 E1 63 00 91 E0 C3 00 91 ?? ?? ?? ?? E0 0F 00 B9 E8 0F 40 B9 E8 13 00 B9 E8 13 40 B9 1F 01 00 71 60 00 00 54 00 00 80 D2 07 00 00 14 E8 23 01 91 E8 1F 00 F9 E0 E3 00 91 ?? ?? ?? ?? E0 23 00 F9 E0 23 40 F9 FF C3 01 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_2_0 {
	meta:
		name = "??$common_ctime@_JD@@YAPEADQEB_J@Z"
		size = 348
		refs = "0008 __security_push_cookie 0048 ??_C@_1DA@FIGBFGOM@?$AAt?$AAi?$AAm?$AAe?$AA_?$AAt?$AA_?$AAv?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0050 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0060 ??_C@_1FM@GNABIEEL@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 006c _CrtDbgReportW 0094 _errno 00b8 ??_C@_1BK@FFKKLBJF@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAc?$AAt?$AAi?$AAm?$AAe?$AA?$AA@ 00c8 _invalid_parameter 0110 ??$localtime_s@PEAUtm@@AEBQEB_J@?$__crt_integer_traits@_J@@SAH$$QEAPEAUtm@@AEBQEB_J@Z 0140 ??$tasctime@PEAUtm@@@?$__crt_char_traits@D@@SAPEAD$$QEAPEAUtm@@@Z 0150 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF C3 01 D1 E0 0F 00 F9 E8 0F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 E8 07 00 B9 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 0B 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 0B 00 B9 E9 0B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 13 00 F9 E9 13 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 0B 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 1F 00 00 14 E8 0F 40 F9 08 01 40 F9 1F 01 00 F1 0A 01 00 54 ?? ?? ?? ?? E0 17 00 F9 E9 17 40 F9 C8 02 80 52 28 01 00 B9 00 00 80 D2 14 00 00 14 E8 23 01 91 E8 1B 00 F9 E1 63 00 91 E0 C3 00 91 ?? ?? ?? ?? E0 0F 00 B9 E8 0F 40 B9 E8 13 00 B9 E8 13 40 B9 1F 01 00 71 60 00 00 54 00 00 80 D2 07 00 00 14 E8 23 01 91 E8 1F 00 F9 E0 E3 00 91 ?? ?? ?? ?? E0 23 00 F9 E0 23 40 F9 FF C3 01 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_3_0 {
	meta:
		name = "??$common_ctime@_J_W@@YAPEA_WQEB_J@Z"
		size = 348
		refs = "0008 __security_push_cookie 0048 ??_C@_1DA@FIGBFGOM@?$AAt?$AAi?$AAm?$AAe?$AA_?$AAt?$AA_?$AAv?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0050 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0060 ??_C@_1FM@GNABIEEL@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 006c _CrtDbgReportW 0094 _errno 00b8 ??_C@_1BK@FFKKLBJF@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAc?$AAt?$AAi?$AAm?$AAe?$AA?$AA@ 00c8 _invalid_parameter 0110 ??$localtime_s@PEAUtm@@AEBQEB_J@?$__crt_integer_traits@_J@@SAH$$QEAPEAUtm@@AEBQEB_J@Z 0140 ??$tasctime@PEAUtm@@@?$__crt_char_traits@_W@@SAPEA_W$$QEAPEAUtm@@@Z 0150 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF C3 01 D1 E0 0F 00 F9 E8 0F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 E8 07 00 B9 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 0B 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 0B 00 B9 E9 0B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 13 00 F9 E9 13 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 0B 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 1F 00 00 14 E8 0F 40 F9 08 01 40 F9 1F 01 00 F1 0A 01 00 54 ?? ?? ?? ?? E0 17 00 F9 E9 17 40 F9 C8 02 80 52 28 01 00 B9 00 00 80 D2 14 00 00 14 E8 23 01 91 E8 1B 00 F9 E1 63 00 91 E0 C3 00 91 ?? ?? ?? ?? E0 0F 00 B9 E8 0F 40 B9 E8 13 00 B9 E8 13 40 B9 1F 01 00 71 60 00 00 54 00 00 80 D2 07 00 00 14 E8 23 01 91 E8 1F 00 F9 E0 E3 00 91 ?? ?? ?? ?? E0 23 00 F9 E0 23 40 F9 FF C3 01 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_4_0 {
	meta:
		name = "??$common_ctime_s@JD@@YAHQEAD_KQEBJ@Z"
		size = 900
		refs = "0008 __security_push_cookie 005c ??_C@_1EO@MBPFOEIP@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA_?$AAi?$AAn?$AA_?$AAc?$AAh?$AAa@ 0064 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0074 ??_C@_1FM@GNABIEEL@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 0080 _CrtDbgReportW 00a8 _errno 00cc ??_C@_1BO@IFLJMBPJ@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAc?$AAt?$AAi?$AAm?$AAe?$AA_?$AAs?$AA?$AA@ 00dc _invalid_parameter 0120 _CrtGetDebugFillThreshold 0170 memset 01a8 ??_C@_1CI@DCHHDOEB@?$AAs?$AAi?$AAz?$AAe?$AA_?$AAi?$AAn?$AA_?$AAc?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA2?$AA6?$AA?$AA@ 0268 ??_C@_1DA@FIGBFGOM@?$AAt?$AAi?$AAm?$AAe?$AA_?$AAt?$AA_?$AAv?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0330 ??$localtime_s@PEAUtm@@AEBQEBJ@?$__crt_integer_traits@J@@SAH$$QEAPEAUtm@@AEBQEBJ@Z 0368 ??$tasctime_s@AEBQEADAEB_KPEAUtm@@@?$__crt_char_traits@D@@SAHAEBQEADAEB_K$$QEAPEAUtm@@@Z 0378 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 03 03 D1 E0 17 00 F9 E1 03 00 F9 E2 27 00 F9 E8 17 40 F9 1F 01 00 F1 E0 00 00 54 E8 03 40 F9 1F 01 00 F1 89 00 00 54 28 00 80 52 E8 0B 00 B9 03 00 00 14 08 00 80 52 E8 0B 00 B9 E8 0B 40 B9 E8 0F 00 B9 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 33 00 B9 E9 33 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 33 00 F9 E9 33 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 A3 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 A4 00 00 14 E9 17 40 F9 08 00 80 52 28 01 00 39 E8 03 40 F9 1F 05 00 B1 C0 03 00 54 E9 7B 40 B2 E8 03 40 F9 1F 01 09 EB 40 03 00 54 E9 03 40 F9 28 00 80 D2 1F 01 09 EB C2 02 00 54 ?? ?? ?? ?? E0 37 00 F9 E8 37 40 F9 E8 2B 00 F9 E8 03 40 F9 09 05 00 D1 E8 2B 40 F9 1F 01 09 EB 82 00 00 54 E8 2B 40 F9 E8 2F 00 F9 04 00 00 14 E8 03 40 F9 08 05 00 D1 E8 2F 00 F9 E8 17 40 F9 00 05 00 91 E2 2F 40 F9 C1 1F 80 52 00 00 00 91 ?? ?? ?? ?? E8 03 40 F9 1F 69 00 F1 83 00 00 54 28 00 80 52 E8 13 00 B9 03 00 00 14 08 00 80 52 E8 13 00 B9 E8 13 40 B9 E8 17 00 B9 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 22 04 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 37 00 B9 E9 37 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 3B 00 F9 E9 3B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 23 04 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 51 00 00 14 E8 27 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 1B 00 B9 03 00 00 14 08 00 80 52 E8 1B 00 B9 E8 1B 40 B9 E8 1F 00 B9 E8 1F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 04 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 3B 00 B9 E9 3B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 1F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 3F 00 F9 E9 3F 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 43 04 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 21 00 00 14 E8 27 40 F9 08 01 40 B9 1F 01 00 71 0A 01 00 54 ?? ?? ?? ?? E0 43 00 F9 E9 43 40 F9 C8 02 80 52 28 01 00 B9 C0 02 80 52 16 00 00 14 E8 63 02 91 E8 47 00 F9 E1 23 01 91 E0 23 02 91 ?? ?? ?? ?? E0 3F 00 B9 E8 3F 40 B9 E8 23 00 B9 E8 23 40 B9 1F 01 00 71 60 00 00 54 E0 23 40 B9 09 00 00 14 E8 63 02 91 E8 4B 00 F9 E2 43 02 91 E1 03 00 91 E0 A3 00 91 ?? ?? ?? ?? E0 43 00 B9 E0 43 40 B9 FF 03 03 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_5_0 {
	meta:
		name = "??$common_ctime_s@J_W@@YAHQEA_W_KQEBJ@Z"
		size = 912
		refs = "0008 __security_push_cookie 005c ??_C@_1EO@MBPFOEIP@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA_?$AAi?$AAn?$AA_?$AAc?$AAh?$AAa@ 0064 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0074 ??_C@_1FM@GNABIEEL@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 0080 _CrtDbgReportW 00a8 _errno 00cc ??_C@_1BO@IFLJMBPJ@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAc?$AAt?$AAi?$AAm?$AAe?$AA_?$AAs?$AA?$AA@ 00dc _invalid_parameter 0120 _CrtGetDebugFillThreshold 017c memset 01b4 ??_C@_1CI@DCHHDOEB@?$AAs?$AAi?$AAz?$AAe?$AA_?$AAi?$AAn?$AA_?$AAc?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA2?$AA6?$AA?$AA@ 0274 ??_C@_1DA@FIGBFGOM@?$AAt?$AAi?$AAm?$AAe?$AA_?$AAt?$AA_?$AAv?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 033c ??$localtime_s@PEAUtm@@AEBQEBJ@?$__crt_integer_traits@J@@SAH$$QEAPEAUtm@@AEBQEBJ@Z 0374 ??$tasctime_s@AEBQEA_WAEB_KPEAUtm@@@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_K$$QEAPEAUtm@@@Z 0384 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 03 03 D1 E0 17 00 F9 E1 03 00 F9 E2 27 00 F9 E8 17 40 F9 1F 01 00 F1 E0 00 00 54 E8 03 40 F9 1F 01 00 F1 89 00 00 54 28 00 80 52 E8 0B 00 B9 03 00 00 14 08 00 80 52 E8 0B 00 B9 E8 0B 40 B9 E8 0F 00 B9 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 33 00 B9 E9 33 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 33 00 F9 E9 33 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 A3 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 A7 00 00 14 E9 17 40 F9 08 00 80 52 28 01 00 79 E8 03 40 F9 1F 05 00 B1 20 04 00 54 E9 7B 40 B2 E8 03 40 F9 1F 01 09 EB A0 03 00 54 E9 03 40 F9 28 00 80 D2 1F 01 09 EB 22 03 00 54 ?? ?? ?? ?? E0 37 00 F9 E8 37 40 F9 E8 2B 00 F9 E8 03 40 F9 09 05 00 D1 E8 2B 40 F9 1F 01 09 EB 82 00 00 54 E8 2B 40 F9 E8 2F 00 F9 04 00 00 14 E8 03 40 F9 08 05 00 D1 E8 2F 00 F9 E9 2F 40 F9 48 00 80 D2 22 7D 08 9B E8 17 40 F9 00 09 00 91 42 00 00 91 C1 1F 80 52 00 00 00 91 ?? ?? ?? ?? E8 03 40 F9 1F 69 00 F1 83 00 00 54 28 00 80 52 E8 13 00 B9 03 00 00 14 08 00 80 52 E8 13 00 B9 E8 13 40 B9 E8 17 00 B9 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 22 04 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 37 00 B9 E9 37 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 3B 00 F9 E9 3B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 23 04 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 51 00 00 14 E8 27 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 1B 00 B9 03 00 00 14 08 00 80 52 E8 1B 00 B9 E8 1B 40 B9 E8 1F 00 B9 E8 1F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 04 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 3B 00 B9 E9 3B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 1F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 3F 00 F9 E9 3F 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 43 04 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 21 00 00 14 E8 27 40 F9 08 01 40 B9 1F 01 00 71 0A 01 00 54 ?? ?? ?? ?? E0 43 00 F9 E9 43 40 F9 C8 02 80 52 28 01 00 B9 C0 02 80 52 16 00 00 14 E8 63 02 91 E8 47 00 F9 E1 23 01 91 E0 23 02 91 ?? ?? ?? ?? E0 3F 00 B9 E8 3F 40 B9 E8 23 00 B9 E8 23 40 B9 1F 01 00 71 60 00 00 54 E0 23 40 B9 09 00 00 14 E8 63 02 91 E8 4B 00 F9 E2 43 02 91 E1 03 00 91 E0 A3 00 91 ?? ?? ?? ?? E0 43 00 B9 E0 43 40 B9 FF 03 03 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_6_0 {
	meta:
		name = "??$common_ctime_s@_JD@@YAHQEAD_KQEB_J@Z"
		size = 900
		refs = "0008 __security_push_cookie 005c ??_C@_1EO@MBPFOEIP@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA_?$AAi?$AAn?$AA_?$AAc?$AAh?$AAa@ 0064 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0074 ??_C@_1FM@GNABIEEL@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 0080 _CrtDbgReportW 00a8 _errno 00cc ??_C@_1BO@IFLJMBPJ@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAc?$AAt?$AAi?$AAm?$AAe?$AA_?$AAs?$AA?$AA@ 00dc _invalid_parameter 0120 _CrtGetDebugFillThreshold 0170 memset 01a8 ??_C@_1CI@DCHHDOEB@?$AAs?$AAi?$AAz?$AAe?$AA_?$AAi?$AAn?$AA_?$AAc?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA2?$AA6?$AA?$AA@ 0268 ??_C@_1DA@FIGBFGOM@?$AAt?$AAi?$AAm?$AAe?$AA_?$AAt?$AA_?$AAv?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0330 ??$localtime_s@PEAUtm@@AEBQEB_J@?$__crt_integer_traits@_J@@SAH$$QEAPEAUtm@@AEBQEB_J@Z 0368 ??$tasctime_s@AEBQEADAEB_KPEAUtm@@@?$__crt_char_traits@D@@SAHAEBQEADAEB_K$$QEAPEAUtm@@@Z 0378 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 03 03 D1 E0 17 00 F9 E1 03 00 F9 E2 27 00 F9 E8 17 40 F9 1F 01 00 F1 E0 00 00 54 E8 03 40 F9 1F 01 00 F1 89 00 00 54 28 00 80 52 E8 0B 00 B9 03 00 00 14 08 00 80 52 E8 0B 00 B9 E8 0B 40 B9 E8 0F 00 B9 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 33 00 B9 E9 33 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 33 00 F9 E9 33 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 A3 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 A4 00 00 14 E9 17 40 F9 08 00 80 52 28 01 00 39 E8 03 40 F9 1F 05 00 B1 C0 03 00 54 E9 7B 40 B2 E8 03 40 F9 1F 01 09 EB 40 03 00 54 E9 03 40 F9 28 00 80 D2 1F 01 09 EB C2 02 00 54 ?? ?? ?? ?? E0 37 00 F9 E8 37 40 F9 E8 2B 00 F9 E8 03 40 F9 09 05 00 D1 E8 2B 40 F9 1F 01 09 EB 82 00 00 54 E8 2B 40 F9 E8 2F 00 F9 04 00 00 14 E8 03 40 F9 08 05 00 D1 E8 2F 00 F9 E8 17 40 F9 00 05 00 91 E2 2F 40 F9 C1 1F 80 52 00 00 00 91 ?? ?? ?? ?? E8 03 40 F9 1F 69 00 F1 83 00 00 54 28 00 80 52 E8 13 00 B9 03 00 00 14 08 00 80 52 E8 13 00 B9 E8 13 40 B9 E8 17 00 B9 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 22 04 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 37 00 B9 E9 37 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 3B 00 F9 E9 3B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 23 04 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 51 00 00 14 E8 27 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 1B 00 B9 03 00 00 14 08 00 80 52 E8 1B 00 B9 E8 1B 40 B9 E8 1F 00 B9 E8 1F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 04 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 3B 00 B9 E9 3B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 1F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 3F 00 F9 E9 3F 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 43 04 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 21 00 00 14 E8 27 40 F9 08 01 40 F9 1F 01 00 F1 0A 01 00 54 ?? ?? ?? ?? E0 43 00 F9 E9 43 40 F9 C8 02 80 52 28 01 00 B9 C0 02 80 52 16 00 00 14 E8 63 02 91 E8 47 00 F9 E1 23 01 91 E0 23 02 91 ?? ?? ?? ?? E0 3F 00 B9 E8 3F 40 B9 E8 23 00 B9 E8 23 40 B9 1F 01 00 71 60 00 00 54 E0 23 40 B9 09 00 00 14 E8 63 02 91 E8 4B 00 F9 E2 43 02 91 E1 03 00 91 E0 A3 00 91 ?? ?? ?? ?? E0 43 00 B9 E0 43 40 B9 FF 03 03 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_7_0 {
	meta:
		name = "??$common_ctime_s@_J_W@@YAHQEA_W_KQEB_J@Z"
		size = 912
		refs = "0008 __security_push_cookie 005c ??_C@_1EO@MBPFOEIP@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA_?$AAi?$AAn?$AA_?$AAc?$AAh?$AAa@ 0064 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0074 ??_C@_1FM@GNABIEEL@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 0080 _CrtDbgReportW 00a8 _errno 00cc ??_C@_1BO@IFLJMBPJ@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAc?$AAt?$AAi?$AAm?$AAe?$AA_?$AAs?$AA?$AA@ 00dc _invalid_parameter 0120 _CrtGetDebugFillThreshold 017c memset 01b4 ??_C@_1CI@DCHHDOEB@?$AAs?$AAi?$AAz?$AAe?$AA_?$AAi?$AAn?$AA_?$AAc?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA2?$AA6?$AA?$AA@ 0274 ??_C@_1DA@FIGBFGOM@?$AAt?$AAi?$AAm?$AAe?$AA_?$AAt?$AA_?$AAv?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 033c ??$localtime_s@PEAUtm@@AEBQEB_J@?$__crt_integer_traits@_J@@SAH$$QEAPEAUtm@@AEBQEB_J@Z 0374 ??$tasctime_s@AEBQEA_WAEB_KPEAUtm@@@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_K$$QEAPEAUtm@@@Z 0384 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 03 03 D1 E0 17 00 F9 E1 03 00 F9 E2 27 00 F9 E8 17 40 F9 1F 01 00 F1 E0 00 00 54 E8 03 40 F9 1F 01 00 F1 89 00 00 54 28 00 80 52 E8 0B 00 B9 03 00 00 14 08 00 80 52 E8 0B 00 B9 E8 0B 40 B9 E8 0F 00 B9 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 33 00 B9 E9 33 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 33 00 F9 E9 33 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 A3 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 A7 00 00 14 E9 17 40 F9 08 00 80 52 28 01 00 79 E8 03 40 F9 1F 05 00 B1 20 04 00 54 E9 7B 40 B2 E8 03 40 F9 1F 01 09 EB A0 03 00 54 E9 03 40 F9 28 00 80 D2 1F 01 09 EB 22 03 00 54 ?? ?? ?? ?? E0 37 00 F9 E8 37 40 F9 E8 2B 00 F9 E8 03 40 F9 09 05 00 D1 E8 2B 40 F9 1F 01 09 EB 82 00 00 54 E8 2B 40 F9 E8 2F 00 F9 04 00 00 14 E8 03 40 F9 08 05 00 D1 E8 2F 00 F9 E9 2F 40 F9 48 00 80 D2 22 7D 08 9B E8 17 40 F9 00 09 00 91 42 00 00 91 C1 1F 80 52 00 00 00 91 ?? ?? ?? ?? E8 03 40 F9 1F 69 00 F1 83 00 00 54 28 00 80 52 E8 13 00 B9 03 00 00 14 08 00 80 52 E8 13 00 B9 E8 13 40 B9 E8 17 00 B9 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 22 04 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 37 00 B9 E9 37 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 3B 00 F9 E9 3B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 23 04 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 51 00 00 14 E8 27 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 1B 00 B9 03 00 00 14 08 00 80 52 E8 1B 00 B9 E8 1B 40 B9 E8 1F 00 B9 E8 1F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 04 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 3B 00 B9 E9 3B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 1F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 3F 00 F9 E9 3F 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 43 04 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 21 00 00 14 E8 27 40 F9 08 01 40 F9 1F 01 00 F1 0A 01 00 54 ?? ?? ?? ?? E0 43 00 F9 E9 43 40 F9 C8 02 80 52 28 01 00 B9 C0 02 80 52 16 00 00 14 E8 63 02 91 E8 47 00 F9 E1 23 01 91 E0 23 02 91 ?? ?? ?? ?? E0 3F 00 B9 E8 3F 40 B9 E8 23 00 B9 E8 23 40 B9 1F 01 00 71 60 00 00 54 E0 23 40 B9 09 00 00 14 E8 63 02 91 E8 4B 00 F9 E2 43 02 91 E1 03 00 91 E0 A3 00 91 ?? ?? ?? ?? E0 43 00 B9 E0 43 40 B9 FF 03 03 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_8_0 {
	meta:
		name = "??$localtime_s@PEAUtm@@AEBQEBJ@?$__crt_integer_traits@J@@SAH$$QEAPEAUtm@@AEBQEBJ@Z"
		size = 52
		refs = "0020 _localtime32_s"
		altNames = "??$localtime_s@AEBQEAUtm@@AEBQEBJ@?$__crt_integer_traits@J@@SAHAEBQEAUtm@@AEBQEBJ@Z ??$localtime_s@PEAUtm@@PEAJ@?$__crt_integer_traits@J@@SAH$$QEAPEAUtm@@$$QEAPEAJ@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 F9 E8 13 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_57_4_0 {
	meta:
		name = "??$gmtime_s@AEBQEAUtm@@AEBQEBJ@?$__crt_integer_traits@J@@SAHAEBQEAUtm@@AEBQEBJ@Z"
		size = 52
		refs = "0020 _gmtime32_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 F9 E8 13 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_57_5_2 {
	meta:
		name = "??$gmtime_s@AEBQEAUtm@@AEBQEB_J@?$__crt_integer_traits@_J@@SAHAEBQEAUtm@@AEBQEB_J@Z"
		size = 52
		refs = "0020 _gmtime64_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 F9 E8 13 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_57_6_3 {
	meta:
		name = "??$gmtime_s@AEBQEAUtm@@PEAJ@?$__crt_integer_traits@J@@SAHAEBQEAUtm@@$$QEAPEAJ@Z"
		size = 52
		refs = "0020 _gmtime32_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 F9 E8 13 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_57_7_3 {
	meta:
		name = "??$gmtime_s@AEBQEAUtm@@PEA_J@?$__crt_integer_traits@_J@@SAHAEBQEAUtm@@$$QEAPEA_J@Z"
		size = 52
		refs = "0020 _gmtime64_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 F9 E8 13 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_348_6_2 {
	meta:
		name = "??$gmtime_s@PEAUtm@@PEAJ@?$__crt_integer_traits@J@@SAH$$QEAPEAUtm@@$$QEAPEAJ@Z"
		size = 52
		refs = "0020 _gmtime32_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 F9 E8 13 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_348_7_2 {
	meta:
		name = "??$gmtime_s@PEAUtm@@PEA_J@?$__crt_integer_traits@_J@@SAH$$QEAPEAUtm@@$$QEAPEA_J@Z"
		size = 52
		refs = "0020 _gmtime64_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 F9 E8 13 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_57_9_2 {
	meta:
		name = "??$localtime_s@AEBQEAUtm@@AEBQEB_J@?$__crt_integer_traits@_J@@SAHAEBQEAUtm@@AEBQEB_J@Z"
		size = 52
		refs = "0020 _localtime64_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 F9 E8 13 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_9_3 {
	meta:
		name = "??$localtime_s@PEAUtm@@AEBQEB_J@?$__crt_integer_traits@_J@@SAH$$QEAPEAUtm@@AEBQEB_J@Z"
		size = 52
		refs = "0020 _localtime64_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 F9 E8 13 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_512_9_3 {
	meta:
		name = "??$localtime_s@PEAUtm@@PEA_J@?$__crt_integer_traits@_J@@SAH$$QEAPEAUtm@@$$QEAPEA_J@Z"
		size = 52
		refs = "0020 _localtime64_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 F9 E8 13 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_10_0 {
	meta:
		name = "??$tasctime@PEAUtm@@@?$__crt_char_traits@D@@SAPEAD$$QEAPEAUtm@@@Z"
		size = 40
		refs = "0014 asctime"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E8 0B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_11_0 {
	meta:
		name = "??$tasctime@PEAUtm@@@?$__crt_char_traits@_W@@SAPEA_W$$QEAPEAUtm@@@Z"
		size = 40
		refs = "0014 _wasctime"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E8 0B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_22_0 {
	meta:
		name = "??$tcslen@AEAPEAD@?$__crt_char_traits@D@@SA_KAEAPEAD@Z"
		size = 40
		refs = "0014 strlen"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E8 0B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_23_3 {
	meta:
		name = "??$tcslen@AEAPEA_W@?$__crt_char_traits@_W@@SA_KAEAPEA_W@Z"
		size = 40
		refs = "0014 wcslen"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E8 0B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_680_28_3 {
	meta:
		name = "??$tcslen@AEAPEBD@?$__crt_char_traits@D@@SA_KAEAPEBD@Z"
		size = 40
		refs = "0014 strlen"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E8 0B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_680_29_4 {
	meta:
		name = "??$tcslen@AEAPEB_W@?$__crt_char_traits@_W@@SA_KAEAPEB_W@Z"
		size = 40
		refs = "0014 wcslen"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E8 0B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_24_3 {
	meta:
		name = "??$tcslen@AEBQEAD@?$__crt_char_traits@D@@SA_KAEBQEAD@Z"
		size = 40
		refs = "0014 strlen"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E8 0B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_94_7_3 {
	meta:
		name = "??$tcslen@AEBQEA_W@?$__crt_char_traits@_W@@SA_KAEBQEA_W@Z"
		size = 40
		refs = "0014 wcslen"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E8 0B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_565_18_3 {
	meta:
		name = "??$tcslen@AEBQEBD@?$__crt_char_traits@D@@SA_KAEBQEBD@Z"
		size = 40
		refs = "0014 strlen"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E8 0B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_559_21_4 {
	meta:
		name = "??$tcslen@AEBQEB_W@?$__crt_char_traits@_W@@SA_KAEBQEB_W@Z"
		size = 40
		refs = "0014 wcslen"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E8 0B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_680_32_3 {
	meta:
		name = "??$tcslen@PEAD@?$__crt_char_traits@D@@SA_K$$QEAPEAD@Z"
		size = 40
		refs = "0014 strlen"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E8 0B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_680_33_0 {
	meta:
		name = "??$tcslen@PEA_W@?$__crt_char_traits@_W@@SA_K$$QEAPEA_W@Z"
		size = 40
		refs = "0014 wcslen"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E8 0B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_512_11_2 {
	meta:
		name = "??$time@PEA_J@?$__crt_integer_traits@_J@@SA_J$$QEAPEA_J@Z"
		size = 40
		refs = "0014 _time64"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E8 0B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_12_0 {
	meta:
		name = "??$tasctime_s@AEBQEADAEB_KPEAUtm@@@?$__crt_char_traits@D@@SAHAEBQEADAEB_K$$QEAPEAUtm@@@Z"
		size = 64
		refs = "002c asctime_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E8 0F 40 F9 02 01 40 F9 E8 13 40 F9 01 01 40 F9 E8 17 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_13_2 {
	meta:
		name = "??$tasctime_s@AEBQEA_WAEB_KPEAUtm@@@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_K$$QEAPEAUtm@@@Z"
		size = 64
		refs = "002c _wasctime_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E8 0F 40 F9 02 01 40 F9 E8 13 40 F9 01 01 40 F9 E8 17 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_424_19_0 {
	meta:
		name = "??$tcscat_s@AEBQEADAEB_KAEAPEAD@?$__crt_char_traits@D@@SAHAEBQEADAEB_KAEAPEAD@Z"
		size = 64
		refs = "002c strcat_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E8 0F 40 F9 02 01 40 F9 E8 13 40 F9 01 01 40 F9 E8 17 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_424_20_0 {
	meta:
		name = "??$tcscat_s@AEBQEADAEB_KAEBQEBD@?$__crt_char_traits@D@@SAHAEBQEADAEB_KAEBQEBD@Z"
		size = 64
		refs = "002c strcat_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E8 0F 40 F9 02 01 40 F9 E8 13 40 F9 01 01 40 F9 E8 17 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_424_21_0 {
	meta:
		name = "??$tcscat_s@AEBQEADAEB_KPEBD@?$__crt_char_traits@D@@SAHAEBQEADAEB_K$$QEAPEBD@Z"
		size = 64
		refs = "002c strcat_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E8 0F 40 F9 02 01 40 F9 E8 13 40 F9 01 01 40 F9 E8 17 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_424_22_4 {
	meta:
		name = "??$tcscat_s@AEBQEA_WAEB_KAEAPEA_W@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_KAEAPEA_W@Z"
		size = 64
		refs = "002c wcscat_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E8 0F 40 F9 02 01 40 F9 E8 13 40 F9 01 01 40 F9 E8 17 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_424_23_3 {
	meta:
		name = "??$tcscat_s@AEBQEA_WAEB_KAEBQEB_W@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_KAEBQEB_W@Z"
		size = 64
		refs = "002c wcscat_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E8 0F 40 F9 02 01 40 F9 E8 13 40 F9 01 01 40 F9 E8 17 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_424_24_3 {
	meta:
		name = "??$tcscat_s@AEBQEA_WAEB_KPEB_W@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_K$$QEAPEB_W@Z"
		size = 64
		refs = "002c wcscat_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E8 0F 40 F9 02 01 40 F9 E8 13 40 F9 01 01 40 F9 E8 17 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_18_0 {
	meta:
		name = "??$tcscpy_s@AEAPEADAEB_KAEBQEAD@?$__crt_char_traits@D@@SAHAEAPEADAEB_KAEBQEAD@Z"
		size = 64
		refs = "002c strcpy_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E8 0F 40 F9 02 01 40 F9 E8 13 40 F9 01 01 40 F9 E8 17 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_19_3 {
	meta:
		name = "??$tcscpy_s@AEAPEA_WAEB_KAEBQEA_W@?$__crt_char_traits@_W@@SAHAEAPEA_WAEB_KAEBQEA_W@Z"
		size = 64
		refs = "002c wcscpy_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E8 0F 40 F9 02 01 40 F9 E8 13 40 F9 01 01 40 F9 E8 17 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_20_2 {
	meta:
		name = "??$tcscpy_s@AEBQEADAEB_KAEBQEAD@?$__crt_char_traits@D@@SAHAEBQEADAEB_K0@Z"
		size = 64
		refs = "002c strcpy_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E8 0F 40 F9 02 01 40 F9 E8 13 40 F9 01 01 40 F9 E8 17 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_565_12_4 {
	meta:
		name = "??$tcscpy_s@AEBQEADAEB_KAEBQEBD@?$__crt_char_traits@D@@SAHAEBQEADAEB_KAEBQEBD@Z"
		size = 64
		refs = "002c strcpy_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E8 0F 40 F9 02 01 40 F9 E8 13 40 F9 01 01 40 F9 E8 17 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_424_27_2 {
	meta:
		name = "??$tcscpy_s@AEBQEADAEB_KPEBD@?$__crt_char_traits@D@@SAHAEBQEADAEB_K$$QEAPEBD@Z"
		size = 64
		refs = "002c strcpy_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E8 0F 40 F9 02 01 40 F9 E8 13 40 F9 01 01 40 F9 E8 17 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_21_3 {
	meta:
		name = "??$tcscpy_s@AEBQEA_WAEB_KAEBQEA_W@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_K0@Z"
		size = 64
		refs = "002c wcscpy_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E8 0F 40 F9 02 01 40 F9 E8 13 40 F9 01 01 40 F9 E8 17 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_565_13_0 {
	meta:
		name = "??$tcscpy_s@AEBQEA_WAEB_KAEBQEB_W@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_KAEBQEB_W@Z"
		size = 64
		refs = "002c wcscpy_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E8 0F 40 F9 02 01 40 F9 E8 13 40 F9 01 01 40 F9 E8 17 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_424_28_0 {
	meta:
		name = "??$tcscpy_s@AEBQEA_WAEB_KPEB_W@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_K$$QEAPEB_W@Z"
		size = 64
		refs = "002c wcscpy_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E8 0F 40 F9 02 01 40 F9 E8 13 40 F9 01 01 40 F9 E8 17 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_14_0 {
	meta:
		name = "_ctime32"
		size = 36
		refs = "0010 ??$common_ctime@JD@@YAPEADQEBJ@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_53_13_3 {
	meta:
		name = "??$__crt_interlocked_read_pointer@UHINSTANCE__@@@@YAPEAUHINSTANCE__@@PEDSEAU0@@Z"
		size = 36
		refs = "0010 ?__crt_interlocked_read_64@@YA_JPED_J@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_53_14_0 {
	meta:
		name = "??$__crt_interlocked_read_pointer@X@@YAPEAXPEDSEAX@Z"
		size = 36
		refs = "0010 ?__crt_interlocked_read_64@@YA_JPED_J@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_241_2 {
	meta:
		name = "??$scratch_count@D@formatting_buffer@__crt_stdio_output@@QEBA_KXZ"
		size = 36
		refs = "0010 ??$count@D@formatting_buffer@__crt_stdio_output@@QEBA_KXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_424_29_0 {
	meta:
		name = "??$tcslen@AEAY0BAF@D@?$__crt_char_traits@D@@SA_KAEAY0BAF@D@Z"
		size = 36
		refs = "0010 strlen"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_424_30_4 {
	meta:
		name = "??$tcslen@AEAY0BAF@_W@?$__crt_char_traits@_W@@SA_KAEAY0BAF@_W@Z"
		size = 36
		refs = "0010 wcslen"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_565_34_4 {
	meta:
		name = "__wcserror"
		size = 36
		refs = "0010 ??$common_strerror@_W@@YAPEA_WQEB_W@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_16_3 {
	meta:
		name = "_ctime64"
		size = 36
		refs = "0010 ??$common_ctime@_JD@@YAPEADQEB_J@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_630_14_4 {
	meta:
		name = "_gmtime32"
		size = 36
		refs = "0010 ??$common_gmtime@J@@YAPEAUtm@@QEBJ@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_630_16_3 {
	meta:
		name = "_gmtime64"
		size = 36
		refs = "0010 ??$common_gmtime@_J@@YAPEAUtm@@QEB_J@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_57_11_3 {
	meta:
		name = "_localtime32"
		size = 36
		refs = "0010 ??$common_localtime@J@@YAPEAUtm@@QEBJ@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_57_13_0 {
	meta:
		name = "_localtime64"
		size = 36
		refs = "0010 ??$common_localtime@_J@@YAPEAUtm@@QEB_J@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_94_12_3 {
	meta:
		name = "_mktemp"
		size = 36
		refs = "0010 ??$common_mktemp@D@@YAPEADQEAD@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_615_4_4 {
	meta:
		name = "_strdate"
		size = 36
		refs = "0010 ??$common_strdate@D@@YAPEADQEAD@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_565_38_0 {
	meta:
		name = "_strerror"
		size = 36
		refs = "0010 ??$common_strerror@D@@YAPEADQEBD@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_652_4_2 {
	meta:
		name = "_strtime"
		size = 36
		refs = "0010 ??$common_strtime@D@@YAPEADQEAD@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_436_5_0 {
	meta:
		name = "_time64"
		size = 36
		refs = "0010 ??$common_time@_J@@YA_JQEA_J@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_530_22_3 {
	meta:
		name = "_wasctime"
		size = 36
		refs = "0010 ??$common_asctime@_W@@YAPEA_WQEBUtm@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_18_4 {
	meta:
		name = "_wctime32"
		size = 36
		refs = "0010 ??$common_ctime@J_W@@YAPEA_WQEBJ@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_20_2 {
	meta:
		name = "_wctime64"
		size = 36
		refs = "0010 ??$common_ctime@_J_W@@YAPEA_WQEB_J@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_94_14_4 {
	meta:
		name = "_wmktemp"
		size = 36
		refs = "0010 ??$common_mktemp@_W@@YAPEA_WQEA_W@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_615_6_2 {
	meta:
		name = "_wstrdate"
		size = 36
		refs = "0010 ??$common_strdate@_W@@YAPEA_WQEA_W@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_652_6_4 {
	meta:
		name = "_wstrtime"
		size = 36
		refs = "0010 ??$common_strtime@_W@@YAPEA_WQEA_W@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_458_1_4 {
	meta:
		name = "abort"
		size = 104
		refs = "0008 __abort_behavior 0014 ??_C@_1DA@LLLMNMKI@?$AAa?$AAb?$AAo?$AAr?$AAt?$AA?$CI?$AA?$CJ?$AA?5?$AAh?$AAa?$AAs?$AA?5?$AAb?$AAe?$AAe?$AAn?$AA?5?$AAc?$AAa?$AAl?$AAl?$AAe?$AAd?$AA?$AA@ 001c __acrt_report_runtime_error 0020 __acrt_get_sigabrt_handler 0040 raise 005c _exit"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 88 00 00 36 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 0B 00 F9 E8 0B 40 F9 E8 0F 00 F9 E8 0F 40 F9 1F 01 00 F1 60 00 00 54 C0 02 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 68 00 08 36 E0 00 80 52 60 00 3E D4 60 00 80 52 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_530_24_4 {
	meta:
		name = "asctime"
		size = 36
		refs = "0010 ??$common_asctime@D@@YAPEADQEBUtm@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_15_0 {
	meta:
		name = "_ctime32_s"
		size = 52
		refs = "0020 ??$common_ctime_s@JD@@YAHQEAD_KQEBJ@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_565_35_2 {
	meta:
		name = "__wcserror_s"
		size = 52
		refs = "0020 ??$common_strerror_s@_W@@YAHQEA_W_KQEB_W@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_17_0 {
	meta:
		name = "_ctime64_s"
		size = 52
		refs = "0020 ??$common_ctime_s@_JD@@YAHQEAD_KQEB_J@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_565_39_0 {
	meta:
		name = "_strerror_s"
		size = 52
		refs = "0020 ??$common_strerror_s@D@@YAHQEAD_KQEBD@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_530_23_3 {
	meta:
		name = "_wasctime_s"
		size = 52
		refs = "0020 ??$common_asctime_s@_W@@YAHQEA_W_KQEBUtm@@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_19_0 {
	meta:
		name = "_wctime32_s"
		size = 52
		refs = "0020 ??$common_ctime_s@J_W@@YAHQEA_W_KQEBJ@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_4_21_4 {
	meta:
		name = "_wctime64_s"
		size = 52
		refs = "0020 ??$common_ctime_s@_J_W@@YAHQEA_W_KQEB_J@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_629_13_3 {
	meta:
		name = "_wfopen_s"
		size = 52
		refs = "0020 ??$common_fopen_s@_W@@YAHQEAPEAU_iobuf@@QEB_W1@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_530_25_0 {
	meta:
		name = "asctime_s"
		size = 52
		refs = "0020 ??$common_asctime_s@D@@YAHQEAD_KQEBUtm@@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_629_16_2 {
	meta:
		name = "fopen_s"
		size = 52
		refs = "0020 ??$common_fopen_s@D@@YAHQEAPEAU_iobuf@@QEBD1@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_161_1_0 {
	meta:
		name = "strcat_s"
		size = 52
		refs = "0020 ??$common_tcscat_s@D@@YAHQEAD_KQEBD@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_682_1_4 {
	meta:
		name = "strcpy_s"
		size = 52
		refs = "0020 ??$common_tcscpy_s@D@@YAHQEAD_KQEBD@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_556_1_0 {
	meta:
		name = "wcscat_s"
		size = 52
		refs = "0020 ??$common_tcscat_s@_W@@YAHQEA_W_KQEB_W@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_470_1_4 {
	meta:
		name = "wcscpy_s"
		size = 52
		refs = "0020 ??$common_tcscpy_s@_W@@YAHQEA_W_KQEB_W@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
		size = 416
		refs = "0064 __acrt_locale_changed 0088 __acrt_initial_locale_pointers 00a0 __acrt_getptd 011c __acrt_update_locale_info 013c __acrt_update_multibyte_info"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 0F 00 F9 E1 13 00 F9 E8 0F 40 F9 09 61 00 91 08 00 80 52 28 01 00 39 E8 13 40 F9 1F 01 00 F1 E0 01 00 54 EA C3 00 91 4A 01 00 91 E8 13 40 F9 08 01 00 91 09 21 40 A9 49 21 00 A9 E8 0F 40 F9 0A 21 00 91 4A 01 00 91 E8 C3 00 91 08 01 00 91 09 21 40 A9 49 21 00 A9 4D 00 00 14 ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 41 01 00 54 E8 0F 40 F9 0A 21 00 91 4A 01 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 08 01 00 91 09 21 40 A9 49 21 00 A9 3E 00 00 14 ?? ?? ?? ?? E0 17 00 F9 E8 0F 40 F9 09 01 00 91 E8 17 40 F9 28 01 00 F9 E8 0F 40 F9 08 01 00 91 08 01 40 F9 0A 41 02 91 E8 0F 40 F9 08 21 00 91 09 01 00 91 48 01 40 F9 28 01 00 F9 E8 0F 40 F9 08 01 00 91 08 01 40 F9 0A 21 02 91 E8 0F 40 F9 08 21 00 91 09 21 00 91 48 01 40 F9 28 01 00 F9 E8 0F 40 F9 08 21 00 91 01 01 00 91 E8 0F 40 F9 08 01 00 91 21 00 00 91 00 01 40 F9 ?? ?? ?? ?? E8 0F 40 F9 08 21 00 91 01 21 00 91 E8 0F 40 F9 08 01 00 91 21 00 00 91 00 01 40 F9 ?? ?? ?? ?? E8 0F 40 F9 08 01 00 91 08 01 40 F9 08 A1 0E 91 08 01 40 B9 08 02 08 37 E8 0F 40 F9 08 01 00 91 08 01 40 F9 08 A1 0E 91 08 01 40 B9 09 01 1F 32 E8 0F 40 F9 08 01 00 91 08 01 40 F9 08 A1 0E 91 09 01 00 B9 E8 0F 40 F9 09 61 00 91 28 00 80 52 28 01 00 39 E0 0F 40 F9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_5_1_0 {
	meta:
		name = "??1_LocaleUpdate@@QEAA@XZ"
		size = 84
	strings:
		$1 = { FF 43 00 D1 E0 03 00 F9 E8 03 40 F9 08 61 00 91 08 01 40 39 08 01 00 11 1F 01 00 71 80 01 00 54 E8 03 40 F9 08 01 00 91 08 01 40 F9 08 A1 0E 91 08 01 40 B9 09 79 1E 12 E8 03 40 F9 08 01 00 91 08 01 40 F9 08 A1 0E 91 09 01 00 B9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_5_2_0 {
	meta:
		name = "?GetLocaleT@_LocaleUpdate@@QEAAPEAU__crt_locale_pointers@@XZ"
		size = 28
	strings:
		$1 = { FF 43 00 D1 E0 03 00 F9 E8 03 40 F9 00 21 00 91 00 00 00 91 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_5_3_0 {
	meta:
		name = "__acrt_locale_changed"
		size = 60
		refs = "0004 __acrt_locale_changed_data"
	strings:
		$1 = { FF 43 00 D1 ?? ?? ?? ?? ?? ?? ?? ?? 1F 01 00 71 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 00 1D 00 53 00 00 00 11 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_5_4_0 {
	meta:
		name = "__ascii_stricmp"
		size = 224
	strings:
		$1 = { FF 83 00 D1 E0 0B 00 F9 E1 0F 00 F9 E8 0B 40 F9 08 01 C0 39 08 1D 00 53 08 01 00 11 E8 03 00 B9 E8 03 40 B9 E8 0B 00 B9 E8 0B 40 F9 08 05 00 91 E8 0B 00 F9 E8 0B 40 B9 1F 05 01 71 0B 01 00 54 E8 03 40 B9 1F 69 01 71 AC 00 00 54 E9 03 40 B9 E8 03 80 12 28 01 08 4B E8 03 00 B9 E8 0F 40 F9 08 01 C0 39 08 1D 00 53 08 01 00 11 E8 07 00 B9 E8 07 40 B9 E8 0F 00 B9 E8 0F 40 F9 08 05 00 91 E8 0F 00 F9 E8 0F 40 B9 1F 05 01 71 0B 01 00 54 E8 07 40 B9 1F 69 01 71 AC 00 00 54 E9 07 40 B9 E8 03 80 12 28 01 08 4B E8 07 00 B9 E8 03 40 B9 1F 01 00 71 A0 00 00 54 E9 07 40 B9 E8 03 40 B9 1F 01 09 6B 40 FA FF 54 E9 03 40 B9 E8 07 40 B9 20 01 08 4B 00 00 00 11 FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_5_5_0 {
	meta:
		name = "_stricmp"
		size = 484
		refs = "0010 __acrt_locale_changed 005c ??_C@_1BO@GCPMHDON@?$AAd?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0064 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0074 ??_C@_1GE@JNJGLDHA@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0080 _CrtDbgReportW 00a8 _errno 00cc ??_C@_1BC@JLGKKIIG@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAc?$AAm?$AAp?$AA?$AA@ 00dc _invalid_parameter 011c ??_C@_1BO@NEBGDLJE@?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01b0 __ascii_stricmp 01d0 _stricmp_l"
	strings:
		$1 = { FD 7B BA A9 FD 03 00 91 E0 23 00 F9 E1 1F 00 F9 ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 01 0D 00 54 E8 23 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 17 00 B9 03 00 00 14 08 00 80 52 E8 17 00 B9 E8 17 40 B9 E8 1B 00 B9 E8 1B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 0B 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 27 00 B9 E9 27 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 1B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 27 00 F9 E9 27 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 0B 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 B0 12 3E 00 00 14 E8 1F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 1F 00 B9 03 00 00 14 08 00 80 52 E8 1F 00 B9 E8 1F 40 B9 E8 23 00 B9 E8 23 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 02 0C 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 2B 00 B9 E9 2B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 23 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 2B 00 F9 E9 2B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 03 0C 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 B0 12 0E 00 00 14 E1 1F 40 F9 E0 23 40 F9 ?? ?? ?? ?? E0 2F 00 B9 E0 2F 40 B9 08 00 00 14 07 00 00 14 02 00 80 D2 E1 1F 40 F9 E0 23 40 F9 ?? ?? ?? ?? E0 33 00 B9 E0 33 40 B9 FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_5_6_0 {
	meta:
		name = "_stricmp_l"
		size = 736
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0058 ??_C@_1BO@GCPMHDON@?$AAd?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0060 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0070 ??_C@_1GE@JNJGLDHA@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 007c _CrtDbgReportW 00a4 _errno 00c8 ??_C@_1BG@GLLONOEH@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAc?$AAm?$AAp?$AA_?$AAl?$AA?$AA@ 00d8 _invalid_parameter 00e8 ??1_LocaleUpdate@@QEAA@XZ 0128 ??_C@_1BO@NEBGDLJE@?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01c8 ?GetLocaleT@_LocaleUpdate@@QEAAPEAU__crt_locale_pointers@@XZ 01f4 __ascii_stricmp 0240 _tolower_l"
	strings:
		$1 = { FD 7B B4 A9 FD 03 00 91 E0 17 00 F9 E1 1B 00 F9 E2 37 00 F9 E1 37 40 F9 E0 63 02 91 ?? ?? ?? ?? E0 5F 00 F9 E8 17 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 17 00 B9 03 00 00 14 08 00 80 52 E8 17 00 B9 E8 17 40 B9 E8 1B 00 B9 E8 1B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 22 06 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 3B 00 B9 E9 3B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 1B 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 3B 00 F9 E9 3B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 23 06 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 08 00 B0 12 E8 3F 00 B9 E0 63 02 91 ?? ?? ?? ?? E0 3F 40 B9 7A 00 00 14 E8 1B 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 1F 00 B9 03 00 00 14 08 00 80 52 E8 1F 00 B9 E8 1F 40 B9 E8 23 00 B9 E8 23 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 06 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 43 00 B9 E9 43 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 23 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 3F 00 F9 E9 3F 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 43 06 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 08 00 B0 12 E8 47 00 B9 E0 63 02 91 ?? ?? ?? ?? E0 47 40 B9 46 00 00 14 E0 63 02 91 ?? ?? ?? ?? E0 43 00 F9 E8 43 40 F9 08 01 00 91 08 01 40 F9 08 E1 04 91 08 01 40 F9 1F 01 00 F1 81 01 00 54 E1 1B 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 4B 00 B9 E8 4B 40 B9 E8 4F 00 B9 E0 63 02 91 ?? ?? ?? ?? E0 4F 40 B9 32 00 00 14 2A 00 00 14 E0 63 02 91 ?? ?? ?? ?? E0 47 00 F9 E8 17 40 F9 08 01 C0 39 08 1D 00 53 08 01 00 11 E8 53 00 B9 E1 47 40 F9 E0 53 40 B9 ?? ?? ?? ?? E0 57 00 B9 E8 57 40 B9 E8 13 00 B9 E8 17 40 F9 08 05 00 91 E8 17 00 F9 E0 63 02 91 ?? ?? ?? ?? E0 4B 00 F9 E8 1B 40 F9 08 01 C0 39 08 1D 00 53 08 01 00 11 E8 5B 00 B9 E1 4B 40 F9 E0 5B 40 B9 ?? ?? ?? ?? E0 5F 00 B9 E8 5F 40 B9 E8 27 00 B9 E8 1B 40 F9 08 05 00 91 E8 1B 00 F9 E8 13 40 B9 1F 01 00 71 A0 00 00 54 E9 27 40 B9 E8 13 40 B9 1F 01 09 6B 00 FB FF 54 E9 13 40 B9 E8 27 40 B9 28 01 08 4B E8 63 00 B9 E0 63 02 91 ?? ?? ?? ?? E0 63 40 B9 FD 7B CC A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "_cabs"
		size = 44
		refs = "0018 _hypot"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 FD E1 13 00 FD E1 13 40 FD E0 0F 40 FD ?? ?? ?? ?? E0 0B 00 FD E0 0B 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "strcspn"
		size = 448
		refs = "0008 __security_push_cookie 0068 __report_rangecheckfailure 01b4 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 43 01 D1 E0 13 00 F9 E1 17 00 F9 E8 13 40 F9 E8 0B 00 F9 E8 17 40 F9 E8 07 00 F9 08 00 80 52 E8 03 00 B9 04 00 00 14 E8 03 40 B9 08 05 00 11 E8 03 00 B9 E8 03 40 B9 1F 81 00 71 EA 01 00 54 E8 03 40 B9 08 7D 40 93 E8 0F 00 F9 E8 0F 40 F9 1F 81 00 F1 42 00 00 54 02 00 00 14 ?? ?? ?? ?? E9 C3 00 91 E8 0F 40 F9 29 01 08 8B 08 00 80 52 28 01 00 39 ED FF FF 17 E8 07 40 F9 08 01 40 39 08 01 00 11 1F 01 00 71 40 04 00 54 E8 07 40 F9 08 01 40 39 08 01 00 11 08 7D 03 13 09 7D 40 93 28 00 80 D2 29 7D 08 9B E8 C3 00 91 0A 01 09 8B E8 07 40 F9 08 01 40 39 08 01 00 11 09 09 00 12 28 00 80 52 09 21 C9 1A 48 01 40 39 08 01 00 11 0A 01 09 2A E8 07 40 F9 08 01 40 39 08 01 00 11 08 7D 03 13 09 7D 40 93 28 00 80 D2 29 7D 08 9B E8 C3 00 91 09 01 09 8B 48 1D 00 53 28 01 00 39 E8 07 40 F9 08 05 00 91 E8 07 00 F9 DB FF FF 17 08 00 80 52 E8 03 00 B9 E8 C3 40 39 08 01 00 11 08 01 00 32 08 1D 00 53 E8 C3 00 39 E8 0B 40 F9 08 01 40 39 08 01 00 11 08 7D 03 13 09 7D 40 93 28 00 80 D2 29 7D 08 9B E8 C3 00 91 08 01 09 8B 0A 01 40 39 4A 01 00 11 E8 0B 40 F9 08 01 40 39 08 01 00 11 09 09 00 12 28 00 80 52 08 21 C9 1A 48 01 08 0A 1F 01 00 71 01 01 00 54 E8 03 40 B9 08 05 00 11 E8 03 00 B9 E8 0B 40 F9 08 05 00 91 E8 0B 00 F9 E6 FF FF 17 E8 03 40 B9 00 7D 40 93 00 00 00 91 FF 43 01 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "fetestexcept"
		size = 52
		refs = "001c fegetexceptflag"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 17 00 B9 08 00 80 52 E8 13 00 B9 E1 17 40 B9 E0 43 00 91 ?? ?? ?? ?? E8 13 40 B9 00 11 00 12 00 00 00 11 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "_getpid"
		size = 36
		refs = "0008 __imp_GetCurrentProcessId"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "??$__crt_interlocked_read@H@@YAHPEDH@Z"
		size = 36
		refs = "0010 ?__crt_interlocked_read_32@@YAHPEDH@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_424_0_3 {
	meta:
		name = "??$__crt_interlocked_read@J@@YAJPEDJ@Z"
		size = 36
		refs = "0010 ?__crt_interlocked_read_32@@YAHPEDH@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_660_6_2 {
	meta:
		name = "?appmodel_get_policy@begin_thread_init_policy_properties@?1??__acrt_get_begin_thread_init_policy@@YA?AW4begin_thread_init_policy@@XZ@SAJPEAW4AppPolicyThreadInitializationType@@@Z"
		size = 36
		refs = "0010 __acrt_AppPolicyGetThreadInitializationTypeInternal"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_660_7_2 {
	meta:
		name = "?appmodel_get_policy@developer_information_policy_properties@?1??__acrt_get_developer_information_policy@@YA?AW4developer_information_policy@@XZ@SAJPEAW4AppPolicyShowDeveloperDiagnostic@@@Z"
		size = 36
		refs = "0010 __acrt_AppPolicyGetShowDeveloperDiagnosticInternal"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_660_8_0 {
	meta:
		name = "?appmodel_get_policy@process_end_policy_properties@?1??__acrt_get_process_end_policy@@YA?AW4process_end_policy@@XZ@SAJPEAW4AppPolicyProcessTerminationMethod@@@Z"
		size = 36
		refs = "0010 __acrt_AppPolicyGetProcessTerminationMethodInternal"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_660_9_4 {
	meta:
		name = "?appmodel_get_policy@windowing_model_policy_properties@?1??__acrt_get_windowing_model_policy@@YA?AW4windowing_model_policy@@XZ@SAJPEAW4AppPolicyWindowingModel@@@Z"
		size = 36
		refs = "0010 __acrt_AppPolicyGetWindowingModelInternal"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_179_9_0 {
	meta:
		name = "__acrt_initialize_new_handler"
		size = 36
		refs = "0010 ?__acrt_new_handler@@3V?$dual_state_global@P6AH_K@Z@__crt_state_management@@A 0018 ?initialize@?$dual_state_global@P6AH_K@Z@__crt_state_management@@QEAAXQ6AH_K@Z@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E1 0B 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_553_7_4 {
	meta:
		name = "__acrt_initialize_user_matherr"
		size = 36
		refs = "0010 ?user_matherr@@3V?$dual_state_global@P6AHPEAU_exception@@@Z@__crt_state_management@@A 0018 ?initialize@?$dual_state_global@P6AHPEAU_exception@@@Z@__crt_state_management@@QEAAXQ6AHPEAU_exception@@@Z@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E1 0B 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_447_65_0 {
	meta:
		name = "__threadid"
		size = 36
		refs = "0008 __imp_GetCurrentThreadId"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_523_3_4 {
	meta:
		name = "_ftime32_s"
		size = 36
		refs = "0010 ??$common_ftime_s@JU__timeb32@@@@YAHQEAU__timeb32@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_523_5_4 {
	meta:
		name = "_ftime64_s"
		size = 36
		refs = "0010 ??$common_ftime_s@_JU__timeb64@@@@YAHQEAU__timeb64@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_115_10_3 {
	meta:
		name = "_getc_nolock"
		size = 36
		refs = "0010 _fgetc_nolock"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_436_4_4 {
	meta:
		name = "_time32"
		size = 36
		refs = "0010 ??$common_time@J@@YAJQEAJ@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_380_6_4 {
	meta:
		name = "_unlink"
		size = 36
		refs = "0010 remove"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_215_1_0 {
	meta:
		name = "_wunlink"
		size = 36
		refs = "0010 _wremove"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_115_13_0 {
	meta:
		name = "getc"
		size = 36
		refs = "0010 fgetc"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "_reduce"
		size = 72
		refs = "001c _frnd"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 FD 11 10 66 1E F0 0B 40 FD 20 0A 70 1E 00 40 60 1E ?? ?? ?? ?? E0 0F 00 FD F1 00 00 5C F0 0F 40 FD 20 0A 70 1E 00 40 60 1E FD 7B C2 A8 C0 03 5F D6 1F 20 03 D5 00 00 00 00 00 00 B0 3F }
	condition:
		$1
}

rule file_10_1_0 {
	meta:
		name = "pow"
		size = 3424
		refs = "0018 _ctrlfp 0034 _fpclass 00a0 _d_inttype 00cc _d_inf 00d4 _copysign 011c _except2 0294 _handle_qnan2 02b0 _powhlp 0360 _d_ind 03ac ymax 04b4 _decomp 0580 _get_exp 0638 a1 0730 log 073c log2inv 07a0 a2 0808 p4 0818 p3 082c p2 0840 p1 0860 K 08c8 _reduce 09ac _ovfx 0a00 _uflx 0adc q7 0aec q6 0b00 q5 0b14 q4 0b28 q3 0b3c q2 0b50 q1 0bf8 _set_exp"
	strings:
		$1 = { FD 7B A1 A9 FD 03 00 91 E0 13 00 FD E1 0B 00 FD 81 69 00 58 00 E0 93 D2 ?? ?? ?? ?? E0 93 00 F9 E8 93 40 F9 E8 17 00 F9 F0 13 40 FD F0 27 00 FD E0 0B 40 FD ?? ?? ?? ?? E0 C3 00 B9 E8 C3 40 B9 08 05 1B 12 1F 01 00 71 C0 00 00 54 A1 67 00 58 E0 17 40 F9 ?? ?? ?? ?? 00 10 6E 1E 37 03 00 14 E0 13 40 FD ?? ?? ?? ?? E0 C7 00 B9 E8 C7 40 B9 08 05 1B 12 1F 01 00 71 00 08 00 54 E8 2F 40 79 08 01 00 11 09 2D 1D 12 08 FF 8F 52 3F 01 08 6B 61 00 00 54 E0 0B 40 FD 28 03 00 14 E0 0B 40 FD ?? ?? ?? ?? E0 CB 00 B9 E8 CB 40 B9 E8 93 00 B9 F0 0B 40 FD 08 22 60 1E C2 03 00 54 E8 93 40 B9 1F 05 00 71 21 01 00 54 E1 13 40 FD ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 97 00 FD F0 97 40 FD F0 7F 00 FD 04 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? F0 7F 00 FD F0 7F 40 FD F0 37 00 FD E8 17 40 F9 02 01 7F B2 42 00 00 91 E2 37 40 FD E1 0B 40 FD E0 27 40 FD A1 03 80 52 80 00 80 52 ?? ?? ?? ?? E0 9B 00 FD E0 9B 40 FD 04 03 00 14 13 00 00 14 F0 0B 40 FD 08 22 60 1E 0D 02 00 54 E8 93 40 B9 1F 05 00 71 81 00 00 54 F0 13 40 FD F0 83 00 FD 03 00 00 14 B0 5F 00 5C F0 83 00 FD F0 83 40 FD F0 37 00 FD E1 5E 00 58 E0 17 40 F9 ?? ?? ?? ?? E0 37 40 FD F1 02 00 14 E8 4F 40 79 08 01 00 11 09 29 1C 12 08 FE 8F 52 3F 01 08 6B E0 00 00 54 E8 2F 40 79 08 01 00 11 09 29 1C 12 08 FE 8F 52 3F 01 08 6B E1 0A 00 54 E8 4F 40 79 08 01 00 11 09 2D 1D 12 08 FE 8F 52 3F 01 08 6B 01 01 00 54 E8 27 40 B9 08 49 13 53 1F 01 00 71 21 02 00 54 E8 23 40 B9 1F 01 00 71 C1 01 00 54 E8 2F 40 79 08 01 00 11 09 2D 1D 12 08 FE 8F 52 3F 01 08 6B A1 02 00 54 E8 17 40 B9 08 49 13 53 1F 01 00 71 81 00 00 54 E8 13 40 B9 1F 01 00 71 C0 01 00 54 F1 13 40 FD F0 0B 40 FD 22 2A 70 1E E2 17 40 F9 42 40 60 1E E1 0B 40 FD E0 27 40 FD A1 03 80 52 00 01 80 52 ?? ?? ?? ?? E0 9F 00 FD E0 9F 40 FD BE 02 00 14 11 10 6E 1E F0 13 40 FD 00 22 71 1E 61 00 00 54 00 10 6E 1E B8 02 00 14 E8 4F 40 79 08 01 00 11 09 2D 1D 12 08 FF 8F 52 3F 01 08 6B E0 00 00 54 E8 2F 40 79 08 01 00 11 09 2D 1D 12 08 FF 8F 52 3F 01 08 6B E1 00 00 54 E1 0B 40 FD E0 13 40 FD ?? ?? ?? ?? E0 A3 00 FD E0 A3 40 FD A6 02 00 14 E0 A3 01 91 E1 0B 40 FD E0 13 40 FD ?? ?? ?? ?? E0 CF 00 B9 E8 CF 40 B9 1F 01 00 71 60 01 00 54 E2 17 40 F9 E2 37 40 FD E1 0B 40 FD E0 27 40 FD A1 03 80 52 00 01 80 52 ?? ?? ?? ?? E0 A7 00 FD E0 A7 40 FD 94 02 00 14 A1 52 00 58 E0 17 40 F9 ?? ?? ?? ?? E0 37 40 FD 8F 02 00 14 10 10 6E 1E F0 23 00 FD F0 13 40 FD 08 22 60 1E C2 03 00 54 E0 0B 40 FD ?? ?? ?? ?? E0 D3 00 B9 E8 D3 40 B9 E8 97 00 B9 E8 97 40 B9 1F 05 00 71 A0 00 00 54 E8 97 40 B9 1F 09 00 71 80 00 00 54 07 00 00 14 10 10 7E 1E F0 23 00 FD F0 13 40 FD 10 42 61 1E F0 13 00 FD 0C 00 00 14 E2 17 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? E1 0B 40 FD E0 27 40 FD A1 03 80 52 00 01 80 52 ?? ?? ?? ?? E0 AB 00 FD E0 AB 40 FD 6D 02 00 14 F0 0B 40 FD 08 22 60 1E A2 00 00 54 F0 0B 40 FD 10 42 61 1E F0 87 00 FD 03 00 00 14 F0 0B 40 FD F0 87 00 FD ?? ?? ?? ?? ?? ?? ?? ?? F0 87 40 FD 00 22 71 1E 8D 07 00 54 F0 0B 40 FD 08 22 60 1E 02 01 00 54 F0 0B 40 FD 10 42 61 1E F0 0B 00 FD 11 10 6E 1E F0 13 40 FD 30 1A 70 1E F0 13 00 FD 11 10 6E 1E F0 13 40 FD 00 22 71 1E 4D 02 00 54 E8 17 40 F9 02 01 7E B2 F1 23 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 22 0A 70 1E 42 00 00 91 42 40 60 1E E1 0B 40 FD E0 27 40 FD A1 03 80 52 20 02 80 52 ?? ?? ?? ?? E0 AF 00 FD E0 AF 40 FD 41 02 00 14 1D 00 00 14 11 10 6E 1E F0 13 40 FD 00 22 71 1E 22 02 00 54 E8 17 40 F9 02 01 7D B2 F1 23 40 FD 90 47 00 5C 22 0A 70 1E 42 00 00 91 42 40 60 1E E1 0B 40 FD E0 27 40 FD A1 03 80 52 40 02 80 52 ?? ?? ?? ?? E0 B3 00 FD E0 B3 40 FD 2D 02 00 14 09 00 00 14 A1 45 00 58 E0 17 40 F9 ?? ?? ?? ?? F1 23 40 FD 10 10 6E 1E 20 0A 70 1E 00 40 60 1E 24 02 00 14 E0 73 01 91 E0 13 40 FD ?? ?? ?? ?? E0 B7 00 FD F0 B7 40 FD F0 3F 00 FD 71 44 00 5C F0 0B 40 FD 00 22 71 1E 08 0B 00 54 E0 13 40 FD ?? ?? ?? ?? E0 D7 00 B9 E8 D7 40 B9 1F 01 00 71 40 0A 00 54 E0 0B 40 FD ?? ?? ?? ?? E0 DB 00 B9 E8 DB 40 B9 1F 01 00 71 80 09 00 54 F0 0B 40 FD 08 22 60 1E 2D 09 00 54 F0 0B 40 FD 08 02 78 1E E8 5B 00 B9 E9 5F 40 B9 E8 5B 40 B9 28 7D 08 1B E8 73 00 B9 10 10 6E 1E F0 2B 00 FD 08 00 00 14 E8 5B 40 B9 08 7D 01 13 E8 5B 00 B9 F1 3F 40 FD F0 3F 40 FD 30 0A 70 1E F0 3F 00 FD E8 5B 40 B9 1F 01 00 71 00 01 00 54 E8 5B 40 B9 A8 00 00 36 F1 2B 40 FD F0 3F 40 FD 30 0A 70 1E F0 2B 00 FD F0 FF FF 17 E0 2B 40 FD ?? ?? ?? ?? E0 DF 00 B9 E9 DF 40 B9 E8 73 40 B9 28 01 08 0B E8 33 00 B9 E8 33 40 B9 1F 01 28 71 2D 02 00 54 F1 23 40 FD F0 2B 40 FD 31 0A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? 22 0A 70 1E E2 17 40 F9 42 40 60 1E E1 0B 40 FD E0 27 40 FD A1 03 80 52 20 02 80 52 ?? ?? ?? ?? E0 BB 00 FD E0 BB 40 FD D6 01 00 14 E8 33 40 B9 1F F5 27 31 0A 02 00 54 F1 23 40 FD F0 2B 40 FD 31 0A 70 1E 70 3A 00 5C 22 0A 70 1E E2 17 40 F9 42 40 60 1E E1 0B 40 FD E0 27 40 FD A1 03 80 52 40 02 80 52 ?? ?? ?? ?? E0 BF 00 FD E0 BF 40 FD C4 01 00 14 6C 01 00 14 28 00 80 52 E8 1B 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? F0 3F 40 FD 00 22 71 1E 68 00 00 54 28 01 80 52 E8 1B 00 B9 E8 1B 40 B9 08 11 00 11 09 7D 40 93 08 01 80 D2 29 7D 08 9B ?? ?? ?? ?? ?? ?? ?? ?? 08 01 09 8B 11 01 40 FD F0 3F 40 FD 00 22 71 1E 88 00 00 54 E8 1B 40 B9 08 11 00 11 E8 1B 00 B9 E8 1B 40 B9 08 09 00 11 09 7D 40 93 08 01 80 D2 29 7D 08 9B ?? ?? ?? ?? ?? ?? ?? ?? 08 01 09 8B 11 01 40 FD F0 3F 40 FD 00 22 71 1E 88 00 00 54 E8 1B 40 B9 08 09 00 11 E8 1B 00 B9 E9 5F 40 B9 08 02 80 52 29 7D 08 1B E8 1B 40 B9 28 01 08 4B 1F 01 00 71 2A 01 00 54 E9 5F 40 B9 08 02 80 52 29 7D 08 1B E8 1B 40 B9 28 01 08 4B E8 03 08 4B E8 9B 00 B9 07 00 00 14 E9 5F 40 B9 08 02 80 52 29 7D 08 1B E8 1B 40 B9 28 01 08 4B E8 9B 00 B9 E8 9B 40 B9 1F 05 00 71 81 01 00 54 E0 13 40 FD ?? ?? ?? ?? E0 C3 00 FD F1 C3 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 30 0A 70 1E F0 77 00 FD F0 2F 00 5C F0 8B 00 FD 5C 00 00 14 E8 1B 40 B9 08 05 00 11 09 7D 40 93 08 01 80 D2 29 7D 08 9B ?? ?? ?? ?? ?? ?? ?? ?? 08 01 09 8B F1 3F 40 FD 10 01 40 FD 31 3A 70 1E E8 1B 40 B9 09 05 00 11 48 00 80 52 28 0D C8 1A 09 7D 40 93 08 01 80 D2 29 7D 08 9B ?? ?? ?? ?? ?? ?? ?? ?? 08 01 09 8B 10 01 40 FD 32 3A 70 1E E8 1B 40 B9 08 05 00 11 09 7D 40 93 08 01 80 D2 29 7D 08 9B ?? ?? ?? ?? ?? ?? ?? ?? 08 01 09 8B F1 3F 40 FD 10 01 40 FD 30 2A 70 1E 50 1A 70 1E F0 43 00 FD F1 43 40 FD F0 43 40 FD 30 2A 70 1E F0 43 00 FD F1 43 40 FD F0 43 40 FD 30 0A 70 1E F0 5B 00 FD ?? ?? ?? ?? ?? ?? ?? ?? F0 5B 40 FD 31 0A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? 31 2A 70 1E F0 5B 40 FD 31 0A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? 31 2A 70 1E F0 5B 40 FD 31 0A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? 31 2A 70 1E F0 5B 40 FD 31 0A 70 1E F0 43 40 FD 30 0A 70 1E F0 5F 00 FD ?? ?? ?? ?? ?? ?? ?? ?? F0 5F 40 FD 31 0A 70 1E F0 5F 40 FD 10 2A 71 1E F0 5F 00 FD F1 43 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 31 0A 70 1E F0 5F 40 FD 11 2A 71 1E F0 43 40 FD 30 2A 70 1E F0 8B 00 FD E9 5F 40 B9 08 02 80 52 29 7D 08 1B E8 1B 40 B9 28 01 08 4B 11 01 62 1E 10 25 00 5C 30 0A 70 1E F0 77 00 FD E0 0B 40 FD ?? ?? ?? ?? E0 C7 00 FD F0 C7 40 FD F0 8F 00 FD F1 0B 40 FD F0 8F 40 FD 30 3A 70 1E F0 CB 00 FD F1 8B 40 FD F0 0B 40 FD 32 0A 70 1E F1 77 40 FD F0 CB 40 FD 30 0A 70 1E 50 2A 70 1E F0 47 00 FD E0 47 40 FD ?? ?? ?? ?? E0 CF 00 FD F0 CF 40 FD F0 57 00 FD F1 47 40 FD F0 57 40 FD 30 3A 70 1E F0 1F 00 FD F1 77 40 FD F0 8F 40 FD 31 0A 70 1E F0 57 40 FD 10 2A 71 1E F0 47 00 FD E0 47 40 FD ?? ?? ?? ?? E0 D3 00 FD F0 D3 40 FD F0 57 00 FD F1 47 40 FD F0 57 40 FD 31 3A 70 1E F0 1F 40 FD 10 2A 71 1E F0 1F 00 FD E0 1F 40 FD ?? ?? ?? ?? E0 D7 00 FD F0 D7 40 FD F0 47 00 FD F1 57 40 FD F0 47 40 FD 31 2A 70 1E 10 10 66 1E 10 0A 71 1E F0 7B 00 FD F1 1F 40 FD F0 47 40 FD 30 3A 70 1E F0 1F 00 FD ?? ?? ?? ?? ?? ?? ?? ?? F0 7B 40 FD 00 22 71 1E 2D 02 00 54 E8 17 40 F9 02 01 7E B2 F1 23 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 22 0A 70 1E 42 00 00 91 42 40 60 1E E1 0B 40 FD E0 27 40 FD A1 03 80 52 20 02 80 52 ?? ?? ?? ?? E0 DB 00 FD E0 DB 40 FD CF 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? F0 7B 40 FD 00 22 71 1E 02 02 00 54 E8 17 40 F9 02 01 7D B2 F1 23 40 FD 50 19 00 5C 22 0A 70 1E 42 00 00 91 42 40 60 1E E1 0B 40 FD E0 27 40 FD A1 03 80 52 40 02 80 52 ?? ?? ?? ?? E0 DF 00 FD E0 DF 40 FD BB 00 00 14 F0 7B 40 FD 08 02 78 1E E8 63 00 B9 F0 1F 40 FD 08 22 60 1E 0D 01 00 54 E8 63 40 B9 08 05 00 11 E8 63 00 B9 F1 1F 40 FD 10 17 00 5C 30 3A 70 1E F0 1F 00 FD E8 63 40 B9 1F 01 00 71 8A 00 00 54 08 00 80 52 E8 9F 00 B9 03 00 00 14 28 00 80 52 E8 9F 00 B9 E8 9F 40 B9 E8 E3 00 B9 E9 63 40 B9 08 02 80 52 29 0D C8 1A E8 E3 40 B9 28 01 08 0B E8 73 00 B9 E9 73 40 B9 08 02 80 52 29 7D 08 1B E8 63 40 B9 28 01 08 4B E8 A3 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? F0 1F 40 FD 31 0A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? 31 2A 70 1E F0 1F 40 FD 31 0A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? 31 2A 70 1E F0 1F 40 FD 31 0A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? 31 2A 70 1E F0 1F 40 FD 31 0A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? 31 2A 70 1E F0 1F 40 FD 31 0A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? 31 2A 70 1E F0 1F 40 FD 31 0A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? 31 2A 70 1E F0 1F 40 FD 30 0A 70 1E F0 2B 00 FD E8 A3 40 B9 08 05 00 11 09 7D 40 93 08 01 80 D2 29 7D 08 9B ?? ?? ?? ?? ?? ?? ?? ?? 0A 01 09 8B E8 A3 40 B9 08 05 00 11 09 7D 40 93 08 01 80 D2 29 7D 08 9B ?? ?? ?? ?? ?? ?? ?? ?? 08 01 09 8B 11 01 40 FD F0 2B 40 FD 31 0A 70 1E 50 01 40 FD 10 2A 71 1E F0 2B 00 FD E0 2B 40 FD ?? ?? ?? ?? E0 E7 00 B9 E9 E7 40 B9 E8 73 40 B9 28 01 08 0B E8 33 00 B9 E8 33 40 B9 1F 01 10 71 6D 03 00 54 E8 33 40 B9 00 01 18 51 00 00 00 11 E0 2B 40 FD ?? ?? ?? ?? E0 E3 00 FD F1 23 40 FD F0 E3 40 FD 30 0A 70 1E F0 37 00 FD E8 17 40 F9 02 01 7E B2 F1 23 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 22 0A 70 1E 42 00 00 91 42 40 60 1E E1 0B 40 FD E0 27 40 FD A1 03 80 52 20 02 80 52 ?? ?? ?? ?? E0 E7 00 FD E0 E7 40 FD 3B 00 00 14 E8 33 40 B9 1F F5 0F 31 4A 03 00 54 E8 33 40 B9 00 01 18 11 00 00 00 11 E0 2B 40 FD ?? ?? ?? ?? E0 EB 00 FD F1 23 40 FD F0 EB 40 FD 30 0A 70 1E F0 37 00 FD E8 17 40 F9 02 01 7D B2 F1 23 40 FD D0 05 00 5C 22 0A 70 1E 42 00 00 91 42 40 60 1E E1 0B 40 FD E0 27 40 FD A1 03 80 52 40 02 80 52 ?? ?? ?? ?? E0 EF 00 FD E0 EF 40 FD 1F 00 00 14 E0 33 40 B9 E0 2B 40 FD ?? ?? ?? ?? E0 F3 00 FD F1 23 40 FD F0 F3 40 FD 30 0A 70 1E F0 37 00 FD E8 17 40 F9 1F 01 00 F1 20 01 00 54 E8 17 40 F9 00 01 7C B2 61 02 00 58 00 00 00 91 ?? ?? ?? ?? E0 37 40 FD 0D 00 00 14 0C 00 00 14 E8 17 40 F9 02 01 7C B2 42 00 00 91 E2 37 40 FD E1 0B 40 FD E0 27 40 FD A1 03 80 52 00 02 80 52 ?? ?? ?? ?? E0 F7 00 FD E0 F7 40 FD FD 7B DF A8 C0 03 5F D6 00 9F C0 03 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 60 40 00 00 00 00 00 00 B0 3F }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "_mbccpy"
		size = 20
		refs = "0010 _mbccpy_s_l"
	strings:
		$1 = { 23 00 00 91 41 00 80 D2 04 00 80 D2 02 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_197_3_0 {
	meta:
		name = "_guard_icall_checks_enforced"
		size = 28
		refs = "0000 __guard_check_icall_fptr 0008 _guard_check_icall_nop"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 3F 01 08 EB E0 07 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_11_1_0 {
	meta:
		name = "_mbccpy_l"
		size = 20
		refs = "0010 _mbccpy_s_l"
	strings:
		$1 = { 44 00 00 91 23 00 00 91 02 00 80 D2 41 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "atan2l"
		size = 44
		refs = "0018 atan2"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 FD E1 0B 00 FD E1 0B 40 FD E0 0F 40 FD ?? ?? ?? ?? E0 13 00 FD E0 13 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_288_2_0 {
	meta:
		name = "_nextafter"
		size = 44
		refs = "0018 nextafter"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 FD E1 0B 00 FD E1 0B 40 FD E0 0F 40 FD ?? ?? ?? ?? E0 13 00 FD E0 13 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_461_3_4 {
	meta:
		name = "fmodl"
		size = 44
		refs = "0018 fmod"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 FD E1 0B 00 FD E1 0B 40 FD E0 0F 40 FD ?? ?? ?? ?? E0 13 00 FD E0 13 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_214_1_0 {
	meta:
		name = "hypot"
		size = 44
		refs = "0018 _hypot"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 FD E1 0B 00 FD E1 0B 40 FD E0 0F 40 FD ?? ?? ?? ?? E0 13 00 FD E0 13 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_591_1_4 {
	meta:
		name = "hypotl"
		size = 44
		refs = "0018 _hypot"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 FD E1 0B 00 FD E1 0B 40 FD E0 0F 40 FD ?? ?? ?? ?? E0 13 00 FD E0 13 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_564_0_2 {
	meta:
		name = "nextafter"
		size = 44
		refs = "0018 nexttoward"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 FD E1 0B 00 FD E1 0B 40 FD E0 0F 40 FD ?? ?? ?? ?? E0 13 00 FD E0 13 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_417_0_3 {
	meta:
		name = "nextafterl"
		size = 44
		refs = "0018 nexttowardl"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 FD E1 0B 00 FD E1 0B 40 FD E0 0F 40 FD ?? ?? ?? ?? E0 13 00 FD E0 13 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_229_3_3 {
	meta:
		name = "powl"
		size = 44
		refs = "0018 pow"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 FD E1 0B 00 FD E1 0B 40 FD E0 0F 40 FD ?? ?? ?? ?? E0 13 00 FD E0 13 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_12_1_0 {
	meta:
		name = "catanhl"
		size = 1344
		refs = "0018 creall 0030 cimagl 0044 _ldtest 00c0 piby2 013c _LZero_C 0260 big 03bc log1pl 0404 atan2l 0430 _fperrraise 0434 _LInf_C 0464 sqrtl 0494 logl 0518 _LCbuild"
	strings:
		$1 = { FD 7B AF A9 FD 03 00 91 E0 57 00 FD E1 5B 00 FD E1 5B 40 FD E0 57 40 FD ?? ?? ?? ?? E0 5F 00 FD F0 5F 40 FD F0 13 00 FD E1 5B 40 FD E0 57 40 FD ?? ?? ?? ?? E0 63 00 FD F0 63 40 FD F0 0B 00 FD E0 83 00 91 ?? ?? ?? ?? E0 83 00 79 E8 83 C0 79 E8 33 00 79 E0 43 00 91 ?? ?? ?? ?? E0 87 00 79 E8 87 C0 79 E8 53 00 79 E8 33 C0 79 08 01 00 11 1F 09 00 71 61 04 00 54 E8 53 C0 79 08 01 00 11 1F 09 00 71 C1 00 00 54 F0 13 40 FD F0 1F 00 FD F0 0B 40 FD F0 1B 00 FD 19 00 00 14 E8 53 C0 79 08 01 00 11 1F 05 00 71 21 02 00 54 70 24 00 5C F0 1F 00 FD F0 0B 40 FD 08 22 60 1E C2 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E F0 33 00 FD 04 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? F0 33 00 FD F0 33 40 FD F0 1B 00 FD 05 00 00 14 F0 13 40 FD F0 1F 00 FD F0 13 40 FD F0 1B 00 FD 05 01 00 14 E8 53 C0 79 08 01 00 11 1F 09 00 71 A1 03 00 54 E8 33 C0 79 08 01 00 11 1F 05 00 71 A0 00 00 54 E8 33 C0 79 08 01 00 11 1F 01 00 71 01 02 00 54 E8 4F 40 79 08 01 00 11 C8 00 78 36 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E F0 37 00 FD 03 00 00 14 50 1F 00 5C F0 37 00 FD F0 37 40 FD F0 1F 00 FD F0 0B 40 FD F0 1B 00 FD 05 00 00 14 F0 0B 40 FD F0 1F 00 FD F0 0B 40 FD F0 1B 00 FD E5 00 00 14 E8 33 C0 79 08 01 00 11 1F 05 00 71 61 03 00 54 F0 13 40 FD 08 22 60 1E C2 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E F0 3B 00 FD 03 00 00 14 50 1C 00 5C F0 3B 00 FD F0 3B 40 FD F0 1F 00 FD E8 2F 40 79 08 01 00 11 C8 00 78 36 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E F0 3F 00 FD 04 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? F0 3F 00 FD F0 3F 40 FD F0 1B 00 FD C7 00 00 14 E8 2F 40 79 08 01 00 11 A8 00 78 36 F0 0B 40 FD 10 42 61 1E F0 43 00 FD 03 00 00 14 F0 0B 40 FD F0 43 00 FD F0 43 40 FD F0 27 00 FD F0 13 40 FD 08 22 60 1E E2 00 00 54 28 00 80 52 E8 47 00 B9 F0 13 40 FD 10 42 61 1E F0 13 00 FD 06 00 00 14 08 00 80 52 E8 47 00 B9 F0 0B 40 FD 10 42 61 1E F0 0B 00 FD F1 13 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 00 22 71 1E A2 03 00 54 F1 0B 40 FD F0 13 40 FD 30 1A 70 1E F0 47 00 FD 11 10 6E 1E F0 13 40 FD 32 1A 70 1E F1 47 40 FD F0 47 40 FD 31 0A 70 1E 10 10 6E 1E 10 2A 71 1E 50 1A 70 1E F0 1F 00 FD F0 0B 40 FD 08 22 60 1E C2 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E F0 4B 00 FD 04 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? F0 4B 00 FD F0 4B 40 FD F0 1B 00 FD 83 00 00 14 F1 27 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 00 22 71 1E A2 03 00 54 F1 13 40 FD F0 0B 40 FD 30 1A 70 1E F0 2B 00 FD F1 2B 40 FD F0 0B 40 FD 32 1A 70 1E F1 2B 40 FD F0 2B 40 FD 31 0A 70 1E 10 10 6E 1E 10 2A 71 1E 50 1A 70 1E F0 1F 00 FD F0 0B 40 FD 08 22 60 1E C2 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E F0 4F 00 FD 04 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? F0 4F 00 FD F0 4F 40 FD F0 1B 00 FD 62 00 00 14 11 10 6E 1E F0 13 40 FD 00 22 71 1E 80 05 00 54 11 10 6E 1E F0 13 40 FD 30 3A 70 1E F0 2F 00 FD F1 27 40 FD F0 27 40 FD 30 0A 70 1E F0 53 00 FD 11 10 62 1E F0 13 40 FD 32 0A 70 1E F1 2F 40 FD F0 2F 40 FD 31 0A 70 1E F0 53 40 FD 30 2A 70 1E 40 1A 70 1E 00 40 60 1E ?? ?? ?? ?? E0 67 00 FD 11 10 6A 1E F0 67 40 FD 30 0A 70 1E F0 1F 00 FD 11 10 6E 1E F0 13 40 FD 31 2A 70 1E F0 2F 40 FD 11 0A 71 1E F0 53 40 FD 21 3A 70 1E 11 10 60 1E F0 0B 40 FD 20 0A 70 1E 21 40 60 1E 00 40 60 1E ?? ?? ?? ?? E0 6B 00 FD 11 10 6C 1E F0 6B 40 FD 30 0A 70 1E F0 1B 00 FD 33 00 00 14 F0 0B 40 FD 08 22 60 1E 21 01 00 54 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? F0 1F 00 FD F0 0B 40 FD F0 1B 00 FD 28 00 00 14 F1 0B 40 FD F0 0B 40 FD 31 0A 70 1E 10 10 62 1E 00 2A 71 1E 00 40 60 1E ?? ?? ?? ?? E0 6F 00 FD E0 6F 40 FD ?? ?? ?? ?? E0 73 00 FD E0 27 40 FD ?? ?? ?? ?? E0 77 00 FD F1 73 40 FD F0 77 40 FD 20 1A 70 1E 00 40 60 1E ?? ?? ?? ?? E0 7B 00 FD F0 7B 40 FD F0 1F 00 FD 01 10 60 1E E0 27 40 FD ?? ?? ?? ?? E0 7F 00 FD ?? ?? ?? ?? ?? ?? ?? ?? F0 7F 40 FD 31 2A 70 1E 10 10 6C 1E 10 0A 71 1E F0 1B 00 FD F0 0B 40 FD 08 22 60 1E 82 00 00 54 F0 1B 40 FD 10 42 61 1E F0 1B 00 FD E8 47 40 B9 1F 01 00 71 A0 00 00 54 F0 1F 40 FD 10 42 61 1E F0 1F 00 FD 04 00 00 14 F0 1B 40 FD 10 42 61 1E F0 1B 00 FD E1 1B 40 FD E0 1F 40 FD ?? ?? ?? ?? E1 87 00 FD E0 83 00 FD E0 83 40 FD E1 87 40 FD FD 7B D1 A8 C0 03 5F D6 1F 20 03 D5 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_426_0_0 {
	meta:
		name = "catanh"
		size = 1344
		refs = "0018 creal 0030 cimag 0044 _dtest 00c0 piby2 013c _Zero_C 0260 big 03bc log1p 0404 atan2 0430 _fperrraise 0434 _Inf_C 0464 sqrt 0494 log 0518 _Cbuild"
	strings:
		$1 = { FD 7B AF A9 FD 03 00 91 E0 57 00 FD E1 5B 00 FD E1 5B 40 FD E0 57 40 FD ?? ?? ?? ?? E0 5F 00 FD F0 5F 40 FD F0 13 00 FD E1 5B 40 FD E0 57 40 FD ?? ?? ?? ?? E0 63 00 FD F0 63 40 FD F0 0B 00 FD E0 83 00 91 ?? ?? ?? ?? E0 83 00 79 E8 83 C0 79 E8 33 00 79 E0 43 00 91 ?? ?? ?? ?? E0 87 00 79 E8 87 C0 79 E8 53 00 79 E8 33 C0 79 08 01 00 11 1F 09 00 71 61 04 00 54 E8 53 C0 79 08 01 00 11 1F 09 00 71 C1 00 00 54 F0 13 40 FD F0 1F 00 FD F0 0B 40 FD F0 1B 00 FD 19 00 00 14 E8 53 C0 79 08 01 00 11 1F 05 00 71 21 02 00 54 70 24 00 5C F0 1F 00 FD F0 0B 40 FD 08 22 60 1E C2 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E F0 33 00 FD 04 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? F0 33 00 FD F0 33 40 FD F0 1B 00 FD 05 00 00 14 F0 13 40 FD F0 1F 00 FD F0 13 40 FD F0 1B 00 FD 05 01 00 14 E8 53 C0 79 08 01 00 11 1F 09 00 71 A1 03 00 54 E8 33 C0 79 08 01 00 11 1F 05 00 71 A0 00 00 54 E8 33 C0 79 08 01 00 11 1F 01 00 71 01 02 00 54 E8 4F 40 79 08 01 00 11 C8 00 78 36 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E F0 37 00 FD 03 00 00 14 50 1F 00 5C F0 37 00 FD F0 37 40 FD F0 1F 00 FD F0 0B 40 FD F0 1B 00 FD 05 00 00 14 F0 0B 40 FD F0 1F 00 FD F0 0B 40 FD F0 1B 00 FD E5 00 00 14 E8 33 C0 79 08 01 00 11 1F 05 00 71 61 03 00 54 F0 13 40 FD 08 22 60 1E C2 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E F0 3B 00 FD 03 00 00 14 50 1C 00 5C F0 3B 00 FD F0 3B 40 FD F0 1F 00 FD E8 2F 40 79 08 01 00 11 C8 00 78 36 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E F0 3F 00 FD 04 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? F0 3F 00 FD F0 3F 40 FD F0 1B 00 FD C7 00 00 14 E8 2F 40 79 08 01 00 11 A8 00 78 36 F0 0B 40 FD 10 42 61 1E F0 43 00 FD 03 00 00 14 F0 0B 40 FD F0 43 00 FD F0 43 40 FD F0 27 00 FD F0 13 40 FD 08 22 60 1E E2 00 00 54 28 00 80 52 E8 47 00 B9 F0 13 40 FD 10 42 61 1E F0 13 00 FD 06 00 00 14 08 00 80 52 E8 47 00 B9 F0 0B 40 FD 10 42 61 1E F0 0B 00 FD F1 13 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 00 22 71 1E A2 03 00 54 F1 0B 40 FD F0 13 40 FD 30 1A 70 1E F0 47 00 FD 11 10 6E 1E F0 13 40 FD 32 1A 70 1E F1 47 40 FD F0 47 40 FD 31 0A 70 1E 10 10 6E 1E 10 2A 71 1E 50 1A 70 1E F0 1F 00 FD F0 0B 40 FD 08 22 60 1E C2 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E F0 4B 00 FD 04 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? F0 4B 00 FD F0 4B 40 FD F0 1B 00 FD 83 00 00 14 F1 27 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 00 22 71 1E A2 03 00 54 F1 13 40 FD F0 0B 40 FD 30 1A 70 1E F0 2B 00 FD F1 2B 40 FD F0 0B 40 FD 32 1A 70 1E F1 2B 40 FD F0 2B 40 FD 31 0A 70 1E 10 10 6E 1E 10 2A 71 1E 50 1A 70 1E F0 1F 00 FD F0 0B 40 FD 08 22 60 1E C2 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E F0 4F 00 FD 04 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? F0 4F 00 FD F0 4F 40 FD F0 1B 00 FD 62 00 00 14 11 10 6E 1E F0 13 40 FD 00 22 71 1E 80 05 00 54 11 10 6E 1E F0 13 40 FD 30 3A 70 1E F0 2F 00 FD F1 27 40 FD F0 27 40 FD 30 0A 70 1E F0 53 00 FD 11 10 62 1E F0 13 40 FD 32 0A 70 1E F1 2F 40 FD F0 2F 40 FD 31 0A 70 1E F0 53 40 FD 30 2A 70 1E 40 1A 70 1E 00 40 60 1E ?? ?? ?? ?? E0 67 00 FD 11 10 6A 1E F0 67 40 FD 30 0A 70 1E F0 1F 00 FD 11 10 6E 1E F0 13 40 FD 31 2A 70 1E F0 2F 40 FD 11 0A 71 1E F0 53 40 FD 21 3A 70 1E 11 10 60 1E F0 0B 40 FD 20 0A 70 1E 21 40 60 1E 00 40 60 1E ?? ?? ?? ?? E0 6B 00 FD 11 10 6C 1E F0 6B 40 FD 30 0A 70 1E F0 1B 00 FD 33 00 00 14 F0 0B 40 FD 08 22 60 1E 21 01 00 54 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? F0 1F 00 FD F0 0B 40 FD F0 1B 00 FD 28 00 00 14 F1 0B 40 FD F0 0B 40 FD 31 0A 70 1E 10 10 62 1E 00 2A 71 1E 00 40 60 1E ?? ?? ?? ?? E0 6F 00 FD E0 6F 40 FD ?? ?? ?? ?? E0 73 00 FD E0 27 40 FD ?? ?? ?? ?? E0 77 00 FD F1 73 40 FD F0 77 40 FD 20 1A 70 1E 00 40 60 1E ?? ?? ?? ?? E0 7B 00 FD F0 7B 40 FD F0 1F 00 FD 01 10 60 1E E0 27 40 FD ?? ?? ?? ?? E0 7F 00 FD ?? ?? ?? ?? ?? ?? ?? ?? F0 7F 40 FD 31 2A 70 1E 10 10 6C 1E 10 0A 71 1E F0 1B 00 FD F0 0B 40 FD 08 22 60 1E 82 00 00 54 F0 1B 40 FD 10 42 61 1E F0 1B 00 FD E8 47 40 B9 1F 01 00 71 A0 00 00 54 F0 1F 40 FD 10 42 61 1E F0 1F 00 FD 04 00 00 14 F0 1B 40 FD 10 42 61 1E F0 1B 00 FD E1 1B 40 FD E0 1F 40 FD ?? ?? ?? ?? E1 87 00 FD E0 83 00 FD E0 83 40 FD E1 87 40 FD FD 7B D1 A8 C0 03 5F D6 1F 20 03 D5 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_12_2_0 {
	meta:
		name = "logl"
		size = 36
		refs = "0010 log"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 FD E0 0B 40 FD ?? ?? ?? ?? E0 0F 00 FD E0 0F 40 FD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_263_1_3 {
	meta:
		name = "cosl"
		size = 36
		refs = "0010 cos"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 FD E0 0B 40 FD ?? ?? ?? ?? E0 0F 00 FD E0 0F 40 FD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_196_0_4 {
	meta:
		name = "expl"
		size = 36
		refs = "0010 exp"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 FD E0 0B 40 FD ?? ?? ?? ?? E0 0F 00 FD E0 0F 40 FD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_168_1_3 {
	meta:
		name = "fabs"
		size = 36
		refs = "0010 ?fabs_intrinsic@@YANN@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 FD E0 0B 40 FD ?? ?? ?? ?? E0 0F 00 FD E0 0F 40 FD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_592_1_2 {
	meta:
		name = "sinhl"
		size = 36
		refs = "0010 sinh"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 FD E0 0B 40 FD ?? ?? ?? ?? E0 0F 00 FD E0 0F 40 FD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_263_2_3 {
	meta:
		name = "sinl"
		size = 36
		refs = "0010 sin"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 FD E0 0B 40 FD ?? ?? ?? ?? E0 0F 00 FD E0 0F 40 FD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_140_2_4 {
	meta:
		name = "sqrtl"
		size = 36
		refs = "0010 sqrt"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 FD E0 0B 40 FD ?? ?? ?? ?? E0 0F 00 FD E0 0F 40 FD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_592_3_3 {
	meta:
		name = "tanl"
		size = 36
		refs = "0010 tan"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 FD E0 0B 40 FD ?? ?? ?? ?? E0 0F 00 FD E0 0F 40 FD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "_errcode"
		size = 128
	strings:
		$1 = { FF 43 00 D1 E0 07 00 B9 E8 07 40 B9 88 00 28 36 A8 00 80 52 E8 03 00 B9 17 00 00 14 E8 07 40 B9 88 00 18 36 28 00 80 52 E8 03 00 B9 12 00 00 14 E8 07 40 B9 88 00 10 36 48 00 80 52 E8 03 00 B9 0D 00 00 14 E8 07 40 B9 88 00 00 36 68 00 80 52 E8 03 00 B9 08 00 00 14 E8 07 40 B9 88 00 08 36 88 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E0 03 40 B9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_13_1_0 {
	meta:
		name = "_except1"
		size = 264
		refs = "0008 __security_push_cookie 0030 _handle_exc 0068 _raise_exc 0070 _errcode 0080 __acrt_has_user_matherr 00bc _umatherr 00d4 _set_errno_from_matherr 00e0 _ctrlfp 00ec __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF C3 02 D1 E0 07 00 B9 E1 0F 00 B9 E0 17 00 FD E1 0F 00 FD E2 0B 00 F9 E2 0B 40 F9 E1 63 00 91 E0 07 40 B9 ?? ?? ?? ?? E0 23 00 B9 E8 23 40 B9 1F 01 00 71 61 01 00 54 E8 83 40 B9 08 79 1F 12 E8 83 00 B9 E5 63 00 91 E4 A3 00 91 E3 0F 40 B9 E2 07 40 B9 E1 43 00 91 E0 03 01 91 ?? ?? ?? ?? E0 07 40 B9 ?? ?? ?? ?? E0 27 00 B9 E8 27 40 B9 E8 0B 00 B9 ?? ?? ?? ?? E0 03 00 39 E8 03 40 39 08 01 00 11 1F 01 00 71 E0 01 00 54 E8 0B 40 B9 1F 01 00 71 80 01 00 54 E2 0B 40 F9 E2 0F 40 FD 61 02 00 5C E0 17 40 FD E1 0F 40 B9 E0 0B 40 B9 ?? ?? ?? ?? E0 1B 00 FD E0 1B 40 FD 08 00 00 14 03 00 00 14 E0 0B 40 B9 ?? ?? ?? ?? 41 01 00 58 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 40 FD FF C3 02 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 00 00 00 00 00 00 00 00 00 9F C0 03 00 00 00 00 }
	condition:
		$1
}

rule file_13_2_0 {
	meta:
		name = "_except2"
		size = 288
		refs = "0008 __security_push_cookie 0034 _handle_exc 0084 _raise_exc 008c _errcode 009c __acrt_has_user_matherr 00d8 _umatherr 00f0 _set_errno_from_matherr 00fc _ctrlfp 0108 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF C3 02 D1 E0 07 00 B9 E1 0F 00 B9 E0 1B 00 FD E1 17 00 FD E2 0F 00 FD E2 0B 00 F9 E2 0B 40 F9 E1 63 00 91 E0 07 40 B9 ?? ?? ?? ?? E0 23 00 B9 E8 23 40 B9 1F 01 00 71 21 02 00 54 E8 83 40 B9 08 01 00 32 E8 83 00 B9 E9 83 40 B9 28 00 80 52 09 0D 1F 33 E9 83 00 B9 F0 17 40 FD F0 3B 00 FD E5 63 00 91 E4 C3 00 91 E3 0F 40 B9 E2 07 40 B9 E1 43 00 91 E0 03 01 91 ?? ?? ?? ?? E0 07 40 B9 ?? ?? ?? ?? E0 27 00 B9 E8 27 40 B9 E8 0B 00 B9 ?? ?? ?? ?? E0 03 00 39 E8 03 40 39 08 01 00 11 1F 01 00 71 E0 01 00 54 E8 0B 40 B9 1F 01 00 71 80 01 00 54 E2 0B 40 F9 E2 0F 40 FD E1 17 40 FD E0 1B 40 FD E1 0F 40 B9 E0 0B 40 B9 ?? ?? ?? ?? E0 1F 00 FD E0 1F 40 FD 08 00 00 14 03 00 00 14 E0 0B 40 B9 ?? ?? ?? ?? 21 01 00 58 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 40 FD FF C3 02 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 1F 20 03 D5 00 9F C0 03 00 00 00 00 }
	condition:
		$1
}

rule file_13_3_0 {
	meta:
		name = "_get_fname"
		size = 148
		refs = "003c ?_names@?1??_get_fname@@9@9"
	strings:
		$1 = { FF 43 00 D1 E0 07 00 B9 08 00 80 52 E8 03 00 B9 04 00 00 14 E8 03 40 B9 08 05 00 11 E8 03 00 B9 E8 03 40 B9 1F 75 00 71 0A 03 00 54 E8 03 40 B9 09 7D 40 93 08 02 80 D2 29 7D 08 9B ?? ?? ?? ?? ?? ?? ?? ?? 08 01 09 8B 08 01 00 91 E9 07 40 B9 08 01 40 B9 1F 01 09 6B 61 01 00 54 E8 03 40 B9 09 7D 40 93 08 02 80 D2 29 7D 08 9B ?? ?? ?? ?? ?? ?? ?? ?? 08 01 09 8B 08 21 00 91 00 01 40 F9 03 00 00 14 E4 FF FF 17 00 00 80 D2 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_13_4_0 {
	meta:
		name = "_handle_exc"
		size = 1016
		refs = "0034 _set_statfp 0114 _d_inf 0164 _d_max 0254 _decomp"
	strings:
		$1 = { FD 7B B7 A9 FD 03 00 91 E0 23 00 B9 E1 17 00 F9 E2 1F 00 F9 E8 23 40 B9 08 11 00 12 E8 13 00 B9 E8 23 40 B9 28 01 18 36 E8 1F 40 F9 E8 00 40 36 20 00 80 D2 ?? ?? ?? ?? E8 13 40 B9 08 79 1C 12 E8 13 00 B9 D7 00 00 14 E8 23 40 B9 28 01 10 36 E8 1F 40 F9 E8 00 48 36 40 00 80 D2 ?? ?? ?? ?? E8 13 40 B9 08 79 1D 12 E8 13 00 B9 CD 00 00 14 E8 23 40 B9 E8 0C 00 36 E8 1F 40 F9 A8 0C 50 36 80 00 80 D2 ?? ?? ?? ?? E8 1F 40 F9 08 05 6A 92 E8 2F 00 F9 09 18 A0 D2 E8 2F 40 F9 1F 01 09 EB 08 0B 00 54 E8 2F 40 F9 08 01 00 11 E8 4B 00 B9 09 10 A0 52 E8 4B 40 B9 1F 01 09 6B A8 01 00 54 09 10 A0 52 E8 4B 40 B9 1F 01 09 6B C0 05 00 54 E8 4B 40 B9 1F 01 00 71 60 01 00 54 09 08 A0 52 E8 4B 40 B9 1F 01 09 6B E0 02 00 54 45 00 00 14 09 18 A0 52 E8 4B 40 B9 1F 01 09 6B 40 06 00 54 40 00 00 14 E8 17 40 F9 10 01 40 FD 08 22 60 1E AD 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? F0 33 00 FD 05 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E F0 33 00 FD E8 17 40 F9 F0 33 40 FD 10 01 00 FD 30 00 00 14 E8 17 40 F9 10 01 40 FD 08 22 60 1E AD 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? F0 37 00 FD 05 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E F0 37 00 FD E8 17 40 F9 F0 37 40 FD 10 01 00 FD 20 00 00 14 E8 17 40 F9 10 01 40 FD 08 22 60 1E AD 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? F0 3B 00 FD 05 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E F0 3B 00 FD E8 17 40 F9 F0 3B 40 FD 10 01 00 FD 10 00 00 14 E8 17 40 F9 10 01 40 FD 08 22 60 1E AD 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? F0 3F 00 FD 05 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E F0 3F 00 FD E8 17 40 F9 F0 3F 40 FD 10 01 00 FD E8 13 40 B9 08 79 1F 12 E8 13 00 B9 65 00 00 14 E8 23 40 B9 68 0C 08 36 E8 1F 40 F9 28 0C 58 36 08 00 80 52 E8 27 00 B9 E8 23 40 B9 68 00 20 36 28 00 80 52 E8 27 00 B9 E8 17 40 F9 10 01 40 FD 08 22 60 1E A0 09 00 54 E0 43 01 91 E8 17 40 F9 00 01 40 FD ?? ?? ?? ?? E0 43 00 FD F0 43 40 FD F0 0F 00 FD E8 53 40 B9 08 01 18 51 E8 33 00 B9 E8 33 40 B9 1F C9 10 31 0A 01 00 54 F1 0F 40 FD 90 0B 00 5C 30 0A 70 1E F0 0F 00 FD 28 00 80 52 E8 27 00 B9 35 00 00 14 F0 0F 40 FD 08 22 60 1E 82 00 00 54 28 00 80 52 E8 43 00 B9 03 00 00 14 08 00 80 52 E8 43 00 B9 E8 43 40 B9 E8 57 00 B9 E8 3F 40 79 08 01 00 11 08 0D 00 12 08 3D 00 53 E8 3F 00 79 E8 3F 40 79 08 01 00 11 08 01 1C 32 08 3D 00 53 E8 3F 00 79 04 00 00 14 E8 33 40 B9 08 05 00 11 E8 33 00 B9 E8 33 40 B9 1F F5 0F 31 8A 02 00 54 E8 1B 40 B9 C8 00 00 36 E8 27 40 B9 1F 01 00 71 61 00 00 54 28 00 80 52 E8 27 00 B9 E8 1B 40 B9 08 7D 01 53 E8 1B 00 B9 E8 1F 40 B9 88 00 00 36 E8 1B 40 B9 08 01 01 32 E8 1B 00 B9 E8 1F 40 B9 08 7D 01 53 E8 1F 00 B9 E8 FF FF 17 E8 57 40 B9 1F 01 00 71 80 00 00 54 F0 0F 40 FD 10 42 61 1E F0 0F 00 FD E8 17 40 F9 F0 0F 40 FD 10 01 00 FD 03 00 00 14 28 00 80 52 E8 27 00 B9 E8 27 40 B9 1F 01 00 71 60 00 00 54 00 01 80 D2 ?? ?? ?? ?? E8 13 40 B9 08 79 1E 12 E8 13 00 B9 E8 23 40 B9 08 01 20 36 E8 1F 40 F9 C8 00 60 36 00 02 80 D2 ?? ?? ?? ?? E8 13 40 B9 08 79 1B 12 E8 13 00 B9 E8 13 40 B9 1F 01 00 71 80 00 00 54 08 00 80 52 E8 47 00 B9 03 00 00 14 28 00 80 52 E8 47 00 B9 E0 47 40 B9 FD 7B C9 A8 C0 03 5F D6 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_13_5_0 {
	meta:
		name = "_handle_qnan2"
		size = 40
	strings:
		$1 = { FF 83 00 D1 E0 03 00 FD E1 07 00 FD F1 03 40 FD F0 07 40 FD 30 2A 70 1E F0 0B 00 FD E0 0B 40 FD FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_13_6_0 {
	meta:
		name = "_raise_exc"
		size = 72
		refs = "003c _raise_exc_ex"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 17 00 B9 E3 13 00 B9 E4 13 00 F9 E5 0F 00 F9 06 00 80 52 E5 0F 40 F9 E4 13 40 F9 E3 13 40 B9 E2 17 40 B9 E1 17 40 F9 E0 1B 40 F9 ?? ?? ?? ?? FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_13_7_0 {
	meta:
		name = "_raise_exc_ex"
		size = 1912
		refs = "0278 _statfp 05a8 _clrfp 05bc __imp_RaiseException"
	strings:
		$1 = { FD 7B B8 A9 FD 03 00 91 E0 0B 00 F9 E1 0F 00 F9 E2 27 00 B9 E3 63 00 B9 E4 3B 00 F9 E5 2F 00 F9 E6 43 00 B9 E8 39 00 18 E8 23 00 B9 E8 0B 40 F9 09 11 00 91 08 00 80 52 28 01 00 B9 E8 0B 40 F9 09 21 00 91 08 00 80 52 28 01 00 B9 E8 0B 40 F9 09 31 00 91 08 00 80 52 28 01 00 B9 E8 27 40 B9 48 01 20 36 08 38 00 18 E8 23 00 B9 E8 0B 40 F9 08 11 00 91 08 01 40 B9 09 01 00 32 E8 0B 40 F9 08 11 00 91 09 01 00 B9 E8 27 40 B9 48 01 08 36 C8 36 00 18 E8 23 00 B9 E8 0B 40 F9 08 11 00 91 08 01 40 B9 09 01 1F 32 E8 0B 40 F9 08 11 00 91 09 01 00 B9 E8 27 40 B9 48 01 00 36 88 35 00 18 E8 23 00 B9 E8 0B 40 F9 08 11 00 91 08 01 40 B9 09 01 1E 32 E8 0B 40 F9 08 11 00 91 09 01 00 B9 E8 27 40 B9 48 01 10 36 48 34 00 18 E8 23 00 B9 E8 0B 40 F9 08 11 00 91 08 01 40 B9 09 01 1D 32 E8 0B 40 F9 08 11 00 91 09 01 00 B9 E8 27 40 B9 48 01 18 36 08 33 00 18 E8 23 00 B9 E8 0B 40 F9 08 11 00 91 08 01 40 B9 09 01 1C 32 E8 0B 40 F9 08 11 00 91 09 01 00 B9 E8 0F 40 F9 08 01 40 F9 88 00 40 36 08 00 80 52 E8 2B 00 B9 03 00 00 14 28 00 80 52 E8 2B 00 B9 E8 0B 40 F9 08 21 00 91 09 01 40 B9 E8 2B 40 B9 09 01 1C 33 E8 0B 40 F9 08 21 00 91 09 01 00 B9 E8 0F 40 F9 08 01 40 F9 88 00 48 36 08 00 80 52 E8 2F 00 B9 03 00 00 14 28 00 80 52 E8 2F 00 B9 E8 0B 40 F9 08 21 00 91 09 01 40 B9 E8 2F 40 B9 09 01 1D 33 E8 0B 40 F9 08 21 00 91 09 01 00 B9 E8 0F 40 F9 08 01 40 F9 88 00 50 36 08 00 80 52 E8 33 00 B9 03 00 00 14 28 00 80 52 E8 33 00 B9 E8 0B 40 F9 08 21 00 91 09 01 40 B9 E8 33 40 B9 09 01 1E 33 E8 0B 40 F9 08 21 00 91 09 01 00 B9 E8 0F 40 F9 08 01 40 F9 88 00 58 36 08 00 80 52 E8 37 00 B9 03 00 00 14 28 00 80 52 E8 37 00 B9 E8 0B 40 F9 08 21 00 91 09 01 40 B9 E8 37 40 B9 09 01 1F 33 E8 0B 40 F9 08 21 00 91 09 01 00 B9 E8 0F 40 F9 08 01 40 F9 88 00 60 36 08 00 80 52 E8 3B 00 B9 03 00 00 14 28 00 80 52 E8 3B 00 B9 E8 0B 40 F9 08 21 00 91 09 01 40 B9 E8 3B 40 B9 09 01 00 33 E8 0B 40 F9 08 21 00 91 09 01 00 B9 ?? ?? ?? ?? E0 3F 00 F9 E8 3F 40 F9 E8 27 00 F9 E8 27 40 F9 08 01 00 36 E8 0B 40 F9 08 31 00 91 08 01 40 B9 09 01 1C 32 E8 0B 40 F9 08 31 00 91 09 01 00 B9 E8 27 40 F9 08 01 08 36 E8 0B 40 F9 08 31 00 91 08 01 40 B9 09 01 1D 32 E8 0B 40 F9 08 31 00 91 09 01 00 B9 E8 27 40 F9 08 01 10 36 E8 0B 40 F9 08 31 00 91 08 01 40 B9 09 01 1E 32 E8 0B 40 F9 08 31 00 91 09 01 00 B9 E8 27 40 F9 08 01 18 36 E8 0B 40 F9 08 31 00 91 08 01 40 B9 09 01 1F 32 E8 0B 40 F9 08 31 00 91 09 01 00 B9 E8 27 40 F9 08 01 20 36 E8 0B 40 F9 08 31 00 91 08 01 40 B9 09 01 00 32 E8 0B 40 F9 08 31 00 91 09 01 00 B9 E8 0F 40 F9 08 01 40 F9 08 05 6A 92 E8 37 00 F9 09 18 A0 D2 E8 37 40 F9 1F 01 09 EB 48 07 00 54 E8 37 40 F9 08 01 00 11 E8 53 00 B9 09 10 A0 52 E8 53 40 B9 1F 01 09 6B A8 01 00 54 09 10 A0 52 E8 53 40 B9 1F 01 09 6B E0 03 00 54 E8 53 40 B9 1F 01 00 71 A0 04 00 54 09 08 A0 52 E8 53 40 B9 1F 01 09 6B E0 01 00 54 27 00 00 14 09 18 A0 52 E8 53 40 B9 1F 01 09 6B 40 00 00 54 22 00 00 14 E8 0B 40 F9 08 01 00 91 08 01 40 B9 09 05 00 32 E8 0B 40 F9 08 01 00 91 09 01 00 B9 1A 00 00 14 E8 0B 40 F9 08 01 00 91 09 01 40 B9 48 00 80 52 09 05 00 33 E8 0B 40 F9 08 01 00 91 09 01 00 B9 11 00 00 14 E8 0B 40 F9 08 01 00 91 09 01 40 B9 28 00 80 52 09 05 00 33 E8 0B 40 F9 08 01 00 91 09 01 00 B9 08 00 00 14 E8 0B 40 F9 08 01 00 91 08 01 40 B9 09 75 1E 12 E8 0B 40 F9 08 01 00 91 09 01 00 B9 E8 0B 40 F9 08 01 00 91 09 01 40 B9 E8 63 40 B9 09 2D 1B 33 E8 0B 40 F9 08 01 00 91 09 01 00 B9 E8 43 40 B9 1F 01 00 71 00 05 00 54 E8 0B 40 F9 08 81 00 91 08 01 40 B9 09 01 00 32 E8 0B 40 F9 08 81 00 91 09 01 00 B9 E8 0B 40 F9 08 81 00 91 08 01 40 B9 09 6D 1B 12 E8 0B 40 F9 08 81 00 91 09 01 00 B9 E8 0B 40 F9 09 41 00 91 E8 3B 40 F9 10 01 40 BD 30 01 00 BD E8 0B 40 F9 08 81 01 91 08 01 40 B9 09 01 00 32 E8 0B 40 F9 08 81 01 91 09 01 00 B9 E8 0B 40 F9 08 81 01 91 08 01 40 B9 09 6D 1B 12 E8 0B 40 F9 08 81 01 91 09 01 00 B9 E8 0B 40 F9 09 41 01 91 E8 2F 40 F9 10 01 40 BD 30 01 00 BD 29 00 00 14 E8 0B 40 F9 08 81 00 91 08 01 40 B9 09 01 00 32 E8 0B 40 F9 08 81 00 91 09 01 00 B9 E8 0B 40 F9 08 81 00 91 09 01 40 B9 28 00 80 52 09 0D 1F 33 E8 0B 40 F9 08 81 00 91 09 01 00 B9 E8 0B 40 F9 09 41 00 91 E8 3B 40 F9 10 01 40 FD 30 01 00 FD E8 0B 40 F9 08 81 01 91 08 01 40 B9 09 01 00 32 E8 0B 40 F9 08 81 01 91 09 01 00 B9 E8 0B 40 F9 08 81 01 91 09 01 40 B9 28 00 80 52 09 0D 1F 33 E8 0B 40 F9 08 81 01 91 09 01 00 B9 E8 0B 40 F9 09 41 01 91 E8 2F 40 F9 10 01 40 FD 30 01 00 FD ?? ?? ?? ?? E3 43 00 91 22 00 80 52 01 00 80 52 E0 23 40 B9 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 E8 0B 40 F9 08 21 00 91 08 01 40 B9 C8 00 20 36 E8 0F 40 F9 08 01 40 F9 09 F9 77 92 E8 0F 40 F9 09 01 00 F9 E8 0B 40 F9 08 21 00 91 08 01 40 B9 C8 00 18 36 E8 0F 40 F9 08 01 40 F9 09 F9 76 92 E8 0F 40 F9 09 01 00 F9 E8 0B 40 F9 08 21 00 91 08 01 40 B9 C8 00 10 36 E8 0F 40 F9 08 01 40 F9 09 F9 75 92 E8 0F 40 F9 09 01 00 F9 E8 0B 40 F9 08 21 00 91 08 01 40 B9 C8 00 08 36 E8 0F 40 F9 08 01 40 F9 09 F9 74 92 E8 0F 40 F9 09 01 00 F9 E8 0B 40 F9 08 21 00 91 08 01 40 B9 C8 00 00 36 E8 0F 40 F9 08 01 40 F9 09 F9 73 92 E8 0F 40 F9 09 01 00 F9 E8 0B 40 F9 08 01 00 91 08 01 40 B9 08 05 00 12 E8 3F 00 B9 E8 3F 40 B9 1F 0D 00 71 28 04 00 54 EA 3F 40 B9 89 00 00 10 28 49 AA 38 28 09 08 8B 00 01 1F D6 16 0F 08 01 E8 0F 40 F9 09 01 40 F9 68 00 80 D2 09 05 6A B3 E8 0F 40 F9 09 01 00 F9 14 00 00 14 E8 0F 40 F9 09 01 40 F9 28 00 80 D2 09 05 6A B3 E8 0F 40 F9 09 01 00 F9 0D 00 00 14 E8 0F 40 F9 09 01 40 F9 48 00 80 D2 09 05 6A B3 E8 0F 40 F9 09 01 00 F9 06 00 00 14 E8 0F 40 F9 08 01 40 F9 09 F5 68 92 E8 0F 40 F9 09 01 00 F9 E8 43 40 B9 1F 01 00 71 E0 00 00 54 E8 0B 40 F9 09 41 01 91 E8 2F 40 F9 30 01 40 BD 10 01 00 BD 06 00 00 14 E8 0B 40 F9 09 41 01 91 E8 2F 40 F9 30 01 40 FD 10 01 00 FD FD 7B C8 A8 C0 03 5F D6 1F 20 03 D5 0D 00 00 C0 8F 00 00 C0 93 00 00 C0 91 00 00 C0 8E 00 00 C0 90 00 00 C0 }
	condition:
		$1
}

rule file_13_8_0 {
	meta:
		name = "_raise_excf"
		size = 72
		refs = "003c _raise_exc_ex"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 17 00 B9 E3 13 00 B9 E4 13 00 F9 E5 0F 00 F9 26 00 80 52 E5 0F 40 F9 E4 13 40 F9 E3 13 40 B9 E2 17 40 B9 E1 17 40 F9 E0 1B 40 F9 ?? ?? ?? ?? FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_13_9_0 {
	meta:
		name = "_set_errno_from_matherr"
		size = 112
		refs = "003c _errno"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 B9 E8 17 40 B9 E8 13 00 B9 E8 13 40 B9 1F 05 00 71 00 01 00 54 E8 13 40 B9 1F 05 00 71 0D 02 00 54 E8 13 40 B9 1F 0D 00 71 0D 01 00 54 0C 00 00 14 ?? ?? ?? ?? E0 0F 00 F9 E9 0F 40 F9 28 04 80 52 28 01 00 B9 06 00 00 14 ?? ?? ?? ?? E0 13 00 F9 E9 13 40 F9 48 04 80 52 28 01 00 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_13_10_0 {
	meta:
		name = "_umatherr"
		size = 216
		refs = "0024 _get_fname 0080 _ctrlfp 0088 __acrt_invoke_user_matherr 00a0 _set_errno_from_matherr"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 13 00 B9 E1 17 00 B9 E0 17 00 FD E1 1B 00 FD E2 13 00 FD E2 1F 00 F9 E0 17 40 B9 ?? ?? ?? ?? E0 37 00 F9 E8 37 40 F9 E8 27 00 F9 E8 27 40 F9 1F 01 00 F1 A0 03 00 54 E8 13 40 B9 E8 43 00 B9 E8 2B 40 B9 E8 53 00 B9 E8 2F 40 B9 E8 57 00 B9 E8 33 40 B9 E8 5B 00 B9 E8 37 40 B9 E8 5F 00 B9 E8 23 40 B9 E8 63 00 B9 E8 27 40 B9 E8 67 00 B9 C1 02 00 58 E0 1F 40 F9 ?? ?? ?? ?? E0 03 01 91 ?? ?? ?? ?? E0 1B 00 B9 E8 1B 40 B9 1F 01 00 71 61 00 00 54 E0 13 40 B9 ?? ?? ?? ?? E0 33 40 FD 08 00 00 14 07 00 00 14 01 01 00 58 E0 1F 40 F9 ?? ?? ?? ?? E0 13 40 B9 ?? ?? ?? ?? E0 13 40 FD FD 7B C7 A8 C0 03 5F D6 00 9F C0 03 00 00 00 00 }
	condition:
		$1
}

rule file_14_4_0 {
	meta:
		name = "_wcsxfrm_l"
		size = 1208
		refs = "0058 ??_C@_1CE@EOIGACOB@?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 0060 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0070 ??_C@_1GE@EEOADBAP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 007c _CrtDbgReportW 00a4 _errno 00c8 ??_C@_1BG@BGLDKGGG@?$AA_?$AAw?$AAc?$AAs?$AAx?$AAf?$AAr?$AAm?$AA_?$AAl?$AA?$AA@ 00d8 _invalid_parameter 0124 ??_C@_1EG@IHNOIFPP@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN@ 01e4 ??_C@_1CI@NAPEFFEJ@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0278 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0284 ?GetLocaleT@_LocaleUpdate@@QEAAPEAU__crt_locale_pointers@@XZ 02b4 wcsncpy 02bc wcslen 02d0 ??1_LocaleUpdate@@QEAA@XZ 0310 __acrt_LCMapStringW"
	strings:
		$1 = { FD 7B B0 A9 FD 03 00 91 E0 13 00 F9 E1 23 00 F9 E2 0F 00 F9 E3 3F 00 F9 08 00 B0 12 E8 13 00 B9 E9 7B 40 B2 E8 0F 40 F9 1F 01 09 EB 88 00 00 54 28 00 80 52 E8 2B 00 B9 03 00 00 14 08 00 80 52 E8 2B 00 B9 E8 2B 40 B9 E8 2F 00 B9 E8 2F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 07 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 4B 00 B9 E9 4B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 2F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 33 00 F9 E9 33 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 A3 07 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 7B 40 B2 F4 00 00 14 E8 13 40 F9 1F 01 00 F1 E1 00 00 54 E8 0F 40 F9 1F 01 00 F1 80 00 00 54 08 00 80 52 E8 33 00 B9 03 00 00 14 28 00 80 52 E8 33 00 B9 E8 33 40 B9 E8 37 00 B9 E8 37 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 07 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 4F 00 B9 E9 4F 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 37 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 37 00 F9 E9 37 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 07 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 7B 40 B2 C1 00 00 14 E8 23 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 3B 00 B9 03 00 00 14 08 00 80 52 E8 3B 00 B9 E8 3B 40 B9 E8 3F 00 B9 E8 3F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 07 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 53 00 B9 E9 53 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 3F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 3B 00 F9 E9 3B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 07 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 7B 40 B2 91 00 00 14 E1 3F 40 F9 E0 43 03 91 ?? ?? ?? ?? E0 7B 00 F9 E0 43 03 91 ?? ?? ?? ?? E0 43 00 F9 E8 43 40 F9 08 01 00 91 08 01 40 F9 08 C1 04 91 08 01 40 F9 1F 01 00 F1 C1 01 00 54 E2 0F 40 F9 E1 23 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 23 40 F9 ?? ?? ?? ?? E0 47 00 F9 E8 47 40 F9 E8 4B 00 F9 E0 43 03 91 ?? ?? ?? ?? E0 4B 40 F9 76 00 00 14 E0 43 03 91 ?? ?? ?? ?? E0 4F 00 F9 E8 4F 40 F9 08 01 00 91 08 01 40 F9 08 C1 04 91 05 00 80 52 04 00 80 D2 03 00 80 12 E2 23 40 F9 01 80 80 52 00 01 40 F9 ?? ?? ?? ?? E0 57 00 B9 E8 57 40 B9 E8 13 00 B9 E9 13 40 B9 08 00 80 52 1F 01 09 6B 21 01 00 54 ?? ?? ?? ?? E0 53 00 F9 E9 53 40 F9 48 05 80 52 28 01 00 B9 08 00 B0 12 E8 13 00 B9 53 00 00 14 E8 0F 40 F9 09 01 00 11 E8 13 40 B9 1F 01 09 6B AC 07 00 54 E0 43 03 91 ?? ?? ?? ?? E0 57 00 F9 E8 0F 40 F9 05 01 00 11 E8 57 40 F9 08 01 00 91 08 01 40 F9 08 C1 04 91 A5 00 00 11 E4 13 40 F9 03 00 80 12 E2 23 40 F9 01 80 80 52 00 01 40 F9 ?? ?? ?? ?? E0 5B 00 B9 E8 5B 40 B9 E8 13 00 B9 E9 13 40 B9 08 00 80 52 1F 01 09 6B 21 01 00 54 ?? ?? ?? ?? E0 5B 00 F9 E9 5B 40 F9 48 05 80 52 28 01 00 B9 08 00 B0 12 E8 13 00 B9 1D 00 00 14 E8 13 40 B9 08 7D 40 93 E8 0F 00 F9 E8 13 40 B9 08 05 00 51 E8 13 00 B9 E8 0F 40 F9 E8 5F 00 F9 E8 0F 40 F9 08 05 00 D1 E8 0F 00 F9 E8 5F 40 F9 1F 01 00 F1 E9 01 00 54 E9 0F 40 F9 28 00 80 D2 29 7D 08 9B E8 13 40 F9 08 01 09 8B 0A 01 40 39 4A 01 00 11 E9 0F 40 F9 48 00 80 D2 29 7D 08 9B E8 13 40 F9 08 01 09 8B 0A 01 00 79 EB FF FF 17 12 00 00 14 E8 13 40 F9 1F 01 00 F1 80 01 00 54 E8 0F 40 F9 1F 01 00 F1 29 01 00 54 E9 13 40 F9 08 00 80 52 28 01 00 79 ?? ?? ?? ?? E0 63 00 F9 E9 63 40 F9 48 04 80 52 28 01 00 B9 E8 13 40 B9 08 05 00 51 E8 13 00 B9 E8 13 40 B9 08 7D 40 93 E8 67 00 F9 E0 43 03 91 ?? ?? ?? ?? E0 67 40 F9 FD 7B D0 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_14_5_0 {
	meta:
		name = "wcsxfrm"
		size = 56
		refs = "0024 _wcsxfrm_l"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E2 0B 00 F9 03 00 80 D2 E2 0B 40 F9 E1 0F 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 17 00 F9 E0 17 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_538_13_0 {
	meta:
		name = "_aligned_realloc_base"
		size = 56
		refs = "0024 _aligned_offset_realloc_base"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E2 0B 00 F9 03 00 80 D2 E2 0B 40 F9 E1 0F 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 17 00 F9 E0 17 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_516_5_0 {
	meta:
		name = "strxfrm"
		size = 56
		refs = "0024 _strxfrm_l"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E2 0B 00 F9 03 00 80 D2 E2 0B 40 F9 E1 0F 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 17 00 F9 E0 17 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_167_9_0 {
	meta:
		name = "wcstombs"
		size = 56
		refs = "0024 ?_wcstombs_l_helper@@YA_KPEADPEB_W_KPEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E2 0B 00 F9 03 00 80 D2 E2 0B 40 F9 E1 0F 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 17 00 F9 E0 17 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "_logb"
		size = 328
		refs = "0060 ??_C@_05JGDBENOH@_logb?$AA@ 0068 _handle_error 00d8 _handle_nan"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 13 00 FD F0 13 40 FD F0 17 00 FD E8 17 40 F9 E8 0B 00 F9 E8 0B 40 F9 08 29 4C 92 08 FD 74 D3 08 FD 0F D1 E8 0F 00 F9 E8 0B 40 F9 08 F9 40 92 1F 01 00 F1 01 02 00 54 26 00 80 52 E1 07 00 5C E0 13 40 FD 45 04 80 52 84 00 80 52 43 00 80 52 02 FE FF D2 A1 04 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 1B 00 FD E0 1B 40 FD 31 00 00 14 30 00 00 14 E9 0F 40 F9 A8 7F 80 92 1F 01 09 EB 2C 01 00 54 E8 0F 40 F9 1F FD 0F F1 CC 00 00 54 E8 0F 40 F9 00 01 62 9E 00 40 60 1E 25 00 00 14 24 00 00 14 E8 0F 40 F9 1F FD 0F F1 CD 01 00 54 E8 0B 40 F9 08 CD 40 92 1F 01 00 F1 81 00 00 54 E0 13 40 FD 1B 00 00 14 06 00 00 14 E0 0B 40 F9 ?? ?? ?? ?? E0 1F 00 FD E0 1F 40 FD 15 00 00 14 14 00 00 14 E8 0B 40 F9 08 CD 40 92 E8 0B 00 F9 A8 7F 80 92 E8 0F 00 F9 09 02 E0 D2 E8 0B 40 F9 1F 01 09 EB 02 01 00 54 E8 0B 40 F9 08 F9 7F D3 E8 0B 00 F9 E8 0F 40 F9 08 05 00 D1 E8 0F 00 F9 F6 FF FF 17 E8 0F 40 F9 00 01 62 9E 00 40 60 1E FD 7B C4 A8 C0 03 5F D6 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "_lfind"
		size = 1172
		refs = "0050 ??_C@_1BO@GJOLAGLP@?$AAk?$AAe?$AAy?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1GA@CAPCBDEK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0074 _CrtDbgReportW 009c _errno 00c0 ??_C@_1O@OHGEBJAD@?$AA_?$AAl?$AAf?$AAi?$AAn?$AAd?$AA?$AA@ 00d0 _invalid_parameter 0110 ??_C@_1BO@DPJBHFOB@?$AAn?$AAu?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01e0 ??_C@_1DK@GBFPGLPH@?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CK?$AAn?$AAu?$AAm?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 02a0 ??_C@_1BE@NJBEBBME@?$AAw?$AAi?$AAd?$AAt?$AAh?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0360 ??_C@_1CG@PNGKIMLM@?$AAc?$AAo?$AAm?$AAp?$AAa?$AAr?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0450 __guard_check_icall_fptr"
	strings:
		$1 = { FD 7B B4 A9 FD 03 00 91 E0 43 00 F9 E1 37 00 F9 E2 33 00 F9 E3 13 00 B9 E4 3F 00 F9 E8 43 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 17 00 B9 03 00 00 14 08 00 80 52 E8 17 00 B9 E8 17 40 B9 E8 1B 00 B9 E8 1B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 07 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 4B 00 B9 E9 4B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 1B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 4B 00 F9 E9 4B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 83 07 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 ED 00 00 14 E8 33 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 1F 00 B9 03 00 00 14 08 00 80 52 E8 1F 00 B9 E8 1F 40 B9 E8 23 00 B9 E8 23 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 07 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 4F 00 B9 E9 4F 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 23 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 4F 00 F9 E9 4F 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 A3 07 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 BD 00 00 14 E8 37 40 F9 1F 01 00 F1 01 01 00 54 E8 33 40 F9 08 01 40 B9 1F 01 00 71 80 00 00 54 08 00 80 52 E8 27 00 B9 03 00 00 14 28 00 80 52 E8 27 00 B9 E8 27 40 B9 E8 2B 00 B9 E8 2B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 07 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 53 00 B9 E9 53 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 2B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 53 00 F9 E9 53 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 07 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 89 00 00 14 E8 13 40 B9 1F 01 00 71 89 00 00 54 28 00 80 52 E8 2F 00 B9 03 00 00 14 08 00 80 52 E8 2F 00 B9 E8 2F 40 B9 E8 33 00 B9 E8 33 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 07 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 57 00 B9 E9 57 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 33 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 57 00 F9 E9 57 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 07 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 59 00 00 14 E8 3F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 37 00 B9 03 00 00 14 08 00 80 52 E8 37 00 B9 E8 37 40 B9 E8 3B 00 B9 E8 3B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 02 08 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 5B 00 B9 E9 5B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 3B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 5B 00 F9 E9 5B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 03 08 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 29 00 00 14 E8 37 40 F9 E8 3B 00 F9 E8 33 40 F9 09 01 40 B9 E8 13 40 B9 28 7D 08 1B 09 7D 40 D3 E8 3B 40 F9 08 01 09 8B E8 5F 00 F9 E8 3B 40 F9 E8 23 00 F9 06 00 00 14 E8 13 40 B9 09 7D 40 D3 E8 23 40 F9 08 01 09 8B E8 23 00 F9 E9 5F 40 F9 E8 23 40 F9 1F 01 09 EB 40 02 00 54 E8 3F 40 F9 E8 47 00 F9 EF 47 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 E1 23 40 F9 E0 43 40 F9 E8 47 40 F9 00 01 3F D6 E0 5F 00 B9 E8 5F 40 B9 1F 01 00 71 61 00 00 54 E0 23 40 F9 03 00 00 14 E7 FF FF 17 00 00 80 D2 FD 7B CC A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_17_5_0 {
	meta:
		name = "_mbsnextc_l"
		size = 212
		refs = "0018 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0020 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0024 ??_C@_1BK@FPAMLIDG@?$AAs?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0028 ??_C@_1HC@OKGOOFB@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0044 _CrtDbgReportW 0054 _errno 0060 ??_C@_1BI@IOLGAJKA@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAe?$AAx?$AAt?$AAc?$AA_?$AAl?$AA?$AA@ 0078 _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 13 00 00 91 E0 43 00 91 14 00 80 52 ?? ?? ?? ?? 53 03 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 05 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 05 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 0C 00 00 14 6A 02 40 39 E8 13 40 F9 48 01 08 8B 09 65 40 39 A9 00 10 36 68 06 40 39 68 00 00 34 54 5D 18 53 73 06 00 91 68 02 40 39 00 01 14 0B E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "?is_lfh_enabled@@YA_NXZ"
		size = 128
		refs = "0020 __acrt_heap 0028 __imp_HeapQueryInformation"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 08 00 80 12 E8 13 00 B9 04 00 80 D2 83 00 80 D2 E2 43 00 91 01 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 E0 1B 00 B9 E8 1B 40 B9 1F 01 00 71 61 00 00 54 00 00 80 52 0C 00 00 14 E8 13 40 B9 1F 09 00 71 81 00 00 54 28 00 80 52 E8 17 00 B9 03 00 00 14 08 00 80 52 E8 17 00 B9 E8 17 40 B9 00 1D 00 53 00 00 00 11 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_18_1_0 {
	meta:
		name = "_expand"
		size = 56
		refs = "0024 _expand_dbg"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 0B 00 F9 04 00 80 52 03 00 80 D2 22 00 80 52 E1 0B 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 F9 E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_680_76_0 {
	meta:
		name = "_tempnam"
		size = 56
		refs = "0024 ??$common_tempnam@D@@YAPEADQEBD0H0H@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 0B 00 F9 04 00 80 52 03 00 80 D2 22 00 80 52 E1 0B 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 F9 E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_680_78_0 {
	meta:
		name = "_wtempnam"
		size = 56
		refs = "0024 ??$common_tempnam@_W@@YAPEA_WQEB_W0HQEBDH@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 0B 00 F9 04 00 80 52 03 00 80 D2 22 00 80 52 E1 0B 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 F9 E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "calloc"
		size = 56
		refs = "0024 _calloc_dbg"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 0B 00 F9 04 00 80 52 03 00 80 D2 22 00 80 52 E1 0B 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 F9 E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_454_0_0 {
	meta:
		name = "realloc"
		size = 56
		refs = "0024 _realloc_dbg"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 0B 00 F9 04 00 80 52 03 00 80 D2 22 00 80 52 E1 0B 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 F9 E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_18_2_0 {
	meta:
		name = "_expand_base"
		size = 516
		refs = "0044 ??_C@_1CC@CKEAHJPH@?$AAb?$AAl?$AAo?$AAc?$AAk?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 004c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 005c ??_C@_1FO@GEKPJHID@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAh@ 0068 _CrtDbgReportW 0090 _errno 00b4 ??_C@_1BK@JMCGJOCC@?$AA_?$AAe?$AAx?$AAp?$AAa?$AAn?$AAd?$AA_?$AAb?$AAa?$AAs?$AAe?$AA?$AA@ 00c4 _invalid_parameter 0100 __acrt_heap 0108 __imp_HeapSize 015c __imp_HeapReAlloc 01a8 ?is_lfh_enabled@@YA_NXZ 01c8 __imp_GetLastError 01dc __acrt_errno_from_os_error"
	strings:
		$1 = { FD 7B B7 A9 FD 03 00 91 E0 13 00 F9 E1 1F 00 F9 E8 13 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 17 00 B9 03 00 00 14 08 00 80 52 E8 17 00 B9 E8 17 40 B9 E8 1B 00 B9 E8 1B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 22 05 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 2B 00 B9 E9 2B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 1B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 33 00 F9 E9 33 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 23 05 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 4C 00 00 14 E8 1F 40 F9 1F 81 00 B1 09 01 00 54 ?? ?? ?? ?? E0 37 00 F9 E9 37 40 F9 88 01 80 52 28 01 00 B9 00 00 80 D2 42 00 00 14 E2 13 40 F9 01 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 E0 3B 00 F9 E8 3B 40 F9 E8 2B 00 F9 E8 1F 40 F9 1F 01 00 F1 81 00 00 54 28 00 80 D2 E8 23 00 F9 03 00 00 14 E8 1F 40 F9 E8 23 00 F9 E8 23 40 F9 E8 2F 00 F9 E3 2F 40 F9 E2 13 40 F9 01 02 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 E0 3F 00 F9 E8 3F 40 F9 E8 27 00 F9 E8 27 40 F9 1F 01 00 F1 60 00 00 54 E0 27 40 F9 1E 00 00 14 09 00 88 D2 E8 2B 40 F9 1F 01 09 EB A8 01 00 54 E9 2B 40 F9 E8 2F 40 F9 1F 01 09 EB 28 01 00 54 ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 60 00 00 54 E0 13 40 F9 0E 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 E0 2F 00 B9 E0 2F 40 B9 ?? ?? ?? ?? E0 33 00 B9 ?? ?? ?? ?? E0 43 00 F9 E9 43 40 F9 E8 33 40 B9 28 01 00 B9 00 00 80 D2 FD 7B C9 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_19_3_0 {
	meta:
		name = "?common_mbstrlen_l@@YA_KQEBD_KQEAU__crt_locale_pointers@@@Z"
		size = 708
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0030 ?GetLocaleT@_LocaleUpdate@@QEAAPEAU__crt_locale_pointers@@XZ 0084 ??_C@_1BBK@OJOCBOE@?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA_?$AAu?$AAp?$AAd?$AAa?$AAt?$AAe?$AA?4?$AAG?$AAe?$AAt?$AAL?$AAo?$AAc?$AAa?$AAl?$AAe?$AAT?$AA?$CI?$AA?$CJ?$AA?9?$AA?$DO?$AAl?$AAo?$AAc?$AAi@ 008c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 009c ??_C@_1GG@HHGHPEAK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 00a8 _CrtDbgReportW 00f8 strnlen 010c ??1_LocaleUpdate@@QEAA@XZ 0158 __imp_MultiByteToWideChar 0174 _errno 0228 _isleadbyte_l"
	strings:
		$1 = { FD 7B B2 A9 FD 03 00 91 E0 1F 00 F9 E1 13 00 F9 E2 3B 00 F9 E1 3B 40 F9 E0 43 01 91 ?? ?? ?? ?? E0 3F 00 F9 E8 3F 40 F9 E8 6B 00 F9 E0 43 01 91 ?? ?? ?? ?? E0 43 00 F9 E8 43 40 F9 08 01 00 91 08 01 40 F9 08 01 00 91 08 21 00 91 08 01 40 B9 1F 05 00 71 80 03 00 54 E0 43 01 91 ?? ?? ?? ?? E0 47 00 F9 E8 47 40 F9 08 01 00 91 08 01 40 F9 08 01 00 91 08 21 00 91 08 01 40 B9 1F 09 00 71 20 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 04 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 2B 00 B9 E9 2B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E0 43 01 91 ?? ?? ?? ?? E0 4B 00 F9 E8 4B 40 F9 08 01 00 91 08 01 40 F9 08 01 00 91 08 21 00 91 08 01 40 B9 1F 05 00 71 61 01 00 54 E1 13 40 F9 E0 1F 40 F9 ?? ?? ?? ?? E0 4F 00 F9 E8 4F 40 F9 E8 53 00 F9 E0 43 01 91 ?? ?? ?? ?? E0 53 40 F9 6A 00 00 14 E0 43 01 91 ?? ?? ?? ?? E0 57 00 F9 E8 13 40 F9 03 01 00 11 E8 57 40 F9 08 01 00 91 08 01 40 F9 08 01 00 91 08 31 00 91 05 00 80 52 04 00 80 D2 63 00 00 11 E2 1F 40 F9 21 01 80 52 00 01 40 B9 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 E0 2F 00 B9 E8 2F 40 B9 1F 01 00 71 81 01 00 54 ?? ?? ?? ?? E0 5B 00 F9 E9 5B 40 F9 48 05 80 52 28 01 00 B9 08 00 80 92 E8 5F 00 F9 E0 43 01 91 ?? ?? ?? ?? E0 5F 40 F9 48 00 00 14 08 00 80 D2 E8 23 00 F9 08 00 80 D2 E8 0F 00 F9 E8 1F 40 F9 E8 0B 00 F9 0A 00 00 14 E8 23 40 F9 08 05 00 91 E8 23 00 F9 E8 0B 40 F9 08 05 00 91 E8 0B 00 F9 E8 0F 40 F9 08 05 00 91 E8 0F 00 F9 E9 13 40 F9 E8 0F 40 F9 1F 01 09 EB C2 04 00 54 E8 0B 40 F9 08 01 C0 39 08 01 00 11 1F 01 00 71 20 04 00 54 E0 43 01 91 ?? ?? ?? ?? E0 63 00 F9 E8 0B 40 F9 08 01 C0 39 00 1D 00 53 00 00 00 11 E1 63 40 F9 00 00 00 11 ?? ?? ?? ?? E0 33 00 B9 E8 33 40 B9 1F 01 00 71 40 02 00 54 E8 0F 40 F9 08 05 00 91 E8 0F 00 F9 E9 13 40 F9 E8 0F 40 F9 1F 01 09 EB 43 00 00 54 0B 00 00 14 E8 0B 40 F9 08 05 00 91 E8 0B 00 F9 E8 0B 40 F9 08 01 C0 39 08 01 00 11 1F 01 00 71 41 00 00 54 02 00 00 14 CF FF FF 17 E9 13 40 F9 E8 0F 40 F9 1F 01 09 EB 83 00 00 54 E8 13 40 F9 E8 27 00 F9 03 00 00 14 E8 23 40 F9 E8 27 00 F9 E8 27 40 F9 E8 67 00 F9 E0 43 01 91 ?? ?? ?? ?? E0 67 40 F9 FD 7B CE A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_19_5_0 {
	meta:
		name = "_mbstrlen"
		size = 88
		refs = "000c __acrt_locale_changed 0028 strlen 0044 _mbstrlen_l"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 E1 00 00 54 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 F9 E0 13 40 F9 07 00 00 14 06 00 00 14 01 00 80 D2 E0 0F 40 F9 ?? ?? ?? ?? E0 17 00 F9 E0 17 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_19_6_0 {
	meta:
		name = "_mbstrlen_l"
		size = 48
		refs = "001c ?common_mbstrlen_l@@YA_KQEBD_KQEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 0B 00 F9 E2 0B 40 F9 01 00 80 92 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 F9 E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_19_7_0 {
	meta:
		name = "_mbstrnlen"
		size = 48
		refs = "001c _mbstrnlen_l"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 0B 00 F9 02 00 80 D2 E1 0B 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 F9 E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_538_3_0 {
	meta:
		name = "_aligned_malloc_base"
		size = 48
		refs = "001c _aligned_offset_malloc_base"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 0B 00 F9 02 00 80 D2 E1 0B 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 F9 E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_19_8_0 {
	meta:
		name = "_mbstrnlen_l"
		size = 440
		refs = "0048 ??_C@_1CE@BLLJFLOH@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0050 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0060 ??_C@_1GG@HHGHPEAK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 006c _CrtDbgReportW 0094 _errno 00b8 ??_C@_1BK@NDCACHED@?$AA_?$AAm?$AAb?$AAs?$AAt?$AAr?$AAn?$AAl?$AAe?$AAn?$AA_?$AAl?$AA?$AA@ 00c8 _invalid_parameter 010c ??_C@_1CI@DJIFDDII@?$AAm?$AAa?$AAx?$AA_?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 01a4 ?common_mbstrlen_l@@YA_KQEBD_KQEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { FD 7B BA A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 27 00 F9 E8 1B 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 13 00 B9 03 00 00 14 08 00 80 52 E8 13 00 B9 E8 13 40 B9 E8 17 00 B9 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 0D 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 1F 00 F9 E9 1F 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 63 0D 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 92 38 00 00 14 E9 7B 40 B2 E8 17 40 F9 1F 01 09 EB 88 00 00 54 28 00 80 52 E8 1B 00 B9 03 00 00 14 08 00 80 52 E8 1B 00 B9 E8 1B 40 B9 E8 1F 00 B9 E8 1F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 0D 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 27 00 B9 E9 27 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 1F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 23 00 F9 E9 23 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 83 0D 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 92 07 00 00 14 E2 27 40 F9 E1 17 40 F9 E0 1B 40 F9 ?? ?? ?? ?? E0 2B 00 F9 E0 2B 40 F9 FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_20_4_0 {
	meta:
		name = "_wcsicmp"
		size = 744
		refs = "0010 __acrt_locale_changed 005c ??_C@_1BO@GCPMHDON@?$AAd?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0064 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0074 ??_C@_1GE@FNNJGCGI@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0080 _CrtDbgReportW 00a8 _errno 00cc ??_C@_1BC@NHIBDOMC@?$AA_?$AAw?$AAc?$AAs?$AAi?$AAc?$AAm?$AAp?$AA?$AA@ 00dc _invalid_parameter 011c ??_C@_1BO@NEBGDLJE@?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 02d4 _wcsicmp_l"
	strings:
		$1 = { FD 7B BA A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 21 15 00 54 E8 13 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 2B 00 B9 03 00 00 14 08 00 80 52 E8 2B 00 B9 E8 2B 40 B9 E8 2F 00 B9 E8 2F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 0A 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 43 00 B9 E9 43 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 2F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 2B 00 F9 E9 2B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 A3 0A 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 B0 12 7F 00 00 14 E8 0F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 33 00 B9 03 00 00 14 08 00 80 52 E8 33 00 B9 E8 33 40 B9 E8 37 00 B9 E8 37 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 0A 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 47 00 B9 E9 47 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 37 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 2F 00 F9 E9 2F 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 0A 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 B0 12 4F 00 00 14 E8 13 40 F9 08 01 40 79 08 01 00 11 1F 05 01 71 AB 01 00 54 E8 13 40 F9 08 01 40 79 08 01 00 11 1F 69 01 71 0C 01 00 54 E8 13 40 F9 08 01 40 79 08 01 00 11 08 05 01 51 08 85 01 11 E8 3B 00 B9 05 00 00 14 E8 13 40 F9 08 01 40 79 08 01 00 11 E8 3B 00 B9 E8 3B 40 B9 08 3D 00 53 E8 27 00 79 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F 05 01 71 AB 01 00 54 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F 69 01 71 0C 01 00 54 E8 0F 40 F9 08 01 40 79 08 01 00 11 08 05 01 51 08 85 01 11 E8 3F 00 B9 05 00 00 14 E8 0F 40 F9 08 01 40 79 08 01 00 11 E8 3F 00 B9 E8 3F 40 B9 08 3D 00 53 E8 2B 00 79 E8 13 40 F9 08 09 00 91 E8 13 00 F9 E8 0F 40 F9 08 09 00 91 E8 0F 00 F9 E8 27 40 79 08 01 00 11 1F 01 00 71 E0 00 00 54 E9 27 40 79 29 01 00 11 E8 2B 40 79 08 01 00 11 3F 01 08 6B 20 F8 FF 54 E9 27 40 79 29 01 00 11 E8 2B 40 79 08 01 00 11 20 01 08 4B 00 00 00 11 08 00 00 14 07 00 00 14 02 00 80 D2 E1 0F 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 4B 00 B9 E0 4B 40 B9 FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_20_5_0 {
	meta:
		name = "_wcsicmp_l"
		size = 956
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0058 ??_C@_1BO@GCPMHDON@?$AAd?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0060 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0070 ??_C@_1GE@FNNJGCGI@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 007c _CrtDbgReportW 00a4 _errno 00c8 ??_C@_1BG@EELGPCPD@?$AA_?$AAw?$AAc?$AAs?$AAi?$AAc?$AAm?$AAp?$AA_?$AAl?$AA?$AA@ 00d8 _invalid_parameter 00e8 ??1_LocaleUpdate@@QEAA@XZ 0128 ??_C@_1BO@NEBGDLJE@?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01c8 ?GetLocaleT@_LocaleUpdate@@QEAAPEAU__crt_locale_pointers@@XZ 0310 _towlower_l"
	strings:
		$1 = { FD 7B B4 A9 FD 03 00 91 E0 0F 00 F9 E1 13 00 F9 E2 33 00 F9 E1 33 40 F9 E0 43 02 91 ?? ?? ?? ?? E0 5B 00 F9 E8 0F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 33 00 B9 03 00 00 14 08 00 80 52 E8 33 00 B9 E8 33 40 B9 E8 37 00 B9 E8 37 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 22 06 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 4B 00 B9 E9 4B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 37 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 37 00 F9 E9 37 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 23 06 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 08 00 B0 12 E8 4F 00 B9 E0 43 02 91 ?? ?? ?? ?? E0 4F 40 B9 B1 00 00 14 E8 13 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 3B 00 B9 03 00 00 14 08 00 80 52 E8 3B 00 B9 E8 3B 40 B9 E8 3F 00 B9 E8 3F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 06 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 53 00 B9 E9 53 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 3F 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 3B 00 F9 E9 3B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 43 06 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 08 00 B0 12 E8 57 00 B9 E0 43 02 91 ?? ?? ?? ?? E0 57 40 B9 7D 00 00 14 E0 43 02 91 ?? ?? ?? ?? E0 3F 00 F9 E8 3F 40 F9 08 01 00 91 08 01 40 F9 08 E1 04 91 08 01 40 F9 1F 01 00 F1 41 08 00 54 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F 05 01 71 AB 01 00 54 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F 69 01 71 0C 01 00 54 E8 0F 40 F9 08 01 40 79 08 01 00 11 08 05 01 51 08 85 01 11 E8 43 00 B9 05 00 00 14 E8 0F 40 F9 08 01 40 79 08 01 00 11 E8 43 00 B9 E8 43 40 B9 08 3D 00 53 E8 23 00 79 E8 13 40 F9 08 01 40 79 08 01 00 11 1F 05 01 71 AB 01 00 54 E8 13 40 F9 08 01 40 79 08 01 00 11 1F 69 01 71 0C 01 00 54 E8 13 40 F9 08 01 40 79 08 01 00 11 08 05 01 51 08 85 01 11 E8 47 00 B9 05 00 00 14 E8 13 40 F9 08 01 40 79 08 01 00 11 E8 47 00 B9 E8 47 40 B9 08 3D 00 53 E8 27 00 79 E8 0F 40 F9 08 09 00 91 E8 0F 00 F9 E8 13 40 F9 08 09 00 91 E8 13 00 F9 E8 23 40 79 08 01 00 11 1F 01 00 71 E0 00 00 54 E9 23 40 79 29 01 00 11 E8 27 40 79 08 01 00 11 3F 01 08 6B 20 F8 FF 54 29 00 00 14 E0 43 02 91 ?? ?? ?? ?? E0 43 00 F9 E8 0F 40 F9 08 01 40 79 E8 53 00 79 E1 43 40 F9 E0 53 40 79 ?? ?? ?? ?? E0 57 00 79 E8 57 40 79 E8 23 00 79 E8 0F 40 F9 08 09 00 91 E8 0F 00 F9 E0 43 02 91 ?? ?? ?? ?? E0 47 00 F9 E8 13 40 F9 08 01 40 79 E8 5B 00 79 E1 47 40 F9 E0 5B 40 79 ?? ?? ?? ?? E0 5F 00 79 E8 5F 40 79 E8 27 00 79 E8 13 40 F9 08 09 00 91 E8 13 00 F9 E8 23 40 79 08 01 00 11 1F 01 00 71 E0 00 00 54 E9 23 40 79 29 01 00 11 E8 27 40 79 08 01 00 11 3F 01 08 6B 20 FB FF 54 E9 23 40 79 29 01 00 11 E8 27 40 79 08 01 00 11 28 01 08 4B E8 5B 00 B9 E0 43 02 91 ?? ?? ?? ?? E0 5B 40 B9 FD 7B CC A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_21_2_0 {
	meta:
		name = "??$common_system@D@@YAHQEBD@Z"
		size = 412
		refs = "000c __security_push_cookie 0014 ??_C@_0DC@GGIGALME@minkernel?2crts?2ucrt?2inc?2corecrt_@ 001c ?comspec_name@?1???$common_system@D@@YAHQEBD@Z@4QBDB 003c _dupenv_s_dbg 0060 _access_s 0078 ??_C@_1CG@IPGACMHA@?$AAc?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AA?$FL?$AA0?$AA?$FN?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?8?$AA?2?$AA0?$AA?8?$AA?$AA@ 0080 ??_C@_1GG@LJIGDNNP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0084 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 009c _CrtDbgReportW 00b0 ?slash_c@?1???$common_system@D@@YAHQEBD@Z@4QBDB 00c4 _errno 00e4 _spawnve 0130 ?cmd_exe@?1???$common_system@D@@YAHQEBD@Z@4QBDB 014c _spawnvpe 015c _free_dbg 0168 __security_pop_cookie 0180 ??_C@_1JK@PAMMDFPO@?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAc?$AAr?$AAt?$AA?$CI?$AAc?$AAo?$AAm?$AAs?$AAp?$AAe?$AAc?$AA_?$AAv?$AAa@ 0184 ??_C@_1BM@NCHJIBJC@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAs?$AAy?$AAs?$AAt?$AAe?$AAm?$AA?$AA@ 0198 _invoke_watson"
	strings:
		$1 = { FD 7B BE A9 F3 53 01 A9 FD 03 00 91 ?? ?? ?? ?? FF 83 00 D1 ?? ?? ?? ?? FF 03 00 F9 ?? ?? ?? ?? 13 00 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 45 0D 80 52 43 00 80 52 01 00 80 D2 E0 03 00 91 ?? ?? ?? ?? 1F 58 00 71 A0 09 00 54 53 01 00 B5 E0 03 40 F9 60 00 00 B5 13 00 80 52 40 00 00 14 01 00 80 52 ?? ?? ?? ?? 1F 00 00 71 F3 17 9F 1A 3A 00 00 14 68 02 C0 39 C8 01 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 05 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 E8 03 40 F9 ?? ?? ?? ?? F3 FF 01 A9 ?? ?? ?? ?? E8 A7 00 A9 88 03 00 B4 ?? ?? ?? ?? 14 00 40 B9 ?? ?? ?? ?? 03 00 80 D2 1F 00 00 B9 E1 07 40 F9 E2 23 00 91 00 00 80 52 ?? ?? ?? ?? 13 00 00 11 7F 06 00 31 80 00 00 54 ?? ?? ?? ?? 14 00 00 B9 16 00 00 14 ?? ?? ?? ?? 08 00 40 B9 1F 09 00 71 E0 00 00 54 ?? ?? ?? ?? 08 00 40 B9 1F 35 00 71 60 00 00 54 13 00 80 12 0C 00 00 14 ?? ?? ?? ?? 14 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E8 07 00 F9 E2 23 00 91 ?? ?? ?? ?? 00 00 80 52 ?? ?? ?? ?? 13 00 00 11 E0 03 40 F9 41 00 80 52 ?? ?? ?? ?? 60 02 00 11 FF 83 00 91 ?? ?? ?? ?? F3 53 41 A9 FD 7B C2 A8 C0 03 5F D6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_3_0 {
	meta:
		name = "??$common_system@_W@@YAHQEB_W@Z"
		size = 412
		refs = "000c __security_push_cookie 0014 ??_C@_0DC@GGIGALME@minkernel?2crts?2ucrt?2inc?2corecrt_@ 001c ?comspec_name@?1???$common_system@_W@@YAHQEB_W@Z@4QB_WB 003c _wdupenv_s_dbg 0060 _waccess_s 0078 ??_C@_1CG@IPGACMHA@?$AAc?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AA?$FL?$AA0?$AA?$FN?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?8?$AA?2?$AA0?$AA?8?$AA?$AA@ 0080 ??_C@_1GG@LJIGDNNP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0084 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 009c _CrtDbgReportW 00b0 ?slash_c@?1???$common_system@_W@@YAHQEB_W@Z@4QB_WB 00c4 _errno 00e4 _wspawnve 0130 ?cmd_exe@?1???$common_system@_W@@YAHQEB_W@Z@4QB_WB 014c _wspawnvpe 015c _free_dbg 0168 __security_pop_cookie 0180 ??_C@_1JK@PAMMDFPO@?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAc?$AAr?$AAt?$AA?$CI?$AAc?$AAo?$AAm?$AAs?$AAp?$AAe?$AAc?$AA_?$AAv?$AAa@ 0184 ??_C@_1BM@NCHJIBJC@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAs?$AAy?$AAs?$AAt?$AAe?$AAm?$AA?$AA@ 0198 _invoke_watson"
	strings:
		$1 = { FD 7B BE A9 F3 53 01 A9 FD 03 00 91 ?? ?? ?? ?? FF 83 00 D1 ?? ?? ?? ?? FF 03 00 F9 ?? ?? ?? ?? 13 00 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 25 0F 80 52 43 00 80 52 01 00 80 D2 E0 03 00 91 ?? ?? ?? ?? 1F 58 00 71 A0 09 00 54 53 01 00 B5 E0 03 40 F9 60 00 00 B5 13 00 80 52 40 00 00 14 01 00 80 52 ?? ?? ?? ?? 1F 00 00 71 F3 17 9F 1A 3A 00 00 14 68 02 40 79 C8 01 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 05 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 E8 03 40 F9 ?? ?? ?? ?? F3 FF 01 A9 ?? ?? ?? ?? E8 A7 00 A9 88 03 00 B4 ?? ?? ?? ?? 14 00 40 B9 ?? ?? ?? ?? 03 00 80 D2 1F 00 00 B9 E1 07 40 F9 E2 23 00 91 00 00 80 52 ?? ?? ?? ?? 13 00 00 11 7F 06 00 31 80 00 00 54 ?? ?? ?? ?? 14 00 00 B9 16 00 00 14 ?? ?? ?? ?? 08 00 40 B9 1F 09 00 71 E0 00 00 54 ?? ?? ?? ?? 08 00 40 B9 1F 35 00 71 60 00 00 54 13 00 80 12 0C 00 00 14 ?? ?? ?? ?? 14 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E8 07 00 F9 E2 23 00 91 ?? ?? ?? ?? 00 00 80 52 ?? ?? ?? ?? 13 00 00 11 E0 03 40 F9 41 00 80 52 ?? ?? ?? ?? 60 02 00 11 FF 83 00 91 ?? ?? ?? ?? F3 53 41 A9 FD 7B C2 A8 C0 03 5F D6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_6_0 {
	meta:
		name = "??$tdupenv_s_crt@PEAPEAD$$TAEAY07$$CBD@?$__crt_char_traits@D@@SAH$$QEAPEAPEAD$$QEA$$TAEAY07$$CBD@Z"
		size = 28
		refs = "0000 ??_C@_0DC@GGIGALME@minkernel?2crts?2ucrt?2inc?2corecrt_@ 0018 _dupenv_s_dbg"
		altNames = "??$tdupenv_s_crt@PEAPEAD$$TAEAY04$$CBD@?$__crt_char_traits@D@@SAH$$QEAPEAPEAD$$QEA$$TAEAY04$$CBD@Z ??$tdupenv_s_crt@PEAPEAD$$TAEAY0L@$$CBD@?$__crt_char_traits@D@@SAH$$QEAPEAPEAD$$QEA$$TAEAY0L@$$CBD@Z"
	strings:
		$1 = { ?? ?? ?? ?? 21 00 40 F9 ?? ?? ?? ?? 00 00 40 F9 45 0D 80 52 43 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_15_3 {
	meta:
		name = "??$tcscat_s@AEAPEADAEB_KPEAD@?$__crt_char_traits@D@@SAHAEAPEADAEB_K$$QEAPEAD@Z"
		size = 16
		refs = "000c strcat_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_17_3 {
	meta:
		name = "??$tcscat_s@AEAPEA_WAEB_KPEA_W@?$__crt_char_traits@_W@@SAHAEAPEA_WAEB_K$$QEAPEA_W@Z"
		size = 16
		refs = "000c wcscat_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_195_18_3 {
	meta:
		name = "??$tcscat_s@PEADAEB_KAEBQEBD@?$__crt_char_traits@D@@SAH$$QEAPEADAEB_KAEBQEBD@Z"
		size = 16
		refs = "000c strcat_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_195_19_3 {
	meta:
		name = "??$tcscat_s@PEA_WAEB_KAEBQEB_W@?$__crt_char_traits@_W@@SAH$$QEAPEA_WAEB_KAEBQEB_W@Z"
		size = 16
		refs = "000c wcscat_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_18_4 {
	meta:
		name = "??$tcscpy_s@AEAPEADAEA_KAEBQEBD@?$__crt_char_traits@D@@SAHAEAPEADAEA_KAEBQEBD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_531_18_2 {
	meta:
		name = "??$tcscpy_s@AEAPEADAEB_KAEAPEAD@?$__crt_char_traits@D@@SAHAEAPEADAEB_K0@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_696_20_2 {
	meta:
		name = "??$tcscpy_s@AEAPEADAEB_KAEBQEBD@?$__crt_char_traits@D@@SAHAEAPEADAEB_KAEBQEBD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_497_8_3 {
	meta:
		name = "??$tcscpy_s@AEAPEAD_KAEBQEBD@?$__crt_char_traits@D@@SAHAEAPEAD$$QEA_KAEBQEBD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_21_4 {
	meta:
		name = "??$tcscpy_s@AEAPEA_WAEA_KAEBQEB_W@?$__crt_char_traits@_W@@SAHAEAPEA_WAEA_KAEBQEB_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_531_19_0 {
	meta:
		name = "??$tcscpy_s@AEAPEA_WAEB_KAEAPEA_W@?$__crt_char_traits@_W@@SAHAEAPEA_WAEB_K0@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_696_21_0 {
	meta:
		name = "??$tcscpy_s@AEAPEA_WAEB_KAEBQEB_W@?$__crt_char_traits@_W@@SAHAEAPEA_WAEB_KAEBQEB_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_23_2 {
	meta:
		name = "??$tcscpy_s@AEAPEA_W_KAEBQEB_W@?$__crt_char_traits@_W@@SAHAEAPEA_W$$QEA_KAEBQEB_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_497_10_3 {
	meta:
		name = "??$tcscpy_s@AEBQEADAEB_KAEAPEAD@?$__crt_char_traits@D@@SAHAEBQEADAEB_KAEAPEAD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_531_20_2 {
	meta:
		name = "??$tcscpy_s@AEBQEADAEB_KAEBQEAD@?$__crt_char_traits@D@@SAHAEBQEADAEB_K0@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_696_22_4 {
	meta:
		name = "??$tcscpy_s@AEBQEADAEB_KAEBQEBD@?$__crt_char_traits@D@@SAHAEBQEADAEB_KAEBQEBD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_497_11_4 {
	meta:
		name = "??$tcscpy_s@AEBQEA_WAEB_KAEAPEA_W@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_KAEAPEA_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_531_21_2 {
	meta:
		name = "??$tcscpy_s@AEBQEA_WAEB_KAEBQEA_W@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_K0@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_696_23_2 {
	meta:
		name = "??$tcscpy_s@AEBQEA_WAEB_KAEBQEB_W@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_KAEBQEB_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_357_22_2 {
	meta:
		name = "??$tcscpy_s@PEADAEB_KAEAPEAD@?$__crt_char_traits@D@@SAH$$QEAPEADAEB_KAEAPEAD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_195_22_2 {
	meta:
		name = "??$tcscpy_s@PEADAEB_KAEAPEBD@?$__crt_char_traits@D@@SAH$$QEAPEADAEB_KAEAPEBD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_230_31_3 {
	meta:
		name = "??$tcscpy_s@PEADAEB_KAEBQEBD@?$__crt_char_traits@D@@SAH$$QEAPEADAEB_KAEBQEBD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_281_19_3 {
	meta:
		name = "??$tcscpy_s@PEAD_KAEBQEBD@?$__crt_char_traits@D@@SAH$$QEAPEAD$$QEA_KAEBQEBD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_357_23_2 {
	meta:
		name = "??$tcscpy_s@PEA_WAEB_KAEAPEA_W@?$__crt_char_traits@_W@@SAH$$QEAPEA_WAEB_KAEAPEA_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_195_24_4 {
	meta:
		name = "??$tcscpy_s@PEA_WAEB_KAEAPEB_W@?$__crt_char_traits@_W@@SAH$$QEAPEA_WAEB_KAEAPEB_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_230_32_3 {
	meta:
		name = "??$tcscpy_s@PEA_WAEB_KAEBQEB_W@?$__crt_char_traits@_W@@SAH$$QEAPEA_WAEB_KAEBQEB_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_281_21_4 {
	meta:
		name = "??$tcscpy_s@PEA_W_KAEBQEB_W@?$__crt_char_traits@_W@@SAH$$QEAPEA_W$$QEA_KAEBQEB_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_696_28_0 {
	meta:
		name = "??$tcsnicoll@AEAPEADAEBQEBDAEB_K@?$__crt_char_traits@D@@SAHAEAPEADAEBQEBDAEB_K@Z"
		size = 16
		refs = "000c _strnicoll"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_696_29_3 {
	meta:
		name = "??$tcsnicoll@AEAPEA_WAEBQEB_WAEB_K@?$__crt_char_traits@_W@@SAHAEAPEA_WAEBQEB_WAEB_K@Z"
		size = 16
		refs = "000c _wcsnicoll"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_531_26_3 {
	meta:
		name = "??$tcsnicoll@AEBQEBDAEAPEADAEB_K@?$__crt_char_traits@D@@SAHAEBQEBDAEAPEADAEB_K@Z"
		size = 16
		refs = "000c _strnicoll"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_531_27_4 {
	meta:
		name = "??$tcsnicoll@AEBQEB_WAEAPEA_WAEB_K@?$__crt_char_traits@_W@@SAHAEBQEB_WAEAPEA_WAEB_K@Z"
		size = 16
		refs = "000c _wcsnicoll"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_128_4 {
	meta:
		name = "??$tcstol@AEAPEBDPEAPEADH@?$__crt_char_traits@D@@SAJAEAPEBD$$QEAPEAPEAD$$QEAH@Z"
		size = 16
		refs = "000c strtol"
	strings:
		$1 = { 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_129_0 {
	meta:
		name = "??$tcstol@AEAPEB_WPEAPEA_WH@?$__crt_char_traits@_W@@SAJAEAPEB_W$$QEAPEAPEA_W$$QEAH@Z"
		size = 16
		refs = "000c wcstol"
	strings:
		$1 = { 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_130_2 {
	meta:
		name = "??$tcstol@PEBDPEAPEADH@?$__crt_char_traits@D@@SAJ$$QEAPEBD$$QEAPEAPEAD$$QEAH@Z"
		size = 16
		refs = "000c strtol"
	strings:
		$1 = { 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_131_2 {
	meta:
		name = "??$tcstol@PEB_WPEAPEA_WH@?$__crt_char_traits@_W@@SAJ$$QEAPEB_W$$QEAPEAPEA_W$$QEAH@Z"
		size = 16
		refs = "000c wcstol"
	strings:
		$1 = { 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_213_64_0 {
	meta:
		name = "??$tcstoull@AEAPEB_WPEAPEA_WH@?$__crt_char_traits@_W@@SA_KAEAPEB_W$$QEAPEAPEA_W$$QEAH@Z"
		size = 16
		refs = "000c wcstoull"
	strings:
		$1 = { 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_213_65_0 {
	meta:
		name = "??$tcstoull@PEBDPEAPEADH@?$__crt_char_traits@D@@SA_K$$QEAPEBD$$QEAPEAPEAD$$QEAH@Z"
		size = 16
		refs = "000c strtoull"
	strings:
		$1 = { 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_497_20_0 {
	meta:
		name = "??$tfullpath@AEBQEADAEBQEBDAEB_K@?$__crt_char_traits@D@@SAPEADAEBQEADAEBQEBDAEB_K@Z"
		size = 16
		refs = "000c _fullpath"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_497_21_0 {
	meta:
		name = "??$tfullpath@AEBQEA_WAEBQEB_WAEB_K@?$__crt_char_traits@_W@@SAPEA_WAEBQEA_WAEBQEB_WAEB_K@Z"
		size = 16
		refs = "000c _wfullpath"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_379_22_2 {
	meta:
		name = "??$tgetpath@AEAPEADAEAPEADH@?$__crt_char_traits@D@@SAPEADAEAPEAD0$$QEAH@Z"
		size = 16
		refs = "000c __acrt_getpath"
	strings:
		$1 = { 42 00 80 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_497_22_0 {
	meta:
		name = "??$tgetpath@AEAPEADAEAPEAD_K@?$__crt_char_traits@D@@SAPEADAEAPEAD0$$QEA_K@Z"
		size = 16
		refs = "000c __acrt_getpath"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_379_23_3 {
	meta:
		name = "??$tgetpath@AEAPEA_WAEAPEA_WH@?$__crt_char_traits@_W@@SAPEA_WAEAPEA_W0$$QEAH@Z"
		size = 16
		refs = "000c __acrt_wgetpath"
	strings:
		$1 = { 42 00 80 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_497_23_4 {
	meta:
		name = "??$tgetpath@AEAPEA_WAEAPEA_W_K@?$__crt_char_traits@_W@@SAPEA_WAEAPEA_W0$$QEA_K@Z"
		size = 16
		refs = "000c __acrt_wgetpath"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_230_45_3 {
	meta:
		name = "??$tgetpath@AEAPEBDPEADH@?$__crt_char_traits@D@@SAPEADAEAPEBD$$QEAPEAD$$QEAH@Z"
		size = 16
		refs = "000c __acrt_getpath"
	strings:
		$1 = { 42 00 80 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_230_46_3 {
	meta:
		name = "??$tgetpath@AEAPEB_WPEA_WH@?$__crt_char_traits@_W@@SAPEA_WAEAPEB_W$$QEAPEA_W$$QEAH@Z"
		size = 16
		refs = "000c __acrt_wgetpath"
	strings:
		$1 = { 42 00 80 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_497_24_2 {
	meta:
		name = "??$tgetpath@AEBQEADAEAPEAD_K@?$__crt_char_traits@D@@SAPEADAEBQEADAEAPEAD$$QEA_K@Z"
		size = 16
		refs = "000c __acrt_getpath"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_497_25_2 {
	meta:
		name = "??$tgetpath@AEBQEA_WAEAPEA_W_K@?$__crt_char_traits@_W@@SAPEA_WAEBQEA_WAEAPEA_W$$QEA_K@Z"
		size = 16
		refs = "000c __acrt_wgetpath"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_8_3 {
	meta:
		name = "??$tspawnve@HAEAPEBDAEAY03PEBD$$T@?$__crt_char_traits@D@@SA_J$$QEAHAEAPEBDAEAY03PEBD$$QEA$$T@Z"
		size = 16
		refs = "000c _spawnve"
	strings:
		$1 = { 63 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_9_4 {
	meta:
		name = "??$tspawnve@HAEAPEB_WAEAY03PEB_W$$T@?$__crt_char_traits@_W@@SA_J$$QEAHAEAPEB_WAEAY03PEB_W$$QEA$$T@Z"
		size = 16
		refs = "000c _wspawnve"
	strings:
		$1 = { 63 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_10_4 {
	meta:
		name = "??$tspawnvpe@HAEAPEBDAEAY03PEBD$$T@?$__crt_char_traits@D@@SA_J$$QEAHAEAPEBDAEAY03PEBD$$QEA$$T@Z"
		size = 16
		refs = "000c _spawnvpe"
	strings:
		$1 = { 63 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_11_4 {
	meta:
		name = "??$tspawnvpe@HAEAPEB_WAEAY03PEB_W$$T@?$__crt_char_traits@_W@@SA_J$$QEAHAEAPEB_WAEAY03PEB_W$$QEA$$T@Z"
		size = 16
		refs = "000c _wspawnvpe"
	strings:
		$1 = { 63 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_7_0 {
	meta:
		name = "??$tdupenv_s_crt@PEAPEA_W$$TAEAY07$$CB_W@?$__crt_char_traits@_W@@SAH$$QEAPEAPEA_W$$QEA$$TAEAY07$$CB_W@Z"
		size = 28
		refs = "0000 ??_C@_0DC@GGIGALME@minkernel?2crts?2ucrt?2inc?2corecrt_@ 0018 _wdupenv_s_dbg"
		altNames = "??$tdupenv_s_crt@PEAPEA_W$$TAEAY04$$CB_W@?$__crt_char_traits@_W@@SAH$$QEAPEAPEA_W$$QEA$$TAEAY04$$CB_W@Z ??$tdupenv_s_crt@PEAPEA_W$$TAEAY0L@$$CB_W@?$__crt_char_traits@_W@@SAH$$QEAPEAPEA_W$$QEA$$TAEAY0L@$$CB_W@Z"
	strings:
		$1 = { ?? ?? ?? ?? 21 00 40 F9 ?? ?? ?? ?? 00 00 40 F9 25 0F 80 52 43 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_14_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAA@XZ"
		size = 44
		refs = "0018 _free_dbg"
		altNames = "??1?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@Uprocess_handle_pair@?A0xe43b7539@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAA@XZ ??1?$scanset_buffer@_W@__crt_stdio_input@@QEAA@XZ ??1?$scanset_storage@$01@__crt_stdio_input@@QEAA@XZ ?release@?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@Uprocess_handle_pair@?A0xe43b7539@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 02 40 F9 41 00 80 52 ?? ?? ?? ?? 7F 02 00 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_21_16_0 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEBA_NXZ"
		size = 16
		altNames = "??B?$__crt_unique_handle_t@Uenvironment_strings_traits@?A0x1bf47908@@@@QEBA_NXZ ??B?$__crt_unique_handle_t@Uprocess_handle_pair_traits@?A0xe43b7539@@@@QEBA_NXZ ??B?$__crt_unique_handle_t@Ustream_traits@?A0xe43b7539@@@@QEBA_NXZ ??B?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEBA_NXZ ??B?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEBA_NXZ ??B?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEBA_NXZ ??B?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_handle_t@Uenvironment_strings_traits@?A0x1bf47908@@@@QEBA_NXZ ?is_valid@?$__crt_unique_handle_t@Uprocess_handle_pair_traits@?A0xe43b7539@@@@QEBA_NXZ ?is_valid@?$__crt_unique_handle_t@Ustream_traits@?A0xe43b7539@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEBA_NXZ"
	strings:
		$1 = { 08 00 40 F9 1F 01 00 F1 E0 07 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_21_26_0 {
	meta:
		name = "_invoke_watson_if_oneof"
		size = 52
		refs = "0030 _invoke_watson"
	strings:
		$1 = { 68 00 00 91 89 00 00 91 80 00 00 34 1F 00 01 6B 04 10 42 7A 40 00 00 54 C0 03 5F D6 E4 00 00 91 C3 00 00 11 A2 00 00 91 21 01 00 91 00 01 00 91 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_27_0 {
	meta:
		name = "_wsystem"
		size = 452
		refs = "000c __security_push_cookie 0014 ??_C@_0DC@GGIGALME@minkernel?2crts?2ucrt?2inc?2corecrt_@ 001c ?comspec_name@?1???$common_system@_W@@YAHQEB_W@Z@4QB_WB 003c _wdupenv_s_dbg 005c _free_dbg 006c _waccess_s 0094 ??_C@_1CG@IPGACMHA@?$AAc?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AA?$FL?$AA0?$AA?$FN?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?8?$AA?2?$AA0?$AA?8?$AA?$AA@ 009c ??_C@_1GG@LJIGDNNP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 00a0 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00b8 _CrtDbgReportW 00cc ?slash_c@?1???$common_system@_W@@YAHQEB_W@Z@4QB_WB 00e0 _errno 0100 _wspawnve 0158 ?cmd_exe@?1???$common_system@_W@@YAHQEB_W@Z@4QB_WB 0174 _wspawnvpe 0190 __security_pop_cookie 01a8 ??_C@_1JK@PAMMDFPO@?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAc?$AAr?$AAt?$AA?$CI?$AAc?$AAo?$AAm?$AAs?$AAp?$AAe?$AAc?$AA_?$AAv?$AAa@ 01ac ??_C@_1BM@NCHJIBJC@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAs?$AAy?$AAs?$AAt?$AAe?$AAm?$AA?$AA@ 01c0 _invoke_watson"
	strings:
		$1 = { FD 7B BE A9 F3 53 01 A9 FD 03 00 91 ?? ?? ?? ?? FF 83 00 D1 ?? ?? ?? ?? FF 03 00 F9 ?? ?? ?? ?? 13 00 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 25 0F 80 52 43 00 80 52 01 00 80 D2 E0 03 00 91 ?? ?? ?? ?? 1F 58 00 71 E0 0A 00 54 33 02 00 B5 E0 03 40 F9 C0 00 00 B5 41 00 80 52 00 00 80 D2 ?? ?? ?? ?? 13 00 80 52 49 00 00 14 01 00 80 52 ?? ?? ?? ?? 41 00 80 52 13 00 00 11 E0 03 40 F9 ?? ?? ?? ?? 7F 02 00 71 F3 17 9F 1A 40 00 00 14 68 02 40 79 C8 01 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 05 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 E8 03 40 F9 ?? ?? ?? ?? F3 FF 01 A9 ?? ?? ?? ?? E8 A7 00 A9 E8 03 00 B4 ?? ?? ?? ?? 14 00 40 B9 ?? ?? ?? ?? 03 00 80 D2 1F 00 00 B9 E1 07 40 F9 E2 23 00 91 00 00 80 52 ?? ?? ?? ?? 13 00 00 11 7F 06 00 31 80 00 00 54 ?? ?? ?? ?? 14 00 00 B9 19 00 00 14 ?? ?? ?? ?? 08 00 40 B9 1F 09 00 71 40 01 00 54 ?? ?? ?? ?? 08 00 40 B9 1F 35 00 71 C0 00 00 54 E0 03 40 F9 41 00 80 52 ?? ?? ?? ?? 13 00 80 12 0F 00 00 14 ?? ?? ?? ?? 14 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E8 07 00 F9 E2 23 00 91 ?? ?? ?? ?? 00 00 80 52 ?? ?? ?? ?? 13 00 00 91 E0 03 40 F9 41 00 80 52 ?? ?? ?? ?? 60 02 00 11 FF 83 00 91 ?? ?? ?? ?? F3 53 41 A9 FD 7B C2 A8 C0 03 5F D6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_28_0 {
	meta:
		name = "system"
		size = 452
		refs = "000c __security_push_cookie 0014 ??_C@_0DC@GGIGALME@minkernel?2crts?2ucrt?2inc?2corecrt_@ 001c ?comspec_name@?1???$common_system@D@@YAHQEBD@Z@4QBDB 003c _dupenv_s_dbg 005c _free_dbg 006c _access_s 0094 ??_C@_1CG@IPGACMHA@?$AAc?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AA?$FL?$AA0?$AA?$FN?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?8?$AA?2?$AA0?$AA?8?$AA?$AA@ 009c ??_C@_1GG@LJIGDNNP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 00a0 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00b8 _CrtDbgReportW 00cc ?slash_c@?1???$common_system@D@@YAHQEBD@Z@4QBDB 00e0 _errno 0100 _spawnve 0158 ?cmd_exe@?1???$common_system@D@@YAHQEBD@Z@4QBDB 0174 _spawnvpe 0190 __security_pop_cookie 01a8 ??_C@_1JK@PAMMDFPO@?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAc?$AAr?$AAt?$AA?$CI?$AAc?$AAo?$AAm?$AAs?$AAp?$AAe?$AAc?$AA_?$AAv?$AAa@ 01ac ??_C@_1BM@NCHJIBJC@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAs?$AAy?$AAs?$AAt?$AAe?$AAm?$AA?$AA@ 01c0 _invoke_watson"
	strings:
		$1 = { FD 7B BE A9 F3 53 01 A9 FD 03 00 91 ?? ?? ?? ?? FF 83 00 D1 ?? ?? ?? ?? FF 03 00 F9 ?? ?? ?? ?? 13 00 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 45 0D 80 52 43 00 80 52 01 00 80 D2 E0 03 00 91 ?? ?? ?? ?? 1F 58 00 71 E0 0A 00 54 33 02 00 B5 E0 03 40 F9 C0 00 00 B5 41 00 80 52 00 00 80 D2 ?? ?? ?? ?? 13 00 80 52 49 00 00 14 01 00 80 52 ?? ?? ?? ?? 41 00 80 52 13 00 00 11 E0 03 40 F9 ?? ?? ?? ?? 7F 02 00 71 F3 17 9F 1A 40 00 00 14 68 02 C0 39 C8 01 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 05 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 E8 03 40 F9 ?? ?? ?? ?? F3 FF 01 A9 ?? ?? ?? ?? E8 A7 00 A9 E8 03 00 B4 ?? ?? ?? ?? 14 00 40 B9 ?? ?? ?? ?? 03 00 80 D2 1F 00 00 B9 E1 07 40 F9 E2 23 00 91 00 00 80 52 ?? ?? ?? ?? 13 00 00 11 7F 06 00 31 80 00 00 54 ?? ?? ?? ?? 14 00 00 B9 19 00 00 14 ?? ?? ?? ?? 08 00 40 B9 1F 09 00 71 40 01 00 54 ?? ?? ?? ?? 08 00 40 B9 1F 35 00 71 C0 00 00 54 E0 03 40 F9 41 00 80 52 ?? ?? ?? ?? 13 00 80 12 0F 00 00 14 ?? ?? ?? ?? 14 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E8 07 00 F9 E2 23 00 91 ?? ?? ?? ?? 00 00 80 52 ?? ?? ?? ?? 13 00 00 91 E0 03 40 F9 41 00 80 52 ?? ?? ?? ?? 60 02 00 11 FF 83 00 91 ?? ?? ?? ?? F3 53 41 A9 FD 7B C2 A8 C0 03 5F D6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "_msize"
		size = 40
		refs = "0014 _msize_dbg"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 21 00 80 52 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_348_14_0 {
	meta:
		name = "_mktime64"
		size = 40
		refs = "0014 ??$common_mktime@_J@@YA_JQEAUtm@@_N@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 21 00 80 52 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_22_1_0 {
	meta:
		name = "_msize_base"
		size = 248
		refs = "0040 ??_C@_1CC@CKEAHJPH@?$AAb?$AAl?$AAo?$AAc?$AAk?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0048 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0058 ??_C@_1FM@MMDMNOHM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAh@ 0064 _CrtDbgReportW 008c _errno 00b0 ??_C@_1BI@MHNDMCP@?$AA_?$AAm?$AAs?$AAi?$AAz?$AAe?$AA_?$AAb?$AAa?$AAs?$AAe?$AA?$AA@ 00c0 _invalid_parameter 00d4 __acrt_heap 00dc __imp_HeapSize"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 13 00 F9 E8 13 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 13 00 B9 03 00 00 14 08 00 80 52 E8 13 00 B9 E8 13 40 B9 E8 17 00 B9 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 02 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 17 00 F9 E9 17 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 02 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 92 0A 00 00 14 E2 13 40 F9 01 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 E0 1B 00 F9 E0 1B 40 F9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "??$assemble_floating_point_ind@M@__crt_strtox@@YAXAEAM@Z"
		size = 112
	strings:
		$1 = { FF 43 00 D1 E0 07 00 F9 E8 07 40 F9 E8 03 00 F9 E8 03 40 F9 08 01 00 91 08 01 40 B9 09 01 01 32 E8 03 40 F9 08 01 00 91 09 01 00 B9 E8 03 40 F9 08 01 00 91 08 01 40 B9 09 1D 09 32 E8 03 40 F9 08 01 00 91 09 01 00 B9 E8 03 40 F9 08 01 00 91 09 01 40 B9 08 08 A0 52 09 59 00 33 E8 03 40 F9 08 01 00 91 09 01 00 B9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_1_0 {
	meta:
		name = "??$assemble_floating_point_ind@N@__crt_strtox@@YAXAEAN@Z"
		size = 112
	strings:
		$1 = { FF 43 00 D1 E0 07 00 F9 E8 07 40 F9 E8 03 00 F9 E8 03 40 F9 08 01 00 91 08 01 40 F9 09 01 41 B2 E8 03 40 F9 08 01 00 91 09 01 00 F9 E8 03 40 F9 08 01 00 91 08 01 40 F9 09 29 4C B2 E8 03 40 F9 08 01 00 91 09 01 00 F9 E8 03 40 F9 08 01 00 91 09 01 40 F9 08 01 E0 D2 09 CD 40 B3 E8 03 40 F9 08 01 00 91 09 01 00 F9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_2_0 {
	meta:
		name = "??$assemble_floating_point_infinity@M@__crt_strtox@@YAX_NAEAM@Z"
		size = 152
	strings:
		$1 = { FF 83 00 D1 E0 03 00 39 E1 0B 00 F9 E8 0B 40 F9 E8 07 00 F9 E8 03 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 07 00 B9 03 00 00 14 08 00 80 52 E8 07 00 B9 E8 07 40 F9 08 01 00 91 09 01 40 B9 E8 07 40 B9 09 01 01 33 E8 07 40 F9 08 01 00 91 09 01 00 B9 E8 07 40 F9 08 01 00 91 08 01 40 B9 09 1D 09 32 E8 07 40 F9 08 01 00 91 09 01 00 B9 E8 07 40 F9 08 01 00 91 08 01 40 B9 09 21 09 12 E8 07 40 F9 08 01 00 91 09 01 00 B9 FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_3_0 {
	meta:
		name = "??$assemble_floating_point_infinity@N@__crt_strtox@@YAX_NAEAN@Z"
		size = 156
	strings:
		$1 = { FF 83 00 D1 E0 03 00 39 E1 0B 00 F9 E8 0B 40 F9 E8 07 00 F9 E8 03 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 07 00 B9 03 00 00 14 08 00 80 52 E8 07 00 B9 E8 07 40 B9 0A 7D 40 93 E8 07 40 F9 08 01 00 91 09 01 40 F9 49 01 41 B3 E8 07 40 F9 08 01 00 91 09 01 00 F9 E8 07 40 F9 08 01 00 91 08 01 40 F9 09 29 4C B2 E8 07 40 F9 08 01 00 91 09 01 00 F9 E8 07 40 F9 08 01 00 91 08 01 40 F9 09 2D 4C 92 E8 07 40 F9 08 01 00 91 09 01 00 F9 FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_4_0 {
	meta:
		name = "??$assemble_floating_point_qnan@M@__crt_strtox@@YAX_NAEAM@Z"
		size = 152
	strings:
		$1 = { FF 83 00 D1 E0 03 00 39 E1 0B 00 F9 E8 0B 40 F9 E8 07 00 F9 E8 03 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 07 00 B9 03 00 00 14 08 00 80 52 E8 07 00 B9 E8 07 40 F9 08 01 00 91 09 01 40 B9 E8 07 40 B9 09 01 01 33 E8 07 40 F9 08 01 00 91 09 01 00 B9 E8 07 40 F9 08 01 00 91 08 01 40 B9 09 1D 09 32 E8 07 40 F9 08 01 00 91 09 01 00 B9 E8 07 40 F9 08 01 00 91 08 01 40 B9 09 59 00 32 E8 07 40 F9 08 01 00 91 09 01 00 B9 FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_5_0 {
	meta:
		name = "??$assemble_floating_point_qnan@N@__crt_strtox@@YAX_NAEAN@Z"
		size = 156
	strings:
		$1 = { FF 83 00 D1 E0 03 00 39 E1 0B 00 F9 E8 0B 40 F9 E8 07 00 F9 E8 03 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 07 00 B9 03 00 00 14 08 00 80 52 E8 07 00 B9 E8 07 40 B9 0A 7D 40 93 E8 07 40 F9 08 01 00 91 09 01 40 F9 49 01 41 B3 E8 07 40 F9 08 01 00 91 09 01 00 F9 E8 07 40 F9 08 01 00 91 08 01 40 F9 09 29 4C B2 E8 07 40 F9 08 01 00 91 09 01 00 F9 E8 07 40 F9 08 01 00 91 08 01 40 F9 09 CD 40 B2 E8 07 40 F9 08 01 00 91 09 01 00 F9 FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_6_0 {
	meta:
		name = "??$assemble_floating_point_snan@M@__crt_strtox@@YAX_NAEAM@Z"
		size = 156
	strings:
		$1 = { FF 83 00 D1 E0 03 00 39 E1 0B 00 F9 E8 0B 40 F9 E8 07 00 F9 E8 03 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 07 00 B9 03 00 00 14 08 00 80 52 E8 07 00 B9 E8 07 40 F9 08 01 00 91 09 01 40 B9 E8 07 40 B9 09 01 01 33 E8 07 40 F9 08 01 00 91 09 01 00 B9 E8 07 40 F9 08 01 00 91 08 01 40 B9 09 1D 09 32 E8 07 40 F9 08 01 00 91 09 01 00 B9 E8 07 40 F9 08 01 00 91 09 01 40 B9 28 00 80 52 09 59 00 33 E8 07 40 F9 08 01 00 91 09 01 00 B9 FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_7_0 {
	meta:
		name = "??$assemble_floating_point_snan@N@__crt_strtox@@YAX_NAEAN@Z"
		size = 160
	strings:
		$1 = { FF 83 00 D1 E0 03 00 39 E1 0B 00 F9 E8 0B 40 F9 E8 07 00 F9 E8 03 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 07 00 B9 03 00 00 14 08 00 80 52 E8 07 00 B9 E8 07 40 B9 0A 7D 40 93 E8 07 40 F9 08 01 00 91 09 01 40 F9 49 01 41 B3 E8 07 40 F9 08 01 00 91 09 01 00 F9 E8 07 40 F9 08 01 00 91 08 01 40 F9 09 29 4C B2 E8 07 40 F9 08 01 00 91 09 01 00 F9 E8 07 40 F9 08 01 00 91 09 01 40 F9 28 00 80 D2 09 CD 40 B3 E8 07 40 F9 08 01 00 91 09 01 00 F9 FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_8_0 {
	meta:
		name = "??$assemble_floating_point_value_t@M@__crt_strtox@@YA?AW4SLD_STATUS@@_NH_KAEAM@Z"
		size = 148
	strings:
		$1 = { FF 83 00 D1 E0 03 00 39 E1 07 00 B9 E2 0F 00 F9 E3 0B 00 F9 E8 0B 40 F9 E8 07 00 F9 EA 03 40 39 4A 01 00 11 E8 07 40 F9 08 01 00 91 09 01 40 B9 49 01 01 33 E8 07 40 F9 08 01 00 91 09 01 00 B9 E8 07 40 B9 0A FD 01 11 E8 07 40 F9 08 01 00 91 09 01 40 B9 49 1D 09 33 E8 07 40 F9 08 01 00 91 09 01 00 B9 E8 0F 40 F9 0A 01 00 11 E8 07 40 F9 08 01 00 91 09 01 40 B9 49 59 00 33 E8 07 40 F9 08 01 00 91 09 01 00 B9 00 00 80 52 FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_9_0 {
	meta:
		name = "??$assemble_floating_point_value_t@N@__crt_strtox@@YA?AW4SLD_STATUS@@_NH_KAEAN@Z"
		size = 152
	strings:
		$1 = { FF 83 00 D1 E0 03 00 39 E1 07 00 B9 E2 0F 00 F9 E3 0B 00 F9 E8 0B 40 F9 E8 07 00 F9 E8 03 40 39 08 01 00 11 0A 7D 40 93 E8 07 40 F9 08 01 00 91 09 01 40 F9 49 01 41 B3 E8 07 40 F9 08 01 00 91 09 01 00 F9 E8 07 40 B9 08 FD 0F 11 0A 7D 40 93 E8 07 40 F9 08 01 00 91 09 01 40 F9 49 29 4C B3 E8 07 40 F9 08 01 00 91 09 01 00 F9 E8 07 40 F9 08 01 00 91 09 01 40 F9 E8 0F 40 F9 09 CD 40 B3 E8 07 40 F9 08 01 00 91 09 01 00 F9 00 00 80 52 FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_10_0 {
	meta:
		name = "??$assemble_floating_point_zero@M@__crt_strtox@@YAX_NAEAM@Z"
		size = 152
	strings:
		$1 = { FF 83 00 D1 E0 03 00 39 E1 0B 00 F9 E8 0B 40 F9 E8 07 00 F9 E8 03 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 07 00 B9 03 00 00 14 08 00 80 52 E8 07 00 B9 E8 07 40 F9 08 01 00 91 09 01 40 B9 E8 07 40 B9 09 01 01 33 E8 07 40 F9 08 01 00 91 09 01 00 B9 E8 07 40 F9 08 01 00 91 08 01 40 B9 09 5D 01 12 E8 07 40 F9 08 01 00 91 09 01 00 B9 E8 07 40 F9 08 01 00 91 08 01 40 B9 09 21 09 12 E8 07 40 F9 08 01 00 91 09 01 00 B9 FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_11_0 {
	meta:
		name = "??$assemble_floating_point_zero@N@__crt_strtox@@YAX_NAEAN@Z"
		size = 156
	strings:
		$1 = { FF 83 00 D1 E0 03 00 39 E1 0B 00 F9 E8 0B 40 F9 E8 07 00 F9 E8 03 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 07 00 B9 03 00 00 14 08 00 80 52 E8 07 00 B9 E8 07 40 B9 0A 7D 40 93 E8 07 40 F9 08 01 00 91 09 01 40 F9 49 01 41 B3 E8 07 40 F9 08 01 00 91 09 01 00 F9 E8 07 40 F9 08 01 00 91 08 01 40 F9 09 D1 41 92 E8 07 40 F9 08 01 00 91 09 01 00 F9 E8 07 40 F9 08 01 00 91 08 01 40 F9 09 2D 4C 92 E8 07 40 F9 08 01 00 91 09 01 00 F9 FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_12_0 {
	meta:
		name = "??$common_strtod_l@MD@@YAMQEBDQEAPEADQEAU__crt_locale_pointers@@@Z"
		size = 412
		refs = "0060 ??_C@_1CE@BLLJFLOH@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0068 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0078 ??_C@_1GE@LDNEKBAL@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 0084 _CrtDbgReportW 00ac _errno 00d0 ??_C@_1CA@HBJOPDIL@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAd?$AA_?$AAl?$AA?$AA@ 00e0 _invalid_parameter 00f4 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0118 ??$make_c_string_character_source@DPEAPEAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBDQEAPEAD@Z 012c ?GetLocaleT@_LocaleUpdate@@QEAAPEAU__crt_locale_pointers@@XZ 0140 ??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QEAM@Z 0188 ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { FD 7B B5 A9 FD 03 00 91 E0 1F 00 F9 E1 1B 00 F9 E2 27 00 F9 E8 1B 40 F9 1F 01 00 F1 80 00 00 54 E9 1B 40 F9 E8 1F 40 F9 28 01 00 F9 E8 1F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 13 00 B9 03 00 00 14 08 00 80 52 E8 13 00 B9 E8 13 40 B9 E8 17 00 B9 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 23 00 F9 E9 23 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A0 05 00 1C 2A 00 00 14 E1 27 40 F9 E0 03 02 91 ?? ?? ?? ?? E0 3F 00 F9 F0 04 00 1C F0 1F 00 BD E8 83 02 91 E8 2B 00 F9 E2 1B 40 F9 E1 1F 40 F9 E0 2B 40 F9 ?? ?? ?? ?? E0 2F 00 F9 E8 2F 40 F9 E8 33 00 F9 E0 03 02 91 ?? ?? ?? ?? E0 37 00 F9 E2 73 00 91 E1 33 40 F9 E0 37 40 F9 ?? ?? ?? ?? E0 27 00 B9 E8 27 40 B9 E8 1B 00 B9 E8 1B 40 B9 1F 0D 00 71 80 00 00 54 E8 1B 40 B9 1F 09 00 71 C1 00 00 54 ?? ?? ?? ?? E0 3B 00 F9 E9 3B 40 F9 48 04 80 52 28 01 00 B9 F0 1F 40 BD F0 2B 00 BD E0 03 02 91 ?? ?? ?? ?? E0 2B 40 BD FD 7B CB A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_23_13_0 {
	meta:
		name = "??$common_strtod_l@M_W@@YAMQEB_WQEAPEA_WQEAU__crt_locale_pointers@@@Z"
		size = 412
		refs = "0060 ??_C@_1CE@BLLJFLOH@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0068 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0078 ??_C@_1GE@LDNEKBAL@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 0084 _CrtDbgReportW 00ac _errno 00d0 ??_C@_1CA@HBJOPDIL@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAd?$AA_?$AAl?$AA?$AA@ 00e0 _invalid_parameter 00f4 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0118 ??$make_c_string_character_source@_WPEAPEA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_WQEAPEA_W@Z 012c ?GetLocaleT@_LocaleUpdate@@QEAAPEAU__crt_locale_pointers@@XZ 0140 ??$parse_floating_point@V?$c_string_character_source@_W@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@QEAM@Z 0188 ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { FD 7B B5 A9 FD 03 00 91 E0 1F 00 F9 E1 1B 00 F9 E2 27 00 F9 E8 1B 40 F9 1F 01 00 F1 80 00 00 54 E9 1B 40 F9 E8 1F 40 F9 28 01 00 F9 E8 1F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 13 00 B9 03 00 00 14 08 00 80 52 E8 13 00 B9 E8 13 40 B9 E8 17 00 B9 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 23 00 F9 E9 23 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A0 05 00 1C 2A 00 00 14 E1 27 40 F9 E0 03 02 91 ?? ?? ?? ?? E0 3F 00 F9 F0 04 00 1C F0 1F 00 BD E8 83 02 91 E8 2B 00 F9 E2 1B 40 F9 E1 1F 40 F9 E0 2B 40 F9 ?? ?? ?? ?? E0 2F 00 F9 E8 2F 40 F9 E8 33 00 F9 E0 03 02 91 ?? ?? ?? ?? E0 37 00 F9 E2 73 00 91 E1 33 40 F9 E0 37 40 F9 ?? ?? ?? ?? E0 27 00 B9 E8 27 40 B9 E8 1B 00 B9 E8 1B 40 B9 1F 0D 00 71 80 00 00 54 E8 1B 40 B9 1F 09 00 71 C1 00 00 54 ?? ?? ?? ?? E0 3B 00 F9 E9 3B 40 F9 48 04 80 52 28 01 00 B9 F0 1F 40 BD F0 2B 00 BD E0 03 02 91 ?? ?? ?? ?? E0 2B 40 BD FD 7B CB A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_23_14_0 {
	meta:
		name = "??$common_strtod_l@ND@@YANQEBDQEAPEADQEAU__crt_locale_pointers@@@Z"
		size = 416
		refs = "0060 ??_C@_1CE@BLLJFLOH@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0068 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0078 ??_C@_1GE@LDNEKBAL@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 0084 _CrtDbgReportW 00ac _errno 00d0 ??_C@_1CA@HBJOPDIL@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAd?$AA_?$AAl?$AA?$AA@ 00e0 _invalid_parameter 00f4 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0118 ??$make_c_string_character_source@DPEAPEAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBDQEAPEAD@Z 012c ?GetLocaleT@_LocaleUpdate@@QEAAPEAU__crt_locale_pointers@@XZ 0140 ??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QEAN@Z 0188 ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { FD 7B B4 A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 27 00 F9 E8 17 40 F9 1F 01 00 F1 80 00 00 54 E9 17 40 F9 E8 1B 40 F9 28 01 00 F9 E8 1B 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 13 00 B9 03 00 00 14 08 00 80 52 E8 13 00 B9 E8 13 40 B9 E8 17 00 B9 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1F 00 B9 E9 1F 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 23 00 F9 E9 23 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A0 05 00 5C 2A 00 00 14 E1 27 40 F9 E0 23 02 91 ?? ?? ?? ?? E0 43 00 F9 F0 04 00 5C F0 1F 00 FD E8 A3 02 91 E8 2B 00 F9 E2 17 40 F9 E1 1B 40 F9 E0 2B 40 F9 ?? ?? ?? ?? E0 2F 00 F9 E8 2F 40 F9 E8 33 00 F9 E0 23 02 91 ?? ?? ?? ?? E0 37 00 F9 E2 E3 00 91 E1 33 40 F9 E0 37 40 F9 ?? ?? ?? ?? E0 23 00 B9 E8 23 40 B9 E8 1B 00 B9 E8 1B 40 B9 1F 0D 00 71 80 00 00 54 E8 1B 40 B9 1F 09 00 71 C1 00 00 54 ?? ?? ?? ?? E0 3B 00 F9 E9 3B 40 F9 48 04 80 52 28 01 00 B9 F0 1F 40 FD F0 3F 00 FD E0 23 02 91 ?? ?? ?? ?? E0 3F 40 FD FD 7B CC A8 C0 03 5F D6 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_23_15_0 {
	meta:
		name = "??$common_strtod_l@N_W@@YANQEB_WQEAPEA_WQEAU__crt_locale_pointers@@@Z"
		size = 416
		refs = "0060 ??_C@_1CE@BLLJFLOH@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0068 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0078 ??_C@_1GE@LDNEKBAL@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 0084 _CrtDbgReportW 00ac _errno 00d0 ??_C@_1CA@HBJOPDIL@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAd?$AA_?$AAl?$AA?$AA@ 00e0 _invalid_parameter 00f4 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0118 ??$make_c_string_character_source@_WPEAPEA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_WQEAPEA_W@Z 012c ?GetLocaleT@_LocaleUpdate@@QEAAPEAU__crt_locale_pointers@@XZ 0140 ??$parse_floating_point@V?$c_string_character_source@_W@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@QEAN@Z 0188 ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { FD 7B B4 A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 27 00 F9 E8 17 40 F9 1F 01 00 F1 80 00 00 54 E9 17 40 F9 E8 1B 40 F9 28 01 00 F9 E8 1B 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 13 00 B9 03 00 00 14 08 00 80 52 E8 13 00 B9 E8 13 40 B9 E8 17 00 B9 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1F 00 B9 E9 1F 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 23 00 F9 E9 23 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A0 05 00 5C 2A 00 00 14 E1 27 40 F9 E0 23 02 91 ?? ?? ?? ?? E0 43 00 F9 F0 04 00 5C F0 1F 00 FD E8 A3 02 91 E8 2B 00 F9 E2 17 40 F9 E1 1B 40 F9 E0 2B 40 F9 ?? ?? ?? ?? E0 2F 00 F9 E8 2F 40 F9 E8 33 00 F9 E0 23 02 91 ?? ?? ?? ?? E0 37 00 F9 E2 E3 00 91 E1 33 40 F9 E0 37 40 F9 ?? ?? ?? ?? E0 23 00 B9 E8 23 40 B9 E8 1B 00 B9 E8 1B 40 B9 1F 0D 00 71 80 00 00 54 E8 1B 40 B9 1F 09 00 71 C1 00 00 54 ?? ?? ?? ?? E0 3B 00 F9 E9 3B 40 F9 48 04 80 52 28 01 00 B9 F0 1F 40 FD F0 3F 00 FD E0 23 02 91 ?? ?? ?? ?? E0 3F 40 FD FD 7B CC A8 C0 03 5F D6 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_23_16_0 {
	meta:
		name = "??$convert_decimal_string_to_floating_type@M@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@0@AEAM@Z"
		size = 60
		refs = "0018 ??0floating_point_value@__crt_strtox@@QEAA@QEAM@Z 0028 ?convert_decimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@AEBVfloating_point_value@1@@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 17 00 F9 E1 0F 00 F9 E1 0F 40 F9 E0 C3 00 91 ?? ?? ?? ?? E0 13 00 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_17_2 {
	meta:
		name = "??$convert_decimal_string_to_floating_type@N@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@0@AEAN@Z"
		size = 60
		refs = "0018 ??0floating_point_value@__crt_strtox@@QEAA@QEAN@Z 0028 ?convert_decimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@AEBVfloating_point_value@1@@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 17 00 F9 E1 0F 00 F9 E1 0F 40 F9 E0 C3 00 91 ?? ?? ?? ?? E0 13 00 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_18_4 {
	meta:
		name = "??$convert_hexadecimal_string_to_floating_type@M@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@0@AEAM@Z"
		size = 60
		refs = "0018 ??0floating_point_value@__crt_strtox@@QEAA@QEAM@Z 0028 ?convert_hexadecimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@AEBVfloating_point_value@1@@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 17 00 F9 E1 0F 00 F9 E1 0F 40 F9 E0 C3 00 91 ?? ?? ?? ?? E0 13 00 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_27_4 {
	meta:
		name = "??$convert_hexadecimal_string_to_floating_type@N@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@0@AEAN@Z"
		size = 60
		refs = "0018 ??0floating_point_value@__crt_strtox@@QEAA@QEAN@Z 0028 ?convert_hexadecimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@AEBVfloating_point_value@1@@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 17 00 F9 E1 0F 00 F9 E1 0F 40 F9 E0 C3 00 91 ?? ?? ?? ?? E0 13 00 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_20_0 {
	meta:
		name = "??$make_c_string_character_source@DPEAPEAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBDQEAPEAD@Z"
		size = 52
		refs = "0020 ??0?$c_string_character_source@D@__crt_strtox@@QEAA@QEBDQEAPEBD@Z"
		altNames = "??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBD$$T@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0B 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 17 00 F9 E0 0B 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_237_21_0 {
	meta:
		name = "??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_W$$T@Z"
		size = 52
		refs = "0020 ??0?$c_string_character_source@_W@__crt_strtox@@QEAA@QEB_WQEAPEB_W@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0B 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 17 00 F9 E0 0B 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_21_0 {
	meta:
		name = "??$make_c_string_character_source@_WPEAPEA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_WQEAPEA_W@Z"
		size = 52
		refs = "0020 ??0?$c_string_character_source@_W@__crt_strtox@@QEAA@QEB_WQEAPEB_W@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0B 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 17 00 F9 E0 0B 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_22_0 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QEAM@Z"
		size = 528
		refs = "0008 __security_push_cookie 0050 ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0074 _CrtDbgReportW 009c _errno 00c0 ??_C@_1EG@HNBONIDJ@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAp?$AAa?$AAr?$AAs?$AAe?$AA_?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi@ 00d0 _invalid_parameter 00e0 ??1?$c_string_character_source@D@__crt_strtox@@QEAA@XZ 0120 ??_C@_1CE@KDGPAKOD@?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01c8 ??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@D@0@AEAUfloating_point_string@0@@Z 01e4 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAM@Z 0204 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 0D D1 E0 1F 00 F9 E1 0B 00 F9 E2 23 00 F9 E8 23 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 E8 07 00 B9 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 07 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 27 00 F9 E9 27 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 1F 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 1F 40 B9 46 00 00 14 E8 1F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 0B 00 B9 03 00 00 14 08 00 80 52 E8 0B 00 B9 E8 0B 40 B9 E8 0F 00 B9 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 2B 00 F9 E9 2B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 27 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 27 40 B9 12 00 00 14 E2 63 01 91 E1 0B 40 F9 E0 1F 40 F9 ?? ?? ?? ?? E0 2B 00 B9 E8 2B 40 B9 E8 2F 00 B9 E2 23 40 F9 E1 63 01 91 E0 2F 40 B9 ?? ?? ?? ?? E0 33 00 B9 E8 33 40 B9 E8 37 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 37 40 B9 FF 83 0D 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_23_0 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QEAN@Z"
		size = 528
		refs = "0008 __security_push_cookie 0050 ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0074 _CrtDbgReportW 009c _errno 00c0 ??_C@_1EG@HNBONIDJ@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAp?$AAa?$AAr?$AAs?$AAe?$AA_?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi@ 00d0 _invalid_parameter 00e0 ??1?$c_string_character_source@D@__crt_strtox@@QEAA@XZ 0120 ??_C@_1CE@KDGPAKOD@?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01c8 ??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@D@0@AEAUfloating_point_string@0@@Z 01e4 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAN@Z 0204 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 0D D1 E0 1F 00 F9 E1 0B 00 F9 E2 23 00 F9 E8 23 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 E8 07 00 B9 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 07 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 27 00 F9 E9 27 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 1F 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 1F 40 B9 46 00 00 14 E8 1F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 0B 00 B9 03 00 00 14 08 00 80 52 E8 0B 00 B9 E8 0B 40 B9 E8 0F 00 B9 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 2B 00 F9 E9 2B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 27 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 27 40 B9 12 00 00 14 E2 63 01 91 E1 0B 40 F9 E0 1F 40 F9 ?? ?? ?? ?? E0 2B 00 B9 E8 2B 40 B9 E8 2F 00 B9 E2 23 40 F9 E1 63 01 91 E0 2F 40 B9 ?? ?? ?? ?? E0 33 00 B9 E8 33 40 B9 E8 37 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 37 40 B9 FF 83 0D 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_171_5_0 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@U_LDBL12@@@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QEAU_LDBL12@@@Z"
		size = 528
		refs = "0008 __security_push_cookie 0050 ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0074 _CrtDbgReportW 009c _errno 00c0 ??_C@_1EG@HNBONIDJ@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAp?$AAa?$AAr?$AAs?$AAe?$AA_?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi@ 00d0 _invalid_parameter 00e0 ??1?$c_string_character_source@D@__crt_strtox@@QEAA@XZ 0120 ??_C@_1CE@KDGPAKOD@?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01c8 ??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@D@0@AEAUfloating_point_string@0@@Z 01e4 ??$parse_floating_point_write_result@U_LDBL12@@@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAU_LDBL12@@@Z 0204 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 0D D1 E0 1F 00 F9 E1 0B 00 F9 E2 23 00 F9 E8 23 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 E8 07 00 B9 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 07 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 27 00 F9 E9 27 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 1F 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 1F 40 B9 46 00 00 14 E8 1F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 0B 00 B9 03 00 00 14 08 00 80 52 E8 0B 00 B9 E8 0B 40 B9 E8 0F 00 B9 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 2B 00 F9 E9 2B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 27 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 27 40 B9 12 00 00 14 E2 63 01 91 E1 0B 40 F9 E0 1F 40 F9 ?? ?? ?? ?? E0 2B 00 B9 E8 2B 40 B9 E8 2F 00 B9 E2 23 40 F9 E1 63 01 91 E0 2F 40 B9 ?? ?? ?? ?? E0 33 00 B9 E8 33 40 B9 E8 37 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 37 40 B9 FF 83 0D 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_24_0 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@_W@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@QEAM@Z"
		size = 528
		refs = "0008 __security_push_cookie 0050 ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0074 _CrtDbgReportW 009c _errno 00c0 ??_C@_1EG@HNBONIDJ@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAp?$AAa?$AAr?$AAs?$AAe?$AA_?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi@ 00d0 _invalid_parameter 00e0 ??1?$c_string_character_source@_W@__crt_strtox@@QEAA@XZ 0120 ??_C@_1CE@KDGPAKOD@?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01c8 ??$parse_floating_point_from_source@V?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@_W@0@AEAUfloating_point_string@0@@Z 01e4 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAM@Z 0204 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 0D D1 E0 1F 00 F9 E1 0B 00 F9 E2 23 00 F9 E8 23 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 E8 07 00 B9 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 07 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 27 00 F9 E9 27 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 1F 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 1F 40 B9 46 00 00 14 E8 1F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 0B 00 B9 03 00 00 14 08 00 80 52 E8 0B 00 B9 E8 0B 40 B9 E8 0F 00 B9 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 2B 00 F9 E9 2B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 27 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 27 40 B9 12 00 00 14 E2 63 01 91 E1 0B 40 F9 E0 1F 40 F9 ?? ?? ?? ?? E0 2B 00 B9 E8 2B 40 B9 E8 2F 00 B9 E2 23 40 F9 E1 63 01 91 E0 2F 40 B9 ?? ?? ?? ?? E0 33 00 B9 E8 33 40 B9 E8 37 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 37 40 B9 FF 83 0D 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_25_2 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@_W@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@QEAN@Z"
		size = 528
		refs = "0008 __security_push_cookie 0050 ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0074 _CrtDbgReportW 009c _errno 00c0 ??_C@_1EG@HNBONIDJ@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAp?$AAa?$AAr?$AAs?$AAe?$AA_?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi@ 00d0 _invalid_parameter 00e0 ??1?$c_string_character_source@_W@__crt_strtox@@QEAA@XZ 0120 ??_C@_1CE@KDGPAKOD@?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01c8 ??$parse_floating_point_from_source@V?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@_W@0@AEAUfloating_point_string@0@@Z 01e4 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAN@Z 0204 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 0D D1 E0 1F 00 F9 E1 0B 00 F9 E2 23 00 F9 E8 23 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 E8 07 00 B9 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 07 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 27 00 F9 E9 27 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 1F 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 1F 40 B9 46 00 00 14 E8 1F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 0B 00 B9 03 00 00 14 08 00 80 52 E8 0B 00 B9 E8 0B 40 B9 E8 0F 00 B9 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 2B 00 F9 E9 2B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 27 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 27 40 B9 12 00 00 14 E2 63 01 91 E1 0B 40 F9 E0 1F 40 F9 ?? ?? ?? ?? E0 2B 00 B9 E8 2B 40 B9 E8 2F 00 B9 E2 23 40 F9 E1 63 01 91 E0 2F 40 B9 ?? ?? ?? ?? E0 33 00 B9 E8 33 40 B9 E8 37 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 37 40 B9 FF 83 0D 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_45_4 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QEAM@Z"
		size = 528
		refs = "0008 __security_push_cookie 0050 ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0074 _CrtDbgReportW 009c _errno 00c0 ??_C@_1EG@HNBONIDJ@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAp?$AAa?$AAr?$AAs?$AAe?$AA_?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi@ 00d0 _invalid_parameter 00e0 ??1?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAA@XZ 0120 ??_C@_1CE@KDGPAKOD@?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01c8 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 01e4 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAM@Z 0204 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 0D D1 E0 1F 00 F9 E1 0B 00 F9 E2 23 00 F9 E8 23 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 E8 07 00 B9 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 07 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 27 00 F9 E9 27 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 1F 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 1F 40 B9 46 00 00 14 E8 1F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 0B 00 B9 03 00 00 14 08 00 80 52 E8 0B 00 B9 E8 0B 40 B9 E8 0F 00 B9 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 2B 00 F9 E9 2B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 27 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 27 40 B9 12 00 00 14 E2 63 01 91 E1 0B 40 F9 E0 1F 40 F9 ?? ?? ?? ?? E0 2B 00 B9 E8 2B 40 B9 E8 2F 00 B9 E2 23 40 F9 E1 63 01 91 E0 2F 40 B9 ?? ?? ?? ?? E0 33 00 B9 E8 33 40 B9 E8 37 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 37 40 B9 FF 83 0D 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_46_3 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QEAN@Z"
		size = 528
		refs = "0008 __security_push_cookie 0050 ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0074 _CrtDbgReportW 009c _errno 00c0 ??_C@_1EG@HNBONIDJ@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAp?$AAa?$AAr?$AAs?$AAe?$AA_?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi@ 00d0 _invalid_parameter 00e0 ??1?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAA@XZ 0120 ??_C@_1CE@KDGPAKOD@?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01c8 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 01e4 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAN@Z 0204 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 0D D1 E0 1F 00 F9 E1 0B 00 F9 E2 23 00 F9 E8 23 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 E8 07 00 B9 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 07 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 27 00 F9 E9 27 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 1F 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 1F 40 B9 46 00 00 14 E8 1F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 0B 00 B9 03 00 00 14 08 00 80 52 E8 0B 00 B9 E8 0B 40 B9 E8 0F 00 B9 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 2B 00 F9 E9 2B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 27 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 27 40 B9 12 00 00 14 E2 63 01 91 E1 0B 40 F9 E0 1F 40 F9 ?? ?? ?? ?? E0 2B 00 B9 E8 2B 40 B9 E8 2F 00 B9 E2 23 40 F9 E1 63 01 91 E0 2F 40 B9 ?? ?? ?? ?? E0 33 00 B9 E8 33 40 B9 E8 37 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 37 40 B9 FF 83 0D 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_47_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QEAM@Z"
		size = 528
		refs = "0008 __security_push_cookie 0050 ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0074 _CrtDbgReportW 009c _errno 00c0 ??_C@_1EG@HNBONIDJ@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAp?$AAa?$AAr?$AAs?$AAe?$AA_?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi@ 00d0 _invalid_parameter 00e0 ??1?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA@XZ 0120 ??_C@_1CE@KDGPAKOD@?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01c8 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 01e4 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAM@Z 0204 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 0D D1 E0 1F 00 F9 E1 0B 00 F9 E2 23 00 F9 E8 23 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 E8 07 00 B9 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 07 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 27 00 F9 E9 27 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 1F 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 1F 40 B9 46 00 00 14 E8 1F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 0B 00 B9 03 00 00 14 08 00 80 52 E8 0B 00 B9 E8 0B 40 B9 E8 0F 00 B9 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 2B 00 F9 E9 2B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 27 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 27 40 B9 12 00 00 14 E2 63 01 91 E1 0B 40 F9 E0 1F 40 F9 ?? ?? ?? ?? E0 2B 00 B9 E8 2B 40 B9 E8 2F 00 B9 E2 23 40 F9 E1 63 01 91 E0 2F 40 B9 ?? ?? ?? ?? E0 33 00 B9 E8 33 40 B9 E8 37 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 37 40 B9 FF 83 0D 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_48_3 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QEAN@Z"
		size = 528
		refs = "0008 __security_push_cookie 0050 ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0074 _CrtDbgReportW 009c _errno 00c0 ??_C@_1EG@HNBONIDJ@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAp?$AAa?$AAr?$AAs?$AAe?$AA_?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi@ 00d0 _invalid_parameter 00e0 ??1?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA@XZ 0120 ??_C@_1CE@KDGPAKOD@?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01c8 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 01e4 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAN@Z 0204 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 0D D1 E0 1F 00 F9 E1 0B 00 F9 E2 23 00 F9 E8 23 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 E8 07 00 B9 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 07 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 27 00 F9 E9 27 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 1F 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 1F 40 B9 46 00 00 14 E8 1F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 0B 00 B9 03 00 00 14 08 00 80 52 E8 0B 00 B9 E8 0B 40 B9 E8 0F 00 B9 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 2B 00 F9 E9 2B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 27 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 27 40 B9 12 00 00 14 E2 63 01 91 E1 0B 40 F9 E0 1F 40 F9 ?? ?? ?? ?? E0 2B 00 B9 E8 2B 40 B9 E8 2F 00 B9 E2 23 40 F9 E1 63 01 91 E0 2F 40 B9 ?? ?? ?? ?? E0 33 00 B9 E8 33 40 B9 E8 37 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 37 40 B9 FF 83 0D 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_49_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@QEAM@Z"
		size = 528
		refs = "0008 __security_push_cookie 0050 ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0074 _CrtDbgReportW 009c _errno 00c0 ??_C@_1EG@HNBONIDJ@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAp?$AAa?$AAr?$AAs?$AAe?$AA_?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi@ 00d0 _invalid_parameter 00e0 ??1?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAA@XZ 0120 ??_C@_1CE@KDGPAKOD@?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01c8 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 01e4 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAM@Z 0204 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 0D D1 E0 1F 00 F9 E1 0B 00 F9 E2 23 00 F9 E8 23 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 E8 07 00 B9 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 07 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 27 00 F9 E9 27 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 1F 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 1F 40 B9 46 00 00 14 E8 1F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 0B 00 B9 03 00 00 14 08 00 80 52 E8 0B 00 B9 E8 0B 40 B9 E8 0F 00 B9 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 2B 00 F9 E9 2B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 27 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 27 40 B9 12 00 00 14 E2 63 01 91 E1 0B 40 F9 E0 1F 40 F9 ?? ?? ?? ?? E0 2B 00 B9 E8 2B 40 B9 E8 2F 00 B9 E2 23 40 F9 E1 63 01 91 E0 2F 40 B9 ?? ?? ?? ?? E0 33 00 B9 E8 33 40 B9 E8 37 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 37 40 B9 FF 83 0D 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_50_2 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@QEAN@Z"
		size = 528
		refs = "0008 __security_push_cookie 0050 ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0074 _CrtDbgReportW 009c _errno 00c0 ??_C@_1EG@HNBONIDJ@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAp?$AAa?$AAr?$AAs?$AAe?$AA_?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi@ 00d0 _invalid_parameter 00e0 ??1?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAA@XZ 0120 ??_C@_1CE@KDGPAKOD@?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01c8 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 01e4 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAN@Z 0204 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 0D D1 E0 1F 00 F9 E1 0B 00 F9 E2 23 00 F9 E8 23 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 E8 07 00 B9 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 07 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 27 00 F9 E9 27 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 1F 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 1F 40 B9 46 00 00 14 E8 1F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 0B 00 B9 03 00 00 14 08 00 80 52 E8 0B 00 B9 E8 0B 40 B9 E8 0F 00 B9 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 2B 00 F9 E9 2B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 27 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 27 40 B9 12 00 00 14 E2 63 01 91 E1 0B 40 F9 E0 1F 40 F9 ?? ?? ?? ?? E0 2B 00 B9 E8 2B 40 B9 E8 2F 00 B9 E2 23 40 F9 E1 63 01 91 E0 2F 40 B9 ?? ?? ?? ?? E0 33 00 B9 E8 33 40 B9 E8 37 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 37 40 B9 FF 83 0D 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_51_2 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@QEAM@Z"
		size = 528
		refs = "0008 __security_push_cookie 0050 ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0074 _CrtDbgReportW 009c _errno 00c0 ??_C@_1EG@HNBONIDJ@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAp?$AAa?$AAr?$AAs?$AAe?$AA_?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi@ 00d0 _invalid_parameter 00e0 ??1?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA@XZ 0120 ??_C@_1CE@KDGPAKOD@?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01c8 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 01e4 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAM@Z 0204 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 0D D1 E0 1F 00 F9 E1 0B 00 F9 E2 23 00 F9 E8 23 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 E8 07 00 B9 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 07 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 27 00 F9 E9 27 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 1F 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 1F 40 B9 46 00 00 14 E8 1F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 0B 00 B9 03 00 00 14 08 00 80 52 E8 0B 00 B9 E8 0B 40 B9 E8 0F 00 B9 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 2B 00 F9 E9 2B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 27 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 27 40 B9 12 00 00 14 E2 63 01 91 E1 0B 40 F9 E0 1F 40 F9 ?? ?? ?? ?? E0 2B 00 B9 E8 2B 40 B9 E8 2F 00 B9 E2 23 40 F9 E1 63 01 91 E0 2F 40 B9 ?? ?? ?? ?? E0 33 00 B9 E8 33 40 B9 E8 37 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 37 40 B9 FF 83 0D 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_52_3 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@QEAN@Z"
		size = 528
		refs = "0008 __security_push_cookie 0050 ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0074 _CrtDbgReportW 009c _errno 00c0 ??_C@_1EG@HNBONIDJ@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAp?$AAa?$AAr?$AAs?$AAe?$AA_?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi@ 00d0 _invalid_parameter 00e0 ??1?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA@XZ 0120 ??_C@_1CE@KDGPAKOD@?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01c8 ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z 01e4 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAN@Z 0204 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 0D D1 E0 1F 00 F9 E1 0B 00 F9 E2 23 00 F9 E8 23 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 E8 07 00 B9 E8 07 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 07 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 27 00 F9 E9 27 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 1F 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 1F 40 B9 46 00 00 14 E8 1F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 0B 00 B9 03 00 00 14 08 00 80 52 E8 0B 00 B9 E8 0B 40 B9 E8 0F 00 B9 E8 0F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 B9 1F 01 00 71 A1 02 00 54 ?? ?? ?? ?? E0 2B 00 F9 E9 2B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 D4 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 28 00 80 52 E8 27 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 27 40 B9 12 00 00 14 E2 63 01 91 E1 0B 40 F9 E0 1F 40 F9 ?? ?? ?? ?? E0 2B 00 B9 E8 2B 40 B9 E8 2F 00 B9 E2 23 40 F9 E1 63 01 91 E0 2F 40 B9 ?? ?? ?? ?? E0 33 00 B9 E8 33 40 B9 E8 37 00 B9 E0 0B 40 F9 ?? ?? ?? ?? E0 37 40 B9 FF 83 0D 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_26_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@D@0@AEAUfloating_point_string@0@@Z"
		size = 2252
		refs = "0018 ?validate@?$c_string_character_source@D@__crt_strtox@@QEBA_NXZ 003c ?save_state@?$c_string_character_source@D@__crt_strtox@@QEBAPEBDXZ 0050 ?get@?$c_string_character_source@D@__crt_strtox@@QEAADXZ 0070 ??0<lambda_a4d13f8896d4166bcf1a62c02ca9256c>@@QEAA@AEAV?$c_string_character_source@D@__crt_strtox@@AEADAEAPEBD@Z 007c ?is_space@__crt_strtox@@YA_NDQEAU__crt_locale_pointers@@@Z 0144 ??$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$c_string_character_source@D@0@PEBD@Z 0180 ??$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$c_string_character_source@D@0@PEBD@Z 0220 ?unget@?$c_string_character_source@D@__crt_strtox@@QEAAXD@Z 02d0 ?parse_digit@__crt_strtox@@YAID@Z 048c ??R<lambda_a4d13f8896d4166bcf1a62c02ca9256c>@@QEBA_NXZ"
	strings:
		$1 = { FD 7B B0 A9 FD 03 00 91 E0 5F 00 F9 E1 13 00 F9 E2 2B 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 FB 00 39 E8 FB 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 E0 00 80 52 24 02 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 67 00 F9 E8 67 40 F9 E8 43 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 FF 00 39 E8 FF C0 39 E8 43 00 39 E3 03 02 91 E2 43 00 91 E1 13 40 F9 E0 A3 03 91 ?? ?? ?? ?? E1 5F 40 F9 E0 43 C0 39 ?? ?? ?? ?? E0 A7 00 39 E8 A7 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 AB 00 39 E8 AB C0 39 E8 43 00 39 F3 FF FF 17 E8 43 C0 39 08 01 00 11 1F B5 00 71 81 00 00 54 28 00 80 52 E8 77 00 B9 03 00 00 14 08 00 80 52 E8 77 00 B9 E8 2B 40 F9 09 21 0C 91 E8 77 40 B9 08 1D 00 53 28 01 00 39 E8 43 C0 39 08 01 00 11 1F B5 00 71 A0 00 00 54 E8 43 C0 39 08 01 00 11 1F AD 00 71 C1 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 AF 00 39 E8 AF C0 39 E8 43 00 39 E8 43 C0 39 08 01 00 11 1F 25 01 71 A0 00 00 54 E8 43 C0 39 08 01 00 11 1F A5 01 71 01 01 00 54 E2 43 40 F9 E1 13 40 F9 E0 43 00 91 ?? ?? ?? ?? E0 93 00 B9 E0 93 40 B9 DD 01 00 14 E8 43 C0 39 08 01 00 11 1F 39 01 71 A0 00 00 54 E8 43 C0 39 08 01 00 11 1F B9 01 71 01 01 00 54 E2 43 40 F9 E1 13 40 F9 E0 43 00 91 ?? ?? ?? ?? E0 97 00 B9 E0 97 40 B9 CE 01 00 14 08 00 80 52 E8 47 00 39 E8 43 C0 39 08 01 00 11 1F C1 00 71 01 04 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 6B 00 F9 E8 6B 40 F9 E8 6F 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 B3 00 39 E8 B3 C0 39 E8 4F 00 39 E8 4F C0 39 08 01 00 11 1F E1 01 71 A0 00 00 54 E8 4F C0 39 08 01 00 11 1F 61 01 71 61 01 00 54 28 00 80 52 E8 47 00 39 E0 13 40 F9 ?? ?? ?? ?? E0 B7 00 39 E8 B7 C0 39 E8 43 00 39 E8 6F 40 F9 E8 43 00 F9 04 00 00 14 E1 4F C0 39 E0 13 40 F9 ?? ?? ?? ?? E8 2B 40 F9 08 21 00 91 E8 47 00 F9 E8 2B 40 F9 08 21 0C 91 E8 63 00 F9 E8 2B 40 F9 08 21 00 91 E8 23 00 F9 08 00 80 52 E8 4F 00 B9 08 00 80 52 E8 4B 00 39 E8 43 C0 39 08 01 00 11 1F C1 00 71 21 01 00 54 28 00 80 52 E8 4B 00 39 E0 13 40 F9 ?? ?? ?? ?? E0 BB 00 39 E8 BB C0 39 E8 43 00 39 F5 FF FF 17 06 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 BF 00 39 E8 BF C0 39 E8 43 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 01 80 52 E8 7B 00 B9 03 00 00 14 28 01 80 52 E8 7B 00 B9 E8 7B 40 B9 E8 9F 00 B9 E0 43 C0 39 ?? ?? ?? ?? E0 9B 00 B9 E8 9B 40 B9 E8 5B 00 B9 E9 9F 40 B9 E8 5B 40 B9 1F 01 09 6B 49 00 00 54 12 00 00 14 28 00 80 52 E8 4B 00 39 E9 63 40 F9 E8 23 40 F9 1F 01 09 EB 00 01 00 54 E8 5B 40 B9 09 1D 00 53 E8 23 40 F9 09 01 00 39 E8 23 40 F9 08 05 00 91 E8 23 00 F9 E8 4F 40 B9 08 05 00 11 E8 4F 00 B9 D6 FF FF 17 E8 5F 40 F9 08 01 00 91 08 01 40 F9 08 E1 03 91 08 01 40 F9 08 01 00 91 08 01 40 F9 08 01 C0 39 E8 C3 00 39 E9 43 C0 39 29 01 00 11 E8 C3 C0 39 08 01 00 11 3F 01 08 6B 41 08 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 C7 00 39 E8 C7 C0 39 E8 43 00 39 E9 47 40 F9 E8 23 40 F9 1F 01 09 EB 01 02 00 54 E8 43 C0 39 08 01 00 11 1F C1 00 71 81 01 00 54 28 00 80 52 E8 4B 00 39 E8 4F 40 B9 08 05 00 51 E8 4F 00 B9 E0 13 40 F9 ?? ?? ?? ?? E0 CB 00 39 E8 CB C0 39 E8 43 00 39 F2 FF FF 17 06 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 CF 00 39 E8 CF C0 39 E8 43 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 01 80 52 E8 5F 00 B9 03 00 00 14 28 01 80 52 E8 5F 00 B9 E8 5F 40 B9 E8 A7 00 B9 E0 43 C0 39 ?? ?? ?? ?? E0 A3 00 B9 E8 A3 40 B9 E8 63 00 B9 E9 A7 40 B9 E8 63 40 B9 1F 01 09 6B 49 00 00 54 0F 00 00 14 28 00 80 52 E8 4B 00 39 E9 63 40 F9 E8 23 40 F9 1F 01 09 EB 00 01 00 54 E8 63 40 B9 09 1D 00 53 E8 23 40 F9 09 01 00 39 E8 23 40 F9 08 05 00 91 E8 23 00 F9 D9 FF FF 17 E8 4B 40 39 08 01 00 11 1F 01 00 71 61 02 00 54 E0 A3 03 91 ?? ?? ?? ?? E0 D3 00 39 E8 D3 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 E0 00 80 52 07 01 00 14 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 40 00 80 52 01 01 00 14 03 00 00 14 E0 00 80 52 FE 00 00 14 E1 43 C0 39 E0 13 40 F9 ?? ?? ?? ?? E0 13 40 F9 ?? ?? ?? ?? E0 73 00 F9 E8 73 40 F9 E8 43 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 D7 00 39 E8 D7 C0 39 E8 43 00 39 08 00 80 52 E8 53 00 39 E8 43 C0 39 08 01 00 11 E8 4B 00 B9 E8 4B 40 B9 1F 95 01 71 6C 01 00 54 E8 4B 40 B9 1F 95 01 71 80 01 00 54 E8 4B 40 B9 1F 15 01 71 20 01 00 54 E8 4B 40 B9 1F 41 01 71 60 02 00 54 14 00 00 14 E8 4B 40 B9 1F C1 01 71 E0 01 00 54 10 00 00 14 E8 47 40 39 08 01 00 11 1F 01 00 71 81 00 00 54 28 00 80 52 E8 67 00 B9 03 00 00 14 08 00 80 52 E8 67 00 B9 E8 67 40 B9 08 1D 00 53 E8 53 00 39 03 00 00 14 E8 47 40 39 E8 53 00 39 08 00 80 52 E8 1B 00 B9 E8 53 40 39 08 01 00 11 1F 01 00 71 20 0E 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 DB 00 39 E8 DB C0 39 E8 43 00 39 E8 43 C0 39 08 01 00 11 1F B5 00 71 81 00 00 54 28 00 80 52 E8 A3 00 39 03 00 00 14 08 00 80 52 E8 A3 00 39 E8 A3 40 39 E8 EF 00 39 E8 43 C0 39 08 01 00 11 1F AD 00 71 A0 00 00 54 E8 43 C0 39 08 01 00 11 1F B5 00 71 C1 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 DF 00 39 E8 DF C0 39 E8 43 00 39 08 00 80 52 E8 57 00 39 E8 43 C0 39 08 01 00 11 1F C1 00 71 21 01 00 54 28 00 80 52 E8 57 00 39 E0 13 40 F9 ?? ?? ?? ?? E0 E3 00 39 E8 E3 C0 39 E8 43 00 39 F5 FF FF 17 06 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 E7 00 39 E8 E7 C0 39 E8 43 00 39 E0 43 C0 39 ?? ?? ?? ?? E0 B3 00 B9 E8 B3 40 B9 E8 6B 00 B9 E8 6B 40 B9 1F 29 00 71 43 00 00 54 11 00 00 14 28 00 80 52 E8 57 00 39 E9 1B 40 B9 48 01 80 52 29 7D 08 1B E8 6B 40 B9 28 01 08 0B E8 1B 00 B9 09 8A 82 52 E8 1B 40 B9 1F 01 09 6B 8D 00 00 54 28 8A 82 52 E8 1B 00 B9 02 00 00 14 E3 FF FF 17 E0 43 C0 39 ?? ?? ?? ?? E0 AB 00 B9 E8 AB 40 B9 1F 29 00 71 E2 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 EB 00 39 E8 EB C0 39 E8 43 00 39 F5 FF FF 17 E8 EF 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 1B 40 B9 E8 03 08 4B E8 1B 00 B9 E8 57 40 39 08 01 00 11 1F 01 00 71 01 02 00 54 E0 A3 03 91 ?? ?? ?? ?? E0 F3 00 39 E8 F3 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 F7 00 39 E8 F7 C0 39 E8 43 00 39 03 00 00 14 E0 00 80 52 56 00 00 14 E1 43 C0 39 E0 13 40 F9 ?? ?? ?? ?? E9 47 40 F9 E8 23 40 F9 1F 01 09 EB 60 01 00 54 E8 23 40 F9 08 05 00 D1 08 01 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E8 23 40 F9 08 05 00 D1 E8 23 00 F9 F3 FF FF 17 E9 47 40 F9 E8 23 40 F9 1F 01 09 EB 61 00 00 54 40 00 80 52 3F 00 00 14 09 8A 82 52 E8 1B 40 B9 1F 01 09 6B 6D 00 00 54 20 01 80 52 39 00 00 14 E9 89 82 12 E8 1B 40 B9 1F 01 09 6B 6A 00 00 54 00 01 80 52 33 00 00 14 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 6F 00 B9 03 00 00 14 28 00 80 52 E8 6F 00 B9 E8 6F 40 B9 E8 AF 00 B9 E9 4F 40 B9 E8 AF 40 B9 29 7D 08 1B E8 1B 40 B9 08 01 09 0B E8 1B 00 B9 09 8A 82 52 E8 1B 40 B9 1F 01 09 6B 6D 00 00 54 20 01 80 52 1C 00 00 14 E9 89 82 12 E8 1B 40 B9 1F 01 09 6B 6A 00 00 54 00 01 80 52 16 00 00 14 E8 2B 40 F9 09 01 00 91 E8 1B 40 B9 28 01 00 B9 E9 23 40 F9 E8 47 40 F9 28 01 08 CB 09 01 00 11 E8 2B 40 F9 08 11 00 91 09 01 00 B9 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 73 00 B9 03 00 00 14 08 00 80 52 E8 73 00 B9 E0 73 40 B9 FD 7B D0 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_53_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z"
		size = 2252
		refs = "0018 ?validate@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEBA_NXZ 003c ?save_state@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEBA_KXZ 0050 ?get@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAADXZ 0070 ??0<lambda_987679f592fad43c4bd3fe4c5bcc8c0e>@@QEAA@AEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@AEADAEA_K@Z 007c ?is_space@__crt_strtox@@YA_NDQEAU__crt_locale_pointers@@@Z 0144 ??$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@_K@Z 0180 ??$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@_K@Z 0220 ?unget@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAAXD@Z 02d0 ?parse_digit@__crt_strtox@@YAID@Z 048c ??R<lambda_987679f592fad43c4bd3fe4c5bcc8c0e>@@QEBA_NXZ"
	strings:
		$1 = { FD 7B B0 A9 FD 03 00 91 E0 5F 00 F9 E1 13 00 F9 E2 2B 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 FB 00 39 E8 FB 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 E0 00 80 52 24 02 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 67 00 F9 E8 67 40 F9 E8 43 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 FF 00 39 E8 FF C0 39 E8 43 00 39 E3 03 02 91 E2 43 00 91 E1 13 40 F9 E0 A3 03 91 ?? ?? ?? ?? E1 5F 40 F9 E0 43 C0 39 ?? ?? ?? ?? E0 A7 00 39 E8 A7 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 AB 00 39 E8 AB C0 39 E8 43 00 39 F3 FF FF 17 E8 43 C0 39 08 01 00 11 1F B5 00 71 81 00 00 54 28 00 80 52 E8 77 00 B9 03 00 00 14 08 00 80 52 E8 77 00 B9 E8 2B 40 F9 09 21 0C 91 E8 77 40 B9 08 1D 00 53 28 01 00 39 E8 43 C0 39 08 01 00 11 1F B5 00 71 A0 00 00 54 E8 43 C0 39 08 01 00 11 1F AD 00 71 C1 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 AF 00 39 E8 AF C0 39 E8 43 00 39 E8 43 C0 39 08 01 00 11 1F 25 01 71 A0 00 00 54 E8 43 C0 39 08 01 00 11 1F A5 01 71 01 01 00 54 E2 43 40 F9 E1 13 40 F9 E0 43 00 91 ?? ?? ?? ?? E0 93 00 B9 E0 93 40 B9 DD 01 00 14 E8 43 C0 39 08 01 00 11 1F 39 01 71 A0 00 00 54 E8 43 C0 39 08 01 00 11 1F B9 01 71 01 01 00 54 E2 43 40 F9 E1 13 40 F9 E0 43 00 91 ?? ?? ?? ?? E0 97 00 B9 E0 97 40 B9 CE 01 00 14 08 00 80 52 E8 47 00 39 E8 43 C0 39 08 01 00 11 1F C1 00 71 01 04 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 6B 00 F9 E8 6B 40 F9 E8 6F 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 B3 00 39 E8 B3 C0 39 E8 4F 00 39 E8 4F C0 39 08 01 00 11 1F E1 01 71 A0 00 00 54 E8 4F C0 39 08 01 00 11 1F 61 01 71 61 01 00 54 28 00 80 52 E8 47 00 39 E0 13 40 F9 ?? ?? ?? ?? E0 B7 00 39 E8 B7 C0 39 E8 43 00 39 E8 6F 40 F9 E8 43 00 F9 04 00 00 14 E1 4F C0 39 E0 13 40 F9 ?? ?? ?? ?? E8 2B 40 F9 08 21 00 91 E8 47 00 F9 E8 2B 40 F9 08 21 0C 91 E8 63 00 F9 E8 2B 40 F9 08 21 00 91 E8 23 00 F9 08 00 80 52 E8 4F 00 B9 08 00 80 52 E8 4B 00 39 E8 43 C0 39 08 01 00 11 1F C1 00 71 21 01 00 54 28 00 80 52 E8 4B 00 39 E0 13 40 F9 ?? ?? ?? ?? E0 BB 00 39 E8 BB C0 39 E8 43 00 39 F5 FF FF 17 06 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 BF 00 39 E8 BF C0 39 E8 43 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 01 80 52 E8 7B 00 B9 03 00 00 14 28 01 80 52 E8 7B 00 B9 E8 7B 40 B9 E8 9F 00 B9 E0 43 C0 39 ?? ?? ?? ?? E0 9B 00 B9 E8 9B 40 B9 E8 5B 00 B9 E9 9F 40 B9 E8 5B 40 B9 1F 01 09 6B 49 00 00 54 12 00 00 14 28 00 80 52 E8 4B 00 39 E9 63 40 F9 E8 23 40 F9 1F 01 09 EB 00 01 00 54 E8 5B 40 B9 09 1D 00 53 E8 23 40 F9 09 01 00 39 E8 23 40 F9 08 05 00 91 E8 23 00 F9 E8 4F 40 B9 08 05 00 11 E8 4F 00 B9 D6 FF FF 17 E8 5F 40 F9 08 01 00 91 08 01 40 F9 08 E1 03 91 08 01 40 F9 08 01 00 91 08 01 40 F9 08 01 C0 39 E8 C3 00 39 E9 43 C0 39 29 01 00 11 E8 C3 C0 39 08 01 00 11 3F 01 08 6B 41 08 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 C7 00 39 E8 C7 C0 39 E8 43 00 39 E9 47 40 F9 E8 23 40 F9 1F 01 09 EB 01 02 00 54 E8 43 C0 39 08 01 00 11 1F C1 00 71 81 01 00 54 28 00 80 52 E8 4B 00 39 E8 4F 40 B9 08 05 00 51 E8 4F 00 B9 E0 13 40 F9 ?? ?? ?? ?? E0 CB 00 39 E8 CB C0 39 E8 43 00 39 F2 FF FF 17 06 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 CF 00 39 E8 CF C0 39 E8 43 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 01 80 52 E8 5F 00 B9 03 00 00 14 28 01 80 52 E8 5F 00 B9 E8 5F 40 B9 E8 A7 00 B9 E0 43 C0 39 ?? ?? ?? ?? E0 A3 00 B9 E8 A3 40 B9 E8 63 00 B9 E9 A7 40 B9 E8 63 40 B9 1F 01 09 6B 49 00 00 54 0F 00 00 14 28 00 80 52 E8 4B 00 39 E9 63 40 F9 E8 23 40 F9 1F 01 09 EB 00 01 00 54 E8 63 40 B9 09 1D 00 53 E8 23 40 F9 09 01 00 39 E8 23 40 F9 08 05 00 91 E8 23 00 F9 D9 FF FF 17 E8 4B 40 39 08 01 00 11 1F 01 00 71 61 02 00 54 E0 A3 03 91 ?? ?? ?? ?? E0 D3 00 39 E8 D3 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 E0 00 80 52 07 01 00 14 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 40 00 80 52 01 01 00 14 03 00 00 14 E0 00 80 52 FE 00 00 14 E1 43 C0 39 E0 13 40 F9 ?? ?? ?? ?? E0 13 40 F9 ?? ?? ?? ?? E0 73 00 F9 E8 73 40 F9 E8 43 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 D7 00 39 E8 D7 C0 39 E8 43 00 39 08 00 80 52 E8 53 00 39 E8 43 C0 39 08 01 00 11 E8 4B 00 B9 E8 4B 40 B9 1F 95 01 71 6C 01 00 54 E8 4B 40 B9 1F 95 01 71 80 01 00 54 E8 4B 40 B9 1F 15 01 71 20 01 00 54 E8 4B 40 B9 1F 41 01 71 60 02 00 54 14 00 00 14 E8 4B 40 B9 1F C1 01 71 E0 01 00 54 10 00 00 14 E8 47 40 39 08 01 00 11 1F 01 00 71 81 00 00 54 28 00 80 52 E8 67 00 B9 03 00 00 14 08 00 80 52 E8 67 00 B9 E8 67 40 B9 08 1D 00 53 E8 53 00 39 03 00 00 14 E8 47 40 39 E8 53 00 39 08 00 80 52 E8 1B 00 B9 E8 53 40 39 08 01 00 11 1F 01 00 71 20 0E 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 DB 00 39 E8 DB C0 39 E8 43 00 39 E8 43 C0 39 08 01 00 11 1F B5 00 71 81 00 00 54 28 00 80 52 E8 A3 00 39 03 00 00 14 08 00 80 52 E8 A3 00 39 E8 A3 40 39 E8 EF 00 39 E8 43 C0 39 08 01 00 11 1F AD 00 71 A0 00 00 54 E8 43 C0 39 08 01 00 11 1F B5 00 71 C1 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 DF 00 39 E8 DF C0 39 E8 43 00 39 08 00 80 52 E8 57 00 39 E8 43 C0 39 08 01 00 11 1F C1 00 71 21 01 00 54 28 00 80 52 E8 57 00 39 E0 13 40 F9 ?? ?? ?? ?? E0 E3 00 39 E8 E3 C0 39 E8 43 00 39 F5 FF FF 17 06 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 E7 00 39 E8 E7 C0 39 E8 43 00 39 E0 43 C0 39 ?? ?? ?? ?? E0 B3 00 B9 E8 B3 40 B9 E8 6B 00 B9 E8 6B 40 B9 1F 29 00 71 43 00 00 54 11 00 00 14 28 00 80 52 E8 57 00 39 E9 1B 40 B9 48 01 80 52 29 7D 08 1B E8 6B 40 B9 28 01 08 0B E8 1B 00 B9 09 8A 82 52 E8 1B 40 B9 1F 01 09 6B 8D 00 00 54 28 8A 82 52 E8 1B 00 B9 02 00 00 14 E3 FF FF 17 E0 43 C0 39 ?? ?? ?? ?? E0 AB 00 B9 E8 AB 40 B9 1F 29 00 71 E2 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 EB 00 39 E8 EB C0 39 E8 43 00 39 F5 FF FF 17 E8 EF 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 1B 40 B9 E8 03 08 4B E8 1B 00 B9 E8 57 40 39 08 01 00 11 1F 01 00 71 01 02 00 54 E0 A3 03 91 ?? ?? ?? ?? E0 F3 00 39 E8 F3 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 F7 00 39 E8 F7 C0 39 E8 43 00 39 03 00 00 14 E0 00 80 52 56 00 00 14 E1 43 C0 39 E0 13 40 F9 ?? ?? ?? ?? E9 47 40 F9 E8 23 40 F9 1F 01 09 EB 60 01 00 54 E8 23 40 F9 08 05 00 D1 08 01 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E8 23 40 F9 08 05 00 D1 E8 23 00 F9 F3 FF FF 17 E9 47 40 F9 E8 23 40 F9 1F 01 09 EB 61 00 00 54 40 00 80 52 3F 00 00 14 09 8A 82 52 E8 1B 40 B9 1F 01 09 6B 6D 00 00 54 20 01 80 52 39 00 00 14 E9 89 82 12 E8 1B 40 B9 1F 01 09 6B 6A 00 00 54 00 01 80 52 33 00 00 14 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 6F 00 B9 03 00 00 14 28 00 80 52 E8 6F 00 B9 E8 6F 40 B9 E8 AF 00 B9 E9 4F 40 B9 E8 AF 40 B9 29 7D 08 1B E8 1B 40 B9 08 01 09 0B E8 1B 00 B9 09 8A 82 52 E8 1B 40 B9 1F 01 09 6B 6D 00 00 54 20 01 80 52 1C 00 00 14 E9 89 82 12 E8 1B 40 B9 1F 01 09 6B 6A 00 00 54 00 01 80 52 16 00 00 14 E8 2B 40 F9 09 01 00 91 E8 1B 40 B9 28 01 00 B9 E9 23 40 F9 E8 47 40 F9 28 01 08 CB 09 01 00 11 E8 2B 40 F9 08 11 00 91 09 01 00 B9 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 73 00 B9 03 00 00 14 08 00 80 52 E8 73 00 B9 E0 73 40 B9 FD 7B D0 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_55_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z"
		size = 2252
		refs = "0018 ?validate@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEBA_NXZ 003c ?save_state@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEBA_KXZ 0050 ?get@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAADXZ 0070 ??0<lambda_1db4d925c2db10274e92824f631ccf5d>@@QEAA@AEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@AEADAEA_K@Z 007c ?is_space@__crt_strtox@@YA_NDQEAU__crt_locale_pointers@@@Z 0144 ??$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@_K@Z 0180 ??$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@_K@Z 0220 ?unget@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAAXD@Z 02d0 ?parse_digit@__crt_strtox@@YAID@Z 048c ??R<lambda_1db4d925c2db10274e92824f631ccf5d>@@QEBA_NXZ"
	strings:
		$1 = { FD 7B B0 A9 FD 03 00 91 E0 5F 00 F9 E1 13 00 F9 E2 2B 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 FB 00 39 E8 FB 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 E0 00 80 52 24 02 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 67 00 F9 E8 67 40 F9 E8 43 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 FF 00 39 E8 FF C0 39 E8 43 00 39 E3 03 02 91 E2 43 00 91 E1 13 40 F9 E0 A3 03 91 ?? ?? ?? ?? E1 5F 40 F9 E0 43 C0 39 ?? ?? ?? ?? E0 A7 00 39 E8 A7 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 AB 00 39 E8 AB C0 39 E8 43 00 39 F3 FF FF 17 E8 43 C0 39 08 01 00 11 1F B5 00 71 81 00 00 54 28 00 80 52 E8 77 00 B9 03 00 00 14 08 00 80 52 E8 77 00 B9 E8 2B 40 F9 09 21 0C 91 E8 77 40 B9 08 1D 00 53 28 01 00 39 E8 43 C0 39 08 01 00 11 1F B5 00 71 A0 00 00 54 E8 43 C0 39 08 01 00 11 1F AD 00 71 C1 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 AF 00 39 E8 AF C0 39 E8 43 00 39 E8 43 C0 39 08 01 00 11 1F 25 01 71 A0 00 00 54 E8 43 C0 39 08 01 00 11 1F A5 01 71 01 01 00 54 E2 43 40 F9 E1 13 40 F9 E0 43 00 91 ?? ?? ?? ?? E0 93 00 B9 E0 93 40 B9 DD 01 00 14 E8 43 C0 39 08 01 00 11 1F 39 01 71 A0 00 00 54 E8 43 C0 39 08 01 00 11 1F B9 01 71 01 01 00 54 E2 43 40 F9 E1 13 40 F9 E0 43 00 91 ?? ?? ?? ?? E0 97 00 B9 E0 97 40 B9 CE 01 00 14 08 00 80 52 E8 47 00 39 E8 43 C0 39 08 01 00 11 1F C1 00 71 01 04 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 6B 00 F9 E8 6B 40 F9 E8 6F 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 B3 00 39 E8 B3 C0 39 E8 4F 00 39 E8 4F C0 39 08 01 00 11 1F E1 01 71 A0 00 00 54 E8 4F C0 39 08 01 00 11 1F 61 01 71 61 01 00 54 28 00 80 52 E8 47 00 39 E0 13 40 F9 ?? ?? ?? ?? E0 B7 00 39 E8 B7 C0 39 E8 43 00 39 E8 6F 40 F9 E8 43 00 F9 04 00 00 14 E1 4F C0 39 E0 13 40 F9 ?? ?? ?? ?? E8 2B 40 F9 08 21 00 91 E8 47 00 F9 E8 2B 40 F9 08 21 0C 91 E8 63 00 F9 E8 2B 40 F9 08 21 00 91 E8 23 00 F9 08 00 80 52 E8 4F 00 B9 08 00 80 52 E8 4B 00 39 E8 43 C0 39 08 01 00 11 1F C1 00 71 21 01 00 54 28 00 80 52 E8 4B 00 39 E0 13 40 F9 ?? ?? ?? ?? E0 BB 00 39 E8 BB C0 39 E8 43 00 39 F5 FF FF 17 06 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 BF 00 39 E8 BF C0 39 E8 43 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 01 80 52 E8 7B 00 B9 03 00 00 14 28 01 80 52 E8 7B 00 B9 E8 7B 40 B9 E8 9F 00 B9 E0 43 C0 39 ?? ?? ?? ?? E0 9B 00 B9 E8 9B 40 B9 E8 5B 00 B9 E9 9F 40 B9 E8 5B 40 B9 1F 01 09 6B 49 00 00 54 12 00 00 14 28 00 80 52 E8 4B 00 39 E9 63 40 F9 E8 23 40 F9 1F 01 09 EB 00 01 00 54 E8 5B 40 B9 09 1D 00 53 E8 23 40 F9 09 01 00 39 E8 23 40 F9 08 05 00 91 E8 23 00 F9 E8 4F 40 B9 08 05 00 11 E8 4F 00 B9 D6 FF FF 17 E8 5F 40 F9 08 01 00 91 08 01 40 F9 08 E1 03 91 08 01 40 F9 08 01 00 91 08 01 40 F9 08 01 C0 39 E8 C3 00 39 E9 43 C0 39 29 01 00 11 E8 C3 C0 39 08 01 00 11 3F 01 08 6B 41 08 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 C7 00 39 E8 C7 C0 39 E8 43 00 39 E9 47 40 F9 E8 23 40 F9 1F 01 09 EB 01 02 00 54 E8 43 C0 39 08 01 00 11 1F C1 00 71 81 01 00 54 28 00 80 52 E8 4B 00 39 E8 4F 40 B9 08 05 00 51 E8 4F 00 B9 E0 13 40 F9 ?? ?? ?? ?? E0 CB 00 39 E8 CB C0 39 E8 43 00 39 F2 FF FF 17 06 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 CF 00 39 E8 CF C0 39 E8 43 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 01 80 52 E8 5F 00 B9 03 00 00 14 28 01 80 52 E8 5F 00 B9 E8 5F 40 B9 E8 A7 00 B9 E0 43 C0 39 ?? ?? ?? ?? E0 A3 00 B9 E8 A3 40 B9 E8 63 00 B9 E9 A7 40 B9 E8 63 40 B9 1F 01 09 6B 49 00 00 54 0F 00 00 14 28 00 80 52 E8 4B 00 39 E9 63 40 F9 E8 23 40 F9 1F 01 09 EB 00 01 00 54 E8 63 40 B9 09 1D 00 53 E8 23 40 F9 09 01 00 39 E8 23 40 F9 08 05 00 91 E8 23 00 F9 D9 FF FF 17 E8 4B 40 39 08 01 00 11 1F 01 00 71 61 02 00 54 E0 A3 03 91 ?? ?? ?? ?? E0 D3 00 39 E8 D3 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 E0 00 80 52 07 01 00 14 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 40 00 80 52 01 01 00 14 03 00 00 14 E0 00 80 52 FE 00 00 14 E1 43 C0 39 E0 13 40 F9 ?? ?? ?? ?? E0 13 40 F9 ?? ?? ?? ?? E0 73 00 F9 E8 73 40 F9 E8 43 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 D7 00 39 E8 D7 C0 39 E8 43 00 39 08 00 80 52 E8 53 00 39 E8 43 C0 39 08 01 00 11 E8 4B 00 B9 E8 4B 40 B9 1F 95 01 71 6C 01 00 54 E8 4B 40 B9 1F 95 01 71 80 01 00 54 E8 4B 40 B9 1F 15 01 71 20 01 00 54 E8 4B 40 B9 1F 41 01 71 60 02 00 54 14 00 00 14 E8 4B 40 B9 1F C1 01 71 E0 01 00 54 10 00 00 14 E8 47 40 39 08 01 00 11 1F 01 00 71 81 00 00 54 28 00 80 52 E8 67 00 B9 03 00 00 14 08 00 80 52 E8 67 00 B9 E8 67 40 B9 08 1D 00 53 E8 53 00 39 03 00 00 14 E8 47 40 39 E8 53 00 39 08 00 80 52 E8 1B 00 B9 E8 53 40 39 08 01 00 11 1F 01 00 71 20 0E 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 DB 00 39 E8 DB C0 39 E8 43 00 39 E8 43 C0 39 08 01 00 11 1F B5 00 71 81 00 00 54 28 00 80 52 E8 A3 00 39 03 00 00 14 08 00 80 52 E8 A3 00 39 E8 A3 40 39 E8 EF 00 39 E8 43 C0 39 08 01 00 11 1F AD 00 71 A0 00 00 54 E8 43 C0 39 08 01 00 11 1F B5 00 71 C1 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 DF 00 39 E8 DF C0 39 E8 43 00 39 08 00 80 52 E8 57 00 39 E8 43 C0 39 08 01 00 11 1F C1 00 71 21 01 00 54 28 00 80 52 E8 57 00 39 E0 13 40 F9 ?? ?? ?? ?? E0 E3 00 39 E8 E3 C0 39 E8 43 00 39 F5 FF FF 17 06 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 E7 00 39 E8 E7 C0 39 E8 43 00 39 E0 43 C0 39 ?? ?? ?? ?? E0 B3 00 B9 E8 B3 40 B9 E8 6B 00 B9 E8 6B 40 B9 1F 29 00 71 43 00 00 54 11 00 00 14 28 00 80 52 E8 57 00 39 E9 1B 40 B9 48 01 80 52 29 7D 08 1B E8 6B 40 B9 28 01 08 0B E8 1B 00 B9 09 8A 82 52 E8 1B 40 B9 1F 01 09 6B 8D 00 00 54 28 8A 82 52 E8 1B 00 B9 02 00 00 14 E3 FF FF 17 E0 43 C0 39 ?? ?? ?? ?? E0 AB 00 B9 E8 AB 40 B9 1F 29 00 71 E2 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 EB 00 39 E8 EB C0 39 E8 43 00 39 F5 FF FF 17 E8 EF 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 1B 40 B9 E8 03 08 4B E8 1B 00 B9 E8 57 40 39 08 01 00 11 1F 01 00 71 01 02 00 54 E0 A3 03 91 ?? ?? ?? ?? E0 F3 00 39 E8 F3 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 F7 00 39 E8 F7 C0 39 E8 43 00 39 03 00 00 14 E0 00 80 52 56 00 00 14 E1 43 C0 39 E0 13 40 F9 ?? ?? ?? ?? E9 47 40 F9 E8 23 40 F9 1F 01 09 EB 60 01 00 54 E8 23 40 F9 08 05 00 D1 08 01 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E8 23 40 F9 08 05 00 D1 E8 23 00 F9 F3 FF FF 17 E9 47 40 F9 E8 23 40 F9 1F 01 09 EB 61 00 00 54 40 00 80 52 3F 00 00 14 09 8A 82 52 E8 1B 40 B9 1F 01 09 6B 6D 00 00 54 20 01 80 52 39 00 00 14 E9 89 82 12 E8 1B 40 B9 1F 01 09 6B 6A 00 00 54 00 01 80 52 33 00 00 14 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 6F 00 B9 03 00 00 14 28 00 80 52 E8 6F 00 B9 E8 6F 40 B9 E8 AF 00 B9 E9 4F 40 B9 E8 AF 40 B9 29 7D 08 1B E8 1B 40 B9 08 01 09 0B E8 1B 00 B9 09 8A 82 52 E8 1B 40 B9 1F 01 09 6B 6D 00 00 54 20 01 80 52 1C 00 00 14 E9 89 82 12 E8 1B 40 B9 1F 01 09 6B 6A 00 00 54 00 01 80 52 16 00 00 14 E8 2B 40 F9 09 01 00 91 E8 1B 40 B9 28 01 00 B9 E9 23 40 F9 E8 47 40 F9 28 01 08 CB 09 01 00 11 E8 2B 40 F9 08 11 00 91 09 01 00 B9 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 73 00 B9 03 00 00 14 08 00 80 52 E8 73 00 B9 E0 73 40 B9 FD 7B D0 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_27_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@_W@0@AEAUfloating_point_string@0@@Z"
		size = 2252
		refs = "0018 ?validate@?$c_string_character_source@_W@__crt_strtox@@QEBA_NXZ 003c ?save_state@?$c_string_character_source@_W@__crt_strtox@@QEBAPEB_WXZ 0050 ?get@?$c_string_character_source@_W@__crt_strtox@@QEAA_WXZ 0070 ??0<lambda_74a2d8e426d717992967bf549d0b1d46>@@QEAA@AEAV?$c_string_character_source@_W@__crt_strtox@@AEA_WAEAPEB_W@Z 007c ?is_space@__crt_strtox@@YA_N_WPEAU__crt_locale_pointers@@@Z 0144 ??$parse_floating_point_possible_infinity@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$c_string_character_source@_W@0@PEB_W@Z 0180 ??$parse_floating_point_possible_nan@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$c_string_character_source@_W@0@PEB_W@Z 0220 ?unget@?$c_string_character_source@_W@__crt_strtox@@QEAAX_W@Z 02d0 ?parse_digit@__crt_strtox@@YAI_W@Z 048c ??R<lambda_74a2d8e426d717992967bf549d0b1d46>@@QEBA_NXZ"
	strings:
		$1 = { FD 7B AE A9 FD 03 00 91 E0 6F 00 F9 E1 13 00 F9 E2 3B 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 A7 00 39 E8 A7 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 E0 00 80 52 24 02 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 77 00 F9 E8 77 40 F9 E8 53 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 CB 00 79 E8 CB 40 79 E8 23 00 79 E3 83 02 91 E2 43 00 91 E1 13 40 F9 E0 23 04 91 ?? ?? ?? ?? E1 6F 40 F9 E0 23 40 79 ?? ?? ?? ?? E0 AB 00 39 E8 AB 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 CF 00 79 E8 CF 40 79 E8 23 00 79 F3 FF FF 17 E8 23 40 79 08 01 00 11 1F B5 00 71 81 00 00 54 28 00 80 52 E8 97 00 B9 03 00 00 14 08 00 80 52 E8 97 00 B9 E8 3B 40 F9 09 21 0C 91 E8 97 40 B9 08 1D 00 53 28 01 00 39 E8 23 40 79 08 01 00 11 1F B5 00 71 A0 00 00 54 E8 23 40 79 08 01 00 11 1F AD 00 71 C1 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 D3 00 79 E8 D3 40 79 E8 23 00 79 E8 23 40 79 08 01 00 11 1F 25 01 71 A0 00 00 54 E8 23 40 79 08 01 00 11 1F A5 01 71 01 01 00 54 E2 53 40 F9 E1 13 40 F9 E0 43 00 91 ?? ?? ?? ?? E0 B3 00 B9 E0 B3 40 B9 DD 01 00 14 E8 23 40 79 08 01 00 11 1F 39 01 71 A0 00 00 54 E8 23 40 79 08 01 00 11 1F B9 01 71 01 01 00 54 E2 53 40 F9 E1 13 40 F9 E0 43 00 91 ?? ?? ?? ?? E0 B7 00 B9 E0 B7 40 B9 CE 01 00 14 08 00 80 52 E8 4B 00 39 E8 23 40 79 08 01 00 11 1F C1 00 71 01 04 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 7B 00 F9 E8 7B 40 F9 E8 7F 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 93 00 79 E8 93 40 79 E8 63 00 79 E8 63 40 79 08 01 00 11 1F E1 01 71 A0 00 00 54 E8 63 40 79 08 01 00 11 1F 61 01 71 61 01 00 54 28 00 80 52 E8 4B 00 39 E0 13 40 F9 ?? ?? ?? ?? E0 97 00 79 E8 97 40 79 E8 23 00 79 E8 7F 40 F9 E8 53 00 F9 04 00 00 14 E1 63 40 79 E0 13 40 F9 ?? ?? ?? ?? E8 3B 40 F9 08 21 00 91 E8 57 00 F9 E8 3B 40 F9 08 21 0C 91 E8 73 00 F9 E8 3B 40 F9 08 21 00 91 E8 1F 00 F9 08 00 80 52 E8 47 00 B9 08 00 80 52 E8 4F 00 39 E8 23 40 79 08 01 00 11 1F C1 00 71 21 01 00 54 28 00 80 52 E8 4F 00 39 E0 13 40 F9 ?? ?? ?? ?? E0 9B 00 79 E8 9B 40 79 E8 23 00 79 F5 FF FF 17 06 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 9F 00 79 E8 9F 40 79 E8 23 00 79 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 01 80 52 E8 9B 00 B9 03 00 00 14 28 01 80 52 E8 9B 00 B9 E8 9B 40 B9 E8 BF 00 B9 E0 23 40 79 ?? ?? ?? ?? E0 BB 00 B9 E8 BB 40 B9 E8 7B 00 B9 E9 BF 40 B9 E8 7B 40 B9 1F 01 09 6B 49 00 00 54 12 00 00 14 28 00 80 52 E8 4F 00 39 E9 73 40 F9 E8 1F 40 F9 1F 01 09 EB 00 01 00 54 E8 7B 40 B9 09 1D 00 53 E8 1F 40 F9 09 01 00 39 E8 1F 40 F9 08 05 00 91 E8 1F 00 F9 E8 47 40 B9 08 05 00 11 E8 47 00 B9 D6 FF FF 17 E8 6F 40 F9 08 01 00 91 08 01 40 F9 08 E1 03 91 08 01 40 F9 08 01 00 91 08 01 40 F9 08 01 C0 39 E8 AF 00 39 E9 23 40 79 29 01 00 11 E8 AF C0 39 08 01 00 11 3F 01 08 6B 41 08 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 A3 00 79 E8 A3 40 79 E8 23 00 79 E9 57 40 F9 E8 1F 40 F9 1F 01 09 EB 01 02 00 54 E8 23 40 79 08 01 00 11 1F C1 00 71 81 01 00 54 28 00 80 52 E8 4F 00 39 E8 47 40 B9 08 05 00 51 E8 47 00 B9 E0 13 40 F9 ?? ?? ?? ?? E0 A7 00 79 E8 A7 40 79 E8 23 00 79 F2 FF FF 17 06 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 AB 00 79 E8 AB 40 79 E8 23 00 79 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 01 80 52 E8 7F 00 B9 03 00 00 14 28 01 80 52 E8 7F 00 B9 E8 7F 40 B9 E8 C7 00 B9 E0 23 40 79 ?? ?? ?? ?? E0 C3 00 B9 E8 C3 40 B9 E8 83 00 B9 E9 C7 40 B9 E8 83 40 B9 1F 01 09 6B 49 00 00 54 0F 00 00 14 28 00 80 52 E8 4F 00 39 E9 73 40 F9 E8 1F 40 F9 1F 01 09 EB 00 01 00 54 E8 83 40 B9 09 1D 00 53 E8 1F 40 F9 09 01 00 39 E8 1F 40 F9 08 05 00 91 E8 1F 00 F9 D9 FF FF 17 E8 4F 40 39 08 01 00 11 1F 01 00 71 61 02 00 54 E0 23 04 91 ?? ?? ?? ?? E0 B3 00 39 E8 B3 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 E0 00 80 52 07 01 00 14 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 40 00 80 52 01 01 00 14 03 00 00 14 E0 00 80 52 FE 00 00 14 E1 23 40 79 E0 13 40 F9 ?? ?? ?? ?? E0 13 40 F9 ?? ?? ?? ?? E0 83 00 F9 E8 83 40 F9 E8 53 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 AF 00 79 E8 AF 40 79 E8 23 00 79 08 00 80 52 E8 53 00 39 E8 23 40 79 08 01 00 11 E8 43 00 B9 E8 43 40 B9 1F 95 01 71 6C 01 00 54 E8 43 40 B9 1F 95 01 71 80 01 00 54 E8 43 40 B9 1F 15 01 71 20 01 00 54 E8 43 40 B9 1F 41 01 71 60 02 00 54 14 00 00 14 E8 43 40 B9 1F C1 01 71 E0 01 00 54 10 00 00 14 E8 4B 40 39 08 01 00 11 1F 01 00 71 81 00 00 54 28 00 80 52 E8 87 00 B9 03 00 00 14 08 00 80 52 E8 87 00 B9 E8 87 40 B9 08 1D 00 53 E8 53 00 39 03 00 00 14 E8 4B 40 39 E8 53 00 39 08 00 80 52 E8 1B 00 B9 E8 53 40 39 08 01 00 11 1F 01 00 71 20 0E 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 C7 00 79 E8 C7 40 79 E8 23 00 79 E8 23 40 79 08 01 00 11 1F B5 00 71 81 00 00 54 28 00 80 52 E8 A3 00 39 03 00 00 14 08 00 80 52 E8 A3 00 39 E8 A3 40 39 E8 B7 00 39 E8 23 40 79 08 01 00 11 1F AD 00 71 A0 00 00 54 E8 23 40 79 08 01 00 11 1F B5 00 71 C1 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 B3 00 79 E8 B3 40 79 E8 23 00 79 08 00 80 52 E8 57 00 39 E8 23 40 79 08 01 00 11 1F C1 00 71 21 01 00 54 28 00 80 52 E8 57 00 39 E0 13 40 F9 ?? ?? ?? ?? E0 B7 00 79 E8 B7 40 79 E8 23 00 79 F5 FF FF 17 06 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 BB 00 79 E8 BB 40 79 E8 23 00 79 E0 23 40 79 ?? ?? ?? ?? E0 D3 00 B9 E8 D3 40 B9 E8 8B 00 B9 E8 8B 40 B9 1F 29 00 71 43 00 00 54 11 00 00 14 28 00 80 52 E8 57 00 39 E9 1B 40 B9 48 01 80 52 29 7D 08 1B E8 8B 40 B9 28 01 08 0B E8 1B 00 B9 09 8A 82 52 E8 1B 40 B9 1F 01 09 6B 8D 00 00 54 28 8A 82 52 E8 1B 00 B9 02 00 00 14 E3 FF FF 17 E0 23 40 79 ?? ?? ?? ?? E0 CB 00 B9 E8 CB 40 B9 1F 29 00 71 E2 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 BF 00 79 E8 BF 40 79 E8 23 00 79 F5 FF FF 17 E8 B7 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 1B 40 B9 E8 03 08 4B E8 1B 00 B9 E8 57 40 39 08 01 00 11 1F 01 00 71 01 02 00 54 E0 23 04 91 ?? ?? ?? ?? E0 BB 00 39 E8 BB 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 C3 00 79 E8 C3 40 79 E8 23 00 79 03 00 00 14 E0 00 80 52 56 00 00 14 E1 23 40 79 E0 13 40 F9 ?? ?? ?? ?? E9 57 40 F9 E8 1F 40 F9 1F 01 09 EB 60 01 00 54 E8 1F 40 F9 08 05 00 D1 08 01 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E8 1F 40 F9 08 05 00 D1 E8 1F 00 F9 F3 FF FF 17 E9 57 40 F9 E8 1F 40 F9 1F 01 09 EB 61 00 00 54 40 00 80 52 3F 00 00 14 09 8A 82 52 E8 1B 40 B9 1F 01 09 6B 6D 00 00 54 20 01 80 52 39 00 00 14 E9 89 82 12 E8 1B 40 B9 1F 01 09 6B 6A 00 00 54 00 01 80 52 33 00 00 14 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 8F 00 B9 03 00 00 14 28 00 80 52 E8 8F 00 B9 E8 8F 40 B9 E8 CF 00 B9 E9 47 40 B9 E8 CF 40 B9 29 7D 08 1B E8 1B 40 B9 08 01 09 0B E8 1B 00 B9 09 8A 82 52 E8 1B 40 B9 1F 01 09 6B 6D 00 00 54 20 01 80 52 1C 00 00 14 E9 89 82 12 E8 1B 40 B9 1F 01 09 6B 6A 00 00 54 00 01 80 52 16 00 00 14 E8 3B 40 F9 09 01 00 91 E8 1B 40 B9 28 01 00 B9 E9 1F 40 F9 E8 57 40 F9 28 01 08 CB 09 01 00 11 E8 3B 40 F9 08 11 00 91 09 01 00 B9 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 93 00 B9 03 00 00 14 08 00 80 52 E8 93 00 B9 E0 93 40 B9 FD 7B D2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_54_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z"
		size = 2252
		refs = "0018 ?validate@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEBA_NXZ 003c ?save_state@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEBA_KXZ 0050 ?get@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA_WXZ 0070 ??0<lambda_2869a9057330eafa474e853b0696fc23>@@QEAA@AEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@AEA_WAEA_K@Z 007c ?is_space@__crt_strtox@@YA_N_WPEAU__crt_locale_pointers@@@Z 0144 ??$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@_K@Z 0180 ??$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@_K@Z 0220 ?unget@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAAX_W@Z 02d0 ?parse_digit@__crt_strtox@@YAI_W@Z 048c ??R<lambda_2869a9057330eafa474e853b0696fc23>@@QEBA_NXZ"
	strings:
		$1 = { FD 7B AE A9 FD 03 00 91 E0 6F 00 F9 E1 13 00 F9 E2 3B 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 A7 00 39 E8 A7 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 E0 00 80 52 24 02 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 77 00 F9 E8 77 40 F9 E8 53 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 CB 00 79 E8 CB 40 79 E8 23 00 79 E3 83 02 91 E2 43 00 91 E1 13 40 F9 E0 23 04 91 ?? ?? ?? ?? E1 6F 40 F9 E0 23 40 79 ?? ?? ?? ?? E0 AB 00 39 E8 AB 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 CF 00 79 E8 CF 40 79 E8 23 00 79 F3 FF FF 17 E8 23 40 79 08 01 00 11 1F B5 00 71 81 00 00 54 28 00 80 52 E8 97 00 B9 03 00 00 14 08 00 80 52 E8 97 00 B9 E8 3B 40 F9 09 21 0C 91 E8 97 40 B9 08 1D 00 53 28 01 00 39 E8 23 40 79 08 01 00 11 1F B5 00 71 A0 00 00 54 E8 23 40 79 08 01 00 11 1F AD 00 71 C1 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 D3 00 79 E8 D3 40 79 E8 23 00 79 E8 23 40 79 08 01 00 11 1F 25 01 71 A0 00 00 54 E8 23 40 79 08 01 00 11 1F A5 01 71 01 01 00 54 E2 53 40 F9 E1 13 40 F9 E0 43 00 91 ?? ?? ?? ?? E0 B3 00 B9 E0 B3 40 B9 DD 01 00 14 E8 23 40 79 08 01 00 11 1F 39 01 71 A0 00 00 54 E8 23 40 79 08 01 00 11 1F B9 01 71 01 01 00 54 E2 53 40 F9 E1 13 40 F9 E0 43 00 91 ?? ?? ?? ?? E0 B7 00 B9 E0 B7 40 B9 CE 01 00 14 08 00 80 52 E8 4B 00 39 E8 23 40 79 08 01 00 11 1F C1 00 71 01 04 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 7B 00 F9 E8 7B 40 F9 E8 7F 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 93 00 79 E8 93 40 79 E8 63 00 79 E8 63 40 79 08 01 00 11 1F E1 01 71 A0 00 00 54 E8 63 40 79 08 01 00 11 1F 61 01 71 61 01 00 54 28 00 80 52 E8 4B 00 39 E0 13 40 F9 ?? ?? ?? ?? E0 97 00 79 E8 97 40 79 E8 23 00 79 E8 7F 40 F9 E8 53 00 F9 04 00 00 14 E1 63 40 79 E0 13 40 F9 ?? ?? ?? ?? E8 3B 40 F9 08 21 00 91 E8 57 00 F9 E8 3B 40 F9 08 21 0C 91 E8 73 00 F9 E8 3B 40 F9 08 21 00 91 E8 1F 00 F9 08 00 80 52 E8 47 00 B9 08 00 80 52 E8 4F 00 39 E8 23 40 79 08 01 00 11 1F C1 00 71 21 01 00 54 28 00 80 52 E8 4F 00 39 E0 13 40 F9 ?? ?? ?? ?? E0 9B 00 79 E8 9B 40 79 E8 23 00 79 F5 FF FF 17 06 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 9F 00 79 E8 9F 40 79 E8 23 00 79 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 01 80 52 E8 9B 00 B9 03 00 00 14 28 01 80 52 E8 9B 00 B9 E8 9B 40 B9 E8 BF 00 B9 E0 23 40 79 ?? ?? ?? ?? E0 BB 00 B9 E8 BB 40 B9 E8 7B 00 B9 E9 BF 40 B9 E8 7B 40 B9 1F 01 09 6B 49 00 00 54 12 00 00 14 28 00 80 52 E8 4F 00 39 E9 73 40 F9 E8 1F 40 F9 1F 01 09 EB 00 01 00 54 E8 7B 40 B9 09 1D 00 53 E8 1F 40 F9 09 01 00 39 E8 1F 40 F9 08 05 00 91 E8 1F 00 F9 E8 47 40 B9 08 05 00 11 E8 47 00 B9 D6 FF FF 17 E8 6F 40 F9 08 01 00 91 08 01 40 F9 08 E1 03 91 08 01 40 F9 08 01 00 91 08 01 40 F9 08 01 C0 39 E8 AF 00 39 E9 23 40 79 29 01 00 11 E8 AF C0 39 08 01 00 11 3F 01 08 6B 41 08 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 A3 00 79 E8 A3 40 79 E8 23 00 79 E9 57 40 F9 E8 1F 40 F9 1F 01 09 EB 01 02 00 54 E8 23 40 79 08 01 00 11 1F C1 00 71 81 01 00 54 28 00 80 52 E8 4F 00 39 E8 47 40 B9 08 05 00 51 E8 47 00 B9 E0 13 40 F9 ?? ?? ?? ?? E0 A7 00 79 E8 A7 40 79 E8 23 00 79 F2 FF FF 17 06 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 AB 00 79 E8 AB 40 79 E8 23 00 79 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 01 80 52 E8 7F 00 B9 03 00 00 14 28 01 80 52 E8 7F 00 B9 E8 7F 40 B9 E8 C7 00 B9 E0 23 40 79 ?? ?? ?? ?? E0 C3 00 B9 E8 C3 40 B9 E8 83 00 B9 E9 C7 40 B9 E8 83 40 B9 1F 01 09 6B 49 00 00 54 0F 00 00 14 28 00 80 52 E8 4F 00 39 E9 73 40 F9 E8 1F 40 F9 1F 01 09 EB 00 01 00 54 E8 83 40 B9 09 1D 00 53 E8 1F 40 F9 09 01 00 39 E8 1F 40 F9 08 05 00 91 E8 1F 00 F9 D9 FF FF 17 E8 4F 40 39 08 01 00 11 1F 01 00 71 61 02 00 54 E0 23 04 91 ?? ?? ?? ?? E0 B3 00 39 E8 B3 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 E0 00 80 52 07 01 00 14 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 40 00 80 52 01 01 00 14 03 00 00 14 E0 00 80 52 FE 00 00 14 E1 23 40 79 E0 13 40 F9 ?? ?? ?? ?? E0 13 40 F9 ?? ?? ?? ?? E0 83 00 F9 E8 83 40 F9 E8 53 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 AF 00 79 E8 AF 40 79 E8 23 00 79 08 00 80 52 E8 53 00 39 E8 23 40 79 08 01 00 11 E8 43 00 B9 E8 43 40 B9 1F 95 01 71 6C 01 00 54 E8 43 40 B9 1F 95 01 71 80 01 00 54 E8 43 40 B9 1F 15 01 71 20 01 00 54 E8 43 40 B9 1F 41 01 71 60 02 00 54 14 00 00 14 E8 43 40 B9 1F C1 01 71 E0 01 00 54 10 00 00 14 E8 4B 40 39 08 01 00 11 1F 01 00 71 81 00 00 54 28 00 80 52 E8 87 00 B9 03 00 00 14 08 00 80 52 E8 87 00 B9 E8 87 40 B9 08 1D 00 53 E8 53 00 39 03 00 00 14 E8 4B 40 39 E8 53 00 39 08 00 80 52 E8 1B 00 B9 E8 53 40 39 08 01 00 11 1F 01 00 71 20 0E 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 C7 00 79 E8 C7 40 79 E8 23 00 79 E8 23 40 79 08 01 00 11 1F B5 00 71 81 00 00 54 28 00 80 52 E8 A3 00 39 03 00 00 14 08 00 80 52 E8 A3 00 39 E8 A3 40 39 E8 B7 00 39 E8 23 40 79 08 01 00 11 1F AD 00 71 A0 00 00 54 E8 23 40 79 08 01 00 11 1F B5 00 71 C1 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 B3 00 79 E8 B3 40 79 E8 23 00 79 08 00 80 52 E8 57 00 39 E8 23 40 79 08 01 00 11 1F C1 00 71 21 01 00 54 28 00 80 52 E8 57 00 39 E0 13 40 F9 ?? ?? ?? ?? E0 B7 00 79 E8 B7 40 79 E8 23 00 79 F5 FF FF 17 06 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 BB 00 79 E8 BB 40 79 E8 23 00 79 E0 23 40 79 ?? ?? ?? ?? E0 D3 00 B9 E8 D3 40 B9 E8 8B 00 B9 E8 8B 40 B9 1F 29 00 71 43 00 00 54 11 00 00 14 28 00 80 52 E8 57 00 39 E9 1B 40 B9 48 01 80 52 29 7D 08 1B E8 8B 40 B9 28 01 08 0B E8 1B 00 B9 09 8A 82 52 E8 1B 40 B9 1F 01 09 6B 8D 00 00 54 28 8A 82 52 E8 1B 00 B9 02 00 00 14 E3 FF FF 17 E0 23 40 79 ?? ?? ?? ?? E0 CB 00 B9 E8 CB 40 B9 1F 29 00 71 E2 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 BF 00 79 E8 BF 40 79 E8 23 00 79 F5 FF FF 17 E8 B7 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 1B 40 B9 E8 03 08 4B E8 1B 00 B9 E8 57 40 39 08 01 00 11 1F 01 00 71 01 02 00 54 E0 23 04 91 ?? ?? ?? ?? E0 BB 00 39 E8 BB 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 C3 00 79 E8 C3 40 79 E8 23 00 79 03 00 00 14 E0 00 80 52 56 00 00 14 E1 23 40 79 E0 13 40 F9 ?? ?? ?? ?? E9 57 40 F9 E8 1F 40 F9 1F 01 09 EB 60 01 00 54 E8 1F 40 F9 08 05 00 D1 08 01 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E8 1F 40 F9 08 05 00 D1 E8 1F 00 F9 F3 FF FF 17 E9 57 40 F9 E8 1F 40 F9 1F 01 09 EB 61 00 00 54 40 00 80 52 3F 00 00 14 09 8A 82 52 E8 1B 40 B9 1F 01 09 6B 6D 00 00 54 20 01 80 52 39 00 00 14 E9 89 82 12 E8 1B 40 B9 1F 01 09 6B 6A 00 00 54 00 01 80 52 33 00 00 14 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 8F 00 B9 03 00 00 14 28 00 80 52 E8 8F 00 B9 E8 8F 40 B9 E8 CF 00 B9 E9 47 40 B9 E8 CF 40 B9 29 7D 08 1B E8 1B 40 B9 08 01 09 0B E8 1B 00 B9 09 8A 82 52 E8 1B 40 B9 1F 01 09 6B 6D 00 00 54 20 01 80 52 1C 00 00 14 E9 89 82 12 E8 1B 40 B9 1F 01 09 6B 6A 00 00 54 00 01 80 52 16 00 00 14 E8 3B 40 F9 09 01 00 91 E8 1B 40 B9 28 01 00 B9 E9 1F 40 F9 E8 57 40 F9 28 01 08 CB 09 01 00 11 E8 3B 40 F9 08 11 00 91 09 01 00 B9 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 93 00 B9 03 00 00 14 08 00 80 52 E8 93 00 B9 E0 93 40 B9 FD 7B D2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_56_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@AEAUfloating_point_string@0@@Z"
		size = 2252
		refs = "0018 ?validate@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEBA_NXZ 003c ?save_state@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEBA_KXZ 0050 ?get@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA_WXZ 0070 ??0<lambda_ab71cf08e5e7ad30a15505f224e9f7a9>@@QEAA@AEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@AEA_WAEA_K@Z 007c ?is_space@__crt_strtox@@YA_N_WPEAU__crt_locale_pointers@@@Z 0144 ??$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@_K@Z 0180 ??$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@_K@Z 0220 ?unget@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAAX_W@Z 02d0 ?parse_digit@__crt_strtox@@YAI_W@Z 048c ??R<lambda_ab71cf08e5e7ad30a15505f224e9f7a9>@@QEBA_NXZ"
	strings:
		$1 = { FD 7B AE A9 FD 03 00 91 E0 6F 00 F9 E1 13 00 F9 E2 3B 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 A7 00 39 E8 A7 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 E0 00 80 52 24 02 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 77 00 F9 E8 77 40 F9 E8 53 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 CB 00 79 E8 CB 40 79 E8 23 00 79 E3 83 02 91 E2 43 00 91 E1 13 40 F9 E0 23 04 91 ?? ?? ?? ?? E1 6F 40 F9 E0 23 40 79 ?? ?? ?? ?? E0 AB 00 39 E8 AB 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 CF 00 79 E8 CF 40 79 E8 23 00 79 F3 FF FF 17 E8 23 40 79 08 01 00 11 1F B5 00 71 81 00 00 54 28 00 80 52 E8 97 00 B9 03 00 00 14 08 00 80 52 E8 97 00 B9 E8 3B 40 F9 09 21 0C 91 E8 97 40 B9 08 1D 00 53 28 01 00 39 E8 23 40 79 08 01 00 11 1F B5 00 71 A0 00 00 54 E8 23 40 79 08 01 00 11 1F AD 00 71 C1 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 D3 00 79 E8 D3 40 79 E8 23 00 79 E8 23 40 79 08 01 00 11 1F 25 01 71 A0 00 00 54 E8 23 40 79 08 01 00 11 1F A5 01 71 01 01 00 54 E2 53 40 F9 E1 13 40 F9 E0 43 00 91 ?? ?? ?? ?? E0 B3 00 B9 E0 B3 40 B9 DD 01 00 14 E8 23 40 79 08 01 00 11 1F 39 01 71 A0 00 00 54 E8 23 40 79 08 01 00 11 1F B9 01 71 01 01 00 54 E2 53 40 F9 E1 13 40 F9 E0 43 00 91 ?? ?? ?? ?? E0 B7 00 B9 E0 B7 40 B9 CE 01 00 14 08 00 80 52 E8 4B 00 39 E8 23 40 79 08 01 00 11 1F C1 00 71 01 04 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 7B 00 F9 E8 7B 40 F9 E8 7F 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 93 00 79 E8 93 40 79 E8 63 00 79 E8 63 40 79 08 01 00 11 1F E1 01 71 A0 00 00 54 E8 63 40 79 08 01 00 11 1F 61 01 71 61 01 00 54 28 00 80 52 E8 4B 00 39 E0 13 40 F9 ?? ?? ?? ?? E0 97 00 79 E8 97 40 79 E8 23 00 79 E8 7F 40 F9 E8 53 00 F9 04 00 00 14 E1 63 40 79 E0 13 40 F9 ?? ?? ?? ?? E8 3B 40 F9 08 21 00 91 E8 57 00 F9 E8 3B 40 F9 08 21 0C 91 E8 73 00 F9 E8 3B 40 F9 08 21 00 91 E8 1F 00 F9 08 00 80 52 E8 47 00 B9 08 00 80 52 E8 4F 00 39 E8 23 40 79 08 01 00 11 1F C1 00 71 21 01 00 54 28 00 80 52 E8 4F 00 39 E0 13 40 F9 ?? ?? ?? ?? E0 9B 00 79 E8 9B 40 79 E8 23 00 79 F5 FF FF 17 06 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 9F 00 79 E8 9F 40 79 E8 23 00 79 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 01 80 52 E8 9B 00 B9 03 00 00 14 28 01 80 52 E8 9B 00 B9 E8 9B 40 B9 E8 BF 00 B9 E0 23 40 79 ?? ?? ?? ?? E0 BB 00 B9 E8 BB 40 B9 E8 7B 00 B9 E9 BF 40 B9 E8 7B 40 B9 1F 01 09 6B 49 00 00 54 12 00 00 14 28 00 80 52 E8 4F 00 39 E9 73 40 F9 E8 1F 40 F9 1F 01 09 EB 00 01 00 54 E8 7B 40 B9 09 1D 00 53 E8 1F 40 F9 09 01 00 39 E8 1F 40 F9 08 05 00 91 E8 1F 00 F9 E8 47 40 B9 08 05 00 11 E8 47 00 B9 D6 FF FF 17 E8 6F 40 F9 08 01 00 91 08 01 40 F9 08 E1 03 91 08 01 40 F9 08 01 00 91 08 01 40 F9 08 01 C0 39 E8 AF 00 39 E9 23 40 79 29 01 00 11 E8 AF C0 39 08 01 00 11 3F 01 08 6B 41 08 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 A3 00 79 E8 A3 40 79 E8 23 00 79 E9 57 40 F9 E8 1F 40 F9 1F 01 09 EB 01 02 00 54 E8 23 40 79 08 01 00 11 1F C1 00 71 81 01 00 54 28 00 80 52 E8 4F 00 39 E8 47 40 B9 08 05 00 51 E8 47 00 B9 E0 13 40 F9 ?? ?? ?? ?? E0 A7 00 79 E8 A7 40 79 E8 23 00 79 F2 FF FF 17 06 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 AB 00 79 E8 AB 40 79 E8 23 00 79 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 01 80 52 E8 7F 00 B9 03 00 00 14 28 01 80 52 E8 7F 00 B9 E8 7F 40 B9 E8 C7 00 B9 E0 23 40 79 ?? ?? ?? ?? E0 C3 00 B9 E8 C3 40 B9 E8 83 00 B9 E9 C7 40 B9 E8 83 40 B9 1F 01 09 6B 49 00 00 54 0F 00 00 14 28 00 80 52 E8 4F 00 39 E9 73 40 F9 E8 1F 40 F9 1F 01 09 EB 00 01 00 54 E8 83 40 B9 09 1D 00 53 E8 1F 40 F9 09 01 00 39 E8 1F 40 F9 08 05 00 91 E8 1F 00 F9 D9 FF FF 17 E8 4F 40 39 08 01 00 11 1F 01 00 71 61 02 00 54 E0 23 04 91 ?? ?? ?? ?? E0 B3 00 39 E8 B3 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 E0 00 80 52 07 01 00 14 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 40 00 80 52 01 01 00 14 03 00 00 14 E0 00 80 52 FE 00 00 14 E1 23 40 79 E0 13 40 F9 ?? ?? ?? ?? E0 13 40 F9 ?? ?? ?? ?? E0 83 00 F9 E8 83 40 F9 E8 53 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 AF 00 79 E8 AF 40 79 E8 23 00 79 08 00 80 52 E8 53 00 39 E8 23 40 79 08 01 00 11 E8 43 00 B9 E8 43 40 B9 1F 95 01 71 6C 01 00 54 E8 43 40 B9 1F 95 01 71 80 01 00 54 E8 43 40 B9 1F 15 01 71 20 01 00 54 E8 43 40 B9 1F 41 01 71 60 02 00 54 14 00 00 14 E8 43 40 B9 1F C1 01 71 E0 01 00 54 10 00 00 14 E8 4B 40 39 08 01 00 11 1F 01 00 71 81 00 00 54 28 00 80 52 E8 87 00 B9 03 00 00 14 08 00 80 52 E8 87 00 B9 E8 87 40 B9 08 1D 00 53 E8 53 00 39 03 00 00 14 E8 4B 40 39 E8 53 00 39 08 00 80 52 E8 1B 00 B9 E8 53 40 39 08 01 00 11 1F 01 00 71 20 0E 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 C7 00 79 E8 C7 40 79 E8 23 00 79 E8 23 40 79 08 01 00 11 1F B5 00 71 81 00 00 54 28 00 80 52 E8 A3 00 39 03 00 00 14 08 00 80 52 E8 A3 00 39 E8 A3 40 39 E8 B7 00 39 E8 23 40 79 08 01 00 11 1F AD 00 71 A0 00 00 54 E8 23 40 79 08 01 00 11 1F B5 00 71 C1 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 B3 00 79 E8 B3 40 79 E8 23 00 79 08 00 80 52 E8 57 00 39 E8 23 40 79 08 01 00 11 1F C1 00 71 21 01 00 54 28 00 80 52 E8 57 00 39 E0 13 40 F9 ?? ?? ?? ?? E0 B7 00 79 E8 B7 40 79 E8 23 00 79 F5 FF FF 17 06 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 BB 00 79 E8 BB 40 79 E8 23 00 79 E0 23 40 79 ?? ?? ?? ?? E0 D3 00 B9 E8 D3 40 B9 E8 8B 00 B9 E8 8B 40 B9 1F 29 00 71 43 00 00 54 11 00 00 14 28 00 80 52 E8 57 00 39 E9 1B 40 B9 48 01 80 52 29 7D 08 1B E8 8B 40 B9 28 01 08 0B E8 1B 00 B9 09 8A 82 52 E8 1B 40 B9 1F 01 09 6B 8D 00 00 54 28 8A 82 52 E8 1B 00 B9 02 00 00 14 E3 FF FF 17 E0 23 40 79 ?? ?? ?? ?? E0 CB 00 B9 E8 CB 40 B9 1F 29 00 71 E2 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 BF 00 79 E8 BF 40 79 E8 23 00 79 F5 FF FF 17 E8 B7 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 1B 40 B9 E8 03 08 4B E8 1B 00 B9 E8 57 40 39 08 01 00 11 1F 01 00 71 01 02 00 54 E0 23 04 91 ?? ?? ?? ?? E0 BB 00 39 E8 BB 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 C3 00 79 E8 C3 40 79 E8 23 00 79 03 00 00 14 E0 00 80 52 56 00 00 14 E1 23 40 79 E0 13 40 F9 ?? ?? ?? ?? E9 57 40 F9 E8 1F 40 F9 1F 01 09 EB 60 01 00 54 E8 1F 40 F9 08 05 00 D1 08 01 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E8 1F 40 F9 08 05 00 D1 E8 1F 00 F9 F3 FF FF 17 E9 57 40 F9 E8 1F 40 F9 1F 01 09 EB 61 00 00 54 40 00 80 52 3F 00 00 14 09 8A 82 52 E8 1B 40 B9 1F 01 09 6B 6D 00 00 54 20 01 80 52 39 00 00 14 E9 89 82 12 E8 1B 40 B9 1F 01 09 6B 6A 00 00 54 00 01 80 52 33 00 00 14 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 8F 00 B9 03 00 00 14 28 00 80 52 E8 8F 00 B9 E8 8F 40 B9 E8 CF 00 B9 E9 47 40 B9 E8 CF 40 B9 29 7D 08 1B E8 1B 40 B9 08 01 09 0B E8 1B 00 B9 09 8A 82 52 E8 1B 40 B9 1F 01 09 6B 6D 00 00 54 20 01 80 52 1C 00 00 14 E9 89 82 12 E8 1B 40 B9 1F 01 09 6B 6A 00 00 54 00 01 80 52 16 00 00 14 E8 3B 40 F9 09 01 00 91 E8 1B 40 B9 28 01 00 B9 E9 1F 40 F9 E8 57 40 F9 28 01 08 CB 09 01 00 11 E8 3B 40 F9 08 11 00 91 09 01 00 B9 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 93 00 B9 03 00 00 14 08 00 80 52 E8 93 00 B9 E0 93 40 B9 FD 7B D2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_28_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$c_string_character_source@D@0@PEBD@Z"
		size = 304
		refs = "0024 ??0<lambda_85175643e3245fab8ee1d5c9ffbed652>@@QEAA@AEAV?$c_string_character_source@D@__crt_strtox@@AEADAEAPEBD@Z 0034 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$c_string_character_source@D@1@PEBD@Z@4QBDB 003c ?inf_uppercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$c_string_character_source@D@1@PEBD@Z@4QBDB 0044 ??$parse_next_characters_from_source@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$c_string_character_source@D@0@@Z 0060 ??R<lambda_85175643e3245fab8ee1d5c9ffbed652>@@QEBA_NXZ 0078 ?unget@?$c_string_character_source@D@__crt_strtox@@QEAAXD@Z 0080 ?save_state@?$c_string_character_source@D@__crt_strtox@@QEBAPEBDXZ 0094 ?get@?$c_string_character_source@D@__crt_strtox@@QEAADXZ 00b4 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$c_string_character_source@D@1@PEBD@Z@4QBDB 00bc ?inity_uppercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$c_string_character_source@D@1@PEBD@Z@4QBDB"
	strings:
		$1 = { FD 7B BA A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E2 1B 00 F9 E3 C3 00 91 E2 13 40 F9 E1 0F 40 F9 E0 03 01 91 ?? ?? ?? ?? E4 0F 40 F9 E3 13 40 F9 62 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E0 03 01 91 ?? ?? ?? ?? E0 00 80 52 30 00 00 14 E8 13 40 F9 01 01 C0 39 E0 0F 40 F9 ?? ?? ?? ?? E0 0F 40 F9 ?? ?? ?? ?? E0 1F 00 F9 E8 1F 40 F9 E8 1B 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 47 00 39 E9 13 40 F9 E8 47 C0 39 28 01 00 39 E4 0F 40 F9 E3 13 40 F9 A2 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 4B 00 39 E8 4B 40 39 08 01 00 11 1F 01 00 71 E1 01 00 54 E0 03 01 91 ?? ?? ?? ?? E0 4F 00 39 E8 4F 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 68 00 80 52 E8 2B 00 B9 03 00 00 14 E8 00 80 52 E8 2B 00 B9 E0 2B 40 B9 06 00 00 14 E8 13 40 F9 01 01 C0 39 E0 0F 40 F9 ?? ?? ?? ?? 60 00 80 52 FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_57_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
		size = 304
		refs = "0024 ??0<lambda_1232a416a9149be513dc40db5f8b835d>@@QEAA@AEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@AEADAEA_K@Z 0034 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 003c ?inf_uppercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0044 ??$parse_next_characters_from_source@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z 0060 ??R<lambda_1232a416a9149be513dc40db5f8b835d>@@QEBA_NXZ 0078 ?unget@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAAXD@Z 0080 ?save_state@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEBA_KXZ 0094 ?get@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAADXZ 00b4 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 00bc ?inity_uppercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB"
	strings:
		$1 = { FD 7B BA A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E2 1B 00 F9 E3 C3 00 91 E2 13 40 F9 E1 0F 40 F9 E0 03 01 91 ?? ?? ?? ?? E4 0F 40 F9 E3 13 40 F9 62 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E0 03 01 91 ?? ?? ?? ?? E0 00 80 52 30 00 00 14 E8 13 40 F9 01 01 C0 39 E0 0F 40 F9 ?? ?? ?? ?? E0 0F 40 F9 ?? ?? ?? ?? E0 1F 00 F9 E8 1F 40 F9 E8 1B 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 47 00 39 E9 13 40 F9 E8 47 C0 39 28 01 00 39 E4 0F 40 F9 E3 13 40 F9 A2 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 4B 00 39 E8 4B 40 39 08 01 00 11 1F 01 00 71 E1 01 00 54 E0 03 01 91 ?? ?? ?? ?? E0 4F 00 39 E8 4F 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 68 00 80 52 E8 2B 00 B9 03 00 00 14 E8 00 80 52 E8 2B 00 B9 E0 2B 40 B9 06 00 00 14 E8 13 40 F9 01 01 C0 39 E0 0F 40 F9 ?? ?? ?? ?? 60 00 80 52 FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_58_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
		size = 304
		refs = "0024 ??0<lambda_ee7c83d9f0cd4f1299194e0a8d424b67>@@QEAA@AEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@AEADAEA_K@Z 0034 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 003c ?inf_uppercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0044 ??$parse_next_characters_from_source@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z 0060 ??R<lambda_ee7c83d9f0cd4f1299194e0a8d424b67>@@QEBA_NXZ 0078 ?unget@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAAXD@Z 0080 ?save_state@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEBA_KXZ 0094 ?get@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAADXZ 00b4 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 00bc ?inity_uppercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB"
	strings:
		$1 = { FD 7B BA A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E2 1B 00 F9 E3 C3 00 91 E2 13 40 F9 E1 0F 40 F9 E0 03 01 91 ?? ?? ?? ?? E4 0F 40 F9 E3 13 40 F9 62 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E0 03 01 91 ?? ?? ?? ?? E0 00 80 52 30 00 00 14 E8 13 40 F9 01 01 C0 39 E0 0F 40 F9 ?? ?? ?? ?? E0 0F 40 F9 ?? ?? ?? ?? E0 1F 00 F9 E8 1F 40 F9 E8 1B 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 47 00 39 E9 13 40 F9 E8 47 C0 39 28 01 00 39 E4 0F 40 F9 E3 13 40 F9 A2 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 4B 00 39 E8 4B 40 39 08 01 00 11 1F 01 00 71 E1 01 00 54 E0 03 01 91 ?? ?? ?? ?? E0 4F 00 39 E8 4F 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 68 00 80 52 E8 2B 00 B9 03 00 00 14 E8 00 80 52 E8 2B 00 B9 E0 2B 40 B9 06 00 00 14 E8 13 40 F9 01 01 C0 39 E0 0F 40 F9 ?? ?? ?? ?? 60 00 80 52 FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_29_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$c_string_character_source@_W@0@PEB_W@Z"
		size = 304
		refs = "0024 ??0<lambda_b2e4b863da30a29f1a9fc7ecc6d00735>@@QEAA@AEAV?$c_string_character_source@_W@__crt_strtox@@AEA_WAEAPEB_W@Z 0034 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$c_string_character_source@_W@1@PEB_W@Z@4QB_WB 003c ?inf_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$c_string_character_source@_W@1@PEB_W@Z@4QB_WB 0044 ??$parse_next_characters_from_source@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NQEB_W0_KAEA_WAEAV?$c_string_character_source@_W@0@@Z 0060 ??R<lambda_b2e4b863da30a29f1a9fc7ecc6d00735>@@QEBA_NXZ 0078 ?unget@?$c_string_character_source@_W@__crt_strtox@@QEAAX_W@Z 0080 ?save_state@?$c_string_character_source@_W@__crt_strtox@@QEBAPEB_WXZ 0094 ?get@?$c_string_character_source@_W@__crt_strtox@@QEAA_WXZ 00b4 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$c_string_character_source@_W@1@PEB_W@Z@4QB_WB 00bc ?inity_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$c_string_character_source@_W@1@PEB_W@Z@4QB_WB"
	strings:
		$1 = { FD 7B BA A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E2 1B 00 F9 E3 C3 00 91 E2 13 40 F9 E1 0F 40 F9 E0 03 01 91 ?? ?? ?? ?? E4 0F 40 F9 E3 13 40 F9 62 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E0 03 01 91 ?? ?? ?? ?? E0 00 80 52 30 00 00 14 E8 13 40 F9 01 01 40 79 E0 0F 40 F9 ?? ?? ?? ?? E0 0F 40 F9 ?? ?? ?? ?? E0 1F 00 F9 E8 1F 40 F9 E8 1B 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 2B 00 79 E9 13 40 F9 E8 2B 40 79 28 01 00 79 E4 0F 40 F9 E3 13 40 F9 A2 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 47 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 E1 01 00 54 E0 03 01 91 ?? ?? ?? ?? E0 4B 00 39 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 68 00 80 52 E8 2B 00 B9 03 00 00 14 E8 00 80 52 E8 2B 00 B9 E0 2B 40 B9 06 00 00 14 E8 13 40 F9 01 01 40 79 E0 0F 40 F9 ?? ?? ?? ?? 60 00 80 52 FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_59_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
		size = 304
		refs = "0024 ??0<lambda_3fab6266ebbbb6a80db50646f7fd7b75>@@QEAA@AEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@AEA_WAEA_K@Z 0034 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 003c ?inf_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0044 ??$parse_next_characters_from_source@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEB_W0_KAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z 0060 ??R<lambda_3fab6266ebbbb6a80db50646f7fd7b75>@@QEBA_NXZ 0078 ?unget@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAAX_W@Z 0080 ?save_state@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEBA_KXZ 0094 ?get@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA_WXZ 00b4 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 00bc ?inity_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB"
	strings:
		$1 = { FD 7B BA A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E2 1B 00 F9 E3 C3 00 91 E2 13 40 F9 E1 0F 40 F9 E0 03 01 91 ?? ?? ?? ?? E4 0F 40 F9 E3 13 40 F9 62 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E0 03 01 91 ?? ?? ?? ?? E0 00 80 52 30 00 00 14 E8 13 40 F9 01 01 40 79 E0 0F 40 F9 ?? ?? ?? ?? E0 0F 40 F9 ?? ?? ?? ?? E0 1F 00 F9 E8 1F 40 F9 E8 1B 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 2B 00 79 E9 13 40 F9 E8 2B 40 79 28 01 00 79 E4 0F 40 F9 E3 13 40 F9 A2 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 47 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 E1 01 00 54 E0 03 01 91 ?? ?? ?? ?? E0 4B 00 39 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 68 00 80 52 E8 2B 00 B9 03 00 00 14 E8 00 80 52 E8 2B 00 B9 E0 2B 40 B9 06 00 00 14 E8 13 40 F9 01 01 40 79 E0 0F 40 F9 ?? ?? ?? ?? 60 00 80 52 FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_60_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
		size = 304
		refs = "0024 ??0<lambda_283d5cd4935f5253d095a945c5771a1b>@@QEAA@AEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@AEA_WAEA_K@Z 0034 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 003c ?inf_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0044 ??$parse_next_characters_from_source@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEB_W0_KAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z 0060 ??R<lambda_283d5cd4935f5253d095a945c5771a1b>@@QEBA_NXZ 0078 ?unget@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAAX_W@Z 0080 ?save_state@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEBA_KXZ 0094 ?get@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA_WXZ 00b4 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 00bc ?inity_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB"
	strings:
		$1 = { FD 7B BA A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E2 1B 00 F9 E3 C3 00 91 E2 13 40 F9 E1 0F 40 F9 E0 03 01 91 ?? ?? ?? ?? E4 0F 40 F9 E3 13 40 F9 62 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E0 03 01 91 ?? ?? ?? ?? E0 00 80 52 30 00 00 14 E8 13 40 F9 01 01 40 79 E0 0F 40 F9 ?? ?? ?? ?? E0 0F 40 F9 ?? ?? ?? ?? E0 1F 00 F9 E8 1F 40 F9 E8 1B 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 2B 00 79 E9 13 40 F9 E8 2B 40 79 28 01 00 79 E4 0F 40 F9 E3 13 40 F9 A2 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 47 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 E1 01 00 54 E0 03 01 91 ?? ?? ?? ?? E0 4B 00 39 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 68 00 80 52 E8 2B 00 B9 03 00 00 14 E8 00 80 52 E8 2B 00 B9 E0 2B 40 B9 06 00 00 14 E8 13 40 F9 01 01 40 79 E0 0F 40 F9 ?? ?? ?? ?? 60 00 80 52 FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_30_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$c_string_character_source@D@0@PEBD@Z"
		size = 632
		refs = "0024 ??0<lambda_aaca0f6c2c612c0ee38e1ea27fdc2ad6>@@QEAA@AEAV?$c_string_character_source@D@__crt_strtox@@AEADAEAPEBD@Z 0034 ?lowercase@?1???$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$c_string_character_source@D@1@PEBD@Z@4QBDB 003c ?uppercase@?1???$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$c_string_character_source@D@1@PEBD@Z@4QBDB 0044 ??$parse_next_characters_from_source@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$c_string_character_source@D@0@@Z 0060 ??R<lambda_aaca0f6c2c612c0ee38e1ea27fdc2ad6>@@QEBA_NXZ 0078 ?unget@?$c_string_character_source@D@__crt_strtox@@QEAAXD@Z 0080 ?save_state@?$c_string_character_source@D@__crt_strtox@@QEBAPEBDXZ 0094 ?get@?$c_string_character_source@D@__crt_strtox@@QEAADXZ 0114 ??$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@0@@Z 014c ??$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@0@@Z 01b4 ?is_digit_or_nondigit@__crt_strtox@@YA_NH@Z"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 13 00 F9 E1 17 00 F9 E2 23 00 F9 E3 03 01 91 E2 13 40 F9 E1 17 40 F9 E0 43 01 91 ?? ?? ?? ?? E4 17 40 F9 E3 13 40 F9 62 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E0 43 01 91 ?? ?? ?? ?? E0 00 80 52 82 00 00 14 E8 13 40 F9 01 01 C0 39 E0 17 40 F9 ?? ?? ?? ?? E0 17 40 F9 ?? ?? ?? ?? E0 27 00 F9 E8 27 40 F9 E8 23 00 F9 E0 17 40 F9 ?? ?? ?? ?? E0 47 00 39 E9 13 40 F9 E8 47 C0 39 28 01 00 39 E8 13 40 F9 08 01 C0 39 08 01 00 11 1F A1 00 71 E0 01 00 54 E0 43 01 91 ?? ?? ?? ?? E0 4B 00 39 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 33 00 B9 03 00 00 14 E8 00 80 52 E8 33 00 B9 E0 33 40 B9 60 00 00 14 E0 17 40 F9 ?? ?? ?? ?? E0 4F 00 39 E9 13 40 F9 E8 4F C0 39 28 01 00 39 E1 17 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 53 00 39 E8 53 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E8 13 40 F9 01 01 C0 39 E0 17 40 F9 ?? ?? ?? ?? A0 00 80 52 4C 00 00 14 E1 17 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 57 00 39 E8 57 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E8 13 40 F9 01 01 C0 39 E0 17 40 F9 ?? ?? ?? ?? C0 00 80 52 3E 00 00 14 E8 13 40 F9 08 01 C0 39 08 01 00 11 1F A5 00 71 A0 04 00 54 E8 13 40 F9 08 01 C0 39 08 01 00 11 1F 01 00 71 00 04 00 54 E8 13 40 F9 00 01 C0 39 00 00 00 11 00 00 00 11 ?? ?? ?? ?? E0 5B 00 39 E8 5B 40 39 08 01 00 11 1F 01 00 71 E1 01 00 54 E0 43 01 91 ?? ?? ?? ?? E0 5F 00 39 E8 5F 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 37 00 B9 03 00 00 14 E8 00 80 52 E8 37 00 B9 E0 37 40 B9 1C 00 00 14 E0 17 40 F9 ?? ?? ?? ?? E0 63 00 39 E9 13 40 F9 E8 63 C0 39 28 01 00 39 D8 FF FF 17 E8 13 40 F9 08 01 C0 39 08 01 00 11 1F A5 00 71 E0 01 00 54 E0 43 01 91 ?? ?? ?? ?? E0 67 00 39 E8 67 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 3B 00 B9 03 00 00 14 E8 00 80 52 E8 3B 00 B9 E0 3B 40 B9 02 00 00 14 80 00 80 52 FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_61_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
		size = 632
		refs = "0024 ??0<lambda_156378f40168adef48d7ddfcff3a1264>@@QEAA@AEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@AEADAEA_K@Z 0034 ?lowercase@?1???$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 003c ?uppercase@?1???$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0044 ??$parse_next_characters_from_source@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z 0060 ??R<lambda_156378f40168adef48d7ddfcff3a1264>@@QEBA_NXZ 0078 ?unget@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAAXD@Z 0080 ?save_state@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEBA_KXZ 0094 ?get@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAADXZ 0114 ??$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z 014c ??$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z 01b4 ?is_digit_or_nondigit@__crt_strtox@@YA_NH@Z"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 13 00 F9 E1 17 00 F9 E2 23 00 F9 E3 03 01 91 E2 13 40 F9 E1 17 40 F9 E0 43 01 91 ?? ?? ?? ?? E4 17 40 F9 E3 13 40 F9 62 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E0 43 01 91 ?? ?? ?? ?? E0 00 80 52 82 00 00 14 E8 13 40 F9 01 01 C0 39 E0 17 40 F9 ?? ?? ?? ?? E0 17 40 F9 ?? ?? ?? ?? E0 27 00 F9 E8 27 40 F9 E8 23 00 F9 E0 17 40 F9 ?? ?? ?? ?? E0 47 00 39 E9 13 40 F9 E8 47 C0 39 28 01 00 39 E8 13 40 F9 08 01 C0 39 08 01 00 11 1F A1 00 71 E0 01 00 54 E0 43 01 91 ?? ?? ?? ?? E0 4B 00 39 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 33 00 B9 03 00 00 14 E8 00 80 52 E8 33 00 B9 E0 33 40 B9 60 00 00 14 E0 17 40 F9 ?? ?? ?? ?? E0 4F 00 39 E9 13 40 F9 E8 4F C0 39 28 01 00 39 E1 17 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 53 00 39 E8 53 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E8 13 40 F9 01 01 C0 39 E0 17 40 F9 ?? ?? ?? ?? A0 00 80 52 4C 00 00 14 E1 17 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 57 00 39 E8 57 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E8 13 40 F9 01 01 C0 39 E0 17 40 F9 ?? ?? ?? ?? C0 00 80 52 3E 00 00 14 E8 13 40 F9 08 01 C0 39 08 01 00 11 1F A5 00 71 A0 04 00 54 E8 13 40 F9 08 01 C0 39 08 01 00 11 1F 01 00 71 00 04 00 54 E8 13 40 F9 00 01 C0 39 00 00 00 11 00 00 00 11 ?? ?? ?? ?? E0 5B 00 39 E8 5B 40 39 08 01 00 11 1F 01 00 71 E1 01 00 54 E0 43 01 91 ?? ?? ?? ?? E0 5F 00 39 E8 5F 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 37 00 B9 03 00 00 14 E8 00 80 52 E8 37 00 B9 E0 37 40 B9 1C 00 00 14 E0 17 40 F9 ?? ?? ?? ?? E0 63 00 39 E9 13 40 F9 E8 63 C0 39 28 01 00 39 D8 FF FF 17 E8 13 40 F9 08 01 C0 39 08 01 00 11 1F A5 00 71 E0 01 00 54 E0 43 01 91 ?? ?? ?? ?? E0 67 00 39 E8 67 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 3B 00 B9 03 00 00 14 E8 00 80 52 E8 3B 00 B9 E0 3B 40 B9 02 00 00 14 80 00 80 52 FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_62_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
		size = 632
		refs = "0024 ??0<lambda_bdd123a27a08a14f93fbf44b617d0736>@@QEAA@AEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@AEADAEA_K@Z 0034 ?lowercase@?1???$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 003c ?uppercase@?1???$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0044 ??$parse_next_characters_from_source@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z 0060 ??R<lambda_bdd123a27a08a14f93fbf44b617d0736>@@QEBA_NXZ 0078 ?unget@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAAXD@Z 0080 ?save_state@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEBA_KXZ 0094 ?get@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAADXZ 0114 ??$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z 014c ??$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z 01b4 ?is_digit_or_nondigit@__crt_strtox@@YA_NH@Z"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 13 00 F9 E1 17 00 F9 E2 23 00 F9 E3 03 01 91 E2 13 40 F9 E1 17 40 F9 E0 43 01 91 ?? ?? ?? ?? E4 17 40 F9 E3 13 40 F9 62 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E0 43 01 91 ?? ?? ?? ?? E0 00 80 52 82 00 00 14 E8 13 40 F9 01 01 C0 39 E0 17 40 F9 ?? ?? ?? ?? E0 17 40 F9 ?? ?? ?? ?? E0 27 00 F9 E8 27 40 F9 E8 23 00 F9 E0 17 40 F9 ?? ?? ?? ?? E0 47 00 39 E9 13 40 F9 E8 47 C0 39 28 01 00 39 E8 13 40 F9 08 01 C0 39 08 01 00 11 1F A1 00 71 E0 01 00 54 E0 43 01 91 ?? ?? ?? ?? E0 4B 00 39 E8 4B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 33 00 B9 03 00 00 14 E8 00 80 52 E8 33 00 B9 E0 33 40 B9 60 00 00 14 E0 17 40 F9 ?? ?? ?? ?? E0 4F 00 39 E9 13 40 F9 E8 4F C0 39 28 01 00 39 E1 17 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 53 00 39 E8 53 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E8 13 40 F9 01 01 C0 39 E0 17 40 F9 ?? ?? ?? ?? A0 00 80 52 4C 00 00 14 E1 17 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 57 00 39 E8 57 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E8 13 40 F9 01 01 C0 39 E0 17 40 F9 ?? ?? ?? ?? C0 00 80 52 3E 00 00 14 E8 13 40 F9 08 01 C0 39 08 01 00 11 1F A5 00 71 A0 04 00 54 E8 13 40 F9 08 01 C0 39 08 01 00 11 1F 01 00 71 00 04 00 54 E8 13 40 F9 00 01 C0 39 00 00 00 11 00 00 00 11 ?? ?? ?? ?? E0 5B 00 39 E8 5B 40 39 08 01 00 11 1F 01 00 71 E1 01 00 54 E0 43 01 91 ?? ?? ?? ?? E0 5F 00 39 E8 5F 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 37 00 B9 03 00 00 14 E8 00 80 52 E8 37 00 B9 E0 37 40 B9 1C 00 00 14 E0 17 40 F9 ?? ?? ?? ?? E0 63 00 39 E9 13 40 F9 E8 63 C0 39 28 01 00 39 D8 FF FF 17 E8 13 40 F9 08 01 C0 39 08 01 00 11 1F A5 00 71 E0 01 00 54 E0 43 01 91 ?? ?? ?? ?? E0 67 00 39 E8 67 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 3B 00 B9 03 00 00 14 E8 00 80 52 E8 3B 00 B9 E0 3B 40 B9 02 00 00 14 80 00 80 52 FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_31_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$c_string_character_source@_W@0@PEB_W@Z"
		size = 632
		refs = "0024 ??0<lambda_c728f12739a3597330a783bb0930d4cc>@@QEAA@AEAV?$c_string_character_source@_W@__crt_strtox@@AEA_WAEAPEB_W@Z 0034 ?lowercase@?1???$parse_floating_point_possible_nan@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$c_string_character_source@_W@1@PEB_W@Z@4QB_WB 003c ?uppercase@?1???$parse_floating_point_possible_nan@_WV?$c_string_character_source@_W@__crt_strtox@@PEB_W@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$c_string_character_source@_W@1@PEB_W@Z@4QB_WB 0044 ??$parse_next_characters_from_source@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NQEB_W0_KAEA_WAEAV?$c_string_character_source@_W@0@@Z 0060 ??R<lambda_c728f12739a3597330a783bb0930d4cc>@@QEBA_NXZ 0078 ?unget@?$c_string_character_source@_W@__crt_strtox@@QEAAX_W@Z 0080 ?save_state@?$c_string_character_source@_W@__crt_strtox@@QEBAPEB_WXZ 0094 ?get@?$c_string_character_source@_W@__crt_strtox@@QEAA_WXZ 0114 ??$parse_floating_point_possible_nan_is_snan@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$c_string_character_source@_W@0@@Z 014c ??$parse_floating_point_possible_nan_is_ind@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$c_string_character_source@_W@0@@Z 01b4 ?is_digit_or_nondigit@__crt_strtox@@YA_NH@Z"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 0F 00 F9 E1 13 00 F9 E2 23 00 F9 E3 03 01 91 E2 0F 40 F9 E1 13 40 F9 E0 43 01 91 ?? ?? ?? ?? E4 13 40 F9 E3 0F 40 F9 62 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E0 43 01 91 ?? ?? ?? ?? E0 00 80 52 82 00 00 14 E8 0F 40 F9 01 01 40 79 E0 13 40 F9 ?? ?? ?? ?? E0 13 40 F9 ?? ?? ?? ?? E0 27 00 F9 E8 27 40 F9 E8 23 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 53 00 79 E9 0F 40 F9 E8 53 40 79 28 01 00 79 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F A1 00 71 E0 01 00 54 E0 43 01 91 ?? ?? ?? ?? E0 47 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 33 00 B9 03 00 00 14 E8 00 80 52 E8 33 00 B9 E0 33 40 B9 60 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 57 00 79 E9 0F 40 F9 E8 57 40 79 28 01 00 79 E1 13 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 4B 00 39 E8 4B 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E8 0F 40 F9 01 01 40 79 E0 13 40 F9 ?? ?? ?? ?? A0 00 80 52 4C 00 00 14 E1 13 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 4F 00 39 E8 4F 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E8 0F 40 F9 01 01 40 79 E0 13 40 F9 ?? ?? ?? ?? C0 00 80 52 3E 00 00 14 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F A5 00 71 A0 04 00 54 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F 01 00 71 00 04 00 54 E8 0F 40 F9 00 01 40 79 00 00 00 11 00 00 00 11 ?? ?? ?? ?? E0 53 00 39 E8 53 40 39 08 01 00 11 1F 01 00 71 E1 01 00 54 E0 43 01 91 ?? ?? ?? ?? E0 57 00 39 E8 57 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 37 00 B9 03 00 00 14 E8 00 80 52 E8 37 00 B9 E0 37 40 B9 1C 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 5B 00 79 E9 0F 40 F9 E8 5B 40 79 28 01 00 79 D8 FF FF 17 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F A5 00 71 E0 01 00 54 E0 43 01 91 ?? ?? ?? ?? E0 5B 00 39 E8 5B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 3B 00 B9 03 00 00 14 E8 00 80 52 E8 3B 00 B9 E0 3B 40 B9 02 00 00 14 80 00 80 52 FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_63_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
		size = 632
		refs = "0024 ??0<lambda_6c6d19daa7c7d45df7f17119b7c25976>@@QEAA@AEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@AEA_WAEA_K@Z 0034 ?lowercase@?1???$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 003c ?uppercase@?1???$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0044 ??$parse_next_characters_from_source@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEB_W0_KAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z 0060 ??R<lambda_6c6d19daa7c7d45df7f17119b7c25976>@@QEBA_NXZ 0078 ?unget@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAAX_W@Z 0080 ?save_state@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEBA_KXZ 0094 ?get@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA_WXZ 0114 ??$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z 014c ??$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z 01b4 ?is_digit_or_nondigit@__crt_strtox@@YA_NH@Z"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 0F 00 F9 E1 13 00 F9 E2 23 00 F9 E3 03 01 91 E2 0F 40 F9 E1 13 40 F9 E0 43 01 91 ?? ?? ?? ?? E4 13 40 F9 E3 0F 40 F9 62 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E0 43 01 91 ?? ?? ?? ?? E0 00 80 52 82 00 00 14 E8 0F 40 F9 01 01 40 79 E0 13 40 F9 ?? ?? ?? ?? E0 13 40 F9 ?? ?? ?? ?? E0 27 00 F9 E8 27 40 F9 E8 23 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 53 00 79 E9 0F 40 F9 E8 53 40 79 28 01 00 79 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F A1 00 71 E0 01 00 54 E0 43 01 91 ?? ?? ?? ?? E0 47 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 33 00 B9 03 00 00 14 E8 00 80 52 E8 33 00 B9 E0 33 40 B9 60 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 57 00 79 E9 0F 40 F9 E8 57 40 79 28 01 00 79 E1 13 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 4B 00 39 E8 4B 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E8 0F 40 F9 01 01 40 79 E0 13 40 F9 ?? ?? ?? ?? A0 00 80 52 4C 00 00 14 E1 13 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 4F 00 39 E8 4F 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E8 0F 40 F9 01 01 40 79 E0 13 40 F9 ?? ?? ?? ?? C0 00 80 52 3E 00 00 14 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F A5 00 71 A0 04 00 54 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F 01 00 71 00 04 00 54 E8 0F 40 F9 00 01 40 79 00 00 00 11 00 00 00 11 ?? ?? ?? ?? E0 53 00 39 E8 53 40 39 08 01 00 11 1F 01 00 71 E1 01 00 54 E0 43 01 91 ?? ?? ?? ?? E0 57 00 39 E8 57 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 37 00 B9 03 00 00 14 E8 00 80 52 E8 37 00 B9 E0 37 40 B9 1C 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 5B 00 79 E9 0F 40 F9 E8 5B 40 79 28 01 00 79 D8 FF FF 17 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F A5 00 71 E0 01 00 54 E0 43 01 91 ?? ?? ?? ?? E0 5B 00 39 E8 5B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 3B 00 B9 03 00 00 14 E8 00 80 52 E8 3B 00 B9 E0 3B 40 B9 02 00 00 14 80 00 80 52 FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_64_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
		size = 632
		refs = "0024 ??0<lambda_a9f975f7e8316be0241b8392d74a98d8>@@QEAA@AEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@AEA_WAEA_K@Z 0034 ?lowercase@?1???$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 003c ?uppercase@?1???$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0044 ??$parse_next_characters_from_source@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEB_W0_KAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z 0060 ??R<lambda_a9f975f7e8316be0241b8392d74a98d8>@@QEBA_NXZ 0078 ?unget@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAAX_W@Z 0080 ?save_state@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEBA_KXZ 0094 ?get@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA_WXZ 0114 ??$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z 014c ??$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z 01b4 ?is_digit_or_nondigit@__crt_strtox@@YA_NH@Z"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 0F 00 F9 E1 13 00 F9 E2 23 00 F9 E3 03 01 91 E2 0F 40 F9 E1 13 40 F9 E0 43 01 91 ?? ?? ?? ?? E4 13 40 F9 E3 0F 40 F9 62 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E0 43 01 91 ?? ?? ?? ?? E0 00 80 52 82 00 00 14 E8 0F 40 F9 01 01 40 79 E0 13 40 F9 ?? ?? ?? ?? E0 13 40 F9 ?? ?? ?? ?? E0 27 00 F9 E8 27 40 F9 E8 23 00 F9 E0 13 40 F9 ?? ?? ?? ?? E0 53 00 79 E9 0F 40 F9 E8 53 40 79 28 01 00 79 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F A1 00 71 E0 01 00 54 E0 43 01 91 ?? ?? ?? ?? E0 47 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 33 00 B9 03 00 00 14 E8 00 80 52 E8 33 00 B9 E0 33 40 B9 60 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 57 00 79 E9 0F 40 F9 E8 57 40 79 28 01 00 79 E1 13 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 4B 00 39 E8 4B 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E8 0F 40 F9 01 01 40 79 E0 13 40 F9 ?? ?? ?? ?? A0 00 80 52 4C 00 00 14 E1 13 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 4F 00 39 E8 4F 40 39 08 01 00 11 1F 01 00 71 E0 00 00 54 E8 0F 40 F9 01 01 40 79 E0 13 40 F9 ?? ?? ?? ?? C0 00 80 52 3E 00 00 14 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F A5 00 71 A0 04 00 54 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F 01 00 71 00 04 00 54 E8 0F 40 F9 00 01 40 79 00 00 00 11 00 00 00 11 ?? ?? ?? ?? E0 53 00 39 E8 53 40 39 08 01 00 11 1F 01 00 71 E1 01 00 54 E0 43 01 91 ?? ?? ?? ?? E0 57 00 39 E8 57 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 37 00 B9 03 00 00 14 E8 00 80 52 E8 37 00 B9 E0 37 40 B9 1C 00 00 14 E0 13 40 F9 ?? ?? ?? ?? E0 5B 00 79 E9 0F 40 F9 E8 5B 40 79 28 01 00 79 D8 FF FF 17 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F A5 00 71 E0 01 00 54 E0 43 01 91 ?? ?? ?? ?? E0 5B 00 39 E8 5B 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 88 00 80 52 E8 3B 00 B9 03 00 00 14 E8 00 80 52 E8 3B 00 B9 E0 3B 40 B9 02 00 00 14 80 00 80 52 FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_32_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@0@@Z"
		size = 64
		refs = "001c ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@1@@Z@4QBDB 0024 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@1@@Z@4QBDB 002c ??$parse_next_characters_from_source@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$c_string_character_source@D@0@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E4 0F 40 F9 E3 13 40 F9 82 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E0 43 40 39 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_65_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "001c ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0024 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 002c ??$parse_next_characters_from_source@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E4 0F 40 F9 E3 13 40 F9 82 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E0 43 40 39 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_66_4 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "001c ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0024 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 002c ??$parse_next_characters_from_source@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E4 0F 40 F9 E3 13 40 F9 82 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E0 43 40 39 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_237_32_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$c_string_character_source@_W@0@@Z"
		size = 64
		refs = "001c ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$c_string_character_source@_W@1@@Z@4QB_WB 0024 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$c_string_character_source@_W@1@@Z@4QB_WB 002c ??$parse_next_characters_from_source@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NQEB_W0_KAEA_WAEAV?$c_string_character_source@_W@0@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E4 0F 40 F9 E3 13 40 F9 82 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E0 43 40 39 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_67_2 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "001c ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 0024 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 002c ??$parse_next_characters_from_source@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEB_W0_KAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E4 0F 40 F9 E3 13 40 F9 82 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E0 43 40 39 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_68_2 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "001c ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 0024 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 002c ??$parse_next_characters_from_source@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEB_W0_KAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E4 0F 40 F9 E3 13 40 F9 82 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E0 43 40 39 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_34_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@0@@Z"
		size = 64
		refs = "001c ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@1@@Z@4QBDB 0024 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@1@@Z@4QBDB 002c ??$parse_next_characters_from_source@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$c_string_character_source@D@0@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E4 0F 40 F9 E3 13 40 F9 A2 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E0 43 40 39 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_69_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "001c ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0024 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 002c ??$parse_next_characters_from_source@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E4 0F 40 F9 E3 13 40 F9 A2 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E0 43 40 39 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_70_4 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "001c ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0024 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 002c ??$parse_next_characters_from_source@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E4 0F 40 F9 E3 13 40 F9 A2 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E0 43 40 39 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_237_34_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$c_string_character_source@_W@0@@Z"
		size = 64
		refs = "001c ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$c_string_character_source@_W@1@@Z@4QB_WB 0024 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$c_string_character_source@_W@1@@Z@4QB_WB 002c ??$parse_next_characters_from_source@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NQEB_W0_KAEA_WAEAV?$c_string_character_source@_W@0@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E4 0F 40 F9 E3 13 40 F9 A2 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E0 43 40 39 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_71_2 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "001c ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 0024 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 002c ??$parse_next_characters_from_source@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEB_W0_KAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E4 0F 40 F9 E3 13 40 F9 A2 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E0 43 40 39 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_72_2 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "001c ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 0024 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 002c ??$parse_next_characters_from_source@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEB_W0_KAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E4 0F 40 F9 E3 13 40 F9 A2 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 43 00 39 E0 43 40 39 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_36_0 {
	meta:
		name = "??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAM@Z"
		size = 412
		refs = "0050 ??$convert_decimal_string_to_floating_type@M@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@0@AEAM@Z 0068 ??$convert_hexadecimal_string_to_floating_type@M@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@0@AEAM@Z 0088 ??$assemble_floating_point_zero@M@__crt_strtox@@YAX_NAEAM@Z 00a4 ??$assemble_floating_point_infinity@M@__crt_strtox@@YAX_NAEAM@Z 00c0 ??$assemble_floating_point_qnan@M@__crt_strtox@@YAX_NAEAM@Z 00dc ??$assemble_floating_point_snan@M@__crt_strtox@@YAX_NAEAM@Z 00ec ??$assemble_floating_point_ind@M@__crt_strtox@@YAXAEAM@Z 0150 ??_C@_1M@HLGKFCJM@?$AAf?$AAa?$AAl?$AAs?$AAe?$AA?$AA@ 0158 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0168 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0174 _CrtDbgReportW"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 17 00 B9 E1 1B 00 F9 E2 17 00 F9 E8 17 40 B9 E8 13 00 B9 E8 13 40 B9 1F 25 00 71 08 09 00 54 EA 13 40 B9 89 00 00 10 28 49 AA 38 28 09 08 8B 00 01 1F D6 03 09 0F 16 1D 24 2B 2F 34 3B 3B 3B E1 17 40 F9 E0 1B 40 F9 ?? ?? ?? ?? E0 1B 00 B9 E0 1B 40 B9 4E 00 00 14 E1 17 40 F9 E0 1B 40 F9 ?? ?? ?? ?? E0 1F 00 B9 E0 1F 40 B9 48 00 00 14 E8 1B 40 F9 08 21 0C 91 E1 17 40 F9 00 01 40 39 ?? ?? ?? ?? 00 00 80 52 41 00 00 14 E8 1B 40 F9 08 21 0C 91 E1 17 40 F9 00 01 40 39 ?? ?? ?? ?? 00 00 80 52 3A 00 00 14 E8 1B 40 F9 08 21 0C 91 E1 17 40 F9 00 01 40 39 ?? ?? ?? ?? 00 00 80 52 33 00 00 14 E8 1B 40 F9 08 21 0C 91 E1 17 40 F9 00 01 40 39 ?? ?? ?? ?? 00 00 80 52 2C 00 00 14 E0 17 40 F9 ?? ?? ?? ?? 00 00 80 52 28 00 00 14 E1 17 40 F9 00 00 80 52 ?? ?? ?? ?? 20 00 80 52 23 00 00 14 E8 1B 40 F9 08 21 0C 91 E1 17 40 F9 00 01 40 39 ?? ?? ?? ?? 40 00 80 52 1C 00 00 14 E8 1B 40 F9 08 21 0C 91 E1 17 40 F9 00 01 40 39 ?? ?? ?? ?? 60 00 80 52 15 00 00 14 08 00 80 52 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 02 D3 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 20 00 80 52 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_37_0 {
	meta:
		name = "??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAN@Z"
		size = 412
		refs = "0050 ??$convert_decimal_string_to_floating_type@N@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@0@AEAN@Z 0068 ??$convert_hexadecimal_string_to_floating_type@N@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@0@AEAN@Z 0088 ??$assemble_floating_point_zero@N@__crt_strtox@@YAX_NAEAN@Z 00a4 ??$assemble_floating_point_infinity@N@__crt_strtox@@YAX_NAEAN@Z 00c0 ??$assemble_floating_point_qnan@N@__crt_strtox@@YAX_NAEAN@Z 00dc ??$assemble_floating_point_snan@N@__crt_strtox@@YAX_NAEAN@Z 00ec ??$assemble_floating_point_ind@N@__crt_strtox@@YAXAEAN@Z 0150 ??_C@_1M@HLGKFCJM@?$AAf?$AAa?$AAl?$AAs?$AAe?$AA?$AA@ 0158 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0168 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0174 _CrtDbgReportW"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 17 00 B9 E1 1B 00 F9 E2 17 00 F9 E8 17 40 B9 E8 13 00 B9 E8 13 40 B9 1F 25 00 71 08 09 00 54 EA 13 40 B9 89 00 00 10 28 49 AA 38 28 09 08 8B 00 01 1F D6 03 09 0F 16 1D 24 2B 2F 34 3B 3B 3B E1 17 40 F9 E0 1B 40 F9 ?? ?? ?? ?? E0 1B 00 B9 E0 1B 40 B9 4E 00 00 14 E1 17 40 F9 E0 1B 40 F9 ?? ?? ?? ?? E0 1F 00 B9 E0 1F 40 B9 48 00 00 14 E8 1B 40 F9 08 21 0C 91 E1 17 40 F9 00 01 40 39 ?? ?? ?? ?? 00 00 80 52 41 00 00 14 E8 1B 40 F9 08 21 0C 91 E1 17 40 F9 00 01 40 39 ?? ?? ?? ?? 00 00 80 52 3A 00 00 14 E8 1B 40 F9 08 21 0C 91 E1 17 40 F9 00 01 40 39 ?? ?? ?? ?? 00 00 80 52 33 00 00 14 E8 1B 40 F9 08 21 0C 91 E1 17 40 F9 00 01 40 39 ?? ?? ?? ?? 00 00 80 52 2C 00 00 14 E0 17 40 F9 ?? ?? ?? ?? 00 00 80 52 28 00 00 14 E1 17 40 F9 00 00 80 52 ?? ?? ?? ?? 20 00 80 52 23 00 00 14 E8 1B 40 F9 08 21 0C 91 E1 17 40 F9 00 01 40 39 ?? ?? ?? ?? 40 00 80 52 1C 00 00 14 E8 1B 40 F9 08 21 0C 91 E1 17 40 F9 00 01 40 39 ?? ?? ?? ?? 60 00 80 52 15 00 00 14 08 00 80 52 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 02 D3 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 20 00 80 52 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_171_11_0 {
	meta:
		name = "??$parse_floating_point_write_result@U_LDBL12@@@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAU_LDBL12@@@Z"
		size = 412
		refs = "0050 ?convert_decimal_string_to_floating_type@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@AEAU_LDBL12@@@Z 0068 ?convert_hexadecimal_string_to_floating_type@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@AEAU_LDBL12@@@Z 0088 ?assemble_floating_point_zero@__crt_strtox@@YAX_NAEAU_LDBL12@@@Z 00a4 ?assemble_floating_point_infinity@__crt_strtox@@YAX_NAEAU_LDBL12@@@Z 00c0 ?assemble_floating_point_qnan@__crt_strtox@@YAX_NAEAU_LDBL12@@@Z 00dc ?assemble_floating_point_snan@__crt_strtox@@YAX_NAEAU_LDBL12@@@Z 00ec ?assemble_floating_point_ind@__crt_strtox@@YAXAEAU_LDBL12@@@Z 0150 ??_C@_1M@HLGKFCJM@?$AAf?$AAa?$AAl?$AAs?$AAe?$AA?$AA@ 0158 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0168 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0174 _CrtDbgReportW"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 17 00 B9 E1 1B 00 F9 E2 17 00 F9 E8 17 40 B9 E8 13 00 B9 E8 13 40 B9 1F 25 00 71 08 09 00 54 EA 13 40 B9 89 00 00 10 28 49 AA 38 28 09 08 8B 00 01 1F D6 03 09 0F 16 1D 24 2B 2F 34 3B 3B 3B E1 17 40 F9 E0 1B 40 F9 ?? ?? ?? ?? E0 1B 00 B9 E0 1B 40 B9 4E 00 00 14 E1 17 40 F9 E0 1B 40 F9 ?? ?? ?? ?? E0 1F 00 B9 E0 1F 40 B9 48 00 00 14 E8 1B 40 F9 08 21 0C 91 E1 17 40 F9 00 01 40 39 ?? ?? ?? ?? 00 00 80 52 41 00 00 14 E8 1B 40 F9 08 21 0C 91 E1 17 40 F9 00 01 40 39 ?? ?? ?? ?? 00 00 80 52 3A 00 00 14 E8 1B 40 F9 08 21 0C 91 E1 17 40 F9 00 01 40 39 ?? ?? ?? ?? 00 00 80 52 33 00 00 14 E8 1B 40 F9 08 21 0C 91 E1 17 40 F9 00 01 40 39 ?? ?? ?? ?? 00 00 80 52 2C 00 00 14 E0 17 40 F9 ?? ?? ?? ?? 00 00 80 52 28 00 00 14 E1 17 40 F9 00 00 80 52 ?? ?? ?? ?? 20 00 80 52 23 00 00 14 E8 1B 40 F9 08 21 0C 91 E1 17 40 F9 00 01 40 39 ?? ?? ?? ?? 40 00 80 52 1C 00 00 14 E8 1B 40 F9 08 21 0C 91 E1 17 40 F9 00 01 40 39 ?? ?? ?? ?? 60 00 80 52 15 00 00 14 08 00 80 52 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 02 D3 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E9 23 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 20 00 80 52 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_38_0 {
	meta:
		name = "??$parse_next_characters_from_source@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$c_string_character_source@D@0@@Z"
		size = 212
		refs = "00b0 ?get@?$c_string_character_source@D@__crt_strtox@@QEAADXZ"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 E0 1B 00 F9 E1 1F 00 F9 E2 17 00 F9 E3 13 00 F9 E4 23 00 F9 08 00 80 D2 E8 0F 00 F9 04 00 00 14 E8 0F 40 F9 08 05 00 91 E8 0F 00 F9 E9 17 40 F9 E8 0F 40 F9 1F 01 09 EB 40 04 00 54 E8 13 40 F9 0A 01 C0 39 4A 01 00 11 E9 0F 40 F9 28 00 80 D2 29 7D 08 9B E8 1B 40 F9 08 01 09 8B 08 01 C0 39 08 01 00 11 5F 01 08 6B E0 01 00 54 E8 13 40 F9 0A 01 C0 39 4A 01 00 11 E9 0F 40 F9 28 00 80 D2 29 7D 08 9B E8 1F 40 F9 08 01 09 8B 08 01 C0 39 08 01 00 11 5F 01 08 6B 60 00 00 54 00 00 80 52 09 00 00 14 E0 23 40 F9 ?? ?? ?? ?? E0 43 00 39 E9 13 40 F9 E8 43 C0 39 28 01 00 39 D9 FF FF 17 20 00 80 52 FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_79_0 {
	meta:
		name = "??$parse_next_characters_from_source@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 212
		refs = "00b0 ?get@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAADXZ"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 E0 1B 00 F9 E1 1F 00 F9 E2 17 00 F9 E3 13 00 F9 E4 23 00 F9 08 00 80 D2 E8 0F 00 F9 04 00 00 14 E8 0F 40 F9 08 05 00 91 E8 0F 00 F9 E9 17 40 F9 E8 0F 40 F9 1F 01 09 EB 40 04 00 54 E8 13 40 F9 0A 01 C0 39 4A 01 00 11 E9 0F 40 F9 28 00 80 D2 29 7D 08 9B E8 1B 40 F9 08 01 09 8B 08 01 C0 39 08 01 00 11 5F 01 08 6B E0 01 00 54 E8 13 40 F9 0A 01 C0 39 4A 01 00 11 E9 0F 40 F9 28 00 80 D2 29 7D 08 9B E8 1F 40 F9 08 01 09 8B 08 01 C0 39 08 01 00 11 5F 01 08 6B 60 00 00 54 00 00 80 52 09 00 00 14 E0 23 40 F9 ?? ?? ?? ?? E0 43 00 39 E9 13 40 F9 E8 43 C0 39 28 01 00 39 D9 FF FF 17 20 00 80 52 FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_80_0 {
	meta:
		name = "??$parse_next_characters_from_source@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 212
		refs = "00b0 ?get@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QEAADXZ"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 E0 1B 00 F9 E1 1F 00 F9 E2 17 00 F9 E3 13 00 F9 E4 23 00 F9 08 00 80 D2 E8 0F 00 F9 04 00 00 14 E8 0F 40 F9 08 05 00 91 E8 0F 00 F9 E9 17 40 F9 E8 0F 40 F9 1F 01 09 EB 40 04 00 54 E8 13 40 F9 0A 01 C0 39 4A 01 00 11 E9 0F 40 F9 28 00 80 D2 29 7D 08 9B E8 1B 40 F9 08 01 09 8B 08 01 C0 39 08 01 00 11 5F 01 08 6B E0 01 00 54 E8 13 40 F9 0A 01 C0 39 4A 01 00 11 E9 0F 40 F9 28 00 80 D2 29 7D 08 9B E8 1F 40 F9 08 01 09 8B 08 01 C0 39 08 01 00 11 5F 01 08 6B 60 00 00 54 00 00 80 52 09 00 00 14 E0 23 40 F9 ?? ?? ?? ?? E0 43 00 39 E9 13 40 F9 E8 43 C0 39 28 01 00 39 D9 FF FF 17 20 00 80 52 FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_39_0 {
	meta:
		name = "??$parse_next_characters_from_source@_WV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_NQEB_W0_KAEA_WAEAV?$c_string_character_source@_W@0@@Z"
		size = 212
		refs = "00b0 ?get@?$c_string_character_source@_W@__crt_strtox@@QEAA_WXZ"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 E0 1B 00 F9 E1 1F 00 F9 E2 17 00 F9 E3 13 00 F9 E4 23 00 F9 08 00 80 D2 E8 0F 00 F9 04 00 00 14 E8 0F 40 F9 08 05 00 91 E8 0F 00 F9 E9 17 40 F9 E8 0F 40 F9 1F 01 09 EB 40 04 00 54 E8 13 40 F9 0A 01 40 79 4A 01 00 11 E9 0F 40 F9 48 00 80 D2 29 7D 08 9B E8 1B 40 F9 08 01 09 8B 08 01 40 79 08 01 00 11 5F 01 08 6B E0 01 00 54 E8 13 40 F9 0A 01 40 79 4A 01 00 11 E9 0F 40 F9 48 00 80 D2 29 7D 08 9B E8 1F 40 F9 08 01 09 8B 08 01 40 79 08 01 00 11 5F 01 08 6B 60 00 00 54 00 00 80 52 09 00 00 14 E0 23 40 F9 ?? ?? ?? ?? E0 23 00 79 E9 13 40 F9 E8 23 40 79 28 01 00 79 D9 FF FF 17 20 00 80 52 FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_81_0 {
	meta:
		name = "??$parse_next_characters_from_source@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEB_W0_KAEA_WAEAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 212
		refs = "00b0 ?get@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA_WXZ"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 E0 1B 00 F9 E1 1F 00 F9 E2 17 00 F9 E3 13 00 F9 E4 23 00 F9 08 00 80 D2 E8 0F 00 F9 04 00 00 14 E8 0F 40 F9 08 05 00 91 E8 0F 00 F9 E9 17 40 F9 E8 0F 40 F9 1F 01 09 EB 40 04 00 54 E8 13 40 F9 0A 01 40 79 4A 01 00 11 E9 0F 40 F9 48 00 80 D2 29 7D 08 9B E8 1B 40 F9 08 01 09 8B 08 01 40 79 08 01 00 11 5F 01 08 6B E0 01 00 54 E8 13 40 F9 0A 01 40 79 4A 01 00 11 E9 0F 40 F9 48 00 80 D2 29 7D 08 9B E8 1F 40 F9 08 01 09 8B 08 01 40 79 08 01 00 11 5F 01 08 6B 60 00 00 54 00 00 80 52 09 00 00 14 E0 23 40 F9 ?? ?? ?? ?? E0 23 00 79 E9 13 40 F9 E8 23 40 79 28 01 00 79 D9 FF FF 17 20 00 80 52 FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_82_0 {
	meta:
		name = "??$parse_next_characters_from_source@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQEB_W0_KAEA_WAEAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 212
		refs = "00b0 ?get@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QEAA_WXZ"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 E0 1B 00 F9 E1 1F 00 F9 E2 17 00 F9 E3 13 00 F9 E4 23 00 F9 08 00 80 D2 E8 0F 00 F9 04 00 00 14 E8 0F 40 F9 08 05 00 91 E8 0F 00 F9 E9 17 40 F9 E8 0F 40 F9 1F 01 09 EB 40 04 00 54 E8 13 40 F9 0A 01 40 79 4A 01 00 11 E9 0F 40 F9 48 00 80 D2 29 7D 08 9B E8 1B 40 F9 08 01 09 8B 08 01 40 79 08 01 00 11 5F 01 08 6B E0 01 00 54 E8 13 40 F9 0A 01 40 79 4A 01 00 11 E9 0F 40 F9 48 00 80 D2 29 7D 08 9B E8 1F 40 F9 08 01 09 8B 08 01 40 79 08 01 00 11 5F 01 08 6B 60 00 00 54 00 00 80 52 09 00 00 14 E0 23 40 F9 ?? ?? ?? ?? E0 23 00 79 E9 13 40 F9 E8 23 40 79 28 01 00 79 D9 FF FF 17 20 00 80 52 FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_46_0 {
	meta:
		name = "??0?$c_string_character_source@D@__crt_strtox@@QEAA@QEBDQEAPEBD@Z"
		size = 84
		altNames = "??0?$c_string_character_source@_W@__crt_strtox@@QEAA@QEB_WQEAPEB_W@Z"
	strings:
		$1 = { FF 83 00 D1 E0 07 00 F9 E1 0B 00 F9 E2 03 00 F9 E8 07 40 F9 09 01 00 91 E8 0B 40 F9 28 01 00 F9 E8 07 40 F9 09 21 00 91 E8 03 40 F9 28 01 00 F9 E8 03 40 F9 1F 01 00 F1 80 00 00 54 E9 03 40 F9 E8 0B 40 F9 28 01 00 F9 E0 07 40 F9 FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_49_0 {
	meta:
		name = "??0big_integer@__crt_strtox@@QEAA@AEBU01@@Z"
		size = 112
		refs = "0060 memcpy_s"
		altNames = "??4big_integer@__crt_strtox@@QEAAAEAU01@AEBU01@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E1 0B 00 F9 E8 0B 40 F9 0A 01 00 91 E8 0F 40 F9 09 01 00 91 48 01 40 B9 28 01 00 B9 E8 0B 40 F9 08 01 00 91 08 01 40 B9 09 7D 40 D3 88 00 80 D2 23 7D 08 9B E8 0B 40 F9 02 11 00 91 E8 0F 40 F9 00 11 00 91 63 00 00 91 42 00 00 91 81 39 80 D2 00 00 00 91 ?? ?? ?? ?? E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_50_0 {
	meta:
		name = "??0big_integer@__crt_strtox@@QEAA@XZ"
		size = 64
		refs = "0030 memset"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E8 0B 40 F9 09 01 00 91 08 00 80 52 28 01 00 B9 E8 0B 40 F9 00 11 00 91 82 39 80 D2 81 19 80 52 00 00 00 91 ?? ?? ?? ?? E0 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_51_0 {
	meta:
		name = "??0floating_point_value@__crt_strtox@@QEAA@QEAM@Z"
		size = 136
		refs = "003c ??_C@_1CC@MOAOAFND@?$AAv?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0044 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0054 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0060 _CrtDbgReportW"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 13 00 F9 E8 0F 40 F9 09 01 00 91 E8 13 40 F9 28 01 00 F9 E8 0F 40 F9 09 21 00 91 08 00 80 52 28 01 00 39 E8 13 40 F9 1F 01 00 F1 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 32 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 13 00 B9 E9 13 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E0 0F 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_52_0 {
	meta:
		name = "??0floating_point_value@__crt_strtox@@QEAA@QEAN@Z"
		size = 136
		refs = "003c ??_C@_1CC@MOAOAFND@?$AAv?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0044 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0054 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0060 _CrtDbgReportW"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 13 00 F9 E8 0F 40 F9 09 01 00 91 E8 13 40 F9 28 01 00 F9 E8 0F 40 F9 09 21 00 91 28 00 80 52 28 01 00 39 E8 13 40 F9 1F 01 00 F1 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 31 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 13 00 B9 E9 13 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E0 0F 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_53_0 {
	meta:
		name = "??1?$c_string_character_source@D@__crt_strtox@@QEAA@XZ"
		size = 64
		altNames = "??1?$c_string_character_source@_W@__crt_strtox@@QEAA@XZ"
	strings:
		$1 = { FF 43 00 D1 E0 03 00 F9 E8 03 40 F9 08 21 00 91 08 01 40 F9 1F 01 00 F1 00 01 00 54 E8 03 40 F9 0A 01 00 91 E8 03 40 F9 08 21 00 91 09 01 40 F9 48 01 40 F9 28 01 00 F9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_57_0 {
	meta:
		name = "??M__crt_strtox@@YA_NAEBUbig_integer@0@0@Z"
		size = 328
	strings:
		$1 = { FF 83 00 D1 E0 07 00 F9 E1 0B 00 F9 E8 07 40 F9 0A 01 00 91 E8 0B 40 F9 08 01 00 91 09 01 40 B9 48 01 40 B9 1F 01 09 6B 69 00 00 54 00 00 80 52 44 00 00 14 E8 07 40 F9 0A 01 00 91 E8 0B 40 F9 08 01 00 91 09 01 40 B9 48 01 40 B9 1F 01 09 6B 62 00 00 54 20 00 80 52 3A 00 00 14 E8 07 40 F9 08 01 00 91 08 01 40 B9 08 05 00 51 E8 03 00 B9 04 00 00 14 E8 03 40 B9 08 05 00 51 E8 03 00 B9 E8 03 40 B9 1F 05 00 31 80 02 00 54 E8 07 40 F9 0A 11 00 91 E8 03 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 4B 01 08 8B E8 0B 40 F9 0A 11 00 91 E8 03 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 09 01 40 B9 68 01 40 B9 1F 01 09 6B 41 00 00 54 E8 FF FF 17 E8 03 40 B9 1F 05 00 31 61 00 00 54 00 00 80 52 16 00 00 14 E8 07 40 F9 0A 11 00 91 E8 03 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 4B 01 08 8B E8 0B 40 F9 0A 11 00 91 E8 03 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 09 01 40 B9 68 01 40 B9 1F 01 09 6B 68 00 00 54 20 00 80 52 02 00 00 14 00 00 80 52 FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_65_0 {
	meta:
		name = "?accumulate_decimal_digits_into_big_integer@__crt_strtox@@YAXQEBE0AEAUbig_integer@1@@Z"
		size = 236
		refs = "0060 ?multiply@__crt_strtox@@YA_NAEAUbig_integer@1@I@Z 006c ?add@__crt_strtox@@YA_NAEAUbig_integer@1@I@Z 00cc ?multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@1@I@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 17 00 F9 E1 1B 00 F9 E2 13 00 F9 08 00 80 52 E8 13 00 B9 08 00 80 52 E8 17 00 B9 E8 17 40 F9 E8 0F 00 F9 04 00 00 14 E8 0F 40 F9 08 05 00 91 E8 0F 00 F9 E9 1B 40 F9 E8 0F 40 F9 1F 01 09 EB 80 03 00 54 E8 17 40 B9 1F 25 00 71 61 01 00 54 81 04 00 18 E0 13 40 F9 ?? ?? ?? ?? E1 13 40 B9 E0 13 40 F9 ?? ?? ?? ?? 08 00 80 52 E8 13 00 B9 08 00 80 52 E8 17 00 B9 E9 13 40 B9 48 01 80 52 28 7D 08 1B E8 13 00 B9 E8 0F 40 F9 09 01 40 39 29 01 00 11 E8 13 40 B9 08 01 09 0B E8 13 00 B9 E8 17 40 B9 08 05 00 11 E8 17 00 B9 DF FF FF 17 E8 17 40 B9 1F 01 00 71 E0 00 00 54 E1 17 40 B9 E0 13 40 F9 ?? ?? ?? ?? E1 13 40 B9 E0 13 40 F9 ?? ?? ?? ?? FD 7B C4 A8 C0 03 5F D6 1F 20 03 D5 00 CA 9A 3B }
	condition:
		$1
}

rule file_23_66_0 {
	meta:
		name = "?add@__crt_strtox@@YA_NAEAUbig_integer@1@I@Z"
		size = 372
		refs = "0008 __security_push_cookie 0144 ??0big_integer@__crt_strtox@@QEAA@XZ 0154 ??4big_integer@__crt_strtox@@QEAAAEAU01@AEBU01@@Z 0168 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF C3 07 D1 E0 07 00 F9 E1 13 00 B9 E8 13 40 B9 1F 01 00 71 61 00 00 54 20 00 80 52 4F 00 00 14 E8 13 40 B9 E8 07 00 B9 08 00 80 52 E8 03 00 B9 04 00 00 14 E8 03 40 B9 08 05 00 11 E8 03 00 B9 E8 07 40 F9 08 01 00 91 09 01 40 B9 E8 03 40 B9 1F 01 09 6B A0 03 00 54 E8 07 40 F9 0A 11 00 91 E8 03 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 08 01 40 B9 09 7D 40 D3 E8 07 40 B9 08 7D 40 D3 28 01 08 8B E8 0F 00 F9 E8 0F 40 F9 0B 01 00 11 E8 07 40 F9 0A 11 00 91 E8 03 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 0B 01 00 B9 E8 0F 40 F9 08 FD 60 D3 08 01 00 11 E8 07 00 B9 DC FF FF 17 E8 07 40 B9 1F 01 00 71 20 04 00 54 E8 07 40 F9 08 01 00 91 08 01 40 B9 1F CD 01 71 82 02 00 54 E8 07 40 F9 0A 11 00 91 E8 07 40 F9 08 01 00 91 08 01 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 49 01 08 8B E8 07 40 B9 28 01 00 B9 E8 07 40 F9 08 01 00 91 08 01 40 B9 09 05 00 11 E8 07 40 F9 08 01 00 91 09 01 00 B9 09 00 00 14 E0 A3 00 91 ?? ?? ?? ?? E0 13 00 F9 E1 13 40 F9 E0 07 40 F9 ?? ?? ?? ?? 00 00 80 52 02 00 00 14 20 00 80 52 FF C3 07 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_67_0 {
	meta:
		name = "?add_carry@__crt_strtox@@YAIAEAIII@Z"
		size = 96
	strings:
		$1 = { FF 83 00 D1 E0 07 00 F9 E1 03 00 B9 E2 07 00 B9 E8 07 40 F9 08 01 40 B9 09 7D 40 D3 E8 03 40 B9 08 7D 40 D3 29 01 08 8B E8 07 40 B9 08 7D 40 D3 28 01 08 8B E8 0B 00 F9 E8 0B 40 F9 09 01 00 11 E8 07 40 F9 09 01 00 B9 E8 0B 40 F9 08 FD 60 D3 00 01 00 11 00 00 00 11 FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_68_0 {
	meta:
		name = "?add_multiply_carry@__crt_strtox@@YAIAEAIIII@Z"
		size = 100
	strings:
		$1 = { FF 83 00 D1 E0 0B 00 F9 E1 03 00 B9 E2 07 00 B9 E3 0B 00 B9 E8 03 40 B9 09 7D 40 D3 E8 07 40 B9 08 7D 40 D3 29 7D 08 9B E8 0B 40 F9 08 01 40 B9 08 7D 40 D3 29 01 08 8B E8 0B 40 B9 08 7D 40 D3 28 01 08 8B E8 0F 00 F9 E8 0F 40 F9 09 01 00 11 E8 0B 40 F9 09 01 00 B9 E0 1F 40 B9 FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_69_0 {
	meta:
		name = "?as_double@floating_point_value@__crt_strtox@@QEBAAEANXZ"
		size = 180
		refs = "0024 ??_C@_1BK@ICEICMHI@?$AA?$CI?$AA_?$AAi?$AAs?$AA_?$AAd?$AAo?$AAu?$AAb?$AAl?$AAe?$AA?$CJ?$AA?$AA@ 002c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 003c ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0048 _CrtDbgReportW 008c ??_C@_1FM@FELNCOBF@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi?$AAn?$AAt?$AA_?$AAv?$AAa?$AAl@ 0094 ??_C@_1BG@GEMHBGAF@?$AA_?$AAi?$AAs?$AA_?$AAd?$AAo?$AAu?$AAb?$AAl?$AAe?$AA?$AA@ 009c _invoke_watson"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 21 00 91 08 01 40 39 08 01 00 11 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 33 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 13 00 B9 E9 13 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 F9 08 21 00 91 08 01 40 39 08 01 00 11 1F 01 00 71 41 01 00 54 04 00 80 D2 E3 33 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 0F 40 F9 08 01 00 91 00 01 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_70_0 {
	meta:
		name = "?as_float@floating_point_value@__crt_strtox@@QEBAAEAMXZ"
		size = 180
		refs = "0024 ??_C@_1BM@CEPACFMA@?$AA?$CI?$AA?$CB?$AA_?$AAi?$AAs?$AA_?$AAd?$AAo?$AAu?$AAb?$AAl?$AAe?$AA?$CJ?$AA?$AA@ 002c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 003c ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0048 _CrtDbgReportW 008c ??_C@_1FK@JOJELFFO@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi?$AAn?$AAt?$AA_?$AAv?$AAa?$AAl@ 0094 ??_C@_1BI@BANMPGJI@?$AA?$CB?$AA_?$AAi?$AAs?$AA_?$AAd?$AAo?$AAu?$AAb?$AAl?$AAe?$AA?$AA@ 009c _invoke_watson"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 21 00 91 08 01 40 39 08 01 00 11 1F 01 00 71 20 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 34 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 13 00 B9 E9 13 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 F9 08 21 00 91 08 01 40 39 08 01 00 11 1F 01 00 71 40 01 00 54 04 00 80 D2 A3 34 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 0F 40 F9 08 01 00 91 00 01 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_71_0 {
	meta:
		name = "?assemble_floating_point_infinity@__crt_strtox@@YAX_NAEBVfloating_point_value@1@@Z"
		size = 104
		refs = "0014 ?is_double@floating_point_value@__crt_strtox@@QEBA_NXZ 0030 ?as_double@floating_point_value@__crt_strtox@@QEBAAEANXZ 0040 ??$assemble_floating_point_infinity@N@__crt_strtox@@YAX_NAEAN@Z 004c ?as_float@floating_point_value@__crt_strtox@@QEBAAEAMXZ 005c ??$assemble_floating_point_infinity@M@__crt_strtox@@YAX_NAEAM@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 43 00 39 E1 0F 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 47 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 00 01 00 54 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 F9 E1 13 40 F9 E0 43 40 39 ?? ?? ?? ?? 07 00 00 14 E0 0F 40 F9 ?? ?? ?? ?? E0 17 00 F9 E1 17 40 F9 E0 43 40 39 ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_74_0 {
	meta:
		name = "?assemble_floating_point_zero@__crt_strtox@@YAX_NAEBVfloating_point_value@1@@Z"
		size = 104
		refs = "0014 ?is_double@floating_point_value@__crt_strtox@@QEBA_NXZ 0030 ?as_double@floating_point_value@__crt_strtox@@QEBAAEANXZ 0040 ??$assemble_floating_point_zero@N@__crt_strtox@@YAX_NAEAN@Z 004c ?as_float@floating_point_value@__crt_strtox@@QEBAAEAMXZ 005c ??$assemble_floating_point_zero@M@__crt_strtox@@YAX_NAEAM@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 43 00 39 E1 0F 00 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 47 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 00 01 00 54 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 F9 E1 13 40 F9 E0 43 40 39 ?? ?? ?? ?? 07 00 00 14 E0 0F 40 F9 ?? ?? ?? ?? E0 17 00 F9 E1 17 40 F9 E0 43 40 39 ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_72_0 {
	meta:
		name = "?assemble_floating_point_value@__crt_strtox@@YA?AW4SLD_STATUS@@_KH_N1AEBVfloating_point_value@1@@Z"
		size = 768
		refs = "0020 ?bit_scan_reverse@__crt_strtox@@YAI_K@Z 0034 ?mantissa_bits@floating_point_value@__crt_strtox@@QEBAHXZ 0070 ?maximum_binary_exponent@floating_point_value@__crt_strtox@@QEBAHXZ 0090 ?assemble_floating_point_infinity@__crt_strtox@@YAX_NAEBVfloating_point_value@1@@Z 00a4 ?minimum_binary_exponent@floating_point_value@__crt_strtox@@QEBAHXZ 00c0 ?exponent_bias@floating_point_value@__crt_strtox@@QEBAHXZ 0120 ?right_shift_with_rounding@__crt_strtox@@YA_K_N_KI0@Z 0144 ?assemble_floating_point_zero@__crt_strtox@@YAX_NAEBVfloating_point_value@1@@Z 0154 ?denormal_mantissa_mask@floating_point_value@__crt_strtox@@QEBA_KXZ 01dc ?normal_mantissa_mask@floating_point_value@__crt_strtox@@QEBA_KXZ 0280 ?is_double@floating_point_value@__crt_strtox@@QEBA_NXZ 029c ?as_double@floating_point_value@__crt_strtox@@QEBAAEANXZ 02b4 ??$assemble_floating_point_value_t@N@__crt_strtox@@YA?AW4SLD_STATUS@@_NH_KAEAN@Z 02cc ?as_float@floating_point_value@__crt_strtox@@QEBAAEAMXZ 02e4 ??$assemble_floating_point_value_t@M@__crt_strtox@@YA?AW4SLD_STATUS@@_NH_KAEAM@Z"
	strings:
		$1 = { FD 7B B5 A9 FD 03 00 91 E0 3B 00 F9 E1 43 00 B9 E2 43 00 39 E3 47 00 39 E4 1B 00 F9 E0 3B 40 F9 ?? ?? ?? ?? E0 4B 00 B9 E8 4B 40 B9 E8 53 00 B9 E0 1B 40 F9 ?? ?? ?? ?? E0 4F 00 B9 E9 4F 40 B9 E8 53 40 B9 28 01 08 4B E8 27 00 B9 E9 43 40 B9 E8 27 40 B9 28 01 08 4B E8 3B 00 B9 E8 3B 40 F9 E8 0F 00 F9 E8 3B 40 B9 E8 2B 00 B9 E0 1B 40 F9 ?? ?? ?? ?? E0 57 00 B9 E9 57 40 B9 E8 3B 40 B9 1F 01 09 6B ED 00 00 54 E1 1B 40 F9 E0 43 40 39 ?? ?? ?? ?? 60 00 80 52 98 00 00 14 71 00 00 14 E0 1B 40 F9 ?? ?? ?? ?? E0 5B 00 B9 E9 5B 40 B9 E8 3B 40 B9 1F 01 09 6B 6A 07 00 54 E0 1B 40 F9 ?? ?? ?? ?? E0 5F 00 B9 E9 27 40 B9 E8 3B 40 B9 29 01 08 0B E8 5F 40 B9 28 01 08 0B 08 05 00 51 E8 3F 00 B9 E0 1B 40 F9 ?? ?? ?? ?? E0 63 00 B9 E8 63 40 B9 E8 03 08 4B E8 2B 00 B9 E8 3F 40 B9 1F 01 00 71 4A 04 00 54 E8 3F 40 B9 E2 03 08 4B E3 47 40 39 42 00 00 11 E1 0F 40 F9 E0 43 40 39 ?? ?? ?? ?? E0 3F 00 F9 E8 3F 40 F9 E8 0F 00 F9 E8 0F 40 F9 1F 01 00 F1 C1 00 00 54 E1 1B 40 F9 E0 43 40 39 ?? ?? ?? ?? 40 00 80 52 6B 00 00 14 E0 1B 40 F9 ?? ?? ?? ?? E0 43 00 F9 E9 43 40 F9 E8 0F 40 F9 1F 01 09 EB 09 01 00 54 E8 3F 40 B9 09 05 00 11 E8 43 40 B9 09 01 09 4B E8 27 40 B9 28 01 08 4B E8 2B 00 B9 06 00 00 14 E8 3F 40 B9 09 7D 40 93 E8 0F 40 F9 08 21 C9 9A E8 0F 00 F9 30 00 00 14 E8 27 40 B9 1F 01 00 71 AA 04 00 54 E8 27 40 B9 E2 03 08 4B E3 47 40 39 42 00 00 11 E1 0F 40 F9 E0 43 40 39 ?? ?? ?? ?? E0 47 00 F9 E8 47 40 F9 E8 0F 00 F9 E0 1B 40 F9 ?? ?? ?? ?? E0 4B 00 F9 E9 4B 40 F9 E8 0F 40 F9 1F 01 09 EB 69 02 00 54 E8 0F 40 F9 08 FD 41 D3 E8 0F 00 F9 E8 2B 40 B9 08 05 00 11 E8 2B 00 B9 E0 1B 40 F9 ?? ?? ?? ?? E0 67 00 B9 E9 67 40 B9 E8 2B 40 B9 1F 01 09 6B CD 00 00 54 E1 1B 40 F9 E0 43 40 39 ?? ?? ?? ?? 60 00 80 52 30 00 00 14 09 00 00 14 E8 27 40 B9 1F 01 00 71 CD 00 00 54 E8 27 40 B9 09 7D 40 93 E8 0F 40 F9 08 21 C9 9A E8 0F 00 F9 E0 1B 40 F9 ?? ?? ?? ?? E0 4F 00 F9 E9 0F 40 F9 E8 4F 40 F9 28 01 08 8A E8 0F 00 F9 E0 1B 40 F9 ?? ?? ?? ?? E0 83 00 39 E8 83 40 39 08 01 00 11 1F 01 00 71 A0 01 00 54 E0 1B 40 F9 ?? ?? ?? ?? E0 53 00 F9 E3 53 40 F9 E2 0F 40 F9 E1 2B 40 B9 E0 43 40 39 ?? ?? ?? ?? E0 6B 00 B9 E8 6B 40 B9 E8 47 00 B9 0C 00 00 14 E0 1B 40 F9 ?? ?? ?? ?? E0 57 00 F9 E3 57 40 F9 E2 0F 40 F9 E1 2B 40 B9 E0 43 40 39 ?? ?? ?? ?? E0 6F 00 B9 E8 6F 40 B9 E8 47 00 B9 E0 47 40 B9 FD 7B CB A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_73_0 {
	meta:
		name = "?assemble_floating_point_value_from_big_integer@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUbig_integer@1@I_N1AEBVfloating_point_value@1@@Z"
		size = 1240
		refs = "0020 ?mantissa_bits@floating_point_value@__crt_strtox@@QEBAHXZ 010c ?assemble_floating_point_value@__crt_strtox@@YA?AW4SLD_STATUS@@_KH_N1AEBVfloating_point_value@1@@Z"
	strings:
		$1 = { FD 7B B4 A9 FD 03 00 91 E0 13 00 F9 E1 37 00 B9 E2 4F 00 39 E3 47 00 39 E4 37 00 F9 E0 37 40 F9 ?? ?? ?? ?? E0 A3 00 B9 E8 A3 40 B9 08 05 00 51 E8 3B 00 B9 E8 37 40 B9 1F 01 01 71 08 07 00 54 E8 3B 40 B9 E8 7B 00 B9 E8 13 40 F9 08 01 00 91 08 01 40 B9 1F 01 00 71 C9 00 00 54 E8 13 40 F9 08 11 00 91 08 01 40 B9 E8 63 00 B9 03 00 00 14 08 00 80 52 E8 63 00 B9 E8 63 40 B9 E8 73 00 B9 E8 13 40 F9 08 01 00 91 08 01 40 B9 1F 05 00 71 C9 00 00 54 E8 13 40 F9 08 21 00 91 08 01 40 B9 E8 47 00 B9 03 00 00 14 08 00 80 52 E8 47 00 B9 E8 47 40 B9 E8 77 00 B9 E8 73 40 B9 09 7D 40 D3 E8 77 40 B9 08 7D 40 D3 08 7D 60 D3 28 01 08 8B E8 57 00 F9 E8 47 40 39 08 01 00 11 1F 01 00 71 81 00 00 54 28 00 80 52 E8 53 00 39 03 00 00 14 08 00 80 52 E8 53 00 39 E4 37 40 F9 E3 53 40 39 E2 4F 40 39 E1 7B 40 B9 E0 57 40 F9 ?? ?? ?? ?? E0 7F 00 B9 E0 7F 40 B9 EE 00 00 14 EA 37 40 B9 09 04 80 52 48 09 C9 1A 08 7D 09 1B 48 01 08 4B E8 2B 00 B9 E9 37 40 B9 08 04 80 52 28 09 C8 1A E8 3F 00 B9 E8 3F 40 B9 08 05 00 51 E8 57 00 B9 E8 3F 40 B9 08 09 00 51 E8 1B 00 B9 E8 2B 40 B9 1F 01 00 71 21 0A 00 54 E9 1B 40 B9 08 04 80 52 29 7D 08 1B E8 3B 40 B9 08 01 09 0B E8 83 00 B9 E8 13 40 F9 0A 11 00 91 E8 1B 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 08 01 40 B9 0B 7D 40 D3 E8 13 40 F9 0A 11 00 91 E8 57 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 08 01 40 B9 08 7D 40 D3 08 7D 60 D3 68 01 08 8B E8 5B 00 F9 E8 47 40 39 08 01 00 11 1F 01 00 71 81 00 00 54 28 00 80 52 E8 4B 00 B9 03 00 00 14 08 00 80 52 E8 4B 00 B9 E8 4B 40 B9 08 1D 00 53 E8 43 00 39 08 00 80 52 E8 2F 00 B9 04 00 00 14 E8 2F 40 B9 08 05 00 11 E8 2F 00 B9 E9 1B 40 B9 E8 2F 40 B9 1F 01 09 6B E0 02 00 54 E8 13 40 F9 0A 11 00 91 E8 2F 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 08 01 40 B9 1F 01 00 71 81 00 00 54 28 00 80 52 E8 4F 00 B9 03 00 00 14 08 00 80 52 E8 4F 00 B9 E9 43 40 39 29 01 00 11 E8 4F 40 B9 28 01 08 0A 08 1D 00 53 E8 43 00 39 E4 FF FF 17 E4 37 40 F9 E3 43 40 39 E2 4F 40 39 E1 83 40 B9 E0 5B 40 F9 ?? ?? ?? ?? E0 87 00 B9 E0 87 40 B9 8B 00 00 14 29 00 80 52 E8 2B 40 B9 28 21 C8 1A 08 05 00 51 E8 43 00 B9 09 08 80 52 E8 2B 40 B9 28 01 08 4B E8 53 00 B9 E8 53 40 B9 08 81 00 51 E8 8F 00 B9 09 04 80 52 E8 2B 40 B9 28 01 08 4B E8 8B 00 B9 E8 43 40 B9 E8 03 28 2A E8 93 00 B9 09 04 80 52 E8 8B 40 B9 28 01 08 4B E8 97 00 B9 E9 1B 40 B9 08 04 80 52 29 7D 08 1B E8 3B 40 B9 09 01 09 0B E8 2B 40 B9 28 01 08 0B E8 9B 00 B9 E8 13 40 F9 0A 11 00 91 E8 3F 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 09 01 40 B9 E8 43 40 B9 28 01 08 0A 09 7D 40 D3 E8 53 40 B9 08 7D 40 D3 2B 21 C8 9A E8 13 40 F9 0A 11 00 91 E8 57 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 08 01 40 B9 09 7D 40 D3 E8 8F 40 B9 08 7D 40 D3 28 21 C8 9A 6B 01 08 8B E8 13 40 F9 0A 11 00 91 E8 1B 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 09 01 40 B9 E8 93 40 B9 28 01 08 0A 09 7D 40 D3 E8 97 40 B9 08 7D 40 D3 28 25 C8 9A 68 01 08 8B E8 5F 00 F9 E8 47 40 39 08 01 00 11 1F 01 00 71 01 02 00 54 E8 13 40 F9 0A 11 00 91 E8 1B 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 09 01 40 B9 E8 43 40 B9 28 01 08 0A 1F 01 00 71 81 00 00 54 28 00 80 52 E8 5B 00 B9 03 00 00 14 08 00 80 52 E8 5B 00 B9 E8 5B 40 B9 08 1D 00 53 E8 4B 00 39 08 00 80 52 E8 33 00 B9 04 00 00 14 E8 33 40 B9 08 05 00 11 E8 33 00 B9 E9 1B 40 B9 E8 33 40 B9 1F 01 09 6B E0 02 00 54 E8 13 40 F9 0A 11 00 91 E8 33 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 08 01 40 B9 1F 01 00 71 81 00 00 54 28 00 80 52 E8 5F 00 B9 03 00 00 14 08 00 80 52 E8 5F 00 B9 E9 4B 40 39 29 01 00 11 E8 5F 40 B9 28 01 08 0A 08 1D 00 53 E8 4B 00 39 E4 FF FF 17 E4 37 40 F9 E3 4B 40 39 E2 4F 40 39 E1 9B 40 B9 E0 5F 40 F9 ?? ?? ?? ?? E0 9F 00 B9 E0 9F 40 B9 FD 7B CC A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_75_0 {
	meta:
		name = "?bit_scan_reverse@__crt_strtox@@YAIAEBUbig_integer@1@@Z"
		size = 136
		refs = "0054 ?bit_scan_reverse@__crt_strtox@@YAII@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 08 01 40 B9 1F 01 00 71 61 00 00 54 00 00 80 52 17 00 00 14 E8 0F 40 F9 0A 11 00 91 E8 0F 40 F9 08 01 00 91 08 01 40 B9 08 05 00 51 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 00 01 40 B9 ?? ?? ?? ?? E0 13 00 B9 E8 0F 40 F9 08 01 00 91 08 01 40 B9 09 05 00 51 08 04 80 52 29 7D 08 1B E8 13 40 B9 20 01 08 0B 00 00 00 11 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_76_0 {
	meta:
		name = "?bit_scan_reverse@__crt_strtox@@YAII@Z"
		size = 108
	strings:
		$1 = { FF 43 00 D1 E0 0B 00 B9 08 00 80 52 E8 07 00 B9 E8 0B 40 B9 08 11 C0 5A E8 03 00 B9 E9 03 80 52 E8 03 40 B9 29 01 08 4B E8 13 00 91 09 01 00 B9 E8 03 40 B9 09 7D 05 53 28 00 80 52 08 01 09 4B 08 1D 00 53 08 01 00 11 1F 01 00 71 A0 00 00 54 E8 07 40 B9 00 05 00 11 00 00 00 11 02 00 00 14 00 00 80 52 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_77_0 {
	meta:
		name = "?bit_scan_reverse@__crt_strtox@@YAI_K@Z"
		size = 84
		refs = "0020 ?bit_scan_reverse@__crt_strtox@@YAII@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E9 7F 40 B2 E8 0F 40 F9 1F 01 09 EB 29 01 00 54 E0 1F 40 B9 ?? ?? ?? ?? E0 13 00 B9 E8 13 40 B9 00 81 00 11 00 00 00 11 06 00 00 14 05 00 00 14 E0 1B 40 B9 ?? ?? ?? ?? E0 17 00 B9 E0 17 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_78_0 {
	meta:
		name = "?convert_decimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@AEBVfloating_point_value@1@@Z"
		size = 1468
		refs = "0008 __security_push_cookie 001c ?mantissa_bits@floating_point_value@__crt_strtox@@QEBAHXZ 011c ??0big_integer@__crt_strtox@@QEAA@XZ 012c ?accumulate_decimal_digits_into_big_integer@__crt_strtox@@YAXQEBE0AEAUbig_integer@1@@Z 0144 ?multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@1@I@Z 016c ?assemble_floating_point_infinity@__crt_strtox@@YAX_NAEBVfloating_point_value@1@@Z 017c ?bit_scan_reverse@__crt_strtox@@YAIAEBUbig_integer@1@@Z 01e4 ?assemble_floating_point_value_from_big_integer@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUbig_integer@1@I_N1AEBVfloating_point_value@1@@Z 0258 ?make_big_integer@__crt_strtox@@YA?AUbig_integer@1@_K@Z 028c ?assemble_floating_point_zero@__crt_strtox@@YAX_NAEBVfloating_point_value@1@@Z 0308 ?shift_left@__crt_strtox@@YA_NAEAUbig_integer@1@I@Z 03a4 ??M__crt_strtox@@YA_NAEBUbig_integer@0@0@Z 03f0 ?divide@__crt_strtox@@YA_KAEAUbig_integer@1@AEBU21@@Z 0430 ?bit_scan_reverse@__crt_strtox@@YAI_K@Z 05a0 ?assemble_floating_point_value@__crt_strtox@@YA?AW4SLD_STATUS@@_KH_N1AEBVfloating_point_value@1@@Z 05b0 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 19 D1 E0 0B 00 F9 E1 1B 00 F9 E0 1B 40 F9 ?? ?? ?? ?? E0 B3 00 B9 E8 B3 40 B9 08 05 00 11 E8 53 00 B9 E8 0B 40 F9 08 01 00 91 09 01 40 B9 08 00 80 52 1F 01 09 6B 8D 00 00 54 08 00 80 52 E8 77 00 B9 05 00 00 14 E8 0B 40 F9 08 01 00 91 08 01 40 B9 E8 77 00 B9 E8 77 40 B9 E8 2B 00 B9 E8 0B 40 F9 08 11 00 91 09 01 40 B9 E8 2B 40 B9 1F 01 09 6B 82 00 00 54 E8 2B 40 B9 E8 7B 00 B9 05 00 00 14 E8 0B 40 F9 08 11 00 91 08 01 40 B9 E8 7B 00 B9 E8 7B 40 B9 E8 3B 00 B9 E9 2B 40 B9 E8 3B 40 B9 28 01 08 4B E8 3F 00 B9 E8 0B 40 F9 08 21 00 91 E8 6F 00 F9 E8 0B 40 F9 09 21 00 91 E8 3B 40 B9 08 7D 40 D3 28 01 08 8B E8 63 00 F9 E8 63 40 F9 E8 6B 00 F9 E8 0B 40 F9 09 21 00 91 E8 0B 40 F9 08 11 00 91 08 01 40 B9 08 7D 40 D3 28 01 08 8B E8 67 00 F9 E9 67 40 F9 E8 6B 40 F9 28 01 08 CB 08 01 00 11 E8 1F 00 B9 E0 E3 03 91 ?? ?? ?? ?? E2 E3 03 91 E1 63 40 F9 E0 6F 40 F9 ?? ?? ?? ?? E8 3F 40 B9 1F 01 00 71 09 02 00 54 E1 3F 40 B9 E0 E3 03 91 ?? ?? ?? ?? E0 0F 00 39 E8 0F 40 39 08 01 00 11 1F 01 00 71 01 01 00 54 E8 0B 40 F9 08 21 0C 91 E1 1B 40 F9 00 01 40 39 ?? ?? ?? ?? 60 00 80 52 0E 01 00 14 E0 E3 03 91 ?? ?? ?? ?? E0 B7 00 B9 E8 B7 40 B9 E8 0B 00 B9 E9 53 40 B9 E8 0B 40 B9 1F 01 09 6B 82 00 00 54 E8 1F 40 B9 1F 01 00 71 81 02 00 54 E8 1F 40 B9 1F 01 00 71 80 00 00 54 28 00 80 52 E8 07 00 39 03 00 00 14 08 00 80 52 E8 07 00 39 E8 0B 40 F9 08 21 0C 91 E4 1B 40 F9 E3 07 40 39 02 01 40 39 E1 0B 40 B9 E0 E3 03 91 ?? ?? ?? ?? E0 BB 00 B9 E0 BB 40 B9 EF 00 00 14 E0 23 0B 91 ?? ?? ?? ?? E2 23 0B 91 E1 67 40 F9 E0 6B 40 F9 ?? ?? ?? ?? E8 0B 40 F9 08 01 00 91 08 01 40 B9 1F 01 00 71 2A 01 00 54 E8 0B 40 F9 08 01 00 91 08 01 40 B9 E9 03 08 4B E8 1F 40 B9 08 01 09 0B E8 43 00 B9 03 00 00 14 E8 1F 40 B9 E8 43 00 B9 E8 43 40 B9 E8 8B 00 B9 21 00 80 D2 E0 63 12 91 ?? ?? ?? ?? E1 8B 40 B9 E0 63 12 91 ?? ?? ?? ?? E0 13 00 39 E8 13 40 39 08 01 00 11 1F 01 00 71 01 01 00 54 E8 0B 40 F9 08 21 0C 91 E1 1B 40 F9 00 01 40 39 ?? ?? ?? ?? 40 00 80 52 C6 00 00 14 E0 23 0B 91 ?? ?? ?? ?? E0 8F 00 B9 E8 8F 40 B9 E8 4B 00 B9 E0 63 12 91 ?? ?? ?? ?? E0 93 00 B9 E8 93 40 B9 E8 47 00 B9 E9 4B 40 B9 E8 47 40 B9 1F 01 09 6B C9 00 00 54 E9 47 40 B9 E8 4B 40 B9 28 01 08 4B E8 4F 00 B9 03 00 00 14 08 00 80 52 E8 4F 00 B9 E8 4F 40 B9 E8 1B 00 B9 E8 1B 40 B9 1F 01 00 71 89 00 00 54 E1 1B 40 B9 E0 23 0B 91 ?? ?? ?? ?? E9 53 40 B9 E8 0B 40 B9 28 01 08 4B E8 27 00 B9 E8 27 40 B9 E8 23 00 B9 E8 0B 40 B9 1F 01 00 71 89 03 00 54 E9 23 40 B9 E8 1B 40 B9 1F 01 09 6B 89 02 00 54 E8 1F 40 B9 1F 01 00 71 80 00 00 54 28 00 80 52 E8 0B 00 39 03 00 00 14 08 00 80 52 E8 0B 00 39 E8 0B 40 F9 08 21 0C 91 E4 1B 40 F9 E3 0B 40 39 02 01 40 39 E1 0B 40 B9 E0 E3 03 91 ?? ?? ?? ?? E0 97 00 B9 E0 97 40 B9 89 00 00 14 E9 23 40 B9 E8 1B 40 B9 28 01 08 4B E8 23 00 B9 E1 63 12 91 E0 23 0B 91 ?? ?? ?? ?? E0 17 00 39 E8 17 40 39 08 01 00 11 1F 01 00 71 A0 00 00 54 E8 1B 40 B9 08 05 00 11 E8 57 00 B9 03 00 00 14 E8 1B 40 B9 E8 57 00 B9 E8 57 40 B9 E8 A7 00 B9 E1 23 40 B9 E0 23 0B 91 ?? ?? ?? ?? E1 63 12 91 E0 23 0B 91 ?? ?? ?? ?? E0 73 00 F9 E8 73 40 F9 E8 43 00 F9 E8 CB 42 B9 1F 01 00 71 81 00 00 54 28 00 80 52 E8 5B 00 B9 03 00 00 14 08 00 80 52 E8 5B 00 B9 E8 5B 40 B9 08 1D 00 53 E8 03 00 39 E0 43 40 F9 ?? ?? ?? ?? E0 9B 00 B9 E8 9B 40 B9 E8 5F 00 B9 E9 27 40 B9 E8 5F 40 B9 1F 01 09 6B E9 03 00 54 E9 5F 40 B9 E8 27 40 B9 28 01 08 4B E8 67 00 B9 E8 03 40 39 08 01 00 11 1F 01 00 71 A0 01 00 54 E8 67 40 B9 09 7D 40 D3 28 00 80 D2 08 21 C9 9A 09 05 00 D1 E8 43 40 F9 08 01 09 8A 1F 01 00 F1 81 00 00 54 28 00 80 52 E8 63 00 B9 03 00 00 14 08 00 80 52 E8 63 00 B9 E8 63 40 B9 08 1D 00 53 E8 03 00 39 E8 67 40 B9 09 7D 40 D3 E8 43 40 F9 08 25 C9 9A E8 43 00 F9 E8 FB 40 B9 1F 01 00 71 89 00 00 54 E8 FF 40 B9 E8 6B 00 B9 03 00 00 14 08 00 80 52 E8 6B 00 B9 E8 6B 40 B9 E8 9F 00 B9 E8 FB 40 B9 1F 05 00 71 89 00 00 54 E8 03 41 B9 E8 6F 00 B9 03 00 00 14 08 00 80 52 E8 6F 00 B9 E8 6F 40 B9 E8 A3 00 B9 E8 9F 40 B9 09 7D 40 D3 E8 A3 40 B9 08 7D 40 D3 08 7D 60 D3 28 01 08 8B E8 77 00 F9 E8 27 40 B9 09 7D 40 D3 E8 77 40 F9 09 21 C9 9A E8 43 40 F9 28 01 08 8B E8 7B 00 F9 E8 0B 40 B9 1F 01 00 71 A9 00 00 54 E8 0B 40 B9 08 09 00 51 E8 73 00 B9 05 00 00 14 E8 A7 40 B9 E8 03 08 4B 08 05 00 51 E8 73 00 B9 E8 73 40 B9 E8 AB 00 B9 E8 0B 40 F9 08 21 0C 91 E4 1B 40 F9 E3 03 40 39 02 01 40 39 E1 AB 40 B9 E0 7B 40 F9 ?? ?? ?? ?? E0 AF 00 B9 E0 AF 40 B9 FF 83 19 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_79_0 {
	meta:
		name = "?convert_hexadecimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@AEBVfloating_point_value@1@@Z"
		size = 396
		refs = "001c ?mantissa_bits@floating_point_value@__crt_strtox@@QEBAHXZ 0080 ?normal_mantissa_mask@floating_point_value@__crt_strtox@@QEBA_KXZ 0178 ?assemble_floating_point_value@__crt_strtox@@YA?AW4SLD_STATUS@@_KH_N1AEBVfloating_point_value@1@@Z"
	strings:
		$1 = { FD 7B BA A9 FD 03 00 91 E0 1F 00 F9 E1 27 00 F9 08 00 80 D2 E8 17 00 F9 E0 27 40 F9 ?? ?? ?? ?? E0 43 00 B9 E8 1F 40 F9 08 01 00 91 09 01 40 B9 E8 43 40 B9 28 01 08 0B 08 05 00 51 E8 23 00 B9 E8 1F 40 F9 09 21 00 91 E8 1F 40 F9 08 11 00 91 08 01 40 B9 08 7D 40 D3 28 01 08 8B E8 2B 00 F9 E8 1F 40 F9 08 21 00 91 E8 0F 00 F9 E9 2B 40 F9 E8 0F 40 F9 1F 01 09 EB 40 03 00 54 E0 27 40 F9 ?? ?? ?? ?? E0 2F 00 F9 E9 2F 40 F9 E8 17 40 F9 1F 01 09 EB 68 02 00 54 E9 17 40 F9 08 02 80 D2 28 7D 08 9B E8 17 00 F9 E8 0F 40 F9 08 01 40 39 08 01 00 11 09 7D 40 93 E8 17 40 F9 08 01 09 8B E8 17 00 F9 E8 0F 40 F9 08 05 00 91 E8 0F 00 F9 E8 23 40 B9 08 11 00 51 E8 23 00 B9 E4 FF FF 17 28 00 80 52 E8 43 00 39 E9 2B 40 F9 E8 0F 40 F9 1F 01 09 EB 40 03 00 54 E8 43 40 39 08 01 00 11 1F 01 00 71 C0 02 00 54 E8 43 40 39 08 01 00 11 1F 01 00 71 80 01 00 54 E8 0F 40 F9 08 01 40 39 08 01 00 11 1F 01 00 71 E8 0F 40 F9 08 05 00 91 E8 0F 00 F9 81 00 00 54 28 00 80 52 E8 33 00 B9 03 00 00 14 08 00 80 52 E8 33 00 B9 E8 33 40 B9 08 1D 00 53 E8 43 00 39 E4 FF FF 17 E8 1F 40 F9 08 21 0C 91 E4 27 40 F9 E3 43 40 39 02 01 40 39 E1 23 40 B9 E0 17 40 F9 ?? ?? ?? ?? E0 47 00 B9 E0 47 40 B9 FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_80_0 {
	meta:
		name = "?count_sequential_high_zeroes@__crt_strtox@@YAII@Z"
		size = 112
	strings:
		$1 = { FF 43 00 D1 E0 0B 00 B9 E8 0B 40 B9 08 11 C0 5A E8 03 00 B9 E9 03 80 52 E8 03 40 B9 29 01 08 4B E8 33 00 91 09 01 00 B9 E8 03 40 B9 09 7D 05 53 28 00 80 52 08 01 09 4B 08 1D 00 53 08 01 00 11 1F 01 00 71 C0 00 00 54 E9 03 80 52 E8 0F 40 B9 28 01 08 4B E8 07 00 B9 03 00 00 14 08 04 80 52 E8 07 00 B9 E0 07 40 B9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_81_0 {
	meta:
		name = "?denormal_mantissa_mask@floating_point_value@__crt_strtox@@QEBA_KXZ"
		size = 64
	strings:
		$1 = { FF 43 00 D1 E0 07 00 F9 E8 07 40 F9 08 21 00 91 08 01 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 08 FE FF 92 E8 03 00 F9 03 00 00 14 E8 5B 40 B2 E8 03 00 F9 E0 03 40 F9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_82_0 {
	meta:
		name = "?divide@__crt_strtox@@YA_KAEAUbig_integer@1@AEBU21@@Z"
		size = 2808
		refs = "0008 __security_push_cookie 0054 ??_C@_1DI@GICAMMFM@?$AA?$CI?$AA?$CC?$AAD?$AAi?$AAv?$AAi?$AAs?$AAi?$AAo?$AAn?$AA?5?$AAb?$AAy?$AA?5?$AAz?$AAe?$AAr?$AAo?$AA?$CC?$AA?0?$AA?5?$AAf?$AAa?$AAl?$AAs?$AAe?$AA?$CJ?$AA?$AA@ 005c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 006c ??_C@_1GO@BFGDDONN@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0078 _CrtDbgReportW 0100 ??0big_integer@__crt_strtox@@QEAA@XZ 0110 ??4big_integer@__crt_strtox@@QEAAAEAU01@AEBU01@@Z 04ac ?count_sequential_high_zeroes@__crt_strtox@@YAII@Z 0814 ?multiply_64_32@__crt_strtox@@YA_K_KI@Z 0aec __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 43 19 D1 E0 03 00 F9 E1 23 00 F9 E8 03 40 F9 08 01 00 91 08 01 40 B9 1F 01 00 71 61 00 00 54 00 00 80 D2 AE 02 00 14 E8 23 40 F9 08 01 00 91 08 01 40 B9 1F 01 00 71 C1 02 00 54 08 00 80 52 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 5B 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 AB 00 B9 E9 AB 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 00 00 80 D2 94 02 00 14 E8 03 40 F9 08 01 00 91 08 01 40 B9 08 05 00 51 E8 13 00 B9 E8 23 40 F9 08 01 00 91 08 01 40 B9 08 05 00 51 E8 4F 00 B9 E8 4F 40 B9 1F 01 00 71 81 12 00 54 E8 23 40 F9 08 11 00 91 08 01 40 B9 E8 37 00 B9 E8 37 40 B9 1F 05 00 71 E1 01 00 54 E8 03 40 F9 08 11 00 91 08 01 40 B9 E8 A3 00 B9 E0 A3 03 91 ?? ?? ?? ?? E0 67 00 F9 E1 67 40 F9 E0 03 40 F9 ?? ?? ?? ?? E8 A3 40 B9 00 7D 40 D3 00 00 00 91 72 02 00 14 E8 13 40 B9 1F 01 00 71 61 05 00 54 E8 03 40 F9 08 11 00 91 08 01 40 B9 E8 83 00 B9 E0 E3 0A 91 ?? ?? ?? ?? E0 6B 00 F9 E1 6B 40 F9 E0 03 40 F9 ?? ?? ?? ?? EA 83 40 B9 E9 37 40 B9 49 00 00 35 80 00 3E D4 48 09 C9 1A 08 7D 09 1B 49 01 08 4B E8 03 40 F9 08 11 00 91 09 01 00 B9 E8 03 40 F9 08 11 00 91 08 01 40 B9 1F 01 00 71 89 00 00 54 28 00 80 52 E8 93 00 B9 03 00 00 14 08 00 80 52 E8 93 00 B9 E8 03 40 F9 09 01 00 91 E8 93 40 B9 28 01 00 B9 E9 83 40 B9 E8 37 40 B9 48 00 00 35 80 00 3E D4 28 09 C8 1A 00 7D 40 D3 00 00 00 91 45 02 00 14 08 00 80 D2 E8 5B 00 F9 08 00 80 D2 E8 37 00 F9 E8 13 40 B9 E8 4B 00 B9 04 00 00 14 E8 4B 40 B9 08 05 00 51 E8 4B 00 B9 E8 4B 40 B9 1F 05 00 31 80 04 00 54 E8 37 40 F9 0B 7D 60 D3 E8 03 40 F9 0A 11 00 91 E8 4B 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 08 01 40 B9 08 7D 40 D3 68 01 08 AA E8 37 00 F9 E8 5B 40 F9 0A 7D 60 D3 E8 37 40 B9 09 7D 40 D3 E8 37 40 F9 49 00 00 B5 80 00 3E D4 08 09 C9 9A 08 01 00 11 08 7D 40 D3 48 01 08 8B E8 5B 00 F9 E8 37 40 B9 0A 7D 40 D3 E9 37 40 F9 4A 00 00 B5 80 00 3E D4 28 09 CA 9A 08 7D 0A 9B 28 01 08 CB E8 37 00 F9 D8 FF FF 17 E0 23 12 91 ?? ?? ?? ?? E0 6F 00 F9 E1 6F 40 F9 E0 03 40 F9 ?? ?? ?? ?? E8 37 40 F9 08 FD 60 D3 09 01 00 11 E8 03 40 F9 08 21 00 91 09 01 00 B9 E8 37 40 F9 09 01 00 11 E8 03 40 F9 08 11 00 91 09 01 00 B9 E8 03 40 F9 08 21 00 91 08 01 40 B9 1F 01 00 71 89 00 00 54 48 00 80 52 E8 87 00 B9 03 00 00 14 28 00 80 52 E8 87 00 B9 E8 03 40 F9 09 01 00 91 E8 87 40 B9 28 01 00 B9 E0 5B 40 F9 F4 01 00 14 E9 13 40 B9 E8 4F 40 B9 1F 01 09 6B 69 00 00 54 00 00 80 D2 EE 01 00 14 E8 4F 40 B9 08 05 00 11 E8 0F 00 B9 E9 13 40 B9 E8 4F 40 B9 28 01 08 4B E8 53 00 B9 E8 53 40 B9 E8 27 00 B9 E8 13 40 B9 E8 17 00 B9 04 00 00 14 E8 17 40 B9 08 05 00 51 E8 17 00 B9 E9 53 40 B9 E8 17 40 B9 1F 01 09 6B AA 00 00 54 E8 27 40 B9 08 05 00 11 E8 27 00 B9 2E 00 00 14 E8 23 40 F9 0A 11 00 91 E9 17 40 B9 E8 53 40 B9 28 01 08 4B 09 7D 40 93 88 00 80 D2 28 7D 08 9B 4B 01 08 8B E8 03 40 F9 0A 11 00 91 E8 17 40 B9 09 7D 40 93 88 00 80 D2 28 7D 08 9B 48 01 08 8B 09 01 40 B9 68 01 40 B9 1F 01 09 6B 20 03 00 54 E8 23 40 F9 0A 11 00 91 E9 17 40 B9 E8 53 40 B9 28 01 08 4B 09 7D 40 93 88 00 80 D2 28 7D 08 9B 4B 01 08 8B E8 03 40 F9 0A 11 00 91 E8 17 40 B9 09 7D 40 93 88 00 80 D2 28 7D 08 9B 48 01 08 8B 09 01 40 B9 68 01 40 B9 1F 01 09 6B 82 00 00 54 E8 27 40 B9 08 05 00 11 E8 27 00 B9 02 00 00 14 C9 FF FF 17 E8 27 40 B9 1F 01 00 71 61 00 00 54 00 00 80 D2 A5 01 00 14 E8 23 40 F9 0A 11 00 91 E8 0F 40 B9 08 05 00 51 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 08 01 40 B9 E8 1F 00 B9 E8 23 40 F9 0A 11 00 91 E8 0F 40 B9 08 09 00 51 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 08 01 40 B9 E8 2B 00 B9 E0 1F 40 B9 ?? ?? ?? ?? E0 A7 00 B9 E8 A7 40 B9 E8 1B 00 B9 09 04 80 52 E8 1B 40 B9 28 01 08 4B E8 57 00 B9 E8 1B 40 B9 1F 01 00 71 C9 03 00 54 E9 1F 40 B9 E8 1B 40 B9 2A 21 C8 1A E9 2B 40 B9 E8 57 40 B9 28 25 C8 1A 48 01 08 2A E8 1F 00 B9 E9 2B 40 B9 E8 1B 40 B9 28 21 C8 1A E8 2B 00 B9 E8 0F 40 B9 1F 09 00 71 E9 01 00 54 E8 23 40 F9 0A 11 00 91 E8 0F 40 B9 08 0D 00 51 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 09 01 40 B9 E8 57 40 B9 29 25 C8 1A E8 2B 40 B9 08 01 09 2A E8 2B 00 B9 08 00 80 D2 E8 5F 00 F9 E8 27 40 B9 E8 0B 00 B9 E8 0B 40 B9 08 05 00 51 E8 0B 00 B9 E8 0B 40 B9 1F 01 00 71 EB 24 00 54 E9 0B 40 B9 E8 0F 40 B9 29 01 08 0B E8 13 40 B9 3F 01 08 6B A8 01 00 54 E8 03 40 F9 0A 11 00 91 E9 0B 40 B9 E8 0F 40 B9 28 01 08 0B 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 08 01 40 B9 E8 8B 00 B9 03 00 00 14 08 00 80 52 E8 8B 00 B9 E8 8B 40 B9 E8 7F 00 B9 E8 03 40 F9 0A 11 00 91 E9 0B 40 B9 E8 0F 40 B9 28 01 08 0B 08 05 00 51 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 08 01 40 B9 08 7D 40 D3 E8 4F 00 F9 E8 7F 40 B9 E8 9F 00 B9 E8 03 40 F9 0A 11 00 91 E9 0B 40 B9 E8 0F 40 B9 28 01 08 0B 08 09 00 51 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 08 01 40 B9 E8 2F 00 B9 E8 1B 40 B9 1F 01 00 71 89 04 00 54 E8 1B 40 B9 09 7D 40 D3 E8 4F 40 F9 0A 21 C9 9A E9 2F 40 B9 E8 57 40 B9 28 25 C8 1A 08 7D 40 D3 48 01 08 AA E8 4F 00 F9 E9 2F 40 B9 E8 1B 40 B9 28 21 C8 1A E8 2F 00 B9 E9 0B 40 B9 E8 0F 40 B9 28 01 08 0B 1F 0D 00 71 23 02 00 54 E8 03 40 F9 0A 11 00 91 E9 0B 40 B9 E8 0F 40 B9 28 01 08 0B 08 0D 00 51 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 09 01 40 B9 E8 57 40 B9 29 25 C8 1A E8 2F 40 B9 08 01 09 2A E8 2F 00 B9 E8 1F 40 B9 09 7D 40 D3 E8 4F 40 F9 49 00 00 B5 80 00 3E D4 08 09 C9 9A E8 1F 00 F9 E8 1F 40 B9 0A 7D 40 D3 E9 4F 40 F9 4A 00 00 B5 80 00 3E D4 28 09 CA 9A 08 7D 0A 9B 28 01 08 CB 08 01 00 11 08 7D 40 D3 E8 3B 00 F9 E9 7F 40 B2 E8 1F 40 F9 1F 01 09 EB 89 01 00 54 E8 1F 40 B9 0A 7D 40 D3 E9 1F 40 F9 E8 7F 40 B2 28 01 08 CB 49 7D 08 9B E8 3B 40 F9 08 01 09 8B E8 3B 00 F9 E8 7F 40 B2 E8 1F 00 F9 E9 7F 40 B2 E8 3B 40 F9 1F 01 09 EB A8 02 00 54 E8 2B 40 B9 09 7D 40 D3 E8 1F 40 F9 0A 7D 09 9B E8 3B 40 F9 09 7D 60 D3 E8 2F 40 B9 08 7D 40 D3 28 01 08 AA 5F 01 08 EB 49 01 00 54 E8 1F 40 F9 08 05 00 D1 E8 1F 00 F9 E8 1F 40 B9 09 7D 40 D3 E8 3B 40 F9 08 01 09 8B E8 3B 00 F9 E9 FF FF 17 E8 1F 40 F9 1F 01 00 F1 89 11 00 54 08 00 80 D2 E8 33 00 F9 08 00 80 52 E8 23 00 B9 04 00 00 14 E8 23 40 B9 08 05 00 11 E8 23 00 B9 E9 0F 40 B9 E8 23 40 B9 1F 01 09 6B A2 07 00 54 E8 23 40 F9 0A 11 00 91 E8 23 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 01 01 40 B9 E0 1F 40 F9 ?? ?? ?? ?? E0 73 00 F9 E9 33 40 F9 E8 73 40 F9 28 01 08 8B E8 33 00 F9 E8 33 40 F9 08 01 00 11 E8 8F 00 B9 E8 33 40 F9 08 FD 60 D3 E8 33 00 F9 E8 03 40 F9 0A 11 00 91 E9 0B 40 B9 E8 23 40 B9 28 01 08 0B 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B E9 8F 40 B9 08 01 40 B9 1F 01 09 6B 82 00 00 54 E8 33 40 F9 08 05 00 91 E8 33 00 F9 E8 03 40 F9 0A 11 00 91 E9 0B 40 B9 E8 23 40 B9 28 01 08 0B 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 09 01 40 B9 E8 8F 40 B9 2A 01 08 4B E9 0B 40 B9 E8 23 40 B9 28 01 08 0B 09 7D 40 D3 88 00 80 D2 29 7D 08 9B E8 03 40 F9 08 11 00 91 08 01 09 8B 0A 01 00 B9 BE FF FF 17 E8 7F 40 B9 09 7D 40 D3 E8 33 40 F9 3F 01 08 EB 42 07 00 54 08 00 80 52 E8 7B 00 B9 08 00 80 52 E8 33 00 B9 04 00 00 14 E8 33 40 B9 08 05 00 11 E8 33 00 B9 E9 0F 40 B9 E8 33 40 B9 1F 01 09 6B 62 05 00 54 E8 03 40 F9 0A 11 00 91 E9 0B 40 B9 E8 33 40 B9 28 01 08 0B 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 08 01 40 B9 0B 7D 40 D3 E8 23 40 F9 0A 11 00 91 E8 33 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 08 01 40 B9 08 7D 40 D3 69 01 08 8B E8 7B 40 B9 08 7D 40 D3 28 01 08 8B E8 63 00 F9 E8 63 40 F9 0B 01 00 11 E8 03 40 F9 0A 11 00 91 E9 0B 40 B9 E8 33 40 B9 28 01 08 0B 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 0B 01 00 B9 E8 63 40 F9 08 FD 60 D3 08 01 00 11 E8 7B 00 B9 D0 FF FF 17 E8 1F 40 F9 08 05 00 D1 E8 1F 00 F9 E9 0B 40 B9 E8 0F 40 B9 28 01 08 0B 08 05 00 51 E8 13 00 B9 E8 5F 40 F9 09 7D 60 D3 E8 1F 40 F9 08 01 00 11 08 7D 40 D3 28 01 08 8B E8 5F 00 F9 D5 FE FF 17 E8 13 40 B9 08 05 00 11 E8 5B 00 B9 04 00 00 14 E8 5B 40 B9 08 05 00 11 E8 5B 00 B9 E8 03 40 F9 08 01 00 91 09 01 40 B9 E8 5B 40 B9 1F 01 09 6B 62 01 00 54 E8 03 40 F9 0A 11 00 91 E8 5B 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 49 01 08 8B 08 00 80 52 28 01 00 B9 EE FF FF 17 E8 13 40 B9 09 05 00 11 E8 03 40 F9 08 01 00 91 09 01 00 B9 E8 03 40 F9 08 01 00 91 08 01 40 B9 1F 01 00 71 C0 02 00 54 E8 03 40 F9 0A 11 00 91 E8 03 40 F9 08 01 00 91 08 01 40 B9 08 05 00 51 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 08 01 40 B9 1F 01 00 71 21 01 00 54 E8 03 40 F9 08 01 00 91 08 01 40 B9 09 05 00 51 E8 03 40 F9 08 01 00 91 09 01 00 B9 E7 FF FF 17 E0 5F 40 F9 FF 43 19 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_83_0 {
	meta:
		name = "?exponent_bias@floating_point_value@__crt_strtox@@QEBAHXZ"
		size = 64
		altNames = "?maximum_binary_exponent@floating_point_value@__crt_strtox@@QEBAHXZ"
	strings:
		$1 = { FF 43 00 D1 E0 07 00 F9 E8 07 40 F9 08 21 00 91 08 01 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 7F 80 52 E8 03 00 B9 03 00 00 14 E8 0F 80 52 E8 03 00 B9 E0 03 40 B9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_84_0 {
	meta:
		name = "?get@?$c_string_character_source@D@__crt_strtox@@QEAADXZ"
		size = 68
	strings:
		$1 = { FF 43 00 D1 E0 07 00 F9 E8 07 40 F9 08 01 00 91 08 01 40 F9 08 01 C0 39 E8 03 00 39 E8 07 40 F9 08 01 00 91 08 01 40 F9 09 05 00 91 E8 07 40 F9 08 01 00 91 09 01 00 F9 E0 03 C0 39 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_85_0 {
	meta:
		name = "?get@?$c_string_character_source@_W@__crt_strtox@@QEAA_WXZ"
		size = 68
	strings:
		$1 = { FF 43 00 D1 E0 07 00 F9 E8 07 40 F9 08 01 00 91 08 01 40 F9 08 01 40 79 E8 03 00 79 E8 07 40 F9 08 01 00 91 08 01 40 F9 09 09 00 91 E8 07 40 F9 08 01 00 91 09 01 00 F9 E0 03 40 79 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_86_0 {
	meta:
		name = "?is_digit_or_nondigit@__crt_strtox@@YA_NH@Z"
		size = 136
	strings:
		$1 = { FF 43 00 D1 E0 03 00 B9 E8 03 40 B9 1F C1 00 71 CB 00 00 54 E8 03 40 B9 1F E5 00 71 6C 00 00 54 20 00 80 52 17 00 00 14 E8 03 40 B9 1F 85 01 71 CB 00 00 54 E8 03 40 B9 1F E9 01 71 6C 00 00 54 20 00 80 52 0F 00 00 14 E8 03 40 B9 1F 05 01 71 CB 00 00 54 E8 03 40 B9 1F 69 01 71 6C 00 00 54 20 00 80 52 07 00 00 14 E8 03 40 B9 1F 7D 01 71 61 00 00 54 20 00 80 52 02 00 00 14 00 00 80 52 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_87_0 {
	meta:
		name = "?is_double@floating_point_value@__crt_strtox@@QEBA_NXZ"
		size = 28
	strings:
		$1 = { FF 43 00 D1 E0 03 00 F9 E8 03 40 F9 08 21 00 91 00 01 40 39 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_88_0 {
	meta:
		name = "?is_space@__crt_strtox@@YA_NDQEAU__crt_locale_pointers@@@Z"
		size = 100
		refs = "0028 _ischartype_l"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 43 00 39 E1 13 00 F9 E8 43 C0 39 00 1D 00 53 00 00 00 11 E2 13 40 F9 01 01 80 52 00 00 00 11 ?? ?? ?? ?? E0 1B 00 B9 E8 1B 40 B9 1F 01 00 71 80 00 00 54 28 00 80 52 E8 17 00 B9 03 00 00 14 08 00 80 52 E8 17 00 B9 E8 17 40 B9 00 1D 00 53 00 00 00 11 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_89_0 {
	meta:
		name = "?is_space@__crt_strtox@@YA_N_WPEAU__crt_locale_pointers@@@Z"
		size = 84
		refs = "0018 iswctype"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 23 00 79 E1 13 00 F9 01 01 80 52 E0 23 40 79 ?? ?? ?? ?? E0 1B 00 B9 E8 1B 40 B9 1F 01 00 71 80 00 00 54 28 00 80 52 E8 17 00 B9 03 00 00 14 08 00 80 52 E8 17 00 B9 E8 17 40 B9 00 1D 00 53 00 00 00 11 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_90_0 {
	meta:
		name = "?make_big_integer@__crt_strtox@@YA?AUbig_integer@1@_K@Z"
		size = 136
		refs = "0008 __security_push_cookie 001c ??0big_integer@__crt_strtox@@QEAA@XZ 0070 ??0big_integer@__crt_strtox@@QEAA@AEBU01@@Z 007c __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 07 D1 E0 0B 00 F9 E1 07 00 F9 E0 63 00 91 ?? ?? ?? ?? E8 07 40 F9 08 7D 40 92 08 01 00 11 E8 1F 00 B9 E8 07 40 F9 08 FD 60 D3 08 01 00 11 E8 23 00 B9 E8 23 40 B9 1F 01 00 71 81 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 48 00 80 52 E8 03 00 B9 E8 03 40 B9 E8 1B 00 B9 E1 63 00 91 E0 0B 40 F9 ?? ?? ?? ?? E0 0B 40 F9 FF 83 07 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_91_0 {
	meta:
		name = "?mantissa_bits@floating_point_value@__crt_strtox@@QEBAHXZ"
		size = 64
	strings:
		$1 = { FF 43 00 D1 E0 07 00 F9 E8 07 40 F9 08 21 00 91 08 01 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 A8 06 80 52 E8 03 00 B9 03 00 00 14 08 03 80 52 E8 03 00 B9 E0 03 40 B9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_93_0 {
	meta:
		name = "?minimum_binary_exponent@floating_point_value@__crt_strtox@@QEBAHXZ"
		size = 64
	strings:
		$1 = { FF 43 00 D1 E0 07 00 F9 E8 07 40 F9 08 21 00 91 08 01 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 A8 7F 80 12 E8 03 00 B9 03 00 00 14 A8 0F 80 12 E8 03 00 B9 E0 03 40 B9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_94_0 {
	meta:
		name = "?multiply@__crt_strtox@@YA_NAEAUbig_integer@1@AEBU21@@Z"
		size = 1048
		refs = "0008 __security_push_cookie 003c ?multiply@__crt_strtox@@YA_NAEAUbig_integer@1@I@Z 0078 ??4big_integer@__crt_strtox@@QEAAAEAU01@AEBU01@@Z 01b4 ??0big_integer@__crt_strtox@@QEAA@XZ 0318 ?add_multiply_carry@__crt_strtox@@YAIAEAIIII@Z 03a8 ?add_carry@__crt_strtox@@YAIAEAIII@Z 040c __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 10 D1 E0 0F 00 F9 E1 17 00 F9 E8 17 40 F9 08 01 00 91 08 01 40 B9 1F 05 00 71 28 01 00 54 E8 17 40 F9 08 11 00 91 01 01 40 B9 E0 0F 40 F9 ?? ?? ?? ?? E0 43 00 39 E0 43 40 39 F0 00 00 14 E8 0F 40 F9 08 01 00 91 08 01 40 B9 1F 05 00 71 C8 01 00 54 E8 0F 40 F9 08 11 00 91 08 01 40 B9 E8 3F 00 B9 E1 17 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E1 3F 40 B9 E0 0F 40 F9 ?? ?? ?? ?? E0 47 00 39 E0 47 40 39 DE 00 00 14 E8 17 40 F9 0A 01 00 91 E8 0F 40 F9 08 01 00 91 09 01 40 B9 48 01 40 B9 1F 01 09 6B 82 00 00 54 28 00 80 52 E8 23 00 39 03 00 00 14 08 00 80 52 E8 23 00 39 E8 23 40 39 E8 03 00 39 E8 03 40 39 08 01 00 11 1F 01 00 71 A0 00 00 54 E8 17 40 F9 08 11 00 91 E8 2B 00 F9 04 00 00 14 E8 0F 40 F9 08 11 00 91 E8 2B 00 F9 E8 2B 40 F9 E8 33 00 F9 E8 03 40 39 08 01 00 11 1F 01 00 71 A0 00 00 54 E8 0F 40 F9 08 11 00 91 E8 2F 00 F9 04 00 00 14 E8 17 40 F9 08 11 00 91 E8 2F 00 F9 E8 2F 40 F9 E8 37 00 F9 E8 03 40 39 08 01 00 11 1F 01 00 71 C0 00 00 54 E8 17 40 F9 08 01 00 91 08 01 40 B9 E8 33 00 B9 05 00 00 14 E8 0F 40 F9 08 01 00 91 08 01 40 B9 E8 33 00 B9 E8 33 40 B9 E8 43 00 B9 E8 03 40 39 08 01 00 11 1F 01 00 71 C0 00 00 54 E8 0F 40 F9 08 01 00 91 08 01 40 B9 E8 37 00 B9 05 00 00 14 E8 17 40 F9 08 01 00 91 08 01 40 B9 E8 37 00 B9 E8 37 40 B9 E8 47 00 B9 E0 03 02 91 ?? ?? ?? ?? 08 00 80 52 E8 0F 00 B9 04 00 00 14 E8 0F 40 B9 08 05 00 11 E8 0F 00 B9 E9 43 40 B9 E8 0F 40 B9 1F 01 09 6B E0 10 00 54 E8 0F 40 B9 09 7D 40 D3 88 00 80 D2 29 7D 08 9B E8 33 40 F9 08 01 09 8B 08 01 40 B9 E8 3B 00 B9 E8 3B 40 B9 1F 01 00 71 21 02 00 54 E9 83 40 B9 E8 0F 40 B9 1F 01 09 6B 81 01 00 54 E8 0F 40 B9 09 7D 40 D3 88 00 80 D2 29 7D 08 9B E8 13 02 91 09 01 09 8B 08 00 80 52 28 01 00 B9 E8 0F 40 B9 08 05 00 11 E8 83 00 B9 DF FF FF 17 08 00 80 52 E8 23 00 B9 E8 0F 40 B9 E8 07 00 B9 08 00 80 52 E8 27 00 B9 07 00 00 14 E8 27 40 B9 08 05 00 11 E8 27 00 B9 E8 07 40 B9 08 05 00 11 E8 07 00 B9 E9 47 40 B9 E8 27 40 B9 1F 01 09 6B 00 05 00 54 E8 07 40 B9 1F CD 01 71 A0 04 00 54 E9 83 40 B9 E8 07 40 B9 1F 01 09 6B 81 01 00 54 E8 07 40 B9 09 7D 40 D3 88 00 80 D2 29 7D 08 9B E8 13 02 91 09 01 09 8B 08 00 80 52 28 01 00 B9 E8 07 40 B9 08 05 00 11 E8 83 00 B9 E8 27 40 B9 09 7D 40 D3 88 00 80 D2 29 7D 08 9B E8 37 40 F9 0A 01 09 8B E8 07 40 B9 09 7D 40 D3 88 00 80 D2 29 7D 08 9B E8 13 02 91 00 01 09 8B E3 23 40 B9 42 01 40 B9 E1 3B 40 B9 00 00 00 91 ?? ?? ?? ?? E0 4B 00 B9 E8 4B 40 B9 E8 23 00 B9 D0 FF FF 17 E8 23 40 B9 1F 01 00 71 A0 04 00 54 E8 07 40 B9 1F CD 01 71 40 04 00 54 E9 83 40 B9 E8 07 40 B9 1F 01 09 6B 81 01 00 54 E8 07 40 B9 09 7D 40 D3 88 00 80 D2 29 7D 08 9B E8 13 02 91 09 01 09 8B 08 00 80 52 28 01 00 B9 E8 07 40 B9 08 05 00 11 E8 83 00 B9 E8 07 40 B9 09 7D 40 D3 88 00 80 D2 29 7D 08 9B E8 13 02 91 08 01 09 8B E8 3B 00 F9 E2 23 40 B9 01 00 80 52 E0 3B 40 F9 ?? ?? ?? ?? E0 4F 00 B9 E8 4F 40 B9 E8 23 00 B9 E8 07 40 B9 08 05 00 11 E8 07 00 B9 DA FF FF 17 E8 07 40 B9 1F CD 01 71 21 01 00 54 E0 43 09 91 ?? ?? ?? ?? E0 3F 00 F9 E1 3F 40 F9 E0 0F 40 F9 ?? ?? ?? ?? 00 00 80 52 06 00 00 14 74 FF FF 17 E1 03 02 91 E0 0F 40 F9 ?? ?? ?? ?? 20 00 80 52 FF 83 10 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_95_0 {
	meta:
		name = "?multiply@__crt_strtox@@YA_NAEAUbig_integer@1@I@Z"
		size = 320
		refs = "0008 __security_push_cookie 0028 ??0big_integer@__crt_strtox@@QEAA@XZ 0038 ??4big_integer@__crt_strtox@@QEAAAEAU01@AEBU01@@Z 0090 ?multiply_core@__crt_strtox@@YAIQEAIII@Z 0134 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 03 0F D1 E0 03 00 F9 E1 0B 00 B9 E8 0B 40 B9 1F 01 00 71 21 01 00 54 E0 A3 00 91 ?? ?? ?? ?? E0 0F 00 F9 E1 0F 40 F9 E0 03 40 F9 ?? ?? ?? ?? 20 00 80 52 3C 00 00 14 E8 0B 40 B9 1F 05 00 71 61 00 00 54 20 00 80 52 37 00 00 14 E8 03 40 F9 08 01 00 91 08 01 40 B9 1F 01 00 71 61 00 00 54 20 00 80 52 30 00 00 14 E8 03 40 F9 09 01 00 91 E8 03 40 F9 00 11 00 91 E2 0B 40 B9 21 01 40 B9 00 00 00 91 ?? ?? ?? ?? E0 13 00 B9 E8 13 40 B9 E8 0F 00 B9 E8 0F 40 B9 1F 01 00 71 20 04 00 54 E8 03 40 F9 08 01 00 91 08 01 40 B9 1F CD 01 71 82 02 00 54 E8 03 40 F9 0A 11 00 91 E8 03 40 F9 08 01 00 91 08 01 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 49 01 08 8B E8 0F 40 B9 28 01 00 B9 E8 03 40 F9 08 01 00 91 08 01 40 B9 09 05 00 11 E8 03 40 F9 08 01 00 91 09 01 00 B9 09 00 00 14 E0 E3 07 91 ?? ?? ?? ?? E0 13 00 F9 E1 13 40 F9 E0 03 40 F9 ?? ?? ?? ?? 00 00 80 52 02 00 00 14 20 00 80 52 FF 03 0F 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_96_0 {
	meta:
		name = "?multiply_64_32@__crt_strtox@@YA_K_KI@Z"
		size = 40
	strings:
		$1 = { FF 43 00 D1 E0 07 00 F9 E1 03 00 B9 E8 03 40 B9 09 7D 40 D3 E8 07 40 F9 00 7D 09 9B 00 00 00 91 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_97_0 {
	meta:
		name = "?multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@1@I@Z"
		size = 560
		refs = "0008 __security_push_cookie 007c ?large_power_indices@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@2@I@Z@4QBUunpack_index@?1??12@YA_N0I@Z@B 0090 ??0big_integer@__crt_strtox@@QEAA@XZ 00d4 ?large_power_data@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@2@I@Z@4QBIB 010c memset 0158 memcpy 0164 ?multiply@__crt_strtox@@YA_NAEAUbig_integer@1@AEBU21@@Z 0190 ??4big_integer@__crt_strtox@@QEAAAEAU01@AEBU01@@Z 01e8 ?small_powers_of_ten@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAEAUbig_integer@2@I@Z@4QBIB 01fc ?multiply@__crt_strtox@@YA_NAEAUbig_integer@1@I@Z 0224 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 0F D1 E0 13 00 F9 E1 17 00 B9 E9 17 40 B9 48 01 80 52 28 09 C8 1A E8 07 00 B9 E8 07 40 B9 1F 01 00 71 00 0C 00 54 E8 07 40 B9 08 7D 40 D3 1F 99 00 F1 89 00 00 54 C8 04 80 D2 E8 17 00 F9 04 00 00 14 E8 07 40 B9 08 7D 40 D3 E8 17 00 F9 E8 17 40 F9 08 01 00 11 E8 13 00 B9 E8 13 40 B9 08 05 00 51 09 7D 40 D3 88 00 80 D2 29 7D 08 9B ?? ?? ?? ?? ?? ?? ?? ?? 08 01 09 8B E8 07 00 F9 E0 03 01 91 ?? ?? ?? ?? E8 07 40 F9 08 0D 00 91 09 01 40 39 29 01 00 11 E8 07 40 F9 08 09 00 91 08 01 40 39 08 01 00 11 28 01 08 0B E8 43 00 B9 E8 07 40 F9 08 01 00 91 08 01 40 79 09 01 00 11 88 00 80 D2 29 7D 08 9B ?? ?? ?? ?? ?? ?? ?? ?? 08 01 09 8B E8 1B 00 F9 E8 07 40 F9 08 09 00 91 08 01 40 39 08 01 00 11 09 7D 40 93 88 00 80 D2 22 7D 08 9B 42 00 00 91 01 00 80 52 E0 13 01 91 ?? ?? ?? ?? E8 07 40 F9 08 0D 00 91 08 01 40 39 08 01 00 11 09 7D 40 93 88 00 80 D2 22 7D 08 9B E8 07 40 F9 08 09 00 91 08 01 40 39 09 01 00 11 88 00 80 D2 29 7D 08 9B E8 13 01 91 00 01 09 8B 42 00 00 91 E1 1B 40 F9 00 00 00 91 ?? ?? ?? ?? E1 03 01 91 E0 13 40 F9 ?? ?? ?? ?? E0 03 00 39 E8 03 40 39 08 01 00 11 1F 01 00 71 21 01 00 54 E0 43 08 91 ?? ?? ?? ?? E0 1F 00 F9 E1 1F 40 F9 E0 13 40 F9 ?? ?? ?? ?? 00 00 80 52 22 00 00 14 E9 07 40 B9 E8 13 40 B9 28 01 08 4B E8 07 00 B9 9F FF FF 17 EA 17 40 B9 49 01 80 52 48 09 C9 1A 08 7D 09 1B 48 01 08 4B E8 1B 00 B9 E8 1B 40 B9 1F 01 00 71 60 02 00 54 E8 1B 40 B9 08 05 00 51 09 7D 40 D3 88 00 80 D2 29 7D 08 9B ?? ?? ?? ?? ?? ?? ?? ?? 08 01 09 8B 01 01 40 B9 E0 13 40 F9 ?? ?? ?? ?? E0 07 00 39 E8 07 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 00 00 80 52 02 00 00 14 20 00 80 52 FF 83 0F 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_98_0 {
	meta:
		name = "?multiply_core@__crt_strtox@@YAIQEAIII@Z"
		size = 192
	strings:
		$1 = { FF 83 00 D1 E0 0B 00 F9 E1 0B 00 B9 E2 0F 00 B9 08 00 80 52 E8 07 00 B9 08 00 80 52 E8 03 00 B9 04 00 00 14 E8 03 40 B9 08 05 00 11 E8 03 00 B9 E9 0B 40 B9 E8 03 40 B9 1F 01 09 6B C0 03 00 54 E8 03 40 B9 09 7D 40 D3 88 00 80 D2 29 7D 08 9B E8 0B 40 F9 08 01 09 8B 08 01 40 B9 09 7D 40 D3 E8 0F 40 B9 08 7D 40 D3 29 7D 08 9B E8 07 40 B9 08 7D 40 D3 28 01 08 8B E8 0F 00 F9 E8 0F 40 F9 0A 01 00 11 E8 03 40 B9 09 7D 40 D3 88 00 80 D2 29 7D 08 9B E8 0B 40 F9 08 01 09 8B 0A 01 00 B9 E8 0F 40 F9 08 FD 60 D3 08 01 00 11 E8 07 00 B9 DD FF FF 17 E0 07 40 B9 FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_99_0 {
	meta:
		name = "?normal_mantissa_mask@floating_point_value@__crt_strtox@@QEBA_KXZ"
		size = 64
	strings:
		$1 = { FF 43 00 D1 E0 07 00 F9 E8 07 40 F9 08 21 00 91 08 01 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 08 FC FF 92 E8 03 00 F9 03 00 00 14 E8 5F 40 B2 E8 03 00 F9 E0 03 40 F9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_100_0 {
	meta:
		name = "?parse_digit@__crt_strtox@@YAID@Z"
		size = 184
	strings:
		$1 = { FF 43 00 D1 E0 03 00 39 E8 03 C0 39 08 01 00 11 1F C1 00 71 4B 01 00 54 E8 03 C0 39 08 01 00 11 1F E5 00 71 CC 00 00 54 E8 03 C0 39 08 01 00 11 00 C1 00 51 00 00 00 11 1E 00 00 14 E8 03 C0 39 08 01 00 11 1F 85 01 71 6B 01 00 54 E8 03 C0 39 08 01 00 11 1F E9 01 71 EC 00 00 54 E8 03 C0 39 08 01 00 11 08 85 01 51 00 29 00 11 00 00 00 11 10 00 00 14 E8 03 C0 39 08 01 00 11 1F 05 01 71 6B 01 00 54 E8 03 C0 39 08 01 00 11 1F 69 01 71 EC 00 00 54 E8 03 C0 39 08 01 00 11 08 05 01 51 00 29 00 11 00 00 00 11 02 00 00 14 00 00 80 12 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_101_0 {
	meta:
		name = "?parse_digit@__crt_strtox@@YAI_W@Z"
		size = 224
		refs = "0010 ?wide_character_to_digit@__crt_strtox@@YAH_W@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 23 00 79 E0 23 40 79 ?? ?? ?? ?? E0 1F 00 B9 E8 1F 40 B9 E8 17 00 B9 E8 17 40 B9 1F 05 00 31 60 00 00 54 E0 17 40 B9 2A 00 00 14 E9 23 40 79 29 01 00 11 28 08 80 52 1F 01 09 6B AC 00 00 54 E8 23 40 79 08 01 00 11 1F 69 01 71 4D 01 00 54 E9 23 40 79 29 01 00 11 28 0C 80 52 1F 01 09 6B 6C 03 00 54 E8 23 40 79 08 01 00 11 1F E9 01 71 EC 02 00 54 E8 23 40 79 08 01 00 11 1F 85 01 71 6B 01 00 54 E8 23 40 79 08 01 00 11 1F E9 01 71 EC 00 00 54 E8 23 40 79 08 01 00 11 08 85 01 51 08 05 01 11 E8 1B 00 B9 04 00 00 14 E8 23 40 79 08 01 00 11 E8 1B 00 B9 E8 1B 40 B9 08 05 01 51 00 29 00 11 00 00 00 11 02 00 00 14 00 00 80 12 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_102_0 {
	meta:
		name = "?restore_state@?$c_string_character_source@D@__crt_strtox@@QEAA_NQEBD@Z"
		size = 40
		altNames = "?restore_state@?$c_string_character_source@_W@__crt_strtox@@QEAA_NQEB_W@Z"
	strings:
		$1 = { FF 43 00 D1 E0 03 00 F9 E1 07 00 F9 E8 03 40 F9 09 01 00 91 E8 07 40 F9 28 01 00 F9 20 00 80 52 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_104_0 {
	meta:
		name = "?right_shift_with_rounding@__crt_strtox@@YA_K_N_KI0@Z"
		size = 348
		refs = "0128 ?should_round_up@__crt_strtox@@YA_N_N000@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 5F 00 39 E1 13 00 F9 E2 1F 00 B9 E3 4F 00 39 E8 1F 40 B9 08 7D 40 D3 1F 01 01 F1 63 00 00 54 00 00 80 D2 4A 00 00 14 E8 1F 40 B9 08 05 00 51 09 7D 40 D3 28 00 80 D2 08 21 C9 9A 08 05 00 D1 E8 1F 00 F9 E8 1F 40 B9 08 05 00 51 09 7D 40 D3 28 00 80 D2 08 21 C9 9A E8 1B 00 F9 E8 1F 40 B9 09 7D 40 D3 28 00 80 D2 08 21 C9 9A E8 17 00 F9 E9 13 40 F9 E8 17 40 F9 28 01 08 8A 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 43 00 39 03 00 00 14 08 00 80 52 E8 43 00 39 E8 43 40 39 E8 5B 00 39 E9 13 40 F9 E8 1B 40 F9 28 01 08 8A 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 47 00 39 03 00 00 14 08 00 80 52 E8 47 00 39 E8 47 40 39 E8 57 00 39 E8 4F 40 39 08 01 00 11 1F 01 00 71 20 01 00 54 E9 13 40 F9 E8 1F 40 F9 28 01 08 8A 1F 01 00 F1 81 00 00 54 08 00 80 52 E8 4B 00 39 03 00 00 14 28 00 80 52 E8 4B 00 39 E8 4B 40 39 E8 53 00 39 E3 53 40 39 E2 57 40 39 E1 5B 40 39 E0 5F 40 39 ?? ?? ?? ?? E0 63 00 39 E8 1F 40 B9 09 7D 40 D3 E8 13 40 F9 09 25 C9 9A E8 63 40 39 08 01 00 11 08 7D 40 93 20 01 08 8B 00 00 00 91 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_105_0 {
	meta:
		name = "?save_state@?$c_string_character_source@D@__crt_strtox@@QEBAPEBDXZ"
		size = 28
		altNames = "??C__crt_stdio_stream@@QEBAPEAU__crt_stdio_stream_data@@XZ ?begin@?$argument_list@D@?A0x5f5c8891@@QEBAPEAPEADXZ ?begin@?$argument_list@_W@?A0x5f5c8891@@QEBAPEAPEA_WXZ ?get@?$__crt_scoped_stack_ptr@D@@QEBAPEADXZ ?get@?$__crt_scoped_stack_ptr@_W@@QEBAPEA_WXZ ?get@?$__crt_unique_handle_t@U__crt_findfile_traits@@@@QEBAPEAXXZ ?get@?$__crt_unique_handle_t@U__crt_handle_traits@@@@QEBAPEAXXZ ?get@?$__crt_unique_handle_t@U__crt_hmodule_traits@@@@QEBAPEAUHINSTANCE__@@XZ ?get@?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QEBAPEBDXZ ?get@?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QEBAPEB_WXZ ?get@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEBAPEADXZ ?get@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEBAPEADXZ ?get@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEBAPEAEXZ ?get@?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEBAPEAPEADXZ ?get@?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEBAPEAPEA_WXZ ?get@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@D@@U__crt_internal_free_policy@@@@QEBAPEAU?$__crt_report_hook_node@D@@XZ ?get@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@_W@@U__crt_internal_free_policy@@@@QEBAPEAU?$__crt_report_hook_node@_W@@XZ ?get@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QEBAPEAU__acrt_ptd@@XZ ?get@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QEBAPEAU__acrt_thread_parameter@@XZ ?get@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QEBAPEAU__crt_lc_time_data@@XZ ?get@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QEBAPEAU__crt_locale_data@@XZ ?get@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QEBAPEAU__crt_locale_pointers@@XZ ?get@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QEBAPEAU__crt_lowio_handle_data@@XZ ?get@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QEBAPEAU__crt_multibyte_data@@XZ ?get@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEBAPEA_WXZ ?get@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QEBAPEA_WXZ ?save_state@?$c_string_character_source@_W@__crt_strtox@@QEBAPEB_WXZ"
	strings:
		$1 = { FF 43 00 D1 E0 03 00 F9 E8 03 40 F9 08 01 00 91 00 01 40 F9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_107_0 {
	meta:
		name = "?shift_left@__crt_strtox@@YA_NAEAUbig_integer@1@I@Z"
		size = 1012
		refs = "0008 __security_push_cookie 00b4 ?bit_scan_reverse@__crt_strtox@@YAII@Z 0194 ??0big_integer@__crt_strtox@@QEAA@XZ 01a4 ??4big_integer@__crt_strtox@@QEAAAEAU01@AEBU01@@Z 03e8 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 03 09 D1 E0 0B 00 F9 E1 23 00 B9 E9 23 40 B9 08 04 80 52 28 09 C8 1A E8 07 00 B9 EA 23 40 B9 09 04 80 52 48 09 C9 1A 08 7D 09 1B 48 01 08 4B E8 27 00 B9 28 00 80 D2 E8 3B 00 F9 E8 27 40 B9 E8 43 00 B9 09 04 80 52 E8 43 40 B9 28 01 08 4B E8 47 00 B9 E8 47 40 B9 09 7D 40 D3 28 00 80 D2 08 21 C9 9A 08 05 00 D1 08 01 00 11 E8 3F 00 B9 E8 3F 40 B9 E8 03 28 2A E8 5B 00 B9 E8 0B 40 F9 0A 11 00 91 E8 0B 40 F9 08 01 00 91 08 01 40 B9 08 05 00 51 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 00 01 40 B9 ?? ?? ?? ?? E0 4F 00 B9 09 04 80 52 E8 4F 40 B9 29 01 08 4B E8 27 40 B9 1F 01 09 6B 89 00 00 54 28 00 80 52 E8 03 00 39 03 00 00 14 08 00 80 52 E8 03 00 39 E8 03 40 39 E8 0F 00 39 E8 0B 40 F9 08 01 00 91 09 01 40 B9 E8 07 40 B9 28 01 08 0B 1F CD 01 71 89 00 00 54 28 00 80 52 E8 07 00 39 03 00 00 14 08 00 80 52 E8 07 00 39 E8 07 40 39 E8 23 00 39 E8 0B 40 F9 08 01 00 91 09 01 40 B9 E8 07 40 B9 28 01 08 0B 1F CD 01 71 01 01 00 54 E8 0F 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 0B 00 39 03 00 00 14 08 00 80 52 E8 0B 00 39 E8 0B 40 39 E8 27 00 39 E8 23 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E8 27 40 39 08 01 00 11 1F 01 00 71 20 01 00 54 E0 E3 01 91 ?? ?? ?? ?? E0 37 00 F9 E1 37 40 F9 E0 0B 40 F9 ?? ?? ?? ?? 00 00 80 52 8E 00 00 14 E8 0B 40 F9 08 01 00 91 09 01 40 B9 E8 07 40 B9 28 01 08 0B 1F C9 01 71 02 01 00 54 E8 0B 40 F9 08 01 00 91 09 01 40 B9 E8 07 40 B9 28 01 08 0B E8 2B 00 B9 03 00 00 14 48 0E 80 52 E8 2B 00 B9 E8 2B 40 B9 E8 1F 00 B9 E8 1F 40 B9 E8 0F 00 B9 04 00 00 14 E8 0F 40 B9 08 05 00 51 E8 0F 00 B9 E8 0F 40 B9 1F 05 00 31 00 0A 00 54 E9 07 40 B9 E8 0F 40 B9 1F 01 09 6B 83 09 00 54 E9 0F 40 B9 E8 07 40 B9 28 01 08 4B E8 2F 00 B9 E9 0F 40 B9 E8 07 40 B9 28 01 08 4B 08 05 00 51 E8 37 00 B9 E8 0B 40 F9 08 01 00 91 09 01 40 B9 E8 2F 40 B9 1F 01 09 6B 62 01 00 54 E8 0B 40 F9 0A 11 00 91 E8 2F 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 08 01 40 B9 E8 33 00 B9 03 00 00 14 08 00 80 52 E8 33 00 B9 E8 33 40 B9 E8 53 00 B9 E8 0B 40 F9 08 01 00 91 09 01 40 B9 E8 37 40 B9 1F 01 09 6B 62 01 00 54 E8 0B 40 F9 0A 11 00 91 E8 37 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 48 01 08 8B 08 01 40 B9 E8 3B 00 B9 03 00 00 14 08 00 80 52 E8 3B 00 B9 E8 3B 40 B9 E8 57 00 B9 E9 53 40 B9 E8 3F 40 B9 29 01 08 0A E8 43 40 B9 28 21 C8 1A E8 5F 00 B9 E9 57 40 B9 E8 5B 40 B9 29 01 08 0A E8 47 40 B9 28 25 C8 1A E8 63 00 B9 E9 5F 40 B9 E8 63 40 B9 28 01 08 2A E8 67 00 B9 E8 0B 40 F9 0A 11 00 91 E8 0F 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 49 01 08 8B E8 67 40 B9 28 01 00 B9 AC FF FF 17 08 00 80 52 E8 1B 00 B9 04 00 00 14 E8 1B 40 B9 08 05 00 11 E8 1B 00 B9 E9 07 40 B9 E8 1B 40 B9 1F 01 09 6B 60 01 00 54 E8 0B 40 F9 0A 11 00 91 E8 1B 40 B9 09 7D 40 D3 88 00 80 D2 28 7D 08 9B 49 01 08 8B 08 00 80 52 28 01 00 B9 F0 FF FF 17 E8 0F 40 39 08 01 00 11 1F 01 00 71 A0 00 00 54 E8 1F 40 B9 08 05 00 11 E8 4B 00 B9 03 00 00 14 E8 1F 40 B9 E8 4B 00 B9 E8 0B 40 F9 09 01 00 91 E8 4B 40 B9 28 01 00 B9 20 00 80 52 FF 03 09 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_108_0 {
	meta:
		name = "?should_round_up@__crt_strtox@@YA_N_N000@Z"
		size = 432
		refs = "006c fegetround 0164 ??_C@_1EI@OBAKGPDD@?$AA?$CI?$AA?$CC?$AAu?$AAn?$AAe?$AAx?$AAp?$AAe?$AAc?$AAt?$AAe?$AAd?$AA?5?$AAr?$AAo?$AAu?$AAn?$AAd?$AAi?$AAn?$AAg?$AA?5?$AAm?$AAo?$AAd?$AAe?$AA?$CC?$AA?0?$AA?5?$AAf?$AAa?$AAl@ 016c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 017c ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0188 _CrtDbgReportW"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 4F 00 39 E1 57 00 39 E2 47 00 39 E3 4B 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 01 01 00 54 E8 4B 40 39 08 01 00 11 1F 01 00 71 81 00 00 54 28 00 80 52 E8 43 00 39 03 00 00 14 08 00 80 52 E8 43 00 39 E8 43 40 39 E8 53 00 39 E8 53 40 39 08 01 00 11 1F 01 00 71 60 00 00 54 00 00 80 52 50 00 00 14 ?? ?? ?? ?? E0 27 00 B9 E8 27 40 B9 E8 1B 00 B9 E8 1B 40 B9 1F 01 08 71 6C 01 00 54 E8 1B 40 B9 1F 01 08 71 20 04 00 54 E8 1B 40 B9 1F 01 00 71 20 01 00 54 E8 1B 40 B9 1F 01 04 71 00 05 00 54 2B 00 00 14 E8 1B 40 B9 1F 01 0C 71 C0 04 00 54 27 00 00 14 E8 47 40 39 08 01 00 11 1F 01 00 71 80 01 00 54 E8 4B 40 39 08 01 00 11 1F 01 00 71 A1 00 00 54 E8 57 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 1F 00 B9 03 00 00 14 08 00 80 52 E8 1F 00 B9 E8 1F 40 B9 00 1D 00 53 00 00 00 11 26 00 00 14 E8 4F 40 39 08 01 00 11 1F 01 00 71 81 00 00 54 28 00 80 52 E8 23 00 B9 03 00 00 14 08 00 80 52 E8 23 00 B9 E8 23 40 B9 00 1D 00 53 00 00 00 11 19 00 00 14 E0 4F 40 39 17 00 00 14 00 00 80 52 15 00 00 14 08 00 80 52 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 02 4C 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 2B 00 B9 E9 2B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 00 00 80 52 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_109_0 {
	meta:
		name = "?unget@?$c_string_character_source@D@__crt_strtox@@QEAAXD@Z"
		size = 276
		refs = "0088 ??_C@_1CM@GJENOOEJ@?$AAc?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA?8?$AA?2?$AA0?$AA?8?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CK?$AA_?$AAp?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAc?$AA?$AA@ 0090 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00a0 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 00ac _CrtDbgReportW 00d4 _errno 00f8 ??_C@_1GK@MNHIDABG@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAc?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA_?$AAc?$AAh?$AAa?$AAr?$AAa?$AAc?$AAt?$AAe?$AAr@ 0108 _invalid_parameter"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 43 00 39 E8 13 40 F9 08 01 00 91 08 01 40 F9 09 05 00 D1 E8 13 40 F9 08 01 00 91 09 01 00 F9 E8 43 C0 39 08 01 00 11 1F 01 00 71 A0 01 00 54 E8 13 40 F9 08 01 00 91 08 01 40 F9 09 01 C0 39 29 01 00 11 E8 43 C0 39 08 01 00 11 3F 01 08 6B 80 00 00 54 08 00 80 52 E8 17 00 B9 03 00 00 14 28 00 80 52 E8 17 00 B9 E8 17 40 B9 E8 1B 00 B9 E8 1B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 02 DF 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1F 00 B9 E9 1F 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 1B 40 B9 1F 01 00 71 E1 01 00 54 ?? ?? ?? ?? E0 17 00 F9 E9 17 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 03 DF 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_110_0 {
	meta:
		name = "?unget@?$c_string_character_source@_W@__crt_strtox@@QEAAX_W@Z"
		size = 276
		refs = "0088 ??_C@_1CM@GJENOOEJ@?$AAc?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA?8?$AA?2?$AA0?$AA?8?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CK?$AA_?$AAp?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAc?$AA?$AA@ 0090 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00a0 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 00ac _CrtDbgReportW 00d4 _errno 00f8 ??_C@_1HA@CONLANFI@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAc?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA_?$AAc?$AAh?$AAa?$AAr?$AAa?$AAc?$AAt?$AAe?$AAr@ 0108 _invalid_parameter"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 23 00 79 E8 13 40 F9 08 01 00 91 08 01 40 F9 09 09 00 D1 E8 13 40 F9 08 01 00 91 09 01 00 F9 E8 23 40 79 08 01 00 11 1F 01 00 71 A0 01 00 54 E8 13 40 F9 08 01 00 91 08 01 40 F9 09 01 40 79 29 01 00 11 E8 23 40 79 08 01 00 11 3F 01 08 6B 80 00 00 54 08 00 80 52 E8 17 00 B9 03 00 00 14 28 00 80 52 E8 17 00 B9 E8 17 40 B9 E8 1B 00 B9 E8 1B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 02 DF 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1F 00 B9 E9 1F 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 1B 40 B9 1F 01 00 71 E1 01 00 54 ?? ?? ?? ?? E0 17 00 F9 E9 17 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 03 DF 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_111_0 {
	meta:
		name = "?validate@?$c_string_character_source@D@__crt_strtox@@QEBA_NXZ"
		size = 224
		refs = "0048 ??_C@_1BM@PNEBBBDO@?$AA_?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0050 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0060 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 0094 _errno 00b8 ??_C@_1HA@MKKIHBHP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAc?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA_?$AAc?$AAh?$AAa?$AAr?$AAa?$AAc?$AAt?$AAe?$AAr@ 00c8 _invalid_parameter"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E8 13 40 F9 08 01 00 91 08 01 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 13 00 B9 03 00 00 14 08 00 80 52 E8 13 00 B9 E8 13 40 B9 E8 17 00 B9 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 DD 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 17 00 F9 E9 17 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 83 DD 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 02 00 00 14 20 00 80 52 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_112_0 {
	meta:
		name = "?validate@?$c_string_character_source@_W@__crt_strtox@@QEBA_NXZ"
		size = 224
		refs = "0048 ??_C@_1BM@PNEBBBDO@?$AA_?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0050 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0060 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 0094 _errno 00b8 ??_C@_1HG@FCDBLOEG@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAc?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA_?$AAc?$AAh?$AAa?$AAr?$AAa?$AAc?$AAt?$AAe?$AAr@ 00c8 _invalid_parameter"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E8 13 40 F9 08 01 00 91 08 01 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 13 00 B9 03 00 00 14 08 00 80 52 E8 13 00 B9 E8 13 40 B9 E8 17 00 B9 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 DD 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 17 00 F9 E9 17 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 83 DD 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 02 00 00 14 20 00 80 52 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_113_0 {
	meta:
		name = "?wide_character_to_digit@__crt_strtox@@YAH_W@Z"
		size = 1148
	strings:
		$1 = { FF 43 00 D1 E0 03 00 79 E8 03 40 79 08 01 00 11 1F C1 00 71 6A 00 00 54 00 00 80 12 16 01 00 14 E8 03 40 79 08 01 00 11 1F E9 00 71 CA 00 00 54 E8 03 40 79 08 01 00 11 00 C1 00 51 00 00 00 11 0D 01 00 14 E9 03 40 79 29 01 00 11 08 E2 9F 52 3F 01 08 6B 8A 1F 00 54 E8 03 40 79 08 01 00 11 1F 81 19 71 6A 00 00 54 00 00 80 12 02 01 00 14 E8 03 40 79 08 01 00 11 1F A9 19 71 CA 00 00 54 E8 03 40 79 08 01 00 11 00 81 19 51 00 00 00 11 F9 00 00 14 E8 03 40 79 08 01 00 11 1F C1 1B 71 6A 00 00 54 00 00 80 12 F3 00 00 14 E8 03 40 79 08 01 00 11 1F E9 1B 71 CA 00 00 54 E8 03 40 79 08 01 00 11 00 C1 1B 51 00 00 00 11 EA 00 00 14 E8 03 40 79 08 01 00 11 1F 99 25 71 6A 00 00 54 00 00 80 12 E4 00 00 14 E8 03 40 79 08 01 00 11 1F C1 25 71 CA 00 00 54 E8 03 40 79 08 01 00 11 00 99 25 51 00 00 00 11 DB 00 00 14 E8 03 40 79 08 01 00 11 1F 99 27 71 6A 00 00 54 00 00 80 12 D5 00 00 14 E8 03 40 79 08 01 00 11 1F C1 27 71 CA 00 00 54 E8 03 40 79 08 01 00 11 00 99 27 51 00 00 00 11 CC 00 00 14 E8 03 40 79 08 01 00 11 1F 99 29 71 6A 00 00 54 00 00 80 12 C6 00 00 14 E8 03 40 79 08 01 00 11 1F C1 29 71 CA 00 00 54 E8 03 40 79 08 01 00 11 00 99 29 51 00 00 00 11 BD 00 00 14 E8 03 40 79 08 01 00 11 1F 99 2B 71 6A 00 00 54 00 00 80 12 B7 00 00 14 E8 03 40 79 08 01 00 11 1F C1 2B 71 CA 00 00 54 E8 03 40 79 08 01 00 11 00 99 2B 51 00 00 00 11 AE 00 00 14 E8 03 40 79 08 01 00 11 1F 99 2D 71 6A 00 00 54 00 00 80 12 A8 00 00 14 E8 03 40 79 08 01 00 11 1F C1 2D 71 CA 00 00 54 E8 03 40 79 08 01 00 11 00 99 2D 51 00 00 00 11 9F 00 00 14 E8 03 40 79 08 01 00 11 1F 99 31 71 6A 00 00 54 00 00 80 12 99 00 00 14 E8 03 40 79 08 01 00 11 1F C1 31 71 CA 00 00 54 E8 03 40 79 08 01 00 11 00 99 31 51 00 00 00 11 90 00 00 14 E8 03 40 79 08 01 00 11 1F 99 33 71 6A 00 00 54 00 00 80 12 8A 00 00 14 E8 03 40 79 08 01 00 11 1F C1 33 71 CA 00 00 54 E8 03 40 79 08 01 00 11 00 99 33 51 00 00 00 11 81 00 00 14 E8 03 40 79 08 01 00 11 1F 99 35 71 6A 00 00 54 00 00 80 12 7B 00 00 14 E8 03 40 79 08 01 00 11 1F C1 35 71 CA 00 00 54 E8 03 40 79 08 01 00 11 00 99 35 51 00 00 00 11 72 00 00 14 E8 03 40 79 08 01 00 11 1F 41 39 71 6A 00 00 54 00 00 80 12 6C 00 00 14 E8 03 40 79 08 01 00 11 1F 69 39 71 CA 00 00 54 E8 03 40 79 08 01 00 11 00 41 39 51 00 00 00 11 63 00 00 14 E8 03 40 79 08 01 00 11 1F 41 3B 71 6A 00 00 54 00 00 80 12 5D 00 00 14 E8 03 40 79 08 01 00 11 1F 69 3B 71 CA 00 00 54 E8 03 40 79 08 01 00 11 00 41 3B 51 00 00 00 11 54 00 00 14 E8 03 40 79 08 01 00 11 1F 81 3C 71 6A 00 00 54 00 00 80 12 4E 00 00 14 E8 03 40 79 08 01 00 11 1F A9 3C 71 CA 00 00 54 E8 03 40 79 08 01 00 11 00 81 3C 51 00 00 00 11 45 00 00 14 E9 03 40 79 29 01 00 11 08 08 82 52 3F 01 08 6B 6A 00 00 54 00 00 80 12 3E 00 00 14 E9 03 40 79 29 01 00 11 48 09 82 52 3F 01 08 6B EA 00 00 54 E9 03 40 79 29 01 00 11 08 08 82 52 20 01 08 4B 00 00 00 11 33 00 00 14 E9 03 40 79 29 01 00 11 08 FC 82 52 3F 01 08 6B 6A 00 00 54 00 00 80 12 2C 00 00 14 E9 03 40 79 29 01 00 11 48 FD 82 52 3F 01 08 6B EA 00 00 54 E9 03 40 79 29 01 00 11 08 FC 82 52 20 01 08 4B 00 00 00 11 21 00 00 14 E9 03 40 79 29 01 00 11 08 02 83 52 3F 01 08 6B 6A 00 00 54 00 00 80 12 1A 00 00 14 E9 03 40 79 29 01 00 11 48 03 83 52 3F 01 08 6B EA 00 00 54 E9 03 40 79 29 01 00 11 08 02 83 52 20 01 08 4B 00 00 00 11 0F 00 00 14 00 00 80 12 0D 00 00 14 E9 03 40 79 29 01 00 11 48 E3 9F 52 3F 01 08 6B EA 00 00 54 E9 03 40 79 29 01 00 11 08 E2 9F 52 20 01 08 4B 00 00 00 11 02 00 00 14 00 00 80 12 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_114_0 {
	meta:
		name = "__acrt_get_locale_data_prefix"
		size = 36
	strings:
		$1 = { FF 43 00 D1 E0 03 00 F9 E8 03 40 F9 E8 07 00 F9 E8 07 40 F9 08 01 00 91 00 01 40 F9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_116_0 {
	meta:
		name = "_chvalidchk_l"
		size = 52
		refs = "0020 _chvalidator_l"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 B9 E1 13 00 B9 E2 13 00 F9 E2 13 40 B9 E1 17 40 B9 E0 13 40 F9 ?? ?? ?? ?? E0 1B 00 B9 E0 1B 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_117_0 {
	meta:
		name = "_ischartype_l"
		size = 124
		refs = "0024 __acrt_get_locale_data_prefix 004c _isctype_l 0068 _chvalidchk_l"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 B9 E1 13 00 B9 E2 13 00 F9 E8 13 40 F9 1F 01 00 F1 00 02 00 54 E0 13 40 F9 ?? ?? ?? ?? E0 17 00 F9 E8 17 40 F9 08 21 00 91 08 01 40 B9 1F 05 00 71 0D 01 00 54 E2 13 40 F9 E1 13 40 B9 E0 17 40 B9 ?? ?? ?? ?? E0 1B 00 B9 E0 1B 40 B9 07 00 00 14 E2 13 40 F9 E1 13 40 B9 E0 17 40 B9 ?? ?? ?? ?? E0 1F 00 B9 E0 1F 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_118_0 {
	meta:
		name = "_strtod_l"
		size = 52
		refs = "0020 ??$common_strtod_l@ND@@YANQEBDQEAPEADQEAU__crt_locale_pointers@@@Z"
		altNames = "_strtold_l"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E2 0B 00 F9 E2 0B 40 F9 E1 0F 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 17 00 FD E0 17 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_121_0 {
	meta:
		name = "_wcstod_l"
		size = 52
		refs = "0020 ??$common_strtod_l@N_W@@YANQEB_WQEAPEA_WQEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E2 0B 00 F9 E2 0B 40 F9 E1 0F 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 17 00 FD E0 17 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_123_0 {
	meta:
		name = "_wcstold_l"
		size = 52
		refs = "0020 ??$common_strtod_l@N_W@@YANQEB_WQEAPEA_WQEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E2 0B 00 F9 E2 0B 40 F9 E1 0F 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 17 00 FD E0 17 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_119_0 {
	meta:
		name = "_strtof_l"
		size = 52
		refs = "0020 ??$common_strtod_l@MD@@YAMQEBDQEAPEADQEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 BD E0 13 40 BD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_122_0 {
	meta:
		name = "_wcstof_l"
		size = 52
		refs = "0020 ??$common_strtod_l@M_W@@YAMQEB_WQEAPEA_WQEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 13 00 BD E0 13 40 BD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_124_0 {
	meta:
		name = "memcpy_s"
		size = 380
		refs = "0060 _errno 0074 _invalid_parameter_noinfo 00a8 memset 016c memcpy"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 27 00 F9 E1 1F 00 F9 E2 23 00 F9 E3 13 00 F9 E8 13 40 F9 1F 01 00 F1 61 00 00 54 00 00 80 52 53 00 00 14 E8 27 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 13 00 B9 03 00 00 14 08 00 80 52 E8 13 00 B9 E8 13 40 B9 E8 2B 00 B9 E8 2B 40 B9 1F 01 00 71 21 01 00 54 ?? ?? ?? ?? E0 2B 00 F9 E9 2B 40 F9 C8 02 80 52 28 01 00 B9 ?? ?? ?? ?? C0 02 80 52 3E 00 00 14 E8 23 40 F9 1F 01 00 F1 A0 00 00 54 E9 13 40 F9 E8 1F 40 F9 1F 01 09 EB 42 06 00 54 E2 1F 40 F9 01 00 80 52 E0 27 40 F9 ?? ?? ?? ?? E8 23 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 17 00 B9 03 00 00 14 08 00 80 52 E8 17 00 B9 E8 17 40 B9 E8 2F 00 B9 E8 2F 40 B9 1F 01 00 71 21 01 00 54 ?? ?? ?? ?? E0 2F 00 F9 E9 2F 40 F9 C8 02 80 52 28 01 00 B9 ?? ?? ?? ?? C0 02 80 52 1E 00 00 14 E9 13 40 F9 E8 1F 40 F9 1F 01 09 EB 83 00 00 54 28 00 80 52 E8 1B 00 B9 03 00 00 14 08 00 80 52 E8 1B 00 B9 E8 1B 40 B9 E8 33 00 B9 E8 33 40 B9 1F 01 00 71 21 01 00 54 ?? ?? ?? ?? E0 33 00 F9 E9 33 40 F9 48 04 80 52 28 01 00 B9 ?? ?? ?? ?? 40 04 80 52 08 00 00 14 C0 02 80 52 06 00 00 14 E2 13 40 F9 E1 23 40 F9 E0 27 40 F9 ?? ?? ?? ?? 00 00 80 52 FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_125_0 {
	meta:
		name = "strtod"
		size = 48
		refs = "001c ??$common_strtod_l@ND@@YANQEBDQEAPEADQEAU__crt_locale_pointers@@@Z"
		altNames = "strtold"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 0B 00 F9 02 00 80 D2 E1 0B 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 FD E0 13 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_128_0 {
	meta:
		name = "wcstod"
		size = 48
		refs = "001c ??$common_strtod_l@N_W@@YANQEB_WQEAPEA_WQEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 0B 00 F9 02 00 80 D2 E1 0B 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 FD E0 13 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_130_0 {
	meta:
		name = "wcstold"
		size = 48
		refs = "001c ??$common_strtod_l@N_W@@YANQEB_WQEAPEA_WQEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 0B 00 F9 02 00 80 D2 E1 0B 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 FD E0 13 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_126_0 {
	meta:
		name = "strtof"
		size = 48
		refs = "001c ??$common_strtod_l@MD@@YAMQEBDQEAPEADQEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 02 00 80 D2 E1 0F 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 13 00 BD E0 13 40 BD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_129_0 {
	meta:
		name = "wcstof"
		size = 48
		refs = "001c ??$common_strtod_l@M_W@@YAMQEB_WQEAPEA_WQEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 02 00 80 D2 E1 0F 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 13 00 BD E0 13 40 BD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_24_5_0 {
	meta:
		name = "_mbsdec_l"
		size = 328
		refs = "0018 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 001c ??_C@_1CE@BLLJFLOH@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0020 ??_C@_1GO@DDOMFNGF@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 003c _CrtDbgReportW 004c _errno 0060 ??_C@_1BE@KLNCOLCD@?$AA_?$AAm?$AAb?$AAs?$AAd?$AAe?$AAc?$AA_?$AAl?$AA?$AA@ 0070 _invalid_parameter 0084 ??_C@_1CG@CMGPGAOD@?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 00dc ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 33 00 00 91 54 03 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 02 06 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 03 06 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? 00 00 80 D2 31 00 00 14 93 02 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 22 06 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 23 06 80 52 ?? ?? ?? ?? E6 FF FF 17 9F 02 13 EB 22 FD FF 54 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? EC 13 40 F9 88 09 40 B9 68 00 00 35 60 06 00 D1 0D 00 00 14 6B 06 00 D1 6B 05 00 D1 9F 02 0B EB A8 00 00 54 69 01 40 39 29 01 0C 8B 2A 65 40 39 4A FF 17 37 68 02 0B CB 09 01 40 92 6A 02 09 CB 40 05 00 D1 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_25_4_0 {
	meta:
		name = "_mbsupr"
		size = 56
		refs = "0020 _mbsupr_s_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 7F 02 00 F1 08 00 80 92 E1 03 88 9A 02 00 80 D2 ?? ?? ?? ?? 1F 00 00 71 60 02 9F 9A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_623_4_0 {
	meta:
		name = "_mbslwr"
		size = 56
		refs = "0020 _mbslwr_s_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 7F 02 00 F1 08 00 80 92 E1 03 88 9A 02 00 80 D2 ?? ?? ?? ?? 1F 00 00 71 60 02 9F 9A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_25_5_0 {
	meta:
		name = "_mbsupr_l"
		size = 56
		refs = "0020 _mbsupr_s_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 7F 02 00 F1 08 00 80 92 22 00 00 91 E1 03 88 9A ?? ?? ?? ?? 1F 00 00 71 60 02 9F 9A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_623_5_0 {
	meta:
		name = "_mbslwr_l"
		size = 56
		refs = "0020 _mbslwr_s_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 7F 02 00 F1 08 00 80 92 22 00 00 91 E1 03 88 9A ?? ?? ?? ?? 1F 00 00 71 60 02 9F 9A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_25_7_0 {
	meta:
		name = "_mbsupr_s_l"
		size = 684
		refs = "0038 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 003c ??_C@_1KE@KOBLPBMH@?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe@ 0040 ??_C@_1GO@OAPABPI@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 005c _CrtDbgReportW 006c _errno 0080 ??_C@_1BI@PBGKGPOP@?$AA_?$AAm?$AAb?$AAs?$AAu?$AAp?$AAr?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 0090 _invalid_parameter 00a4 strnlen 00d0 _CrtGetDebugFillThreshold 00e8 memset 00f0 ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 017c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 01cc __acrt_LCMapStringA"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BC A9 FD 03 00 91 FF 43 00 D1 14 00 00 91 33 00 00 91 56 00 00 91 B4 00 00 B4 B3 00 00 B4 B4 03 00 B5 00 00 80 52 86 00 00 14 B3 FF FF B4 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 22 06 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 23 06 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? C0 02 80 52 6C 00 00 14 61 02 00 91 80 02 00 91 ?? ?? ?? ?? 15 00 00 91 BF 02 13 EB 43 04 00 54 9F 02 00 39 7F 06 00 B1 80 01 00 54 E8 7B 40 B2 7F 02 08 EB 64 1A 41 FA 09 01 00 54 ?? ?? ?? ?? 68 06 00 D1 1F 00 08 EB 02 30 88 9A 80 06 00 91 C1 1F 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 07 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 A3 07 80 52 ?? ?? ?? ?? D3 FF FF 17 68 06 00 91 09 F9 60 92 A9 01 00 B4 A8 06 00 91 1F 01 13 EB 42 01 00 54 ?? ?? ?? ?? 68 02 15 CB 09 05 00 D1 1F 00 09 EB A8 02 14 8B 02 30 89 9A 00 05 00 91 C1 1F 80 52 ?? ?? ?? ?? C1 02 00 91 E0 A3 00 91 ?? ?? ?? ?? 88 02 40 39 96 02 00 91 95 02 00 91 E8 04 00 34 EB 1F 40 F9 CC 02 40 39 8A 01 0B 8B 49 65 40 39 E9 02 10 36 67 05 40 B9 2D 00 80 52 61 11 41 F9 46 00 80 52 ED 03 00 B9 E5 83 00 91 44 00 80 52 C3 02 00 91 02 40 80 52 E0 C3 00 91 ?? ?? ?? ?? 60 04 00 34 E8 83 40 39 D6 06 00 91 EB 1F 40 F9 1F 04 00 71 A8 16 00 38 CD 01 00 54 E9 87 40 39 A9 02 00 39 B5 06 00 91 0A 00 00 14 88 05 00 11 68 C1 28 8B 09 61 40 39 69 00 28 36 4A 65 04 91 02 00 00 14 CA 02 00 91 49 01 40 39 A9 16 00 38 CA 1E 40 38 8A FB FF 35 BF 02 00 39 00 00 80 52 E8 03 41 39 A8 00 00 34 EA 17 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FF 43 00 91 FD 7B C4 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 7F 06 00 B1 9F 02 00 39 80 01 00 54 E8 7B 40 B2 7F 02 08 EB 64 1A 41 FA 09 01 00 54 ?? ?? ?? ?? 68 06 00 D1 1F 00 08 EB 02 30 88 9A 80 06 00 91 C1 1F 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 40 B9 E2 FF FF 17 }
	condition:
		$1
}

rule file_26_4_0 {
	meta:
		name = "_mbscat_s_l"
		size = 1032
		refs = "002c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0030 ??_C@_1FC@NCPEPIBI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt@ 0034 ??_C@_1HG@MCHNPME@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0050 _CrtDbgReportW 0060 _errno 0074 ??_C@_1BI@FAFMEAGP@?$AA_?$AAm?$AAb?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 0084 _invalid_parameter 00b0 _CrtGetDebugFillThreshold 00c8 memset 00d0 ??_C@_1CG@OFBJMIGJ@?$AA?$CI?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAr?$AAc?$AA?$CJ?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0120 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 013c strcat_s 01a4 ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 02e0 ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BD A9 FD 03 00 91 14 00 00 91 9F 02 00 F1 33 00 00 91 64 1A 40 FA 56 00 00 91 48 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 03 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 43 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? C0 02 80 52 DA 00 00 14 56 04 00 B5 9F 02 00 39 7F 06 00 B1 80 01 00 54 E8 7B 40 B2 7F 02 08 EB 64 1A 41 FA 09 01 00 54 ?? ?? ?? ?? 68 06 00 D1 1F 00 08 EB 02 30 88 9A 80 06 00 91 C1 1F 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 03 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 63 03 80 52 ?? ?? ?? ?? D8 FF FF 17 61 00 00 91 E0 43 00 91 ?? ?? ?? ?? EE 13 40 F9 C8 09 40 B9 C8 00 00 35 C2 02 00 91 61 02 00 91 80 02 00 91 ?? ?? ?? ?? A7 00 00 14 17 00 80 52 8B 02 00 91 75 02 00 91 68 01 40 39 88 00 00 34 6B 05 00 91 B5 06 00 D1 95 FF FF B5 15 05 00 B5 9F 02 00 39 7F 06 00 B1 80 01 00 54 E8 7B 40 B2 7F 02 08 EB 64 1A 41 FA 09 01 00 54 ?? ?? ?? ?? 68 06 00 D1 1F 00 08 EB 02 30 88 9A 80 06 00 91 C1 1F 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 06 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 C3 06 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 77 00 00 14 6C 05 00 D1 8A 01 00 91 9F 01 14 EB 03 01 00 54 48 01 40 39 08 01 0E 8B 09 65 40 39 89 00 10 36 4A 05 00 D1 5F 01 14 EB 42 FF FF 54 89 01 0A 4B A9 00 00 36 6B 05 00 D1 7F 01 00 39 37 00 80 52 B5 06 00 91 CA 16 40 38 6D 01 00 91 6A 15 00 38 6A 00 00 34 B5 06 00 D1 75 FF FF B5 15 07 00 B5 C8 02 40 39 E8 01 00 35 AC 01 00 91 BF 01 14 EB 03 01 00 54 89 01 40 39 29 01 0E 8B 2A 65 40 39 8A 00 10 36 8C 05 00 D1 9F 01 14 EB 42 FF FF 54 A9 01 0C 4B 69 00 00 36 7F F1 1F 38 49 00 00 14 9F 02 00 39 7F 06 00 B1 80 01 00 54 E8 7B 40 B2 7F 02 08 EB 64 1A 41 FA 09 01 00 54 ?? ?? ?? ?? 68 06 00 D1 1F 00 08 EB 02 30 88 9A 80 06 00 91 C1 1F 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 0C 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 43 0C 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 40 04 80 52 28 00 00 14 6C 09 00 D1 8A 01 00 91 9F 01 14 EB 03 01 00 54 48 01 40 39 08 01 0E 8B 09 65 40 39 89 00 10 36 4A 05 00 D1 5F 01 14 EB 42 FF FF 54 89 01 0A 4B 89 00 00 36 7F E1 1F 38 B5 06 00 91 37 00 80 52 68 06 00 91 09 F9 60 92 C9 01 00 B4 68 02 15 CB 09 05 00 91 3F 01 13 EB 42 01 00 54 ?? ?? ?? ?? A8 06 00 D1 1F 00 08 EB 02 30 88 9A 88 02 15 CB 09 01 13 8B 20 05 00 91 C1 1F 80 52 ?? ?? ?? ?? D7 00 00 34 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 40 05 80 52 02 00 00 14 00 00 80 52 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "??$?RD@__crt_internal_free_policy@@QEBAXQEBD@Z"
		size = 36
		refs = "0018 _free_dbg"
		altNames = "??$?RE@__crt_internal_free_policy@@QEBAXQEBE@Z ??$?RG@__crt_internal_free_policy@@QEBAXQEBG@Z ??$?RJ@__crt_internal_free_policy@@QEBAXQEBJ@Z ??$?RP6AXXZ@__crt_internal_free_policy@@QEBAXQEBQ6AXXZ@Z ??$?RPEAD@__crt_internal_free_policy@@QEBAXQEBQEAD@Z ??$?RPEAU__crt_stdio_stream_data@@@__crt_internal_free_policy@@QEBAXQEBQEAU__crt_stdio_stream_data@@@Z ??$?RPEA_W@__crt_internal_free_policy@@QEBAXQEBQEA_W@Z ??$?RU?$__crt_report_hook_node@D@@@__crt_internal_free_policy@@QEBAXQEBU?$__crt_report_hook_node@D@@@Z ??$?RU?$__crt_report_hook_node@_W@@@__crt_internal_free_policy@@QEBAXQEBU?$__crt_report_hook_node@_W@@@Z ??$?RU__acrt_ptd@@@__crt_internal_free_policy@@QEBAXQEBU__acrt_ptd@@@Z ??$?RU__acrt_thread_parameter@@@__crt_internal_free_policy@@QEBAXQEBU__acrt_thread_parameter@@@Z ??$?RU__crt_lc_time_data@@@__crt_internal_free_policy@@QEBAXQEBU__crt_lc_time_data@@@Z ??$?RU__crt_locale_data@@@__crt_internal_free_policy@@QEBAXQEBU__crt_locale_data@@@Z ??$?RU__crt_locale_pointers@@@__crt_internal_free_policy@@QEBAXQEBU__crt_locale_pointers@@@Z ??$?RU__crt_lowio_handle_data@@@__crt_internal_free_policy@@QEBAXQEBU__crt_lowio_handle_data@@@Z ??$?RU__crt_multibyte_data@@@__crt_internal_free_policy@@QEBAXQEBU__crt_multibyte_data@@@Z ??$?RU__crt_stdio_stream_data@@@__crt_internal_free_policy@@QEBAXQEBU__crt_stdio_stream_data@@@Z ??$?RUlconv@@@__crt_internal_free_policy@@QEBAXQEBUlconv@@@Z ??$?RUtm@@@__crt_internal_free_policy@@QEBAXQEBUtm@@@Z ??$?R_W@__crt_internal_free_policy@@QEBAXQEB_W@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E1 0B 00 F9 41 00 80 52 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_2_0 {
	meta:
		name = "??$common_tmpnam@D@@YAHQEAD_KW4buffer_id@?A0x5b9a7937@@QEAPEAD@Z"
		size = 240
		refs = "0024 __acrt_lock 0028 _errno 0048 ??$common_tmpnam_nolock@D@@YAHQEAD_KW4buffer_id@?A0x5b9a7937@@@Z 00a4 ?get_tmpnam_ptd_buffer@@YAPEAPEADD@Z 00dc __acrt_unlock"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 A0 0F 00 F9 A1 27 00 F9 A2 23 00 B9 A3 1B 00 F9 08 00 80 52 A8 13 00 B9 80 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? A0 23 00 F9 A8 23 40 F9 08 01 40 B9 A8 2B 00 B9 A2 23 40 B9 A1 27 40 F9 A0 0F 40 F9 ?? ?? ?? ?? A0 27 00 B9 A8 27 40 B9 A8 13 00 B9 A8 13 40 B9 1F 01 00 71 40 01 00 54 A9 1B 40 F9 A8 0F 40 F9 28 01 00 F9 ?? ?? ?? ?? A0 2B 00 F9 A9 2B 40 F9 A8 13 40 B9 28 01 00 B9 15 00 00 14 A8 0F 40 F9 1F 01 00 F1 80 00 00 54 A8 0F 40 F9 A8 1F 00 F9 07 00 00 14 00 00 80 52 ?? ?? ?? ?? A0 2F 00 F9 A8 2F 40 F9 08 01 40 F9 A8 1F 00 F9 A9 1B 40 F9 A8 1F 40 F9 28 01 00 F9 ?? ?? ?? ?? A0 33 00 F9 A9 33 40 F9 A8 2B 40 B9 28 01 00 B9 80 01 80 52 ?? ?? ?? ?? A0 13 40 B9 FD 7B C7 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_27_4_0 {
	meta:
		name = "??$common_tmpnam@_W@@YAHQEA_W_KW4buffer_id@?A0x5b9a7937@@QEAPEA_W@Z"
		size = 240
		refs = "0024 __acrt_lock 0028 _errno 0048 ??$common_tmpnam_nolock@_W@@YAHQEA_W_KW4buffer_id@?A0x5b9a7937@@@Z 00a4 ?get_tmpnam_ptd_buffer@@YAPEAPEA_W_W@Z 00dc __acrt_unlock"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 A0 0F 00 F9 A1 27 00 F9 A2 23 00 B9 A3 1B 00 F9 08 00 80 52 A8 13 00 B9 80 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? A0 23 00 F9 A8 23 40 F9 08 01 40 B9 A8 2B 00 B9 A2 23 40 B9 A1 27 40 F9 A0 0F 40 F9 ?? ?? ?? ?? A0 27 00 B9 A8 27 40 B9 A8 13 00 B9 A8 13 40 B9 1F 01 00 71 40 01 00 54 A9 1B 40 F9 A8 0F 40 F9 28 01 00 F9 ?? ?? ?? ?? A0 2B 00 F9 A9 2B 40 F9 A8 13 40 B9 28 01 00 B9 15 00 00 14 A8 0F 40 F9 1F 01 00 F1 80 00 00 54 A8 0F 40 F9 A8 1F 00 F9 07 00 00 14 00 00 80 52 ?? ?? ?? ?? A0 2F 00 F9 A8 2F 40 F9 08 01 40 F9 A8 1F 00 F9 A9 1B 40 F9 A8 1F 40 F9 28 01 00 F9 ?? ?? ?? ?? A0 33 00 F9 A9 33 40 F9 A8 2B 40 B9 28 01 00 B9 80 01 80 52 ?? ?? ?? ?? A0 13 40 B9 FD 7B C7 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_27_3_0 {
	meta:
		name = "?fin$0@?0???$common_tmpnam@D@@YAHQEAD_KW4buffer_id@?A0x5b9a7937@@QEAPEAD@Z@4HA"
		size = 28
		refs = "000c __acrt_unlock"
		altNames = "?fin$0@?0???$common_tmpnam@_W@@YAHQEA_W_KW4buffer_id@?A0x5b9a7937@@QEAPEA_W@Z@4HA ?fin$0@?0???$compute_name@D@@YA_NQEBDQEAD_K2@Z@4HA ?fin$0@?0???$compute_name@_W@@YA_NQEB_WQEA_W_K2@Z@4HA ?fin$0@?0??common_tmpfile@@YAHQEAPEAU_iobuf@@H@Z@4HA"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 80 01 80 52 ?? ?? ?? ?? 01 00 00 14 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_6_0 {
	meta:
		name = "??$common_tmpnam_nolock@D@@YAHQEAD_KW4buffer_id@?A0x5b9a7937@@@Z"
		size = 688
		refs = "0018 ??$get_tmpfile_buffer_nolock@D@@YAPEADW4buffer_id@?A0x5b9a7937@@@Z 005c ??$initialize_tmpfile_buffer_nolock@D@@YA_NW4buffer_id@?A0x5b9a7937@@@Z 006c ??$generate_tmpfile_file_name@D@@YA_NQEAD_K@Z 009c ??$taccess_s@AEBQEADH@?$__crt_char_traits@D@@SAHAEBQEAD$$QEAH@Z 00f8 ??$tcslen@AEBQEAD@?$__crt_char_traits@D@@SA_KAEBQEAD@Z 013c ??$tcscpy_s@AEBQEADAEB_KAEBQEAD@?$__crt_char_traits@D@@SAHAEBQEADAEB_K0@Z 014c ??_C@_1GC@NNHAGHGE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0154 ??_C@_1CK@MADPAFHK@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAt?$AAm?$AAp?$AAn?$AAa?$AAm?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk?$AA?$AA@ 015c ??_C@_1JE@PLDPNCIB@?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA_?$AAb?$AAu@ 0168 _invoke_watson_if_error 0180 ??_C@_1DO@NDLLDDHJ@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAi?$AAd?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAi?$AAd?$AA?3?$AA?3?$AAt?$AAm?$AAp?$AAn?$AAa?$AAm?$AA?$AA@ 0188 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 01a4 _CrtDbgReportW 01c4 ?get_tmpnam_ptd_buffer@@YAPEAPEADD@Z 01fc ??_C@_0DB@FLJKHJDH@minkernel?2crts?2ucrt?2src?2appcrt?2s@ 0210 _calloc_dbg 0220 ??0?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAA@QEAD@Z 0234 ?detach@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAAPEADXZ 024c ??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAA@XZ 0274 ??$tcscpy_s@AEAPEADAEB_KAEBQEAD@?$__crt_char_traits@D@@SAHAEAPEADAEB_KAEBQEAD@Z 0294 ??_C@_1JA@JPEEANAF@?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AA?$CK?$AAp?$AAt?$AAd?$AA_?$AAb?$AAu?$AAf?$AAf@"
	strings:
		$1 = { FD 7B B6 A9 FD 03 00 91 E0 27 00 F9 E1 23 00 F9 E2 17 00 B9 E0 17 40 B9 ?? ?? ?? ?? E0 2B 00 F9 E8 2B 40 F9 E8 0F 00 F9 88 20 80 D2 E8 4B 00 F9 E8 0F 40 F9 1F 01 00 F1 61 00 00 54 80 01 80 52 9A 00 00 14 E8 0F 40 F9 08 01 C0 39 08 01 00 11 1F 01 00 71 81 00 00 54 E0 17 40 B9 ?? ?? ?? ?? 0B 00 00 14 81 20 80 D2 E0 0F 40 F9 ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 40 00 80 52 88 00 00 14 08 00 80 52 E8 2B 00 B9 E1 A3 00 91 E0 63 00 91 ?? ?? ?? ?? E0 2F 00 B9 E8 2F 40 B9 1F 01 00 71 81 01 00 54 81 20 80 D2 E0 0F 40 F9 ?? ?? ?? ?? E0 47 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 40 00 80 52 75 00 00 14 ED FF FF 17 E8 27 40 F9 1F 01 00 F1 80 04 00 54 E8 17 40 B9 1F 01 00 71 00 02 00 54 E0 63 00 91 ?? ?? ?? ?? E0 2F 00 F9 E9 23 40 F9 E8 2F 40 F9 1F 01 09 EB 23 01 00 54 E8 23 40 F9 1F 01 00 F1 80 00 00 54 E9 27 40 F9 08 00 80 52 28 01 00 39 40 04 80 52 5F 00 00 14 E2 63 00 91 E1 03 01 91 E0 23 01 91 ?? ?? ?? ?? E0 33 00 B9 05 00 80 D2 A4 1E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 33 40 B9 ?? ?? ?? ?? 00 00 80 52 4E 00 00 14 E8 17 40 B9 1F 01 00 71 20 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 1F 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 37 00 B9 E9 37 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 00 00 80 52 ?? ?? ?? ?? E0 33 00 F9 E8 33 40 F9 E8 13 00 F9 E8 13 40 F9 1F 01 00 F1 61 00 00 54 80 01 80 52 31 00 00 14 E8 13 40 F9 08 01 40 F9 1F 01 00 F1 A1 03 00 54 A4 20 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 42 00 80 52 21 00 80 D2 80 20 80 D2 ?? ?? ?? ?? E0 37 00 F9 E1 37 40 F9 E0 23 02 91 ?? ?? ?? ?? E0 3B 00 F9 E8 3B 40 F9 E8 3F 00 F9 E0 3F 40 F9 ?? ?? ?? ?? E0 43 00 F9 E9 13 40 F9 E8 43 40 F9 28 01 00 F9 E0 23 02 91 ?? ?? ?? ?? E8 13 40 F9 08 01 40 F9 1F 01 00 F1 61 00 00 54 80 01 80 52 11 00 00 14 E2 63 00 91 E1 43 02 91 E0 13 40 F9 ?? ?? ?? ?? E0 3B 00 B9 05 00 80 D2 84 21 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 3B 40 B9 ?? ?? ?? ?? 00 00 80 52 FD 7B CA A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_7_0 {
	meta:
		name = "??$common_tmpnam_nolock@_W@@YAHQEA_W_KW4buffer_id@?A0x5b9a7937@@@Z"
		size = 688
		refs = "0018 ??$get_tmpfile_buffer_nolock@_W@@YAPEA_WW4buffer_id@?A0x5b9a7937@@@Z 005c ??$initialize_tmpfile_buffer_nolock@_W@@YA_NW4buffer_id@?A0x5b9a7937@@@Z 006c ??$generate_tmpfile_file_name@_W@@YA_NQEA_W_K@Z 009c ??$taccess_s@AEBQEA_WH@?$__crt_char_traits@_W@@SAHAEBQEA_W$$QEAH@Z 00f8 ??$tcslen@AEBQEA_W@?$__crt_char_traits@_W@@SA_KAEBQEA_W@Z 013c ??$tcscpy_s@AEBQEA_WAEB_KAEBQEA_W@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_K0@Z 014c ??_C@_1GC@NNHAGHGE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0154 ??_C@_1CK@MADPAFHK@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAt?$AAm?$AAp?$AAn?$AAa?$AAm?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk?$AA?$AA@ 015c ??_C@_1JE@PLDPNCIB@?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA_?$AAb?$AAu@ 0168 _invoke_watson_if_error 0180 ??_C@_1DO@NDLLDDHJ@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAi?$AAd?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAi?$AAd?$AA?3?$AA?3?$AAt?$AAm?$AAp?$AAn?$AAa?$AAm?$AA?$AA@ 0188 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 01a4 _CrtDbgReportW 01c4 ?get_tmpnam_ptd_buffer@@YAPEAPEA_W_W@Z 01fc ??_C@_0DB@FLJKHJDH@minkernel?2crts?2ucrt?2src?2appcrt?2s@ 0210 _calloc_dbg 0220 ??0?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAA@QEA_W@Z 0234 ?detach@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAAPEA_WXZ 024c ??1?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAA@XZ 0274 ??$tcscpy_s@AEAPEA_WAEB_KAEBQEA_W@?$__crt_char_traits@_W@@SAHAEAPEA_WAEB_KAEBQEA_W@Z 0294 ??_C@_1JA@JPEEANAF@?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AA?$CK?$AAp?$AAt?$AAd?$AA_?$AAb?$AAu?$AAf?$AAf@"
	strings:
		$1 = { FD 7B B6 A9 FD 03 00 91 E0 27 00 F9 E1 23 00 F9 E2 17 00 B9 E0 17 40 B9 ?? ?? ?? ?? E0 2B 00 F9 E8 2B 40 F9 E8 0F 00 F9 88 20 80 D2 E8 4B 00 F9 E8 0F 40 F9 1F 01 00 F1 61 00 00 54 80 01 80 52 9A 00 00 14 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F 01 00 71 81 00 00 54 E0 17 40 B9 ?? ?? ?? ?? 0B 00 00 14 81 20 80 D2 E0 0F 40 F9 ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 40 00 80 52 88 00 00 14 08 00 80 52 E8 2B 00 B9 E1 A3 00 91 E0 63 00 91 ?? ?? ?? ?? E0 2F 00 B9 E8 2F 40 B9 1F 01 00 71 81 01 00 54 81 20 80 D2 E0 0F 40 F9 ?? ?? ?? ?? E0 47 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 40 00 80 52 75 00 00 14 ED FF FF 17 E8 27 40 F9 1F 01 00 F1 80 04 00 54 E8 17 40 B9 1F 01 00 71 00 02 00 54 E0 63 00 91 ?? ?? ?? ?? E0 2F 00 F9 E9 23 40 F9 E8 2F 40 F9 1F 01 09 EB 23 01 00 54 E8 23 40 F9 1F 01 00 F1 80 00 00 54 E9 27 40 F9 08 00 80 52 28 01 00 79 40 04 80 52 5F 00 00 14 E2 63 00 91 E1 03 01 91 E0 23 01 91 ?? ?? ?? ?? E0 33 00 B9 05 00 80 D2 A4 1E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 33 40 B9 ?? ?? ?? ?? 00 00 80 52 4E 00 00 14 E8 17 40 B9 1F 01 00 71 20 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 1F 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 37 00 B9 E9 37 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 00 00 80 52 ?? ?? ?? ?? E0 33 00 F9 E8 33 40 F9 E8 13 00 F9 E8 13 40 F9 1F 01 00 F1 61 00 00 54 80 01 80 52 31 00 00 14 E8 13 40 F9 08 01 40 F9 1F 01 00 F1 A1 03 00 54 A4 20 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 42 00 80 52 41 00 80 D2 80 20 80 D2 ?? ?? ?? ?? E0 37 00 F9 E1 37 40 F9 E0 23 02 91 ?? ?? ?? ?? E0 3B 00 F9 E8 3B 40 F9 E8 3F 00 F9 E0 3F 40 F9 ?? ?? ?? ?? E0 43 00 F9 E9 13 40 F9 E8 43 40 F9 28 01 00 F9 E0 23 02 91 ?? ?? ?? ?? E8 13 40 F9 08 01 40 F9 1F 01 00 F1 61 00 00 54 80 01 80 52 11 00 00 14 E2 63 00 91 E1 43 02 91 E0 13 40 F9 ?? ?? ?? ?? E0 3B 00 B9 05 00 80 D2 84 21 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 3B 40 B9 ?? ?? ?? ?? 00 00 80 52 FD 7B CA A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_8_0 {
	meta:
		name = "??$generate_tmpfile_file_name@D@@YA_NQEAD_K@Z"
		size = 768
		refs = "0020 ??$tcsrchr@AEBQEADD@?$__crt_char_traits@D@@SAPEADAEBQEAD$$QEAD@Z 0064 ??_C@_1BO@HCNLLOKB@?$AAd?$AAo?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 006c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 007c ??_C@_1GC@NNHAGHGE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0088 _CrtDbgReportW 00c0 ??_C@_1DG@FEHBCODN@?$AAg?$AAe?$AAn?$AAe?$AAr?$AAa?$AAt?$AAe?$AA_?$AAt?$AAm?$AAp?$AAf?$AAi?$AAl?$AAe?$AA_?$AAf?$AAi?$AAl?$AAe?$AA_?$AAn?$AAa?$AAm?$AAe?$AA?$AA@ 00d0 _invalid_parameter 0114 ??_C@_1CC@NADANIGJ@?$AAd?$AAo?$AAt?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA_?$AAn?$AAa?$AAm?$AAe?$AA?$AA@ 01cc ??_C@_1GO@BHPFFNDF@?$AAf?$AAi?$AAl?$AAe?$AA_?$AAn?$AAa?$AAm?$AAe?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AAs?$AAt?$AAa?$AAt?$AAi?$AAc?$AA_?$AAc?$AAa?$AAs?$AAt?$AA?$DM?$AAs?$AAi@ 0284 ??$tcstoull@AEBQEAD$$TH@?$__crt_char_traits@D@@SA_KAEBQEAD$$QEA$$T$$QEAH@Z 02c4 ??$ulltot_s@AEB_KAEBQEADAEB_KH@?$__crt_char_traits@D@@SAHAEB_KAEBQEAD0$$QEAH@Z 02e4 ??_C@_1JA@CCDPDPLH@?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAu?$AAl?$AAl?$AAt?$AAo?$AAt?$AA_?$AAs?$AA?$CI?$AAn?$AAe?$AAx?$AAt?$AA_?$AAi?$AAd?$AAe?$AAn@ 02f0 _invoke_watson_if_error"
	strings:
		$1 = { FD 7B B7 A9 FD 03 00 91 E0 1F 00 F9 E1 33 00 F9 C8 05 80 52 E8 43 00 39 E1 43 00 91 E0 E3 00 91 ?? ?? ?? ?? E0 3B 00 F9 E8 3B 40 F9 E8 1B 00 F9 E8 1B 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 17 00 B9 03 00 00 14 08 00 80 52 E8 17 00 B9 E8 17 40 B9 E8 1B 00 B9 E8 1B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 13 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 43 00 B9 E9 43 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 1B 40 B9 1F 01 00 71 81 01 00 54 04 00 80 D2 43 13 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 88 00 00 14 E9 1F 40 F9 E8 1B 40 F9 1F 01 09 EB 83 00 00 54 28 00 80 52 E8 1F 00 B9 03 00 00 14 08 00 80 52 E8 1F 00 B9 E8 1F 40 B9 E8 23 00 B9 E8 23 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 13 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 47 00 B9 E9 47 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 23 40 B9 1F 01 00 71 81 01 00 54 04 00 80 D2 63 13 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 5C 00 00 14 E9 1B 40 F9 E8 1F 40 F9 29 01 08 CB E8 33 40 F9 1F 01 09 EB 89 00 00 54 28 00 80 52 E8 27 00 B9 03 00 00 14 08 00 80 52 E8 27 00 B9 E8 27 40 B9 E8 2B 00 B9 E8 2B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 13 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 4B 00 B9 E9 4B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 2B 40 B9 1F 01 00 71 81 01 00 54 04 00 80 D2 83 13 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 2E 00 00 14 E8 1B 40 F9 08 05 00 91 E8 2F 00 F9 E9 2F 40 F9 E8 1F 40 F9 29 01 08 CB E8 33 40 F9 08 01 09 CB E8 47 00 F9 88 04 80 52 E8 4F 00 B9 08 00 80 D2 E8 3F 00 F9 E2 33 01 91 E1 E3 01 91 E0 63 01 91 ?? ?? ?? ?? E0 43 00 F9 E8 43 40 F9 08 05 00 91 E8 37 00 F9 E8 37 40 F9 1F 01 00 F1 61 00 00 54 00 00 80 52 14 00 00 14 88 04 80 52 E8 53 00 B9 E3 43 01 91 E2 23 02 91 E1 63 01 91 E0 A3 01 91 ?? ?? ?? ?? E0 57 00 B9 05 00 80 D2 C4 14 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 57 40 B9 ?? ?? ?? ?? 20 00 80 52 FD 7B C9 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_9_0 {
	meta:
		name = "??$generate_tmpfile_file_name@_W@@YA_NQEA_W_K@Z"
		size = 776
		refs = "0020 ??$tcsrchr@AEBQEA_WD@?$__crt_char_traits@_W@@SAPEA_WAEBQEA_W$$QEAD@Z 0064 ??_C@_1BO@HCNLLOKB@?$AAd?$AAo?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 006c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 007c ??_C@_1GC@NNHAGHGE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0088 _CrtDbgReportW 00c0 ??_C@_1DG@FEHBCODN@?$AAg?$AAe?$AAn?$AAe?$AAr?$AAa?$AAt?$AAe?$AA_?$AAt?$AAm?$AAp?$AAf?$AAi?$AAl?$AAe?$AA_?$AAf?$AAi?$AAl?$AAe?$AA_?$AAn?$AAa?$AAm?$AAe?$AA?$AA@ 00d0 _invalid_parameter 0114 ??_C@_1CC@NADANIGJ@?$AAd?$AAo?$AAt?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA_?$AAn?$AAa?$AAm?$AAe?$AA?$AA@ 01d0 ??_C@_1GO@BHPFFNDF@?$AAf?$AAi?$AAl?$AAe?$AA_?$AAn?$AAa?$AAm?$AAe?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AAs?$AAt?$AAa?$AAt?$AAi?$AAc?$AA_?$AAc?$AAa?$AAs?$AAt?$AA?$DM?$AAs?$AAi@ 028c ??$tcstoull@AEBQEA_W$$TH@?$__crt_char_traits@_W@@SA_KAEBQEA_W$$QEA$$T$$QEAH@Z 02cc ??$ulltot_s@AEB_KAEBQEA_WAEB_KH@?$__crt_char_traits@_W@@SAHAEB_KAEBQEA_W0$$QEAH@Z 02ec ??_C@_1JA@CCDPDPLH@?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAu?$AAl?$AAl?$AAt?$AAo?$AAt?$AA_?$AAs?$AA?$CI?$AAn?$AAe?$AAx?$AAt?$AA_?$AAi?$AAd?$AAe?$AAn@ 02f8 _invoke_watson_if_error"
	strings:
		$1 = { FD 7B B7 A9 FD 03 00 91 E0 1F 00 F9 E1 33 00 F9 C8 05 80 52 E8 43 00 39 E1 43 00 91 E0 E3 00 91 ?? ?? ?? ?? E0 3B 00 F9 E8 3B 40 F9 E8 1B 00 F9 E8 1B 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 17 00 B9 03 00 00 14 08 00 80 52 E8 17 00 B9 E8 17 40 B9 E8 1B 00 B9 E8 1B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 13 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 43 00 B9 E9 43 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 1B 40 B9 1F 01 00 71 81 01 00 54 04 00 80 D2 43 13 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 8A 00 00 14 E9 1F 40 F9 E8 1B 40 F9 1F 01 09 EB 83 00 00 54 28 00 80 52 E8 1F 00 B9 03 00 00 14 08 00 80 52 E8 1F 00 B9 E8 1F 40 B9 E8 23 00 B9 E8 23 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 13 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 47 00 B9 E9 47 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 23 40 B9 1F 01 00 71 81 01 00 54 04 00 80 D2 63 13 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 5E 00 00 14 E9 1B 40 F9 E8 1F 40 F9 28 01 08 CB 09 FD 41 93 E8 33 40 F9 1F 01 09 EB 89 00 00 54 28 00 80 52 E8 27 00 B9 03 00 00 14 08 00 80 52 E8 27 00 B9 E8 27 40 B9 E8 2B 00 B9 E8 2B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 13 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 4B 00 B9 E9 4B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 2B 40 B9 1F 01 00 71 81 01 00 54 04 00 80 D2 83 13 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 2F 00 00 14 E8 1B 40 F9 08 09 00 91 E8 2F 00 F9 E9 2F 40 F9 E8 1F 40 F9 28 01 08 CB 09 FD 41 93 E8 33 40 F9 08 01 09 CB E8 47 00 F9 88 04 80 52 E8 4F 00 B9 08 00 80 D2 E8 3F 00 F9 E2 33 01 91 E1 E3 01 91 E0 63 01 91 ?? ?? ?? ?? E0 43 00 F9 E8 43 40 F9 08 05 00 91 E8 37 00 F9 E8 37 40 F9 1F 01 00 F1 61 00 00 54 00 00 80 52 14 00 00 14 88 04 80 52 E8 53 00 B9 E3 43 01 91 E2 23 02 91 E1 63 01 91 E0 A3 01 91 ?? ?? ?? ?? E0 57 00 B9 05 00 80 D2 C4 14 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 57 40 B9 ?? ?? ?? ?? 20 00 80 52 FD 7B C9 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_10_0 {
	meta:
		name = "??$get_temp_path@KAEBQEAD@?$__crt_char_traits@D@@SAK$$QEAKAEBQEAD@Z"
		size = 52
		refs = "0020 __acrt_GetTempPathA"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 F9 E8 13 40 F9 00 01 40 B9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_512_6_0 {
	meta:
		name = "??$futime@AEAHAEBQEAU__utimbuf32@@@?$__crt_integer_traits@J@@SAHAEAHAEBQEAU__utimbuf32@@@Z"
		size = 52
		refs = "0020 _futime32"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 F9 E8 13 40 F9 00 01 40 B9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_512_7_0 {
	meta:
		name = "??$futime@AEAHAEBQEAU__utimbuf64@@@?$__crt_integer_traits@_J@@SAHAEAHAEBQEAU__utimbuf64@@@Z"
		size = 52
		refs = "0020 _futime64"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 F9 E8 13 40 F9 00 01 40 B9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_116_0 {
	meta:
		name = "??$ungettc_nolock@AEBHPEAU_iobuf@@@?$__crt_char_traits@D@@SAHAEBH$$QEAPEAU_iobuf@@@Z"
		size = 52
		refs = "0020 _ungetc_nolock"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 F9 E8 13 40 F9 00 01 40 B9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_11_0 {
	meta:
		name = "??$get_temp_path@KAEBQEA_W@?$__crt_char_traits@_W@@SAK$$QEAKAEBQEA_W@Z"
		size = 60
		refs = "0020 __imp_GetTempPathW"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 F9 E8 13 40 F9 00 01 40 B9 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_12_0 {
	meta:
		name = "??$get_tmpfile_buffer_nolock@D@@YAPEADW4buffer_id@?A0x5b9a7937@@@Z"
		size = 156
		refs = "0014 ?get_tmpfile_buffer_pointer_nolock@@YAAEAPEADW4buffer_id@?A0x5b9a7937@@D@Z 0038 ??_C@_0DB@FLJKHJDH@minkernel?2crts?2ucrt?2src?2appcrt?2s@ 004c _calloc_dbg 005c ??0?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAA@QEAD@Z 0070 ?detach@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAAPEADXZ 0088 ??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAA@XZ"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 E0 13 00 B9 01 00 80 52 E0 13 40 B9 ?? ?? ?? ?? E0 13 00 F9 E8 13 40 F9 E8 0F 00 F9 E8 0F 40 F9 08 01 40 F9 1F 01 00 F1 E1 02 00 54 24 0A 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 42 00 80 52 21 00 80 D2 80 20 80 D2 ?? ?? ?? ?? E0 17 00 F9 E1 17 40 F9 E0 23 01 91 ?? ?? ?? ?? E0 1B 00 F9 E8 1B 40 F9 E8 1F 00 F9 E0 1F 40 F9 ?? ?? ?? ?? E0 23 00 F9 E9 0F 40 F9 E8 23 40 F9 28 01 00 F9 E0 23 01 91 ?? ?? ?? ?? E8 0F 40 F9 00 01 40 F9 FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_13_0 {
	meta:
		name = "??$get_tmpfile_buffer_nolock@_W@@YAPEA_WW4buffer_id@?A0x5b9a7937@@@Z"
		size = 156
		refs = "0014 ?get_tmpfile_buffer_pointer_nolock@@YAAEAPEA_WW4buffer_id@?A0x5b9a7937@@_W@Z 0038 ??_C@_0DB@FLJKHJDH@minkernel?2crts?2ucrt?2src?2appcrt?2s@ 004c _calloc_dbg 005c ??0?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAA@QEA_W@Z 0070 ?detach@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAAPEA_WXZ 0088 ??1?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAA@XZ"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 E0 13 00 B9 01 00 80 52 E0 13 40 B9 ?? ?? ?? ?? E0 13 00 F9 E8 13 40 F9 E8 0F 00 F9 E8 0F 40 F9 08 01 40 F9 1F 01 00 F1 E1 02 00 54 24 0A 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 42 00 80 52 41 00 80 D2 80 20 80 D2 ?? ?? ?? ?? E0 17 00 F9 E1 17 40 F9 E0 23 01 91 ?? ?? ?? ?? E0 1B 00 F9 E8 1B 40 F9 E8 1F 00 F9 E0 1F 40 F9 ?? ?? ?? ?? E0 23 00 F9 E9 0F 40 F9 E8 23 40 F9 28 01 00 F9 E0 23 01 91 ?? ?? ?? ?? E8 0F 40 F9 00 01 40 F9 FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_14_0 {
	meta:
		name = "??$initialize_tmpfile_buffer_nolock@D@@YA_NW4buffer_id@?A0x5b9a7937@@@Z"
		size = 540
		refs = "0010 ??$get_tmpfile_buffer_nolock@D@@YAPEADW4buffer_id@?A0x5b9a7937@@@Z 0054 ??$get_temp_path@KAEBQEAD@?$__crt_char_traits@D@@SAK$$QEAKAEBQEAD@Z 00b4 ??0<lambda_fd10835d84bca6d3f1a7e11a5ff2d200>@@QEAA@AEB_KAEAPEADAEBQEAD@Z 0144 ??R<lambda_fd10835d84bca6d3f1a7e11a5ff2d200>@@QEBA_KXZ 0154 __imp_GetCurrentProcessId 017c ??$ulltot_s@KAEAPEAD_KH@?$__crt_char_traits@D@@SAH$$QEAKAEAPEAD$$QEA_K$$QEAH@Z 018c ??_C@_1GC@NNHAGHGE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0194 ??_C@_1EC@HIMPBFCI@?$AAi?$AAn?$AAi?$AAt?$AAi?$AAa?$AAl?$AAi?$AAz?$AAe?$AA_?$AAt?$AAm?$AAp?$AAf?$AAi?$AAl?$AAe?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk@ 019c ??_C@_1IM@OGKNKOJP@?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAu?$AAl?$AAl?$AAt?$AAo?$AAt?$AA_?$AAs?$AA?$CI?$AAG?$AAe?$AAt?$AAC?$AAu?$AAr?$AAr?$AAe?$AAn@ 01a8 _invoke_watson_if_error 01b0 ??$tcslen@AEAPEAD@?$__crt_char_traits@D@@SA_KAEAPEAD@Z"
	strings:
		$1 = { FD 7B B7 A9 FD 03 00 91 E0 23 00 B9 E0 23 40 B9 ?? ?? ?? ?? E0 2B 00 F9 E8 2B 40 F9 E8 17 00 F9 88 20 80 D2 E8 2F 00 F9 E8 17 40 F9 1F 01 00 F1 61 00 00 54 00 00 80 52 77 00 00 14 C8 1D 80 52 E8 4B 00 B9 88 20 80 52 E8 33 00 B9 E1 A3 00 91 E0 C3 00 91 ?? ?? ?? ?? E0 37 00 B9 E8 37 40 B9 E8 1B 00 B9 E8 1B 40 B9 1F 01 00 71 80 00 00 54 E8 1B 40 B9 1F B9 03 71 C9 00 00 54 E9 17 40 F9 08 00 80 52 28 01 00 39 00 00 80 52 62 00 00 14 E8 1B 40 B9 09 7D 40 D3 E8 17 40 F9 08 01 09 8B E8 0B 00 F9 E3 A3 00 91 E2 43 00 91 E1 63 01 91 E0 E3 01 91 ?? ?? ?? ?? E8 23 40 B9 E8 1F 00 B9 E8 1F 40 B9 1F 01 00 71 00 01 00 54 E8 1F 40 B9 1F 05 00 71 80 01 00 54 E8 1F 40 B9 1F 09 00 71 00 02 00 54 15 00 00 14 E9 0B 40 F9 68 0E 80 52 28 01 00 39 E8 0B 40 F9 08 05 00 91 E8 0B 00 F9 0E 00 00 14 E9 0B 40 F9 88 0E 80 52 28 01 00 39 E8 0B 40 F9 08 05 00 91 E8 0B 00 F9 07 00 00 14 E9 0B 40 F9 A8 0E 80 52 28 01 00 39 E8 0B 40 F9 08 05 00 91 E8 0B 00 F9 88 04 80 52 E8 3F 00 B9 E0 E3 01 91 ?? ?? ?? ?? E0 33 00 F9 E8 33 40 F9 E8 37 00 F9 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 E0 3B 00 B9 E8 3B 40 B9 E8 43 00 B9 E3 F3 00 91 E2 A3 01 91 E1 43 00 91 E0 03 01 91 ?? ?? ?? ?? E0 47 00 B9 05 00 80 D2 64 10 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 47 40 B9 ?? ?? ?? ?? E0 43 00 91 ?? ?? ?? ?? E0 3B 00 F9 E9 0B 40 F9 E8 3B 40 F9 28 01 08 8B E8 0B 00 F9 E9 0B 40 F9 C8 05 80 52 28 01 00 39 E8 0B 40 F9 08 05 00 91 E8 0B 00 F9 E9 0B 40 F9 08 06 80 52 28 01 00 39 E8 0B 40 F9 08 05 00 91 E8 0B 00 F9 E9 0B 40 F9 08 00 80 52 28 01 00 39 E8 0B 40 F9 08 05 00 91 E8 0B 00 F9 20 00 80 52 FD 7B C9 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_15_0 {
	meta:
		name = "??$initialize_tmpfile_buffer_nolock@_W@@YA_NW4buffer_id@?A0x5b9a7937@@@Z"
		size = 556
		refs = "0010 ??$get_tmpfile_buffer_nolock@_W@@YAPEA_WW4buffer_id@?A0x5b9a7937@@@Z 0054 ??$get_temp_path@KAEBQEA_W@?$__crt_char_traits@_W@@SAK$$QEAKAEBQEA_W@Z 00bc ??0<lambda_890542a8f130cf228121e5f4948058fa>@@QEAA@AEB_KAEAPEA_WAEBQEA_W@Z 014c ??R<lambda_890542a8f130cf228121e5f4948058fa>@@QEBA_KXZ 015c __imp_GetCurrentProcessId 0184 ??$ulltot_s@KAEAPEA_W_KH@?$__crt_char_traits@_W@@SAH$$QEAKAEAPEA_W$$QEA_K$$QEAH@Z 0194 ??_C@_1GC@NNHAGHGE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 019c ??_C@_1EC@HIMPBFCI@?$AAi?$AAn?$AAi?$AAt?$AAi?$AAa?$AAl?$AAi?$AAz?$AAe?$AA_?$AAt?$AAm?$AAp?$AAf?$AAi?$AAl?$AAe?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk@ 01a4 ??_C@_1IM@OGKNKOJP@?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAu?$AAl?$AAl?$AAt?$AAo?$AAt?$AA_?$AAs?$AA?$CI?$AAG?$AAe?$AAt?$AAC?$AAu?$AAr?$AAr?$AAe?$AAn@ 01b0 _invoke_watson_if_error 01b8 ??$tcslen@AEAPEA_W@?$__crt_char_traits@_W@@SA_KAEAPEA_W@Z"
	strings:
		$1 = { FD 7B B7 A9 FD 03 00 91 E0 23 00 B9 E0 23 40 B9 ?? ?? ?? ?? E0 2B 00 F9 E8 2B 40 F9 E8 17 00 F9 88 20 80 D2 E8 2F 00 F9 E8 17 40 F9 1F 01 00 F1 61 00 00 54 00 00 80 52 7B 00 00 14 C8 1D 80 52 E8 4B 00 B9 88 20 80 52 E8 33 00 B9 E1 A3 00 91 E0 C3 00 91 ?? ?? ?? ?? E0 37 00 B9 E8 37 40 B9 E8 1B 00 B9 E8 1B 40 B9 1F 01 00 71 80 00 00 54 E8 1B 40 B9 1F B9 03 71 C9 00 00 54 E9 17 40 F9 08 00 80 52 28 01 00 79 00 00 80 52 66 00 00 14 E8 1B 40 B9 09 7D 40 D3 48 00 80 D2 29 7D 08 9B E8 17 40 F9 08 01 09 8B E8 0B 00 F9 E3 A3 00 91 E2 43 00 91 E1 63 01 91 E0 E3 01 91 ?? ?? ?? ?? E8 23 40 B9 E8 1F 00 B9 E8 1F 40 B9 1F 01 00 71 00 01 00 54 E8 1F 40 B9 1F 05 00 71 80 01 00 54 E8 1F 40 B9 1F 09 00 71 00 02 00 54 15 00 00 14 E9 0B 40 F9 C8 0E 80 52 28 01 00 79 E8 0B 40 F9 08 09 00 91 E8 0B 00 F9 0E 00 00 14 E9 0B 40 F9 E8 0E 80 52 28 01 00 79 E8 0B 40 F9 08 09 00 91 E8 0B 00 F9 07 00 00 14 E9 0B 40 F9 08 0F 80 52 28 01 00 79 E8 0B 40 F9 08 09 00 91 E8 0B 00 F9 88 04 80 52 E8 3F 00 B9 E0 E3 01 91 ?? ?? ?? ?? E0 33 00 F9 E8 33 40 F9 E8 37 00 F9 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 E0 3B 00 B9 E8 3B 40 B9 E8 43 00 B9 E3 F3 00 91 E2 A3 01 91 E1 43 00 91 E0 03 01 91 ?? ?? ?? ?? E0 47 00 B9 05 00 80 D2 64 10 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 47 40 B9 ?? ?? ?? ?? E0 43 00 91 ?? ?? ?? ?? E0 3B 00 F9 E9 3B 40 F9 48 00 80 D2 29 7D 08 9B E8 0B 40 F9 08 01 09 8B E8 0B 00 F9 E9 0B 40 F9 C8 05 80 52 28 01 00 79 E8 0B 40 F9 08 09 00 91 E8 0B 00 F9 E9 0B 40 F9 08 06 80 52 28 01 00 79 E8 0B 40 F9 08 09 00 91 E8 0B 00 F9 E9 0B 40 F9 08 00 80 52 28 01 00 79 E8 0B 40 F9 08 09 00 91 E8 0B 00 F9 20 00 80 52 FD 7B C9 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_16_0 {
	meta:
		name = "??$taccess_s@AEBQEADH@?$__crt_char_traits@D@@SAHAEBQEAD$$QEAH@Z"
		size = 52
		refs = "0020 _access_s"
		altNames = "??$taccess_s@AEBQEBDH@?$__crt_char_traits@D@@SAHAEBQEBD$$QEAH@Z ??$taccess_s@PEBDH@?$__crt_char_traits@D@@SAH$$QEAPEBD$$QEAH@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 B9 E8 13 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_17_0 {
	meta:
		name = "??$taccess_s@AEBQEA_WH@?$__crt_char_traits@_W@@SAHAEBQEA_W$$QEAH@Z"
		size = 52
		refs = "0020 _waccess_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 B9 E8 13 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_680_19_0 {
	meta:
		name = "??$taccess_s@AEBQEB_WH@?$__crt_char_traits@_W@@SAHAEBQEB_W$$QEAH@Z"
		size = 52
		refs = "0020 _waccess_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 B9 E8 13 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_680_21_0 {
	meta:
		name = "??$taccess_s@PEB_WH@?$__crt_char_traits@_W@@SAH$$QEAPEB_W$$QEAH@Z"
		size = 52
		refs = "0020 _waccess_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E8 0F 40 F9 01 01 40 B9 E8 13 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_26_0 {
	meta:
		name = "??$tcsrchr@AEBQEADD@?$__crt_char_traits@D@@SAPEADAEBQEAD$$QEAD@Z"
		size = 60
		refs = "0028 ?strrchr@@YAPEADQEADH@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 0B 00 F9 E8 0B 40 F9 01 01 C0 39 21 00 00 11 21 00 00 11 E8 0F 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 F9 E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_27_0 {
	meta:
		name = "??$tcsrchr@AEBQEA_WD@?$__crt_char_traits@_W@@SAPEA_WAEBQEA_W$$QEAD@Z"
		size = 60
		refs = "0028 ?wcsrchr@@YAPEA_WPEA_W_W@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 0B 00 F9 E8 0B 40 F9 08 01 C0 39 01 3D 00 53 21 00 00 11 E8 0F 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 F9 E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_28_0 {
	meta:
		name = "??$tcstoull@AEBQEAD$$TH@?$__crt_char_traits@D@@SA_KAEBQEAD$$QEA$$T$$QEAH@Z"
		size = 64
		refs = "002c strtoull"
		altNames = "??$tcstoull@PEBDPEAPEADH@?$__crt_char_traits@D@@SA_K$$QEAPEBD$$QEAPEAPEAD$$QEAH@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E2 0B 00 F9 E8 0B 40 F9 02 01 40 B9 E8 0F 40 F9 01 01 40 F9 E8 13 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 17 00 F9 E0 17 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_113_0 {
	meta:
		name = "??$tcstoull@AEAPEB_WPEAPEA_WH@?$__crt_char_traits@_W@@SA_KAEAPEB_W$$QEAPEAPEA_W$$QEAH@Z"
		size = 64
		refs = "002c wcstoull"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E2 0B 00 F9 E8 0B 40 F9 02 01 40 B9 E8 0F 40 F9 01 01 40 F9 E8 13 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 17 00 F9 E0 17 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_29_0 {
	meta:
		name = "??$tcstoull@AEBQEA_W$$TH@?$__crt_char_traits@_W@@SA_KAEBQEA_W$$QEA$$T$$QEAH@Z"
		size = 64
		refs = "002c wcstoull"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E2 0B 00 F9 E8 0B 40 F9 02 01 40 B9 E8 0F 40 F9 01 01 40 F9 E8 13 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 17 00 F9 E0 17 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_30_0 {
	meta:
		name = "??$ulltot_s@AEB_KAEBQEADAEB_KH@?$__crt_char_traits@D@@SAHAEB_KAEBQEAD0$$QEAH@Z"
		size = 76
		refs = "0038 _ui64toa_s"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 B9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_374_2_0 {
	meta:
		name = "??$message_box@$$TAEBQEBDAEBQEBDK@?$__crt_char_traits@D@@SAH$$QEA$$TAEBQEBD1$$QEAK@Z"
		size = 76
		refs = "0038 __acrt_MessageBoxA"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 B9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_374_3_0 {
	meta:
		name = "??$message_box@$$TAEBQEB_WAEBQEB_WK@?$__crt_char_traits@_W@@SAH$$QEA$$TAEBQEB_W1$$QEAK@Z"
		size = 76
		refs = "0038 __acrt_MessageBoxW"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 B9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_374_4_0 {
	meta:
		name = "??$message_box@PEAUHWND__@@AEBQEBDAEBQEBDAEBI@?$__crt_char_traits@D@@SAH$$QEAPEAUHWND__@@AEBQEBD1AEBI@Z"
		size = 76
		refs = "0038 __acrt_MessageBoxA"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 B9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_374_5_4 {
	meta:
		name = "??$message_box@PEAUHWND__@@AEBQEB_WAEBQEB_WAEBI@?$__crt_char_traits@_W@@SAH$$QEAPEAUHWND__@@AEBQEB_W1AEBI@Z"
		size = 76
		refs = "0038 __acrt_MessageBoxW"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 B9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_31_3 {
	meta:
		name = "??$ulltot_s@AEB_KAEBQEA_WAEB_KH@?$__crt_char_traits@_W@@SAHAEB_KAEBQEA_W0$$QEAH@Z"
		size = 76
		refs = "0038 _ui64tow_s"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 13 00 F9 E3 0F 00 F9 E8 0F 40 F9 03 01 40 B9 E8 13 40 F9 02 01 40 F9 E8 17 40 F9 01 01 40 F9 E8 1B 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_32_0 {
	meta:
		name = "??$ulltot_s@KAEAPEAD_KH@?$__crt_char_traits@D@@SAH$$QEAKAEAPEAD$$QEA_K$$QEAH@Z"
		size = 84
		refs = "0040 _ui64toa_s"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 0F 00 F9 E1 1B 00 F9 E2 17 00 F9 E3 13 00 F9 E8 0F 40 F9 08 01 40 B9 00 7D 40 D3 E8 13 40 F9 03 01 40 B9 E8 17 40 F9 02 01 40 F9 E8 1B 40 F9 01 01 40 F9 00 00 00 91 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_33_0 {
	meta:
		name = "??$ulltot_s@KAEAPEA_W_KH@?$__crt_char_traits@_W@@SAH$$QEAKAEAPEA_W$$QEA_K$$QEAH@Z"
		size = 84
		refs = "0040 _ui64tow_s"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 0F 00 F9 E1 1B 00 F9 E2 17 00 F9 E3 13 00 F9 E8 0F 40 F9 08 01 40 B9 00 7D 40 D3 E8 13 40 F9 03 01 40 B9 E8 17 40 F9 02 01 40 F9 E8 1B 40 F9 01 01 40 F9 00 00 00 91 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_36_0 {
	meta:
		name = "??0?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAA@QEAD@Z"
		size = 40
		altNames = "??0?$__crt_scoped_stack_ptr@D@@QEAA@U?$__crt_scoped_stack_ptr_tag@D@@@Z ??0?$__crt_scoped_stack_ptr@_W@@QEAA@U?$__crt_scoped_stack_ptr_tag@_W@@@Z ??0?$__crt_scoped_stack_ptr_tag@D@@QEAA@QEAD@Z ??0?$__crt_scoped_stack_ptr_tag@_W@@QEAA@QEA_W@Z ??0?$__crt_unique_handle_t@U__crt_findfile_traits@@@@QEAA@QEAX@Z ??0?$__crt_unique_handle_t@U__crt_handle_traits@@@@QEAA@QEAX@Z ??0?$__crt_unique_handle_t@U__crt_hmodule_traits@@@@QEAA@QEAUHINSTANCE__@@@Z ??0?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QEAA@QEBD@Z ??0?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QEAA@QEB_W@Z ??0?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEAA@QEAD@Z ??0?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEAA@QEAE@Z ??0?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QEAA@QEAG@Z ??0?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QEAA@QEAJ@Z ??0?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QEAA@QEAP6AXXZ@Z ??0?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEAA@QEAPEAD@Z ??0?$__crt_unique_heap_ptr@PEAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAA@QEAPEAU__crt_stdio_stream_data@@@Z ??0?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEAA@QEAPEA_W@Z ??0?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@D@@U__crt_internal_free_policy@@@@QEAA@QEAU?$__crt_report_hook_node@D@@@Z ??0?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@_W@@U__crt_internal_free_policy@@@@QEAA@QEAU?$__crt_report_hook_node@_W@@@Z ??0?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QEAA@QEAU__acrt_ptd@@@Z ??0?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QEAA@QEAU__acrt_thread_parameter@@@Z ??0?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QEAA@QEAU__acrt_thread_parameter@@@Z ??0?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QEAA@QEAU__crt_lc_time_data@@@Z ??0?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QEAA@QEAU__crt_locale_data@@@Z ??0?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QEAA@QEAU__crt_locale_pointers@@@Z ??0?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QEAA@QEAU__crt_lowio_handle_data@@@Z ??0?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QEAA@QEAU__crt_multibyte_data@@@Z ??0?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAA@QEAU__crt_stdio_stream_data@@@Z ??0?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QEAA@QEAUlconv@@@Z ??0?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QEAA@QEAUtm@@@Z ??0?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAA@QEA_W@Z ??0?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QEAA@QEA_W@Z ??0?$string_output_adapter@D@__crt_stdio_output@@QEAA@QEAU?$string_output_adapter_context@D@1@@Z ??0?$string_output_adapter@_W@__crt_stdio_output@@QEAA@QEAU?$string_output_adapter_context@_W@1@@Z ??0__crt_stdio_stream@@QEAA@QEAU__crt_stdio_stream_data@@@Z ??0__crt_stdio_stream@@QEAA@QEAU_iobuf@@@Z"
	strings:
		$1 = { FF 43 00 D1 E0 03 00 F9 E1 07 00 F9 E8 03 40 F9 09 01 00 91 E8 07 40 F9 28 01 00 F9 E0 03 40 F9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_38_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_171_4_4 {
	meta:
		name = "??$multiply_ld12_by@$0BA@@@YAXQEAU_LDBL12@@@Z"
		size = 28
		refs = "0010 ??$shl_ld12@$03@@YAXQEAU_LDBL12@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_612_37_4 {
	meta:
		name = "??1?$__crt_unique_handle_t@U__crt_findfile_traits@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?close@?$__crt_unique_handle_t@U__crt_findfile_traits@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_59_55_2 {
	meta:
		name = "??1?$__crt_unique_handle_t@U__crt_handle_traits@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?close@?$__crt_unique_handle_t@U__crt_handle_traits@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_51_12_4 {
	meta:
		name = "??1?$__crt_unique_handle_t@U__crt_hmodule_traits@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?close@?$__crt_unique_handle_t@U__crt_hmodule_traits@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_680_44_2 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_680_45_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_169_12_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_641_168_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_325_7_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_73_2_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_550_21_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_612_40_3 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_358_15_3 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@PEAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@PEAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_612_41_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_559_30_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@D@@U__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@D@@U__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_559_31_3 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@_W@@U__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@_W@@U__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_447_27_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_265_7_2 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_265_8_2 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_466_8_2 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_691_37_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_691_38_3 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_226_2_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_691_39_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_337_5_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_450_5_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_630_8_2 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_184_6_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_169_13_2 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QEAA@XZ"
		size = 28
		refs = "0010 ?release@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_325_4 {
	meta:
		name = "??1?$format_validation_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$standard_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_326_2 {
	meta:
		name = "??1?$format_validation_base@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$standard_base@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_327_3 {
	meta:
		name = "??1?$format_validation_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$standard_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_328_0 {
	meta:
		name = "??1?$format_validation_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$standard_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_329_0 {
	meta:
		name = "??1?$output_adapter_data@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$common_data@D@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_330_4 {
	meta:
		name = "??1?$output_adapter_data@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$common_data@D@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_331_3 {
	meta:
		name = "??1?$output_adapter_data@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$common_data@_W@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_332_4 {
	meta:
		name = "??1?$output_adapter_data@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$common_data@_W@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_333_2 {
	meta:
		name = "??1?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$format_validation_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_334_2 {
	meta:
		name = "??1?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$positional_parameter_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_335_2 {
	meta:
		name = "??1?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$standard_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_336_2 {
	meta:
		name = "??1?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$format_validation_base@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_337_3 {
	meta:
		name = "??1?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$positional_parameter_base@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_338_4 {
	meta:
		name = "??1?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$standard_base@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_339_0 {
	meta:
		name = "??1?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$format_validation_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_340_3 {
	meta:
		name = "??1?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$positional_parameter_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_341_3 {
	meta:
		name = "??1?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$standard_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_342_0 {
	meta:
		name = "??1?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$format_validation_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_343_4 {
	meta:
		name = "??1?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$positional_parameter_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_344_2 {
	meta:
		name = "??1?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$standard_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_345_0 {
	meta:
		name = "??1?$positional_parameter_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$format_validation_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_346_0 {
	meta:
		name = "??1?$positional_parameter_base@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$format_validation_base@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_347_2 {
	meta:
		name = "??1?$positional_parameter_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$format_validation_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_348_2 {
	meta:
		name = "??1?$positional_parameter_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$format_validation_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_349_2 {
	meta:
		name = "??1?$standard_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$output_adapter_data@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_350_2 {
	meta:
		name = "??1?$standard_base@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$output_adapter_data@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_351_2 {
	meta:
		name = "??1?$standard_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$output_adapter_data@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_352_2 {
	meta:
		name = "??1?$standard_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
		size = 28
		refs = "0010 ??1?$output_adapter_data@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_538_0_3 {
	meta:
		name = "_aligned_free"
		size = 28
		refs = "0010 _aligned_free_dbg"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_523_2_3 {
	meta:
		name = "_ftime32"
		size = 28
		refs = "0010 _ftime32_s"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_523_4_3 {
	meta:
		name = "_ftime64"
		size = 28
		refs = "0010 _ftime64_s"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_396_4_3 {
	meta:
		name = "clearerr"
		size = 28
		refs = "0010 clearerr_s"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_43_0 {
	meta:
		name = "?common_tmpfile@@YAHQEAPEAU_iobuf@@H@Z"
		size = 312
		refs = "0044 ??_C@_1CE@JLIJLEKO@?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 004c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 005c ??_C@_1GC@NNHAGHGE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0068 _CrtDbgReportW 0090 _errno 00b4 ??_C@_1BO@JPOBIAKL@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAt?$AAm?$AAp?$AAf?$AAi?$AAl?$AAe?$AA?$AA@ 00c4 _invalid_parameter 00e8 __acrt_lock 00f4 ?common_tmpfile_nolock@@YAHQEAPEAU_iobuf@@H@Z 0128 __acrt_unlock"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 A0 17 00 F9 A1 23 00 B9 A8 17 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 A8 17 00 B9 03 00 00 14 08 00 80 52 A8 17 00 B9 A8 17 40 B9 A8 1B 00 B9 A8 1B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 34 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? A0 1F 00 B9 A9 1F 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 A8 1B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? A0 1B 00 F9 A9 1B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 83 34 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 19 00 00 14 A9 17 40 F9 08 00 80 D2 28 01 00 F9 08 00 80 52 A8 13 00 B9 80 01 80 52 ?? ?? ?? ?? A1 23 40 B9 A0 17 40 F9 ?? ?? ?? ?? A0 27 00 B9 A8 27 40 B9 A8 13 00 B9 A8 13 40 B9 1F 01 00 71 C0 00 00 54 ?? ?? ?? ?? A0 1F 00 F9 A9 1F 40 F9 A8 13 40 B9 28 01 00 B9 80 01 80 52 ?? ?? ?? ?? A0 13 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_45_0 {
	meta:
		name = "?common_tmpfile_nolock@@YAHQEAPEAU_iobuf@@H@Z"
		size = 768
		refs = "0014 ??$get_tmpfile_buffer_nolock@D@@YAPEADW4buffer_id@?A0x5b9a7937@@@Z 0058 ??$initialize_tmpfile_buffer_nolock@D@@YA_NW4buffer_id@?A0x5b9a7937@@@Z 0084 ??$generate_tmpfile_file_name@D@@YA_NQEAD_K@Z 00a8 ?__acrt_stdio_allocate_stream@@YA?AV__crt_stdio_stream@@XZ 00b0 ?valid@__crt_stdio_stream@@QEBA_NXZ 00d8 _errno 012c _sopen_s 01b0 ??_C@_0DB@FLJKHJDH@minkernel?2crts?2ucrt?2src?2appcrt?2s@ 01c0 _strdup_dbg 01cc ??C__crt_stdio_stream@@QEBAPEAU__crt_stdio_stream_data@@XZ 0208 _close 026c _commode 0280 ?set_flags@__crt_stdio_stream@@QEBA_NJ@Z 02a4 ?public_stream@__crt_stdio_stream@@QEBAPEAU_iobuf@@XZ 02e4 ?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z 02ec ?unlock@__crt_stdio_stream@@QEBAXXZ"
	strings:
		$1 = { FD 7B B3 A9 FD 03 00 91 A0 5B 00 F9 A1 33 00 B9 20 00 80 52 ?? ?? ?? ?? A0 2B 00 F9 A8 2B 40 F9 A8 17 00 F9 88 20 80 D2 A8 63 00 F9 A8 17 40 F9 1F 01 00 F1 61 00 00 54 80 01 80 52 AE 00 00 14 A8 17 40 F9 08 01 C0 39 08 01 00 11 1F 01 00 71 61 01 00 54 20 00 80 52 ?? ?? ?? ?? A0 43 00 39 A8 43 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 C0 02 80 52 A0 00 00 14 0B 00 00 14 81 20 80 D2 A0 17 40 F9 ?? ?? ?? ?? A0 47 00 39 A8 47 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 C0 02 80 52 95 00 00 14 A0 63 00 91 ?? ?? ?? ?? A0 63 00 91 ?? ?? ?? ?? A0 4B 00 39 A8 4B 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 00 03 80 52 8A 00 00 14 08 00 80 52 A8 23 00 B9 ?? ?? ?? ?? A0 2F 00 F9 A8 2F 40 F9 08 01 40 B9 A8 3B 00 B9 ?? ?? ?? ?? A0 33 00 F9 A9 33 40 F9 08 00 80 52 28 01 00 B9 08 00 80 52 A8 27 00 B9 48 A8 90 52 A8 4B 00 B9 08 30 80 52 A8 4F 00 B9 04 30 80 52 A3 33 40 B9 42 A8 90 52 A1 17 40 F9 A0 93 00 91 ?? ?? ?? ?? A0 37 00 B9 A8 37 40 B9 A8 23 00 B9 A8 23 40 B9 1F 45 00 71 61 01 00 54 81 20 80 D2 A0 17 40 F9 ?? ?? ?? ?? A0 4F 00 39 A8 4F 40 39 08 01 00 11 1F 01 00 71 41 00 00 54 02 00 00 14 EB FF FF 17 ?? ?? ?? ?? A0 37 00 F9 A8 37 40 F9 08 01 40 B9 1F 01 00 71 C1 00 00 54 ?? ?? ?? ?? A0 3B 00 F9 A9 3B 40 F9 A8 3B 40 B9 28 01 00 B9 A8 27 40 B9 1F 05 00 31 41 00 00 54 46 00 00 14 43 30 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 41 00 80 52 A0 17 40 F9 ?? ?? ?? ?? A0 43 00 F9 A0 63 00 91 ?? ?? ?? ?? A0 3F 00 F9 A8 3F 40 F9 09 A1 00 91 A8 43 40 F9 28 01 00 F9 A0 63 00 91 ?? ?? ?? ?? A0 47 00 F9 A8 47 40 F9 08 A1 00 91 08 01 40 F9 1F 01 00 F1 C1 00 00 54 A0 27 40 B9 ?? ?? ?? ?? 88 01 80 52 A8 23 00 B9 2B 00 00 14 A0 63 00 91 ?? ?? ?? ?? A0 4B 00 F9 A8 4B 40 F9 09 41 00 91 08 00 80 52 28 01 00 B9 A0 63 00 91 ?? ?? ?? ?? A0 4F 00 F9 A8 4F 40 F9 09 21 00 91 08 00 80 D2 28 01 00 F9 A0 63 00 91 ?? ?? ?? ?? A0 53 00 F9 A8 53 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 ?? ?? ?? ?? ?? ?? ?? ?? 01 01 1E 32 21 00 00 11 A0 63 00 91 ?? ?? ?? ?? A0 63 00 91 ?? ?? ?? ?? A0 57 00 F9 A8 57 40 F9 09 61 00 91 A8 27 40 B9 28 01 00 B9 A0 63 00 91 ?? ?? ?? ?? A0 5F 00 F9 A9 5B 40 F9 A8 5F 40 F9 28 01 00 F9 08 00 80 52 A8 23 00 B9 A0 63 00 91 ?? ?? ?? ?? A0 23 00 F9 A8 23 40 F9 08 61 00 91 08 01 40 B9 1F 05 00 31 61 00 00 54 A0 0F 40 F9 ?? ?? ?? ?? A0 63 00 91 ?? ?? ?? ?? A0 23 40 B9 FD 7B CD A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_27_46_0 {
	meta:
		name = "?fin$0@?0??common_tmpfile_nolock@@YAHQEAPEAU_iobuf@@H@Z@4HA"
		size = 68
		refs = "000c ??C__crt_stdio_stream@@QEBAPEAU__crt_stdio_stream_data@@XZ 002c ?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z 0034 ?unlock@__crt_stdio_stream@@QEBAXXZ"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 A0 63 00 91 ?? ?? ?? ?? A0 23 00 F9 A8 23 40 F9 08 61 00 91 08 01 40 B9 1F 05 00 31 61 00 00 54 A0 0F 40 F9 ?? ?? ?? ?? A0 63 00 91 ?? ?? ?? ?? 01 00 00 14 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_47_0 {
	meta:
		name = "?detach@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAAPEADXZ"
		size = 52
		altNames = "?detach@?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QEAAPEBDXZ ?detach@?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QEAAPEB_WXZ ?detach@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEAAPEADXZ ?detach@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEAAPEAEXZ ?detach@?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QEAAPEAGXZ ?detach@?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QEAAPEAJXZ ?detach@?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QEAAPEAP6AXXZXZ ?detach@?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEAAPEAPEADXZ ?detach@?$__crt_unique_heap_ptr@PEAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAAPEAPEAU__crt_stdio_stream_data@@XZ ?detach@?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEAAPEAPEA_WXZ ?detach@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@D@@U__crt_internal_free_policy@@@@QEAAPEAU?$__crt_report_hook_node@D@@XZ ?detach@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@_W@@U__crt_internal_free_policy@@@@QEAAPEAU?$__crt_report_hook_node@_W@@XZ ?detach@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QEAAPEAU__acrt_ptd@@XZ ?detach@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QEAAPEAU__acrt_thread_parameter@@XZ ?detach@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QEAAPEAU__acrt_thread_parameter@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QEAAPEAU__crt_lc_time_data@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QEAAPEAU__crt_locale_data@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QEAAPEAU__crt_locale_pointers@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QEAAPEAU__crt_lowio_handle_data@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QEAAPEAU__crt_multibyte_data@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAAPEAU__crt_stdio_stream_data@@XZ ?detach@?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QEAAPEAUlconv@@XZ ?detach@?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QEAAPEAUtm@@XZ ?detach@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAAPEA_WXZ ?detach@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QEAAPEA_WXZ"
	strings:
		$1 = { FF 43 00 D1 E0 03 00 F9 E8 03 40 F9 08 01 00 91 08 01 40 F9 E8 07 00 F9 E8 03 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 E0 07 40 F9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_49_0 {
	meta:
		name = "?get_tmpfile_buffer_pointer_nolock@@YAAEAPEADW4buffer_id@?A0x5b9a7937@@D@Z"
		size = 52
		refs = "001c ?narrow_tmpfile_buffer_pointers@@3PAPEADA"
	strings:
		$1 = { FF 43 00 D1 E0 07 00 B9 E1 03 00 39 E8 07 40 B9 09 7D 40 93 08 01 80 D2 29 7D 08 9B ?? ?? ?? ?? ?? ?? ?? ?? 00 01 09 8B 00 00 00 91 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_50_0 {
	meta:
		name = "?get_tmpfile_buffer_pointer_nolock@@YAAEAPEA_WW4buffer_id@?A0x5b9a7937@@_W@Z"
		size = 52
		refs = "001c ?wide_tmpfile_buffer_pointers@@3PAPEA_WA"
	strings:
		$1 = { FF 43 00 D1 E0 07 00 B9 E1 03 00 79 E8 07 40 B9 09 7D 40 93 08 01 80 D2 29 7D 08 9B ?? ?? ?? ?? ?? ?? ?? ?? 00 01 09 8B 00 00 00 91 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_51_0 {
	meta:
		name = "?get_tmpnam_ptd_buffer@@YAPEAPEADD@Z"
		size = 68
		refs = "000c __acrt_getptd_noexit"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 43 00 39 ?? ?? ?? ?? E0 13 00 F9 E8 13 40 F9 E8 0F 00 F9 E8 0F 40 F9 1F 01 00 F1 61 00 00 54 00 00 80 D2 04 00 00 14 E8 0F 40 F9 00 21 01 91 00 00 00 91 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_52_0 {
	meta:
		name = "?get_tmpnam_ptd_buffer@@YAPEAPEA_W_W@Z"
		size = 68
		refs = "000c __acrt_getptd_noexit"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 23 00 79 ?? ?? ?? ?? E0 13 00 F9 E8 13 40 F9 E8 0F 00 F9 E8 0F 40 F9 1F 01 00 F1 61 00 00 54 00 00 80 D2 04 00 00 14 E8 0F 40 F9 00 41 01 91 00 00 00 91 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_53_0 {
	meta:
		name = "?public_stream@__crt_stdio_stream@@QEBAPEAU_iobuf@@XZ"
		size = 36
	strings:
		$1 = { FF 43 00 D1 E0 03 00 F9 E8 03 40 F9 08 01 00 91 08 01 40 F9 00 01 00 91 00 00 00 91 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_54_0 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RD@__crt_internal_free_policy@@QEBAXQEBD@Z"
		altNames = "?release@?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_680_69_3 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?R_W@__crt_internal_free_policy@@QEBAXQEB_W@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_169_24_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RD@__crt_public_free_policy@@QEBAXQEBD@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_490_39_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RE@__crt_internal_free_policy@@QEBAXQEBE@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_325_13_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RG@__crt_internal_free_policy@@QEBAXQEBG@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_325_14_2 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RJ@__crt_internal_free_policy@@QEBAXQEBJ@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_550_34_2 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RP6AXXZ@__crt_internal_free_policy@@QEBAXQEBQ6AXXZ@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_612_81_0 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RPEAD@__crt_internal_free_policy@@QEBAXQEBQEAD@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_358_26_2 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@PEAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RPEAU__crt_stdio_stream_data@@@__crt_internal_free_policy@@QEBAXQEBQEAU__crt_stdio_stream_data@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_490_41_0 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RPEA_W@__crt_internal_free_policy@@QEBAXQEBQEA_W@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_559_52_3 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@D@@U__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RU?$__crt_report_hook_node@D@@@__crt_internal_free_policy@@QEBAXQEBU?$__crt_report_hook_node@D@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_559_53_3 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@_W@@U__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RU?$__crt_report_hook_node@_W@@@__crt_internal_free_policy@@QEBAXQEBU?$__crt_report_hook_node@_W@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_447_54_3 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RU__acrt_ptd@@@__crt_internal_free_policy@@QEBAXQEBU__acrt_ptd@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_265_19_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RU__acrt_thread_parameter@@@__crt_internal_free_policy@@QEBAXQEBU__acrt_thread_parameter@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_265_20_0 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QEAAXXZ"
		size = 56
		refs = "001c ??Rthread_parameter_free_policy@?A0x4e93fcdd@@QEAAXQEAU__acrt_thread_parameter@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_466_16_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RU__crt_lc_time_data@@@__crt_internal_free_policy@@QEBAXQEBU__crt_lc_time_data@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_691_69_3 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RU__crt_locale_data@@@__crt_internal_free_policy@@QEBAXQEBU__crt_locale_data@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_691_70_3 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RU__crt_locale_pointers@@@__crt_internal_free_policy@@QEBAXQEBU__crt_locale_pointers@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_226_7_2 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RU__crt_lowio_handle_data@@@__crt_internal_free_policy@@QEBAXQEBU__crt_lowio_handle_data@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_691_71_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RU__crt_multibyte_data@@@__crt_internal_free_policy@@QEBAXQEBU__crt_multibyte_data@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_337_18_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RU__crt_stdio_stream_data@@@__crt_internal_free_policy@@QEBAXQEBU__crt_stdio_stream_data@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_450_9_2 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RUlconv@@@__crt_internal_free_policy@@QEBAXQEBUlconv@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_630_12_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?RUtm@@@__crt_internal_free_policy@@QEBAXQEBUtm@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_268_5_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?R_W@__crt_internal_free_policy@@QEBAXQEB_W@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_169_25_3 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QEAAXXZ"
		size = 56
		refs = "001c ??$?R_W@__crt_public_free_policy@@QEBAXQEB_W@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 01 01 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 0F 40 F9 09 01 00 91 08 00 80 D2 28 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_56_0 {
	meta:
		name = "?set_flags@__crt_stdio_stream@@QEBA_NJ@Z"
		size = 132
	strings:
		$1 = { FF 83 00 D1 E0 0B 00 F9 E1 03 00 B9 EC 03 40 B9 8C 01 00 11 E8 0B 40 F9 08 01 00 91 08 01 40 F9 0B 51 00 91 6B 01 00 91 6A FD 5F 88 4A 01 00 11 49 01 0C 2A 69 FD 08 88 1F 01 00 71 61 FF FF 54 BF 3B 03 D5 EA 0B 00 B9 E9 0B 40 B9 E8 03 40 B9 28 01 08 0A 1F 01 00 71 80 00 00 54 28 00 80 52 E8 07 00 B9 03 00 00 14 08 00 80 52 E8 07 00 B9 E8 07 40 B9 00 1D 00 53 00 00 00 11 FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_57_0 {
	meta:
		name = "?strrchr@@YAPEADQEADH@Z"
		size = 44
		refs = "0018 strrchr"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 13 00 B9 E1 13 40 B9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 F9 E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_58_0 {
	meta:
		name = "?unlock@__crt_stdio_stream@@QEBAXXZ"
		size = 40
		refs = "0010 ?public_stream@__crt_stdio_stream@@QEBAPEAU_iobuf@@XZ 001c _unlock_file"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_337_16_0 {
	meta:
		name = "?lock@__crt_stdio_stream@@QEBAXXZ"
		size = 40
		refs = "0010 ?public_stream@__crt_stdio_stream@@QEBAPEAU_iobuf@@XZ 001c _lock_file"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 E0 0B 40 F9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_59_0 {
	meta:
		name = "?valid@__crt_stdio_stream@@QEBA_NXZ"
		size = 68
		altNames = "??B?$__crt_scoped_stack_ptr@D@@QEBA_NXZ ??B?$__crt_scoped_stack_ptr@_W@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@D@@U__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@_W@@U__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QEBA_NXZ"
	strings:
		$1 = { FF 43 00 D1 E0 07 00 F9 E8 07 40 F9 08 01 00 91 08 01 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 00 1D 00 53 00 00 00 11 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_60_0 {
	meta:
		name = "?wcsrchr@@YAPEA_WPEA_W_W@Z"
		size = 44
		refs = "0018 wcsrchr"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 23 00 79 E1 23 40 79 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 F9 E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_477_0_0 {
	meta:
		name = "?wcschr@@YAPEA_WPEA_W_W@Z"
		size = 44
		refs = "0018 wcschr"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 23 00 79 E1 23 40 79 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 F9 E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_62_0 {
	meta:
		name = "__acrt_stdio_free_tmpfile_name_buffers_nolock"
		size = 224
		refs = "0008 ?narrow_tmpfile_buffer_pointers@@3PAPEADA 005c _free_dbg 0070 ?wide_tmpfile_buffer_pointers@@3PAPEA_WA"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? E8 13 00 F9 E8 13 40 F9 E8 0B 00 F9 E8 13 40 F9 08 61 00 91 E8 23 00 F9 04 00 00 14 E8 0B 40 F9 08 21 00 91 E8 0B 00 F9 E9 23 40 F9 E8 0B 40 F9 1F 01 09 EB 60 01 00 54 E8 0B 40 F9 E8 17 00 F9 41 00 80 52 E8 17 40 F9 00 01 40 F9 ?? ?? ?? ?? E9 17 40 F9 08 00 80 D2 28 01 00 F9 F0 FF FF 17 ?? ?? ?? ?? ?? ?? ?? ?? E8 1B 00 F9 E8 1B 40 F9 E8 0F 00 F9 E8 1B 40 F9 08 61 00 91 E8 27 00 F9 04 00 00 14 E8 0F 40 F9 08 21 00 91 E8 0F 00 F9 E9 27 40 F9 E8 0F 40 F9 1F 01 09 EB 60 01 00 54 E8 0F 40 F9 E8 1F 00 F9 41 00 80 52 E8 1F 40 F9 00 01 40 F9 ?? ?? ?? ?? E9 1F 40 F9 08 00 80 D2 28 01 00 F9 F0 FF FF 17 FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_63_0 {
	meta:
		name = "_invoke_watson_if_error"
		size = 80
		refs = "0044 _invoke_watson"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 13 00 B9 E1 1B 00 F9 E2 17 00 F9 E3 13 00 F9 E4 17 00 B9 E5 0F 00 F9 E8 13 40 B9 1F 01 00 71 41 00 00 54 07 00 00 14 E4 0F 40 F9 E3 17 40 B9 E2 13 40 F9 E1 17 40 F9 E0 1B 40 F9 ?? ?? ?? ?? FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_64_0 {
	meta:
		name = "_wtmpnam"
		size = 52
		refs = "0024 ??$common_tmpnam@_W@@YAHQEA_W_KW4buffer_id@?A0x5b9a7937@@QEAPEA_W@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 08 00 80 D2 E8 0B 00 F9 E3 43 00 91 02 00 80 52 81 20 80 D2 E0 0F 40 F9 ?? ?? ?? ?? E0 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_68_0 {
	meta:
		name = "tmpnam"
		size = 52
		refs = "0024 ??$common_tmpnam@D@@YAHQEAD_KW4buffer_id@?A0x5b9a7937@@QEAPEAD@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 08 00 80 D2 E8 0B 00 F9 E3 43 00 91 02 00 80 52 81 20 80 D2 E0 0F 40 F9 ?? ?? ?? ?? E0 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_65_0 {
	meta:
		name = "_wtmpnam_s"
		size = 252
		refs = "004c ??_C@_1DC@MGKAFPFD@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0054 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0064 ??_C@_1GC@NNHAGHGE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0070 _CrtDbgReportW 0098 _errno 00bc ??_C@_1BG@OOCNCNMF@?$AA_?$AAw?$AAt?$AAm?$AAp?$AAn?$AAa?$AAm?$AA_?$AAs?$AA?$AA@ 00cc _invalid_parameter 00e8 ??$common_tmpnam@_W@@YAHQEA_W_KW4buffer_id@?A0x5b9a7937@@QEAPEA_W@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 13 00 F9 E1 1F 00 F9 08 00 80 D2 E8 1B 00 F9 E8 13 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 13 00 B9 03 00 00 14 08 00 80 52 E8 13 00 B9 E8 13 40 B9 E8 17 00 B9 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 39 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 17 00 F9 E9 17 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 83 39 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 08 00 00 14 E3 C3 00 91 42 00 80 52 E1 1F 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 1F 00 B9 E0 1F 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_66_0 {
	meta:
		name = "tmpfile"
		size = 40
		refs = "0018 ?common_tmpfile@@YAHQEAPEAU_iobuf@@H@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 08 00 80 D2 E8 0B 00 F9 01 08 80 52 E0 43 00 91 ?? ?? ?? ?? E0 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_67_0 {
	meta:
		name = "tmpfile_s"
		size = 40
		refs = "0014 ?common_tmpfile@@YAHQEAPEAU_iobuf@@H@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 01 02 80 52 E0 0F 40 F9 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_69_0 {
	meta:
		name = "tmpnam_s"
		size = 252
		refs = "004c ??_C@_1DC@MGKAFPFD@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0054 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0064 ??_C@_1GC@NNHAGHGE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0070 _CrtDbgReportW 0098 _errno 00bc ??_C@_1BC@LALKNPAF@?$AAt?$AAm?$AAp?$AAn?$AAa?$AAm?$AA_?$AAs?$AA?$AA@ 00cc _invalid_parameter 00e8 ??$common_tmpnam@D@@YAHQEAD_KW4buffer_id@?A0x5b9a7937@@QEAPEAD@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 13 00 F9 E1 1F 00 F9 08 00 80 D2 E8 1B 00 F9 E8 13 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 13 00 B9 03 00 00 14 08 00 80 52 E8 13 00 B9 E8 13 40 B9 E8 17 00 B9 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 38 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 17 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 17 00 F9 E9 17 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 43 38 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 08 00 00 14 E3 C3 00 91 42 00 80 52 E1 1F 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 1F 00 B9 E0 1F 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "csinl"
		size = 196
		refs = "0018 creall 0028 cimagl 0040 _LCbuild 0054 csinhl"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 1B 00 FD E1 1F 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 0F 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 0B 00 FD F0 0B 40 FD 00 42 61 1E E1 0F 40 FD 00 40 60 1E ?? ?? ?? ?? E1 27 00 FD E0 23 00 FD E1 27 40 FD E0 23 40 FD ?? ?? ?? ?? E1 37 00 FD E0 33 00 FD EA C3 00 91 4A 01 00 91 E8 83 01 91 08 01 00 91 09 21 40 A9 49 21 00 A9 E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 13 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 17 00 FD F0 13 40 FD 01 42 61 1E 21 40 60 1E E0 17 40 FD ?? ?? ?? ?? E1 2F 00 FD E0 2B 00 FD E0 2B 40 FD E1 2F 40 FD FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_655_0_0 {
	meta:
		name = "casin"
		size = 196
		refs = "0018 creal 0028 cimag 0040 _Cbuild 0054 casinh"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 1B 00 FD E1 1F 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 0F 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 0B 00 FD F0 0B 40 FD 00 42 61 1E E1 0F 40 FD 00 40 60 1E ?? ?? ?? ?? E1 27 00 FD E0 23 00 FD E1 27 40 FD E0 23 40 FD ?? ?? ?? ?? E1 37 00 FD E0 33 00 FD EA C3 00 91 4A 01 00 91 E8 83 01 91 08 01 00 91 09 21 40 A9 49 21 00 A9 E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 13 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 17 00 FD F0 13 40 FD 01 42 61 1E 21 40 60 1E E0 17 40 FD ?? ?? ?? ?? E1 2F 00 FD E0 2B 00 FD E0 2B 40 FD E1 2F 40 FD FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_478_0_0 {
	meta:
		name = "casinl"
		size = 196
		refs = "0018 creall 0028 cimagl 0040 _LCbuild 0054 casinhl"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 1B 00 FD E1 1F 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 0F 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 0B 00 FD F0 0B 40 FD 00 42 61 1E E1 0F 40 FD 00 40 60 1E ?? ?? ?? ?? E1 27 00 FD E0 23 00 FD E1 27 40 FD E0 23 40 FD ?? ?? ?? ?? E1 37 00 FD E0 33 00 FD EA C3 00 91 4A 01 00 91 E8 83 01 91 08 01 00 91 09 21 40 A9 49 21 00 A9 E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 13 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 17 00 FD F0 13 40 FD 01 42 61 1E 21 40 60 1E E0 17 40 FD ?? ?? ?? ?? E1 2F 00 FD E0 2B 00 FD E0 2B 40 FD E1 2F 40 FD FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_321_0_3 {
	meta:
		name = "catan"
		size = 196
		refs = "0018 creal 0028 cimag 0040 _Cbuild 0054 catanh"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 1B 00 FD E1 1F 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 0F 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 0B 00 FD F0 0B 40 FD 00 42 61 1E E1 0F 40 FD 00 40 60 1E ?? ?? ?? ?? E1 27 00 FD E0 23 00 FD E1 27 40 FD E0 23 40 FD ?? ?? ?? ?? E1 37 00 FD E0 33 00 FD EA C3 00 91 4A 01 00 91 E8 83 01 91 08 01 00 91 09 21 40 A9 49 21 00 A9 E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 13 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 17 00 FD F0 13 40 FD 01 42 61 1E 21 40 60 1E E0 17 40 FD ?? ?? ?? ?? E1 2F 00 FD E0 2B 00 FD E0 2B 40 FD E1 2F 40 FD FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_356_0_3 {
	meta:
		name = "catanl"
		size = 196
		refs = "0018 creall 0028 cimagl 0040 _LCbuild 0054 catanhl"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 1B 00 FD E1 1F 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 0F 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 0B 00 FD F0 0B 40 FD 00 42 61 1E E1 0F 40 FD 00 40 60 1E ?? ?? ?? ?? E1 27 00 FD E0 23 00 FD E1 27 40 FD E0 23 40 FD ?? ?? ?? ?? E1 37 00 FD E0 33 00 FD EA C3 00 91 4A 01 00 91 E8 83 01 91 08 01 00 91 09 21 40 A9 49 21 00 A9 E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 13 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 17 00 FD F0 13 40 FD 01 42 61 1E 21 40 60 1E E0 17 40 FD ?? ?? ?? ?? E1 2F 00 FD E0 2B 00 FD E0 2B 40 FD E1 2F 40 FD FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_692_0_3 {
	meta:
		name = "csin"
		size = 196
		refs = "0018 creal 0028 cimag 0040 _Cbuild 0054 csinh"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 1B 00 FD E1 1F 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 0F 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 0B 00 FD F0 0B 40 FD 00 42 61 1E E1 0F 40 FD 00 40 60 1E ?? ?? ?? ?? E1 27 00 FD E0 23 00 FD E1 27 40 FD E0 23 40 FD ?? ?? ?? ?? E1 37 00 FD E0 33 00 FD EA C3 00 91 4A 01 00 91 E8 83 01 91 08 01 00 91 09 21 40 A9 49 21 00 A9 E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 13 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 17 00 FD F0 13 40 FD 01 42 61 1E 21 40 60 1E E0 17 40 FD ?? ?? ?? ?? E1 2F 00 FD E0 2B 00 FD E0 2B 40 FD E1 2F 40 FD FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "ctan"
		size = 196
		refs = "0018 creal 0028 cimag 0040 _Cbuild 0054 ctanh"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 1B 00 FD E1 1F 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 0F 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 0B 00 FD F0 0B 40 FD 00 42 61 1E E1 0F 40 FD 00 40 60 1E ?? ?? ?? ?? E1 27 00 FD E0 23 00 FD E1 27 40 FD E0 23 40 FD ?? ?? ?? ?? E1 37 00 FD E0 33 00 FD EA C3 00 91 4A 01 00 91 E8 83 01 91 08 01 00 91 09 21 40 A9 49 21 00 A9 E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 13 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 17 00 FD F0 13 40 FD 01 42 61 1E 21 40 60 1E E0 17 40 FD ?? ?? ?? ?? E1 2F 00 FD E0 2B 00 FD E0 2B 40 FD E1 2F 40 FD FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_85_0_4 {
	meta:
		name = "ctanl"
		size = 196
		refs = "0018 creall 0028 cimagl 0040 _LCbuild 0054 ctanhl"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 1B 00 FD E1 1F 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 0F 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 0B 00 FD F0 0B 40 FD 00 42 61 1E E1 0F 40 FD 00 40 60 1E ?? ?? ?? ?? E1 27 00 FD E0 23 00 FD E1 27 40 FD E0 23 40 FD ?? ?? ?? ?? E1 37 00 FD E0 33 00 FD EA C3 00 91 4A 01 00 91 E8 83 01 91 08 01 00 91 09 21 40 A9 49 21 00 A9 E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 13 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 17 00 FD F0 13 40 FD 01 42 61 1E 21 40 60 1E E0 17 40 FD ?? ?? ?? ?? E1 2F 00 FD E0 2B 00 FD E0 2B 40 FD E1 2F 40 FD FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "llround"
		size = 176
		refs = "0010 _dtest 004c round 0090 _fperrraise"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 FD E0 63 00 91 ?? ?? ?? ?? E0 23 00 79 E8 23 C0 79 08 01 00 11 E8 17 00 B9 E8 17 40 B9 1F 01 00 71 40 03 00 54 E8 17 40 B9 1F 01 00 71 8D 00 00 54 E8 17 40 B9 1F 09 00 71 4D 02 00 54 E0 0F 40 FD ?? ?? ?? ?? E0 13 00 FD F0 13 40 FD F0 0F 00 FD F1 0F 40 FD 10 02 00 5C 00 22 71 1E 28 01 00 54 F1 01 00 5C F0 0F 40 FD 00 22 71 1E A8 00 00 54 F0 0F 40 FD 00 02 78 9E 00 00 00 91 04 00 00 14 20 00 80 52 ?? ?? ?? ?? 00 00 80 D2 FD 7B C3 A8 C0 03 5F D6 00 00 00 00 00 00 E0 C3 00 00 00 00 00 00 E0 43 }
	condition:
		$1
}

rule file_496_0_0 {
	meta:
		name = "llroundl"
		size = 176
		refs = "0010 _ldtest 004c roundl 0090 _fperrraise"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 FD E0 63 00 91 ?? ?? ?? ?? E0 23 00 79 E8 23 C0 79 08 01 00 11 E8 17 00 B9 E8 17 40 B9 1F 01 00 71 40 03 00 54 E8 17 40 B9 1F 01 00 71 8D 00 00 54 E8 17 40 B9 1F 09 00 71 4D 02 00 54 E0 0F 40 FD ?? ?? ?? ?? E0 13 00 FD F0 13 40 FD F0 0F 00 FD F1 0F 40 FD 10 02 00 5C 00 22 71 1E 28 01 00 54 F1 01 00 5C F0 0F 40 FD 00 22 71 1E A8 00 00 54 F0 0F 40 FD 00 02 78 9E 00 00 00 91 04 00 00 14 20 00 80 52 ?? ?? ?? ?? 00 00 80 D2 FD 7B C3 A8 C0 03 5F D6 00 00 00 00 00 00 E0 C3 00 00 00 00 00 00 E0 43 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "??1scoped_global_state_reset@__crt_state_management@@QEAA@XZ"
		size = 16
		altNames = "?select_heap@@YAPEAXQEAX@Z _CrtSetAllocHook _CrtSetDebugFillThreshold _CrtSetDumpClient _CrtSetReportHook nan nanf nanl"
	strings:
		$1 = { FF 43 00 D1 E0 03 00 F9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_30_1_0 {
	meta:
		name = "_lsearch_s"
		size = 1228
		refs = "0054 ??_C@_1BO@GJOLAGLP@?$AAk?$AAe?$AAy?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 005c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 006c ??_C@_1GE@DHIJHLDF@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0078 _CrtDbgReportW 00a0 _errno 00c4 ??_C@_1BG@BABOCLIN@?$AA_?$AAl?$AAs?$AAe?$AAa?$AAr?$AAc?$AAh?$AA_?$AAs?$AA?$AA@ 00d4 _invalid_parameter 0114 ??_C@_1BO@DPJBHFOB@?$AAn?$AAu?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01d4 ??_C@_1CA@IMEMOBFB@?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0294 ??_C@_1BE@NJBEBBME@?$AAw?$AAi?$AAd?$AAt?$AAh?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0354 ??_C@_1CG@PNGKIMLM@?$AAc?$AAo?$AAm?$AAp?$AAa?$AAr?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0440 __guard_check_icall_fptr 047c ??1scoped_global_state_reset@__crt_state_management@@QEAA@XZ 0498 memcpy"
	strings:
		$1 = { FD 7B B2 A9 FD 03 00 91 E0 3B 00 F9 E1 43 00 F9 E2 2B 00 F9 E3 27 00 F9 E4 4B 00 F9 E5 67 00 F9 E8 3B 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 17 00 B9 03 00 00 14 08 00 80 52 E8 17 00 B9 E8 17 40 B9 E8 1B 00 B9 E8 1B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 08 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 5B 00 B9 E9 5B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 1B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 53 00 F9 E9 53 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 43 08 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 FA 00 00 14 E8 2B 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 1F 00 B9 03 00 00 14 08 00 80 52 E8 1F 00 B9 E8 1F 40 B9 E8 23 00 B9 E8 23 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 08 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 5F 00 B9 E9 5F 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 23 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 57 00 F9 E9 57 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 63 08 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 CA 00 00 14 E8 43 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 27 00 B9 03 00 00 14 08 00 80 52 E8 27 00 B9 E8 27 40 B9 E8 2B 00 B9 E8 2B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 08 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 63 00 B9 E9 63 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 2B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 5B 00 F9 E9 5B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 83 08 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 9A 00 00 14 E8 27 40 F9 1F 01 00 F1 89 00 00 54 28 00 80 52 E8 2F 00 B9 03 00 00 14 08 00 80 52 E8 2F 00 B9 E8 2F 40 B9 E8 33 00 B9 E8 33 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 08 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 67 00 B9 E9 67 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 33 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 5F 00 F9 E9 5F 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 A3 08 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 6A 00 00 14 E8 4B 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 37 00 B9 03 00 00 14 08 00 80 52 E8 37 00 B9 E8 37 40 B9 E8 3B 00 B9 E8 3B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 08 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 6B 00 B9 E9 6B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 3B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 63 00 F9 E9 63 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 08 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 3A 00 00 14 E8 43 40 F9 E8 47 00 F9 E8 2B 40 F9 08 01 40 B9 09 7D 40 D3 E8 27 40 F9 29 7D 08 9B E8 47 40 F9 08 01 09 8B E8 3F 00 F9 E8 47 40 F9 E8 23 00 F9 05 00 00 14 E9 23 40 F9 E8 27 40 F9 28 01 08 8B E8 23 00 F9 E9 3F 40 F9 E8 23 40 F9 1F 01 09 EB E0 02 00 54 E8 4B 40 F9 E8 4F 00 F9 EF 4F 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 E2 23 40 F9 E1 3B 40 F9 E0 67 40 F9 E8 4F 40 F9 00 01 3F D6 E0 6F 00 B9 E8 6F 40 B9 1F 01 00 71 E1 00 00 54 E8 23 40 F9 E8 6B 00 F9 E0 43 00 91 ?? ?? ?? ?? E0 6B 40 F9 10 00 00 14 E3 FF FF 17 E2 27 40 F9 E1 3B 40 F9 E0 3F 40 F9 ?? ?? ?? ?? E8 2B 40 F9 08 01 40 B9 09 05 00 11 E8 2B 40 F9 09 01 00 B9 E8 3F 40 F9 E8 6F 00 F9 E0 43 00 91 ?? ?? ?? ?? E0 6F 40 F9 FD 7B CE A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "_dexp"
		size = 1208
		refs = "0018 _dtest 00b8 _Inf_C 00ec _fperrraise 00f4 _Nan_C 0198 _dscale 024c hugexp 02d4 invln2 0328 c1 0344 c23 0358 _Eps_C 03a4 c 03cc s"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 0F 00 F9 E0 1B 00 FD E1 4B 00 B9 E0 0F 40 F9 ?? ?? ?? ?? E0 73 00 79 E8 73 C0 79 E8 23 00 79 E0 C3 00 91 ?? ?? ?? ?? E0 77 00 79 E8 77 C0 79 E8 43 00 79 E9 23 C0 79 29 01 00 11 08 00 80 52 1F 01 09 6B CD 00 00 54 E9 43 C0 79 29 01 00 11 08 00 80 52 1F 01 09 6B 6C 0F 00 54 E8 23 C0 79 08 01 00 11 1F 09 00 71 81 00 00 54 40 00 80 52 0C 01 00 14 73 00 00 14 E8 43 C0 79 08 01 00 11 1F 09 00 71 E1 00 00 54 E8 0F 40 F9 F0 1B 40 FD 10 01 00 FD 40 00 80 52 02 01 00 14 69 00 00 14 E8 43 C0 79 08 01 00 11 1F 01 00 71 C1 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? E8 0F 40 F9 10 01 40 FD 00 22 71 1E E0 00 00 54 E8 0F 40 F9 F0 1B 40 FD 10 01 00 FD 00 00 80 52 F2 00 00 14 09 00 00 14 20 00 80 52 ?? ?? ?? ?? E9 0F 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? 30 01 00 FD 40 00 80 52 E9 00 00 14 50 00 00 14 E8 43 C0 79 08 01 00 11 1F 05 00 71 E1 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 11 42 61 1E E8 0F 40 F9 10 01 40 FD 00 22 71 1E E0 00 00 54 E8 0F 40 F9 F0 1B 40 FD 10 01 00 FD 20 00 80 52 D8 00 00 14 09 00 00 14 20 00 80 52 ?? ?? ?? ?? E9 0F 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? 30 01 00 FD 40 00 80 52 CF 00 00 14 36 00 00 14 E8 23 C0 79 08 01 00 11 1F 01 00 71 81 03 00 54 E8 0F 40 F9 F0 1B 40 FD 10 01 00 FD E1 4B 40 B9 E0 0F 40 F9 ?? ?? ?? ?? E0 7B 00 79 E8 7B C0 79 E8 23 00 79 E8 23 C0 79 08 01 00 11 E8 43 00 B9 E8 43 40 B9 1F 01 00 71 A0 00 00 54 E8 43 40 B9 1F 05 00 71 A0 00 00 54 06 00 00 14 00 02 80 52 ?? ?? ?? ?? 03 00 00 14 00 01 80 52 ?? ?? ?? ?? E0 23 C0 79 B0 00 00 14 17 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? E8 0F 40 F9 10 01 40 FD 00 22 71 1E 41 01 00 54 E8 0F 40 F9 11 01 40 FD F0 1B 40 FD 30 0A 70 1E E8 0F 40 F9 10 01 00 FD 20 00 80 52 A1 00 00 14 08 00 00 14 31 14 00 5C F0 1B 40 FD 30 0A 70 1E E8 0F 40 F9 10 01 00 FD 00 00 80 52 99 00 00 14 98 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 11 42 61 1E E8 0F 40 F9 10 01 40 FD 00 22 71 1E 22 01 00 54 51 12 00 5C F0 1B 40 FD 30 0A 70 1E E8 0F 40 F9 10 01 00 FD 00 00 80 52 8A 00 00 14 89 00 00 14 E8 0F 40 F9 11 01 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 00 22 71 1E 82 01 00 54 ?? ?? ?? ?? ?? ?? ?? ?? F0 1B 40 FD 30 0A 70 1E E8 0F 40 F9 10 01 00 FD 00 01 80 52 ?? ?? ?? ?? 20 00 80 52 79 00 00 14 78 00 00 14 E8 0F 40 F9 11 01 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 30 0A 70 1E F0 17 00 FD F0 17 40 FD 08 22 60 1E 82 00 00 54 10 10 7C 1E F0 2F 00 FD 03 00 00 14 10 10 6C 1E F0 2F 00 FD F1 17 40 FD F0 2F 40 FD 30 2A 70 1E 08 02 78 1E E8 47 00 B9 E8 47 40 B9 10 01 62 1E F0 17 00 FD F1 17 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 31 0A 70 1E E8 0F 40 F9 10 01 40 FD 12 3A 71 1E F1 17 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 30 0A 70 1E 50 3A 70 1E F0 17 00 FD ?? ?? ?? ?? ?? ?? ?? ?? 11 42 61 1E F0 17 40 FD 20 22 70 1E 42 01 00 54 ?? ?? ?? ?? ?? ?? ?? ?? F0 17 40 FD 00 22 71 1E A2 00 00 54 E8 0F 40 F9 F0 1B 40 FD 10 01 00 FD 2D 00 00 14 F1 17 40 FD F0 17 40 FD 30 0A 70 1E F0 2B 00 FD ?? ?? ?? ?? ?? ?? ?? ?? F0 2B 40 FD 31 0A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? 31 2A 70 1E F0 2B 40 FD 10 0A 71 1E F0 33 00 FD ?? ?? ?? ?? ?? ?? ?? ?? F0 2B 40 FD 31 0A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? 31 2A 70 1E F0 2B 40 FD 31 0A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? 31 2A 70 1E F0 17 40 FD 10 0A 71 1E F0 37 00 FD F1 33 40 FD F0 37 40 FD 31 2A 70 1E 10 10 6E 1E 12 2A 71 1E F1 33 40 FD F0 37 40 FD 31 3A 70 1E 10 10 6E 1E 10 2A 71 1E 51 1A 70 1E F0 1B 40 FD 30 0A 70 1E E8 0F 40 F9 10 01 00 FD E9 47 40 B9 E8 4B 40 B9 21 01 08 0B 21 00 00 11 E0 0F 40 F9 ?? ?? ?? ?? E0 7F 00 79 E8 7F C0 79 E8 23 00 79 E8 23 C0 79 08 01 00 11 E8 4F 00 B9 E8 4F 40 B9 1F 01 00 71 A0 00 00 54 E8 4F 40 B9 1F 05 00 71 A0 00 00 54 06 00 00 14 00 02 80 52 ?? ?? ?? ?? 03 00 00 14 00 01 80 52 ?? ?? ?? ?? E0 23 C0 79 FD 7B C7 A8 C0 03 5F D6 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_413_0_0 {
	meta:
		name = "_ldexp"
		size = 1208
		refs = "0018 _ldtest 00b8 _LInf_C 00ec _fperrraise 00f4 _LNan_C 0198 _ldscale 024c hugexp 02d4 invln2 0328 c1 0344 c23 0358 _LEps_C 03a4 c 03cc s"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 0F 00 F9 E0 1B 00 FD E1 4B 00 B9 E0 0F 40 F9 ?? ?? ?? ?? E0 73 00 79 E8 73 C0 79 E8 23 00 79 E0 C3 00 91 ?? ?? ?? ?? E0 77 00 79 E8 77 C0 79 E8 43 00 79 E9 23 C0 79 29 01 00 11 08 00 80 52 1F 01 09 6B CD 00 00 54 E9 43 C0 79 29 01 00 11 08 00 80 52 1F 01 09 6B 6C 0F 00 54 E8 23 C0 79 08 01 00 11 1F 09 00 71 81 00 00 54 40 00 80 52 0C 01 00 14 73 00 00 14 E8 43 C0 79 08 01 00 11 1F 09 00 71 E1 00 00 54 E8 0F 40 F9 F0 1B 40 FD 10 01 00 FD 40 00 80 52 02 01 00 14 69 00 00 14 E8 43 C0 79 08 01 00 11 1F 01 00 71 C1 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? E8 0F 40 F9 10 01 40 FD 00 22 71 1E E0 00 00 54 E8 0F 40 F9 F0 1B 40 FD 10 01 00 FD 00 00 80 52 F2 00 00 14 09 00 00 14 20 00 80 52 ?? ?? ?? ?? E9 0F 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? 30 01 00 FD 40 00 80 52 E9 00 00 14 50 00 00 14 E8 43 C0 79 08 01 00 11 1F 05 00 71 E1 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 11 42 61 1E E8 0F 40 F9 10 01 40 FD 00 22 71 1E E0 00 00 54 E8 0F 40 F9 F0 1B 40 FD 10 01 00 FD 20 00 80 52 D8 00 00 14 09 00 00 14 20 00 80 52 ?? ?? ?? ?? E9 0F 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? 30 01 00 FD 40 00 80 52 CF 00 00 14 36 00 00 14 E8 23 C0 79 08 01 00 11 1F 01 00 71 81 03 00 54 E8 0F 40 F9 F0 1B 40 FD 10 01 00 FD E1 4B 40 B9 E0 0F 40 F9 ?? ?? ?? ?? E0 7B 00 79 E8 7B C0 79 E8 23 00 79 E8 23 C0 79 08 01 00 11 E8 43 00 B9 E8 43 40 B9 1F 01 00 71 A0 00 00 54 E8 43 40 B9 1F 05 00 71 A0 00 00 54 06 00 00 14 00 02 80 52 ?? ?? ?? ?? 03 00 00 14 00 01 80 52 ?? ?? ?? ?? E0 23 C0 79 B0 00 00 14 17 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? E8 0F 40 F9 10 01 40 FD 00 22 71 1E 41 01 00 54 E8 0F 40 F9 11 01 40 FD F0 1B 40 FD 30 0A 70 1E E8 0F 40 F9 10 01 00 FD 20 00 80 52 A1 00 00 14 08 00 00 14 31 14 00 5C F0 1B 40 FD 30 0A 70 1E E8 0F 40 F9 10 01 00 FD 00 00 80 52 99 00 00 14 98 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 11 42 61 1E E8 0F 40 F9 10 01 40 FD 00 22 71 1E 22 01 00 54 51 12 00 5C F0 1B 40 FD 30 0A 70 1E E8 0F 40 F9 10 01 00 FD 00 00 80 52 8A 00 00 14 89 00 00 14 E8 0F 40 F9 11 01 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 00 22 71 1E 82 01 00 54 ?? ?? ?? ?? ?? ?? ?? ?? F0 1B 40 FD 30 0A 70 1E E8 0F 40 F9 10 01 00 FD 00 01 80 52 ?? ?? ?? ?? 20 00 80 52 79 00 00 14 78 00 00 14 E8 0F 40 F9 11 01 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 30 0A 70 1E F0 17 00 FD F0 17 40 FD 08 22 60 1E 82 00 00 54 10 10 7C 1E F0 2F 00 FD 03 00 00 14 10 10 6C 1E F0 2F 00 FD F1 17 40 FD F0 2F 40 FD 30 2A 70 1E 08 02 78 1E E8 47 00 B9 E8 47 40 B9 10 01 62 1E F0 17 00 FD F1 17 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 31 0A 70 1E E8 0F 40 F9 10 01 40 FD 12 3A 71 1E F1 17 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 30 0A 70 1E 50 3A 70 1E F0 17 00 FD ?? ?? ?? ?? ?? ?? ?? ?? 11 42 61 1E F0 17 40 FD 20 22 70 1E 42 01 00 54 ?? ?? ?? ?? ?? ?? ?? ?? F0 17 40 FD 00 22 71 1E A2 00 00 54 E8 0F 40 F9 F0 1B 40 FD 10 01 00 FD 2D 00 00 14 F1 17 40 FD F0 17 40 FD 30 0A 70 1E F0 2B 00 FD ?? ?? ?? ?? ?? ?? ?? ?? F0 2B 40 FD 31 0A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? 31 2A 70 1E F0 2B 40 FD 10 0A 71 1E F0 33 00 FD ?? ?? ?? ?? ?? ?? ?? ?? F0 2B 40 FD 31 0A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? 31 2A 70 1E F0 2B 40 FD 31 0A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? 31 2A 70 1E F0 17 40 FD 10 0A 71 1E F0 37 00 FD F1 33 40 FD F0 37 40 FD 31 2A 70 1E 10 10 6E 1E 12 2A 71 1E F1 33 40 FD F0 37 40 FD 31 3A 70 1E 10 10 6E 1E 10 2A 71 1E 51 1A 70 1E F0 1B 40 FD 30 0A 70 1E E8 0F 40 F9 10 01 00 FD E9 47 40 B9 E8 4B 40 B9 21 01 08 0B 21 00 00 11 E0 0F 40 F9 ?? ?? ?? ?? E0 7F 00 79 E8 7F C0 79 E8 23 00 79 E8 23 C0 79 08 01 00 11 E8 4F 00 B9 E8 4F 40 B9 1F 01 00 71 A0 00 00 54 E8 4F 40 B9 1F 05 00 71 A0 00 00 54 06 00 00 14 00 02 80 52 ?? ?? ?? ?? 03 00 00 14 00 01 80 52 ?? ?? ?? ?? E0 23 C0 79 FD 7B C7 A8 C0 03 5F D6 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_31_1_0 {
	meta:
		name = "exp2"
		size = 392
		refs = "0010 _dtest 00c0 _d_int 0140 ln2 015c _dexp"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 13 00 FD E0 83 00 91 ?? ?? ?? ?? E0 23 00 79 E8 23 C0 79 08 01 00 11 E8 1B 00 B9 E8 1B 40 B9 1F 01 00 71 80 02 00 54 E8 1B 40 B9 1F 05 00 71 E0 00 00 54 E8 1B 40 B9 1F 09 00 71 40 00 00 54 0F 00 00 14 E0 13 40 FD 45 00 00 14 E8 4F 40 79 08 01 00 11 88 00 78 36 90 08 00 5C F0 1B 00 FD 03 00 00 14 F0 13 40 FD F0 1B 00 FD E0 1B 40 FD 3B 00 00 14 00 10 6E 1E 39 00 00 14 B1 07 00 5C F0 13 40 FD 00 22 71 1E A9 00 00 54 F1 13 40 FD 50 07 00 5C 00 22 71 1E 88 00 00 54 08 00 80 52 E8 17 00 B9 24 00 00 14 F0 13 40 FD F0 17 00 FD 01 00 80 52 E0 A3 00 91 ?? ?? ?? ?? F0 17 40 FD 08 02 78 1E E8 17 00 B9 F1 13 40 FD F0 17 40 FD 30 3A 70 1E F0 13 00 FD F1 13 40 FD 10 10 6C 1E 00 22 71 1E 22 01 00 54 F1 13 40 FD 10 10 6E 1E 30 3A 70 1E F0 13 00 FD E8 17 40 B9 08 05 00 11 E8 17 00 B9 0C 00 00 14 11 10 7C 1E F0 13 40 FD 00 22 71 1E 02 01 00 54 F1 13 40 FD 10 10 6E 1E 30 2A 70 1E F0 13 00 FD E8 17 40 B9 08 05 00 51 E8 17 00 B9 F1 13 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 30 0A 70 1E F0 13 00 FD E1 17 40 B9 00 10 6E 1E E0 83 00 91 ?? ?? ?? ?? E0 13 40 FD FD 7B C4 A8 C0 03 5F D6 1F 20 03 D5 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 C1 00 00 C0 FF FF FF DF 41 }
	condition:
		$1
}

rule file_413_1_0 {
	meta:
		name = "exp2l"
		size = 392
		refs = "0010 _ldtest 00c0 _ld_int 0140 ln2 015c _ldexp"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 13 00 FD E0 83 00 91 ?? ?? ?? ?? E0 23 00 79 E8 23 C0 79 08 01 00 11 E8 1B 00 B9 E8 1B 40 B9 1F 01 00 71 80 02 00 54 E8 1B 40 B9 1F 05 00 71 E0 00 00 54 E8 1B 40 B9 1F 09 00 71 40 00 00 54 0F 00 00 14 E0 13 40 FD 45 00 00 14 E8 4F 40 79 08 01 00 11 88 00 78 36 90 08 00 5C F0 1B 00 FD 03 00 00 14 F0 13 40 FD F0 1B 00 FD E0 1B 40 FD 3B 00 00 14 00 10 6E 1E 39 00 00 14 B1 07 00 5C F0 13 40 FD 00 22 71 1E A9 00 00 54 F1 13 40 FD 50 07 00 5C 00 22 71 1E 88 00 00 54 08 00 80 52 E8 17 00 B9 24 00 00 14 F0 13 40 FD F0 17 00 FD 01 00 80 52 E0 A3 00 91 ?? ?? ?? ?? F0 17 40 FD 08 02 78 1E E8 17 00 B9 F1 13 40 FD F0 17 40 FD 30 3A 70 1E F0 13 00 FD F1 13 40 FD 10 10 6C 1E 00 22 71 1E 22 01 00 54 F1 13 40 FD 10 10 6E 1E 30 3A 70 1E F0 13 00 FD E8 17 40 B9 08 05 00 11 E8 17 00 B9 0C 00 00 14 11 10 7C 1E F0 13 40 FD 00 22 71 1E 02 01 00 54 F1 13 40 FD 10 10 6E 1E 30 2A 70 1E F0 13 00 FD E8 17 40 B9 08 05 00 51 E8 17 00 B9 F1 13 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 30 0A 70 1E F0 13 00 FD E1 17 40 B9 00 10 6E 1E E0 83 00 91 ?? ?? ?? ?? E0 13 40 FD FD 7B C4 A8 C0 03 5F D6 1F 20 03 D5 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 C1 00 00 C0 FF FF FF DF 41 }
	condition:
		$1
}

rule file_32_5_0 {
	meta:
		name = "_mbslen_l"
		size = 156
		refs = "0014 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 13 00 00 91 E0 43 00 91 ?? ?? ?? ?? EA 13 40 F9 48 09 40 B9 28 01 00 35 68 02 C0 39 6A 02 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 40 01 13 CB 0E 00 00 14 6B 02 40 39 0C 00 80 52 4B 01 00 34 68 01 0A 8B 09 65 40 39 89 00 10 36 73 06 00 91 69 02 40 39 89 00 00 34 6B 1E 40 38 8C 05 00 11 0B FF FF 35 80 7D 40 93 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "norml"
		size = 104
		refs = "0018 creall 0030 cimagl"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 FD E1 1F 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 13 00 FD F0 13 40 FD F0 0B 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 17 00 FD F0 17 40 FD F0 0F 00 FD F1 0B 40 FD F0 0B 40 FD 32 0A 70 1E F1 0F 40 FD F0 0F 40 FD 30 0A 70 1E 40 2A 70 1E 00 40 60 1E FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "norm"
		size = 104
		refs = "0018 creal 0030 cimag"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 FD E1 1F 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 13 00 FD F0 13 40 FD F0 0B 00 FD E1 1F 40 FD E0 1B 40 FD ?? ?? ?? ?? E0 17 00 FD F0 17 40 FD F0 0F 00 FD F1 0B 40 FD F0 0B 40 FD 32 0A 70 1E F1 0F 40 FD F0 0F 40 FD 30 0A 70 1E 40 2A 70 1E 00 40 60 1E FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_34_5_0 {
	meta:
		name = "_mbstok_s_l"
		size = 800
		refs = "0024 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0028 ??_C@_1CG@NGEOKDE@?$AA?$CI?$AA_?$AAC?$AAo?$AAn?$AAt?$AAe?$AAx?$AAt?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002c ??_C@_1HC@OKFLAEGA@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0048 _CrtDbgReportW 0058 _errno 006c ??_C@_1BI@POJFKBIJ@?$AA_?$AAm?$AAb?$AAs?$AAt?$AAo?$AAk?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 007c _invalid_parameter 0090 ??_C@_1CG@CBDCOOGB@?$AA?$CI?$AA_?$AAC?$AAo?$AAn?$AAt?$AAr?$AAo?$AAl?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00e8 ??_C@_1FK@NHNJCDJJ@?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CK?$AA_?$AAC?$AAo?$AAn?$AAt?$AAe?$AAx?$AAt@ 0138 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0154 strtok_s"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BD A9 FD 03 00 91 13 00 00 91 35 00 00 91 56 00 00 91 56 03 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 02 03 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 03 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 A2 00 00 14 95 02 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 22 03 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 23 03 80 52 ?? ?? ?? ?? E6 FF FF 17 D3 02 00 B5 C8 02 40 F9 88 02 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 03 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 43 03 80 52 ?? ?? ?? ?? D0 FF FF 17 61 00 00 91 E0 43 00 91 ?? ?? ?? ?? EF 13 40 F9 E8 09 40 B9 C8 00 00 35 C2 02 00 91 A1 02 00 91 60 02 00 91 ?? ?? ?? ?? 67 00 00 14 53 00 00 B5 D3 02 40 F9 6B 02 40 39 8B 05 00 34 57 05 80 52 A8 02 40 39 B4 02 00 91 08 03 00 34 8D 02 40 39 A9 01 0F 8B 2A 65 40 39 4A 01 10 36 8C 06 40 39 CC 01 00 34 BF 01 0B 6B 81 00 00 54 68 06 40 39 9F 01 08 6B A0 01 00 54 94 06 00 91 03 00 00 14 BF 01 0B 6B 20 01 00 54 94 06 00 91 89 02 40 39 C9 00 00 34 EE FF FF 17 94 06 00 91 ?? ?? ?? ?? 17 00 00 B9 EF 13 40 F9 88 02 40 39 E8 01 00 34 69 02 40 39 29 01 0F 8B 2A 65 40 39 8A 00 10 36 73 06 00 91 6A 02 40 39 AA 00 00 34 73 06 00 91 6B 02 40 39 AB 00 00 34 DA FF FF 17 ?? ?? ?? ?? 17 00 00 B9 EF 13 40 F9 68 02 40 39 60 02 00 91 28 06 00 34 A7 02 40 39 AC 02 00 91 0D 00 80 52 27 03 00 34 8E 01 40 39 C9 01 0F 8B 2A 65 40 39 6A 01 10 36 8B 05 40 39 4B 02 00 34 68 02 40 39 DF 01 08 6B 81 00 00 54 6A 06 40 39 7F 01 0A 6B 40 01 00 54 8C 05 00 91 04 00 00 14 69 02 40 39 DF 01 09 6B 00 01 00 54 8C 05 00 91 8B 01 40 39 AB 00 00 34 EC FF FF 17 2D 00 80 52 02 00 00 14 8C 05 00 91 88 01 40 39 C8 01 00 35 69 02 40 39 29 01 0F 8B 2A 65 40 39 8A 00 10 36 6A 06 40 39 CA 00 00 34 73 06 00 91 73 06 00 91 6B 02 40 39 2B 01 00 34 D9 FF FF 17 7F 02 00 39 06 00 00 14 7F 02 00 39 73 06 00 91 6D 00 00 34 7F 02 00 39 73 06 00 91 D3 02 00 F9 1F 00 13 EB 41 00 00 54 00 00 80 D2 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "??$?0AEBV?$console_output_adapter@D@__crt_stdio_output@@AEB_KAEBQEBDAEBQEAU__crt_locale_pointers@@AEBQEAD@?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA@AEBV?$console_output_adapter@D@1@AEB_KAEBQEBDAEBQEAU__crt_locale_pointers@@AEBQEAD@Z"
		size = 72
		altNames = "??$?0AEBV?$console_output_adapter@D@__crt_stdio_output@@AEB_KAEBQEBDAEBQEAU__crt_locale_pointers@@AEBQEAD@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA@AEBV?$console_output_adapter@D@1@AEB_KAEBQEBDAEBQEAU__crt_locale_pointers@@AEBQEAD@Z"
	strings:
		$1 = { AB 00 40 F9 8A 00 40 F9 69 00 40 F9 48 00 40 F9 1F 08 00 F9 1F 7C 05 29 1F 7C 06 29 1F 38 00 B9 1F 00 01 39 1F 04 01 39 1F 50 00 B9 1F 50 01 39 1F 2C 02 F9 1F 30 02 F9 08 28 00 A9 09 AC 01 A9 1F 70 04 B9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_1_0 {
	meta:
		name = "??$?0AEBV?$console_output_adapter@D@__crt_stdio_output@@AEB_KAEBQEBDAEBQEAU__crt_locale_pointers@@AEBQEAD@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA@AEBV?$console_output_adapter@D@1@AEB_KAEBQEBDAEBQEAU__crt_locale_pointers@@AEBQEAD@Z"
		size = 96
	strings:
		$1 = { 48 00 40 F9 AA 00 40 F9 89 00 40 F9 6B 00 40 F9 1F 08 00 F9 1F 7C 05 29 1F 7C 06 29 1F 38 00 B9 1F 00 01 39 1F 04 01 39 1F 50 00 B9 1F 50 01 39 1F 2C 02 F9 1F 30 02 F9 08 24 00 A9 08 00 80 12 08 E8 0D B9 08 EC 0D B9 0B A8 01 A9 1F 70 04 B9 1F 78 04 B9 1F 7C 04 B9 0B 40 02 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_3_0 {
	meta:
		name = "??$?0AEBV?$console_output_adapter@_W@__crt_stdio_output@@AEB_KAEBQEB_WAEBQEAU__crt_locale_pointers@@AEBQEAD@?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA@AEBV?$console_output_adapter@_W@1@AEB_KAEBQEB_WAEBQEAU__crt_locale_pointers@@AEBQEAD@Z"
		size = 72
		altNames = "??$?0AEBV?$console_output_adapter@_W@__crt_stdio_output@@AEB_KAEBQEB_WAEBQEAU__crt_locale_pointers@@AEBQEAD@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA@AEBV?$console_output_adapter@_W@1@AEB_KAEBQEB_WAEBQEAU__crt_locale_pointers@@AEBQEAD@Z"
	strings:
		$1 = { AB 00 40 F9 8A 00 40 F9 69 00 40 F9 48 00 40 F9 1F 08 00 F9 1F 7C 05 29 1F 7C 06 29 1F 38 00 B9 1F 00 01 39 1F 84 00 79 1F 50 00 B9 1F 50 01 39 1F 2C 02 F9 1F 30 02 F9 08 28 00 A9 09 AC 01 A9 1F 70 04 B9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_4_0 {
	meta:
		name = "??$?0AEBV?$console_output_adapter@_W@__crt_stdio_output@@AEB_KAEBQEB_WAEBQEAU__crt_locale_pointers@@AEBQEAD@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA@AEBV?$console_output_adapter@_W@1@AEB_KAEBQEB_WAEBQEAU__crt_locale_pointers@@AEBQEAD@Z"
		size = 96
	strings:
		$1 = { 48 00 40 F9 AA 00 40 F9 89 00 40 F9 6B 00 40 F9 1F 08 00 F9 1F 7C 05 29 1F 7C 06 29 1F 38 00 B9 1F 00 01 39 1F 84 00 79 1F 50 00 B9 1F 50 01 39 1F 2C 02 F9 1F 30 02 F9 08 24 00 A9 08 00 80 12 08 E8 0D B9 08 EC 0D B9 0B A8 01 A9 1F 70 04 B9 1F 78 04 B9 1F 7C 04 B9 0B 40 02 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_7_0 {
	meta:
		name = "??$common_vcprintf@Vformat_validation_base@__crt_stdio_output@@D@@YAH_KQEBDQEAU__crt_locale_pointers@@QEAD@Z"
		size = 184
		refs = "0010 __security_push_cookie 002c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 006c ?process@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAAHXZ 007c _free_dbg 00a4 __security_pop_cookie"
		altNames = "__conio_common_vcprintf_s"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 13 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 12 D1 14 00 00 91 35 00 00 91 41 00 00 91 E0 03 00 91 73 00 00 91 ?? ?? ?? ?? FF 57 03 A9 E8 23 00 91 FF 7F 09 29 E0 83 00 91 F4 23 02 A9 FF 7F 0A 29 FF 5B 00 B9 FF 83 01 39 FF 87 01 39 FF 73 00 B9 FF D3 01 39 FF 3F 02 F9 FF 43 02 F9 F3 23 00 F9 FF 93 04 B9 ?? ?? ?? ?? 41 00 80 52 13 00 00 11 E0 43 42 F9 ?? ?? ?? ?? E8 63 40 39 FF 43 02 F9 A8 00 00 34 EA 03 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FF 43 12 91 ?? ?? ?? ?? F5 13 40 F9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_11_0 {
	meta:
		name = "??$common_vcprintf@Vstandard_base@__crt_stdio_output@@D@@YAH_KQEBDQEAU__crt_locale_pointers@@QEAD@Z"
		size = 184
		refs = "0010 __security_push_cookie 002c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 006c ?process@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAAHXZ 007c _free_dbg 00a4 __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 13 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 12 D1 14 00 00 91 35 00 00 91 41 00 00 91 E0 03 00 91 73 00 00 91 ?? ?? ?? ?? FF 57 03 A9 E8 23 00 91 FF 7F 09 29 E0 83 00 91 F4 23 02 A9 FF 7F 0A 29 FF 5B 00 B9 FF 83 01 39 FF 87 01 39 FF 73 00 B9 FF D3 01 39 FF 3F 02 F9 FF 43 02 F9 F3 23 00 F9 FF 93 04 B9 ?? ?? ?? ?? 41 00 80 52 13 00 00 11 E0 43 42 F9 ?? ?? ?? ?? E8 63 40 39 FF 43 02 F9 A8 00 00 34 EA 03 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FF 43 12 91 ?? ?? ?? ?? F5 13 40 F9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_473_0 {
	meta:
		name = "__conio_common_vcprintf"
		size = 184
		refs = "0010 __security_push_cookie 002c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 006c ?process@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAAHXZ 007c _free_dbg 00a4 __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 13 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 12 D1 14 00 00 91 35 00 00 91 41 00 00 91 E0 03 00 91 73 00 00 91 ?? ?? ?? ?? FF 57 03 A9 E8 23 00 91 FF 7F 09 29 E0 83 00 91 F4 23 02 A9 FF 7F 0A 29 FF 5B 00 B9 FF 83 01 39 FF 87 01 39 FF 73 00 B9 FF D3 01 39 FF 3F 02 F9 FF 43 02 F9 F3 23 00 F9 FF 93 04 B9 ?? ?? ?? ?? 41 00 80 52 13 00 00 11 E0 43 42 F9 ?? ?? ?? ?? E8 63 40 39 FF 43 02 F9 A8 00 00 34 EA 03 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FF 43 12 91 ?? ?? ?? ?? F5 13 40 F9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_8_0 {
	meta:
		name = "??$common_vcprintf@Vformat_validation_base@__crt_stdio_output@@_W@@YAH_KQEB_WQEAU__crt_locale_pointers@@QEAD@Z"
		size = 184
		refs = "0010 __security_push_cookie 002c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 006c ?process@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAAHXZ 007c _free_dbg 00a4 __security_pop_cookie"
		altNames = "__conio_common_vcwprintf_s"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 13 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 12 D1 14 00 00 91 35 00 00 91 41 00 00 91 E0 03 00 91 73 00 00 91 ?? ?? ?? ?? FF 57 03 A9 E8 23 00 91 FF 7F 09 29 E0 83 00 91 F4 23 02 A9 FF 7F 0A 29 FF 5B 00 B9 FF 83 01 39 FF C7 00 79 FF 73 00 B9 FF D3 01 39 FF 3F 02 F9 FF 43 02 F9 F3 23 00 F9 FF 93 04 B9 ?? ?? ?? ?? 41 00 80 52 13 00 00 11 E0 43 42 F9 ?? ?? ?? ?? E8 63 40 39 FF 43 02 F9 A8 00 00 34 EA 03 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FF 43 12 91 ?? ?? ?? ?? F5 13 40 F9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_12_0 {
	meta:
		name = "??$common_vcprintf@Vstandard_base@__crt_stdio_output@@_W@@YAH_KQEB_WQEAU__crt_locale_pointers@@QEAD@Z"
		size = 184
		refs = "0010 __security_push_cookie 002c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 006c ?process@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAAHXZ 007c _free_dbg 00a4 __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 13 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 12 D1 14 00 00 91 35 00 00 91 41 00 00 91 E0 03 00 91 73 00 00 91 ?? ?? ?? ?? FF 57 03 A9 E8 23 00 91 FF 7F 09 29 E0 83 00 91 F4 23 02 A9 FF 7F 0A 29 FF 5B 00 B9 FF 83 01 39 FF C7 00 79 FF 73 00 B9 FF D3 01 39 FF 3F 02 F9 FF 43 02 F9 F3 23 00 F9 FF 93 04 B9 ?? ?? ?? ?? 41 00 80 52 13 00 00 11 E0 43 42 F9 ?? ?? ?? ?? E8 63 40 39 FF 43 02 F9 A8 00 00 34 EA 03 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FF 43 12 91 ?? ?? ?? ?? F5 13 40 F9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_476_0 {
	meta:
		name = "__conio_common_vcwprintf"
		size = 184
		refs = "0010 __security_push_cookie 002c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 006c ?process@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAAHXZ 007c _free_dbg 00a4 __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 13 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 12 D1 14 00 00 91 35 00 00 91 41 00 00 91 E0 03 00 91 73 00 00 91 ?? ?? ?? ?? FF 57 03 A9 E8 23 00 91 FF 7F 09 29 E0 83 00 91 F4 23 02 A9 FF 7F 0A 29 FF 5B 00 B9 FF 83 01 39 FF C7 00 79 FF 73 00 B9 FF D3 01 39 FF 3F 02 F9 FF 43 02 F9 F3 23 00 F9 FF 93 04 B9 ?? ?? ?? ?? 41 00 80 52 13 00 00 11 E0 43 42 F9 ?? ?? ?? ?? E8 63 40 39 FF 43 02 F9 A8 00 00 34 EA 03 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FF 43 12 91 ?? ?? ?? ?? F5 13 40 F9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_9_0 {
	meta:
		name = "??$common_vcprintf@Vpositional_parameter_base@__crt_stdio_output@@D@@YAH_KQEBDQEAU__crt_locale_pointers@@QEAD@Z"
		size = 208
		refs = "0010 __security_push_cookie 002c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0084 ?process@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAAHXZ 0094 _free_dbg 00bc __security_pop_cookie"
		altNames = "__conio_common_vcprintf_p"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 13 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 38 D1 14 00 00 91 35 00 00 91 41 00 00 91 E0 03 00 91 73 00 00 91 ?? ?? ?? ?? FF 57 03 A9 E8 23 00 91 FF 7F 09 29 F4 23 02 A9 08 00 80 12 E0 83 00 91 E8 0B 0E B9 E8 0F 0E B9 FF 7F 0A 29 FF 5B 00 B9 FF 83 01 39 FF 87 01 39 FF 73 00 B9 FF D3 01 39 FF 3F 02 F9 FF 43 02 F9 F3 23 00 F9 FF 93 04 B9 FF 9B 04 B9 FF 9F 04 B9 F5 53 02 F9 ?? ?? ?? ?? 41 00 80 52 13 00 00 11 E0 43 42 F9 ?? ?? ?? ?? E8 63 40 39 FF 43 02 F9 A8 00 00 34 EA 03 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FF 43 38 91 ?? ?? ?? ?? F5 13 40 F9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_10_0 {
	meta:
		name = "??$common_vcprintf@Vpositional_parameter_base@__crt_stdio_output@@_W@@YAH_KQEB_WQEAU__crt_locale_pointers@@QEAD@Z"
		size = 208
		refs = "0010 __security_push_cookie 002c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0084 ?process@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAAHXZ 0094 _free_dbg 00bc __security_pop_cookie"
		altNames = "__conio_common_vcwprintf_p"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 13 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 38 D1 14 00 00 91 35 00 00 91 41 00 00 91 E0 03 00 91 73 00 00 91 ?? ?? ?? ?? FF 57 03 A9 E8 23 00 91 FF 7F 09 29 F4 23 02 A9 08 00 80 12 E0 83 00 91 E8 0B 0E B9 E8 0F 0E B9 FF 7F 0A 29 FF 5B 00 B9 FF 83 01 39 FF C7 00 79 FF 73 00 B9 FF D3 01 39 FF 3F 02 F9 FF 43 02 F9 F3 23 00 F9 FF 93 04 B9 FF 9B 04 B9 FF 9F 04 B9 F5 53 02 F9 ?? ?? ?? ?? 41 00 80 52 13 00 00 11 E0 43 42 F9 ?? ?? ?? ?? E8 63 40 39 FF 43 02 F9 A8 00 00 34 EA 03 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FF 43 38 91 ?? ?? ?? ?? F5 13 40 F9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_13_0 {
	meta:
		name = "??$count@D@formatting_buffer@__crt_stdio_output@@QEBA_KXZ"
		size = 28
		altNames = "??$scratch_count@D@formatting_buffer@__crt_stdio_output@@QEBA_KXZ"
	strings:
		$1 = { 08 04 42 F9 68 00 00 B5 00 40 80 D2 03 00 00 14 08 00 42 F9 00 FD 41 D3 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_14_0 {
	meta:
		name = "??$count@_W@formatting_buffer@__crt_stdio_output@@QEBA_KXZ"
		size = 28
	strings:
		$1 = { 08 04 42 F9 68 00 00 B5 00 20 80 D2 03 00 00 14 08 00 42 F9 00 FD 42 D3 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_15_0 {
	meta:
		name = "??$data@D@formatting_buffer@__crt_stdio_output@@QEAAPEADXZ"
		size = 16
		altNames = "??$data@_W@formatting_buffer@__crt_stdio_output@@QEAAPEA_WXZ"
	strings:
		$1 = { 08 04 42 F9 1F 01 00 F1 00 00 88 9A C0 03 5F D6 }
	condition:
		$1
}

rule file_35_17_0 {
	meta:
		name = "??$ensure_buffer_is_big_enough@D@formatting_buffer@__crt_stdio_output@@QEAA_N_K@Z"
		size = 204
		refs = "0030 _errno 006c ??_C@_0DI@KIFBHMNO@minkernel?2crts?2ucrt?2inc?2corecrt_@ 0080 _malloc_dbg 009c _free_dbg"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 13 00 00 91 08 00 80 92 41 00 00 B5 80 00 3E D4 08 09 C1 9A 09 F9 7F 92 3F 09 00 F1 C2 00 00 54 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 00 00 80 52 1F 00 00 14 68 06 42 F9 34 F8 7F D3 A8 00 00 B5 9F 02 10 F1 68 00 00 54 20 00 80 52 18 00 00 14 68 02 42 F9 9F 02 08 EB 89 FF FF 54 ?? ?? ?? ?? ?? ?? ?? ?? 83 2C 80 52 41 00 80 52 80 02 00 91 ?? ?? ?? ?? 15 00 00 91 75 00 00 B5 13 00 80 52 07 00 00 14 60 06 42 F9 41 00 80 52 ?? ?? ?? ?? 75 06 02 F9 74 02 02 F9 33 00 80 52 41 00 80 52 00 00 80 D2 ?? ?? ?? ?? 60 02 00 11 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_18_0 {
	meta:
		name = "??$extract_argument_from_va_list@C_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 248
		refs = "0040 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0044 ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0048 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0064 _CrtDbgReportW 0074 _errno 0080 ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 0098 _invalid_parameter 00cc ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 01 01 00 54 08 10 40 F9 09 21 00 91 09 10 00 F9 29 81 DF 38 28 7D 40 93 28 00 00 F9 2E 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 13 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 22 00 80 52 03 04 C1 39 21 21 12 91 ?? ?? ?? ?? 07 00 00 14 08 01 0A 9B 09 49 42 F9 2A 01 C0 39 4B 7D 40 93 2B 00 00 F9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_19_0 {
	meta:
		name = "??$extract_argument_from_va_list@C_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 248
		refs = "0040 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0044 ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0048 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0064 _CrtDbgReportW 0074 _errno 0080 ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 0098 _invalid_parameter 00cc ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 01 01 00 54 08 10 40 F9 09 21 00 91 09 10 00 F9 29 81 DF 38 28 7D 40 93 28 00 00 F9 2E 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 13 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 22 00 80 52 03 84 40 79 21 21 12 91 ?? ?? ?? ?? 07 00 00 14 08 01 0A 9B 09 49 42 F9 2A 01 C0 39 4B 7D 40 93 2B 00 00 F9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_20_0 {
	meta:
		name = "??$extract_argument_from_va_list@C_J@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 32
		altNames = "??$extract_argument_from_va_list@C_J@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
	strings:
		$1 = { 08 10 40 F9 09 21 00 91 09 10 00 F9 29 81 DF 38 20 00 80 52 28 7D 40 93 28 00 00 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_22_0 {
	meta:
		name = "??$extract_argument_from_va_list@E_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 236
		refs = "0038 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 003c ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0040 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 005c _CrtDbgReportW 006c _errno 0078 ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 0090 _invalid_parameter 00c4 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 C1 00 00 54 08 10 40 F9 09 21 00 91 09 10 00 F9 2A 81 5F 38 2C 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 12 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 22 00 80 52 03 04 C1 39 21 21 12 91 ?? ?? ?? ?? 06 00 00 14 08 01 0A 9B 09 49 42 F9 2A 01 40 39 20 00 80 52 2A 00 00 F9 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_23_0 {
	meta:
		name = "??$extract_argument_from_va_list@E_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 236
		refs = "0038 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 003c ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0040 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 005c _CrtDbgReportW 006c _errno 0078 ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 0090 _invalid_parameter 00c4 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 C1 00 00 54 08 10 40 F9 09 21 00 91 09 10 00 F9 2A 81 5F 38 2C 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 12 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 22 00 80 52 03 84 40 79 21 21 12 91 ?? ?? ?? ?? 06 00 00 14 08 01 0A 9B 09 49 42 F9 2A 01 40 39 20 00 80 52 2A 00 00 F9 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_24_0 {
	meta:
		name = "??$extract_argument_from_va_list@E_J@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 28
		altNames = "??$extract_argument_from_va_list@E_J@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
	strings:
		$1 = { 08 10 40 F9 09 21 00 91 09 10 00 F9 2A 81 5F 38 20 00 80 52 2A 00 00 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_26_0 {
	meta:
		name = "??$extract_argument_from_va_list@F_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 268
		refs = "004c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0050 ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0054 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0070 _CrtDbgReportW 0080 _errno 008c ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00a4 _invalid_parameter 00d8 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 61 01 00 54 0A 10 40 F9 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 DF 78 09 7D 40 93 29 00 00 F9 30 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 15 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 22 00 80 52 03 04 C1 39 21 21 12 91 ?? ?? ?? ?? 09 00 00 14 08 01 0A 9B 0A 49 42 F9 E9 03 0A CB 28 01 40 92 0A 69 EA 78 4B 7D 40 93 2B 00 00 F9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_27_0 {
	meta:
		name = "??$extract_argument_from_va_list@F_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 268
		refs = "004c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0050 ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0054 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0070 _CrtDbgReportW 0080 _errno 008c ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00a4 _invalid_parameter 00d8 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 61 01 00 54 0A 10 40 F9 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 DF 78 09 7D 40 93 29 00 00 F9 30 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 15 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 22 00 80 52 03 84 40 79 21 21 12 91 ?? ?? ?? ?? 09 00 00 14 08 01 0A 9B 0A 49 42 F9 E9 03 0A CB 28 01 40 92 0A 69 EA 78 4B 7D 40 93 2B 00 00 F9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_28_0 {
	meta:
		name = "??$extract_argument_from_va_list@F_J@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 44
		altNames = "??$extract_argument_from_va_list@F_J@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
	strings:
		$1 = { 0A 10 40 F9 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 DF 78 20 00 80 52 09 7D 40 93 29 00 00 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_30_0 {
	meta:
		name = "??$extract_argument_from_va_list@GD@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAD@Z"
		size = 260
		refs = "0048 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0088 ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00a0 _invalid_parameter 00d4 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 41 01 00 54 0A 10 40 F9 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 DF 38 28 00 00 39 2F 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 14 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 22 00 80 52 03 04 C1 39 21 21 12 91 ?? ?? ?? ?? 08 00 00 14 08 01 0A 9B 0A 49 42 F9 E9 03 0A CB 28 01 40 92 0A 69 EA 38 2A 00 00 39 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_31_0 {
	meta:
		name = "??$extract_argument_from_va_list@GD@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAD@Z"
		size = 40
	strings:
		$1 = { 0A 10 40 F9 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 DF 38 20 00 80 52 28 00 00 39 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_32_0 {
	meta:
		name = "??$extract_argument_from_va_list@G_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 260
		refs = "0048 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0088 ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00a0 _invalid_parameter 00d4 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 41 01 00 54 0A 10 40 F9 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F 78 28 00 00 F9 2F 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 14 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 22 00 80 52 03 04 C1 39 21 21 12 91 ?? ?? ?? ?? 08 00 00 14 08 01 0A 9B 0A 49 42 F9 E9 03 0A CB 28 01 40 92 0A 69 6A 78 2A 00 00 F9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_33_0 {
	meta:
		name = "??$extract_argument_from_va_list@G_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 260
		refs = "0048 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0088 ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00a0 _invalid_parameter 00d4 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 41 01 00 54 0A 10 40 F9 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F 78 28 00 00 F9 2F 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 14 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 22 00 80 52 03 84 40 79 21 21 12 91 ?? ?? ?? ?? 08 00 00 14 08 01 0A 9B 0A 49 42 F9 E9 03 0A CB 28 01 40 92 0A 69 6A 78 2A 00 00 F9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_34_0 {
	meta:
		name = "??$extract_argument_from_va_list@G_J@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 40
		altNames = "??$extract_argument_from_va_list@G_J@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
	strings:
		$1 = { 0A 10 40 F9 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F 78 20 00 80 52 28 00 00 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_36_0 {
	meta:
		name = "??$extract_argument_from_va_list@H_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 260
		refs = "0048 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0088 ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00a0 _invalid_parameter 00d4 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 41 01 00 54 0A 10 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 9F B8 28 00 00 F9 2F 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 14 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 22 00 80 52 03 04 C1 39 21 21 12 91 ?? ?? ?? ?? 08 00 00 14 08 01 0A 9B 0A 49 42 F9 E9 03 0A CB 28 05 40 92 0A 69 AA B8 2A 00 00 F9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_37_0 {
	meta:
		name = "??$extract_argument_from_va_list@H_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 260
		refs = "0048 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0088 ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00a0 _invalid_parameter 00d4 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 41 01 00 54 0A 10 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 9F B8 28 00 00 F9 2F 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 14 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 22 00 80 52 03 84 40 79 21 21 12 91 ?? ?? ?? ?? 08 00 00 14 08 01 0A 9B 0A 49 42 F9 E9 03 0A CB 28 05 40 92 0A 69 AA B8 2A 00 00 F9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_38_0 {
	meta:
		name = "??$extract_argument_from_va_list@H_J@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 40
		altNames = "??$extract_argument_from_va_list@H_J@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
	strings:
		$1 = { 0A 10 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 9F B8 20 00 80 52 28 00 00 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_40_0 {
	meta:
		name = "??$extract_argument_from_va_list@I_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 260
		refs = "0048 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0088 ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00a0 _invalid_parameter 00d4 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 41 01 00 54 0A 10 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F B8 28 00 00 F9 2F 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 14 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 22 00 80 52 03 04 C1 39 21 21 12 91 ?? ?? ?? ?? 08 00 00 14 08 01 0A 9B 0A 49 42 F9 E9 03 0A CB 28 05 40 92 0A 69 6A B8 2A 00 00 F9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_41_0 {
	meta:
		name = "??$extract_argument_from_va_list@I_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 260
		refs = "0048 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0088 ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00a0 _invalid_parameter 00d4 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 41 01 00 54 0A 10 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F B8 28 00 00 F9 2F 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 14 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 22 00 80 52 03 84 40 79 21 21 12 91 ?? ?? ?? ?? 08 00 00 14 08 01 0A 9B 0A 49 42 F9 E9 03 0A CB 28 05 40 92 0A 69 6A B8 2A 00 00 F9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_42_0 {
	meta:
		name = "??$extract_argument_from_va_list@I_J@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 40
		altNames = "??$extract_argument_from_va_list@I_J@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
	strings:
		$1 = { 0A 10 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F B8 20 00 80 52 28 00 00 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_44_0 {
	meta:
		name = "??$extract_argument_from_va_list@PEADPEAD@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAD@Z"
		size = 260
		refs = "0048 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0088 ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00a0 _invalid_parameter 00d4 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z"
		altNames = "??$extract_argument_from_va_list@PEAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ@PEAU1?1??234@AEAA_NXZ@@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@1@AEAA_NXZ@@Z ??$extract_argument_from_va_list@PEAXPEAX@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAX@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 41 01 00 54 0A 10 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F F8 28 00 00 F9 2F 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 14 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 62 00 80 52 03 04 C1 39 21 21 12 91 ?? ?? ?? ?? 08 00 00 14 08 01 0A 9B 0A 49 42 F9 E9 03 0A CB 28 09 40 92 0A 69 6A F8 2A 00 00 F9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_45_0 {
	meta:
		name = "??$extract_argument_from_va_list@PEADPEAD@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAD@Z"
		size = 260
		refs = "0048 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0088 ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00a0 _invalid_parameter 00d4 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z"
		altNames = "??$extract_argument_from_va_list@PEAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ@PEAU1?1??234@AEAA_NXZ@@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@1@AEAA_NXZ@@Z ??$extract_argument_from_va_list@PEAXPEAX@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAX@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 41 01 00 54 0A 10 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F F8 28 00 00 F9 2F 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 14 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 62 00 80 52 03 84 40 79 21 21 12 91 ?? ?? ?? ?? 08 00 00 14 08 01 0A 9B 0A 49 42 F9 E9 03 0A CB 28 09 40 92 0A 69 6A F8 2A 00 00 F9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_46_0 {
	meta:
		name = "??$extract_argument_from_va_list@PEADPEAD@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAD@Z"
		size = 40
		altNames = "??$extract_argument_from_va_list@PEADPEAD@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAD@Z ??$extract_argument_from_va_list@PEAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ@PEAU1?1??234@AEAA_NXZ@@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@1@AEAA_NXZ@@Z ??$extract_argument_from_va_list@PEAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ@PEAU1?1??234@AEAA_NXZ@@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@1@AEAA_NXZ@@Z ??$extract_argument_from_va_list@PEAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ@PEAU1?1??234@AEAA_NXZ@@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@1@AEAA_NXZ@@Z ??$extract_argument_from_va_list@PEAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ@PEAU1?1??234@AEAA_NXZ@@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@1@AEAA_NXZ@@Z ??$extract_argument_from_va_list@PEAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ@PEAU1?1??234@AEAA_NXZ@@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@1@AEAA_NXZ@@Z ??$extract_argument_from_va_list@PEAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ@PEAU1?1??234@AEAA_NXZ@@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@1@AEAA_NXZ@@Z ??$extract_argument_from_va_list@PEAXPEAX@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAX@Z ??$extract_argument_from_va_list@PEAXPEAX@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAX@Z ??$extract_argument_from_va_list@_J_J@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z ??$extract_argument_from_va_list@_J_J@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z ??$extract_argument_from_va_list@_K_J@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z ??$extract_argument_from_va_list@_K_J@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
	strings:
		$1 = { 0A 10 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F F8 20 00 80 52 28 00 00 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_60_0 {
	meta:
		name = "??$extract_argument_from_va_list@U_CRT_DOUBLE@@U1@@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAU_CRT_DOUBLE@@@Z"
		size = 256
		refs = "0044 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0048 ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 004c ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0068 _CrtDbgReportW 0078 _errno 0084 ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 009c _invalid_parameter 00d0 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 21 01 00 54 0A 10 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 70 81 5F FC 2E 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 14 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 82 00 80 52 03 04 C1 39 21 21 12 91 ?? ?? ?? ?? 08 00 00 14 08 01 0A 9B 0A 49 42 F9 E9 03 0A CB 28 09 40 92 10 69 6A FC 30 00 00 FD 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_61_0 {
	meta:
		name = "??$extract_argument_from_va_list@U_CRT_DOUBLE@@U1@@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAU_CRT_DOUBLE@@@Z"
		size = 256
		refs = "0044 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0048 ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 004c ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0068 _CrtDbgReportW 0078 _errno 0084 ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 009c _invalid_parameter 00d0 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 21 01 00 54 0A 10 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 70 81 5F FC 2E 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 14 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 82 00 80 52 03 84 40 79 21 21 12 91 ?? ?? ?? ?? 08 00 00 14 08 01 0A 9B 0A 49 42 F9 E9 03 0A CB 28 09 40 92 10 69 6A FC 30 00 00 FD 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_62_0 {
	meta:
		name = "??$extract_argument_from_va_list@U_CRT_DOUBLE@@U1@@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAU_CRT_DOUBLE@@@Z"
		size = 40
		altNames = "??$extract_argument_from_va_list@U_CRT_DOUBLE@@U1@@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAU_CRT_DOUBLE@@@Z"
	strings:
		$1 = { 0A 10 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 70 81 5F FC 20 00 80 52 30 00 00 FD C0 03 5F D6 }
	condition:
		$1
}

rule file_35_64_0 {
	meta:
		name = "??$extract_argument_from_va_list@_J_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 260
		refs = "0048 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0088 ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00a0 _invalid_parameter 00d4 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z"
		altNames = "??$extract_argument_from_va_list@_K_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 41 01 00 54 0A 10 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F F8 28 00 00 F9 2F 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 14 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 42 00 80 52 03 04 C1 39 21 21 12 91 ?? ?? ?? ?? 08 00 00 14 08 01 0A 9B 0A 49 42 F9 E9 03 0A CB 28 09 40 92 0A 69 6A F8 2A 00 00 F9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_65_0 {
	meta:
		name = "??$extract_argument_from_va_list@_J_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
		size = 260
		refs = "0048 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0088 ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00a0 _invalid_parameter 00d4 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z"
		altNames = "??$extract_argument_from_va_list@_K_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 41 01 00 54 0A 10 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F F8 28 00 00 F9 2F 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 14 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 42 00 80 52 03 84 40 79 21 21 12 91 ?? ?? ?? ?? 08 00 00 14 08 01 0A 9B 0A 49 42 F9 E9 03 0A CB 28 09 40 92 0A 69 6A F8 2A 00 00 F9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_72_0 {
	meta:
		name = "??$extract_argument_from_va_list@_W_W@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_W@Z"
		size = 260
		refs = "0048 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0088 ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00a0 _invalid_parameter 00d4 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 41 01 00 54 0A 10 40 F9 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F 78 28 00 00 79 2F 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 14 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 22 00 80 52 03 04 C1 39 21 21 12 91 ?? ?? ?? ?? 08 00 00 14 08 01 0A 9B 0A 49 42 F9 E9 03 0A CB 28 01 40 92 0A 69 6A 78 2A 00 00 79 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_73_0 {
	meta:
		name = "??$extract_argument_from_va_list@_W_W@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_W@Z"
		size = 260
		refs = "0048 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0088 ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00a0 _invalid_parameter 00d4 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 05 00 71 41 01 00 54 0A 10 40 F9 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F 78 28 00 00 79 2F 00 00 14 09 EC 4D B9 3F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 96 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 96 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 14 00 00 14 08 78 44 B9 0A 03 80 D2 1F 05 00 71 28 7D 40 93 01 01 00 54 09 01 0A 9B 04 3C 40 B9 22 00 80 52 03 84 40 79 21 21 12 91 ?? ?? ?? ?? 08 00 00 14 08 01 0A 9B 0A 49 42 F9 E9 03 0A CB 28 01 40 92 0A 69 6A 78 2A 00 00 79 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_74_0 {
	meta:
		name = "??$extract_argument_from_va_list@_W_W@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_W@Z"
		size = 40
		altNames = "??$extract_argument_from_va_list@_W_W@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_W@Z"
	strings:
		$1 = { 0A 10 40 F9 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F 78 20 00 80 52 28 00 00 79 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_82_0 {
	meta:
		name = "??$is_character_specifier@D@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@CA_ND@Z"
		size = 24
	strings:
		$1 = { 08 1C 00 53 09 0D 01 51 EA 1B 80 52 3F 01 0A 6A E0 17 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_35_83_0 {
	meta:
		name = "??$is_character_specifier@_W@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@CA_N_W@Z"
		size = 20
	strings:
		$1 = { 08 0C 01 51 E9 FB 9F 52 1F 01 09 6A E0 17 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_35_84_0 {
	meta:
		name = "??$is_integral_specifier@D@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@CA_ND@Z"
		size = 56
	strings:
		$1 = { 08 60 01 51 09 1D 00 53 3F 81 00 71 88 00 00 54 09 01 00 58 28 25 C8 9A 88 00 00 37 1F A8 00 71 00 00 80 52 41 00 00 54 20 00 80 52 C0 03 5F D6 01 10 82 20 01 00 00 00 }
	condition:
		$1
}

rule file_35_85_0 {
	meta:
		name = "??$is_integral_specifier@_W@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@CA_N_W@Z"
		size = 64
	strings:
		$1 = { 08 F5 9F 52 08 00 08 0B 09 3D 00 53 3F 81 00 71 88 00 00 54 28 01 00 58 08 25 C9 9A 88 00 00 37 1F A8 00 71 00 00 80 52 41 00 00 54 20 00 80 52 C0 03 5F D6 1F 20 03 D5 01 10 82 20 01 00 00 00 }
	condition:
		$1
}

rule file_35_88_0 {
	meta:
		name = "??$is_string_specifier@D@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@CA_ND@Z"
		size = 24
	strings:
		$1 = { 08 1C 00 53 09 4D 01 51 EA 1B 80 52 3F 01 0A 6A E0 17 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_35_89_0 {
	meta:
		name = "??$is_string_specifier@_W@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@CA_N_W@Z"
		size = 20
	strings:
		$1 = { 08 4C 01 51 E9 FB 9F 52 1F 01 09 6A E0 17 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_35_90_0 {
	meta:
		name = "??$is_wide_character_specifier@D@__crt_stdio_output@@YA_N_KDW4length_modifier@0@@Z"
		size = 80
	strings:
		$1 = { 5F 08 00 71 20 02 00 54 5F 0C 00 71 A0 01 00 54 5F 30 00 71 60 01 00 54 5F 34 00 71 60 01 00 54 28 1C 00 53 09 8D 01 51 EA 1D 80 52 3F 01 0A 6A E8 17 9F 1A 08 01 00 52 00 1D 00 53 04 00 00 14 20 00 80 52 02 00 00 14 00 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_91_0 {
	meta:
		name = "??$is_wide_character_specifier@_W@__crt_stdio_output@@YA_N_K_WW4length_modifier@0@@Z"
		size = 88
	strings:
		$1 = { 5F 08 00 71 60 02 00 54 5F 0C 00 71 E0 01 00 54 5F 30 00 71 A0 01 00 54 5F 34 00 71 60 01 00 54 28 8C 01 51 E9 FD 9F 52 1F 01 09 6A 0B 00 7E 92 EA 17 9F 1A 7F 01 00 F1 E8 17 9F 1A 09 01 0A 4A 20 1D 00 53 04 00 00 14 20 00 80 52 02 00 00 14 00 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_94_0 {
	meta:
		name = "??$peek_va_arg@F@__crt_stdio_output@@YAFPEAD@Z"
		size = 16
	strings:
		$1 = { E8 03 00 CB 09 01 40 92 20 69 E0 78 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_95_0 {
	meta:
		name = "??$peek_va_arg@G@__crt_stdio_output@@YAGPEAD@Z"
		size = 16
		altNames = "??$peek_va_arg@_W@__crt_stdio_output@@YA_WPEAD@Z"
	strings:
		$1 = { E8 03 00 CB 09 01 40 92 20 69 60 78 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_96_0 {
	meta:
		name = "??$peek_va_arg@H@__crt_stdio_output@@YAHPEAD@Z"
		size = 16
		altNames = "??$peek_va_arg@I@__crt_stdio_output@@YAIPEAD@Z"
	strings:
		$1 = { E8 03 00 CB 09 05 40 92 20 69 60 B8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_98_0 {
	meta:
		name = "??$peek_va_arg@PEAD@__crt_stdio_output@@YAPEADPEAD@Z"
		size = 16
		altNames = "??$peek_va_arg@PEAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ@@__crt_stdio_output@@YAPEAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@0@AEAA_NXZ@PEAD@Z ??$peek_va_arg@PEAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ@@__crt_stdio_output@@YAPEAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@0@AEAA_NXZ@PEAD@Z ??$peek_va_arg@PEAX@__crt_stdio_output@@YAPEAXPEAD@Z ??$peek_va_arg@_J@__crt_stdio_output@@YA_JPEAD@Z ??$peek_va_arg@_K@__crt_stdio_output@@YA_KPEAD@Z"
	strings:
		$1 = { E8 03 00 CB 09 09 40 92 20 69 60 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_102_0 {
	meta:
		name = "??$peek_va_arg@U_CRT_DOUBLE@@@__crt_stdio_output@@YA?AU_CRT_DOUBLE@@PEAD@Z"
		size = 16
	strings:
		$1 = { E8 03 00 CB 09 09 40 92 20 69 60 FC C0 03 5F D6 }
	condition:
		$1
}

rule file_35_108_0 {
	meta:
		name = "??$read_va_arg@C@__crt_stdio_output@@YACAEAPEAD@Z"
		size = 20
	strings:
		$1 = { 08 00 40 F9 09 21 00 91 09 00 00 F9 20 81 DF 38 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_109_0 {
	meta:
		name = "??$read_va_arg@E@__crt_stdio_output@@YAEAEAPEAD@Z"
		size = 20
	strings:
		$1 = { 08 00 40 F9 09 21 00 91 09 00 00 F9 20 81 5F 38 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_110_0 {
	meta:
		name = "??$read_va_arg@F@__crt_stdio_output@@YAFAEAPEAD@Z"
		size = 32
	strings:
		$1 = { 0A 00 40 F9 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 0B 00 00 F9 60 81 DF 78 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_111_0 {
	meta:
		name = "??$read_va_arg@G@__crt_stdio_output@@YAGAEAPEAD@Z"
		size = 32
		altNames = "??$read_va_arg@_W@__crt_stdio_output@@YA_WAEAPEAD@Z"
	strings:
		$1 = { 0A 00 40 F9 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 0B 00 00 F9 60 81 5F 78 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_112_0 {
	meta:
		name = "??$read_va_arg@H@__crt_stdio_output@@YAHAEAPEAD@Z"
		size = 32
		altNames = "??$read_va_arg@I@__crt_stdio_output@@YAIAEAPEAD@Z"
	strings:
		$1 = { 0A 00 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 0B 00 00 F9 60 81 5F B8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_114_0 {
	meta:
		name = "??$read_va_arg@PEAD@__crt_stdio_output@@YAPEADAEAPEAD@Z"
		size = 32
		altNames = "??$read_va_arg@PEAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ@@__crt_stdio_output@@YAPEAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@0@AEAA_NXZ@AEAPEAD@Z ??$read_va_arg@PEAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ@@__crt_stdio_output@@YAPEAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@0@AEAA_NXZ@AEAPEAD@Z ??$read_va_arg@PEAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ@@__crt_stdio_output@@YAPEAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@0@AEAA_NXZ@AEAPEAD@Z ??$read_va_arg@PEAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ@@__crt_stdio_output@@YAPEAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@0@AEAA_NXZ@AEAPEAD@Z ??$read_va_arg@PEAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ@@__crt_stdio_output@@YAPEAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@0@AEAA_NXZ@AEAPEAD@Z ??$read_va_arg@PEAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ@@__crt_stdio_output@@YAPEAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@0@AEAA_NXZ@AEAPEAD@Z ??$read_va_arg@PEAX@__crt_stdio_output@@YAPEAXAEAPEAD@Z ??$read_va_arg@_J@__crt_stdio_output@@YA_JAEAPEAD@Z ??$read_va_arg@_K@__crt_stdio_output@@YA_KAEAPEAD@Z"
	strings:
		$1 = { 0A 00 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 0B 00 00 F9 60 81 5F F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_122_0 {
	meta:
		name = "??$read_va_arg@U_CRT_DOUBLE@@@__crt_stdio_output@@YA?AU_CRT_DOUBLE@@AEAPEAD@Z"
		size = 32
	strings:
		$1 = { 0A 00 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 0B 00 00 F9 60 81 5F FC C0 03 5F D6 }
	condition:
		$1
}

rule file_35_127_0 {
	meta:
		name = "??$scratch_data@D@formatting_buffer@__crt_stdio_output@@QEAAPEADXZ"
		size = 28
	strings:
		$1 = { 09 04 42 F9 69 00 00 B5 00 00 08 91 03 00 00 14 08 00 42 F9 20 05 48 8B C0 03 5F D6 }
	condition:
		$1
}

rule file_35_132_0 {
	meta:
		name = "??$type_case_integer_parse_into_buffer@I@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXII_N@Z"
		size = 196
		altNames = "??$type_case_integer_parse_into_buffer@I@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXII_N@Z ??$type_case_integer_parse_into_buffer@I@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXII_N@Z"
	strings:
		$1 = { 09 60 01 91 28 05 42 F9 1F 01 00 F1 2A 01 88 9A 08 30 42 F9 68 00 00 B5 08 40 80 D2 03 00 00 14 08 2C 42 F9 08 FD 41 D3 08 01 0A 8B 06 05 00 D1 06 24 00 F9 0A 38 40 B9 5F 01 00 71 20 D8 40 7A 40 03 00 54 49 05 00 51 09 38 00 B9 42 00 00 35 80 00 3E D4 2C 08 C2 1A 8A 85 02 1B 81 01 00 11 4B C1 00 11 6D 1D 00 13 BF E5 00 71 2D 01 00 54 2E 08 80 52 7F 00 00 71 28 0C 80 52 C8 11 88 1A 0C 01 0D 0B 8D 1D 00 13 AE E9 00 51 CD 1D 00 13 0F 24 40 F9 ED 01 00 39 09 24 40 F9 27 05 00 D1 07 24 00 F9 E4 FF FF 17 08 24 40 F9 CA 00 08 4B 0A 50 00 B9 08 24 40 F9 09 05 00 91 09 24 00 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_135_0 {
	meta:
		name = "??$type_case_integer_parse_into_buffer@I@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXII_N@Z"
		size = 208
		altNames = "??$type_case_integer_parse_into_buffer@I@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXII_N@Z ??$type_case_integer_parse_into_buffer@I@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXII_N@Z"
	strings:
		$1 = { 09 60 01 91 28 05 42 F9 1F 01 00 F1 2A 01 88 9A 08 30 42 F9 68 00 00 B5 08 20 80 D2 03 00 00 14 08 2C 42 F9 08 FD 42 D3 48 05 08 8B 05 09 00 D1 05 24 00 F9 0A 38 40 B9 5F 01 00 71 20 D8 40 7A 80 03 00 54 49 05 00 51 09 38 00 B9 42 00 00 35 80 00 3E D4 2C 08 C2 1A 8A 85 02 1B 81 01 00 11 4B C1 00 11 6D 3D 00 53 BF E5 00 71 49 01 00 54 2E 08 80 52 7F 00 00 71 28 0C 80 52 C8 11 88 1A 0C 81 2D 0B 8D 1D 00 13 AE E9 00 51 CF 1D 00 13 ED 3D 00 53 09 24 40 F9 A7 1D 00 13 27 01 00 79 0A 24 40 F9 4B 09 00 D1 0B 24 00 F9 E2 FF FF 17 08 24 40 F9 A9 00 08 CB 2A FD 41 93 0A 50 00 B9 08 24 40 F9 09 09 00 91 09 24 00 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_138_0 {
	meta:
		name = "??$type_case_integer_parse_into_buffer@_K@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAX_KI_N@Z"
		size = 204
		altNames = "??$type_case_integer_parse_into_buffer@_K@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAX_KI_N@Z ??$type_case_integer_parse_into_buffer@_K@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAX_KI_N@Z"
	strings:
		$1 = { 09 60 01 91 28 05 42 F9 1F 01 00 F1 2A 01 88 9A 08 30 42 F9 68 00 00 B5 08 40 80 D2 03 00 00 14 08 2C 42 F9 08 FD 41 D3 08 01 0A 8B 05 05 00 D1 05 24 00 F9 0A 38 40 B9 5F 01 00 71 20 D8 40 FA 80 03 00 54 49 05 00 51 09 38 00 B9 4A 7C 40 D3 4A 00 00 B5 80 00 3E D4 2D 08 CA 9A AA 85 0A 9B A1 01 00 91 4B 1D 00 13 6C C1 00 11 8E 1D 00 13 DF E5 00 71 2D 01 00 54 2F 08 80 52 7F 00 00 71 28 0C 80 52 E8 11 88 1A 0D 01 0E 0B AE 1D 00 13 CF E9 00 51 EE 1D 00 13 09 24 40 F9 2E 01 00 39 07 24 40 F9 E6 04 00 D1 06 24 00 F9 E2 FF FF 17 08 24 40 F9 AA 00 08 4B 0A 50 00 B9 08 24 40 F9 09 05 00 91 09 24 00 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_141_0 {
	meta:
		name = "??$type_case_integer_parse_into_buffer@_K@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAX_KI_N@Z"
		size = 216
		altNames = "??$type_case_integer_parse_into_buffer@_K@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAX_KI_N@Z ??$type_case_integer_parse_into_buffer@_K@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAX_KI_N@Z"
	strings:
		$1 = { 09 60 01 91 28 05 42 F9 1F 01 00 F1 2A 01 88 9A 08 30 42 F9 68 00 00 B5 08 20 80 D2 03 00 00 14 08 2C 42 F9 08 FD 42 D3 48 05 08 8B 04 09 00 D1 04 24 00 F9 0A 38 40 B9 5F 01 00 71 20 D8 40 FA C0 03 00 54 49 05 00 51 09 38 00 B9 4A 7C 40 D3 4A 00 00 B5 80 00 3E D4 2D 08 CA 9A AA 85 0A 9B A1 01 00 91 4B 3D 00 53 6C C1 00 11 8E 3D 00 53 DF E5 00 71 49 01 00 54 2F 08 80 52 7F 00 00 71 28 0C 80 52 E8 11 88 1A 0D 81 2E 0B AE 1D 00 13 CF E9 00 51 E7 1D 00 13 EE 3C 00 53 06 24 40 F9 C9 1D 00 13 C9 00 00 79 0A 24 40 F9 4B 09 00 D1 0B 24 00 F9 E0 FF FF 17 08 24 40 F9 89 00 08 CB 2A FD 41 93 0A 50 00 B9 08 24 40 F9 09 09 00 91 09 24 00 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_144_0 {
	meta:
		name = "??$write_multiple_characters@V?$console_output_adapter@D@__crt_stdio_output@@D@__crt_stdio_output@@YAXAEBV?$console_output_adapter@D@0@DHQEAH@Z"
		size = 116
		refs = "002c _putch_nolock"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 55 00 00 11 BF 02 00 71 36 00 00 11 74 00 00 91 13 00 80 52 0D 02 00 54 C0 02 00 11 ?? ?? ?? ?? 1F 04 00 31 40 01 00 54 88 02 40 B9 09 05 00 11 89 02 00 B9 3F 05 00 31 E0 00 00 54 73 06 00 11 7F 02 15 6B 8A 00 00 54 F4 FF FF 17 08 00 80 12 88 02 00 B9 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_145_0 {
	meta:
		name = "??$write_multiple_characters@V?$console_output_adapter@_W@__crt_stdio_output@@D@__crt_stdio_output@@YAXAEBV?$console_output_adapter@_W@0@DHQEAH@Z"
		size = 120
		refs = "002c _putwch_nolock"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 55 00 00 11 BF 02 00 71 36 00 00 11 74 00 00 91 13 00 80 52 2D 02 00 54 C0 3E 00 53 ?? ?? ?? ?? E9 FF 9F 52 1F 00 09 6B 40 01 00 54 88 02 40 B9 09 05 00 11 89 02 00 B9 3F 05 00 31 E0 00 00 54 73 06 00 11 7F 02 15 6B 8A 00 00 54 F3 FF FF 17 08 00 80 12 88 02 00 B9 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_147_0 {
	meta:
		name = "??0?$common_data@D@__crt_stdio_output@@IEAA@XZ"
		size = 52
	strings:
		$1 = { 1F 7C 00 A9 1F 7C 01 A9 1F 10 00 F9 1F 7C 05 29 1F 7C 06 29 1F 38 00 B9 1F 00 01 39 1F 04 01 39 1F 50 00 B9 1F 50 01 39 1F 2C 02 F9 1F 30 02 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_148_0 {
	meta:
		name = "??0?$common_data@_W@__crt_stdio_output@@IEAA@XZ"
		size = 52
	strings:
		$1 = { 1F 7C 00 A9 1F 7C 01 A9 1F 10 00 F9 1F 7C 05 29 1F 7C 06 29 1F 38 00 B9 1F 00 01 39 1F 84 00 79 1F 50 00 B9 1F 50 01 39 1F 2C 02 F9 1F 30 02 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_149_0 {
	meta:
		name = "??0?$output_adapter_data@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA@AEBV?$console_output_adapter@D@1@_KQEBDQEAU__crt_locale_pointers@@QEAD@Z"
		size = 52
	strings:
		$1 = { 1F 08 00 F9 1F 7C 05 29 1F 7C 06 29 1F 38 00 B9 1F 00 01 39 1F 04 01 39 1F 50 00 B9 1F 50 01 39 1F 2C 02 F9 1F 30 02 F9 02 10 00 A9 03 94 01 A9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_150_0 {
	meta:
		name = "??0?$output_adapter_data@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA@AEBV?$console_output_adapter@_W@1@_KQEB_WQEAU__crt_locale_pointers@@QEAD@Z"
		size = 52
	strings:
		$1 = { 1F 08 00 F9 1F 7C 05 29 1F 7C 06 29 1F 38 00 B9 1F 00 01 39 1F 84 00 79 1F 50 00 B9 1F 50 01 39 1F 2C 02 F9 1F 30 02 F9 02 10 00 A9 03 94 01 A9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_151_0 {
	meta:
		name = "??0?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@AEBV?$console_output_adapter@D@1@_KQEBDQEAU__crt_locale_pointers@@QEAD@Z"
		size = 56
		altNames = "??0?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@AEBV?$console_output_adapter@D@1@_KQEBDQEAU__crt_locale_pointers@@QEAD@Z"
	strings:
		$1 = { 1F 08 00 F9 1F 7C 05 29 1F 7C 06 29 1F 38 00 B9 1F 00 01 39 1F 04 01 39 1F 50 00 B9 1F 50 01 39 1F 2C 02 F9 1F 30 02 F9 02 10 00 A9 03 94 01 A9 1F 70 04 B9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_152_0 {
	meta:
		name = "??0?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@AEBV?$console_output_adapter@D@1@_KQEBDQEAU__crt_locale_pointers@@QEAD@Z"
		size = 80
	strings:
		$1 = { 1F 08 00 F9 08 00 80 12 1F 7C 05 29 1F 7C 06 29 1F 38 00 B9 1F 00 01 39 1F 04 01 39 1F 50 00 B9 1F 50 01 39 1F 2C 02 F9 1F 30 02 F9 02 10 00 A9 03 94 01 A9 1F 70 04 B9 1F 78 04 B9 1F 7C 04 B9 03 40 02 F9 08 E8 0D B9 08 EC 0D B9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_154_0 {
	meta:
		name = "??0?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@AEBV?$console_output_adapter@_W@1@_KQEB_WQEAU__crt_locale_pointers@@QEAD@Z"
		size = 56
		altNames = "??0?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@AEBV?$console_output_adapter@_W@1@_KQEB_WQEAU__crt_locale_pointers@@QEAD@Z"
	strings:
		$1 = { 1F 08 00 F9 1F 7C 05 29 1F 7C 06 29 1F 38 00 B9 1F 00 01 39 1F 84 00 79 1F 50 00 B9 1F 50 01 39 1F 2C 02 F9 1F 30 02 F9 02 10 00 A9 03 94 01 A9 1F 70 04 B9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_155_0 {
	meta:
		name = "??0?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@AEBV?$console_output_adapter@_W@1@_KQEB_WQEAU__crt_locale_pointers@@QEAD@Z"
		size = 80
	strings:
		$1 = { 1F 08 00 F9 08 00 80 12 1F 7C 05 29 1F 7C 06 29 1F 38 00 B9 1F 00 01 39 1F 84 00 79 1F 50 00 B9 1F 50 01 39 1F 2C 02 F9 1F 30 02 F9 02 10 00 A9 03 94 01 A9 1F 70 04 B9 1F 78 04 B9 1F 7C 04 B9 03 40 02 F9 08 E8 0D B9 08 EC 0D B9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_159_0 {
	meta:
		name = "??0__crt_errno_guard@@QEAA@QEAH@Z"
		size = 20
	strings:
		$1 = { 01 00 00 F9 28 00 40 B9 08 08 00 B9 3F 00 00 B9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_162_0 {
	meta:
		name = "??1?$common_data@D@__crt_stdio_output@@QEAA@XZ"
		size = 44
		refs = "0018 _free_dbg"
		altNames = "??1?$common_data@_W@__crt_stdio_output@@QEAA@XZ ??1?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ ??1?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ ??1?$output_adapter_data@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ ??1?$output_adapter_data@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ ??1?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@XZ ??1?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@XZ ??1?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@XZ ??1?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@XZ ??1?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@XZ ??1?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAA@XZ ??1?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ ??1?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ ??1?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ ??1?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QEAA@XZ"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 32 42 F9 41 00 80 52 ?? ?? ?? ?? 7F 32 02 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_179_0 {
	meta:
		name = "??1__crt_errno_guard@@QEAA@XZ"
		size = 28
	strings:
		$1 = { 09 00 40 F9 28 01 40 B9 88 00 00 35 08 08 40 B9 48 00 00 34 28 01 00 B9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_180_0 {
	meta:
		name = "??1formatting_buffer@__crt_stdio_output@@QEAA@XZ"
		size = 44
		refs = "0018 _free_dbg"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 06 42 F9 41 00 80 52 ?? ?? ?? ?? 7F 06 02 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_181_0 {
	meta:
		name = "??4?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAAAEAV0@$$QEAV0@@Z"
		size = 64
		refs = "001c _free_dbg"
		altNames = "??4?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEAAAEAV0@$$QEAV0@@Z ??4?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEAAAEAV0@$$QEAV0@@Z ??4?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEAAAEAV0@$$QEAV0@@Z ??4?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAAAEAV0@$$QEAV0@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 80 02 40 F9 33 00 00 91 41 00 80 52 ?? ?? ?? ?? 9F 02 00 F9 68 02 40 F9 80 02 00 91 88 02 00 F9 7F 02 00 F9 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_184_0 {
	meta:
		name = "?adjust_hexit@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CADH_N@Z"
		size = 36
		altNames = "?adjust_hexit@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CADH_N@Z ?adjust_hexit@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CADH_N@Z ?adjust_hexit@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CADH_N@Z ?adjust_hexit@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CADH_N@Z ?adjust_hexit@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CADH_N@Z"
	strings:
		$1 = { 29 08 80 52 3F 00 00 71 28 0C 80 52 28 11 88 1A 09 81 20 0B 2A 1D 00 13 4B E9 00 51 60 1D 00 13 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_190_0 {
	meta:
		name = "?advance_to_next_pass@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
		size = 84
		altNames = "?advance_to_next_pass@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
	strings:
		$1 = { 08 78 44 B9 09 05 00 11 09 78 04 B9 3F 0D 00 71 61 00 00 54 00 00 80 52 0E 00 00 14 3F 09 00 71 81 00 00 54 08 7C 44 B9 1F 05 00 71 40 FF FF 54 08 00 80 12 1F 7C 04 B9 08 E8 0D B9 08 EC 0D B9 08 40 42 F9 1F FC 06 29 08 0C 00 F9 20 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_192_0 {
	meta:
		name = "?advance_to_next_pass@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
		size = 24
		altNames = "?advance_to_next_pass@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
	strings:
		$1 = { 08 70 44 B9 09 05 00 11 3F 09 00 71 09 70 04 B9 E0 07 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_35_194_0 {
	meta:
		name = "?crop_zeroes@__crt_stdio_output@@YAXPEADQEAU__crt_locale_pointers@@@Z"
		size = 152
	strings:
		$1 = { 28 00 40 F9 09 7D 40 F9 2A 01 40 F9 4D 01 C0 39 04 00 00 14 7F 01 0D 6B 80 00 00 54 00 04 00 91 0B 00 C0 39 8B FF FF 35 08 00 C0 39 0C 04 00 91 28 03 00 34 07 00 00 14 29 1D 00 53 2A 15 01 51 EE 1B 80 52 4A 01 0E 0A 8A 00 00 34 8C 05 00 91 89 01 C0 39 29 FF FF 35 8B 05 00 D1 68 01 C0 39 1F C1 00 71 A1 00 00 54 6B 05 00 D1 69 01 C0 39 3F C1 00 71 A0 FF FF 54 68 01 C0 39 1F 01 0D 6B 41 00 00 54 6B 05 00 D1 8A 15 C0 38 6A 1D 00 38 CA FF FF 35 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_195_0 {
	meta:
		name = "?find_next_state@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEBA?AW4state@2@DW432@@Z"
		size = 68
		refs = "000c format_validation_lookup_table"
		altNames = "?find_next_state@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEBA?AW4state@2@DW432@@Z"
	strings:
		$1 = { 28 80 03 11 09 1D 00 53 3F 69 01 71 ?? ?? ?? ?? C8 00 00 54 29 80 00 51 ?? ?? ?? ?? 0A C9 69 38 4B 0D 00 12 02 00 00 14 0B 00 80 52 68 0D 0B 0B ?? ?? ?? ?? 0A 01 02 0B 2B 49 6A 38 60 7D 04 53 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_197_0 {
	meta:
		name = "?find_next_state@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEBA?AW4state@2@DW432@@Z"
		size = 64
		refs = "000c standard_lookup_table"
	strings:
		$1 = { 28 80 03 11 09 1D 00 53 3F 69 01 71 ?? ?? ?? ?? C8 00 00 54 29 80 00 51 ?? ?? ?? ?? 0A C9 69 38 4B 0D 00 12 02 00 00 14 0B 00 80 52 49 0C 0B 0B ?? ?? ?? ?? 0A 49 69 38 40 7D 04 53 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_198_0 {
	meta:
		name = "?find_next_state@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEBA?AW4state@2@_WW432@@Z"
		size = 72
		refs = "0010 format_validation_lookup_table"
		altNames = "?find_next_state@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEBA?AW4state@2@_WW432@@Z"
	strings:
		$1 = { 08 FC 9F 52 28 00 08 0B 09 3D 00 53 3F 69 01 71 ?? ?? ?? ?? C8 00 00 54 29 80 00 51 ?? ?? ?? ?? 0A C9 69 38 4B 0D 00 12 02 00 00 14 0B 00 80 52 68 0D 0B 0B ?? ?? ?? ?? 0A 01 02 0B 2B 49 6A 38 60 7D 04 53 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_200_0 {
	meta:
		name = "?find_next_state@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEBA?AW4state@2@_WW432@@Z"
		size = 68
		refs = "0010 standard_lookup_table"
	strings:
		$1 = { 08 FC 9F 52 28 00 08 0B 09 3D 00 53 3F 69 01 71 ?? ?? ?? ?? C8 00 00 54 29 80 00 51 ?? ?? ?? ?? 0A C9 69 38 4B 0D 00 12 02 00 00 14 0B 00 80 52 49 0C 0B 0B ?? ?? ?? ?? 0A 49 69 38 40 7D 04 53 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_201_0 {
	meta:
		name = "?force_decimal_point@__crt_stdio_output@@YAXPEADQEAU__crt_locale_pointers@@@Z"
		size = 132
		refs = "0018 tolower 002c isdigit"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 02 C0 39 34 00 00 91 ?? ?? ?? ?? 1F 94 01 71 A0 00 00 54 73 06 00 91 60 02 40 39 ?? ?? ?? ?? A0 FF FF 35 60 02 C0 39 ?? ?? ?? ?? 1F E0 01 71 41 00 00 54 73 0A 00 91 88 02 40 F9 6D 06 00 91 6E 02 C0 39 09 7D 40 F9 2A 01 40 F9 4B 01 C0 39 6B 02 00 39 AC 15 C0 38 AE F1 1F 38 8E 01 00 11 AC F1 DF 38 8C FF FF 35 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_203_0 {
	meta:
		name = "?get@__crt_deferred_errno_cache@@QEAAAEAHXZ"
		size = 48
		refs = "0018 _errno"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 68 02 40 F9 68 00 00 B5 ?? ?? ?? ?? 60 02 00 F9 60 02 40 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_220_0 {
	meta:
		name = "?has_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEBA_NI@Z"
		size = 16
		altNames = "?has_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEBA_NI@Z ?has_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEBA_NI@Z ?has_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEBA_NI@Z ?has_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEBA_NI@Z ?has_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEBA_NI@Z"
	strings:
		$1 = { 08 30 40 B9 1F 01 01 6A E0 07 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_35_226_0 {
	meta:
		name = "?is_positional_parameter_reappearance_consistent@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEBUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z"
		size = 544
		refs = "01cc ??$is_wide_character_specifier@D@__crt_stdio_output@@YA_N_KDW4length_modifier@0@@Z"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 2B 00 00 91 61 11 C0 39 76 00 00 11 95 00 00 11 3F C0 01 71 E9 17 9F 1A DF C2 01 71 E8 17 9F 1A 49 0E 00 35 28 0E 00 35 28 1C 00 53 09 4D 01 51 EA 1B 80 52 C8 1E 00 53 3F 01 0A 6A 09 4D 01 51 EE 17 9F 1A 28 1C 00 53 3F 01 0A 6A 09 0D 01 51 ED 17 9F 1A C8 1E 00 53 3F 01 0A 6A 09 0D 01 51 EC 17 9F 1A 3F 01 0A 6A E8 17 9F 1A AE 09 00 35 8D 0B 00 35 AC 09 00 35 48 0B 00 35 28 60 01 51 09 1D 00 53 3F 81 00 71 0D 0C 00 58 68 00 00 54 A8 25 C8 9A 88 00 00 37 3F A8 00 71 0A 00 80 52 41 00 00 54 2A 00 80 52 C8 62 01 51 09 1D 00 53 3F 81 00 71 68 00 00 54 A8 25 C8 9A 88 00 00 37 DF AA 00 71 08 00 80 52 41 00 00 54 28 00 80 52 AA 00 00 35 68 08 00 35 68 01 40 B9 1F 01 02 6B 3E 00 00 14 5F 01 08 6B C1 07 00 54 6A 11 40 B9 5F 25 00 71 E9 17 9F 1A BF 26 00 71 E8 17 9F 1A 3F 01 08 6B E1 06 00 54 5F 2D 00 71 08 02 00 54 89 00 00 10 28 49 AA 38 28 09 08 8B 00 01 1F D6 03 05 07 03 09 09 09 09 0B 09 03 09 8B 00 80 D2 08 00 00 14 2B 00 80 D2 06 00 00 14 4B 00 80 D2 04 00 00 14 0B 01 80 D2 02 00 00 14 0B 00 80 D2 BF 2E 00 71 08 02 00 54 89 00 00 10 28 49 B5 38 28 09 08 8B 00 01 1F D6 03 05 07 03 09 09 09 09 0B 09 03 09 8A 00 80 D2 08 00 00 14 2A 00 80 D2 06 00 00 14 4A 00 80 D2 04 00 00 14 0A 01 80 D2 02 00 00 14 0A 00 80 D2 7F 01 0A EB 0F 00 00 14 DF 01 0D 6B E1 01 00 54 9F 01 08 6B A1 01 00 54 14 00 40 F9 62 11 40 B9 80 02 00 91 ?? ?? ?? ?? A2 02 00 11 13 00 00 11 80 02 00 91 C1 02 00 11 ?? ?? ?? ?? 7F 02 00 6B E0 17 9F 1A 06 00 00 14 00 00 80 52 04 00 00 14 08 01 09 4A 09 01 00 52 20 1D 00 53 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 1F 20 03 D5 01 10 82 20 01 00 00 00 }
	condition:
		$1
}

rule file_35_227_0 {
	meta:
		name = "?is_positional_parameter_reappearance_consistent@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEBUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z"
		size = 536
		refs = "01c4 ??$is_wide_character_specifier@_W@__crt_stdio_output@@YA_N_K_WW4length_modifier@0@@Z"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 2A 00 00 91 41 09 40 79 76 00 00 11 95 00 00 11 3F C0 01 71 E9 17 9F 1A DF C2 01 71 E8 17 9F 1A 09 0E 00 35 E8 0D 00 35 E9 FB 9F 52 28 4C 01 51 1F 01 09 6A C8 4E 01 51 ED 17 9F 1A 1F 01 09 6A 28 0C 01 51 EC 17 9F 1A 1F 01 09 6A C8 0E 01 51 EB 17 9F 1A 1F 01 09 6A E8 17 9F 1A ED 09 00 35 CC 0B 00 35 EB 09 00 35 88 0B 00 35 08 F5 9F 52 28 00 08 0B 09 3D 00 53 3F 81 00 71 2C 0C 00 58 68 00 00 54 88 25 C9 9A 88 00 00 37 3F A8 00 71 09 00 80 52 41 00 00 54 29 00 80 52 08 F5 9F 52 C8 02 08 0B 0B 3D 00 53 7F 81 00 71 68 00 00 54 88 25 CB 9A 88 00 00 37 DF AA 00 71 08 00 80 52 41 00 00 54 28 00 80 52 A9 00 00 35 68 08 00 35 48 01 40 B9 1F 01 02 6B 3E 00 00 14 3F 01 08 6B C1 07 00 54 4A 11 40 B9 5F 25 00 71 E9 17 9F 1A BF 26 00 71 E8 17 9F 1A 3F 01 08 6B E1 06 00 54 5F 2D 00 71 08 02 00 54 89 00 00 10 28 49 AA 38 28 09 08 8B 00 01 1F D6 03 05 07 03 09 09 09 09 0B 09 03 09 8B 00 80 D2 08 00 00 14 2B 00 80 D2 06 00 00 14 4B 00 80 D2 04 00 00 14 0B 01 80 D2 02 00 00 14 0B 00 80 D2 BF 2E 00 71 08 02 00 54 89 00 00 10 28 49 B5 38 28 09 08 8B 00 01 1F D6 03 05 07 03 09 09 09 09 0B 09 03 09 8A 00 80 D2 08 00 00 14 2A 00 80 D2 06 00 00 14 4A 00 80 D2 04 00 00 14 0A 01 80 D2 02 00 00 14 0A 00 80 D2 7F 01 0A EB 0F 00 00 14 BF 01 0C 6B E1 01 00 54 7F 01 08 6B A1 01 00 54 14 00 40 F9 42 11 40 B9 80 02 00 91 ?? ?? ?? ?? A2 02 00 11 13 00 00 11 80 02 00 91 C1 02 00 11 ?? ?? ?? ?? 7F 02 00 6B E0 17 9F 1A 06 00 00 14 00 00 80 52 04 00 00 14 08 01 09 4A 09 01 00 52 20 1D 00 53 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 1F 20 03 D5 01 10 82 20 01 00 00 00 }
	condition:
		$1
}

rule file_35_235_0 {
	meta:
		name = "?parse_int_from_format_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z"
		size = 176
		refs = "0020 _errno 0048 strtol"
		altNames = "?parse_int_from_format_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z ?parse_int_from_format_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BE A9 FD 03 00 91 13 00 00 91 68 0A 40 F9 36 00 00 91 68 00 00 B5 ?? ?? ?? ?? 60 0A 00 F9 74 0A 40 F9 42 01 80 52 E1 43 00 91 95 02 40 B9 9F 02 00 B9 68 0E 40 F9 FF 0B 00 F9 00 05 00 D1 ?? ?? ?? ?? C0 02 00 B9 68 0A 40 F9 68 00 00 B5 ?? ?? ?? ?? 60 0A 00 F9 68 0A 40 F9 09 01 40 B9 3F 89 00 71 00 01 00 54 68 0E 40 F9 E9 0B 40 F9 3F 01 08 EB 83 00 00 54 69 0E 00 F9 20 00 80 52 02 00 00 14 00 00 80 52 88 02 40 B9 68 00 00 35 55 00 00 34 95 02 00 B9 FD 7B C2 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_238_0 {
	meta:
		name = "?parse_int_from_format_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z"
		size = 176
		refs = "0020 _errno 0048 wcstol"
		altNames = "?parse_int_from_format_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z ?parse_int_from_format_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BE A9 FD 03 00 91 13 00 00 91 68 0A 40 F9 36 00 00 91 68 00 00 B5 ?? ?? ?? ?? 60 0A 00 F9 74 0A 40 F9 42 01 80 52 E1 43 00 91 95 02 40 B9 9F 02 00 B9 68 0E 40 F9 FF 0B 00 F9 00 09 00 D1 ?? ?? ?? ?? C0 02 00 B9 68 0A 40 F9 68 00 00 B5 ?? ?? ?? ?? 60 0A 00 F9 68 0A 40 F9 09 01 40 B9 3F 89 00 71 00 01 00 54 68 0E 40 F9 E9 0B 40 F9 3F 01 08 EB 83 00 00 54 69 0E 00 F9 20 00 80 52 02 00 00 14 00 00 80 52 88 02 40 B9 68 00 00 35 55 00 00 34 95 02 00 B9 FD 7B C2 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_241_0 {
	meta:
		name = "?process@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAAHXZ"
		size = 704
		refs = "0018 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 001c ??_C@_1CM@JOIJBMEM@?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAi?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0020 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 003c _CrtDbgReportW 004c _errno 0060 ??_C@_1BLG@HKIOHBGE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0070 _invalid_parameter 0090 format_validation_lookup_table 0134 ?state_case_normal@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0158 ?state_case_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0174 ?parse_int_from_format_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z 0210 ?state_case_size@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 021c ?state_case_type@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0248 ?validate_and_update_state_at_end_of_format_string@?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEBA_NXZ 0278 ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 68 0E 40 F9 48 03 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 02 CB 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 03 CB 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? 00 00 80 12 7C 00 00 14 68 72 44 B9 09 05 00 11 69 72 04 B9 3F 09 00 71 C0 0E 00 54 ?? ?? ?? ?? 69 0E 40 F9 7F 52 00 B9 7F 2E 00 B9 2A 01 C0 39 6A 06 01 39 8A 0C 00 34 6A 0E 40 F9 6B 2A 40 B9 48 05 00 91 68 0E 00 F9 4B 0C F8 37 6D 06 C1 39 67 2E 40 B9 AC 81 03 11 89 1D 00 53 3F 69 01 71 C8 00 00 54 AE 81 00 51 ?? ?? ?? ?? AF C9 6E 38 EA 0D 00 12 02 00 00 14 0A 00 80 52 48 0D 0A 0B ?? ?? ?? ?? 0A 01 07 0B 2B 49 6A 38 67 7D 04 53 67 2E 00 B9 FF 20 00 71 40 0B 00 54 FF 1C 00 71 08 FB FF 54 8C 00 00 10 8A 49 A7 38 8A 09 0A 8B 40 01 1F D6 02 05 0B 0E 24 26 39 3C 60 02 00 91 ?? ?? ?? ?? 3A 00 00 14 09 00 80 12 7F 7E 06 29 69 7E 07 29 7F 02 01 39 7F 52 01 39 36 00 00 14 60 02 00 91 ?? ?? ?? ?? 31 00 00 14 68 06 C1 39 1F A9 00 71 A0 00 00 54 61 D2 00 91 60 02 00 91 ?? ?? ?? ?? 2A 00 00 14 6A 12 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6C 81 5F B8 6C 36 00 B9 AC 00 F8 36 6B 36 46 29 6C 01 1E 32 EE 03 0D 4B 6C 3A 06 29 28 00 80 52 1C 00 00 14 7F 3A 00 B9 1B 00 00 14 68 06 C1 39 1F A9 00 71 60 00 00 54 61 E2 00 91 E8 FF FF 17 6A 12 40 F9 0D 00 80 12 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6C 81 5F B8 9F 01 00 71 6C 3A 00 B9 8B 01 00 11 AC B1 8B 1A 6C 3A 00 B9 EA FF FF 17 60 02 00 91 ?? ?? ?? ?? 03 00 00 14 60 02 00 91 ?? ?? ?? ?? 08 00 00 11 88 F2 FF 34 68 0E 40 F9 09 01 C0 39 69 06 01 39 C9 F3 FF 35 69 0E 40 F9 2A 05 00 91 6A 0E 00 F9 60 02 00 91 ?? ?? ?? ?? 40 F1 FF 34 69 72 44 B9 2A 05 00 11 6A 72 04 B9 5F 09 00 71 A1 F1 FF 54 60 2A 40 B9 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 CD 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 83 CD 80 52 ?? ?? ?? ?? 69 FF FF 17 }
	condition:
		$1
}

rule file_35_242_0 {
	meta:
		name = "?process@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAAHXZ"
		size = 612
		refs = "001c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0020 ??_C@_1CM@JOIJBMEM@?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAi?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0024 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0040 _CrtDbgReportW 0050 _errno 0064 ??_C@_1BLM@CNOJLNJD@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0074 _invalid_parameter 0080 format_validation_lookup_table 013c ?validate_and_update_state_at_beginning_of_format_character@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ 0174 ?state_case_normal@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0194 ?state_case_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 01a0 ?state_case_width@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 01b4 ?state_case_precision@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 01c0 ?state_case_size@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 01cc ?state_case_type@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 01f8 ?validate_and_update_state_at_end_of_format_string@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ 0208 ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 13 00 00 91 68 0E 40 F9 48 03 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 02 CB 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 03 CB 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? 00 00 80 12 76 00 00 14 ?? ?? ?? ?? 14 00 80 12 68 7A 44 B9 09 05 00 11 69 7A 04 B9 3F 0D 00 71 C0 0D 00 54 3F 09 00 71 81 00 00 54 69 7E 44 B9 3F 05 00 71 20 0D 00 54 6A 42 42 F9 7F 7E 04 B9 74 EA 0D B9 74 EE 0D B9 7F FE 06 29 6A 0E 00 F9 7F 52 00 B9 7F 2E 00 B9 48 01 C0 39 68 06 01 39 88 08 00 34 68 0E 40 F9 6A 2A 40 B9 09 05 00 91 69 0E 00 F9 4A 08 F8 37 6D 06 C1 39 67 2E 40 B9 AB 81 03 11 6C 1D 00 53 9F 69 01 71 C8 00 00 54 AE 81 00 51 ?? ?? ?? ?? AF C9 6E 38 E8 0D 00 12 02 00 00 14 08 00 80 52 08 0D 08 0B ?? ?? ?? ?? 60 02 00 91 0A 01 07 0B 2B 49 6A 38 6A 7D 04 53 6A 2E 00 B9 ?? ?? ?? ?? C0 F9 FF 34 6B 2E 40 B9 7F 21 00 71 C0 05 00 54 7F 1D 00 71 28 F9 FF 54 8A 00 00 10 49 49 AB 38 49 09 09 8B 20 01 1F D6 02 05 0A 0D 10 12 15 18 60 02 00 91 ?? ?? ?? ?? 16 00 00 14 7F 7E 06 29 7F 02 01 39 74 7E 07 29 7F 52 01 39 13 00 00 14 60 02 00 91 ?? ?? ?? ?? 0E 00 00 14 60 02 00 91 ?? ?? ?? ?? 0B 00 00 14 7F 3A 00 B9 0B 00 00 14 60 02 00 91 ?? ?? ?? ?? 06 00 00 14 60 02 00 91 ?? ?? ?? ?? 03 00 00 14 60 02 00 91 ?? ?? ?? ?? 08 00 00 11 28 F5 FF 34 68 0E 40 F9 09 01 C0 39 69 06 01 39 C9 F7 FF 35 69 0E 40 F9 2A 05 00 91 6A 0E 00 F9 60 02 00 91 ?? ?? ?? ?? E0 F3 FF 34 A2 FF FF 17 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 CD 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 83 CD 80 52 ?? ?? ?? ?? 86 FF FF 17 60 2A 40 B9 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_243_0 {
	meta:
		name = "?process@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAAHXZ"
		size = 688
		refs = "0018 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 001c ??_C@_1CM@JOIJBMEM@?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAi?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0020 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 003c _CrtDbgReportW 004c _errno 0060 ??_C@_1BKE@EJAONHIE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0070 _invalid_parameter 0090 standard_lookup_table 0130 ?state_case_normal@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0154 ?state_case_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0170 ?parse_int_from_format_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z 020c ?state_case_size@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0218 ?state_case_type@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0268 ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 68 0E 40 F9 48 03 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 02 CB 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 03 CB 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? 00 00 80 12 78 00 00 14 68 72 44 B9 09 05 00 11 69 72 04 B9 3F 09 00 71 40 0E 00 54 ?? ?? ?? ?? 69 0E 40 F9 7F 52 00 B9 7F 2E 00 B9 2A 01 C0 39 6A 06 01 39 6A 0C 00 34 6A 0E 40 F9 6B 2A 40 B9 48 05 00 91 68 0E 00 F9 2B 0C F8 37 6D 06 C1 39 67 2E 40 B9 AC 81 03 11 89 1D 00 53 3F 69 01 71 C8 00 00 54 AE 81 00 51 ?? ?? ?? ?? AF C9 6E 38 EA 0D 00 12 02 00 00 14 0A 00 80 52 EA 0C 0A 0B ?? ?? ?? ?? 0B 49 6A 38 67 7D 04 53 67 2E 00 B9 FF 20 00 71 E0 0A 00 54 FF 1C 00 71 28 FB FF 54 8C 00 00 10 89 49 A7 38 89 09 09 8B 20 01 1F D6 02 05 0B 0E 24 26 39 3C 60 02 00 91 ?? ?? ?? ?? 3A 00 00 14 09 00 80 12 7F 7E 06 29 69 7E 07 29 7F 02 01 39 7F 52 01 39 36 00 00 14 60 02 00 91 ?? ?? ?? ?? 31 00 00 14 68 06 C1 39 1F A9 00 71 A0 00 00 54 61 D2 00 91 60 02 00 91 ?? ?? ?? ?? 2A 00 00 14 6A 12 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6C 81 5F B8 6C 36 00 B9 AC 00 F8 36 6B 36 46 29 6C 01 1E 32 EE 03 0D 4B 6C 3A 06 29 28 00 80 52 1C 00 00 14 7F 3A 00 B9 1B 00 00 14 68 06 C1 39 1F A9 00 71 60 00 00 54 61 E2 00 91 E8 FF FF 17 6A 12 40 F9 0D 00 80 12 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6C 81 5F B8 9F 01 00 71 6C 3A 00 B9 8B 01 00 11 AC B1 8B 1A 6C 3A 00 B9 EA FF FF 17 60 02 00 91 ?? ?? ?? ?? 03 00 00 14 60 02 00 91 ?? ?? ?? ?? 08 00 00 11 A8 F2 FF 34 68 0E 40 F9 09 01 C0 39 69 06 01 39 E9 F3 FF 35 69 0E 40 F9 2A 05 00 91 6A 0E 00 F9 6B 72 44 B9 6C 05 00 11 6C 72 04 B9 9F 09 00 71 21 F2 FF 54 60 2A 40 B9 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 CD 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 83 CD 80 52 ?? ?? ?? ?? 6D FF FF 17 }
	condition:
		$1
}

rule file_35_244_0 {
	meta:
		name = "?process@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAAHXZ"
		size = 756
		refs = "001c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0020 ??_C@_1CM@JOIJBMEM@?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAi?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0024 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0040 _CrtDbgReportW 0050 _errno 0064 ??_C@_1BMO@BFJMLNMJ@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0074 _invalid_parameter 0094 format_validation_lookup_table 0148 _putwch_nolock 0188 ?state_case_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 01a4 ?parse_int_from_format_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z 0240 ?state_case_size@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 024c ?state_case_type@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0278 ?validate_and_update_state_at_end_of_format_string@?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEBA_NXZ 02ac ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 13 00 00 91 68 0E 40 F9 48 03 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 02 CB 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 03 CB 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? 00 00 80 12 87 00 00 14 68 72 44 B9 09 05 00 11 69 72 04 B9 3F 09 00 71 20 10 00 54 ?? ?? ?? ?? 14 00 80 12 69 0E 40 F9 7F 52 00 B9 7F 2E 00 B9 2A 01 40 79 6A 86 00 79 CA 0D 00 34 68 0E 40 F9 6B 2A 40 B9 0A 09 00 91 6A 0E 00 F9 8B 0D F8 37 6D 86 40 79 0C FC 9F 52 67 2E 40 B9 A9 01 0C 0B 2C 3D 00 53 9F 69 01 71 C8 00 00 54 AE 81 00 51 ?? ?? ?? ?? AF C9 6E 38 E8 0D 00 12 02 00 00 14 08 00 80 52 08 0D 08 0B ?? ?? ?? ?? 0A 01 07 0B 2B 49 6A 38 67 7D 04 53 67 2E 00 B9 FF 20 00 71 80 0C 00 54 FF 1C 00 71 C8 FA FF 54 8C 00 00 10 8A 49 A7 38 8A 09 0A 8B 40 01 1F D6 02 0F 14 17 2D 2F 42 45 60 86 40 79 2D 00 80 52 6D 52 01 39 ?? ?? ?? ?? E9 FF 9F 52 1F 00 09 6B 61 00 00 54 74 2A 00 B9 3F 00 00 14 68 2A 40 B9 09 05 00 11 69 2A 00 B9 3B 00 00 14 7F 7E 06 29 7F 02 01 39 74 7E 07 29 7F 52 01 39 36 00 00 14 60 02 00 91 ?? ?? ?? ?? 31 00 00 14 68 86 40 79 1F A9 00 71 A0 00 00 54 61 D2 00 91 60 02 00 91 ?? ?? ?? ?? 2A 00 00 14 6A 12 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6C 81 5F B8 6C 36 00 B9 AC 00 F8 36 6B 36 46 29 6C 01 1E 32 EE 03 0D 4B 6C 3A 06 29 28 00 80 52 1C 00 00 14 7F 3A 00 B9 1B 00 00 14 68 86 40 79 1F A9 00 71 60 00 00 54 61 E2 00 91 E8 FF FF 17 6A 12 40 F9 0D 00 80 12 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6C 81 5F B8 9F 01 00 71 6C 3A 00 B9 8B 01 00 11 AC B1 8B 1A 6C 3A 00 B9 EA FF FF 17 60 02 00 91 ?? ?? ?? ?? 03 00 00 14 60 02 00 91 ?? ?? ?? ?? 08 00 00 11 28 F1 FF 34 68 0E 40 F9 09 01 40 79 69 86 00 79 89 F2 FF 35 69 0E 40 F9 2A 09 00 91 6A 0E 00 F9 60 02 00 91 ?? ?? ?? ?? E0 EF FF 34 69 72 44 B9 2A 05 00 11 6A 72 04 B9 5F 09 00 71 61 F0 FF 54 60 2A 40 B9 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 CD 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 83 CD 80 52 ?? ?? ?? ?? 5D FF FF 17 }
	condition:
		$1
}

rule file_35_245_0 {
	meta:
		name = "?process@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAAHXZ"
		size = 616
		refs = "001c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0020 ??_C@_1CM@JOIJBMEM@?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAi?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0024 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0040 _CrtDbgReportW 0050 _errno 0064 ??_C@_1BNE@IJFKJKMM@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0074 _invalid_parameter 0080 format_validation_lookup_table 0140 ?validate_and_update_state_at_beginning_of_format_character@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ 0178 ?state_case_normal@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0198 ?state_case_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 01a4 ?state_case_width@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 01b8 ?state_case_precision@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 01c4 ?state_case_size@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 01d0 ?state_case_type@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 01fc ?validate_and_update_state_at_end_of_format_string@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ 020c ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 13 00 00 91 68 0E 40 F9 48 03 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 02 CB 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 03 CB 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? 00 00 80 12 77 00 00 14 ?? ?? ?? ?? 14 00 80 12 68 7A 44 B9 09 05 00 11 69 7A 04 B9 3F 0D 00 71 E0 0D 00 54 3F 09 00 71 81 00 00 54 69 7E 44 B9 3F 05 00 71 40 0D 00 54 6A 42 42 F9 7F 7E 04 B9 74 EA 0D B9 74 EE 0D B9 7F FE 06 29 6A 0E 00 F9 7F 52 00 B9 7F 2E 00 B9 48 01 40 79 68 86 00 79 A8 08 00 34 68 0E 40 F9 6A 2A 40 B9 09 09 00 91 69 0E 00 F9 6A 08 F8 37 6D 86 40 79 0B FC 9F 52 67 2E 40 B9 AB 01 0B 0B 6C 3D 00 53 9F 69 01 71 C8 00 00 54 AE 81 00 51 ?? ?? ?? ?? AF C9 6E 38 E8 0D 00 12 02 00 00 14 08 00 80 52 08 0D 08 0B ?? ?? ?? ?? 60 02 00 91 0A 01 07 0B 2B 49 6A 38 6A 7D 04 53 6A 2E 00 B9 ?? ?? ?? ?? A0 F9 FF 34 6B 2E 40 B9 7F 21 00 71 C0 05 00 54 7F 1D 00 71 08 F9 FF 54 8A 00 00 10 49 49 AB 38 49 09 09 8B 20 01 1F D6 02 05 0A 0D 10 12 15 18 60 02 00 91 ?? ?? ?? ?? 16 00 00 14 7F 7E 06 29 7F 02 01 39 74 7E 07 29 7F 52 01 39 13 00 00 14 60 02 00 91 ?? ?? ?? ?? 0E 00 00 14 60 02 00 91 ?? ?? ?? ?? 0B 00 00 14 7F 3A 00 B9 0B 00 00 14 60 02 00 91 ?? ?? ?? ?? 06 00 00 14 60 02 00 91 ?? ?? ?? ?? 03 00 00 14 60 02 00 91 ?? ?? ?? ?? 08 00 00 11 08 F5 FF 34 68 0E 40 F9 09 01 40 79 69 86 00 79 A9 F7 FF 35 69 0E 40 F9 2A 09 00 91 6A 0E 00 F9 60 02 00 91 ?? ?? ?? ?? C0 F3 FF 34 A1 FF FF 17 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 CD 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 83 CD 80 52 ?? ?? ?? ?? 85 FF FF 17 60 2A 40 B9 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_246_0 {
	meta:
		name = "?process@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QEAAHXZ"
		size = 740
		refs = "001c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0020 ??_C@_1CM@JOIJBMEM@?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAi?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0024 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0040 _CrtDbgReportW 0050 _errno 0064 ??_C@_1BLM@MEMPCIGD@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0074 _invalid_parameter 0094 standard_lookup_table 0144 _putwch_nolock 0184 ?state_case_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 01a0 ?parse_int_from_format_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z 023c ?state_case_size@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0248 ?state_case_type@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 029c ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 13 00 00 91 68 0E 40 F9 48 03 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 02 CB 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 03 CB 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? 00 00 80 12 83 00 00 14 68 72 44 B9 09 05 00 11 69 72 04 B9 3F 09 00 71 A0 0F 00 54 ?? ?? ?? ?? 14 00 80 12 69 0E 40 F9 7F 52 00 B9 7F 2E 00 B9 2A 01 40 79 6A 86 00 79 AA 0D 00 34 68 0E 40 F9 6B 2A 40 B9 0A 09 00 91 6A 0E 00 F9 6B 0D F8 37 6D 86 40 79 0C FC 9F 52 67 2E 40 B9 A9 01 0C 0B 2C 3D 00 53 9F 69 01 71 C8 00 00 54 AE 81 00 51 ?? ?? ?? ?? AF C9 6E 38 E8 0D 00 12 02 00 00 14 08 00 80 52 EA 0C 08 0B ?? ?? ?? ?? 0B 49 6A 38 67 7D 04 53 67 2E 00 B9 FF 20 00 71 20 0C 00 54 FF 1C 00 71 E8 FA FF 54 8C 00 00 10 89 49 A7 38 89 09 09 8B 20 01 1F D6 02 0F 14 17 2D 2F 42 45 60 86 40 79 2D 00 80 52 6D 52 01 39 ?? ?? ?? ?? E9 FF 9F 52 1F 00 09 6B 61 00 00 54 74 2A 00 B9 3F 00 00 14 68 2A 40 B9 09 05 00 11 69 2A 00 B9 3B 00 00 14 7F 7E 06 29 7F 02 01 39 74 7E 07 29 7F 52 01 39 36 00 00 14 60 02 00 91 ?? ?? ?? ?? 31 00 00 14 68 86 40 79 1F A9 00 71 A0 00 00 54 61 D2 00 91 60 02 00 91 ?? ?? ?? ?? 2A 00 00 14 6A 12 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6C 81 5F B8 6C 36 00 B9 AC 00 F8 36 6B 36 46 29 6C 01 1E 32 EE 03 0D 4B 6C 3A 06 29 28 00 80 52 1C 00 00 14 7F 3A 00 B9 1B 00 00 14 68 86 40 79 1F A9 00 71 60 00 00 54 61 E2 00 91 E8 FF FF 17 6A 12 40 F9 0D 00 80 12 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6C 81 5F B8 9F 01 00 71 6C 3A 00 B9 8B 01 00 11 AC B1 8B 1A 6C 3A 00 B9 EA FF FF 17 60 02 00 91 ?? ?? ?? ?? 03 00 00 14 60 02 00 91 ?? ?? ?? ?? 08 00 00 11 48 F1 FF 34 68 0E 40 F9 09 01 40 79 69 86 00 79 A9 F2 FF 35 69 0E 40 F9 2A 09 00 91 6A 0E 00 F9 6B 72 44 B9 6C 05 00 11 6C 72 04 B9 9F 09 00 71 E1 F0 FF 54 60 2A 40 B9 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 CD 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 83 CD 80 52 ?? ?? ?? ?? 61 FF FF 17 }
	condition:
		$1
}

rule file_35_248_0 {
	meta:
		name = "?set_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXI@Z"
		size = 16
		altNames = "?set_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXI@Z ?set_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXI@Z ?set_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXI@Z ?set_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXI@Z ?set_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXI@Z"
	strings:
		$1 = { 08 30 40 B9 29 00 08 2A 09 30 00 B9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_254_0 {
	meta:
		name = "?should_format@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
		size = 36
		altNames = "?should_format@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
	strings:
		$1 = { 08 78 44 B9 1F 05 00 71 A1 00 00 54 08 7C 44 B9 00 00 80 52 1F 05 00 71 41 00 00 54 20 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_258_0 {
	meta:
		name = "?should_skip_normal_state_processing@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
		size = 56
		altNames = "?should_skip_normal_state_processing@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
	strings:
		$1 = { 09 78 44 B9 3F 05 00 71 C1 00 00 54 08 7C 44 B9 1F 09 00 71 61 00 00 54 20 00 80 52 06 00 00 14 3F 09 00 71 61 00 00 54 08 7C 44 B9 68 FF FF 34 00 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_262_0 {
	meta:
		name = "?should_skip_type_state_output@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEBA_NXZ"
		size = 36
		altNames = "?should_skip_type_state_output@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEBA_NXZ"
	strings:
		$1 = { 08 7C 44 B9 1F 09 00 71 A1 00 00 54 08 78 44 B9 20 00 80 52 1F 05 00 71 40 00 00 54 00 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_272_0 {
	meta:
		name = "?state_case_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 112
		altNames = "?state_case_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ ?state_case_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
	strings:
		$1 = { 08 04 C1 39 1F 81 00 71 A0 02 00 54 1F 8D 00 71 00 02 00 54 1F AD 00 71 60 01 00 54 1F B5 00 71 C0 00 00 54 1F C1 00 71 01 02 00 54 08 30 40 B9 09 01 1D 32 0C 00 00 14 08 30 40 B9 09 01 1E 32 09 00 00 14 08 30 40 B9 09 01 00 32 06 00 00 14 08 30 40 B9 09 01 1B 32 03 00 00 14 08 30 40 B9 09 01 1F 32 09 30 00 B9 20 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_275_0 {
	meta:
		name = "?state_case_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 112
		altNames = "?state_case_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ ?state_case_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
	strings:
		$1 = { 08 84 40 79 1F 81 00 71 A0 02 00 54 1F 8D 00 71 00 02 00 54 1F AD 00 71 60 01 00 54 1F B5 00 71 C0 00 00 54 1F C1 00 71 01 02 00 54 08 30 40 B9 09 01 1D 32 0C 00 00 14 08 30 40 B9 09 01 1E 32 09 00 00 14 08 30 40 B9 09 01 00 32 06 00 00 14 08 30 40 B9 09 01 1B 32 03 00 00 14 08 30 40 B9 09 01 1F 32 09 30 00 B9 20 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_278_0 {
	meta:
		name = "?state_case_normal@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 200
		refs = "0014 ?state_case_normal_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z 0028 _putch_nolock 0054 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0058 ??_C@_1DG@CEJKFDMO@?$AAs?$AAt?$AAa?$AAt?$AAe?$AA_?$AAc?$AAa?$AAs?$AAe?$AA_?$AAn?$AAo?$AAr?$AAm?$AAa?$AAl?$AA_?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA?$CI?$AA?$CJ?$AA?$AA@ 005c ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0078 _CrtDbgReportW 0088 _errno 0094 ??_C@_1BMK@BGPKBIHJ@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00ac _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 01 00 80 52 13 00 00 91 ?? ?? ?? ?? 60 00 00 35 08 00 80 52 0C 00 00 14 60 06 C1 39 ?? ?? ?? ?? 1F 04 00 31 81 00 00 54 08 00 80 12 68 2A 00 B9 04 00 00 14 68 2A 40 B9 09 05 00 11 69 2A 00 B9 28 00 80 52 48 03 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 22 D3 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 23 D3 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 02 00 00 14 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_280_0 {
	meta:
		name = "?state_case_normal@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 200
		refs = "0014 ?state_case_normal_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z 0028 _putch_nolock 0054 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0058 ??_C@_1DG@CEJKFDMO@?$AAs?$AAt?$AAa?$AAt?$AAe?$AA_?$AAc?$AAa?$AAs?$AAe?$AA_?$AAn?$AAo?$AAr?$AAm?$AAa?$AAl?$AA_?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA?$CI?$AA?$CJ?$AA?$AA@ 005c ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0078 _CrtDbgReportW 0088 _errno 0094 ??_C@_1BLI@LHEFBLJN@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00ac _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 01 00 80 52 13 00 00 91 ?? ?? ?? ?? 60 00 00 35 08 00 80 52 0C 00 00 14 60 06 C1 39 ?? ?? ?? ?? 1F 04 00 31 81 00 00 54 08 00 80 12 68 2A 00 B9 04 00 00 14 68 2A 40 B9 09 05 00 11 69 2A 00 B9 28 00 80 52 48 03 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 22 D3 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 23 D3 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 02 00 00 14 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_279_0 {
	meta:
		name = "?state_case_normal@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 244
		refs = "0040 ?state_case_normal_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z 0054 _putch_nolock 0080 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0084 ??_C@_1DG@CEJKFDMO@?$AAs?$AAt?$AAa?$AAt?$AAe?$AA_?$AAc?$AAa?$AAs?$AAe?$AA_?$AAn?$AAo?$AAr?$AAm?$AAa?$AAl?$AA_?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA?$CI?$AA?$CJ?$AA?$AA@ 0088 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 00a4 _CrtDbgReportW 00b4 _errno 00c0 ??_C@_1BNA@IDNMDBH@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00d8 _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 69 7A 44 B9 3F 05 00 71 81 00 00 54 68 7E 44 B9 1F 09 00 71 00 06 00 54 3F 09 00 71 61 00 00 54 68 7E 44 B9 88 05 00 34 01 00 80 52 60 02 00 91 ?? ?? ?? ?? 60 00 00 35 08 00 80 52 0C 00 00 14 60 06 C1 39 ?? ?? ?? ?? 1F 04 00 31 81 00 00 54 08 00 80 12 68 2A 00 B9 04 00 00 14 68 2A 40 B9 09 05 00 11 69 2A 00 B9 28 00 80 52 48 03 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 22 D3 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 23 D3 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 02 00 00 14 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_281_0 {
	meta:
		name = "?state_case_normal@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 84
		refs = "001c _putwch_nolock"
		altNames = "?state_case_normal@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ ?state_case_normal_common@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ ?state_case_normal_common@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ ?state_case_normal_common@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 86 40 79 28 00 80 52 68 52 01 39 ?? ?? ?? ?? E9 FF 9F 52 1F 00 09 6B 81 00 00 54 08 00 80 12 68 2A 00 B9 04 00 00 14 68 2A 40 B9 09 05 00 11 69 2A 00 B9 20 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_282_0 {
	meta:
		name = "?state_case_normal@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 124
		refs = "0044 _putwch_nolock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 69 7A 44 B9 3F 05 00 71 81 00 00 54 68 7E 44 B9 1F 09 00 71 40 02 00 54 3F 09 00 71 61 00 00 54 68 7E 44 B9 C8 01 00 34 60 86 40 79 28 00 80 52 68 52 01 39 ?? ?? ?? ?? E9 FF 9F 52 1F 00 09 6B 81 00 00 54 08 00 80 12 68 2A 00 B9 04 00 00 14 68 2A 40 B9 09 05 00 11 69 2A 00 B9 20 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_284_0 {
	meta:
		name = "?state_case_normal_common@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 92
		refs = "0014 ?state_case_normal_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z 0028 _putch_nolock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 01 00 80 52 13 00 00 91 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 0C 00 00 14 60 06 C1 39 ?? ?? ?? ?? 1F 04 00 31 81 00 00 54 08 00 80 12 68 2A 00 B9 04 00 00 14 68 2A 40 B9 09 05 00 11 69 2A 00 B9 20 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_285_0 {
	meta:
		name = "?state_case_normal_common@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 92
		refs = "0014 ?state_case_normal_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z 0028 _putch_nolock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 01 00 80 52 13 00 00 91 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 0C 00 00 14 60 06 C1 39 ?? ?? ?? ?? 1F 04 00 31 81 00 00 54 08 00 80 12 68 2A 00 B9 04 00 00 14 68 2A 40 B9 09 05 00 11 69 2A 00 B9 20 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_286_0 {
	meta:
		name = "?state_case_normal_common@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 92
		refs = "0014 ?state_case_normal_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z 0028 _putch_nolock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 01 00 80 52 13 00 00 91 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 0C 00 00 14 60 06 C1 39 ?? ?? ?? ?? 1F 04 00 31 81 00 00 54 08 00 80 12 68 2A 00 B9 04 00 00 14 68 2A 40 B9 09 05 00 11 69 2A 00 B9 20 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_290_0 {
	meta:
		name = "?state_case_normal_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z"
		size = 224
		refs = "0030 _putch_nolock 006c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0070 ??_C@_1CK@LGDCECDH@?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAc?$AAh?$AAa?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?8?$AA?2?$AA0?$AA?8?$AA?$AA@ 0074 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0090 _CrtDbgReportW 00a0 _errno 00ac ??_C@_1BNG@BIPBMMDF@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00c4 _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 68 06 40 F9 7F 52 01 39 60 06 C1 39 09 01 40 F9 0B 1C 00 53 2A 01 40 F9 4B D9 6B 78 2B 05 78 36 ?? ?? ?? ?? 1F 04 00 31 81 00 00 54 08 00 80 12 68 2A 00 B9 04 00 00 14 68 2A 40 B9 09 05 00 11 69 2A 00 B9 69 0E 40 F9 28 15 C0 38 68 06 01 39 08 1D 00 13 69 0E 00 F9 48 03 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 22 D6 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 23 D6 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 02 00 00 14 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_291_0 {
	meta:
		name = "?state_case_normal_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z"
		size = 224
		refs = "0030 _putch_nolock 006c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0070 ??_C@_1CK@LGDCECDH@?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAc?$AAh?$AAa?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?8?$AA?2?$AA0?$AA?8?$AA?$AA@ 0074 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0090 _CrtDbgReportW 00a0 _errno 00ac ??_C@_1BNM@LINJAOH@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00c4 _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 68 06 40 F9 7F 52 01 39 60 06 C1 39 09 01 40 F9 0B 1C 00 53 2A 01 40 F9 4B D9 6B 78 2B 05 78 36 ?? ?? ?? ?? 1F 04 00 31 81 00 00 54 08 00 80 12 68 2A 00 B9 04 00 00 14 68 2A 40 B9 09 05 00 11 69 2A 00 B9 69 0E 40 F9 28 15 C0 38 68 06 01 39 08 1D 00 13 69 0E 00 F9 48 03 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 22 D6 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 23 D6 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 02 00 00 14 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_292_0 {
	meta:
		name = "?state_case_normal_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z"
		size = 224
		refs = "0030 _putch_nolock 006c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0070 ??_C@_1CK@LGDCECDH@?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAc?$AAh?$AAa?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?8?$AA?2?$AA0?$AA?8?$AA?$AA@ 0074 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0090 _CrtDbgReportW 00a0 _errno 00ac ??_C@_1BME@EGKCNELI@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00c4 _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 68 06 40 F9 7F 52 01 39 60 06 C1 39 09 01 40 F9 0B 1C 00 53 2A 01 40 F9 4B D9 6B 78 2B 05 78 36 ?? ?? ?? ?? 1F 04 00 31 81 00 00 54 08 00 80 12 68 2A 00 B9 04 00 00 14 68 2A 40 B9 09 05 00 11 69 2A 00 B9 69 0E 40 F9 28 15 C0 38 68 06 01 39 08 1D 00 13 69 0E 00 F9 48 03 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 22 D6 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 23 D6 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 02 00 00 14 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_293_0 {
	meta:
		name = "?state_case_normal_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_N_W@Z"
		size = 16
		altNames = "?state_case_normal_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_N_W@Z ?state_case_normal_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_N_W@Z"
	strings:
		$1 = { 28 00 80 52 08 50 01 39 20 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_296_0 {
	meta:
		name = "?state_case_percent@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 28
		altNames = "?state_case_percent@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ ?state_case_percent@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ ?state_case_percent@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ ?state_case_percent@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ ?state_case_percent@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
	strings:
		$1 = { 08 00 80 12 1F 7C 06 29 08 7C 07 29 1F 00 01 39 1F 50 01 39 20 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_302_0 {
	meta:
		name = "?state_case_precision@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 80
		refs = "0010 ?parse_int_from_format_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z"
	strings:
		$1 = { 08 04 C1 39 1F A9 00 71 60 00 00 54 01 E0 00 91 ?? ?? ?? ?? 0A 10 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F B8 09 00 80 12 08 38 00 B9 1F 01 00 71 08 38 40 B9 29 B1 88 1A 09 38 00 B9 20 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_304_0 {
	meta:
		name = "?state_case_precision@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 80
		refs = "0010 ?parse_int_from_format_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z"
	strings:
		$1 = { 08 04 C1 39 1F A9 00 71 60 00 00 54 01 E0 00 91 ?? ?? ?? ?? 0A 10 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F B8 09 00 80 12 08 38 00 B9 1F 01 00 71 08 38 40 B9 29 B1 88 1A 09 38 00 B9 20 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_303_0 {
	meta:
		name = "?state_case_precision@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 112
		refs = "0020 ?parse_int_from_format_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z 0028 ?update_precision@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 68 06 C1 39 1F A9 00 71 80 00 00 54 61 E2 00 91 ?? ?? ?? ?? 10 00 00 14 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 0C 00 00 14 68 7A 44 B9 1F 05 00 71 81 00 00 54 68 7E 44 B9 1F 05 00 71 A1 00 00 54 68 3A 40 B9 68 00 F8 36 08 00 80 12 68 3A 00 B9 20 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_305_0 {
	meta:
		name = "?state_case_precision@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 80
		refs = "0010 ?parse_int_from_format_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z"
	strings:
		$1 = { 08 84 40 79 1F A9 00 71 60 00 00 54 01 E0 00 91 ?? ?? ?? ?? 0A 10 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F B8 09 00 80 12 08 38 00 B9 1F 01 00 71 08 38 40 B9 29 B1 88 1A 09 38 00 B9 20 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_307_0 {
	meta:
		name = "?state_case_precision@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 80
		refs = "0010 ?parse_int_from_format_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z"
	strings:
		$1 = { 08 84 40 79 1F A9 00 71 60 00 00 54 01 E0 00 91 ?? ?? ?? ?? 0A 10 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F B8 09 00 80 12 08 38 00 B9 1F 01 00 71 08 38 40 B9 29 B1 88 1A 09 38 00 B9 20 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_306_0 {
	meta:
		name = "?state_case_precision@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 112
		refs = "0020 ?parse_int_from_format_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z 0028 ?update_precision@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 68 86 40 79 1F A9 00 71 80 00 00 54 61 E2 00 91 ?? ?? ?? ?? 10 00 00 14 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 0C 00 00 14 68 7A 44 B9 1F 05 00 71 81 00 00 54 68 7E 44 B9 1F 05 00 71 A1 00 00 54 68 3A 40 B9 68 00 F8 36 08 00 80 12 68 3A 00 B9 20 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_308_0 {
	meta:
		name = "?state_case_size@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 600
		refs = "0028 ?state_case_type@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0044 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FG@OBJBDPAC@?$AA?$CI?$AA?$CC?$AAN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0090 ??_C@_1BMG@OBMNJJOL@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00a0 _invalid_parameter 00b8 ??_C@_1EC@GJPNJDCN@?$AA_?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA_?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?3?$AA?3?$AAn?$AAo?$AAn?$AAe@"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 0A 04 C1 39 5F 19 01 71 E1 00 00 54 08 00 40 F9 08 11 18 37 E9 00 80 52 09 2C 00 B9 ?? ?? ?? ?? 85 00 00 14 5F 39 01 71 C1 03 00 54 08 00 40 F9 08 10 18 37 09 01 80 52 ?? ?? ?? ?? 09 2C 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 EA 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 C3 EA 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? 00 00 80 52 66 00 00 14 08 3C 40 B9 88 02 00 34 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 EB 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 A3 EB 80 52 ?? ?? ?? ?? E5 FF FF 17 5F A9 01 71 AC 06 00 54 5F A9 01 71 20 06 00 54 5F 25 01 71 80 02 00 54 5F 31 01 71 E0 01 00 54 5F 51 01 71 60 01 00 54 5F A1 01 71 81 08 00 54 09 0C 40 F9 28 01 C0 39 1F A1 01 71 61 00 00 54 2A 00 80 52 38 00 00 14 48 00 80 52 3B 00 00 14 A8 01 80 52 39 00 00 14 09 01 80 52 09 3C 00 B9 37 00 00 14 09 0C 40 F9 2A 01 C0 39 5F CD 00 71 E1 00 00 54 28 05 C0 39 1F C9 00 71 81 00 00 54 28 09 00 91 4A 01 80 52 28 00 00 14 5F D9 00 71 E1 00 00 54 28 05 C0 39 1F D1 00 71 81 00 00 54 28 09 00 91 6A 01 80 52 20 00 00 14 48 61 01 51 09 1D 00 53 3F 81 00 71 28 04 00 54 A9 04 00 58 28 25 C8 9A C8 03 00 36 29 01 80 52 E4 FF FF 17 A8 00 80 52 19 00 00 14 5F B1 01 71 A0 01 00 54 5F D1 01 71 20 01 00 54 5F DD 01 71 A0 00 00 54 5F E9 01 71 41 02 00 54 C8 00 80 52 0F 00 00 14 88 01 80 52 0D 00 00 14 E9 00 80 52 D4 FF FF 17 09 0C 40 F9 28 01 C0 39 1F B1 01 71 C1 00 00 54 8A 00 80 52 28 05 00 91 08 0C 00 F9 0A 3C 00 B9 03 00 00 14 68 00 80 52 08 3C 00 B9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 1F 20 03 D5 01 10 82 20 01 00 00 00 }
	condition:
		$1
}

rule file_35_309_0 {
	meta:
		name = "?state_case_size@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 600
		refs = "0028 ?state_case_type@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0044 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FG@OBJBDPAC@?$AA?$CI?$AA?$CC?$AAN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0090 ??_C@_1BMM@MDMPAJJB@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00a0 _invalid_parameter 00b8 ??_C@_1EC@GJPNJDCN@?$AA_?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA_?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?3?$AA?3?$AAn?$AAo?$AAn?$AAe@"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 0A 04 C1 39 5F 19 01 71 E1 00 00 54 08 00 40 F9 08 11 18 37 E9 00 80 52 09 2C 00 B9 ?? ?? ?? ?? 85 00 00 14 5F 39 01 71 C1 03 00 54 08 00 40 F9 08 10 18 37 09 01 80 52 ?? ?? ?? ?? 09 2C 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 EA 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 C3 EA 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? 00 00 80 52 66 00 00 14 08 3C 40 B9 88 02 00 34 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 EB 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 A3 EB 80 52 ?? ?? ?? ?? E5 FF FF 17 5F A9 01 71 AC 06 00 54 5F A9 01 71 20 06 00 54 5F 25 01 71 80 02 00 54 5F 31 01 71 E0 01 00 54 5F 51 01 71 60 01 00 54 5F A1 01 71 81 08 00 54 09 0C 40 F9 28 01 C0 39 1F A1 01 71 61 00 00 54 2A 00 80 52 38 00 00 14 48 00 80 52 3B 00 00 14 A8 01 80 52 39 00 00 14 09 01 80 52 09 3C 00 B9 37 00 00 14 09 0C 40 F9 2A 01 C0 39 5F CD 00 71 E1 00 00 54 28 05 C0 39 1F C9 00 71 81 00 00 54 28 09 00 91 4A 01 80 52 28 00 00 14 5F D9 00 71 E1 00 00 54 28 05 C0 39 1F D1 00 71 81 00 00 54 28 09 00 91 6A 01 80 52 20 00 00 14 48 61 01 51 09 1D 00 53 3F 81 00 71 28 04 00 54 A9 04 00 58 28 25 C8 9A C8 03 00 36 29 01 80 52 E4 FF FF 17 A8 00 80 52 19 00 00 14 5F B1 01 71 A0 01 00 54 5F D1 01 71 20 01 00 54 5F DD 01 71 A0 00 00 54 5F E9 01 71 41 02 00 54 C8 00 80 52 0F 00 00 14 88 01 80 52 0D 00 00 14 E9 00 80 52 D4 FF FF 17 09 0C 40 F9 28 01 C0 39 1F B1 01 71 C1 00 00 54 8A 00 80 52 28 05 00 91 08 0C 00 F9 0A 3C 00 B9 03 00 00 14 68 00 80 52 08 3C 00 B9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 1F 20 03 D5 01 10 82 20 01 00 00 00 }
	condition:
		$1
}

rule file_35_310_0 {
	meta:
		name = "?state_case_size@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 600
		refs = "0028 ?state_case_type@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0044 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FG@OBJBDPAC@?$AA?$CI?$AA?$CC?$AAN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0090 ??_C@_1BLE@FJAJINEM@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00a0 _invalid_parameter 00b8 ??_C@_1EC@GJPNJDCN@?$AA_?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA_?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?3?$AA?3?$AAn?$AAo?$AAn?$AAe@"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 0A 04 C1 39 5F 19 01 71 E1 00 00 54 08 00 40 F9 08 11 18 37 E9 00 80 52 09 2C 00 B9 ?? ?? ?? ?? 85 00 00 14 5F 39 01 71 C1 03 00 54 08 00 40 F9 08 10 18 37 09 01 80 52 ?? ?? ?? ?? 09 2C 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 EA 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 C3 EA 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? 00 00 80 52 66 00 00 14 08 3C 40 B9 88 02 00 34 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 EB 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 A3 EB 80 52 ?? ?? ?? ?? E5 FF FF 17 5F A9 01 71 AC 06 00 54 5F A9 01 71 20 06 00 54 5F 25 01 71 80 02 00 54 5F 31 01 71 E0 01 00 54 5F 51 01 71 60 01 00 54 5F A1 01 71 81 08 00 54 09 0C 40 F9 28 01 C0 39 1F A1 01 71 61 00 00 54 2A 00 80 52 38 00 00 14 48 00 80 52 3B 00 00 14 A8 01 80 52 39 00 00 14 09 01 80 52 09 3C 00 B9 37 00 00 14 09 0C 40 F9 2A 01 C0 39 5F CD 00 71 E1 00 00 54 28 05 C0 39 1F C9 00 71 81 00 00 54 28 09 00 91 4A 01 80 52 28 00 00 14 5F D9 00 71 E1 00 00 54 28 05 C0 39 1F D1 00 71 81 00 00 54 28 09 00 91 6A 01 80 52 20 00 00 14 48 61 01 51 09 1D 00 53 3F 81 00 71 28 04 00 54 A9 04 00 58 28 25 C8 9A C8 03 00 36 29 01 80 52 E4 FF FF 17 A8 00 80 52 19 00 00 14 5F B1 01 71 A0 01 00 54 5F D1 01 71 20 01 00 54 5F DD 01 71 A0 00 00 54 5F E9 01 71 41 02 00 54 C8 00 80 52 0F 00 00 14 88 01 80 52 0D 00 00 14 E9 00 80 52 D4 FF FF 17 09 0C 40 F9 28 01 C0 39 1F B1 01 71 C1 00 00 54 8A 00 80 52 28 05 00 91 08 0C 00 F9 0A 3C 00 B9 03 00 00 14 68 00 80 52 08 3C 00 B9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 1F 20 03 D5 01 10 82 20 01 00 00 00 }
	condition:
		$1
}

rule file_35_311_0 {
	meta:
		name = "?state_case_size@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 600
		refs = "0028 ?state_case_type@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0044 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FG@OBJBDPAC@?$AA?$CI?$AA?$CC?$AAN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0090 ??_C@_1BNO@MMJDJILD@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00a0 _invalid_parameter 00b8 ??_C@_1EC@GJPNJDCN@?$AA_?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA_?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?3?$AA?3?$AAn?$AAo?$AAn?$AAe@"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 0A 84 40 79 5F 19 01 71 E1 00 00 54 08 00 40 F9 28 11 18 37 E9 00 80 52 09 2C 00 B9 ?? ?? ?? ?? 86 00 00 14 5F 39 01 71 C1 03 00 54 08 00 40 F9 28 10 18 37 09 01 80 52 ?? ?? ?? ?? 09 2C 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 EA 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 C3 EA 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? 00 00 80 52 67 00 00 14 08 3C 40 B9 88 02 00 34 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 EB 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 A3 EB 80 52 ?? ?? ?? ?? E5 FF FF 17 5F A9 01 71 CC 06 00 54 5F A9 01 71 40 06 00 54 5F 25 01 71 80 02 00 54 5F 31 01 71 E0 01 00 54 5F 51 01 71 60 01 00 54 5F A1 01 71 A1 08 00 54 09 0C 40 F9 28 01 40 79 1F A1 01 71 61 00 00 54 2A 00 80 52 39 00 00 14 48 00 80 52 3C 00 00 14 A8 01 80 52 3A 00 00 14 09 01 80 52 09 3C 00 B9 38 00 00 14 09 0C 40 F9 2A 01 40 79 5F CD 00 71 E1 00 00 54 28 05 40 79 1F C9 00 71 81 00 00 54 28 11 00 91 4A 01 80 52 29 00 00 14 5F D9 00 71 E1 00 00 54 28 05 40 79 1F D1 00 71 81 00 00 54 28 11 00 91 6A 01 80 52 21 00 00 14 08 F5 9F 52 48 01 08 0B 09 3D 00 53 3F 81 00 71 28 04 00 54 88 04 00 58 08 25 C9 9A C8 03 00 36 29 01 80 52 E3 FF FF 17 A8 00 80 52 19 00 00 14 5F B1 01 71 A0 01 00 54 5F D1 01 71 20 01 00 54 5F DD 01 71 A0 00 00 54 5F E9 01 71 41 02 00 54 C8 00 80 52 0F 00 00 14 88 01 80 52 0D 00 00 14 E9 00 80 52 D3 FF FF 17 09 0C 40 F9 28 01 40 79 1F B1 01 71 C1 00 00 54 8A 00 80 52 28 09 00 91 08 0C 00 F9 0A 3C 00 B9 03 00 00 14 68 00 80 52 08 3C 00 B9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 01 10 82 20 01 00 00 00 }
	condition:
		$1
}

rule file_35_312_0 {
	meta:
		name = "?state_case_size@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 600
		refs = "0028 ?state_case_type@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0044 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FG@OBJBDPAC@?$AA?$CI?$AA?$CC?$AAN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0090 ??_C@_1BOE@BBNBBNLC@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00a0 _invalid_parameter 00b8 ??_C@_1EC@GJPNJDCN@?$AA_?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA_?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?3?$AA?3?$AAn?$AAo?$AAn?$AAe@"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 0A 84 40 79 5F 19 01 71 E1 00 00 54 08 00 40 F9 28 11 18 37 E9 00 80 52 09 2C 00 B9 ?? ?? ?? ?? 86 00 00 14 5F 39 01 71 C1 03 00 54 08 00 40 F9 28 10 18 37 09 01 80 52 ?? ?? ?? ?? 09 2C 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 EA 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 C3 EA 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? 00 00 80 52 67 00 00 14 08 3C 40 B9 88 02 00 34 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 EB 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 A3 EB 80 52 ?? ?? ?? ?? E5 FF FF 17 5F A9 01 71 CC 06 00 54 5F A9 01 71 40 06 00 54 5F 25 01 71 80 02 00 54 5F 31 01 71 E0 01 00 54 5F 51 01 71 60 01 00 54 5F A1 01 71 A1 08 00 54 09 0C 40 F9 28 01 40 79 1F A1 01 71 61 00 00 54 2A 00 80 52 39 00 00 14 48 00 80 52 3C 00 00 14 A8 01 80 52 3A 00 00 14 09 01 80 52 09 3C 00 B9 38 00 00 14 09 0C 40 F9 2A 01 40 79 5F CD 00 71 E1 00 00 54 28 05 40 79 1F C9 00 71 81 00 00 54 28 11 00 91 4A 01 80 52 29 00 00 14 5F D9 00 71 E1 00 00 54 28 05 40 79 1F D1 00 71 81 00 00 54 28 11 00 91 6A 01 80 52 21 00 00 14 08 F5 9F 52 48 01 08 0B 09 3D 00 53 3F 81 00 71 28 04 00 54 88 04 00 58 08 25 C9 9A C8 03 00 36 29 01 80 52 E3 FF FF 17 A8 00 80 52 19 00 00 14 5F B1 01 71 A0 01 00 54 5F D1 01 71 20 01 00 54 5F DD 01 71 A0 00 00 54 5F E9 01 71 41 02 00 54 C8 00 80 52 0F 00 00 14 88 01 80 52 0D 00 00 14 E9 00 80 52 D3 FF FF 17 09 0C 40 F9 28 01 40 79 1F B1 01 71 C1 00 00 54 8A 00 80 52 28 09 00 91 08 0C 00 F9 0A 3C 00 B9 03 00 00 14 68 00 80 52 08 3C 00 B9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 01 10 82 20 01 00 00 00 }
	condition:
		$1
}

rule file_35_313_0 {
	meta:
		name = "?state_case_size@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 600
		refs = "0028 ?state_case_type@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0044 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1FG@OBJBDPAC@?$AA?$CI?$AA?$CC?$AAN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0090 ??_C@_1BMM@GFJMEAMM@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00a0 _invalid_parameter 00b8 ??_C@_1EC@GJPNJDCN@?$AA_?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA_?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?3?$AA?3?$AAn?$AAo?$AAn?$AAe@"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 0A 84 40 79 5F 19 01 71 E1 00 00 54 08 00 40 F9 28 11 18 37 E9 00 80 52 09 2C 00 B9 ?? ?? ?? ?? 86 00 00 14 5F 39 01 71 C1 03 00 54 08 00 40 F9 28 10 18 37 09 01 80 52 ?? ?? ?? ?? 09 2C 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 EA 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 C3 EA 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? 00 00 80 52 67 00 00 14 08 3C 40 B9 88 02 00 34 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 EB 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 A3 EB 80 52 ?? ?? ?? ?? E5 FF FF 17 5F A9 01 71 CC 06 00 54 5F A9 01 71 40 06 00 54 5F 25 01 71 80 02 00 54 5F 31 01 71 E0 01 00 54 5F 51 01 71 60 01 00 54 5F A1 01 71 A1 08 00 54 09 0C 40 F9 28 01 40 79 1F A1 01 71 61 00 00 54 2A 00 80 52 39 00 00 14 48 00 80 52 3C 00 00 14 A8 01 80 52 3A 00 00 14 09 01 80 52 09 3C 00 B9 38 00 00 14 09 0C 40 F9 2A 01 40 79 5F CD 00 71 E1 00 00 54 28 05 40 79 1F C9 00 71 81 00 00 54 28 11 00 91 4A 01 80 52 29 00 00 14 5F D9 00 71 E1 00 00 54 28 05 40 79 1F D1 00 71 81 00 00 54 28 11 00 91 6A 01 80 52 21 00 00 14 08 F5 9F 52 48 01 08 0B 09 3D 00 53 3F 81 00 71 28 04 00 54 88 04 00 58 08 25 C9 9A C8 03 00 36 29 01 80 52 E3 FF FF 17 A8 00 80 52 19 00 00 14 5F B1 01 71 A0 01 00 54 5F D1 01 71 20 01 00 54 5F DD 01 71 A0 00 00 54 5F E9 01 71 41 02 00 54 C8 00 80 52 0F 00 00 14 88 01 80 52 0D 00 00 14 E9 00 80 52 D3 FF FF 17 09 0C 40 F9 28 01 40 79 1F B1 01 71 C1 00 00 54 8A 00 80 52 28 09 00 91 08 0C 00 F9 0A 3C 00 B9 03 00 00 14 68 00 80 52 08 3C 00 B9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 01 10 82 20 01 00 00 00 }
	condition:
		$1
}

rule file_35_314_0 {
	meta:
		name = "?state_case_type@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 712
		refs = "00ac ?type_case_c_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z 00b8 ?type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 00c4 ?type_case_s@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 00d0 ?type_case_a@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 00f0 ?type_case_integer@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z 0138 ?type_case_n@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0244 ??$write_multiple_characters@V?$console_output_adapter@D@__crt_stdio_output@@D@__crt_stdio_output@@YAXAEBV?$console_output_adapter@D@0@DHQEAH@Z 025c ?write_string@?$console_output_adapter@D@__crt_stdio_output@@QEBAXQEBDHQEAHAEAV__crt_deferred_errno_cache@@@Z 0288 ?write_stored_string_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BE A9 FD 03 00 91 13 00 00 91 68 06 C1 39 0A 05 01 51 5F DD 00 71 A8 14 00 54 89 00 00 10 28 59 AA 78 28 09 08 8B 00 01 1F D6 26 00 A0 00 1C 00 A0 00 26 00 26 00 26 00 A0 00 A0 00 A0 00 A0 00 A0 00 A0 00 A0 00 A0 00 A0 00 A0 00 A0 00 23 00 A0 00 A0 00 A0 00 A0 00 37 00 A0 00 20 00 A0 00 A0 00 A0 00 A0 00 A0 00 A0 00 26 00 A0 00 1C 00 29 00 26 00 26 00 26 00 A0 00 29 00 A0 00 A0 00 A0 00 A0 00 40 00 31 00 3C 00 A0 00 A0 00 23 00 A0 00 2C 00 A0 00 A0 00 3A 00 01 00 80 52 60 02 00 91 ?? ?? ?? ?? 23 00 00 14 60 02 00 91 ?? ?? ?? ?? 20 00 00 14 60 02 00 91 ?? ?? ?? ?? 1D 00 00 14 60 02 00 91 ?? ?? ?? ?? 1A 00 00 14 68 32 40 B9 09 01 1C 32 69 32 00 B9 41 01 80 52 02 00 80 52 60 02 00 91 ?? ?? ?? ?? 12 00 00 14 69 32 40 B9 69 00 28 36 28 01 19 32 68 32 00 B9 01 01 80 52 F7 FF FF 17 22 00 80 52 01 02 80 52 F5 FF FF 17 02 00 80 52 FD FF FF 17 09 02 80 52 68 01 80 52 69 22 07 29 F8 FF FF 17 60 02 00 91 ?? ?? ?? ?? 08 00 00 11 A8 0B 00 34 68 02 41 39 68 00 00 34 20 00 80 52 5A 00 00 14 E8 43 00 91 6C 32 40 B9 1F 01 00 79 0B 00 80 D2 1F 09 00 39 6C 01 20 36 6C 00 30 36 A8 05 80 52 06 00 00 14 6C 00 00 36 68 05 80 52 03 00 00 14 8C 00 08 36 08 04 80 52 E8 43 00 39 2B 00 80 D2 6D 06 C1 39 EA 1B 80 52 A8 1D 00 53 09 61 01 51 29 01 0A 0A 89 00 00 35 6C 00 28 36 2E 00 80 52 02 00 00 14 0E 00 80 52 A8 1D 00 53 09 05 01 51 EA 1B 80 52 2A 01 0A 0A 4E 00 00 35 4A 02 00 35 E9 43 00 91 08 06 80 52 68 69 29 38 BF 61 01 71 69 05 00 91 80 00 00 54 BF 05 01 71 08 00 80 52 41 00 00 54 28 00 80 52 0B 0B 80 52 1F 01 00 71 0A 0F 80 52 68 11 8A 1A EB 43 00 91 28 69 2B 38 2B 05 00 91 68 52 40 B9 75 01 00 11 69 36 40 B9 29 01 08 4B 34 01 15 4B 88 05 1E 12 C8 00 00 35 63 A2 00 91 82 02 00 11 01 04 80 52 60 A2 11 91 ?? ?? ?? ?? 64 42 00 91 63 A2 00 91 A2 02 00 11 E1 43 00 91 60 A2 11 91 ?? ?? ?? ?? 68 32 40 B9 E8 00 18 36 C8 00 10 37 63 A2 00 91 82 02 00 11 01 06 80 52 60 A2 11 91 ?? ?? ?? ?? 01 00 80 52 60 02 00 91 ?? ?? ?? ?? 68 2A 40 B9 E8 F5 FF 37 68 32 40 B9 A8 F5 17 36 63 A2 00 91 82 02 00 11 01 04 80 52 60 A2 11 91 ?? ?? ?? ?? A7 FF FF 17 00 00 80 52 FD 7B C2 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_316_0 {
	meta:
		name = "?state_case_type@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 712
		refs = "00ac ?type_case_c_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z 00b8 ?type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 00c4 ?type_case_s@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 00d0 ?type_case_a@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 00f0 ?type_case_integer@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z 0138 ?type_case_n@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0244 ??$write_multiple_characters@V?$console_output_adapter@D@__crt_stdio_output@@D@__crt_stdio_output@@YAXAEBV?$console_output_adapter@D@0@DHQEAH@Z 025c ?write_string@?$console_output_adapter@D@__crt_stdio_output@@QEBAXQEBDHQEAHAEAV__crt_deferred_errno_cache@@@Z 0288 ?write_stored_string_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BE A9 FD 03 00 91 13 00 00 91 68 06 C1 39 0A 05 01 51 5F DD 00 71 A8 14 00 54 89 00 00 10 28 59 AA 78 28 09 08 8B 00 01 1F D6 26 00 A0 00 1C 00 A0 00 26 00 26 00 26 00 A0 00 A0 00 A0 00 A0 00 A0 00 A0 00 A0 00 A0 00 A0 00 A0 00 A0 00 23 00 A0 00 A0 00 A0 00 A0 00 37 00 A0 00 20 00 A0 00 A0 00 A0 00 A0 00 A0 00 A0 00 26 00 A0 00 1C 00 29 00 26 00 26 00 26 00 A0 00 29 00 A0 00 A0 00 A0 00 A0 00 40 00 31 00 3C 00 A0 00 A0 00 23 00 A0 00 2C 00 A0 00 A0 00 3A 00 01 00 80 52 60 02 00 91 ?? ?? ?? ?? 23 00 00 14 60 02 00 91 ?? ?? ?? ?? 20 00 00 14 60 02 00 91 ?? ?? ?? ?? 1D 00 00 14 60 02 00 91 ?? ?? ?? ?? 1A 00 00 14 68 32 40 B9 09 01 1C 32 69 32 00 B9 41 01 80 52 02 00 80 52 60 02 00 91 ?? ?? ?? ?? 12 00 00 14 69 32 40 B9 69 00 28 36 28 01 19 32 68 32 00 B9 01 01 80 52 F7 FF FF 17 22 00 80 52 01 02 80 52 F5 FF FF 17 02 00 80 52 FD FF FF 17 09 02 80 52 68 01 80 52 69 22 07 29 F8 FF FF 17 60 02 00 91 ?? ?? ?? ?? 08 00 00 11 A8 0B 00 34 68 02 41 39 68 00 00 34 20 00 80 52 5A 00 00 14 E8 43 00 91 6C 32 40 B9 1F 01 00 79 0B 00 80 D2 1F 09 00 39 6C 01 20 36 6C 00 30 36 A8 05 80 52 06 00 00 14 6C 00 00 36 68 05 80 52 03 00 00 14 8C 00 08 36 08 04 80 52 E8 43 00 39 2B 00 80 D2 6D 06 C1 39 EA 1B 80 52 A8 1D 00 53 09 61 01 51 29 01 0A 0A 89 00 00 35 6C 00 28 36 2E 00 80 52 02 00 00 14 0E 00 80 52 A8 1D 00 53 09 05 01 51 EA 1B 80 52 2A 01 0A 0A 4E 00 00 35 4A 02 00 35 E9 43 00 91 08 06 80 52 68 69 29 38 BF 61 01 71 69 05 00 91 80 00 00 54 BF 05 01 71 08 00 80 52 41 00 00 54 28 00 80 52 0B 0B 80 52 1F 01 00 71 0A 0F 80 52 68 11 8A 1A EB 43 00 91 28 69 2B 38 2B 05 00 91 68 52 40 B9 75 01 00 11 69 36 40 B9 29 01 08 4B 34 01 15 4B 88 05 1E 12 C8 00 00 35 63 A2 00 91 82 02 00 11 01 04 80 52 60 A2 11 91 ?? ?? ?? ?? 64 42 00 91 63 A2 00 91 A2 02 00 11 E1 43 00 91 60 A2 11 91 ?? ?? ?? ?? 68 32 40 B9 E8 00 18 36 C8 00 10 37 63 A2 00 91 82 02 00 11 01 06 80 52 60 A2 11 91 ?? ?? ?? ?? 01 00 80 52 60 02 00 91 ?? ?? ?? ?? 68 2A 40 B9 E8 F5 FF 37 68 32 40 B9 A8 F5 17 36 63 A2 00 91 82 02 00 11 01 04 80 52 60 A2 11 91 ?? ?? ?? ?? A7 FF FF 17 00 00 80 52 FD 7B C2 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_315_0 {
	meta:
		name = "?state_case_type@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 736
		refs = "00ac ?type_case_c_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z 00b8 ?type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 00c4 ?type_case_s@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 00d0 ?type_case_a@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 00f0 ?type_case_integer@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z 0138 ?type_case_n@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 025c ??$write_multiple_characters@V?$console_output_adapter@D@__crt_stdio_output@@D@__crt_stdio_output@@YAXAEBV?$console_output_adapter@D@0@DHQEAH@Z 0274 ?write_string@?$console_output_adapter@D@__crt_stdio_output@@QEBAXQEBDHQEAHAEAV__crt_deferred_errno_cache@@@Z 02a0 ?write_stored_string_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BE A9 FD 03 00 91 13 00 00 91 68 06 C1 39 0A 05 01 51 5F DD 00 71 68 15 00 54 89 00 00 10 28 59 AA 78 28 09 08 8B 00 01 1F D6 26 00 A6 00 1C 00 A6 00 26 00 26 00 26 00 A6 00 A6 00 A6 00 A6 00 A6 00 A6 00 A6 00 A6 00 A6 00 A6 00 A6 00 23 00 A6 00 A6 00 A6 00 A6 00 37 00 A6 00 20 00 A6 00 A6 00 A6 00 A6 00 A6 00 A6 00 26 00 A6 00 1C 00 29 00 26 00 26 00 26 00 A6 00 29 00 A6 00 A6 00 A6 00 A6 00 40 00 31 00 3C 00 A6 00 A6 00 23 00 A6 00 2C 00 A6 00 A6 00 3A 00 01 00 80 52 60 02 00 91 ?? ?? ?? ?? 23 00 00 14 60 02 00 91 ?? ?? ?? ?? 20 00 00 14 60 02 00 91 ?? ?? ?? ?? 1D 00 00 14 60 02 00 91 ?? ?? ?? ?? 1A 00 00 14 68 32 40 B9 09 01 1C 32 69 32 00 B9 41 01 80 52 02 00 80 52 60 02 00 91 ?? ?? ?? ?? 12 00 00 14 69 32 40 B9 69 00 28 36 28 01 19 32 68 32 00 B9 01 01 80 52 F7 FF FF 17 22 00 80 52 01 02 80 52 F5 FF FF 17 02 00 80 52 FD FF FF 17 09 02 80 52 68 01 80 52 69 22 07 29 F8 FF FF 17 60 02 00 91 ?? ?? ?? ?? 08 00 00 11 68 0C 00 34 68 7E 44 B9 1F 09 00 71 C1 00 00 54 68 7A 44 B9 1F 05 00 71 61 00 00 54 20 00 80 52 5C 00 00 14 68 02 41 39 A8 FF FF 35 E8 43 00 91 6C 32 40 B9 1F 01 00 79 0B 00 80 D2 1F 09 00 39 6C 01 20 36 6C 00 30 36 A8 05 80 52 06 00 00 14 6C 00 00 36 68 05 80 52 03 00 00 14 8C 00 08 36 08 04 80 52 E8 43 00 39 2B 00 80 D2 6D 06 C1 39 EA 1B 80 52 A8 1D 00 53 09 61 01 51 29 01 0A 0A 89 00 00 35 6C 00 28 36 2E 00 80 52 02 00 00 14 0E 00 80 52 A8 1D 00 53 09 05 01 51 EA 1B 80 52 2A 01 0A 0A 4E 00 00 35 4A 02 00 35 E9 43 00 91 08 06 80 52 68 69 29 38 BF 61 01 71 69 05 00 91 80 00 00 54 BF 05 01 71 08 00 80 52 41 00 00 54 28 00 80 52 0B 0B 80 52 1F 01 00 71 0A 0F 80 52 68 11 8A 1A EB 43 00 91 28 69 2B 38 2B 05 00 91 68 52 40 B9 75 01 00 11 69 36 40 B9 29 01 08 4B 34 01 15 4B 88 05 1E 12 C8 00 00 35 63 A2 00 91 82 02 00 11 01 04 80 52 60 A2 11 91 ?? ?? ?? ?? 64 42 00 91 63 A2 00 91 A2 02 00 11 E1 43 00 91 60 A2 11 91 ?? ?? ?? ?? 68 32 40 B9 E8 00 18 36 C8 00 10 37 63 A2 00 91 82 02 00 11 01 06 80 52 60 A2 11 91 ?? ?? ?? ?? 01 00 80 52 60 02 00 91 ?? ?? ?? ?? 68 2A 40 B9 A8 F5 FF 37 68 32 40 B9 68 F5 17 36 63 A2 00 91 82 02 00 11 01 04 80 52 60 A2 11 91 ?? ?? ?? ?? A5 FF FF 17 00 00 80 52 FD 7B C2 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_317_0 {
	meta:
		name = "?state_case_type@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 712
		refs = "0010 __security_push_cookie 00b0 ?type_case_c_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_N_W@Z 00bc ?type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 00c8 ?type_case_s@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 00d4 ?type_case_a@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 00f4 ?type_case_integer@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z 013c ?type_case_n@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0240 ??$write_multiple_characters@V?$console_output_adapter@_W@__crt_stdio_output@@D@__crt_stdio_output@@YAXAEBV?$console_output_adapter@_W@0@DHQEAH@Z 0258 ?write_string@?$console_output_adapter@_W@__crt_stdio_output@@QEBAXQEB_WHQEAHAEAV__crt_deferred_errno_cache@@@Z 0284 ?write_stored_string_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_N_W@Z 02b4 __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 13 00 F9 FD 03 00 91 ?? ?? ?? ?? 13 00 00 91 68 86 40 79 0A 05 01 51 5F DD 00 71 68 14 00 54 89 00 00 10 28 59 AA 78 28 09 08 8B 00 01 1F D6 26 00 9E 00 1C 00 9E 00 26 00 26 00 26 00 9E 00 9E 00 9E 00 9E 00 9E 00 9E 00 9E 00 9E 00 9E 00 9E 00 9E 00 23 00 9E 00 9E 00 9E 00 9E 00 37 00 9E 00 20 00 9E 00 9E 00 9E 00 9E 00 9E 00 9E 00 26 00 9E 00 1C 00 29 00 26 00 26 00 26 00 9E 00 29 00 9E 00 9E 00 9E 00 9E 00 40 00 31 00 3C 00 9E 00 9E 00 23 00 9E 00 2C 00 9E 00 9E 00 3A 00 01 00 80 52 60 02 00 91 ?? ?? ?? ?? 23 00 00 14 60 02 00 91 ?? ?? ?? ?? 20 00 00 14 60 02 00 91 ?? ?? ?? ?? 1D 00 00 14 60 02 00 91 ?? ?? ?? ?? 1A 00 00 14 68 32 40 B9 09 01 1C 32 69 32 00 B9 41 01 80 52 02 00 80 52 60 02 00 91 ?? ?? ?? ?? 12 00 00 14 69 32 40 B9 69 00 28 36 28 01 19 32 68 32 00 B9 01 01 80 52 F7 FF FF 17 22 00 80 52 01 02 80 52 F5 FF FF 17 02 00 80 52 FD FF FF 17 09 02 80 52 68 01 80 52 69 22 07 29 F8 FF FF 17 60 02 00 91 ?? ?? ?? ?? 08 00 00 11 68 0B 00 34 68 02 41 39 68 00 00 34 20 00 80 52 58 00 00 14 E8 03 00 91 6B 32 40 B9 1F 01 00 B9 0A 00 80 D2 1F 09 00 79 6B 01 20 36 6B 00 30 36 A8 05 80 52 06 00 00 14 6B 00 00 36 68 05 80 52 03 00 00 14 8B 00 08 36 08 04 80 52 E8 03 00 79 2A 00 80 D2 6C 86 40 79 E9 FB 9F 52 88 61 01 51 08 01 09 0A 88 00 00 35 6B 00 28 36 2D 00 80 52 02 00 00 14 0D 00 80 52 88 05 01 51 E9 FB 9F 52 09 01 09 0A 4D 00 00 35 49 02 00 35 E9 03 00 91 08 06 80 52 28 79 2A 78 9F 61 01 71 49 05 00 91 80 00 00 54 9F 05 01 71 08 00 80 52 41 00 00 54 28 00 80 52 0C 0B 80 52 0A 0F 80 52 1F 01 00 71 88 11 8A 1A EC 03 00 91 88 79 29 78 2A 05 00 91 68 52 40 B9 55 01 00 11 69 36 40 B9 29 01 08 4B 34 01 15 4B 68 05 1E 12 C8 00 00 35 63 A2 00 91 82 02 00 11 01 04 80 52 60 A2 11 91 ?? ?? ?? ?? 64 42 00 91 63 A2 00 91 A2 02 00 11 E1 03 00 91 60 A2 11 91 ?? ?? ?? ?? 68 32 40 B9 E8 00 18 36 C8 00 10 37 63 A2 00 91 82 02 00 11 01 06 80 52 60 A2 11 91 ?? ?? ?? ?? 01 00 80 52 60 02 00 91 ?? ?? ?? ?? 68 2A 40 B9 28 F6 FF 37 68 32 40 B9 E8 F5 17 36 63 A2 00 91 82 02 00 11 01 04 80 52 60 A2 11 91 ?? ?? ?? ?? A9 FF FF 17 00 00 80 52 ?? ?? ?? ?? F5 13 40 F9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_319_0 {
	meta:
		name = "?state_case_type@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 712
		refs = "0010 __security_push_cookie 00b0 ?type_case_c_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_N_W@Z 00bc ?type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 00c8 ?type_case_s@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 00d4 ?type_case_a@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 00f4 ?type_case_integer@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z 013c ?type_case_n@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0240 ??$write_multiple_characters@V?$console_output_adapter@_W@__crt_stdio_output@@D@__crt_stdio_output@@YAXAEBV?$console_output_adapter@_W@0@DHQEAH@Z 0258 ?write_string@?$console_output_adapter@_W@__crt_stdio_output@@QEBAXQEB_WHQEAHAEAV__crt_deferred_errno_cache@@@Z 0284 ?write_stored_string_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_N_W@Z 02b4 __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 13 00 F9 FD 03 00 91 ?? ?? ?? ?? 13 00 00 91 68 86 40 79 0A 05 01 51 5F DD 00 71 68 14 00 54 89 00 00 10 28 59 AA 78 28 09 08 8B 00 01 1F D6 26 00 9E 00 1C 00 9E 00 26 00 26 00 26 00 9E 00 9E 00 9E 00 9E 00 9E 00 9E 00 9E 00 9E 00 9E 00 9E 00 9E 00 23 00 9E 00 9E 00 9E 00 9E 00 37 00 9E 00 20 00 9E 00 9E 00 9E 00 9E 00 9E 00 9E 00 26 00 9E 00 1C 00 29 00 26 00 26 00 26 00 9E 00 29 00 9E 00 9E 00 9E 00 9E 00 40 00 31 00 3C 00 9E 00 9E 00 23 00 9E 00 2C 00 9E 00 9E 00 3A 00 01 00 80 52 60 02 00 91 ?? ?? ?? ?? 23 00 00 14 60 02 00 91 ?? ?? ?? ?? 20 00 00 14 60 02 00 91 ?? ?? ?? ?? 1D 00 00 14 60 02 00 91 ?? ?? ?? ?? 1A 00 00 14 68 32 40 B9 09 01 1C 32 69 32 00 B9 41 01 80 52 02 00 80 52 60 02 00 91 ?? ?? ?? ?? 12 00 00 14 69 32 40 B9 69 00 28 36 28 01 19 32 68 32 00 B9 01 01 80 52 F7 FF FF 17 22 00 80 52 01 02 80 52 F5 FF FF 17 02 00 80 52 FD FF FF 17 09 02 80 52 68 01 80 52 69 22 07 29 F8 FF FF 17 60 02 00 91 ?? ?? ?? ?? 08 00 00 11 68 0B 00 34 68 02 41 39 68 00 00 34 20 00 80 52 58 00 00 14 E8 03 00 91 6B 32 40 B9 1F 01 00 B9 0A 00 80 D2 1F 09 00 79 6B 01 20 36 6B 00 30 36 A8 05 80 52 06 00 00 14 6B 00 00 36 68 05 80 52 03 00 00 14 8B 00 08 36 08 04 80 52 E8 03 00 79 2A 00 80 D2 6C 86 40 79 E9 FB 9F 52 88 61 01 51 08 01 09 0A 88 00 00 35 6B 00 28 36 2D 00 80 52 02 00 00 14 0D 00 80 52 88 05 01 51 E9 FB 9F 52 09 01 09 0A 4D 00 00 35 49 02 00 35 E9 03 00 91 08 06 80 52 28 79 2A 78 9F 61 01 71 49 05 00 91 80 00 00 54 9F 05 01 71 08 00 80 52 41 00 00 54 28 00 80 52 0C 0B 80 52 0A 0F 80 52 1F 01 00 71 88 11 8A 1A EC 03 00 91 88 79 29 78 2A 05 00 91 68 52 40 B9 55 01 00 11 69 36 40 B9 29 01 08 4B 34 01 15 4B 68 05 1E 12 C8 00 00 35 63 A2 00 91 82 02 00 11 01 04 80 52 60 A2 11 91 ?? ?? ?? ?? 64 42 00 91 63 A2 00 91 A2 02 00 11 E1 03 00 91 60 A2 11 91 ?? ?? ?? ?? 68 32 40 B9 E8 00 18 36 C8 00 10 37 63 A2 00 91 82 02 00 11 01 06 80 52 60 A2 11 91 ?? ?? ?? ?? 01 00 80 52 60 02 00 91 ?? ?? ?? ?? 68 2A 40 B9 28 F6 FF 37 68 32 40 B9 E8 F5 17 36 63 A2 00 91 82 02 00 11 01 04 80 52 60 A2 11 91 ?? ?? ?? ?? A9 FF FF 17 00 00 80 52 ?? ?? ?? ?? F5 13 40 F9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_318_0 {
	meta:
		name = "?state_case_type@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 736
		refs = "0010 __security_push_cookie 00b0 ?type_case_c_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_N_W@Z 00bc ?type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 00c8 ?type_case_s@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 00d4 ?type_case_a@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 00f4 ?type_case_integer@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z 013c ?type_case_n@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0258 ??$write_multiple_characters@V?$console_output_adapter@_W@__crt_stdio_output@@D@__crt_stdio_output@@YAXAEBV?$console_output_adapter@_W@0@DHQEAH@Z 0270 ?write_string@?$console_output_adapter@_W@__crt_stdio_output@@QEBAXQEB_WHQEAHAEAV__crt_deferred_errno_cache@@@Z 029c ?write_stored_string_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_N_W@Z 02cc __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 13 00 F9 FD 03 00 91 ?? ?? ?? ?? 13 00 00 91 68 86 40 79 0A 05 01 51 5F DD 00 71 28 15 00 54 89 00 00 10 28 59 AA 78 28 09 08 8B 00 01 1F D6 26 00 A4 00 1C 00 A4 00 26 00 26 00 26 00 A4 00 A4 00 A4 00 A4 00 A4 00 A4 00 A4 00 A4 00 A4 00 A4 00 A4 00 23 00 A4 00 A4 00 A4 00 A4 00 37 00 A4 00 20 00 A4 00 A4 00 A4 00 A4 00 A4 00 A4 00 26 00 A4 00 1C 00 29 00 26 00 26 00 26 00 A4 00 29 00 A4 00 A4 00 A4 00 A4 00 40 00 31 00 3C 00 A4 00 A4 00 23 00 A4 00 2C 00 A4 00 A4 00 3A 00 01 00 80 52 60 02 00 91 ?? ?? ?? ?? 23 00 00 14 60 02 00 91 ?? ?? ?? ?? 20 00 00 14 60 02 00 91 ?? ?? ?? ?? 1D 00 00 14 60 02 00 91 ?? ?? ?? ?? 1A 00 00 14 68 32 40 B9 09 01 1C 32 69 32 00 B9 41 01 80 52 02 00 80 52 60 02 00 91 ?? ?? ?? ?? 12 00 00 14 69 32 40 B9 69 00 28 36 28 01 19 32 68 32 00 B9 01 01 80 52 F7 FF FF 17 22 00 80 52 01 02 80 52 F5 FF FF 17 02 00 80 52 FD FF FF 17 09 02 80 52 68 01 80 52 69 22 07 29 F8 FF FF 17 60 02 00 91 ?? ?? ?? ?? 08 00 00 11 28 0C 00 34 68 7E 44 B9 1F 09 00 71 C1 00 00 54 68 7A 44 B9 1F 05 00 71 61 00 00 54 20 00 80 52 5A 00 00 14 68 02 41 39 A8 FF FF 35 E8 03 00 91 6B 32 40 B9 1F 01 00 B9 0A 00 80 D2 1F 09 00 79 6B 01 20 36 6B 00 30 36 A8 05 80 52 06 00 00 14 6B 00 00 36 68 05 80 52 03 00 00 14 8B 00 08 36 08 04 80 52 E8 03 00 79 2A 00 80 D2 6C 86 40 79 E9 FB 9F 52 88 61 01 51 08 01 09 0A 88 00 00 35 6B 00 28 36 2D 00 80 52 02 00 00 14 0D 00 80 52 88 05 01 51 E9 FB 9F 52 09 01 09 0A 4D 00 00 35 49 02 00 35 E9 03 00 91 08 06 80 52 28 79 2A 78 9F 61 01 71 49 05 00 91 80 00 00 54 9F 05 01 71 08 00 80 52 41 00 00 54 28 00 80 52 0C 0B 80 52 0A 0F 80 52 1F 01 00 71 88 11 8A 1A EC 03 00 91 88 79 29 78 2A 05 00 91 68 52 40 B9 55 01 00 11 69 36 40 B9 29 01 08 4B 34 01 15 4B 68 05 1E 12 C8 00 00 35 63 A2 00 91 82 02 00 11 01 04 80 52 60 A2 11 91 ?? ?? ?? ?? 64 42 00 91 63 A2 00 91 A2 02 00 11 E1 03 00 91 60 A2 11 91 ?? ?? ?? ?? 68 32 40 B9 E8 00 18 36 C8 00 10 37 63 A2 00 91 82 02 00 11 01 06 80 52 60 A2 11 91 ?? ?? ?? ?? 01 00 80 52 60 02 00 91 ?? ?? ?? ?? 68 2A 40 B9 E8 F5 FF 37 68 32 40 B9 A8 F5 17 36 63 A2 00 91 82 02 00 11 01 04 80 52 60 A2 11 91 ?? ?? ?? ?? A7 FF FF 17 00 00 80 52 ?? ?? ?? ?? F5 13 40 F9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_320_0 {
	meta:
		name = "?state_case_width@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 80
		refs = "0010 ?parse_int_from_format_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z"
	strings:
		$1 = { 08 04 C1 39 1F A9 00 71 60 00 00 54 01 D0 00 91 ?? ?? ?? ?? 0A 10 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F B8 08 34 00 B9 A8 00 F8 36 08 28 46 29 09 01 1E 32 E8 03 0A 4B 09 20 06 29 20 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_322_0 {
	meta:
		name = "?state_case_width@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 80
		refs = "0010 ?parse_int_from_format_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z"
	strings:
		$1 = { 08 04 C1 39 1F A9 00 71 60 00 00 54 01 D0 00 91 ?? ?? ?? ?? 0A 10 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F B8 08 34 00 B9 A8 00 F8 36 08 28 46 29 09 01 1E 32 E8 03 0A 4B 09 20 06 29 20 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_321_0 {
	meta:
		name = "?state_case_width@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 124
		refs = "0020 ?parse_int_from_format_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z 0028 ?update_field_width@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 68 06 C1 39 1F A9 00 71 80 00 00 54 61 D2 00 91 ?? ?? ?? ?? 13 00 00 14 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 0F 00 00 14 68 7A 44 B9 1F 05 00 71 81 00 00 54 68 7E 44 B9 1F 05 00 71 01 01 00 54 6A 36 40 B9 CA 00 F8 36 68 32 40 B9 EA 03 0A 4B 6A 36 00 B9 09 01 1E 32 69 32 00 B9 20 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_323_0 {
	meta:
		name = "?state_case_width@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 80
		refs = "0010 ?parse_int_from_format_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z"
	strings:
		$1 = { 08 84 40 79 1F A9 00 71 60 00 00 54 01 D0 00 91 ?? ?? ?? ?? 0A 10 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F B8 08 34 00 B9 A8 00 F8 36 08 28 46 29 09 01 1E 32 E8 03 0A 4B 09 20 06 29 20 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_325_0 {
	meta:
		name = "?state_case_width@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 80
		refs = "0010 ?parse_int_from_format_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z"
	strings:
		$1 = { 08 84 40 79 1F A9 00 71 60 00 00 54 01 D0 00 91 ?? ?? ?? ?? 0A 10 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F B8 08 34 00 B9 A8 00 F8 36 08 28 46 29 09 01 1E 32 E8 03 0A 4B 09 20 06 29 20 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_324_0 {
	meta:
		name = "?state_case_width@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 124
		refs = "0020 ?parse_int_from_format_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NQEAH@Z 0028 ?update_field_width@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 68 86 40 79 1F A9 00 71 80 00 00 54 61 D2 00 91 ?? ?? ?? ?? 13 00 00 14 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 0F 00 00 14 68 7A 44 B9 1F 05 00 71 81 00 00 54 68 7E 44 B9 1F 05 00 71 01 01 00 54 6A 36 40 B9 CA 00 F8 36 68 32 40 B9 EA 03 0A 4B 6A 36 00 B9 09 01 1E 32 69 32 00 B9 20 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_338_0 {
	meta:
		name = "?to_integer_size@__crt_stdio_output@@YA_KW4length_modifier@1@@Z"
		size = 76
	strings:
		$1 = { 1F 2C 00 71 08 02 00 54 89 00 00 10 28 49 A0 38 28 09 08 8B 00 01 1F D6 03 05 07 03 09 09 09 09 0B 09 03 09 80 00 80 D2 08 00 00 14 20 00 80 D2 06 00 00 14 40 00 80 D2 04 00 00 14 00 01 80 D2 02 00 00 14 00 00 80 D2 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_345_0 {
	meta:
		name = "?type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 176
		refs = "0048 ??$is_wide_character_specifier@D@__crt_stdio_output@@YA_N_KDW4length_modifier@0@@Z 0074 ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
		altNames = "?type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 13 00 00 91 6A 12 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 75 81 5F F8 35 02 00 B4 B4 06 40 F9 F4 01 00 B4 62 3E 40 B9 61 06 C1 39 60 02 40 F9 ?? ?? ?? ?? 74 26 00 F9 A8 02 40 79 C0 00 00 34 08 7D 01 53 29 00 80 52 68 52 00 B9 69 52 01 39 0D 00 00 14 68 52 00 B9 0A 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 68 26 00 F9 ?? ?? ?? ?? 49 1D C0 38 E9 FF FF 35 ?? ?? ?? ?? 49 01 08 CB 69 52 00 B9 7F 52 01 39 20 00 80 52 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_346_0 {
	meta:
		name = "?type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 200
		refs = "001c ??$extract_argument_from_va_list@PEAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ@PEAU1?1??234@AEAA_NXZ@@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@1@AEAA_NXZ@@Z 0060 ??$is_wide_character_specifier@D@__crt_stdio_output@@YA_N_KDW4length_modifier@0@@Z 008c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BE A9 FD 03 00 91 E1 43 00 91 FF 0B 00 F9 13 00 00 91 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 24 00 00 14 68 7A 44 B9 1F 05 00 71 81 00 00 54 68 7E 44 B9 1F 05 00 71 A1 03 00 54 F4 0B 40 F9 34 02 00 B4 95 06 40 F9 F5 01 00 B4 62 3E 40 B9 61 06 C1 39 60 02 40 F9 ?? ?? ?? ?? 75 26 00 F9 88 02 40 79 C0 00 00 34 08 7D 01 53 29 00 80 52 68 52 00 B9 69 52 01 39 0D 00 00 14 68 52 00 B9 0A 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 68 26 00 F9 ?? ?? ?? ?? 49 1D C0 38 E9 FF FF 35 ?? ?? ?? ?? 49 01 08 CB 69 52 00 B9 7F 52 01 39 20 00 80 52 FD 7B C2 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_348_0 {
	meta:
		name = "?type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 176
		refs = "0048 ??$is_wide_character_specifier@_W@__crt_stdio_output@@YA_N_K_WW4length_modifier@0@@Z 0074 ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
		altNames = "?type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 13 00 00 91 6A 12 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 75 81 5F F8 35 02 00 B4 B4 06 40 F9 F4 01 00 B4 62 3E 40 B9 61 86 40 79 60 02 40 F9 ?? ?? ?? ?? 74 26 00 F9 A8 02 40 79 C0 00 00 34 08 7D 01 53 29 00 80 52 68 52 00 B9 69 52 01 39 0D 00 00 14 68 52 00 B9 0A 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 68 26 00 F9 ?? ?? ?? ?? 49 1D C0 38 E9 FF FF 35 ?? ?? ?? ?? 49 01 08 CB 69 52 00 B9 7F 52 01 39 20 00 80 52 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_349_0 {
	meta:
		name = "?type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 200
		refs = "001c ??$extract_argument_from_va_list@PEAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ@PEAU1?1??234@AEAA_NXZ@@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@1@AEAA_NXZ@@Z 0060 ??$is_wide_character_specifier@_W@__crt_stdio_output@@YA_N_K_WW4length_modifier@0@@Z 008c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BE A9 FD 03 00 91 E1 43 00 91 FF 0B 00 F9 13 00 00 91 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 24 00 00 14 68 7A 44 B9 1F 05 00 71 81 00 00 54 68 7E 44 B9 1F 05 00 71 A1 03 00 54 F4 0B 40 F9 34 02 00 B4 95 06 40 F9 F5 01 00 B4 62 3E 40 B9 61 86 40 79 60 02 40 F9 ?? ?? ?? ?? 75 26 00 F9 88 02 40 79 C0 00 00 34 08 7D 01 53 29 00 80 52 68 52 00 B9 69 52 01 39 0D 00 00 14 68 52 00 B9 0A 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 68 26 00 F9 ?? ?? ?? ?? 49 1D C0 38 E9 FF FF 35 ?? ?? ?? ?? 49 01 08 CB 69 52 00 B9 7F 52 01 39 20 00 80 52 FD 7B C2 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_351_0 {
	meta:
		name = "?type_case_a@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 544
		refs = "0078 ??$ensure_buffer_is_big_enough@D@formatting_buffer@__crt_stdio_output@@QEAA_N_K@Z 014c __acrt_fp_format 0168 ?force_decimal_point@__crt_stdio_output@@YAXPEADQEAU__crt_locale_pointers@@@Z 0190 ?crop_zeroes@__crt_stdio_output@@YAXPEADQEAU__crt_locale_pointers@@@Z"
		altNames = "?type_case_a@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 FF 43 00 D1 13 00 00 91 68 32 40 B9 6A 3A 40 B9 09 01 1C 32 69 32 00 B9 2A 01 F8 36 68 06 41 39 EA 1B 80 52 09 05 01 51 3F 01 0A 6A C9 00 80 52 A8 01 80 52 28 11 88 1A 08 00 00 14 0A 01 00 35 68 06 41 39 EA 1B 80 52 09 1D 01 51 28 01 0A 0A 68 00 00 35 28 00 80 52 68 3A 00 B9 68 3A 40 B9 60 62 01 91 09 75 05 11 21 7D 40 93 ?? ?? ?? ?? 20 01 00 35 68 32 42 F9 68 00 00 B5 08 40 80 D2 03 00 00 14 68 2E 42 F9 08 FD 41 D3 09 75 05 51 69 3A 00 B9 69 62 01 91 28 05 42 F9 1F 01 00 F1 28 01 88 9A 68 26 00 F9 6A 12 40 F9 E9 83 00 91 3F 01 00 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 70 81 5F FC 68 32 42 F9 F0 13 00 FD 68 00 00 B5 04 40 80 D2 03 00 00 14 68 2E 42 F9 04 FD 41 D3 69 32 42 F9 69 00 00 B5 63 62 09 91 03 00 00 14 68 2E 42 F9 23 05 48 8B 68 32 42 F9 68 00 00 B5 02 40 80 D2 03 00 00 14 68 2E 42 F9 02 FD 41 D3 69 62 01 91 65 06 C1 39 28 05 42 F9 E0 83 00 91 67 02 40 F9 66 3A 40 B9 1F 01 00 F1 21 01 88 9A 68 06 40 F9 E8 03 00 F9 ?? ?? ?? ?? 68 32 40 B9 C8 00 28 36 69 3A 40 B9 89 00 00 35 61 06 40 F9 60 26 40 F9 ?? ?? ?? ?? 68 06 41 39 EA 1B 80 52 09 1D 01 51 28 01 0A 0A C8 00 00 35 68 32 40 B9 88 00 28 37 61 06 40 F9 60 26 40 F9 ?? ?? ?? ?? 6A 26 40 F9 48 01 C0 39 1F B5 00 71 C1 00 00 54 68 32 40 B9 4A 05 00 91 6A 26 00 F9 09 01 1A 32 69 32 00 B9 6B 26 40 F9 68 01 C0 39 08 25 01 51 09 1D 00 53 3F 95 00 71 C8 00 00 54 49 02 00 58 28 25 C8 9A 68 00 00 36 69 0E 80 52 69 06 01 39 68 01 C0 39 6A 01 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 48 01 0B CB 68 52 00 B9 20 00 80 52 FF 43 00 91 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 21 00 00 00 21 00 00 00 }
	condition:
		$1
}

rule file_35_352_0 {
	meta:
		name = "?type_case_a@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 568
		refs = "0020 ?validate_state_for_type_case_a@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ 00a0 ??$ensure_buffer_is_big_enough@D@formatting_buffer@__crt_stdio_output@@QEAA_N_K@Z 00ec ??$extract_argument_from_va_list@U_CRT_DOUBLE@@U1@@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAU_CRT_DOUBLE@@@Z 0164 __acrt_fp_format 0180 ?force_decimal_point@__crt_stdio_output@@YAXPEADQEAU__crt_locale_pointers@@@Z 01a8 ?crop_zeroes@__crt_stdio_output@@YAXPEADQEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 FF 43 00 D1 13 00 00 91 68 32 40 B9 09 01 1C 32 69 32 00 B9 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 7D 00 00 14 68 7A 44 B9 1F 05 00 71 81 00 00 54 68 7E 44 B9 1F 05 00 71 C1 0E 00 54 68 3A 40 B9 28 01 F8 36 68 06 41 39 EA 1B 80 52 09 05 01 51 3F 01 0A 6A C9 00 80 52 A8 01 80 52 28 11 88 1A 08 00 00 14 08 01 00 35 68 06 41 39 EA 1B 80 52 09 1D 01 51 28 01 0A 0A 68 00 00 35 28 00 80 52 68 3A 00 B9 68 3A 40 B9 60 62 01 91 09 75 05 11 21 7D 40 93 ?? ?? ?? ?? 20 01 00 35 68 32 42 F9 68 00 00 B5 08 40 80 D2 03 00 00 14 68 2E 42 F9 08 FD 41 D3 09 75 05 51 69 3A 00 B9 69 62 01 91 28 05 42 F9 E1 83 00 91 60 02 00 91 1F 01 00 F1 28 01 88 9A E9 83 00 91 68 26 00 F9 3F 01 00 F9 ?? ?? ?? ?? C0 F9 FF 34 68 32 42 F9 68 00 00 B5 04 40 80 D2 03 00 00 14 68 2E 42 F9 04 FD 41 D3 69 32 42 F9 69 00 00 B5 63 62 09 91 03 00 00 14 68 2E 42 F9 23 05 48 8B 68 32 42 F9 68 00 00 B5 02 40 80 D2 03 00 00 14 68 2E 42 F9 02 FD 41 D3 69 62 01 91 65 06 C1 39 28 05 42 F9 E0 83 00 91 67 02 40 F9 66 3A 40 B9 1F 01 00 F1 21 01 88 9A 68 06 40 F9 E8 03 00 F9 ?? ?? ?? ?? 68 32 40 B9 C8 00 28 36 69 3A 40 B9 89 00 00 35 61 06 40 F9 60 26 40 F9 ?? ?? ?? ?? 68 06 41 39 EA 1B 80 52 09 1D 01 51 28 01 0A 0A C8 00 00 35 68 32 40 B9 88 00 28 37 61 06 40 F9 60 26 40 F9 ?? ?? ?? ?? 6A 26 40 F9 48 01 C0 39 1F B5 00 71 C1 00 00 54 68 32 40 B9 4A 05 00 91 6A 26 00 F9 09 01 1A 32 69 32 00 B9 6B 26 40 F9 68 01 C0 39 08 25 01 51 09 1D 00 53 3F 95 00 71 C8 00 00 54 49 02 00 58 28 25 C8 9A 68 00 00 36 69 0E 80 52 69 06 01 39 68 01 C0 39 6A 01 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 48 01 0B CB 68 52 00 B9 20 00 80 52 FF 43 00 91 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 21 00 00 00 21 00 00 00 }
	condition:
		$1
}

rule file_35_354_0 {
	meta:
		name = "?type_case_a@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 544
		refs = "0078 ??$ensure_buffer_is_big_enough@D@formatting_buffer@__crt_stdio_output@@QEAA_N_K@Z 014c __acrt_fp_format 0168 ?force_decimal_point@__crt_stdio_output@@YAXPEADQEAU__crt_locale_pointers@@@Z 0190 ?crop_zeroes@__crt_stdio_output@@YAXPEADQEAU__crt_locale_pointers@@@Z"
		altNames = "?type_case_a@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 FF 43 00 D1 13 00 00 91 68 32 40 B9 6A 3A 40 B9 09 01 1C 32 69 32 00 B9 2A 01 F8 36 68 86 40 79 EA FB 9F 52 09 05 01 51 3F 01 0A 6A C9 00 80 52 A8 01 80 52 28 11 88 1A 08 00 00 14 0A 01 00 35 68 86 40 79 EA FB 9F 52 09 1D 01 51 28 01 0A 0A 68 00 00 35 28 00 80 52 68 3A 00 B9 68 3A 40 B9 60 62 01 91 09 75 05 11 21 7D 40 93 ?? ?? ?? ?? 20 01 00 35 68 32 42 F9 68 00 00 B5 08 40 80 D2 03 00 00 14 68 2E 42 F9 08 FD 41 D3 09 75 05 51 69 3A 00 B9 69 62 01 91 28 05 42 F9 1F 01 00 F1 28 01 88 9A 68 26 00 F9 6A 12 40 F9 E9 83 00 91 3F 01 00 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 70 81 5F FC 68 32 42 F9 F0 13 00 FD 68 00 00 B5 04 40 80 D2 03 00 00 14 68 2E 42 F9 04 FD 41 D3 69 32 42 F9 69 00 00 B5 63 62 09 91 03 00 00 14 68 2E 42 F9 23 05 48 8B 68 32 42 F9 68 00 00 B5 02 40 80 D2 03 00 00 14 68 2E 42 F9 02 FD 41 D3 69 62 01 91 65 0A C1 39 28 05 42 F9 E0 83 00 91 67 02 40 F9 66 3A 40 B9 1F 01 00 F1 21 01 88 9A 68 06 40 F9 E8 03 00 F9 ?? ?? ?? ?? 68 32 40 B9 C8 00 28 36 69 3A 40 B9 89 00 00 35 61 06 40 F9 60 26 40 F9 ?? ?? ?? ?? 68 86 40 79 EA FB 9F 52 09 1D 01 51 28 01 0A 0A C8 00 00 35 68 32 40 B9 88 00 28 37 61 06 40 F9 60 26 40 F9 ?? ?? ?? ?? 6A 26 40 F9 48 01 C0 39 1F B5 00 71 C1 00 00 54 68 32 40 B9 4A 05 00 91 6A 26 00 F9 09 01 1A 32 69 32 00 B9 6B 26 40 F9 68 01 C0 39 08 25 01 51 09 1D 00 53 3F 95 00 71 C8 00 00 54 49 02 00 58 28 25 C8 9A 68 00 00 36 69 0E 80 52 69 86 00 79 68 01 C0 39 6A 01 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 48 01 0B CB 68 52 00 B9 20 00 80 52 FF 43 00 91 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 21 00 00 00 21 00 00 00 }
	condition:
		$1
}

rule file_35_355_0 {
	meta:
		name = "?type_case_a@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 568
		refs = "0020 ?validate_state_for_type_case_a@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ 00a0 ??$ensure_buffer_is_big_enough@D@formatting_buffer@__crt_stdio_output@@QEAA_N_K@Z 00ec ??$extract_argument_from_va_list@U_CRT_DOUBLE@@U1@@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAU_CRT_DOUBLE@@@Z 0164 __acrt_fp_format 0180 ?force_decimal_point@__crt_stdio_output@@YAXPEADQEAU__crt_locale_pointers@@@Z 01a8 ?crop_zeroes@__crt_stdio_output@@YAXPEADQEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 FF 43 00 D1 13 00 00 91 68 32 40 B9 09 01 1C 32 69 32 00 B9 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 7D 00 00 14 68 7A 44 B9 1F 05 00 71 81 00 00 54 68 7E 44 B9 1F 05 00 71 C1 0E 00 54 68 3A 40 B9 28 01 F8 36 68 86 40 79 EA FB 9F 52 09 05 01 51 3F 01 0A 6A C9 00 80 52 A8 01 80 52 28 11 88 1A 08 00 00 14 08 01 00 35 68 86 40 79 EA FB 9F 52 09 1D 01 51 28 01 0A 0A 68 00 00 35 28 00 80 52 68 3A 00 B9 68 3A 40 B9 60 62 01 91 09 75 05 11 21 7D 40 93 ?? ?? ?? ?? 20 01 00 35 68 32 42 F9 68 00 00 B5 08 40 80 D2 03 00 00 14 68 2E 42 F9 08 FD 41 D3 09 75 05 51 69 3A 00 B9 69 62 01 91 28 05 42 F9 E1 83 00 91 60 02 00 91 1F 01 00 F1 28 01 88 9A E9 83 00 91 68 26 00 F9 3F 01 00 F9 ?? ?? ?? ?? C0 F9 FF 34 68 32 42 F9 68 00 00 B5 04 40 80 D2 03 00 00 14 68 2E 42 F9 04 FD 41 D3 69 32 42 F9 69 00 00 B5 63 62 09 91 03 00 00 14 68 2E 42 F9 23 05 48 8B 68 32 42 F9 68 00 00 B5 02 40 80 D2 03 00 00 14 68 2E 42 F9 02 FD 41 D3 69 62 01 91 65 0A C1 39 28 05 42 F9 E0 83 00 91 67 02 40 F9 66 3A 40 B9 1F 01 00 F1 21 01 88 9A 68 06 40 F9 E8 03 00 F9 ?? ?? ?? ?? 68 32 40 B9 C8 00 28 36 69 3A 40 B9 89 00 00 35 61 06 40 F9 60 26 40 F9 ?? ?? ?? ?? 68 86 40 79 EA FB 9F 52 09 1D 01 51 28 01 0A 0A C8 00 00 35 68 32 40 B9 88 00 28 37 61 06 40 F9 60 26 40 F9 ?? ?? ?? ?? 6A 26 40 F9 48 01 C0 39 1F B5 00 71 C1 00 00 54 68 32 40 B9 4A 05 00 91 6A 26 00 F9 09 01 1A 32 69 32 00 B9 6B 26 40 F9 68 01 C0 39 08 25 01 51 09 1D 00 53 3F 95 00 71 C8 00 00 54 49 02 00 58 28 25 C8 9A 68 00 00 36 69 0E 80 52 69 86 00 79 68 01 C0 39 6A 01 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 48 01 0B CB 68 52 00 B9 20 00 80 52 FF 43 00 91 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 21 00 00 00 21 00 00 00 }
	condition:
		$1
}

rule file_35_363_0 {
	meta:
		name = "?type_case_c_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z"
		size = 208
		refs = "001c ??$is_wide_character_specifier@D@__crt_stdio_output@@YA_N_KDW4length_modifier@0@@Z 006c wctomb_s"
		altNames = "?type_case_c_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 62 3E 40 B9 61 06 C1 39 60 02 40 F9 ?? ?? ?? ?? 6A 12 40 F9 74 62 01 91 C0 02 00 34 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 63 81 5F 78 88 06 42 F9 68 00 00 B5 02 40 80 D2 03 00 00 14 88 02 42 F9 02 FD 41 D3 88 06 42 F9 60 42 01 91 1F 01 00 F1 81 02 88 9A ?? ?? ?? ?? 00 02 00 34 28 00 80 52 68 02 01 39 0D 00 00 14 88 06 42 F9 1F 01 00 F1 8C 02 88 9A E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 68 81 DF 38 88 01 00 39 28 00 80 52 68 52 00 B9 88 06 42 F9 20 00 80 52 1F 01 00 F1 88 02 88 9A 68 26 00 F9 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_364_0 {
	meta:
		name = "?type_case_c_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z"
		size = 248
		refs = "001c ??$is_wide_character_specifier@D@__crt_stdio_output@@YA_N_KDW4length_modifier@0@@Z 0030 ??$extract_argument_from_va_list@_W_W@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_W@Z 0088 wctomb_s 00b0 ??$extract_argument_from_va_list@GD@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAD@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 13 00 00 91 62 3E 40 B9 61 06 C1 39 60 02 40 F9 ?? ?? ?? ?? E0 03 00 34 E1 43 00 91 FF 23 00 79 60 02 00 91 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 2C 00 00 14 68 7A 44 B9 1F 05 00 71 81 00 00 54 68 7E 44 B9 1F 05 00 71 A1 04 00 54 74 62 01 91 88 06 42 F9 68 00 00 B5 02 40 80 D2 03 00 00 14 88 02 42 F9 02 FD 41 D3 88 06 42 F9 60 42 01 91 E3 23 40 79 1F 01 00 F1 81 02 88 9A ?? ?? ?? ?? 60 02 00 34 28 00 80 52 68 02 01 39 10 00 00 14 74 62 01 91 88 06 42 F9 60 02 00 91 1F 01 00 F1 81 02 88 9A ?? ?? ?? ?? 20 FC FF 34 68 7A 44 B9 1F 05 00 71 81 00 00 54 68 7E 44 B9 1F 05 00 71 E1 00 00 54 28 00 80 52 68 52 00 B9 88 06 42 F9 1F 01 00 F1 88 02 88 9A 68 26 00 F9 20 00 80 52 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_366_0 {
	meta:
		name = "?type_case_c_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_N_W@Z"
		size = 180
		refs = "0044 ??$is_wide_character_specifier@_W@__crt_stdio_output@@YA_N_K_WW4length_modifier@0@@Z 0074 _mbtowc_l"
		altNames = "?type_case_c_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_N_W@Z"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BE A9 FD 03 00 91 13 00 00 91 36 00 80 52 76 52 01 39 6A 12 40 F9 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 62 3E 40 B9 61 86 40 79 60 02 40 F9 75 81 5F 78 ?? ?? ?? ?? 74 62 01 91 88 06 42 F9 1F 01 00 F1 80 01 00 35 63 06 40 F9 F5 43 00 39 80 02 88 9A FF 47 00 39 E1 43 00 91 68 00 40 F9 02 09 80 B9 ?? ?? ?? ?? A0 00 F8 36 76 02 01 39 03 00 00 14 88 02 88 9A 15 01 00 79 88 06 42 F9 20 00 80 52 76 52 00 B9 1F 01 00 F1 88 02 88 9A 68 26 00 F9 FD 7B C2 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_367_0 {
	meta:
		name = "?type_case_c_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_N_W@Z"
		size = 216
		refs = "0024 ??$extract_argument_from_va_list@_W_W@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_W@Z 0058 ??$is_wide_character_specifier@_W@__crt_stdio_output@@YA_N_K_WW4length_modifier@0@@Z 008c _mbtowc_l"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BE A9 FD 03 00 91 13 00 00 91 FF 23 00 79 35 00 80 52 E1 43 00 91 75 52 01 39 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 26 00 00 14 68 7A 44 B9 1F 05 00 71 81 00 00 54 68 7E 44 B9 1F 05 00 71 E1 03 00 54 62 3E 40 B9 61 86 40 79 60 02 40 F9 ?? ?? ?? ?? 74 62 01 91 E0 01 00 35 E8 43 C0 39 FF 47 00 39 E1 43 00 91 63 06 40 F9 E8 43 00 39 88 06 42 F9 1F 01 00 F1 80 02 88 9A 68 00 40 F9 02 09 80 B9 ?? ?? ?? ?? 00 01 F8 36 75 02 01 39 06 00 00 14 88 06 42 F9 1F 01 00 F1 89 02 88 9A E8 23 40 79 28 01 00 79 88 06 42 F9 75 52 00 B9 1F 01 00 F1 88 02 88 9A 68 26 00 F9 20 00 80 52 FD 7B C2 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_369_0 {
	meta:
		name = "?type_case_d@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 24
		refs = "0014 ?type_case_integer@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
	strings:
		$1 = { 08 30 40 B9 02 00 80 52 41 01 80 52 09 01 1C 32 09 30 00 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_370_0 {
	meta:
		name = "?type_case_d@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 24
		refs = "0014 ?type_case_integer@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
	strings:
		$1 = { 08 30 40 B9 02 00 80 52 41 01 80 52 09 01 1C 32 09 30 00 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_371_0 {
	meta:
		name = "?type_case_d@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 24
		refs = "0014 ?type_case_integer@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
	strings:
		$1 = { 08 30 40 B9 02 00 80 52 41 01 80 52 09 01 1C 32 09 30 00 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_372_2 {
	meta:
		name = "?type_case_d@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 24
		refs = "0014 ?type_case_integer@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
	strings:
		$1 = { 08 30 40 B9 02 00 80 52 41 01 80 52 09 01 1C 32 09 30 00 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_373_2 {
	meta:
		name = "?type_case_d@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 24
		refs = "0014 ?type_case_integer@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
	strings:
		$1 = { 08 30 40 B9 02 00 80 52 41 01 80 52 09 01 1C 32 09 30 00 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_374_2 {
	meta:
		name = "?type_case_d@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 24
		refs = "0014 ?type_case_integer@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
	strings:
		$1 = { 08 30 40 B9 02 00 80 52 41 01 80 52 09 01 1C 32 09 30 00 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_375_0 {
	meta:
		name = "?type_case_integer@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
		size = 644
		refs = "00a8 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00ac ??_C@_1EO@GHKFGFKL@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAi?$AAn?$AAt?$AAe?$AAg?$AAe?$AAr?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe@ 00b0 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 00cc _CrtDbgReportW 00dc _errno 00e8 ??_C@_1BMK@CBEMPMMA@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0100 _invalid_parameter 0224 ??$type_case_integer_parse_into_buffer@_K@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAX_KI_N@Z 0230 ??$type_case_integer_parse_into_buffer@I@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXII_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 6A 3E 40 B9 2E 00 00 11 5F 2D 00 71 08 02 00 54 89 00 00 10 28 49 AA 38 28 09 08 8B 00 01 1F D6 03 05 07 03 09 09 09 09 0B 09 03 09 8C 00 80 D2 08 00 00 14 2C 00 80 D2 06 00 00 14 4C 00 80 D2 04 00 00 14 0C 01 80 D2 02 00 00 14 0C 00 80 D2 9F 05 00 71 E0 08 00 54 9F 09 00 71 40 06 00 54 9F 11 00 71 C0 04 00 54 9F 21 00 71 61 01 00 54 6A 12 40 F9 74 C2 00 91 88 02 40 B9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6D 81 5F F8 44 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 37 81 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 A3 37 81 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 5C 00 00 14 6A 12 40 F9 74 C2 00 91 88 02 40 B9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6D 81 5F B8 21 00 00 14 74 C2 00 91 6A 12 40 F9 88 02 40 B9 28 01 20 36 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 68 81 DF 78 0D 7D 40 93 15 00 00 14 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6D 81 5F 78 0E 00 00 14 74 C2 00 91 88 02 40 B9 E8 00 20 36 69 12 40 F9 2A 21 00 91 6A 12 00 F9 48 81 DF 38 0D 7D 40 93 05 00 00 14 68 12 40 F9 09 21 00 91 69 12 00 F9 2D 81 5F 38 88 02 40 B9 A8 00 20 36 8D 00 F8 B6 08 01 1A 32 88 02 00 B9 ED 03 0D CB 6A 3A 40 B9 6A 00 F8 36 28 00 80 52 07 00 00 14 88 02 40 B9 5F 01 08 71 09 79 1C 12 89 02 00 B9 6D 00 00 54 08 40 80 52 68 3A 00 B9 8D 00 00 B5 88 02 40 B9 09 79 1A 12 89 02 00 B9 43 00 00 11 7F 52 01 39 C2 01 00 11 9F 21 00 F1 60 02 00 91 81 00 00 54 A1 01 00 91 ?? ?? ?? ?? 03 00 00 14 A1 01 00 11 ?? ?? ?? ?? 88 02 40 B9 E8 01 38 36 69 52 40 B9 A9 00 00 34 68 26 40 F9 09 01 C0 39 3F C1 00 71 20 01 00 54 68 26 40 F9 0A 06 80 52 09 05 00 D1 69 26 00 F9 2A 01 00 39 68 52 40 B9 09 05 00 11 69 52 00 B9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_377_0 {
	meta:
		name = "?type_case_integer@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
		size = 644
		refs = "00a8 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00ac ??_C@_1EO@GHKFGFKL@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAi?$AAn?$AAt?$AAe?$AAg?$AAe?$AAr?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe@ 00b0 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 00cc _CrtDbgReportW 00dc _errno 00e8 ??_C@_1BLI@IAPDPPCE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0100 _invalid_parameter 0224 ??$type_case_integer_parse_into_buffer@_K@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAX_KI_N@Z 0230 ??$type_case_integer_parse_into_buffer@I@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXII_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 6A 3E 40 B9 2E 00 00 11 5F 2D 00 71 08 02 00 54 89 00 00 10 28 49 AA 38 28 09 08 8B 00 01 1F D6 03 05 07 03 09 09 09 09 0B 09 03 09 8C 00 80 D2 08 00 00 14 2C 00 80 D2 06 00 00 14 4C 00 80 D2 04 00 00 14 0C 01 80 D2 02 00 00 14 0C 00 80 D2 9F 05 00 71 E0 08 00 54 9F 09 00 71 40 06 00 54 9F 11 00 71 C0 04 00 54 9F 21 00 71 61 01 00 54 6A 12 40 F9 74 C2 00 91 88 02 40 B9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6D 81 5F F8 44 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 37 81 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 A3 37 81 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 5C 00 00 14 6A 12 40 F9 74 C2 00 91 88 02 40 B9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6D 81 5F B8 21 00 00 14 74 C2 00 91 6A 12 40 F9 88 02 40 B9 28 01 20 36 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 68 81 DF 78 0D 7D 40 93 15 00 00 14 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6D 81 5F 78 0E 00 00 14 74 C2 00 91 88 02 40 B9 E8 00 20 36 69 12 40 F9 2A 21 00 91 6A 12 00 F9 48 81 DF 38 0D 7D 40 93 05 00 00 14 68 12 40 F9 09 21 00 91 69 12 00 F9 2D 81 5F 38 88 02 40 B9 A8 00 20 36 8D 00 F8 B6 08 01 1A 32 88 02 00 B9 ED 03 0D CB 6A 3A 40 B9 6A 00 F8 36 28 00 80 52 07 00 00 14 88 02 40 B9 5F 01 08 71 09 79 1C 12 89 02 00 B9 6D 00 00 54 08 40 80 52 68 3A 00 B9 8D 00 00 B5 88 02 40 B9 09 79 1A 12 89 02 00 B9 43 00 00 11 7F 52 01 39 C2 01 00 11 9F 21 00 F1 60 02 00 91 81 00 00 54 A1 01 00 91 ?? ?? ?? ?? 03 00 00 14 A1 01 00 11 ?? ?? ?? ?? 88 02 40 B9 E8 01 38 36 69 52 40 B9 A9 00 00 34 68 26 40 F9 09 01 C0 39 3F C1 00 71 20 01 00 54 68 26 40 F9 0A 06 80 52 09 05 00 D1 69 26 00 F9 2A 01 00 39 68 52 40 B9 09 05 00 11 69 52 00 B9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_376_0 {
	meta:
		name = "?type_case_integer@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
		size = 636
		refs = "00a4 ??$extract_argument_from_va_list@_J_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z 00ac ??$extract_argument_from_va_list@_K_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z 00b4 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00b8 ??_C@_1EO@GHKFGFKL@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAi?$AAn?$AAt?$AAe?$AAg?$AAe?$AAr?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe@ 00bc ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 00d8 _CrtDbgReportW 00e8 _errno 00f4 ??_C@_1BNA@DPILCHKO@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 010c _invalid_parameter 012c ??$extract_argument_from_va_list@H_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z 0134 ??$extract_argument_from_va_list@I_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z 0150 ??$extract_argument_from_va_list@F_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z 0158 ??$extract_argument_from_va_list@G_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z 0174 ??$extract_argument_from_va_list@C_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z 017c ??$extract_argument_from_va_list@E_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z 0214 ??$type_case_integer_parse_into_buffer@_K@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAX_KI_N@Z 0220 ??$type_case_integer_parse_into_buffer@I@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXII_N@Z"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BE A9 FD 03 00 91 13 00 00 91 6A 3E 40 B9 36 00 00 11 57 00 00 11 5F 2D 00 71 08 02 00 54 89 00 00 10 28 49 AA 38 28 09 08 8B 00 01 1F D6 03 05 07 03 09 09 09 09 0B 09 03 09 94 00 80 D2 08 00 00 14 34 00 80 D2 06 00 00 14 54 00 80 D2 04 00 00 14 14 01 80 D2 02 00 00 14 14 00 80 D2 FF 0B 00 F9 9F 06 00 71 60 07 00 54 9F 0A 00 71 00 06 00 54 9F 12 00 71 A0 04 00 54 9F 22 00 71 41 01 00 54 75 C2 00 91 A8 02 40 B9 E1 43 00 91 60 02 00 91 68 00 20 36 ?? ?? ?? ?? 36 00 00 14 ?? ?? ?? ?? 34 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 37 81 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 A3 37 81 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 55 00 00 14 75 C2 00 91 A8 02 40 B9 E1 43 00 91 60 02 00 91 68 00 20 36 ?? ?? ?? ?? 14 00 00 14 ?? ?? ?? ?? 12 00 00 14 75 C2 00 91 A8 02 40 B9 E1 43 00 91 60 02 00 91 68 00 20 36 ?? ?? ?? ?? 0B 00 00 14 ?? ?? ?? ?? 09 00 00 14 75 C2 00 91 A8 02 40 B9 E1 43 00 91 60 02 00 91 68 00 20 36 ?? ?? ?? ?? 02 00 00 14 ?? ?? ?? ?? 08 00 00 11 68 FC FF 34 68 7A 44 B9 1F 05 00 71 81 00 00 54 68 7E 44 B9 1F 05 00 71 41 06 00 54 A8 02 40 B9 EA 0B 40 F9 A8 00 20 36 8A 00 F8 B6 08 01 1A 32 A8 02 00 B9 EA 03 0A CB 6B 3A 40 B9 6B 00 F8 36 28 00 80 52 07 00 00 14 A8 02 40 B9 7F 01 08 71 09 79 1C 12 A9 02 00 B9 6D 00 00 54 08 40 80 52 68 3A 00 B9 8A 00 00 B5 A8 02 40 B9 09 79 1A 12 A9 02 00 B9 7F 52 01 39 9F 22 00 F1 E3 02 00 11 C2 02 00 11 60 02 00 91 81 00 00 54 41 01 00 91 ?? ?? ?? ?? 03 00 00 14 41 01 00 11 ?? ?? ?? ?? A8 02 40 B9 E8 01 38 36 69 52 40 B9 A9 00 00 34 68 26 40 F9 09 01 C0 39 3F C1 00 71 20 01 00 54 68 26 40 F9 0A 06 80 52 09 05 00 D1 69 26 00 F9 2A 01 00 39 68 52 40 B9 09 05 00 11 69 52 00 B9 20 00 80 52 FD 7B C2 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_378_0 {
	meta:
		name = "?type_case_integer@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
		size = 648
		refs = "00a8 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00ac ??_C@_1EO@GHKFGFKL@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAi?$AAn?$AAt?$AAe?$AAg?$AAe?$AAr?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe@ 00b0 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 00cc _CrtDbgReportW 00dc _errno 00e8 ??_C@_1BOC@EPNAJNBF@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0100 _invalid_parameter 0228 ??$type_case_integer_parse_into_buffer@_K@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAX_KI_N@Z 0234 ??$type_case_integer_parse_into_buffer@I@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXII_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 6A 3E 40 B9 2E 00 00 11 5F 2D 00 71 08 02 00 54 89 00 00 10 28 49 AA 38 28 09 08 8B 00 01 1F D6 03 05 07 03 09 09 09 09 0B 09 03 09 8C 00 80 D2 08 00 00 14 2C 00 80 D2 06 00 00 14 4C 00 80 D2 04 00 00 14 0C 01 80 D2 02 00 00 14 0C 00 80 D2 9F 05 00 71 E0 08 00 54 9F 09 00 71 40 06 00 54 9F 11 00 71 C0 04 00 54 9F 21 00 71 61 01 00 54 6A 12 40 F9 74 C2 00 91 88 02 40 B9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6D 81 5F F8 44 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 37 81 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 A3 37 81 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 5D 00 00 14 6A 12 40 F9 74 C2 00 91 88 02 40 B9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6D 81 5F B8 21 00 00 14 74 C2 00 91 6A 12 40 F9 88 02 40 B9 28 01 20 36 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 68 81 DF 78 0D 7D 40 93 15 00 00 14 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6D 81 5F 78 0E 00 00 14 74 C2 00 91 88 02 40 B9 E8 00 20 36 69 12 40 F9 2A 21 00 91 6A 12 00 F9 48 81 DF 38 0D 7D 40 93 05 00 00 14 68 12 40 F9 09 21 00 91 69 12 00 F9 2D 81 5F 38 88 02 40 B9 A8 00 20 36 8D 00 F8 B6 08 01 1A 32 88 02 00 B9 ED 03 0D CB 6A 3A 40 B9 2B 00 80 52 6A 00 F8 36 6B 3A 00 B9 08 00 00 14 88 02 40 B9 5F 01 08 71 09 79 1C 12 89 02 00 B9 6D 00 00 54 08 40 80 52 68 3A 00 B9 8D 00 00 B5 88 02 40 B9 09 79 1A 12 89 02 00 B9 43 00 00 11 6B 52 01 39 C2 01 00 11 9F 21 00 F1 60 02 00 91 81 00 00 54 A1 01 00 91 ?? ?? ?? ?? 03 00 00 14 A1 01 00 11 ?? ?? ?? ?? 88 02 40 B9 E8 01 38 36 69 52 40 B9 A9 00 00 34 68 26 40 F9 09 01 40 79 3F C1 00 71 20 01 00 54 68 26 40 F9 0A 06 80 52 09 09 00 D1 69 26 00 F9 2A 01 00 79 68 52 40 B9 09 05 00 11 69 52 00 B9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_380_0 {
	meta:
		name = "?type_case_integer@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
		size = 648
		refs = "00a8 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00ac ??_C@_1EO@GHKFGFKL@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAi?$AAn?$AAt?$AAe?$AAg?$AAe?$AAr?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe@ 00b0 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 00cc _CrtDbgReportW 00dc _errno 00e8 ??_C@_1BNA@NHIEEONE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0100 _invalid_parameter 0228 ??$type_case_integer_parse_into_buffer@_K@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAX_KI_N@Z 0234 ??$type_case_integer_parse_into_buffer@I@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXII_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 6A 3E 40 B9 2E 00 00 11 5F 2D 00 71 08 02 00 54 89 00 00 10 28 49 AA 38 28 09 08 8B 00 01 1F D6 03 05 07 03 09 09 09 09 0B 09 03 09 8C 00 80 D2 08 00 00 14 2C 00 80 D2 06 00 00 14 4C 00 80 D2 04 00 00 14 0C 01 80 D2 02 00 00 14 0C 00 80 D2 9F 05 00 71 E0 08 00 54 9F 09 00 71 40 06 00 54 9F 11 00 71 C0 04 00 54 9F 21 00 71 61 01 00 54 6A 12 40 F9 74 C2 00 91 88 02 40 B9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6D 81 5F F8 44 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 37 81 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 A3 37 81 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 5D 00 00 14 6A 12 40 F9 74 C2 00 91 88 02 40 B9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6D 81 5F B8 21 00 00 14 74 C2 00 91 6A 12 40 F9 88 02 40 B9 28 01 20 36 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 68 81 DF 78 0D 7D 40 93 15 00 00 14 E8 03 0A CB 09 01 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 6D 81 5F 78 0E 00 00 14 74 C2 00 91 88 02 40 B9 E8 00 20 36 69 12 40 F9 2A 21 00 91 6A 12 00 F9 48 81 DF 38 0D 7D 40 93 05 00 00 14 68 12 40 F9 09 21 00 91 69 12 00 F9 2D 81 5F 38 88 02 40 B9 A8 00 20 36 8D 00 F8 B6 08 01 1A 32 88 02 00 B9 ED 03 0D CB 6A 3A 40 B9 2B 00 80 52 6A 00 F8 36 6B 3A 00 B9 08 00 00 14 88 02 40 B9 5F 01 08 71 09 79 1C 12 89 02 00 B9 6D 00 00 54 08 40 80 52 68 3A 00 B9 8D 00 00 B5 88 02 40 B9 09 79 1A 12 89 02 00 B9 43 00 00 11 6B 52 01 39 C2 01 00 11 9F 21 00 F1 60 02 00 91 81 00 00 54 A1 01 00 91 ?? ?? ?? ?? 03 00 00 14 A1 01 00 11 ?? ?? ?? ?? 88 02 40 B9 E8 01 38 36 69 52 40 B9 A9 00 00 34 68 26 40 F9 09 01 40 79 3F C1 00 71 20 01 00 54 68 26 40 F9 0A 06 80 52 09 09 00 D1 69 26 00 F9 2A 01 00 79 68 52 40 B9 09 05 00 11 69 52 00 B9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_379_0 {
	meta:
		name = "?type_case_integer@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
		size = 640
		refs = "00a4 ??$extract_argument_from_va_list@_J_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z 00ac ??$extract_argument_from_va_list@_K_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z 00b4 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00b8 ??_C@_1EO@GHKFGFKL@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAi?$AAn?$AAt?$AAe?$AAg?$AAe?$AAr?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe@ 00bc ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 00d8 _CrtDbgReportW 00e8 _errno 00f4 ??_C@_1BOI@CKLPKAPF@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 010c _invalid_parameter 012c ??$extract_argument_from_va_list@H_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z 0134 ??$extract_argument_from_va_list@I_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z 0150 ??$extract_argument_from_va_list@F_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z 0158 ??$extract_argument_from_va_list@G_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z 0174 ??$extract_argument_from_va_list@C_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z 017c ??$extract_argument_from_va_list@E_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEA_J@Z 0218 ??$type_case_integer_parse_into_buffer@_K@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAX_KI_N@Z 0224 ??$type_case_integer_parse_into_buffer@I@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXII_N@Z"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BE A9 FD 03 00 91 13 00 00 91 6A 3E 40 B9 36 00 00 11 57 00 00 11 5F 2D 00 71 08 02 00 54 89 00 00 10 28 49 AA 38 28 09 08 8B 00 01 1F D6 03 05 07 03 09 09 09 09 0B 09 03 09 94 00 80 D2 08 00 00 14 34 00 80 D2 06 00 00 14 54 00 80 D2 04 00 00 14 14 01 80 D2 02 00 00 14 14 00 80 D2 FF 0B 00 F9 9F 06 00 71 60 07 00 54 9F 0A 00 71 00 06 00 54 9F 12 00 71 A0 04 00 54 9F 22 00 71 41 01 00 54 75 C2 00 91 A8 02 40 B9 E1 43 00 91 60 02 00 91 68 00 20 36 ?? ?? ?? ?? 36 00 00 14 ?? ?? ?? ?? 34 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 37 81 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 A3 37 81 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 56 00 00 14 75 C2 00 91 A8 02 40 B9 E1 43 00 91 60 02 00 91 68 00 20 36 ?? ?? ?? ?? 14 00 00 14 ?? ?? ?? ?? 12 00 00 14 75 C2 00 91 A8 02 40 B9 E1 43 00 91 60 02 00 91 68 00 20 36 ?? ?? ?? ?? 0B 00 00 14 ?? ?? ?? ?? 09 00 00 14 75 C2 00 91 A8 02 40 B9 E1 43 00 91 60 02 00 91 68 00 20 36 ?? ?? ?? ?? 02 00 00 14 ?? ?? ?? ?? 08 00 00 11 68 FC FF 34 68 7A 44 B9 1F 05 00 71 81 00 00 54 68 7E 44 B9 1F 05 00 71 61 06 00 54 A8 02 40 B9 EA 0B 40 F9 A8 00 20 36 8A 00 F8 B6 08 01 1A 32 A8 02 00 B9 EA 03 0A CB 6B 3A 40 B9 2C 00 80 52 6B 00 F8 36 6C 3A 00 B9 08 00 00 14 A8 02 40 B9 7F 01 08 71 09 79 1C 12 A9 02 00 B9 6D 00 00 54 08 40 80 52 68 3A 00 B9 8A 00 00 B5 A8 02 40 B9 09 79 1A 12 A9 02 00 B9 6C 52 01 39 9F 22 00 F1 E3 02 00 11 C2 02 00 11 60 02 00 91 81 00 00 54 41 01 00 91 ?? ?? ?? ?? 03 00 00 14 41 01 00 11 ?? ?? ?? ?? A8 02 40 B9 E8 01 38 36 69 52 40 B9 A9 00 00 34 68 26 40 F9 09 01 40 79 3F C1 00 71 20 01 00 54 68 26 40 F9 0A 06 80 52 09 09 00 D1 69 26 00 F9 2A 01 00 79 68 52 40 B9 09 05 00 11 69 52 00 B9 20 00 80 52 FD 7B C2 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_381_0 {
	meta:
		name = "?type_case_n@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 404
		refs = "002c _get_printf_count_output 0034 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0038 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 003c ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0058 _CrtDbgReportW 0068 _errno 007c ??_C@_1BLO@NCBAJABA@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 008c _invalid_parameter 0114 ??_C@_1EO@GHKFGFKL@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAi?$AAn?$AAt?$AAe?$AAg?$AAe?$AAr?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe@"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 6A 12 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 74 81 5F F8 ?? ?? ?? ?? 40 03 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 47 81 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 43 47 81 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? 00 00 80 52 3D 00 00 14 6A 3E 40 B9 5F 2D 00 71 08 02 00 54 89 00 00 10 28 49 AA 38 28 09 08 8B 00 01 1F D6 03 05 07 03 09 09 09 09 0B 09 03 09 8A 00 80 D2 08 00 00 14 2A 00 80 D2 06 00 00 14 4A 00 80 D2 04 00 00 14 0A 01 80 D2 02 00 00 14 0A 00 80 D2 5F 05 00 71 60 04 00 54 5F 09 00 71 C0 03 00 54 5F 11 00 71 20 03 00 54 5F 21 00 71 81 00 00 54 68 2A 80 B9 88 02 00 F9 1C 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 48 81 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 83 48 81 52 ?? ?? ?? ?? C9 FF FF 17 68 2A 40 B9 88 02 00 B9 06 00 00 14 68 52 C0 79 88 02 00 79 03 00 00 14 68 A2 C0 39 88 02 00 39 28 00 80 52 68 02 01 39 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_383_0 {
	meta:
		name = "?type_case_n@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 404
		refs = "002c _get_printf_count_output 0034 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0038 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 003c ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0058 _CrtDbgReportW 0068 _errno 007c ??_C@_1BKM@INIKIFKL@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 008c _invalid_parameter 0114 ??_C@_1EO@GHKFGFKL@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAi?$AAn?$AAt?$AAe?$AAg?$AAe?$AAr?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe@"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 6A 12 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 74 81 5F F8 ?? ?? ?? ?? 40 03 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 47 81 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 43 47 81 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? 00 00 80 52 3D 00 00 14 6A 3E 40 B9 5F 2D 00 71 08 02 00 54 89 00 00 10 28 49 AA 38 28 09 08 8B 00 01 1F D6 03 05 07 03 09 09 09 09 0B 09 03 09 8A 00 80 D2 08 00 00 14 2A 00 80 D2 06 00 00 14 4A 00 80 D2 04 00 00 14 0A 01 80 D2 02 00 00 14 0A 00 80 D2 5F 05 00 71 60 04 00 54 5F 09 00 71 C0 03 00 54 5F 11 00 71 20 03 00 54 5F 21 00 71 81 00 00 54 68 2A 80 B9 88 02 00 F9 1C 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 48 81 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 83 48 81 52 ?? ?? ?? ?? C9 FF FF 17 68 2A 40 B9 88 02 00 B9 06 00 00 14 68 52 C0 79 88 02 00 79 03 00 00 14 68 A2 C0 39 88 02 00 39 28 00 80 52 68 02 01 39 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_384_0 {
	meta:
		name = "?type_case_n@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 404
		refs = "002c _get_printf_count_output 0034 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0038 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 003c ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0058 _CrtDbgReportW 0068 _errno 007c ??_C@_1BNG@LNJJNELO@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 008c _invalid_parameter 0114 ??_C@_1EO@GHKFGFKL@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAi?$AAn?$AAt?$AAe?$AAg?$AAe?$AAr?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe@"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 6A 12 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 74 81 5F F8 ?? ?? ?? ?? 40 03 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 47 81 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 43 47 81 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? 00 00 80 52 3D 00 00 14 6A 3E 40 B9 5F 2D 00 71 08 02 00 54 89 00 00 10 28 49 AA 38 28 09 08 8B 00 01 1F D6 03 05 07 03 09 09 09 09 0B 09 03 09 8A 00 80 D2 08 00 00 14 2A 00 80 D2 06 00 00 14 4A 00 80 D2 04 00 00 14 0A 01 80 D2 02 00 00 14 0A 00 80 D2 5F 05 00 71 60 04 00 54 5F 09 00 71 C0 03 00 54 5F 11 00 71 20 03 00 54 5F 21 00 71 81 00 00 54 68 2A 80 B9 88 02 00 F9 1C 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 48 81 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 83 48 81 52 ?? ?? ?? ?? C9 FF FF 17 68 2A 40 B9 88 02 00 B9 06 00 00 14 68 52 C0 79 88 02 00 79 03 00 00 14 68 A2 C0 39 88 02 00 39 28 00 80 52 68 02 01 39 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_386_0 {
	meta:
		name = "?type_case_n@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 404
		refs = "002c _get_printf_count_output 0034 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0038 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 003c ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0058 _CrtDbgReportW 0068 _errno 007c ??_C@_1BME@FGLFKNB@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 008c _invalid_parameter 0114 ??_C@_1EO@GHKFGFKL@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAi?$AAn?$AAt?$AAe?$AAg?$AAe?$AAr?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe@"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 6A 12 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 74 81 5F F8 ?? ?? ?? ?? 40 03 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 47 81 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 43 47 81 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? 00 00 80 52 3D 00 00 14 6A 3E 40 B9 5F 2D 00 71 08 02 00 54 89 00 00 10 28 49 AA 38 28 09 08 8B 00 01 1F D6 03 05 07 03 09 09 09 09 0B 09 03 09 8A 00 80 D2 08 00 00 14 2A 00 80 D2 06 00 00 14 4A 00 80 D2 04 00 00 14 0A 01 80 D2 02 00 00 14 0A 00 80 D2 5F 05 00 71 60 04 00 54 5F 09 00 71 C0 03 00 54 5F 11 00 71 20 03 00 54 5F 21 00 71 81 00 00 54 68 2A 80 B9 88 02 00 F9 1C 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 48 81 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 83 48 81 52 ?? ?? ?? ?? C9 FF FF 17 68 2A 40 B9 88 02 00 B9 06 00 00 14 68 52 C0 79 88 02 00 79 03 00 00 14 68 A2 C0 39 88 02 00 39 28 00 80 52 68 02 01 39 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_382_0 {
	meta:
		name = "?type_case_n@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 436
		refs = "0018 ??$extract_argument_from_va_list@PEAXPEAX@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAX@Z 0040 _get_printf_count_output 0048 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0090 ??_C@_1BME@LDMBFEIF@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00a0 _invalid_parameter 0128 ??_C@_1EO@GHKFGFKL@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAi?$AAn?$AAt?$AAe?$AAg?$AAe?$AAr?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe@"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 E1 43 00 91 FF 0B 00 F9 13 00 00 91 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 61 00 00 14 68 7A 44 B9 1F 05 00 71 81 00 00 54 68 7E 44 B9 1F 05 00 71 41 0B 00 54 ?? ?? ?? ?? 20 03 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 47 81 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 43 47 81 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? DF FF FF 17 6A 3E 40 B9 5F 2D 00 71 08 02 00 54 89 00 00 10 28 49 AA 38 28 09 08 8B 00 01 1F D6 03 05 07 03 09 09 09 09 0B 09 03 09 8A 00 80 D2 08 00 00 14 2A 00 80 D2 06 00 00 14 4A 00 80 D2 04 00 00 14 0A 01 80 D2 02 00 00 14 0A 00 80 D2 5F 05 00 71 C0 04 00 54 5F 09 00 71 00 04 00 54 5F 11 00 71 40 03 00 54 5F 21 00 71 A1 00 00 54 69 2A 80 B9 E8 0B 40 F9 09 01 00 F9 1F 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 48 81 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 83 48 81 52 ?? ?? ?? ?? C9 FF FF 17 69 2A 40 B9 E8 0B 40 F9 09 01 00 B9 08 00 00 14 69 52 C0 79 E8 0B 40 F9 09 01 00 79 04 00 00 14 69 A2 C0 39 E8 0B 40 F9 09 01 00 39 28 00 80 52 68 02 01 39 20 00 80 52 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_385_0 {
	meta:
		name = "?type_case_n@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 436
		refs = "0018 ??$extract_argument_from_va_list@PEAXPEAX@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAX@Z 0040 _get_printf_count_output 0048 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 0050 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 006c _CrtDbgReportW 007c _errno 0090 ??_C@_1BNM@CMCEOKHA@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00a0 _invalid_parameter 0128 ??_C@_1EO@GHKFGFKL@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAi?$AAn?$AAt?$AAe?$AAg?$AAe?$AAr?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe@"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 E1 43 00 91 FF 0B 00 F9 13 00 00 91 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 61 00 00 14 68 7A 44 B9 1F 05 00 71 81 00 00 54 68 7E 44 B9 1F 05 00 71 41 0B 00 54 ?? ?? ?? ?? 20 03 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 47 81 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 43 47 81 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? DF FF FF 17 6A 3E 40 B9 5F 2D 00 71 08 02 00 54 89 00 00 10 28 49 AA 38 28 09 08 8B 00 01 1F D6 03 05 07 03 09 09 09 09 0B 09 03 09 8A 00 80 D2 08 00 00 14 2A 00 80 D2 06 00 00 14 4A 00 80 D2 04 00 00 14 0A 01 80 D2 02 00 00 14 0A 00 80 D2 5F 05 00 71 C0 04 00 54 5F 09 00 71 00 04 00 54 5F 11 00 71 40 03 00 54 5F 21 00 71 A1 00 00 54 69 2A 80 B9 E8 0B 40 F9 09 01 00 F9 1F 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 48 81 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 83 48 81 52 ?? ?? ?? ?? C9 FF FF 17 69 2A 40 B9 E8 0B 40 F9 09 01 00 B9 08 00 00 14 69 52 C0 79 E8 0B 40 F9 09 01 00 79 04 00 00 14 69 A2 C0 39 E8 0B 40 F9 09 01 00 39 28 00 80 52 68 02 01 39 20 00 80 52 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_387_0 {
	meta:
		name = "?type_case_o@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 28
		refs = "0018 ?type_case_integer@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
	strings:
		$1 = { 08 30 40 B9 68 00 28 36 08 01 19 32 08 30 00 B9 02 00 80 52 01 01 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_388_0 {
	meta:
		name = "?type_case_o@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 28
		refs = "0018 ?type_case_integer@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
	strings:
		$1 = { 08 30 40 B9 68 00 28 36 08 01 19 32 08 30 00 B9 02 00 80 52 01 01 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_389_0 {
	meta:
		name = "?type_case_o@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 28
		refs = "0018 ?type_case_integer@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
	strings:
		$1 = { 08 30 40 B9 68 00 28 36 08 01 19 32 08 30 00 B9 02 00 80 52 01 01 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_390_2 {
	meta:
		name = "?type_case_o@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 28
		refs = "0018 ?type_case_integer@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
	strings:
		$1 = { 08 30 40 B9 68 00 28 36 08 01 19 32 08 30 00 B9 02 00 80 52 01 01 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_391_2 {
	meta:
		name = "?type_case_o@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 28
		refs = "0018 ?type_case_integer@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
	strings:
		$1 = { 08 30 40 B9 68 00 28 36 08 01 19 32 08 30 00 B9 02 00 80 52 01 01 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_392_2 {
	meta:
		name = "?type_case_o@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 28
		refs = "0018 ?type_case_integer@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
	strings:
		$1 = { 08 30 40 B9 68 00 28 36 08 01 19 32 08 30 00 B9 02 00 80 52 01 01 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_393_0 {
	meta:
		name = "?type_case_p@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 24
		refs = "0014 ?type_case_integer@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
	strings:
		$1 = { 08 02 80 52 69 01 80 52 08 24 07 29 22 00 80 52 01 02 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_394_0 {
	meta:
		name = "?type_case_p@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 24
		refs = "0014 ?type_case_integer@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
	strings:
		$1 = { 08 02 80 52 69 01 80 52 08 24 07 29 22 00 80 52 01 02 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_395_0 {
	meta:
		name = "?type_case_p@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 24
		refs = "0014 ?type_case_integer@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
	strings:
		$1 = { 08 02 80 52 69 01 80 52 08 24 07 29 22 00 80 52 01 02 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_396_2 {
	meta:
		name = "?type_case_p@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 24
		refs = "0014 ?type_case_integer@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
	strings:
		$1 = { 08 02 80 52 69 01 80 52 08 24 07 29 22 00 80 52 01 02 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_397_2 {
	meta:
		name = "?type_case_p@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 24
		refs = "0014 ?type_case_integer@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
	strings:
		$1 = { 08 02 80 52 69 01 80 52 08 24 07 29 22 00 80 52 01 02 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_398_2 {
	meta:
		name = "?type_case_p@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 24
		refs = "0014 ?type_case_integer@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NI_N@Z"
	strings:
		$1 = { 08 02 80 52 69 01 80 52 08 24 07 29 22 00 80 52 01 02 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_399_0 {
	meta:
		name = "?type_case_s@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 184
		refs = "004c ??$is_wide_character_specifier@D@__crt_stdio_output@@YA_N_KDW4length_modifier@0@@Z 005c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@ 007c wcsnlen 0084 ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@ 009c strnlen"
		altNames = "?type_case_s@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 13 00 00 91 6A 12 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 68 0A 47 29 09 00 B0 12 74 81 5F F8 61 06 C1 39 60 02 40 F9 1F 05 00 31 35 01 88 1A 74 26 00 F9 ?? ?? ?? ?? 9F 02 00 F1 A1 7E 40 93 60 01 00 34 ?? ?? ?? ?? ?? ?? ?? ?? 88 02 00 91 29 01 88 9A 2A 00 80 52 69 26 00 F9 20 01 00 91 6A 52 01 39 ?? ?? ?? ?? 08 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 68 26 40 F9 29 01 88 9A 20 01 00 91 69 26 00 F9 ?? ?? ?? ?? 60 52 00 B9 20 00 80 52 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_400_0 {
	meta:
		name = "?type_case_s@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 184
		refs = "0014 ??$extract_argument_from_va_list@PEADPEAD@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAD@Z 0054 ??$is_wide_character_specifier@D@__crt_stdio_output@@YA_N_KDW4length_modifier@0@@Z 0064 ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@ 0080 wcsnlen 008c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@ 00a0 strnlen"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 61 22 01 91 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 23 00 00 14 68 7A 44 B9 1F 05 00 71 81 00 00 54 68 7E 44 B9 1F 05 00 71 81 03 00 54 68 0A 47 29 09 00 B0 12 61 06 C1 39 60 02 40 F9 1F 05 00 31 34 01 88 1A ?? ?? ?? ?? 68 26 40 F9 60 01 00 34 88 00 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 68 26 00 F9 60 26 40 F9 28 00 80 52 81 7E 40 93 68 52 01 39 ?? ?? ?? ?? 08 00 00 14 88 00 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 68 26 00 F9 60 26 40 F9 81 7E 40 93 ?? ?? ?? ?? 60 52 00 B9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_402_0 {
	meta:
		name = "?type_case_s@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 244
		refs = "004c ??$is_wide_character_specifier@_W@__crt_stdio_output@@YA_N_K_WW4length_modifier@0@@Z 0054 ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@ 007c wcsnlen 008c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
		altNames = "?type_case_s@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 13 00 00 91 6A 12 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 68 0A 47 29 09 00 B0 12 75 81 5F F8 61 86 40 79 60 02 40 F9 1F 05 00 31 34 01 88 1A 75 26 00 F9 ?? ?? ?? ?? C0 01 00 34 ?? ?? ?? ?? ?? ?? ?? ?? A8 02 00 91 BF 02 00 F1 29 01 88 9A 2A 00 80 52 69 26 00 F9 20 01 00 91 6A 52 01 39 81 7E 40 93 ?? ?? ?? ?? 60 52 00 B9 17 00 00 14 95 00 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 68 26 00 F9 6D 26 40 F9 0E 00 80 52 9F 02 00 71 CD 01 00 54 A9 01 C0 39 89 01 00 34 2C 1D 00 53 69 06 40 F9 2A 01 40 F9 4B 01 40 F9 6C D9 6C 78 4C 00 78 36 AD 05 00 91 CE 05 00 11 DF 01 14 6B AD 05 00 91 8B FE FF 54 6E 52 00 B9 20 00 80 52 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_403_0 {
	meta:
		name = "?type_case_s@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 244
		refs = "0014 ??$extract_argument_from_va_list@PEADPEAD@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NAEAPEAD@Z 0054 ??$is_wide_character_specifier@_W@__crt_stdio_output@@YA_N_K_WW4length_modifier@0@@Z 0064 ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@ 0080 wcsnlen 0090 ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 61 22 01 91 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 32 00 00 14 68 7A 44 B9 1F 05 00 71 81 00 00 54 68 7E 44 B9 1F 05 00 71 61 05 00 54 68 0A 47 29 09 00 B0 12 61 86 40 79 60 02 40 F9 1F 05 00 31 34 01 88 1A ?? ?? ?? ?? 68 26 40 F9 80 01 00 34 88 00 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 68 26 00 F9 60 26 40 F9 28 00 80 52 81 7E 40 93 68 52 01 39 ?? ?? ?? ?? 60 52 00 B9 17 00 00 14 88 00 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 68 26 00 F9 6D 26 40 F9 0E 00 80 52 9F 02 00 71 CD 01 00 54 A9 01 C0 39 89 01 00 34 2C 1D 00 53 69 06 40 F9 2A 01 40 F9 4B 01 40 F9 6C D9 6C 78 4C 00 78 36 AD 05 00 91 CE 05 00 11 DF 01 14 6B AD 05 00 91 8B FE FF 54 6E 52 00 B9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_405_0 {
	meta:
		name = "?type_case_s_compute_narrow_string_length@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEBAHHD@Z"
		size = 32
		refs = "0010 strnlen"
		altNames = "?type_case_s_compute_narrow_string_length@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEBAHHD@Z ?type_case_s_compute_narrow_string_length@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEBAHHD@Z"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 00 24 40 F9 21 7C 40 93 ?? ?? ?? ?? 00 00 00 11 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_408_0 {
	meta:
		name = "?type_case_s_compute_narrow_string_length@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEBAHH_W@Z"
		size = 76
		altNames = "?type_case_s_compute_narrow_string_length@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEBAHH_W@Z ?type_case_s_compute_narrow_string_length@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEBAHH_W@Z"
	strings:
		$1 = { 0D 00 00 91 AC 25 40 F9 00 00 80 52 3F 00 00 71 CD 01 00 54 88 01 C0 39 88 01 00 34 0B 1D 00 53 A8 05 40 F9 09 01 40 F9 2A 01 40 F9 4B D9 6B 78 4B 00 78 36 8C 05 00 91 00 04 00 11 1F 00 01 6B 8C 05 00 91 8B FE FF 54 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_423_0 {
	meta:
		name = "?unset_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXI@Z"
		size = 20
		altNames = "?unset_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXI@Z ?unset_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXI@Z ?unset_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXI@Z ?unset_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXI@Z ?unset_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAAXI@Z"
	strings:
		$1 = { 08 30 40 B9 E9 03 21 2A 29 01 08 0A 09 30 00 B9 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_429_0 {
	meta:
		name = "?update_field_width@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
		size = 340
		refs = "0050 strtol 00b8 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z 00c0 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00c4 ??_C@_1IC@KGDNLBNC@?$AAw?$AAi?$AAd?$AAt?$AAh?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAi?$AAn?$AAt?$AAe?$AAr@ 00c8 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 00e4 _CrtDbgReportW 00f4 _errno 0100 ??_C@_1BAA@GLNFGJHK@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 0118 _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 13 00 00 91 68 7E 44 B9 1F 05 00 71 41 01 00 54 6A 12 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 68 81 5F B8 68 36 00 B9 42 00 00 14 60 0E 40 F9 42 01 80 52 FF 0B 00 F9 E1 43 00 91 ?? ?? ?? ?? EB 0B 40 F9 69 7A 44 B9 0A 04 00 51 68 05 00 91 68 0E 00 F9 3F 05 00 71 C1 05 00 54 8A 02 F8 37 68 01 C0 39 1F 91 00 71 21 02 00 54 5F 91 01 71 EA 01 00 54 68 EA 4D B9 49 7D 40 93 0B 03 80 D2 64 3E 40 B9 63 06 C1 39 22 00 80 52 60 02 00 91 5F 01 08 6B 48 C1 88 1A 68 EA 0D B9 28 4D 0B 9B 01 21 12 91 ?? ?? ?? ?? 23 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 9A 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 83 9A 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 0A 00 00 14 48 7D 40 93 09 03 80 D2 08 4D 09 9B 0A 49 42 F9 E9 03 0A CB 28 05 40 92 0A 69 6A B8 6A 36 00 B9 20 00 80 52 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_430_0 {
	meta:
		name = "?update_field_width@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
		size = 340
		refs = "0050 wcstol 00b8 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z 00c0 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00c4 ??_C@_1IC@KGDNLBNC@?$AAw?$AAi?$AAd?$AAt?$AAh?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAi?$AAn?$AAt?$AAe?$AAr@ 00c8 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 00e4 _CrtDbgReportW 00f4 _errno 0100 ??_C@_1BAM@KFMOOAFH@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 0118 _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 13 00 00 91 68 7E 44 B9 1F 05 00 71 41 01 00 54 6A 12 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 68 81 5F B8 68 36 00 B9 42 00 00 14 60 0E 40 F9 42 01 80 52 FF 0B 00 F9 E1 43 00 91 ?? ?? ?? ?? EB 0B 40 F9 69 7A 44 B9 0A 04 00 51 68 09 00 91 68 0E 00 F9 3F 05 00 71 C1 05 00 54 8A 02 F8 37 68 01 40 79 1F 91 00 71 21 02 00 54 5F 91 01 71 EA 01 00 54 68 EA 4D B9 49 7D 40 93 0B 03 80 D2 64 3E 40 B9 63 86 40 79 22 00 80 52 60 02 00 91 5F 01 08 6B 48 C1 88 1A 68 EA 0D B9 28 4D 0B 9B 01 21 12 91 ?? ?? ?? ?? 23 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 9A 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 83 9A 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 0A 00 00 14 48 7D 40 93 09 03 80 D2 08 4D 09 9B 0A 49 42 F9 E9 03 0A CB 28 05 40 92 0A 69 6A B8 6A 36 00 B9 20 00 80 52 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_431_0 {
	meta:
		name = "?update_field_width@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
		size = 40
		altNames = "?update_field_width@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
	strings:
		$1 = { 0A 10 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F B8 08 34 00 B9 20 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_433_0 {
	meta:
		name = "?update_precision@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
		size = 340
		refs = "0050 strtol 00b8 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z 00c0 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00c4 ??_C@_1JC@PMCLKCOC@?$AAp?$AAr?$AAe?$AAc?$AAi?$AAs?$AAi?$AAo?$AAn?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAi@ 00c8 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 00e4 _CrtDbgReportW 00f4 _errno 0100 ??_C@_1PM@DOKNBBLP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 0118 _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 13 00 00 91 68 7E 44 B9 1F 05 00 71 41 01 00 54 6A 12 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 68 81 5F B8 68 3A 00 B9 42 00 00 14 60 0E 40 F9 42 01 80 52 FF 0B 00 F9 E1 43 00 91 ?? ?? ?? ?? EB 0B 40 F9 69 7A 44 B9 0A 04 00 51 68 05 00 91 68 0E 00 F9 3F 05 00 71 C1 05 00 54 8A 02 F8 37 68 01 C0 39 1F 91 00 71 21 02 00 54 5F 91 01 71 EA 01 00 54 68 EA 4D B9 49 7D 40 93 0B 03 80 D2 64 3E 40 B9 63 06 C1 39 22 00 80 52 60 02 00 91 5F 01 08 6B 48 C1 88 1A 68 EA 0D B9 28 4D 0B 9B 01 21 12 91 ?? ?? ?? ?? 23 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 9E 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 83 9E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 0A 00 00 14 48 7D 40 93 09 03 80 D2 08 4D 09 9B 0A 49 42 F9 E9 03 0A CB 28 05 40 92 0A 69 6A B8 6A 3A 00 B9 20 00 80 52 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_434_0 {
	meta:
		name = "?update_precision@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
		size = 340
		refs = "0050 wcstol 00b8 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z 00c0 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00c4 ??_C@_1JC@PMCLKCOC@?$AAp?$AAr?$AAe?$AAc?$AAi?$AAs?$AAi?$AAo?$AAn?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAi@ 00c8 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 00e4 _CrtDbgReportW 00f4 _errno 0100 ??_C@_1BAI@EAAPMNON@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 0118 _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 13 00 00 91 68 7E 44 B9 1F 05 00 71 41 01 00 54 6A 12 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 6B 12 00 F9 68 81 5F B8 68 3A 00 B9 42 00 00 14 60 0E 40 F9 42 01 80 52 FF 0B 00 F9 E1 43 00 91 ?? ?? ?? ?? EB 0B 40 F9 69 7A 44 B9 0A 04 00 51 68 09 00 91 68 0E 00 F9 3F 05 00 71 C1 05 00 54 8A 02 F8 37 68 01 40 79 1F 91 00 71 21 02 00 54 5F 91 01 71 EA 01 00 54 68 EA 4D B9 49 7D 40 93 0B 03 80 D2 64 3E 40 B9 63 86 40 79 22 00 80 52 60 02 00 91 5F 01 08 6B 48 C1 88 1A 68 EA 0D B9 28 4D 0B 9B 01 21 12 91 ?? ?? ?? ?? 23 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 9E 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 83 9E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 0A 00 00 14 48 7D 40 93 09 03 80 D2 08 4D 09 9B 0A 49 42 F9 E9 03 0A CB 28 05 40 92 0A 69 6A B8 6A 3A 00 B9 20 00 80 52 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_435_0 {
	meta:
		name = "?update_precision@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
		size = 40
		altNames = "?update_precision@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
	strings:
		$1 = { 0A 10 40 F9 E8 03 0A CB 09 05 40 92 2A 01 0A 8B 4B 21 00 91 0B 10 00 F9 68 81 5F B8 08 38 00 B9 20 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_439_0 {
	meta:
		name = "?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z"
		size = 156
		refs = "0030 ?is_positional_parameter_reappearance_consistent@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEBUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z 0038 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 003c ??_C@_1LO@HECDHMMI@?$AAi?$AAs?$AA_?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AAe?$AAt?$AAe?$AAr?$AA_?$AAr?$AAe?$AAa?$AAp?$AAp?$AAe?$AAa?$AAr@ 0040 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 005c _CrtDbgReportW 006c _errno 0078 ??_C@_1BBO@KJOMOGDM@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 0090 _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 28 00 40 B9 08 01 00 35 22 00 00 B9 23 10 00 39 24 10 00 B9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 ?? ?? ?? ?? 60 FF FF 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 BF 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 BF 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 E3 FF FF 17 }
	condition:
		$1
}

rule file_35_440_0 {
	meta:
		name = "?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z"
		size = 156
		refs = "0030 ?is_positional_parameter_reappearance_consistent@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEBUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z 0038 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 003c ??_C@_1LO@HECDHMMI@?$AAi?$AAs?$AA_?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AAe?$AAt?$AAe?$AAr?$AA_?$AAr?$AAe?$AAa?$AAp?$AAp?$AAe?$AAa?$AAr@ 0040 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 005c _CrtDbgReportW 006c _errno 0078 ??_C@_1BCK@MLHIMABF@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 0090 _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 28 00 40 B9 08 01 00 35 22 00 00 B9 23 08 00 79 24 10 00 B9 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 ?? ?? ?? ?? 60 FF FF 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 BF 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 E3 BF 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 E3 FF FF 17 }
	condition:
		$1
}

rule file_35_441_0 {
	meta:
		name = "?validate_and_update_state_at_beginning_of_format_character@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
		size = 372
		refs = "0050 strtol 0084 memset 0110 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0114 ??_C@_1IC@NLEOMCDL@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAi?$AAn?$AAt?$AAe?$AAr@ 0118 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0134 _CrtDbgReportW 0144 _errno 0150 ??_C@_1BFA@OMCJIKHO@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 0168 _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 13 00 00 91 68 2E 40 B9 1F 05 00 71 41 07 00 54 60 0E 40 F9 09 00 C0 39 3F 95 00 71 C0 06 00 54 68 7E 44 B9 48 03 00 35 28 41 03 11 FF 0B 00 F9 09 1D 00 53 3F 25 00 71 68 02 00 54 42 01 80 52 E1 43 00 91 ?? ?? ?? ?? 1F 00 00 71 CD 01 00 54 E8 0B 40 F9 08 01 C0 39 1F 91 00 71 41 01 00 54 68 7A 44 B9 1F 05 00 71 A1 00 00 54 02 2C 81 D2 01 00 80 52 60 22 12 91 ?? ?? ?? ?? 48 00 80 52 02 00 00 14 28 00 80 52 68 7E 04 B9 68 7E 44 B9 1F 09 00 71 01 03 00 54 60 0E 40 F9 42 01 80 52 FF 0F 00 F9 E1 63 00 91 ?? ?? ?? ?? EB 0F 40 F9 69 7A 44 B9 0A 04 00 51 6A EE 0D B9 68 05 00 91 68 0E 00 F9 3F 05 00 71 61 01 00 54 CA 01 F8 37 68 01 C0 39 1F 91 00 71 61 01 00 54 5F 91 01 71 2A 01 00 54 68 EA 4D B9 5F 01 08 6B 48 C1 88 1A 68 EA 0D B9 20 00 80 52 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 02 AB 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 03 AB 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 E5 FF FF 17 }
	condition:
		$1
}

rule file_35_442_0 {
	meta:
		name = "?validate_and_update_state_at_beginning_of_format_character@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
		size = 376
		refs = "0054 wcstol 0088 memset 0114 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0118 ??_C@_1IC@NLEOMCDL@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAi?$AAn?$AAt?$AAe?$AAr@ 011c ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0138 _CrtDbgReportW 0148 _errno 0154 ??_C@_1BFM@OHMDOJHM@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 016c _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 13 00 00 91 68 2E 40 B9 1F 05 00 71 61 07 00 54 60 0E 40 F9 09 00 40 79 3F 95 00 71 E0 06 00 54 68 7E 44 B9 68 03 00 35 08 FA 9F 52 FF 0B 00 F9 28 01 08 0B 09 3D 00 53 3F 25 00 71 68 02 00 54 42 01 80 52 E1 43 00 91 ?? ?? ?? ?? 1F 00 00 71 CD 01 00 54 E8 0B 40 F9 08 01 40 79 1F 91 00 71 41 01 00 54 68 7A 44 B9 1F 05 00 71 A1 00 00 54 02 2C 81 D2 01 00 80 52 60 22 12 91 ?? ?? ?? ?? 48 00 80 52 02 00 00 14 28 00 80 52 68 7E 04 B9 68 7E 44 B9 1F 09 00 71 01 03 00 54 60 0E 40 F9 42 01 80 52 FF 0F 00 F9 E1 63 00 91 ?? ?? ?? ?? EB 0F 40 F9 69 7A 44 B9 0A 04 00 51 6A EE 0D B9 68 09 00 91 68 0E 00 F9 3F 05 00 71 61 01 00 54 CA 01 F8 37 68 01 40 79 1F 91 00 71 61 01 00 54 5F 91 01 71 2A 01 00 54 68 EA 4D B9 5F 01 08 6B 48 C1 88 1A 68 EA 0D B9 20 00 80 52 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 02 AB 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 03 AB 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 E5 FF FF 17 }
	condition:
		$1
}

rule file_35_445_0 {
	meta:
		name = "?validate_and_update_state_at_end_of_format_string@?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEBA_NXZ"
		size = 144
		refs = "001c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0020 ??_C@_1GC@BNMHNGKM@?$AA_?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?3?$AA?3?$AAn?$AAo?$AAr?$AAm?$AAa?$AAl?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA_?$AAs?$AAt?$AAa?$AAt@ 0024 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0040 _CrtDbgReportW 0050 _errno 005c ??_C@_1BDI@HCBOIIML@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAv?$AAa?$AAl?$AAi?$AAd@ 0074 _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 2C 40 B9 1F 01 00 71 04 19 47 7A 40 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 87 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 A3 87 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 02 00 00 14 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_446_0 {
	meta:
		name = "?validate_and_update_state_at_end_of_format_string@?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEBA_NXZ"
		size = 144
		refs = "001c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0020 ??_C@_1GC@BNMHNGKM@?$AA_?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?3?$AA?3?$AAn?$AAo?$AAr?$AAm?$AAa?$AAl?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA_?$AAs?$AAt?$AAa?$AAt@ 0024 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0040 _CrtDbgReportW 0050 _errno 005c ??_C@_1BEE@CEMEBAPI@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAv?$AAa?$AAl?$AAi?$AAd@ 0074 _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 2C 40 B9 1F 01 00 71 04 19 47 7A 40 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 87 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 A3 87 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 02 00 00 14 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_447_0 {
	meta:
		name = "?validate_and_update_state_at_end_of_format_string@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
		size = 352
		refs = "0010 ?validate_and_update_state_at_end_of_format_string@?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEBA_NXZ 00f0 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00f4 ??_C@_1FK@BCPANIEK@?$AA?$CI?$AA?$CC?$AAM?$AAi?$AAs?$AAs?$AAi?$AAn?$AAg?$AA?5?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAi?$AAn?$AA?5?$AAt?$AAh?$AAe?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt@ 00f8 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0114 _CrtDbgReportW 0124 _errno 0130 ??_C@_1BDO@LGKDLMJI@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 0148 _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 4E 00 00 14 68 7E 44 B9 1F 09 00 71 41 09 00 54 68 7A 44 B9 1F 05 00 71 E1 08 00 54 68 EA 8D B9 09 03 80 D2 63 22 12 91 08 4D 09 9B 02 81 12 91 7F 00 02 EB 00 08 00 54 69 12 40 F9 69 04 00 F9 6A 84 41 B8 5F 05 00 71 80 03 00 54 5F 09 00 71 60 02 00 54 5F 0D 00 71 40 01 00 54 5F 11 00 71 A1 03 00 54 6B 12 40 F9 E8 03 0B CB 0A 09 40 92 4B 01 0B 8B 6C 21 00 91 6C 12 00 F9 ED FF FF 17 6E 12 40 F9 E9 03 0E CB 2D 09 40 92 AE 01 0E 8B CF 21 00 91 6F 12 00 F9 E6 FF FF 17 65 12 40 F9 E7 03 05 CB E6 08 40 92 C8 00 05 8B 0A 21 00 91 6A 12 00 F9 DF FF FF 17 64 12 40 F9 EB 03 04 CB 6C 05 40 92 89 01 04 8B 2D 21 00 91 6D 12 00 F9 D8 FF FF 17 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 94 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 83 94 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B3 FF FF 17 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_448_0 {
	meta:
		name = "?validate_and_update_state_at_end_of_format_string@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
		size = 352
		refs = "0010 ?validate_and_update_state_at_end_of_format_string@?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEBA_NXZ 00f0 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00f4 ??_C@_1FK@BCPANIEK@?$AA?$CI?$AA?$CC?$AAM?$AAi?$AAs?$AAs?$AAi?$AAn?$AAg?$AA?5?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAi?$AAn?$AA?5?$AAt?$AAh?$AAe?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt@ 00f8 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0114 _CrtDbgReportW 0124 _errno 0130 ??_C@_1BEK@GJLBPCFH@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 0148 _invalid_parameter"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 4E 00 00 14 68 7E 44 B9 1F 09 00 71 41 09 00 54 68 7A 44 B9 1F 05 00 71 E1 08 00 54 68 EA 8D B9 09 03 80 D2 63 22 12 91 08 4D 09 9B 02 81 12 91 7F 00 02 EB 00 08 00 54 69 12 40 F9 69 04 00 F9 6A 84 41 B8 5F 05 00 71 80 03 00 54 5F 09 00 71 60 02 00 54 5F 0D 00 71 40 01 00 54 5F 11 00 71 A1 03 00 54 6B 12 40 F9 E8 03 0B CB 0A 09 40 92 4B 01 0B 8B 6C 21 00 91 6C 12 00 F9 ED FF FF 17 6E 12 40 F9 E9 03 0E CB 2D 09 40 92 AE 01 0E 8B CF 21 00 91 6F 12 00 F9 E6 FF FF 17 65 12 40 F9 E7 03 05 CB E6 08 40 92 C8 00 05 8B 0A 21 00 91 6A 12 00 F9 DF FF FF 17 64 12 40 F9 EB 03 04 CB 6C 05 40 92 89 01 04 8B 2D 21 00 91 6D 12 00 F9 D8 FF FF 17 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 94 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 83 94 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B3 FF FF 17 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_451_0 {
	meta:
		name = "?validate_state_for_type_case_a@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
		size = 200
		refs = "0030 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0034 ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0038 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0054 _CrtDbgReportW 0064 _errno 0070 ??_C@_1BBI@MNEKPAEI@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 0088 _invalid_parameter 00b0 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 09 00 71 21 05 00 54 08 78 44 B9 1F 05 00 71 C1 04 00 54 08 EC 4D B9 1F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 A1 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 A3 A1 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 0B 00 00 14 08 7D 40 93 04 3C 40 B9 09 03 80 D2 03 04 C1 39 09 01 09 9B 82 00 80 52 21 21 12 91 ?? ?? ?? ?? 02 00 00 14 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_452_0 {
	meta:
		name = "?validate_state_for_type_case_a@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IEAA_NXZ"
		size = 200
		refs = "0030 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0034 ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0038 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0054 _CrtDbgReportW 0064 _errno 0070 ??_C@_1BCE@KFLNEPIF@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 0088 _invalid_parameter 00b0 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AEAA_NAEAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 08 7C 44 B9 1F 09 00 71 21 05 00 54 08 78 44 B9 1F 05 00 71 C1 04 00 54 08 EC 4D B9 1F 8D 01 71 49 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 A1 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 A3 A1 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 0B 00 00 14 08 7D 40 93 04 3C 40 B9 09 03 80 D2 03 84 40 79 09 01 09 9B 82 00 80 52 21 21 12 91 ?? ?? ?? ?? 02 00 00 14 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_461_0 {
	meta:
		name = "?write_character@?$console_output_adapter@D@__crt_stdio_output@@QEBAXDQEAH@Z"
		size = 68
		refs = "0014 _putch_nolock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 20 00 00 11 53 00 00 91 ?? ?? ?? ?? 1F 04 00 31 81 00 00 54 08 00 80 12 68 02 00 B9 04 00 00 14 68 02 40 B9 09 05 00 11 69 02 00 B9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_462_0 {
	meta:
		name = "?write_character@?$console_output_adapter@_W@__crt_stdio_output@@QEBAX_WQEAH@Z"
		size = 72
		refs = "0014 _putwch_nolock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 20 00 00 11 53 00 00 91 ?? ?? ?? ?? E9 FF 9F 52 1F 00 09 6B 81 00 00 54 08 00 80 12 68 02 00 B9 04 00 00 14 68 02 40 B9 09 05 00 11 69 02 00 B9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_463_0 {
	meta:
		name = "?write_stored_string_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z"
		size = 200
		refs = "0010 __security_push_cookie 0050 wctomb_s 0070 ?write_string@?$console_output_adapter@D@__crt_stdio_output@@QEBAXQEBDHQEAHAEAV__crt_deferred_errno_cache@@@Z 00b4 __security_pop_cookie"
		altNames = "?write_stored_string_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z ?write_stored_string_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_ND@Z"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 13 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 00 D1 13 00 00 91 68 52 41 39 A8 03 00 34 68 52 40 B9 1F 01 00 71 4D 03 00 54 74 26 40 F9 15 00 80 52 A8 03 00 34 83 26 40 78 C2 00 80 D2 FF 03 00 B9 E1 23 00 91 E0 03 00 91 ?? ?? ?? ?? A0 01 00 35 E2 03 40 B9 62 01 00 34 64 42 00 91 63 A2 00 91 E1 23 00 91 60 A2 11 91 ?? ?? ?? ?? 68 52 40 B9 B5 06 00 11 BF 02 08 6B E1 FD FF 54 0A 00 00 14 08 00 80 12 68 2A 00 B9 07 00 00 14 62 52 40 B9 64 42 00 91 61 26 40 F9 63 A2 00 91 60 A2 11 91 ?? ?? ?? ?? 20 00 80 52 FF 43 00 91 ?? ?? ?? ?? F5 13 40 F9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_466_0 {
	meta:
		name = "?write_stored_string_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_N_W@Z"
		size = 220
		refs = "0054 _mbtowc_l 0068 _putwch_nolock 00c0 ?write_string@?$console_output_adapter@_W@__crt_stdio_output@@QEBAXQEB_WHQEAHAEAV__crt_deferred_errno_cache@@@Z"
		altNames = "?write_stored_string_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_N_W@Z ?write_stored_string_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_N_W@Z"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BE A9 FD 03 00 91 13 00 00 91 68 52 41 39 88 04 00 35 68 52 40 B9 1F 01 00 71 2D 04 00 54 75 26 40 F9 14 00 80 52 88 04 00 34 17 00 80 12 63 06 40 F9 FF 23 00 79 A1 02 00 91 E0 43 00 91 68 00 40 F9 02 09 80 B9 ?? ?? ?? ?? 16 00 00 11 DF 02 00 71 2D 02 00 54 E0 23 40 79 ?? ?? ?? ?? E9 FF 9F 52 1F 00 09 6B 61 00 00 54 77 2A 00 B9 04 00 00 14 68 2A 40 B9 09 05 00 11 69 2A 00 B9 6A 52 40 B9 94 06 00 11 B5 C2 36 8B 9F 02 0A 6B 01 FD FF 54 09 00 00 14 77 2A 00 B9 07 00 00 14 62 52 40 B9 64 42 00 91 61 26 40 F9 63 A2 00 91 60 A2 11 91 ?? ?? ?? ?? 20 00 80 52 FD 7B C2 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_469_0 {
	meta:
		name = "?write_string@?$console_output_adapter@D@__crt_stdio_output@@QEBAXQEBDHQEAHAEAV__crt_deferred_errno_cache@@@Z"
		size = 244
		refs = "0030 _errno 0058 _putch_nolock"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BF A9 FD 03 00 91 93 00 00 91 68 02 40 F9 37 00 00 91 58 00 00 11 74 00 00 91 68 00 00 B5 ?? ?? ?? ?? 60 02 00 F9 75 02 40 F9 F8 C2 38 8B FF 02 18 EB B6 02 40 B9 BF 02 00 B9 00 04 00 54 19 00 80 12 E0 16 C0 38 ?? ?? ?? ?? 1F 04 00 31 61 00 00 54 99 02 00 B9 06 00 00 14 88 02 40 B9 09 05 00 11 89 02 00 B9 3F 05 00 31 41 02 00 54 69 02 40 F9 69 00 00 B5 ?? ?? ?? ?? 60 02 00 F9 68 02 40 F9 09 01 40 B9 3F A9 00 71 81 01 00 54 E0 07 80 52 ?? ?? ?? ?? 1F 04 00 31 61 00 00 54 99 02 00 B9 04 00 00 14 88 02 40 B9 09 05 00 11 89 02 00 B9 FF 02 18 EB 61 FC FF 54 A8 02 40 B9 68 00 00 35 56 00 00 34 B6 02 00 B9 FD 7B C1 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_470_0 {
	meta:
		name = "?write_string@?$console_output_adapter@_W@__crt_stdio_output@@QEBAXQEB_WHQEAHAEAV__crt_deferred_errno_cache@@@Z"
		size = 256
		refs = "0030 _errno 005c _putwch_nolock"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BF A9 FD 03 00 91 93 00 00 91 68 02 40 F9 38 00 00 91 57 00 00 11 74 00 00 91 68 00 00 B5 ?? ?? ?? ?? 60 02 00 F9 75 02 40 F9 E8 7E 40 93 17 07 08 8B 1F 03 17 EB B6 02 40 B9 BF 02 00 B9 40 04 00 54 19 00 80 12 00 27 40 78 ?? ?? ?? ?? E9 FF 9F 52 1F 00 09 6B 61 00 00 54 99 02 00 B9 06 00 00 14 88 02 40 B9 09 05 00 11 89 02 00 B9 3F 05 00 31 61 02 00 54 69 02 40 F9 69 00 00 B5 ?? ?? ?? ?? 60 02 00 F9 68 02 40 F9 09 01 40 B9 3F A9 00 71 A1 01 00 54 E0 07 80 52 ?? ?? ?? ?? E9 FF 9F 52 1F 00 09 6B 61 00 00 54 99 02 00 B9 04 00 00 14 88 02 40 B9 09 05 00 11 89 02 00 B9 1F 03 17 EB 21 FC FF 54 A8 02 40 B9 68 00 00 35 56 00 00 34 B6 02 00 B9 FD 7B C1 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_471_0 {
	meta:
		name = "__acrt_isleadbyte_l_noupdate"
		size = 24
	strings:
		$1 = { 28 00 40 F9 0A 1C 00 53 09 01 40 F9 2A D9 6A 78 40 01 11 12 C0 03 5F D6 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "strncat"
		size = 216
	strings:
		$1 = { FF C3 00 D1 E0 07 00 F9 E1 0F 00 F9 E2 0B 00 F9 E8 07 40 F9 E8 13 00 F9 E8 07 40 F9 08 01 C0 39 08 01 00 11 E8 03 00 B9 E8 07 40 F9 08 05 00 91 E8 07 00 F9 E8 03 40 B9 1F 01 00 71 40 00 00 54 F6 FF FF 17 E8 07 40 F9 08 05 00 D1 E8 07 00 F9 E8 0B 40 F9 E8 17 00 F9 E8 0B 40 F9 08 05 00 D1 E8 0B 00 F9 E8 17 40 F9 1F 01 00 F1 A0 02 00 54 E9 07 40 F9 E8 0F 40 F9 08 01 C0 39 28 01 00 39 E8 07 40 F9 08 01 C0 39 08 01 00 11 E8 07 00 B9 E8 07 40 F9 08 05 00 91 E8 07 00 F9 E8 0F 40 F9 08 05 00 91 E8 0F 00 F9 E8 07 40 B9 1F 01 00 71 61 00 00 54 E0 13 40 F9 06 00 00 14 E5 FF FF 17 E9 07 40 F9 08 00 80 52 28 01 00 39 E0 13 40 F9 FF C3 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "_dscale"
		size = 1720
		refs = "00e4 _dnorm 0150 _Inf_C"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 E0 23 00 F9 E1 27 00 B9 E8 23 40 F9 E8 0F 00 F9 E8 0F 40 F9 08 19 00 91 08 01 40 79 08 01 00 11 08 29 1C 12 08 7D 04 13 08 3D 00 13 E8 43 00 79 E8 43 C0 79 08 01 00 11 1F FD 1F 71 61 04 00 54 E8 0F 40 F9 08 19 00 91 08 01 40 79 08 01 00 11 08 0D 00 12 1F 01 00 71 A1 02 00 54 E8 0F 40 F9 08 11 00 91 08 01 40 79 08 01 00 11 1F 01 00 71 E1 01 00 54 E8 0F 40 F9 08 09 00 91 08 01 40 79 08 01 00 11 1F 01 00 71 21 01 00 54 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F 01 00 71 81 00 00 54 28 00 80 52 E8 33 00 B9 03 00 00 14 48 00 80 52 E8 33 00 B9 E8 33 40 B9 00 3D 00 13 00 00 00 11 7A 01 00 14 11 00 00 14 E8 43 C0 79 08 01 00 11 1F 01 00 71 A1 01 00 54 E0 0F 40 F9 ?? ?? ?? ?? E0 5F 00 79 E8 5F C0 79 E8 43 00 79 E9 43 C0 79 29 01 00 11 08 00 80 52 1F 01 09 6B 6A 00 00 54 00 00 80 52 69 01 00 14 E9 27 40 B9 08 00 80 52 1F 01 09 6B 6A 03 00 54 E9 43 C0 79 29 01 00 11 E8 FF 80 52 09 01 09 4B E8 27 40 B9 3F 01 08 6B 8C 02 00 54 E8 0F 40 F9 08 19 00 91 08 01 40 79 08 01 00 11 C8 00 78 36 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E F0 27 00 FD 04 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? F0 27 00 FD E8 23 40 F9 F0 27 40 FD 10 01 00 FD 20 00 80 52 4C 01 00 14 4B 01 00 14 E8 43 C0 79 08 01 00 11 E9 03 08 4B E8 27 40 B9 3F 01 08 6B 6A 02 00 54 E8 0F 40 F9 08 19 00 91 08 01 40 79 08 01 00 11 0A 51 11 12 E9 43 C0 79 29 01 00 11 E8 27 40 B9 08 01 09 0B 08 6D 1C 53 48 01 08 2A 09 3D 00 53 E8 0F 40 F9 08 19 00 91 09 01 00 79 00 00 80 12 34 01 00 14 33 01 00 14 E8 0F 40 F9 08 19 00 91 08 01 40 79 08 01 00 11 08 01 11 12 08 3D 00 53 E8 53 00 79 E8 0F 40 F9 08 19 00 91 08 01 40 79 08 01 00 11 08 0D 00 12 08 01 1C 32 09 3D 00 53 E8 0F 40 F9 08 19 00 91 09 01 00 79 E8 43 C0 79 08 01 00 11 09 05 00 51 E8 27 40 B9 08 01 09 0B E8 27 00 B9 E8 27 40 B9 1F D5 00 31 AB 00 00 54 E9 27 40 B9 08 00 80 52 1F 01 09 6B 6C 02 00 54 E8 0F 40 F9 09 19 00 91 E8 53 40 79 28 01 00 79 E8 0F 40 F9 09 11 00 91 08 00 80 52 28 01 00 79 E8 0F 40 F9 09 09 00 91 08 00 80 52 28 01 00 79 E9 0F 40 F9 08 00 80 52 28 01 00 79 00 00 80 52 04 01 00 14 03 01 00 14 E8 27 40 B9 08 3D 00 13 E8 23 00 79 08 00 80 52 E8 47 00 79 06 00 00 14 E8 23 C0 79 08 01 00 11 08 41 00 11 08 3D 00 13 E8 23 00 79 E8 23 C0 79 08 01 00 11 1F 41 00 31 EC 04 00 54 E8 47 40 79 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 37 00 B9 03 00 00 14 08 00 80 52 E8 37 00 B9 E8 0F 40 F9 09 01 40 79 29 01 00 11 E8 37 40 B9 28 01 08 2A 08 3D 00 53 E8 47 00 79 E8 0F 40 F9 08 09 00 91 E9 0F 40 F9 08 01 40 79 28 01 00 79 E8 0F 40 F9 0A 11 00 91 E8 0F 40 F9 09 09 00 91 48 01 40 79 28 01 00 79 E8 0F 40 F9 0A 19 00 91 E8 0F 40 F9 09 11 00 91 48 01 40 79 28 01 00 79 E8 0F 40 F9 09 19 00 91 08 00 80 52 28 01 00 79 D2 FF FF 17 E8 23 C0 79 08 01 00 11 E8 03 08 4B 08 3D 00 13 E8 23 00 79 E8 23 C0 79 08 01 00 11 1F 01 00 71 A0 0B 00 54 E8 47 40 79 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 3B 00 B9 03 00 00 14 08 00 80 52 E8 3B 00 B9 E8 0F 40 F9 0A 01 40 79 4A 01 00 11 E9 23 C0 79 29 01 00 11 08 02 80 52 08 01 09 4B 49 21 C8 1A E8 3B 40 B9 28 01 08 2A 08 3D 00 53 E8 47 00 79 E8 0F 40 F9 09 01 40 79 29 01 00 11 E8 23 C0 79 08 01 00 11 2B 29 C8 1A E8 0F 40 F9 08 09 00 91 0A 01 40 79 4A 01 00 11 E9 23 C0 79 29 01 00 11 08 02 80 52 08 01 09 4B 48 21 C8 1A 68 01 08 2A 09 3D 00 53 E8 0F 40 F9 09 01 00 79 E8 0F 40 F9 08 09 00 91 09 01 40 79 29 01 00 11 E8 23 C0 79 08 01 00 11 2B 29 C8 1A E8 0F 40 F9 08 11 00 91 0A 01 40 79 4A 01 00 11 E9 23 C0 79 29 01 00 11 08 02 80 52 08 01 09 4B 48 21 C8 1A 68 01 08 2A 09 3D 00 53 E8 0F 40 F9 08 09 00 91 09 01 00 79 E8 0F 40 F9 08 11 00 91 09 01 40 79 29 01 00 11 E8 23 C0 79 08 01 00 11 2B 29 C8 1A E8 0F 40 F9 08 19 00 91 0A 01 40 79 4A 01 00 11 E9 23 C0 79 29 01 00 11 08 02 80 52 08 01 09 4B 48 21 C8 1A 68 01 08 2A 09 3D 00 53 E8 0F 40 F9 08 11 00 91 09 01 00 79 E8 0F 40 F9 0A 19 00 91 E8 23 C0 79 09 3D 00 53 48 01 40 79 08 25 C9 1A 09 3D 00 53 E8 0F 40 F9 08 19 00 91 09 01 00 79 E8 0F 40 F9 08 19 00 91 E9 53 40 79 29 01 00 11 08 01 40 79 08 01 00 11 0A 01 09 2A E8 0F 40 F9 09 19 00 91 48 3D 00 53 28 01 00 79 E9 47 40 79 29 01 00 11 08 00 90 52 1F 01 09 6B 4B 01 00 54 E9 47 40 79 29 01 00 11 08 00 90 52 1F 01 09 6B 01 07 00 54 E8 0F 40 F9 08 01 40 79 08 01 00 11 88 06 00 36 E8 0F 40 F9 08 01 40 79 08 05 00 11 09 3D 00 53 E8 0F 40 F9 09 01 00 79 E8 0F 40 F9 08 01 40 79 08 01 00 11 08 3D 00 12 1F 01 00 71 01 05 00 54 E8 0F 40 F9 08 09 00 91 08 01 40 79 08 05 00 11 08 3D 00 53 E8 57 00 79 E8 0F 40 F9 09 09 00 91 E8 57 40 79 28 01 00 79 E8 57 40 79 08 01 00 11 08 3D 00 12 1F 01 00 71 21 03 00 54 E8 0F 40 F9 08 11 00 91 08 01 40 79 08 05 00 11 08 3D 00 53 E8 5B 00 79 E8 0F 40 F9 09 11 00 91 E8 5B 40 79 28 01 00 79 E8 5B 40 79 08 01 00 11 08 3D 00 12 1F 01 00 71 41 01 00 54 E8 0F 40 F9 08 19 00 91 08 01 40 79 08 05 00 11 09 3D 00 53 E8 0F 40 F9 08 19 00 91 09 01 00 79 1C 00 00 14 E8 0F 40 F9 08 19 00 91 09 01 40 79 29 01 00 11 E8 53 40 79 08 01 00 11 3F 01 08 6B 81 02 00 54 E8 0F 40 F9 08 11 00 91 08 01 40 79 08 01 00 11 1F 01 00 71 C1 01 00 54 E8 0F 40 F9 08 09 00 91 08 01 40 79 08 01 00 11 1F 01 00 71 01 01 00 54 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F 01 00 71 61 00 00 54 00 00 80 52 02 00 00 14 00 00 80 12 FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_38_1_0 {
	meta:
		name = "_fdscale"
		size = 1248
		refs = "00b4 _fdnorm 0120 _FInf_C"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 E0 23 00 F9 E1 27 00 B9 E8 23 40 F9 E8 0F 00 F9 E8 0F 40 F9 08 09 00 91 08 01 40 79 08 01 00 11 08 1D 19 12 08 7D 07 13 08 3D 00 13 E8 27 00 79 E8 27 C0 79 08 01 00 11 1F FD 03 71 E1 02 00 54 E8 0F 40 F9 08 09 00 91 08 01 40 79 08 01 00 11 08 19 00 12 1F 01 00 71 21 01 00 54 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F 01 00 71 81 00 00 54 28 00 80 52 E8 2F 00 B9 03 00 00 14 48 00 80 52 E8 2F 00 B9 E8 2F 40 B9 00 3D 00 13 00 00 00 11 10 01 00 14 11 00 00 14 E8 27 C0 79 08 01 00 11 1F 01 00 71 A1 01 00 54 E0 0F 40 F9 ?? ?? ?? ?? E0 57 00 79 E8 57 C0 79 E8 27 00 79 E9 27 C0 79 29 01 00 11 08 00 80 52 1F 01 09 6B 6A 00 00 54 00 00 80 52 FF 00 00 14 E9 27 40 B9 08 00 80 52 1F 01 09 6B 6A 03 00 54 E9 27 C0 79 29 01 00 11 E8 1F 80 52 09 01 09 4B E8 27 40 B9 3F 01 08 6B 8C 02 00 54 E8 0F 40 F9 08 09 00 91 08 01 40 79 08 01 00 11 C8 00 78 36 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 21 1E F0 33 00 BD 04 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? F0 33 00 BD E8 23 40 F9 F0 33 40 BD 10 01 00 BD 20 00 80 52 E2 00 00 14 E1 00 00 14 E8 27 C0 79 08 01 00 11 E9 03 08 4B E8 27 40 B9 3F 01 08 6B 6A 02 00 54 E8 0F 40 F9 08 09 00 91 08 01 40 79 08 01 00 11 0A 5D 11 12 E9 27 C0 79 29 01 00 11 E8 27 40 B9 08 01 09 0B 08 61 19 53 48 01 08 2A 09 3D 00 53 E8 0F 40 F9 08 09 00 91 09 01 00 79 00 00 80 12 CA 00 00 14 C9 00 00 14 E8 0F 40 F9 08 09 00 91 08 01 40 79 08 01 00 11 08 01 11 12 08 3D 00 53 E8 53 00 79 E8 0F 40 F9 08 09 00 91 08 01 40 79 08 01 00 11 08 19 00 12 08 01 19 32 09 3D 00 53 E8 0F 40 F9 08 09 00 91 09 01 00 79 E8 27 C0 79 08 01 00 11 09 05 00 51 E8 27 40 B9 08 01 09 0B E8 27 00 B9 E8 27 40 B9 1F 61 00 31 AB 00 00 54 E9 27 40 B9 08 00 80 52 1F 01 09 6B 6C 01 00 54 E8 0F 40 F9 09 09 00 91 E8 53 40 79 28 01 00 79 E9 0F 40 F9 08 00 80 52 28 01 00 79 00 00 80 52 A2 00 00 14 A1 00 00 14 E8 27 40 B9 08 3D 00 13 E8 23 00 79 08 00 80 52 E8 43 00 79 E8 23 C0 79 08 01 00 11 1F 41 00 31 EC 03 00 54 E8 43 40 79 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 37 00 B9 03 00 00 14 08 00 80 52 E8 37 00 B9 E8 0F 40 F9 09 01 40 79 29 01 00 11 E8 37 40 B9 28 01 08 2A 08 3D 00 53 E8 43 00 79 E8 0F 40 F9 08 09 00 91 E9 0F 40 F9 08 01 40 79 28 01 00 79 E8 0F 40 F9 09 09 00 91 08 00 80 52 28 01 00 79 E8 23 C0 79 08 01 00 11 08 41 00 11 08 3D 00 13 E8 23 00 79 E8 23 C0 79 08 01 00 11 E8 03 08 4B 08 3D 00 13 E8 23 00 79 E8 23 C0 79 08 01 00 11 1F 01 00 71 60 06 00 54 E8 43 40 79 08 01 00 11 1F 01 00 71 80 00 00 54 28 00 80 52 E8 3B 00 B9 03 00 00 14 08 00 80 52 E8 3B 00 B9 E8 0F 40 F9 0A 01 40 79 4A 01 00 11 E9 23 C0 79 29 01 00 11 08 02 80 52 08 01 09 4B 49 21 C8 1A E8 3B 40 B9 28 01 08 2A 08 3D 00 53 E8 43 00 79 E8 0F 40 F9 09 01 40 79 29 01 00 11 E8 23 C0 79 08 01 00 11 2B 29 C8 1A E8 0F 40 F9 08 09 00 91 0A 01 40 79 4A 01 00 11 E9 23 C0 79 29 01 00 11 08 02 80 52 08 01 09 4B 48 21 C8 1A 68 01 08 2A 09 3D 00 53 E8 0F 40 F9 09 01 00 79 E8 0F 40 F9 0A 09 00 91 E8 23 C0 79 09 3D 00 53 48 01 40 79 08 25 C9 1A 09 3D 00 53 E8 0F 40 F9 08 09 00 91 09 01 00 79 E8 0F 40 F9 08 09 00 91 E9 53 40 79 29 01 00 11 08 01 40 79 08 01 00 11 0A 01 09 2A E8 0F 40 F9 09 09 00 91 48 3D 00 53 28 01 00 79 E9 43 40 79 29 01 00 11 08 00 90 52 1F 01 09 6B 4B 01 00 54 E9 43 40 79 29 01 00 11 08 00 90 52 1F 01 09 6B 41 03 00 54 E8 0F 40 F9 08 01 40 79 08 01 00 11 C8 02 00 36 E8 0F 40 F9 08 01 40 79 08 05 00 11 09 3D 00 53 E8 0F 40 F9 09 01 00 79 E8 0F 40 F9 08 01 40 79 08 01 00 11 08 3D 00 12 1F 01 00 71 41 01 00 54 E8 0F 40 F9 08 09 00 91 08 01 40 79 08 05 00 11 09 3D 00 53 E8 0F 40 F9 08 09 00 91 09 01 00 79 10 00 00 14 E8 0F 40 F9 08 09 00 91 09 01 40 79 29 01 00 11 E8 53 40 79 08 01 00 11 3F 01 08 6B 01 01 00 54 E8 0F 40 F9 08 01 40 79 08 01 00 11 1F 01 00 71 61 00 00 54 00 00 80 52 02 00 00 14 00 00 80 12 FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_38_2_0 {
	meta:
		name = "_ldscale"
		size = 44
		refs = "0018 _dscale"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E1 17 00 B9 E1 17 40 B9 E0 0F 40 F9 ?? ?? ?? ?? E0 23 00 79 E0 23 C0 79 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_39_3_0 {
	meta:
		name = "?_mbrtowc_s_l@@YAHPEAHPEA_WPEBD_KPEAU_Mbstatet@@PEAU__crt_locale_pointers@@@Z"
		size = 1684
		refs = "002c ??_C@_1CC@HOFKGKIJ@?$AAp?$AAm?$AAb?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0034 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0044 ??_C@_1GG@MCCIENJO@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 0050 _CrtDbgReportW 00f8 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0104 ?GetLocaleT@_LocaleUpdate@@QEAAPEAU__crt_locale_pointers@@XZ 0140 ??_C@_1GC@GKDIDINO@?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA_?$AAm?$AAb?$AA_?$AAc?$AAu?$AAr?$AA_?$AAm?$AAa?$AAx?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA1?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe@ 01f0 ??1_LocaleUpdate@@QEAA@XZ 0288 __imp_MultiByteToWideChar 02b4 _errno 0384 _isleadbyte_l 0420 strlen"
	strings:
		$1 = { FD 7B AD A9 FD 03 00 91 E0 0B 00 F9 E1 0F 00 F9 E2 17 00 F9 E3 57 00 F9 E4 1B 00 F9 E5 5B 00 F9 E8 1B 40 F9 1F 01 00 F1 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 22 07 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 47 00 B9 E9 47 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 0F 40 F9 1F 01 00 F1 80 00 00 54 E9 0F 40 F9 08 00 80 52 28 01 00 79 E8 17 40 F9 1F 01 00 F1 80 00 00 54 E8 57 40 F9 1F 01 00 F1 21 01 00 54 E8 0B 40 F9 1F 01 00 F1 80 00 00 54 E9 0B 40 F9 08 00 80 52 28 01 00 B9 00 00 80 52 75 01 00 14 E8 17 40 F9 08 01 C0 39 08 01 00 11 1F 01 00 71 21 01 00 54 E8 0B 40 F9 1F 01 00 F1 80 00 00 54 E9 0B 40 F9 08 00 80 52 28 01 00 B9 00 00 80 52 68 01 00 14 E1 5B 40 F9 E0 03 02 91 ?? ?? ?? ?? E0 97 00 F9 E0 03 02 91 ?? ?? ?? ?? E0 5F 00 F9 E8 5F 40 F9 08 01 00 91 08 01 40 F9 08 01 00 91 08 21 00 91 08 01 40 B9 E8 23 00 B9 E8 23 40 B9 1F 05 00 71 80 02 00 54 E8 23 40 B9 1F 09 00 71 20 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 09 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 4B 00 B9 E9 4B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E0 03 02 91 ?? ?? ?? ?? E0 63 00 F9 E8 63 40 F9 08 01 00 91 08 01 40 F9 08 E1 04 91 08 01 40 F9 1F 01 00 F1 C1 02 00 54 E8 0F 40 F9 1F 01 00 F1 E0 00 00 54 E8 17 40 F9 08 01 C0 39 09 1D 00 53 29 01 00 11 E8 0F 40 F9 09 01 00 79 E8 0B 40 F9 1F 01 00 F1 80 00 00 54 E9 0B 40 F9 28 00 80 52 28 01 00 B9 08 00 80 52 E8 4F 00 B9 E0 03 02 91 ?? ?? ?? ?? E0 4F 40 B9 25 01 00 14 E8 1B 40 F9 08 01 00 91 08 01 40 B9 1F 01 00 71 A0 0A 00 54 E8 1B 40 F9 09 05 00 91 E8 17 40 F9 08 01 C0 39 28 01 00 39 E8 23 40 B9 1F 05 00 71 CD 03 00 54 E8 0F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 3B 00 B9 03 00 00 14 08 00 80 52 E8 3B 00 B9 E0 03 02 91 ?? ?? ?? ?? E0 67 00 F9 E8 67 40 F9 08 01 00 91 08 01 40 F9 08 01 00 91 08 31 00 91 E5 3B 40 B9 E4 0F 40 F9 43 00 80 52 E2 1B 40 F9 21 01 80 52 00 01 40 B9 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 E0 53 00 B9 E8 53 40 B9 1F 01 00 71 E1 03 00 54 E8 1B 40 F9 09 01 00 91 08 00 80 52 28 01 00 B9 ?? ?? ?? ?? E0 6B 00 F9 E9 6B 40 F9 48 05 80 52 28 01 00 B9 E8 0F 40 F9 1F 01 00 F1 80 00 00 54 E9 0F 40 F9 08 00 80 52 28 01 00 79 E8 0B 40 F9 1F 01 00 F1 80 00 00 54 E9 0B 40 F9 08 00 80 12 28 01 00 B9 ?? ?? ?? ?? E0 6F 00 F9 E8 6F 40 F9 08 01 40 B9 E8 57 00 B9 E0 03 02 91 ?? ?? ?? ?? E0 57 40 B9 DD 00 00 14 E8 1B 40 F9 09 01 00 91 08 00 80 52 28 01 00 B9 E8 0B 40 F9 1F 01 00 F1 80 00 00 54 E9 0B 40 F9 E8 23 40 B9 28 01 00 B9 08 00 80 52 E8 5B 00 B9 E0 03 02 91 ?? ?? ?? ?? E0 5B 40 B9 CD 00 00 14 CA 00 00 14 E0 03 02 91 ?? ?? ?? ?? E0 73 00 F9 E8 17 40 F9 08 01 C0 39 00 1D 00 53 00 00 00 11 E1 73 40 F9 00 00 00 11 ?? ?? ?? ?? E0 5F 00 B9 E8 5F 40 B9 1F 01 00 71 20 0F 00 54 E8 23 40 B9 09 7D 40 93 E8 57 40 F9 1F 01 09 EB 42 02 00 54 E9 1B 40 F9 E8 17 40 F9 08 01 C0 39 28 01 00 39 E8 0B 40 F9 1F 01 00 F1 80 00 00 54 E9 0B 40 F9 28 00 80 12 28 01 00 B9 08 00 80 52 E8 63 00 B9 E0 03 02 91 ?? ?? ?? ?? E0 63 40 B9 A9 00 00 14 56 00 00 14 E8 23 40 B9 1F 05 00 71 ED 05 00 54 E8 0F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 3F 00 B9 03 00 00 14 08 00 80 52 E8 3F 00 B9 E0 17 40 F9 ?? ?? ?? ?? E0 77 00 F9 E9 7B 40 B2 E8 77 40 F9 1F 01 09 EB E2 00 00 54 E0 17 40 F9 ?? ?? ?? ?? E0 7B 00 F9 E8 7B 40 F9 E8 53 00 F9 03 00 00 14 E8 7B 40 B2 E8 53 00 F9 E0 03 02 91 ?? ?? ?? ?? E0 7F 00 F9 E8 53 40 F9 03 01 00 11 E8 7F 40 F9 08 01 00 91 08 01 40 F9 08 01 00 91 08 31 00 91 E5 3F 40 B9 E4 0F 40 F9 63 00 00 11 E2 17 40 F9 21 01 80 52 00 01 40 B9 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 E0 67 00 B9 E8 67 40 B9 1F 01 00 71 A1 04 00 54 E8 17 40 F9 08 05 00 91 08 01 C0 39 08 01 00 11 1F 01 00 71 E1 03 00 54 E8 1B 40 F9 09 01 00 91 08 00 80 52 28 01 00 B9 ?? ?? ?? ?? E0 83 00 F9 E9 83 40 F9 48 05 80 52 28 01 00 B9 E8 0F 40 F9 1F 01 00 F1 80 00 00 54 E9 0F 40 F9 08 00 80 52 28 01 00 79 E8 0B 40 F9 1F 01 00 F1 80 00 00 54 E9 0B 40 F9 08 00 80 12 28 01 00 B9 ?? ?? ?? ?? E0 87 00 F9 E8 87 40 F9 08 01 40 B9 E8 6B 00 B9 E0 03 02 91 ?? ?? ?? ?? E0 6B 40 B9 53 00 00 14 E8 0B 40 F9 1F 01 00 F1 80 00 00 54 E9 0B 40 F9 E8 23 40 B9 28 01 00 B9 08 00 80 52 E8 6F 00 B9 E0 03 02 91 ?? ?? ?? ?? E0 6F 40 B9 47 00 00 14 44 00 00 14 E8 0F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 43 00 B9 03 00 00 14 08 00 80 52 E8 43 00 B9 E0 03 02 91 ?? ?? ?? ?? E0 8B 00 F9 E8 8B 40 F9 08 01 00 91 08 01 40 F9 08 01 00 91 08 31 00 91 E5 43 40 B9 E4 0F 40 F9 23 00 80 52 E2 17 40 F9 21 01 80 52 00 01 40 B9 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 E0 73 00 B9 E8 73 40 B9 1F 01 00 71 61 03 00 54 ?? ?? ?? ?? E0 8F 00 F9 E9 8F 40 F9 48 05 80 52 28 01 00 B9 E8 0F 40 F9 1F 01 00 F1 80 00 00 54 E9 0F 40 F9 08 00 80 52 28 01 00 79 E8 0B 40 F9 1F 01 00 F1 80 00 00 54 E9 0B 40 F9 08 00 80 12 28 01 00 B9 ?? ?? ?? ?? E0 93 00 F9 E8 93 40 F9 08 01 40 B9 E8 77 00 B9 E0 03 02 91 ?? ?? ?? ?? E0 77 40 B9 0F 00 00 14 E8 0B 40 F9 1F 01 00 F1 80 00 00 54 E9 0B 40 F9 28 00 80 52 28 01 00 B9 08 00 80 52 E8 7B 00 B9 E0 03 02 91 ?? ?? ?? ?? E0 7B 40 B9 03 00 00 14 E0 03 02 91 ?? ?? ?? ?? FD 7B D3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_39_4_0 {
	meta:
		name = "?_mbsrtowcs_helper@@YA_KPEA_WPEAPEBD_KPEAU_Mbstatet@@@Z"
		size = 664
		refs = "004c ??_C@_1BM@DAAPEENN@?$AAp?$AAs?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0054 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0064 ??_C@_1GG@MCCIENJO@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 0070 _CrtDbgReportW 0098 _errno 00bc ??_C@_1CE@GMDJEGCL@?$AA_?$AAm?$AAb?$AAs?$AAr?$AAt?$AAo?$AAw?$AAc?$AAs?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 00cc _invalid_parameter 00fc ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0110 ?mbst@?1??_mbsrtowcs_helper@@YA_KPEA_WPEAPEBD_KPEAU_Mbstatet@@@Z@4U2@A 0150 ?GetLocaleT@_LocaleUpdate@@QEAAPEAU__crt_locale_pointers@@XZ 0170 ?_mbrtowc_s_l@@YAHPEAHPEA_WPEBD_KPEAU_Mbstatet@@PEAU__crt_locale_pointers@@@Z 018c ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { FD 7B B5 A9 FD 03 00 91 E0 1F 00 F9 E1 2B 00 F9 E2 27 00 F9 E3 1B 00 F9 E8 2B 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 2B 00 B9 03 00 00 14 08 00 80 52 E8 2B 00 B9 E8 2B 40 B9 E8 2F 00 B9 E8 2F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 23 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 47 00 B9 E9 47 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 2F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 2F 00 F9 E9 2F 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 23 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 92 6F 00 00 14 E8 2B 40 F9 08 01 40 F9 E8 0F 00 F9 08 00 80 52 E8 13 00 B9 08 00 80 D2 E8 13 00 F9 01 00 80 D2 E0 23 02 91 ?? ?? ?? ?? E0 57 00 F9 E8 1B 40 F9 1F 01 00 F1 81 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? E8 1B 00 F9 E8 1F 40 F9 1F 01 00 F1 01 05 00 54 09 00 00 14 E8 13 40 F9 08 05 00 91 E8 13 00 F9 E8 13 40 B9 09 7D 40 93 E8 0F 40 F9 08 01 09 8B E8 0F 00 F9 E0 23 02 91 ?? ?? ?? ?? E0 33 00 F9 E5 33 40 F9 E4 1B 40 F9 E3 7B 40 B2 E2 0F 40 F9 E1 03 01 91 E0 43 00 91 ?? ?? ?? ?? E8 13 40 B9 1F 01 00 71 0A 01 00 54 08 00 80 92 E8 37 00 F9 E0 23 02 91 ?? ?? ?? ?? E0 37 40 F9 3F 00 00 14 0A 00 00 14 E8 13 40 B9 1F 01 00 71 E1 00 00 54 E8 13 40 F9 E8 3B 00 F9 E0 23 02 91 ?? ?? ?? ?? E0 3B 40 F9 35 00 00 14 DB FF FF 17 0F 00 00 14 E8 13 40 F9 08 05 00 91 E8 13 00 F9 E8 13 40 B9 09 7D 40 93 E8 0F 40 F9 08 01 09 8B E8 0F 00 F9 E8 1F 40 F9 08 09 00 91 E8 1F 00 F9 E8 27 40 F9 08 05 00 D1 E8 27 00 F9 E9 27 40 F9 08 00 80 D2 1F 01 09 EB 22 03 00 54 E0 23 02 91 ?? ?? ?? ?? E0 3F 00 F9 E5 3F 40 F9 E4 1B 40 F9 E3 7B 40 B2 E2 0F 40 F9 E1 1F 40 F9 E0 43 00 91 ?? ?? ?? ?? E8 13 40 B9 1F 01 00 71 AA 00 00 54 08 00 80 92 E8 13 00 F9 09 00 00 14 07 00 00 14 E8 13 40 B9 1F 01 00 71 81 00 00 54 08 00 80 D2 E8 0F 00 F9 02 00 00 14 D7 FF FF 17 E9 2B 40 F9 E8 0F 40 F9 28 01 00 F9 E8 13 40 F9 E8 43 00 F9 E0 23 02 91 ?? ?? ?? ?? E0 43 40 F9 FD 7B CB A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_39_6_0 {
	meta:
		name = "btowc"
		size = 164
		refs = "0068 ?_mbrtowc_s_l@@YAHPEAHPEA_WPEBD_KPEAU_Mbstatet@@PEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 B9 E8 17 40 B9 1F 05 00 31 81 00 00 54 E0 FF 9F 52 20 00 00 14 1F 00 00 14 E8 17 40 B9 08 1D 00 13 E8 43 00 39 E9 83 00 91 29 01 00 91 08 00 80 D2 28 01 00 F9 08 00 80 52 E8 27 00 79 08 00 80 12 E8 1B 00 B9 05 00 80 D2 E4 83 00 91 23 00 80 D2 E2 43 00 91 E1 4B 00 91 E0 63 00 91 ?? ?? ?? ?? E8 1B 40 B9 1F 01 00 71 8A 00 00 54 E8 FF 9F 52 E8 1F 00 B9 04 00 00 14 E8 27 40 79 08 01 00 11 E8 1F 00 B9 E8 1F 40 B9 00 3D 00 53 00 00 00 11 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_39_7_0 {
	meta:
		name = "mbrlen"
		size = 112
		refs = "0034 ?mbst@?1??mbrlen@@9@4U_Mbstatet@@A 0058 ?_mbrtowc_s_l@@YAHPEAHPEA_WPEBD_KPEAU_Mbstatet@@PEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 17 00 F9 E2 0F 00 F9 08 00 80 12 E8 13 00 B9 E8 0F 40 F9 1F 01 00 F1 80 00 00 54 E8 0F 40 F9 E8 13 00 F9 04 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? E8 13 00 F9 05 00 80 D2 E4 13 40 F9 E3 17 40 F9 E2 1B 40 F9 01 00 80 D2 E0 43 00 91 ?? ?? ?? ?? E8 13 40 B9 00 7D 40 93 00 00 00 91 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_39_8_0 {
	meta:
		name = "mbrtowc"
		size = 200
		refs = "0044 ?mbst@?1??mbrtowc@@9@4U_Mbstatet@@A 0068 ?_mbrtowc_s_l@@YAHPEAHPEA_WPEBD_KPEAU_Mbstatet@@PEAU__crt_locale_pointers@@@Z 00a0 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 E0 23 00 F9 E1 17 00 F9 E2 1F 00 F9 E3 0F 00 F9 08 00 80 12 E8 13 00 B9 E8 17 40 F9 1F 01 00 F1 40 02 00 54 E8 0F 40 F9 1F 01 00 F1 80 00 00 54 E8 0F 40 F9 E8 13 00 F9 04 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? E8 13 00 F9 05 00 80 D2 E4 13 40 F9 E3 1F 40 F9 E2 17 40 F9 E1 23 40 F9 E0 43 00 91 ?? ?? ?? ?? 12 00 00 14 E8 0F 40 F9 1F 01 00 F1 80 00 00 54 E8 0F 40 F9 E8 1B 00 F9 04 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? E8 1B 00 F9 05 00 80 D2 E4 1B 40 F9 23 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? 01 00 80 D2 E0 43 00 91 ?? ?? ?? ?? E8 13 40 B9 00 7D 40 93 00 00 00 91 FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_39_9_0 {
	meta:
		name = "mbsrtowcs"
		size = 60
		refs = "0028 ?_mbsrtowcs_helper@@YA_KPEA_WPEAPEBD_KPEAU_Mbstatet@@@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E3 0B 00 F9 E3 0B 40 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 1B 00 F9 E0 1B 40 F9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_449_5_0 {
	meta:
		name = "_mbstowcs_l"
		size = 60
		refs = "0028 ?_mbstowcs_l_helper@@YA_KPEA_WPEBD_KPEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E3 0B 00 F9 E3 0B 40 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 1B 00 F9 E0 1B 40 F9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_167_7_0 {
	meta:
		name = "_wcstombs_l"
		size = 60
		refs = "0028 ?_wcstombs_l_helper@@YA_KPEADPEB_W_KPEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E3 0B 00 F9 E3 0B 40 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 1B 00 F9 E0 1B 40 F9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_349_9_0 {
	meta:
		name = "wcsrtombs"
		size = 60
		refs = "0028 internal_wcsrtombs"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E3 0B 00 F9 E3 0B 40 F9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 1B 00 F9 E0 1B 40 F9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_39_10_0 {
	meta:
		name = "mbsrtowcs_s"
		size = 1364
		refs = "0090 ??_C@_1JI@OGEJMCOI@?$AA?$CI?$AAd?$AAs?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAW?$AAo?$AAr?$AAd?$AAs?$AA?5?$AA?$DN@ 0098 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00a8 ??_C@_1GG@MCCIENJO@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 00b4 _CrtDbgReportW 00dc _errno 0100 ??_C@_1BI@GDNNFHAB@?$AAm?$AAb?$AAs?$AAr?$AAt?$AAo?$AAw?$AAc?$AAs?$AA_?$AAs?$AA?$AA@ 0110 _invalid_parameter 0160 _CrtGetDebugFillThreshold 01bc memset 01f4 ??_C@_1BM@DAAPEENN@?$AAp?$AAs?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 02b4 ?_mbsrtowcs_helper@@YA_KPEA_WPEAPEBD_KPEAU_Mbstatet@@@Z 0480 ??_C@_1CO@EPBLOHBA@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAW?$AAo?$AAr?$AAd?$AAs?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAr?$AAe?$AAt?$AAs?$AAi?$AAz?$AAe?$AA?$AA@"
	strings:
		$1 = { FD 7B B1 A9 FD 03 00 91 E0 23 00 F9 E1 0F 00 F9 E2 0B 00 F9 E3 3F 00 F9 E4 37 00 F9 E5 5F 00 F9 E8 23 40 F9 1F 01 00 F1 80 00 00 54 E9 23 40 F9 08 00 80 92 28 01 00 F9 E8 0F 40 F9 1F 01 00 F1 81 00 00 54 E8 0B 40 F9 1F 01 00 F1 40 01 00 54 E8 0F 40 F9 1F 01 00 F1 80 00 00 54 E8 0B 40 F9 1F 01 00 F1 88 00 00 54 08 00 80 52 E8 2B 00 B9 03 00 00 14 28 00 80 52 E8 2B 00 B9 E8 2B 40 B9 E8 2F 00 B9 E8 2F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 E2 30 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 4B 00 B9 E9 4B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 2F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 53 00 F9 E9 53 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 E3 30 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 0D 01 00 14 E8 0F 40 F9 1F 01 00 F1 E0 04 00 54 E9 0F 40 F9 08 00 80 52 28 01 00 79 E8 0B 40 F9 1F 05 00 B1 20 04 00 54 E9 7B 40 B2 E8 0B 40 F9 1F 01 09 EB A0 03 00 54 E9 0B 40 F9 28 00 80 D2 1F 01 09 EB 22 03 00 54 ?? ?? ?? ?? E0 57 00 F9 E8 57 40 F9 E8 2F 00 F9 E8 0B 40 F9 09 05 00 D1 E8 2F 40 F9 1F 01 09 EB 82 00 00 54 E8 2F 40 F9 E8 33 00 F9 04 00 00 14 E8 0B 40 F9 08 05 00 D1 E8 33 00 F9 E9 33 40 F9 48 00 80 D2 22 7D 08 9B E8 0F 40 F9 00 09 00 91 42 00 00 91 C1 1F 80 52 00 00 00 91 ?? ?? ?? ?? E8 3F 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 33 00 B9 03 00 00 14 08 00 80 52 E8 33 00 B9 E8 33 40 B9 E8 37 00 B9 E8 37 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 31 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 4F 00 B9 E9 4F 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 37 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 5B 00 F9 E9 5B 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 83 31 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 B4 00 00 14 E9 0B 40 F9 E8 37 40 F9 1F 01 09 EB 89 00 00 54 E8 0B 40 F9 E8 3B 00 F9 03 00 00 14 E8 37 40 F9 E8 3B 00 F9 E3 5F 40 F9 E2 3B 40 F9 E1 3F 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 63 00 F9 E8 63 40 F9 E8 13 00 F9 E8 13 40 F9 1F 05 00 B1 E1 05 00 54 E8 0F 40 F9 1F 01 00 F1 E0 04 00 54 E9 0F 40 F9 08 00 80 52 28 01 00 79 E8 0B 40 F9 1F 05 00 B1 20 04 00 54 E9 7B 40 B2 E8 0B 40 F9 1F 01 09 EB A0 03 00 54 E9 0B 40 F9 28 00 80 D2 1F 01 09 EB 22 03 00 54 ?? ?? ?? ?? E0 67 00 F9 E8 67 40 F9 E8 43 00 F9 E8 0B 40 F9 09 05 00 D1 E8 43 40 F9 1F 01 09 EB 82 00 00 54 E8 43 40 F9 E8 47 00 F9 04 00 00 14 E8 0B 40 F9 08 05 00 D1 E8 47 00 F9 E9 47 40 F9 48 00 80 D2 22 7D 08 9B E8 0F 40 F9 00 09 00 91 42 00 00 91 C1 1F 80 52 00 00 00 91 ?? ?? ?? ?? ?? ?? ?? ?? E0 6B 00 F9 E8 6B 40 F9 00 01 40 B9 72 00 00 14 E8 13 40 F9 08 05 00 91 E8 13 00 F9 E8 0F 40 F9 1F 01 00 F1 A0 0C 00 54 E9 0B 40 F9 E8 13 40 F9 1F 01 09 EB 29 0B 00 54 E9 0F 40 F9 08 00 80 52 28 01 00 79 E8 0B 40 F9 1F 05 00 B1 20 04 00 54 E9 7B 40 B2 E8 0B 40 F9 1F 01 09 EB A0 03 00 54 E9 0B 40 F9 28 00 80 D2 1F 01 09 EB 22 03 00 54 ?? ?? ?? ?? E0 6F 00 F9 E8 6F 40 F9 E8 4B 00 F9 E8 0B 40 F9 09 05 00 D1 E8 4B 40 F9 1F 01 09 EB 82 00 00 54 E8 4B 40 F9 E8 4F 00 F9 04 00 00 14 E8 0B 40 F9 08 05 00 D1 E8 4F 00 F9 E9 4F 40 F9 48 00 80 D2 22 7D 08 9B E8 0F 40 F9 00 09 00 91 42 00 00 91 C1 1F 80 52 00 00 00 91 ?? ?? ?? ?? E9 13 40 F9 E8 0B 40 F9 1F 01 09 EB 88 00 00 54 28 00 80 52 E8 3B 00 B9 03 00 00 14 08 00 80 52 E8 3B 00 B9 E8 3B 40 B9 E8 3F 00 B9 E8 3F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 34 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 53 00 B9 E9 53 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 3F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 73 00 F9 E9 73 40 F9 48 04 80 52 28 01 00 B9 04 00 80 D2 83 34 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 40 04 80 52 11 00 00 14 09 00 00 14 E8 13 40 F9 09 05 00 D1 48 00 80 D2 29 7D 08 9B E8 0F 40 F9 09 01 09 8B 08 00 80 52 28 01 00 79 E8 23 40 F9 1F 01 00 F1 80 00 00 54 E9 23 40 F9 E8 13 40 F9 28 01 00 F9 00 00 80 52 FD 7B CF A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "??$common_xtox@KD@@YAHKQEAD_KI_N@Z"
		size = 644
		refs = "0184 ??_C@_1CM@LONILNIJ@?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DM?$AA?5?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?$AA@ 018c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 019c ??_C@_1GA@HBEFGMHK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 01a8 _CrtDbgReportW 01d0 _errno 01f4 ??_C@_1BI@OLPLFKOE@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAx?$AAt?$AAo?$AAx?$AA?$AA@ 0204 _invalid_parameter"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 4B 00 B9 E1 2F 00 F9 E2 2B 00 F9 E3 33 00 B9 E4 63 00 39 E8 2F 40 F9 E8 0B 00 F9 08 00 80 D2 E8 17 00 F9 E8 4B 40 B9 E8 1F 00 B9 E8 63 40 39 08 01 00 11 1F 01 00 71 A0 01 00 54 E9 0B 40 F9 A8 05 80 52 28 01 00 39 E8 0B 40 F9 08 05 00 91 E8 0B 00 F9 E8 17 40 F9 08 05 00 91 E8 17 00 F9 E8 1F 40 B9 E8 03 08 4B E8 1F 00 B9 E8 0B 40 F9 E8 23 00 F9 EA 1F 40 B9 E9 33 40 B9 49 00 00 35 80 00 3E D4 48 09 C9 1A 08 7D 09 1B 48 01 08 4B E8 23 00 B9 E9 1F 40 B9 E8 33 40 B9 48 00 00 35 80 00 3E D4 28 09 C8 1A E8 1F 00 B9 E8 23 40 B9 1F 25 00 71 69 01 00 54 E8 23 40 B9 08 29 00 51 08 85 01 11 09 1D 00 13 E8 0B 40 F9 09 01 00 39 E8 0B 40 F9 08 05 00 91 E8 0B 00 F9 09 00 00 14 E8 23 40 B9 08 C1 00 11 09 1D 00 13 E8 0B 40 F9 09 01 00 39 E8 0B 40 F9 08 05 00 91 E8 0B 00 F9 E8 17 40 F9 08 05 00 91 E8 17 00 F9 E8 1F 40 B9 1F 01 00 71 A9 00 00 54 E9 2B 40 F9 E8 17 40 F9 1F 01 09 EB 83 FA FF 54 E9 2B 40 F9 E8 17 40 F9 1F 01 09 EB A3 06 00 54 E9 2F 40 F9 08 00 80 52 28 01 00 39 E9 2B 40 F9 E8 17 40 F9 1F 01 09 EB 82 00 00 54 28 00 80 52 E8 37 00 B9 03 00 00 14 08 00 80 52 E8 37 00 B9 E8 37 40 B9 E8 3B 00 B9 E8 3B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 0A 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 4F 00 B9 E9 4F 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 3B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 33 00 F9 E9 33 40 F9 48 04 80 52 28 01 00 B9 04 00 80 D2 63 0A 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 40 04 80 52 1C 00 00 14 E9 0B 40 F9 08 00 80 52 28 01 00 39 E8 0B 40 F9 08 05 00 D1 E8 0B 00 F9 E8 0B 40 F9 08 01 C0 39 E8 67 00 39 E9 0B 40 F9 E8 23 40 F9 08 01 C0 39 28 01 00 39 E9 23 40 F9 E8 67 C0 39 28 01 00 39 E8 0B 40 F9 08 05 00 D1 E8 0B 00 F9 E8 23 40 F9 08 05 00 91 E8 23 00 F9 E9 0B 40 F9 E8 23 40 F9 1F 01 09 EB A3 FD FF 54 00 00 80 52 FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_1_0 {
	meta:
		name = "??$common_xtox@K_W@@YAHKQEA_W_KI_N@Z"
		size = 644
		refs = "0184 ??_C@_1CM@LONILNIJ@?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DM?$AA?5?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?$AA@ 018c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 019c ??_C@_1GA@HBEFGMHK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 01a8 _CrtDbgReportW 01d0 _errno 01f4 ??_C@_1BI@OLPLFKOE@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAx?$AAt?$AAo?$AAx?$AA?$AA@ 0204 _invalid_parameter"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 4B 00 B9 E1 2F 00 F9 E2 2B 00 F9 E3 33 00 B9 E4 63 00 39 E8 2F 40 F9 E8 0B 00 F9 08 00 80 D2 E8 17 00 F9 E8 4B 40 B9 E8 1F 00 B9 E8 63 40 39 08 01 00 11 1F 01 00 71 A0 01 00 54 E9 0B 40 F9 A8 05 80 52 28 01 00 79 E8 0B 40 F9 08 09 00 91 E8 0B 00 F9 E8 17 40 F9 08 05 00 91 E8 17 00 F9 E8 1F 40 B9 E8 03 08 4B E8 1F 00 B9 E8 0B 40 F9 E8 23 00 F9 EA 1F 40 B9 E9 33 40 B9 49 00 00 35 80 00 3E D4 48 09 C9 1A 08 7D 09 1B 48 01 08 4B E8 27 00 B9 E9 1F 40 B9 E8 33 40 B9 48 00 00 35 80 00 3E D4 28 09 C8 1A E8 1F 00 B9 E8 27 40 B9 1F 25 00 71 69 01 00 54 E8 27 40 B9 08 29 00 51 08 85 01 11 09 3D 00 53 E8 0B 40 F9 09 01 00 79 E8 0B 40 F9 08 09 00 91 E8 0B 00 F9 09 00 00 14 E8 27 40 B9 08 C1 00 11 09 3D 00 53 E8 0B 40 F9 09 01 00 79 E8 0B 40 F9 08 09 00 91 E8 0B 00 F9 E8 17 40 F9 08 05 00 91 E8 17 00 F9 E8 1F 40 B9 1F 01 00 71 A9 00 00 54 E9 2B 40 F9 E8 17 40 F9 1F 01 09 EB 83 FA FF 54 E9 2B 40 F9 E8 17 40 F9 1F 01 09 EB A3 06 00 54 E9 2F 40 F9 08 00 80 52 28 01 00 79 E9 2B 40 F9 E8 17 40 F9 1F 01 09 EB 82 00 00 54 28 00 80 52 E8 37 00 B9 03 00 00 14 08 00 80 52 E8 37 00 B9 E8 37 40 B9 E8 3B 00 B9 E8 3B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 0A 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 4F 00 B9 E9 4F 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 3B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 33 00 F9 E9 33 40 F9 48 04 80 52 28 01 00 B9 04 00 80 D2 63 0A 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 40 04 80 52 1C 00 00 14 E9 0B 40 F9 08 00 80 52 28 01 00 79 E8 0B 40 F9 08 09 00 D1 E8 0B 00 F9 E8 0B 40 F9 08 01 40 79 E8 43 00 79 E9 0B 40 F9 E8 23 40 F9 08 01 40 79 28 01 00 79 E9 23 40 F9 E8 43 40 79 28 01 00 79 E8 0B 40 F9 08 09 00 D1 E8 0B 00 F9 E8 23 40 F9 08 09 00 91 E8 23 00 F9 E9 0B 40 F9 E8 23 40 F9 1F 01 09 EB A3 FD FF 54 00 00 80 52 FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_2_0 {
	meta:
		name = "??$common_xtox@_KD@@YAH_KQEAD0I_N@Z"
		size = 656
		refs = "0190 ??_C@_1CM@LONILNIJ@?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DM?$AA?5?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?$AA@ 0198 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 01a8 ??_C@_1GA@HBEFGMHK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 01b4 _CrtDbgReportW 01dc _errno 0200 ??_C@_1BI@OLPLFKOE@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAx?$AAt?$AAo?$AAx?$AA?$AA@ 0210 _invalid_parameter"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 33 00 F9 E1 2F 00 F9 E2 2B 00 F9 E3 33 00 B9 E4 63 00 39 E8 2F 40 F9 E8 0B 00 F9 08 00 80 D2 E8 13 00 F9 E8 33 40 F9 E8 17 00 F9 E8 63 40 39 08 01 00 11 1F 01 00 71 A0 01 00 54 E9 0B 40 F9 A8 05 80 52 28 01 00 39 E8 0B 40 F9 08 05 00 91 E8 0B 00 F9 E8 13 40 F9 08 05 00 91 E8 13 00 F9 E8 17 40 F9 E8 03 08 CB E8 17 00 F9 E8 0B 40 F9 E8 23 00 F9 E8 33 40 B9 0A 7D 40 D3 E9 17 40 F9 4A 00 00 B5 80 00 3E D4 28 09 CA 9A 08 7D 0A 9B 28 01 08 CB 08 01 00 11 E8 1F 00 B9 E8 33 40 B9 09 7D 40 D3 E8 17 40 F9 49 00 00 B5 80 00 3E D4 08 09 C9 9A E8 17 00 F9 E8 1F 40 B9 1F 25 00 71 69 01 00 54 E8 1F 40 B9 08 29 00 51 08 85 01 11 09 1D 00 13 E8 0B 40 F9 09 01 00 39 E8 0B 40 F9 08 05 00 91 E8 0B 00 F9 09 00 00 14 E8 1F 40 B9 08 C1 00 11 09 1D 00 13 E8 0B 40 F9 09 01 00 39 E8 0B 40 F9 08 05 00 91 E8 0B 00 F9 E8 13 40 F9 08 05 00 91 E8 13 00 F9 E8 17 40 F9 1F 01 00 F1 A9 00 00 54 E9 2B 40 F9 E8 13 40 F9 1F 01 09 EB 23 FA FF 54 E9 2B 40 F9 E8 13 40 F9 1F 01 09 EB A3 06 00 54 E9 2F 40 F9 08 00 80 52 28 01 00 39 E9 2B 40 F9 E8 13 40 F9 1F 01 09 EB 82 00 00 54 28 00 80 52 E8 37 00 B9 03 00 00 14 08 00 80 52 E8 37 00 B9 E8 37 40 B9 E8 3B 00 B9 E8 3B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 0A 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 4B 00 B9 E9 4B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 3B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 37 00 F9 E9 37 40 F9 48 04 80 52 28 01 00 B9 04 00 80 D2 63 0A 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 40 04 80 52 1C 00 00 14 E9 0B 40 F9 08 00 80 52 28 01 00 39 E8 0B 40 F9 08 05 00 D1 E8 0B 00 F9 E8 0B 40 F9 08 01 C0 39 E8 67 00 39 E9 0B 40 F9 E8 23 40 F9 08 01 C0 39 28 01 00 39 E9 23 40 F9 E8 67 C0 39 28 01 00 39 E8 0B 40 F9 08 05 00 D1 E8 0B 00 F9 E8 23 40 F9 08 05 00 91 E8 23 00 F9 E9 0B 40 F9 E8 23 40 F9 1F 01 09 EB A3 FD FF 54 00 00 80 52 FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_3_0 {
	meta:
		name = "??$common_xtox@_K_W@@YAH_KQEA_W0I_N@Z"
		size = 656
		refs = "0190 ??_C@_1CM@LONILNIJ@?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DM?$AA?5?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?$AA@ 0198 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 01a8 ??_C@_1GA@HBEFGMHK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 01b4 _CrtDbgReportW 01dc _errno 0200 ??_C@_1BI@OLPLFKOE@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAx?$AAt?$AAo?$AAx?$AA?$AA@ 0210 _invalid_parameter"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 33 00 F9 E1 2F 00 F9 E2 2B 00 F9 E3 33 00 B9 E4 63 00 39 E8 2F 40 F9 E8 0B 00 F9 08 00 80 D2 E8 13 00 F9 E8 33 40 F9 E8 17 00 F9 E8 63 40 39 08 01 00 11 1F 01 00 71 A0 01 00 54 E9 0B 40 F9 A8 05 80 52 28 01 00 79 E8 0B 40 F9 08 09 00 91 E8 0B 00 F9 E8 13 40 F9 08 05 00 91 E8 13 00 F9 E8 17 40 F9 E8 03 08 CB E8 17 00 F9 E8 0B 40 F9 E8 23 00 F9 E8 33 40 B9 0A 7D 40 D3 E9 17 40 F9 4A 00 00 B5 80 00 3E D4 28 09 CA 9A 08 7D 0A 9B 28 01 08 CB 08 01 00 11 E8 1F 00 B9 E8 33 40 B9 09 7D 40 D3 E8 17 40 F9 49 00 00 B5 80 00 3E D4 08 09 C9 9A E8 17 00 F9 E8 1F 40 B9 1F 25 00 71 69 01 00 54 E8 1F 40 B9 08 29 00 51 08 85 01 11 09 3D 00 53 E8 0B 40 F9 09 01 00 79 E8 0B 40 F9 08 09 00 91 E8 0B 00 F9 09 00 00 14 E8 1F 40 B9 08 C1 00 11 09 3D 00 53 E8 0B 40 F9 09 01 00 79 E8 0B 40 F9 08 09 00 91 E8 0B 00 F9 E8 13 40 F9 08 05 00 91 E8 13 00 F9 E8 17 40 F9 1F 01 00 F1 A9 00 00 54 E9 2B 40 F9 E8 13 40 F9 1F 01 09 EB 23 FA FF 54 E9 2B 40 F9 E8 13 40 F9 1F 01 09 EB A3 06 00 54 E9 2F 40 F9 08 00 80 52 28 01 00 79 E9 2B 40 F9 E8 13 40 F9 1F 01 09 EB 82 00 00 54 28 00 80 52 E8 37 00 B9 03 00 00 14 08 00 80 52 E8 37 00 B9 E8 37 40 B9 E8 3B 00 B9 E8 3B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 0A 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 4B 00 B9 E9 4B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 3B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 37 00 F9 E9 37 40 F9 48 04 80 52 28 01 00 B9 04 00 80 D2 63 0A 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 40 04 80 52 1C 00 00 14 E9 0B 40 F9 08 00 80 52 28 01 00 79 E8 0B 40 F9 08 09 00 D1 E8 0B 00 F9 E8 0B 40 F9 08 01 40 79 E8 37 00 79 E9 0B 40 F9 E8 23 40 F9 08 01 40 79 28 01 00 79 E9 23 40 F9 E8 37 40 79 28 01 00 79 E8 0B 40 F9 08 09 00 D1 E8 0B 00 F9 E8 23 40 F9 08 09 00 91 E8 23 00 F9 E9 0B 40 F9 E8 23 40 F9 1F 01 09 EB A3 FD FF 54 00 00 80 52 FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_4_0 {
	meta:
		name = "??$common_xtox_s@KD@@YAHKQEAD_KI_N@Z"
		size = 1036
		refs = "0050 ??_C@_1CE@MCCHPLBM@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1GA@HBEFGMHK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 0074 _CrtDbgReportW 009c _errno 00c0 ??_C@_1BM@HMPEMLNP@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAx?$AAt?$AAo?$AAx?$AA_?$AAs?$AA?$AA@ 00d0 _invalid_parameter 0110 ??_C@_1CC@ONIJBMJF@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 01d4 _CrtGetDebugFillThreshold 0224 memset 0288 ??_C@_1HA@JFIOFNKD@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AAs?$AAt?$AAa?$AAt?$AAi?$AAc?$AA_?$AAc?$AAa?$AAs?$AAt?$AA?$DM?$AAs?$AAi?$AAz?$AAe?$AA_@ 0358 ??_C@_1DE@PCJGDBBD@?$AA2?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA3?$AA6?$AA?$AA@ 03f8 ??$common_xtox@KD@@YAHKQEAD_KI_N@Z"
	strings:
		$1 = { FD 7B B6 A9 FD 03 00 91 E0 63 00 B9 E1 27 00 F9 E2 0F 00 F9 E3 23 00 B9 E4 43 00 39 E8 27 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 27 00 B9 03 00 00 14 08 00 80 52 E8 27 00 B9 E8 27 40 B9 E8 2B 00 B9 E8 2B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 53 00 B9 E9 53 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 2B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 3F 00 F9 E9 3F 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 43 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 CB 00 00 14 E8 0F 40 F9 1F 01 00 F1 89 00 00 54 28 00 80 52 E8 2F 00 B9 03 00 00 14 08 00 80 52 E8 2F 00 B9 E8 2F 40 B9 E8 33 00 B9 E8 33 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 57 00 B9 E9 57 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 33 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 43 00 F9 E9 43 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 63 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 9B 00 00 14 E9 27 40 F9 08 00 80 52 28 01 00 39 E8 0F 40 F9 1F 05 00 B1 C0 03 00 54 E9 7B 40 B2 E8 0F 40 F9 1F 01 09 EB 40 03 00 54 E9 0F 40 F9 28 00 80 D2 1F 01 09 EB C2 02 00 54 ?? ?? ?? ?? E0 47 00 F9 E8 47 40 F9 E8 37 00 F9 E8 0F 40 F9 09 05 00 D1 E8 37 40 F9 1F 01 09 EB 82 00 00 54 E8 37 40 F9 E8 3B 00 F9 04 00 00 14 E8 0F 40 F9 08 05 00 D1 E8 3B 00 F9 E8 27 40 F9 00 05 00 91 E2 3B 40 F9 C1 1F 80 52 00 00 00 91 ?? ?? ?? ?? E8 43 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 48 00 80 52 E8 37 00 B9 03 00 00 14 28 00 80 52 E8 37 00 B9 E8 37 40 B9 09 7D 40 93 E8 0F 40 F9 1F 01 09 EB 89 00 00 54 28 00 80 52 E8 3B 00 B9 03 00 00 14 08 00 80 52 E8 3B 00 B9 E8 3B 40 B9 E8 3F 00 B9 E8 3F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 5B 00 B9 E9 5B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 3F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 4B 00 F9 E9 4B 40 F9 48 04 80 52 28 01 00 B9 04 00 80 D2 A3 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 40 04 80 52 3D 00 00 14 E9 23 40 B9 48 00 80 52 1F 01 09 6B E8 00 00 54 E8 23 40 B9 1F 91 00 71 88 00 00 54 28 00 80 52 E8 43 00 B9 03 00 00 14 08 00 80 52 E8 43 00 B9 E8 43 40 B9 E8 47 00 B9 E8 47 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 5F 00 B9 E9 5F 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 47 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 4F 00 F9 E9 4F 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 09 00 00 14 E4 43 40 39 E3 23 40 B9 E2 0F 40 F9 E1 27 40 F9 E0 63 40 B9 ?? ?? ?? ?? E0 67 00 B9 E0 67 40 B9 FD 7B CA A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_5_0 {
	meta:
		name = "??$common_xtox_s@K_W@@YAHKQEA_W_KI_N@Z"
		size = 1048
		refs = "0050 ??_C@_1CE@MCCHPLBM@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1GA@HBEFGMHK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 0074 _CrtDbgReportW 009c _errno 00c0 ??_C@_1BM@HMPEMLNP@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAx?$AAt?$AAo?$AAx?$AA_?$AAs?$AA?$AA@ 00d0 _invalid_parameter 0110 ??_C@_1CC@ONIJBMJF@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 01d4 _CrtGetDebugFillThreshold 0230 memset 0294 ??_C@_1HA@JFIOFNKD@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AAs?$AAt?$AAa?$AAt?$AAi?$AAc?$AA_?$AAc?$AAa?$AAs?$AAt?$AA?$DM?$AAs?$AAi?$AAz?$AAe?$AA_@ 0364 ??_C@_1DE@PCJGDBBD@?$AA2?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA3?$AA6?$AA?$AA@ 0404 ??$common_xtox@K_W@@YAHKQEA_W_KI_N@Z"
	strings:
		$1 = { FD 7B B6 A9 FD 03 00 91 E0 63 00 B9 E1 27 00 F9 E2 0F 00 F9 E3 23 00 B9 E4 43 00 39 E8 27 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 27 00 B9 03 00 00 14 08 00 80 52 E8 27 00 B9 E8 27 40 B9 E8 2B 00 B9 E8 2B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 53 00 B9 E9 53 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 2B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 3F 00 F9 E9 3F 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 43 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 CE 00 00 14 E8 0F 40 F9 1F 01 00 F1 89 00 00 54 28 00 80 52 E8 2F 00 B9 03 00 00 14 08 00 80 52 E8 2F 00 B9 E8 2F 40 B9 E8 33 00 B9 E8 33 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 57 00 B9 E9 57 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 33 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 43 00 F9 E9 43 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 63 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 9E 00 00 14 E9 27 40 F9 08 00 80 52 28 01 00 79 E8 0F 40 F9 1F 05 00 B1 20 04 00 54 E9 7B 40 B2 E8 0F 40 F9 1F 01 09 EB A0 03 00 54 E9 0F 40 F9 28 00 80 D2 1F 01 09 EB 22 03 00 54 ?? ?? ?? ?? E0 47 00 F9 E8 47 40 F9 E8 37 00 F9 E8 0F 40 F9 09 05 00 D1 E8 37 40 F9 1F 01 09 EB 82 00 00 54 E8 37 40 F9 E8 3B 00 F9 04 00 00 14 E8 0F 40 F9 08 05 00 D1 E8 3B 00 F9 E9 3B 40 F9 48 00 80 D2 22 7D 08 9B E8 27 40 F9 00 09 00 91 42 00 00 91 C1 1F 80 52 00 00 00 91 ?? ?? ?? ?? E8 43 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 48 00 80 52 E8 37 00 B9 03 00 00 14 28 00 80 52 E8 37 00 B9 E8 37 40 B9 09 7D 40 93 E8 0F 40 F9 1F 01 09 EB 89 00 00 54 28 00 80 52 E8 3B 00 B9 03 00 00 14 08 00 80 52 E8 3B 00 B9 E8 3B 40 B9 E8 3F 00 B9 E8 3F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 5B 00 B9 E9 5B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 3F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 4B 00 F9 E9 4B 40 F9 48 04 80 52 28 01 00 B9 04 00 80 D2 A3 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 40 04 80 52 3D 00 00 14 E9 23 40 B9 48 00 80 52 1F 01 09 6B E8 00 00 54 E8 23 40 B9 1F 91 00 71 88 00 00 54 28 00 80 52 E8 43 00 B9 03 00 00 14 08 00 80 52 E8 43 00 B9 E8 43 40 B9 E8 47 00 B9 E8 47 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 5F 00 B9 E9 5F 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 47 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 4F 00 F9 E9 4F 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 09 00 00 14 E4 43 40 39 E3 23 40 B9 E2 0F 40 F9 E1 27 40 F9 E0 63 40 B9 ?? ?? ?? ?? E0 67 00 B9 E0 67 40 B9 FD 7B CA A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_6_0 {
	meta:
		name = "??$common_xtox_s@_KD@@YAH_KQEAD0I_N@Z"
		size = 1036
		refs = "0050 ??_C@_1CE@MCCHPLBM@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1GA@HBEFGMHK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 0074 _CrtDbgReportW 009c _errno 00c0 ??_C@_1BM@HMPEMLNP@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAx?$AAt?$AAo?$AAx?$AA_?$AAs?$AA?$AA@ 00d0 _invalid_parameter 0110 ??_C@_1CC@ONIJBMJF@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 01d4 _CrtGetDebugFillThreshold 0224 memset 0288 ??_C@_1HA@JFIOFNKD@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AAs?$AAt?$AAa?$AAt?$AAi?$AAc?$AA_?$AAc?$AAa?$AAs?$AAt?$AA?$DM?$AAs?$AAi?$AAz?$AAe?$AA_@ 0358 ??_C@_1DE@PCJGDBBD@?$AA2?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA3?$AA6?$AA?$AA@ 03f8 ??$common_xtox@_KD@@YAH_KQEAD0I_N@Z"
	strings:
		$1 = { FD 7B B5 A9 FD 03 00 91 E0 53 00 F9 E1 27 00 F9 E2 0F 00 F9 E3 23 00 B9 E4 43 00 39 E8 27 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 27 00 B9 03 00 00 14 08 00 80 52 E8 27 00 B9 E8 27 40 B9 E8 2B 00 B9 E8 2B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 53 00 B9 E9 53 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 2B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 3F 00 F9 E9 3F 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 43 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 CB 00 00 14 E8 0F 40 F9 1F 01 00 F1 89 00 00 54 28 00 80 52 E8 2F 00 B9 03 00 00 14 08 00 80 52 E8 2F 00 B9 E8 2F 40 B9 E8 33 00 B9 E8 33 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 57 00 B9 E9 57 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 33 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 43 00 F9 E9 43 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 63 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 9B 00 00 14 E9 27 40 F9 08 00 80 52 28 01 00 39 E8 0F 40 F9 1F 05 00 B1 C0 03 00 54 E9 7B 40 B2 E8 0F 40 F9 1F 01 09 EB 40 03 00 54 E9 0F 40 F9 28 00 80 D2 1F 01 09 EB C2 02 00 54 ?? ?? ?? ?? E0 47 00 F9 E8 47 40 F9 E8 37 00 F9 E8 0F 40 F9 09 05 00 D1 E8 37 40 F9 1F 01 09 EB 82 00 00 54 E8 37 40 F9 E8 3B 00 F9 04 00 00 14 E8 0F 40 F9 08 05 00 D1 E8 3B 00 F9 E8 27 40 F9 00 05 00 91 E2 3B 40 F9 C1 1F 80 52 00 00 00 91 ?? ?? ?? ?? E8 43 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 48 00 80 52 E8 37 00 B9 03 00 00 14 28 00 80 52 E8 37 00 B9 E8 37 40 B9 09 7D 40 93 E8 0F 40 F9 1F 01 09 EB 89 00 00 54 28 00 80 52 E8 3B 00 B9 03 00 00 14 08 00 80 52 E8 3B 00 B9 E8 3B 40 B9 E8 3F 00 B9 E8 3F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 5B 00 B9 E9 5B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 3F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 4B 00 F9 E9 4B 40 F9 48 04 80 52 28 01 00 B9 04 00 80 D2 A3 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 40 04 80 52 3D 00 00 14 E9 23 40 B9 48 00 80 52 1F 01 09 6B E8 00 00 54 E8 23 40 B9 1F 91 00 71 88 00 00 54 28 00 80 52 E8 43 00 B9 03 00 00 14 08 00 80 52 E8 43 00 B9 E8 43 40 B9 E8 47 00 B9 E8 47 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 5F 00 B9 E9 5F 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 47 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 4F 00 F9 E9 4F 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 09 00 00 14 E4 43 40 39 E3 23 40 B9 E2 0F 40 F9 E1 27 40 F9 E0 53 40 F9 ?? ?? ?? ?? E0 63 00 B9 E0 63 40 B9 FD 7B CB A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_7_0 {
	meta:
		name = "??$common_xtox_s@_K_W@@YAH_KQEA_W0I_N@Z"
		size = 1048
		refs = "0050 ??_C@_1CE@MCCHPLBM@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1GA@HBEFGMHK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 0074 _CrtDbgReportW 009c _errno 00c0 ??_C@_1BM@HMPEMLNP@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAx?$AAt?$AAo?$AAx?$AA_?$AAs?$AA?$AA@ 00d0 _invalid_parameter 0110 ??_C@_1CC@ONIJBMJF@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 01d4 _CrtGetDebugFillThreshold 0230 memset 0294 ??_C@_1HA@JFIOFNKD@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AAs?$AAt?$AAa?$AAt?$AAi?$AAc?$AA_?$AAc?$AAa?$AAs?$AAt?$AA?$DM?$AAs?$AAi?$AAz?$AAe?$AA_@ 0364 ??_C@_1DE@PCJGDBBD@?$AA2?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA3?$AA6?$AA?$AA@ 0404 ??$common_xtox@_K_W@@YAH_KQEA_W0I_N@Z"
	strings:
		$1 = { FD 7B B5 A9 FD 03 00 91 E0 53 00 F9 E1 27 00 F9 E2 0F 00 F9 E3 23 00 B9 E4 43 00 39 E8 27 40 F9 1F 01 00 F1 80 00 00 54 28 00 80 52 E8 27 00 B9 03 00 00 14 08 00 80 52 E8 27 00 B9 E8 27 40 B9 E8 2B 00 B9 E8 2B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 53 00 B9 E9 53 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 2B 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 3F 00 F9 E9 3F 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 43 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 CE 00 00 14 E8 0F 40 F9 1F 01 00 F1 89 00 00 54 28 00 80 52 E8 2F 00 B9 03 00 00 14 08 00 80 52 E8 2F 00 B9 E8 2F 40 B9 E8 33 00 B9 E8 33 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 57 00 B9 E9 57 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 33 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 43 00 F9 E9 43 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 63 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 9E 00 00 14 E9 27 40 F9 08 00 80 52 28 01 00 79 E8 0F 40 F9 1F 05 00 B1 20 04 00 54 E9 7B 40 B2 E8 0F 40 F9 1F 01 09 EB A0 03 00 54 E9 0F 40 F9 28 00 80 D2 1F 01 09 EB 22 03 00 54 ?? ?? ?? ?? E0 47 00 F9 E8 47 40 F9 E8 37 00 F9 E8 0F 40 F9 09 05 00 D1 E8 37 40 F9 1F 01 09 EB 82 00 00 54 E8 37 40 F9 E8 3B 00 F9 04 00 00 14 E8 0F 40 F9 08 05 00 D1 E8 3B 00 F9 E9 3B 40 F9 48 00 80 D2 22 7D 08 9B E8 27 40 F9 00 09 00 91 42 00 00 91 C1 1F 80 52 00 00 00 91 ?? ?? ?? ?? E8 43 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 48 00 80 52 E8 37 00 B9 03 00 00 14 28 00 80 52 E8 37 00 B9 E8 37 40 B9 09 7D 40 93 E8 0F 40 F9 1F 01 09 EB 89 00 00 54 28 00 80 52 E8 3B 00 B9 03 00 00 14 08 00 80 52 E8 3B 00 B9 E8 3B 40 B9 E8 3F 00 B9 E8 3F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 5B 00 B9 E9 5B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 3F 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 4B 00 F9 E9 4B 40 F9 48 04 80 52 28 01 00 B9 04 00 80 D2 A3 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 40 04 80 52 3D 00 00 14 E9 23 40 B9 48 00 80 52 1F 01 09 6B E8 00 00 54 E8 23 40 B9 1F 91 00 71 88 00 00 54 28 00 80 52 E8 43 00 B9 03 00 00 14 08 00 80 52 E8 43 00 B9 E8 43 40 B9 E8 47 00 B9 E8 47 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 C2 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 5F 00 B9 E9 5F 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E8 47 40 B9 1F 01 00 71 21 02 00 54 ?? ?? ?? ?? E0 4F 00 F9 E9 4F 40 F9 C8 02 80 52 28 01 00 B9 04 00 80 D2 C3 0E 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 02 80 52 09 00 00 14 E4 43 40 39 E3 23 40 B9 E2 0F 40 F9 E1 27 40 F9 E0 53 40 F9 ?? ?? ?? ?? E0 63 00 B9 E0 63 40 B9 FD 7B CB A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_8_0 {
	meta:
		name = "_i64toa"
		size = 108
		refs = "005c ??$common_xtox@_KD@@YAH_KQEAD0I_N@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 13 00 F9 E2 17 00 B9 E8 17 40 B9 1F 29 00 71 E1 00 00 54 E8 0F 40 F9 1F 01 00 F1 8A 00 00 54 28 00 80 52 E8 43 00 39 03 00 00 14 08 00 80 52 E8 43 00 39 E8 43 40 39 E8 47 00 39 E4 47 40 39 E3 17 40 B9 02 00 80 92 E1 13 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_10_0 {
	meta:
		name = "_i64tow"
		size = 108
		refs = "005c ??$common_xtox@_K_W@@YAH_KQEA_W0I_N@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0F 00 F9 E1 13 00 F9 E2 17 00 B9 E8 17 40 B9 1F 29 00 71 E1 00 00 54 E8 0F 40 F9 1F 01 00 F1 8A 00 00 54 28 00 80 52 E8 43 00 39 03 00 00 14 08 00 80 52 E8 43 00 39 E8 43 40 39 E8 47 00 39 E4 47 40 39 E3 17 40 B9 02 00 80 92 E1 13 40 F9 E0 0F 40 F9 ?? ?? ?? ?? E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_9_0 {
	meta:
		name = "_i64toa_s"
		size = 116
		refs = "0060 ??$common_xtox_s@_KD@@YAH_KQEAD0I_N@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 13 00 F9 E1 1B 00 F9 E2 17 00 F9 E3 17 00 B9 E8 17 40 B9 1F 29 00 71 E1 00 00 54 E8 13 40 F9 1F 01 00 F1 8A 00 00 54 28 00 80 52 E8 43 00 39 03 00 00 14 08 00 80 52 E8 43 00 39 E8 43 40 39 E8 47 00 39 E4 47 40 39 E3 17 40 B9 E2 17 40 F9 E1 1B 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 1B 00 B9 E0 1B 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_11_0 {
	meta:
		name = "_i64tow_s"
		size = 116
		refs = "0060 ??$common_xtox_s@_K_W@@YAH_KQEA_W0I_N@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 13 00 F9 E1 1B 00 F9 E2 17 00 F9 E3 17 00 B9 E8 17 40 B9 1F 29 00 71 E1 00 00 54 E8 13 40 F9 1F 01 00 F1 8A 00 00 54 28 00 80 52 E8 43 00 39 03 00 00 14 08 00 80 52 E8 43 00 39 E8 43 40 39 E8 47 00 39 E4 47 40 39 E3 17 40 B9 E2 17 40 F9 E1 1B 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 1B 00 B9 E0 1B 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_12_0 {
	meta:
		name = "_itoa"
		size = 108
		refs = "005c ??$common_xtox@KD@@YAHKQEAD_KI_N@Z"
		altNames = "_ltoa"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 1B 00 B9 E1 13 00 F9 E2 17 00 B9 E8 17 40 B9 1F 29 00 71 E1 00 00 54 E8 1B 40 B9 1F 01 00 71 8A 00 00 54 28 00 80 52 E8 43 00 39 03 00 00 14 08 00 80 52 E8 43 00 39 E8 43 40 39 E8 47 00 39 E4 47 40 39 E3 17 40 B9 02 00 80 92 E1 13 40 F9 E0 1B 40 B9 ?? ?? ?? ?? E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_14_0 {
	meta:
		name = "_itow"
		size = 108
		refs = "005c ??$common_xtox@K_W@@YAHKQEA_W_KI_N@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 1B 00 B9 E1 13 00 F9 E2 17 00 B9 E8 17 40 B9 1F 29 00 71 E1 00 00 54 E8 1B 40 B9 1F 01 00 71 8A 00 00 54 28 00 80 52 E8 43 00 39 03 00 00 14 08 00 80 52 E8 43 00 39 E8 43 40 39 E8 47 00 39 E4 47 40 39 E3 17 40 B9 02 00 80 92 E1 13 40 F9 E0 1B 40 B9 ?? ?? ?? ?? E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_18_0 {
	meta:
		name = "_ltow"
		size = 108
		refs = "005c ??$common_xtox@K_W@@YAHKQEA_W_KI_N@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 1B 00 B9 E1 13 00 F9 E2 17 00 B9 E8 17 40 B9 1F 29 00 71 E1 00 00 54 E8 1B 40 B9 1F 01 00 71 8A 00 00 54 28 00 80 52 E8 43 00 39 03 00 00 14 08 00 80 52 E8 43 00 39 E8 43 40 39 E8 47 00 39 E4 47 40 39 E3 17 40 B9 02 00 80 92 E1 13 40 F9 E0 1B 40 B9 ?? ?? ?? ?? E0 13 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_13_0 {
	meta:
		name = "_itoa_s"
		size = 116
		refs = "0060 ??$common_xtox_s@KD@@YAHKQEAD_KI_N@Z"
		altNames = "_ltoa_s"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 1B 00 B9 E1 17 00 F9 E2 13 00 F9 E3 17 00 B9 E8 17 40 B9 1F 29 00 71 E1 00 00 54 E8 1B 40 B9 1F 01 00 71 8A 00 00 54 28 00 80 52 E8 43 00 39 03 00 00 14 08 00 80 52 E8 43 00 39 E8 43 40 39 E8 47 00 39 E4 47 40 39 E3 17 40 B9 E2 13 40 F9 E1 17 40 F9 E0 1B 40 B9 ?? ?? ?? ?? E0 1F 00 B9 E0 1F 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_15_0 {
	meta:
		name = "_itow_s"
		size = 116
		refs = "0060 ??$common_xtox_s@K_W@@YAHKQEA_W_KI_N@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 1B 00 B9 E1 17 00 F9 E2 13 00 F9 E3 17 00 B9 E8 17 40 B9 1F 29 00 71 E1 00 00 54 E8 1B 40 B9 1F 01 00 71 8A 00 00 54 28 00 80 52 E8 43 00 39 03 00 00 14 08 00 80 52 E8 43 00 39 E8 43 40 39 E8 47 00 39 E4 47 40 39 E3 17 40 B9 E2 13 40 F9 E1 17 40 F9 E0 1B 40 B9 ?? ?? ?? ?? E0 1F 00 B9 E0 1F 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_19_0 {
	meta:
		name = "_ltow_s"
		size = 116
		refs = "0060 ??$common_xtox_s@K_W@@YAHKQEA_W_KI_N@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 1B 00 B9 E1 17 00 F9 E2 13 00 F9 E3 17 00 B9 E8 17 40 B9 1F 29 00 71 E1 00 00 54 E8 1B 40 B9 1F 01 00 71 8A 00 00 54 28 00 80 52 E8 43 00 39 03 00 00 14 08 00 80 52 E8 43 00 39 E8 43 40 39 E8 47 00 39 E4 47 40 39 E3 17 40 B9 E2 13 40 F9 E1 17 40 F9 E0 1B 40 B9 ?? ?? ?? ?? E0 1F 00 B9 E0 1F 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_20_0 {
	meta:
		name = "_ui64toa"
		size = 56
		refs = "0028 ??$common_xtox@_KD@@YAH_KQEAD0I_N@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E2 13 00 B9 04 00 80 52 E3 13 40 B9 02 00 80 92 E1 0F 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 0F 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_22_0 {
	meta:
		name = "_ui64tow"
		size = 56
		refs = "0028 ??$common_xtox@_K_W@@YAH_KQEA_W0I_N@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 0F 00 F9 E2 13 00 B9 04 00 80 52 E3 13 40 B9 02 00 80 92 E1 0F 40 F9 E0 13 40 F9 ?? ?? ?? ?? E0 0F 40 F9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_21_0 {
	meta:
		name = "_ui64toa_s"
		size = 64
		refs = "002c ??$common_xtox_s@_KD@@YAH_KQEAD0I_N@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E3 13 00 B9 04 00 80 52 E3 13 40 B9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 17 00 B9 E0 17 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_23_0 {
	meta:
		name = "_ui64tow_s"
		size = 64
		refs = "002c ??$common_xtox_s@_K_W@@YAH_KQEA_W0I_N@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 F9 E1 13 00 F9 E2 0F 00 F9 E3 13 00 B9 04 00 80 52 E3 13 40 B9 E2 0F 40 F9 E1 13 40 F9 E0 17 40 F9 ?? ?? ?? ?? E0 17 00 B9 E0 17 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_24_0 {
	meta:
		name = "_ultoa"
		size = 56
		refs = "0028 ??$common_xtox@KD@@YAHKQEAD_KI_N@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 17 00 B9 E1 0F 00 F9 E2 13 00 B9 04 00 80 52 E3 13 40 B9 02 00 80 92 E1 0F 40 F9 E0 17 40 B9 ?? ?? ?? ?? E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_26_0 {
	meta:
		name = "_ultow"
		size = 56
		refs = "0028 ??$common_xtox@K_W@@YAHKQEA_W_KI_N@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 17 00 B9 E1 0F 00 F9 E2 13 00 B9 04 00 80 52 E3 13 40 B9 02 00 80 92 E1 0F 40 F9 E0 17 40 B9 ?? ?? ?? ?? E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_25_0 {
	meta:
		name = "_ultoa_s"
		size = 64
		refs = "002c ??$common_xtox_s@KD@@YAHKQEAD_KI_N@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 B9 E1 17 00 F9 E2 13 00 F9 E3 13 00 B9 04 00 80 52 E3 13 40 B9 E2 13 40 F9 E1 17 40 F9 E0 17 40 B9 ?? ?? ?? ?? E0 1B 00 B9 E0 1B 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_27_0 {
	meta:
		name = "_ultow_s"
		size = 64
		refs = "002c ??$common_xtox_s@K_W@@YAHKQEA_W_KI_N@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 B9 E1 17 00 F9 E2 13 00 F9 E3 13 00 B9 04 00 80 52 E3 13 40 B9 E2 13 40 F9 E1 17 40 F9 E0 17 40 B9 ?? ?? ?? ?? E0 1B 00 B9 E0 1B 40 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "wctype"
		size = 196
		refs = "0034 ?tab@@3QBUwctab@@B 0078 strcmp"
		altNames = "wctrans"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 08 00 80 52 E8 13 00 B9 04 00 00 14 E8 13 40 B9 08 05 00 11 E8 13 00 B9 E8 13 40 B9 09 7D 40 D3 08 02 80 D2 29 7D 08 9B ?? ?? ?? ?? ?? ?? ?? ?? 08 01 09 8B 08 01 00 91 08 01 40 F9 1F 01 00 F1 60 03 00 54 E8 13 40 B9 09 7D 40 D3 08 02 80 D2 29 7D 08 9B ?? ?? ?? ?? ?? ?? ?? ?? 08 01 09 8B 08 01 00 91 E1 0F 40 F9 00 01 40 F9 ?? ?? ?? ?? E0 17 00 B9 E8 17 40 B9 1F 01 00 71 61 01 00 54 E8 13 40 B9 09 7D 40 D3 08 02 80 D2 29 7D 08 9B ?? ?? ?? ?? ?? ?? ?? ?? 08 01 09 8B 08 21 00 91 00 01 40 79 03 00 00 14 D9 FF FF 17 00 00 80 52 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_42_8_0 {
	meta:
		name = "__acrt_stdio_allocate_buffer_nolock"
		size = 464
		refs = "0018 ??_C@_1DC@OGOLMDEL@?$AAp?$AAu?$AAb?$AAl?$AAi?$AAc?$AA_?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0020 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0030 ??_C@_1GC@DLDMJFMI@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 003c _CrtDbgReportW 0060 ??0__crt_stdio_stream@@QEAA@QEAU_iobuf@@@Z 0064 _cflush 007c ??_C@_0DB@LKJPMJPL@minkernel?2crts?2ucrt?2src?2appcrt?2s@ 008c _malloc_dbg 009c ??0?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAA@QEAD@Z 00b0 ?detach@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAAPEADXZ 00bc ??C__crt_stdio_stream@@QEBAPEAU__crt_stdio_stream_data@@XZ 00d8 ??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAA@XZ 0104 ?set_flags@__crt_stdio_stream@@QEBA_NJ@Z"
	strings:
		$1 = { FD 7B B6 A9 FD 03 00 91 E0 13 00 F9 E8 13 40 F9 1F 01 00 F1 21 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 02 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 28 00 80 52 1F 01 09 6B 41 00 00 54 00 00 3E D4 E1 13 40 F9 E0 43 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 05 00 11 ?? ?? ?? ?? ?? ?? ?? ?? 63 03 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 41 00 80 52 00 00 82 D2 ?? ?? ?? ?? E0 17 00 F9 E1 17 40 F9 E0 43 01 91 ?? ?? ?? ?? E0 1B 00 F9 E8 1B 40 F9 E8 1F 00 F9 E0 1F 40 F9 ?? ?? ?? ?? E0 27 00 F9 E0 43 00 91 ?? ?? ?? ?? E0 23 00 F9 E8 23 40 F9 09 21 00 91 E8 27 40 F9 28 01 00 F9 E0 43 01 91 ?? ?? ?? ?? E0 43 00 91 ?? ?? ?? ?? E0 2F 00 F9 E8 2F 40 F9 08 21 00 91 08 01 40 F9 1F 01 00 F1 80 01 00 54 01 08 80 52 E0 43 00 91 ?? ?? ?? ?? E0 43 00 91 ?? ?? ?? ?? E0 33 00 F9 E8 33 40 F9 09 81 00 91 08 00 82 52 28 01 00 B9 16 00 00 14 01 80 80 52 E0 43 00 91 ?? ?? ?? ?? E0 43 00 91 ?? ?? ?? ?? E0 37 00 F9 E0 43 00 91 ?? ?? ?? ?? E0 3B 00 F9 E8 37 40 F9 09 71 00 91 E8 3B 40 F9 08 21 00 91 09 01 00 F9 E0 43 00 91 ?? ?? ?? ?? E0 3F 00 F9 E8 3F 40 F9 09 81 00 91 48 00 80 52 28 01 00 B9 E0 43 00 91 ?? ?? ?? ?? E0 43 00 F9 E0 43 00 91 ?? ?? ?? ?? E0 47 00 F9 E8 43 40 F9 0A 21 00 91 E8 47 40 F9 09 01 00 91 48 01 40 F9 28 01 00 F9 E0 43 00 91 ?? ?? ?? ?? E0 4B 00 F9 E8 4B 40 F9 09 41 00 91 08 00 80 52 28 01 00 B9 FD 7B CA A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_43_2_0 {
	meta:
		name = "??$common_chdir@D@@YAHQEBD@Z"
		size = 508
		refs = "0014 __security_push_cookie 0020 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0024 ??_C@_1CA@DFHJGMAL@?$AAp?$AAa?$AAt?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0028 ??_C@_1GE@HFGGHBCA@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0044 _CrtDbgReportW 0054 __doserrno 005c _errno 0068 ??_C@_1BK@KFGCOIBC@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAc?$AAh?$AAd?$AAi?$AAr?$AA?$AA@ 0080 _invalid_parameter 008c __imp_SetCurrentDirectoryA 00a0 __imp_GetLastError 00b0 __acrt_errno_map_os_error 00b8 __imp_GetCurrentDirectoryA 00e0 ??_C@_0DC@MIGIBIJP@minkernel?2crts?2ucrt?2src?2desktopc@ 0100 _calloc_dbg 0110 _free_dbg 017c toupper 018c __imp_SetEnvironmentVariableA 01e4 __security_pop_cookie"
	strings:
		$1 = { FD 7B BC A9 F3 53 01 A9 F5 5B 02 A9 F7 1B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 04 D1 80 03 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 07 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 A3 07 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 12 56 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? F4 FF FF 17 ?? ?? ?? ?? FF 07 00 F9 ?? ?? ?? ?? 09 FD DF C8 E1 43 00 91 A0 20 80 52 B5 20 80 52 20 01 3F D6 14 00 00 11 D4 06 00 34 ?? ?? ?? ?? 9F 02 15 6B 63 03 00 54 84 0D 80 52 ?? ?? ?? ?? 42 00 80 52 21 00 80 D2 80 7E 40 D3 ?? ?? ?? ?? 41 00 80 52 13 00 00 91 E0 07 40 F9 ?? ?? ?? ?? 41 00 80 52 F3 07 00 F9 00 00 80 D2 ?? ?? ?? ?? 53 01 00 B4 ?? ?? ?? ?? 09 FD DF C8 61 02 00 91 80 02 00 11 95 02 00 11 20 01 3F D6 14 00 00 11 14 FD FF 35 1B 00 00 14 14 00 80 12 20 00 00 14 E0 43 C0 39 1F 70 01 71 60 00 00 54 1F BC 00 71 C1 00 00 54 E8 47 C0 39 1F 00 08 6B 61 00 00 54 14 00 80 52 15 00 00 14 ?? ?? ?? ?? A8 07 80 52 FF 0F 00 39 E8 03 00 39 ?? ?? ?? ?? 49 07 80 52 E0 07 00 39 ?? ?? ?? ?? E9 0B 00 39 09 FD DF C8 E1 43 00 91 E0 03 00 91 20 01 3F D6 20 FE FF 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? 14 00 80 12 F3 07 40 F9 41 00 80 52 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FF 43 04 91 ?? ?? ?? ?? F7 1B 40 F9 F5 5B 42 A9 F3 53 41 A9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_43_3_0 {
	meta:
		name = "??$common_chdir@_W@@YAHQEB_W@Z"
		size = 512
		refs = "0014 __security_push_cookie 0020 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0024 ??_C@_1CA@DFHJGMAL@?$AAp?$AAa?$AAt?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0028 ??_C@_1GE@HFGGHBCA@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0044 _CrtDbgReportW 0054 __doserrno 005c _errno 0068 ??_C@_1BK@KFGCOIBC@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAc?$AAh?$AAd?$AAi?$AAr?$AA?$AA@ 0080 _invalid_parameter 008c __imp_SetCurrentDirectoryW 00a0 __imp_GetLastError 00b0 __acrt_errno_map_os_error 00b8 __imp_GetCurrentDirectoryW 00e0 ??_C@_0DC@MIGIBIJP@minkernel?2crts?2ucrt?2src?2desktopc@ 0100 _calloc_dbg 0110 _free_dbg 0180 toupper 0190 __imp_SetEnvironmentVariableW 01e8 __security_pop_cookie"
	strings:
		$1 = { FD 7B BC A9 F3 53 01 A9 F5 5B 02 A9 F7 1B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 83 08 D1 80 03 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 A2 07 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 A3 07 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 12 57 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? F4 FF FF 17 ?? ?? ?? ?? FF 03 00 F9 ?? ?? ?? ?? 09 FD DF C8 E1 43 00 91 A0 20 80 52 B5 20 80 52 20 01 3F D6 14 00 00 11 F4 06 00 34 ?? ?? ?? ?? 9F 02 15 6B 63 03 00 54 84 0D 80 52 ?? ?? ?? ?? 42 00 80 52 41 00 80 D2 80 7E 40 D3 ?? ?? ?? ?? 41 00 80 52 13 00 00 91 E0 03 40 F9 ?? ?? ?? ?? 41 00 80 52 F3 03 00 F9 00 00 80 D2 ?? ?? ?? ?? 53 01 00 B4 ?? ?? ?? ?? 09 FD DF C8 61 02 00 91 80 02 00 11 95 02 00 11 20 01 3F D6 14 00 00 11 14 FD FF 35 1C 00 00 14 14 00 80 12 21 00 00 14 E9 23 40 79 3F 71 01 71 60 00 00 54 3F BD 00 71 C1 00 00 54 E8 27 40 79 3F 01 08 6B 61 00 00 54 14 00 80 52 16 00 00 14 20 1D 00 13 ?? ?? ?? ?? A8 07 80 52 FF 1F 00 79 E8 13 00 79 ?? ?? ?? ?? 49 07 80 52 E0 17 00 79 ?? ?? ?? ?? E9 1B 00 79 09 FD DF C8 E1 43 00 91 E0 23 00 91 20 01 3F D6 00 FE FF 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? 14 00 80 12 F3 03 40 F9 41 00 80 52 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FF 83 08 91 ?? ?? ?? ?? F7 1B 40 F9 F5 5B 42 A9 F3 53 41 A9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_43_4_0 {
	meta:
		name = "??$get_current_directory@AEAKAEAPEAD@?$__crt_char_traits@D@@SAKAEAKAEAPEAD@Z"
		size = 24
		refs = "0000 __imp_GetCurrentDirectoryA"
	strings:
		$1 = { ?? ?? ?? ?? 21 00 40 F9 ?? ?? ?? ?? 00 00 40 B9 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_43_5_0 {
	meta:
		name = "??$get_current_directory@AEAKAEAPEA_W@?$__crt_char_traits@_W@@SAKAEAKAEAPEA_W@Z"
		size = 24
		refs = "0000 __imp_GetCurrentDirectoryW"
	strings:
		$1 = { ?? ?? ?? ?? 21 00 40 F9 ?? ?? ?? ?? 00 00 40 B9 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_43_6_0 {
	meta:
		name = "??$set_current_directory@AEBQEBD@?$__crt_char_traits@D@@SAHAEBQEBD@Z"
		size = 20
		refs = "0000 __imp_SetCurrentDirectoryA"
	strings:
		$1 = { ?? ?? ?? ?? 00 00 40 F9 ?? ?? ?? ?? 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_43_7_0 {
	meta:
		name = "??$set_current_directory@AEBQEB_W@?$__crt_char_traits@_W@@SAHAEBQEB_W@Z"
		size = 20
		refs = "0000 __imp_SetCurrentDirectoryW"
	strings:
		$1 = { ?? ?? ?? ?? 00 00 40 F9 ?? ?? ?? ?? 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_379_9_4 {
	meta:
		name = "??$tcschr@AEAPEA_WD@?$__crt_char_traits@_W@@SAPEA_WAEAPEA_W$$QEAD@Z"
		size = 16
		refs = "000c wcschr"
	strings:
		$1 = { 28 00 C0 39 00 00 40 F9 01 3D 00 53 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_531_17_4 {
	meta:
		name = "??$tcschr@AEBQEA_WD@?$__crt_char_traits@_W@@SAPEA_WAEBQEA_W$$QEAD@Z"
		size = 16
		refs = "000c wcschr"
	strings:
		$1 = { 28 00 C0 39 00 00 40 F9 01 3D 00 53 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_281_17_2 {
	meta:
		name = "??$tcschr@AEBQEB_WD@?$__crt_char_traits@_W@@SAPEB_WAEBQEB_W$$QEAD@Z"
		size = 16
		refs = "000c wcschr"
	strings:
		$1 = { 28 00 C0 39 00 00 40 F9 01 3D 00 53 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_379_13_0 {
	meta:
		name = "??$tcschr@PEA_WD@?$__crt_char_traits@_W@@SAPEA_W$$QEAPEA_W$$QEAD@Z"
		size = 16
		refs = "000c wcschr"
	strings:
		$1 = { 28 00 C0 39 00 00 40 F9 01 3D 00 53 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_379_19_0 {
	meta:
		name = "??$tcsrchr@AEAPEA_WD@?$__crt_char_traits@_W@@SAPEA_WAEAPEA_W$$QEAD@Z"
		size = 16
		refs = "000c wcsrchr"
	strings:
		$1 = { 28 00 C0 39 00 00 40 F9 01 3D 00 53 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_195_31_0 {
	meta:
		name = "??$tcsrchr@AEAPEB_WD@?$__crt_char_traits@_W@@SAPEB_WAEAPEB_W$$QEAD@Z"
		size = 16
		refs = "000c wcsrchr"
	strings:
		$1 = { 28 00 C0 39 00 00 40 F9 01 3D 00 53 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_195_33_0 {
	meta:
		name = "??$tcsrchr@AEBQEB_WD@?$__crt_char_traits@_W@@SAPEB_WAEBQEB_W$$QEAD@Z"
		size = 16
		refs = "000c wcsrchr"
	strings:
		$1 = { 28 00 C0 39 00 00 40 F9 01 3D 00 53 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_8_0 {
	meta:
		name = "??$set_cwd_environment_variable@D@@YAHQEBD@Z"
		size = 148
		refs = "0038 toupper 0048 __imp_SetEnvironmentVariableA 0070 __imp_GetLastError 0080 __acrt_errno_map_os_error"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 13 00 00 91 60 02 C0 39 1F 70 01 71 60 00 00 54 1F BC 00 71 C1 00 00 54 68 06 C0 39 1F 00 08 6B 61 00 00 54 00 00 80 52 15 00 00 14 ?? ?? ?? ?? A8 07 80 52 FF 4F 00 39 E8 43 00 39 ?? ?? ?? ?? 49 07 80 52 E0 47 00 39 ?? ?? ?? ?? E9 4B 00 39 09 FD DF C8 61 02 00 91 E0 43 00 91 20 01 3F D6 20 FE FF 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? 00 00 80 12 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_43_9_0 {
	meta:
		name = "??$set_cwd_environment_variable@_W@@YAHQEB_W@Z"
		size = 160
		refs = "000c __security_push_cookie 0040 toupper 0050 __imp_SetEnvironmentVariableW 0078 __imp_GetLastError 0088 __acrt_errno_map_os_error 0090 __security_pop_cookie"
	strings:
		$1 = { FD 7B BE A9 F3 0B 00 F9 FD 03 00 91 ?? ?? ?? ?? 13 00 00 91 69 02 40 79 3F 71 01 71 60 00 00 54 3F BD 00 71 C1 00 00 54 68 06 40 79 3F 01 08 6B 61 00 00 54 00 00 80 52 16 00 00 14 20 1D 00 13 ?? ?? ?? ?? A8 07 80 52 FF 0F 00 79 E8 03 00 79 ?? ?? ?? ?? 49 07 80 52 E0 07 00 79 ?? ?? ?? ?? E9 0B 00 79 09 FD DF C8 61 02 00 91 E0 03 00 91 20 01 3F D6 00 FE FF 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? 00 00 80 12 ?? ?? ?? ?? F3 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_43_10_0 {
	meta:
		name = "??$set_environment_variable@AEAY03$$CBDAEBQEBD@?$__crt_char_traits@D@@SAHAEAY03$$CBDAEBQEBD@Z"
		size = 20
		refs = "0000 __imp_SetEnvironmentVariableA"
	strings:
		$1 = { ?? ?? ?? ?? 21 00 40 F9 ?? ?? ?? ?? 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_43_11_0 {
	meta:
		name = "??$set_environment_variable@AEAY03$$CB_WAEBQEB_W@?$__crt_char_traits@_W@@SAHAEAY03$$CB_WAEBQEB_W@Z"
		size = 20
		refs = "0000 __imp_SetEnvironmentVariableW"
	strings:
		$1 = { ?? ?? ?? ?? 21 00 40 F9 ?? ?? ?? ?? 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "towctrans"
		size = 88
		refs = "0024 towupper 003c towlower"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 23 00 79 E1 2B 00 79 E8 2B 40 79 08 01 00 11 1F 05 00 71 E1 00 00 54 E0 23 40 79 ?? ?? ?? ?? E0 2F 00 79 E8 2F 40 79 E8 27 00 79 06 00 00 14 E0 23 40 79 ?? ?? ?? ?? E0 33 00 79 E8 33 40 79 E8 27 00 79 E0 27 40 79 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "atan"
		size = 968
		refs = "00a0 _handle_nan 00d0 ?piby2@?1??atan@@9@9 00e4 val_with_flags"
	strings:
		$1 = { FD 7B B7 A9 FD 03 00 91 E0 0B 00 FD F0 0B 40 FD F0 33 00 FD E8 33 40 F9 E8 27 00 F9 E8 27 40 F9 08 F9 40 92 E8 17 00 F9 E9 17 40 F9 E8 27 40 F9 1F 01 09 EB 80 00 00 54 28 00 80 52 E8 33 00 B9 03 00 00 14 08 00 80 52 E8 33 00 B9 E8 33 40 B9 08 7D 40 93 E8 2B 00 F9 E8 2B 40 F9 1F 01 00 F1 A0 00 00 54 F0 0B 40 FD 10 42 61 1E F0 0F 00 FD 03 00 00 14 F0 0B 40 FD F0 0F 00 FD 29 15 00 58 E8 17 40 F9 1F 01 09 EB 89 05 00 54 09 FE EF D2 E8 17 40 F9 1F 01 09 EB E9 00 00 54 E0 27 40 F9 ?? ?? ?? ?? E0 37 00 FD E0 37 40 FD 9B 00 00 14 19 00 00 14 B1 13 00 5C F0 0F 40 FD 00 22 71 1E AD 02 00 54 E8 2B 40 F9 1F 01 00 F1 60 01 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 00 42 61 1E 00 02 80 52 00 40 60 1E ?? ?? ?? ?? E0 3B 00 FD E0 3B 40 FD 8A 00 00 14 08 00 00 14 00 02 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 3F 00 FD E0 3F 40 FD 82 00 00 14 11 10 7E 1E F0 0F 40 FD 30 1A 70 1E F0 0B 00 FD 70 10 00 5C F0 23 00 FD 70 10 00 5C F0 1F 00 FD 3E 00 00 14 69 FE E7 D2 E8 17 40 F9 1F 01 09 EB 09 02 00 54 F1 0F 40 FD 10 10 6F 1E 32 3A 70 1E 11 10 6F 1E F0 0F 40 FD 31 0A 70 1E 10 10 6E 1E 10 2A 71 1E 50 1A 70 1E F0 0B 00 FD 90 0E 00 5C F0 23 00 FD 90 0E 00 5C F0 1F 00 FD 2B 00 00 14 C9 FC E7 D2 E8 17 40 F9 1F 01 09 EB C9 01 00 54 F1 0F 40 FD 10 10 6E 1E 32 3A 70 1E 11 10 6E 1E F0 0F 40 FD 30 2A 70 1E 50 1A 70 1E F0 0B 00 FD F0 0C 00 5C F0 23 00 FD F0 0C 00 5C F0 1F 00 FD 1A 00 00 14 89 FB E7 D2 E8 17 40 F9 1F 01 09 EB 09 02 00 54 11 10 60 1E F0 0F 40 FD 31 0A 70 1E 10 10 6E 1E 32 3A 70 1E 11 10 60 1E F0 0F 40 FD 30 2A 70 1E 50 1A 70 1E F0 0B 00 FD 10 0B 00 5C F0 23 00 FD 10 0B 00 5C F0 1F 00 FD 07 00 00 14 F0 0F 40 FD F0 0B 00 FD B0 0A 00 5C F0 23 00 FD 70 0A 00 5C F0 1F 00 FD F1 0B 40 FD F0 0B 40 FD 30 0A 70 1E F0 13 00 FD F1 0B 40 FD F0 13 40 FD 32 0A 70 1E 91 09 00 5C F0 13 40 FD 31 0A 70 1E 70 09 00 5C 11 2A 71 1E F0 13 40 FD 31 0A 70 1E 30 09 00 5C 11 2A 71 1E F0 13 40 FD 31 0A 70 1E F0 08 00 5C 11 2A 71 1E F0 13 40 FD 31 0A 70 1E B0 08 00 5C 10 2A 71 1E 52 0A 70 1E 91 08 00 5C F0 13 40 FD 31 0A 70 1E 70 08 00 5C 11 2A 71 1E F0 13 40 FD 31 0A 70 1E 30 08 00 5C 11 2A 71 1E F0 13 40 FD 31 0A 70 1E F0 07 00 5C 11 2A 71 1E F0 13 40 FD 31 0A 70 1E B0 07 00 5C 10 2A 71 1E 50 1A 70 1E F0 43 00 FD F1 43 40 FD F0 1F 40 FD 31 3A 70 1E F0 0B 40 FD 31 3A 70 1E F0 23 40 FD 10 3A 71 1E F0 2F 00 FD E8 2B 40 F9 1F 01 00 F1 80 00 00 54 F0 2F 40 FD 10 42 61 1E F0 2F 00 FD E0 2F 40 FD FD 7B C9 A8 C0 03 5F D6 00 00 00 00 00 80 03 40 00 00 00 00 00 DC D0 43 18 2D 44 54 FB 21 F9 3F 06 5C 14 33 26 A6 91 3C 9B F6 81 D2 0B 73 EF 3F BC CB F0 7A 88 07 70 3C 18 2D 44 54 FB 21 E9 3F 06 5C 14 33 26 A6 81 3C 4F BB 61 05 67 AC DD 3F E0 65 2F 22 7F 2B 7A 3C 00 00 00 00 00 00 00 00 87 9F 1B E4 5C A7 22 3F F2 53 F0 16 21 2D 9F 3F C0 25 B4 3D E4 3D CC 3F 3C 3B 99 4C BE A6 DC 3F F3 69 91 0A CB 2B D1 3F D9 5E E8 F1 97 F1 A3 3F FF BE F9 5B B0 2C DB 3F 2E 8D C4 44 C6 99 F6 3F A0 F5 CD 17 2A 37 FD 3F EC 1E DA 8F B0 C1 E9 3F }
	condition:
		$1
}

rule file_45_1_0 {
	meta:
		name = "raise_fpsw_flags"
		size = 44
		refs = "0020 _controlfp_s"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 13 00 B9 08 00 80 52 E8 17 00 B9 E2 13 40 B9 E1 13 40 B9 E0 53 00 91 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_45_2_0 {
	meta:
		name = "val_with_flags"
		size = 36
		refs = "0014 raise_fpsw_flags"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 FD E0 13 00 B9 E0 13 40 B9 ?? ?? ?? ?? E0 0F 40 FD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "_telli64"
		size = 44
		refs = "0018 _lseeki64"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 13 00 B9 22 00 80 52 01 00 80 D2 E0 13 40 B9 ?? ?? ?? ?? E0 0F 00 F9 E0 0F 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_47_31_0 {
	meta:
		name = "?__acrt_stdio_reset_buffer@@YAXV__crt_stdio_stream@@@Z"
		size = 96
		refs = "0010 ??C__crt_stdio_stream@@QEBAPEAU__crt_stdio_stream_data@@XZ"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0B 00 F9 E0 43 00 91 ?? ?? ?? ?? E0 0F 00 F9 E0 43 00 91 ?? ?? ?? ?? E0 13 00 F9 E8 0F 40 F9 0A 21 00 91 E8 13 40 F9 09 01 00 91 48 01 40 F9 28 01 00 F9 E0 43 00 91 ?? ?? ?? ?? E0 17 00 F9 E8 17 40 F9 09 41 00 91 08 00 80 52 28 01 00 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_47_32_0 {
	meta:
		name = "?__crt_interlocked_read_32@@YAHPEDH@Z"
		size = 36
	strings:
		$1 = { FF 43 00 D1 E0 07 00 F9 E8 07 40 F9 08 01 40 B9 E8 03 00 B9 BF 3B 03 D5 E0 03 40 B9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_47_33_0 {
	meta:
		name = "?common_flush_all@@YAH_N@Z"
		size = 112
		refs = "002c ??0<lambda_ab61a845afdef5b7c387490eaf3616ee>@@QEAA@AEAHAEB_N0@Z 003c ??$__acrt_lock_and_call@V<lambda_ab61a845afdef5b7c387490eaf3616ee>@@@@YAXW4__acrt_lock_id@@$$QEAV<lambda_ab61a845afdef5b7c387490eaf3616ee>@@@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 43 00 39 08 00 80 52 E8 17 00 B9 08 00 80 52 E8 1B 00 B9 E3 63 00 91 E2 43 00 91 E1 53 00 91 E0 A3 00 91 ?? ?? ?? ?? E0 13 00 F9 E1 13 40 F9 00 01 80 52 ?? ?? ?? ?? E8 43 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 E8 17 40 B9 E8 1F 00 B9 03 00 00 14 E8 1B 40 B9 E8 1F 00 B9 E0 1F 40 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_47_34_0 {
	meta:
		name = "?common_flush_all_should_try_to_flush_stream@@YA_NV__crt_stdio_stream@@QEAH@Z"
		size = 176
		refs = "0014 ?valid@__crt_stdio_stream@@QEBA_NXZ 0038 ?get_flags@__crt_stdio_stream@@QEBAJXZ 004c ?is_stream_allocated@@YA_NJ@Z 0070 ?is_stream_flushable_or_commitable@@YA_NJ@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 17 00 F9 E0 83 00 91 ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 00 00 80 52 1E 00 00 14 E0 83 00 91 ?? ?? ?? ?? E0 1B 00 B9 E8 1B 40 B9 E8 17 00 B9 E0 17 40 B9 ?? ?? ?? ?? E0 47 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 00 00 80 52 10 00 00 14 E0 17 40 B9 ?? ?? ?? ?? E0 4B 00 39 E8 4B 40 39 08 01 00 11 1F 01 00 71 01 01 00 54 E8 17 40 F9 08 01 40 B9 09 05 00 11 E8 17 40 F9 09 01 00 B9 00 00 80 52 02 00 00 14 20 00 80 52 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_47_35_0 {
	meta:
		name = "?get_flags@__crt_stdio_stream@@QEBAJXZ"
		size = 52
		refs = "0020 ??$__crt_interlocked_read@J@@YAJPEDJ@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0F 00 F9 E8 0F 40 F9 08 01 00 91 08 01 40 F9 00 51 00 91 00 00 00 91 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_47_36_0 {
	meta:
		name = "?has_all_of@__crt_stdio_stream@@QEBA_NJ@Z"
		size = 92
		refs = "0014 ?get_flags@__crt_stdio_stream@@QEBAJXZ"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 13 00 F9 E1 13 00 B9 E0 13 40 F9 ?? ?? ?? ?? E0 1B 00 B9 E9 1B 40 B9 E8 13 40 B9 29 01 08 0A E8 13 40 B9 3F 01 08 6B 81 00 00 54 28 00 80 52 E8 17 00 B9 03 00 00 14 08 00 80 52 E8 17 00 B9 E8 17 40 B9 00 1D 00 53 00 00 00 11 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_47_37_0 {
	meta:
		name = "?is_stream_allocated@@YA_NJ@Z"
		size = 56
	strings:
		$1 = { FF 43 00 D1 E0 07 00 B9 E8 07 40 B9 88 00 68 36 28 00 80 52 E8 03 00 B9 03 00 00 14 08 00 80 52 E8 03 00 B9 E8 03 40 B9 00 1D 00 53 00 00 00 11 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_47_38_0 {
	meta:
		name = "?is_stream_flushable@@YA_NJ@Z"
		size = 68
	strings:
		$1 = { FF 43 00 D1 E0 03 00 B9 E8 03 40 B9 08 05 00 12 1F 09 00 71 60 00 00 54 00 00 80 52 08 00 00 14 E8 03 40 B9 08 05 1A 12 1F 01 00 71 61 00 00 54 00 00 80 52 02 00 00 14 20 00 80 52 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_47_39_0 {
	meta:
		name = "?is_stream_flushable_or_commitable@@YA_NJ@Z"
		size = 76
		refs = "0010 ?is_stream_flushable@@YA_NJ@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 17 00 B9 E0 17 40 B9 ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 60 00 00 54 20 00 80 52 06 00 00 14 E8 17 40 B9 68 00 58 36 20 00 80 52 02 00 00 14 00 00 80 52 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_47_42_0 {
	meta:
		name = "?unset_flags@__crt_stdio_stream@@QEBA_NJ@Z"
		size = 136
	strings:
		$1 = { FF 83 00 D1 E0 0B 00 F9 E1 03 00 B9 E8 03 40 B9 EC 03 28 2A 8C 01 00 11 E8 0B 40 F9 08 01 00 91 08 01 40 F9 0B 51 00 91 6B 01 00 91 6A FD 5F 88 4A 01 00 11 49 01 0C 0A 69 FD 08 88 1F 01 00 71 61 FF FF 54 BF 3B 03 D5 EA 0B 00 B9 E9 0B 40 B9 E8 03 40 B9 28 01 08 0A 1F 01 00 71 80 00 00 54 28 00 80 52 E8 07 00 B9 03 00 00 14 08 00 80 52 E8 07 00 B9 E8 07 40 B9 00 1D 00 53 00 00 00 11 FF 83 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_47_44_0 {
	meta:
		name = "__acrt_stdio_flush_nolock"
		size = 324
		refs = "0014 ??0__crt_stdio_stream@@QEAA@QEAU_iobuf@@@Z 001c ?get_flags@__crt_stdio_stream@@QEBAJXZ 0028 ?is_stream_flushable@@YA_NJ@Z 004c ??C__crt_stdio_stream@@QEBAPEAU__crt_stdio_stream_data@@XZ 0088 ?__acrt_stdio_reset_buffer@@YAXV__crt_stdio_stream@@@Z 00b0 ?public_stream@__crt_stdio_stream@@QEBAPEAU_iobuf@@XZ 00bc _fileno 00d8 _write 0100 ?set_flags@__crt_stdio_stream@@QEBA_NJ@Z 0114 ?has_all_of@__crt_stdio_stream@@QEBA_NJ@Z 0134 ?unset_flags@__crt_stdio_stream@@QEBA_NJ@Z"
	strings:
		$1 = { FD 7B BA A9 FD 03 00 91 E0 1F 00 F9 E1 1F 40 F9 E0 63 00 91 ?? ?? ?? ?? E0 63 00 91 ?? ?? ?? ?? E0 27 00 B9 E0 27 40 B9 ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 00 00 80 52 3E 00 00 14 E0 63 00 91 ?? ?? ?? ?? E0 23 00 F9 E0 63 00 91 ?? ?? ?? ?? E0 27 00 F9 E8 23 40 F9 09 01 00 91 E8 27 40 F9 08 21 00 91 29 01 40 F9 08 01 40 F9 28 01 08 CB 08 01 00 11 E8 23 00 B9 E0 0F 40 F9 ?? ?? ?? ?? E8 23 40 B9 1F 01 00 71 6C 00 00 54 00 00 80 52 28 00 00 14 E0 63 00 91 ?? ?? ?? ?? E0 2F 00 F9 E0 63 00 91 ?? ?? ?? ?? E0 2B 00 F9 E0 2B 40 F9 ?? ?? ?? ?? E0 2B 00 B9 E8 2F 40 F9 08 21 00 91 E2 23 40 B9 01 01 40 F9 E0 2B 40 B9 ?? ?? ?? ?? E0 2F 00 B9 E8 2F 40 B9 E8 33 00 B9 E9 33 40 B9 E8 23 40 B9 1F 01 09 6B C0 00 00 54 01 02 80 52 E0 63 00 91 ?? ?? ?? ?? 00 00 80 12 0D 00 00 14 81 00 80 52 E0 63 00 91 ?? ?? ?? ?? E0 47 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 80 00 00 54 41 00 80 52 E0 63 00 91 ?? ?? ?? ?? 00 00 80 52 FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_47_45_0 {
	meta:
		name = "_fflush_nolock"
		size = 204
		refs = "0014 ??0__crt_stdio_stream@@QEAA@QEAU_iobuf@@@Z 001c ?valid@__crt_stdio_stream@@QEBA_NXZ 0038 ?common_flush_all@@YAH_N@Z 004c ?public_stream@__crt_stdio_stream@@QEBAPEAU_iobuf@@XZ 0058 __acrt_stdio_flush_nolock 007c ?has_all_of@__crt_stdio_stream@@QEBA_NJ@Z 0098 _fileno 00a4 _commit"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 1B 00 F9 E1 1B 40 F9 E0 A3 00 91 ?? ?? ?? ?? E0 A3 00 91 ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 C1 00 00 54 00 00 80 52 ?? ?? ?? ?? E0 17 00 B9 E0 17 40 B9 20 00 00 14 E0 A3 00 91 ?? ?? ?? ?? E0 1F 00 F9 E0 1F 40 F9 ?? ?? ?? ?? E0 1B 00 B9 E8 1B 40 B9 1F 01 00 71 60 00 00 54 00 00 80 12 15 00 00 14 01 00 81 52 E0 A3 00 91 ?? ?? ?? ?? E0 47 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 80 01 00 54 E0 1B 40 F9 ?? ?? ?? ?? E0 1F 00 B9 E0 1F 40 B9 ?? ?? ?? ?? E0 23 00 B9 E8 23 40 B9 1F 01 00 71 60 00 00 54 00 00 80 12 02 00 00 14 00 00 80 52 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_47_46_0 {
	meta:
		name = "_flushall"
		size = 32
		refs = "000c ?common_flush_all@@YAH_N@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 20 00 80 52 ?? ?? ?? ?? E0 13 00 B9 E0 13 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_47_47_0 {
	meta:
		name = "fflush"
		size = 176
		refs = "0014 ??0__crt_stdio_stream@@QEAA@QEAU_iobuf@@@Z 001c ?valid@__crt_stdio_stream@@QEBA_NXZ 0038 ?common_flush_all@@YAH_N@Z 004c ?get_flags@__crt_stdio_stream@@QEBAJXZ 0058 ?is_stream_flushable_or_commitable@@YA_NJ@Z 0080 ??0<lambda_9a32fed5bf61b6b509b2d3f6003082a1>@@QEAA@AEBV__crt_stdio_stream@@@Z 008c ?public_stream@__crt_stdio_stream@@QEBAPEAU_iobuf@@XZ 009c ??$__acrt_lock_stream_and_call@V<lambda_9a32fed5bf61b6b509b2d3f6003082a1>@@@@YAHQEAU_iobuf@@$$QEAV<lambda_9a32fed5bf61b6b509b2d3f6003082a1>@@@Z"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 E0 1B 00 F9 E1 1B 40 F9 E0 63 00 91 ?? ?? ?? ?? E0 63 00 91 ?? ?? ?? ?? E0 43 00 39 E8 43 40 39 08 01 00 11 1F 01 00 71 C1 00 00 54 00 00 80 52 ?? ?? ?? ?? E0 23 00 B9 E0 23 40 B9 19 00 00 14 E0 63 00 91 ?? ?? ?? ?? E0 27 00 B9 E0 27 40 B9 ?? ?? ?? ?? E0 47 00 39 E8 47 40 39 08 01 00 11 1F 01 00 71 61 00 00 54 00 00 80 52 0D 00 00 14 E1 63 00 91 E0 23 01 91 ?? ?? ?? ?? E0 1F 00 F9 E0 63 00 91 ?? ?? ?? ?? E0 23 00 F9 E1 1F 40 F9 E0 23 40 F9 ?? ?? ?? ?? E0 2B 00 B9 E0 2B 40 B9 FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_48_5_0 {
	meta:
		name = "_mbsnicoll_l"
		size = 500
		refs = "0028 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 003c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0040 ??_C@_1BM@ODEBGPLG@?$AAs?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0044 ??_C@_1HC@PFLNBKII@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0060 _CrtDbgReportW 0070 _errno 0090 ??_C@_1BM@BBBGICEO@?$AAs?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 00e8 ??_C@_1BK@CMPKHPEC@?$AAn?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 012c ??_C@_1BK@CNKOCFOL@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAi?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 013c _invalid_parameter 0160 _strnicoll_l 0170 _mbsnbcnt_l 01ac __acrt_CompareStringA"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BD A9 FD 03 00 91 73 00 00 91 15 00 00 91 36 00 00 91 61 02 00 91 E0 43 00 91 54 00 00 91 ?? ?? ?? ?? 74 00 00 B5 00 00 80 52 66 00 00 14 95 02 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 42 07 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 43 07 80 52 ?? ?? ?? ?? 2A 00 00 14 96 02 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 62 07 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 63 07 80 52 ?? ?? ?? ?? 16 00 00 14 E8 7B 40 B2 9F 02 08 EB 29 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 80 D2 82 07 80 52 40 00 80 52 ?? ?? ?? ?? 1F 04 00 71 41 00 00 54 00 00 3E D4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 83 07 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? 20 00 00 14 E8 13 40 F9 A0 02 00 91 08 09 40 B9 C8 00 00 35 63 02 00 91 82 02 00 91 C1 02 00 91 ?? ?? ?? ?? 1A 00 00 14 E2 63 00 91 81 02 00 91 ?? ?? ?? ?? E2 63 00 91 13 00 00 91 C0 02 00 91 81 02 00 91 ?? ?? ?? ?? E8 13 40 F9 64 02 00 11 06 00 00 11 C5 02 00 91 A3 02 00 91 07 05 40 B9 22 00 82 52 01 11 41 F9 E0 63 00 91 ?? ?? ?? ?? C0 00 00 35 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 00 00 B0 12 02 00 00 14 00 08 00 51 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "catanhf"
		size = 1340
		refs = "0018 crealf 0030 cimagf 0044 _fdtest 00c0 piby2 013c _FZero_C 0260 big 03bc log1pf 0404 atan2f 0430 _fperrraise 0434 _FInf_C 0464 sqrtf 0494 logf 0518 _FCbuild"
	strings:
		$1 = { FD 7B B6 A9 FD 03 00 91 E0 63 00 BD E1 67 00 BD E1 67 40 BD E0 63 40 BD ?? ?? ?? ?? E0 6B 00 BD F0 6B 40 BD F0 17 00 BD E1 67 40 BD E0 63 40 BD ?? ?? ?? ?? E0 6F 00 BD F0 6F 40 BD F0 13 00 BD E0 53 00 91 ?? ?? ?? ?? E0 53 00 79 E8 53 C0 79 E8 43 00 79 E0 43 00 91 ?? ?? ?? ?? E0 57 00 79 E8 57 C0 79 E8 47 00 79 E8 43 C0 79 08 01 00 11 1F 09 00 71 61 04 00 54 E8 47 C0 79 08 01 00 11 1F 09 00 71 C1 00 00 54 F0 17 40 BD F0 1F 00 BD F0 13 40 BD F0 1B 00 BD 19 00 00 14 E8 47 C0 79 08 01 00 11 1F 05 00 71 21 02 00 54 70 24 00 1C F0 1F 00 BD F0 13 40 BD 08 22 20 1E C2 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 21 1E F0 37 00 BD 04 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? F0 37 00 BD F0 37 40 BD F0 1B 00 BD 05 00 00 14 F0 17 40 BD F0 1F 00 BD F0 17 40 BD F0 1B 00 BD 05 01 00 14 E8 47 C0 79 08 01 00 11 1F 09 00 71 A1 03 00 54 E8 43 C0 79 08 01 00 11 1F 05 00 71 A0 00 00 54 E8 43 C0 79 08 01 00 11 1F 01 00 71 01 02 00 54 E8 2F 40 79 08 01 00 11 C8 00 78 36 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 21 1E F0 3B 00 BD 03 00 00 14 50 1F 00 1C F0 3B 00 BD F0 3B 40 BD F0 1F 00 BD F0 13 40 BD F0 1B 00 BD 05 00 00 14 F0 13 40 BD F0 1F 00 BD F0 13 40 BD F0 1B 00 BD E5 00 00 14 E8 43 C0 79 08 01 00 11 1F 05 00 71 61 03 00 54 F0 17 40 BD 08 22 20 1E C2 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 21 1E F0 3F 00 BD 03 00 00 14 50 1C 00 1C F0 3F 00 BD F0 3F 40 BD F0 1F 00 BD E8 27 40 79 08 01 00 11 C8 00 78 36 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 21 1E F0 43 00 BD 04 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? F0 43 00 BD F0 43 40 BD F0 1B 00 BD C7 00 00 14 E8 27 40 79 08 01 00 11 A8 00 78 36 F0 13 40 BD 10 42 21 1E F0 47 00 BD 03 00 00 14 F0 13 40 BD F0 47 00 BD F0 47 40 BD F0 27 00 BD F0 17 40 BD 08 22 20 1E E2 00 00 54 28 00 80 52 E8 5B 00 B9 F0 17 40 BD 10 42 21 1E F0 17 00 BD 06 00 00 14 08 00 80 52 E8 5B 00 B9 F0 13 40 BD 10 42 21 1E F0 13 00 BD F1 17 40 BD ?? ?? ?? ?? ?? ?? ?? ?? 00 22 31 1E A2 03 00 54 F1 13 40 BD F0 17 40 BD 30 1A 30 1E F0 4B 00 BD 11 10 2E 1E F0 