private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "__invoke_watson_if_error"
		size = 32
		refs = "001b __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 02 5D C3 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_0_1_0 {
	meta:
		name = "__invoke_watson_if_oneof"
		size = 43
		refs = "0026 __invoke_watson"
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 74 0A 3B 45 0C 74 07 3B 45 10 74 02 5D C3 FF 75 24 FF 75 20 FF 75 1C FF 75 18 FF 75 14 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_0_2_0 {
	meta:
		name = "__wcenvarg"
		size = 1052
		refs = "0007 ___security_cookie 0024 ??_C@_1BG@FIGGICF@?$AAS?$AAy?$AAs?$AAt?$AAe?$AAm?$AAR?$AAo?$AAo?$AAt?$AA?$AA@ 005a _wcslen 0072 __calloc_crt 0087 __errno 0092 ___doserrno 00b0 __wdupenv_s 0119 __wenvptr 0122 ___crtGetEnvironmentStringsW 013d _free 01f8 __wcsnicmp 0285 _wcscpy_s 0317 _memcpy 0383 ??_C@_13NMPKAAJP@?$AA?$DN?$AA?$AA@ 038a _wcscat_s 0409 @__security_check_cookie@4 0417 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 EC 48 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 57 33 C9 8B 45 10 8B 55 08 8D 7D E4 6A 05 89 4D B8 BE ?? ?? ?? ?? 89 4D CC 89 4D C8 59 F3 A5 8B 5D 0C 89 45 D4 8B 45 14 89 45 E0 33 C0 66 A5 6A 02 89 45 D0 8B F2 89 45 BC 8B 02 89 55 DC 5F 89 7D C0 85 C0 74 16 50 E8 ?? ?? ?? ?? 40 8D 76 04 03 F8 8B 06 59 85 C0 75 ED 89 7D C0 6A 02 57 E8 ?? ?? ?? ?? 59 59 8B 4D D4 89 01 85 C0 75 23 8B 4D E0 89 01 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? C7 00 08 00 00 00 83 C8 FF E9 5C 03 00 00 8D 45 E4 33 FF 50 8D 45 D0 57 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0E 83 F8 16 0F 84 4D 03 00 00 83 C8 FF EB 6B 8D 45 E4 50 E8 ?? ?? ?? ?? 59 8D 70 02 89 75 C4 39 7D D0 74 0E FF 75 D0 E8 ?? ?? ?? ?? 03 F0 59 89 75 C4 85 DB 0F 84 6A 01 00 00 8B 03 8B F3 6A 02 5F 89 7D D8 85 C0 74 16 50 E8 ?? ?? ?? ?? 40 8D 76 04 03 F8 8B 06 59 85 C0 75 ED 89 7D D8 A1 ?? ?? ?? ?? 85 C0 75 2D E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 85 C0 75 1F 83 C8 FF 33 FF 8B 5D D4 89 45 CC FF 33 E8 ?? ?? ?? ?? 59 8B 4D E0 89 3B 89 39 E9 89 02 00 00 33 C9 8B F1 89 4D C8 6A 3D 5A 66 39 08 74 2D 0F B7 08 8B D0 6A 3D 5F 66 3B CF 74 1A 52 E8 ?? ?? ?? ?? 40 03 F0 A1 ?? ?? ?? ?? 59 8D 14 70 0F B7 0A 66 85 C9 75 E1 6A 3D 89 75 C8 5A 8D 0C 70 8B FE 66 39 11 75 3C 33 F6 66 39 71 02 74 31 66 83 7C 78 04 3A 75 29 66 39 54 78 06 75 22 8D 04 78 83 C0 08 50 E8 ?? ?? ?? ?? 83 C0 05 03 F8 A1 ?? ?? ?? ?? 59 6A 3D 5A 8D 0C 78 66 39 11 74 C9 8B 75 C8 8B 4D D8 8B C7 2B C6 8B F3 03 C8 33 C0 89 4D D8 89 4D B8 39 03 74 28 8D 45 E4 50 E8 ?? ?? ?? ?? 50 8D 45 E4 50 FF 36 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 4F 83 C6 04 33 C0 39 06 75 DB 8B 4D D8 03 4D C4 6A 02 51 E8 ?? ?? ?? ?? 59 59 8B 4D E0 89 01 85 C0 75 3E 8B 5D D4 FF 33 E8 ?? ?? ?? ?? 33 FF 59 89 3B E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 83 CB FF C7 00 08 00 00 00 E9 88 01 00 00 8B 4D D8 C7 45 BC 01 00 00 00 EB B4 8B 4D E0 89 39 8B 45 DC 8B 55 D4 83 38 00 8B 32 75 05 83 C6 02 EB 79 FF 30 8B 45 C0 8B CE 2B CE D1 F9 2B C1 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 38 01 00 00 8B 45 DC FF 30 E8 ?? ?? ?? ?? 59 8D 34 46 8B 45 DC 83 C6 02 83 C0 04 EB 3B 50 8B 45 C0 8B CE 2B 0A D1 F9 2B C1 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 01 01 00 00 8B 45 DC FF 30 E8 ?? ?? ?? ?? 59 6A 20 59 8D 34 46 8B 45 DC 83 C0 04 66 89 0E 83 C6 02 8B 55 D4 89 45 DC 8B 00 85 C0 75 B9 89 46 FE 8B 45 E0 8B 30 85 DB 0F 84 AD 00 00 00 8B 4D C8 2B F9 A1 ?? ?? ?? ?? 03 FF 57 8D 04 48 50 56 E8 ?? ?? ?? ?? 03 F7 83 C4 0C 33 FF 39 3B 74 3D 8B 7D B8 8B 45 E0 8B CE FF 33 2B 08 8B C7 D1 F9 2B C1 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 82 00 00 00 FF 33 E8 ?? ?? ?? ?? 83 C3 04 59 8D 34 46 33 C0 83 C6 02 39 03 75 C8 33 FF 83 7D BC 00 75 45 8B 5D C4 8D 45 E4 50 53 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 8F 00 00 00 68 ?? ?? ?? ?? 53 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 7C 8B 45 D0 85 C0 74 0F 50 53 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 66 8D 34 5E 8B 45 E0 85 F6 74 20 3B 30 75 08 33 C0 66 89 06 83 C6 02 33 C0 33 FF 66 89 06 8B D8 EB 0E 33 C0 50 50 50 50 50 EB 41 33 FF 8B 5D CC A1 ?? ?? ?? ?? 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 45 D0 89 3D ?? ?? ?? ?? 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B C3 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "__FCbuild"
		size = 27
	strings:
		$1 = { 55 8B EC 51 51 D9 45 08 D9 5D F8 D9 45 0C 8B 45 F8 D9 5D FC 8B 55 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_1_0 {
	meta:
		name = "_cprojf"
		size = 135
		refs = "000e _crealf 001c _cimagf 0028 __fdtest 0061 __FZero_C 0070 __FInf_C"
	strings:
		$1 = { 55 8B EC 83 EC 0C 56 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 0C D9 5D F8 FF 75 08 E8 ?? ?? ?? ?? 8D 45 F8 50 D9 5D FC E8 ?? ?? ?? ?? 0F B7 F0 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 18 0F B7 C0 33 C9 41 66 3B F1 5E 74 0D 66 3B C1 74 08 8B 45 08 8B 55 0C EB 2F 0F B7 45 FE A9 00 80 00 00 74 0A D9 05 ?? ?? ?? ?? D9 E0 EB 02 D9 EE D9 5D FC D9 05 ?? ?? ?? ?? D9 5D F4 D9 45 FC 8B 45 F4 D9 5D F8 8B 55 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "__putw"
		size = 170
		refs = "0003 __sehtable$__putw 0008 __SEH_prolog4 0025 __errno 0030 __invalid_parameter_noinfo 003e __lock_file 0066 __flsbuf 0074 _ferror 0097 __SEH_epilog4 00a4 __unlock_file"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 04 5B 8D 7D 08 83 65 E4 00 33 C0 8B 75 0C 85 F6 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 5D 89 75 0C 56 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B C3 4B 89 5D E0 85 C0 74 21 FF 4E 04 78 0A 8A 0F 8B 06 88 08 FF 06 EB 0C 56 0F BE 07 50 E8 ?? ?? ?? ?? 59 59 47 89 7D DC EB D5 56 E8 ?? ?? ?? ?? 59 85 C0 74 05 83 CF FF EB 03 8B 7D 08 89 7D E4 C7 45 FC FE FF FF FF E8 0E 00 00 00 8B C7 E8 ?? ?? ?? ?? C3 8B 7D E4 8B 75 0C 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "__fflush_nolock"
		size = 70
		refs = "000d _flsall 0016 __flush 002f __fileno 0035 __commit"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 85 F6 75 09 56 E8 ?? ?? ?? ?? 59 EB 2F 56 E8 ?? ?? ?? ?? 59 85 C0 74 05 83 C8 FF EB 1F F7 46 0C 00 40 00 00 74 14 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? F7 D8 59 59 1B C0 EB 02 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_3_1_0 {
	meta:
		name = "__flush"
		size = 100
		refs = "002c __fileno 0033 __write"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 33 DB 8B 46 0C 24 03 3C 02 75 42 F7 46 0C 08 01 00 00 74 39 57 8B 3E 2B 7E 08 85 FF 7E 2E 57 FF 76 08 56 E8 ?? ?? ?? ?? 59 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C7 75 0F 8B 46 0C 84 C0 79 0F 83 E0 FD 89 46 0C EB 07 83 4E 0C 20 83 CB FF 5F 8B 4E 08 8B C3 83 66 04 00 89 0E 5E 5B 5D C3 }
	condition:
		$1
}

rule file_3_3_0 {
	meta:
		name = "_fflush"
		size = 89
		refs = "0003 __sehtable$_fflush 0008 __SEH_prolog4 001a _flsall 0023 __lock_file 002d __fflush_nolock 0046 __SEH_epilog4 0053 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 8B 75 08 85 F6 75 09 57 E8 ?? ?? ?? ?? 59 EB 24 56 E8 ?? ?? ?? ?? 59 89 7D FC 56 E8 ?? ?? ?? ?? 59 8B F8 89 7D E4 C7 45 FC FE FF FF FF E8 0E 00 00 00 8B C7 E8 ?? ?? ?? ?? C3 8B 75 08 8B 7D E4 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_3_4_0 {
	meta:
		name = "_flsall"
		size = 228
		refs = "0003 __sehtable$_flsall 0008 __SEH_prolog4 0017 __lock 0029 __nstream 0034 ___piob 0048 __lock_file2 006a __fflush_nolock 00b2 __unlock_file2 00d0 __SEH_epilog4 00de __unlock"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 21 7D DC 6A 01 E8 ?? ?? ?? ?? 59 21 7D FC 33 F6 8B 5D 08 89 75 E0 3B 35 ?? ?? ?? ?? 0F 8D 86 00 00 00 A1 ?? ?? ?? ?? 8B 04 B0 85 C0 74 5D F6 40 0C 83 74 57 50 56 E8 ?? ?? ?? ?? 59 59 C7 45 FC 01 00 00 00 A1 ?? ?? ?? ?? 8B 04 B0 F6 40 0C 83 74 30 83 FB 01 75 12 50 E8 ?? ?? ?? ?? 59 83 F8 FF 74 1F 47 89 7D E4 EB 19 85 DB 75 15 F6 40 0C 02 74 0F 50 E8 ?? ?? ?? ?? 59 83 F8 FF 75 03 09 45 DC 83 65 FC 00 E8 0C 00 00 00 46 EB 85 8B 5D 08 8B 7D E4 8B 75 E0 A1 ?? ?? ?? ?? FF 34 B0 56 E8 ?? ?? ?? ?? 59 59 C3 C7 45 FC FE FF FF FF E8 16 00 00 00 83 FB 01 8B C7 74 03 8B 45 DC E8 ?? ?? ?? ?? C3 8B 5D 08 8B 7D E4 6A 01 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
		size = 136
		refs = "0013 __getptd 0029 ___ptlocinfo 0030 ___globallocalestatus 003a ___updatetlocinfo 0046 ___ptmbcinfo 005a ___updatetmbcinfo"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 C6 46 0C 00 85 C9 75 66 57 E8 ?? ?? ?? ?? 8B F8 89 7E 08 8B 57 6C 89 16 8B 4F 68 89 4E 04 3B 15 ?? ?? ?? ?? 74 11 A1 ?? ?? ?? ?? 85 47 70 75 07 E8 ?? ?? ?? ?? 89 06 8B 46 04 5F 3B 05 ?? ?? ?? ?? 74 15 8B 4E 08 A1 ?? ?? ?? ?? 85 41 70 75 08 E8 ?? ?? ?? ?? 89 46 04 8B 4E 08 8B 41 70 A8 02 75 16 83 C8 02 89 41 70 C6 46 0C 01 EB 0A 8B 01 89 06 8B 41 04 89 46 04 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_3_0 {
	meta:
		name = "__mbctolower"
		size = 17
		refs = "0009 __mbctolower_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_17_128_2 {
	meta:
		name = "__Mtx_lock"
		size = 17
		refs = "0009 ?mtx_do_lock@@YAHPAPAU_Mtx_internal_imp_t@@PBUxtime@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1299_16_0 {
	meta:
		name = "__cropzeros"
		size = 17
		refs = "0009 __cropzeros_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1299_20_0 {
	meta:
		name = "__forcdecpt"
		size = 17
		refs = "0009 __forcdecpt_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_411_14_0 {
	meta:
		name = "__ismbbkana"
		size = 17
		refs = "0009 __ismbbkana_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_648_3_0 {
	meta:
		name = "__ismbcalnum"
		size = 17
		refs = "0009 __ismbcalnum_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_437_3_0 {
	meta:
		name = "__ismbcalpha"
		size = 17
		refs = "0009 __ismbcalpha_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1142_3_0 {
	meta:
		name = "__ismbcblank"
		size = 17
		refs = "0009 __ismbcblank_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_363_3_0 {
	meta:
		name = "__ismbcdigit"
		size = 17
		refs = "0009 __ismbcdigit_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_212_3_0 {
	meta:
		name = "__ismbcgraph"
		size = 17
		refs = "0009 __ismbcgraph_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_619_3_0 {
	meta:
		name = "__ismbchira"
		size = 17
		refs = "0009 __ismbchira_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_619_5_0 {
	meta:
		name = "__ismbckata"
		size = 17
		refs = "0009 __ismbckata_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_796_3_0 {
	meta:
		name = "__ismbcl0"
		size = 17
		refs = "0009 __ismbcl0_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_796_5_0 {
	meta:
		name = "__ismbcl1"
		size = 17
		refs = "0009 __ismbcl1_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_796_7_0 {
	meta:
		name = "__ismbcl2"
		size = 17
		refs = "0009 __ismbcl2_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_654_3_0 {
	meta:
		name = "__ismbclegal"
		size = 17
		refs = "0009 __ismbclegal_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_956_3_0 {
	meta:
		name = "__ismbclower"
		size = 17
		refs = "0009 __ismbclower_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_347_3_0 {
	meta:
		name = "__ismbcprint"
		size = 17
		refs = "0009 __ismbcprint_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1142_5_0 {
	meta:
		name = "__ismbcpunct"
		size = 17
		refs = "0009 __ismbcpunct_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1344_3_0 {
	meta:
		name = "__ismbcspace"
		size = 17
		refs = "0009 __ismbcspace_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_619_7_0 {
	meta:
		name = "__ismbcsymbol"
		size = 17
		refs = "0009 __ismbcsymbol_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1178_3_0 {
	meta:
		name = "__ismbcupper"
		size = 17
		refs = "0009 __ismbcupper_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_697_3_0 {
	meta:
		name = "__mbbtombc"
		size = 17
		refs = "0009 __mbbtombc_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1104_3_0 {
	meta:
		name = "__mbcjistojms"
		size = 17
		refs = "0009 __mbcjistojms_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1104_5_0 {
	meta:
		name = "__mbcjmstojis"
		size = 17
		refs = "0009 __mbcjmstojis_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1179_0_0 {
	meta:
		name = "__mbctohira"
		size = 17
		refs = "0009 __mbctohira_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_493_0_0 {
	meta:
		name = "__mbctokata"
		size = 17
		refs = "0009 __mbctokata_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_697_5_0 {
	meta:
		name = "__mbctombb"
		size = 17
		refs = "0009 __mbctombb_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_453_3_0 {
	meta:
		name = "__mbctoupper"
		size = 17
		refs = "0009 __mbctoupper_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1058_3_0 {
	meta:
		name = "__mbslen"
		size = 17
		refs = "0009 __mbslen_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_380_3_0 {
	meta:
		name = "__mbsnextc"
		size = 17
		refs = "0009 __mbsnextc_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_387_3_0 {
	meta:
		name = "__mbsrev"
		size = 17
		refs = "0009 __mbsrev_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_986_2_0 {
	meta:
		name = "__mkgmtime32"
		size = 17
		refs = "0009 __make__time32_t"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1035_2_0 {
	meta:
		name = "__mkgmtime64"
		size = 17
		refs = "0009 __make__time64_t"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_937_5_0 {
	meta:
		name = "__wtof"
		size = 17
		refs = "0009 __wtof_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_678_6_0 {
	meta:
		name = "_atof"
		size = 17
		refs = "0009 __atof_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1301_20_0 {
	meta:
		name = "_isleadbyte"
		size = 17
		refs = "0009 __isleadbyte_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_980_4_0 {
	meta:
		name = "_towlower"
		size = 17
		refs = "0009 __towlower_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_737_4_0 {
	meta:
		name = "_towupper"
		size = 17
		refs = "0009 __towupper_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_5_4_0 {
	meta:
		name = "__mbctolower_l"
		size = 151
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0056 ___crtLCMapStringA"
	strings:
		$1 = { 55 8B EC 83 EC 18 8D 4D E8 53 FF 75 0C E8 ?? ?? ?? ?? 8B 5D 08 81 FB FF 00 00 00 76 54 8B 4D EC 8B C3 C1 E8 08 88 45 FC 0F B6 C0 88 5D FD F6 44 08 19 04 74 4E 6A 01 FF 71 04 8D 45 F8 6A 02 50 6A 02 8D 45 FC 50 68 00 01 00 00 FF B1 1C 02 00 00 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 22 8B 45 F8 0F B6 D8 C1 E3 08 0F B6 C4 03 D8 EB 12 8B 45 EC F6 44 18 19 10 74 08 0F B6 9C 18 19 01 00 00 80 7D F4 00 74 07 8B 4D F0 83 61 70 FD 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "_copysignl"
		size = 31
		altNames = "_copysign"
	strings:
		$1 = { 55 8B EC 8B 45 0E B9 FF 7F 00 00 66 33 45 16 66 23 C1 66 33 45 16 66 89 45 0E DD 45 08 5D C3 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "_lrint"
		size = 122
		refs = "000a __dtest 0024 _nearbyint 003f __fperrraise 0049 __real@c1e0000000000000 0056 __real@41dfffffffc00000 0064 __ftol2_sse"
	strings:
		$1 = { 55 8B EC 51 51 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 85 C0 74 60 7E 05 83 F8 02 7E 51 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 55 F8 DD 45 08 83 C4 08 DD E9 DF E0 F6 C4 44 7B 0D 6A 20 DD D8 E8 ?? ?? ?? ?? DD 45 F8 59 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 75 16 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 07 E8 ?? ?? ?? ?? EB 0C DD D8 6A 01 E8 ?? ?? ?? ?? 59 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_539_0_0 {
	meta:
		name = "_lrintl"
		size = 122
		refs = "000a __ldtest 0024 _nearbyintl 003f __fperrraise 0049 __real@c1e0000000000000 0056 __real@41dfffffffc00000 0064 __ftol2_sse"
	strings:
		$1 = { 55 8B EC 51 51 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 85 C0 74 60 7E 05 83 F8 02 7E 51 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 55 F8 DD 45 08 83 C4 08 DD E9 DF E0 F6 C4 44 7B 0D 6A 20 DD D8 E8 ?? ?? ?? ?? DD 45 F8 59 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 75 16 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 07 E8 ?? ?? ?? ?? EB 0C DD D8 6A 01 E8 ?? ?? ?? ?? 59 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "__dquad"
		size = 1014
		refs = "000a ___security_cookie 0021 __real@c1945f306dc9c883 0034 __real@41945f306dc9c883 0047 __real@3fe45f306dc9c883 0058 __real@3fe0000000000000 0074 __d_int 008d __real@3fd0000000000000 0095 __real@3e50000000000000 009b __real@41b921fb50000000 00ab __real@401110b460000000 00b5 __real@3e51a62620000000 00bf __real@3cd3145c00000000 00c9 __real@3b3b839a20000000 00fe __dunscale 0121 __dxp_setw 014c __dscale 0175 ___b 017f _memcpy 0195 __dxp_mulh 01e8 __dxp_addx 01f0 ___c 0225 __real@3fc45f306dc9c883 0242 __real@be50000000000000 0294 _get_acsize 0369 __real@bfd0000000000000 039b __dxp_getw 03ad __real@c1dfffffffc00000 03bd __real@41dfffffffc00000 03ca __real@41e0000000000000 03d9 _fmod 03e1 __ftol2_sse 03ee @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC B8 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 57 8B 7D 08 DD 07 DD 95 58 FF FF FF DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 05 0F 8A B2 00 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 0F 85 9F 00 00 00 DC 0D ?? ?? ?? ?? D9 EE D8 D9 DF E0 F6 C4 41 7A 08 DC 05 ?? ?? ?? ?? EB 06 DC 25 ?? ?? ?? ?? 8D 85 64 FF FF FF 6A 00 50 DD 9D 64 FF FF FF E8 ?? ?? ?? ?? DD 85 64 FF FF FF D9 EE DD E9 DF E0 59 59 F6 C4 44 7B 4C DD 05 ?? ?? ?? ?? D8 C9 DC 0D ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 C9 DC AD 58 FF FF FF D9 C1 DC 0D ?? ?? ?? ?? DE E9 D9 C1 DC 0D ?? ?? ?? ?? DE E9 D9 C1 DC 0D ?? ?? ?? ?? DE E9 D9 C9 DC 0D ?? ?? ?? ?? DE E9 DD 95 58 FF FF FF EB 06 DD 85 58 FF FF FF DD 1F E9 C7 02 00 00 53 56 6A 06 5E 8D 85 64 FF FF FF 50 8D 85 60 FF FF FF 50 DD 9D 64 FF FF FF E8 ?? ?? ?? ?? 8B 85 60 FF FF FF 59 59 66 83 F8 56 7D 1D DD 85 58 FF FF FF 8D 45 CC 51 51 DD 1C 24 56 50 E8 ?? ?? ?? ?? 83 C4 10 E9 C2 00 00 00 98 83 E8 36 C1 F8 05 0F B7 C0 89 85 60 FF FF FF 98 C1 E0 05 F7 D8 50 8D 85 58 FF FF FF 50 E8 ?? ?? ?? ?? DD 85 58 FF FF FF 8D 85 48 FF FF FF DD 1C 24 6A 02 50 E8 ?? ?? ?? ?? 0F BF 85 60 FF FF FF 6B C0 30 6A 30 8D 80 ?? ?? ?? ?? 50 8D 45 CC 50 E8 ?? ?? ?? ?? DD 85 48 FF FF FF 8D 45 CC 83 C4 14 DD 1C 24 56 50 E8 ?? ?? ?? ?? DD 85 50 FF FF FF 83 C4 10 D9 EE DA E9 DF E0 F6 C4 44 7B 42 0F BF 85 60 FF FF FF 6B C0 30 6A 30 8D 80 ?? ?? ?? ?? 50 8D 45 9C 50 E8 ?? ?? ?? ?? DD 85 50 FF FF FF 8D 45 9C 59 DD 1C 24 56 50 E8 ?? ?? ?? ?? 56 8D 45 9C 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? 83 C4 20 BB ?? ?? ?? ?? DD 45 CC DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 74 11 DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 0F 85 DB 00 00 00 DC 45 D4 8D 85 64 FF FF FF 6A 00 50 DC 0D ?? ?? ?? ?? DD 9D 64 FF FF FF E8 ?? ?? ?? ?? DD 85 64 FF FF FF 8D 85 48 FF FF FF DC 0D ?? ?? ?? ?? DD 1C 24 6A 02 50 E8 ?? ?? ?? ?? 8B C6 C1 E0 03 50 8D 45 9C 53 50 E8 ?? ?? ?? ?? DD 85 48 FF FF FF 8D 45 9C 83 C4 14 DD 1C 24 56 50 E8 ?? ?? ?? ?? DD 85 50 FF FF FF 83 C4 10 D9 EE DA E9 DF E0 F6 C4 44 7B 50 DD 45 CC 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B F0 8D 85 6C FF FF FF 8B CE C1 E1 03 51 53 50 E8 ?? ?? ?? ?? DD 85 50 FF FF FF 8D 85 6C FF FF FF 83 C4 0C DD 1C 24 56 50 E8 ?? ?? ?? ?? 56 8D 85 6C FF FF FF 50 8D 45 9C 56 50 E8 ?? ?? ?? ?? 83 C4 20 56 8D 45 9C 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? 83 C4 10 E9 02 FF FF FF DC 45 D4 DC 0D ?? ?? ?? ?? D9 EE D8 D9 DF E0 F6 C4 41 7A 08 DC 05 ?? ?? ?? ?? EB 06 DC 25 ?? ?? ?? ?? 8D 85 64 FF FF FF 6A 00 50 DD 9D 64 FF FF FF E8 ?? ?? ?? ?? DD 85 64 FF FF FF D9 EE DA E9 DF E0 59 59 F6 C4 44 7B 5A DD 45 CC 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B F0 C1 E0 03 50 8D 85 6C FF FF FF 53 50 E8 ?? ?? ?? ?? DD 85 64 FF FF FF 8D 85 6C FF FF FF DC 0D ?? ?? ?? ?? 83 C4 0C DC 0D ?? ?? ?? ?? DD 1C 24 56 50 E8 ?? ?? ?? ?? 56 8D 85 6C FF FF FF 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? 83 C4 20 8D 45 CC 56 50 E8 ?? ?? ?? ?? 59 59 DD 1F DD 85 64 FF FF FF 5E 5B DD 05 ?? ?? ?? ?? D8 D9 DF E0 5F F6 C4 41 74 0D DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 75 18 DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 E8 ?? ?? ?? ?? 8B 4D FC 83 E0 03 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "__ldquad"
		size = 1014
		refs = "000a ___security_cookie 0021 __real@c1945f306dc9c883 0034 __real@41945f306dc9c883 0047 __real@3fe45f306dc9c883 0058 __real@3fe0000000000000 0074 __ld_int 008d __real@3fd0000000000000 0095 __real@3e50000000000000 009b __real@41b921fb50000000 00ab __real@401110b460000000 00b5 __real@3e51a62620000000 00bf __real@3cd3145c00000000 00c9 __real@3b3b839a20000000 00fe __ldunscale 0121 __ldxp_setw 014c __ldscale 0175 ___b 017f _memcpy 0195 __ldxp_mulh 01e8 __ldxp_addx 01f0 ___c 0225 __real@3fc45f306dc9c883 0242 __real@be50000000000000 0294 _get_acsize 0369 __real@bfd0000000000000 039b __ldxp_getw 03ad __real@c1dfffffffc00000 03bd __real@41dfffffffc00000 03ca __real@41e0000000000000 03d9 _fmodl 03e1 __ftol2_sse 03ee @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC B8 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 57 8B 7D 08 DD 07 DD 95 58 FF FF FF DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 05 0F 8A B2 00 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 0F 85 9F 00 00 00 DC 0D ?? ?? ?? ?? D9 EE D8 D9 DF E0 F6 C4 41 7A 08 DC 05 ?? ?? ?? ?? EB 06 DC 25 ?? ?? ?? ?? 8D 85 64 FF FF FF 6A 00 50 DD 9D 64 FF FF FF E8 ?? ?? ?? ?? DD 85 64 FF FF FF D9 EE DD E9 DF E0 59 59 F6 C4 44 7B 4C DD 05 ?? ?? ?? ?? D8 C9 DC 0D ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 C9 DC AD 58 FF FF FF D9 C1 DC 0D ?? ?? ?? ?? DE E9 D9 C1 DC 0D ?? ?? ?? ?? DE E9 D9 C1 DC 0D ?? ?? ?? ?? DE E9 D9 C9 DC 0D ?? ?? ?? ?? DE E9 DD 95 58 FF FF FF EB 06 DD 85 58 FF FF FF DD 1F E9 C7 02 00 00 53 56 6A 06 5E 8D 85 64 FF FF FF 50 8D 85 60 FF FF FF 50 DD 9D 64 FF FF FF E8 ?? ?? ?? ?? 8B 85 60 FF FF FF 59 59 66 83 F8 56 7D 1D DD 85 58 FF FF FF 8D 45 CC 51 51 DD 1C 24 56 50 E8 ?? ?? ?? ?? 83 C4 10 E9 C2 00 00 00 98 83 E8 36 C1 F8 05 0F B7 C0 89 85 60 FF FF FF 98 C1 E0 05 F7 D8 50 8D 85 58 FF FF FF 50 E8 ?? ?? ?? ?? DD 85 58 FF FF FF 8D 85 48 FF FF FF DD 1C 24 6A 02 50 E8 ?? ?? ?? ?? 0F BF 85 60 FF FF FF 6B C0 30 6A 30 8D 80 ?? ?? ?? ?? 50 8D 45 CC 50 E8 ?? ?? ?? ?? DD 85 48 FF FF FF 8D 45 CC 83 C4 14 DD 1C 24 56 50 E8 ?? ?? ?? ?? DD 85 50 FF FF FF 83 C4 10 D9 EE DA E9 DF E0 F6 C4 44 7B 42 0F BF 85 60 FF FF FF 6B C0 30 6A 30 8D 80 ?? ?? ?? ?? 50 8D 45 9C 50 E8 ?? ?? ?? ?? DD 85 50 FF FF FF 8D 45 9C 59 DD 1C 24 56 50 E8 ?? ?? ?? ?? 56 8D 45 9C 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? 83 C4 20 BB ?? ?? ?? ?? DD 45 CC DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 74 11 DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 0F 85 DB 00 00 00 DC 45 D4 8D 85 64 FF FF FF 6A 00 50 DC 0D ?? ?? ?? ?? DD 9D 64 FF FF FF E8 ?? ?? ?? ?? DD 85 64 FF FF FF 8D 85 48 FF FF FF DC 0D ?? ?? ?? ?? DD 1C 24 6A 02 50 E8 ?? ?? ?? ?? 8B C6 C1 E0 03 50 8D 45 9C 53 50 E8 ?? ?? ?? ?? DD 85 48 FF FF FF 8D 45 9C 83 C4 14 DD 1C 24 56 50 E8 ?? ?? ?? ?? DD 85 50 FF FF FF 83 C4 10 D9 EE DA E9 DF E0 F6 C4 44 7B 50 DD 45 CC 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B F0 8D 85 6C FF FF FF 8B CE C1 E1 03 51 53 50 E8 ?? ?? ?? ?? DD 85 50 FF FF FF 8D 85 6C FF FF FF 83 C4 0C DD 1C 24 56 50 E8 ?? ?? ?? ?? 56 8D 85 6C FF FF FF 50 8D 45 9C 56 50 E8 ?? ?? ?? ?? 83 C4 20 56 8D 45 9C 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? 83 C4 10 E9 02 FF FF FF DC 45 D4 DC 0D ?? ?? ?? ?? D9 EE D8 D9 DF E0 F6 C4 41 7A 08 DC 05 ?? ?? ?? ?? EB 06 DC 25 ?? ?? ?? ?? 8D 85 64 FF FF FF 6A 00 50 DD 9D 64 FF FF FF E8 ?? ?? ?? ?? DD 85 64 FF FF FF D9 EE DA E9 DF E0 59 59 F6 C4 44 7B 5A DD 45 CC 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B F0 C1 E0 03 50 8D 85 6C FF FF FF 53 50 E8 ?? ?? ?? ?? DD 85 64 FF FF FF 8D 85 6C FF FF FF DC 0D ?? ?? ?? ?? 83 C4 0C DC 0D ?? ?? ?? ?? DD 1C 24 56 50 E8 ?? ?? ?? ?? 56 8D 85 6C FF FF FF 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? 83 C4 20 8D 45 CC 56 50 E8 ?? ?? ?? ?? 59 59 DD 1F DD 85 64 FF FF FF 5E 5B DD 05 ?? ?? ?? ?? D8 D9 DF E0 5F F6 C4 41 74 0D DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 75 18 DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 E8 ?? ?? ?? ?? 8B 4D FC 83 E0 03 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_1_0 {
	meta:
		name = "__dquadph"
		size = 212
		refs = "000c __dquad 001f __d_int 0033 __real@c1cfffffff800000 0044 __real@41cfffffff800000 0053 __real@41d0000000000000 0062 _fmod 0071 __ftol2_sse 007c __real@400921fb54442d18 008a __real@3fe921fb54442d18 009c __real@3fe0000000000000 00ac __real@bfe921fb54442d18"
	strings:
		$1 = { 55 8B EC 51 51 56 8B 75 08 57 56 E8 ?? ?? ?? ?? DD 45 0C 8B F8 8D 45 F8 6A 01 50 DD 5D F8 E8 ?? ?? ?? ?? DD 45 F8 83 C4 0C DD 45 0C D8 E1 DD 55 0C DD 05 ?? ?? ?? ?? D8 DA DF E0 F6 C4 41 74 66 D9 C9 DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 75 1F DD D9 DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 1C 24 E8 ?? ?? ?? ?? DD 45 0C 83 C4 10 D9 C9 DC C0 E8 ?? ?? ?? ?? D9 C0 83 E0 03 DD 05 ?? ?? ?? ?? 03 F8 DC C9 D9 C9 DC 06 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 75 15 DD D8 47 D9 C9 DC 25 ?? ?? ?? ?? DE C9 DC 06 EB 24 DD D8 EB A7 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 0D DD D8 4F D9 C9 DC 05 ?? ?? ?? ?? EB DA DD DA DD D8 8B C7 5F DD 1E 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_1_0 {
	meta:
		name = "__ldquadph"
		size = 212
		refs = "000c __ldquad 001f __ld_int 0033 __real@c1cfffffff800000 0044 __real@41cfffffff800000 0053 __real@41d0000000000000 0062 _fmodl 0071 __ftol2_sse 007c __real@400921fb54442d18 008a __real@3fe921fb54442d18 009c __real@3fe0000000000000 00ac __real@bfe921fb54442d18"
	strings:
		$1 = { 55 8B EC 51 51 56 8B 75 08 57 56 E8 ?? ?? ?? ?? DD 45 0C 8B F8 8D 45 F8 6A 01 50 DD 5D F8 E8 ?? ?? ?? ?? DD 45 F8 83 C4 0C DD 45 0C D8 E1 DD 55 0C DD 05 ?? ?? ?? ?? D8 DA DF E0 F6 C4 41 74 66 D9 C9 DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 75 1F DD D9 DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 1C 24 E8 ?? ?? ?? ?? DD 45 0C 83 C4 10 D9 C9 DC C0 E8 ?? ?? ?? ?? D9 C0 83 E0 03 DD 05 ?? ?? ?? ?? 03 F8 DC C9 D9 C9 DC 06 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 75 15 DD D8 47 D9 C9 DC 25 ?? ?? ?? ?? DE C9 DC 06 EB 24 DD D8 EB A7 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 0D DD D8 4F D9 C9 DC 05 ?? ?? ?? ?? EB DA DD DA DD D8 8B C7 5F DD 1E 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_2_0 {
	meta:
		name = "__dsin"
		size = 274
		refs = "0008 __dtest 002a __dquad 0030 __Rteps_C 0075 __real@3e21ba39100a2609 007d __real@3e927df9c661a83b 0085 __real@3efa019f9030ac63 008d __real@3f56c16c1651fbf6 0095 __real@3fa55555555502b1 009d __real@3fdfffffffffffae 00a5 __real@3ff0000000000000 00ad __real@3de5d810c32f8fb0 00b5 __real@3e5ae5e1a1730c8f 00bd __real@3ec71de34fe4ad4d 00c5 __real@3f2a01a019b5e33e 00cd __real@3f8111111110f0fa 00d5 __real@3fc5555555555542 00ee __fperrraise 00f4 __Nan_C"
	strings:
		$1 = { 55 8B EC 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 83 E8 00 0F 84 E4 00 00 00 48 0F 84 CD 00 00 00 48 0F 84 C1 00 00 00 8D 45 08 50 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D9 C0 D9 E0 DD 45 08 59 8B 4D 10 D8 D1 03 C8 DF E0 DD D9 F6 C4 41 75 1A D8 D1 DF E0 DD D9 F6 C4 05 7A 11 F6 C1 01 0F 84 81 00 00 00 DD D8 D9 E8 EB 7B DD D9 D9 C0 D8 C9 F6 C1 01 74 3A DD D9 DD 05 ?? ?? ?? ?? D8 C9 DC 25 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 25 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 25 ?? ?? ?? ?? DE C9 DC 05 ?? ?? ?? ?? EB 36 DD 05 ?? ?? ?? ?? D8 C9 DC 25 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 25 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 25 ?? ?? ?? ?? D9 C9 D8 CA DE C9 DE C1 F6 C1 02 EB 26 DD 45 08 5D C3 6A 01 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 5D C3 F6 45 10 01 74 04 D9 E8 EB 03 DD 45 08 F6 45 10 02 74 02 D9 E0 5D C3 }
	condition:
		$1
}

rule file_38_2_0 {
	meta:
		name = "__ldsin"
		size = 274
		refs = "0008 __ldtest 002a __ldquad 0030 __LRteps_C 0075 __real@3e21ba39100a2609 007d __real@3e927df9c661a83b 0085 __real@3efa019f9030ac63 008d __real@3f56c16c1651fbf6 0095 __real@3fa55555555502b1 009d __real@3fdfffffffffffae 00a5 __real@3ff0000000000000 00ad __real@3de5d810c32f8fb0 00b5 __real@3e5ae5e1a1730c8f 00bd __real@3ec71de34fe4ad4d 00c5 __real@3f2a01a019b5e33e 00cd __real@3f8111111110f0fa 00d5 __real@3fc5555555555542 00ee __fperrraise 00f4 __LNan_C"
	strings:
		$1 = { 55 8B EC 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 83 E8 00 0F 84 E4 00 00 00 48 0F 84 CD 00 00 00 48 0F 84 C1 00 00 00 8D 45 08 50 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D9 C0 D9 E0 DD 45 08 59 8B 4D 10 D8 D1 03 C8 DF E0 DD D9 F6 C4 41 75 1A D8 D1 DF E0 DD D9 F6 C4 05 7A 11 F6 C1 01 0F 84 81 00 00 00 DD D8 D9 E8 EB 7B DD D9 D9 C0 D8 C9 F6 C1 01 74 3A DD D9 DD 05 ?? ?? ?? ?? D8 C9 DC 25 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 25 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 25 ?? ?? ?? ?? DE C9 DC 05 ?? ?? ?? ?? EB 36 DD 05 ?? ?? ?? ?? D8 C9 DC 25 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 25 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 25 ?? ?? ?? ?? D9 C9 D8 CA DE C9 DE C1 F6 C1 02 EB 26 DD 45 08 5D C3 6A 01 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 5D C3 F6 45 10 01 74 04 D9 E8 EB 03 DD 45 08 F6 45 10 02 74 02 D9 E0 5D C3 }
	condition:
		$1
}

rule file_8_3_0 {
	meta:
		name = "_get_acsize"
		size = 48
		refs = "000d __dunscale"
	strings:
		$1 = { 55 8B EC 51 8D 45 08 50 8D 45 FC 50 E8 ?? ?? ?? ?? 0F BF 45 FC 59 59 6A 35 99 59 F7 F9 8D 04 45 05 00 00 00 83 F8 06 76 03 6A 06 58 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_4_0 {
	meta:
		name = "_get_acsize"
		size = 48
		refs = "000d __ldunscale"
	strings:
		$1 = { 55 8B EC 51 8D 45 08 50 8D 45 FC 50 E8 ?? ?? ?? ?? 0F BF 45 FC 59 59 6A 35 99 59 F7 F9 8D 04 45 05 00 00 00 83 F8 06 76 03 6A 06 58 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_4_0 {
	meta:
		name = "_lgamma"
		size = 519
		refs = "0015 __d_int 0037 __Inf_C 0050 __fperrraise 0061 __dgamma_big 007d __real@400921fb54442d18 0085 __dsin 0099 __dlog 00ac _lgamma_big 00d6 _rootapprox 0120 __dpoly 012e __real@3ff3333333333333 013b __real@3ff8000000000000 0149 _approx 01b3 __dtgamma 01df __real@3e7f7d1cf79abc9e 01e9 __real@3fe62e42c0000000 01f9 _log1p"
	strings:
		$1 = { 55 8B EC 83 EC 1C DD 45 08 8D 45 F4 56 33 F6 56 50 DD 5D F4 E8 ?? ?? ?? ?? DD 45 08 98 59 59 2B C6 74 1D 48 74 0D 48 75 36 DD D8 DD 45 08 E9 CF 01 00 00 DD D8 DD 05 ?? ?? ?? ?? E9 C2 01 00 00 D9 EE D8 D9 DF E0 F6 C4 01 75 14 6A 04 DD D8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? E9 A2 01 00 00 DD 05 ?? ?? ?? ?? D9 C0 D9 E0 D8 DA DF E0 F6 C4 41 75 46 DD D8 DC 65 F4 56 56 51 51 DC 0D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DC 4D 08 83 C4 04 DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DD 5D EC DD 45 08 83 C4 04 D9 E0 DD 1C 24 E8 ?? ?? ?? ?? DC 6D EC E9 48 01 00 00 D8 D9 DF E0 F6 C4 41 7A 0F 51 51 DD 1C 24 E8 ?? ?? ?? ?? E9 30 01 00 00 8B D6 8B CE DC 91 ?? ?? ?? ?? DF E0 F6 C4 41 75 0D DC 91 ?? ?? ?? ?? DF E0 F6 C4 05 7B 0C 83 C1 28 42 81 F9 B8 01 00 00 72 DA 83 FA 0B 73 2D 6B C2 28 DC A0 ?? ?? ?? ?? FF B0 ?? ?? ?? ?? DC A0 ?? ?? ?? ?? FF B0 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 E9 D6 00 00 00 DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 75 6F DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 60 B9 ?? ?? ?? ?? DC 11 DF E0 F6 C4 05 7B 09 46 83 C1 20 83 FE 01 72 EE C1 E6 05 FF B6 ?? ?? ?? ?? DC A6 ?? ?? ?? ?? FF B6 ?? ?? ?? ?? DD 55 EC 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D E4 DD 45 EC FF B6 ?? ?? ?? ?? FF B6 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 7D E4 83 C4 10 EB 5A 8D 45 FC DD D8 50 8D 45 08 50 E8 ?? ?? ?? ?? 59 59 DD 5D F4 DD 45 08 56 51 D9 E1 51 DD 1C 24 E8 ?? ?? ?? ?? 0F BF 45 FC D9 E0 F7 D8 83 C4 04 89 45 0C DB 45 0C DD 05 ?? ?? ?? ?? D8 C9 DE C2 DC 0D ?? ?? ?? ?? DE C1 DD 5D 08 DD 45 F4 DD 1C 24 E8 ?? ?? ?? ?? DC 45 08 59 59 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_6_0 {
	meta:
		name = "_lgammal"
		size = 519
		refs = "0015 __ld_int 0037 __LInf_C 0050 __fperrraise 0061 __ldgamma_big 007d __real@400921fb54442d18 0085 __ldsin 0099 __ldlog 00ac _lgamma_big 00d6 _rootapprox 0120 __ldpoly 012e __real@3ff3333333333333 013b __real@3ff8000000000000 0149 _approx 01b3 __ldtgamma 01df __real@3e7f7d1cf79abc9e 01e9 __real@3fe62e42c0000000 01f9 _log1pl"
	strings:
		$1 = { 55 8B EC 83 EC 1C DD 45 08 8D 45 F4 56 33 F6 56 50 DD 5D F4 E8 ?? ?? ?? ?? DD 45 08 98 59 59 2B C6 74 1D 48 74 0D 48 75 36 DD D8 DD 45 08 E9 CF 01 00 00 DD D8 DD 05 ?? ?? ?? ?? E9 C2 01 00 00 D9 EE D8 D9 DF E0 F6 C4 01 75 14 6A 04 DD D8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? E9 A2 01 00 00 DD 05 ?? ?? ?? ?? D9 C0 D9 E0 D8 DA DF E0 F6 C4 41 75 46 DD D8 DC 65 F4 56 56 51 51 DC 0D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DC 4D 08 83 C4 04 DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DD 5D EC DD 45 08 83 C4 04 D9 E0 DD 1C 24 E8 ?? ?? ?? ?? DC 6D EC E9 48 01 00 00 D8 D9 DF E0 F6 C4 41 7A 0F 51 51 DD 1C 24 E8 ?? ?? ?? ?? E9 30 01 00 00 8B D6 8B CE DC 91 ?? ?? ?? ?? DF E0 F6 C4 41 75 0D DC 91 ?? ?? ?? ?? DF E0 F6 C4 05 7B 0C 83 C1 28 42 81 F9 B8 01 00 00 72 DA 83 FA 0B 73 2D 6B C2 28 DC A0 ?? ?? ?? ?? FF B0 ?? ?? ?? ?? DC A0 ?? ?? ?? ?? FF B0 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 E9 D6 00 00 00 DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 75 6F DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 60 B9 ?? ?? ?? ?? DC 11 DF E0 F6 C4 05 7B 09 46 83 C1 20 83 FE 01 72 EE C1 E6 05 FF B6 ?? ?? ?? ?? DC A6 ?? ?? ?? ?? FF B6 ?? ?? ?? ?? DD 55 EC 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D E4 DD 45 EC FF B6 ?? ?? ?? ?? FF B6 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 7D E4 83 C4 10 EB 5A 8D 45 FC DD D8 50 8D 45 08 50 E8 ?? ?? ?? ?? 59 59 DD 5D F4 DD 45 08 56 51 D9 E1 51 DD 1C 24 E8 ?? ?? ?? ?? 0F BF 45 FC D9 E0 F7 D8 83 C4 04 89 45 0C DB 45 0C DD 05 ?? ?? ?? ?? D8 C9 DE C2 DC 0D ?? ?? ?? ?? DE C1 DD 5D 08 DD 45 F4 DD 1C 24 E8 ?? ?? ?? ?? DC 45 08 59 59 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_5_0 {
	meta:
		name = "_lgamma_big"
		size = 157
		refs = "001a __dlog 0032 __real@3fe0000000000000 0044 __dunscale 005b __dscale 006c __real@3f4a01a01a01a01a 0074 __real@3f66c16c16c16c17 007c __real@3fb5555555555555 0085 __real@3fdacfe390c97d69 0091 __fperrraise"
	strings:
		$1 = { 55 8B EC 83 EC 1C D9 E8 DD 45 08 DC F9 D9 C9 6A 00 51 51 DD 5D EC DD 1C 24 E8 ?? ?? ?? ?? D9 E8 8D 45 F4 DE E9 50 8D 45 FC 50 DD 5D E4 DD 45 08 DC 25 ?? ?? ?? ?? DD 5D F4 DD 45 EC D9 C0 DE C9 DD 5D 08 E8 ?? ?? ?? ?? DD 45 F4 0F BF 45 FC DC 4D E4 50 8D 45 F4 50 DD 5D F4 E8 ?? ?? ?? ?? 83 C4 1C 66 85 C0 79 27 DD 45 08 DD 05 ?? ?? ?? ?? D8 C9 DC 25 ?? ?? ?? ?? DE C9 DC 05 ?? ?? ?? ?? DC 4D EC DC 05 ?? ?? ?? ?? DC 45 F4 EB 0B 6A 08 E8 ?? ?? ?? ?? DD 45 F4 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_5_0 {
	meta:
		name = "_lgamma_big"
		size = 157
		refs = "001a __ldlog 0032 __real@3fe0000000000000 0044 __ldunscale 005b __ldscale 006c __real@3f4a01a01a01a01a 0074 __real@3f66c16c16c16c17 007c __real@3fb5555555555555 0085 __real@3fdacfe390c97d69 0091 __fperrraise"
	strings:
		$1 = { 55 8B EC 83 EC 1C D9 E8 DD 45 08 DC F9 D9 C9 6A 00 51 51 DD 5D EC DD 1C 24 E8 ?? ?? ?? ?? D9 E8 8D 45 F4 DE E9 50 8D 45 FC 50 DD 5D E4 DD 45 08 DC 25 ?? ?? ?? ?? DD 5D F4 DD 45 EC D9 C0 DE C9 DD 5D 08 E8 ?? ?? ?? ?? DD 45 F4 0F BF 45 FC DC 4D E4 50 8D 45 F4 50 DD 5D F4 E8 ?? ?? ?? ?? 83 C4 1C 66 85 C0 79 27 DD 45 08 DD 05 ?? ?? ?? ?? D8 C9 DC 25 ?? ?? ?? ?? DE C9 DC 05 ?? ?? ?? ?? DC 4D EC DC 05 ?? ?? ?? ?? DC 45 F4 EB 0B 6A 08 E8 ?? ?? ?? ?? DD 45 F4 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "___libm_sse2_sincos"
		size = 489
		refs = "001f _PI32INV 002b _SHIFTER 003b _P_1 0047 _P_2 0060 _SC_4 0066 _Ctable 007b _P_3 009c _SC_2 00ee _SC_3 00fa _SC_1 017a _ONE 0188 _ALL_ONES 0191 _TWO_POW_55 01a1 _TWO_POW_M55 01be _cos 01d2 _sin"
	strings:
		$1 = { 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 4B 01 00 00 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 15 ?? ?? ?? ?? F2 0F 2D D1 66 0F 58 CA 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D9 81 C2 00 76 1C 00 66 0F 28 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 06 03 C2 66 0F 59 D1 66 0F 5C C3 66 0F 59 0D ?? ?? ?? ?? 66 0F 5C E3 66 0F 28 78 10 66 0F 28 DC 66 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 FC 66 0F 5C DC 66 0F 59 E8 66 0F 59 C0 66 0F 5C DA 66 0F 28 10 66 0F 5C CB 66 0F 28 58 30 66 0F 58 D3 66 0F 5C FA 66 0F 59 CF 66 0F 28 78 10 66 0F 59 D4 66 0F 59 F0 66 0F 59 DC 66 0F 59 D0 66 0F 59 F8 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 C3 66 0F 58 58 10 66 0F 58 F5 F2 0F 10 EE 66 0F 15 F6 66 0F 14 ED 66 0F 59 F7 66 0F 59 D5 66 0F 28 FC 66 0F 58 E3 66 0F 28 68 10 66 0F 5C EB 66 0F 5C DC 66 0F 58 48 20 66 0F 58 E8 66 0F 58 DF 66 0F 58 CD 66 0F 58 CB 66 0F 58 CA 66 0F 58 CE 66 0F 58 CC F2 0F 10 C1 66 0F 15 C9 C3 7F 42 F2 0F 10 C8 66 0F C5 C0 03 66 0D 00 80 66 0F C4 C8 03 F2 0F 58 0D ?? ?? ?? ?? 66 3D 10 80 7D 09 F2 0F 59 05 ?? ?? ?? ?? C3 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 5C C3 F2 0F 59 05 ?? ?? ?? ?? C3 8B C4 83 EC 20 83 E4 F0 89 44 24 08 66 0F D6 44 24 10 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 5C 24 18 F3 0F 7E 44 24 10 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 F3 0F 7E 4C 24 18 8B 64 24 08 C3 }
	condition:
		$1
}

rule file_10_1_0 {
	meta:
		name = "__wtoi64"
		size = 20
		refs = "000b __wcstoi64"
		altNames = "__wtoll"
	strings:
		$1 = { 55 8B EC 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_712_0_0 {
	meta:
		name = "__atoi64"
		size = 20
		refs = "000b __strtoi64"
	strings:
		$1 = { 55 8B EC 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_10_4_0 {
	meta:
		name = "__wtol"
		size = 20
		refs = "000b _wcstol"
	strings:
		$1 = { 55 8B EC 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_712_6_0 {
	meta:
		name = "_atol"
		size = 20
		refs = "000b _strtol"
	strings:
		$1 = { 55 8B EC 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_712_7_0 {
	meta:
		name = "_atoll"
		size = 20
		refs = "000b __strtoi64"
	strings:
		$1 = { 55 8B EC 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_10_2_0 {
	meta:
		name = "__wtoi64_l"
		size = 23
		refs = "000e __wcstoi64_l"
		altNames = "__wtoll_l"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_712_1_0 {
	meta:
		name = "__atoi64_l"
		size = 23
		refs = "000e __strtoi64_l"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_712_3_0 {
	meta:
		name = "__atol_l"
		size = 23
		refs = "000e __strtol_l"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_712_4_0 {
	meta:
		name = "__atoll_l"
		size = 23
		refs = "000e __strtoi64_l"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_10_5_0 {
	meta:
		name = "__wtol_l"
		size = 23
		refs = "000e __wcstol_l"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_11_3_0 {
	meta:
		name = "__mbsnbicoll"
		size = 24
		refs = "000f __mbsnbicoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_53_0_1 {
	meta:
		name = "__Stod"
		size = 24
		refs = "000f __Stodx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_104_0_2 {
	meta:
		name = "__Stof"
		size = 24
		refs = "000f __Stofx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_110_0_1 {
	meta:
		name = "__Stold"
		size = 24
		refs = "000f __Stoldx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_118_0_2 {
	meta:
		name = "__Stoll"
		size = 24
		refs = "000f __Stollx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_38_0_1 {
	meta:
		name = "__Stoul"
		size = 24
		refs = "000f __Stoulx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_37_0_2 {
	meta:
		name = "__Stoull"
		size = 24
		refs = "000f __Stoullx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_102_0_2 {
	meta:
		name = "__WStod"
		size = 24
		refs = "000f __WStodx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_85_0_2 {
	meta:
		name = "__WStof"
		size = 24
		refs = "000f __WStofx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_70_0_2 {
	meta:
		name = "__WStold"
		size = 24
		refs = "000f __WStoldx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1003_6_0 {
	meta:
		name = "__aligned_realloc"
		size = 24
		refs = "000f __aligned_offset_realloc"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1112_7_0 {
	meta:
		name = "__atoflt_l"
		size = 24
		refs = "000f ___crt_atoflt_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1299_18_0 {
	meta:
		name = "__fassign"
		size = 24
		refs = "000f __fassign_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_370_0_0 {
	meta:
		name = "__mbscat_s"
		size = 24
		refs = "000f __mbscat_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_559_0_0 {
	meta:
		name = "__mbscpy_s"
		size = 24
		refs = "000f __mbscpy_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_305_3_0 {
	meta:
		name = "__mbsnbcat"
		size = 24
		refs = "000f __mbsnbcat_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_487_3_0 {
	meta:
		name = "__mbsnbcmp"
		size = 24
		refs = "000f __mbsnbcmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1143_3_0 {
	meta:
		name = "__mbsnbcoll"
		size = 24
		refs = "000f __mbsnbcoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_646_3_0 {
	meta:
		name = "__mbsnbcpy"
		size = 24
		refs = "000f __mbsnbcpy_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1239_3_0 {
	meta:
		name = "__mbsnbicmp"
		size = 24
		refs = "000f __mbsnbicmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_65_3_0 {
	meta:
		name = "__mbsnbset"
		size = 24
		refs = "000f __mbsnbset_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_107_3_0 {
	meta:
		name = "__mbsncat"
		size = 24
		refs = "000f __mbsncat_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1289_3_0 {
	meta:
		name = "__mbsncmp"
		size = 24
		refs = "000f __mbsncmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1028_3_0 {
	meta:
		name = "__mbsncoll"
		size = 24
		refs = "000f __mbsncoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_983_3_0 {
	meta:
		name = "__mbsncpy"
		size = 24
		refs = "000f __mbsncpy_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_366_3_0 {
	meta:
		name = "__mbsnicmp"
		size = 24
		refs = "000f __mbsnicmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_566_3_0 {
	meta:
		name = "__mbsnicoll"
		size = 24
		refs = "000f __mbsnicoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_887_3_0 {
	meta:
		name = "__mbsnset"
		size = 24
		refs = "000f __mbsnset_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1398_0_0 {
	meta:
		name = "__mbsset_s"
		size = 24
		refs = "000f __mbsset_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1075_3_0 {
	meta:
		name = "__mbstok_s"
		size = 24
		refs = "000f __mbstok_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "__spawnvp"
		size = 24
		refs = "000f __spawnvpe"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1120_1_0 {
	meta:
		name = "__wcstol_l"
		size = 24
		refs = "000f ?wcstoxl@@YAKPB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "__wspawnvp"
		size = 24
		refs = "000f __wspawnvpe"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_393_4_0 {
	meta:
		name = "_mbtowc"
		size = 24
		refs = "000f __mbtowc_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1279_4_0 {
	meta:
		name = "_strxfrm"
		size = 24
		refs = "000f __strxfrm_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1120_3_0 {
	meta:
		name = "_wcstol"
		size = 24
		refs = "000f ?wcstoxl@@YAKPB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_533_7_0 {
	meta:
		name = "_wcstombs"
		size = 24
		refs = "000f __wcstombs_l_helper"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_772_4_0 {
	meta:
		name = "_wcsxfrm"
		size = 24
		refs = "000f __wcsxfrm_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_11_4_0 {
	meta:
		name = "__mbsnbicoll_l"
		size = 182
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0030 __errno 003b __invalid_parameter_noinfo 0071 __strnicoll_l 0093 ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 83 EC 10 8D 4D F0 56 57 FF 75 14 E8 ?? ?? ?? ?? 8B 45 10 85 C0 75 07 33 F6 E9 80 00 00 00 8B 4D 08 85 C9 74 07 8B 55 0C 85 D2 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? BE FF FF FF 7F EB 5B BE FF FF FF 7F 3B C6 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 40 8B 7D F4 83 7F 08 00 75 12 FF 75 14 50 52 51 E8 ?? ?? ?? ?? 83 C4 10 8B F0 EB 25 FF 77 04 50 52 50 51 68 01 10 00 00 FF B7 1C 02 00 00 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 03 8D 70 FE 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 5F 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "_ilogb"
		size = 56
		refs = "000d __dunscale"
	strings:
		$1 = { 55 8B EC 51 8D 45 08 50 8D 45 FC 50 E8 ?? ?? ?? ?? 98 59 59 83 E8 00 74 16 48 74 0C 48 74 09 66 8B 45 FC 66 48 98 EB 0C B8 FF FF FF 7F EB 05 B8 00 00 00 80 8B E5 5D C3 }
	condition:
		$1
}

rule file_332_0_0 {
	meta:
		name = "_ilogbf"
		size = 56
		refs = "000d __fdunscale"
	strings:
		$1 = { 55 8B EC 51 8D 45 08 50 8D 45 FC 50 E8 ?? ?? ?? ?? 98 59 59 83 E8 00 74 16 48 74 0C 48 74 09 66 8B 45 FC 66 48 98 EB 0C B8 FF FF FF 7F EB 05 B8 00 00 00 80 8B E5 5D C3 }
	condition:
		$1
}

rule file_889_0_0 {
	meta:
		name = "_ilogbl"
		size = 56
		refs = "000d __ldunscale"
	strings:
		$1 = { 55 8B EC 51 8D 45 08 50 8D 45 FC 50 E8 ?? ?? ?? ?? 98 59 59 83 E8 00 74 16 48 74 0C 48 74 09 66 8B 45 FC 66 48 98 EB 0C B8 FF FF FF 7F EB 05 B8 00 00 00 80 8B E5 5D C3 }
	condition:
		$1
}

rule file_14_1_0 {
	meta:
		name = "?_invoke_watson@@YAXPBG00II@Z"
		size = 24
		refs = "0013 __invoke_watson"
	strings:
		$1 = { 55 8B EC FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_14_2_0 {
	meta:
		name = "__call_reportfault"
		size = 293
		refs = "000a ___security_cookie 001e __crt_debugger_hook 0036 _memset 00ec __imp__IsDebuggerPresent@0 00fa ___crtUnhandledException 011d @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 28 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 7D 08 FF 57 74 09 FF 75 08 E8 ?? ?? ?? ?? 59 83 A5 E0 FC FF FF 00 8D 85 E4 FC FF FF 6A 4C 6A 00 50 E8 ?? ?? ?? ?? 8D 85 E0 FC FF FF 83 C4 0C 89 85 D8 FC FF FF 8D 85 30 FD FF FF 89 85 DC FC FF FF 89 85 E0 FD FF FF 89 8D DC FD FF FF 89 95 D8 FD FF FF 89 9D D4 FD FF FF 89 B5 D0 FD FF FF 89 BD CC FD FF FF 66 8C 95 F8 FD FF FF 66 8C 8D EC FD FF FF 66 8C 9D C8 FD FF FF 66 8C 85 C4 FD FF FF 66 8C A5 C0 FD FF FF 66 8C AD BC FD FF FF 9C 8F 85 F0 FD FF FF 8B 45 04 89 85 E8 FD FF FF 8D 45 04 89 85 F4 FD FF FF C7 85 30 FD FF FF 01 00 01 00 8B 40 FC 89 85 E4 FD FF FF 8B 45 0C 89 85 E0 FC FF FF 8B 45 10 89 85 E4 FC FF FF 8B 45 04 89 85 EC FC FF FF FF 15 ?? ?? ?? ?? 8B F8 8D 85 D8 FC FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 75 13 85 FF 75 0F 83 7D 08 FF 74 09 FF 75 08 E8 ?? ?? ?? ?? 59 8B 4D FC 33 CD 5F E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_14_5_0 {
	meta:
		name = "__invalid_parameter"
		size = 43
		refs = "0005 ___pInvalidArgHandler 000b __imp__DecodePointer@4 0026 __invoke_watson"
	strings:
		$1 = { 55 8B EC FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 03 5D FF E0 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_14_6_0 {
	meta:
		name = "__invalid_parameter_noinfo"
		size = 16
		refs = "0008 __invalid_parameter"
	strings:
		$1 = { 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_14_7_0 {
	meta:
		name = "__invalid_parameter_noinfo_noreturn"
		size = 27
		refs = "0009 __invalid_parameter 0016 __invoke_watson"
	strings:
		$1 = { 56 33 F6 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 56 56 56 56 56 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_14_8_0 {
	meta:
		name = "__invoke_watson"
		size = 43
		refs = "0003 _IsProcessorFeaturePresent@4 001c __call_reportfault 0022 ___crtTerminateProcess"
	strings:
		$1 = { 6A 17 E8 ?? ?? ?? ?? 85 C0 74 05 6A 05 59 CD 29 56 6A 01 BE 17 04 00 C0 56 6A 02 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 10 5E C3 }
	condition:
		$1
}

rule file_14_9_0 {
	meta:
		name = "__set_invalid_parameter_handler"
		size = 37
		refs = "0006 ___pInvalidArgHandler 000c __imp__DecodePointer@4 0017 __imp__EncodePointer@4"
	strings:
		$1 = { 55 8B EC 56 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF 75 08 8B F0 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "?__set_inconsistency@@YAP6AXXZP6AXXZ@Z"
		size = 37
		refs = "0006 ?__pInconsistency@@3P6AXXZA 000c __imp__DecodePointer@4 0017 __imp__EncodePointer@4"
	strings:
		$1 = { 55 8B EC 56 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF 75 08 8B F0 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_111_2_0 {
	meta:
		name = "__set_purecall_handler"
		size = 37
		refs = "0006 ___pPurecall 000c __imp__DecodePointer@4 0017 __imp__EncodePointer@4"
	strings:
		$1 = { 55 8B EC 56 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF 75 08 8B F0 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "_nexttoward"
		size = 344
		refs = "000b __dtest 0029 __ldtest 00f3 __fperrraise"
	strings:
		$1 = { 55 8B EC 53 56 8D 45 08 57 50 E8 ?? ?? ?? ?? 59 6A 02 0F B7 F0 BB F0 7F 00 00 5F 66 3B F7 0F 84 1A 01 00 00 8D 45 10 50 E8 ?? ?? ?? ?? DD 45 10 59 66 3B C7 0F 84 01 01 00 00 DD 45 08 DD E1 DF E0 F6 C4 44 0F 8B EF 00 00 00 33 C9 41 66 3B F1 75 22 8B 45 0E DD D8 0F B7 C0 DD D8 25 EF FF 00 00 C7 45 0A FF FF FF FF 0D EF 7F 00 00 B9 FF FF 00 00 EB 17 66 85 F6 75 1F DE D9 DF E0 F6 C4 05 7A 04 33 C0 EB 05 B8 00 80 00 00 66 89 45 0E 66 89 4D 08 E9 A6 00 00 00 D8 D1 DF E0 D9 EE F6 C4 05 7A 09 D8 D1 DF E0 F6 C4 05 7B 16 D9 CA D8 D9 DF E0 F6 C4 05 7A 43 DE D9 DF E0 F6 C4 05 7A 3E EB 06 DD D9 DD D9 DD D8 66 FF 45 08 75 70 66 FF 45 0A 75 6A 66 FF 45 0C 75 64 66 8B 45 0E 66 40 66 89 45 0E 0F B7 C0 25 FF 7F FF FF 3B C3 75 4E 6A 08 E8 ?? ?? ?? ?? 59 EB 44 DD D8 DD D8 66 8B 45 08 B9 FF FF 00 00 66 03 C1 66 89 45 08 66 3B C1 75 2B 66 8B 45 0A 66 03 C1 66 89 45 0A 66 3B C1 75 1B 66 8B 45 0C 66 03 C1 66 89 45 0C 66 3B C1 75 0B 66 01 4D 0E EB 05 DD D8 DD 5D 08 8B 45 0E 5F 0F B7 C0 5E 85 C3 5B 75 08 6A 10 E8 ?? ?? ?? ?? 59 DD 45 08 5D C3 }
	condition:
		$1
}

rule file_1135_0_0 {
	meta:
		name = "_nexttowardl"
		size = 344
		refs = "000b __ldtest 00f3 __fperrraise"
	strings:
		$1 = { 55 8B EC 53 56 8D 45 08 57 50 E8 ?? ?? ?? ?? 59 6A 02 0F B7 F0 BB F0 7F 00 00 5F 66 3B F7 0F 84 1A 01 00 00 8D 45 10 50 E8 ?? ?? ?? ?? DD 45 10 59 66 3B C7 0F 84 01 01 00 00 DD 45 08 DD E1 DF E0 F6 C4 44 0F 8B EF 00 00 00 33 C9 41 66 3B F1 75 22 8B 45 0E DD D8 0F B7 C0 DD D8 25 EF FF 00 00 C7 45 0A FF FF FF FF 0D EF 7F 00 00 B9 FF FF 00 00 EB 17 66 85 F6 75 1F DE D9 DF E0 F6 C4 05 7A 04 33 C0 EB 05 B8 00 80 00 00 66 89 45 0E 66 89 4D 08 E9 A6 00 00 00 D8 D1 DF E0 D9 EE F6 C4 05 7A 09 D8 D1 DF E0 F6 C4 05 7B 16 D9 CA D8 D9 DF E0 F6 C4 05 7A 43 DE D9 DF E0 F6 C4 05 7A 3E EB 06 DD D9 DD D9 DD D8 66 FF 45 08 75 70 66 FF 45 0A 75 6A 66 FF 45 0C 75 64 66 8B 45 0E 66 40 66 89 45 0E 0F B7 C0 25 FF 7F FF FF 3B C3 75 4E 6A 08 E8 ?? ?? ?? ?? 59 EB 44 DD D8 DD D8 66 8B 45 08 B9 FF FF 00 00 66 03 C1 66 89 45 08 66 3B C1 75 2B 66 8B 45 0A 66 03 C1 66 89 45 0A 66 3B C1 75 1B 66 8B 45 0C 66 03 C1 66 89 45 0C 66 3B C1 75 0B 66 01 4D 0E EB 05 DD D8 DD 5D 08 8B 45 0E 5F 0F B7 C0 5E 85 C3 5B 75 08 6A 10 E8 ?? ?? ?? ?? 59 DD 45 08 5D C3 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "_wcsncmp"
		size = 54
	strings:
		$1 = { 55 8B EC 8B 45 10 85 C0 75 02 5D C3 8B 4D 0C 8B 55 08 56 48 74 15 0F B7 32 66 85 F6 74 0D 66 3B 31 75 08 83 C2 02 83 C1 02 EB E8 0F B7 02 0F B7 09 2B C1 5E 5D C3 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "__ldpoly"
		size = 37
		altNames = "__LPoly __Poly __dpoly"
	strings:
		$1 = { 55 8B EC 8B 4D 10 8B 45 14 48 DD 01 78 15 DD 45 08 EB 02 D9 C9 DC C9 83 C1 08 48 D9 C9 DC 01 79 F2 DD D9 5D C3 }
	condition:
		$1
}

rule file_19_1_0 {
	meta:
		name = "_erfcl"
		size = 474
		refs = "000c __ldtest 002b __real@3fde861fbb24c00a 0043 _erfl 0054 __real@3ff85e353f7ced91 0074 __real@3fe8000000000000 0079 _s00 0086 __ldpoly 0096 _c00 00b1 __real@3ff4800000000000 00b6 _s01 00d3 _c01 00ef _approx 010a __fperrraise 0171 __ld_int 018a _exp 01a9 __ldexp 01cd __real@4000000000000000"
	strings:
		$1 = { 55 8B EC 83 EC 18 8D 45 08 56 50 E8 ?? ?? ?? ?? 98 59 83 E8 00 0F 84 B8 01 00 00 48 0F 84 98 01 00 00 48 0F 84 8C 01 00 00 DD 05 ?? ?? ?? ?? DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 15 51 51 DD 1C 24 E8 ?? ?? ?? ?? D9 E8 59 59 DE E1 E9 83 01 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 0F 85 87 00 00 00 D9 E8 D8 D9 DF E0 6A 08 F6 C4 41 75 3D DC 25 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 51 DD 55 F8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D F0 DD 45 F8 6A 09 68 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 7D F0 83 C4 10 E9 26 01 00 00 DC 25 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 51 DD 55 F8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D F0 DD 45 F8 6A 09 68 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 7D F0 83 C4 10 E9 E9 00 00 00 33 F6 B9 ?? ?? ?? ?? DC 11 DF E0 F6 C4 05 7B 1A 46 83 C1 20 83 FE 06 72 EE 6A 10 DD D8 E8 ?? ?? ?? ?? 59 D9 EE E9 BF 00 00 00 D9 E8 DE F1 C1 E6 05 FF B6 ?? ?? ?? ?? DC A6 ?? ?? ?? ?? FF B6 ?? ?? ?? ?? DD 55 F0 51 DD 55 F8 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 DD 45 F0 FF B6 ?? ?? ?? ?? FF B6 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 7D E8 8D 45 F8 6A 11 50 DD 5D E8 DD 45 08 DD 5D F8 E8 ?? ?? ?? ?? DD 45 F8 83 C4 10 D9 C0 DD 45 08 DC E9 DE C2 DE C9 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E8 8D 45 F8 DD 45 F8 59 DC C8 59 6A 00 51 51 D9 E0 DD 5D F8 DD 1C 24 50 E8 ?? ?? ?? ?? DD 45 F8 83 C4 10 EB 20 DD 45 08 EB 1B 8B 45 0E 0F B7 C0 A9 00 80 00 00 0F 84 44 FF FF FF DD 05 ?? ?? ?? ?? EB 02 D9 E8 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_1364_1_0 {
	meta:
		name = "_erfc"
		size = 474
		refs = "000c __dtest 002b __real@3fde861fbb24c00a 0043 _erf 0054 __real@3ff85e353f7ced91 0074 __real@3fe8000000000000 0079 _s00 0086 __dpoly 0096 _c00 00b1 __real@3ff4800000000000 00b6 _s01 00d3 _c01 00ef _approx 010a __fperrraise 0171 __d_int 018a _exp 01a9 __dexp 01cd __real@4000000000000000"
	strings:
		$1 = { 55 8B EC 83 EC 18 8D 45 08 56 50 E8 ?? ?? ?? ?? 98 59 83 E8 00 0F 84 B8 01 00 00 48 0F 84 98 01 00 00 48 0F 84 8C 01 00 00 DD 05 ?? ?? ?? ?? DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 15 51 51 DD 1C 24 E8 ?? ?? ?? ?? D9 E8 59 59 DE E1 E9 83 01 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 0F 85 87 00 00 00 D9 E8 D8 D9 DF E0 6A 08 F6 C4 41 75 3D DC 25 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 51 DD 55 F8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D F0 DD 45 F8 6A 09 68 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 7D F0 83 C4 10 E9 26 01 00 00 DC 25 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 51 DD 55 F8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D F0 DD 45 F8 6A 09 68 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 7D F0 83 C4 10 E9 E9 00 00 00 33 F6 B9 ?? ?? ?? ?? DC 11 DF E0 F6 C4 05 7B 1A 46 83 C1 20 83 FE 06 72 EE 6A 10 DD D8 E8 ?? ?? ?? ?? 59 D9 EE E9 BF 00 00 00 D9 E8 DE F1 C1 E6 05 FF B6 ?? ?? ?? ?? DC A6 ?? ?? ?? ?? FF B6 ?? ?? ?? ?? DD 55 F0 51 DD 55 F8 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 DD 45 F0 FF B6 ?? ?? ?? ?? FF B6 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 7D E8 8D 45 F8 6A 11 50 DD 5D E8 DD 45 08 DD 5D F8 E8 ?? ?? ?? ?? DD 45 F8 83 C4 10 D9 C0 DD 45 08 DC E9 DE C2 DE C9 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E8 8D 45 F8 DD 45 F8 59 DC C8 59 6A 00 51 51 D9 E0 DD 5D F8 DD 1C 24 50 E8 ?? ?? ?? ?? DD 45 F8 83 C4 10 EB 20 DD 45 08 EB 1B 8B 45 0E 0F B7 C0 A9 00 80 00 00 0F 84 44 FF FF FF DD 05 ?? ?? ?? ?? EB 02 D9 E8 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_19_2_0 {
	meta:
		name = "_expl"
		size = 20
		refs = "000c _exp"
	strings:
		$1 = { 55 8B EC DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_49_4_2 {
	meta:
		name = "?log@@YAOO@Z"
		size = 20
		refs = "000c _log"
	strings:
		$1 = { 55 8B EC DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1098_1_0 {
	meta:
		name = "_cosl"
		size = 20
		refs = "000c _cos"
	strings:
		$1 = { 55 8B EC DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_565_2_0 {
	meta:
		name = "_logl"
		size = 20
		refs = "000c _log"
	strings:
		$1 = { 55 8B EC DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_209_1_0 {
	meta:
		name = "_sinhl"
		size = 20
		refs = "000c _sinh"
	strings:
		$1 = { 55 8B EC DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1065_3_0 {
	meta:
		name = "_sinl"
		size = 20
		refs = "000c _sin"
	strings:
		$1 = { 55 8B EC DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1036_13_0 {
	meta:
		name = "_sqrtl"
		size = 20
		refs = "000c _sqrt"
	strings:
		$1 = { 55 8B EC DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_209_3_0 {
	meta:
		name = "_tanl"
		size = 20
		refs = "000c _tan"
	strings:
		$1 = { 55 8B EC DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "_qsort_s"
		size = 916
		refs = "000a ___security_cookie 0046 __errno 0051 __invalid_parameter_noinfo 005e @__security_check_cookie@4 00b0 _shortsort_s 00e4 _swap_c"
	strings:
		$1 = { 55 8B EC 81 EC 20 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 18 8B 55 0C 53 8B 5D 14 56 8B 75 10 57 8B 7D 08 89 BD FC FE FF FF 89 B5 04 FF FF FF 89 9D F8 FE FF FF 89 8D 00 FF FF FF 85 FF 75 25 85 D2 74 21 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 85 F6 74 DB 85 DB 74 D7 83 FA 02 72 E2 4A C7 85 F4 FE FF FF 00 00 00 00 0F AF D6 03 D7 89 95 08 FF FF FF 8D A4 24 00 00 00 00 8B C2 33 D2 2B C7 F7 F6 8D 78 01 83 FF 08 77 1C 51 53 56 FF B5 08 FF FF FF FF B5 FC FE FF FF E8 ?? ?? ?? ?? 83 C4 14 E9 A9 02 00 00 8B 85 FC FE FF FF D1 EF 0F AF FE 03 F8 57 50 51 89 BD EC FE FF FF FF D3 83 C4 0C 85 C0 7E 10 56 57 FF B5 FC FE FF FF E8 ?? ?? ?? ?? 83 C4 0C FF B5 08 FF FF FF FF B5 FC FE FF FF FF B5 00 FF FF FF FF D3 83 C4 0C 85 C0 7E 15 56 FF B5 08 FF FF FF FF B5 FC FE FF FF E8 ?? ?? ?? ?? 83 C4 0C FF B5 08 FF FF FF 57 FF B5 00 FF FF FF FF D3 83 C4 0C 85 C0 7E 10 56 FF B5 08 FF FF FF 57 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 08 FF FF FF 8B D8 8B B5 FC FE FF FF 8B 95 04 FF FF FF 89 85 E8 FE FF FF EB 03 8D 49 00 3B FE 76 31 03 F2 89 B5 F0 FE FF FF 3B F7 73 1F 57 56 FF B5 00 FF FF FF FF 95 F8 FE FF FF 8B 95 04 FF FF FF 83 C4 0C 85 C0 7E D9 3B FE 77 40 8B 85 08 FF FF FF 8B 9D F8 FE FF FF EB 03 8D 49 00 03 F2 3B F0 77 1D 57 56 FF B5 00 FF FF FF FF D3 8B 95 04 FF FF FF 83 C4 0C 85 C0 8B 85 08 FF FF FF 7E DD 8B 9D E8 FE FF FF 89 B5 F0 FE FF FF 8B B5 F8 FE FF FF 8B 95 04 FF FF FF 2B DA 3B DF 76 17 57 53 FF B5 00 FF FF FF FF D6 83 C4 0C 85 C0 7F E3 8B 95 04 FF FF FF 8B B5 F0 FE FF FF 89 9D E8 FE FF FF 3B DE 72 5C 89 95 E4 FE FF FF 89 9D E0 FE FF FF 3B F3 74 31 8B FE 8B D3 8B B5 E4 FE FF FF 2B FB 8A 02 8D 52 01 8A 4C 17 FF 88 44 17 FF 88 4A FF 4E 75 ED 8B B5 F0 FE FF FF 8B BD EC FE FF FF 8B 95 04 FF FF FF 8B 85 08 FF FF FF 3B FB 0F 85 09 FF FF FF 8B FE 89 BD EC FE FF FF E9 FC FE FF FF 03 DA 3B FB 73 2B 8D 9B 00 00 00 00 2B DA 3B DF 76 1F 57 53 FF B5 00 FF FF FF FF 95 F8 FE FF FF 8B 95 04 FF FF FF 83 C4 0C 85 C0 74 DF 3B FB 72 32 8B B5 F8 FE FF FF EB 03 8D 49 00 2B DA 3B 9D FC FE FF FF 76 17 57 53 FF B5 00 FF FF FF FF D6 8B 95 04 FF FF FF 83 C4 0C 85 C0 74 DF 8B B5 F0 FE FF FF 8B 95 08 FF FF FF 8B C3 8B BD FC FE FF FF 8B CA 2B CE 2B C7 3B C1 7C 3F 3B FB 73 18 8B 85 F4 FE FF FF 89 BC 85 0C FF FF FF 89 5C 85 84 40 89 85 F4 FE FF FF 8B 9D F8 FE FF FF 3B F2 73 52 8B 8D 00 FF FF FF 8B FE 8B B5 04 FF FF FF 89 BD FC FE FF FF E9 72 FD FF FF 3B F2 73 18 8B 85 F4 FE FF FF 89 B4 85 0C FF FF FF 89 54 85 84 40 89 85 F4 FE FF FF 8B B5 04 FF FF FF 3B FB 73 1B 8B 8D 00 FF FF FF 8B D3 8B 9D F8 FE FF FF E9 2C FD FF FF 8B B5 04 FF FF FF EB 06 8B 9D F8 FE FF FF 8B 85 F4 FE FF FF 48 89 85 F4 FE FF FF 0F 88 DD FC FF FF 8B BC 85 0C FF FF FF 8B 54 85 84 8B 8D 00 FF FF FF 89 BD FC FE FF FF E9 EF FC FF FF }
	condition:
		$1
}

rule file_22_1_0 {
	meta:
		name = "_shortsort_s"
		size = 119
	strings:
		$1 = { 55 8B EC 8B 4D 08 53 8B 5D 0C 3B D9 76 66 8B 45 10 56 57 8D 14 01 8B F2 8B F9 3B F3 77 1F 8B FF 57 56 FF 75 18 FF 55 14 83 C4 0C 85 C0 7E 02 8B FE 8B 45 10 03 F0 3B F3 76 E6 8B 4D 08 8B F0 8B D3 3B FB 74 24 85 C0 74 20 2B FB EB 03 8D 49 00 8A 02 8D 52 01 8A 4C 17 FF 88 44 17 FF 88 4A FF 4E 75 ED 8B 45 10 8B 4D 08 2B D8 8D 14 01 3B D9 77 A4 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_22_2_0 {
	meta:
		name = "_swap_c"
		size = 55
		altNames = "_swap"
	strings:
		$1 = { 55 8B EC 8B 45 0C 57 8B 7D 08 3B F8 74 26 56 8B 75 10 85 F6 74 1D 2B F8 EB 06 8D 9B 00 00 00 00 8A 08 8D 40 01 8A 54 07 FF 88 4C 07 FF 88 50 FF 4E 75 ED 5E 5F 5D C3 }
	condition:
		$1
}

rule file_23_1_0 {
	meta:
		name = "_system"
		size = 245
		refs = "0007 ___security_cookie 0018 ??_C@_07CFPBBAOO@COMSPEC?$AA@ 0024 __dupenv_s 0050 __access_s 0060 ??_C@_02HNHPBPFE@?1c?$AA@ 0070 __errno 0087 __spawnve 00b9 ??_C@_07INNMNHPJ@cmd?4exe?$AA@ 00c4 __spawnvpe 00d3 _free 00e2 @__security_check_cookie@4 00f0 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 EC 18 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 33 DB 8D 45 E8 68 ?? ?? ?? ?? 53 50 89 5D E8 8B F3 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 09 83 F8 16 0F 84 B2 00 00 00 8B 4D 08 8B 45 E8 89 45 EC 85 C9 75 18 85 C0 0F 84 84 00 00 00 53 50 E8 ?? ?? ?? ?? F7 D8 59 1B F6 59 46 EB 71 C7 45 F0 ?? ?? ?? ?? 89 4D F4 89 5D F8 57 85 C0 74 45 E8 ?? ?? ?? ?? 8B 38 E8 ?? ?? ?? ?? 53 89 18 8D 45 EC 50 FF 75 EC 53 E8 ?? ?? ?? ?? 83 C4 10 8B F0 E8 ?? ?? ?? ?? 83 FE FF 74 04 89 38 EB 2F 83 38 02 74 0A E8 ?? ?? ?? ?? 83 38 0D 75 20 E8 ?? ?? ?? ?? 89 38 53 8D 45 EC B9 ?? ?? ?? ?? 50 51 53 89 4D EC E8 ?? ?? ?? ?? 83 C4 10 8B F0 5F 8B 45 E8 50 E8 ?? ?? ?? ?? 59 8B 4D FC 8B C6 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_759_1_0 {
	meta:
		name = "__wsystem"
		size = 245
		refs = "0007 ___security_cookie 0018 ??_C@_1BA@HMCCKBDK@?$AAC?$AAO?$AAM?$AAS?$AAP?$AAE?$AAC?$AA?$AA@ 0024 __wdupenv_s 0050 __waccess_s 0060 ??_C@_15JBFELBFC@?$AA?1?$AAc?$AA?$AA@ 0070 __errno 0087 __wspawnve 00b9 ??_C@_1BA@DBKIDAPL@?$AAc?$AAm?$AAd?$AA?4?$AAe?$AAx?$AAe?$AA?$AA@ 00c4 __wspawnvpe 00d3 _free 00e2 @__security_check_cookie@4 00f0 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 EC 18 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 33 DB 8D 45 E8 68 ?? ?? ?? ?? 53 50 89 5D E8 8B F3 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 09 83 F8 16 0F 84 B2 00 00 00 8B 4D 08 8B 45 E8 89 45 EC 85 C9 75 18 85 C0 0F 84 84 00 00 00 53 50 E8 ?? ?? ?? ?? F7 D8 59 1B F6 59 46 EB 71 C7 45 F0 ?? ?? ?? ?? 89 4D F4 89 5D F8 57 85 C0 74 45 E8 ?? ?? ?? ?? 8B 38 E8 ?? ?? ?? ?? 53 89 18 8D 45 EC 50 FF 75 EC 53 E8 ?? ?? ?? ?? 83 C4 10 8B F0 E8 ?? ?? ?? ?? 83 FE FF 74 04 89 38 EB 2F 83 38 02 74 0A E8 ?? ?? ?? ?? 83 38 0D 75 20 E8 ?? ?? ?? ?? 89 38 53 8D 45 EC B9 ?? ?? ?? ?? 50 51 53 89 4D EC E8 ?? ?? ?? ?? 83 C4 10 8B F0 5F 8B 45 E8 50 E8 ?? ?? ?? ?? 59 8B 4D FC 8B C6 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "__freea"
		size = 30
		refs = "0017 _free"
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 74 12 83 E8 08 81 38 DD DD 00 00 75 07 50 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "_fetestexcept"
		size = 29
		refs = "0010 _fegetexceptflag"
	strings:
		$1 = { 55 8B EC 51 FF 75 08 83 65 FC 00 8D 45 FC 50 E8 ?? ?? ?? ?? 8B 45 FC 59 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "_bx8"
		size = 28
	strings:
		$1 = { 55 8B EC 8B 45 10 0F B6 08 8B 45 0C 03 88 A4 00 00 00 8B 45 08 89 08 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_27_1_0 {
	meta:
		name = "_bx32"
		size = 27
	strings:
		$1 = { 55 8B EC 8B 45 0C 6A 04 8B 88 A4 00 00 00 8B 45 10 03 08 8B 45 08 89 08 58 5D C3 }
	condition:
		$1
}

rule file_27_2_0 {
	meta:
		name = "_sib0"
		size = 332
		refs = "0031 $LN32 00ae $LN33 010c $LN23 0110 $LN22 0114 $LN21 0118 $LN20 011c $LN19 0120 $LN18 0124 $LN17 0128 $LN16 012c $LN9 0130 $LN8 0134 $LN7 0138 $LN6 013c $LN5 0140 $LN4 0144 $LN3 0148 $LN2"
	strings:
		$1 = { 55 8B EC 8B 45 0C 53 8B 5D 10 56 57 33 FF 0F B6 33 47 8B CE C1 E9 06 D3 E7 8B CE C1 E9 03 83 E1 07 83 F9 04 74 4F 83 E1 07 83 F9 07 77 47 FF 24 8D ?? ?? ?? ?? 8B 90 B0 00 00 00 EB 3A 8B 90 AC 00 00 00 EB 32 8B 90 A8 00 00 00 EB 2A 8B 90 A4 00 00 00 EB 22 8B 90 C4 00 00 00 EB 1A 8B 90 B4 00 00 00 EB 12 8B 90 A0 00 00 00 EB 0A 8B 90 9C 00 00 00 EB 02 33 D2 83 E6 07 83 FE 05 75 0F 8B 45 08 0F AF D7 56 03 53 01 89 10 58 EB 77 83 FE 04 75 10 0F AF D7 03 90 C4 00 00 00 8B 45 08 89 10 EB 5F 83 E6 07 83 FE 07 77 4C FF 24 B5 ?? ?? ?? ?? 8B 80 B0 00 00 00 8B 4D 08 89 01 EB 3E 8B 80 AC 00 00 00 EB F1 8B 80 A8 00 00 00 EB E9 8B 80 A4 00 00 00 EB E1 8B 80 C4 00 00 00 EB D9 8B 80 B4 00 00 00 EB D1 8B 80 A0 00 00 00 EB C9 8B 80 9C 00 00 00 EB C1 8B 4D 08 83 21 00 0F AF D7 01 11 33 C0 40 5F 5E 5B 5D C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_3_0 {
	meta:
		name = "_sib8"
		size = 320
		refs = "0031 $LN31 009d $LN32 0100 $LN22 0104 $LN21 0108 $LN20 010c $LN19 0110 $LN18 0114 $LN17 0118 $LN16 011c $LN15 0120 $LN9 0124 $LN8 0128 $LN7 012c $LN6 0130 $LN5 0134 $LN4 0138 $LN3 013c $LN2"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 10 33 F6 6A 07 46 5B 0F B6 07 8B D0 8B C8 C1 E9 06 C1 EA 03 D3 E6 23 D3 8B 4D 0C 83 FA 04 74 4D 23 D3 3B D3 77 47 FF 24 95 ?? ?? ?? ?? 8B 91 B0 00 00 00 EB 3A 8B 91 AC 00 00 00 EB 32 8B 91 A8 00 00 00 EB 2A 8B 91 A4 00 00 00 EB 22 8B 91 C4 00 00 00 EB 1A 8B 91 B4 00 00 00 EB 12 8B 91 A0 00 00 00 EB 0A 8B 91 9C 00 00 00 EB 02 33 D2 23 C3 83 F8 04 75 16 0F B6 47 01 0F AF D6 03 D0 8B 45 08 03 91 C4 00 00 00 89 10 EB 63 23 C3 3B C3 77 4C FF 24 85 ?? ?? ?? ?? 8B 81 B0 00 00 00 8B 4D 08 89 01 EB 3E 8B 81 AC 00 00 00 EB F1 8B 81 A8 00 00 00 EB E9 8B 81 A4 00 00 00 EB E1 8B 81 C4 00 00 00 EB D9 8B 81 B4 00 00 00 EB D1 8B 81 A0 00 00 00 EB C9 8B 81 9C 00 00 00 EB C1 8B 4D 08 83 21 00 0F B6 47 01 0F AF D6 03 D0 01 11 6A 02 58 5F 5E 5B 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_4_0 {
	meta:
		name = "_sib32"
		size = 316
		refs = "0031 $LN31 009d $LN32 00fc $LN22 0100 $LN21 0104 $LN20 0108 $LN19 010c $LN18 0110 $LN17 0114 $LN16 0118 $LN15 011c $LN9 0120 $LN8 0124 $LN7 0128 $LN6 012c $LN5 0130 $LN4 0134 $LN3 0138 $LN2"
	strings:
		$1 = { 55 8B EC 8B 45 0C 53 8B 5D 10 56 57 33 FF 0F B6 33 47 8B CE C1 E9 06 D3 E7 8B CE C1 E9 03 83 E1 07 83 F9 04 74 4F 83 E1 07 83 F9 07 77 47 FF 24 8D ?? ?? ?? ?? 8B 90 B0 00 00 00 EB 3A 8B 90 AC 00 00 00 EB 32 8B 90 A8 00 00 00 EB 2A 8B 90 A4 00 00 00 EB 22 8B 90 C4 00 00 00 EB 1A 8B 90 B4 00 00 00 EB 12 8B 90 A0 00 00 00 EB 0A 8B 90 9C 00 00 00 EB 02 33 D2 83 E6 07 83 FE 04 75 13 0F AF D7 03 90 C4 00 00 00 8B 45 08 03 53 01 89 10 EB 62 83 E6 07 83 FE 07 77 4C FF 24 B5 ?? ?? ?? ?? 8B 80 B0 00 00 00 8B 4D 08 89 01 EB 3E 8B 80 AC 00 00 00 EB F1 8B 80 A8 00 00 00 EB E9 8B 80 A4 00 00 00 EB E1 8B 80 C4 00 00 00 EB D9 8B 80 B4 00 00 00 EB D1 8B 80 A0 00 00 00 EB C9 8B 80 9C 00 00 00 EB C1 8B 4D 08 83 21 00 0F AF D7 03 53 01 01 11 6A 05 58 5F 5E 5B 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_5_0 {
	meta:
		name = "_d32"
		size = 18
	strings:
		$1 = { 55 8B EC 8B 45 10 6A 04 8B 08 8B 45 08 89 08 58 5D C3 }
	condition:
		$1
}

rule file_27_6_0 {
	meta:
		name = "_bp8"
		size = 28
	strings:
		$1 = { 55 8B EC 8B 45 10 0F B6 08 8B 45 0C 03 88 B4 00 00 00 8B 45 08 89 08 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_27_7_0 {
	meta:
		name = "_bp32"
		size = 27
	strings:
		$1 = { 55 8B EC 8B 45 0C 6A 04 8B 88 B4 00 00 00 8B 45 10 03 08 8B 45 08 89 08 58 5D C3 }
	condition:
		$1
}

rule file_27_8_0 {
	meta:
		name = "_si0"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 A0 00 00 00 8B 45 08 89 08 33 C0 5D C3 }
	condition:
		$1
}

rule file_27_9_0 {
	meta:
		name = "_si8"
		size = 28
	strings:
		$1 = { 55 8B EC 8B 45 10 0F B6 08 8B 45 0C 03 88 A0 00 00 00 8B 45 08 89 08 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_27_10_0 {
	meta:
		name = "_si32"
		size = 27
	strings:
		$1 = { 55 8B EC 8B 45 0C 6A 04 8B 88 A0 00 00 00 8B 45 10 03 08 8B 45 08 89 08 58 5D C3 }
	condition:
		$1
}

rule file_27_11_0 {
	meta:
		name = "_di0"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 9C 00 00 00 8B 45 08 89 08 33 C0 5D C3 }
	condition:
		$1
}

rule file_27_12_0 {
	meta:
		name = "_di8"
		size = 28
	strings:
		$1 = { 55 8B EC 8B 45 10 0F B6 08 8B 45 0C 03 88 9C 00 00 00 8B 45 08 89 08 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_27_13_0 {
	meta:
		name = "_di32"
		size = 27
	strings:
		$1 = { 55 8B EC 8B 45 0C 6A 04 8B 88 9C 00 00 00 8B 45 10 03 08 8B 45 08 89 08 58 5D C3 }
	condition:
		$1
}

rule file_27_15_0 {
	meta:
		name = "_ax0"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 B0 00 00 00 8B 45 08 89 08 33 C0 5D C3 }
	condition:
		$1
}

rule file_27_16_0 {
	meta:
		name = "_ax8"
		size = 28
	strings:
		$1 = { 55 8B EC 8B 45 10 0F B6 08 8B 45 0C 03 88 B0 00 00 00 8B 45 08 89 08 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_27_17_0 {
	meta:
		name = "_ax32"
		size = 27
	strings:
		$1 = { 55 8B EC 8B 45 0C 6A 04 8B 88 B0 00 00 00 8B 45 10 03 08 8B 45 08 89 08 58 5D C3 }
	condition:
		$1
}

rule file_27_18_0 {
	meta:
		name = "_cx0"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 AC 00 00 00 8B 45 08 89 08 33 C0 5D C3 }
	condition:
		$1
}

rule file_27_19_0 {
	meta:
		name = "_cx8"
		size = 28
	strings:
		$1 = { 55 8B EC 8B 45 10 0F B6 08 8B 45 0C 03 88 AC 00 00 00 8B 45 08 89 08 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_27_20_0 {
	meta:
		name = "_cx32"
		size = 27
	strings:
		$1 = { 55 8B EC 8B 45 0C 6A 04 8B 88 AC 00 00 00 8B 45 10 03 08 8B 45 08 89 08 58 5D C3 }
	condition:
		$1
}

rule file_27_21_0 {
	meta:
		name = "_dx0"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 A8 00 00 00 8B 45 08 89 08 33 C0 5D C3 }
	condition:
		$1
}

rule file_27_22_0 {
	meta:
		name = "_dx8"
		size = 28
	strings:
		$1 = { 55 8B EC 8B 45 10 0F B6 08 8B 45 0C 03 88 A8 00 00 00 8B 45 08 89 08 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_27_23_0 {
	meta:
		name = "_dx32"
		size = 27
	strings:
		$1 = { 55 8B EC 8B 45 0C 6A 04 8B 88 A8 00 00 00 8B 45 10 03 08 8B 45 08 89 08 58 5D C3 }
	condition:
		$1
}

rule file_27_24_0 {
	meta:
		name = "_bx0"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 A4 00 00 00 8B 45 08 89 08 33 C0 5D C3 }
	condition:
		$1
}

rule file_27_25_0 {
	meta:
		name = "_AdjustExceptionResult"
		size = 436
		refs = "00ba $LN61 00c1 $LN71 00df $LN62 00e6 $LN72 00f4 $LN63 00fb $LN73 011c $LN64 0123 $LN74 0174 $LN39 0178 $LN40 0194 $LN16 0198 $LN17"
	strings:
		$1 = { 55 8B EC 8B 55 0C 8B 4A 20 8B 41 60 A8 01 0F 84 5D 01 00 00 83 E0 1E 3C 0E 0F 85 52 01 00 00 8B 45 08 53 56 57 83 F8 58 0F 87 F9 00 00 00 6A 07 83 CF FF 33 F6 5B 83 F8 57 73 3A 83 F8 39 0F 82 2A 01 00 00 83 F8 3A 76 08 83 F8 3C E9 D9 00 00 00 8B 41 50 2B C6 74 7D 48 74 6A 48 74 52 48 75 14 83 7A 18 02 76 0B 83 7A 18 06 76 63 39 5A 18 75 03 89 71 50 8B 4A 20 8B 41 50 2B C6 0F 84 8F 00 00 00 48 74 79 48 74 61 48 0F 85 DE 00 00 00 83 7A 18 02 76 0F 83 7A 18 06 76 6E 39 5A 18 0F 85 C9 00 00 00 89 71 50 89 71 54 E9 BE 00 00 00 8B 42 18 3B C3 77 BE 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 7A 18 03 76 A7 39 5A 18 77 A5 89 79 50 EB A0 8B 42 18 3B C3 77 99 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 42 18 3B C3 77 7D 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 7A 18 03 76 A0 39 5A 18 77 64 89 79 50 89 79 54 EB 5C 8B 42 18 3B C3 77 55 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 F8 5A 77 42 8B 41 50 83 E8 00 74 2C 48 74 20 48 74 10 48 75 31 8B 42 1C 25 6F F7 FF FF 83 C8 45 EB 21 8B 42 1C 25 2B F7 FF FF 83 C8 01 EB 14 81 62 1C 2A F7 FF FF EB 0E 8B 42 1C 25 6A F7 FF FF 83 C8 40 89 42 1C 5F 5E 5B 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 01 00 00 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 00 01 01 00 01 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 01 00 00 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 00 01 01 00 01 00 }
	condition:
		$1
}

rule file_27_26_0 {
	meta:
		name = "_DppxEmulationWrapper"
		size = 428
		refs = "0066 _LoopDppxSimdValue"
	strings:
		$1 = { 55 8B EC 51 51 8B 45 1C 53 56 57 8B 30 33 DB 8B 7D 0C 33 C0 C1 EE 1E 46 89 75 FC 83 7F 28 6D 0F 95 C0 40 89 45 0C 33 C0 89 45 1C 83 7F 28 48 74 16 83 7F 28 6D 75 1E 33 DB 85 C0 0F 94 C3 8D 1C 9D 49 00 00 00 EB 0E 33 DB 85 C0 0F 94 C3 8D 1C 9D 2B 00 00 00 53 50 56 FF 75 18 FF 75 14 FF 75 10 57 FF 75 08 E8 ?? ?? ?? ?? 8B 4D 08 83 C4 20 8B D1 89 45 F8 8B 45 1C 83 EA 00 74 35 4A 0F 85 BF 00 00 00 85 C0 0F 85 B7 00 00 00 8B 97 B0 00 00 00 8B B7 B4 00 00 00 8B 87 B8 00 00 00 8B 8F BC 00 00 00 89 57 50 89 77 54 89 47 58 89 4F 5C EB 32 8B D0 83 EA 00 74 45 4A 0F 85 83 00 00 00 8B B7 B8 00 00 00 8B 97 BC 00 00 00 8B 8F B0 00 00 00 8B 87 B4 00 00 00 89 77 50 89 57 54 89 4F 58 89 47 5C 89 87 80 00 00 00 89 8F 84 00 00 00 89 97 88 00 00 00 89 B7 8C 00 00 00 EB 3C 8B B7 B0 00 00 00 8B 8F B4 00 00 00 8B 97 B8 00 00 00 8B 87 BC 00 00 00 89 77 50 89 4F 54 89 57 58 89 47 5C 89 8F 80 00 00 00 89 B7 84 00 00 00 89 87 88 00 00 00 89 97 8C 00 00 00 8B 4D 08 8B 45 1C 8B 75 FC 40 89 45 1C 3B 45 0C 0F 86 DB FE FF FF 33 D2 2B CA 74 2A 49 75 49 8B CA 85 F6 74 43 81 C7 B0 00 00 00 8B 45 10 8B 40 18 D3 E8 A8 01 75 05 89 17 89 57 04 41 83 C7 08 3B CE 72 E7 EB 22 8B CA 85 F6 74 1C 81 C7 B0 00 00 00 8B 45 10 8B 40 18 D3 E8 A8 01 75 02 89 17 41 83 C7 04 3B CE 72 EA 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_27_0 {
	meta:
		name = "_LoadOperand"
		size = 522
	strings:
		$1 = { 55 8B EC 8B 55 14 8B 45 0C 89 02 83 F8 1F 75 06 83 62 20 FE 5D C3 83 F8 15 74 3E 83 F8 14 74 39 83 F8 17 74 34 83 F8 1B 74 2F 80 7D 08 00 74 40 6A 0D 59 83 F8 12 75 02 89 0A 83 F8 13 75 06 C7 02 19 00 00 00 83 F8 0E 75 02 89 0A 83 F8 0C 75 1F C7 02 0B 00 00 00 EB 17 80 7D 08 00 74 0B 83 F8 14 75 06 C7 02 08 00 00 00 8B 45 1C 89 42 04 53 56 8B 75 18 8D 5A 10 57 33 C0 8B FB 81 C6 CC 00 00 00 AB AB AB AB 8B 42 20 8B 0A 83 C8 01 89 42 20 83 F9 13 0F 87 DC 00 00 00 0F 84 CE 00 00 00 83 E9 08 74 54 83 E9 03 74 3C 49 74 31 49 74 29 49 74 11 83 E9 04 0F 85 48 01 00 00 83 E0 E1 E9 E9 00 00 00 83 E0 E1 89 42 20 8B 4E 10 8B 01 89 03 8B 41 04 E9 28 01 00 00 83 E0 E1 EB 0E 83 E0 EB 83 C8 0A EB E1 83 E0 EB 83 C8 0A 89 42 20 8B 46 10 8B 00 E9 AA 00 00 00 83 E0 EB 83 C8 0A 89 42 20 8B 45 10 83 E8 00 74 59 48 74 4B 48 74 3D 48 74 2F 48 48 74 20 48 74 12 48 0F 85 E3 00 00 00 8B 45 18 8B 80 9C 00 00 00 EB 77 8B 45 18 8B 80 A0 00 00 00 EB 6C 8B 45 18 8B 80 B4 00 00 00 EB 61 8B 45 18 8B 80 A4 00 00 00 EB 56 8B 45 18 8B 80 A8 00 00 00 EB 4B 8B 45 18 8B 80 AC 00 00 00 EB 40 8B 45 18 8B 80 B0 00 00 00 EB 35 83 E0 E3 83 C8 02 EB 37 83 E9 14 74 6C 49 74 48 6A 02 5F 2B CF 74 3A 2B CF 74 2C 49 74 1B 49 75 75 83 E0 EB 83 C8 0A 89 42 20 8B 45 10 83 C0 0A 03 C0 8B 04 C6 89 03 EB 5D 83 E0 EB 83 C8 0A 89 42 20 8B 76 10 EB 2A 83 E0 E3 0B C7 E9 08 FF FF FF 83 E0 E3 0B C7 EB 03 83 E0 E1 8B 75 10 89 42 20 8B 45 18 05 CC 00 00 00 8D 76 0A C1 E6 04 03 F0 8B FB A5 A5 A5 A5 EB 1D 8B 4D 10 83 E0 EB 83 C8 0A 83 C1 02 03 C9 89 42 20 8B 04 CE 89 03 8B 44 CE 04 89 43 04 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_27_28_0 {
	meta:
		name = "_LoopDppxSimdValue"
		size = 598
		refs = "0181 __XMMI_FP_Emulation 0189 __XMMI2_FP_Emulation"
	strings:
		$1 = { 55 8B EC 51 51 53 8B 5D 10 33 C9 56 83 C8 FF 89 4D FC 57 8B 7D 0C 89 45 F8 39 4D 1C 0F 86 2D 02 00 00 8B 75 14 8D 97 B0 00 00 00 8D 47 08 89 55 0C 89 45 10 83 7D 20 00 75 3A 8B 43 18 83 C1 04 D3 E8 A8 01 75 2E 8B 45 08 33 C9 2B C1 74 0A 48 75 10 89 0A 89 4A 04 EB 09 8B 45 10 89 88 A8 00 00 00 83 8F C0 00 00 00 01 8B 43 1C 89 47 30 E9 BE 01 00 00 83 63 04 00 83 66 04 E0 83 66 08 E0 83 66 0C E0 8B 43 10 33 06 8B 4D 24 83 E0 03 31 06 81 E1 FF 0F 00 00 8B 43 14 8B 16 83 E0 07 C1 E1 03 81 E2 03 00 FE FF 0B C8 8B 46 20 C1 E1 02 0B CA 8B 55 0C 89 0E 33 47 60 83 E0 01 31 46 20 8B 47 60 33 46 20 83 E0 1E 31 46 20 8B 45 08 83 E8 00 74 11 48 75 17 8B 42 A0 89 46 10 8B 42 A4 89 46 14 EB 09 8B 45 10 8B 40 48 89 46 10 8B 87 90 00 00 00 83 E0 01 74 1D 8B 4E 40 83 E1 FE 0B C8 89 4E 40 8B 87 90 00 00 00 33 C1 83 E0 1E 33 C1 89 46 40 EB 04 83 66 40 FE 8B 45 08 8B 4D 10 83 E8 00 74 11 48 75 14 8B 42 D0 89 46 30 8B 42 D4 89 46 34 EB 06 8B 41 78 89 46 30 8B 45 08 83 66 60 FE 83 E8 00 74 10 48 75 16 8B 02 89 46 50 8B 42 04 89 46 54 EB 09 8B 81 A8 00 00 00 89 46 50 8B 87 C0 00 00 00 33 46 60 83 E0 1E 31 46 60 83 7D 08 01 89 73 20 74 0E 83 7D 08 02 74 08 53 E8 ?? ?? ?? ?? EB 06 53 E8 ?? ?? ?? ?? 8B 55 10 59 89 02 83 3A 01 8B 43 04 89 42 10 75 4C F6 43 04 20 74 04 83 4F 04 20 F6 43 04 10 74 04 83 4F 04 10 F6 43 04 08 74 04 83 4F 04 08 F6 43 04 04 74 04 83 4F 04 04 F6 43 04 02 74 04 83 4F 04 02 F6 43 04 01 74 04 83 4F 04 01 56 FF 55 18 89 45 F8 59 83 F8 FF 75 68 8B 55 10 8B 8F C0 00 00 00 33 4E 60 83 E1 01 31 8F C0 00 00 00 F6 87 C0 00 00 00 01 8B 4B 1C 89 4F 30 74 24 8B 45 08 83 E8 00 74 13 8B 55 0C 48 75 19 8B 46 50 89 02 8B 46 54 89 42 04 EB 0C 8B 46 50 89 82 A8 00 00 00 8B 55 0C 8B 4D FC 83 C2 08 83 45 10 04 41 89 4D FC 89 55 0C 3B 4D 1C 0F 82 E8 FD FF FF 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_29_0 {
	meta:
		name = "_SetPniOperation"
		size = 112
	strings:
		$1 = { 55 8B EC 8B 45 08 83 E8 43 74 41 48 74 4A 48 74 52 83 E8 23 74 20 48 74 12 48 74 04 32 C0 5D C3 8B 45 0C C7 00 4B 00 00 00 EB 41 8B 45 0C C7 00 49 00 00 00 EB 36 8B 45 0C 33 C9 39 4D 10 0F 94 C1 8D 0C 4D 49 00 00 00 89 08 EB 20 83 7D 10 00 74 11 83 7D 10 02 74 0B 8B 45 0C C7 00 2B 00 00 00 EB 09 8B 45 0C C7 00 2D 00 00 00 B0 01 5D C3 }
	condition:
		$1
}

rule file_27_30_0 {
	meta:
		name = "_UpdateResult"
		size = 304
		refs = "0026 $LN24 002d $LN28 00fc $LN12 0100 $LN10 0104 $LN17 0108 $LN18 010c $LN19 0110 $LN13 0114 $LN14 0118 $LN20"
	strings:
		$1 = { 55 8B EC 8B 55 08 53 56 57 8B 7D 0C 8B 02 8B 4A 04 83 C0 F8 8D 9F 6C 01 00 00 83 F8 13 0F 87 D1 00 00 00 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B BF DC 00 00 00 8D 72 10 A5 A5 A5 A5 E9 B1 00 00 00 8B 8F DC 00 00 00 8B 42 10 89 01 8B 42 14 89 41 04 E9 9B 00 00 00 8B 8F DC 00 00 00 8B 42 10 89 01 E9 8B 00 00 00 03 C9 8D 3C CB EB C7 8B 42 10 03 C9 89 84 CF EC 00 00 00 8B 42 14 89 84 CF F0 00 00 00 EB 6C 83 E9 00 74 55 49 74 47 49 74 39 49 74 2B 49 49 74 1C 49 74 0E 49 75 4B 8B 42 10 89 87 9C 00 00 00 EB 40 8B 42 10 89 87 A0 00 00 00 EB 35 8B 42 10 89 87 B4 00 00 00 EB 2A 8B 42 10 89 87 A4 00 00 00 EB 1F 8B 42 10 89 87 A8 00 00 00 EB 14 8B 42 10 89 87 AC 00 00 00 EB 09 8B 42 10 89 87 B0 00 00 00 8B 45 10 89 87 C0 00 00 00 5F 5E 5B 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 07 02 03 02 03 07 07 07 04 04 05 06 07 06 07 03 04 06 }
	condition:
		$1
}

rule file_27_31_0 {
	meta:
		name = "__fpieee_flt_simd"
		size = 4653
		refs = "0018 __sehtable$__fpieee_flt_simd 001d __except_handler4 0032 ___security_cookie 03c6 _InstInfoTableEX 03d0 _InstInfoTableDX 03eb _InstInfoTableCX 03f2 _InstInfoTable7X 03f9 _InstInfoTable5X 0457 _InstInfoTable4X 045e _InstInfoTable0X 0465 _InstInfoTable2X 0560 _InstInfoTableX 069c ??_C@_0BJ@DIBIJBHA@GetEnabledXStateFeatures?$AA@ 06a1 ??_C@_0N@MDJJJHMB@kernel32?4dll?$AA@ 06a7 __imp__GetModuleHandleA@4 06b0 __imp__GetProcAddress@8 06bd ??_C@_0BG@IKLDMBLM@GetXStateFeaturesMask?$AA@ 06d2 ??_C@_0BE@KINNKFDA@LocateXStateFeature?$AA@ 07c1 _modrm32 0906 _LoadOperand 0b20 _SetPniOperation 0b80 $LN252 0b87 $LN307 0cc6 $LN253 0ccd $LN308 0de6 $LN254 0ded $LN309 0e36 __XMMI_FP_Emulation 0e60 __XMMI2_FP_Emulation 0f0d _AdjustExceptionResult 0feb _DppxEmulationWrapper 100d _UpdateResult 11dc @__security_check_cookie@4 11e8 $LN67 11ec $LN65 11f0 $LN66 1200 $LN44 1204 $LN42 1208 $LN43 1218 $LN34 121c $LN32 1220 $LN38"
	strings:
		$1 = { 53 8B DC 51 51 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 51 53 81 EC A8 02 00 00 A1 ?? ?? ?? ?? 31 45 F8 33 C5 89 45 DC 56 57 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 8B 53 0C 8B 7B 10 89 BD 94 FD FF FF 83 A5 A4 FD FF FF 00 83 C8 FF 89 85 A0 FD FF FF 32 C9 88 8D FB FD FF FF 88 8D 0D FE FF FF 32 C0 89 85 E8 FD FF FF 88 85 F9 FD FF FF 33 C0 8B C8 89 8D 88 FD FF FF 89 85 E4 FD FF FF 8B F0 89 B5 FC FD FF FF 89 85 B4 FD FF FF 89 85 A8 FD FF FF 89 85 EC FD FF FF 89 85 B8 FD FF FF 8B 02 39 48 14 74 0B FF 70 14 FF D7 59 E9 02 11 00 00 8B 72 04 89 B5 E0 FD FF FF 8B 06 BA 20 00 01 00 23 C2 3B C2 0F 85 E6 10 00 00 33 C0 89 85 00 FE FF FF 8B F8 88 85 0F FE FF FF 89 45 FC B2 01 88 95 FA FD FF FF 88 85 09 FE FF FF 88 85 08 FE FF FF 88 85 07 FE FF FF 8B B6 B8 00 00 00 89 B5 F0 FD FF FF 89 B5 F4 FD FF FF 84 D2 0F 84 CB 01 00 00 8A 06 88 85 FB FD FF FF 46 89 B5 F0 FD FF FF 89 B5 F4 FD FF FF 0F B6 C0 83 F8 67 7F 49 74 37 83 F8 26 74 32 83 F8 2E 74 2D 83 F8 36 74 28 83 F8 3E 74 23 83 F8 63 0F 8E 82 01 00 00 83 F8 65 7E 15 83 F8 66 0F 85 74 01 00 00 C7 85 00 FE FF FF 01 00 00 00 EB 35 B0 01 88 85 0F FE FF FF 88 85 0E FE FF FF EB 92 2D C4 00 00 00 0F 84 A4 00 00 00 48 74 2B 83 E8 2B 74 DD 48 48 74 19 48 0F 85 3A 01 00 00 C6 85 09 FE FF FF 01 FF 85 FC FD FF FF E9 62 FF FF FF C6 85 09 FE FF FF 01 EB AB 33 D2 42 88 95 07 FE FF FF 8A 0E 46 89 B5 F0 FD FF FF 89 B5 F4 FD FF FF 8A C1 24 03 3A C2 75 06 89 95 00 FE FF FF 3C 02 75 06 88 95 09 FE FF FF 3C 03 75 0C 88 95 09 FE FF FF 89 95 00 FE FF FF 0F B6 C9 8B C1 C1 E8 02 23 C2 89 85 E8 FD FF FF 88 85 F9 FD FF FF F7 D1 C1 F9 03 83 E1 0F 89 8D 88 FD FF FF C6 85 0D FE FF FF 0F FF 85 FC FD FF FF E9 A9 00 00 00 C6 85 08 FE FF FF 01 8A 16 46 89 B5 F4 FD FF FF 8A 0E 46 89 B5 F0 FD FF FF 89 B5 F4 FD FF FF 8A C1 24 03 3C 01 75 0A C7 85 00 FE FF FF 01 00 00 00 3C 02 75 07 C6 85 09 FE FF FF 01 3C 03 75 11 C6 85 09 FE FF FF 01 C7 85 00 FE FF FF 01 00 00 00 0F B6 C9 8B C1 C1 E8 02 83 E0 01 89 85 E8 FD FF FF 88 85 F9 FD FF FF F7 D1 C1 F9 03 83 E1 0F 89 8D 88 FD FF FF 0F B6 C2 83 E0 0F 48 74 1C 48 74 10 48 0F 85 FA 0E 00 00 C6 85 0D FE FF FF 3A EB 10 C6 85 0D FE FF FF 38 EB 07 C6 85 0D FE FF FF 0F 83 85 FC FD FF FF 02 32 D2 88 95 FA FD FF FF E9 2D FE FF FF C7 45 FC FE FF FF FF 80 BD 0F FE FF FF 00 0F 85 C0 0E 00 00 C7 45 FC 01 00 00 00 89 B5 9C FD FF FF 8B 06 89 85 B0 FD FF FF 8B D0 83 E2 0F 89 95 84 FD FF FF C1 E8 04 83 E0 0F 89 85 8C FD FF FF 80 BD 07 FE FF FF 00 75 3D 80 BD 08 FE FF FF 00 75 34 8B 8D B0 FD FF FF C1 E9 0B 83 E1 07 89 8D B0 FD FF FF 89 8D 90 FD FF FF 80 BD FB FD FF FF 0F 74 41 B0 01 88 85 0F FE FF FF 88 85 0E FE FF FF E9 8D 04 00 00 80 BD 0D FE FF FF 0F 74 19 6A 03 58 89 85 8C FD FF FF 0F B6 95 0D FE FF FF 83 E2 0F 89 95 84 FD FF FF 89 8D B0 FD FF FF 89 8D 90 FD FF FF 48 48 0F 84 B5 00 00 00 48 74 4D 48 48 74 42 48 48 74 37 83 E8 05 74 2B 48 74 0D 48 75 A1 B9 ?? ?? ?? ?? E9 9A 00 00 00 B9 ?? ?? ?? ?? 80 BD 09 FE FF FF 00 0F 84 88 00 00 00 83 A5 00 FE FF FF 00 EB 7F B9 ?? ?? ?? ?? EB 78 B9 ?? ?? ?? ?? EB DC B9 ?? ?? ?? ?? EB 6A 83 FA 0A 0F 85 5E FF FF FF 33 FF 47 8A 85 08 FE FF FF 0A 85 07 FE FF FF 75 13 46 89 B5 F0 FD FF FF 89 B5 F4 FD FF FF FF 85 FC FD FF FF 89 B5 9C FD FF FF 8B 06 8B D0 83 E2 0F 89 95 84 FD FF FF C1 E8 04 83 E0 0F 89 85 8C FD FF FF 74 10 83 F8 04 0F 85 10 FF FF FF B9 ?? ?? ?? ?? EB 0C B9 ?? ?? ?? ?? EB 05 B9 ?? ?? ?? ?? 8B 06 25 00 C0 00 00 3D 00 C0 00 00 0F 95 C0 88 85 DF FD FF FF 0F B6 C0 C1 E0 04 0B C2 83 F8 20 0F 87 D7 FE FF FF 83 FF 01 0F 85 81 00 00 00 8D 0C 81 89 8D E4 FD FF FF 89 8D 98 FD FF FF 8B 01 BA FF 0F 00 00 23 C2 83 F8 6B 74 26 83 F8 6C 74 21 83 F8 6D 74 1C 83 F8 46 74 0E 83 F8 47 74 09 83 F8 48 0F 85 94 FE FF FF 83 A5 00 FE FF FF 00 EB 0A C7 85 00 FE FF FF 01 00 00 00 83 F8 6B 74 26 83 F8 46 74 21 83 F8 6D 74 1C 83 F8 48 74 17 83 F8 6C 74 09 83 F8 47 0F 85 5F FE FF FF C6 85 09 FE FF FF 01 EB 26 C6 85 09 FE FF FF 00 EB 1D 8B 95 00 FE FF FF 8D 04 42 8D 0C 81 89 8D E4 FD FF FF 89 8D 98 FD FF FF BA FF 0F 00 00 8B 09 85 CA 0F 84 26 FE FF FF 8B C1 25 00 F0 01 00 3D 00 E0 01 00 75 4B C1 E9 11 83 E1 1F 80 BD 09 FE FF FF 00 74 15 8D 0C 8D ?? ?? ?? ?? 89 8D E4 FD FF FF 89 8D 98 FD FF FF EB 13 8D 04 8D ?? ?? ?? ?? 89 85 E4 FD FF FF 89 85 98 FD FF FF 32 C0 88 85 09 FE FF FF C7 85 00 FE FF FF 02 00 00 00 EB 06 8A 85 09 FE FF FF 8B 8D E4 FD FF FF 8B 09 23 CA 83 F9 43 74 0A 83 F9 44 74 05 83 F9 45 75 08 32 C0 88 85 09 FE FF FF 83 F9 68 74 0A 83 F9 69 74 05 83 F9 6A 75 0A C7 85 00 FE FF FF 01 00 00 00 85 FF 75 0D 0F B6 C0 03 C1 89 85 38 FE FF FF EB 06 89 8D 38 FE FF FF 80 BD 07 FE FF FF 00 75 09 80 BD 08 FE FF FF 00 74 57 83 F9 51 77 20 74 3C 83 F9 33 74 37 83 F9 3A 76 46 83 F9 3C 76 2D 83 F9 40 74 28 83 F9 42 74 23 83 F9 46 EB 1C 83 F9 59 72 2D 83 F9 5F 76 14 83 F9 61 74 0F 83 F9 62 76 1E 83 F9 67 76 05 83 F9 6B 75 14 8B 06 C1 E8 0B 83 E0 07 89 85 B0 FD FF FF 89 85 90 FD FF FF 8B BD FC FD FF FF 83 C7 03 89 BD FC FD FF FF 33 C9 89 8D EC FD FF FF 89 8D 54 FD FF FF 8B 85 E8 FD FF FF 8B 8D E0 FD FF FF 84 C0 0F 84 E2 00 00 00 8B 01 BA 40 00 01 00 23 C2 3B C2 0F 85 D1 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? FF D7 50 8B 35 ?? ?? ?? ?? FF D6 89 85 C0 FD FF FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF D7 50 FF D6 89 85 BC FD FF FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF D7 50 FF D6 8B F0 85 F6 0F 84 D6 0A 00 00 FF 95 C0 FD FF FF 89 85 48 FD FF FF 89 95 4C FD FF FF 83 E0 04 83 C8 00 0F 84 B8 0A 00 00 8D 85 48 FD FF FF 50 8B BD E0 FD FF FF 57 FF 95 BC FD FF FF 85 C0 0F 84 9C 0A 00 00 8D 85 44 FD FF FF 50 6A 01 57 FF D6 89 85 B8 FD FF FF 89 85 58 FD FF FF 6A 00 6A 02 57 FF D6 89 85 EC FD FF FF 89 85 54 FD FF FF 6A 02 58 89 85 5C FD FF FF 8B B5 F0 FD FF FF 8B BD FC FD FF FF 8B 8D E0 FD FF FF EB 1B 8D 81 6C 01 00 00 89 85 B8 FD FF FF 89 85 58 FD FF FF 33 C0 40 89 85 5C FD FF FF 89 85 A8 FD FF FF 80 BD DF FD FF FF 00 74 36 89 B5 F4 FD FF FF 46 89 B5 F4 FD FF FF 8A 06 88 85 FB FD FF FF 46 89 B5 F4 FD FF FF 0F B6 C0 56 51 8D 8D A4 FD FF FF 51 FF 14 85 ?? ?? ?? ?? 83 C4 0C 8B C8 EB 06 8B 8D B4 FD FF FF 03 F9 89 BD FC FD FF FF 8B 85 E4 FD FF FF 8B 00 25 00 00 C0 01 3D 00 00 40 00 75 18 03 F1 89 B5 F4 FD FF FF 0F B6 06 89 85 3C FE FF FF 47 89 BD FC FD FF FF C7 45 FC FE FF FF FF 33 C9 89 8D B4 FD FF FF 8B 85 A8 FD FF FF 85 C0 0F 8E A7 08 00 00 6A 08 58 89 85 E8 FD FF FF 8B BD E0 FD FF FF 85 C9 0F 84 9A 00 00 00 8B 95 EC FD FF FF 89 95 F0 FD FF FF 8B BD B8 FD FF FF 8D 4F 08 2B D7 89 95 BC FD FF FF 8D B5 50 FF FF FF 2B F7 8D BD 50 FF FF FF 2B BD EC FD FF FF 89 85 C0 FD FF FF 8B 41 F8 8B 95 F0 FD FF FF 89 04 17 8B 41 FC 89 44 17 04 8B 01 89 04 0E 8B 41 04 89 44 0E 04 8B C2 8B 00 89 41 F8 8B C2 8B 40 04 89 41 FC 8B 95 BC FD FF FF 8B 04 0A 89 01 8B 44 0A 04 89 41 04 83 85 F0 FD FF FF 10 8D 49 10 FF 8D C0 FD FF FF 75 AE 8B 85 A4 FD FF FF 83 C0 10 8B BD E0 FD FF FF EB 06 8B 85 A4 FD FF FF 89 87 DC 00 00 00 8B B5 B0 FD FF FF 56 57 8D 85 50 FE FF FF 50 56 8B 85 E4 FD FF FF 8B 00 C1 E8 0C 83 E0 1F 50 FF B5 09 FE FF FF E8 ?? ?? ?? ?? 83 C4 18 8B 85 E4 FD FF FF 8B 08 8B C1 25 00 F0 01 00 C1 E9 11 83 E1 1F 3D 00 F0 01 00 8B 85 9C FD FF FF 8B 00 75 28 C1 E8 08 83 E0 07 50 57 8D 95 50 FE FF FF 52 50 51 FF B5 09 FE FF FF E8 ?? ?? ?? ?? 83 C4 18 83 A5 A0 FE FF FF FE EB 1F C1 E8 08 83 E0 07 50 57 8D 95 80 FE FF FF 52 50 51 FF B5 09 FE FF FF E8 ?? ?? ?? ?? 83 C4 18 8B 85 9C FD FF FF 8B 00 C1 E8 0B 83 E0 07 50 57 8D 85 B0 FE FF FF 50 56 8B B5 E4 FD FF FF 8B 06 C1 E8 19 83 E0 1F 50 FF B5 09 FE FF FF E8 ?? ?? ?? ?? 83 C4 18 80 BD 0F FE FF FF 00 0F 85 0D 08 00 00 0F B7 87 CC 00 00 00 B9 00 03 00 00 23 C1 74 20 3D 00 02 00 00 74 0D 3B C1 75 1F 83 A5 74 FD FF FF 00 EB 16 C7 85 74 FD FF FF 01 00 00 00 EB 0A C7 85 74 FD FF FF 02 00 00 00 8B 87 E4 00 00 00 8B C8 C1 E9 0D 83 E1 03 83 E9 00 74 2D 49 74 1E 49 74 0F 49 75 2B C7 85 70 FD FF FF 03 00 00 00 EB 1F C7 85 70 FD FF FF 02 00 00 00 EB 13 C7 85 70 FD FF FF 01 00 00 00 EB 07 83 A5 70 FD FF FF 00 8B C8 C1 E9 07 83 E1 3F 89 8D 60 FD FF FF 8B C8 C1 E9 0F 83 E1 01 89 8D 68 FD FF FF 8B C8 C1 E9 06 83 E1 01 89 8D 6C FD FF FF 8B 8F C0 00 00 00 89 8D 7C FD FF FF 8B 8D 3C FE FF FF 89 8D 78 FD FF FF 83 E0 3F 89 85 10 FE FF FF 83 A5 14 FE FF FF 00 8B 06 C1 E8 1E 40 89 85 BC FD FF FF 80 BD 09 FE FF FF 00 74 09 33 C0 40 89 85 BC FD FF FF 8B BD 38 FE FF FF 83 FF 48 0F 84 0E 05 00 00 83 FF 6D 0F 84 05 05 00 00 33 F6 85 C0 0F 84 2B 05 00 00 8B 8D 40 FF FF FF 89 8D C0 FD FF FF 83 A5 64 FD FF FF 00 6A E0 59 21 8D E4 FE FF FF 21 8D E8 FE FF FF 21 8D EC FE FF FF 8B 95 74 FD FF FF 83 E2 07 C1 E2 02 8B 85 E0 FE FF FF 23 C1 0B D0 8B 85 70 FD FF FF 83 E0 03 0B D0 56 8D 85 AC FD FF FF 50 57 E8 ?? ?? ?? ?? 83 C4 0C 84 C0 8B 85 AC FD FF FF 75 02 8B C7 C1 E0 05 33 C2 25 E0 FF 01 00 33 D0 89 95 E0 FE FF FF 8B 95 70 FE FF FF 83 E2 1F 8B 8D 00 FF FF FF 83 E1 E0 0B CA 89 8D 00 FF FF FF 8B 85 00 FE FF FF 83 E8 00 0F 84 B9 00 00 00 48 74 64 8D 47 A1 83 F8 08 0F 87 01 01 00 00 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 84 B5 60 FE FF FF 89 85 F0 FE FF FF 83 A5 F4 FE FF FF 00 E9 DA 00 00 00 8B 84 B5 60 FE FF FF 89 85 F0 FE FF FF E9 C8 00 00 00 8B 84 F5 60 FE FF FF 89 85 F0 FE FF FF 8B 84 F5 64 FE FF FF 89 85 F4 FE FF FF E9 A9 00 00 00 8B 84 F5 60 FE FF FF 89 85 F0 FE FF FF 8B 84 F5 64 FE FF FF 89 85 F4 FE FF FF 83 FF 69 74 09 83 FF 6A 0F 85 81 00 00 00 83 FE 01 75 7C 8B 85 90 FE FF FF 89 85 F0 FE FF FF 8B 85 94 FE FF FF 89 85 F4 FE FF FF 8B C1 33 85 A0 FE FF FF 83 E0 1F EB 4F 8B 84 B5 60 FE FF FF 89 85 F0 FE FF FF 83 FF 44 74 05 83 FF 45 75 40 8B C6 48 74 1C 48 74 11 48 75 35 8B 85 98 FE FF FF 89 85 F0 FE FF FF EB C3 8B 85 90 FE FF FF EB F0 8B 85 68 FE FF FF 89 85 F0 FE FF FF 8B C1 33 85 70 FE FF FF 83 E0 1E 33 C8 89 8D 00 FF FF FF 8B 8D 20 FF FF FF F6 85 A0 FE FF FF 01 74 0F 8B C1 33 85 A0 FE FF FF 83 E0 1F 33 C8 EB 03 83 E1 FE 89 8D 20 FF FF FF 8B 85 00 FE FF FF 83 E8 00 0F 84 AA 00 00 00 48 74 58 8D 47 A1 83 F8 08 0F 87 FF 00 00 00 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 84 B5 90 FE FF FF 83 A5 14 FF FF FF 00 E9 D8 00 00 00 8B 84 B5 90 FE FF FF E9 CC 00 00 00 8B 84 F5 90 FE FF FF 89 85 10 FF FF FF 8B 84 F5 94 FE FF FF 89 85 14 FF FF FF E9 B3 00 00 00 8B 84 F5 90 FE FF FF 89 85 10 FF FF FF 8B 84 F5 94 FE FF FF 89 85 14 FF FF FF 83 FF 69 74 09 83 FF 6A 0F 85 8B 00 00 00 85 F6 0F 85 83 00 00 00 8B 85 68 FE FF FF 89 85 10 FF FF FF 8B 85 6C FE FF FF 89 85 14 FF FF FF 83 E1 E0 0B CA EB 3D 8B 84 B5 90 FE FF FF 89 85 10 FF FF FF 83 FF 44 74 05 83 FF 45 75 4D 8B C6 83 E8 00 74 2F 48 74 24 48 75 40 8B 85 94 FE FF FF 89 85 10 FF FF FF 8B C1 33 85 A0 FE FF FF 83 E0 1F 33 C8 89 8D 20 FF FF FF EB 1F 8B 85 6C FE FF FF EB 06 8B 85 64 FE FF FF 83 E1 E0 0B CA 89 8D 20 FF FF FF 89 85 10 FF FF FF 8B 8D C0 FD FF FF 83 E1 FE 8B 95 00 FE FF FF 8B C2 83 E8 00 74 20 48 74 61 83 C7 A1 83 FF 08 77 22 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 A5 34 FF FF FF 00 8B 84 B5 C0 FE FF FF 89 85 30 FF FF FF 8B 85 D0 FE FF FF 33 C1 83 E0 1E 33 C8 89 8D 40 FF FF FF 8D 85 E0 FE FF FF 89 85 80 FD FF FF 83 FA 01 74 2F 83 FA 02 74 2A 8D 85 60 FD FF FF 50 E8 ?? ?? ?? ?? EB 28 8B 84 F5 C0 FE FF FF 89 85 30 FF FF FF 8B 84 F5 C4 FE FF FF 89 85 34 FF FF FF EB AD 8D 85 60 FD FF FF 50 E8 ?? ?? ?? ?? 89 84 B5 18 FE FF FF 59 8B 8D 64 FD FF FF 89 8C B5 28 FE FF FF 83 BC B5 18 FE FF FF 01 0F 85 8E 00 00 00 8B 85 14 FE FF FF F6 C1 20 74 09 83 C8 20 89 85 14 FE FF FF F6 C1 10 74 09 83 C8 10 89 85 14 FE FF FF F6 C1 08 74 09 83 C8 08 89 85 14 FE FF FF F6 C1 04 74 09 83 C8 04 89 85 14 FE FF FF F6 C1 02 74 09 83 C8 02 89 85 14 FE FF FF F6 C1 01 74 09 83 C8 01 89 85 14 FE FF FF 8D 85 E0 FE FF FF 50 FF 95 94 FD FF FF 59 89 85 A0 FD FF FF 83 F8 FF 0F 85 39 01 00 00 8D 85 60 FD FF FF 50 8B BD 38 FE FF FF 57 E8 ?? ?? ?? ?? 59 59 EB 06 8B BD 38 FE FF FF 8B 85 D0 FE FF FF 8B 8D 40 FF FF FF 89 8D C0 FD FF FF 33 C1 83 E0 01 8B 8D D0 FE FF FF 33 C8 89 8D D0 FE FF FF 8B 85 7C FD FF FF 89 85 40 FE FF FF F6 C1 01 74 68 8B 85 00 FE FF FF 83 E8 00 74 4A 48 74 14 83 FF 5F 72 55 83 FF 60 76 26 83 FF 65 76 38 83 FF 67 77 46 8B 85 30 FF FF FF 89 84 F5 C0 FE FF FF 8B 85 34 FF FF FF 89 84 F5 C4 FE FF FF EB 24 8B 85 30 FF FF FF 89 84 F5 C0 FE FF FF 83 A4 F5 C4 FE FF FF 00 EB 0D 8B 85 30 FF FF FF 89 84 B5 C0 FE FF FF 8B BD 38 FE FF FF 46 3B B5 BC FD FF FF 0F 82 13 FB FF FF EB 30 56 FF B5 94 FD FF FF 8D 85 E0 FE FF FF 50 8D 85 60 FD FF FF 50 8D 85 10 FE FF FF 50 FF B5 00 FE FF FF E8 ?? ?? ?? ?? 83 C4 18 89 85 A0 FD FF FF FF B5 40 FE FF FF 8B BD }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "_wcstok"
		size = 178
		refs = "0005 __getptd"
	strings:
		$1 = { 55 8B EC 51 E8 ?? ?? ?? ?? 8B 4D 08 89 45 FC 85 C9 75 03 8B 48 1C 0F B7 11 33 C0 53 56 57 8B 7D 0C 66 85 D2 74 30 0F B7 1F 8B C7 66 85 DB 74 12 8B F3 66 3B F2 74 0B 83 C0 02 0F B7 30 66 85 F6 75 F0 33 D2 66 39 10 74 0B 83 C1 02 0F B7 11 66 85 D2 75 D5 33 C0 8B F1 66 39 01 74 3E 0F B7 1F 33 D2 8B C7 66 85 DB 74 1B 0F B7 11 89 55 08 8B D3 66 3B 55 08 74 0B 83 C0 02 0F B7 10 66 85 D2 75 EF 33 D2 66 39 10 75 0A 83 C1 02 66 39 11 75 D1 EB 08 33 C0 66 89 01 83 C1 02 8B 45 FC 5F 89 48 1C 8B C6 2B C1 F7 D8 1B C0 23 C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "__wrmdir"
		size = 46
		refs = "0008 __imp__RemoveDirectoryW@4 0012 __imp__GetLastError@0 0020 __dosmaperr"
	strings:
		$1 = { 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_896_0_0 {
	meta:
		name = "__wremove"
		size = 46
		refs = "0008 __imp__DeleteFileW@4 0012 __imp__GetLastError@0 0020 __dosmaperr"
	strings:
		$1 = { 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_31_8_0 {
	meta:
		name = "??$swap@PAU_Node@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@@std@@YAXAAPAU_Node@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@0@Z"
		size = 21
		altNames = "??$_Swap_adl@PAU_Container_proxy@std@@@std@@YAXAAPAU_Container_proxy@0@0@Z ??$_Swap_adl@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@YAXAAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@0@Z ??$_Swap_adl@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@YAXAAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@0@Z ??$swap@PAU?$_Task_impl@E@details@Concurrency@@@std@@YAXAAPAU?$_Task_impl@E@details@Concurrency@@0@Z ??$swap@PAU?$_Task_impl@_N@details@Concurrency@@@std@@YAXAAPAU?$_Task_impl@_N@details@Concurrency@@0@Z ??$swap@PAU_Container_proxy@std@@@std@@YAXAAPAU_Container_proxy@0@0@Z ??$swap@PAU_ExceptionHolder@details@Concurrency@@@std@@YAXAAPAU_ExceptionHolder@details@Concurrency@@0@Z ??$swap@PAUscheduler_interface@Concurrency@@@std@@YAXAAPAUscheduler_interface@Concurrency@@0@Z ??$swap@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@YAXAAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@0@Z ??$swap@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@YAXAAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@0@Z ??$swap@PAV_Concurrent_queue_rep@details@Concurrency@@@std@@YAXAAPAV_Concurrent_queue_rep@details@Concurrency@@0@Z ??$swap@PAV_Ref_count_base@std@@@std@@YAXAAPAV_Ref_count_base@0@0@Z ??$swap@PAV__ExceptionPtr@@@std@@YAXAAPAV__ExceptionPtr@@0@Z"
	strings:
		$1 = { 55 8B EC 8B 55 08 8B 4D 0C 56 8B 32 8B 01 89 02 89 31 5E 5D C3 }
	condition:
		$1
}

rule file_31_12_0 {
	meta:
		name = "??0cancellation_token_source@Concurrency@@QAE@ABV01@@Z"
		size = 32
		altNames = "??0cancellation_token@Concurrency@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 8B 30 85 F6 74 0A 33 D2 8D 46 04 42 F0 0F C1 10 89 31 8B C1 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_31_13_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_435_25_0 {
	meta:
		name = "??0_Interruption_exception@details@Concurrency@@QAE@ABV012@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7_Interruption_exception@details@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_443_0_0 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0bad_typeid@std@@QAE@ABV01@@Z 0010 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_443_1_0 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@PBD@Z"
		size = 27
		refs = "000a ??0bad_typeid@std@@QAE@PBD@Z 0010 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1354_12_0 {
	meta:
		name = "??0bad_alloc@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_443_2_0 {
	meta:
		name = "??0bad_cast@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1353_1_0 {
	meta:
		name = "??0bad_exception@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_55_20_2 {
	meta:
		name = "??0bad_function_call@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_function_call@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_66_430_2 {
	meta:
		name = "??0bad_target@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_443_4_0 {
	meta:
		name = "??0bad_typeid@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_121_660_1 {
	meta:
		name = "??0bad_weak_ptr@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_weak_ptr@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_199_18_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_21_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_600_69_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_111_30_2 {
	meta:
		name = "??0failure@ios_base@std@@QAE@ABV012@@Z"
		size = 27
		refs = "000a ??0_System_error@std@@QAE@ABV01@@Z 0010 ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1042_31_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_600_70_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_600_71_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_600_72_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_176_13_0 {
	meta:
		name = "??0invalid_argument@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_434_1 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_435_44_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_121_673_1 {
	meta:
		name = "??0invalid_operation@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_24_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_714_15_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_714_16_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_714_17_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_39_36_1 {
	meta:
		name = "??0length_error@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7length_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_60_20_2 {
	meta:
		name = "??0lock_error@threads@stdext@@QAE@ABV012@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7lock_error@threads@stdext@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_123_647_2 {
	meta:
		name = "??0logic_error@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_438_1 {
	meta:
		name = "??0message_not_found@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_435_45_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_28_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_439_1 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_80_60_1 {
	meta:
		name = "??0out_of_range@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_55_33_2 {
	meta:
		name = "??0overflow_error@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_80_62_1 {
	meta:
		name = "??0range_error@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7range_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_20_87_1 {
	meta:
		name = "??0runtime_error@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_446_16_0 {
	meta:
		name = "??0scheduler_worker_creation_error@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0scheduler_resource_allocation_error@Concurrency@@QAE@ABV01@@Z 0010 ??_7scheduler_worker_creation_error@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_56_0 {
	meta:
		name = "??0scheduler_worker_creation_error@Concurrency@@QAE@J@Z"
		size = 27
		refs = "000a ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0010 ??_7scheduler_worker_creation_error@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_82_91_1 {
	meta:
		name = "??0system_error@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0_System_error@std@@QAE@ABV01@@Z 0010 ??_7system_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_60_24_2 {
	meta:
		name = "??0thread_resource_error@threads@stdext@@QAE@ABV012@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7thread_resource_error@threads@stdext@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1316_42_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_31_15_0 {
	meta:
		name = "??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000a _free"
	strings:
		$1 = { 56 8B 31 EB 0A 56 8B 76 04 E8 ?? ?? ?? ?? 59 85 F6 75 F2 5E C3 }
	condition:
		$1
}

rule file_31_27_0 {
	meta:
		name = "??_EGlobalCore@details@Concurrency@@QAEPAXI@Z"
		size = 78
		refs = "000e ??1GlobalCore@details@Concurrency@@QAE@XZ 001b ??_M@YGXPAXIHP6EX0@Z@Z 0027 ??_V@YAXPAX@Z 0035 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 02 56 8B F1 74 25 57 68 ?? ?? ?? ?? 8D 7E FC FF 37 6A 24 56 E8 ?? ?? ?? ?? F6 45 08 01 74 07 57 E8 ?? ?? ?? ?? 59 8B C7 5F EB 18 FF 76 20 E8 ?? ?? ?? ?? F6 45 08 01 59 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_31_28_0 {
	meta:
		name = "??_Gscheduler_not_attached@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1exception@std@@UAE@XZ 0013 ??3@YAXPAX@Z"
		altNames = "??_G_Interruption_exception@details@Concurrency@@UAEPAXI@Z ??_G_System_error@std@@UAEPAXI@Z ??_Gbad_function_call@std@@UAEPAXI@Z ??_Gbad_target@Concurrency@@UAEPAXI@Z ??_Gbad_weak_ptr@std@@UAEPAXI@Z ??_Gcontext_self_unblock@Concurrency@@UAEPAXI@Z ??_Gcontext_unblock_unbalanced@Concurrency@@UAEPAXI@Z ??_Gdefault_scheduler_exists@Concurrency@@UAEPAXI@Z ??_Gfailure@ios_base@std@@UAEPAXI@Z ??_Gfuture_error@std@@UAEPAXI@Z ??_Gimproper_lock@Concurrency@@UAEPAXI@Z ??_Gimproper_scheduler_attach@Concurrency@@UAEPAXI@Z ??_Gimproper_scheduler_detach@Concurrency@@UAEPAXI@Z ??_Gimproper_scheduler_reference@Concurrency@@UAEPAXI@Z ??_Ginvalid_argument@std@@UAEPAXI@Z ??_Ginvalid_link_target@Concurrency@@UAEPAXI@Z ??_Ginvalid_multiple_scheduling@Concurrency@@UAEPAXI@Z ??_Ginvalid_operation@Concurrency@@UAEPAXI@Z ??_Ginvalid_oversubscribe_operation@Concurrency@@UAEPAXI@Z ??_Ginvalid_scheduler_policy_key@Concurrency@@UAEPAXI@Z ??_Ginvalid_scheduler_policy_thread_specification@Concurrency@@UAEPAXI@Z ??_Ginvalid_scheduler_policy_value@Concurrency@@UAEPAXI@Z ??_Glength_error@std@@UAEPAXI@Z ??_Glock_error@threads@stdext@@UAEPAXI@Z ??_Glogic_error@std@@UAEPAXI@Z ??_Gmessage_not_found@Concurrency@@UAEPAXI@Z ??_Gmissing_wait@Concurrency@@UAEPAXI@Z ??_Gnested_scheduler_missing_detach@Concurrency@@UAEPAXI@Z ??_Goperation_timed_out@Concurrency@@UAEPAXI@Z ??_Gout_of_range@std@@UAEPAXI@Z ??_Goverflow_error@std@@UAEPAXI@Z ??_Grange_error@std@@UAEPAXI@Z ??_Gregex_error@std@@UAEPAXI@Z ??_Gruntime_error@std@@UAEPAXI@Z ??_Gscheduler_resource_allocation_error@Concurrency@@UAEPAXI@Z ??_Gscheduler_worker_creation_error@Concurrency@@UAEPAXI@Z ??_Gsystem_error@std@@UAEPAXI@Z ??_Gtask_canceled@Concurrency@@UAEPAXI@Z ??_Gthread_resource_error@threads@stdext@@UAEPAXI@Z ??_Gunsupported_os@Concurrency@@UAEPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_689_1 {
	meta:
		name = "??_G?$_AnonymousOriginator@I@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_AnonymousOriginator@I@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_690_1 {
	meta:
		name = "??_G?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_702_1 {
	meta:
		name = "??_G?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_703_1 {
	meta:
		name = "??_G?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_121_962_1 {
	meta:
		name = "??_G?$_RunAnyParam@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_RunAnyParam@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_704_1 {
	meta:
		name = "??_G?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_66_705_2 {
	meta:
		name = "??_G?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_66_706_2 {
	meta:
		name = "??_G?$_SyncOriginator@I@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_SyncOriginator@I@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_707_1 {
	meta:
		name = "??_G?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_121_963_1 {
	meta:
		name = "??_G?$_Task_impl@E@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_Task_impl@E@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_121_964_1 {
	meta:
		name = "??_G?$_Task_impl@_N@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_Task_impl@_N@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_50_115_2 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_114_2 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_32_114_2 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_50_118_2 {
	meta:
		name = "??_G?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_114_139_1 {
	meta:
		name = "??_G?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_46_117_2 {
	meta:
		name = "??_G?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_66_708_2 {
	meta:
		name = "??_G?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_119_173_2 {
	meta:
		name = "??_G?$collate@D@std@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$collate@D@std@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_442_1 {
	meta:
		name = "??_G?$collate@G@std@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$collate@G@std@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_382_2 {
	meta:
		name = "??_G?$collate@_W@std@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$collate@_W@std@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_709_1 {
	meta:
		name = "??_G?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_710_1 {
	meta:
		name = "??_G?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_12_119_2 {
	meta:
		name = "??_G?$ctype@G@std@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$ctype@G@std@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_102_141_1 {
	meta:
		name = "??_G?$ctype@_W@std@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$ctype@_W@std@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_715_1 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_66_716_2 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_66_717_2 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_66_718_2 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_66_719_2 {
	meta:
		name = "??_G?$ordered_message_processor@I@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$ordered_message_processor@I@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_66_720_2 {
	meta:
		name = "??_G?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_66_721_2 {
	meta:
		name = "??_G?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_722_1 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_723_1 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_724_1 {
	meta:
		name = "??_G?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_725_1 {
	meta:
		name = "??_G?$single_assignment@I@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$single_assignment@I@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_726_1 {
	meta:
		name = "??_G?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_66_727_2 {
	meta:
		name = "??_G?$single_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$single_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_728_1 {
	meta:
		name = "??_G?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_729_1 {
	meta:
		name = "??_G?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_730_1 {
	meta:
		name = "??_G?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_731_1 {
	meta:
		name = "??_G?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_90_215_1 {
	meta:
		name = "??_G?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_403_2 {
	meta:
		name = "??_G?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_465_1 {
	meta:
		name = "??_G?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_600_140_0 {
	meta:
		name = "??_GCacheLocalScheduleGroupSegment@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_190_69_0 {
	meta:
		name = "??_GContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1ContextBase@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_199_49_0 {
	meta:
		name = "??_GExternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1ExternalContextBase@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_600_142_0 {
	meta:
		name = "??_GFairScheduleGroupSegment@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_63_0 {
	meta:
		name = "??_GInternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1InternalContextBase@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1316_73_0 {
	meta:
		name = "??_GResourceManager@details@Concurrency@@AAEPAXI@Z"
		size = 31
		refs = "0007 ??1ResourceManager@details@Concurrency@@AAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_495_96_0 {
	meta:
		name = "??_GScheduleGroupSegmentBase@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_600_146_0 {
	meta:
		name = "??_GSchedulerBase@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1SchedulerBase@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_600_147_0 {
	meta:
		name = "??_GSchedulerPolicy@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1SchedulerPolicy@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1050_45_0 {
	meta:
		name = "??_GSchedulerProxy@details@Concurrency@@IAEPAXI@Z"
		size = 31
		refs = "0007 ??1SchedulerProxy@details@Concurrency@@IAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_600_148_0 {
	meta:
		name = "??_GSchedulingNode@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1SchedulingNode@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_600_149_0 {
	meta:
		name = "??_GSchedulingRing@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1SchedulingRing@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_576_45_0 {
	meta:
		name = "??_GSegment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_576_46_0 {
	meta:
		name = "??_GSegment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_435_82_0 {
	meta:
		name = "??_GTaskStack@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1TaskStack@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_446_33_0 {
	meta:
		name = "??_GThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1ThreadProxy@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_664_36_0 {
	meta:
		name = "??_GThreadScheduler@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1ThreadScheduler@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1016_34_0 {
	meta:
		name = "??_GTimerObj@?6??wait@Concurrency@@YAXI@Z@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1_Timer@details@Concurrency@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_656_41_0 {
	meta:
		name = "??_GTransmogrifiedPrimary@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1TransmogrifiedPrimary@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_69_63_0 {
	meta:
		name = "??_GUMSFreeThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1UMSFreeThreadProxy@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_69_64_0 {
	meta:
		name = "??_GUMSFreeThreadProxyFactory@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1UMSFreeThreadProxyFactory@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1324_55_0 {
	meta:
		name = "??_GUMSFreeVirtualProcessorRoot@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1UMSFreeVirtualProcessorRoot@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1320_40_0 {
	meta:
		name = "??_GUMSSchedulerProxy@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1UMSSchedulerProxy@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_316_33_0 {
	meta:
		name = "??_GUMSThreadInternalContext@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1UMSThreadInternalContext@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_499_36_0 {
	meta:
		name = "??_GUMSThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1UMSThreadProxy@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1367_35_0 {
	meta:
		name = "??_GUMSThreadScheduler@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1UMSThreadScheduler@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_911_34_0 {
	meta:
		name = "??_GUMSThreadVirtualProcessor@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1UMSThreadVirtualProcessor@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_974_48_0 {
	meta:
		name = "??_GVirtualProcessor@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1VirtualProcessor@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_802_33_0 {
	meta:
		name = "??_GWaiterThreadPool@platform@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1WaiterThreadPool@platform@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_66_732_2 {
	meta:
		name = "??_G_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_733_1 {
	meta:
		name = "??_G_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_45_59_1 {
	meta:
		name = "??_G_Concurrent_queue_base_v4@details@Concurrency@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1_Concurrent_queue_base_v4@details@Concurrency@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_89_2_1 {
	meta:
		name = "??_G_Condition_variable@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1_Condition_variable@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_121_970_1 {
	meta:
		name = "??_G_ExceptionHolder@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1_ExceptionHolder@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_19_60_1 {
	meta:
		name = "??_G_Fac_node@std@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1_Fac_node@std@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_7_52_2 {
	meta:
		name = "??_G_Locimp@locale@std@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1_Locimp@locale@std@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_190_72_0 {
	meta:
		name = "??_G_TaskCollection@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1_TaskCollection@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_123_930_2 {
	meta:
		name = "??_G_Task_impl_base@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1_Task_impl_base@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1016_35_0 {
	meta:
		name = "??_G_Timer@details@Concurrency@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1_Timer@details@Concurrency@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_544_64_0 {
	meta:
		name = "??_G__ExceptionPtr@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1__ExceptionPtr@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_734_1 {
	meta:
		name = "??_Gagent@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1agent@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_17_57_2 {
	meta:
		name = "??_Gcritical_section@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1critical_section@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_29_132_2 {
	meta:
		name = "??_Glocale@std@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1locale@std@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_704_5_0 {
	meta:
		name = "??_Gtype_info@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1type_info@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_31_29_0 {
	meta:
		name = "??_H@YGXPAXIHP6EPAX0@Z@Z"
		size = 31
	strings:
		$1 = { 55 8B EC 56 8B 75 10 4E 78 10 57 8B 7D 08 8B CF FF 55 14 03 7D 0C 4E 79 F5 5F 5E 5D C2 10 00 }
	condition:
		$1
}

rule file_31_30_0 {
	meta:
		name = "?Create@CurrentScheduler@Concurrency@@SAXABVSchedulerPolicy@2@@Z"
		size = 20
		refs = "0007 ?Create@SchedulerBase@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z"
	strings:
		$1 = { 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 8B C8 8B 10 5D FF 62 1C }
	condition:
		$1
}

rule file_31_31_0 {
	meta:
		name = "?CreateScheduleGroup@CurrentScheduler@Concurrency@@SAPAVScheduleGroup@2@AAVlocation@2@@Z"
		size = 20
		refs = "0004 ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? FF 75 08 8B C8 8B 10 FF 52 20 5D C3 }
	condition:
		$1
}

rule file_31_33_0 {
	meta:
		name = "?Detach@CurrentScheduler@Concurrency@@SAXXZ"
		size = 49
		refs = "0007 ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ 0012 ?Detach@SchedulerBase@details@Concurrency@@QAEXXZ 001e ??0scheduler_not_attached@Concurrency@@QAE@XZ 0023 __TI2?AVscheduler_not_attached@Concurrency@@ 002c __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 0C E8 ?? ?? ?? ?? 85 C0 74 0B 8B C8 E8 ?? ?? ?? ?? 8B E5 5D C3 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_31_35_0 {
	meta:
		name = "?GetNumberOfVirtualProcessors@CurrentScheduler@Concurrency@@SAIXZ"
		size = 20
		refs = "0001 ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 07 8B 10 8B C8 FF 62 08 83 C8 FF C3 }
	condition:
		$1
}

rule file_1240_35_0 {
	meta:
		name = "?ScheduleGroupId@Context@Concurrency@@SAIXZ"
		size = 20
		refs = "0001 ?SafeFastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 07 8B 10 8B C8 FF 62 08 83 C8 FF C3 }
	condition:
		$1
}

rule file_31_36_0 {
	meta:
		name = "?GetPolicy@CurrentScheduler@Concurrency@@SA?AVSchedulerPolicy@2@XZ"
		size = 30
		refs = "0009 ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 E8 ?? ?? ?? ?? FF 75 08 8B C8 8B 10 FF 52 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_31_37_0 {
	meta:
		name = "?Id@CurrentScheduler@Concurrency@@SAIXZ"
		size = 20
		refs = "0001 ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 07 8B 10 8B C8 FF 62 04 83 C8 FF C3 }
	condition:
		$1
}

rule file_1240_36_0 {
	meta:
		name = "?VirtualProcessorId@Context@Concurrency@@SAIXZ"
		size = 20
		refs = "0001 ?SafeFastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 07 8B 10 8B C8 FF 62 04 83 C8 FF C3 }
	condition:
		$1
}

rule file_31_38_0 {
	meta:
		name = "?IsAvailableLocation@CurrentScheduler@Concurrency@@SA_NABVlocation@2@@Z"
		size = 28
		refs = "0004 ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 85 C0 74 0C 8B 10 8B C8 FF 75 08 FF 52 30 5D C3 32 C0 5D C3 }
	condition:
		$1
}

rule file_31_39_0 {
	meta:
		name = "?RegisterShutdownEvent@CurrentScheduler@Concurrency@@SAXPAX@Z"
		size = 52
		refs = "0007 ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ 0021 ??0scheduler_not_attached@Concurrency@@QAE@XZ 0026 __TI2?AVscheduler_not_attached@Concurrency@@ 002f __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 0C E8 ?? ?? ?? ?? 85 C0 74 0E 8B 10 8B C8 FF 75 08 FF 52 18 8B E5 5D C3 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_31_40_0 {
	meta:
		name = "?ScheduleTask@CurrentScheduler@Concurrency@@SAXP6AXPAX@Z0@Z"
		size = 23
		refs = "0004 ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
		altNames = "?_ScheduleTask@_CurrentScheduler@details@Concurrency@@SAXP6AXPAX@Z0@Z"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? FF 75 0C 8B C8 FF 75 08 8B 10 FF 52 2C 5D C3 }
	condition:
		$1
}

rule file_31_41_0 {
	meta:
		name = "?ScheduleTask@CurrentScheduler@Concurrency@@SAXP6AXPAX@Z0AAVlocation@2@@Z"
		size = 26
		refs = "0004 ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? FF 75 10 8B C8 FF 75 0C 8B 10 FF 75 08 FF 52 28 5D C3 }
	condition:
		$1
}

rule file_31_42_0 {
	meta:
		name = "?_Assign@cancellation_token_source@Concurrency@@AAEXPAV_CancellationTokenState@details@2@@Z"
		size = 28
		altNames = "?_Assign@cancellation_token@Concurrency@@AAEXPAV_CancellationTokenState@details@2@@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 85 F6 74 0A 33 D2 8D 46 04 42 F0 0F C1 10 89 31 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_31_43_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 136
		refs = "0003 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0008 __EH_prolog3 0031 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 004b ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0058 ?_Invoke@_CancellationTokenRegistration@details@Concurrency@@AAEXXZ 006e ?set@event@Concurrency@@QAEXXZ 0079 _free 0083 __EH_epilog3"
	strings:
		$1 = { 6A 24 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D9 33 D2 8D 4B 08 42 33 C0 F0 0F B1 11 85 C0 75 64 33 FF 89 7D EC 89 7D F0 8D 43 34 89 7D FC 50 8D 4D D0 E8 ?? ?? ?? ?? 8B 73 54 8D 4D D0 89 7B 54 8B 43 58 89 75 EC 89 45 F0 89 7B 58 E8 ?? ?? ?? ?? 8B FE 85 F6 74 0E 8B 0F E8 ?? ?? ?? ?? 8B 7F 04 85 FF 75 F2 8D 4B 0C C7 43 08 02 00 00 00 E8 ?? ?? ?? ?? EB 0A 56 8B 76 04 E8 ?? ?? ?? ?? 59 85 F6 75 F2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_31_45_0 {
	meta:
		name = "__ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_205_1 {
	meta:
		name = "__ehhandler$??$_StoreException@V?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@@?$task_completion_event@E@Concurrency@@QBE_NV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@ABV_TaskCreationCallstack@details@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_StoreException@V?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@@?$task_completion_event@E@Concurrency@@QBE_NV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@ABV_TaskCreationCallstack@details@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_209_1 {
	meta:
		name = "__ehhandler$??$_StoreException@V?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@@?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@QBE_NV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@ABV_TaskCreationCallstack@details@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_StoreException@V?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@@?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@QBE_NV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@ABV_TaskCreationCallstack@details@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_909_98_0 {
	meta:
		name = "__ehhandler$?_StructuredChoreWrapper@_UnrealizedChore@details@Concurrency@@CAXPAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_StructuredChoreWrapper@_UnrealizedChore@details@Concurrency@@CAXPAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_46_0 {
	meta:
		name = "?_Get@_CurrentScheduler@details@Concurrency@@SA?AV_Scheduler@23@XZ"
		size = 17
		refs = "0004 ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 8B 4D 08 89 01 8B C1 5D C3 }
	condition:
		$1
}

rule file_1240_42_0 {
	meta:
		name = "?_CurrentContext@_Context@details@Concurrency@@SA?AV123@XZ"
		size = 17
		refs = "0004 ?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 8B 4D 08 89 01 8B C1 5D C3 }
	condition:
		$1
}

rule file_31_49_0 {
	meta:
		name = "?_Invoke@_CancellationTokenRegistration@details@Concurrency@@AAEXXZ"
		size = 66
		refs = "0006 ?GetCurrentThreadId@platform@details@Concurrency@@YAJXZ 0034 ?set@event@Concurrency@@QAEXXZ 003e ?_Release@_RefCounter@details@Concurrency@@QAEJXZ"
	strings:
		$1 = { 53 56 57 8B F1 E8 ?? ?? ?? ?? 8B F8 8D 5E 08 8B D7 33 C0 F0 0F B1 13 85 C0 75 1D 8B 06 8B CE FF 50 08 6A 03 59 8B C7 F0 0F B1 0B 83 F8 02 75 08 8B 4E 0C E8 ?? ?? ?? ?? 5F 8B CE 5E 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_51_0 {
	meta:
		name = "?_Release@_RefCounter@details@Concurrency@@QAEJXZ"
		size = 23
		altNames = "?_Release@_RefCounterBase@details@Concurrency@@QAEJXZ"
	strings:
		$1 = { 56 8D 51 04 83 CE FF F0 0F C1 32 4E 75 05 8B 11 FF 52 04 8B C6 5E C3 }
	condition:
		$1
}

rule file_31_53_0 {
	meta:
		name = "?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z"
		size = 18
		altNames = "??$_CompareAndSwap@I@?$_Subatomic_impl@$03@details@Concurrency@@SAIACIII@Z ??$_CompareAndSwap@PAU_Segment_t@_Concurrent_vector_base_v4@details@Concurrency@@@?$_Subatomic_impl@$03@details@Concurrency@@SAPAU_Segment_t@_Concurrent_vector_base_v4@12@ACRAU3412@PAU3412@1@Z"
	strings:
		$1 = { 55 8B EC 8B 55 0C 8B 4D 08 8B 45 10 F0 0F B1 11 5D C3 }
	condition:
		$1
}

rule file_31_55_0 {
	meta:
		name = "?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z"
		size = 36
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 8B F9 8B 16 8B 07 89 06 89 17 8B 4E 04 8B 47 04 89 46 04 89 4F 04 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_31_56_0 {
	meta:
		name = "_hypot"
		size = 29
		refs = "0014 __hypot"
		altNames = "_hypotl"
	strings:
		$1 = { 55 8B EC DD 45 10 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_469_0_0 {
	meta:
		name = "_atan2l"
		size = 29
		refs = "0014 _atan2"
	strings:
		$1 = { 55 8B EC DD 45 10 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_38_3_0 {
	meta:
		name = "_fmodl"
		size = 29
		refs = "0014 _fmod"
	strings:
		$1 = { 55 8B EC DD 45 10 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_633_0_0 {
	meta:
		name = "_nextafter"
		size = 29
		refs = "0014 _nexttoward"
	strings:
		$1 = { 55 8B EC DD 45 10 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1203_0_0 {
	meta:
		name = "_nextafterl"
		size = 29
		refs = "0014 _nexttowardl"
	strings:
		$1 = { 55 8B EC DD 45 10 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_310_4_0 {
	meta:
		name = "_powl"
		size = 29
		refs = "0014 _pow"
	strings:
		$1 = { 55 8B EC DD 45 10 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "__vmlsAtan24Spec"
		size = 2800
		refs = "0073 INFP_1898_0_2 0086 INFN_1898_0_2 00da _2il0floatpacket_46 010e _2il0floatpacket_50 0116 _2il0floatpacket_54 0120 _2il0floatpacket_49 012a _2il0floatpacket_53 0134 _2il0floatpacket_48 013e _2il0floatpacket_52 0148 _2il0floatpacket_47 0159 _2il0floatpacket_51 016c m_or_p_1898_0_2 0173 pi_or_zero_1898_0_2 0632 _2il0floatpacket_39 063f _2il0floatpacket_38 065d _2il0floatpacket_41 066b _2il0floatpacket_40 0678 _2il0floatpacket_45 0685 _2il0floatpacket_44 06a7 NEGZERO_1898_0_2 06c0 _2il0floatpacket_43 06cd _2il0floatpacket_42"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 1C 8B 45 0C 8B 55 08 8B 18 8B FB 8B 32 8B CE F3 0F 10 22 8B D3 81 E7 FF FF FF 7F 81 E1 00 00 00 80 81 E2 00 00 00 80 81 FF 00 00 80 7F F3 0F 10 18 0F 8F 43 01 00 00 8B FE 81 E7 FF FF FF 7F 81 FF 00 00 80 7F 0F 8F 2F 01 00 00 0F 57 C0 0F 2E E0 7A 06 0F 84 90 06 00 00 0F 2E D8 7A 06 0F 84 67 06 00 00 F3 0F 10 15 ?? ?? ?? ?? 0F 2E DA 7A 06 0F 84 0C 06 00 00 F3 0F 10 0D ?? ?? ?? ?? 0F 2E D9 7A 06 0F 84 B3 05 00 00 0F 2E E2 7A 06 0F 84 9B 05 00 00 0F 2E E1 7A 06 0F 84 83 05 00 00 81 E6 FF FF FF 7F 81 E3 FF FF FF 7F 89 34 24 81 C9 00 00 80 3F 89 5C 24 04 F3 0F 10 14 24 F3 0F 10 4C 24 04 89 4C 24 10 0F 2F D1 76 18 DD 05 ?? ?? ?? ?? F3 0F 5C C1 F3 0F 5E C2 F3 0F 11 04 24 D9 04 24 EB 0E F3 0F 5E D1 F3 0F 11 14 24 D9 EE D9 04 24 D9 44 24 10 D9 C1 D8 CA D9 C0 D8 C9 D9 E8 DD 05 ?? ?? ?? ?? D8 CA DD 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? DE CB C1 FA 1F D9 CA DE C1 D9 C9 DC 05 ?? ?? ?? ?? DE CA DE C1 DE CA D9 C9 DE C2 D9 C9 DC 0C D5 ?? ?? ?? ?? DC 04 D5 ?? ?? ?? ?? DE C9 D9 5C 24 08 F3 0F 10 64 24 08 EB 04 F3 0F 58 E3 8B 55 10 8B 4D 08 F3 0F 11 22 8B 58 04 8B FB 8B 71 04 8B D3 F3 0F 10 61 04 8B CE 81 E7 FF FF FF 7F 81 E1 00 00 00 80 81 E2 00 00 00 80 81 FF 00 00 80 7F F3 0F 10 58 04 0F 8F 45 01 00 00 8B FE 81 E7 FF FF FF 7F 81 FF 00 00 80 7F 0F 8F 31 01 00 00 0F 57 C0 0F 2E E0 7A 06 0F 84 3B 06 00 00 0F 2E D8 7A 06 0F 84 12 06 00 00 F3 0F 10 15 ?? ?? ?? ?? 0F 2E DA 7A 06 0F 84 B7 05 00 00 F3 0F 10 0D ?? ?? ?? ?? 0F 2E D9 7A 06 0F 84 5E 05 00 00 0F 2E E2 7A 06 0F 84 46 05 00 00 0F 2E E1 7A 06 0F 84 2E 05 00 00 81 E6 FF FF FF 7F 81 E3 FF FF FF 7F 89 74 24 14 81 C9 00 00 80 3F 89 5C 24 18 F3 0F 10 54 24 14 F3 0F 10 4C 24 18 89 4C 24 10 0F 2F D1 76 18 DD 05 ?? ?? ?? ?? F3 0F 5C C1 F3 0F 5E C2 F3 0F 11 04 24 D9 04 24 EB 0E F3 0F 5E D1 F3 0F 11 14 24 D9 EE D9 04 24 D9 44 24 10 D9 C1 D8 CA D9 C0 D8 C9 D9 E8 DD 05 ?? ?? ?? ?? D8 CA DD 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? DE CB C1 FA 1F D9 CA DE C1 D9 C9 DC 05 ?? ?? ?? ?? DE CA DE C1 DE CA D9 C9 DE C2 D9 C9 DC 0C D5 ?? ?? ?? ?? DC 04 D5 ?? ?? ?? ?? DE C9 D9 5C 24 08 F3 0F 10 64 24 08 EB 04 F3 0F 58 E3 8B 55 10 8B 4D 08 F3 0F 11 62 04 8B 58 08 8B FB 8B 71 08 8B D3 F3 0F 10 61 08 8B CE 81 E7 FF FF FF 7F 81 E1 00 00 00 80 81 E2 00 00 00 80 81 FF 00 00 80 7F F3 0F 10 58 08 0F 8F 45 01 00 00 8B FE 81 E7 FF FF FF 7F 81 FF 00 00 80 7F 0F 8F 31 01 00 00 0F 57 C0 0F 2E E0 7A 06 0F 84 E3 05 00 00 0F 2E D8 7A 06 0F 84 BA 05 00 00 F3 0F 10 15 ?? ?? ?? ?? 0F 2E DA 7A 06 0F 84 5F 05 00 00 F3 0F 10 0D ?? ?? ?? ?? 0F 2E D9 7A 06 0F 84 06 05 00 00 0F 2E E2 7A 06 0F 84 EE 04 00 00 0F 2E E1 7A 06 0F 84 D6 04 00 00 81 E6 FF FF FF 7F 81 E3 FF FF FF 7F 89 74 24 14 81 C9 00 00 80 3F 89 5C 24 18 F3 0F 10 54 24 14 F3 0F 10 4C 24 18 89 4C 24 10 0F 2F D1 76 18 DD 05 ?? ?? ?? ?? F3 0F 5C C1 F3 0F 5E C2 F3 0F 11 04 24 D9 04 24 EB 0E F3 0F 5E D1 F3 0F 11 14 24 D9 EE D9 04 24 D9 44 24 10 D9 C1 D8 CA D9 C0 D8 C9 D9 E8 DD 05 ?? ?? ?? ?? D8 CA DD 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? DE CB C1 FA 1F D9 CA DE C1 D9 C9 DC 05 ?? ?? ?? ?? DE CA DE C1 DE CA D9 C9 DE C2 D9 C9 DC 0C D5 ?? ?? ?? ?? DC 04 D5 ?? ?? ?? ?? DE C9 D9 5C 24 08 F3 0F 10 64 24 08 EB 04 F3 0F 58 E3 8B 55 10 8B 4D 08 F3 0F 11 62 08 F3 0F 10 61 0C 8B 51 0C 8B DA 8B 48 0C 8B F1 F3 0F 10 58 0C 8B C1 25 FF FF FF 7F 81 E3 00 00 00 80 81 E6 00 00 00 80 3D 00 00 80 7F 0F 8F 43 01 00 00 8B C2 25 FF FF FF 7F 3D 00 00 80 7F 0F 8F 31 01 00 00 0F 57 C0 0F 2E E0 7A 06 0F 84 8F 05 00 00 0F 2E D8 7A 06 0F 84 66 05 00 00 F3 0F 10 15 ?? ?? ?? ?? 0F 2E DA 7A 06 0F 84 0B 05 00 00 F3 0F 10 0D ?? ?? ?? ?? 0F 2E D9 7A 06 0F 84 B2 04 00 00 0F 2E E2 7A 06 0F 84 9A 04 00 00 0F 2E E1 7A 06 0F 84 82 04 00 00 81 E2 FF FF FF 7F 81 E1 FF FF FF 7F 89 54 24 14 81 CB 00 00 80 3F 89 4C 24 18 F3 0F 10 54 24 14 F3 0F 10 4C 24 18 89 5C 24 10 0F 2F D1 76 18 DD 05 ?? ?? ?? ?? F3 0F 5C C1 F3 0F 5E C2 F3 0F 11 04 24 D9 04 24 EB 0E F3 0F 5E D1 F3 0F 11 14 24 D9 EE D9 04 24 D9 44 24 10 D9 C1 D8 CA D9 C0 D8 C9 D9 E8 DD 05 ?? ?? ?? ?? D8 CA DD 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? DE CB C1 FE 1F D9 CA DE C1 D9 C9 DC 05 ?? ?? ?? ?? DE CA DE C1 DE CA D9 C9 DE C2 D9 C9 DC 0C F5 ?? ?? ?? ?? DC 04 F5 ?? ?? ?? ?? DE C9 D9 5C 24 08 F3 0F 10 64 24 08 EB 04 F3 0F 58 E3 8B 45 10 F3 0F 11 60 0C 83 C4 1C 5B 5F 5E 8B E5 5D C3 F3 0F 10 25 ?? ?? ?? ?? E9 4E FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 41 FB FF FF 0F 2E E2 7A 02 74 32 0F 2E E1 7A 02 74 1E 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 22 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 15 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 08 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 FB FA FF FF 0F 2E E2 7A 02 74 34 0F 2E 25 ?? ?? ?? ?? 7A 02 74 1C 0F 2F C4 F3 0F 10 0D ?? ?? ?? ?? 0F 28 E0 0F 86 D5 FA FF FF 0F 28 E1 E9 CD FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 C0 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 B3 FA FF FF 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 A2 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 95 FA FF FF 85 C9 74 33 0F 2F D8 0F 87 88 FA FF FF 0F 2F C3 77 18 85 D2 F3 0F 10 05 ?? ?? ?? ?? 0F 84 73 FA FF FF 0F 28 E0 E9 6B FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 5E FA FF FF 0F 2F D8 0F 87 55 FA FF FF 0F 2F C3 77 18 85 D2 F3 0F 10 05 ?? ?? ?? ?? 0F 84 40 FA FF FF 0F 28 E0 E9 38 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 2B FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 A5 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 98 FB FF FF 0F 2E E2 7A 02 74 32 0F 2E E1 7A 02 74 1E 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 79 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 6C FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 5F FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 52 FB FF FF 0F 2E E2 7A 02 74 34 0F 2E 25 ?? ?? ?? ?? 7A 02 74 1C 0F 2F C4 F3 0F 10 0D ?? ?? ?? ?? 0F 28 E0 0F 86 2C FB FF FF 0F 28 E1 E9 24 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 17 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 0A FB FF FF 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 F9 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 EC FA FF FF 85 C9 74 33 0F 2F D8 0F 87 DF FA FF FF 0F 2F C3 77 18 85 D2 F3 0F 10 05 ?? ?? ?? ?? 0F 84 CA FA FF FF 0F 28 E0 E9 C2 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 B5 FA FF FF 0F 2F D8 0F 87 AC FA FF FF 0F 2F C3 77 18 85 D2 F3 0F 10 05 ?? ?? ?? ?? 0F 84 97 FA FF FF 0F 28 E0 E9 8F FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 82 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 FD FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 F0 FB FF FF 0F 2E E2 7A 02 74 32 0F 2E E1 7A 02 74 1E 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 D1 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 C4 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 B7 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 AA FB FF FF 0F 2E E2 7A 02 74 34 0F 2E 25 ?? ?? ?? ?? 7A 02 74 1C 0F 2F C4 F3 0F 10 0D ?? ?? ?? ?? 0F 28 E0 0F 86 84 FB FF FF 0F 28 E1 E9 7C FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 6F FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 62 FB FF FF 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 51 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 44 FB FF FF 85 C9 74 33 0F 2F D8 0F 87 37 FB FF FF 0F 2F C3 77 18 85 D2 F3 0F 10 05 ?? ?? ?? ?? 0F 84 22 FB FF FF 0F 28 E0 E9 1A FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 0D FB FF FF 0F 2F D8 0F 87 04 FB FF FF 0F 2F C3 77 18 85 D2 F3 0F 10 05 ?? ?? ?? ?? 0F 84 EF FA FF FF 0F 28 E0 E9 E7 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 DA FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 51 FC FF FF F3 0F 10 25 ?? ?? ?? ?? E9 44 FC FF FF 0F 2E E2 7A 02 74 32 0F 2E E1 7A 02 74 1E 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 25 FC FF FF F3 0F 10 25 ?? ?? ?? ?? E9 18 FC FF FF F3 0F 10 25 ?? ?? ?? ?? E9 0B FC FF FF F3 0F 10 25 ?? ?? ?? ?? E9 FE FB FF FF 0F 2E E2 7A 02 74 34 0F 2E 25 ?? ?? ?? ?? 7A 02 74 1C 0F 2F C4 F3 0F 10 0D ?? ?? ?? ?? 0F 28 E0 0F 86 D8 FB FF FF 0F 28 E1 E9 D0 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 C3 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 B6 FB FF FF 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 A5 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 98 FB FF FF 85 DB 74 33 0F 2F D8 0F 87 8B FB FF FF 0F 2F C3 77 18 85 F6 F3 0F 10 05 ?? ?? ?? ?? 0F 84 76 FB FF FF 0F 28 E0 E9 6E FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 61 FB FF FF 0F 2F D8 0F 87 58 FB FF FF 0F 2F C3 77 18 85 F6 F3 0F 10 05 ?? ?? ?? ?? 0F 84 43 FB FF FF 0F 28 E0 E9 3B FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 2E FB FF FF 8B FF }
	condition:
		$1
}

rule file_33_1_0 {
	meta:
		name = "___sse2_atan2f4"
		size = 368
		refs = "0012 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC A0 00 00 00 83 E4 F0 89 44 24 64 0F 28 15 ?? ?? ?? ?? 0F 28 EA 0F 29 44 24 20 0F 54 E9 0F 54 D0 0F 28 35 ?? ?? ?? ?? 0F 29 4C 24 30 0F 54 C6 0F 28 FE 0F 56 05 ?? ?? ?? ?? 0F 28 DD 0F 54 F9 0F 29 44 24 10 0F 56 3D ?? ?? ?? ?? 0F C2 DA 01 0F 28 E3 0F 54 E5 0F 28 C3 0F 55 C2 0F 56 E0 0F 54 D3 0F 28 C3 0F 55 C5 0F 56 D0 0F 5E E2 D9 44 24 20 D8 4C 24 24 D8 4C 24 28 D8 4C 24 2C D9 44 24 30 D8 4C 24 34 D8 4C 24 38 D8 4C 24 3C DE C9 DD 1C 24 0F 54 F3 0F 57 ED 0F 54 1D ?? ?? ?? ?? 0F C2 CD 01 0F 56 E6 0F 54 0D ?? ?? ?? ?? 0F 28 C4 8B 44 24 04 0F 59 C4 0F 28 D0 0F 59 D0 0F 28 35 ?? ?? ?? ?? 25 00 00 F0 7F 0F 59 F2 0F 28 2D ?? ?? ?? ?? 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 F2 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 F2 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 F2 0F 59 C5 0F 58 35 ?? ?? ?? ?? 0F 58 C6 0F 59 C4 0F 28 6C 24 10 0F 58 C3 0F 59 C7 0F 58 C1 0F 59 C5 74 09 3D 00 00 F0 7F 74 02 EB 27 83 EC 20 8D 44 24 40 89 04 24 8D 44 24 50 89 44 24 04 8D 44 24 60 89 44 24 08 E8 B2 F3 FF FF 83 C4 20 0F 28 44 24 40 8B 64 24 64 C3 EB 03 CC CC CC }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "__rmtmp"
		size = 173
		refs = "0003 __sehtable$__rmtmp 0008 __SEH_prolog4 0014 __lock 0023 __nstream 002a ___piob 003e __lock_file2 0061 __fclose_nolock 0086 __unlock_file2 009c __SEH_epilog4 00a7 __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 6A 01 E8 ?? ?? ?? ?? 59 21 7D FC 33 F6 89 75 E0 3B 35 ?? ?? ?? ?? 7D 64 A1 ?? ?? ?? ?? 8B 04 B0 85 C0 74 3E F6 40 0C 83 74 38 50 56 E8 ?? ?? ?? ?? 59 59 C7 45 FC 01 00 00 00 A1 ?? ?? ?? ?? 8B 04 B0 F6 40 0C 83 74 11 83 78 1C 00 74 0B 50 E8 ?? ?? ?? ?? 59 47 89 7D E4 83 65 FC 00 E8 09 00 00 00 46 EB A8 8B 7D E4 8B 75 E0 A1 ?? ?? ?? ?? FF 34 B0 56 E8 ?? ?? ?? ?? 59 59 C3 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C7 E8 ?? ?? ?? ?? C3 8B 7D E4 6A 01 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "___libm_sse2_sin"
		size = 430
		refs = "001b _PI32INV 0027 _SHIFTER 0037 _P_1 0043 _P_2 0060 _SC_4 0066 _Ctable 007b _P_3 00a0 _SC_2 00e5 _SC_3 00f1 _SC_1 015d _ALL_ONES 0166 _TWO_POW_55 0176 _TWO_POW_M55 0195 _sin 01a9 _NEG_ZERO"
	strings:
		$1 = { 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 36 01 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 2D D1 F2 0F 58 CA F2 0F 10 1D ?? ?? ?? ?? F2 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 D9 66 0F 14 C9 81 C2 00 76 1C 00 F2 0F 10 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 05 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C E3 F2 0F 10 78 08 66 0F 14 C0 F2 0F 10 DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB F2 0F 10 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 F2 0F 10 C3 F2 0F 58 58 08 66 0F 59 CF F2 0F 10 FC F2 0F 58 E3 66 0F 58 F5 F2 0F 10 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F2 0F 58 CE F2 0F 58 E1 66 0F 28 C4 C3 7F 2C 66 C1 E8 04 66 3D FD 0C 75 09 F2 0F 59 05 ?? ?? ?? ?? C3 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 5C D8 F2 0F 59 1D ?? ?? ?? ?? C3 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 74 19 83 EC 08 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 83 C4 08 C3 F2 0F 59 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_36_3_0 {
	meta:
		name = "?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z"
		size = 414
		refs = "003a ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 009f __imp__MultiByteToWideChar@24 00ca __isleadbyte_l 0163 __errno"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 57 8B 7D 0C 85 FF 74 05 33 C0 66 89 07 8B 5D 10 85 DB 0F 84 6D 01 00 00 83 7D 14 00 0F 84 63 01 00 00 80 3B 00 0F 84 5A 01 00 00 56 FF 75 1C 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D F0 33 F6 39 B1 A8 00 00 00 75 2C 85 FF 74 06 0F B6 03 66 89 07 8B 45 08 85 C0 74 06 C7 00 01 00 00 00 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 8B C6 5E E9 21 01 00 00 8B 45 18 39 30 74 43 8A 03 8B 5D 18 88 43 01 83 79 74 01 7E 2E 33 C0 85 FF 0F 95 C0 50 57 6A 02 53 6A 09 FF 71 04 FF 15 ?? ?? ?? ?? 85 C0 74 13 8B 4D 08 89 33 85 C9 74 B2 8B 45 F0 8B 40 74 89 01 EB A8 89 33 E9 A1 00 00 00 8D 45 F0 50 0F B6 03 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 6C 8B 4D F0 8B 51 74 39 55 14 73 1D 8B 4D 18 8A 03 88 01 8B 45 08 85 C0 0F 84 71 FF FF FF C7 00 FE FF FF FF E9 66 FF FF FF 83 FA 01 7E 1D 33 C0 85 FF 0F 95 C0 50 57 52 53 6A 09 FF 71 04 FF 15 ?? ?? ?? ?? 8B 4D F0 85 C0 75 0D 80 7B 01 00 75 07 8B 45 18 89 30 EB 37 8B 55 08 85 D2 0F 84 2C FF FF FF 8B 41 74 89 02 E9 22 FF FF FF 33 C0 85 FF 0F 95 C0 50 8B 45 F0 57 6A 01 53 6A 09 FF 70 04 FF 15 ?? ?? ?? ?? 85 C0 0F 85 F3 FE FF FF E8 ?? ?? ?? ?? C7 00 2A 00 00 00 85 FF 74 05 33 C0 66 89 07 8B 45 08 85 C0 74 03 83 08 FF E8 ?? ?? ?? ?? 8B 30 E9 D6 FE FF FF 8B 45 08 85 C0 74 03 83 20 00 33 C0 5F 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_4_0 {
	meta:
		name = "__mbsrtowcs_helper"
		size = 251
		refs = "000f __errno 001a __invalid_parameter_noinfo 0035 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0041 ?mbst@?5??_mbsrtowcs_helper@@9@4HA 0063 ?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 8B 5D 0C 85 DB 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 D0 00 00 00 83 65 FC 00 8D 4D EC 56 57 8B 3B 33 F6 56 E8 ?? ?? ?? ?? 8B 45 14 85 C0 75 08 B8 ?? ?? ?? ?? 89 45 14 8B 4D 08 85 C9 75 51 8D 4D EC 51 50 68 FF FF FF 7F 57 8D 45 0C 50 8D 45 FC 50 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 18 85 C0 78 2A 8B 5D 14 74 6F 03 F8 46 8D 45 EC 50 53 68 FF FF FF 7F 57 8D 45 0C 50 8D 45 FC 50 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 18 85 C0 79 D9 83 CE FF EB 45 39 75 10 76 3E 8D 55 EC 52 50 68 FF FF FF 7F 57 51 8D 45 FC 50 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 18 85 C0 78 1C 74 16 8B 4D 08 03 F8 8B 45 14 83 C1 02 46 89 4D 08 FF 4D 10 75 CB EB 07 33 FF EB 03 83 CE FF 89 3B 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD 5F 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_5_0 {
	meta:
		name = "_btowc"
		size = 82
		refs = "0038 ?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 0C 83 F8 FF 75 07 B8 FF FF 00 00 EB 39 83 4D FC FF 88 45 0B 33 C0 50 89 45 F4 89 45 F8 8D 45 F4 50 6A 01 8D 45 0B 50 8D 45 F8 50 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 18 B8 FF FF 00 00 83 7D FC 00 7C 04 0F B7 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_6_0 {
	meta:
		name = "_mbrlen"
		size = 50
		refs = "0010 ?mbst@?1??mbrlen@@9@4HA 0024 ?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 51 83 4D FC FF 8B 45 10 85 C0 75 05 B8 ?? ?? ?? ?? 6A 00 50 FF 75 0C 8D 45 FC FF 75 08 6A 00 50 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 18 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_7_0 {
	meta:
		name = "_mbrtowc"
		size = 80
		refs = "0016 ?mbst@?1??mbrtowc@@9@4HA 0037 ??_C@_00CNPNBAHC@?$AA@ 0042 ?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 51 83 4D FC FF 83 7D 0C 00 8B 45 14 74 17 85 C0 75 05 B8 ?? ?? ?? ?? 6A 00 50 FF 75 10 FF 75 0C FF 75 08 EB 15 85 C0 75 05 B8 ?? ?? ?? ?? 6A 00 50 6A 01 68 ?? ?? ?? ?? 6A 00 8D 45 FC 50 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 18 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_9_0 {
	meta:
		name = "_mbsrtowcs_s"
		size = 159
		refs = "0025 __errno 002f __invalid_parameter_noinfo 0054 __mbsrtowcs_helper"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 56 57 85 DB 74 03 83 0B FF 8B 75 0C 8B 7D 10 85 F6 75 06 85 FF 74 1E EB 04 85 FF 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 63 33 C0 66 89 06 83 7D 14 00 74 E2 8B 45 18 3B C7 76 02 8B C7 FF 75 1C 50 FF 75 14 56 E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 75 12 85 F6 74 05 33 C0 66 89 06 E8 ?? ?? ?? ?? 8B 00 EB 28 40 85 F6 74 1B 33 C9 3B C7 76 10 66 89 0E 3B F8 76 0E E8 ?? ?? ?? ?? 6A 22 EB 9E 66 89 4C 46 FE 85 DB 74 02 89 03 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "___WSTRINGTOLD_L"
		size = 91
		refs = "0007 ___security_cookie 002e ___wstrgtold12_l 003a __ld12told 0053 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 18 8B 4D 10 8B 55 0C 56 8B 75 08 57 50 33 C0 50 50 50 FF 75 14 8D 45 F0 51 52 50 E8 ?? ?? ?? ?? 8B F8 8D 45 F0 56 50 E8 ?? ?? ?? ?? 83 C4 28 83 F8 01 75 03 83 CF 02 8B 4D FC 8B C7 5F 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1383_0_0 {
	meta:
		name = "___STRINGTOLD_L"
		size = 91
		refs = "0007 ___security_cookie 002e ___strgtold12_l 003a __ld12told 0053 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 18 8B 4D 10 8B 55 0C 56 8B 75 08 57 50 33 C0 50 50 50 FF 75 14 8D 45 F0 51 52 50 E8 ?? ?? ?? ?? 8B F8 8D 45 F0 56 50 E8 ?? ?? ?? ?? 83 C4 28 83 F8 01 75 03 83 CF 02 8B 4D FC 8B C7 5F 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_37_1_0 {
	meta:
		name = "___addl"
		size = 36
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 4D 0C 56 33 F6 8D 14 08 3B D0 72 04 3B D1 73 03 33 F6 46 8B 4D 10 8B C6 5E 89 11 5D C3 }
	condition:
		$1
}

rule file_37_2_0 {
	meta:
		name = "___ld12mul"
		size = 716
		refs = "0007 ___security_cookie 02c4 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 33 C0 53 8B 5D 0C 56 8B 75 08 89 45 D0 0F B7 53 0A 89 45 F0 0F B7 4E 0A 89 45 F4 89 45 F8 8B C2 33 C1 89 75 DC 57 BF 00 80 00 00 23 C7 89 45 D8 8D 47 FF 23 C8 23 D0 8D 04 0A 0F B7 F8 B8 FF 7F 00 00 89 7D EC 66 3B C8 0F 83 3F 02 00 00 66 3B D0 0F 83 36 02 00 00 B8 FD BF 00 00 66 3B F8 0F 87 28 02 00 00 B8 BF 3F 00 00 66 3B F8 77 0C 33 C0 89 46 04 89 06 E9 2D 02 00 00 33 C0 66 85 C9 75 1F 47 F7 46 08 FF FF FF 7F 89 7D EC 75 12 39 46 04 75 0D 39 06 75 09 66 89 46 0A E9 0A 02 00 00 66 85 D2 75 16 47 F7 43 08 FF FF FF 7F 89 7D EC 75 09 39 43 04 75 04 39 03 74 B5 6A 05 5A 89 45 D4 8D 4D F4 89 55 E8 89 55 E4 85 D2 7E 54 8D 7B 08 89 7D E0 8D 3C 46 8B 5D E0 8B F2 0F B7 03 0F B7 17 83 65 E4 00 0F AF D0 89 55 E0 03 51 FC 3B 51 FC 72 05 3B 55 E0 73 05 33 C0 40 EB 03 8B 45 E4 89 51 FC 85 C0 74 03 66 FF 01 83 C7 02 83 EB 02 4E 85 F6 7F C6 8B 75 DC 8B 55 E8 8B 5D 0C 8B 45 D4 83 C1 02 40 4A 89 45 D4 89 55 E8 85 D2 7F 96 8B 7D EC B8 FF FF 00 00 8B 5D F8 81 C7 02 C0 00 00 66 85 FF 0F 8E 9E 00 00 00 8B 75 F0 89 75 EC 85 DB 78 2C 8B 45 F4 8B D6 8B C8 C1 EA 1F 03 C0 C1 E9 1F 0B C2 03 DB 89 45 F4 03 F6 B8 FF FF 00 00 89 75 F0 0B D9 03 F8 89 5D F8 66 85 FF 7F D0 89 75 EC 8B 75 DC 8B 55 EC 66 85 FF 7E 5D 66 8B 45 F0 B9 00 80 00 00 66 3B C1 77 12 81 E2 FF FF 01 00 81 FA 00 80 01 00 0F 85 BA 00 00 00 8B 45 F2 83 F8 FF 0F 85 AA 00 00 00 83 65 F2 00 8B 45 F6 83 F8 FF 0F 85 91 00 00 00 66 8B 45 FA B9 FF FF 00 00 83 65 F6 00 66 3B C1 75 77 B8 00 80 00 00 47 66 89 45 FA EB 77 8B 55 F0 03 F8 66 85 FF 79 9C 8B 75 D0 8B C7 F7 D8 0F B7 C0 89 45 E8 03 F8 F6 45 F0 01 74 01 46 8B 4D F4 8B C3 C1 E0 1F 89 4D EC D1 6D EC 09 45 EC 8B 45 EC C1 E1 1F D1 EA 0B D1 D1 EB FF 4D E8 89 45 F4 89 55 F0 75 D1 85 F6 89 5D F8 8B 75 DC 0F 84 50 FF FF FF 33 C9 66 8B C2 41 66 0B C1 66 89 45 F0 8B 55 F0 E9 3F FF FF FF 66 40 66 89 45 FA EB 04 40 89 45 F6 8B 5D F8 EB 04 40 89 45 F2 B8 FF 7F 00 00 66 3B F8 73 19 66 8B 45 F2 0B 7D D8 66 89 06 8B 45 F4 89 46 02 89 5E 06 66 89 7E 0A EB 1E 33 C0 66 39 45 D8 0F 94 C0 83 66 04 00 48 25 00 00 00 80 05 00 80 FF 7F 83 26 00 89 46 08 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_37_3_0 {
	meta:
		name = "___multtenpow12"
		size = 851
		refs = "0007 ___security_cookie 0015 __pow10pos 002e __pow10neg 034b @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 44 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 BA ?? ?? ?? ?? 57 8B 7D 0C 83 EA 60 89 5D D0 85 FF 0F 84 18 03 00 00 79 0A BA ?? ?? ?? ?? F7 DF 83 EA 60 83 7D 10 00 75 05 33 C0 66 89 03 85 FF 0F 84 F9 02 00 00 56 BE 00 80 00 00 8B C7 83 C2 54 C1 FF 03 89 55 C4 89 7D 0C 83 E0 07 0F 84 D3 02 00 00 6B C8 0C 03 CA 89 4D CC 66 39 31 72 14 8B F1 8D 7D E4 8D 4D E4 89 4D CC A5 A5 A5 FF 4D E6 8B 7D 0C 0F B7 43 0A BB FF 7F 00 00 0F B7 71 0A 83 65 C0 00 83 65 F0 00 83 65 F4 00 83 65 F8 00 89 75 D8 81 E6 FF 7F 00 00 31 45 D8 25 FF 7F 00 00 81 65 D8 00 80 00 00 89 45 DC 03 C6 89 75 E0 0F B7 F0 8B 45 DC 66 3B C3 8B 5D D0 89 75 D4 0F 83 3D 02 00 00 B9 FF 7F 00 00 66 39 4D E0 8B 4D CC 0F 83 2B 02 00 00 C7 45 DC FD BF 00 00 66 3B 75 DC 0F 87 1A 02 00 00 C7 45 DC BF 3F 00 00 66 3B 75 DC 77 0C 33 C0 89 43 04 89 03 E9 1C 02 00 00 66 85 C0 75 21 46 33 C0 F7 43 08 FF FF FF 7F 89 75 D4 75 14 39 43 04 75 0F 39 03 75 0B 66 89 43 0A E9 F9 01 00 00 33 C0 66 83 7D E0 00 75 16 46 F7 41 08 FF FF FF 7F 89 75 D4 75 09 39 41 04 75 04 39 01 74 B1 6A 05 5F 89 45 C8 8D 55 F4 89 7D DC 89 7D E0 85 FF 7E 55 8D 34 43 8B 5D E0 8D 79 08 0F B7 07 83 65 BC 00 89 45 E0 8B 4D E0 0F B7 06 0F AF C8 89 4D E0 03 4A FC 3B 4A FC 72 05 3B 4D E0 73 05 33 C0 40 EB 03 8B 45 BC 89 4A FC 85 C0 74 03 66 FF 02 83 C6 02 83 EF 02 4B 85 DB 7F C0 8B 5D D0 8B 4D CC 8B 7D DC 8B 45 C8 83 C2 02 40 4F 89 45 C8 89 7D DC 85 FF 7F 95 8B 75 D4 8B 55 F8 81 C6 02 C0 00 00 8B 7D F0 89 55 E0 66 85 F6 7E 3B 85 D2 78 32 8B 45 F4 8B D7 C1 EA 1F 8B C8 03 C0 C1 E9 1F 0B C2 03 FF 8B 55 E0 89 45 F4 03 D2 B8 FF FF 00 00 89 7D F0 0B D1 03 F0 89 55 E0 89 55 F8 66 85 F6 7F CA 66 85 F6 7F 69 B8 FF FF 00 00 03 F0 66 85 F6 79 5D 8B 5D C0 8B C6 F7 D8 0F B7 C0 89 45 DC 03 F0 F6 45 F0 01 74 01 43 8B 4D F4 8B C2 C1 E0 1F 89 4D E0 D1 6D E0 09 45 E0 8B 45 E0 C1 E1 1F D1 EF D1 EA 0B F9 FF 4D DC 89 55 F8 89 45 F4 89 7D F0 75 CE 85 DB 89 55 E0 8B 5D D0 74 12 33 C9 66 8B C7 41 66 0B C1 66 89 45 F0 8B 7D F0 EB 04 66 8B 45 F0 B9 00 80 00 00 66 3B C1 77 0E 81 E7 FF FF 01 00 81 FF 00 80 01 00 75 42 8B 45 F2 83 F8 FF 75 36 83 65 F2 00 8B 45 F6 83 F8 FF 75 21 66 8B 45 FA BA FF FF 00 00 83 65 F6 00 66 3B C2 75 07 66 89 4D FA 46 EB 0C 66 40 66 89 45 FA EB 04 40 89 45 F6 8B 4D F8 EB 07 40 89 45 F2 8B 4D E0 8B 7D 0C B8 FF 7F 00 00 8B 55 C4 66 3B F0 73 19 66 8B 45 F2 0B 75 D8 66 89 03 8B 45 F4 89 43 02 89 4B 06 66 89 73 0A EB 1E 33 C0 66 39 45 D8 0F 94 C0 83 63 04 00 48 25 00 00 00 80 05 00 80 FF 7F 83 23 00 89 43 08 BE 00 80 00 00 85 FF 0F 85 0E FD FF FF 5E 8B 4D FC 5F 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_37_4_0 {
	meta:
		name = "___shl_12"
		size = 49
	strings:
		$1 = { 55 8B EC 56 57 8B 7D 08 8B 07 8B D0 8B 4F 04 03 C0 89 07 8B F1 C1 EA 1F C1 EE 1F 8D 04 09 0B C2 89 47 04 8B 47 08 03 C0 0B C6 89 47 08 5F 5E 5D C3 }
	condition:
		$1
}

rule file_37_5_0 {
	meta:
		name = "___shr_12"
		size = 48
	strings:
		$1 = { 55 8B EC 56 57 8B 7D 08 8B 4F 08 8B F1 8B 47 04 8B D0 D1 E8 C1 E6 1F 0B C6 C1 E2 1F 89 47 04 8B 07 D1 E9 D1 E8 0B C2 89 4F 08 89 07 5F 5E 5D C3 }
	condition:
		$1
}

rule file_37_6_0 {
	meta:
		name = "___wstrgtold12_l"
		size = 2128
		refs = "000a ___security_cookie 0049 __errno 0054 __invalid_parameter_noinfo 00bb $LN323 045b ___mtold12 049b __pow10pos 04ad __pow10neg 0818 @__security_check_cookie@4 0820 $LN119 0824 $LN108 0828 $LN97 082c $LN88 0830 $LN75 0834 $LN61 0838 $LN58 083c $LN43 0840 $LN49 0844 $LN36 0848 $LN21 084c $LN28"
	strings:
		$1 = { 55 8B EC 81 EC 80 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 89 45 80 8B 45 0C 89 45 88 33 C0 53 33 DB 40 56 89 45 9C 8B F3 8B C3 89 5D 84 57 8D 7D E0 89 75 AC 89 5D 94 89 5D A8 89 5D 90 89 5D B0 39 45 24 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 B0 07 00 00 8B 55 10 89 55 B4 C7 45 A4 09 00 00 00 C7 45 A0 0A 00 00 00 0F B7 0A 83 F9 20 74 11 66 3B 4D A4 74 0B 66 3B 4D A0 74 05 83 F9 0D 75 05 83 C2 02 EB E2 C7 45 8C 08 00 00 00 C7 45 A4 30 00 00 00 C7 45 A0 39 00 00 00 0F B7 0A 83 C2 02 89 4D 98 83 F8 0B 0F 87 06 03 00 00 FF 24 85 ?? ?? ?? ?? 8D 41 CF 66 3B 45 8C 77 08 6A 03 58 83 EA 02 EB D6 8B 45 24 0F B7 C9 8B 00 8B 80 84 00 00 00 8B 00 0F BE 00 3B C8 75 05 6A 05 58 EB BA 83 E9 2B 74 1F 49 49 74 0E 83 E9 03 0F 85 3D 02 00 00 33 C0 40 EB A3 6A 02 B9 00 80 00 00 58 89 4D 84 EB 96 6A 02 58 89 5D 84 EB 8E 33 C0 40 89 45 94 8D 41 CF 66 3B 45 8C 76 A1 8B 45 24 0F B7 C9 8B 00 8B 80 84 00 00 00 8B 00 0F BE 00 3B C8 75 04 6A 04 EB A7 83 F9 2B 74 2F 83 F9 2D 74 2A 6A 30 58 3B C8 74 AB 83 F9 43 0F 8E DF 01 00 00 83 F9 45 7E 0E 8D 41 9C 33 C9 41 3B C1 0F 87 CC 01 00 00 6A 06 E9 73 FF FF FF 83 EA 02 6A 0B E9 69 FF FF FF 8D 41 CF 6A 08 59 66 3B C1 0F 86 39 FF FF FF 8B 45 24 8B 75 98 8B 00 8B 80 84 00 00 00 8B 00 0F BE 08 0F B7 C6 3B C1 75 0B 6A 05 58 8B 75 AC E9 F2 FE FF FF 6A 30 58 66 3B F0 0F 85 0E 02 00 00 33 C0 40 EB E7 33 C0 40 6A 30 89 45 94 58 66 3B C8 72 2B 8B 5D B0 66 3B 4D A0 77 1A 83 FE 19 73 09 80 E9 30 46 88 0F 47 EB 01 43 0F B7 0A 83 C2 02 66 3B C8 73 E0 89 5D B0 33 DB 89 75 AC 8B 45 24 0F B7 C9 8B 00 8B 80 84 00 00 00 8B 00 0F BE 00 3B C8 0F 84 25 FF FF FF 83 F9 2B 0F 84 54 FF FF FF 83 F9 2D 0F 84 4B FF FF FF E9 23 FF FF FF 33 C0 40 89 45 94 89 45 A8 85 F6 75 1D 6A 30 58 66 3B C8 8B 45 B0 75 15 0F B7 0A 48 83 C2 02 66 3B 4D A4 74 F3 89 45 B0 EB 03 8B 45 B0 66 3B 4D A4 72 25 66 3B 4D A0 77 19 83 FE 19 73 08 80 E9 30 46 88 0F 47 48 0F B7 0A 83 C2 02 66 3B 4D A4 73 E1 89 45 B0 89 75 AC 0F B7 C1 83 F8 2B 0F 84 E2 FE FF FF 83 F8 2D 0F 84 D9 FE FF FF 83 F8 43 0F 8E 95 00 00 00 83 F8 45 0F 8E C0 FE FF FF 83 C0 9C E9 AD FE FF FF 33 C0 40 89 45 A8 8D 41 D0 6A 09 59 66 3B C1 0F 87 02 01 00 00 6A 04 E9 F7 FD FF FF 8D 42 FC 89 45 B4 8D 41 CF 66 3B 45 8C 77 07 6A 09 E9 E1 FD FF FF 0F B7 C1 83 E8 2B 74 22 48 48 74 10 83 E8 03 0F 85 D0 00 00 00 6A 08 E9 E4 FD FF FF 6A 07 83 C9 FF 58 89 4D 9C E9 93 FD FF FF 6A 07 E9 CF FD FF FF 33 C0 40 6A 30 89 45 90 58 EB 06 0F B7 0A 83 C2 02 66 3B C8 74 F5 8D 41 CF 6A 08 59 66 3B C1 76 A7 83 EA 02 8B F3 8B 45 88 89 10 8B 45 94 85 C0 0F 84 9F 04 00 00 8B 45 AC 83 F8 18 0F 86 D9 00 00 00 8A 45 F7 3C 05 7C 05 FE C0 88 45 F7 8B 4D B0 4F 6A 18 41 58 89 4D B0 E9 C0 00 00 00 8D 41 CF 66 3B 45 8C 0F 86 5D FF FF FF 6A 30 58 66 3B C8 E9 68 FF FF FF 83 7D 20 00 74 22 8D 42 FE 89 45 B4 0F B7 C1 83 E8 2B 0F 84 6B FF FF FF 48 48 75 22 83 4D 9C FF 6A 07 58 E9 EE FC FF FF 6A 0A 58 83 EA 02 6A 0A 59 3B C1 0F 85 DD FC FF FF E9 70 FF FF FF 8B 55 B4 E9 68 FF FF FF 33 C0 8B F3 40 89 45 90 EB 25 66 3B 4D A0 77 42 6B CE 0A 8B 75 98 0F B7 F6 83 C6 D0 03 F1 81 FE 50 14 00 00 7F 13 0F B7 0A 83 C2 02 89 4D 98 6A 30 58 66 3B C8 73 D3 EB 19 8B 4D 98 BE 51 14 00 00 6A 30 58 EB 0C 66 3B 4D A0 77 0B 0F B7 0A 83 C2 02 66 3B C8 73 EF 83 EA 02 E9 0B FF FF FF 8B 4D B0 85 C0 0F 84 A5 03 00 00 4F 80 3F 00 75 0B 48 41 4F 80 3F 00 74 F8 89 4D B0 8D 4D C4 51 50 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 4D 9C 83 C4 0C 85 C9 79 02 F7 DE 03 75 B0 8B 45 90 85 C0 75 03 03 75 18 8B 45 A8 85 C0 75 03 2B 75 1C 81 FE 50 14 00 00 0F 8F 49 03 00 00 81 FE B0 EB FF FF 0F 8C 30 03 00 00 BA ?? ?? ?? ?? 83 EA 60 85 F6 0F 84 0E 03 00 00 79 0A BA ?? ?? ?? ?? F7 DE 83 EA 60 83 7D 14 00 0F 85 F0 02 00 00 33 C0 66 89 45 C4 E9 E5 02 00 00 8B C6 83 C2 54 C1 FE 03 89 55 B0 89 75 AC 83 E0 07 0F 84 CE 02 00 00 6B C8 0C B8 00 80 00 00 03 CA 89 4D 94 66 39 01 72 11 8B F1 8D 7D B8 8D 4D B8 89 4D 94 A5 A5 A5 FF 4D BA 0F B7 79 0A 8B 55 CE 8B C7 33 C2 89 5D 8C 25 00 80 00 00 89 5D D4 89 45 A4 B8 FF 7F 00 00 23 D0 89 5D D8 23 F8 89 5D DC 8D 04 17 0F B7 F0 B8 FF 7F 00 00 89 75 9C 66 3B D0 0F 83 49 02 00 00 66 3B F8 0F 83 40 02 00 00 B8 FD BF 00 00 66 3B F0 0F 87 32 02 00 00 B8 BF 3F 00 00 66 3B F0 77 08 89 5D CC E9 37 02 00 00 66 85 D2 75 24 46 F7 45 CC FF FF FF 7F 89 75 9C 75 17 83 7D C8 00 75 11 83 7D C4 00 75 0B 33 C0 66 89 45 CE E9 14 02 00 00 66 85 FF 75 16 46 F7 41 08 FF FF FF 7F 89 75 9C 75 09 39 59 04 75 04 39 19 74 B4 6A 05 8B C3 8D 55 D8 5F 89 45 A0 89 7D 98 89 7D 88 85 FF 7E 58 8D 75 C4 8D 34 46 8D 41 08 89 45 90 0F B7 06 89 45 A8 8B 45 90 8B 4D A8 89 5D 88 0F B7 00 0F AF C8 89 4D A8 03 4A FC 3B 4A FC 72 05 3B 4D A8 73 05 33 C0 40 EB 03 8B 45 88 89 4A FC 85 C0 74 03 66 FF 02 83 6D 90 02 83 C6 02 4F 85 FF 7F BD 8B 4D 94 8B 7D 98 8B 45 A0 83 C2 02 40 4F 89 45 A0 89 7D 98 85 FF 7F 92 8B 75 9C 8B 55 DC 81 C6 02 C0 00 00 8B 7D D4 89 55 B4 66 85 F6 7E 3B 85 D2 78 32 8B 45 D8 8B D7 C1 EA 1F 8B C8 03 C0 C1 E9 1F 0B C2 03 FF 8B 55 B4 89 45 D8 03 D2 B8 FF FF 00 00 89 7D D4 0B D1 03 F0 89 55 B4 89 55 DC 66 85 F6 7F CA 66 85 F6 7F 69 B8 FF FF 00 00 03 F0 66 85 F6 79 5D 8B 5D 8C 8B C6 F7 D8 0F B7 C0 89 45 A8 03 F0 F6 45 D4 01 74 01 43 8B 4D D8 8B C2 C1 E0 1F 89 4D B4 D1 6D B4 09 45 B4 8B 45 B4 C1 E1 1F D1 EF D1 EA 0B F9 FF 4D A8 89 55 DC 89 45 D8 89 7D D4 75 CE 6A 00 85 DB 89 55 B4 5B 74 12 33 C9 66 8B C7 41 66 0B C1 66 89 45 D4 8B 7D D4 EB 04 66 8B 45 D4 BA 00 80 00 00 66 3B C2 77 0E 81 E7 FF FF 01 00 81 FF 00 80 01 00 75 40 8B 45 D6 83 F8 FF 75 34 8B 45 DA 89 5D D6 83 F8 FF 75 20 66 8B 45 DE B9 FF FF 00 00 89 5D DA 66 3B C1 75 07 66 89 55 DE 46 EB 0C 66 40 66 89 45 DE EB 04 40 89 45 DA 8B 4D DC EB 07 40 89 45 D6 8B 4D B4 8B 55 B0 B8 FF 7F 00 00 66 3B F0 72 1F 33 C0 89 5D C8 66 39 45 A4 89 5D C4 0F 94 C0 48 25 00 00 00 80 05 00 80 FF 7F 89 45 CC EB 3A 66 8B 45 D6 0B 75 A4 66 89 45 C4 8B 45 D8 89 45 C6 89 4D CA 66 89 75 CE EB 20 33 C0 66 39 45 A4 0F 94 C0 48 25 00 00 00 80 05 00 80 FF 7F 89 45 CC 89 5D C8 89 5D C4 8B 55 B0 8B 75 AC 85 F6 0F 85 13 FD FF FF 8B 45 CC 0F B7 4D C4 8B 55 C6 8B 75 CA C1 E8 10 EB 30 8B CB 8B C3 8B F3 8B D3 33 DB 43 EB 23 B8 FF 7F 00 00 BE 00 00 00 80 6A 02 EB 10 8B CB 8B C3 8B F3 8B D3 EB 0B 8B C3 8B F3 6A 04 8B CB 8B D3 5B 8B 7D 80 0B 45 84 66 89 47 0A 8B C3 66 89 0F 89 57 02 89 77 06 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "_strcpy"
		size = 16
	strings:
		$1 = { 57 8B 7C 24 08 EB 6E 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_39_1_0 {
	meta:
		name = "_strcat"
		size = 232
	strings:
		$1 = { 8B 4C 24 04 57 F7 C1 03 00 00 00 74 13 8A 01 83 C1 01 84 C0 74 3D F7 C1 03 00 00 00 75 EF 8B FF 8B 01 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C1 04 A9 00 01 01 81 74 E8 8B 41 FC 84 C0 74 23 84 E4 74 1A A9 00 00 FF 00 74 0E A9 00 00 00 FF 74 02 EB CD 8D 79 FF EB 0D 8D 79 FE EB 08 8D 79 FD EB 03 8D 79 FC 8B 4C 24 0C F7 C1 03 00 00 00 74 1D 8A 11 83 C1 01 84 D2 74 66 88 17 83 C7 01 F7 C1 03 00 00 00 75 EA EB 05 89 17 83 C7 04 BA FF FE FE 7E 8B 01 03 D0 83 F0 FF 33 C2 8B 11 83 C1 04 A9 00 01 01 81 74 E1 84 D2 74 34 84 F6 74 27 F7 C2 00 00 FF 00 74 12 F7 C2 00 00 00 FF 74 02 EB C7 89 17 8B 44 24 08 5F C3 66 89 17 8B 44 24 08 C6 47 02 00 5F C3 66 89 17 8B 44 24 08 5F C3 88 17 8B 44 24 08 5F C3 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "__wexecvp"
		size = 21
		refs = "000c __wexecvpe"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_27_191_1 {
	meta:
		name = "??$receive@I@Concurrency@@YAIPAV?$ISource@I@0@I@Z"
		size = 21
		refs = "000c ??$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@0@IPBV?$function@$$A6A_NABI@Z@std@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_27_193_1 {
	meta:
		name = "??$receive@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@AAV?$ISource@W4agent_status@Concurrency@@@0@I@Z"
		size = 21
		refs = "000c ??$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PAV?$ISource@W4agent_status@Concurrency@@@0@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_66_195_2 {
	meta:
		name = "??$receive@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PAV?$ISource@W4agent_status@Concurrency@@@0@I@Z"
		size = 21
		refs = "000c ??$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PAV?$ISource@W4agent_status@Concurrency@@@0@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_802_63_0 {
	meta:
		name = "?__InitializeCriticalSectionEx@platform@details@Concurrency@@YAHPAU_RTL_CRITICAL_SECTION@@K@Z"
		size = 21
		refs = "000c ___crtInitializeCriticalSectionEx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_48_10_2 {
	meta:
		name = "__Cnd_wait"
		size = 21
		refs = "000c ?do_wait@@YAHPAPAU_Cnd_internal_imp_t@@PAPAU_Mtx_internal_imp_t@@PBUxtime@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1003_1_0 {
	meta:
		name = "__aligned_malloc"
		size = 21
		refs = "000c __aligned_offset_malloc"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1112_4_0 {
	meta:
		name = "__atodbl"
		size = 21
		refs = "000c __atodbl_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1112_6_0 {
	meta:
		name = "__atoflt"
		size = 21
		refs = "000c __atoflt_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1112_8_0 {
	meta:
		name = "__atoldbl"
		size = 21
		refs = "000c __atoldbl_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1128_0_0 {
	meta:
		name = "__execvp"
		size = 21
		refs = "000c __execvpe"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_894_2_0 {
	meta:
		name = "__getws_s"
		size = 21
		refs = "000c __getws_helper"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_870_3_0 {
	meta:
		name = "__ismbslead"
		size = 21
		refs = "000c __ismbslead_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_509_3_0 {
	meta:
		name = "__ismbstrail"
		size = 21
		refs = "000c __ismbstrail_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_525_3_0 {
	meta:
		name = "__mbbtype"
		size = 21
		refs = "000c __mbbtype_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_479_3_0 {
	meta:
		name = "__mbsbtype"
		size = 21
		refs = "000c __mbsbtype_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_593_3_0 {
	meta:
		name = "__mbschr"
		size = 21
		refs = "000c __mbschr_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_530_3_0 {
	meta:
		name = "__mbscmp"
		size = 21
		refs = "000c __mbscmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_383_3_0 {
	meta:
		name = "__mbscoll"
		size = 21
		refs = "000c __mbscoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1118_3_0 {
	meta:
		name = "__mbscspn"
		size = 21
		refs = "000c __mbscspn_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1107_3_0 {
	meta:
		name = "__mbsdec"
		size = 21
		refs = "000c __mbsdec_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_395_3_0 {
	meta:
		name = "__mbsicmp"
		size = 21
		refs = "000c __mbsicmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1365_3_0 {
	meta:
		name = "__mbsicoll"
		size = 21
		refs = "000c __mbsicoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_514_5_0 {
	meta:
		name = "__mbslwr_s"
		size = 21
		refs = "000c __mbslwr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1056_3_0 {
	meta:
		name = "__mbsnbcnt"
		size = 21
		refs = "000c __mbsnbcnt_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1294_3_0 {
	meta:
		name = "__mbsnccnt"
		size = 21
		refs = "000c __mbsnccnt_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_461_0_0 {
	meta:
		name = "__mbsninc"
		size = 21
		refs = "000c __mbsninc_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_317_3_0 {
	meta:
		name = "__mbsnlen"
		size = 21
		refs = "000c __mbsnlen_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_993_3_0 {
	meta:
		name = "__mbspbrk"
		size = 21
		refs = "000c __mbspbrk_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1388_3_0 {
	meta:
		name = "__mbsrchr"
		size = 21
		refs = "000c __mbsrchr_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_758_3_0 {
	meta:
		name = "__mbsset"
		size = 21
		refs = "000c __mbsset_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_145_3_0 {
	meta:
		name = "__mbsspn"
		size = 21
		refs = "000c __mbsspn_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1303_3_0 {
	meta:
		name = "__mbsspnp"
		size = 21
		refs = "000c __mbsspnp_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_62_3_0 {
	meta:
		name = "__mbsstr"
		size = 21
		refs = "000c __mbsstr_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1001_0_0 {
	meta:
		name = "__mbstok"
		size = 21
		refs = "000c __mbstok_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_801_3_0 {
	meta:
		name = "__mbstrnlen"
		size = 21
		refs = "000c __mbstrnlen_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_135_5_0 {
	meta:
		name = "__mbsupr_s"
		size = 21
		refs = "000c __mbsupr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_406_9_0 {
	meta:
		name = "__strlwr_s"
		size = 21
		refs = "000c __strlwr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_989_9_0 {
	meta:
		name = "__strupr_s"
		size = 21
		refs = "000c __strupr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1284_9_0 {
	meta:
		name = "__wcslwr_s"
		size = 21
		refs = "000c __wcslwr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1390_9_0 {
	meta:
		name = "__wcsupr_s"
		size = 21
		refs = "000c __wcsupr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_936_2_0 {
	meta:
		name = "_gets_s"
		size = 21
		refs = "000c __gets_helper"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1371_4_0 {
	meta:
		name = "_strcoll"
		size = 21
		refs = "000c __strcoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_935_4_0 {
	meta:
		name = "_strtod"
		size = 21
		refs = "000c __strtod_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1331_4_0 {
	meta:
		name = "_wcstod"
		size = 21
		refs = "000c __wcstod_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_985_13_0 {
	meta:
		name = "_wcstof"
		size = 21
		refs = "000c __wcstof_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_41_1_0 {
	meta:
		name = "__localtime64"
		size = 37
		refs = "0005 ___getgmtimebuf 0014 __localtime64_s"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 59 1B C0 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_436_1_0 {
	meta:
		name = "__gmtime32"
		size = 37
		refs = "0005 ___getgmtimebuf 0014 __gmtime32_s"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 59 1B C0 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_1009_0_0 {
	meta:
		name = "__gmtime64"
		size = 37
		refs = "0005 ___getgmtimebuf 0014 __gmtime64_s"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 59 1B C0 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_814_1_0 {
	meta:
		name = "__localtime32"
		size = 37
		refs = "0005 ___getgmtimebuf 0014 __localtime32_s"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 59 1B C0 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_41_2_0 {
	meta:
		name = "__localtime64_s"
		size = 634
		refs = "001c __errno 0026 __invalid_parameter_noinfo 003c _memset 0074 ___tzset 007d __get_daylight 008f __get_dstbias 00a1 __get_timezone 00d5 __gmtime64_s 00ee __isindst 017e __allrem 019a __alldiv 0275 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 56 33 DB 57 8B 7D 08 89 5D F8 89 5D F4 89 5D FC 85 FF 75 18 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5F 5E 5B 8B E5 5D C3 6A 24 68 FF 00 00 00 57 E8 ?? ?? ?? ?? 8B 75 0C 83 C4 0C 85 F6 74 D1 39 5E 04 7F 12 7C 04 39 1E 73 0C E8 ?? ?? ?? ?? 6A 16 5E 89 30 EB C9 6A 07 58 39 46 04 7C 0A 7F EA 81 3E FF 6F 40 93 77 E2 E8 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 59 85 C0 0F 85 E5 01 00 00 8D 45 F4 50 E8 ?? ?? ?? ?? 59 85 C0 0F 85 D3 01 00 00 8D 45 FC 50 E8 ?? ?? ?? ?? 59 85 C0 0F 85 C1 01 00 00 8B 5E 04 8B 0E 85 DB 7C 6E 7F 08 81 F9 80 F4 03 00 76 64 8B 45 FC 99 2B C8 8D 45 EC 50 1B DA 89 4D EC 57 89 5D F0 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 49 FF FF FF 39 45 F8 0F 84 3C 01 00 00 57 E8 ?? ?? ?? ?? 59 85 C0 0F 84 2D 01 00 00 8B 45 F4 99 29 45 EC 8D 45 EC 50 19 55 F0 57 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 13 FF FF FF C7 47 20 01 00 00 00 E9 03 01 00 00 56 57 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 F6 FE FF FF 39 45 F8 74 2D 57 E8 ?? ?? ?? ?? 59 85 C0 74 22 8B 45 F4 03 45 FC 99 8B C8 C7 47 20 01 00 00 00 8B 07 8B F2 99 8B D8 2B D9 1B D6 89 55 08 8B F2 EB 0F 8B 07 99 8B D8 8B F2 8B 45 FC 99 2B D8 1B F2 6A 00 6A 3C 56 53 E8 ?? ?? ?? ?? 89 07 85 C0 79 0B 83 C0 3C 83 C3 C4 89 07 83 D6 FF 6A 00 6A 3C 56 53 E8 ?? ?? ?? ?? 8B F0 8B DA 8B 47 04 99 03 F0 6A 00 6A 3C 13 DA 53 56 E8 ?? ?? ?? ?? 89 47 04 85 C0 79 0C 83 C0 3C 83 C6 C4 89 47 04 83 D3 FF 6A 00 6A 3C 53 56 E8 ?? ?? ?? ?? 8B F0 8B DA 8B 47 08 99 03 F0 6A 00 6A 18 13 DA 53 56 E8 ?? ?? ?? ?? 89 47 08 85 C0 79 0C 83 C0 18 83 C6 E8 89 47 08 83 D3 FF 6A 00 6A 18 53 56 E8 ?? ?? ?? ?? 8B C8 85 D2 7C 2B 7F 04 85 C9 74 1B 8B 47 18 03 C1 6A 07 99 5E F7 FE 01 4F 0C 89 57 18 01 4F 1C 33 C0 E9 FD FD FF FF 85 D2 7F F5 7C 04 85 C9 73 EF 8B 47 18 83 C0 07 01 4F 0C 03 C1 6A 07 99 5E F7 FE 8B 47 0C 89 57 18 85 C0 7F D1 83 C0 1F C7 47 10 0B 00 00 00 89 47 0C 8D 81 6D 01 00 00 01 47 1C FF 4F 14 EB B9 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "___libm_sse2_cos"
		size = 417
		refs = "001b _PI32INV 0027 _SHIFTER 0037 _P_1 0043 _P_2 0060 _SC_4 0066 _Ctable 007b _P_3 00a0 _SC_2 00e5 _SC_3 00f1 _SC_1 0161 _ONE 0188 _cos 019c _NEG_ZERO"
	strings:
		$1 = { 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 36 01 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 2D D1 F2 0F 58 CA F2 0F 10 1D ?? ?? ?? ?? F2 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 D9 66 0F 14 C9 81 C2 10 76 1C 00 F2 0F 10 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 05 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C E3 F2 0F 10 78 08 66 0F 14 C0 F2 0F 10 DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB F2 0F 10 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 F2 0F 10 C3 F2 0F 58 58 08 66 0F 59 CF F2 0F 10 FC F2 0F 58 E3 66 0F 58 F5 F2 0F 10 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F2 0F 58 CE F2 0F 58 E1 66 0F 28 C4 C3 7F 1F 66 0F C5 C0 03 66 25 FF 7F 66 0F C4 C0 03 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C C8 66 0F 28 C1 C3 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 74 19 83 EC 08 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 83 C4 08 C3 F2 0F 59 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "__fullpath"
		size = 251
		refs = "002a __imp__GetFullPathNameA@16 0034 __imp__GetLastError@0 003a __dosmaperr 0054 __errno 0069 _calloc 0095 __invalid_parameter_noinfo 00b9 _free 00ee __getcwd"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 53 56 57 85 C0 0F 84 D5 00 00 00 80 38 00 0F 84 CC 00 00 00 8B 5D 08 85 DB 75 60 33 C9 51 51 51 50 FF 15 ?? ?? ?? ?? 85 C0 75 13 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 E9 AE 00 00 00 8B 75 10 3B F0 77 02 8B F0 83 FE FF 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 8F 00 00 00 6A 01 56 E8 ?? ?? ?? ?? 8B F8 59 59 85 FF 75 2A E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB DC 8B 75 10 85 F6 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB C3 8B FB EB 03 8B 45 0C 8D 4D FC 51 57 56 50 FF 15 ?? ?? ?? ?? 3B C6 72 18 85 DB 75 07 57 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 93 85 C0 75 14 85 DB 0F 85 5B FF FF FF 57 E8 ?? ?? ?? ?? 59 E9 4F FF FF FF 8B C7 EB 0D FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 59 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "__mbclen"
		size = 38
		refs = "000c __ismbblead"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 0F B6 06 50 E8 ?? ?? ?? ?? 59 85 C0 74 0B 80 7E 01 00 74 05 6A 02 58 EB 03 33 C0 40 5E 5D C3 }
	condition:
		$1
}

rule file_45_1_0 {
	meta:
		name = "__mbclen_l"
		size = 42
		refs = "000f __ismbblead_l"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 FF 75 0C 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 0B 80 7E 01 00 74 05 6A 02 58 EB 03 33 C0 40 5E 5D C3 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "_cimagl"
		size = 47
		refs = "0007 ___security_cookie 0027 @__security_check_cookie@4"
		altNames = "_cimag"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 8B 4D FC 8D 75 08 33 CD 8D 7D EC A5 A5 A5 A5 DD 45 F4 5F 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "___get_abstract_control"
		size = 113
	strings:
		$1 = { 55 8B EC 8B 55 08 33 C9 F7 C2 3D 0C 00 00 74 5D F6 C2 01 74 03 6A 10 59 F6 C2 04 74 03 83 C9 08 F6 C2 08 74 03 83 C9 04 F6 C2 10 74 03 83 C9 02 F6 C2 20 74 03 83 C9 01 56 BE 00 0C 00 00 8B C2 23 C6 3B C6 5E 75 08 81 C9 00 03 00 00 EB 1E F7 C2 00 08 00 00 74 08 81 C9 00 01 00 00 EB 0E F7 C2 00 04 00 00 74 06 81 C9 00 02 00 00 8B C1 5D C3 }
	condition:
		$1
}

rule file_47_1_0 {
	meta:
		name = "___get_abstract_control_sse2"
		size = 123
	strings:
		$1 = { 55 8B EC 8B 55 08 33 C9 F7 C2 80 7E 00 00 74 67 84 D2 79 03 6A 10 59 57 BF 00 02 00 00 85 D7 74 03 83 C9 08 F7 C2 00 04 00 00 74 03 83 C9 04 F7 C2 00 08 00 00 74 03 83 C9 02 F7 C2 00 10 00 00 74 03 83 C9 01 56 BE 00 60 00 00 8B C2 23 C6 3B C6 5E 75 08 81 C9 00 03 00 00 EB 1A F7 C2 00 40 00 00 74 08 81 C9 00 01 00 00 EB 0A F7 C2 00 20 00 00 74 02 0B CF 5F 8B C1 5D C3 }
	condition:
		$1
}

rule file_47_2_0 {
	meta:
		name = "___get_abstract_status"
		size = 55
		altNames = "___get_abstract_status_sse2"
	strings:
		$1 = { 55 8B EC 8B 4D 08 33 C0 F6 C1 3D 74 28 F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 5D C3 }
	condition:
		$1
}

rule file_47_4_0 {
	meta:
		name = "___get_machine_control"
		size = 111
	strings:
		$1 = { 55 8B EC 8B 55 08 33 C9 F7 C2 1F 03 00 00 74 5B F6 C2 10 74 01 41 F6 C2 08 74 03 83 C9 04 F6 C2 04 74 03 83 C9 08 F6 C2 02 74 03 83 C9 10 F6 C2 01 74 03 83 C9 20 56 BE 00 03 00 00 8B C2 23 C6 3B C6 5E 75 08 81 C9 00 0C 00 00 EB 1E F7 C2 00 02 00 00 74 08 81 C9 00 04 00 00 EB 0E F7 C2 00 01 00 00 74 06 81 C9 00 08 00 00 8B C1 5D C3 }
	condition:
		$1
}

rule file_47_5_0 {
	meta:
		name = "___get_machine_control_sse2"
		size = 126
	strings:
		$1 = { 55 8B EC 8B 55 08 33 C9 F7 C2 1F 03 00 00 74 6A F6 C2 10 74 05 B9 80 00 00 00 57 BF 00 02 00 00 F6 C2 08 74 02 0B CF F6 C2 04 74 06 81 C9 00 04 00 00 F6 C2 02 74 06 81 C9 00 08 00 00 F6 C2 01 74 06 81 C9 00 10 00 00 56 BE 00 03 00 00 8B C2 23 C6 3B C6 5E 75 08 81 C9 00 60 00 00 EB 1A 85 D7 74 08 81 C9 00 20 00 00 EB 0E F7 C2 00 01 00 00 74 06 81 C9 00 40 00 00 5F 8B C1 5D C3 }
	condition:
		$1
}

rule file_47_6_0 {
	meta:
		name = "___get_machine_status"
		size = 53
		altNames = "___get_machine_status_sse2"
	strings:
		$1 = { 55 8B EC 8B 4D 08 33 C0 F6 C1 1F 74 26 F6 C1 10 74 01 40 F6 C1 08 74 03 83 C8 04 F6 C1 04 74 03 83 C8 08 F6 C1 02 74 03 83 C8 10 F6 C1 01 74 03 83 C8 20 5D C3 }
	condition:
		$1
}

rule file_47_8_0 {
	meta:
		name = "__getfpcontrolword"
		size = 82
		refs = "0026 ___isa_available 0036 ___get_abstract_control_sse2 0040 ___get_abstract_control"
	strings:
		$1 = { 55 8B EC 83 EC 20 33 C0 89 45 E0 89 45 E4 89 45 E8 89 45 EC 89 45 F0 89 45 F4 89 45 F8 89 45 FC 9B D9 75 E0 83 3D ?? ?? ?? ?? 01 7C 04 0F AE 5D FC 56 FF 75 FC E8 ?? ?? ?? ?? FF 75 E0 8B F0 E8 ?? ?? ?? ?? 59 0B C6 59 25 1F 03 00 00 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_9_0 {
	meta:
		name = "__getfpstatusword"
		size = 80
		refs = "0026 ___isa_available 0036 ___get_abstract_status_sse2 0040 ___get_abstract_status"
	strings:
		$1 = { 55 8B EC 83 EC 20 33 C0 89 45 E0 89 45 E4 89 45 E8 89 45 EC 89 45 F0 89 45 F4 89 45 F8 89 45 FC 9B D9 75 E0 83 3D ?? ?? ?? ?? 01 7C 04 0F AE 5D FC 56 FF 75 FC E8 ?? ?? ?? ?? FF 75 E4 8B F0 E8 ?? ?? ?? ?? 59 0B C6 59 83 E0 1F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_10_0 {
	meta:
		name = "__setfpcontrolword"
		size = 127
		refs = "002b ___get_machine_control 004a ___isa_available 005a ___get_machine_control_sse2"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 56 57 33 FF 89 7D E0 89 7D E4 89 7D E8 89 7D EC 89 7D F0 89 7D F4 89 7D F8 9B D9 75 E0 BB 1F 03 00 00 53 E8 ?? ?? ?? ?? FF 75 08 8B F0 F7 D6 23 75 E0 E8 ?? ?? ?? ?? 59 0B F0 59 89 75 E0 D9 65 E0 83 3D ?? ?? ?? ?? 01 7C 27 89 7D FC 0F AE 5D FC 53 E8 ?? ?? ?? ?? FF 75 08 8B F0 F7 D6 23 75 FC E8 ?? ?? ?? ?? 59 0B F0 59 89 75 FC 0F AE 55 FC 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_11_0 {
	meta:
		name = "__setfpstatusword"
		size = 122
		refs = "0026 ___get_machine_status 0045 ___isa_available 0056 ___get_machine_status_sse2"
	strings:
		$1 = { 55 8B EC 83 EC 20 56 57 33 FF 89 7D E0 89 7D E4 89 7D E8 89 7D EC 89 7D F0 89 7D F4 89 7D F8 9B D9 75 E0 6A 1F E8 ?? ?? ?? ?? FF 75 08 8B F0 F7 D6 23 75 E4 E8 ?? ?? ?? ?? 59 0B F0 59 89 75 E4 D9 65 E0 83 3D ?? ?? ?? ?? 01 7C 28 89 7D FC 0F AE 5D FC 6A 1F E8 ?? ?? ?? ?? FF 75 08 8B F0 F7 D6 23 75 FC E8 ?? ?? ?? ?? 59 0B F0 59 89 75 FC 0F AE 55 FC 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "__dnorm"
		size = 369
		altNames = "__Dnorm"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 8B 75 08 57 33 FF 6A 0F 0F B7 46 06 47 8B D8 81 E3 00 80 00 00 59 23 C1 89 5D F8 66 89 46 06 75 17 33 C9 66 39 4E 04 75 0F 66 39 4E 02 75 09 66 39 0E 0F 84 23 01 00 00 66 85 C0 75 2D 0F B7 46 04 0F B7 4E 02 0F B7 D0 33 DB 0F B7 C1 83 EF 10 0F B7 0E 66 89 1E 66 85 D2 74 EA 8B 5D F8 66 89 56 06 66 89 46 04 66 89 4E 02 0F B7 4E 06 6A 10 58 66 3B C8 73 71 0F B7 56 02 0F B7 5E 04 89 55 FC EB 03 8B 55 FC 03 C9 66 8B C3 66 C1 E8 0F 66 0B C8 0F B7 C1 66 8B CA 0F B7 16 89 45 F4 8D 04 1B 66 C1 E9 0F 66 0B C8 8B 45 FC 0F B7 D9 03 C0 66 8B CA 66 C1 E9 0F 66 0B C8 4F 0F B7 C1 89 45 FC 8D 04 12 6A 10 66 89 06 8B 45 F4 5A 0F B7 C8 66 3B C2 72 AE 66 89 46 06 8B 45 FC 66 89 5E 04 8B 5D F8 66 89 46 02 0F B7 46 06 6A 20 59 66 3B C8 77 61 0F B7 56 04 0F B7 4E 02 0F B7 1E 8B F0 89 45 FC 8B C1 66 D1 EB C1 E0 0F 66 0B C3 66 D1 E9 0F B7 D8 8B C2 C1 E0 0F 66 0B C8 66 D1 EA 8B C6 0F B7 C9 C1 E0 0F 66 0B C2 66 D1 EE 6A 20 0F B7 D0 47 58 66 3B C6 76 CA 89 75 FC 8B 75 08 8B 45 FC 66 89 1E 8B 5D F8 66 89 46 06 66 89 56 04 66 89 4E 02 6A 0F 58 66 21 46 06 66 09 5E 06 66 8B C7 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_48_1_0 {
	meta:
		name = "__fdnorm"
		size = 202
		altNames = "__FDnorm"
	strings:
		$1 = { 55 8B EC 51 53 56 8B 75 08 57 33 FF 6A 7F 0F B7 46 02 47 8B D8 81 E3 00 80 00 00 59 23 C1 89 5D FC 66 89 46 02 75 0A 66 83 3E 00 0F 84 8B 00 00 00 66 85 C0 75 0F 66 8B 06 66 89 46 02 33 C0 6A F1 66 89 06 5F 0F B7 46 02 B9 80 00 00 00 66 3B C1 73 29 8B D9 0F B7 16 03 C0 66 8B CA 66 C1 E9 0F 66 0B C8 4F 0F B7 C9 8D 04 12 66 89 06 8B C1 66 3B CB 72 E0 8B 5D FC 66 89 4E 02 0F B7 46 02 B9 00 01 00 00 66 3B C8 77 2B 0F B7 16 8B C8 BE 00 01 00 00 8B C1 66 D1 EA C1 E0 0F 66 0B C2 66 D1 E9 47 0F B7 D0 66 3B F1 76 E9 8B 75 08 66 89 4E 02 66 89 16 6A 7F 58 66 21 46 02 66 09 5E 02 66 8B C7 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "__ldexp"
		size = 566
		refs = "000b __ldtest 0036 __real@c0dccc8000000000 004a __real@0000000000000000 0059 __real@40dccc8000000000 0066 __LInf_C 0072 __fperrraise 0083 __real@3ff71547652b82fe 008f __real@3fe0000000000000 009a __real@bfe0000000000000 00a7 __ftol2_sse 00b5 __real@3fe62e42f8000000 00c1 __real@3e4be8e7bcd5e4f2 00c9 __LEps_C 00f4 __real@3f503fa081572e11 00fc __real@3fbc718f8c124358 0106 __real@3f0152b741a5e84b 010c __real@3f8c70e8daf3bd0b 0139 __ldscale 01a9 __LNan_C"
	strings:
		$1 = { 55 8B EC 51 56 8B 75 08 57 56 E8 ?? ?? ?? ?? 0F B7 F8 8D 45 0C 50 E8 ?? ?? ?? ?? 59 59 33 C9 0F B7 C0 66 3B CF 0F 8E 36 01 00 00 66 3B C8 0F 8E 2D 01 00 00 DD 05 ?? ?? ?? ?? DC 1E DF E0 F6 C4 41 75 12 DD 45 0C 33 C0 DC 0D ?? ?? ?? ?? DD 1E E9 DB 01 00 00 DD 06 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 1B DD 05 ?? ?? ?? ?? DC 4D 0C 6A 08 DD 1E E8 ?? ?? ?? ?? 33 C0 59 40 E9 B1 01 00 00 DD 06 DC 0D ?? ?? ?? ?? D9 EE D8 D9 DF E0 DD 05 ?? ?? ?? ?? F6 C4 41 75 08 DD 05 ?? ?? ?? ?? EB 02 D9 C0 DE C2 D9 C9 E8 ?? ?? ?? ?? 8B C8 89 4D FC DB 45 FC DD 05 ?? ?? ?? ?? D8 C9 DC 2E D9 C9 DC 0D ?? ?? ?? ?? DE E9 DD 05 ?? ?? ?? ?? D9 C0 D9 E0 D8 DA DF E0 F6 C4 05 7A 12 D8 D9 DF E0 F6 C4 41 75 0B DD D8 DD D8 DD 45 0C EB 43 DD D8 D9 C0 D8 C9 DD 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 D9 C1 DC 0D ?? ?? ?? ?? DC 05 ?? ?? ?? ?? DE CA D9 C9 DE C3 D9 CA DE C9 D9 C0 D8 C2 D9 E8 DC C1 D9 CB DE E2 D9 C9 DE C2 DE F1 DC 4D 0C 8B 45 14 03 C1 50 56 DD 1E E8 ?? ?? ?? ?? 0F B7 F0 0F BF C6 59 59 83 E8 00 74 07 48 75 0C 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 66 8B C6 E9 CF 00 00 00 53 6A 02 5B 66 3B FB 75 08 66 8B C3 E9 BD 00 00 00 66 3B C3 75 0B DD 45 0C 66 8B C3 E9 AB 00 00 00 66 85 C0 75 29 DD 06 DD 05 ?? ?? ?? ?? DA E9 DF E0 F6 C4 44 7B 08 DD 45 0C E9 8B 00 00 00 6A 01 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 EB CA 33 C9 41 66 3B C1 75 1E DD 05 ?? ?? ?? ?? D9 E0 DD 06 DA E9 DF E0 F6 C4 44 7B 08 DD 45 0C 66 8B C1 EB 5A 51 EB CC 66 85 FF 75 2F FF 75 14 DD 45 0C 56 DD 1E E8 ?? ?? ?? ?? 0F B7 F0 0F BF C6 59 59 83 E8 00 74 07 48 75 0C 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 66 8B C6 EB 25 DD 06 DD 05 ?? ?? ?? ?? DA E9 DF E0 F6 C4 44 7A 07 DD 06 DC 4D 0C EB AC DD 45 0C DC 0D ?? ?? ?? ?? 33 C0 DD 1E 5B 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_426_0_0 {
	meta:
		name = "__dexp"
		size = 566
		refs = "000b __dtest 0036 __real@c09cc80000000000 004a __real@0000000000000000 0059 __real@409cc80000000000 0066 __Inf_C 0072 __fperrraise 0083 __real@3ff71547652b82fe 008f __real@3fe0000000000000 009a __real@bfe0000000000000 00a7 __ftol2_sse 00b5 __real@3fe62e42f8000000 00c1 __real@3e4be8e7bcd5e4f2 00c9 __Eps_C 00f4 __real@3f503fa081572e11 00fc __real@3fbc718f8c124358 0106 __real@3f0152b741a5e84b 010c __real@3f8c70e8daf3bd0b 0139 __dscale 01a9 __Nan_C"
	strings:
		$1 = { 55 8B EC 51 56 8B 75 08 57 56 E8 ?? ?? ?? ?? 0F B7 F8 8D 45 0C 50 E8 ?? ?? ?? ?? 59 59 33 C9 0F B7 C0 66 3B CF 0F 8E 36 01 00 00 66 3B C8 0F 8E 2D 01 00 00 DD 05 ?? ?? ?? ?? DC 1E DF E0 F6 C4 41 75 12 DD 45 0C 33 C0 DC 0D ?? ?? ?? ?? DD 1E E9 DB 01 00 00 DD 06 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 1B DD 05 ?? ?? ?? ?? DC 4D 0C 6A 08 DD 1E E8 ?? ?? ?? ?? 33 C0 59 40 E9 B1 01 00 00 DD 06 DC 0D ?? ?? ?? ?? D9 EE D8 D9 DF E0 DD 05 ?? ?? ?? ?? F6 C4 41 75 08 DD 05 ?? ?? ?? ?? EB 02 D9 C0 DE C2 D9 C9 E8 ?? ?? ?? ?? 8B C8 89 4D FC DB 45 FC DD 05 ?? ?? ?? ?? D8 C9 DC 2E D9 C9 DC 0D ?? ?? ?? ?? DE E9 DD 05 ?? ?? ?? ?? D9 C0 D9 E0 D8 DA DF E0 F6 C4 05 7A 12 D8 D9 DF E0 F6 C4 41 75 0B DD D8 DD D8 DD 45 0C EB 43 DD D8 D9 C0 D8 C9 DD 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 D9 C1 DC 0D ?? ?? ?? ?? DC 05 ?? ?? ?? ?? DE CA D9 C9 DE C3 D9 CA DE C9 D9 C0 D8 C2 D9 E8 DC C1 D9 CB DE E2 D9 C9 DE C2 DE F1 DC 4D 0C 8B 45 14 03 C1 50 56 DD 1E E8 ?? ?? ?? ?? 0F B7 F0 0F BF C6 59 59 83 E8 00 74 07 48 75 0C 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 66 8B C6 E9 CF 00 00 00 53 6A 02 5B 66 3B FB 75 08 66 8B C3 E9 BD 00 00 00 66 3B C3 75 0B DD 45 0C 66 8B C3 E9 AB 00 00 00 66 85 C0 75 29 DD 06 DD 05 ?? ?? ?? ?? DA E9 DF E0 F6 C4 44 7B 08 DD 45 0C E9 8B 00 00 00 6A 01 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 EB CA 33 C9 41 66 3B C1 75 1E DD 05 ?? ?? ?? ?? D9 E0 DD 06 DA E9 DF E0 F6 C4 44 7B 08 DD 45 0C 66 8B C1 EB 5A 51 EB CC 66 85 FF 75 2F FF 75 14 DD 45 0C 56 DD 1E E8 ?? ?? ?? ?? 0F B7 F0 0F BF C6 59 59 83 E8 00 74 07 48 75 0C 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 66 8B C6 EB 25 DD 06 DD 05 ?? ?? ?? ?? DA E9 DF E0 F6 C4 44 7A 07 DD 06 DC 4D 0C EB AC DD 45 0C DC 0D ?? ?? ?? ?? 33 C0 DD 1E 5B 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_1_0 {
	meta:
		name = "_exp2l"
		size = 201
		refs = "000a __ldtest 002a __real@c1e0000000000000 003e __real@41dfffffffc00000 0052 __ld_int 005e __ftol2_sse 006a __real@3fe0000000000000 007e __real@bfe0000000000000 0092 __real@3fe62e42fefa39ef 00a6 __ldexp"
	strings:
		$1 = { 55 8B EC 51 51 8D 45 08 50 E8 ?? ?? ?? ?? 59 98 33 C9 2B C1 0F 84 A9 00 00 00 48 0F 84 91 00 00 00 48 0F 84 85 00 00 00 DD 05 ?? ?? ?? ?? DD 45 08 D8 D1 DF E0 DD D9 F6 C4 41 7B 54 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 74 47 51 8D 45 F8 50 DD 5D F8 E8 ?? ?? ?? ?? DD 45 F8 59 59 D9 C0 E8 ?? ?? ?? ?? DC 6D 08 0F BF C8 DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 75 07 D9 E8 41 DE E9 EB 14 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 05 D9 E8 49 DE C1 DC 0D ?? ?? ?? ?? 8D 45 08 51 51 51 DD 5D 08 D9 E8 DD 1C 24 50 E8 ?? ?? ?? ?? 83 C4 10 DD 45 08 EB 13 8B 45 0E 0F B7 C0 A9 00 80 00 00 74 EE D9 EE EB 02 D9 E8 8B E5 5D C3 }
	condition:
		$1
}

rule file_426_1_0 {
	meta:
		name = "_exp2"
		size = 201
		refs = "000a __dtest 002a __real@c1e0000000000000 003e __real@41dfffffffc00000 0052 __d_int 005e __ftol2_sse 006a __real@3fe0000000000000 007e __real@bfe0000000000000 0092 __real@3fe62e42fefa39ef 00a6 __dexp"
	strings:
		$1 = { 55 8B EC 51 51 8D 45 08 50 E8 ?? ?? ?? ?? 59 98 33 C9 2B C1 0F 84 A9 00 00 00 48 0F 84 91 00 00 00 48 0F 84 85 00 00 00 DD 05 ?? ?? ?? ?? DD 45 08 D8 D1 DF E0 DD D9 F6 C4 41 7B 54 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 74 47 51 8D 45 F8 50 DD 5D F8 E8 ?? ?? ?? ?? DD 45 F8 59 59 D9 C0 E8 ?? ?? ?? ?? DC 6D 08 0F BF C8 DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 75 07 D9 E8 41 DE E9 EB 14 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 05 D9 E8 49 DE C1 DC 0D ?? ?? ?? ?? 8D 45 08 51 51 51 DD 5D 08 D9 E8 DD 1C 24 50 E8 ?? ?? ?? ?? 83 C4 10 DD 45 08 EB 13 8B 45 0E 0F B7 C0 A9 00 80 00 00 74 EE D9 EE EB 02 D9 E8 8B E5 5D C3 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "_llrint"
		size = 124
		refs = "000a __dtest 0024 _nearbyint 003f __fperrraise 0049 __real@c3e0000000000000 0056 __real@43e0000000000000 0064 __ftol2"
	strings:
		$1 = { 55 8B EC 51 51 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 85 C0 74 60 7E 05 83 F8 02 7E 51 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 55 F8 DD 45 08 83 C4 08 DD E9 DF E0 F6 C4 44 7B 0D 6A 20 DD D8 E8 ?? ?? ?? ?? DD 45 F8 59 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 75 16 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 07 E8 ?? ?? ?? ?? EB 0E DD D8 6A 01 E8 ?? ?? ?? ?? 59 33 C0 33 D2 8B E5 5D C3 }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "_llrintl"
		size = 124
		refs = "000a __ldtest 0024 _nearbyintl 003f __fperrraise 0049 __real@c3e0000000000000 0056 __real@43e0000000000000 0064 __ftol2"
	strings:
		$1 = { 55 8B EC 51 51 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 85 C0 74 60 7E 05 83 F8 02 7E 51 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 55 F8 DD 45 08 83 C4 08 DD E9 DF E0 F6 C4 44 7B 0D 6A 20 DD D8 E8 ?? ?? ?? ?? DD 45 F8 59 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 75 16 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 07 E8 ?? ?? ?? ?? EB 0E DD D8 6A 01 E8 ?? ?? ?? ?? 59 33 C0 33 D2 8B E5 5D C3 }
	condition:
		$1
}

rule file_51_12_0 {
	meta:
		name = "??0exception_ptr@std@@QAE@ABV01@@Z"
		size = 24
		refs = "000b ?__ExceptionPtrCopy@@YAXPAXPBX@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_51_28_0 {
	meta:
		name = "??_Gexception_ptr@std@@QAEPAXI@Z"
		size = 33
		refs = "0008 ?__ExceptionPtrDestroy@@YAXPAX@Z 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 56 E8 ?? ?? ?? ?? F6 45 08 01 59 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_51_35_0 {
	meta:
		name = "?_Current_exception@exception_ptr@std@@SA?AV12@XZ"
		size = 58
		refs = "0003 __ehhandler$?_Current_exception@exception_ptr@std@@SA?AV12@XZ 0008 __EH_prolog3 0018 ?__ExceptionPtrCreate@@YAXPAX@Z 002b ?__ExceptionPtrCurrentException@@YAXPAX@Z 0035 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 83 65 F0 00 FF 75 08 E8 ?? ?? ?? ?? FF 75 08 83 65 FC 00 C7 45 F0 01 00 00 00 E8 ?? ?? ?? ?? 8B 45 08 59 59 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_51_36_0 {
	meta:
		name = "__unwindfunclet$?_Current_exception@exception_ptr@std@@SA?AV12@XZ$0"
		size = 25
		refs = "0014 ??1exception_ptr@std@@QAE@XZ"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0C 00 00 00 83 65 F0 FE 8B 4D 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_121_335_1 {
	meta:
		name = "__unwindfunclet$??$make_shared@U?$_Task_impl@E@details@Concurrency@@AAPAV_CancellationTokenState@23@AAUscheduler_ptr@3@@std@@YA?AV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@4@@Z$1"
		size = 25
		refs = "0014 ??1?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QAE@XZ"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0C 00 00 00 83 65 F0 FE 8B 4D 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_121_339_1 {
	meta:
		name = "__unwindfunclet$??$make_shared@U?$_Task_impl@_N@details@Concurrency@@AAPAV_CancellationTokenState@23@AAUscheduler_ptr@3@@std@@YA?AV?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@0@AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@4@@Z$1"
		size = 25
		refs = "0014 ??1?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@std@@QAE@XZ"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0C 00 00 00 83 65 F0 FE 8B 4D 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_121_343_1 {
	meta:
		name = "__unwindfunclet$??$make_shared@U_ExceptionHolder@details@Concurrency@@ABVexception_ptr@std@@V_TaskCreationCallstack@23@@std@@YA?AV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@0@ABVexception_ptr@0@$$QAV_TaskCreationCallstack@details@Concurrency@@@Z$1"
		size = 25
		refs = "0014 ??1?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@QAE@XZ"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0C 00 00 00 83 65 F0 FE 8B 4D 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_600_252_0 {
	meta:
		name = "__unwindfunclet$?GetBitSet@SchedulerBase@details@Concurrency@@QAE?AVQuickBitSet@23@PBVlocation@3@@Z$0"
		size = 25
		refs = "0014 ??1QuickBitSet@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0C 00 00 00 83 65 F0 FE 8B 4D 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_90_443_1 {
	meta:
		name = "__unwindfunclet$?do_transform@?$collate@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@PBD0@Z$0"
		size = 25
		refs = "0014 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0C 00 00 00 83 65 F0 FE 8B 4D 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_99_1147_1 {
	meta:
		name = "__unwindfunclet$?do_transform@?$collate@G@std@@MBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@PBG0@Z$0"
		size = 25
		refs = "0014 ??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0C 00 00 00 83 65 F0 FE 8B 4D 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_99_1150_1 {
	meta:
		name = "__unwindfunclet$?do_transform@?$collate@_W@std@@MBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@PB_W0@Z$0"
		size = 25
		refs = "0014 ??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0C 00 00 00 83 65 F0 FE 8B 4D 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_20_359_1 {
	meta:
		name = "__unwindfunclet$?global@locale@std@@SA?AV12@ABV12@@Z$0"
		size = 25
		refs = "0014 ??1locale@std@@QAE@XZ"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0C 00 00 00 83 65 F0 FE 8B 4D 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_51_37_0 {
	meta:
		name = "__ehhandler$?_Current_exception@exception_ptr@std@@SA?AV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Current_exception@exception_ptr@std@@SA?AV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_544_10_0 {
	meta:
		name = "__ehhandler$??$_Resetp@V__ExceptionPtr@@@?$shared_ptr@V__ExceptionPtr@@@std@@AAEXPAV__ExceptionPtr@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Resetp@V__ExceptionPtr@@@?$shared_ptr@V__ExceptionPtr@@@std@@AAEXPAV__ExceptionPtr@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_495_17_0 {
	meta:
		name = "__ehhandler$??0?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@ABVQuickBitSet@12@_NI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@ABVQuickBitSet@12@_NI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_260_1 {
	meta:
		name = "__ehhandler$??0?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@QAE@PAV?$ISource@W4agent_status@Concurrency@@@1@IPAV?$ITarget@I@1@ABV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@QAE@PAV?$ISource@W4agent_status@Concurrency@@@1@IPAV?$ITarget@I@1@ABV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_71_1 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@D@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@D@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_179_1 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@G@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@G@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_169_2 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@_W@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@_W@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_275_2 {
	meta:
		name = "__ehhandler$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_278_1 {
	meta:
		name = "__ehhandler$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_283_2 {
	meta:
		name = "__ehhandler$??0?$_SyncOriginator@I@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_SyncOriginator@I@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_287_1 {
	meta:
		name = "__ehhandler$??0?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_509_1 {
	meta:
		name = "__ehhandler$??0?$_Task_impl@E@details@Concurrency@@QAE@PAV_CancellationTokenState@12@Uscheduler_ptr@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Task_impl@E@details@Concurrency@@QAE@PAV_CancellationTokenState@12@Uscheduler_ptr@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_512_1 {
	meta:
		name = "__ehhandler$??0?$_Task_impl@_N@details@Concurrency@@QAE@PAV_CancellationTokenState@12@Uscheduler_ptr@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Task_impl@_N@details@Concurrency@@QAE@PAV_CancellationTokenState@12@Uscheduler_ptr@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_44_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_47_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_50_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_98_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBDI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBDI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_223_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_226_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@IG@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@IG@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_229_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_232_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBGI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBGI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_237_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_240_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@I_W@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@I_W@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_42_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_246_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_WI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_WI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_566_1 {
	meta:
		name = "__ehhandler$??0?$function@$$A6A?AV?$task@_N@Concurrency@@XZ@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6A?AV?$task@_N@Concurrency@@XZ@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_569_1 {
	meta:
		name = "__ehhandler$??0?$function@$$A6A?AV?$task@_N@Concurrency@@_N@Z@std@@QAE@AAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6A?AV?$task@_N@Concurrency@@_N@Z@std@@QAE@AAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_321_2 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXABI@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXABI@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_572_1 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXE@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXE@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_575_1 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_578_1 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXV?$task@X@Concurrency@@@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXV?$task@X@Concurrency@@@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_561_2 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXV?$task@_N@Concurrency@@@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXV?$task@_N@Concurrency@@@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_564_2 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXXZ@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXXZ@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_327_1 {
	meta:
		name = "__ehhandler$??0?$function@$$A6A_NABI@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6A_NABI@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_330_1 {
	meta:
		name = "__ehhandler$??0?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_54_2 {
	meta:
		name = "__ehhandler$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_270_1 {
	meta:
		name = "__ehhandler$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_235_2 {
	meta:
		name = "__ehhandler$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_345_2 {
	meta:
		name = "__ehhandler$??0?$ordered_message_processor@I@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ordered_message_processor@I@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_348_2 {
	meta:
		name = "__ehhandler$??0?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_351_2 {
	meta:
		name = "__ehhandler$??0?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_355_2 {
	meta:
		name = "__ehhandler$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_359_1 {
	meta:
		name = "__ehhandler$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_363_1 {
	meta:
		name = "__ehhandler$??0?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_367_2 {
	meta:
		name = "__ehhandler$??0?$single_assignment@I@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$single_assignment@I@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_375_1 {
	meta:
		name = "__ehhandler$??0?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_381_2 {
	meta:
		name = "__ehhandler$??0?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_387_2 {
	meta:
		name = "__ehhandler$??0?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_394_2 {
	meta:
		name = "__ehhandler$??0?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_119_89_2 {
	meta:
		name = "__ehhandler$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_238_2 {
	meta:
		name = "__ehhandler$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_241_2 {
	meta:
		name = "__ehhandler$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_190_24_0 {
	meta:
		name = "__ehhandler$??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_199_14_0 {
	meta:
		name = "__ehhandler$??0ExternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ExternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_797_18_0 {
	meta:
		name = "__ehhandler$??0MultiWaitBlockHolder@details@Concurrency@@QAE@_NI00@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0MultiWaitBlockHolder@details@Concurrency@@QAE@_NI00@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_495_31_0 {
	meta:
		name = "__ehhandler$??0ScheduleGroupBase@details@Concurrency@@QAE@PAVSchedulerBase@12@PAVlocation@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ScheduleGroupBase@details@Concurrency@@QAE@PAVSchedulerBase@12@PAVlocation@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1050_16_0 {
	meta:
		name = "__ehhandler$??0SchedulerProxy@details@Concurrency@@QAE@PAUIScheduler@2@PAVResourceManager@12@ABVSchedulerPolicy@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0SchedulerProxy@details@Concurrency@@QAE@PAUIScheduler@2@PAVResourceManager@12@ABVSchedulerPolicy@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_501_20_0 {
	meta:
		name = "__ehhandler$??0SchedulingNode@details@Concurrency@@QAE@ABVQuickBitSet@12@KPAVSchedulingRing@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0SchedulingNode@details@Concurrency@@QAE@ABVQuickBitSet@12@KPAVSchedulingRing@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_495_41_0 {
	meta:
		name = "__ehhandler$??0Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@23@ABVQuickBitSet@23@II@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@23@ABVQuickBitSet@23@II@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_20_0 {
	meta:
		name = "__ehhandler$??0ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_302_12_0 {
	meta:
		name = "__ehhandler$??0ThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1016_12_0 {
	meta:
		name = "__ehhandler$??0TimerObj@?6??wait@Concurrency@@YAXI@Z@QAE@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0TimerObj@?6??wait@Concurrency@@YAXI@Z@QAE@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_656_17_0 {
	meta:
		name = "__ehhandler$??0TransmogrifiedPrimary@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0TransmogrifiedPrimary@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_911_14_0 {
	meta:
		name = "__ehhandler$??0UMSThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_968_17_0 {
	meta:
		name = "__ehhandler$??0WorkQueue@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0WorkQueue@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_435_23_0 {
	meta:
		name = "__ehhandler$??0_AsyncTaskCollection@details@Concurrency@@AAE@PAV_CancellationTokenState@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_AsyncTaskCollection@details@Concurrency@@AAE@PAV_CancellationTokenState@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_401_2 {
	meta:
		name = "__ehhandler$??0_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@QAE@0ABV34@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@QAE@0ABV34@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_405_2 {
	meta:
		name = "__ehhandler$??0_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@QAE@0I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@QAE@0I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_411_2 {
	meta:
		name = "__ehhandler$??0_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@QAE@0ABV45@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@QAE@0ABV45@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_415_2 {
	meta:
		name = "__ehhandler$??0_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@QAE@0I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@QAE@0I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_626_1 {
	meta:
		name = "__ehhandler$??0_ExceptionHolder@details@Concurrency@@QAE@ABVexception_ptr@std@@ABV_TaskCreationCallstack@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_ExceptionHolder@details@Concurrency@@QAE@ABVexception_ptr@std@@ABV_TaskCreationCallstack@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_7_22_2 {
	meta:
		name = "__ehhandler$??0_Locimp@locale@std@@AAE@ABV012@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Locimp@locale@std@@AAE@ABV012@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1042_23_0 {
	meta:
		name = "__ehhandler$??0_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1042_26_0 {
	meta:
		name = "__ehhandler$??0_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_435_32_0 {
	meta:
		name = "__ehhandler$??0_TaskCollection@details@Concurrency@@AAE@PAV012@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskCollection@details@Concurrency@@AAE@PAV012@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_435_35_0 {
	meta:
		name = "__ehhandler$??0_TaskCollection@details@Concurrency@@QAE@PAV_CancellationTokenState@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskCollection@details@Concurrency@@QAE@PAV_CancellationTokenState@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_435_38_0 {
	meta:
		name = "__ehhandler$??0_TaskCollection@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskCollection@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_642_1 {
	meta:
		name = "__ehhandler$??0_TaskCollectionImpl@details@Concurrency@@QAE@Uscheduler_ptr@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskCollectionImpl@details@Concurrency@@QAE@Uscheduler_ptr@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_649_1 {
	meta:
		name = "__ehhandler$??0_TaskProcThunk@details@Concurrency@@QAE@ABV?$function@$$A6AXXZ@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskProcThunk@details@Concurrency@@QAE@ABV?$function@$$A6AXXZ@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1042_35_0 {
	meta:
		name = "__ehhandler$??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1042_38_0 {
	meta:
		name = "__ehhandler$??0scoped_lock@reader_writer_lock@Concurrency@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0scoped_lock@reader_writer_lock@Concurrency@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_111_36_2 {
	meta:
		name = "__ehhandler$??0sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_37_2 {
	meta:
		name = "__ehhandler$??0sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_37_2 {
	meta:
		name = "__ehhandler$??0sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_495_59_0 {
	meta:
		name = "__ehhandler$??1?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_446_2 {
	meta:
		name = "__ehhandler$??1?$_AnonymousOriginator@I@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_AnonymousOriginator@I@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_449_2 {
	meta:
		name = "__ehhandler$??1?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_475_2 {
	meta:
		name = "__ehhandler$??1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_479_2 {
	meta:
		name = "__ehhandler$??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_703_2 {
	meta:
		name = "__ehhandler$??1?$_RunAnyParam@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_RunAnyParam@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_482_1 {
	meta:
		name = "__ehhandler$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_485_1 {
	meta:
		name = "__ehhandler$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_491_2 {
	meta:
		name = "__ehhandler$??1?$_SyncOriginator@I@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_SyncOriginator@I@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_497_2 {
	meta:
		name = "__ehhandler$??1?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_741_1 {
	meta:
		name = "__ehhandler$??1?$_Task_impl@E@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Task_impl@E@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_744_1 {
	meta:
		name = "__ehhandler$??1?$_Task_impl@_N@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Task_impl@_N@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_501_2 {
	meta:
		name = "__ehhandler$??1?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_504_2 {
	meta:
		name = "__ehhandler$??1?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_507_1 {
	meta:
		name = "__ehhandler$??1?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_534_2 {
	meta:
		name = "__ehhandler$??1?$ordered_message_processor@I@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$ordered_message_processor@I@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_541_2 {
	meta:
		name = "__ehhandler$??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_544_2 {
	meta:
		name = "__ehhandler$??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_549_2 {
	meta:
		name = "__ehhandler$??1?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_554_2 {
	meta:
		name = "__ehhandler$??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_559_1 {
	meta:
		name = "__ehhandler$??1?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_563_1 {
	meta:
		name = "__ehhandler$??1?$single_assignment@I@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$single_assignment@I@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_571_1 {
	meta:
		name = "__ehhandler$??1?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_577_1 {
	meta:
		name = "__ehhandler$??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_583_2 {
	meta:
		name = "__ehhandler$??1?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_587_1 {
	meta:
		name = "__ehhandler$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_591_1 {
	meta:
		name = "__ehhandler$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_596_1 {
	meta:
		name = "__ehhandler$??1?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_199_29_0 {
	meta:
		name = "__ehhandler$??1ExternalContextBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ExternalContextBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_37_0 {
	meta:
		name = "__ehhandler$??1InternalContextBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1InternalContextBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1316_49_0 {
	meta:
		name = "__ehhandler$??1ResourceManager@details@Concurrency@@AAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ResourceManager@details@Concurrency@@AAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_495_68_0 {
	meta:
		name = "__ehhandler$??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_600_108_0 {
	meta:
		name = "__ehhandler$??1SchedulerBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulerBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1050_28_0 {
	meta:
		name = "__ehhandler$??1SchedulerProxy@details@Concurrency@@IAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulerProxy@details@Concurrency@@IAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_501_31_0 {
	meta:
		name = "__ehhandler$??1SchedulingNode@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulingNode@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1139_24_0 {
	meta:
		name = "__ehhandler$??1SchedulingRing@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulingRing@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_39_0 {
	meta:
		name = "__ehhandler$??1ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_656_27_0 {
	meta:
		name = "__ehhandler$??1TransmogrifiedPrimary@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1TransmogrifiedPrimary@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_44_0 {
	meta:
		name = "__ehhandler$??1UMSFreeThreadProxyFactory@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1UMSFreeThreadProxyFactory@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1320_25_0 {
	meta:
		name = "__ehhandler$??1UMSSchedulerProxy@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1UMSSchedulerProxy@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_974_33_0 {
	meta:
		name = "__ehhandler$??1VirtualProcessor@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1VirtualProcessor@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_435_53_0 {
	meta:
		name = "__ehhandler$??1_AsyncTaskCollection@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_AsyncTaskCollection@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_797_40_0 {
	meta:
		name = "__ehhandler$??1_Condition_variable@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Condition_variable@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_743_2 {
	meta:
		name = "__ehhandler$??1_ExceptionHolder@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_ExceptionHolder@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_805_1 {
	meta:
		name = "__ehhandler$??1_TaskCollectionImpl@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_TaskCollectionImpl@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_814_1 {
	meta:
		name = "__ehhandler$??1_Task_impl_base@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Task_impl_base@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_613_2 {
	meta:
		name = "__ehhandler$??1agent@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1agent@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_782_2 {
	meta:
		name = "__ehhandler$??1task_options@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1task_options@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_435_85_0 {
	meta:
		name = "__ehhandler$??_G_AsyncTaskCollection@details@Concurrency@@UAEPAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??_G_AsyncTaskCollection@details@Concurrency@@UAEPAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1050_52_0 {
	meta:
		name = "__ehhandler$?AddExecutionResource@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddExecutionResource@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_74_0 {
	meta:
		name = "__ehhandler$?Alloc@InternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Alloc@InternalContextBase@details@Concurrency@@UAEPAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_600_171_0 {
	meta:
		name = "__ehhandler$?AllocateSegment@CacheLocalScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AllocateSegment@CacheLocalScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_154_39_0 {
	meta:
		name = "__ehhandler$?BeginTransmogrifying@Transmogrificator@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?BeginTransmogrifying@Transmogrificator@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1353_8_0 {
	meta:
		name = "__ehhandler$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_600_188_0 {
	meta:
		name = "__ehhandler$?CheckStaticConstruction@SchedulerBase@details@Concurrency@@CAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CheckStaticConstruction@SchedulerBase@details@Concurrency@@CAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_72_0 {
	meta:
		name = "__ehhandler$?Create@FreeThreadProxyFactory@details@Concurrency@@EAEPAVFreeThreadProxy@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@FreeThreadProxyFactory@details@Concurrency@@EAEPAVFreeThreadProxy@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_664_42_0 {
	meta:
		name = "__ehhandler$?Create@ThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@ThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1367_42_0 {
	meta:
		name = "__ehhandler$?Create@UMSThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@UMSThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1050_66_0 {
	meta:
		name = "__ehhandler$?CreateExternalThreadResource@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@PAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateExternalThreadResource@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@PAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_79_0 {
	meta:
		name = "__ehhandler$?CreateFactory@UMSFreeThreadProxyFactory@details@Concurrency@@SAPAV123@PAVThreadProxyFactoryManager@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateFactory@UMSFreeThreadProxyFactory@details@Concurrency@@SAPAV123@PAVThreadProxyFactoryManager@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_664_45_0 {
	meta:
		name = "__ehhandler$?CreateInternalContext@ThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateInternalContext@ThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1367_45_0 {
	meta:
		name = "__ehhandler$?CreateInternalContext@UMSThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateInternalContext@UMSThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1316_102_0 {
	meta:
		name = "__ehhandler$?CreateSchedulerProxy@ResourceManager@details@Concurrency@@AAEPAVSchedulerProxy@23@PAUIScheduler@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateSchedulerProxy@ResourceManager@details@Concurrency@@AAEPAVSchedulerProxy@23@PAUIScheduler@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_190_99_0 {
	meta:
		name = "__ehhandler$?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_664_50_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessor@ThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessor@ThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1367_50_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessor@UMSThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessor@UMSThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1050_72_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1320_50_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessorRoot@UMSSchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessorRoot@UMSSchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_190_102_0 {
	meta:
		name = "__ehhandler$?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1050_82_0 {
	meta:
		name = "__ehhandler$?DestroyVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@QAEXPAVVirtualProcessorRoot@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DestroyVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@QAEXPAVVirtualProcessorRoot@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_600_253_0 {
	meta:
		name = "__ehhandler$?GetBitSet@SchedulerBase@details@Concurrency@@QAE?AVQuickBitSet@23@PBVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetBitSet@SchedulerBase@details@Concurrency@@QAE?AVQuickBitSet@23@PBVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1316_136_0 {
	meta:
		name = "__ehhandler$?GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_600_266_0 {
	meta:
		name = "__ehhandler$?GetExternalContext@SchedulerBase@details@Concurrency@@AAEPAVExternalContextBase@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetExternalContext@SchedulerBase@details@Concurrency@@AAEPAVExternalContextBase@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_98_0 {
	meta:
		name = "__ehhandler$?GetFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVFreeThreadProxyFactory@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVFreeThreadProxyFactory@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1316_154_0 {
	meta:
		name = "__ehhandler$?GetNodeCount@ResourceManager@details@Concurrency@@SAIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetNodeCount@ResourceManager@details@Concurrency@@SAIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_106_0 {
	meta:
		name = "__ehhandler$?GetUMSFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVUMSFreeThreadProxyFactory@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetUMSFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVUMSFreeThreadProxyFactory@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_495_147_0 {
	meta:
		name = "__ehhandler$?Grow@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEPAUSegment@123@PAU4123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Grow@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEPAUSegment@123@PAU4123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1316_205_0 {
	meta:
		name = "__ehhandler$?Release@ResourceManager@details@Concurrency@@UAEIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Release@ResourceManager@details@Concurrency@@UAEIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1050_123_0 {
	meta:
		name = "__ehhandler$?RemoveCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RemoveCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_600_403_0 {
	meta:
		name = "__ehhandler$?ResetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?ResetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_600_431_0 {
	meta:
		name = "__ehhandler$?StaticDestruction@SchedulerBase@details@Concurrency@@CAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?StaticDestruction@SchedulerBase@details@Concurrency@@CAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_501_88_0 {
	meta:
		name = "__ehhandler$?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_968_69_0 {
	meta:
		name = "__ehhandler$?Steal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Steal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1316_238_0 {
	meta:
		name = "__ehhandler$?SubscribeCurrentThread@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?SubscribeCurrentThread@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1316_246_0 {
	meta:
		name = "__ehhandler$?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_435_146_0 {
	meta:
		name = "__ehhandler$?_Alias@_TaskCollection@details@Concurrency@@AAEPAV123@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Alias@_TaskCollection@details@Concurrency@@AAEPAV123@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_544_75_0 {
	meta:
		name = "__ehhandler$?_CallCopyCtor@__ExceptionPtr@@ABEXPAX0IQBU_s_CatchableType@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CallCopyCtor@__ExceptionPtr@@ABEXPAX0IQBU_s_CatchableType@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_1038_2 {
	meta:
		name = "__ehhandler$?_CreateImpl@?$task@X@Concurrency@@QAEXPAV_CancellationTokenState@details@2@Uscheduler_ptr@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CreateImpl@?$task@X@Concurrency@@QAEXPAV_CancellationTokenState@details@2@Uscheduler_ptr@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_95_1 {
	meta:
		name = "__ehhandler$?_Init@locale@std@@CAPAV_Locimp@12@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@locale@std@@CAPAV_Locimp@12@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_215_2 {
	meta:
		name = "__ehhandler$?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_100_1 {
	meta:
		name = "__ehhandler$?_Locimp_dtor@_Locimp@locale@std@@CAXPAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Locimp_dtor@_Locimp@locale@std@@CAXPAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_1189_2 {
	meta:
		name = "__ehhandler$?_Make@?$_Task_ptr@E@details@Concurrency@@SA?AV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@PAV_CancellationTokenState@23@Uscheduler_ptr@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Make@?$_Task_ptr@E@details@Concurrency@@SA?AV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@PAV_CancellationTokenState@23@Uscheduler_ptr@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_1192_2 {
	meta:
		name = "__ehhandler$?_Make@?$_Task_ptr@_N@details@Concurrency@@SA?AV?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@std@@PAV_CancellationTokenState@23@Uscheduler_ptr@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Make@?$_Task_ptr@_N@details@Concurrency@@SA?AV?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@std@@PAV_CancellationTokenState@23@Uscheduler_ptr@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_225_2 {
	meta:
		name = "__ehhandler$?_Makeloc@_Locimp@locale@std@@CAPAV123@ABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Makeloc@_Locimp@locale@std@@CAPAV123@ABV_Locinfo@3@HPAV123@PBV23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_435_205_0 {
	meta:
		name = "__ehhandler$?_NewCollection@_AsyncTaskCollection@details@Concurrency@@SAPAV123@PAV_CancellationTokenState@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_NewCollection@_AsyncTaskCollection@details@Concurrency@@SAPAV123@PAV_CancellationTokenState@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_107_1 {
	meta:
		name = "__ehhandler$?_New_Locimp@_Locimp@locale@std@@CAPAV123@ABV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_New_Locimp@_Locimp@locale@std@@CAPAV123@ABV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_111_91_2 {
	meta:
		name = "__ehhandler$?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_107_1 {
	meta:
		name = "__ehhandler$?_Osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_90_2 {
	meta:
		name = "__ehhandler$?_Osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_1214_2 {
	meta:
		name = "__ehhandler$?_Perform@?$_Continuation_func_transformer@V?$task@_N@Concurrency@@X@Concurrency@@SA?AV?$function@$$A6AEV?$task@_N@Concurrency@@@Z@std@@V?$function@$$A6AXV?$task@_N@Concurrency@@@Z@4@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Perform@?$_Continuation_func_transformer@V?$task@_N@Concurrency@@X@Concurrency@@SA?AV?$function@$$A6AEV?$task@_N@Concurrency@@@Z@std@@V?$function@$$A6AXV?$task@_N@Concurrency@@@Z@4@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_51_0 {
	meta:
		name = "__ehhandler$?_RaisedException@_TaskCollectionBase@details@Concurrency@@IAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RaisedException@_TaskCollectionBase@details@Concurrency@@IAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_783_55_0 {
	meta:
		name = "__ehhandler$?_RegisterConcRTEventTracing@details@Concurrency@@YAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RegisterConcRTEventTracing@details@Concurrency@@YAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_1311_1 {
	meta:
		name = "__ehhandler$?_Rethrow_future_exception@std@@YAXVexception_ptr@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Rethrow_future_exception@std@@YAXVexception_ptr@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_1262_2 {
	meta:
		name = "__ehhandler$?_RunTask@_TaskCollectionImpl@details@Concurrency@@SAXP6AXPAX@Z0W4_TaskInliningMode@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RunTask@_TaskCollectionImpl@details@Concurrency@@SAXP6AXPAX@Z0W4_TaskInliningMode@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_1273_2 {
	meta:
		name = "__ehhandler$?_ScheduleFuncWithAutoInline@details@Concurrency@@YAXABV?$function@$$A6AXXZ@std@@W4_TaskInliningMode@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_ScheduleFuncWithAutoInline@details@Concurrency@@YAXABV?$function@$$A6AXXZ@std@@W4_TaskInliningMode@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_1281_2 {
	meta:
		name = "__ehhandler$?_ScheduleTask@_Task_impl_base@details@Concurrency@@QAEXPAU_TaskProcHandle@23@W4_TaskInliningMode@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_ScheduleTask@_Task_impl_base@details@Concurrency@@QAEXPAU_TaskProcHandle@23@W4_TaskInliningMode@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_1284_2 {
	meta:
		name = "__ehhandler$?_ScheduleWithAutoInline@_AsyncTaskCollection@details@Concurrency@@QAE?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@W4_TaskInliningMode@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_ScheduleWithAutoInline@_AsyncTaskCollection@details@Concurrency@@QAE?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@W4_TaskInliningMode@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_412_1 {
	meta:
		name = "__ehhandler$?do_get_time@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_time@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_970_2 {
	meta:
		name = "__ehhandler$?do_get_time@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_time@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_1044_1 {
	meta:
		name = "__ehhandler$?do_get_time@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_time@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_416_1 {
	meta:
		name = "__ehhandler$?do_get_year@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_year@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_1049_1 {
	meta:
		name = "__ehhandler$?do_get_year@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_year@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_1052_1 {
	meta:
		name = "__ehhandler$?do_get_year@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_year@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_119_404_2 {
	meta:
		name = "__ehhandler$?do_transform@?$collate@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@PBD0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_transform@?$collate@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@PBD0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_1077_2 {
	meta:
		name = "__ehhandler$?do_transform@?$collate@G@std@@MBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@PBG0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_transform@?$collate@G@std@@MBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@PBG0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_1080_2 {
	meta:
		name = "__ehhandler$?do_transform@?$collate@_W@std@@MBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@PB_W0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_transform@?$collate@_W@std@@MBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@PB_W0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1042_149_0 {
	meta:
		name = "__ehhandler$?try_lock_for@critical_section@Concurrency@@QAE_NI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?try_lock_for@critical_section@Concurrency@@QAE_NI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_326_2 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QBEDD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QBEDD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_334_2 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_335_2 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_59_109_2 {
	meta:
		name = "__ehhandler$__Call_func@4"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$__Call_func@4 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_39_0 {
	meta:
		name = "?_FinishCancelState@_TaskCollectionBase@details@Concurrency@@IAEXI@Z"
		size = 38
	strings:
		$1 = { 55 8B EC 56 8D 71 18 8B 16 8B CA 8B C2 EB 04 8B D0 8B C8 83 E1 FC 0B 4D 08 F0 0F B1 0E 3B C2 75 EE 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_51_41_0 {
	meta:
		name = "?_GetTokenState@_TaskCollectionBase@details@Concurrency@@QAEPAV_CancellationTokenState@23@PAPAV_CancellationTokenRegistration@23@@Z"
		size = 40
	strings:
		$1 = { 55 8B EC 8B 41 08 33 C9 A8 01 74 0F 8B C8 83 E1 FE 74 05 8B 41 10 EB 03 6A 02 58 8B 55 08 85 D2 74 02 89 0A 5D C2 04 00 }
	condition:
		$1
}

rule file_51_46_0 {
	meta:
		name = "?_MarkCancellation@_TaskCollectionBase@details@Concurrency@@IAE_NXZ"
		size = 40
	strings:
		$1 = { 56 8D 71 18 8B 16 F6 C2 03 75 15 8B CA 8B C2 83 C9 01 F0 0F B1 0E 3B C2 74 0A 8B D0 A8 03 74 EB 32 C0 5E C3 B0 01 5E C3 }
	condition:
		$1
}

rule file_51_48_0 {
	meta:
		name = "?_RaisedCancel@_TaskCollectionBase@details@Concurrency@@IAEXXZ"
		size = 43
	strings:
		$1 = { 56 8D 71 18 8B 16 F7 C2 FC FF FF FF 75 1B 8B CA 8B C2 83 E1 03 83 C9 0C F0 0F B1 0E 3B C2 74 09 8B D0 A9 FC FF FF FF 74 E5 5E C3 }
	condition:
		$1
}

rule file_51_49_0 {
	meta:
		name = "?_RaisedException@_TaskCollectionBase@details@Concurrency@@IAEXXZ"
		size = 111
		refs = "0003 __ehhandler$?_RaisedException@_TaskCollectionBase@details@Concurrency@@IAEXXZ 0008 __EH_prolog3 0036 ??2@YAPAXI@Z 0049 ?current_exception@std@@YA?AVexception_ptr@1@XZ 006a __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 79 18 8B 17 8B C2 83 E0 FC 74 05 83 F8 0C 75 4C 8B CA 8B C2 83 E1 03 83 C9 08 F0 0F B1 0F 3B C2 74 04 8B D0 EB DE 6A 08 E8 ?? ?? ?? ?? 59 89 45 F0 33 F6 89 75 FC 85 C0 74 09 50 E8 ?? ?? ?? ?? 59 8B F0 8B 17 8B CA 8B C2 EB 04 8B D0 8B C8 83 E1 03 0B CE F0 0F B1 0F 3B C2 75 EF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_51_54_0 {
	meta:
		name = "?_RethrowException@_TaskCollectionBase@details@Concurrency@@IAEXXZ"
		size = 112
		refs = "0003 __ehhandler$?_RethrowException@_TaskCollectionBase@details@Concurrency@@IAEXXZ 0008 __EH_prolog3 0021 ?__ExceptionPtrCopy@@YAXPAXPBX@Z 002b ?__ExceptionPtrDestroy@@YAXPAX@Z 0031 ??3@YAXPAX@Z 003d ?__uncaught_exception@@YA_NXZ 0056 ?rethrow_exception@std@@YAXVexception_ptr@1@@Z 006b __EH_epilog3"
	strings:
		$1 = { 6A 0C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 77 18 83 E6 FC 74 54 83 FE 0C 74 4F 8D 45 E8 56 50 E8 ?? ?? ?? ?? 83 65 FC 00 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 67 18 00 83 C4 10 E8 ?? ?? ?? ?? 84 C0 75 17 51 51 8B C4 8D 4D E8 51 50 E8 ?? ?? ?? ?? 59 59 E8 ?? ?? ?? ?? 59 59 83 4D FC FF 8D 45 E8 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_51_56_0 {
	meta:
		name = "__ehhandler$?_RethrowException@_TaskCollectionBase@details@Concurrency@@IAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RethrowException@_TaskCollectionBase@details@Concurrency@@IAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_15_2 {
	meta:
		name = "__ehhandler$??$?0AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@2@@?$_Ref_count_obj@U?$_Task_impl@E@details@Concurrency@@@std@@QAE@AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@4@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@2@@?$_Ref_count_obj@U?$_Task_impl@E@details@Concurrency@@@std@@QAE@AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@4@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_19_2 {
	meta:
		name = "__ehhandler$??$?0AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@2@@?$_Ref_count_obj@U?$_Task_impl@_N@details@Concurrency@@@std@@QAE@AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@4@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@2@@?$_Ref_count_obj@U?$_Task_impl@_N@details@Concurrency@@@std@@QAE@AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@4@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_495_38_0 {
	meta:
		name = "__ehhandler$??0ScheduleGroupSegmentBase@details@Concurrency@@IAE@PAVScheduleGroupBase@12@PAVSchedulingRing@12@PAVlocation@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ScheduleGroupSegmentBase@details@Concurrency@@IAE@PAVScheduleGroupBase@12@PAVSchedulingRing@12@PAVlocation@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1050_57_0 {
	meta:
		name = "__ehhandler$?AddVirtualProcessorRoots@SchedulerProxy@details@Concurrency@@QAEXPAPAUIVirtualProcessorRoot@3@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddVirtualProcessorRoots@SchedulerProxy@details@Concurrency@@QAEXPAPAUIVirtualProcessorRoot@3@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_190_87_0 {
	meta:
		name = "__ehhandler$?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_742_43_0 {
	meta:
		name = "__ehhandler$?DoPolling@UMSBackgroundPoller@details@Concurrency@@QAE_NXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DoPolling@UMSBackgroundPoller@details@Concurrency@@QAE_NXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1316_214_0 {
	meta:
		name = "__ehhandler$?RequestInitialVirtualProcessors@ResourceManager@details@Concurrency@@QAEPAUIExecutionResource@3@PAVSchedulerProxy@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RequestInitialVirtualProcessors@ResourceManager@details@Concurrency@@QAEPAUIExecutionResource@3@PAVSchedulerProxy@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_190_222_0 {
	meta:
		name = "__ehhandler$?SyncPop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEPAV_UnrealizedChore@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?SyncPop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEPAV_UnrealizedChore@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_101_67_2 {
	meta:
		name = "__ehhandler$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_444_2 {
	meta:
		name = "__ehhandler$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_101_71_2 {
	meta:
		name = "__ehhandler$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_722_2 {
	meta:
		name = "__ehhandler$?_Makeushloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Makeushloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_731_2 {
	meta:
		name = "__ehhandler$?_Makewloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Makewloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_1286_1 {
	meta:
		name = "__ehhandler$?_RegisterCancellation@_Task_impl_base@details@Concurrency@@QAEXV?$weak_ptr@U_Task_impl_base@details@Concurrency@@@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RegisterCancellation@_Task_impl_base@details@Concurrency@@QAEXV?$weak_ptr@U_Task_impl_base@details@Concurrency@@@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_58_0 {
	meta:
		name = "?_SafeGetParent@_TaskCollectionBase@details@Concurrency@@IAEPAV123@XZ"
		size = 20
	strings:
		$1 = { 8B 41 04 BA FF FF FF 0F 23 C2 3B C2 74 03 8B 01 C3 33 C0 C3 }
	condition:
		$1
}

rule file_51_59_0 {
	meta:
		name = "?_WillInterruptForPendingCancel@_TaskCollectionBase@details@Concurrency@@IAE_NXZ"
		size = 109
		refs = "0005 ?_SafeGetParent@_TaskCollectionBase@details@Concurrency@@IAEPAV123@XZ 0010 ?_GetTokenState@_TaskCollectionBase@details@Concurrency@@QAEPAV_CancellationTokenState@23@PAPAV_CancellationTokenRegistration@23@@Z 0033 ?_IsMarkedForAbnormalExit@_TaskCollection@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 56 57 8B F1 E8 ?? ?? ?? ?? 6A 00 8B CE 8B F8 E8 ?? ?? ?? ?? 8B F0 EB 37 85 F6 75 40 8B 47 04 C1 F8 1C 24 01 74 06 F6 47 18 03 75 2C 84 C0 75 0B 8B CF E8 ?? ?? ?? ?? 84 C0 75 1D 6A 00 8B CF E8 ?? ?? ?? ?? 8B CF 8B F0 E8 ?? ?? ?? ?? 8B F8 85 FF 75 C5 32 C0 5F 5E C3 B0 01 EB F9 83 FE 02 74 F2 8B 4E 08 33 C0 85 C9 0F 95 C0 EB E8 }
	condition:
		$1
}

rule file_51_62_0 {
	meta:
		name = "?current_exception@std@@YA?AVexception_ptr@1@XZ"
		size = 24
		refs = "000c ?_Current_exception@exception_ptr@std@@SA?AV12@XZ"
	strings:
		$1 = { 55 8B EC 51 FF 75 08 83 65 FC 00 E8 ?? ?? ?? ?? 8B 45 08 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_51_63_0 {
	meta:
		name = "?rethrow_exception@std@@YAXVexception_ptr@1@@Z"
		size = 46
		refs = "0003 __ehhandler$?rethrow_exception@std@@YAXVexception_ptr@1@@Z 0008 __EH_prolog3 0015 ?__ExceptionPtrRethrow@@YAXPBX@Z 0022 ?__ExceptionPtrDestroy@@YAXPAX@Z 0029 __EH_epilog3"
	strings:
		$1 = { 6A 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 8D 45 08 50 E8 ?? ?? ?? ?? 83 4D FC FF 8D 45 08 50 E8 ?? ?? ?? ?? 59 59 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_51_65_0 {
	meta:
		name = "__ehhandler$?rethrow_exception@std@@YAXVexception_ptr@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?rethrow_exception@std@@YAXVexception_ptr@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_122_1 {
	meta:
		name = "__ehhandler$??$_Cancel@V?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@@?$task_completion_event@E@Concurrency@@QBE_NV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@ABV_TaskCreationCallstack@details@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Cancel@V?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@@?$task_completion_event@E@Concurrency@@QBE_NV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@ABV_TaskCreationCallstack@details@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_925_1 {
	meta:
		name = "__ehhandler$??R?$_Func_class@EV?$task@_N@Concurrency@@@std@@QBEEV?$task@_N@Concurrency@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??R?$_Func_class@EV?$task@_N@Concurrency@@@std@@QBEEV?$task@_N@Concurrency@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_884_2 {
	meta:
		name = "__ehhandler$??R?$_Func_class@XV?$task@X@Concurrency@@@std@@QBEXV?$task@X@Concurrency@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??R?$_Func_class@XV?$task@X@Concurrency@@@std@@QBEXV?$task@X@Concurrency@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_887_2 {
	meta:
		name = "__ehhandler$??R?$_Func_class@XV?$task@_N@Concurrency@@@std@@QBEXV?$task@_N@Concurrency@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??R?$_Func_class@XV?$task@_N@Concurrency@@@std@@QBEXV?$task@_N@Concurrency@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1050_99_0 {
	meta:
		name = "__ehhandler$?GetResourceForNewSubscription@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@PAV423@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetResourceForNewSubscription@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@PAV423@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_600_300_0 {
	meta:
		name = "__ehhandler$?GetSubAllocator@SchedulerBase@details@Concurrency@@SAPAVSubAllocator@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetSubAllocator@SchedulerBase@details@Concurrency@@SAPAVSubAllocator@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_911_46_0 {
	meta:
		name = "__ehhandler$?Initialize@UMSThreadVirtualProcessor@details@Concurrency@@MAEXPAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Initialize@UMSThreadVirtualProcessor@details@Concurrency@@MAEXPAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_962_2 {
	meta:
		name = "__ehhandler$?_Bridge@_TaskProcThunk@details@Concurrency@@SAXPAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Bridge@_TaskProcThunk@details@Concurrency@@SAXPAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_966_2 {
	meta:
		name = "__ehhandler$?_CallInContext@_ContextCallback@details@Concurrency@@QBEXV?$function@$$A6AXXZ@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CallInContext@_ContextCallback@details@Concurrency@@QBEXV?$function@$$A6AXXZ@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_1256_2 {
	meta:
		name = "__ehhandler$?_RunChoreBridge@_TaskProcHandle@details@Concurrency@@SAXPAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RunChoreBridge@_TaskProcHandle@details@Concurrency@@SAXPAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_1328_1 {
	meta:
		name = "__ehhandler$?_ScheduleContinuationTask@_Task_impl_base@details@Concurrency@@QAEXPAU_ContinuationTaskHandleBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_ScheduleContinuationTask@_Task_impl_base@details@Concurrency@@QAEXPAU_ContinuationTaskHandleBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_1191_2 {
	meta:
		name = "__ehhandler$?register_filter@?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@IAEXABV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?register_filter@?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@IAEXABV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "__dunscale"
		size = 148
		refs = "0051 __dnorm"
	strings:
		$1 = { 55 8B EC 56 8B 75 0C BA FF 07 00 00 66 8B 46 06 66 C1 E8 04 66 23 C2 0F B7 C8 66 3B CA 75 29 8B 45 08 33 C9 66 89 08 F6 46 06 0F 75 16 33 C0 66 39 46 04 75 0E 66 39 46 02 75 08 66 39 06 75 03 40 EB 4E 6A 02 58 EB 49 33 C0 66 3B C1 7C 1B 56 E8 ?? ?? ?? ?? 59 0F B7 C8 66 85 C9 7E 0C 8B 45 08 33 C9 66 89 08 33 C0 EB 27 66 8B 46 06 BA EF BF 00 00 66 23 C2 81 C1 02 FC FF FF BA E0 3F 00 00 66 0B C2 66 89 46 06 8B 45 08 66 89 08 83 C8 FF 5E 5D C3 }
	condition:
		$1
}

rule file_85_0_1 {
	meta:
		name = "__Dunscale"
		size = 148
		refs = "0051 __Dnorm"
	strings:
		$1 = { 55 8B EC 56 8B 75 0C BA FF 07 00 00 66 8B 46 06 66 C1 E8 04 66 23 C2 0F B7 C8 66 3B CA 75 29 8B 45 08 33 C9 66 89 08 F6 46 06 0F 75 16 33 C0 66 39 46 04 75 0E 66 39 46 02 75 08 66 39 06 75 03 40 EB 4E 6A 02 58 EB 49 33 C0 66 3B C1 7C 1B 56 E8 ?? ?? ?? ?? 59 0F B7 C8 66 85 C9 7E 0C 8B 45 08 33 C9 66 89 08 33 C0 EB 27 66 8B 46 06 BA EF BF 00 00 66 23 C2 81 C1 02 FC FF FF BA E0 3F 00 00 66 0B C2 66 89 46 06 8B 45 08 66 89 08 83 C8 FF 5E 5D C3 }
	condition:
		$1
}

rule file_52_1_0 {
	meta:
		name = "__fdunscale"
		size = 133
		refs = "0045 __fdnorm"
	strings:
		$1 = { 55 8B EC 56 8B 75 0C BA FF 00 00 00 66 8B 46 02 66 C1 E8 07 66 23 C2 0F B7 C8 66 3B CA 75 1D 8B 45 08 33 C9 66 89 08 F6 46 02 7F 75 0A 66 39 0E 75 05 33 C0 40 EB 4B 6A 02 58 EB 46 33 C0 66 3B C1 7C 1B 56 E8 ?? ?? ?? ?? 59 0F B7 C8 66 85 C9 7E 0C 8B 45 08 33 C9 66 89 08 33 C0 EB 24 66 8B 46 02 BA 7F BF 00 00 66 23 C2 83 C1 82 BA 00 3F 00 00 66 0B C2 66 89 46 02 8B 45 08 66 89 08 83 C8 FF 5E 5D C3 }
	condition:
		$1
}

rule file_117_0_1 {
	meta:
		name = "__FDunscale"
		size = 133
		refs = "0045 __FDnorm"
	strings:
		$1 = { 55 8B EC 56 8B 75 0C BA FF 00 00 00 66 8B 46 02 66 C1 E8 07 66 23 C2 0F B7 C8 66 3B CA 75 1D 8B 45 08 33 C9 66 89 08 F6 46 02 7F 75 0A 66 39 0E 75 05 33 C0 40 EB 4B 6A 02 58 EB 46 33 C0 66 3B C1 7C 1B 56 E8 ?? ?? ?? ?? 59 0F B7 C8 66 85 C9 7E 0C 8B 45 08 33 C9 66 89 08 33 C0 EB 24 66 8B 46 02 BA 7F BF 00 00 66 23 C2 83 C1 82 BA 00 3F 00 00 66 0B C2 66 89 46 02 8B 45 08 66 89 08 83 C8 FF 5E 5D C3 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "___sse2_sinf4"
		size = 448
		refs = "001b _static_const_table 00f7 ___common_sin_reduction_LA"
	strings:
		$1 = { 8B C4 81 EC 90 00 00 00 83 E4 F0 89 44 24 54 0F 28 F0 0F 28 D0 0F 28 F8 0F 28 0D ?? ?? ?? ?? 66 0F DB F9 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 59 C4 0F 28 25 ?? ?? ?? ?? 66 0F 66 FD 0F 28 2D ?? ?? ?? ?? 0F 50 C7 0B C0 75 7B 66 0F 5B C0 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 35 ?? ?? ?? ?? 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 28 05 ?? ?? ?? ?? 0F 5C D4 0F 5C D5 0F 5C D6 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 CA 0F 5C CF 0F 59 D2 0F 59 C2 0F 58 C4 0F 59 C2 0F 58 C5 0F 59 C2 0F 58 C6 0F 59 C2 0F 59 C1 0F 58 C1 66 0F EF C3 E9 EA 00 00 00 66 0F 28 CE 66 0F DB 35 ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? 0F 11 34 24 0F 11 4C 24 30 D9 04 24 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 10 89 44 24 20 D9 44 24 04 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 14 89 44 24 24 D9 44 24 08 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 18 89 44 24 28 D9 44 24 0C 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 1C 89 44 24 2C 0F 10 54 24 10 0F 10 5C 24 20 0F 57 5C 24 30 0F 28 05 ?? ?? ?? ?? 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 CA 0F 59 D2 E9 F2 FE FF FF 8B 64 24 54 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "@_RTC_AllocaHelper@12"
		size = 50
	strings:
		$1 = { 55 8B EC 53 56 8B F1 8B DA 85 F6 74 1F 85 DB 74 1B 8B 55 08 85 D2 74 14 57 B0 CC 8B FE 8B CB F3 AA 8B 02 89 46 04 89 5E 0C 89 32 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_55_1_0 {
	meta:
		name = "@_RTC_CheckStackVars2@12"
		size = 198
		refs = "0042 ?_RTC_StackFailure@@YAXPAXPBD@Z 0094 ?_RTC_AllocaFailure@@YAXPAXPAU_RTC_ALLOCA_NODE@@H@Z"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 8B DA 33 FF 85 DB 74 48 89 7D FC 39 3B 7E 41 8B F7 8B F9 8B 4B 04 8B 14 0E 81 7C 3A FC CC CC CC CC 75 0F 8B 44 0E 04 03 C2 81 3C 38 CC CC CC CC 74 0E FF 74 0E 08 FF 75 04 E8 ?? ?? ?? ?? 59 59 8B 45 FC 83 C6 0C 40 89 45 FC 3B 03 7C C5 33 FF 8B 75 08 8B C6 85 F6 74 5C 8B 40 04 47 85 C0 75 F8 EB 4E 81 3E CC CC CC CC 75 1B 81 7E 14 CC CC CC CC 75 12 81 7E 18 CC CC CC CC 75 09 81 7E 1C CC CC CC CC 74 0D 57 56 FF 75 04 E8 ?? ?? ?? ?? 83 C4 0C 8B 46 0C 81 7C 30 FC CC CC CC CC 74 0D 57 56 FF 75 04 E8 ?? ?? ?? ?? 83 C4 0C 8B 76 04 4F 85 F6 75 AE 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_55_2_0 {
	meta:
		name = "@_RTC_CheckStackVars@8"
		size = 88
		refs = "0040 ?_RTC_StackFailure@@YAXPAXPBD@Z"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 8B C1 56 33 F6 89 45 FC 39 33 7E 3F 57 8B FE 8B 4B 04 8B 14 0F 81 7C 02 FC CC CC CC CC 75 12 8B 44 0F 04 03 C2 8B 55 FC 81 3C 10 CC CC CC CC 74 0E FF 74 0F 08 FF 75 04 E8 ?? ?? ?? ?? 59 59 8B 45 FC 46 83 C7 0C 3B 33 7C C5 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_55_3_0 {
	meta:
		name = "__RTC_CheckEsp"
		size = 35
		refs = "0014 ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 75 01 C3 55 8B EC 83 EC 00 50 52 53 56 57 6A 00 FF 75 04 E8 ?? ?? ?? ?? 59 59 5F 5E 5B 5A 58 8B E5 5D C3 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "___avx_powf8"
		size = 1488
		refs = "0041 ___common_spow_data 05bd ___common_spow_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC 80 02 00 00 C5 FC 11 4C 24 20 C5 FC 11 04 24 C4 E3 7D 19 C4 01 C5 FC 5A F4 C5 F8 28 D0 C4 E3 7D 19 C8 01 C5 FC 5A F8 C5 FC 5A D9 C5 FC 5A EA C5 FD 11 7C 24 60 C5 F8 10 3D ?? ?? ?? ?? C5 F9 DB C7 C5 F1 DB CF C5 FA 7F 84 24 10 02 00 00 C5 FA 7F 8C 24 00 02 00 00 C5 FD 11 5C 24 40 C5 F8 10 1D ?? ?? ?? ?? C5 E9 FA D3 C5 D9 FA E3 C5 FA 7F 94 24 E0 01 00 00 C5 FA 7F A4 24 F0 01 00 00 C5 FD 10 05 ?? ?? ?? ?? C5 FD 10 15 ?? ?? ?? ?? C5 D5 54 C8 C5 F5 56 DA C5 CD 54 E0 C5 FD 5A FB C5 DD 56 D2 C5 FD 5A E2 C5 F8 53 C7 C5 F8 53 FC C5 FC 5A C8 C5 FC 5A E7 C4 E3 7D 19 E8 01 C5 D1 73 D5 14 C5 F9 73 D0 14 C5 D0 C6 E8 DD C4 E3 7D 19 F7 01 C5 C9 73 D6 14 C5 F9 73 D7 14 C5 C8 C6 F8 DD C4 E3 7D 09 C1 00 C4 E3 7D 09 CC 00 C5 FE E6 F7 C5 FE E6 E5 C5 FD 10 3D ?? ?? ?? ?? C5 E5 59 D8 C5 ED 59 D1 C5 FD 11 B4 24 80 00 00 00 C5 E5 5C EF C5 ED 5C FF C5 FD 11 AC 24 A0 00 00 00 C5 FD 11 BC 24 C0 00 00 00 C5 D1 73 D0 28 C5 F9 7E E8 C4 E3 7D 19 C3 01 C4 E3 79 16 EA 02 C5 E1 73 D3 28 C5 F9 7E D9 C5 C1 73 D1 28 C4 E3 7D 19 CE 01 C5 E9 73 D6 28 C5 FB 10 B0 ?? ?? ?? ?? C4 E3 79 16 D8 02 C5 C9 16 B2 ?? ?? ?? ?? C5 F9 7E FA C5 FB 10 A9 ?? ?? ?? ?? C5 D1 16 98 ?? ?? ?? ?? C5 F9 7E D0 C5 FB 10 AA ?? ?? ?? ?? C4 E3 79 16 D2 02 C4 E3 79 16 F9 02 C4 E3 4D 18 F3 01 C5 FB 10 98 ?? ?? ?? ?? C5 E1 16 92 ?? ?? ?? ?? C5 FD 10 1D ?? ?? ?? ?? C5 D1 16 B9 ?? ?? ?? ?? C5 FD 10 2D ?? ?? ?? ?? C5 E5 C2 C0 11 C5 E5 C2 D9 11 C5 FD 54 CD C5 E5 54 C5 C5 FD 10 1D ?? ?? ?? ?? C5 FD 10 AC 24 A0 00 00 00 C5 F5 56 CB C5 DD 5C C9 C5 FD 10 A4 24 80 00 00 00 C5 FD 56 C3 C5 DD 5C D8 C4 E3 45 18 FA 01 C5 FD 10 15 ?? ?? ?? ?? C5 F5 59 E2 C5 E5 59 D2 C5 FD 10 0D ?? ?? ?? ?? C5 FD 10 1D ?? ?? ?? ?? C5 FD 11 A4 24 E0 00 00 00 C5 FD 11 94 24 00 01 00 00 C5 FD 10 94 24 C0 00 00 00 C5 F5 59 C5 C5 F5 59 E2 C5 FD 58 C3 C5 DD 58 CB C5 D5 59 DD C5 ED 59 E2 C5 FD 59 C3 C5 F5 59 CC C5 D5 58 E8 C5 ED 58 C1 C5 FD 10 0D ?? ?? ?? ?? C5 D5 58 F6 C5 FD 58 FF C5 CD 58 84 24 E0 00 00 00 C5 C5 58 B4 24 00 01 00 00 C5 FD 10 3D ?? ?? ?? ?? C5 FD 59 6C 24 40 C5 CD 59 54 24 60 C5 D5 59 E1 C5 ED 59 D9 C5 FD 11 A4 24 20 01 00 00 C5 FD 11 9C 24 40 01 00 00 C5 E5 5C CF C5 DD 5C E7 C5 FD 10 1D ?? ?? ?? ?? C5 DD 58 E3 C5 F5 58 FB C5 DD 5C CB C5 C5 5C DB C5 FD 11 A4 24 60 01 00 00 C5 FD 11 8C 24 A0 01 00 00 C5 FD 11 9C 24 C0 01 00 00 C5 F8 10 1D ?? ?? ?? ?? C5 FD 11 BC 24 80 01 00 00 C4 E3 7D 19 E8 01 C4 E3 7D 19 D6 01 C5 D0 C6 C0 DD C5 E8 C6 D6 DD C5 F8 10 35 ?? ?? ?? ?? C5 FA 6F AC 24 E0 01 00 00 C5 D1 66 CE C5 D1 76 E6 C5 FA 6F AC 24 00 02 00 00 C5 F1 EB E4 C5 D1 66 FB C5 D1 76 CB C5 C1 EB E9 C5 D9 EB CD C5 F8 10 2D ?? ?? ?? ?? C5 F8 10 25 ?? ?? ?? ?? C5 F8 54 C5 C5 F9 66 C4 C5 E8 54 D5 C5 F1 EB C8 C5 FA 6F 84 24 F0 01 00 00 C5 F9 66 FE C5 F9 76 F6 C5 C1 EB F6 C5 FA 6F BC 24 10 02 00 00 C5 C1 66 C3 C5 C1 76 DB C5 F9 EB C3 C5 C9 EB F0 C5 E9 66 C4 C5 C9 EB E0 C5 FD 10 AC 24 80 01 00 00 C5 E9 EF D2 C5 F1 6B CC C5 F1 63 DA C5 F9 10 0D ?? ?? ?? ?? C5 FD 10 A4 24 60 01 00 00 C5 F9 D7 C3 C5 D8 54 C1 C4 E3 7D 19 EE 01 C4 E3 7D 19 E7 01 C5 C8 54 D9 C5 F8 11 B4 24 40 02 00 00 C5 C0 54 D1 C5 F8 11 BC 24 20 02 00 00 C5 D9 73 D4 0B C5 FD 10 B4 24 20 01 00 00 C5 FD 10 BC 24 40 01 00 00 C5 F8 11 AC 24 30 02 00 00 C5 D0 54 E9 C5 F9 7E C1 C5 CD 5C 8C 24 A0 01 00 00 C5 C5 5C B4 24 C0 01 00 00 C5 FD 10 3D ?? ?? ?? ?? C4 E3 79 16 C2 02 C5 F5 59 CF C5 CD 59 F7 C5 FA 7E 3C CD ?? ?? ?? ?? C5 C1 16 3C D5 ?? ?? ?? ?? C5 F9 7E D1 C4 E3 79 16 D2 02 C5 FA 7E 04 CD ?? ?? ?? ?? C5 F9 7E E9 C5 F9 16 14 D5 ?? ?? ?? ?? C4 E3 79 16 EA 02 C5 FA 7E 04 CD ?? ?? ?? ?? C5 F9 7E D9 C5 F9 16 2C D5 ?? ?? ?? ?? C4 E3 79 16 DA 02 C4 E3 45 18 D2 01 C5 FA 7E 3C CD ?? ?? ?? ?? C5 C1 16 1C D5 ?? ?? ?? ?? C5 ED 59 C1 C5 FD 58 D2 C4 E3 55 18 DB 01 C5 E5 59 F6 C5 F8 10 AC 24 20 02 00 00 C5 C1 73 D5 0B C5 D1 73 F7 34 C5 CD 58 CB C5 E1 73 F4 34 C4 E3 7D 19 D0 01 C5 E9 D4 E3 C5 F9 D4 C5 C5 F8 10 94 24 30 02 00 00 C5 E1 73 D2 0B C5 F8 10 94 24 40 02 00 00 C5 C1 73 F3 34 C5 E1 73 D2 0B C4 E3 7D 19 CE 01 C4 E3 5D 18 C0 01 C5 D9 73 F3 34 C5 F1 D4 CF C5 C9 D4 F4 C5 FD 5A C0 C4 E3 75 18 CE 01 C5 FD 5A D1 C4 E3 7D 18 C2 01 84 C0 75 04 8B E5 5D C3 C5 FC 10 0C 24 C5 FC 10 54 24 20 C5 FC 11 84 24 C0 00 00 00 C5 FC 11 4C 24 40 C5 FC 11 94 24 80 00 00 00 85 C0 74 D5 33 D2 89 74 24 04 8B F2 89 3C 24 8B F8 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 84 24 C0 00 00 00 EB AB C5 F8 77 8D 8C B4 C0 00 00 00 8D 54 B4 40 8D 84 B4 80 00 00 00 51 50 52 E8 ?? ?? ?? ?? 83 C4 0C EB C6 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_59_3_0 {
	meta:
		name = "?__crtCompareStringA_stat@@YAHPAUlocaleinfo_struct@@PB_WKPBDH2HH@Z"
		size = 644
		refs = "0007 ___security_cookie 0035 ?strncnt@@YAHPBDH@Z 00b1 __imp__GetCPInfo@8 012b __imp__MultiByteToWideChar@24 0165 __alloca_probe_16 0179 _malloc 0255 ___crtCompareStringEx 0261 __freea 027c @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 8B 4D 1C 53 89 45 E0 8B 45 0C 56 8B 75 18 89 45 D4 8B 45 14 89 45 E4 89 4D DC 57 85 F6 7E 22 56 50 E8 ?? ?? ?? ?? 59 59 8B 4D DC 8B F0 8B 7D 20 85 FF 7E 19 57 51 E8 ?? ?? ?? ?? 59 59 8B F8 EB 11 83 FE FF 7D E7 33 C0 E9 10 02 00 00 83 FF FF 7C F4 8B 45 24 33 DB 89 5D D8 85 C0 75 0B 8B 45 E0 8B 00 8B 40 04 89 45 24 85 F6 74 08 85 FF 0F 85 96 00 00 00 3B F7 75 08 6A 02 58 E9 DC 01 00 00 83 FF 01 7E 08 33 C0 40 E9 CF 01 00 00 83 FE 01 7E 04 6A 03 EB E4 8D 4D E8 51 50 FF 15 ?? ?? ?? ?? 85 C0 74 A0 85 F6 7E 2B 83 7D E8 02 72 E3 8D 45 EE 38 5D EE 74 DB 8B 75 E4 8A 48 01 84 C9 74 D1 8A 16 3A 10 72 04 3A D1 76 AD 83 C0 02 38 18 75 E8 EB BE 85 FF 7E 32 83 7D E8 02 72 A7 8D 45 EE 38 5D EE 74 9F 8B 75 DC 8A 48 01 84 C9 74 95 8A 16 3A 10 72 08 3A D1 0F 86 7A FF FF FF 83 C0 02 38 18 75 E4 E9 7B FF FF FF 53 53 56 FF 75 E4 6A 09 FF 75 24 FF 15 ?? ?? ?? ?? 8B C8 89 4D E0 85 C9 0F 84 1D FF FF FF 7E 52 6A E0 33 D2 58 F7 F1 83 F8 02 72 46 03 C9 8D 41 08 3B C1 76 3A 8B 45 E0 8D 04 45 08 00 00 00 3D 00 04 00 00 77 13 E8 ?? ?? ?? ?? 8B DC 85 DB 74 1E C7 03 CC CC 00 00 EB 13 50 E8 ?? ?? ?? ?? 8B D8 59 85 DB 74 09 C7 03 DD DD 00 00 83 C3 08 8B 4D E0 85 DB 0F 84 C1 FE FF FF 51 53 56 FF 75 E4 8B 75 24 6A 01 56 FF 15 ?? ?? ?? ?? 85 C0 0F 84 B4 00 00 00 33 C0 50 50 57 FF 75 DC 6A 09 56 FF 15 ?? ?? ?? ?? 8B C8 89 4D E4 85 C9 0F 84 96 00 00 00 7E 57 6A E0 33 D2 58 F7 F1 83 F8 02 72 4B 03 C9 8D 41 08 3B C1 76 3F 8B 45 E4 8D 04 45 08 00 00 00 3D 00 04 00 00 77 13 E8 ?? ?? ?? ?? 8B F4 85 F6 74 1E C7 06 CC CC 00 00 EB 13 50 E8 ?? ?? ?? ?? 8B F0 59 85 F6 74 09 C7 06 DD DD 00 00 83 C6 08 8B 4D E4 EB 05 8B 4D E4 33 F6 85 F6 74 37 51 56 57 FF 75 DC 6A 01 FF 75 24 FF 15 ?? ?? ?? ?? 85 C0 74 1B 8B 45 E4 50 8B 45 E0 56 50 53 FF 75 10 FF 75 D4 E8 ?? ?? ?? ?? 83 C4 18 89 45 D8 56 E8 ?? ?? ?? ?? 59 53 E8 ?? ?? ?? ?? 8B 45 D8 59 8D 65 C8 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_59_4_0 {
	meta:
		name = "?strncnt@@YAHPBDH@Z"
		size = 32
		altNames = "___strncnt"
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B C8 8B 55 08 85 C0 74 0B 49 80 3A 00 74 06 42 85 C9 75 F5 49 2B C1 48 5D C3 }
	condition:
		$1
}

rule file_59_5_0 {
	meta:
		name = "__MallocaIsSizeInRange"
		size = 17
	strings:
		$1 = { 55 8B EC 8B 4D 08 8D 41 08 3B C8 1B C0 F7 D8 5D C3 }
	condition:
		$1
}

rule file_59_6_0 {
	meta:
		name = "__MarkAllocaS"
		size = 20
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 74 08 8B 4D 0C 89 08 83 C0 08 5D C3 }
	condition:
		$1
}

rule file_59_7_0 {
	meta:
		name = "___crtCompareStringA"
		size = 67
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002b ?__crtCompareStringA_stat@@YAHPAUlocaleinfo_struct@@PB_WKPBDH2HH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 08 8D 4D F0 E8 ?? ?? ?? ?? FF 75 24 8D 45 F0 FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C 50 E8 ?? ?? ?? ?? 83 C4 20 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "__lfind_s"
		size = 139
		refs = "000c __errno 0017 __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 57 33 FF 39 7D 08 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 3C 53 8B 5D 10 85 DB 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 1F 56 8B 75 0C 85 F6 75 1B 39 3B 74 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 5E 5B 5F 5D C3 39 7D 14 76 E4 39 7D 18 74 DF 39 3B 76 EB 56 FF 75 08 FF 75 1C FF 55 18 83 C4 0C 85 C0 74 0A 03 75 14 47 3B 3B 72 E7 EB D0 8B C6 EB CE }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "_asctime"
		size = 525
		refs = "0009 _buf 000e __getptd_noexit 0023 __calloc_crt 00b1 __days 0137 ___dnames 0140 ___mnames 01f5 __errno 0200 __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 85 F6 74 1B 83 7E 3C 00 75 12 6A 01 6A 1A E8 ?? ?? ?? ?? 89 46 3C 59 59 85 C0 74 03 8B 7E 3C 8B DF 85 FF 0F 84 B7 01 00 00 8B 75 08 C6 07 00 85 F6 0F 84 A9 01 00 00 8B 56 14 85 D2 0F 88 9E 01 00 00 8B 4E 10 85 C9 0F 88 93 01 00 00 83 F9 0B 0F 8F 8A 01 00 00 83 7E 08 00 0F 8C 80 01 00 00 83 7E 08 17 0F 8F 76 01 00 00 83 7E 04 00 0F 8C 6C 01 00 00 83 7E 04 3B 0F 8F 62 01 00 00 83 3E 00 0F 8C 59 01 00 00 83 3E 3B 0F 8F 50 01 00 00 83 7E 0C 01 0F 8C 46 01 00 00 8B 04 8D ?? ?? ?? ?? 2B 04 8D ?? ?? ?? ?? C7 45 F8 64 00 00 00 3B 46 0C 7D 4E 81 C2 6C 07 00 00 8B C2 89 55 FC 25 03 00 00 80 79 05 48 83 C8 FC 40 75 0D 8B C2 99 F7 7D F8 85 D2 75 18 8B 55 FC 8B C2 C7 45 FC 90 01 00 00 99 F7 7D FC 85 D2 0F 85 F1 00 00 00 83 F9 01 0F 85 E8 00 00 00 83 7E 0C 1D 0F 8F DE 00 00 00 8B 46 18 85 C0 0F 88 D3 00 00 00 83 F8 06 0F 8F CA 00 00 00 6B D0 03 6B C1 03 33 C9 8B F0 8A 84 0A ?? ?? ?? ?? 88 03 8A 84 0E ?? ?? ?? ?? 88 44 0F 04 41 43 83 F9 03 7C E5 8B 75 08 8D 4B 05 C6 03 20 C6 43 04 20 6A 0A 8B 46 0C 99 5B F7 FB 6A 30 89 5D FC 5B 02 C3 02 D3 88 01 88 51 01 C6 41 02 20 8B 46 08 99 F7 7D FC 6A 0A 02 C3 02 D3 88 41 03 88 51 04 C6 41 05 3A 8B 46 04 99 F7 7D FC 02 C3 02 D3 88 41 06 88 51 07 C6 41 08 3A 8B 06 99 F7 7D FC 02 C3 02 D3 88 41 09 88 51 0A C6 41 0B 20 8B 46 14 99 F7 7D F8 83 C0 13 99 F7 7D FC 02 C3 02 D3 88 41 0C 88 51 0D 8B 46 14 99 F7 7D F8 5E 8B C2 99 F7 FE 56 02 C3 02 D3 88 41 0E 58 88 51 0F 88 41 10 8B C7 C6 41 11 00 EB 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_61_1_0 {
	meta:
		name = "_asctime_s"
		size = 487
		refs = "009a __days 011a ___dnames 0123 ___mnames 01d0 __errno 01da __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 51 8B 4D 08 53 56 57 85 C9 0F 84 BD 01 00 00 83 7D 0C 00 0F 86 B3 01 00 00 83 7D 0C 1A C6 01 00 0F 82 A6 01 00 00 8B 75 10 85 F6 0F 84 9B 01 00 00 8B 5E 14 85 DB 0F 88 90 01 00 00 8B 7E 10 85 FF 0F 88 85 01 00 00 83 FF 0B 0F 8F 7C 01 00 00 83 7E 08 00 0F 8C 72 01 00 00 83 7E 08 17 0F 8F 68 01 00 00 83 7E 04 00 0F 8C 5E 01 00 00 83 7E 04 3B 0F 8F 54 01 00 00 83 3E 00 0F 8C 4B 01 00 00 83 3E 3B 0F 8F 42 01 00 00 83 7E 0C 01 0F 8C 38 01 00 00 8B 04 BD ?? ?? ?? ?? 2B 04 BD ?? ?? ?? ?? C7 45 08 64 00 00 00 3B 46 0C 7D 45 81 C3 6C 07 00 00 8B C3 25 03 00 00 80 79 05 48 83 C8 FC 40 75 0A 8B C3 99 F7 7D 08 85 D2 75 12 8B C3 BB 90 01 00 00 99 F7 FB 85 D2 0F 85 EC 00 00 00 83 FF 01 0F 85 E3 00 00 00 83 7E 0C 1D 0F 8F D9 00 00 00 8B 46 18 85 C0 0F 88 CE 00 00 00 83 F8 06 0F 8F C5 00 00 00 6B D8 03 8D 41 04 6B FF 03 8B F0 33 D2 8A 84 13 ?? ?? ?? ?? 88 01 8A 84 17 ?? ?? ?? ?? 88 04 16 42 41 83 FA 03 7C E6 8B 75 10 C6 01 20 C6 41 04 20 6A 0A 8B 46 0C 99 5B F7 FB 6A 30 5B 02 C3 02 D3 88 41 05 88 51 06 C6 41 07 20 8B 46 08 99 6A 0A 5F F7 FF 6A 64 02 C3 02 D3 88 41 08 88 51 09 C6 41 0A 3A 8B 46 04 99 F7 FF 02 C3 02 D3 88 41 0B 88 51 0C C6 41 0D 3A 8B 06 99 F7 FF 02 C3 02 D3 88 41 0E 88 51 0F C6 41 10 20 8B 46 14 99 F7 7D 08 83 C0 13 99 F7 FF 02 C3 02 D3 88 41 11 88 51 12 8B 46 14 99 5E F7 FE 57 8B C2 99 F7 FF 02 C3 02 D3 88 41 13 58 88 51 14 88 41 15 33 C0 C6 41 16 00 EB 11 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_61_2_0 {
	meta:
		name = "_store_dt"
		size = 30
	strings:
		$1 = { 55 8B EC 8B 45 0C 99 6A 0A 59 F7 F9 8B 4D 08 04 30 80 C2 30 88 01 8D 41 02 88 51 01 5D C3 }
	condition:
		$1
}

rule file_62_4_0 {
	meta:
		name = "__mbsstr_l"
		size = 226
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 _strstr 004d __errno 0058 __invalid_parameter_noinfo 0060 _strlen"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 56 57 FF 75 10 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 EC 33 DB 39 58 08 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 8B D8 E9 9A 00 00 00 8B 45 0C 85 C0 74 13 38 18 75 08 8B 5D 08 E9 87 00 00 00 8B 7D 08 85 FF 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 6E 50 E8 ?? ?? ?? ?? 8B F7 57 2B F0 E8 ?? ?? ?? ?? 03 C6 59 59 89 45 F8 38 1F 74 53 8B 55 0C 8B CF 8B 75 EC 2B CA 3B F8 77 45 8B C2 8A 17 88 55 FE 84 D2 8B 55 0C 74 14 8A 10 84 D2 74 2F 38 14 01 8B 55 0C 75 06 40 38 1C 01 75 EC 38 18 74 1D 0F B6 45 FE 47 41 8A 44 30 19 24 04 74 06 38 1F 74 0D 47 41 8B 45 F8 38 1F 75 BB EB 02 8B DF 80 7D F4 00 74 07 8B 4D F0 83 61 70 FD 5F 5E 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_63_2_0 {
	meta:
		name = "__chkesp"
		size = 24
	strings:
		$1 = { 75 01 C3 55 8B EC 83 EC 00 50 52 53 56 57 CC 5F 5E 5B 5A 58 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "_cbrtl"
		size = 260
		refs = "000f __ldunscale 0066 __ldscale 0087 __real@3fcf3482be8bc16a 008f __real@3feea8826aa8eb46 0097 __real@3fb43419e30014f9 009f __real@3fd1e54b48d3ae68 00a9 __real@3ff8000000000000 00af __real@3fe0000000000000"
	strings:
		$1 = { 55 8B EC 83 EC 10 8D 45 08 50 8D 45 FC 50 E8 ?? ?? ?? ?? 98 59 59 83 F8 02 77 08 DD 45 08 E9 DD 00 00 00 53 56 66 8B 75 FC 33 DB 0F BF CE 8B C1 C7 45 F8 03 00 00 00 99 F7 7D F8 57 6B C0 03 8B FB 3B C1 74 2B 4F 66 46 0F BF CE 8B C1 99 F7 7D F8 6B C0 03 3B C1 75 ED 66 89 75 FC 85 FF 79 10 8D 45 08 57 50 E8 ?? ?? ?? ?? 66 8B 75 FC 59 59 8B 45 0E DD 45 08 0F B7 C0 A9 00 80 00 00 74 05 33 DB D9 E0 43 DD 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D9 C1 DC 05 ?? ?? ?? ?? DE F9 D9 C1 DC 0D ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DC CB D9 C3 D8 F3 D9 C3 D8 CC DE C1 D9 C2 DE F1 DE C3 DC CA D9 CB D8 F2 D9 C2 D8 CB DE C1 DE F9 DE C1 DE C9 DD 55 F0 85 DB 74 07 D9 E0 DD 5D F0 EB 02 DD D8 0F BF C6 99 F7 7D F8 50 8D 45 F0 50 E8 ?? ?? ?? ?? DD 45 F0 59 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_1103_0_0 {
	meta:
		name = "_cbrt"
		size = 260
		refs = "000f __dunscale 0066 __dscale 0087 __real@3fcf3482be8bc16a 008f __real@3feea8826aa8eb46 0097 __real@3fb43419e30014f9 009f __real@3fd1e54b48d3ae68 00a9 __real@3ff8000000000000 00af __real@3fe0000000000000"
	strings:
		$1 = { 55 8B EC 83 EC 10 8D 45 08 50 8D 45 FC 50 E8 ?? ?? ?? ?? 98 59 59 83 F8 02 77 08 DD 45 08 E9 DD 00 00 00 53 56 66 8B 75 FC 33 DB 0F BF CE 8B C1 C7 45 F8 03 00 00 00 99 F7 7D F8 57 6B C0 03 8B FB 3B C1 74 2B 4F 66 46 0F BF CE 8B C1 99 F7 7D F8 6B C0 03 3B C1 75 ED 66 89 75 FC 85 FF 79 10 8D 45 08 57 50 E8 ?? ?? ?? ?? 66 8B 75 FC 59 59 8B 45 0E DD 45 08 0F B7 C0 A9 00 80 00 00 74 05 33 DB D9 E0 43 DD 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D9 C1 DC 05 ?? ?? ?? ?? DE F9 D9 C1 DC 0D ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DC CB D9 C3 D8 F3 D9 C3 D8 CC DE C1 D9 C2 DE F1 DE C3 DC CA D9 CB D8 F2 D9 C2 D8 CB DE C1 DE F9 DE C1 DE C9 DD 55 F0 85 DB 74 07 D9 E0 DD 5D F0 EB 02 DD D8 0F BF C6 99 F7 7D F8 50 8D 45 F0 50 E8 ?? ?? ?? ?? DD 45 F0 59 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_65_4_0 {
	meta:
		name = "__mbsnbset_l"
		size = 192
		refs = "0016 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002c __strnset 0043 __errno 004e __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 8B 75 08 8D 4D F0 57 FF 75 14 89 75 08 E8 ?? ?? ?? ?? 8B 45 F4 33 DB 39 58 08 75 13 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 8B D8 EB 73 8B 7D 10 85 F6 75 16 85 FF 74 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 56 8B 4D 0C 8B D1 C1 EA 08 84 D2 74 43 84 C9 75 2C E8 ?? ?? ?? ?? B2 20 8A CA C7 00 16 00 00 00 EB 1B 38 1E 74 2E 8D 47 FF 83 EF 02 85 C0 74 13 38 5E 01 74 0E 88 16 88 4E 01 83 C6 02 85 FF 75 E1 EB 11 C6 06 20 EB 0C 4F 38 1E 74 07 88 0E 46 85 FF 75 F4 8B 5D 08 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 5F 5E 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_3_0 {
	meta:
		name = "__INTRN_LOCALE_CONV"
		size = 16
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 00 8B 80 84 00 00 00 5D C3 }
	condition:
		$1
}

rule file_68_4_0 {
	meta:
		name = "___check_float_string"
		size = 95
		refs = "001d __calloc_crt 003e _memcpy 0049 __recalloc_crt"
	strings:
		$1 = { 55 8B EC 56 8B 75 0C 57 8B 06 39 45 08 75 49 8B 7D 10 6A 02 50 8B 0F 3B 4D 14 75 2B E8 ?? ?? ?? ?? 89 07 59 59 85 C0 75 04 33 C0 EB 2E 8B 45 18 C7 00 01 00 00 00 FF 36 FF 75 14 FF 37 E8 ?? ?? ?? ?? 83 C4 0C EB 0F 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 D5 89 07 D1 26 33 C0 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_68_5_0 {
	meta:
		name = "__cprinput_l"
		size = 4016
		refs = "000a ___security_cookie 0064 __errno 006f __invalid_parameter_noinfo 0086 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00b3 _isspace 00cb __whiteout 00d1 __un_inc 0157 _isdigit 0368 __getche_nolock 0499 ___check_float_string 073c __cfltcvt_tab 0742 __imp__DecodePointer@4 0867 _isleadbyte 08b7 __mbtowc_l 095f _memset 0c85 __allmul 0c98 _isxdigit 0cc6 __hextodec 0f7f _free 0fa8 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 00 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 10 53 8D 9D 7C FE FF FF 89 8D 14 FE FF FF 89 9D 54 FE FF FF 33 DB 57 8B 7D 08 8B C3 C7 85 20 FE FF FF 5E 01 00 00 89 9D 2C FE FF FF 89 9D 40 FE FF FF 89 9D 48 FE FF FF 89 9D 18 FE FF FF 89 85 68 FE FF FF 89 9D 10 FE FF FF 85 FF 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 25 0F 00 00 56 FF 75 0C 8D 8D 00 FE FF FF E8 ?? ?? ?? ?? 8A 07 8B F3 88 9D 78 FE FF FF 89 B5 6C FE FF FF 89 B5 60 FE FF FF 89 9D 30 FE FF FF 84 C0 0F 84 DC 0E 00 00 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 74 35 8D 85 60 FE FF FF 4E 50 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 47 0F B6 07 50 E8 ?? ?? ?? ?? 59 85 C0 75 F1 8B B5 60 FE FF FF E9 56 0E 00 00 8A 07 3C 25 0F 85 09 0E 00 00 38 47 01 0F 84 F6 0D 00 00 33 D2 C6 85 77 FE FF FF 01 89 95 34 FE FF FF 8B F2 88 95 2B FE FF FF 89 95 50 FE FF FF 89 95 4C FE FF FF 88 95 3B FE FF FF 88 95 5B FE FF FF 88 95 7A FE FF FF 88 95 7B FE FF FF 88 95 67 FE FF FF 88 95 79 FE FF FF 89 95 24 FE FF FF 47 0F B6 1F 53 E8 ?? ?? ?? ?? 59 85 C0 74 61 FF 85 4C FE FF FF 6B C6 0A 8D 73 D0 03 F0 8A 8D 7A FE FF FF 8A 85 7B FE FF FF 8A 95 79 FE FF FF 84 C0 74 CD 89 B5 70 FE FF FF 8B B5 6C FE FF FF 89 BD 44 FE FF FF 84 C9 0F 85 57 01 00 00 8B 85 14 FE FF FF 89 85 10 FE FF FF 83 C0 04 89 85 14 FE FF FF 8B 48 FC 89 8D 3C FE FF FF E9 3B 01 00 00 83 FB 4E 0F 8F A2 00 00 00 74 A2 83 FB 2A 0F 84 84 00 00 00 83 FB 46 74 94 83 FB 49 74 14 83 FB 4C 0F 85 93 00 00 00 FE 85 77 FE FF FF E9 7B FF FF FF 8A 47 01 3C 36 75 23 8D 4F 02 80 39 34 75 1B 8B F9 FF 85 24 FE FF FF 83 A5 40 FE FF FF 00 83 A5 48 FE FF FF 00 E9 51 FF FF FF 3C 33 75 0F 8D 4F 02 80 39 32 75 07 8B F9 E9 3E FF FF FF 3C 64 0F 84 36 FF FF FF 3C 69 0F 84 9E 00 00 00 3C 6F 0F 84 26 FF FF FF 3C 78 0F 84 1E FF FF FF 3C 58 75 27 E9 15 FF FF FF 8A 8D 7A FE FF FF FE C1 88 8D 7A FE FF FF E9 08 FF FF FF 83 FB 68 74 57 83 FB 6C 74 1E 83 FB 77 74 2E 8A 85 7B FE FF FF 8A 8D 7A FE FF FF FE C0 88 85 7B FE FF FF E9 E6 FE FF FF 8D 47 01 80 38 6C 75 07 8B F8 E9 61 FF FF FF FE 85 77 FE FF FF 8A 95 79 FE FF FF 8A 85 7B FE FF FF FE C2 8A 8D 7A FE FF FF 88 95 79 FE FF FF E9 B8 FE FF FF 8A 95 79 FE FF FF FE 8D 77 FE FF FF FE CA 88 95 79 FE FF FF EB 06 8A 95 79 FE FF FF 8A 8D 7A FE FF FF 8A 85 7B FE FF FF E9 8B FE FF FF 83 A5 3C FE FF FF 00 32 C0 88 85 7B FE FF FF 84 D2 75 18 8A 07 3C 53 74 0B C6 85 79 FE FF FF FF 3C 43 75 07 C6 85 79 FE FF FF 01 0F B6 0F 83 C9 20 89 8D 5C FE FF FF 83 F9 6E 0F 84 B4 00 00 00 83 F9 63 74 20 83 F9 7B 74 1B 8D 85 60 FE FF FF 50 E8 ?? ?? ?? ?? 8B B5 60 FE FF FF 59 89 B5 6C FE FF FF EB 12 46 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF 83 FB FF 0F 84 F2 0B 00 00 8B 8D 5C FE FF FF 8B 85 4C FE FF FF 8B 95 70 FE FF FF 85 C0 74 08 85 D2 0F 84 CD 0B 00 00 83 F9 6F 0F 8F 38 05 00 00 0F 84 84 08 00 00 83 F9 63 0F 84 B8 03 00 00 83 F9 64 0F 84 72 08 00 00 0F 8E 44 05 00 00 83 F9 67 7E 38 83 F9 69 74 25 83 F9 6E 0F 85 31 05 00 00 80 BD 7A FE FF FF 00 8B C6 0F 84 D2 0A 00 00 E9 68 03 00 00 8B 9D 68 FE FF FF EB 92 6A 64 5F 89 BD 5C FE FF FF E9 1E 06 00 00 33 F6 83 FB 2D 75 0B 8B 85 54 FE FF FF 46 88 18 EB 05 83 FB 2B 75 23 8B BD 6C FE FF FF 4A 89 95 70 FE FF FF 47 E8 ?? ?? ?? ?? 8B D8 8B 85 4C FE FF FF 89 9D 68 FE FF FF EB 06 8B BD 6C FE FF FF 85 C0 75 07 83 8D 70 FE FF FF FF 0F B6 C3 50 E8 ?? ?? ?? ?? 59 8B 8D 70 FE FF FF 85 C0 74 5A 8B C1 49 89 8D 70 FE FF FF 85 C0 74 4D 8B 85 54 FE FF FF FF 85 50 FE FF FF 88 1C 06 8D 85 2C FE FF FF 50 8D 85 7C FE FF FF 46 50 8D 85 54 FE FF FF 50 8D 85 20 FE FF FF 50 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 C7 0A 00 00 47 E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF EB 92 8B 85 00 FE FF FF 8B 80 84 00 00 00 8B 00 8A 18 8B 85 68 FE FF FF 3A D8 0F 85 CA 00 00 00 8B C1 49 89 8D 70 FE FF FF 85 C0 0F 84 B9 00 00 00 47 E8 ?? ?? ?? ?? 89 85 68 FE FF FF 8B 85 54 FE FF FF 88 1C 06 8D 85 2C FE FF FF 50 8D 85 7C FE FF FF 46 50 8D 85 54 FE FF FF 50 8D 85 20 FE FF FF 50 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 45 0A 00 00 8B 9D 68 FE FF FF EB 5E 8B 8D 70 FE FF FF 8B C1 49 89 8D 70 FE FF FF 85 C0 74 61 8B 85 54 FE FF FF FF 85 50 FE FF FF 88 1C 06 8D 85 2C FE FF FF 50 8D 85 7C FE FF FF 46 50 8D 85 54 FE FF FF 50 8D 85 20 FE FF FF 50 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 ED 09 00 00 47 E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 75 94 EB 06 8B 9D 68 FE FF FF 83 BD 50 FE FF FF 00 0F 84 35 01 00 00 83 FB 65 74 09 83 FB 45 0F 85 27 01 00 00 8B 8D 70 FE FF FF 8B C1 49 89 8D 70 FE FF FF 85 C0 0F 84 10 01 00 00 8B 85 54 FE FF FF C6 04 06 65 8D 85 2C FE FF FF 50 8D 85 7C FE FF FF 46 50 8D 85 54 FE FF FF 50 8D 85 20 FE FF FF 50 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 5F 09 00 00 47 E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF 83 FB 2D 75 39 8B 85 54 FE FF FF 88 1C 06 8D 85 2C FE FF FF 50 8D 85 7C FE FF FF 46 50 8D 85 54 FE FF FF 50 8D 85 20 FE FF FF 50 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 15 09 00 00 EB 05 83 FB 2B 75 79 8B 8D 70 FE FF FF 8B C1 49 89 8D 70 FE FF FF 85 C0 75 58 21 85 70 FE FF FF EB 5E 8B 8D 70 FE FF FF 8B C1 49 89 8D 70 FE FF FF 85 C0 74 59 8B 85 54 FE FF FF FF 85 50 FE FF FF 88 1C 06 8D 85 2C FE FF FF 50 8D 85 7C FE FF FF 46 50 8D 85 54 FE FF FF 50 8D 85 20 FE FF FF 50 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 A3 08 00 00 47 E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 75 94 4F 53 89 BD 6C FE FF FF 89 BD 60 FE FF FF E8 ?? ?? ?? ?? 83 BD 50 FE FF FF 00 59 0F 84 66 08 00 00 80 BD 7A FE FF FF 00 75 39 8B 85 54 FE FF FF 8D 8D 00 FE FF FF FF 85 30 FE FF FF 51 8B 8D 3C FE FF FF 50 C6 04 06 00 0F BE 85 77 FE FF FF 51 48 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 83 C4 10 8B BD 44 FE FF FF 8A 85 78 FE FF FF 8B B5 6C FE FF FF FE C0 88 85 78 FE FF FF 47 E9 E2 07 00 00 85 C0 75 11 42 C7 85 4C FE FF FF 01 00 00 00 89 95 70 FE FF FF 8A 85 79 FE FF FF 84 C0 7E 07 C6 85 67 FE FF FF 01 8B 9D 6C FE FF FF 8B 85 68 FE FF FF 4B 8B B5 3C FE FF FF 50 89 9D 6C FE FF FF 89 9D 60 FE FF FF E8 ?? ?? ?? ?? 8B BD 5C FE FF FF 59 83 BD 4C FE FF FF 00 74 17 8B 8D 70 FE FF FF 8B C1 49 89 8D 70 FE FF FF 85 C0 0F 84 F9 03 00 00 43 89 9D 6C FE FF FF 89 9D 60 FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF 83 FF 63 74 46 83 FF 73 75 13 83 FB 09 7C 09 83 FB 0D 0F 8E AD 03 00 00 83 FB 20 75 2E 83 FF 7B 0F 85 9F 03 00 00 33 D2 8B C3 C1 F8 03 8B CB 83 E1 07 42 D3 E2 0F BE 4C 05 DC 0F BE 85 3B FE FF FF 33 C8 85 D1 0F 84 7A 03 00 00 80 BD 7A FE FF FF 00 0F 85 61 03 00 00 80 BD 67 FE FF FF 00 0F 84 43 03 00 00 0F B6 C3 50 88 9D 1C FE FF FF E8 ?? ?? ?? ?? 8B 9D 6C FE FF FF 59 85 C0 74 18 43 89 9D 6C FE FF FF 89 9D 60 FE FF FF E8 ?? ?? ?? ?? 88 85 1D FE FF FF 8D 85 00 FE FF FF C7 85 18 FE FF FF 3F 00 00 00 50 8B 85 00 FE FF FF FF 70 74 8D 85 1C FE FF FF 50 8D 85 18 FE FF FF 50 E8 ?? ?? ?? ?? 8B 8D 3C FE FF FF 83 C4 10 66 8B 85 18 FE FF FF 66 89 01 83 C1 02 89 8D 3C FE FF FF E9 E1 FE FF FF 8B C1 83 E8 70 0F 84 3A 03 00 00 83 E8 03 0F 84 90 FE FF FF 48 48 0F 84 30 03 00 00 83 E8 03 0F 84 10 01 00 00 83 E8 03 74 31 0F B6 07 3B C3 0F 85 57 06 00 00 8A 85 78 FE FF FF FE C8 80 BD 7A FE FF FF 00 0F 85 31 FE FF FF 8B 8D 10 FE FF FF 89 8D 14 FE FF FF E9 20 FE FF FF 8A 85 79 FE FF FF 84 C0 7E 07 C6 85 67 FE FF FF 01 47 80 3F 5E 75 08 47 C6 85 3B FE FF FF FF 6A 20 8D 45 DC 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C 80 3F 5D 75 0C B4 5D C6 45 E7 20 47 E9 81 00 00 00 8A A5 2B FE FF FF EB 79 47 3C 2D 75 5F 84 E4 74 5B 8A 0F 80 F9 5D 74 54 47 89 BD 44 FE FF FF 3A E1 73 04 8A D9 EB 04 8A DC 8A E1 3A E3 73 26 8A C3 0F B6 F4 2A C4 0F B6 F8 8B D6 8B CE C1 EA 03 83 E1 07 B0 01 D2 E0 08 44 15 DC 46 4F 75 EA 8B BD 44 FE FF FF 0F B6 CB B0 01 8B D1 83 E1 07 C1 EA 03 D2 E0 08 44 15 DC 32 E4 EB 15 0F B6 C8 8A E0 8B D1 B0 01 C1 EA 03 83 E1 07 D2 E0 08 44 15 DC 8A 07 3C 5D 75 81 84 C0 0F 84 69 05 00 00 89 BD 44 FE FF FF E9 80 FD FF FF 8B BD 5C FE FF FF 8B 85 4C FE FF FF 83 FB 2D 75 09 C6 85 5B FE FF FF 01 EB 05 83 FB 2B 75 31 4A 89 95 70 FE FF FF 75 0E 85 C0 74 0A B0 01 88 85 7B FE FF FF EB 1A 46 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF 83 FB 30 75 7A 46 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF 80 FB 78 0F 84 D2 00 00 00 80 FB 58 0F 84 C9 00 00 00 C7 85 50 FE FF FF 01 00 00 00 83 FF 78 74 22 83 BD 4C FE FF FF 00 74 0E FF 8D 70 FE FF FF 75 06 FE 85 7B FE FF FF 6A 6F 59 89 8D 5C FE FF FF EB 23 4E 53 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 59 6A 30 5B 89 9D 68 FE FF FF 8B 8D 5C FE FF FF 8A 85 7B FE FF FF 83 BD 24 FE FF FF 00 0F 84 8F 02 00 00 84 C0 0F 85 50 02 00 00 83 F9 78 0F 84 89 01 00 00 83 F9 70 0F 84 80 01 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 8B BD 5C FE FF FF 59 85 C0 0F 84 10 02 00 00 83 FF 6F 0F 85 3E 01 00 00 83 FB 38 0F 8D FE 01 00 00 8B 85 48 FE FF FF 8B 8D 40 FE FF FF 0F A4 C8 03 89 85 48 FE FF FF C1 E1 03 E9 84 01 00 00 46 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 83 BD 4C FE FF FF 00 8B D8 89 9D 68 FE FF FF 74 1A 8B 85 70 FE FF FF 83 E8 02 89 85 70 FE FF FF 83 F8 01 7D 06 FE 85 7B FE FF FF 6A 78 E9 1B FF FF FF 8B 85 3C FE FF FF 88 18 40 89 85 3C FE FF FF EB 01 46 8B 9D 6C FE FF FF E9 01 FC FF FF 8B 85 6C FE FF FF 48 53 89 85 6C FE FF FF 89 85 60 FE FF FF E8 ?? ?? ?? ?? 59 8B 85 3C FE FF FF 3B F0 0F 84 8B 03 00 00 80 BD 7A FE FF FF 00 0F 85 5A FB FF FF FF 85 30 FE FF FF 83 FF 63 0F 84 4B FB FF FF 80 BD 67 FE FF FF 00 8B BD 44 FE FF FF 74 0A 33 C9 66 89 08 E9 38 FB FF FF C6 00 00 E9 30 FB FF FF C6 85 77 FE FF FF 01 8B 85 4C FE FF FF 83 FB 2D 75 09 C6 85 5B FE FF FF 01 EB 09 83 FB 2B 0F 85 A1 FE FF FF 4A 89 95 70 FE FF FF 75 0B 85 C0 74 07 B0 01 E9 93 FE FF FF 46 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 8B D8 E9 68 FE FF FF 8B 8D 48 FE FF FF 6A 00 6A 0A 51 8B 8D 40 FE FF FF 51 E8 ?? ?? ?? ?? 8B C8 89 95 48 FE FF FF EB 4C 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 90 00 00 00 8B 85 40 FE FF FF 8B 8D 48 FE FF FF 0F A4 C1 04 53 C1 E0 04 89 8D 48 FE FF FF 89 85 40 FE FF FF E8 ?? ?? ?? ?? 8B BD 5C FE FF FF 8B D8 59 8B 8D 40 FE FF FF 89 9D 68 FE FF FF FF 85 50 FE FF FF 8D 43 D0 99 03 C8 8B 85 48 FE FF FF 89 8D 40 FE FF FF 13 C2 83 BD 4C FE FF FF 00 89 85 48 FE FF FF 74 08 FF 8D 70 FE FF FF 74 53 46 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 8B 8D 5C FE FF FF 8B D8 89 9D 68 FE FF FF E9 CC FD FF FF 8B BD 5C FE FF FF 4E 53 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 59 EB 06 8B BD 5C FE FF FF 8B 85 48 FE FF FF 8B 8D 40 FE FF FF 80 BD 5B FE FF FF 00 0F 84 14 01 00 00 F7 D9 89 8D 40 FE FF FF 83 D0 00 F7 D8 89 85 48 FE FF FF E9 FC 00 00 00 84 C0 0F 85 D7 00 00 00 83 F9 78 74 3F 83 F9 70 74 3A 0F B6 C3 50 E8 ?? ?? ?? ?? 8B BD 5C FE FF FF 59 85 C0 0F 84 9F 00 00 00 83 FF 6F 75 14 83 FB 38 0F 8D 91 00 00 00 8B 85 34 FE FF FF C1 E0 03 EB 39 6B 85 34 FE FF FF 0A EB 30 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 69 C1 A5 34 FE FF FF 04 53 E8 ?? ?? ?? ?? 8B BD 5C FE FF FF 8B D8 8B 85 34 FE FF FF 59 89 9D 68 FE FF FF FF 85 50 FE FF FF 83 C0 D0 03 C3 83 BD 4C FE FF FF 00 89 85 34 FE FF FF 74 08 FF 8D 70 FE FF FF 74 4D 46 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 8B 8D 5C FE FF FF 8B D8 89 9D 68 FE FF FF E9 45 FF FF FF 8B BD 5C FE FF FF 4E 53 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 59 EB 06 8B BD 5C FE FF FF 8B 85 34 FE FF FF 80 BD 5B FE FF FF 00 74 08 F7 D8 89 85 34 FE FF FF 83 EF 46 F7 DF 1B FF 23 BD 50 FE FF FF 0F 84 D8 00 00 00 80 BD 7A FE FF FF 00 0F 85 A7 F8 FF FF FF 85 30 FE FF FF 8B BD 44 FE FF FF 8B 85 34 FE FF FF 83 BD 24 FE FF FF 00 74 1C 8B 85 3C FE FF FF 8B 8D 40 FE FF FF 89 08 8B 8D 48 FE FF FF 89 48 04 E9 76 F8 FF FF 8A 8D 77 FE FF FF 84 C9 8B 8D 3C FE FF FF 74 07 89 01 E9 5F F8 FF FF 66 89 01 E9 57 F8 FF FF 3C 25 75 06 38 47 01 75 01 47 46 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 8B D8 0F B6 07 47 89 9D 68 FE FF FF 3B C3 75 42 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 19 E8 ?? ?? ?? ?? 0F B6 0F 47 3B C8 75 18 89 B5 60 FE FF FF 89 B5 6C FE FF FF 8A 07 84 C0 0F 85 57 F1 FF FF EB 16 50 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 59 EB 06 53 E8 ?? ?? ?? ?? 59 83 BD 2C FE FF FF 01 75 0C FF B5 54 FE FF FF E8 ?? ?? ?? ?? 59 8B 9D 30 FE FF FF 80 BD 0C FE FF FF 00 5E 74 0A 8B 8D 08 FE FF FF 83 61 70 FD 8B C3 8B 4D FC 5F 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_6_0 {
	meta:
		name = "__cscanf"
		size = 22
		refs = "000d __cprinput_l"
		altNames = "__cwscanf"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1395_3_0 {
	meta:
		name = "__cprintf"
		size = 22
		refs = "000d __vcprintf_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_585_3_0 {
	meta:
		name = "__cprintf_p"
		size = 22
		refs = "000d __vcprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_358_3_0 {
	meta:
		name = "__cprintf_s"
		size = 22
		refs = "000d __vcprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_849_6_0 {
	meta:
		name = "__cscanf_s"
		size = 22
		refs = "000d __cprinput_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_736_3_0 {
	meta:
		name = "__cwprintf"
		size = 22
		refs = "000d __vcwprintf_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_990_3_0 {
	meta:
		name = "__cwprintf_p"
		size = 22
		refs = "000d __vcwprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_807_3_0 {
	meta:
		name = "__cwprintf_s"
		size = 22
		refs = "000d __vcwprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_87_6_0 {
	meta:
		name = "__cwscanf_s"
		size = 22
		refs = "000d __cprinput_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_184_2_0 {
	meta:
		name = "__printf_p"
		size = 22
		refs = "000d __vprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1198_1_0 {
	meta:
		name = "__wprintf_p"
		size = 22
		refs = "000d __vwprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_184_7_0 {
	meta:
		name = "_printf_s"
		size = 22
		refs = "000d __vprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1198_5_0 {
	meta:
		name = "_wprintf_s"
		size = 22
		refs = "000d __vwprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_68_7_0 {
	meta:
		name = "__cscanf_l"
		size = 23
		refs = "000e __cprinput_l"
		altNames = "__cwscanf_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1395_4_0 {
	meta:
		name = "__cprintf_l"
		size = 23
		refs = "000e __vcprintf_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_585_4_0 {
	meta:
		name = "__cprintf_p_l"
		size = 23
		refs = "000e __vcprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_358_4_0 {
	meta:
		name = "__cprintf_s_l"
		size = 23
		refs = "000e __vcprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_849_7_0 {
	meta:
		name = "__cscanf_s_l"
		size = 23
		refs = "000e __cprinput_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_736_4_0 {
	meta:
		name = "__cwprintf_l"
		size = 23
		refs = "000e __vcwprintf_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_990_4_0 {
	meta:
		name = "__cwprintf_p_l"
		size = 23
		refs = "000e __vcwprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_807_4_0 {
	meta:
		name = "__cwprintf_s_l"
		size = 23
		refs = "000e __vcwprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_87_7_0 {
	meta:
		name = "__cwscanf_s_l"
		size = 23
		refs = "000e __cprinput_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_184_1_0 {
	meta:
		name = "__printf_l"
		size = 23
		refs = "000e __vprintf_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_184_3_0 {
	meta:
		name = "__printf_p_l"
		size = 23
		refs = "000e __vprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_184_4_0 {
	meta:
		name = "__printf_s_l"
		size = 23
		refs = "000e __vprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1252_1_0 {
	meta:
		name = "__scprintf_l"
		size = 23
		refs = "000e __vscprintf_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1252_3_0 {
	meta:
		name = "__scprintf_p_l"
		size = 23
		refs = "000e __vscprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_970_2_0 {
	meta:
		name = "__scwprintf_l"
		size = 23
		refs = "000e __vscwprintf_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_970_4_0 {
	meta:
		name = "__scwprintf_p_l"
		size = 23
		refs = "000e __vscwprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1198_0_0 {
	meta:
		name = "__wprintf_l"
		size = 23
		refs = "000e __vwprintf_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1198_2_0 {
	meta:
		name = "__wprintf_p_l"
		size = 23
		refs = "000e __vwprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1198_3_0 {
	meta:
		name = "__wprintf_s_l"
		size = 23
		refs = "000e __vwprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_68_8_0 {
	meta:
		name = "__hextodec"
		size = 33
		refs = "000c _isdigit"
	strings:
		$1 = { 55 8B EC 53 8A 5D 08 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 0F BE C3 59 75 06 83 E0 DF 83 E8 07 5B 5D C3 }
	condition:
		$1
}

rule file_68_10_0 {
	meta:
		name = "__un_inc"
		size = 17
		refs = "000b __ungetch_nolock"
	strings:
		$1 = { 55 8B EC 83 7D 08 FF 74 06 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_560_8_0 {
	meta:
		name = "__un_inc"
		size = 17
		refs = "000b __ungetc_nolock"
	strings:
		$1 = { 55 8B EC 83 7D 08 FF 74 06 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_68_11_0 {
	meta:
		name = "__whiteout"
		size = 42
		refs = "000b __getche_nolock 001b _isspace"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 FF 06 E8 ?? ?? ?? ?? 8B D8 83 FB FF 74 0E 0F B6 CB 51 E8 ?? ?? ?? ?? 59 85 C0 75 E4 5E 8B C3 5B 5D C3 }
	condition:
		$1
}

rule file_69_12_0 {
	meta:
		name = "??0?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z"
		size = 51
		refs = "0010 ??_7?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@6B@ 0020 __imp__InitializeSListHead@4"
	strings:
		$1 = { 55 8B EC 8B 45 08 53 56 57 8B F9 6A 03 5B C7 07 ?? ?? ?? ?? 8D 77 08 8B 40 08 89 47 04 56 FF 15 ?? ?? ?? ?? 83 C6 08 4B 79 F3 8B C7 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_69_13_0 {
	meta:
		name = "??0?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z"
		size = 51
		refs = "0010 ??_7?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@6B@ 0020 __imp__InitializeSListHead@4"
	strings:
		$1 = { 55 8B EC 8B 45 08 53 56 57 8B F9 6A 03 5B C7 07 ?? ?? ?? ?? 8D 77 08 8B 40 08 89 47 04 56 FF 15 ?? ?? ?? ?? 83 C6 08 4B 79 F3 8B C7 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_69_14_0 {
	meta:
		name = "??0FreeThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@I@Z"
		size = 49
		refs = "000e ??0ThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@I@Z 0014 ??_7FreeThreadProxy@details@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 57 FF 75 0C 8B F1 FF 75 08 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8D 7E 30 33 C0 AB AB AB 33 C0 21 46 30 66 89 46 34 8B C6 5F 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_69_15_0 {
	meta:
		name = "??0FreeThreadProxyFactory@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z"
		size = 38
		refs = "000a ??0?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z 0010 ??_7FreeThreadProxyFactory@details@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 C7 46 28 01 00 00 00 C6 46 2C 00 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_69_16_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QAE@XZ"
		size = 20
	strings:
		$1 = { 57 33 C0 8B F9 AB AB AB 33 C0 21 01 66 89 41 04 8B C1 5F C3 }
	condition:
		$1
}

rule file_69_18_0 {
	meta:
		name = "??0ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ"
		size = 52
		refs = "0003 __ehhandler$??0ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ 0008 __EH_prolog3 001c ??0_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ 0025 ?__TlsAlloc@platform@details@Concurrency@@YAKXZ 002f __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 83 26 00 8D 4E 0C 83 66 04 00 E8 ?? ?? ?? ?? 83 65 FC 00 E8 ?? ?? ?? ?? 89 46 08 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_69_22_0 {
	meta:
		name = "??0UMSFreeThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@PAXI@Z"
		size = 70
		refs = "0011 ??0UMSThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@PAXI@Z 001d ??_7UMSFreeThreadProxy@details@Concurrency@@6BUMSBaseObject@12@@ 0024 ??_7UMSFreeThreadProxy@details@Concurrency@@6BIUMSThreadProxy@2@@ 002d ??_7UMSFreeThreadProxy@details@Concurrency@@6BIUMSUnblockNotification@2@@"
	strings:
		$1 = { 55 8B EC 56 57 FF 75 10 8B F1 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8D 8E B0 00 00 00 C7 06 ?? ?? ?? ?? C7 46 04 ?? ?? ?? ?? 33 C0 C7 46 08 ?? ?? ?? ?? 8B F9 AB AB AB 33 C0 21 01 66 89 41 04 8B C6 5F 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_69_23_0 {
	meta:
		name = "??0UMSFreeThreadProxyFactory@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z"
		size = 178
		refs = "0003 __ehhandler$??0UMSFreeThreadProxyFactory@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z 0008 __EH_prolog3 0015 ??0?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z 001d ??_7UMSFreeThreadProxyFactory@details@Concurrency@@6B@ 0028 ??0Transmogrificator@details@Concurrency@@QAE@XZ 003a ?CreateUmsCompletionList@UMS@details@Concurrency@@SAHPAPAX@Z 0045 __imp__GetLastError@0 005a ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 005f __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0068 __CxxThrowException@8 0073 ?GetUmsCompletionListEvent@UMS@details@Concurrency@@SAHPAXPAPAX@Z 008c ??2@YAPAXI@Z 009f ??0TransmogrifiedPrimary@details@Concurrency@@QAE@XZ 00ab __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 FF 75 08 E8 ?? ?? ?? ?? 33 FF C7 06 ?? ?? ?? ?? 8D 4E 30 89 7D FC E8 ?? ?? ?? ?? 8D 5E 58 C6 45 FC 01 53 89 3B 89 7E 5C E8 ?? ?? ?? ?? 59 85 C0 75 29 FF 15 ?? ?? ?? ?? 85 C0 7E 08 0F B7 C0 0D 00 00 07 80 50 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8D 46 5C 50 FF 33 E8 ?? ?? ?? ?? 59 59 85 C0 75 0C FF 15 ?? ?? ?? ?? 85 C0 7E CE EB C4 6A 44 E8 ?? ?? ?? ?? 59 89 45 08 C6 45 FC 02 85 C0 74 09 8B C8 E8 ?? ?? ?? ?? 8B F8 89 7E 28 8B C6 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_69_27_0 {
	meta:
		name = "__ehhandler$??0UMSFreeThreadProxyFactory@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSFreeThreadProxyFactory@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_15_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$codecvt@DDH@std@@@std@@YAABV?$codecvt@DDH@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$codecvt@DDH@std@@@std@@YAABV?$codecvt@DDH@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_19_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$codecvt@GDH@std@@@std@@YAABV?$codecvt@GDH@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$codecvt@GDH@std@@@std@@YAABV?$codecvt@GDH@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_19_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$codecvt@_WDH@std@@@std@@YAABV?$codecvt@_WDH@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$codecvt@_WDH@std@@@std@@YAABV?$codecvt@_WDH@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_119_35_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$collate@D@std@@@std@@YAABV?$collate@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$collate@D@std@@@std@@YAABV?$collate@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_94_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_97_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_28_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_33_22_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_112_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_119_41_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$messages@D@std@@@std@@YAABV?$messages@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$messages@D@std@@@std@@YAABV?$messages@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_115_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_118_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_119_44_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_121_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_124_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_119_47_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_127_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_121_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_119_50_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@D$00@std@@@std@@YAABV?$moneypunct@D$00@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@D$00@std@@@std@@YAABV?$moneypunct@D$00@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_60_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAABV?$moneypunct@D$0A@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAABV?$moneypunct@D$0A@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_133_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_136_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_139_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_142_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_35_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_145_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_148_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_34_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_142_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_145_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_37_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_148_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_151_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_63_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_163_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_166_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_119_59_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_160_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_172_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1316_26_0 {
	meta:
		name = "__ehhandler$??0ResourceManager@details@Concurrency@@AAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ResourceManager@details@Concurrency@@AAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1139_16_0 {
	meta:
		name = "__ehhandler$??0SchedulingRing@details@Concurrency@@QAE@PAVSchedulerBase@12@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0SchedulingRing@details@Concurrency@@QAE@PAVSchedulerBase@12@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1324_21_0 {
	meta:
		name = "__ehhandler$??0UMSFreeVirtualProcessorRoot@details@Concurrency@@QAE@PAVUMSSchedulerProxy@12@PAUSchedulerNode@12@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSFreeVirtualProcessorRoot@details@Concurrency@@QAE@PAVUMSSchedulerProxy@12@PAUSchedulerNode@12@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_600_174_0 {
	meta:
		name = "__ehhandler$?AllocateSegment@FairScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AllocateSegment@FairScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_495_122_0 {
	meta:
		name = "__ehhandler$?DemandInitialize@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DemandInitialize@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_600_326_0 {
	meta:
		name = "__ehhandler$?InternalCreateScheduleGroup@SchedulerBase@details@Concurrency@@AAEPAVScheduleGroup@3@PAVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?InternalCreateScheduleGroup@SchedulerBase@details@Concurrency@@AAEPAVScheduleGroup@3@PAVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_600_417_0 {
	meta:
		name = "__ehhandler$?SetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXABVSchedulerPolicy@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?SetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXABVSchedulerPolicy@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_544_107_0 {
	meta:
		name = "__ehhandler$?_InitBadAllocException@__ExceptionPtr@@CA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_InitBadAllocException@__ExceptionPtr@@CA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_115_131_2 {
	meta:
		name = "__ehhandler$?_Internal_grow@_Concurrent_vector_base_v4@details@Concurrency@@IAEXIIIP6AXPAXPBXI@Z1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Internal_grow@_Concurrent_vector_base_v4@details@Concurrency@@IAEXIIIP6AXPAXPBXI@Z1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_115_138_2 {
	meta:
		name = "__ehhandler$?_Internal_reserve@_Concurrent_vector_base_v4@details@Concurrency@@IAEXIII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Internal_reserve@_Concurrent_vector_base_v4@details@Concurrency@@IAEXIII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_435_240_0 {
	meta:
		name = "__ehhandler$?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_435_243_0 {
	meta:
		name = "__ehhandler$?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@PAVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@PAVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1016_55_0 {
	meta:
		name = "__ehhandler$?wait@Concurrency@@YAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?wait@Concurrency@@YAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_28_0 {
	meta:
		name = "??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 23
		refs = "000c ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_14_0 {
	meta:
		name = "??0ScopedCriticalRegion@ContextBase@details@Concurrency@@QAE@PAV123@@Z"
		size = 23
		refs = "000c ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_190_29_0 {
	meta:
		name = "??0_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 23
		refs = "000c ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_18_0 {
	meta:
		name = "??0_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 23
		refs = "000c ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1316_32_0 {
	meta:
		name = "??0_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 23
		refs = "000c ?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_600_67_0 {
	meta:
		name = "??0_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 23
		refs = "000c ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1050_18_0 {
	meta:
		name = "??0_Scoped_lock@_ReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 23
		refs = "000c ?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1042_39_0 {
	meta:
		name = "??0scoped_lock_read@reader_writer_lock@Concurrency@@QAE@AAV12@@Z"
		size = 23
		refs = "000c ?lock_read@reader_writer_lock@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_69_30_0 {
	meta:
		name = "??0scheduler_resource_allocation_error@Concurrency@@QAE@ABV01@@Z"
		size = 36
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7scheduler_resource_allocation_error@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 56 8B F9 E8 ?? ?? ?? ?? C7 07 ?? ?? ?? ?? 8B 46 0C 89 47 0C 8B C7 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_39_44_1 {
	meta:
		name = "??0regex_error@std@@QAE@ABV01@@Z"
		size = 36
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7regex_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 56 8B F9 E8 ?? ?? ?? ?? C7 07 ?? ?? ?? ?? 8B 46 0C 89 47 0C 8B C7 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_69_37_0 {
	meta:
		name = "??1ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ"
		size = 71
		refs = "0003 __ehhandler$??1ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ 0008 __EH_prolog3 0030 ?__TlsFree@platform@details@Concurrency@@YAXK@Z 003d ??1_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ 0042 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 83 65 FC 00 8B 0E 85 C9 74 05 8B 01 FF 50 18 8B 4E 04 85 C9 74 05 8B 01 FF 50 18 FF 76 08 E8 ?? ?? ?? ?? 83 4D FC FF 59 8D 4E 0C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_69_41_0 {
	meta:
		name = "??1UMSFreeThreadProxy@details@Concurrency@@UAE@XZ"
		size = 25
		refs = "0002 ??_7UMSFreeThreadProxy@details@Concurrency@@6BUMSBaseObject@12@@ 0009 ??_7UMSFreeThreadProxy@details@Concurrency@@6BIUMSThreadProxy@2@@ 0010 ??_7UMSFreeThreadProxy@details@Concurrency@@6BIUMSUnblockNotification@2@@ 0015 ??1UMSThreadProxy@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { C7 01 ?? ?? ?? ?? C7 41 04 ?? ?? ?? ?? C7 41 08 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_42_0 {
	meta:
		name = "??1UMSFreeThreadProxyFactory@details@Concurrency@@UAE@XZ"
		size = 47
		refs = "0003 __ehhandler$??1UMSFreeThreadProxyFactory@details@Concurrency@@UAE@XZ 0008 __EH_prolog3 0013 ??_7UMSFreeThreadProxyFactory@details@Concurrency@@6B@ 001f ??1Transmogrificator@details@Concurrency@@QAE@XZ 0025 ??_7IThreadProxyFactory@details@Concurrency@@6B@ 002a __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 C7 06 ?? ?? ?? ?? 83 65 FC 00 8D 4E 30 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_69_58_0 {
	meta:
		name = "??_G?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7IThreadProxyFactory@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
		altNames = "??_G?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAEPAXI@Z ??_GFreeThreadProxyFactory@details@Concurrency@@UAEPAXI@Z ??_GIThreadProxyFactory@details@Concurrency@@UAEPAXI@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_685_1 {
	meta:
		name = "??_G?$ISource@I@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$ISource@I@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_686_1 {
	meta:
		name = "??_G?$ISource@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$ISource@W4agent_status@Concurrency@@@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_66_687_2 {
	meta:
		name = "??_G?$ITarget@I@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$ITarget@I@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_66_688_2 {
	meta:
		name = "??_G?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$ITarget@W4agent_status@Concurrency@@@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_123_896_2 {
	meta:
		name = "??_G?$_Func_base@EV?$task@_N@Concurrency@@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$_Func_base@EV?$task@_N@Concurrency@@@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_123_897_2 {
	meta:
		name = "??_G?$_Func_base@V?$task@_N@Concurrency@@_N@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$_Func_base@V?$task@_N@Concurrency@@_N@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_121_947_1 {
	meta:
		name = "??_G?$_Func_base@X$$$V@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$_Func_base@X$$$V@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_66_691_2 {
	meta:
		name = "??_G?$_Func_base@XABI@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$_Func_base@XABI@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_66_692_2 {
	meta:
		name = "??_G?$_Func_base@XPAV?$message@I@Concurrency@@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$_Func_base@XPAV?$message@I@Concurrency@@@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_693_1 {
	meta:
		name = "??_G?$_Func_base@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$_Func_base@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_121_948_1 {
	meta:
		name = "??_G?$_Func_base@XV?$task@_N@Concurrency@@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$_Func_base@XV?$task@_N@Concurrency@@@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_694_1 {
	meta:
		name = "??_G?$_Func_base@_NABW4agent_status@Concurrency@@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$_Func_base@_NABW4agent_status@Concurrency@@@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_66_695_2 {
	meta:
		name = "??_G?$_Func_impl@U?$_Callable_obj@P6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@@std@@@2@_NABW4agent_status@Concurrency@@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$_Func_base@_NABW4agent_status@Concurrency@@@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_544_60_0 {
	meta:
		name = "??_G?$_Ref_count@V__ExceptionPtr@@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Ref_count_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_544_61_0 {
	meta:
		name = "??_G?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Ref_count_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_121_958_1 {
	meta:
		name = "??_G?$_Ref_count_obj@U?$_Task_impl@E@details@Concurrency@@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Ref_count_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_121_959_1 {
	meta:
		name = "??_G?$_Ref_count_obj@U?$_Task_impl@_N@details@Concurrency@@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Ref_count_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_121_960_1 {
	meta:
		name = "??_G?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Ref_count_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_29_119_2 {
	meta:
		name = "??_G?$codecvt@DDH@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_379_2 {
	meta:
		name = "??_G?$codecvt@GDH@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_380_2 {
	meta:
		name = "??_G?$codecvt@_WDH@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_713_1 {
	meta:
		name = "??_G?$message@I@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$message@I@Concurrency@@6B@ 0014 ?Free@Concurrency@@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_714_1 {
	meta:
		name = "??_G?$message@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$message@W4agent_status@Concurrency@@@Concurrency@@6B@ 0014 ?Free@Concurrency@@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_90_209_1 {
	meta:
		name = "??_G?$messages@D@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_446_1 {
	meta:
		name = "??_G?$messages@G@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_447_1 {
	meta:
		name = "??_G?$messages@_W@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_90_210_1 {
	meta:
		name = "??_G?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_387_2 {
	meta:
		name = "??_G?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_388_2 {
	meta:
		name = "??_G?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_119_177_2 {
	meta:
		name = "??_G?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_450_1 {
	meta:
		name = "??_G?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_390_2 {
	meta:
		name = "??_G?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_52_115_2 {
	meta:
		name = "??_G?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_395_2 {
	meta:
		name = "??_G?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_457_1 {
	meta:
		name = "??_G?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_20_130_1 {
	meta:
		name = "??_G?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_458_1 {
	meta:
		name = "??_G?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_398_2 {
	meta:
		name = "??_G?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_600_139_0 {
	meta:
		name = "??_GCacheLocalScheduleGroup@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7ScheduleGroup@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_435_81_0 {
	meta:
		name = "??_GCancellationTokenRegistration_TaskProc@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_RefCounter@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_199_48_0 {
	meta:
		name = "??_GContext@Concurrency@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7Context@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1050_44_0 {
	meta:
		name = "??_GExecutionResource@details@Concurrency@@QAEPAXI@Z"
		size = 32
		refs = "000c ??_7ExecutionResource@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_600_141_0 {
	meta:
		name = "??_GFairScheduleGroup@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7ScheduleGroup@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_600_143_0 {
	meta:
		name = "??_GRealizedChore@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Chore@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_495_94_0 {
	meta:
		name = "??_GScheduleGroup@Concurrency@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7ScheduleGroup@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_495_95_0 {
	meta:
		name = "??_GScheduleGroupBase@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7ScheduleGroup@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_600_145_0 {
	meta:
		name = "??_GScheduler@Concurrency@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7Scheduler@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_911_33_0 {
	meta:
		name = "??_GUMSSchedulingContext@details@Concurrency@@QAEPAXI@Z"
		size = 32
		refs = "000c ??_7UMSSchedulingContext@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_123_918_2 {
	meta:
		name = "??_G_CancellationTokenRegistration@details@Concurrency@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_RefCounter@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_121_968_1 {
	meta:
		name = "??_G_Chore@details@Concurrency@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Chore@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_121_969_1 {
	meta:
		name = "??_G_ContinuationTaskHandleBase@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Chore@details@Concurrency@@6B@ 0014 ?Free@Concurrency@@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_90_216_1 {
	meta:
		name = "??_G_Facet_base@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_123_922_2 {
	meta:
		name = "??_G_Future_error_category@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7error_category@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_19_62_1 {
	meta:
		name = "??_G_Generic_error_category@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7error_category@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_29_2 {
	meta:
		name = "??_G_Iostream_error_category@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7error_category@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_909_44_0 {
	meta:
		name = "??_G_RefCounter@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_RefCounter@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_435_89_0 {
	meta:
		name = "??_G_RefCounterBase@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_RefCounterBase@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_123_926_2 {
	meta:
		name = "??_G_Ref_count_base@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Ref_count_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_42_31_2 {
	meta:
		name = "??_G_System_error_category@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7error_category@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_123_928_2 {
	meta:
		name = "??_G_TaskProcHandle@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Chore@details@Concurrency@@6B@ 0014 ?Free@Concurrency@@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_121_980_1 {
	meta:
		name = "??_G_UnrealizedChore@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Chore@details@Concurrency@@6B@ 0014 ?Free@Concurrency@@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_470_1 {
	meta:
		name = "??_Gcodecvt_base@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_29_149_1 {
	meta:
		name = "??_Gctype_base@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_95_127_2 {
	meta:
		name = "??_Gerror_category@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7error_category@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_473_1 {
	meta:
		name = "??_Gfacet@locale@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_90_223_1 {
	meta:
		name = "??_Gmessages_base@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_475_1 {
	meta:
		name = "??_Gmoney_base@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_90_226_1 {
	meta:
		name = "??_Gtime_base@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_69_60_0 {
	meta:
		name = "??_GFreeThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 37
		refs = "0008 ??_7FreeThreadProxy@details@Concurrency@@6B@ 000d ??1ThreadProxy@details@Concurrency@@UAE@XZ 0019 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_302_29_0 {
	meta:
		name = "??_GThreadVirtualProcessor@details@Concurrency@@UAEPAXI@Z"
		size = 37
		refs = "0008 ??_7ThreadVirtualProcessor@details@Concurrency@@6B@ 000d ??1VirtualProcessor@details@Concurrency@@UAE@XZ 0019 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_443_15_0 {
	meta:
		name = "??_G__non_rtti_object@std@@UAEPAXI@Z"
		size = 37
		refs = "0008 ??_7exception@std@@6B@ 000d ?_Tidy@exception@std@@AAEXXZ 0019 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1316_74_0 {
	meta:
		name = "??_Gbad_alloc@std@@UAEPAXI@Z"
		size = 37
		refs = "0008 ??_7bad_alloc@std@@6B@ 000d ??1exception@std@@UAE@XZ 0019 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_443_16_0 {
	meta:
		name = "??_Gbad_cast@std@@UAEPAXI@Z"
		size = 37
		refs = "0008 ??_7exception@std@@6B@ 000d ?_Tidy@exception@std@@AAEXXZ 0019 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1353_4_0 {
	meta:
		name = "??_Gbad_exception@std@@UAEPAXI@Z"
		size = 37
		refs = "0008 ??_7bad_exception@std@@6B@ 000d ??1exception@std@@UAE@XZ 0019 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_443_17_0 {
	meta:
		name = "??_Gbad_typeid@std@@UAEPAXI@Z"
		size = 37
		refs = "0008 ??_7exception@std@@6B@ 000d ?_Tidy@exception@std@@AAEXXZ 0019 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_443_18_0 {
	meta:
		name = "??_Gexception@std@@UAEPAXI@Z"
		size = 37
		refs = "0008 ??_7exception@std@@6B@ 000d ?_Tidy@exception@std@@AAEXXZ 0019 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_69_70_0 {
	meta:
		name = "?Create@FreeThreadProxyFactory@details@Concurrency@@EAEPAVFreeThreadProxy@23@I@Z"
		size = 53
		refs = "0003 __ehhandler$?Create@FreeThreadProxyFactory@details@Concurrency@@EAEPAVFreeThreadProxy@23@I@Z 0008 __EH_prolog3 0011 ??2@YAPAXI@Z 0029 ??0FreeThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@I@Z 002e __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 6A 44 E8 ?? ?? ?? ?? 59 8B C8 89 4D F0 33 C0 89 45 FC 85 C9 74 09 FF 75 08 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_69_73_0 {
	meta:
		name = "?Create@UMSFreeThreadProxyFactory@details@Concurrency@@EAEPAVUMSFreeThreadProxy@23@I@Z"
		size = 222
		refs = "0003 __ehhandler$?Create@UMSFreeThreadProxyFactory@details@Concurrency@@EAEPAVUMSFreeThreadProxy@23@I@Z 0008 __EH_prolog3 0014 ??2@YAPAXI@Z 002f ??0UMSFreeThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@PAXI@Z 0054 ?DequeueUmsCompletionListItems@UMS@details@Concurrency@@SAHPAXKPAPAX@Z 0068 ?FromUMSContext@UMSThreadProxy@details@Concurrency@@SAPAV123@PAX@Z 0072 ?GetNextUmsListItem@UMS@details@Concurrency@@SAPAXPAX@Z 0080 ?QueueToCompletion@TransmogrifiedPrimary@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z 0099 __imp__WaitForMultipleObjectsEx@20 00a4 __EH_epilog3 00b6 __imp__GetLastError@0 00cb ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 00d0 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 00d9 __CxxThrowException@8"
	strings:
		$1 = { 6A 1C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D9 68 C0 00 00 00 E8 ?? ?? ?? ?? 59 89 45 F0 33 F6 89 75 FC 85 C0 74 12 FF 75 08 8B C8 FF 73 58 53 E8 ?? ?? ?? ?? 8B F8 EB 02 8B FE 8B 47 18 83 4D FC FF 89 45 E8 8B 43 5C 89 45 EC EB 42 8D 45 08 50 56 FF 73 58 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 4C 8B 45 08 85 C0 74 27 50 E8 ?? ?? ?? ?? FF 75 08 8B F0 E8 ?? ?? ?? ?? 59 59 8B 4B 28 56 89 45 08 E8 ?? ?? ?? ?? 8B 45 08 85 C0 75 DB 33 F6 56 6A FF 56 8D 45 E8 50 6A 02 FF 15 ?? ?? ?? ?? 85 C0 75 AA 8B C7 E8 ?? ?? ?? ?? C2 04 00 8B 07 8B CF 6A 01 FF 50 04 FF 15 ?? ?? ?? ?? 85 C0 7E 08 0F B7 C0 0D 00 00 07 80 50 8D 4D D8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 D8 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_69_75_0 {
	meta:
		name = "__ehhandler$?Create@UMSFreeThreadProxyFactory@details@Concurrency@@EAEPAVUMSFreeThreadProxy@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@UMSFreeThreadProxyFactory@details@Concurrency@@EAEPAVUMSFreeThreadProxy@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_611_1 {
	meta:
		name = "__ehhandler$??0?$vector@PAXV?$allocator@PAX@std@@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$vector@PAXV?$allocator@PAX@std@@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_1049_1 {
	meta:
		name = "__ehhandler$?_CancelWithException@_Task_impl_base@details@Concurrency@@QAE_NABVexception_ptr@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CancelWithException@_Task_impl_base@details@Concurrency@@QAE_NABVexception_ptr@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_544_91_0 {
	meta:
		name = "__ehhandler$?_CurrentException@__ExceptionPtr@@SA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CurrentException@__ExceptionPtr@@SA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_1093_2 {
	meta:
		name = "__ehhandler$?_FinalizeAndRunContinuations@?$_Task_impl@E@details@Concurrency@@QAEXE@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_FinalizeAndRunContinuations@?$_Task_impl@E@details@Concurrency@@QAEXE@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_1096_2 {
	meta:
		name = "__ehhandler$?_FinalizeAndRunContinuations@?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAEXU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_FinalizeAndRunContinuations@?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAEXU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_1099_2 {
	meta:
		name = "__ehhandler$?_FinalizeAndRunContinuations@?$_Task_impl@_N@details@Concurrency@@QAEX_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_FinalizeAndRunContinuations@?$_Task_impl@_N@details@Concurrency@@QAEX_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_848_1 {
	meta:
		name = "__ehhandler$?_Handle_message@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@AAEXPAV?$message@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Handle_message@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@AAEXPAV?$message@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_851_1 {
	meta:
		name = "__ehhandler$?_Handle_message@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@AAEXPAV?$message@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Handle_message@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@AAEXPAV?$message@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_854_1 {
	meta:
		name = "__ehhandler$?_Handle_message@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@AAEXPAV?$message@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Handle_message@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@AAEXPAV?$message@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_435_220_0 {
	meta:
		name = "__ehhandler$?_RegisterCallback@_CancellationTokenState@details@Concurrency@@QAEXPAV_CancellationTokenRegistration@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RegisterCallback@_CancellationTokenState@details@Concurrency@@QAEXPAV_CancellationTokenRegistration@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_944_1 {
	meta:
		name = "__ehhandler$?_Sync_send_helper@?$ordered_message_processor@I@Concurrency@@AAEXPAV?$message@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Sync_send_helper@?$ordered_message_processor@I@Concurrency@@AAEXPAV?$message@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_947_1 {
	meta:
		name = "__ehhandler$?_Sync_send_helper@?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@AAEXPAV?$message@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Sync_send_helper@?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@AAEXPAV?$message@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_1336_2 {
	meta:
		name = "__ehhandler$?_TransitionedToStarted@?$_Task_impl@E@details@Concurrency@@QAE_NXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_TransitionedToStarted@?$_Task_impl@E@details@Concurrency@@QAE_NXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_1339_2 {
	meta:
		name = "__ehhandler$?_TransitionedToStarted@?$_Task_impl@_N@details@Concurrency@@QAE_NXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_TransitionedToStarted@?$_Task_impl@_N@details@Concurrency@@QAE_NXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_1011_1 {
	meta:
		name = "__ehhandler$?add@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAEXPAV?$ISource@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?add@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAEXPAV?$ISource@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_1014_2 {
	meta:
		name = "__ehhandler$?add@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAEXPAV?$ISource@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?add@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAEXPAV?$ISource@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_1076_1 {
	meta:
		name = "__ehhandler$?count@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAEIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?count@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAEIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_1174_1 {
	meta:
		name = "__ehhandler$?propagate_message@?$single_assignment@I@Concurrency@@MAE?AW4message_status@2@PAV?$message@I@2@PAV?$ISource@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?propagate_message@?$single_assignment@I@Concurrency@@MAE?AW4message_status@2@PAV?$message@I@2@PAV?$ISource@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_1222_1 {
	meta:
		name = "__ehhandler$?release_ref@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release_ref@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_1225_2 {
	meta:
		name = "__ehhandler$?release_ref@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release_ref@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_1228_2 {
	meta:
		name = "__ehhandler$?release_ref@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release_ref@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_1281_2 {
	meta:
		name = "__ehhandler$?send_message@?$single_assignment@I@Concurrency@@MAE?AW4message_status@2@PAV?$message@I@2@PAV?$ISource@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?send_message@?$single_assignment@I@Concurrency@@MAE?AW4message_status@2@PAV?$message@I@2@PAV?$ISource@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_1309_2 {
	meta:
		name = "__ehhandler$?unlink_sources@?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@MAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_sources@?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@MAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_1312_2 {
	meta:
		name = "__ehhandler$?unlink_sources@?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@MAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_sources@?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@MAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_1315_2 {
	meta:
		name = "__ehhandler$?unlink_sources@?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@MAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_sources@?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@MAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_1318_2 {
	meta:
		name = "__ehhandler$?unlink_sources@?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@MAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_sources@?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@MAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_76_0 {
	meta:
		name = "?CreateFactory@FreeThreadProxyFactory@details@Concurrency@@SAPAV123@PAVThreadProxyFactoryManager@23@@Z"
		size = 36
		refs = "0004 ?StaticInitialize@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@KAXXZ 000b ??2@YAPAXI@Z 001a ??0FreeThreadProxyFactory@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 6A 30 E8 ?? ?? ?? ?? 59 85 C0 74 0C FF 75 08 8B C8 E8 ?? ?? ?? ?? 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_69_77_0 {
	meta:
		name = "?CreateFactory@UMSFreeThreadProxyFactory@details@Concurrency@@SAPAV123@PAVThreadProxyFactoryManager@23@@Z"
		size = 53
		refs = "0003 __ehhandler$?CreateFactory@UMSFreeThreadProxyFactory@details@Concurrency@@SAPAV123@PAVThreadProxyFactoryManager@23@@Z 0008 __EH_prolog3 000d ?StaticInitialize@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@KAXXZ 0014 ??2@YAPAXI@Z 002b ??0UMSFreeThreadProxyFactory@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z 0030 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 60 E8 ?? ?? ?? ?? 59 8B C8 89 4D F0 33 C0 89 45 FC 85 C9 74 08 FF 75 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_69_80_0 {
	meta:
		name = "?Delta@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@CAPAVFreeThreadProxy@23@PAX@Z"
		size = 17
	strings:
		$1 = { 55 8B EC 8B 45 08 8D 48 C4 F7 D8 1B C0 23 C1 5D C3 }
	condition:
		$1
}

rule file_69_81_0 {
	meta:
		name = "?Delta@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@CAPAVUMSFreeThreadProxy@23@PAX@Z"
		size = 20
	strings:
		$1 = { 55 8B EC 8B 45 08 8D 88 54 FF FF FF F7 D8 1B C0 23 C1 5D C3 }
	condition:
		$1
}

rule file_69_86_0 {
	meta:
		name = "?Flush@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QAEPAVFreeThreadProxy@23@XZ"
		size = 17
		refs = "0003 __imp__InterlockedFlushSList@4"
	strings:
		$1 = { 51 FF 15 ?? ?? ?? ?? 8D 48 C4 F7 D8 1B C0 23 C1 C3 }
	condition:
		$1
}

rule file_69_110_0 {
	meta:
		name = "?Pop@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QAEPAVFreeThreadProxy@23@XZ"
		size = 17
		refs = "0003 __imp__InterlockedPopEntrySList@4"
	strings:
		$1 = { 51 FF 15 ?? ?? ?? ?? 8D 48 C4 F7 D8 1B C0 23 C1 C3 }
	condition:
		$1
}

rule file_69_87_0 {
	meta:
		name = "?Flush@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QAEPAVUMSFreeThreadProxy@23@XZ"
		size = 20
		refs = "0003 __imp__InterlockedFlushSList@4"
	strings:
		$1 = { 51 FF 15 ?? ?? ?? ?? 8D 88 54 FF FF FF F7 D8 1B C0 23 C1 C3 }
	condition:
		$1
}

rule file_69_111_0 {
	meta:
		name = "?Pop@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QAEPAVUMSFreeThreadProxy@23@XZ"
		size = 20
		refs = "0003 __imp__InterlockedPopEntrySList@4"
	strings:
		$1 = { 51 FF 15 ?? ?? ?? ?? 8D 88 54 FF FF FF F7 D8 1B C0 23 C1 C3 }
	condition:
		$1
}

rule file_69_91_0 {
	meta:
		name = "?GetCriticalRegionType@UMSThreadProxy@details@Concurrency@@UBE?AW4CriticalRegionType@3@XZ"
		size = 20
	strings:
		$1 = { 83 79 54 00 76 04 6A 02 58 C3 33 C0 3B 41 50 1B C0 F7 D8 C3 }
	condition:
		$1
}

rule file_69_96_0 {
	meta:
		name = "?GetFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVFreeThreadProxyFactory@23@XZ"
		size = 69
		refs = "0003 __ehhandler$?GetFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVFreeThreadProxyFactory@23@XZ 0008 __EH_prolog3 001c ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ 002b ?CreateFactory@FreeThreadProxyFactory@details@Concurrency@@SAPAV123@PAVThreadProxyFactoryManager@23@@Z 0039 ?_Release@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ 0040 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 83 3F 00 75 2A 8D 77 0C 8B CE 89 75 F0 E8 ?? ?? ?? ?? 83 65 FC 00 83 3F 00 75 09 57 E8 ?? ?? ?? ?? 59 89 07 83 4D FC FF 8B CE E8 ?? ?? ?? ?? 8B 07 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_69_99_0 {
	meta:
		name = "?GetNextUnblockNotification@UMSThreadProxy@details@Concurrency@@UAEPAUIUMSUnblockNotification@3@XZ"
		size = 21
	strings:
		$1 = { 8B 49 58 8D 41 A0 F7 D9 1B C9 23 C8 74 04 8D 41 08 C3 33 C0 C3 }
	condition:
		$1
}

rule file_69_104_0 {
	meta:
		name = "?GetUMSFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVUMSFreeThreadProxyFactory@23@XZ"
		size = 73
		refs = "0003 __ehhandler$?GetUMSFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVUMSFreeThreadProxyFactory@23@XZ 0008 __EH_prolog3 001d ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ 002d ?CreateFactory@UMSFreeThreadProxyFactory@details@Concurrency@@SAPAV123@PAVThreadProxyFactoryManager@23@@Z 003c ?_Release@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ 0044 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 83 7F 04 00 75 2C 8D 77 0C 8B CE 89 75 F0 E8 ?? ?? ?? ?? 83 65 FC 00 83 7F 04 00 75 0A 57 E8 ?? ?? ?? ?? 59 89 47 04 83 4D FC FF 8B CE E8 ?? ?? ?? ?? 8B 47 04 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_69_108_0 {
	meta:
		name = "?Next@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@SAPAVFreeThreadProxy@23@PAV423@@Z"
		size = 20
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 3C 8D 48 C4 F7 D8 1B C0 23 C1 5D C3 }
	condition:
		$1
}

rule file_69_109_0 {
	meta:
		name = "?Next@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@SAPAVUMSFreeThreadProxy@23@PAV423@@Z"
		size = 26
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 80 AC 00 00 00 8D 88 54 FF FF FF F7 D8 1B C0 23 C1 5D C3 }
	condition:
		$1
}

rule file_69_112_0 {
	meta:
		name = "?Prepare@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@MAEXPAVFreeThreadProxy@23@H@Z"
		size = 24
		refs = "0010 ?SetPriority@ThreadProxy@details@Concurrency@@QAEXH@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 08 8B 45 0C 39 41 18 74 06 50 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule file_69_113_0 {
	meta:
		name = "?Prepare@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@MAEXPAVUMSFreeThreadProxy@23@H@Z"
		size = 24
		refs = "0010 ?SetPriority@UMSThreadProxy@details@Concurrency@@QAEXH@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 08 8B 45 0C 39 41 2C 74 06 50 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule file_69_114_0 {
	meta:
		name = "?Prepare@UMSFreeThreadProxyFactory@details@Concurrency@@EAEXPAVUMSFreeThreadProxy@23@H@Z"
		size = 36
		refs = "0013 ?SetPriority@UMSThreadProxy@details@Concurrency@@QAEXH@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 56 8B 75 08 39 46 2C 74 08 50 8B CE E8 ?? ?? ?? ?? 83 66 58 00 83 66 54 00 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_69_115_0 {
	meta:
		name = "?Push@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QAEXPAVFreeThreadProxy@23@@Z"
		size = 21
		refs = "000d __imp__InterlockedPushEntrySList@8"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 C0 3C 50 51 FF 15 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_69_116_0 {
	meta:
		name = "?Push@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QAEXPAVUMSFreeThreadProxy@23@@Z"
		size = 23
		refs = "000f __imp__InterlockedPushEntrySList@8"
	strings:
		$1 = { 55 8B EC 8B 45 08 05 AC 00 00 00 50 51 FF 15 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_69_117_0 {
	meta:
		name = "?ReclaimProxy@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAEXPAUIThreadProxy@3@@Z"
		size = 89
		refs = "0012 ?s_proxyStackSize@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1QBIB 002a __imp__QueryDepthSList@4 0033 ?s_bucketSize@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1HA 0040 __imp__InterlockedPushEntrySList@8"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 33 C0 57 8B F9 8B 4E 14 3B 0C 85 ?? ?? ?? ?? 74 08 40 83 F8 04 7C F1 EB 27 53 8D 5F 08 8D 1C C3 53 FF 15 ?? ?? ?? ?? 0F B7 C0 3B 05 ?? ?? ?? ?? 7D 0D 8D 46 3C 50 53 FF 15 ?? ?? ?? ?? 33 F6 5B 85 F6 74 08 8B 07 8B CF 56 FF 50 20 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_69_118_0 {
	meta:
		name = "?ReclaimProxy@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAEXPAUIThreadProxy@3@@Z"
		size = 103
		refs = "001d ?s_proxyStackSize@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1QBIB 0035 __imp__QueryDepthSList@4 003e ?s_bucketSize@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1HA 004e __imp__InterlockedPushEntrySList@8"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 8B F9 85 F6 74 05 83 C6 FC EB 02 33 F6 8B 4E 28 33 C0 3B 0C 85 ?? ?? ?? ?? 74 08 40 83 F8 04 7C F1 EB 2A 53 8D 5F 08 8D 1C C3 53 FF 15 ?? ?? ?? ?? 0F B7 C0 3B 05 ?? ?? ?? ?? 7D 10 8D 86 AC 00 00 00 50 53 FF 15 ?? ?? ?? ?? 33 F6 5B 85 F6 74 08 8B 07 8B CF 56 FF 50 20 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_69_119_0 {
	meta:
		name = "?ReclaimProxy@FreeThreadProxyFactory@details@Concurrency@@UAEXPAUIThreadProxy@3@@Z"
		size = 145
		refs = "0018 ?s_proxyStackSize@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1QBIB 0030 __imp__QueryDepthSList@4 0039 ?s_bucketSize@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1HA 0046 __imp__InterlockedPushEntrySList@8 0053 __imp__InterlockedFlushSList@4"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 8B F9 80 7F 2C 00 75 6F 8B 4E 14 33 C0 3B 0C 85 ?? ?? ?? ?? 74 08 40 83 F8 04 7C F1 EB 59 53 8D 5F 08 8D 1C C3 53 FF 15 ?? ?? ?? ?? 0F B7 C0 3B 05 ?? ?? ?? ?? 7D 3F 8D 46 3C 50 53 FF 15 ?? ?? ?? ?? 80 7F 2C 00 74 2C 53 FF 15 ?? ?? ?? ?? 8B D0 8D 4A C4 F7 DA 1B D2 23 D1 74 18 8B 07 8B CF 8B 72 3C 52 FF 50 20 8B D6 8D 46 C4 F7 DA 1B D2 23 D0 75 E8 33 F6 5B 85 F6 74 08 8B 07 8B CF 56 FF 50 20 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_69_122_0 {
	meta:
		name = "?Release@FreeThreadProxyFactory@details@Concurrency@@UAEJXZ"
		size = 29
	strings:
		$1 = { 56 8D 41 28 83 CE FF F0 0F C1 30 4E 75 0B 85 C9 74 07 8B 11 6A 01 FF 52 14 8B C6 5E C3 }
	condition:
		$1
}

rule file_69_124_0 {
	meta:
		name = "?RequestProxy@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAEPAUIThreadProxy@3@IH@Z"
		size = 112
		refs = "000f ?s_proxyStackSize@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1QBIB 0020 __imp__InterlockedPopEntrySList@4"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F9 33 F6 8B 4D 08 BB ?? ?? ?? ?? 8D 47 08 89 45 FC 3B 0B 77 1A 50 FF 15 ?? ?? ?? ?? 8B F0 8D 46 C4 F7 DE 1B F6 23 F0 75 29 8B 45 FC 8B 4D 08 83 C3 04 83 C0 08 89 45 FC 81 FB ?? ?? ?? ?? 7C D1 85 F6 75 0E 8B 07 51 8B CF FF 50 1C 8B F0 85 F6 74 0B FF 75 0C 8B 17 8B CF 56 FF 52 24 5F 8B C6 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_69_125_0 {
	meta:
		name = "?RequestProxy@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAEPAUIThreadProxy@3@IH@Z"
		size = 114
		refs = "000f ?s_proxyStackSize@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1QBIB 0020 ?Pop@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QAEPAVUMSFreeThreadProxy@23@XZ"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F9 33 F6 8B 4D 08 BB ?? ?? ?? ?? 8D 47 08 89 45 FC 3B 0B 77 13 8B C8 E8 ?? ?? ?? ?? 8B F0 85 F6 75 29 8B 45 FC 8B 4D 08 83 C3 04 83 C0 08 89 45 FC 81 FB ?? ?? ?? ?? 7C D8 85 F6 75 0E 8B 07 51 8B CF FF 50 1C 8B F0 85 F6 74 14 FF 75 0C 8B 07 8B CF 56 FF 50 24 85 F6 74 05 8D 46 04 EB 02 33 C0 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_69_127_0 {
	meta:
		name = "?Retire@UMSFreeThreadProxyFactory@details@Concurrency@@EAEXPAVUMSFreeThreadProxy@23@@Z"
		size = 30
		refs = "000a ?Cancel@UMSThreadProxy@details@Concurrency@@QAEXXZ 0015 ?QueueToCompletion@TransmogrifiedPrimary@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 E8 ?? ?? ?? ?? FF 75 08 8B 4E 28 E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_69_128_0 {
	meta:
		name = "?RetireThreadProxies@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QAEXXZ"
		size = 88
		refs = "0019 __imp__InterlockedFlushSList@4"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 8B C1 6A 04 5B 89 45 F8 8D 78 08 89 5D FC 57 FF 15 ?? ?? ?? ?? 8B D0 8D 4A C4 F7 DA 1B D2 23 D1 74 1E 8B 5D F8 8B 03 8B CB 8B 72 3C 52 FF 50 20 8B D6 8D 46 C4 F7 DA 1B D2 23 D0 75 E8 8B 5D FC 83 C7 08 4B 89 5D FC 75 C5 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_129_0 {
	meta:
		name = "?RetireThreadProxies@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QAEXXZ"
		size = 87
		refs = "0019 ?Flush@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QAEPAVUMSFreeThreadProxy@23@XZ"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 8B C1 6A 04 5B 89 45 F8 8D 78 08 89 5D FC 8B CF E8 ?? ?? ?? ?? 8B C8 85 C9 74 24 8B 5D F8 8B 13 8B B1 AC 00 00 00 51 8B CB FF 52 20 8B CE 8D 86 54 FF FF FF F7 D9 1B C9 23 C8 75 E2 8B 5D FC 83 C7 08 4B 89 5D FC 75 C6 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_131_0 {
	meta:
		name = "?ShutdownFactory@FreeThreadProxyFactory@details@Concurrency@@UAEXXZ"
		size = 20
		refs = "0008 ?RetireThreadProxies@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 56 8B F1 C6 46 2C 01 E8 ?? ?? ?? ?? 8B 06 8B CE 5E FF 60 0C }
	condition:
		$1
}

rule file_69_132_0 {
	meta:
		name = "?ShutdownFactory@UMSFreeThreadProxyFactory@details@Concurrency@@UAEXXZ"
		size = 46
		refs = "0004 ?RetireThreadProxies@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QAEXXZ 0010 __imp__SetEvent@4 001e ?DeleteUmsCompletionList@UMS@details@Concurrency@@SAHPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? 8B 46 28 FF 70 14 FF 15 ?? ?? ?? ?? 83 7E 58 00 74 09 FF 76 58 E8 ?? ?? ?? ?? 59 8B 06 8B CE 6A 01 FF 50 14 5E C3 }
	condition:
		$1
}

rule file_69_133_0 {
	meta:
		name = "?StaticInitialize@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@KAXXZ"
		size = 23
		refs = "0002 ?s_bucketSize@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1HA 000a ?GetProcessorCount@Concurrency@@YAIXZ"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 0D E8 ?? ?? ?? ?? C1 E0 02 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_69_134_0 {
	meta:
		name = "?StaticInitialize@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@KAXXZ"
		size = 23
		refs = "0002 ?s_bucketSize@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1HA 000a ?GetProcessorCount@Concurrency@@YAIXZ"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 0D E8 ?? ?? ?? ?? C1 E0 02 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_69_146_0 {
	meta:
		name = "_HRESULT_FROM_WIN32"
		size = 20
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 7E 08 0F B7 C0 0D 00 00 07 80 5D C3 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "_remainder"
		size = 31
		refs = "0016 _remquo"
		altNames = "_remainderl"
	strings:
		$1 = { 55 8B EC DD 45 10 6A 00 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "_strncmp"
		size = 120
	strings:
		$1 = { 53 56 8B 4C 24 0C 8B 54 24 10 8B 5C 24 14 F7 C3 FF FF FF FF 74 51 2B CA F7 C2 03 00 00 00 74 18 0F B6 04 0A 3A 02 75 48 85 C0 0F 44 D8 42 83 EB 01 76 34 F6 C2 03 75 E8 8D 04 0A 25 FF 0F 00 00 3D FC 0F 00 00 77 D9 8B 04 0A 3B 02 75 D2 83 EB 04 76 14 8D B0 FF FE FE FE 83 C2 04 F7 D0 23 C6 A9 80 80 80 80 74 D1 33 C0 5E 5B C3 8D 64 24 00 1B C0 83 C8 01 5E 5B C3 }
	condition:
		$1
}

rule file_72_1_0 {
	meta:
		name = "__setmaxstdio"
		size = 254
		refs = "0003 __sehtable$__setmaxstdio 0008 __SEH_prolog4 001e __errno 0029 __invalid_parameter_noinfo 0038 __lock 0043 __nstream 0050 ___piob 0055 __recalloc_crt 00a5 _free 00ed __SEH_epilog4 00f8 __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 E4 00 8B 75 08 8D 46 EC 3D EC 07 00 00 76 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 B7 00 00 00 6A 01 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 3D ?? ?? ?? ?? 3B F7 7E 34 6A 04 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 78 8B 0D ?? ?? ?? ?? 89 4D E0 3B CE 7D 07 83 24 88 00 41 EB F2 89 35 ?? ?? ?? ?? 89 75 E4 EB 52 75 04 8B F7 EB 56 89 75 E4 4F 89 7D E0 8B 0D ?? ?? ?? ?? 3B FE 7C 20 8B 04 B9 85 C0 74 13 F6 40 0C 83 75 35 50 E8 ?? ?? ?? ?? 59 8B 0D ?? ?? ?? ?? 4F 89 7D E0 EB DC 83 FE FF 74 23 6A 04 56 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 89 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 06 83 CE FF 89 75 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 01 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_74_1_0 {
	meta:
		name = "__wfindfirst64"
		size = 308
		refs = "000a ___security_cookie 001f __errno 002a __invalid_parameter_noinfo 0049 __imp__FindFirstFileExW@24 0056 __imp__GetLastError@0 0087 @__security_check_cookie@4 00c2 ___time64_t_from_ft 0117 _wcscpy_s 012f __invoke_watson"
	strings:
		$1 = { 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 85 F6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4D 85 C0 74 E7 53 57 33 DB 8D 8D AC FD FF FF 53 53 53 51 53 50 FF 15 ?? ?? ?? ?? 8B F8 83 FF FF 75 51 FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 36 83 F8 08 74 24 83 F8 12 74 2C E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5F 5B 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB DF E8 ?? ?? ?? ?? 89 30 EB D6 8B 85 AC FD FF FF 83 C0 80 F7 D8 1B C0 23 85 AC FD FF FF 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 B8 FD FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 C0 FD FF FF 50 89 56 14 E8 ?? ?? ?? ?? 8B 8D C8 FD FF FF 89 46 18 33 C0 03 85 CC FD FF FF 89 46 20 8D 85 D8 FD FF FF 50 8D 46 28 89 56 1C 13 CB 68 04 01 00 00 50 89 4E 24 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 8B C7 E9 55 FF FF FF 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_74_2_0 {
	meta:
		name = "__wfindnext64"
		size = 296
		refs = "000a ___security_cookie 0023 __errno 002e __invalid_parameter_noinfo 003c @__security_check_cookie@4 0052 __imp__FindNextFileW@8 005c __imp__GetLastError@0 00b6 ___time64_t_from_ft 010e _wcscpy_s 0123 __invoke_watson"
	strings:
		$1 = { 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 08 56 8B 75 0C 57 83 CF FF 3B CF 75 22 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B C7 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 85 F6 74 DA 8D 85 AC FD FF FF 50 51 FF 15 ?? ?? ?? ?? 85 C0 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB AF E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB A2 E8 ?? ?? ?? ?? 89 30 EB 99 8B 85 AC FD FF FF 83 C0 80 F7 D8 1B C0 23 85 AC FD FF FF 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 B8 FD FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 C0 FD FF FF 50 89 56 14 E8 ?? ?? ?? ?? 8B 8D C8 FD FF FF 89 46 18 33 C0 03 85 CC FD FF FF 6A 00 5F 89 46 20 13 CF 8D 85 D8 FD FF FF 89 56 1C 50 8D 46 28 89 4E 24 68 04 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 0F 84 17 FF FF FF 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_75_3_0 {
	meta:
		name = "__output_l"
		size = 2944
		refs = "000a ___security_cookie 0071 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0076 __errno 0096 __fileno 00b5 ___pioinfo 00bc ___badioinfo 0159 ___lookuptable 0195 $LN277 03a5 __isleadbyte_l 03c3 _write_char 04e3 ___wnullstring 0557 _wctomb_s 05d0 ___nullstring 05d6 _strlen 063d __get_printf_count_output 06d4 __malloc_crt 0744 __cfltcvt_tab 074a __imp__DecodePointer@4 08d0 __aulldvrm 09c2 _write_multi_char 09eb _write_string 0af6 _free 0b43 @__security_check_cookie@4 0b57 __invalid_parameter_noinfo 0b60 $LN263 0b64 $LN130 0b68 $LN129 0b6c $LN121 0b70 $LN117 0b74 $LN116 0b78 $LN112 0b7c $LN96"
	strings:
		$1 = { 55 8B EC 81 EC 80 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 8D 8D 90 FD FF FF 53 56 89 85 D0 FD FF FF 8B 45 0C 57 FF 75 10 8B 7D 14 89 85 F0 FD FF FF 33 C0 8B D8 89 BD E4 FD FF FF 89 85 AC FD FF FF 8B F0 89 9D E8 FD FF FF 89 85 C0 FD FF FF 89 85 D8 FD FF FF 89 85 CC FD FF FF 89 85 A4 FD FF FF 89 85 B4 FD FF FF 89 85 C8 FD FF FF E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 85 A8 FD FF FF 8B 85 D0 FD FF FF 85 C0 0F 84 BD 0A 00 00 F6 40 0C 40 75 63 50 E8 ?? ?? ?? ?? 59 8B C8 83 F9 FF 74 19 83 F9 FE 74 14 8B D1 C1 F8 05 83 E2 1F C1 E2 06 03 14 85 ?? ?? ?? ?? EB 05 BA ?? ?? ?? ?? F6 42 24 7F 0F 85 81 0A 00 00 83 F9 FF 74 19 83 F9 FE 74 14 8B C1 83 E1 1F C1 F8 05 C1 E1 06 03 0C 85 ?? ?? ?? ?? EB 05 B9 ?? ?? ?? ?? F6 41 24 80 0F 85 54 0A 00 00 8B 95 F0 FD FF FF 85 D2 0F 84 46 0A 00 00 8A 12 33 C0 89 85 DC FD FF FF 8B C8 89 8D E0 FD FF FF 89 85 BC FD FF FF 89 85 B0 FD FF FF 88 95 EF FD FF FF 88 95 B8 FD FF FF 84 D2 0F 84 EE 09 00 00 8B 85 F0 FD FF FF 40 89 85 F0 FD FF FF 85 C9 0F 88 D9 09 00 00 8D 42 E0 3C 58 77 0F 0F BE C2 0F BE 80 ?? ?? ?? ?? 83 E0 0F EB 02 33 C0 8B BD BC FD FF FF 0F BE BC C7 ?? ?? ?? ?? 8B C7 89 BD BC FD FF FF 8B BD E4 FD FF FF C1 F8 04 89 85 BC FD FF FF 83 F8 07 0F 87 77 09 00 00 FF 24 85 ?? ?? ?? ?? 33 C0 83 8D D8 FD FF FF FF 8B D8 89 85 A4 FD FF FF 89 85 B4 FD FF FF 89 85 C0 FD FF FF 89 85 CC FD FF FF 89 9D E8 FD FF FF 89 85 C8 FD FF FF E9 3C 09 00 00 0F BE C2 83 E8 20 74 46 83 E8 03 74 39 83 E8 08 74 2F 48 48 74 1D 83 E8 03 8B 85 F0 FD FF FF 0F 85 1D 09 00 00 83 CB 08 89 9D E8 FD FF FF E9 0F 09 00 00 83 CB 04 89 9D E8 FD FF FF E9 FB 08 00 00 83 CB 01 EB F0 81 CB 80 00 00 00 EB E8 83 CB 02 EB E3 80 FA 2A 75 2F 8B 07 83 C7 04 89 BD E4 FD FF FF 89 85 C0 FD FF FF 85 C0 0F 89 CB 08 00 00 83 CB 04 F7 D8 89 9D E8 FD FF FF 89 85 C0 FD FF FF E9 B5 08 00 00 6B 8D C0 FD FF FF 0A 0F BE C2 83 C1 D0 03 C1 89 85 C0 FD FF FF E9 95 08 00 00 33 C0 89 85 D8 FD FF FF E9 8E 08 00 00 80 FA 2A 75 2B 8B 07 83 C7 04 89 85 D8 FD FF FF 85 C0 8B 85 F0 FD FF FF 89 BD E4 FD FF FF 0F 89 70 08 00 00 83 8D D8 FD FF FF FF E9 64 08 00 00 6B 8D D8 FD FF FF 0A 0F BE C2 83 C1 D0 03 C1 89 85 D8 FD FF FF E9 3E 08 00 00 80 FA 49 74 45 80 FA 68 74 38 8B 85 F0 FD FF FF 80 FA 6C 74 14 80 FA 77 0F 85 2C 08 00 00 81 CB 00 08 00 00 E9 07 FF FF FF 80 38 6C 75 0C 40 81 CB 00 10 00 00 E9 F6 FE FF FF 83 CB 10 E9 EE FE FF FF 83 CB 20 E9 F4 FE FF FF 8B 85 F0 FD FF FF 8A 00 3C 36 75 1C 8B BD F0 FD FF FF 80 7F 01 34 75 10 8B C7 83 C0 02 81 CB 00 80 00 00 E9 BE FE FF FF 3C 33 75 1C 8B BD F0 FD FF FF 80 7F 01 32 75 10 8B C7 83 C0 02 81 E3 FF 7F FF FF E9 9E FE FF FF 3C 64 0F 84 AA 07 00 00 3C 69 0F 84 A2 07 00 00 3C 6F 0F 84 9A 07 00 00 3C 75 0F 84 92 07 00 00 3C 78 0F 84 8A 07 00 00 3C 58 0F 84 82 07 00 00 33 C0 89 85 BC FD FF FF EB 02 33 C0 89 85 C8 FD FF FF 8D 85 90 FD FF FF 50 0F B6 C2 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 38 8D 85 E0 FD FF FF 50 FF B5 D0 FD FF FF FF B5 B8 FD FF FF E8 ?? ?? ?? ?? 8B 8D F0 FD FF FF 83 C4 0C 8A 01 41 88 85 B8 FD FF FF 89 8D F0 FD FF FF 84 C0 0F 84 64 07 00 00 8D 85 E0 FD FF FF 50 FF B5 D0 FD FF FF FF B5 B8 FD FF FF E8 ?? ?? ?? ?? 83 C4 0C E9 FC 06 00 00 0F BE C2 83 F8 64 0F 8F CD 01 00 00 0F 84 51 02 00 00 83 F8 53 0F 8F ED 00 00 00 74 7C 83 E8 41 74 10 48 48 74 56 48 48 74 08 48 48 0F 85 18 05 00 00 80 C2 20 C7 85 A4 FD FF FF 01 00 00 00 88 95 EF FD FF FF 8B 85 D8 FD FF FF 8D B5 F4 FD FF FF 83 CB 40 B9 00 02 00 00 89 9D E8 FD FF FF 89 8D C4 FD FF FF 85 C0 0F 89 32 02 00 00 C7 85 D8 FD FF FF 06 00 00 00 E9 80 02 00 00 F7 C3 30 08 00 00 0F 85 9E 00 00 00 81 CB 00 08 00 00 89 9D E8 FD FF FF E9 8D 00 00 00 F7 C3 30 08 00 00 75 0C 81 CB 00 08 00 00 89 9D E8 FD FF FF 8B 95 D8 FD FF FF B9 FF FF FF 7F 83 FA FF 74 02 8B CA 8B 37 83 C7 04 89 BD E4 FD FF FF F7 C3 10 08 00 00 0F 84 53 04 00 00 85 F6 75 06 8B 35 ?? ?? ?? ?? C7 85 C8 FD FF FF 01 00 00 00 8B C6 85 C9 74 0F 33 D2 49 66 39 10 74 07 83 C0 02 85 C9 75 F3 2B C6 D1 F8 E9 3C 04 00 00 83 E8 58 0F 84 B0 02 00 00 48 48 74 70 83 E8 07 0F 84 27 FF FF FF 48 48 0F 85 24 04 00 00 83 C7 04 89 BD E4 FD FF FF F7 C3 10 08 00 00 74 30 0F B7 47 FC 50 68 00 02 00 00 8D 85 F4 FD FF FF 50 8D 85 DC FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 1F C7 85 B4 FD FF FF 01 00 00 00 EB 13 8A 47 FC 88 85 F4 FD FF FF C7 85 DC FD FF FF 01 00 00 00 8D B5 F4 FD FF FF E9 C5 03 00 00 8B 07 83 C7 04 89 BD E4 FD FF FF 85 C0 74 33 8B 70 04 85 F6 74 2C 0F BF 00 F7 C3 00 08 00 00 74 14 99 2B C2 C7 85 C8 FD FF FF 01 00 00 00 D1 F8 E9 8A 03 00 00 33 C9 89 8D C8 FD FF FF E9 7D 03 00 00 8B 35 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 E9 6B 03 00 00 83 F8 70 0F 8F E3 01 00 00 0F 84 CF 01 00 00 83 F8 65 0F 8C 59 03 00 00 83 F8 67 0F 8E 4B FE FF FF 83 F8 69 74 64 83 F8 6E 74 25 83 F8 6F 0F 85 3D 03 00 00 C7 85 DC FD FF FF 08 00 00 00 84 DB 79 5B 81 CB 00 02 00 00 89 9D E8 FD FF FF EB 4D 83 C7 04 89 BD E4 FD FF FF 8B 7F FC E8 ?? ?? ?? ?? 85 C0 0F 84 02 05 00 00 8B 85 E0 FD FF FF F6 C3 20 74 05 66 89 07 EB 02 89 07 C7 85 B4 FD FF FF 01 00 00 00 E9 7A 04 00 00 83 CB 40 89 9D E8 FD FF FF C7 85 DC FD FF FF 0A 00 00 00 F7 C3 00 80 00 00 75 0C F7 C3 00 10 00 00 0F 84 8E 01 00 00 8B 0F 83 C7 08 89 BD E4 FD FF FF 33 F6 8B 7F FC E9 AE 01 00 00 75 11 80 FA 67 75 56 C7 85 D8 FD FF FF 01 00 00 00 EB 4A 3B C1 7E 08 8B C1 89 85 D8 FD FF FF 3D A3 00 00 00 7E 37 8D B8 5D 01 00 00 57 E8 ?? ?? ?? ?? 8A 95 EF FD FF FF 89 85 B0 FD FF FF 59 85 C0 74 0A 8B F0 89 BD C4 FD FF FF EB 0A C7 85 D8 FD FF FF A3 00 00 00 8B BD E4 FD FF FF 8B 07 83 C7 08 89 85 88 FD FF FF 89 BD E4 FD FF FF 8B 47 FC 89 85 8C FD FF FF 8D 85 90 FD FF FF 50 FF B5 A4 FD FF FF 0F BE C2 FF B5 D8 FD FF FF 50 FF B5 C4 FD FF FF 8D 85 88 FD FF FF 56 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 8B FB 83 C4 1C 81 E7 80 00 00 00 74 21 83 BD D8 FD FF FF 00 75 18 8D 85 90 FD FF FF 50 56 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 59 59 80 BD EF FD FF FF 67 75 1C 85 FF 75 18 8D 85 90 FD FF FF 50 56 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 59 59 80 3E 2D 0F 85 28 FE FF FF 81 CB 00 01 00 00 46 89 9D E8 FD FF FF E9 16 FE FF FF C7 85 D8 FD FF FF 08 00 00 00 6A 07 EB 1C 83 E8 73 0F 84 DF FC FF FF 48 48 0F 84 96 FE FF FF 83 E8 03 0F 85 6B 01 00 00 6A 27 C7 85 DC FD FF FF 10 00 00 00 58 89 85 AC FD FF FF 84 DB 0F 89 7C FE FF FF 04 51 C6 85 D4 FD FF FF 30 88 85 D5 FD FF FF C7 85 CC FD FF FF 02 00 00 00 E9 5E FE FF FF 83 C7 04 33 F6 89 BD E4 FD FF FF F6 C3 20 74 11 F6 C3 40 74 06 0F BF 47 FC EB 0E 0F B7 47 FC EB 08 F6 C3 40 74 0A 8B 47 FC 99 8B C8 8B FA EB 05 8B 4F FC 8B FE F6 C3 40 74 1C 3B FE 7F 18 7C 04 3B CE 73 12 F7 D9 13 FE F7 DF 81 CB 00 01 00 00 89 9D E8 FD FF FF F7 C3 00 90 00 00 75 02 8B FE 8B 95 D8 FD FF FF 85 D2 79 05 33 D2 42 EB 14 83 E3 F7 B8 00 02 00 00 89 9D E8 FD FF FF 3B D0 7E 02 8B D0 8B C1 0B C7 75 06 89 B5 CC FD FF FF 8D 75 F3 8B C2 4A 89 95 D8 FD FF FF 85 C0 7F 06 8B C1 0B C7 74 3D 8B 85 DC FD FF FF 99 52 50 57 51 E8 ?? ?? ?? ?? 83 C1 30 89 9D 84 FD FF FF 89 85 C4 FD FF FF 8B FA 83 F9 39 7E 06 03 8D AC FD FF FF 8B 95 D8 FD FF FF 88 0E 4E 8B 8D C4 FD FF FF EB B0 8B 9D E8 FD FF FF 8D 45 F3 2B C6 46 89 85 DC FD FF FF F7 C3 00 02 00 00 74 36 85 C0 74 05 80 3E 30 74 2D 4E FF 85 DC FD FF FF C6 06 30 EB 21 85 F6 75 06 8B 35 ?? ?? ?? ?? 8B C6 EB 07 49 80 38 00 74 05 40 85 C9 75 F5 2B C6 89 85 DC FD FF FF 83 BD B4 FD FF FF 00 0F 85 86 01 00 00 F6 C3 40 74 35 F7 C3 00 01 00 00 74 09 C6 85 D4 FD FF FF 2D EB 1A F6 C3 01 74 09 C6 85 D4 FD FF FF 2B EB 0C F6 C3 02 74 11 C6 85 D4 FD FF FF 20 C7 85 CC FD FF FF 01 00 00 00 8B BD C0 FD FF FF 2B BD DC FD FF FF 8B 85 CC FD FF FF 2B F8 F6 C3 0C 75 1E 8D 85 E0 FD FF FF 50 FF B5 D0 FD FF FF 57 6A 20 E8 ?? ?? ?? ?? 8B 85 CC FD FF FF 83 C4 10 FF B5 A8 FD FF FF 8D 8D E0 FD FF FF 51 FF B5 D0 FD FF FF 50 8D 85 D4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 14 F6 C3 08 74 1D F6 C3 04 75 18 8D 85 E0 FD FF FF 50 FF B5 D0 FD FF FF 57 6A 30 E8 ?? ?? ?? ?? 83 C4 10 83 BD C8 FD FF FF 00 8B 85 DC FD FF FF 74 7D 85 C0 7E 79 8B CE 48 89 85 C4 FD FF FF 0F B7 01 83 C1 02 50 6A 06 8D 45 F4 89 8D 84 FD FF FF 50 8D 85 A0 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 3F 39 85 A0 FD FF FF 74 37 FF B5 A8 FD FF FF 8D 85 E0 FD FF FF 50 FF B5 D0 FD FF FF 8D 45 F4 FF B5 A0 FD FF FF 50 E8 ?? ?? ?? ?? 8B 85 C4 FD FF FF 83 C4 14 8B 8D 84 FD FF FF 85 C0 75 96 EB 28 83 C9 FF 89 8D E0 FD FF FF EB 23 FF B5 A8 FD FF FF 8D 8D E0 FD FF FF 51 FF B5 D0 FD FF FF 50 56 E8 ?? ?? ?? ?? 83 C4 14 8B 8D E0 FD FF FF 85 C9 78 23 F6 C3 04 74 1E 8D 85 E0 FD FF FF 50 FF B5 D0 FD FF FF 57 6A 20 E8 ?? ?? ?? ?? 83 C4 10 8B 8D E0 FD FF FF 8B 85 B0 FD FF FF 85 C0 74 15 50 E8 ?? ?? ?? ?? 33 C0 59 89 85 B0 FD FF FF 8B 8D E0 FD FF FF 8B 85 F0 FD FF FF 8A 10 88 95 EF FD FF FF 88 95 B8 FD FF FF 84 D2 0F 85 18 F6 FF FF 8B C1 80 BD 9C FD FF FF 00 5F 5E 5B 74 0A 8B 8D 98 FD FF FF 83 61 70 FD 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB C7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_4_0 {
	meta:
		name = "_get_int64_arg"
		size = 19
		altNames = "_get_crtdouble_arg"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 00 08 8B 10 8B 42 F8 8B 52 FC 5D C3 }
	condition:
		$1
}

rule file_75_5_0 {
	meta:
		name = "_get_int_arg"
		size = 16
	strings:
		$1 = { 55 8B EC 8B 45 08 83 00 04 8B 00 8B 40 FC 5D C3 }
	condition:
		$1
}

rule file_75_6_0 {
	meta:
		name = "_get_short_arg"
		size = 17
	strings:
		$1 = { 55 8B EC 8B 45 08 83 00 04 8B 00 66 8B 40 FC 5D C3 }
	condition:
		$1
}

rule file_75_7_0 {
	meta:
		name = "_write_char"
		size = 72
		refs = "002e __flsbuf"
	strings:
		$1 = { 55 8B EC 8B 55 0C F6 42 0C 40 74 06 83 7A 08 00 74 2F FF 4A 04 78 0E 8B 02 8A 4D 08 88 08 FF 02 0F B6 C1 EB 0F 8B 45 08 52 0F BE C0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 08 8B 45 10 83 08 FF 5D C3 8B 45 10 FF 00 5D C3 }
	condition:
		$1
}

rule file_75_8_0 {
	meta:
		name = "_write_multi_char"
		size = 44
		refs = "0018 _write_char"
	strings:
		$1 = { 55 8B EC 56 8B 75 0C 85 F6 7E 1E 57 8B 7D 14 57 FF 75 10 4E FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 83 3F FF 74 04 85 F6 7F E7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_75_9_0 {
	meta:
		name = "_write_string"
		size = 120
		refs = "003f _write_char"
	strings:
		$1 = { 55 8B EC 56 8B 75 18 57 8B 7D 10 8B 06 89 45 18 F6 47 0C 40 74 10 83 7F 08 00 75 0A 8B 4D 14 8B 45 0C 01 01 EB 4E 83 26 00 53 8B 5D 0C 85 DB 7E 40 8B 45 14 50 8B 45 08 4B 57 0F B6 00 50 E8 ?? ?? ?? ?? 8B 45 14 83 C4 0C FF 45 08 83 38 FF 75 14 83 3E 2A 75 13 50 57 6A 3F E8 ?? ?? ?? ?? 8B 45 14 83 C4 0C 85 DB 7F CB 83 3E 00 75 05 8B 45 18 89 06 5B 5F 5E 5D C3 }
	condition:
		$1
}

rule file_77_3_0 {
	meta:
		name = "__mbstrlen"
		size = 32
		refs = "0005 ___locale_changed 000e _strlen 0018 __mbstrlen_l"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 06 5D E9 ?? ?? ?? ?? 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_77_4_0 {
	meta:
		name = "__mbstrlen_l"
		size = 139
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0020 _strlen 003c __imp__MultiByteToWideChar@24 0045 __errno 005e __isleadbyte_l"
	strings:
		$1 = { 55 8B EC 83 EC 10 56 57 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F0 83 78 74 01 75 0D FF 75 08 E8 ?? ?? ?? ?? 59 8B F8 EB 4D 8B 75 08 83 CF FF 6A 00 6A 00 57 56 6A 09 FF 70 04 FF 15 ?? ?? ?? ?? 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 2A 00 00 00 EB 25 33 FF EB 1B 8D 4D F0 0F B6 C0 51 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 06 46 80 3E 00 74 08 47 46 8A 06 84 C0 75 DF 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 8B C7 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "__wspawnlpe"
		size = 82
		refs = "000b __errno 0016 __invalid_parameter_noinfo 0049 __wspawnvpe"
	strings:
		$1 = { 55 8B EC 8B 55 0C 85 D2 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 33 C9 66 39 0A 74 E4 8B 45 10 85 C0 74 DD 66 39 08 74 D8 8D 4D 10 8B 01 8D 49 04 85 C0 75 F7 FF 31 8D 45 10 50 52 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1393_0_0 {
	meta:
		name = "__wspawnle"
		size = 82
		refs = "000b __errno 0016 __invalid_parameter_noinfo 0049 __wspawnve"
	strings:
		$1 = { 55 8B EC 8B 55 0C 85 D2 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 33 C9 66 39 0A 74 E4 8B 45 10 85 C0 74 DD 66 39 08 74 D8 8D 4D 10 8B 01 8D 49 04 85 C0 75 F7 FF 31 8D 45 10 50 52 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "__wchdir"
		size = 287
		refs = "000a ___security_cookie 002d ___doserrno 0035 __errno 0040 __invalid_parameter_noinfo 004d __imp__SetCurrentDirectoryW@4 0067 __imp__GetCurrentDirectoryW@8 007c __calloc_crt 00ca _towupper 00e7 __imp__SetEnvironmentVariableW@8 00f1 __imp__GetLastError@0 00f7 __dosmaperr 0108 _free 0117 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 1C 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 83 A5 E4 FD FF FF 00 53 83 CB FF 56 8D B5 E8 FD FF FF 85 C0 75 1D E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 C4 00 00 00 57 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 96 00 00 00 8D 85 E8 FD FF FF 50 68 05 01 00 00 FF 15 ?? ?? ?? ?? 8B F8 81 FF 04 01 00 00 7E 2E 8D 47 01 6A 02 50 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 67 C7 85 E4 FD FF FF 01 00 00 00 85 FF 74 59 56 8D 47 01 50 FF 15 ?? ?? ?? ?? 8B F8 85 FF 74 48 0F B7 06 83 F8 5C 74 05 83 F8 2F 75 0A 66 3B 46 02 75 04 33 DB EB 3E 6A 3D 58 66 89 45 F4 0F B7 06 50 E8 ?? ?? ?? ?? 59 6A 3A 66 89 45 F6 58 66 89 45 F8 33 C0 66 89 45 FA 8D 45 F4 56 50 FF 15 ?? ?? ?? ?? 85 C0 75 CB FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 BD E4 FD FF FF 00 5F 74 07 56 E8 ?? ?? ?? ?? 59 8B 4D FC 8B C3 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_80_4_0 {
	meta:
		name = "__toupper_l"
		size = 324
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002e __isctype_l 0097 __isleadbyte_l 00b4 __errno 00eb ___crtLCMapStringA"
	strings:
		$1 = { 55 8B EC 83 EC 18 8D 4D E8 53 FF 75 0C E8 ?? ?? ?? ?? 8B 5D 08 81 FB 00 01 00 00 73 60 8B 4D E8 83 79 74 01 7E 14 8D 45 E8 50 6A 02 53 E8 ?? ?? ?? ?? 8B 4D E8 83 C4 0C EB 0D 8B 81 90 00 00 00 0F B7 04 58 83 E0 02 85 C0 74 1E 80 7D F4 00 8B 81 98 00 00 00 0F B6 0C 18 74 07 8B 45 F0 83 60 70 FD 8B C1 E9 D6 00 00 00 80 7D F4 00 74 07 8B 4D F0 83 61 70 FD 8B C3 E9 C2 00 00 00 8B 45 E8 83 78 74 01 7E 2D 8B C3 8D 4D E8 C1 F8 08 89 45 08 51 0F B6 C0 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 12 8B 45 08 6A 02 88 45 FC 88 5D FD C6 45 FE 00 59 EB 15 E8 ?? ?? ?? ?? 33 C9 41 C7 00 2A 00 00 00 88 5D FC C6 45 FD 00 8B 45 E8 8D 55 F8 6A 01 FF 70 04 6A 03 52 51 8D 4D FC 51 68 00 02 00 00 FF B0 A8 00 00 00 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 75 15 38 45 F4 0F 84 77 FF FF FF 8B 45 F0 83 60 70 FD E9 6B FF FF FF 83 F8 01 75 13 80 7D F4 00 0F B6 45 F8 74 25 8B 4D F0 83 61 70 FD EB 1C 0F B6 55 F8 0F B6 45 F9 C1 E2 08 0B D0 80 7D F4 00 74 07 8B 4D F0 83 61 70 FD 8B C2 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_80_5_0 {
	meta:
		name = "_toupper"
		size = 44
		refs = "0005 ___locale_changed 0024 __toupper_l"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 12 8B 4D 08 8D 41 9F 83 F8 19 77 03 83 C1 E0 8B C1 5D C3 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "__wfopen"
		size = 21
		refs = "000c __wfsopen"
	strings:
		$1 = { 55 8B EC 6A 40 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_430_1_0 {
	meta:
		name = "_fopen"
		size = 21
		refs = "000c __fsopen"
	strings:
		$1 = { 55 8B EC 6A 40 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_81_1_0 {
	meta:
		name = "__wfopen_s"
		size = 69
		refs = "000c __errno 0016 __invalid_parameter_noinfo 002a __wfsopen"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 85 F6 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 24 68 80 00 00 00 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 89 06 85 C0 74 04 33 C0 EB 07 E8 ?? ?? ?? ?? 8B 00 5E 5D C3 }
	condition:
		$1
}

rule file_430_2_0 {
	meta:
		name = "_fopen_s"
		size = 69
		refs = "000c __errno 0016 __invalid_parameter_noinfo 002a __fsopen"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 85 F6 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 24 68 80 00 00 00 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 89 06 85 C0 74 04 33 C0 EB 07 E8 ?? ?? ?? ?? 8B 00 5E 5D C3 }
	condition:
		$1
}

rule file_81_2_0 {
	meta:
		name = "__wfsopen"
		size = 202
		refs = "0003 __sehtable$__wfsopen 0008 __SEH_prolog4 0020 __errno 002b __invalid_parameter_noinfo 0051 __getstream 0087 ___security_cookie 008c __local_unwind4 009c __wopenfile 00b7 __SEH_epilog4 00c4 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C9 89 4D E4 33 C0 8B 7D 08 85 FF 0F 95 C0 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 80 00 00 00 33 C0 8B 5D 0C 85 DB 0F 95 C0 85 C0 74 DB 33 C0 66 39 0B 0F 95 C0 85 C0 74 CF E8 ?? ?? ?? ?? 8B F0 89 75 08 85 F6 75 0D E8 ?? ?? ?? ?? C7 00 18 00 00 00 EB C4 33 C0 89 45 FC 66 39 07 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A FE 8D 45 F0 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C EB 9A 56 FF 75 10 53 57 E8 ?? ?? ?? ?? 83 C4 10 8B F8 89 7D E4 C7 45 FC FE FF FF FF E8 0E 00 00 00 8B C7 E8 ?? ?? ?? ?? C3 8B 75 08 8B 7D E4 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "___libm_sse2_powf"
		size = 1715
		refs = "0004 _dword_mask 000f _SIGMASK 001b _EXPMASK 0048 _cv 0093 _B_table 009b _SCALE5 00c4 _T_tbl 00e9 _Shifter 0161 _cev 01a9 _exp2_tbl 01f6 _ABSVALMASK 02bf _NEG_ZEROD 0357 _ABSVALS 039b _ONEMASK 0437 _NEG_ZERO 0443 _NEG_INF 0492 _sNaN 0533 _INF"
	strings:
		$1 = { F3 0F 10 3D ?? ?? ?? ?? 83 EC 0C 66 0F 12 2D ?? ?? ?? ?? 66 0F DB C7 66 0F 12 1D ?? ?? ?? ?? 66 0F DB CF F3 0F 11 44 24 04 66 0F C5 C0 01 0F 28 E0 66 0F 73 F0 1D 66 0F 54 E8 66 0F 56 EB F3 0F 11 4C 24 08 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? F3 0F 5A C9 8B D0 B9 7F 7F 00 00 2B CA 81 EA 80 00 00 00 0B CA 81 F9 00 80 00 00 0F 83 7D 01 00 00 BA 3F 3F 00 00 B9 00 00 00 00 66 0F 6E C2 83 E0 7F 83 C0 01 25 FE 00 00 00 66 0F 12 3C 85 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 10 DF 66 0F 73 D7 1A 66 0F 73 F7 1A 66 0F 73 D4 10 66 0F FA E0 66 0F 72 E4 07 F3 0F E6 E4 66 0F 12 04 85 ?? ?? ?? ?? F2 0F 5C DF F2 0F 59 FD F2 0F 59 EB F2 0F 5C 3D ?? ?? ?? ?? F2 0F 58 EF 66 0F 70 FD 44 66 0F 12 1D ?? ?? ?? ?? F2 0F 58 C5 66 0F 59 F7 66 0F 59 FF F2 0F 58 C4 F2 0F 59 D7 F2 0F 58 C2 66 0F 70 D2 EE F2 0F 58 F2 F2 0F 59 C1 F2 0F 59 FF 66 0F C5 D0 03 F2 0F 10 E0 F2 0F 58 C3 F2 0F 5C C3 66 0F 59 F7 B8 D0 41 00 00 81 E2 F0 7F 00 00 2B C2 81 EA 60 3E 00 00 0B D0 81 FA 00 00 00 80 0F 83 F8 04 00 00 F2 0F 2D C0 F2 0F 5C E0 66 0F 70 FE EE F2 0F 58 F7 66 0F 28 3D ?? ?? ?? ?? F2 0F 59 CE 66 0F 28 15 ?? ?? ?? ?? 66 0F 57 F6 F2 0F 58 E1 66 0F 70 EC 44 BA BF 0F 00 00 2B D0 05 A0 0F 00 00 0B D0 2D A0 0F 00 00 81 FA 00 00 00 80 0F 83 D9 03 00 00 8B D0 D1 FA 83 E0 1F 66 0F 12 1C C5 ?? ?? ?? ?? 81 C9 F0 3F 00 00 83 E2 F0 03 CA 66 0F C4 F1 03 83 C4 0C 66 0F 59 FD F2 0F 59 ED F2 0F 59 E3 66 0F 58 D7 F2 0F 59 DE F2 0F 59 E6 F2 0F 59 EA 66 0F 70 C2 EE F2 0F 58 C5 F2 0F 59 C4 F2 0F 58 C3 66 0F 5A C0 C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E CA F2 0F 10 C1 F2 0F 10 F9 66 0F 54 C3 66 0F 73 D0 20 66 0F 7E C1 81 F9 00 00 F0 7F 0F 83 D4 00 00 00 0B D1 83 FA 00 0F 84 20 03 00 00 66 0F 7E E2 81 FA FF FF 7F 7F 0F 86 DC 00 00 00 66 0F 73 F3 34 66 0F 56 FB B9 F3 03 00 00 66 0F 6E D9 66 0F 73 D0 14 66 0F FA C3 66 0F EF DB 66 0F EE C3 66 0F F3 F8 66 0F 76 FB 66 0F D7 CF 81 E1 FF 00 00 00 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 0F 83 38 01 00 00 81 F9 FF 00 00 00 0F 85 EF 01 00 00 66 0F 12 1D ?? ?? ?? ?? F2 0F 10 C1 F2 0F 10 F9 66 0F 54 C3 B9 F4 03 00 00 66 0F 6E D9 66 0F 54 05 ?? ?? ?? ?? 66 0F 73 D0 34 66 0F FA C3 66 0F 12 1D ?? ?? ?? ?? 66 0F F3 F8 66 0F 76 FB 66 0F D7 CF 81 E1 FF 00 00 00 81 C1 01 7F 00 00 81 E1 00 80 00 00 81 FA 00 00 80 00 72 32 BA 3F BF 00 00 E9 8C FD FF FF 66 0F 7E E2 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 77 05 E9 91 01 00 00 83 C4 0C F3 0F 10 C4 F3 0F 58 C0 C3 B9 00 00 00 00 66 0F 57 C0 BA 80 5F 00 00 66 0F C4 C2 01 66 0F 12 2D ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? F3 0F 59 E0 66 0F 7E E2 81 E2 FF FF FF 7F 83 FA 00 74 26 66 0F C5 C4 01 0F 28 C4 0F 54 25 ?? ?? ?? ?? 66 0F 73 F0 1D 66 0F 54 E8 66 0F 56 EB BA 3F 5F 00 00 E9 0D FD FF FF 8B 54 24 08 81 E2 00 00 00 80 83 FA 00 74 23 C1 E1 10 66 0F 7E E2 23 D1 81 CA 00 00 80 7F 66 0F 6E C2 83 C4 0C F3 0F 10 2D ?? ?? ?? ?? F3 0F 5E EC C3 C1 E1 10 66 0F 7E E2 23 D1 83 FA 00 75 7E 83 C4 0C 0F 57 C0 C3 66 0F 7E E2 81 FA 00 00 80 7F 0F 84 99 00 00 00 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 0F 87 2F FF FF FF 81 F9 FF 00 00 00 75 65 F2 0F 10 E9 F2 0F 10 D1 B9 F4 03 00 00 66 0F 6E D9 66 0F 54 2D ?? ?? ?? ?? 66 0F 73 D5 34 66 0F FA EB 66 0F EF DB 66 0F F3 D5 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 3D FF 00 00 00 74 27 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 74 0C 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? C3 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? C3 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 D1 00 00 00 83 C4 0C 0F 57 C0 C3 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 B7 00 00 00 83 C4 0C 0F 57 C0 C3 66 0F 7E E0 3D 00 00 00 80 0F 84 E7 FE FF FF 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C0 C3 8B 44 24 08 8B C8 25 FF FF FF 7F 3D 00 00 80 7F 0F 87 87 00 00 00 81 E1 00 00 00 80 66 0F 7E E2 81 F2 00 00 80 BF 83 FA 00 74 30 83 F9 00 74 49 66 0F 7E E0 25 FF FF FF 7F 3D 00 00 80 3F 73 14 83 F8 00 75 4C B9 00 00 80 3F 66 0F 6E E9 F3 0F 5E EC EB 3D 83 C4 0C 0F 57 C0 C3 83 EC 10 0F AE 5C 24 0C 83 64 24 0C DE 0F AE 54 24 0C 83 C4 1C F3 0F 10 05 ?? ?? ?? ?? C3 66 0F C5 C4 01 25 80 7F 00 00 3D 80 3F 00 00 73 07 83 C4 0C 0F 57 C0 C3 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 4C 24 08 83 C4 0C F3 0F 58 C9 F3 0F 10 C1 C3 66 0F 7E E0 F3 0F 10 05 ?? ?? ?? ?? 83 F8 00 74 17 66 0F 7E E0 0F 57 D2 F3 0F 58 E2 25 FF FF FF 7F 3D 00 00 80 7F 77 00 83 C4 0C C3 3D 00 20 00 00 0F 8D 92 00 00 00 3D 00 E0 FF FF 0F 8E 9E 00 00 00 66 0F 57 C9 8B D0 C1 FA 05 83 E0 1F 66 0F 12 1C C5 ?? ?? ?? ?? 8B C2 D1 FA 2B C2 C1 E2 04 05 FF 03 00 00 C1 E0 04 81 C9 F0 3F 00 00 03 CA 66 0F C4 F1 03 66 0F C4 C8 03 66 0F 59 FD F2 0F 59 ED F2 0F 59 E3 66 0F 58 D7 F2 0F 59 DE F2 0F 59 E6 F2 0F 59 EA 66 0F 70 C2 EE F2 0F 58 C5 F2 0F 59 C4 F2 0F 58 C3 F2 0F 59 C1 66 0F 5A C0 66 0F C5 C0 01 25 FF 7F 00 00 3D 80 7F 00 00 73 05 83 F8 10 72 00 83 C4 0C C3 83 C4 0C 81 C9 7F 7F 00 00 66 0F 57 C0 66 0F C4 C1 01 F3 0F 58 C0 C3 83 C4 0C B8 00 00 80 00 66 0F 6E E8 F3 0F 59 ED 66 0F 57 C0 66 0F C4 C1 01 C3 8B 54 24 04 F3 0F 10 64 24 04 81 FA 00 00 80 3F 0F 84 9C FE FF FF 8B 44 24 08 F3 0F 10 4C 24 08 25 FF FF FF 7F 3D 00 00 80 7F 0F 83 27 FE FF FF 83 F8 00 0F 84 CD FE FF FF 66 0F C5 D0 03 8B C2 81 E2 F0 7F 00 00 81 FA 60 3E 00 00 76 10 25 00 80 00 00 83 F8 00 0F 84 73 FF FF FF EB 88 83 C4 0C C1 E1 10 81 C9 00 00 80 3F 66 0F 6E C1 C3 }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "___sse2_atan22"
		size = 656
		refs = "0021 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC C0 00 00 00 83 E4 F0 89 84 24 84 00 00 00 66 0F 29 04 24 66 0F 29 4C 24 10 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 54 D0 66 0F 54 D9 66 0F 29 54 24 30 66 0F 29 5C 24 40 66 0F 57 C2 66 0F 57 CB 66 0F 28 D0 66 0F C2 D1 05 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 E2 66 0F 54 DA 66 0F 54 25 ?? ?? ?? ?? 66 0F 56 CC 66 0F 28 E2 66 0F 28 E8 66 0F 28 F1 66 0F 54 C2 66 0F 54 CA 66 0F 55 D6 66 0F 55 E5 66 0F 56 CC 66 0F 56 D0 66 0F 5E CA 66 0F 28 24 24 66 0F 28 2C 24 66 0F 28 74 24 10 66 0F 28 7C 24 10 66 0F 54 25 ?? ?? ?? ?? 66 0F 54 2D ?? ?? ?? ?? 66 0F 54 35 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? 66 0F C2 25 ?? ?? ?? ?? 06 66 0F C2 2D ?? ?? ?? ?? 01 66 0F C2 35 ?? ?? ?? ?? 06 66 0F C2 3D ?? ?? ?? ?? 01 66 0F 54 E5 66 0F 54 F7 66 0F 54 E6 66 0F 50 C4 83 F8 03 0F 8C 5A 01 00 00 66 0F 28 64 24 40 66 0F 72 E4 1F 66 0F 70 E4 F5 66 0F 54 25 ?? ?? ?? ?? 66 0F 29 64 24 50 66 0F 29 5C 24 60 66 0F 28 E1 66 0F 59 C9 66 0F 28 E9 66 0F 59 C9 66 0F 28 C1 66 0F 59 C9 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D0 66 0F 59 D5 66 0F 59 D8 66 0F 59 F5 66 0F 58 D3 66 0F 58 F7 66 0F 58 F2 66 0F 59 F4 66 0F 58 74 24 60 66 0F 56 74 24 40 66 0F 58 74 24 50 66 0F 56 74 24 30 66 0F 28 C6 EB 21 DD 04 24 DD 44 24 10 D9 F3 DD 5C 24 20 DD 44 24 08 DD 44 24 18 D9 F3 DD 5C 24 28 66 0F 28 44 24 20 8B A4 24 84 00 00 00 C3 8D 64 24 00 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "___common_dtan_cout_rare"
		size = 128
		refs = "004f __vmldTanHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 83 EC 08 8B 55 08 0F B7 4A 06 F2 0F 10 0A 81 E1 F0 7F 00 00 0F B6 42 07 83 E0 7F F2 0F 11 0C 24 81 F9 F0 7F 00 00 88 44 24 07 74 06 33 C0 8B E5 5D C3 8B 45 0C 83 3C 24 00 75 23 81 7C 24 04 00 00 F0 7F 75 19 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C8 F2 0F 11 08 B8 01 00 00 00 8B E5 5D C3 F2 0F 59 C9 F2 0F 11 08 33 C0 8B E5 5D C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_87_4_0 {
	meta:
		name = "___check_float_string"
		size = 98
		refs = "001d __calloc_crt 0041 _memcpy 004c __recalloc_crt"
	strings:
		$1 = { 55 8B EC 56 8B 75 0C 57 8B 06 39 45 08 75 4C 8B 7D 10 6A 04 50 8B 0F 3B 4D 14 75 2E E8 ?? ?? ?? ?? 89 07 59 59 85 C0 75 04 33 C0 EB 31 8B 45 18 C7 00 01 00 00 00 8B 06 03 C0 50 FF 75 14 FF 37 E8 ?? ?? ?? ?? 83 C4 0C EB 0F 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 D2 89 07 D1 26 33 C0 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_87_5_0 {
	meta:
		name = "__cprinput_s_l"
		size = 4794
		refs = "000a ___security_cookie 0070 __errno 007b __invalid_parameter_noinfo 0092 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00c2 _iswctype 00db __whiteout 00e4 __un_inc 01a7 _isdigit 03c3 __getwche_nolock 0598 ___check_float_string 0798 _free 07eb @__security_check_cookie@4 08e7 __malloc_crt 0901 _wcstombs_s 0937 __cfltcvt_tab 093d __imp__DecodePointer@4 0b43 _memset 0e10 _wctomb_s 0f2d __allmul 0f56 _isxdigit 0f8a __hextodec 12b5 __invoke_watson"
	strings:
		$1 = { 55 8B EC 81 EC 44 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 10 89 85 D4 FC FF FF 8D 85 40 FD FF FF 53 33 DB 89 85 04 FD FF FF 56 8B 75 08 8B C3 89 B5 20 FD FF FF C7 85 E0 FC FF FF 5E 01 00 00 89 9D D8 FC FF FF 89 9D 18 FD FF FF 89 9D CC FC FF FF 89 9D FC FC FF FF 89 9D F4 FC FF FF 89 85 28 FD FF FF 89 9D D0 FC FF FF 85 F6 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 5C 07 00 00 57 FF 75 0C 8D 8D BC FC FF FF E8 ?? ?? ?? ?? 0F B7 06 8B FB 88 9D 13 FD FF FF 8B D3 89 BD 38 FD FF FF 89 BD 14 FD FF FF 89 95 E4 FC FF FF 66 85 C0 0F 84 0F 07 00 00 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 49 8D 85 14 FD FF FF 4F 50 89 BD 14 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 50 E8 ?? ?? ?? ?? 59 59 83 C6 02 6A 08 0F B7 06 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 EC 8B BD 14 FD FF FF 89 B5 20 FD FF FF 89 BD 38 FD FF FF E9 16 11 00 00 0F B7 06 6A 25 59 66 3B C8 0F 85 D9 10 00 00 66 3B 4E 02 0F 84 C1 10 00 00 8B F3 89 9D F8 FC FF FF 8B FB 89 B5 0C FD FF FF 8B B5 20 FD FF FF 8A C3 8A D3 89 BD E8 FC FF FF B6 01 89 9D F0 FC FF FF 8B CB 89 9D 30 FD FF FF 89 9D DC FC FF FF 88 9D EF FC FF FF 88 9D 12 FD FF FF 88 85 37 FD FF FF 88 95 03 FD FF FF 88 9D 27 FD FF FF 88 9D 3F FD FF FF 88 B5 2F FD FF FF 89 8D 08 FD FF FF 83 C6 02 0F B7 1E F7 C3 00 FF 00 00 75 39 0F B6 C3 50 E8 ?? ?? ?? ?? 8A 95 03 FD FF FF 59 8B 8D 08 FD FF FF 85 C0 74 13 FF 85 F0 FC FF FF 6B C7 0A 8D 7B D0 03 F8 E9 82 00 00 00 8A B5 2F FD FF FF 8A 85 37 FD FF FF 83 FB 4E 0F 8F 08 01 00 00 74 6B 83 FB 2A 0F 84 F0 00 00 00 83 FB 46 74 5D 83 FB 49 74 13 83 FB 4C 0F 85 FB 00 00 00 FE C6 88 B5 2F FD FF FF EB 45 0F B7 46 02 83 F8 36 75 27 66 83 7E 04 34 75 20 8B 8D 08 FD FF FF 83 C6 04 83 A5 FC FC FF FF 00 41 83 A5 F4 FC FF FF 00 89 8D 08 FD FF FF EB 15 83 F8 33 75 6D 66 83 7E 04 32 75 66 83 C6 04 8B 8D 08 FD FF FF 8A 9D 3F FD FF FF 8A B5 2F FD FF FF 8A 85 37 FD FF FF 84 D2 0F 84 29 FF FF FF 89 B5 20 FD FF FF 8B B5 0C FD FF FF 89 BD 30 FD FF FF 8B BD E8 FC FF FF 84 C0 0F 85 BE 00 00 00 8B 85 D4 FC FF FF 89 85 D0 FC FF FF 83 C0 04 89 85 D4 FC FF FF 8B 40 FC 89 85 0C FD FF FF E9 A2 00 00 00 6A 64 59 66 3B C1 74 95 6A 69 59 66 3B C1 74 8D 6A 6F 59 66 3B C1 74 85 6A 78 59 66 3B C1 0F 84 79 FF FF FF 6A 58 59 66 3B C1 75 23 E9 6C FF FF FF FE C0 88 85 37 FD FF FF E9 65 FF FF FF 83 FB 68 74 46 6A 6C 58 3B D8 74 12 83 FB 77 74 27 FE C2 88 95 03 FD FF FF E9 41 FF FF FF 6A 6C 8D 46 02 5B 66 39 18 75 07 8B F0 E9 09 FF FF FF FE C6 88 B5 2F FD FF FF 8A 9D 3F FD FF FF FE C3 88 9D 3F FD FF FF E9 20 FF FF FF 8A 9D 3F FD FF FF FE CE 88 B5 2F FD FF FF FE CB EB E3 83 A5 0C FD FF FF 00 8B 8D 20 FD FF FF 32 FF 84 DB 75 14 0F B7 01 83 F8 53 74 09 83 F8 43 74 04 FE C3 EB 03 80 CB FF 0F B7 11 6A 20 58 0B D0 89 95 1C FD FF FF 83 FA 6E 0F 84 42 01 00 00 83 FA 63 74 23 83 FA 7B 74 1E 8D 85 14 FD FF FF 50 E8 ?? ?? ?? ?? 59 0F B7 C8 8B 85 14 FD FF FF 89 85 38 FD FF FF EB 1B 8B 85 38 FD FF FF 40 89 85 38 FD FF FF 89 85 14 FD FF FF E8 ?? ?? ?? ?? 0F B7 C8 B8 FF FF 00 00 89 8D 28 FD FF FF 66 3B C1 0F 84 A7 03 00 00 8B 95 1C FD FF FF 8B 85 F0 FC FF FF 85 C0 74 0D 83 BD 30 FD FF FF 00 0F 84 41 0E 00 00 80 BD 37 FD FF FF 00 75 54 83 FA 63 74 0A 83 FA 73 74 05 83 FA 7B 75 45 8B 85 D0 FC FF FF 83 C0 04 89 85 D4 FC FF FF 8B 40 FC 89 85 0C FD FF FF 8B 85 D4 FC FF FF 89 85 D0 FC FF FF 83 C0 04 89 85 D4 FC FF FF 8B 40 FC 89 85 DC FC FF FF 83 F8 01 0F 82 F6 0D 00 00 8B 85 F0 FC FF FF 83 FA 6F 0F 8F 1B 06 00 00 0F 84 5E 0A 00 00 83 FA 63 0F 84 E1 04 00 00 6A 64 58 3B D0 0F 84 4A 0A 00 00 0F 8E 25 06 00 00 83 FA 67 7E 5B 83 FA 69 74 49 83 FA 6E 0F 85 12 06 00 00 80 BD 37 FD FF FF 00 8B B5 38 FD FF FF 0F 84 F5 0C 00 00 33 DB 8B BD 38 FD FF FF 8B B5 20 FD FF FF FE 85 13 FD FF FF 83 C6 02 89 B5 20 FD FF FF E9 62 0D 00 00 8B 8D 28 FD FF FF E9 10 FF FF FF 8B F8 89 BD 1C FD FF FF E9 4C 07 00 00 8B 9D 28 FD FF FF 33 F6 6A 2D 59 66 3B CB 75 0C 8B 85 04 FD FF FF 46 66 89 08 EB 08 6A 2B 58 66 3B C3 75 23 8B BD 38 FD FF FF FF 8D 30 FD FF FF 47 89 BD 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 28 FD FF FF EB 06 8B BD 38 FD FF FF 83 BD F0 FC FF FF 00 0F 85 81 00 00 00 83 8D 30 FD FF FF FF EB 78 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 72 8B 8D 30 FD FF FF 8B C1 49 89 8D 30 FD FF FF 85 C0 74 5F 8B 8D 04 FD FF FF FF 85 F8 FC FF FF 66 0F BE C3 66 89 04 71 8D 85 D8 FC FF FF 50 8D 85 40 FD FF FF 46 50 8D 85 04 FD FF FF 50 8D 85 E0 FC FF FF 50 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 DE 01 00 00 47 89 BD 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 28 FD FF FF F7 C3 00 FF 00 00 74 80 8B 85 BC FC FF FF 8B 80 84 00 00 00 8B 40 30 0F B7 38 8B CF 0F BE C3 3B C8 8B 8D 30 FD FF FF 0F 85 E1 00 00 00 8B C1 49 89 8D 30 FD FF FF 85 C0 0F 84 D0 00 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 8B 85 04 FD FF FF 89 9D 28 FD FF FF 66 89 3C 70 8D 85 D8 FC FF FF 50 8D 85 40 FD FF FF 46 50 8D 85 04 FD FF FF 50 8D 85 E0 FC FF FF 50 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 3F 01 00 00 BF 00 FF 00 00 85 DF 75 75 0F B6 C3 50 E8 ?? ?? ?? ?? 59 8B 8D 30 FD FF FF 85 C0 74 67 8B C1 49 89 8D 30 FD FF FF 85 C0 74 5A 8B 85 04 FD FF FF FF 85 F8 FC FF FF 66 89 1C 70 8D 85 D8 FC FF FF 50 8D 85 40 FD FF FF 46 50 8D 85 04 FD FF FF 50 8D 85 E0 FC FF FF 50 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 D7 00 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 28 FD FF FF EB 87 8B 8D 30 FD FF FF 83 BD F8 FC FF FF 00 0F 84 BB 01 00 00 6A 65 5A 66 3B D3 74 0C 6A 45 58 66 3B C3 0F 85 A7 01 00 00 8B C1 49 89 8D 30 FD FF FF 85 C0 0F 84 96 01 00 00 8B 85 04 FD FF FF 66 89 14 70 8D 85 D8 FC FF FF 50 8D 85 40 FD FF FF 46 50 8D 85 04 FD FF FF 50 8D 85 E0 FC FF FF 50 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 55 8B BD 38 FD FF FF 47 E8 ?? ?? ?? ?? 6A 2D 0F B7 D8 59 89 9D 28 FD FF FF 66 3B CB 0F 85 A2 00 00 00 8B 85 04 FD FF FF 66 89 0C 70 8D 85 D8 FC FF FF 50 8D 85 40 FD FF FF 46 50 8D 85 04 FD FF FF 50 8D 85 E0 FC FF FF 50 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 7A 33 DB 8B 85 18 FD FF FF 83 BD CC FC FF FF 01 75 07 50 E8 ?? ?? ?? ?? 59 83 BD D8 FC FF FF 01 75 0C FF B5 04 FD FF FF E8 ?? ?? ?? ?? 59 83 FB 01 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B 95 E4 FC FF FF 80 BD C8 FC FF FF 00 5F 74 0A 8B 8D C4 FC FF FF 83 61 70 FD 8B C2 8B 4D FC 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 6A 2B 58 66 3B C3 0F 85 89 00 00 00 8B 8D 30 FD FF FF 8B C1 49 89 8D 30 FD FF FF 85 C0 75 67 21 85 30 FD FF FF EB 6E 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 70 8B 8D 30 FD FF FF 8B C1 49 89 8D 30 FD FF FF 85 C0 74 5D 8B 85 04 FD FF FF FF 85 F8 FC FF FF 66 89 1C 70 8D 85 D8 FC FF FF 50 8D 85 40 FD FF FF 46 50 8D 85 04 FD FF FF 50 8D 85 E0 FC FF FF 50 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 0C FF FF FF 47 E8 ?? ?? ?? ?? 0F B7 D8 89 9D 28 FD FF FF F7 C3 00 FF 00 00 74 8A EB 06 8B BD 38 FD FF FF 4F 53 89 BD 38 FD FF FF 89 BD 14 FD FF FF E8 ?? ?? ?? ?? 83 BD F8 FC FF FF 00 59 0F 84 CC FE FF FF 80 BD 37 FD FF FF 00 0F 85 22 09 00 00 8B 9D 04 FD FF FF 33 C0 FF 85 E4 FC FF FF 66 89 04 73 8B 85 E0 FC FF FF 8D 3C 45 02 00 00 00 57 E8 ?? ?? ?? ?? 8B F0 59 85 F6 0F 84 8F FE FF FF 8D 4F FF 51 53 57 56 33 DB 53 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 12 83 F8 16 0F 84 9A 09 00 00 83 F8 22 0F 84 91 09 00 00 8D 85 BC FC FF FF 50 0F BE 85 2F FD FF FF 56 FF B5 0C FD FF FF 48 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 56 E8 ?? ?? ?? ?? 83 C4 14 E9 58 FB FF FF 85 C0 75 10 FF 85 30 FD FF FF C7 85 F0 FC FF FF 01 00 00 00 84 DB 7E 07 C6 85 27 FD FF FF 01 8B 9D 38 FD FF FF 8B 85 28 FD FF FF 4B 8B B5 0C FD FF FF 50 89 9D 38 FD FF FF 89 9D 14 FD FF FF E8 ?? ?? ?? ?? 8B BD 1C FD FF FF 59 83 FF 63 74 06 FF 8D DC FC FF FF 83 BD F0 FC FF FF 00 74 17 8B 8D 30 FD FF FF 8B C1 49 89 8D 30 FD FF FF 85 C0 0F 84 A3 04 00 00 43 89 9D 38 FD FF FF 89 9D 14 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 28 FD FF FF 83 FF 63 74 4F 83 FF 73 75 16 83 FB 09 72 09 83 FB 0D 0F 86 56 04 00 00 6A 20 58 66 3B D8 75 34 83 FF 7B 0F 85 45 04 00 00 0F B7 C3 33 D2 8B C8 42 83 E1 07 C1 E8 03 D3 E2 8B 8D 18 FD FF FF 0F BE 0C 08 0F BE 85 EF FC FF FF 33 C8 85 D1 0F 84 1A 04 00 00 80 BD 37 FD FF FF 00 0F 85 FF 03 00 00 8B 8D DC FC FF FF 85 C9 0F 84 2D 08 00 00 80 BD 27 FD FF FF 00 0F 84 9B 03 00 00 8B 95 0C FD FF FF 66 89 1A 83 C2 02 49 89 95 0C FD FF FF 89 8D DC FC FF FF E9 C9 03 00 00 8B C2 83 E8 70 0F 84 37 04 00 00 83 E8 03 0F 84 D5 FE FF FF 48 48 0F 84 2D 04 00 00 83 E8 03 0F 84 86 01 00 00 83 E8 03 74 40 8B B5 20 FD FF FF 8B 9D 28 FD FF FF 66 39 1E 0F 85 B4 07 00 00 FE 8D 13 FD FF FF 33 DB 8B BD 38 FD FF FF 38 9D 37 FD FF FF 0F 85 E0 F9 FF FF 8B 85 D0 FC FF FF 89 85 D4 FC FF FF E9 CF F9 FF FF 84 DB 7E 07 C6 85 27 FD FF FF 01 8B B5 20 FD FF FF 83 C6 02 6A 5E 58 66 3B 06 75 0A 83 C6 02 C6 85 EF FC FF FF FF 8B 85 18 FD FF FF 85 C0 75 23 68 00 20 00 00 E8 ?? ?? ?? ?? 89 85 18 FD FF FF 59 85 C0 0F 84 79 07 00 00 C7 85 CC FC FF FF 01 00 00 00 68 00 20 00 00 33 DB 53 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 5D 5A 66 3B 16 0F 85 B1 00 00 00 8B 85 18 FD FF FF 8B FA 83 C6 02 C6 40 0B 20 E9 97 00 00 00 0F B7 C8 83 C6 02 6A 2D 58 66 3B C1 75 6F 66 85 FF 74 6A 0F B7 06 66 3B D0 74 62 83 C6 02 89 B5 20 FD FF FF 66 3B F8 73 04 8B F0 EB 0B 0F B7 F7 8B F8 89 BD E8 FC FF FF 89 B5 08 FD FF FF 66 3B FE 73 2D 2B B5 E8 FC FF FF 0F B7 DE 8B B5 18 FD FF FF 0F B7 FF 8B D7 8B CF C1 EA 03 83 E1 07 B0 01 D2 E0 08 04 32 47 4B 75 EB 8B B5 08 FD FF FF 0F B7 CE 8B FB 8B B5 20 FD FF FF EB 02 8B F9 8B D1 B0 01 83 E1 07 C1 EA 03 D2 E0 8B 8D 18 FD FF FF 6A 5D 08 04 0A 5A 89 BD E8 FC FF FF 0F B7 06 66 3B D0 0F 85 57 FF FF FF 66 39 1E 0F 84 6B FB FF FF 89 B5 20 FD FF FF E9 49 FD FF FF 8B BD 1C FD FF FF 6A 2D 58 66 3B C1 75 09 C6 85 12 FD FF FF 01 EB 08 6A 2B 58 66 3B C1 75 36 FF 8D 30 FD FF FF 75 0D 83 BD F0 FC FF FF 00 74 04 B7 01 EB 21 8B 85 38 FD FF FF 40 89 85 38 FD FF FF 89 85 14 FD FF FF E8 ?? ?? ?? ?? 0F B7 C8 89 8D 28 FD FF FF 6A 30 58 66 3B C1 0F 85 87 00 00 00 8B 85 38 FD FF FF 40 89 85 38 FD FF FF 89 85 14 FD FF FF E8 ?? ?? ?? ?? 0F B7 C8 6A 78 58 89 8D 28 FD FF FF 66 3B C1 0F 84 F4 00 00 00 6A 58 5A 66 3B D1 0F 84 E8 00 00 00 C7 85 F8 FC FF FF 01 00 00 00 3B F8 74 1B 83 BD F0 FC FF FF 00 74 0A FF 8D 30 FD FF FF 75 02 FE C7 6A 6F 5A E9 04 01 00 00 8B BD 38 FD FF FF 4F 51 89 BD 38 FD FF FF 89 BD 14 FD FF FF E8 ?? ?? ?? ?? 59 6A 30 58 8B C8 89 8D 28 FD FF FF 8B 95 1C FD FF FF 6A 78 58 83 BD 08 FD FF FF 00 0F 84 41 03 00 00 84 FF 0F 85 00 03 00 00 8B 9D 38 FD FF FF 3B D0 0F 84 0A 02 00 00 83 FA 70 0F 84 01 02 00 00 F7 C1 00 FF 00 00 0F 85 B9 02 00 00 0F B6 C1 50 E8 ?? ?? ?? ?? 8B BD 1C FD FF FF 59 85 C0 0F 84 BD 02 00 00 6A 6F 58 3B F8 0F 85 A7 01 00 00 8B 8D 28 FD FF FF 6A 38 58 66 3B C1 0F 86 8A 02 00 00 8B 85 FC FC FF FF 8B 95 F4 FC FF FF 0F A4 C2 03 C1 E0 03 89 95 F4 FC FF FF 89 85 FC FC FF FF E9 F5 01 00 00 8B BD 38 FD FF FF 47 89 BD 38 FD FF FF 89 BD 14 FD FF FF E8 ?? ?? ?? ?? 83 BD F0 FC FF FF 00 0F B7 C8 89 8D 28 FD FF FF 74 16 8B 85 30 FD FF FF 83 E8 02 89 85 30 FD FF FF 83 F8 01 7D 02 FE C7 6A 78 58 8B D0 89 95 1C FD FF FF E9 1F FF FF FF 83 A5 E8 FC FF FF 00 8D 85 E8 FC FF FF 53 51 FF B5 0C FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 83 F8 22 0F 84 5E 04 00 00 8B 85 E8 FC FF FF 8B 9D 38 FD FF FF 85 C0 0F 8E 73 FB FF FF 01 85 0C FD FF FF 29 85 DC FC FF FF EB 03 83 C6 02 8B 9D 38 FD FF FF E9 57 FB FF FF 8B 85 38 FD FF FF 48 53 89 85 38 FD FF FF 89 85 14 FD FF FF E8 ?? ?? ?? ?? 59 8B 85 0C FD FF FF 3B F0 0F 84 0D F9 FF FF 80 BD 37 FD FF FF 00 0F 85 22 F6 FF FF FF 85 E4 FC FF FF 83 FF 63 0F 84 13 F6 FF FF 80 BD 27 FD FF FF 00 8B BD 38 FD FF FF 8B B5 20 FD FF FF 74 0C 33 C9 33 DB 66 89 08 E9 00 F6 FF FF 33 DB 88 18 E9 F7 F5 FF FF C6 85 2F FD FF FF 01 6A 2D 58 66 3B C1 75 09 C6 85 12 FD FF FF 01 EB 0C 6A 2B 58 66 3B C1 0F 85 33 FE FF FF FF 8D 30 FD FF FF 75 10 83 BD F0 FC FF FF 00 74 07 B7 01 E9 1B FE FF FF 8B BD 38 FD FF FF 47 89 BD 38 FD FF FF 89 BD 14 FD FF FF E8 ?? ?? ?? ?? 0F B7 C8 E9 EF FD FF FF 8B 8D F4 FC FF FF 6A 00 6A 0A 51 8B 8D FC FC FF FF 51 E8 ?? ?? ?? ?? 8B 8D 28 FD FF FF 89 85 FC FC FF FF 89 95 F4 FC FF FF EB 59 F7 C1 00 FF 00 00 0F 85 B8 00 00 00 0F B6 C1 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 A0 00 00 00 8B 85 FC FC FF FF 8B 8D F4 FC FF FF 0F A4 C1 04 C1 E0 04 89 85 FC FC FF FF 8B 85 28 FD FF FF 50 89 8D F4 FC FF FF E8 ?? ?? ?? ?? 8B BD 1C FD FF FF 59 0F B7 C8 89 8D 28 FD FF FF FF 85 F8 FC FF FF 0F B7 C1 6A 30 59 2B C1 8B 8D FC FC FF FF 99 03 C8 8B 85 F4 FC FF FF 89 8D FC FC FF FF 13 C2 83 BD F0 FC FF FF 00 89 85 F4 FC FF FF 74 08 FF 8D 30 FD FF FF 74 65 43 89 9D 38 FD FF FF 89 9D 14 FD FF FF E8 ?? ?? ?? ?? 8B 95 1C FD FF FF 0F B7 C8 6A 78 89 8D 28 FD FF FF 58 E9 30 }
	condition:
		$1
}

rule file_87_8_0 {
	meta:
		name = "__hextodec"
		size = 49
		refs = "0018 _isdigit"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 F7 C6 00 FF 00 00 75 11 0F B7 DE 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 75 09 0F B7 DE 83 E3 DF 83 EB 07 5E 66 8B C3 5B 5D C3 }
	condition:
		$1
}

rule file_87_11_0 {
	meta:
		name = "__un_inc"
		size = 22
		refs = "0010 __ungetwch_nolock"
	strings:
		$1 = { 55 8B EC B8 FF FF 00 00 66 3B 45 08 74 06 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_1191_8_0 {
	meta:
		name = "__un_inc"
		size = 22
		refs = "0010 __ungetwc_nolock"
	strings:
		$1 = { 55 8B EC B8 FF FF 00 00 66 3B 45 08 74 06 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_87_12_0 {
	meta:
		name = "__whiteout"
		size = 49
		refs = "000b __getwche_nolock 0020 _iswctype"
	strings:
		$1 = { 55 8B EC 56 57 8B 7D 08 FF 07 E8 ?? ?? ?? ?? 0F B7 F0 B8 FF FF 00 00 66 3B F0 74 0E 6A 08 56 E8 ?? ?? ?? ?? 59 59 85 C0 75 DE 5F 66 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "_localeconv"
		size = 38
		refs = "0001 __getptd 000a ___ptlocinfo 0012 ___globallocalestatus 001c ___updatetlocinfo 0021 ___lconv"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 48 6C 3B 0D ?? ?? ?? ?? 74 10 8B 0D ?? ?? ?? ?? 85 48 70 75 05 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "___avx_log4"
		size = 416
		refs = "0010 ___common_dlog_data 018f ___common_dlog_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FD 54 2D ?? ?? ?? ?? C5 D5 56 1D ?? ?? ?? ?? C5 FD 5A CB C5 F8 53 F1 C5 FC 5A FE C5 E9 73 D0 14 C4 E3 7D 19 C4 01 C5 D1 73 D4 14 C5 FD C2 25 ?? ?? ?? ?? 11 C5 E8 C6 CD DD C5 FD C2 2D ?? ?? ?? ?? 16 C4 E3 7D 09 D7 00 C5 FE E6 F1 C5 DD 56 FD C5 E5 54 25 ?? ?? ?? ?? C5 E5 5C DC C4 E3 7D 19 FD 01 C5 C0 C6 CD DD C5 DD 59 EA C5 F8 50 C1 C5 E5 59 CA C5 D5 5C 1D ?? ?? ?? ?? C5 E5 58 E9 C5 C1 73 D2 28 C5 F9 7E FA C4 E3 79 16 F9 02 C4 E3 7D 19 D4 01 C5 D9 73 D4 28 C5 FB 10 9A ?? ?? ?? ?? C5 F9 7E E2 C5 E1 16 89 ?? ?? ?? ?? C5 ED C2 15 ?? ?? ?? ?? 1E C5 FB 10 BA ?? ?? ?? ?? C4 E3 79 16 E1 02 C5 ED 54 15 ?? ?? ?? ?? C5 C1 16 A1 ?? ?? ?? ?? C4 E3 75 18 DC 01 C5 ED 56 0D ?? ?? ?? ?? C5 CD 5C F1 C5 D5 59 0D ?? ?? ?? ?? C5 D5 59 25 ?? ?? ?? ?? C5 CD 59 15 ?? ?? ?? ?? C5 F5 58 35 ?? ?? ?? ?? C5 DD 58 25 ?? ?? ?? ?? C5 D5 59 CD C5 CD 59 F9 C5 C5 58 F4 C5 CD 59 C9 C5 D5 58 E9 C5 D5 58 DB C5 E5 58 CA 85 C0 75 08 C5 FD 28 C1 8B E5 5D C3 C5 FD 11 44 24 40 C5 FD 11 8C 24 80 00 00 00 74 E7 33 D2 89 74 24 04 8B F2 89 3C 24 8B F8 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 8C 24 80 00 00 00 EB BD C5 F8 77 8D 8C F4 80 00 00 00 8D 44 F4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_91_10_0 {
	meta:
		name = "??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z"
		size = 19
		altNames = "??0?$_SpinWait@$0A@@details@Concurrency@@QAE@P6AXXZ@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 61 08 00 89 41 0C 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_91_13_0 {
	meta:
		name = "??0InternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@@Z"
		size = 115
		refs = "0013 ??_7IExecutionContext@Concurrency@@6B@ 0018 ??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0027 ??_7InternalContextBase@details@Concurrency@@6BIExecutionContext@2@@ 002e ??_7InternalContextBase@details@Concurrency@@6BContextBase@12@@"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 33 DB 53 FF 75 08 8D 4F 04 C7 07 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 A7 B3 00 00 00 FC 8B C7 C7 07 ?? ?? ?? ?? C7 47 04 ?? ?? ?? ?? 89 9F 9C 00 00 00 89 9F A0 00 00 00 89 9F A4 00 00 00 89 9F A8 00 00 00 89 9F AC 00 00 00 88 9F B0 00 00 00 88 9F B2 00 00 00 89 9F E4 00 00 00 89 5F 1C C6 87 EC 00 00 00 01 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_91_23_0 {
	meta:
		name = "??0invalid_argument@std@@QAE@PBD@Z"
		size = 34
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 0017 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 89 45 08 8B F1 8D 45 08 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_544_39_0 {
	meta:
		name = "??0length_error@std@@QAE@PBD@Z"
		size = 34
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 0017 ??_7length_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 89 45 08 8B F1 8D 45 08 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_39_41_1 {
	meta:
		name = "??0out_of_range@std@@QAE@PBD@Z"
		size = 34
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 0017 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 89 45 08 8B F1 8D 45 08 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_39_43_1 {
	meta:
		name = "??0overflow_error@std@@QAE@PBD@Z"
		size = 34
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 0017 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 89 45 08 8B F1 8D 45 08 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_80_63_1 {
	meta:
		name = "??0range_error@std@@QAE@PBD@Z"
		size = 34
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 0017 ??_7range_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 89 45 08 8B F1 8D 45 08 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_25_0 {
	meta:
		name = "??0location@Concurrency@@QAE@ABV01@@Z"
		size = 21
		refs = "000a ?_Assign@location@Concurrency@@QAEXABV12@@Z"
		altNames = "??4location@Concurrency@@QAEAAV01@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_90_76_1 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@ABV01@@Z"
		size = 21
		refs = "000a ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_192_1 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@ABV01@@Z"
		size = 21
		refs = "000a ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_96_28_1 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@ABV01@@Z"
		size = 21
		refs = "000a ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_90_176_1 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAEAAU01@ABU01@@Z"
		size = 21
		refs = "000a ??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_376_1 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAEAAU01@ABU01@@Z"
		size = 21
		refs = "000a ??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_377_1 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAEAAU01@ABU01@@Z"
		size = 21
		refs = "000a ??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_495_79_0 {
	meta:
		name = "??4QuickBitSet@details@Concurrency@@QAEAAV012@ABV012@@Z"
		size = 21
		refs = "000a ?CopyFrom@QuickBitSet@details@Concurrency@@IAEXABV123@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_90_203_1 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAEAAV01@H@Z"
		size = 21
		refs = "000a ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAEAAV01@H@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_429_1 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAEAAV01@H@Z"
		size = 21
		refs = "000a ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAEAAV01@H@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_96_77_1 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAEAAV01@H@Z"
		size = 21
		refs = "000a ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAEAAV01@H@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_27_0 {
	meta:
		name = "??0logic_error@std@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_11_0 {
	meta:
		name = "??0_Interruption_exception@details@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7_Interruption_exception@details@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_443_3_0 {
	meta:
		name = "??0bad_cast@std@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_544_37_0 {
	meta:
		name = "??0bad_exception@std@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_13_0 {
	meta:
		name = "??0bad_target@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_443_5_0 {
	meta:
		name = "??0bad_typeid@std@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_16_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_18_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_20_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_22_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_24_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_26_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_28_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_30_0 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_32_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_34_0 {
	meta:
		name = "??0invalid_operation@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_36_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_38_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_40_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_42_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_44_0 {
	meta:
		name = "??0message_not_found@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_46_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_48_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_50_0 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_268_2 {
	meta:
		name = "??0runtime_error@std@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_52_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_58_0 {
	meta:
		name = "??0task_canceled@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7task_canceled@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_60_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_29_0 {
	meta:
		name = "??1?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "0004 ?Wipe@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEXXZ 000c ??_V@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? FF 76 08 E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_501_24_0 {
	meta:
		name = "??1?$Hash@II@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "0004 ?Wipe@?$Hash@II@details@Concurrency@@QAEXXZ 000c ??_V@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? FF 76 08 E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_91_31_0 {
	meta:
		name = "??1CancellationBeaconStack@ContextBase@details@Concurrency@@QAE@XZ"
		size = 57
		refs = "001a ??_V@YAXPAX@Z 0020 ??3@YAXPAX@Z"
	strings:
		$1 = { 53 8B D9 83 7B 04 00 7E 25 8B 43 08 57 8B 38 85 FF 74 1A 56 FF 37 8B 77 04 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 8B FE 59 59 85 F6 75 E8 5E 5F FF 73 08 E8 ?? ?? ?? ?? 59 5B C3 }
	condition:
		$1
}

rule file_91_33_0 {
	meta:
		name = "??1ContextBase@details@Concurrency@@UAE@XZ"
		size = 46
		refs = "000b ??1CancellationBeaconStack@ContextBase@details@Concurrency@@QAE@XZ 0018 ?Wipe@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEXXZ 0020 ??_V@YAXPAX@Z 0027 ??_7Context@Concurrency@@6B@"
	strings:
		$1 = { 56 57 8B F9 8D 8F 8C 00 00 00 E8 ?? ?? ?? ?? 8D B7 80 00 00 00 8B CE E8 ?? ?? ?? ?? FF 76 08 E8 ?? ?? ?? ?? 59 C7 07 ?? ?? ?? ?? 5F 5E C3 }
	condition:
		$1
}

rule file_91_35_0 {
	meta:
		name = "??1InternalContextBase@details@Concurrency@@UAE@XZ"
		size = 52
		refs = "0003 __ehhandler$??1InternalContextBase@details@Concurrency@@UAE@XZ 0008 __EH_prolog3 0014 ??_7InternalContextBase@details@Concurrency@@6BIExecutionContext@2@@ 001a ??_7InternalContextBase@details@Concurrency@@6BContextBase@12@@ 0023 ?Cleanup@InternalContextBase@details@Concurrency@@IAEXXZ 002a ??1ContextBase@details@Concurrency@@UAE@XZ 002f __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 4D F0 8D 71 04 C7 01 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 83 65 FC 00 E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_91_49_0 {
	meta:
		name = "??4Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEAAV0123@ABV0123@@Z"
		size = 22
		altNames = "??0?$_Network_link_iterator@V?$ISource@I@Concurrency@@@Concurrency@@QAE@ABV01@@Z ??0?$_Network_link_iterator@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@QAE@ABV01@@Z ??0DName@@QAE@ABV0@@Z ??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@ABV0123@@Z ??4DName@@QAEAAV0@ABV0@@Z ??4Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEAAV0123@ABV0123@@Z"
	strings:
		$1 = { 55 8B EC 8B 55 08 8B 02 89 01 8B 42 04 89 41 04 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_91_61_0 {
	meta:
		name = "??_GCancellationBeaconNode@CancellationBeaconStack@ContextBase@details@Concurrency@@QAEPAXI@Z"
		size = 34
		refs = "0009 ??_V@YAXPAX@Z 0016 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 FF 36 E8 ?? ?? ?? ?? F6 45 08 01 59 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_71_0 {
	meta:
		name = "?AddToRunnables@InternalContextBase@details@Concurrency@@MAEXVlocation@3@@Z"
		size = 379
		refs = "000c ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0028 ?_Assign@location@Concurrency@@QAEXABV12@@Z 0053 ?GetScheduler@ContextBase@details@Concurrency@@QBEPAVSchedulerBase@23@XZ 0068 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 00d1 ?GetScheduleGroup@ContextBase@details@Concurrency@@QBEPAVScheduleGroupBase@23@XZ 00ee ?Push@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z 0124 ?StartupVirtualProcessor@SchedulerBase@details@Concurrency@@QAE_NPAVScheduleGroupSegmentBase@23@Vlocation@3@K@Z 014e ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 016e ?AddRunnableContext@ScheduleGroupSegmentBase@details@Concurrency@@IAEXPAVInternalContextBase@23@Vlocation@3@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 1C 53 56 57 8B F9 E8 ?? ?? ?? ?? 8B 57 20 8B D8 83 BA B8 01 00 00 00 7E 1F 83 EC 10 8D 45 08 8B CC 50 E8 ?? ?? ?? ?? 8B 4F 20 57 8B 01 FF 50 3C 84 C0 0F 85 35 01 00 00 85 DB 0F 84 16 01 00 00 8A 43 4C 84 C0 0F 85 0B 01 00 00 8B CB E8 ?? ?? ?? ?? 39 47 20 0F 85 FB 00 00 00 8B C3 8B CB 89 45 F8 E8 ?? ?? ?? ?? 8B 47 1C 8B 80 00 01 00 00 F6 40 30 02 0F 85 D5 00 00 00 8B 83 9C 00 00 00 8B 88 90 00 00 00 8B F1 8B 47 1C 83 E1 1F C1 EE 05 8B 50 20 33 C0 40 D3 E0 85 04 B2 0F 84 AD 00 00 00 8B 83 9C 00 00 00 8B 48 14 2B 48 10 8B 47 20 0F B7 40 10 3B C8 0F 8D 92 00 00 00 8B 47 1C 8B CB 89 45 FC 8B B0 00 01 00 00 E8 ?? ?? ?? ?? 3B C6 74 0A C7 87 E4 00 00 00 01 00 00 00 8B 8B 9C 00 00 00 57 83 C1 10 E8 ?? ?? ?? ?? 8B 47 20 83 B8 B4 01 00 00 00 7E 2C 8D 45 08 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 77 20 8D 45 E4 6A 0B 83 EC 10 8B CC 50 E8 ?? ?? ?? ?? 8B 5D FC 8B CE 53 E8 ?? ?? ?? ?? EB 03 8B 5D FC 8B B3 00 01 00 00 8B 5D F8 8B CB E8 ?? ?? ?? ?? 3B C6 74 0A C7 87 E4 00 00 00 00 00 00 00 8B CB E8 ?? ?? ?? ?? EB 1E 8B CB E8 ?? ?? ?? ?? 83 EC 10 8D 45 08 8B CC 50 E8 ?? ?? ?? ?? 8B 4F 1C 57 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_91_72_0 {
	meta:
		name = "?Alloc@InternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 81
		refs = "0003 __ehhandler$?Alloc@InternalContextBase@details@Concurrency@@UAEPAXI@Z 0008 __EH_prolog3 001d ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 002c ?GetCurrentSubAllocator@VirtualProcessor@details@Concurrency@@QAEPAVSubAllocator@23@XZ 0036 ?Alloc@SubAllocator@details@Concurrency@@QAEPAXI@Z 0043 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 004a __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 8D 7E FC F7 DF 1B FF 23 FE 8B CF 89 7D F0 E8 ?? ?? ?? ?? 8B 8E 9C 00 00 00 83 65 FC 00 E8 ?? ?? ?? ?? FF 75 08 8B C8 E8 ?? ?? ?? ?? 83 4D FC FF 8B CF 8B F0 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_91_75_0 {
	meta:
		name = "?Block@InternalContextBase@details@Concurrency@@UAEXXZ"
		size = 294
		refs = "000b ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0022 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 005d ?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z 008a ?FindWorkForBlockingOrNesting@InternalContextBase@details@Concurrency@@AAEPAV123@AA_N0@Z 00b0 ?PrepareForUse@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupSegmentBase@23@PAU_Chore@23@_N@Z 00ba ?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z 00d0 ?ReleaseInternalContext@SchedulerBase@details@Concurrency@@QAEXPAVInternalContextBase@23@_N@Z 00e5 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 00f0 ?_PrepareSteal@_UnrealizedChore@details@Concurrency@@QAEXPAVContextBase@23@@Z 00ff ?GetScheduleGroupSegment@ContextBase@details@Concurrency@@QBEPAVScheduleGroupSegmentBase@23@XZ 010d ?_Assign@location@Concurrency@@QAEXABV12@@Z"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 8B F9 E8 ?? ?? ?? ?? 8B 4F 1C FF 77 08 8B 01 FF 50 04 50 6A 04 6A 03 8B CF E8 ?? ?? ?? ?? 8B 87 9C 00 00 00 33 F6 46 8A 80 AD 00 00 00 84 C0 8B C6 74 2B 8D 57 2C F0 0F C1 02 40 3B C6 75 10 6A 02 59 8B C6 F0 0F B1 0A 3B C6 75 03 56 EB 02 6A 02 8D 4F FC E8 ?? ?? ?? ?? E9 B2 00 00 00 8D 4F 2C F0 0F C1 01 40 3B C6 0F 85 A2 00 00 00 8D 4D FE C6 45 FF 00 51 8D 4D FF C6 45 FE 00 51 8D 4F FC E8 ?? ?? ?? ?? 6A 02 8B D8 8D 57 2C 59 8B C6 F0 0F B1 0A 3B C6 75 20 80 7D FF 00 74 0E 6A 00 6A 00 FF 77 18 8B CB E8 ?? ?? ?? ?? 56 53 8D 4F FC E8 ?? ?? ?? ?? EB 58 85 DB 74 54 80 7D FF 00 74 0C 8B 4F 1C 56 53 E8 ?? ?? ?? ?? EB 42 80 7D FE 00 74 1F 8B B3 A8 00 00 00 8B CF E8 ?? ?? ?? ?? 8D 43 04 8B CE 50 E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 8D 4B 04 E8 ?? ?? ?? ?? 83 EC 10 83 C0 0C 8B CC 50 E8 ?? ?? ?? ?? 8B 03 8B CB FF 50 14 8B CF E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_91_76_0 {
	meta:
		name = "?Cancel@InternalContextBase@details@Concurrency@@MAEXXZ"
		size = 116
		refs = "002c ?ClaimExclusiveOwnership@VirtualProcessor@details@Concurrency@@QAE_NAAVClaimTicket@123@K_N@Z 003d ?ExerciseClaim@VirtualProcessor@details@Concurrency@@AAE_NW4AvailabilityType@123@PAVScheduleGroupSegmentBase@23@PAVInternalContextBase@23@@Z 0047 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 005b ?SpinUntilBlocked@InternalContextBase@details@Concurrency@@IAEXXZ 0062 ?Cleanup@InternalContextBase@details@Concurrency@@IAEXXZ 006a ?DecrementInternalContextCount@SchedulerBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 51 56 57 8B F9 33 F6 39 B7 A0 00 00 00 74 30 6A 01 6A 0F 8D 45 F8 C6 87 B0 00 00 00 01 8B 8F A0 00 00 00 50 89 75 F8 E8 ?? ?? ?? ?? 84 C0 74 3A 8B 4D FC 56 56 FF 75 F8 E8 ?? ?? ?? ?? EB 2B 8D 77 04 E8 ?? ?? ?? ?? 3B C6 75 09 C6 87 B0 00 00 00 01 EB 16 8B CF E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 8B 4F 20 E8 ?? ?? ?? ?? 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_91_77_0 {
	meta:
		name = "?Cleanup@InternalContextBase@details@Concurrency@@IAEXXZ"
		size = 24
		refs = "0007 ?Cleanup@ContextBase@details@Concurrency@@QAEXXZ 0012 ?SwapScheduleGroupSegment@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupSegmentBase@23@_N@Z"
	strings:
		$1 = { 56 8B F1 8D 4E 04 E8 ?? ?? ?? ?? 6A 00 6A 00 8B CE E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_91_78_0 {
	meta:
		name = "?CleanupDispatchedContextOnCancel@InternalContextBase@details@Concurrency@@IAEXXZ"
		size = 27
		refs = "0007 ?EnterHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 000e ?Cleanup@InternalContextBase@details@Concurrency@@IAEXXZ 0017 ?DecrementInternalContextCount@SchedulerBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 56 8B F1 8D 4E 04 E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 8B 4E 20 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_79_0 {
	meta:
		name = "?ClearQuickCacheSlot@SchedulerBase@details@Concurrency@@QAEXI@Z"
		size = 37
	strings:
		$1 = { 55 8B EC 8B 51 5C 33 C0 56 8B 75 08 40 C1 E6 07 39 04 16 75 0B 8B 49 5C 33 D2 03 CE F0 0F B1 11 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_81_0 {
	meta:
		name = "?CrossGroupRunnable@InternalContextBase@details@Concurrency@@QAEXJ@Z"
		size = 16
	strings:
		$1 = { 55 8B EC 8B 45 08 89 81 E4 00 00 00 5D C2 04 00 }
	condition:
		$1
}

rule file_91_84_0 {
	meta:
		name = "?Dispatch@InternalContextBase@details@Concurrency@@UAEXPAUDispatchState@3@@Z"
		size = 372
		refs = "0003 __ehhandler$?Dispatch@InternalContextBase@details@Concurrency@@UAEXPAUDispatchState@3@@Z 0008 __EH_prolog3 0016 __imp__GetCurrentThreadId@0 0023 ?SetAsCurrentTls@ContextBase@details@Concurrency@@IAEXXZ 0043 ?GetPolicyValue@SchedulerPolicy@Concurrency@@QBEIW4PolicyElementKey@2@@Z 004c ?GetOSVersion@Concurrency@@YA?AW4OSVersion@IResourceManager@1@XZ 0063 ??1SchedulerPolicy@Concurrency@@QAE@XZ 0070 ?RoInitialize@WinRT@details@Concurrency@@SAJW4RO_INIT_TYPE@@@Z 0078 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0088 ?ExecutedAssociatedChore@InternalContextBase@details@Concurrency@@IAE_NXZ 0093 ?IsVirtualProcessorRetired@InternalContextBase@details@Concurrency@@IAE_NXZ 00c8 ?SafePoint@VirtualProcessor@details@Concurrency@@QAE_NXZ 00d3 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 00db ?CommitSafePoints@SchedulerBase@details@Concurrency@@QAEXXZ 00ed ?WorkWasFound@InternalContextBase@details@Concurrency@@IAE_NPAVWorkItem@23@@Z 0102 ?ExecuteChoreInline@InternalContextBase@details@Concurrency@@IAEXPAVWorkItem@23@@Z 0114 ?WaitForWork@InternalContextBase@details@Concurrency@@IAEXXZ 0124 ?CleanupDispatchedContextOnCancel@InternalContextBase@details@Concurrency@@IAEXXZ 013a ?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z 0143 ?RoUninitialize@WinRT@details@Concurrency@@SAXXZ 014a ?ClearContextTls@ContextBase@details@Concurrency@@AAEXXZ 014f __EH_epilog3 0161 ??0nested_scheduler_missing_detach@Concurrency@@QAE@XZ 0166 __TI2?AVnested_scheduler_missing_detach@Concurrency@@ 016f __CxxThrowException@8"
	strings:
		$1 = { 6A 20 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 83 65 F0 00 32 FF FF 15 ?? ?? ?? ?? 8D 7E 04 89 46 48 8B CF E8 ?? ?? ?? ?? 8B 4E 20 8D 55 EC 52 8B 01 FF 50 0C 83 65 FC 00 8B C8 6A 09 C7 45 F0 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 0E E8 ?? ?? ?? ?? 83 F8 06 75 04 B3 01 EB 02 32 DB 83 4D FC FF 8D 4D EC E8 ?? ?? ?? ?? 84 DB 74 0A 6A 01 B7 01 E8 ?? ?? ?? ?? 59 8B CF E8 ?? ?? ?? ?? 83 A6 AC 00 00 00 00 8B CE 32 DB E8 ?? ?? ?? ?? 84 C0 74 0E 8B CE E8 ?? ?? ?? ?? 8A D8 E9 8C 00 00 00 80 A6 B3 00 00 00 FD 33 C0 89 45 E0 89 45 E8 39 86 A0 00 00 00 0F 84 9D 00 00 00 38 86 B2 00 00 00 75 25 8B 8E A0 00 00 00 E8 ?? ?? ?? ?? 84 C0 74 16 8B CF E8 ?? ?? ?? ?? 8B 4E 20 E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 8D 45 E0 8B CE 50 E8 ?? ?? ?? ?? 8B CE 84 C0 74 11 83 7D E0 01 74 37 8D 45 E0 50 E8 ?? ?? ?? ?? EB 88 E8 ?? ?? ?? ?? 84 C0 75 2D 8B CE E8 ?? ?? ?? ?? 80 BE B0 00 00 00 00 74 09 8B CE E8 ?? ?? ?? ?? B3 01 84 DB 0F 84 6C FF FF FF EB 0A 6A 00 FF 75 E8 E8 ?? ?? ?? ?? 84 FF 74 05 E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C2 04 00 8B CF E8 ?? ?? ?? ?? 8D 4D D4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 D4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_91_85_0 {
	meta:
		name = "__unwindfunclet$?Dispatch@InternalContextBase@details@Concurrency@@UAEXPAUDispatchState@3@@Z$0"
		size = 25
		refs = "0014 ??1SchedulerPolicy@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0C 00 00 00 83 65 F0 FE 8D 4D EC E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_91_86_0 {
	meta:
		name = "__ehhandler$?Dispatch@InternalContextBase@details@Concurrency@@UAEXPAUDispatchState@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Dispatch@InternalContextBase@details@Concurrency@@UAEXPAUDispatchState@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_408_1 {
	meta:
		name = "__ehhandler$?do_get_date@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_date@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_1033_1 {
	meta:
		name = "__ehhandler$?do_get_date@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_date@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_1036_1 {
	meta:
		name = "__ehhandler$?do_get_date@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_date@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_444_1 {
	meta:
		name = "__ehhandler$?do_transform@?$collate@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@PBD0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_transform@?$collate@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@PBD0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_1148_1 {
	meta:
		name = "__ehhandler$?do_transform@?$collate@G@std@@MBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@PBG0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_transform@?$collate@G@std@@MBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@PBG0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_1151_1 {
	meta:
		name = "__ehhandler$?do_transform@?$collate@_W@std@@MBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@PB_W0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_transform@?$collate@_W@std@@MBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@PB_W0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_797_131_0 {
	meta:
		name = "__ehhandler$?notify_one@_Condition_variable@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?notify_one@_Condition_variable@details@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_1237_1 {
	meta:
		name = "__ehhandler$?remove@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE_NPAV?$ISource@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?remove@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE_NPAV?$ISource@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_1240_1 {
	meta:
		name = "__ehhandler$?remove@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE_NPAV?$ISource@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?remove@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE_NPAV?$ISource@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_797_134_0 {
	meta:
		name = "__ehhandler$?reset@event@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?reset@event@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_89_0 {
	meta:
		name = "?ExecuteChoreInline@InternalContextBase@details@Concurrency@@IAEXPAVWorkItem@23@@Z"
		size = 61
		refs = "000b ?TransferReferences@WorkItem@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z 001e ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0026 ?Invoke@WorkItem@details@Concurrency@@QAEXXZ 002d ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0034 ?ReleaseWorkQueue@ContextBase@details@Concurrency@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 56 E8 ?? ?? ?? ?? 8B 86 A0 00 00 00 83 C6 04 8B CE FF 40 6C E8 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_90_0 {
	meta:
		name = "?ExecutedAssociatedChore@InternalContextBase@details@Concurrency@@IAE_NXZ"
		size = 106
		refs = "0013 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 003e ?Invoke@RealizedChore@details@Concurrency@@QAEXXZ 004e ?ReleaseRealizedChore@SchedulerBase@details@Concurrency@@QAEXPAVRealizedChore@23@@Z 0056 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 005d ?ReleaseWorkQueue@ContextBase@details@Concurrency@@IAEXXZ"
	strings:
		$1 = { 57 8B F9 83 BF A8 00 00 00 00 74 5A 53 8D 5F 04 8B CB E8 ?? ?? ?? ?? 80 BF B1 00 00 00 00 74 14 8B 87 A8 00 00 00 50 FF 50 0C 83 A7 A8 00 00 00 00 59 EB 1F 56 8B B7 A8 00 00 00 8B CE E8 ?? ?? ?? ?? 8B 4F 20 83 A7 A8 00 00 00 00 56 E8 ?? ?? ?? ?? 5E 8B CB E8 ?? ?? ?? ?? 8B CB E8 ?? ?? ?? ?? 5B B0 01 5F C3 32 C0 5F C3 }
	condition:
		$1
}

rule file_91_91_0 {
	meta:
		name = "?Exercise@ClaimTicket@VirtualProcessor@details@Concurrency@@QAE_NPAVScheduleGroupSegmentBase@34@@Z"
		size = 29
		refs = "0011 ?ExerciseClaim@VirtualProcessor@details@Concurrency@@AAE_NW4AvailabilityType@123@PAVScheduleGroupSegmentBase@23@PAVInternalContextBase@23@@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 6A 00 FF 75 08 FF 36 8B 4E 04 E8 ?? ?? ?? ?? 83 26 00 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_94_0 {
	meta:
		name = "?FindWorkForBlockingOrNesting@InternalContextBase@details@Concurrency@@AAEPAV123@AA_N0@Z"
		size = 260
		refs = "0040 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 004a ?GetInternalContext@SchedulerBase@details@Concurrency@@QAEPAVInternalContextBase@23@_N@Z 0054 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0061 ?ResolveToken@WorkItem@details@Concurrency@@QAE_NXZ 007a ?BindTo@WorkItem@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z 00a9 ?ReleaseInternalContext@SchedulerBase@details@Concurrency@@QAEXPAVInternalContextBase@23@_N@Z 00d7 ?Bind@WorkItem@details@Concurrency@@QAEPAVInternalContextBase@23@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 8B D9 33 C9 57 6A 19 51 8B 83 A0 00 00 00 8B 53 1C 89 4D F4 89 4D FC 8D 4D F4 52 51 8D 48 28 FF 50 48 84 C0 0F 84 B3 00 00 00 83 7D F4 01 0F 84 A4 00 00 00 56 8D 4B 04 E8 ?? ?? ?? ?? 8B 4B 20 6A 01 E8 ?? ?? ?? ?? 8D 4B 04 8B F8 E8 ?? ?? ?? ?? 5E 85 FF 74 5A 8D 4D F4 E8 ?? ?? ?? ?? 84 C0 74 17 83 7D F4 04 8B 45 0C 0F 94 C1 57 88 08 8D 4D F4 E8 ?? ?? ?? ?? EB 7A 8B 4B 1C 8B 83 A0 00 00 00 6A 07 6A 00 51 8D 4D F4 51 8D 48 28 FF 50 48 84 C0 74 13 83 7D F4 01 75 C7 8B 4B 20 6A 01 57 E8 ?? ?? ?? ?? EB 24 8B 45 08 C6 00 01 EB 43 8B 4B 1C 8B 83 A0 00 00 00 6A 01 6A 00 51 8D 4D F4 51 8D 48 28 FF 50 48 84 C0 74 27 8D 4D F4 E8 ?? ?? ?? ?? 8B F8 EB 1B 8B 7D FC EB 16 8B 4B 20 6A 01 E8 ?? ?? ?? ?? 8B F8 8B 45 08 85 FF 0F 95 C1 88 08 8B C7 5F 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_91_95_0 {
	meta:
		name = "?Free@InternalContextBase@details@Concurrency@@UAEXPAX@Z"
		size = 44
		refs = "0007 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0012 ?GetCurrentSubAllocator@VirtualProcessor@details@Concurrency@@QAEPAVSubAllocator@23@XZ 001c ?Free@SubAllocator@details@Concurrency@@QAEXPAX@Z 0023 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? 8B 8E 9C 00 00 00 E8 ?? ?? ?? ?? FF 75 08 8B C8 E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_99_0 {
	meta:
		name = "?GetAndResetOversubscribedVProc@InternalContextBase@details@Concurrency@@QAEPAVVirtualProcessor@23@PAV423@@Z"
		size = 46
	strings:
		$1 = { 55 8B EC 8B 55 08 56 33 F6 85 D2 74 1A 57 8D B9 A4 00 00 00 3B 17 75 0E 33 C9 8B C2 F0 0F B1 0F 3B C2 75 02 8B F2 5F 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_101_0 {
	meta:
		name = "?GetCriticalRegionType@ContextBase@details@Concurrency@@UBE?AW4CriticalRegionType@3@XZ"
		size = 20
	strings:
		$1 = { 83 79 10 00 76 04 6A 02 58 C3 33 C0 3B 41 0C 1B C0 F7 D8 C3 }
	condition:
		$1
}

rule file_91_111_0 {
	meta:
		name = "?GetVirtualProcessorId@InternalContextBase@details@Concurrency@@UBEIXZ"
		size = 47
		refs = "0005 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0026 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 56 57 8B F1 E8 ?? ?? ?? ?? 83 BE 9C 00 00 00 00 74 0E 8B 86 9C 00 00 00 8B B8 88 00 00 00 EB 03 83 CF FF 8B CE E8 ?? ?? ?? ?? 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_91_112_0 {
	meta:
		name = "?GrowAndPush@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@AAEXPAVInternalContextBase@23@VSlot@?$Mailbox@VInternalContextBase@details@Concurrency@@@23@@Z"
		size = 361
		refs = "002d ??_U@YAPAXI@Z 0083 ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ 00f5 _memset 014a ?_Release@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ 0152 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 24 53 56 57 8B F9 33 C9 6A 04 5A 89 7D E8 8B 47 08 8D 1C 45 02 00 00 00 8B C3 89 5D EC F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 89 45 F4 33 C9 8B 47 0C 89 45 E0 8B C3 6A 08 5E F7 E6 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 89 45 F0 59 59 85 C0 74 17 8D 53 FF 8B C8 85 D2 78 12 83 21 00 83 61 04 00 03 CE 4A 79 F4 EB 04 83 65 F0 00 8B 77 14 8B CE 8B 47 10 89 45 DC 89 75 E4 E8 ?? ?? ?? ?? 8B 47 04 33 D2 8B 07 8B 5F 04 2B 1F 89 45 F8 89 55 FC 85 DB 7E 45 8B 75 F0 8B C8 8B 47 0C 23 4F 08 8B 04 88 8B 4D F4 89 04 91 8B 4F 10 8B 55 F8 23 57 08 8B 7D FC 8B 04 D1 89 04 FE 8B 44 D1 04 8B D7 8B 7D E8 89 44 D6 04 42 8B 45 F8 40 89 55 FC 89 45 F8 3B D3 7C C1 8B 75 E4 8B 45 EC 2B C3 C1 E0 02 50 8B 45 F4 6A 00 8D 04 98 50 E8 ?? ?? ?? ?? 8B 45 F4 83 C4 0C 8B 55 EC 89 47 0C 4A 8B 45 F0 89 47 10 8B 45 0C C7 07 00 00 00 00 89 57 08 85 C0 74 17 8B 4F 10 23 D3 89 04 D1 8B 45 10 89 44 D1 04 8B 55 08 83 CA 01 EB 03 8B 55 08 8B 47 0C 8B CB 23 4F 08 89 14 88 8D 43 01 8B CE 89 47 04 E8 ?? ?? ?? ?? FF 75 E0 E8 ?? ?? ?? ?? FF 75 DC E8 ?? ?? ?? ?? 59 59 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_190_145_0 {
	meta:
		name = "?GrowAndPush@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEXPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
		size = 361
		refs = "002d ??_U@YAPAXI@Z 0083 ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ 00f5 _memset 014a ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ 0152 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 24 53 56 57 8B F9 33 C9 6A 04 5A 89 7D E8 8B 47 08 8D 1C 45 02 00 00 00 8B C3 89 5D EC F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 89 45 F4 33 C9 8B 47 0C 89 45 E0 8B C3 6A 08 5E F7 E6 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 89 45 F0 59 59 85 C0 74 17 8D 53 FF 8B C8 85 D2 78 12 83 21 00 83 61 04 00 03 CE 4A 79 F4 EB 04 83 65 F0 00 8B 77 14 8B CE 8B 47 10 89 45 DC 89 75 E4 E8 ?? ?? ?? ?? 8B 47 04 33 D2 8B 07 8B 5F 04 2B 1F 89 45 F8 89 55 FC 85 DB 7E 45 8B 75 F0 8B C8 8B 47 0C 23 4F 08 8B 04 88 8B 4D F4 89 04 91 8B 4F 10 8B 55 F8 23 57 08 8B 7D FC 8B 04 D1 89 04 FE 8B 44 D1 04 8B D7 8B 7D E8 89 44 D6 04 42 8B 45 F8 40 89 55 FC 89 45 F8 3B D3 7C C1 8B 75 E4 8B 45 EC 2B C3 C1 E0 02 50 8B 45 F4 6A 00 8D 04 98 50 E8 ?? ?? ?? ?? 8B 45 F4 83 C4 0C 8B 55 EC 89 47 0C 4A 8B 45 F0 89 47 10 8B 45 0C C7 07 00 00 00 00 89 57 08 85 C0 74 17 8B 4F 10 23 D3 89 04 D1 8B 45 10 89 44 D1 04 8B 55 08 83 CA 01 EB 03 8B 55 08 8B 47 0C 8B CB 23 4F 08 89 14 88 8D 43 01 8B CE 89 47 04 E8 ?? ?? ?? ?? FF 75 E0 E8 ?? ?? ?? ?? FF 75 DC E8 ?? ?? ?? ?? 59 59 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_91_116_0 {
	meta:
		name = "?IncrementDequeuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QAEXI@Z"
		size = 41
		refs = "000b ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 001f ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 57 8D 4E 04 E8 ?? ?? ?? ?? 8B 96 A0 00 00 00 8D 4E 04 8B 45 08 01 42 6C E8 ?? ?? ?? ?? 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_117_0 {
	meta:
		name = "?IncrementEnqueuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QAEXXZ"
		size = 31
		refs = "0008 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 001b ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 56 8B F1 57 8D 4E 04 E8 ?? ?? ?? ?? 8B 86 A0 00 00 00 8D 4E 04 5F 5E FF 40 68 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_118_0 {
	meta:
		name = "?InterlockedClear@QuickBitSet@details@Concurrency@@QAEXI@Z"
		size = 36
	strings:
		$1 = { 55 8B EC 8B 41 04 8B 55 08 8B CA 56 33 F6 C1 EA 05 46 83 E1 1F D3 E6 F7 D6 8D 04 90 F0 21 30 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_119_0 {
	meta:
		name = "?InterlockedClear@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z"
		size = 66
		refs = "001d ?SpinUntilSet@QuickBitSet@details@Concurrency@@QBEXI@Z"
	strings:
		$1 = { 55 8B EC 53 8B D9 56 57 8B 7D 08 83 CE FF 8B 43 08 8D 04 B8 F0 0F C1 30 4E 75 1E 57 E8 ?? ?? ?? ?? 33 D2 8B CF 83 E1 1F C1 EF 05 42 D3 E2 8B 4B 04 F7 D2 8D 0C B9 F0 21 11 5F 8B C6 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_91_120_0 {
	meta:
		name = "?InterlockedSet@QuickBitSet@details@Concurrency@@QAEXI@Z"
		size = 34
	strings:
		$1 = { 55 8B EC 8B 41 04 8B 55 08 8B CA 56 33 F6 C1 EA 05 83 E1 1F 46 D3 E6 8D 04 90 F0 09 30 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_121_0 {
	meta:
		name = "?InterlockedSet@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z"
		size = 72
		refs = "0023 ?SpinUntilClear@QuickBitSet@details@Concurrency@@QBEXI@Z"
	strings:
		$1 = { 55 8B EC 51 8B 41 08 53 8B 5D 08 56 57 33 FF 89 4D FC 47 8D 04 98 8B F7 F0 0F C1 30 46 3B F7 75 1C 53 E8 ?? ?? ?? ?? 8B CB C1 EB 05 83 E1 1F D3 E7 8B 4D FC 8B 49 04 8D 0C 99 F0 09 39 5F 8B C6 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_91_122_0 {
	meta:
		name = "?InternalReference@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
		size = 18
	strings:
		$1 = { 33 C0 F6 41 30 04 75 09 83 C1 14 40 F0 0F C1 01 40 C3 }
	condition:
		$1
}

rule file_91_123_0 {
	meta:
		name = "?InternalRelease@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
		size = 46
		refs = "0021 ?RemoveScheduleGroup@SchedulerBase@details@Concurrency@@QAEXPAVScheduleGroupBase@23@@Z"
	strings:
		$1 = { 56 8B F1 F6 46 30 04 75 21 57 8D 46 14 83 CF FF F0 0F C1 38 4F 75 0E 8B 16 FF 52 1C 8B 4E 04 56 E8 ?? ?? ?? ?? 8B C7 5F 5E C3 33 C0 5E C3 }
	condition:
		$1
}

rule file_91_131_0 {
	meta:
		name = "?IsSet@QuickBitSet@details@Concurrency@@QBE_NI@Z"
		size = 43
	strings:
		$1 = { 55 8B EC 8B 41 04 33 D2 56 8B 75 08 42 57 8B FE 83 E6 1F C1 EF 05 8B CE D3 E2 8B 04 B8 23 C2 F7 D8 5F 1B C0 F7 D8 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_134_0 {
	meta:
		name = "?IsVirtualProcessorRetired@InternalContextBase@details@Concurrency@@IAE_NXZ"
		size = 94
		refs = "0037 ?InterlockedClear@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z 0047 ?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z 0052 ?CleanupDispatchedContextOnCancel@InternalContextBase@details@Concurrency@@IAEXXZ"
	strings:
		$1 = { 56 8B F1 80 BE B2 00 00 00 00 75 4E 8B 86 A0 00 00 00 80 B8 AD 00 00 00 00 74 3F 83 BE AC 00 00 00 00 76 17 8B 86 A0 00 00 00 8B 4E 20 83 C1 3C FF B0 90 00 00 00 E8 ?? ?? ?? ?? 83 A6 AC 00 00 00 00 8B CE 6A 00 E8 ?? ?? ?? ?? 84 C0 74 07 8B CE E8 ?? ?? ?? ?? B0 01 5E C3 32 C0 5E C3 }
	condition:
		$1
}

rule file_91_135_0 {
	meta:
		name = "?LeaveScheduler@InternalContextBase@details@Concurrency@@AAEXXZ"
		size = 216
		refs = "0011 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0028 ?FindWorkForBlockingOrNesting@InternalContextBase@details@Concurrency@@AAEPAV123@AA_N0@Z 003f ?PrepareForUse@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupSegmentBase@23@PAU_Chore@23@_N@Z 0046 ?EnterHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 00a2 ?MakeAvailable@VirtualProcessor@details@Concurrency@@IAEXW4AvailabilityType@123@_N@Z 00aa ?DeferredGetInternalContext@SchedulerBase@details@Concurrency@@QAEXXZ 00c6 ?ExitHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 00cd ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 56 8B F1 57 8D 5E 04 8B CB E8 ?? ?? ?? ?? 8D 45 FE C6 45 FF 00 50 8D 45 FF C6 45 FE 00 50 8B CE E8 ?? ?? ?? ?? 80 7D FF 00 89 45 F4 74 0E 6A 00 6A 00 FF 76 1C 8B C8 E8 ?? ?? ?? ?? 8B CB E8 ?? ?? ?? ?? 8B 86 A0 00 00 00 8B 4E 20 89 4D EC 8B 4D F4 C7 86 A0 00 00 00 00 00 00 00 8B BE 9C 00 00 00 89 45 F8 89 4D F0 85 C9 75 0E 8B 00 8B 4D F8 FF 50 04 89 45 F0 8B 45 F8 33 D2 8D 4E 2C 42 87 11 8B 10 8B C8 FF 75 F4 FF 52 10 8B 4D F0 85 C9 75 1F 8B 4D F8 6A 01 6A 04 E8 ?? ?? ?? ?? 8B 4D EC E8 ?? ?? ?? ?? 8B 07 8B CF 6A 02 FF 50 08 EB 0A 8B 07 6A 02 51 8B CF FF 50 04 8B CB E8 ?? ?? ?? ?? 8B CB E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_91_138_0 {
	meta:
		name = "?NotifySearching@SchedulerBase@details@Concurrency@@QAEXI_N@Z"
		size = 45
		refs = "0013 ?InterlockedSet@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z 001d ?ClearQuickCacheSlot@SchedulerBase@details@Concurrency@@QAEXI@Z 0024 ?InterlockedClear@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z"
	strings:
		$1 = { 55 8B EC 80 7D 0C 00 56 FF 75 08 8B F1 8D 4E 3C 74 11 E8 ?? ?? ?? ?? FF 75 08 8B CE E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_91_139_0 {
	meta:
		name = "?Oversubscribe@InternalContextBase@details@Concurrency@@UAEX_N@Z"
		size = 118
		refs = "0019 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 002b ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0049 ?GetAndResetOversubscribedVProc@InternalContextBase@details@Concurrency@@QAEPAVVirtualProcessor@23@PAV423@@Z 0054 ?MarkForRetirement@VirtualProcessor@details@Concurrency@@AAEXXZ 0063 ??0invalid_oversubscribe_operation@Concurrency@@QAE@XZ 0068 __TI2?AVinvalid_oversubscribe_operation@Concurrency@@ 0071 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 0C 80 7D 08 00 56 8B F1 74 22 FF 46 14 83 7E 14 01 75 40 E8 ?? ?? ?? ?? 8B 8E 9C 00 00 00 8B 01 FF 50 20 8B CE E8 ?? ?? ?? ?? EB 27 8B 46 14 85 C0 74 27 48 89 46 14 75 1A 8B 86 A0 00 00 00 8D 4E FC 50 E8 ?? ?? ?? ?? 85 C0 74 07 8B C8 E8 ?? ?? ?? ?? 5E 8B E5 5D C2 04 00 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_91_140_0 {
	meta:
		name = "?PrepareForUse@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupSegmentBase@23@PAU_Chore@23@_N@Z"
		size = 105
	strings:
		$1 = { 55 8B EC 8B 45 08 8B D1 56 8B 75 0C C6 82 EC 00 00 00 00 89 42 1C 85 F6 75 18 8B 80 00 01 00 00 F6 40 30 04 75 3E 33 C9 83 C0 14 41 F0 0F C1 08 EB 32 80 7D 10 00 74 1F 8B 80 00 01 00 00 F6 40 30 04 75 0A 33 C9 83 C0 14 41 F0 0F C1 08 C6 82 B1 00 00 00 01 EB 07 C6 82 B1 00 00 00 00 89 B2 A8 00 00 00 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_91_141_0 {
	meta:
		name = "?PrepareToRun@InternalContextBase@details@Concurrency@@MAEXPAVVirtualProcessor@23@@Z"
		size = 23
	strings:
		$1 = { 55 8B EC 8B 45 08 33 D2 89 81 A0 00 00 00 8D 41 2C 87 10 5D C2 04 00 }
	condition:
		$1
}

rule file_91_142_0 {
	meta:
		name = "?Push@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z"
		size = 65
		refs = "0037 ?GrowAndPush@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@AAEXPAVInternalContextBase@23@VSlot@?$Mailbox@VInternalContextBase@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 8B D1 56 57 8B 7A 04 8B 02 8B 72 08 03 C6 3B F8 7D 13 8B 4A 0C 23 F7 8B 45 08 89 04 B1 8D 47 01 89 42 04 EB 13 51 51 8B C4 FF 75 08 83 20 00 83 60 04 00 E8 ?? ?? ?? ?? 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_190_180_0 {
	meta:
		name = "?Push@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"
		size = 65
		refs = "0037 ?GrowAndPush@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEXPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 8B D1 56 57 8B 7A 04 8B 02 8B 72 08 03 C6 3B F8 7D 13 8B 4A 0C 23 F7 8B 45 08 89 04 B1 8D 47 01 89 42 04 EB 13 51 51 8B C4 FF 75 08 83 20 00 83 60 04 00 E8 ?? ?? ?? ?? 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_144_0 {
	meta:
		name = "?ReclaimVirtualProcessor@InternalContextBase@details@Concurrency@@IAEXXZ"
		size = 81
		refs = "0024 ?ClaimExclusiveOwnership@VirtualProcessor@details@Concurrency@@QAE_NAAVClaimTicket@123@K_N@Z 003d ?Deactivate@VirtualProcessor@details@Concurrency@@QAE_NPAUIExecutionContext@3@@Z"
	strings:
		$1 = { 55 8B EC 51 51 56 8B F1 80 BE B2 00 00 00 00 74 3B 8B 8E A0 00 00 00 8D 45 F8 83 65 F8 00 6A 01 6A 0F 50 E8 ?? ?? ?? ?? 84 C0 75 19 EB 07 8B 06 8B CE FF 50 20 8B 8E A0 00 00 00 56 E8 ?? ?? ?? ?? 84 C0 74 E9 C6 86 B2 00 00 00 00 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_91_145_0 {
	meta:
		name = "?RejoinScheduler@InternalContextBase@details@Concurrency@@AAEXXZ"
		size = 31
		refs = "0008 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0011 ?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z 001b ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 56 8B F1 57 8D 4E 04 E8 ?? ?? ?? ?? 6A 03 8B CE E8 ?? ?? ?? ?? 5F 8D 4E 04 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_146_0 {
	meta:
		name = "?RemoveFromUse@InternalContextBase@details@Concurrency@@QAEXXZ"
		size = 35
		refs = "0007 ?ReleaseWorkQueue@ContextBase@details@Concurrency@@IAEXXZ 0012 ?SwapScheduleGroupSegment@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupSegmentBase@23@_N@Z"
	strings:
		$1 = { 56 8B F1 8D 4E 04 E8 ?? ?? ?? ?? 6A 00 6A 00 8B CE E8 ?? ?? ?? ?? 83 66 48 00 C6 86 EC 00 00 00 01 5E C3 }
	condition:
		$1
}

rule file_91_148_0 {
	meta:
		name = "?SearchForWork@VirtualProcessor@details@Concurrency@@QAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_N@Z"
		size = 26
	strings:
		$1 = { 55 8B EC 6A 07 FF 75 10 8D 41 28 FF 75 0C 8B C8 FF 75 08 FF 50 20 5D C2 0C 00 }
	condition:
		$1
}

rule file_91_151_0 {
	meta:
		name = "?SetProxy@InternalContextBase@details@Concurrency@@UAEXPAUIThreadProxy@3@@Z"
		size = 66
		refs = "001f ??_C@_0N@FACDCNDA@pThreadProxy?$AA@ 0028 ??0exception@std@@QAE@ABQBD@Z 002d __TI3?AVinvalid_argument@std@@ 0037 ??_7invalid_argument@std@@6B@ 003d __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 0C 85 C0 74 0C 89 81 9C 00 00 00 8B E5 5D C2 04 00 8D 45 08 C7 45 08 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 C7 45 F4 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_91_152_0 {
	meta:
		name = "?SpinUntilBlocked@InternalContextBase@details@Concurrency@@IAEXXZ"
		size = 45
		refs = "0016 ?_Sleep0@details@Concurrency@@YAXXZ 001e ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 10 56 8B F1 83 7E 2C 00 75 19 83 65 F8 00 C7 45 FC ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 83 7E 2C 00 74 F2 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_91_153_0 {
	meta:
		name = "?SpinUntilClear@QuickBitSet@details@Concurrency@@QBEXI@Z"
		size = 74
		refs = "002c ?_Sleep0@details@Concurrency@@YAXXZ 0036 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 10 53 8B 59 04 56 8B F0 83 E0 1F 57 33 FF C1 EE 05 47 8B C8 D3 E7 8B 04 B3 85 C7 74 1C 83 65 F8 00 C7 45 FC ?? ?? ?? ?? EB 08 8D 4D F0 E8 ?? ?? ?? ?? 8B 04 B3 85 C7 75 F1 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_91_154_0 {
	meta:
		name = "?SpinUntilSet@QuickBitSet@details@Concurrency@@QBEXI@Z"
		size = 74
		refs = "002c ?_Sleep0@details@Concurrency@@YAXXZ 0036 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 10 53 8B 59 04 56 8B F0 83 E0 1F 57 33 FF C1 EE 05 47 8B C8 D3 E7 8B 04 B3 85 C7 75 1C 83 65 F8 00 C7 45 FC ?? ?? ?? ?? EB 08 8D 4D F0 E8 ?? ?? ?? ?? 8B 04 B3 85 C7 74 F1 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_91_155_0 {
	meta:
		name = "?SpinUntilValueEquals@details@Concurrency@@YAXPCJJ@Z"
		size = 47
		refs = "0019 ?_Sleep0@details@Concurrency@@YAXXZ 0021 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 10 56 8B 75 0C 57 8B 7D 08 39 37 74 17 83 65 F8 00 C7 45 FC ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 39 37 75 F4 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_91_156_0 {
	meta:
		name = "?SpinYield@InternalContextBase@details@Concurrency@@UAEXXZ"
		size = 146
		refs = "000d ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0024 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 003e ?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z 006e ?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z 0079 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 8B F1 33 DB E8 ?? ?? ?? ?? 8B 4E 1C FF 76 08 8B 01 FF 50 04 50 6A 04 6A 05 8B CE E8 ?? ?? ?? ?? 8B 86 9C 00 00 00 8A 80 AD 00 00 00 84 C0 74 0C 6A 02 8D 4E FC E8 ?? ?? ?? ?? EB 32 8B 4E 18 8B 86 9C 00 00 00 6A 01 53 51 8D 4D F4 89 5D F4 51 8D 48 28 89 5D FC FF 50 48 84 C0 74 0F 6A 02 FF 75 FC 8D 4E FC E8 ?? ?? ?? ?? EB 02 B3 01 8B CE E8 ?? ?? ?? ?? 84 DB 74 0B 8B 8E 98 00 00 00 8B 01 FF 50 0C 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_91_157_0 {
	meta:
		name = "?StartupIdleVirtualProcessor@SchedulerBase@details@Concurrency@@QAE_NPAVScheduleGroupSegmentBase@23@Vlocation@3@@Z"
		size = 40
		refs = "0013 ?_Assign@location@Concurrency@@QAEXABV12@@Z 001d ?StartupVirtualProcessor@SchedulerBase@details@Concurrency@@QAE_NPAVScheduleGroupSegmentBase@23@Vlocation@3@K@Z"
	strings:
		$1 = { 55 8B EC 51 56 6A 0B 83 EC 10 8D 45 0C 8B F1 8B CC 50 E8 ?? ?? ?? ?? FF 75 08 8B CE E8 ?? ?? ?? ?? 5E 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_91_158_0 {
	meta:
		name = "?SwapScheduleGroupSegment@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupSegmentBase@23@_N@Z"
		size = 81
		refs = "0016 ?SpinUntilValueEquals@details@Concurrency@@YAXPCJJ@Z 0026 ?InternalRelease@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 83 7E 1C 00 74 40 8D 86 E4 00 00 00 6A 00 50 E8 ?? ?? ?? ?? 59 59 8B 4E 1C 8B 89 00 01 00 00 E8 ?? ?? ?? ?? 80 7D 0C 00 8B 55 08 74 16 8B 82 00 01 00 00 F6 40 30 04 75 0A 33 C9 83 C0 14 41 F0 0F C1 08 89 56 1C 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_91_159_0 {
	meta:
		name = "?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z"
		size = 238
		refs = "0025 ?ReclaimVirtualProcessor@InternalContextBase@details@Concurrency@@IAEXXZ 003c ?EnterHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0059 ?ExitHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 007b ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 0084 ?ReleaseInternalContext@ScheduleGroupSegmentBase@details@Concurrency@@IAEXPAVInternalContextBase@23@@Z 0090 ?TriggerCommitSafePoints@SchedulerBase@details@Concurrency@@QAEXPAVSafePointMarker@23@@Z 0099 ?VirtualProcessorActive@SchedulerBase@details@Concurrency@@QAE_N_N@Z 00c6 ?_Assign@location@Concurrency@@QAEXABV12@@Z 00cf ?AddRunnableContext@ScheduleGroupSegmentBase@details@Concurrency@@IAEXPAVInternalContextBase@23@Vlocation@3@@Z"
	strings:
		$1 = { 55 8B EC 51 51 53 56 8B F1 33 DB 57 8B 7D 08 8B 86 9C 00 00 00 89 45 F8 39 9E A0 00 00 00 0F 84 8B 00 00 00 E8 ?? ?? ?? ?? 8B 86 A0 00 00 00 8D 4E 04 8B 80 C0 00 00 00 89 45 FC E8 ?? ?? ?? ?? 8B 8E A0 00 00 00 8B 01 FF 50 0C 89 9E A0 00 00 00 85 FF 74 12 8D 4E 04 E8 ?? ?? ?? ?? 33 C9 8D 46 2C 41 87 08 EB 21 8B 4E 20 FF 76 0C 8B 01 FF 50 04 50 6A 04 6A 06 8D 4E 04 E8 ?? ?? ?? ?? 8B 4E 1C 56 E8 ?? ?? ?? ?? 8B 4E 20 8D 45 FC 50 E8 ?? ?? ?? ?? 8B 4E 20 53 E8 ?? ?? ?? ?? 8A 9E B0 00 00 00 85 FF 75 08 33 C9 8D 46 2C 41 87 08 83 FF 02 74 05 83 FF 03 75 1A 8B 46 1C 83 EC 10 83 C0 0C 8B CC 50 E8 ?? ?? ?? ?? 8B 4E 1C 56 E8 ?? ?? ?? ?? 85 FF 74 0C 8B 45 F8 8B C8 6A 01 8B 10 FF 52 08 5F 5E 8A C3 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_91_160_0 {
	meta:
		name = "?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z"
		size = 249
		refs = "0031 ?_Assign@location@Concurrency@@QAEXABV12@@Z 003a ?AddRunnableContext@ScheduleGroupSegmentBase@details@Concurrency@@IAEXPAVInternalContextBase@23@Vlocation@3@@Z 0054 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 005d ?ReleaseInternalContext@ScheduleGroupSegmentBase@details@Concurrency@@IAEXPAVInternalContextBase@23@@Z 0067 ?EnterHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 00c3 ?MakeAvailable@VirtualProcessor@details@Concurrency@@IAEXW4AvailabilityType@123@_N@Z 00cb ?DeferredGetInternalContext@SchedulerBase@details@Concurrency@@QAEXXZ 00ec ?ExitHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 55 8B EC 8B 45 0C 83 EC 0C 53 56 57 33 FF 8B F1 47 83 E8 00 74 2A 48 74 4A 48 74 08 48 75 44 6A 02 5F EB 3F 8B 46 1C 83 EC 10 83 C0 0C 8B CC 50 E8 ?? ?? ?? ?? 8B 4E 1C 56 E8 ?? ?? ?? ?? EB 23 8B 4E 20 FF 76 0C 8B 01 FF 50 04 50 6A 04 6A 06 8D 4E 04 E8 ?? ?? ?? ?? 8B 4E 1C 56 E8 ?? ?? ?? ?? 33 FF 8D 4E 04 E8 ?? ?? ?? ?? 8B 86 A0 00 00 00 8B 4E 20 89 4D F4 8B 4D 08 C7 86 A0 00 00 00 00 00 00 00 8B 9E 9C 00 00 00 89 45 FC 89 4D F8 85 C9 75 0E 8B 00 8B 4D FC FF 50 04 89 45 F8 8B 45 FC 33 D2 8D 4E 2C 42 87 11 8B 10 8B C8 FF 75 08 FF 52 10 8B 4D F8 85 C9 75 1E 8B 4D FC 6A 01 6A 04 E8 ?? ?? ?? ?? 8B 4D F4 E8 ?? ?? ?? ?? 8B 03 8B CB 57 FF 50 08 EB 09 8B 03 57 51 8B CB FF 50 04 83 7D 0C 00 74 08 8D 4E 04 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_91_161_0 {
	meta:
		name = "?SwitchToRunnableContext@InternalContextBase@details@Concurrency@@IAEXPAVWorkItem@23@@Z"
		size = 20
		refs = "000c ?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 6A 00 FF 70 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_91_162_0 {
	meta:
		name = "?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z"
		size = 45
		refs = "0008 ?g_TraceInfo@details@Concurrency@@3U_CONCRT_TRACE_INFO@12@A 0022 ?ThrowContextEvent@ContextBase@details@Concurrency@@KAXW4ConcRT_EventType@3@EKK@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 3A 0D ?? ?? ?? ?? 77 1B A1 ?? ?? ?? ?? A8 02 74 12 FF 75 14 FF 75 10 51 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C2 10 00 }
	condition:
		$1
}

rule file_91_163_0 {
	meta:
		name = "?Unblock@InternalContextBase@details@Concurrency@@UAEXXZ"
		size = 166
		refs = "0015 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 003b ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 0050 ?SpinUntilBlocked@InternalContextBase@details@Concurrency@@IAEXXZ 0061 ?_Assign@location@Concurrency@@QAEXABV12@@Z 0081 ??0context_self_unblock@Concurrency@@QAE@XZ 0086 __TI2?AVcontext_self_unblock@Concurrency@@ 0093 ??0context_unblock_unbalanced@Concurrency@@QAE@XZ 0098 __TI2?AVcontext_unblock_unbalanced@Concurrency@@ 00a1 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 1C 53 56 57 8B F9 8D 77 FC F7 DE 1B F6 23 F7 E8 ?? ?? ?? ?? 3B F0 74 60 8D 5F 2C 83 CE FF F0 0F C1 33 4E 8B 4F 1C FF 77 08 8B 01 FF 50 04 50 6A 04 6A 04 8B CF E8 ?? ?? ?? ?? 83 FE 01 75 2F 8D 77 FC C7 03 00 00 00 00 8B CE E8 ?? ?? ?? ?? 8B 47 18 83 EC 10 83 C0 0C 8B CC 50 E8 ?? ?? ?? ?? 8B 06 8B CE FF 50 14 5F 5E 5B 8B E5 5D C3 8D 46 01 83 F8 01 76 F1 EB 12 8D 4D E4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E4 EB 10 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_91_164_0 {
	meta:
		name = "?WaitForWork@InternalContextBase@details@Concurrency@@IAEXXZ"
		size = 240
		refs = "0028 ?InterlockedSet@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z 0030 ?ClearQuickCacheSlot@SchedulerBase@details@Concurrency@@QAEXI@Z 0065 ?MakeAvailable@VirtualProcessor@details@Concurrency@@IAEXW4AvailabilityType@123@_N@Z 0071 ?EnsureAllTasksVisible@VirtualProcessor@details@Concurrency@@QAEXPAUIExecutionContext@3@@Z 0099 ?VirtualProcessorIdle@SchedulerBase@details@Concurrency@@QAEX_N@Z 00ae ?Deactivate@VirtualProcessor@details@Concurrency@@QAE_NPAUIExecutionContext@3@@Z 00e3 ?InterlockedClear@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z"
	strings:
		$1 = { 53 8B D9 FF 83 AC 00 00 00 83 BB AC 00 00 00 01 75 24 8B 83 A0 00 00 00 56 57 8B 7B 20 8B B0 90 00 00 00 56 8D 4F 3C E8 ?? ?? ?? ?? 56 8B CF E8 ?? ?? ?? ?? 5F 5E 8B 83 AC 00 00 00 B9 00 01 00 00 3B C1 73 0C 8B 8B 9C 00 00 00 5B 8B 01 FF 60 0C 75 24 8B 8B A0 00 00 00 6A 01 6A 02 C6 83 B2 00 00 00 01 E8 ?? ?? ?? ?? 8B 8B A0 00 00 00 53 E8 ?? ?? ?? ?? 5B C3 F6 83 B3 00 00 00 02 74 13 8B 8B 9C 00 00 00 48 89 83 AC 00 00 00 5B 8B 01 FF 60 0C 8B 4B 20 6A 01 E8 ?? ?? ?? ?? EB 07 8B 03 8B CB FF 50 20 8B 8B A0 00 00 00 53 E8 ?? ?? ?? ?? 84 C0 74 E9 8B 4B 20 6A 00 E8 ?? ?? ?? ?? 83 BB AC 00 00 00 00 C6 83 B2 00 00 00 00 76 17 8B 83 A0 00 00 00 8B 4B 20 83 C1 3C FF B0 90 00 00 00 E8 ?? ?? ?? ?? 83 A3 AC 00 00 00 00 5B C3 }
	condition:
		$1
}

rule file_91_165_0 {
	meta:
		name = "?Wipe@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEXXZ"
		size = 74
		refs = "001f ??3@YAXPAX@Z 0040 _memset"
		altNames = "?Wipe@?$Hash@II@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 57 8B F9 83 7F 04 00 7E 3F 53 33 DB 39 1F 7E 20 56 8B 47 08 8B 04 98 85 C0 74 0F 8B 30 50 E8 ?? ?? ?? ?? 8B C6 59 85 F6 75 F1 43 3B 1F 7C E2 5E 8B 07 83 67 04 00 C1 E0 02 50 6A 00 FF 77 08 E8 ?? ?? ?? ?? 83 C4 0C 5B 5F C3 }
	condition:
		$1
}

rule file_91_166_0 {
	meta:
		name = "?WorkWasFound@InternalContextBase@details@Concurrency@@IAE_NPAVWorkItem@23@@Z"
		size = 105
		refs = "0031 ?ReclaimVirtualProcessor@InternalContextBase@details@Concurrency@@IAEXXZ 0051 ?InterlockedClear@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z"
	strings:
		$1 = { 55 8B EC 51 56 8B F1 6A 07 8A 86 B2 00 00 00 8B 56 1C 88 45 FC FF 75 FC 8B 86 A0 00 00 00 83 C0 28 52 FF 75 08 8B C8 FF 50 20 84 C0 74 32 8B CE E8 ?? ?? ?? ?? 83 BE AC 00 00 00 00 74 17 8B 86 A0 00 00 00 8B 4E 20 83 C1 3C FF B0 90 00 00 00 E8 ?? ?? ?? ?? 83 A6 AC 00 00 00 00 B0 01 EB 02 32 C0 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_91_167_0 {
	meta:
		name = "?Yield@InternalContextBase@details@Concurrency@@UAEXXZ"
		size = 317
		refs = "000d ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0024 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 003e ?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z 0076 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0080 ?GetInternalContext@SchedulerBase@details@Concurrency@@QAEPAVInternalContextBase@23@_N@Z 0095 ?ResolveToken@WorkItem@details@Concurrency@@QAE_NXZ 00a2 ?BindTo@WorkItem@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z 00d0 ?ReleaseInternalContext@SchedulerBase@details@Concurrency@@QAEXPAVInternalContextBase@23@_N@Z 00e2 ?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z 0116 ?Bind@WorkItem@details@Concurrency@@QAEPAVInternalContextBase@23@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 8B F1 33 DB E8 ?? ?? ?? ?? 8B 4E 1C FF 76 08 8B 01 FF 50 04 50 6A 04 6A 05 8B CE E8 ?? ?? ?? ?? 8B 86 9C 00 00 00 8A 80 AD 00 00 00 84 C0 74 0F 6A 02 8D 4E FC E8 ?? ?? ?? ?? E9 DA 00 00 00 8B 4E 18 8B 86 9C 00 00 00 57 6A 09 53 51 8D 4D F4 89 5D F4 51 8D 48 28 89 5D FC FF 50 4C 84 C0 0F 84 B1 00 00 00 83 7D F4 01 74 61 8B CE E8 ?? ?? ?? ?? 8B 4E 1C 6A 01 E8 ?? ?? ?? ?? 8B CE 8B F8 E8 ?? ?? ?? ?? 85 FF 74 66 8D 4D F4 E8 ?? ?? ?? ?? 84 C0 74 0B 57 8D 4D F4 E8 ?? ?? ?? ?? EB 2F 8B 4E 18 8B 86 9C 00 00 00 6A 03 53 51 8D 4D F4 51 8D 48 28 FF 50 4C 84 C0 74 25 83 7D F4 01 75 D4 8B 4E 1C 6A 01 57 E8 ?? ?? ?? ?? 8B 7D FC 85 FF 74 43 6A 02 57 8D 4E FC E8 ?? ?? ?? ?? EB 38 8B 4E 1C 6A 01 57 E8 ?? ?? ?? ?? 8B FB EB E0 8B 4E 18 8B 86 9C 00 00 00 6A 01 53 51 8D 4D F4 51 8D 48 28 FF 50 4C 84 C0 74 0C 8D 4D F4 E8 ?? ?? ?? ?? 8B F8 EB B9 B3 01 5F 8B CE E8 ?? ?? ?? ?? 84 DB 74 0B 8B 8E 98 00 00 00 8B 01 FF 50 0C 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_91_170_0 {
	meta:
		name = "?_Assign@location@Concurrency@@QAEXABV12@@Z"
		size = 53
	strings:
		$1 = { 55 8B EC 8B 55 08 56 BE FF FF FF 0F 8B 02 33 01 23 C6 31 01 8B 02 33 01 23 C6 33 02 89 01 8B 42 08 89 41 08 8B 42 04 89 41 04 8B 42 0C 89 41 0C 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_91_177_0 {
	meta:
		name = "?_IsEnabled@_CONCRT_TRACE_INFO@details@Concurrency@@QBE_NEK@Z"
		size = 32
	strings:
		$1 = { 55 8B EC 8A 45 08 3A 41 04 77 0F 8B 01 23 45 0C 3B 45 0C 75 05 33 C0 40 EB 02 33 C0 5D C2 08 00 }
	condition:
		$1
}

rule file_91_181_0 {
	meta:
		name = "?_Reset@?$_SpinWait@$00@details@Concurrency@@IAEXXZ"
		size = 22
		refs = "0008 ?_Value@_SpinCount@details@Concurrency@@SAIXZ 0010 ?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 56 8B F1 83 66 08 00 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_190_262_0 {
	meta:
		name = "?_Reset@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ"
		size = 22
		refs = "0008 ?_Value@_SpinCount@details@Concurrency@@SAIXZ 0010 ?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 56 8B F1 83 66 08 00 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_91_182_0 {
	meta:
		name = "?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z"
		size = 34
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 75 09 C7 41 08 04 00 00 00 EB 0B 89 01 33 C0 40 89 41 04 89 41 08 5D C2 04 00 }
	condition:
		$1
}

rule file_91_184_0 {
	meta:
		name = "?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
		size = 110
		refs = "0011 ?_Value@_SpinCount@details@Concurrency@@SAIXZ 0019 ?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 53 56 8B F1 33 DB 8B 46 08 2B C3 75 12 89 5E 08 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? EB E7 48 74 34 48 74 1C 48 74 05 48 74 24 EB 10 89 5E 08 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 32 C0 EB 2A FF 4E 04 75 07 C7 46 08 03 00 00 00 B3 01 FF 56 0C 8A C3 EB 15 F3 90 FF 0E 75 0D 8B 46 04 F7 D8 1B C0 83 C0 03 89 46 08 B0 01 5E 5B C3 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "_scalbnl"
		size = 64
		refs = "000e __ldtest 0020 __ldscale 0036 __fperrraise"
		altNames = "_scalblnl"
	strings:
		$1 = { 55 8B EC 83 7D 10 00 74 32 8D 45 08 50 E8 ?? ?? ?? ?? 59 66 85 C0 79 23 FF 75 10 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 59 83 E8 00 74 07 48 75 0C 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 DD 45 08 5D C3 }
	condition:
		$1
}

rule file_916_0_0 {
	meta:
		name = "_scalbln"
		size = 64
		refs = "000e __dtest 0020 __dscale 0036 __fperrraise"
	strings:
		$1 = { 55 8B EC 83 7D 10 00 74 32 8D 45 08 50 E8 ?? ?? ?? ?? 59 66 85 C0 79 23 FF 75 10 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 59 83 E8 00 74 07 48 75 0C 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 DD 45 08 5D C3 }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "_scalbn"
		size = 64
		refs = "000e __dtest 0020 __dscale 0036 __fperrraise"
	strings:
		$1 = { 55 8B EC 83 7D 10 00 74 32 8D 45 08 50 E8 ?? ?? ?? ?? 59 66 85 C0 79 23 FF 75 10 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 59 83 E8 00 74 07 48 75 0C 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 DD 45 08 5D C3 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "_asinhl"
		size = 136
		refs = "0008 __ldtest 0033 __real@4000000000000000 0039 __LEps_C 0052 _sqrt 0069 _log1pl 0073 _log 0079 __real@3fe62e42fefa39ef"
	strings:
		$1 = { 55 8B EC 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 83 F8 02 77 05 DD 45 08 5D C3 D9 EE DD 45 08 D8 D1 DF E0 56 33 F6 DD D9 F6 C4 05 7A 06 D9 E0 46 DD 55 08 DD 05 ?? ?? ?? ?? DC 35 ?? ?? ?? ?? 51 51 D8 D9 DF E0 F6 C4 41 75 27 DC C8 D9 E8 DE C1 DD 1C 24 E8 ?? ?? ?? ?? DD 45 08 D9 C0 D8 C9 D9 E8 DE C3 DE F2 DE C1 DD 1C 24 E8 ?? ?? ?? ?? EB 0E DD 1C 24 E8 ?? ?? ?? ?? DC 05 ?? ?? ?? ?? 59 59 85 F6 5E 74 02 D9 E0 5D C3 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "_strtok_s"
		size = 237
		refs = "0007 ___security_cookie 0026 __errno 0031 __invalid_parameter_noinfo 003f @__security_check_cookie@4 00e8 ___report_rangecheckfailure"
	strings:
		$1 = { 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 56 8B 75 08 57 8B 7D 10 89 45 D4 89 7D D8 85 FF 75 22 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 85 C0 74 DA 85 F6 75 04 39 37 74 D2 33 C0 83 F8 20 0F 83 89 00 00 00 C6 44 05 DC 00 40 83 F8 20 7C EF 8B 7D D4 53 8A 1F B0 01 0F B6 CB 8B D1 83 E1 07 C1 EA 03 D2 E0 08 44 15 DC 47 84 DB 75 E6 8B 7D D8 85 F6 75 09 8B 37 EB 05 84 DB 74 19 46 8A 1E 33 C0 0F B6 D3 40 8B CA C1 EA 03 83 E1 07 D3 E0 84 44 15 DC 75 E3 8B DE EB 17 0F B6 16 33 C0 8B CA 40 83 E1 07 C1 EA 03 D3 E0 84 44 15 DC 75 08 46 80 3E 00 75 E4 EB 04 C6 06 00 46 8B C3 89 37 2B C6 F7 D8 1B C0 23 C3 5B E9 50 FF FF FF E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_95_3_0 {
	meta:
		name = "__validate_param_reuseW"
		size = 376
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 10 66 8B 4D 10 0F B7 50 08 53 56 57 6A 70 58 66 3B D0 0F 84 49 01 00 00 66 3B C8 0F 84 40 01 00 00 6A 53 58 33 FF 33 DB 6A 73 5E 47 89 75 F0 66 3B D6 74 07 8B F3 66 3B D0 75 02 8B F7 66 3B 4D F0 74 07 66 3B C8 8B C3 75 02 8B C7 85 F6 0F 85 E9 00 00 00 85 C0 0F 85 FF 00 00 00 6A 69 5E C7 45 FC 64 00 00 00 6A 6F 58 C7 45 F8 75 00 00 00 C7 45 F4 78 00 00 00 C7 45 F0 58 00 00 00 66 3B 55 FC 74 62 66 3B D6 74 39 66 3B D0 74 34 66 3B 55 F8 74 2E 66 3B 55 F4 74 28 66 3B 55 F0 74 22 66 3B 4D FC 74 1C 66 3B CE 74 17 66 3B C8 74 12 66 3B 4D F8 74 0C 66 3B 4D F4 74 06 66 3B 4D F0 75 6F 66 3B 55 FC 74 1E 66 3B D6 74 19 66 3B D0 74 14 66 3B 55 F8 74 0E 66 3B 55 F4 74 08 8B C3 66 3B 55 F0 75 02 8B C7 66 3B 4D FC 74 1F 66 3B CE 74 1A 6A 6F 5A 66 3B CA 74 12 66 3B 4D F8 74 0C 66 3B 4D F4 74 06 66 3B 4D F0 75 02 8B DF 3B C3 74 04 33 C0 EB 52 8B 45 08 8B 48 0C 8B C1 33 45 14 A9 00 00 01 00 75 EA 33 4D 14 F6 C1 20 75 E2 8B 4D 08 33 C0 8B 09 3B 4D 0C EB 29 3B F0 75 1A 8B 45 08 8B 48 0C 8B 45 14 C1 E9 05 C1 E8 05 F7 D1 F7 D0 33 C8 F6 C1 01 74 02 8B FB 8B C7 EB 08 33 C0 66 3B D1 0F 94 C0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_95_4_0 {
	meta:
		name = "__woutput_p_l"
		size = 4852
		refs = "000a ___security_cookie 0065 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0079 __errno 0093 __invalid_parameter_noinfo 0182 ___lookuptable_s 01d6 _wcstol 0208 _memset 02c3 $LN661 0307 _write_char 0523 __validate_param_reuseW 073c _write_multi_char 0765 _write_string 07cd __mbtowc_l 0a94 ___nullstring 0a9a _strlen 0b47 __get_printf_count_output 0c3b __malloc_crt 0cd8 __cfltcvt_tab 0cde __imp__DecodePointer@4 1003 __aulldvrm 10cd __isleadbyte_l 1101 ___wnullstring 11c1 _free 124e _get_crtdouble_arg 12cc @__security_check_cookie@4 12d4 $LN255 12d8 $LN251 12dc $LN250 12e0 $LN242 12e4 $LN230 12e8 $LN229 12ec $LN217 12f0 $LN201"
	strings:
		$1 = { 55 8B EC 81 EC D0 0A 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 33 C9 53 56 57 FF 75 10 8B 7D 08 8B D9 89 85 44 F5 FF FF 8B F1 8B 45 14 89 8D 50 F5 FF FF 89 8D 7C F5 FF FF 89 8D 4C F5 FF FF 89 8D AC F5 FF FF 89 8D 68 F5 FF FF 8D 8D 90 F5 FF FF 89 BD 6C F5 FF FF 89 85 B0 F5 FF FF 89 9D A8 F5 FF FF E8 ?? ?? ?? ?? 83 8D 8C F5 FF FF FF 33 C0 89 85 78 F5 FF FF E8 ?? ?? ?? ?? 89 85 48 F5 FF FF 85 FF 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 38 9D 9C F5 FF FF 74 0A 8B 8D 98 F5 FF FF 83 61 70 FD 83 C8 FF E9 12 12 00 00 8B 8D 44 F5 FF FF 85 C9 75 24 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 38 9D 9C F5 FF FF 74 D6 8B 85 98 F5 FF FF 83 60 70 FD EB CA 8B BD B0 F5 FF FF 33 C0 8B D0 89 85 84 F5 FF FF 89 95 B8 F5 FF FF C7 85 38 F5 FF FF 58 00 00 00 83 FA 01 75 0D 83 BD 8C F5 FF FF 00 0F 84 99 11 00 00 83 8D 74 F5 FF FF FF 83 8D 88 F5 FF FF FF 83 8D 8C F5 FF FF FF 89 85 B4 F5 FF FF 33 C0 89 85 5C F5 FF FF 89 85 64 F5 FF FF 89 85 70 F5 FF FF 89 85 A0 F5 FF FF 8B C1 0F B7 09 89 8D A4 F5 FF FF 66 85 C9 0F 84 31 11 00 00 83 C0 02 83 BD 84 F5 FF FF 00 89 85 80 F5 FF FF 0F 8C 82 10 00 00 8D 41 E0 66 3B 85 38 F5 FF FF 77 0F 0F B7 C1 0F B6 80 ?? ?? ?? ?? 83 E0 0F EB 02 33 C0 8B 8D 5C F5 FF FF 6B C0 09 0F B6 8C 08 ?? ?? ?? ?? C1 E9 04 89 8D 5C F5 FF FF 83 F9 01 0F 85 F2 00 00 00 8B 85 80 F5 FF FF 8B 8D 8C F5 FF FF 66 83 38 25 0F 84 F4 00 00 00 83 F9 FF 75 60 6A 0A 8D 8D 78 F5 FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 7E 3A 8B 85 78 F5 FF FF 6A 24 5F 66 39 38 75 2C 83 BD B8 F5 FF FF 00 75 17 33 C0 68 40 06 00 00 50 8D 85 BC F9 FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C C7 85 8C F5 FF FF 01 00 00 00 EB 1C 8B BD B0 F5 FF FF 33 C0 8B C8 89 8D 8C F5 FF FF 83 F9 01 0F 85 86 00 00 00 6A 24 5F 8B 95 80 F5 FF FF 8D 85 78 F5 FF FF 6A 0A 50 52 E8 ?? ?? ?? ?? 8B 8D 78 F5 FF FF 83 C4 0C 83 BD B8 F5 FF FF 00 8D 50 FF 8D 41 02 89 95 88 F5 FF FF 89 85 80 F5 FF FF 75 2A 85 D2 0F 88 BA 02 00 00 66 39 39 0F 85 B1 02 00 00 6A 64 58 3B D0 0F 8D A6 02 00 00 3B 95 74 F5 FF FF 7E 06 89 95 74 F5 FF FF 8B BD B0 F5 FF FF EB 12 83 F9 08 0F 84 87 02 00 00 83 F9 07 0F 87 26 0F 00 00 8B 8D 8C F5 FF FF 8B 85 5C F5 FF FF FF 24 85 ?? ?? ?? ?? 8B 95 B8 F5 FF FF 85 D2 75 09 83 F9 01 0F 84 00 0F 00 00 83 FA 01 75 09 83 F9 FF 0F 84 F2 0E 00 00 8B 8D A4 F5 FF FF 8D 85 84 F5 FF FF C7 85 68 F5 FF FF 01 00 00 00 50 FF B5 6C F5 FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C E9 BB 0E 00 00 33 C9 83 8D A0 F5 FF FF FF 8B D9 89 8D 4C F5 FF FF 89 8D AC F5 FF FF 89 8D 70 F5 FF FF 89 8D 7C F5 FF FF 89 9D A8 F5 FF FF 89 8D 68 F5 FF FF E9 8D 0E 00 00 8B 8D A4 F5 FF FF 0F B7 C1 6A 20 59 2B C1 74 46 83 E8 03 74 39 83 E8 08 74 2F 48 48 74 1D 8B 95 B8 F5 FF FF 83 E8 03 0F 85 66 0E 00 00 83 CB 08 89 9D A8 F5 FF FF E9 58 0E 00 00 83 CB 04 89 9D A8 F5 FF FF E9 44 0E 00 00 83 CB 01 EB F0 81 CB 80 00 00 00 EB E8 83 CB 02 EB E3 8B 85 A4 F5 FF FF 6A 2A 5A 66 3B C2 0F 85 A6 00 00 00 85 C9 75 14 8B 95 B8 F5 FF FF 83 C7 04 89 BD B0 F5 FF FF 8B 47 FC EB 47 8B 95 80 F5 FF FF 8D 85 78 F5 FF FF 6A 0A 50 52 E8 ?? ?? ?? ?? 8B 8D 78 F5 FF FF 83 C4 0C 48 8D 51 02 89 95 80 F5 FF FF 8B 95 B8 F5 FF FF 85 D2 0F 84 DE 00 00 00 8B BD B0 F5 FF FF 03 C0 8B 84 C5 C0 F9 FF FF 8B 00 89 85 70 F5 FF FF 85 C0 0F 89 B9 0D 00 00 83 CB 04 F7 D8 89 9D A8 F5 FF FF 89 85 70 F5 FF FF E9 A3 0D 00 00 8B BD B0 F5 FF FF C7 01 01 00 00 00 6A 2A 59 66 89 8C 05 C4 F9 FF FF 89 9C 05 C8 F9 FF FF E9 80 0D 00 00 6B 8D 70 F5 FF FF 0A 0F B7 C0 83 C1 D0 03 C1 89 85 70 F5 FF FF E9 60 0D 00 00 33 C0 89 85 A0 F5 FF FF E9 53 0D 00 00 8B 85 A4 F5 FF FF 6A 2A 5A 66 3B C2 0F 85 E6 00 00 00 85 C9 75 17 8B 95 B8 F5 FF FF 83 C7 04 89 BD B0 F5 FF FF 8B 47 FC E9 B1 00 00 00 8B 95 80 F5 FF FF 8D 85 78 F5 FF FF 6A 0A 50 52 E8 ?? ?? ?? ?? 8B 8D 78 F5 FF FF 83 C4 0C 48 8D 51 02 89 95 80 F5 FF FF 8B 95 B8 F5 FF FF 85 D2 75 6E 85 C0 78 4E 6A 24 5F 66 39 39 75 46 6A 64 59 39 8D 88 F5 FF FF 7D 3B 3B 85 74 F5 FF FF 7E 06 89 85 74 F5 FF FF C1 E0 04 8D 8D BC F9 FF FF 03 C8 33 FF 39 39 0F 84 1D FF FF FF 53 6A 2A 58 50 6A 01 51 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 85 9C 0C 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 80 BD 9C F5 FF FF 00 E9 83 FB FF FF 8B BD B0 F5 FF FF 03 C0 8B 84 C5 C0 F9 FF FF 8B 00 89 85 A0 F5 FF FF 85 C0 0F 89 6D 0C 00 00 83 8D A0 F5 FF FF FF E9 61 0C 00 00 6B 8D A0 F5 FF FF 0A 0F B7 C0 83 C1 D0 03 C1 E9 E9 FE FF FF 8B 8D A4 F5 FF FF 0F B7 C1 83 F8 49 74 57 83 F8 68 74 48 6A 6C 59 3B C1 74 1A 8B 95 B8 F5 FF FF 83 F8 77 0F 85 24 0C 00 00 81 CB 00 08 00 00 E9 B6 FD FF FF 8B 95 80 F5 FF FF 66 39 0A 75 14 83 C2 02 81 CB 00 10 00 00 89 95 80 F5 FF FF E9 A5 FD FF FF 83 CB 10 E9 9D FD FF FF 6A 20 58 0B D8 E9 93 FD FF FF 8B 95 80 F5 FF FF 0F B7 02 83 F8 36 75 1B 66 83 7A 02 34 75 14 83 C2 04 81 CB 00 80 00 00 89 95 80 F5 FF FF E9 6A FD FF FF 83 F8 33 75 1B 66 83 7A 02 32 75 14 83 C2 04 81 E3 FF 7F FF FF 89 95 80 F5 FF FF E9 4A FD FF FF 6A 64 5A 66 3B C2 74 2F 6A 69 5A 66 3B C2 74 27 6A 6F 5A 66 3B C2 74 1F 83 F8 75 74 1A 83 F8 78 74 15 6A 58 5A 66 3B C2 74 0D 33 C0 89 85 5C F5 FF FF E9 7C FC FF FF 81 CB 00 00 01 00 E9 08 FD FF FF 8B 95 A4 F5 FF FF 0F B7 C2 83 F8 64 0F 8F 23 04 00 00 0F 84 EA 04 00 00 83 F8 53 0F 8F 43 02 00 00 0F 84 FB 01 00 00 83 E8 41 0F 84 81 01 00 00 48 48 0F 84 5D 01 00 00 48 48 0F 84 71 01 00 00 48 48 0F 84 69 01 00 00 8B 95 B4 F5 FF FF 8B 85 AC F5 FF FF 83 BD 8C F5 FF FF 01 75 0D 83 BD B8 F5 FF FF 00 0F 84 ED 0A 00 00 85 C0 0F 85 C6 0A 00 00 F6 C3 40 74 20 F7 C3 00 01 00 00 0F 84 2D 0A 00 00 6A 2D 58 66 89 85 60 F5 FF FF C7 85 7C F5 FF FF 01 00 00 00 6A 20 59 8B BD 70 F5 FF FF 8B 85 7C F5 FF FF 2B FA 2B F8 F6 C3 0C 75 1D 8D 85 84 F5 FF FF 50 FF B5 6C F5 FF FF 57 51 E8 ?? ?? ?? ?? 8B 85 7C F5 FF FF 83 C4 10 FF B5 48 F5 FF FF 8D 8D 84 F5 FF FF 51 FF B5 6C F5 FF FF 50 8D 85 60 F5 FF FF 50 E8 ?? ?? ?? ?? 83 C4 14 F6 C3 08 74 1F F6 C3 04 75 1A 8D 85 84 F5 FF FF 50 FF B5 6C F5 FF FF 57 6A 30 58 50 E8 ?? ?? ?? ?? 83 C4 10 83 BD 68 F5 FF FF 00 8B 85 B4 F5 FF FF 0F 85 C7 09 00 00 85 C0 0F 8E BF 09 00 00 8B DE 48 89 85 34 F5 FF FF 8D 85 90 F5 FF FF 50 8B 85 90 F5 FF FF FF 70 74 8D 85 54 F5 FF FF 53 50 E8 ?? ?? ?? ?? 83 C4 10 89 85 A4 F5 FF FF 85 C0 0F 8E 79 09 00 00 8D 85 84 F5 FF FF 50 FF B5 6C F5 FF FF FF B5 54 F5 FF FF E8 ?? ?? ?? ?? 03 9D A4 F5 FF FF 83 C4 0C 8B 85 34 F5 FF FF 85 C0 7F A0 E9 50 09 00 00 F7 C3 30 08 00 00 0F 85 E5 00 00 00 6A 20 58 0B D8 89 9D A8 F5 FF FF E9 D5 00 00 00 6A 20 58 03 D0 C7 85 4C F5 FF FF 01 00 00 00 89 95 A4 F5 FF FF 83 CB 40 89 9D A8 F5 FF FF 83 F9 01 0F 85 7F 03 00 00 83 BD B8 F5 FF FF 00 0F 85 72 03 00 00 8B 85 88 F5 FF FF 83 F8 63 0F 87 C1 FC FF FF C1 E0 04 8D 8D BC F9 FF FF 03 C8 83 39 00 0F 85 35 03 00 00 C7 01 07 00 00 00 66 89 94 05 C4 F9 FF FF 89 9C 05 C8 F9 FF FF E9 35 09 00 00 F7 C3 30 08 00 00 75 0B 6A 20 58 0B D8 89 9D A8 F5 FF FF 8B 85 A0 F5 FF FF 83 F8 FF 75 05 B8 FF FF FF 7F 89 85 A4 F5 FF FF 85 C9 0F 85 9A 07 00 00 83 C7 04 89 BD B0 F5 FF FF 8B 77 FC E9 B5 07 00 00 83 E8 58 0F 84 75 04 00 00 48 48 0F 84 05 01 00 00 83 E8 07 0F 84 48 FF FF FF 48 48 0F 85 C2 FD FF FF C7 85 68 F5 FF FF 01 00 00 00 85 C9 75 0F 83 C7 04 89 BD B0 F5 FF FF 0F B7 47 FC EB 68 8B 85 88 F5 FF FF 83 F8 63 0F 87 03 FC FF FF 83 BD B8 F5 FF FF 00 75 44 C1 E0 04 8D 8D BC F9 FF FF 03 C8 83 39 00 75 1A C7 01 01 00 00 00 66 89 94 05 C4 F9 FF FF 89 9C 05 C8 F9 FF FF E9 63 FD FF FF 53 52 6A 01 51 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 84 BB FB FF FF E9 49 FD FF FF 03 C0 8B 84 C5 C0 F9 FF FF 0F B7 00 89 85 54 F5 FF FF F6 C3 20 74 49 88 85 58 F5 FF FF 33 C0 88 85 59 F5 FF FF 8D 85 90 F5 FF FF 50 8B 85 90 F5 FF FF FF 70 74 8D 85 58 F5 FF FF 50 8D 85 BC F5 FF FF 50 E8 ?? ?? ?? ?? 8B BD B0 F5 FF FF 83 C4 10 85 C0 79 12 33 C0 40 89 85 AC F5 FF FF EB 07 66 89 85 BC F5 FF FF 33 D2 8D B5 BC F5 FF FF 42 89 95 B4 F5 FF FF E9 D4 FC FF FF 85 C9 75 0E 83 C7 04 89 BD B0 F5 FF FF 8B 47 FC EB 47 8B 85 88 F5 FF FF 83 F8 63 0F 87 1A FB FF FF 83 BD B8 F5 FF FF 00 75 24 C1 E0 04 8D 8D BC F9 FF FF 03 C8 83 39 00 75 0B C7 01 02 00 00 00 E9 12 FF FF FF 53 52 6A 02 E9 21 FF FF FF 03 C0 8B 84 C5 C0 F9 FF FF 8B 00 85 C0 74 3E 8B 70 04 85 F6 74 37 F7 C3 00 08 00 00 74 1F 0F BF 00 99 2B C2 C7 85 68 F5 FF FF 01 00 00 00 8B D0 D1 FA 89 95 B4 F5 FF FF E9 49 FC FF FF 0F BF 10 33 C9 89 8D 68 F5 FF FF E9 5A FF FF FF 8B 35 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 8B BD B0 F5 FF FF 8B D0 59 89 95 B4 F5 FF FF E9 19 FC FF FF 83 F8 70 0F 8F A8 02 00 00 0F 84 94 02 00 00 83 F8 65 0F 8C FB FB FF FF 83 F8 67 0F 8E 70 FD FF FF 83 F8 69 0F 84 A3 00 00 00 83 F8 6E 74 2C 83 F8 6F 0F 85 DB FB FF FF C7 85 A4 F5 FF FF 08 00 00 00 84 DB 0F 89 96 00 00 00 81 CB 00 02 00 00 89 9D A8 F5 FF FF E9 85 00 00 00 85 C9 75 0E 83 C7 04 89 BD B0 F5 FF FF 8B 7F FC EB 27 8B 85 88 F5 FF FF 83 F8 63 0F 87 04 FA FF FF 83 BD B8 F5 FF FF 00 0F 84 E6 FE FF FF 03 C0 8B 84 C5 C0 F9 FF FF 8B 38 E8 ?? ?? ?? ?? 85 C0 0F 84 DF F9 FF FF 8B 85 84 F5 FF FF F6 C3 20 74 05 66 89 07 EB 02 89 07 8B BD B0 F5 FF FF 33 C0 8B 95 B4 F5 FF FF 40 89 85 AC F5 FF FF E9 52 FB FF FF 83 CB 40 89 9D A8 F5 FF FF C7 85 A4 F5 FF FF 0A 00 00 00 F7 C3 00 80 00 00 0F 84 72 02 00 00 85 C9 0F 85 1B 02 00 00 83 C7 08 89 BD B0 F5 FF FF 8B 4F F8 8B 5F FC E9 70 03 00 00 53 52 6A 07 51 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 84 63 F9 FF FF E9 00 06 00 00 8B 85 A0 F5 FF FF 8D B5 BC F5 FF FF BA 00 02 00 00 89 95 B4 F5 FF FF 85 C0 79 0C C7 85 A0 F5 FF FF 06 00 00 00 EB 71 75 20 8B 8D A4 F5 FF FF 6A 67 58 66 3B C8 8B 8D 8C F5 FF FF 75 5B C7 85 A0 F5 FF FF 01 00 00 00 EB 4F 3D 00 02 00 00 7E 08 8B C2 89 85 A0 F5 FF FF 3D A3 00 00 00 7E 39 8D B8 5D 01 00 00 57 E8 ?? ?? ?? ?? 89 85 64 F5 FF FF 59 8B 8D 8C F5 FF FF 85 C0 74 06 8B F0 8B D7 EB 10 8B 95 B4 F5 FF FF C7 85 A0 F5 FF FF A3 00 00 00 8B BD B0 F5 FF FF 85 C9 75 17 83 C7 08 89 BD B0 F5 FF FF 8B 47 F8 89 85 3C F5 FF FF 8B 47 FC EB 23 8B 85 88 F5 FF FF 83 F8 63 0F 87 9C F8 FF FF 03 C0 8B 8C C5 C0 F9 FF FF 8B 01 89 85 3C F5 FF FF 8B 41 04 89 85 40 F5 FF FF 8D 85 90 F5 FF FF 50 FF B5 4C F5 FF FF 8B 85 A4 F5 FF FF FF B5 A0 F5 FF FF 0F BE C0 50 52 56 8D 85 3C F5 FF FF 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 8B FB 83 C4 1C 81 E7 80 00 00 00 74 21 83 BD A0 F5 FF FF 00 75 18 8D 85 90 F5 FF FF 50 56 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 59 59 6A 67 58 66 39 85 A4 F5 FF FF 75 1C 85 FF 75 18 8D 85 90 F5 FF FF 50 56 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 59 59 80 3E 2D 0F 85 55 FD FF FF 81 CB 00 01 00 00 46 89 9D A8 F5 FF FF E9 43 FD FF FF C7 85 A0 F5 FF FF 08 00 00 00 6A 07 EB 1C 83 E8 73 0F 84 46 FB FF FF 48 48 0F 84 14 FE FF FF 83 E8 03 0F 85 48 F9 FF FF 6A 27 C7 85 A4 F5 FF FF 10 00 00 00 58 89 85 50 F5 FF FF 84 DB 0F 89 FA FD FF FF 6A 30 5F 83 C0 51 66 89 BD 60 F5 FF FF 8B BD B0 F5 FF FF 66 89 85 62 F5 FF FF C7 85 7C F5 FF FF 02 00 00 00 E9 D1 FD FF FF 8B 85 88 F5 FF FF 83 F8 63 0F 87 62 F7 FF FF 83 BD B8 F5 FF FF 00 75 24 C1 E0 04 8D 8D BC F9 FF FF 03 C8 83 39 00 75 0B C7 01 03 00 00 00 E9 5A FB FF FF 53 52 6A 03 E9 69 FB FF FF 03 C0 33 D2 8B 84 C5 C0 F9 FF FF 8B 58 04 E9 5D 01 00 00 F7 C3 00 10 00 00 74 44 85 C9 0F 84 86 FD FF FF 8B 85 88 F5 FF FF 83 F8 63 0F 87 03 F7 FF FF 83 BD B8 F5 FF FF 00 75 C5 C1 E0 04 8D 8D BC F9 FF FF 03 C8 83 39 00 75 0B C7 01 04 00 00 00 E9 FB FA FF FF 53 52 6A 04 E9 0A FB FF FF F6 C3 20 0F 84 82 00 00 00 F6 C3 40 74 40 85 C9 75 12 83 C7 04 89 BD B0 F5 FF FF 0F BF 47 FC E9 A5 00 00 00 8B 85 88 F5 FF FF 83 F8 63 0F 87 A3 F6 FF FF 83 BD B8 F5 FF FF 00 0F 84 9C FA FF FF 03 C0 8B 84 C5 C0 F9 FF FF 0F BF 00 EB 7B 85 C9 75 0F 83 C7 04 89 BD B0 F5 FF FF 0F B7 47 FC EB 68 8B 85 88 F5 FF FF 83 F8 63 0F 87 66 F6 FF FF 83 BD B8 F5 FF FF 00 0F 84 5F FA FF FF 03 C0 8B 84 C5 C0 F9 FF FF 0F B7 00 EB 3E F6 C3 40 74 42 85 C9 75 0E 83 C7 04 89 BD B0 F5 FF FF 8B 47 FC EB 27 8B 85 88 F5 FF FF 83 F8 63 0F 87 25 F6 FF FF 83 BD B8 F5 FF FF 00 0F 84 1E FA FF FF 03 C0 8B 84 C5 C0 F9 FF FF 8B 00 99 8B C8 8B DA 33 D2 EB 41 85 C9 75 12 83 C7 04 33 D2 89 BD B0 F5 FF FF 8B DA 8B 4F FC EB 2B 8B 85 88 F5 FF FF 83 F8 63 0F 87 DF F5 FF FF 83 BD B8 F5 FF FF 00 0F 84 D8 F9 FF FF 03 C0 33 D2 8B DA 8B 84 C5 C0 F9 FF FF 8B 08 8B 85 A8 F5 FF FF A8 40 74 1B 3B DA 7F 17 7C 04 3B CA 73 11 F7 D9 13 DA F7 DB 0D 00 01 00 00 89 85 A8 F5 FF FF 89 8D B4 F5 FF FF A9 00 90 00 00 75 08 89 8D B4 F5 FF FF 8B DA 8B 95 A0 F5 FF FF 85 D2 79 05 33 D2 42 EB 14 83 E0 F7 89 85 A8 F5 FF FF B8 00 02 00 00 3B D0 7E 02 8B D0 8B C1 0B C3 75 06 89 85 7C F5 FF FF 8B BD B4 F5 FF FF 8D B5 BB F7 FF FF 8B C2 4A 89 95 A0 F5 FF FF 85 C0 7F 06 8B C7 0B C3 74 33 8B 85 A4 F5 FF FF 99 52 50 }
	condition:
		$1
}

rule file_95_7_0 {
	meta:
		name = "_write_char"
		size = 54
		refs = "0017 __fputwc_nolock"
	strings:
		$1 = { 55 8B EC 8B 45 0C F6 40 0C 40 74 06 83 78 08 00 74 1D 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 B9 FF FF 00 00 66 3B C1 75 08 8B 45 10 83 08 FF 5D C3 8B 45 10 FF 00 5D C3 }
	condition:
		$1
}

rule file_95_9_0 {
	meta:
		name = "_write_string"
		size = 121
		refs = "003f _write_char"
	strings:
		$1 = { 55 8B EC 56 8B 75 18 57 8B 7D 10 8B 06 89 45 18 F6 47 0C 40 74 10 83 7F 08 00 75 0A 8B 4D 14 8B 45 0C 01 01 EB 4F 83 26 00 53 8B 5D 0C 85 DB 7E 41 8B 45 14 50 8B 45 08 4B 57 0F B7 00 50 E8 ?? ?? ?? ?? 8B 45 14 83 C4 0C 83 45 08 02 83 38 FF 75 14 83 3E 2A 75 13 50 57 6A 3F E8 ?? ?? ?? ?? 8B 45 14 83 C4 0C 85 DB 7F CA 83 3E 00 75 05 8B 45 18 89 06 5B 5F 5E 5D C3 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "___common_spow_cout_rare"
		size = 2960
		refs = "0174 _2il0floatpacket_112 01be __vmlsPowHATab 01d9 _2il0floatpacket_113 0376 _2il0floatpacket_114 0384 _2il0floatpacket_115 04ca _2il0floatpacket_124 061f _2il0floatpacket_116 0637 _2il0floatpacket_117 0646 _2il0floatpacket_118 0652 _2il0floatpacket_119 0787 _2il0floatpacket_120 07aa _2il0floatpacket_121 07f0 _2il0floatpacket_122 07fc _2il0floatpacket_123 0944 _2il0floatpacket_126"
	strings:
		$1 = { 56 57 53 55 83 EC 30 8B 44 24 44 66 0F EF C0 8B 54 24 48 F3 0F 10 20 F3 0F 10 1A 0F 28 CC 8B 12 0F 28 D3 8B 00 0F 2E E0 7A 02 74 06 89 44 24 08 EB 0D 0F 28 CC F3 0F 58 CC F3 0F 11 4C 24 08 0F 2E D8 7A 02 74 06 89 54 24 28 EB 0D 0F 28 D3 F3 0F 58 D3 F3 0F 11 54 24 28 0F B6 54 24 2B B8 01 00 00 00 81 E2 80 00 00 00 33 DB C1 EA 07 33 C9 F7 44 24 08 FF FF 7F 00 89 54 24 2C BA 00 00 00 00 0F B7 6C 24 2A 0F 44 D0 81 E5 80 7F 00 00 F7 44 24 28 FF FF 7F 00 0F B7 7C 24 0A 0F 44 D8 81 E7 80 7F 00 00 C1 ED 07 81 FD FF 00 00 00 0F B6 74 24 0B 0F 45 C8 81 E6 80 00 00 00 66 0F 7E D0 25 FF FF FF 7F 89 4C 24 0C C1 EF 07 C1 EE 07 8D 88 00 00 80 C0 81 F9 00 00 00 40 73 42 3D 00 00 80 4B 0F 8D 20 05 00 00 8B C8 81 E1 00 00 80 FF 81 C1 00 00 80 00 C1 E9 17 D3 E0 A9 FF FF 7F 00 75 1D 25 FF FF FF 00 B9 02 00 00 00 3D 00 00 80 00 B8 01 00 00 00 0F 44 C8 89 4C 24 10 EB 08 C7 44 24 10 00 00 00 00 85 F6 75 09 83 FF 7F 0F 84 47 0A 00 00 85 ED 75 08 85 DB 0F 85 7E 04 00 00 33 C9 B8 01 00 00 00 81 FF FF 00 00 00 0F 45 C8 89 4C 24 08 0B D1 0F 84 4C 04 00 00 0B 5C 24 0C 0F 84 42 04 00 00 0F 2E C8 7A 06 0F 84 B2 09 00 00 0F 2E 0D ?? ?? ?? ?? 7A 06 0F 84 73 09 00 00 83 7C 24 08 00 0F 84 96 03 00 00 83 7C 24 0C 00 0F 84 8B 03 00 00 0F 2F C8 77 0B 83 7C 24 10 00 0F 84 46 03 00 00 8B 44 24 10 23 C6 F3 0F 11 4C 24 08 80 64 24 0B 7F 85 FF F3 0F 10 04 85 ?? ?? ?? ?? F3 0F 11 44 24 0C 75 1B F3 0F 10 44 24 08 B9 C0 FF FF FF F3 0F 59 05 ?? ?? ?? ?? F3 0F 11 44 24 08 EB 08 F3 0F 10 44 24 08 33 C9 0F B7 5C 24 0A 81 E3 80 7F 00 00 C1 EB 07 8B 54 24 08 C1 E3 17 81 E2 FF FF 7F 00 F3 0F 11 44 24 18 0B DA 0F B7 44 24 1A 81 C3 00 00 C8 C0 25 7F 80 FF FF 0D 80 3F FF FF 66 89 44 24 1A C1 FB 17 03 D9 8B 4C 24 18 81 E1 00 00 78 00 81 C1 00 00 08 00 C1 E9 14 F3 0F 2A C3 F3 0F 10 2C CD ?? ?? ?? ?? 0F 28 D5 F3 0F 10 24 8D ?? ?? ?? ?? F3 0F 58 D0 F3 0F 10 5C 24 18 F3 0F 11 54 24 20 F3 0F 59 DC F3 0F 10 74 24 20 66 0F 7E DE F3 0F 5C C6 81 E6 00 00 1E 00 F3 0F 58 E8 81 C6 00 00 02 00 C1 EE 12 F3 0F 11 6C 24 24 F3 0F 10 54 24 20 0F 28 EA F3 0F 10 3C F5 ?? ?? ?? ?? F3 0F 10 0C B5 ?? ?? ?? ?? F3 0F 58 EF F3 0F 59 E1 F3 0F 10 44 24 24 F3 0F 11 6C 24 20 F3 0F 59 D9 F3 0F 10 6C 24 20 66 0F 7E DF F3 0F 5C D5 81 E7 00 C0 07 00 F3 0F 58 D7 81 C7 00 40 00 00 C1 EF 0F F3 0F 11 54 24 24 F3 0F 10 6C 24 20 0F 28 FD F3 0F 10 14 FD ?? ?? ?? ?? F3 0F 10 74 24 24 F3 0F 58 FA F3 0F 58 C6 F3 0F 11 7C 24 20 F3 0F 10 7C 24 20 F3 0F 10 34 BD ?? ?? ?? ?? F3 0F 5C EF F3 0F 59 E6 F3 0F 58 EA F3 0F 11 6C 24 24 F3 0F 10 6C 24 20 F3 0F 10 54 24 24 F3 0F 10 7C 24 18 F3 0F 58 C2 0F 28 CF F3 0F 58 04 CD ?? ?? ?? ?? F3 0F 59 DE F3 0F 58 04 F5 ?? ?? ?? ?? 0F 28 D3 F3 0F 58 04 FD ?? ?? ?? ?? F3 0F 5C 15 ?? ?? ?? ?? F3 0F 11 44 24 1C F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C8 F3 0F 11 4C 24 20 F3 0F 10 74 24 20 F3 0F 11 54 24 14 F3 0F 5C 74 24 18 F3 0F 11 74 24 24 F3 0F 10 74 24 20 F3 0F 10 4C 24 24 F3 0F 5C F1 F3 0F 11 74 24 20 F3 0F 10 4C 24 20 F3 0F 5C F9 F3 0F 11 7C 24 24 0F 28 FC F3 0F 59 F8 F3 0F 10 74 24 20 F3 0F 10 4C 24 24 F3 0F 11 7C 24 20 F3 0F 10 44 24 20 F3 0F 5C C4 F3 0F 11 44 24 24 F3 0F 10 7C 24 20 F3 0F 10 44 24 24 F3 0F 5C F8 F3 0F 11 7C 24 20 0F 28 FE F3 0F 10 44 24 20 F3 0F 5C E0 F3 0F 11 64 24 24 F3 0F 10 64 24 20 F3 0F 59 FC F3 0F 59 E1 F3 0F 5C FB 0F 28 DA F3 0F 58 FC F3 0F 58 DD F3 0F 10 44 24 24 F3 0F 11 5C 24 20 F3 0F 10 64 24 20 F3 0F 59 F0 F3 0F 5C EC F3 0F 59 C8 F3 0F 58 FE F3 0F 58 EA F3 0F 58 CF F3 0F 11 6C 24 24 F3 0F 10 64 24 20 F3 0F 11 64 24 10 0F B7 44 24 12 25 80 7F 00 00 C1 E8 07 03 E8 F3 0F 10 54 24 24 81 FD 09 01 00 00 F3 0F 10 44 24 1C 0F 8D 19 06 00 00 81 FD C0 00 00 00 0F 8F 67 01 00 00 C7 44 24 20 00 00 80 3F F3 0F 10 44 24 20 F3 0F 10 54 24 0C 8B 44 24 4C F3 0F 58 05 ?? ?? ?? ?? F3 0F 11 44 24 20 F3 0F 10 4C 24 20 F3 0F 59 D1 F3 0F 11 10 33 C0 83 C4 30 5D 5B 5F 5E C3 C7 44 24 20 00 00 00 00 F3 0F 10 4C 24 20 F3 0F 10 44 24 20 F3 0F 5E C8 8B 54 24 4C F3 0F 11 4C 24 20 8B 44 24 20 89 02 B8 01 00 00 00 83 C4 30 5D 5B 5F 5E C3 83 FF 7F 7D 31 83 7C 24 2C 00 74 16 F3 0F 59 D2 8B 44 24 4C F3 0F 11 10 33 C0 83 C4 30 5D 5B 5F 5E C3 8B 44 24 4C C7 00 00 00 00 00 33 C0 83 C4 30 5D 5B 5F 5E C3 83 7C 24 2C 00 74 21 8B 44 24 10 23 C6 8B 4C 24 4C 8B 14 85 ?? ?? ?? ?? 33 C0 89 54 24 18 89 11 83 C4 30 5D 5B 5F 5E C3 F3 0F 59 C9 8B 44 24 10 F3 0F 59 D1 23 C6 F3 0F 59 14 85 ?? ?? ?? ?? 33 C0 8B 54 24 4C F3 0F 11 12 83 C4 30 5D 5B 5F 5E C3 8B 44 24 4C F3 0F 58 E3 F3 0F 11 20 33 C0 83 C4 30 5D 5B 5F 5E C3 8B 54 24 4C F3 0F 58 CA F3 0F 11 4C 24 20 C7 44 24 24 00 00 80 3F 0F B6 6C 24 23 0F B6 44 24 27 83 E5 80 83 E0 7F 0B C5 88 44 24 27 33 C0 F3 0F 10 4C 24 24 F3 0F 10 44 24 24 F3 0F 59 C8 F3 0F 11 0A 83 C4 30 5D 5B 5F 5E C3 C7 44 24 10 02 00 00 00 E9 12 FB FF FF F3 0F 10 5C 24 14 F3 0F 10 3D ?? ?? ?? ?? F3 0F 58 D9 F3 0F 58 CA F3 0F 59 FB F3 0F 58 C1 F3 0F 58 3D ?? ?? ?? ?? F3 0F 59 FB 0F 28 D0 F3 0F 58 3D ?? ?? ?? ?? F3 0F 59 FB F3 0F 58 3D ?? ?? ?? ?? F3 0F 59 FB F3 0F 58 E7 F3 0F 11 64 24 20 F3 0F 10 4C 24 20 F3 0F 10 64 24 10 F3 0F 5C E1 F3 0F 58 E7 F3 0F 11 64 24 24 F3 0F 10 74 24 20 F3 0F 10 4C 24 24 F3 0F 58 D6 F3 0F 11 54 24 20 F3 0F 10 6C 24 20 F3 0F 10 54 24 28 F3 0F 5C F5 F3 0F 58 F0 F3 0F 11 74 24 24 F3 0F 10 35 ?? ?? ?? ?? F3 0F 10 6C 24 20 0F 28 C6 F3 0F 59 C5 F3 0F 59 F2 F3 0F 10 7C 24 24 F3 0F 11 44 24 20 F3 0F 58 F9 F3 0F 10 4C 24 20 F3 0F 59 7C 24 28 F3 0F 5C CD F3 0F 11 4C 24 24 F3 0F 10 5C 24 20 F3 0F 10 44 24 24 F3 0F 5C D8 F3 0F 11 5C 24 20 F3 0F 10 64 24 20 F3 0F 5C EC F3 0F 11 6C 24 24 F3 0F 10 5C 24 20 F3 0F 10 64 24 24 F3 0F 11 74 24 20 F3 0F 10 6C 24 20 F3 0F 5C 6C 24 28 F3 0F 11 6C 24 24 F3 0F 10 4C 24 20 F3 0F 10 44 24 24 F3 0F 5C C8 F3 0F 11 4C 24 20 F3 0F 10 6C 24 20 F3 0F 5C D5 F3 0F 11 54 24 24 F3 0F 10 54 24 20 F3 0F 10 6C 24 24 0F 28 C2 0F 28 CD F3 0F 59 CC F3 0F 59 D4 F3 0F 59 C3 F3 0F 59 DD F3 0F 58 CA F3 0F 10 15 ?? ?? ?? ?? F3 0F 58 CB 0F 28 D8 F3 0F 58 F9 F3 0F 58 DA F3 0F 11 5C 24 20 F3 0F 10 64 24 20 F3 0F 10 0D ?? ?? ?? ?? F3 0F 5C E2 F3 0F 11 24 24 F3 0F 10 34 24 8B 54 24 20 8B C2 83 E2 7F F3 0F 5C C6 F3 0F 11 44 24 04 F3 0F 10 44 24 04 C1 E0 0A F3 0F 58 F8 F3 0F 59 CF F3 0F 10 04 D5 ?? ?? ?? ?? C1 F8 11 F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CF F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CF F3 0F 59 C8 F3 0F 58 0C D5 ?? ?? ?? ?? 0F 28 D1 F3 0F 58 D0 F3 0F 11 54 24 18 0F B7 4C 24 1A 8B D1 81 E2 80 7F 00 00 C1 EA 07 83 C2 81 03 D0 81 FA 80 00 00 00 0F 8D 36 02 00 00 83 FA 82 7C 3A 83 C2 7F 81 E1 7F 80 FF FF 0F B6 D2 C1 E2 07 0B CA 66 89 4C 24 1A F3 0F 10 44 24 18 F3 0F 59 44 24 0C 8B 44 24 4C F3 0F 11 44 24 18 F3 0F 11 00 33 C0 83 C4 30 5D 5B 5F 5E C3 81 FA 78 FF FF FF 0F 8C 1E 01 00 00 F3 0F 11 54 24 20 83 C0 40 F3 0F 10 54 24 20 BA 00 00 80 3F F3 0F 10 1D ?? ?? ?? ?? 83 C0 7F 89 54 24 08 F3 0F 5C C2 C1 EA 10 F3 0F 58 C1 F3 0F 11 44 24 24 F3 0F 10 44 24 20 F3 0F 59 D8 F3 0F 10 4C 24 24 F3 0F 11 5C 24 20 F3 0F 10 64 24 20 0F B7 CA F3 0F 5C E0 F3 0F 11 64 24 24 81 E1 7F 80 FF FF F3 0F 10 74 24 20 F3 0F 10 6C 24 24 0F B6 C0 F3 0F 5C F5 F3 0F 11 74 24 20 F3 0F 10 7C 24 20 C1 E0 07 F3 0F 5C C7 F3 0F 11 44 24 24 0B C8 F3 0F 10 44 24 20 33 C0 F3 0F 10 54 24 24 66 89 4C 24 0A F3 0F 58 CA F3 0F 10 5C 24 08 F3 0F 59 CB F3 0F 59 C3 F3 0F 10 25 ?? ?? ?? ?? F3 0F 59 CC F3 0F 59 C4 F3 0F 11 4C 24 20 F3 0F 10 4C 24 20 C7 44 24 20 00 00 80 00 F3 0F 58 C1 F3 0F 10 74 24 20 F3 0F 10 6C 24 20 F3 0F 59 F5 F3 0F 11 74 24 20 F3 0F 10 7C 24 20 F3 0F 10 4C 24 0C F3 0F 58 C7 F3 0F 59 C8 8B 5C 24 4C F3 0F 11 44 24 18 F3 0F 11 0B 83 C4 30 5D 5B 5F 5E C3 81 FA 61 FF FF FF 7C 7F BA 00 00 80 3F 05 BF 00 00 00 89 54 24 08 C1 EA 10 0F B7 CA 0F B6 C0 81 E1 7F 80 FF FF C1 E0 07 0B C8 33 C0 F3 0F 10 5C 24 0C 66 89 4C 24 0A F3 0F 59 1D ?? ?? ?? ?? F3 0F 59 54 24 08 C7 44 24 20 00 00 80 00 F3 0F 59 DA F3 0F 10 54 24 20 F3 0F 10 44 24 20 F3 0F 59 C2 F3 0F 11 44 24 20 F3 0F 10 4C 24 20 8B 5C 24 4C F3 0F 58 D9 F3 0F 11 5C 24 18 F3 0F 11 1B 83 C4 30 5D 5B 5F 5E C3 C7 44 24 20 00 00 80 00 F3 0F 10 44 24 20 F3 0F 10 4C 24 20 F3 0F 59 C8 F3 0F 11 4C 24 20 F3 0F 10 54 24 20 F3 0F 10 5C 24 0C F3 0F 59 DA 8B 44 24 4C F3 0F 11 5C 24 18 F3 0F 11 18 33 C0 83 C4 30 5D 5B 5F 5E C3 C7 44 24 20 00 00 00 7F F3 0F 10 4C 24 20 F3 0F 10 44 24 20 F3 0F 59 C8 F3 0F 11 4C 24 20 F3 0F 10 54 24 20 F3 0F 10 5C 24 0C F3 0F 59 DA 8B 44 24 4C F3 0F 11 5C 24 18 F3 0F 11 18 33 C0 83 C4 30 5D 5B 5F 5E C3 0F B6 44 24 13 25 80 00 00 00 C1 E8 07 8B 54 24 2C 33 D0 33 C0 8B 4C 24 4C F3 0F 10 04 95 ?? ?? ?? ?? F3 0F 59 C0 F3 0F 59 44 24 0C F3 0F 11 01 83 C4 30 5D 5B 5F 5E C3 83 7C 24 10 00 75 0B 83 7C 24 0C 00 0F 85 7B F6 FF FF 8B 44 24 10 83 E0 01 8B 4C 24 4C 8B 14 85 ?? ?? ?? ?? 33 C0 89 11 83 C4 30 5D 5B 5F 5E C3 F3 0F 59 C9 83 7C 24 2C 00 74 28 8B 44 24 10 23 C6 8B 54 24 4C F3 0F 10 04 85 ?? ?? ?? ?? B8 01 00 00 00 F3 0F 5E C1 F3 0F 11 02 83 C4 30 5D 5B 5F 5E C3 8B 44 24 10 23 C6 8B 54 24 4C F3 0F 10 04 85 ?? ?? ?? ?? 33 C0 F3 0F 59 C1 F3 0F 11 02 83 C4 30 5D 5B 5F 5E C3 85 D2 0F 84 B1 F5 FF FF E9 36 FA FF FF 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "__lrotr"
		size = 16
		altNames = "__rotr"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 8B 45 08 83 E1 1F D3 C8 5D C3 }
	condition:
		$1
}

rule file_98_2_0 {
	meta:
		name = "__rotr64"
		size = 54
		refs = "0018 __allshl 0029 __aullshr"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 0C 53 8B 5D 10 56 57 6A 40 59 83 E3 3F 2B CB E8 ?? ?? ?? ?? 8B F0 8B FA 8B 45 08 8B CB 8B 55 0C E8 ?? ?? ?? ?? 0B C6 0B D7 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_1197_2_0 {
	meta:
		name = "__rotl64"
		size = 54
		refs = "0018 __aullshr 0029 __allshl"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 0C 53 8B 5D 10 56 57 6A 40 59 83 E3 3F 2B CB E8 ?? ?? ?? ?? 8B F0 8B FA 8B 45 08 8B CB 8B 55 0C E8 ?? ?? ?? ?? 0B C6 0B D7 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "___vdecl_expf4"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_expf4 000e ___sse2_expf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "___vdecl_ceil2"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_ceil2 000e ___sse2_ceil2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_908_0_0 {
	meta:
		name = "___vdecl_ceilf4"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_ceilf4 000e ___sse2_ceilf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1141_0_0 {
	meta:
		name = "___vdecl_exp2"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_exp2 000e ___sse2_exp2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "___vdecl_floor2"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_floor2 000e ___sse2_floor2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_813_0_0 {
	meta:
		name = "___vdecl_floorf4"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_floorf4 000e ___sse2_floorf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "_cabs"
		size = 59
		refs = "0012 _cimag 0026 _creal 0030 _hypot"
	strings:
		$1 = { 55 8B EC 56 57 83 EC 10 8D 75 08 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 DD 5C 24 10 8B FC 8D 75 08 A5 A5 A5 A5 E8 ?? ?? ?? ?? 59 59 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5D C3 }
	condition:
		$1
}

rule file_1296_0_0 {
	meta:
		name = "_cabsl"
		size = 59
		refs = "0012 _cimagl 0026 _creall 0030 _hypotl"
	strings:
		$1 = { 55 8B EC 56 57 83 EC 10 8D 75 08 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 DD 5C 24 10 8B FC 8D 75 08 A5 A5 A5 A5 E8 ?? ?? ?? ?? 59 59 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5D C3 }
	condition:
		$1
}

rule file_910_0_0 {
	meta:
		name = "_carg"
		size = 59
		refs = "0012 _creal 0026 _cimag 0030 _atan2"
	strings:
		$1 = { 55 8B EC 56 57 83 EC 10 8D 75 08 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 DD 5C 24 10 8B FC 8D 75 08 A5 A5 A5 A5 E8 ?? ?? ?? ?? 59 59 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5D C3 }
	condition:
		$1
}

rule file_510_1_0 {
	meta:
		name = "_cargl"
		size = 59
		refs = "0012 _creall 0026 _cimagl 0030 _atan2l"
	strings:
		$1 = { 55 8B EC 56 57 83 EC 10 8D 75 08 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 51 51 DD 5C 24 10 8B FC 8D 75 08 A5 A5 A5 A5 E8 ?? ?? ?? ?? 59 59 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5D C3 }
	condition:
		$1
}

rule file_105_3_0 {
	meta:
		name = "__mbsnbset_s_l"
		size = 529
		refs = "0048 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 005d __strnset_s 0092 __ismbblead_l 01cc __errno 01d6 __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 56 8B 75 14 33 DB 89 5D F8 89 5D FC 57 85 F6 75 15 39 5D 08 75 19 39 5D 0C 0F 85 D3 01 00 00 33 C0 E9 DD 01 00 00 39 5D 08 0F 84 C3 01 00 00 8B 7D 0C 85 FF 0F 84 B8 01 00 00 FF 75 18 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 E4 39 58 08 75 17 56 FF 75 10 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 8B D8 E9 7F 01 00 00 8B 4D 10 8B C1 8B 75 08 C1 E8 08 89 45 F4 84 C0 0F 84 B3 00 00 00 84 C9 0F 84 BE 00 00 00 8D 4D E0 0F B6 C0 51 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 A7 00 00 00 8B 45 14 A8 01 74 07 33 C9 48 41 89 4D F8 8B CE D1 E8 89 45 14 38 19 74 6B 85 C0 74 64 4F 74 61 8D 4E 01 89 4D F0 38 19 74 5F 39 5D FC 74 04 8B CB EB 14 8D 45 E0 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 8B C8 8B 45 14 8B 55 F4 88 16 8B 75 F0 89 4D FC 4F 74 2C 85 C9 74 05 89 5D FC EB 15 8D 45 E0 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 89 45 FC 8B 45 14 59 8B 4D 10 88 0E 46 48 89 45 14 38 1E 75 98 8B 4D 08 8B 55 F8 EB 6E 8B 4D 08 33 D2 47 88 1E 42 EB 63 8D 45 E0 50 0F B6 C1 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 07 88 1E E9 92 00 00 00 8B CE 38 19 74 41 8B 45 14 8B 4D 10 85 C0 74 30 4F 74 2D 39 5D FC 74 05 89 5D FC EB 18 8D 45 E0 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 8B 4D 10 89 45 FC 8B 45 14 88 0E 46 48 89 45 14 38 1E 75 CC 8B 4D 08 8B D3 EB 05 8B D3 8B 45 14 85 C0 75 27 39 5D FC 74 1E 38 1E 74 1E 4F 74 17 33 D2 42 38 5E 01 75 05 88 1E 47 EB 0A C6 06 20 46 EB 04 4F 74 05 46 38 1E 75 F8 85 FF 75 13 88 19 E8 ?? ?? ?? ?? 6A 16 5B 89 18 E8 ?? ?? ?? ?? EB 0E 85 D2 74 0A E8 ?? ?? ?? ?? 6A 2A 5B 89 18 80 7D EC 00 74 18 8B 4D E8 83 61 70 FD EB 0F E8 ?? ?? ?? ?? 6A 16 5B 89 18 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_107_4_0 {
	meta:
		name = "__mbsncat_l"
		size = 265
		refs = "001f __errno 002a __invalid_parameter_noinfo 005b ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 006c _strncat 008b __ismbslead_l 00d2 __mbsbtype_l"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 8B 5D 10 85 DB 75 08 8B 45 08 E9 EE 00 00 00 56 8B 75 08 85 F6 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 CE 00 00 00 57 8B 7D 0C 85 FF 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 AE 00 00 00 FF 75 14 8D 4D EC E8 ?? ?? ?? ?? 8B 45 F0 83 78 08 00 75 0F 53 57 56 E8 ?? ?? ?? ?? 83 C4 0C 8B D8 EB 7C 8B DE 89 5D FC 8A 06 46 84 C0 75 F9 8D 45 EC 4E 50 56 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 01 4E 8B 4D 10 8A 17 49 8B 5D F0 0F B6 C2 F6 44 18 19 04 8B 5D FC 88 16 74 35 8A 47 01 83 C7 02 88 46 01 83 C6 02 84 C0 75 2B 88 46 FE 3B F3 74 2A 8D 45 EC 50 8B C6 2B C3 48 50 53 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 01 75 12 C6 46 FF 00 EB 0F 46 47 84 D2 74 D8 85 C9 75 AC EB D2 C6 06 00 80 7D F8 00 74 07 8B 45 F4 83 60 70 FD 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_108_3_0 {
	meta:
		name = "__mbsncat_s_l"
		size = 558
		refs = "003a __errno 0044 __invalid_parameter_noinfo 0058 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 006d _strncat_s 00bd __ismbblead_l"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 14 53 56 8B 75 08 33 DB 89 5D F8 57 85 C0 75 0B 85 F6 75 0B 39 5D 0C 75 18 EB 27 85 F6 74 12 39 5D 0C 76 0D 8B 7D 10 85 C0 74 1E 85 FF 75 1A 88 1E E8 ?? ?? ?? ?? 6A 16 5B 89 18 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 8B E5 5D C3 FF 75 18 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 E4 39 58 08 75 17 FF 75 14 57 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 10 8B D8 E9 9D 01 00 00 8B 45 0C 8B FE 8B C8 38 1F 74 04 47 49 75 F8 89 4D FC 85 C9 75 0E 88 1E E8 ?? ?? ?? ?? 6A 16 E9 5F 01 00 00 3B C8 73 4D 8D 47 FF 89 45 F0 8B D0 89 55 F4 3B C6 72 28 8B D8 8D 45 E0 50 0F B6 03 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 05 4B 3B DE 73 E8 8B 4D FC 8B 45 F0 89 5D F4 33 DB 8B 55 F4 2B C2 A8 01 74 10 8B 7D F0 41 89 4D FC C7 45 F8 01 00 00 00 88 1F 8B 45 14 83 F8 FF 75 1B 8B 55 10 2B FA 8A 02 88 04 17 42 84 C0 0F 84 84 00 00 00 49 89 4D FC 75 EC EB 7C 85 C0 74 76 8B 55 10 8D 45 E0 50 0F B6 02 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 2B 8B 45 10 8D 50 01 80 3A 00 74 45 8B 4D FC 83 F9 02 76 38 8A 00 88 07 8A 02 88 47 01 83 C7 02 42 83 E9 02 89 55 10 89 4D FC EB 15 8B 55 10 8A 02 88 07 47 42 89 55 10 84 C0 74 1E FF 4D FC 74 19 8B 45 14 48 89 45 14 75 A4 EB 11 89 5D FC EB 09 88 1F C7 45 F8 01 00 00 00 8B 45 14 85 C0 75 02 88 1F 83 7D FC 00 75 73 83 7D 14 FF 75 5A 83 7D F8 00 74 0B E8 ?? ?? ?? ?? C7 00 2A 00 00 00 8B 55 0C 83 FA 01 76 38 8D 4A FE 03 CE 89 4D 14 8B F9 3B CE 72 1E 8D 45 E0 50 0F B6 07 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 05 4F 3B FE 73 E8 8B 4D 14 8B 55 0C 8B C1 2B C7 A8 01 74 04 88 19 EB 04 88 5C 16 FF 6A 50 5B EB 23 88 1E E8 ?? ?? ?? ?? 6A 22 5B 89 18 E8 ?? ?? ?? ?? EB 10 83 7D F8 00 74 0A E8 ?? ?? ?? ?? 6A 2A 5B 89 18 80 7D EC 00 0F 84 26 FE FF FF 8B 4D E8 83 61 70 FD E9 1A FE FF FF }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "_atanh"
		size = 148
		refs = "0009 __dtest 0041 __fperrraise 0047 __Nan_C 0064 __Inf_C 0081 _log1p 0087 __real@3fe0000000000000"
	strings:
		$1 = { 55 8B EC 8D 45 08 56 50 E8 ?? ?? ?? ?? 98 33 F6 59 2B C6 74 79 48 48 74 75 D9 EE DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 06 D9 E0 46 DD 55 08 D9 E8 D8 D1 DF E0 F6 C4 05 7A 14 DD D9 6A 01 DD D8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 EB 43 DD E1 DF E0 F6 C4 44 7A 1A DD D9 6A 04 DD D8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 85 F6 74 24 D9 E0 EB 20 D9 C1 DC C0 D9 C9 DE E2 51 51 DE F1 DD 1C 24 E8 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? 59 EB DA DD 45 08 5E 5D C3 }
	condition:
		$1
}

rule file_1226_0_0 {
	meta:
		name = "_atanhl"
		size = 148
		refs = "0009 __ldtest 0041 __fperrraise 0047 __LNan_C 0064 __LInf_C 0081 _log1pl 0087 __real@3fe0000000000000"
	strings:
		$1 = { 55 8B EC 8D 45 08 56 50 E8 ?? ?? ?? ?? 98 33 F6 59 2B C6 74 79 48 48 74 75 D9 EE DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 06 D9 E0 46 DD 55 08 D9 E8 D8 D1 DF E0 F6 C4 05 7A 14 DD D9 6A 01 DD D8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 EB 43 DD E1 DF E0 F6 C4 44 7A 1A DD D9 6A 04 DD D8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 85 F6 74 24 D9 E0 EB 20 D9 C1 DC C0 D9 C9 DE E2 51 51 DE F1 DD 1C 24 E8 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? 59 EB DA DD 45 08 5E 5D C3 }
	condition:
		$1
}

rule file_111_1_0 {
	meta:
		name = "__purecall"
		size = 34
		refs = "0002 ___pPurecall 0008 __imp__DecodePointer@4 0017 __set_abort_behavior 001e _abort"
	strings:
		$1 = { FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 02 FF D0 6A 01 6A 00 E8 ?? ?? ?? ?? 59 59 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "_free"
		size = 56
		refs = "0010 __crtheap 0016 __imp__HeapFree@12 0020 __errno 0028 __imp__GetLastError@0 002e __get_errno_from_oserr"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 74 2D FF 75 08 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 18 56 E8 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 89 06 5E 5D C3 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "__splitpath"
		size = 74
		refs = "0041 __splitpath_helper"
	strings:
		$1 = { 55 8B EC 8B 45 18 B9 00 01 00 00 F7 D8 1B C0 23 C1 50 FF 75 18 8B 45 14 F7 D8 1B C0 23 C1 50 8B 45 10 FF 75 14 F7 D8 1B C0 23 C1 50 8B 45 0C FF 75 10 F7 D8 1B C0 83 E0 03 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 24 5D C3 }
	condition:
		$1
}

rule file_580_0_0 {
	meta:
		name = "__wsplitpath"
		size = 74
		refs = "0041 __wsplitpath_helper"
	strings:
		$1 = { 55 8B EC 8B 45 18 B9 00 01 00 00 F7 D8 1B C0 23 C1 50 FF 75 18 8B 45 14 F7 D8 1B C0 23 C1 50 8B 45 10 FF 75 14 F7 D8 1B C0 23 C1 50 8B 45 0C FF 75 10 F7 D8 1B C0 83 E0 03 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 24 5D C3 }
	condition:
		$1
}

rule file_114_1_0 {
	meta:
		name = "__splitpath_helper"
		size = 521
		refs = "0096 __mbsnbcpy_s 00c0 __ismbblead 01dc __errno 01ea __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 51 51 83 65 FC 00 8B 55 10 53 56 57 8B 7D 08 85 FF 74 0B 8B 4D 0C 85 C9 75 12 85 D2 74 12 8B 5D 14 8B 45 24 33 F6 46 E9 72 01 00 00 85 D2 74 EE 8B 5D 14 85 DB 75 07 39 5D 18 75 E5 EB 06 83 7D 18 00 74 DD 83 7D 1C 00 75 08 83 7D 20 00 75 D1 EB 06 83 7D 20 00 74 C9 83 7D 24 00 75 08 83 7D 28 00 75 BD EB 06 83 7D 28 00 74 B5 33 C0 8B F7 40 80 3E 00 74 04 46 48 75 F7 80 3E 3A 75 23 85 C9 74 17 83 FA 03 0F 82 63 01 00 00 6A 02 57 6A FF 51 E8 ?? ?? ?? ?? 83 C4 10 8D 7E 01 89 7D 08 EB 07 85 C9 74 03 C6 01 00 83 65 F8 00 33 DB 8B F7 38 1F 74 60 8B 7D F8 0F BE 06 50 E8 ?? ?? ?? ?? 59 85 C0 74 03 46 EB 15 8A 06 3C 2F 74 0C 3C 5C 74 08 3C 2E 75 07 8B DE EB 03 8D 7E 01 46 80 3E 00 75 D4 89 7D F8 85 FF 8B 7D 08 74 27 8B 4D 14 85 C9 74 1B 8B 45 F8 2B C7 39 45 18 0F 86 92 00 00 00 50 57 6A FF 51 E8 ?? ?? ?? ?? 83 C4 10 8B 7D F8 EB 0A 8B 4D 14 85 C9 74 03 C6 01 00 85 DB 74 3E 3B DF 72 3A 8B 4D 1C 85 C9 74 16 8B C3 2B C7 39 45 20 76 53 50 57 6A FF 51 E8 ?? ?? ?? ?? 83 C4 10 8B 45 24 85 C0 74 3B 2B F3 39 75 28 76 46 56 53 6A FF 50 E8 ?? ?? ?? ?? 83 C4 10 EB 25 8B 4D 1C 85 C9 74 14 2B F7 39 75 20 76 1B 56 57 6A FF 51 E8 ?? ?? ?? ?? 83 C4 10 8B 45 24 85 C0 74 03 C6 00 00 33 C0 EB 75 8B 45 24 8B 5D 14 8B 75 FC EB 0C 8B 45 24 8B 5D 14 8B 75 FC 8B 4D 1C 8B 55 0C 85 D2 74 09 83 7D 10 00 76 03 C6 02 00 85 DB 74 09 83 7D 18 00 76 03 C6 03 00 85 C9 74 09 83 7D 20 00 76 03 C6 01 00 85 C0 74 09 83 7D 28 00 76 03 C6 00 00 E8 ?? ?? ?? ?? 85 FF 75 13 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 10 8B 45 24 EB A7 85 F6 75 E9 6A 22 59 89 08 8B C1 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "__wgetpath"
		size = 195
		refs = "0025 __errno"
	strings:
		$1 = { 55 8B EC 51 53 56 8B 75 08 57 6A 02 5A 6A 3B 58 89 45 FC EB 02 03 F2 66 39 06 74 F9 8B 4D 10 8B FE 49 75 24 E8 ?? ?? ?? ?? 8B 5D 0C C7 00 22 00 00 00 2B FE 33 C0 F7 DF 66 89 03 1B FF 23 FE 8B C7 5F 5E 5B 8B E5 5D C3 0F B7 06 8B 5D 0C 66 85 C0 74 5B C7 45 08 22 00 00 00 66 3B 45 FC 74 5C 03 F2 66 3B 45 08 74 16 66 89 03 03 DA 49 75 36 8B FE E8 ?? ?? ?? ?? 6A 22 59 89 08 EB B4 0F B7 06 66 85 C0 74 28 66 3B 45 08 74 12 66 89 03 03 F2 03 DA 49 74 DA 0F B7 06 66 85 C0 75 E8 66 83 3E 00 74 0A 03 F2 0F B7 06 66 85 C0 75 AC 6A 3B 58 66 39 06 0F 85 78 FF FF FF EB 03 6A 3B 58 03 F2 EB EE }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "_acos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __acos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_679_0_0 {
	meta:
		name = "_asin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __asin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "_atan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __atan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_1083_0_0 {
	meta:
		name = "_cos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __cos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_489_0_0 {
	meta:
		name = "_log"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_1247_0_0 {
	meta:
		name = "_log10"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_1253_0_0 {
	meta:
		name = "_sin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __sin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_912_0_0 {
	meta:
		name = "_tan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __tan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_117_1_0 {
	meta:
		name = "__CIacos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIacos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_679_1_0 {
	meta:
		name = "__CIasin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIasin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_234_1_0 {
	meta:
		name = "__CIatan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIatan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1083_1_0 {
	meta:
		name = "__CIcos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIcos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_489_1_0 {
	meta:
		name = "__CIlog"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1247_1_0 {
	meta:
		name = "__CIlog10"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_634_1_0 {
	meta:
		name = "__CIpow"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIpow_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1253_1_0 {
	meta:
		name = "__CIsin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIsin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_912_1_0 {
	meta:
		name = "__CItan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CItan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_117_2_0 {
	meta:
		name = "__CIacos_default"
		size = 203
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002d __load_CW 004a ___fastflag 0051 __fast_exit 005c _NAME_ 0061 __math_exit 008b __convertTOStoQNaN 00a3 __indefinite 00c5 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 6D 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? 3D 00 00 F0 3F 73 2D D9 E8 D8 C1 D9 E8 D8 E2 DE C9 D9 FA D9 C9 D9 F3 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0D 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? 77 38 8B 44 24 0C 8B C8 25 FF FF 0F 00 0B 44 24 08 75 27 81 E1 00 00 00 80 DD D8 74 04 D9 EB EB C2 D9 EE EB BE E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0D 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "___avx_cosf8"
		size = 3200
		refs = "0013 ___common_scos_data 0130 ___common_scos_cout_rare 01df ___common_scos_reduction_data"
	strings:
		$1 = { 55 8B EC 83 E4 C0 56 57 53 81 EC F4 02 00 00 C5 FC 54 15 ?? ?? ?? ?? C5 E1 EF DB C5 EC C2 25 ?? ?? ?? ?? 1E C4 E3 7D 19 E5 01 C5 D9 6B F5 C5 C9 63 FB C5 F9 D7 C7 84 C0 0F 85 FB 00 00 00 C5 FC 58 3D ?? ?? ?? ?? 33 DB C5 FC 10 35 ?? ?? ?? ?? C5 C4 59 15 ?? ?? ?? ?? C5 EC 58 D6 C5 E1 72 F2 1F C4 E3 7D 19 D5 01 C5 EC 5C D6 C5 D1 72 F5 1F C5 EC 5C 25 ?? ?? ?? ?? C5 DC 59 15 ?? ?? ?? ?? C5 FC 5C D2 C4 E3 65 18 ED 01 C5 DC 59 1D ?? ?? ?? ?? C5 EC 5C D3 C5 DC 59 1D ?? ?? ?? ?? C5 EC 5C D3 C5 DC 59 1D ?? ?? ?? ?? C5 EC 5C D3 C5 EC 59 DA C5 E4 59 25 ?? ?? ?? ?? C5 DC 58 25 ?? ?? ?? ?? C5 DC 59 E3 C5 DC 58 25 ?? ?? ?? ?? C5 DC 59 E3 C5 DC 58 25 ?? ?? ?? ?? C5 DC 59 DB C5 EC 57 D5 C5 E4 59 DA C5 E4 58 D2 84 DB 75 11 C5 FC 28 C2 81 C4 F4 02 00 00 5B 5F 5E 8B E5 5D C3 C5 FC 11 04 24 C5 FC 11 54 24 40 85 DB 74 E0 33 F6 0F A3 F3 72 0E 46 83 FE 20 7C F5 C5 FC 10 54 24 40 EB CB C5 F8 77 8D 44 B4 40 8D 14 B4 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB DC C5 FC 10 25 ?? ?? ?? ?? BA 00 00 80 7F C5 FC 11 44 24 40 C5 F9 6E FA C5 DC 54 EA C5 D4 C2 D4 00 C4 E3 7D 19 C4 01 C5 F8 11 A4 24 90 00 00 00 C4 E3 7D 19 D5 01 C5 E9 6B F5 C5 C9 63 DB C5 F9 70 D7 00 C5 F9 D7 C3 89 84 24 A0 02 00 00 C5 F8 28 C8 C5 E9 DB D9 C5 D1 72 D3 17 C5 E9 DB DC C5 E9 72 D3 17 C5 E1 72 F5 01 C5 E1 FE DD C5 D1 72 F3 02 C5 E1 72 F2 01 C5 F9 7E EA C5 E1 FE DA C5 E1 72 F3 02 C5 F8 11 8C 24 80 00 00 00 C4 E3 79 16 E9 01 C4 E3 79 16 E8 02 C4 E3 79 16 EF 03 C5 F9 7E DE C5 F9 6E 91 ?? ?? ?? ?? C4 E3 79 16 9C 24 AC 02 00 00 01 C4 E3 79 16 9C 24 B0 02 00 00 02 C4 E3 79 16 DB 03 C5 F9 6E 9A ?? ?? ?? ?? C5 E1 6C EA C5 F9 6E 98 ?? ?? ?? ?? C5 F9 6E 97 ?? ?? ?? ?? C5 E1 6C DA 89 B4 24 A8 02 00 00 C5 D0 C6 F3 88 C5 F9 6E 9E ?? ?? ?? ?? 8B B4 24 AC 02 00 00 89 BC 24 A4 02 00 00 C5 F9 6E 83 ?? ?? ?? ?? C5 F9 6E 96 ?? ?? ?? ?? 8B B4 24 B0 02 00 00 C5 E1 6C EA C5 F9 6E 93 ?? ?? ?? ?? C5 F9 6E 9E ?? ?? ?? ?? C5 E1 6C DA C5 D0 C6 EB 88 C5 F9 6E 9A ?? ?? ?? ?? C5 F9 6E 91 ?? ?? ?? ?? C5 E1 6C FA C5 F9 6E 97 ?? ?? ?? ?? 8B BC 24 A8 02 00 00 C5 F9 6E 98 ?? ?? ?? ?? C5 E1 6C DA C5 C0 C6 FB 88 C5 F9 6E 9F ?? ?? ?? ?? 8B BC 24 AC 02 00 00 C5 F8 11 B4 24 A0 00 00 00 C5 F8 11 AC 24 B0 00 00 00 C5 F9 6E 97 ?? ?? ?? ?? C5 E1 6C D2 C5 F9 6E 9E ?? ?? ?? ?? C5 E1 6C D8 C5 E8 C6 D3 88 C5 F8 11 94 24 C0 00 00 00 C5 F9 6E 9A ?? ?? ?? ?? C5 F9 6E 91 ?? ?? ?? ?? B9 FF FF 7F 00 C5 E1 6C DA C5 F9 6E 90 ?? ?? ?? ?? 8B 84 24 A4 02 00 00 8B 94 24 A8 02 00 00 C5 F9 6E 80 ?? ?? ?? ?? B8 FF FF 00 00 C5 E9 6C D0 C5 E0 C6 DA 88 C5 F8 11 9C 24 D0 00 00 00 C5 F9 6E 9A ?? ?? ?? ?? BA 00 00 00 80 C5 F9 6E 97 ?? ?? ?? ?? BF 00 00 80 28 C5 F9 6E 83 ?? ?? ?? ?? BB 00 00 80 00 C5 E1 6C DA C5 F9 6E 96 ?? ?? ?? ?? BE FF 00 00 00 C5 E9 6C D0 C5 E0 C6 C2 88 C5 F9 6E D9 C5 F9 70 D3 00 C5 F9 6E DB C5 F9 70 DB 00 C5 E9 DB E4 C5 E9 DB C9 C5 D9 FE D3 C5 F9 6E E0 C5 F1 FE CB C5 F9 70 DC 00 B9 00 00 80 3F C5 C9 DB E3 C5 D1 DB F3 C5 D1 72 D7 10 C5 C1 DB FB C5 FA 7F AC 24 10 01 00 00 BB 00 00 40 47 C5 F8 10 AC 24 C0 00 00 00 B8 FF FF 03 00 C5 FA 7F B4 24 00 01 00 00 C5 C9 72 D5 10 C5 D1 DB EB C5 FA 7F AC 24 40 01 00 00 C5 F8 10 AC 24 D0 00 00 00 C5 F8 11 84 24 E0 00 00 00 C5 F9 72 D0 10 C5 FA 7F 84 24 60 01 00 00 C5 F9 72 D1 10 C5 F1 DB CB C5 D1 72 D5 10 C5 FA 7F AC 24 50 01 00 00 C5 D1 72 D2 10 C5 E9 DB D3 C5 FA 7F A4 24 F0 00 00 00 C4 E2 71 40 E4 C5 FA 7F A4 24 A0 01 00 00 C4 E2 69 40 A4 24 00 01 00 00 C5 FA 7F B4 24 20 01 00 00 C5 FA 7F BC 24 30 01 00 00 C5 FA 7F A4 24 B0 01 00 00 C4 E2 69 40 F6 C4 E2 71 40 A4 24 10 01 00 00 C5 FA 7F B4 24 D0 01 00 00 C4 E2 71 40 F7 C5 E1 DB BC 24 D0 00 00 00 C5 FA 7F A4 24 C0 01 00 00 C4 E2 79 40 E7 C5 FA 6F BC 24 50 01 00 00 C5 D9 72 D4 10 C5 FA 7F 8C 24 80 01 00 00 C4 E2 71 40 CF C5 FA 7F 84 24 70 01 00 00 C4 E2 79 40 C7 C5 C1 72 D1 10 C5 FA 7F B4 24 E0 01 00 00 C5 C9 DB F3 C5 F9 FE C7 C5 C9 FE F0 C5 D9 FE FE C5 E1 DB A4 24 E0 00 00 00 C5 FA 7F 94 24 90 01 00 00 C4 E2 69 40 94 24 40 01 00 00 C4 E2 51 40 CC C5 E9 DB C3 C5 FA 7F 94 24 F0 01 00 00 C5 C9 72 D1 10 C5 FA 6F 8C 24 60 01 00 00 C5 FA 6F 94 24 90 01 00 00 C4 E2 69 40 D1 C4 E2 51 40 E1 C5 E9 72 D2 10 C5 D9 FE E2 C5 F9 FE C4 C5 FA 7F BC 24 00 02 00 00 C5 C9 FE C8 C5 FA 6F A4 24 70 01 00 00 C5 C9 72 D7 10 C5 FA 6F BC 24 E0 01 00 00 C4 E2 59 40 84 24 30 01 00 00 C5 C1 72 D7 10 C5 E1 DB 94 24 C0 01 00 00 C5 F9 FE C7 C5 FA 7F 8C 24 10 02 00 00 C5 E9 FE D0 C5 C1 72 D1 10 C5 C9 FE C2 C5 FA 6F 8C 24 F0 01 00 00 C4 E2 51 40 B4 24 40 01 00 00 C5 F1 72 D1 10 C5 E1 DB 94 24 D0 01 00 00 C5 C9 FE F1 C5 E9 FE D6 C5 C1 FE F2 C5 FA 6F 94 24 C0 01 00 00 C4 E2 59 40 BC 24 10 01 00 00 C5 E9 72 D2 10 C5 E1 DB 8C 24 A0 01 00 00 C5 C1 FE FA C5 FA 7F 84 24 20 02 00 00 C5 F9 72 D0 10 C5 F1 FE D7 C5 FA 7F B4 24 30 02 00 00 C5 F9 FE FA C5 E9 72 D6 10 C5 FA 6F B4 24 D0 01 00 00 C4 E2 51 40 8C 24 20 01 00 00 C5 C9 72 D6 10 C5 E1 DB 84 24 B0 01 00 00 C5 F1 FE CE C5 F9 FE C1 C5 C9 72 D7 10 C5 E9 FE C8 C5 C1 DB FB C5 F8 10 84 24 A0 00 00 00 C5 FA 6F 94 24 80 01 00 00 C5 F9 72 D0 10 C4 E2 69 40 D0 C4 E2 59 40 84 24 F0 00 00 00 C5 E9 DB D3 C5 FA 6F A4 24 A0 01 00 00 C5 D9 72 D4 10 C5 F9 FE C4 C5 E9 FE D0 C5 C9 FE F2 C5 E9 72 D1 10 C5 F8 10 A4 24 B0 00 00 00 C5 F9 72 F6 10 C5 FA 6F B4 24 90 01 00 00 C5 F9 FE C7 C5 C1 72 D4 10 C5 F1 DB CB C4 E2 49 40 E7 C4 E2 51 40 B4 24 00 01 00 00 C5 D9 DB E3 C5 FA 6F AC 24 B0 01 00 00 C5 D1 72 D5 10 C5 C9 FE FD C5 D9 FE E7 C5 E9 FE D4 C5 D9 72 F2 10 C5 FA 6F BC 24 30 02 00 00 C5 D9 FE E9 C5 FA 6F A4 24 20 02 00 00 C5 E1 DB B4 24 00 02 00 00 C5 E9 72 F4 10 C5 E1 DB 9C 24 10 02 00 00 C5 D9 72 F7 10 C5 D9 FE E3 C5 F9 6E DA C5 E9 FE CE C5 F9 6E F1 C5 F9 70 D3 00 BA 00 00 00 34 C5 E9 DB 9C 24 80 00 00 00 B9 FF 01 00 00 C5 F9 70 F6 00 C5 E9 DB 94 24 90 00 00 00 C5 E1 EF FE C5 FA 7F 84 24 40 02 00 00 C5 F9 72 D0 09 C5 FA 7F AC 24 50 02 00 00 C5 D1 72 D5 09 C5 E9 EF F6 C5 F9 EB C7 C5 D1 EB EE C4 E3 7D 18 ED 01 C5 F9 6E C3 C5 F9 70 F0 00 BB DB 0F C9 40 C4 E3 4D 18 FE 01 C5 C4 58 C5 C5 FC 5C F7 C5 F9 6E FE C5 D4 5C EE BE 00 10 C9 40 C5 FC 11 6C 24 60 C5 F9 6E EF C5 F9 70 F5 00 C5 E9 EF EE BF 7A 77 95 B7 C5 F8 11 84 24 60 02 00 00 C4 E3 7D 19 84 24 70 02 00 00 01 C5 F9 70 C7 00 C5 F9 6E F8 C5 F9 70 FF 00 B8 00 F0 FF FF C5 FA 7F 84 24 80 02 00 00 C5 E1 EF C6 C5 C1 DB F1 C5 C1 DB FC C5 C9 72 F6 05 C5 C1 72 F7 05 C5 C9 EB F0 C5 C1 EB FD C5 F1 72 D1 12 C5 D9 72 D4 12 C4 E3 4D 18 FF 01 C4 E3 7D 18 ED 01 C5 F9 6E C2 C5 C4 5C FD BA FF FF FF 7F C5 F9 70 E8 00 C5 E1 EF C5 C5 F9 6E D9 C5 F9 70 DB 00 C5 E9 EF D5 C5 E1 DB B4 24 40 02 00 00 B9 00 00 80 35 C5 E1 DB 9C 24 50 02 00 00 C5 D1 72 F6 0E C5 E1 72 F3 0E C5 D1 EB E9 C5 E1 EB E4 C5 D1 EB C8 C5 D9 EB DA C4 E3 75 18 EB 01 C5 FC 10 4C 24 60 C4 E3 7D 18 D2 01 C5 D4 5C C2 C5 F9 6E EF C5 F4 58 F0 C5 F4 5C E6 C5 FC 58 DC C5 F9 6E E6 C5 E4 58 D7 C5 F9 6E FB C5 F9 70 DC 00 C5 F9 6E E0 C5 F9 70 C7 00 C5 F9 70 FD 00 C5 F9 70 EC 00 C4 E3 55 18 E5 01 C5 CC 54 E4 C5 CC 5C F4 C4 E3 7D 18 C8 01 C4 E3 65 18 C3 01 C4 E3 45 18 DF 01 C5 FC 59 FC C5 FC 59 EE C5 E4 59 C4 C5 F4 59 D2 C5 F9 6E C9 C5 E4 59 F6 C5 D4 58 C0 C5 F9 6E EA C5 EC 58 E6 C5 F9 70 F5 00 C5 FC 58 D4 C5 FC 10 44 24 40 C5 C4 58 E2 C5 C4 5C DC C5 F9 70 F9 00 C5 E4 58 D2 C4 E3 4D 18 DE 01 C5 FC 54 EB C4 E3 45 18 F7 01 C5 D4 C2 DE 1E C5 D4 C2 EE 12 C5 D4 54 E8 C5 E4 54 E4 C5 E4 54 D2 C5 D4 56 E4 C5 FA 6F AC 24 80 02 00 00 C5 FC 11 14 24 C5 D1 DB 94 24 60 02 00 00 C5 C9 72 F2 04 C5 D1 DB 94 24 70 02 00 00 C5 E9 72 F2 04 C5 F9 7E F6 C5 F9 7E D2 C5 DC 59 DC C4 E3 79 16 F3 01 C4 E3 79 16 F7 02 C4 E3 79 16 F1 03 C4 E3 79 16 94 24 BC 02 00 00 01 C4 E3 79 16 94 24 C0 02 00 00 02 C4 E3 79 16 D0 03 C5 F9 6E 96 ?? ?? ?? ?? C5 F9 6E AB ?? ?? ?? ?? C5 E9 6C F5 C5 F9 6E 97 ?? ?? ?? ?? C5 F9 6E A9 ?? ?? ?? ?? 89 94 24 B8 02 00 00 C5 E9 6C D5 C5 F9 6E AA ?? ?? ?? ?? 8B 94 24 BC 02 00 00 C5 C8 C6 D2 88 89 8C 24 B4 02 00 00 C5 F9 6E B2 ?? ?? ?? ?? 8B 94 24 C0 02 00 00 C5 D1 6C FE C5 F9 6E B0 ?? ?? ?? ?? C5 F9 6E AA ?? ?? ?? ?? C5 D1 6C EE C5 C0 C6 ED 88 C5 F9 6E B3 ?? ?? ?? ?? C5 F9 6E 88 ?? ?? ?? ?? 89 9C 24 94 02 00 00 89 B4 24 98 02 00 00 89 BC 24 9C 02 00 00 C4 E3 6D 18 D5 01 C5 F9 6E AE ?? ?? ?? ?? C5 D1 6C FE C5 F9 6E B1 ?? ?? ?? ?? 8B 8C 24 B8 02 00 00 C5 F9 6E AF ?? ?? ?? ?? C5 D1 6C EE C5 F9 6E B1 ?? ?? ?? ?? 8B 8C 24 BC 02 00 00 C5 C0 C6 ED 88 C5 F9 6E B9 ?? ?? ?? ?? C5 C9 6C F7 C5 F9 6E BA ?? ?? ?? ?? C5 C1 6C F9 C5 C8 C6 F7 88 C4 E3 55 18 EE 01 C5 F9 6E B3 ?? ?? ?? ?? C5 FC 11 6C 24 20 C5 F9 6E AE ?? ?? ?? ?? C5 D1 6C F6 8B 9F ?? ?? ?? ?? 89 9C 24 90 02 00 00 8B 9C 24 A0 02 00 00 8B B4 24 B4 02 00 00 8B BC 24 B8 02 00 00 C5 FC 11 44 24 40 C5 F9 6E AC 24 90 02 00 00 C5 F9 6E 86 ?? ?? ?? ?? C5 D1 6C C8 C5 C8 C6 F9 88 89 9C 24 A0 02 00 00 8B 9C 24 98 02 00 00 C5 F9 6E B7 ?? ?? ?? ?? C5 F9 6E A9 ?? ?? ?? ?? C5 F9 6E 82 ?? ?? ?? ?? C5 F9 6E 88 ?? ?? ?? ?? C5 C9 6C F5 C5 F9 6C E9 C5 C8 C6 C5 88 C5 F9 6E AB ?? ?? ?? ?? 8B 9C 24 94 02 00 00 C5 F9 6E B6 ?? ?? ?? ?? C4 E3 45 18 F8 01 C5 F9 6E 83 ?? ?? ?? ?? 8B 9C 24 9C 02 00 00 C5 FC 11 7C 24 60 C5 D1 6C F8 C5 F9 6E 8B ?? ?? ?? ?? C5 F1 6C EE C5 C0 C6 ED 88 C5 F9 6E 87 ?? ?? ?? ?? C5 F9 6E 89 ?? ?? ?? ?? C5 F9 6E B2 ?? ?? ?? ?? C5 F9 6E B8 ?? ?? ?? ?? C5 F9 6C C1 C5 C9 6C CF C5 F8 C6 F1 88 C5 FC 10 7C 24 20 8B 9C 24 A0 02 00 00 C4 E3 55 18 EE 01 C5 DC 59 C5 C5 EC 59 F4 C5 FC 11 AC 24 80 00 00 00 C5 C4 58 C8 C5 CC 58 E9 C5 C4 5C F9 C5 C4 58 F8 C5 F4 5C C5 C5 FC 58 CE C5 E4 59 35 ?? ?? ?? ?? C5 F4 58 C7 C5 CC 58 0D ?? ?? ?? ?? C5 F4 59 F3 C5 CC 59 CC C5 EC 58 B4 24 80 00 00 00 C5 E4 59 15 ?? ?? ?? ?? C5 EC 58 15 ?? ?? ?? ?? C5 EC 59 DB C5 FC 10 54 24 20 C5 DC 59 E2 C5 E4 59 DA C5 CC 5C E4 C5 DC 59 3C 24 C5 F4 59 CC C5 C4 58 74 24 60 C5 F4 58 C0 C5 E4 58 D6 C5 EC 58 D8 C5 FC 10 44 24 40 C5 D4 58 D3 E9 74 F4 FF FF 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "___common_dcosh_cout_rare"
		size = 976
		refs = "0011 __vmldCoshHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 83 EC 3C 8B 4D 08 F2 0F 10 0D ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 51 06 81 E2 F0 7F 00 00 81 FA F0 7F 00 00 0F 84 7F 03 00 00 F2 0F 10 01 0F B6 51 07 F2 0F 11 44 24 20 83 E2 7F 88 54 24 27 0F B7 4C 24 26 81 E1 F0 7F 00 00 81 F9 90 3C 00 00 0F 8E 34 03 00 00 F2 0F 10 7C 24 20 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C7 0F 86 FC 02 00 00 F2 0F 11 4C 24 30 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CF 66 0F 2F 3D ?? ?? ?? ?? 0F 82 2B 01 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 C8 F2 0F 11 0C 24 F2 0F 10 0C 24 8B 0C 24 8B D1 83 E2 3F F2 0F 5C 0D ?? ?? ?? ?? F2 0F 11 4C 24 08 F2 0F 10 54 24 08 F2 0F 59 15 ?? ?? ?? ?? F2 0F 10 5C 24 08 F2 0F 5C FA F2 0F 59 1D ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C FB F2 0F 59 CF C1 E2 04 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF F2 0F 10 A2 ?? ?? ?? ?? C1 E9 06 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF 81 C1 FF 03 00 00 49 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF 81 E1 FF 07 00 00 81 F9 FE 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF F2 0F 59 CF F2 0F 58 CF F2 0F 59 CC F2 0F 58 8A ?? ?? ?? ?? F2 0F 58 CC 77 2A C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 36 F2 0F 10 44 24 30 F2 0F 59 C1 8B 45 0C F2 0F 11 00 33 C0 83 C4 3C 5E 8B E5 5D C3 49 81 E1 FF 07 00 00 0F B7 44 24 36 C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 36 33 C0 F2 0F 59 4C 24 30 F2 0F 59 0D ?? ?? ?? ?? 8B 55 0C F2 0F 11 0A 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 2D ?? ?? ?? ?? 0F B7 4C 24 36 81 E1 0F 80 FF FF F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 0C 24 F2 0F 10 34 24 8B 34 24 8B D6 C1 EA 06 83 E6 3F 81 C2 FF 03 00 00 F2 0F 5C 35 ?? ?? ?? ?? F2 0F 11 74 24 08 8D 42 FF F2 0F 10 5C 24 08 25 FF 07 00 00 F2 0F 59 1D ?? ?? ?? ?? F7 DA F2 0F 10 44 24 08 83 C2 FC F2 0F 59 05 ?? ?? ?? ?? F2 0F 5C FB F2 0F 10 35 ?? ?? ?? ?? 81 E2 FF 07 00 00 C1 E6 04 F2 0F 5C F8 0F 28 E7 F2 0F 59 E7 F2 0F 59 F4 F2 0F 59 EC F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 F4 F2 0F 59 EC F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 EF F2 0F 59 F4 C1 E0 04 F2 0F 10 9E ?? ?? ?? ?? 0B C8 F2 0F 10 A6 ?? ?? ?? ?? F7 DE 66 89 4C 24 36 81 E1 0F 80 FF FF C1 E2 04 F2 0F 10 4C 24 30 0B CA 66 89 4C 24 36 F2 0F 59 D9 F2 0F 59 E1 F2 0F 10 44 24 30 F2 0F 10 96 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 10 8E ?? ?? ?? ?? F2 0F 59 C8 0F 28 C3 F2 0F 58 C2 F2 0F 11 44 24 10 0F 28 C3 F2 0F 11 4C 24 20 F2 0F 5C DA F2 0F 10 4C 24 10 F2 0F 59 EB F2 0F 5C C1 8B 45 0C F2 0F 58 C2 F2 0F 11 44 24 18 0F 28 C4 F2 0F 10 54 24 20 F2 0F 10 4C 24 10 F2 0F 5C C2 F2 0F 59 C7 F2 0F 59 FB F2 0F 58 C2 F2 0F 11 4C 24 28 F2 0F 58 C4 F2 0F 10 4C 24 18 F2 0F 58 C1 F2 0F 58 C5 F2 0F 10 6C 24 28 F2 0F 59 F5 F2 0F 58 C6 F2 0F 58 C7 F2 0F 11 44 24 10 F2 0F 10 7C 24 10 F2 0F 58 EF F2 0F 11 28 33 C0 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C0 8B 45 0C F2 0F 11 00 B8 03 00 00 00 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? 8B 45 0C F2 0F 58 44 24 20 F2 0F 11 00 33 C0 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 01 F2 0F 59 C0 8B 45 0C F2 0F 11 00 33 C0 83 C4 3C 5E 8B E5 5D C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "_ctanh"
		size = 371
		refs = "0015 _creal 0026 _cimag 0032 __dtest 005f __Zero_C 0077 __real@bff0000000000000 00c9 __Nan_C 00d8 _tan 00e6 _sinh 0107 __Inf_C 0149 _sqrt 015b __Cbuild"
	strings:
		$1 = { 55 8B EC 83 EC 38 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 0C DD 5D F0 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8D 45 F0 50 DD 5D F8 E8 ?? ?? ?? ?? 0F B7 F0 8D 45 F8 50 E8 ?? ?? ?? ?? 33 D2 0F B7 C0 42 83 C4 18 66 3B F2 75 40 0F B7 45 FE D9 EE A9 00 80 00 00 74 0A DD 05 ?? ?? ?? ?? D9 E0 EB 02 D9 C0 D9 C9 DC 5D F0 DF E0 F6 C4 41 75 08 DD 05 ?? ?? ?? ?? EB 02 D9 E8 83 EC 10 D9 C9 DD 5C 24 08 8D 45 D8 E9 C6 00 00 00 6A 02 59 66 3B C1 75 0C DD 45 F8 83 EC 10 DD 54 24 08 EB E4 66 3B F1 75 19 DD 45 F8 D9 EE DD E9 DF E0 DD 45 F0 F6 C4 44 7B C5 DD D9 D9 C0 D9 C9 EB BD 66 3B C2 75 08 DD 05 ?? ?? ?? ?? EB CC DD 45 F8 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 5D E8 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DD 45 E8 D9 C0 D8 C9 D9 E8 59 59 DC C1 D9 C9 D8 CB DD 55 E8 D8 CB D8 C1 DD 55 E0 DD 05 ?? ?? ?? ?? DD E9 DF E0 F6 C4 44 7A 20 DD D8 D9 EE D8 D3 DF E0 DD DB F6 C4 41 75 08 DD D8 DD 05 ?? ?? ?? ?? D9 C9 DE CA E9 4B FF FF FF DE FA 83 EC 10 D9 C9 DD 5C 24 08 D9 C9 DC C8 DE C1 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E8 8D 45 C8 DC 75 E0 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "__chkstk"
		size = 43
	strings:
		$1 = { 51 8D 4C 24 04 2B C8 1B C0 F7 D0 23 C8 8B C4 25 00 F0 FF FF 3B C8 72 0A 8B C1 59 94 8B 00 89 04 24 C3 2D 00 10 00 00 85 00 EB E9 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "_fesetround"
		size = 58
		refs = "0016 __getfpcontrolword 0024 __setfpcontrolword 002a _fegetround"
	strings:
		$1 = { 55 8B EC 8B 45 08 25 00 03 00 00 3B 45 08 74 05 33 C0 40 5D C3 E8 ?? ?? ?? ?? 25 FF FC FF FF 0B 45 08 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 33 C9 3B 45 08 0F 95 C1 8B C1 5D C3 }
	condition:
		$1
}

rule file_124_1_0 {
	meta:
		name = "__setdefaultprecision"
		size = 39
		refs = "000f __controlfp_s 0022 __invoke_watson"
	strings:
		$1 = { 56 68 00 00 03 00 68 00 00 01 00 33 F6 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 02 5E C3 56 56 56 56 56 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_125_7_0 {
	meta:
		name = "??$ConcRT_FillBuffer@$0EAB@@details@Concurrency@@YAXAAY0EAB@_WPB_WPAD@Z"
		size = 207
		refs = "000b ?SafeFastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0020 ?GetScheduler@ContextBase@details@Concurrency@@QBEPAVSchedulerBase@23@XZ 002a __imp__GetCurrentThreadId@0 0032 ?ScheduleGroupRefCount@ContextBase@details@Concurrency@@QBEIXZ 004f ??_C@_1CG@CBCHDCDB@?$AA?$FL?$AA?$CF?$AAd?$AA?3?$AA?$CF?$AAd?$AA?3?$AA?$CF?$AAd?$AA?3?$AA?$CF?$AAd?$AA?$CI?$AA?$CF?$AAd?$AA?$CJ?$AA?$FN?$AA?5?$AA?$AA@ 005a _swprintf_s 0087 _vswprintf_s"
	strings:
		$1 = { 55 8B EC 53 56 33 C0 57 8B D8 E8 ?? ?? ?? ?? 8B 75 08 8B F8 B8 01 04 00 00 85 FF 74 5A 8B CF E8 ?? ?? ?? ?? 85 C0 74 4A FF 15 ?? ?? ?? ?? 50 8B CF E8 ?? ?? ?? ?? 50 8B 07 8B CF FF 50 08 50 8B 07 8B CF FF 10 50 8B 07 8B CF FF 50 04 50 68 ?? ?? ?? ?? 68 01 04 00 00 56 E8 ?? ?? ?? ?? 8B D8 83 C4 20 33 FF B8 01 04 00 00 85 DB 79 0B 8B DF EB 07 B8 01 04 00 00 33 FF FF 75 10 2B C3 FF 75 0C 50 8D 04 5E 50 E8 ?? ?? ?? ?? 8B CE 83 C4 10 8D 51 02 66 8B 01 83 C1 02 66 3B C7 75 F5 2B CA D1 F9 85 C9 7E 24 6A 0A 58 66 39 44 4E FE 74 1A 81 F9 00 04 00 00 73 0D 66 89 04 4E 33 C0 66 89 44 4E 02 EB 05 66 89 44 4E FE 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_125_14_0 {
	meta:
		name = "??0_SpinLock@details@Concurrency@@QAE@ACJ@Z"
		size = 72
		refs = "0023 ?_UnderlyingYield@details@Concurrency@@YAXXZ 002b ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 10 33 D2 42 33 C0 56 8B 75 08 57 8B F9 89 37 F0 0F B1 16 85 C0 74 22 83 65 F8 00 C7 45 FC ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 0F 33 D2 42 33 C0 F0 0F B1 11 85 C0 75 E9 8B C7 5F 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_125_36_0 {
	meta:
		name = "?DeleteAsyncTimerAndUnloadLibrary@details@Concurrency@@YAXPAU_TP_TIMER@@@Z"
		size = 60
		refs = "000c ___crtSetThreadpoolTimer 0016 ___crtWaitForThreadpoolTimerCallbacks 001e ___crtCloseThreadpoolTimer 0026 ?CheckOneShotStaticDestruction@SchedulerBase@details@Concurrency@@SAXXZ 002b ?HostModule@details@Concurrency@@3PAUHINSTANCE__@@A 0036 __imp__FreeLibrary@4"
	strings:
		$1 = { 55 8B EC 33 C0 50 50 50 FF 75 08 E8 ?? ?? ?? ?? 6A 01 FF 75 08 E8 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 83 C4 1C E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 74 07 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_125_38_0 {
	meta:
		name = "?FreeLibraryAndDestroyThread@details@Concurrency@@YAXK@Z"
		size = 43
		refs = "0004 ?LoadLibraryCount@details@Concurrency@@3JC 0012 ?CheckOneShotStaticDestruction@SchedulerBase@details@Concurrency@@SAXXZ 0017 ?HostModule@details@Concurrency@@3PAUHINSTANCE__@@A 0025 __imp__FreeLibraryAndExitThread@8"
	strings:
		$1 = { 55 8B EC B9 ?? ?? ?? ?? 83 C8 FF F0 0F C1 01 75 18 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 74 0A FF 75 08 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_125_39_0 {
	meta:
		name = "?InitializeCookie@Security@details@Concurrency@@SAKXZ"
		size = 78
		refs = "0008 ?s_initialized@Security@details@Concurrency@@2JC 0012 ?s_cookie@Security@details@Concurrency@@2KA 0018 __imp__EncodePointer@4 0023 ___security_cookie 0030 __imp__GetCurrentThread@0 0037 __imp__GetThreadTimes@20"
	strings:
		$1 = { 55 8B EC 83 EC 10 C7 05 ?? ?? ?? ?? 01 00 00 00 56 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F0 8D 45 F8 33 35 ?? ?? ?? ?? 50 50 50 8D 45 F0 50 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 08 8B 45 F4 33 45 F0 33 F0 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_125_41_0 {
	meta:
		name = "?LoadLibraryAndCreateThread@details@Concurrency@@YAPAXPAU_SECURITY_ATTRIBUTES@@KP6GKPAX@Z1KPAK@Z"
		size = 77
		refs = "0017 ?__CreateThread@platform@details@Concurrency@@YAPAXPAU_SECURITY_ATTRIBUTES@@IP6GKPAX@Z1KPAK@Z 0028 ?LoadLibraryCount@details@Concurrency@@3JC 0039 ?ReferenceLoadLibrary@details@Concurrency@@YAXXZ 003e ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA"
	strings:
		$1 = { 55 8B EC 57 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F8 83 C4 18 85 FF 74 24 56 33 F6 B8 ?? ?? ?? ?? 46 8B CE F0 0F C1 08 41 3B CE 75 0F E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? F0 0F C1 30 46 5E 8B C7 5F 5D C3 }
	condition:
		$1
}

rule file_125_43_0 {
	meta:
		name = "?ReferenceLoadLibrary@details@Concurrency@@YAXXZ"
		size = 150
		refs = "000a ___security_cookie 0018 __imp__GetModuleHandleA@4 001d ___ImageBase 0035 __imp__GetModuleFileNameW@12 004e __imp__LoadLibraryExW@12 0053 ?HostModule@details@Concurrency@@3PAUHINSTANCE__@@A 005e @__security_check_cookie@4 0068 __imp__GetLastError@0 0080 ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0085 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0091 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 81 EC 1C 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 57 6A 00 FF 15 ?? ?? ?? ?? B9 ?? ?? ?? ?? 3B C1 74 32 BF 04 01 00 00 8D 85 F4 FD FF FF 57 50 51 FF 15 ?? ?? ?? ?? 85 C0 74 29 3B C7 74 25 6A 00 6A 00 8D 85 F4 FD FF FF 50 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B 4D FC 33 CD 5F E8 ?? ?? ?? ?? 8B E5 5D C3 FF 15 ?? ?? ?? ?? 85 C0 7E 08 0F B7 C0 0D 00 00 07 80 50 8D 8D E4 FD FF FF E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_125_45_0 {
	meta:
		name = "?RegisterAsyncTimerAndLoadLibrary@details@Concurrency@@YAPAU_TP_TIMER@@KP6GXPAU_TP_CALLBACK_INSTANCE@@PAXPAU3@@Z1_N@Z"
		size = 104
		refs = "000f ___crtCreateThreadpoolTimer 001d ?ReferenceLoadLibrary@details@Concurrency@@YAXXZ 0024 ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA 003a __allmul 005a ___crtSetThreadpoolTimer"
	strings:
		$1 = { 55 8B EC 51 51 56 6A 00 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 8B F0 83 C4 0C 85 F6 74 47 E8 ?? ?? ?? ?? 33 C0 B9 ?? ?? ?? ?? 40 F0 0F C1 01 6A FF 68 F0 D8 FF FF 6A 00 FF 75 08 E8 ?? ?? ?? ?? 89 45 F8 8B 45 14 0F B6 C0 F7 D8 89 55 FC 6A 00 1B C0 23 45 08 50 8D 45 F8 50 56 E8 ?? ?? ?? ?? 83 C4 10 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_125_46_0 {
	meta:
		name = "?RegisterAsyncWaitAndLoadLibrary@details@Concurrency@@YAPAU_TP_WAIT@@PAXP6GXPAU_TP_CALLBACK_INSTANCE@@0PAU3@K@Z0@Z"
		size = 62
		refs = "000d ___crtCreateThreadpoolWait 001b ?ReferenceLoadLibrary@details@Concurrency@@YAXXZ 0022 ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA 0032 ___crtSetThreadpoolWait"
	strings:
		$1 = { 55 8B EC 56 6A 00 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 8B F0 83 C4 0C 85 F6 74 21 E8 ?? ?? ?? ?? 33 C0 B9 ?? ?? ?? ?? 40 F0 0F C1 01 6A 00 FF 75 08 56 E8 ?? ?? ?? ?? 83 C4 0C 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_125_47_0 {
	meta:
		name = "?UnRegisterAsyncTimerAndUnloadLibrary@details@Concurrency@@YAXPAU_TP_CALLBACK_INSTANCE@@PAU_TP_TIMER@@@Z"
		size = 54
		refs = "000c ___crtSetThreadpoolTimer 0014 ___crtCloseThreadpoolTimer 001c ?CheckOneShotStaticDestruction@SchedulerBase@details@Concurrency@@SAXXZ 0021 ?HostModule@details@Concurrency@@3PAUHINSTANCE__@@A 002e ___crtFreeLibraryWhenCallbackReturns"
	strings:
		$1 = { 55 8B EC 33 C0 50 50 50 FF 75 0C E8 ?? ?? ?? ?? FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 74 0B 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_125_48_0 {
	meta:
		name = "?UnRegisterAsyncWaitAndUnloadLibrary@details@Concurrency@@YAXPAU_TP_CALLBACK_INSTANCE@@PAU_TP_WAIT@@@Z"
		size = 53
		refs = "000b ___crtSetThreadpoolWait 0013 ___crtCloseThreadpoolWait 001b ?CheckOneShotStaticDestruction@SchedulerBase@details@Concurrency@@SAXXZ 0020 ?HostModule@details@Concurrency@@3PAUHINSTANCE__@@A 002d ___crtFreeLibraryWhenCallbackReturns"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 FF 75 0C E8 ?? ?? ?? ?? FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 74 0B 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_125_49_0 {
	meta:
		name = "?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ"
		size = 16
		refs = "0004 ?StaticEnterCriticalRegion@ContextBase@details@Concurrency@@SAXXZ 000c ?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? 8B CE 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_125_50_0 {
	meta:
		name = "?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ"
		size = 16
		refs = "0004 ?StaticEnterHyperCriticalRegion@ContextBase@details@Concurrency@@SAXXZ 000c ?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? 8B CE 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_125_51_0 {
	meta:
		name = "?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ"
		size = 51
		refs = "0019 ?_Sleep0@details@Concurrency@@YAXXZ 0021 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 10 33 C0 40 56 8B F1 87 06 85 C0 74 1C 83 65 F8 00 C7 45 FC ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 33 C0 40 87 06 85 C0 75 EF 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_125_57_0 {
	meta:
		name = "?_ConcRT_Trace@details@Concurrency@@YAXHPB_WZZ"
		size = 183
		refs = "000a ___security_cookie 0014 _g_DesiredTraceLevel 0030 ??$ConcRT_FillBuffer@$0EAB@@details@Concurrency@@YAXAAY0EAB@_WPB_WPAD@Z 003e _g_DebugOutFilePtr 004f _fwprintf 0054 _g_CommitFrequency 0061 _g_TraceCount 0072 __aullrem 0095 _fflush 00a5 __imp__OutputDebugStringW@4 00af @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 08 08 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC A1 ?? ?? ?? ?? 85 45 08 0F 84 88 00 00 00 8D 45 10 50 FF 75 0C 8D 85 F8 F7 FF FF 50 E8 ?? ?? ?? ?? 33 C0 83 C4 0C 66 89 45 F8 A1 ?? ?? ?? ?? 85 C0 74 56 8D 8D F8 F7 FF FF 51 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 59 59 85 C0 7E 4B 56 8B 35 ?? ?? ?? ?? 57 8B 3D ?? ?? ?? ?? 99 52 50 57 56 E8 ?? ?? ?? ?? 83 C6 01 89 35 ?? ?? ?? ?? 83 D7 00 0B C2 89 3D ?? ?? ?? ?? 5F 5E 75 1B FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 EB 0D 8D 85 F8 F7 FF FF 50 FF 15 ?? ?? ?? ?? 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_125_72_0 {
	meta:
		name = "?_TryAcquire@_CriticalNonReentrantLock@details@Concurrency@@QAE_NXZ"
		size = 32
		refs = "0005 ?StaticEnterCriticalRegion@ContextBase@details@Concurrency@@SAXXZ 000c ?_TryAcquire@_NonReentrantLock@details@Concurrency@@QAE_NXZ 0017 ?StaticExitCriticalRegion@ContextBase@details@Concurrency@@SAXXZ"
	strings:
		$1 = { 53 56 8B F1 E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 8A D8 84 DB 75 05 E8 ?? ?? ?? ?? 5E 8A C3 5B C3 }
	condition:
		$1
}

rule file_125_73_0 {
	meta:
		name = "?_TryAcquire@_HyperNonReentrantLock@details@Concurrency@@QAE_NXZ"
		size = 32
		refs = "0005 ?StaticEnterHyperCriticalRegion@ContextBase@details@Concurrency@@SAXXZ 000c ?_TryAcquire@_NonReentrantLock@details@Concurrency@@QAE_NXZ 0017 ?StaticExitHyperCriticalRegion@ContextBase@details@Concurrency@@SAXXZ"
	strings:
		$1 = { 53 56 8B F1 E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 8A D8 84 DB 75 05 E8 ?? ?? ?? ?? 5E 8A C3 5B C3 }
	condition:
		$1
}

rule file_125_74_0 {
	meta:
		name = "?_TryAcquire@_NonReentrantLock@details@Concurrency@@QAE_NXZ"
		size = 21
	strings:
		$1 = { 83 39 00 75 0B 33 D2 42 8B C2 87 01 85 C0 74 02 33 D2 8A C2 C3 }
	condition:
		$1
}

rule file_125_75_0 {
	meta:
		name = "?_UnderlyingYield@details@Concurrency@@YAXXZ"
		size = 21
		refs = "0001 ?SafeFastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0011 ?__SwitchToThread@platform@details@Concurrency@@YAXXZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 07 8B 10 8B C8 FF 62 20 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "___free_lc_time"
		size = 896
		refs = "0013 _free"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 85 F6 0F 84 6E 03 00 00 FF 76 04 E8 ?? ?? ?? ?? FF 76 08 E8 ?? ?? ?? ?? FF 76 0C E8 ?? ?? ?? ?? FF 76 10 E8 ?? ?? ?? ?? FF 76 14 E8 ?? ?? ?? ?? FF 76 18 E8 ?? ?? ?? ?? FF 36 E8 ?? ?? ?? ?? FF 76 20 E8 ?? ?? ?? ?? FF 76 24 E8 ?? ?? ?? ?? FF 76 28 E8 ?? ?? ?? ?? FF 76 2C E8 ?? ?? ?? ?? FF 76 30 E8 ?? ?? ?? ?? FF 76 34 E8 ?? ?? ?? ?? FF 76 1C E8 ?? ?? ?? ?? FF 76 38 E8 ?? ?? ?? ?? FF 76 3C E8 ?? ?? ?? ?? 83 C4 40 FF 76 40 E8 ?? ?? ?? ?? FF 76 44 E8 ?? ?? ?? ?? FF 76 48 E8 ?? ?? ?? ?? FF 76 4C E8 ?? ?? ?? ?? FF 76 50 E8 ?? ?? ?? ?? FF 76 54 E8 ?? ?? ?? ?? FF 76 58 E8 ?? ?? ?? ?? FF 76 5C E8 ?? ?? ?? ?? FF 76 60 E8 ?? ?? ?? ?? FF 76 64 E8 ?? ?? ?? ?? FF 76 68 E8 ?? ?? ?? ?? FF 76 6C E8 ?? ?? ?? ?? FF 76 70 E8 ?? ?? ?? ?? FF 76 74 E8 ?? ?? ?? ?? FF 76 78 E8 ?? ?? ?? ?? FF 76 7C E8 ?? ?? ?? ?? 83 C4 40 FF B6 80 00 00 00 E8 ?? ?? ?? ?? FF B6 84 00 00 00 E8 ?? ?? ?? ?? FF B6 88 00 00 00 E8 ?? ?? ?? ?? FF B6 8C 00 00 00 E8 ?? ?? ?? ?? FF B6 90 00 00 00 E8 ?? ?? ?? ?? FF B6 94 00 00 00 E8 ?? ?? ?? ?? FF B6 98 00 00 00 E8 ?? ?? ?? ?? FF B6 9C 00 00 00 E8 ?? ?? ?? ?? FF B6 A0 00 00 00 E8 ?? ?? ?? ?? FF B6 A4 00 00 00 E8 ?? ?? ?? ?? FF B6 A8 00 00 00 E8 ?? ?? ?? ?? FF B6 B8 00 00 00 E8 ?? ?? ?? ?? FF B6 BC 00 00 00 E8 ?? ?? ?? ?? FF B6 C0 00 00 00 E8 ?? ?? ?? ?? FF B6 C4 00 00 00 E8 ?? ?? ?? ?? FF B6 C8 00 00 00 E8 ?? ?? ?? ?? 83 C4 40 FF B6 CC 00 00 00 E8 ?? ?? ?? ?? FF B6 B4 00 00 00 E8 ?? ?? ?? ?? FF B6 D4 00 00 00 E8 ?? ?? ?? ?? FF B6 D8 00 00 00 E8 ?? ?? ?? ?? FF B6 DC 00 00 00 E8 ?? ?? ?? ?? FF B6 E0 00 00 00 E8 ?? ?? ?? ?? FF B6 E4 00 00 00 E8 ?? ?? ?? ?? FF B6 E8 00 00 00 E8 ?? ?? ?? ?? FF B6 D0 00 00 00 E8 ?? ?? ?? ?? FF B6 EC 00 00 00 E8 ?? ?? ?? ?? FF B6 F0 00 00 00 E8 ?? ?? ?? ?? FF B6 F4 00 00 00 E8 ?? ?? ?? ?? FF B6 F8 00 00 00 E8 ?? ?? ?? ?? FF B6 FC 00 00 00 E8 ?? ?? ?? ?? FF B6 00 01 00 00 E8 ?? ?? ?? ?? FF B6 04 01 00 00 E8 ?? ?? ?? ?? 83 C4 40 FF B6 08 01 00 00 E8 ?? ?? ?? ?? FF B6 0C 01 00 00 E8 ?? ?? ?? ?? FF B6 10 01 00 00 E8 ?? ?? ?? ?? FF B6 14 01 00 00 E8 ?? ?? ?? ?? FF B6 18 01 00 00 E8 ?? ?? ?? ?? FF B6 1C 01 00 00 E8 ?? ?? ?? ?? FF B6 20 01 00 00 E8 ?? ?? ?? ?? FF B6 24 01 00 00 E8 ?? ?? ?? ?? FF B6 28 01 00 00 E8 ?? ?? ?? ?? FF B6 2C 01 00 00 E8 ?? ?? ?? ?? FF B6 30 01 00 00 E8 ?? ?? ?? ?? FF B6 34 01 00 00 E8 ?? ?? ?? ?? FF B6 38 01 00 00 E8 ?? ?? ?? ?? FF B6 3C 01 00 00 E8 ?? ?? ?? ?? FF B6 40 01 00 00 E8 ?? ?? ?? ?? FF B6 44 01 00 00 E8 ?? ?? ?? ?? 83 C4 40 FF B6 48 01 00 00 E8 ?? ?? ?? ?? FF B6 4C 01 00 00 E8 ?? ?? ?? ?? FF B6 50 01 00 00 E8 ?? ?? ?? ?? FF B6 54 01 00 00 E8 ?? ?? ?? ?? FF B6 58 01 00 00 E8 ?? ?? ?? ?? FF B6 5C 01 00 00 E8 ?? ?? ?? ?? FF B6 60 01 00 00 E8 ?? ?? ?? ?? 83 C4 1C 5E 5D C3 }
	condition:
		$1
}

rule file_126_1_0 {
	meta:
		name = "___init_time"
		size = 124
		refs = "001c __calloc_crt 002f __get_lc_time 003b ___free_lc_time 0041 _free 0052 ___lc_time_c"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 08 83 BF B4 00 00 00 00 74 3F 33 DB 68 64 01 00 00 43 53 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 75 04 8B C3 EB 4B 57 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 10 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 EB DF 89 9E B0 00 00 00 EB 05 BE ?? ?? ?? ?? 8B 87 9C 00 00 00 3D ?? ?? ?? ?? 74 0C 05 B0 00 00 00 83 C9 FF F0 0F C1 08 89 B7 9C 00 00 00 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_126_2_0 {
	meta:
		name = "__get_lc_time"
		size = 2035
		refs = "0022 ___copy_locale_name 0041 ___getlocaleinfo"
	strings:
		$1 = { 55 8B EC 51 51 53 56 8B 75 0C 57 8B 7D 08 8B 9E B4 00 00 00 85 FF 75 08 83 C8 FF E9 CC 07 00 00 53 E8 ?? ?? ?? ?? 83 65 FC 00 89 87 60 01 00 00 8D 47 04 50 6A 31 53 8D 45 F8 89 75 F8 6A 01 50 E8 ?? ?? ?? ?? 8D 4F 08 8B F0 51 6A 32 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 0C 50 6A 33 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 83 C4 40 0B F0 8D 47 10 50 6A 34 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 14 50 6A 35 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 18 50 6A 36 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 57 6A 37 53 0B F0 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 47 20 50 6A 2A 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 24 50 6A 2B 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 28 50 6A 2C 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 2C 50 6A 2D 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 47 30 50 6A 2E 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 34 50 6A 2F 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 1C 50 6A 30 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 38 50 6A 44 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 47 3C 50 6A 45 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 40 50 6A 46 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 44 50 6A 47 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 48 50 6A 48 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 47 4C 50 6A 49 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 50 50 6A 4A 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 54 50 6A 4B 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 58 50 6A 4C 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 47 5C 50 6A 4D 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 60 50 6A 4E 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 64 50 6A 4F 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 68 50 6A 38 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 47 6C 50 6A 39 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 70 50 6A 3A 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 74 50 6A 3B 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 47 78 50 6A 3C 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 47 7C 50 6A 3D 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 87 80 00 00 00 50 6A 3E 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 87 84 00 00 00 50 6A 3F 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 87 88 00 00 00 50 6A 40 53 6A 01 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 87 8C 00 00 00 50 6A 41 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 87 90 00 00 00 50 6A 42 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 87 94 00 00 00 50 6A 43 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 87 98 00 00 00 50 6A 28 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 87 9C 00 00 00 50 6A 29 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 87 A0 00 00 00 50 6A 1F 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 87 A4 00 00 00 50 6A 20 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 0B F0 8D 87 A8 00 00 00 50 68 03 10 00 00 53 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 87 AC 00 00 00 50 68 09 10 00 00 53 8D 45 F8 6A 00 50 E8 ?? ?? ?? ?? 0B F0 8D 87 B8 00 00 00 50 6A 31 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 BC 00 00 00 50 6A 32 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 C0 00 00 00 50 6A 33 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 87 C4 00 00 00 50 6A 34 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 C8 00 00 00 50 6A 35 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 CC 00 00 00 50 6A 36 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 B4 00 00 00 50 6A 37 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 87 D4 00 00 00 50 6A 2A 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 D8 00 00 00 50 6A 2B 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 DC 00 00 00 50 6A 2C 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 E0 00 00 00 50 6A 2D 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 87 E4 00 00 00 50 6A 2E 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 E8 00 00 00 50 6A 2F 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 D0 00 00 00 50 6A 30 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 EC 00 00 00 50 6A 44 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 87 F0 00 00 00 50 6A 45 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 F4 00 00 00 50 6A 46 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 F8 00 00 00 50 6A 47 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 FC 00 00 00 50 6A 48 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 87 00 01 00 00 50 6A 49 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 04 01 00 00 50 6A 4A 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 08 01 00 00 50 6A 4B 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 0C 01 00 00 50 6A 4C 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 87 10 01 00 00 50 6A 4D 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 14 01 00 00 50 6A 4E 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 18 01 00 00 50 6A 4F 53 6A 02 8D 45 F8 50 E8 ?? ?? ?? ?? 0B F0 8D 87 1C 01 00 00 50 6A 38 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 87 20 01 00 00 50 6A 39 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 24 01 00 00 50 6A 3A 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 28 01 00 00 50 6A 3B 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 2C 01 00 00 50 6A 3C 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 87 30 01 00 00 50 6A 3D 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 34 01 00 00 50 6A 3E 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 38 01 00 00 50 6A 3F 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 3C 01 00 00 50 6A 40 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 87 40 01 00 00 50 6A 41 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 44 01 00 00 50 6A 42 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 48 01 00 00 50 6A 43 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 4C 01 00 00 50 6A 28 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 83 C4 50 0B F0 8D 87 50 01 00 00 50 6A 29 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 54 01 00 00 50 6A 1F 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 58 01 00 00 50 6A 20 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 0B F0 8D 87 5C 01 00 00 50 68 03 10 00 00 53 8D 45 F8 6A 02 50 E8 ?? ?? ?? ?? 83 C4 50 0B C6 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "__aullrem"
		size = 117
	strings:
		$1 = { 53 8B 44 24 14 0B C0 75 18 8B 4C 24 10 8B 44 24 0C 33 D2 F7 F1 8B 44 24 08 F7 F1 8B C2 33 D2 EB 50 8B C8 8B 5C 24 10 8B 54 24 0C 8B 44 24 08 D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B C8 F7 64 24 14 91 F7 64 24 10 03 D1 72 0E 3B 54 24 0C 77 08 72 0E 3B 44 24 08 76 08 2B 44 24 10 1B 54 24 14 2B 44 24 08 1B 54 24 0C F7 DA F7 D8 83 DA 00 5B C2 10 00 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "___common_dsinh_cout_rare"
		size = 1888
		refs = "0012 __vmldSinhHATab 00f9 _2il0floatpacket_88"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 53 83 EC 78 8B 4D 08 F2 0F 10 15 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 59 06 81 E3 F0 7F 00 00 C1 EB 04 F2 0F 10 19 81 FB FF 07 00 00 0F B6 51 07 F2 0F 11 5C 24 70 0F 84 03 07 00 00 85 DB 0F 8E C5 06 00 00 8B CA 83 E1 7F F2 0F 11 5C 24 10 81 FB C9 03 00 00 88 4C 24 17 0F 8E 84 06 00 00 F2 0F 10 44 24 10 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 4B 06 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 EA 04 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 69 04 00 00 F2 0F 10 3D ?? ?? ?? ?? 25 0F 80 FF FF F2 0F 59 F8 83 E2 80 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 54 24 68 F2 0F 58 3D ?? ?? ?? ?? F2 0F 11 7C 24 50 F2 0F 10 64 24 50 8B 5C 24 50 8B F3 C1 EE 06 83 E3 3F C1 E3 04 F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 CC 8D 8E FF 03 00 00 0F 57 25 ?? ?? ?? ?? 81 C6 FE 03 00 00 F2 0F 59 25 ?? ?? ?? ?? F2 0F 5C C1 0F 28 D0 0F 28 D8 81 E6 FF 07 00 00 F7 D9 C1 E6 04 83 C1 FC 0B C6 81 E1 FF 07 00 00 66 89 44 24 6E 25 0F 80 FF FF C1 E1 04 F2 0F 58 D4 F2 0F 11 54 24 60 0B C1 F2 0F 10 6C 24 60 F2 0F 5C DD F2 0F 11 1C 24 F2 0F 10 6C 24 60 F2 0F 10 34 24 F2 0F 58 EE F2 0F 11 6C 24 08 F2 0F 10 3C 24 F2 0F 58 E7 F2 0F 11 24 24 F2 0F 10 64 24 08 F2 0F 5C C4 F2 0F 10 25 ?? ?? ?? ?? F2 0F 11 44 24 08 F2 0F 10 34 24 F2 0F 10 44 24 08 F2 0F 58 F0 F2 0F 11 74 24 08 F2 0F 10 74 24 60 0F 28 FE F2 0F 59 FC F2 0F 10 6C 24 08 F2 0F 11 7C 24 60 F2 0F 10 4C 24 60 F2 0F 11 74 24 10 F2 0F 5C CE F2 0F 11 0C 24 F2 0F 10 54 24 60 F2 0F 10 04 24 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C D0 F2 0F 11 54 24 60 0F 28 D6 F2 0F 59 D6 F2 0F 59 CA F2 0F 11 6C 24 18 0F 28 EE F2 0F 10 5C 24 60 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C EB F2 0F 59 CA F2 0F 59 CE F2 0F 10 35 ?? ?? ?? ?? F2 0F 59 F2 F2 0F 11 2C 24 F2 0F 10 7C 24 60 F2 0F 10 04 24 F2 0F 11 44 24 28 F2 0F 10 83 ?? ?? ?? ?? F2 0F 10 5C 24 68 66 89 44 24 6E F2 0F 11 4C 24 30 F2 0F 59 C3 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F2 0F 28 E8 F2 0F 11 7C 24 20 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F2 F2 0F 10 93 ?? ?? ?? ?? F7 DB F2 0F 11 74 24 38 F2 0F 10 74 24 68 F2 0F 59 D3 F2 0F 10 8B ?? ?? ?? ?? F2 0F 59 CE F2 0F 10 9B ?? ?? ?? ?? F2 0F 5C E9 F2 0F 59 DE F2 0F 11 6C 24 60 0F 28 F0 F2 0F 10 7C 24 60 F2 0F 5C F7 F2 0F 5C F1 F2 0F 11 34 24 F2 0F 10 74 24 60 F2 0F 10 2C 24 0F 28 FE F2 0F 5C EB F2 0F 58 EA F2 0F 58 D3 F2 0F 58 FD F2 0F 11 7C 24 60 F2 0F 10 7C 24 60 F2 0F 5C F7 0F 28 F8 F2 0F 58 F9 F2 0F 58 F5 F2 0F 11 34 24 F2 0F 10 6C 24 60 F2 0F 10 34 24 F2 0F 11 7C 24 60 F2 0F 10 7C 24 60 F2 0F 5C C7 F2 0F 58 C1 F2 0F 11 04 24 F2 0F 10 7C 24 60 F2 0F 10 04 24 0F 28 CF F2 0F 58 D0 F2 0F 58 CA F2 0F 11 4C 24 60 F2 0F 10 5C 24 60 F2 0F 5C FB F2 0F 58 FA F2 0F 11 3C 24 F2 0F 10 7C 24 60 F2 0F 59 E7 0F 28 DF F2 0F 10 0C 24 F2 0F 11 64 24 60 F2 0F 10 64 24 60 F2 0F 5C E7 F2 0F 11 24 24 F2 0F 10 44 24 60 F2 0F 10 24 24 F2 0F 5C C4 F2 0F 11 44 24 60 F2 0F 10 54 24 60 F2 0F 5C DA F2 0F 11 1C 24 F2 0F 10 64 24 60 F2 0F 10 04 24 F2 0F 10 5C 24 18 F2 0F 11 44 24 48 0F 28 D3 F2 0F 11 64 24 40 0F 28 E1 F2 0F 10 44 24 30 F2 0F 59 D1 F2 0F 59 E0 F2 0F 59 C7 F2 0F 59 DF F2 0F 58 D4 0F 28 E6 0F 28 F8 F2 0F 59 64 24 38 F2 0F 58 D4 F2 0F 10 64 24 10 F2 0F 59 E1 F2 0F 58 D4 F2 0F 10 64 24 38 F2 0F 59 E5 F2 0F 58 D3 F2 0F 58 FC F2 0F 58 F2 F2 0F 11 7C 24 60 F2 0F 10 4C 24 60 F2 0F 10 5C 24 48 F2 0F 5C C1 F2 0F 10 4C 24 28 F2 0F 58 C4 F2 0F 11 04 24 0F 28 C1 F2 0F 10 64 24 60 F2 0F 10 14 24 F2 0F 59 C3 F2 0F 58 F2 F2 0F 10 7C 24 20 F2 0F 58 F0 F2 0F 59 DF F2 0F 10 54 24 40 F2 0F 58 F3 F2 0F 59 FA F2 0F 59 CA 0F 28 C7 F2 0F 58 F1 F2 0F 58 C4 F2 0F 11 44 24 60 0F 28 C5 F2 0F 10 4C 24 60 F2 0F 5C F9 F2 0F 58 FC F2 0F 11 3C 24 F2 0F 10 4C 24 60 F2 0F 10 3C 24 F2 0F 58 C1 F2 0F 58 F7 F2 0F 11 44 24 60 F2 0F 10 7C 24 60 F2 0F 5C EF F2 0F 58 E9 F2 0F 11 2C 24 F2 0F 10 44 24 60 F2 0F 10 2C 24 F2 0F 58 F5 F2 0F 58 F0 F2 0F 11 74 24 58 0F B6 44 24 5F 83 E0 7F 0B C2 8B 55 0C 88 44 24 5F 33 C0 F2 0F 10 74 24 58 F2 0F 11 32 83 C4 78 5B 5E 8B E5 5D C3 0F 28 D0 F2 0F 59 D0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CA 0F B6 74 24 77 83 E6 80 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA 8B 55 0C F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 C2 F2 0F 11 44 24 58 0F B6 44 24 5F 83 E0 7F 0B C6 88 44 24 5F 33 C0 F2 0F 10 44 24 58 F2 0F 11 02 83 C4 78 5B 5E 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 11 54 24 68 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 50 F2 0F 10 64 24 50 F2 0F 10 0D ?? ?? ?? ?? 8B 4C 24 50 8B D1 83 E2 3F F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 59 E3 F2 0F 5C C2 C1 E2 04 F2 0F 5C C4 F2 0F 59 C8 C1 E9 06 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 C1 FE 03 00 00 81 E1 FF 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 F9 FE 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 59 C8 F2 0F 58 C8 F2 0F 10 82 ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 8A ?? ?? ?? ?? F2 0F 58 C8 77 21 C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 6E F2 0F 10 44 24 68 F2 0F 59 C8 F2 0F 11 4C 24 58 EB 33 49 81 E1 FF 07 00 00 0F B7 44 24 6E C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 6E F2 0F 10 44 24 68 F2 0F 59 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 58 0F B6 44 24 5F 0F B6 74 24 77 83 E0 7F 83 E6 80 8B 55 0C 0B C6 88 44 24 5F 33 C0 F2 0F 10 44 24 58 F2 0F 11 02 83 C4 78 5B 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C3 8B 45 0C F2 0F 11 00 B8 03 00 00 00 83 C4 78 5B 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? 8B 45 0C F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 11 00 33 C0 83 C4 78 5B 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 D8 F2 0F 11 5C 24 60 F2 0F 10 4C 24 60 8B 45 0C F2 0F 11 54 24 68 F2 0F 58 4C 24 70 F2 0F 11 08 33 C0 83 C4 78 5B 5E 8B E5 5D C3 8B 45 0C F2 0F 58 DB F2 0F 11 18 33 C0 83 C4 78 5B 5E 8B E5 5D C3 8D 49 00 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "_ccosf"
		size = 54
		refs = "000a _crealf 0019 _cimagf 0026 __FCbuild 002d _ccoshf"
	strings:
		$1 = { 55 8B EC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 D9 1C 24 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 D9 E0 D9 1C 24 E8 ?? ?? ?? ?? 52 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "__wmkdir"
		size = 49
		refs = "000c __imp__CreateDirectoryW@8 0016 __imp__GetLastError@0 0022 __dosmaperr"
	strings:
		$1 = { 55 8B EC 56 33 F6 56 FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? 8B F0 85 F6 74 0C 56 E8 ?? ?? ?? ?? 59 83 C8 FF EB 02 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_131_3_0 {
	meta:
		name = "__mbsnbcpy_s_l"
		size = 463
		refs = "003c __errno 0046 __invalid_parameter_noinfo 005a ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0071 _strncpy_s 00ec __ismbblead_l"
	strings:
		$1 = { 55 8B EC 83 EC 14 56 8B 75 08 57 8B 7D 14 85 FF 75 0D 85 F6 75 0D 39 75 0C 75 20 33 C0 EB 2D 85 F6 74 18 83 7D 0C 00 76 12 85 FF 75 05 C6 06 00 EB E9 83 7D 10 00 75 1A C6 06 00 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5F 5E 8B E5 5D C3 53 FF 75 18 8D 4D EC E8 ?? ?? ?? ?? 8B 45 F0 33 DB 39 58 08 75 17 57 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 10 8B D8 E9 3B 01 00 00 8B 45 0C 8B CE 8B 55 10 89 45 14 83 FF FF 75 15 8A 02 88 01 41 42 84 C0 8B 45 14 74 25 48 89 45 14 75 ED EB 1D 8A 02 88 01 41 42 84 C0 8B 45 14 74 09 48 89 45 14 74 03 4F 75 EA 85 FF 75 03 88 19 41 85 C0 0F 85 AD 00 00 00 38 1A 74 05 83 FF 01 75 43 8D 51 FF 89 55 FC 8B CA 89 4D 14 3B D6 72 25 8B DA 8D 45 EC 50 0F B6 03 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 05 4B 3B DE 73 E8 8B 55 FC 89 5D 14 33 DB 8B 4D 14 8B C2 2B C1 A8 01 74 07 88 1A E9 9B 00 00 00 83 FF FF 75 49 8B 4D 0C 83 F9 01 76 38 8D 51 FE 03 D6 89 55 14 8B FA 3B D6 72 1E 8D 45 EC 50 0F B6 07 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 05 4F 3B FE 73 E8 8B 4D 0C 8B 55 14 8B C2 2B C7 A8 01 74 04 88 1A EB 04 88 5C 0E FF 6A 50 5B EB 57 88 1E E8 ?? ?? ?? ?? 6A 22 5B 89 18 E8 ?? ?? ?? ?? EB 44 8B C1 2B C6 83 F8 02 7C 3B 83 C1 FE 89 4D 14 8B F9 3B CE 72 1B 8D 45 EC 50 0F B6 07 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 05 4F 3B FE 73 E8 8B 4D 14 8B C1 2B C7 A8 01 74 0C 88 19 E8 ?? ?? ?? ?? 6A 2A 5B 89 18 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD 8B C3 5B E9 7D FE FF FF }
	condition:
		$1
}

rule file_132_1_0 {
	meta:
		name = "__set_output_format"
		size = 50
		refs = "0009 __outputformat 0016 __errno 0021 __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 8B 4D 08 56 8B 35 ?? ?? ?? ?? F7 C1 FE FF FF FF 74 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 06 89 0D ?? ?? ?? ?? 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "__add_exp"
		size = 47
		refs = "0026 __set_exp"
	strings:
		$1 = { 55 8B EC 8B 45 0E DD 45 08 0F B7 C8 8B 45 10 C1 E9 04 05 02 FC FF FF 81 E1 FF 07 00 00 03 C1 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_134_1_0 {
	meta:
		name = "__decomp"
		size = 210
		refs = "009d __set_exp"
	strings:
		$1 = { 55 8B EC DD 45 08 D9 EE DD E1 DF E0 57 F6 C4 44 7A 09 DD D9 33 FF E9 AF 00 00 00 56 66 8B 75 0E 0F B7 C6 A9 F0 7F 00 00 75 7C 8B 4D 0C 8B 55 08 F7 C1 FF FF 0F 00 75 04 85 D2 74 6A DE D9 BF 03 FC FF FF DF E0 F6 C4 41 75 05 33 C0 40 EB 02 33 C0 F6 45 0E 10 75 1F 03 C9 89 4D 0C 85 D2 79 06 83 C9 01 89 4D 0C 03 D2 4F F6 45 0E 10 74 E8 66 8B 75 0E 89 55 08 B9 EF FF 00 00 66 23 F1 66 89 75 0E 85 C0 74 0C B8 00 80 00 00 66 0B F0 66 89 75 0E DD 45 08 6A 00 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C EB 23 6A 00 51 DD D8 51 DD 1C 24 E8 ?? ?? ?? ?? 0F B7 FE 83 C4 0C C1 EF 04 81 E7 FF 07 00 00 81 EF FE 03 00 00 5E 8B 45 10 89 38 5F 5D C3 }
	condition:
		$1
}

rule file_134_2_0 {
	meta:
		name = "__get_exp"
		size = 25
	strings:
		$1 = { 55 8B EC 8B 45 0E 0F B7 C0 C1 E8 04 25 FF 07 00 00 2D FE 03 00 00 98 5D C3 }
	condition:
		$1
}

rule file_134_3_0 {
	meta:
		name = "__set_bexp"
		size = 41
	strings:
		$1 = { 55 8B EC 51 51 8B 45 0E 8B 4D 10 DD 45 08 0F B7 C0 C1 E1 04 25 0F 80 00 00 DD 5D F8 0B C8 66 89 4D FE DD 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_134_4_0 {
	meta:
		name = "__set_exp"
		size = 47
	strings:
		$1 = { 55 8B EC 51 51 8B 4D 10 8B 45 0E DD 45 08 0F B7 C0 8D 89 FE 03 00 00 25 0F 80 00 00 C1 E1 04 DD 5D F8 0B C8 66 89 4D FE DD 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_134_5_0 {
	meta:
		name = "__sptype"
		size = 91
	strings:
		$1 = { 55 8B EC 81 7D 0C 00 00 F0 7F 8B 45 08 75 07 85 C0 75 15 40 5D C3 81 7D 0C 00 00 F0 FF 75 09 85 C0 75 05 6A 02 58 5D C3 8B 4D 0E BA F8 7F 00 00 66 23 CA 66 3B CA 75 04 6A 03 EB E9 BA F0 7F 00 00 66 3B CA 75 11 F7 45 0C FF FF 07 00 75 04 85 C0 74 04 6A 04 EB CE 33 C0 5D C3 }
	condition:
		$1
}

rule file_135_3_0 {
	meta:
		name = "__mbsupr"
		size = 35
		refs = "0011 __mbsupr_s_l"
	strings:
		$1 = { 55 8B EC 8B 45 08 F7 D8 6A 00 1B C0 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_514_3_0 {
	meta:
		name = "__mbslwr"
		size = 35
		refs = "0011 __mbslwr_s_l"
	strings:
		$1 = { 55 8B EC 8B 45 08 F7 D8 6A 00 1B C0 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_135_4_0 {
	meta:
		name = "__mbsupr_l"
		size = 36
		refs = "0012 __mbsupr_s_l"
	strings:
		$1 = { 55 8B EC 8B 45 08 FF 75 0C F7 D8 1B C0 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_514_4_0 {
	meta:
		name = "__mbslwr_l"
		size = 36
		refs = "0012 __mbslwr_s_l"
	strings:
		$1 = { 55 8B EC 8B 45 08 FF 75 0C F7 D8 1B C0 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_135_6_0 {
	meta:
		name = "__mbsupr_s_l"
		size = 249
		refs = "0026 __errno 0030 __invalid_parameter_noinfo 003e _strnlen 0055 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0094 ___crtLCMapStringA"
	strings:
		$1 = { 55 8B EC 83 EC 14 56 8B 75 08 57 8B 7D 0C 85 F6 74 0F 85 FF 74 0F 85 F6 75 21 33 C0 E9 BB 00 00 00 85 FF 74 F1 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 A1 00 00 00 57 56 E8 ?? ?? ?? ?? 59 59 3B C7 72 05 C6 06 00 EB D8 53 FF 75 10 8D 4D EC E8 ?? ?? ?? ?? 80 3E 00 8B DE 8B FE 74 68 8B 45 F0 8A 0B 0F B6 D1 89 55 FC 8A 54 02 19 F6 C2 04 74 3C 6A 01 FF 70 04 8D 4D 08 6A 02 51 6A 02 53 68 00 02 00 00 FF B0 1C 02 00 00 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 43 8B 4D 08 88 0F 47 43 83 F8 01 8B 45 F0 7E 16 88 2F EB 11 F6 C2 20 74 0A 8B 4D FC 8A 8C 01 19 01 00 00 88 0F 47 43 80 3B 00 75 9B 33 C0 88 07 80 7D F8 00 5B 74 07 8B 4D F4 83 61 70 FD 5F 5E 8B E5 5D C3 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C6 06 00 E8 ?? ?? ?? ?? 8B 00 EB D5 }
	condition:
		$1
}

rule file_137_1_0 {
	meta:
		name = "??0DName@@QAE@AAPBDD@Z"
		size = 185
		refs = "0069 ?disableFlags@UnDecorator@@0KA 0083 ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 57 8B 7D 08 83 26 00 C6 46 04 00 81 66 04 FF 00 FF FF 8B 0F 85 C9 0F 84 89 00 00 00 80 39 00 74 7E 33 D2 8B 1F 8A 03 3A 45 0C 74 4B 3C 5F 74 3C 3C 24 74 38 3C 3C 74 34 3C 3E 74 30 3C 2D 74 2C 3C 61 7C 04 3C 7A 7E 24 3C 41 7C 04 3C 5A 7E 1C 3C 30 7C 04 3C 39 7E 14 3C 80 72 04 3C FE 76 0C F7 05 ?? ?? ?? ?? 00 00 01 00 74 39 8D 43 01 42 89 07 80 38 00 75 AC 52 51 8B CE E8 ?? ?? ?? ?? 8B 07 8A 08 84 C9 74 11 40 89 07 3A 4D 0C 74 19 83 26 00 C6 46 04 03 EB 10 80 7E 04 00 75 0A C6 46 04 01 EB 04 C6 46 04 02 5F 8B C6 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule file_137_3_0 {
	meta:
		name = "??0DName@@QAE@D@Z"
		size = 44
		refs = "0021 ?doPchar@DName@@AAEXPBDH@Z"
		altNames = "??4DName@@QAEAAV0@D@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 83 26 00 C6 46 04 00 81 66 04 FF 00 FF FF 80 7D 08 00 74 0B 6A 01 8D 45 08 50 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_137_4_0 {
	meta:
		name = "??0DName@@QAE@PAV0@@Z"
		size = 77
		refs = "0012 _heap 0017 ?getMemory@_HeapManager@@QAEPAXIH@Z 0025 ??0pDNameNode@@QAE@PAVDName@@@Z"
	strings:
		$1 = { 55 8B EC 53 33 DB 56 8B F1 39 5D 08 74 2B 53 6A 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C FF 75 08 8B C8 E8 ?? ?? ?? ?? 8B D8 85 DB 0F 95 C0 FE C8 24 03 88 46 04 EB 03 88 5E 04 81 66 04 FF 00 FF FF 8B C6 89 1E 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_137_5_0 {
	meta:
		name = "??0DName@@QAE@PBD@Z"
		size = 58
		refs = "002f ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 33 C0 8B 4D 08 88 46 04 81 66 04 FF 00 FF FF 89 06 85 C9 74 18 38 01 74 14 40 80 3C 08 00 75 F9 85 C0 74 09 50 51 8B CE E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_137_6_0 {
	meta:
		name = "??0DName@@QAE@W4DNameStatus@@@Z"
		size = 67
		refs = "002d ?make@DNameStatusNode@@SAPAV1@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 8B F1 81 66 04 FF 00 FF FF 83 F8 02 74 09 83 F8 03 74 04 33 C9 EB 02 8B C8 83 26 00 88 4E 04 83 F8 01 75 11 50 E8 ?? ?? ?? ?? 89 06 59 85 C0 75 04 C6 46 04 03 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_137_7_0 {
	meta:
		name = "??0DName@@QAE@XZ"
		size = 17
	strings:
		$1 = { 83 21 00 8B C1 C6 41 04 00 81 61 04 FF 00 FF FF C3 }
	condition:
		$1
}

rule file_137_8_0 {
	meta:
		name = "??0DName@@QAE@_J@Z"
		size = 147
		refs = "0007 ___security_cookie 0050 __aulldvrm 007a ?doPchar@DName@@AAEXPBDH@Z 0089 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 55 0C 8B C1 33 C9 89 45 DC 56 57 8B 7D 08 8D 75 F9 88 48 04 81 60 04 FF 00 FF FF 89 08 88 4D F9 88 4D E3 3B D1 7F 10 7C 04 3B F9 73 0A F7 DF C6 45 E3 01 13 D1 F7 DA 53 51 6A 0A 52 57 4E E8 ?? ?? ?? ?? 80 C1 30 89 5D D8 8B F8 88 0E 0B C2 6A 00 59 75 E4 5B 38 4D E3 74 04 4E C6 06 2D 8D 4D F9 2B CE 51 8B 4D DC 56 E8 ?? ?? ?? ?? 8B 4D FC 8B 45 DC 33 CD 5F 5E E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_137_9_0 {
	meta:
		name = "??0DName@@QAE@_K@Z"
		size = 109
		refs = "0007 ___security_cookie 0038 __aulldvrm 0054 ?doPchar@DName@@AAEXPBDH@Z 0063 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 24 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 55 0C 53 8B 5D 08 56 8B F1 C6 45 F8 00 57 8D 7D F8 83 26 00 C6 46 04 00 81 66 04 FF 00 FF FF 6A 00 6A 0A 52 53 4F E8 ?? ?? ?? ?? 89 5D E0 80 C1 30 8B D8 88 0F 0B C2 75 E6 8D 4D F8 2B CF 51 57 8B CE E8 ?? ?? ?? ?? 8B 4D FC 8B C6 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_137_11_0 {
	meta:
		name = "??0DNameStatusNode@@AAE@W4DNameStatus@@@Z"
		size = 35
		refs = "000e ??_7DNameStatusNode@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 89 41 04 48 F7 D8 C7 01 ?? ?? ?? ?? 1B C0 83 E0 FC 83 C0 04 89 41 08 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_137_13_0 {
	meta:
		name = "??0UnDecorator@@QAE@PADPBDHP6APADJ@ZK@Z"
		size = 105
		refs = "0014 ?name@UnDecorator@@0PBDB 0019 ?gName@UnDecorator@@0PBDB 0025 ?maxStringLength@UnDecorator@@0HA 002b ?outputString@UnDecorator@@0PADA 0043 ?disableFlags@UnDecorator@@0KA 004c ?pZNameList@UnDecorator@@0PAVReplicator@@A 0051 ?m_pGetParameter@UnDecorator@@0P6APADJ@ZA 0059 ?pArgList@UnDecorator@@0PAVReplicator@@A 005f ?fExplicitTemplateParams@UnDecorator@@0_NA"
	strings:
		$1 = { 55 8B EC 83 09 FF 8B 45 0C 8B 55 08 56 8D 71 2C 83 0E FF A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 85 D2 74 10 8B 45 10 A3 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? EB 0E 83 25 ?? ?? ?? ?? 00 83 25 ?? ?? ?? ?? 00 8B 45 18 A3 ?? ?? ?? ?? 8B 45 14 89 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B C1 89 0D ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 5E 5D C2 14 00 }
	condition:
		$1
}

rule file_137_14_0 {
	meta:
		name = "??0charNode@@QAE@D@Z"
		size = 21
		refs = "000d ??_7charNode@@6B@"
	strings:
		$1 = { 55 8B EC 8A 45 08 88 41 04 8B C1 C7 01 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_137_15_0 {
	meta:
		name = "??0pDNameNode@@QAE@PAVDName@@@Z"
		size = 40
		refs = "0008 ??_7pDNameNode@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 C7 01 ?? ?? ?? ?? 85 C0 74 0F 8A 50 04 80 FA 02 74 05 80 FA 03 75 02 33 C0 89 41 04 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_137_16_0 {
	meta:
		name = "??0pairNode@@QAE@PAVDNameNode@@0@Z"
		size = 31
		refs = "0017 ??_7pairNode@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 49 0C FF 89 41 04 8B 45 0C 89 41 08 8B C1 C7 01 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule file_137_17_0 {
	meta:
		name = "??0pcharNode@@QAE@PBDH@Z"
		size = 87
		refs = "000d ??_7pcharNode@@6B@ 0020 _heap 0025 ?getMemory@_HeapManager@@QAEPAXIH@Z"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 57 8B 7D 0C C7 06 ?? ?? ?? ?? 85 FF 74 31 8B 5D 08 85 DB 74 2A 6A 00 57 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 89 7E 08 89 4E 04 85 C9 74 15 85 FF 74 15 2B D9 8A 04 0B 88 01 41 4F 75 F7 EB 08 83 66 04 00 83 66 08 00 5F 8B C6 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule file_137_18_0 {
	meta:
		name = "??2@YAPAXIAAV_HeapManager@@H@Z"
		size = 21
		refs = "0007 _heap 000f ?getMemory@_HeapManager@@QAEPAXIH@Z"
	strings:
		$1 = { 55 8B EC FF 75 10 B9 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_137_21_0 {
	meta:
		name = "??4DName@@QAEAAV0@PAV0@@Z"
		size = 73
		refs = "001e _heap 0023 ?getMemory@_HeapManager@@QAEPAXIH@Z 0031 ??0pDNameNode@@QAE@PAVDName@@@Z"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 33 DB 88 5E 04 81 66 04 FF 00 FF FF 89 1E 39 5D 08 74 23 53 6A 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C FF 75 08 8B C8 E8 ?? ?? ?? ?? 8B D8 89 1E 85 DB 75 04 C6 46 04 03 8B C6 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_137_22_0 {
	meta:
		name = "??4DName@@QAEAAV0@PBD@Z"
		size = 50
		refs = "0027 ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 33 C0 8B 4D 08 88 46 04 81 66 04 FF 00 FF FF 89 06 38 01 74 07 40 80 3C 08 00 75 F9 50 51 8B CE E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_137_23_0 {
	meta:
		name = "??4DName@@QAEAAV0@W4DNameStatus@@@Z"
		size = 53
		refs = "001a ?make@DNameStatusNode@@SAPAV1@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 8B F1 81 66 04 FF 00 FF FF 88 46 04 83 F8 01 75 13 50 E8 ?? ?? ?? ?? 89 06 59 85 C0 75 09 C6 46 04 03 EB 03 83 26 00 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_137_24_0 {
	meta:
		name = "??AReplicator@@QBE?AVDName@@H@Z"
		size = 60
		refs = "0031 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 8B 55 0C 83 FA 09 77 20 83 39 FF 74 17 3B 11 7F 13 8B 54 91 04 8B 45 08 8B 0A 89 08 8B 4A 04 89 48 04 EB 11 6A 02 EB 02 6A 03 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 5D C2 08 00 }
	condition:
		$1
}

rule file_137_25_0 {
	meta:
		name = "??BUnDecorator@@QAEPADXZ"
		size = 383
		refs = "0014 ?name@UnDecorator@@0PBDB 003c ?gName@UnDecorator@@0PBDB 0046 ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 0051 ??_C@_04HEJADOOB@CV?3?5?$AA@ 0059 ??0DName@@QAE@PBD@Z 0060 ??HDName@@QBE?AV0@ABV0@@Z 0076 ?getTemplateName@UnDecorator@@CA?AVDName@@_N@Z 0088 ?disableFlags@UnDecorator@@0KA 0100 ??4DName@@QAEAAV0@PBD@Z 0108 ?outputString@UnDecorator@@0PADA 0120 ?maxStringLength@UnDecorator@@0HA 012d _heap 0146 ?getString@DName@@QBEPADPADH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 4D F4 B8 00 00 FF FF 21 45 FC 23 C8 A1 ?? ?? ?? ?? 56 33 F6 89 75 F8 8B D6 57 BF 00 10 00 00 85 C0 0F 84 83 00 00 00 80 38 3F 75 6F 8A 40 01 3C 40 75 32 83 05 ?? ?? ?? ?? 02 8D 45 E8 50 E8 ?? ?? ?? ?? 59 50 8D 45 F0 50 68 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 55 F0 8B 4D F4 EB 45 3C 24 75 4D 8D 45 E0 56 50 E8 ?? ?? ?? ?? 59 59 8B 48 04 8B 10 80 F9 02 74 12 85 3D ?? ?? ?? ?? 75 23 A1 ?? ?? ?? ?? 80 38 00 74 19 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 59 8B 48 04 8B 10 80 F9 03 75 21 33 C0 E9 BC 00 00 00 3C 3F 75 E1 A1 ?? ?? ?? ?? 80 78 02 40 75 D6 81 E1 02 00 FF FF 83 C9 02 EB DA 80 F9 02 74 1A 85 3D ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? 80 38 00 75 08 89 55 F8 89 4D FC EB 11 FF 35 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 8B 55 F8 A1 ?? ?? ?? ?? 85 C0 75 2B 85 D2 74 08 8B 02 8B CA FF 10 8B F0 8D 46 01 A3 ?? ?? ?? ?? 83 C0 07 83 E0 F8 50 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 59 85 C0 74 3E FF 35 ?? ?? ?? ?? 8D 4D F8 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B C8 EB 17 80 FA 20 75 0E 40 88 11 41 EB 01 40 80 38 20 74 FA EB 04 88 11 41 40 8A 10 84 D2 75 E3 8A C2 88 01 A1 ?? ?? ?? ?? 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_26_0 {
	meta:
		name = "??H@YA?AVDName@@DABV0@@Z"
		size = 36
		refs = "0012 ??0DName@@QAE@D@Z 0019 ??HDName@@QBE?AV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 51 FF 75 10 8D 4D F8 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_27_0 {
	meta:
		name = "??H@YA?AVDName@@PBDABV0@@Z"
		size = 36
		refs = "0012 ??0DName@@QAE@PBD@Z 0019 ??HDName@@QBE?AV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 51 FF 75 10 8D 4D F8 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_28_0 {
	meta:
		name = "??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z"
		size = 36
		refs = "0012 ??0DName@@QAE@W4DNameStatus@@@Z 0019 ??HDName@@QBE?AV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 51 FF 75 10 8D 4D F8 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_29_0 {
	meta:
		name = "??HDName@@QBE?AV0@ABV0@@Z"
		size = 34
		refs = "0017 ??YDName@@QAEAAV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 8B 11 56 8B 75 08 FF 75 0C 89 16 8B 49 04 89 4E 04 8B CE E8 ?? ?? ?? ?? 8B C6 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_137_30_0 {
	meta:
		name = "??HDName@@QBE?AV0@D@Z"
		size = 34
		refs = "0017 ??YDName@@QAEAAV0@D@Z"
	strings:
		$1 = { 55 8B EC 8B 11 56 8B 75 08 FF 75 0C 89 16 8B 49 04 89 4E 04 8B CE E8 ?? ?? ?? ?? 8B C6 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_137_31_0 {
	meta:
		name = "??HDName@@QBE?AV0@PAV0@@Z"
		size = 34
		refs = "0017 ??YDName@@QAEAAV0@PAV0@@Z"
	strings:
		$1 = { 55 8B EC 8B 11 56 8B 75 08 FF 75 0C 89 16 8B 49 04 89 4E 04 8B CE E8 ?? ?? ?? ?? 8B C6 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_137_32_0 {
	meta:
		name = "??HDName@@QBE?AV0@PBD@Z"
		size = 34
		refs = "0017 ??YDName@@QAEAAV0@PBD@Z"
	strings:
		$1 = { 55 8B EC 8B 11 56 8B 75 08 FF 75 0C 89 16 8B 49 04 89 4E 04 8B CE E8 ?? ?? ?? ?? 8B C6 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_137_33_0 {
	meta:
		name = "??HDName@@QBE?AV0@W4DNameStatus@@@Z"
		size = 34
		refs = "0017 ??YDName@@QAEAAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 8B 11 56 8B 75 08 FF 75 0C 89 16 8B 49 04 89 4E 04 8B CE E8 ?? ?? ?? ?? 8B C6 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_137_34_0 {
	meta:
		name = "??YDName@@QAEAAV0@ABV0@@Z"
		size = 67
		refs = "001c ??YDName@@QAEAAV0@W4DNameStatus@@@Z 0038 ?append@DName@@AAEXPAVDNameNode@@@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 80 7E 04 01 7F 30 8B 4D 08 83 39 00 75 0E 0F BE 41 04 8B CE 50 E8 ?? ?? ?? ?? EB 1A 83 3E 00 75 0C 8B 01 89 06 8B 41 04 89 46 04 EB 09 FF 31 8B CE E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_137_35_0 {
	meta:
		name = "??YDName@@QAEAAV0@D@Z"
		size = 80
		refs = "001b ??4DName@@QAEAAV0@D@Z 0026 _heap 002b ?getMemory@_HeapManager@@QAEPAXIH@Z 0035 ??_7charNode@@6B@ 0044 ?append@DName@@AAEXPAVDNameNode@@@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 80 7E 04 01 7F 3D 53 8B 5D 08 84 DB 74 34 83 3E 00 75 08 53 E8 ?? ?? ?? ?? EB 27 6A 00 6A 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0B C7 00 ?? ?? ?? ?? 88 58 04 EB 02 33 C0 50 8B CE E8 ?? ?? ?? ?? 5B 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_137_36_0 {
	meta:
		name = "??YDName@@QAEAAV0@PAV0@@Z"
		size = 101
		refs = "001d ??4DName@@QAEAAV0@PAV0@@Z 0033 ??YDName@@QAEAAV0@W4DNameStatus@@@Z 003d _heap 0042 ?getMemory@_HeapManager@@QAEPAXIH@Z 004e ??0pDNameNode@@QAE@PAVDName@@@Z 0058 ?append@DName@@AAEXPAVDNameNode@@@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 80 7E 04 01 7F 52 57 8B 7D 08 85 FF 74 49 53 33 DB 39 1E 75 08 57 E8 ?? ?? ?? ?? EB 39 8A 47 04 84 C0 74 0F 3C 01 74 0B 0F BE C0 50 E8 ?? ?? ?? ?? EB 23 53 6A 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A 57 8B C8 E8 ?? ?? ?? ?? 8B D8 53 8B CE E8 ?? ?? ?? ?? 5B 5F 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_137_37_0 {
	meta:
		name = "??YDName@@QAEAAV0@PBD@Z"
		size = 97
		refs = "0022 ??4DName@@QAEAAV0@PBD@Z 002c _heap 0031 ?getMemory@_HeapManager@@QAEPAXIH@Z 004a ??0pcharNode@@QAE@PBDH@Z 0054 ?append@DName@@AAEXPAVDNameNode@@@Z"
	strings:
		$1 = { 55 8B EC 53 8B D9 80 7B 04 01 7F 4E 57 8B 7D 08 85 FF 74 45 80 3F 00 74 40 56 33 F6 39 33 75 08 57 E8 ?? ?? ?? ?? EB 30 56 6A 0C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 17 80 3F 00 74 07 46 80 3C 3E 00 75 F9 56 57 8B C8 E8 ?? ?? ?? ?? 8B F0 56 8B CB E8 ?? ?? ?? ?? 5E 5F 8B C3 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_137_38_0 {
	meta:
		name = "??YDName@@QAEAAV0@W4DNameStatus@@@Z"
		size = 64
		refs = "0024 ?make@DNameStatusNode@@SAPAV1@W4DNameStatus@@@Z 002d ?append@DName@@AAEXPAVDNameNode@@@Z 0035 ??4DName@@QAEAAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 80 7E 04 01 7F 2D 83 3E 00 8B 45 08 74 1F 83 F8 02 74 1A 83 F8 03 74 15 85 C0 74 17 50 E8 ?? ?? ?? ?? 59 50 8B CE E8 ?? ?? ?? ?? EB 06 50 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_137_39_0 {
	meta:
		name = "??YReplicator@@QAEAAV0@ABVDName@@@Z"
		size = 74
		refs = "0019 _heap 001e ?getMemory@_HeapManager@@QAEPAXIH@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 83 3E 09 74 38 57 8B 7D 08 83 3F 00 74 2E 6A 00 6A 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 0C 8B 0F 89 0A 8B 4F 04 89 4A 04 EB 02 33 D2 85 D2 74 08 FF 06 8B 06 89 54 86 04 5F 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_137_40_0 {
	meta:
		name = "??_5DName@@QAEAAV0@ABV0@@Z"
		size = 28
	strings:
		$1 = { 55 8B EC 80 79 04 03 74 0D 8B 45 08 8A 40 04 3C 01 7E 03 88 41 04 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_137_41_0 {
	meta:
		name = "?Constructor@_HeapManager@@QAEXP6APAXI@ZP6AXPAX@Z@Z"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 45 08 89 01 8B 45 0C 89 41 04 33 C0 89 41 10 89 41 08 89 41 0C 5D C2 08 00 }
	condition:
		$1
}

rule file_137_42_0 {
	meta:
		name = "?Destructor@_HeapManager@@QAEXXZ"
		size = 38
	strings:
		$1 = { 56 8B F1 83 7E 04 00 74 1B EB 0F 8B 46 0C FF 76 0C 8B 00 89 46 08 FF 56 04 59 8B 46 08 89 46 0C 85 C0 75 E7 5E C3 }
	condition:
		$1
}

rule file_137_43_0 {
	meta:
		name = "?UScore@UnDecorator@@SAPBDW4Tokens@@@Z"
		size = 29
		refs = "0004 ?disableFlags@UnDecorator@@0KA 0012 _tokenTable"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? F7 D0 A8 01 8B 45 08 8B 04 85 ?? ?? ?? ?? 75 03 83 C0 02 5D C3 }
	condition:
		$1
}

rule file_137_44_0 {
	meta:
		name = "?append@DName@@AAEXPAVDNameNode@@@Z"
		size = 70
		refs = "0013 _heap 0018 ?getMemory@_HeapManager@@QAEPAXIH@Z 0028 ??_7pairNode@@6B@"
	strings:
		$1 = { 55 8B EC 56 57 8B 7D 08 8B F1 85 FF 74 2E 6A 00 6A 10 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 14 8B 0E 83 48 0C FF C7 00 ?? ?? ?? ?? 89 48 04 89 78 08 EB 02 33 C0 89 06 85 C0 75 04 C6 46 04 03 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_137_45_0 {
	meta:
		name = "?composeDeclaration@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 3382
		refs = "0018 ?getTypeEncoding@UnDecorator@@CAHXZ 0047 ??0DName@@QAE@W4DNameStatus@@@Z 0061 ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 010f ?disableFlags@UnDecorator@@0KA 012c ?getBasedType@UnDecorator@@CA?AVDName@@XZ 013c ??0DName@@QAE@D@Z 0143 ??HDName@@QBE?AV0@ABV0@@Z 0164 ??_5DName@@QAEAAV0@ABV0@@Z 019a ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 01b1 ??HDName@@QBE?AV0@D@Z 01c1 ??YDName@@QAEAAV0@ABV0@@Z 01ca ?getVCallThunkType@UnDecorator@@CA?AVDName@@XZ 0202 ??_C@_03OPGICMGF@?$HN?8?5?$AA@ 020a ??YDName@@QAEAAV0@PBD@Z 021b ??_C@_02IGFCGPIL@?$HN?8?$AA@ 022c ?getCallingConvention@UnDecorator@@CA?AVDName@@XZ 0287 ??YDName@@QAEAAV0@D@Z 03b7 ?getThisType@UnDecorator@@CA?AVDName@@XZ 048d ?getReturnType@UnDecorator@@CA?AVDName@@PAV2@@Z 0499 ??_C@_01CLKCMJKC@?5?$AA@ 04a1 ??0DName@@QAE@PBD@Z 04dd _heap 04e2 ?getMemory@_HeapManager@@QAEPAXIH@Z 054b ??_C@_0N@CBHHHENL@?$GAvtordispex?$HL?$AA@ 05d7 ??_C@_0L@GHPFDFH@?$GAvtordisp?$HL?$AA@ 060f ??_C@_0L@HNGCOGAE@?$GAadjustor?$HL?$AA@ 0645 ?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ 06b6 ?getRestrictionSpec@UnDecorator@@CA?AVDName@@XZ 06e8 ?getThrowTypes@UnDecorator@@CA?AVDName@@XZ 070c ?getDispatchTarget@UnDecorator@@CA?AVDName@@XZ 0792 ?getVfTableType@UnDecorator@@CA?AVDName@@ABV2@@Z 07ef ??HDName@@QBE?AV0@PBD@Z 0809 ?getVdispMapType@UnDecorator@@CA?AVDName@@ABV2@@Z 086d ??_C@_0CB@KJDOOODE@?$GAlocal?5static?5destructor?5helper?8@ 08be ??_C@_0DB@ILEFOCIJ@?$GAtemplate?5static?5data?5member?5con@ 090c ??_C@_0DA@HGFJFBBE@?$GAtemplate?5static?5data?5member?5des@ 09d9 ?getExternalDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 0a6c ??_C@_07PGOEDBHP@static?5?$AA@ 0b62 ??_C@_08NIEOINHE@virtual?5?$AA@ 0be1 ??_C@_09LAPHOOG@private?3?5?$AA@ 0c2e ??_C@_0M@GAIFPFIP@protected?3?5?$AA@ 0c8e ??_C@_08GPDDCMKI@public?3?5?$AA@ 0cde ??_C@_08KJLFOPNE@?$FLthunk?$FN?3?$AA@ 0d0e ??_C@_0M@DHNBOJMP@extern?5?$CCC?$CC?5?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 5C 81 65 D8 00 00 FF FF 33 C0 53 56 89 45 FC 89 45 D4 E8 ?? ?? ?? ?? 8B 75 0C 8B D8 33 C0 33 C9 40 39 0E 74 0C F7 46 04 00 02 00 00 89 45 EC 75 03 89 4D EC 81 FB FF FF 00 00 75 12 8B 4D 08 6A 02 E8 ?? ?? ?? ?? 8B 45 08 E9 DD 0C 00 00 81 FB FE FF 00 00 75 0F 56 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB E1 81 FB FD FF 00 00 75 12 8B 45 08 8B 0E 89 08 8B 4E 04 89 48 04 E9 AC 0C 00 00 57 8B FB 81 E7 00 80 00 00 0F 84 C3 06 00 00 8B C3 33 D2 25 00 18 00 00 3D 00 08 00 00 89 45 0C 8B C3 0F 94 C2 89 55 F8 85 D2 74 07 25 00 04 00 00 EB 05 25 00 10 00 00 85 C0 74 12 8B C3 25 00 1B 00 00 3D 00 10 00 00 0F 84 84 06 00 00 8B C3 85 D2 74 07 25 00 04 00 00 EB 05 25 00 10 00 00 85 C0 74 1D 8B C3 25 00 1B 00 00 3D 00 11 00 00 0F 84 5C 06 00 00 3D 00 12 00 00 0F 84 51 06 00 00 F7 C3 00 40 00 00 74 60 8B 0D ?? ?? ?? ?? 8B C1 D1 E8 F7 D0 A8 01 74 38 C1 E9 03 F7 D1 F6 C1 01 74 2E 8D 45 BC 50 E8 ?? ?? ?? ?? 59 50 8D 45 B4 50 6A 20 8D 4D C4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 B4 89 45 D4 8B 45 B8 89 45 D8 EB 13 8D 45 B4 50 E8 ?? ?? ?? ?? 59 50 8D 4D D4 E8 ?? ?? ?? ?? 8B 55 F8 33 C9 8B C3 85 D2 74 07 25 00 04 00 00 EB 05 25 00 10 00 00 85 C0 0F 84 2D 01 00 00 81 7D 0C 00 18 00 00 0F 85 20 01 00 00 51 8D 45 B4 50 E8 ?? ?? ?? ?? 59 59 8D 45 B4 8B CE 50 8D 45 BC 50 6A 7B 8D 45 C4 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D D4 E8 ?? ?? ?? ?? 8D 45 B4 50 E8 ?? ?? ?? ?? BE 00 10 00 00 59 85 35 ?? ?? ?? ?? 75 3E 8D 45 B4 50 8D 45 BC 50 6A 2C 8D 4D C4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 BC 8D 4D B4 89 45 B4 8B 45 C0 68 ?? ?? ?? ?? 89 45 B8 E8 ?? ?? ?? ?? 8D 45 B4 50 8D 4D D4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D D4 E8 ?? ?? ?? ?? 8D 45 B4 50 E8 ?? ?? ?? ?? 59 8B 0D ?? ?? ?? ?? 8B C1 D1 E8 F7 D0 A8 01 0F 84 00 05 00 00 8B C1 C1 E8 04 F7 D0 A8 01 0F 84 F1 04 00 00 85 CE 0F 85 E9 04 00 00 8D 45 B4 50 8D 45 BC 50 6A 20 8D 4D C4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 BC 8D 4D B4 89 45 B4 8B 45 C0 6A 20 89 45 B8 E8 ?? ?? ?? ?? 8B 45 B4 8D 4D BC 89 45 BC 8B 45 B8 89 45 C0 8D 45 D4 50 E8 ?? ?? ?? ?? 8B 4D BC 89 4D FC 89 4D D4 8B 4D C0 E9 14 07 00 00 81 65 C8 00 00 FF FF B8 00 00 FF FF 21 45 C0 21 45 B8 21 45 D0 8B 45 B8 25 00 00 FF FF 89 4D BC 89 45 E0 8B C3 89 4D B4 89 4D CC 89 4D E4 89 4D C4 85 D2 74 07 25 00 04 00 00 EB 05 25 00 10 00 00 85 C0 0F 84 97 00 00 00 85 D2 74 77 8B C3 25 00 07 00 00 3D 00 06 00 00 75 3E 8D 45 DC 6A 01 50 E8 ?? ?? ?? ?? 8B 45 DC 89 45 BC 8B 45 E0 89 45 C0 8D 45 DC 6A 01 50 E8 ?? ?? ?? ?? 8B 45 DC 89 45 B4 8B 45 E0 89 45 B8 8D 45 DC 6A 01 50 E8 ?? ?? ?? ?? 83 C4 18 EB 1F 85 D2 74 27 8B C3 25 00 07 00 00 3D 00 05 00 00 75 19 8D 45 DC 6A 01 50 E8 ?? ?? ?? ?? 59 59 8B 45 DC 89 45 CC 8B 45 E0 89 45 D0 8D 45 DC 6A 01 50 E8 ?? ?? ?? ?? 8B 45 DC 8B 55 F8 59 89 45 E4 8B 45 E0 59 89 45 E0 85 D2 74 40 8B C3 25 00 07 00 00 3D 00 02 00 00 74 32 A1 ?? ?? ?? ?? 83 E0 60 3C 60 8D 45 F0 50 74 13 E8 ?? ?? ?? ?? 59 8B 08 8B 40 04 89 4D C4 89 45 C8 EB 0F E8 ?? ?? ?? ?? 59 50 8D 4D C4 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8B C1 D1 E8 F7 D0 A8 01 74 30 C1 E9 04 F7 D1 F6 C1 01 74 26 8D 45 D4 50 8D 45 F0 50 8D 45 AC 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 8B 08 8B 40 04 89 4D D4 89 45 D8 EB 13 8D 45 AC 50 E8 ?? ?? ?? ?? 59 50 8D 4D D4 E8 ?? ?? ?? ?? 33 C9 39 0E 74 42 39 4D D4 74 32 F7 05 ?? ?? ?? ?? 00 10 00 00 75 26 56 8D 45 F0 50 6A 20 8D 4D AC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8D 45 F0 50 8D 4D D4 E8 ?? ?? ?? ?? 33 C9 EB 0B 8B 06 89 45 D4 8B 46 04 89 45 D8 8B 45 B0 25 00 00 FF FF 89 4D F4 83 7D EC 00 89 45 0C 51 74 52 8D 45 AC 50 E8 ?? ?? ?? ?? 59 59 50 8D 45 E8 50 68 ?? ?? ?? ?? 8D 4D A4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8D 45 E8 50 8D 4D D4 E8 ?? ?? ?? ?? F7 05 ?? ?? ?? ?? 00 10 00 00 0F 85 71 04 00 00 33 F6 8B 4D F8 8B C3 85 C9 74 4C 25 00 04 00 00 EB 4A 6A 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 89 4D F4 85 C9 74 10 33 C0 88 41 04 81 61 04 FF 00 FF FF 89 01 EB 07 33 F6 8B CE 89 75 F4 51 8D 45 A4 50 E8 ?? ?? ?? ?? 59 59 8B 30 8B 40 04 89 75 FC 89 45 0C EB AB 25 00 10 00 00 85 C0 0F 84 14 01 00 00 85 C9 0F 84 DA 00 00 00 8B C3 25 00 07 00 00 3D 00 06 00 00 75 7A 8D 45 BC 50 8D 45 E8 50 68 ?? ?? ?? ?? 8D 4D A4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 E8 8D 4D BC 89 45 BC 8B 45 EC 6A 2C 89 45 C0 E8 ?? ?? ?? ?? 8B 45 BC 8D 4D E8 89 45 E8 8B 45 C0 89 45 EC 8D 45 B4 50 E8 ?? ?? ?? ?? 8B 45 E8 8D 4D B4 89 45 B4 8B 45 EC 6A 2C 89 45 B8 E8 ?? ?? ?? ?? 8B 45 B4 8D 4D BC 89 45 BC 8B 45 B8 89 45 C0 8D 45 CC 50 E8 ?? ?? ?? ?? EB 2E 85 C9 74 4E 8B C3 25 00 07 00 00 3D 00 05 00 00 75 40 8D 45 CC 50 8D 45 BC 50 68 ?? ?? ?? ?? 8D 4D A4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 BC 8D 4D B4 89 45 B4 8B 45 C0 6A 2C 89 45 B8 E8 ?? ?? ?? ?? 8D 45 B4 50 8D 4D D4 E8 ?? ?? ?? ?? EB 0D 68 ?? ?? ?? ?? 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 E4 8D 4D B4 89 45 B4 8B 45 E0 68 ?? ?? ?? ?? 89 45 B8 E8 ?? ?? ?? ?? 8D 45 B4 50 8D 4D D4 E8 ?? ?? ?? ?? 8D 45 A4 50 E8 ?? ?? ?? ?? 59 50 8D 45 BC 50 6A 28 8D 4D AC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 BC 8D 4D B4 89 45 B4 8B 45 C0 6A 29 89 45 B8 E8 ?? ?? ?? ?? 8D 45 B4 50 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 F8 85 C0 74 1A 8B C3 25 00 07 00 00 3D 00 02 00 00 74 0C 8D 45 C4 50 8D 4D D4 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 13 F7 D0 A8 01 8D 45 A4 50 74 11 E8 ?? ?? ?? ?? 59 50 8D 4D D4 E8 ?? ?? ?? ?? EB 0F E8 ?? ?? ?? ?? 59 50 8D 4D D4 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 08 F7 D0 A8 01 8D 45 A4 50 74 11 E8 ?? ?? ?? ?? 59 50 8D 4D D4 E8 ?? ?? ?? ?? EB 0F E8 ?? ?? ?? ?? 59 50 8D 4D D4 E8 ?? ?? ?? ?? 8D 45 A4 50 E8 ?? ?? ?? ?? 59 50 8D 4D D4 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 02 F7 D0 A8 01 74 1D 8B 4D F4 85 C9 74 16 8B 45 D4 89 01 8B 45 D8 89 41 04 8B 45 0C 89 75 D4 E9 A8 02 00 00 8B 45 D8 89 45 0C 8B 45 D4 89 45 FC E9 9A 02 00 00 56 8D 4D D4 E8 ?? ?? ?? ?? B9 00 7C 00 00 85 FF 0F 85 AF 00 00 00 8B C3 23 C1 3D 00 68 00 00 74 13 85 FF 0F 85 9C 00 00 00 8B C3 23 C1 3D 00 70 00 00 75 0E 8D 45 D4 50 FF 75 08 E8 ?? ?? ?? ?? EB 75 85 FF 75 7F 8B C3 23 C1 3D 00 60 00 00 75 4E 33 F6 8D 45 C4 56 50 E8 ?? ?? ?? ?? 8B 45 D4 59 59 89 45 B4 8D 4D B4 8B 45 D8 6A 7B 89 45 B8 E8 ?? ?? ?? ?? 8B 45 B4 8D 4D BC 89 45 BC 8B 45 B8 89 45 C0 8D 45 C4 50 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 75 08 8D 4D BC E8 ?? ?? ?? ?? EB 1A 85 FF 75 22 8B C3 23 C1 3B C1 75 16 8D 45 D4 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 8B 45 08 E9 18 05 00 00 85 FF 74 10 8B C3 BE 00 18 00 00 23 C6 2D 00 08 00 00 EB 0C 8B C3 BE 00 18 00 00 25 00 60 00 00 F7 D8 BA 00 10 00 00 1B C0 40 85 C0 8B C3 74 07 25 00 04 00 00 EB 02 23 C2 85 C0 74 22 8B C3 8B CF 25 00 1B 00 00 2B C2 F7 D8 1B C0 40 F7 D9 1B C9 85 C8 74 0A 68 ?? ?? ?? ?? E9 9A 00 00 00 8B C3 85 FF 74 09 23 C6 2D 00 08 00 00 EB 05 25 00 60 00 00 F7 D8 1B C0 40 85 C0 8B C3 74 07 25 00 04 00 00 EB 02 23 C2 85 C0 74 22 8B C3 8B CF 25 00 1B 00 00 2D 00 11 00 00 F7 D8 1B C0 40 F7 D9 1B C9 85 C8 74 07 68 ?? ?? ?? ?? EB 4C 8B C3 85 FF 74 09 23 C6 2D 00 08 00 00 EB 05 25 00 60 00 00 F7 D8 1B C0 40 85 C0 8B C3 74 07 25 00 04 00 00 EB 02 23 C2 85 C0 74 37 8B C3 8B CF 25 00 1B 00 00 2D 00 12 00 00 F7 D8 1B C0 40 F7 D9 1B C9 85 C8 74 1C 68 ?? ?? ?? ?? 8D 4D D4 E8 ?? ?? ?? ?? 85 FF 74 30 8B C3 23 C6 2D 00 08 00 00 EB 2C 85 FF 75 F1 8B C3 25 00 7C 00 00 3D 00 78 00 00 75 DF 8B 45 08 8B 4D D4 89 08 8B 4D D8 89 48 04 E9 E3 03 00 00 8B C3 25 00 60 00 00 F7 D8 1B C0 40 85 C0 8B C3 74 07 25 00 04 00 00 EB 05 25 00 10 00 00 85 C0 74 62 8B D3 33 C0 81 E2 00 1B 00 00 8B CF 81 FA 00 11 00 00 0F 94 C0 F7 D9 1B C9 85 C8 75 15 33 C0 8B CF 81 FA 00 12 00 00 0F 94 C0 F7 D9 1B C9 85 C8 74 30 8D 45 D4 50 8D 45 B4 50 68 ?? ?? ?? ?? 8D 4D A4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 B4 8B 4D B8 89 45 FC 89 45 D4 89 4D 0C 89 4D D8 EB 20 8D 45 D4 50 8D 45 A4 50 E8 ?? ?? ?? ?? 59 59 8B 08 8B 40 04 89 4D FC 89 4D D4 89 45 0C 89 45 D8 8B C3 BE 00 18 00 00 85 FF 74 09 23 C6 2D 00 08 00 00 EB 05 25 00 60 00 00 F7 D8 1B C0 40 85 C0 0F 84 7E 02 00 00 A1 ?? ?? ?? ?? C1 E8 09 F7 D0 A8 01 0F 84 5F 01 00 00 8B C3 85 FF 74 09 23 C6 2D 00 08 00 00 EB 05 25 00 60 00 00 F7 D8 1B C0 40 85 C0 74 4C 85 FF 74 13 8B C3 25 00 07 00 00 2D 00 02 00 00 F7 D8 1B C0 40 EB 03 33 C0 40 85 C0 74 2E 8D 45 D4 50 8D 45 B4 50 68 ?? ?? ?? ?? 8D 4D A4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 B4 89 45 FC 89 45 D4 8B 45 B8 89 45 0C 89 45 D8 85 FF 74 28 8B C3 25 00 07 00 00 3D 00 01 00 00 0F 84 B2 00 00 00 85 FF 74 12 8B C3 B9 00 08 00 00 23 C6 BA 00 60 00 00 2B C1 EB 0E 8B C3 BA 00 60 00 00 23 C2 B9 00 08 00 00 F7 D8 1B C0 40 85 C0 8B C3 74 07 25 00 04 00 00 EB 05 25 00 10 00 00 85 C0 0F 84 9D 00 00 00 8B C3 85 FF 74 06 23 C6 2B C1 EB 02 23 C2 F7 D8 1B C0 40 85 C0 74 0E 8B C3 25 00 07 00 00 3D 00 05 00 00 74 4A 8B C3 85 FF 74 06 23 C6 2B C1 EB 02 23 C2 F7 D8 1B C0 40 85 C0 74 0E 8B C3 25 00 07 00 00 3D 00 06 00 00 74 25 8B C3 85 FF 74 06 23 C6 2B C1 EB 02 23 C2 F7 D8 1B C0 40 85 C0 74 3C 8B C3 25 00 07 00 00 3D 00 04 00 00 75 2E 8D 45 D4 50 8D 45 B4 50 68 ?? ?? ?? ?? 8D 4D A4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 B4 89 45 FC 89 45 D4 8B 45 B8 89 45 0C 89 45 D8 A1 ?? ?? ?? ?? C1 E8 07 F7 D0 A8 01 0F 84 FB 00 00 00 8B C3 BA 00 08 00 00 85 FF 74 06 23 C6 2B C2 EB 05 25 00 60 00 00 F7 D8 1B C0 40 85 C0 74 2F 85 FF 74 0D 8B C3 33 C9 24 C0 3C 40 0F 94 C1 EB 0B 8B CB 23 CE 2B CA F7 D9 1B C9 41 85 C9 74 0F 8D 45 D4 50 8D 45 B4 50 68 ?? ?? ?? ?? EB 4B 8B C3 85 FF 74 06 23 C6 2B C2 EB 05 25 00 60 00 00 F7 D8 1B C0 40 85 C0 74 4E 85 FF 74 0D 8B C3 33 C9 24 C0 3C 80 0F 94 C1 EB 0F 8B CB 23 CE 81 E9 00 10 00 00 F7 D9 1B C9 41 85 C9 74 2A 8D 45 D4 50 8D 45 B4 50 68 ?? ?? ?? ?? 8D 4D A4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4D B4 8B 55 B8 89 4D D4 89 55 D8 EB 4B 8B C3 85 FF 74 06 23 C6 2B C2 EB 05 25 00 60 00 00 F7 D8 1B C0 40 85 C0 74 2B 85 FF 74 0B 6A 00 F6 C3 C0 58 0F 94 C0 EB 09 8B C3 23 C6 F7 D8 1B C0 40 85 C0 74 0F 8D 45 D4 50 8D 45 B4 50 68 ?? ?? ?? ?? EB 9E 8B 55 0C 8B 4D FC 8B C3 85 FF 74 09 23 C6 2D 00 08 00 00 EB 05 25 00 60 00 00 F7 D8 1B C0 40 85 C0 8B C3 74 07 25 00 04 00 00 EB 05 25 00 10 00 00 85 C0 74 34 F7 05 ?? ?? ?? ?? 00 10 00 00 75 28 8D 45 D4 50 8D 45 B4 50 68 ?? ?? ?? ?? 8D 4D A4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4D B4 8B 55 B8 89 4D D4 89 55 D8 F7 C3 00 00 01 00 74 22 8D 45 D4 50 8D 45 B4 50 68 ?? ?? ?? ?? 8D 4D A4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4D B4 8B 55 B8 8B 45 08 89 08 89 50 04 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_56_0 {
	meta:
		name = "?doPchar@DName@@AAEXPBDH@Z"
		size = 136
		refs = "0031 _heap 003c ?getMemory@_HeapManager@@QAEPAXIH@Z 004b ??0pcharNode@@QAE@PBDH@Z 0066 ??_7charNode@@6B@"
	strings:
		$1 = { 55 8B EC 56 8B F1 57 33 FF 39 3E 74 0F 81 66 04 FF 00 FF FF C6 46 04 03 89 3E EB 66 53 8B 5D 08 85 DB 74 59 39 7D 0C 74 54 8B 45 0C 2B C7 74 47 B9 ?? ?? ?? ?? 57 48 74 1E 6A 0C E8 ?? ?? ?? ?? 85 C0 74 0D FF 75 0C 8B C8 53 E8 ?? ?? ?? ?? 8B F8 89 3E 85 FF EB 1E 6A 08 E8 ?? ?? ?? ?? 85 C0 74 0D 8A 0B C7 00 ?? ?? ?? ?? 88 48 04 EB 02 8B C7 89 06 85 C0 75 0A C6 46 04 03 EB 04 C6 46 04 02 5B 5F 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_137_59_0 {
	meta:
		name = "?doThisTypes@UnDecorator@@SAHXZ"
		size = 18
		refs = "0002 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 8B 0D ?? ?? ?? ?? 33 C0 83 E1 60 80 F9 60 0F 95 C0 C3 }
	condition:
		$1
}

rule file_137_63_0 {
	meta:
		name = "?getArgumentList@UnDecorator@@CA?AVDName@@XZ"
		size = 268
		refs = "0027 ?gName@UnDecorator@@0PBDB 004d ??YDName@@QAEAAV0@D@Z 0077 ?pArgList@UnDecorator@@0PAVReplicator@@A 007d ??AReplicator@@QBE?AVDName@@H@Z 0085 ??YDName@@QAEAAV0@ABV0@@Z 00a1 ?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 00c3 ??YReplicator@@QAEAAV0@ABVDName@@@Z 00ff ??YDName@@QAEAAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 56 8B 75 08 33 DB 43 83 26 00 C6 46 04 00 81 66 04 FF 00 FF FF 80 7E 04 00 0F 85 DE 00 00 00 A1 ?? ?? ?? ?? 57 8A 08 80 F9 40 0F 84 CC 00 00 00 80 F9 5A 0F 84 C3 00 00 00 85 DB 74 04 33 DB EB 0E 6A 2C 8B CE E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 08 84 C9 0F 84 9A 00 00 00 0F BE C9 83 E9 30 83 F9 09 77 20 40 A3 ?? ?? ?? ?? 8D 45 E8 51 8B 0D ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? EB 5E 83 65 F8 00 8B F8 81 65 FC 00 00 FF FF 8D 45 F8 50 8D 45 F0 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 2B C7 59 59 83 F8 01 7E 14 8B 0D ?? ?? ?? ?? 83 39 09 74 09 8D 45 F0 50 E8 ?? ?? ?? ?? 8D 45 F0 8B CE 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 3B C7 75 13 81 66 04 FF 00 FF FF 83 26 00 C6 46 04 02 A1 ?? ?? ?? ?? 80 7E 04 00 0F 84 34 FF FF FF EB 09 6A 01 8B CE E8 ?? ?? ?? ?? 5F 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_64_0 {
	meta:
		name = "?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ"
		size = 222
		refs = "0004 ?gName@UnDecorator@@0PBDB 0024 ?getArgumentList@UnDecorator@@CA?AVDName@@XZ 004b ??0DName@@QAE@W4DNameStatus@@@Z 005b ?disableFlags@UnDecorator@@0KA 0067 ??_C@_04EENFHACM@?0?4?4?4?$AA@ 006e ??_C@_0M@ELJOJFFH@?0?$DMellipsis?$DO?$AA@ 007b ??HDName@@QBE?AV0@PBD@Z 00b6 ??_C@_03KHICJKCI@?4?4?4?$AA@ 00bd ??_C@_0L@EGPHHEKN@?$DMellipsis?$DO?$AA@ 00cb ??_C@_04GKJNKENE@void?$AA@ 00d3 ??0DName@@QAE@PBD@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 EC 10 0F BE 08 83 E9 58 0F 84 AD 00 00 00 49 49 0F 84 84 00 00 00 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 55 FC 59 84 D2 75 66 A1 ?? ?? ?? ?? 8A 08 84 C9 74 5B 80 F9 40 74 50 80 F9 5A 74 0F 8B 4D 08 6A 02 E8 ?? ?? ?? ?? E9 83 00 00 00 40 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 12 F7 D0 A8 01 B8 ?? ?? ?? ?? 75 05 B8 ?? ?? ?? ?? 50 8D 45 F0 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 55 08 8B 08 89 0A 8B 48 04 8B C2 89 4A 04 EB 4A 40 A3 ?? ?? ?? ?? 8B 45 08 8B 4D F8 89 08 89 50 04 EB 37 40 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 12 F7 D0 A8 01 B8 ?? ?? ?? ?? 75 05 B8 ?? ?? ?? ?? 50 EB 0B 40 A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_65_0 {
	meta:
		name = "?getArrayType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 514
		refs = "0004 ?gName@UnDecorator@@0PBDB 0016 ?getNumberOfDimensions@UnDecorator@@CAHXZ 0054 ??_C@_02GPECMEKF@?$FL?$FN?$AA@ 005c ??YDName@@QAEAAV0@PBD@Z 007f ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 0090 ??0DName@@QAE@D@Z 0097 ??HDName@@QBE?AV0@ABV0@@Z 00ad ??YDName@@QAEAAV0@D@Z 00b9 ??YDName@@QAEAAV0@ABV0@@Z 0143 ?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 018e ??_C@_02GOGNNPBN@?$CJ?$FL?$AA@ 01ac ??YDName@@QAEAAV0@W4DNameStatus@@@Z 01e4 ??HDName@@QBE?AV0@W4DNameStatus@@@Z 01eb ??HDName@@QBE?AV0@D@Z 01f4 ?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 EC 30 80 38 00 56 0F 84 4E 01 00 00 E8 ?? ?? ?? ?? 8B F0 85 F6 79 04 33 F6 85 F6 75 11 8D 45 E0 6A 5D 50 8D 45 E8 8D 4D F0 E9 A0 01 00 00 8B 45 FC 83 65 F8 00 25 00 00 FF FF 57 8B 7D 0C 89 45 FC F7 47 04 00 08 00 00 74 10 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 8B 45 FC 3C 01 7F 5C 8B C6 4E 85 C0 74 55 A1 ?? ?? ?? ?? 80 38 00 74 4B 8D 45 D8 6A 00 50 E8 ?? ?? ?? ?? 59 59 50 8D 45 F0 50 6A 5B 8D 4D D0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 F0 8D 4D E8 89 45 E8 8B 45 F4 6A 5D 89 45 EC E8 ?? ?? ?? ?? 8D 45 E8 50 8D 4D F8 E8 ?? ?? ?? ?? 80 7D FC 01 7E A4 83 3F 00 74 72 F7 47 04 00 08 00 00 74 19 8D 45 F8 8B CF 50 8D 45 D0 50 E8 ?? ?? ?? ?? 8B 08 89 4D F8 8B 40 04 EB 4D 57 8D 45 E8 50 6A 28 8D 4D D0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 E8 8D 4D F0 89 45 F0 8B 45 EC 6A 29 89 45 F4 E8 ?? ?? ?? ?? 8B 45 F0 8D 4D E8 89 45 E8 8B 45 F4 89 45 EC 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 E8 89 45 F8 8B 45 EC 89 45 FC 8D 45 F8 50 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 45 08 8B 55 E4 59 59 8B 4D E0 81 CA 00 08 00 00 89 08 89 50 04 5F E9 9A 00 00 00 8B 45 0C 83 38 00 74 60 50 8D 45 E0 50 6A 28 8D 4D D0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 E0 8D 4D E8 89 45 E8 8B 45 E4 68 ?? ?? ?? ?? 89 45 EC E8 ?? ?? ?? ?? 8B 45 E8 8D 4D F0 89 45 F0 8B 45 EC 6A 01 89 45 F4 E8 ?? ?? ?? ?? 8B 45 F0 8D 4D F8 89 45 F8 8B 45 F4 6A 5D 89 45 FC E8 ?? ?? ?? ?? 8D 45 F8 EB 24 8D 45 D0 6A 5D 50 8D 45 D8 8D 4D E0 6A 01 50 6A 5B E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 59 59 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_66_0 {
	meta:
		name = "?getBasedType@UnDecorator@@CA?AVDName@@XZ"
		size = 151
		refs = "0009 ?UScore@UnDecorator@@SAPBDW4Tokens@@@Z 0013 ??0DName@@QAE@PBD@Z 0019 ?gName@UnDecorator@@0PBDB 0041 ??0DName@@QAE@W4DNameStatus@@@Z 004f ?getScopedName@UnDecorator@@CA?AVDName@@XZ 0059 ??YDName@@QAEAAV0@ABV0@@Z 0060 ??_C@_04GKJNKENE@void?$AA@ 0068 ??YDName@@QAEAAV0@PBD@Z 0074 ??YDName@@QAEAAV0@W4DNameStatus@@@Z 0079 ??_C@_02KCKGHPCA@?$CJ?5?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 10 6A 00 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8A 01 84 C0 74 4B 0F BE C0 41 89 0D ?? ?? ?? ?? 83 E8 30 74 2D 48 48 74 14 83 E8 03 75 3D 8B 4D 08 6A 02 E8 ?? ?? ?? ?? 8B 45 08 EB 49 8D 45 F0 50 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? EB 19 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? EB 0A 6A 01 8D 4D F8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 8B 45 08 8B 4D F8 89 08 8B 4D FC 89 48 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_67_0 {
	meta:
		name = "?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 983
		refs = "0005 ?gName@UnDecorator@@0PBDB 0052 $LN105 0059 $LN113 005e ??_C@_04ENMBGAPA@char?$AA@ 0066 ??4DName@@QAEAAV0@PBD@Z 0070 ??_C@_05BFKKPKCG@short?$AA@ 0077 ??_C@_03JBIPMCLC@int?$AA@ 007e ??_C@_04GOKPGOLB@long?$AA@ 0085 ??_C@_05KNFBNCOH@float?$AA@ 00f3 ??_C@_06EBGKOKIG@__int8?$AA@ 010c ?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 0112 ??_C@_06GCICPBLB@__w64?5?$AA@ 011a ??H@YA?AVDName@@PBDABV0@@Z 0133 ??4DName@@QAEAAV0@W4DNameStatus@@@Z 013d ??_C@_07ICFHOGAF@__int16?$AA@ 014e ??_C@_07LFCOJCAC@__int64?$AA@ 0155 ??_C@_07OFLPPHGP@__int32?$AA@ 015c ??_C@_08GAHOLHEO@__int128?$AA@ 018e ?getECSUDataType@UnDecorator@@CA?AVDName@@XZ 01b4 ??_C@_07NFANNNEC@UNKNOWN?$AA@ 01be ??_C@_07CLGGIAMF@wchar_t?$AA@ 01c8 ??_C@_09EEKGDCPH@?$DMunknown?$DO?$AA@ 0200 ??_C@_00CNPNBAHC@?$AA@ 020e ?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0PBD@Z 021d ??_C@_02GPECMEKF@?$FL?$FN?$AA@ 0225 ??YDName@@QAEAAV0@PBD@Z 0235 ??_C@_04DDKJGDCM@bool?$AA@ 023f ??_C@_04GKJNKENE@void?$AA@ 0275 ??_C@_05CJIMAING@long?5?$AA@ 0282 ??_C@_06BNJCAIGJ@double?$AA@ 02d8 ??_C@_09EBBEKKIH@unsigned?5?$AA@ 02e7 ??_C@_07EDHNAJHC@signed?5?$AA@ 02ef ??0DName@@QAE@PBD@Z 02f6 ??HDName@@QBE?AV0@ABV0@@Z 0319 ??0DName@@QAE@D@Z 032c ??YDName@@QAEAAV0@ABV0@@Z 034b ??_C@_05BNCCCJPP@const?$AA@ 035d ??_C@_09EFNPDFFP@?5volatile?$AA@ 0371 ??_C@_08PABEKFH@volatile?$AA@ 037e ??_C@_01NBENCBCI@?$CK?$AA@ 03a0 ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 03b4 $LN47 03b8 $LN46 03bc $LN45 03c0 $LN44 03c4 $LN43 03c8 $LN21"
	strings:
		$1 = { 55 8B EC 8B 0D ?? ?? ?? ?? 83 EC 24 8A 01 53 56 57 84 C0 0F 84 7E 03 00 00 83 65 F4 00 BF 00 00 FF FF 21 7D F8 41 0F B6 F0 83 CB FF 8B C6 89 0D ?? ?? ?? ?? C6 45 FF 00 83 F8 4E 7F 4E 0F 84 3E 02 00 00 83 E8 43 83 F8 0A 0F 87 00 02 00 00 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? E9 28 02 00 00 68 ?? ?? ?? ?? EB EC 68 ?? ?? ?? ?? EB E5 68 ?? ?? ?? ?? EB DE 68 ?? ?? ?? ?? EB D7 83 F8 4F 0F 84 E0 01 00 00 0F 8E B5 01 00 00 83 F8 53 0F 8E A5 01 00 00 83 F8 58 0F 84 92 01 00 00 83 F8 5F 0F 85 9A 01 00 00 8A 19 41 0F B6 C3 89 0D ?? ?? ?? ?? 83 F8 4D 0F 8F 98 00 00 00 83 F8 4C 0F 8D 88 00 00 00 83 F8 47 7F 6B 83 F8 46 7D 5F 85 C0 74 45 83 F8 24 74 1E 83 C0 BC 83 F8 01 0F 87 C1 00 00 00 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? E9 96 01 00 00 FF 75 0C 8D 45 E4 50 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 E9 81 02 00 00 49 89 0D ?? ?? ?? ?? 8D 4D F4 6A 01 E8 ?? ?? ?? ?? E9 5E 01 00 00 68 ?? ?? ?? ?? EB B4 83 F8 49 7E 0C 83 F8 4B 7F 66 68 ?? ?? ?? ?? EB A3 68 ?? ?? ?? ?? EB 9C 68 ?? ?? ?? ?? EB 95 83 F8 4E 0F 84 C9 00 00 00 83 F8 4F 74 61 83 F8 52 74 52 83 F8 57 74 43 83 C0 A8 83 F8 01 77 31 8D 45 EC 49 50 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 08 8B 50 04 89 4D F4 89 55 F8 85 C9 0F 85 F4 00 00 00 8B 45 08 89 08 89 50 04 E9 F7 01 00 00 68 ?? ?? ?? ?? E9 3A FF FF FF 68 ?? ?? ?? ?? E9 30 FF FF FF 68 ?? ?? ?? ?? E9 26 FF FF FF 6A FE 5B 8B 4D 0C 83 65 F4 00 21 7D F8 8B 01 89 45 E4 8B 41 04 89 45 E8 83 FB FE 0F 85 4E 01 00 00 BE 00 08 00 00 0B C6 89 45 E8 8D 45 E4 68 ?? ?? ?? ?? 50 8D 45 F4 50 8D 45 EC 50 E8 ?? ?? ?? ?? 8B 55 F0 83 C4 10 85 D6 75 10 68 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 8B 55 F0 8B 4D EC E9 72 FF FF FF 68 ?? ?? ?? ?? E9 B9 FE FF FF 68 ?? ?? ?? ?? E9 1A FE FF FF 8B DE 83 E3 03 EB 3F 8D 45 DC 49 50 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 08 8B 50 04 89 4D F4 89 55 F8 85 C9 75 28 E9 32 FF FF FF 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 83 FB FF 0F 85 3D FF FF FF 8A 5D FF 83 EE 43 74 3F 6A 02 59 2B F1 74 29 2B F1 74 25 2B F1 74 21 2B F1 74 1D 83 EE 14 75 4F 0F B6 C3 83 E8 45 74 10 2B C1 74 0C 2B C1 74 08 2B C1 74 04 2B C1 75 37 8D 45 F4 50 8D 45 E4 50 68 ?? ?? ?? ?? EB 0D 8D 45 F4 50 8D 45 E4 50 68 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 E4 89 45 F4 8B 45 E8 89 45 F8 8B 45 0C 83 38 00 74 22 50 8D 45 E4 50 6A 20 8D 4D DC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8D 45 E4 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 45 08 8B 4D F4 89 08 8B 4D F8 89 48 04 EB 6A 83 39 00 75 38 F6 C3 01 74 21 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? F6 C3 02 74 21 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? EB 12 F6 C3 02 74 0D 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E4 50 8D 45 F4 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 EB 10 FF 75 0C 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 5F 5E 5B 8B E5 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 01 01 02 02 03 03 05 04 }
	condition:
		$1
}

rule file_137_68_0 {
	meta:
		name = "?getCallIndex@UnDecorator@@CA?AVDName@@XZ"
		size = 20
		refs = "0009 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z"
		altNames = "?getGuardNumber@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 59 59 5D C3 }
	condition:
		$1
}

rule file_137_69_0 {
	meta:
		name = "?getCallingConvention@UnDecorator@@CA?AVDName@@XZ"
		size = 191
		refs = "0006 ?gName@UnDecorator@@0PBDB 003e ?disableFlags@UnDecorator@@0KA 0090 ?UScore@UnDecorator@@SAPBDW4Tokens@@@Z 009a ??4DName@@QAEAAV0@PBD@Z 00b4 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 51 51 A1 ?? ?? ?? ?? 8A 08 84 C9 0F 84 9A 00 00 00 0F BE C9 83 E9 41 40 A3 ?? ?? ?? ?? 6A 02 83 F9 10 0F 87 85 00 00 00 8B 45 FC 83 65 F8 00 25 02 00 FF FF 5A 0B C2 89 45 FC A1 ?? ?? ?? ?? D1 E8 F7 D0 A8 01 74 54 83 E1 FE 83 F9 08 77 26 74 20 83 E9 00 74 17 2B CA 74 10 2B CA 74 08 2B CA 75 39 6A 03 EB 26 6A 04 EB 22 52 EB 1F 6A 01 EB 1B 6A 05 EB 17 83 E9 0C 74 10 2B CA 74 08 2B CA 75 19 6A 06 EB 06 6A 08 EB 02 6A 07 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 45 08 8B 4D F8 89 08 8B 4D FC 89 48 04 EB 0D 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_70_0 {
	meta:
		name = "?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@PBD0H@Z"
		size = 1437
		refs = "0017 ?gName@UnDecorator@@0PBDB 003d ?getExtendedDataIndirectType@UnDecorator@@CA?AVDName@@AAPBDAA_NH@Z 00a7 ?disableFlags@UnDecorator@@0KA 00c7 ??YDName@@QAEAAV0@D@Z 00ce ?UScore@UnDecorator@@SAPBDW4Tokens@@@Z 011f ??HDName@@QBE?AV0@PBD@Z 013d ??4DName@@QAEAAV0@PBD@Z 021c ??0DName@@QAE@PBD@Z 0232 ??YDName@@QAEAAV0@ABV0@@Z 02dd ??_C@_02MOLJINC@?3?3?$AA@ 02ec ??HDName@@QBE?AV0@ABV0@@Z 0313 ?getScope@UnDecorator@@CA?AVDName@@XZ 0333 ??0DName@@QAE@W4DNameStatus@@@Z 0365 ??_5DName@@QAEAAV0@ABV0@@Z 038d ??YDName@@QAEAAV0@W4DNameStatus@@@Z 03bf ?getBasedType@UnDecorator@@CA?AVDName@@XZ 0403 ??_C@_09GAIEOBLP@volatile?5?$AA@ 0430 ??_C@_06LIJLOJAG@const?5?$AA@ 047c ??0DName@@QAE@D@Z 0576 ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 54 8B 45 C8 33 C9 25 00 00 FF FF 88 4D FF 89 45 F8 A1 ?? ?? ?? ?? 53 56 57 8A 00 84 C0 0F 84 F1 04 00 00 8B 7D 18 3C 24 75 2C 57 8D 45 FF 50 8D 45 10 50 8D 45 CC 50 E8 ?? ?? ?? ?? 8B 4D CC 83 C4 10 85 C9 74 10 8B 45 08 89 08 8B 4D D0 89 48 04 E9 3B 05 00 00 A1 ?? ?? ?? ?? 33 C9 8B 55 E8 8A 00 3C 41 0F BE D8 B8 00 00 FF FF 0F 9C C1 33 F6 49 89 75 E4 83 E1 2B 23 D0 83 C1 16 89 55 E8 2B D9 33 C9 21 45 E0 89 4D DC 8B C3 83 E8 04 0F 84 A9 00 00 00 48 74 49 83 E8 03 0F 85 56 01 00 00 A1 ?? ?? ?? ?? D1 E8 F7 D0 A8 01 0F 84 F0 00 00 00 85 F6 74 24 6A 20 8D 4D D4 89 75 D4 89 55 D8 E8 ?? ?? ?? ?? 6A 0A E8 ?? ?? ?? ?? 59 50 8D 45 BC 8D 4D D4 E9 A1 00 00 00 6A 0A E9 AF 00 00 00 A1 ?? ?? ?? ?? D1 E8 F7 D0 A8 01 0F 84 B0 00 00 00 85 C9 74 35 8B 45 E0 89 4D EC 8D 4D EC 6A 20 89 45 F0 E8 ?? ?? ?? ?? 6A 0B E8 ?? ?? ?? ?? 59 50 8D 45 B4 50 8D 4D EC E8 ?? ?? ?? ?? 8B 08 8B 40 04 89 4D DC 89 45 E0 EB 77 6A 0B E8 ?? ?? ?? ?? 59 50 8D 4D DC E8 ?? ?? ?? ?? EB 64 8B 0D ?? ?? ?? ?? 8B C1 D1 E8 F7 D0 A8 01 74 54 C1 E9 11 F7 D1 F6 C1 01 74 4A 85 F6 74 32 6A 20 8D 4D CC 89 75 CC 89 55 D0 E8 ?? ?? ?? ?? 6A 09 E8 ?? ?? ?? ?? 59 50 8D 45 AC 8D 4D CC 50 E8 ?? ?? ?? ?? 8B 30 8B 40 04 89 75 E4 89 45 E8 EB 14 6A 09 E8 ?? ?? ?? ?? 59 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 75 E4 A1 ?? ?? ?? ?? 40 A3 ?? ?? ?? ?? 80 38 24 75 20 57 8D 45 FF 50 8D 45 10 50 8D 45 C4 50 E8 ?? ?? ?? ?? 8B 4D C4 83 C4 10 85 C9 0F 85 35 03 00 00 A1 ?? ?? ?? ?? 33 C9 8B 55 E8 8A 00 3C 41 0F BE D8 0F 9C C1 49 83 E1 2B 83 C1 16 2B D9 8B 4D DC E9 93 FE FF FF A1 ?? ?? ?? ?? 80 38 00 74 06 FF 05 ?? ?? ?? ?? 83 FB 1F 0F 87 B0 00 00 00 FF 75 10 8D 4D EC E8 ?? ?? ?? ?? 8B 45 F8 8D 4D D4 83 65 D4 00 89 45 D8 8D 45 EC 50 E8 ?? ?? ?? ?? 8B 45 D4 8B 55 D8 89 45 EC 89 55 F0 85 F6 74 34 6A 20 8D 4D D4 89 45 D4 89 55 D8 E8 ?? ?? ?? ?? 8B 45 D4 8D 4D F4 89 45 F4 8B 45 D8 89 45 F8 8D 45 E4 50 E8 ?? ?? ?? ?? 8B 45 F4 8B 55 F8 89 45 EC 89 55 F0 8B 4D DC 85 C9 74 37 8B 45 E0 89 4D D4 8D 4D D4 6A 20 89 45 D8 E8 ?? ?? ?? ?? 8B 45 D4 8D 4D DC 89 45 DC 8B 45 D8 89 45 E0 8D 45 EC 50 E8 ?? ?? ?? ?? 8B 45 DC 8B 55 E0 89 45 EC 89 55 F0 F6 C3 10 0F 84 D3 00 00 00 85 FF 74 07 6A 02 E9 BF 02 00 00 8B 45 10 80 38 00 74 78 8D 45 EC 50 8D 45 CC 50 68 ?? ?? ?? ?? 8D 4D AC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 CC 89 45 EC 8B 45 D0 89 45 F0 A1 ?? ?? ?? ?? 80 38 00 8D 45 EC 50 74 1F 8D 45 AC 50 8D 45 B4 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 8B 08 8B 50 04 89 4D EC EB 1E 8D 45 CC 50 6A 01 8D 4D AC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 CC 8B 55 D0 89 45 EC 89 55 F0 EB 20 A1 ?? ?? ?? ?? 80 38 00 74 31 8D 45 AC 50 E8 ?? ?? ?? ?? 59 50 8D 4D EC E8 ?? ?? ?? ?? 8B 55 F0 A1 ?? ?? ?? ?? 8A 08 84 C9 74 10 40 A3 ?? ?? ?? ?? 80 F9 40 74 12 E9 3E FF FF FF 6A 01 8D 4D EC E8 ?? ?? ?? ?? 8B 55 F0 A1 ?? ?? ?? ?? D1 E8 F7 D0 A8 01 8B C3 74 35 83 E0 0C 3C 0C 75 4B 85 FF 0F 85 13 FF FF FF 8D 45 EC 50 8D 45 AC 50 8D 45 B4 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 8B 08 8B 50 04 89 4D EC 89 55 F0 EB 1D 83 E0 0C 3C 0C 75 16 8D 45 AC 50 E8 ?? ?? ?? ?? 59 50 8D 4D EC E8 ?? ?? ?? ?? 8B 55 F0 F6 C3 02 74 28 8D 45 EC 50 8D 45 CC 50 68 ?? ?? ?? ?? 8D 4D AC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 CC 8B 55 D0 89 45 EC 89 55 F0 F6 C3 01 74 28 8D 45 EC 50 8D 45 CC 50 68 ?? ?? ?? ?? 8D 4D AC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 CC 8B 55 D0 89 45 EC 89 55 F0 BB 00 01 00 00 85 FF 0F 85 92 00 00 00 8B 75 0C 33 C9 39 0E 74 5D 85 5E 04 75 42 8B 45 14 39 08 74 3B 50 8D 45 D4 50 6A 20 8D 4D AC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 D4 8D 4D CC 89 45 CC 8B 45 D8 6A 20 89 45 D0 E8 ?? ?? ?? ?? 56 8D 45 B4 50 8D 4D CC E8 ?? ?? ?? ?? EB 36 F7 46 04 00 08 00 00 74 0A 8B 06 8B 56 04 89 45 EC EB 2F 56 EB 08 8B 45 14 39 08 74 25 50 8D 45 C4 50 6A 20 8D 4D AC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8D 45 C4 50 8D 4D EC E8 ?? ?? ?? ?? 8B 55 F0 0B D3 80 7D FF 00 74 06 81 CA 00 20 00 00 8B 45 08 8B 4D EC 89 08 89 50 04 E9 8A 00 00 00 8B 45 08 89 08 8B 4D C8 E9 3A FB FF FF 39 4D 18 75 6B 8B 75 0C 39 0E 74 5A F7 46 04 00 01 00 00 75 41 8B 45 14 39 08 74 3A 50 8D 45 C4 50 6A 01 8D 4D AC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 C4 8D 4D CC 89 45 CC 8B 45 C8 6A 20 89 45 D0 E8 ?? ?? ?? ?? 56 FF 75 08 8D 4D CC E8 ?? ?? ?? ?? EB 24 56 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB 14 8B 45 14 39 08 74 03 50 EB E7 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_71_0 {
	meta:
		name = "?getDataIndirectType@UnDecorator@@CA?AVDName@@XZ"
		size = 57
		refs = "0019 ??_C@_00CNPNBAHC@?$AA@ 002b ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@PBD0H@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 33 C9 B8 00 00 FF FF 21 45 FC 21 45 F4 8D 45 F8 51 50 68 ?? ?? ?? ?? 8D 45 F0 89 4D F8 50 FF 75 08 89 4D F0 E8 ?? ?? ?? ?? 8B 45 08 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_72_0 {
	meta:
		name = "?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z"
		size = 210
		refs = "000d ??0DName@@QAE@PAV0@@Z 0012 ?gName@UnDecorator@@0PBDB 0032 ?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 004d ??_C@_04GKJNKENE@void?$AA@ 0052 ??0DName@@QAE@PBD@Z 0063 ??_C@_05BEFAKPML@void?5?$AA@ 0086 ??_C@_00CNPNBAHC@?$AA@ 0093 ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@PBD0H@Z 00c0 ??0DName@@QAE@W4DNameStatus@@@Z 00c7 ??HDName@@QBE?AV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 8D 4D F8 FF 75 0C E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 08 84 C9 0F 84 93 00 00 00 80 F9 3F 74 49 80 F9 58 74 13 8D 45 F8 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 E9 8E 00 00 00 40 83 7D F8 00 A3 ?? ?? ?? ?? 75 0F 8B 4D 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 73 8D 45 F8 50 FF 75 08 8D 4D F0 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 56 83 65 F0 00 40 81 65 F4 00 00 FF FF A3 ?? ?? ?? ?? 8D 45 F0 6A 00 50 68 ?? ?? ?? ?? 8D 45 F8 50 8D 45 E8 50 E8 ?? ?? ?? ?? 8B 08 89 4D F8 8B 40 04 89 45 FC 8D 45 F8 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 1C EB 18 8D 45 F8 50 FF 75 08 8D 4D F0 6A 01 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_73_0 {
	meta:
		name = "?getDecoratedName@UnDecorator@@CA?AVDName@@XZ"
		size = 588
		refs = "0004 ?disableFlags@UnDecorator@@0KA 0028 ?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z 0048 ?gName@UnDecorator@@0PBDB 006b ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 0089 ?getSymbolName@UnDecorator@@CA?AVDName@@XZ 00e1 ?getScope@UnDecorator@@CA?AVDName@@XZ 00f3 ?fExplicitTemplateParams@UnDecorator@@0_NA 010f ??YDName@@QAEAAV0@ABV0@@Z 0135 ??_C@_02MOLJINC@?3?3?$AA@ 0148 ??YDName@@QAEAAV0@PBD@Z 0219 ?composeDeclaration@UnDecorator@@CA?AVDName@@ABV2@@Z 023e ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 EC 24 53 56 BE 00 20 00 00 57 85 C6 74 30 25 FF DF FF FF A3 ?? ?? ?? ?? 8D 45 DC 6A 00 50 E8 ?? ?? ?? ?? 09 35 ?? ?? ?? ?? 59 59 8B 45 08 8B 4D DC 89 08 8B 4D E0 89 48 04 E9 FE 01 00 00 A1 ?? ?? ?? ?? 8A 08 80 F9 3F 0F 85 DD 01 00 00 40 A3 ?? ?? ?? ?? 38 08 75 23 38 48 01 75 1E 8D 45 DC 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 59 EB 06 40 A3 ?? ?? ?? ?? 80 38 00 75 F5 EB B0 8D 45 F4 50 E8 ?? ?? ?? ?? 8B 75 F4 33 C0 8B 5D F8 40 59 85 F6 74 0D F7 C3 00 02 00 00 74 05 89 45 FC EB 04 83 65 FC 00 8B FB C1 EF 0F 23 F8 80 FB 01 7E 0D 8B 45 08 89 30 89 58 04 E9 80 01 00 00 A1 ?? ?? ?? ?? 8A 00 84 C0 0F 84 D2 00 00 00 3C 40 0F 84 CA 00 00 00 8D 45 DC 50 E8 ?? ?? ?? ?? 8B 45 DC 59 85 C0 0F 84 B5 00 00 00 80 3D ?? ?? ?? ?? 00 74 72 8D 45 DC C6 05 ?? ?? ?? ?? 00 50 8D 4D EC 89 75 EC 89 5D F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 75 EC 8B 5D F0 89 75 F4 80 38 40 89 5D F8 74 7D 8D 45 DC 50 E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 8B 08 8B 40 04 89 4D EC 8D 4D EC 89 45 F0 E8 ?? ?? ?? ?? 8B 45 EC 8D 4D E4 89 45 E4 8B 45 F0 89 45 E8 8D 45 F4 50 E8 ?? ?? ?? ?? 8B 75 E4 8B 5D E8 EB 34 89 45 E4 8D 4D E4 8B 45 E0 68 ?? ?? ?? ?? 89 45 E8 E8 ?? ?? ?? ?? 8B 45 E4 8D 4D EC 89 45 EC 8B 45 E8 89 45 F0 8D 45 F4 50 E8 ?? ?? ?? ?? 8B 75 EC 8B 5D F0 89 5D F8 89 75 F4 8B 4D FC 85 C9 74 0D 85 F6 74 09 81 CB 00 02 00 00 89 5D F8 BA 00 80 00 00 85 FF 74 05 0B DA 89 5D F8 85 F6 0F 84 E8 FE FF FF BF 00 10 00 00 85 DF 0F 85 DB FE FF FF A1 ?? ?? ?? ?? 8A 00 84 C0 74 0E 3C 40 74 04 6A 02 EB 4A FF 05 ?? ?? ?? ?? 85 3D ?? ?? ?? ?? 74 26 85 C9 75 22 85 DA 75 1E 21 4D DC 8D 45 DC 81 65 E0 00 00 FF FF 50 8D 45 E4 50 E8 ?? ?? ?? ?? 59 59 E9 94 FE FF FF 8D 45 F4 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 0E 84 C9 75 B4 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_74_0 {
	meta:
		name = "?getDimension@UnDecorator@@CA?AVDName@@_N@Z"
		size = 311
		refs = "0005 ?gName@UnDecorator@@0PBDB 0019 ??_C@_0BN@IBLMMFAP@?$GAnon?9type?9template?9parameter?$AA@ 002f ??0DName@@QAE@W4DNameStatus@@@Z 005b ??0DName@@QAE@_K@Z 0066 ??H@YA?AVDName@@PBDABV0@@Z 00ed ??0DName@@QAE@_J@Z"
	strings:
		$1 = { 55 8B EC 8B 0D ?? ?? ?? ?? 83 EC 18 56 33 F6 80 39 51 57 8B FE 75 0C 41 BF ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 8A 01 84 C0 75 12 8B 4D 08 6A 01 E8 ?? ?? ?? ?? 8B 45 08 E9 F6 00 00 00 3C 30 7C 4C 3C 39 7F 48 0F BE C0 83 E8 2F 41 99 89 0D ?? ?? ?? ?? 52 50 85 FF 74 18 8D 4D F8 E8 ?? ?? ?? ?? 50 8D 45 F0 57 50 E8 ?? ?? ?? ?? 83 C4 0C EB 08 8D 4D E8 E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 0A 89 08 8B 4A 04 89 48 04 E9 A6 00 00 00 53 8B DE EB 29 84 C0 74 45 3C 41 7C 32 3C 50 7F 2E 0F BE C0 0F A4 F3 04 83 E8 41 99 C1 E6 04 03 C6 8B F0 13 DA 41 89 0D ?? ?? ?? ?? 8A 01 3C 40 75 D3 8A 01 41 89 0D ?? ?? ?? ?? 3C 40 74 13 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 57 6A 01 EB EF 80 7D 0C 00 53 56 74 26 85 FF 74 18 8D 4D E8 E8 ?? ?? ?? ?? 50 8D 45 F0 57 50 E8 ?? ?? ?? ?? 83 C4 0C EB 20 8D 4D F8 E8 ?? ?? ?? ?? EB 16 85 FF 74 0A 8D 4D E8 E8 ?? ?? ?? ?? EB D8 8D 4D F8 E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 0A 89 08 8B 4A 04 89 48 04 5B 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_75_0 {
	meta:
		name = "?getDispatchTarget@UnDecorator@@CA?AVDName@@XZ"
		size = 91
		refs = "0005 ?gName@UnDecorator@@0PBDB 003f ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 8B 0D ?? ?? ?? ?? 8A 01 84 C0 74 39 3C 5F 75 35 8A 41 01 84 C0 74 2E 3C 5F 75 2A 83 C1 02 89 0D ?? ?? ?? ?? 0F BE 01 83 E8 41 41 89 0D ?? ?? ?? ?? 83 F8 03 76 0F 8B 4D 08 6A 02 E8 ?? ?? ?? ?? 8B 45 08 5D C3 8B 45 08 83 20 00 C6 40 04 00 81 60 04 FF 00 FF FF 5D C3 }
	condition:
		$1
}

rule file_137_76_0 {
	meta:
		name = "?getDisplacement@UnDecorator@@CA?AVDName@@XZ"
		size = 20
		refs = "0009 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z"
	strings:
		$1 = { 55 8B EC 6A 01 FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 59 59 5D C3 }
	condition:
		$1
}

rule file_137_77_0 {
	meta:
		name = "?getECSUDataType@UnDecorator@@CA?AVDName@@XZ"
		size = 275
		refs = "0004 ?disableFlags@UnDecorator@@0KA 0026 ?gName@UnDecorator@@0PBDB 005e ??_C@_0N@DLIEFKNA@cointerface?5?$AA@ 0065 ??_C@_08KOFANOFK@coclass?5?$AA@ 0072 ?getEnumType@UnDecorator@@CA?AVDName@@XZ 007d ??_C@_05LJGMCFOG@enum?5?$AA@ 0085 ??0DName@@QAE@PBD@Z 008c ??HDName@@QBE?AV0@ABV0@@Z 009f ??_C@_06LJBABKPM@class?5?$AA@ 00a6 ??_C@_07DIBCDNGL@struct?5?$AA@ 00ad ??_C@_06MOJHIBMG@union?5?$AA@ 00b5 ??4DName@@QAEAAV0@PBD@Z 00d5 ?getScopedName@UnDecorator@@CA?AVDName@@XZ 00e2 ??YDName@@QAEAAV0@ABV0@@Z 0101 ??_C@_0P@GCIFDJCJ@?$GAunknown?5ecsu?8?$AA@"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 EC 20 8B D0 C1 EA 0F F7 D2 53 56 33 F6 46 23 D6 74 07 A9 00 10 00 00 74 02 33 F6 8B 0D ?? ?? ?? ?? BB 00 00 FF FF 83 65 F8 00 21 5D FC 0F BE 01 41 89 0D ?? ?? ?? ?? 83 E8 00 0F 84 AD 00 00 00 83 E8 54 74 5E 48 74 54 48 74 4A 48 74 14 48 74 0A 48 75 5C 68 ?? ?? ?? ?? EB 4D 68 ?? ?? ?? ?? EB 46 8D 45 E8 8B F2 50 E8 ?? ?? ?? ?? 59 50 8D 45 F0 50 68 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 F0 89 45 F8 8B 45 F4 89 45 FC EB 1B 68 ?? ?? ?? ?? EB 0C 68 ?? ?? ?? ?? EB 05 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 83 65 F0 00 21 5D F4 85 F6 74 0C 8B 45 F8 89 45 F0 8B 45 FC 89 45 F4 8D 45 F8 50 E8 ?? ?? ?? ?? 59 8D 45 F8 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 08 8B 4D F0 89 08 8B 4D F4 89 48 04 EB 17 49 89 0D ?? ?? ?? ?? 8B 4D 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_78_0 {
	meta:
		name = "?getECSUName@UnDecorator@@CA?AVDName@@XZ"
		size = 17
		refs = "0007 ?getScopedName@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 59 5D C3 }
	condition:
		$1
}

rule file_137_105_0 {
	meta:
		name = "?getStorageConvention@UnDecorator@@CA?AVDName@@XZ"
		size = 17
		refs = "0007 ?getDataIndirectType@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 59 5D C3 }
	condition:
		$1
}

rule file_137_79_0 {
	meta:
		name = "?getEnumType@UnDecorator@@CA?AVDName@@XZ"
		size = 228
		refs = "0007 ?gName@UnDecorator@@0PBDB 0032 $LN27 0037 ??_C@_05CIHEBHNO@char?5?$AA@ 003e ??_C@_06EHJMALKF@short?5?$AA@ 0045 ??_C@_04LAHKHJMA@int?5?$AA@ 004c ??_C@_05CJIMAING@long?5?$AA@ 0054 ??4DName@@QAEAAV0@PBD@Z 0080 ??_C@_09EBBEKKIH@unsigned?5?$AA@ 0088 ??0DName@@QAE@PBD@Z 008f ??HDName@@QBE?AV0@ABV0@@Z 00b9 ??0DName@@QAE@W4DNameStatus@@@Z 00c4 $LN10 00cc $LN9 00d4 $LN11 00d8 $LN7 00dc $LN6"
	strings:
		$1 = { 55 8B EC 83 EC 18 A1 ?? ?? ?? ?? 83 65 F8 00 81 65 FC 00 00 FF FF 8A 00 84 C0 0F 84 93 00 00 00 0F BE C0 83 C0 D0 83 F8 07 0F 87 80 00 00 00 FF 24 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB 13 68 ?? ?? ?? ?? EB 0C 68 ?? ?? ?? ?? EB 05 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 00 FF 05 ?? ?? ?? ?? 83 E8 31 74 0C 48 48 74 08 48 48 74 04 48 48 75 28 8D 45 F8 50 8D 45 F0 50 68 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 F0 89 45 F8 8B 45 F4 89 45 FC 8B 45 08 8B 4D F8 89 08 8B 4D FC 89 48 04 EB 11 6A 02 EB 02 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_137_80_0 {
	meta:
		name = "?getExtendedDataIndirectType@UnDecorator@@CA?AVDName@@AAPBDAA_NH@Z"
		size = 421
		refs = "0008 ?gName@UnDecorator@@0PBDB 0083 ??4DName@@QAEAAV0@D@Z 008d ??0DName@@QAE@_K@Z 009a ??HDName@@QBE?AV0@ABV0@@Z 00af ??YDName@@QAEAAV0@D@Z 0105 ??YDName@@QAEAAV0@W4DNameStatus@@@Z 0128 ??_C@_01FGNFDNOH@?$CF?$AA@ 0139 ??0DName@@QAE@W4DNameStatus@@@Z 017e ??_C@_01JKBOJNNK@?$FO?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 15 ?? ?? ?? ?? 53 56 8B 75 FC 33 DB 81 E6 00 00 FF FF 89 5D F8 42 89 75 FC 89 15 ?? ?? ?? ?? 57 8A 0A 0F BE F9 8B C7 83 E8 41 0F 84 23 01 00 00 48 0F 84 F0 00 00 00 48 0F 84 DE 00 00 00 84 C9 0F 84 D2 00 00 00 8A 42 01 84 C0 0F 84 C7 00 00 00 39 5D 14 0F 85 D2 00 00 00 8D 4F D0 83 C2 02 C1 E1 04 83 C1 D0 0F BE F8 03 F9 89 15 ?? ?? ?? ?? 83 FF 01 76 26 6A 2C 8D 4D F8 E8 ?? ?? ?? ?? 53 57 8D 4D E8 E8 ?? ?? ?? ?? 50 8D 45 E0 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 18 8B 70 04 6A 3E 8D 4D F0 89 5D F0 89 75 F4 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 55 F0 8B 4D F4 89 55 F8 80 38 24 89 4D FC 75 08 40 A3 ?? ?? ?? ?? EB 21 89 4D F4 8D 4D F0 6A 5E 89 55 F0 E8 ?? ?? ?? ?? 8B 55 F0 8B 4D F4 A1 ?? ?? ?? ?? 89 55 F8 89 4D FC 80 38 00 74 08 40 A3 ?? ?? ?? ?? EB 10 6A 01 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D FC 8B 55 F8 8B 45 08 81 C9 00 40 00 00 89 10 89 48 04 EB 7F 6A 01 EB 12 8B 45 0C C7 00 ?? ?? ?? ?? EB 24 39 5D 14 74 0F 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 5C 8B 45 10 8D 4D F8 6A 3E C6 00 01 E8 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? EB 35 39 5D 14 75 29 8B 4D 0C 8B 01 80 38 26 75 0C C7 01 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 01 80 38 2A 75 0C C7 01 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 42 89 15 ?? ?? ?? ?? 8B 45 08 88 58 04 81 60 04 FF 00 FF FF 89 18 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_81_0 {
	meta:
		name = "?getExternalDataType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 121
		refs = "0007 _heap 0011 ?getMemory@_HeapManager@@QAEPAXIH@Z 0032 ?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z 003b ?getDataIndirectType@UnDecorator@@CA?AVDName@@XZ 0054 ??YDName@@QAEAAV0@D@Z 0063 ??HDName@@QBE?AV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 B9 ?? ?? ?? ?? 56 6A 00 6A 08 E8 ?? ?? ?? ?? 8B F0 85 F6 74 10 83 26 00 C6 46 04 00 81 66 04 FF 00 FF FF EB 02 33 F6 56 FF 75 08 E8 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? 8B 45 F0 8D 4D F8 83 C4 0C 89 45 F8 8B 45 F4 89 45 FC 6A 20 E8 ?? ?? ?? ?? FF 75 0C 8D 45 E8 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 08 89 0E 8B 48 04 8B 45 08 89 4E 04 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_82_0 {
	meta:
		name = "?getFunctionIndirectType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 1014
		refs = "0004 ?gName@UnDecorator@@0PBDB 001a ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 003e ??0DName@@QAE@W4DNameStatus@@@Z 00d6 ??_C@_02MOLJINC@?3?3?$AA@ 00de ??0DName@@QAE@PBD@Z 00e5 ??HDName@@QBE?AV0@ABV0@@Z 0104 ?getScope@UnDecorator@@CA?AVDName@@XZ 0114 ??0DName@@QAE@D@Z 0133 ??YDName@@QAEAAV0@ABV0@@Z 0186 ?disableFlags@UnDecorator@@0KA 0196 ?getThisType@UnDecorator@@CA?AVDName@@XZ 01c1 ?getBasedType@UnDecorator@@CA?AVDName@@XZ 020d ??_5DName@@QAEAAV0@ABV0@@Z 0260 ?getCallingConvention@UnDecorator@@CA?AVDName@@XZ 02bd ??YDName@@QAEAAV0@D@Z 02d1 _heap 02d6 ?getMemory@_HeapManager@@QAEPAXIH@Z 02f6 ?getReturnType@UnDecorator@@CA?AVDName@@PAV2@@Z 02ff ?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ 0372 ?getRestrictionSpec@UnDecorator@@CA?AVDName@@XZ 03a4 ?getThrowTypes@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 EC 38 8A 08 84 C9 75 18 FF 75 0C 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 E9 C9 03 00 00 80 F9 36 7C 05 80 F9 39 7E 11 80 F9 5F 74 0C 8B 4D 08 6A 02 E8 ?? ?? ?? ?? EB DD 53 0F BE D9 83 EB 36 40 A3 ?? ?? ?? ?? 83 FB 29 75 2E 8A 08 84 C9 74 16 0F BE D9 83 EB 3D 40 A3 ?? ?? ?? ?? 83 FB 04 7C 20 83 FB 07 EB 19 FF 75 0C 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB 1B 85 DB 78 05 83 FB 03 7E 03 83 CB FF 83 FB FF 75 12 8B 4D 08 6A 02 E8 ?? ?? ?? ?? 8B 45 08 E9 4A 03 00 00 83 65 F0 00 81 65 F4 00 00 FF FF 56 8B 75 0C 57 8B FB 8B 06 89 45 F8 8B 46 04 89 45 FC 83 E7 02 0F 84 D9 00 00 00 8D 45 F8 50 8D 45 E8 50 68 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 E8 89 45 F8 8B 45 EC 89 45 FC A1 ?? ?? ?? ?? 80 38 00 74 43 8D 45 D0 50 E8 ?? ?? ?? ?? 59 50 8D 45 E0 50 6A 20 8D 4D C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 E0 8D 4D E8 89 45 E8 8B 45 E4 89 45 EC 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 E8 89 45 F8 8B 45 EC EB 22 8D 45 F8 50 8D 45 E0 50 6A 01 8D 4D C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 E0 89 45 F8 8B 45 E4 89 45 FC A1 ?? ?? ?? ?? 8A 08 84 C9 0F 84 A4 00 00 00 80 F9 40 0F 85 94 00 00 00 40 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 E0 60 3C 60 8D 45 C8 50 74 6D E8 ?? ?? ?? ?? 59 8B 08 8B 40 04 89 4D F0 89 45 F4 F6 C3 04 0F 84 97 00 00 00 A1 ?? ?? ?? ?? D1 E8 F7 D0 A8 01 8D 45 C8 50 74 77 E8 ?? ?? ?? ?? 59 50 8D 45 E0 50 6A 20 8D 4D D0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 E0 8D 4D E8 89 45 E8 8B 45 E4 89 45 EC 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 E8 89 45 F8 8B 45 EC 89 45 FC EB 44 E8 ?? ?? ?? ?? 59 50 8D 4D F0 E8 ?? ?? ?? ?? EB 93 6A 02 E9 CA 01 00 00 8D 45 F8 50 FF 75 08 8D 4D C8 6A 01 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E9 B5 01 00 00 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? D1 E8 F7 D0 A8 01 74 26 8D 45 F8 50 8D 45 C8 50 8D 45 D0 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 8B 08 8B 40 04 89 4D F8 89 45 FC EB 13 8D 45 C8 50 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? 33 DB 39 1E 74 3B 8D 45 F8 50 8D 45 E0 50 6A 28 8D 4D C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 E0 8D 4D E8 89 45 E8 8B 45 E4 6A 29 89 45 EC E8 ?? ?? ?? ?? 8B 45 E8 89 45 F8 8B 45 EC 89 45 FC 53 6A 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 85 F6 74 0E 88 5E 04 81 66 04 FF 00 FF FF 89 1E EB 02 8B F3 8D 45 D8 56 50 E8 ?? ?? ?? ?? 8D 45 C8 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 4D D0 50 8D 45 E0 50 6A 28 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 E0 8D 4D E8 89 45 E8 8B 45 E4 6A 29 89 45 EC E8 ?? ?? ?? ?? 8D 45 E8 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8B C1 83 E0 60 3C 60 74 16 85 FF 74 12 8D 45 F0 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? C1 E9 13 8D 45 C8 F7 D1 50 F6 C1 01 74 11 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? EB 0F E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 08 F7 D0 A8 01 8D 45 C8 50 74 11 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? EB 0F E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? 85 F6 74 1B 8B 45 F8 89 06 8B 45 FC 89 46 04 8B 45 08 8B 4D D8 89 08 8B 4D DC 89 48 04 EB 0D 6A 03 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_87_0 {
	meta:
		name = "?getLastChar@pDNameNode@@UBEDXZ"
		size = 21
	strings:
		$1 = { 8B 49 04 85 C9 74 0B 8B 09 85 C9 74 05 8B 01 FF 60 04 32 C0 C3 }
	condition:
		$1
}

rule file_137_88_0 {
	meta:
		name = "?getLastChar@pairNode@@UBEDXZ"
		size = 26
	strings:
		$1 = { 56 8B F1 8B 4E 08 8B 01 FF 50 04 84 C0 75 09 8B 4E 04 5E 8B 01 FF 60 04 5E C3 }
	condition:
		$1
}

rule file_137_89_0 {
	meta:
		name = "?getLastChar@pcharNode@@UBEDXZ"
		size = 18
	strings:
		$1 = { 8B 51 08 85 D2 74 08 8B 41 04 8A 44 10 FF C3 32 C0 C3 }
	condition:
		$1
}

rule file_137_90_0 {
	meta:
		name = "?getLexicalFrame@UnDecorator@@CA?AVDName@@XZ"
		size = 61
		refs = "000d ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 001e ??0DName@@QAE@D@Z 0025 ??HDName@@QBE?AV0@ABV0@@Z 0032 ??HDName@@QBE?AV0@D@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 59 59 50 8D 45 F8 50 6A 60 8D 4D E8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 6A 27 FF 75 08 8D 4D F8 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_91_0 {
	meta:
		name = "?getMemory@_HeapManager@@QAEPAXIH@Z"
		size = 133
		refs = "003c _heap 0041 ?getMemory@_HeapManager@@QAEPAXIH@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 83 C6 07 83 E6 F8 83 7D 0C 00 57 8B F9 74 06 56 FF 17 59 EB 63 85 F6 75 03 6A 08 5E 8B 47 10 53 3B C6 73 45 BB 00 10 00 00 3B F3 77 38 6A 01 68 04 10 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 05 83 20 00 EB 02 33 C0 85 C0 74 18 8B 4F 0C 85 C9 74 04 89 01 EB 03 89 47 08 2B DE 89 47 0C 89 5F 10 EB 09 33 C0 EB 0E 2B C6 89 47 10 8B 47 10 83 C0 04 03 47 0C 5B 5F 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_137_92_0 {
	meta:
		name = "?getNumberOfDimensions@UnDecorator@@CAHXZ"
		size = 97
		refs = "0002 ?gName@UnDecorator@@0PBDB"
	strings:
		$1 = { 8B 0D ?? ?? ?? ?? 8A 01 84 C0 75 03 33 C0 C3 3C 30 7C 12 3C 39 7F 0E 0F BE C0 83 E8 2F 41 89 0D ?? ?? ?? ?? C3 33 D2 EB 20 84 C0 74 DF 3C 41 7C 2C 3C 50 7F 28 C1 E2 04 0F BE C0 83 C2 BF 03 D0 41 89 0D ?? ?? ?? ?? 8A 01 3C 40 75 DC 8A 01 41 89 0D ?? ?? ?? ?? 3C 40 75 03 8B C2 C3 83 C8 FF C3 }
	condition:
		$1
}

rule file_137_93_0 {
	meta:
		name = "?getOperatorName@UnDecorator@@CA?AVDName@@_NPA_N@Z"
		size = 1498
		refs = "001a ?gName@UnDecorator@@0PBDB 0069 _nameTable 0071 ??4DName@@QAEAAV0@PBD@Z 0089 ??_C@_08LHJFAFGD@operator?$AA@ 0091 ??0DName@@QAE@PBD@Z 0098 ??HDName@@QBE?AV0@ABV0@@Z 00c0 ?getTemplateArgumentList@UnDecorator@@CA?AVDName@@XZ 00d0 ??0DName@@QAE@D@Z 00e3 ??YDName@@QAEAAV0@ABV0@@Z 00fd ??YDName@@QAEAAV0@D@Z 0143 ?getZName@UnDecorator@@CA?AVDName@@_N0@Z 01ba ??0DName@@QAE@W4DNameStatus@@@Z 0291 ??_C@_08OBABFOLI@?$GAstring?8?$AA@ 029a ?getStringEncoding@UnDecorator@@CA?AVDName@@PADH@Z 02c9 ??_C@_0BG@JNJLAMPM@?$GAanonymous?5namespace?8?$AA@ 031f ??HDName@@QBE?AV0@W4DNameStatus@@@Z 0340 _rttiTable 03a5 ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 03ad ??HDName@@QBE?AV0@D@Z 0406 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 0434 ?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z 0487 ?getOperatorName@UnDecorator@@CA?AVDName@@_NPA_N@Z 052b ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 0550 ?getSymbolName@UnDecorator@@CA?AVDName@@XZ 055f ??_C@_02OHHJMEON@?8?8?$AA@ 0567 ??YDName@@QAEAAV0@PBD@Z"
	strings:
		$1 = { 55 8B EC 81 EC 90 00 00 00 8B 4D FC BA 00 00 FF FF 21 55 F4 23 CA 53 56 8B 35 ?? ?? ?? ?? 57 33 FF 89 4D FC 89 7D F8 0F BE 06 46 89 7D F0 89 35 ?? ?? ?? ?? 83 F8 41 0F 8F 89 01 00 00 0F 84 58 05 00 00 85 C0 0F 84 62 01 00 00 83 F8 2F 0F 8E 50 04 00 00 83 F8 31 7E 4E 83 F8 39 0F 8F 42 04 00 00 0F BE 46 FF FF 34 85 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 8B 7D F8 85 FF 0F 84 48 05 00 00 8D 45 F8 50 8D 45 D8 50 68 ?? ?? ?? ?? 8D 4D D0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 7D D8 8B 4D DC E9 24 05 00 00 21 55 F4 8B DF 89 5D F0 38 5D 0C 0F 84 81 00 00 00 8D 85 78 FF FF FF 50 E8 ?? ?? ?? ?? 59 50 8D 45 D8 50 6A 3C 8D 4D E0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8D 45 D8 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D F0 85 C9 74 13 8B 01 FF 50 04 3C 3E 75 0A 6A 20 8D 4D F0 E8 ?? ?? ?? ?? 6A 3E 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 10 85 C0 74 03 C6 00 01 8B 35 ?? ?? ?? ?? 38 1E 75 10 8B 45 08 8B 4D F0 89 08 8B 4D F4 E9 A1 04 00 00 8B 5D F0 46 89 35 ?? ?? ?? ?? 57 8D 85 70 FF FF FF 57 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 08 8B 50 04 89 4D F8 89 55 FC 89 35 ?? ?? ?? ?? 85 C9 74 2B 80 7E FF 31 75 25 8D 45 F8 50 8D 45 E0 50 6A 7E 8D 4D D8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4D E0 8B 55 E4 89 4D F8 89 55 FC 85 DB 74 12 8D 45 F0 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 55 FC 8B 4D F8 8B 45 08 89 08 89 50 04 E9 26 04 00 00 4E 89 35 ?? ?? ?? ?? 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 0D 04 00 00 83 F8 42 0F 84 C9 03 00 00 0F 8E CF 02 00 00 83 F8 5A 0F 8E BD 03 00 00 83 F8 5F 0F 85 BD 02 00 00 0F BE 06 46 89 35 ?? ?? ?? ?? 83 F8 4F 0F 8F D5 00 00 00 83 F8 44 0F 8D 75 03 00 00 83 F8 39 7F 66 74 40 85 C0 74 9F 83 F8 2F 0F 8E 8D 02 00 00 83 F8 36 7E 1E 83 F8 38 0F 8F 7F 02 00 00 0F BE 46 FF FF 34 85 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? EB 84 0F BE 46 FF FF 34 85 ?? ?? ?? ?? E9 23 FE FF FF 0F BE 46 FF 8D 4D E0 FF 34 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 E4 81 CA 00 80 00 00 8B 4D E0 E9 32 FF FF FF 83 F8 3F 74 39 83 F8 40 0F 8E 28 02 00 00 83 F8 42 0F 8E F3 02 00 00 83 F8 43 0F 85 16 02 00 00 6A 01 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 55 E4 83 C4 0C 81 CA 00 10 00 00 EB BA 0F BE 06 46 89 35 ?? ?? ?? ?? 85 C0 0F 84 EF FE FF FF 83 F8 30 0F 85 DD 01 00 00 57 68 ?? ?? ?? ?? EB C6 83 F8 54 0F 8F E7 01 00 00 83 F8 53 0F 8D 97 02 00 00 83 E8 50 0F 84 83 01 00 00 48 0F 84 DA 02 00 00 48 0F 85 AC 01 00 00 0F BE 46 FF 8D 4D F8 FF 34 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 00 84 C0 75 12 6A 01 FF 75 08 8D 4D F8 E8 ?? ?? ?? ?? E9 96 FE FF FF 0F BE C0 83 E8 30 0F 88 70 01 00 00 83 F8 05 0F 83 67 01 00 00 FF 34 85 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 0F BE 01 41 89 0D ?? ?? ?? ?? 83 F8 30 0F 84 C9 00 00 00 83 F8 31 74 18 83 C0 CE 83 F8 02 0F 86 35 01 00 00 49 89 0D ?? ?? ?? ?? E9 32 FE FF FF 8B 45 F8 8D 4D E8 89 45 E8 8B 45 FC 89 45 EC 8D 45 F0 50 E8 ?? ?? ?? ?? 6A 2C 8D 45 B8 50 8D 45 C8 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E8 E8 ?? ?? ?? ?? 6A 2C 8D 45 A8 50 8D 45 88 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E8 E8 ?? ?? ?? ?? 6A 2C 8D 45 98 50 8D 45 C0 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E8 E8 ?? ?? ?? ?? 6A 29 8D 45 B0 50 8D 45 A0 57 50 E8 ?? ?? ?? ?? 59 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E8 E8 ?? ?? ?? ?? 6A 27 FF 75 08 8D 4D E8 E8 ?? ?? ?? ?? E9 90 FD FF FF 8D 45 D8 57 50 E8 ?? ?? ?? ?? 8B 45 D8 59 59 89 45 E8 8D 4D E8 8B 45 DC 6A 20 89 45 EC E8 ?? ?? ?? ?? 8B 45 E8 8D 4D E0 89 45 E0 8B 45 EC 89 45 E4 8D 45 F8 50 E8 ?? ?? ?? ?? 8D 4D E0 EB 41 0F BE 46 FF 8D 4D F8 FF 34 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 57 8D 45 90 57 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 08 8B 40 04 89 4D F0 89 45 F4 85 C9 74 0E A9 00 04 00 00 74 07 6A 02 E9 0B FD FF FF 8D 4D F8 8D 45 F0 50 FF 75 08 E8 ?? ?? ?? ?? E9 FF FC FF FF 83 F8 56 0F 8E C0 00 00 00 83 F8 57 7E D7 83 F8 59 0F 8E A2 00 00 00 83 F8 5F 75 C9 0F BE 06 46 89 35 ?? ?? ?? ?? 83 F8 41 7C BA 83 F8 44 7E 0A 83 F8 46 7E 15 83 F8 4A 7F AB 0F BE 46 FF FF 34 85 ?? ?? ?? ?? E9 27 FD FF FF 0F BE 46 FF 8D 4D E8 FF 34 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 3F 75 25 8D 45 80 50 E8 ?? ?? ?? ?? 59 50 8D 4D E8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 40 75 1B 40 A3 ?? ?? ?? ?? EB 13 8D 45 D0 50 E8 ?? ?? ?? ?? 59 50 8D 4D E8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 08 8B 4D E8 89 08 8B 4D EC EB 58 0F BE 46 FF FF 34 85 ?? ?? ?? ?? E9 A8 FC FF FF 0F BE 46 FF FF 34 85 ?? ?? ?? ?? E9 D5 FA FF FF 33 FF 47 0F BE 46 FF 8D 4D F8 FF 34 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 FF 0F 84 BF FA FF FF 8B 7D F8 85 FF 74 0B 8B 4D FC 81 C9 00 02 00 00 EB 03 8B 4D FC 8B 45 08 89 38 89 48 04 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_94_0 {
	meta:
		name = "?getPointerType@UnDecorator@@CA?AVDName@@ABV2@0@Z"
		size = 30
		refs = "0004 ??_C@_01NBENCBCI@?$CK?$AA@ 0012 ?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0PBD@Z"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_137_95_0 {
	meta:
		name = "?getPointerTypeArray@UnDecorator@@CA?AVDName@@ABV2@0@Z"
		size = 30
		refs = "0004 ??_C@_00CNPNBAHC@?$AA@ 0012 ?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0PBD@Z"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_137_96_0 {
	meta:
		name = "?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 440
		refs = "0008 ?gName@UnDecorator@@0PBDB 003b ?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 0047 ??_C@_08PABEKFH@volatile?$AA@ 004f ??4DName@@QAEAAV0@PBD@Z 005d ??YDName@@QAEAAV0@D@Z 0068 ??_C@_01HNPIGOCE@?$CG?$AA@ 008f ?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0PBD@Z 00b0 ??0DName@@QAE@W4DNameStatus@@@Z 00eb ??_C@_00CNPNBAHC@?$AA@ 00ff ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@PBD0H@Z 0122 ?getPtrRefDataType@UnDecorator@@CA?AVDName@@ABV2@H@Z 0137 ?getFunctionIndirectType@UnDecorator@@CA?AVDName@@ABV2@@Z 015d ??_C@_0P@GCOCNKDM@std?3?3nullptr_t?$AA@ 0162 ??0DName@@QAE@PBD@Z 0196 ??_C@_02PPKAJPJL@?$CG?$CG?$AA@ 01a8 ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 8B 0D ?? ?? ?? ?? BA 00 00 FF FF 21 55 FC 56 57 0F BE 01 33 FF 89 7D F8 2B C7 0F 84 79 01 00 00 83 E8 24 74 70 8B 75 0C 83 E8 1D 74 34 48 74 10 56 FF 75 08 E8 ?? ?? ?? ?? 59 59 E9 69 01 00 00 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 39 3E 74 0A 6A 20 8D 4D F8 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 06 41 89 45 F0 8B 46 04 0D 00 01 00 00 89 0D ?? ?? ?? ?? 89 45 F4 8D 45 F0 50 8D 45 F8 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 E9 14 01 00 00 8A 41 01 3C 24 74 17 84 C0 0F 84 F5 00 00 00 8B 4D 08 6A 02 E8 ?? ?? ?? ?? E9 F6 00 00 00 8B 75 0C 83 C1 02 89 0D ?? ?? ?? ?? 0F BE 01 83 F8 51 7F 76 0F 84 C2 00 00 00 2B C7 74 69 83 E8 41 74 4F 48 74 35 48 75 C8 21 55 FC 8D 45 F8 57 50 68 ?? ?? ?? ?? 8D 45 E8 89 7D F8 41 56 50 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 1C E9 9B 00 00 00 6A 01 56 FF 75 08 41 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 81 00 00 00 56 FF 75 08 41 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 FF FE FF FF 56 EB 5F 83 E8 52 74 2C 48 74 1D 48 0F 85 58 FF FF FF 41 89 0D ?? ?? ?? ?? 8B 4D 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 47 41 89 0D ?? ?? ?? ?? E9 36 FF FF FF 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 39 3E 74 0A 6A 20 8D 4D F8 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 68 ?? ?? ?? ?? E9 CD FE FF FF FF 75 0C 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_97_0 {
	meta:
		name = "?getPtrRefDataType@UnDecorator@@CA?AVDName@@ABV2@H@Z"
		size = 234
		refs = "0004 ?gName@UnDecorator@@0PBDB 0032 ??_C@_04GKJNKENE@void?$AA@ 0037 ??0DName@@QAE@PBD@Z 0042 ??_C@_05BEFAKPML@void?5?$AA@ 004a ??H@YA?AVDName@@PBDABV0@@Z 0065 ?getArrayType@UnDecorator@@CA?AVDName@@ABV2@@Z 0077 ?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 008f ??_C@_0M@EALIELKG@cli?3?3array?$DM?$AA@ 009e ??HDName@@QBE?AV0@ABV0@@Z 00bc ??_C@_0O@GKABPPIF@cli?3?3pin_ptr?$DM?$AA@ 00dc ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 EC 18 8A 08 84 C9 0F 84 BE 00 00 00 83 7D 10 00 74 38 80 F9 58 75 33 40 A3 ?? ?? ?? ?? 8B 45 0C 83 38 00 75 12 8B 4D 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 A3 00 00 00 50 68 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? E9 8D 00 00 00 80 F9 59 75 15 FF 75 0C 40 FF 75 08 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 EB 76 56 8B 75 0C 8D 45 F8 56 50 E8 ?? ?? ?? ?? F7 46 04 00 40 00 00 59 59 74 24 8D 45 F8 50 8D 45 F0 50 68 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4D F0 8B 55 F4 EB 1E F7 46 04 00 20 00 00 74 0F 8D 45 F8 50 8D 45 F0 50 68 ?? ?? ?? ?? EB D1 8B 55 FC 8B 4D F8 8B 45 08 5E 89 08 89 50 04 EB 13 FF 75 0C 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_98_0 {
	meta:
		name = "?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0PBD@Z"
		size = 252
		refs = "0006 ?gName@UnDecorator@@0PBDB 0029 ??0DName@@QAE@PBD@Z 004b ??YDName@@QAEAAV0@ABV0@@Z 0064 ?getFunctionIndirectType@UnDecorator@@CA?AVDName@@ABV2@@Z 0083 ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@PBD0H@Z 0098 ?getPtrRefDataType@UnDecorator@@CA?AVDName@@ABV2@H@Z 00a7 ??0DName@@QAE@W4DNameStatus@@@Z 00b2 ??YDName@@QAEAAV0@PBD@Z 00da ??YDName@@QAEAAV0@D@Z"
	strings:
		$1 = { 55 8B EC 51 51 A1 ?? ?? ?? ?? 56 57 8A 00 84 C0 0F 84 8B 00 00 00 3C 36 7C 04 3C 39 7E 04 3C 5F 75 50 FF 75 14 8D 4D F8 E8 ?? ?? ?? ?? 8B 45 0C 33 F6 8B 7D 10 39 30 74 16 39 37 74 09 F7 47 04 00 01 00 00 75 09 50 8D 4D F8 E8 ?? ?? ?? ?? 39 37 74 09 57 8D 4D F8 E8 ?? ?? ?? ?? 8D 45 F8 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 8B 45 08 E9 84 00 00 00 8B 75 14 8D 45 F8 6A 00 FF 75 0C 56 FF 75 10 50 E8 ?? ?? ?? ?? 33 C0 80 3E 2A 0F 94 C0 50 8D 45 F8 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 EB C9 6A 01 8D 4D F8 E8 ?? ?? ?? ?? FF 75 14 8D 4D F8 E8 ?? ?? ?? ?? 8B 7D 0C 33 F6 39 37 74 09 57 8D 4D F8 E8 ?? ?? ?? ?? 53 8B 5D 10 39 33 74 17 39 37 74 0A 6A 20 8D 4D F8 E8 ?? ?? ?? ?? 53 8D 4D F8 E8 ?? ?? ?? ?? 8B 45 08 8B 4D F8 5B 89 08 8B 4D FC 89 48 04 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_99_0 {
	meta:
		name = "?getReferenceType@UnDecorator@@CA?AVDName@@ABV2@0PBD@Z"
		size = 28
		refs = "0010 ?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0PBD@Z"
	strings:
		$1 = { 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_137_100_0 {
	meta:
		name = "?getRestrictionSpec@UnDecorator@@CA?AVDName@@XZ"
		size = 238
		refs = "0006 ?gName@UnDecorator@@0PBDB 0037 ?disableFlags@UnDecorator@@0KA 0055 ??_C@_01CLKCMJKC@?5?$AA@ 005d ??YDName@@QAEAAV0@PBD@Z 0064 ?UScore@UnDecorator@@SAPBDW4Tokens@@@Z 0086 ??_C@_03DCBBJBAA@amp?$AA@ 008d ??_C@_03PBJBJNON@cpu?$AA@ 00a0 ??_C@_02KEGNLNML@?0?5?$AA@ 00b4 ??0DName@@QAE@W4DNameStatus@@@Z 00c3 ??YDName@@QAEAAV0@D@Z"
	strings:
		$1 = { 55 8B EC 51 51 A1 ?? ?? ?? ?? 56 57 8A 08 84 C9 0F 84 C1 00 00 00 80 F9 5F 0F 85 B8 00 00 00 40 A3 ?? ?? ?? ?? 0F BE 38 83 EF 41 40 A3 ?? ?? ?? ?? 83 FF 03 77 78 A1 ?? ?? ?? ?? 33 D2 8B 4D FC D1 E8 81 E1 00 00 FF FF F7 D0 89 55 F8 89 4D FC A8 01 74 79 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 6A 0C E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? 85 FF 74 47 8B F7 F7 D6 46 23 F7 8B C6 48 74 0A 48 75 29 68 ?? ?? ?? ?? EB 05 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? F7 D6 23 FE 74 1E 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? EB C8 8B 4D 08 6A 02 E8 ?? ?? ?? ?? 8B 45 08 EB 2B 6A 29 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D FC 8B 55 F8 8B 45 08 89 10 89 48 04 EB 11 8B 45 08 83 20 00 C6 40 04 00 81 60 04 FF 00 FF FF 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_101_0 {
	meta:
		name = "?getReturnType@UnDecorator@@CA?AVDName@@PAV2@@Z"
		size = 47
		refs = "0004 ?gName@UnDecorator@@0PBDB 001a ??0DName@@QAE@PAV0@@Z 0024 ?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? FF 75 0C 80 38 40 75 10 8B 4D 08 40 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0A FF 75 08 E8 ?? ?? ?? ?? 59 59 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_137_102_0 {
	meta:
		name = "?getScope@UnDecorator@@CA?AVDName@@XZ"
		size = 983
		refs = "0031 ?gName@UnDecorator@@0PBDB 0049 ?fExplicitTemplateParams@UnDecorator@@0_NA 0052 ?fGetTemplateArgumentList@UnDecorator@@0_NA 0068 ??_C@_02MOLJINC@?3?3?$AA@ 0073 ??0DName@@QAE@PBD@Z 007a ??HDName@@QBE?AV0@ABV0@@Z 009d ??0DName@@QAE@D@Z 010a ?getLexicalFrame@UnDecorator@@CA?AVDName@@XZ 0131 ?getZName@UnDecorator@@CA?AVDName@@_N0@Z 0155 ??YDName@@QAEAAV0@PBD@Z 016d ??YDName@@QAEAAV0@ABV0@@Z 01cd ??YDName@@QAEAAV0@D@Z 0227 ??HDName@@QBE?AV0@D@Z 0268 ?getOperatorName@UnDecorator@@CA?AVDName@@_NPA_N@Z 029d ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 02e9 ??0DName@@QAE@AAPBDD@Z 02f3 ??_C@_0BG@JNJLAMPM@?$GAanonymous?5namespace?8?$AA@ 0316 ?pZNameList@UnDecorator@@0PAVReplicator@@A 0324 ??YReplicator@@QAEAAV0@ABVDName@@@Z 0398 ??4DName@@QAEAAV0@W4DNameStatus@@@Z 03b2 ??0DName@@QAE@W4DNameStatus@@@Z 03b9 ??HDName@@QBE?AV0@PBD@Z"
	strings:
		$1 = { 55 8B EC 81 EC F0 00 00 00 53 56 8B 75 08 57 C6 45 0B 00 83 26 00 C6 46 04 00 8B 46 04 25 FF 00 FF FF 89 46 04 84 C0 0F 85 42 03 00 00 8B 5D FC A1 ?? ?? ?? ?? 8A 00 84 C0 0F 84 30 03 00 00 3C 40 0F 84 28 03 00 00 80 3D ?? ?? ?? ?? 00 74 0D 80 3D ?? ?? ?? ?? 00 0F 84 71 03 00 00 83 3E 00 74 55 56 8D 45 B0 50 68 ?? ?? ?? ?? 8D 8D 20 FF FF FF E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 80 7D 0B 00 8B 45 B0 89 06 8B 45 B4 89 46 04 74 28 56 8D 45 C8 50 6A 5B 8D 8D 30 FF FF FF E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 C8 89 06 8B 45 CC 89 46 04 C6 45 0B 00 A1 ?? ?? ?? ?? 80 38 3F 0F 85 78 02 00 00 40 A3 ?? ?? ?? ?? 0F BE 00 83 E8 24 0F 84 53 02 00 00 48 0F 84 00 02 00 00 83 E8 1A 0F 84 54 01 00 00 48 48 0F 84 EF 01 00 00 83 E8 08 0F 84 02 01 00 00 83 E8 08 74 17 56 8D 45 80 50 8D 85 10 FF FF FF 50 E8 ?? ?? ?? ?? 59 E9 3E 02 00 00 33 FF 81 E3 00 00 FF FF FF 05 ?? ?? ?? ?? 89 7D F8 89 5D FC 6A 00 8D 45 D8 6A 01 50 E8 ?? ?? ?? ?? 8B 4D DC 83 C4 0C 84 C9 75 41 85 FF 74 36 8B 45 D8 89 4D E4 8D 4D E0 68 ?? ?? ?? ?? 89 45 E0 E8 ?? ?? ?? ?? 8B 45 E0 8D 4D F0 89 45 F0 8B 45 E4 89 45 F4 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 7D F0 8B 5D F4 EB 12 8B 7D D8 8B D9 EB 0B 81 E3 02 00 FF FF 83 CB 02 33 FF 89 5D FC 89 7D F8 84 DB 75 52 A1 ?? ?? ?? ?? 80 38 40 75 89 8D 45 F8 50 8D 45 A8 50 6A 5B 8D 8D 28 FF FF FF E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 A8 8D 4D E8 89 45 E8 8B 45 AC 6A 5D 89 45 EC E8 ?? ?? ?? ?? 8B 45 E8 89 06 8B 45 EC 89 46 04 FF 05 ?? ?? ?? ?? E9 7E 01 00 00 81 66 04 FF 00 FF FF 83 26 00 C6 46 04 02 E9 6B 01 00 00 FF 05 ?? ?? ?? ?? 8D 85 68 FF FF FF 56 50 6A 5D 8D 85 38 FF FF FF 50 6A 00 8D 85 58 FF FF FF 6A 01 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? C6 45 0B 01 E9 1E 01 00 00 A1 ?? ?? ?? ?? 8D 48 01 80 39 5F 75 4D 80 78 02 3F 75 47 56 8D 85 18 FF FF FF 89 0D ?? ?? ?? ?? 50 6A 00 8D 85 48 FF FF FF 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 8B 01 89 06 8B 41 04 89 46 04 A1 ?? ?? ?? ?? 80 38 40 0F 85 D5 00 00 00 E9 47 FF FF FF 8D 85 78 FF FF FF 50 E8 ?? ?? ?? ?? 59 50 8D 45 B8 50 6A 60 8D 8D 70 FF FF FF E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 B8 8D 4D D0 89 45 D0 8B 45 BC 6A 27 89 45 D4 E8 ?? ?? ?? ?? 56 8D 85 60 FF FF FF 50 8D 4D D0 EB 76 6A 40 68 ?? ?? ?? ?? 8D 4D A0 E8 ?? ?? ?? ?? 56 8D 45 C0 50 68 ?? ?? ?? ?? 8D 8D 50 FF FF FF E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 C0 89 06 8B 45 C4 89 46 04 8B 0D ?? ?? ?? ?? 83 39 09 74 46 8D 45 A0 50 E8 ?? ?? ?? ?? EB 3B FF 0D ?? ?? ?? ?? 8D 85 40 FF FF FF 56 50 8D 45 98 EB 08 8D 45 88 56 50 8D 45 90 6A 00 6A 01 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 8B 01 89 06 8B 41 04 89 46 04 80 7E 04 00 0F 84 C1 FC FF FF A1 ?? ?? ?? ?? 8A 00 84 C0 74 14 3C 40 74 50 81 66 04 FF 00 FF FF 83 26 00 C6 46 04 02 EB 40 83 3E 00 75 0B 6A 01 8B CE E8 ?? ?? ?? ?? EB 30 56 8D 45 90 50 68 ?? ?? ?? ?? 8D 45 88 50 6A 01 8D 4D 98 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 08 89 0E 8B 40 04 89 46 04 5F 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_103_0 {
	meta:
		name = "?getScopedName@UnDecorator@@CA?AVDName@@XZ"
		size = 251
		refs = "002d ?getZName@UnDecorator@@CA?AVDName@@_N0@Z 0043 ?gName@UnDecorator@@0PBDB 005a ??_C@_02MOLJINC@?3?3?$AA@ 0067 ?getScope@UnDecorator@@CA?AVDName@@XZ 006f ??HDName@@QBE?AV0@PBD@Z 0076 ??HDName@@QBE?AV0@ABV0@@Z 00bc ??4DName@@QAEAAV0@W4DNameStatus@@@Z 00d6 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 56 8B 75 08 33 DB 57 BF FF FE FF FF 53 88 5E 04 8B 46 04 23 C7 89 1E 25 FF 01 FF FF 89 46 04 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 8B C8 83 C4 0C 8B 01 89 06 8B 41 04 84 C0 89 46 04 A1 ?? ?? ?? ?? 75 42 8A 08 84 C9 74 3C 80 F9 40 74 3E 56 8D 45 F8 50 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 E8 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 8B 01 89 06 8B 41 04 89 46 04 A1 ?? ?? ?? ?? 8A 08 80 F9 40 75 08 40 A3 ?? ?? ?? ?? EB 58 84 C9 74 15 8B 46 04 23 C7 89 1E 25 FF 01 FF FF 89 46 04 C6 46 04 02 EB 3F 39 1E 75 0B 6A 01 8B CE E8 ?? ?? ?? ?? EB 30 56 8D 45 E8 50 68 ?? ?? ?? ?? 8D 45 F0 50 6A 01 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 08 89 0E 8B 48 04 89 4E 04 5F 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_104_0 {
	meta:
		name = "?getSignedDimension@UnDecorator@@CA?AVDName@@XZ"
		size = 83
		refs = "0006 ?gName@UnDecorator@@0PBDB 0016 ??0DName@@QAE@W4DNameStatus@@@Z 002e ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 0039 ??H@YA?AVDName@@DABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 51 A1 ?? ?? ?? ?? 8A 08 84 C9 75 0C 8B 4D 08 6A 01 E8 ?? ?? ?? ?? EB 30 6A 00 80 F9 3F 75 1F 40 A3 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 50 6A 2D FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 EB 0A FF 75 08 E8 ?? ?? ?? ?? 59 59 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_106_0 {
	meta:
		name = "?getString@DName@@QBEPADPAD0@Z"
		size = 22
	strings:
		$1 = { 55 8B EC 8B 09 85 C9 75 07 8B 45 08 5D C2 08 00 8B 01 5D FF 60 08 }
	condition:
		$1
}

rule file_137_107_0 {
	meta:
		name = "?getString@DName@@QBEPADPADH@Z"
		size = 94
		refs = "001b _heap 0024 ?getMemory@_HeapManager@@QAEPAXIH@Z"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 57 8B F9 8B 0F 85 C9 74 3D 85 F6 75 1B 8B 01 FF 10 56 B9 ?? ?? ?? ?? 8D 58 01 53 E8 ?? ?? ?? ?? 8B F0 85 F6 74 27 EB 03 8B 5D 0C 8B 0F 85 C9 75 04 8B C6 EB 0C 8B 11 8D 43 FF 03 C6 50 56 FF 52 08 C6 00 00 EB 07 85 F6 74 03 C6 06 00 5F 8B C6 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule file_137_108_0 {
	meta:
		name = "?getString@DNameStatusNode@@UBEPADPAD0@Z"
		size = 39
		refs = "000c ??_C@_04OKOHEJBO@?5?$DP?$DP?5?$AA@ 0017 ?getStringHelper@@YAPADPAD00H@Z"
	strings:
		$1 = { 55 8B EC 83 79 04 01 75 17 6A 04 68 ?? ?? ?? ?? FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 EB 03 8B 45 08 5D C2 08 00 }
	condition:
		$1
}

rule file_137_109_0 {
	meta:
		name = "?getString@charNode@@UBEPADPAD0@Z"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 08 3B 45 0C 73 06 8A 49 04 88 08 40 5D C2 08 00 }
	condition:
		$1
}

rule file_137_110_0 {
	meta:
		name = "?getString@pDNameNode@@UBEPADPAD0@Z"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 49 04 85 C9 74 0C 8B 09 85 C9 74 06 8B 01 5D FF 60 08 8B 45 08 5D C2 08 00 }
	condition:
		$1
}

rule file_137_111_0 {
	meta:
		name = "?getString@pairNode@@UBEPADPAD0@Z"
		size = 42
	strings:
		$1 = { 55 8B EC 56 FF 75 0C 8B F1 FF 75 08 8B 4E 04 8B 01 FF 50 08 3B 45 0C 73 0C 8B 4E 08 FF 75 0C 50 8B 11 FF 52 08 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_137_112_0 {
	meta:
		name = "?getString@pcharNode@@UBEPADPAD0@Z"
		size = 27
		refs = "0010 ?getStringHelper@@YAPADPAD00H@Z"
	strings:
		$1 = { 55 8B EC FF 71 08 FF 71 04 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C2 08 00 }
	condition:
		$1
}

rule file_137_113_0 {
	meta:
		name = "?getStringEncoding@UnDecorator@@CA?AVDName@@PADH@Z"
		size = 163
		refs = "000d ??0DName@@QAE@PBD@Z 0013 ?gName@UnDecorator@@0PBDB 003f ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 0098 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 8D 4D F8 FF 75 0C E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8A 01 41 89 0D ?? ?? ?? ?? 3C 40 75 6E 8A 01 41 89 0D ?? ?? ?? ?? 3C 5F 75 61 8D 45 F0 41 6A 00 50 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 C4 10 8A 08 84 C9 74 2C 80 F9 40 74 0C 40 A3 ?? ?? ?? ?? 8A 08 84 C9 75 EF 80 38 00 74 16 8B 4D F8 40 A3 ?? ?? ?? ?? 8B 45 08 89 08 8B 4D FC 89 48 04 EB 17 48 A3 ?? ?? ?? ?? 6A 01 EB 02 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_114_0 {
	meta:
		name = "?getStringHelper@@YAPADPAD00H@Z"
		size = 53
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 55 08 2B C2 8B 4D 14 3B C8 7E 02 8B C8 85 C9 74 18 53 56 57 8B 7D 10 8B F2 2B FA 8B D9 8A 04 37 88 06 46 4B 75 F7 5F 5E 5B 8D 04 0A 5D C3 }
	condition:
		$1
}

rule file_137_115_0 {
	meta:
		name = "?getSymbolName@UnDecorator@@CA?AVDName@@XZ"
		size = 72
		refs = "0004 ?gName@UnDecorator@@0PBDB 0019 ?getTemplateName@UnDecorator@@CA?AVDName@@_N@Z 002e ?getOperatorName@UnDecorator@@CA?AVDName@@_NPA_N@Z 003c ?getZName@UnDecorator@@CA?AVDName@@_N0@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 80 38 3F 75 27 40 80 38 24 75 0E 6A 01 FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 22 6A 00 6A 00 FF 75 08 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0C 6A 00 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_137_116_0 {
	meta:
		name = "?getTemplateArgumentList@UnDecorator@@CA?AVDName@@XZ"
		size = 633
		refs = "0007 ___security_cookie 002a ?fGetTemplateArgumentList@UnDecorator@@0_NA 003a ?gName@UnDecorator@@0PBDB 0076 ?pTemplateArgList@UnDecorator@@0PAVReplicator@@A 007c ??AReplicator@@QBE?AVDName@@H@Z 0084 ??YDName@@QAEAAV0@ABV0@@Z 00c5 ??_C@_04GKJNKENE@void?$AA@ 00cd ??4DName@@QAEAAV0@PBD@Z 00fc ?getTemplateConstant@UnDecorator@@CA?AVDName@@XZ 0112 ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 0118 ?disableFlags@UnDecorator@@0KA 012d ?getString@DName@@QBEPADPADH@Z 0136 _atol 013d ?m_pGetParameter@UnDecorator@@0P6APADJ@ZA 0156 ??_C@_0BE@EODMJLIF@?$GAtemplate?9parameter?$AA@ 015e ??0DName@@QAE@PBD@Z 0165 ??HDName@@QBE?AV0@ABV0@@Z 0176 ??_C@_01GEODFPGF@?8?$AA@ 017e ??YDName@@QAEAAV0@PBD@Z 01e1 ?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 0214 ??YReplicator@@QAEAAV0@ABVDName@@@Z 022d ??YDName@@QAEAAV0@D@Z 0241 ??_C@_03KHICJKCI@?4?4?4?$AA@ 0271 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 78 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 B3 01 88 5D EB 83 26 00 C6 46 04 00 81 66 04 FF 00 FF FF 88 1D ?? ?? ?? ?? 80 7E 04 00 0F 85 28 02 00 00 8B 0D ?? ?? ?? ?? 57 8A 01 84 C0 0F 84 16 02 00 00 3C 40 0F 84 0E 02 00 00 32 FF 84 DB 74 05 88 7D EB EB 02 B7 01 0F BE D0 83 EA 30 83 FA 09 77 24 41 8D 45 90 52 89 0D ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? E9 BF 01 00 00 83 65 E0 00 32 DB 81 65 E4 00 00 FF FF 8B F9 3C 24 75 17 38 41 01 75 12 8A 41 02 3C 57 75 2A FE C3 83 C1 03 89 0D ?? ?? ?? ?? 8A 01 3C 58 75 2B 41 89 0D ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? E9 1E 01 00 00 3C 56 75 DD 83 C1 03 89 0D ?? ?? ?? ?? E9 6A 01 00 00 3C 24 75 19 41 38 01 74 14 8D 45 88 89 0D ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E9 E1 00 00 00 3C 3F 0F 85 C0 00 00 00 8D 45 C0 50 E8 ?? ?? ?? ?? F7 05 ?? ?? ?? ?? 00 40 00 00 59 74 6A 6A 10 8D 45 EC 50 8D 4D C0 E8 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 59 59 85 C0 74 06 50 E9 7C FF FF FF 8D 45 C0 50 8D 45 B8 50 68 ?? ?? ?? ?? 8D 4D A8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 B8 8D 4D D0 89 45 D0 8B 45 BC 68 ?? ?? ?? ?? 89 45 D4 E8 ?? ?? ?? ?? 8B 45 D0 89 45 E0 8B 45 D4 EB 64 8D 45 C0 50 8D 45 B0 50 68 ?? ?? ?? ?? 8D 4D A0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 B0 8D 4D D8 89 45 D8 8B 45 B4 68 ?? ?? ?? ?? 89 45 DC E8 ?? ?? ?? ?? 8B 45 D8 89 45 E0 8B 45 DC EB 24 83 65 C8 00 8D 45 C8 81 65 CC 00 00 FF FF 50 8D 45 98 50 E8 ?? ?? ?? ?? 59 59 8B C8 8B 01 89 45 E0 8B 41 04 89 45 E4 8B 0D ?? ?? ?? ?? 8B C1 2B C7 83 F8 01 7E 1B A1 ?? ?? ?? ?? 83 38 09 74 11 8D 4D E0 51 8B C8 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 83 7D E0 00 74 2E 84 FF 74 09 6A 2C 8B CE E8 ?? ?? ?? ?? 8D 45 E0 8B CE 50 E8 ?? ?? ?? ?? 84 DB 74 0C 68 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 80 7E 04 00 8A 5D EB 0F 84 E0 FD FF FF 5F 8B 4D FC 8B C6 5E 33 CD C6 05 ?? ?? ?? ?? 00 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_117_0 {
	meta:
		name = "?getTemplateConstant@UnDecorator@@CA?AVDName@@XZ"
		size = 768
		refs = "000a ___security_cookie 0014 ?gName@UnDecorator@@0PBDB 0062 ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 0068 ?disableFlags@UnDecorator@@0KA 0081 ?getString@DName@@QBEPADPADH@Z 008a _atol 0091 ?m_pGetParameter@UnDecorator@@0P6APADJ@ZA 00ea ??0DName@@QAE@W4DNameStatus@@@Z 0129 ??0DName@@QAE@PBD@Z 0130 ??HDName@@QBE?AV0@D@Z 0137 ??HDName@@QBE?AV0@ABV0@@Z 014c ??_C@_04HIBGFPH@NULL?$AA@ 0164 ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 016c ??_C@_01HNPIGOCE@?$CG?$AA@ 01cf ?getZName@UnDecorator@@CA?AVDName@@_N0@Z 021c ??_C@_0BE@EODMJLIF@?$GAtemplate?9parameter?$AA@ 022d ??_C@_01GEODFPGF@?8?$AA@ 0239 ??HDName@@QBE?AV0@PBD@Z 0243 ??_C@_0BN@IBLMMFAP@?$GAnon?9type?9template?9parameter?$AA@ 024f ??0DName@@QAE@D@Z 026d ??YDName@@QAEAAV0@ABV0@@Z 0277 ??YDName@@QAEAAV0@D@Z 02f8 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC C8 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC A1 ?? ?? ?? ?? 53 56 8B 75 08 8A 18 40 57 0F BE FB A3 ?? ?? ?? ?? 83 FF 45 0F 8F 6C 01 00 00 0F 84 5E 01 00 00 83 EF 00 0F 84 48 01 00 00 83 EF 30 0F 84 33 01 00 00 4F 0F 84 EF 00 00 00 4F 74 51 83 EF 12 0F 85 88 00 00 00 8D 45 80 50 E8 ?? ?? ?? ?? F7 05 ?? ?? ?? ?? 00 40 00 00 59 0F 84 91 01 00 00 6A 10 8D 45 EC 50 8D 4D 80 E8 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 59 59 85 C0 0F 84 69 01 00 00 50 E9 AB 00 00 00 8D 45 80 50 E8 ?? ?? ?? ?? 8D 85 78 FF FF FF 50 E8 ?? ?? ?? ?? 80 7D 84 01 59 59 0F 8F C9 00 00 00 80 BD 7C FF FF FF 01 0F 8F BC 00 00 00 6A 64 8D 45 89 50 8D 4D 80 E8 ?? ?? ?? ?? 85 C0 75 0E 6A 02 8B CE E8 ?? ?? ?? ?? E9 FA 01 00 00 8A 45 89 88 45 88 3C 2D 75 0C 8A 45 8A 88 45 89 C6 45 8A 2E EB 04 C6 45 89 2E 8D 85 78 FF FF FF 50 56 6A 65 8D 85 60 FF FF FF 50 8D 45 88 50 8D 8D 40 FF FF FF E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E9 AD 01 00 00 80 38 40 75 17 40 A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? E9 91 01 00 00 8D 85 38 FF FF FF 50 E8 ?? ?? ?? ?? 59 50 56 68 ?? ?? ?? ?? 8D 8D 70 FF FF FF E8 ?? ?? ?? ?? EB B7 56 E8 ?? ?? ?? ?? 59 E9 64 01 00 00 48 A3 ?? ?? ?? ?? 6A 01 E9 51 FF FF FF 56 E8 ?? ?? ?? ?? EB E5 83 FF 4A 0F 8E A2 00 00 00 83 FF 51 0F 84 AD FE FF FF 83 FF 52 74 0E 83 FF 53 74 3B 83 FF 54 0F 85 22 FF FF FF 6A 00 8D 85 78 FF FF FF 6A 00 50 E8 ?? ?? ?? ?? 8D 45 80 50 E8 ?? ?? ?? ?? 8B 85 78 FF FF FF 83 C4 10 89 06 8B 85 7C FF FF FF 89 46 04 E9 F8 00 00 00 83 26 00 C6 46 04 00 81 66 04 FF 00 FF FF E9 E5 00 00 00 8D 45 80 8D 4D F4 50 8D 85 78 FF FF FF 50 80 FB 44 75 27 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 8D 8D 78 FF FF FF E8 ?? ?? ?? ?? E9 AB 00 00 00 68 ?? ?? ?? ?? EB D7 6A 7B 8D 4D 80 E8 ?? ?? ?? ?? 80 EB 48 80 FB 02 77 20 8D 85 50 FF FF FF 50 E8 ?? ?? ?? ?? 59 50 8D 4D 80 E8 ?? ?? ?? ?? 6A 2C 8D 4D 80 E8 ?? ?? ?? ?? 83 EF 46 74 2C 4F 74 09 4F 74 46 4F 74 23 4F 75 56 8D 85 68 FF FF FF 50 E8 ?? ?? ?? ?? 59 50 8D 4D 80 E8 ?? ?? ?? ?? 6A 2C 8D 4D 80 E8 ?? ?? ?? ?? 8D 85 58 FF FF FF 50 E8 ?? ?? ?? ?? 59 50 8D 4D 80 E8 ?? ?? ?? ?? 6A 2C 8D 4D 80 E8 ?? ?? ?? ?? 8D 85 48 FF FF FF 50 E8 ?? ?? ?? ?? 59 50 8D 4D 80 E8 ?? ?? ?? ?? 6A 7D 56 8D 4D 80 E8 ?? ?? ?? ?? 8B 4D FC 8B C6 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_118_0 {
	meta:
		name = "?getTemplateName@UnDecorator@@CA?AVDName@@_N@Z"
		size = 346
		refs = "0004 ?gName@UnDecorator@@0PBDB 0023 ?pTemplateArgList@UnDecorator@@0PAVReplicator@@A 0042 ?pArgList@UnDecorator@@0PAVReplicator@@A 0055 ?pZNameList@UnDecorator@@0PAVReplicator@@A 0089 ?getOperatorName@UnDecorator@@CA?AVDName@@_NPA_N@Z 009b ?getZName@UnDecorator@@CA?AVDName@@_N0@Z 00b3 ?fExplicitTemplateParams@UnDecorator@@0_NA 00c1 ?getTemplateArgumentList@UnDecorator@@CA?AVDName@@XZ 00d1 ??0DName@@QAE@D@Z 00d8 ??HDName@@QBE?AV0@ABV0@@Z 00e4 ??YDName@@QAEAAV0@ABV0@@Z 00fe ??YDName@@QAEAAV0@D@Z 014f ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 81 EC AC 00 00 00 80 38 3F 0F 85 32 01 00 00 80 78 01 24 0F 85 28 01 00 00 8B 0D ?? ?? ?? ?? 83 C0 02 83 4D AC FF 83 4D 80 FF 83 8D 54 FF FF FF FF 53 89 4D F0 32 DB 56 8B 35 ?? ?? ?? ?? 8D 4D AC 89 0D ?? ?? ?? ?? 8D 4D 80 57 8B 3D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 8D 8D 54 FF FF FF A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 80 38 3F 88 5D FF 75 1A 40 A3 ?? ?? ?? ?? 8D 45 FF 50 8D 45 E8 6A 01 50 E8 ?? ?? ?? ?? 8A 5D FF EB 0D 6A 01 8D 45 E8 6A 01 50 E8 ?? ?? ?? ?? 8B 08 83 C4 0C 8B 40 04 89 45 F8 89 4D F4 85 C9 75 07 C6 05 ?? ?? ?? ?? 01 84 DB 75 69 8D 45 E0 50 E8 ?? ?? ?? ?? 59 50 8D 45 E8 50 6A 3C 8D 4D D8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8D 45 E8 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 4D F4 85 C9 74 13 8B 01 FF 50 04 3C 3E 75 0A 6A 20 8D 4D F4 E8 ?? ?? ?? ?? 6A 3E 8D 4D F4 E8 ?? ?? ?? ?? 80 7D 0C 00 74 10 A1 ?? ?? ?? ?? 80 38 00 74 06 40 A3 ?? ?? ?? ?? 8B 4D F4 8B 45 F0 A3 ?? ?? ?? ?? 8B 45 08 89 3D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 5F 89 08 8B 4D F8 5E 89 48 04 5B EB 0D 8B 4D 08 6A 02 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_119_0 {
	meta:
		name = "?getThisType@UnDecorator@@CA?AVDName@@XZ"
		size = 58
		refs = "0020 ??_C@_00CNPNBAHC@?$AA@ 002c ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@PBD0H@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 65 F8 00 B8 00 00 FF FF 21 45 FC 21 45 F4 8D 45 F8 83 65 F0 00 6A 01 50 68 ?? ?? ?? ?? 8D 45 F0 50 FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_120_0 {
	meta:
		name = "?getThrowTypes@UnDecorator@@CA?AVDName@@XZ"
		size = 138
		refs = "0004 ?gName@UnDecorator@@0PBDB 0035 ?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ 0040 ??_C@_07HDJPLPEK@?5throw?$CI?$AA@ 0048 ??0DName@@QAE@PBD@Z 004f ??HDName@@QBE?AV0@ABV0@@Z 0078 ??HDName@@QBE?AV0@W4DNameStatus@@@Z 007f ??HDName@@QBE?AV0@D@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 EC 18 8A 08 84 C9 74 4C 80 F9 5A 75 1A 8B 4D FC 40 A3 ?? ?? ?? ?? 81 E1 00 00 FF FF 8B 45 08 83 20 00 89 48 04 EB 56 8D 45 F0 50 E8 ?? ?? ?? ?? 59 50 8D 45 F8 50 68 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 6A 29 FF 75 08 8D 4D F8 EB 21 6A 29 FF 75 08 8D 45 E8 6A 01 50 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_121_0 {
	meta:
		name = "?getTypeEncoding@UnDecorator@@CAHXZ"
		size = 1264
		refs = "0006 ?gName@UnDecorator@@0PBDB 01e4 ?getTypeEncoding@UnDecorator@@CAHXZ 039d $LN129 04cc $LN15 04d0 $LN14 04d4 $LN13 04d8 $LN12 04dc $LN10 04e0 $LN11 04e4 $LN9 04e8 $LN8 04ec $LN7"
	strings:
		$1 = { 55 8B EC 51 8B 15 ?? ?? ?? ?? 53 56 57 BE 00 40 00 00 33 C9 80 3A 5F 75 09 42 8B CE 89 15 ?? ?? ?? ?? 8A 02 3C 41 7C 08 3C 5A 0F 8E 88 00 00 00 3C 24 0F 85 34 03 00 00 42 C6 45 FF 00 89 15 ?? ?? ?? ?? 0F BE 02 83 F8 42 0F 8F EB 01 00 00 0F 84 DA 01 00 00 85 C0 0F 84 C7 01 00 00 83 F8 24 0F 85 96 01 00 00 80 7A 01 50 75 01 42 42 89 15 ?? ?? ?? ?? 0F BE 02 83 F8 4A 7F 18 0F 84 43 01 00 00 83 E8 00 0F 84 30 01 00 00 83 E8 46 74 1C 48 48 EB 16 83 F8 4C 7C 7A 83 F8 4D 7E 0E 83 F8 4F 0F 8E 1E 01 00 00 83 F8 51 75 67 42 89 15 ?? ?? ?? ?? E9 5A FF FF FF 0F BE 1A B8 00 80 00 00 83 EB 41 0B C8 42 89 15 ?? ?? ?? ?? F6 C3 01 74 08 81 C9 00 20 00 00 EB 06 81 E1 FF DF FF FF 83 FB 18 0F 8D D9 03 00 00 BE FF EF FF FF BF 00 08 00 00 85 C8 74 06 23 CE 0B CF EB 06 81 E1 FF 9F FF FF 8B D3 83 E2 18 74 45 83 FA 08 74 23 83 FA 10 74 0A B8 FF FF 00 00 E9 A6 03 00 00 85 C8 74 08 81 E1 3F FF FF FF EB 38 81 E1 FF E7 FF FF EB 30 85 C8 74 0B 83 E1 BF 81 C9 80 00 00 00 EB 21 81 E1 FF F7 FF FF 81 C9 00 10 00 00 EB 13 85 C8 74 0B 81 E1 7F FF FF FF 83 C9 40 EB 04 23 CE 0B CF 83 E3 06 83 EB 00 0F 84 54 03 00 00 4B 4B 74 2A 4B 4B 74 15 4B 4B 75 9A 81 E1 FF FC FF FF 81 C9 00 04 00 00 E9 37 03 00 00 81 E1 FF F9 FF FF 81 C9 00 01 00 00 E9 26 03 00 00 85 C8 74 11 81 E1 FF FA FF FF 81 C9 00 02 00 00 E9 11 03 00 00 81 E1 FF 9F FF FF E9 06 03 00 00 B8 FE FF 00 00 E9 FE 02 00 00 42 89 15 ?? ?? ?? ?? 8A 02 3C 30 7C 20 3C 39 7F 1C 0F BE C0 83 C0 D1 03 C2 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0D 00 00 01 00 E9 D1 02 00 00 B9 FF FF 00 00 E9 64 01 00 00 83 F8 2F 0F 8E 0E FF FF FF 83 F8 35 7E 6F 83 F8 41 0F 85 00 FF FF FF 81 E1 FF F4 FF FF 81 C9 00 90 00 00 E9 3C 01 00 00 B9 FE FF 00 00 4A E9 31 01 00 00 81 C9 00 98 00 00 E9 26 01 00 00 83 E8 43 0F 84 17 01 00 00 48 0F 84 02 01 00 00 48 0F 84 ED 00 00 00 83 E8 0D 0F 85 B9 FE FF FF 42 C6 45 FF 01 89 15 ?? ?? ?? ?? 8A 1A 80 FB 30 0F 8C BD 00 00 00 80 FB 35 0F 8F B4 00 00 00 0F BE 1A B8 00 80 00 00 0B C8 83 EB 30 BE FF EF FF FF BF 00 08 00 00 85 C8 74 06 23 CE 0B CF EB 06 81 E1 FF 9F FF FF 80 7D FF 00 74 0E 81 E1 FF FE FF FF 81 C9 00 06 00 00 EB 0C 81 E1 FF FD FF FF 81 C9 00 05 00 00 F6 C3 01 74 08 81 C9 00 20 00 00 EB 06 81 E1 FF DF FF FF 83 E3 06 83 EB 00 74 3D 4B 4B 74 1C 4B 4B 0F 85 2C FE FF FF 85 C8 74 08 81 E1 3F FF FF FF EB 6D 81 E1 FF E7 FF FF EB 65 85 C8 74 0B 83 E1 BF 81 C9 80 00 00 00 EB 56 81 E1 FF F7 FF FF 81 C9 00 10 00 00 EB 48 85 C8 74 0B 81 E1 7F FF FF FF 83 C9 40 EB 39 23 CE 0B CF EB 33 33 C0 84 DB 0F 94 C0 05 FE FF 00 00 E9 85 01 00 00 81 E1 FF F6 FF FF 81 C9 00 92 00 00 EB 14 81 E1 FF F5 FF FF 81 C9 00 91 00 00 EB 06 81 C9 00 7C 00 00 42 89 15 ?? ?? ?? ?? E9 55 01 00 00 8A 02 3C 30 0F 8C 2C 01 00 00 3C 38 0F 8F 24 01 00 00 0F BE C0 42 83 C0 D0 89 15 ?? ?? ?? ?? 81 E1 FF 7F FF FF 83 F8 08 0F 87 79 FD FF FF FF 24 85 ?? ?? ?? ?? B8 00 80 00 00 85 C8 74 0E 81 E1 FF FA FF FF 81 C9 00 02 00 00 EB 06 81 E1 FF 9F FF FF 85 C8 74 0E 81 E1 7F FF FF FF 83 C9 40 E9 F1 00 00 00 81 E1 FF EF FF FF 81 C9 00 08 00 00 E9 E0 00 00 00 B8 00 80 00 00 85 C8 74 0E 81 E1 FF FA FF FF 81 C9 00 02 00 00 EB 06 81 E1 FF 9F FF FF 85 C8 74 0E 83 E1 BF 81 C9 80 00 00 00 E9 B1 00 00 00 81 E1 FF F7 FF FF 81 C9 00 10 00 00 E9 A0 00 00 00 B8 00 80 00 00 85 C8 74 0E 81 E1 FF FA FF FF 81 C9 00 02 00 00 EB 06 81 E1 FF 9F FF FF 85 C8 74 08 81 E1 3F FF FF FF EB 77 81 E1 FF E7 FF FF EB 6F 81 E1 FF DF FF FF 0B CE EB 65 81 E1 FF E3 FF FF 81 C9 00 60 00 00 EB 57 81 E1 FF BF FF FF 81 C9 00 20 00 00 EB 49 81 E1 FF EB FF FF 81 C9 00 68 00 00 EB 3B 81 E1 FF F3 FF FF 81 C9 00 70 00 00 EB 2D 81 E1 FF FB FF FF 81 C9 00 78 00 00 EB 1F 3C 39 75 0E 42 B9 FD FF 00 00 89 15 ?? ?? ?? ?? EB 0D 33 C9 84 C0 0F 95 C1 81 C1 FE FF 00 00 8B C1 5F 5E 5B 8B E5 5D C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_137_122_0 {
	meta:
		name = "?getVCallThunkType@UnDecorator@@CA?AVDName@@XZ"
		size = 59
		refs = "0004 ?gName@UnDecorator@@0PBDB 001c ??_C@_06EEGAIFAK@?$HLflat?$HN?$AA@ 0026 ??0DName@@QAE@PBD@Z 0032 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 8A 08 84 C9 74 1E 80 F9 41 8B 4D 08 74 04 6A 02 EB 17 40 68 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0A 8B 4D 08 6A 01 E8 ?? ?? ?? ?? 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_137_123_0 {
	meta:
		name = "?getVbTableType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 21
		refs = "000a ?getVfTableType@UnDecorator@@CA?AVDName@@ABV2@@Z"
	strings:
		$1 = { 55 8B EC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 59 59 5D C3 }
	condition:
		$1
}

rule file_137_124_0 {
	meta:
		name = "?getVdispMapType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 86
		refs = "000d ??_C@_05JIBOFOHK@?$HLfor?5?$AA@ 001e ??YDName@@QAEAAV0@PBD@Z 0027 ?getScope@UnDecorator@@CA?AVDName@@XZ 0030 ??YDName@@QAEAAV0@ABV0@@Z 0039 ??YDName@@QAEAAV0@D@Z 003f ?gName@UnDecorator@@0PBDB"
	strings:
		$1 = { 55 8B EC 51 51 8B 4D 0C 56 8B 75 08 68 ?? ?? ?? ?? 8B 01 89 06 8B 41 04 8B CE 89 46 04 E8 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 59 50 8B CE E8 ?? ?? ?? ?? 6A 7D 8B CE E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 80 39 40 75 07 41 89 0D ?? ?? ?? ?? 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_125_0 {
	meta:
		name = "?getVfTableType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 357
		refs = "0026 ?gName@UnDecorator@@0PBDB 0038 ?getDataIndirectType@UnDecorator@@CA?AVDName@@XZ 004f ??YDName@@QAEAAV0@D@Z 005c ??HDName@@QBE?AV0@ABV0@@Z 0083 ??_C@_05JIBOFOHK@?$HLfor?5?$AA@ 008a ??YDName@@QAEAAV0@PBD@Z 00ac ?getScope@UnDecorator@@CA?AVDName@@XZ 00bc ??0DName@@QAE@D@Z 00e4 ??YDName@@QAEAAV0@ABV0@@Z 0103 ??_C@_02MDINNEEG@s?5?$AA@ 011a ??YDName@@QAEAAV0@W4DNameStatus@@@Z 0147 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 83 EC 20 8B 01 53 56 8B 75 08 33 DB 43 89 06 8B 41 04 8A C8 89 46 04 3A CB 0F 8F 38 01 00 00 A1 ?? ?? ?? ?? 80 38 00 0F 84 06 01 00 00 8D 45 F0 50 E8 ?? ?? ?? ?? 8B 45 F0 59 89 45 F8 8D 4D F8 8B 45 F4 6A 20 89 45 FC E8 ?? ?? ?? ?? 56 8D 45 E8 50 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 8B 01 89 06 8B 41 04 89 46 04 3A C3 0F 8F E9 00 00 00 A1 ?? ?? ?? ?? 80 38 40 0F 84 AF 00 00 00 68 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 38 5E 04 0F 8F 90 00 00 00 8A 08 84 C9 74 6A 80 F9 40 74 65 8D 45 E8 50 E8 ?? ?? ?? ?? 59 50 8D 45 F0 50 6A 60 8D 4D E0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 F0 8D 4D F8 89 45 F8 8B 45 F4 6A 27 89 45 FC E8 ?? ?? ?? ?? 8D 45 F8 8B CE 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 40 75 06 40 A3 ?? ?? ?? ?? 38 5E 04 7F 2F 80 38 40 74 91 68 ?? ?? ?? ?? E9 7B FF FF FF 38 5E 04 7F 1B 80 38 00 75 08 53 8B CE E8 ?? ?? ?? ?? 6A 7D 8B CE E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 40 75 2C 40 A3 ?? ?? ?? ?? EB 24 3A CB 7F 20 56 8D 45 F0 50 53 8D 4D E0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4D F0 89 0E 8B 4D F4 89 4E 04 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_126_0 {
	meta:
		name = "?getZName@UnDecorator@@CA?AVDName@@_N0@Z"
		size = 554
		refs = "0007 ___security_cookie 0014 ?gName@UnDecorator@@0PBDB 002b ?pZNameList@UnDecorator@@0PAVReplicator@@A 0039 ??AReplicator@@QBE?AVDName@@H@Z 0059 ?getTemplateName@UnDecorator@@CA?AVDName@@_N@Z 0095 ??4DName@@QAEAAV0@W4DNameStatus@@@Z 009f ??_C@_0BE@JAEOCHPE@template?9parameter?9?$AA@ 00ab ?und_strncmp@@YAIPBD0I@Z 00bc ??_C@_0O@KHGCOMHP@generic?9type?9?$AA@ 00e5 ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 00eb ?disableFlags@UnDecorator@@0KA 0100 ?getString@DName@@QBEPADPADH@Z 0109 _atol 0110 ?m_pGetParameter@UnDecorator@@0P6APADJ@ZA 011f ??4DName@@QAEAAV0@PBD@Z 0129 ??_C@_01NLNLIGKH@?$GA?$AA@ 0141 ??0DName@@QAE@PBD@Z 0148 ??HDName@@QBE?AV0@ABV0@@Z 0159 ??_C@_01GEODFPGF@?8?$AA@ 0161 ??YDName@@QAEAAV0@PBD@Z 01b2 ??YDName@@QAEAAV0@ABV0@@Z 01e3 ??0DName@@QAE@AAPBDD@Z 0208 ??YReplicator@@QAEAAV0@ABVDName@@@Z 0222 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 3C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 35 ?? ?? ?? ?? 57 8B 7D 08 8A 1E 0F BE C3 83 E8 30 83 F8 09 77 19 8B 0D ?? ?? ?? ?? 46 50 57 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 D5 01 00 00 83 65 E4 00 81 65 E8 00 00 FF FF 80 FB 3F 75 4C 8D 45 CC 6A 00 50 E8 ?? ?? ?? ?? 59 59 8B 08 8B 40 04 89 4D E4 8B 0D ?? ?? ?? ?? 89 45 E8 8A 01 41 89 0D ?? ?? ?? ?? 3C 40 0F 84 71 01 00 00 49 33 C0 89 0D ?? ?? ?? ?? 38 01 8D 4D E4 0F 95 C0 40 50 E8 ?? ?? ?? ?? E9 54 01 00 00 B8 ?? ?? ?? ?? 6A 13 50 56 89 45 D8 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 05 83 C6 13 EB 1F B8 ?? ?? ?? ?? 6A 0D 50 56 89 45 D8 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 E1 00 00 00 83 C6 0D 8D 45 DC 89 35 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? F7 05 ?? ?? ?? ?? 00 40 00 00 59 74 74 6A 10 8D 45 EC 50 8D 4D DC E8 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 59 59 8D 4D E4 85 C0 74 0B 50 E8 ?? ?? ?? ?? E9 CA 00 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 DC 50 8D 45 CC 50 FF 75 D8 8D 4D C4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 CC 8D 4D D4 89 45 D4 8B 45 D0 68 ?? ?? ?? ?? 89 45 D8 E8 ?? ?? ?? ?? 8D 45 D4 EB 43 68 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 8D 45 DC 50 8D 45 CC 50 FF 75 D8 8D 4D C4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 CC 8D 4D DC 89 45 DC 8B 45 D0 68 ?? ?? ?? ?? 89 45 E0 E8 ?? ?? ?? ?? 8D 45 DC 50 8D 4D E4 E8 ?? ?? ?? ?? EB 3A 80 7D 10 00 74 1A 80 FB 40 75 15 8B 45 C8 83 65 E4 00 25 00 00 FF FF 46 89 35 ?? ?? ?? ?? EB 17 6A 40 68 ?? ?? ?? ?? 8D 4D C4 E8 ?? ?? ?? ?? 8B 08 8B 40 04 89 4D E4 89 45 E8 80 7D 0C 00 74 14 8B 0D ?? ?? ?? ?? 83 39 09 74 09 8D 45 E4 50 E8 ?? ?? ?? ?? 8B 45 E4 89 07 8B 45 E8 89 47 04 8B 4D FC 8B C7 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_135_0 {
	meta:
		name = "?isUDC@DName@@QBEHXZ"
		size = 17
	strings:
		$1 = { 33 C0 39 01 74 0A F7 41 04 00 02 00 00 74 01 40 C3 }
	condition:
		$1
}

rule file_137_136_0 {
	meta:
		name = "?isUDTThunk@DName@@QBEHXZ"
		size = 17
	strings:
		$1 = { 33 C0 39 01 74 0A F7 41 04 00 04 00 00 74 01 40 C3 }
	condition:
		$1
}

rule file_137_142_0 {
	meta:
		name = "?length@pDNameNode@@UBEHXZ"
		size = 20
	strings:
		$1 = { 8B 49 04 85 C9 74 0A 8B 09 85 C9 74 04 8B 01 FF 20 33 C0 C3 }
	condition:
		$1
}

rule file_137_143_0 {
	meta:
		name = "?length@pairNode@@UBEHXZ"
		size = 41
	strings:
		$1 = { 53 8B D9 83 7B 0C 00 7D 1B 8B 4B 08 56 57 8B 7B 04 8B 01 FF 10 8B 17 8B CF 8B F0 FF 12 03 F0 5F 89 73 0C 5E 8B 43 0C 5B C3 }
	condition:
		$1
}

rule file_137_145_0 {
	meta:
		name = "?make@DNameStatusNode@@SAPAV1@W4DNameStatus@@@Z"
		size = 134
		refs = "0004 ??_B?1??make@DNameStatusNode@@SAPAV1@W4DNameStatus@@@Z@51 0010 ?nodes@?1??make@DNameStatusNode@@SAPAV2@W4DNameStatus@@@Z@4PAV2@A 0033 ??_7DNameStatusNode@@6B@"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? A8 01 75 61 33 C9 C7 05 ?? ?? ?? ?? 04 00 00 00 41 C7 05 ?? ?? ?? ?? 02 00 00 00 0B C1 89 0D ?? ?? ?? ?? 33 D2 A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 03 00 00 00 89 15 ?? ?? ?? ?? 8B 45 08 83 F8 03 77 0A 6B C0 0C 05 ?? ?? ?? ?? 5D C3 B8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_137_154_0 {
	meta:
		name = "?und_memcpy@@YAXPADPBDI@Z"
		size = 31
	strings:
		$1 = { 55 8B EC 8B 55 10 85 D2 74 13 8B 4D 08 56 8B 75 0C 2B F1 8A 04 0E 88 01 41 4A 75 F7 5E 5D C3 }
	condition:
		$1
}

rule file_137_155_0 {
	meta:
		name = "?und_strlen@@YAIPBD@Z"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 4D 08 33 C0 38 01 74 07 40 41 80 39 00 75 F9 5D C3 }
	condition:
		$1
}

rule file_137_156_0 {
	meta:
		name = "?und_strncmp@@YAIPBD0I@Z"
		size = 47
	strings:
		$1 = { 55 8B EC 8B 45 10 85 C0 75 02 5D C3 8B 4D 0C 8B 55 08 53 48 74 0E 8A 1A 84 DB 74 08 3A 19 75 04 42 41 EB EF 0F B6 02 0F B6 09 2B C1 5B 5D C3 }
	condition:
		$1
}

rule file_137_157_0 {
	meta:
		name = "___unDName"
		size = 163
		refs = "0003 __sehtable$___unDName 0008 __SEH_prolog4 001f __mtinitlocknum 002b __lock 0035 _heap 0068 ??0UnDecorator@@QAE@PADPBDHP6APADJ@ZK@Z 0070 ??BUnDecorator@@QAEPADXZ 007f ?Destructor@_HeapManager@@QAEXXZ 0092 __SEH_epilog4 009d __unlock"
	strings:
		$1 = { 6A 64 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 14 85 F6 75 04 33 C0 EB 7A 33 FF 89 7D E4 6A 05 E8 ?? ?? ?? ?? 59 85 C0 74 EB 6A 05 E8 ?? ?? ?? ?? 59 89 7D FC 89 35 ?? ?? ?? ?? 8B 45 18 A3 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 8B 45 1C 0F B7 C0 50 57 FF 75 10 FF 75 0C FF 75 08 8D 4D 8C E8 ?? ?? ?? ?? 8D 4D 8C E8 ?? ?? ?? ?? 8B F0 89 75 E4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 05 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_137_158_0 {
	meta:
		name = "___unDNameEx"
		size = 161
		refs = "0003 __sehtable$___unDNameEx 0008 __SEH_prolog4 001f __mtinitlocknum 002b __lock 0035 _heap 0066 ??0UnDecorator@@QAE@PADPBDHP6APADJ@ZK@Z 006e ??BUnDecorator@@QAEPADXZ 007d ?Destructor@_HeapManager@@QAEXXZ 0090 __SEH_epilog4 009b __unlock"
	strings:
		$1 = { 6A 64 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 14 85 F6 75 04 33 C0 EB 78 33 FF 89 7D E4 6A 05 E8 ?? ?? ?? ?? 59 85 C0 74 EB 6A 05 E8 ?? ?? ?? ?? 59 89 7D FC 89 35 ?? ?? ?? ?? 8B 45 18 A3 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? FF 75 20 FF 75 1C FF 75 10 FF 75 0C FF 75 08 8D 4D 8C E8 ?? ?? ?? ?? 8D 4D 8C E8 ?? ?? ?? ?? 8B F0 89 75 E4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 05 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "__calloc_impl"
		size = 122
		refs = "0018 __errno 003b __crtheap 0041 __imp__HeapAlloc@12 004d __newmode 0056 __callnewh"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 85 F6 74 1B 6A E0 33 D2 58 F7 F6 3B 45 0C 73 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 51 0F AF 75 0C 85 F6 75 01 46 33 C9 83 FE E0 77 15 56 6A 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B C8 85 C9 75 2A 83 3D ?? ?? ?? ?? 00 74 14 56 E8 ?? ?? ?? ?? 59 85 C0 75 D0 8B 45 10 85 C0 74 BC EB B4 8B 45 10 85 C0 74 06 C7 00 0C 00 00 00 8B C1 5E 5D C3 }
	condition:
		$1
}

rule file_140_0_0 {
	meta:
		name = "?__CxxUnhandledExceptionFilter@@YGJPAU_EXCEPTION_POINTERS@@@Z"
		size = 65
		refs = "003c ?terminate@@YAXXZ"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 00 81 38 63 73 6D E0 75 25 83 78 10 03 75 1F 8B 40 14 3D 20 05 93 19 74 1B 3D 21 05 93 19 74 14 3D 22 05 93 19 74 0D 3D 00 40 99 01 74 06 33 C0 5D C2 04 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_141_13_0 {
	meta:
		name = "??0VirtualProcessorRoot@details@Concurrency@@QAE@PAVSchedulerProxy@12@PAUSchedulerNode@12@I@Z"
		size = 71
		refs = "0015 ??_7VirtualProcessorRoot@details@Concurrency@@6B@ 0020 ??0ExecutionResource@details@Concurrency@@QAE@PAVSchedulerProxy@12@PAUSchedulerNode@12@I@Z 002e ?s_currentId@VirtualProcessorRoot@details@Concurrency@@0JA"
	strings:
		$1 = { 55 8B EC 53 56 57 FF 75 10 8B F9 33 DB FF 75 0C FF 75 08 C7 07 ?? ?? ?? ?? 8D 4F 08 89 5F 04 E8 ?? ?? ?? ?? 33 C0 66 89 5F 44 89 5F 4C B9 ?? ?? ?? ?? 40 F0 0F C1 01 40 89 47 48 8B C7 89 7F 24 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule file_141_38_0 {
	meta:
		name = "??_GVirtualProcessorRoot@details@Concurrency@@UAEPAXI@Z"
		size = 39
		refs = "000c ??_7VirtualProcessorRoot@details@Concurrency@@6B@ 0013 ??_7ExecutionResource@details@Concurrency@@6B@ 001b ??3@YAXPAX@Z"
		altNames = "??_GFreeVirtualProcessorRoot@details@Concurrency@@UAEPAXI@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? C7 46 08 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_141_53_0 {
	meta:
		name = "?Remove@VirtualProcessorRoot@details@Concurrency@@UAEXPAUIScheduler@3@@Z"
		size = 103
		refs = "001c ??0invalid_operation@Concurrency@@QAE@XZ 0021 __TI2?AVinvalid_operation@Concurrency@@ 002a ?ResetSubscriptionLevel@VirtualProcessorRoot@details@Concurrency@@QAEXXZ 0033 ?DestroyVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@QAEXPAVVirtualProcessorRoot@23@@Z 0044 ??_C@_0L@HKFDMHB@pScheduler?$AA@ 004d ??0exception@std@@QAE@ABQBD@Z 0054 ??_7invalid_argument@std@@6B@ 0059 __TI3?AVinvalid_argument@std@@ 0062 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 0C 56 8B F1 8B 4D 08 85 C9 74 2E 8B 46 1C 39 48 08 74 0F 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB 36 8B CE E8 ?? ?? ?? ?? 8B 4E 1C 56 E8 ?? ?? ?? ?? 5E 8B E5 5D C2 04 00 8D 45 08 C7 45 08 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? C7 45 F4 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_141_54_0 {
	meta:
		name = "?ResetSubscriptionLevel@VirtualProcessorRoot@details@Concurrency@@QAEXXZ"
		size = 26
		refs = "0012 ?Unsubscribe@VirtualProcessorRoot@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 8D 41 4C 83 CA FF F0 0F C1 10 4A 75 05 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "?_open@@YAHPBDHH@Z"
		size = 45
		refs = "0016 __sopen_helper"
	strings:
		$1 = { 55 8B EC 51 6A 00 8D 45 FC 50 FF 75 10 6A 40 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF EB 03 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_142_2_0 {
	meta:
		name = "?_wopen@@YAHPB_WHH@Z"
		size = 45
		refs = "0016 __wsopen_helper"
	strings:
		$1 = { 55 8B EC 51 6A 00 8D 45 FC 50 FF 75 10 6A 40 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF EB 03 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_142_1_0 {
	meta:
		name = "?_sopen@@YAHPBDHHH@Z"
		size = 46
		refs = "0017 __sopen_helper"
	strings:
		$1 = { 55 8B EC 51 6A 00 8D 45 FC 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF EB 03 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_142_3_0 {
	meta:
		name = "?_wsopen@@YAHPB_WHHH@Z"
		size = 46
		refs = "0017 __wsopen_helper"
	strings:
		$1 = { 55 8B EC 51 6A 00 8D 45 FC 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF EB 03 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "___vdecl_fmodf4"
		size = 89
		refs = "0016 __CIfmod"
	strings:
		$1 = { 83 EC 20 F3 0F 7F 04 24 F3 0F 7F 4C 24 10 D9 04 24 D9 44 24 10 E8 ?? ?? ?? ?? D9 1C 24 D9 44 24 04 D9 44 24 14 E8 ?? ?? ?? ?? D9 5C 24 04 D9 44 24 08 D9 44 24 18 E8 ?? ?? ?? ?? D9 5C 24 08 D9 44 24 0C D9 44 24 1C E8 ?? ?? ?? ?? D9 5C 24 0C F3 0F 6F 04 24 83 C4 20 C3 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "_nearbyint"
		size = 36
		refs = "0008 __dtest 001c __drint"
	strings:
		$1 = { 55 8B EC 8D 45 08 50 E8 ?? ?? ?? ?? DD 45 08 98 59 83 F8 02 76 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_550_0_0 {
	meta:
		name = "_nearbyintl"
		size = 36
		refs = "0008 __ldtest 001c __ldrint"
	strings:
		$1 = { 55 8B EC 8D 45 08 50 E8 ?? ?? ?? ?? DD 45 08 98 59 83 F8 02 76 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_145_4_0 {
	meta:
		name = "__mbsspn_l"
		size = 202
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 _strspn 0041 __errno 004c __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 56 57 FF 75 10 8D 4D EC E8 ?? ?? ?? ?? 8B 5D F0 33 F6 39 73 08 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 8B F0 E9 82 00 00 00 8B 55 08 85 D2 74 07 8B 7D 0C 85 FF 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 62 80 3A 00 8B F2 74 59 8A 07 8B CF 84 C0 74 31 8B 55 F0 8A 19 0F B6 C3 F6 44 10 19 04 74 15 3A 1E 75 08 8A 41 01 3A 46 01 74 13 80 79 01 00 74 0D 41 EB 04 3A 1E 74 06 41 80 39 00 75 D5 8B 5D F0 80 39 00 74 18 0F B6 06 F6 44 18 19 04 74 06 46 80 3E 00 74 08 8A 07 46 80 3E 00 75 AC 8B 55 08 2B F2 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD 5F 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "___libm_sse2_acosf"
		size = 989
		refs = "005a _T_table 0062 _Tbl_addr 009a _PI_BY_2 0191 _NEG_PI 02ea _PI"
	strings:
		$1 = { 66 0F 7E C0 B9 00 00 80 3F 66 0F 6E D9 0F 57 FF B9 00 00 FE FF 66 0F 6E D1 BA FF FF FF 7F 23 D0 81 EA 00 00 80 3D 81 FA D7 B3 DD 01 0F 83 BB 00 00 00 F3 0F 10 C8 F3 0F 59 C0 B9 01 00 00 00 66 0F C4 F9 01 F3 0F 5C D8 F3 0F 51 DB C1 EA 10 81 E2 FE 01 00 00 F3 0F 10 2C 55 ?? ?? ?? ?? 0F 10 24 95 ?? ?? ?? ?? 0F 54 D1 0F 56 D7 66 0F 70 F1 00 66 0F 70 F9 00 F3 0F 58 CA F3 0F 59 F5 F3 0F 5C FA B9 AB AA 2A 3E 66 0F 6E C1 F3 0F 59 F9 F3 0F 10 EE F3 0F 59 D3 0F 10 0D ?? ?? ?? ?? F3 0F 58 EA F3 0F 5E FD F3 0F 5C D6 25 00 00 00 80 66 0F 6E D8 F3 0F 59 C2 F3 0F 59 D2 66 0F 70 DB 00 F3 0F 59 C2 0F 57 E3 0F 5C CC 66 0F 70 E9 55 F3 0F 58 C1 66 0F 70 F1 55 F3 0F 5C EF F3 0F 5C F5 F3 0F 5C FE F3 0F 5C C7 F3 0F 58 C5 C3 81 EA D7 B3 DD 01 81 FA 29 4C 20 00 0F 83 EC 00 00 00 66 0F 70 F8 00 F3 0F 10 C8 66 0F 73 D7 0C 66 0F 73 F7 0C 25 00 00 00 80 F3 0F 5C CF 66 0F 70 F7 00 F3 0F 59 FF F3 0F 58 C6 F3 0F 5C DF F3 0F 59 C1 66 0F 70 E3 00 F3 0F 5C D8 F3 0F 51 DB B9 00 00 01 00 0B C8 66 0F 6E E9 C1 E8 1F F7 D8 0F 54 D3 66 0F C5 D3 01 0F 56 D5 83 E0 08 C1 E8 03 F7 D8 66 0F 6E F8 66 0F 70 FF 00 81 EA 80 3D 00 00 81 E2 FE FF 00 00 F3 0F 59 1C 55 ?? ?? ?? ?? F3 0F 59 F2 F3 0F 59 CA F3 0F 59 D2 F3 0F 5C F3 0F 54 3D ?? ?? ?? ?? F3 0F 58 F1 F3 0F 5C E2 F3 0F 58 DB F3 0F 5C E0 F3 0F 58 DE B9 AB AA 2A BE 66 0F 6E E9 F3 0F 5E E3 0F 10 14 95 ?? ?? ?? ?? F3 0F 59 EE F3 0F 59 F6 F3 0F 59 EE 0F 58 FA F3 0F 58 EF 25 00 00 00 80 66 0F 6E C0 66 0F 70 DF 55 F3 0F 58 EC F3 0F 58 EB 0F 57 C5 C3 81 C2 D7 B3 DD 07 81 FA 00 00 00 06 73 66 B9 AB AA 2A BE 66 0F 6E C9 66 0F 70 E8 00 F3 0F 59 C0 BA 9A 99 99 BD 66 0F 6E D2 F3 0F 59 CD 66 0F 70 E5 00 F3 0F 59 D5 F3 0F 10 35 ?? ?? ?? ?? F3 0F 10 3D ?? ?? ?? ?? 66 0F 70 D8 00 F3 0F 59 C0 F3 0F 59 CB F3 0F 5C E7 F3 0F 59 C2 F3 0F 58 FC F3 0F 58 CE F3 0F 5C EF F3 0F 58 C1 F3 0F 5C C5 F3 0F 5C C4 C3 81 EA 00 00 FE 07 81 FA 00 00 02 00 0F 83 DD 00 00 00 B9 FF FF FF 7F 66 0F 6E F9 0F 54 F8 BA 00 00 00 3F 66 0F 6E E2 B9 9A 99 99 BD 66 0F 6E C9 F3 0F 59 FC BA AB AA 2A BE 66 0F 6E D2 F3 0F 5C E7 BA 6E DB 36 BD 66 0F 6E DA 66 0F 70 FC 00 F3 0F 51 E4 F3 0F 59 CF 66 0F 70 EF 00 25 00 00 00 80 C1 E8 1F F7 D8 66 0F 6E C0 F3 0F 59 FF F3 0F 58 D1 B9 00 F0 FF FF 66 0F 6E C9 F3 0F 59 DF 66 0F 70 C0 00 F3 0F 58 D3 0F 54 05 ?? ?? ?? ?? F3 0F 59 D5 0F 54 CC 66 0F 70 DC 00 F3 0F 5C E1 F3 0F 58 DB F3 0F 59 C9 F3 0F 5C DC F3 0F 5C E9 F3 0F 59 E3 66 0F 70 DB 55 F3 0F 5C EC F3 0F 5E EB F3 0F 58 DB F3 0F 59 D3 F3 0F 58 D0 25 00 00 00 80 35 00 00 00 80 66 0F 6E F0 66 0F 70 C0 55 F3 0F 5C D5 F3 0F 5C D3 F3 0F 58 C2 0F 57 C6 C3 81 C2 00 00 7E 3F 81 FA 00 00 80 37 72 21 81 FA 00 00 80 3F 74 50 81 FA 00 00 80 7F 77 40 BA 00 00 80 7F 66 0F 6E CA 0F 57 C0 F3 0F 59 C1 C3 66 0F 70 C8 00 F3 0F 10 15 ?? ?? ?? ?? 66 0F 70 D8 00 F3 0F 10 05 ?? ?? ?? ?? F3 0F 5C CA F3 0F 58 D1 F3 0F 5C D3 F3 0F 58 C2 F3 0F 5C C1 C3 0F 57 FF F3 0F 58 C7 C3 25 00 00 00 80 C1 E8 1F F7 D8 66 0F 6E C0 F3 0F 10 15 ?? ?? ?? ?? F3 0F 10 0D ?? ?? ?? ?? 0F 54 D0 0F 54 C1 F3 0F 58 C2 C3 }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "__ungetc_nolock"
		size = 224
		refs = "0014 __fileno 001c ___badioinfo 0037 ___pioinfo 006b __errno 0076 __invalid_parameter_noinfo 00a2 __getbuf"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 0C 57 83 CF FF F6 46 0C 40 75 6F 56 E8 ?? ?? ?? ?? 59 8B C8 BB ?? ?? ?? ?? 3B CF 74 19 83 F9 FE 74 14 8B D1 C1 F8 05 83 E2 1F C1 E2 06 03 14 85 ?? ?? ?? ?? EB 02 8B D3 F6 42 24 7F 75 25 3B CF 74 19 83 F9 FE 74 14 8B C1 83 E1 1F C1 F8 05 C1 E1 06 03 0C 85 ?? ?? ?? ?? EB 02 8B CB F6 41 24 80 74 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B C7 5F 5E 5B 5D C3 8B 5D 08 3B DF 74 F2 F6 46 0C 01 75 0C F6 46 0C 80 74 E6 F6 46 0C 02 75 E0 83 7E 08 00 75 07 56 E8 ?? ?? ?? ?? 59 8B 06 3B 46 08 75 09 83 7E 04 00 75 C6 40 89 06 FF 0E F6 46 0C 40 8B 06 74 09 38 18 74 07 40 89 06 EB B0 88 18 8B 46 0C FF 46 04 83 E0 EF 83 C8 01 89 46 0C 0F B6 C3 EB 9C }
	condition:
		$1
}

rule file_148_1_0 {
	meta:
		name = "_ungetc"
		size = 112
		refs = "0003 __sehtable$_ungetc 0008 __SEH_prolog4 001f __errno 002a __invalid_parameter_noinfo 0035 __lock_file 0043 __ungetc_nolock 005d __SEH_epilog4 006a __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 E4 00 33 C0 8B 75 0C 85 F6 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 29 56 E8 ?? ?? ?? ?? 59 83 65 FC 00 56 FF 75 08 E8 ?? ?? ?? ?? 59 59 8B F8 89 7D E4 C7 45 FC FE FF FF FF E8 0E 00 00 00 8B C7 E8 ?? ?? ?? ?? C3 8B 75 0C 8B 7D E4 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "___dtold"
		size = 200
	strings:
		$1 = { 55 8B EC 51 51 8B 45 0C 53 56 57 0F B7 78 06 BB 00 00 00 80 8B 50 04 8B CF 8B 00 81 E7 00 80 00 00 C1 E9 04 81 E2 FF FF 0F 00 81 E1 FF 07 00 00 89 7D F8 8B F1 89 45 FC 85 F6 74 17 81 FE FF 07 00 00 74 08 8D 81 00 3C 00 00 EB 25 B8 FF 7F 00 00 EB 21 85 D2 75 12 85 C0 75 0E 8B 45 08 21 50 04 21 10 66 89 78 08 EB 58 8D 81 01 3C 00 00 33 DB 0F B7 C0 8B 4D FC 8B F1 C1 EE 15 C1 E2 0B 0B F2 C1 E1 0B 0B F3 89 45 0C 8B 5D 08 89 73 04 89 0B 85 F6 78 26 8B F8 8B 13 03 F6 8B CA 81 C7 FF FF 00 00 C1 E9 1F 0B F1 8D 04 12 89 03 79 E8 89 7D 0C 8B 7D F8 8B 45 0C 89 73 04 0B F8 66 89 7B 08 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_149_1_0 {
	meta:
		name = "__fltout2"
		size = 142
		refs = "0007 ___security_cookie 0025 ___dtold 0040 _$I10_OUTPUT 0060 _strcpy_s 0079 @__security_check_cookie@4 0089 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 14 53 8B 5D 10 56 89 45 DC 8D 45 08 57 50 8D 45 D0 50 E8 ?? ?? ?? ?? 59 59 8D 45 E0 50 6A 00 6A 11 83 EC 0C 8D 75 D0 8B FC A5 A5 66 A5 E8 ?? ?? ?? ?? 8B 75 DC 89 43 08 0F BE 45 E2 89 03 0F BF 45 E0 89 43 04 8D 45 E4 50 FF 75 18 56 E8 ?? ?? ?? ?? 83 C4 24 85 C0 75 16 8B 4D FC 8B C3 5F 89 73 0C 33 CD 5E 5B E8 ?? ?? ?? ?? 8B E5 5D C3 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "__beginthreadex"
		size = 153
		refs = "000f __errno 001a __invalid_parameter_noinfo 002b __calloc_crt 0038 __getptd 0041 __initptd 0064 __threadstartex@4 0070 __imp__CreateThread@24 007a __imp__GetLastError@0 0082 _free 008d __dosmaperr"
	strings:
		$1 = { 55 8B EC 53 8B 5D 10 57 33 FF 85 DB 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 73 56 68 BC 03 00 00 6A 01 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 49 E8 ?? ?? ?? ?? FF 70 6C 56 E8 ?? ?? ?? ?? 8B 45 14 83 4E 04 FF 89 46 58 8B 45 1C 89 5E 54 59 59 85 C0 75 03 8D 45 10 50 FF 75 18 56 68 ?? ?? ?? ?? FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 1C FF 15 ?? ?? ?? ?? 8B F8 56 E8 ?? ?? ?? ?? 59 85 FF 74 07 57 E8 ?? ?? ?? ?? 59 33 C0 5E 5F 5B 5D C3 }
	condition:
		$1
}

rule file_150_1_0 {
	meta:
		name = "__callthreadstartex"
		size = 65
		refs = "0003 __sehtable$__callthreadstartex 0008 __SEH_prolog4 000d __getptd 001d __endthreadex 002e __XcptFilter 003c __exit"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 FF 70 58 FF 50 54 50 E8 ?? ?? ?? ?? 8B 4D EC 8B 01 8B 00 89 45 E4 51 50 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 FF 75 E4 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_150_2_0 {
	meta:
		name = "__createThread"
		size = 31
		refs = "000d __threadstartex@4 0019 __imp__CreateThread@24"
	strings:
		$1 = { 55 8B EC FF 75 18 FF 75 14 FF 75 10 68 ?? ?? ?? ?? FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_150_3_0 {
	meta:
		name = "__endthreadex"
		size = 46
		refs = "0005 __getptd_noexit 0019 __uninitMTAoncurrentthread 001f __freeptd 0029 __imp__ExitThread@4"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 15 83 BE B4 03 00 00 00 74 05 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 FF 75 08 FF 15 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_150_4_0 {
	meta:
		name = "__initMTAoncurrentthread"
		size = 88
		refs = "0002 ?s_initialized@?1??_initMTAoncurrentthread@@9@9 000a ??_C@_0N@PPOMPGGK@RoInitialize?$AA@ 0016 ??_C@_1BI@IDAOOPDH@?$AAc?$AAo?$AAm?$AAb?$AAa?$AAs?$AAe?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 001c __imp__LoadLibraryExW@12 0023 __imp__GetProcAddress@8 002f __imp__EncodePointer@4 0034 ?s_roinit@?1??_initMTAoncurrentthread@@9@9 004c __imp__DecodePointer@4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 39 68 ?? ?? ?? ?? 68 00 08 00 00 6A 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 01 C3 50 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 6A 01 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 F7 D8 1B C0 40 C3 }
	condition:
		$1
}

rule file_150_5_0 {
	meta:
		name = "__threadstartex@4"
		size = 125
		refs = "0005 ___get_flsindex 000b ___crtFlsGetValue 0021 ___crtFlsSetValue 002d __imp__GetLastError@0 0034 __imp__ExitThread@4 003a __imp__GetCurrentThreadId@0 0059 __freefls@4 005e ___crtIsPackagedApp 006d __initMTAoncurrentthread 0078 __callthreadstartex"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F0 59 85 F6 75 2C 8B 75 08 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 0D FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 06 EB 1B 8B 4D 08 51 8B 41 54 89 46 54 8B 41 58 89 46 58 8B 41 04 89 46 04 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 86 B4 03 00 00 85 C0 74 0B E8 ?? ?? ?? ?? 89 86 B4 03 00 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_150_6_0 {
	meta:
		name = "__uninitMTAoncurrentthread"
		size = 80
		refs = "0002 ?s_initialized@?1??_uninitMTAoncurrentthread@@9@9 000a ??_C@_0P@LLFHBIJD@RoUninitialize?$AA@ 0016 ??_C@_1BI@IDAOOPDH@?$AAc?$AAo?$AAm?$AAb?$AAa?$AAs?$AAe?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 001c __imp__LoadLibraryExW@12 0023 __imp__GetProcAddress@8 002e __imp__EncodePointer@4 0033 ?s_rouninit@?1??_uninitMTAoncurrentthread@@9@9 0049 __imp__DecodePointer@4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 38 68 ?? ?? ?? ?? 68 00 08 00 00 6A 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 24 50 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF E0 C3 }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "_setbuf"
		size = 40
		refs = "001f _setvbuf"
	strings:
		$1 = { 55 8B EC 83 7D 0C 00 75 08 6A 00 6A 04 6A 00 EB 0A 68 00 02 00 00 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_154_11_0 {
	meta:
		name = "??0?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@XZ"
		size = 18
		refs = "000a ??0_ReaderWriterLock@details@Concurrency@@QAE@XZ"
		altNames = "??0?$SafeRWList@UBoostedObject@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@XZ ??0?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 56 8B F1 83 26 00 8D 4E 04 E8 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_154_13_0 {
	meta:
		name = "??0Transmogrificator@details@Concurrency@@QAE@XZ"
		size = 178
		refs = "001f ??0_ReaderWriterLock@details@Concurrency@@QAE@XZ 002c __imp__CreateEventW@16 0039 __imp__GetLastError@0 0049 __imp__InitializeSListHead@4 0052 ?TransmogrificationHandler@Transmogrificator@details@Concurrency@@CGXPAXE@Z 005c __imp__RegisterWaitForSingleObject@24 007b ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0080 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 00ad __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 56 8B F1 33 DB 57 8D 7E 04 89 5E 08 89 1F 8D 4E 14 89 5E 0C 89 5E 10 E8 ?? ?? ?? ?? 53 53 53 53 89 5E 1C FF 15 ?? ?? ?? ?? 89 46 08 85 C0 75 0C FF 15 ?? ?? ?? ?? 85 C0 7E 59 EB 4F 8D 46 20 50 FF 15 ?? ?? ?? ?? 53 6A FF 56 68 ?? ?? ?? ?? FF 76 08 57 FF 15 ?? ?? ?? ?? 85 C0 75 25 FF 15 ?? ?? ?? ?? 85 C0 7E 08 0F B7 C0 0D 00 00 07 80 50 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 EB 22 5F 8B C6 5E 5B 8B E5 5D C3 0F B7 C0 0D 00 00 07 80 50 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_154_19_0 {
	meta:
		name = "??1Transmogrificator@details@Concurrency@@QAE@XZ"
		size = 64
		refs = "0009 __imp__InterlockedFlushSList@4 0019 __imp__SetEvent@4 0031 __imp__UnregisterWaitEx@8 003a __imp__CloseHandle@4"
	strings:
		$1 = { 57 8B F9 8D 47 20 50 FF 15 ?? ?? ?? ?? 85 C0 74 13 56 FF 70 D0 8B 30 FF 15 ?? ?? ?? ?? 8B C6 85 F6 75 EF 5E 83 7F 04 00 74 0B 6A FF FF 77 04 FF 15 ?? ?? ?? ?? FF 77 08 FF 15 ?? ?? ?? ?? 5F C3 }
	condition:
		$1
}

rule file_154_35_0 {
	meta:
		name = "?AddTail@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
		size = 47
	strings:
		$1 = { 55 8B EC 8B 01 8B 55 08 85 C0 75 07 89 52 04 89 12 EB 16 8B 40 04 89 42 04 8B 01 89 02 8B 01 8B 40 04 89 10 8B 01 89 50 04 89 11 5D C2 04 00 }
	condition:
		$1
}

rule file_154_36_0 {
	meta:
		name = "?AddTail@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
		size = 39
		refs = "000b ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ 0015 ?AddTail@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z 001d ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 57 8B F9 8D 4F 04 E8 ?? ?? ?? ?? FF 75 08 8B CF E8 ?? ?? ?? ?? 8D 4F 04 E8 ?? ?? ?? ?? 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_600_167_0 {
	meta:
		name = "?AddTail@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QAEXPAVWaitNode@SchedulerBase@23@@Z"
		size = 39
		refs = "000b ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ 0015 ?AddTail@?$List@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@@details@Concurrency@@QAEXPAVWaitNode@SchedulerBase@23@@Z 001d ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 57 8B F9 8D 4F 04 E8 ?? ?? ?? ?? FF 75 08 8B CF E8 ?? ?? ?? ?? 8D 4F 04 E8 ?? ?? ?? ?? 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_190_206_0 {
	meta:
		name = "?Remove@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
		size = 39
		refs = "000b ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ 0015 ?Remove@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z 001d ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 57 8B F9 8D 4F 04 E8 ?? ?? ?? ?? FF 75 08 8B CF E8 ?? ?? ?? ?? 8D 4F 04 E8 ?? ?? ?? ?? 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_154_37_0 {
	meta:
		name = "?BeginTransmogrifying@Transmogrificator@details@Concurrency@@AAEXXZ"
		size = 108
		refs = "0003 __ehhandler$?BeginTransmogrifying@Transmogrificator@details@Concurrency@@AAEXXZ 0008 __EH_prolog3 0017 ?RemoveHead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEPAUListEntry@23@XZ 0021 ??2@YAPAXI@Z 0035 ??0CachedTransmogrifiedPrimary@details@Concurrency@@QAE@PAVTransmogrificator@12@@Z 0053 ?QueueToCompletion@TransmogrifiedPrimary@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z 0067 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 8D 46 10 8D 5E 0C 8B C8 E8 ?? ?? ?? ?? 6A 4C 8D 78 80 E8 ?? ?? ?? ?? 59 89 45 F0 83 65 FC 00 85 C0 74 0C 56 8B C8 E8 ?? ?? ?? ?? 8B D0 EB 02 33 D2 83 4D FC FF 8D 47 3C 8B CA 87 08 83 F9 01 75 08 57 8B CA E8 ?? ?? ?? ?? 83 C8 FF F0 0F C1 03 48 85 C0 8D 46 10 7F AE E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_154_42_0 {
	meta:
		name = "?PerformTransmogrification@Transmogrificator@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z"
		size = 86
		refs = "000c __imp__InterlockedPopEntrySList@4 0034 ?AddTail@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z 004d __imp__SetEvent@4"
	strings:
		$1 = { 55 8B EC 56 8B F1 8D 46 20 50 FF 15 ?? ?? ?? ?? 85 C0 74 15 8D 4E 1C 83 CA FF F0 0F C1 11 8D 48 BC 8B 45 08 89 48 3C EB 28 8B 45 08 8D 4E 10 83 E8 80 50 E8 ?? ?? ?? ?? 33 C0 8D 4E 0C 40 F0 0F C1 01 40 83 F8 01 75 09 FF 76 08 FF 15 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_154_43_0 {
	meta:
		name = "?RemoveHead@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEPAUListEntry@23@XZ"
		size = 39
	strings:
		$1 = { 8B D1 8B 02 85 C0 75 01 C3 56 8B 70 04 3B C6 75 05 83 22 00 EB 0D 8B 4E 04 89 01 8B 12 8B 4E 04 89 4A 04 8B C6 5E C3 }
	condition:
		$1
}

rule file_154_44_0 {
	meta:
		name = "?RemoveHead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEPAUListEntry@23@XZ"
		size = 35
		refs = "000a ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ 0011 ?RemoveHead@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEPAUListEntry@23@XZ 001a ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 56 57 8B F9 8D 77 04 8B CE E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 8B CE 8B F8 E8 ?? ?? ?? ?? 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_600_395_0 {
	meta:
		name = "?RemoveHead@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QAEPAVWaitNode@SchedulerBase@23@XZ"
		size = 35
		refs = "000a ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ 0011 ?RemoveHead@?$List@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@@details@Concurrency@@QAEPAVWaitNode@SchedulerBase@23@XZ 001a ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 56 57 8B F9 8D 77 04 8B CE E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 8B CE 8B F8 E8 ?? ?? ?? ?? 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_154_45_0 {
	meta:
		name = "?ReturnToCache@Transmogrificator@details@Concurrency@@QAEXPAVCachedTransmogrifiedPrimary@23@@Z"
		size = 53
		refs = "0013 __imp__SetEvent@4 002d __imp__InterlockedPushEntrySList@8"
	strings:
		$1 = { 55 8B EC 8D 51 1C 83 3A 08 7C 0E 8B 45 08 FF 70 14 FF 15 ?? ?? ?? ?? EB 18 33 C0 40 F0 0F C1 02 8B 45 08 83 C0 44 50 8D 41 20 50 FF 15 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_154_48_0 {
	meta:
		name = "?UnblockTransmogrification@Transmogrificator@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z"
		size = 36
		refs = "001b ?QueueToCompletion@TransmogrifiedPrimary@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 33 D2 42 33 C0 8D 4E 3C F0 0F B1 11 85 C0 74 08 56 8B C8 E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "__wexecl"
		size = 66
		refs = "000b __errno 0016 __invalid_parameter_noinfo 0039 __wexecve"
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 33 D2 66 39 10 74 E4 8B 4D 0C 85 C9 74 DD 66 39 11 74 D8 52 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "__wcsrev"
		size = 58
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 8B DE 57 8B FE 66 8B 06 83 C6 02 66 85 C0 75 F5 83 EE 04 EB 12 66 8B 0E 0F B7 17 66 89 0F 83 C7 02 66 89 16 83 EE 02 3B FE 72 EA 5F 5E 8B C3 5B 5D C3 }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "__get_sys_err_msg"
		size = 38
		refs = "000c ___sys_nerr 001c ___sys_errlist"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 85 F6 78 09 E8 ?? ?? ?? ?? 3B 30 7C 07 E8 ?? ?? ?? ?? 8B 30 E8 ?? ?? ?? ?? 8B 04 B0 5E 5D C3 }
	condition:
		$1
}

rule file_159_2_0 {
	meta:
		name = "__wperror"
		size = 282
		refs = "0003 __sehtable$__wperror 0008 __SEH_prolog4 0034 _wcstombs_s 004f __invoke_watson 005e __calloc_crt 0097 _free 009d __SEH_epilog4 00a6 ___lock_fhandle 00b4 _strlen 00bc __write_nolock 00c2 ??_C@_02LMMGGCAJ@?3?5?$AA@ 00d6 __errno 00dd __get_sys_err_msg 00f4 ??_C@_01EEMJAFIK@?6?$AA@ 0114 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 02 5F 89 7D E0 33 F6 89 75 E4 8B 5D 08 85 DB 0F 84 80 00 00 00 66 39 33 74 7B 68 FF FF FF 7F 53 56 56 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 14 83 F8 16 74 05 83 F8 22 75 0A 56 56 56 56 56 E8 ?? ?? ?? ?? 39 75 E4 74 44 6A 01 FF 75 E4 E8 ?? ?? ?? ?? 59 59 8B F0 85 F6 74 32 6A FF 53 FF 75 E4 56 33 DB 53 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 24 83 F8 16 74 05 83 F8 22 75 07 53 53 53 53 53 EB BD 85 C0 74 0F 56 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C3 33 DB 57 E8 ?? ?? ?? ?? 59 89 5D FC 85 F6 74 1D 56 E8 ?? ?? ?? ?? 50 56 57 E8 ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 1C 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 E8 ?? ?? ?? ?? 8B F0 56 E8 ?? ?? ?? ?? 50 56 57 E8 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 24 C7 45 FC FE FF FF FF E8 05 00 00 00 EB 8D 8B 7D E0 57 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "_acoshf"
		size = 189
		refs = "000a __fdtest 0040 __fperrraise 0046 __FNan_C 005f __FEps_C 0065 __real@4000000000000000 008d _sqrtf 009e _log1pf 00a8 _logf 00ae __real@3fe62e4300000000"
	strings:
		$1 = { 55 8B EC 51 51 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 48 74 0B 48 75 15 D9 45 08 E9 9B 00 00 00 8B 45 0A 0F B7 C0 A9 00 80 00 00 EB E9 D9 E8 D9 45 08 D8 D1 DF E0 F6 C4 05 7A 13 DD D9 6A 01 DD D8 E8 ?? ?? ?? ?? D9 05 ?? ?? ?? ?? EB 6C DD E1 DF E0 DD D9 F6 C4 44 7A 06 DD D8 D9 EE EB 5C D9 05 ?? ?? ?? ?? DC 3D ?? ?? ?? ?? 51 D8 D9 DF E0 F6 C4 41 75 31 D9 C0 D9 E8 DC E9 D9 C9 D9 5D FC DE C1 D8 4D FC D9 5D F8 D9 45 F8 D9 1C 24 E8 ?? ?? ?? ?? D8 45 FC D9 5D F8 D9 45 F8 D9 1C 24 E8 ?? ?? ?? ?? EB 14 D9 1C 24 E8 ?? ?? ?? ?? DC 05 ?? ?? ?? ?? D9 5D F8 D9 45 F8 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_160_1_0 {
	meta:
		name = "_logf"
		size = 26
		refs = "000c _log"
	strings:
		$1 = { 55 8B EC D9 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? D9 5D 08 D9 45 08 59 59 5D C3 }
	condition:
		$1
}

rule file_261_1_0 {
	meta:
		name = "_cosf"
		size = 26
		refs = "000c _cos"
	strings:
		$1 = { 55 8B EC D9 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? D9 5D 08 D9 45 08 59 59 5D C3 }
	condition:
		$1
}

rule file_1349_2_0 {
	meta:
		name = "_expf"
		size = 26
		refs = "000c _exp"
	strings:
		$1 = { 55 8B EC D9 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? D9 5D 08 D9 45 08 59 59 5D C3 }
	condition:
		$1
}

rule file_1404_3_0 {
	meta:
		name = "_sinf"
		size = 26
		refs = "000c _sin"
	strings:
		$1 = { 55 8B EC D9 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? D9 5D 08 D9 45 08 59 59 5D C3 }
	condition:
		$1
}

rule file_300_1_0 {
	meta:
		name = "_sinhf"
		size = 26
		refs = "000c _sinh"
	strings:
		$1 = { 55 8B EC D9 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? D9 5D 08 D9 45 08 59 59 5D C3 }
	condition:
		$1
}

rule file_784_13_0 {
	meta:
		name = "_sqrtf"
		size = 26
		refs = "000c _sqrt"
	strings:
		$1 = { 55 8B EC D9 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? D9 5D 08 D9 45 08 59 59 5D C3 }
	condition:
		$1
}

rule file_300_3_0 {
	meta:
		name = "_tanf"
		size = 26
		refs = "000c _tan"
	strings:
		$1 = { 55 8B EC D9 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? D9 5D 08 D9 45 08 59 59 5D C3 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "___sse4_floorf4"
		size = 16
	strings:
		$1 = { 66 0F 3A 08 C0 01 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__wfdopen"
		size = 413
		refs = "0003 __sehtable$__wfdopen 0008 __SEH_prolog4 001b __errno 004c __nhandle 0066 ___pioinfo 00a6 __commode 013f __getstream 0160 __cflush 017f __unlock_file 0191 __invalid_parameter_noinfo 0198 __SEH_epilog4"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 55 0C 85 D2 0F 95 C0 85 C0 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 66 01 00 00 8B 7D 08 83 FF FE 75 10 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 53 01 00 00 85 FF 0F 88 3B 01 00 00 3B 3D ?? ?? ?? ?? 0F 83 2F 01 00 00 8B C7 C1 F8 05 8B CF 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 0F BE 44 08 04 83 E0 01 0F 84 0D 01 00 00 6A 20 58 EB 03 83 C2 02 66 39 02 74 F8 0F B7 02 83 F8 61 74 0A 83 F8 72 74 1A 83 F8 77 75 83 6A 02 5B 33 C9 41 33 C0 8B F0 89 45 0C 0B 1D ?? ?? ?? ?? EB 68 33 DB 43 EB E9 85 C9 74 6A 0F B7 C0 83 E8 20 74 57 83 E8 0B 74 3F 83 E8 37 74 11 48 74 2A 83 E8 0B 74 18 83 E8 06 0F 85 42 FF FF FF 83 7D 0C 00 75 27 C7 45 0C 01 00 00 00 EB 2D 85 F6 75 1A 46 81 E3 FF BF FF FF EB 20 85 F6 75 0D 46 81 CB 00 40 00 00 EB 13 84 DB 79 06 33 C0 8B C8 EB 09 83 E3 FC 81 CB 80 00 00 00 83 C2 02 0F B7 02 66 85 C0 75 92 6A 20 58 EB 03 83 C2 02 66 39 02 74 F8 33 C0 33 C9 66 39 0A 0F 94 C0 85 C0 0F 84 DC FE FF FF E8 ?? ?? ?? ?? 8B F0 89 75 0C 85 F6 75 0D E8 ?? ?? ?? ?? C7 00 18 00 00 00 EB 3C 33 C0 89 45 FC FF 05 ?? ?? ?? ?? 89 5E 0C 89 7E 10 C7 45 FC FE FF FF FF E8 07 00 00 00 8B C6 EB 1D 8B 75 0C 56 E8 ?? ?? ?? ?? 59 C3 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 33 C0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_163_12_0 {
	meta:
		name = "??0_Interruption_exception@details@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7_Interruption_exception@details@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_797_19_0 {
	meta:
		name = "??0SingleWaitBlock@details@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0WaitBlock@details@Concurrency@@QAE@XZ 000a ??_7SingleWaitBlock@details@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_14_0 {
	meta:
		name = "??0bad_target@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_17_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_19_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_21_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_23_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_25_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_27_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_29_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_31_0 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_33_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_35_0 {
	meta:
		name = "??0invalid_operation@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_37_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_39_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_41_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_43_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_45_0 {
	meta:
		name = "??0message_not_found@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_47_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_49_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_51_0 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_53_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_59_0 {
	meta:
		name = "??0task_canceled@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7task_canceled@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_61_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QAE@XZ"
		size = 18
		refs = "0004 ??0exception@std@@QAE@XZ 000a ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_163_54_0 {
	meta:
		name = "??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z"
		size = 30
		refs = "0007 ??0exception@std@@QAE@XZ 0015 ??_7scheduler_resource_allocation_error@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? 8B 45 08 89 46 0C 8B C6 C7 06 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_163_55_0 {
	meta:
		name = "??0scheduler_resource_allocation_error@Concurrency@@QAE@PBDJ@Z"
		size = 34
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0019 ??_7scheduler_resource_allocation_error@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 8B F1 50 E8 ?? ?? ?? ?? 8B 45 0C 89 46 0C 8B C6 C7 06 ?? ?? ?? ?? 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_163_57_0 {
	meta:
		name = "??0scheduler_worker_creation_error@Concurrency@@QAE@PBDJ@Z"
		size = 30
		refs = "000d ??0scheduler_resource_allocation_error@Concurrency@@QAE@PBDJ@Z 0013 ??_7scheduler_worker_creation_error@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 0C 8B F1 FF 75 08 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "__alldvrm"
		size = 223
	strings:
		$1 = { 57 56 55 33 FF 33 ED 8B 44 24 14 0B C0 7D 15 47 45 8B 54 24 10 F7 D8 F7 DA 83 D8 00 89 44 24 14 89 54 24 10 8B 44 24 1C 0B C0 7D 14 47 8B 54 24 18 F7 D8 F7 DA 83 D8 00 89 44 24 1C 89 54 24 18 0B C0 75 28 8B 4C 24 18 8B 44 24 14 33 D2 F7 F1 8B D8 8B 44 24 10 F7 F1 8B F0 8B C3 F7 64 24 18 8B C8 8B C6 F7 64 24 18 03 D1 EB 47 8B D8 8B 4C 24 18 8B 54 24 14 8B 44 24 10 D1 EB D1 D9 D1 EA D1 D8 0B DB 75 F4 F7 F1 8B F0 F7 64 24 1C 8B C8 8B 44 24 18 F7 E6 03 D1 72 0E 3B 54 24 14 77 08 72 0F 3B 44 24 10 76 09 4E 2B 44 24 18 1B 54 24 1C 33 DB 2B 44 24 10 1B 54 24 14 4D 79 07 F7 DA F7 D8 83 DA 00 8B CA 8B D3 8B D9 8B C8 8B C6 4F 75 07 F7 DA F7 D8 83 DA 00 5D 5E 5F C2 10 00 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "___libm_sse2_log10"
		size = 574
		refs = "0024 _emask 002c _CC 0034 _One 003c _Magic 0044 _hi_mask 0062 _CB_Tbl 006a _T_Tbl 00cc _coeff 00f8 _LOG10_2 0104 _place_LR 015e _Zero 01b2 _Infs 01e1 _Two52"
	strings:
		$1 = { 83 EC 0C BA 00 00 00 00 66 0F 13 44 24 04 66 0F 28 E8 66 0F 14 C0 66 0F 73 D5 34 66 0F C5 CD 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C3 66 0F 58 E0 66 0F C5 C4 00 25 F0 07 00 00 66 0F 28 A0 ?? ?? ?? ?? 66 0F 28 B8 ?? ?? ?? ?? 66 0F 54 F0 66 0F 5C C6 66 0F 59 F4 66 0F 5C F2 F2 0F 58 FE 66 0F 59 C4 66 0F 28 E0 66 0F 58 C6 81 E1 FF 0F 00 00 83 E9 01 81 F9 FD 07 00 00 0F 87 B1 00 00 00 81 E9 FE 03 00 00 03 CA F2 0F 2A F1 66 0F 14 F6 C1 E1 0A 03 C1 B9 10 00 00 00 BA 00 00 00 00 83 F8 00 0F 44 D1 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 DB 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 DB 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 F5 66 0F 28 AA ?? ?? ?? ?? 66 0F 54 E5 66 0F 58 FE 66 0F 58 FC 66 0F 59 C8 F2 0F 59 D8 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D0 66 0F 28 F7 66 0F 15 F6 66 0F 59 CB 66 0F 28 C1 66 0F 58 CA 66 0F 15 C0 83 C4 0C F2 0F 58 C1 F2 0F 58 C6 F2 0F 58 C7 C3 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? F2 0F C2 C8 00 66 0F C5 C1 00 83 F8 00 77 54 83 F9 FF 74 67 81 F9 FE 07 00 00 77 75 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C2 F2 0F C2 D0 00 66 0F C5 C2 00 83 F8 00 74 0C 83 C4 0C 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 44 24 04 83 C4 0C F2 0F 58 C0 C3 83 C4 0C 66 0F 12 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C1 BA CC FF FF FF E9 1B FE FF FF 83 C1 01 81 E1 FF 07 00 00 81 F9 FF 07 00 00 73 0C 83 C4 0C 66 0F 57 C0 F2 0F 5E C0 C3 66 0F 12 54 24 04 66 0F 12 44 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B C1 83 F8 00 74 CE 83 C4 0C F2 0F 58 C0 C3 }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "__wfreopen"
		size = 38
		refs = "0018 __wfreopen_helper"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 8D 45 FC 6A 40 FF 75 10 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_803_1_0 {
	meta:
		name = "_freopen"
		size = 38
		refs = "0018 __freopen_helper"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 8D 45 FC 6A 40 FF 75 10 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_167_1_0 {
	meta:
		name = "__wfreopen_helper"
		size = 211
		refs = "0003 __sehtable$__wfreopen_helper 0008 __SEH_prolog4 001b __errno 0025 __invalid_parameter_noinfo 0071 __SEH_epilog4 007b __lock_file 008b __fclose_nolock 00a6 __wopenfile 00cd __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 5D 08 85 DB 0F 95 C0 85 C0 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 43 33 FF 89 3B 33 C0 8B 4D 0C 85 C9 0F 95 C0 85 C0 74 DB 33 C0 39 45 10 0F 95 C0 85 C0 74 CF 33 C0 8B 75 14 85 F6 0F 95 C0 85 C0 74 C1 66 39 39 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? C3 89 75 E4 56 E8 ?? ?? ?? ?? 59 89 7D FC F6 46 0C 83 74 07 56 E8 ?? ?? ?? ?? 59 89 7E 08 89 3E 89 7E 0C 89 7E 04 56 FF 75 18 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 89 03 C7 45 FC FE FF FF FF E8 10 00 00 00 39 3B 74 AA 33 C0 EB AD 33 FF 8B 5D 08 8B 75 E4 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_167_2_0 {
	meta:
		name = "__wfreopen_s"
		size = 30
		refs = "0015 __wfreopen_helper"
	strings:
		$1 = { 55 8B EC 68 80 00 00 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_803_2_0 {
	meta:
		name = "_freopen_s"
		size = 30
		refs = "0015 __freopen_helper"
	strings:
		$1 = { 55 8B EC 68 80 00 00 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "@x64tow@20"
		size = 139
		refs = "0035 __aulldvrm"
	strings:
		$1 = { 55 8B EC 51 51 83 7D 10 00 56 89 55 FC 8B F1 8B 4D 08 8B 55 0C 57 74 10 6A 2D 58 66 89 06 83 C6 02 F7 D9 83 D2 00 F7 DA 8B 7D FC 89 75 0C 53 6A 00 57 52 51 E8 ?? ?? ?? ?? 89 4D 10 8B C8 8B 45 10 89 5D FC 83 F8 09 76 05 83 C0 57 EB 03 83 C0 30 66 89 06 83 C6 02 85 D2 77 D4 72 04 85 C9 75 CE 8B 7D 0C 33 C0 66 89 06 83 EE 02 5B 66 8B 07 0F B7 0E 66 89 06 83 EE 02 66 89 0F 83 C7 02 3B FE 72 EA 5F 5E 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_168_1_0 {
	meta:
		name = "__i64tow"
		size = 48
		refs = "0027 @x64tow@20"
	strings:
		$1 = { 55 8B EC 8B 55 14 33 C0 83 FA 0A 75 0F 39 45 0C 7F 0A 7C 05 39 45 08 73 03 33 C0 40 8B 4D 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_218_1_0 {
	meta:
		name = "__i64toa"
		size = 48
		refs = "0027 @x64toa@20"
	strings:
		$1 = { 55 8B EC 8B 55 14 33 C0 83 FA 0A 75 0F 39 45 0C 7F 0A 7C 05 39 45 08 73 03 33 C0 40 8B 4D 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_168_2_0 {
	meta:
		name = "__itow"
		size = 43
		refs = "0022 _xtow@16"
	strings:
		$1 = { 55 8B EC 83 7D 10 0A 8B 45 08 56 75 0A 85 C0 79 06 6A 01 6A 0A EB 05 6A 00 FF 75 10 8B 75 0C 56 50 E8 ?? ?? ?? ?? 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_218_2_0 {
	meta:
		name = "__itoa"
		size = 43
		refs = "0022 _xtoa@16"
	strings:
		$1 = { 55 8B EC 83 7D 10 0A 8B 45 08 56 75 0A 85 C0 79 06 6A 01 6A 0A EB 05 6A 00 FF 75 10 8B 75 0C 56 50 E8 ?? ?? ?? ?? 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_168_3_0 {
	meta:
		name = "__ltow"
		size = 42
		refs = "0021 _xtow@16"
	strings:
		$1 = { 55 8B EC 83 7D 10 0A 75 0B 83 7D 08 00 7D 05 33 C0 40 EB 02 33 C0 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_218_3_0 {
	meta:
		name = "__ltoa"
		size = 42
		refs = "0021 _xtoa@16"
	strings:
		$1 = { 55 8B EC 83 7D 10 0A 75 0B 83 7D 08 00 7D 05 33 C0 40 EB 02 33 C0 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_168_4_0 {
	meta:
		name = "__ui64tow"
		size = 27
		refs = "0012 @x64tow@20"
	strings:
		$1 = { 55 8B EC 8B 55 14 8B 4D 10 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_218_4_0 {
	meta:
		name = "__ui64toa"
		size = 27
		refs = "0012 @x64toa@20"
	strings:
		$1 = { 55 8B EC 8B 55 14 8B 4D 10 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_168_5_0 {
	meta:
		name = "__ultow"
		size = 24
		refs = "000f _xtow@16"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_218_5_0 {
	meta:
		name = "__ultoa"
		size = 24
		refs = "000f _xtoa@16"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_168_6_0 {
	meta:
		name = "_xtow@16"
		size = 97
	strings:
		$1 = { 55 8B EC 83 7D 14 00 8B 4D 08 53 56 8B 75 0C 57 74 0B 6A 2D 58 66 89 06 83 C6 02 F7 D9 6A 02 8B FE 5B 8B C1 33 D2 F7 75 10 8B C8 8D 42 57 83 FA 09 77 03 8D 42 30 66 89 06 03 F3 85 C9 75 E3 33 C0 66 89 06 2B F3 66 8B 07 0F B7 0E 66 89 06 2B F3 66 89 0F 03 FB 3B FE 72 EC 5F 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule file_169_0_0 {
	meta:
		name = "__mbccpy"
		size = 25
		refs = "0010 __mbccpy_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C 6A 00 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_169_1_0 {
	meta:
		name = "__mbccpy_l"
		size = 26
		refs = "0011 __mbccpy_s_l"
	strings:
		$1 = { 55 8B EC FF 75 10 FF 75 0C 6A 00 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "_memcpy"
		size = 1604
		refs = "0023 ___favor 004b ___isa_enabled 0205 TrailUpVec 023c LeadUpVec 024b UnwindUpVec 0250 LeadUp1 0254 LeadUp2 0258 LeadUp3 02cc UnwindUp0 02d0 UnwindUp1 02d4 UnwindUp2 02d8 UnwindUp3 02dc UnwindUp4 02e0 UnwindUp5 02e4 UnwindUp6 02e8 UnwindUp7 0338 TrailUp0 033c TrailUp1 0340 TrailUp2 0344 TrailUp3 03aa TrailDownVec 03b5 UnwindDownVec 03d0 LeadDownVec 03dc LeadDown1 03e0 LeadDown2 03e4 LeadDown3 0468 UnwindDown7 046c UnwindDown6 0470 UnwindDown5 0474 UnwindDown4 0478 UnwindDown3 047c UnwindDown2 0480 UnwindDown1 0484 UnwindDown0 04d4 TrailDown0 04d8 TrailDown1 04dc TrailDown2 04e0 TrailDown3"
		altNames = "_memmove"
	strings:
		$1 = { 57 56 8B 74 24 10 8B 4C 24 14 8B 7C 24 0C 8B C1 8B D1 03 C6 3B FE 76 08 3B F8 0F 82 68 03 00 00 0F BA 25 ?? ?? ?? ?? 01 73 07 F3 A4 E9 17 03 00 00 81 F9 80 00 00 00 0F 82 CE 01 00 00 8B C7 33 C6 A9 0F 00 00 00 75 0E 0F BA 25 ?? ?? ?? ?? 01 0F 82 DA 04 00 00 0F BA 25 ?? ?? ?? ?? 00 0F 83 A7 01 00 00 F7 C7 03 00 00 00 0F 85 B8 01 00 00 F7 C6 03 00 00 00 0F 85 97 01 00 00 0F BA E7 02 73 0D 8B 06 83 E9 04 8D 76 04 89 07 8D 7F 04 0F BA E7 03 73 11 F3 0F 7E 0E 83 E9 08 8D 76 08 66 0F D6 0F 8D 7F 08 F7 C6 07 00 00 00 74 63 0F BA E6 03 0F 83 B2 00 00 00 66 0F 6F 4E F4 8D 76 F4 66 0F 6F 5E 10 83 E9 30 66 0F 6F 46 20 66 0F 6F 6E 30 8D 76 30 83 F9 30 66 0F 6F D3 66 0F 3A 0F D9 0C 66 0F 7F 1F 66 0F 6F E0 66 0F 3A 0F C2 0C 66 0F 7F 47 10 66 0F 6F CD 66 0F 3A 0F EC 0C 66 0F 7F 6F 20 8D 7F 30 7D B7 8D 76 0C E9 AF 00 00 00 66 0F 6F 4E F8 8D 76 F8 8D 49 00 66 0F 6F 5E 10 83 E9 30 66 0F 6F 46 20 66 0F 6F 6E 30 8D 76 30 83 F9 30 66 0F 6F D3 66 0F 3A 0F D9 08 66 0F 7F 1F 66 0F 6F E0 66 0F 3A 0F C2 08 66 0F 7F 47 10 66 0F 6F CD 66 0F 3A 0F EC 08 66 0F 7F 6F 20 8D 7F 30 7D B7 8D 76 08 EB 56 66 0F 6F 4E FC 8D 76 FC 8B FF 66 0F 6F 5E 10 83 E9 30 66 0F 6F 46 20 66 0F 6F 6E 30 8D 76 30 83 F9 30 66 0F 6F D3 66 0F 3A 0F D9 04 66 0F 7F 1F 66 0F 6F E0 66 0F 3A 0F C2 04 66 0F 7F 47 10 66 0F 6F CD 66 0F 3A 0F EC 04 66 0F 7F 6F 20 8D 7F 30 7D B7 8D 76 04 83 F9 10 7C 13 F3 0F 6F 0E 83 E9 10 8D 76 10 66 0F 7F 0F 8D 7F 10 EB E8 0F BA E1 02 73 0D 8B 06 83 E9 04 8D 76 04 89 07 8D 7F 04 0F BA E1 03 73 11 F3 0F 7E 0E 83 E9 08 8D 76 08 66 0F D6 0F 8D 7F 08 8B 04 8D ?? ?? ?? ?? FF E0 F7 C7 03 00 00 00 75 15 C1 E9 02 83 E2 03 83 F9 08 72 2A F3 A5 FF 24 95 ?? ?? ?? ?? 90 8B C7 BA 03 00 00 00 83 E9 04 72 0C 83 E0 03 03 C8 FF 24 85 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 90 FF 24 8D ?? ?? ?? ?? 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 23 D1 8A 06 88 07 8A 46 01 88 47 01 8A 46 02 C1 E9 02 88 47 02 83 C6 03 83 C7 03 83 F9 08 72 CC F3 A5 FF 24 95 ?? ?? ?? ?? 8D 49 00 23 D1 8A 06 88 07 8A 46 01 C1 E9 02 88 47 01 83 C6 02 83 C7 02 83 F9 08 72 A6 F3 A5 FF 24 95 ?? ?? ?? ?? 90 23 D1 8A 06 88 07 83 C6 01 C1 E9 02 83 C7 01 83 F9 08 72 88 F3 A5 FF 24 95 ?? ?? ?? ?? 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 44 8E E4 89 44 8F E4 8B 44 8E E8 89 44 8F E8 8B 44 8E EC 89 44 8F EC 8B 44 8E F0 89 44 8F F0 8B 44 8E F4 89 44 8F F4 8B 44 8E F8 89 44 8F F8 8B 44 8E FC 89 44 8F FC 8D 04 8D 00 00 00 00 03 F0 03 F8 FF 24 95 ?? ?? ?? ?? 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 44 24 0C 5E 5F C3 90 8A 06 88 07 8B 44 24 0C 5E 5F C3 90 8A 06 88 07 8A 46 01 88 47 01 8B 44 24 0C 5E 5F C3 8D 49 00 8A 06 88 07 8A 46 01 88 47 01 8A 46 02 88 47 02 8B 44 24 0C 5E 5F C3 90 8D 74 31 FC 8D 7C 39 FC F7 C7 03 00 00 00 75 24 C1 E9 02 83 E2 03 83 F9 08 72 0D FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 8B FF F7 D9 FF 24 8D ?? ?? ?? ?? 8D 49 00 8B C7 BA 03 00 00 00 83 F9 04 72 0C 83 E0 03 2B C8 FF 24 85 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8A 46 03 23 D1 88 47 03 83 EE 01 C1 E9 02 83 EF 01 83 F9 08 72 B2 FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 8D 49 00 8A 46 03 23 D1 88 47 03 8A 46 02 C1 E9 02 88 47 02 83 EE 02 83 EF 02 83 F9 08 72 88 FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 90 8A 46 03 23 D1 88 47 03 8A 46 02 88 47 02 8A 46 01 C1 E9 02 88 47 01 83 EE 03 83 EF 03 83 F9 08 0F 82 56 FF FF FF FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 44 8E 1C 89 44 8F 1C 8B 44 8E 18 89 44 8F 18 8B 44 8E 14 89 44 8F 14 8B 44 8E 10 89 44 8F 10 8B 44 8E 0C 89 44 8F 0C 8B 44 8E 08 89 44 8F 08 8B 44 8E 04 89 44 8F 04 8D 04 8D 00 00 00 00 03 F0 03 F8 FF 24 95 ?? ?? ?? ?? 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 44 24 0C 5E 5F C3 90 8A 46 03 88 47 03 8B 44 24 0C 5E 5F C3 8D 49 00 8A 46 03 88 47 03 8A 46 02 88 47 02 8B 44 24 0C 5E 5F C3 90 8A 46 03 88 47 03 8A 46 02 88 47 02 8A 46 01 88 47 01 8B 44 24 0C 5E 5F C3 8D A4 24 00 00 00 00 57 8B C6 83 E0 0F 85 C0 0F 85 D2 00 00 00 8B D1 83 E1 7F C1 EA 07 74 65 8D A4 24 00 00 00 00 90 66 0F 6F 06 66 0F 6F 4E 10 66 0F 6F 56 20 66 0F 6F 5E 30 66 0F 7F 07 66 0F 7F 4F 10 66 0F 7F 57 20 66 0F 7F 5F 30 66 0F 6F 66 40 66 0F 6F 6E 50 66 0F 6F 76 60 66 0F 6F 7E 70 66 0F 7F 67 40 66 0F 7F 6F 50 66 0F 7F 77 60 66 0F 7F 7F 70 8D B6 80 00 00 00 8D BF 80 00 00 00 4A 75 A3 85 C9 74 4F 8B D1 C1 EA 04 85 D2 74 17 8D 9B 00 00 00 00 66 0F 6F 06 66 0F 7F 07 8D 76 10 8D 7F 10 4A 75 EF 83 E1 0F 74 2A 8B C1 C1 E9 02 74 0D 8B 16 89 17 8D 76 04 8D 7F 04 49 75 F3 8B C8 83 E1 03 74 0F 8A 06 88 07 46 47 49 75 F7 8D 9B 00 00 00 00 58 5E 5F C3 8D A4 24 00 00 00 00 EB 03 CC CC CC BA 10 00 00 00 2B D0 2B CA 51 8B C2 8B C8 83 E1 03 74 09 8A 16 88 17 46 47 49 75 F7 C1 E8 02 74 0D 8B 16 89 17 8D 76 04 8D 7F 04 48 75 F3 59 E9 FA FE FF FF }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "___libm_sse2_cosf"
		size = 320
		refs = "0004 _static_const_table"
	strings:
		$1 = { F2 0F 10 15 ?? ?? ?? ?? 81 E6 FF FF FF 7F 25 00 00 80 7F 3D 00 00 80 7F 0F 84 0E 01 00 00 C1 EE 17 81 EE 8E 00 00 00 81 E6 F8 FF 00 00 F2 0F 10 1C 75 ?? ?? ?? ?? F2 0F 10 2C 75 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 66 0F 57 E4 B8 38 43 00 00 66 0F C4 E0 03 66 0F 54 D3 66 0F 73 F3 28 F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 CD F2 0F 10 C2 F2 0F 58 D3 F2 0F 10 EA F2 0F 5C C2 F2 0F 58 D4 F2 0F 58 D8 66 0F 7E D6 F2 0F 5C D4 F2 0F 58 CB B8 80 01 00 00 F2 0F 10 25 ?? ?? ?? ?? F2 0F 5C EA 03 F6 8B D6 C1 E6 18 C1 FE 1F 23 C2 03 D6 33 D6 F2 0F 58 CD 81 E2 FE 00 00 00 F2 0F 10 1C D5 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 66 0F 70 D1 44 F2 0F 59 C9 F2 0F 10 2C D5 ?? ?? ?? ?? 8B F0 81 E6 00 01 00 00 C1 E6 17 F2 0F 59 DA 66 0F 6E D6 F2 0F 5C C1 05 80 00 00 00 25 00 01 00 00 C1 E0 17 F2 0F 5C E1 66 0F 73 F2 20 66 0F 6E C8 66 0F 57 E2 F2 0F 59 C5 F2 0F 59 DC 66 0F 73 F1 20 66 0F 57 C1 F2 0F 58 C3 66 0F 5A C0 EB 04 F3 0F 5C C0 C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_172_1_0 {
	meta:
		name = "___sse2_cosf4"
		size = 1328
		refs = "0015 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC 20 01 00 00 83 E4 F0 89 84 24 E4 00 00 00 0F 28 3D ?? ?? ?? ?? 0F 54 F8 0F 28 05 ?? ?? ?? ?? 0F 28 25 ?? ?? ?? ?? 0F 28 F7 0F 28 D7 0F 28 2D ?? ?? ?? ?? 0F 58 C7 0F 59 C4 66 0F 5B C0 0F 28 25 ?? ?? ?? ?? 0F C2 FD 06 0F 28 2D ?? ?? ?? ?? 0F 50 C7 23 C0 75 5B 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 0D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 5C C1 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 28 05 ?? ?? ?? ?? 0F 5C D4 0F 5C D5 0F 5C D6 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 CA 0F 5C CF 0F 59 D2 E9 4A 04 00 00 0F 28 CE 0F 29 74 24 50 66 0F 66 35 ?? ?? ?? ?? 0F 29 BC 24 90 00 00 00 0F 57 3D ?? ?? ?? ?? 0F 50 D6 89 04 24 85 D2 0F 85 A7 02 00 00 0F 28 F2 0F 28 DD 0F 28 2D ?? ?? ?? ?? 0F 29 BC 24 80 00 00 00 0F 28 F8 0F 5B C0 0F 28 0D ?? ?? ?? ?? 0F 28 D4 0F 28 25 ?? ?? ?? ?? 0F 5C C1 66 0F 72 F7 1F 0F 59 D0 0F 59 D8 0F 59 E0 0F 59 E8 66 0F 70 44 24 50 EE 0F 5A 4C 24 50 0F 5A C0 0F 5C F2 0F 5C F3 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D9 0F 5C F4 66 0F E6 DB 66 0F 70 DB DC 0F 5C F5 66 0F EB 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D3 66 0F 5C 15 ?? ?? ?? ?? 66 0F 29 44 24 20 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C2 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F 5C C8 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C1 66 0F 5C CC 66 0F 5C C1 0F 54 B4 24 80 00 00 00 0F 29 B4 24 A0 00 00 00 66 0F 28 F1 66 0F 5C C4 66 0F 5C CD 66 0F 73 F3 3E 66 0F 5C F1 0F 54 BC 24 80 00 00 00 0F 29 BC 24 B0 00 00 00 66 0F 28 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 C6 66 0F 28 74 24 20 66 0F 59 35 ?? ?? ?? ?? 66 0F 58 C8 66 0F 59 E2 66 0F 5C F9 66 0F 28 E9 66 0F 5C CC 66 0F 58 C7 66 0F 5C E9 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 C5 66 0F E6 F6 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F DB EB 66 0F 58 C1 66 0F 28 4C 24 20 66 0F EF 2D ?? ?? ?? ?? 66 0F 70 ED DD 66 0F 70 F6 DC 66 0F EB 35 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D6 66 0F 29 44 24 30 66 0F 5C 15 ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C2 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F D6 6C 24 10 66 0F 5C C8 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C1 66 0F 5C CC 66 0F 5C C1 66 0F 28 D9 66 0F 5C C4 66 0F 5C CD 66 0F 73 F6 3E 66 0F 5C D9 66 0F 28 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C DD 66 0F 58 C3 66 0F 58 C8 66 0F 59 E2 66 0F 5C F9 66 0F 28 E9 66 0F 5C CC 66 0F 58 C7 66 0F 5C E9 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 0F 28 A4 24 90 00 00 00 66 0F 58 C5 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F 5A 54 24 30 66 0F DB EE 0F 28 B4 24 A0 00 00 00 66 0F 28 5C 24 10 66 0F 58 C8 66 0F EF 2D ?? ?? ?? ?? 66 0F 5A C9 66 0F 70 ED DD 66 0F 14 D1 0F 28 8C 24 B0 00 00 00 66 0F 14 DD 0F 54 D4 0F 54 DC 0F 56 D6 0F 28 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 56 D9 0F 28 CA 0F 59 D2 E9 76 01 00 00 0F 5A C9 66 0F 29 8C 24 C0 00 00 00 83 F8 0F 0F 84 98 00 00 00 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 0D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 5C C1 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 5C D4 0F 5C D5 0F 5C D6 0F 5C D7 0F 28 CA 0F 59 D2 0F 28 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 E2 0F 59 D2 0F 57 CB 0F 28 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 59 C2 0F 59 EA 0F 59 D1 0F 59 E1 0F 58 05 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 C2 0F 59 EC 0F 58 C5 0F 58 C1 0F 29 44 24 70 89 74 24 04 0F 5A 74 24 58 66 0F 29 74 24 20 89 04 24 A9 01 00 00 00 74 22 F3 0F 10 44 24 50 8B 74 24 50 8B 44 24 50 F2 0F 10 8C 24 C0 00 00 00 E8 55 FA FF FF F3 0F 11 44 24 70 8B 04 24 A9 02 00 00 00 74 22 F3 0F 10 44 24 54 8B 74 24 54 8B 44 24 54 F2 0F 10 8C 24 C8 00 00 00 E8 29 FA FF FF F3 0F 11 44 24 74 8B 04 24 A9 04 00 00 00 74 1F F3 0F 10 44 24 58 8B 74 24 58 8B 44 24 58 F2 0F 10 4C 24 20 E8 00 FA FF FF F3 0F 11 44 24 78 8B 04 24 0F 28 44 24 70 A9 08 00 00 00 74 1F F3 0F 10 44 24 5C 8B 74 24 5C 8B 44 24 5C F2 0F 10 4C 24 28 E8 D2 F9 FF FF F3 0F 11 44 24 7C 8B 74 24 04 0F 28 44 24 70 EB 23 0F 59 C2 0F 58 05 ?? ?? ?? ?? 0F 59 C2 0F 58 C5 0F 59 C2 0F 58 C6 0F 59 C2 0F 59 C1 0F 58 C1 66 0F EF C3 8B A4 24 E4 00 00 00 C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "___common_dlog_cout_rare"
		size = 688
		refs = "003a __imldLnHATab 0063 _2il0floatpacket_70 0248 _2il0floatpacket_71"
	strings:
		$1 = { 55 8B EC 83 E4 F8 83 EC 18 8B 45 08 0F B7 48 06 8B D1 81 E2 F0 7F 00 00 81 FA F0 7F 00 00 0F 84 3C 02 00 00 F2 0F 10 20 F7 C1 F0 7F 00 00 F2 0F 11 64 24 10 75 15 F2 0F 59 25 ?? ?? ?? ?? BA C4 FF FF FF F2 0F 11 64 24 10 EB 02 33 D2 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F E0 0F 86 C2 01 00 00 F2 0F 10 05 ?? ?? ?? ?? 0F 28 D4 F2 0F 5C D0 F2 0F 11 54 24 08 80 64 24 0F 7F F2 0F 10 4C 24 08 66 0F 2F 0D ?? ?? ?? ?? 0F 86 2B 01 00 00 F2 0F 11 64 24 08 0F B7 4C 24 0E 81 E1 0F 80 FF FF 81 C9 F0 3F FF FF 66 89 4C 24 0E F2 0F 10 74 24 08 0F 28 E6 0F 28 EE 0F B7 44 24 16 25 F0 7F 00 00 F2 0F 58 25 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? C1 E8 04 F2 0F 11 24 24 F2 0F 10 3D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B 4D 0C 8D 94 02 01 FC FF FF 8B 04 24 F2 0F 11 2C 24 83 E0 7F F2 0F 10 24 24 F2 0F 2A DA F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D3 F2 0F 5C F4 F2 0F 59 1D ?? ?? ?? ?? 8D 14 40 33 C0 F2 0F 10 0C D5 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 1C D5 ?? ?? ?? ?? F2 0F 58 14 D5 ?? ?? ?? ?? F2 0F 59 CE F2 0F 5C E0 0F 28 C4 F2 0F 58 E2 F2 0F 58 C1 F2 0F 58 CB F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 59 F8 F2 0F 58 CF F2 0F 58 E1 F2 0F 11 21 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C2 8B 45 0C F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 59 C2 F2 0F 58 D0 F2 0F 11 10 33 C0 8B E5 5D C3 66 0F 2E E0 7A 02 74 14 F2 0F 5E C0 8B 45 0C F2 0F 11 00 B8 01 00 00 00 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? 0F 57 0D ?? ?? ?? ?? F2 0F 5E C8 8B 45 0C F2 0F 11 08 B8 02 00 00 00 8B E5 5D C3 0F B6 50 07 F7 C2 80 00 00 00 75 15 F2 0F 10 00 F2 0F 59 C0 8B 45 0C F2 0F 11 00 33 C0 8B E5 5D C3 F7 40 04 FF FF 0F 00 75 E2 83 38 00 75 DD F2 0F 10 05 ?? ?? ?? ?? F2 0F 5E C0 8B 45 0C F2 0F 11 00 B8 01 00 00 00 8B E5 5D C3 EB 03 CC CC CC }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "___sse2_acos2"
		size = 528
		refs = "001a _static_const_table"
	strings:
		$1 = { 8B C4 81 EC 30 01 00 00 83 E4 F0 89 84 24 F4 00 00 00 66 0F 28 C8 66 0F 28 05 ?? ?? ?? ?? 66 0F 57 D2 66 0F C2 D1 05 66 0F 29 94 24 C0 00 00 00 66 0F 54 C1 66 0F 28 D9 66 0F 55 1D ?? ?? ?? ?? 66 0F 29 9C 24 B0 00 00 00 66 0F 29 44 24 10 66 0F 55 C1 66 0F 28 E0 66 0F C2 25 ?? ?? ?? ?? 05 66 0F 28 3D ?? ?? ?? ?? 66 0F 29 04 24 66 0F 5C F8 66 0F 59 C0 66 0F 59 3D ?? ?? ?? ?? 66 0F 28 D4 66 0F 54 FC 66 0F 55 D0 66 0F 56 D7 66 0F 51 F7 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 D8 66 0F C2 DD 00 66 0F 29 5C 24 20 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 84 24 B0 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 56 4C 24 10 66 0F 28 DC 66 0F 54 CC 66 0F 55 D8 66 0F 56 CB 66 0F 29 4C 24 70 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 54 8C 24 C0 00 00 00 66 0F 28 DC 66 0F 54 CC 66 0F 55 D8 66 0F 56 CB 66 0F 29 8C 24 80 00 00 00 66 0F 28 CA 66 0F 59 D2 66 0F 28 C2 66 0F 59 05 ?? ?? ?? ?? 66 0F 28 DA 66 0F 59 1D ?? ?? ?? ?? 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 28 EC 66 0F 55 2C 24 66 0F 54 F4 66 0F 56 F5 66 0F 29 74 24 40 66 0F 28 6C 24 20 66 0F 28 74 24 20 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 59 C8 66 0F 58 CB 66 0F 28 1D ?? ?? ?? ?? 66 0F 54 9C 24 C0 00 00 00 66 0F 59 4C 24 40 66 0F 58 4C 24 40 66 0F 59 4C 24 70 66 0F 58 8C 24 80 00 00 00 66 0F 54 EB 66 0F 55 F1 66 0F 56 F5 66 0F 28 C6 66 0F 28 C6 8B A4 24 F4 00 00 00 C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_176_35_0 {
	meta:
		name = "?AssociateExecutionContext@FreeThreadProxy@details@Concurrency@@QAEXPAUIExecutionContext@3@@Z"
		size = 21
	strings:
		$1 = { 55 8B EC 8B D1 8B 4D 08 52 89 4A 40 8B 01 FF 50 0C 5D C2 04 00 }
	condition:
		$1
}

rule file_176_36_0 {
	meta:
		name = "?Dispatch@FreeThreadProxy@details@Concurrency@@EAEXXZ"
		size = 125
		refs = "002a ?__TlsSetValue@platform@details@Concurrency@@YAXKPAX@Z 0057 ?ReturnIdleProxy@FreeThreadProxy@details@Concurrency@@QAEXXZ 0064 ?ResetOnIdle@FreeVirtualProcessorRoot@details@Concurrency@@QAEXW4SwitchingProxyState@3@@Z 006d ?SuspendExecution@ThreadProxy@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 51 53 56 8B F1 C7 45 F8 08 00 00 00 33 DB 89 5D FC 39 5E 24 75 5D 8B 4E 04 8B C6 83 C8 01 50 8B 01 FF 50 10 50 E8 ?? ?? ?? ?? 59 59 39 5E 24 75 42 57 8B 4E 40 56 8B 01 FF 50 0C 8B 4E 40 8D 55 F8 52 8B 01 FF 50 10 8B 7E 10 8B CE 89 5E 40 89 5E 10 E8 ?? ?? ?? ?? 85 FF 74 0B 6A 01 8B CF E8 ?? ?? ?? ?? EB 07 8B CE E8 ?? ?? ?? ?? 39 5E 24 74 C0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_176_39_0 {
	meta:
		name = "?ReturnIdleProxy@FreeThreadProxy@details@Concurrency@@QAEXXZ"
		size = 16
	strings:
		$1 = { 8B D1 52 8B 4A 04 83 62 40 00 8B 01 FF 50 04 C3 }
	condition:
		$1
}

rule file_176_40_0 {
	meta:
		name = "?SwitchOut@FreeThreadProxy@details@Concurrency@@UAEXW4SwitchingProxyState@3@@Z"
		size = 100
		refs = "002a ?ResetOnIdle@FreeVirtualProcessorRoot@details@Concurrency@@QAEXW4SwitchingProxyState@3@@Z 0035 ?SuspendExecution@ThreadProxy@details@Concurrency@@QAEXXZ 0041 ??_C@_0M@CIMHMGAD@switchState?$AA@ 004a ??0exception@std@@QAE@ABQBD@Z 004f __TI3?AVinvalid_argument@std@@ 0059 ??_7invalid_argument@std@@6B@ 005f __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 0C 85 C0 74 2E 8B 51 10 85 D2 75 09 83 F8 01 75 22 85 D2 74 17 83 F8 02 75 04 83 61 10 00 50 8B CA E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 E8 ?? ?? ?? ?? EB F3 8D 45 08 C7 45 08 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 C7 45 F4 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_176_41_0 {
	meta:
		name = "?SwitchTo@FreeThreadProxy@details@Concurrency@@UAEXPAUIExecutionContext@3@W4SwitchingProxyState@3@@Z"
		size = 166
		refs = "0046 ?Affinitize@FreeVirtualProcessorRoot@details@Concurrency@@QAEXPAVFreeThreadProxy@23@@Z 005d ?__SignalObjectAndWait@platform@details@Concurrency@@YAKPAX0KH@Z 0070 ?ResumeExecution@ThreadProxy@details@Concurrency@@QAEXXZ 0083 ??_C@_08BAFMHLII@pContext?$AA@ 008c ??0exception@std@@QAE@ABQBD@Z 0091 __TI3?AVinvalid_argument@std@@ 009b ??_7invalid_argument@std@@6B@ 00a1 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 8B 5D 08 56 57 8B F9 85 DB 74 6B 8B 03 8B CB FF 50 08 8B F0 85 F6 75 0E 8B 47 10 53 8B 48 1C 8B 01 FF 50 1C 8B F0 8B 4F 10 83 67 10 00 8B 5D 0C 83 FB 01 75 08 33 D2 8D 47 20 42 87 10 56 E8 ?? ?? ?? ?? 83 EB 00 74 1E 4B 75 1B 6A 01 6A FF FF 77 0C FF 76 0C E8 ?? ?? ?? ?? 83 C4 10 8D 47 20 33 C9 87 08 EB 07 8B CE E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 08 00 8D 45 08 C7 45 08 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 C7 45 F4 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "_fegetexceptflag"
		size = 36
		refs = "0014 __getfpstatusword"
	strings:
		$1 = { 55 8B EC 56 8B 75 0C 83 E6 1F 75 07 8B 45 08 21 30 EB 0C E8 ?? ?? ?? ?? 8B 4D 08 23 C6 89 01 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "_cacosh"
		size = 814
		refs = "0016 _creal 0027 _cimag 0033 __dtest 0063 __Inf_C 00c2 __real@4002d97c7f3321d2 00ca __real@3fe921fb54442d18 00de __real@400921fb54442d18 010c __real@bff921fb54442d18 0117 __real@3ff921fb54442d18 013b __Cbuild 014f _csqrt 01df __real@5fcffb3abd82527b 024d _asinh 0276 _log 02f4 _atan2"
	strings:
		$1 = { 55 8B EC 83 EC 58 53 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 0C DD 5D E8 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8D 45 E8 50 DD 5D F8 E8 ?? ?? ?? ?? 0F B7 F0 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 18 0F B7 C0 6A 02 59 66 3B F1 75 26 66 3B C1 75 05 DD 45 E8 EB 2D 66 83 F8 01 75 11 DD 05 ?? ?? ?? ?? DD 5D F0 DD 45 E8 E9 91 02 00 00 DD 45 E8 EB 1F 66 3B C1 75 22 66 83 FE 01 75 11 DD 05 ?? ?? ?? ?? DD 5D F0 DD 45 F8 E9 70 02 00 00 DD 45 F8 DD 55 F0 E9 65 02 00 00 33 DB 43 66 3B F3 75 4A DD 05 ?? ?? ?? ?? DD 5D F0 D9 EE 66 3B C3 75 1A DC 5D E8 DF E0 F6 C4 41 75 08 DD 05 ?? ?? ?? ?? EB 1A DD 05 ?? ?? ?? ?? EB 12 DC 55 E8 DF E0 F6 C4 41 75 08 DD D8 DD 05 ?? ?? ?? ?? 0F B7 45 FE A9 00 80 00 00 E9 0F 02 00 00 66 3B C3 75 2B DD 05 ?? ?? ?? ?? DD 5D F0 D9 EE DC 5D F8 DF E0 F6 C4 41 75 0B DD 05 ?? ?? ?? ?? E9 EE 01 00 00 DD 05 ?? ?? ?? ?? E9 E3 01 00 00 DD 45 F8 8D 45 A8 83 EC 10 D9 E0 DD 5C 24 08 DD 45 E8 D9 E8 DE E9 DD 1C 24 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 C8 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? DD 45 F8 8D 7D B8 8B F0 83 C4 04 8D 45 C8 DD 5C 24 08 DD 45 E8 D9 E8 A5 DE C1 A5 DD 1C 24 50 A5 A5 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 D8 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B F0 8D 7D A8 83 C4 04 A5 A5 A5 A5 8B FC 8D 75 B8 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 B8 DD 5D E0 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 A8 DD 5D D0 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 A8 DD 5D F0 A5 A5 A5 A5 E8 ?? ?? ?? ?? DD 55 C0 DD 05 ?? ?? ?? ?? 83 C4 10 DD 45 E0 D8 D1 DF E0 D9 EE F6 C4 41 75 0F DD D8 DD D9 DD 55 E0 DC 7D F0 DC 4D D0 EB 42 DD 45 D0 D8 D3 DF E0 F6 C4 41 75 0B DD D9 DD DA D9 C1 DD 5D E0 EB 16 D9 C0 D9 E0 DD 55 E0 D8 D4 DF E0 DD DC F6 C4 41 75 0F DD D9 DD D8 D9 CA DE F1 DE C9 DC 65 F0 EB 0C DD DB DD 5D E0 DE CA DC 4D F0 DE E9 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 55 F0 DD 45 E0 83 C4 08 D9 EE DD E1 DF E0 F6 C4 44 7B 29 D8 DA DF E0 51 51 DD D9 DD 1C 24 F6 C4 41 7A 0F E8 ?? ?? ?? ?? DC 45 F0 59 DD 5D F0 59 EB 10 E8 ?? ?? ?? ?? DC 6D F0 EB EF DD D9 DD D9 DD D8 0F B7 45 FE DD 45 F8 A9 00 80 00 00 74 07 D9 E0 DD 55 F8 EB 02 33 DB 83 EC 10 8D 45 A8 DD 5C 24 08 DD 45 E8 D9 E8 DE E9 DD 1C 24 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 C8 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? DD 45 C0 8B F0 51 DD 5C 24 10 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 59 59 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DC C0 85 DB 74 02 D9 E0 83 EC 10 8D 45 A8 DD 5C 24 08 DD 45 F0 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_1170_1_0 {
	meta:
		name = "_cacoshl"
		size = 814
		refs = "0016 _creall 0027 _cimagl 0033 __ldtest 0063 __LInf_C 00c2 __real@4002d97c7f3321d2 00ca __real@3fe921fb54442d18 00de __real@400921fb54442d18 010c __real@bff921fb54442d18 0117 __real@3ff921fb54442d18 013b __LCbuild 014f _csqrtl 01df __real@5fcffb3abd82527b 024d _asinhl 0276 _log 02f4 _atan2l"
	strings:
		$1 = { 55 8B EC 83 EC 58 53 56 57 83 EC 10 8D 75 0C 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 0C DD 5D E8 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8D 45 E8 50 DD 5D F8 E8 ?? ?? ?? ?? 0F B7 F0 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 18 0F B7 C0 6A 02 59 66 3B F1 75 26 66 3B C1 75 05 DD 45 E8 EB 2D 66 83 F8 01 75 11 DD 05 ?? ?? ?? ?? DD 5D F0 DD 45 E8 E9 91 02 00 00 DD 45 E8 EB 1F 66 3B C1 75 22 66 83 FE 01 75 11 DD 05 ?? ?? ?? ?? DD 5D F0 DD 45 F8 E9 70 02 00 00 DD 45 F8 DD 55 F0 E9 65 02 00 00 33 DB 43 66 3B F3 75 4A DD 05 ?? ?? ?? ?? DD 5D F0 D9 EE 66 3B C3 75 1A DC 5D E8 DF E0 F6 C4 41 75 08 DD 05 ?? ?? ?? ?? EB 1A DD 05 ?? ?? ?? ?? EB 12 DC 55 E8 DF E0 F6 C4 41 75 08 DD D8 DD 05 ?? ?? ?? ?? 0F B7 45 FE A9 00 80 00 00 E9 0F 02 00 00 66 3B C3 75 2B DD 05 ?? ?? ?? ?? DD 5D F0 D9 EE DC 5D F8 DF E0 F6 C4 41 75 0B DD 05 ?? ?? ?? ?? E9 EE 01 00 00 DD 05 ?? ?? ?? ?? E9 E3 01 00 00 DD 45 F8 8D 45 A8 83 EC 10 D9 E0 DD 5C 24 08 DD 45 E8 D9 E8 DE E9 DD 1C 24 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 C8 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? DD 45 F8 8D 7D B8 8B F0 83 C4 04 8D 45 C8 DD 5C 24 08 DD 45 E8 D9 E8 A5 DE C1 A5 DD 1C 24 50 A5 A5 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 D8 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B F0 8D 7D A8 83 C4 04 A5 A5 A5 A5 8B FC 8D 75 B8 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 B8 DD 5D E0 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 A8 DD 5D D0 A5 A5 A5 A5 E8 ?? ?? ?? ?? 8B FC 8D 75 A8 DD 5D F0 A5 A5 A5 A5 E8 ?? ?? ?? ?? DD 55 C0 DD 05 ?? ?? ?? ?? 83 C4 10 DD 45 E0 D8 D1 DF E0 D9 EE F6 C4 41 75 0F DD D8 DD D9 DD 55 E0 DC 7D F0 DC 4D D0 EB 42 DD 45 D0 D8 D3 DF E0 F6 C4 41 75 0B DD D9 DD DA D9 C1 DD 5D E0 EB 16 D9 C0 D9 E0 DD 55 E0 D8 D4 DF E0 DD DC F6 C4 41 75 0F DD D9 DD D8 D9 CA DE F1 DE C9 DC 65 F0 EB 0C DD DB DD 5D E0 DE CA DC 4D F0 DE E9 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 55 F0 DD 45 E0 83 C4 08 D9 EE DD E1 DF E0 F6 C4 44 7B 29 D8 DA DF E0 51 51 DD D9 DD 1C 24 F6 C4 41 7A 0F E8 ?? ?? ?? ?? DC 45 F0 59 DD 5D F0 59 EB 10 E8 ?? ?? ?? ?? DC 6D F0 EB EF DD D9 DD D9 DD D8 0F B7 45 FE DD 45 F8 A9 00 80 00 00 74 07 D9 E0 DD 55 F8 EB 02 33 DB 83 EC 10 8D 45 A8 DD 5C 24 08 DD 45 E8 D9 E8 DE E9 DD 1C 24 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B FC 8D 45 C8 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? DD 45 C0 8B F0 51 DD 5C 24 10 8B FC A5 A5 A5 A5 E8 ?? ?? ?? ?? 59 59 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DC C0 85 DB 74 02 D9 E0 83 EC 10 8D 45 A8 DD 5C 24 08 DD 45 F0 DD 1C 24 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 8B 45 08 8B F8 A5 A5 A5 A5 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "__fputchar"
		size = 24
		refs = "0004 ___iob_func 0010 _putc"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 83 C0 20 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "__fputwchar"
		size = 24
		refs = "0004 ___iob_func 0010 _fputwc"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 83 C0 20 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "__getcwd"
		size = 21
		refs = "000c __getdcwd"
	strings:
		$1 = { 55 8B EC FF 75 0C FF 75 08 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1235_0_0 {
	meta:
		name = "__wgetcwd"
		size = 21
		refs = "000c __wgetdcwd"
	strings:
		$1 = { 55 8B EC FF 75 0C FF 75 08 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_181_1_0 {
	meta:
		name = "__getdcwd"
		size = 284
		refs = "000f __validdrive 0019 ___doserrno 0024 __errno 002f __invalid_parameter_noinfo 003b __getdrive 0093 __imp__GetFullPathNameA@16 00ca _calloc 0108 __imp__GetLastError@0 010e __dosmaperr"
	strings:
		$1 = { 55 8B EC 51 51 53 8B 5D 08 85 DB 74 2D 53 E8 ?? ?? ?? ?? 59 85 C0 75 29 E8 ?? ?? ?? ?? C7 00 0F 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 DD 00 00 00 E8 ?? ?? ?? ?? 8B D8 56 8B 75 10 57 8B 7D 0C 85 FF 74 23 85 F6 7F 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 AD 00 00 00 8B C6 89 75 FC C6 07 00 EB 05 33 C0 89 45 FC 85 DB 74 12 80 C3 40 66 C7 45 09 3A 2E 88 5D 08 C6 45 0B 00 EB 06 66 C7 45 08 2E 00 8B 1D ?? ?? ?? ?? 8D 4D F8 51 57 50 8D 45 08 50 FF D3 85 C0 74 5F 85 FF 74 15 3B 45 FC 7C 52 E8 ?? ?? ?? ?? C7 00 22 00 00 00 C6 07 00 EB 53 3B C6 7E 02 8B F0 6A 01 56 E8 ?? ?? ?? ?? 8B F8 59 59 85 FF 75 18 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? C7 00 08 00 00 00 EB 25 8D 45 F8 50 57 56 8D 45 08 50 FF D3 85 C0 74 08 3B C6 7D 04 8B C7 EB 0F FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 33 C0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_181_2_0 {
	meta:
		name = "__validdrive"
		size = 124
		refs = "0007 ___security_cookie 0019 ___doserrno 0024 __errno 002f __invalid_parameter_noinfo 005f __imp__GetDriveTypeW@4 0074 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 83 F8 1A 76 1D E8 ?? ?? ?? ?? C7 00 0F 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 E8 ?? ?? ?? ?? EB 37 85 C0 75 05 33 C0 40 EB 30 83 C0 40 6A 3A 66 89 45 F4 58 66 89 45 F6 6A 5C 58 66 89 45 F8 33 C0 66 89 45 FA 8D 45 F4 50 FF 15 ?? ?? ?? ?? 85 C0 74 05 83 F8 01 75 CD 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "__ctime64"
		size = 109
		refs = "0007 ___security_cookie 0018 __errno 0023 __invalid_parameter_noinfo 002f @__security_check_cookie@4 0057 __localtime64_s 0066 _asctime"
	strings:
		$1 = { 55 8B EC 83 EC 28 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 85 C0 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 83 78 04 00 7F 14 7C 05 83 38 00 73 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB D6 50 8D 45 D8 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 C6 8D 45 D8 50 E8 ?? ?? ?? ?? 59 EB BC }
	condition:
		$1
}

rule file_1094_0_0 {
	meta:
		name = "__wctime64"
		size = 109
		refs = "0007 ___security_cookie 0018 __errno 0023 __invalid_parameter_noinfo 002f @__security_check_cookie@4 0057 __localtime64_s 0066 __wasctime"
	strings:
		$1 = { 55 8B EC 83 EC 28 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 85 C0 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 83 78 04 00 7F 14 7C 05 83 38 00 73 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB D6 50 8D 45 D8 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 C6 8D 45 D8 50 E8 ?? ?? ?? ?? 59 EB BC }
	condition:
		$1
}

rule file_183_1_0 {
	meta:
		name = "__ctime64_s"
		size = 146
		refs = "0007 ___security_cookie 0035 __errno 0056 __localtime64_s 0069 _asctime_s 007d __invalid_parameter_noinfo 008a @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 28 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 10 56 8B 75 08 85 F6 74 57 83 7D 0C 00 76 51 33 C9 88 0E 85 C0 74 49 39 48 04 7F 12 7C 04 39 08 73 0C E8 ?? ?? ?? ?? 6A 16 5E 89 30 EB 41 83 78 04 07 7C 0A 7F EC 81 38 FF 6F 40 93 77 E4 50 8D 45 D8 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 23 8D 45 D8 50 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C EB 11 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "__get_printf_count_output"
		size = 21
		refs = "0002 ___security_cookie 000d ___enable_percent_n"
	strings:
		$1 = { 8B 0D ?? ?? ?? ?? 33 C0 83 C9 01 39 0D ?? ?? ?? ?? 0F 94 C0 C3 }
	condition:
		$1
}

rule file_184_5_0 {
	meta:
		name = "__set_printf_count_output"
		size = 40
		refs = "0005 ___security_cookie 0013 ___enable_percent_n"
	strings:
		$1 = { 55 8B EC 8B 15 ?? ?? ?? ?? 33 C0 8B 4D 08 83 CA 01 39 15 ?? ?? ?? ?? 0F 94 C0 F7 D9 1B C9 23 CA 89 0D ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_184_6_0 {
	meta:
		name = "_printf"
		size = 175
		refs = "0003 __sehtable$_printf 0008 __SEH_prolog4 001e __errno 0029 __invalid_parameter_noinfo 0033 ___iob_func 003e __lock_file2 0051 __stbuf 006a __output_l 007e __ftbuf 0094 __SEH_epilog4 00a8 __unlock_file2"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 33 C0 39 45 08 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 61 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 89 7D FC E8 ?? ?? ?? ?? 83 C0 20 50 E8 ?? ?? ?? ?? 59 8B F0 8D 45 0C 50 57 FF 75 08 E8 ?? ?? ?? ?? 83 C0 20 50 E8 ?? ?? ?? ?? 8B F8 89 7D E4 E8 ?? ?? ?? ?? 83 C0 20 50 56 E8 ?? ?? ?? ?? 83 C4 18 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C7 E8 ?? ?? ?? ?? C3 8B 7D E4 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_1198_4_0 {
	meta:
		name = "_wprintf"
		size = 175
		refs = "0003 __sehtable$_wprintf 0008 __SEH_prolog4 001e __errno 0029 __invalid_parameter_noinfo 0033 ___iob_func 003e __lock_file2 0051 __stbuf 006a __woutput_l 007e __ftbuf 0094 __SEH_epilog4 00a8 __unlock_file2"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 33 C0 39 45 08 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 61 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 89 7D FC E8 ?? ?? ?? ?? 83 C0 20 50 E8 ?? ?? ?? ?? 59 8B F0 8D 45 0C 50 57 FF 75 08 E8 ?? ?? ?? ?? 83 C0 20 50 E8 ?? ?? ?? ?? 8B F8 89 7D E4 E8 ?? ?? ?? ?? 83 C0 20 50 56 E8 ?? ?? ?? ?? 83 C4 18 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C7 E8 ?? ?? ?? ?? C3 8B 7D E4 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "?_fpcvt@@YAHPADIPAU_strflt@@HPAH2@Z"
		size = 117
		refs = "001c __errno 0026 __invalid_parameter_noinfo 0042 __fptostr"
	strings:
		$1 = { 55 8B EC 8B 4D 14 85 C9 7E 04 8B C1 EB 02 33 C0 8B 55 0C 83 C0 02 56 3B D0 73 13 E8 ?? ?? ?? ?? 6A 22 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 44 8D 42 FE 3B C8 7F 02 8B C1 57 8B 7D 10 57 50 52 FF 75 08 E8 ?? ?? ?? ?? 8B F0 83 C4 10 85 F6 74 0B E8 ?? ?? ?? ?? 89 30 8B C6 EB 17 8B 45 1C 33 C9 83 3F 2D 0F 94 C1 89 08 8B 45 18 8B 4F 04 89 08 33 C0 5F 5E 5D C3 }
	condition:
		$1
}

rule file_185_1_0 {
	meta:
		name = "__ecvt"
		size = 95
		refs = "0005 __getptd_noexit 001d __malloc_crt 004c __ecvt_s"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 4D 83 7E 48 00 57 BF 5D 01 00 00 75 0E 57 E8 ?? ?? ?? ?? 89 46 48 59 85 C0 74 32 8B 45 10 B9 5B 01 00 00 8B 76 48 3B C1 7C 02 8B C1 FF 75 18 DD 45 08 FF 75 14 50 51 51 DD 1C 24 57 56 E8 ?? ?? ?? ?? 83 C4 1C F7 D8 1B C0 F7 D0 23 C6 5F 5E 5D C3 }
	condition:
		$1
}

rule file_185_2_0 {
	meta:
		name = "__ecvt_s"
		size = 176
		refs = "0007 ___security_cookie 0029 __errno 0033 __invalid_parameter_noinfo 0072 __fltout2 0081 ?_fpcvt@@YAHPADIPAU_strflt@@HPAH2@Z 00a8 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 34 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 1C 8B 4D 20 56 8B 75 18 57 8B 7D 08 89 45 E0 89 4D DC 85 FF 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 65 53 8B 5D 0C 85 DB 74 0B C6 07 00 85 C0 74 04 85 C9 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 3E 6A 16 8D 45 E4 50 8D 45 CC 50 FF 75 14 FF 75 10 E8 ?? ?? ?? ?? FF 75 DC FF 75 E0 56 50 53 57 E8 ?? ?? ?? ?? 83 C3 FE 83 C4 2C 3B F3 7E 02 8B F3 85 F6 78 0A 80 3C 3E 00 74 04 C6 04 3E 00 5B 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_185_3_0 {
	meta:
		name = "__fcvt"
		size = 158
		refs = "0007 ___security_cookie 001a __getptd_noexit 0034 __malloc_crt 0054 __fltout2 007e __fcvt_s 0096 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 18 56 57 8B 7D 14 E8 ?? ?? ?? ?? 8B F0 85 F6 75 04 33 C0 EB 65 83 7E 48 00 75 12 68 5D 01 00 00 E8 ?? ?? ?? ?? 89 46 48 59 85 C0 74 E4 8B 76 48 8D 45 E4 6A 16 50 8D 45 D4 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? B9 5B 01 00 00 83 C4 14 2B 48 04 8B 45 10 3B C1 7C 02 8B C1 DD 45 08 53 57 50 51 51 DD 1C 24 68 5D 01 00 00 56 E8 ?? ?? ?? ?? 83 C4 1C F7 D8 1B C0 F7 D0 23 C6 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_185_4_0 {
	meta:
		name = "__fcvt_s"
		size = 156
		refs = "0007 ___security_cookie 0021 __errno 002b __invalid_parameter_noinfo 0055 __fltout2 0084 ?_fpcvt@@YAHPADIPAU_strflt@@HPAH2@Z 0094 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 20 56 8B 75 08 57 8B 7D 1C 85 F6 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 58 83 7D 0C 00 76 E7 C6 06 00 85 FF 74 E0 85 DB 74 DC 6A 16 8D 45 E4 50 8D 45 D0 50 FF 75 14 FF 75 10 E8 ?? ?? ?? ?? 8B 55 18 83 C4 14 89 45 E0 8B 40 04 8D 0C 10 85 D2 7E 0D 85 C0 7E 09 3B CA 7D 05 B9 FF FF FF 7F 53 57 51 FF 75 E0 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 18 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "__dpow"
		size = 1826
		refs = "000a ___security_cookie 0034 __dunscale 004b __d_int 008f __real@3fe0000000000000 00a8 __real@bfe0000000000000 00f4 __fperrraise 00fa __Nan_C 014c __real@4000000000000000 0157 __real@3fe6a09e667f3bcd 017a _scale 0185 __ftol2_sse 01be _lnbias 01eb __dlogpoly 0248 __real@3fe62e42fefa39ef 0267 __real@c0e0000000000000 0287 __real@c02e000000000000 0298 __real@402e000000000000 02ad __real@c044000000000000 02ba __real@4044000000000000 033e __real@40e0000000000000 035e __dxp_setw 038c __dxp_addx 03bd _log2e 03c5 _memcpy 03d7 __dxp_mulh 046e __dxp_addh 054c __dxp_getw 0589 __dexp 05a8 __Inf_C 0626 @__security_check_cookie@4 0671 __Zero_C"
	strings:
		$1 = { 55 8B EC 81 EC F0 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC DD 45 10 8D 45 08 53 8B 5D 18 56 57 50 8D 85 58 FF FF FF 89 9D 28 FF FF FF 50 DD 9D 34 FF FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 44 FF FF FF 8D 85 34 FF FF FF 6A 00 50 E8 ?? ?? ?? ?? 83 C4 10 0F B7 F8 85 DB 74 05 33 C0 66 89 03 D9 EE DD 45 10 66 85 FF 75 09 DD E1 DF E0 F6 C4 44 7B 48 8B 95 44 FF FF FF 33 F6 DD 45 08 46 66 8B 8D 58 FF FF FF 66 85 D2 0F 89 4B 05 00 00 DD 05 ?? ?? ?? ?? 66 3B CE 75 2C DD E1 DF E0 F6 C4 44 7B 14 66 3B FE 75 1E DD 05 ?? ?? ?? ?? DD EA DF E0 F6 C4 44 7A 0F DD DB DD DA DD D9 DD D8 D9 E8 E9 59 05 00 00 33 C0 66 3B C2 0F 8E 07 05 00 00 66 3B C7 0F 8C FE 04 00 00 8B 45 0E DD DA 0F B7 C0 A9 00 80 00 00 74 1D 66 85 FF 79 18 DD DA DD D8 56 DD D8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 E9 19 05 00 00 D8 D2 DF E0 DD DA F6 C4 41 75 09 83 A5 44 FF FF FF 00 EB 30 DD D8 8D 85 34 FF FF FF 6A FF D9 E0 50 DD 5D 08 E8 ?? ?? ?? ?? DD 45 08 DD 05 ?? ?? ?? ?? 59 59 66 8B 8D 58 FF FF FF 0F B7 C0 89 85 44 FF FF FF D9 E8 DD 05 ?? ?? ?? ?? 66 3B CE 75 1F DD 05 ?? ?? ?? ?? D8 DC DF E0 F6 C4 41 75 10 DD DA 33 FF DD 95 50 FF FF FF D9 CA DE C9 EB 41 DD D9 DD D8 DD 05 ?? ?? ?? ?? DE CA DC C1 D9 C9 E8 ?? ?? ?? ?? 8D 78 E0 89 BD 54 FF FF FF DB 85 54 FF FF FF DD 9D 50 FF FF FF DD 85 50 FF FF FF DC 35 ?? ?? ?? ?? DE C1 DD 95 50 FF FF FF DD 45 08 D9 C0 C1 E7 05 D8 E2 81 C7 ?? ?? ?? ?? 51 51 DD 95 2C FF FF FF D9 CA DE C1 D9 C1 DE F1 DD 95 3C FF FF FF D9 C0 DE C9 DD 95 20 FF FF FF D9 C9 DD 5D 08 DD 1C 24 E8 ?? ?? ?? ?? DC 8D 20 FF FF FF DD 85 2C FF FF FF DC E9 0F BF 85 58 FF FF FF D9 E8 D9 C0 DC A5 50 FF FF FF 89 85 54 FF FF FF 59 59 DC 0D ?? ?? ?? ?? DE C3 DD 85 3C FF FF FF DE CB D9 CA DD 95 2C FF FF FF DE C1 DB 85 54 FF FF FF DD 9D 3C FF FF FF DD 85 3C FF FF FF DC 07 D9 C1 DD 05 ?? ?? ?? ?? DC F9 D9 C9 D8 C2 DD 95 34 FF FF FF DD 45 10 DC C9 D9 C9 DD 95 48 FF FF FF DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 11 DD D9 33 F6 DD DB DD DB DD D8 DD D9 E9 14 03 00 00 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 0F 85 98 00 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 0F 85 85 00 00 00 D9 C9 DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 75 7A DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 6B D9 EE D8 DA DF E0 DD 05 ?? ?? ?? ?? F6 C4 41 75 04 DE EA EB 02 DE C2 D9 C9 E8 ?? ?? ?? ?? DC CB D9 CB 89 85 54 FF FF FF DD 95 48 FF FF FF DD 47 10 DC 47 08 D8 CC DE CA DE C1 D9 C9 DE CA DB 85 54 FF FF FF DD 9D 3C FF FF FF DD 85 3C FF FF FF DE EA D9 C9 DC 0D ?? ?? ?? ?? DE C1 DD 9D 48 FF FF FF E9 44 02 00 00 DD D9 EB 02 DD D8 DD DB DD DB DD D8 DD D9 DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 0F 84 4C 02 00 00 51 DD D8 8D 45 DC DD 45 08 51 DD 1C 24 6A 04 50 E8 ?? ?? ?? ?? DD 85 2C FF FF FF 8D 85 10 FF FF FF 59 59 DD 1C 24 6A 02 5B 53 50 E8 ?? ?? ?? ?? 53 8D 85 10 FF FF FF 50 8D 45 DC 6A 04 50 E8 ?? ?? ?? ?? DD 45 DC 83 C4 20 D9 EE DD E1 DF E0 DD D9 F6 C4 44 8D 45 9C 7A 14 51 51 DD 1C 24 6A 04 5E 56 50 E8 ?? ?? ?? ?? 83 C4 10 EB 7C 6A 20 68 ?? ?? ?? ?? 50 DD D8 E8 ?? ?? ?? ?? DD 45 DC 8D 45 9C 59 DD 1C 24 6A 04 50 E8 ?? ?? ?? ?? 83 C4 10 DD 44 F5 DC D9 EE DA E9 DF E0 F6 C4 44 7B 46 6A 20 8D 85 7C FF FF FF 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? DD 44 F5 DC 8D 85 7C FF FF FF 59 DD 1C 24 6A 04 50 E8 ?? ?? ?? ?? 6A 04 8D 85 7C FF FF FF 50 8D 45 9C 6A 04 50 E8 ?? ?? ?? ?? 83 C4 20 46 83 FE 04 7C AB 6A 04 5E 6A 03 57 8D 45 9C 56 50 E8 ?? ?? ?? ?? 0F BF 85 58 FF FF FF 83 C4 08 89 85 54 FF FF FF 8D 45 9C DB 85 54 FF FF FF DD 9D 3C FF FF FF DD 85 3C FF FF FF DD 1C 24 56 50 E8 ?? ?? ?? ?? DD 45 10 8D 45 DC 59 59 DD 1C 24 53 50 E8 ?? ?? ?? ?? 6A 20 8D 45 9C 50 8D 45 BC 50 E8 ?? ?? ?? ?? DD 45 DC 8D 45 BC 83 C4 14 DD 1C 24 56 50 E8 ?? ?? ?? ?? DD 45 E4 83 C4 10 D9 EE DA E9 DF E0 F6 C4 44 7B 3B 6A 20 8D 45 9C 50 8D 85 5C FF FF FF 50 E8 ?? ?? ?? ?? DD 45 E4 8D 85 5C FF FF FF 59 DD 1C 24 56 50 E8 ?? ?? ?? ?? 56 8D 85 5C FF FF FF 50 8D 45 BC 56 50 E8 ?? ?? ?? ?? 83 C4 20 DD 45 BC DD 55 08 D9 EE DD E1 DF E0 F6 C4 44 7B 18 DD 45 C4 DD E1 DF E0 DD D9 F6 C4 44 7B 0E DC 45 CC DE C1 DD 5D 08 EB 08 DD D8 EB 02 DD D9 DD D8 8D 45 08 6A 00 50 E8 ?? ?? ?? ?? DD 45 08 8D 45 BC DD 95 3C FF FF FF D9 E0 DD 1C 24 56 50 E8 ?? ?? ?? ?? 8D 45 BC 56 50 E8 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? 83 C4 18 DD 9D 48 FF FF FF DD 85 3C FF FF FF E8 ?? ?? ?? ?? D9 E8 8B 9D 28 FF FF FF 85 DB 74 05 66 89 03 33 C0 50 51 51 8D 85 48 FF FF FF DD 1C 24 50 E8 ?? ?? ?? ?? DD 85 48 FF FF FF 83 C4 10 0F B7 F0 0F BF C6 83 E8 00 74 0F 48 75 24 DD D8 DD 05 ?? ?? ?? ?? 6A 08 EB 06 DD D8 D9 EE 6A 10 DD 9D 48 FF FF FF E8 ?? ?? ?? ?? DD 85 48 FF FF FF 59 66 83 BD 44 FF FF FF 00 74 4B D9 E0 EB 47 DD D8 6A 02 5B 66 3B D3 75 06 DD DA DD D8 EB 37 DD D8 66 3B FB 75 04 DD D9 EB 2C DD D8 66 3B D6 0F 85 82 00 00 00 8B 45 0E BE 00 80 00 00 0F B7 C0 85 C6 8B 45 16 0F B7 C0 75 1D 85 C6 75 08 DD D8 DD 05 ?? ?? ?? ?? 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 85 C6 75 21 DD D8 66 85 FF 75 DE 8D 85 34 FF FF FF 6A FF 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 79 C9 E9 C4 00 00 00 66 85 FF 75 C5 8D 85 34 FF FF FF DD D8 6A FF 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 79 0B DD 05 ?? ?? ?? ?? E9 58 FF FF FF D9 EE EB 9F 8B 45 16 0F B7 C0 66 3B FE 75 1F A9 00 80 00 00 75 0A 66 85 C9 7E 88 E9 7B FF FF FF 66 85 C9 0F 8F 7A FF FF FF E9 6D FF FF FF BE 00 80 00 00 85 C6 75 2C 66 85 FF 0F 85 63 FF FF FF 8D 85 34 FF FF FF DD D8 6A FF 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 79 A9 8B 45 0E 0F B7 C0 85 C6 74 9F EB 92 6A 04 DD D8 E8 ?? ?? ?? ?? 59 66 85 FF 0F 85 27 FF FF FF 8D 85 34 FF FF FF 6A FF 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 0F 89 0E FF FF FF 8B 45 0E 0F B7 C0 85 C6 0F 84 00 FF FF FF DD 05 ?? ?? ?? ?? E9 B0 FE FF FF }
	condition:
		$1
}

rule file_1286_0_0 {
	meta:
		name = "__ldpow"
		size = 1826
		refs = "000a ___security_cookie 0034 __ldunscale 004b __ld_int 008f __real@3fe0000000000000 00a8 __real@bfe0000000000000 00f4 __fperrraise 00fa __LNan_C 014c __real@4000000000000000 0157 __real@3fe6a09e667f3bcd 017a _scale 0185 __ftol2_sse 01be _lnbias 01eb __ldlogpoly 0248 __real@3fe62e42fefa39ef 0267 __real@c0e0000000000000 0287 __real@c02e000000000000 0298 __real@402e000000000000 02ad __real@c044000000000000 02ba __real@4044000000000000 033e __real@40e0000000000000 035e __ldxp_setw 038c __ldxp_addx 03bd _log2e 03c5 _memcpy 03d7 __ldxp_mulh 046e __ldxp_addh 054c __ldxp_getw 0589 __ldexp 05a8 __LInf_C 0626 @__security_check_cookie@4 0671 __LZero_C"
	strings:
		$1 = { 55 8B EC 81 EC F0 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC DD 45 10 8D 45 08 53 8B 5D 18 56 57 50 8D 85 58 FF FF FF 89 9D 28 FF FF FF 50 DD 9D 34 FF FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 44 FF FF FF 8D 85 34 FF FF FF 6A 00 50 E8 ?? ?? ?? ?? 83 C4 10 0F B7 F8 85 DB 74 05 33 C0 66 89 03 D9 EE DD 45 10 66 85 FF 75 09 DD E1 DF E0 F6 C4 44 7B 48 8B 95 44 FF FF FF 33 F6 DD 45 08 46 66 8B 8D 58 FF FF FF 66 85 D2 0F 89 4B 05 00 00 DD 05 ?? ?? ?? ?? 66 3B CE 75 2C DD E1 DF E0 F6 C4 44 7B 14 66 3B FE 75 1E DD 05 ?? ?? ?? ?? DD EA DF E0 F6 C4 44 7A 0F DD DB DD DA DD D9 DD D8 D9 E8 E9 59 05 00 00 33 C0 66 3B C2 0F 8E 07 05 00 00 66 3B C7 0F 8C FE 04 00 00 8B 45 0E DD DA 0F B7 C0 A9 00 80 00 00 74 1D 66 85 FF 79 18 DD DA DD D8 56 DD D8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 E9 19 05 00 00 D8 D2 DF E0 DD DA F6 C4 41 75 09 83 A5 44 FF FF FF 00 EB 30 DD D8 8D 85 34 FF FF FF 6A FF D9 E0 50 DD 5D 08 E8 ?? ?? ?? ?? DD 45 08 DD 05 ?? ?? ?? ?? 59 59 66 8B 8D 58 FF FF FF 0F B7 C0 89 85 44 FF FF FF D9 E8 DD 05 ?? ?? ?? ?? 66 3B CE 75 1F DD 05 ?? ?? ?? ?? D8 DC DF E0 F6 C4 41 75 10 DD DA 33 FF DD 95 50 FF FF FF D9 CA DE C9 EB 41 DD D9 DD D8 DD 05 ?? ?? ?? ?? DE CA DC C1 D9 C9 E8 ?? ?? ?? ?? 8D 78 E0 89 BD 54 FF FF FF DB 85 54 FF FF FF DD 9D 50 FF FF FF DD 85 50 FF FF FF DC 35 ?? ?? ?? ?? DE C1 DD 95 50 FF FF FF DD 45 08 D9 C0 C1 E7 05 D8 E2 81 C7 ?? ?? ?? ?? 51 51 DD 95 2C FF FF FF D9 CA DE C1 D9 C1 DE F1 DD 95 3C FF FF FF D9 C0 DE C9 DD 95 20 FF FF FF D9 C9 DD 5D 08 DD 1C 24 E8 ?? ?? ?? ?? DC 8D 20 FF FF FF DD 85 2C FF FF FF DC E9 0F BF 85 58 FF FF FF D9 E8 D9 C0 DC A5 50 FF FF FF 89 85 54 FF FF FF 59 59 DC 0D ?? ?? ?? ?? DE C3 DD 85 3C FF FF FF DE CB D9 CA DD 95 2C FF FF FF DE C1 DB 85 54 FF FF FF DD 9D 3C FF FF FF DD 85 3C FF FF FF DC 07 D9 C1 DD 05 ?? ?? ?? ?? DC F9 D9 C9 D8 C2 DD 95 34 FF FF FF DD 45 10 DC C9 D9 C9 DD 95 48 FF FF FF DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 11 DD D9 33 F6 DD DB DD DB DD D8 DD D9 E9 14 03 00 00 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 0F 85 98 00 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 0F 85 85 00 00 00 D9 C9 DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 75 7A DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 6B D9 EE D8 DA DF E0 DD 05 ?? ?? ?? ?? F6 C4 41 75 04 DE EA EB 02 DE C2 D9 C9 E8 ?? ?? ?? ?? DC CB D9 CB 89 85 54 FF FF FF DD 95 48 FF FF FF DD 47 10 DC 47 08 D8 CC DE CA DE C1 D9 C9 DE CA DB 85 54 FF FF FF DD 9D 3C FF FF FF DD 85 3C FF FF FF DE EA D9 C9 DC 0D ?? ?? ?? ?? DE C1 DD 9D 48 FF FF FF E9 44 02 00 00 DD D9 EB 02 DD D8 DD DB DD DB DD D8 DD D9 DC 15 ?? ?? ?? ?? DF E0 F6 C4 41 0F 84 4C 02 00 00 51 DD D8 8D 45 DC DD 45 08 51 DD 1C 24 6A 04 50 E8 ?? ?? ?? ?? DD 85 2C FF FF FF 8D 85 10 FF FF FF 59 59 DD 1C 24 6A 02 5B 53 50 E8 ?? ?? ?? ?? 53 8D 85 10 FF FF FF 50 8D 45 DC 6A 04 50 E8 ?? ?? ?? ?? DD 45 DC 83 C4 20 D9 EE DD E1 DF E0 DD D9 F6 C4 44 8D 45 9C 7A 14 51 51 DD 1C 24 6A 04 5E 56 50 E8 ?? ?? ?? ?? 83 C4 10 EB 7C 6A 20 68 ?? ?? ?? ?? 50 DD D8 E8 ?? ?? ?? ?? DD 45 DC 8D 45 9C 59 DD 1C 24 6A 04 50 E8 ?? ?? ?? ?? 83 C4 10 DD 44 F5 DC D9 EE DA E9 DF E0 F6 C4 44 7B 46 6A 20 8D 85 7C FF FF FF 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? DD 44 F5 DC 8D 85 7C FF FF FF 59 DD 1C 24 6A 04 50 E8 ?? ?? ?? ?? 6A 04 8D 85 7C FF FF FF 50 8D 45 9C 6A 04 50 E8 ?? ?? ?? ?? 83 C4 20 46 83 FE 04 7C AB 6A 04 5E 6A 03 57 8D 45 9C 56 50 E8 ?? ?? ?? ?? 0F BF 85 58 FF FF FF 83 C4 08 89 85 54 FF FF FF 8D 45 9C DB 85 54 FF FF FF DD 9D 3C FF FF FF DD 85 3C FF FF FF DD 1C 24 56 50 E8 ?? ?? ?? ?? DD 45 10 8D 45 DC 59 59 DD 1C 24 53 50 E8 ?? ?? ?? ?? 6A 20 8D 45 9C 50 8D 45 BC 50 E8 ?? ?? ?? ?? DD 45 DC 8D 45 BC 83 C4 14 DD 1C 24 56 50 E8 ?? ?? ?? ?? DD 45 E4 83 C4 10 D9 EE DA E9 DF E0 F6 C4 44 7B 3B 6A 20 8D 45 9C 50 8D 85 5C FF FF FF 50 E8 ?? ?? ?? ?? DD 45 E4 8D 85 5C FF FF FF 59 DD 1C 24 56 50 E8 ?? ?? ?? ?? 56 8D 85 5C FF FF FF 50 8D 45 BC 56 50 E8 ?? ?? ?? ?? 83 C4 20 DD 45 BC DD 55 08 D9 EE DD E1 DF E0 F6 C4 44 7B 18 DD 45 C4 DD E1 DF E0 DD D9 F6 C4 44 7B 0E DC 45 CC DE C1 DD 5D 08 EB 08 DD D8 EB 02 DD D9 DD D8 8D 45 08 6A 00 50 E8 ?? ?? ?? ?? DD 45 08 8D 45 BC DD 95 3C FF FF FF D9 E0 DD 1C 24 56 50 E8 ?? ?? ?? ?? 8D 45 BC 56 50 E8 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? 83 C4 18 DD 9D 48 FF FF FF DD 85 3C FF FF FF E8 ?? ?? ?? ?? D9 E8 8B 9D 28 FF FF FF 85 DB 74 05 66 89 03 33 C0 50 51 51 8D 85 48 FF FF FF DD 1C 24 50 E8 ?? ?? ?? ?? DD 85 48 FF FF FF 83 C4 10 0F B7 F0 0F BF C6 83 E8 00 74 0F 48 75 24 DD D8 DD 05 ?? ?? ?? ?? 6A 08 EB 06 DD D8 D9 EE 6A 10 DD 9D 48 FF FF FF E8 ?? ?? ?? ?? DD 85 48 FF FF FF 59 66 83 BD 44 FF FF FF 00 74 4B D9 E0 EB 47 DD D8 6A 02 5B 66 3B D3 75 06 DD DA DD D8 EB 37 DD D8 66 3B FB 75 04 DD D9 EB 2C DD D8 66 3B D6 0F 85 82 00 00 00 8B 45 0E BE 00 80 00 00 0F B7 C0 85 C6 8B 45 16 0F B7 C0 75 1D 85 C6 75 08 DD D8 DD 05 ?? ?? ?? ?? 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 85 C6 75 21 DD D8 66 85 FF 75 DE 8D 85 34 FF FF FF 6A FF 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 79 C9 E9 C4 00 00 00 66 85 FF 75 C5 8D 85 34 FF FF FF DD D8 6A FF 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 79 0B DD 05 ?? ?? ?? ?? E9 58 FF FF FF D9 EE EB 9F 8B 45 16 0F B7 C0 66 3B FE 75 1F A9 00 80 00 00 75 0A 66 85 C9 7E 88 E9 7B FF FF FF 66 85 C9 0F 8F 7A FF FF FF E9 6D FF FF FF BE 00 80 00 00 85 C6 75 2C 66 85 FF 0F 85 63 FF FF FF 8D 85 34 FF FF FF DD D8 6A FF 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 79 A9 8B 45 0E 0F B7 C0 85 C6 74 9F EB 92 6A 04 DD D8 E8 ?? ?? ?? ?? 59 66 85 FF 0F 85 27 FF FF FF 8D 85 34 FF FF FF 6A FF 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 0F 89 0E FF FF FF 8B 45 0E 0F B7 C0 85 C6 0F 84 00 FF FF FF DD 05 ?? ?? ?? ?? E9 B0 FE FF FF }
	condition:
		$1
}

rule file_186_1_0 {
	meta:
		name = "__dtgamma"
		size = 370
		refs = "0011 __real@404b000000000000 0023 _stirling 0030 __real@bfe0000000000000 0044 __real@3fe0000000000000 008b __real@3ff0000000000000 009d __real@3ff8000000000000 00b7 __real@4004000000000000 00cd __real@4000000000000000 012b __dunscale 013a _s 0146 __dpoly 0156 _c"
	strings:
		$1 = { 55 8B EC 83 EC 18 56 8B 75 08 DD 06 DD 55 F0 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 75 12 FF 75 0C DD D8 56 E8 ?? ?? ?? ?? 59 59 E9 3F 01 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 3D D9 C0 DD 55 F8 DD 05 ?? ?? ?? ?? D8 D2 DF E0 D9 E8 F6 C4 05 7A 08 DD DA EB 1A D9 C9 D9 CA DC C3 D9 CA D8 CB DD 55 F8 D9 C9 D8 D3 DF E0 F6 C4 05 7A E8 DD D9 DD D8 DE E9 E9 A6 00 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 12 DD 05 ?? ?? ?? ?? D8 C1 DE C9 DD 5D F8 E9 88 00 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 0B DD 55 F8 DC 25 ?? ?? ?? ?? EB 1C DD 05 ?? ?? ?? ?? D8 D1 DF E0 F6 C4 41 75 1A DD D8 D9 E8 DD 5D F8 DC 25 ?? ?? ?? ?? 8B 45 0C 33 C9 DD 55 F0 66 89 08 EB 56 D9 E8 D9 C0 DD 55 F8 D9 CA D8 D3 DF E0 F6 C4 05 7B 0E DD DA DD D9 DD D8 EB 22 D9 CA D9 CB D9 CA D9 CB D8 E1 DC FA D9 CA DD 55 F8 D9 CB D8 D2 DF E0 F6 C4 05 7B E4 DD DB DD DA DD D9 DC 25 ?? ?? ?? ?? DD 5D F0 8D 45 F8 50 FF 75 0C E8 ?? ?? ?? ?? DD 45 F0 59 59 DD 45 F8 6A 07 68 ?? ?? ?? ?? 51 DD 1E 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 DD 45 F0 6A 06 68 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 7D E8 83 C4 10 DC 4D F0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_1286_1_0 {
	meta:
		name = "__ldtgamma"
		size = 370
		refs = "0011 __real@404b000000000000 0023 _stirling 0030 __real@bfe0000000000000 0044 __real@3fe0000000000000 008b __real@3ff0000000000000 009d __real@3ff8000000000000 00b7 __real@4004000000000000 00cd __real@4000000000000000 012b __ldunscale 013a _s 0146 __ldpoly 0156 _c"
	strings:
		$1 = { 55 8B EC 83 EC 18 56 8B 75 08 DD 06 DD 55 F0 DC 15 ?? ?? ?? ?? DF E0 F6 C4 01 75 12 FF 75 0C DD D8 56 E8 ?? ?? ?? ?? 59 59 E9 3F 01 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 3D D9 C0 DD 55 F8 DD 05 ?? ?? ?? ?? D8 D2 DF E0 D9 E8 F6 C4 05 7A 08 DD DA EB 1A D9 C9 D9 CA DC C3 D9 CA D8 CB DD 55 F8 D9 C9 D8 D3 DF E0 F6 C4 05 7A E8 DD D9 DD D8 DE E9 E9 A6 00 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 12 DD 05 ?? ?? ?? ?? D8 C1 DE C9 DD 5D F8 E9 88 00 00 00 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 0B DD 55 F8 DC 25 ?? ?? ?? ?? EB 1C DD 05 ?? ?? ?? ?? D8 D1 DF E0 F6 C4 41 75 1A DD D8 D9 E8 DD 5D F8 DC 25 ?? ?? ?? ?? 8B 45 0C 33 C9 DD 55 F0 66 89 08 EB 56 D9 E8 D9 C0 DD 55 F8 D9 CA D8 D3 DF E0 F6 C4 05 7B 0E DD DA DD D9 DD D8 EB 22 D9 CA D9 CB D9 CA D9 CB D8 E1 DC FA D9 CA DD 55 F8 D9 CB D8 D2 DF E0 F6 C4 05 7B E4 DD DB DD DA DD D9 DC 25 ?? ?? ?? ?? DD 5D F0 8D 45 F8 50 FF 75 0C E8 ?? ?? ?? ?? DD 45 F0 59 59 DD 45 F8 6A 07 68 ?? ?? ?? ?? 51 DD 1E 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 DD 45 F0 6A 06 68 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 7D E8 83 C4 10 DC 4D F0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_2_0 {
	meta:
		name = "_stirling"
		size = 149
		refs = "0019 __real@3fe0000000000000 0027 __dpow 003d _approx0 0043 __real@3f86e2e6d3354adf 0050 __dpoly 0080 _exp"
	strings:
		$1 = { 55 8B EC 83 EC 20 56 8B 75 0C 57 8B 7D 08 56 83 EC 10 DD 07 DD 55 F8 DD 05 ?? ?? ?? ?? D8 E9 DD 5C 24 08 DD 1C 24 E8 ?? ?? ?? ?? DD 5D E0 D9 E8 83 C4 14 DC 75 F8 66 F7 1E 6A 01 FF 35 ?? ?? ?? ?? DC 25 ?? ?? ?? ?? 51 51 DD 55 F0 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 DD 45 F0 6A 0D FF 35 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 7D E8 83 C4 08 DD 1F DD 45 F8 D9 E0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E0 59 59 DC 3F DD 1F D9 EE 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_1286_3_0 {
	meta:
		name = "_stirling"
		size = 149
		refs = "0019 __real@3fe0000000000000 0027 __ldpow 003d _approx0 0043 __real@3f86e2e6d3354adf 0050 __ldpoly 0080 _exp"
	strings:
		$1 = { 55 8B EC 83 EC 20 56 8B 75 0C 57 8B 7D 08 56 83 EC 10 DD 07 DD 55 F8 DD 05 ?? ?? ?? ?? D8 E9 DD 5C 24 08 DD 1C 24 E8 ?? ?? ?? ?? DD 5D E0 D9 E8 83 C4 14 DC 75 F8 66 F7 1E 6A 01 FF 35 ?? ?? ?? ?? DC 25 ?? ?? ?? ?? 51 51 DD 55 F0 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 DD 45 F0 6A 0D FF 35 ?? ?? ?? ?? 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 7D E8 83 C4 08 DD 1F DD 45 F8 D9 E0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E0 59 59 DC 3F DD 1F D9 EE 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_3_0 {
	meta:
		name = "_tgamma"
		size = 481
		refs = "0015 __d_int 004c __fperrraise 0052 __Nan_C 0074 __Inf_C 009d __real@c065c00000000000 00bc __dgamma_big 00f8 __real@bff0000000000000 010d __real@400921fb54442d18 0118 __dsin 013d __dtgamma 0158 __dscale 017a __real@4065c00000000000 0194 __real@3ff0000000000000"
	strings:
		$1 = { 55 8B EC 83 EC 24 DD 45 08 8D 45 EC 56 33 F6 56 50 DD 5D EC E8 ?? ?? ?? ?? DD 45 08 98 DD 55 DC D9 EE 59 59 2B C6 74 33 DD D8 48 74 0D 48 75 6B DD D8 DD 45 08 E9 A2 01 00 00 8B 45 0E DD D8 0F B7 C0 A9 00 80 00 00 74 E9 6A 01 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? E9 80 01 00 00 DD E1 DF E0 F6 C4 44 7A 2A DD D8 6A 04 DD D8 E8 ?? ?? ?? ?? 8B 45 0E DD 05 ?? ?? ?? ?? 0F B7 C0 59 A9 00 80 00 00 0F 84 55 01 00 00 D9 E0 E9 4E 01 00 00 D8 D9 DF E0 F6 C4 41 75 04 DD D8 EB AE DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 10 6A 10 DD D8 E8 ?? ?? ?? ?? D9 EE E9 21 01 00 00 DD 05 ?? ?? ?? ?? D9 E0 D8 D9 DF E0 F6 C4 41 0F 85 A9 00 00 00 DD 55 F4 D9 C0 8D 45 F4 D9 E0 D9 E8 DE E9 6A FF 50 DD 5D E4 DC 65 EC DD 5D EC E8 ?? ?? ?? ?? DD 45 DC DC 65 F4 59 59 DC 1D ?? ?? ?? ?? DF E0 DD 45 EC F6 C4 05 7A 05 D9 E0 DD 55 EC DC 0D ?? ?? ?? ?? 56 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 45 08 8D 45 FC DC C9 D9 E0 D9 E8 50 8D 45 E4 DE E9 50 DE C9 D9 E0 DC 3D ?? ?? ?? ?? DD 5D F4 E8 ?? ?? ?? ?? D9 E8 DE C1 0F BF 45 FC 50 8D 45 F4 50 DC 7D F4 DC 4D E4 DD 5D F4 E8 ?? ?? ?? ?? 98 83 C4 1C 2B C6 74 07 48 75 0C 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 DD 45 F4 EB 64 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 7A 49 8D 45 FC 50 8D 45 08 50 E8 ?? ?? ?? ?? DC 05 ?? ?? ?? ?? 0F BF 45 FC F7 D8 50 8D 45 08 DC 75 08 50 DD 5D 08 E8 ?? ?? ?? ?? 98 83 C4 10 2B C6 74 0B 48 0F 85 75 FE FF FF 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 E9 64 FE FF FF 6A 08 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_1286_4_0 {
	meta:
		name = "_tgammal"
		size = 481
		refs = "0015 __ld_int 004c __fperrraise 0052 __LNan_C 0074 __LInf_C 009d __real@c065c00000000000 00bc __ldgamma_big 00f8 __real@bff0000000000000 010d __real@400921fb54442d18 0118 __ldsin 013d __ldtgamma 0158 __ldscale 017a __real@4065c00000000000 0194 __real@3ff0000000000000"
	strings:
		$1 = { 55 8B EC 83 EC 24 DD 45 08 8D 45 EC 56 33 F6 56 50 DD 5D EC E8 ?? ?? ?? ?? DD 45 08 98 DD 55 DC D9 EE 59 59 2B C6 74 33 DD D8 48 74 0D 48 75 6B DD D8 DD 45 08 E9 A2 01 00 00 8B 45 0E DD D8 0F B7 C0 A9 00 80 00 00 74 E9 6A 01 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? E9 80 01 00 00 DD E1 DF E0 F6 C4 44 7A 2A DD D8 6A 04 DD D8 E8 ?? ?? ?? ?? 8B 45 0E DD 05 ?? ?? ?? ?? 0F B7 C0 59 A9 00 80 00 00 0F 84 55 01 00 00 D9 E0 E9 4E 01 00 00 D8 D9 DF E0 F6 C4 41 75 04 DD D8 EB AE DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 10 6A 10 DD D8 E8 ?? ?? ?? ?? D9 EE E9 21 01 00 00 DD 05 ?? ?? ?? ?? D9 E0 D8 D9 DF E0 F6 C4 41 0F 85 A9 00 00 00 DD 55 F4 D9 C0 8D 45 F4 D9 E0 D9 E8 DE E9 6A FF 50 DD 5D E4 DC 65 EC DD 5D EC E8 ?? ?? ?? ?? DD 45 DC DC 65 F4 59 59 DC 1D ?? ?? ?? ?? DF E0 DD 45 EC F6 C4 05 7A 05 D9 E0 DD 55 EC DC 0D ?? ?? ?? ?? 56 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 45 08 8D 45 FC DC C9 D9 E0 D9 E8 50 8D 45 E4 DE E9 50 DE C9 D9 E0 DC 3D ?? ?? ?? ?? DD 5D F4 E8 ?? ?? ?? ?? D9 E8 DE C1 0F BF 45 FC 50 8D 45 F4 50 DC 7D F4 DC 4D E4 DD 5D F4 E8 ?? ?? ?? ?? 98 83 C4 1C 2B C6 74 07 48 75 0C 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 DD 45 F4 EB 64 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 7A 49 8D 45 FC 50 8D 45 08 50 E8 ?? ?? ?? ?? DC 05 ?? ?? ?? ?? 0F BF 45 FC F7 D8 50 8D 45 08 DC 75 08 50 DD 5D 08 E8 ?? ?? ?? ?? 98 83 C4 10 2B C6 74 0B 48 0F 85 75 FE FF FF 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 E9 64 FE FF FF 6A 08 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "__d_inttype"
		size = 104
		refs = "000e __fpclass 0021 __frnd 0037 __real@3fe0000000000000"
	strings:
		$1 = { 55 8B EC 51 51 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 A8 90 75 4A DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 45 08 DD E1 DF E0 59 59 DD D9 F6 C4 44 7A 2B DC 0D ?? ?? ?? ?? 51 51 DD 55 F8 DD 1C 24 E8 ?? ?? ?? ?? DD 45 F8 DA E9 DF E0 59 59 F6 C4 44 7A 05 6A 02 58 EB 09 33 C0 40 EB 04 DD D8 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_188_1_0 {
	meta:
		name = "__powhlp"
		size = 310
		refs = "0030 __d_inf 008d __d_ind 00e2 __d_inttype 011d __d_mzero"
	strings:
		$1 = { 55 8B EC DD 45 08 B9 00 00 F0 7F 56 33 F6 D9 E1 B8 00 00 F0 FF 39 4D 14 75 3A 39 75 10 75 7C D9 E8 D8 D1 DF E0 F6 C4 05 7A 0F DD D9 DD D8 DD 05 ?? ?? ?? ?? E9 E8 00 00 00 D8 D1 DF E0 DD D9 F6 C4 41 8B 45 18 0F 85 D9 00 00 00 DD D8 D9 EE E9 D0 00 00 00 39 45 14 75 42 39 75 10 75 3D D9 E8 D8 D1 DF E0 F6 C4 05 7A 0B DD D9 DD D8 D9 EE E9 AD 00 00 00 DE D9 DF E0 F6 C4 41 8B 45 18 75 0B DD 05 ?? ?? ?? ?? E9 99 00 00 00 DD 05 ?? ?? ?? ?? 33 F6 DD 18 46 E9 96 00 00 00 DD D8 39 4D 0C 75 2D 39 75 08 0F 85 86 00 00 00 D9 EE DD 45 10 D8 D1 DF E0 F6 C4 41 0F 84 6D FF FF FF D8 D9 DF E0 F6 C4 05 8B 45 18 7B 5B DD D8 D9 E8 EB 55 39 45 0C 75 5D 39 75 08 75 58 DD 45 10 51 51 DD 1C 24 E8 ?? ?? ?? ?? D9 EE DD 45 10 59 59 D8 D1 8B C8 DF E0 F6 C4 41 75 13 DD D9 DD D8 DD 05 ?? ?? ?? ?? 83 F9 01 75 1A D9 E0 EB 16 D8 D9 DF E0 F6 C4 05 7A 14 83 F9 01 75 08 DD D8 DD 05 ?? ?? ?? ?? 8B 45 18 DD 18 EB 09 8B 4D 18 DD D8 D9 E8 DD 19 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_190_6_0 {
	meta:
		name = "??$_InternalDeleteHelper@VWorkQueue@details@Concurrency@@@details@Concurrency@@YAXPAVWorkQueue@01@@Z"
		size = 19
		refs = "000d ??_GWorkQueue@details@Concurrency@@QAEPAXI@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 08 85 C9 74 07 6A 01 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_190_11_0 {
	meta:
		name = "??0?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE@H@Z"
		size = 62
		refs = "001f ??_U@YAPAXI@Z 0030 _memset"
		altNames = "??0?$Hash@II@details@Concurrency@@QAE@H@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 8B F1 33 C9 6A 04 5A 83 66 04 00 89 06 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 8B 0E C1 E1 02 51 6A 00 50 89 46 08 E8 ?? ?? ?? ?? 83 C4 10 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_190_16_0 {
	meta:
		name = "??0ArrayNode@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE@PAPAVWorkQueue@23@@Z"
		size = 22
		altNames = "??0ArrayNode@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE@PAPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z ??0ArrayNode@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAE@PAPAVExternalStatistics@23@@Z ??0ArrayNode@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QAE@PAPAVScheduleGroupBase@23@@Z ??0ArrayNode@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@QAE@PAPAVScheduleGroupSegmentBase@23@@Z ??0ArrayNode@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE@PAPAVVirtualProcessor@23@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 61 04 00 83 49 08 FF 89 01 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_190_17_0 {
	meta:
		name = "??0CancellationBeaconNode@CancellationBeaconStack@ContextBase@details@Concurrency@@QAE@XZ"
		size = 24
		refs = "000d ??_U@YAPAXI@Z"
	strings:
		$1 = { 56 8B F1 68 80 00 00 00 83 66 04 00 E8 ?? ?? ?? ?? 89 06 8B C6 59 5E C3 }
	condition:
		$1
}

rule file_190_18_0 {
	meta:
		name = "??0CancellationBeaconStack@ContextBase@details@Concurrency@@QAE@XZ"
		size = 25
		refs = "000d ??_U@YAPAXI@Z"
	strings:
		$1 = { 56 8B F1 6A 10 83 26 00 83 66 04 00 E8 ?? ?? ?? ?? 89 46 08 8B C6 59 5E C3 }
	condition:
		$1
}

rule file_190_20_0 {
	meta:
		name = "??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z"
		size = 198
		refs = "0003 __ehhandler$??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0008 __EH_prolog3 0025 ??_7ContextBase@details@Concurrency@@6B@ 005b ??0_ReaderWriterLock@details@Concurrency@@QAE@XZ 0085 ??0?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE@H@Z 0094 ??0CancellationBeaconStack@ContextBase@details@Concurrency@@QAE@XZ 00a0 ?GetNewContextId@SchedulerBase@details@Concurrency@@QAEIXZ 00b8 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 00bf __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 8B 45 08 8D 4E 54 83 4E 3C FF 33 FF 89 46 1C 8A 45 0C C7 06 ?? ?? ?? ?? 89 7E 0C 89 7E 10 89 7E 14 89 7E 20 89 7E 24 C7 46 28 01 00 00 00 89 7E 2C 89 7E 30 89 7E 34 89 7E 38 89 7E 40 89 7E 44 88 46 4C 89 7D FC 89 7E 50 E8 ?? ?? ?? ?? 89 7E 64 8D 8E 80 00 00 00 C7 46 68 FF FF FF FF C7 46 6C FF FF FF FF 89 7E 70 89 7E 74 6A 07 89 7E 78 89 7E 7C E8 ?? ?? ?? ?? 8D 8E 8C 00 00 00 C6 45 FC 01 E8 ?? ?? ?? ?? 8B 4E 1C C6 45 FC 02 E8 ?? ?? ?? ?? 8B 4E 1C 89 46 08 50 8B 01 FF 50 04 50 6A 04 6A 01 8B CE E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 08 00 }
	condition:
		$1
}

rule file_190_28_0 {
	meta:
		name = "??0_Cancellation_beacon@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "0004 ?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 000b ?PushCancellationBeacon@ContextBase@details@Concurrency@@QAEPAU_Beacon_reference@23@XZ"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 06 8B C6 5E C3 }
	condition:
		$1
}

rule file_190_31_0 {
	meta:
		name = "??0_Scoped_lock_read@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@AAV123@@Z"
		size = 26
		refs = "000f ?_AcquireRead@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E 83 C1 04 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_742_14_0 {
	meta:
		name = "??0_Scoped_lock@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@AAV123@@Z"
		size = 26
		refs = "000f ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E 83 C1 04 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_190_36_0 {
	meta:
		name = "??1?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@XZ"
		size = 23
		refs = "0007 ??_V@YAXPAX@Z"
		altNames = "??1?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 56 8B F1 FF 76 0C E8 ?? ?? ?? ?? FF 76 10 E8 ?? ?? ?? ?? 59 59 5E C3 }
	condition:
		$1
}

rule file_190_37_0 {
	meta:
		name = "??1?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@XZ"
		size = 23
		refs = "0007 ??_V@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 FF 76 1C E8 ?? ?? ?? ?? FF 76 20 E8 ?? ?? ?? ?? 59 59 5E C3 }
	condition:
		$1
}

rule file_190_44_0 {
	meta:
		name = "??1Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 23
		refs = "0007 ??_V@YAXPAX@Z"
		altNames = "??1Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 56 8B F1 FF 76 0C E8 ?? ?? ?? ?? FF 76 08 E8 ?? ?? ?? ?? 59 59 5E C3 }
	condition:
		$1
}

rule file_190_46_0 {
	meta:
		name = "??1WorkQueue@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "0007 ??1?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@XZ 000f ??1?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 56 8B F1 8D 4E 4C E8 ?? ?? ?? ?? 8B CE 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_190_54_0 {
	meta:
		name = "??8location@Concurrency@@QBE_NABV01@@Z"
		size = 36
	strings:
		$1 = { 55 8B EC 8B 55 08 8B 02 33 01 A9 FF FF FF 0F 75 0D 8B 41 08 3B 42 08 75 05 33 C0 40 EB 02 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_190_55_0 {
	meta:
		name = "??9location@Concurrency@@QBE_NABV01@@Z"
		size = 24
		refs = "0007 ??8location@Concurrency@@QBE_NABV01@@Z"
	strings:
		$1 = { 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 33 C9 84 C0 0F 94 C1 8A C1 5D C2 04 00 }
	condition:
		$1
}

rule file_226_32_0 {
	meta:
		name = "??9HardwareAffinity@details@Concurrency@@QAE_NABU012@@Z"
		size = 24
		refs = "0007 ??8HardwareAffinity@details@Concurrency@@QAE_NABU012@@Z"
	strings:
		$1 = { 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 33 C9 84 C0 0F 94 C1 8A C1 5D C2 04 00 }
	condition:
		$1
}

rule file_190_56_0 {
	meta:
		name = "??ACancellationBeaconStack@ContextBase@details@Concurrency@@QAEPAUCancellationBeacon@123@J@Z"
		size = 52
	strings:
		$1 = { 55 8B EC 8B 41 08 56 8B 75 08 8B D6 C1 FA 04 83 FA 04 7D 05 8B 04 90 EB 0E 8B 40 0C 83 EA 03 74 06 8B 40 04 4A 75 FA 8B 00 83 E6 0F 8D 04 F0 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_190_71_0 {
	meta:
		name = "??_GWorkQueue@details@Concurrency@@QAEPAXI@Z"
		size = 41
		refs = "000a ??1?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@XZ 0011 ??1?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@XZ 001d ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 8D 4E 4C E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_190_74_0 {
	meta:
		name = "?AcquirePushBeacon@CancellationBeaconStack@ContextBase@details@Concurrency@@QAEPAUCancellationBeacon@234@H@Z"
		size = 57
		refs = "000f ?Grow@CancellationBeaconStack@ContextBase@details@Concurrency@@AAEXXZ 0018 ??ACancellationBeaconStack@ContextBase@details@Concurrency@@QAEPAUCancellationBeacon@123@J@Z"
	strings:
		$1 = { 55 8B EC 51 56 8B F1 8B 06 3B 46 04 7C 05 E8 ?? ?? ?? ?? FF 36 8B CE E8 ?? ?? ?? ?? 8B 4D 08 33 D2 89 48 04 8D 4D FC C7 00 00 00 00 00 FF 06 F0 09 11 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_190_77_0 {
	meta:
		name = "?Add@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEHPAVWorkQueue@23@@Z"
		size = 347
		refs = "00a8 ??_U@YAPAXI@Z 00bc _memset 00c3 ??2@YAPAXI@Z 0129 ?_UnderlyingYield@details@Concurrency@@YAXXZ 0131 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 56 57 8B F1 C6 45 FF 00 6A 04 33 FF 58 8B 56 30 89 55 F8 8D 5A 08 83 3B FF 89 5D F4 7C 3C 8B 1A 33 D2 39 56 28 7E 2D 83 3B 00 75 20 8B 4D 08 8D 04 3A 89 41 44 8B 46 40 89 45 F0 33 C0 F0 0F B1 0B 85 C0 0F 84 8F 00 00 00 6A 04 58 42 03 D8 3B 56 28 7C D3 8B 5D F4 8B 55 F8 80 7D FF 00 0F 85 D2 00 00 00 6A FE 59 83 C8 FF F0 0F B1 0B 03 7E 28 8D 5A 04 83 3B 00 0F 85 99 00 00 00 33 C9 33 C0 41 F0 0F B1 0B 85 C0 0F 85 88 00 00 00 8B 46 28 33 C9 6A 04 5A F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 8B C8 8B 46 28 C1 E0 02 50 6A 00 51 89 4D F0 E8 ?? ?? ?? ?? 6A 0C E8 ?? ?? ?? ?? 8B C8 83 C4 14 85 C9 74 35 8B 45 F0 83 61 04 00 83 49 08 FF 89 01 EB 28 03 FA C6 45 FF 01 3B 7D F0 7C 0A 33 C9 8D 46 40 41 F0 0F C1 08 8B 5D F4 83 C9 FF 8B C2 F0 0F B1 0B E9 59 FF FF FF 33 C9 8B 56 3C 3B 56 38 7D 09 8B 46 34 89 0C 90 FF 46 3C 87 0B 8B 55 F8 83 3B 01 75 1B 83 65 E8 00 C7 45 EC ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 83 3B 01 74 F3 8B 55 F8 80 7D FF 00 8B 52 04 6A 04 89 55 F8 58 0F 84 CA FE FF FF 8B C7 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_190_78_0 {
	meta:
		name = "?AddStealer@ContextBase@details@Concurrency@@QAEXPAV123@_N@Z"
		size = 48
		refs = "0012 ?AddTail@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 8B F9 8D 46 5C 50 8D 4F 50 E8 ?? ?? ?? ?? 80 7D 0C 00 C6 46 4D 01 74 0A 8D 47 64 83 C9 FF F0 0F C1 08 5F 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_190_82_0 {
	meta:
		name = "?CancelCollection@ContextBase@details@Concurrency@@QAEXH@Z"
		size = 109
		refs = "0044 ?FlagCancellationBeacons@ContextBase@details@Concurrency@@QAEXH@Z"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 33 D2 57 42 8D 46 70 F0 0F C1 10 8B 7D 08 8D 5E 68 8B 13 83 FA FF 74 04 3B FA 7F 25 8B CF 8B C2 F0 0F B1 0B 3B C2 74 04 8B D0 EB E7 83 7E 74 00 74 05 83 C8 FF EB 02 8B C7 50 8B CE E8 ?? ?? ?? ?? 83 C6 6C 8B 16 83 FA FF 74 04 3B FA 7C 10 8B CF 8B C2 F0 0F B1 0E 3B C2 74 04 8B D0 EB E7 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_190_83_0 {
	meta:
		name = "?CancelCollectionComplete@ContextBase@details@Concurrency@@QAE_NH@Z"
		size = 50
		refs = "0018 ?RecomputeMaximumCancellationDepth@ContextBase@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 8B 45 08 53 56 57 8B F9 83 CB FF 8B F3 8D 57 68 F0 0F B1 32 E8 ?? ?? ?? ?? 8D 47 70 F0 0F C1 18 4B F7 DB 5F 1B DB 5E 8D 43 01 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_190_84_0 {
	meta:
		name = "?CancelEntireContext@ContextBase@details@Concurrency@@QAEXXZ"
		size = 19
		refs = "000e ?CancelCollection@ContextBase@details@Concurrency@@QAEXH@Z"
	strings:
		$1 = { 33 D2 8D 41 74 42 87 10 68 19 FC FF FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_190_85_0 {
	meta:
		name = "?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z"
		size = 199
		refs = "0003 __ehhandler$?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z 0008 __EH_prolog3 0020 ?_AcquireRead@_ReaderWriterLock@details@Concurrency@@QAEXXZ 0079 ?IsCanceledAtDepth@ContextBase@details@Concurrency@@AAE_NPAV_TaskCollectionBase@23@H@Z 0092 ?CancelCollection@ContextBase@details@Concurrency@@QAEXH@Z 009c ?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z 00bb ?_ReleaseRead@_ReaderWriterLock@details@Concurrency@@QAEXXZ 00c0 __EH_epilog3"
	strings:
		$1 = { 6A 0C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C1 89 45 F0 8D 78 50 8D 47 04 89 7D E8 8B C8 89 45 EC E8 ?? ?? ?? ?? 83 65 FC 00 8B 37 85 F6 EB 74 83 7E 18 00 75 6C 8B 56 D4 8B 45 08 3B D0 74 43 85 C0 75 10 8B 42 04 C1 E0 04 C1 F8 04 83 F8 FF 75 1D EB 4E 8B 48 04 C1 E1 04 C1 F9 04 83 F9 FF 74 40 8B 42 04 C1 E0 04 C1 F8 04 3B C1 7E 33 8B 4D F0 83 79 3C FF 74 0B 50 52 E8 ?? ?? ?? ?? 84 C0 74 1F 33 C0 8D 4E 18 40 87 01 68 19 FC FF FF 8D 4E A4 E8 ?? ?? ?? ?? 6A 00 8D 4E A4 E8 ?? ?? ?? ?? 3B 37 74 05 8B 76 04 EB 02 33 F6 85 F6 0F 85 7B FF FF FF 8B 4D EC 83 4D FC FF E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_190_88_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 38
		refs = "0007 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0015 ?DeleteElements@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 56 8B F1 8B 4E 24 E8 ?? ?? ?? ?? 84 C0 75 15 FF 76 10 8B CE E8 ?? ?? ?? ?? 83 66 10 00 8D 46 48 33 C9 87 08 5E C3 }
	condition:
		$1
}

rule file_495_109_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 38
		refs = "0007 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0015 ?DeleteElements@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 56 8B F1 8B 4E 24 E8 ?? ?? ?? ?? 84 C0 75 15 FF 76 10 8B CE E8 ?? ?? ?? ?? 83 66 10 00 8D 46 48 33 C9 87 08 5E C3 }
	condition:
		$1
}

rule file_1139_40_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 38
		refs = "0007 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0015 ?DeleteElements@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 56 8B F1 8B 4E 24 E8 ?? ?? ?? ?? 84 C0 75 15 FF 76 10 8B CE E8 ?? ?? ?? ?? 83 66 10 00 8D 46 48 33 C9 87 08 5E C3 }
	condition:
		$1
}

rule file_974_55_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 38
		refs = "0007 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0015 ?DeleteElements@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 56 8B F1 8B 4E 24 E8 ?? ?? ?? ?? 84 C0 75 15 FF 76 10 8B CE E8 ?? ?? ?? ?? 83 66 10 00 8D 46 48 33 C9 87 08 5E C3 }
	condition:
		$1
}

rule file_190_90_0 {
	meta:
		name = "?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NPAPAV_UnrealizedChore@34@@Z"
		size = 71
		refs = "003b ?Dereference@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 57 8B 06 8B 56 04 8B 40 0C 8B 3C 90 83 FF 01 74 21 8B 06 33 D2 8B 4E 04 42 8B 40 0C 8D 04 88 87 10 3B D7 75 0D 8B 4D 08 85 C9 74 02 89 39 B0 01 EB 09 8B 0E E8 ?? ?? ?? ?? 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_501_53_0 {
	meta:
		name = "?Claim@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE_NPAPAVInternalContextBase@34@@Z"
		size = 71
		refs = "003b ?Dereference@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 57 8B 06 8B 56 04 8B 40 0C 8B 3C 90 83 FF 01 74 21 8B 06 33 D2 8B 4E 04 42 8B 40 0C 8D 04 88 87 10 3B D7 75 0D 8B 4D 08 85 C9 74 02 89 39 B0 01 EB 09 8B 0E E8 ?? ?? ?? ?? 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_190_91_0 {
	meta:
		name = "?Cleanup@ContextBase@details@Concurrency@@QAEXXZ"
		size = 33
		refs = "0004 ?ReleaseWorkQueue@ContextBase@details@Concurrency@@IAEXXZ 001b ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? 8B 4E 1C FF 76 08 8B 01 FF 50 04 50 6A 04 6A 02 8B CE E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_190_92_0 {
	meta:
		name = "?ClearAliasTable@ContextBase@details@Concurrency@@QAEXXZ"
		size = 65
		refs = "0016 ?_ReleaseAlias@_TaskCollection@details@Concurrency@@AAEXXZ 002a ?NextList@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@PAH@Z 0037 ?Wipe@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 56 57 8D B9 80 00 00 00 EB 11 8B 4E 08 E8 ?? ?? ?? ?? 8B 36 85 F6 75 F2 FF 45 FC 8D 45 FC 8B CF 50 E8 ?? ?? ?? ?? 8B F0 85 F6 75 DE 8B CF E8 ?? ?? ?? ?? 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_190_93_0 {
	meta:
		name = "?ClearContextTls@ContextBase@details@Concurrency@@AAEXXZ"
		size = 16
		refs = "0004 ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 0009 ?__TlsSetValue@platform@details@Concurrency@@YAXKPAX@Z"
	strings:
		$1 = { 6A 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_190_94_0 {
	meta:
		name = "?ConfirmCancel@ContextBase@details@Concurrency@@QAE_NPAU_Beacon_reference@23@@Z"
		size = 21
		refs = "000d ?IsCanceledAtDepth@ContextBase@details@Concurrency@@AAE_NPAV_TaskCollectionBase@23@H@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 FF 70 04 FF 71 34 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_190_97_0 {
	meta:
		name = "?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
		size = 128
		refs = "0003 __ehhandler$?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 0008 __EH_prolog3 0017 __imp__InterlockedPopEntrySList@4 0031 ?GetDetachedWorkQueue@ScheduleGroupSegmentBase@details@Concurrency@@IAEPAVWorkQueue@23@XZ 003f ??2@YAPAXI@Z 0051 ??0WorkQueue@details@Concurrency@@QAE@XZ 0062 ?Reinitialize@WorkQueue@details@Concurrency@@AAEXXZ 0070 ?Add@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEHPAVWorkQueue@23@@Z 007b __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 8B 46 18 83 C0 58 50 FF 15 ?? ?? ?? ?? 33 FF 8B CF 85 C0 74 03 8D 48 E8 89 4E 20 85 C9 75 34 8B 4E 18 E8 ?? ?? ?? ?? 89 46 20 85 C0 75 38 6A 74 E8 ?? ?? ?? ?? 59 89 45 F0 89 7D FC 85 C0 74 09 8B C8 E8 ?? ?? ?? ?? 8B F8 83 4D FC FF 89 7E 20 57 EB 08 E8 ?? ?? ?? ?? FF 76 20 8B 4E 18 83 C1 58 E8 ?? ?? ?? ?? 8B 46 20 89 70 48 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_190_100_0 {
	meta:
		name = "?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
		size = 127
		refs = "0003 __ehhandler$?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 0008 __EH_prolog3 0012 ?GetDetachedWorkQueue@ScheduleGroupSegmentBase@details@Concurrency@@IAEPAVWorkQueue@23@XZ 0026 __imp__InterlockedPopEntrySList@4 003f ??2@YAPAXI@Z 0051 ??0WorkQueue@details@Concurrency@@QAE@XZ 0061 ?Reinitialize@WorkQueue@details@Concurrency@@AAEXXZ 006f ?Add@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEHPAVWorkQueue@23@@Z 007a __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 8B 4E 18 E8 ?? ?? ?? ?? 89 46 20 85 C0 75 56 8B 46 18 83 C0 58 50 FF 15 ?? ?? ?? ?? 33 FF 8B CF 85 C0 74 03 8D 48 E8 89 4E 20 85 C9 75 24 6A 74 E8 ?? ?? ?? ?? 59 89 45 F0 89 7D FC 85 C0 74 09 8B C8 E8 ?? ?? ?? ?? 8B F8 83 4D FC FF 89 7E 20 EB 05 E8 ?? ?? ?? ?? 8B 4E 18 FF 76 20 83 C1 58 E8 ?? ?? ?? ?? 8B 46 20 89 70 48 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_190_103_0 {
	meta:
		name = "?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ"
		size = 34
		refs = "0002 ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA 000d ?CreateContextFromDefaultScheduler@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0013 ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 0018 ?__TlsGetValue@platform@details@Concurrency@@YAPAXK@Z"
	strings:
		$1 = { F7 05 ?? ?? ?? ?? 00 00 00 80 75 05 E9 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 85 C0 74 EB C3 }
	condition:
		$1
}

rule file_190_105_0 {
	meta:
		name = "?Delete@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE_NABQAV_TaskCollection@23@@Z"
		size = 17
		refs = "0009 ?FindAndDelete@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE_NABQAV_TaskCollection@23@PAPAV423@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_105_251_1 {
	meta:
		name = "?clear@ios_base@std@@QAEXH@Z"
		size = 17
		refs = "0009 ?clear@ios_base@std@@QAEXH_N@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_119_450_2 {
	meta:
		name = "?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z"
		size = 17
		refs = "0009 ?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXID@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_1_1177_2 {
	meta:
		name = "?resize@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXI@Z"
		size = 17
		refs = "0009 ?resize@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXIG@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_1_1179_2 {
	meta:
		name = "?resize@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXI@Z"
		size = 17
		refs = "0009 ?resize@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXI_W@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_190_106_0 {
	meta:
		name = "?DeleteElements@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
		size = 34
		refs = "0015 ??_GWorkQueue@details@Concurrency@@QAEPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 EB 10 8D 4E E8 8B 36 85 C9 74 07 6A 01 E8 ?? ?? ?? ?? 85 F6 75 EC 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_190_109_0 {
	meta:
		name = "?Dereference@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEXXZ"
		size = 29
		refs = "0010 ?StaticDelete@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@SAXPAU1234@@Z 0018 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { 8D 41 14 83 CA FF F0 0F C1 10 75 10 FF 31 51 68 ?? ?? ?? ?? 83 C1 1C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_501_60_0 {
	meta:
		name = "?Dereference@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEXXZ"
		size = 29
		refs = "0010 ?StaticDelete@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@SAXPAU1234@@Z 0018 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { 8D 41 14 83 CA FF F0 0F C1 10 75 10 FF 31 51 68 ?? ?? ?? ?? 83 C1 1C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_190_111_0 {
	meta:
		name = "?DetachStealers@ContextBase@details@Concurrency@@QAEXXZ"
		size = 331
		refs = "0003 __sehtable$?DetachStealers@ContextBase@details@Concurrency@@QAEXXZ 0008 __SEH_prolog4 001e ?_UnderlyingYield@details@Concurrency@@YAXXZ 0026 ?_SpinOnce@?$_SpinWait@$0A@@details@Concurrency@@QAE_NXZ 003a ?ClearAliasTable@ContextBase@details@Concurrency@@QAEXXZ 0047 ?_FlushWriteOwners@_ReaderWriterLock@details@Concurrency@@QAEXXZ 004c __SEH_epilog4 0062 ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ 009e ?_GetStealTrackingList@_TaskCollection@details@Concurrency@@ABEPAXXZ 00a9 ?_TryAcquireWrite@_ReaderWriterLock@details@Concurrency@@QAE_NXZ 00b5 ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ 00bf ?__Sleep@platform@details@Concurrency@@YAXK@Z 00f7 ?Remove@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z 0106 ?AddTail@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
	strings:
		$1 = { 6A 2C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 89 7D D4 33 DB 39 5F 64 74 17 89 5D CC C7 45 D0 ?? ?? ?? ?? 8D 4D C4 E8 ?? ?? ?? ?? 39 5F 64 75 F3 39 9F 84 00 00 00 7E 07 8B CF E8 ?? ?? ?? ?? 39 5F 50 75 0E 8D 4F 54 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 8A C3 88 45 E6 84 C0 75 F1 C6 45 E7 01 8D 4F 54 E8 ?? ?? ?? ?? 89 5D FC B0 01 88 45 E7 8B 77 50 85 F6 74 05 8B 76 04 EB 02 8B F3 85 F6 74 44 84 C0 74 40 3B 77 50 74 08 8B 46 04 89 45 E0 EB 03 89 5D E0 8D 46 A4 89 45 DC 8B 48 30 E8 ?? ?? ?? ?? 89 45 D8 8D 48 04 E8 ?? ?? ?? ?? 84 C0 75 34 8D 4F 54 E8 ?? ?? ?? ?? 88 5D E7 6A 01 E8 ?? ?? ?? ?? 59 33 C0 85 F6 0F 94 C0 89 45 E0 88 45 E6 C7 45 FC FE FF FF FF E8 5F 00 00 00 8B 45 E0 E9 71 FF FF FF C7 45 FC 01 00 00 00 8B 75 DC 83 C6 5C 56 8D 4F 50 E8 ?? ?? ?? ?? 8B 45 DC 88 58 4D 56 8B 4D D8 E8 ?? ?? ?? ?? 89 5D FC 8B 75 E0 E8 10 00 00 00 8A 45 E7 E9 5F FF FF FF 33 DB 8B 7D D4 8B 75 E0 8B 45 D8 8D 48 04 E8 ?? ?? ?? ?? C3 33 DB 8B 7D D4 8A 45 E6 89 45 E0 80 7D E7 00 74 08 8D 4F 54 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_190_122_0 {
	meta:
		name = "?Expire@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEXXZ"
		size = 17
		refs = "0004 ?StaticDelete@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@SAXPAU1234@@Z 000c ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { FF 31 51 68 ?? ?? ?? ?? 83 C1 1C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_501_61_0 {
	meta:
		name = "?Expire@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEXXZ"
		size = 17
		refs = "0004 ?StaticDelete@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@SAXPAU1234@@Z 000c ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { FF 31 51 68 ?? ?? ?? ?? 83 C1 1C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_190_123_0 {
	meta:
		name = "?FindAndDelete@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE_NABQAV_TaskCollection@23@PAPAV423@@Z"
		size = 63
		refs = "000c ?HashValue@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAIABQAV_TaskCollection@23@H@Z 0019 ?Remove@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@ABQAV_TaskCollection@23@H@Z 0030 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 FF 36 FF 75 08 E8 ?? ?? ?? ?? 59 59 50 FF 75 08 8B CE E8 ?? ?? ?? ?? 5E 85 C0 74 17 8B 55 0C 85 D2 74 05 8B 48 08 89 0A 50 E8 ?? ?? ?? ?? 59 B0 01 EB 02 32 C0 5D C2 08 00 }
	condition:
		$1
}

rule file_190_124_0 {
	meta:
		name = "?First@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@PAH@Z"
		size = 19
		refs = "000b ?NextList@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@PAH@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 83 20 00 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_190_126_0 {
	meta:
		name = "?FlagCancellationBeacons@ContextBase@details@Concurrency@@QAEXH@Z"
		size = 76
		refs = "001a ??ACancellationBeaconStack@ContextBase@details@Concurrency@@QAEPAUCancellationBeacon@123@J@Z"
	strings:
		$1 = { 55 8B EC 53 8B D9 56 57 33 F6 8D 83 8C 00 00 00 8B 38 85 FF 7E 2F 56 8B C8 E8 ?? ?? ?? ?? 8B C8 8B 45 08 39 41 04 7C 12 83 7B 3C FF 74 05 39 43 3C 7F 07 33 C0 40 F0 0F C1 01 46 8D 83 8C 00 00 00 3B F7 7C D1 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_190_135_0 {
	meta:
		name = "?GetScheduleGroup@ContextBase@details@Concurrency@@QBEPAVScheduleGroupBase@23@XZ"
		size = 17
	strings:
		$1 = { 8B 41 18 85 C0 74 07 8B 80 00 01 00 00 C3 33 C0 C3 }
	condition:
		$1
}

rule file_190_136_0 {
	meta:
		name = "?GetScheduleGroupId@ContextBase@details@Concurrency@@UBEIXZ"
		size = 22
	strings:
		$1 = { 8B 49 18 85 C9 74 0B 8B 89 00 01 00 00 8B 01 FF 60 04 83 C8 FF C3 }
	condition:
		$1
}

rule file_190_139_0 {
	meta:
		name = "?GetStructuredWorkQueue@ContextBase@details@Concurrency@@QAEPAVWorkQueue@23@XZ"
		size = 19
		refs = "000a ?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 56 8B F1 83 7E 20 00 75 05 E8 ?? ?? ?? ?? 8B 46 20 5E C3 }
	condition:
		$1
}

rule file_190_140_0 {
	meta:
		name = "?GetWorkQueue@ContextBase@details@Concurrency@@QAEPAVWorkQueue@23@XZ"
		size = 19
		refs = "000a ?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 56 8B F1 83 7E 20 00 75 05 E8 ?? ?? ?? ?? 8B 46 20 5E C3 }
	condition:
		$1
}

rule file_190_141_0 {
	meta:
		name = "?Grow@CancellationBeaconStack@ContextBase@details@Concurrency@@AAEXXZ"
		size = 155
		refs = "0003 __ehhandler$?Grow@CancellationBeaconStack@ContextBase@details@Concurrency@@AAEXXZ 0008 __EH_prolog3 002f ??2@YAPAXI@Z 0041 ??0CancellationBeaconNode@CancellationBeaconStack@ContextBase@details@Concurrency@@QAE@XZ 0096 __EH_epilog3"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D9 8B 73 04 33 FF C1 FE 04 89 7D F0 83 FE 04 7D 31 85 F6 7E 0A 8B 43 08 8B 44 B0 FC 89 45 F0 6A 08 E8 ?? ?? ?? ?? 59 89 45 EC 89 7D FC 85 C0 74 09 8B C8 E8 ?? ?? ?? ?? 8B F8 8B 43 08 89 3C B0 EB 38 8B 43 08 8B 40 0C 8B C8 89 45 F0 83 EE 03 74 09 89 4D F0 8B 49 04 4E 75 F7 6A 08 E8 ?? ?? ?? ?? 59 89 45 EC C7 45 FC 01 00 00 00 85 C0 74 09 8B C8 E8 ?? ?? ?? ?? 8B F8 8B 45 F0 85 C0 74 03 89 78 04 83 43 04 10 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_190_144_0 {
	meta:
		name = "__ehhandler$?Grow@CancellationBeaconStack@ContextBase@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Grow@CancellationBeaconStack@ContextBase@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_8_2 {
	meta:
		name = "__ehhandler$??$?0$$A6A_NABW4agent_status@Concurrency@@@Z@?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAE@A6A_NABW4agent_status@Concurrency@@@Z@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0$$A6A_NABW4agent_status@Concurrency@@@Z@?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAE@A6A_NABW4agent_status@Concurrency@@@Z@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_38_2 {
	meta:
		name = "__ehhandler$??$?0ABVexception_ptr@std@@V_TaskCreationCallstack@details@Concurrency@@@?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@QAE@ABVexception_ptr@1@$$QAV_TaskCreationCallstack@details@Concurrency@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0ABVexception_ptr@std@@V_TaskCreationCallstack@details@Concurrency@@@?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@QAE@ABVexception_ptr@1@$$QAV_TaskCreationCallstack@details@Concurrency@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_544_13_0 {
	meta:
		name = "__ehhandler$??$_Resetp@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@std@@AAEXPAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Resetp@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@std@@AAEXPAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_326_2 {
	meta:
		name = "__ehhandler$??$make_shared@U?$_Task_impl@E@details@Concurrency@@AAPAV_CancellationTokenState@23@AAUscheduler_ptr@3@@std@@YA?AV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@4@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$make_shared@U?$_Task_impl@E@details@Concurrency@@AAPAV_CancellationTokenState@23@AAUscheduler_ptr@3@@std@@YA?AV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@4@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_330_2 {
	meta:
		name = "__ehhandler$??$make_shared@U?$_Task_impl@_N@details@Concurrency@@AAPAV_CancellationTokenState@23@AAUscheduler_ptr@3@@std@@YA?AV?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@0@AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@4@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$make_shared@U?$_Task_impl@_N@details@Concurrency@@AAPAV_CancellationTokenState@23@AAUscheduler_ptr@3@@std@@YA?AV?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@0@AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@4@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_334_2 {
	meta:
		name = "__ehhandler$??$make_shared@U_ExceptionHolder@details@Concurrency@@ABVexception_ptr@std@@V_TaskCreationCallstack@23@@std@@YA?AV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@0@ABVexception_ptr@0@$$QAV_TaskCreationCallstack@details@Concurrency@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$make_shared@U_ExceptionHolder@details@Concurrency@@ABVexception_ptr@std@@V_TaskCreationCallstack@23@@std@@YA?AV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@0@ABVexception_ptr@0@$$QAV_TaskCreationCallstack@details@Concurrency@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_39_1 {
	meta:
		name = "__ehhandler$??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_33_2 {
	meta:
		name = "__ehhandler$??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_33_2 {
	meta:
		name = "__ehhandler$??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_33_2 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_33_39_1 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_33_2 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_316_2 {
	meta:
		name = "__ehhandler$??0?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@QAE@ABV?$function@$$A6AXABI@Z@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@QAE@ABV?$function@$$A6AXABI@Z@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_629_2 {
	meta:
		name = "__ehhandler$??0_Task_impl_base@details@Concurrency@@QAE@PAV_CancellationTokenState@12@Uscheduler_ptr@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Task_impl_base@details@Concurrency@@QAE@PAV_CancellationTokenState@12@Uscheduler_ptr@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_423_1 {
	meta:
		name = "__ehhandler$??0agent@Concurrency@@QAE@AAVScheduleGroup@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0agent@Concurrency@@QAE@AAVScheduleGroup@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_426_1 {
	meta:
		name = "__ehhandler$??0agent@Concurrency@@QAE@AAVScheduler@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0agent@Concurrency@@QAE@AAVScheduler@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_429_1 {
	meta:
		name = "__ehhandler$??0agent@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0agent@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_683_1 {
	meta:
		name = "__ehhandler$??0task_options@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0task_options@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_602_2 {
	meta:
		name = "__ehhandler$??1_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_606_2 {
	meta:
		name = "__ehhandler$??1_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_797_45_0 {
	meta:
		name = "__ehhandler$??1event@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1event@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1085_2_0 {
	meta:
		name = "__ehhandler$??2@YAPAXIABUnothrow_t@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??2@YAPAXIABUnothrow_t@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1324_67_0 {
	meta:
		name = "__ehhandler$?Activate@UMSFreeVirtualProcessorRoot@details@Concurrency@@UAEXPAUIExecutionContext@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Activate@UMSFreeVirtualProcessorRoot@details@Concurrency@@UAEXPAUIExecutionContext@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1316_107_0 {
	meta:
		name = "__ehhandler$?CreateSingleton@ResourceManager@details@Concurrency@@SAPAV123@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateSingleton@ResourceManager@details@Concurrency@@SAPAV123@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_600_257_0 {
	meta:
		name = "__ehhandler$?GetDefaultScheduler@SchedulerBase@details@Concurrency@@CAPAV123@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetDefaultScheduler@SchedulerBase@details@Concurrency@@CAPAV123@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1316_211_0 {
	meta:
		name = "__ehhandler$?RemoveExecutionResource@ResourceManager@details@Concurrency@@QAEXPAVExecutionResource@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RemoveExecutionResource@ResourceManager@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_435_160_0 {
	meta:
		name = "__ehhandler$?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AAEX_N0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AAEX_N0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_1088_1 {
	meta:
		name = "__ehhandler$?_CreateImpl@?$task@E@Concurrency@@QAEXPAV_CancellationTokenState@details@2@Uscheduler_ptr@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CreateImpl@?$task@E@Concurrency@@QAEXPAV_CancellationTokenState@details@2@Uscheduler_ptr@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_1094_1 {
	meta:
		name = "__ehhandler$?_CreateImpl@?$task@_N@Concurrency@@QAEXPAV_CancellationTokenState@details@2@Uscheduler_ptr@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CreateImpl@?$task@_N@Concurrency@@QAEXPAV_CancellationTokenState@details@2@Uscheduler_ptr@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_328_1 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_692_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_695_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_435_189_0 {
	meta:
		name = "__ehhandler$?_Initialize@_TaskCollection@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Initialize@_TaskCollection@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_1173_2 {
	meta:
		name = "__ehhandler$?_JoinAllTokens_Add@details@Concurrency@@YAXABVcancellation_token_source@2@PAV_CancellationTokenState@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_JoinAllTokens_Add@details@Concurrency@@YAXABVcancellation_token_source@2@PAV_CancellationTokenState@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_119_301_2 {
	meta:
		name = "__ehhandler$?_Makexloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Makexloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_1276_1 {
	meta:
		name = "__ehhandler$?_Perform@?$_Continuation_func_transformer@_NV?$task@_N@Concurrency@@@Concurrency@@SA?AV?$function@$$A6A?AV?$task@_N@Concurrency@@_N@Z@std@@V34@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Perform@?$_Continuation_func_transformer@_NV?$task@_N@Concurrency@@@Concurrency@@SA?AV?$function@$$A6A?AV?$task@_N@Concurrency@@_N@Z@std@@V34@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_1317_1 {
	meta:
		name = "__ehhandler$?_RunContinuation@_Task_impl_base@details@Concurrency@@QAEXPAU_ContinuationTaskHandleBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RunContinuation@_Task_impl_base@details@Concurrency@@QAEXPAU_ContinuationTaskHandleBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_1334_1 {
	meta:
		name = "__ehhandler$?_ScheduleTask@_TaskCollectionImpl@details@Concurrency@@QAEXPAU_TaskProcHandle@23@W4_TaskInliningMode@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_ScheduleTask@_TaskCollectionImpl@details@Concurrency@@QAEXPAU_TaskProcHandle@23@W4_TaskInliningMode@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_544_120_0 {
	meta:
		name = "__ehhandler$?__ExceptionPtrCurrentException@@YAXPAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?__ExceptionPtrCurrentException@@YAXPAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_111_123_2 {
	meta:
		name = "__ehhandler$?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEAAV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEAAV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_141_1 {
	meta:
		name = "__ehhandler$?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEAAV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEAAV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_54_141_1 {
	meta:
		name = "__ehhandler$?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEAAV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEAAV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_342_2 {
	meta:
		name = "__ehhandler$?global@locale@std@@SA?AV12@ABV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?global@locale@std@@SA?AV12@ABV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_190_149_0 {
	meta:
		name = "?HasVirtualProcessorAvailableForNewWork@SchedulerBase@details@Concurrency@@QBE_NXZ"
		size = 22
	strings:
		$1 = { 8B 81 B8 01 00 00 8B 89 B4 01 00 00 2B C8 33 C0 85 C9 0F 9F C0 C3 }
	condition:
		$1
}

rule file_190_150_0 {
	meta:
		name = "?HashValue@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAIABQAV_TaskCollection@23@H@Z"
		size = 44
		altNames = "?HashValue@?$Hash@II@details@Concurrency@@CAIABIH@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 BA C5 9D 1C 81 33 C9 0F B6 04 31 33 C2 69 D0 93 01 00 01 41 83 F9 04 72 EE 8B C2 33 D2 F7 75 0C 5E 8B C2 5D C3 }
	condition:
		$1
}

rule file_190_156_0 {
	meta:
		name = "?IsCanceledAtDepth@ContextBase@details@Concurrency@@AAE_NPAV_TaskCollectionBase@23@H@Z"
		size = 234
		refs = "0074 ?_SafeGetParent@_TaskCollectionBase@details@Concurrency@@IAEPAV123@XZ 008a ?_GetTokenState@_TaskCollectionBase@details@Concurrency@@QAEPAV_CancellationTokenState@23@PAPAV_CancellationTokenRegistration@23@@Z 00a9 ?_IsMarkedForAbnormalExit@_TaskCollection@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 83 7F 70 00 0F 8E AC 00 00 00 8B 5D 0C 39 5F 68 0F 8F A0 00 00 00 83 7F 3C FF 0F 84 BE 00 00 00 8B 47 68 3B 47 3C 0F 8D B2 00 00 00 8B 47 34 8B 75 08 3B F0 75 21 8B 40 04 C1 E0 04 C1 F8 04 3B D8 75 14 8B 4F 38 83 F9 02 74 6B 8B 49 08 33 C0 85 C9 0F 95 C0 EB 61 3B 77 30 74 56 8B 46 04 C1 E0 04 C1 F8 04 3B C3 74 49 8B CE E8 ?? ?? ?? ?? 8B F0 85 F6 75 E1 EB 3A 3B 77 30 74 42 6A 00 8B CE E8 ?? ?? ?? ?? 85 C0 75 35 8B 46 04 C1 F8 1C 24 01 74 06 F6 46 18 03 75 44 84 C0 75 0B 8B CE E8 ?? ?? ?? ?? 84 C0 75 35 8B CE E8 ?? ?? ?? ?? 8B F0 85 F6 75 C2 32 C0 5F 5E 5B 5D C2 08 00 85 F6 74 F3 3B 77 30 74 EE 6A 00 8B CE E8 ?? ?? ?? ?? 83 F8 02 74 E0 8B 48 08 E9 70 FF FF FF B0 01 EB D6 }
	condition:
		$1
}

rule file_190_157_0 {
	meta:
		name = "?IsCanceledAtDepth@ContextBase@details@Concurrency@@QAE_NH@Z"
		size = 18
		refs = "000a ?IsCanceledAtDepth@ContextBase@details@Concurrency@@AAE_NPAV_TaskCollectionBase@23@H@Z"
	strings:
		$1 = { 55 8B EC FF 75 08 FF 71 34 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_190_158_0 {
	meta:
		name = "?IsCanceledAtDepth@ContextBase@details@Concurrency@@QAE_NPAV_TaskCollectionBase@23@@Z"
		size = 26
		refs = "0012 ?IsCanceledAtDepth@ContextBase@details@Concurrency@@AAE_NPAV_TaskCollectionBase@23@H@Z"
	strings:
		$1 = { 55 8B EC 8B 55 08 8B 42 04 C1 E0 04 C1 F8 04 50 52 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_190_159_0 {
	meta:
		name = "?IsCancellationVisible@ContextBase@details@Concurrency@@QBE_NPAV_TaskCollectionBase@23@_N@Z"
		size = 57
		refs = "0015 ?TokenHidesCancellation@ContextBase@details@Concurrency@@QBE_NPAV_TaskCollectionBase@23@_N@Z 0026 ?_WillInterruptForPendingCancel@_TaskCollectionBase@details@Concurrency@@IAE_NXZ"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 33 DB 39 5E 70 7E 0F FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 84 C0 74 11 39 5E 78 7E 0F 8B 4D 08 E8 ?? ?? ?? ?? 84 C0 74 03 33 DB 43 5E 8A C3 5B 5D C2 08 00 }
	condition:
		$1
}

rule file_190_165_0 {
	meta:
		name = "?IsOneShotInitialized@SchedulerBase@details@Concurrency@@SA_NXZ"
		size = 17
		refs = "0001 ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA"
	strings:
		$1 = { A1 ?? ?? ?? ?? 25 00 00 00 80 F7 D8 1B C0 F7 D8 C3 }
	condition:
		$1
}

rule file_190_168_0 {
	meta:
		name = "?LockedSetOwningContext@WorkQueue@details@Concurrency@@QAEXPAVContextBase@23@@Z"
		size = 35
		refs = "000b ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ 0019 ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 57 8B F9 8D 4F 70 E8 ?? ?? ?? ?? 8B 45 08 8D 4F 70 89 47 48 E8 ?? ?? ?? ?? 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_190_169_0 {
	meta:
		name = "?Next@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@PAHPAU4123@@Z"
		size = 27
		refs = "0013 ?NextList@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@PAH@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 00 85 C0 75 0B 8B 45 08 50 FF 00 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule file_190_170_0 {
	meta:
		name = "?Next@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QBEPAUListEntry@23@PAU423@@Z"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 08 3B 01 74 05 8B 40 04 EB 02 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_190_171_0 {
	meta:
		name = "?NextList@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@PAH@Z"
		size = 49
	strings:
		$1 = { 55 8B EC 56 8B 75 08 8B 16 3B 11 7D 13 8B 41 08 8D 04 90 83 38 00 75 0F 42 83 C0 04 3B 11 7C F3 33 C0 5E 5D C2 04 00 89 16 8B 41 08 8B 04 90 EB F1 }
	condition:
		$1
}

rule file_190_172_0 {
	meta:
		name = "?Pop@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ"
		size = 78
		refs = "003b ?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NPAPAV_UnrealizedChore@34@@Z"
	strings:
		$1 = { 53 56 8B F1 33 DB 57 8B 7E 04 8B 56 08 4F 8B 46 0C 23 D7 89 7E 04 8D 04 90 87 18 85 DB 75 06 8D 47 01 89 46 04 F6 C3 01 74 1E 8B 4E 08 83 E3 FE 8B 46 10 23 CF 6A 00 8D 0C C8 E8 ?? ?? ?? ?? 84 C0 75 05 33 C0 40 EB 02 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule file_576_124_0 {
	meta:
		name = "?Pop@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ"
		size = 78
		refs = "003b ?Claim@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE_NPAPAVInternalContextBase@34@@Z"
	strings:
		$1 = { 53 56 8B F1 33 DB 57 8B 7E 04 8B 56 08 4F 8B 46 0C 23 D7 89 7E 04 8D 04 90 87 18 85 DB 75 06 8D 47 01 89 46 04 F6 C3 01 74 1E 8B 4E 08 83 E3 FE 8B 46 10 23 CF 6A 00 8D 0C C8 E8 ?? ?? ?? ?? 84 C0 75 05 33 C0 40 EB 02 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule file_190_173_0 {
	meta:
		name = "?Pop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ"
		size = 90
		refs = "0038 ?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NPAPAV_UnrealizedChore@34@@Z 0056 ?SyncPop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEPAV_UnrealizedChore@23@XZ"
	strings:
		$1 = { 53 8B D1 56 57 8D 7A 04 8B 37 4E 8B C6 87 07 39 32 7F 38 8B 4A 08 8B 42 1C 23 CE 8B 1C 88 85 DB 74 E6 F6 C3 01 74 20 8B 4A 08 83 E3 FE 8B 42 20 23 CE 6A 00 8D 0C C8 E8 ?? ?? ?? ?? 84 C0 75 07 33 C0 40 5F 5E 5B C3 8B C3 EB F8 8D 46 01 8B CA 89 07 5F 5E 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_190_175_0 {
	meta:
		name = "?PopContextFromTls@ContextBase@details@Concurrency@@AAEPAV123@XZ"
		size = 30
		refs = "000a ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 000f ?__TlsSetValue@platform@details@Concurrency@@YAXKPAX@Z"
	strings:
		$1 = { 56 57 8B F9 8B 77 24 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 67 24 00 8B C6 59 59 5F 5E C3 }
	condition:
		$1
}

rule file_190_176_0 {
	meta:
		name = "?PopGoverningTokenState@ContextBase@details@Concurrency@@QAEXPAV_CancellationTokenState@23@@Z"
		size = 97
		refs = "0008 ?_SafeGetParent@_TaskCollectionBase@details@Concurrency@@IAEPAV123@XZ 001c ?_GetTokenState@_TaskCollectionBase@details@Concurrency@@QAEPAV_CancellationTokenState@23@PAPAV_CancellationTokenRegistration@23@@Z"
	strings:
		$1 = { 56 57 8B F9 8B 4F 34 E8 ?? ?? ?? ?? 8B F0 85 F6 74 42 3B 77 30 74 1A 6A 00 8B CE E8 ?? ?? ?? ?? 85 C0 75 0D 8B CE E8 ?? ?? ?? ?? 8B F0 85 F6 75 E1 85 F6 74 1F 3B 77 30 74 1A 6A 00 8B CE E8 ?? ?? ?? ?? 89 47 38 8B 46 04 C1 E0 04 C1 F8 04 89 47 3C EB 08 83 67 38 00 83 4F 3C FF 5F 5E C2 04 00 }
	condition:
		$1
}

rule file_190_179_0 {
	meta:
		name = "?PullFromFreePool@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEPAVWorkQueue@23@XZ"
		size = 16
		refs = "0003 __imp__InterlockedPopEntrySList@4"
	strings:
		$1 = { 51 FF 15 ?? ?? ?? ?? 85 C0 75 01 C3 83 C0 E8 C3 }
	condition:
		$1
}

rule file_190_181_0 {
	meta:
		name = "?Push@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
		size = 101
		refs = "005b ?GrowAndPush@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEXPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 8B D1 56 57 8B 72 04 8B 02 8B 7A 08 03 C7 3B F0 8B 45 0C 7D 31 85 C0 74 17 8B 4A 10 23 FE 89 04 F9 8B 45 10 89 44 F9 04 8B 7D 08 83 CF 01 EB 03 8B 7D 08 8B 4A 08 8B 42 0C 23 CE 89 3C 88 8D 46 01 89 42 04 EB 16 51 51 8B CC FF 75 08 89 01 8B 45 10 89 41 04 8B CA E8 ?? ?? ?? ?? 5F 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_190_182_0 {
	meta:
		name = "?Push@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEHPAV_UnrealizedChore@23@@Z"
		size = 70
		refs = "003c ?SyncPush@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEHPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 8B D1 56 57 8B 72 04 8B 02 8B 7A 08 03 C7 3B F0 7D 18 8B 4A 1C 23 FE 8B 45 08 89 04 B9 8D 46 01 89 42 04 8B 42 0C 03 C6 EB 13 51 51 8B C4 FF 75 08 83 20 00 83 60 04 00 E8 ?? ?? ?? ?? 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_190_183_0 {
	meta:
		name = "?Push@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEHPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
		size = 106
		refs = "0060 ?SyncPush@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEHPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 8B D1 56 57 8B 72 04 8B 02 8B 7A 08 03 C7 3B F0 8B 45 0C 7D 36 85 C0 74 17 8B 4A 20 23 FE 89 04 F9 8B 45 10 89 44 F9 04 8B 7D 08 83 CF 01 EB 03 8B 7D 08 8B 4A 08 8B 42 1C 23 CE 89 3C 88 8D 46 01 89 42 04 8B 42 0C 03 C6 EB 16 51 51 8B CC FF 75 08 89 01 8B 45 10 89 41 04 8B CA E8 ?? ?? ?? ?? 5F 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_190_184_0 {
	meta:
		name = "?PushCancellationBeacon@ContextBase@details@Concurrency@@QAEPAU_Beacon_reference@23@XZ"
		size = 69
		refs = "0020 ?AcquirePushBeacon@CancellationBeaconStack@ContextBase@details@Concurrency@@QAEPAUCancellationBeacon@234@H@Z"
	strings:
		$1 = { 56 8B F1 8B 46 34 85 C0 74 0B 8B 40 04 C1 E0 04 C1 F8 04 EB 03 83 C8 FF 50 8D 8E 8C 00 00 00 E8 ?? ?? ?? ?? 83 7E 74 00 8B D0 75 0E 83 7E 68 FF 74 0F 8B 4E 68 3B 4A 04 7F 07 33 C0 40 F0 0F C1 02 8B C2 5E C3 }
	condition:
		$1
}

rule file_190_185_0 {
	meta:
		name = "?PushContextToTls@ContextBase@details@Concurrency@@AAEXPAV123@@Z"
		size = 27
		refs = "000c ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 0011 ?__TlsSetValue@platform@details@Concurrency@@YAXKPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 51 89 41 24 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 5D C2 04 00 }
	condition:
		$1
}

rule file_190_186_0 {
	meta:
		name = "?PushGoverningTokenState@ContextBase@details@Concurrency@@QAEXPAV_CancellationTokenState@23@H@Z"
		size = 19
	strings:
		$1 = { 55 8B EC 8B 45 08 89 41 38 8B 45 0C 89 41 3C 5D C2 08 00 }
	condition:
		$1
}

rule file_190_187_0 {
	meta:
		name = "?PushStructured@ContextBase@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"
		size = 101
		refs = "000f ?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 001a ?Push@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 57 33 FF 39 7E 20 75 05 E8 ?? ?? ?? ?? FF 75 08 8B 4E 20 E8 ?? ?? ?? ?? 80 7E 4C 00 8B 86 9C 00 00 00 74 05 FF 40 08 EB 03 FF 40 68 8B 46 1C 8B 88 B8 01 00 00 8B 80 B4 01 00 00 2B C1 85 C0 7E 18 83 EC 10 8B C4 89 38 89 78 08 89 78 0C 8B 4E 1C FF 76 18 8B 01 FF 50 38 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_190_188_0 {
	meta:
		name = "?PushStructured@ContextBase@details@Concurrency@@QAEXPAV_UnrealizedChore@23@PAVlocation@3@@Z"
		size = 220
		refs = "002f ??8location@Concurrency@@QBE_NABV01@@Z 007f ?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 008a ?PushStructured@WorkQueue@details@Concurrency@@QAEXPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z 00c4 ?_Assign@location@Concurrency@@QAEXABV12@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 65 F8 00 83 65 F4 00 53 8B 5D 0C 56 8B F1 57 8B 7E 18 89 7D FC 85 DB 74 47 F7 03 FF FF FF 0F 74 3F 8D 47 0C 8B CB 50 E8 ?? ?? ?? ?? 84 C0 75 24 8B 8F 00 01 00 00 8D 55 FC 52 53 FF 75 08 8B 01 8D 55 F0 52 FF 50 18 8B 7D FC 8B 18 8B 40 04 89 45 F4 EB 03 8B 5D F8 8B 07 8B CF FF 50 04 EB 03 8B 5D F8 51 51 8B 4D F4 8B C4 89 18 89 48 04 83 7E 20 00 75 07 8B CE E8 ?? ?? ?? ?? FF 75 08 8B 4E 20 E8 ?? ?? ?? ?? 80 7E 4C 00 8B 86 9C 00 00 00 74 05 FF 40 08 EB 03 FF 40 68 8B 46 1C 8B 88 B8 01 00 00 8B 80 B4 01 00 00 2B C1 85 C0 7E 1C 8B 45 FC 83 EC 10 83 C0 0C 8B CC 50 E8 ?? ?? ?? ?? 8B 4E 1C FF 75 FC 8B 01 FF 50 38 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_190_190_0 {
	meta:
		name = "?PushStructured@WorkQueue@details@Concurrency@@QAEXPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
		size = 30
		refs = "0016 ?Push@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 51 51 8B D4 FF 75 08 89 02 8B 45 10 89 42 04 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule file_190_191_0 {
	meta:
		name = "?PushUnstructured@ContextBase@details@Concurrency@@QAEHPAV_UnrealizedChore@23@@Z"
		size = 115
		refs = "0010 ?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 001e ?Push@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEHPAV_UnrealizedChore@23@@Z"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 33 DB 57 39 5E 20 75 05 E8 ?? ?? ?? ?? 8B 4E 20 FF 75 08 83 C1 4C E8 ?? ?? ?? ?? 8B F8 38 5E 4C 74 0B 8B 8E 9C 00 00 00 FF 41 08 EB 09 8B 86 9C 00 00 00 FF 40 68 8B 46 1C 8B 88 B8 01 00 00 8B 80 B4 01 00 00 2B C1 85 C0 7E 18 83 EC 10 8B C4 89 18 89 58 08 89 58 0C 8B 4E 1C FF 76 18 8B 01 FF 50 38 8B C7 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_190_192_0 {
	meta:
		name = "?PushUnstructured@ContextBase@details@Concurrency@@QAEHPAV_UnrealizedChore@23@PAVlocation@3@@Z"
		size = 224
		refs = "002f ??8location@Concurrency@@QBE_NABV01@@Z 007f ?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 008a ?PushUnstructured@WorkQueue@details@Concurrency@@QAEHPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z 00c6 ?_Assign@location@Concurrency@@QAEXABV12@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 65 F8 00 83 65 F4 00 53 8B 5D 0C 56 8B F1 57 8B 7E 18 89 7D FC 85 DB 74 47 F7 03 FF FF FF 0F 74 3F 8D 47 0C 8B CB 50 E8 ?? ?? ?? ?? 84 C0 75 24 8B 8F 00 01 00 00 8D 55 FC 52 53 FF 75 08 8B 01 8D 55 F0 52 FF 50 18 8B 7D FC 8B 18 8B 40 04 89 45 F4 EB 03 8B 5D F8 8B 07 8B CF FF 50 04 EB 03 8B 5D F8 51 51 8B 4D F4 8B C4 89 18 89 48 04 83 7E 20 00 75 07 8B CE E8 ?? ?? ?? ?? FF 75 08 8B 4E 20 E8 ?? ?? ?? ?? 80 7E 4C 00 8B F8 8B 86 9C 00 00 00 74 05 FF 40 08 EB 03 FF 40 68 8B 46 1C 8B 88 B8 01 00 00 8B 80 B4 01 00 00 2B C1 85 C0 7E 1C 8B 45 FC 83 EC 10 83 C0 0C 8B CC 50 E8 ?? ?? ?? ?? 8B 4E 1C FF 75 FC 8B 11 FF 52 38 8B C7 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_190_194_0 {
	meta:
		name = "?PushUnstructured@WorkQueue@details@Concurrency@@QAEHPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
		size = 33
		refs = "0019 ?Push@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEHPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 51 51 8B D4 83 C1 4C FF 75 08 89 02 8B 45 10 89 42 04 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule file_190_196_0 {
	meta:
		name = "?RecomputeMaximumCancellationDepth@ContextBase@details@Concurrency@@AAEXXZ"
		size = 137
		refs = "0043 ?_IsMarkedForAbnormalExit@_TaskCollection@details@Concurrency@@QBE_NXZ 004e ?_SafeGetParent@_TaskCollectionBase@details@Concurrency@@IAEPAV123@XZ"
	strings:
		$1 = { 55 8B EC 51 53 8B D9 83 C8 FF 56 57 8D 4B 6C 89 4D FC 87 01 8B 73 74 8B 7B 34 F7 DE 1B F6 81 E6 1A FC FF FF 4E EB 2D 3B 7B 30 74 37 8B 47 04 C1 F8 1C 24 01 74 06 F6 47 18 03 75 1E 84 C0 75 0B 8B CF E8 ?? ?? ?? ?? 84 C0 75 0F 8B CF E8 ?? ?? ?? ?? 8B F8 85 FF 75 CF EB 09 8B 77 04 C1 E6 04 C1 FE 04 8B 7D FC 83 CA FF 83 FA FF 74 04 3B F2 7C 10 8B CE 8B C2 F0 0F B1 0F 3B C2 74 04 8B D0 EB E7 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_190_200_0 {
	meta:
		name = "?ReleaseWorkQueue@ContextBase@details@Concurrency@@IAEXXZ"
		size = 87
		refs = "001c ?LockedSetOwningContext@WorkQueue@details@Concurrency@@QAEXPAVContextBase@23@@Z 0025 ?DetachActiveWorkQueue@ScheduleGroupSegmentBase@details@Concurrency@@IAEXPAVWorkQueue@23@@Z 004a ?Remove@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE_NPAVWorkQueue@23@H_N@Z 0053 ?DetachStealers@ContextBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 56 57 8B F9 8B 77 20 85 F6 74 43 33 C9 89 4F 20 8B 46 50 3B 46 4C 7E 13 51 8B CE E8 ?? ?? ?? ?? 8B 4F 18 56 E8 ?? ?? ?? ?? EB 23 39 4E 70 74 0A 51 8B CE E8 ?? ?? ?? ?? EB 03 89 4E 48 8B 4F 18 6A 01 FF 76 44 83 C1 58 56 E8 ?? ?? ?? ?? 8B CF 5F 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_190_202_0 {
	meta:
		name = "?Remove@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@ABQAV_TaskCollection@23@H@Z"
		size = 72
	strings:
		$1 = { 55 8B EC 53 8B 5D 0C 56 57 8B F9 33 F6 8B 4F 08 8B 14 99 85 D2 74 12 8B 45 08 8B 00 39 42 04 74 11 8B F2 8B 12 85 D2 75 F3 33 C0 5F 5E 5B 5D C2 08 00 85 F6 75 07 8B 02 89 04 99 EB 04 8B 0A 89 0E FF 4F 04 8B C2 EB E3 }
	condition:
		$1
}

rule file_190_203_0 {
	meta:
		name = "?Remove@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
		size = 46
	strings:
		$1 = { 55 8B EC 56 8B 75 08 8B 56 04 8B 06 89 02 8B 16 8B 46 04 89 42 04 8B 01 3B F0 5E 75 0D 3B 40 04 75 04 33 C0 EB 02 8B 00 89 01 5D C2 04 00 }
	condition:
		$1
}

rule file_190_204_0 {
	meta:
		name = "?Remove@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE_NPAVWorkQueue@23@H_N@Z"
		size = 248
		refs = "0077 __imp__QueryDepthSList@4 0093 __imp__InterlockedPushEntrySList@8 00a6 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 00c1 __imp__InterlockedFlushSList@4 00d0 ?CheckForDeletionBridge@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@CAXPAV123@@Z 00d5 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { 55 8B EC 51 8B 55 0C 53 56 8B F1 8B 4E 2C 8B 5E 28 D3 FA 4B 23 5D 0C 3B 56 3C 7C 07 32 C0 E9 CD 00 00 00 8B 4E 38 8B 46 34 57 3B D1 7C 11 2B D1 8B 7C 88 FC 78 0C 42 8B 7F 04 4A 75 FA EB 03 8B 3C 90 8B 07 33 D2 8B 4D 08 89 4D 0C 8D 0C 98 8B 45 0C F0 0F B1 11 89 45 FC 8B 45 FC 3B 45 0C 0F 85 88 00 00 00 6A FE 8D 4F 08 58 F0 0F B1 19 80 7D 10 00 74 74 8B 3D ?? ?? ?? ?? 56 FF D7 0F B7 C0 3B 46 44 7E 55 8B 45 08 8D 5E 08 83 C0 18 50 53 FF 15 ?? ?? ?? ?? 53 FF D7 0F B7 C0 3B 46 44 7E 47 8B 4E 24 E8 ?? ?? ?? ?? 84 C0 75 3B 33 D2 8D 4E 48 42 33 C0 F0 0F B1 11 85 C0 75 2B 53 FF 15 ?? ?? ?? ?? FF 76 24 8D 4E 14 89 46 10 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0E 8B 4D 08 83 C1 18 51 56 FF 15 ?? ?? ?? ?? B0 01 EB 02 32 C0 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_190_205_0 {
	meta:
		name = "?Remove@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE_NPAVWorkQueue@23@_N@Z"
		size = 22
		refs = "000e ?Remove@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE_NPAVWorkQueue@23@H_N@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 FF 75 0C FF 70 44 50 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule file_190_207_0 {
	meta:
		name = "?RemoveStealer@ContextBase@details@Concurrency@@QAEXPAV123@@Z"
		size = 22
		refs = "000e ?Remove@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 C1 50 83 C0 5C 50 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_190_208_0 {
	meta:
		name = "?ScheduleGroupRefCount@ContextBase@details@Concurrency@@QBEIXZ"
		size = 21
	strings:
		$1 = { 8B 41 18 85 C0 74 0A 8B 80 00 01 00 00 8B 40 14 C3 83 C8 FF C3 }
	condition:
		$1
}

rule file_190_212_0 {
	meta:
		name = "?StaticDelete@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@SAXPAU1234@@Z"
		size = 25
		refs = "000d ??1Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 74 0E 8B 4D 08 E8 ?? ?? ?? ?? 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_501_85_0 {
	meta:
		name = "?StaticDelete@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@SAXPAU1234@@Z"
		size = 25
		refs = "000d ??1Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 74 0E 8B 4D 08 E8 ?? ?? ?? ?? 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_190_217_0 {
	meta:
		name = "?StaticGetCriticalRegionType@ContextBase@details@Concurrency@@SA?AW4CriticalRegionType@3@XZ"
		size = 19
		refs = "0001 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 07 8B 10 8B C8 FF 62 40 33 C0 C3 }
	condition:
		$1
}

rule file_190_218_0 {
	meta:
		name = "?SweepAliasTable@ContextBase@details@Concurrency@@QAEXXZ"
		size = 126
		refs = "0018 ?NextList@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@PAH@Z 003d ?_IsStaleAlias@_TaskCollection@details@Concurrency@@ABE_NXZ 004b ?_OriginalCollection@_TaskCollection@details@Concurrency@@QBEPAV123@XZ 005b ?FindAndDelete@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE_NABQAV_TaskCollection@23@PAPAV423@@Z 0066 ??1_TaskCollection@details@Concurrency@@QAE@XZ 006c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 51 83 65 FC 00 8D 45 FC 53 57 8D 99 80 00 00 00 50 8B CB E8 ?? ?? ?? ?? 8B F8 85 FF 74 56 56 8B 37 85 F6 75 10 FF 45 FC 8D 45 FC 50 8B CB E8 ?? ?? ?? ?? 8B F0 8B 4F 08 E8 ?? ?? ?? ?? 84 C0 74 2C 8B 7F 08 8B CF E8 ?? ?? ?? ?? 89 45 F8 8B CB 6A 00 8D 45 F8 50 E8 ?? ?? ?? ?? 85 FF 74 0E 8B CF E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 8B FE 85 F6 75 AC 5E 5F 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_190_220_0 {
	meta:
		name = "?SyncPop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEPAV_UnrealizedChore@23@XZ"
		size = 150
		refs = "0003 __ehhandler$?SyncPop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEPAV_UnrealizedChore@23@XZ 0008 __EH_prolog3 0015 ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ 0077 ?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NPAPAV_UnrealizedChore@34@@Z 008a ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ 0091 __EH_epilog3"
	strings:
		$1 = { 6A 0C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 8B 4E 10 89 4D F0 E8 ?? ?? ?? ?? 8B 7E 04 33 C9 4F 89 4D E8 89 4D EC 8B D9 89 7E 04 89 4D FC 39 3E 7F 1F 8B 56 08 8B 46 1C 23 D7 8B 4E 20 8B 1C 90 8B 04 D1 89 45 E8 8B 44 D1 04 33 C9 89 45 EC EB 06 8D 47 01 89 46 04 39 3E 7C 10 8B 06 01 46 0C 89 0E 89 4E 04 89 4E 18 88 4E 14 F6 C3 01 74 13 51 8D 4D E8 83 E3 FE E8 ?? ?? ?? ?? 84 C0 75 03 33 DB 43 8B 4D F0 83 4D FC FF E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_190_223_0 {
	meta:
		name = "?SyncPush@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEHPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
		size = 394
		refs = "002f ??_U@YAPAXI@Z 0085 ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ 0162 ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ 016a ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 24 53 56 57 8B F9 33 C9 6A 04 5A 89 7D EC 8B 47 08 40 8D 1C 00 8B 47 04 8B 07 8B C3 89 5D E4 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 89 45 F0 33 C9 8B 47 1C 89 45 E0 8B C3 6A 08 5E F7 E6 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 89 45 FC 59 59 85 C0 74 17 8D 53 FF 8B C8 85 D2 78 12 83 21 00 83 61 04 00 03 CE 4A 79 F4 EB 04 83 65 FC 00 8B 77 10 8B CE 8B 47 20 89 45 DC 89 75 E8 E8 ?? ?? ?? ?? 8B 1F 8B 57 04 8B 4F 0C 2B D3 23 5F 08 8B 47 04 2B CB 83 65 F8 00 2B CA 03 C1 89 55 F4 89 47 0C 8D 04 13 89 1F 89 47 04 85 D2 7E 46 33 D2 8B 47 1C 8B CB 23 4F 08 8B 75 FC 8B 04 88 8B 4D F0 89 04 91 8B D3 23 57 08 8B 4F 20 8B 7D F8 8B 04 D1 89 04 FE 8B 44 D1 04 8B D7 8B 7D EC 8B CE 89 44 D1 04 42 43 89 55 F8 3B 55 F4 7C C2 8B 75 E8 8B 55 F4 8B 45 F0 89 47 1C 8B 45 FC 89 47 20 8B 07 01 47 0C 80 7F 14 00 74 05 8B 07 29 47 18 8B 45 E4 48 89 47 08 C7 07 00 00 00 00 89 57 04 8B 5F 04 8B 45 0C 85 C0 74 1A 8B 4F 20 8B D3 23 57 08 89 04 D1 8B 45 10 89 44 D1 04 8B 55 08 83 CA 01 EB 03 8B 55 08 8B 47 1C 8B CB 23 4F 08 89 14 88 8D 43 01 89 47 04 8B CE E8 ?? ?? ?? ?? FF 75 E0 E8 ?? ?? ?? ?? FF 75 DC E8 ?? ?? ?? ?? 8B 47 04 59 59 8B 4F 0C 5F 49 5E 03 C1 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_190_224_0 {
	meta:
		name = "?ThrowContextEvent@ContextBase@details@Concurrency@@KAXW4ConcRT_EventType@3@EKK@Z"
		size = 115
		refs = "0009 ?g_pEtw@details@Concurrency@@3PAVEtw@12@A 001c _memset 002b _ContextEventGuid 005d ?g_ConcRTSessionHandle@details@Concurrency@@3_KA 0068 ?Trace@Etw@details@Concurrency@@QAEK_KPAU_EVENT_TRACE_HEADER@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 40 53 8B 1D ?? ?? ?? ?? 85 DB 74 5D 56 57 6A 3E 8D 45 C2 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C C7 45 EC 00 00 02 00 BE ?? ?? ?? ?? 8D 7D D8 8B CB 6A 40 58 66 89 45 C0 8B 45 08 88 45 C4 8B 45 0C 88 45 C5 8B 45 10 A5 A5 A5 A5 89 45 F4 8B 45 14 89 45 F8 8D 45 C0 50 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_190_225_0 {
	meta:
		name = "?TokenHidesCancellation@ContextBase@details@Concurrency@@QBE_NPAV_TaskCollectionBase@23@_N@Z"
		size = 77
		refs = "0012 ?_GetTokenState@_TaskCollectionBase@details@Concurrency@@QAEPAV_CancellationTokenState@23@PAPAV_CancellationTokenRegistration@23@@Z"
	strings:
		$1 = { 55 8B EC 80 7D 0C 00 56 8B F1 74 19 8B 4D 08 6A 00 E8 ?? ?? ?? ?? 83 F8 02 74 06 83 78 08 00 75 04 B0 01 EB 23 8B 46 3C 39 46 6C 7D 19 83 F8 FF 74 14 8B 4E 38 83 F9 02 74 E7 8B 49 08 33 C0 85 C9 0F 94 C0 EB 02 32 C0 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_190_228_0 {
	meta:
		name = "?TryPop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@H@Z"
		size = 99
		refs = "0016 ?Pop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ 004a ?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NPAPAV_UnrealizedChore@34@@Z"
	strings:
		$1 = { 55 8B EC 8B D1 53 56 8B 75 08 2B 72 0C 8B 42 04 48 3B F0 75 07 E8 ?? ?? ?? ?? EB 41 3B 72 04 7D 3A 3B 32 7C 36 8B 4A 08 33 DB 8B 42 1C 23 CE 8D 04 88 87 18 F6 C3 01 74 1E 8B 4A 08 83 E3 FE 8B 42 20 23 CE 6A 00 8D 0C C8 E8 ?? ?? ?? ?? 84 C0 75 05 33 C0 40 EB 06 8B C3 EB 02 33 C0 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_190_240_0 {
	meta:
		name = "?_Confirm_cancel@_Cancellation_beacon@details@Concurrency@@QAE_NXZ"
		size = 38
		refs = "0004 ?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0013 ?IsCanceledAtDepth@ContextBase@details@Concurrency@@AAE_NPAV_TaskCollectionBase@23@H@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? 8B 16 8B C8 FF 72 04 FF 70 34 E8 ?? ?? ?? ?? 84 C0 75 09 8B 0E 83 CA FF F0 0F C1 11 5E C3 }
	condition:
		$1
}

rule file_190_248_0 {
	meta:
		name = "?_IsCurrentlyInlined@_TaskCollectionBase@details@Concurrency@@QBE_NXZ"
		size = 18
	strings:
		$1 = { 8B 49 04 BA FF FF FF 0F 23 CA 33 C0 3B CA 0F 95 C0 C3 }
	condition:
		$1
}

rule file_190_265_0 {
	meta:
		name = "?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QAEXI@Z"
		size = 36
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 75 09 C7 41 08 04 00 00 00 EB 0D 83 61 04 00 89 01 C7 41 08 01 00 00 00 5D C2 04 00 }
	condition:
		$1
}

rule file_190_269_0 {
	meta:
		name = "?_SpinOnce@?$_SpinWait@$0A@@details@Concurrency@@QAE_NXZ"
		size = 109
		refs = "0011 ?_Value@_SpinCount@details@Concurrency@@SAIXZ 0019 ?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 53 56 8B F1 33 DB 8B 46 08 2B C3 75 12 89 5E 08 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? EB E7 48 74 33 48 74 1C 48 74 05 48 74 24 EB 10 89 5E 08 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 32 C0 EB 29 FF 4E 04 75 07 C7 46 08 03 00 00 00 B3 01 F3 90 8A C3 EB 15 F3 90 FF 0E 75 0D 8B 46 04 F7 D8 1B C0 83 C0 03 89 46 08 B0 01 5E 5B C3 }
	condition:
		$1
}

rule file_190_273_0 {
	meta:
		name = "_MemoryBarrier"
		size = 16
	strings:
		$1 = { 55 8B EC 51 33 C9 8D 45 FC F0 09 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "___sse2_tanh2"
		size = 656
		refs = "0016 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC C0 00 00 00 83 E4 F0 89 84 24 84 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 28 C8 89 4C 24 60 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C7 89 74 24 64 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 54 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 58 D3 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 F2 66 0F 29 4C 24 50 66 0F 5C D3 8D 44 24 50 66 0F 28 CE 66 0F 59 E2 66 0F 57 DB 66 0F C2 3D ?? ?? ?? ?? 05 66 0F 73 F6 04 66 0F 29 4C 24 40 66 0F 59 EA 66 0F FB D9 66 0F 5C C4 66 0F 7E F6 89 7C 24 68 66 0F 5C C5 66 0F 50 CF 66 0F FE 0D ?? ?? ?? ?? 81 E6 F0 03 00 00 66 0F 15 F6 66 0F FE 1D ?? ?? ?? ?? 66 0F 73 F1 2E 66 0F 7E F7 66 0F 28 BE ?? ?? ?? ?? 81 E7 F0 03 00 00 66 0F 73 F3 2E 66 0F 29 44 24 30 F7 DE 66 0F 28 B7 ?? ?? ?? ?? 81 C6 00 04 00 00 66 0F DB 0D ?? ?? ?? ?? 66 0F 28 EF F7 DF 66 0F DB 1D ?? ?? ?? ?? 66 0F C6 EE 00 81 C7 00 04 00 00 66 0F 28 A6 ?? ?? ?? ?? 66 0F C6 FE 03 66 0F 28 97 ?? ?? ?? ?? 66 0F 59 E9 66 0F 28 F4 66 0F 59 F9 66 0F C6 E2 00 66 0F 29 2C 24 66 0F 28 C8 66 0F C6 F2 03 66 0F 59 E3 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C0 66 0F 29 64 24 20 66 0F 59 F3 66 0F 58 EF 66 0F 28 1D ?? ?? ?? ?? 83 F9 03 66 0F 59 D0 66 0F 58 E6 0F 84 C8 00 00 00 66 0F 29 7C 24 10 66 0F 59 D8 66 0F 58 15 ?? ?? ?? ?? 66 0F 28 FD 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 58 EC 66 0F 59 C3 66 0F 5C FC 66 0F 59 D1 66 0F 28 D8 66 0F 58 D1 66 0F 59 DD 66 0F 28 CA 66 0F 59 D7 66 0F 28 20 66 0F 59 C7 66 0F 58 DA 66 0F 59 CD 66 0F 28 7C 24 10 66 0F 58 DE 66 0F 28 6C 24 20 66 0F 58 DF 66 0F 5C F7 66 0F 28 14 24 66 0F 58 DD 66 0F 5C C6 66 0F 54 25 ?? ?? ?? ?? 66 0F 58 DA 66 0F 5C EA 66 0F 58 C1 8B 74 24 64 66 0F 5C C5 8B 7C 24 68 66 0F 5E C3 83 F9 01 66 0F 56 C4 7D 08 8B 4C 24 60 EB 5B 8B FF 7F 0A 66 0F 28 3D ?? ?? ?? ?? EB 10 66 0F 28 3D ?? ?? ?? ?? EB 06 8B FF 66 0F 57 FF 66 0F 28 08 66 0F 54 C7 66 0F 28 15 ?? ?? ?? ?? 66 0F 57 DB 66 0F 54 D1 66 0F 55 3D ?? ?? ?? ?? 66 0F C2 D9 03 8B 4C 24 60 66 0F 56 C7 8B 74 24 64 66 0F 56 C2 8B 7C 24 68 66 0F 56 C3 8B A4 24 84 00 00 00 C3 8D 49 00 }
	condition:
		$1
}

rule file_192_3_0 {
	meta:
		name = "?__crtGetStringTypeA_stat@@YAHPAUlocaleinfo_struct@@KPBDHPAGHH@Z"
		size = 248
		refs = "0005 ___security_cookie 0042 __imp__MultiByteToWideChar@24 0076 __alloca_probe_16 008a _malloc 00ad _memset 00d5 __imp__GetStringTypeW@16 00dd __freea 00f0 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 1C 53 56 57 33 FF 85 C9 75 0D 8B 45 08 8B 00 8B 40 04 8B C8 89 45 1C 57 33 C0 39 45 20 57 FF 75 14 0F 95 C0 FF 75 10 8D 04 C5 01 00 00 00 50 51 FF 15 ?? ?? ?? ?? 8B D8 85 DB 75 07 33 C0 E9 91 00 00 00 7E 4B 81 FB F0 FF FF 7F 77 43 8D 0C 1B 8D 41 08 3B C1 76 39 8D 04 5D 08 00 00 00 3D 00 04 00 00 77 13 E8 ?? ?? ?? ?? 8B F4 85 F6 74 CC C7 06 CC CC 00 00 EB 13 50 E8 ?? ?? ?? ?? 8B F0 59 85 F6 74 B7 C7 06 DD DD 00 00 83 C6 08 EB 02 8B F7 85 F6 74 A6 8D 04 1B 50 57 56 E8 ?? ?? ?? ?? 83 C4 0C 53 56 FF 75 14 FF 75 10 6A 01 FF 75 1C FF 15 ?? ?? ?? ?? 85 C0 74 10 FF 75 18 50 56 FF 75 0C FF 15 ?? ?? ?? ?? 8B F8 56 E8 ?? ?? ?? ?? 59 8B C7 8D 65 F0 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_192_6_0 {
	meta:
		name = "___crtGetStringTypeA"
		size = 64
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0028 ?__crtGetStringTypeA_stat@@YAHPAUlocaleinfo_struct@@KPBDHPAGHH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 08 8D 4D F0 E8 ?? ?? ?? ?? FF 75 20 8D 45 F0 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C 50 E8 ?? ?? ?? ?? 83 C4 1C 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "__global_unwind2"
		size = 32
		refs = "000c _gu_return 0014 _RtlUnwind@16"
	strings:
		$1 = { 55 8B EC 53 56 57 55 6A 00 6A 00 68 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 5D 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_193_1_0 {
	meta:
		name = "__unwind_handler"
		size = 69
		refs = "001c @__security_check_cookie@4"
	strings:
		$1 = { 8B 4C 24 04 F7 41 04 06 00 00 00 B8 01 00 00 00 74 32 8B 44 24 14 8B 48 FC 33 C8 E8 ?? ?? ?? ?? 55 8B 68 10 8B 50 28 52 8B 50 24 52 E8 14 00 00 00 83 C4 08 5D 8B 44 24 08 8B 54 24 10 89 02 B8 03 00 00 00 C3 }
	condition:
		$1
}

rule file_193_2_0 {
	meta:
		name = "__local_unwind2"
		size = 132
		refs = "000c __unwind_handler 0018 ___security_cookie"
	strings:
		$1 = { 53 56 57 8B 44 24 10 55 50 6A FE 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 A1 ?? ?? ?? ?? 33 C4 50 8D 44 24 04 64 A3 00 00 00 00 8B 44 24 28 8B 58 08 8B 70 0C 83 FE FF 74 3A 83 7C 24 2C FF 74 06 3B 74 24 2C 76 2D 8D 34 76 8B 0C B3 89 4C 24 0C 89 48 0C 83 7C B3 04 00 75 17 68 01 01 00 00 8B 44 B3 08 E8 49 00 00 00 8B 44 B3 08 E8 5F 00 00 00 EB B7 8B 4C 24 04 64 89 0D 00 00 00 00 83 C4 18 5F 5E 5B C3 }
	condition:
		$1
}

rule file_193_3_0 {
	meta:
		name = "__abnormal_termination"
		size = 35
		refs = "000c __unwind_handler"
	strings:
		$1 = { 33 C0 64 8B 0D 00 00 00 00 81 79 04 ?? ?? ?? ?? 75 10 8B 51 0C 8B 52 0C 39 51 08 75 05 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_193_5_0 {
	meta:
		name = "__NLG_Notify"
		size = 31
		refs = "0003 __NLG_Destination"
	strings:
		$1 = { 53 51 BB ?? ?? ?? ?? 8B 4C 24 0C 89 4B 08 89 43 04 89 6B 0C 55 51 50 58 59 5D 59 5B C2 04 00 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "__CallSettingFrame@12"
		size = 76
		refs = "001f __NLG_Notify1"
	strings:
		$1 = { 55 8B EC 83 EC 04 53 51 8B 45 0C 83 C0 0C 89 45 FC 8B 45 08 55 FF 75 10 8B 4D 10 8B 6D FC E8 ?? ?? ?? ?? 56 57 FF D0 5F 5E 8B DD 5D 8B 4D 10 55 8B EB 81 F9 00 01 00 00 75 05 B9 02 00 00 00 51 E8 ?? ?? ?? ?? 5D 59 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_195_3_0 {
	meta:
		name = "___ascii_stricmp"
		size = 57
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 8B 7D 0C 0F B6 0E 46 8D 41 BF 83 F8 19 77 03 83 C1 20 0F B6 17 47 8D 42 BF 83 F8 19 77 03 83 C2 20 85 C9 74 04 3B CA 74 DA 2B CA 5F 8B C1 5E 5D C3 }
	condition:
		$1
}

rule file_195_4_0 {
	meta:
		name = "__stricmp"
		size = 71
		refs = "0005 ___locale_changed 0013 __errno 001e __invalid_parameter_noinfo 0031 ___ascii_stricmp 003e __stricmp_l"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 29 83 7D 08 00 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 5D C3 83 7D 0C 00 74 E3 5D E9 ?? ?? ?? ?? 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_325_4_0 {
	meta:
		name = "_wcscoll"
		size = 71
		refs = "0005 ___locale_changed 0013 __errno 001e __invalid_parameter_noinfo 0031 _wcscmp 003e __wcscoll_l"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 29 83 7D 08 00 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 5D C3 83 7D 0C 00 74 E3 5D E9 ?? ?? ?? ?? 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_195_5_0 {
	meta:
		name = "__stricmp_l"
		size = 149
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0023 __errno 002e __invalid_parameter_noinfo 0048 ___ascii_stricmp 005e __tolower_l"
	strings:
		$1 = { 55 8B EC 83 EC 10 8D 4D F0 53 56 57 FF 75 10 E8 ?? ?? ?? ?? 8B 7D 08 85 FF 74 07 8B 5D 0C 85 DB 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? BE FF FF FF 7F EB 46 8B 45 F0 83 B8 A8 00 00 00 00 75 0D 53 57 E8 ?? ?? ?? ?? 59 59 8B F0 EB 2D 2B FB 0F B6 04 1F 8D 4D F0 51 50 E8 ?? ?? ?? ?? 8D 4D F0 8B F0 0F B6 03 51 50 E8 ?? ?? ?? ?? 83 C4 10 43 85 F6 74 04 3B F0 74 D7 2B F0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 5F 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "_asinhf"
		size = 167
		refs = "000b __fdtest 003c __FEps_C 0042 __real@4000000000000000 0063 _sqrtf 007b _log1pf 0085 _logf 008b __real@3fe62e4300000000"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 83 F8 02 77 08 D9 45 08 E9 85 00 00 00 D9 EE D9 45 08 D8 D1 DF E0 56 33 F6 DD D9 F6 C4 05 7A 09 D9 E0 46 D9 5D 08 D9 45 08 D9 05 ?? ?? ?? ?? DC 3D ?? ?? ?? ?? 51 D8 D9 DF E0 F6 C4 41 75 31 DC C8 DD 55 F4 D9 E8 DE C1 D9 5D FC D9 45 FC D9 1C 24 E8 ?? ?? ?? ?? D9 E8 DE C1 DC 7D F4 D8 45 08 D9 5D FC D9 45 FC D9 1C 24 E8 ?? ?? ?? ?? EB 0E D9 1C 24 E8 ?? ?? ?? ?? DC 05 ?? ?? ?? ?? D9 5D FC D9 45 FC 85 F6 59 5E 74 02 D9 E0 D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_198_0_0 {
	meta:
		name = "_roundl"
		size = 81
		refs = "000a __ld_int 003e __real@3ff0000000000000"
	strings:
		$1 = { 55 8B EC 8D 45 08 6A 01 50 E8 ?? ?? ?? ?? 98 59 59 85 C0 7E 05 83 F8 02 7E 32 8D 45 08 6A 00 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 74 20 8B 45 0E DD 45 08 0F B7 C0 A9 00 80 00 00 74 08 DC 25 ?? ?? ?? ?? 5D C3 DC 05 ?? ?? ?? ?? 5D C3 DD 45 08 5D C3 }
	condition:
		$1
}

rule file_979_0_0 {
	meta:
		name = "_round"
		size = 81
		refs = "000a __d_int 003e __real@3ff0000000000000"
	strings:
		$1 = { 55 8B EC 8D 45 08 6A 01 50 E8 ?? ?? ?? ?? 98 59 59 85 C0 7E 05 83 F8 02 7E 32 8D 45 08 6A 00 50 E8 ?? ?? ?? ?? 59 59 66 85 C0 74 20 8B 45 0E DD 45 08 0F B7 C0 A9 00 80 00 00 74 08 DC 25 ?? ?? ?? ?? 5D C3 DC 05 ?? ?? ?? ?? 5D C3 DD 45 08 5D C3 }
	condition:
		$1
}

rule file_199_12_0 {
	meta:
		name = "??0ExternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z"
		size = 150
		refs = "0003 __ehhandler$??0ExternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0008 __EH_prolog3 0017 ??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 001f ??_7ExternalContextBase@details@Concurrency@@6B@ 0034 ?__CreateAutoResetEvent@platform@details@Concurrency@@YAPAX_N@Z 0043 ?GetAnonymousScheduleGroupSegment@SchedulerBase@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@XZ 004d ??2@YAPAXI@Z 007e ?Add@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAEHPAVExternalStatistics@23@@Z 0088 ?PrepareForUse@ExternalContextBase@details@Concurrency@@QAEX_N@Z 008f __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 6A 01 FF 75 08 E8 ?? ?? ?? ?? 33 FF C7 06 ?? ?? ?? ?? 57 89 7D FC 89 BE A0 00 00 00 89 BE A4 00 00 00 E8 ?? ?? ?? ?? 59 8B 4E 1C 89 86 A8 00 00 00 E8 ?? ?? ?? ?? 6A 1C 89 46 18 E8 ?? ?? ?? ?? 59 85 C0 74 15 89 78 08 89 78 0C 89 78 10 89 78 14 C7 40 18 01 00 00 00 EB 02 8B C7 8B 4E 1C 50 81 C1 C8 00 00 00 89 86 9C 00 00 00 E8 ?? ?? ?? ?? FF 75 0C 8B CE E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 08 00 }
	condition:
		$1
}

rule file_199_15_0 {
	meta:
		name = "??0ExternalStatistics@details@Concurrency@@QAE@XZ"
		size = 24
	strings:
		$1 = { 33 C0 89 41 08 89 41 0C 89 41 10 89 41 14 8B C1 C7 41 18 01 00 00 00 C3 }
	condition:
		$1
}

rule file_199_27_0 {
	meta:
		name = "??1ExternalContextBase@details@Concurrency@@UAE@XZ"
		size = 45
		refs = "0003 __ehhandler$??1ExternalContextBase@details@Concurrency@@UAE@XZ 0008 __EH_prolog3 0013 ??_7ExternalContextBase@details@Concurrency@@6B@ 001c ?Cleanup@ExternalContextBase@details@Concurrency@@AAEXXZ 0023 ??1ContextBase@details@Concurrency@@UAE@XZ 0028 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 C7 06 ?? ?? ?? ?? 83 65 FC 00 E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_199_55_0 {
	meta:
		name = "?Add@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAEHPAVExternalStatistics@23@@Z"
		size = 346
		refs = "00a7 ??_U@YAPAXI@Z 00bb _memset 00c2 ??2@YAPAXI@Z 0128 ?_UnderlyingYield@details@Concurrency@@YAXXZ 0130 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
		altNames = "?Add@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAEHPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 56 57 8B F1 C6 45 FF 00 6A 04 33 FF 58 8B 56 30 89 55 F8 8D 5A 08 83 3B FF 89 5D F4 7C 3B 8B 1A 33 D2 39 56 28 7E 2C 83 3B 00 75 1F 8B 4D 08 8D 04 3A 89 01 8B 46 40 89 45 F0 33 C0 F0 0F B1 0B 85 C0 0F 84 8F 00 00 00 6A 04 58 42 03 D8 3B 56 28 7C D4 8B 5D F4 8B 55 F8 80 7D FF 00 0F 85 D2 00 00 00 6A FE 59 83 C8 FF F0 0F B1 0B 03 7E 28 8D 5A 04 83 3B 00 0F 85 99 00 00 00 33 C9 33 C0 41 F0 0F B1 0B 85 C0 0F 85 88 00 00 00 8B 46 28 33 C9 6A 04 5A F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 8B C8 8B 46 28 C1 E0 02 50 6A 00 51 89 4D F0 E8 ?? ?? ?? ?? 6A 0C E8 ?? ?? ?? ?? 8B C8 83 C4 14 85 C9 74 35 8B 45 F0 83 61 04 00 83 49 08 FF 89 01 EB 28 03 FA C6 45 FF 01 3B 7D F0 7C 0A 33 C9 8D 46 40 41 F0 0F C1 08 8B 5D F4 83 C9 FF 8B C2 F0 0F B1 0B E9 59 FF FF FF 33 C9 8B 56 3C 3B 56 38 7D 09 8B 46 34 89 0C 90 FF 46 3C 87 0B 8B 55 F8 83 3B 01 75 1B 83 65 E8 00 C7 45 EC ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 83 3B 01 74 F3 8B 55 F8 80 7D FF 00 8B 52 04 6A 04 89 55 F8 58 0F 84 CB FE FF FF 8B C7 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_199_57_0 {
	meta:
		name = "?Alloc@ExternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0004 ?GetCurrentSubAllocator@ExternalContextBase@details@Concurrency@@QAEPAVSubAllocator@23@XZ 0010 ?Alloc@SubAllocator@details@Concurrency@@QAEPAXI@Z 0018 ?StaticAlloc@SubAllocator@details@Concurrency@@SAPAXI@Z"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 85 C0 74 08 8B C8 5D E9 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 59 5D C2 04 00 }
	condition:
		$1
}

rule file_199_58_0 {
	meta:
		name = "?Block@ExternalContextBase@details@Concurrency@@UAEXXZ"
		size = 60
		refs = "0016 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 0036 __imp__WaitForSingleObjectEx@12"
	strings:
		$1 = { 56 8B F1 8B 4E 1C FF 76 08 8B 01 FF 50 04 50 6A 04 6A 03 8B CE E8 ?? ?? ?? ?? 33 C0 8D 4E 2C 40 F0 0F C1 01 40 83 F8 01 75 10 6A 00 6A FF FF B6 A8 00 00 00 FF 15 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_199_59_0 {
	meta:
		name = "?Cleanup@ExternalContextBase@details@Concurrency@@AAEXXZ"
		size = 88
		refs = "0004 ?Cleanup@ContextBase@details@Concurrency@@QAEXXZ 0015 __imp__CloseHandle@4 003d ?ReturnSubAllocator@SchedulerBase@details@Concurrency@@SAXPAVSubAllocator@23@@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? 8B 86 A4 00 00 00 85 C0 74 0E 50 FF 15 ?? ?? ?? ?? 83 A6 A4 00 00 00 00 8B 86 A8 00 00 00 85 C0 74 07 50 FF 15 ?? ?? ?? ?? 8B 86 A0 00 00 00 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 86 9C 00 00 00 83 A6 9C 00 00 00 00 5E C7 40 18 00 00 00 00 C3 }
	condition:
		$1
}

rule file_199_62_0 {
	meta:
		name = "?DetachStatistics@ExternalContextBase@details@Concurrency@@QAEPAVExternalStatistics@23@XZ"
		size = 21
	strings:
		$1 = { 8B 81 9C 00 00 00 83 A1 9C 00 00 00 00 C7 40 18 00 00 00 00 C3 }
	condition:
		$1
}

rule file_199_67_0 {
	meta:
		name = "?Free@ExternalContextBase@details@Concurrency@@UAEXPAX@Z"
		size = 37
		refs = "0004 ?GetCurrentSubAllocator@ExternalContextBase@details@Concurrency@@QAEPAVSubAllocator@23@XZ 0010 ?Free@SubAllocator@details@Concurrency@@QAEXPAX@Z 001c ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 85 C0 74 08 8B C8 5D E9 ?? ?? ?? ?? 8B 45 08 83 C0 FC 50 E8 ?? ?? ?? ?? 59 5D C2 04 00 }
	condition:
		$1
}

rule file_199_71_0 {
	meta:
		name = "?GetCurrentSubAllocator@ExternalContextBase@details@Concurrency@@QAEPAVSubAllocator@23@XZ"
		size = 34
		refs = "000f ?GetSubAllocator@SchedulerBase@details@Concurrency@@SAPAVSubAllocator@23@_N@Z"
	strings:
		$1 = { 56 8B F1 83 BE A0 00 00 00 00 75 0E 6A 01 E8 ?? ?? ?? ?? 59 89 86 A0 00 00 00 8B 86 A0 00 00 00 5E C3 }
	condition:
		$1
}

rule file_199_73_0 {
	meta:
		name = "?ImplicitDetachHandler@ExternalContextBase@details@Concurrency@@CGXPAU_TP_CALLBACK_INSTANCE@@PAXPAU_TP_WAIT@@K@Z"
		size = 34
		refs = "000d ?DetachExternalContext@SchedulerBase@details@Concurrency@@AAEXPAVExternalContextBase@23@_N@Z 0018 ?UnRegisterAsyncWaitAndUnloadLibrary@details@Concurrency@@YAXPAU_TP_CALLBACK_INSTANCE@@PAU_TP_WAIT@@@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 6A 00 51 8B 49 1C E8 ?? ?? ?? ?? FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C2 10 00 }
	condition:
		$1
}

rule file_199_74_0 {
	meta:
		name = "?ImplicitDetachHandlerXP@ExternalContextBase@details@Concurrency@@CGXPAXE@Z"
		size = 35
		refs = "000e ?__UnregisterWait@platform@details@Concurrency@@YAXPAX@Z 001a ?DetachExternalContext@SchedulerBase@details@Concurrency@@AAEXPAVExternalContextBase@23@_N@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 FF B6 AC 00 00 00 E8 ?? ?? ?? ?? 59 8B 4E 1C 6A 00 56 E8 ?? ?? ?? ?? 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_199_77_0 {
	meta:
		name = "?Oversubscribe@ExternalContextBase@details@Concurrency@@UAEX_N@Z"
		size = 57
		refs = "0026 ??0invalid_oversubscribe_operation@Concurrency@@QAE@XZ 002b __TI2?AVinvalid_oversubscribe_operation@Concurrency@@ 0034 __CxxThrowException@8"
		altNames = "?Oversubscribe@UMSThreadInternalContext@details@Concurrency@@UAEX_N@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 80 7D 08 00 74 05 FF 41 14 EB 0B 8B 41 14 85 C0 74 0A 48 89 41 14 8B E5 5D C2 04 00 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_199_78_0 {
	meta:
		name = "?PrepareForUse@ExternalContextBase@details@Concurrency@@QAEX_N@Z"
		size = 197
		refs = "0015 __imp__GetCurrentThreadId@0 002f __imp__GetCurrentProcess@0 0036 __imp__GetCurrentThread@0 0044 __imp__DuplicateHandle@28 004e __imp__GetLastError@0 0059 ?GetOSVersion@Concurrency@@YA?AW4OSVersion@IResourceManager@1@XZ 0064 ?ImplicitDetachHandler@ExternalContextBase@details@Concurrency@@CGXPAU_TP_CALLBACK_INSTANCE@@PAXPAU_TP_WAIT@@K@Z 006b ?RegisterAsyncWaitAndLoadLibrary@details@Concurrency@@YAPAU_TP_WAIT@@PAXP6GXPAU_TP_CALLBACK_INSTANCE@@0PAU3@K@Z0@Z 0089 ?ImplicitDetachHandlerXP@ExternalContextBase@details@Concurrency@@CGXPAXE@Z 0090 ?__RegisterWaitForSingleObject@platform@details@Concurrency@@YAPAXPAXP6GX0E@Z0@Z 00b2 ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 00b7 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 00c0 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 8A 5D 08 57 8B F9 88 9F 98 00 00 00 FF 15 ?? ?? ?? ?? 89 47 44 84 DB 75 7D 6A 02 6A 00 6A 00 8D 9F A4 00 00 00 53 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 0C FF 15 ?? ?? ?? ?? 85 C0 7E 57 EB 4D E8 ?? ?? ?? ?? 57 83 F8 03 7C 25 68 ?? ?? ?? ?? FF 33 E8 ?? ?? ?? ?? 83 C4 0C 89 87 AC 00 00 00 85 C0 75 21 FF 15 ?? ?? ?? ?? 85 C0 7E 27 EB 1D 68 ?? ?? ?? ?? FF 33 E8 ?? ?? ?? ?? 83 C4 0C 89 87 AC 00 00 00 5F 5B 8B E5 5D C2 04 00 0F B7 C0 0D 00 00 07 80 50 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_199_79_0 {
	meta:
		name = "?RemoveFromUse@ExternalContextBase@details@Concurrency@@QAEXXZ"
		size = 34
		refs = "0004 ?ReleaseWorkQueue@ContextBase@details@Concurrency@@IAEXXZ 0015 __imp__CloseHandle@4"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? 8B 86 A4 00 00 00 85 C0 74 0E 50 FF 15 ?? ?? ?? ?? 83 A6 A4 00 00 00 00 5E C3 }
	condition:
		$1
}

rule file_199_81_0 {
	meta:
		name = "?StaticFree@SubAllocator@details@Concurrency@@SAXPAX@Z"
		size = 18
		refs = "000b ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 C0 FC 50 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_199_83_0 {
	meta:
		name = "?Unblock@ExternalContextBase@details@Concurrency@@UAEXXZ"
		size = 119
		refs = "000a ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0025 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 003e __imp__SetEvent@4 0055 ??0context_self_unblock@Concurrency@@QAE@XZ 005a __TI2?AVcontext_self_unblock@Concurrency@@ 0064 ??0context_unblock_unbalanced@Concurrency@@QAE@XZ 0069 __TI2?AVcontext_unblock_unbalanced@Concurrency@@ 0072 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 0C 56 8B F1 E8 ?? ?? ?? ?? 3B F0 74 3F 8B 4E 1C FF 76 08 8B 01 FF 50 04 50 6A 04 6A 04 8B CE E8 ?? ?? ?? ?? 8D 46 2C 83 C9 FF F0 0F C1 08 49 75 11 FF B6 A8 00 00 00 FF 15 ?? ?? ?? ?? 5E 8B E5 5D C3 8D 41 01 83 F8 01 76 F3 EB 0F 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB 0D 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_199_85_0 {
	meta:
		name = "?Yield@ExternalContextBase@details@Concurrency@@UAEXXZ"
		size = 32
		refs = "0016 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 001c ?__SwitchToThread@platform@details@Concurrency@@YAXXZ"
	strings:
		$1 = { 56 8B F1 8B 4E 1C FF 76 08 8B 01 FF 50 04 50 6A 04 6A 05 8B CE E8 ?? ?? ?? ?? 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_0_0 {
	meta:
		name = "__vsnprintf"
		size = 27
		refs = "0012 __vsnprintf_l"
	strings:
		$1 = { 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1228_2_0 {
	meta:
		name = "?vswprintf@@YAHPAGIPBGPAD@Z"
		size = 27
		refs = "0012 ?_vswprintf_l@@YAHPA_WIPB_WPAUlocaleinfo_struct@@PAD@Z"
	strings:
		$1 = { 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1228_3_0 {
	meta:
		name = "?vswprintf@@YAHPA_WIPB_WPAD@Z"
		size = 27
		refs = "0012 ?_vswprintf_l@@YAHPA_WIPB_WPAUlocaleinfo_struct@@PAD@Z"
	strings:
		$1 = { 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1298_0_0 {
	meta:
		name = "__vsnwprintf"
		size = 27
		refs = "0012 __vsnwprintf_l"
	strings:
		$1 = { 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_557_8_0 {
	meta:
		name = "_vsprintf_s"
		size = 27
		refs = "0012 __vsprintf_s_l"
	strings:
		$1 = { 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_616_8_0 {
	meta:
		name = "_vswprintf_s"
		size = 27
		refs = "0012 __vswprintf_s_l"
	strings:
		$1 = { 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_200_1_0 {
	meta:
		name = "__vsnprintf_l"
		size = 172
		refs = "001b __errno 0026 __invalid_parameter_noinfo 007d __output_l 009e __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 83 65 E0 00 33 C0 57 8D 7D E4 6A 07 59 F3 AB 39 45 10 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 78 8B 45 0C 56 8B 75 08 85 C0 74 19 85 F6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 53 B9 FF FF FF 7F 89 4D E4 3B C1 77 03 89 45 E4 FF 75 18 8D 45 E0 C7 45 EC 42 00 00 00 FF 75 14 89 75 E8 FF 75 10 89 75 E0 50 E8 ?? ?? ?? ?? 83 C4 10 8B F8 85 F6 74 1C FF 4D E4 78 08 8B 45 E0 C6 00 00 EB 0D 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 8B C7 5E 5F 8B E5 5D C3 }
	condition:
		$1
}

rule file_20