private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "MIPS"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "__fsetlocking"
		size = 68
	strings:
		$1 = { 00 00 86 8C 02 00 03 24 01 00 07 24 00 80 C2 30 0B 38 62 00 06 00 A0 10 21 10 E0 00 FF FF 07 3C FF 7F E7 24 04 00 A3 10 24 30 C7 00 00 00 86 AC 08 00 E0 03 00 00 00 00 00 80 C6 34 08 00 E0 03 00 00 86 AC }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "prefixcmp"
		size = 40
	strings:
		$1 = { 10 00 83 8C 10 00 A4 8C 2B 28 64 00 04 00 A0 14 01 00 02 24 26 10 64 00 2B 10 02 00 23 10 02 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_1_1_0 {
	meta:
		name = "scopecmp"
		size = 40
	strings:
		$1 = { 04 00 82 8C 04 00 A3 8C 2B 20 62 00 04 00 80 14 00 00 00 00 26 10 43 00 08 00 E0 03 2B 10 02 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_1_2_0 {
	meta:
		name = "in6aicmp"
		size = 16
		refs = "0008 memcmp"
	strings:
		$1 = { 08 00 84 24 08 00 A5 24 ?? ?? ?? 0? 10 00 06 24 }
	condition:
		$1
}

rule file_1_3_0 {
	meta:
		name = "match_prefix"
		size = 284
	strings:
		$1 = { 00 00 83 94 02 00 07 24 07 00 67 10 D8 FF BD 27 21 10 C0 00 0A 00 06 24 11 00 66 10 00 00 00 00 08 00 E0 03 28 00 BD 27 02 00 83 94 04 00 82 8C 0A 00 04 24 0A 00 A3 A7 FF FF 03 24 18 00 A0 AF 08 00 A4 A7 0C 00 A0 AF 10 00 A0 AF 14 00 A0 AF 1A 00 A3 A7 1C 00 A2 AF 20 00 A0 AF 08 00 A4 27 10 00 A2 8C 08 00 89 24 08 00 43 2C 1D 00 60 14 00 FF 0A 34 00 00 A6 90 08 00 83 90 14 00 C3 14 21 30 20 01 ?? ?? ?? 0? 21 18 A0 00 00 00 68 90 00 00 C7 90 0E 00 07 15 00 00 00 00 F8 FF 42 24 08 00 47 2C 01 00 63 24 F8 FF E0 10 01 00 C6 24 00 00 C6 90 00 00 63 90 07 10 4A 00 26 18 C3 00 FF 00 63 30 24 10 62 00 11 00 40 10 00 00 00 00 18 00 A5 24 10 00 A2 8C 08 00 43 2C E5 FF 60 10 00 00 00 00 21 30 20 01 21 18 A0 00 00 00 C6 90 00 00 63 90 07 10 4A 00 26 18 C3 00 FF 00 63 30 24 10 62 00 F3 FF 40 14 18 00 A5 24 E8 FF A5 24 14 00 A2 8C 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_1_4_0 {
	meta:
		name = "gaiconf_init"
		size = 3240
		refs = "0000 __gnu_local_gp 0004 $LC0 0008 $LC1 005c _IO_new_fopen 006c fileno 007c __fxstat64 0090 __libc_tsd_CTYPE_B 0094 __libc_errno 00d8 __getline 00ec strchr 0298 strcmp 0294 $LC5 02e0 inet_pton 0300 strtoul 0374 free 037c _IO_new_fclose 03b8 malloc 0448 qsort 0554 $LC2 0680 $LC4 07d4 $LC3"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 04 3C ?? ?? 05 3C D8 FE BD 27 ?? ?? 9C 27 ?? ?? 84 24 ?? ?? A5 24 00 01 B0 AF 24 01 BF AF 20 01 BE AF 1C 01 B7 AF 18 01 B6 AF 14 01 B5 AF 10 01 B4 AF 0C 01 B3 AF 08 01 B2 AF 04 01 B1 AF 10 00 BC AF E0 00 A0 AF DC 00 A0 AF E5 00 A0 A3 D8 00 A0 AF D4 00 A0 AF ?? ?? ?? 0? E4 00 A0 A3 8E 02 40 10 21 80 40 00 ?? ?? ?? 0? 21 20 40 00 21 28 40 00 03 00 04 24 ?? ?? ?? 0? 18 00 A6 27 B0 02 40 14 10 00 BC 8F 00 00 02 8E ?? ?? 93 8F ?? ?? 95 8F 3B E8 03 7C 00 80 42 34 D0 00 A0 AF CC 00 A0 AF 21 90 60 00 F8 00 A0 AF 00 00 02 AE E8 00 A0 AF 21 88 00 00 21 A0 63 02 21 A8 A3 02 10 00 42 30 AA 00 40 14 21 F0 72 02 D0 00 A4 27 CC 00 A5 27 ?? ?? ?? 0? 21 30 00 02 A4 00 40 18 D0 00 B6 8F 23 00 05 24 ?? ?? ?? 0? 21 20 C0 02 60 01 40 10 00 00 00 00 00 00 40 A0 D0 00 A4 8F 00 00 83 80 ?? ?? ?? 0? 00 00 C2 8F 00 00 83 80 40 28 03 00 21 28 45 00 00 00 A5 94 00 20 A5 30 FA FF A0 14 01 00 84 24 FF FF 84 24 07 00 60 14 21 B8 80 00 ?? ?? ?? 0? 21 30 00 00 00 00 C5 94 00 20 A5 30 7C 00 A0 14 23 40 E4 02 01 00 F7 26 00 00 E5 82 40 30 05 00 F8 FF A0 14 21 30 46 00 00 00 46 94 23 40 E4 02 21 28 00 00 00 20 C6 30 FF FF C6 30 0A 00 C0 10 00 00 00 00 01 00 F7 26 00 00 E5 82 40 30 05 00 21 30 46 00 00 00 C6 94 00 20 C6 30 FA FF C0 14 01 00 F7 26 FF FF F7 26 39 02 A0 10 00 00 00 00 40 30 05 00 21 30 46 00 00 00 C6 94 00 20 C6 30 07 00 C0 10 21 B0 E0 02 ?? ?? ?? 0? 00 00 00 00 00 00 C6 94 00 20 C6 30 06 00 C0 14 00 00 00 00 01 00 D6 26 00 00 C5 82 40 30 05 00 F8 FF A0 14 21 30 46 00 5C 00 C4 12 00 00 00 00 04 00 A0 10 00 00 00 00 00 00 C0 A2 00 00 82 8E 01 00 D6 26 00 00 C5 82 40 30 05 00 21 48 46 00 00 00 29 95 00 20 29 31 FA FF 20 15 01 00 D6 26 FF FF D6 26 8A 01 A0 10 21 30 46 00 00 00 C5 94 00 20 A5 30 86 01 A0 14 00 00 00 00 ?? ?? ?? 0? 21 28 C0 02 00 00 26 95 00 20 C6 30 06 00 C0 14 00 00 00 00 01 00 A5 24 00 00 A6 80 40 48 06 00 F8 FF C0 14 21 48 49 00 06 00 02 24 57 01 02 11 00 00 A0 A0 07 00 02 2D B2 00 40 14 07 00 02 24 FD 00 02 11 0A 00 02 24 28 00 02 15 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 24 00 40 14 E4 00 A3 27 F4 00 A3 AF D4 00 A3 27 F0 00 A3 AF 21 20 E0 02 D8 00 A3 27 2F 00 05 24 00 00 A0 AE ?? ?? ?? 0? EC 00 A3 AF B1 00 40 10 21 F0 40 00 00 00 40 A0 0A 00 04 24 21 28 E0 02 ?? ?? ?? 0? B8 00 A6 27 12 00 40 10 01 00 C4 27 AE 00 80 10 C8 00 A3 27 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? FC 00 A3 AF 21 40 40 00 FF FF 02 24 08 00 02 11 FC 00 A3 8F C8 00 A2 8F 00 00 42 80 04 00 40 14 00 00 00 00 81 00 02 2D A5 00 40 14 21 20 C0 02 ?? ?? ?? 0? 00 00 02 8E 00 00 E0 A2 01 00 E5 82 00 00 C2 8F 40 30 05 00 21 30 46 00 00 00 C6 94 01 00 F7 26 00 20 C6 30 ?? ?? ?? 0? FF FF C6 30 00 00 02 8E 10 00 42 30 59 FF 40 10 D0 00 A4 27 ?? ?? ?? 0? D0 00 A4 8F ?? ?? ?? 0? 21 20 00 02 DC 00 A2 8F 35 01 40 14 E5 00 B3 93 D4 00 A2 8F ?? ?? 13 3C ?? ?? 73 26 63 01 40 10 21 80 60 02 E4 00 B5 93 EE 01 A0 12 21 A0 40 00 C0 10 14 00 40 21 14 00 ?? ?? ?? 0? 23 20 82 00 89 01 40 10 21 90 40 00 E9 01 A0 12 21 10 80 02 18 00 40 18 D8 00 A4 8F C0 18 02 00 40 11 02 00 23 60 43 00 23 68 0C 00 21 18 80 00 21 60 4C 02 21 10 00 00 00 00 6B 8C 04 00 6A 8C 08 00 69 8C 0C 00 68 8C 10 00 67 8C 14 00 66 8C 21 28 82 01 E8 FF AB AC EC FF AA AC F0 FF A9 AC F4 FF A8 AC F8 FF A7 AC FC FF A6 AC E8 FF 42 24 F1 FF 4D 14 18 00 63 8C 66 01 80 14 D4 00 A5 8F ?? ?? 07 3C 21 20 40 02 18 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 E8 00 A3 8F ?? ?? 15 3C 39 01 60 10 ?? ?? B5 26 F8 00 A3 8F 01 00 62 2C E8 00 A3 8F 21 18 62 00 80 10 03 00 00 21 03 00 23 20 82 00 ?? ?? ?? 0? E8 00 A3 AF D4 01 40 10 21 A0 40 00 F8 00 A3 8F 0A 00 60 14 E8 00 A2 8F FF FF 42 24 00 21 02 00 80 18 02 00 23 18 83 00 21 18 83 02 0E 00 04 24 00 00 60 AC 04 00 60 AC 08 00 64 AC 11 00 40 18 80 18 02 00 00 11 02 00 23 40 43 00 23 48 08 00 21 18 20 02 21 40 88 02 21 10 00 00 00 00 67 8C 04 00 66 8C 08 00 65 8C 21 20 02 01 F4 FF 87 AC F8 FF 86 AC FC FF 85 AC F4 FF 42 24 F7 FF 49 14 0C 00 63 8C 04 00 20 16 E8 00 A5 8F ?? ?? ?? 0? ?? ?? 07 3C 21 88 E0 02 0C 00 37 8E ?? ?? ?? 0? 21 20 20 02 FB FF E0 16 E8 00 A5 8F ?? ?? 07 3C 21 20 80 02 0C 00 06 24 ?? ?? E7 24 ?? ?? ?? 0? ?? ?? 11 3C ?? ?? ?? 0? ?? ?? 31 26 05 00 02 24 78 FF 02 15 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 74 FF 40 14 E5 00 A3 27 F4 00 A3 AF DC 00 A3 27 F0 00 A3 AF 21 20 E0 02 E0 00 A3 27 2F 00 05 24 00 00 A0 AE ?? ?? ?? 0? EC 00 A3 AF 51 FF 40 14 21 F0 40 00 0A 00 04 24 21 28 E0 02 ?? ?? ?? 0? B8 00 A6 27 63 FF 40 10 00 00 00 00 C8 00 A2 8F 00 00 42 80 5F FF 40 14 80 00 08 24 C8 00 A3 27 21 20 C0 02 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? FC 00 A8 AF 21 B0 40 00 FF FF 02 24 92 01 C2 12 FC 00 A8 8F C8 00 A2 8F 00 00 42 80 51 FF 40 14 00 00 00 00 4F FF C0 06 1C 00 04 24 ?? ?? ?? 0? FC 00 A8 AF 95 01 40 10 FC 00 A8 8F F0 00 A3 8F 01 00 07 2D 10 00 48 AC 00 00 65 8C F4 00 A3 8F 14 00 56 AC 01 00 A5 24 00 00 64 90 EC 00 A3 8F 25 20 E4 00 B8 00 A7 8F 00 00 66 8C 00 00 47 AC BC 00 A7 8F 18 00 46 AC 04 00 47 AC C0 00 A7 8F 08 00 47 AC C4 00 A7 8F 0C 00 47 AC 00 00 62 AC F0 00 A3 8F 00 00 65 AC F4 00 A3 8F 00 00 64 A0 ?? ?? ?? 0? 00 00 02 8E ?? ?? ?? 0? 21 20 C0 02 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 29 FF 40 14 21 20 E0 02 2F 00 05 24 ?? ?? ?? 0? 00 00 A0 AE 03 00 40 10 21 F0 00 00 01 00 5E 24 00 00 40 A0 0A 00 04 24 21 28 E0 02 ?? ?? ?? 0? B8 00 A6 27 F9 00 40 10 B8 00 A2 8F 1A FF 40 14 00 00 00 00 BC 00 A2 8F 17 FF 40 14 C0 00 A3 8F FF FF 02 3C 14 FF 62 14 00 00 00 00 55 01 C0 13 21 20 C0 03 C8 00 A5 27 ?? ?? ?? 0? 0A 00 06 24 21 F0 40 00 FF FF 02 24 3E 01 C2 13 C8 00 A2 8F 00 00 42 80 08 FF 40 14 00 00 00 00 60 00 C2 2F 05 FF 40 14 00 00 00 00 81 00 C2 2F 02 FF 40 10 21 20 C0 02 C8 00 A5 27 ?? ?? ?? 0? 0A 00 06 24 21 B0 40 00 FF FF 02 24 4B 01 C2 12 22 00 02 24 C8 00 A2 8F 00 00 42 80 F7 FE 40 14 00 00 00 00 F5 FE C0 06 00 00 00 00 ?? ?? ?? 0? 10 00 04 24 3B 01 40 10 00 00 00 00 60 00 04 24 43 01 C4 13 FF FF 05 24 23 20 1E 00 04 20 85 00 A0 20 04 7C 02 24 24 00 E8 00 A3 8F C4 00 A6 8F 60 00 C5 3B 01 00 63 24 E8 00 A3 AF F8 00 A3 8F 01 00 A5 2C 24 30 86 00 0C 00 51 AC 04 00 44 AC 00 00 46 AC 08 00 56 AC 25 18 65 00 21 88 40 00 F8 00 A3 AF ?? ?? ?? 0? 00 00 02 8E ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 45 24 D4 FE 40 14 79 00 04 24 00 00 E2 92 23 10 82 00 15 00 40 14 01 00 42 2C 01 00 E2 92 65 00 04 24 23 10 82 00 10 00 40 14 01 00 42 2C 02 00 E2 92 73 00 04 24 23 10 82 00 0B 00 40 14 01 00 42 2C 03 00 E2 92 ?? ?? 03 3C 01 00 42 2C C1 FE 40 10 ?? ?? 62 AC ?? ?? 02 3C 01 00 03 24 ?? ?? 43 AC ?? ?? ?? 0? 00 00 02 8E ?? ?? 03 3C ?? ?? 62 AC ?? ?? ?? 0? 00 00 02 8E ?? ?? ?? 0? 21 28 C0 02 BD 00 60 12 21 90 40 00 C0 10 12 00 40 21 12 00 ?? ?? ?? 0? 23 20 82 00 5F 00 40 10 21 80 40 00 C8 00 60 12 00 00 00 00 18 00 40 1A E0 00 A4 8F C0 10 12 00 40 61 12 00 23 60 82 01 23 68 0C 00 21 18 80 00 21 60 0C 02 21 10 00 00 00 00 6B 8C 04 00 6A 8C 08 00 69 8C 0C 00 68 8C 10 00 67 8C 14 00 66 8C 21 28 82 01 E8 FF AB AC EC FF AA AC F0 FF A9 AC F4 FF A8 AC F8 FF A7 AC FC FF A6 AC E8 FF 42 24 F1 FF 4D 14 18 00 63 8C 06 00 80 10 DC 00 A5 8F ?? ?? ?? 0? 18 00 92 8C FD FF 40 16 21 20 40 02 DC 00 A5 8F ?? ?? 07 3C 21 20 00 02 18 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 D4 00 A2 8F ?? ?? 13 3C 9F FE 40 14 ?? ?? 73 26 E8 00 A3 8F ?? ?? 15 3C ?? ?? B5 26 C9 FE 60 14 21 90 A0 02 ?? ?? 11 3C ?? ?? 31 26 21 A0 20 02 ?? ?? 02 3C ?? ?? 44 8C 03 00 93 10 ?? ?? 50 AC ?? ?? ?? 0? 00 00 00 00 ?? ?? 02 3C ?? ?? 44 8C 03 00 95 10 ?? ?? 52 AC ?? ?? ?? 0? 00 00 00 00 ?? ?? 02 3C ?? ?? 44 8C 03 00 91 10 ?? ?? 54 AC ?? ?? ?? 0? 00 00 00 00 60 00 A3 8F 24 01 BF 8F ?? ?? 02 3C 20 01 BE 8F 1C 01 B7 8F 18 01 B6 8F 14 01 B5 8F 10 01 B4 8F 0C 01 B3 8F 08 01 B2 8F 04 01 B1 8F 00 01 B0 8F ?? ?? 43 AC 08 00 E0 03 28 01 BD 27 ?? ?? ?? 0? 18 00 94 8C FD FF 80 16 21 20 80 02 ?? ?? ?? 0? D4 00 A5 8F 04 00 13 12 E0 00 A4 8F ?? ?? ?? 0? 21 20 00 02 E0 00 A4 8F 03 00 80 14 00 00 00 00 ?? ?? ?? 0? D8 00 A4 8F ?? ?? ?? 0? 18 00 90 8C FD FF 00 16 21 20 00 02 D8 00 A4 8F 05 00 80 10 00 00 00 00 ?? ?? ?? 0? 18 00 90 8C FD FF 00 16 21 20 00 02 06 00 20 12 00 00 00 00 0C 00 30 8E ?? ?? ?? 0? 21 20 20 02 FC FF 00 16 21 88 00 02 ?? ?? ?? 0? 00 00 00 00 24 01 BF 8F 20 01 BE 8F 1C 01 B7 8F 18 01 B6 8F 14 01 B5 8F 10 01 B4 8F 0C 01 B3 8F 08 01 B2 8F 04 01 B1 8F 00 01 B0 8F 08 00 E0 03 28 01 BD 27 ?? ?? ?? 0? 21 B0 E0 02 21 40 00 00 ?? ?? ?? 0? 21 28 00 00 ?? ?? ?? 0? 21 88 00 00 02 00 04 24 21 28 E0 02 ?? ?? ?? 0? C4 00 A6 27 1E FE 40 10 00 00 00 00 73 00 C0 13 C8 00 A3 27 21 20 C0 03 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? FC 00 A3 AF 21 F0 40 00 FF FF 02 24 13 FE C2 13 FC 00 A3 8F C8 00 A2 8F 00 00 42 80 0F FE 40 14 00 00 00 00 21 00 C2 2F 0C FE 40 10 00 00 00 00 21 20 C0 02 21 28 60 00 ?? ?? ?? 0? 0A 00 06 24 21 B0 40 00 FF FF 02 24 49 00 C2 12 22 00 02 24 C8 00 A2 8F 00 00 42 80 00 FE 40 14 00 00 00 00 FE FD C0 06 00 00 00 00 ?? ?? ?? 0? 60 00 DE 27 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 88 00 00 01 00 52 24 ?? ?? ?? 0? DC 00 B2 AF 01 00 54 24 ?? ?? ?? 0? D4 00 B4 AF FF FF 82 26 40 21 02 00 C0 18 02 00 23 18 83 00 21 18 43 02 28 00 04 24 00 00 60 AC 04 00 60 AC 08 00 60 AC 0C 00 60 AC 10 00 60 AC ?? ?? ?? 0? 14 00 64 AC FF FF 52 26 40 19 12 00 C0 10 12 00 23 10 62 00 21 10 02 02 01 00 03 24 00 00 40 AC 04 00 40 AC 08 00 40 AC 0C 00 40 AC 10 00 40 AC ?? ?? ?? 0? 14 00 43 AC 03 00 13 12 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 83 FF 55 12 00 00 00 00 ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? E0 00 A4 8F 00 00 A3 8E 22 00 02 24 CA FD 62 10 00 00 00 00 C8 00 A2 8F 00 00 42 80 C2 FE 40 10 00 00 00 00 ?? ?? ?? 0? 00 00 02 8E 00 00 A4 8E 22 00 02 24 6C FE 82 14 00 00 00 00 ?? ?? ?? 0? 00 00 02 8E ?? ?? ?? 0? 80 00 1E 24 00 00 A4 8E B6 FF 82 14 00 00 00 00 ?? ?? ?? 0? 00 00 02 8E ?? ?? ?? 0? D0 00 A4 8F ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? E0 00 A4 8F 00 00 A4 8E B4 FE 82 14 00 00 00 00 ?? ?? ?? 0? 00 00 02 8E ?? ?? ?? 0? 21 20 00 00 C8 00 A2 8F 00 00 42 80 A6 FD 40 14 00 00 00 00 ?? ?? ?? 0? 20 00 1E 24 }
	condition:
		$1
}

rule file_1_5_0 {
	meta:
		name = "gaih_inet_serv.isra.3"
		size = 304
		refs = "0070 __getservbyname_r"
	strings:
		$1 = { A0 FF BD 27 58 00 BE AF 54 00 B6 AF 50 00 B5 AF 4C 00 B4 AF 48 00 B3 AF 44 00 B2 AF 40 00 B1 AF 3C 00 B0 AF 5C 00 BF AF 21 F0 A0 03 21 98 A0 00 21 90 80 00 21 B0 C0 00 21 A0 E0 00 0A 00 B1 24 00 04 10 24 22 00 15 24 0E 00 02 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 30 00 C2 27 10 00 B0 AF 14 00 A2 AF 21 20 40 02 21 28 20 02 20 00 C6 27 ?? ?? ?? 0? 18 00 A7 27 1C 00 40 14 00 00 00 00 30 00 C2 8F 1B 00 40 10 00 00 00 00 00 00 63 8E 00 00 80 AE 04 00 83 AE 08 00 63 92 02 00 63 30 21 00 60 10 00 00 00 00 00 00 C4 8E 08 00 43 8C 08 00 84 AE 21 10 00 00 0C 00 83 AE 21 E8 C0 03 5C 00 BF 8F 58 00 BE 8F 54 00 B6 8F 50 00 B5 8F 4C 00 B4 8F 48 00 B3 8F 44 00 B2 8F 40 00 B1 8F 3C 00 B0 8F 08 00 E0 03 60 00 BD 27 D6 FF 55 10 40 80 10 00 21 E8 C0 03 5C 00 DF 8F 58 00 BE 8F 54 00 B6 8F 50 00 B5 8F 4C 00 B4 8F 48 00 B3 8F 44 00 B2 8F 40 00 B1 8F 3C 00 B0 8F 08 01 02 24 08 00 E0 03 60 00 BD 27 ?? ?? ?? 0? 04 00 64 8E }
	condition:
		$1
}

rule file_1_6_0 {
	meta:
		name = "gaih_inet"
		size = 8824
		refs = "0014 __gnu_local_gp 0278 __idna_to_ascii_lz 02c8 __inet_aton 0394 malloc 0444 strchr 045c inet_pton 04dc free 05a4 strtoul 0604 __nss_not_use_nscd_hosts 0628 __nss_hosts_database 0640 _res_hconf 0650 __libc_resp 0670 __res_maybe_init 06d0 __libc_errno 0738 $LC10 0740 __nss_lookup_function 0770 __libc_h_errno 07cc $LC8 0800 _dl_mcount_wrapper_check 0b00 in6addr_loopback 0b98 __idna_to_unicode_lzlz 0bdc realloc 0ff0 __nss_database_custom 100c __nscd_getai 11ac strlen 1204 memcpy 1498 $LC11 0734 $LC9 15bc if_nametoindex 1634 __gethostbyname2_r 1824 __strdup 1a20 __libc_alloca_cutoff 0634 $LC6 1c2c $LC7 1c3c __nss_database_lookup 1cc4 __gethostbyaddr_r 1ed8 mempcpy 1f78 __strndup 2098 $LC12 209c $LC13 20b0 __assert_fail 20a0 __PRETTY_FUNCTION__.13268 223c _res_hconf_init"
	strings:
		$1 = { 10 FF BD 27 E4 00 B7 AF 21 B8 C0 00 0C 00 C6 8C C8 00 B0 AF ?? ?? 1C 3C ?? ?? 10 3C E8 00 BE AF ?? ?? 9C 27 21 F0 A0 03 ?? ?? 10 26 E0 00 B6 AF CC 00 B1 AF F0 00 C4 AF EC 00 BF AF DC 00 B5 AF D8 00 B4 AF D4 00 B3 AF D0 00 B2 AF 28 00 DC AF 21 88 A0 00 21 B0 E0 00 58 00 D0 AF 54 00 C0 AF 03 00 C0 14 08 00 E4 8E 2B 00 80 10 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 42 24 16 00 80 10 00 00 00 00 00 00 43 8C 13 00 64 10 00 00 00 00 14 00 42 24 0A 00 43 80 F8 FF 60 14 00 00 00 00 07 01 02 24 21 E8 C0 03 EC 00 BF 8F E8 00 BE 8F E4 00 B7 8F E0 00 B6 8F DC 00 B5 8F D8 00 B4 8F D4 00 B3 8F D0 00 B2 8F CC 00 B1 8F C8 00 B0 8F 08 00 E0 03 F0 00 BD 27 11 00 C0 10 00 00 00 00 08 00 43 90 02 00 63 30 0D 00 60 14 00 00 00 00 04 00 43 8C 0A 00 C3 10 00 00 00 00 14 00 42 24 0A 00 43 80 DD FF 60 14 00 00 00 00 0B 00 80 10 08 01 02 24 ?? ?? ?? 0? 07 01 02 24 ?? ?? 42 24 19 00 20 12 21 28 00 00 08 00 43 90 01 00 63 30 0F 00 60 10 00 00 00 00 08 01 02 24 21 E8 C0 03 EC 00 BF 8F E8 00 BE 8F E4 00 B7 8F E0 00 B6 8F DC 00 B5 8F D8 00 B4 8F D4 00 B3 8F D0 00 B2 8F CC 00 B1 8F C8 00 B0 8F 08 00 E0 03 F0 00 BD 27 04 00 23 8E EA 01 60 04 00 3A 65 7C 00 1A 03 00 25 28 A3 00 FF FF A5 30 1C 00 80 14 00 00 00 00 1A 00 C0 14 00 00 00 00 1E 00 43 80 B1 04 60 10 14 00 42 24 58 00 C4 27 ?? ?? ?? 0? 21 30 00 00 14 00 42 24 0A 00 43 80 9D 00 60 10 00 00 00 00 09 00 43 90 FA FF 60 10 00 00 00 00 00 00 48 8C 04 00 47 8C E8 FF BD 27 28 00 A3 27 28 00 A0 AF 2C 00 A8 AF 30 00 A7 AF 34 00 A5 AF 10 00 C6 24 00 00 83 AC ?? ?? ?? 0? 21 20 60 00 08 00 44 90 00 00 47 8C E8 FF BD 27 28 00 A3 27 02 00 84 30 58 00 C3 AF 00 00 60 AC 02 00 80 14 04 00 67 AC 04 00 46 8C 08 00 66 AC 0C 00 65 AC 30 00 19 24 7C 00 D9 AF F0 00 D9 8F 00 02 20 13 00 00 00 00 00 00 E3 8E D8 FF BD 27 28 00 A2 27 40 00 64 30 54 00 C2 AF 08 00 40 AC 1C 00 40 AC A4 00 80 10 00 00 40 AC 00 02 62 7C 02 00 46 34 00 02 63 30 0A 30 43 00 21 20 20 03 30 00 C5 27 ?? ?? ?? 0? 30 00 C0 AF 21 18 40 00 08 00 40 10 50 00 C2 AF C9 00 02 24 BD 02 62 10 CA 00 63 38 0B 00 02 24 69 00 04 24 ?? ?? ?? 0? 0B 10 83 00 30 00 D9 8F F0 00 C2 8F 54 00 C5 8F 64 00 D9 AF 26 18 59 00 2B 18 03 00 88 00 C3 AF 64 00 C4 8F ?? ?? ?? 0? 0C 00 A5 24 59 00 40 10 54 00 D0 8F 04 00 E2 8E FD FF 03 24 24 18 43 00 88 00 60 14 0A 00 03 24 54 00 D0 8F 02 00 02 24 00 00 E3 8E 08 00 02 AE 64 00 D9 8F 02 00 63 30 0A C8 03 00 80 00 D9 AF 21 A8 00 00 74 00 C0 AF 84 00 C0 AF 78 00 C0 AF 70 00 C0 AF 6C 00 C0 AF 8C 00 C0 AF 80 00 D2 8F 21 98 00 02 68 00 D5 AF 09 02 70 12 00 00 00 00 08 00 15 8E 0A 00 02 24 FF FF B4 32 A5 01 82 12 10 00 11 24 58 00 D3 8F 56 01 60 12 20 00 23 26 60 00 C3 AF ?? ?? ?? 0? FF FF B5 32 0C 00 04 26 22 00 45 A4 03 00 85 88 00 00 85 98 28 00 40 AC 2C 00 40 AC 24 00 45 AC 00 00 73 8E 1C 00 56 24 48 01 60 12 21 90 00 00 ?? ?? ?? 0? 60 00 C4 8F 4D 01 40 10 00 00 C2 AE 08 00 65 8E 04 00 67 8E 00 00 E8 8E 20 00 44 24 14 00 44 AC 0A 00 04 24 0C 00 45 AC 04 00 55 AC 00 00 48 AC 08 00 47 AC 10 00 51 AC 18 00 52 AC 20 00 54 A4 1C 00 40 AC E2 FF 84 16 0C 00 65 8E 0C 00 04 26 24 00 40 AC 22 00 45 A4 03 00 89 88 07 00 88 88 0B 00 87 88 0F 00 85 88 00 00 89 98 04 00 88 98 08 00 87 98 0C 00 85 98 28 00 49 AC 2C 00 48 AC 30 00 47 AC 34 00 45 AC 1C 00 04 8E ?? ?? ?? 0? 38 00 44 AC 20 00 C6 24 ?? ?? ?? 0? 7C 00 C6 AF 08 00 02 8E 30 00 40 14 64 00 C4 8F ?? ?? ?? 0? 25 00 05 24 7E 06 40 14 21 88 40 00 64 00 C5 8F 0A 00 04 24 ?? ?? ?? 0? 0C 00 06 26 28 00 DC 8F 8E 02 40 18 00 00 00 00 04 00 E3 8E 31 02 60 10 0A 00 02 24 2F 02 62 10 02 00 02 24 2F 00 62 10 54 00 C2 8F 09 00 12 24 21 A8 00 00 74 00 C0 AF 84 00 C0 AF 78 00 C0 AF 70 00 C0 AF 6C 00 C0 AF 88 00 D9 8F 17 01 20 17 00 00 00 00 6C 00 D9 8F 10 01 20 17 00 00 00 00 78 00 D9 8F 09 01 20 17 00 00 00 00 74 00 D9 8F 19 FF 20 13 21 10 40 02 21 20 A0 02 ?? ?? ?? 0? AC 00 D2 AF ?? ?? ?? 0? AC 00 C2 8F F0 00 D9 8F 21 28 40 00 88 00 C0 AF ?? ?? ?? 0? 64 00 D9 AF ?? ?? ?? 0? 80 00 C0 AF E1 FF 43 14 09 00 12 24 00 00 E3 8E 08 00 64 30 DE FF 80 10 21 A8 00 00 54 00 D0 8F FF FF 05 3C 0C 00 04 8E 14 00 05 AE 10 00 00 AE 18 00 04 AE 0C 00 00 AE ?? ?? ?? 0? 08 00 02 AE 0C 00 44 8C D1 FF 80 14 09 00 12 24 10 00 44 8C CF FF 80 14 21 A8 00 00 14 00 45 8C FF FF 04 3C CB FF A4 14 00 00 00 00 18 00 44 8C 08 00 43 AC 21 80 40 00 0C 00 44 AC 12 00 20 12 FE 80 02 34 0C 00 03 8E FF C0 63 30 0A 04 62 10 FF 00 02 24 0C 00 03 92 02 04 62 10 01 00 24 26 30 00 C5 27 ?? ?? ?? 0? 0A 00 06 24 30 00 C3 8F 28 00 DC 8F 1C 00 02 AE 00 00 62 80 8E 01 40 14 00 00 00 00 54 00 D0 8F 00 00 E2 8E 02 00 42 30 A0 03 40 14 64 00 D9 8F 08 00 02 8E 80 00 C0 AF 4A FF 40 14 00 00 00 00 00 00 E2 8E 04 00 42 30 81 01 40 14 02 00 02 24 04 00 E3 8E F9 03 62 10 4C 00 C0 AF ?? ?? 10 3C ?? ?? 02 8E D8 03 40 18 00 00 00 00 01 00 42 24 65 00 43 28 73 02 60 10 00 00 00 00 ?? ?? 02 AE ?? ?? 02 3C ?? ?? 42 8C 7E 05 40 10 ?? ?? 04 3C 4C 00 C2 AF 21 80 00 00 ?? ?? 02 3C ?? ?? 42 8C FC 06 40 10 00 00 00 00 ?? ?? 99 8F 3B E8 03 7C 21 28 00 00 21 88 23 03 94 00 D9 AF 7C 00 D9 8F 00 00 24 8E 20 04 39 27 ?? ?? ?? 0? 68 00 D9 AF 00 00 32 8E FF DF 11 24 01 80 03 34 08 00 59 8E 27 10 02 00 01 00 04 24 24 88 31 03 90 00 D9 AF 68 00 D9 8F 28 00 DC 8F 0A 80 82 00 2B 18 23 03 CC 06 60 10 08 00 51 AE D8 FB BD 27 28 00 B5 27 74 00 C0 AF 80 06 00 16 FF FF 19 24 3B E8 03 7C 98 00 C3 AF 7C 00 D9 AF ?? ?? 82 8F 98 00 D9 8F 70 00 D7 AF 21 40 00 00 21 10 59 00 70 00 D9 8F 54 00 D2 27 9C 00 D6 AF 04 00 39 8F 4C 00 C4 8F 20 04 11 24 FF FF 03 24 84 00 C0 AF 78 00 C0 AF 8C 00 C0 AF A8 00 C2 AF 21 98 00 01 74 00 D7 8F 21 B0 40 02 2B 00 20 13 6C 00 D9 AF 70 00 D9 8F 00 00 22 8F 02 00 42 30 93 03 40 14 ?? ?? 02 3C ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? C4 00 C3 AF 21 80 40 00 28 00 DC 8F BE 01 40 14 C4 00 C3 8F A8 00 D9 8F FD FF 02 24 00 00 23 8F 24 10 62 00 39 05 40 10 01 00 19 24 ?? ?? 82 8F 98 00 D9 8F 01 00 03 24 6C 00 C3 AF 21 10 59 00 FF FF 03 24 00 00 43 AC 21 A0 00 00 6C 00 D9 8F 4C 00 C2 8F 80 20 19 00 21 20 44 00 04 00 85 8C 01 00 04 24 88 01 A4 10 94 00 D9 8F 00 00 44 8C 84 01 80 10 70 00 D9 8F 4C 00 C4 AF 04 00 39 8F D7 FF 20 17 6C 00 D9 AF ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? C4 00 C3 AF 50 00 D9 27 21 80 40 00 30 00 D2 27 60 00 D9 AF 32 06 40 10 C4 00 C3 8F 01 00 14 24 FE FF 13 24 21 20 00 02 ?? ?? ?? 0? 50 00 C0 AF 60 00 C3 8F 64 00 C4 8F 14 00 B2 AF 10 00 A3 AF 18 00 A0 AF 21 28 C0 02 21 30 A0 02 21 C8 00 02 09 F8 20 03 21 38 20 02 01 01 54 10 28 00 DC 8F F7 00 53 14 22 00 04 24 50 00 C3 8F 3A 01 64 14 FF FF 05 24 30 00 C3 8F 2F 01 65 14 21 20 60 00 DF 00 E0 16 21 20 A0 02 68 00 D9 8F 40 18 11 00 01 80 04 34 21 28 79 00 2B 10 A4 00 FF 05 40 10 21 20 A0 00 F0 FF 02 24 0F 00 63 24 24 18 62 00 08 00 62 24 23 E8 A2 03 28 00 A2 27 21 20 43 00 DB 00 A4 12 00 00 00 00 21 88 60 00 68 00 C5 AF ?? ?? ?? 0? 21 A8 40 00 00 01 C5 8F 00 00 A2 8C 01 00 42 24 00 00 A2 AC 00 00 10 8E 7A 04 00 12 54 00 D3 8F ?? ?? ?? 0? 00 00 00 00 21 20 40 02 68 00 D5 8F ?? ?? ?? 0? 0A 00 12 24 ?? ?? ?? 0? 88 00 D9 8F ?? ?? ?? 0? 84 00 C4 8F ?? ?? ?? 0? 74 00 D9 8F ?? ?? ?? 0? 70 00 C4 8F ?? ?? ?? 0? 78 00 D9 8F ?? ?? ?? 0? 64 00 C4 8F ?? ?? ?? 0? 6C 00 D9 8F 0A 00 43 80 0E 01 60 14 21 28 40 00 1E 00 43 80 01 FE 60 10 14 00 54 24 58 00 C3 27 21 98 00 00 60 00 C3 AF 0C 00 F2 26 ?? ?? ?? 0? 21 A8 60 02 00 00 84 8E 0C 00 64 10 00 00 00 00 14 00 94 26 0A 00 82 82 FA 00 40 10 58 00 C2 8F 08 00 82 92 01 00 43 30 F9 FF 60 14 00 00 00 00 08 00 E3 8E F3 FF 60 14 00 00 00 00 0C 00 E3 8E 06 00 60 10 02 00 42 30 04 00 40 14 00 00 00 00 04 00 82 8E EE FF 62 14 00 00 00 00 E8 FF BD 27 00 00 24 8E 28 00 B3 27 21 28 80 02 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 10 00 B5 26 18 00 40 10 50 00 C2 AF 00 01 43 30 E2 FF 60 14 14 00 94 26 ?? ?? ?? 0? 21 E8 C0 03 8C 00 D9 8F 7A 00 20 13 08 00 02 24 00 00 E3 8E 18 00 63 30 56 FE 62 14 1C 00 11 24 0C 00 02 8E 54 FE 40 14 58 00 D3 8F 10 00 02 8E 51 FE 40 14 FF FF 02 3C 14 00 03 8E 4E FE 62 14 00 00 00 00 ?? ?? ?? 0? 00 00 10 8E 60 00 D9 8F 60 00 D3 AF ?? ?? ?? 0? 00 00 33 AF D8 FF BD 27 28 00 A2 27 00 00 40 AC 04 00 40 AC 08 00 40 AC 0C 00 40 AC 10 00 40 AC 14 00 40 AC 18 00 40 AC 1C 00 40 AC 04 00 E3 8E 15 00 60 10 54 00 C2 AF 0A 00 04 24 1E 00 64 10 00 00 00 00 02 00 04 24 2D 00 64 10 00 00 00 00 54 00 D0 8F B2 04 00 12 21 90 00 00 80 00 C0 AF 64 00 C0 AF 21 A8 00 00 74 00 C0 AF 84 00 C0 AF 78 00 C0 AF 70 00 C0 AF 6C 00 C0 AF 88 00 C0 AF ?? ?? ?? 0? 8C 00 C0 AF D8 FF BD 27 28 00 A4 27 00 00 44 AC 28 00 A0 AF 2C 00 A0 AF 30 00 A0 AF 34 00 A0 AF 38 00 A0 AF 3C 00 A0 AF 40 00 A0 AF E1 FF 60 14 44 00 A0 AF 00 00 E4 8E 0A 00 05 24 01 00 84 30 0C 00 80 14 08 00 45 AC ?? ?? 04 3C ?? ?? 83 24 ?? ?? 86 8C 04 00 65 8C 08 00 64 8C 0C 00 63 8C 0C 00 46 AC 10 00 45 AC 14 00 44 AC 18 00 43 AC 04 00 E3 8E D2 FF 60 14 00 00 42 8C 00 00 E3 8E 02 00 04 24 08 00 44 AC 01 00 63 30 D0 FF 60 14 54 00 D0 8F 00 01 03 3C 7F 00 63 24 ?? ?? ?? 0? 0C 00 43 AC 00 00 E2 8E 02 00 43 30 F5 FD 60 10 00 00 00 00 40 04 40 12 21 A0 00 00 21 88 00 00 80 00 43 30 78 02 60 10 78 00 D9 8F 00 02 43 7C 02 00 66 34 00 02 42 30 21 20 40 02 30 00 C5 27 ?? ?? ?? 0? 0A 30 62 00 82 04 40 14 68 00 D5 8F 30 00 C2 8F 6C 02 52 10 78 00 D9 8F 21 90 40 00 E0 FD 20 12 00 00 00 00 ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 08 00 15 8E ?? ?? ?? 0? 1C 00 11 24 40 88 11 00 ?? ?? ?? 0? 21 28 20 02 6B 00 40 10 94 00 D9 8F 01 00 17 24 ?? ?? ?? 0? 21 A8 40 00 02 01 12 24 21 A8 00 00 ?? ?? ?? 0? 74 00 C0 AF 21 88 23 02 68 00 C5 AF ?? ?? ?? 0? 21 A8 40 00 21 18 40 00 30 00 C2 8F 02 00 79 24 6C 00 D9 AF 04 00 42 38 01 00 54 2C ?? ?? ?? 0? 21 98 80 02 70 00 D9 8F 21 18 40 00 00 00 22 8F 02 00 42 30 9A 00 40 14 80 00 D9 8F 00 00 C2 8E 70 00 C9 8F 01 00 14 24 02 00 06 24 0A 00 07 24 FF FF 08 3C 26 00 40 10 03 00 19 24 08 00 44 8C 08 00 86 10 04 00 25 8D 1D 00 A0 10 00 00 00 00 14 00 85 10 00 00 00 00 00 00 42 8C ?? ?? ?? 0? 00 00 C2 AE F8 FF A7 14 00 00 00 00 00 00 24 8D 08 00 84 30 F8 FF 80 10 00 00 00 00 0C 00 44 8C 08 00 47 AC 14 00 48 AC 18 00 44 AC 10 00 40 AC 0C 00 40 AC 21 B0 40 00 21 A0 00 00 ?? ?? ?? 0? 00 00 42 8C 21 B0 40 00 21 A0 00 00 E1 FF 87 14 00 00 42 8C 01 00 19 24 ?? ?? ?? 0? 8C 00 D9 AF 21 B0 40 00 21 A0 00 00 ?? ?? ?? 0? 00 00 42 8C 6C 00 D9 AF ?? ?? ?? 0? 21 98 80 02 21 18 40 00 21 10 80 00 02 00 04 24 C3 FF 44 14 04 00 42 38 FD FF 14 24 ?? ?? ?? 0? 21 98 80 02 21 18 40 00 ?? ?? ?? 0? 30 00 C2 8F 54 00 D0 8F 0A 00 02 24 ?? ?? ?? 0? 08 00 02 AE F9 FC 50 10 20 00 B3 26 ?? ?? ?? 0? 7C 00 D3 AF E8 FF BD 27 00 00 24 8E 28 00 A3 27 0C 00 E6 26 21 38 60 00 ?? ?? ?? 0? 58 00 C3 AF 2B FD 40 10 50 00 C2 AF ?? ?? ?? 0? 21 E8 C0 03 ?? ?? ?? 0? 0A 00 02 24 94 00 D9 8F 3B E8 03 7C 74 00 D7 AF 21 10 23 03 00 00 42 8C 90 00 D9 8F 0A 00 12 24 08 00 44 8C 00 20 23 33 70 00 C0 AF 25 18 83 00 6C 00 C0 AF ?? ?? ?? 0? 08 00 43 AC 94 00 D9 8F 3B E8 03 7C 74 00 D7 AF 21 10 23 03 00 00 42 8C 70 00 D7 8F 9C 00 D6 8F 08 00 51 8C 21 40 60 02 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 90 00 D9 8F 21 20 64 00 00 20 25 33 00 00 83 8C 25 88 25 02 08 00 51 AC FF FF 02 24 D2 03 62 10 0B 01 12 24 11 03 80 12 54 00 D0 8F 0F 03 00 11 FD FF 02 24 9C FD 82 16 05 01 12 24 26 50 14 01 03 00 02 24 0A 90 4A 00 70 00 C0 AF ?? ?? ?? 0? 6C 00 C0 AF 70 00 D9 8F 0A 00 04 24 04 00 22 8F 1B 00 44 10 00 00 00 00 19 00 40 10 02 00 04 24 FA 04 44 10 50 00 D9 27 21 A0 00 00 7C 00 D9 8F 01 00 02 24 7B 01 22 13 00 00 00 00 79 01 62 10 FE FF 02 24 5F 03 22 13 FF FF 02 24 58 03 62 10 02 00 79 24 ?? ?? ?? 0? 6C 00 D9 AF 54 00 D0 8F 80 00 C0 AF ?? ?? ?? 0? 08 00 02 8E 67 FF 20 17 00 00 C2 8E 04 00 59 8C ?? ?? ?? 0? 80 00 D9 AF 44 00 C3 27 50 00 D9 27 74 00 D7 AF 7C 00 D6 AF 44 00 C0 AF 30 00 D2 27 48 00 D3 27 6C 00 C3 AF 60 00 D9 AF 22 00 14 24 64 00 D6 8F ?? ?? ?? 0? 21 B8 60 00 48 00 C4 8F FF FF 03 24 F1 01 83 14 21 18 40 00 40 10 11 00 F0 FF 04 24 0F 00 42 24 24 10 44 00 08 00 43 24 23 E8 A3 03 28 00 A3 27 21 20 62 00 26 A8 A4 02 21 88 51 00 0B 88 55 00 21 A8 60 00 21 20 00 02 ?? ?? ?? 0? 50 00 C0 AF 60 00 C3 8F 21 20 C0 02 10 00 B1 AF 14 00 A3 AF 18 00 B3 AF 1C 00 A0 AF 20 00 B7 AF 0A 00 05 24 21 30 40 02 21 C8 00 02 09 F8 20 03 21 38 A0 02 50 00 C4 8F DF FF 94 10 28 00 DC 8F 7C 00 D6 8F 21 18 40 00 7C 00 C2 AF 01 00 02 24 D5 01 62 10 74 00 D7 8F C5 00 80 10 21 A0 00 00 48 00 C4 8F FF FF 02 24 B0 04 82 14 94 00 D9 8F 3B E8 03 7C 21 10 60 00 21 18 23 03 00 00 63 8C 90 00 D9 8F ?? ?? 87 8F 08 00 66 8C 00 20 25 33 21 10 E2 00 00 00 44 AC 25 10 C5 00 08 00 62 AC ?? ?? ?? 0? 0B 00 02 24 ?? ?? 00 AE ?? ?? 02 3C ?? ?? 42 90 8C FD 40 14 ?? ?? 02 3C }
	condition:
		$1
}

rule file_1_7_0 {
	meta:
		name = "get_scope"
		size = 220
	strings:
		$1 = { 00 00 83 94 0A 00 02 24 16 00 62 10 02 00 05 24 03 00 65 10 0F 00 02 24 08 00 E0 03 00 00 00 00 ?? ?? 02 3C ?? ?? 43 8C 04 00 86 8C 04 00 65 8C 00 00 64 8C 24 28 C5 00 08 00 A4 10 0C 00 62 24 04 00 45 8C 21 18 40 00 0C 00 42 24 F4 FF 44 8C 24 28 C5 00 FA FF A4 14 00 00 00 00 08 00 E0 03 08 00 62 8C 08 00 83 90 FF 00 02 24 18 00 62 10 FE 80 05 34 08 00 82 8C FF C0 43 30 12 00 65 10 00 00 00 00 0B 00 40 14 00 00 00 00 0C 00 82 8C 08 00 40 14 00 00 00 00 10 00 82 8C 05 00 40 14 00 00 00 00 14 00 84 8C 00 01 02 3C 06 00 82 10 00 00 00 00 FE C0 63 38 0E 00 04 24 05 00 02 24 08 00 E0 03 0B 10 83 00 08 00 E0 03 02 00 02 24 09 00 82 90 08 00 E0 03 0F 00 42 30 }
	condition:
		$1
}

rule file_1_8_0 {
	meta:
		name = "rfc3484_sort"
		size = 1684
		refs = "0340 __check_native 0398 $LC14 03a4 $LC13 03b8 __assert_fail 03a8 __PRETTY_FUNCTION__.13534 03d0 $LC15 0620 $LC17 063c $LC16 0658 $LC19 0678 $LC18"
	strings:
		$1 = { B8 FF BD 27 28 00 B2 AF 00 00 92 8C 2C 00 B3 AF 24 00 B1 AF 00 00 B3 8C 80 18 12 00 00 89 12 00 00 00 C2 8C 23 88 23 02 23 88 32 02 80 18 13 00 20 00 B0 AF 80 88 11 00 00 81 13 00 21 88 51 00 23 80 03 02 23 80 13 02 21 00 23 92 80 80 10 00 21 80 50 00 38 00 B6 AF 44 00 BF AF 40 00 BE AF 3C 00 B7 AF 34 00 B5 AF 30 00 B4 AF 21 B0 C0 00 40 00 60 10 21 00 02 92 96 00 40 10 04 00 2D 26 00 00 22 8E 04 00 0E 26 14 00 47 8C ?? ?? ?? 0? 21 20 E0 00 00 00 03 8E 21 A0 40 00 ?? ?? ?? 0? 14 00 64 8C 21 20 A0 01 ?? ?? ?? 0? 21 A8 40 00 21 20 C0 01 ?? ?? ?? 0? 21 40 40 00 97 00 88 12 00 00 00 00 6B 00 A2 12 44 00 BF 8F 22 00 22 92 01 00 43 30 73 00 60 14 00 00 00 00 22 00 03 92 01 00 64 30 7B 00 80 14 02 00 42 30 73 00 40 10 02 00 63 30 78 00 60 10 FF FF 02 24 ?? ?? 02 3C ?? ?? 4C 8C FF 7F 0B 3C 21 20 E0 00 21 28 80 01 ?? ?? ?? 0? FF FF 66 35 21 28 80 01 FF FF 66 35 21 20 A0 01 ?? ?? ?? 0? 21 78 40 00 00 00 03 8E 21 28 80 01 FF FF 66 35 14 00 64 8C ?? ?? ?? 0? 21 68 40 00 FF FF 66 35 21 20 C0 01 21 28 80 01 ?? ?? ?? 0? 21 58 40 00 6B 00 ED 11 00 00 00 00 44 00 62 11 44 00 BF 8F 00 00 22 8E ?? ?? ?? 0? 14 00 47 8C 3F 00 40 14 44 00 BF 8F 00 00 22 8E 14 00 47 8C ?? ?? ?? 0? 21 20 E0 00 00 00 03 8E 21 A0 40 00 ?? ?? ?? 0? 14 00 64 8C 21 A8 40 00 ?? ?? 02 3C ?? ?? 4B 8C 21 20 E0 00 21 30 00 00 ?? ?? ?? 0? 21 28 60 01 00 00 03 8E 21 28 60 01 21 30 00 00 14 00 64 8C ?? ?? ?? 0? 21 58 40 00 2A 18 4B 00 3F 00 60 14 2A 58 62 01 25 00 60 15 44 00 BF 8F 21 00 22 92 11 00 40 10 2A 10 95 02 24 00 37 8E 24 00 1E 8E 0C 00 FE 12 FF FF 02 24 28 00 26 8E 28 00 09 8E 1C 00 A6 AF A2 00 C2 10 18 00 A9 AF 45 00 22 11 00 00 00 00 2B 00 C0 14 00 00 00 00 13 00 20 15 44 00 BF 8F 2A 10 95 02 28 00 40 14 2A A0 B4 02 0E 00 80 16 44 00 BF 8F 21 00 22 92 07 00 40 10 00 00 00 00 00 00 24 8E 00 00 03 8E 04 00 82 8C 04 00 65 8C 66 00 45 10 02 00 05 24 2B 90 53 02 1B 00 40 16 FF FF 02 24 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 01 00 02 24 08 00 E0 03 48 00 BD 27 22 00 03 92 01 00 64 30 F0 FF 80 10 02 00 42 30 8F FF 40 14 02 00 63 30 90 FF 60 10 ?? ?? 02 3C ?? ?? ?? 0? 44 00 BF 8F D8 FF 20 15 2A 10 95 02 FF FF 02 24 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 F3 FF 62 15 FF FF 02 24 00 00 22 8E ?? ?? ?? 0? 14 00 47 8C 6B FF A2 12 FF FF 02 24 ?? ?? ?? 0? 44 00 BF 8F FF FF 17 24 18 00 A0 AF 21 30 C0 03 21 20 E0 02 1C 00 A5 27 ?? ?? ?? 0? 18 00 A7 27 04 00 C2 8E 1C 00 A6 8F B2 FF 40 18 18 00 A9 8F 00 00 C3 8E 21 28 00 00 ?? ?? ?? 0? FF FF 08 24 15 00 C7 13 00 00 00 00 01 00 A5 24 A9 FF A2 10 2C 00 63 24 24 00 67 8C F9 FF F7 14 00 00 00 00 28 00 64 8C 03 00 88 10 00 00 00 00 03 00 86 14 ?? ?? 04 3C ?? ?? ?? 0? 28 00 66 AC ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 CD 06 06 24 ?? ?? ?? 0? ?? ?? E7 24 28 00 64 8C 03 00 88 10 00 00 00 00 03 00 89 14 ?? ?? 04 3C ?? ?? ?? 0? 28 00 69 AC ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 D3 06 06 24 ?? ?? ?? 0? ?? ?? E7 24 2B 00 45 10 0A 00 05 24 08 00 45 10 00 00 00 00 21 18 00 00 21 10 00 00 2A 10 43 00 94 FF 40 10 2B 90 53 02 ?? ?? ?? 0? 44 00 BF 8F 04 00 25 96 93 00 A2 14 ?? ?? 07 3C 04 00 02 96 88 00 45 14 21 10 00 00 14 00 87 8C 14 00 68 8C 21 28 00 00 04 00 2D 26 04 00 0A 26 04 00 09 24 21 20 E2 00 21 18 A2 01 08 00 84 8C 08 00 63 8C 4D 00 83 14 26 18 83 00 21 30 02 01 21 18 42 01 08 00 C6 8C 08 00 63 8C 46 00 C3 14 21 18 80 00 01 00 A5 24 F2 FF A9 14 04 00 42 24 ?? ?? ?? 0? 21 18 00 00 A5 FF 26 11 1C 00 A0 AF ?? ?? ?? 0? FF FF 1E 24 04 00 25 96 63 00 A2 14 ?? ?? 07 3C 04 00 02 96 59 00 45 14 ?? ?? 05 3C 14 00 82 8C 08 00 26 8E 23 00 24 92 04 00 42 8C A0 30 06 7C 02 34 26 00 A0 10 02 7C 02 14 22 00 26 30 C2 00 23 20 04 00 FF FF 02 24 04 20 82 00 24 20 C4 00 0A 00 80 14 21 10 00 00 00 80 04 3C ?? ?? ?? 0? 20 00 07 24 05 00 47 10 42 20 04 00 24 28 86 00 FC FF A0 10 01 00 42 24 FF FF 42 24 14 00 63 8C 08 00 06 8E 23 00 04 92 04 00 63 8C A0 30 06 7C 02 34 26 00 A0 18 03 7C 02 1C 23 00 26 30 C3 00 23 20 04 00 FF FF 03 24 04 18 83 00 24 18 C3 00 0E 00 60 14 00 80 04 3C ?? ?? ?? 0? 20 00 07 24 AA FF 67 10 42 20 04 00 24 28 86 00 FC FF A0 10 01 00 63 24 FF FF 63 24 2A 20 62 00 A3 FF 80 10 00 00 00 00 ?? ?? ?? 0? FF FF 02 24 ?? ?? ?? 0? 21 18 00 00 26 18 83 00 A0 30 03 7C 02 34 26 00 21 10 00 00 00 80 03 3C ?? ?? ?? 0? 20 00 07 24 05 00 47 10 42 18 03 00 24 20 66 00 FC FF 80 10 01 00 42 24 FF FF 42 24 02 00 A3 24 80 18 03 00 21 80 03 02 21 18 03 01 00 00 65 8C 04 00 06 8E 21 18 00 00 00 80 04 3C 26 30 C5 00 A0 30 06 7C 02 34 26 00 ?? ?? ?? 0? 20 00 07 24 83 FF 67 10 42 20 04 00 24 28 86 00 FC FF A0 10 01 00 63 24 FF FF 63 24 ?? ?? ?? 0? 2A 20 62 00 ?? ?? 04 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 F1 06 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 F0 06 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 10 07 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 0F 07 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_1_9_0 {
	meta:
		name = "freeaddrinfo"
		size = 80
		refs = "0024 free"
	strings:
		$1 = { D8 FF BD 27 1C 00 B0 AF 24 00 BF AF 20 00 B1 AF 03 00 80 14 21 80 80 00 ?? ?? ?? 0? 24 00 BF 8F 18 00 04 8E ?? ?? ?? 0? 1C 00 11 8E ?? ?? ?? 0? 21 20 00 02 FA FF 20 16 21 80 20 02 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_1_10_0 {
	meta:
		name = "getaddrinfo"
		size = 2884
		refs = "0004 __gnu_local_gp 0150 __pthread_once 01e8 qsort 020c __libc_errno 02bc __connect 0384 __socket 03b0 memcmp 03c8 memcpy 0400 __getsockname 05f0 __check_pf 06d4 qsort_r 0774 __free_in6ai 07d0 strtoul 0874 $LC21 0878 $LC13 088c __assert_fail 087c __PRETTY_FUNCTION__.13806 0898 freeaddrinfo 08f4 free 030c $LC20 09fc __lll_lock_wait_private 0ac4 __libc_alloca_cutoff 0ad4 malloc 0a1c $LC0 0b14 __xstat64"
	strings:
		$1 = { 88 FE BD 27 ?? ?? 1C 3C ?? ?? 9C 27 70 01 BE AF 21 F0 A0 03 5C 01 B3 AF 58 01 B2 AF 54 01 B1 AF 74 01 BF AF 6C 01 B7 AF 68 01 B6 AF 64 01 B5 AF 60 01 B4 AF 50 01 B0 AF 18 00 DC AF 21 98 80 00 21 90 A0 00 21 88 C0 00 84 01 C7 AF 05 00 80 10 FC 00 C0 AF 00 00 83 80 2A 00 02 24 88 01 62 10 00 00 00 00 7F 01 40 12 2A 00 02 24 00 00 43 82 79 01 62 10 00 00 00 00 7E 01 20 12 00 00 00 00 00 00 22 8E 00 F8 03 24 24 18 43 00 3D 02 60 14 24 01 C3 AF 02 00 43 30 03 00 60 10 00 00 00 00 30 02 60 12 00 00 00 00 20 00 42 30 F8 00 C0 AF F4 00 C0 AF 01 01 C0 A3 00 01 C0 A3 49 01 40 14 21 80 00 00 E9 01 40 12 00 00 00 00 00 00 42 82 BC 01 40 14 21 28 00 00 04 00 22 8E FD FF 03 24 24 18 43 00 04 00 60 10 F0 00 C0 AF 0A 00 03 24 17 02 43 14 F8 00 C4 8F F0 00 C2 27 10 00 A2 AF 21 20 60 02 21 30 20 02 ?? ?? ?? 0? FC 00 C7 27 E0 01 40 14 18 00 DC 8F FC 00 C2 8F 1C 01 C0 AF 05 00 40 10 1C 01 C3 8F 1C 00 42 8C FE FF 40 14 01 00 63 24 1C 01 C3 AF F0 00 C2 8F 02 00 42 2C 8C 01 40 14 ?? ?? 04 3C ?? ?? 82 8C 44 01 C2 AF ?? ?? 02 3C ?? ?? 42 24 4C 02 40 10 ?? ?? 05 3C ?? ?? 84 24 ?? ?? ?? 0? ?? ?? A5 24 18 00 DC 8F 1C 01 C4 8F 01 80 02 34 00 91 04 00 80 89 04 00 23 88 32 02 2B 10 22 02 4E 02 40 10 00 00 00 00 08 00 31 26 23 E8 B1 03 18 00 A4 27 20 01 C4 AF 40 01 C0 AF 1C 01 C2 8F 1C 01 C3 8F 20 01 C4 8F 80 10 02 00 2C 01 C2 AF 23 10 42 02 23 10 43 00 80 10 02 00 21 10 82 00 8E 01 00 12 28 01 C2 AF F8 00 C4 8F 08 00 80 10 FC 00 D1 8F F4 00 C5 8F ?? ?? 07 3C 18 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 18 00 DC 8F FC 00 D1 8F E7 01 20 12 20 01 C5 8F 3B E8 03 7C 21 20 60 00 20 01 C2 8F ?? ?? 83 8F 28 01 D4 8F 20 01 D0 8F 0C 00 42 24 04 00 A5 24 21 18 64 00 3C 01 C2 AF 0C 01 C2 AF 38 01 C5 AF 08 01 C5 AF 14 01 C0 AF FF FF 12 24 10 01 C0 AF 21 10 00 00 21 98 00 00 18 01 C3 AF FF FF 03 24 00 00 11 AE 28 00 03 AE 05 00 40 10 00 00 93 AE 10 00 46 8C 10 00 23 8E 50 00 C3 10 00 00 00 00 FF FF 02 24 21 00 00 A2 22 00 00 A2 23 00 00 A2 3C 00 42 12 24 00 02 AE 14 01 C3 8F 02 00 02 24 05 00 62 14 21 20 40 02 04 00 23 8E 0A 00 02 24 32 00 62 10 00 00 00 00 20 00 C5 27 10 00 06 24 20 00 C0 AF 24 00 C0 AF 28 00 C0 AF ?? ?? ?? 0? 2C 00 C0 AF 1C 00 02 24 E0 00 C2 AF 14 00 25 8E 10 00 26 8E ?? ?? ?? 0? 21 20 40 02 47 00 40 10 04 00 05 26 18 01 C2 8F 00 00 43 8C 7C 00 02 24 17 00 62 10 14 01 C3 8F 20 00 00 A2 18 00 22 8E 05 00 40 10 10 01 C4 8F A5 01 80 14 ?? ?? 04 3C 18 00 20 AE 10 01 C2 AF 08 01 C5 8F 0C 01 C2 8F 1C 00 23 8E 2C 00 A5 24 2C 00 42 24 01 00 73 26 2C 00 10 26 04 00 94 26 08 01 C5 AF D3 00 60 10 0C 01 C2 AF 21 10 20 02 ?? ?? ?? 0? 21 88 60 00 0A 00 02 24 E8 FF 62 14 02 00 02 24 04 00 23 8E E5 FF 62 14 00 00 00 00 21 20 40 02 A6 0F 02 24 0C 00 00 00 04 00 23 8E 01 00 05 24 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 14 01 C3 AF 21 90 40 00 1C 00 02 24 E0 00 C2 AF FF FF 02 24 D2 FF 42 12 18 01 C2 8F ?? ?? ?? 0? 14 00 25 8E 14 00 44 8C ?? ?? ?? 0? 14 00 25 8E AE FF 40 14 FF FF 02 24 F4 FF 06 92 04 00 04 26 ?? ?? ?? 0? D8 FF 05 26 F4 FF 06 92 F5 FF 05 92 F6 FF 04 92 F7 FF 03 92 F8 FF 02 8E 20 00 06 A2 21 00 05 A2 22 00 04 A2 23 00 03 A2 ?? ?? ?? 0? 24 00 02 AE 21 20 40 02 ?? ?? ?? 0? E0 00 C6 27 B7 FF 40 14 18 01 C2 8F E0 00 C2 8F F8 00 C7 8F 20 00 02 A2 01 00 02 24 38 00 E0 10 21 00 02 A2 04 00 22 8E 02 00 03 24 5E 00 43 10 14 01 C3 8F 0C 00 02 26 03 00 46 88 07 00 45 88 0B 00 44 88 0F 00 43 88 00 00 46 98 04 00 45 98 08 00 44 98 0C 00 43 98 28 00 C6 AF 2C 00 C5 AF 30 00 C4 AF 34 00 C3 AF F4 00 D5 8F 34 01 D0 AF 21 B8 00 00 21 80 A0 02 30 01 D1 AF 21 A8 E0 00 2B 10 F0 02 08 00 40 14 21 B0 17 02 ?? ?? ?? 0? 30 01 D1 8F 2B 10 F6 02 3D 00 40 10 30 01 D1 8F 21 80 C0 02 21 B0 17 02 42 B0 16 00 C0 10 16 00 40 31 16 00 23 30 C2 00 21 88 A6 02 20 00 C4 27 ?? ?? ?? 0? 21 28 20 02 F2 FF 40 04 00 00 00 00 EB FF 40 14 01 00 D7 26 21 B0 20 02 34 01 D0 8F 07 00 C0 12 30 01 D1 8F 00 00 C2 92 22 00 02 A2 01 00 C2 92 23 00 02 A2 04 00 C2 8E 24 00 02 AE 04 00 22 8E 02 00 03 24 7B FF 43 14 00 00 00 00 14 01 C4 8F 0A 00 03 24 77 FF 83 14 0C 01 C5 8F 20 01 C4 8F 23 18 A4 00 3C 01 C5 8F 21 18 65 00 F4 FF 64 8C CF 00 80 14 ?? ?? 04 3C F8 FF 64 8C CC 00 80 14 ?? ?? 04 3C FC FF 64 8C FF FF 03 3C C7 00 83 14 08 01 C5 8F 20 01 C4 8F 23 18 A4 00 38 01 C5 8F 18 00 04 26 21 18 65 00 FC FF 62 A4 03 00 83 88 08 00 02 26 00 00 83 98 0B 00 03 AA 00 00 43 B8 10 00 02 24 ?? ?? ?? 0? 20 00 02 A2 02 00 03 24 04 00 22 8E 57 FF 43 14 34 01 D0 8F ?? ?? ?? 0? 14 01 C4 8F A3 FF 62 14 0C 00 02 26 FF FF 03 3C 08 01 C4 8F 20 01 C5 8F 30 00 C3 AF 38 01 C3 8F 23 10 85 00 28 00 C0 AF 2C 00 C0 AF 21 10 43 00 00 00 42 8C ?? ?? ?? 0? 34 00 C2 AF 01 01 C4 27 00 01 C5 27 F8 00 C6 27 ?? ?? ?? 0? F4 00 C7 27 04 00 22 8E 8B 00 40 14 02 00 03 24 01 01 C2 93 94 00 40 10 00 01 C2 93 AC FE 40 14 01 00 10 24 1C 00 22 8E 00 00 28 8E 08 00 27 8E 0C 00 26 8E 10 00 25 8E 14 00 24 8E 18 00 23 8E DC 00 C2 AF C0 00 C8 AF C8 00 C7 AF CC 00 C6 AF D0 00 C5 AF D4 00 C4 AF D8 00 C3 AF ?? ?? ?? 0? 02 00 02 24 01 00 42 82 86 FE 40 14 00 00 00 00 15 01 60 12 FE FF 02 24 84 FE 20 16 21 90 00 00 ?? ?? 11 3C ?? ?? ?? 0? ?? ?? 31 26 01 00 82 80 ?? ?? ?? 0? 0A 98 02 00 FF FF 02 24 03 00 42 12 21 20 40 02 A6 0F 02 24 0C 00 00 00 ?? ?? 02 3C 20 01 C3 8F 1C 01 C4 8F ?? ?? 42 8C E0 00 C3 AF C7 00 40 14 E4 00 C4 AF 28 01 C4 8F 1C 01 C5 8F E0 00 C2 27 ?? ?? 07 3C 10 00 A2 AF 04 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 28 01 C4 8F 1C 01 C5 8F 00 00 82 8C 02 00 A3 28 80 20 02 00 00 29 02 00 23 20 A4 00 23 10 82 00 20 01 C4 8F 80 10 02 00 21 10 82 00 00 00 48 8C A0 00 60 14 FC 00 C8 AF 2C 01 C5 8F 28 01 C2 8F 21 20 00 01 FC FF A7 24 21 38 47 00 ?? ?? ?? 0? 20 01 C9 8F 21 20 60 00 04 00 43 8C 04 00 42 24 80 28 03 00 00 31 03 00 23 28 C5 00 23 18 A3 00 80 18 03 00 21 18 23 01 00 00 63 8C F5 FF 47 14 1C 00 83 AC 1C 00 60 AC 10 01 C2 8F 40 01 C3 8F 61 00 60 14 18 00 02 AD ?? ?? ?? 0? F8 00 C4 8F FC 00 C2 8F CD 00 40 10 84 01 C4 8F 00 00 82 AC 21 E8 C0 03 74 01 BF 8F 24 01 C2 8F 6C 01 B7 8F 70 01 BE 8F 68 01 B6 8F 64 01 B5 8F 60 01 B4 8F 5C 01 B3 8F 58 01 B2 8F 54 01 B1 8F 50 01 B0 8F 08 00 E0 03 78 01 BD 27 21 20 40 02 20 00 C5 27 0A 00 06 24 ?? ?? ?? 0? E8 00 D2 AF EC 00 C2 AF 20 00 C2 8F 00 00 42 80 3C FE 40 10 E8 00 C5 27 00 00 22 8E 00 04 42 30 71 00 40 14 FF FF 02 24 ?? ?? ?? 0? EC 00 C2 AF 01 01 C4 27 00 01 C5 27 F8 00 C6 27 ?? ?? ?? 0? F4 00 C7 27 F8 00 C4 8F 6F FE 80 14 18 00 DC 8F ?? ?? ?? 0? FC 00 D1 8F 50 00 43 10 0A 00 03 24 0B 00 43 14 00 01 C2 93 21 FE 40 14 01 00 10 24 F8 00 C4 8F FE FF 02 24 ?? ?? ?? 0? 24 01 C2 AF ?? ?? ?? 0? 21 E8 C0 03 29 00 40 14 00 00 00 00 19 FE 40 16 01 00 10 24 ?? ?? ?? 0? 21 28 00 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 48 0A 06 24 ?? ?? ?? 0? ?? ?? E7 24 FC 00 C4 8F ?? ?? ?? 0? 48 01 C2 AF ?? ?? ?? 0? F8 00 C4 8F 48 01 C2 8F FF FE 03 24 21 E8 C0 03 74 01 BF 8F 24 10 43 00 23 10 02 00 24 01 C2 AF 24 01 C2 8F 6C 01 B7 8F 70 01 BE 8F 68 01 B6 8F 64 01 B5 8F 60 01 B4 8F 5C 01 B3 8F 58 01 B2 8F 54 01 B1 8F 50 01 B0 8F 08 00 E0 03 78 01 BD 27 ?? ?? ?? 0? 20 01 C4 8F ?? ?? ?? 0? 00 00 00 00 1C 00 22 8E 00 00 28 8E 08 00 27 8E 0C 00 26 8E 10 00 25 8E 14 00 24 8E 18 00 23 8E DC 00 C2 AF C0 00 C8 AF C8 00 C7 AF CC 00 C6 AF D0 00 C5 AF D4 00 C4 AF D8 00 C3 AF 0A 00 02 24 C4 00 C2 AF 01 00 10 24 ?? ?? ?? 0? C0 00 D1 27 FA FF 05 24 ?? ?? ?? 0? 24 01 C5 AF ?? ?? ?? 0? 21 E8 C0 03 FF FF 02 24 ?? ?? ?? 0? 24 01 C2 AF 01 01 C2 93 D3 FD 40 14 01 00 10 24 ?? ?? ?? 0? F8 00 C4 8F FF FF 05 24 ?? ?? ?? 0? 24 01 C5 AF ?? ?? ?? 0? 21 18 00 01 ?? ?? ?? 0? 10 01 C0 AF ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 63 0A 06 24 ?? ?? ?? 0? ?? ?? E7 24 F8 00 C4 8F FE FF 03 24 ?? ?? ?? 0? 24 01 C3 AF ?? ?? ?? 0? 21 E8 C0 03 ?? ?? 10 3C ?? ?? 05 26 00 00 A2 C0 01 00 41 24 00 00 A1 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 04 00 40 10 44 01 C2 8F ?? ?? ?? 0? ?? ?? 04 26 44 01 C2 8F 06 00 40 10 28 01 C4 8F ?? ?? 02 3C ?? ?? 42 8C 3C 00 40 14 ?? ?? 05 3C 28 01 C4 8F 1C 01 C5 8F E0 00 C2 27 ?? ?? 07 3C 10 00 A2 AF 04 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 1E FF 40 14 ?? ?? 04 26 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 28 01 C4 8F 44 01 C3 8F B7 FD 60 14 00 00 00 00 ?? ?? ?? 0? 48 01 C4 AF 48 01 C4 8F 18 00 DC 8F ?? ?? 82 8C 02 00 42 34 ?? ?? ?? 0? ?? ?? 82 AC FE FF 02 24 ?? ?? ?? 0? 24 01 C2 AF ?? ?? ?? 0? 21 20 20 02 B0 FD 40 14 18 00 DC 8F ?? ?? ?? 0? 21 20 20 02 20 01 C2 AF 04 00 40 10 18 00 DC 8F 01 00 03 24 ?? ?? ?? 0? 40 01 C3 AF F8 00 C4 8F F6 FF 05 24 ?? ?? ?? 0? 24 01 C5 AF ?? ?? ?? 0? 21 E8 C0 03 03 00 04 24 ?? ?? A5 24 ?? ?? ?? 0? 20 00 C6 27 05 00 40 14 ?? ?? 02 3C ?? ?? 42 8C 68 00 C3 8F BC FF 62 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 28 01 C4 8F }
	condition:
		$1
}

rule file_1_11_0 {
	meta:
		name = "fini"
		size = 112
		refs = "001c free"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 44 8C ?? ?? 03 3C E0 FF BD 27 ?? ?? 63 24 03 00 83 10 1C 00 BF AF ?? ?? ?? 0? ?? ?? 43 AC ?? ?? 02 3C ?? ?? 44 8C ?? ?? 03 3C ?? ?? 63 24 03 00 83 10 00 00 00 00 ?? ?? ?? 0? ?? ?? 43 AC ?? ?? 02 3C ?? ?? 44 8C ?? ?? 03 3C ?? ?? 63 24 04 00 83 10 1C 00 BF 8F 20 00 BD 27 ?? ?? ?? 0? ?? ?? 43 AC 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "bcopy"
		size = 404
		refs = "0074 _wordcopy_fwd_dest_aligned 0114 _wordcopy_bwd_dest_aligned 0164 _wordcopy_bwd_aligned 0174 _wordcopy_fwd_aligned"
	strings:
		$1 = { 23 18 A4 00 D8 FF BD 27 2B 18 66 00 21 10 A0 00 24 00 BF AF 20 00 B2 AF 1C 00 B1 AF 29 00 60 14 18 00 B0 AF 10 00 C3 2C 19 00 60 14 21 80 80 00 23 40 05 00 03 00 08 31 52 00 00 11 23 90 C8 00 21 88 A8 00 21 18 80 00 00 00 67 90 01 00 42 24 01 00 63 24 FC FF 51 14 FF FF 47 A0 21 80 88 00 03 00 02 32 21 20 20 02 21 28 00 02 41 00 40 10 82 30 12 00 ?? ?? ?? 0? 00 00 00 00 FC FF 02 24 24 10 42 02 21 80 02 02 03 00 46 32 21 10 22 02 06 00 C0 10 21 20 46 00 00 00 03 92 01 00 42 24 01 00 10 26 FC FF 44 14 FF FF 43 A0 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 10 00 C3 2C 21 10 86 00 19 00 60 14 21 80 A6 00 03 00 05 32 2C 00 A0 10 23 90 C5 00 23 88 45 00 21 18 00 02 FF FF 42 24 00 00 44 90 FF FF 63 24 FC FF 51 14 00 00 64 A0 23 80 05 02 03 00 22 32 21 20 00 02 21 28 20 02 15 00 40 10 82 30 12 00 ?? ?? ?? 0? 00 00 00 00 FC FF 03 24 24 18 43 02 03 00 46 32 23 10 23 02 DF FF C0 10 23 80 03 02 23 30 46 00 FF FF 42 24 00 00 43 90 FF FF 10 26 FC FF 46 14 00 00 03 A2 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? FC FF 03 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? FC FF 02 24 ?? ?? ?? 0? 21 88 A0 00 ?? ?? ?? 0? 21 88 40 00 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "__libc_cleanup_routine"
		size = 32
		altNames = "__pthread_cleanup_routine"
	strings:
		$1 = { 08 00 82 8C 03 00 40 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 99 8C 08 00 20 03 04 00 84 8C }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "__atomic_pwritev64_replacement"
		size = 468
		refs = "0004 __gnu_local_gp 00d4 mempcpy 00fc __pwrite64 0108 free 014c __libc_errno 0198 __libc_alloca_cutoff 01ac malloc"
	strings:
		$1 = { B0 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 48 00 BE AF 21 F0 A0 03 38 00 B3 AF 30 00 B1 AF 4C 00 BF AF 44 00 B6 AF 40 00 B5 AF 3C 00 B4 AF 34 00 B2 AF 2C 00 B0 AF 18 00 DC AF 21 98 C0 00 54 00 C0 18 21 88 80 00 04 00 A2 8C 00 80 03 3C 2B 18 43 00 3C 00 60 10 FF 7F 04 3C 21 38 A0 00 21 18 00 00 21 80 00 00 ?? ?? ?? 0? FF FF 84 34 04 00 E2 8C 2B 40 02 01 33 00 00 15 00 00 00 00 21 80 02 02 01 00 63 24 08 00 E7 24 F8 FF 73 14 23 40 90 00 01 80 02 34 2B 10 02 02 3F 00 40 10 21 20 00 02 0E 00 02 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 18 00 B4 27 0B 00 60 1A 21 A8 00 00 21 90 A0 00 21 10 80 02 21 B0 00 00 00 00 45 8E 04 00 46 8E 21 20 40 00 ?? ?? ?? 0? 01 00 D6 26 FA FF D3 16 08 00 52 26 60 00 C8 8F 64 00 C9 8F 21 20 20 02 10 00 A8 AF 14 00 A9 AF 21 28 80 02 ?? ?? ?? 0? 21 30 00 02 21 20 A0 02 ?? ?? ?? 0? 20 00 C2 AF 21 E8 C0 03 4C 00 BF 8F 20 00 C2 8F 44 00 B6 8F 48 00 BE 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 50 00 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC 21 E8 C0 03 4C 00 BF 8F 48 00 BE 8F 44 00 B6 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F FF FF 02 24 08 00 E0 03 50 00 BD 27 ?? ?? ?? 0? 21 80 00 00 ?? ?? ?? 0? 20 00 C5 AF BF FF 40 14 20 00 C5 8F 21 20 00 02 ?? ?? ?? 0? 20 00 C5 AF 21 A0 40 00 03 00 40 10 20 00 C5 8F ?? ?? ?? 0? 21 A8 40 00 21 A8 00 00 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_5_1_0 {
	meta:
		name = "pwritev64"
		size = 392
		refs = "0004 __gnu_local_gp 008c __libc_errno 00cc __libc_enable_asynccancel 0130 __libc_disable_asynccancel"
	strings:
		$1 = { B8 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 40 00 BE AF 21 F0 A0 03 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF 44 00 BF AF 28 00 B0 AF 18 00 DC AF 21 A0 80 00 21 98 A0 00 21 90 C0 00 58 00 D5 8F 5C 00 D1 8F 3B E8 03 7C 70 8B 62 8C 1E 00 40 14 00 00 00 00 F0 FF BD 27 18 00 A2 27 24 00 C2 AF 21 38 A0 02 E0 FF BD 27 10 00 B1 AF EB 10 02 24 0C 00 00 00 20 00 BD 27 2F 00 E0 10 21 80 40 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 20 00 02 21 10 62 00 00 00 50 AC FF FF 10 24 59 00 03 24 27 00 83 14 21 10 00 02 10 00 B5 AF 14 00 B1 AF 21 20 80 02 21 28 60 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 21 E8 C0 03 ?? ?? ?? 0? 00 00 00 00 F0 FF BD 27 18 00 A3 27 18 00 DC 8F 21 F8 40 00 20 00 C3 AF 21 20 80 02 21 28 60 02 21 30 40 02 21 38 A0 02 E0 FF BD 27 10 00 B1 AF EB 10 02 24 0C 00 00 00 20 00 BD 27 07 00 E0 10 21 80 40 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 50 AC FF FF 10 24 21 20 E0 03 ?? ?? ?? 0? 00 00 00 00 18 00 DC 8F 0C 00 00 06 21 10 00 02 21 E8 C0 03 44 00 BF 8F 40 00 BE 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 48 00 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 ?? ?? ?? 0? 00 00 44 8C }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "decode_name"
		size = 252
	strings:
		$1 = { 21 10 80 00 01 00 85 24 21 18 80 00 5C 00 07 24 30 00 04 24 31 00 09 24 33 00 0B 24 34 00 0A 24 32 00 0C 24 0A 00 0F 24 09 00 0E 24 20 00 0D 24 00 00 66 80 08 00 C7 10 00 00 00 00 FF FF A6 A0 00 00 66 80 01 00 A5 24 F9 FF C0 14 01 00 63 24 08 00 E0 03 00 00 00 00 01 00 68 80 0E 00 04 11 00 00 00 00 19 00 07 11 00 00 00 00 F3 FF 09 15 00 00 00 00 02 00 68 80 F0 FF 0B 15 00 00 00 00 03 00 68 80 ED FF 0A 15 00 00 00 00 FF FF A7 A0 ?? ?? ?? 0? 03 00 63 24 02 00 68 80 0E 00 0A 11 00 00 00 00 E5 FF 09 15 00 00 00 00 03 00 68 80 0F 00 09 11 00 00 00 00 E0 FF 0C 15 00 00 00 00 FF FF AF A0 ?? ?? ?? 0? 03 00 63 24 FF FF A7 A0 ?? ?? ?? 0? 01 00 63 24 03 00 68 80 D7 FF 04 15 00 00 00 00 FF FF AD A0 ?? ?? ?? 0? 03 00 63 24 FF FF AE A0 ?? ?? ?? 0? 03 00 63 24 }
	condition:
		$1
}

rule file_6_1_0 {
	meta:
		name = "__setmntent"
		size = 156
		refs = "0020 strlen 0044 mempcpy 0064 _IO_new_fopen"
	strings:
		$1 = { D0 FF BD 27 28 00 BE AF 24 00 B1 AF 21 F0 A0 03 21 88 80 00 21 20 A0 00 2C 00 BF AF 20 00 B0 AF ?? ?? ?? 0? 18 00 C5 AF 0A 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 C5 8F 10 00 B0 27 21 20 00 02 ?? ?? ?? 0? 21 30 40 00 63 00 03 24 00 00 43 A0 65 00 03 24 01 00 43 A0 02 00 40 A0 21 20 20 02 ?? ?? ?? 0? 21 28 00 02 04 00 40 10 00 00 00 00 00 00 43 8C 00 80 63 34 00 00 43 AC 21 E8 C0 03 2C 00 DF 8F 28 00 BE 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_6_2_0 {
	meta:
		name = "__endmntent"
		size = 48
		refs = "0010 _IO_new_fclose"
	strings:
		$1 = { 09 00 80 10 00 00 00 00 E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 1C 00 BF 8F 01 00 02 24 08 00 E0 03 20 00 BD 27 08 00 E0 03 01 00 02 24 }
	condition:
		$1
}

rule file_6_3_0 {
	meta:
		name = "__getmntent_r"
		size = 944
		refs = "0048 fgets_unlocked 0058 strchr 0114 $LC1 0360 $LC0 0370 sscanf"
	strings:
		$1 = { C8 FB BD 27 30 04 B6 AF 2C 04 B5 AF 28 04 B4 AF 24 04 B3 AF 20 04 B2 AF 1C 04 B1 AF 18 04 B0 AF 34 04 BF AF 21 90 80 00 21 A8 A0 00 21 88 C0 00 21 98 E0 00 20 00 10 24 09 00 16 24 23 00 14 24 21 20 20 02 21 28 60 02 ?? ?? ?? 0? 21 30 40 02 42 00 40 10 21 20 20 02 ?? ?? ?? 0? 0A 00 05 24 0E 00 40 10 18 00 A4 27 00 00 40 A0 21 10 20 02 00 00 43 80 03 00 70 10 21 40 40 00 0F 00 76 14 00 00 00 00 ?? ?? ?? 0? 01 00 42 24 ?? ?? ?? 0? 00 00 00 00 F5 FF 40 14 18 00 A4 27 00 04 05 24 ?? ?? ?? 0? 21 30 40 02 18 00 A4 27 F7 FF 40 14 0A 00 05 24 ?? ?? ?? 0? 21 10 20 02 E1 FF 60 10 21 20 20 02 E0 FF 74 10 21 28 60 02 20 00 04 24 2D 00 64 10 09 00 04 24 2B 00 64 10 20 00 05 24 ?? ?? ?? 0? 01 00 08 25 27 00 65 10 00 00 00 00 25 00 64 10 00 00 00 00 01 00 08 25 00 00 03 81 F9 FF 60 14 00 00 00 00 ?? ?? ?? 0? 21 20 40 00 00 00 A2 AE ?? ?? 02 3C ?? ?? 42 24 04 00 A2 AE 08 00 A2 AE 0C 00 A2 AE 10 00 A0 AE 34 04 BF 8F 14 00 A0 AE 21 10 A0 02 30 04 B6 8F 2C 04 B5 8F 28 04 B4 8F 24 04 B3 8F 20 04 B2 8F 1C 04 B1 8F 18 04 B0 8F 08 00 E0 03 38 04 BD 27 34 04 BF 8F 30 04 B6 8F 2C 04 B5 8F 28 04 B4 8F 24 04 B3 8F 20 04 B2 8F 1C 04 B1 8F 18 04 B0 8F 21 10 00 00 08 00 E0 03 38 04 BD 27 00 00 00 A1 21 20 40 00 ?? ?? ?? 0? 01 00 18 25 DE FF 00 13 00 00 A2 AE 21 20 00 03 20 00 05 24 09 00 06 24 00 00 83 80 03 00 65 10 21 10 80 00 03 00 66 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 0F 00 60 10 20 00 05 24 14 00 65 10 09 00 05 24 12 00 65 10 20 00 06 24 ?? ?? ?? 0? 01 00 42 24 0E 00 66 10 00 00 00 00 0C 00 65 10 00 00 00 00 01 00 42 24 00 00 43 80 F9 FF 60 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 04 00 A2 AE ?? ?? 02 3C ?? ?? 42 24 ?? ?? ?? 0? 08 00 A2 AE 00 00 40 A0 ?? ?? ?? 0? 01 00 58 24 21 20 00 03 04 00 A2 AE 20 00 05 24 F5 FF 00 13 09 00 06 24 00 00 83 80 03 00 65 10 21 10 80 00 03 00 66 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 0F 00 60 10 20 00 05 24 14 00 65 10 09 00 05 24 12 00 65 10 20 00 06 24 ?? ?? ?? 0? 01 00 42 24 0E 00 66 10 00 00 00 00 0C 00 65 10 00 00 00 00 01 00 42 24 00 00 43 80 F9 FF 60 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 A2 AE ?? ?? 02 3C ?? ?? 42 24 ?? ?? ?? 0? 0C 00 A2 AE 00 00 40 A0 ?? ?? ?? 0? 01 00 58 24 21 20 00 03 08 00 A2 AE 20 00 05 24 F5 FF 00 13 09 00 06 24 00 00 83 80 03 00 65 10 21 10 80 00 03 00 66 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 0F 00 60 10 20 00 05 24 12 00 65 10 09 00 05 24 10 00 65 10 20 00 06 24 ?? ?? ?? 0? 01 00 42 24 0C 00 66 10 00 00 00 00 0A 00 65 10 00 00 00 00 01 00 42 24 00 00 43 80 F9 FF 60 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 0C 00 A2 AE ?? ?? ?? 0? 10 00 A0 AE 00 00 40 A0 ?? ?? ?? 0? 01 00 58 24 73 FF 00 13 0C 00 A2 AE ?? ?? 05 3C 21 20 00 03 ?? ?? A5 24 10 00 A6 26 ?? ?? ?? 0? 14 00 A7 26 6B FF 40 10 01 00 03 24 6B FF 43 10 34 04 BF 8F 21 10 A0 02 30 04 B6 8F 2C 04 B5 8F 28 04 B4 8F 24 04 B3 8F 20 04 B2 8F 1C 04 B1 8F 18 04 B0 8F 08 00 E0 03 38 04 BD 27 }
	condition:
		$1
}

rule file_6_4_0 {
	meta:
		name = "__addmntent"
		size = 1632
		refs = "0058 fseek 0224 $LC2 0244 fprintf 0254 fflush 02cc strlen"
	strings:
		$1 = { A8 FF BD 27 21 10 A0 00 4C 00 B7 AF 44 00 B5 AF 40 00 B4 AF 34 00 B1 AF 30 00 B0 AF 00 00 54 8C 04 00 57 8C 08 00 51 8C 0C 00 50 8C 10 00 55 8C 14 00 42 8C 50 00 BE AF 02 00 06 24 21 F0 A0 03 21 28 00 00 38 00 B2 AF 54 00 BF AF 48 00 B6 AF 3C 00 B3 AF 21 90 80 00 ?? ?? ?? 0? 28 00 C2 AF 8C 00 40 14 00 00 00 00 00 00 96 82 19 00 C0 12 00 00 00 00 20 00 02 24 94 00 C2 12 F7 FF C2 26 FF 00 42 30 02 00 42 2C 90 00 40 14 5C 00 02 24 8E 00 C2 12 21 18 80 02 20 00 06 24 ?? ?? ?? 0? 5C 00 07 24 89 00 46 10 00 00 00 00 87 00 A0 14 00 00 00 00 85 00 47 10 00 00 00 00 01 00 63 24 00 00 62 80 F7 FF 45 24 FF 00 A5 30 F5 FF 40 14 02 00 A5 2C 21 98 80 02 00 00 E7 82 19 00 E0 10 00 00 00 00 20 00 02 24 A1 00 E2 10 F7 FF E2 24 FF 00 42 30 02 00 42 2C 9D 00 40 14 5C 00 02 24 9B 00 E2 10 21 18 E0 02 20 00 05 24 ?? ?? ?? 0? 5C 00 06 24 96 00 45 10 00 00 00 00 94 00 80 14 00 00 00 00 92 00 46 10 00 00 00 00 01 00 63 24 00 00 62 80 F7 FF 44 24 FF 00 84 30 F5 FF 40 14 02 00 84 2C 21 B0 E0 02 00 00 27 82 18 00 E0 10 20 00 02 24 B0 00 E2 10 F7 FF E2 24 FF 00 42 30 02 00 42 2C AC 00 40 14 5C 00 02 24 AA 00 E2 10 01 00 23 26 20 00 05 24 ?? ?? ?? 0? 5C 00 06 24 A5 00 45 10 00 00 00 00 A3 00 80 14 00 00 00 00 A1 00 46 10 00 00 00 00 00 00 62 80 01 00 63 24 F7 FF 44 24 FF 00 84 30 F5 FF 40 14 02 00 84 2C 21 B8 20 02 00 00 11 82 18 00 20 12 20 00 02 24 BF 00 22 12 F7 FF 22 26 FF 00 42 30 02 00 42 2C BB 00 40 14 5C 00 02 24 B9 00 22 12 01 00 03 26 20 00 05 24 ?? ?? ?? 0? 5C 00 06 24 B4 00 45 10 00 00 00 00 B2 00 80 14 00 00 00 00 B0 00 46 10 00 00 00 00 00 00 62 80 01 00 63 24 F7 FF 44 24 FF 00 84 30 F5 FF 40 14 02 00 84 2C 21 40 00 02 28 00 C2 8F ?? ?? 05 3C 10 00 B7 AF 14 00 A8 AF 18 00 B5 AF 1C 00 A2 AF 21 20 40 02 ?? ?? A5 24 21 30 60 02 ?? ?? ?? 0? 21 38 C0 02 11 00 40 04 00 00 00 00 ?? ?? ?? 0? 21 20 40 02 21 E8 C0 03 54 00 BF 8F 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 2B 10 02 00 08 00 E0 03 58 00 BD 27 21 E8 C0 03 54 00 DF 8F 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 01 00 02 24 08 00 E0 03 58 00 BD 27 ?? ?? ?? 0? 21 20 80 02 80 10 02 00 0F 00 42 24 C2 10 02 00 C0 10 02 00 23 E8 A2 03 20 00 B3 27 21 18 C0 02 20 00 05 24 21 20 80 02 21 10 60 02 09 00 07 24 0A 00 0B 24 5C 00 09 24 5C 00 08 24 30 00 06 24 31 00 0A 24 32 00 0D 24 0F 00 65 10 34 00 0C 24 A1 00 67 10 00 00 00 00 AB 00 6B 10 00 00 00 00 C7 00 69 10 00 00 00 00 00 00 43 A0 01 00 42 24 00 00 83 80 64 FF 60 10 00 00 00 00 01 00 83 80 F3 FF 65 14 01 00 84 24 00 00 48 A0 01 00 46 A0 02 00 4C A0 03 00 46 A0 ?? ?? ?? 0? 04 00 42 24 21 20 E0 02 ?? ?? ?? 0? 2C 00 C7 AF 80 10 02 00 0F 00 42 24 2C 00 C7 8F C2 10 02 00 C0 10 02 00 23 E8 A2 03 20 00 B6 27 21 18 E0 00 20 00 04 24 21 10 C0 02 09 00 06 24 0A 00 0A 24 5C 00 08 24 5C 00 07 24 30 00 05 24 31 00 09 24 32 00 0C 24 0F 00 64 10 34 00 0B 24 71 00 66 10 00 00 00 00 7B 00 6A 10 00 00 00 00 99 00 68 10 00 00 00 00 00 00 43 A0 01 00 42 24 00 00 E3 82 56 FF 60 10 00 00 00 00 01 00 E3 82 F3 FF 64 14 01 00 F7 26 00 00 47 A0 01 00 45 A0 02 00 4B A0 03 00 45 A0 ?? ?? ?? 0? 04 00 42 24 21 20 20 02 ?? ?? ?? 0? 2C 00 C7 AF 80 10 02 00 0F 00 42 24 2C 00 C7 8F C2 10 02 00 C0 10 02 00 23 E8 A2 03 20 00 B7 27 21 18 E0 00 20 00 04 24 21 10 E0 02 09 00 06 24 0A 00 0A 24 5C 00 08 24 5C 00 07 24 30 00 05 24 31 00 09 24 32 00 0C 24 0F 00 64 10 34 00 0B 24 3B 00 66 10 00 00 00 00 63 00 6A 10 00 00 00 00 6B 00 68 10 00 00 00 00 00 00 43 A0 01 00 42 24 00 00 23 82 47 FF 60 10 00 00 00 00 01 00 23 82 F3 FF 64 14 01 00 31 26 00 00 47 A0 01 00 45 A0 02 00 4B A0 03 00 45 A0 ?? ?? ?? 0? 04 00 42 24 ?? ?? ?? 0? 21 20 00 02 80 10 02 00 0F 00 42 24 C2 10 02 00 C0 10 02 00 23 E8 A2 03 20 00 A8 27 21 18 20 02 20 00 04 24 21 10 00 01 09 00 06 24 0A 00 0B 24 5C 00 09 24 5C 00 07 24 30 00 05 24 31 00 0A 24 32 00 0D 24 0F 00 64 10 34 00 0C 24 19 00 66 10 00 00 00 00 35 00 6B 10 00 00 00 00 3F 00 69 10 00 00 00 00 00 00 43 A0 01 00 42 24 00 00 03 82 3A FF 60 10 00 00 00 00 01 00 03 82 F3 FF 64 14 01 00 10 26 00 00 47 A0 01 00 45 A0 02 00 4C A0 03 00 45 A0 ?? ?? ?? 0? 04 00 42 24 00 00 47 A0 01 00 45 A0 02 00 49 A0 03 00 49 A0 ?? ?? ?? 0? 04 00 42 24 00 00 47 A0 01 00 45 A0 02 00 4A A0 03 00 4A A0 ?? ?? ?? 0? 04 00 42 24 00 00 47 A0 01 00 45 A0 02 00 49 A0 03 00 49 A0 ?? ?? ?? 0? 04 00 42 24 00 00 48 A0 01 00 46 A0 02 00 4A A0 03 00 4A A0 ?? ?? ?? 0? 04 00 42 24 00 00 47 A0 01 00 45 A0 02 00 49 A0 03 00 4C A0 ?? ?? ?? 0? 04 00 42 24 00 00 48 A0 01 00 46 A0 02 00 4A A0 03 00 4D A0 ?? ?? ?? 0? 04 00 42 24 00 00 47 A0 01 00 45 A0 02 00 4A A0 03 00 4D A0 ?? ?? ?? 0? 04 00 42 24 00 00 47 A0 01 00 45 A0 02 00 49 A0 03 00 4C A0 ?? ?? ?? 0? 04 00 42 24 00 00 49 A0 01 00 49 A0 ?? ?? ?? 0? 02 00 42 24 00 00 48 A0 01 00 48 A0 ?? ?? ?? 0? 02 00 42 24 00 00 48 A0 01 00 48 A0 ?? ?? ?? 0? 02 00 42 24 00 00 49 A0 01 00 49 A0 ?? ?? ?? 0? 02 00 42 24 }
	condition:
		$1
}

rule file_6_5_0 {
	meta:
		name = "__hasmntopt"
		size = 220
		refs = "0024 strlen 0040 strchr 0054 strstr"
	strings:
		$1 = { D0 FF BD 27 18 00 B0 AF 21 80 80 00 21 20 A0 00 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 2C 00 BF AF ?? ?? ?? 0? 21 90 A0 00 21 98 40 00 0C 00 10 8E 3D 00 14 24 ?? ?? ?? 0? 2C 00 11 24 ?? ?? ?? 0? 00 00 00 00 1B 00 40 10 01 00 50 24 21 20 00 02 ?? ?? ?? 0? 21 28 40 02 21 20 40 00 0D 00 40 10 2C 00 05 24 04 00 50 10 21 18 53 00 FF FF 43 80 F2 FF 71 14 21 18 53 00 00 00 63 80 06 00 60 10 2C 00 BF 8F 04 00 74 10 00 00 00 00 EB FF 71 14 00 00 00 00 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 21 10 00 00 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "__setitimer"
		size = 28
	strings:
		$1 = { 08 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "__isoc99_vwscanf"
		size = 500
		refs = "0008 stdin 007c __lll_lock_wait_private 00b8 _IO_vfwscanf 01a0 _Unwind_Resume"
	strings:
		$1 = { C8 FF BD 27 24 00 B1 AF ?? ?? 11 3C 20 00 B0 AF ?? ?? 30 8E 2C 00 B3 AF 28 00 B2 AF 00 00 02 8E 34 00 BF AF 30 00 B4 AF 00 80 42 30 21 98 80 00 39 00 40 14 21 90 A0 00 3B E8 03 7C 48 00 04 8E 70 8B 74 24 08 00 83 8C 12 00 74 10 21 38 00 02 18 00 A0 AF 00 00 85 C0 06 00 A0 14 00 00 03 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 03 24 0F 00 00 00 03 00 60 14 00 00 00 00 ?? ?? ?? 0? 18 00 A5 AF 48 00 03 8E ?? ?? 27 8E 21 20 60 00 08 00 74 AC 04 00 83 8C 01 00 63 24 04 00 83 AC 3C 00 E2 8C 21 20 E0 00 21 28 60 02 10 00 42 34 3C 00 E2 AC 21 30 40 02 ?? ?? ?? 0? 21 38 00 00 3C 00 05 8E 00 00 03 8E EB FF 04 24 24 20 A4 00 00 80 63 30 21 88 40 00 06 00 60 14 3C 00 04 AE 48 00 04 8E 04 00 82 8C FF FF 42 24 0C 00 40 10 04 00 82 AC 34 00 BF 8F 21 10 20 02 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? 21 38 00 02 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 EC FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F 3C 00 05 8E 00 00 02 8E EB FF 03 24 24 18 A3 00 00 80 42 30 21 88 80 00 06 00 40 14 3C 00 03 AE 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_1159_0_0 {
	meta:
		name = "__isoc99_vscanf"
		size = 500
		refs = "0008 stdin 007c __lll_lock_wait_private 00b8 _IO_vfscanf 01a0 _Unwind_Resume"
	strings:
		$1 = { C8 FF BD 27 24 00 B1 AF ?? ?? 11 3C 20 00 B0 AF ?? ?? 30 8E 2C 00 B3 AF 28 00 B2 AF 00 00 02 8E 34 00 BF AF 30 00 B4 AF 00 80 42 30 21 98 80 00 39 00 40 14 21 90 A0 00 3B E8 03 7C 48 00 04 8E 70 8B 74 24 08 00 83 8C 12 00 74 10 21 38 00 02 18 00 A0 AF 00 00 85 C0 06 00 A0 14 00 00 03 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 03 24 0F 00 00 00 03 00 60 14 00 00 00 00 ?? ?? ?? 0? 18 00 A5 AF 48 00 03 8E ?? ?? 27 8E 21 20 60 00 08 00 74 AC 04 00 83 8C 01 00 63 24 04 00 83 AC 3C 00 E2 8C 21 20 E0 00 21 28 60 02 10 00 42 34 3C 00 E2 AC 21 30 40 02 ?? ?? ?? 0? 21 38 00 00 3C 00 05 8E 00 00 03 8E EB FF 04 24 24 20 A4 00 00 80 63 30 21 88 40 00 06 00 60 14 3C 00 04 AE 48 00 04 8E 04 00 82 8C FF FF 42 24 0C 00 40 10 04 00 82 AC 34 00 BF 8F 21 10 20 02 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? 21 38 00 02 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 EC FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F 3C 00 05 8E 00 00 02 8E EB FF 03 24 24 18 A3 00 00 80 42 30 21 88 80 00 06 00 40 14 3C 00 03 AE 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "allocate"
		size = 36
		refs = "0008 malloc"
	strings:
		$1 = { E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 04 04 24 1C 00 BF 8F ?? ?? 03 3C ?? ?? 62 AC 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_9_1_0 {
	meta:
		name = "getnetgrent"
		size = 236
		refs = "0000 __gnu_local_gp 0004 __pthread_once 0070 __getnetgrent_r 009c __libc_errno 00cc malloc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 02 3C C8 FF BD 27 ?? ?? 9C 27 ?? ?? 42 24 2C 00 B2 AF 28 00 B1 AF 24 00 B0 AF 34 00 BF AF 30 00 B3 AF 18 00 BC AF 21 88 80 00 21 80 A0 00 1F 00 40 10 21 90 C0 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? ?? 0? ?? ?? A5 24 18 00 BC 8F ?? ?? 03 3C ?? ?? 67 8C 0D 00 E0 10 21 20 20 02 00 04 02 24 10 00 A2 AF 21 28 00 02 ?? ?? ?? 0? 21 30 40 02 34 00 BF 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 0C 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 ?? ?? 13 3C ?? ?? 62 8E 03 00 40 10 00 00 00 00 ?? ?? ?? 0? ?? ?? 03 3C ?? ?? ?? 0? 00 04 04 24 ?? ?? 03 3C ?? ?? 62 AC 02 00 02 24 18 00 BC 8F ?? ?? ?? 0? ?? ?? 62 AE }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "putwc"
		size = 464
		refs = "006c __lll_lock_wait_private 0148 __woverflow 017c _Unwind_Resume"
	strings:
		$1 = { 00 00 A2 8C D0 FF BD 27 28 00 B2 AF 00 80 42 30 20 00 B0 AF 2C 00 BF AF 24 00 B1 AF 21 80 A0 00 1A 00 40 14 21 90 80 00 3B E8 03 7C 48 00 A4 8C 70 8B 71 24 08 00 83 8C 11 00 71 10 00 00 00 00 18 00 A0 AF 00 00 85 C0 06 00 A0 14 00 00 03 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 03 24 0F 00 00 00 03 00 60 14 00 00 00 00 ?? ?? ?? 0? 18 00 A5 AF 48 00 03 8E 21 20 60 00 08 00 71 AC 04 00 83 8C 01 00 63 24 04 00 83 AC 5C 00 02 8E 2D 00 40 10 21 20 00 02 10 00 43 8C 14 00 44 8C 2B 20 64 00 27 00 80 10 04 00 64 24 10 00 44 AC 21 88 40 02 00 00 72 AC 00 00 02 8E 00 80 42 30 07 00 40 14 2C 00 BF 8F 48 00 04 8E 04 00 82 8C FF FF 42 24 08 00 40 10 04 00 82 AC 2C 00 BF 8F 21 10 20 02 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 F0 FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 2C 00 BF 8F 21 20 00 02 ?? ?? ?? 0? 21 28 40 02 ?? ?? ?? 0? 21 88 40 00 00 00 02 8E 00 80 42 30 06 00 40 14 21 88 80 00 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "parse_printf_format"
		size = 348
		refs = "002c __strchrnul 0078 __parse_one_specmb 0050 __printf_arginfo_table"
	strings:
		$1 = { 90 FF BD 27 58 00 B1 AF 21 88 A0 00 25 00 05 24 60 00 B3 AF 6C 00 BF AF 68 00 B5 AF 64 00 B4 AF 5C 00 B2 AF 54 00 B0 AF 21 98 C0 00 ?? ?? ?? 0? 4C 00 A0 AF 21 20 40 00 00 00 42 90 45 00 40 10 21 80 00 00 FF FF 12 24 01 00 14 24 ?? ?? ?? 0? ?? ?? 15 3C 80 28 05 00 21 28 65 02 00 00 A2 AC 30 00 A4 8F 00 00 82 90 2F 00 40 10 4C 00 A2 8F 21 28 00 02 18 00 A6 27 ?? ?? ?? 0? 4C 00 A7 27 38 00 A3 8F 07 00 72 10 21 80 02 02 2B 10 71 00 05 00 40 10 34 00 A2 8F 80 18 03 00 21 18 63 02 00 00 60 AC 34 00 A2 8F 06 00 52 10 2B 18 51 00 05 00 60 10 3C 00 A5 8F 80 10 02 00 21 10 62 02 00 00 40 AC 3C 00 A5 8F 2B 10 B1 00 E5 FF 40 10 30 00 A4 8F 44 00 A2 8F E2 FF 40 10 00 00 00 00 DC FF 54 10 40 00 A2 8F 20 00 A2 8F ?? ?? A3 8E 80 30 05 00 80 10 02 00 21 10 62 00 00 00 59 8C 18 00 A4 27 23 28 25 02 21 30 66 02 09 F8 20 03 48 00 A7 27 30 00 A4 8F 00 00 82 90 D5 FF 40 14 21 28 00 02 4C 00 A2 8F 2B 18 02 02 0A 10 03 02 6C 00 BF 8F 68 00 B5 8F 64 00 B4 8F 60 00 B3 8F 5C 00 B2 8F 58 00 B1 8F 54 00 B0 8F 08 00 E0 03 70 00 BD 27 ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "getwchar_unlocked"
		size = 64
		refs = "0000 _IO_stdin 0038 __wuflow"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 44 8C 5C 00 82 8C 0A 00 40 10 00 00 00 00 00 00 43 8C 04 00 45 8C 2B 28 65 00 05 00 A0 10 00 00 00 00 04 00 64 24 00 00 44 AC 08 00 E0 03 00 00 62 8C ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "rename"
		size = 28
	strings:
		$1 = { C6 0F 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "posix_spawn_file_actions_destroy"
		size = 36
		refs = "000c free"
	strings:
		$1 = { 08 00 84 8C E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 1C 00 BF 8F 21 10 00 00 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "__mmap"
		size = 28
	strings:
		$1 = { FA 0F 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "__nl_langinfo_l"
		size = 112
		refs = "0050 $LC0"
	strings:
		$1 = { 03 14 04 00 06 00 03 24 11 00 43 10 0D 00 43 2C 0F 00 60 10 FF FF 84 30 FF FF 03 34 0F 00 83 10 00 00 00 00 80 10 02 00 21 28 A2 00 00 00 A2 8C 20 00 43 8C 2B 18 83 00 05 00 60 10 08 00 84 24 80 20 04 00 21 10 44 00 08 00 E0 03 04 00 42 8C ?? ?? 02 3C 08 00 E0 03 ?? ?? 42 24 10 00 42 24 80 10 02 00 21 28 A2 00 08 00 E0 03 00 00 A2 8C }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "strerror_l"
		size = 308
		refs = "001c _sys_nerr_internal 002c _sys_errlist_internal 0048 __uselocale 0060 __dcgettext 0050 _libc_intl_domainname 0094 last_value 00a0 free 00b4 $LC0 00dc $LC1 00ec __asprintf"
	strings:
		$1 = { D0 FF BD 27 20 00 B0 AF 2C 00 BF AF 28 00 B2 AF 24 00 B1 AF 1E 00 80 04 21 80 80 00 ?? ?? 02 3C ?? ?? 42 8C 2A 10 82 00 19 00 40 10 ?? ?? 02 3C 80 18 04 00 ?? ?? 42 24 21 10 62 00 00 00 51 8C 13 00 20 12 00 00 00 00 ?? ?? ?? 0? 21 20 A0 00 ?? ?? 04 3C 21 28 20 02 05 00 06 24 21 80 40 00 ?? ?? ?? 0? ?? ?? 84 24 21 20 00 02 ?? ?? ?? 0? 21 88 40 00 2C 00 BF 8F 21 10 20 02 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 3B E8 03 7C ?? ?? 11 3C 21 88 23 02 ?? ?? 24 8E ?? ?? ?? 0? 18 00 A5 AF 18 00 A5 8F ?? ?? ?? 0? 21 20 A0 00 ?? ?? 05 3C ?? ?? 04 3C ?? ?? A5 24 05 00 06 24 21 90 40 00 ?? ?? ?? 0? ?? ?? 84 24 21 20 40 02 ?? ?? ?? 0? 21 90 40 00 ?? ?? 05 3C ?? ?? 24 26 ?? ?? A5 24 21 30 40 02 ?? ?? ?? 0? 21 38 00 02 FF FF 03 24 07 00 43 10 2C 00 BF 8F ?? ?? 22 8E 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? 20 AE 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 21 10 00 00 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_17_1_0 {
	meta:
		name = "strerror_thread_freeres"
		size = 24
		refs = "0008 last_value 0010 free"
	strings:
		$1 = { 3B E8 03 7C 21 10 60 00 ?? ?? 03 3C 21 10 62 00 ?? ?? ?? 0? ?? ?? 44 8C }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "__scanf"
		size = 68
		refs = "0000 stdin 0030 _IO_vfscanf"
	strings:
		$1 = { ?? ?? 02 3C D8 FF BD 27 21 18 80 00 ?? ?? 44 8C 2C 00 A2 27 2C 00 A5 AF 30 00 A6 AF 34 00 A7 AF 21 28 60 00 21 30 40 00 21 38 00 00 24 00 BF AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_929_0_0 {
	meta:
		name = "__wscanf"
		size = 68
		refs = "0000 stdin 0030 _IO_vfwscanf"
	strings:
		$1 = { ?? ?? 02 3C D8 FF BD 27 21 18 80 00 ?? ?? 44 8C 2C 00 A2 27 2C 00 A5 AF 30 00 A6 AF 34 00 A7 AF 21 28 60 00 21 30 40 00 21 38 00 00 24 00 BF AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "fstatvfs"
		size = 124
		refs = "001c __fstatfs 0034 __fxstat64 0050 __internal_statvfs"
	strings:
		$1 = { F0 FE BD 27 04 01 B1 AF 21 88 A0 00 B8 00 A5 27 08 01 B2 AF 0C 01 BF AF 00 01 B0 AF ?? ?? ?? 0? 21 90 80 00 13 00 40 04 18 00 B0 27 03 00 04 24 21 28 40 02 ?? ?? ?? 0? 21 30 00 02 27 10 02 00 21 38 00 00 0B 38 02 02 21 20 00 00 21 28 20 02 ?? ?? ?? 0? B8 00 A6 27 21 10 00 00 0C 01 BF 8F 08 01 B2 8F 04 01 B1 8F 00 01 B0 8F 08 00 E0 03 10 01 BD 27 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "syscall"
		size = 28
	strings:
		$1 = { A0 0F 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "__strverscmp"
		size = 300
	strings:
		$1 = { 33 00 85 10 00 00 00 00 00 00 82 90 00 00 A3 90 01 00 84 24 30 00 48 38 D0 FF 47 24 01 00 08 2D 0A 00 E7 2C 23 30 43 00 01 00 A5 24 15 00 C0 14 21 38 07 01 26 00 40 10 ?? ?? 09 3C ?? ?? ?? 0? ?? ?? 29 25 22 00 40 10 00 00 00 00 01 00 84 24 FF FF 82 90 01 00 A5 24 21 38 27 01 FF FF A3 90 00 00 E8 90 D0 FF 46 24 30 00 47 38 0A 00 C6 2C 01 00 E7 2C 21 38 E6 00 23 30 43 00 F1 FF C0 10 21 38 E8 00 30 00 62 38 D0 FF 63 24 0A 00 63 2C 01 00 42 2C 40 40 07 00 21 10 43 00 21 38 07 01 21 38 E2 00 ?? ?? 02 3C ?? ?? 42 24 21 10 E2 00 00 00 42 80 02 00 03 24 18 00 43 10 03 00 03 24 0A 00 43 10 01 00 84 24 08 00 E0 03 00 00 00 00 08 00 E0 03 21 10 00 00 FF FF A2 90 D0 FF 42 24 0A 00 42 2C 0F 00 40 10 01 00 84 24 FF FF 82 90 D0 FF 42 24 0A 00 42 2C F7 FF 40 14 01 00 A5 24 FF FF A5 24 00 00 A3 90 FF FF 02 24 D0 FF 63 24 0A 00 63 2C 08 00 E0 03 0A 10 C3 00 08 00 E0 03 21 10 C0 00 08 00 E0 03 01 00 02 24 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "getnetent"
		size = 296
		refs = "0004 __gnu_local_gp 004c __libc_h_errno 0064 __getnetent_r 0084 __nss_getent 0098 __libc_errno 00f4 __lll_lock_wait_private"
	strings:
		$1 = { C8 FF BD 27 ?? ?? 1C 3C 24 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 2B 00 40 14 00 00 00 00 ?? ?? 82 8F 3B E8 03 7C 21 90 60 00 21 10 43 00 ?? ?? 03 3C ?? ?? 63 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C 10 00 A3 AF 14 00 A2 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? 00 04 07 24 18 00 BC 8F 21 98 40 00 ?? ?? 03 26 ?? ?? 91 8F 21 90 32 02 00 00 52 8E 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 10 00 40 10 ?? ?? 04 26 34 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 32 AE 21 10 60 02 2C 00 B2 8F 30 00 B3 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? 18 00 BC 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F }
	condition:
		$1
}

rule file_311_0_0 {
	meta:
		name = "gethostent"
		size = 296
		refs = "0004 __gnu_local_gp 004c __libc_h_errno 0064 __gethostent_r 0084 __nss_getent 0098 __libc_errno 00f4 __lll_lock_wait_private"
	strings:
		$1 = { C8 FF BD 27 ?? ?? 1C 3C 24 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 2B 00 40 14 00 00 00 00 ?? ?? 82 8F 3B E8 03 7C 21 90 60 00 21 10 43 00 ?? ?? 03 3C ?? ?? 63 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C 10 00 A3 AF 14 00 A2 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? 00 04 07 24 18 00 BC 8F 21 98 40 00 ?? ?? 03 26 ?? ?? 91 8F 21 90 32 02 00 00 52 8E 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 10 00 40 10 ?? ?? 04 26 34 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 32 AE 21 10 60 02 2C 00 B2 8F 30 00 B3 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? 18 00 BC 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "__dup2"
		size = 28
	strings:
		$1 = { DF 0F 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "__wctrans"
		size = 212
		refs = "0000 __gnu_local_gp 0010 _nl_current_LC_CTYPE 0054 __rawmemchr 006c strcmp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D0 FF BD 27 28 00 B3 AF 21 10 62 00 00 00 42 8C 2C 00 BF AF 24 00 B2 AF 00 00 53 8C 20 00 B1 AF 1C 00 B0 AF 10 00 BC AF 50 00 70 8E 00 00 02 82 1B 00 40 10 21 90 80 00 ?? ?? ?? 0? 21 88 00 00 ?? ?? ?? 0? 01 00 31 26 01 00 43 80 14 00 60 10 01 00 50 24 21 28 00 02 ?? ?? ?? 0? 21 20 40 02 21 20 00 02 F6 FF 40 14 21 28 00 00 6C 00 62 8E 2C 00 BF 8F 24 00 B2 8F 21 10 22 02 08 00 42 24 80 10 02 00 21 98 62 02 04 00 62 8E 20 00 B1 8F 28 00 B3 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 21 10 00 00 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "critical_factorization"
		size = 428
		refs = "0000 __gnu_local_gp 0008 __libc_tsd_CTYPE_TOLOWER"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 ?? ?? 8D 8F 3B E8 03 7C 01 00 0E 24 21 10 A3 01 00 00 4B 8C 01 00 07 24 21 40 00 00 FF FF 02 24 21 18 82 00 21 60 67 00 21 18 E8 00 2B 48 65 00 15 00 20 11 21 50 83 00 00 00 89 91 00 00 4A 91 80 48 09 00 80 50 0A 00 21 50 6A 01 21 48 69 01 00 00 4A 91 00 00 29 91 2B 60 49 01 35 00 80 11 00 00 00 00 21 40 60 00 01 00 07 24 23 70 62 00 21 18 82 00 21 60 67 00 21 18 E8 00 2B 48 65 00 ED FF 20 15 21 50 83 00 3B E8 03 7C 21 68 A3 01 00 00 AC 8D 00 00 CE AC 01 00 07 24 01 00 0E 24 21 40 00 00 FF FF 0B 24 21 18 8B 00 21 68 67 00 21 18 E8 00 2B 48 65 00 15 00 20 11 21 50 83 00 00 00 A9 91 00 00 4A 91 80 48 09 00 80 50 0A 00 21 50 8A 01 21 48 89 01 00 00 4A 91 00 00 29 91 2B 68 2A 01 1A 00 A0 11 00 00 00 00 21 40 60 00 01 00 07 24 23 70 6B 00 21 18 8B 00 21 68 67 00 21 18 E8 00 2B 48 65 00 ED FF 20 15 21 50 83 00 01 00 42 24 01 00 6B 25 2B 18 62 01 03 00 60 14 00 00 00 00 00 00 CE AC 21 10 60 01 08 00 E0 03 00 00 00 00 0D 00 49 11 00 00 00 00 21 10 00 01 01 00 0E 24 01 00 08 25 ?? ?? ?? 0? 01 00 07 24 0A 00 49 11 00 00 00 00 21 58 00 01 01 00 0E 24 01 00 08 25 ?? ?? ?? 0? 01 00 07 24 07 00 EE 10 00 00 00 00 ?? ?? ?? 0? 01 00 E7 24 06 00 EE 10 00 00 00 00 ?? ?? ?? 0? 01 00 E7 24 21 40 60 00 ?? ?? ?? 0? 01 00 07 24 21 40 60 00 ?? ?? ?? 0? 01 00 07 24 }
	condition:
		$1
}

rule file_25_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 1400
		refs = "0008 __gnu_local_gp 0084 __libc_tsd_CTYPE_TOLOWER 00e0 __strncasecmp 0134 memchr"
	strings:
		$1 = { 90 FB BD 27 18 04 AF 27 ?? ?? 1C 3C 21 50 A0 00 ?? ?? 9C 27 64 04 B7 AF 60 04 B6 AF 21 B8 C0 00 21 B0 80 00 21 28 E0 00 21 20 C0 00 21 30 E0 01 50 04 B2 AF 48 04 B0 AF 10 00 BC AF 40 04 AA AF 6C 04 BF AF 68 04 BE AF 5C 04 B5 AF 58 04 B4 AF 54 04 B3 AF 4C 04 B1 AF ?? ?? ?? 0? 21 90 E0 00 10 00 BC 8F 40 04 AA 8F 21 80 40 00 18 00 A3 27 00 00 72 AC 04 00 63 24 FD FF E3 15 00 00 00 00 12 00 40 12 ?? ?? 94 8F 3B E8 03 7C 21 20 83 02 00 00 86 8C 21 10 E0 02 21 28 57 02 FF FF 43 26 00 00 44 90 18 00 A7 27 01 00 42 24 80 20 04 00 21 20 C4 00 00 00 84 8C 80 20 04 00 21 20 E4 00 00 00 83 AC F6 FF 45 14 FF FF 63 24 18 04 A7 8F 21 20 E0 02 21 30 00 02 21 28 E7 02 40 04 AA AF ?? ?? ?? 0? 20 04 A7 AF 93 00 40 14 40 04 AA 8F 3B E8 03 7C 21 10 83 02 FF FF 03 26 21 38 E3 02 2C 04 A3 AF 20 04 A3 8F 21 A0 00 00 00 00 51 8C 21 98 92 02 01 00 02 24 23 18 43 02 23 10 50 00 21 20 CA 02 21 28 00 00 23 30 6A 02 24 04 A7 AF 28 04 A3 AF ?? ?? ?? 0? 30 04 A2 AF 21 A8 00 00 1C 00 40 14 FF FF 5E 26 1A 00 60 12 21 10 D3 02 FF FF 42 90 18 00 A4 27 80 10 02 00 21 10 22 02 00 00 42 8C 80 10 02 00 21 10 82 00 00 00 42 8C 1D 00 40 10 2B 68 B0 02 04 00 A0 12 20 04 A7 8F 2B 18 47 00 28 04 A7 8F 0B 10 E3 00 21 A0 82 02 21 A8 00 00 21 50 60 02 21 98 92 02 21 20 CA 02 21 28 00 00 ?? ?? ?? 0? 23 30 6A 02 E6 FF 40 10 00 00 00 00 21 10 00 00 6C 04 BF 8F 68 04 BE 8F 64 04 B7 8F 60 04 B6 8F 5C 04 B5 8F 58 04 B4 8F 54 04 B3 8F 50 04 B2 8F 4C 04 B1 8F 48 04 B0 8F 08 00 E0 03 70 04 BD 27 21 18 00 02 0A 18 AD 02 21 10 74 00 2B 20 7E 00 21 50 E3 02 1D 00 80 10 21 10 C2 02 00 00 45 91 00 00 44 90 80 28 05 00 80 20 04 00 21 28 25 02 21 20 24 02 00 00 A5 8C 00 00 84 8C 3E 00 A4 14 23 30 03 00 21 50 46 01 ?? ?? ?? 0? 21 30 46 00 00 00 84 90 00 00 42 90 80 20 04 00 80 10 02 00 21 20 24 02 21 10 22 02 00 00 84 8C 00 00 42 8C 32 00 82 14 30 04 A7 8F 01 00 63 24 2B 28 7E 00 21 20 43 01 F2 FF A0 14 21 10 C3 00 2C 04 A7 8F 21 50 87 02 BA 00 A0 11 21 50 CA 02 24 04 A3 8F 24 04 A7 8F 00 00 64 90 00 00 43 91 FF FF E2 24 80 20 04 00 80 18 03 00 21 20 24 02 21 18 23 02 00 00 85 8C 00 00 64 8C AD 00 A4 14 FF FF 43 25 23 68 B0 02 21 68 4D 01 ?? ?? ?? 0? 23 50 0A 02 FF FF 63 24 01 00 45 90 01 00 64 90 80 28 05 00 80 20 04 00 21 28 25 02 21 20 24 02 00 00 A5 8C 00 00 84 8C 05 00 A4 14 01 00 AC 26 FF FF 42 24 F3 FF 6D 14 21 30 6A 00 01 00 AC 26 2B 30 CC 00 99 00 C0 14 20 04 A7 8F 28 04 B5 8F 21 50 60 02 ?? ?? ?? 0? 21 A0 87 02 30 04 A7 8F 21 A8 00 00 21 50 60 02 21 58 F4 00 ?? ?? ?? 0? 21 A0 63 01 23 10 50 02 2B 18 50 00 0B 10 03 02 3B E8 03 7C 21 20 60 00 FF FF 03 26 21 38 E3 02 30 04 A7 AF 21 20 84 02 20 04 A3 AF FF FF 54 26 23 18 10 00 28 04 A3 AF 2B 38 14 02 30 04 A3 8F 2C 04 A7 AF 30 04 A7 8F 21 B8 F0 02 24 04 B7 AF FF FF 63 24 38 04 A3 AF 23 A8 F0 00 24 04 A3 8F 28 04 A7 8F 01 00 17 24 00 00 93 8C 01 00 42 24 23 B8 F0 02 34 04 B7 AF 3C 04 A2 AF 18 04 A2 AF 21 F0 00 00 21 B8 67 00 21 88 D2 03 21 20 CA 02 21 28 00 00 ?? ?? ?? 0? 23 30 2A 02 79 FF 40 14 21 10 00 00 76 FF 20 12 21 10 D1 02 FF FF 42 90 18 00 A3 27 80 10 02 00 21 10 62 02 00 00 42 8C 80 10 02 00 21 10 62 00 00 00 42 8C 04 00 40 10 2C 04 A7 8F 21 F0 C2 03 ?? ?? ?? 0? 21 50 20 02 21 30 D0 03 1E 00 E0 10 21 30 C6 02 24 04 A7 8F 00 00 C2 90 00 00 E3 90 80 10 02 00 21 10 62 02 80 18 03 00 21 18 63 02 00 00 63 8C 00 00 42 8C 3E 00 62 14 28 04 A7 8F 21 18 00 02 ?? ?? ?? 0? 21 30 C7 00 00 00 84 90 00 00 42 90 80 20 04 00 80 10 02 00 21 20 64 02 21 10 62 02 00 00 84 8C 00 00 42 8C 33 00 82 14 34 04 A7 8F 01 00 63 24 2B 28 74 00 21 20 E3 02 F2 FF A0 14 21 10 C3 00 20 04 A7 8F FF FF 02 24 21 18 C7 03 1A 00 E2 10 21 18 C3 02 30 04 A7 8F 00 00 62 90 00 00 E4 90 80 10 02 00 21 10 62 02 80 20 04 00 21 20 64 02 00 00 84 8C 00 00 42 8C 22 00 82 14 FF FF 63 24 ?? ?? ?? 0? 38 04 A2 8F 00 00 45 90 01 00 64 90 80 28 05 00 80 20 04 00 21 28 65 02 21 20 64 02 00 00 A5 8C 00 00 84 8C 16 00 A4 14 FF FF 42 24 F5 FF 55 14 FF FF 63 24 6C 04 BF 8F 21 10 DE 02 64 04 B7 8F 68 04 BE 8F 60 04 B6 8F 5C 04 B5 8F 58 04 B4 8F 54 04 B3 8F 50 04 B2 8F 4C 04 B1 8F 48 04 B0 8F 08 00 E0 03 70 04 BD 27 21 18 00 02 34 04 A7 8F 21 50 20 02 21 70 FE 00 ?? ?? ?? 0? 21 F0 C3 01 3C 04 A3 8F 21 50 20 02 ?? ?? ?? 0? 21 F0 C3 03 ?? ?? ?? 0? 21 30 00 02 ?? ?? ?? 0? 21 10 D4 02 }
	condition:
		$1
}

rule file_25_2_0 {
	meta:
		name = "__strcasestr"
		size = 1484
		refs = "0000 __gnu_local_gp 004c __libc_tsd_CTYPE_TOLOWER 014c __strncasecmp 01b0 memchr"
	strings:
		$1 = { ?? ?? 1C 3C 98 FF BD 27 ?? ?? 9C 27 5C 00 B7 AF 64 00 BF AF 60 00 BE AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 48 00 B2 AF 44 00 B1 AF 40 00 B0 AF 10 00 BC AF 00 00 82 80 5C 01 40 10 21 B8 A0 00 00 00 A7 80 5C 01 E0 10 ?? ?? 86 8F 3B E8 03 7C 21 28 60 00 21 28 C5 00 00 00 A6 8C 21 18 E0 02 21 40 80 00 ?? ?? ?? 0? 01 00 05 24 00 00 67 80 13 00 E0 10 00 00 00 00 FF 00 42 30 FF 00 E7 30 80 10 02 00 80 38 07 00 21 10 C2 00 21 38 C7 00 00 00 49 8C 00 00 E7 8C 01 00 08 25 00 00 02 81 26 38 27 01 01 00 E7 2C 01 00 63 24 EF FF 40 14 24 28 A7 00 00 00 62 80 A6 00 40 14 64 00 BF 8F 0B 00 A0 14 21 10 80 00 23 B0 77 00 20 00 C2 2E 01 00 95 24 12 00 40 14 FF FF C8 26 21 20 A0 02 21 28 00 01 21 30 E0 02 ?? ?? ?? 0? 21 38 C0 02 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 21 20 E0 02 21 28 C0 02 18 00 A6 27 ?? ?? ?? 0? 3C 00 A8 AF 18 00 A3 8F 21 20 E0 02 21 30 40 00 21 28 E3 02 20 00 A3 AF ?? ?? ?? 0? 21 98 40 00 10 00 BC 8F 3B E8 03 7C 68 00 40 14 3C 00 A8 8F 21 10 60 00 FF FF 63 26 24 00 A3 AF ?? ?? 83 8F 21 A0 00 00 21 F0 00 00 21 10 62 00 24 00 A3 8F 00 00 50 8C 01 00 02 24 21 88 E3 02 20 00 A3 8F 23 10 53 00 28 00 A2 AF 23 18 C3 02 2C 00 A3 AF 21 90 D6 03 21 20 A8 02 21 28 00 00 ?? ?? ?? 0? 23 30 48 02 67 00 40 14 64 00 BF 8F 65 00 40 12 2B 18 93 02 21 10 60 02 0A 10 83 02 21 18 40 00 21 28 5E 00 2B 10 56 00 21 30 E3 02 1D 00 40 10 21 28 A5 02 00 00 C4 90 00 00 A2 90 80 20 04 00 80 10 02 00 21 20 04 02 21 10 02 02 00 00 84 8C 00 00 42 8C 5F 00 82 14 23 10 03 00 21 30 C2 00 ?? ?? ?? 0? 21 28 A2 00 00 00 42 91 00 00 24 91 80 10 02 00 80 20 04 00 21 10 02 02 21 20 04 02 00 00 42 8C 00 00 88 8C 53 00 48 14 28 00 A2 8F 01 00 63 24 2B 40 76 00 21 50 C3 00 F2 FF 00 15 21 48 A3 00 24 00 A3 8F 2B 10 93 02 21 40 C3 03 D0 00 40 10 21 40 A8 02 00 00 24 92 00 00 03 91 FF FF 22 26 80 20 04 00 80 18 03 00 21 20 04 02 21 18 03 02 00 00 85 8C 00 00 64 8C C5 00 A4 14 FF FF 03 25 23 48 93 02 21 48 09 01 ?? ?? ?? 0? 23 40 68 02 FF FF 63 24 01 00 45 90 01 00 64 90 80 28 05 00 80 20 04 00 21 28 05 02 21 20 04 02 00 00 A5 8C 00 00 84 8C 05 00 A4 14 01 00 8C 26 FF FF 42 24 F3 FF 69 14 21 30 68 00 01 00 8C 26 2B 30 CC 00 B6 00 C0 14 2C 00 B4 8F 20 00 A2 8F 21 40 40 02 ?? ?? ?? 0? 21 F0 C2 03 ?? ?? 84 8F 21 10 60 00 21 18 F3 02 21 10 82 00 00 00 64 90 00 00 54 8C 01 00 7E 26 80 20 04 00 21 20 84 02 21 18 B3 02 2B 10 1E 01 20 00 A3 AF 1B 00 40 10 00 00 91 90 23 30 76 02 21 20 A8 02 21 28 00 00 ?? ?? ?? 0? 02 00 C6 24 14 00 40 10 21 40 C0 03 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 21 10 00 00 08 00 E0 03 68 00 BD 27 28 00 A2 8F 21 A0 00 00 21 40 40 02 21 F0 5E 00 ?? ?? ?? 0? 21 F0 C3 03 23 10 D3 02 2B 20 53 00 0B 10 64 02 01 00 42 24 20 00 A4 8F FF FF 63 26 18 00 A2 AF 30 00 A2 AF 01 00 02 24 23 10 53 00 24 00 A3 AF 21 18 E3 02 28 00 A3 AF 34 00 A2 AF 2B 18 D6 03 00 00 82 90 2C 00 A3 AF 28 00 A3 8F 80 10 02 00 21 10 82 02 FF FF 63 24 38 00 A3 AF 00 00 42 90 28 00 A3 8F 21 90 FE 02 01 00 8F 24 09 00 22 12 23 B8 73 00 D0 FF 40 10 21 20 E0 01 00 00 82 90 80 10 02 00 21 10 82 02 00 00 42 90 F9 FF 22 16 01 00 8F 24 20 00 A3 8F 23 78 E3 01 2C 00 A3 8F 20 00 60 10 FF FF EF 25 01 00 86 90 00 00 42 92 01 00 45 26 80 30 06 00 21 30 86 02 80 10 02 00 21 10 82 02 00 00 C6 8C 00 00 58 8C 02 00 84 24 FF 00 CE 30 0E 00 0E 13 21 10 C0 03 ?? ?? ?? 0? FF 00 C6 30 FF FF 86 90 FF FF AE 90 80 30 06 00 21 30 86 02 80 70 0E 00 21 70 8E 02 00 00 C6 8C 00 00 D8 8D FF 00 CE 30 29 00 0E 17 FF 00 C6 30 01 00 42 24 2B 30 56 00 01 00 84 24 F1 FF C0 14 01 00 A5 24 24 00 A3 8F FF FF 02 24 21 20 E3 01 1D 00 62 10 21 20 A4 02 28 00 A3 8F 00 00 85 90 FF FF 84 24 00 00 62 90 80 28 05 00 21 28 85 02 80 10 02 00 21 10 82 02 00 00 A5 8C 00 00 4E 8C FF 00 A6 30 0E 00 C6 11 38 00 A2 8F ?? ?? ?? 0? FF 00 A5 30 01 00 85 90 00 00 46 90 80 28 05 00 80 30 06 00 21 28 85 02 21 30 86 02 00 00 A5 8C 00 00 CE 8C FF 00 A6 30 17 00 C6 15 FF FF 42 24 F4 FF 57 14 FF FF 84 24 ?? ?? ?? 0? 21 10 AF 02 81 FF C0 10 34 00 A3 8F 21 78 6F 00 21 80 E2 01 21 70 16 02 23 30 C8 01 21 20 A8 02 21 28 00 00 ?? ?? ?? 0? 3C 00 AE AF 77 FF 40 14 3C 00 AE 8F 75 FF C0 11 21 78 13 02 21 78 AF 02 21 40 C0 01 ?? ?? ?? 0? 21 20 E0 01 FF 00 A5 30 6E FF A0 10 30 00 A3 8F ?? ?? ?? 0? 21 80 E3 01 ?? ?? ?? 0? 21 30 60 02 21 18 A0 00 ?? ?? ?? 0? 01 00 05 24 ?? ?? ?? 0? 21 10 80 00 ?? ?? ?? 0? 21 10 BE 02 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "__libc_csu_init"
		size = 212
		refs = "0010 __preinit_array_start 000c __preinit_array_end 006c __init_array_start 0070 __init_array_end 0080 _init"
	strings:
		$1 = { C8 FF BD 27 30 00 B5 AF 20 00 B1 AF ?? ?? 15 3C ?? ?? 11 3C ?? ?? 31 26 ?? ?? B5 26 23 A8 B1 02 83 A8 15 00 2C 00 B4 AF 28 00 B3 AF 24 00 B2 AF 1C 00 B0 AF 34 00 BF AF 21 90 80 00 21 98 A0 00 21 A0 C0 00 09 00 A0 12 21 80 00 00 00 00 39 8E 21 20 40 02 21 28 60 02 21 30 80 02 09 F8 20 03 01 00 10 26 F9 FF 15 16 04 00 31 26 ?? ?? 11 3C ?? ?? 15 3C ?? ?? 31 26 ?? ?? B5 26 23 A8 B1 02 ?? ?? ?? 0? 83 A8 15 00 09 00 A0 12 21 80 00 00 00 00 39 8E 21 20 40 02 21 28 60 02 21 30 80 02 09 F8 20 03 01 00 10 26 F9 FF 15 16 04 00 31 26 34 00 BF 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_26_1_0 {
	meta:
		name = "__libc_csu_fini"
		size = 100
		refs = "0004 __fini_array_start 000c __fini_array_end 005c _fini"
	strings:
		$1 = { D8 FF BD 27 ?? ?? 02 3C 1C 00 B0 AF ?? ?? 10 3C ?? ?? 42 24 ?? ?? 10 26 23 80 02 02 83 80 10 00 20 00 B1 AF FF FF 11 26 80 88 11 00 24 00 BF AF 07 00 00 12 21 88 51 00 00 00 39 8E FF FF 10 26 09 F8 20 03 FC FF 31 26 FB FF 00 16 00 00 00 00 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F ?? ?? ?? 0? 28 00 BD 27 }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "xdr_rmtcallres"
		size = 144
		refs = "0008 xdr_u_long 002c xdr_reference"
	strings:
		$1 = { 00 00 A2 8C D0 FF BD 27 ?? ?? 07 3C 04 00 06 24 24 00 B0 AF ?? ?? E7 24 21 80 A0 00 18 00 A5 27 28 00 B1 AF 2C 00 BF AF 21 88 80 00 ?? ?? ?? 0? 18 00 A2 AF 07 00 40 14 21 20 20 02 2C 00 BF 8F 28 00 B1 8F 24 00 B0 8F 21 10 00 00 08 00 E0 03 30 00 BD 27 ?? ?? ?? 0? 04 00 05 26 F8 FF 40 10 2C 00 BF 8F 18 00 A2 8F 0C 00 19 8E 08 00 05 8E 21 20 20 02 09 F8 20 03 00 00 02 AE 2C 00 BF 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_27_1_0 {
	meta:
		name = "xdr_rmtcall_args"
		size = 300
		refs = "0020 xdr_u_long"
	strings:
		$1 = { C8 FF BD 27 24 00 B1 AF 20 00 B0 AF 34 00 BF AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 21 80 80 00 ?? ?? ?? 0? 21 88 A0 00 0A 00 40 14 21 20 00 02 21 10 00 00 34 00 BF 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? 04 00 25 26 F5 FF 40 10 21 10 00 00 21 20 00 02 ?? ?? ?? 0? 08 00 25 26 F0 FF 40 10 21 10 00 00 04 00 02 8E 18 00 A0 AF 10 00 59 8C 09 F8 20 03 21 20 00 02 21 20 00 02 18 00 A5 27 ?? ?? ?? 0? 21 90 40 00 E5 FF 40 10 21 10 00 00 04 00 02 8E 10 00 59 8C 09 F8 20 03 21 20 00 02 14 00 39 8E 10 00 25 8E 21 20 00 02 09 F8 20 03 21 98 40 00 DA FF 40 10 21 10 00 00 04 00 02 8E 10 00 59 8C 09 F8 20 03 21 20 00 02 04 00 03 8E 23 98 53 00 21 20 00 02 14 00 79 8C 21 28 40 02 0C 00 33 AE 09 F8 20 03 21 A0 40 00 21 20 00 02 ?? ?? ?? 0? 0C 00 25 26 C8 FF 40 10 21 20 00 02 04 00 02 8E 14 00 59 8C 09 F8 20 03 21 28 80 02 ?? ?? ?? 0? 01 00 02 24 }
	condition:
		$1
}

rule file_27_2_0 {
	meta:
		name = "pmap_rmtcall"
		size = 296
		refs = "0060 clntudp_create 0074 xdr_rmtcallres 0090 xdr_rmtcall_args"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 24 88 FF BD 27 04 00 63 8C 68 00 B2 AF 21 90 E0 00 ?? ?? 47 8C 00 6F 02 24 70 00 B4 AF 6C 00 B3 AF 64 00 B1 AF 60 00 B0 AF 74 00 BF AF 21 A0 A0 00 02 00 82 A4 01 00 05 3C 50 00 A2 27 14 00 A2 AF 21 98 C0 00 FF FF 02 24 10 00 A3 AF A0 86 A5 34 02 00 06 24 21 88 80 00 ?? ?? ?? 0? 50 00 A2 AF 21 80 40 00 25 00 00 12 10 00 02 24 ?? ?? 03 3C ?? ?? 63 24 04 00 02 8E 10 00 A3 AF 40 00 A3 27 14 00 A3 AF 98 00 A3 8F ?? ?? 06 3C 21 20 00 02 18 00 A3 AF 9C 00 A3 8F 05 00 05 24 ?? ?? C6 24 1C 00 A3 AF 00 00 59 8C 8C 00 A2 8F 28 00 A7 27 28 00 B4 AF 38 00 A2 AF 88 00 A2 8F 2C 00 B3 AF 30 00 B2 AF 3C 00 A2 AF A0 00 A2 8F 40 00 A2 AF 94 00 A2 8F 48 00 A2 AF 90 00 A2 8F 09 F8 20 03 4C 00 A2 AF 04 00 03 8E 21 20 00 02 10 00 79 8C 09 F8 20 03 58 00 A2 AF 58 00 A2 8F 74 00 BF 8F 02 00 20 A6 70 00 B4 8F 6C 00 B3 8F 68 00 B2 8F 64 00 B1 8F 60 00 B0 8F 08 00 E0 03 78 00 BD 27 }
	condition:
		$1
}

rule file_27_3_0 {
	meta:
		name = "clnt_broadcast"
		size = 1344
		refs = "0000 __gnu_local_gp 0048 authunix_create_default 0060 __socket 0084 __setsockopt 009c getifaddrs 0128 freeifaddrs 0148 _create_xid 01e8 xdrmem_create 01f4 xdr_callmsg 0090 _libc_intl_domainname 020c $LC1 0218 __dcgettext 0224 perror 022c __close 027c $LC0 028c xdr_rmtcall_args 02cc __libc_errno 0320 __sendto 0334 $LC3 00a8 $LC2 035c _null_auth 0378 xdr_rmtcallres 039c __poll 03e8 $LC4 0444 __recvfrom 0474 xdr_replymsg 0498 xdr_void 04f0 $LC5"
	strings:
		$1 = { ?? ?? 1C 3C E0 D6 BD 27 ?? ?? 9C 27 1C 29 BF AF 14 29 B7 AF 10 29 B6 AF 0C 29 B5 AF 04 29 B3 AF 00 29 B2 AF FC 28 B1 AF F8 28 B0 AF 18 00 BC AF 21 B8 80 00 21 B0 A0 00 21 A8 C0 00 21 90 E0 00 18 29 BE AF 08 29 B4 AF ?? ?? ?? 0? 01 00 13 24 02 00 04 24 01 00 05 24 11 00 06 24 21 80 40 00 ?? ?? ?? 0? E4 28 B3 AF 83 00 40 04 21 88 40 00 04 00 02 24 10 00 A2 AF 21 20 20 02 FF FF 05 34 20 00 06 24 ?? ?? ?? 0? E4 28 A7 27 5F 00 40 04 ?? ?? 04 3C 20 00 A4 27 D8 28 B1 AF ?? ?? ?? 0? DC 28 B3 A7 A7 00 40 14 ?? ?? 04 3C 20 00 A4 8F 0D 01 80 10 21 10 80 00 21 98 00 00 03 00 05 24 ?? ?? ?? 0? 02 00 06 24 00 00 42 8C 16 00 40 10 14 00 63 2A 14 00 60 10 00 00 00 00 08 00 43 8C 03 00 63 30 F8 FF 65 14 00 00 00 00 0C 00 43 8C F5 FF 60 10 00 00 00 00 00 00 63 94 F2 FF 66 14 20 00 A8 27 14 00 47 8C 00 00 42 8C 80 18 13 00 04 00 E7 8C 21 18 03 01 01 00 73 26 D8 27 67 AC EC FF 40 14 14 00 63 2A ?? ?? ?? 0? 00 00 00 00 02 00 02 24 C8 28 A2 A7 00 6F 02 24 CC 28 A0 AF D0 28 A0 AF D4 28 A0 AF ?? ?? ?? 0? CA 28 A2 A7 05 00 04 24 5C 28 A4 AF 01 00 04 3C 02 00 03 24 A0 86 84 34 58 28 A3 AF 54 28 A4 AF 50 28 A3 AF 00 00 05 8E 04 00 04 8E 08 00 03 8E 48 28 A2 AF 21 A0 40 00 30 29 A2 8F 60 28 A5 AF 64 28 A4 AF 68 28 A3 AF 0C 00 09 8E 10 00 08 8E 88 28 A2 AF E0 28 A2 27 14 00 03 8E 34 29 B9 8F A8 28 A2 AF 38 29 A2 8F 90 28 A4 27 80 22 A5 27 78 05 06 24 21 38 00 00 6C 28 A9 AF 70 28 A8 AF 74 28 A3 AF B4 28 B9 AF B0 28 A2 AF 4C 28 A0 AF 78 28 B7 AF 7C 28 B6 AF 80 28 B5 AF ?? ?? ?? 0? 8C 28 B2 AF 90 28 A4 27 ?? ?? ?? 0? 48 28 A5 27 23 00 40 14 90 28 A4 27 ?? ?? ?? 0? 01 00 12 24 ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 21 20 40 00 ?? ?? ?? 0? 03 00 12 24 ?? ?? ?? 0? 21 20 20 02 20 00 03 8E 10 00 79 8C 09 F8 20 03 21 20 00 02 1C 29 BF 8F 21 10 40 02 18 29 BE 8F 14 29 B7 8F 10 29 B6 8F 0C 29 B5 8F 08 29 B4 8F 04 29 B3 8F 00 29 B2 8F FC 28 B1 8F F8 28 B0 8F 08 00 E0 03 20 29 BD 27 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? 78 28 A5 27 E5 FF 40 10 01 00 12 24 94 28 A2 8F 10 00 59 8C 09 F8 20 03 90 28 A4 27 21 90 40 00 94 28 A2 8F 1C 00 59 8C 04 00 20 13 18 00 BC 8F 09 F8 20 03 90 28 A4 27 18 00 BC 8F ?? ?? 95 8F 3B E8 03 7C 21 10 60 00 A0 0F 03 24 F0 28 A3 AF 21 A8 A2 02 1B 00 60 12 F8 27 BE 27 21 B8 00 00 ?? ?? ?? 0? 10 00 16 24 16 00 F3 12 04 00 DE 27 00 00 C2 8F C8 28 A8 27 10 00 A8 AF 14 00 B6 AF 21 20 20 02 80 22 A5 27 21 30 40 02 21 38 00 00 ?? ?? ?? 0? CC 28 A2 AF F3 FF 42 12 01 00 F7 26 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? ?? ?? 84 24 ?? ?? ?? 0? 21 98 00 00 3C 29 B9 8F 61 00 20 13 ?? ?? 02 3C ?? ?? 5E 24 ?? ?? 03 3C ?? ?? 67 8C 08 00 C2 8F 04 00 C3 8F F0 28 A6 8F ?? ?? 19 3C A8 28 A8 27 ?? ?? 39 27 D8 28 A4 27 01 00 05 24 58 28 A3 AF 54 28 A7 AF 5C 28 A2 AF 64 28 A8 AF ?? ?? ?? 0? 68 28 B9 AF FF FF 03 24 0A 00 43 10 00 00 00 00 17 00 40 14 10 00 16 24 F0 28 A3 8F 80 3E 02 24 D0 07 63 24 C7 FF 62 14 F0 28 A3 AF ?? ?? ?? 0? 05 00 12 24 00 00 A3 8E 04 00 02 24 E2 FF 62 10 ?? ?? 03 3C ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 21 20 40 00 ?? ?? ?? 0? 04 00 12 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 04 00 17 24 00 00 A2 8E 34 00 57 14 ?? ?? 04 3C B8 28 A8 27 E8 28 B9 27 10 00 A8 AF 14 00 B9 AF 21 20 20 02 20 00 A5 27 60 22 06 24 21 38 00 00 ?? ?? ?? 0? E8 28 B6 AF F2 FF 40 04 04 00 43 2C C4 FF 60 14 ?? ?? 03 3C 90 28 A4 27 20 00 A5 27 21 30 40 00 ?? ?? ?? 0? 01 00 07 24 90 28 A4 27 ?? ?? ?? 0? 48 28 A5 27 04 00 40 10 21 B0 00 00 48 28 A2 8F 1D 00 82 12 50 28 A2 8F 02 00 02 24 90 28 A2 AF ?? ?? 02 3C 90 28 A4 27 48 28 A5 27 ?? ?? 42 24 ?? ?? ?? 0? 68 28 A2 AF 34 29 B9 8F 38 29 A5 8F 09 F8 20 03 90 28 A4 27 94 28 A2 8F 1C 00 59 8C 03 00 20 13 00 00 00 00 09 F8 20 03 90 28 A4 27 A3 FF C0 12 ?? ?? 03 3C ?? ?? ?? 0? 21 90 00 00 ?? ?? ?? 0? 21 98 00 00 ?? ?? 05 3C ?? ?? 84 24 ?? ?? ?? 0? ?? ?? A5 24 E4 FF 40 14 02 00 02 24 60 28 A2 8F E1 FF 40 14 02 00 02 24 E0 28 A2 8F 38 29 A4 8F 3C 29 B9 8F 00 3A 43 7C 00 12 02 00 25 10 62 00 B8 28 A5 27 09 F8 20 03 BA 28 A2 A7 ?? ?? ?? 0? 21 B0 40 00 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "compute_tzname_max"
		size = 96
		refs = "0030 __tzname_cur_max"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 45 8C ?? ?? 06 3C 21 20 A4 00 00 00 A2 80 0C 00 40 10 21 10 A0 00 01 00 42 24 00 00 43 80 FE FF 60 14 01 00 42 24 FF FF 42 24 ?? ?? C3 8C 23 28 45 00 2B 18 65 00 02 00 60 10 00 00 00 00 ?? ?? C5 AC 01 00 45 24 2B 10 A4 00 EF FF 40 14 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "__tzfile_read"
		size = 3752
		refs = "0008 __use_tzfile 0054 __libc_enable_secure 006c getenv 0068 $LC2 0088 default_tzdir.5534 009c strlen 00c8 mempcpy 00e0 memcpy 00f8 __xstat64 0124 _IO_new_fopen 0a28 $LC3 0134 fileno 0144 __fxstat64 0154 _IO_new_fclose 0170 strstr 0208 $LC1 0184 free 01d8 $LC0 01e0 memcmp 026c fread_unlocked 027c $LC4 03c0 malloc 0560 __uflow 08f4 __tzstring 0914 __tzname 09b4 __daylight 09c0 __timezone 0bc0 fseek 0bd0 ftello 0e48 $LC5 0e4c $LC6 0e60 __assert_fail 0e50 __PRETTY_FUNCTION__.5698"
	strings:
		$1 = { B8 FE BD 27 24 01 B1 AF ?? ?? 11 3C 40 01 BE AF 34 01 B5 AF 2C 01 B3 AF 28 01 B2 AF 20 01 B0 AF ?? ?? 35 8E 44 01 BF AF 3C 01 B7 AF 38 01 B6 AF 30 01 B4 AF 21 F0 A0 03 21 80 80 00 21 90 A0 00 21 98 C0 00 98 00 80 10 ?? ?? 20 AE 00 00 94 80 4B 00 80 12 ?? ?? 02 3C ?? ?? 42 8C 41 00 40 14 2F 00 02 24 93 00 82 12 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 04 00 40 10 21 B0 40 00 00 00 42 80 50 00 40 14 00 00 00 00 ?? ?? 16 3C 14 00 14 24 13 00 06 24 ?? ?? D6 26 21 20 00 02 ?? ?? ?? 0? 18 01 C6 AF 01 00 57 24 21 10 F4 02 0E 00 42 24 C2 10 02 00 C0 10 02 00 23 E8 A2 03 18 01 C6 8F 10 00 B4 27 21 20 80 02 ?? ?? ?? 0? 21 28 C0 02 2F 00 03 24 00 00 43 A0 01 00 44 24 21 28 00 02 ?? ?? ?? 0? 21 30 E0 02 0D 00 A0 12 ?? ?? 05 3C 03 00 04 24 21 28 80 02 ?? ?? ?? 0? 18 00 C6 27 07 00 40 14 ?? ?? 05 3C ?? ?? 02 3C ?? ?? 43 8C 28 00 C4 8F 42 02 83 10 ?? ?? 42 8C ?? ?? 05 3C 21 20 80 02 ?? ?? ?? 0? ?? ?? A5 24 14 00 40 10 21 B8 40 00 ?? ?? ?? 0? 21 20 40 00 21 28 40 00 03 00 04 24 ?? ?? ?? 0? 18 00 C6 27 31 00 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 E0 02 ?? ?? ?? 0? ?? ?? 10 3C 1C 00 82 12 ?? ?? 05 3C 21 20 00 02 ?? ?? ?? 0? ?? ?? A5 24 BA FF 40 10 2F 00 02 24 ?? ?? 10 3C ?? ?? ?? 0? ?? ?? 04 8E ?? ?? 00 AE 21 E8 C0 03 44 01 BF 8F 40 01 BE 8F 3C 01 B7 8F 38 01 B6 8F 34 01 B5 8F 30 01 B4 8F 2C 01 B3 8F 28 01 B2 8F 24 01 B1 8F 20 01 B0 8F 08 00 E0 03 48 01 BD 27 ?? ?? ?? 0? 21 20 C0 02 21 30 40 00 ?? ?? ?? 0? 01 00 54 24 ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? 0F 00 06 24 E0 FF 40 10 ?? ?? 05 3C ?? ?? 05 3C 21 20 00 02 ?? ?? A5 24 ?? ?? ?? 0? 13 00 06 24 D9 FF 40 10 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? 10 3C ?? ?? 10 3C ?? ?? ?? 0? ?? ?? 04 8E 00 00 E4 8E 18 00 CB 8F 28 00 C8 8F 2C 00 C9 8F 60 00 CA 8F ?? ?? 02 3C 00 80 84 34 ?? ?? 4B AC ?? ?? 40 AC ?? ?? 02 3C 00 00 E4 AE ?? ?? 48 AC B8 00 C4 27 ?? ?? 49 AC 2C 00 05 24 ?? ?? 02 3C 01 00 06 24 21 38 E0 02 ?? ?? 00 AE ?? ?? ?? 0? ?? ?? 4A AC 01 00 04 24 07 00 44 14 ?? ?? 16 3C B8 00 C4 27 ?? ?? C5 26 ?? ?? ?? 0? 04 00 06 24 0A 00 40 10 F0 00 C2 AF ?? ?? ?? 0? 21 20 E0 02 ?? ?? ?? 0? 00 00 00 00 ?? ?? 14 3C ?? ?? ?? 0? ?? ?? 94 26 ?? ?? ?? 0? 21 A0 00 02 D8 00 C6 8F DC 00 C4 8F D4 00 C2 8F E0 00 CB 8F D0 00 CD 8F CC 00 CE 8F A0 30 06 7C 33 33 05 3C 02 34 26 00 A0 20 04 7C A0 10 02 7C 33 33 A5 24 02 24 24 00 ?? ?? 14 3C A0 58 0B 7C 02 14 22 00 ?? ?? 0C 3C A0 68 0D 7C A0 70 0E 7C ?? ?? 03 3C 2B 28 C5 00 ?? ?? 66 AC ?? ?? 84 AE 02 5C 2B 00 ?? ?? 82 AD 02 6C 2D 00 DC FF A0 10 02 74 2E 00 80 A8 06 00 21 40 A6 02 03 00 08 25 FC FF 05 24 24 40 05 01 27 38 08 00 C2 38 07 00 2B 38 E4 00 D2 FF E0 14 C0 38 04 00 21 20 07 01 27 50 04 00 2B 50 4B 01 CD FF 40 15 21 20 8B 00 FD FF 8A 2C CA FF 40 11 03 00 84 24 24 28 85 00 27 20 05 00 C2 20 04 00 2B 20 82 00 C4 FF 80 14 C0 C0 02 00 21 20 B8 00 27 10 04 00 2B 10 52 00 BF FF 40 14 21 20 92 00 04 01 C5 AF 18 01 C6 AF 00 01 C7 AF F8 00 C8 AF 08 01 CB AF 0C 01 CC AF 10 01 CD AF 14 01 CE AF ?? ?? ?? 0? FC 00 D8 AF ?? ?? 02 AE 04 01 C5 8F 18 01 C6 8F 00 01 C7 8F F8 00 C8 8F 08 01 CB 8F 0C 01 CC 8F 10 01 CD 8F 14 01 CE 8F AA FF 40 10 FC 00 D8 8F 21 20 48 00 ?? ?? 03 3C 21 38 87 00 21 C8 55 00 ?? ?? 0F 3C ?? ?? 15 3C 21 28 45 00 ?? ?? 0A 3C ?? ?? 67 AC ?? ?? 03 3C ?? ?? F9 AD ?? ?? A4 AE ?? ?? 45 AD 03 00 40 12 ?? ?? 60 AC 21 28 B8 00 00 00 65 AE 21 20 40 00 05 00 05 24 21 38 E0 02 F8 00 CA AF 08 01 CB AF 0C 01 CC AF 10 01 CD AF 14 01 CE AF ?? ?? ?? 0? 1C 01 CF AF ?? ?? 05 3C ?? ?? A4 8C F8 00 CA 8F 08 01 CB 8F 0C 01 CC 8F 10 01 CD 8F 14 01 CE 8F 86 FF 44 14 1C 01 CF 8F 0E 02 40 10 ?? ?? E6 8D ?? ?? 87 8E 00 00 C4 90 2B 20 87 00 7F FF 80 10 01 00 C4 24 21 30 C2 00 07 00 86 10 FF FF 45 24 00 00 85 90 2B 28 A7 00 FB FF A0 14 01 00 84 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? 06 8E 80 20 02 00 21 10 C4 00 FF FF 06 24 FC FF 44 8C FF FF A5 24 FC FF 42 24 A0 20 04 7C 02 24 24 00 FA FF A6 14 00 00 44 AC 21 98 00 00 E4 00 C6 27 FF FF 07 24 E8 00 C5 27 04 00 E2 8E 08 00 F8 8E 2B 20 58 00 0B 00 80 10 21 90 C0 00 01 00 44 24 04 00 E4 AE 00 00 42 90 01 00 52 26 1D 00 45 12 FF FF 42 A2 21 10 80 00 2B 20 58 00 F8 FF 80 14 01 00 44 24 21 20 E0 02 04 01 C5 AF 18 01 C6 AF 00 01 C7 AF F8 00 CA AF 08 01 CB AF 0C 01 CC AF 10 01 CD AF 14 01 CE AF ?? ?? ?? 0? 1C 01 CF AF 00 01 C7 8F 04 01 C5 8F 18 01 C6 8F F8 00 CA 8F 08 01 CB 8F 0C 01 CC 8F 10 01 CD 8F 14 01 CE 8F 43 FF 47 10 1C 01 CF 8F 04 00 E4 8E ?? ?? ?? 0? 08 00 F8 8E 2B C0 98 00 04 02 00 13 00 00 00 00 01 00 82 24 04 00 E2 AE 00 00 82 90 02 00 44 2C 37 FF 80 10 ?? ?? A4 8E C0 90 13 00 21 20 92 00 04 00 82 A0 04 00 E2 8E 08 00 E4 8E 2B 20 44 00 E1 01 80 10 01 00 44 24 04 00 E4 AE 00 00 42 90 2B 20 62 01 2A FF 80 14 E4 00 C4 8F ?? ?? B9 8E ?? ?? 98 8E A0 20 04 7C 01 00 73 26 21 90 32 03 02 24 24 00 2B C0 78 02 05 00 42 A2 BA FF 00 17 00 00 44 AE ?? ?? 02 3C ?? ?? 44 8C 21 30 60 01 01 00 05 24 21 38 E0 02 F8 00 CA AF 08 01 CB AF 0C 01 CC AF 10 01 CD AF 14 01 CE AF ?? ?? ?? 0? 1C 01 CF AF 08 01 CB 8F 21 90 40 00 F8 00 CA 8F 0C 01 CC 8F 10 01 CD 8F 14 01 CE 8F 0C FF 4B 14 1C 01 CF 8F ?? ?? 82 8D 21 38 00 00 E4 00 C6 27 FF FF 0B 24 45 00 40 10 E8 00 C5 27 08 00 E4 8E 21 98 C0 00 04 00 E2 8E 2B C0 44 00 9B 01 00 13 01 00 58 24 04 00 F8 AE 00 00 42 90 01 00 73 26 F8 FF 65 16 FF FF 62 A2 E4 00 C2 8F ?? ?? 59 8D C0 C0 07 00 A0 10 02 7C 02 14 22 00 21 C8 38 03 00 00 22 AF 04 00 E2 8E 2B 20 44 00 0C 00 80 10 21 98 C0 00 01 00 44 24 04 00 E4 AE 00 00 42 90 01 00 73 26 1F 00 65 12 FF FF 62 A2 08 00 E4 8E 04 00 E2 8E 2B 20 44 00 F7 FF 80 14 01 00 44 24 21 20 E0 02 04 01 C5 AF 18 01 C6 AF 00 01 C7 AF F8 00 CA AF 08 01 CB AF 0C 01 CC AF 10 01 CD AF 14 01 CE AF 1C 01 CF AF ?? ?? ?? 0? FC 00 D8 AF 08 01 CB 8F 04 01 C5 8F 18 01 C6 8F 00 01 C7 8F F8 00 CA 8F 0C 01 CC 8F 10 01 CD 8F 14 01 CE 8F 1C 01 CF 8F CE FE 4B 10 FC 00 D8 8F ?? ?? ?? 0? 01 00 73 26 E4 00 C2 8F ?? ?? 59 8D ?? ?? 84 8D A0 10 02 7C 01 00 E7 24 02 14 22 00 21 C0 38 03 2B 20 E4 00 BD FF 80 14 04 00 02 AF 10 00 A0 11 21 98 00 00 FF FF 06 24 04 00 E2 8E 08 00 E4 8E 2B 20 44 00 96 01 80 10 01 00 44 24 04 00 E4 AE 00 00 42 90 ?? ?? A5 8E C0 20 13 00 2B 10 02 00 21 20 A4 00 01 00 73 26 F3 FF 6D 16 06 00 82 A0 ?? ?? 85 8E 2B 10 65 02 0B 00 40 10 ?? ?? A4 8E C0 10 13 00 C0 30 05 00 21 10 82 00 21 20 86 00 06 00 42 24 06 00 84 24 00 00 40 A0 08 00 42 24 FD FF 44 14 00 00 00 00 21 98 00 00 FF FF 06 24 10 00 C0 11 21 10 A0 00 04 00 E2 8E 08 00 E4 8E 2B 20 44 00 8E 01 80 10 01 00 44 24 04 00 E4 AE 00 00 42 90 ?? ?? A5 8E C0 20 13 00 2B 10 02 00 21 20 A4 00 01 00 73 26 F3 FF 6E 16 07 00 82 A0 ?? ?? 82 8E 2B 20 62 02 0B 00 80 10 ?? ?? A5 8E C0 98 13 00 C0 20 02 00 21 10 B3 00 07 00 A5 24 07 00 42 24 21 20 A4 00 00 00 40 A0 08 00 42 24 FD FF 44 14 00 00 00 00 BC 00 C2 83 9E 00 40 14 2C 00 05 24 ?? ?? 05 3C ?? ?? A2 8C 05 00 40 10 21 20 E0 02 00 00 42 80 02 00 40 14 00 00 00 00 ?? ?? A0 AC ?? ?? ?? 0? 1C 01 CF AF ?? ?? 82 8E 21 80 00 00 0F 00 40 10 1C 01 CF 8F ?? ?? A3 8E C0 10 10 00 ?? ?? 05 3C 21 10 62 00 05 00 42 90 ?? ?? A4 8C 1C 01 CF AF 01 00 10 26 ?? ?? ?? 0? 21 20 82 00 ?? ?? 82 8E 2B 10 02 02 F3 FF 40 14 1C 01 CF 8F ?? ?? 02 3C ?? ?? 56 8C ?? ?? 10 3C ?? ?? 17 26 ?? ?? 00 AE 04 00 E0 AE DC 00 C0 12 F4 00 D7 AF ?? ?? E2 8D FF FF D6 26 ?? ?? A3 8E 21 10 56 00 00 00 42 90 C0 10 02 00 21 10 62 00 04 00 45 90 80 18 05 00 21 98 E3 02 00 00 64 8E 1E 00 80 10 ?? ?? 03 3C F3 FF C0 16 ?? ?? E2 8D ?? ?? 02 8E CB 00 40 10 ?? ?? 83 8E 04 00 E2 8E C4 00 40 10 ?? ?? 02 3C ?? ?? ?? 0? 21 20 40 02 ?? ?? 03 3C ?? ?? 62 8C 33 00 40 14 ?? ?? A8 8E ?? ?? A2 8E 00 00 49 8C ?? ?? 02 3C ?? ?? 49 AC ?? ?? 02 3C ?? ?? 49 AC F0 00 C3 8F ?? ?? 02 3C 23 48 09 00 ?? ?? 43 AC ?? ?? 02 3C ?? ?? 49 AC 01 00 02 24 ?? ?? ?? 0? ?? ?? 22 AE 05 00 42 90 ?? ?? 64 8C 04 01 C5 AF 1C 01 CF AF ?? ?? ?? 0? 21 20 82 00 04 01 C5 8F 01 00 03 24 00 00 62 AE 23 20 65 00 F4 00 C5 8F 80 20 04 00 21 20 85 00 00 00 82 8C D4 FF 40 10 1C 01 CF 8F ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 42 8C 2C 00 C3 8F BE FD 62 14 ?? ?? 05 3C ?? ?? 02 3C ?? ?? 44 8C 18 00 C3 8F B9 FD 83 14 ?? ?? 42 8C B7 FD 40 14 ?? ?? 02 3C ?? ?? 42 8C 60 00 C3 8F B3 FD 62 14 01 00 02 24 ?? ?? ?? 0? ?? ?? 22 AE ?? ?? E7 8D ?? ?? 0A 3C ?? ?? 0C 3C ?? ?? 40 AD ?? ?? 80 AD 21 58 00 00 21 48 00 00 21 28 00 00 21 18 00 00 14 00 60 14 21 20 E2 00 FF FF 84 90 C0 20 04 00 21 20 04 01 04 00 86 90 0E 00 C0 14 00 00 00 00 8B 00 A0 14 00 00 83 8C 21 48 60 00 01 00 03 24 FF FF 42 24 F2 FF 40 14 00 00 00 00 ?? ?? 89 AD 8B 00 A0 14 ?? ?? 4B AD ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 49 AC 05 00 A0 10 21 20 E2 00 D6 00 60 14 01 00 05 24 ?? ?? ?? 0? FF FF 42 24 FF FF 84 90 C0 20 04 00 21 20 04 01 04 00 86 90 EC FF C0 10 00 00 00 00 ?? ?? ?? 0? 00 00 8B 8C B8 00 C4 27 01 00 06 24 21 38 E0 02 ?? ?? ?? 0? 1C 01 CF AF 01 00 04 24 DB FD 44 14 B8 00 C4 27 ?? ?? C5 26 ?? ?? ?? 0? 04 00 06 24 D6 FD 40 14 D8 00 C5 8F E0 00 C7 8F D0 00 CA 8F DC 00 C4 8F CC 00 C6 8F D4 00 C2 8F A0 28 05 7C A0 38 07 7C A0 50 0A 7C 02 2C 25 00 02 54 2A 00 A0 20 04 7C 02 3C 27 00 A0 30 06 7C 21 38 47 01 02 24 24 00 C0 58 05 00 A0 10 02 7C 02 34 26 00 21 28 65 01 02 14 22 00 21 30 E6 00 40 38 04 00 C0 20 04 00 21 30 C5 00 23 28 87 00 80 20 02 00 00 11 02 00 23 10 44 00 21 28 C5 00 21 20 E0 02 21 28 A2 00 ?? ?? ?? 0? 01 00 06 24 B3 FD 40 14 00 00 00 00 ?? ?? ?? 0? 21 20 E0 02 AF FD 40 04 1C 01 CF 8F 54 00 C5 8F 02 00 44 24 C3 37 04 00 2A 38 A6 00 A9 FD E0 14 50 00 D6 8F 03 00 C5 14 2B 20 C4 02 A5 FD 80 14 00 00 00 00 23 B0 C2 02 0D 00 C5 26 04 00 E2 8E 08 00 E4 8E C2 28 05 00 C0 28 05 00 23 E8 A5 03 2B 20 44 00 9A 00 80 10 10 00 B3 27 01 00 44 24 04 00 E4 AE 00 00 42 90 0A 00 04 24 95 FD 44 14 FE FF D6 26 21 20 60 02 01 00 05 24 21 30 C0 02 21 38 E0 02 ?? ?? ?? 0? 1C 01 CF AF 8D FD C2 16 1C 01 CF 8F 21 B0 76 02 00 00 C0 A2 21 20 60 02 ?? ?? ?? 0? 1C 01 CF AF ?? ?? 03 3C ?? ?? 62 AC ?? ?? ?? 0? 1C 01 CF 8F ?? ?? 42 8C ?? ?? ?? 0? 04 00 E2 AE ?? ?? 83 8E 01 00 02 24 69 00 62 14 ?? ?? 02 3C ?? ?? 44 8C ?? ?? ?? 0? 1C 01 CF AF ?? ?? 02 AE ?? ?? ?? 0? 1C 01 CF 8F ?? ?? 82 8E 0A FE 40 14 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 44 8C ?? ?? 83 AD ?? ?? 4B AD 21 48 60 00 ?? ?? 55 8D 26 A8 A9 02 2B A8 15 00 ?? ?? ?? 0? F0 00 D5 AF 26 58 69 01 2B 58 0B 00 ?? ?? ?? 0? F0 00 CB AF 21 20 E0 02 04 01 C5 AF 18 01 C6 AF 00 01 C7 AF F8 00 CA AF 08 01 CB AF 0C 01 CC AF 10 01 CD AF 14 01 CE AF ?? ?? ?? 0? 1C 01 CF AF 08 01 CB 8F 04 01 C5 8F 18 01 C6 8F 00 01 C7 8F F8 00 CA 8F 0C 01 CC 8F 10 01 CD 8F 14 01 CE 8F 51 FD 4B 10 1C 01 CF 8F ?? ?? ?? 0? 08 00 E4 8E 21 20 E0 02 04 01 C5 AF 18 01 C6 AF 00 01 C7 AF F8 00 CA AF 08 01 CB AF 0C 01 CC AF 10 01 CD AF 14 01 CE AF ?? ?? ?? 0? 1C 01 CF AF 04 01 C5 8F 18 01 C6 8F 00 01 C7 8F F8 00 CA 8F 08 01 CB 8F 0C 01 CC 8F 10 01 CD 8F 14 01 CE 8F ?? ?? ?? 0? 1C 01 CF 8F 21 20 E0 02 04 01 C5 AF 18 01 C6 AF 00 01 C7 AF F8 00 CA AF 08 01 CB AF 0C 01 CC AF 10 01 CD AF 14 01 CE AF ?? ?? ?? 0? 1C 01 CF AF 04 01 C5 8F 18 01 C6 8F 00 01 C7 8F F8 00 CA 8F 08 01 CB 8F 0C 01 CC 8F 10 01 CD 8F 14 01 CE 8F ?? ?? ?? 0? 1C 01 CF 8F 21 20 E0 02 18 01 C6 AF 10 01 CD AF 14 01 CE AF ?? ?? ?? 0? 1C 01 CF AF 18 01 C6 8F 10 01 CD 8F 14 01 CE 8F 63 FE 46 14 1C 01 CF 8F ?? ?? ?? 0? 00 00 00 00 ?? ?? 89 AD ?? ?? ?? 0? ?? ?? 4B AD ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 EA 01 06 24 ?? ?? ?? 0? ?? ?? E7 24 21 20 E0 02 18 01 C6 AF 14 01 CE AF ?? ?? ?? 0? 1C 01 CF AF 18 01 C6 8F 14 01 CE 8F 04 FD 46 10 1C 01 CF 8F ?? ?? ?? 0? ?? ?? A5 8E 21 20 E0 02 ?? ?? ?? 0? 1C 01 CF AF ?? ?? ?? 0? 1C 01 CF 8F }
	condition:
		$1
}

rule file_28_2_0 {
	meta:
		name = "__tzfile_default"
		size = 556
		refs = "0034 strlen 0050 $LC7 005c __tzfile_read 0064 __use_tzfile 008c mempcpy 009c memcpy 0178 __tzname 01a8 __timezone"
	strings:
		$1 = { B8 FF BD 27 24 00 B0 AF 21 80 A0 00 44 00 BF AF 3C 00 B6 AF 38 00 B5 AF 34 00 B4 AF 21 A8 E0 00 30 00 B3 AF 2C 00 B2 AF 21 98 C0 00 28 00 B1 AF 21 A0 80 00 ?? ?? ?? 0? 40 00 B7 AF 21 20 00 02 ?? ?? ?? 0? 01 00 51 24 01 00 56 24 21 90 D1 02 ?? ?? 04 3C ?? ?? 84 24 21 28 40 02 ?? ?? ?? 0? 18 00 A6 27 ?? ?? 02 3C ?? ?? 43 8C 55 00 60 10 44 00 BF 8F ?? ?? 17 3C ?? ?? E3 8E 02 00 63 2C 5A 00 60 14 18 00 A4 8F 21 28 80 02 ?? ?? ?? 0? 21 30 20 02 21 20 40 00 21 30 C0 02 ?? ?? ?? 0? 21 28 00 02 ?? ?? 02 3C 18 00 A3 8F ?? ?? 46 8C ?? ?? 02 3C ?? ?? 43 AC 02 00 02 24 56 00 C0 10 ?? ?? E2 AE ?? ?? 02 3C ?? ?? 43 8C ?? ?? 0B 3C ?? ?? 02 3C ?? ?? 0C 3C ?? ?? 4A 8C ?? ?? 6D 8D ?? ?? 87 8D ?? ?? 02 3C ?? ?? 44 8C 23 68 AD 02 23 38 67 02 21 30 66 00 21 48 40 01 ?? ?? ?? 0? 21 28 00 00 06 00 02 91 13 00 40 14 00 00 00 00 00 00 42 8D 21 10 4D 00 00 00 42 AD 01 00 63 24 04 00 05 91 04 00 4A 25 13 00 66 10 04 00 29 25 00 00 68 90 C0 40 08 00 21 40 88 00 04 00 02 91 00 00 62 A0 07 00 02 91 F4 FF 40 14 00 00 00 00 EC FF A0 14 00 00 00 00 00 00 22 8D 01 00 63 24 04 00 4A 25 21 10 47 00 00 00 22 AD 04 00 05 91 EF FF 66 14 04 00 29 25 ?? ?? 02 3C ?? ?? 45 24 01 00 03 24 00 00 93 AC 05 00 80 A0 04 00 80 A0 08 00 95 AC 0C 00 83 A0 0D 00 91 A0 23 18 13 00 ?? ?? 54 AC 21 20 40 02 ?? ?? 02 3C 04 00 B0 AC ?? ?? 93 AD ?? ?? 75 AD ?? ?? ?? 0? ?? ?? 43 AC 44 00 BF 8F 40 00 B7 8F 3C 00 B6 8F 38 00 B5 8F 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 48 00 BD 27 40 00 B7 8F 3C 00 B6 8F 38 00 B5 8F 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F ?? ?? 40 AC 08 00 E0 03 48 00 BD 27 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 0B 3C ?? ?? ?? 0? ?? ?? 0C 3C }
	condition:
		$1
}

rule file_28_3_0 {
	meta:
		name = "__tzfile_compute"
		size = 1912
		refs = "00c8 __tzname 01dc __tzstring 02b4 __daylight 02c8 __timezone 0304 strcmp 0504 $LC5 04d4 $LC6 0518 __assert_fail 0508 __PRETTY_FUNCTION__.5735 0530 __tzset_parse_tz 0540 __offtime 055c __tz_compute 05b0 strlen 0730 $LC8 0758 $LC9"
	strings:
		$1 = { B8 FF BD 27 24 00 B1 AF 44 00 BF AF 40 00 BE AF 3C 00 B7 AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 20 00 B0 AF 48 00 A4 AF 21 88 C0 00 22 00 A0 14 54 00 A7 AF ?? ?? 02 3C ?? ?? 43 8C ?? ?? 10 3C ?? ?? 08 8E 54 00 AA 8F C0 10 03 00 F8 FF 42 24 00 00 20 AE 48 00 A6 8F 21 10 02 01 ?? ?? ?? 0? 00 00 40 AD 21 38 40 00 F8 FF 42 24 08 00 45 8C 2A 28 C5 00 C5 00 A0 10 00 00 00 00 21 18 80 00 F8 FF 60 14 FF FF 64 24 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 ?? ?? 12 3C ?? ?? 42 8E ?? ?? 03 3C ?? ?? 73 24 ?? ?? 60 AC 3E 01 40 10 04 00 60 AE ?? ?? 03 3C ?? ?? 69 8C 00 00 23 8D 2A 18 83 00 38 01 60 14 80 18 02 00 21 18 23 01 FC FF 63 8C 2A 28 83 00 07 01 A0 10 1A 88 06 3C 23 18 64 00 EF 22 C6 24 18 00 66 00 C3 2F 03 00 10 30 00 00 21 18 C3 00 C3 1D 03 00 23 18 65 00 2B 28 62 00 80 00 A0 10 FF FF 50 24 23 18 43 00 FF FF 65 24 80 30 05 00 21 50 26 01 00 00 4B 8D 2A 58 8B 00 9D 00 60 11 00 00 00 00 0A 00 A2 2C 05 00 40 14 21 10 26 01 D8 FF 42 8D 2A 10 82 00 E0 00 40 14 21 10 26 01 FC FF 42 8C 2A 10 82 00 09 00 40 10 21 80 A0 00 04 00 C6 24 21 48 26 01 21 80 A0 00 FC FF 29 25 F8 FF 22 8D 2A 10 82 00 FC FF 40 14 FF FF 10 26 ?? ?? 14 3C ?? ?? 82 8E FF FF 03 26 ?? ?? 15 3C 21 10 43 00 00 00 42 90 18 00 A3 AF ?? ?? A3 8E C0 10 02 00 ?? ?? 17 3C 21 10 62 00 05 00 43 90 ?? ?? E4 8E 04 00 56 90 1C 00 B3 AF ?? ?? ?? 0? 21 20 83 00 ?? ?? 43 8E 80 B0 16 00 21 B0 76 02 2B 18 03 02 00 00 C2 AE 08 00 60 14 ?? ?? 8A 8E ?? ?? ?? 0? ?? ?? 03 3C ?? ?? 42 8E 01 00 10 26 2B 10 02 02 1A 00 40 10 ?? ?? 03 3C 21 10 50 01 00 00 42 90 ?? ?? A3 8E C0 10 02 00 21 10 62 00 04 00 56 90 05 00 44 90 80 F0 16 00 21 F0 7E 02 00 00 C2 8F F1 FF 40 14 ?? ?? 42 8E ?? ?? E2 8E ?? ?? ?? 0? 21 20 44 00 01 00 04 24 1C 00 A5 8F 23 18 96 00 80 18 03 00 00 00 C2 AF 21 18 65 00 00 00 62 8C E4 FF 40 10 ?? ?? 8A 8E ?? ?? 03 3C ?? ?? 62 8C 31 01 40 10 00 00 00 00 18 00 A5 8F ?? ?? B0 8E 21 50 45 01 00 00 43 91 C0 18 03 00 21 80 03 02 ?? ?? 04 3C ?? ?? 03 3C ?? ?? 63 8C ?? ?? 85 8C ?? ?? 04 3C 26 28 65 00 2B 28 05 00 23 18 03 00 ?? ?? 85 AC ?? ?? 04 3C 7D 00 40 10 ?? ?? 83 AC 04 00 62 8E 77 00 40 10 ?? ?? 02 3C 04 00 02 92 58 00 AA 8F ?? ?? E4 8E 80 18 02 00 20 00 42 AD 21 38 63 02 00 00 F4 8C 05 00 02 92 21 28 80 02 ?? ?? ?? 0? 21 20 82 00 12 01 40 14 58 00 AA 8F 00 00 02 8E ?? ?? 03 3C ?? ?? 63 8C 28 00 54 AD 24 00 42 AD ?? ?? ?? 0? ?? ?? 10 3C 21 18 00 00 01 00 66 24 2B 10 D0 00 98 FF 40 10 21 10 03 02 42 10 02 00 80 28 02 00 21 28 25 01 00 00 A5 8C 2A 28 85 00 0C 00 A0 10 00 00 00 00 21 80 40 00 2B 10 D0 00 8D FF 40 10 21 10 03 02 42 10 02 00 80 28 02 00 21 28 25 01 00 00 A5 8C 2A 28 85 00 F6 FF A0 14 00 00 00 00 ?? ?? ?? 0? 21 18 40 00 04 00 E2 8C 00 00 22 AE 00 00 E2 8C 3C FF C2 14 44 00 BF 8F 18 00 80 14 04 00 E2 8C 16 00 40 18 54 00 AA 8F 01 00 02 24 ?? ?? ?? 0? 00 00 42 AD 09 00 63 24 2B 10 62 00 05 00 40 10 00 00 00 00 28 00 42 8D 2A 10 82 00 D5 FF 40 10 00 00 00 00 04 00 C6 24 21 48 26 01 21 80 A0 00 04 00 29 25 FC FF 22 8D 2A 10 82 00 FC FF 40 10 01 00 10 26 ?? ?? ?? 0? ?? ?? 14 3C FF 1F 05 3C FE FF A5 34 21 18 65 00 C0 38 03 00 21 38 07 01 04 00 E3 8C 2A 48 62 00 19 FF 20 11 54 00 AA 8F 01 00 09 24 16 FF 80 10 00 00 49 AD 00 00 E7 8C 01 00 E7 24 13 FF E6 14 44 00 BF 8F 01 00 63 24 11 FF 62 14 40 00 BE 8F 01 00 A2 24 21 10 82 00 C0 10 02 00 21 10 02 01 04 00 42 24 01 00 84 24 ?? ?? ?? 0? 02 00 03 24 F4 FF 46 8C FC FF 47 8C 01 00 C6 24 0A 00 E6 14 54 00 AA 8F F8 FF 47 8C 00 00 46 8C 01 00 63 24 01 00 E5 24 16 00 C5 14 F8 FF 42 24 F4 FF 64 14 21 40 60 00 54 00 AA 8F ?? ?? ?? 0? 00 00 43 AD ?? ?? 42 8C ?? ?? ?? 0? 04 00 62 AE ?? ?? 02 3C ?? ?? 43 8C 01 00 02 24 0C 00 62 14 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? E4 8E ?? ?? 0A 3C ?? ?? ?? 0? ?? ?? 42 AD F5 FF 70 24 ?? ?? ?? 0? 21 18 00 00 54 00 A3 8F ?? ?? ?? 0? 00 00 68 AC ?? ?? 04 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 15 03 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 03 3C ?? ?? 64 8C 1D FF 80 10 21 80 40 00 ?? ?? ?? 0? 00 00 00 00 58 00 A6 8F 48 00 A4 27 ?? ?? ?? 0? 21 28 00 00 15 FF 40 10 ?? ?? 50 8E 48 00 A4 8F 58 00 A5 8F 01 00 06 24 ?? ?? ?? 0? ?? ?? 12 3C ?? ?? 10 3C ?? ?? 43 8E ?? ?? 05 8E ?? ?? 15 3C ?? ?? A2 8E C0 20 03 00 21 20 A4 00 B2 FE 82 14 ?? ?? 08 8E ?? ?? 02 3C ?? ?? 43 8C 02 00 02 24 66 00 62 14 ?? ?? 05 3C ?? ?? ?? 0? 00 00 00 00 ?? ?? B5 8E ?? ?? 0A 3C ?? ?? 42 AD ?? ?? ?? 0? 21 20 A0 02 01 00 42 24 ?? ?? ?? 0? 21 20 A2 02 04 00 62 AE ?? ?? ?? 0? ?? ?? 43 8E ?? ?? 10 3C ?? ?? 02 8E 50 00 40 10 ?? ?? 15 3C ?? ?? A2 8E 04 00 43 90 11 00 60 10 21 18 00 00 21 90 00 00 ?? ?? 17 3C 43 00 60 10 ?? ?? E4 8E ?? ?? 03 8E 01 00 52 26 2B 10 43 02 3C 00 40 10 ?? ?? A4 8E C0 10 12 00 21 10 82 00 04 00 48 90 12 00 00 11 00 00 00 00 ?? ?? ?? 0? 04 00 63 8E 21 B0 00 00 21 90 00 00 ?? ?? 17 3C 21 10 56 00 05 00 42 90 ?? ?? E4 8E ?? ?? ?? 0? 21 20 82 00 04 00 63 8E ?? ?? 04 3C 09 00 60 10 ?? ?? 82 AC ?? ?? B0 8E ?? ?? ?? 0? 21 80 16 02 21 10 80 00 20 00 72 10 00 00 00 00 ?? ?? ?? 0? C0 B0 12 00 ?? ?? 04 8E 2B 18 44 02 F5 FF 60 10 ?? ?? A3 8E 21 80 76 00 04 00 08 92 0C 00 00 15 01 00 45 26 C0 40 05 00 21 18 68 00 04 00 63 24 2B 40 A4 00 FC FE 00 11 FC FF 68 24 08 00 63 24 F8 FF 69 90 FA FF 20 11 01 00 A5 24 21 80 00 01 05 00 02 92 ?? ?? E4 8E ?? ?? ?? 0? 21 20 82 00 ?? ?? B0 8E ?? ?? 05 3C 04 00 62 AE ?? ?? A2 8C ?? ?? ?? 0? 21 80 16 02 21 B0 00 00 ?? ?? ?? 0? 21 90 00 00 ?? ?? ?? 0? ?? ?? A2 8E 05 00 42 90 ?? ?? ?? 0? 21 20 82 00 ?? ?? ?? 0? 04 00 62 AE ?? ?? A2 8E 21 B0 00 00 21 90 00 00 ?? ?? ?? 0? ?? ?? 17 3C ?? ?? 04 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 B7 02 06 24 ?? ?? ?? 0? ?? ?? E7 24 04 00 62 8E ?? ?? ?? 0? ?? ?? 62 AC ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 1C 03 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "fgetpwent"
		size = 624
		refs = "0004 __gnu_local_gp 003c _IO_new_fgetpos 0084 __libc_errno 00ac _IO_new_fsetpos 00d8 __fgetpwent_r 00f8 realloc 0114 free 0228 malloc 0260 __lll_lock_wait_private"
	strings:
		$1 = { A0 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 20 00 A5 27 40 00 B2 AF 18 00 BC AF 5C 00 BF AF 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF 3C 00 B1 AF 38 00 B0 AF ?? ?? ?? 0? 21 90 80 00 69 00 40 14 18 00 BC 8F ?? ?? 03 3C ?? ?? 64 24 00 00 82 C0 01 00 41 24 00 00 81 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 7C 00 40 14 00 00 00 00 ?? ?? 11 3C ?? ?? 22 8E 68 00 40 10 00 04 03 24 ?? ?? 97 8F 3B E8 03 7C ?? ?? 13 3C ?? ?? 10 3C ?? ?? 73 26 22 00 14 24 21 F0 E3 02 ?? ?? ?? 0? ?? ?? 15 3C 20 00 A5 27 ?? ?? ?? 0? ?? ?? 22 AE 23 00 40 14 ?? ?? 02 3C ?? ?? A2 8E 21 30 40 00 21 20 40 02 24 00 40 10 21 28 60 02 ?? ?? 07 8E 2C 00 A2 27 ?? ?? ?? 0? 10 00 A2 AF 3D 00 54 14 ?? ?? 02 8E ?? ?? 36 8E 00 04 42 24 21 20 C0 02 21 28 40 00 ?? ?? ?? 0? ?? ?? 02 AE E9 FF 40 14 21 20 40 02 00 00 C5 8F 21 20 C0 02 30 00 A2 AF ?? ?? ?? 0? 34 00 A5 AF 34 00 A5 8F 30 00 A2 8F 21 20 40 02 00 00 C5 AF 20 00 A5 27 ?? ?? ?? 0? ?? ?? 22 AE E1 FF 40 10 ?? ?? A2 8E ?? ?? 02 3C ?? ?? 40 AC 21 10 00 00 21 30 40 00 21 20 40 02 DE FF 40 14 21 28 60 02 2C 00 A0 AF 3B E8 03 7C 21 10 E3 02 00 00 50 8C ?? ?? 03 3C ?? ?? 64 24 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 2A 00 40 10 ?? ?? 64 24 5C 00 BF 8F 3B E8 03 7C 21 10 E3 02 00 00 50 AC 58 00 BE 8F 2C 00 A2 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 60 00 BD 27 ?? ?? 22 8E E0 FF 40 14 00 00 00 00 ?? ?? ?? 0? 2C 00 A0 AF 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 21 10 00 00 08 00 E0 03 60 00 BD 27 ?? ?? 02 3C 00 04 04 24 ?? ?? ?? 0? ?? ?? 43 AC ?? ?? 22 AE ?? ?? ?? 0? 18 00 BC 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 5C 00 BF 8F ?? ?? ?? 0? ?? ?? 64 24 ?? ?? ?? 0? 18 00 BC 8F }
	condition:
		$1
}

rule file_442_0_0 {
	meta:
		name = "fgetsgent"
		size = 624
		refs = "0004 __gnu_local_gp 003c _IO_new_fgetpos 0084 __libc_errno 00ac _IO_new_fsetpos 00d8 __fgetsgent_r 00f8 realloc 0114 free 0228 malloc 0260 __lll_lock_wait_private"
	strings:
		$1 = { A0 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 20 00 A5 27 40 00 B2 AF 18 00 BC AF 5C 00 BF AF 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF 3C 00 B1 AF 38 00 B0 AF ?? ?? ?? 0? 21 90 80 00 69 00 40 14 18 00 BC 8F ?? ?? 03 3C ?? ?? 64 24 00 00 82 C0 01 00 41 24 00 00 81 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 7C 00 40 14 00 00 00 00 ?? ?? 11 3C ?? ?? 22 8E 68 00 40 10 00 04 03 24 ?? ?? 97 8F 3B E8 03 7C ?? ?? 13 3C ?? ?? 10 3C ?? ?? 73 26 22 00 14 24 21 F0 E3 02 ?? ?? ?? 0? ?? ?? 15 3C 20 00 A5 27 ?? ?? ?? 0? ?? ?? 22 AE 23 00 40 14 ?? ?? 02 3C ?? ?? A2 8E 21 30 40 00 21 20 40 02 24 00 40 10 21 28 60 02 ?? ?? 07 8E 2C 00 A2 27 ?? ?? ?? 0? 10 00 A2 AF 3D 00 54 14 ?? ?? 02 8E ?? ?? 36 8E 00 04 42 24 21 20 C0 02 21 28 40 00 ?? ?? ?? 0? ?? ?? 02 AE E9 FF 40 14 21 20 40 02 00 00 C5 8F 21 20 C0 02 30 00 A2 AF ?? ?? ?? 0? 34 00 A5 AF 34 00 A5 8F 30 00 A2 8F 21 20 40 02 00 00 C5 AF 20 00 A5 27 ?? ?? ?? 0? ?? ?? 22 AE E1 FF 40 10 ?? ?? A2 8E ?? ?? 02 3C ?? ?? 40 AC 21 10 00 00 21 30 40 00 21 20 40 02 DE FF 40 14 21 28 60 02 2C 00 A0 AF 3B E8 03 7C 21 10 E3 02 00 00 50 8C ?? ?? 03 3C ?? ?? 64 24 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 2A 00 40 10 ?? ?? 64 24 5C 00 BF 8F 3B E8 03 7C 21 10 E3 02 00 00 50 AC 58 00 BE 8F 2C 00 A2 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 60 00 BD 27 ?? ?? 22 8E E0 FF 40 14 00 00 00 00 ?? ?? ?? 0? 2C 00 A0 AF 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 21 10 00 00 08 00 E0 03 60 00 BD 27 ?? ?? 02 3C 00 04 04 24 ?? ?? ?? 0? ?? ?? 43 AC ?? ?? 22 AE ?? ?? ?? 0? 18 00 BC 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 5C 00 BF 8F ?? ?? ?? 0? ?? ?? 64 24 ?? ?? ?? 0? 18 00 BC 8F }
	condition:
		$1
}

rule file_852_0_0 {
	meta:
		name = "fgetspent"
		size = 624
		refs = "0004 __gnu_local_gp 003c _IO_new_fgetpos 0084 __libc_errno 00ac _IO_new_fsetpos 00d8 __fgetspent_r 00f8 realloc 0114 free 0228 malloc 0260 __lll_lock_wait_private"
	strings:
		$1 = { A0 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 20 00 A5 27 40 00 B2 AF 18 00 BC AF 5C 00 BF AF 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF 3C 00 B1 AF 38 00 B0 AF ?? ?? ?? 0? 21 90 80 00 69 00 40 14 18 00 BC 8F ?? ?? 03 3C ?? ?? 64 24 00 00 82 C0 01 00 41 24 00 00 81 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 7C 00 40 14 00 00 00 00 ?? ?? 11 3C ?? ?? 22 8E 68 00 40 10 00 04 03 24 ?? ?? 97 8F 3B E8 03 7C ?? ?? 13 3C ?? ?? 10 3C ?? ?? 73 26 22 00 14 24 21 F0 E3 02 ?? ?? ?? 0? ?? ?? 15 3C 20 00 A5 27 ?? ?? ?? 0? ?? ?? 22 AE 23 00 40 14 ?? ?? 02 3C ?? ?? A2 8E 21 30 40 00 21 20 40 02 24 00 40 10 21 28 60 02 ?? ?? 07 8E 2C 00 A2 27 ?? ?? ?? 0? 10 00 A2 AF 3D 00 54 14 ?? ?? 02 8E ?? ?? 36 8E 00 04 42 24 21 20 C0 02 21 28 40 00 ?? ?? ?? 0? ?? ?? 02 AE E9 FF 40 14 21 20 40 02 00 00 C5 8F 21 20 C0 02 30 00 A2 AF ?? ?? ?? 0? 34 00 A5 AF 34 00 A5 8F 30 00 A2 8F 21 20 40 02 00 00 C5 AF 20 00 A5 27 ?? ?? ?? 0? ?? ?? 22 AE E1 FF 40 10 ?? ?? A2 8E ?? ?? 02 3C ?? ?? 40 AC 21 10 00 00 21 30 40 00 21 20 40 02 DE FF 40 14 21 28 60 02 2C 00 A0 AF 3B E8 03 7C 21 10 E3 02 00 00 50 8C ?? ?? 03 3C ?? ?? 64 24 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 2A 00 40 10 ?? ?? 64 24 5C 00 BF 8F 3B E8 03 7C 21 10 E3 02 00 00 50 AC 58 00 BE 8F 2C 00 A2 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 60 00 BD 27 ?? ?? 22 8E E0 FF 40 14 00 00 00 00 ?? ?? ?? 0? 2C 00 A0 AF 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 21 10 00 00 08 00 E0 03 60 00 BD 27 ?? ?? 02 3C 00 04 04 24 ?? ?? ?? 0? ?? ?? 43 AC ?? ?? 22 AE ?? ?? ?? 0? 18 00 BC 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 5C 00 BF 8F ?? ?? ?? 0? ?? ?? 64 24 ?? ?? ?? 0? 18 00 BC 8F }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "__getclktck"
		size = 20
		refs = "0000 _dl_clktck"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C 64 00 03 24 08 00 E0 03 0A 10 62 00 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "__pause_nocancel"
		size = 28
	strings:
		$1 = { BD 0F 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_31_1_0 {
	meta:
		name = "__libc_pause"
		size = 124
		refs = "0034 __libc_enable_asynccancel 0054 __libc_disable_asynccancel"
	strings:
		$1 = { 3B E8 03 7C 70 8B 63 8C 08 00 03 14 00 00 00 00 BD 0F 02 24 0C 00 00 00 F0 FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 D0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 2C 00 A2 AF BD 0F 02 24 0C 00 00 00 24 00 A2 AF 28 00 A7 AF 2C 00 A4 8F ?? ?? ?? 0? 00 00 00 00 24 00 A2 8F 28 00 A7 8F 1C 00 BF 8F DC FF E0 14 30 00 BD 27 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_4_1_2 {
	meta:
		name = "__libc_pause"
		size = 124
		refs = "0034 __pthread_enable_asynccancel 0054 __pthread_disable_asynccancel"
	strings:
		$1 = { 3B E8 03 7C 70 8B 63 8C 08 00 03 14 00 00 00 00 BD 0F 02 24 0C 00 00 00 F0 FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 D0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 2C 00 A2 AF BD 0F 02 24 0C 00 00 00 24 00 A2 AF 28 00 A7 AF 2C 00 A4 8F ?? ?? ?? 0? 00 00 00 00 24 00 A2 8F 28 00 A7 8F 1C 00 BF 8F DC FF E0 14 30 00 BD 27 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "getsubopt"
		size = 360
		refs = "0048 __strchrnul 005c memchr 0088 strncmp"
	strings:
		$1 = { C0 FF BD 27 28 00 B4 AF 00 00 94 8C 30 00 B6 AF 3C 00 BF AF 38 00 BE AF 34 00 B7 AF 2C 00 B5 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 00 00 82 82 4A 00 40 10 21 B0 80 00 21 88 A0 00 21 20 80 02 2C 00 05 24 ?? ?? ?? 0? 21 F0 C0 00 23 30 54 00 21 20 80 02 3D 00 05 24 ?? ?? ?? 0? 21 A8 40 00 00 00 30 8E 21 B8 A0 02 11 00 00 12 0B B8 42 00 23 90 F4 02 04 00 31 26 21 98 00 00 21 28 00 02 21 20 80 02 ?? ?? ?? 0? 21 30 40 02 04 00 31 26 04 00 40 14 21 80 12 02 00 00 02 82 19 00 40 10 01 00 E2 26 FC FF 30 8E F4 FF 00 16 01 00 73 26 00 00 D4 AF 00 00 A2 82 0F 00 40 14 00 00 00 00 00 00 D5 AE FF FF 02 24 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 00 00 A0 A2 ?? ?? ?? 0? 01 00 B5 26 26 B8 F5 02 0A 10 17 00 00 00 C2 AF 00 00 A2 82 04 00 40 10 3C 00 BF 8F 00 00 A0 A2 01 00 B5 26 3C 00 BF 8F 00 00 D5 AE 21 10 60 02 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "day_of_the_week"
		size = 296
		refs = "0044 __mon_yday"
	strings:
		$1 = { 14 00 83 8C 10 00 89 8C EB 51 07 3C 6C 07 65 24 02 00 22 29 23 10 A2 00 00 00 46 28 03 00 45 24 0A 28 46 00 1F 85 E7 34 21 30 A0 00 83 28 05 00 18 00 A7 00 BA FF 63 24 C0 50 03 00 80 41 03 00 21 40 48 01 ?? ?? 0A 3C ?? ?? 4A 25 C3 37 06 00 40 48 09 00 21 18 03 01 21 48 2A 01 00 00 2A 95 80 40 03 00 21 18 68 00 27 FE 63 24 C3 47 02 00 21 18 65 00 10 58 00 00 18 00 47 00 C3 38 0B 00 23 30 E6 00 40 49 06 00 C0 38 06 00 23 38 27 01 21 30 E6 00 23 28 A6 00 C2 2F 05 00 0C 00 89 8C 49 92 07 3C 93 24 E7 24 10 10 00 00 43 31 02 00 23 30 06 01 21 18 66 00 C3 11 02 00 23 40 48 00 21 18 65 00 21 18 68 00 21 18 6A 00 21 18 69 00 FF FF 63 24 18 00 67 00 C3 2F 03 00 10 10 00 00 21 10 43 00 83 10 02 00 23 10 45 00 C0 28 02 00 23 10 A2 00 23 10 62 00 07 00 42 24 18 00 47 00 C3 2F 02 00 10 18 00 00 21 18 62 00 83 18 03 00 23 18 65 00 C0 28 03 00 23 18 A3 00 23 10 43 00 08 00 E0 03 18 00 82 AC }
	condition:
		$1
}

rule file_33_1_0 {
	meta:
		name = "__strptime_internal"
		size = 13772
		refs = "041c _nl_C_LC_TIME 0468 __strptime_internal 0a04 $LC1 0b40 strcmp 0b70 strlen 0b8c __strncasecmp_l 1638 __localtime_r 1660 _nl_select_era_entry 1914 $LC0 1948 _nl_parse_alt_digit 2770 __mon_yday 3120 $LC2 1afc $LC3 3134 __assert_fail 3124 __PRETTY_FUNCTION__.7624"
	strings:
		$1 = { 60 FF BD 27 84 00 B3 AF B0 00 B3 8F 8C 00 B5 AF 80 00 B2 AF 78 00 B0 AF 9C 00 BF AF 98 00 BE AF 94 00 B7 AF 90 00 B6 AF 88 00 B4 AF 7C 00 B1 AF 21 80 E0 00 A0 00 A4 AF 21 A8 A0 00 A8 00 A6 AF 32 01 E0 10 08 00 72 8E 04 00 E2 8C 00 00 E3 8C 50 00 A2 AF A8 00 A2 8F 4C 00 A3 AF 20 00 A3 27 20 00 44 24 00 00 4A 8C 04 00 47 8C 08 00 46 8C 0C 00 45 8C 10 00 42 24 00 00 6A AC 04 00 67 AC 08 00 66 AC 0C 00 65 AC F6 FF 44 14 10 00 63 24 00 00 45 8C 04 00 44 8C 08 00 42 8C 20 00 B1 27 00 00 65 AC 04 00 64 AC 08 00 62 AC ?? ?? 14 3C ?? ?? 94 26 ?? ?? 1E 3C 00 00 A2 82 17 00 40 10 00 00 00 00 34 00 66 8E 40 18 02 00 21 18 C3 00 00 00 63 94 00 20 63 30 2B 00 60 10 00 00 00 00 A0 00 A2 8F ?? ?? ?? 0? 00 00 43 80 A0 00 A2 AF 00 00 43 80 40 18 03 00 21 18 C3 00 00 00 63 94 00 20 63 30 F9 FF 60 14 01 00 42 24 01 00 B5 26 00 00 A2 82 EB FF 40 14 00 00 00 00 18 09 00 12 4C 00 A3 8F A8 00 B3 8F 20 00 A2 27 00 00 03 AE 50 00 A3 8F 04 00 03 AE 40 00 A3 27 00 00 47 8C 04 00 46 8C 08 00 45 8C 0C 00 44 8C 10 00 42 24 00 00 67 AE 04 00 66 AE 08 00 65 AE 0C 00 64 AE F6 FF 43 14 10 00 73 26 00 00 44 8C 04 00 43 8C 08 00 42 8C 00 00 64 AE 04 00 63 AE 08 00 62 AE ?? ?? ?? 0? A0 00 A2 8F 25 00 03 24 13 00 43 10 A0 00 A3 8F 01 00 64 24 A0 00 A4 AF 00 00 63 80 C5 FF 62 10 01 00 B5 26 21 10 00 00 9C 00 BF 8F 98 00 BE 8F 94 00 B7 8F 90 00 B6 8F 8C 00 B5 8F 88 00 B4 8F 84 00 B3 8F 80 00 B2 8F 7C 00 B1 8F 78 00 B0 8F 08 00 E0 03 A0 00 BD 27 C9 00 00 12 01 00 A2 26 2D 00 04 24 30 00 09 24 23 00 0A 24 00 00 43 80 0A 00 64 10 00 00 00 00 08 00 69 10 00 00 00 00 FF 00 65 30 A2 FF A7 24 02 00 E7 2C 03 00 E0 14 00 00 00 00 03 00 6A 14 00 00 00 00 ?? ?? ?? 0? 01 00 42 24 D0 FF A5 24 0A 00 A5 2C 0A 00 A0 10 DB FF 63 24 01 00 42 24 00 00 43 80 D0 FF 64 24 FF 00 84 30 0A 00 84 2C FB FF 80 14 01 00 42 24 FF FF 42 24 DB FF 63 24 FF 00 63 30 56 00 64 2C A0 00 B7 8F CF FF 80 10 01 00 55 24 80 18 03 00 21 18 83 02 00 00 63 8C 08 00 60 00 00 00 00 00 A0 00 B7 AF 00 00 E2 82 40 18 02 00 21 18 C3 00 00 00 63 94 00 20 63 30 F9 FF 60 14 01 00 F7 26 D0 FF 42 24 FF 00 42 30 0A 00 42 2C BD FF 40 10 A0 00 A2 8F 03 00 06 24 21 28 40 00 01 00 42 24 A0 00 A2 AF 00 00 A4 80 D0 FF 83 24 40 50 03 00 C0 38 03 00 21 38 47 01 10 27 EA 2C 0F 00 40 11 00 00 00 00 01 00 A5 90 D0 FF A5 24 FF 00 A5 30 0A 00 A5 2C 09 00 A0 10 00 00 00 00 21 28 40 00 01 00 42 24 A0 00 A2 AF 00 00 A4 80 FF FF C6 24 21 20 E4 00 ED FF C0 14 D0 FF 83 24 10 27 63 2C A0 FF 60 10 64 F8 84 24 14 00 24 AE 4C 00 A2 97 01 00 03 24 04 42 02 7C 84 52 62 7C ?? ?? ?? 0? 4C 00 A2 A7 A0 00 B7 AF 00 00 E2 82 40 18 02 00 21 18 C3 00 00 00 63 94 00 20 63 30 F9 FF 60 14 01 00 F7 26 D0 FF 42 24 FF 00 42 30 0A 00 42 2C 8C FF 40 10 A0 00 A2 8F 02 00 06 24 21 20 40 00 01 00 42 24 A0 00 A2 AF 00 00 83 80 D0 FF 65 24 40 38 05 00 C0 28 05 00 21 28 E5 00 6F 01 A7 2C 0F 00 E0 10 00 00 00 00 01 00 84 90 D0 FF 84 24 FF 00 84 30 0A 00 84 2C 0A 00 80 10 CF FF 63 24 21 20 40 00 01 00 42 24 A0 00 A2 AF 00 00 83 80 FF FF C6 24 21 18 65 00 ED FF C0 14 D0 FF 65 24 CF FF 63 24 6E 01 62 2C 6F FF 40 10 21 10 00 00 1C 00 23 AE 4C 00 A2 97 01 00 03 24 84 10 62 7C ?? ?? ?? 0? 4C 00 A2 A7 4C 00 A2 8F 00 10 03 24 00 18 42 30 0D 00 43 10 ?? ?? C3 27 CC 00 45 8E 00 00 A3 80 95 0A 60 14 21 20 E0 02 00 08 03 24 5C FF 43 10 4C 00 A2 97 02 00 03 24 A0 00 B7 AF C4 62 62 7C 4C 00 A2 A7 ?? ?? C3 27 CC 00 65 8C 00 00 A2 80 53 FF 40 10 A0 00 A4 8F 10 00 B3 AF 21 30 20 02 ?? ?? ?? 0? 4C 00 A7 27 11 FF 40 14 A0 00 A2 AF ?? ?? ?? 0? 21 10 00 00 4C 00 A2 8F 00 10 03 24 00 18 42 30 0D 00 43 10 ?? ?? C3 27 C8 00 45 8E 00 00 A3 80 64 0A 60 14 21 20 E0 02 00 08 03 24 3F FF 43 10 4C 00 A2 97 02 00 03 24 A0 00 B7 AF C4 62 62 7C 4C 00 A2 A7 ?? ?? C3 27 C8 00 65 8C 00 00 A2 80 37 FF 40 10 21 10 00 00 A0 00 A4 8F 10 00 B3 AF 21 30 20 02 ?? ?? ?? 0? 4C 00 A7 27 2F FF 40 10 A0 00 A2 AF 4C 00 A2 97 01 00 03 24 84 52 62 7C ?? ?? ?? 0? 4C 00 A2 A7 ?? ?? ?? 0? 01 00 A3 82 FF FF 02 24 4C 00 A0 AF 50 00 A2 AF 4F 00 A2 A3 ?? ?? ?? 0? 21 88 C0 00 00 00 E3 82 01 00 E2 26 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 0A 00 80 10 21 28 E0 02 A0 00 A2 AF 00 00 43 80 21 28 40 00 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 F8 FF 80 14 01 00 42 24 D0 FF 62 24 FF 00 42 30 0A 00 42 2C 0C FF 40 10 01 00 A2 24 A0 00 A2 AF 00 00 A2 80 D0 FF 42 24 40 20 02 00 C0 18 02 00 21 18 83 00 36 00 64 2C 0C 00 80 10 00 00 00 00 01 00 A4 90 D0 FF 84 24 FF 00 84 30 0A 00 84 2C 06 00 80 10 00 00 00 00 02 00 A2 24 A0 00 A2 AF 01 00 A2 80 D0 FF 42 24 21 10 43 00 36 00 43 2C F5 FE 60 10 4C 00 A3 97 4E 00 A2 A3 01 00 02 24 44 29 43 7C ?? ?? ?? 0? 4C 00 A3 A7 00 00 E3 82 01 00 E2 26 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 0A 00 80 10 21 28 E0 02 A0 00 A2 AF 00 00 43 80 21 28 40 00 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 F8 FF 80 14 01 00 42 24 D0 FF 62 24 FF 00 42 30 0A 00 42 2C DA FE 40 10 01 00 A2 24 A0 00 A2 AF 00 00 A2 80 D0 FF 42 24 40 20 02 00 C0 18 02 00 21 18 83 00 36 00 64 2C 0C 00 80 10 00 00 00 00 01 00 A4 90 D0 FF 84 24 FF 00 84 30 0A 00 84 2C 07 00 80 10 36 00 42 2C 02 00 A2 24 A0 00 A2 AF 01 00 A2 80 D0 FF 42 24 21 10 43 00 36 00 42 2C 87 FE 40 14 21 10 00 00 ?? ?? ?? 0? 9C 00 BF 8F 00 00 E3 82 01 00 E2 26 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 0A 00 80 10 21 28 E0 02 A0 00 A2 AF 00 00 43 80 21 28 40 00 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 F8 FF 80 14 01 00 42 24 2B 00 02 24 03 00 62 10 2D 00 02 24 AC FE 62 14 21 10 00 00 01 00 A4 24 A0 00 A4 AF 00 00 A6 80 21 18 00 00 21 10 00 00 04 00 07 24 00 00 85 90 D0 FF A5 24 FF 00 A5 30 0A 00 A5 2C B9 09 A0 10 01 00 84 24 A0 00 A4 AF 40 50 02 00 FF FF 85 80 C0 10 02 00 21 10 42 01 D0 FF 42 24 01 00 63 24 F2 FF 67 14 21 10 45 00 EB 51 04 3C 1F 85 84 34 19 00 44 00 10 20 00 00 42 21 04 00 80 18 04 00 00 21 04 00 21 18 64 00 80 20 03 00 21 18 64 00 23 10 43 00 3C 00 44 2C 88 FE 80 10 40 20 02 00 C0 10 02 00 21 10 82 00 80 20 02 00 21 10 44 00 88 88 04 3C 89 88 84 34 19 00 44 00 10 10 00 00 02 11 02 00 21 10 43 00 B1 04 43 2C 7B FE 60 10 00 19 02 00 00 12 02 00 23 10 43 00 00 19 02 00 23 10 62 00 EB 51 03 3C 1F 85 63 34 19 00 43 00 2D 00 03 24 10 10 00 00 50 04 C3 10 42 11 02 00 ?? ?? ?? 0? 24 00 22 AE ?? ?? ?? 0? 00 00 E2 82 A0 00 B7 AF 00 00 E2 82 40 10 02 00 21 10 C2 00 00 00 42 94 00 20 42 30 F9 FF 40 14 01 00 F7 26 ?? ?? ?? 0? 00 00 A2 82 00 00 E3 82 01 00 E2 26 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 0A 00 80 10 21 28 E0 02 A0 00 A2 AF 00 00 43 80 21 28 40 00 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 F8 FF 80 14 01 00 42 24 D0 FF 62 24 FF 00 42 30 0A 00 42 2C 4C FE 40 10 01 00 A2 24 A0 00 A2 AF 00 00 A3 80 D0 FF 62 24 40 30 02 00 C0 20 02 00 21 20 C4 00 0D 00 86 2C 0C 00 C0 10 00 00 00 00 01 00 A6 90 D0 FF C6 24 FF 00 C6 30 0A 00 C6 2C 07 00 C0 10 CF FF 63 24 02 00 A2 24 A0 00 A2 AF 01 00 A3 80 21 18 83 00 D0 FF 62 24 CF FF 63 24 0C 00 63 2C 34 FE 60 10 AA AA 03 3C AB AA 63 34 19 00 43 00 10 18 00 00 C2 18 03 00 80 20 03 00 00 19 03 00 23 18 64 00 23 10 43 00 08 00 22 AE 4C 00 A2 97 01 00 03 24 04 00 62 7C ?? ?? ?? 0? 4C 00 A2 A7 00 00 E3 82 01 00 E2 26 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 0A 00 80 10 21 28 E0 02 A0 00 A2 AF 00 00 43 80 21 28 40 00 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 F8 FF 80 14 01 00 42 24 D0 FF 62 24 FF 00 42 30 0A 00 42 2C 10 FE 40 10 01 00 A2 24 A0 00 A2 AF 00 00 A2 80 D0 FF 42 24 40 20 02 00 C0 18 02 00 21 18 83 00 3C 00 64 2C 0C 00 80 10 00 00 00 00 01 00 A4 90 D0 FF 84 24 FF 00 84 30 0A 00 84 2C 06 00 80 10 00 00 00 00 02 00 A2 24 A0 00 A2 AF 01 00 A2 80 D0 FF 42 24 21 10 43 00 3C 00 43 2C F9 FD 60 10 00 00 00 00 ?? ?? ?? 0? 04 00 22 AE 01 00 43 90 02 00 55 24 B8 FF 62 24 FF 00 42 30 32 00 43 2C F0 FD 60 10 ?? ?? 03 3C 80 10 02 00 ?? ?? 63 24 21 10 62 00 00 00 42 8C 08 00 40 00 00 00 00 00 ?? ?? 05 3C 10 00 B3 AF 21 20 E0 02 ?? ?? A5 24 21 30 20 02 ?? ?? ?? 0? 4C 00 A7 27 A5 FD 40 14 A0 00 A2 AF ?? ?? ?? 0? 21 10 00 00 00 00 E3 82 01 00 E2 26 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 0A 00 80 10 21 28 E0 02 A0 00 A2 AF 00 00 43 80 21 28 40 00 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 F8 FF 80 14 01 00 42 24 D0 FF 62 24 FF 00 42 30 0A 00 42 2C C9 FD 40 10 01 00 A2 24 A0 00 A2 AF 00 00 A2 80 D0 FF 42 24 40 20 02 00 C0 18 02 00 21 18 83 00 3E 00 64 2C 0C 00 80 10 00 00 00 00 01 00 A4 90 D0 FF 84 24 FF 00 84 30 0A 00 84 2C 06 00 80 10 00 00 00 00 02 00 A2 24 A0 00 A2 AF 01 00 A2 80 D0 FF 42 24 21 10 43 00 3E 00 43 2C B2 FD 60 10 00 00 00 00 ?? ?? ?? 0? 00 00 22 AE 4C 00 A2 8F ?? ?? 16 3C ?? ?? D6 26 C0 0A 48 7C FF FF 03 24 58 00 B6 AF 64 00 A8 AF 60 00 A3 AF 21 B0 00 00 ?? ?? ?? 0? 5C 00 A0 AF 5C 00 A3 8F 21 50 EA 02 2B 10 6A 00 6F 00 40 10 4C 00 A2 8F 00 18 42 30 85 07 40 14 58 00 A8 8F 24 00 64 8D 00 00 05 8D ?? ?? ?? 0? 68 00 AA AF 68 00 AA 8F A0 00 B7 8F 60 00 B6 AF 03 00 40 10 5C 00 AA AF 01 00 03 24 64 00 A3 AF 58 00 A8 8F 30 00 05 8D 21 20 A0 00 ?? ?? ?? 0? 68 00 A5 AF 68 00 A5 8F 21 30 40 00 21 38 60 02 21 20 A0 00 21 28 E0 02 ?? ?? ?? 0? 68 00 A2 AF 34 06 40 14 68 00 AA 8F 5C 00 A3 8F 21 50 EA 02 2B 10 6A 00 30 06 40 10 58 00 A8 8F 02 00 03 24 60 00 B6 AF 5C 00 AA AF 64 00 A3 AF 58 00 A8 8F 01 00 D6 26 0C 00 02 24 04 00 08 25 4A 07 C2 12 58 00 A8 AF A0 00 B7 8F 4C 00 A2 8F 00 18 42 30 00 10 04 24 DE FF 44 10 02 00 05 3C 1A 00 A5 34 21 58 C5 02 FF FF 6B 31 80 58 0B 00 21 58 4B 02 24 00 65 8D 70 00 AB AF 21 20 A0 00 ?? ?? ?? 0? 68 00 A5 AF 68 00 A5 8F 21 30 40 00 21 38 60 02 21 20 A0 00 21 28 E0 02 ?? ?? ?? 0? 68 00 A2 AF 68 00 AA 8F 13 00 40 14 70 00 AB 8F 5C 00 A8 8F 21 50 EA 02 2B 10 0A 01 0F 00 40 10 02 00 02 3C 4C 00 A2 8F 00 18 42 30 37 07 40 14 58 00 A3 8F 24 00 64 8D 60 00 B6 AF 30 00 65 8C ?? ?? ?? 0? 5C 00 AA AF 64 00 A8 8F 01 00 04 24 0B 40 82 00 64 00 A8 AF 02 00 02 3C 0E 00 42 34 21 58 C2 02 FF FF 6B 31 80 58 0B 00 21 58 4B 02 24 00 65 8D A0 00 B7 8F 70 00 AB AF 21 20 A0 00 ?? ?? ?? 0? 68 00 A5 AF 68 00 A5 8F 21 30 40 00 21 38 60 02 21 20 A0 00 21 28 E0 02 ?? ?? ?? 0? 68 00 A2 AF 68 00 AA 8F 8F FF 40 10 70 00 AB 8F 4C 00 A2 8F 00 18 42 30 00 08 04 24 B5 FF 44 10 58 00 A8 8F ?? ?? ?? 0? A0 00 B7 8F 4C 00 A2 8F 00 10 03 24 00 18 42 30 0D 00 43 10 ?? ?? C3 27 C4 00 45 8E 00 00 A3 80 2B 08 60 14 21 20 E0 02 00 08 03 24 20 FD 43 10 4C 00 A2 97 02 00 03 24 A0 00 B7 AF C4 62 62 7C 4C 00 A2 A7 ?? ?? C3 27 C4 00 65 8C 00 00 A2 80 E3 FD 40 14 A0 00 A4 8F ?? ?? ?? 0? 21 10 00 00 00 00 E3 82 01 00 E2 26 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 0A 00 80 10 21 28 E0 02 A0 00 A2 AF 00 00 43 80 21 28 40 00 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 F8 FF 80 14 01 00 42 24 D0 FF 62 24 FF 00 42 30 0A 00 42 2C FF FC 40 10 01 00 A2 24 A0 00 A2 AF 00 00 A2 80 D0 FF 42 24 40 20 02 00 C0 18 02 00 21 18 83 00 64 00 64 2C 0C 00 80 10 00 00 00 00 01 00 A4 90 D0 FF 84 24 FF 00 84 30 0A 00 84 2C 07 00 80 10 64 00 42 2C 02 00 A2 24 A0 00 A2 AF 01 00 A2 80 D0 FF 42 24 21 10 43 00 64 00 42 2C AC FC 40 14 21 10 00 00 ?? ?? ?? 0? 9C 00 BF 8F 00 00 E3 82 01 00 E2 26 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 0A 00 80 10 21 28 E0 02 A0 00 A2 AF 00 00 43 80 21 28 40 00 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 F8 FF 80 14 01 00 42 24 D0 FF 62 24 FF 00 42 30 0A 00 42 2C D0 FC 40 10 01 00 A2 24 A0 00 A2 AF 00 00 A2 80 D0 FF 44 24 40 18 04 00 C0 20 04 00 21 18 64 00 0D 00 64 2C 0B 00 80 10 00 00 00 00 01 00 A4 90 D0 FF 84 24 FF 00 84 30 0A 00 84 2C 06 00 80 10 CF FF 42 24 02 00 A2 24 A0 00 A2 AF 01 00 A2 80 21 10 62 00 CF FF 42 24 0C 00 43 2C B9 FC 60 10 00 00 00 00 10 00 22 AE 4C 00 A2 97 01 00 03 24 C4 18 62 7C 84 52 62 7C ?? ?? ?? 0? 4C 00 A2 A7 00 00 E3 82 01 00 E2 26 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 0A 00 80 10 21 28 E0 02 A0 00 A2 AF 00 00 43 80 21 28 40 00 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 F8 FF 80 14 01 00 42 24 D0 FF 62 24 FF 00 42 30 0A 00 42 2C 9C FC 40 10 01 00 A2 24 A0 00 A2 AF 00 00 A3 80 D0 FF 62 24 40 30 02 00 C0 20 02 00 21 20 C4 00 20 00 86 2C 0C 00 C0 10 00 00 00 00 01 00 A6 90 D0 FF C6 24 FF 00 C6 30 0A 00 C6 2C 07 00 C0 10 CF FF 63 24 02 00 A2 24 A0 00 A2 AF 01 00 A3 80 21 18 83 00 D0 FF 62 24 CF FF 63 24 1F 00 63 2C 84 FC 60 10 00 00 00 00 0C 00 22 AE 4C 00 A2 97 01 00 03 24 04 21 62 7C 84 52 62 7C ?? ?? ?? 0? 4C 00 A2 A7 00 00 E3 82 01 00 E2 26 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 0A 00 80 10 21 28 E0 02 A0 00 A2 AF 00 00 43 80 21 28 40 00 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 F8 FF 80 14 01 00 42 24 D0 FF 62 24 }
	condition:
		$1
}

rule file_33_2_0 {
	meta:
		name = "__strptime_l"
		size = 32
		refs = "000c __strptime_internal"
	strings:
		$1 = { D8 FF BD 27 10 00 A7 AF 24 00 BF AF ?? ?? ?? 0? 21 38 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_1491_1_0 {
	meta:
		name = "__strtol_l"
		size = 32
		refs = "000c ____strtol_l_internal"
	strings:
		$1 = { D8 FF BD 27 10 00 A7 AF 24 00 BF AF ?? ?? ?? 0? 21 38 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_1389_1_0 {
	meta:
		name = "__strtoll_l"
		size = 32
		refs = "000c ____strtoll_l_internal"
	strings:
		$1 = { D8 FF BD 27 10 00 A7 AF 24 00 BF AF ?? ?? ?? 0? 21 38 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_825_1_0 {
	meta:
		name = "__strtoul_l"
		size = 32
		refs = "000c ____strtoul_l_internal"
	strings:
		$1 = { D8 FF BD 27 10 00 A7 AF 24 00 BF AF ?? ?? ?? 0? 21 38 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_1298_1_0 {
	meta:
		name = "__strtoull_l"
		size = 32
		refs = "000c ____strtoull_l_internal"
	strings:
		$1 = { D8 FF BD 27 10 00 A7 AF 24 00 BF AF ?? ?? ?? 0? 21 38 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_1408_1_0 {
	meta:
		name = "__wcstol_l"
		size = 32
		refs = "000c ____wcstol_l_internal"
	strings:
		$1 = { D8 FF BD 27 10 00 A7 AF 24 00 BF AF ?? ?? ?? 0? 21 38 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_391_1_0 {
	meta:
		name = "__wcstoll_l"
		size = 32
		refs = "000c ____wcstoll_l_internal"
	strings:
		$1 = { D8 FF BD 27 10 00 A7 AF 24 00 BF AF ?? ?? ?? 0? 21 38 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_1238_1_0 {
	meta:
		name = "__wcstoul_l"
		size = 32
		refs = "000c ____wcstoul_l_internal"
	strings:
		$1 = { D8 FF BD 27 10 00 A7 AF 24 00 BF AF ?? ?? ?? 0? 21 38 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_543_1_0 {
	meta:
		name = "__wcstoull_l"
		size = 32
		refs = "000c ____wcstoull_l_internal"
	strings:
		$1 = { D8 FF BD 27 10 00 A7 AF 24 00 BF AF ?? ?? ?? 0? 21 38 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "jrand48"
		size = 40
		refs = "0010 __jrand48_r 0004 __libc_drand48_data"
	strings:
		$1 = { D8 FF BD 27 ?? ?? 05 3C 18 00 A6 27 24 00 BF AF ?? ?? ?? 0? ?? ?? A5 24 24 00 BF 8F 18 00 A2 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_443_0_0 {
	meta:
		name = "nrand48"
		size = 40
		refs = "0010 __nrand48_r 0004 __libc_drand48_data"
	strings:
		$1 = { D8 FF BD 27 ?? ?? 05 3C 18 00 A6 27 24 00 BF AF ?? ?? ?? 0? ?? ?? A5 24 24 00 BF 8F 18 00 A2 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "_longjmp_unwind"
		size = 56
		refs = "0000 __pthread_cleanup_upto"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 09 00 40 10 00 00 00 00 F8 FF BD 27 04 00 BE AF 21 F0 A0 03 21 E8 C0 03 21 28 C0 03 04 00 BE 8F ?? ?? ?? 0? 08 00 BD 27 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "mabort"
		size = 204
		refs = "002c _libc_intl_domainname 0028 $LC2 0038 __dcgettext 0040 __libc_fatal 004c $LC1 006c $LC0 0090 $LC4 00b0 $LC3"
	strings:
		$1 = { E0 FF BD 27 01 00 02 24 28 00 82 10 1C 00 BF AF 02 00 82 28 14 00 40 14 02 00 02 24 0A 00 82 10 03 00 02 24 19 00 82 14 ?? ?? 05 3C ?? ?? 04 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? ?? 0? 21 20 40 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? ?? 0? 00 00 00 00 08 00 80 14 ?? ?? 05 3C ?? ?? 04 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_36_1_0 {
	meta:
		name = "checkhdr.part.0"
		size = 180
	strings:
		$1 = { 0C 00 85 8C 08 00 83 8C 04 00 82 8C D8 FF BD 27 21 18 A3 00 26 18 62 00 67 D8 02 3C 09 53 42 24 24 00 BF AF 21 00 62 10 20 00 B0 AF DA FE 02 3C EB BE 42 34 10 00 62 10 00 00 00 00 02 00 02 24 ?? ?? 03 3C ?? ?? 79 8C ?? ?? 10 3C 21 20 40 00 18 00 A2 AF 09 F8 20 03 ?? ?? 00 AE 18 00 A2 8F 01 00 03 24 ?? ?? 03 AE 24 00 BF 8F 20 00 B0 8F 08 00 E0 03 28 00 BD 27 00 00 85 8C 21 28 85 00 18 00 A6 80 D7 FF 05 24 ED FF C5 14 03 00 02 24 10 00 85 8C 14 00 84 8C 26 20 A4 00 E8 FF 83 14 02 00 02 24 ?? ?? ?? 0? 21 10 00 00 ?? ?? ?? 0? 01 00 02 24 }
	condition:
		$1
}

rule file_36_2_0 {
	meta:
		name = "unlink_blk.isra.1"
		size = 88
	strings:
		$1 = { 08 00 A0 10 DA FE 03 3C 00 00 82 8C 0C 00 A6 8C EB BE 63 34 21 30 46 00 26 18 C3 00 08 00 A2 AC 04 00 A3 AC 00 00 82 8C 08 00 40 10 DA FE 03 3C 08 00 44 8C EB BE 63 34 21 20 A4 00 26 18 83 00 0C 00 45 AC 08 00 E0 03 04 00 43 AC ?? ?? 02 3C 08 00 E0 03 ?? ?? 45 AC }
	condition:
		$1
}

rule file_36_3_0 {
	meta:
		name = "memalignhook"
		size = 424
		refs = "0008 __gnu_local_gp 0058 __memalign_hook 00fc memset 0128 mcheck_check_all 0160 __libc_errno 0190 memalign"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C ?? ?? 1C 3C D0 FF BD 27 ?? ?? 9C 27 20 00 B0 AF 2C 00 BF AF 28 00 B2 AF 24 00 B1 AF 10 00 BC AF 3E 00 40 14 21 80 A0 00 17 00 82 24 23 88 04 00 24 88 22 02 01 00 22 26 27 10 02 00 2B 10 50 00 43 00 40 14 00 00 00 00 ?? ?? 02 3C ?? ?? 59 8C ?? ?? 12 3C 01 00 05 26 ?? ?? 59 AE 4A 00 20 13 21 28 B1 00 09 F8 20 03 00 00 00 00 21 28 40 00 ?? ?? 02 3C ?? ?? 42 24 47 00 A0 10 ?? ?? 42 AE ?? ?? 02 3C ?? ?? 44 8C DA FE 06 3C E8 FF 23 26 EB BE C6 34 21 18 A3 00 26 38 86 00 00 00 70 AC 08 00 60 AC 0C 00 64 AC ?? ?? 43 AC 06 00 80 10 04 00 67 AC 0C 00 82 8C 08 00 83 AC 21 10 62 00 26 30 46 00 04 00 86 AC DA FE 04 3C EB BE 84 34 26 20 A4 00 18 00 67 24 10 00 65 AC 14 00 64 AC 21 10 70 00 D7 FF 03 24 21 20 E0 00 18 00 43 A0 93 FF 05 24 ?? ?? ?? 0? 21 30 00 02 21 38 40 00 2C 00 BF 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 21 10 E0 00 08 00 E0 03 30 00 BD 27 18 00 A4 AF ?? ?? ?? 0? 1C 00 A6 AF 18 00 A4 8F 10 00 BC 8F 17 00 82 24 23 88 04 00 24 88 22 02 01 00 22 26 27 10 02 00 2B 10 50 00 BF FF 40 10 1C 00 A6 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 2C 00 BF 8F 21 38 00 00 21 10 62 00 0C 00 03 24 00 00 43 AC 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 21 10 E0 00 08 00 E0 03 30 00 BD 27 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 28 40 00 ?? ?? ?? 0? 21 38 00 00 }
	condition:
		$1
}

rule file_36_4_0 {
	meta:
		name = "mallochook"
		size = 352
		refs = "0008 __gnu_local_gp 004c __malloc_hook 00d8 memset 00fc mcheck_check_all 011c __libc_errno 0148 malloc"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C ?? ?? 1C 3C D0 FF BD 27 ?? ?? 9C 27 24 00 B0 AF 2C 00 BF AF 28 00 B1 AF 10 00 BC AF 35 00 40 14 21 80 80 00 E7 FF 02 2E 38 00 40 10 00 00 00 00 ?? ?? 02 3C ?? ?? 59 8C ?? ?? 11 3C 19 00 04 26 3F 00 20 13 ?? ?? 39 AE 09 F8 20 03 00 00 00 00 21 18 40 00 ?? ?? 02 3C ?? ?? 42 24 3C 00 60 10 ?? ?? 22 AE ?? ?? 04 3C ?? ?? 82 8C DA FE 05 3C EB BE A5 34 26 30 45 00 00 00 70 AC 08 00 60 AC 0C 00 62 AC ?? ?? 83 AC 06 00 40 10 04 00 66 AC 0C 00 44 8C 08 00 43 AC 21 20 83 00 26 28 85 00 04 00 45 AC DA FE 04 3C EB BE 84 34 26 20 64 00 18 00 67 24 14 00 64 AC 21 10 70 00 10 00 63 AC D7 FF 03 24 21 20 E0 00 18 00 43 A0 93 FF 05 24 ?? ?? ?? 0? 21 30 00 02 21 38 40 00 2C 00 BF 8F 28 00 B1 8F 24 00 B0 8F 21 10 E0 00 08 00 E0 03 30 00 BD 27 ?? ?? ?? 0? 18 00 A5 AF E7 FF 02 2E 10 00 BC 8F CA FF 40 14 18 00 A5 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 2C 00 BF 8F 21 38 00 00 21 10 62 00 0C 00 03 24 00 00 43 AC 28 00 B1 8F 24 00 B0 8F 21 10 E0 00 08 00 E0 03 30 00 BD 27 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 18 40 00 ?? ?? ?? 0? 21 38 00 00 }
	condition:
		$1
}

rule file_36_5_0 {
	meta:
		name = "freehook"
		size = 260
		refs = "0068 memset 0088 __free_hook 00b8 mcheck_check_all 00d8 free"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C D8 FF BD 27 20 00 B2 AF 18 00 B0 AF 24 00 BF AF 1C 00 B1 AF 21 80 80 00 25 00 40 14 21 90 A0 00 12 00 00 12 ?? ?? 02 3C ?? ?? 42 8C 24 00 40 14 00 00 00 00 F4 FF 05 8E 67 D8 02 3C 09 53 42 24 F0 FF 04 26 EC FF 02 AE ?? ?? ?? 0? FC FF 02 AE E8 FF 06 8E F4 FF 00 AE F0 FF 00 AE 21 20 00 02 ?? ?? ?? 0? 95 FF 05 24 F8 FF 10 8E ?? ?? 02 3C ?? ?? 59 8C ?? ?? 11 3C 21 20 00 02 14 00 20 13 ?? ?? 39 AE 09 F8 20 03 21 28 40 02 24 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 20 00 B2 8F 18 00 B0 8F ?? ?? 22 AE 1C 00 B1 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? E8 FF 04 26 ?? ?? ?? 0? F4 FF 05 8E ?? ?? ?? 0? 00 00 00 00 24 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 20 00 B2 8F 18 00 B0 8F ?? ?? 22 AE 1C 00 B1 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_36_6_0 {
	meta:
		name = "reallochook"
		size = 604
		refs = "0000 __gnu_local_gp 00b0 __free_hook 00c4 __malloc_hook 00c8 __memalign_hook 00cc __realloc_hook 01c4 memset 01d4 mcheck_check_all 0214 realloc 022c __libc_errno"
	strings:
		$1 = { ?? ?? 1C 3C C0 FF BD 27 ?? ?? 9C 27 34 00 B7 AF 1C 00 B1 AF 3C 00 BF AF 38 00 BE AF 30 00 B6 AF 2C 00 B5 AF 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 18 00 B0 AF 10 00 BC AF 21 88 A0 00 81 00 A0 10 21 B8 C0 00 ?? ?? 02 3C ?? ?? 42 8C 61 00 40 14 21 80 80 00 E7 FF 22 2E 72 00 40 10 00 00 00 00 69 00 00 12 ?? ?? 02 3C ?? ?? 42 8C E8 FF 16 26 61 00 40 14 E8 FF 12 8E F4 FF 05 8E ?? ?? ?? 0? F0 FF 04 26 2B 10 32 02 56 00 40 14 21 20 11 02 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 02 3C ?? ?? 43 8C ?? ?? 05 3C ?? ?? 02 3C ?? ?? B9 8C ?? ?? 42 8C ?? ?? 1E 3C ?? ?? 15 3C ?? ?? 14 3C ?? ?? 13 3C ?? ?? C4 AF ?? ?? A3 AE ?? ?? 82 AE ?? ?? 79 AE 21 20 C0 02 4F 00 20 13 19 00 25 26 09 F8 20 03 21 30 E0 02 21 80 40 00 ?? ?? 02 3C ?? ?? 42 24 ?? ?? C2 AF ?? ?? 02 3C ?? ?? 42 24 ?? ?? A2 AE ?? ?? 02 3C ?? ?? 42 24 ?? ?? 82 AE ?? ?? 02 3C ?? ?? 42 24 4F 00 00 12 ?? ?? 62 AE ?? ?? 03 3C ?? ?? 62 8C DA FE 04 3C EB BE 84 34 26 28 44 00 00 00 11 AE 08 00 00 AE 0C 00 02 AE ?? ?? 70 AC 06 00 40 10 04 00 05 AE 0C 00 43 8C 08 00 50 AC 21 18 70 00 26 20 64 00 04 00 44 AC DA FE 04 3C EB BE 84 34 26 20 04 02 14 00 04 AE 21 18 11 02 D7 FF 04 24 2B 10 51 02 10 00 10 AE 0E 00 40 14 18 00 64 A0 18 00 02 26 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 18 00 44 26 21 20 04 02 93 FF 05 24 ?? ?? ?? 0? 23 30 32 02 ?? ?? ?? 0? 18 00 02 26 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 10 00 BC 8F 95 FF 05 24 ?? ?? ?? 0? 23 30 51 02 ?? ?? ?? 0? ?? ?? 02 3C ?? ?? ?? 0? 21 20 C0 02 ?? ?? ?? 0? F4 FF 05 8E 21 90 00 00 ?? ?? ?? 0? 21 B0 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 80 40 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 0C 00 03 24 00 00 43 AC ?? ?? ?? 0? 21 10 00 00 ?? ?? ?? 0? 21 28 C0 00 ?? ?? ?? 0? 21 10 00 00 ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_36_7_0 {
	meta:
		name = "mcheck_check_all"
		size = 124
	strings:
		$1 = { D8 FF BD 27 ?? ?? 02 3C 18 00 B0 AF ?? ?? 50 8C 20 00 B2 AF ?? ?? 12 3C 24 00 BF AF 1C 00 B1 AF 0E 00 00 12 ?? ?? 40 AE ?? ?? ?? 0? ?? ?? 11 3C 0C 00 10 8E 0A 00 00 12 24 00 BF 8F ?? ?? 22 8E FB FF 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 0C 00 10 8E FA FF 00 16 ?? ?? 22 8E 24 00 BF 8F 01 00 02 24 1C 00 B1 8F 18 00 B0 8F ?? ?? 42 AE 20 00 B2 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_36_8_0 {
	meta:
		name = "mcheck"
		size = 252
		refs = "0014 __libc_malloc_initialized 0060 malloc 006c free 0074 __free_hook 007c __malloc_hook 00a0 __memalign_hook 00bc __realloc_hook"
	strings:
		$1 = { D0 FF BD 27 2C 00 BF AF 28 00 B1 AF 38 00 80 10 24 00 B0 AF ?? ?? 02 3C ?? ?? 42 8C ?? ?? 03 3C 0B 00 40 18 ?? ?? 64 AC ?? ?? 02 3C ?? ?? 50 8C 01 00 10 2E 23 80 10 00 2C 00 BF 8F 21 10 00 02 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? 11 3C ?? ?? 22 8E F7 FF 40 14 21 80 00 00 ?? ?? ?? 0? 21 20 00 00 18 00 A2 AF ?? ?? ?? 0? 18 00 A4 8F ?? ?? 05 3C ?? ?? AA 8C ?? ?? 04 3C ?? ?? 09 3C ?? ?? 88 8C ?? ?? 2A AD ?? ?? 09 3C ?? ?? 29 25 ?? ?? 03 3C ?? ?? A9 AC ?? ?? 05 3C ?? ?? 67 8C ?? ?? A8 AC ?? ?? 05 3C ?? ?? A5 24 ?? ?? 02 3C ?? ?? 85 AC ?? ?? 04 3C ?? ?? 46 8C ?? ?? 87 AC ?? ?? 04 3C ?? ?? 84 24 ?? ?? 64 AC ?? ?? 03 3C ?? ?? 66 AC ?? ?? 03 3C ?? ?? 63 24 ?? ?? 43 AC 01 00 02 24 ?? ?? ?? 0? ?? ?? 22 AE ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 }
	condition:
		$1
}

rule file_36_9_0 {
	meta:
		name = "mcheck_pedantic"
		size = 44
		refs = "0008 mcheck"
	strings:
		$1 = { E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 03 00 40 14 01 00 04 24 ?? ?? 03 3C ?? ?? 64 AC 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1383_0_0 {
	meta:
		name = "_IO_str_chk_overflow"
		size = 16
		refs = "0008 __chk_fail"
	strings:
		$1 = { E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_510_0_0 {
	meta:
		name = "__stack_chk_fail_local"
		size = 16
		refs = "0008 __stack_chk_fail"
	strings:
		$1 = { E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_257_1_0 {
	meta:
		name = "_dl_start"
		size = 16
		refs = "0008 abort"
	strings:
		$1 = { E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_66_0_2 {
	meta:
		name = "longjmp"
		size = 16
		refs = "0008 __libc_longjmp"
	strings:
		$1 = { E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_828_4_0 {
	meta:
		name = "svctcp_rendezvous_abort"
		size = 16
		refs = "0008 abort"
	strings:
		$1 = { E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_167_4_0 {
	meta:
		name = "svcunix_rendezvous_abort"
		size = 16
		refs = "0008 abort"
	strings:
		$1 = { E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_36_10_0 {
	meta:
		name = "mprobe"
		size = 32
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C 03 00 40 10 00 00 00 00 ?? ?? ?? 0? E8 FF 84 24 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "_create_xid"
		size = 284
		refs = "0044 getpid 0060 __gettimeofday 007c __srand48_r 008c lrand48_r 00e8 __lll_lock_wait_private"
	strings:
		$1 = { C8 FF BD 27 20 00 B0 AF ?? ?? 10 3C ?? ?? 03 26 34 00 BF AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 2A 00 40 14 00 00 00 00 ?? ?? ?? 0? ?? ?? 12 3C ?? ?? 43 8E 21 88 40 00 22 00 62 10 18 00 B3 27 21 20 60 02 ?? ?? ?? 0? 21 28 00 00 18 00 A2 8F 1C 00 A4 8F ?? ?? 14 3C ?? ?? 85 26 26 20 82 00 ?? ?? ?? 0? 26 20 91 00 ?? ?? 51 AE ?? ?? 84 26 ?? ?? ?? 0? 21 28 60 02 ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 10 00 40 10 ?? ?? 04 26 34 00 BF 8F 18 00 A2 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? ?? ?? 14 3C ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "alphasort64"
		size = 20
		refs = "000c strcoll"
	strings:
		$1 = { 00 00 84 8C 00 00 A5 8C 13 00 84 24 ?? ?? ?? 0? 13 00 A5 24 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "versionsort64"
		size = 20
		refs = "000c __strverscmp"
	strings:
		$1 = { 00 00 84 8C 00 00 A5 8C 13 00 84 24 ?? ?? ?? 0? 13 00 A5 24 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "lrand48"
		size = 44
		refs = "0000 __libc_drand48_data 0014 __nrand48_r"
	strings:
		$1 = { ?? ?? 04 3C D8 FF BD 27 ?? ?? 84 24 18 00 A6 27 24 00 BF AF ?? ?? ?? 0? 21 28 80 00 24 00 BF 8F 18 00 A2 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_1306_0_0 {
	meta:
		name = "mrand48"
		size = 44
		refs = "0000 __libc_drand48_data 0014 __jrand48_r"
	strings:
		$1 = { ?? ?? 04 3C D8 FF BD 27 ?? ?? 84 24 18 00 A6 27 24 00 BF AF ?? ?? ?? 0? 21 28 80 00 24 00 BF 8F 18 00 A2 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "__realpath_chk"
		size = 36
		refs = "000c __realpath 001c __chk_fail"
	strings:
		$1 = { 00 10 C6 2C 03 00 C0 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "psignal"
		size = 296
		refs = "0030 $LC0 0044 _sys_siglist 005c _libc_intl_domainname 0064 __dcgettext 0080 __fxprintf 006c $LC2 00a8 $LC3 00cc __asprintf 00dc $LC5 00ec free 002c $LC1 0118 $LC4"
	strings:
		$1 = { C0 FF BD 27 30 00 B1 AF 2C 00 B0 AF 3C 00 BF AF 38 00 B3 AF 34 00 B2 AF 21 80 A0 00 04 00 A0 10 21 88 80 00 00 00 A2 80 39 00 40 14 ?? ?? 12 3C ?? ?? 12 3C ?? ?? 52 26 21 80 40 02 80 00 22 2E 18 00 40 10 ?? ?? 02 3C 80 18 11 00 ?? ?? 42 24 21 10 62 00 00 00 45 8C 12 00 A0 10 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? 05 3C 21 30 00 02 21 38 40 02 10 00 A2 AF 21 20 00 00 ?? ?? ?? 0? ?? ?? A5 24 3C 00 BF 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? 13 3C ?? ?? 05 3C ?? ?? 64 26 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 21 28 40 00 10 00 B1 AF 20 00 A4 27 21 30 00 02 ?? ?? ?? 0? 21 38 40 02 10 00 40 04 20 00 A6 8F ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? 21 20 00 00 ?? ?? ?? 0? 20 00 A4 8F 3C 00 BF 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? ?? 0? ?? ?? 52 26 ?? ?? 05 3C ?? ?? 64 26 ?? ?? ?? 0? ?? ?? A5 24 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "__lcong48_r"
		size = 84
	strings:
		$1 = { 03 00 83 88 21 10 00 00 00 00 83 98 03 00 A3 A8 00 00 A3 B8 04 00 83 90 04 00 A3 A0 05 00 83 90 05 00 A3 A0 08 00 88 94 06 00 87 94 0C 00 83 94 0A 00 86 94 00 24 08 00 25 20 E4 00 0C 00 A3 A4 01 00 03 24 10 00 A4 AC 14 00 A6 AC 08 00 E0 03 0E 00 A3 A4 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "grantpt"
		size = 720
		refs = "0004 __gnu_local_gp 0050 realloc 0074 __ptsname_internal 0090 memchr 00ac malloc 00bc __libc_errno 00d4 free 00ec __libc_fcntl 014c __getuid 0184 __chown 01ac __chmod 0248 __sysconf 026c $LC0 0284 __getgrnam_r 02ac __getgid"
	strings:
		$1 = { 10 EF BD 27 ?? ?? 1C 3C E8 10 BE AF 21 F0 A0 03 E0 10 B2 AF D8 10 B0 AF ?? ?? 9C 27 20 00 D2 27 00 10 10 24 E4 10 B3 AF DC 10 B1 AF EC 10 BF AF 18 00 DC AF 21 98 80 00 0B 00 00 16 21 88 40 02 80 00 10 24 21 20 20 02 18 00 51 12 21 28 00 02 ?? ?? ?? 0? 00 00 00 00 18 00 40 10 18 00 DC 8F F7 FF 00 12 21 88 40 00 21 20 60 02 21 28 20 02 21 30 00 02 ?? ?? ?? 0? 20 10 C7 27 18 00 DC 8F 21 30 00 02 21 20 20 02 25 00 40 14 21 28 00 00 ?? ?? ?? 0? 00 00 00 00 2C 00 40 14 40 80 10 00 21 20 20 02 EA FF 51 16 21 28 00 02 ?? ?? ?? 0? 21 20 00 02 EA FF 40 14 18 00 DC 8F ?? ?? 90 8F 3B E8 03 7C 21 10 03 02 0C 00 03 24 03 00 51 12 00 00 43 AC ?? ?? ?? 0? 21 20 20 02 3B E8 03 7C 21 88 03 02 21 20 60 02 01 00 05 24 ?? ?? ?? 0? 00 00 32 8E FF FF 03 24 4E 00 43 10 09 00 03 24 19 00 02 24 3B E8 03 7C 6C 00 42 12 00 00 00 00 21 10 03 02 00 00 52 AC ?? ?? ?? 0? FF FF 02 24 ?? ?? 90 8F 3B E8 03 7C 21 20 60 00 19 00 45 38 16 00 03 24 0A 10 65 00 21 20 04 02 E5 FF 51 16 00 00 82 AC ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 21 80 40 00 40 10 C2 8F 24 00 50 14 44 10 C6 8F ?? ?? 13 3C ?? ?? 66 8E FF FF 02 24 35 00 C2 10 00 00 00 00 44 10 C3 8F 05 00 C3 10 21 20 20 02 ?? ?? ?? 0? 21 28 00 02 1D 00 40 04 00 00 00 00 38 10 C3 8F 90 01 02 24 FF 01 63 30 05 00 62 10 21 80 00 00 21 20 20 02 ?? ?? ?? 0? 90 01 05 24 C3 87 02 00 14 00 51 12 00 00 00 00 ?? ?? ?? 0? 21 20 20 02 21 10 00 02 21 E8 C0 03 EC 10 BF 8F E8 10 BE 8F E4 10 B3 8F E0 10 B2 8F DC 10 B1 8F D8 10 B0 8F 08 00 E0 03 F0 10 BD 27 21 20 20 02 ?? ?? ?? 0? 21 28 00 02 DA FF 41 04 ?? ?? 13 3C EE FF 51 16 FF FF 10 24 21 E8 C0 03 EC 10 DF 8F 21 10 00 02 E8 10 BE 8F E4 10 B3 8F E0 10 B2 8F DC 10 B1 8F D8 10 B0 8F 08 00 E0 03 F0 10 BD 27 00 00 24 8E B1 FF 83 14 00 00 00 00 ?? ?? ?? 0? 21 E8 C0 03 ?? ?? ?? 0? 45 00 04 24 27 20 02 00 00 04 03 24 0A 10 64 00 0E 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 ?? ?? 04 3C D0 10 C3 27 10 00 A3 AF ?? ?? 84 24 C0 10 C5 27 18 00 A6 27 ?? ?? ?? 0? 21 38 40 00 D0 10 C2 8F 03 00 40 10 ?? ?? 66 8E 08 00 46 8C ?? ?? 66 AE FF FF 02 24 B5 FF C2 14 44 10 C3 8F ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 30 40 00 21 10 03 02 16 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "__getpwuid_r"
		size = 660
		refs = "0000 __nss_not_use_nscd_passwd 0008 __gnu_local_gp 009c __libc_errno 00a4 $LC0 00b0 _dl_mcount_wrapper_check 0104 __nss_next2 0170 __nss_database_custom 0190 __nscd_getpwuid_r 0200 __nss_passwd_lookup2"
	strings:
		$1 = { ?? ?? 03 3C ?? ?? 62 8C ?? ?? 1C 3C B0 FF BD 27 ?? ?? 9C 27 48 00 BE AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 4C 00 BF AF 44 00 B7 AF 40 00 B6 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 21 98 80 00 21 90 A0 00 21 A0 C0 00 21 A8 E0 00 61 00 40 18 60 00 BE 8F 01 00 42 24 65 00 44 28 42 00 80 10 ?? ?? 10 3C ?? ?? 62 AC ?? ?? 02 92 60 00 40 10 ?? ?? 05 3C ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 44 8C 01 00 62 24 24 00 A3 AF 20 00 A4 AF 01 00 42 2C 43 00 40 14 ?? ?? 97 8F 3B E8 03 7C ?? ?? 16 3C 21 88 E3 02 ?? ?? D6 26 ?? ?? ?? 0? 20 00 A4 8F 20 00 B9 8F 21 20 60 02 21 28 40 02 21 30 80 02 21 38 A0 02 09 F8 20 03 10 00 B1 AF 21 80 40 00 FE FF 02 24 24 00 A4 27 21 28 C0 02 21 30 00 00 05 00 02 16 20 00 A7 27 00 00 23 8E 22 00 02 24 2C 00 62 10 00 00 00 00 10 00 B0 AF ?? ?? ?? 0? 14 00 A0 AF E8 FF 40 10 01 00 02 24 48 00 02 12 02 00 02 2E 5B 00 40 14 00 00 C0 AF 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 24 00 43 10 FE FF 03 24 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 ?? ?? 60 AC ?? ?? 02 3C ?? ?? 42 90 BC FF 40 14 ?? ?? 10 3C 10 00 BE AF 21 20 60 02 21 28 40 02 21 30 80 02 ?? ?? ?? 0? 21 38 A0 02 E8 FF 41 04 18 00 BC 8F ?? ?? ?? 0? ?? ?? 10 3C FF FF 10 24 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 DF FF 43 14 00 00 C0 AF FE FF 03 24 DD FF 03 12 4C 00 BF 8F ?? ?? ?? 0? 16 00 02 24 E6 FF 40 10 ?? ?? 02 3C ?? ?? 10 3C ?? ?? 02 92 A4 FF 40 14 ?? ?? 02 3C ?? ?? 05 3C 24 00 A4 27 ?? ?? A5 24 21 30 00 00 ?? ?? ?? 0? 20 00 A7 27 1C 00 40 14 18 00 BC 8F 20 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 24 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 0F 00 00 00 01 00 03 24 ?? ?? ?? 0? ?? ?? 03 A2 00 00 D2 AF 21 10 00 00 4C 00 BF 8F 3B E8 03 7C 21 20 E3 02 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 00 00 82 AC 08 00 E0 03 50 00 BD 27 FF FF 04 24 ?? ?? 03 3C ?? ?? ?? 0? ?? ?? 64 AC ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "__getgrgid_r"
		size = 660
		refs = "0000 __nss_not_use_nscd_group 0008 __gnu_local_gp 009c __libc_errno 00a4 $LC0 00b0 _dl_mcount_wrapper_check 0104 __nss_next2 0170 __nss_database_custom 0190 __nscd_getgrgid_r 0200 __nss_group_lookup2"
	strings:
		$1 = { ?? ?? 03 3C ?? ?? 62 8C ?? ?? 1C 3C B0 FF BD 27 ?? ?? 9C 27 48 00 BE AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 4C 00 BF AF 44 00 B7 AF 40 00 B6 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 21 98 80 00 21 90 A0 00 21 A0 C0 00 21 A8 E0 00 61 00 40 18 60 00 BE 8F 01 00 42 24 65 00 44 28 42 00 80 10 ?? ?? 10 3C ?? ?? 62 AC ?? ?? 02 92 60 00 40 10 ?? ?? 05 3C ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 44 8C 01 00 62 24 24 00 A3 AF 20 00 A4 AF 01 00 42 2C 43 00 40 14 ?? ?? 97 8F 3B E8 03 7C ?? ?? 16 3C 21 88 E3 02 ?? ?? D6 26 ?? ?? ?? 0? 20 00 A4 8F 20 00 B9 8F 21 20 60 02 21 28 40 02 21 30 80 02 21 38 A0 02 09 F8 20 03 10 00 B1 AF 21 80 40 00 FE FF 02 24 24 00 A4 27 21 28 C0 02 21 30 00 00 05 00 02 16 20 00 A7 27 00 00 23 8E 22 00 02 24 2C 00 62 10 00 00 00 00 10 00 B0 AF ?? ?? ?? 0? 14 00 A0 AF E8 FF 40 10 01 00 02 24 48 00 02 12 02 00 02 2E 5B 00 40 14 00 00 C0 AF 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 24 00 43 10 FE FF 03 24 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 ?? ?? 60 AC ?? ?? 02 3C ?? ?? 42 90 BC FF 40 14 ?? ?? 10 3C 10 00 BE AF 21 20 60 02 21 28 40 02 21 30 80 02 ?? ?? ?? 0? 21 38 A0 02 E8 FF 41 04 18 00 BC 8F ?? ?? ?? 0? ?? ?? 10 3C FF FF 10 24 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 DF FF 43 14 00 00 C0 AF FE FF 03 24 DD FF 03 12 4C 00 BF 8F ?? ?? ?? 0? 16 00 02 24 E6 FF 40 10 ?? ?? 02 3C ?? ?? 10 3C ?? ?? 02 92 A4 FF 40 14 ?? ?? 02 3C ?? ?? 05 3C 24 00 A4 27 ?? ?? A5 24 21 30 00 00 ?? ?? ?? 0? 20 00 A7 27 1C 00 40 14 18 00 BC 8F 20 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 24 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 0F 00 00 00 01 00 03 24 ?? ?? ?? 0? ?? ?? 03 A2 00 00 D2 AF 21 10 00 00 4C 00 BF 8F 3B E8 03 7C 21 20 E3 02 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 00 00 82 AC 08 00 E0 03 50 00 BD 27 FF FF 04 24 ?? ?? 03 3C ?? ?? ?? 0? ?? ?? 64 AC ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "__getgrnam_r"
		size = 660
		refs = "0000 __nss_not_use_nscd_group 0008 __gnu_local_gp 009c __libc_errno 00a4 $LC0 00b0 _dl_mcount_wrapper_check 0104 __nss_next2 0170 __nss_database_custom 0190 __nscd_getgrnam_r 0200 __nss_group_lookup2"
	strings:
		$1 = { ?? ?? 03 3C ?? ?? 62 8C ?? ?? 1C 3C B0 FF BD 27 ?? ?? 9C 27 48 00 BE AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 4C 00 BF AF 44 00 B7 AF 40 00 B6 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 21 98 80 00 21 90 A0 00 21 A0 C0 00 21 A8 E0 00 61 00 40 18 60 00 BE 8F 01 00 42 24 65 00 44 28 42 00 80 10 ?? ?? 10 3C ?? ?? 62 AC ?? ?? 02 92 60 00 40 10 ?? ?? 05 3C ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 44 8C 01 00 62 24 24 00 A3 AF 20 00 A4 AF 01 00 42 2C 43 00 40 14 ?? ?? 97 8F 3B E8 03 7C ?? ?? 16 3C 21 88 E3 02 ?? ?? D6 26 ?? ?? ?? 0? 20 00 A4 8F 20 00 B9 8F 21 20 60 02 21 28 40 02 21 30 80 02 21 38 A0 02 09 F8 20 03 10 00 B1 AF 21 80 40 00 FE FF 02 24 24 00 A4 27 21 28 C0 02 21 30 00 00 05 00 02 16 20 00 A7 27 00 00 23 8E 22 00 02 24 2C 00 62 10 00 00 00 00 10 00 B0 AF ?? ?? ?? 0? 14 00 A0 AF E8 FF 40 10 01 00 02 24 48 00 02 12 02 00 02 2E 5B 00 40 14 00 00 C0 AF 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 24 00 43 10 FE FF 03 24 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 ?? ?? 60 AC ?? ?? 02 3C ?? ?? 42 90 BC FF 40 14 ?? ?? 10 3C 10 00 BE AF 21 20 60 02 21 28 40 02 21 30 80 02 ?? ?? ?? 0? 21 38 A0 02 E8 FF 41 04 18 00 BC 8F ?? ?? ?? 0? ?? ?? 10 3C FF FF 10 24 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 DF FF 43 14 00 00 C0 AF FE FF 03 24 DD FF 03 12 4C 00 BF 8F ?? ?? ?? 0? 16 00 02 24 E6 FF 40 10 ?? ?? 02 3C ?? ?? 10 3C ?? ?? 02 92 A4 FF 40 14 ?? ?? 02 3C ?? ?? 05 3C 24 00 A4 27 ?? ?? A5 24 21 30 00 00 ?? ?? ?? 0? 20 00 A7 27 1C 00 40 14 18 00 BC 8F 20 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 24 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 0F 00 00 00 01 00 03 24 ?? ?? ?? 0? ?? ?? 03 A2 00 00 D2 AF 21 10 00 00 4C 00 BF 8F 3B E8 03 7C 21 20 E3 02 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 00 00 82 AC 08 00 E0 03 50 00 BD 27 FF FF 04 24 ?? ?? 03 3C ?? ?? ?? 0? ?? ?? 64 AC ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_326_0_0 {
	meta:
		name = "__getpwnam_r"
		size = 660
		refs = "0000 __nss_not_use_nscd_passwd 0008 __gnu_local_gp 009c __libc_errno 00a4 $LC0 00b0 _dl_mcount_wrapper_check 0104 __nss_next2 0170 __nss_database_custom 0190 __nscd_getpwnam_r 0200 __nss_passwd_lookup2"
	strings:
		$1 = { ?? ?? 03 3C ?? ?? 62 8C ?? ?? 1C 3C B0 FF BD 27 ?? ?? 9C 27 48 00 BE AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 4C 00 BF AF 44 00 B7 AF 40 00 B6 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 21 98 80 00 21 90 A0 00 21 A0 C0 00 21 A8 E0 00 61 00 40 18 60 00 BE 8F 01 00 42 24 65 00 44 28 42 00 80 10 ?? ?? 10 3C ?? ?? 62 AC ?? ?? 02 92 60 00 40 10 ?? ?? 05 3C ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 44 8C 01 00 62 24 24 00 A3 AF 20 00 A4 AF 01 00 42 2C 43 00 40 14 ?? ?? 97 8F 3B E8 03 7C ?? ?? 16 3C 21 88 E3 02 ?? ?? D6 26 ?? ?? ?? 0? 20 00 A4 8F 20 00 B9 8F 21 20 60 02 21 28 40 02 21 30 80 02 21 38 A0 02 09 F8 20 03 10 00 B1 AF 21 80 40 00 FE FF 02 24 24 00 A4 27 21 28 C0 02 21 30 00 00 05 00 02 16 20 00 A7 27 00 00 23 8E 22 00 02 24 2C 00 62 10 00 00 00 00 10 00 B0 AF ?? ?? ?? 0? 14 00 A0 AF E8 FF 40 10 01 00 02 24 48 00 02 12 02 00 02 2E 5B 00 40 14 00 00 C0 AF 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 24 00 43 10 FE FF 03 24 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 ?? ?? 60 AC ?? ?? 02 3C ?? ?? 42 90 BC FF 40 14 ?? ?? 10 3C 10 00 BE AF 21 20 60 02 21 28 40 02 21 30 80 02 ?? ?? ?? 0? 21 38 A0 02 E8 FF 41 04 18 00 BC 8F ?? ?? ?? 0? ?? ?? 10 3C FF FF 10 24 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 DF FF 43 14 00 00 C0 AF FE FF 03 24 DD FF 03 12 4C 00 BF 8F ?? ?? ?? 0? 16 00 02 24 E6 FF 40 10 ?? ?? 02 3C ?? ?? 10 3C ?? ?? 02 92 A4 FF 40 14 ?? ?? 02 3C ?? ?? 05 3C 24 00 A4 27 ?? ?? A5 24 21 30 00 00 ?? ?? ?? 0? 20 00 A7 27 1C 00 40 14 18 00 BC 8F 20 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 24 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 0F 00 00 00 01 00 03 24 ?? ?? ?? 0? ?? ?? 03 A2 00 00 D2 AF 21 10 00 00 4C 00 BF 8F 3B E8 03 7C 21 20 E3 02 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 00 00 82 AC 08 00 E0 03 50 00 BD 27 FF FF 04 24 ?? ?? 03 3C ?? ?? ?? 0? ?? ?? 64 AC ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "__futimes"
		size = 648
		refs = "0000 __gnu_local_gp 00c4 __libc_errno 014c _itoa_word 0154 selffd.6734"
	strings:
		$1 = { ?? ?? 1C 3C A0 FF BD 27 ?? ?? 9C 27 50 00 B1 AF 4C 00 B0 AF 5C 00 BF AF 58 00 B3 AF 54 00 B2 AF 10 00 BC AF 21 80 A0 00 1A 00 A0 10 21 88 80 00 04 00 A2 8C 0F 00 05 3C 40 42 A5 24 2B 18 45 00 34 00 60 10 00 00 00 00 0C 00 03 8E 2B 28 65 00 30 00 A0 10 80 20 02 00 C0 39 02 00 80 30 03 00 C0 41 03 00 23 38 E4 00 00 00 05 8E 08 00 04 8E 23 30 06 01 21 10 E2 00 21 18 C3 00 C0 10 02 00 C0 18 03 00 34 00 A5 AF 38 00 A2 AF 3C 00 A4 AF 40 00 A3 AF ?? ?? 12 3C ?? ?? 42 8E 27 00 40 14 34 00 A6 27 21 20 20 02 21 28 00 00 0A 30 10 00 21 38 00 00 DC 10 02 24 0C 00 00 00 0C 00 E0 10 FF FF 03 24 ?? ?? 93 8F 3B E8 03 7C 21 20 60 00 21 98 64 02 21 18 40 00 00 00 62 AE 59 00 02 24 14 00 62 10 00 00 00 00 ?? ?? ?? 0? FF FF 02 24 4A 00 43 10 ?? ?? 93 8F 5C 00 BF 8F 58 00 B3 8F 54 00 B2 8F 50 00 B1 8F 4C 00 B0 8F 08 00 E0 03 60 00 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 01 00 02 24 ?? ?? 42 AE 21 20 20 02 32 00 A5 27 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 32 00 A0 A3 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 63 24 04 00 65 8C 10 00 BC 8F F2 FF 44 24 F5 FF 46 A8 00 00 86 B8 08 00 62 8C 07 00 85 A8 0C 00 66 90 0D 00 63 90 04 00 85 B8 0B 00 82 A8 08 00 82 B8 0C 00 86 A0 0D 00 83 A0 21 28 00 02 AB 10 02 24 0C 00 00 00 19 00 E0 14 ?? ?? 93 8F FF FF 03 24 D2 FF 43 14 5C 00 BF 8F ?? ?? 93 8F 3B E8 03 7C 21 10 63 02 00 00 42 8C 14 00 03 24 09 00 43 10 15 00 43 28 21 00 60 10 02 00 03 24 13 00 43 10 0D 00 03 24 C0 FF 43 14 00 00 00 00 BE FF 00 12 00 00 00 00 3B E8 03 7C 21 10 63 02 59 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 3B E8 03 7C 21 20 63 02 ?? ?? ?? 0? 00 00 82 AC 3B E8 03 7C 21 10 63 02 ?? ?? ?? 0? 00 00 43 8C 21 20 20 02 01 00 05 24 21 30 00 00 D7 0F 02 24 0C 00 00 00 0D 00 E0 10 FF FF 03 24 3B E8 03 7C 21 20 63 02 00 00 82 AC ?? ?? ?? 0? FF FF 02 24 4E 00 03 24 E4 FF 43 10 5A 00 03 24 E2 FF 43 10 00 00 00 00 ?? ?? ?? 0? FF FF 02 24 DE FF 43 14 00 00 00 00 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "wmemset"
		size = 124
	strings:
		$1 = { 04 00 C3 2C 1B 00 60 14 21 10 80 00 21 18 80 00 21 38 C0 00 FC FF E7 24 04 00 E8 2C 00 00 65 AC 04 00 65 AC 08 00 65 AC 0C 00 65 AC F9 FF 00 11 10 00 63 24 FC FF C3 24 82 18 03 00 01 00 63 24 00 19 03 00 21 18 43 00 03 00 C6 30 07 00 C0 10 01 00 04 24 05 00 C4 10 00 00 65 AC 03 00 04 24 02 00 C4 14 04 00 65 AC 08 00 65 AC 08 00 E0 03 00 00 00 00 ?? ?? ?? 0? 21 18 80 00 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "__fdatasync_nocancel"
		size = 28
	strings:
		$1 = { 38 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_50_1_0 {
	meta:
		name = "fdatasync"
		size = 132
		refs = "0038 __libc_enable_asynccancel 005c __libc_disable_asynccancel"
	strings:
		$1 = { 3B E8 03 7C 70 8B 63 8C 08 00 03 14 00 00 00 00 38 10 02 24 0C 00 00 00 F0 FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 D0 FF BD 27 1C 00 BF AF 00 00 A4 AF ?? ?? ?? 0? 00 00 00 00 2C 00 A2 AF 00 00 A4 8F 38 10 02 24 0C 00 00 00 24 00 A2 AF 28 00 A7 AF 2C 00 A4 8F ?? ?? ?? 0? 00 00 00 00 24 00 A2 8F 28 00 A7 8F 1C 00 BF 8F DA FF E0 14 30 00 BD 27 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "_dl_add_to_namespace_list"
		size = 260
		refs = "0000 __pthread_mutex_lock 0024 _dl_load_write_lock 0040 _dl_ns 007c _dl_load_adds 00b0 __pthread_mutex_unlock"
	strings:
		$1 = { ?? ?? 02 3C D8 FF BD 27 ?? ?? 42 24 20 00 B1 AF 1C 00 B0 AF 24 00 BF AF 21 88 80 00 04 00 40 10 21 80 A0 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 80 30 10 00 00 29 10 00 21 10 C5 00 23 10 50 00 ?? ?? 04 3C 80 10 02 00 ?? ?? 84 24 21 10 82 00 00 00 43 8C 04 00 60 14 00 00 00 00 ?? ?? ?? 0? 00 00 51 AC 21 18 40 00 0C 00 62 8C FD FF 40 14 00 00 00 00 10 00 23 AE 0C 00 71 AC ?? ?? 02 3C ?? ?? 43 8C 21 28 C5 00 23 80 B0 00 80 80 10 00 ?? ?? 45 8C 21 80 90 00 01 00 64 24 04 00 07 8E 2B 30 83 00 21 30 C5 00 ?? ?? 44 AC ?? ?? 46 AC ?? ?? 02 3C 01 00 E7 24 ?? ?? 42 24 04 00 07 AE 28 03 23 AE 0A 00 40 10 2C 03 25 AE 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 28 00 BD 27 ?? ?? ?? 0? ?? ?? 02 3C 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_51_1_0 {
	meta:
		name = "_dl_new_object"
		size = 780
		refs = "0004 __gnu_local_gp 0048 strlen 005c calloc 0088 memcpy 0090 _dl_debug_mask 00cc _dl_ns 0198 __libc_errno 01b4 __getcwd 01d8 realloc 01f8 free 0268 strchr 028c mempcpy 02d4 malloc"
	strings:
		$1 = { B8 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 38 00 B6 AF 21 B0 80 00 21 20 A0 00 44 00 BF AF 34 00 B5 AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 10 00 BC AF 21 98 A0 00 21 A0 C0 00 21 88 E0 00 40 00 BE AF ?? ?? ?? 0? 3C 00 B7 AF 41 03 44 24 01 00 05 24 5C 00 B2 8F ?? ?? ?? 0? 01 00 55 24 A1 00 40 10 21 80 40 00 30 03 43 24 40 03 04 26 34 03 42 24 21 28 60 02 21 30 A0 02 38 02 03 AE 14 00 10 AE ?? ?? ?? 0? 1C 00 02 AE ?? ?? 04 3C 68 02 03 8E ?? ?? 85 8C 01 00 04 24 04 08 83 7E 00 01 A5 30 34 03 02 AE 3C 03 04 AE 04 00 16 AE 63 00 A0 10 68 02 03 AE 00 11 12 00 80 18 12 00 21 18 62 00 23 18 72 00 ?? ?? 02 3C 80 18 03 00 ?? ?? 42 24 21 10 62 00 00 00 43 8C FF FF 04 24 8C 02 02 26 10 03 04 AE 04 00 04 24 40 02 11 AE 18 00 12 AE A0 02 02 AE 57 00 60 10 9C 02 04 AE 30 02 63 24 8C 02 03 AE 01 00 04 24 04 00 20 16 00 00 00 00 ?? ?? ?? 0? 21 88 00 02 21 88 60 00 40 02 23 8E FD FF 60 14 00 00 00 00 42 00 80 10 21 18 00 00 8C 02 03 8E 30 02 31 26 08 00 71 10 58 00 A4 8F 10 00 84 30 6D 00 80 10 00 00 00 00 90 02 03 AE 21 18 00 00 21 10 43 00 00 00 51 AC 00 00 D1 82 30 02 02 26 A4 02 02 AE 25 00 20 12 21 10 00 02 ?? ?? ?? 0? 21 20 C0 02 21 A0 40 00 01 00 42 24 18 00 A2 AF 2F 00 02 24 50 00 22 12 10 00 BC 8F ?? ?? 97 8F 3B E8 03 7C 18 00 B2 8F 21 F0 00 00 21 B8 E3 02 ?? ?? ?? 0? 22 00 15 24 ?? ?? ?? 0? 00 00 00 00 29 00 40 14 21 F0 20 02 00 00 E2 8E 3E 00 55 14 21 90 60 02 80 00 53 26 21 20 C0 03 ?? ?? ?? 0? 21 28 60 02 7F 00 45 26 23 28 B4 00 21 88 40 00 F1 FF 40 14 21 20 40 00 21 20 C0 03 ?? ?? ?? 0? FF FF 11 24 7C 02 11 AE 21 10 00 02 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 21 18 00 00 ?? ?? ?? 0? 30 02 31 26 ?? ?? ?? 0? D4 02 04 AE FA FF 80 10 00 00 00 00 ?? ?? ?? 0? 8C 02 03 8E ?? ?? ?? 0? 21 20 00 00 21 20 20 02 ?? ?? ?? 0? 21 28 00 00 FF FF 44 80 2F 00 03 24 03 00 83 10 21 20 40 00 01 00 44 24 00 00 43 A0 18 00 A6 8F ?? ?? ?? 0? 21 28 C0 02 ?? ?? ?? 0? 2F 00 05 24 21 10 60 00 FF FF 44 80 FD FF 85 14 FF FF 43 24 26 20 23 02 0A 18 44 00 00 00 60 A0 21 10 00 02 ?? ?? ?? 0? 7C 02 11 AE ?? ?? ?? 0? 21 20 C0 03 ?? ?? ?? 0? FF FF 11 24 ?? ?? ?? 0? 18 00 A4 8F 05 00 40 10 21 88 40 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 21 10 00 00 FF FF 11 24 7C 02 11 AE ?? ?? ?? 0? 21 10 00 02 ?? ?? ?? 0? 04 00 03 24 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "__atfct_seterrno_2"
		size = 588
		refs = "0000 __gnu_local_gp 003c strchr 0054 __lxstat64 007c __libc_errno 0094 __fxstat64 00b8 $LC0 0148 __xstat64"
	strings:
		$1 = { ?? ?? 1C 3C 30 FF BD 27 ?? ?? 9C 27 C4 00 B0 AF CC 00 BF AF C8 00 B1 AF 10 00 BC AF 3F 00 C0 10 21 80 80 00 14 00 02 24 17 00 82 10 02 00 02 24 41 00 82 14 0E 00 C4 24 2F 00 05 24 ?? ?? ?? 0? B8 00 A6 AF 00 00 40 A0 B8 00 A6 8F 03 00 04 24 21 28 C0 00 ?? ?? ?? 0? 18 00 A6 27 FF FF 03 24 6A 00 43 10 10 00 BC 8F 52 00 40 14 30 00 A3 8F 00 A0 02 34 00 F0 63 30 4E 00 62 10 ?? ?? 91 8F ?? ?? ?? 0? 09 00 10 24 18 00 B0 27 03 00 04 24 21 30 00 02 ?? ?? ?? 0? B8 00 A7 AF 10 00 BC 8F 19 00 40 14 B8 00 A7 8F 30 00 B1 8F 00 40 02 24 00 F0 31 32 2F 00 22 12 ?? ?? 05 3C E0 00 A2 8F 0D 00 40 10 ?? ?? 91 8F 03 00 04 24 21 28 E0 00 ?? ?? ?? 0? 21 30 00 02 0B 00 40 14 10 00 BC 8F 30 00 B1 8F 00 40 02 24 00 F0 31 32 14 00 22 12 ?? ?? 05 3C ?? ?? 91 8F 14 00 10 24 3B E8 03 7C 21 10 23 02 00 00 50 AC CC 00 BF 8F C8 00 B1 8F C4 00 B0 8F 08 00 E0 03 D0 00 BD 27 E0 00 A2 8F 05 00 40 10 14 00 02 24 20 00 82 10 02 00 02 24 20 00 82 10 00 00 00 00 ?? ?? ?? 0? ?? ?? 91 8F 03 00 04 24 ?? ?? A5 24 ?? ?? ?? 0? 21 30 00 02 05 00 40 14 10 00 BC 8F 30 00 A2 8F 00 F0 42 30 E4 FF 51 10 00 00 00 00 59 00 10 24 ?? ?? ?? 0? ?? ?? 91 8F 03 00 04 24 ?? ?? A5 24 21 30 00 02 ?? ?? ?? 0? B8 00 A7 AF 10 00 BC 8F F6 FF 40 14 B8 00 A7 8F 30 00 A2 8F 00 F0 42 30 C7 FF 51 10 ?? ?? 91 8F ?? ?? ?? 0? 59 00 10 24 ?? ?? ?? 0? 18 00 B0 27 ?? ?? 91 8F E0 00 A2 8F 11 00 40 10 2F 00 05 24 ?? ?? ?? 0? 0E 00 44 24 E0 00 A5 8F 00 00 40 A0 03 00 04 24 ?? ?? ?? 0? 18 00 A6 27 FF FF 03 24 11 00 43 10 00 00 00 00 05 00 40 14 30 00 A3 8F 00 A0 02 34 00 F0 63 30 A0 FF 62 14 00 00 00 00 ?? ?? ?? 0? 02 00 10 24 ?? ?? 91 8F 3B E8 03 7C 21 10 23 02 00 00 42 8C E7 FF 50 14 E0 00 A2 8F ?? ?? ?? 0? 09 00 10 24 3B E8 03 7C 21 10 23 02 00 00 43 8C 02 00 02 24 90 FF 62 10 00 00 00 00 ?? ?? ?? 0? 02 00 10 24 }
	condition:
		$1
}

rule file_53_1_0 {
	meta:
		name = "renameat"
		size = 500
		refs = "0008 __have_atfcts 0010 __gnu_local_gp 0068 __libc_errno 00a0 strlen 00c4 procfd.7870 00d8 __snprintf 0164 __atfct_seterrno_2"
	strings:
		$1 = { C0 FF BD 27 28 00 B2 AF ?? ?? 12 3C ?? ?? 42 8E ?? ?? 1C 3C 38 00 BE AF ?? ?? 9C 27 21 F0 A0 03 30 00 B4 AF 2C 00 B3 AF 24 00 B1 AF 20 00 B0 AF 3C 00 BF AF 34 00 B5 AF 18 00 DC AF 21 98 80 00 21 88 A0 00 21 A0 C0 00 0F 00 40 04 21 80 E0 00 C7 10 02 24 0C 00 00 00 46 00 E0 10 FF FF 03 24 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 28 40 00 21 20 64 00 00 00 82 AC 59 00 03 24 3F 00 A3 14 FF FF 02 24 ?? ?? 42 AE 9C FF 02 24 46 00 62 12 2F 00 02 24 00 00 23 82 44 00 62 10 9C FF 02 24 ?? ?? ?? 0? 21 20 20 02 44 00 40 10 18 00 DC 8F 2E 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 B2 27 ?? ?? 06 3C 10 00 B1 AF 21 20 40 02 20 00 45 24 ?? ?? C6 24 ?? ?? ?? 0? 21 38 60 02 9C FF 02 24 33 00 82 12 21 88 40 02 00 00 03 82 2F 00 02 24 12 00 62 10 21 A8 00 00 ?? ?? ?? 0? 21 20 00 02 2D 00 40 10 18 00 DC 8F 2E 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 B5 27 ?? ?? 06 3C 10 00 B0 AF 21 20 A0 02 20 00 45 24 ?? ?? C6 24 21 38 80 02 ?? ?? ?? 0? 21 80 A0 02 21 20 20 02 21 28 00 02 C6 0F 02 24 0C 00 00 00 0A 00 E0 10 21 20 40 00 10 00 B2 AF 21 28 80 02 21 30 A0 02 ?? ?? ?? 0? 21 38 60 02 ?? ?? ?? 0? FF FF 02 24 19 00 43 10 00 00 00 00 21 E8 C0 03 3C 00 DF 8F 38 00 BE 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 40 00 BD 27 9C FF 02 24 CF FF 82 16 21 90 00 00 ?? ?? ?? 0? 21 A8 00 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 02 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 ?? ?? ?? 0? 00 00 45 8C }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "__getdate_r"
		size = 1700
		refs = "0004 __gnu_local_gp 0010 $LC0 0048 getenv 00a4 __xstat64 00cc __access 0124 _IO_new_fopen 0120 $LC1 0144 __libc_tsd_CTYPE_B 0180 strlen 0220 memcpy 0278 strptime 02ac __getline 02e8 free 0308 _IO_new_fclose 033c time 0348 __localtime_r 0494 mktime 04bc __libc_alloca_cutoff 04cc malloc 0540 memset"
	strings:
		$1 = { B8 FE BD 27 ?? ?? 1C 3C 28 01 B2 AF 21 90 80 00 ?? ?? 04 3C 40 01 BE AF ?? ?? 9C 27 21 F0 A0 03 ?? ?? 84 24 24 01 B1 AF 20 01 B0 AF 44 01 BF AF 3C 01 B7 AF 38 01 B6 AF 34 01 B5 AF 30 01 B4 AF 2C 01 B3 AF 10 00 DC AF ?? ?? ?? 0? 21 88 A0 00 24 00 40 10 21 80 40 00 00 00 42 80 0F 00 40 14 01 00 03 24 21 E8 C0 03 44 01 BF 8F 40 01 BE 8F 3C 01 B7 8F 38 01 B6 8F 34 01 B5 8F 30 01 B4 8F 2C 01 B3 8F 28 01 B2 8F 24 01 B1 8F 20 01 B0 8F 21 10 60 00 08 00 E0 03 48 01 BD 27 03 00 04 24 21 28 00 02 ?? ?? ?? 0? 18 00 C6 27 ED FF 40 04 03 00 03 24 30 00 C4 8F 00 80 02 34 00 F0 84 30 E8 FF 82 14 04 00 03 24 21 20 00 02 ?? ?? ?? 0? 04 00 05 24 12 00 41 04 21 20 00 02 ?? ?? ?? 0? 02 00 03 24 21 E8 C0 03 44 01 BF 8F 01 00 03 24 40 01 BE 8F 3C 01 B7 8F 38 01 B6 8F 34 01 B5 8F 30 01 B4 8F 2C 01 B3 8F 28 01 B2 8F 24 01 B1 8F 20 01 B0 8F 21 10 60 00 08 00 E0 03 48 01 BD 27 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 21 98 40 00 EA FF 40 10 10 00 DC 8F 00 00 44 8C 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 00 80 84 34 00 00 64 AE 21 18 62 00 00 00 74 8C ?? ?? ?? 0? 00 00 42 82 00 00 42 82 40 10 02 00 21 10 82 02 00 00 42 94 00 20 42 30 FA FF 40 14 01 00 52 26 FF FF 52 26 ?? ?? ?? 0? 21 20 40 02 63 00 40 10 00 00 00 00 FF FF 50 24 21 18 50 02 00 00 63 80 40 18 03 00 21 18 83 02 00 00 63 94 00 20 63 30 0C 00 60 14 FF FF 03 26 ?? ?? ?? 0? 21 A8 00 00 00 00 84 80 40 20 04 00 21 20 84 02 00 00 84 94 00 20 84 30 05 00 80 10 00 00 00 00 21 80 60 00 FF FF 03 26 F6 FF 00 16 21 20 43 02 2B 10 02 02 12 00 40 10 21 A8 00 00 01 00 14 26 01 80 02 34 2B 10 82 02 AE 00 40 10 0E 00 82 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 10 00 A3 27 21 28 40 02 21 30 00 02 ?? ?? ?? 0? 21 20 60 00 21 80 50 00 00 00 00 A2 21 90 40 00 21 A8 00 00 18 01 C0 AF 14 01 C0 AF 21 B8 00 00 0A 00 16 24 00 80 10 3C ?? ?? ?? 0? FF FF 14 24 18 00 30 AE 0C 00 30 AE 10 00 30 AE 14 00 30 AE 04 00 30 AE 00 00 30 AE 08 00 30 AE 20 00 34 AE 24 00 20 AE ?? ?? ?? 0? 28 00 20 AE 04 00 40 10 21 B8 40 00 00 00 42 80 16 00 40 10 00 00 00 00 00 00 62 8E 10 00 42 30 12 00 40 14 00 00 00 00 18 01 C4 27 21 30 60 02 ?? ?? ?? 0? 14 01 C5 27 21 18 40 00 21 20 40 02 21 30 20 02 09 00 60 04 FF FF 42 24 18 01 C5 8F 21 10 A2 00 00 00 43 80 DF FF 76 14 00 00 00 00 00 00 40 A0 ?? ?? ?? 0? 18 01 C5 8F ?? ?? ?? 0? 21 20 A0 02 ?? ?? ?? 0? 18 01 C4 8F 00 00 63 8E 20 00 63 30 07 00 60 10 21 20 60 02 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 05 00 03 24 ?? ?? ?? 0? 21 A8 00 00 ?? ?? ?? 0? 00 00 00 00 40 00 E0 12 00 00 00 00 00 00 E2 82 4B FF 40 14 07 00 03 24 ?? ?? ?? 0? 10 01 C4 27 10 01 C4 27 ?? ?? ?? 0? E4 00 C5 27 18 00 33 8E 07 00 62 2E 36 00 40 10 00 80 02 3C 14 00 32 8E 10 00 30 8E 9E 00 42 12 21 18 00 00 0C 00 02 2E 04 00 40 10 00 80 04 3C 0C 00 22 8E 62 00 44 10 00 00 00 00 08 00 24 8E 00 80 02 3C 8F 00 82 10 04 00 25 8E 00 00 22 8E 00 80 06 3C 89 00 A6 10 00 00 00 00 00 80 05 3C 41 00 45 10 00 00 00 00 18 00 82 2C 04 00 40 10 00 80 02 3C 9C 00 02 12 00 00 00 00 00 80 02 3C 37 00 42 12 F8 00 C2 8F 00 80 02 3C 6D 00 02 12 F4 00 C2 8F 2C 00 60 14 00 00 00 00 10 00 25 8E 14 00 22 8E 0C 00 24 8E 0C 00 A6 2C 1A FF C0 10 08 00 03 24 01 00 03 24 04 18 A3 00 D5 0A 65 30 62 00 A0 14 28 05 65 30 66 00 A0 14 02 00 63 30 09 00 60 14 00 00 00 00 ?? ?? ?? 0? 08 00 03 24 ?? ?? ?? 0? 07 00 03 24 21 18 00 00 14 00 32 8E ?? ?? ?? 0? 10 00 30 8E F7 FF 80 18 6C 07 42 24 03 00 45 30 0D 00 A0 14 1C 00 03 24 64 00 03 24 1A 00 43 00 F4 01 60 00 10 28 00 00 07 00 A0 14 1D 00 03 24 90 01 05 24 1A 00 45 00 F4 01 A0 00 1C 00 06 24 10 38 00 00 0B 18 C7 00 2A 20 64 00 F5 FE 80 14 08 00 03 24 ?? ?? ?? 0? 21 20 20 02 27 10 02 00 08 00 03 24 ?? ?? ?? 0? 0B 18 02 00 ?? ?? ?? 0? 14 00 22 AE ?? ?? ?? 0? 00 00 20 AE ?? ?? ?? 0? 21 20 80 02 50 FF 40 14 0E 00 82 26 ?? ?? ?? 0? 21 20 80 02 09 00 40 10 21 A8 40 00 21 28 40 02 21 30 00 02 21 20 40 00 ?? ?? ?? 0? 21 80 B0 02 21 90 A0 02 ?? ?? ?? 0? 00 00 00 A2 ?? ?? ?? 0? 21 20 60 02 ?? ?? ?? 0? 06 00 03 24 08 00 42 16 00 80 02 3C F4 00 C2 8F F8 00 D2 8F 23 10 02 02 C2 17 02 00 21 90 42 02 14 00 32 AE 00 80 02 3C 14 00 62 12 01 00 14 24 B8 00 C4 27 21 28 00 00 ?? ?? ?? 0? 2C 00 06 24 B8 00 C4 27 CC 00 D2 AF C8 00 D0 AF ?? ?? ?? 0? C4 00 D4 AF D0 00 C3 8F 07 00 02 24 14 00 32 8E 23 18 63 02 07 00 63 24 1A 00 62 00 F4 01 40 00 10 00 30 8E 10 A0 00 00 01 00 94 26 0C 00 34 AE ?? ?? ?? 0? 01 00 03 24 ?? ?? ?? 0? 10 00 22 AE FF FF 82 24 1F 00 42 2C A0 FF 40 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 FF FF 82 24 1E 00 42 2C 9A FF 40 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 04 00 20 AE 28 00 A4 10 00 00 22 8E 08 00 20 AE ?? ?? ?? 0? 21 20 00 00 63 FF 12 16 0C 00 02 2E 0C 00 22 8E 65 FF 50 14 07 00 02 24 FC 00 C3 8F F8 00 D2 8F 23 18 63 02 07 00 63 24 1A 00 62 00 F4 01 40 00 F0 00 C2 8F F4 00 D0 8F 01 00 03 24 14 00 32 AE 10 00 30 AE 10 20 00 00 21 10 44 00 ?? ?? ?? 0? 0C 00 22 AE 0C 00 22 8E 64 FF 50 14 00 80 02 3C 18 00 22 8E 61 FF 50 14 00 80 02 3C EC 00 C2 8F F0 00 C3 8F F4 00 D0 8F 23 10 82 00 C2 17 02 00 21 10 62 00 10 00 30 AE 0C 00 22 AE ?? ?? ?? 0? 01 00 03 24 D8 FF 45 14 E4 00 C6 8F EC 00 C4 8F E8 00 C5 8F 08 00 24 AE 04 00 25 AE 03 00 82 14 00 00 26 AE ?? ?? ?? 0? 21 10 C0 00 ?? ?? ?? 0? 21 10 C0 00 }
	condition:
		$1
}

rule file_54_1_0 {
	meta:
		name = "getdate"
		size = 84
		refs = "0010 __getdate_r 0038 getdate_err"
	strings:
		$1 = { E0 FF BD 27 18 00 B0 AF ?? ?? 10 3C 1C 00 BF AF ?? ?? ?? 0? ?? ?? 05 26 06 00 40 14 ?? ?? 10 26 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 1C 00 BF 8F ?? ?? 03 3C 21 80 00 00 ?? ?? 62 AC 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "__nss_ethers_lookup2"
		size = 228
		refs = "0008 __nss_ethers_database 0064 __nss_lookup 006c $LC0 007c __nss_database_lookup"
	strings:
		$1 = { D0 FF BD 27 1C 00 B1 AF ?? ?? 11 3C ?? ?? 22 8E 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 18 00 B0 AF 2C 00 BF AF 21 80 80 00 21 A0 A0 00 21 98 C0 00 0E 00 40 10 21 90 E0 00 00 00 02 AE 2C 00 BF 8F 1C 00 B1 8F 21 20 00 02 21 28 80 02 18 00 B0 8F 28 00 B4 8F 21 30 60 02 21 38 40 02 24 00 B3 8F 20 00 B2 8F ?? ?? ?? 0? 30 00 BD 27 ?? ?? 04 3C ?? ?? 84 24 21 28 00 00 21 30 00 00 ?? ?? ?? 0? ?? ?? 27 26 0E 00 40 04 ?? ?? 22 8E 2C 00 BF 8F 1C 00 B1 8F 00 00 02 AE 21 20 00 02 21 28 80 02 18 00 B0 8F 28 00 B4 8F 21 30 60 02 21 38 40 02 24 00 B3 8F 20 00 B2 8F ?? ?? ?? 0? 30 00 BD 27 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F FF FF 02 24 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_873_0_0 {
	meta:
		name = "__nss_aliases_lookup2"
		size = 228
		refs = "0008 __nss_aliases_database 0064 __nss_lookup 006c $LC0 007c __nss_database_lookup"
	strings:
		$1 = { D0 FF BD 27 1C 00 B1 AF ?? ?? 11 3C ?? ?? 22 8E 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 18 00 B0 AF 2C 00 BF AF 21 80 80 00 21 A0 A0 00 21 98 C0 00 0E 00 40 10 21 90 E0 00 00 00 02 AE 2C 00 BF 8F 1C 00 B1 8F 21 20 00 02 21 28 80 02 18 00 B0 8F 28 00 B4 8F 21 30 60 02 21 38 40 02 24 00 B3 8F 20 00 B2 8F ?? ?? ?? 0? 30 00 BD 27 ?? ?? 04 3C ?? ?? 84 24 21 28 00 00 21 30 00 00 ?? ?? ?? 0? ?? ?? 27 26 0E 00 40 04 ?? ?? 22 8E 2C 00 BF 8F 1C 00 B1 8F 00 00 02 AE 21 20 00 02 21 28 80 02 18 00 B0 8F 28 00 B4 8F 21 30 60 02 21 38 40 02 24 00 B3 8F 20 00 B2 8F ?? ?? ?? 0? 30 00 BD 27 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F FF FF 02 24 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_822_0_0 {
	meta:
		name = "__nss_netgroup_lookup2"
		size = 228
		refs = "0008 __nss_netgroup_database 0064 __nss_lookup 006c $LC0 007c __nss_database_lookup"
	strings:
		$1 = { D0 FF BD 27 1C 00 B1 AF ?? ?? 11 3C ?? ?? 22 8E 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 18 00 B0 AF 2C 00 BF AF 21 80 80 00 21 A0 A0 00 21 98 C0 00 0E 00 40 10 21 90 E0 00 00 00 02 AE 2C 00 BF 8F 1C 00 B1 8F 21 20 00 02 21 28 80 02 18 00 B0 8F 28 00 B4 8F 21 30 60 02 21 38 40 02 24 00 B3 8F 20 00 B2 8F ?? ?? ?? 0? 30 00 BD 27 ?? ?? 04 3C ?? ?? 84 24 21 28 00 00 21 30 00 00 ?? ?? ?? 0? ?? ?? 27 26 0E 00 40 04 ?? ?? 22 8E 2C 00 BF 8F 1C 00 B1 8F 00 00 02 AE 21 20 00 02 21 28 80 02 18 00 B0 8F 28 00 B4 8F 21 30 60 02 21 38 40 02 24 00 B3 8F 20 00 B2 8F ?? ?? ?? 0? 30 00 BD 27 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F FF FF 02 24 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_658_0_0 {
	meta:
		name = "__nss_protocols_lookup2"
		size = 228
		refs = "0008 __nss_protocols_database 0064 __nss_lookup 006c $LC0 007c __nss_database_lookup"
	strings:
		$1 = { D0 FF BD 27 1C 00 B1 AF ?? ?? 11 3C ?? ?? 22 8E 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 18 00 B0 AF 2C 00 BF AF 21 80 80 00 21 A0 A0 00 21 98 C0 00 0E 00 40 10 21 90 E0 00 00 00 02 AE 2C 00 BF 8F 1C 00 B1 8F 21 20 00 02 21 28 80 02 18 00 B0 8F 28 00 B4 8F 21 30 60 02 21 38 40 02 24 00 B3 8F 20 00 B2 8F ?? ?? ?? 0? 30 00 BD 27 ?? ?? 04 3C ?? ?? 84 24 21 28 00 00 21 30 00 00 ?? ?? ?? 0? ?? ?? 27 26 0E 00 40 04 ?? ?? 22 8E 2C 00 BF 8F 1C 00 B1 8F 00 00 02 AE 21 20 00 02 21 28 80 02 18 00 B0 8F 28 00 B4 8F 21 30 60 02 21 38 40 02 24 00 B3 8F 20 00 B2 8F ?? ?? ?? 0? 30 00 BD 27 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F FF FF 02 24 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "__nss_rpc_lookup2"
		size = 228
		refs = "0008 __nss_rpc_database 0064 __nss_lookup 006c $LC0 007c __nss_database_lookup"
	strings:
		$1 = { D0 FF BD 27 1C 00 B1 AF ?? ?? 11 3C ?? ?? 22 8E 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 18 00 B0 AF 2C 00 BF AF 21 80 80 00 21 A0 A0 00 21 98 C0 00 0E 00 40 10 21 90 E0 00 00 00 02 AE 2C 00 BF 8F 1C 00 B1 8F 21 20 00 02 21 28 80 02 18 00 B0 8F 28 00 B4 8F 21 30 60 02 21 38 40 02 24 00 B3 8F 20 00 B2 8F ?? ?? ?? 0? 30 00 BD 27 ?? ?? 04 3C ?? ?? 84 24 21 28 00 00 21 30 00 00 ?? ?? ?? 0? ?? ?? 27 26 0E 00 40 04 ?? ?? 22 8E 2C 00 BF 8F 1C 00 B1 8F 00 00 02 AE 21 20 00 02 21 28 80 02 18 00 B0 8F 28 00 B4 8F 21 30 60 02 21 38 40 02 24 00 B3 8F 20 00 B2 8F ?? ?? ?? 0? 30 00 BD 27 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F FF FF 02 24 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_654_0_0 {
	meta:
		name = "__nss_services_lookup2"
		size = 228
		refs = "0008 __nss_services_database 0064 __nss_lookup 006c $LC0 007c __nss_database_lookup"
	strings:
		$1 = { D0 FF BD 27 1C 00 B1 AF ?? ?? 11 3C ?? ?? 22 8E 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 18 00 B0 AF 2C 00 BF AF 21 80 80 00 21 A0 A0 00 21 98 C0 00 0E 00 40 10 21 90 E0 00 00 00 02 AE 2C 00 BF 8F 1C 00 B1 8F 21 20 00 02 21 28 80 02 18 00 B0 8F 28 00 B4 8F 21 30 60 02 21 38 40 02 24 00 B3 8F 20 00 B2 8F ?? ?? ?? 0? 30 00 BD 27 ?? ?? 04 3C ?? ?? 84 24 21 28 00 00 21 30 00 00 ?? ?? ?? 0? ?? ?? 27 26 0E 00 40 04 ?? ?? 22 8E 2C 00 BF 8F 1C 00 B1 8F 00 00 02 AE 21 20 00 02 21 28 80 02 18 00 B0 8F 28 00 B4 8F 21 30 60 02 21 38 40 02 24 00 B3 8F 20 00 B2 8F ?? ?? ?? 0? 30 00 BD 27 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F FF FF 02 24 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "__setstate_r"
		size = 296
		refs = "0000 __gnu_local_gp 0110 __libc_errno"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3F 00 80 10 04 00 83 24 3D 00 A0 10 00 00 00 00 0C 00 A2 8C 38 00 40 10 08 00 A6 8C 04 00 A7 8C 23 38 E6 00 83 38 07 00 80 40 07 00 21 38 07 01 21 10 E2 00 FC FF C2 AC 00 00 86 8C 66 66 07 3C 67 66 E7 24 18 00 C7 00 C3 47 06 00 10 10 00 00 43 10 02 00 23 10 48 00 80 40 02 00 21 10 02 01 23 10 C2 00 05 00 46 2C 25 00 C0 10 04 00 49 24 ?? ?? 06 3C ?? ?? C6 24 80 48 09 00 80 40 02 00 21 40 06 01 21 48 C9 00 04 00 26 8D 00 00 08 8D 0C 00 A2 AC 10 00 A6 AC 11 00 40 10 14 00 A8 AC 00 00 82 8C 18 00 47 00 C3 17 02 00 10 38 00 00 43 38 07 00 23 38 E2 00 21 40 E8 00 1A 00 06 01 F4 01 C0 00 80 38 07 00 21 38 67 00 04 00 A7 AC 10 10 00 00 80 40 02 00 21 40 68 00 00 00 A8 AC 80 30 06 00 21 30 66 00 08 00 A3 AC 18 00 A6 AC 08 00 E0 03 21 10 00 00 ?? ?? ?? 0? FC FF C0 AC 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_57_1_0 {
	meta:
		name = "__random_r"
		size = 200
		refs = "0000 __gnu_local_gp 00b0 __libc_errno"
	strings:
		$1 = { ?? ?? 1C 3C 28 00 80 10 ?? ?? 9C 27 26 00 A0 10 00 00 00 00 0C 00 82 8C 1A 00 40 10 08 00 83 8C 00 00 82 8C 04 00 88 8C 18 00 89 8C 00 00 4B 8C 00 00 07 8D 04 00 46 24 2B 50 C9 00 21 38 67 01 42 58 07 00 00 00 47 AC 08 00 40 11 00 00 AB AC 04 00 08 25 2B 48 09 01 0B 18 09 01 00 00 86 AC 04 00 83 AC 08 00 E0 03 21 10 00 00 21 30 60 00 04 00 03 25 00 00 86 AC 04 00 83 AC 08 00 E0 03 21 10 00 00 00 00 66 8C C6 41 04 3C 6D 4E 84 24 02 20 C4 70 39 30 84 24 00 F0 84 7C 00 00 64 AC 08 00 E0 03 00 00 A4 AC 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_57_2_0 {
	meta:
		name = "__srandom_r"
		size = 352
		refs = "0130 __random_r"
	strings:
		$1 = { 55 00 A0 10 21 68 A0 00 0C 00 A3 8C 05 00 62 2C 51 00 40 10 00 00 00 00 08 00 AB 8C 01 00 02 24 0B 10 84 00 4A 00 60 10 00 00 62 AD 10 00 A5 8C 21 30 60 01 02 00 A3 28 2E 00 60 14 01 00 07 24 4E 83 0C 3C FF 7F 0A 3C 5F 0B 8C 25 FF FF 4A 35 18 00 4C 00 C3 27 02 00 04 00 C6 24 01 00 E7 24 10 18 00 00 21 18 62 00 03 1C 03 00 23 18 64 00 80 40 03 00 40 4A 03 00 23 48 28 01 23 48 23 01 C0 20 09 00 23 48 89 00 80 48 09 00 21 48 23 01 C0 20 09 00 21 48 24 01 23 10 49 00 80 71 03 00 C0 21 02 00 40 49 02 00 23 40 C8 01 21 48 24 01 23 40 03 01 80 20 08 00 00 71 09 00 23 40 88 00 23 48 C9 01 21 10 22 01 80 40 08 00 C0 20 02 00 21 18 03 01 23 10 82 00 80 18 03 00 23 10 43 00 21 18 4A 00 00 00 44 28 0B 10 64 00 D8 FF E5 14 00 00 C2 AC 14 00 A2 8D 40 60 05 00 C0 28 05 00 80 10 02 00 21 60 85 01 21 10 62 01 FF FF 8C 25 00 00 A2 AD 04 00 AB AD 0D 00 80 05 FF FF 0E 24 D8 FF BD 27 24 00 BF AF 21 20 A0 01 18 00 A5 27 ?? ?? ?? 0? FF FF 8C 25 FC FF 8E 15 21 20 A0 01 24 00 BF 8F 21 10 00 00 08 00 E0 03 28 00 BD 27 08 00 E0 03 21 10 00 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_57_3_0 {
	meta:
		name = "__initstate_r"
		size = 384
		refs = "0000 __gnu_local_gp 0074 __srandom_r 0168 __libc_errno"
	strings:
		$1 = { ?? ?? 1C 3C E0 FF BD 27 ?? ?? 9C 27 21 78 E0 00 1C 00 BF AF 18 00 B0 AF 51 00 E0 10 10 00 BC AF 08 00 E2 8C 05 00 40 10 21 80 A0 00 0C 00 E3 8C 3B 00 60 14 00 00 00 00 FC FF 40 AC 80 00 C2 2C 14 00 40 10 20 00 C2 2C 41 00 40 10 01 00 18 24 08 00 C6 2C 42 00 C0 14 00 00 00 00 04 00 02 26 0C 00 E0 AD 14 00 E0 AD 10 00 E0 AD 18 00 E2 AD 08 00 E2 AD ?? ?? ?? 0? 21 28 E0 01 00 00 00 AE 21 10 00 00 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 00 01 C6 2C 04 00 18 24 03 00 02 24 0B C0 46 00 04 00 02 27 ?? ?? 03 3C ?? ?? 63 24 80 10 02 00 21 10 62 00 80 28 18 00 04 00 42 8C 21 18 A3 00 00 00 65 8C 04 00 19 26 80 18 02 00 21 18 23 03 0C 00 F8 AD 14 00 E5 AD 18 00 E3 AD 08 00 F9 AD 10 00 E2 AD ?? ?? ?? 0? 21 28 E0 01 04 00 E3 8D 1C 00 BF 8F 21 10 00 00 23 C8 79 00 83 C8 19 00 80 18 19 00 21 C8 79 00 21 C0 38 03 00 00 18 AE 18 00 B0 8F 08 00 E0 03 20 00 BD 27 04 00 E5 8C 23 28 A2 00 83 28 05 00 80 38 05 00 21 28 E5 00 21 18 A3 00 FC FF 43 AC 80 00 C2 2C C1 FF 40 14 20 00 C2 2C ?? ?? ?? 0? 00 01 C6 2C 40 00 C6 2C 02 00 02 24 ?? ?? ?? 0? 0A C0 46 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "fputwc"
		size = 484
		refs = "006c __lll_lock_wait_private 0090 _IO_fwide 015c __woverflow 0190 _Unwind_Resume"
	strings:
		$1 = { 00 00 A2 8C D0 FF BD 27 28 00 B2 AF 00 80 42 30 20 00 B0 AF 2C 00 BF AF 24 00 B1 AF 21 80 A0 00 1A 00 40 14 21 90 80 00 3B E8 03 7C 48 00 A4 8C 70 8B 71 24 08 00 83 8C 11 00 71 10 00 00 00 00 18 00 A0 AF 00 00 85 C0 06 00 A0 14 00 00 03 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 03 24 0F 00 00 00 03 00 60 14 00 00 00 00 ?? ?? ?? 0? 18 00 A5 AF 48 00 03 8E 21 20 60 00 08 00 71 AC 04 00 83 8C 01 00 63 24 04 00 83 AC 21 20 00 02 ?? ?? ?? 0? 01 00 05 24 0C 00 40 04 FF FF 11 24 5C 00 02 8E 2D 00 40 10 21 20 00 02 10 00 43 8C 14 00 44 8C 2B 20 64 00 27 00 80 10 04 00 64 24 10 00 44 AC 21 88 40 02 00 00 72 AC 00 00 02 8E 00 80 42 30 07 00 40 14 2C 00 BF 8F 48 00 04 8E 04 00 82 8C FF FF 42 24 08 00 40 10 04 00 82 AC 2C 00 BF 8F 21 10 20 02 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 F0 FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 2C 00 BF 8F 21 20 00 02 ?? ?? ?? 0? 21 28 40 02 ?? ?? ?? 0? 21 88 40 00 00 00 02 8E 00 80 42 30 06 00 40 14 21 88 80 00 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "__towctrans_l"
		size = 132
		altNames = "__towctrans"
	strings:
		$1 = { 1E 00 A0 10 21 10 80 00 00 00 A6 8C 04 00 A3 8C 06 20 C4 00 2B 18 83 00 18 00 60 10 05 00 84 24 80 20 04 00 21 20 A4 00 00 00 83 8C 13 00 60 10 00 00 00 00 08 00 A4 8C 0C 00 A6 8C 06 20 82 00 24 20 86 00 80 20 04 00 21 18 83 00 21 18 A3 00 00 00 63 8C 09 00 60 10 00 00 00 00 10 00 A4 8C 24 20 44 00 80 20 04 00 21 18 83 00 21 28 A3 00 00 00 A3 8C 08 00 E0 03 21 10 43 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "wcscmp"
		size = 56
	strings:
		$1 = { 04 00 A5 24 FC FF A3 8C 04 00 84 24 08 00 60 10 FC FF 82 8C FB FF 43 10 04 00 A5 24 FC FF A5 24 2A 18 43 00 01 00 04 24 FF FF 02 24 0A 10 83 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "__iswalnum_l"
		size = 196
	strings:
		$1 = { 80 FF 02 24 24 10 82 00 27 00 40 10 00 00 00 00 00 00 A3 8C 68 00 65 8C 13 00 A5 24 80 28 05 00 21 18 65 00 04 00 63 8C 00 00 65 8C 04 00 66 8C 06 28 A4 00 2B 30 A6 00 19 00 C0 10 21 10 00 00 05 00 A5 24 80 28 05 00 21 28 65 00 00 00 A5 8C 13 00 A0 10 00 00 00 00 08 00 66 8C 0C 00 67 8C 06 30 C4 00 24 30 C7 00 80 30 06 00 21 28 C5 00 21 28 65 00 00 00 A5 8C 09 00 A0 10 42 31 04 00 10 00 62 8C 24 10 C2 00 80 10 02 00 21 28 45 00 21 18 65 00 00 00 62 8C 06 20 82 00 01 00 82 30 08 00 E0 03 00 00 00 00 34 00 A2 8C 40 20 04 00 21 20 44 00 00 00 82 94 08 00 42 30 08 00 E0 03 FF FF 42 30 }
	condition:
		$1
}

rule file_61_1_0 {
	meta:
		name = "__iswalpha_l"
		size = 196
	strings:
		$1 = { 80 FF 02 24 24 10 82 00 27 00 40 10 00 00 00 00 00 00 A3 8C 68 00 65 8C 0A 00 A5 24 80 28 05 00 21 18 65 00 04 00 63 8C 00 00 65 8C 04 00 66 8C 06 28 A4 00 2B 30 A6 00 19 00 C0 10 21 10 00 00 05 00 A5 24 80 28 05 00 21 28 65 00 00 00 A5 8C 13 00 A0 10 00 00 00 00 08 00 66 8C 0C 00 67 8C 06 30 C4 00 24 30 C7 00 80 30 06 00 21 28 C5 00 21 28 65 00 00 00 A5 8C 09 00 A0 10 42 31 04 00 10 00 62 8C 24 10 C2 00 80 10 02 00 21 28 45 00 21 18 65 00 00 00 62 8C 06 20 82 00 01 00 82 30 08 00 E0 03 00 00 00 00 34 00 A2 8C 40 20 04 00 21 20 44 00 00 00 82 94 00 04 42 30 08 00 E0 03 FF FF 42 30 }
	condition:
		$1
}

rule file_61_2_0 {
	meta:
		name = "__iswblank_l"
		size = 192
	strings:
		$1 = { 80 FF 02 24 24 10 82 00 27 00 40 10 00 00 00 00 00 00 A3 8C 68 00 65 8C 10 00 A5 24 80 28 05 00 21 18 65 00 04 00 63 8C 00 00 65 8C 04 00 66 8C 06 28 A4 00 2B 30 A6 00 19 00 C0 10 21 10 00 00 05 00 A5 24 80 28 05 00 21 28 65 00 00 00 A5 8C 13 00 A0 10 00 00 00 00 08 00 66 8C 0C 00 67 8C 06 30 C4 00 24 30 C7 00 80 30 06 00 21 28 C5 00 21 28 65 00 00 00 A5 8C 09 00 A0 10 42 31 04 00 10 00 62 8C 24 10 C2 00 80 10 02 00 21 28 45 00 21 18 65 00 00 00 62 8C 06 20 82 00 01 00 82 30 08 00 E0 03 00 00 00 00 34 00 A2 8C 40 20 04 00 21 20 44 00 00 00 82 94 08 00 E0 03 01 00 42 30 }
	condition:
		$1
}

rule file_61_3_0 {
	meta:
		name = "__iswcntrl_l"
		size = 196
	strings:
		$1 = { 80 FF 02 24 24 10 82 00 27 00 40 10 00 00 00 00 00 00 A3 8C 68 00 65 8C 11 00 A5 24 80 28 05 00 21 18 65 00 04 00 63 8C 00 00 65 8C 04 00 66 8C 06 28 A4 00 2B 30 A6 00 19 00 C0 10 21 10 00 00 05 00 A5 24 80 28 05 00 21 28 65 00 00 00 A5 8C 13 00 A0 10 00 00 00 00 08 00 66 8C 0C 00 67 8C 06 30 C4 00 24 30 C7 00 80 30 06 00 21 28 C5 00 21 28 65 00 00 00 A5 8C 09 00 A0 10 42 31 04 00 10 00 62 8C 24 10 C2 00 80 10 02 00 21 28 45 00 21 18 65 00 00 00 62 8C 06 20 82 00 01 00 82 30 08 00 E0 03 00 00 00 00 34 00 A2 8C 40 20 04 00 21 20 44 00 00 00 82 94 02 00 42 30 08 00 E0 03 FF FF 42 30 }
	condition:
		$1
}

rule file_61_4_0 {
	meta:
		name = "__iswdigit_l"
		size = 180
	strings:
		$1 = { 80 FF 02 24 24 10 82 00 27 00 40 10 00 00 00 00 00 00 A3 8C 68 00 65 8C 0B 00 A5 24 80 28 05 00 21 18 65 00 04 00 63 8C 00 00 65 8C 04 00 66 8C 06 28 A4 00 2B 30 A6 00 19 00 C0 10 21 10 00 00 05 00 A5 24 80 28 05 00 21 28 65 00 00 00 A5 8C 13 00 A0 10 00 00 00 00 08 00 66 8C 0C 00 67 8C 06 30 C4 00 24 30 C7 00 80 30 06 00 21 28 C5 00 21 28 65 00 00 00 A5 8C 09 00 A0 10 42 31 04 00 10 00 62 8C 24 10 C2 00 80 10 02 00 21 28 45 00 21 18 65 00 00 00 62 8C 06 20 82 00 01 00 82 30 08 00 E0 03 00 00 00 00 D0 FF 84 24 08 00 E0 03 0A 00 82 2C }
	condition:
		$1
}

rule file_61_5_0 {
	meta:
		name = "__iswlower_l"
		size = 196
	strings:
		$1 = { 80 FF 02 24 24 10 82 00 27 00 40 10 00 00 00 00 00 00 A3 8C 68 00 65 8C 09 00 A5 24 80 28 05 00 21 18 65 00 04 00 63 8C 00 00 65 8C 04 00 66 8C 06 28 A4 00 2B 30 A6 00 19 00 C0 10 21 10 00 00 05 00 A5 24 80 28 05 00 21 28 65 00 00 00 A5 8C 13 00 A0 10 00 00 00 00 08 00 66 8C 0C 00 67 8C 06 30 C4 00 24 30 C7 00 80 30 06 00 21 28 C5 00 21 28 65 00 00 00 A5 8C 09 00 A0 10 42 31 04 00 10 00 62 8C 24 10 C2 00 80 10 02 00 21 28 45 00 21 18 65 00 00 00 62 8C 06 20 82 00 01 00 82 30 08 00 E0 03 00 00 00 00 34 00 A2 8C 40 20 04 00 21 20 44 00 00 00 82 94 00 02 42 30 08 00 E0 03 FF FF 42 30 }
	condition:
		$1
}

rule file_61_6_0 {
	meta:
		name = "__iswgraph_l"
		size = 196
	strings:
		$1 = { 80 FF 02 24 24 10 82 00 27 00 40 10 00 00 00 00 00 00 A3 8C 68 00 65 8C 0F 00 A5 24 80 28 05 00 21 18 65 00 04 00 63 8C 00 00 65 8C 04 00 66 8C 06 28 A4 00 2B 30 A6 00 19 00 C0 10 21 10 00 00 05 00 A5 24 80 28 05 00 21 28 65 00 00 00 A5 8C 13 00 A0 10 00 00 00 00 08 00 66 8C 0C 00 67 8C 06 30 C4 00 24 30 C7 00 80 30 06 00 21 28 C5 00 21 28 65 00 00 00 A5 8C 09 00 A0 10 42 31 04 00 10 00 62 8C 24 10 C2 00 80 10 02 00 21 28 45 00 21 18 65 00 00 00 62 8C 06 20 82 00 01 00 82 30 08 00 E0 03 00 00 00 00 34 00 A2 8C 40 20 04 00 21 20 44 00 00 00 82 94 00 80 42 30 08 00 E0 03 FF FF 42 30 }
	condition:
		$1
}

rule file_61_7_0 {
	meta:
		name = "__iswprint_l"
		size = 196
	strings:
		$1 = { 80 FF 02 24 24 10 82 00 27 00 40 10 00 00 00 00 00 00 A3 8C 68 00 65 8C 0E 00 A5 24 80 28 05 00 21 18 65 00 04 00 63 8C 00 00 65 8C 04 00 66 8C 06 28 A4 00 2B 30 A6 00 19 00 C0 10 21 10 00 00 05 00 A5 24 80 28 05 00 21 28 65 00 00 00 A5 8C 13 00 A0 10 00 00 00 00 08 00 66 8C 0C 00 67 8C 06 30 C4 00 24 30 C7 00 80 30 06 00 21 28 C5 00 21 28 65 00 00 00 A5 8C 09 00 A0 10 42 31 04 00 10 00 62 8C 24 10 C2 00 80 10 02 00 21 28 45 00 21 18 65 00 00 00 62 8C 06 20 82 00 01 00 82 30 08 00 E0 03 00 00 00 00 34 00 A2 8C 40 20 04 00 21 20 44 00 00 00 82 94 00 40 42 30 08 00 E0 03 FF FF 42 30 }
	condition:
		$1
}

rule file_61_8_0 {
	meta:
		name = "__iswpunct_l"
		size = 196
	strings:
		$1 = { 80 FF 02 24 24 10 82 00 27 00 40 10 00 00 00 00 00 00 A3 8C 68 00 65 8C 12 00 A5 24 80 28 05 00 21 18 65 00 04 00 63 8C 00 00 65 8C 04 00 66 8C 06 28 A4 00 2B 30 A6 00 19 00 C0 10 21 10 00 00 05 00 A5 24 80 28 05 00 21 28 65 00 00 00 A5 8C 13 00 A0 10 00 00 00 00 08 00 66 8C 0C 00 67 8C 06 30 C4 00 24 30 C7 00 80 30 06 00 21 28 C5 00 21 28 65 00 00 00 A5 8C 09 00 A0 10 42 31 04 00 10 00 62 8C 24 10 C2 00 80 10 02 00 21 28 45 00 21 18 65 00 00 00 62 8C 06 20 82 00 01 00 82 30 08 00 E0 03 00 00 00 00 34 00 A2 8C 40 20 04 00 21 20 44 00 00 00 82 94 04 00 42 30 08 00 E0 03 FF FF 42 30 }
	condition:
		$1
}

rule file_61_9_0 {
	meta:
		name = "__iswspace_l"
		size = 196
	strings:
		$1 = { 80 FF 02 24 24 10 82 00 27 00 40 10 00 00 00 00 00 00 A3 8C 68 00 65 8C 0D 00 A5 24 80 28 05 00 21 18 65 00 04 00 63 8C 00 00 65 8C 04 00 66 8C 06 28 A4 00 2B 30 A6 00 19 00 C0 10 21 10 00 00 05 00 A5 24 80 28 05 00 21 28 65 00 00 00 A5 8C 13 00 A0 10 00 00 00 00 08 00 66 8C 0C 00 67 8C 06 30 C4 00 24 30 C7 00 80 30 06 00 21 28 C5 00 21 28 65 00 00 00 A5 8C 09 00 A0 10 42 31 04 00 10 00 62 8C 24 10 C2 00 80 10 02 00 21 28 45 00 21 18 65 00 00 00 62 8C 06 20 82 00 01 00 82 30 08 00 E0 03 00 00 00 00 34 00 A2 8C 40 20 04 00 21 20 44 00 00 00 82 94 00 20 42 30 08 00 E0 03 FF FF 42 30 }
	condition:
		$1
}

rule file_61_10_0 {
	meta:
		name = "__iswupper_l"
		size = 196
	strings:
		$1 = { 80 FF 02 24 24 10 82 00 27 00 40 10 00 00 00 00 00 00 A3 8C 68 00 65 8C 08 00 A5 24 80 28 05 00 21 18 65 00 04 00 63 8C 00 00 65 8C 04 00 66 8C 06 28 A4 00 2B 30 A6 00 19 00 C0 10 21 10 00 00 05 00 A5 24 80 28 05 00 21 28 65 00 00 00 A5 8C 13 00 A0 10 00 00 00 00 08 00 66 8C 0C 00 67 8C 06 30 C4 00 24 30 C7 00 80 30 06 00 21 28 C5 00 21 28 65 00 00 00 A5 8C 09 00 A0 10 42 31 04 00 10 00 62 8C 24 10 C2 00 80 10 02 00 21 28 45 00 21 18 65 00 00 00 62 8C 06 20 82 00 01 00 82 30 08 00 E0 03 00 00 00 00 34 00 A2 8C 40 20 04 00 21 20 44 00 00 00 82 94 00 01 42 30 08 00 E0 03 FF FF 42 30 }
	condition:
		$1
}

rule file_61_11_0 {
	meta:
		name = "__iswxdigit_l"
		size = 196
	strings:
		$1 = { 80 FF 02 24 24 10 82 00 27 00 40 10 00 00 00 00 00 00 A3 8C 68 00 65 8C 0C 00 A5 24 80 28 05 00 21 18 65 00 04 00 63 8C 00 00 65 8C 04 00 66 8C 06 28 A4 00 2B 30 A6 00 19 00 C0 10 21 10 00 00 05 00 A5 24 80 28 05 00 21 28 65 00 00 00 A5 8C 13 00 A0 10 00 00 00 00 08 00 66 8C 0C 00 67 8C 06 30 C4 00 24 30 C7 00 80 30 06 00 21 28 C5 00 21 28 65 00 00 00 A5 8C 09 00 A0 10 42 31 04 00 10 00 62 8C 24 10 C2 00 80 10 02 00 21 28 45 00 21 18 65 00 00 00 62 8C 06 20 82 00 01 00 82 30 08 00 E0 03 00 00 00 00 34 00 A2 8C 40 20 04 00 21 20 44 00 00 00 82 94 00 10 42 30 08 00 E0 03 FF FF 42 30 }
	condition:
		$1
}

rule file_61_12_0 {
	meta:
		name = "__towlower_l"
		size = 148
	strings:
		$1 = { 00 00 A3 8C 21 10 80 00 6C 00 65 8C 09 00 A5 24 80 28 05 00 21 18 65 00 04 00 63 8C 00 00 66 8C 04 00 65 8C 06 20 C4 00 2B 28 85 00 17 00 A0 10 05 00 84 24 80 20 04 00 21 20 64 00 00 00 84 8C 12 00 80 10 00 00 00 00 08 00 65 8C 0C 00 66 8C 06 28 A2 00 24 28 A6 00 80 28 05 00 21 20 A4 00 21 20 64 00 00 00 84 8C 08 00 80 10 00 00 00 00 10 00 65 8C 24 28 45 00 80 28 05 00 21 20 A4 00 21 18 64 00 00 00 63 8C 21 10 43 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_61_13_0 {
	meta:
		name = "__towupper_l"
		size = 148
	strings:
		$1 = { 00 00 A3 8C 21 10 80 00 6C 00 65 8C 08 00 A5 24 80 28 05 00 21 18 65 00 04 00 63 8C 00 00 66 8C 04 00 65 8C 06 20 C4 00 2B 28 85 00 17 00 A0 10 05 00 84 24 80 20 04 00 21 20 64 00 00 00 84 8C 12 00 80 10 00 00 00 00 08 00 65 8C 0C 00 66 8C 06 28 A2 00 24 28 A6 00 80 28 05 00 21 20 A4 00 21 20 64 00 00 00 84 8C 08 00 80 10 00 00 00 00 10 00 65 8C 24 28 45 00 80 28 05 00 21 20 A4 00 21 18 64 00 00 00 63 8C 21 10 43 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "__strnlen"
		size = 268
	strings:
		$1 = { 33 00 A0 10 21 10 00 00 21 28 85 00 2B 30 A4 00 FF FF 03 24 03 00 82 30 38 00 40 10 0B 28 66 00 00 00 82 80 37 00 40 10 00 00 00 00 ?? ?? ?? 0? 21 10 80 00 00 00 43 80 23 00 60 10 2B 18 A2 00 01 00 42 24 03 00 43 30 FA FF 60 14 00 00 00 00 2B 18 45 00 1B 00 60 10 FE FE 09 3C 80 80 08 3C FF FE 29 35 80 80 08 35 04 00 43 24 FC FF 66 8C 21 30 C9 00 24 30 C8 00 0D 00 C0 10 2B 38 65 00 FC FF 66 80 0F 00 C0 10 00 00 00 00 FD FF 66 80 0B 00 C0 10 00 00 00 00 FE FF 66 80 15 00 C0 10 00 00 00 00 FF FF 66 80 0B 00 C0 10 00 00 00 00 0B 00 E0 10 00 00 00 00 ?? ?? ?? 0? 21 10 60 00 01 00 42 24 2B 18 A2 00 0B 10 A3 00 23 10 44 00 08 00 E0 03 00 00 00 00 ?? ?? ?? 0? 03 00 42 24 21 10 A0 00 2B 18 A5 00 0B 10 A3 00 08 00 E0 03 23 10 44 00 ?? ?? ?? 0? 02 00 42 24 ?? ?? ?? 0? 21 10 80 00 ?? ?? ?? 0? 21 10 80 00 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "__posix_spawnp"
		size = 48
		refs = "001c __spawni"
	strings:
		$1 = { D0 FF BD 27 40 00 A2 8F 2C 00 BF AF 10 00 A2 AF 44 00 A2 8F 14 00 A2 AF 01 00 02 24 ?? ?? ?? 0? 18 00 A2 AF 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "wait_on_socket"
		size = 336
		refs = "0004 __gnu_local_gp 0040 __poll 0074 __libc_errno 0094 __gettimeofday"
	strings:
		$1 = { C0 FF BD 27 ?? ?? 1C 3C 28 00 B0 AF 21 80 A0 00 ?? ?? 9C 27 20 00 A4 AF 19 00 02 24 20 00 A4 27 01 00 05 24 21 30 00 02 10 00 BC AF 3C 00 BF AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF ?? ?? ?? 0? 24 00 A2 A7 FF FF 03 24 09 00 43 10 10 00 BC 8F 3C 00 BF 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? 91 8F 3B E8 03 7C 21 88 23 02 00 00 24 8E 04 00 03 24 F3 FF 83 14 3C 00 BF 8F 18 00 A4 27 ?? ?? ?? 0? 21 28 00 00 1C 00 A3 8F E8 03 02 24 18 00 A4 8F F4 01 63 24 1A 00 62 00 F4 01 40 00 62 10 12 3C 21 A0 20 02 FF FF 13 24 D3 4D 52 26 12 18 00 00 02 28 44 70 21 10 B0 00 ?? ?? ?? 0? 21 88 43 00 00 00 86 8E 04 00 03 24 DD FF C3 14 3C 00 BF 8F ?? ?? ?? 0? 00 00 00 00 1C 00 A3 8F 18 00 A2 8F F4 01 63 24 18 00 72 00 80 28 02 00 C0 31 02 00 23 28 C5 00 C3 1F 03 00 21 10 A2 00 C0 10 02 00 10 20 00 00 83 21 04 00 23 80 64 00 23 80 02 02 21 80 11 02 20 00 A4 27 01 00 05 24 ?? ?? ?? 0? 21 30 00 02 18 00 A4 27 E5 FF 53 10 21 28 00 00 ?? ?? ?? 0? 3C 00 BF 8F }
	condition:
		$1
}

rule file_64_1_0 {
	meta:
		name = "open_socket"
		size = 740
		refs = "0008 __have_sock_cloexec 0010 __gnu_local_gp 0058 __socket 00bc $LC0 0118 __connect 0140 memcpy 0154 __libc_errno 016c __send 0224 __gettimeofday 025c __poll 02a0 __fcntl"
	strings:
		$1 = { 40 FF BD 27 A0 00 B0 AF ?? ?? 10 3C ?? ?? 02 8E ?? ?? 1C 3C B8 00 BE AF ?? ?? 9C 27 21 F0 A0 03 B0 00 B4 AF AC 00 B3 AF A8 00 B2 AF BC 00 BF AF B4 00 B5 AF A4 00 B1 AF 10 00 DC AF 21 98 80 00 21 A0 A0 00 5C 00 40 04 21 90 C0 00 08 00 05 3C 01 00 04 24 82 00 A5 24 ?? ?? ?? 0? 21 30 00 00 ?? ?? 03 8E 21 88 40 00 10 00 DC 8F 05 00 60 14 21 10 60 00 FF FF 03 24 7E 00 23 12 01 00 02 24 ?? ?? 02 AE 4D 00 40 04 01 00 04 24 88 00 20 06 0F 00 43 26 FC FF 02 24 24 18 62 00 0A 00 63 24 C2 18 03 00 ?? ?? 02 8E C0 18 03 00 23 E8 A3 03 10 00 B0 27 78 00 40 04 0C 00 55 26 ?? ?? 03 3C ?? ?? 62 8C ?? ?? 63 24 04 00 64 8C 01 00 05 24 18 00 C5 A7 1D 00 C2 AB 1A 00 C2 BB 08 00 62 8C 21 00 C4 AB 1E 00 C4 BB 0C 00 64 8C 25 00 C2 AB 22 00 C2 BB 10 00 62 8C 29 00 C4 AB 14 00 63 90 26 00 C4 BB 2D 00 C2 AB 21 20 20 02 18 00 C5 27 6E 00 06 24 2A 00 C2 BB ?? ?? ?? 0? 2E 00 C3 A3 2B 00 40 04 10 00 DC 8F 02 00 02 24 21 30 40 02 04 00 13 AE 08 00 12 AE 0C 00 04 26 21 28 80 02 ?? ?? ?? 0? 00 00 02 AE 10 00 DC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 01 00 12 24 21 98 62 00 21 20 20 02 21 28 00 02 21 30 A0 02 ?? ?? ?? 0? 00 40 07 24 FF FF 03 24 22 00 43 10 04 00 04 24 1C 00 55 14 21 20 20 02 21 10 20 02 21 E8 C0 03 BC 00 BF 8F B8 00 BE 8F B4 00 B5 8F B0 00 B4 8F AC 00 B3 8F A8 00 B2 8F A4 00 B1 8F A0 00 B0 8F 08 00 E0 03 C0 00 BD 27 01 00 04 24 02 00 05 24 ?? ?? ?? 0? 21 30 00 00 ?? ?? ?? 0? 21 88 40 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 43 8C 96 00 02 24 CF FF 62 10 00 00 00 00 21 20 20 02 A6 0F 02 24 0C 00 00 00 ?? ?? ?? 0? FF FF 02 24 00 00 63 8E D5 FF 64 10 00 00 00 00 DE FF A2 12 21 10 20 02 0B 00 02 24 F4 FF 62 14 90 00 C4 27 ?? ?? ?? 0? 21 28 00 00 22 00 40 12 9C 00 C4 8F 90 00 C2 8F 94 00 C3 8F 88 13 06 24 05 00 42 24 9C 00 C3 AF 98 00 C2 AF 1C 00 02 24 88 00 C4 27 01 00 05 24 88 00 D1 AF ?? ?? ?? 0? 8C 00 C2 A7 E2 FF 40 18 21 90 00 00 ?? ?? ?? 0? 21 20 20 02 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 83 8C 16 00 63 38 0A 10 23 02 ?? ?? ?? 0? ?? ?? 02 AE 21 20 20 02 04 00 05 24 ?? ?? ?? 0? 82 00 06 24 ?? ?? ?? 0? ?? ?? 03 3C ?? ?? ?? 0? FF FF 02 24 94 00 C3 8F E8 03 02 24 98 00 C5 8F 23 18 83 00 1A 00 62 00 F4 01 40 00 90 00 C4 8F 23 20 A4 00 00 00 82 70 ?? ?? ?? 0? 12 30 00 00 }
	condition:
		$1
}

rule file_64_2_0 {
	meta:
		name = "__readall"
		size = 260
		refs = "0000 __gnu_local_gp 0010 __libc_errno 0060 __read"
	strings:
		$1 = { ?? ?? 1C 3C C0 FF BD 27 ?? ?? 9C 27 34 00 B6 AF ?? ?? 96 8F 3B E8 03 7C 38 00 B7 AF 30 00 B5 AF 2C 00 B4 AF 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF 3C 00 BF AF 1C 00 B0 AF 10 00 BC AF 21 A8 C0 00 21 98 80 00 21 90 A0 00 21 88 C0 00 FF FF 14 24 0B 00 17 24 21 B0 C3 02 21 28 40 02 21 30 20 02 ?? ?? ?? 0? 21 20 60 02 12 00 54 10 21 80 40 00 18 00 40 18 00 00 00 00 23 88 22 02 F6 FF 20 16 21 90 42 02 23 10 B1 02 3C 00 BF 8F 38 00 B7 8F 34 00 B6 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 40 00 BD 27 00 00 C2 8E 04 00 03 24 E7 FF 43 10 21 28 40 02 08 00 57 10 21 10 00 02 ?? ?? ?? 0? 00 00 00 00 EC FF 40 10 23 10 B1 02 00 00 C2 8E E9 FF 57 14 21 10 00 02 21 20 60 02 ?? ?? ?? 0? C8 00 05 24 D8 FF 40 1C 21 10 00 02 ?? ?? ?? 0? 3C 00 BF 8F }
	condition:
		$1
}

rule file_64_3_0 {
	meta:
		name = "__readvall"
		size = 608
		refs = "0000 __gnu_local_gp 0010 __libc_errno 0074 __readv 010c memcpy"
	strings:
		$1 = { ?? ?? 1C 3C B8 FF BD 27 ?? ?? 9C 27 38 00 B6 AF ?? ?? 96 8F 40 00 BE AF 3B E8 03 7C 21 F0 A0 03 34 00 B5 AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF 44 00 BF AF 3C 00 B7 AF 20 00 B0 AF 21 A0 80 00 10 00 DC AF 21 88 A0 00 21 98 C0 00 FF FF 12 24 21 B0 C3 02 ?? ?? ?? 0? 04 00 15 24 00 00 C2 8E 71 00 55 14 0B 00 03 24 21 20 80 02 21 28 20 02 ?? ?? ?? 0? 21 30 60 02 21 80 40 00 F7 FF 52 10 10 00 DC 8F 60 00 40 18 00 00 00 00 0B 00 60 1A 21 90 00 00 C0 20 13 00 21 30 00 00 21 10 26 02 04 00 42 8C 08 00 C6 24 FC FF C4 14 21 90 42 02 2B 10 12 02 0F 00 40 14 0A 00 C2 24 21 E8 C0 03 44 00 DF 8F 21 10 00 02 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 C2 10 02 00 C0 10 02 00 21 A8 A0 03 23 E8 A2 03 10 00 A4 27 ?? ?? ?? 0? 21 28 20 02 10 00 DC 8F 3B E8 03 7C 21 20 60 00 ?? ?? 96 8F 21 B8 40 00 21 18 00 02 FF FF 11 24 21 B0 C4 02 04 00 E2 8E 2B 20 62 00 1F 00 80 10 00 00 00 00 00 00 E4 8E 23 10 43 00 04 00 E2 AE 21 18 83 00 00 00 E3 AE 21 20 80 02 21 28 E0 02 ?? ?? ?? 0? 21 30 60 02 18 00 51 10 21 18 40 00 20 00 40 1C 00 00 00 00 30 00 40 14 00 00 00 00 21 E8 A0 02 21 E8 C0 03 44 00 BF 8F 21 10 00 02 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 23 18 62 00 FF FF 73 26 ?? ?? ?? 0? 08 00 F7 26 00 00 C2 8E 04 00 04 24 E1 FF 44 10 21 20 80 02 0B 00 04 24 18 00 44 10 21 20 80 02 21 80 60 00 ?? ?? ?? 0? 21 E8 A0 02 21 80 02 02 2B 10 12 02 CD FF 40 14 00 00 00 00 ?? ?? ?? 0? 21 E8 A0 02 AC FF 40 10 00 00 00 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 42 8C 0B 00 03 24 A4 FF 43 14 00 00 00 00 ?? ?? ?? 0? 21 80 00 00 ?? ?? ?? 0? 00 00 C2 8E C8 00 05 24 ?? ?? ?? 0? 18 00 C3 AF C1 FF 40 1C 18 00 C3 8F ?? ?? ?? 0? 21 80 60 00 }
	condition:
		$1
}

rule file_64_4_0 {
	meta:
		name = "__nscd_unmap"
		size = 88
		refs = "001c __munmap 0030 free 0038 $LC1 003c $LC2 0050 __assert_fail 0040 __PRETTY_FUNCTION__.10554"
	strings:
		$1 = { 0C 00 82 8C E0 FF BD 27 18 00 B0 AF 1C 00 BF AF 09 00 40 14 21 80 80 00 00 00 84 8C ?? ?? ?? 0? 08 00 05 8E 1C 00 BF 8F 21 20 00 02 18 00 B0 8F ?? ?? ?? 0? 20 00 BD 27 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 10 01 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_64_5_0 {
	meta:
		name = "__nscd_get_mapping"
		size = 1012
		refs = "0004 __gnu_local_gp 0048 strlen 005c __libc_errno 0138 __recvmsg 0178 strcmp 018c __fxstat64 01b4 __close 0238 __nscd_unmap 02a8 __mmap 0320 malloc 0378 __munmap 0394 time"
	strings:
		$1 = { C0 FE BD 27 ?? ?? 1C 3C ?? ?? 9C 27 38 01 BE AF 18 01 B0 AF 21 F0 A0 03 21 80 80 00 21 20 A0 00 3C 01 BF AF 34 01 B7 AF 30 01 B6 AF 2C 01 B5 AF 28 01 B4 AF 24 01 B3 AF 20 01 B2 AF 1C 01 B1 AF 18 00 DC AF 21 A0 A0 00 ?? ?? ?? 0? 21 B0 C0 00 18 00 DC 8F 21 A8 40 00 01 00 A3 26 ?? ?? 97 8F 08 00 42 24 08 01 C3 AF C2 10 02 00 3B E8 03 7C 21 98 E3 02 C0 10 02 00 23 E8 A2 03 08 01 C6 8F 00 00 62 8E 21 20 00 02 21 28 80 02 ?? ?? ?? 0? 0C 01 C2 AF 18 00 A3 27 21 80 40 00 10 01 C3 AF 46 00 40 04 FF FF 12 24 EC 00 C3 AF 08 01 C3 8F 10 00 02 24 21 20 00 02 F0 00 C3 AF 00 01 C3 27 F4 00 C3 AF 08 00 03 24 F8 00 C3 AF EC 00 C3 27 C8 00 C3 AF 02 00 03 24 CC 00 C3 AF DC 00 C3 27 D0 00 C3 AF FF FF 03 34 E0 00 C3 AF 88 13 05 24 01 00 03 24 C0 00 C0 AF C4 00 C0 AF D8 00 C0 AF D4 00 C2 AF E4 00 C3 AF DC 00 C2 AF ?? ?? ?? 0? E8 00 D2 AF 26 00 40 18 FF FF 11 24 ?? ?? ?? 0? 04 00 12 24 00 00 63 8E 07 00 72 14 D4 00 C3 8F 21 20 00 02 C0 00 C5 27 ?? ?? ?? 0? 00 40 06 3C F8 FF 51 10 D4 00 C3 8F 0C 00 63 2C 18 00 60 14 D0 00 C3 8F 16 00 60 10 00 00 00 00 00 00 64 8C 10 00 03 24 12 00 83 14 08 01 C3 8F 42 00 62 14 E8 00 D1 8F 10 01 C4 8F ?? ?? ?? 0? 21 28 80 02 9A 00 40 14 03 00 04 24 21 28 20 02 ?? ?? ?? 0? 20 00 C6 27 95 00 40 14 5C 00 C2 8F 8F 00 40 18 58 00 C3 8F 00 01 C3 AF ?? ?? ?? 0? 04 01 C2 AF FF FF 12 24 ?? ?? ?? 0? 21 20 00 02 00 00 C4 8E 0C 01 C2 8F 3B E8 03 7C 21 B8 E3 02 00 00 E2 AE 0B 00 80 10 00 00 D2 AE 0C 00 82 24 00 00 43 C0 FF FF 61 24 00 00 41 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 01 00 02 24 0F 00 62 10 00 00 00 00 21 E8 C0 03 3C 01 BF 8F 21 10 40 02 38 01 BE 8F 34 01 B7 8F 30 01 B6 8F 2C 01 B5 8F 28 01 B4 8F 24 01 B3 8F 20 01 B2 8F 1C 01 B1 8F 18 01 B0 8F 08 00 E0 03 40 01 BD 27 ?? ?? ?? 0? 00 00 00 00 21 E8 C0 03 3C 01 DF 8F 21 10 40 02 38 01 BE 8F 34 01 B7 8F 30 01 B6 8F 2C 01 B5 8F 28 01 B4 8F 24 01 B3 8F 20 01 B2 8F 1C 01 B1 8F 18 01 B0 8F 08 00 E0 03 40 01 BD 27 09 00 B5 26 5B 00 55 14 10 01 C4 8F ?? ?? ?? 0? 21 28 80 02 32 00 40 14 FF FF 12 24 00 01 C5 8F 10 00 B1 AF 14 00 A0 AF 21 20 00 00 01 00 06 24 ?? ?? ?? 0? 01 00 07 24 21 A8 40 00 FF FF 02 24 4C 00 A2 12 02 00 02 24 00 00 A3 8E 43 00 62 14 78 00 02 24 04 00 A3 8E 29 00 62 14 00 01 C5 8F 28 00 A2 8E 26 00 40 10 00 00 00 00 0C 00 A3 8E 27 00 60 10 00 00 00 00 80 10 02 00 2C 00 B4 8E 0F 00 45 24 00 01 C3 8F 04 01 C2 8F F0 FF 04 24 24 28 A4 00 78 00 93 26 21 98 65 02 14 00 40 10 08 01 C3 AF 14 00 04 24 ?? ?? ?? 0? 14 01 C5 AF 21 90 40 00 11 00 40 10 14 01 C5 8F 04 00 A2 8E 00 00 55 AE 08 00 53 AE 21 28 A2 00 21 A8 A5 02 01 00 02 24 04 00 55 AE 10 00 54 AE 0C 00 42 AE ?? ?? ?? 0? 21 20 20 02 ?? ?? ?? 0? 00 00 00 00 2B 10 73 00 EC FF 40 10 14 00 04 24 08 01 C5 8F ?? ?? ?? 0? 21 20 A0 02 ?? ?? ?? 0? FF FF 12 24 10 00 B2 8E 21 20 00 00 14 00 B3 8E ?? ?? ?? 0? 00 00 00 00 2C 01 43 26 2B 20 72 00 C3 2F 02 00 21 20 93 00 2B 30 85 00 08 00 C0 14 00 00 00 00 03 00 A4 10 00 00 00 00 ?? ?? ?? 0? 28 00 A2 8E 2B 10 62 00 FC FF 40 10 00 00 00 00 ?? ?? ?? 0? 00 01 C5 8F 03 00 40 14 78 00 64 2C 6F FF 80 10 00 00 00 00 ?? ?? ?? 0? FF FF 12 24 }
	condition:
		$1
}

rule file_64_6_0 {
	meta:
		name = "__nscd_get_map_ref"
		size = 460
		refs = "00bc __nscd_get_mapping 0178 time"
	strings:
		$1 = { 04 00 C2 8C C0 FF BD 27 FF FF 03 24 30 00 B2 AF 3C 00 BF AF 38 00 B4 AF 34 00 B3 AF 2C 00 B1 AF 28 00 B0 AF 47 00 43 10 21 90 C0 00 21 A0 80 00 06 00 06 24 18 00 A0 AF 18 00 A2 8F 00 00 44 C2 06 00 82 14 00 00 03 24 01 00 01 24 00 00 41 E2 FA FF 20 10 01 00 03 24 0F 00 00 00 34 00 60 10 00 00 00 00 18 00 A2 8F 1C 00 A2 AF 1C 00 A2 8F 31 00 40 14 00 00 00 00 04 00 53 8E FF FF 02 24 50 00 62 12 00 00 00 00 0B 00 60 12 21 20 80 02 00 00 62 8E 0C 00 43 8C 33 00 60 10 00 00 00 00 2C 00 44 8C 10 00 63 8E 2B 18 64 00 0A 00 60 10 00 00 00 00 21 20 80 02 04 00 46 26 ?? ?? ?? 0? 24 00 A7 AF 21 98 40 00 FF FF 02 24 3D 00 62 12 24 00 A7 8F 00 00 62 8E 08 00 42 8C 01 00 43 30 38 00 60 14 00 00 E2 AC 0C 00 62 26 0F 00 00 00 00 00 41 C0 01 00 21 24 00 00 41 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 3C 00 BF 8F 00 00 40 AE 21 10 60 02 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? ?? 0? 18 00 A4 AF FF FF C6 24 BD FF C0 14 00 00 00 00 3C 00 BF 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F FF FF 02 24 08 00 E0 03 40 00 BD 27 10 00 50 8C 21 20 00 00 14 00 51 8C 20 00 A5 AF ?? ?? ?? 0? 24 00 A7 AF 2C 01 06 26 2B 18 D0 00 C3 27 02 00 21 18 71 00 2B 40 64 00 20 00 A5 8F C6 FF 00 15 24 00 A7 8F 03 00 83 10 00 00 00 00 ?? ?? ?? 0? 00 00 62 8E 2B 10 C2 00 C0 FF 40 14 21 20 80 02 ?? ?? ?? 0? 00 00 62 8E ?? ?? ?? 0? FF FF 13 24 }
	condition:
		$1
}

rule file_64_7_0 {
	meta:
		name = "__nscd_cache_search"
		size = 504
		refs = "0040 __nis_hash 015c memcmp"
	strings:
		$1 = { B8 FF BD 27 4C 00 A5 AF 40 00 BE AF 21 F0 80 00 4C 00 A4 8F 20 00 B0 AF 21 28 C0 00 21 80 E0 00 38 00 B6 AF 34 00 B5 AF 2C 00 B3 AF 24 00 B1 AF 44 00 BF AF 3C 00 B7 AF 30 00 B4 AF 28 00 B2 AF ?? ?? ?? 0? 21 B0 C0 00 10 00 15 8E CC CC 13 3C CD CC 73 36 19 00 B3 02 00 00 03 8E 28 00 64 8C 10 98 00 00 42 99 13 00 1B 00 44 00 F4 01 80 00 10 10 00 00 1E 00 44 24 80 20 04 00 21 18 64 00 FF FF 02 24 00 00 71 8C 4E 00 22 12 1C 00 22 26 2B 10 A2 02 4C 00 40 14 21 10 00 00 04 00 17 8E 21 80 F1 02 03 00 02 32 46 00 40 14 58 00 A9 8F FF FF 73 26 21 90 00 00 18 00 29 25 FF FF 14 24 ?? ?? ?? 0? 01 00 07 24 10 00 02 8E 3D 00 22 12 00 00 00 00 3B 00 74 12 00 00 00 00 08 00 40 12 21 18 F1 02 03 00 64 30 36 00 80 14 1C 00 31 26 2B 88 B1 02 33 00 20 16 00 00 00 00 10 00 71 8C 30 00 54 10 23 90 F2 00 1C 00 43 24 2B 18 A3 02 2C 00 60 14 21 80 E2 02 03 00 02 32 29 00 40 14 FF FF 73 26 00 00 02 92 E7 FF 5E 14 00 00 00 00 04 00 02 8E E4 FF 56 14 00 00 00 00 08 00 05 8E 21 10 B6 00 2B 10 A2 02 DF FF 40 14 4C 00 A4 8F 21 28 E5 02 21 30 C0 02 1C 00 A7 AF ?? ?? ?? 0? 18 00 A9 AF 1C 00 A7 8F D7 FF 40 14 18 00 A9 8F 14 00 03 8E 18 00 62 24 2B 10 A2 02 D2 FF 40 14 21 10 E3 02 07 00 44 30 0E 00 80 14 00 00 00 00 12 00 44 90 CC FF 80 10 00 00 00 00 00 00 44 8C 21 20 64 00 2B 20 A4 02 C7 FF 80 14 21 18 23 01 2B 18 A3 02 C4 FF 60 14 44 00 BF 8F ?? ?? ?? 0? 40 00 BE 8F 21 10 00 00 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_64_8_0 {
	meta:
		name = "__nscd_open_socket"
		size = 320
		refs = "0000 __gnu_local_gp 0044 __libc_errno 00a4 __read"
	strings:
		$1 = { ?? ?? 1C 3C C0 FF BD 27 ?? ?? 9C 27 01 04 A3 2C 21 10 A0 00 20 00 B1 AF 3C 00 BF AF 38 00 B7 AF 34 00 B6 AF 30 00 B5 AF 2C 00 B4 AF 28 00 B3 AF 24 00 B2 AF 1C 00 B0 AF 10 00 BC AF 3E 00 60 10 50 00 B1 8F ?? ?? 96 8F 3B E8 03 7C 21 28 80 00 21 A8 C3 02 21 20 C0 00 21 30 40 00 21 90 E0 00 ?? ?? ?? 0? 00 00 B7 8E 23 00 40 04 21 80 40 00 21 20 40 00 ?? ?? ?? 0? 88 13 05 24 FF FF 13 24 06 00 40 1C 04 00 14 24 ?? ?? ?? 0? 21 20 00 02 00 00 A3 8E 07 00 74 14 00 00 00 00 21 20 00 02 21 28 40 02 ?? ?? ?? 0? 21 30 20 02 F8 FF 53 10 00 00 00 00 0D 00 51 14 21 18 00 02 3C 00 BF 8F 38 00 B7 8F 34 00 B6 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 21 10 60 00 08 00 E0 03 40 00 BD 27 21 20 00 02 A6 0F 02 24 0C 00 00 00 3C 00 BF 8F 3B E8 03 7C 21 10 C3 02 FF FF 03 24 00 00 57 AC 34 00 B6 8F 38 00 B7 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 21 10 60 00 08 00 E0 03 40 00 BD 27 ?? ?? ?? 0? FF FF 03 24 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "convert_and_print"
		size = 348
		refs = "0038 strlen 0064 realloc 008c __mbsrtowcs 00c8 $LC0 00d0 stderr 00d8 __vfwprintf 0120 fputws_unlocked 011c $LC1"
	strings:
		$1 = { B0 FF BD 27 48 00 BE AF 34 00 B3 AF 4C 00 BF AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 21 F0 A0 03 2B 00 80 10 21 98 80 00 ?? ?? ?? 0? 21 B8 A0 00 01 00 51 24 80 90 11 00 0E 00 56 26 C2 B0 16 00 21 80 00 00 D0 07 35 2E A0 0F 34 2E ?? ?? ?? 0? C0 B0 16 00 ?? ?? ?? 0? 00 00 00 00 29 00 40 10 21 80 40 00 21 20 00 02 20 00 C5 27 21 30 20 02 18 00 C7 27 18 00 C0 AF 1C 00 C0 AF ?? ?? ?? 0? 20 00 D3 AF 0A 00 22 16 FF FF 03 24 21 10 00 00 0A 10 14 02 0B 80 50 00 21 20 00 02 ED FF A0 12 21 28 40 02 23 E8 B6 03 ?? ?? ?? 0? 10 00 B0 27 03 00 43 14 ?? ?? 02 3C ?? ?? 10 3C ?? ?? 10 26 ?? ?? 44 8C 21 28 00 02 ?? ?? ?? 0? 21 30 E0 02 21 E8 C0 03 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 ?? ?? 02 3C ?? ?? 45 8C ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 21 E8 C0 03 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_66_1_0 {
	meta:
		name = "vwarnx"
		size = 244
		refs = "0008 stderr 002c __progname 003c __fwprintf 0034 $LC2 0068 putwc_unlocked 0080 fprintf 0078 $LC3 0094 vfprintf 00ec __overflow"
	strings:
		$1 = { D8 FF BD 27 18 00 B0 AF ?? ?? 10 3C ?? ?? 02 8E 20 00 B2 AF 1C 00 B1 AF 6C 00 43 8C 24 00 BF AF 21 88 80 00 12 00 60 18 21 90 A0 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 05 3C 21 20 40 00 ?? ?? ?? 0? ?? ?? A5 24 21 20 20 02 ?? ?? ?? 0? 21 28 40 02 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F ?? ?? 05 8E 18 00 B0 8F 0A 00 04 24 ?? ?? ?? 0? 28 00 BD 27 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 05 3C 21 20 40 00 ?? ?? ?? 0? ?? ?? A5 24 04 00 20 12 ?? ?? 04 8E 21 28 20 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? 04 8E 14 00 82 8C 18 00 83 8C 2B 18 43 00 0A 00 60 10 01 00 43 24 14 00 83 AC 0A 00 03 24 00 00 43 A0 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 0A 00 05 24 ?? ?? ?? 0? 28 00 BD 27 }
	condition:
		$1
}

rule file_66_2_0 {
	meta:
		name = "vwarn"
		size = 336
		refs = "0008 stderr 000c __gnu_local_gp 0020 __libc_errno 0054 __progname 0064 __fwprintf 005c $LC2 0088 fputws_unlocked 0084 $LC4 00bc $LC5 00dc fprintf 00d4 $LC3 00f4 vfprintf 0100 $LC6 010c fwrite_unlocked 0140 $LC7"
	strings:
		$1 = { D0 FF BD 27 18 00 B0 AF ?? ?? 10 3C ?? ?? 1C 3C ?? ?? 02 8E ?? ?? 9C 27 3B E8 03 7C 1C 00 B1 AF ?? ?? 91 8F 21 30 60 00 6C 00 43 8C 21 38 26 02 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 2C 00 BF AF 10 00 BC AF 21 90 80 00 21 A0 A0 00 1F 00 60 18 00 00 F3 8C ?? ?? 03 3C ?? ?? 66 8C ?? ?? 05 3C 21 20 40 00 ?? ?? ?? 0? ?? ?? A5 24 09 00 40 12 10 00 BC 8F 21 20 40 02 ?? ?? ?? 0? 21 28 80 02 ?? ?? 05 8E ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 10 00 BC 8F 3B E8 03 7C 21 88 23 02 00 00 33 AE 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F ?? ?? 04 8E 18 00 B0 8F ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? 30 00 BD 27 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 05 3C 21 20 40 00 ?? ?? ?? 0? ?? ?? A5 24 0C 00 40 12 10 00 BC 8F ?? ?? 04 8E 21 28 40 02 ?? ?? ?? 0? 21 30 80 02 ?? ?? 07 8E ?? ?? 04 3C ?? ?? 84 24 01 00 05 24 ?? ?? ?? 0? 02 00 06 24 10 00 BC 8F 3B E8 03 7C 21 88 23 02 00 00 33 AE 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F ?? ?? 04 8E 18 00 B0 8F ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? 30 00 BD 27 }
	condition:
		$1
}

rule file_66_3_0 {
	meta:
		name = "warn"
		size = 48
		refs = "001c vwarn"
		altNames = "warnx"
	strings:
		$1 = { D8 FF BD 27 2C 00 A2 27 2C 00 A5 AF 21 28 40 00 24 00 BF AF 30 00 A6 AF 34 00 A7 AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_66_5_0 {
	meta:
		name = "verr"
		size = 36
		refs = "0014 vwarn 001c exit"
	strings:
		$1 = { E0 FF BD 27 18 00 B0 AF 21 80 80 00 21 20 A0 00 1C 00 BF AF ?? ?? ?? 0? 21 28 C0 00 ?? ?? ?? 0? 21 20 00 02 }
	condition:
		$1
}

rule file_66_6_0 {
	meta:
		name = "verrx"
		size = 36
		refs = "0014 vwarnx 001c exit"
	strings:
		$1 = { E0 FF BD 27 18 00 B0 AF 21 80 80 00 21 20 A0 00 1C 00 BF AF ?? ?? ?? 0? 21 28 C0 00 ?? ?? ?? 0? 21 20 00 02 }
	condition:
		$1
}

rule file_66_7_0 {
	meta:
		name = "err"
		size = 32
		refs = "0018 verr"
		altNames = "errx"
	strings:
		$1 = { D8 FF BD 27 30 00 A2 27 30 00 A6 AF 21 30 40 00 24 00 BF AF 34 00 A7 AF ?? ?? ?? 0? 18 00 A2 AF }
	condition:
		$1
}

rule file_202_3_0 {
	meta:
		name = "_IO_obstack_printf"
		size = 44
		refs = "0018 _IO_obstack_vprintf"
	strings:
		$1 = { D8 FF BD 27 30 00 A2 27 30 00 A6 AF 21 30 40 00 24 00 BF AF 34 00 A7 AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_1395_0_0 {
	meta:
		name = "___asprintf"
		size = 44
		refs = "0018 _IO_vasprintf"
	strings:
		$1 = { D8 FF BD 27 30 00 A2 27 30 00 A6 AF 21 30 40 00 24 00 BF AF 34 00 A7 AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_1258_0_0 {
	meta:
		name = "__dprintf"
		size = 44
		refs = "0018 _IO_vdprintf"
	strings:
		$1 = { D8 FF BD 27 30 00 A2 27 30 00 A6 AF 21 30 40 00 24 00 BF AF 34 00 A7 AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_876_0_0 {
	meta:
		name = "__fprintf"
		size = 44
		refs = "0018 vfprintf"
	strings:
		$1 = { D8 FF BD 27 30 00 A2 27 30 00 A6 AF 21 30 40 00 24 00 BF AF 34 00 A7 AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_1272_0_0 {
	meta:
		name = "__fscanf"
		size = 44
		refs = "0018 __vfscanf"
	strings:
		$1 = { D8 FF BD 27 30 00 A2 27 30 00 A6 AF 21 30 40 00 24 00 BF AF 34 00 A7 AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_860_0_0 {
	meta:
		name = "__fwprintf"
		size = 44
		refs = "0018 __vfwprintf"
	strings:
		$1 = { D8 FF BD 27 30 00 A2 27 30 00 A6 AF 21 30 40 00 24 00 BF AF 34 00 A7 AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_889_0_0 {
	meta:
		name = "__fwscanf"
		size = 44
		refs = "0018 __vfwscanf"
	strings:
		$1 = { D8 FF BD 27 30 00 A2 27 30 00 A6 AF 21 30 40 00 24 00 BF AF 34 00 A7 AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_545_0_0 {
	meta:
		name = "__isoc99_sscanf"
		size = 44
		refs = "0018 __isoc99_vsscanf"
	strings:
		$1 = { D8 FF BD 27 30 00 A2 27 30 00 A6 AF 21 30 40 00 24 00 BF AF 34 00 A7 AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_1056_0_0 {
	meta:
		name = "__isoc99_swscanf"
		size = 44
		refs = "0018 __isoc99_vswscanf"
	strings:
		$1 = { D8 FF BD 27 30 00 A2 27 30 00 A6 AF 21 30 40 00 24 00 BF AF 34 00 A7 AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_619_0_0 {
	meta:
		name = "__sprintf"
		size = 44
		refs = "0018 _IO_vsprintf"
	strings:
		$1 = { D8 FF BD 27 30 00 A2 27 30 00 A6 AF 21 30 40 00 24 00 BF AF 34 00 A7 AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_343_0_0 {
	meta:
		name = "__sscanf"
		size = 44
		refs = "0018 _IO_vsscanf"
	strings:
		$1 = { D8 FF BD 27 30 00 A2 27 30 00 A6 AF 21 30 40 00 24 00 BF AF 34 00 A7 AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_859_0_0 {
	meta:
		name = "__swscanf"
		size = 44
		refs = "0018 vswscanf"
	strings:
		$1 = { D8 FF BD 27 30 00 A2 27 30 00 A6 AF 21 30 40 00 24 00 BF AF 34 00 A7 AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "scandir64"
		size = 56
		refs = "0024 scandirat64"
		altNames = "scandir"
	strings:
		$1 = { D8 FF BD 27 21 40 80 00 21 18 A0 00 21 10 C0 00 9C FF 04 24 10 00 A7 AF 21 28 00 01 21 30 60 00 24 00 BF AF ?? ?? ?? 0? 21 38 40 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "ether_ntohost"
		size = 368
		refs = "0010 __gnu_local_gp 0068 __libc_errno 0064 $LC0 00a8 __nss_next2 00f0 strcpy 0138 __nss_ethers_lookup"
	strings:
		$1 = { A8 FB BD 27 38 04 B0 AF ?? ?? 10 3C ?? ?? 02 8E ?? ?? 1C 3C ?? ?? 9C 27 50 04 B6 AF 3C 04 B1 AF 54 04 BF AF 4C 04 B5 AF 48 04 B4 AF 44 04 B3 AF 40 04 B2 AF 18 00 BC AF 21 B0 80 00 39 00 40 10 21 88 A0 00 ?? ?? 03 3C ?? ?? 79 8C FF FF 03 24 30 04 A2 AF 3E 00 43 10 2C 04 B9 AF 30 04 B3 27 2C 04 B2 27 ?? ?? 14 3C ?? ?? 95 8F 3B E8 03 7C ?? ?? 94 26 21 A8 A3 02 21 20 20 02 20 04 A5 27 20 00 A6 27 00 04 07 24 09 F8 20 03 10 00 B5 AF 10 00 A2 AF 14 00 A0 AF 21 20 60 02 21 28 80 02 21 30 00 00 21 38 40 02 ?? ?? ?? 0? 21 80 40 00 F1 FF 40 10 2C 04 B9 8F 01 00 03 24 0B 00 03 12 FF FF 02 24 54 04 BF 8F 50 04 B6 8F 4C 04 B5 8F 48 04 B4 8F 44 04 B3 8F 40 04 B2 8F 3C 04 B1 8F 38 04 B0 8F 08 00 E0 03 58 04 BD 27 20 04 A5 8F ?? ?? ?? 0? 21 20 C0 02 54 04 BF 8F 50 04 B6 8F 4C 04 B5 8F 48 04 B4 8F 44 04 B3 8F 40 04 B2 8F 3C 04 B1 8F 38 04 B0 8F 21 10 00 00 08 00 E0 03 58 04 BD 27 30 04 B3 27 2C 04 B2 27 ?? ?? 14 3C 21 20 60 02 ?? ?? 85 26 ?? ?? ?? 0? 21 30 40 02 05 00 40 10 18 00 BC 8F FF FF 02 24 ?? ?? 02 AE ?? ?? ?? 0? FF FF 02 24 2C 04 B9 8F ?? ?? 02 3C ?? ?? 59 AC 30 04 A2 8F ?? ?? ?? 0? ?? ?? 02 AE }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "clnttcp_geterr"
		size = 32
	strings:
		$1 = { 08 00 82 8C 24 00 44 8C 28 00 43 8C 2C 00 42 8C 00 00 A4 AC 04 00 A3 AC 08 00 E0 03 08 00 A2 AC }
	condition:
		$1
}

rule file_69_1_0 {
	meta:
		name = "clnttcp_freeres"
		size = 28
	strings:
		$1 = { 08 00 84 8C 02 00 02 24 21 C8 A0 00 4C 00 82 AC 21 28 C0 00 08 00 20 03 4C 00 84 24 }
	condition:
		$1
}

rule file_69_3_0 {
	meta:
		name = "clnttcp_destroy"
		size = 104
		refs = "0038 free 0058 __close"
	strings:
		$1 = { D8 FF BD 27 1C 00 B0 AF 08 00 90 8C 20 00 B1 AF 24 00 BF AF 04 00 02 8E 0F 00 40 14 21 88 80 00 50 00 02 8E 1C 00 59 8C 03 00 20 13 00 00 00 00 09 F8 20 03 4C 00 04 26 ?? ?? ?? 0? 21 20 00 02 24 00 BF 8F 1C 00 B0 8F 21 20 20 02 20 00 B1 8F ?? ?? ?? 0? 28 00 BD 27 ?? ?? ?? 0? 00 00 04 8E ?? ?? ?? 0? 50 00 02 8E }
	condition:
		$1
}

rule file_69_4_0 {
	meta:
		name = "clnttcp_control"
		size = 380
	strings:
		$1 = { 10 00 A2 2C F0 FF BD 27 5A 00 40 10 08 00 83 8C ?? ?? 02 3C ?? ?? 42 24 80 28 05 00 21 28 45 00 00 00 A2 8C 08 00 40 00 00 00 00 00 03 00 C7 88 3C 00 65 24 01 00 02 24 00 00 C7 98 A0 20 07 7C 02 24 24 00 3F 00 64 A8 0C 00 A7 AF 08 00 A4 AF 00 00 A4 B8 08 00 E0 03 10 00 BD 27 04 00 C2 8C 00 00 C4 8C 0C 00 62 AC 01 00 02 24 08 00 64 AC ?? ?? ?? 0? 10 00 62 AC 08 00 64 8C 0C 00 63 8C 01 00 02 24 00 00 C4 AC ?? ?? ?? 0? 04 00 C3 AC 14 00 67 8C 18 00 65 8C 1C 00 64 8C 20 00 63 8C 01 00 02 24 00 00 C7 AC 04 00 C5 AC 08 00 C4 AC ?? ?? ?? 0? 0C 00 C3 AC 00 00 63 8C 01 00 02 24 ?? ?? ?? 0? 00 00 C3 AC 01 00 02 24 ?? ?? ?? 0? 04 00 62 AC 04 00 60 AC ?? ?? ?? 0? 01 00 02 24 30 00 63 24 03 00 64 88 01 00 02 24 00 00 64 98 10 00 BD 27 A0 18 04 7C 02 1C 23 00 03 00 C3 A8 08 00 E0 03 00 00 C3 B8 03 00 C7 88 30 00 65 24 01 00 02 24 00 00 C7 98 FF FF E4 24 A0 20 04 7C 02 24 24 00 33 00 64 A8 0C 00 A7 AF 08 00 A4 AF ?? ?? ?? 0? 00 00 A4 B8 ?? ?? ?? 0? 40 00 63 24 03 00 C7 88 40 00 65 24 01 00 02 24 00 00 C7 98 A0 20 07 7C 02 24 24 00 43 00 64 A8 0C 00 A7 AF 08 00 A4 AF ?? ?? ?? 0? 00 00 A4 B8 ?? ?? ?? 0? 3C 00 63 24 ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_69_5_0 {
	meta:
		name = "clnttcp_call"
		size = 768
		refs = "006c xdr_void 0104 xdrrec_endofrecord 0130 _null_auth 0154 xdrrec_skiprecord 0168 xdr_replymsg 01bc _seterr_reply 02c0 xdr_opaque_auth"
	strings:
		$1 = { 88 FF BD 27 50 00 B0 AF 08 00 90 8C 64 00 B5 AF 54 00 B1 AF 10 00 02 8E 74 00 BF AF 70 00 BE AF 6C 00 B7 AF 68 00 B6 AF 60 00 B4 AF 5C 00 B3 AF 58 00 B2 AF 21 A8 80 00 7C 00 A5 AF 80 00 A6 AF 84 00 A7 AF 05 00 40 14 4C 00 11 26 90 00 A2 8F 08 00 02 AE 94 00 A2 8F 0C 00 02 AE 88 00 B9 8F 77 00 20 13 01 00 16 24 03 00 03 24 ?? ?? 14 3C 30 00 17 26 48 00 A3 AF ?? ?? 12 3C ?? ?? 94 26 50 00 02 8E 30 00 13 8E 48 00 06 8E 0C 00 59 8C FF FF 73 26 30 00 13 AE 4C 00 00 AE 24 00 00 AE 21 20 20 02 21 28 E0 02 09 F8 20 03 A0 98 13 7C 69 00 40 10 02 9C 33 00 50 00 02 8E 21 20 20 02 04 00 59 8C 09 F8 20 03 7C 00 A5 27 62 00 40 10 00 00 00 00 00 00 A4 8E 20 00 82 8C 04 00 59 8C 09 F8 20 03 21 28 20 02 5B 00 40 10 84 00 A5 8F 80 00 B9 8F 09 F8 20 03 21 20 20 02 56 00 40 10 21 20 20 02 ?? ?? ?? 0? 21 28 C0 02 5B 00 40 10 03 00 02 24 1B 00 C0 12 21 10 00 00 08 00 02 8E 42 00 40 10 00 00 00 00 01 00 02 24 4C 00 02 AE ?? ?? 5E 26 04 00 C5 8F ?? ?? 46 8E 08 00 C2 8F 21 20 20 02 28 00 A5 AF 24 00 A6 AF 2C 00 A2 AF 34 00 A0 AF ?? ?? ?? 0? 38 00 B4 AF 21 20 20 02 25 00 40 10 18 00 A5 27 ?? ?? ?? 0? 00 00 00 00 10 00 40 14 18 00 A2 8F 24 00 02 8E ED FF 40 10 00 00 00 00 74 00 BF 8F 70 00 BE 8F 6C 00 B7 8F 68 00 B6 8F 64 00 B5 8F 60 00 B4 8F 5C 00 B3 8F 58 00 B2 8F 54 00 B1 8F 50 00 B0 8F 08 00 E0 03 78 00 BD 27 DF FF 53 14 18 00 A4 27 ?? ?? ?? 0? 24 00 05 26 24 00 02 8E 2E 00 40 10 48 00 A3 8F FF FF 63 24 EB FF 60 10 48 00 A3 AF 00 00 A4 8E 20 00 82 8C 0C 00 59 8C 09 F8 20 03 00 00 00 00 A3 FF 40 14 00 00 00 00 24 00 02 8E 74 00 BF 8F 70 00 BE 8F 6C 00 B7 8F 68 00 B6 8F 64 00 B5 8F 60 00 B4 8F 5C 00 B3 8F 58 00 B2 8F 54 00 B1 8F 50 00 B0 8F 08 00 E0 03 78 00 BD 27 0C 00 02 8E BD FF 40 14 05 00 02 24 ?? ?? ?? 0? 24 00 02 AE 08 00 02 8E 89 FF 40 14 03 00 03 24 0C 00 16 8E ?? ?? ?? 0? 2B B0 16 00 24 00 02 8E 03 00 40 14 21 20 20 02 01 00 02 24 24 00 02 AE ?? ?? ?? 0? 01 00 05 24 ?? ?? ?? 0? 24 00 02 8E ?? ?? ?? 0? 24 00 02 AE 00 00 A4 8E 20 00 82 8C 08 00 59 8C 09 F8 20 03 24 00 A5 27 0D 00 40 14 07 00 02 24 24 00 02 AE 06 00 02 24 28 00 02 AE 28 00 A2 8F D1 FF 40 10 02 00 02 24 4C 00 02 AE 21 20 20 02 ?? ?? ?? 0? 24 00 A5 27 ?? ?? ?? 0? 24 00 02 8E 8C 00 A5 8F 88 00 B9 8F 09 F8 20 03 21 20 20 02 F3 FF 40 14 28 00 A2 8F 24 00 02 8E F0 FF 40 14 28 00 A2 8F 02 00 02 24 ?? ?? ?? 0? 24 00 02 AE }
	condition:
		$1
}

rule file_69_6_0 {
	meta:
		name = "writetcp"
		size = 212
		refs = "0000 __gnu_local_gp 0058 __write 0074 __libc_errno"
	strings:
		$1 = { ?? ?? 1C 3C D0 FF BD 27 ?? ?? 9C 27 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 2C 00 BF AF 10 00 BC AF 21 A0 C0 00 21 90 80 00 21 88 A0 00 21 80 C0 00 05 00 C0 1C FF FF 13 24 ?? ?? ?? 0? 2C 00 BF 8F 19 00 00 1A 21 88 22 02 00 00 44 8E 21 30 00 02 ?? ?? ?? 0? 21 28 20 02 23 80 02 02 F8 FF 53 14 10 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 43 8C 03 00 02 24 24 00 42 AE 28 00 43 AE 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F FF FF 02 24 08 00 E0 03 30 00 BD 27 2C 00 BF 8F 21 10 80 02 24 00 B3 8F 28 00 B4 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_69_7_0 {
	meta:
		name = "readtcp"
		size = 400
		refs = "0000 __gnu_local_gp 006c __libc_errno 00b0 __poll 0100 __read"
	strings:
		$1 = { ?? ?? 1C 3C C0 FF BD 27 ?? ?? 9C 27 08 00 83 8C 24 00 B1 AF 20 00 B0 AF 3C 00 BF AF 21 80 80 00 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 10 00 BC AF 21 88 C0 00 0C 00 84 8C 24 00 C0 10 21 10 00 00 21 A0 A0 00 62 10 05 3C D3 4D A5 24 18 00 85 00 C0 91 03 00 80 10 03 00 23 10 42 02 21 18 43 00 00 00 07 8E ?? ?? 96 8F C0 10 03 00 C3 27 04 00 3B E8 03 7C 21 30 60 00 01 00 03 24 18 00 A7 AF 1C 00 A3 A7 FF FF 13 24 21 B0 C6 02 04 00 15 24 10 28 00 00 83 29 05 00 23 20 A4 00 21 90 44 00 18 00 A4 27 01 00 05 24 ?? ?? ?? 0? 21 30 40 02 1E 00 53 10 00 00 00 00 0E 00 40 14 21 28 80 02 05 00 02 24 24 00 02 AE FF FF 02 24 3C 00 BF 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 40 00 BD 27 00 00 04 8E ?? ?? ?? 0? 21 30 20 02 FF FF 03 24 0E 00 43 10 10 00 BC 8F F0 FF 40 14 3C 00 BF 8F 83 00 02 24 28 00 02 AE 04 00 02 24 24 00 02 AE ?? ?? ?? 0? FF FF 02 24 00 00 C3 8E DC FF 75 10 18 00 A4 27 ?? ?? ?? 0? 28 00 03 AE 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 83 8C 28 00 03 AE 3C 00 BF 8F 04 00 04 24 24 00 04 AE 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_69_8_0 {
	meta:
		name = "clnttcp_create"
		size = 764
		refs = "0004 __gnu_local_gp 003c malloc 00a8 _create_xid 00d4 xdrmem_create 00e0 xdr_callhdr 0140 xdrrec_create 0154 authnone_create 0190 pmap_getport 01bc __socket 01cc bindresvport 01e0 __connect 0208 free 0244 __close 0254 __rpc_thread_createerr 025c _libc_intl_domainname 0260 $LC0 0270 __dcgettext 0278 $LC1 027c __func__.12981 028c __fxprintf 02b8 __libc_errno"
	strings:
		$1 = { 90 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 58 00 B1 AF 21 88 80 00 0C 00 04 24 6C 00 BF AF 68 00 B5 AF 64 00 B4 AF 60 00 B3 AF 5C 00 B2 AF 54 00 B0 AF 18 00 BC AF 21 A8 A0 00 21 A0 C0 00 ?? ?? ?? 0? 21 98 E0 00 64 00 04 24 ?? ?? ?? 0? 21 90 40 00 80 00 40 12 21 80 40 00 7E 00 40 10 00 00 00 00 02 00 22 96 48 00 40 10 21 20 20 02 00 00 62 8E 51 00 40 04 02 00 04 24 04 00 00 AE 0C 00 23 8E 00 00 26 8E 04 00 25 8E 08 00 24 8E 20 00 03 AE 4C 00 11 26 14 00 06 AE 18 00 05 AE 1C 00 04 AE 00 00 02 AE 0C 00 00 AE ?? ?? ?? 0? 10 00 00 AE 20 00 A2 AF 21 20 20 02 02 00 02 24 30 00 05 26 18 00 06 24 21 38 00 00 28 00 A2 AF 24 00 A0 AF 2C 00 B5 AF ?? ?? ?? 0? 30 00 B4 AF 21 20 20 02 ?? ?? ?? 0? 20 00 A5 27 44 00 40 10 00 00 00 00 50 00 02 8E 10 00 59 8C 09 F8 20 03 21 20 20 02 50 00 03 8E 48 00 02 AE 1C 00 79 8C 04 00 20 13 ?? ?? 02 3C 09 F8 20 03 21 20 20 02 ?? ?? 02 3C ?? ?? 42 24 80 00 A5 8F 84 00 A6 8F 10 00 A2 AF ?? ?? 02 3C ?? ?? 42 24 21 20 20 02 21 38 00 02 ?? ?? ?? 0? 14 00 A2 AF ?? ?? 02 3C ?? ?? 42 24 04 00 42 AE ?? ?? ?? 0? 08 00 50 AE 00 00 42 AE 21 10 40 02 6C 00 BF 8F 68 00 B5 8F 64 00 B4 8F 60 00 B3 8F 5C 00 B2 8F 58 00 B1 8F 54 00 B0 8F 08 00 E0 03 70 00 BD 27 21 28 A0 02 21 30 80 02 ?? ?? ?? 0? 06 00 07 24 52 00 40 10 02 1A 02 00 00 12 02 00 25 10 62 00 02 00 22 A6 00 00 62 8E B1 FF 41 04 02 00 04 24 02 00 05 24 ?? ?? ?? 0? 06 00 06 24 21 20 40 00 00 00 62 AE ?? ?? ?? 0? 21 28 00 00 00 00 64 8E 32 00 80 04 21 28 20 02 ?? ?? ?? 0? 10 00 06 24 2E 00 40 04 01 00 02 24 04 00 02 AE ?? ?? ?? 0? 00 00 62 8E 04 00 02 8E 0F 00 40 14 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 20 40 02 6C 00 BF 8F 68 00 B5 8F 64 00 B4 8F 60 00 B3 8F 5C 00 B2 8F 58 00 B1 8F 54 00 B0 8F 21 10 00 00 08 00 E0 03 70 00 BD 27 00 00 64 8E ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 05 00 06 24 ?? ?? ?? 0? 21 88 40 00 ?? ?? 05 3C ?? ?? 06 3C 21 20 00 00 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? 21 38 40 00 0C 00 02 24 00 00 22 AE ?? ?? ?? 0? 08 00 22 AE ?? ?? ?? 0? 00 00 00 00 18 00 BC 8F 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 83 8C 0C 00 04 24 00 00 44 AC 08 00 43 AC 00 00 64 8E DB FF 81 04 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "__libc_siglongjmp"
		size = 76
		refs = "0014 _longjmp_unwind 0030 __longjmp 003c __sigprocmask"
	strings:
		$1 = { D8 FF BD 27 1C 00 B0 AF 21 80 80 00 20 00 B1 AF 24 00 BF AF ?? ?? ?? 0? 21 88 A0 00 68 00 02 8E 05 00 40 14 03 00 04 24 01 00 05 24 21 20 00 02 ?? ?? ?? 0? 0B 28 31 02 6C 00 05 26 ?? ?? ?? 0? 21 30 00 00 ?? ?? ?? 0? 01 00 05 24 }
	condition:
		$1
}

rule file_1406_0_0 {
	meta:
		name = "__longjmp_chk"
		size = 76
		refs = "0014 _longjmp_unwind 0030 ____longjmp_chk 003c __sigprocmask"
	strings:
		$1 = { D8 FF BD 27 1C 00 B0 AF 21 80 80 00 20 00 B1 AF 24 00 BF AF ?? ?? ?? 0? 21 88 A0 00 68 00 02 8E 05 00 40 14 03 00 04 24 01 00 05 24 21 20 00 02 ?? ?? ?? 0? 0B 28 31 02 6C 00 05 26 ?? ?? ?? 0? 21 30 00 00 ?? ?? ?? 0? 01 00 05 24 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "__vwprintf"
		size = 24
		refs = "0000 stdout 0010 __vfwprintf"
	strings:
		$1 = { ?? ?? 03 3C 21 10 80 00 ?? ?? 64 8C 21 30 A0 00 ?? ?? ?? 0? 21 28 40 00 }
	condition:
		$1
}

rule file_1265_0_0 {
	meta:
		name = "_IO_vscanf"
		size = 28
		refs = "0000 _IO_stdin 0014 _IO_vfscanf"
	strings:
		$1 = { ?? ?? 03 3C 21 10 80 00 ?? ?? 64 8C 21 30 A0 00 21 38 00 00 ?? ?? ?? 0? 21 28 40 00 }
	condition:
		$1
}

rule file_816_0_0 {
	meta:
		name = "__vprintf"
		size = 24
		refs = "0000 stdout 0010 vfprintf"
	strings:
		$1 = { ?? ?? 03 3C 21 10 80 00 ?? ?? 64 8C 21 30 A0 00 ?? ?? ?? 0? 21 28 40 00 }
	condition:
		$1
}

rule file_1459_0_0 {
	meta:
		name = "__vwscanf"
		size = 28
		refs = "0000 _IO_stdin 0014 _IO_vfwscanf"
	strings:
		$1 = { ?? ?? 03 3C 21 10 80 00 ?? ?? 64 8C 21 30 A0 00 21 38 00 00 ?? ?? ?? 0? 21 28 40 00 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "__link"
		size = 28
	strings:
		$1 = { A9 0F 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "getpass"
		size = 504
		refs = "0004 $LC1 0010 $LC0 002c _IO_new_fopen 0050 fileno 005c __tcgetattr 006c $LC2 0078 __fxprintf 0080 fflush_unlocked 0098 __getline 00d0 stdin 00e0 _IO_new_fclose 016c tcsetattr 0184 $LC3 01c4 stderr 01f0 _Unwind_Resume"
	strings:
		$1 = { 68 FF BD 27 ?? ?? 05 3C 84 00 B1 AF 21 88 80 00 ?? ?? 04 3C ?? ?? A5 24 ?? ?? 84 24 80 00 B0 AF 94 00 BF AF 90 00 B4 AF 8C 00 B3 AF ?? ?? ?? 0? 88 00 B2 AF 61 00 40 10 21 80 40 00 00 00 42 8C 21 90 00 02 21 A0 00 02 00 80 42 34 00 00 02 AE ?? ?? ?? 0? 21 20 00 02 21 20 40 00 ?? ?? ?? 0? 18 00 A5 27 29 00 40 10 21 98 00 00 ?? ?? 05 3C 21 20 40 02 ?? ?? A5 24 ?? ?? ?? 0? 21 30 20 02 ?? ?? ?? 0? 21 20 40 02 ?? ?? 11 3C ?? ?? 05 3C ?? ?? 24 26 ?? ?? A5 24 ?? ?? ?? 0? 21 30 00 02 ?? ?? 23 8E 08 00 60 10 00 00 00 00 41 00 40 04 FF FF 42 24 21 18 62 00 00 00 64 80 0A 00 02 24 2E 00 82 10 00 00 00 00 32 00 60 16 00 00 00 00 ?? ?? 02 3C ?? ?? 42 8C 04 00 02 12 94 00 BF 8F ?? ?? ?? 0? 21 20 00 02 94 00 BF 8F ?? ?? 22 8E 90 00 B4 8F 8C 00 B3 8F 88 00 B2 8F 84 00 B1 8F 80 00 B0 8F 08 00 E0 03 98 00 BD 27 18 00 A2 27 4C 00 A3 27 48 00 A4 27 00 00 48 8C 04 00 47 8C 08 00 46 8C 0C 00 45 8C 10 00 42 24 00 00 68 AC 04 00 67 AC 08 00 66 AC 0C 00 65 AC F6 FF 44 14 10 00 63 24 00 00 42 8C 21 20 00 02 00 00 62 AC 24 00 A3 8F F6 FF 02 24 24 10 62 00 ?? ?? ?? 0? 24 00 A2 AF 21 20 40 00 10 54 05 24 ?? ?? ?? 0? 18 00 A6 27 ?? ?? ?? 0? 01 00 53 2C D4 FF 60 12 00 00 60 A0 ?? ?? 05 3C 21 20 40 02 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? 21 20 00 02 21 20 40 00 10 54 05 24 ?? ?? ?? 0? 4C 00 A6 27 ?? ?? ?? 0? ?? ?? 02 3C ?? ?? ?? 0? 00 00 60 A0 ?? ?? 02 3C ?? ?? 50 8C ?? ?? 02 3C ?? ?? 52 8C 21 10 00 00 26 A0 12 02 0A 10 14 02 ?? ?? ?? 0? 21 A0 40 00 03 00 80 12 21 80 80 00 ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 21 20 00 02 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "__isoc99_fscanf"
		size = 480
		refs = "0074 __lll_lock_wait_private 00b4 _IO_vfscanf 018c _Unwind_Resume"
	strings:
		$1 = { 00 00 82 8C D0 FF BD 27 24 00 B1 AF 00 80 42 30 20 00 B0 AF 2C 00 BF AF 28 00 B2 AF 21 80 80 00 38 00 A6 AF 3C 00 A7 AF 1A 00 40 14 21 88 A0 00 3B E8 03 7C 48 00 84 8C 70 8B 72 24 08 00 82 8C 11 00 52 10 00 00 00 00 18 00 A0 AF 00 00 83 C0 06 00 60 14 00 00 02 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 02 24 0F 00 00 00 03 00 40 14 00 00 00 00 ?? ?? ?? 0? 18 00 A3 AF 48 00 02 8E 21 20 40 00 08 00 52 AC 04 00 82 8C 01 00 42 24 04 00 82 AC 3C 00 03 8E 38 00 A2 27 21 20 00 02 10 00 63 34 3C 00 03 AE 21 28 20 02 21 30 40 00 21 38 00 00 ?? ?? ?? 0? 18 00 A2 AF 3C 00 05 8E 00 00 03 8E EB FF 04 24 24 20 A4 00 00 80 63 30 21 88 40 00 06 00 60 14 3C 00 04 AE 48 00 04 8E 04 00 82 8C FF FF 42 24 08 00 40 10 04 00 82 AC 2C 00 BF 8F 21 10 20 02 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 F0 FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 2C 00 BF 8F 3C 00 05 8E 00 00 02 8E EB FF 03 24 24 18 A3 00 00 80 42 30 21 88 80 00 06 00 40 14 3C 00 03 AE 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_820_0_0 {
	meta:
		name = "__isoc99_fwscanf"
		size = 480
		refs = "0074 __lll_lock_wait_private 00b4 _IO_vfwscanf 018c _Unwind_Resume"
	strings:
		$1 = { 00 00 82 8C D0 FF BD 27 24 00 B1 AF 00 80 42 30 20 00 B0 AF 2C 00 BF AF 28 00 B2 AF 21 80 80 00 38 00 A6 AF 3C 00 A7 AF 1A 00 40 14 21 88 A0 00 3B E8 03 7C 48 00 84 8C 70 8B 72 24 08 00 82 8C 11 00 52 10 00 00 00 00 18 00 A0 AF 00 00 83 C0 06 00 60 14 00 00 02 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 02 24 0F 00 00 00 03 00 40 14 00 00 00 00 ?? ?? ?? 0? 18 00 A3 AF 48 00 02 8E 21 20 40 00 08 00 52 AC 04 00 82 8C 01 00 42 24 04 00 82 AC 3C 00 03 8E 38 00 A2 27 21 20 00 02 10 00 63 34 3C 00 03 AE 21 28 20 02 21 30 40 00 21 38 00 00 ?? ?? ?? 0? 18 00 A2 AF 3C 00 05 8E 00 00 03 8E EB FF 04 24 24 20 A4 00 00 80 63 30 21 88 40 00 06 00 60 14 3C 00 04 AE 48 00 04 8E 04 00 82 8C FF FF 42 24 08 00 40 10 04 00 82 AC 2C 00 BF 8F 21 10 20 02 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 F0 FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 2C 00 BF 8F 3C 00 05 8E 00 00 02 8E EB FF 03 24 24 18 A3 00 00 80 42 30 21 88 80 00 06 00 40 14 3C 00 03 AE 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "__getegid"
		size = 16
	strings:
		$1 = { D2 0F 02 24 0C 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "__mktemp"
		size = 64
		refs = "0018 __gen_tempname"
	strings:
		$1 = { E0 FF BD 27 21 28 00 00 21 30 00 00 02 00 07 24 18 00 B0 AF 1C 00 BF AF ?? ?? ?? 0? 21 80 80 00 03 00 41 04 1C 00 BF 8F 00 00 00 A2 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "__strcasecmp"
		size = 112
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE"
	strings:
		$1 = { ?? ?? 1C 3C 3B E8 03 7C ?? ?? 9C 27 21 10 60 00 ?? ?? 83 8F 21 10 62 00 13 00 85 10 00 00 42 8C ?? ?? ?? 0? 38 00 46 8C 0F 00 60 10 00 00 00 00 01 00 A5 24 00 00 83 90 FF FF A2 90 80 38 03 00 80 10 02 00 21 38 C7 00 21 10 C2 00 00 00 E7 8C 00 00 42 8C 23 10 E2 00 F3 FF 40 10 01 00 84 24 08 00 E0 03 00 00 00 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "strftime"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 __strftime_l"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 24 00 BF AF 21 10 62 00 00 00 42 8C 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_931_0_0 {
	meta:
		name = "__strtol_internal"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 ____strtol_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 24 00 BF AF 21 10 62 00 00 00 42 8C 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_1295_0_0 {
	meta:
		name = "__strtoll_internal"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 ____strtoll_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 24 00 BF AF 21 10 62 00 00 00 42 8C 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_795_0_0 {
	meta:
		name = "__strtoul_internal"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 ____strtoul_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 24 00 BF AF 21 10 62 00 00 00 42 8C 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_810_0_0 {
	meta:
		name = "__strtoull_internal"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 ____strtoull_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 24 00 BF AF 21 10 62 00 00 00 42 8C 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "__wcstol_internal"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 ____wcstol_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 24 00 BF AF 21 10 62 00 00 00 42 8C 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_715_0_0 {
	meta:
		name = "__wcstoll_internal"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 ____wcstoll_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 24 00 BF AF 21 10 62 00 00 00 42 8C 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "__wcstoul_internal"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 ____wcstoul_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 24 00 BF AF 21 10 62 00 00 00 42 8C 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_850_0_0 {
	meta:
		name = "__wcstoull_internal"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 ____wcstoull_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 24 00 BF AF 21 10 62 00 00 00 42 8C 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_342_0_0 {
	meta:
		name = "wcsftime"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 __wcsftime_l"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 24 00 BF AF 21 10 62 00 00 00 42 8C 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "__socketpair"
		size = 28
	strings:
		$1 = { 58 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_81_1_0 {
	meta:
		name = "wcstol"
		size = 64
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 002c ____wcstol_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 21 38 00 00 21 10 62 00 00 00 42 8C 24 00 BF AF 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "strptime"
		size = 64
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 002c __strptime_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 21 38 00 00 21 10 62 00 00 00 42 8C 24 00 BF AF 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_931_1_0 {
	meta:
		name = "strtol"
		size = 64
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 002c ____strtol_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 21 38 00 00 21 10 62 00 00 00 42 8C 24 00 BF AF 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_1295_1_0 {
	meta:
		name = "strtoll"
		size = 64
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 002c ____strtoll_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 21 38 00 00 21 10 62 00 00 00 42 8C 24 00 BF AF 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_795_1_0 {
	meta:
		name = "strtoul"
		size = 64
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 002c ____strtoul_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 21 38 00 00 21 10 62 00 00 00 42 8C 24 00 BF AF 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_810_1_0 {
	meta:
		name = "strtoull"
		size = 64
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 002c ____strtoull_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 21 38 00 00 21 10 62 00 00 00 42 8C 24 00 BF AF 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_715_1_0 {
	meta:
		name = "wcstoll"
		size = 64
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 002c ____wcstoll_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 21 38 00 00 21 10 62 00 00 00 42 8C 24 00 BF AF 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_209_1_0 {
	meta:
		name = "wcstoul"
		size = 64
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 002c ____wcstoul_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 21 38 00 00 21 10 62 00 00 00 42 8C 24 00 BF AF 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_850_1_0 {
	meta:
		name = "wcstoull"
		size = 64
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 002c ____wcstoull_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 21 38 00 00 21 10 62 00 00 00 42 8C 24 00 BF AF 18 00 BC AF ?? ?? ?? 0? 10 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "nfsservctl"
		size = 28
	strings:
		$1 = { 5D 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "listxattr"
		size = 28
	strings:
		$1 = { 86 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "memfrob"
		size = 44
	strings:
		$1 = { 21 10 80 00 21 30 85 00 06 00 A0 10 21 18 80 00 01 00 63 24 FF FF 65 90 2A 00 A5 38 FC FF 66 14 FF FF 65 A0 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "__exit_thread"
		size = 16
	strings:
		$1 = { A1 0F 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "sigignore"
		size = 76
		refs = "0020 memset 0034 __sigaction"
	strings:
		$1 = { 50 FF BD 27 21 28 00 00 80 00 06 24 A8 00 B0 AF 01 00 02 24 21 80 80 00 20 00 A4 27 AC 00 BF AF ?? ?? ?? 0? 1C 00 A2 AF 21 20 00 02 18 00 A5 27 21 30 00 00 ?? ?? ?? 0? 18 00 A0 AF AC 00 BF 8F A8 00 B0 8F 08 00 E0 03 B0 00 BD 27 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "seteuid"
		size = 168
		refs = "0000 __gnu_local_gp 0020 __nptl_setxid 005c __libc_errno"
	strings:
		$1 = { ?? ?? 1C 3C C8 FF BD 27 ?? ?? 9C 27 FF FF 02 24 21 28 80 00 34 00 BF AF 0E 00 82 10 10 00 BC AF ?? ?? 03 3C ?? ?? 63 24 12 00 60 10 59 10 03 24 18 00 A4 27 18 00 A3 AF 1C 00 A2 AF 20 00 A5 AF ?? ?? ?? 0? 24 00 A2 AF 34 00 BF 8F 08 00 E0 03 38 00 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 FF FF 04 24 FF FF 06 24 59 10 02 24 0C 00 00 00 F1 FF E0 10 34 00 BF 8F 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "setlinebuf"
		size = 16
		refs = "0008 _IO_setvbuf"
	strings:
		$1 = { 21 28 00 00 01 00 06 24 ?? ?? ?? 0? 21 38 00 00 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "__libc_init_secure"
		size = 108
		refs = "0000 __libc_enable_secure_decided 0020 __geteuid 0028 __getuid 003c __libc_enable_secure 0050 __getegid 0058 __getgid"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C 03 00 40 10 00 00 00 00 08 00 E0 03 00 00 00 00 E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 18 00 B0 AF ?? ?? ?? 0? 21 80 40 00 07 00 02 12 01 00 03 24 1C 00 BF 8F ?? ?? 02 3C 18 00 B0 8F ?? ?? 43 AC 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 80 40 00 26 10 02 02 ?? ?? ?? 0? 2B 18 02 00 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "fchmodat"
		size = 452
		refs = "0004 __gnu_local_gp 0040 __have_atfcts 0070 __libc_errno 00a8 strlen 00cc procfd.8484 00e4 __snprintf 0108 __atfct_seterrno"
	strings:
		$1 = { C8 FF BD 27 ?? ?? 1C 3C FF FE 02 24 ?? ?? 9C 27 30 00 BE AF 24 10 E2 00 21 F0 A0 03 34 00 BF AF 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 46 00 40 14 18 00 DC AF 00 01 E2 30 4B 00 40 14 ?? ?? 11 3C ?? ?? 22 8E 21 90 80 00 21 80 A0 00 0F 00 40 04 21 98 C0 00 CB 10 02 24 0C 00 00 00 2D 00 E0 10 FF FF 03 24 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 28 40 00 21 20 64 00 00 00 82 AC 59 00 03 24 26 00 A3 14 FF FF 02 24 ?? ?? 22 AE 9C FF 02 24 2B 00 42 12 2F 00 02 24 00 00 03 82 12 00 62 10 21 88 00 00 ?? ?? ?? 0? 21 20 00 02 36 00 40 10 18 00 DC 8F 2E 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 B1 27 ?? ?? 06 3C 10 00 B0 AF 21 20 20 02 20 00 45 24 ?? ?? C6 24 21 38 40 02 ?? ?? ?? 0? 21 80 20 02 21 20 00 02 21 28 60 02 AF 0F 02 24 0C 00 00 00 08 00 E0 10 21 20 40 00 21 28 40 02 ?? ?? ?? 0? 21 30 20 02 ?? ?? ?? 0? FF FF 02 24 24 00 43 10 00 00 00 00 21 E8 C0 03 34 00 DF 8F 30 00 BE 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? 21 88 00 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 7A 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 02 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 ?? ?? ?? 0? 00 00 45 8C }
	condition:
		$1
}

rule file_91_1_0 {
	meta:
		name = "__dlclose"
		size = 44
		refs = "0010 _dlerror_run"
	strings:
		$1 = { 21 28 80 00 ?? ?? 04 3C E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? ?? ?? 84 24 1C 00 BF 8F 2B 10 02 00 23 10 02 00 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "__ptsname_internal"
		size = 784
		refs = "0000 __gnu_local_gp 0010 __libc_errno 0050 __isatty 00c8 __ioctl 00ec __xstat64 0154 __fxstat64 0198 __libc_ptyname1 01a8 strlen 01bc $LC1 01b8 __libc_ptyname2 0218 _itoa_word 0234 $LC0 0268 memcpy"
	strings:
		$1 = { ?? ?? 1C 3C A8 FF BD 27 ?? ?? 9C 27 40 00 B2 AF ?? ?? 92 8F 3B E8 03 7C 38 00 B0 AF 21 80 43 02 50 00 B6 AF 3C 00 B1 AF 54 00 BF AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF 10 00 BC AF 21 88 A0 00 12 00 A0 10 00 00 16 8E 21 A0 80 00 21 A8 C0 00 ?? ?? ?? 0? 21 98 E0 00 18 00 40 14 19 00 02 24 00 00 02 AE 54 00 BF 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 58 00 BD 27 54 00 BF 8F 16 00 02 24 00 00 02 AE 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 58 00 BD 27 04 40 05 3C 21 20 80 02 30 54 A5 24 ?? ?? ?? 0? 30 00 A6 27 4D 00 40 10 16 00 02 24 00 00 03 8E 12 00 62 10 00 00 00 00 03 00 04 24 21 28 20 02 ?? ?? ?? 0? 21 30 60 02 12 00 40 04 00 00 00 00 18 00 63 8E 00 20 02 24 00 F0 63 30 5B 00 62 10 03 00 04 24 3B E8 03 7C 21 10 43 02 19 00 03 24 00 00 43 AC ?? ?? ?? 0? 19 00 02 24 0B 00 B5 2E 08 00 A0 12 03 00 04 24 22 00 02 24 ?? ?? ?? 0? 00 00 02 AE 3B E8 03 7C 21 10 43 02 ?? ?? ?? 0? 00 00 42 8C 21 28 80 02 ?? ?? ?? 0? 21 30 60 02 5F 00 40 04 02 00 04 24 28 00 62 8E 00 5A 43 7C 06 00 64 10 04 00 04 24 5B 00 64 10 80 FF 63 24 08 00 63 2C E3 FF 60 10 00 00 00 00 02 1B 02 00 FF 00 42 30 00 FF 04 24 24 18 64 00 ?? ?? 15 3C 25 80 62 00 ?? ?? A4 26 30 00 B0 AF ?? ?? ?? 0? 02 A1 10 00 2B 10 82 02 D6 FF 40 10 ?? ?? 04 3C ?? ?? 02 3C ?? ?? 43 8C ?? ?? 42 24 ?? ?? B5 26 0F 00 10 32 ?? ?? 84 24 04 00 42 8C 21 A0 95 02 21 20 04 02 03 00 23 AA 00 00 85 92 00 00 84 90 00 00 23 BA 07 00 22 AA 04 00 22 BA 08 00 25 A2 09 00 24 A2 ?? ?? ?? 0? 0A 00 20 A2 30 00 A4 8F 0A 00 06 24 2C 00 A5 27 21 38 00 00 ?? ?? ?? 0? 2C 00 A0 A3 2D 00 A6 27 23 30 C2 00 09 00 C3 24 2B A8 A3 02 C0 FF A0 16 ?? ?? 03 3C ?? ?? 65 8C ?? ?? 63 24 04 00 64 8C 03 00 25 AA 08 00 67 90 09 00 63 90 00 00 25 BA 07 00 24 AA 04 00 24 BA 21 28 40 00 09 00 24 26 08 00 27 A2 ?? ?? ?? 0? 09 00 23 A2 ?? ?? ?? 0? 03 00 04 24 28 00 63 8E 00 5A 62 7C 06 00 44 10 04 00 04 24 09 00 44 10 78 FF 42 24 08 00 42 2C 9E FF 40 10 00 00 00 00 3B E8 03 7C 21 10 43 02 00 00 56 AC ?? ?? ?? 0? 21 10 00 00 02 23 03 00 00 FF 02 24 24 10 82 00 FF 00 63 30 25 10 43 00 40 FF 42 24 40 00 42 2C 90 FF 40 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 00 00 02 8E 02 1B 02 00 00 FF 04 24 24 20 83 00 FF 00 42 30 25 20 82 00 80 FF 84 24 40 00 84 2C 83 FF 80 10 00 FF 04 24 ?? ?? ?? 0? 24 18 64 00 }
	condition:
		$1
}

rule file_92_1_0 {
	meta:
		name = "ptsname"
		size = 60
		refs = "0018 __ptsname_internal"
	strings:
		$1 = { 40 FF BD 27 B8 00 B0 AF ?? ?? 10 3C ?? ?? 05 26 18 00 A7 27 BC 00 BF AF ?? ?? ?? 0? 1E 00 06 24 BC 00 BF 8F ?? ?? 10 26 0B 80 02 00 21 10 00 02 B8 00 B0 8F 08 00 E0 03 C0 00 BD 27 }
	condition:
		$1
}

rule file_92_2_0 {
	meta:
		name = "__ptsname_r"
		size = 28
		refs = "0008 __ptsname_internal"
	strings:
		$1 = { 40 FF BD 27 BC 00 BF AF ?? ?? ?? 0? 18 00 A7 27 BC 00 BF 8F 08 00 E0 03 C0 00 BD 27 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "cbc_crypt"
		size = 312
		refs = "00f4 _des_crypt"
	strings:
		$1 = { A8 FF BD 27 50 00 B0 AF 68 00 B0 8F 54 00 BF AF 07 00 C2 30 00 00 0E 82 01 00 0D 82 02 00 0C 82 03 00 0B 82 04 00 0A 82 05 00 09 82 06 00 08 82 07 00 03 82 24 00 A0 AF 28 00 AE A3 29 00 AD A3 2A 00 AC A3 2B 00 AB A3 2C 00 AA A3 2D 00 A9 A3 2E 00 A8 A3 2F 00 A3 A3 0E 00 40 10 03 00 0F 24 00 00 0E A2 01 00 0D A2 02 00 0C A2 03 00 0B A2 04 00 0A A2 05 00 09 A2 06 00 08 A2 07 00 03 A2 54 00 BF 8F 50 00 B0 8F 21 10 E0 01 08 00 E0 03 58 00 BD 27 01 20 C2 2C F1 FF 40 10 00 00 00 00 00 00 8D 90 01 00 8C 90 02 00 8B 90 03 00 8A 90 04 00 89 90 05 00 88 90 06 00 83 90 07 00 82 90 01 00 EE 30 21 20 A0 00 21 28 C0 00 18 00 A6 27 48 00 A7 AF 20 00 AE AF 18 00 AD A3 19 00 AC A3 1A 00 AB A3 1B 00 AA A3 1C 00 A9 A3 1D 00 A8 A3 1E 00 A3 A3 ?? ?? ?? 0? 1F 00 A2 A3 02 00 0F 24 0A 00 40 14 48 00 A7 8F 28 00 AE 83 29 00 AD 83 2A 00 AC 83 2B 00 AB 83 2C 00 AA 83 2D 00 A9 83 2E 00 A8 83 ?? ?? ?? 0? 2F 00 A3 83 02 00 E7 30 ?? ?? ?? 0? 01 00 EF 2C }
	condition:
		$1
}

rule file_93_1_0 {
	meta:
		name = "ecb_crypt"
		size = 172
		refs = "008c _des_crypt"
	strings:
		$1 = { A8 FF BD 27 01 00 08 24 07 00 C2 30 03 00 03 24 54 00 BF AF 05 00 40 10 24 00 A8 AF 54 00 BF 8F 21 10 60 00 08 00 E0 03 58 00 BD 27 01 20 C2 2C FB FF 40 10 54 00 BF 8F 06 00 83 90 00 00 8D 90 01 00 8C 90 02 00 8B 90 03 00 8A 90 04 00 89 90 05 00 88 90 07 00 82 90 01 00 EE 30 21 20 A0 00 21 28 C0 00 18 00 A6 27 1E 00 A3 A3 48 00 A7 AF 20 00 AE AF 18 00 AD A3 19 00 AC A3 1A 00 AB A3 1B 00 AA A3 1C 00 A9 A3 1D 00 A8 A3 ?? ?? ?? 0? 1F 00 A2 A3 02 00 03 24 E0 FF 40 10 48 00 A7 8F 02 00 E3 30 ?? ?? ?? 0? 01 00 63 2C }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "strxfrm"
		size = 32
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0018 __strxfrm_l"
	strings:
		$1 = { ?? ?? 1C 3C 3B E8 03 7C ?? ?? 9C 27 21 10 60 00 ?? ?? 83 8F 21 10 62 00 ?? ?? ?? 0? 00 00 47 8C }
	condition:
		$1
}

rule file_1101_0_0 {
	meta:
		name = "__strtod_internal"
		size = 32
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0018 ____strtod_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C 3B E8 03 7C ?? ?? 9C 27 21 10 60 00 ?? ?? 83 8F 21 10 62 00 ?? ?? ?? 0? 00 00 47 8C }
	condition:
		$1
}

rule file_737_0_0 {
	meta:
		name = "__strtof_internal"
		size = 32
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0018 ____strtof_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C 3B E8 03 7C ?? ?? 9C 27 21 10 60 00 ?? ?? 83 8F 21 10 62 00 ?? ?? ?? 0? 00 00 47 8C }
	condition:
		$1
}

rule file_559_0_0 {
	meta:
		name = "__strtold_internal"
		size = 32
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0018 ____strtold_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C 3B E8 03 7C ?? ?? 9C 27 21 10 60 00 ?? ?? 83 8F 21 10 62 00 ?? ?? ?? 0? 00 00 47 8C }
	condition:
		$1
}

rule file_1090_0_0 {
	meta:
		name = "__wcstod_internal"
		size = 32
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0018 ____wcstod_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C 3B E8 03 7C ?? ?? 9C 27 21 10 60 00 ?? ?? 83 8F 21 10 62 00 ?? ?? ?? 0? 00 00 47 8C }
	condition:
		$1
}

rule file_1023_0_0 {
	meta:
		name = "__wcstof_internal"
		size = 32
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0018 ____wcstof_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C 3B E8 03 7C ?? ?? 9C 27 21 10 60 00 ?? ?? 83 8F 21 10 62 00 ?? ?? ?? 0? 00 00 47 8C }
	condition:
		$1
}

rule file_947_0_0 {
	meta:
		name = "__wcstold_internal"
		size = 32
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0018 ____wcstold_l_internal"
	strings:
		$1 = { ?? ?? 1C 3C 3B E8 03 7C ?? ?? 9C 27 21 10 60 00 ?? ?? 83 8F 21 10 62 00 ?? ?? ?? 0? 00 00 47 8C }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "wcsxfrm"
		size = 32
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0018 __wcsxfrm_l"
	strings:
		$1 = { ?? ?? 1C 3C 3B E8 03 7C ?? ?? 9C 27 21 10 60 00 ?? ?? 83 8F 21 10 62 00 ?? ?? ?? 0? 00 00 47 8C }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "endnetgrent_hook"
		size = 96
		refs = "0034 __nss_lookup_function 0030 $LC0"
	strings:
		$1 = { E0 FF BD 27 18 00 B0 AF 21 80 80 00 28 00 84 8C FF FF 82 24 FE FF 42 2C 05 00 40 14 1C 00 BF AF 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 03 00 40 10 21 C8 40 00 09 F8 20 03 21 20 00 02 1C 00 BF 8F 28 00 00 AE 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_95_1_0 {
	meta:
		name = "setup"
		size = 188
		refs = "0048 $LC1 0054 __nss_lookup 0068 __nss_netgroup_lookup"
	strings:
		$1 = { D8 FF BD 27 20 00 B1 AF ?? ?? 11 3C ?? ?? 22 92 1C 00 B0 AF 24 00 BF AF 21 38 80 00 0F 00 40 10 21 80 A0 00 ?? ?? 02 3C ?? ?? 42 8C FF FF 03 24 1D 00 43 10 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 00 00 A2 AC 21 20 A0 00 ?? ?? 05 3C ?? ?? A5 24 21 30 00 00 ?? ?? ?? 0? 28 00 BD 27 21 20 A0 00 ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? 21 30 E0 00 0B 00 40 10 FF FF 03 24 ?? ?? 04 3C ?? ?? 83 AC 0F 00 00 00 24 00 BF 8F 01 00 03 24 1C 00 B0 8F ?? ?? 23 A2 20 00 B1 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 00 00 03 8E 20 00 B1 8F 1C 00 B0 8F 01 00 02 24 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_95_2_0 {
	meta:
		name = "__internal_setnetgrent_reuse"
		size = 504
		refs = "0004 __gnu_local_gp 006c $LC1 0070 $LC0 0098 _dl_mcount_wrapper_check 00cc __nss_next2 00e4 strlen 00f0 malloc 0114 memcpy 0158 __nss_lookup_function 018c __libc_errno 01d8 $LC2 01dc $LC3 01f0 __assert_fail 01e0 __PRETTY_FUNCTION__.11039"
	strings:
		$1 = { B0 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 34 00 B3 AF 30 00 B2 AF 28 00 B3 24 21 90 80 00 21 20 A0 00 4C 00 BF AF 48 00 BE AF 28 00 B0 AF 18 00 BC AF 21 80 A0 00 21 F0 C0 00 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF ?? ?? ?? 0? 2C 00 B1 AF 20 00 A4 27 ?? ?? ?? 0? 21 28 60 02 5C 00 40 14 00 00 00 00 10 00 02 8E 5B 00 40 14 ?? ?? 16 3C ?? ?? 17 3C ?? ?? D6 26 01 00 15 24 ?? ?? ?? 0? ?? ?? F7 26 17 00 40 14 00 00 00 00 10 00 02 8E 52 00 40 14 ?? ?? 04 3C ?? ?? ?? 0? 20 00 A4 8F 20 00 B9 8F 21 20 40 02 09 F8 20 03 21 28 00 02 10 00 A2 AF 14 00 A0 AF 21 88 40 00 21 20 60 02 21 28 C0 02 21 30 00 00 20 00 A7 27 ?? ?? ?? 0? 28 00 14 8E EB FF 35 16 00 00 00 00 1E 00 40 10 21 20 80 02 ?? ?? ?? 0? 21 20 40 02 05 00 44 24 ?? ?? ?? 0? 01 00 54 24 21 98 40 00 21 00 40 10 18 00 BC 8F 20 00 02 8E 04 00 64 26 21 28 40 02 21 30 80 02 ?? ?? ?? 0? 00 00 62 AE 4C 00 BF 8F 01 00 22 3A 20 00 13 AE 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 01 00 42 2C 08 00 E0 03 50 00 BD 27 ?? ?? ?? 0? 21 28 E0 02 CA FF 40 10 21 88 40 00 ?? ?? ?? 0? 21 20 40 00 21 C8 20 02 09 F8 20 03 21 20 00 02 ?? ?? ?? 0? 10 00 02 8E 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 4C 00 BF 8F 44 00 B7 8F 21 20 64 00 00 00 83 8C 40 00 B6 8F 3C 00 B5 8F 00 00 C3 AF 38 00 B4 8F 48 00 BE 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 21 10 00 00 08 00 E0 03 50 00 BD 27 ?? ?? ?? 0? FF FF 11 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 88 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_95_3_0 {
	meta:
		name = "nscd_getnetgrent"
		size = 140
		refs = "0034 __rawmemchr"
	strings:
		$1 = { E0 FF BD 27 18 00 B0 AF 21 80 80 00 1C 00 BF AF 10 00 84 8C 14 00 03 8E 18 00 02 8E 21 18 83 00 2B 18 43 00 17 00 60 10 21 20 40 00 21 28 00 00 00 00 00 AE ?? ?? ?? 0? 04 00 02 AE 01 00 42 24 21 20 40 00 21 28 00 00 18 00 02 AE ?? ?? ?? 0? 08 00 02 AE 01 00 44 24 18 00 04 AE 0C 00 04 AE ?? ?? ?? 0? 21 28 00 00 01 00 42 24 18 00 02 AE 01 00 02 24 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_95_4_0 {
	meta:
		name = "free_memory.isra.0"
		size = 108
		refs = "0024 free"
	strings:
		$1 = { D8 FF BD 27 20 00 B1 AF 21 88 80 00 00 00 84 8C 1C 00 B0 AF 24 00 BF AF 07 00 80 10 21 80 A0 00 00 00 82 8C ?? ?? ?? 0? 00 00 22 AE 00 00 24 8E FB FF 80 14 00 00 00 00 00 00 04 8E 07 00 80 10 24 00 BF 8F 00 00 82 8C ?? ?? ?? 0? 00 00 02 AE 00 00 04 8E FB FF 80 14 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_95_5_0 {
	meta:
		name = "__internal_setnetgrent"
		size = 92
		refs = "0004 __gnu_local_gp 003c __libc_errno"
	strings:
		$1 = { D8 FF BD 27 ?? ?? 1C 3C 1C 00 B0 AF 21 80 A0 00 20 00 B1 AF ?? ?? 9C 27 21 88 80 00 24 00 A5 24 24 00 BF AF 10 00 BC AF ?? ?? ?? 0? 20 00 04 26 10 00 BC 8F 24 00 BF 8F 21 20 20 02 ?? ?? 86 8F 20 00 B1 8F 21 28 00 02 1C 00 B0 8F 3B E8 03 7C 21 30 C3 00 ?? ?? ?? 0? 28 00 BD 27 }
	condition:
		$1
}

rule file_95_6_0 {
	meta:
		name = "setnetgrent"
		size = 304
		refs = "0044 __nss_not_use_nscd_netgroup 0068 __nss_database_custom 007c __nscd_setnetgrent 00dc __internal_setnetgrent 00fc __lll_lock_wait_private"
	strings:
		$1 = { D0 FF BD 27 1C 00 B0 AF ?? ?? 10 3C 28 00 B3 AF ?? ?? 03 26 21 98 80 00 2C 00 BF AF 24 00 B2 AF 20 00 B1 AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 2F 00 40 14 00 00 00 00 ?? ?? 03 3C ?? ?? 62 8C 27 00 40 18 00 00 00 00 01 00 42 24 65 00 44 28 1D 00 80 14 ?? ?? 12 3C ?? ?? 60 AC ?? ?? 02 3C ?? ?? 42 90 20 00 40 14 21 20 60 02 ?? ?? 12 3C ?? ?? ?? 0? ?? ?? 45 26 14 00 40 04 21 88 40 00 ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 17 00 40 10 ?? ?? 04 26 2C 00 BF 8F 21 10 20 02 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? 62 AC 21 20 60 02 ?? ?? ?? 0? ?? ?? 45 26 ?? ?? ?? 0? 21 88 40 00 DF FF 40 10 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 12 3C ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? ?? ?? 03 3C 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 2C 00 BF 8F }
	condition:
		$1
}

rule file_95_7_0 {
	meta:
		name = "__internal_endnetgrent"
		size = 44
	strings:
		$1 = { E0 FF BD 27 18 00 B0 AF 1C 00 BF AF ?? ?? ?? 0? 21 80 80 00 1C 00 BF 8F 20 00 04 26 24 00 05 26 18 00 B0 8F ?? ?? ?? 0? 20 00 BD 27 }
	condition:
		$1
}

rule file_95_8_0 {
	meta:
		name = "endnetgrent"
		size = 192
		refs = "008c __lll_lock_wait_private"
	strings:
		$1 = { E0 FF BD 27 18 00 B0 AF ?? ?? 10 3C ?? ?? 03 26 1C 00 BF AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 17 00 40 14 00 00 00 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 09 00 40 10 ?? ?? 04 26 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? ?? ?? 04 3C 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 1C 00 BF 8F }
	condition:
		$1
}

rule file_95_9_0 {
	meta:
		name = "__internal_getnetgrent_r"
		size = 612
		refs = "0004 __gnu_local_gp 0064 __nss_lookup_function 005c $LC4 0078 __libc_errno 008c _dl_mcount_wrapper_check 00d8 strcmp 0120 strlen 012c malloc 014c memcpy"
	strings:
		$1 = { 28 00 E2 8C ?? ?? 1C 3C B8 FF BD 27 ?? ?? 9C 27 28 00 B2 AF 20 00 B0 AF 44 00 BF AF 40 00 BE AF 3C 00 B7 AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 2C 00 B3 AF 24 00 B1 AF 10 00 BC AF 21 80 E0 00 48 00 A4 AF 4C 00 A5 AF 50 00 A6 AF 60 00 40 10 60 00 B2 8F FF FF 03 24 6A 00 43 10 ?? ?? 05 3C 21 20 40 00 ?? ?? ?? 0? ?? ?? A5 24 21 98 40 00 57 00 40 10 10 00 BC 8F ?? ?? 96 8F 3B E8 03 7C 02 00 15 24 21 B0 C3 02 01 00 14 24 ?? ?? ?? 0? 21 20 60 02 58 00 A5 8F 5C 00 A6 8F 21 20 00 02 21 C8 60 02 09 F8 20 03 21 38 C0 02 2B 00 55 10 00 00 00 00 47 00 54 14 44 00 BF 8F 00 00 02 8E 53 00 54 14 48 00 B9 8F 20 00 1E 8E 09 00 C0 13 04 00 11 8E 04 00 C5 27 ?? ?? ?? 0? 21 20 20 02 EA FF 40 10 00 00 00 00 00 00 DE 8F FA FF C0 17 04 00 C5 27 24 00 1E 8E 09 00 C0 13 04 00 C5 27 21 B8 C0 03 ?? ?? ?? 0? 21 20 20 02 DF FF 40 10 00 00 00 00 00 00 F7 8E FA FF E0 16 04 00 E5 26 ?? ?? ?? 0? 21 20 20 02 05 00 44 24 ?? ?? ?? 0? 18 00 A2 AF 21 88 40 00 25 00 40 10 18 00 A6 8F 04 00 05 8E 04 00 24 26 01 00 C6 24 ?? ?? ?? 0? 00 00 3E AE ?? ?? ?? 0? 24 00 11 AE 24 00 03 8E 05 00 60 14 44 00 BF 8F ?? ?? ?? 0? 40 00 BE 8F 0F 00 40 14 00 00 00 00 00 00 65 8C 20 00 02 8E 04 00 64 24 24 00 05 AE 21 30 40 02 00 00 62 AC 21 28 00 02 ?? ?? ?? 0? 20 00 03 AE 24 00 03 8E F3 FF 60 14 00 00 00 00 0A 00 40 10 44 00 BF 8F 28 00 04 8E 07 00 80 10 44 00 BF 8F ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 B0 FF 40 14 21 98 40 00 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 21 10 00 00 08 00 E0 03 48 00 BD 27 ?? ?? 13 3C ?? ?? ?? 0? ?? ?? 73 26 04 00 03 8E 44 00 BF 8F 40 00 BE 8F 00 00 23 AF 08 00 03 8E 4C 00 B9 8F 3C 00 B7 8F 38 00 B6 8F 00 00 23 AF 0C 00 03 8E 50 00 B9 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 01 00 02 24 00 00 23 AF 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_95_10_0 {
	meta:
		name = "__getnetgrent_r"
		size = 260
		refs = "0004 __gnu_local_gp 0050 __libc_errno 0070 __internal_getnetgrent_r 00c4 __lll_lock_wait_private"
	strings:
		$1 = { B8 FF BD 27 ?? ?? 1C 3C 3C 00 B0 AF ?? ?? 10 3C 40 00 B1 AF ?? ?? 9C 27 21 88 80 00 ?? ?? 03 26 44 00 BF AF 20 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 1E 00 40 14 ?? ?? 04 26 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 10 00 A7 AF ?? ?? 07 3C 21 10 62 00 58 00 A3 8F 21 20 20 02 18 00 A2 AF 14 00 A3 AF ?? ?? ?? 0? ?? ?? E7 24 21 88 40 00 ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 10 00 40 10 ?? ?? 04 26 44 00 BF 8F 21 10 20 02 3C 00 B0 8F 40 00 B1 8F 08 00 E0 03 48 00 BD 27 28 00 A5 AF 2C 00 A6 AF ?? ?? ?? 0? 30 00 A7 AF 20 00 BC 8F 30 00 A7 8F 2C 00 A6 8F ?? ?? ?? 0? 28 00 A5 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 44 00 BF 8F }
	condition:
		$1
}

rule file_95_11_0 {
	meta:
		name = "innetgr"
		size = 972
		refs = "0394 __nss_database_custom 0000 __nss_not_use_nscd_netgroup 0008 __gnu_local_gp 006c __libc_errno 00c8 _dl_mcount_wrapper_check 00f8 __nss_lookup_function 00f4 $LC0 0120 $LC1 0138 __nss_next2 0190 __nscd_innetgr 01d0 $LC4 0228 __strcasecmp 024c strcmp 02fc strlen 030c malloc 0328 memcpy 03ac $LC5 03b0 $LC3 03c4 __assert_fail 03b4 __PRETTY_FUNCTION__.11216"
	strings:
		$1 = { ?? ?? 03 3C ?? ?? 62 8C ?? ?? 1C 3C 80 FB BD 27 ?? ?? 9C 27 70 04 B6 AF 6C 04 B5 AF 64 04 B3 AF 7C 04 BF AF 78 04 BE AF 74 04 B7 AF 68 04 B4 AF 60 04 B2 AF 5C 04 B1 AF 58 04 B0 AF 18 00 BC AF 80 04 A4 AF 21 98 A0 00 21 A8 C0 00 D0 00 40 18 21 B0 E0 00 01 00 42 24 65 00 44 28 44 00 80 10 00 00 00 00 ?? ?? 62 AC 80 04 B9 8F ?? ?? 94 8F 3B E8 03 7C 20 04 A0 AF 24 04 A0 AF 28 04 A0 AF 2C 04 A0 AF 30 04 A0 AF 34 04 A0 AF 38 04 A0 AF 3C 04 A0 AF 40 04 A0 AF 44 04 A0 AF 48 04 A0 AF 50 04 B9 AF 21 A0 83 02 4C 04 A4 27 ?? ?? ?? 0? 48 04 A5 27 25 00 40 14 44 04 A2 8F 30 04 A2 8F BA 00 40 14 4C 04 A4 8F ?? ?? ?? 0? 21 90 00 00 50 04 A4 8F 4C 04 B9 8F 09 F8 20 03 20 04 A5 27 21 80 40 00 01 00 02 24 39 00 02 12 48 04 A4 8F 48 04 A4 8F ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 45 24 06 00 40 10 21 88 40 00 ?? ?? ?? 0? 21 20 40 00 21 C8 20 02 09 F8 20 03 20 04 A4 27 89 00 40 16 ?? ?? 05 3C 10 00 B0 AF 14 00 A0 AF 48 04 A4 27 ?? ?? A5 24 21 30 00 00 ?? ?? ?? 0? 4C 04 A7 27 DF FF 40 10 30 04 A2 8F 44 04 A2 8F 7F 00 40 10 04 00 59 24 00 00 43 8C 50 04 B9 AF 44 04 A3 AF 40 04 A3 8F 00 00 43 AC ?? ?? ?? 0? 40 04 A2 AF ?? ?? 60 AC ?? ?? 02 3C ?? ?? 42 90 BB FF 40 14 80 04 B9 8F 80 04 A4 8F 21 28 60 02 21 30 A0 02 ?? ?? ?? 0? 21 38 C0 02 B3 FF 40 04 18 00 BC 8F 7C 04 BF 8F 78 04 BE 8F 74 04 B7 8F 70 04 B6 8F 6C 04 B5 8F 68 04 B4 8F 64 04 B3 8F 60 04 B2 8F 5C 04 B1 8F 58 04 B0 8F 08 00 E0 03 80 04 BD 27 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 C4 FF 40 10 21 88 40 00 01 00 12 24 ?? ?? ?? 0? 21 20 20 02 20 04 A4 27 20 00 A5 27 00 04 06 24 21 C8 20 02 09 F8 20 03 21 38 80 02 4B 00 52 14 20 04 A2 8F 1E 00 52 10 24 04 A4 8F 07 00 80 10 00 00 00 00 05 00 60 12 00 00 00 00 ?? ?? ?? 0? 21 28 60 02 ED FF 40 14 00 00 00 00 28 04 A4 8F 07 00 80 10 00 00 00 00 05 00 A0 12 00 00 00 00 ?? ?? ?? 0? 21 28 A0 02 E4 FF 40 14 00 00 00 00 2C 04 A4 8F 07 00 80 10 00 00 00 00 05 00 C0 12 00 00 00 00 ?? ?? ?? 0? 21 28 C0 02 DB FF 40 14 00 00 00 00 01 00 12 24 ?? ?? ?? 0? 02 00 10 24 40 04 B7 8F 09 00 E0 12 24 04 B0 8F 21 20 00 02 ?? ?? ?? 0? 04 00 E5 26 D0 FF 40 10 00 00 00 00 00 00 F7 8E FA FF E0 16 21 20 00 02 44 04 B7 8F 0B 00 E0 12 80 04 A4 8F 21 F0 E0 02 21 20 00 02 ?? ?? ?? 0? 04 00 C5 27 C4 FF 40 10 00 00 00 00 00 00 DE 8F FA FF C0 17 21 20 00 02 80 04 A4 8F ?? ?? ?? 0? 21 28 00 02 BC FF 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 01 00 46 24 05 00 44 24 ?? ?? ?? 0? 54 04 A6 AF 21 F0 40 00 21 00 40 10 54 04 A6 8F 04 00 44 24 21 28 00 02 ?? ?? ?? 0? 00 00 57 AC ?? ?? ?? 0? 44 04 BE AF 21 90 00 00 ?? ?? ?? 0? 02 00 10 24 01 00 42 3A 01 00 42 2C 40 04 A4 27 44 04 A5 27 ?? ?? ?? 0? 54 04 A2 AF 7C 04 BF 8F 54 04 A2 8F 78 04 BE 8F 74 04 B7 8F 70 04 B6 8F 6C 04 B5 8F 68 04 B4 8F 64 04 B3 8F 60 04 B2 8F 5C 04 B1 8F 58 04 B0 8F 08 00 E0 03 80 04 BD 27 79 FF 40 10 ?? ?? 02 3C ?? ?? ?? 0? 80 04 B9 8F FF FF 12 24 ?? ?? ?? 0? 02 00 10 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 A7 01 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "__getsgnam_r"
		size = 544
		refs = "0010 __gnu_local_gp 0074 __libc_errno 007c $LC0 0088 _dl_mcount_wrapper_check 00dc __nss_next2 01d0 __nss_gshadow_lookup2"
	strings:
		$1 = { B0 FF BD 27 2C 00 B0 AF ?? ?? 10 3C ?? ?? 02 92 ?? ?? 1C 3C ?? ?? 9C 27 40 00 B5 AF 3C 00 B4 AF 38 00 B3 AF 34 00 B2 AF 4C 00 BF AF 48 00 B7 AF 44 00 B6 AF 30 00 B1 AF 18 00 BC AF 21 98 80 00 21 90 A0 00 21 A0 C0 00 5D 00 40 10 21 A8 E0 00 ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 44 8C 01 00 62 24 24 00 A3 AF 20 00 A4 AF 01 00 42 2C 45 00 40 14 ?? ?? 97 8F 3B E8 03 7C ?? ?? 16 3C 21 88 E3 02 ?? ?? D6 26 ?? ?? ?? 0? 20 00 A4 8F 20 00 B9 8F 21 20 60 02 21 28 40 02 21 30 80 02 21 38 A0 02 09 F8 20 03 10 00 B1 AF 21 80 40 00 FE FF 02 24 24 00 A4 27 21 28 C0 02 21 30 00 00 05 00 02 16 20 00 A7 27 00 00 23 8E 22 00 02 24 2F 00 62 10 60 00 A3 8F 10 00 B0 AF ?? ?? ?? 0? 14 00 A0 AF E8 FF 40 10 01 00 02 24 15 00 02 12 60 00 A3 8F 02 00 02 2E 47 00 40 14 00 00 60 AC 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 27 00 43 10 FE FF 03 24 4C 00 BF 8F 48 00 B7 8F 44 00 B6 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 50 00 BD 27 60 00 A2 8F 00 00 52 AC 21 10 00 00 4C 00 BF 8F 3B E8 03 7C 21 20 E3 02 44 00 B6 8F 48 00 B7 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 00 00 82 AC 08 00 E0 03 50 00 BD 27 FF FF 10 24 60 00 A3 8F 00 00 60 AC 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 DD FF 43 14 4C 00 BF 8F FE FF 03 24 DA FF 03 12 4C 00 BF 8F ?? ?? ?? 0? 16 00 02 24 ?? ?? 05 3C 24 00 A4 27 ?? ?? A5 24 21 30 00 00 ?? ?? ?? 0? 20 00 A7 27 0B 00 40 14 18 00 BC 8F 20 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 24 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 0F 00 00 00 01 00 03 24 ?? ?? ?? 0? ?? ?? 03 A2 FF FF 04 24 ?? ?? 03 3C ?? ?? ?? 0? ?? ?? 64 AC ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_802_0_0 {
	meta:
		name = "__getaliasbyname_r"
		size = 544
		refs = "0010 __gnu_local_gp 0074 __libc_errno 007c $LC0 0088 _dl_mcount_wrapper_check 00dc __nss_next2 01d0 __nss_aliases_lookup2"
	strings:
		$1 = { B0 FF BD 27 2C 00 B0 AF ?? ?? 10 3C ?? ?? 02 92 ?? ?? 1C 3C ?? ?? 9C 27 40 00 B5 AF 3C 00 B4 AF 38 00 B3 AF 34 00 B2 AF 4C 00 BF AF 48 00 B7 AF 44 00 B6 AF 30 00 B1 AF 18 00 BC AF 21 98 80 00 21 90 A0 00 21 A0 C0 00 5D 00 40 10 21 A8 E0 00 ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 44 8C 01 00 62 24 24 00 A3 AF 20 00 A4 AF 01 00 42 2C 45 00 40 14 ?? ?? 97 8F 3B E8 03 7C ?? ?? 16 3C 21 88 E3 02 ?? ?? D6 26 ?? ?? ?? 0? 20 00 A4 8F 20 00 B9 8F 21 20 60 02 21 28 40 02 21 30 80 02 21 38 A0 02 09 F8 20 03 10 00 B1 AF 21 80 40 00 FE FF 02 24 24 00 A4 27 21 28 C0 02 21 30 00 00 05 00 02 16 20 00 A7 27 00 00 23 8E 22 00 02 24 2F 00 62 10 60 00 A3 8F 10 00 B0 AF ?? ?? ?? 0? 14 00 A0 AF E8 FF 40 10 01 00 02 24 15 00 02 12 60 00 A3 8F 02 00 02 2E 47 00 40 14 00 00 60 AC 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 27 00 43 10 FE FF 03 24 4C 00 BF 8F 48 00 B7 8F 44 00 B6 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 50 00 BD 27 60 00 A2 8F 00 00 52 AC 21 10 00 00 4C 00 BF 8F 3B E8 03 7C 21 20 E3 02 44 00 B6 8F 48 00 B7 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 00 00 82 AC 08 00 E0 03 50 00 BD 27 FF FF 10 24 60 00 A3 8F 00 00 60 AC 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 DD FF 43 14 4C 00 BF 8F FE FF 03 24 DA FF 03 12 4C 00 BF 8F ?? ?? ?? 0? 16 00 02 24 ?? ?? 05 3C 24 00 A4 27 ?? ?? A5 24 21 30 00 00 ?? ?? ?? 0? 20 00 A7 27 0B 00 40 14 18 00 BC 8F 20 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 24 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 0F 00 00 00 01 00 03 24 ?? ?? ?? 0? ?? ?? 03 A2 FF FF 04 24 ?? ?? 03 3C ?? ?? ?? 0? ?? ?? 64 AC ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_1405_0_0 {
	meta:
		name = "__getprotobyname_r"
		size = 544
		refs = "0010 __gnu_local_gp 0074 __libc_errno 007c $LC0 0088 _dl_mcount_wrapper_check 00dc __nss_next2 01d0 __nss_protocols_lookup2"
	strings:
		$1 = { B0 FF BD 27 2C 00 B0 AF ?? ?? 10 3C ?? ?? 02 92 ?? ?? 1C 3C ?? ?? 9C 27 40 00 B5 AF 3C 00 B4 AF 38 00 B3 AF 34 00 B2 AF 4C 00 BF AF 48 00 B7 AF 44 00 B6 AF 30 00 B1 AF 18 00 BC AF 21 98 80 00 21 90 A0 00 21 A0 C0 00 5D 00 40 10 21 A8 E0 00 ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 44 8C 01 00 62 24 24 00 A3 AF 20 00 A4 AF 01 00 42 2C 45 00 40 14 ?? ?? 97 8F 3B E8 03 7C ?? ?? 16 3C 21 88 E3 02 ?? ?? D6 26 ?? ?? ?? 0? 20 00 A4 8F 20 00 B9 8F 21 20 60 02 21 28 40 02 21 30 80 02 21 38 A0 02 09 F8 20 03 10 00 B1 AF 21 80 40 00 FE FF 02 24 24 00 A4 27 21 28 C0 02 21 30 00 00 05 00 02 16 20 00 A7 27 00 00 23 8E 22 00 02 24 2F 00 62 10 60 00 A3 8F 10 00 B0 AF ?? ?? ?? 0? 14 00 A0 AF E8 FF 40 10 01 00 02 24 15 00 02 12 60 00 A3 8F 02 00 02 2E 47 00 40 14 00 00 60 AC 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 27 00 43 10 FE FF 03 24 4C 00 BF 8F 48 00 B7 8F 44 00 B6 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 50 00 BD 27 60 00 A2 8F 00 00 52 AC 21 10 00 00 4C 00 BF 8F 3B E8 03 7C 21 20 E3 02 44 00 B6 8F 48 00 B7 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 00 00 82 AC 08 00 E0 03 50 00 BD 27 FF FF 10 24 60 00 A3 8F 00 00 60 AC 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 DD FF 43 14 4C 00 BF 8F FE FF 03 24 DA FF 03 12 4C 00 BF 8F ?? ?? ?? 0? 16 00 02 24 ?? ?? 05 3C 24 00 A4 27 ?? ?? A5 24 21 30 00 00 ?? ?? ?? 0? 20 00 A7 27 0B 00 40 14 18 00 BC 8F 20 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 24 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 0F 00 00 00 01 00 03 24 ?? ?? ?? 0? ?? ?? 03 A2 FF FF 04 24 ?? ?? 03 3C ?? ?? ?? 0? ?? ?? 64 AC ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_1270_0_0 {
	meta:
		name = "__getprotobynumber_r"
		size = 544
		refs = "0010 __gnu_local_gp 0074 __libc_errno 007c $LC0 0088 _dl_mcount_wrapper_check 00dc __nss_next2 01d0 __nss_protocols_lookup2"
	strings:
		$1 = { B0 FF BD 27 2C 00 B0 AF ?? ?? 10 3C ?? ?? 02 92 ?? ?? 1C 3C ?? ?? 9C 27 40 00 B5 AF 3C 00 B4 AF 38 00 B3 AF 34 00 B2 AF 4C 00 BF AF 48 00 B7 AF 44 00 B6 AF 30 00 B1 AF 18 00 BC AF 21 98 80 00 21 90 A0 00 21 A0 C0 00 5D 00 40 10 21 A8 E0 00 ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 44 8C 01 00 62 24 24 00 A3 AF 20 00 A4 AF 01 00 42 2C 45 00 40 14 ?? ?? 97 8F 3B E8 03 7C ?? ?? 16 3C 21 88 E3 02 ?? ?? D6 26 ?? ?? ?? 0? 20 00 A4 8F 20 00 B9 8F 21 20 60 02 21 28 40 02 21 30 80 02 21 38 A0 02 09 F8 20 03 10 00 B1 AF 21 80 40 00 FE FF 02 24 24 00 A4 27 21 28 C0 02 21 30 00 00 05 00 02 16 20 00 A7 27 00 00 23 8E 22 00 02 24 2F 00 62 10 60 00 A3 8F 10 00 B0 AF ?? ?? ?? 0? 14 00 A0 AF E8 FF 40 10 01 00 02 24 15 00 02 12 60 00 A3 8F 02 00 02 2E 47 00 40 14 00 00 60 AC 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 27 00 43 10 FE FF 03 24 4C 00 BF 8F 48 00 B7 8F 44 00 B6 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 50 00 BD 27 60 00 A2 8F 00 00 52 AC 21 10 00 00 4C 00 BF 8F 3B E8 03 7C 21 20 E3 02 44 00 B6 8F 48 00 B7 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 00 00 82 AC 08 00 E0 03 50 00 BD 27 FF FF 10 24 60 00 A3 8F 00 00 60 AC 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 DD FF 43 14 4C 00 BF 8F FE FF 03 24 DA FF 03 12 4C 00 BF 8F ?? ?? ?? 0? 16 00 02 24 ?? ?? 05 3C 24 00 A4 27 ?? ?? A5 24 21 30 00 00 ?? ?? ?? 0? 20 00 A7 27 0B 00 40 14 18 00 BC 8F 20 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 24 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 0F 00 00 00 01 00 03 24 ?? ?? ?? 0? ?? ?? 03 A2 FF FF 04 24 ?? ?? 03 3C ?? ?? ?? 0? ?? ?? 64 AC ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_373_0_0 {
	meta:
		name = "__getrpcbyname_r"
		size = 544
		refs = "0010 __gnu_local_gp 0074 __libc_errno 007c $LC0 0088 _dl_mcount_wrapper_check 00dc __nss_next2 01d0 __nss_rpc_lookup2"
	strings:
		$1 = { B0 FF BD 27 2C 00 B0 AF ?? ?? 10 3C ?? ?? 02 92 ?? ?? 1C 3C ?? ?? 9C 27 40 00 B5 AF 3C 00 B4 AF 38 00 B3 AF 34 00 B2 AF 4C 00 BF AF 48 00 B7 AF 44 00 B6 AF 30 00 B1 AF 18 00 BC AF 21 98 80 00 21 90 A0 00 21 A0 C0 00 5D 00 40 10 21 A8 E0 00 ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 44 8C 01 00 62 24 24 00 A3 AF 20 00 A4 AF 01 00 42 2C 45 00 40 14 ?? ?? 97 8F 3B E8 03 7C ?? ?? 16 3C 21 88 E3 02 ?? ?? D6 26 ?? ?? ?? 0? 20 00 A4 8F 20 00 B9 8F 21 20 60 02 21 28 40 02 21 30 80 02 21 38 A0 02 09 F8 20 03 10 00 B1 AF 21 80 40 00 FE FF 02 24 24 00 A4 27 21 28 C0 02 21 30 00 00 05 00 02 16 20 00 A7 27 00 00 23 8E 22 00 02 24 2F 00 62 10 60 00 A3 8F 10 00 B0 AF ?? ?? ?? 0? 14 00 A0 AF E8 FF 40 10 01 00 02 24 15 00 02 12 60 00 A3 8F 02 00 02 2E 47 00 40 14 00 00 60 AC 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 27 00 43 10 FE FF 03 24 4C 00 BF 8F 48 00 B7 8F 44 00 B6 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 50 00 BD 27 60 00 A2 8F 00 00 52 AC 21 10 00 00 4C 00 BF 8F 3B E8 03 7C 21 20 E3 02 44 00 B6 8F 48 00 B7 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 00 00 82 AC 08 00 E0 03 50 00 BD 27 FF FF 10 24 60 00 A3 8F 00 00 60 AC 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 DD FF 43 14 4C 00 BF 8F FE FF 03 24 DA FF 03 12 4C 00 BF 8F ?? ?? ?? 0? 16 00 02 24 ?? ?? 05 3C 24 00 A4 27 ?? ?? A5 24 21 30 00 00 ?? ?? ?? 0? 20 00 A7 27 0B 00 40 14 18 00 BC 8F 20 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 24 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 0F 00 00 00 01 00 03 24 ?? ?? ?? 0? ?? ?? 03 A2 FF FF 04 24 ?? ?? 03 3C ?? ?? ?? 0? ?? ?? 64 AC ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_1490_0_0 {
	meta:
		name = "__getrpcbynumber_r"
		size = 544
		refs = "0010 __gnu_local_gp 0074 __libc_errno 007c $LC0 0088 _dl_mcount_wrapper_check 00dc __nss_next2 01d0 __nss_rpc_lookup2"
	strings:
		$1 = { B0 FF BD 27 2C 00 B0 AF ?? ?? 10 3C ?? ?? 02 92 ?? ?? 1C 3C ?? ?? 9C 27 40 00 B5 AF 3C 00 B4 AF 38 00 B3 AF 34 00 B2 AF 4C 00 BF AF 48 00 B7 AF 44 00 B6 AF 30 00 B1 AF 18 00 BC AF 21 98 80 00 21 90 A0 00 21 A0 C0 00 5D 00 40 10 21 A8 E0 00 ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 44 8C 01 00 62 24 24 00 A3 AF 20 00 A4 AF 01 00 42 2C 45 00 40 14 ?? ?? 97 8F 3B E8 03 7C ?? ?? 16 3C 21 88 E3 02 ?? ?? D6 26 ?? ?? ?? 0? 20 00 A4 8F 20 00 B9 8F 21 20 60 02 21 28 40 02 21 30 80 02 21 38 A0 02 09 F8 20 03 10 00 B1 AF 21 80 40 00 FE FF 02 24 24 00 A4 27 21 28 C0 02 21 30 00 00 05 00 02 16 20 00 A7 27 00 00 23 8E 22 00 02 24 2F 00 62 10 60 00 A3 8F 10 00 B0 AF ?? ?? ?? 0? 14 00 A0 AF E8 FF 40 10 01 00 02 24 15 00 02 12 60 00 A3 8F 02 00 02 2E 47 00 40 14 00 00 60 AC 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 27 00 43 10 FE FF 03 24 4C 00 BF 8F 48 00 B7 8F 44 00 B6 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 50 00 BD 27 60 00 A2 8F 00 00 52 AC 21 10 00 00 4C 00 BF 8F 3B E8 03 7C 21 20 E3 02 44 00 B6 8F 48 00 B7 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 00 00 82 AC 08 00 E0 03 50 00 BD 27 FF FF 10 24 60 00 A3 8F 00 00 60 AC 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 DD FF 43 14 4C 00 BF 8F FE FF 03 24 DA FF 03 12 4C 00 BF 8F ?? ?? ?? 0? 16 00 02 24 ?? ?? 05 3C 24 00 A4 27 ?? ?? A5 24 21 30 00 00 ?? ?? ?? 0? 20 00 A7 27 0B 00 40 14 18 00 BC 8F 20 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 24 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 0F 00 00 00 01 00 03 24 ?? ?? ?? 0? ?? ?? 03 A2 FF FF 04 24 ?? ?? 03 3C ?? ?? ?? 0? ?? ?? 64 AC ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_843_0_0 {
	meta:
		name = "__getspnam_r"
		size = 544
		refs = "0010 __gnu_local_gp 0074 __libc_errno 007c $LC0 0088 _dl_mcount_wrapper_check 00dc __nss_next2 01d0 __nss_shadow_lookup2"
	strings:
		$1 = { B0 FF BD 27 2C 00 B0 AF ?? ?? 10 3C ?? ?? 02 92 ?? ?? 1C 3C ?? ?? 9C 27 40 00 B5 AF 3C 00 B4 AF 38 00 B3 AF 34 00 B2 AF 4C 00 BF AF 48 00 B7 AF 44 00 B6 AF 30 00 B1 AF 18 00 BC AF 21 98 80 00 21 90 A0 00 21 A0 C0 00 5D 00 40 10 21 A8 E0 00 ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 44 8C 01 00 62 24 24 00 A3 AF 20 00 A4 AF 01 00 42 2C 45 00 40 14 ?? ?? 97 8F 3B E8 03 7C ?? ?? 16 3C 21 88 E3 02 ?? ?? D6 26 ?? ?? ?? 0? 20 00 A4 8F 20 00 B9 8F 21 20 60 02 21 28 40 02 21 30 80 02 21 38 A0 02 09 F8 20 03 10 00 B1 AF 21 80 40 00 FE FF 02 24 24 00 A4 27 21 28 C0 02 21 30 00 00 05 00 02 16 20 00 A7 27 00 00 23 8E 22 00 02 24 2F 00 62 10 60 00 A3 8F 10 00 B0 AF ?? ?? ?? 0? 14 00 A0 AF E8 FF 40 10 01 00 02 24 15 00 02 12 60 00 A3 8F 02 00 02 2E 47 00 40 14 00 00 60 AC 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 27 00 43 10 FE FF 03 24 4C 00 BF 8F 48 00 B7 8F 44 00 B6 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 50 00 BD 27 60 00 A2 8F 00 00 52 AC 21 10 00 00 4C 00 BF 8F 3B E8 03 7C 21 20 E3 02 44 00 B6 8F 48 00 B7 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 00 00 82 AC 08 00 E0 03 50 00 BD 27 FF FF 10 24 60 00 A3 8F 00 00 60 AC 3B E8 03 7C 21 10 E3 02 00 00 42 8C 22 00 03 24 DD FF 43 14 4C 00 BF 8F FE FF 03 24 DA FF 03 12 4C 00 BF 8F ?? ?? ?? 0? 16 00 02 24 ?? ?? 05 3C 24 00 A4 27 ?? ?? A5 24 21 30 00 00 ?? ?? ?? 0? 20 00 A7 27 0B 00 40 14 18 00 BC 8F 20 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 24 00 A4 8F ?? ?? 03 3C ?? ?? 64 AC 0F 00 00 00 01 00 03 24 ?? ?? ?? 0? ?? ?? 03 A2 FF FF 04 24 ?? ?? 03 3C ?? ?? ?? 0? ?? ?? 64 AC ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "__getsockname"
		size = 28
	strings:
		$1 = { 4C 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "__openat64_2"
		size = 40
		refs = "000c __openat64 0020 __fortify_fail 0014 $LC0"
	strings:
		$1 = { 00 01 C2 30 03 00 40 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? ?? ?? 84 24 }
	condition:
		$1
}

rule file_944_0_0 {
	meta:
		name = "__openat_2"
		size = 40
		refs = "000c __openat 0020 __fortify_fail 0014 $LC0"
	strings:
		$1 = { 00 01 C2 30 03 00 40 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? ?? ?? 84 24 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "__getlogin_r_chk"
		size = 36
		refs = "000c getlogin_r 001c __chk_fail"
	strings:
		$1 = { 2B 30 C5 00 03 00 C0 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_1437_0_0 {
	meta:
		name = "__getcwd_chk"
		size = 36
		refs = "000c __getcwd 001c __chk_fail"
	strings:
		$1 = { 2B 30 C5 00 03 00 C0 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_846_0_0 {
	meta:
		name = "__getdomainname_chk"
		size = 36
		refs = "000c getdomainname 001c __chk_fail"
	strings:
		$1 = { 2B 30 C5 00 03 00 C0 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_841_0_0 {
	meta:
		name = "__gethostname_chk"
		size = 36
		refs = "000c __gethostname 001c __chk_fail"
	strings:
		$1 = { 2B 30 C5 00 03 00 C0 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "semtimedop"
		size = 140
		refs = "0004 __gnu_local_gp 0078 __libc_errno"
	strings:
		$1 = { E8 FF BD 27 ?? ?? 1C 3C 21 18 80 00 14 00 BE AF 10 00 B0 AF 21 F0 A0 03 ?? ?? 9C 27 F0 FF BD 27 21 10 A0 00 21 80 E0 00 00 00 DC AF 08 00 DD AF 04 00 04 24 21 28 60 00 21 38 00 00 E0 FF BD 27 10 00 A2 AF 14 00 B0 AF 15 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 14 00 00 00 00 21 E8 C0 03 14 00 BE 8F 10 00 B0 8F 08 00 E0 03 18 00 BD 27 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "__vswprintf_chk"
		size = 216
		refs = "0028 _IO_wstrn_jumps 0048 _IO_no_init 0054 _IO_fwide 007c _IO_wstr_init_static 008c _IO_vfwprintf 00d0 __chk_fail"
	strings:
		$1 = { 68 FD BD 27 2B 38 E5 00 88 02 B0 AF 94 02 BF AF 90 02 B2 AF 8C 02 B1 AF 2D 00 E0 14 21 80 A0 00 29 00 A0 10 68 00 A0 AF ?? ?? 02 3C ?? ?? 42 24 21 88 80 00 00 80 05 34 20 00 A4 27 C8 01 A7 27 10 00 A2 AF 21 90 C0 00 ?? ?? ?? 0? 21 30 00 00 20 00 A4 27 ?? ?? ?? 0? 01 00 05 24 04 00 40 1A 00 00 20 AE 5C 00 A2 8F 04 00 42 34 5C 00 A2 AF 21 28 20 02 21 38 20 02 20 00 A4 27 ?? ?? ?? 0? FF FF 06 26 A8 02 A5 8F AC 02 A6 8F ?? ?? ?? 0? 20 00 A4 27 7C 00 A3 8F C8 00 A4 27 18 00 65 8C 09 00 A4 10 00 00 00 00 10 00 63 8C 00 00 60 AC 94 02 BF 8F 90 02 B2 8F 8C 02 B1 8F 88 02 B0 8F 08 00 E0 03 98 02 BD 27 ?? ?? ?? 0? FF FF 02 24 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "__swapoff"
		size = 28
	strings:
		$1 = { 13 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_104_1_0 {
	meta:
		name = "gmtime"
		size = 16
		refs = "0008 __tz_convert 0000 _tmbuf"
	strings:
		$1 = { ?? ?? 06 3C 21 28 00 00 ?? ?? ?? 0? ?? ?? C6 24 }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "__rmdir"
		size = 28
	strings:
		$1 = { C8 0F 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "read_int"
		size = 140
	strings:
		$1 = { 00 00 83 8C CC 0C 08 3C CD CC 08 35 00 00 62 90 01 00 63 24 00 00 83 AC 00 00 65 90 D0 FF 42 24 FF 7F 09 3C D0 FF A5 24 0A 00 A6 2C FF FF 29 35 12 00 C0 10 2A 38 48 00 09 00 40 04 40 30 02 00 C0 10 02 00 21 10 C2 00 23 30 25 01 2A 30 C2 00 21 28 45 00 0B 00 E0 10 FF FF 02 24 0A 10 A6 00 01 00 63 24 00 00 83 AC 00 00 65 90 D0 FF A5 24 0A 00 A6 2C F0 FF C0 14 2A 38 48 00 08 00 E0 03 00 00 00 00 ?? ?? ?? 0? 01 00 63 24 }
	condition:
		$1
}

rule file_106_1_0 {
	meta:
		name = "__parse_one_specmb"
		size = 1896
		refs = "0140 __printf_modifier_table 0204 __printf_function_table 028c __strchrnul 0578 __handle_registered_modifier_mb 0694 __printf_arginfo_table"
	strings:
		$1 = { D8 FF BD 27 20 00 B2 AF 18 00 B0 AF 24 00 BF AF 1C 00 B1 AF 0C 00 C2 94 20 00 03 24 01 00 8B 24 C4 18 02 7C 04 21 02 7C 44 29 02 7C 84 31 02 7C C4 39 02 7C C4 5A 02 7C 04 42 02 7C 84 52 02 7C FF FF 0D 24 28 00 AB AF 10 00 C3 AC 24 00 CD AC 0C 00 C2 A4 01 00 82 90 21 80 C0 00 21 50 80 00 D0 FF 43 24 0A 00 63 2C 21 90 A0 00 91 00 60 14 21 60 E0 00 21 18 60 01 ?? ?? 06 3C ?? ?? C6 24 01 00 08 24 30 00 05 24 E0 FF 42 24 FF 00 42 30 2A 00 44 2C 0D 00 80 10 80 10 02 00 21 10 C2 00 00 00 42 8C 08 00 40 00 00 00 00 00 0C 00 02 96 C4 5A 02 7D 0C 00 02 A6 01 00 64 24 28 00 A4 AF 01 00 62 90 F0 FF 40 14 21 18 80 00 0C 00 02 8E 20 00 42 30 03 00 40 10 FF FF 0A 24 20 00 02 24 10 00 02 AE 20 00 0A AE 04 00 00 AE 00 00 62 90 2A 00 04 24 85 00 44 10 D0 FF 42 24 0A 00 42 2C 8F 00 40 14 21 88 00 00 FF FF 0A 24 1C 00 0A AE 00 00 0A AE 00 00 64 90 2E 00 02 24 71 00 82 10 01 00 64 24 0C 00 02 96 0E 00 00 A6 04 00 02 7C 44 08 02 7C 84 10 02 7C 44 4A 02 7C 0C 00 02 A6 ?? ?? 02 3C ?? ?? 42 8C 05 01 40 14 00 00 00 00 01 00 64 24 28 00 A4 AF 00 00 62 90 B4 FF 42 24 FF 00 42 30 2F 00 45 2C B8 00 A0 10 ?? ?? 05 3C 80 10 02 00 ?? ?? A5 24 21 10 A2 00 00 00 42 8C 08 00 40 00 00 00 00 00 ?? ?? ?? 0? 10 00 05 AE 0C 00 02 96 44 29 02 7D ?? ?? ?? 0? 0C 00 02 A6 0C 00 02 96 84 31 02 7D ?? ?? ?? 0? 0C 00 02 A6 0C 00 02 96 C4 39 02 7D ?? ?? ?? 0? 0C 00 02 A6 0C 00 02 96 C4 18 02 7D ?? ?? ?? 0? 0C 00 02 A6 0C 00 02 96 04 21 02 7D ?? ?? ?? 0? 0C 00 02 A6 0C 00 05 96 02 00 62 24 21 18 80 00 04 00 05 7C 21 20 A0 00 84 10 04 7C 0C 00 04 A6 28 00 A2 AF 00 00 62 90 ?? ?? 03 3C ?? ?? 63 8C FF FF 04 24 08 00 02 AE 1F 01 60 14 30 00 04 AE 08 00 04 8E 01 00 02 24 64 00 03 24 FB 00 83 10 2C 00 02 AE 65 00 83 28 30 01 60 10 48 00 83 28 24 01 60 14 58 00 03 24 F4 00 83 10 59 00 83 28 0B 01 60 14 61 00 03 24 E9 00 83 10 63 00 03 24 E2 00 83 14 00 00 00 00 28 00 02 AE 63 00 04 24 24 00 03 8E FF FF 02 24 C6 00 62 10 00 00 00 00 CB 00 80 10 28 00 A2 8F 28 00 A4 8F 25 00 05 24 ?? ?? ?? 0? 14 00 04 AE 24 00 BF 8F 18 00 02 AE 20 00 B2 8F 21 10 20 02 18 00 B0 8F 1C 00 B1 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 28 00 A4 27 05 00 40 10 28 00 A4 8F 24 00 03 24 00 00 85 90 77 00 A3 10 00 00 00 00 28 00 AB AF 01 00 42 91 ?? ?? ?? 0? 21 18 60 01 28 00 A4 AF 01 00 62 90 2A 00 05 24 61 00 45 10 D0 FF 42 24 0A 00 42 2C 55 00 40 14 21 18 80 00 ?? ?? ?? 0? 00 00 00 AE 01 00 6B 24 28 00 AB AF 01 00 62 90 D0 FF 42 24 0A 00 42 2C 33 00 40 14 00 00 00 00 20 00 12 AE 28 00 AB AF 21 18 60 01 01 00 52 26 ?? ?? ?? 0? 01 00 11 24 ?? ?? ?? 0? 28 00 A4 27 6F FF 4A 10 28 00 A3 8F ?? ?? ?? 0? 04 00 02 AE 0C 00 02 96 21 18 80 00 01 00 04 24 04 00 82 7C 0C 00 02 A6 ?? ?? ?? 0? 01 00 62 24 0C 00 02 96 01 00 05 24 84 10 A2 7C 0C 00 02 A6 01 00 66 90 6C 00 05 24 58 00 C5 10 00 00 00 00 02 00 62 24 ?? ?? ?? 0? 21 18 80 00 01 00 65 90 68 00 02 24 4B 00 A2 10 01 00 05 24 0C 00 05 96 02 00 62 24 01 00 03 24 44 08 65 7C 0C 00 05 A6 ?? ?? ?? 0? 21 18 80 00 0C 00 06 96 01 00 05 24 02 00 62 24 04 00 A6 7C 21 18 C0 00 84 10 A3 7C 0C 00 03 A6 ?? ?? ?? 0? 21 18 80 00 ?? ?? ?? 0? 28 00 A4 27 1D 00 40 10 28 00 A3 8F 24 00 04 24 00 00 65 90 19 00 A4 14 00 00 00 00 06 00 4A 10 FF FF 44 24 20 00 04 AE 00 00 84 8D 2B 28 44 00 0B 10 85 00 00 00 82 AD 20 00 02 8E 01 00 63 24 28 00 A3 AF BB FF 40 04 00 00 00 00 28 00 A3 8F ?? ?? ?? 0? 21 88 00 00 ?? ?? ?? 0? 21 10 80 00 ?? ?? ?? 0? 28 00 A4 27 02 00 4A 10 00 00 00 00 00 00 02 AE ?? ?? ?? 0? 28 00 A3 8F ?? ?? ?? 0? 20 00 02 8E 02 00 6B 24 28 00 AB AF 02 00 62 90 D0 FF 42 24 0A 00 42 2C 1A 00 40 14 00 00 00 00 1C 00 12 AE 01 00 31 26 28 00 AB AF 21 18 60 01 ?? ?? ?? 0? 01 00 52 26 01 00 83 24 07 00 4D 10 28 00 A3 AF FF FF 45 24 24 00 05 AE 00 00 85 8D 2B 30 45 00 0B 10 A6 00 00 00 82 AD ?? ?? ?? 0? 01 00 82 90 0C 00 04 96 03 00 62 24 44 4A A4 7C 0C 00 04 A6 ?? ?? ?? 0? 02 00 63 24 ?? ?? ?? 0? 02 00 63 24 ?? ?? ?? 0? 28 00 A4 27 05 00 40 10 24 00 04 24 28 00 A3 8F 00 00 65 90 06 00 A4 10 00 00 00 00 1C 00 02 8E DD FF 40 04 00 00 00 00 ?? ?? ?? 0? 28 00 A3 8F 06 00 4A 10 FF FF 44 24 1C 00 04 AE 00 00 84 8D 2B 28 44 00 0B 10 85 00 00 00 82 AD 1C 00 02 8E 01 00 63 24 F4 FF 41 04 28 00 A3 AF ?? ?? ?? 0? 1C 00 12 AE 00 00 64 90 80 20 04 00 21 10 44 00 00 00 42 8C F7 FE 40 10 28 00 A4 27 ?? ?? ?? 0? 21 28 00 02 F3 FE 40 14 28 00 A3 8F ?? ?? ?? 0? 01 00 62 24 2C 00 02 8E 39 FF 40 10 00 00 00 00 24 00 12 AE 38 FF 80 14 21 88 22 02 28 00 A2 8F 24 00 BF 8F 20 00 B2 8F FF FF 42 24 18 00 02 AE 14 00 02 AE 21 10 20 02 18 00 B0 8F 1C 00 B1 8F 08 00 E0 03 28 00 BD 27 75 00 02 24 0F 00 82 10 78 00 02 24 0D 00 82 10 00 00 00 00 ?? ?? ?? 0? 2C 00 00 AE 68 00 82 28 FC FF 40 10 00 00 00 00 0C 00 02 8E 01 00 42 30 0B 00 40 10 07 00 02 24 07 01 02 24 ?? ?? ?? 0? 28 00 02 AE 0C 00 02 8E 01 00 43 30 06 00 60 10 04 00 43 30 00 01 02 24 ?? ?? ?? 0? 28 00 02 AE ?? ?? ?? 0? 28 00 02 AE 04 00 60 10 02 00 43 30 00 02 02 24 ?? ?? ?? 0? 28 00 02 AE 04 00 60 10 00 02 42 30 00 04 02 24 ?? ?? ?? 0? 28 00 02 AE 03 00 40 10 01 00 02 24 ?? ?? ?? 0? 28 00 02 AE ?? ?? ?? 0? 28 00 00 AE 53 00 02 24 D9 FF 82 14 04 00 02 24 28 00 02 AE ?? ?? ?? 0? 53 00 04 24 ?? ?? 03 3C ?? ?? 63 8C 80 10 02 00 21 10 62 00 00 00 59 8C DC FE 20 13 21 20 00 02 01 00 05 24 28 00 06 26 09 F8 20 03 30 00 07 26 D6 FE 40 04 2C 00 02 AE ?? ?? ?? 0? 08 00 04 8E 45 00 82 28 C9 FF 40 10 41 00 02 24 C7 FF 82 10 43 00 02 24 C0 FF 82 14 02 00 02 24 28 00 02 AE ?? ?? ?? 0? 43 00 04 24 6F 00 02 24 C6 FF 82 10 70 00 82 28 0E 00 40 14 73 00 02 24 08 00 82 10 74 00 82 28 AF FF 40 10 70 00 02 24 B2 FF 82 14 05 00 02 24 28 00 02 AE ?? ?? ?? 0? 70 00 04 24 03 00 02 24 28 00 02 AE ?? ?? ?? 0? 73 00 04 24 69 00 02 24 B4 FF 82 10 6A 00 82 28 A8 FF 40 14 6E 00 02 24 A4 FF 82 14 00 08 02 24 28 00 02 AE ?? ?? ?? 0? 6E 00 04 24 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "__flock"
		size = 28
	strings:
		$1 = { 2F 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "putgrent"
		size = 756
		refs = "0000 __gnu_local_gp 00dc fprintf 00d0 $LC4 0104 $LC2 010c $LC1 0254 $LC3 026c __lll_lock_wait_private 0284 $LC0 02a4 __libc_errno 02c0 __overflow"
	strings:
		$1 = { ?? ?? 1C 3C C0 FF BD 27 ?? ?? 9C 27 38 00 B4 AF 3C 00 BF AF 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 9C 00 80 10 21 A0 80 00 9A 00 A0 10 21 88 A0 00 00 00 A2 8C 00 80 42 30 18 00 40 14 00 00 00 00 3B E8 03 7C 48 00 A4 8C 70 8B 70 24 08 00 82 8C 0F 00 50 10 00 00 00 00 20 00 A0 AF 00 00 83 C0 06 00 60 14 00 00 02 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 02 24 0F 00 00 00 79 00 40 10 00 00 00 00 48 00 22 8E 21 20 40 00 08 00 50 AC 04 00 82 8C 01 00 42 24 04 00 82 AC 00 00 86 8E 2B 00 03 24 00 00 C2 80 66 00 43 10 04 00 87 8E 2D 00 03 24 63 00 43 10 00 00 00 00 6F 00 E0 10 00 00 00 00 08 00 82 8E ?? ?? 05 3C 21 20 20 02 10 00 A2 AF ?? ?? ?? 0? ?? ?? A5 24 17 00 40 04 00 00 00 00 0C 00 82 8E 31 00 40 10 00 00 00 00 00 00 46 8C 2E 00 C0 10 21 80 00 00 ?? ?? 13 3C ?? ?? ?? 0? ?? ?? 12 3C 0C 00 82 8E 21 18 43 00 00 00 66 8C 26 00 C0 10 00 00 00 00 ?? ?? 62 26 ?? ?? 45 26 0B 28 50 00 ?? ?? ?? 0? 21 20 20 02 01 00 10 26 F4 FF 41 04 80 18 10 00 00 00 22 8E 00 80 42 30 10 00 40 14 00 00 00 00 48 00 24 8E 04 00 82 8C FF FF 42 24 0B 00 40 14 04 00 82 AC 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 51 00 40 10 00 00 00 00 FF FF 10 24 3C 00 BF 8F 21 10 00 02 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 40 00 BD 27 14 00 23 8E 18 00 22 8E 2B 10 62 00 3D 00 40 10 01 00 62 24 14 00 22 AE 0A 00 02 24 21 80 00 00 00 00 62 A0 00 00 22 8E 00 80 42 30 EC FF 40 14 3C 00 BF 8F 48 00 24 8E 04 00 82 8C FF FF 42 24 E6 FF 40 14 04 00 82 AC 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 DC FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 3C 00 BF 8F 10 00 E0 10 00 00 00 00 ?? ?? 05 3C 21 20 20 02 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 20 00 A3 AF 48 00 22 8E 21 20 40 00 ?? ?? ?? 0? 08 00 50 AC ?? ?? 07 3C ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 07 3C ?? ?? ?? 0? ?? ?? E7 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F FF FF 10 24 21 10 62 00 16 00 03 24 ?? ?? ?? 0? 00 00 43 AC 21 20 20 02 ?? ?? ?? 0? 0A 00 05 24 ?? ?? ?? 0? C3 87 02 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? FF FF 10 24 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "svc_exit"
		size = 56
		refs = "0008 __rpc_thread_svc_pollfd 0014 free 001c __rpc_thread_svc_max_pollfd"
	strings:
		$1 = { E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 18 00 B0 AF 00 00 44 8C ?? ?? ?? 0? 21 80 40 00 ?? ?? ?? 0? 00 00 00 AE 1C 00 BF 8F 18 00 B0 8F 00 00 40 AC 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_109_1_0 {
	meta:
		name = "svc_run"
		size = 380
		refs = "0000 __gnu_local_gp 002c __rpc_thread_svc_max_pollfd 0040 __libc_errno 0060 __rpc_thread_svc_pollfd 007c realloc 00e0 __poll 00fc svc_getreq_poll 0114 _libc_intl_domainname 0118 $LC1 0124 __dcgettext 012c perror 015c free 016c $LC0"
	strings:
		$1 = { ?? ?? 1C 3C C8 FF BD 27 ?? ?? 9C 27 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 10 00 BC AF 34 00 BF AF 30 00 B6 AF ?? ?? ?? 0? 2C 00 B5 AF 10 00 BC 8F 3B E8 03 7C 21 90 40 00 ?? ?? 94 8F 21 88 00 00 21 80 00 00 21 A0 83 02 04 00 13 24 00 00 55 8E 06 00 A0 16 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 00 00 42 8C 32 00 40 10 10 00 BC 8F 3B 00 35 12 21 20 00 02 ?? ?? ?? 0? C0 28 15 00 39 00 40 10 ?? ?? 04 3C 21 B0 A0 02 21 88 A0 02 21 80 40 00 10 00 A0 1A 21 20 00 02 ?? ?? ?? 0? 00 00 00 00 00 00 46 8C 21 18 00 02 21 38 00 00 00 00 C2 8C 08 00 C6 24 08 00 63 24 F8 FF 62 AC FC FF C8 84 01 00 E7 24 FE FF 60 A4 F8 FF F5 14 FC FF 68 A4 21 20 00 02 21 28 C0 02 ?? ?? ?? 0? FF FF 06 24 FF FF 03 24 07 00 43 10 00 00 00 00 D7 FF 40 10 21 20 00 02 ?? ?? ?? 0? 21 28 40 00 ?? ?? ?? 0? 00 00 55 8E 00 00 82 8E D0 FF 53 10 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? ?? 0? 21 20 40 00 10 00 BC 8F 34 00 BF 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 21 20 00 02 18 00 B0 8F ?? ?? ?? 0? 38 00 BD 27 ?? ?? ?? 0? 21 B0 20 02 ?? ?? 05 3C ?? ?? 84 24 ?? ?? ?? 0? ?? ?? A5 24 }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "_dl_important_hwcaps"
		size = 2204
		refs = "0004 _dl_hwcap 0024 _dl_hwcap_mask 010c _dl_sysinfo_map 0230 $LC1 02d4 $LC2 03b4 malloc 046c mempcpy 0548 $LC0 0550 memcmp 07c4 strlen 0854 $LC3 0858 $LC4 086c __assert_fail 085c __PRETTY_FUNCTION__.8915 0884 _dl_signal_error 0874 $LC5"
	strings:
		$1 = { ?? ?? 03 3C ?? ?? 63 8C 88 FF BD 27 ?? ?? 02 3C 70 00 BE AF 21 F0 A0 03 ?? ?? 42 8C 2C 00 C3 AF ?? ?? 03 3C ?? ?? 63 8C 20 00 C2 AF ?? ?? 02 3C ?? ?? 42 8C 34 00 C3 AF 20 00 C3 8F 78 00 C4 AF 64 00 B5 AF 2C 00 C4 8F 24 A8 43 00 34 00 C3 8F 5C 00 B3 AF 50 00 B0 AF 24 98 64 00 78 00 C3 8F 25 80 B3 02 68 00 B6 AF 2B 18 03 00 74 00 BF AF 6C 00 B7 AF 60 00 B4 AF 58 00 B2 AF 54 00 B1 AF 30 00 C2 AF 24 00 C3 AF 7C 00 C5 AF 80 00 C6 AF 84 00 C7 AF 1D 00 00 12 21 B0 60 00 21 20 00 00 21 18 00 00 40 40 13 00 01 00 07 24 01 00 63 24 20 00 65 30 04 10 67 00 21 58 40 00 0B 10 05 00 0A 58 05 00 27 60 04 00 23 28 02 00 2B 50 05 00 06 10 95 00 04 60 88 01 23 58 0B 00 20 00 89 30 06 30 93 00 25 10 82 01 23 20 6A 01 24 20 93 00 0B 10 C9 00 24 28 B5 00 01 00 42 30 25 28 A4 00 21 B0 C2 02 E9 FF A0 14 21 20 60 00 ?? ?? 02 3C ?? ?? 42 8C 3C 00 40 10 1C 00 C2 AF 2C 02 58 94 39 00 00 13 24 02 4B 8C 21 68 00 00 3C 00 D5 AF 40 00 D3 AF 44 00 D0 AF 04 00 11 24 02 00 12 24 FC FF 14 24 38 00 D6 AF 21 A8 60 01 21 98 A0 01 ?? ?? ?? 0? 21 80 00 03 01 00 73 26 2B 10 70 02 25 00 40 10 20 00 B5 26 00 00 A2 8E FA FF 51 14 1C 00 C3 8F 08 00 A7 8E 14 00 A8 8E 00 00 62 8C 0C 00 04 24 21 B8 E2 00 2B 10 88 00 21 B0 E0 02 F1 FF 40 10 0C 00 E4 26 18 00 D0 AF 21 80 E0 02 21 B8 00 01 08 00 C2 8E E6 00 52 10 00 00 C3 8E 04 00 C2 8E 03 00 63 24 03 00 42 24 24 18 74 00 24 10 54 00 21 10 62 00 0C 00 42 24 21 B0 C2 02 0C 00 C4 26 23 10 90 00 2B 10 57 00 F1 FF 40 14 00 00 00 00 18 00 D0 8F 01 00 73 26 2B 10 70 02 DD FF 40 14 20 00 B5 26 38 00 D6 8F 3C 00 D5 8F 40 00 D3 8F 44 00 D0 8F 01 00 D6 26 C0 10 16 00 08 00 42 24 23 E8 A2 03 1C 00 D6 AF 10 00 B2 27 01 00 02 24 21 B8 00 00 7B 01 00 12 00 00 00 00 ?? ?? 07 3C 21 10 00 00 ?? ?? E7 24 01 00 06 24 27 18 02 00 40 28 13 00 04 28 65 00 06 18 55 00 25 18 A3 00 20 00 44 30 06 28 53 00 0B 18 A4 00 01 00 63 30 0C 00 60 10 04 18 46 00 21 28 60 00 C0 40 17 00 0A 28 04 00 0B 18 04 00 26 A8 A3 02 21 20 48 02 26 98 65 02 00 00 87 AC 04 00 80 AC 01 00 F7 26 25 80 B3 02 E9 FF 00 16 01 00 42 24 01 00 E3 26 20 00 C3 AF 24 00 C3 8F 1C 01 60 10 C0 10 17 00 78 00 C3 8F 21 10 42 02 00 00 43 AC 20 00 C4 8F 7C 00 C3 8F 04 00 43 AC 01 00 83 24 20 00 C5 8F ?? ?? 04 3C 1C 00 C6 8F C0 10 05 00 21 10 42 02 ?? ?? 84 24 00 00 44 AC 03 00 04 24 58 01 C3 14 04 00 44 AC 1C 00 C3 8F 01 00 02 24 DB 00 62 10 80 00 C3 8F 04 00 43 8E 18 00 C3 AF 1C 00 C3 8F 03 00 62 2C 18 00 C3 8F 1E 00 40 14 05 00 64 24 40 20 04 00 02 00 02 24 01 00 05 24 ?? ?? ?? 0? 1C 00 C6 8F 21 28 40 00 21 10 60 00 C0 18 05 00 21 18 43 02 04 00 65 8C 01 00 43 24 01 00 A5 24 F8 FF C3 14 21 20 85 00 1C 00 C3 8F 03 00 02 24 09 00 62 10 20 00 62 2C 41 01 40 10 20 00 C5 8F 22 00 02 24 40 00 83 24 23 10 45 00 06 10 43 00 3C 01 40 14 ?? ?? 07 3C 20 00 C3 8F FE FF 62 24 04 20 44 00 1C 00 C3 8F 01 00 08 24 04 98 68 00 80 00 C3 8F C0 80 13 00 21 20 90 00 00 00 73 AC ?? ?? ?? 0? 48 00 C8 AF 21 88 40 00 2C 01 40 10 48 00 C8 8F 1C 00 C3 8F 21 20 30 02 02 00 02 24 00 00 24 AE 11 01 62 10 08 00 24 AE 20 00 C3 8F 00 00 56 8E 24 00 D1 AF FF FF 75 24 C0 10 15 00 04 B8 68 00 21 18 42 02 21 88 E0 02 2F 00 10 24 28 00 D3 AF 2C 00 D2 AF 21 B8 60 00 74 00 05 24 6C 00 06 24 73 00 02 24 00 00 85 A0 01 00 86 A0 02 00 82 A0 03 00 90 A0 FE FF 31 26 04 00 84 24 21 A0 E0 02 21 98 A0 02 ?? ?? ?? 0? 01 00 12 24 FF FF 73 26 0D 00 60 12 F8 FF 94 26 04 28 72 02 24 28 B1 00 FA FF A0 10 00 00 00 00 00 00 85 8E 04 00 86 8E FF FF 73 26 ?? ?? ?? 0? F8 FF 94 26 00 00 50 A0 F5 FF 60 16 01 00 44 24 18 00 C6 8F ?? ?? ?? 0? 21 28 C0 02 00 00 50 A0 DF FF 20 16 01 00 44 24 24 00 D1 8F 28 00 D3 8F 2C 00 D2 8F 1C 00 C4 8F 01 00 03 24 21 10 00 00 04 18 83 00 05 00 60 10 C0 20 03 00 21 18 22 02 08 00 42 24 FD FF 44 14 04 00 60 AC 1C 00 C3 8F 01 00 08 24 FF FF 74 24 C0 38 14 00 21 38 47 02 04 00 E7 24 04 28 88 02 21 18 20 02 11 00 60 12 21 10 60 02 FF FF 42 24 24 20 A2 00 0B 00 80 10 00 00 00 00 00 00 E4 8C 04 00 66 8C FF FF 42 24 01 00 84 24 21 20 C4 00 08 00 63 24 FC FF 64 AC 24 20 A2 00 F7 FF 80 14 00 00 00 00 F1 FF 40 14 08 00 63 24 12 00 80 12 F8 FF E7 24 ?? ?? ?? 0? FF FF 94 26 1A FF 71 14 ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? 04 00 06 24 03 00 40 10 04 00 03 24 ?? ?? ?? 0? 04 00 C2 8E 04 00 C2 8E 0B 00 43 2C 6E 00 60 10 04 00 03 24 ?? ?? ?? 0? 03 00 63 24 20 00 C4 8F 01 00 07 24 FE FF 63 26 04 38 87 00 1C 00 67 10 10 00 22 26 21 28 20 02 21 20 40 00 ?? ?? ?? 0? 08 00 29 26 00 00 A8 8C 04 00 A6 8C 08 00 84 24 08 00 A5 24 21 30 06 01 0B 00 67 10 F8 FF 86 AC FF FF 63 24 01 00 66 30 F6 FF C0 14 23 30 91 00 21 30 C9 00 F0 FF C6 8C 08 00 84 24 08 00 A5 24 F7 FF 67 14 F8 FF 86 AC FF 1F 04 3C FE FF 84 34 21 20 64 02 23 20 83 00 C0 20 04 00 21 10 44 00 20 00 C6 8F F8 FF 05 24 04 28 C5 00 21 20 45 00 00 00 84 8C 08 00 42 24 FF FF 63 24 04 00 84 24 FA FF 60 14 F8 FF 44 AC 04 00 22 8E 84 00 C3 8F 00 00 62 AC 21 E8 C0 03 74 00 BF 8F 21 10 20 02 70 00 BE 8F 6C 00 B7 8F 68 00 B6 8F 64 00 B5 8F 60 00 B4 8F 5C 00 B3 8F 58 00 B2 8F 54 00 B1 8F 50 00 B0 8F 08 00 E0 03 78 00 BD 27 04 00 50 8E 02 00 13 24 11 00 04 26 ?? ?? ?? 0? 00 00 73 AC 21 88 40 00 7A 00 20 12 01 00 02 26 80 00 C3 8F 04 00 22 AE 00 00 45 8E 00 00 62 8C 0C 00 20 AE 00 00 64 8C C0 10 02 00 10 00 23 26 21 10 22 02 C0 20 04 00 00 00 23 AE 21 20 24 02 21 30 00 02 ?? ?? ?? 0? 08 00 22 AE 2F 00 03 24 00 00 43 A0 80 00 C3 8F 00 00 73 AC 04 00 22 8E 84 00 C3 8F 00 00 62 AC 21 E8 C0 03 74 00 BF 8F 21 10 20 02 70 00 BE 8F 6C 00 B7 8F 68 00 B6 8F 64 00 B5 8F 60 00 B4 8F 5C 00 B3 8F 58 00 B2 8F 54 00 B1 8F 50 00 B0 8F 08 00 E0 03 78 00 BD 27 20 00 C3 8F ?? ?? ?? 0? 20 00 D7 AF 21 B8 C0 02 14 00 F1 8E 38 00 D6 8F 20 00 C6 8F 10 00 E4 8E 01 00 CF 26 25 28 26 02 18 00 F6 26 ?? ?? 06 3C F8 FF 42 24 21 20 E4 01 21 18 C2 02 ?? ?? C5 AC 30 00 C2 8F 2C 00 C5 8F 1C 00 C4 AF C0 20 04 00 08 00 84 24 23 E8 A4 03 ?? ?? C5 AC 25 20 22 02 ?? ?? 06 3C ?? ?? C4 AC 34 00 C4 8F 2B 10 C3 02 3C 00 D5 8F 40 00 D3 8F 44 00 D0 8F 10 00 B2 27 ?? ?? C4 AC 29 00 40 10 21 B8 00 00 18 00 D3 AF 21 98 E0 02 21 B8 00 02 21 80 20 02 21 88 60 00 01 00 D4 26 ?? ?? ?? 0? 21 20 80 02 00 00 C4 92 01 00 05 24 04 20 85 00 24 20 90 00 2B 00 80 10 C0 20 13 00 21 20 44 02 00 00 94 AC 04 00 82 AC 01 00 73 26 01 00 56 24 21 B0 96 02 2B 10 D1 02 EF FF 40 14 01 00 62 26 21 80 E0 02 21 B8 60 02 87 FE 00 16 18 00 D3 8F ?? ?? ?? 0? 20 00 C2 AF 08 00 45 8E 0C 00 46 8E ?? ?? ?? 0? 2F 00 10 24 00 00 45 8E 18 00 C6 8F 00 00 50 A0 ?? ?? ?? 0? 01 00 44 24 ?? ?? ?? 0? 00 00 50 A0 ?? ?? ?? 0? 01 00 02 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 A6 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 07 3C 0C 00 04 24 21 28 00 00 21 30 00 00 ?? ?? ?? 0? ?? ?? E7 24 1C 00 C3 8F FF FF 63 24 ?? ?? ?? 0? 1C 00 C3 AF }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "getchar_unlocked"
		size = 48
		refs = "0000 _IO_stdin 0028 __uflow"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 44 8C 04 00 82 8C 08 00 83 8C 2B 18 43 00 04 00 60 10 01 00 43 24 04 00 83 AC 08 00 E0 03 00 00 42 90 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "inotify_init"
		size = 28
	strings:
		$1 = { BC 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "__mpn_mul"
		size = 996
		refs = "0064 __mpn_mul_1 0094 __mpn_addmul_1 00dc __mpn_add_n 0150 __mpn_impn_mul_n 0344 __mpn_mul"
	strings:
		$1 = { A0 FF BD 27 58 00 BE AF 21 F0 A0 03 50 00 B6 AF 70 00 D6 8F 4C 00 B5 AF 44 00 B3 AF 20 00 C2 2A 40 00 B2 AF 38 00 B0 AF 5C 00 BF AF 54 00 B7 AF 48 00 B4 AF 3C 00 B1 AF 21 98 80 00 21 A8 A0 00 21 80 C0 00 39 00 40 10 21 90 E0 00 2A 00 C0 12 21 10 00 00 00 00 E7 8C 02 00 E2 2C 57 00 40 14 01 00 02 24 ?? ?? ?? 0? 80 A0 10 00 21 20 74 02 02 00 C3 2A 00 00 82 AC 1F 00 60 14 04 00 71 26 FC FF 42 26 80 B0 16 00 21 B0 56 00 ?? ?? ?? 0? 01 00 13 24 ?? ?? ?? 0? 00 00 00 00 21 18 34 02 04 00 52 26 00 00 62 AC 13 00 56 12 04 00 31 26 04 00 43 8E 21 20 20 02 21 28 A0 02 02 00 62 2C 21 30 00 02 F3 FF 40 10 21 38 60 00 F3 FF 73 14 21 10 00 00 21 28 20 02 21 30 A0 02 ?? ?? ?? 0? 21 38 00 02 04 00 52 26 21 18 34 02 00 00 62 AC EF FF 56 16 04 00 31 26 21 E8 C0 03 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 60 00 BD 27 C0 88 16 00 08 00 31 26 23 E8 B1 03 18 00 A2 27 23 18 16 02 10 00 A2 AF 21 30 E0 00 21 38 C0 02 20 00 C2 AF ?? ?? ?? 0? 2C 00 C3 AF 2C 00 C3 8F 80 A0 16 00 21 B8 74 02 2A 10 76 00 1E 00 40 10 21 A8 B4 02 70 00 60 14 20 00 C4 8F 21 80 16 02 80 80 10 00 21 50 70 02 FC FF 42 8D 21 E8 C0 03 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 60 00 BD 27 53 00 E2 10 80 A0 06 00 05 00 C0 18 21 10 00 00 21 18 62 02 04 00 42 24 FD FF 54 14 00 00 60 AC ?? ?? ?? 0? 21 10 00 00 23 E8 B1 03 18 00 B1 27 21 78 34 02 04 00 E4 25 23 28 16 00 28 00 C4 AF 24 00 C5 AF 23 58 76 00 20 00 C2 8F 21 20 20 02 21 28 A0 02 21 30 40 02 21 38 C0 02 10 00 A2 AF 2C 00 CB AF ?? ?? ?? 0? 30 00 CF AF 21 20 E0 02 21 28 E0 02 21 30 20 02 ?? ?? ?? 0? 21 38 C0 02 30 00 CF 8F 21 B8 F4 02 04 00 E3 26 00 00 E4 8D 2C 00 CB 8F 28 00 C8 8F 21 10 44 00 2B 20 44 00 00 00 E2 AE 1D 00 80 14 21 10 C0 02 0E 00 68 10 02 00 44 28 0D 00 80 14 24 00 C4 8F FF 3F 05 3C FF FF A5 34 21 10 45 00 80 30 02 00 21 10 00 00 21 20 02 01 00 00 85 8C 21 20 62 00 04 00 42 24 FB FF 46 14 00 00 85 AC 24 00 C4 8F 21 18 60 01 21 58 64 01 21 10 CB 02 2A 10 56 00 D2 FF 40 10 21 A8 B4 02 ?? ?? ?? 0? 00 00 00 00 FC FF 09 8D 01 00 29 25 E5 FF 20 15 FC FF 69 AC FF FF 42 24 04 00 08 25 F9 FF 40 14 04 00 63 24 24 00 C4 8F 21 18 60 01 21 58 64 01 21 10 CB 02 2A 10 56 00 C1 FF 40 10 21 A8 B4 02 ?? ?? ?? 0? 00 00 00 00 B3 FF C0 18 21 10 00 00 21 18 A2 02 00 00 64 8C 21 18 62 02 04 00 42 24 FB FF 54 14 00 00 64 AC ?? ?? ?? 0? 21 10 00 00 10 00 A3 AF 21 28 40 02 21 30 C0 02 21 38 A0 02 ?? ?? ?? 0? 2C 00 C3 AF 20 00 C6 8F 21 20 E0 02 21 28 E0 02 ?? ?? ?? 0? 21 38 C0 02 20 00 C5 8F 21 70 F4 02 2C 00 C3 8F 21 20 B4 00 00 00 85 8C 04 00 84 24 21 10 45 00 2B 30 45 00 00 00 C2 AD 09 00 C0 10 04 00 C5 25 FF FF 63 24 04 00 84 24 78 FF 60 10 04 00 A5 24 FC FF 82 8C 01 00 42 24 F9 FF 40 10 FC FF A2 AC 72 FF A4 10 02 00 62 28 70 FF 40 14 21 10 00 00 80 18 03 00 FC FF 67 24 21 18 82 00 00 00 66 8C 21 18 A2 00 04 00 42 24 FB FF 47 14 00 00 66 AC ?? ?? ?? 0? 21 80 16 02 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "__dup"
		size = 28
	strings:
		$1 = { C9 0F 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "__gets_chk"
		size = 632
		refs = "0024 _IO_stdin 0090 _IO_getline 0178 __lll_lock_wait_private 01d4 __uflow 01f0 __chk_fail 021c _Unwind_Resume"
	strings:
		$1 = { C0 FF BD 27 34 00 B3 AF 3C 00 BF AF 38 00 B4 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 81 00 A0 10 21 98 A0 00 ?? ?? 12 3C ?? ?? 50 8E 00 00 02 8E 00 80 42 30 35 00 40 10 21 88 80 00 21 30 00 02 04 00 C2 8C 08 00 C3 8C 2B 18 43 00 61 00 60 10 01 00 43 24 04 00 C3 AC 00 00 42 90 0A 00 03 24 43 00 43 10 ?? ?? 44 8E DF FF 08 24 01 00 25 26 00 00 83 8C FF FF 66 26 0A 00 07 24 24 40 68 00 00 00 88 AC 00 00 22 A2 ?? ?? 44 8E 10 00 A0 AF ?? ?? ?? 0? 20 00 74 30 ?? ?? 44 8E 00 00 85 8C 20 00 A3 30 50 00 60 14 01 00 42 24 25 28 85 02 00 00 85 AC 2B 98 53 00 4D 00 60 12 21 10 22 02 00 00 40 A0 00 00 02 8E 00 80 42 30 07 00 40 14 3C 00 BF 8F 48 00 04 8E 04 00 82 8C FF FF 42 24 29 00 40 10 04 00 82 AC 3C 00 BF 8F 21 10 20 02 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 40 00 BD 27 3B E8 03 7C 48 00 04 8E 70 8B 74 24 08 00 82 8C 10 00 54 10 21 30 00 02 20 00 A0 AF 00 00 83 C0 06 00 60 14 00 00 02 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 02 24 0F 00 00 00 0B 00 40 10 00 00 00 00 48 00 02 8E ?? ?? 46 8E 21 20 40 00 08 00 54 AC 04 00 82 8C 01 00 42 24 ?? ?? ?? 0? 04 00 82 AC ?? ?? ?? 0? 21 10 00 00 ?? ?? ?? 0? 20 00 A3 AF ?? ?? ?? 0? 48 00 02 8E 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 CF FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 3C 00 BF 8F ?? ?? ?? 0? 21 20 C0 00 FF FF 03 24 9F FF 43 14 0A 00 03 24 ?? ?? ?? 0? 21 88 00 00 ?? ?? ?? 0? 00 00 00 00 00 00 02 8E 00 80 42 30 06 00 40 14 21 88 80 00 48 00 04 8E 04 00 83 8C FF FF 63 24 05 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 ?? ?? ?? 0? 00 00 00 00 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F3 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "__ftruncate64"
		size = 60
		refs = "0010 __gnu_local_gp 0028 __libc_errno"
	strings:
		$1 = { 21 28 00 00 74 10 02 24 0C 00 00 00 03 00 E0 14 ?? ?? 1C 3C 08 00 E0 03 00 00 00 00 ?? ?? 9C 27 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "__libc_fork"
		size = 880
		refs = "0004 __gnu_local_gp 0028 __fork_handlers 00d8 _IO_list_lock 015c __fork_generation_pointer 0178 __nptl_set_robust 0190 _IO_iter_begin 01a0 _IO_iter_file 01b8 _IO_iter_next 01c4 _IO_iter_end 01d4 _IO_list_resetlock 01dc _dl_load_lock 022c __fork_lock 0260 __libc_errno 0284 _IO_list_unlock 027c $LC2 0334 $LC1 0348 __assert_fail 0338 __PRETTY_FUNCTION__.10519 0350 $LC0"
	strings:
		$1 = { C8 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 30 00 BE AF 21 F0 A0 03 34 00 BF AF 2C 00 B2 AF 28 00 B1 AF 24 00 B0 AF 10 00 DC AF ?? ?? 03 3C ?? ?? 70 8C 29 00 00 12 21 88 00 00 0F 00 00 00 14 00 02 8E FA FF 40 10 ?? ?? 64 8C 01 00 46 24 18 00 C2 AF 14 00 84 24 00 00 87 C0 06 00 E2 14 00 00 05 24 21 08 C0 00 00 00 81 E0 FA FF 20 10 01 00 05 24 0F 00 00 00 AA 00 A0 10 21 90 00 00 ?? ?? ?? 0? 04 00 19 8E 14 00 03 26 0F 00 00 00 00 00 61 C0 01 00 21 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 21 90 40 00 04 00 19 8E 03 00 20 13 00 00 00 00 09 F8 20 03 00 00 00 00 F0 FF BD 27 10 00 A2 27 00 00 50 AC 00 00 10 8E 21 88 40 00 EC FF 00 16 04 00 52 AC ?? ?? ?? 0? 00 00 00 00 10 00 DC 8F 3B E8 03 7C D8 8B 7F 8C 3B E8 03 7C DC 8B 70 8C 3B E8 03 7C 23 20 10 00 F0 FF BD 27 DC 8B 64 AC 10 00 A2 27 20 01 04 3C 12 00 84 24 18 00 C2 AF 21 28 00 00 21 30 00 00 21 38 00 00 3B E8 03 7C D8 8B 62 24 E0 FF BD 27 10 00 A2 AF 18 10 02 24 0C 00 00 00 20 00 BD 27 46 00 E0 14 21 90 40 00 4A 00 40 14 00 00 00 00 3B E8 03 7C D8 8B 65 8C 7E 00 BF 10 70 8B 64 24 ?? ?? 02 3C ?? ?? 42 8C 04 00 40 10 00 00 00 00 00 00 46 8C 04 00 C6 24 00 00 46 AC ?? ?? 02 3C ?? ?? 42 24 03 00 40 10 DC 8B 65 AC ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 80 40 00 ?? ?? ?? 0? 21 20 00 02 48 00 43 8C 21 20 00 02 00 00 60 AC 04 00 60 AC ?? ?? ?? 0? 08 00 60 AC 21 80 40 00 ?? ?? ?? 0? 00 00 00 00 F4 FF 02 16 00 00 00 00 ?? ?? ?? 0? 01 00 10 24 ?? ?? 03 3C ?? ?? 62 24 ?? ?? 60 AC 01 00 03 24 04 00 40 AC 08 00 40 AC 0C 00 43 AC 10 00 40 AC 0B 00 20 12 14 00 40 AC 00 00 23 8E 0C 00 79 8C 04 00 20 13 00 00 00 00 09 F8 20 03 00 00 00 00 00 00 23 8E 04 00 31 8E F7 FF 20 16 14 00 70 AC ?? ?? 02 3C ?? ?? 40 AC 21 E8 C0 03 34 00 DF 8F 21 10 40 02 30 00 BE 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 52 AC FF FF 12 24 3B E8 03 7C D8 8B 62 8C 2E 00 5F 14 ?? ?? 04 3C 3B E8 03 7C ?? ?? ?? 0? DC 8B 70 AC E9 FF 20 12 01 00 10 24 ?? ?? ?? 0? 00 00 23 8E 04 00 31 8E E4 FF 20 12 00 00 00 00 00 00 23 8E 08 00 79 8C 05 00 20 13 14 00 63 24 09 F8 20 03 00 00 00 00 00 00 23 8E 14 00 63 24 00 00 62 C0 FF FF 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 EE FF 50 14 00 00 00 00 00 00 22 8E 18 00 43 8C EA FF 60 10 00 00 00 00 14 00 44 8C 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 04 00 31 8E ?? ?? 70 8C 44 FF 00 16 18 00 C7 AF ?? ?? ?? 0? 21 88 00 00 ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 D3 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 8D 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "_IO_vasprintf"
		size = 392
		refs = "0024 malloc 0048 _IO_no_init 0050 _IO_str_jumps 0068 _IO_str_init_static_internal 0090 free 00a0 _IO_vfprintf 00f4 memcpy 0138 realloc"
	strings:
		$1 = { 20 FF BD 27 D8 00 B3 AF 21 98 80 00 64 00 04 24 D4 00 B2 AF D0 00 B1 AF CC 00 B0 AF DC 00 BF AF 21 90 A0 00 ?? ?? ?? 0? 21 88 C0 00 54 00 40 10 21 80 40 00 20 00 A4 27 00 80 05 34 FF FF 06 24 21 38 00 00 10 00 A0 AF ?? ?? ?? 0? 68 00 A0 AF ?? ?? 02 3C ?? ?? 42 24 21 28 00 02 21 38 00 02 20 00 A4 27 64 00 06 24 ?? ?? ?? 0? B8 00 A2 AF 20 00 A3 8F FE FF 02 24 21 30 20 02 24 10 62 00 20 00 A2 AF ?? ?? 02 3C ?? ?? 42 24 C0 00 A2 AF ?? ?? 02 3C ?? ?? 42 24 20 00 A4 27 21 28 40 02 ?? ?? ?? 0? C4 00 A2 AF 2B 00 40 04 21 88 40 00 30 00 A2 8F 34 00 B0 8F 38 00 A3 8F 23 80 02 02 23 10 62 00 01 00 12 26 42 10 02 00 2B 10 42 02 19 00 40 10 3C 00 A4 8F ?? ?? ?? 0? 21 20 40 02 21 00 40 10 00 00 62 AE 3C 00 B2 8F 21 20 40 00 21 30 00 02 ?? ?? ?? 0? 21 28 40 02 ?? ?? ?? 0? 21 20 40 02 00 00 63 8E 10 00 60 10 00 00 00 00 21 80 70 00 00 00 00 A2 21 10 20 02 DC 00 BF 8F D8 00 B3 8F D4 00 B2 8F D0 00 B1 8F CC 00 B0 8F 08 00 E0 03 E0 00 BD 27 ?? ?? ?? 0? 21 28 40 02 21 18 40 00 F2 FF 60 14 00 00 62 AE 3C 00 A3 8F ?? ?? ?? 0? 00 00 63 AE ?? ?? ?? 0? 3C 00 A4 8F ?? ?? ?? 0? 21 10 20 02 3C 00 A4 8F ?? ?? ?? 0? 21 28 40 02 00 00 62 AE ?? ?? ?? 0? 21 18 40 00 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "getservbyport"
		size = 464
		refs = "0008 __gnu_local_gp 00a8 __getservbyport_r 00c8 realloc 00d8 free 00ec __libc_errno 0180 malloc 01c0 __lll_lock_wait_private"
	strings:
		$1 = { B0 FF BD 27 ?? ?? 03 3C ?? ?? 1C 3C ?? ?? 9C 27 38 00 B4 AF 34 00 B3 AF 21 A0 A0 00 21 98 80 00 ?? ?? 64 24 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 00 00 82 C0 01 00 41 24 00 00 81 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 57 00 40 14 00 00 00 00 ?? ?? 12 3C ?? ?? 47 8E ?? ?? 11 3C 40 00 E0 10 ?? ?? 30 8E ?? ?? 16 3C ?? ?? D6 26 22 00 15 24 ?? ?? ?? 0? ?? ?? 17 3C ?? ?? E2 AE 20 00 A2 27 10 00 B0 AF 21 20 60 02 21 28 80 02 21 30 C0 02 ?? ?? ?? 0? 14 00 A2 AF 16 00 55 14 ?? ?? 30 8E ?? ?? 5E 8E 40 80 10 00 21 20 C0 03 21 28 00 02 ?? ?? ?? 0? ?? ?? 30 AE EF FF 40 14 21 38 40 00 ?? ?? ?? 0? 21 20 C0 03 18 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 0C 00 03 24 00 00 43 AC ?? ?? 02 3C ?? ?? 40 AC ?? ?? ?? 0? 20 00 A0 AF ?? ?? 42 8E FC FF 40 10 00 00 00 00 ?? ?? 03 3C ?? ?? 64 24 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 17 00 40 10 ?? ?? 64 24 4C 00 BF 8F 20 00 A2 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 00 04 02 24 00 04 04 24 ?? ?? ?? 0? ?? ?? 22 AE DE FF 40 10 ?? ?? 42 AE 21 38 40 00 ?? ?? ?? 0? 00 04 10 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 4C 00 BF 8F ?? ?? ?? 0? ?? ?? 64 24 ?? ?? ?? 0? ?? ?? 12 3C }
	condition:
		$1
}

rule file_416_0_0 {
	meta:
		name = "getservbyname"
		size = 464
		refs = "0008 __gnu_local_gp 00a8 __getservbyname_r 00c8 realloc 00d8 free 00ec __libc_errno 0180 malloc 01c0 __lll_lock_wait_private"
	strings:
		$1 = { B0 FF BD 27 ?? ?? 03 3C ?? ?? 1C 3C ?? ?? 9C 27 38 00 B4 AF 34 00 B3 AF 21 A0 A0 00 21 98 80 00 ?? ?? 64 24 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 00 00 82 C0 01 00 41 24 00 00 81 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 57 00 40 14 00 00 00 00 ?? ?? 12 3C ?? ?? 47 8E ?? ?? 11 3C 40 00 E0 10 ?? ?? 30 8E ?? ?? 16 3C ?? ?? D6 26 22 00 15 24 ?? ?? ?? 0? ?? ?? 17 3C ?? ?? E2 AE 20 00 A2 27 10 00 B0 AF 21 20 60 02 21 28 80 02 21 30 C0 02 ?? ?? ?? 0? 14 00 A2 AF 16 00 55 14 ?? ?? 30 8E ?? ?? 5E 8E 40 80 10 00 21 20 C0 03 21 28 00 02 ?? ?? ?? 0? ?? ?? 30 AE EF FF 40 14 21 38 40 00 ?? ?? ?? 0? 21 20 C0 03 18 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 0C 00 03 24 00 00 43 AC ?? ?? 02 3C ?? ?? 40 AC ?? ?? ?? 0? 20 00 A0 AF ?? ?? 42 8E FC FF 40 10 00 00 00 00 ?? ?? 03 3C ?? ?? 64 24 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 17 00 40 10 ?? ?? 64 24 4C 00 BF 8F 20 00 A2 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 00 04 02 24 00 04 04 24 ?? ?? ?? 0? ?? ?? 22 AE DE FF 40 10 ?? ?? 42 AE 21 38 40 00 ?? ?? ?? 0? 00 04 10 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 4C 00 BF 8F ?? ?? ?? 0? ?? ?? 64 24 ?? ?? ?? 0? ?? ?? 12 3C }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "_IO_helper_overflow"
		size = 240
		refs = "00a4 __wmemmove 00e0 __woverflow"
	strings:
		$1 = { 5C 00 82 8C D0 FF BD 27 24 00 B2 AF 20 00 B1 AF 10 00 52 8C 21 88 A0 00 0C 00 45 8C 1C 00 B0 AF 2C 00 BF AF 23 90 45 02 83 90 12 00 21 80 80 00 28 00 B3 AF 10 00 40 16 5C 01 84 8C 10 00 43 8C 14 00 44 8C 2B 20 64 00 1E 00 80 10 04 00 64 24 10 00 44 AC 21 10 20 02 00 00 71 AC 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 98 00 82 8C 1C 00 59 8C 09 F8 20 03 21 30 40 02 FF FF 43 24 FE FF 63 2C 15 00 60 10 80 98 02 00 5C 00 03 8E 23 30 42 02 0C 00 64 8C ?? ?? ?? 0? 21 28 93 00 5C 00 03 8E 10 00 64 8C 21 10 60 00 23 98 93 00 DF FF 60 14 10 00 73 AC 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 21 20 00 02 21 28 20 02 1C 00 B0 8F 20 00 B1 8F ?? ?? ?? 0? 30 00 BD 27 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_120_1_0 {
	meta:
		name = "buffered_vfprintf"
		size = 648
		refs = "0028 _IO_fwide 00a0 _IO_vfwprintf 0078 _pthread_cleanup_push_defer 00bc _IO_funlockfile 01b4 _pthread_cleanup_pop_restore 0264 __lll_lock_wait_private"
	strings:
		$1 = { 10 80 BD 27 E8 7F B3 AF E4 7F B2 AF E0 7F B1 AF EC 7F BF AF DC 7F B0 AF 21 90 A0 00 38 FE BD 27 01 00 05 24 21 88 80 00 ?? ?? ?? 0? 21 98 C0 00 01 00 03 24 82 00 43 14 01 00 06 3C 18 00 C6 34 21 80 A6 03 18 80 04 34 6C 80 02 AE AD FB 02 3C 21 18 A4 03 3C 00 27 8E 04 80 42 34 A0 00 68 24 00 80 02 AE ?? ?? 02 3C 21 30 60 02 5C 80 08 AE ?? ?? 42 24 18 00 A8 27 ?? ?? 13 3C 21 28 40 02 21 20 60 00 5C 81 11 AE B0 80 08 AE AC 80 08 AE B4 80 03 AE 48 80 00 AE 3C 80 07 AE 98 80 02 AE ?? ?? ?? 0? ?? ?? 73 26 2B 98 13 00 71 00 60 12 21 90 40 00 18 00 A2 27 70 81 04 34 ?? ?? 05 3C 21 20 44 00 ?? ?? A5 24 ?? ?? ?? 0? 21 30 20 02 00 00 22 8E 00 80 42 30 1E 00 40 14 01 00 02 3C 3B E8 03 7C 48 00 24 8E 70 8B 70 24 08 00 82 8C 14 00 50 10 80 81 02 34 18 00 A6 27 01 00 03 3C 21 18 C3 00 21 28 C2 00 21 10 00 00 80 81 60 AC 00 00 86 C0 06 00 C2 14 00 00 03 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 03 24 0F 00 00 00 4C 00 60 10 00 00 00 00 48 00 22 8E 21 20 40 00 08 00 50 AC 04 00 82 8C 01 00 42 24 04 00 82 AC 01 00 02 3C 18 00 A8 27 21 10 02 01 5C 80 42 8C 0C 00 45 8C 10 00 50 8C 23 80 05 02 83 80 10 00 08 00 00 1A 21 20 20 02 98 00 22 8E 1C 00 59 8C 09 F8 20 03 21 30 00 02 26 10 50 00 FF FF 03 24 0B 90 62 00 00 00 22 8E 00 80 42 30 10 00 40 10 00 00 00 00 05 00 60 12 18 00 A2 27 70 81 04 34 21 20 44 00 ?? ?? ?? 0? 21 28 00 00 C8 01 BD 27 EC 7F BF 8F 21 10 40 02 E8 7F B3 8F E4 7F B2 8F E0 7F B1 8F DC 7F B0 8F 08 00 E0 03 F0 7F BD 27 48 00 24 8E 04 00 82 8C FF FF 42 24 ED FF 40 14 04 00 82 AC 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 E3 FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 C8 01 BD 27 EC 7F BF 8F E8 7F B3 8F E4 7F B2 8F E0 7F B1 8F DC 7F B0 8F FF FF 02 24 08 00 E0 03 F0 7F BD 27 ?? ?? ?? 0? 00 00 A6 AC ?? ?? ?? 0? 48 00 22 8E ?? ?? 02 3C ?? ?? 42 24 70 81 02 AE ?? ?? ?? 0? 74 81 11 AE }
	condition:
		$1
}

rule file_120_2_0 {
	meta:
		name = "_IO_vfwprintf"
		size = 18748
		refs = "0000 __gnu_local_gp 0010 __libc_errno 005c _IO_fwide 00b0 __wcschrnul 00cc _pthread_cleanup_push_defer 00d8 _IO_funlockfile 0144 __lll_lock_wait_private 023c _pthread_cleanup_pop_restore 02ec __printf_function_table 02f8 __printf_modifier_table 0304 __printf_va_arg_table 03bc _nl_current_LC_NUMERIC 05d4 _IO_wpadn 060c __btowc 0824 __strnlen 0874 __mbsrtowcs 09b4 free 0abc __parse_one_specwc 0b20 memmove 0b38 __strerror_r 0c60 __printf_fphex 0f98 __printf_fp 0fb8 $LC3 0fc0 $LC4 0fd0 __assert_fail 0fc4 __PRETTY_FUNCTION__.11408 2250 memset 2290 __printf_arginfo_table 23e4 $LC7 24c8 __libc_fatal 23e0 $LC8 28c0 __wcsnlen 2938 _itowa_lower_digits 2a64 _itowa 3038 __woverflow 33dc $LC5 34e8 _itowa_upper_digits 3510 null 352c __wcslen 353c __readonly_area 3fe4 $LC6 3624 __libc_alloca_cutoff 3634 malloc 364c $LC2 3694 $LC1 3d98 strlen"
	strings:
		$1 = { ?? ?? 1C 3C 00 EF BD 27 ?? ?? 9C 27 E0 10 B2 AF ?? ?? 92 8F 3B E8 03 7C E8 10 B4 AF 21 A0 43 02 00 00 88 8E F8 10 BE AF D8 10 B0 AF 21 F0 A0 03 21 80 A0 00 01 00 05 24 F4 10 B7 AF E4 10 B3 AF DC 10 B1 AF FC 10 BF AF F0 10 B6 AF EC 10 B5 AF 18 00 DC AF 21 B8 80 00 21 98 C0 00 ?? ?? ?? 0? 20 10 C8 AF 21 88 40 00 01 00 02 24 8E 00 22 16 00 00 00 00 00 00 E2 8E 08 00 43 30 46 08 60 14 20 00 42 34 86 00 00 12 21 20 E0 02 ?? ?? ?? 0? 01 00 05 24 84 00 51 14 00 00 00 00 00 00 F1 8E 02 00 22 32 53 00 40 14 21 20 00 02 25 00 05 24 ?? ?? ?? 0? 14 10 D3 AF 21 A0 40 00 00 80 22 32 18 10 D4 AF 27 00 40 14 21 A8 00 00 ?? ?? 02 3C ?? ?? 42 24 BA 0A 40 10 ?? ?? 05 3C F0 0F C4 27 ?? ?? A5 24 ?? ?? ?? 0? 21 30 E0 02 00 00 F1 8E 01 00 15 24 00 80 31 32 1A 00 20 16 00 00 00 00 3B E8 03 7C 48 00 E4 8E 70 8B 71 24 08 00 82 8C 11 00 51 10 00 00 00 00 20 00 C0 AF 00 00 83 C0 06 00 60 14 00 00 02 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 02 24 0F 00 00 00 03 00 40 14 00 00 00 00 ?? ?? ?? 0? 20 00 C3 AF 48 00 E2 8E 21 20 40 00 08 00 51 AC 04 00 82 8C 01 00 42 24 04 00 82 AC 98 00 E2 8E 23 88 90 02 83 88 11 00 1C 00 59 8C 21 20 E0 02 21 28 00 02 09 F8 20 03 21 30 20 02 56 00 22 12 18 00 DC 8F FF FF 11 24 00 00 E2 8E 00 80 42 30 06 00 40 14 00 00 00 00 48 00 E4 8E 04 00 82 8C FF FF 42 24 27 00 40 10 04 00 82 AC 20 00 A0 16 00 00 00 00 21 10 20 02 21 E8 C0 03 FC 10 BF 8F F8 10 BE 8F F4 10 B7 8F F0 10 B6 8F EC 10 B5 8F E8 10 B4 8F E4 10 B3 8F E0 10 B2 8F DC 10 B1 8F D8 10 B0 8F 08 00 E0 03 00 11 BD 27 21 20 E0 02 21 28 00 02 ?? ?? ?? 0? 21 30 60 02 21 E8 C0 03 FC 10 BF 8F F8 10 BE 8F F4 10 B7 8F F0 10 B6 8F EC 10 B5 8F E8 10 B4 8F E4 10 B3 8F E0 10 B2 8F DC 10 B1 8F D8 10 B0 8F 08 00 E0 03 00 11 BD 27 F0 0F C4 27 ?? ?? ?? 0? 21 28 00 00 ?? ?? ?? 0? 21 10 20 02 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 D1 FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 CA FF A0 12 00 00 00 00 ?? ?? ?? 0? F0 0F C4 27 16 00 02 24 00 00 82 AE 21 E8 C0 03 FC 10 DF 8F F8 10 BE 8F F4 10 B7 8F F0 10 B6 8F EC 10 B5 8F E8 10 B4 8F E4 10 B3 8F E0 10 B2 8F DC 10 B1 8F D8 10 B0 8F FF FF 02 24 08 00 E0 03 00 11 BD 27 18 10 C2 8F 00 00 43 8C A9 FF 60 10 ?? ?? 04 3C ?? ?? 83 8C C6 01 60 14 ?? ?? 03 3C ?? ?? 63 8C C3 01 60 14 ?? ?? 03 3C ?? ?? 63 8C C0 01 60 14 FF FF 08 24 58 10 C0 AF 60 10 C0 AF 38 10 C0 AF 30 10 C8 AF 5C 10 C0 AF 04 00 48 8C 04 00 42 24 18 10 C2 AF E0 FF 03 25 28 10 C8 AF FF FF 08 24 4C 10 C8 AF ?? ?? 02 3C 20 00 08 24 5B 00 64 2C 21 B0 00 00 C0 0F C9 27 7C 10 C0 AF 78 10 C0 AF 70 10 C0 AF 74 10 C0 AF 80 10 C0 AF 54 10 C0 AF 68 10 C0 AF 50 10 C0 AF 84 10 C0 AF 64 10 C0 AF 88 10 C0 AF 6C 10 C8 AF 0A 00 80 10 ?? ?? 42 24 ?? ?? 02 3C ?? ?? 42 24 21 18 62 00 00 00 63 90 ?? ?? 02 3C ?? ?? 42 24 80 18 03 00 21 10 62 00 00 00 42 8C 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 18 64 00 B8 10 C3 AF 08 00 40 00 00 00 00 00 18 10 C2 8F 04 00 48 8C 04 00 42 24 18 10 C2 AF E0 FF 02 25 5B 00 43 2C 76 01 60 10 28 10 C8 AF ?? ?? 03 3C ?? ?? 63 24 21 10 43 00 00 00 42 90 ?? ?? 04 3C ?? ?? 84 24 80 10 02 00 21 10 44 00 50 10 C0 AF 00 00 42 8C 08 00 40 00 54 10 C0 AF 18 10 C2 8F 04 00 48 8C 04 00 42 24 18 10 C2 AF E0 FF 02 25 5B 00 43 2C 5C 08 60 10 28 10 C8 AF ?? ?? 03 3C ?? ?? 63 24 21 10 43 00 00 00 42 90 01 00 08 24 50 10 C8 AF 54 10 C8 AF ?? ?? 03 3C 80 10 02 00 ?? ?? 63 24 21 10 43 00 00 00 42 8C 08 00 40 00 00 00 00 00 5C 00 E2 8E 38 0D 40 10 21 20 E0 02 10 00 43 8C 14 00 44 8C 2B 20 64 00 32 0D 80 10 04 00 64 24 10 00 44 AC 25 00 02 24 00 00 62 AC FF 7F 02 3C FF FF 42 34 4E 01 22 12 01 00 23 26 54 10 D3 AF 14 0F C0 16 21 20 C0 02 18 10 D3 8F 25 00 05 24 D0 10 C3 AF 04 00 73 26 21 20 60 02 ?? ?? ?? 0? 18 10 D3 AF D0 10 C3 8F 02 0F 60 04 18 10 C2 AF 98 00 E5 8E 23 30 53 00 21 20 E0 02 1C 00 B9 8C 83 30 06 00 21 28 60 02 09 F8 20 03 D0 10 C3 AF 18 10 C4 8F 18 00 DC 8F 21 B0 00 00 23 28 93 00 83 28 05 00 32 01 45 14 D0 10 C3 8F FF 7F 05 3C FF FF A5 34 23 28 A3 00 2A 28 A2 00 13 07 A0 14 00 00 00 00 00 00 85 8C 2A 01 A0 10 21 88 62 00 38 10 C8 8F 21 10 80 00 54 10 D3 8F 01 00 08 25 ?? ?? ?? 0? 38 10 C8 AF 3C 00 E2 8E 04 00 42 30 05 00 40 10 54 10 C8 8F 60 10 C8 8F 92 0E 00 11 00 00 00 00 54 10 C8 8F AD 10 00 11 84 10 C8 8F 00 00 62 8E C3 1F 11 00 04 00 73 26 04 00 43 AC 54 10 D3 AF 00 00 51 AC ?? ?? ?? 0? 21 18 20 02 50 10 C8 8F 40 00 00 15 64 10 C8 8F 64 10 C3 8F 70 10 C8 8F FF FF 63 24 10 00 00 15 28 10 C3 AF 0E 00 60 18 21 30 60 00 21 20 E0 02 ?? ?? ?? 0? 20 00 05 24 FF FF 03 24 01 01 43 10 FF 7F 03 3C FF FF 63 34 2B 20 23 02 7B 0D 80 10 23 18 71 00 2B 18 62 00 E1 06 60 14 21 88 51 00 00 00 64 92 04 00 73 26 ?? ?? ?? 0? 54 10 D3 AF 5C 00 E3 8E 9B 10 60 10 21 20 E0 02 10 00 64 8C 14 00 65 8C 2B 28 85 00 95 10 A0 10 04 00 85 24 10 00 65 AC FF FF 03 24 EA 00 43 10 00 00 82 AC FF 7F 13 3C FF FF 73 36 E6 00 33 12 70 10 C8 8F 98 FF 00 11 01 00 23 26 28 10 C8 8F 95 FF 00 19 21 20 E0 02 20 00 05 24 21 30 00 01 ?? ?? ?? 0? D0 10 C3 AF FF FF 04 24 DA 00 44 10 D0 10 C3 8F 2B 20 73 00 56 0D 80 10 ?? ?? 04 3C FF FF 64 26 23 20 91 00 2B 20 82 00 86 FF 80 10 21 18 43 00 ?? ?? ?? 0? 00 00 00 00 64 10 C8 8F FF FF 07 25 70 10 C8 8F 12 00 00 15 00 00 00 00 10 00 E0 18 21 30 E0 00 21 20 E0 02 20 00 05 24 ?? ?? ?? 0? C0 10 C7 AF FF FF 03 24 C2 00 43 10 C0 10 C7 8F FF 7F 03 3C FF FF 63 34 2B 20 23 02 3B 0D 80 10 23 18 71 00 2B 18 62 00 A1 06 60 14 21 88 51 00 5C 00 E2 8E 04 00 63 26 54 10 C3 AF B9 0E 40 10 00 00 65 8E 10 00 43 8C 14 00 44 8C 2B 20 64 00 B4 0E 80 10 04 00 64 24 10 00 44 AC FF FF 02 24 AC 00 A2 10 00 00 65 AC FF 7F 13 3C FF FF 73 36 A8 00 33 12 70 10 C8 8F 5A FF 00 11 01 00 23 26 58 FF E0 18 21 20 E0 02 20 00 05 24 ?? ?? ?? 0? 21 30 E0 00 10 00 03 24 50 10 C3 AF 54 10 C8 8F DF 08 00 11 84 10 C8 8F 07 00 73 26 F8 FF 02 24 24 10 62 02 00 00 4A 8C 04 00 45 8C 08 00 42 24 54 10 C2 AF 74 10 C0 AF 78 10 C0 AF 21 58 00 00 4C 10 C8 8F 60 0D 00 05 25 18 45 01 5A 0D 00 15 20 00 08 24 A1 08 60 14 68 10 C3 AF 50 10 C8 8F 08 00 02 24 39 0E 02 11 7C 10 C8 8F 20 00 08 24 21 98 20 01 6C 10 C8 AF 68 10 C3 8F ?? ?? ?? 0? 2B 50 03 00 00 00 69 8E 04 00 63 26 54 10 C3 AF 3F 0B 20 11 50 10 C8 8F E2 08 00 15 4C 10 C8 8F 28 10 C8 8F 53 00 02 24 DE 08 02 11 4C 10 C8 8F FF FF 02 24 00 10 C9 AF 5E 0D 02 11 21 20 20 01 ?? ?? ?? 0? 21 28 00 01 21 30 40 00 80 98 06 00 01 80 02 34 2B 10 62 02 4A 0D 40 10 21 20 60 02 0E 00 62 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 18 00 A9 27 21 50 00 00 21 20 20 01 00 10 C5 27 C0 0F C7 27 CC 10 C9 AF C8 10 CA AF C0 0F C0 AF ?? ?? ?? 0? C4 0F C0 AF 21 98 40 00 FF FF 02 24 CC 10 C9 8F 57 00 62 12 C8 10 CA 8F 64 10 C8 8F 23 38 13 01 D8 0A E0 04 70 10 C8 8F 16 00 00 15 00 00 00 00 14 00 E0 10 21 30 E0 00 21 20 E0 02 20 00 05 24 C0 10 C7 AF CC 10 C9 AF ?? ?? ?? 0? C8 10 CA AF FF FF 03 24 C0 10 C7 8F CC 10 C9 8F 44 00 43 10 C8 10 CA 8F FF 7F 03 3C FF FF 63 34 2B 20 23 02 BD 0C 80 10 23 18 71 00 2B 18 62 00 23 06 60 14 21 88 51 00 B7 0A 20 06 21 28 20 01 98 00 E2 8E 21 20 E0 02 1C 00 59 8C 21 30 60 02 C0 10 C7 AF CC 10 C9 AF 09 F8 20 03 C8 10 CA AF C0 10 C7 8F CC 10 C9 8F 2E 00 62 16 C8 10 CA 8F FF 7F 0B 3C FF FF 6B 35 23 10 71 01 2B 10 53 00 0F 06 40 14 70 10 C8 8F 17 00 00 11 21 18 33 02 15 00 E0 10 21 20 E0 02 20 00 05 24 21 30 E0 00 D0 10 C3 AF CC 10 C9 AF C8 10 CA AF ?? ?? ?? 0? D4 10 CB AF FF FF 04 24 D0 10 C3 8F CC 10 C9 8F C8 10 CA 8F 17 00 44 10 D4 10 CB 8F 2B 20 6B 00 93 0C 80 10 ?? ?? 04 3C 23 20 63 01 2B 20 82 00 F7 05 80 14 21 18 43 00 C2 FE 40 11 21 20 20 01 ?? ?? ?? 0? D0 10 C3 AF ?? ?? ?? 0? D0 10 C3 8F 50 10 C0 AF 54 10 C0 AF 28 10 C8 8F 16 00 00 15 00 00 00 00 3B E8 03 7C 21 10 43 02 16 00 03 24 00 00 43 AC FF FF 11 24 58 10 C8 8F 2F 01 00 15 00 00 00 00 E5 FD C0 12 00 00 00 00 ?? ?? ?? 0? 21 20 C0 02 ?? ?? ?? 0? 00 00 E2 8E FF FF 08 24 58 10 C0 AF 60 10 C0 AF 38 10 C0 AF 21 B0 00 00 30 10 C8 AF 5C 10 C0 AF 78 F9 BD 27 18 00 A8 27 44 10 C8 AF 38 0C C0 16 10 10 C0 AF 30 10 C8 8F FF FF 02 24 A1 06 02 11 00 00 00 00 00 00 96 8E BC 06 C0 12 18 10 D4 AF 34 00 16 24 21 50 00 00 21 48 00 00 80 06 03 24 21 20 80 02 24 10 D5 AF 34 10 D4 AF 2C 10 D1 AF 3C 10 D0 AF 21 88 C0 02 40 10 C0 AF 21 40 40 01 21 B0 60 00 21 A0 00 00 44 10 D5 8F 21 80 20 01 ?? ?? ?? 0? 48 10 D2 AF 21 40 20 02 21 20 40 02 34 00 31 26 21 90 A8 02 21 28 00 02 21 30 40 02 ?? ?? ?? 0? 10 10 C7 27 18 00 52 8E 21 80 02 02 01 00 94 26 00 00 42 8E B5 05 40 10 18 10 D2 AF 2B 10 36 02 F0 FF 40 14 40 10 16 00 F0 FF 03 24 0F 00 42 24 24 10 43 00 08 00 44 24 23 E8 A4 03 18 00 A8 27 21 20 02 01 26 20 A4 02 21 B0 56 00 0A 10 C4 02 21 28 A0 02 21 20 00 01 21 30 20 02 21 A8 00 01 ?? ?? ?? 0? 21 B0 40 00 ?? ?? ?? 0? 21 40 20 02 20 10 C4 8F 20 00 C5 27 ?? ?? ?? 0? A0 0F 06 24 21 48 40 00 54 10 D3 AF ?? ?? ?? 0? 50 10 C0 AF 0A 00 03 24 ?? ?? ?? 0? 50 10 C3 AF 08 00 08 24 ?? ?? ?? 0? 50 10 C8 AF 54 10 C8 8F AA 0D 00 11 84 10 C8 8F F8 FF 02 24 07 00 63 26 24 18 62 00 04 00 62 8C 08 00 68 24 54 10 C8 AF C2 5F 02 00 05 00 60 11 00 00 6A 8C 23 50 0A 00 2B 18 0A 00 23 10 02 00 23 10 43 00 0A 00 03 24 21 28 40 00 ?? ?? ?? 0? 50 10 C3 AF 54 10 C8 8F 21 10 00 00 01 00 03 24 04 00 02 7D 68 10 C8 8F 07 00 67 26 CC 0F C0 AF 44 08 02 7D 50 10 C8 8F 21 20 E0 02 C0 0F C5 27 84 10 02 7D 7C 10 C8 8F 08 10 C6 27 C4 18 02 7D 78 10 C8 8F 04 21 02 7D 70 10 C8 8F 44 29 02 7D 74 10 C8 8F 84 31 02 7D 80 10 C8 8F C4 39 02 7D 4C 10 C8 8F 84 52 62 7C F8 FF 03 24 24 38 E3 00 CC 0F C2 A7 00 00 E2 8C 04 00 E3 8C C0 0F C8 AF 64 10 C8 8F 08 00 E7 24 00 10 C2 AF C4 0F C8 AF 28 10 C8 8F 00 10 C2 27 54 10 C7 AF C8 0F C8 AF 6C 10 C8 8F 04 10 C3 AF 08 10 C2 AF ?? ?? ?? 0? D0 0F C8 AF 5F FF 40 04 FF 7F 03 3C FF FF 63 34 2B 20 23 02 72 0D 80 10 23 18 71 00 2B 20 62 00 0C FE 80 10 21 18 22 02 ?? ?? ?? 0? 00 00 00 00 00 00 6A 8E 04 00 73 26 78 0A 40 11 54 10 D3 AF 78 00 08 24 28 10 C8 AF 10 00 03 24 01 00 08 24 80 10 C0 AF 7C 10 C8 AF 50 10 C3 AF 21 58 00 00 4C 10 C8 8F CA 08 00 05 00 00 00 00 8A 08 00 15 20 00 08 24 88 08 40 15 00 00 00 00 50 10 C3 8F 08 00 02 24 5E 0A 62 10 7C 10 C8 8F 20 00 08 24 21 98 20 01 6C 10 C8 AF 4C 10 C8 8F 23 18 33 01 83 10 03 00 2A 10 48 00 0F 00 40 14 00 00 00 00 0D 00 40 11 00 00 00 00 7C 10 C8 8F 0A 00 00 11 4C 10 C8 8F 50 10 C8 8F 08 00 02 24 06 00 02 15 4C 10 C8 8F 30 00 02 24 FC FF 62 AE FC FF 73 26 23 18 33 01 4C 10 C8 8F 83 18 03 00 68 10 C3 AF 23 18 03 00 21 10 68 00 70 10 C8 8F 00 00 44 28 0B 10 04 00 80 10 C3 AF 13 06 00 15 4C 10 C2 AF 64 10 C8 8F 23 30 62 00 08 00 40 11 21 30 C8 00 7C 10 C8 8F 06 00 00 11 78 10 C8 8F 50 10 C3 8F FE FF C2 24 10 00 64 38 0A 30 44 00 78 10 C8 8F 25 10 0B 01 74 10 C8 8F 25 10 48 00 6C 10 C8 8F 2B 10 02 00 23 30 C2 00 20 00 02 24 DC 04 02 11 00 00 00 00 61 07 60 11 74 10 C8 8F 5C 00 E2 8E DA 0B 40 10 21 20 E0 02 10 00 44 8C 14 00 45 8C 2B 28 85 00 D4 0B A0 10 04 00 85 24 10 00 45 AC 2D 00 02 24 00 00 82 AC FF 7F 02 3C FF FF 42 34 F8 FE 22 12 01 00 31 26 07 00 40 11 4C 10 C3 8F 7C 10 C8 8F 04 00 00 11 10 00 02 24 50 10 C3 8F AB 0A 62 10 4C 10 C3 8F 21 30 C3 00 0E 00 C0 18 21 20 E0 02 ?? ?? ?? 0? 30 00 05 24 FF FF 04 24 E8 FE 44 10 FF 7F 04 3C FF FF 84 34 2B 28 24 02 FB 0C A0 10 00 00 00 00 23 20 91 00 2B 20 82 00 C7 04 80 14 21 88 51 00 73 09 20 06 68 10 C6 8F 98 00 E2 8E 21 20 E0 02 1C 00 59 8C 09 F8 20 03 21 28 60 02 68 10 C8 8F D6 FE 02 15 FF 7F 02 3C FF FF 42 34 23 10 51 00 2A 10 48 00 85 FD 40 10 21 18 28 02 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 20 00 01 ?? ?? ?? 0? 00 00 00 00 0A 00 08 24 3C 10 C8 AF 94 10 C8 8F FA 07 00 11 34 00 02 24 38 10 C8 8F 44 10 C3 8F 02 20 02 71 21 10 83 00 48 0A 40 10 34 10 C8 8F 24 00 42 8C 90 10 C0 AF C0 10 02 00 21 10 02 01 00 00 4A 8C 04 00 45 8C 8C 10 C0 AF 21 58 00 00 24 10 C8 8F 4B 0A 00 05 25 18 45 01 45 0A 00 15 20 00 08 24 2C 07 60 14 94 10 C3 AF 3C 10 C8 8F 08 00 02 24 36 08 02 11 A4 10 C8 8F 20 00 08 24 21 18 20 01 98 10 C8 AF 94 10 C8 8F ?? ?? ?? 0? 2B 50 08 00 08 00 03 24 ?? ?? ?? 0? 3C 10 C3 AF 10 00 08 24 ?? ?? ?? 0? 3C 10 C8 AF 38 10 C8 8F 34 00 05 24 44 10 C2 8F 02 18 05 71 21 28 62 00 91 0A A0 10 34 10 C8 8F 24 00 A2 8C 21 20 E0 02 C0 10 02 00 21 10 02 01 0C 10 C6 27 ?? ?? ?? 0? 0C 10 C2 AF 91 FE 40 04 FF 7F 03 3C FF FF 63 34 2B 20 23 02 54 02 80 14 23 18 71 00 ?? ?? 04 3C ?? ?? 84 24 ?? ?? 05 3C ?? ?? 07 3C ?? ?? A5 24 E3 07 06 24 ?? ?? ?? 0? ?? ?? E7 24 38 10 C8 8F 34 00 05 24 44 10 C2 8F 02 18 05 71 21 28 62 00 1E 0B A0 10 34 10 C8 8F 24 00 A2 8C 21 20 E0 02 C0 10 02 00 }
	condition:
		$1
}

rule file_120_3_0 {
	meta:
		name = "read_int"
		size = 116
	strings:
		$1 = { 00 00 83 8C CC 0C 08 3C FF 7F 0A 3C 00 00 62 8C CD CC 08 35 04 00 63 24 D0 FF 42 24 0A 00 0B 24 FF FF 4A 35 00 00 65 8C D0 FF A5 24 0A 00 A6 2C 0E 00 C0 10 2A 38 48 00 0A 00 40 04 00 00 00 00 07 00 E0 10 23 48 45 01 02 30 4B 70 FF FF 02 24 2A 48 26 01 21 28 C5 00 ?? ?? ?? 0? 0A 10 A9 00 FF FF 02 24 ?? ?? ?? 0? 04 00 63 24 08 00 E0 03 00 00 83 AC }
	condition:
		$1
}

rule file_120_4_0 {
	meta:
		name = "group_number"
		size = 292
		refs = "0064 mempcpy"
	strings:
		$1 = { C8 FF BD 27 30 00 BE AF 28 00 B2 AF 34 00 BF AF 2C 00 B3 AF 24 00 B1 AF 20 00 B0 AF 00 00 D0 80 21 F0 A0 03 21 90 C0 00 FF FF 03 26 FF 00 63 30 7E 00 63 2C 21 40 80 00 31 00 60 10 21 10 80 00 23 30 A4 00 0E 00 C2 24 C2 10 02 00 C0 10 02 00 23 E8 A2 03 10 00 B1 27 21 98 A0 00 21 20 20 02 21 28 00 01 ?? ?? ?? 0? 18 00 C7 AF 18 00 C7 8F 01 00 52 26 21 28 60 02 7F 00 06 24 2B 18 22 02 FC FF 42 24 FF FF 10 26 1C 00 60 10 2B 40 22 02 00 00 44 8C FC FF A3 24 16 00 00 16 FC FF A4 AC 14 00 00 11 00 00 00 00 F8 FF A7 AC 00 00 50 82 03 00 06 12 F8 FF A3 24 09 00 01 06 00 00 00 00 FC FF 42 24 00 00 45 8C FC FF 63 24 2B 20 22 02 FB FF 80 14 00 00 65 AC ?? ?? ?? 0? 21 10 60 00 03 00 00 12 00 00 00 00 ?? ?? ?? 0? 01 00 52 26 FF FF 50 82 ?? ?? ?? 0? 21 28 60 00 21 10 A0 00 21 E8 C0 03 34 00 BF 8F 30 00 BE 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_120_5_0 {
	meta:
		name = "_i18n_number_rewrite"
		size = 452
		refs = "0004 __gnu_local_gp 0010 $LC0 004c __wctrans 005c __towctrans 008c __libc_alloca_cutoff 00b8 malloc 00d0 mempcpy 00e8 _nl_current_LC_CTYPE 017c free"
	strings:
		$1 = { B8 FF BD 27 ?? ?? 1C 3C 3C 00 B7 AF 21 B8 80 00 ?? ?? 04 3C ?? ?? 9C 27 40 00 BE AF ?? ?? 84 24 21 F0 A0 03 44 00 BF AF 10 00 DC AF 38 00 B6 AF 30 00 B4 AF 21 B0 C0 00 2C 00 B3 AF 24 00 B1 AF 21 98 A0 00 20 00 B0 AF 34 00 B5 AF ?? ?? ?? 0? 28 00 B2 AF 21 A0 40 00 2E 00 04 24 ?? ?? ?? 0? 21 28 40 00 2C 00 04 24 21 28 80 02 21 80 40 00 ?? ?? ?? 0? 23 98 77 02 01 80 03 34 2B 18 63 02 21 88 40 00 04 00 60 14 01 00 02 24 ?? ?? ?? 0? 21 20 60 02 2B 10 02 00 07 00 40 10 21 A8 40 00 0E 00 62 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 ?? ?? ?? 0? 10 00 B2 27 ?? ?? ?? 0? 21 20 60 02 32 00 40 10 21 90 40 00 21 20 40 02 21 28 E0 02 ?? ?? ?? 0? 21 30 60 02 10 00 DC 8F 3B E8 03 7C 21 20 60 00 21 18 40 00 ?? ?? 82 8F FC FF C6 26 FD FF 09 24 21 20 44 00 00 00 84 8C 2C 00 05 24 FC FF 63 24 2B 38 72 00 1A 00 E0 14 04 00 C2 24 00 00 67 8C D0 FF E8 24 0A 00 08 2D 08 00 00 11 00 00 00 00 00 00 82 8C 0B 00 E7 24 80 38 07 00 21 38 47 00 04 00 E2 8C ?? ?? ?? 0? 00 00 C2 AC 04 00 80 12 00 00 00 00 24 10 E9 00 03 00 45 10 00 00 00 00 ?? ?? ?? 0? 00 00 C7 AC 2E 00 E2 38 21 38 00 02 0B 38 22 02 00 00 C7 AC ?? ?? ?? 0? FC FF C6 24 06 00 A0 16 21 20 40 02 ?? ?? ?? 0? 18 00 C2 AF ?? ?? ?? 0? 18 00 C2 8F 21 10 E0 02 21 E8 C0 03 44 00 DF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "__sched_setparam"
		size = 28
	strings:
		$1 = { 3E 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "__vswscanf"
		size = 144
		refs = "0000 _IO_wstr_jumps 003c _IO_no_init 0048 _IO_fwide 005c _IO_wstr_init_static 0070 _IO_vfwscanf"
	strings:
		$1 = { ?? ?? 02 3C 68 FE BD 27 ?? ?? 42 24 20 00 A7 27 90 01 B2 AF 8C 01 B1 AF 88 01 B0 AF 21 90 80 00 21 88 A0 00 21 80 C0 00 E0 00 A4 27 21 30 00 00 10 00 A2 AF 00 80 05 34 94 01 BF AF ?? ?? ?? 0? 28 01 A0 AF E0 00 A4 27 ?? ?? ?? 0? 01 00 05 24 E0 00 A4 27 21 28 40 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 E0 00 A4 27 21 28 20 02 21 30 00 02 ?? ?? ?? 0? 21 38 00 00 94 01 BF 8F 90 01 B2 8F 8C 01 B1 8F 88 01 B0 8F 08 00 E0 03 98 01 BD 27 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "insque"
		size = 48
	strings:
		$1 = { 08 00 A0 10 00 00 00 00 00 00 A2 8C 02 00 40 10 00 00 A4 AC 04 00 44 AC 00 00 82 AC 08 00 E0 03 04 00 85 AC 00 00 80 AC 08 00 E0 03 04 00 80 AC }
	condition:
		$1
}

rule file_123_1_0 {
	meta:
		name = "remque"
		size = 36
	strings:
		$1 = { 00 00 83 8C 02 00 60 10 04 00 82 8C 04 00 62 AC 02 00 40 10 00 00 00 00 00 00 43 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "strcat"
		size = 60
	strings:
		$1 = { 21 10 80 00 ?? ?? ?? 0? 21 18 80 00 21 18 C0 00 00 00 67 80 FD FF E0 14 01 00 66 24 FF FF 63 24 01 00 A5 24 FF FF A6 80 01 00 63 24 FC FF C0 14 00 00 66 A0 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "__libc_tcdrain"
		size = 188
		refs = "0000 __gnu_local_gp 0044 __libc_errno 0064 __libc_enable_asynccancel 00ac __libc_disable_asynccancel"
	strings:
		$1 = { ?? ?? 1C 3C D8 FF BD 27 ?? ?? 9C 27 24 00 BF AF 20 00 B0 AF 10 00 BC AF 3B E8 03 7C 70 8B 62 8C 10 00 40 14 05 54 05 24 01 00 06 24 D6 0F 02 24 0C 00 00 00 08 00 E0 10 24 00 BF 8F 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC FF FF 02 24 24 00 BF 8F 20 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 18 00 A4 AF 21 F8 40 00 10 00 BC 8F 18 00 A4 8F 05 54 05 24 01 00 06 24 D6 0F 02 24 0C 00 00 00 07 00 E0 10 21 80 40 00 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F FF FF 10 24 21 20 64 00 00 00 82 AC 21 20 E0 03 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 10 00 02 }
	condition:
		$1
}

rule file_72_0_2 {
	meta:
		name = "__libc_tcdrain"
		size = 188
		refs = "0000 __gnu_local_gp 0044 errno 0064 __pthread_enable_asynccancel 00ac __pthread_disable_asynccancel"
	strings:
		$1 = { ?? ?? 1C 3C D8 FF BD 27 ?? ?? 9C 27 24 00 BF AF 20 00 B0 AF 10 00 BC AF 3B E8 03 7C 70 8B 62 8C 10 00 40 14 05 54 05 24 01 00 06 24 D6 0F 02 24 0C 00 00 00 08 00 E0 10 24 00 BF 8F 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC FF FF 02 24 24 00 BF 8F 20 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 18 00 A4 AF 21 F8 40 00 10 00 BC 8F 18 00 A4 8F 05 54 05 24 01 00 06 24 D6 0F 02 24 0C 00 00 00 07 00 E0 10 21 80 40 00 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F FF FF 10 24 21 20 64 00 00 00 82 AC 21 20 E0 03 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 10 00 02 }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "__sched_rr_get_interval"
		size = 28
	strings:
		$1 = { 45 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "fileno"
		size = 72
		refs = "0004 __gnu_local_gp 0030 __libc_errno"
	strings:
		$1 = { 00 00 82 8C ?? ?? 1C 3C 00 20 42 30 06 00 40 10 ?? ?? 9C 27 38 00 82 8C 03 00 40 04 00 00 00 00 08 00 E0 03 00 00 00 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 09 00 03 24 00 00 43 AC 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "__default_morecore"
		size = 36
		refs = "0008 __sbrk"
	strings:
		$1 = { E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 1C 00 BF 8F 27 18 02 00 0A 10 03 00 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "setsgent"
		size = 280
		refs = "0004 __gnu_local_gp 0050 $LC0 0054 __nss_gshadow_lookup2 007c __nss_setent 008c __libc_errno 00e4 __lll_lock_wait_private"
	strings:
		$1 = { C8 FF BD 27 ?? ?? 1C 3C 28 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 20 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 28 00 40 14 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C ?? ?? 07 3C 10 00 A2 AF 14 00 A0 AF 18 00 A0 AF 1C 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? E7 24 20 00 BC 8F 3B E8 03 7C ?? ?? 91 8F 21 10 23 02 00 00 52 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 0E 00 40 10 ?? ?? 04 26 34 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 32 AE 28 00 B0 8F 30 00 B2 8F 2C 00 B1 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? ?? ?? 02 3C 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F }
	condition:
		$1
}

rule file_1071_0_0 {
	meta:
		name = "setaliasent"
		size = 280
		refs = "0004 __gnu_local_gp 0050 $LC0 0054 __nss_aliases_lookup2 007c __nss_setent 008c __libc_errno 00e4 __lll_lock_wait_private"
	strings:
		$1 = { C8 FF BD 27 ?? ?? 1C 3C 28 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 20 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 28 00 40 14 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C ?? ?? 07 3C 10 00 A2 AF 14 00 A0 AF 18 00 A0 AF 1C 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? E7 24 20 00 BC 8F 3B E8 03 7C ?? ?? 91 8F 21 10 23 02 00 00 52 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 0E 00 40 10 ?? ?? 04 26 34 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 32 AE 28 00 B0 8F 30 00 B2 8F 2C 00 B1 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? ?? ?? 02 3C 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F }
	condition:
		$1
}

rule file_1120_0_0 {
	meta:
		name = "setgrent"
		size = 280
		refs = "0004 __gnu_local_gp 0050 $LC0 0054 __nss_group_lookup2 007c __nss_setent 008c __libc_errno 00e4 __lll_lock_wait_private"
	strings:
		$1 = { C8 FF BD 27 ?? ?? 1C 3C 28 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 20 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 28 00 40 14 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C ?? ?? 07 3C 10 00 A2 AF 14 00 A0 AF 18 00 A0 AF 1C 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? E7 24 20 00 BC 8F 3B E8 03 7C ?? ?? 91 8F 21 10 23 02 00 00 52 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 0E 00 40 10 ?? ?? 04 26 34 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 32 AE 28 00 B0 8F 30 00 B2 8F 2C 00 B1 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? ?? ?? 02 3C 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F }
	condition:
		$1
}

rule file_729_0_0 {
	meta:
		name = "setpwent"
		size = 280
		refs = "0004 __gnu_local_gp 0050 $LC0 0054 __nss_passwd_lookup2 007c __nss_setent 008c __libc_errno 00e4 __lll_lock_wait_private"
	strings:
		$1 = { C8 FF BD 27 ?? ?? 1C 3C 28 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 20 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 28 00 40 14 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C ?? ?? 07 3C 10 00 A2 AF 14 00 A0 AF 18 00 A0 AF 1C 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? E7 24 20 00 BC 8F 3B E8 03 7C ?? ?? 91 8F 21 10 23 02 00 00 52 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 0E 00 40 10 ?? ?? 04 26 34 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 32 AE 28 00 B0 8F 30 00 B2 8F 2C 00 B1 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? ?? ?? 02 3C 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F }
	condition:
		$1
}

rule file_534_0_0 {
	meta:
		name = "setspent"
		size = 280
		refs = "0004 __gnu_local_gp 0050 $LC0 0054 __nss_shadow_lookup2 007c __nss_setent 008c __libc_errno 00e4 __lll_lock_wait_private"
	strings:
		$1 = { C8 FF BD 27 ?? ?? 1C 3C 28 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 20 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 28 00 40 14 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C ?? ?? 07 3C 10 00 A2 AF 14 00 A0 AF 18 00 A0 AF 1C 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? E7 24 20 00 BC 8F 3B E8 03 7C ?? ?? 91 8F 21 10 23 02 00 00 52 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 0E 00 40 10 ?? ?? 04 26 34 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 32 AE 28 00 B0 8F 30 00 B2 8F 2C 00 B1 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? ?? ?? 02 3C 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F }
	condition:
		$1
}

rule file_129_1_0 {
	meta:
		name = "endsgent"
		size = 288
		refs = "0014 __gnu_local_gp 0060 $LC1 0064 __nss_gshadow_lookup2 0080 __nss_endent 0090 __libc_errno 00ec __lll_lock_wait_private"
	strings:
		$1 = { ?? ?? 07 3C ?? ?? E2 8C 36 00 40 10 00 00 00 00 C8 FF BD 27 ?? ?? 1C 3C 28 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 26 00 40 14 ?? ?? 04 26 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C 10 00 A2 AF 14 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? E7 24 18 00 BC 8F 3B E8 03 7C ?? ?? 91 8F 21 10 23 02 00 00 52 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 0F 00 40 10 ?? ?? 04 26 3B E8 03 7C 21 88 23 02 00 00 32 AE 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 38 00 BD 27 08 00 E0 03 00 00 00 00 ?? ?? ?? 0? 20 00 A7 AF ?? ?? ?? 0? 20 00 A7 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_1071_1_0 {
	meta:
		name = "endaliasent"
		size = 288
		refs = "0014 __gnu_local_gp 0060 $LC1 0064 __nss_aliases_lookup2 0080 __nss_endent 0090 __libc_errno 00ec __lll_lock_wait_private"
	strings:
		$1 = { ?? ?? 07 3C ?? ?? E2 8C 36 00 40 10 00 00 00 00 C8 FF BD 27 ?? ?? 1C 3C 28 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 26 00 40 14 ?? ?? 04 26 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C 10 00 A2 AF 14 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? E7 24 18 00 BC 8F 3B E8 03 7C ?? ?? 91 8F 21 10 23 02 00 00 52 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 0F 00 40 10 ?? ?? 04 26 3B E8 03 7C 21 88 23 02 00 00 32 AE 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 38 00 BD 27 08 00 E0 03 00 00 00 00 ?? ?? ?? 0? 20 00 A7 AF ?? ?? ?? 0? 20 00 A7 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_1120_1_0 {
	meta:
		name = "endgrent"
		size = 288
		refs = "0014 __gnu_local_gp 0060 $LC1 0064 __nss_group_lookup2 0080 __nss_endent 0090 __libc_errno 00ec __lll_lock_wait_private"
	strings:
		$1 = { ?? ?? 07 3C ?? ?? E2 8C 36 00 40 10 00 00 00 00 C8 FF BD 27 ?? ?? 1C 3C 28 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 26 00 40 14 ?? ?? 04 26 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C 10 00 A2 AF 14 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? E7 24 18 00 BC 8F 3B E8 03 7C ?? ?? 91 8F 21 10 23 02 00 00 52 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 0F 00 40 10 ?? ?? 04 26 3B E8 03 7C 21 88 23 02 00 00 32 AE 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 38 00 BD 27 08 00 E0 03 00 00 00 00 ?? ?? ?? 0? 20 00 A7 AF ?? ?? ?? 0? 20 00 A7 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_1018_1_0 {
	meta:
		name = "endprotoent"
		size = 288
		refs = "0014 __gnu_local_gp 0060 $LC1 0064 __nss_protocols_lookup2 0080 __nss_endent 0090 __libc_errno 00ec __lll_lock_wait_private"
	strings:
		$1 = { ?? ?? 07 3C ?? ?? E2 8C 36 00 40 10 00 00 00 00 C8 FF BD 27 ?? ?? 1C 3C 28 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 26 00 40 14 ?? ?? 04 26 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C 10 00 A2 AF 14 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? E7 24 18 00 BC 8F 3B E8 03 7C ?? ?? 91 8F 21 10 23 02 00 00 52 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 0F 00 40 10 ?? ?? 04 26 3B E8 03 7C 21 88 23 02 00 00 32 AE 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 38 00 BD 27 08 00 E0 03 00 00 00 00 ?? ?? ?? 0? 20 00 A7 AF ?? ?? ?? 0? 20 00 A7 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_729_1_0 {
	meta:
		name = "endpwent"
		size = 288
		refs = "0014 __gnu_local_gp 0060 $LC1 0064 __nss_passwd_lookup2 0080 __nss_endent 0090 __libc_errno 00ec __lll_lock_wait_private"
	strings:
		$1 = { ?? ?? 07 3C ?? ?? E2 8C 36 00 40 10 00 00 00 00 C8 FF BD 27 ?? ?? 1C 3C 28 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 26 00 40 14 ?? ?? 04 26 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C 10 00 A2 AF 14 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? E7 24 18 00 BC 8F 3B E8 03 7C ?? ?? 91 8F 21 10 23 02 00 00 52 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 0F 00 40 10 ?? ?? 04 26 3B E8 03 7C 21 88 23 02 00 00 32 AE 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 38 00 BD 27 08 00 E0 03 00 00 00 00 ?? ?? ?? 0? 20 00 A7 AF ?? ?? ?? 0? 20 00 A7 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_368_1_0 {
	meta:
		name = "endrpcent"
		size = 288
		refs = "0014 __gnu_local_gp 0060 $LC1 0064 __nss_rpc_lookup2 0080 __nss_endent 0090 __libc_errno 00ec __lll_lock_wait_private"
	strings:
		$1 = { ?? ?? 07 3C ?? ?? E2 8C 36 00 40 10 00 00 00 00 C8 FF BD 27 ?? ?? 1C 3C 28 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 26 00 40 14 ?? ?? 04 26 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C 10 00 A2 AF 14 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? E7 24 18 00 BC 8F 3B E8 03 7C ?? ?? 91 8F 21 10 23 02 00 00 52 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 0F 00 40 10 ?? ?? 04 26 3B E8 03 7C 21 88 23 02 00 00 32 AE 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 38 00 BD 27 08 00 E0 03 00 00 00 00 ?? ?? ?? 0? 20 00 A7 AF ?? ?? ?? 0? 20 00 A7 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_1386_1_0 {
	meta:
		name = "endservent"
		size = 288
		refs = "0014 __gnu_local_gp 0060 $LC1 0064 __nss_services_lookup2 0080 __nss_endent 0090 __libc_errno 00ec __lll_lock_wait_private"
	strings:
		$1 = { ?? ?? 07 3C ?? ?? E2 8C 36 00 40 10 00 00 00 00 C8 FF BD 27 ?? ?? 1C 3C 28 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 26 00 40 14 ?? ?? 04 26 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C 10 00 A2 AF 14 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? E7 24 18 00 BC 8F 3B E8 03 7C ?? ?? 91 8F 21 10 23 02 00 00 52 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 0F 00 40 10 ?? ?? 04 26 3B E8 03 7C 21 88 23 02 00 00 32 AE 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 38 00 BD 27 08 00 E0 03 00 00 00 00 ?? ?? ?? 0? 20 00 A7 AF ?? ?? ?? 0? 20 00 A7 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_534_1_0 {
	meta:
		name = "endspent"
		size = 288
		refs = "0014 __gnu_local_gp 0060 $LC1 0064 __nss_shadow_lookup2 0080 __nss_endent 0090 __libc_errno 00ec __lll_lock_wait_private"
	strings:
		$1 = { ?? ?? 07 3C ?? ?? E2 8C 36 00 40 10 00 00 00 00 C8 FF BD 27 ?? ?? 1C 3C 28 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 26 00 40 14 ?? ?? 04 26 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C 10 00 A2 AF 14 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? E7 24 18 00 BC 8F 3B E8 03 7C ?? ?? 91 8F 21 10 23 02 00 00 52 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 0F 00 40 10 ?? ?? 04 26 3B E8 03 7C 21 88 23 02 00 00 32 AE 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 38 00 BD 27 08 00 E0 03 00 00 00 00 ?? ?? ?? 0? 20 00 A7 AF ?? ?? ?? 0? 20 00 A7 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_129_2_0 {
	meta:
		name = "__getsgent_r"
		size = 344
		refs = "0004 __gnu_local_gp 0070 $LC2 0074 $LC0 0078 __nss_gshadow_lookup2 00a0 __nss_getent_r 00b4 __libc_errno 011c __lll_lock_wait_private"
	strings:
		$1 = { 98 FF BD 27 ?? ?? 1C 3C 54 00 B0 AF ?? ?? 10 3C 58 00 B1 AF ?? ?? 9C 27 21 88 80 00 ?? ?? 03 26 64 00 BF AF 60 00 B3 AF 5C 00 B2 AF 38 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 32 00 40 14 ?? ?? 04 26 ?? ?? 02 3C ?? ?? 42 24 10 00 A2 AF ?? ?? 02 3C 24 00 A5 AF 28 00 A6 AF 2C 00 A7 AF ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C ?? ?? 07 3C 20 00 B1 AF 14 00 A2 AF 18 00 A0 AF 1C 00 A0 AF 30 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? E7 24 38 00 BC 8F 3B E8 03 7C 21 90 40 00 ?? ?? 91 8F 21 20 23 02 00 00 93 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 14 00 40 10 ?? ?? 04 26 64 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 33 AE 21 10 40 02 60 00 B3 8F 5C 00 B2 8F 58 00 B1 8F 54 00 B0 8F 08 00 E0 03 68 00 BD 27 40 00 A5 AF 44 00 A6 AF ?? ?? ?? 0? 48 00 A7 AF 48 00 A7 8F 44 00 A6 8F ?? ?? ?? 0? 40 00 A5 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 64 00 BF 8F }
	condition:
		$1
}

rule file_1071_2_0 {
	meta:
		name = "__getaliasent_r"
		size = 344
		refs = "0004 __gnu_local_gp 0070 $LC2 0074 $LC0 0078 __nss_aliases_lookup2 00a0 __nss_getent_r 00b4 __libc_errno 011c __lll_lock_wait_private"
	strings:
		$1 = { 98 FF BD 27 ?? ?? 1C 3C 54 00 B0 AF ?? ?? 10 3C 58 00 B1 AF ?? ?? 9C 27 21 88 80 00 ?? ?? 03 26 64 00 BF AF 60 00 B3 AF 5C 00 B2 AF 38 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 32 00 40 14 ?? ?? 04 26 ?? ?? 02 3C ?? ?? 42 24 10 00 A2 AF ?? ?? 02 3C 24 00 A5 AF 28 00 A6 AF 2C 00 A7 AF ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C ?? ?? 07 3C 20 00 B1 AF 14 00 A2 AF 18 00 A0 AF 1C 00 A0 AF 30 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? E7 24 38 00 BC 8F 3B E8 03 7C 21 90 40 00 ?? ?? 91 8F 21 20 23 02 00 00 93 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 14 00 40 10 ?? ?? 04 26 64 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 33 AE 21 10 40 02 60 00 B3 8F 5C 00 B2 8F 58 00 B1 8F 54 00 B0 8F 08 00 E0 03 68 00 BD 27 40 00 A5 AF 44 00 A6 AF ?? ?? ?? 0? 48 00 A7 AF 48 00 A7 8F 44 00 A6 8F ?? ?? ?? 0? 40 00 A5 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 64 00 BF 8F }
	condition:
		$1
}

rule file_1120_2_0 {
	meta:
		name = "__getgrent_r"
		size = 344
		refs = "0004 __gnu_local_gp 0070 $LC2 0074 $LC0 0078 __nss_group_lookup2 00a0 __nss_getent_r 00b4 __libc_errno 011c __lll_lock_wait_private"
	strings:
		$1 = { 98 FF BD 27 ?? ?? 1C 3C 54 00 B0 AF ?? ?? 10 3C 58 00 B1 AF ?? ?? 9C 27 21 88 80 00 ?? ?? 03 26 64 00 BF AF 60 00 B3 AF 5C 00 B2 AF 38 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 32 00 40 14 ?? ?? 04 26 ?? ?? 02 3C ?? ?? 42 24 10 00 A2 AF ?? ?? 02 3C 24 00 A5 AF 28 00 A6 AF 2C 00 A7 AF ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C ?? ?? 07 3C 20 00 B1 AF 14 00 A2 AF 18 00 A0 AF 1C 00 A0 AF 30 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? E7 24 38 00 BC 8F 3B E8 03 7C 21 90 40 00 ?? ?? 91 8F 21 20 23 02 00 00 93 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 14 00 40 10 ?? ?? 04 26 64 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 33 AE 21 10 40 02 60 00 B3 8F 5C 00 B2 8F 58 00 B1 8F 54 00 B0 8F 08 00 E0 03 68 00 BD 27 40 00 A5 AF 44 00 A6 AF ?? ?? ?? 0? 48 00 A7 AF 48 00 A7 8F 44 00 A6 8F ?? ?? ?? 0? 40 00 A5 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 64 00 BF 8F }
	condition:
		$1
}

rule file_729_2_0 {
	meta:
		name = "__getpwent_r"
		size = 344
		refs = "0004 __gnu_local_gp 0070 $LC2 0074 $LC0 0078 __nss_passwd_lookup2 00a0 __nss_getent_r 00b4 __libc_errno 011c __lll_lock_wait_private"
	strings:
		$1 = { 98 FF BD 27 ?? ?? 1C 3C 54 00 B0 AF ?? ?? 10 3C 58 00 B1 AF ?? ?? 9C 27 21 88 80 00 ?? ?? 03 26 64 00 BF AF 60 00 B3 AF 5C 00 B2 AF 38 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 32 00 40 14 ?? ?? 04 26 ?? ?? 02 3C ?? ?? 42 24 10 00 A2 AF ?? ?? 02 3C 24 00 A5 AF 28 00 A6 AF 2C 00 A7 AF ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C ?? ?? 07 3C 20 00 B1 AF 14 00 A2 AF 18 00 A0 AF 1C 00 A0 AF 30 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? E7 24 38 00 BC 8F 3B E8 03 7C 21 90 40 00 ?? ?? 91 8F 21 20 23 02 00 00 93 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 14 00 40 10 ?? ?? 04 26 64 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 33 AE 21 10 40 02 60 00 B3 8F 5C 00 B2 8F 58 00 B1 8F 54 00 B0 8F 08 00 E0 03 68 00 BD 27 40 00 A5 AF 44 00 A6 AF ?? ?? ?? 0? 48 00 A7 AF 48 00 A7 8F 44 00 A6 8F ?? ?? ?? 0? 40 00 A5 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 64 00 BF 8F }
	condition:
		$1
}

rule file_534_2_0 {
	meta:
		name = "__getspent_r"
		size = 344
		refs = "0004 __gnu_local_gp 0070 $LC2 0074 $LC0 0078 __nss_shadow_lookup2 00a0 __nss_getent_r 00b4 __libc_errno 011c __lll_lock_wait_private"
	strings:
		$1 = { 98 FF BD 27 ?? ?? 1C 3C 54 00 B0 AF ?? ?? 10 3C 58 00 B1 AF ?? ?? 9C 27 21 88 80 00 ?? ?? 03 26 64 00 BF AF 60 00 B3 AF 5C 00 B2 AF 38 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 32 00 40 14 ?? ?? 04 26 ?? ?? 02 3C ?? ?? 42 24 10 00 A2 AF ?? ?? 02 3C 24 00 A5 AF 28 00 A6 AF 2C 00 A7 AF ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C ?? ?? 07 3C 20 00 B1 AF 14 00 A2 AF 18 00 A0 AF 1C 00 A0 AF 30 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? E7 24 38 00 BC 8F 3B E8 03 7C 21 90 40 00 ?? ?? 91 8F 21 20 23 02 00 00 93 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 14 00 40 10 ?? ?? 04 26 64 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 33 AE 21 10 40 02 60 00 B3 8F 5C 00 B2 8F 58 00 B1 8F 54 00 B0 8F 08 00 E0 03 68 00 BD 27 40 00 A5 AF 44 00 A6 AF ?? ?? ?? 0? 48 00 A7 AF 48 00 A7 8F 44 00 A6 8F ?? ?? ?? 0? 40 00 A5 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 64 00 BF 8F }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "__gethostname"
		size = 176
		refs = "0004 __gnu_local_gp 002c uname 003c strlen 0058 memcpy 0098 __libc_errno"
	strings:
		$1 = { 48 FE BD 27 ?? ?? 1C 3C ?? ?? 9C 27 B0 01 B3 AF 21 98 80 00 18 00 A4 27 A8 01 B1 AF A4 01 B0 AF B4 01 BF AF AC 01 B2 AF 10 00 BC AF ?? ?? ?? 0? 21 88 A0 00 14 00 40 14 21 80 40 00 ?? ?? ?? 0? 59 00 A4 27 01 00 42 24 2B 90 22 02 21 30 20 02 21 20 60 02 59 00 A5 27 ?? ?? ?? 0? 0A 30 52 00 0B 00 40 16 10 00 BC 8F B4 01 BF 8F 21 10 00 02 B0 01 B3 8F AC 01 B2 8F A8 01 B1 8F A4 01 B0 8F 08 00 E0 03 B8 01 BD 27 ?? ?? ?? 0? FF FF 10 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F FF FF 10 24 21 10 62 00 4E 00 03 24 ?? ?? ?? 0? 00 00 43 AC }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "posix_spawnattr_setsigdefault"
		size = 92
	strings:
		$1 = { 08 00 84 24 80 00 A8 24 03 00 A7 88 07 00 A6 88 0B 00 A3 88 0F 00 A2 88 00 00 A7 98 04 00 A6 98 08 00 A3 98 0C 00 A2 98 03 00 87 A8 00 00 87 B8 07 00 86 A8 04 00 86 B8 0B 00 83 A8 08 00 83 B8 10 00 A5 24 0F 00 82 A8 0C 00 82 B8 EE FF A8 14 10 00 84 24 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "fchflags"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_errno"
	strings:
		$1 = { ?? ?? 1C 3C 3B E8 03 7C ?? ?? 9C 27 21 10 60 00 ?? ?? 83 8F 05 00 80 04 21 10 62 00 59 00 03 24 00 00 43 AC 08 00 E0 03 FF FF 02 24 16 00 03 24 00 00 43 AC 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "__socket"
		size = 28
	strings:
		$1 = { 57 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_134_1_0 {
	meta:
		name = "open_translit"
		size = 288
		refs = "0020 __libc_dlopen_mode 0038 __libc_dlsym 003c $LC0 0064 __libc_dlclose 0090 $LC1 00a8 $LC2 00c8 $LC3"
	strings:
		$1 = { D8 FF BD 27 18 00 B0 AF 21 80 80 00 20 00 84 8C 00 80 05 3C 01 00 A5 24 24 00 BF AF 20 00 B2 AF ?? ?? ?? 0? 1C 00 B1 AF 35 00 40 10 24 00 02 AE ?? ?? 12 3C 21 20 40 00 ?? ?? ?? 0? ?? ?? 45 26 07 00 40 10 08 00 05 26 00 00 04 8E 21 C8 40 00 09 F8 20 03 0C 00 06 26 0C 00 40 10 21 88 40 00 24 00 04 8E ?? ?? ?? 0? 01 00 11 24 24 00 BF 8F 24 00 00 AE 21 10 20 02 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 24 00 04 8E ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 F0 FF 40 10 10 00 02 AE 24 00 04 8E ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 24 00 04 8E ?? ?? 45 26 ?? ?? ?? 0? 18 00 02 AE 24 00 04 8E ?? ?? 05 3C 14 00 02 AE ?? ?? ?? 0? ?? ?? A5 24 24 00 BF 8F 1C 00 02 AE 01 00 02 24 28 00 02 AE 20 00 B2 8F 21 10 20 02 18 00 B0 8F 1C 00 B1 8F 08 00 E0 03 28 00 BD 27 24 00 BF 8F 01 00 11 24 21 10 20 02 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_134_2_0 {
	meta:
		name = "__gconv_transliterate"
		size = 1288
		refs = "0000 __gnu_local_gp 0008 _nl_current_LC_CTYPE 0374 _dl_mcount_wrapper_check"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 ?? ?? 99 8F 3B E8 03 7C 78 FF BD 27 21 10 23 03 00 00 43 8C 70 00 B4 AF 6C 00 B3 AF 00 00 62 8C 68 00 B2 AF 60 00 B0 AF 84 00 BF AF 80 00 BE AF 7C 00 B7 AF 78 00 B6 AF 74 00 B5 AF 64 00 B1 AF 20 00 BC AF 44 00 B9 AF 18 01 59 8C 21 90 80 00 30 00 B9 AF 98 00 B9 8F A0 00 B3 8F 14 00 90 8C 00 00 39 8F 34 00 B9 AF 30 00 B9 8F 4E 00 20 13 21 A0 A0 00 34 00 B9 8F 28 01 56 8C 04 00 23 27 9C 00 B9 8F 2B 20 23 03 1C 01 59 8C 4C 00 B9 AF 20 01 59 8C 48 00 B9 AF 24 01 59 8C 85 00 80 14 54 00 B9 AF 9C 00 B9 8F 3C 00 A0 AF 06 00 15 24 03 00 22 27 23 18 43 00 82 50 03 00 01 00 57 25 30 00 A3 8F 3C 00 B9 8F 21 F0 79 00 4C 00 A3 8F 42 F0 1E 00 80 38 1E 00 21 10 67 00 00 00 42 8C 38 00 BE AF 21 F0 00 00 40 00 A2 AF 40 00 B9 8F 34 00 A2 8F 80 18 19 00 48 00 B9 8F 21 18 23 03 ?? ?? ?? 0? 00 00 64 8C 04 00 64 8C 01 00 DE 27 7F 00 80 10 04 00 63 24 6B 00 D7 13 84 00 BF 8F 00 00 45 8C 21 30 40 00 F7 FF A4 10 04 00 42 24 75 00 C0 17 50 00 A0 AF 9C 00 B9 8F 2B 10 D9 00 6E 00 40 10 38 00 B9 8F 50 00 A3 8F 40 00 B9 8F 21 10 79 00 48 00 A3 8F 80 10 02 00 21 10 62 00 00 00 43 8C 00 00 C2 8C 2B 10 62 00 63 00 40 14 38 00 B9 8F 38 00 A3 8F 30 00 A3 AF 3C 00 B9 8F 30 00 A3 8F 2B 10 23 03 CF FF 40 14 00 00 00 00 44 00 B9 8F 3B E8 03 7C 21 10 23 03 00 00 4A 8C ?? ?? ?? 0? 00 00 48 8D 21 40 40 00 21 50 60 00 34 01 07 8D 11 00 E0 14 98 00 B9 8F 2C 01 02 8D 2D 00 40 14 06 00 11 24 84 00 BF 8F 21 10 20 02 80 00 BE 8F 7C 00 B7 8F 78 00 B6 8F 74 00 B5 8F 70 00 B4 8F 6C 00 B3 8F 68 00 B2 8F 64 00 B1 8F 60 00 B0 8F 08 00 E0 03 88 00 BD 27 38 01 02 8D 00 00 2B 8F 34 00 B9 8F 04 00 23 27 9C 00 B9 8F 2B 18 23 03 27 00 60 14 00 00 65 8D 0F 00 E0 1C 00 00 00 00 ?? ?? ?? 0? 2C 01 02 8D 04 00 46 8C 2B 30 C5 00 07 00 C0 14 23 20 A4 00 08 00 46 8C 1B 00 86 00 F4 01 C0 00 10 48 00 00 9A 00 20 11 98 00 B9 8F D9 FF E3 10 0C 00 42 24 00 00 44 8C 2B 30 A4 00 F1 FF C0 10 01 00 63 24 2C 01 02 8D D5 FF 40 10 06 00 11 24 34 00 B9 8F 30 01 15 8D 04 00 22 27 2C 00 B5 AF 9C 00 B9 8F 00 00 43 8D 2B 10 22 03 6F 00 40 10 2C 01 76 8C 34 00 A2 8F 07 00 11 24 26 B8 59 00 04 00 02 24 ?? ?? ?? 0? 0A 88 57 00 34 00 B9 8F 9C 00 A2 8F C2 FF 22 13 04 00 11 24 84 00 BF 8F 07 00 11 24 21 10 20 02 80 00 BE 8F 7C 00 B7 8F 78 00 B6 8F 74 00 B5 8F 70 00 B4 8F 6C 00 B3 8F 68 00 B2 8F 64 00 B1 8F 60 00 B0 8F 08 00 E0 03 88 00 BD 27 01 00 39 27 ?? ?? ?? 0? 3C 00 B9 AF EF FF 80 14 84 00 BF 8F 54 00 A3 8F 50 00 BE AF 21 38 67 00 00 00 F1 8C 80 10 11 00 21 18 C2 02 00 00 63 8C 26 00 60 10 21 28 C2 02 04 00 42 24 01 00 31 26 ?? ?? ?? 0? 21 10 C2 02 21 88 80 00 00 00 43 8C 21 38 40 00 01 00 24 26 FB FF 60 14 04 00 42 24 00 00 62 8E 21 20 00 02 2C 00 A5 AF 28 00 A2 AF ?? ?? ?? 0? 58 00 A7 AF 58 00 A7 8F 28 00 A4 27 10 00 A4 AF 14 00 A0 AF 18 00 A0 AF 1C 00 A0 AF 21 20 40 02 21 28 80 02 21 C8 00 02 09 F8 20 03 2C 00 A6 27 0B 00 55 14 01 00 31 26 80 10 11 00 21 18 C2 02 00 00 63 8C DD FF 60 14 34 00 B9 8F 80 30 1E 00 ?? ?? ?? 0? 21 30 26 03 ?? ?? ?? 0? 21 38 A0 00 04 00 03 24 12 00 43 10 05 00 03 24 02 00 43 10 28 00 A3 8F 00 00 63 AE 84 00 BF 8F 21 88 40 00 21 10 20 02 80 00 BE 8F 7C 00 B7 8F 78 00 B6 8F 74 00 B5 8F 70 00 B4 8F 6C 00 B3 8F 68 00 B2 8F 64 00 B1 8F 60 00 B0 8F 08 00 E0 03 88 00 BD 27 98 00 B9 8F A4 00 A4 8F 80 40 1E 00 00 00 22 8F 00 00 83 8C 21 10 48 00 01 00 63 24 00 00 22 AF 00 00 83 AC 28 00 A3 8F 21 10 00 00 ?? ?? ?? 0? 00 00 63 AE 00 00 62 8E 21 20 00 02 ?? ?? ?? 0? 28 00 A2 AF 28 00 A2 27 80 38 16 00 10 00 A2 AF 14 00 A0 AF 18 00 A0 AF 1C 00 A0 AF 21 20 40 02 21 28 80 02 2C 00 A6 27 21 C8 00 02 09 F8 20 03 21 38 A7 02 06 00 03 24 4B FF 43 10 04 00 03 24 0D 00 43 10 98 00 B9 8F 21 88 40 00 28 00 A2 8F ?? ?? ?? 0? 00 00 62 AE A4 00 A3 8F 04 00 6B 25 00 00 62 8C 21 88 00 00 00 00 2B AF 01 00 42 24 ?? ?? ?? 0? 00 00 62 AC A4 00 A2 8F A4 00 A5 8F 00 00 44 8C 00 00 23 8F 21 10 00 00 01 00 84 24 04 00 63 24 00 00 A4 AC ?? ?? ?? 0? 00 00 23 AF }
	condition:
		$1
}

rule file_134_3_0 {
	meta:
		name = "__gconv_translit_find"
		size = 780
		refs = "0070 __tfind 0100 strlen 0104 __gconv_path_elem 0128 $LC6 0134 memcmp 0140 __gconv_max_path_elem_len 0150 malloc 0198 mempcpy 01e4 stpcpy 0220 __tsearch 02a4 __gconv_get_path 02dc __lll_lock_wait_private 02ec $LC4 02f0 $LC5 0304 __assert_fail 02f4 __PRETTY_FUNCTION__.8484"
	strings:
		$1 = { 00 00 82 8C B8 FF BD 27 24 00 B1 AF 44 00 BF AF 40 00 BE AF 3C 00 B7 AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 20 00 B0 AF AE 00 40 10 21 88 80 00 ?? ?? 10 3C ?? ?? 03 26 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 A0 00 40 14 00 00 00 00 ?? ?? 14 3C ?? ?? 15 3C 21 20 20 02 ?? ?? 85 26 ?? ?? ?? 0? ?? ?? A6 26 20 00 40 10 21 90 40 00 00 00 44 8C 24 00 82 8C 1A 00 40 10 FF FF 03 24 6A 00 43 10 21 98 00 00 ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 7E 00 40 10 00 00 00 00 44 00 BF 8F 21 10 60 02 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 ?? ?? ?? 0? 01 00 13 24 00 00 24 8E ?? ?? ?? 0? ?? ?? 13 3C ?? ?? 63 8E 65 00 60 10 01 00 56 24 05 00 C3 2E 09 00 60 14 01 00 17 24 00 00 24 8E FD FF 42 24 ?? ?? 05 3C 21 20 82 00 ?? ?? A5 24 ?? ?? ?? 0? 03 00 06 24 2B B8 02 00 ?? ?? 02 3C ?? ?? 44 8C 2F 00 84 24 21 20 96 00 ?? ?? ?? 0? 21 20 96 00 E6 FF 40 10 21 90 40 00 00 00 25 8E 2C 00 42 24 21 20 40 00 21 30 C0 02 04 00 40 AE 08 00 40 AE 0C 00 40 AE 10 00 40 AE 14 00 40 AE 18 00 40 AE 1C 00 40 AE 20 00 40 AE 24 00 40 AE 28 00 40 AE ?? ?? ?? 0? 00 00 42 AE ?? ?? 73 8E 20 00 42 AE 00 00 65 8E 18 00 A0 10 ?? ?? 03 3C ?? ?? 7E 8C ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 21 20 40 02 1A 00 40 10 00 00 00 00 08 00 73 26 00 00 65 8E 0D 00 A0 10 00 00 00 00 20 00 44 8E ?? ?? ?? 0? 00 00 00 00 00 00 25 8E 21 20 40 00 ?? ?? ?? 0? 21 30 C0 02 F0 FF E0 12 00 00 00 00 03 00 5E A8 ?? ?? ?? 0? 00 00 5E B8 20 00 40 AE 01 00 13 24 21 20 40 02 ?? ?? 85 26 ?? ?? ?? 0? ?? ?? A6 26 01 00 03 24 ?? ?? ?? 0? 0A 98 62 00 ?? ?? ?? 0? 21 98 00 00 ?? ?? ?? 0? 00 00 00 00 AB FF 40 14 00 00 00 00 00 00 42 8E 18 00 43 8C 00 00 49 8C 04 00 48 8C 08 00 47 8C 0C 00 46 8C 10 00 45 8C 14 00 44 8C 1C 00 42 8C 18 00 23 AE 00 00 29 AE 04 00 28 AE 08 00 27 AE 0C 00 26 AE 10 00 25 AE 14 00 24 AE 1C 00 22 AE 00 00 42 8E 28 00 43 8C 01 00 63 24 ?? ?? ?? 0? 28 00 43 AC ?? ?? ?? 0? 18 00 A2 AF ?? ?? ?? 0? 18 00 A2 8F ?? ?? 04 26 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 44 00 BF 8F ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? ?? ?? 14 3C ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 4C 01 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "_itoa_word"
		size = 244
		refs = "0008 _itoa_upper_digits 00a0 _itoa_lower_digits"
	strings:
		$1 = { 27 00 E0 10 21 10 A0 00 ?? ?? 03 3C 0A 00 05 24 27 00 C5 10 ?? ?? 63 24 10 00 05 24 0E 00 C5 10 08 00 05 24 16 00 C5 10 07 00 85 30 1B 00 86 00 F4 01 C0 00 FF FF 42 24 10 28 00 00 21 28 65 00 00 00 A5 80 12 20 00 00 F8 FF 80 14 00 00 45 A0 08 00 E0 03 00 00 00 00 0F 00 85 30 21 28 65 00 00 00 A5 80 FF FF 42 24 02 21 04 00 FA FF 80 14 00 00 45 A0 08 00 E0 03 00 00 00 00 07 00 85 30 21 28 65 00 00 00 A5 80 FF FF 42 24 C2 20 04 00 FA FF 80 14 00 00 45 A0 08 00 E0 03 00 00 00 00 ?? ?? 03 3C 0A 00 05 24 DB FF C5 14 ?? ?? 63 24 CC CC 08 3C CD CC 08 35 19 00 88 00 FF FF 42 24 10 28 00 00 C2 28 05 00 40 38 05 00 C0 30 05 00 21 30 E6 00 23 20 86 00 21 20 64 00 00 00 86 80 21 20 A0 00 F4 FF A0 14 00 00 46 A0 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_135_1_0 {
	meta:
		name = "_itoa"
		size = 1264
		refs = "0010 _itoa_upper_digits 0074 _itoa_lower_digits 0120 _itoa_base_table"
	strings:
		$1 = { E8 FF BD 27 28 00 A2 8F 1A 00 40 10 08 00 02 24 ?? ?? 0B 3C 1A 00 E2 10 ?? ?? 6B 25 10 00 02 24 3C 00 E2 14 FE FF E2 24 82 00 A0 10 21 10 C0 00 F8 FF C2 24 0F 00 83 30 21 18 63 01 00 00 63 80 FF FF C6 24 02 21 04 00 FA FF C2 14 00 00 C3 A0 0F 00 A3 30 21 18 63 01 00 00 63 80 FF FF 42 24 02 29 05 00 74 00 A0 14 00 00 43 A0 08 00 E0 03 18 00 BD 27 ?? ?? 0B 3C E8 FF E2 14 ?? ?? 6B 25 14 00 A0 10 21 10 C0 00 F6 FF C2 24 21 18 C0 00 07 00 87 30 21 38 67 01 00 00 E7 80 FF FF 63 24 C2 20 04 00 FA FF 62 14 00 00 67 A0 01 00 A3 30 80 18 03 00 42 28 05 00 06 00 A0 10 25 20 83 00 21 20 64 01 00 00 83 80 F5 FF C2 24 21 20 A0 00 F5 FF C3 A0 07 00 83 30 21 18 63 01 00 00 63 80 FF FF 42 24 C2 20 04 00 E0 FF 80 10 00 00 43 A0 07 00 83 30 21 18 63 01 00 00 63 80 FF FF 42 24 C2 20 04 00 F3 FF 80 14 00 00 43 A0 ?? ?? ?? 0? 00 00 00 00 80 50 02 00 00 11 02 00 21 10 42 01 ?? ?? 0A 3C ?? ?? 4A 25 4C 00 A0 14 21 50 42 01 08 00 A4 AF 01 00 0E 24 04 00 43 81 80 70 0E 00 21 70 DD 01 04 00 AF 27 21 10 C0 00 30 00 0D 24 23 00 60 14 00 00 4C 8D 0E 00 80 10 00 00 00 00 19 00 8C 00 05 00 45 81 FF FF 42 24 01 00 63 24 10 48 00 00 06 28 A9 00 02 48 A7 70 23 40 89 00 21 40 68 01 00 00 08 81 21 20 A0 00 F4 FF A0 14 00 00 48 A0 D0 00 CF 11 00 00 00 00 09 00 44 81 2A 20 64 00 09 00 80 10 00 00 00 00 FF FF 42 24 00 00 4D A0 09 00 44 81 01 00 63 24 2A 20 64 00 FB FF 80 14 FF FF 42 24 01 00 42 24 04 00 43 81 00 00 C4 8D 00 00 4C 8D DF FF 60 10 FC FF CE 25 EC FF 80 10 21 18 00 00 19 00 8C 00 05 00 48 81 FF FF 42 24 01 00 63 24 FF FF 08 25 10 48 00 00 23 28 89 00 42 28 05 00 21 28 A9 00 06 28 05 01 02 48 A7 70 23 40 89 00 21 40 68 01 00 00 08 81 21 20 A0 00 F0 FF A0 14 00 00 48 A0 ?? ?? ?? 0? 00 00 00 00 21 28 80 00 0F 00 A3 30 21 18 63 01 00 00 63 80 FF FF 42 24 02 29 05 00 FA FF A0 14 00 00 43 A0 08 00 E0 03 18 00 BD 27 0C 00 4D 8D 08 00 4C 81 2B 10 AD 00 67 00 40 14 04 68 8D 01 8A 00 80 11 21 40 00 00 40 00 18 24 23 C0 0C 03 27 48 18 00 40 10 05 00 06 18 04 03 04 48 22 01 20 00 08 33 25 18 23 01 06 C0 05 03 0A C0 68 00 21 40 00 03 10 00 59 8D 20 00 0F 24 23 78 EC 01 19 00 19 01 27 18 0F 00 04 10 62 00 06 40 E4 01 20 00 E3 31 25 40 48 00 06 28 E5 01 0B 40 A3 00 10 48 00 00 21 70 09 03 19 00 CD 01 12 10 00 00 23 28 02 01 2B 40 05 01 10 18 00 00 23 10 03 03 23 10 48 00 06 00 40 10 23 18 AD 00 2B 28 A3 00 72 00 45 10 00 00 00 00 23 28 6D 00 02 00 CE 25 2B 10 AD 00 04 00 40 14 19 00 B9 00 23 28 AD 00 01 00 CE 25 19 00 B9 00 04 20 84 01 10 48 00 00 21 48 A9 00 19 00 2D 01 12 10 00 00 23 40 82 00 2B 20 88 00 10 18 00 00 23 10 A3 00 23 10 44 00 06 00 40 10 23 18 0D 01 2B 40 03 01 52 00 48 10 00 00 00 00 23 40 6D 00 02 00 29 25 2B 10 0D 01 04 00 40 14 06 20 88 01 23 40 0D 01 01 00 29 25 06 20 88 01 04 00 80 11 10 00 A4 AF 04 70 8E 01 06 78 E9 01 25 70 EE 01 19 00 D9 01 04 48 89 01 10 18 00 00 21 28 C3 01 19 00 AD 00 12 10 00 00 23 10 22 01 2B 48 22 01 10 18 00 00 23 18 C3 01 23 18 69 00 06 00 60 10 23 40 4D 00 2B 10 48 00 38 00 62 10 00 00 00 00 23 10 0D 01 02 00 A5 24 2B 18 4D 00 03 00 60 14 00 00 00 00 23 10 4D 00 01 00 A5 24 06 10 82 01 08 00 A5 AF 0C 00 A2 AF ?? ?? ?? 0? 03 00 0E 24 42 18 04 00 27 10 0C 00 06 18 43 00 04 28 85 01 10 00 42 8D 20 00 88 31 04 20 84 01 25 28 65 00 0B 28 88 00 19 00 A2 00 0B 20 08 00 10 18 00 00 21 40 A3 00 19 00 0D 01 12 10 00 00 23 10 82 00 2B 20 82 00 10 18 00 00 23 18 A3 00 23 18 64 00 06 00 60 10 23 20 4D 00 2B 10 44 00 16 00 62 10 00 00 00 00 23 10 8D 00 02 00 08 25 2B 18 4D 00 03 00 60 14 00 00 00 00 23 10 4D 00 01 00 08 25 06 20 82 01 08 00 A8 AF 0C 00 A4 AF ?? ?? ?? 0? 02 00 0E 24 21 C0 00 00 ?? ?? ?? 0? 40 10 05 00 01 00 29 25 ?? ?? ?? 0? 21 40 60 00 01 00 A5 24 ?? ?? ?? 0? 21 10 00 01 01 00 08 25 ?? ?? ?? 0? 21 10 80 00 01 00 CE 25 ?? ?? ?? 0? 21 28 60 00 E4 FE 46 14 21 20 40 00 30 00 03 24 FF FF 42 24 ?? ?? ?? 0? FF FF 83 A0 }
	condition:
		$1
}

rule file_135_2_0 {
	meta:
		name = "_fitoa_word"
		size = 92
		refs = "0010 _itoa_word"
	strings:
		$1 = { D0 FF BD 27 28 00 A9 27 21 50 A0 00 2C 00 BF AF ?? ?? ?? 0? 21 28 20 01 2B 18 49 00 0C 00 60 10 2C 00 BF 8F 21 18 40 00 21 20 40 01 01 00 63 24 FF FF 66 80 01 00 84 24 FC FF 69 14 FF FF 86 A0 23 10 A2 03 28 00 42 24 21 50 42 01 2C 00 BF 8F 21 10 40 01 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_135_3_0 {
	meta:
		name = "_fitoa"
		size = 116
		refs = "0020 _itoa"
	strings:
		$1 = { B0 FF BD 27 60 00 A2 8F 44 00 B0 AF 40 00 B0 27 48 00 B1 AF 10 00 A2 AF 21 88 C0 00 4C 00 BF AF ?? ?? ?? 0? 21 30 00 02 2B 18 50 00 0C 00 60 10 4C 00 BF 8F 21 18 40 00 21 20 20 02 01 00 63 24 FF FF 65 80 01 00 84 24 FC FF 70 14 FF FF 85 A0 23 10 A2 03 40 00 42 24 21 88 22 02 4C 00 BF 8F 21 10 20 02 44 00 B0 8F 48 00 B1 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "__setsid"
		size = 28
	strings:
		$1 = { E2 0F 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "__nscd_getgrouplist"
		size = 964
		refs = "0038 strlen 0040 $LC0 0044 __gr_map_handle 0058 __nscd_get_map_ref 0088 __nscd_cache_search 01b4 __nscd_open_socket 0200 memcpy 024c __nscd_unmap 0298 realloc 02cc __readall 0300 __nss_not_use_nscd_group 01d8 $LC1 0100 $LC2 0324 __assert_fail 0314 __PRETTY_FUNCTION__.12170 03a0 $LC3"
	strings:
		$1 = { A0 FF BD 27 5C 00 BF AF 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF 40 00 B2 AF 3C 00 B1 AF 60 00 A4 AF 21 90 A0 00 21 F0 C0 00 21 A8 E0 00 ?? ?? ?? 0? 38 00 B0 AF ?? ?? 05 3C ?? ?? 06 3C 0C 00 04 24 ?? ?? A5 24 ?? ?? C6 24 2C 00 A7 27 ?? ?? ?? 0? 01 00 57 24 21 88 40 00 21 A0 00 00 FF FF 13 24 01 00 16 24 4B 00 33 12 60 00 A5 8F 0C 00 02 24 10 00 A2 AF 0F 00 04 24 21 30 E0 02 ?? ?? ?? 0? 21 38 20 02 44 00 40 10 60 00 A4 8F 00 00 23 8E 04 00 48 8C 18 00 4B 8C 08 00 67 8C 1C 00 4A 8C 20 00 45 8C 2C 00 A4 8F 18 00 49 24 24 00 46 24 20 00 AB AF 24 00 AA AF 28 00 A5 AF 88 00 E4 14 21 40 28 01 80 28 05 00 21 28 C5 00 2B 40 05 01 85 00 00 15 00 00 00 00 24 00 A3 8F 39 00 76 10 FF FF 08 24 A7 00 73 10 01 00 03 24 00 00 C2 8F A8 00 40 18 ?? ?? 05 3C 00 00 A7 8E 21 18 00 00 80 10 03 00 21 38 E2 00 01 00 70 24 00 00 F2 AC 03 00 13 11 21 20 00 01 A6 0F 02 24 0C 00 00 00 0F 00 33 12 2C 00 A4 8F 00 00 23 8E 08 00 62 8C 7B 00 44 14 01 00 43 30 0C 00 22 26 00 00 43 C0 FF FF 61 24 00 00 41 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 01 00 02 24 39 00 62 10 00 00 00 00 5C 00 BF 8F 21 10 00 02 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 60 00 BD 27 60 00 A4 8F 0C 00 02 24 10 00 A2 AF 21 28 E0 02 0F 00 06 24 ?? ?? ?? 0? 20 00 A7 27 4F 00 53 10 21 40 40 00 24 00 A3 8F C9 FF 76 14 21 30 00 00 28 00 B0 8F 4E 00 00 06 ?? ?? 04 3C 00 00 C2 8F 2A 10 02 02 28 00 40 10 00 00 00 00 35 00 C0 10 00 00 A5 8E 21 20 A0 00 21 28 C0 00 80 30 10 00 ?? ?? ?? 0? 34 00 A8 AF 34 00 A8 8F C3 FF 00 06 00 00 00 00 69 00 00 12 00 00 A7 8E 00 00 E2 8C BE FF 52 10 04 00 E5 24 21 18 00 00 01 00 63 24 B6 FF 70 10 04 00 A5 24 FC FF A6 8C FC FF D2 14 01 00 63 24 ?? ?? ?? 0? FF FF 63 24 ?? ?? ?? 0? 21 20 20 02 5C 00 BF 8F 21 10 00 02 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 60 00 BD 27 00 00 A4 8E 01 00 05 26 80 28 05 00 30 00 A6 AF ?? ?? ?? 0? 34 00 A8 AF 30 00 A6 8F 0F 00 40 10 34 00 A8 8F 28 00 B0 8F 00 00 A2 AE 21 28 40 00 01 00 02 26 CD FF C0 14 00 00 C2 AF 80 30 10 00 21 20 00 01 ?? ?? ?? 0? 34 00 A8 AF 28 00 B0 8F 80 18 10 00 CB FF 43 10 34 00 A8 8F ?? ?? ?? 0? FF FF 10 24 ?? ?? ?? 0? FE FF 10 24 ?? ?? ?? 0? FF FF 10 24 01 00 03 24 ?? ?? 02 3C ?? ?? 43 AC ?? ?? ?? 0? FF FF 10 24 ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 64 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 07 00 60 14 2C 00 A2 AF 01 00 94 26 05 00 02 24 04 00 82 12 0C 00 23 26 4A FF 13 16 00 00 00 00 0C 00 23 26 00 00 62 C0 FF FF 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 05 00 56 10 00 00 00 00 7E FF 13 12 FF FF 11 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 20 20 02 ?? ?? ?? 0? 00 00 00 00 ?? ?? 02 3C ?? ?? 43 AC ?? ?? ?? 0? FF FF 10 24 ?? ?? 04 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 8F 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? ?? 0? 21 18 00 00 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "__uselocale"
		size = 600
		refs = "0000 __gnu_local_gp 0008 __libc_tsd_LOCALE 0024 _nl_global_locale 0038 _nl_current_LC_COLLATE_used 0048 _nl_current_LC_COLLATE 0058 _nl_current_LC_CTYPE_used 0070 _nl_current_LC_CTYPE 007c _nl_current_LC_MONETARY_used 0088 _nl_current_LC_MONETARY 00a0 _nl_current_LC_NUMERIC_used 00ac _nl_current_LC_NUMERIC 00c4 _nl_current_LC_TIME_used 00d0 _nl_current_LC_TIME 00e8 _nl_current_LC_MESSAGES_used 00f4 _nl_current_LC_MESSAGES 010c _nl_current_LC_PAPER_used 0118 _nl_current_LC_PAPER 0130 _nl_current_LC_NAME_used 013c _nl_current_LC_NAME 0154 _nl_current_LC_ADDRESS_used 0160 _nl_current_LC_ADDRESS 0178 _nl_current_LC_TELEPHONE_used 0184 _nl_current_LC_TELEPHONE 019c _nl_current_LC_MEASUREMENT_used 01a8 _nl_current_LC_MEASUREMENT 01c0 _nl_current_LC_IDENTIFICATION_used 01cc _nl_current_LC_IDENTIFICATION 01e4 __libc_tsd_CTYPE_B 0200 __libc_tsd_CTYPE_TOLOWER 0204 __libc_tsd_CTYPE_TOUPPER"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 ?? ?? 86 8F 3B E8 03 7C 21 10 C3 00 86 00 80 10 00 00 45 8C FF FF 02 24 8A 00 82 10 ?? ?? 02 3C ?? ?? 42 24 3B E8 03 7C 21 30 C3 00 21 38 60 00 ?? ?? 03 3C ?? ?? 63 24 05 00 60 10 00 00 C4 AC ?? ?? 86 8F 0C 00 83 24 21 38 C7 00 00 00 E3 AC ?? ?? 03 3C ?? ?? 63 24 07 00 60 10 ?? ?? 03 3C 3B E8 03 7C 21 30 60 00 ?? ?? 83 8F 21 30 66 00 00 00 C4 AC ?? ?? 03 3C ?? ?? 63 24 06 00 60 10 ?? ?? 87 8F 3B E8 03 7C 21 30 60 00 21 30 E6 00 10 00 83 24 00 00 C3 AC ?? ?? 03 3C ?? ?? 63 24 06 00 60 10 ?? ?? 87 8F 3B E8 03 7C 21 30 60 00 21 30 E6 00 04 00 83 24 00 00 C3 AC ?? ?? 03 3C ?? ?? 63 24 06 00 60 10 ?? ?? 87 8F 3B E8 03 7C 21 30 60 00 21 30 E6 00 08 00 83 24 00 00 C3 AC ?? ?? 03 3C ?? ?? 63 24 06 00 60 10 ?? ?? 87 8F 3B E8 03 7C 21 30 60 00 21 30 E6 00 14 00 83 24 00 00 C3 AC ?? ?? 03 3C ?? ?? 63 24 06 00 60 10 ?? ?? 87 8F 3B E8 03 7C 21 30 60 00 21 30 E6 00 1C 00 83 24 00 00 C3 AC ?? ?? 03 3C ?? ?? 63 24 06 00 60 10 ?? ?? 87 8F 3B E8 03 7C 21 30 60 00 21 30 E6 00 20 00 83 24 00 00 C3 AC ?? ?? 03 3C ?? ?? 63 24 06 00 60 10 ?? ?? 87 8F 3B E8 03 7C 21 30 60 00 21 30 E6 00 24 00 83 24 00 00 C3 AC ?? ?? 03 3C ?? ?? 63 24 06 00 60 10 ?? ?? 87 8F 3B E8 03 7C 21 30 60 00 21 30 E6 00 28 00 83 24 00 00 C3 AC ?? ?? 03 3C ?? ?? 63 24 06 00 60 10 ?? ?? 87 8F 3B E8 03 7C 21 30 60 00 21 30 E6 00 2C 00 83 24 00 00 C3 AC ?? ?? 03 3C ?? ?? 63 24 06 00 60 10 ?? ?? 87 8F 3B E8 03 7C 21 30 60 00 21 30 E6 00 30 00 83 24 00 00 C3 AC ?? ?? 89 8F 3B E8 03 7C 34 00 88 8C 38 00 87 8C 3C 00 86 8C 21 48 23 01 21 20 60 00 ?? ?? 83 8F ?? ?? 8A 8F 26 10 A2 00 21 18 64 00 00 00 67 AC FF FF 03 24 21 20 44 01 0B 18 A2 00 00 00 28 AD 00 00 86 AC 08 00 E0 03 21 10 60 00 ?? ?? 02 3C ?? ?? 42 24 26 10 A2 00 FF FF 03 24 0B 18 A2 00 08 00 E0 03 21 10 60 00 ?? ?? 42 24 ?? ?? ?? 0? 21 20 40 00 }
	condition:
		$1
}

rule file_140_0_0 {
	meta:
		name = "xdr_int64_t"
		size = 232
	strings:
		$1 = { 00 00 82 8C D0 FF BD 27 01 00 03 24 28 00 B1 AF 24 00 B0 AF 2C 00 BF AF 21 80 80 00 09 00 43 10 21 88 A0 00 13 00 40 10 02 00 42 38 01 00 42 2C 2C 00 BF 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 04 00 82 8C 20 00 59 8C 09 F8 20 03 1C 00 A5 27 18 00 40 14 21 20 00 02 2C 00 BF 8F 28 00 B1 8F 24 00 B0 8F 21 10 00 00 08 00 E0 03 30 00 BD 27 04 00 85 8C 00 00 23 8E 04 00 22 8E 24 00 B9 8C 18 00 A3 AF 1C 00 A2 AF 09 F8 20 03 1C 00 A5 27 F2 FF 40 10 2C 00 BF 8F 04 00 02 8E 21 20 00 02 24 00 59 8C 09 F8 20 03 18 00 A5 27 ?? ?? ?? 0? 2B 10 02 00 04 00 02 8E 20 00 59 8C 09 F8 20 03 18 00 A5 27 E5 FF 40 10 2C 00 BF 8F 18 00 A3 8F 01 00 02 24 00 00 23 AE 1C 00 A3 8F ?? ?? ?? 0? 04 00 23 AE }
	condition:
		$1
}

rule file_140_2_0 {
	meta:
		name = "xdr_uint64_t"
		size = 232
	strings:
		$1 = { 00 00 82 8C D0 FF BD 27 01 00 03 24 28 00 B1 AF 24 00 B0 AF 2C 00 BF AF 21 80 80 00 09 00 43 10 21 88 A0 00 13 00 40 10 02 00 42 38 01 00 42 2C 2C 00 BF 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 04 00 82 8C 20 00 59 8C 09 F8 20 03 1C 00 A5 27 18 00 40 14 21 20 00 02 2C 00 BF 8F 28 00 B1 8F 24 00 B0 8F 21 10 00 00 08 00 E0 03 30 00 BD 27 04 00 85 8C 00 00 23 8E 04 00 22 8E 24 00 B9 8C 18 00 A3 AF 1C 00 A2 AF 09 F8 20 03 1C 00 A5 27 F2 FF 40 10 2C 00 BF 8F 04 00 02 8E 21 20 00 02 24 00 59 8C 09 F8 20 03 18 00 A5 27 ?? ?? ?? 0? 2B 10 02 00 04 00 02 8E 20 00 59 8C 09 F8 20 03 18 00 A5 27 E5 FF 40 10 2C 00 BF 8F 1C 00 A3 8F 01 00 02 24 04 00 23 AE 18 00 A3 8F ?? ?? ?? 0? 00 00 23 AE }
	condition:
		$1
}

rule file_140_4_0 {
	meta:
		name = "xdr_int32_t"
		size = 64
		altNames = "xdr_uint32_t"
	strings:
		$1 = { 00 00 82 8C 01 00 06 24 05 00 46 10 00 00 00 00 07 00 40 10 02 00 42 38 08 00 E0 03 01 00 42 2C 04 00 82 8C 20 00 59 8C 08 00 20 03 00 00 00 00 04 00 82 8C 24 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_140_6_0 {
	meta:
		name = "xdr_int16_t"
		size = 164
	strings:
		$1 = { 00 00 82 8C D8 FF BD 27 01 00 06 24 20 00 B0 AF 24 00 BF AF 09 00 46 10 21 80 A0 00 15 00 40 10 02 00 42 38 01 00 43 2C 24 00 BF 8F 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 04 00 82 8C 20 00 59 8C 09 F8 20 03 18 00 A5 27 F6 FF 40 10 21 18 00 00 18 00 A2 8F 24 00 BF 8F 01 00 03 24 00 00 02 A6 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 04 00 83 8C 00 00 A2 84 18 00 A5 27 24 00 79 8C 09 F8 20 03 18 00 A2 AF 24 00 BF 8F 21 18 40 00 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_140_7_0 {
	meta:
		name = "xdr_uint16_t"
		size = 164
	strings:
		$1 = { 00 00 82 8C D8 FF BD 27 01 00 06 24 20 00 B0 AF 24 00 BF AF 09 00 46 10 21 80 A0 00 15 00 40 10 02 00 42 38 01 00 43 2C 24 00 BF 8F 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 04 00 82 8C 20 00 59 8C 09 F8 20 03 18 00 A5 27 F6 FF 40 10 21 18 00 00 18 00 A2 8F 24 00 BF 8F 01 00 03 24 00 00 02 A6 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 04 00 83 8C 00 00 A2 94 18 00 A5 27 24 00 79 8C 09 F8 20 03 18 00 A2 AF 24 00 BF 8F 21 18 40 00 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_140_8_0 {
	meta:
		name = "xdr_int8_t"
		size = 164
	strings:
		$1 = { 00 00 82 8C D8 FF BD 27 01 00 06 24 20 00 B0 AF 24 00 BF AF 09 00 46 10 21 80 A0 00 15 00 40 10 02 00 42 38 01 00 43 2C 24 00 BF 8F 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 04 00 82 8C 20 00 59 8C 09 F8 20 03 18 00 A5 27 F6 FF 40 10 21 18 00 00 18 00 A2 8F 01 00 03 24 00 00 02 A2 24 00 BF 8F 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 04 00 83 8C 00 00 A2 80 18 00 A5 27 24 00 79 8C 09 F8 20 03 18 00 A2 AF 24 00 BF 8F 21 18 40 00 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_140_9_0 {
	meta:
		name = "xdr_uint8_t"
		size = 164
	strings:
		$1 = { 00 00 82 8C D8 FF BD 27 01 00 06 24 20 00 B0 AF 24 00 BF AF 09 00 46 10 21 80 A0 00 15 00 40 10 02 00 42 38 01 00 43 2C 24 00 BF 8F 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 04 00 82 8C 20 00 59 8C 09 F8 20 03 18 00 A5 27 F6 FF 40 10 21 18 00 00 18 00 A2 8F 01 00 03 24 00 00 02 A2 24 00 BF 8F 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 04 00 83 8C 00 00 A2 90 18 00 A5 27 24 00 79 8C 09 F8 20 03 18 00 A2 AF 24 00 BF 8F 21 18 40 00 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "__remap_file_pages"
		size = 28
	strings:
		$1 = { 9B 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "___vfprintf_chk"
		size = 512
		refs = "007c __lll_lock_wait_private 00b4 vfprintf 01ac _Unwind_Resume"
	strings:
		$1 = { 00 00 82 8C C8 FF BD 27 2C 00 B3 AF 00 80 42 30 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 34 00 BF AF 30 00 B4 AF 21 80 80 00 21 90 A0 00 21 98 C0 00 1A 00 40 14 21 88 E0 00 3B E8 03 7C 48 00 84 8C 70 8B 74 24 08 00 82 8C 11 00 54 10 00 00 00 00 18 00 A0 AF 00 00 83 C0 06 00 60 14 00 00 02 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 02 24 0F 00 00 00 03 00 40 14 00 00 00 00 ?? ?? ?? 0? 18 00 A3 AF 48 00 02 8E 21 20 40 00 08 00 54 AC 04 00 82 8C 01 00 42 24 04 00 82 AC 04 00 40 1A 21 20 00 02 3C 00 02 8E 04 00 42 34 3C 00 02 AE 21 28 60 02 ?? ?? ?? 0? 21 30 20 02 19 00 40 1A 21 88 40 00 3C 00 03 8E FB FF 02 24 24 10 62 00 3C 00 02 AE 00 00 03 8E EB FF 04 24 24 10 44 00 00 80 63 30 06 00 60 14 3C 00 02 AE 48 00 04 8E 04 00 82 8C FF FF 42 24 0C 00 40 10 04 00 82 AC 34 00 BF 8F 21 10 20 02 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? 3C 00 02 8E 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 EC FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F 3C 00 05 8E 00 00 02 8E EB FF 03 24 24 18 A3 00 00 80 42 30 21 88 80 00 06 00 40 14 3C 00 03 AE 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_1259_0_0 {
	meta:
		name = "__vfwprintf_chk"
		size = 512
		refs = "007c __lll_lock_wait_private 00b4 _IO_vfwprintf 01ac _Unwind_Resume"
	strings:
		$1 = { 00 00 82 8C C8 FF BD 27 2C 00 B3 AF 00 80 42 30 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 34 00 BF AF 30 00 B4 AF 21 80 80 00 21 90 A0 00 21 98 C0 00 1A 00 40 14 21 88 E0 00 3B E8 03 7C 48 00 84 8C 70 8B 74 24 08 00 82 8C 11 00 54 10 00 00 00 00 18 00 A0 AF 00 00 83 C0 06 00 60 14 00 00 02 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 02 24 0F 00 00 00 03 00 40 14 00 00 00 00 ?? ?? ?? 0? 18 00 A3 AF 48 00 02 8E 21 20 40 00 08 00 54 AC 04 00 82 8C 01 00 42 24 04 00 82 AC 04 00 40 1A 21 20 00 02 3C 00 02 8E 04 00 42 34 3C 00 02 AE 21 28 60 02 ?? ?? ?? 0? 21 30 20 02 19 00 40 1A 21 88 40 00 3C 00 03 8E FB FF 02 24 24 10 62 00 3C 00 02 AE 00 00 03 8E EB FF 04 24 24 10 44 00 00 80 63 30 06 00 60 14 3C 00 02 AE 48 00 04 8E 04 00 82 8C FF FF 42 24 0C 00 40 10 04 00 82 AC 34 00 BF 8F 21 10 20 02 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? 3C 00 02 8E 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 EC FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F 3C 00 05 8E 00 00 02 8E EB FF 03 24 24 18 A3 00 00 80 42 30 21 88 80 00 06 00 40 14 3C 00 03 AE 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "sigemptyset"
		size = 84
		refs = "0000 __gnu_local_gp 001c memset 003c __libc_errno"
	strings:
		$1 = { ?? ?? 1C 3C E0 FF BD 27 ?? ?? 9C 27 1C 00 BF AF 08 00 80 10 10 00 BC AF 21 28 00 00 ?? ?? ?? 0? 80 00 06 24 21 10 00 00 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "w_addword"
		size = 228
		refs = "0034 realloc 009c calloc 00d4 free"
	strings:
		$1 = { D8 FF BD 27 1C 00 B1 AF 18 00 B0 AF 24 00 BF AF 20 00 B2 AF 21 88 A0 00 1F 00 A0 10 21 80 80 00 00 00 85 8C 08 00 82 8C 04 00 84 8C 21 28 A2 00 02 00 A5 24 ?? ?? ?? 0? 80 28 05 00 27 00 40 10 00 00 00 00 00 00 05 8E 08 00 03 8E 04 00 02 AE 01 00 A4 24 21 28 A3 00 80 28 05 00 21 30 45 00 00 00 04 AE 00 00 D1 AC 04 00 02 8E 21 18 83 00 80 18 03 00 21 18 43 00 00 00 60 AC 21 10 00 00 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 01 00 04 24 ?? ?? ?? 0? 01 00 05 24 21 90 40 00 0C 00 40 10 21 88 40 00 00 00 05 8E 08 00 02 8E 04 00 04 8E 21 28 A2 00 02 00 A5 24 ?? ?? ?? 0? 80 28 05 00 DD FF 40 14 00 00 00 00 ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? 01 00 02 24 }
	condition:
		$1
}

rule file_144_1_0 {
	meta:
		name = "w_addchar"
		size = 196
		refs = "007c realloc 0098 free 006c $LC0 00a8 $LC1 00bc __assert_fail 00ac __PRETTY_FUNCTION__.10516"
	strings:
		$1 = { D0 FF BD 27 00 00 C2 8C 28 00 B1 AF 21 88 A0 00 00 00 A5 8C 24 00 B0 AF 2C 00 BF AF 10 00 A2 10 21 80 80 00 09 00 80 10 2C 00 BF 8F 21 28 05 02 00 00 A7 A0 00 00 22 8E 01 00 42 24 21 18 02 02 00 00 22 AE 00 00 60 A0 2C 00 BF 8F 21 10 00 02 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 03 00 80 10 64 00 A2 24 0F 00 A0 10 ?? ?? 04 3C 00 00 C2 AC 21 20 00 02 65 00 A5 24 ?? ?? ?? 0? 18 00 A7 AF 04 00 40 10 18 00 A7 8F 00 00 25 8E ?? ?? ?? 0? 21 80 40 00 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 80 00 00 ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 66 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_144_2_0 {
	meta:
		name = "parse_backslash"
		size = 164
	strings:
		$1 = { D8 FF BD 27 1C 00 B0 AF 38 00 B0 8F 24 00 BF AF 20 00 B1 AF 00 00 02 8E 01 00 42 24 21 38 E2 00 00 00 E7 80 17 00 E0 10 0A 00 03 24 0F 00 E3 10 24 00 BF 8F 21 88 80 00 ?? ?? ?? 0? 00 00 84 8C 16 00 40 10 00 00 22 AE 00 00 03 8E 21 10 00 00 01 00 63 24 00 00 03 AE 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 00 00 02 AE 20 00 B1 8F 1C 00 B0 8F 21 10 00 00 08 00 E0 03 28 00 BD 27 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 05 00 02 24 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 01 00 02 24 }
	condition:
		$1
}

rule file_144_3_0 {
	meta:
		name = "parse_qtd_backslash"
		size = 348
	strings:
		$1 = { D0 FF BD 27 18 00 B0 AF 40 00 B0 8F 1C 00 B1 AF 21 88 E0 00 00 00 07 8E 28 00 B4 AF 24 00 B3 AF 01 00 E8 24 20 00 B2 AF 21 10 28 02 2C 00 BF AF 00 00 43 80 22 00 02 24 21 90 80 00 21 A0 A0 00 33 00 62 10 21 98 C0 00 23 00 62 28 0F 00 40 10 00 00 00 00 05 00 60 10 05 00 02 24 0A 00 02 24 11 00 62 14 21 10 00 00 00 00 08 AE 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 5C 00 02 24 1F 00 62 10 60 00 02 24 1D 00 62 10 24 00 02 24 1B 00 62 10 00 00 00 00 21 38 27 02 00 00 44 8E 00 00 E7 80 21 28 80 02 ?? ?? ?? 0? 21 30 60 02 0A 00 40 10 00 00 42 AE 00 00 03 8E 21 20 40 00 21 28 80 02 21 88 23 02 01 00 27 82 ?? ?? ?? 0? 21 30 60 02 11 00 40 14 00 00 42 AE 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 01 00 02 24 08 00 E0 03 30 00 BD 27 00 00 44 8E 21 28 80 02 21 30 60 02 ?? ?? ?? 0? 21 38 60 00 F1 FF 40 10 00 00 42 AE 00 00 03 8E 2C 00 BF 8F 28 00 B4 8F 01 00 63 24 00 00 03 AE 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 21 10 00 00 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_144_4_0 {
	meta:
		name = "w_addmem"
		size = 240
		refs = "0060 realloc 0080 mempcpy 00c4 free 0040 $LC0 00d4 $LC1 00e8 __assert_fail 00d8 __PRETTY_FUNCTION__.10525"
	strings:
		$1 = { D0 FF BD 27 00 00 A3 8C 24 00 B1 AF 40 00 B1 8F 00 00 C2 8C 20 00 B0 AF 21 80 80 00 21 20 71 00 2B 20 44 00 28 00 B2 AF 2C 00 BF AF 21 00 80 10 21 90 A0 00 03 00 00 12 40 18 11 00 25 00 40 10 ?? ?? 04 3C 64 00 65 2C 64 00 04 24 0B 18 85 00 21 28 62 00 00 00 C5 AC 21 20 00 02 01 00 A5 24 ?? ?? ?? 0? 18 00 A7 AF 16 00 40 10 18 00 A7 8F 00 00 44 8E 21 80 40 00 21 30 20 02 21 20 04 02 ?? ?? ?? 0? 21 28 E0 00 00 00 40 A0 00 00 42 8E 21 88 51 00 00 00 51 AE 2C 00 BF 8F 21 10 00 02 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 F8 FF 00 12 21 20 60 00 ?? ?? ?? 0? 21 30 20 02 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 80 00 00 ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 81 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_144_5_0 {
	meta:
		name = "exec_comm"
		size = 1800
		refs = "0000 __gnu_local_gp 0054 __have_pipe2 0070 __pipe2 00ac __libc_errno 00c0 __pipe 00e4 __fork 010c __close 0130 __read 0154 strchr 023c __waitpid 031c __kill 0518 free 0558 $LC2 0564 $LC3 0594 __dup2 05b4 $LC4 05bc __open 05f0 __fxstat64 061c _exit 069c $LC6 06bc __unsetenv 06b8 $LC5 06cc __environ 06d8 __execve 06e0 abort 06f8 __fcntl"
	strings:
		$1 = { ?? ?? 1C 3C 70 FE BD 27 ?? ?? 9C 27 8C 01 BF AF 88 01 BE AF 84 01 B7 AF 80 01 B6 AF 7C 01 B5 AF 78 01 B4 AF 74 01 B3 AF 70 01 B2 AF 6C 01 B1 AF 68 01 B0 AF 18 00 BC AF 90 01 A4 AF 9C 01 A7 AF E8 00 80 10 58 01 A0 AF 90 01 A3 8F 00 00 62 80 E4 00 40 10 ?? ?? 04 3C ?? ?? 82 8C 21 98 A0 00 21 B0 C0 00 16 00 40 04 50 01 B0 27 21 20 00 02 ?? ?? ?? 0? 08 00 05 3C ?? ?? 04 3C ?? ?? 83 8C 07 00 60 14 18 00 BC 8F FF FF 03 24 1A 01 43 10 01 00 04 24 ?? ?? 03 3C ?? ?? 64 AC 21 18 80 00 05 00 60 18 00 00 00 00 0A 00 41 04 ?? ?? 9E 8F ?? ?? ?? 0? 01 00 02 24 06 00 61 04 ?? ?? 9E 8F ?? ?? ?? 0? 21 20 00 02 F9 FF 40 04 18 00 BC 8F ?? ?? 9E 8F 3B E8 03 7C 21 80 00 00 21 A0 00 00 21 F0 C3 03 ?? ?? ?? 0? 00 00 00 00 60 01 A2 AF 4C 01 40 04 18 00 BC 8F 60 01 A4 8F 15 01 80 10 00 00 00 00 4D 01 00 16 ?? ?? 92 8F ?? ?? ?? 0? 54 01 A4 8F FF FF 02 24 54 01 A2 AF A4 01 A2 8F BD 00 40 10 21 90 00 00 50 01 A4 8F C0 00 A5 27 ?? ?? ?? 0? 80 00 06 24 FF FF 03 24 33 00 43 10 21 A8 40 00 35 00 40 18 00 00 00 00 ?? ?? ?? 0? 21 80 00 00 ?? ?? ?? 0? 21 28 E0 02 61 00 40 14 0A 00 04 24 02 00 02 24 8C 00 42 12 A4 01 A4 8F 00 00 65 8E ?? ?? ?? 0? 21 90 00 00 01 00 03 24 65 00 43 10 60 01 A4 8F 9C 01 A2 8F 21 A0 00 00 00 00 40 AC 00 00 C0 AE 00 00 60 AE 01 00 10 26 2A 10 15 02 E1 FF 40 10 50 01 A4 8F C0 00 A3 27 21 88 70 00 00 00 37 82 A8 01 A4 8F ?? ?? ?? 0? 21 28 E0 02 E3 FF 40 14 AC 01 A4 8F 03 00 04 24 78 00 44 12 A4 01 A4 8F 00 00 63 8E 9C 01 A6 8F 0A 00 E2 3A 01 00 94 26 21 20 60 00 21 28 C0 02 21 38 E0 02 ?? ?? ?? 0? 0B A0 02 00 45 00 40 10 00 00 62 AE ?? ?? ?? 0? 01 00 12 24 00 00 C3 8F 04 00 02 24 C5 FF 62 10 50 01 A4 8F 2B A8 15 00 ?? ?? ?? 0? 04 00 10 24 00 00 C2 8F 0A 00 50 14 00 00 00 00 60 01 A4 8F 58 01 A5 27 ?? ?? ?? 0? 21 30 A0 02 FF FF 04 24 F7 FF 44 10 00 00 00 00 B6 FF 40 10 50 01 A4 8F ?? ?? ?? 0? 04 00 10 24 00 00 C2 8F 0B 00 50 14 00 00 00 00 50 01 A4 8F C0 00 A5 27 ?? ?? ?? 0? 80 00 06 24 21 A8 40 00 FF FF 02 24 F6 FF A2 12 00 00 00 00 AF FF A0 1E 00 00 00 00 FF FF 94 26 FF FF 06 24 0A 00 05 24 A3 00 86 12 00 00 00 00 00 00 C3 8E A0 00 60 10 FF FF 63 24 00 00 62 8E 21 10 43 00 00 00 44 80 9B 00 85 14 00 00 00 00 00 00 C3 AE 00 00 40 A0 00 00 C2 8E 90 00 40 10 FF FF 83 26 ?? ?? ?? 0? 21 A0 60 00 2F 00 E4 12 FD FF 04 24 24 18 44 02 01 00 02 24 A9 FF 62 14 A4 01 A4 8F 00 00 65 8E ?? ?? ?? 0? 02 00 12 24 01 00 03 24 9F FF 43 14 9C 01 A2 8F 60 01 A4 8F 09 00 05 24 ?? ?? ?? 0? FF FF 10 24 18 00 BC 8F 3B E8 03 7C 04 00 11 24 ?? ?? 92 8F ?? ?? ?? 0? 21 90 43 02 00 00 42 8E 07 00 51 14 00 00 00 00 60 01 A4 8F 21 28 00 00 ?? ?? ?? 0? 21 30 00 00 F8 FF 50 10 00 00 00 00 ?? ?? ?? 0? 50 01 A4 8F 01 00 02 24 8C 01 BF 8F 88 01 BE 8F 84 01 B7 8F 80 01 B6 8F 7C 01 B5 8F 78 01 B4 8F 74 01 B3 8F 70 01 B2 8F 6C 01 B1 8F 68 01 B0 8F 08 00 E0 03 90 01 BD 27 ?? ?? ?? 0? 21 90 00 00 01 00 42 3A 03 00 03 24 ?? ?? ?? 0? 0A 90 62 00 00 00 65 8E ?? ?? ?? 0? 64 01 A2 AF 01 00 04 24 D3 FF 44 10 64 01 A3 8F 9C 01 A2 8F 00 00 37 82 00 00 40 AC 00 00 C0 AE ?? ?? ?? 0? 00 00 60 AE 8C 01 BF 8F 88 01 BE 8F 84 01 B7 8F 80 01 B6 8F 7C 01 B5 8F 78 01 B4 8F 74 01 B3 8F 70 01 B2 8F 6C 01 B1 8F 68 01 B0 8F 21 10 00 00 08 00 E0 03 90 01 BD 27 FF FF 10 24 50 01 A4 8F C0 00 A5 27 ?? ?? ?? 0? 80 00 06 24 12 00 50 10 00 00 00 00 14 00 40 18 2B 88 02 00 00 00 64 8E 9C 01 A6 8F 10 00 A2 AF 21 28 C0 02 C0 00 A7 27 ?? ?? ?? 0? 21 A0 82 02 AE FF 40 10 00 00 62 AE 50 01 A4 8F C0 00 A5 27 ?? ?? ?? 0? 80 00 06 24 F0 FF 50 14 00 00 00 00 00 00 C4 8F 04 00 03 24 E6 FF 83 10 2B 88 02 00 ?? ?? ?? 0? 04 00 12 24 00 00 C2 8F 09 00 52 14 00 00 00 00 60 01 A4 8F 58 01 A5 27 ?? ?? ?? 0? 21 30 20 02 F8 FF 50 10 00 00 00 00 DA FF 40 10 50 01 A4 8F ?? ?? ?? 0? 04 00 12 24 00 00 C2 8F 72 FF 52 14 00 00 00 00 50 01 A4 8F C0 00 A5 27 ?? ?? ?? 0? 80 00 06 24 F8 FF 50 10 00 00 00 00 D4 FF 40 1C 00 00 00 00 ?? ?? ?? 0? FF FF 94 26 3B E8 03 7C 21 28 60 00 ?? ?? 83 8F 21 28 65 00 00 00 A3 8C 59 00 63 38 ?? ?? ?? 0? 0A 20 43 00 ?? ?? ?? 0? 00 00 64 8E 9C 01 A3 8F 00 00 60 AC 00 00 C0 AE 00 00 60 AE ?? ?? ?? 0? 50 01 A4 8F FF FF 02 24 50 01 A2 AF 58 01 A2 8F A7 FF 40 10 01 00 10 24 ?? ?? ?? 0? 00 00 00 00 4E 00 00 16 ?? ?? 10 3C ?? ?? 02 26 40 01 A2 AF ?? ?? 02 3C ?? ?? 42 24 A0 01 B1 8F 44 01 A2 AF 90 01 A2 8F 10 00 31 32 4C 01 A0 AF 48 01 A2 AF 54 01 A4 8F 01 00 02 24 56 00 82 10 ?? ?? 03 3C ?? ?? ?? 0? 01 00 05 24 ?? ?? ?? 0? 54 01 A4 8F 45 00 20 16 ?? ?? 04 3C ?? ?? ?? 0? 02 00 04 24 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 01 00 05 24 08 00 40 04 21 88 40 00 02 00 02 24 05 00 22 12 21 20 20 02 ?? ?? ?? 0? 02 00 05 24 ?? ?? ?? 0? 21 20 20 02 03 00 04 24 02 00 05 24 ?? ?? ?? 0? 20 00 A6 27 08 00 40 14 38 00 A3 8F 00 20 02 24 00 F0 63 30 04 00 62 14 48 00 A3 8F 03 01 02 24 28 00 62 10 00 00 00 00 ?? ?? ?? 0? 5A 00 04 24 ?? ?? ?? 0? 50 01 A4 8F ?? ?? ?? 0? 54 01 A4 8F ?? ?? ?? 0? 01 00 02 24 3B E8 03 7C FF FF 10 24 21 90 43 02 ?? ?? ?? 0? 04 00 11 24 00 00 42 8E 64 FF 51 14 8C 01 BF 8F 60 01 A4 8F 58 01 A5 27 ?? ?? ?? 0? 21 30 00 00 F8 FF 50 10 21 18 40 00 60 01 A4 8F 3C FF 83 14 21 10 00 00 58 01 A3 8F 05 00 02 24 ?? ?? ?? 0? 0A 10 03 00 ?? ?? 02 26 90 01 A4 8F 40 01 A2 AF ?? ?? 02 3C ?? ?? 42 24 48 01 A4 AF 4C 01 A0 AF 44 01 A2 AF ?? ?? ?? 0? 21 88 00 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? ?? 0? 50 01 A4 8F ?? ?? 02 3C ?? ?? 46 8C ?? ?? 04 26 ?? ?? ?? 0? 40 01 A5 27 ?? ?? ?? 0? 00 00 00 00 ?? ?? 62 8C AD FF 40 18 02 00 05 24 01 00 04 24 ?? ?? ?? 0? 21 30 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_144_6_0 {
	meta:
		name = "parse_backtick"
		size = 428
		refs = "00b4 free"
	strings:
		$1 = { 98 FF BD 27 44 00 B0 AF 78 00 B0 8F 60 00 B7 AF 64 00 BF AF 00 00 03 8E 5C 00 B6 AF 58 00 B5 AF 54 00 B4 AF 50 00 B3 AF 4C 00 B2 AF 48 00 B1 AF 21 10 E3 00 21 B8 E0 00 00 00 47 80 2C 00 A0 AF 30 00 A0 AF 57 00 E0 10 28 00 A0 AF 21 B0 80 00 21 A8 A0 00 21 A0 C0 00 21 90 00 00 5C 00 11 24 60 00 13 24 33 00 F1 10 00 00 00 00 15 00 F3 10 27 00 03 24 03 00 E3 14 28 00 A4 8F 01 00 03 24 23 90 72 00 30 00 A5 27 ?? ?? ?? 0? 2C 00 A6 27 42 00 40 10 28 00 A2 AF 00 00 03 8E 01 00 63 24 00 00 03 AE 21 10 E3 02 00 00 47 80 ED FF E0 14 28 00 A4 8F ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 05 00 02 24 7C 00 A2 8F 28 00 A4 8F 21 28 C0 02 10 00 A2 AF 80 00 A2 8F 21 30 A0 02 21 38 80 02 14 00 A2 AF 84 00 A2 8F 18 00 A2 AF 88 00 A2 8F ?? ?? ?? 0? 1C 00 A2 AF 28 00 A4 8F ?? ?? ?? 0? 21 80 40 00 21 10 00 02 64 00 BF 8F 60 00 B7 8F 5C 00 B6 8F 58 00 B5 8F 54 00 B4 8F 50 00 B3 8F 4C 00 B2 8F 48 00 B1 8F 44 00 B0 8F 08 00 E0 03 68 00 BD 27 0B 00 40 12 01 00 63 24 10 00 B0 AF 28 00 A4 27 30 00 A5 27 2C 00 A6 27 ?? ?? ?? 0? 21 38 E0 02 0C 00 40 14 01 00 12 24 ?? ?? ?? 0? 00 00 03 8E 00 00 03 AE 28 00 A4 27 10 00 B0 AF 30 00 A5 27 2C 00 A6 27 ?? ?? ?? 0? 21 38 E0 02 C5 FF 40 10 00 00 00 00 28 00 A4 8F ?? ?? ?? 0? 38 00 A2 AF ?? ?? ?? 0? 38 00 A2 8F ?? ?? ?? 0? 01 00 02 24 ?? ?? ?? 0? 21 20 00 00 }
	condition:
		$1
}

rule file_144_7_0 {
	meta:
		name = "eval_expr_multdiv"
		size = 332
		refs = "0000 __gnu_local_gp 0068 __libc_tsd_CTYPE_B"
	strings:
		$1 = { ?? ?? 1C 3C C8 FF BD 27 ?? ?? 9C 27 30 00 B4 AF 28 00 B2 AF 24 00 B1 AF 10 00 BC AF 34 00 BF AF 2C 00 B3 AF 20 00 B0 AF 21 90 80 00 ?? ?? ?? 0? 21 A0 A0 00 21 88 40 00 0B 00 40 10 10 00 BC 8F 05 00 11 24 34 00 BF 8F 21 10 20 02 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? 93 8F 3B E8 03 7C 2A 00 10 24 21 98 63 02 00 00 47 8E 00 00 E6 80 F0 FF C0 10 40 10 06 00 00 00 63 8E 21 10 62 00 00 00 42 94 00 20 42 30 11 00 40 10 00 00 00 00 ?? ?? ?? 0? 01 00 E3 24 00 00 66 80 01 00 63 24 E4 FF C0 10 40 40 06 00 00 00 62 8E 21 40 48 00 00 00 08 95 00 20 08 31 05 00 00 11 00 00 00 00 21 38 60 00 F4 FF 60 14 00 00 43 AE 00 00 06 80 0F 00 D0 10 2F 00 02 24 D6 FF C2 14 01 00 E7 24 00 00 47 AE 21 20 40 02 ?? ?? ?? 0? 18 00 A5 27 CF FF 40 14 18 00 A2 8F 00 00 83 8E 1A 00 62 00 F4 01 40 00 12 10 00 00 ?? ?? ?? 0? 00 00 82 AE 01 00 E7 24 00 00 47 AE 21 20 40 02 ?? ?? ?? 0? 18 00 A5 27 C2 FF 40 14 18 00 A2 8F 00 00 83 8E 02 10 62 70 ?? ?? ?? 0? 00 00 82 AE }
	condition:
		$1
}

rule file_144_8_0 {
	meta:
		name = "eval_expr_val"
		size = 364
		refs = "0010 __gnu_local_gp 0038 __libc_tsd_CTYPE_B 0110 strtol"
	strings:
		$1 = { D8 FF BD 27 1C 00 B1 AF 21 88 80 00 00 00 84 8C ?? ?? 1C 3C ?? ?? 9C 27 20 00 B2 AF 24 00 BF AF 18 00 B0 AF 10 00 BC AF 1B 00 80 10 21 90 A0 00 00 00 82 80 33 00 40 10 ?? ?? 85 8F 3B E8 03 7C 21 30 60 00 21 30 A6 00 00 00 C6 8C 40 18 02 00 21 18 C3 00 00 00 63 94 00 20 63 30 0B 00 60 14 21 80 80 00 ?? ?? ?? 0? 28 00 03 24 00 00 02 82 40 18 02 00 24 00 40 10 21 18 C3 00 00 00 63 94 00 20 63 30 07 00 60 10 28 00 03 24 01 00 10 26 F6 FF 00 16 00 00 00 00 00 00 02 80 21 80 00 00 28 00 03 24 18 00 43 14 00 00 00 00 00 00 82 80 0E 00 40 10 24 00 BF 8F 29 00 03 24 20 00 43 10 01 00 82 24 ?? ?? ?? 0? 29 00 04 24 1D 00 64 10 00 00 00 00 00 00 22 AE 00 00 43 80 21 30 40 00 FA FF 60 14 01 00 42 24 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 05 00 02 24 08 00 E0 03 28 00 BD 27 21 80 80 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 21 30 00 00 00 00 23 8E F2 FF 70 10 00 00 42 AE 21 10 00 00 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 21 30 80 00 01 00 C2 24 00 00 22 AE 01 00 04 26 00 00 C0 A0 ?? ?? ?? 0? 21 28 40 02 E3 FF 40 14 24 00 BF 8F ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_144_9_0 {
	meta:
		name = "eval_expr"
		size = 320
		refs = "0004 __gnu_local_gp 0064 __libc_tsd_CTYPE_B"
	strings:
		$1 = { C8 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 38 00 A4 AF 38 00 A4 27 30 00 B3 AF 2C 00 B2 AF 10 00 BC AF 34 00 BF AF 28 00 B1 AF 24 00 B0 AF ?? ?? ?? 0? 21 98 A0 00 21 90 40 00 0A 00 40 10 10 00 BC 8F 05 00 12 24 34 00 BF 8F 21 10 40 02 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? 91 8F 3B E8 03 7C 2B 00 10 24 21 88 23 02 38 00 A7 8F 00 00 E4 80 F1 FF 80 10 40 18 04 00 00 00 22 8E 21 18 43 00 00 00 63 94 00 20 63 30 11 00 60 10 00 00 00 00 ?? ?? ?? 0? 01 00 E3 24 00 00 64 80 01 00 63 24 40 30 04 00 E4 FF 80 10 21 30 46 00 00 00 C6 94 00 20 C6 30 06 00 C0 10 00 00 00 00 38 00 A3 AF F5 FF 60 14 21 38 60 00 00 00 04 80 21 38 00 00 0D 00 90 10 2D 00 02 24 D7 FF 82 14 01 00 E7 24 38 00 A4 27 18 00 A5 27 ?? ?? ?? 0? 38 00 A7 AF D0 FF 40 14 18 00 A2 8F 00 00 63 8E 23 10 62 00 ?? ?? ?? 0? 00 00 62 AE 01 00 E7 24 38 00 A4 27 18 00 A5 27 ?? ?? ?? 0? 38 00 A7 AF C5 FF 40 14 18 00 A2 8F 00 00 63 8E 21 10 62 00 ?? ?? ?? 0? 00 00 62 AE }
	condition:
		$1
}

rule file_144_10_0 {
	meta:
		name = "w_addstr"
		size = 112
		refs = "0020 strlen 0050 $LC7 0054 $LC1 0068 __assert_fail 0058 __PRETTY_FUNCTION__.10533"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 11 00 E0 10 30 00 B0 AF 21 80 80 00 21 20 E0 00 20 00 A5 AF 24 00 A6 AF ?? ?? ?? 0? 28 00 A7 AF 20 00 A5 8F 24 00 A6 8F 28 00 A7 8F 21 20 00 02 ?? ?? ?? 0? 10 00 A2 AF 34 00 BF 8F 30 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 9B 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_144_11_0 {
	meta:
		name = "parse_tilde"
		size = 1088
		refs = "0008 __gnu_local_gp 0074 strchr 0130 __strnlen 0158 memcpy 016c __libc_errno 01c8 __getpwnam_r 02f4 getenv 02f0 $LC8 0354 __getuid 03c0 __getpwuid_r"
	strings:
		$1 = { 00 00 A2 8C 90 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 68 00 BE AF 21 F0 A0 03 6C 00 BF AF 64 00 B7 AF 60 00 B6 AF 5C 00 B5 AF 58 00 B4 AF 54 00 B3 AF 50 00 B2 AF 4C 00 B1 AF 48 00 B0 AF 18 00 DC AF 74 00 C5 AF 70 00 C4 AF 11 00 40 10 78 00 C6 AF 00 00 90 8C 3D 00 03 24 21 10 02 02 FF FF 42 80 08 00 43 10 3A 00 03 24 79 00 43 14 21 20 00 02 3D 00 05 24 ?? ?? ?? 0? 40 00 C7 AF 74 00 40 10 40 00 C7 8F 84 00 C2 8F 72 00 40 14 74 00 C5 8F 80 00 C2 8F DF FF 03 24 00 00 45 8C 01 00 AD 24 21 88 ED 00 00 00 22 82 24 18 43 00 90 00 60 10 3A 00 03 24 8E 00 43 10 2F 00 03 24 8C 00 43 10 09 00 03 24 8A 00 43 10 5C 00 03 24 97 00 43 10 21 80 A0 01 DF FF 08 24 3A 00 09 24 2F 00 0A 24 09 00 0B 24 ?? ?? ?? 0? 5C 00 0C 24 0D 00 49 10 00 00 00 00 0B 00 4A 10 00 00 00 00 09 00 4B 10 00 00 00 00 89 00 4C 10 21 80 60 00 01 00 03 26 21 10 E3 00 00 00 42 80 24 30 48 00 F3 FF C0 14 00 00 00 00 73 00 A3 11 ?? ?? 04 3C 21 20 20 02 ?? ?? ?? 0? 23 28 05 02 0F 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 A4 27 21 18 82 00 21 28 20 02 00 00 60 A0 ?? ?? ?? 0? 21 30 40 00 18 00 DC 8F 10 FC BD 27 3B E8 03 7C ?? ?? 95 8F 21 90 40 00 18 00 B4 27 E8 03 16 24 3C 00 D1 27 20 00 D7 27 21 A8 A3 02 ?? ?? ?? 0? F0 FF 13 24 00 00 A2 8E 22 00 05 24 42 00 45 14 21 B0 60 00 23 E8 A4 03 18 00 A2 27 21 20 43 00 26 48 84 02 0A B0 09 01 21 A0 40 00 21 20 40 02 10 00 B1 AF 21 30 80 02 21 38 C0 02 ?? ?? ?? 0? 21 28 E0 02 F7 03 C3 26 24 18 73 00 08 00 64 24 EC FF 40 14 21 40 76 00 3C 00 C2 8F 2E 00 40 10 34 00 C7 8F 2C 00 E0 10 70 00 C2 8F 74 00 C5 8F 78 00 C6 8F ?? ?? ?? 0? 00 00 44 8C 70 00 C3 8F 00 00 62 AC 80 00 C3 8F 00 00 70 AC 01 00 42 2C 21 E8 C0 03 6C 00 BF 8F 68 00 BE 8F 64 00 B7 8F 60 00 B6 8F 5C 00 B5 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 08 00 E0 03 70 00 BD 27 74 00 C5 8F 78 00 C6 8F 21 20 00 02 ?? ?? ?? 0? 7E 00 07 24 70 00 C3 8F 00 00 62 AC 01 00 42 2C 21 E8 C0 03 6C 00 BF 8F 68 00 BE 8F 64 00 B7 8F 60 00 B6 8F 5C 00 B5 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 08 00 E0 03 70 00 BD 27 70 00 C5 8F 78 00 C6 8F 7E 00 07 24 00 00 A4 8C ?? ?? ?? 0? 74 00 C5 8F 70 00 C3 8F D3 FF 40 10 00 00 62 AC 74 00 C5 8F 78 00 C6 8F 21 20 40 00 ?? ?? ?? 0? 21 38 40 02 70 00 C5 8F 80 00 C3 8F 00 00 A2 AC ?? ?? ?? 0? 00 00 70 AC ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 15 00 40 10 70 00 C3 8F 74 00 C5 8F 78 00 C6 8F 00 00 64 8C ?? ?? ?? 0? 21 38 40 00 70 00 C5 8F BE FF 40 14 00 00 A2 AC ?? ?? ?? 0? 01 00 02 24 70 00 C3 8F 74 00 C5 8F 78 00 C6 8F 00 00 64 8C ?? ?? ?? 0? 7E 00 07 24 70 00 C5 8F 00 00 A2 AC ?? ?? ?? 0? 01 00 42 2C ?? ?? ?? 0? E8 03 14 24 18 00 DC 8F 10 FC BD 27 3B E8 03 7C ?? ?? 88 8F 21 90 40 00 18 00 B5 27 3C 00 D1 27 20 00 D7 27 21 B0 03 01 22 00 13 24 ?? ?? ?? 0? F0 FF 10 24 00 00 C2 8E 21 00 53 14 70 00 C5 8F 23 E8 A4 03 18 00 A2 27 21 20 43 00 26 A8 A4 02 0B A0 75 00 21 A8 40 00 21 38 80 02 21 20 40 02 10 00 B1 AF 21 30 A0 02 ?? ?? ?? 0? 21 28 E0 02 F7 03 83 26 24 18 70 00 08 00 64 24 ED FF 40 14 21 A0 74 00 3C 00 C2 8F 0C 00 40 10 34 00 C7 8F 0A 00 E0 10 70 00 C2 8F 74 00 C5 8F 78 00 C6 8F ?? ?? ?? 0? 00 00 44 8C 70 00 C3 8F C7 FF 40 10 00 00 62 AC ?? ?? ?? 0? 01 00 42 2C 70 00 C5 8F 78 00 C6 8F 7E 00 07 24 00 00 A4 8C ?? ?? ?? 0? 74 00 C5 8F 70 00 C3 8F BC FF 40 10 00 00 62 AC ?? ?? ?? 0? 01 00 42 2C }
	condition:
		$1
}

rule file_144_12_0 {
	meta:
		name = "parse_arith"
		size = 952
		refs = "00f4 free 02c0 _itoa_word 035c _itoa"
	strings:
		$1 = { 78 FF BD 27 64 00 B0 AF 98 00 B0 8F 80 00 B7 AF 84 00 BF AF 00 00 03 8E 7C 00 B6 AF 78 00 B5 AF 74 00 B4 AF 70 00 B3 AF 6C 00 B2 AF 68 00 B1 AF 21 10 E3 00 21 B8 E0 00 00 00 47 80 50 00 A0 AF 54 00 A0 AF AB 00 E0 10 4C 00 A0 AF 21 A0 80 00 21 B0 A0 00 21 A8 C0 00 01 00 12 24 3B 00 11 24 60 00 13 24 75 00 F1 10 3C 00 E4 28 25 00 80 10 24 00 04 24 5B 00 E4 10 25 00 E4 28 7D 00 80 14 28 00 04 24 0D 00 E4 10 29 00 04 24 0D 00 E4 14 4C 00 A4 8F FF FF 52 26 9E 00 40 12 54 00 A5 27 50 00 A6 27 ?? ?? ?? 0? 29 00 07 24 0A 00 40 14 4C 00 A2 AF ?? ?? ?? 0? 01 00 02 24 01 00 52 26 4C 00 A4 8F 54 00 A5 27 ?? ?? ?? 0? 50 00 A6 27 F8 FF 40 10 4C 00 A2 AF 00 00 03 8E 01 00 63 24 00 00 03 AE 21 10 E3 02 00 00 47 80 DD FF E0 14 4C 00 A4 8F ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 05 00 02 24 1B 00 F3 10 9C 00 A2 8F 61 00 E3 28 45 00 60 10 5C 00 03 24 28 00 E3 10 5D 00 03 24 E7 FF E3 14 A0 00 A2 8F 04 00 40 10 4C 00 A4 8F 01 00 02 24 56 00 42 12 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 05 00 02 24 84 00 BF 8F 80 00 B7 8F 7C 00 B6 8F 78 00 B5 8F 74 00 B4 8F 70 00 B3 8F 6C 00 B2 8F 68 00 B1 8F 64 00 B0 8F 08 00 E0 03 88 00 BD 27 01 00 63 24 00 00 03 AE 4C 00 A4 27 10 00 B0 AF 14 00 A2 AF 18 00 A0 AF 1C 00 A0 AF 20 00 A0 AF 54 00 A5 27 50 00 A6 27 ?? ?? ?? 0? 21 38 E0 02 CC FF 40 10 4C 00 A4 8F ?? ?? ?? 0? 58 00 A2 AF ?? ?? ?? 0? 58 00 A2 8F 10 00 B0 AF 4C 00 A4 27 54 00 A5 27 50 00 A6 27 ?? ?? ?? 0? 21 38 E0 02 C0 FF 40 10 4C 00 A4 8F ?? ?? ?? 0? 00 00 00 00 9C 00 A2 8F 10 00 B0 AF 18 00 A0 AF 14 00 A2 AF 01 00 02 24 1C 00 A0 AF 20 00 A0 AF 24 00 A2 AF 4C 00 A4 27 54 00 A5 27 50 00 A6 27 ?? ?? ?? 0? 21 38 E0 02 AF FF 40 10 4C 00 A4 8F ?? ?? ?? 0? 00 00 00 00 7B 00 03 24 03 00 E3 10 7D 00 03 24 A3 FF E3 14 4C 00 A4 8F ?? ?? ?? 0? 4C 00 A4 8F 02 00 02 24 84 00 BF 8F 80 00 B7 8F 7C 00 B6 8F 78 00 B5 8F 74 00 B4 8F 70 00 B3 8F 6C 00 B2 8F 68 00 B1 8F 64 00 B0 8F 08 00 E0 03 88 00 BD 27 0A 00 03 24 91 FF E3 14 00 00 00 00 ?? ?? ?? 0? 4C 00 A4 8F ?? ?? ?? 0? 02 00 02 24 48 00 A0 AF 00 00 82 80 18 00 40 10 00 00 00 00 ?? ?? ?? 0? 48 00 A5 27 16 00 40 14 48 00 A4 8F 00 00 90 8E 21 38 00 00 44 00 A5 27 0A 00 06 24 ?? ?? ?? 0? 44 00 A0 A3 21 38 40 00 21 20 00 02 21 28 C0 02 ?? ?? ?? 0? 21 30 A0 02 4C 00 A4 8F ?? ?? ?? 0? 00 00 82 AE 00 00 82 8E ?? ?? ?? 0? 01 00 42 2C ?? ?? ?? 0? 21 20 00 00 ?? ?? ?? 0? 21 20 00 00 ?? ?? ?? 0? 4C 00 A4 8F ?? ?? ?? 0? 05 00 02 24 A0 00 A2 8F FA FF 40 14 48 00 A0 AF 01 00 63 24 21 B8 E3 02 00 00 E4 82 F5 FF 87 14 4C 00 A4 8F 00 00 03 AE 00 00 82 80 0C 00 40 14 21 80 00 00 C3 2F 10 00 00 00 91 8E 21 20 00 02 0A 00 07 24 44 00 A6 27 10 00 A0 AF ?? ?? ?? 0? 44 00 A0 A3 21 38 40 00 ?? ?? ?? 0? 21 20 20 02 ?? ?? ?? 0? 48 00 A5 27 E2 FF 40 14 48 00 B0 8F F0 FF 01 06 21 28 C0 02 00 00 84 8E 21 30 A0 02 ?? ?? ?? 0? 2D 00 07 24 23 80 10 00 C3 2F 10 00 E9 FF 40 14 00 00 82 AE ?? ?? ?? 0? 4C 00 A4 8F ?? ?? ?? 0? 01 00 02 24 }
	condition:
		$1
}

rule file_144_13_0 {
	meta:
		name = "parse_dollars"
		size = 5756
		refs = "0010 __gnu_local_gp 0188 __libc_tsd_CTYPE_B 022c free 04f4 $LC11 04f8 $LC1 050c __assert_fail 04fc __PRETTY_FUNCTION__.10919 01c4 $LC9 0540 strchr 07dc strtol 07e4 __libc_argc 0964 $LC12 09c0 strlen 09d4 _itoa_word 0a38 __strdup 0a54 __setenv 0ab4 strspn 0ad8 strcspn 0c50 fnmatch 0c68 malloc 0c80 mempcpy 0e70 getenv 0f04 __libc_argv 0f2c $LC10 0ff8 __getpid 1020 pthread_setcancelstate 10e4 _libc_intl_domainname 10e8 $LC14 10f4 __dcgettext 10fc $LC15 110c __fxprintf 1164 $LC16 13c0 $LC13 14d8 stpcpy"
	strings:
		$1 = { 38 FF BD 27 B4 00 B5 AF D8 00 B5 8F A4 00 B1 AF ?? ?? 1C 3C 00 00 B1 8E ?? ?? 9C 27 AC 00 B3 AF 01 00 23 26 A8 00 B2 AF A0 00 B0 AF C4 00 BF AF C0 00 BE AF BC 00 B7 AF B8 00 B6 AF B0 00 B4 AF 28 00 BC AF 21 90 E3 00 00 00 42 82 27 00 09 24 21 80 E0 00 21 98 80 00 CC 00 A5 AF 84 00 49 10 D0 00 A6 AF 28 00 49 28 30 00 20 15 28 00 09 24 18 00 49 10 5B 00 09 24 30 00 49 14 01 00 02 24 DC 00 A3 8F 02 00 31 26 00 00 B1 AE 10 00 B5 AF 14 00 A3 AF ?? ?? ?? 0? 18 00 A2 AF 21 F0 40 00 C4 00 BF 8F 21 10 C0 03 BC 00 B7 8F C0 00 BE 8F B8 00 B6 8F B4 00 B5 8F B0 00 B4 8F AC 00 B3 8F A8 00 B2 8F A4 00 B1 8F A0 00 B0 8F 08 00 E0 03 C8 00 BD 27 02 00 27 26 21 50 07 02 00 00 43 81 A3 00 62 10 00 00 00 00 DC 00 A3 8F 04 00 7E 30 73 00 C0 13 C4 00 BF 8F 04 00 1E 24 21 10 C0 03 BC 00 B7 8F C0 00 BE 8F B8 00 B6 8F B4 00 B5 8F B0 00 B4 8F AC 00 B3 8F A8 00 B2 8F A4 00 B1 8F A0 00 B0 8F 08 00 E0 03 C8 00 BD 27 50 00 40 10 22 00 04 24 4E 00 44 10 00 00 00 00 00 00 A3 AE 00 00 47 82 74 00 A0 AF 78 00 A0 AF 7B 00 FE 38 01 00 DE 2F 80 00 BE AF 6C 00 A0 AF F1 00 C0 13 70 00 A0 AF 02 00 22 26 21 18 02 02 00 00 A2 AE 00 00 67 80 23 00 03 24 0B 01 E3 10 03 00 36 26 21 B0 40 00 8C 00 A0 AF ?? ?? 84 8F 3B E8 03 7C 21 28 60 00 21 28 85 00 00 00 A2 8C 40 18 07 00 21 28 43 00 00 00 A5 94 00 04 A5 30 9C 00 A0 14 5F 00 02 24 9A 00 E2 10 D0 FF E2 24 0A 00 42 2C DD 00 40 10 ?? ?? 04 3C 21 A0 00 00 78 00 B7 27 ?? ?? ?? 0? 74 00 BE 27 80 00 A8 8F 37 03 00 11 01 00 03 24 00 00 A2 8E 01 00 42 24 21 20 02 02 00 00 A2 AE 00 00 87 80 D0 FF E4 24 0A 00 84 2C 34 03 80 10 21 B0 40 00 21 20 80 02 21 28 E0 02 ?? ?? ?? 0? 21 30 C0 03 EF FF 40 14 21 A0 40 00 01 00 1E 24 21 B8 00 00 21 A0 00 00 ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 21 20 E0 02 C4 00 BF 8F 21 10 C0 03 BC 00 B7 8F C0 00 BE 8F B8 00 B6 8F B4 00 B5 8F B0 00 B4 8F AC 00 B3 8F A8 00 B2 8F A4 00 B1 8F A0 00 B0 8F 08 00 E0 03 C8 00 BD 27 00 00 64 8E CC 00 A5 8F D0 00 A6 8F ?? ?? ?? 0? 24 00 07 24 00 00 62 AE 01 00 5E 2C C4 00 BF 8F 21 10 C0 03 BC 00 B7 8F C0 00 BE 8F B8 00 B6 8F B4 00 B5 8F B0 00 B4 8F AC 00 B3 8F A8 00 B2 8F A4 00 B1 8F A0 00 B0 8F 08 00 E0 03 C8 00 BD 27 00 00 A7 AE E0 00 A8 8F EC 00 A2 8F 00 00 47 81 48 00 A0 AF 0B 40 02 00 84 00 A8 AF 60 00 A0 AF 1F 00 E0 10 21 A0 00 00 01 00 16 24 21 88 00 00 27 00 12 24 28 00 17 24 43 00 F2 10 28 00 E2 28 37 00 40 14 22 00 02 24 3C 00 F7 10 29 00 02 24 07 00 E2 14 21 20 80 02 06 00 20 16 60 00 A5 27 FF FF D6 26 3D 03 C0 12 00 00 00 00 21 20 80 02 60 00 A5 27 ?? ?? ?? 0? 48 00 A6 27 98 00 40 10 21 A0 40 00 00 00 A4 8E 01 00 84 24 00 00 A4 AE 21 20 04 02 00 00 87 80 E7 FF E0 14 00 00 00 00 ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 05 00 1E 24 03 00 31 26 21 10 11 02 00 00 42 80 5A FF 40 10 21 18 20 02 21 28 20 02 21 20 00 00 29 00 09 24 28 00 06 24 07 00 80 14 00 00 00 00 EE 00 49 10 00 00 00 00 07 00 46 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 FD FF 46 10 29 00 42 38 01 00 42 2C 23 20 82 00 01 00 63 24 21 10 03 02 00 00 42 80 F0 FF 40 14 21 28 60 00 ?? ?? ?? 0? DC 00 A3 8F D3 FF E2 14 21 20 80 02 4A 00 20 12 00 00 00 00 02 00 31 3A ?? ?? ?? 0? 2B 88 11 00 01 00 22 2E ?? ?? ?? 0? 21 B0 C2 02 44 00 20 12 02 00 03 24 01 00 31 3A 0A 18 11 00 ?? ?? ?? 0? 21 88 60 00 3B E8 03 7C 21 A0 00 00 78 00 B7 27 74 00 BE 27 21 B0 83 00 21 20 80 02 21 28 E0 02 ?? ?? ?? 0? 21 30 C0 03 76 FF 40 10 21 A0 40 00 00 00 A2 8E 00 00 C5 8E 01 00 42 24 21 20 02 02 00 00 A2 AE 00 00 87 80 40 20 07 00 21 20 A4 00 00 00 84 94 08 00 84 30 EF FF 80 14 5F 00 03 24 EE FF E3 10 21 20 80 02 21 B0 40 00 90 00 A0 AF 80 00 A8 8F 4B 00 00 15 21 B8 00 00 FF FF D6 26 94 00 A0 AF 88 00 A0 AF 00 00 B6 AE 00 00 47 82 7B 00 02 24 33 00 E2 10 00 00 00 00 74 02 80 12 8C 00 A8 8F 00 00 82 82 D0 FF 44 24 0A 00 84 2C C1 00 80 14 90 00 A3 8F 66 02 60 10 24 00 04 24 C6 02 44 10 00 00 00 00 2A 00 04 24 35 04 44 10 40 00 04 24 DF 03 44 10 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 DF 05 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? ?? 0? 02 00 11 24 ?? ?? ?? 0? 01 00 11 24 23 00 02 24 BC 03 E2 10 21 B0 60 00 ?? ?? ?? 0? 8C 00 A0 AF 21 28 E0 00 ?? ?? 84 24 ?? ?? ?? 0? 98 00 A7 AF 64 02 40 10 98 00 A7 8F 21 20 00 00 78 00 A5 27 ?? ?? ?? 0? 74 00 A6 27 2F FF 40 10 21 A0 40 00 00 00 B6 8E 01 00 03 24 90 00 A3 AF 01 00 D6 26 ?? ?? ?? 0? 00 00 B6 AE 00 00 A2 8E 21 80 02 02 00 00 04 82 7D 00 02 24 26 FF 82 14 05 00 1E 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 01 00 1E 24 00 00 B6 AE 21 10 16 02 01 00 08 24 00 00 47 80 ?? ?? ?? 0? 8C 00 A8 AF 21 10 16 02 00 00 47 80 2D 00 02 24 76 02 E2 10 01 00 C4 26 2E 00 E2 28 6F 00 40 10 3D 00 02 24 25 00 02 24 69 02 E2 10 2B 00 02 24 6E 02 E2 10 00 00 00 00 23 00 02 24 61 02 E2 14 21 10 04 02 00 00 45 80 AC 02 A7 10 23 00 03 24 94 00 A0 AF 88 00 A3 AF 00 00 A4 AE 00 00 45 80 E1 02 A0 10 21 B0 00 00 21 B8 00 00 80 00 A0 AF 5C 00 1E 24 36 00 BE 10 5D 00 A2 28 1E 00 40 10 22 00 02 24 28 00 A2 10 27 00 02 24 06 00 A2 14 00 00 00 00 3D 00 C0 12 02 00 02 24 01 00 D6 3A 0A 10 16 00 21 B0 40 00 00 00 A2 8E 21 20 E0 02 70 00 A5 27 21 10 02 02 00 00 47 80 ?? ?? ?? 0? 6C 00 A6 27 2F 00 40 10 21 B8 40 00 00 00 A4 8E 01 00 84 24 00 00 A4 AE 21 10 04 02 00 00 45 80 E4 FF A0 14 00 00 00 00 21 B0 80 00 FF FF D6 26 ?? ?? ?? 0? 00 00 B6 AE 7B 00 02 24 0F 00 A2 10 7D 00 03 24 E8 FF A3 14 00 00 00 00 E6 FF C0 16 80 00 A3 8F 75 FF 60 10 80 00 A8 8F FF FF 08 25 ?? ?? ?? 0? 80 00 A8 AF 1A 00 C0 12 00 00 00 00 02 00 D6 3A ?? ?? ?? 0? 2B B0 16 00 80 00 A8 8F 01 00 C2 2E 21 40 02 01 ?? ?? ?? 0? 80 00 A8 AF D5 FF C0 16 01 00 84 24 00 00 A4 AE 21 20 04 02 00 00 82 80 9C 02 40 10 21 20 E0 02 70 00 A5 27 6C 00 A6 27 ?? ?? ?? 0? 5C 00 07 24 CA FF 40 14 21 B8 40 00 ?? ?? ?? 0? 01 00 1E 24 ?? ?? ?? 0? 01 00 16 24 ?? ?? ?? 0? 02 00 16 24 21 28 05 02 01 00 A3 80 62 FE 62 14 DC 00 A3 8F DC 00 A2 8F CC 00 A5 8F D0 00 A6 8F 00 00 B1 AE 21 20 60 02 10 00 B5 AF 14 00 A2 AF 18 00 A0 AF ?? ?? ?? 0? 21 38 00 02 ?? ?? ?? 0? 21 F0 40 00 03 02 E2 10 01 00 C4 26 3E 00 E2 28 DC 01 40 14 3F 00 02 24 FE 01 E2 10 00 00 00 00 7D 00 02 24 F1 01 E2 14 00 00 00 00 94 00 A0 AF 88 00 A0 AF 21 B8 00 00 ?? ?? ?? 0? 00 00 47 82 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 0A 00 06 24 ?? ?? 04 3C ?? ?? 84 8C 2A 20 44 00 C4 01 80 14 ?? ?? 04 3C DC 00 A3 8F 20 00 62 30 8A FE 40 14 03 00 1E 24 21 90 00 00 21 80 00 00 88 00 A8 8F 91 00 00 11 DD FF 11 25 30 00 22 2E 50 00 40 10 ?? ?? 04 3C 80 10 11 00 ?? ?? 84 24 21 10 82 00 00 00 42 8C 08 00 40 00 00 00 00 00 06 00 00 12 00 00 00 00 00 00 02 82 28 00 40 14 94 00 A3 8F 27 00 60 10 30 00 22 2E 60 00 A0 AF 64 00 A0 AF 1F 00 E0 12 68 00 A0 AF 00 00 E2 82 1C 00 40 10 21 40 E0 02 21 A8 00 00 2A 00 16 24 15 01 56 10 00 00 00 00 2B 00 44 28 0B 01 80 10 24 00 04 24 47 01 44 10 27 00 04 24 6C 01 44 10 22 00 04 24 28 00 44 10 02 00 02 24 68 00 A4 8F 00 00 07 81 21 F0 00 01 64 00 A5 27 ?? ?? ?? 0? 60 00 A6 27 9E FF 40 10 68 00 A2 AF 01 00 C8 27 04 00 00 11 00 00 00 00 01 00 C2 83 E8 FF 40 14 00 00 00 00 ?? ?? ?? 0? 21 20 E0 02 68 00 B7 8F 30 00 22 2E E9 00 40 10 ?? ?? 02 3C 80 88 11 00 ?? ?? 42 24 21 10 51 00 00 00 42 8C 08 00 40 00 00 00 00 00 06 00 00 12 00 00 00 00 00 00 02 82 CE FF 40 14 94 00 A8 8F CC FF 00 11 00 00 00 00 3E FE 40 12 21 F0 00 00 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 00 00 00 00 8A 01 A2 12 00 00 00 00 D7 FF A0 16 68 00 A4 8F 02 00 15 24 ?? ?? ?? 0? 21 F0 00 01 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 2E 06 06 24 ?? ?? ?? 0? ?? ?? E7 24 D4 01 00 12 00 00 00 00 00 00 02 82 CF 01 40 10 94 00 A3 8F ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 21 20 E0 02 8C 00 A8 8F 35 00 00 11 EC 00 A2 8F 44 00 A0 A3 5B 02 00 12 00 00 71 8E ?? ?? ?? 0? 21 20 00 02 21 20 40 00 44 00 A5 27 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 CC 00 A5 8F D0 00 A6 8F 21 38 40 00 ?? ?? ?? 0? 21 20 20 02 25 FE 40 12 00 00 62 AE ?? ?? ?? 0? 21 20 00 02 00 00 62 8E ?? ?? ?? 0? 01 00 5E 2C 06 00 00 12 00 00 00 00 00 00 02 82 DF FF 40 14 94 00 A8 8F C3 FF 00 11 00 00 00 00 D6 01 40 16 00 00 00 00 DA 01 E0 12 00 00 00 00 ?? ?? ?? 0? 21 20 E0 02 3F FF 40 10 21 80 40 00 21 20 80 02 21 28 00 02 01 00 06 24 ?? ?? ?? 0? 01 00 12 24 ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 21 20 E0 02 8C 00 A8 8F D0 FF 00 15 00 00 00 00 89 FD 00 12 21 F0 00 00 EC 00 A2 8F 4C 01 40 14 E0 00 A3 8F 4A 01 60 10 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 A4 00 40 16 21 B0 40 00 DE FD C0 12 21 80 C0 02 21 B8 00 00 E8 00 A5 8F ?? ?? ?? 0? 21 20 00 02 04 00 E0 16 21 88 02 02 00 00 22 82 9D 00 40 10 00 00 00 00 E4 00 A5 8F 21 20 20 02 ?? ?? ?? 0? 21 B8 00 00 E8 00 A5 8F 21 90 22 02 ?? ?? ?? 0? 21 20 40 02 21 80 42 02 00 00 05 82 07 00 A0 10 00 00 00 00 ?? ?? ?? 0? E4 00 A4 8F 03 00 40 10 00 00 00 00 01 00 10 26 01 00 17 24 00 00 40 A2 00 00 64 8E CC 00 A5 8F D0 00 A6 8F ?? ?? ?? 0? 21 38 20 02 76 00 40 10 00 00 62 AE 85 00 E0 16 00 00 00 00 00 00 03 82 7E 00 60 10 00 00 00 00 D8 FF D0 12 E0 00 A4 8F ?? ?? ?? 0? 21 28 40 00 01 00 03 24 6D 00 43 10 D0 00 A8 8F 00 00 00 AD CC 00 A8 8F 00 00 00 AD ?? ?? ?? 0? 00 00 60 AE 04 00 00 12 00 00 00 00 00 00 02 82 83 FF 40 14 00 00 00 00 04 00 40 12 94 00 A3 8F ?? ?? ?? 0? 21 20 00 02 94 00 A3 8F 03 00 60 14 00 00 00 00 9F FD 00 16 21 F0 00 00 59 01 E0 12 00 00 00 00 ?? ?? ?? 0? 21 20 E0 02 DE FE 40 10 21 80 40 00 ?? ?? ?? 0? 01 00 12 24 CB 01 00 12 00 00 00 00 6E FF E0 12 00 00 00 00 00 00 E2 82 6B FF 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 88 00 A3 8F 21 88 02 02 25 00 02 24 A2 01 62 10 26 00 62 2C 6A 01 40 14 88 00 A8 8F 4C 00 02 24 7E 01 02 11 52 00 02 24 5D FF 02 15 2B 10 30 02 21 B0 00 02 06 00 40 10 01 00 15 24 ?? ?? ?? 0? 00 00 00 00 2B 10 36 02 55 FF 40 14 00 00 00 00 21 20 E0 02 21 28 C0 02 ?? ?? ?? 0? 21 30 00 00 F8 FF 55 10 01 00 D6 26 FF FF D6 26 23 B0 D0 02 ?? ?? ?? 0? 01 00 C4 26 CF 01 40 10 21 88 40 00 21 20 40 00 21 28 00 02 ?? ?? ?? 0? 21 30 C0 02 C7 01 40 16 00 00 40 A0 21 80 20 02 ?? ?? ?? 0? 01 00 12 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 7B 07 06 24 ?? ?? ?? 0? ?? ?? E7 24 5C 00 04 24 53 00 44 10 7E 00 04 24 23 00 44 10 3F 00 04 24 F6 FE 44 14 00 00 00 00 F5 FE A0 12 68 00 A4 8F 64 00 A5 27 60 00 A6 27 5C 00 07 24 ?? ?? ?? 0? 98 00 A8 AF 21 20 40 00 68 00 A2 AF EC FE 40 14 98 00 A8 8F ?? ?? ?? 0? 01 00 1E 24 00 00 23 82 89 FF 60 10 00 00 00 00 ?? ?? ?? 0? 21 20 C0 02 01 00 1E 24 21 B8 00 00 ?? ?? ?? 0? 21 A0 00 00 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 20 C0 02 ?? ?? ?? 0? 21 F0 00 00 ?? ?? ?? 0? 01 00 17 24 D5 FE A0 16 68 00 A4 8F 64 00 A2 8F D2 FE 40 14 30 00 A2 27 21 38 00 01 10 00 A2 AF 14 00 A0 AF 68 00 A4 27 64 00 A5 27 60 00 A6 27 98 00 A8 AF ?? ?? ?? 0? 30 00 A0 AF 21 F0 40 00 1A 00 40 10 98 00 A8 8F BC 00 40 16 00 00 00 00 ?? ?? ?? 0? 68 00 A4 8F ?? ?? ?? 0? 00 00 00 00 DC 00 A3 8F 30 00 A2 27 10 00 A2 AF 01 00 02 24 21 38 00 01 14 00 A3 AF 18 00 A0 AF 1C 00 A0 AF 20 00 A0 AF 24 00 A2 AF 68 00 A4 27 64 00 A5 27 60 00 A6 27 98 00 A8 AF ?? ?? ?? 0? 30 00 A0 AF 21 F0 40 00 E8 FF 40 14 98 00 A8 8F 30 00 A2 8F 21 40 02 01 ?? ?? ?? 0? 21 F0 00 01 68 00 A4 8F 5C 00 07 24 64 00 A5 27 60 00 A6 27 ?? ?? ?? 0? 98 00 A8 AF 98 00 A8 8F 68 00 A2 AF 21 20 40 00 01 00 07 81 61 01 E0 10 01 00 1E 25 9E FE 40 14 64 00 A5 27 ?? ?? ?? 0? 01 00 1E 24 01 00 02 24 47 00 A2 12 00 00 00 00 94 FE A0 16 68 00 A4 8F 01 00 15 24 ?? ?? ?? 0? 21 F0 00 01 ?? ?? ?? 0? 21 20 80 02 21 80 40 00 64 FE 00 16 21 90 00 00 ?? ?? ?? 0? DC 00 A3 8F 57 00 00 11 ?? ?? 02 3C ?? ?? 44 8C 5C 00 A5 27 0A 00 06 24 FF FF 84 24 21 38 00 00 ?? ?? ?? 0? 5C 00 A0 A3 21 80 40 00 ?? ?? ?? 0? 8C 00 A0 AF 90 00 A3 AF 94 00 A0 AF 88 00 A0 AF 21 B8 00 00 ?? ?? ?? 0? 00 00 47 82 ?? ?? ?? 0? 90 00 A3 AF 80 00 A8 8F 3E 00 00 15 FF FF D6 26 90 00 A0 AF 21 A0 00 00 94 00 A0 AF 88 00 A0 AF 21 B8 00 00 ?? ?? ?? 0? 00 00 B6 AE ?? ?? 84 8C 80 10 02 00 21 10 82 00 ?? ?? ?? 0? 00 00 50 8C 3A 00 02 24 18 00 E2 14 01 00 C6 26 21 18 06 02 00 00 65 80 ?? ?? 04 3C ?? ?? 84 24 9C 00 A3 AF ?? ?? ?? 0? 98 00 A6 AF 05 00 1E 24 21 B8 00 00 9C 00 A3 8F B7 FC 40 10 98 00 A6 8F 00 00 A6 AE 00 00 63 80 02 00 C4 26 01 00 08 24 88 00 A3 AF 21 10 04 02 ?? ?? ?? 0? 94 00 A8 AF 21 A8 00 00 ?? ?? ?? 0? 21 F0 00 01 05 00 1E 24 ?? ?? ?? 0? 21 B8 00 00 21 10 04 02 00 00 45 80 42 00 A7 10 25 00 08 24 94 00 A0 AF ?? ?? ?? 0? 88 00 A8 AF 88 00 A7 AF 21 10 04 02 ?? ?? ?? 0? 94 00 A0 AF 00 00 64 8E CC 00 A5 8F D0 00 A6 8F ?? ?? ?? 0? 21 38 00 02 8A FE 40 16 00 00 62 AE ?? ?? ?? 0? 01 00 5E 2C 05 00 1E 24 21 B8 00 00 ?? ?? ?? 0? 21 A0 00 00 00 00 64 8E ?? ?? ?? 0? 00 00 B1 AE ?? ?? ?? 0? 5C 00 A0 A3 }
	condition:
		$1
}

rule file_144_14_0 {
	meta:
		name = "wordfree"
		size = 116
		refs = "003c free"
	strings:
		$1 = { D8 FF BD 27 20 00 B1 AF 24 00 BF AF 1C 00 B0 AF 13 00 80 10 21 88 80 00 04 00 82 8C 11 00 40 10 24 00 BF 8F 08 00 90 8C 80 80 10 00 21 80 50 00 00 00 04 8E 07 00 80 10 00 00 00 00 ?? ?? ?? 0? 04 00 10 26 00 00 04 8E FC FF 80 14 00 00 00 00 04 00 22 8E ?? ?? ?? 0? 21 20 40 00 04 00 20 AE 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_144_15_0 {
	meta:
		name = "wordexp"
		size = 2704
		refs = "0080 calloc 0098 getenv 0094 $LC5 0190 free 0408 strchr 04d4 glob 0588 globfree 0614 __strdup 0630 wordfree 06f0 $LC19 0940 $LC17 0944 $LC1 0958 __assert_fail 0948 __PRETTY_FUNCTION__.10624 0984 $LC20 0a70 $LC18"
	strings:
		$1 = { 00 00 A3 8C 48 FF BD 27 08 00 C2 30 8C 00 A3 AF 04 00 A3 8C A0 00 B4 AF 98 00 B2 AF 84 00 A3 AF 08 00 A3 8C 90 00 B0 AF B4 00 BF AF B0 00 BE AF AC 00 B7 AF A8 00 B6 AF A4 00 B5 AF 9C 00 B3 AF 94 00 B1 AF 21 A0 C0 00 21 90 A0 00 21 80 80 00 68 00 A0 AF 6C 00 A0 AF 64 00 A0 AF 57 02 40 14 88 00 A3 AF 02 00 83 32 0A 00 60 14 80 00 A3 AF 01 00 82 32 16 02 40 14 00 00 40 AE 01 00 04 24 ?? ?? ?? 0? 04 00 05 24 17 02 40 10 04 00 42 AE 08 00 40 AE ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 4F 02 40 10 21 98 40 00 00 00 44 80 60 00 A3 27 78 00 A3 AF 0E 00 80 10 21 28 60 00 21 38 40 00 21 28 60 00 20 00 08 24 75 00 88 10 F7 FF 82 24 FF 00 42 30 02 00 42 2C 72 00 40 14 78 00 A3 8F 01 00 E7 24 00 00 E4 80 F7 FF 80 14 00 00 00 00 00 00 A0 A0 00 00 11 82 70 00 A0 AF 57 00 20 12 21 10 00 00 3F 00 03 24 B2 00 23 12 40 00 23 2A 39 00 60 10 5C 00 03 24 24 00 03 24 60 01 23 12 25 00 23 2A 71 00 60 14 27 00 03 24 A6 00 23 16 01 00 42 24 21 18 02 02 00 00 67 80 92 00 E0 10 70 00 A2 AF 96 00 F1 10 64 00 A4 8F ?? ?? ?? 0? 27 00 11 24 70 00 A2 8F 01 00 42 24 21 18 02 02 00 00 67 80 89 00 E0 10 70 00 A2 AF 8D 00 F1 10 6C 00 A2 8F 6C 00 A5 27 ?? ?? ?? 0? 68 00 A6 27 21 20 40 00 F3 FF 40 14 64 00 A2 AF 01 00 1E 24 ?? ?? ?? 0? 00 00 00 00 01 00 02 24 0A 00 C2 13 80 00 A3 8F 0A 02 60 10 00 00 00 00 8C 00 A3 8F 21 10 C0 03 00 00 43 AE 84 00 A3 8F 04 00 43 AE 88 00 A3 8F 08 00 43 AE B4 00 BF 8F B0 00 BE 8F AC 00 B7 8F A8 00 B6 8F A4 00 B5 8F A0 00 B4 8F 9C 00 B3 8F 98 00 B2 8F 94 00 B1 8F 90 00 B0 8F 08 00 E0 03 B8 00 BD 27 60 01 23 12 5D 00 23 2A 38 01 60 14 60 00 03 24 49 01 23 12 04 00 83 32 7E 00 02 24 36 01 22 16 70 00 A3 27 00 00 42 8E 10 00 A3 AF 14 00 A2 AF 64 00 A4 27 6C 00 A5 27 68 00 A6 27 ?? ?? ?? 0? 21 38 00 02 27 01 40 14 21 F0 40 00 70 00 A2 8F 01 00 42 24 21 18 02 02 00 00 71 80 AB FF 20 16 70 00 A2 AF 64 00 A5 8F E6 01 A0 10 B4 00 BF 8F ?? ?? ?? 0? 21 20 40 02 B4 00 BF 8F B0 00 BE 8F AC 00 B7 8F A8 00 B6 8F A4 00 B5 8F A0 00 B4 8F 9C 00 B3 8F 98 00 B2 8F 94 00 B1 8F 90 00 B0 8F 08 00 E0 03 B8 00 BD 27 78 00 A3 8F 2B 10 65 00 B1 01 40 10 60 00 A3 83 07 00 64 14 61 00 A2 27 ?? ?? ?? 0? 78 00 A6 8F 01 00 42 24 FF FF 43 80 03 00 64 10 00 00 00 00 FB FF A2 14 21 30 40 00 81 FF C5 14 00 00 00 00 01 00 A5 24 ?? ?? ?? 0? 00 00 C4 A0 22 00 03 24 FF 00 23 16 01 00 42 24 21 18 02 02 00 00 67 80 21 00 E0 10 70 00 A2 AF 04 00 91 32 24 00 03 24 38 01 E3 10 25 00 E3 28 1E 00 60 14 5C 00 03 24 29 01 E3 10 60 00 03 24 1F 01 E3 14 64 00 A4 8F C6 01 20 16 70 00 A3 27 01 00 42 24 10 00 A3 AF 14 00 B4 AF 18 00 A0 AF 1C 00 A0 AF 20 00 A0 AF 64 00 A4 27 6C 00 A5 27 68 00 A6 27 21 38 00 02 ?? ?? ?? 0? 70 00 A2 AF DC 00 40 14 21 F0 40 00 70 00 A2 8F 01 00 42 24 21 18 02 02 00 00 67 80 E2 FF E0 14 70 00 A2 AF 64 00 A4 8F ?? ?? ?? 0? 05 00 1E 24 22 00 02 24 03 01 E2 14 64 00 A4 8F 6C 00 A2 8F A8 FF 40 14 70 00 A2 8F 21 20 40 02 ?? ?? ?? 0? 21 28 00 00 A2 FF 40 10 B4 00 BF 8F ?? ?? ?? 0? B0 00 BE 8F 2A 00 02 24 C9 00 22 16 ?? ?? 04 3C 70 00 B7 8F 54 00 A0 AF 58 00 A0 AF 21 10 17 02 00 00 56 80 95 01 C0 12 5C 00 A0 AF 54 00 A3 27 01 00 1E 24 21 88 00 00 7C 00 A3 AF 27 00 15 24 21 20 60 02 ?? ?? ?? 0? 21 28 C0 02 1D 00 40 14 00 00 00 00 9B 00 D5 12 22 00 02 24 87 00 C2 12 01 00 02 24 8C 01 22 12 24 00 02 24 11 01 C2 12 5C 00 02 24 85 00 C2 16 64 00 A4 8F FE 00 20 12 70 00 A3 27 70 00 A2 27 10 00 A2 AF 64 00 A4 27 6C 00 A5 27 68 00 A6 27 ?? ?? ?? 0? 21 38 00 02 21 F0 40 00 71 00 C0 17 00 00 00 00 70 00 B7 8F 01 00 F7 26 21 10 17 02 00 00 56 80 E0 FF C0 16 70 00 B7 AF 64 00 A5 8F 7C 00 A4 8F FF FF E3 26 ?? ?? ?? 0? 70 00 A3 AF 21 F0 40 00 68 00 A0 AF 6C 00 A0 AF 61 00 40 14 64 00 A0 AF 54 00 A2 8F 1C 01 40 10 01 00 16 24 21 A8 00 00 58 00 A2 8F 10 00 05 24 21 30 00 00 21 10 55 00 00 00 44 8C ?? ?? ?? 0? 30 00 A7 27 16 01 40 14 01 00 03 24 00 00 62 82 32 00 40 14 64 00 A4 8F 34 00 A2 8F 00 00 47 8C 5D 01 E0 10 6C 00 A5 27 ?? ?? ?? 0? 68 00 A6 27 21 20 40 00 64 00 A2 AF 30 00 A2 8F 02 00 42 2C 1B 00 40 14 00 00 00 00 19 00 80 10 00 00 00 00 ?? ?? ?? 0? 01 00 11 24 15 00 80 10 00 00 00 00 6C 00 A5 27 68 00 A6 27 ?? ?? ?? 0? 20 00 07 24 0A 00 40 10 64 00 A2 AF 34 00 A3 8F 80 28 11 00 21 20 40 00 21 10 65 00 00 00 47 8C 6C 00 A5 27 ?? ?? ?? 0? 68 00 A6 27 64 00 A2 AF 30 00 A2 8F 01 00 31 26 2B 10 22 02 EB FF 40 14 64 00 A4 8F ?? ?? ?? 0? 30 00 A4 27 64 00 A2 8F 25 00 40 10 54 00 A2 8F 01 00 C3 26 2B B0 C2 02 E0 00 C0 12 04 00 B5 26 ?? ?? ?? 0? 21 B0 60 00 07 00 80 10 30 00 A2 8F ?? ?? ?? 0? 00 00 00 00 68 00 A0 AF 6C 00 A0 AF 64 00 A0 AF 30 00 A2 8F 0C 00 40 14 21 88 00 00 ?? ?? ?? 0? 00 00 00 00 21 20 40 02 ?? ?? ?? 0? 21 28 40 00 0C 00 40 14 30 00 A2 8F 01 00 31 26 2B 10 22 02 D7 00 40 10 00 00 00 00 34 00 A3 8F 80 10 11 00 21 10 62 00 ?? ?? ?? 0? 00 00 44 8C F1 FF 40 14 00 00 00 00 ?? ?? ?? 0? 30 00 A4 27 01 00 1E 24 ?? ?? ?? 0? 7C 00 A4 8F ?? ?? ?? 0? 64 00 A4 8F 8B 00 20 12 02 00 02 24 13 00 22 12 64 00 A4 8F 6C 00 A5 27 68 00 A6 27 ?? ?? ?? 0? 21 38 C0 02 83 FF 40 14 64 00 A2 AF ?? ?? ?? 0? 7C 00 A4 8F F4 FE C0 13 00 00 00 00 ?? ?? ?? 0? 64 00 A4 8F ?? ?? ?? 0? 01 00 02 24 77 00 20 12 01 00 02 24 EF FF 22 16 64 00 A4 8F ?? ?? ?? 0? 21 88 00 00 78 00 A3 8F 70 00 A2 27 10 00 A2 AF 14 00 B4 AF 18 00 B2 AF 1C 00 B3 AF 20 00 A3 AF 24 00 A0 AF 64 00 A4 27 6C 00 A5 27 68 00 A6 27 ?? ?? ?? 0? 21 38 00 02 DB FE 40 10 21 F0 40 00 ?? ?? ?? 0? 64 00 A4 8F 5B 00 02 24 3B FF 22 12 70 00 B7 8F ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 21 28 20 02 A0 00 40 10 64 00 A5 8F 05 00 A0 10 00 00 00 00 ?? ?? ?? 0? 21 20 40 02 F0 FF 40 14 21 F0 40 00 68 00 A0 AF 6C 00 A0 AF ?? ?? ?? 0? 64 00 A0 AF BE 00 60 14 01 00 42 24 70 00 A3 27 10 00 A3 AF 78 00 A3 8F 14 00 B4 AF 18 00 B2 AF 1C 00 B3 AF 20 00 A3 AF 64 00 A4 27 6C 00 A5 27 68 00 A6 27 21 38 00 02 ?? ?? ?? 0? 70 00 A2 AF B5 FE 40 10 21 F0 40 00 ?? ?? ?? 0? 64 00 A4 8F 70 00 A2 27 10 00 A2 AF 64 00 A4 27 6C 00 A5 27 68 00 A6 27 ?? ?? ?? 0? 21 38 00 02 AA FE 40 10 21 F0 40 00 ?? ?? ?? 0? 64 00 A4 8F 6C 00 A5 27 ?? ?? ?? 0? 68 00 A6 27 21 20 40 00 ED FE 40 14 64 00 A2 AF ?? ?? ?? 0? 01 00 1E 24 70 00 A2 27 10 00 A2 AF 64 00 A4 27 6C 00 A5 27 68 00 A6 27 ?? ?? ?? 0? 21 38 00 02 E2 FE 40 10 21 F0 40 00 ?? ?? ?? 0? 64 00 A4 8F 78 00 A3 8F 70 00 A2 27 10 00 A2 AF 01 00 02 24 14 00 B4 AF 18 00 B2 AF 1C 00 B3 AF 20 00 A3 AF 24 00 A2 AF 64 00 A4 27 6C 00 A5 27 68 00 A6 27 ?? ?? ?? 0? 21 38 00 02 D0 FE 40 10 21 F0 40 00 ?? ?? ?? 0? 64 00 A4 8F 10 00 A3 AF 64 00 A4 27 6C 00 A5 27 68 00 A6 27 ?? ?? ?? 0? 21 38 00 02 21 F0 40 00 06 FF C0 13 70 00 B7 8F ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 01 00 11 24 ?? ?? ?? 0? 02 00 11 24 70 00 A3 27 10 00 A3 AF 7C 00 A3 8F 02 00 22 3A 01 00 42 2C 18 00 A3 AF 78 00 A3 8F 14 00 B4 AF 1C 00 B3 AF 20 00 A3 AF 24 00 A2 AF 64 00 A4 27 6C 00 A5 27 68 00 A6 27 ?? ?? ?? 0? 21 38 00 02 ED FE 40 10 21 F0 40 00 ?? ?? ?? 0? 7C 00 A4 8F ?? ?? ?? 0? 64 00 A4 8F 08 00 44 8E 04 00 05 24 ?? ?? ?? 0? 01 00 84 24 EC FD 40 14 04 00 42 AE 64 00 A2 8F ?? ?? ?? 0? 21 20 40 00 B4 00 BF 8F B0 00 BE 8F AC 00 B7 8F A8 00 B6 8F A4 00 B5 8F A0 00 B4 8F 9C 00 B3 8F 98 00 B2 8F 94 00 B1 8F 90 00 B0 8F 01 00 02 24 08 00 E0 03 B8 00 BD 27 ?? ?? ?? 0? 7C 00 A4 8F ?? ?? ?? 0? 70 00 A2 8F 3D FF 43 10 01 00 1E 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 8C 01 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? ?? 0? 30 00 A4 27 ?? ?? ?? 0? 54 00 A2 8F 78 00 A6 8F DA FD C5 14 00 00 00 00 ?? ?? ?? 0? 01 00 A5 24 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 21 28 20 02 2F 00 40 14 64 00 A4 8F 6C 00 A5 27 68 00 A6 27 ?? ?? ?? 0? 21 38 20 02 25 FE 40 14 64 00 A2 AF ?? ?? ?? 0? 00 00 00 00 21 20 A0 00 ?? ?? ?? 0? 84 00 A0 AF ?? ?? ?? 0? 02 00 83 32 ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? 8C 00 A3 8F 0A 00 02 3C 60 00 A3 27 20 09 42 24 78 00 A3 AF 60 00 A2 AF ?? ?? ?? 0? 21 98 60 00 B0 00 BE 8F AC 00 B7 8F A8 00 B6 8F A4 00 B5 8F A0 00 B4 8F 9C 00 B3 8F 98 00 B2 8F 94 00 B1 8F 90 00 B0 8F 21 10 00 00 08 00 E0 03 B8 00 BD 27 04 00 1E 24 ?? ?? ?? 0? 64 00 A4 8F ?? ?? ?? 0? 80 00 A3 8F 54 00 A3 27 ?? ?? ?? 0? 7C 00 A3 AF ?? ?? ?? 0? 04 00 1E 24 ?? ?? ?? 0? 02 00 1E 24 5C 00 02 24 FB FE C2 16 64 00 A4 8F ?? ?? ?? 0? 70 00 A2 27 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 93 01 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "__wcrtomb_chk"
		size = 76
		refs = "0000 __gnu_local_gp 0010 _nl_current_LC_CTYPE 003c __wcrtomb 0044 __chk_fail"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F E0 FF BD 27 1C 00 BF AF 21 10 62 00 00 00 42 8C 10 00 BC AF 00 00 42 8C 58 00 42 8C 2B 38 E2 00 03 00 E0 14 1C 00 BF 8F ?? ?? ?? 0? 20 00 BD 27 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "critical_factorization"
		size = 344
	strings:
		$1 = { 01 00 0C 24 01 00 07 24 21 40 00 00 FF FF 02 24 21 18 82 00 21 58 67 00 21 18 E8 00 2B 48 65 00 0F 00 20 11 21 50 83 00 00 00 4A 91 00 00 69 91 2B 58 49 01 2C 00 60 11 00 00 00 00 21 40 60 00 01 00 07 24 23 60 62 00 21 18 82 00 21 58 67 00 21 18 E8 00 2B 48 65 00 F3 FF 20 15 21 50 83 00 00 00 CC AC 01 00 0D 24 01 00 07 24 21 40 00 00 FF FF 0B 24 21 18 8B 00 21 60 67 00 21 18 E8 00 2B 48 65 00 0F 00 20 11 21 50 83 00 00 00 4A 91 00 00 89 91 2B 60 2A 01 1A 00 80 11 00 00 00 00 21 40 60 00 01 00 07 24 23 68 6B 00 21 18 8B 00 21 60 67 00 21 18 E8 00 2B 48 65 00 F3 FF 20 15 21 50 83 00 01 00 42 24 01 00 6B 25 2B 18 62 01 03 00 60 14 00 00 00 00 00 00 CD AC 21 10 60 01 08 00 E0 03 00 00 00 00 0D 00 49 11 00 00 00 00 21 10 00 01 01 00 0C 24 01 00 08 25 ?? ?? ?? 0? 01 00 07 24 0A 00 49 11 00 00 00 00 21 58 00 01 01 00 0D 24 01 00 08 25 ?? ?? ?? 0? 01 00 07 24 07 00 EC 10 00 00 00 00 ?? ?? ?? 0? 01 00 E7 24 06 00 ED 10 00 00 00 00 ?? ?? ?? 0? 01 00 E7 24 21 40 60 00 ?? ?? ?? 0? 01 00 07 24 21 40 60 00 ?? ?? ?? 0? 01 00 07 24 }
	condition:
		$1
}

rule file_146_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 1084
		refs = "00b0 memcmp 00f4 memchr"
	strings:
		$1 = { 98 FB BD 27 18 04 AE 27 21 40 A0 00 58 04 B6 AF 48 04 B2 AF 21 B0 80 00 21 90 C0 00 21 20 C0 00 21 28 E0 00 21 30 C0 01 4C 04 B3 AF 40 04 B0 AF 3C 04 A8 AF 64 04 BF AF 60 04 BE AF 5C 04 B7 AF 54 04 B5 AF 50 04 B4 AF 44 04 B1 AF ?? ?? ?? 0? 21 98 E0 00 3C 04 A8 8F 21 80 40 00 18 00 A3 27 00 00 73 AC 04 00 63 24 FD FF C3 15 00 00 00 00 0B 00 60 12 21 10 40 02 21 28 72 02 FF FF 63 26 00 00 44 90 18 00 A6 27 01 00 42 24 80 20 04 00 21 20 C4 00 00 00 83 AC F9 FF 45 14 FF FF 63 24 18 04 B1 8F 21 20 40 02 21 30 00 02 21 28 51 02 ?? ?? ?? 0? 3C 04 A8 AF 71 00 40 14 3C 04 A8 8F FF FF 03 26 21 A8 00 00 28 04 A3 AF 01 00 02 24 21 18 43 02 21 F0 B3 02 20 04 A3 AF 23 10 50 00 23 18 71 02 21 20 C8 02 21 28 00 00 23 30 C8 03 24 04 A3 AF ?? ?? ?? 0? 2C 04 A2 AF 21 A0 00 00 18 00 40 14 FF FF 77 26 16 00 C0 13 21 10 DE 02 FF FF 42 90 18 00 A4 27 80 10 02 00 21 10 82 00 00 00 42 8C 1C 00 40 10 2B 60 90 02 03 00 80 12 24 04 A6 8F 2B 18 51 00 0B 10 C3 00 21 A8 A2 02 21 A0 00 00 21 40 C0 03 21 F0 B3 02 21 20 C8 02 21 28 00 00 ?? ?? ?? 0? 23 30 C8 03 EA FF 40 10 00 00 00 00 21 10 00 00 64 04 BF 8F 60 04 BE 8F 5C 04 B7 8F 58 04 B6 8F 54 04 B5 8F 50 04 B4 8F 4C 04 B3 8F 48 04 B2 8F 44 04 B1 8F 40 04 B0 8F 08 00 E0 03 68 04 BD 27 21 18 00 02 0A 18 8C 02 21 10 75 00 2B 20 77 00 21 40 43 02 11 00 80 10 21 10 C2 02 00 00 05 91 00 00 44 90 2A 00 A4 14 23 30 03 00 21 40 06 01 ?? ?? ?? 0? 21 30 46 00 00 00 84 90 00 00 42 90 24 00 82 14 2C 04 A4 8F 01 00 63 24 2B 28 77 00 21 20 03 01 F8 FF A0 14 21 10 C3 00 28 04 A3 8F 21 40 A3 02 8B 00 80 11 21 40 C8 02 20 04 A3 8F 00 00 04 91 00 00 65 90 FF FF 62 24 85 00 A4 14 FF FF 03 25 23 60 90 02 21 60 0C 01 ?? ?? ?? 0? 23 40 08 02 FF FF 63 24 01 00 45 90 01 00 64 90 05 00 A4 14 01 00 8B 26 FF FF 42 24 F9 FF 6C 14 21 30 68 00 01 00 8B 26 2B 30 CB 00 77 00 C0 14 24 04 B4 8F 21 A8 B1 02 ?? ?? ?? 0? 21 40 C0 03 2C 04 A4 8F 21 A0 00 00 21 40 C0 03 21 50 95 00 ?? ?? ?? 0? 21 A8 43 01 23 10 70 02 2B 18 50 00 FF FF 11 26 0B 10 03 02 21 18 51 02 2C 04 A3 AF FF FF 74 26 23 18 10 00 24 04 A3 AF 2B 18 14 02 28 04 A3 AF 2C 04 A3 8F 24 04 A4 8F 01 00 17 24 FF FF 63 24 34 04 A3 AF 2C 04 A3 8F 01 00 42 24 21 90 50 02 23 B8 F0 02 30 04 B7 AF 38 04 A2 AF 20 04 B2 AF 18 04 A2 AF 21 F0 00 00 23 A8 70 00 21 B8 44 02 21 90 D3 03 21 20 C8 02 21 28 00 00 ?? ?? ?? 0? 23 30 48 02 99 FF 40 14 21 10 00 00 96 FF 40 12 21 10 D2 02 FF FF 42 90 18 00 A6 27 80 10 02 00 21 10 C2 00 00 00 42 8C 04 00 40 10 28 04 A3 8F 21 F0 C2 03 ?? ?? ?? 0? 21 40 40 02 21 78 D0 03 12 00 60 10 21 78 CF 02 20 04 A4 8F 00 00 E2 91 00 00 83 90 2C 00 62 14 24 04 A6 8F 21 18 00 02 ?? ?? ?? 0? 21 78 E6 01 00 00 04 91 00 00 C2 90 27 00 82 14 30 04 A2 8F 01 00 63 24 2B 28 74 00 21 40 E3 02 F8 FF A0 14 21 30 E3 01 21 10 D1 03 FF FF 06 24 0F 00 26 12 21 10 C2 02 2C 04 A3 8F FF FF 42 24 00 00 64 90 01 00 43 90 1C 00 83 14 34 04 A3 8F ?? ?? ?? 0? 00 00 00 00 00 00 64 90 01 00 45 90 16 00 A4 14 FF FF 63 24 FB FF 75 14 FF FF 42 24 64 04 BF 8F 21 10 DE 02 5C 04 B7 8F 60 04 BE 8F 58 04 B6 8F 54 04 B5 8F 50 04 B4 8F 4C 04 B3 8F 48 04 B2 8F 44 04 B1 8F 40 04 B0 8F 08 00 E0 03 68 04 BD 27 21 18 00 02 30 04 A2 8F 21 40 40 02 21 68 5E 00 ?? ?? ?? 0? 21 F0 A3 01 38 04 A3 8F 21 40 40 02 ?? ?? ?? 0? 21 F0 C3 03 ?? ?? ?? 0? 21 30 00 02 ?? ?? ?? 0? 21 10 D5 02 }
	condition:
		$1
}

rule file_146_2_0 {
	meta:
		name = "strstr"
		size = 1160
		refs = "0098 strchr 0138 memchr 0210 memcmp"
	strings:
		$1 = { 98 FF BD 27 58 00 B6 AF 44 00 B1 AF 64 00 BF AF 60 00 BE AF 5C 00 B7 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 48 00 B2 AF 40 00 B0 AF 00 00 82 80 21 88 80 00 06 01 40 10 21 B0 A0 00 00 00 A3 80 06 01 60 10 21 80 A0 00 21 30 80 00 ?? ?? ?? 0? 01 00 07 24 00 00 03 82 0B 00 60 10 00 00 00 00 01 00 C6 24 26 18 43 00 00 00 C2 80 01 00 63 2C 01 00 10 26 F7 FF 40 14 24 38 E3 00 00 00 02 82 4E 00 40 14 64 00 BF 8F 15 00 E0 14 21 10 20 02 00 00 C5 82 01 00 24 26 ?? ?? ?? 0? 23 B0 16 02 45 00 40 10 21 A8 40 00 01 00 14 24 0C 00 D4 12 21 88 36 02 2B 48 22 02 23 88 22 02 20 00 C2 2E 23 80 16 02 49 00 40 14 0B 88 89 02 21 20 A0 02 21 28 20 02 21 30 00 02 ?? ?? ?? 0? 21 38 C0 02 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 01 00 7E 26 21 18 13 02 21 20 B3 02 2B 10 3E 01 20 00 A4 AF 09 00 40 10 00 00 77 90 23 30 89 02 21 20 A9 02 21 28 00 00 ?? ?? ?? 0? 21 30 D3 00 1E 00 40 14 64 00 BF 8F 21 48 C0 03 23 10 D3 02 2B 18 53 00 0B 10 63 02 FF FF 63 26 24 00 A3 AF 21 18 03 02 28 00 A3 AF 2B 18 D6 03 2C 00 A3 AF 28 00 A3 8F 01 00 42 24 20 00 A8 8F 18 00 A2 AF 30 00 A2 AF 01 00 02 24 FF FF 63 24 23 10 53 00 38 00 A3 AF 34 00 A2 AF 28 00 A3 8F 00 00 02 91 21 A0 1E 02 01 00 06 25 7E 00 E2 12 23 80 73 00 78 00 40 14 00 00 00 00 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 21 10 00 00 08 00 E0 03 68 00 BD 27 21 20 00 02 21 28 C0 02 18 00 A6 27 ?? ?? ?? 0? 3C 00 B1 AF 18 00 B2 8F 21 20 00 02 21 30 40 00 21 28 12 02 ?? ?? ?? 0? 21 98 40 00 BD FF 40 14 3C 00 A9 8F FF FF 63 26 20 00 A3 AF 21 88 03 02 23 A0 93 02 23 18 D2 02 21 F0 00 00 21 B8 00 00 28 00 A3 AF 24 00 B4 AF 21 A0 F6 02 21 20 A9 02 21 28 00 00 ?? ?? ?? 0? 23 30 89 02 D8 FF 40 14 64 00 BF 8F D6 FF 80 12 21 20 60 02 2B 18 D3 03 0A 20 C3 03 21 18 80 00 21 28 97 00 2B 20 96 00 21 10 03 02 11 00 80 10 21 28 A5 02 00 00 46 90 00 00 A4 90 2A 00 C4 14 23 20 03 00 21 10 44 00 ?? ?? ?? 0? 21 28 A4 00 00 00 4A 91 00 00 28 91 24 00 48 15 24 00 A4 8F 01 00 63 24 2B 40 76 00 21 50 43 00 F8 FF 00 15 21 48 A3 00 20 00 A3 8F 2B 10 D3 03 21 40 E3 02 5C 00 40 10 21 40 A8 02 00 00 24 92 00 00 02 91 FF FF 25 26 57 00 82 14 FF FF 03 25 23 48 D3 03 21 48 09 01 ?? ?? ?? 0? 23 40 68 02 FF FF 63 24 01 00 A4 90 01 00 62 90 04 00 82 14 00 00 00 00 FF FF A5 24 F9 FF 69 14 21 30 68 00 01 00 DE 27 2B 30 DE 00 4E 00 C0 14 28 00 BE 8F 21 B8 F2 02 ?? ?? ?? 0? 21 48 80 02 24 00 A4 8F 21 F0 00 00 21 48 80 02 21 B8 97 00 ?? ?? ?? 0? 21 B8 E3 02 99 FF 80 10 64 00 BF 8F 30 00 A3 8F 21 90 C3 00 21 88 56 02 21 20 A9 02 21 28 00 00 ?? ?? ?? 0? 23 30 29 02 90 FF 40 14 64 00 BF 8F 8E FF 20 12 00 00 00 00 21 30 53 02 21 30 A6 02 21 48 20 02 21 40 C0 00 00 00 C2 90 84 FF E2 16 01 00 06 25 20 00 A3 8F 23 30 C3 00 2C 00 A3 8F 11 00 60 10 FF FF C6 24 01 00 04 91 00 00 82 92 01 00 83 26 29 00 44 14 02 00 08 25 ?? ?? ?? 0? 21 10 C0 03 FF FF 04 91 FF FF 65 90 24 00 A4 14 00 00 00 00 01 00 42 24 2B 20 56 00 01 00 63 24 F8 FF 80 14 01 00 08 25 24 00 A4 8F FF FF 05 24 21 18 C4 00 0E 00 85 10 21 18 A3 02 28 00 A5 8F 00 00 64 90 00 00 A2 90 CE FF 44 14 FF FF 63 24 ?? ?? ?? 0? 38 00 A2 8F 00 00 45 90 01 00 64 90 C8 FF A4 14 FF FF 42 24 FB FF 50 14 FF FF 63 24 ?? ?? ?? 0? 21 10 A6 02 ?? ?? ?? 0? 21 30 60 02 21 80 A0 00 ?? ?? ?? 0? 01 00 07 24 ?? ?? ?? 0? 21 10 80 00 ?? ?? ?? 0? 21 10 B7 02 21 10 C0 03 52 FF 80 10 64 00 BF 8F 34 00 A3 8F 21 30 66 00 ?? ?? ?? 0? 21 90 C2 00 }
	condition:
		$1
}

rule file_147_2_0 {
	meta:
		name = "__libc_allocate_rtsig"
		size = 80
	strings:
		$1 = { ?? ?? 05 3C ?? ?? A2 8C FF FF 03 24 0E 00 43 10 ?? ?? 06 3C ?? ?? C3 8C 2A 38 62 00 0A 00 E0 14 00 00 00 00 04 00 80 10 00 00 00 00 01 00 43 24 08 00 E0 03 ?? ?? A3 AC FF FF 62 24 ?? ?? C2 AC 08 00 E0 03 21 10 60 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "_IO_ftell"
		size = 652
		refs = "0004 __gnu_local_gp 0074 __lll_lock_wait_private 00a8 _IO_seekoff_unlocked 013c __libc_errno 0238 _Unwind_Resume"
	strings:
		$1 = { 00 00 82 8C ?? ?? 1C 3C C8 FF BD 27 ?? ?? 9C 27 00 80 42 30 28 00 B0 AF 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 18 00 BC AF 1A 00 40 14 21 80 80 00 3B E8 03 7C 48 00 84 8C 70 8B 71 24 08 00 82 8C 11 00 51 10 00 00 00 00 20 00 A0 AF 00 00 83 C0 06 00 60 14 00 00 02 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 02 24 0F 00 00 00 03 00 40 14 00 00 00 00 ?? ?? ?? 0? 20 00 A3 AF 48 00 02 8E 21 20 40 00 08 00 51 AC 04 00 82 8C 01 00 42 24 04 00 82 AC 01 00 02 24 10 00 A2 AF 14 00 A0 AF 21 20 00 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 18 00 BC 8F 00 00 04 8E 21 88 40 00 00 01 82 30 07 00 40 10 21 90 60 00 FF FF 02 24 27 00 22 12 00 00 00 00 6C 00 02 8E 29 00 40 18 00 00 00 00 00 80 84 30 07 00 80 14 FF FF 02 24 48 00 04 8E 04 00 82 8C FF FF 42 24 2B 00 40 10 04 00 82 AC FF FF 02 24 09 00 22 12 C3 1F 11 00 39 00 72 14 21 10 20 02 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 38 00 BD 27 F7 FF 51 16 00 00 00 00 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 18 64 00 00 00 64 8C F3 FF 80 14 34 00 BF 8F 05 00 04 24 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 00 00 64 AC 08 00 E0 03 38 00 BD 27 DC FF 71 10 00 00 00 00 6C 00 02 8E D9 FF 40 1C 00 00 00 00 24 00 02 8E 2C 00 03 8E 23 18 62 00 23 10 23 02 C3 1F 03 00 2B 28 22 02 23 90 43 02 21 88 40 00 ?? ?? ?? 0? 23 90 45 02 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 CD FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? FF FF 02 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 4F 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 00 00 02 8E 00 80 42 30 06 00 40 14 21 88 80 00 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "__getgid"
		size = 16
	strings:
		$1 = { CF 0F 02 24 0C 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "__new_exitfn"
		size = 468
		refs = "00d8 __new_exitfn_called 015c calloc 0178 $LC0 017c $LC1 0190 __assert_fail 0180 __PRETTY_FUNCTION__.6418 01a0 __lll_lock_wait_private"
	strings:
		$1 = { D8 FF BD 27 18 00 B0 AF ?? ?? 10 3C 20 00 B2 AF ?? ?? 03 26 21 90 80 00 24 00 BF AF 1C 00 B1 AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 59 00 40 14 00 00 00 00 00 00 51 8E 4C 00 20 12 21 40 20 02 21 48 00 00 04 00 05 8D 11 00 A0 10 FF FF A3 24 00 31 03 00 21 30 06 01 08 00 C6 8C 12 00 C0 14 00 00 00 00 00 29 05 00 E8 FF A5 24 08 00 60 10 21 28 05 01 F0 FF A5 24 10 00 A6 8C 0B 00 C0 14 FF FF 67 24 21 18 E0 00 FB FF 60 14 F0 FF A5 24 00 00 03 8D 04 00 00 AD 29 00 60 10 21 48 00 01 ?? ?? ?? 0? 21 40 60 00 21 18 A0 00 20 00 05 24 21 00 65 10 00 00 00 00 00 89 03 00 08 00 31 26 01 00 63 24 21 88 11 01 04 00 03 AD ?? ?? 03 3C ?? ?? 64 8C ?? ?? 65 8C 01 00 82 24 2B 20 44 00 21 20 85 00 01 00 05 24 00 00 25 AE ?? ?? 62 AC ?? ?? 64 AC ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 23 00 40 10 ?? ?? 04 26 24 00 BF 8F 21 10 20 02 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 05 00 20 11 01 00 04 24 01 00 02 24 08 00 31 25 ?? ?? ?? 0? 04 00 22 AD ?? ?? ?? 0? 08 02 05 24 0C 00 40 10 21 48 40 00 00 00 51 AC ?? ?? ?? 0? 00 00 42 AE ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 64 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? ?? 0? 21 88 00 00 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? 00 00 51 8E 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 24 00 BF 8F }
	condition:
		$1
}

rule file_151_1_0 {
	meta:
		name = "__internal_atexit"
		size = 108
		refs = "0020 __new_exitfn"
	strings:
		$1 = { D8 FF BD 27 18 00 B0 AF 21 80 80 00 21 20 E0 00 20 00 B2 AF 1C 00 B1 AF 24 00 BF AF 21 90 A0 00 ?? ?? ?? 0? 21 88 C0 00 0E 00 40 10 00 00 00 00 04 00 50 AC 08 00 52 AC 0C 00 51 AC 0F 00 00 00 04 00 03 24 00 00 43 AC 21 10 00 00 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "__sched_getscheduler"
		size = 28
	strings:
		$1 = { 41 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "putmsg"
		size = 112
		refs = "0004 __gnu_local_gp 005c __libc_errno"
	strings:
		$1 = { E8 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 14 00 BE AF 21 F0 A0 03 F0 FF BD 27 21 10 E0 00 00 00 DC AF 08 00 DD AF FF FF 07 24 E0 FF BD 27 10 00 A2 AF 71 10 02 24 0C 00 00 00 20 00 BD 27 05 00 E0 14 00 00 00 00 21 E8 C0 03 14 00 BE 8F 08 00 E0 03 18 00 BD 27 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__wcscat_chk"
		size = 116
		refs = "006c __chk_fail"
	strings:
		$1 = { E0 FF BD 27 FF FF C6 24 21 18 80 00 1C 00 BF AF FF FF 0A 24 15 00 CA 10 04 00 67 24 00 00 68 8C 04 00 00 11 FF FF C9 24 21 30 20 01 ?? ?? ?? 0? 21 18 E0 00 ?? ?? ?? 0? FC FF 63 24 0B 00 C0 10 FF FF C7 24 21 30 E0 00 04 00 A5 24 FC FF A7 8C 04 00 63 24 F9 FF E0 14 00 00 67 AC 1C 00 BF 8F 21 10 80 00 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "__readlinkat_chk"
		size = 40
		refs = "0018 readlinkat 0020 __chk_fail"
	strings:
		$1 = { E0 FF BD 27 30 00 A2 8F 2B 10 47 00 04 00 40 14 1C 00 BF AF 1C 00 BF 8F ?? ?? ?? 0? 20 00 BD 27 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "_IO_wpadn"
		size = 280
	strings:
		$1 = { 90 FF BD 27 20 00 02 24 64 00 B2 AF 5C 00 B0 AF 6C 00 BF AF 68 00 B3 AF 60 00 B1 AF 21 90 80 00 37 00 A2 10 21 80 C0 00 30 00 02 24 37 00 A2 10 54 00 A2 27 14 00 A3 27 00 00 45 AC FC FF 42 24 FD FF 43 14 18 00 B3 27 10 00 02 2A 05 00 40 10 21 88 00 00 ?? ?? ?? 0? 00 00 00 00 17 00 80 14 00 00 00 00 98 00 42 8E 21 20 40 02 21 28 60 02 1C 00 59 8C 10 00 06 24 09 F8 20 03 F0 FF 10 26 10 00 03 24 10 00 04 2A F4 FF 43 10 21 88 22 02 6C 00 BF 8F 27 10 02 00 FF FF 03 24 0B 18 22 02 68 00 B3 8F 64 00 B2 8F 60 00 B1 8F 5C 00 B0 8F 21 10 60 00 08 00 E0 03 70 00 BD 27 07 00 00 1A 21 20 40 02 98 00 42 8E 21 28 60 02 1C 00 59 8C 09 F8 20 03 21 30 00 02 21 88 22 02 6C 00 BF 8F 21 18 20 02 68 00 B3 8F 64 00 B2 8F 60 00 B1 8F 5C 00 B0 8F 21 10 60 00 08 00 E0 03 70 00 BD 27 ?? ?? 13 3C ?? ?? ?? 0? ?? ?? 73 26 ?? ?? 13 3C ?? ?? ?? 0? ?? ?? 73 26 }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "mkostemps"
		size = 52
		refs = "0008 __gen_tempname 0004 __gnu_local_gp 001c __libc_errno"
	strings:
		$1 = { 03 00 A0 04 ?? ?? 1C 3C ?? ?? ?? 0? 21 38 00 00 ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "fgets_unlocked"
		size = 232
		refs = "000c __gnu_local_gp 005c _IO_getline 00ac __libc_errno"
	strings:
		$1 = { 34 00 A0 18 21 18 A0 00 D0 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 24 00 B1 AF 21 88 80 00 01 00 04 24 2C 00 BF AF 28 00 B2 AF 20 00 B0 AF 2B 00 A4 10 18 00 BC AF 00 00 C2 8C 10 00 A4 AF DF FF 04 24 24 20 44 00 00 00 C4 AC 21 80 C0 00 21 20 C0 00 21 28 20 02 FF FF 66 24 0A 00 07 24 ?? ?? ?? 0? 20 00 52 30 18 00 BC 8F 0B 00 40 14 00 00 04 8E 21 88 00 00 25 20 92 00 00 00 04 AE 21 10 20 02 2C 00 BF 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 20 00 83 30 09 00 60 10 00 00 00 00 3B E8 03 7C 21 28 60 00 ?? ?? 83 8F 21 28 65 00 00 00 A5 8C 0B 00 03 24 EC FF A3 14 00 00 00 00 21 10 22 02 00 00 40 A0 ?? ?? ?? 0? 00 00 04 8E 08 00 E0 03 21 10 00 00 00 00 20 A2 ?? ?? ?? 0? 21 10 20 02 }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "enlarge_userbuf.part.0"
		size = 572
		refs = "00cc __wmemcpy 00f8 _IO_wsetb 0178 wmemset 0230 $LC0 0238 $LC1 0224 __assert_fail 0214 __PRETTY_FUNCTION__.10309"
	strings:
		$1 = { B8 FF BD 27 2C 00 B3 AF 3C 00 93 8C 20 00 B0 AF 5C 00 90 8C 08 00 73 32 3C 00 B7 AF 24 00 B1 AF 44 00 BF AF 40 00 BE AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 28 00 B2 AF 21 88 80 00 14 00 03 8E 0F 00 60 12 0C 00 17 8E 44 00 BF 8F 01 00 13 24 21 10 60 02 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 A0 00 99 8C 64 00 DE 24 80 F0 1E 00 18 00 14 8E 21 20 C0 03 18 00 A3 AF 21 A8 C0 00 09 F8 20 03 21 B0 E0 00 21 90 40 00 E7 FF 40 10 18 00 A3 8F 0D 00 80 12 21 20 40 02 5C 00 22 8E 21 28 80 02 1C 00 46 8C 18 00 42 8C 23 30 C2 00 ?? ?? ?? 0? 83 30 06 00 A4 00 39 8E 09 F8 20 03 21 20 80 02 18 00 A3 8F 18 00 00 AE 21 30 5E 02 21 20 20 02 21 28 40 02 01 00 07 24 ?? ?? ?? 0? 23 B8 77 00 58 00 A2 8F 2B 00 40 10 83 30 17 00 00 00 02 8E 0C 00 07 8E 10 00 05 8E 14 00 04 8E 1C 00 03 8E 23 38 F4 00 23 28 B4 00 23 20 94 00 C3 BF 17 00 23 A0 54 00 21 38 47 02 21 28 45 02 21 20 44 02 21 A0 54 02 2A 10 D7 02 0C 00 07 AE 10 00 05 AE 14 00 04 AE 00 00 14 AE 08 00 12 AE 2B 00 40 14 04 00 03 AE 31 00 F6 12 2B 10 A6 02 80 20 06 00 21 20 44 02 23 30 A6 02 ?? ?? ?? 0? 21 28 00 00 44 00 BF 8F 21 10 60 02 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 10 00 02 8E 08 00 07 8E 00 00 05 8E 04 00 04 8E 1C 00 03 8E 23 38 F4 00 23 28 B4 00 23 20 94 00 C3 BF 17 00 23 A0 54 00 21 38 47 02 21 28 45 02 21 20 44 02 21 A0 54 02 2A 10 D7 02 08 00 07 AE 00 00 05 AE 04 00 04 AE 10 00 14 AE 0C 00 12 AE D7 FF 40 10 14 00 03 AE ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 E6 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 CF FF 40 10 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 05 3C }
	condition:
		$1
}

rule file_159_1_0 {
	meta:
		name = "_IO_wstr_underflow"
		size = 108
	strings:
		$1 = { 5C 00 82 8C 10 00 43 8C 04 00 45 8C 2B 30 A3 00 03 00 C0 10 00 00 00 00 04 00 43 AC 21 28 60 00 00 00 86 8C 00 0C 07 24 00 0C C8 30 09 00 07 11 FF F7 08 24 00 00 43 8C 2B 28 65 00 03 00 A0 14 FF FF 02 24 08 00 E0 03 00 00 00 00 08 00 E0 03 00 00 62 8C 14 00 47 8C 24 30 C8 00 00 00 86 AC 00 00 43 AC ?? ?? ?? 0? 10 00 47 AC }
	condition:
		$1
}

rule file_159_2_0 {
	meta:
		name = "_IO_wstr_overflow"
		size = 576
		refs = "0130 __wmemcpy 0158 wmemset 016c _IO_wsetb"
	strings:
		$1 = { C0 FF BD 27 1C 00 B0 AF 21 80 80 00 00 00 84 8C 24 00 B2 AF 01 00 B2 24 08 00 82 30 20 00 B1 AF 3C 00 BF AF 38 00 B7 AF 34 00 B6 AF 30 00 B5 AF 2C 00 B4 AF 28 00 B3 AF 21 88 A0 00 0E 00 40 10 01 00 52 2E 01 00 52 3A 23 10 12 00 3C 00 BF 8F 38 00 B7 8F 34 00 B6 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 40 00 BD 27 00 0C 83 30 00 04 02 24 63 00 62 10 00 08 84 34 5C 00 03 8E 10 00 62 8C 18 00 74 8C 1C 00 73 8C 0C 00 64 8C 23 98 74 02 23 10 44 00 83 98 13 00 83 10 02 00 21 20 72 02 2B 10 44 00 43 00 40 14 00 00 00 00 3C 00 02 8E 08 00 42 30 0D 00 40 10 32 00 62 26 3C 00 BF 8F 38 00 B7 8F 34 00 B6 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F FF FF 02 24 08 00 E0 03 40 00 BD 27 40 A8 02 00 2B 18 B3 02 F2 FF 60 14 3C 00 BF 8F A0 00 19 8E C0 B8 02 00 09 F8 20 03 21 20 E0 02 EB FF 40 10 21 B0 40 00 09 00 80 12 21 20 40 00 21 28 80 02 ?? ?? ?? 0? 21 30 60 02 A4 00 19 8E 09 F8 20 03 21 20 80 02 5C 00 02 8E 18 00 40 AC 80 20 13 00 21 20 C4 02 21 28 00 00 ?? ?? ?? 0? 23 30 B3 02 21 20 00 02 21 28 C0 02 21 30 D7 02 ?? ?? ?? 0? 01 00 07 24 5C 00 03 8E 08 00 67 8C 00 00 66 8C 04 00 65 8C 10 00 64 8C 1C 00 62 8C 23 38 F4 00 23 30 D4 00 23 28 B4 00 23 20 94 00 21 38 C7 02 21 30 C6 02 21 28 C5 02 21 20 C4 02 08 00 67 AC 00 00 66 AC 04 00 65 AC 10 00 64 AC 0C 00 76 AC 14 00 62 AC 19 00 40 12 00 00 00 00 10 00 64 8C 04 00 65 8C 2B 28 A4 00 9C FF A0 10 21 10 20 02 3C 00 BF 8F 38 00 B7 8F 34 00 B6 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 04 00 64 AC 08 00 E0 03 40 00 BD 27 5C 00 03 8E 00 00 04 AE 00 00 62 8C 04 00 64 8C 10 00 62 AC ?? ?? ?? 0? 00 00 64 AC 10 00 62 8C 04 00 44 24 10 00 64 AC ?? ?? ?? 0? 00 00 51 AC }
	condition:
		$1
}

rule file_159_3_0 {
	meta:
		name = "_IO_wstr_pbackfail"
		size = 40
		refs = "0020 _IO_wdefault_pbackfail"
	strings:
		$1 = { 00 00 82 8C 08 00 42 30 05 00 40 10 FF FF 02 24 03 00 A2 10 00 00 00 00 08 00 E0 03 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_159_4_0 {
	meta:
		name = "_IO_wstr_finish"
		size = 88
		refs = "0050 _IO_wdefault_finish"
	strings:
		$1 = { 5C 00 82 8C E0 FF BD 27 18 00 B0 AF 21 80 80 00 18 00 44 8C 09 00 80 10 1C 00 BF AF 3C 00 03 8E 08 00 63 30 06 00 60 14 1C 00 BF 8F A4 00 19 8E 09 F8 20 03 00 00 00 00 5C 00 02 8E 1C 00 BF 8F 21 20 00 02 18 00 B0 8F 18 00 40 AC 21 28 00 00 ?? ?? ?? 0? 20 00 BD 27 }
	condition:
		$1
}

rule file_159_5_0 {
	meta:
		name = "_IO_wstr_seekoff"
		size = 812
	strings:
		$1 = { C8 FF BD 27 28 00 B2 AF 4C 00 B2 8F 2C 00 B3 AF 24 00 B1 AF 20 00 B0 AF 34 00 BF AF 30 00 B4 AF 21 88 80 00 21 80 C0 00 33 00 40 16 21 98 E0 00 00 00 82 8C 00 04 43 30 57 00 60 10 00 00 00 00 00 08 42 30 71 00 40 10 00 00 00 00 5C 00 85 8C 10 00 A2 8C 04 00 A3 8C 08 00 A4 8C 2B A0 62 00 0A 10 74 00 23 A0 44 00 83 A0 14 00 48 00 A3 8F 01 00 02 24 7D 00 62 10 02 00 02 24 06 00 62 14 21 10 14 02 C3 1F 14 00 2B 20 50 00 21 98 63 02 21 80 40 00 21 98 93 00 2F 00 60 06 2A A0 90 02 07 00 80 12 00 00 00 00 20 00 23 8E 1C 00 22 8E 23 10 62 00 2A 10 50 00 94 00 40 14 21 20 20 02 0C 00 A4 8C 34 00 BF 8F 80 18 10 00 21 18 83 00 21 10 00 02 10 00 A3 AC 30 00 B4 8F 21 18 60 02 28 00 B2 8F 2C 00 B3 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 5C 00 85 8C 01 00 46 32 04 00 A2 8C 10 00 A3 8C 08 00 A4 8C 2B A0 62 00 0A 10 74 00 23 A0 44 00 12 00 C0 10 83 A0 14 00 48 00 A3 8F 01 00 02 24 44 00 62 10 00 00 00 00 02 00 02 24 06 00 62 14 21 10 14 02 C3 1F 14 00 2B 20 50 00 21 98 63 02 21 80 40 00 21 98 93 00 51 00 61 06 00 00 00 00 FF FF 02 24 ?? ?? ?? 0? FF FF 03 24 02 00 52 32 FF FF 02 24 FF FF 03 24 BE FF 40 16 00 00 00 00 34 00 BF 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 08 00 42 30 0E 00 40 10 34 00 BF 8F 5C 00 22 8E 30 00 B4 8F 00 00 43 8C 08 00 42 8C 2C 00 B3 8F 28 00 B2 8F 23 18 62 00 83 10 03 00 24 00 B1 8F 20 00 B0 8F C3 1F 03 00 08 00 E0 03 38 00 BD 27 5C 00 22 8E 30 00 B4 8F 10 00 43 8C 0C 00 42 8C 2C 00 B3 8F 28 00 B2 8F 23 18 62 00 83 10 03 00 24 00 B1 8F 20 00 B0 8F C3 1F 03 00 08 00 E0 03 38 00 BD 27 5C 00 85 8C 01 00 12 24 04 00 A3 8C 10 00 A2 8C 08 00 A4 8C 2B A0 62 00 0A 10 74 00 48 00 A3 8F 23 A0 44 00 01 00 02 24 BE FF 62 14 83 A0 14 00 00 00 A2 8C 23 20 44 00 83 10 04 00 21 10 02 02 C3 27 04 00 2B 30 50 00 21 98 64 02 21 98 D3 00 BE FF 60 06 21 80 40 00 ?? ?? ?? 0? 2A 10 90 02 0C 00 A2 8C 10 00 A3 8C 23 18 62 00 83 10 03 00 21 10 02 02 C3 1F 03 00 2B 20 50 00 21 98 63 02 21 80 40 00 ?? ?? ?? 0? 21 98 93 00 2A 10 90 02 07 00 40 10 00 00 00 00 20 00 23 8E 1C 00 22 8E 23 10 62 00 2A 10 50 00 0C 00 40 14 21 20 20 02 08 00 A2 8C 80 18 10 00 80 20 14 00 21 18 43 00 21 10 44 00 00 00 A3 AC 04 00 A2 AC 02 00 52 32 21 10 00 02 ?? ?? ?? 0? 21 18 60 02 01 00 02 24 10 00 A2 AF 21 30 00 02 ?? ?? ?? 0? 21 38 60 02 96 FF 40 14 00 00 00 00 ?? ?? ?? 0? 5C 00 25 8E 10 00 A0 AF 21 30 00 02 ?? ?? ?? 0? 21 38 60 02 8F FF 40 14 FF FF 02 24 ?? ?? ?? 0? 5C 00 25 8E }
	condition:
		$1
}

rule file_159_6_0 {
	meta:
		name = "_IO_wstr_init_static"
		size = 224
		refs = "0028 __wcslen 0044 _IO_wsetb"
	strings:
		$1 = { D0 FF BD 27 24 00 B2 AF 20 00 B1 AF 1C 00 B0 AF 2C 00 BF AF 28 00 B3 AF 21 88 80 00 21 80 A0 00 1A 00 C0 14 21 90 E0 00 ?? ?? ?? 0? 21 20 A0 00 80 10 02 00 21 98 02 02 21 20 20 02 21 28 00 02 21 30 60 02 ?? ?? ?? 0? 21 38 00 00 5C 00 23 8E 0C 00 70 AC 08 00 70 AC 16 00 40 12 00 00 70 AC 2C 00 BF 8F 10 00 72 AC 14 00 73 AC 04 00 72 AC 28 00 B3 8F A0 00 20 AE 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 80 98 06 00 21 98 65 02 2B 10 B3 00 E8 FF 40 14 21 20 20 02 27 98 05 00 82 98 13 00 80 98 13 00 ?? ?? ?? 0? 21 98 B3 00 2C 00 BF 8F 10 00 70 AC 14 00 70 AC 04 00 73 AC 24 00 B2 8F A0 00 20 AE 28 00 B3 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_159_7_0 {
	meta:
		name = "_IO_wstr_count"
		size = 36
	strings:
		$1 = { 5C 00 82 8C 04 00 43 8C 10 00 44 8C 08 00 45 8C 2B 10 83 00 0A 18 82 00 23 10 65 00 08 00 E0 03 83 10 02 00 }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "_IO_ungetc"
		size = 424
		refs = "0074 __lll_lock_wait_private 0098 _IO_sputbackc 0154 _Unwind_Resume"
	strings:
		$1 = { D0 FF BD 27 FF FF 02 24 24 00 B1 AF 2C 00 BF AF 28 00 B2 AF 20 00 B0 AF 43 00 82 10 21 88 80 00 00 00 A2 8C 00 80 42 30 1A 00 40 14 21 80 A0 00 3B E8 03 7C 48 00 A4 8C 70 8B 72 24 08 00 83 8C 11 00 72 10 00 00 00 00 18 00 A0 AF 00 00 85 C0 06 00 A0 14 00 00 03 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 03 24 0F 00 00 00 03 00 60 14 00 00 00 00 ?? ?? ?? 0? 18 00 A5 AF 48 00 03 8E 21 20 60 00 08 00 72 AC 04 00 83 8C 01 00 63 24 04 00 83 AC FF 00 25 32 ?? ?? ?? 0? 21 20 00 02 00 00 03 8E 00 80 63 30 06 00 60 14 21 88 40 00 48 00 04 8E 04 00 83 8C FF FF 63 24 07 00 60 10 04 00 83 AC 2C 00 BF 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F1 FF 60 14 21 10 20 02 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 21 10 20 02 ?? ?? ?? 0? FF FF 02 24 00 00 02 8E 00 80 42 30 06 00 40 14 21 88 80 00 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "__dladdr1"
		size = 56
		refs = "0018 _dl_addr"
	strings:
		$1 = { 01 00 02 24 09 00 E2 10 21 18 C0 00 02 00 02 24 03 00 E2 14 00 00 00 00 ?? ?? ?? 0? 21 38 00 00 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 21 30 00 00 ?? ?? ?? 0? 21 38 60 00 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__fxprintf"
		size = 296
		refs = "0040 strlen 00a4 __vfwprintf 00d4 _IO_vfprintf 00fc stderr 0108 $LC0 010c $LC1 0120 __assert_fail 0110 __PRETTY_FUNCTION__.10946"
	strings:
		$1 = { C8 FF BD 27 30 00 BE AF 21 F0 A0 03 28 00 B1 AF 24 00 B0 AF 34 00 BF AF 2C 00 B2 AF 21 88 80 00 40 00 C6 AF 44 00 C7 AF 34 00 80 10 21 80 A0 00 6C 00 22 8E 40 00 C6 27 25 00 40 18 18 00 C6 AF ?? ?? ?? 0? 21 20 00 02 01 00 42 24 80 18 02 00 0A 00 63 24 C2 18 03 00 C0 18 03 00 21 90 A0 03 23 E8 A3 03 0E 00 40 10 10 00 A5 27 00 00 06 82 21 38 A0 00 07 00 C1 04 21 18 00 00 ?? ?? ?? 0? ?? ?? 04 3C 21 30 03 02 00 00 C6 80 1E 00 C0 04 04 00 E7 24 01 00 63 24 FA FF 43 14 00 00 E6 AC 18 00 C6 8F ?? ?? ?? 0? 21 20 20 02 21 E8 40 02 21 E8 C0 03 34 00 BF 8F 30 00 BE 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 21 20 20 02 ?? ?? ?? 0? 21 28 00 02 21 E8 C0 03 34 00 BF 8F 30 00 BE 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 51 8C ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 2E 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "__vdprintf_chk"
		size = 236
		refs = "0000 _IO_wfile_jumps 0044 _IO_no_init 004c _IO_file_jumps 0058 _IO_file_init 0064 _IO_file_attach 009c _IO_vfprintf 00dc _IO_un_link"
	strings:
		$1 = { ?? ?? 02 3C 68 FE BD 27 ?? ?? 42 24 90 01 B3 AF 8C 01 B2 AF 88 01 B1 AF 84 01 B0 AF 10 00 A2 AF 21 80 80 00 21 98 A0 00 E0 00 A4 27 00 80 05 34 21 90 C0 00 21 88 E0 00 21 30 00 00 20 00 A7 27 94 01 BF AF ?? ?? ?? 0? 28 01 A0 AF ?? ?? 02 3C ?? ?? 42 24 E0 00 A4 27 ?? ?? ?? 0? 78 01 A2 AF E0 00 A4 27 ?? ?? ?? 0? 21 28 00 02 1B 00 40 10 E0 00 A3 8F F3 EF 02 24 24 10 62 00 44 00 42 34 04 00 60 1A E0 00 A2 AF 1C 01 A2 8F 04 00 42 34 1C 01 A2 AF E0 00 A4 27 21 28 40 02 ?? ?? ?? 0? 21 30 20 02 21 80 40 00 78 01 A2 8F E0 00 A4 27 08 00 59 8C 09 F8 20 03 21 28 00 00 21 10 00 02 94 01 BF 8F 90 01 B3 8F 8C 01 B2 8F 88 01 B1 8F 84 01 B0 8F 08 00 E0 03 98 01 BD 27 ?? ?? ?? 0? E0 00 A4 27 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "__tcgetattr"
		size = 204
		refs = "0000 __gnu_local_gp 006c mempcpy 00b8 __libc_errno"
	strings:
		$1 = { ?? ?? 1C 3C B0 FF BD 27 ?? ?? 9C 27 18 00 A6 27 44 00 B0 AF 4C 00 BF AF 21 80 A0 00 48 00 B1 AF 10 00 BC AF 0D 54 05 24 D6 0F 02 24 0C 00 00 00 1F 00 E0 14 21 88 40 00 17 00 40 14 18 00 A2 8F 11 00 04 26 29 00 A5 27 00 00 02 AE 1C 00 A2 8F 17 00 06 24 04 00 02 AE 20 00 A2 8F 08 00 02 AE 24 00 A2 8F 0C 00 02 AE 28 00 A2 93 ?? ?? ?? 0? 10 00 02 A2 00 00 40 A0 01 00 40 A0 02 00 40 A0 03 00 40 A0 04 00 40 A0 05 00 40 A0 06 00 40 A0 07 00 40 A0 08 00 40 A0 4C 00 BF 8F 21 10 20 02 44 00 B0 8F 48 00 B1 8F 08 00 E0 03 50 00 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 51 AC ?? ?? ?? 0? FF FF 11 24 }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "ptrace"
		size = 156
		refs = "0008 __gnu_local_gp 0050 __libc_errno"
	strings:
		$1 = { E8 FF BD 27 1C 00 A2 27 ?? ?? 1C 3C 14 00 B0 AF FF FF 90 24 ?? ?? 9C 27 03 00 10 2E 08 00 A2 AF 0C 00 A2 27 24 00 A7 AF 00 00 BC AF 1C 00 A5 AF 20 00 A6 AF 0B 38 50 00 BA 0F 02 24 0C 00 00 00 0A 00 E0 10 21 20 40 00 3B E8 03 7C 21 28 60 00 ?? ?? 83 8F FF FF 02 24 21 28 65 00 00 00 A4 AC 14 00 B0 8F 08 00 E0 03 18 00 BD 27 FC FF 40 04 00 00 00 00 FA FF 00 12 14 00 B0 8F 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 0C 00 A2 8F 21 20 64 00 00 00 80 AC 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "__inet_aton"
		size = 456
		refs = "0000 __gnu_local_gp 0010 __libc_errno 0088 strtoul 019c __libc_tsd_CTYPE_B"
	strings:
		$1 = { ?? ?? 1C 3C B0 FF BD 27 ?? ?? 9C 27 30 00 B2 AF ?? ?? 92 8F 3B E8 03 7C 40 00 B6 AF 21 B0 43 02 38 00 B4 AF 34 00 B3 AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 3C 00 B5 AF 2C 00 B1 AF 28 00 B0 AF 10 00 BC AF 00 00 D3 8E 00 00 C0 AE 00 00 82 80 21 A0 80 00 D0 FF 42 24 0A 00 42 2C 1F 00 40 10 1C 00 A0 AF 1C 00 A2 27 21 B8 A0 00 20 00 A2 AF 21 F0 40 00 FF FF 10 24 22 00 15 24 1F 00 B1 27 21 30 00 00 21 20 80 02 ?? ?? ?? 0? 18 00 A5 27 00 01 46 2C 20 00 50 10 10 00 BC 8F 18 00 A5 8F 2E 00 03 24 00 00 A4 80 20 00 83 14 00 00 00 00 09 00 D1 13 00 00 00 00 07 00 C0 10 01 00 DE 27 FF FF C2 A3 01 00 A2 80 D0 FF 42 24 0A 00 42 2C EB FF 40 14 01 00 B4 24 3B E8 03 7C 21 90 43 02 00 00 53 AE 21 10 00 00 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 00 00 C3 8E DF FF 75 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 17 00 80 14 00 00 00 00 E8 FF B4 10 20 00 A3 8F 23 20 C3 03 ?? ?? 03 3C 80 20 04 00 ?? ?? 63 24 21 18 83 00 00 00 63 8C 2B 18 62 00 DF FF 60 14 00 00 00 00 05 00 E0 12 1C 00 A3 8F A0 10 02 7C 02 14 22 00 25 10 43 00 00 00 E2 AE 3B E8 03 7C 21 10 43 02 00 00 53 AC ?? ?? ?? 0? 01 00 02 24 D2 FF 80 04 00 00 00 00 3B E8 03 7C 21 30 60 00 ?? ?? 83 8F 40 20 04 00 21 30 66 00 00 00 C3 8C 21 18 64 00 00 00 63 94 00 20 63 30 C7 FF 60 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_166_1_0 {
	meta:
		name = "inet_addr"
		size = 44
		refs = "0008 __inet_aton"
	strings:
		$1 = { D8 FF BD 27 24 00 BF AF ?? ?? ?? 0? 18 00 A5 27 18 00 A4 8F 24 00 BF 8F FF FF 03 24 0B 18 82 00 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_167_1_0 {
	meta:
		name = "svcunix_getargs"
		size = 20
		altNames = "svctcp_getargs"
	strings:
		$1 = { 2C 00 84 8C 21 C8 A0 00 21 28 C0 00 08 00 20 03 08 00 84 24 }
	condition:
		$1
}

rule file_167_2_0 {
	meta:
		name = "svcunix_freeargs"
		size = 28
		altNames = "svctcp_freeargs"
	strings:
		$1 = { 2C 00 84 8C 02 00 02 24 21 C8 A0 00 08 00 82 AC 21 28 C0 00 08 00 20 03 08 00 84 24 }
	condition:
		$1
}

rule file_167_3_0 {
	meta:
		name = "svcunix_destroy"
		size = 112
		refs = "0014 xprt_unregister 001c __close 0048 free"
		altNames = "svctcp_destroy"
	strings:
		$1 = { D8 FF BD 27 1C 00 B0 AF 21 80 80 00 24 00 BF AF 20 00 B1 AF ?? ?? ?? 0? 2C 00 91 8C ?? ?? ?? 0? 00 00 04 8E 04 00 02 96 0F 00 40 14 00 00 00 00 0C 00 22 8E 1C 00 59 8C 03 00 20 13 00 00 00 00 09 F8 20 03 08 00 24 26 ?? ?? ?? 0? 21 20 20 02 24 00 BF 8F 20 00 B1 8F 21 20 00 02 1C 00 B0 8F ?? ?? ?? 0? 28 00 BD 27 ?? ?? ?? 0? 04 00 00 A6 }
	condition:
		$1
}

rule file_167_5_0 {
	meta:
		name = "makefd_xprt"
		size = 284
		refs = "0028 malloc 0074 xdrrec_create 00a4 xprt_register 00d0 _libc_intl_domainname 00d4 $LC0 00e0 __dcgettext 00e8 $LC1 00ec $LC2 00fc __fxprintf 0104 free"
	strings:
		$1 = { C8 FF BD 27 28 00 B2 AF 21 90 80 00 34 01 04 24 34 00 BF AF 30 00 B4 AF 2C 00 B3 AF 24 00 B1 AF 20 00 B0 AF 21 A0 A0 00 ?? ?? ?? 0? 21 98 C0 00 B0 01 04 24 ?? ?? ?? 0? 21 80 40 00 24 00 00 12 21 88 40 00 22 00 40 10 21 28 80 02 08 00 44 24 ?? ?? 02 3C ?? ?? 42 24 10 00 A2 AF ?? ?? 02 3C ?? ?? 42 24 21 30 60 02 21 38 00 02 14 00 A2 AF 02 00 02 24 ?? ?? ?? 0? 00 00 22 AE 20 00 22 26 24 00 02 AE ?? ?? 02 3C ?? ?? 42 24 21 20 00 02 08 00 02 AE 30 00 00 AE 2C 00 11 AE 0C 00 00 AE 04 00 00 A6 ?? ?? ?? 0? 00 00 12 AE 21 10 00 02 34 00 BF 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? 05 3C ?? ?? 06 3C ?? ?? A5 24 ?? ?? C6 24 21 38 40 00 ?? ?? ?? 0? 21 20 00 00 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 20 20 02 ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_167_6_0 {
	meta:
		name = "readunix"
		size = 392
		refs = "0000 __gnu_local_gp 0010 __libc_errno 0064 __poll 00e0 __setsockopt 0118 __recvmsg"
	strings:
		$1 = { ?? ?? 1C 3C 90 FF BD 27 ?? ?? 9C 27 60 00 B4 AF ?? ?? 94 8F 50 00 B0 AF 00 00 90 8C 3B E8 03 7C 68 00 B6 AF 64 00 B5 AF 5C 00 B3 AF 58 00 B2 AF 54 00 B1 AF 6C 00 BF AF 18 00 BC AF 21 98 80 00 21 B0 A0 00 21 A8 C0 00 01 00 12 24 FF FF 11 24 21 A0 83 02 44 00 A4 27 01 00 05 24 B8 88 06 34 44 00 B0 AF ?? ?? ?? 0? 48 00 B2 A7 40 00 51 10 00 00 00 00 31 00 40 10 4A 00 A2 97 38 00 43 30 2E 00 60 14 01 00 42 30 F3 FF 40 10 44 00 A4 27 04 00 03 24 10 00 A3 AF 3C 00 A3 27 28 00 A3 AF ?? ?? 03 3C ?? ?? 63 24 01 00 02 24 30 00 A3 AF 21 20 00 02 1C 00 03 24 FF FF 05 34 11 00 06 24 4C 00 A7 27 3C 00 B6 AF 40 00 B5 AF 2C 00 A2 AF 20 00 A0 AF 24 00 A0 AF 34 00 A3 AF 38 00 A0 AF ?? ?? ?? 0? 4C 00 A2 AF 14 00 40 14 18 00 BC 8F ?? ?? 91 8F 3B E8 03 7C 04 00 12 24 ?? ?? ?? 0? 21 88 23 02 00 00 22 8E 0C 00 52 14 00 00 00 00 21 20 00 02 20 00 A5 27 ?? ?? ?? 0? 21 30 00 00 F8 FF 40 04 38 00 A3 8F 08 00 63 30 03 00 60 14 00 00 00 00 05 00 40 14 6C 00 BF 8F 2C 00 63 8E FF FF 02 24 00 00 60 AC 6C 00 BF 8F 68 00 B6 8F 64 00 B5 8F 60 00 B4 8F 5C 00 B3 8F 58 00 B2 8F 54 00 B1 8F 50 00 B0 8F 08 00 E0 03 70 00 BD 27 00 00 83 8E 04 00 02 24 F0 FF 62 14 4A 00 A2 97 ?? ?? ?? 0? 01 00 42 30 }
	condition:
		$1
}

rule file_167_7_0 {
	meta:
		name = "writeunix"
		size = 364
		refs = "0000 __gnu_local_gp 0040 __libc_errno 0060 __getpid 0068 __geteuid 0070 __getegid 00e4 __sendmsg"
	strings:
		$1 = { ?? ?? 1C 3C 98 FF BD 27 ?? ?? 9C 27 64 00 BF AF 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 48 00 B2 AF 44 00 B1 AF 40 00 B0 AF 10 00 BC AF 31 00 C0 18 70 00 A6 AF ?? ?? 92 8F ?? ?? 17 3C 3B E8 03 7C 21 B0 80 00 21 A8 A0 00 21 A0 C0 00 ?? ?? F3 26 21 90 43 02 ?? ?? ?? 0? 00 00 D0 8E ?? ?? ?? 0? 21 F0 40 00 ?? ?? ?? 0? 21 88 40 00 14 00 62 AE FF FF 02 34 04 00 62 AE 02 00 02 24 08 00 62 AE 34 00 A2 27 18 00 03 24 20 00 A2 AF 01 00 02 24 10 00 71 AE 0C 00 7E AE ?? ?? E3 AE 34 00 B5 AF 38 00 B4 AF 24 00 A2 AF 18 00 A0 AF 1C 00 A0 AF 28 00 B3 AF 2C 00 A3 AF 30 00 A0 AF ?? ?? ?? 0? 04 00 11 24 00 00 42 8E 17 00 51 14 64 00 BF 8F 21 20 00 02 18 00 A5 27 ?? ?? ?? 0? 21 30 00 00 F8 FF 40 04 00 00 00 00 23 A0 82 02 D9 FF 80 1E 21 A8 A2 02 64 00 BF 8F 70 00 A2 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 2C 00 C3 8E 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F FF FF 02 24 00 00 60 AC 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_167_8_0 {
	meta:
		name = "rendezvous_request"
		size = 288
		refs = "0000 __gnu_local_gp 0010 __libc_errno 0060 accept 00f4 __svc_accept_failed"
	strings:
		$1 = { ?? ?? 1C 3C 48 FF BD 27 ?? ?? 9C 27 AC 00 B3 AF ?? ?? 93 8F 3B E8 03 7C B0 00 B4 AF A8 00 B2 AF A4 00 B1 AF A0 00 B0 AF B4 00 BF AF 10 00 BC AF 21 80 80 00 2C 00 94 8C 6E 00 11 24 21 98 63 02 ?? ?? ?? 0? 04 00 12 24 00 00 62 8E 29 00 52 14 00 00 00 00 00 00 04 8E 18 00 A5 27 98 00 A6 27 ?? ?? ?? 0? 98 00 B1 AF F7 FF 40 04 21 20 40 00 00 00 85 8E 04 00 86 8E 01 00 02 24 88 00 A0 AF 8C 00 A0 AF 90 00 A0 AF 94 00 A0 AF ?? ?? ?? 0? 88 00 A2 A7 88 00 A4 8F 10 00 43 24 8C 00 A6 8F 03 00 64 A8 00 00 64 B8 90 00 A5 8F 07 00 66 A8 04 00 66 B8 94 00 A4 8F 0B 00 65 A8 08 00 65 B8 0F 00 64 A8 0C 00 64 B8 B4 00 BF 8F 98 00 A3 8F B0 00 B4 8F AC 00 B3 8F 0C 00 43 AC A8 00 B2 8F A4 00 B1 8F A0 00 B0 8F 21 10 00 00 08 00 E0 03 B8 00 BD 27 ?? ?? ?? 0? 00 00 00 00 B4 00 BF 8F B0 00 B4 8F AC 00 B3 8F A8 00 B2 8F A4 00 B1 8F A0 00 B0 8F 21 10 00 00 08 00 E0 03 B8 00 BD 27 }
	condition:
		$1
}

rule file_167_9_0 {
	meta:
		name = "svcunix_reply"
		size = 84
		refs = "0024 xdr_replymsg 0034 xdrrec_endofrecord"
		altNames = "svctcp_reply"
	strings:
		$1 = { 2C 00 82 8C D8 FF BD 27 1C 00 B0 AF 04 00 43 8C 08 00 50 24 24 00 BF AF 20 00 B1 AF 21 20 00 02 08 00 40 AC ?? ?? ?? 0? 00 00 A3 AC 21 20 00 02 01 00 05 24 ?? ?? ?? 0? 21 88 40 00 24 00 BF 8F 21 10 20 02 1C 00 B0 8F 20 00 B1 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_167_10_0 {
	meta:
		name = "svcunix_stat"
		size = 68
		refs = "0020 xdrrec_eof"
		altNames = "svctcp_stat"
	strings:
		$1 = { 2C 00 84 8C 00 00 83 8C 03 00 60 14 21 10 60 00 08 00 E0 03 00 00 00 00 E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 08 00 84 24 1C 00 BF 8F 02 00 04 24 01 00 03 24 0B 18 82 00 21 10 60 00 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_167_11_0 {
	meta:
		name = "svcunix_recv"
		size = 168
		refs = "002c xdrrec_skiprecord 0038 xdr_callmsg"
	strings:
		$1 = { D0 FF BD 27 1C 00 B0 AF 2C 00 90 8C 28 00 B3 AF 24 00 B2 AF 01 00 13 24 08 00 12 26 2C 00 BF AF 20 00 B1 AF 21 20 40 02 21 88 A0 00 ?? ?? ?? 0? 08 00 13 AE 21 20 40 02 ?? ?? ?? 0? 21 28 20 02 09 00 40 14 2C 00 BF 8F 00 00 00 AE 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 21 10 00 00 08 00 E0 03 30 00 BD 27 00 00 22 8E ?? ?? 03 3C ?? ?? 63 24 04 00 02 AE 28 00 23 AE 1C 00 03 24 24 00 33 AE 2C 00 23 AE 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 01 00 02 24 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_167_12_0 {
	meta:
		name = "svcunix_create"
		size = 576
		refs = "00a4 _libc_intl_domainname 004c memset 005c strlen 0074 memcpy 0088 __bind 0098 __getsockname 00a8 $LC4 00b4 __dcgettext 00bc perror 00f8 __listen 0108 malloc 0128 _null_auth 0170 xprt_register 01a0 __close 01b8 __socket 01d0 $LC3 01f8 $LC0 020c $LC1 0210 __func__.10010 0220 __fxprintf 0228 free"
	strings:
		$1 = { 50 FF BD 27 10 00 02 24 88 00 A2 AF FF FF 02 24 A8 00 B5 AF A4 00 B4 AF A0 00 B3 AF 98 00 B1 AF 94 00 B0 AF AC 00 BF AF 9C 00 B2 AF 21 80 80 00 21 A8 A0 00 21 A0 C0 00 21 88 E0 00 5C 00 82 10 21 98 00 00 21 28 00 00 6E 00 06 24 ?? ?? ?? 0? 18 00 A4 27 21 20 20 02 01 00 02 24 ?? ?? ?? 0? 18 00 A2 A7 21 90 40 00 1A 00 A4 27 21 28 20 02 01 00 46 24 ?? ?? ?? 0? 03 00 52 26 21 20 00 02 18 00 A5 27 21 30 40 02 ?? ?? ?? 0? 88 00 B2 AF 21 20 00 02 18 00 A5 27 ?? ?? ?? 0? 88 00 A6 27 14 00 40 10 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? ?? 0? 21 20 40 00 36 00 60 16 00 00 00 00 21 10 00 00 AC 00 BF 8F A8 00 B5 8F A4 00 B4 8F A0 00 B3 8F 9C 00 B2 8F 98 00 B1 8F 94 00 B0 8F 08 00 E0 03 B0 00 BD 27 21 20 00 02 ?? ?? ?? 0? 80 00 05 24 E9 FF 40 14 ?? ?? 04 3C ?? ?? ?? 0? 08 00 04 24 34 01 04 24 ?? ?? ?? 0? 21 90 40 00 35 00 40 12 21 88 40 00 33 00 40 10 ?? ?? 03 3C ?? ?? 62 24 ?? ?? 65 8C 04 00 43 8C 08 00 42 8C 21 20 20 02 00 00 55 AE 28 00 22 AE ?? ?? 02 3C ?? ?? 42 24 08 00 22 AE FF FF 02 24 04 00 54 AE 2C 00 32 AE 20 00 25 AE 24 00 23 AE 04 00 22 A6 00 00 30 AE ?? ?? ?? 0? 30 00 20 AE AC 00 BF 8F 21 10 20 02 A8 00 B5 8F A4 00 B4 8F A0 00 B3 8F 9C 00 B2 8F 98 00 B1 8F 94 00 B0 8F 08 00 E0 03 B0 00 BD 27 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 10 00 00 01 00 04 24 02 00 05 24 ?? ?? ?? 0? 21 30 00 00 21 80 40 00 9F FF 41 04 01 00 13 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 21 10 00 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? 05 3C ?? ?? 06 3C ?? ?? A5 24 ?? ?? C6 24 21 38 40 00 ?? ?? ?? 0? 21 20 00 00 ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? 21 20 20 02 ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "strerror"
		size = 240
		refs = "0000 __gnu_local_gp 002c __strerror_r 0058 __libc_errno 00ac malloc 00d4 _libc_intl_domainname 00d8 $LC0 00e8 __dcgettext"
	strings:
		$1 = { ?? ?? 1C 3C D0 FF BD 27 ?? ?? 9C 27 21 28 00 00 21 30 00 00 1C 00 B0 AF 10 00 BC AF 2C 00 BF AF 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF ?? ?? ?? 0? 21 80 80 00 08 00 40 10 10 00 BC 8F 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? 92 8F ?? ?? 11 3C ?? ?? 22 8E 3B E8 03 7C 21 20 43 02 0F 00 40 10 00 00 93 8C ?? ?? 25 8E 3B E8 03 7C 21 10 43 02 0F 00 A0 10 00 00 53 AC 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 21 20 00 02 1C 00 B0 8F 00 04 06 24 ?? ?? ?? 0? 30 00 BD 27 ?? ?? ?? 0? 00 04 04 24 ?? ?? 22 AE ?? ?? ?? 0? 10 00 BC 8F 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 05 00 06 24 ?? ?? ?? 0? 30 00 BD 27 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "__syscall_error"
		size = 48
		refs = "000c __errno_location"
	strings:
		$1 = { E0 FF BD 27 14 00 A2 AF 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 A8 8F 00 00 48 AC 1C 00 BF 8F 20 00 BD 27 FF FF 02 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_171_0_0 {
	meta:
		name = "__libc_chown"
		size = 28
	strings:
		$1 = { 6A 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "___fprintf_chk"
		size = 516
		refs = "0078 __lll_lock_wait_private 00bc vfprintf 01b0 _Unwind_Resume"
	strings:
		$1 = { 00 00 82 8C C8 FF BD 27 2C 00 B2 AF 00 80 42 30 28 00 B1 AF 24 00 B0 AF 34 00 BF AF 30 00 B3 AF 21 80 80 00 21 90 A0 00 44 00 A7 AF 1A 00 40 14 21 88 C0 00 3B E8 03 7C 48 00 84 8C 70 8B 73 24 08 00 82 8C 11 00 53 10 00 00 00 00 18 00 A0 AF 00 00 83 C0 06 00 60 14 00 00 02 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 02 24 0F 00 00 00 03 00 40 14 00 00 00 00 ?? ?? ?? 0? 18 00 A3 AF 48 00 02 8E 21 20 40 00 08 00 53 AC 04 00 82 8C 01 00 42 24 04 00 82 AC 05 00 40 1A 44 00 A2 27 3C 00 02 8E 04 00 42 34 3C 00 02 AE 44 00 A2 27 21 20 00 02 21 28 20 02 21 30 40 00 ?? ?? ?? 0? 18 00 A2 AF 18 00 40 1A 21 88 40 00 3C 00 03 8E FB FF 02 24 24 10 62 00 3C 00 02 AE 00 00 03 8E EB FF 04 24 24 10 44 00 00 80 63 30 06 00 60 14 3C 00 02 AE 48 00 04 8E 04 00 82 8C FF FF 42 24 0B 00 40 10 04 00 82 AC 34 00 BF 8F 21 10 20 02 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? 3C 00 02 8E 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 ED FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F 3C 00 05 8E 00 00 02 8E EB FF 03 24 24 18 A3 00 00 80 42 30 21 88 80 00 06 00 40 14 3C 00 03 AE 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_329_0_0 {
	meta:
		name = "__fwprintf_chk"
		size = 516
		refs = "0078 __lll_lock_wait_private 00bc _IO_vfwprintf 01b0 _Unwind_Resume"
	strings:
		$1 = { 00 00 82 8C C8 FF BD 27 2C 00 B2 AF 00 80 42 30 28 00 B1 AF 24 00 B0 AF 34 00 BF AF 30 00 B3 AF 21 80 80 00 21 90 A0 00 44 00 A7 AF 1A 00 40 14 21 88 C0 00 3B E8 03 7C 48 00 84 8C 70 8B 73 24 08 00 82 8C 11 00 53 10 00 00 00 00 18 00 A0 AF 00 00 83 C0 06 00 60 14 00 00 02 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 02 24 0F 00 00 00 03 00 40 14 00 00 00 00 ?? ?? ?? 0? 18 00 A3 AF 48 00 02 8E 21 20 40 00 08 00 53 AC 04 00 82 8C 01 00 42 24 04 00 82 AC 05 00 40 1A 44 00 A2 27 3C 00 02 8E 04 00 42 34 3C 00 02 AE 44 00 A2 27 21 20 00 02 21 28 20 02 21 30 40 00 ?? ?? ?? 0? 18 00 A2 AF 18 00 40 1A 21 88 40 00 3C 00 03 8E FB FF 02 24 24 10 62 00 3C 00 02 AE 00 00 03 8E EB FF 04 24 24 10 44 00 00 80 63 30 06 00 60 14 3C 00 02 AE 48 00 04 8E 04 00 82 8C FF FF 42 24 0B 00 40 10 04 00 82 AC 34 00 BF 8F 21 10 20 02 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? 3C 00 02 8E 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 ED FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F 3C 00 05 8E 00 00 02 8E EB FF 03 24 24 18 A3 00 00 80 42 30 21 88 80 00 06 00 40 14 3C 00 03 AE 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "gethostid"
		size = 512
		refs = "0004 __gnu_local_gp 0010 $LC0 0058 __libc_errno 0068 __gethostname 0188 __gethostbyname_r 01ec memcpy"
	strings:
		$1 = { 58 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 A0 00 BE AF ?? ?? 04 3C 21 F0 A0 03 A4 00 BF AF 9C 00 B4 AF 98 00 B3 AF 94 00 B2 AF 90 00 B1 AF 8C 00 B0 AF 18 00 DC AF ?? ?? 84 24 00 20 05 24 21 30 00 00 A5 0F 02 24 0C 00 00 00 19 00 E0 10 21 80 40 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 50 AC 20 00 C4 27 ?? ?? ?? 0? 40 00 05 24 04 00 40 04 18 00 DC 8F 20 00 C2 83 2A 00 40 14 ?? ?? 94 8F 21 10 00 00 21 E8 C0 03 A4 00 BF 8F A0 00 BE 8F 9C 00 B4 8F 98 00 B3 8F 94 00 B2 8F 90 00 B1 8F 8C 00 B0 8F 08 00 E0 03 A8 00 BD 27 EC FF 40 04 21 20 40 00 80 00 C5 27 04 00 06 24 A3 0F 02 24 0C 00 00 00 07 00 E0 10 21 28 40 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 45 AC FF FF 05 24 21 20 00 02 A6 0F 02 24 0C 00 00 00 04 00 02 24 DA FF A2 14 A4 00 DF 8F 21 E8 C0 03 80 00 C2 8F 9C 00 B4 8F A0 00 BE 8F 98 00 B3 8F 94 00 B2 8F 90 00 B1 8F 8C 00 B0 8F 08 00 E0 03 A8 00 BD 27 F8 FB BD 27 3B E8 03 7C 18 00 B1 27 00 04 10 24 FF FF 12 24 21 A0 83 02 ?? ?? ?? 0? 22 00 13 24 00 00 82 8E CE FF 53 14 21 10 00 00 23 E8 A4 03 18 00 A2 27 21 20 43 00 26 88 24 02 0B 80 71 00 21 88 40 00 84 00 C2 27 10 00 A2 AF 78 00 C2 27 21 38 00 02 20 00 C4 27 14 00 A2 AF 21 30 20 02 ?? ?? ?? 0? 64 00 C5 27 40 18 10 00 F0 FF 04 24 0F 00 63 24 24 18 64 00 08 00 64 24 04 00 40 14 21 80 70 00 84 00 C2 8F 06 00 40 14 00 00 00 00 78 00 C2 8F E2 FF 52 10 21 10 00 00 ?? ?? ?? 0? 21 E8 C0 03 10 00 43 8C 0C 00 42 8C 7C 00 C4 27 00 00 65 8C 05 00 46 28 04 00 03 24 0B 18 46 00 21 30 60 00 ?? ?? ?? 0? 7C 00 C0 AF 7C 00 C2 8F ?? ?? ?? 0? 02 14 22 00 }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "__atomic_writev_replacement"
		size = 524
		refs = "0004 __gnu_local_gp 00f8 mempcpy 0114 __write 0120 free 0168 __libc_errno 01b8 __libc_alloca_cutoff 01c8 malloc 01ec _Unwind_Resume"
	strings:
		$1 = { B8 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 40 00 BE AF 21 F0 A0 03 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 44 00 BF AF 3C 00 B7 AF 38 00 B6 AF 34 00 B5 AF 24 00 B1 AF 20 00 B0 AF 10 00 DC AF 21 98 C0 00 21 A0 80 00 5A 00 C0 18 21 90 A0 00 04 00 A2 8C 00 80 03 3C 2B 18 43 00 41 00 60 10 21 38 A0 00 FF 7F 05 3C 21 18 00 00 21 80 00 00 ?? ?? ?? 0? FF FF A5 34 08 00 E7 24 04 00 E2 8C 23 20 B0 00 2B 20 82 00 36 00 80 14 00 00 00 00 01 00 63 24 F8 FF 73 14 21 80 02 02 01 80 02 34 2B 10 02 02 45 00 40 10 00 00 00 00 0E 00 02 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 10 00 B5 27 13 00 60 1A 18 00 C0 AF 21 10 A0 02 21 88 00 02 ?? ?? ?? 0? 21 B0 00 00 0D 00 D3 12 08 00 52 26 04 00 43 8E 00 00 45 8E 21 20 40 00 2B B8 23 02 0B 18 37 02 21 B8 60 00 21 30 60 00 ?? ?? ?? 0? 23 88 37 02 F4 FF 20 16 01 00 D6 26 FF FF D6 26 21 20 80 02 21 28 A0 02 ?? ?? ?? 0? 21 30 00 02 18 00 C4 8F ?? ?? ?? 0? 1C 00 C2 AF 21 E8 C0 03 44 00 BF 8F 1C 00 C2 8F 3C 00 B7 8F 40 00 BE 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC 21 E8 C0 03 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F FF FF 02 24 08 00 E0 03 48 00 BD 27 ?? ?? ?? 0? 21 80 00 00 ?? ?? ?? 0? 21 20 00 02 BA FF 40 14 0E 00 02 26 ?? ?? ?? 0? 21 20 00 02 08 00 40 10 21 A8 40 00 ?? ?? ?? 0? 18 00 C2 AF 21 80 80 00 ?? ?? ?? 0? 18 00 C4 8F ?? ?? ?? 0? 21 20 00 02 18 00 C0 AF ?? ?? ?? 0? FF FF 02 24 18 00 C0 AF ?? ?? ?? 0? 21 80 80 00 }
	condition:
		$1
}

rule file_174_1_0 {
	meta:
		name = "__libc_writev"
		size = 292
		refs = "0000 __gnu_local_gp 0054 __libc_errno 0098 __libc_enable_asynccancel 00e0 __libc_disable_asynccancel"
	strings:
		$1 = { ?? ?? 1C 3C D0 FF BD 27 ?? ?? 9C 27 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 2C 00 BF AF 10 00 BC AF 21 90 80 00 21 88 A0 00 21 80 C0 00 3B E8 03 7C 70 8B 62 8C 18 00 40 14 00 00 00 00 32 10 02 24 0C 00 00 00 2A 00 E0 10 21 28 40 00 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC FF FF 02 24 16 00 03 24 23 00 A3 14 2C 00 BF 8F 09 00 03 2A 20 00 60 14 21 20 40 02 21 28 20 02 28 00 B2 8F 24 00 B1 8F 21 30 00 02 20 00 B0 8F ?? ?? ?? 0? 30 00 BD 27 ?? ?? ?? 0? 00 00 00 00 21 F8 40 00 10 00 BC 8F 21 20 40 02 21 28 20 02 21 30 00 02 32 10 02 24 0C 00 00 00 08 00 E0 10 21 20 E0 03 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC FF FF 02 24 21 20 E0 03 ?? ?? ?? 0? 18 00 A2 AF 10 00 BC 8F 18 00 A2 8F 06 00 40 04 2C 00 BF 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 ?? ?? ?? 0? 00 00 85 8C }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "fexecve"
		size = 244
		refs = "0000 __gnu_local_gp 003c __libc_errno 0048 __snprintf 0034 $LC0 0058 __execve 0064 $LC1 0078 __xstat"
	strings:
		$1 = { ?? ?? 1C 3C 28 FF BD 27 ?? ?? 9C 27 D4 00 BF AF D0 00 B2 AF CC 00 B1 AF C8 00 B0 AF 28 00 80 04 10 00 BC AF 26 00 A0 10 21 80 A0 00 24 00 C0 10 21 88 C0 00 ?? ?? 06 3C 21 38 80 00 ?? ?? 92 8F A8 00 A4 27 1B 00 05 24 ?? ?? ?? 0? ?? ?? C6 24 21 28 00 02 21 30 20 02 ?? ?? ?? 0? A8 00 A4 27 3B E8 03 7C ?? ?? 05 3C 21 88 43 02 03 00 04 24 ?? ?? A5 24 18 00 A6 27 ?? ?? ?? 0? 00 00 30 8E 0B 00 40 14 59 00 02 24 D4 00 BF 8F 3B E8 03 7C 21 90 43 02 00 00 50 AE CC 00 B1 8F D0 00 B2 8F C8 00 B0 8F FF FF 02 24 08 00 E0 03 D8 00 BD 27 00 00 23 8E 02 00 63 38 ?? ?? ?? 0? 0A 80 43 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D4 00 BF 8F D0 00 B2 8F 21 10 62 00 16 00 03 24 00 00 43 AC CC 00 B1 8F C8 00 B0 8F FF FF 02 24 08 00 E0 03 D8 00 BD 27 }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "__getdtablesize"
		size = 52
		refs = "000c __getrlimit"
	strings:
		$1 = { D8 FF BD 27 18 00 A5 27 24 00 BF AF ?? ?? ?? 0? 05 00 04 24 18 00 A4 8F 24 00 BF 8F 00 00 42 28 00 01 03 24 0A 18 82 00 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "__frexp"
		size = 168
		refs = "0050 $LC0 0054 __muldf3"
	strings:
		$1 = { E0 FF BD 27 00 F0 A7 7C 18 00 B0 AF 21 80 C0 00 F0 7F 06 3C 2A 30 E6 00 1C 00 BF AF 21 10 80 00 00 00 00 AE 21 48 80 00 19 00 C0 10 21 40 A0 00 25 30 E4 00 16 00 C0 10 21 50 A0 00 10 00 06 3C 2A 30 E6 00 08 00 C0 10 21 18 00 00 ?? ?? 02 3C ?? ?? 47 8C ?? ?? ?? 0? ?? ?? 46 8C 21 50 60 00 00 F0 67 7C CA FF 03 24 03 3D 07 00 0F 80 08 3C 02 FC E7 24 FF FF 08 35 24 40 48 01 21 18 E3 00 E0 3F 04 3C 25 40 04 01 00 00 03 AE 21 48 40 00 1C 00 BF 8F 18 00 B0 8F 21 10 20 01 21 18 00 01 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "getgrent"
		size = 284
		refs = "0004 __gnu_local_gp 0054 __getgrent_r 0074 __nss_getent 0088 __libc_errno 00e8 __lll_lock_wait_private"
	strings:
		$1 = { C8 FF BD 27 ?? ?? 1C 3C 24 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 28 00 40 14 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C 10 00 A2 AF 14 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? 00 04 07 24 18 00 BC 8F 3B E8 03 7C 21 90 40 00 ?? ?? 91 8F 21 20 23 02 00 00 93 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 10 00 40 10 ?? ?? 04 26 34 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 33 AE 21 10 40 02 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? ?? ?? 02 3C 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F }
	condition:
		$1
}

rule file_275_0_0 {
	meta:
		name = "getaliasent"
		size = 284
		refs = "0004 __gnu_local_gp 0054 __getaliasent_r 0074 __nss_getent 0088 __libc_errno 00e8 __lll_lock_wait_private"
	strings:
		$1 = { C8 FF BD 27 ?? ?? 1C 3C 24 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 28 00 40 14 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C 10 00 A2 AF 14 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? 00 04 07 24 18 00 BC 8F 3B E8 03 7C 21 90 40 00 ?? ?? 91 8F 21 20 23 02 00 00 93 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 10 00 40 10 ?? ?? 04 26 34 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 33 AE 21 10 40 02 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? ?? ?? 02 3C 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F }
	condition:
		$1
}

rule file_286_0_0 {
	meta:
		name = "getprotoent"
		size = 284
		refs = "0004 __gnu_local_gp 0054 __getprotoent_r 0074 __nss_getent 0088 __libc_errno 00e8 __lll_lock_wait_private"
	strings:
		$1 = { C8 FF BD 27 ?? ?? 1C 3C 24 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 28 00 40 14 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C 10 00 A2 AF 14 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? 00 04 07 24 18 00 BC 8F 3B E8 03 7C 21 90 40 00 ?? ?? 91 8F 21 20 23 02 00 00 93 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 10 00 40 10 ?? ?? 04 26 34 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 33 AE 21 10 40 02 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? ?? ?? 02 3C 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F }
	condition:
		$1
}

rule file_598_0_0 {
	meta:
		name = "getpwent"
		size = 284
		refs = "0004 __gnu_local_gp 0054 __getpwent_r 0074 __nss_getent 0088 __libc_errno 00e8 __lll_lock_wait_private"
	strings:
		$1 = { C8 FF BD 27 ?? ?? 1C 3C 24 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 28 00 40 14 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C 10 00 A2 AF 14 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? 00 04 07 24 18 00 BC 8F 3B E8 03 7C 21 90 40 00 ?? ?? 91 8F 21 20 23 02 00 00 93 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 10 00 40 10 ?? ?? 04 26 34 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 33 AE 21 10 40 02 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? ?? ?? 02 3C 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F }
	condition:
		$1
}

rule file_702_0_0 {
	meta:
		name = "getrpcent"
		size = 284
		refs = "0004 __gnu_local_gp 0054 __getrpcent_r 0074 __nss_getent 0088 __libc_errno 00e8 __lll_lock_wait_private"
	strings:
		$1 = { C8 FF BD 27 ?? ?? 1C 3C 24 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 28 00 40 14 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C 10 00 A2 AF 14 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? 00 04 07 24 18 00 BC 8F 3B E8 03 7C 21 90 40 00 ?? ?? 91 8F 21 20 23 02 00 00 93 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 10 00 40 10 ?? ?? 04 26 34 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 33 AE 21 10 40 02 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? ?? ?? 02 3C 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F }
	condition:
		$1
}

rule file_1026_0_0 {
	meta:
		name = "getservent"
		size = 284
		refs = "0004 __gnu_local_gp 0054 __getservent_r 0074 __nss_getent 0088 __libc_errno 00e8 __lll_lock_wait_private"
	strings:
		$1 = { C8 FF BD 27 ?? ?? 1C 3C 24 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 28 00 40 14 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C 10 00 A2 AF 14 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? 00 04 07 24 18 00 BC 8F 3B E8 03 7C 21 90 40 00 ?? ?? 91 8F 21 20 23 02 00 00 93 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 10 00 40 10 ?? ?? 04 26 34 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 33 AE 21 10 40 02 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? ?? ?? 02 3C 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F }
	condition:
		$1
}

rule file_1280_0_0 {
	meta:
		name = "getsgent"
		size = 284
		refs = "0004 __gnu_local_gp 0054 __getsgent_r 0074 __nss_getent 0088 __libc_errno 00e8 __lll_lock_wait_private"
	strings:
		$1 = { C8 FF BD 27 ?? ?? 1C 3C 24 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 28 00 40 14 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C 10 00 A2 AF 14 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? 00 04 07 24 18 00 BC 8F 3B E8 03 7C 21 90 40 00 ?? ?? 91 8F 21 20 23 02 00 00 93 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 10 00 40 10 ?? ?? 04 26 34 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 33 AE 21 10 40 02 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? ?? ?? 02 3C 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F }
	condition:
		$1
}

rule file_533_0_0 {
	meta:
		name = "getspent"
		size = 284
		refs = "0004 __gnu_local_gp 0054 __getspent_r 0074 __nss_getent 0088 __libc_errno 00e8 __lll_lock_wait_private"
	strings:
		$1 = { C8 FF BD 27 ?? ?? 1C 3C 24 00 B0 AF ?? ?? 10 3C ?? ?? 9C 27 ?? ?? 03 26 34 00 BF AF 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 28 00 40 14 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 06 3C 10 00 A2 AF 14 00 A0 AF ?? ?? 84 24 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? 00 04 07 24 18 00 BC 8F 3B E8 03 7C 21 90 40 00 ?? ?? 91 8F 21 20 23 02 00 00 93 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 10 00 40 10 ?? ?? 04 26 34 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 33 AE 21 10 40 02 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? ?? ?? 02 3C 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "shmat"
		size = 144
		refs = "0004 __gnu_local_gp 006c __libc_errno"
	strings:
		$1 = { E8 FF BD 27 ?? ?? 1C 3C 21 18 80 00 14 00 BE AF ?? ?? 9C 27 21 F0 A0 03 F0 FF BD 27 21 10 A0 00 00 00 DC AF 08 00 DD AF 15 00 04 24 21 28 60 00 0C 00 C7 27 E0 FF BD 27 10 00 A2 AF 15 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 14 00 00 00 00 21 E8 C0 03 0C 00 C2 8F 14 00 BE 8F 08 00 E0 03 18 00 BD 27 3B E8 03 7C 21 28 60 00 ?? ?? 83 8F 21 20 40 00 FF FF 02 24 21 28 65 00 00 00 A4 AC 21 E8 C0 03 14 00 BE 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "__posix_spawn_file_actions_realloc"
		size = 104
		refs = "0028 realloc"
	strings:
		$1 = { D8 FF BD 27 20 00 B1 AF 00 00 91 8C 1C 00 B0 AF 21 80 80 00 08 00 31 26 08 00 84 8C 00 11 11 00 80 28 11 00 24 00 BF AF ?? ?? ?? 0? 21 28 A2 00 08 00 40 10 24 00 BF 8F 08 00 02 AE 00 00 11 AE 21 10 00 00 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 20 00 B1 8F 1C 00 B0 8F 0C 00 02 24 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_180_1_0 {
	meta:
		name = "posix_spawn_file_actions_init"
		size = 36
		refs = "000c memset"
	strings:
		$1 = { E0 FF BD 27 21 28 00 00 1C 00 BF AF ?? ?? ?? 0? 4C 00 06 24 1C 00 BF 8F 21 10 00 00 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "_IO_getwc"
		size = 448
		refs = "0064 __lll_lock_wait_private 0138 __wuflow 016c _Unwind_Resume"
	strings:
		$1 = { 00 00 82 8C D0 FF BD 27 24 00 B0 AF 00 80 42 30 2C 00 BF AF 28 00 B1 AF 1A 00 40 14 21 80 80 00 3B E8 03 7C 48 00 84 8C 70 8B 71 24 08 00 82 8C 11 00 51 10 00 00 00 00 18 00 A0 AF 00 00 83 C0 06 00 60 14 00 00 02 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 02 24 0F 00 00 00 03 00 40 14 00 00 00 00 ?? ?? ?? 0? 18 00 A3 AF 48 00 02 8E 21 20 40 00 08 00 51 AC 04 00 82 8C 01 00 42 24 04 00 82 AC 5C 00 03 8E 2B 00 60 10 00 00 00 00 00 00 64 8C 04 00 62 8C 2B 10 82 00 26 00 40 10 00 00 00 00 00 00 91 8C 04 00 84 24 00 00 64 AC 00 00 02 8E 00 80 42 30 07 00 40 14 2C 00 BF 8F 48 00 04 8E 04 00 82 8C FF FF 42 24 07 00 40 10 04 00 82 AC 2C 00 BF 8F 21 10 20 02 24 00 B0 8F 28 00 B1 8F 08 00 E0 03 30 00 BD 27 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 F1 FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 2C 00 BF 8F ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 88 40 00 00 00 02 8E 00 80 42 30 06 00 40 14 21 88 80 00 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "str_to_mpn.isra.0"
		size = 1044
		refs = "017c _tens_in_limb 01dc __mpn_mul_1 03b4 $LC2 03b8 $LC1 03cc __assert_fail 03bc __PRETTY_FUNCTION__.9581 03f4 $LC0"
	strings:
		$1 = { C0 FF BD 27 38 00 BE AF 2C 00 B5 AF 24 00 B3 AF 20 00 B2 AF 3C 00 BF AF 34 00 B7 AF 30 00 B6 AF 28 00 B4 AF 1C 00 B1 AF 18 00 B0 AF 21 F0 E0 00 21 90 A0 00 54 00 B3 8F 58 00 B5 8F ED 00 A0 18 00 00 E0 AC 9A 3B 14 3C 21 B8 C0 00 21 80 80 00 21 30 00 00 21 88 00 00 21 48 00 00 09 00 16 24 00 CA 94 36 00 00 02 82 D0 FF 44 24 FF 00 84 30 0A 00 84 2C 08 00 80 14 21 18 40 00 04 00 A0 12 00 00 00 00 00 00 A3 82 17 00 62 10 00 00 00 00 21 80 13 02 00 00 03 82 40 10 11 00 C0 88 11 00 21 88 51 00 D0 FF 31 26 FF FF 52 26 01 00 10 26 21 88 23 02 27 00 40 12 01 00 22 25 E9 FF 56 14 21 48 40 00 43 00 C0 14 01 00 02 24 00 00 F1 AE 00 00 C2 AF 21 10 00 00 01 00 06 24 21 88 00 00 ?? ?? ?? 0? 21 48 40 00 01 00 A2 82 AE 00 40 10 01 00 04 24 01 00 03 82 E5 FF 62 14 01 00 03 24 ?? ?? ?? 0? 01 00 63 24 21 40 03 02 00 00 08 81 DF FF 02 15 01 00 63 24 21 10 A3 02 00 00 42 80 F9 FF 40 14 21 20 60 00 21 80 04 02 00 00 03 82 40 10 11 00 C0 88 11 00 21 88 51 00 D0 FF 31 26 FF FF 52 26 01 00 10 26 21 88 23 02 DB FF 40 16 01 00 22 25 50 00 A4 8F 04 00 83 8C 7B 00 60 18 00 00 84 8C 08 00 05 24 23 48 A9 00 C3 2F 09 00 2A 38 A3 00 43 00 E0 10 00 00 00 00 ?? ?? 03 3C 80 10 02 00 ?? ?? 63 24 21 10 43 00 4E 00 C0 14 00 00 47 8C 01 00 02 24 00 00 F1 AE 00 00 C2 AF 3C 00 BF 8F 21 10 00 02 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 21 20 E0 02 21 28 E0 02 ?? ?? ?? 0? 21 38 80 02 00 00 E3 8E 00 00 C4 8F 21 88 23 02 2B 18 23 02 1B 00 60 10 00 00 F1 AE ?? ?? ?? 0? 04 00 E3 26 FC FF 65 8C 01 00 A5 24 15 00 A0 14 FC FF 65 AC FF FF 84 24 FA FF 80 14 04 00 63 24 01 00 03 24 21 10 62 00 12 00 40 10 00 00 00 00 00 00 C3 8F 73 00 64 28 66 00 80 10 80 18 03 00 21 18 E3 02 00 00 62 AC 00 00 C6 8F 21 10 00 00 21 88 00 00 01 00 C6 24 00 00 C6 AF ?? ?? ?? 0? 21 48 40 00 21 18 00 00 21 10 62 00 F0 FF 40 14 00 00 00 00 00 00 C6 8F 21 88 00 00 ?? ?? ?? 0? 21 48 40 00 43 00 65 10 ?? ?? 03 3C ?? ?? 63 24 80 28 04 00 21 28 A3 00 21 10 82 00 80 10 02 00 50 00 A4 8F 00 00 A5 8C 21 18 43 00 00 00 67 8C 21 10 00 00 21 18 00 00 02 88 25 72 00 00 82 AC B4 FF C0 10 04 00 83 AC 21 20 E0 02 ?? ?? ?? 0? 21 28 E0 02 00 00 E3 8E 00 00 C4 8F 21 88 23 02 2B 18 23 02 1F 00 60 14 00 00 F1 AE 21 18 00 00 21 10 62 00 AB FF 40 10 3C 00 BF 8F 00 00 C3 8F 73 00 64 28 2B 00 80 10 80 20 03 00 21 B8 E4 02 01 00 63 24 00 00 C3 AF 30 00 B6 8F 00 00 E2 AE 38 00 BE 8F 21 10 00 02 34 00 B7 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 8B FF 60 14 00 00 00 00 83 FF 80 14 00 00 00 00 ?? ?? ?? 0? ?? ?? 03 3C ?? ?? ?? 0? 04 00 E3 26 FC FF 65 8C 01 00 A5 24 DD FF A0 14 FC FF 65 AC FF FF 84 24 FA FF 80 14 04 00 63 24 FC FF 63 24 ?? ?? ?? 0? 01 00 03 24 2B 48 24 01 78 FF 20 15 ?? ?? 63 24 ?? ?? ?? 0? 00 00 00 00 21 80 04 02 ?? ?? ?? 0? 00 00 03 82 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 B3 01 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 7B 01 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 6A 01 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_182_1_0 {
	meta:
		name = "round_and_return"
		size = 1356
		refs = "0000 __gnu_local_gp 0068 __libc_errno 0080 $LC5 008c $LC6 0094 __muldf3 00f4 $LC3 0100 $LC4 018c __mpn_rshift 023c __mpn_construct_double"
	strings:
		$1 = { ?? ?? 1C 3C C0 FF BD 27 ?? ?? 9C 27 FF FF E3 28 21 10 E0 00 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 3C 00 BF AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 10 00 BC AF 21 80 80 00 54 00 B2 8F 58 00 B3 8F 21 00 60 14 5C 00 B1 8F FF FF 04 24 1C 00 E4 10 02 FC C4 2C 61 00 40 18 00 00 00 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 50 00 A4 8F 21 10 62 00 22 00 03 24 00 00 43 AC 49 00 80 10 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? ?? 0? ?? ?? 47 8C 3C 00 BF 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 40 00 BD 27 E4 FF 80 10 00 00 00 00 1A 00 60 10 FF FF 03 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 22 00 03 24 00 00 43 AC 50 00 A2 8F 62 00 40 10 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? ?? 0? ?? ?? 47 8C 3C 00 BF 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 40 00 BD 27 4C 00 43 10 CD FB C2 2C 01 00 03 24 04 20 63 02 FF FF 84 24 24 20 92 00 2B 20 04 00 02 FC 02 24 25 88 24 02 23 10 46 00 35 00 04 24 54 00 44 10 20 00 44 28 92 00 80 10 00 00 00 00 BE 00 43 10 21 20 00 02 21 28 00 02 02 00 06 24 21 38 40 00 00 00 12 8E ?? ?? ?? 0? FF FF 53 24 00 00 14 8E 10 00 BC 8F ?? ?? ?? 0? 01 00 96 32 ?? ?? 44 8C ?? ?? 45 8C 21 30 80 00 ?? ?? ?? 0? 21 38 A0 00 3C 00 BF 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 40 00 BD 27 04 00 40 14 00 00 00 00 01 04 C3 2C 9C FF 60 10 00 00 00 00 00 00 14 8E 06 A8 72 02 01 00 B5 32 01 00 96 32 05 00 20 16 01 00 03 24 04 18 63 02 FF FF 63 24 24 90 72 00 2B 18 12 00 06 00 A0 12 21 28 C0 00 3F 00 C0 16 00 00 00 00 3E 00 60 14 01 00 83 26 21 28 C0 00 50 00 A6 8F ?? ?? ?? 0? 21 20 00 02 3C 00 BF 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 40 00 BD 27 B5 FF 40 10 01 00 03 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? 44 8C ?? ?? 45 8C 21 30 80 00 ?? ?? ?? 0? 21 38 A0 00 3C 00 BF 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 40 00 BD 27 04 00 12 8E 00 00 02 8E 04 00 00 AE 2B 18 12 00 2B 10 02 00 25 10 62 00 25 88 22 02 00 00 00 AE 21 B0 00 00 21 A0 00 00 14 00 13 24 06 A8 72 02 01 00 B5 32 20 00 A0 16 ?? ?? 02 3C 1E 00 20 16 00 00 00 00 01 00 02 24 04 10 62 02 FF FF 42 24 24 10 52 00 17 00 40 14 00 00 00 00 21 A8 20 02 01 FC 06 24 ?? ?? ?? 0? FF FF 02 24 01 00 83 26 2B A0 74 00 00 00 03 AE 03 00 80 12 04 00 03 8E 01 00 63 24 04 00 03 AE 40 05 64 7C 36 00 80 14 01 FC 04 24 BA FF C4 14 21 28 C0 00 FF FF 04 24 B7 FF 44 14 00 05 63 7C 02 FC 05 24 ?? ?? ?? 0? 0A 28 C3 00 ?? ?? 02 3C 3B E8 03 7C ?? ?? 44 8C ?? ?? 45 8C 21 10 60 00 ?? ?? 83 8F 21 30 80 00 21 38 A0 00 21 10 62 00 22 00 03 24 ?? ?? ?? 0? 00 00 43 AC 18 00 A2 AF 1C 00 A3 AF 18 00 A2 8F 1C 00 A3 8F 01 FC 06 24 ?? ?? ?? 0? FF FF 02 24 FF FF 53 24 43 21 13 00 80 28 04 00 21 28 05 02 00 00 B2 8C 04 00 83 14 1F 00 73 32 00 00 03 8E 2B 18 03 00 25 88 23 02 01 00 03 24 04 18 63 02 FF FF 63 24 24 18 43 02 2B 18 03 00 21 20 00 02 04 00 05 26 01 00 06 24 1F 00 47 30 ?? ?? ?? 0? 25 88 23 02 00 00 14 8E 10 00 BC 8F 04 00 00 AE ?? ?? ?? 0? 01 00 96 32 01 00 D1 24 2B 90 26 02 21 20 00 02 21 28 00 02 02 00 06 24 01 00 07 24 ?? ?? ?? 0? 21 90 42 02 04 00 03 8E 10 00 02 3C 10 00 BC 8F 25 10 62 00 04 00 02 AE 01 04 02 24 77 FF 22 16 21 28 20 02 FF FE 40 12 50 00 A6 8F ?? ?? ?? 0? 00 00 00 00 06 98 72 02 01 00 73 32 06 00 60 12 00 00 12 8E 01 00 55 32 0D 00 A0 16 01 00 43 26 0C 00 20 16 2B 20 72 00 21 20 00 02 21 28 00 02 02 00 06 24 ?? ?? ?? 0? 21 38 40 00 10 00 BC 8F 00 00 14 8E 21 98 00 00 ?? ?? ?? 0? 01 00 96 32 2B 20 72 00 19 00 80 14 18 00 A3 AF 04 00 04 26 02 00 06 24 1C 00 A3 27 05 00 64 10 02 00 05 24 04 00 C5 14 1C 00 B3 8F 00 00 84 8C 00 00 64 AC 1C 00 B3 8F 21 20 00 02 21 28 00 02 02 00 06 24 ?? ?? ?? 0? 21 38 40 00 40 05 62 7E E8 FF 40 10 10 00 BC 8F 00 00 14 8E 21 98 00 00 01 FC 06 24 01 00 96 32 ?? ?? ?? 0? FF FF 02 24 04 00 03 8E 21 98 00 00 01 00 63 24 EE FF 60 10 1C 00 A3 AF 08 00 04 26 01 00 06 24 ?? ?? ?? 0? 20 00 A3 27 }
	condition:
		$1
}

rule file_182_2_0 {
	meta:
		name = "____strtod_l_internal"
		size = 10380
		refs = "0000 __gnu_local_gp 0058 strlen 02b8 _nl_C_locobj 05dc _fpioconst_pow10 0604 __tens 0624 memcpy 0684 __mpn_mul 07d0 __correctly_grouped_prefixmb 0808 $LC8 02e0 $LC14 0b24 __strncasecmp_l 0b40 $LC7 0be4 __divdi3 0c30 __moddi3 0d6c $LC12 0d94 $LC13 0dc0 $LC9 0dd8 __mpn_lshift 1260 __mpn_cmp 1604 __mpn_submul_1 1620 __mpn_add_n 1d10 $LC25 1d14 $LC1 1d28 __assert_fail 1d18 __PRETTY_FUNCTION__.9631 1da0 __mpn_rshift 202c $LC10 2134 ____strtoull_l_internal 215c $LC16 2238 $LC21 22e4 __libc_errno 22fc $LC3 230c $LC4 2318 __muldf3 2374 $LC5 2384 $LC6 23d4 $LC20 23f4 $LC19 2414 $LC15 1448 $LC28 24a0 $LC11 24cc $LC26 24fc $LC27 162c $LC29 2564 $LC23 2584 $LC24 25ac $LC18 25cc $LC22 03d4 $LC17"
	strings:
		$1 = { ?? ?? 1C 3C B8 FB BD 27 ?? ?? 9C 27 04 00 E2 8C 40 04 BE AF 38 04 B6 AF 28 04 B2 AF 24 04 B1 AF 44 04 BF AF 3C 04 B7 AF 34 04 B5 AF 30 04 B4 AF 2C 04 B3 AF 20 04 B0 AF 20 00 BC AF 21 B0 E0 00 21 88 80 00 21 90 A0 00 21 F0 00 00 4B 08 C0 14 D8 03 A0 AF 24 00 53 8C ?? ?? ?? 0? 21 20 60 02 21 A0 40 00 0E 09 40 10 20 00 BC 8F 34 00 C3 8E 21 20 00 00 21 28 00 00 C8 03 A4 AF CC 03 A5 AF FF FF 37 26 01 00 F7 26 00 00 F0 82 40 10 10 00 21 10 62 00 00 00 42 94 00 20 42 30 FA FF 40 14 01 00 F7 26 FF FF F7 26 2D 00 02 24 AB 00 02 12 21 18 E0 02 2B 00 02 24 E3 01 02 12 E0 03 A0 AF 00 00 66 82 0E 00 C0 10 21 20 00 00 00 00 E2 82 74 00 46 14 21 10 00 00 ?? ?? ?? 0? 01 00 42 24 21 20 E2 02 00 00 84 80 6E 00 83 14 01 00 42 24 21 18 62 02 00 00 63 80 F9 FF 60 14 21 20 40 00 21 20 E4 02 00 00 82 90 D0 FF 42 24 FF 00 42 30 0A 00 42 2C 64 00 40 10 D0 FF 02 26 30 00 02 24 CC 01 02 12 D8 03 A8 8F 38 00 C5 8E 21 48 E0 02 01 00 0D 2D 22 08 A0 11 0A 00 0B 24 D0 FF 07 26 80 18 10 00 FF 00 E2 30 21 18 A3 00 0A 00 42 2C 15 00 40 14 00 00 6C 8C 10 00 02 24 FA 01 62 11 9F FF 82 25 0E 00 C0 10 10 00 02 24 00 00 E2 82 8C 01 46 14 21 10 00 00 ?? ?? ?? 0? 01 00 42 24 00 00 84 80 87 01 83 14 01 00 42 24 21 18 62 02 00 00 63 80 FA FF 60 14 21 20 E2 02 10 00 02 24 87 04 62 11 00 00 00 00 21 A8 E0 02 21 60 00 00 10 00 03 24 FF 00 E2 30 0A 00 42 2C 62 00 40 14 00 00 00 00 59 00 63 11 80 10 10 00 60 09 A0 11 D8 03 AA 8F 37 09 C0 17 2B 10 35 01 01 00 8D 2D 0D 00 C0 10 23 F0 0D 00 00 00 A2 82 60 00 46 14 21 10 00 00 ?? ?? ?? 0? 01 00 42 24 00 00 84 80 5B 00 83 14 01 00 42 24 21 18 62 02 00 00 63 80 FA FF 60 14 21 20 A2 02 21 30 B4 02 00 00 C2 80 21 A8 C0 00 23 20 86 01 D0 FF 43 24 FF 00 63 30 0A 00 63 2C 10 00 0E 24 30 00 07 24 14 00 60 14 21 48 A4 02 B4 02 6E 15 80 10 02 00 21 10 A2 00 00 00 42 8C 9F FF 43 24 FF 00 63 30 06 00 63 2C 41 02 60 10 20 14 02 7C 23 10 A6 02 27 18 1E 00 01 00 B5 26 0A F0 43 00 00 00 A2 82 D0 FF 43 24 FF 00 63 30 0A 00 63 2C EE FF 60 10 21 48 A4 02 F5 FF 47 14 00 00 00 00 01 00 B5 26 ?? ?? ?? 0? 00 00 A2 82 D0 FF 02 26 FF 00 42 30 0A 00 42 2C 9B FF 40 14 30 00 02 24 ?? ?? 14 3C ?? ?? 94 26 38 00 82 8E 80 80 10 00 69 00 03 24 21 10 50 00 00 00 42 80 A5 02 43 10 6E 00 03 24 0E 02 43 10 ?? ?? 05 3C 02 00 40 12 21 20 00 00 00 00 51 AE 21 28 00 00 44 04 BF 8F 40 04 BE 8F 3C 04 B7 8F 38 04 B6 8F 34 04 B5 8F 30 04 B4 8F 2C 04 B3 8F 28 04 B2 8F 24 04 B1 8F 20 04 B0 8F 21 10 80 00 21 18 A0 00 08 00 E0 03 48 04 BD 27 21 10 A2 00 00 00 42 8C 9F FF 42 24 FF 00 42 30 06 00 42 2C A2 FF 40 10 00 00 00 00 01 00 8C 25 01 00 B0 82 01 00 B5 26 ?? ?? ?? 0? D0 FF 07 26 01 00 08 24 01 00 F7 26 01 00 70 80 ?? ?? ?? 0? E0 03 A8 AF 80 80 10 00 21 28 B0 00 10 00 03 24 00 00 A2 80 F9 01 63 11 21 48 80 01 65 00 03 24 F9 01 43 10 21 28 A0 02 2B 10 89 01 0F 00 40 10 30 00 02 24 FF FF A3 80 09 00 62 14 21 10 A0 00 30 00 06 24 FF FF 42 24 FF FF 43 80 21 20 49 00 FC FF 66 10 23 20 85 00 21 48 80 00 21 28 40 00 2B 10 2C 01 D8 08 40 14 ?? ?? 04 3C 32 01 89 11 00 00 00 00 02 00 40 12 00 00 00 00 00 00 55 AE 03 01 20 11 E0 03 A8 8F 30 00 C0 13 10 00 02 24 00 00 65 82 00 00 E2 82 05 00 A2 10 01 00 66 82 01 00 E2 82 01 00 F7 26 FD FF A2 14 00 00 00 00 0F 00 C0 10 10 00 02 24 01 00 E2 82 F9 FF 46 14 00 00 00 00 ?? ?? ?? 0? 01 00 02 24 00 00 84 80 C7 01 83 14 00 00 00 00 01 00 42 24 21 18 62 02 00 00 63 80 F9 FF 60 14 21 20 E2 02 10 00 02 24 F9 05 62 11 CC 03 A3 8F C8 03 A2 8F 00 80 05 3C 21 20 40 00 21 28 65 00 4B 08 A0 10 2B 20 9E 00 10 00 04 24 30 06 64 11 82 2F 1E 00 21 20 C0 03 21 28 00 00 23 20 44 00 2B 10 44 00 23 18 65 00 21 30 D4 03 23 10 62 00 21 B8 E6 02 C8 03 A4 AF CC 03 A2 AF 23 48 3E 01 10 00 02 24 29 01 62 11 CC 03 A3 8F 1C 02 61 04 C8 03 A5 8F 23 20 0C 00 2B 10 04 00 23 10 02 00 2A 30 43 00 21 02 C0 14 00 00 00 00 F4 04 62 10 2B 30 85 00 35 01 07 24 21 B0 84 01 23 30 F6 00 23 20 A4 00 2B 28 A4 00 23 10 62 00 2B 38 E6 00 23 10 45 00 23 18 07 00 2A 28 62 00 C8 03 A4 AF 4D 08 A0 14 CC 03 A2 AF 48 08 43 10 FF FF 43 28 34 08 60 14 FF FF 03 24 2F 08 43 10 00 00 00 00 D8 02 C0 16 21 98 00 00 2B 10 C9 02 22 08 40 10 C8 03 B0 8F CC 03 A2 8F 43 01 03 26 2B 20 70 00 21 20 82 00 1C 08 80 14 44 01 63 2C 1A 08 60 10 00 00 00 00 C8 05 60 1A 00 00 00 00 FC 07 C0 12 25 10 02 02 FA 07 40 14 36 00 02 24 23 10 53 00 21 50 00 00 23 18 36 01 2B 20 23 01 E4 03 A3 AF 23 20 04 00 C3 1F 02 00 2A 28 83 00 27 02 A0 14 00 00 00 00 22 02 64 10 E4 03 A8 8F 21 10 C2 02 2B 20 56 00 21 18 83 00 18 02 60 04 00 00 00 00 13 02 60 10 00 00 00 00 FC 03 A0 AF E4 03 A8 8F F4 01 B2 27 28 00 B1 27 ?? ?? 09 3C 23 50 0A 01 ?? ?? 29 25 21 A8 40 02 21 B0 20 02 01 00 1E 24 ?? ?? ?? 0? 21 80 00 00 04 00 30 8D 02 00 A5 24 ?? ?? 02 3C ?? ?? 42 24 FE FF 10 26 80 28 05 00 21 20 C0 02 21 28 45 00 80 30 10 00 1C 04 A9 AF ?? ?? ?? 0? 04 04 AA AF 1C 04 A9 8F 04 04 AA 8F 40 F0 1E 00 21 00 40 11 10 00 29 25 24 10 5E 01 FB FF 40 10 00 00 00 00 26 50 5E 01 EA FF 00 12 00 00 25 8D 04 00 26 8D 02 00 A5 24 ?? ?? 03 3C ?? ?? 63 24 80 28 05 00 10 00 B0 AF 21 20 A0 02 21 28 65 00 FE FF C6 24 21 38 C0 02 1C 04 A9 AF ?? ?? ?? 0? 04 04 AA AF 1C 04 A9 8F 04 04 AA 8F 04 00 24 8D FE FF 84 24 A1 01 40 14 21 80 04 02 21 10 C0 02 FF FF 10 26 21 B0 A0 02 40 F0 1E 00 21 A8 40 00 E1 FF 40 15 10 00 29 25 55 06 D2 12 21 20 20 02 D8 03 AA 8F E4 03 A5 8F FF FF 08 26 C8 03 A2 27 80 18 08 00 14 00 B4 AF 10 00 A2 AF 18 00 AA AF 21 20 E0 02 21 30 40 02 D0 03 A7 27 DC 03 A8 AF ?? ?? ?? 0? 00 04 A3 AF 00 04 A8 8F 21 10 28 02 00 00 54 8C 20 A0 94 72 AF 01 80 1E 21 20 20 02 D0 03 A6 8F C3 1F 13 00 01 00 02 24 C8 03 B3 AF C8 01 02 12 CC 03 A3 AF 02 00 02 24 C0 02 02 16 00 04 AA 8F 02 00 C6 28 28 00 B5 8F E2 03 C0 10 2C 00 B2 8F F4 01 B0 8F 2B 10 12 02 E0 03 40 10 21 B0 00 00 3F 07 60 1A 16 00 62 2A 33 07 40 10 35 00 17 24 C0 03 A2 8F 21 B8 00 00 C0 03 A0 AF C4 03 A2 AF C0 03 B4 27 20 00 73 26 21 B0 00 02 36 00 62 2A D4 03 40 14 21 80 00 00 C8 03 A2 8F CC 03 A3 8F ?? ?? ?? 0? 21 88 00 00 10 00 02 24 2E 05 62 11 20 64 0C 7C 65 00 02 24 7D FE 82 11 21 A8 E0 02 D8 03 A6 8F 21 20 20 01 21 28 E0 02 21 38 C0 03 1C 04 A9 AF ?? ?? ?? 0? 14 04 AB AF 1C 04 A9 8F 06 00 40 12 14 04 AB 8F 03 00 22 15 10 00 6B 39 FF FF E2 26 0B 10 2B 02 00 00 42 AE E0 03 A8 8F BC FE 00 11 21 20 00 00 ?? ?? 02 3C ?? ?? 45 8C 44 04 BF 8F ?? ?? 44 8C 40 04 BE 8F 3C 04 B7 8F 38 04 B6 8F 34 04 B5 8F 30 04 B4 8F 2C 04 B3 8F 28 04 B2 8F 24 04 B1 8F 20 04 B0 8F 21 10 80 00 21 18 A0 00 08 00 E0 03 48 04 BD 27 01 00 F0 82 ?? ?? ?? 0? 01 00 F7 26 01 00 E3 82 38 00 C5 8E 80 18 03 00 21 18 A3 00 00 00 64 8C 78 00 03 24 FD 01 83 10 21 48 E0 02 01 00 0D 2D 50 06 A0 11 0A 00 0B 24 21 B8 20 01 30 00 02 24 01 00 F7 26 00 00 F0 82 FE FF 02 12 01 00 F7 26 FF FF F7 26 ?? ?? ?? 0? D0 FF 07 26 CE FE 80 11 CC 03 A3 8F EB 01 61 04 01 00 02 24 04 00 04 24 10 00 67 39 FF FF A5 24 10 00 06 24 0B 20 47 00 21 48 80 01 30 00 0E 24 16 00 66 11 00 00 A2 80 D0 FF 42 24 0A 00 42 2C 01 00 42 38 0E 00 40 14 00 00 00 00 00 00 A2 80 BB FE 4E 14 C8 03 A2 8F FF FF 29 25 FF FF 8C 25 21 10 82 00 2B 38 44 00 21 18 E3 00 C8 03 A2 AF B3 FE 20 11 CC 03 A3 AF B1 FE 61 04 00 00 00 00 FF FF A5 24 EC FF 66 15 00 00 A2 80 34 00 C7 8E 40 10 02 00 21 10 E2 00 00 00 42 94 00 10 42 38 ?? ?? ?? 0? 00 03 42 7C FF 00 42 30 06 00 42 2C 04 FE 40 10 21 A8 E0 02 ?? ?? ?? 0? 21 60 00 00 00 00 E2 82 ?? ?? ?? 0? 34 00 C8 8E 00 00 E2 82 40 18 02 00 21 18 03 01 00 00 63 94 00 10 63 30 FA FF 60 10 01 00 F7 26 30 00 03 24 06 00 43 14 FF FF F7 26 01 00 F7 26 00 00 E2 82 FE FF 43 10 01 00 F7 26 FF FF F7 26 D0 FF 43 24 0A 00 64 2C 80 02 80 14 00 00 00 00 38 00 C3 8E 80 10 02 00 01 00 F7 26 21 10 62 00 00 00 42 8C A9 FF 42 24 ?? ?? 03 3C 80 20 02 00 ?? ?? 63 24 21 18 83 00 00 00 63 8C 83 06 60 10 15 00 04 24 23 20 83 00 CC 03 A5 8F 04 10 82 00 C4 03 A2 AF 14 00 02 24 23 10 43 00 45 04 A1 04 C8 03 A7 8F 27 58 03 00 FF 7F 0D 3C 01 00 64 25 C3 37 03 00 FF FF AD 35 2B 58 8B 00 23 30 A6 01 21 30 66 01 80 5F 06 00 82 20 04 00 25 20 64 01 83 30 06 00 63 06 C0 10 2B 20 8C 00 FF FF 86 25 2B 20 CC 00 FF FF 84 24 FF FF 63 24 82 67 06 00 80 20 04 00 80 30 06 00 21 30 66 00 C3 5F 03 00 25 20 84 01 2B 18 C3 00 21 20 64 01 21 30 E6 00 21 18 64 00 21 28 A3 00 2B 38 C7 00 21 38 E5 00 C8 03 A6 AF CC 03 A7 AF 01 00 05 24 03 00 0D 24 FF FF 23 25 12 04 60 10 00 00 00 00 00 00 E4 82 40 58 04 00 21 58 0B 01 00 00 6B 95 00 10 6B 31 04 00 60 15 21 60 80 00 21 B8 F4 02 00 00 EC 82 21 20 80 01 D0 FF 8B 24 0A 00 6B 2D 9A 03 60 11 80 20 04 00 01 00 F7 26 D0 FF 84 25 03 00 4B 28 86 03 60 15 28 00 AA 27 80 48 05 00 21 48 49 01 98 03 2B 8D FD FF 4C 24 04 20 84 01 25 20 8B 00 98 03 24 AD FC FF 42 24 ?? ?? ?? 0? 21 48 60 00 21 20 E0 02 ?? ?? A5 24 03 00 06 24 ?? ?? ?? 0? 21 38 80 02 ED FD 40 14 28 00 02 24 03 00 E3 82 63 05 62 10 03 00 E6 26 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C EA FD 40 12 44 04 BF 8F ?? ?? ?? 0? 00 00 46 AE 21 10 C0 00 ?? ?? ?? 0? 01 00 F7 26 70 00 03 24 09 FE 43 14 21 28 A0 02 01 00 AF 82 2D 00 02 24 6C 04 E2 11 2B 00 02 24 9E 04 E2 11 02 00 AE 26 01 00 AE 26 DC 03 A0 AF D0 FF EF 25 FF 00 E2 31 0A 00 42 2C FC FD 40 10 21 28 A0 02 10 00 02 24 BC 04 62 11 DC 03 A8 8F 14 02 00 11 68 01 82 25 21 80 40 00 2B 88 4C 00 21 20 00 02 21 28 20 02 0A 00 06 24 21 38 00 00 1C 04 A9 AF 14 04 AB AF 10 04 AC AF 18 04 AE AF ?? ?? ?? 0? 0C 04 AF AF 1C 04 A9 8F 14 04 AB 8F 10 04 AC 8F 18 04 AE 8F 0C 04 AF 8F 21 C8 40 00 21 C0 60 00 21 20 00 02 21 28 20 02 21 38 00 00 0A 00 06 24 1C 04 A9 AF 14 04 AB AF 10 04 AC AF 18 04 AE AF 0C 04 AF AF 08 04 B8 AF ?? ?? ?? 0? 04 04 B9 AF 21 80 40 00 20 00 BC 8F C8 03 A4 8F CC 03 A5 8F 21 38 60 00 04 04 B9 8F 08 04 B8 8F 0C 04 AF 8F 18 04 AE 8F 10 04 AC 8F 14 04 AB 8F ?? ?? ?? 0? 1C 04 A9 8F 21 20 20 02 2A 10 05 03 96 05 40 14 00 00 00 00 1B 06 B8 10 2B 10 24 03 88 05 24 13 C3 37 0F 00 C2 1F 04 00 40 10 05 00 25 10 62 00 40 28 04 00 82 8F 05 00 80 18 02 00 C0 20 04 00 21 20 A4 00 25 18 23 02 2B 28 85 00 21 10 43 00 21 88 8F 00 21 10 A2 00 21 30 46 00 2B 20 24 02 21 28 86 00 C8 03 B1 AF CC 03 A5 AF 01 00 CE 25 00 00 CF 81 D0 FF EF 25 FF 00 E2 31 0A 00 42 2C E0 FF 40 14 DC 03 AA 8F 68 04 40 11 23 88 11 00 23 28 05 00 2B 10 11 00 23 10 A2 00 C8 03 B1 AF 21 28 A0 02 CC 03 A2 AF ?? ?? ?? 0? 21 A8 C0 01 21 28 A2 00 ?? ?? ?? 0? 00 00 A2 80 21 10 C0 02 21 B0 A0 02 ?? ?? ?? 0? 21 A8 40 00 23 20 2C 01 2B 10 24 01 23 10 02 00 2A 30 62 00 06 00 C0 14 00 00 00 00 E7 FD 43 14 35 01 07 24 2B 30 A4 00 E5 FD C0 10 21 B0 84 01 21 20 A0 00 ?? ?? ?? 0? 21 10 60 00 ?? ?? 05 3C 21 20 E0 02 ?? ?? A5 24 03 00 06 24 ?? ?? ?? 0? 21 38 80 02 57 FD 40 14 00 00 00 00 0A 00 40 12 03 00 F0 26 ?? ?? 05 3C 21 20 00 02 ?? ?? A5 24 05 00 06 24 ?? ?? ?? 0? 21 38 80 02 08 00 F7 26 0A 80 E2 02 00 00 50 AE E0 03 AA 8F 9B 04 40 15 ?? ?? 02 3C ?? ?? 44 8C ?? ?? ?? 0? ?? ?? 45 8C 21 28 20 02 21 30 00 02 ?? ?? ?? 0? 21 38 80 02 D0 03 A6 8F 21 20 40 02 21 28 40 02 ?? ?? ?? 0? 21 38 80 02 49 FE 40 10 D0 03 A6 8F 80 18 06 00 21 18 23 02 01 00 C6 24 D0 03 A6 AF ?? ?? ?? 0? CC 01 62 AC 2B 48 49 00 EC FD 20 11 00 00 00 00 01 00 03 24 23 10 56 00 FC 03 A3 AF ?? ?? ?? 0? E4 03 A2 AF 2B 20 02 01 DD FD 80 10 00 00 00 00 E4 03 A2 8F ?? ?? ?? 0? C3 1F 02 00 F4 01 B1 8F 9E 05 D0 14 28 00 A7 8F 2B 10 27 02 02 24 07 00 FF FF E9 30 99 05 40 10 20 00 0B 24 1B 00 24 02 F4 01 80 00 12 88 00 00 10 18 00 00 00 1C 03 00 12 30 00 00 02 28 29 72 2B 10 65 00 0A 00 40 10 00 00 00 00 21 18 67 00 2B 10 67 00 06 00 40 14 FF FF 26 26 2B 10 65 00 03 00 40 10 00 00 00 00 FE FF 26 26 21 18 67 00 23 18 65 00 1B 00 64 00 F4 01 80 00 12 18 00 00 10 10 00 00 00 14 02 00 12 28 00 00 02 88 69 70 2B 50 51 00 0A 00 40 11 00 00 00 00 21 10 47 00 2B 50 47 00 06 00 40 15 FF FF 65 24 2B 50 51 00 03 00 40 11 00 00 00 00 FE FF 65 24 21 10 47 00 00 34 06 00 23 88 51 00 2A 00 60 16 25 80 A6 00 30 00 00 12 C8 03 A2 8F 20 90 12 72 CC 03 A6 8F 23 28 52 00 2B 10 45 00 23 40 72 01 23 30 C2 00 36 00 0A 29 21 10 A0 00 C8 03 A5 AF 21 18 C0 00 2D 00 40 15 CC 03 A6 AF EB FF 02 24 23 10 52 00 06 10 50 00 C0 03 A2 AF 35 00 52 26 21 10 A0 00 C0 03 B4 27 FF FF 67 24 FC 03 A3 8F E0 03 A8 8F 1F 00 05 24 FF FF 46 24 2B 88 11 00 01 00 04 24 23 90 B2 00 0A 20 23 02 2B 10 C2 00 1C 00 A4 AF 10 00 A8 AF 21 20 80 02 14 00 B0 AF 18 00 B2 AF ?? ?? ?? 0? 21 38 47 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 16 00 62 2A 15 00 40 10 35 00 12 24 C0 03 A2 8F 20 00 73 26 C0 03 B0 AF ?? ?? ?? 0? C4 03 A2 AF CC 03 A3 8F E0 FF 45 24 2B 30 A2 00 FF FF 63 24 21 18 C3 00 21 40 00 00 21 10 A0 00 C8 03 A5 AF CC 03 A3 AF }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "__xpg_basename"
		size = 284
		refs = "0020 strrchr 00ac $LC0"
	strings:
		$1 = { E0 FF BD 27 18 00 B0 AF 1C 00 BF AF 26 00 80 10 21 80 80 00 00 00 82 80 24 00 40 10 1C 00 BF 8F ?? ?? ?? 0? 2F 00 05 24 25 00 40 10 21 18 40 00 01 00 44 80 18 00 80 14 01 00 42 24 2B 10 03 02 15 00 40 10 21 10 60 00 FF FF 64 80 2F 00 02 24 1D 00 82 14 2F 00 05 24 ?? ?? ?? 0? FF FF 62 24 FF FF 44 80 19 00 85 14 21 18 40 00 FF FF 62 24 FB FF 50 14 00 00 00 00 00 00 63 80 07 00 60 10 1C 00 BF 8F 01 00 42 24 01 00 43 80 FE FF 60 14 01 00 42 24 FF FF 42 24 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 1C 00 BF 8F ?? ?? 02 3C 18 00 B0 8F ?? ?? 42 24 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? 21 10 00 02 21 10 60 00 FF FF 43 24 2B 20 03 02 0F 00 80 10 00 00 40 A0 FE FF 44 80 2F 00 02 24 0B 00 82 10 2F 00 04 24 ?? ?? ?? 0? 21 10 60 00 FF FF 43 80 E8 FF 64 10 00 00 00 00 FF FF 42 24 FB FF 50 14 1C 00 BF 8F ?? ?? ?? 0? 18 00 B0 8F ?? ?? ?? 0? 21 10 60 00 }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "__ppoll_chk"
		size = 44
		refs = "001c ppoll 0024 __chk_fail"
	strings:
		$1 = { E0 FF BD 27 30 00 A2 8F C2 10 02 00 2B 10 45 00 04 00 40 14 1C 00 BF AF 1C 00 BF 8F ?? ?? ?? 0? 20 00 BD 27 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "execl"
		size = 372
		refs = "00a4 __environ 00b0 __execve 00c0 free 0104 realloc 015c memcpy"
	strings:
		$1 = { B8 EF BD 27 28 10 B1 AF 50 10 B1 27 44 10 BF AF 40 10 B7 AF 3C 10 B6 AF 38 10 B5 AF 34 10 B4 AF 30 10 B3 AF 2C 10 B2 AF 24 10 B0 AF 50 10 A6 AF 54 10 A7 AF 18 00 A5 AF 38 00 A0 10 18 10 B1 AF 04 00 31 26 01 00 10 24 18 00 B5 27 FC FF 23 8E 80 B8 10 00 21 98 A0 02 21 38 77 02 21 B0 80 00 10 00 12 24 00 04 14 24 00 00 E3 AC 18 10 B1 AF 0C 00 60 10 01 00 10 26 1F 00 90 12 21 20 60 02 08 00 52 26 04 00 31 26 FC FF 23 8E 80 B8 10 00 21 38 77 02 00 00 E3 AC 18 10 B1 AF F6 FF 60 14 01 00 10 26 ?? ?? 02 3C ?? ?? 46 8C 21 20 C0 02 ?? ?? ?? 0? 21 28 60 02 04 00 B3 12 21 80 40 00 ?? ?? ?? 0? 21 20 60 02 21 10 00 02 44 10 BF 8F 40 10 B7 8F 3C 10 B6 8F 38 10 B5 8F 34 10 B4 8F 30 10 B3 8F 2C 10 B2 8F 28 10 B1 8F 24 10 B0 8F 08 00 E0 03 48 10 BD 27 21 28 40 02 11 00 B3 12 40 A0 14 00 ?? ?? ?? 0? 00 00 00 00 09 00 40 10 08 00 52 26 ?? ?? ?? 0? 21 98 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? ?? 0? 18 00 A5 27 ?? ?? ?? 0? 44 10 BF 8F ?? ?? ?? 0? 21 20 60 02 ?? ?? ?? 0? FF FF 02 24 ?? ?? ?? 0? 21 20 00 00 07 00 40 10 21 98 40 00 21 20 60 02 21 28 A0 02 ?? ?? ?? 0? 04 00 E6 26 ?? ?? ?? 0? 08 00 52 26 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "_rpc_dtablesize"
		size = 52
		refs = "0018 __getdtablesize"
	strings:
		$1 = { E0 FF BD 27 18 00 B0 AF ?? ?? 10 3C ?? ?? 02 8E 04 00 40 14 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 02 AE 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "__mpn_mod_1"
		size = 1552
	strings:
		$1 = { 2A 01 A0 10 21 10 00 00 80 10 05 00 40 19 05 00 21 10 43 00 21 10 45 00 40 10 02 00 65 00 42 28 71 00 40 14 20 C0 D8 70 20 10 C2 70 D1 00 40 10 04 40 46 00 40 18 08 00 24 00 60 10 FF FF 0D 24 23 30 08 00 02 1C 08 00 1B 00 C3 00 F4 01 60 00 FF FF 09 31 12 50 00 00 10 30 00 00 00 34 06 00 12 68 00 00 02 38 49 71 2B 58 C7 00 0A 00 60 11 00 00 00 00 21 30 C8 00 2B 58 C8 00 06 00 60 15 FF FF 4D 25 2B 58 C7 00 03 00 60 11 00 00 00 00 FE FF 4D 25 21 30 C8 00 23 30 C7 00 1B 00 C3 00 F4 01 60 00 12 30 00 00 10 18 00 00 00 54 03 00 12 38 00 00 02 48 C9 70 2B 18 49 01 3A 01 60 14 00 00 00 00 00 6C 0D 00 25 68 ED 00 80 18 05 00 FC FF 63 24 21 30 83 00 00 00 CC 8C 20 00 0E 24 23 70 C2 01 02 00 A6 28 42 01 C0 14 06 48 CC 01 23 78 05 00 80 78 0F 00 04 00 63 24 04 00 EF 25 21 20 83 00 ?? ?? ?? 0? 21 28 00 00 21 48 60 00 19 00 2D 01 21 18 85 00 F8 FF 6A 8C 04 60 4C 00 FC FF A5 24 06 58 CA 01 25 58 6C 01 21 60 40 01 10 38 00 00 21 30 27 01 19 00 C8 00 12 30 00 00 23 18 66 01 23 30 68 00 10 38 00 00 2B 58 63 01 23 48 27 01 23 48 2B 01 2B 38 66 00 23 58 C8 00 03 00 20 11 26 38 27 01 21 18 C0 00 0B 18 67 01 2B 38 68 00 23 30 68 00 E4 FF AF 14 0A 18 C7 00 19 00 6D 00 04 50 4A 00 10 28 00 00 21 20 65 00 19 00 88 00 12 20 00 00 23 C0 44 01 2B 50 58 01 10 28 00 00 23 18 65 00 23 50 6A 00 08 00 40 11 2B 18 08 03 23 18 08 03 2B C0 03 03 26 C0 58 01 23 20 68 00 0B 18 98 00 21 C0 60 00 2B 18 08 03 23 40 08 03 0A C0 03 01 08 00 E0 03 06 10 58 00 08 00 E0 03 21 10 60 00 B2 00 00 13 80 38 05 00 FC FF E7 24 21 10 87 00 00 00 4E 8C 20 00 02 24 23 10 58 00 02 00 A8 28 04 30 06 03 FC 00 00 15 06 18 4E 00 23 C8 05 00 04 00 E8 24 80 C8 19 00 21 20 88 00 02 3C 06 00 FF FF CD 30 04 00 39 27 21 40 00 00 1B 00 67 00 F4 01 E0 00 21 58 88 00 F8 FF 6B 8D 04 70 0E 03 FC FF 08 25 06 60 4B 00 25 60 8E 01 02 2C 0C 00 21 70 60 01 12 18 00 00 10 78 00 00 02 50 6D 70 00 1C 0F 00 25 28 A3 00 2B 48 AA 00 07 00 20 11 FF FF 8C 31 21 28 A6 00 2B 18 A6 00 2B 78 AA 00 02 00 60 14 21 48 A6 00 0B 28 2F 01 23 28 AA 00 1B 00 A7 00 F4 01 E0 00 12 28 00 00 10 18 00 00 00 1C 03 00 25 18 6C 00 02 48 AD 70 2B 50 69 00 07 00 40 11 00 00 00 00 21 18 66 00 2B 28 66 00 2B 60 69 00 02 00 A0 14 21 50 66 00 0B 18 4C 01 D6 FF 19 15 23 18 69 00 1B 00 67 00 F4 01 E0 00 04 58 0B 03 02 14 0B 00 12 18 00 00 10 40 00 00 02 20 6D 70 00 1C 08 00 25 10 43 00 2B 18 44 00 05 00 60 10 00 00 00 00 21 10 46 00 2B 18 46 00 B3 00 60 10 2B 28 44 00 23 10 44 00 1B 00 47 00 F4 01 E0 00 FF FF 6B 31 12 10 00 00 10 28 00 00 02 68 4D 70 00 14 05 00 25 58 4B 00 2B 10 6D 01 08 00 40 10 23 10 6D 01 21 58 66 01 2B 10 66 01 03 00 40 14 21 30 66 01 2B 10 6D 01 0B 58 C2 00 23 10 6D 01 08 00 E0 03 06 10 02 03 40 10 06 00 24 00 40 10 FF FF 0B 24 23 18 06 00 02 14 06 00 1B 00 62 00 F4 01 40 00 FF FF C8 30 12 48 00 00 10 18 00 00 00 1C 03 00 12 58 00 00 02 38 28 71 2B 50 67 00 0A 00 40 11 00 00 00 00 21 18 66 00 2B 50 66 00 06 00 40 15 FF FF 2B 25 2B 50 67 00 03 00 40 11 00 00 00 00 FE FF 2B 25 21 18 66 00 23 18 67 00 1B 00 62 00 F4 01 40 00 12 18 00 00 10 10 00 00 00 4C 02 00 12 38 00 00 02 40 68 70 2B 10 28 01 72 00 40 14 00 00 00 00 00 5C 0B 00 25 58 EB 00 FF FF A2 24 80 18 02 00 21 18 83 00 00 00 63 8C 2B 38 66 00 5D 00 E0 10 00 00 00 00 FE FF A2 24 6C FF 40 04 27 60 02 00 80 10 02 00 80 60 0C 00 21 20 82 00 ?? ?? ?? 0? 21 28 00 00 21 18 40 00 19 00 6B 00 21 10 85 00 00 00 4A 8C FC FF A5 24 10 48 00 00 21 40 69 00 19 00 06 01 12 40 00 00 23 10 48 01 23 38 46 00 10 48 00 00 23 18 69 00 2B 50 42 01 2B 40 47 00 23 18 6A 00 23 48 E6 00 03 00 60 10 26 40 68 00 21 10 E0 00 0B 10 28 01 2B 38 46 00 23 18 46 00 E8 FF AC 14 0A 10 67 00 08 00 E0 03 00 00 00 00 FF FF A3 24 80 10 03 00 21 10 82 00 00 00 42 8C 2B 38 46 00 35 00 E0 10 00 00 00 00 FE FF A3 24 F5 FF 60 04 27 68 03 00 80 18 03 00 02 3C 06 00 FF FF CB 30 80 68 0D 00 21 20 83 00 21 28 00 00 1B 00 47 00 F4 01 E0 00 21 50 85 00 00 00 4A 8D FC FF A5 24 02 1C 0A 00 12 10 00 00 10 60 00 00 02 48 4B 70 00 14 0C 00 25 18 62 00 2B 10 69 00 07 00 40 10 FF FF 4A 31 21 18 66 00 2B 10 66 00 2B 60 69 00 02 00 40 14 21 40 66 00 0B 18 0C 01 23 18 69 00 1B 00 67 00 F4 01 E0 00 12 18 00 00 10 10 00 00 00 14 02 00 25 10 4A 00 02 40 6B 70 2B 18 48 00 07 00 60 10 00 00 00 00 21 10 46 00 2B 18 46 00 2B 50 48 00 02 00 60 14 21 48 46 00 0B 10 2A 01 DA FF AD 14 23 10 48 00 08 00 E0 03 00 00 00 00 ?? ?? ?? 0? 21 18 00 00 ?? ?? ?? 0? 21 10 00 00 21 50 48 01 2B 18 48 01 C4 FE 60 14 FF FF C7 24 2B 48 49 01 FE FF C6 24 ?? ?? ?? 0? 0B 38 C9 00 21 48 26 01 2B 10 26 01 8C FF 40 14 FF FF 67 24 2B 40 28 01 FE FF 63 24 ?? ?? ?? 0? 0B 38 68 00 21 18 46 00 ?? ?? ?? 0? 0B 10 65 00 21 18 20 01 ?? ?? ?? 0? 21 50 80 01 02 3C 06 00 FF FF CD 30 ?? ?? ?? 0? 21 58 C0 01 }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "fputc"
		size = 452
		refs = "006c __lll_lock_wait_private 013c __overflow 0170 _Unwind_Resume"
		altNames = "_IO_putc"
	strings:
		$1 = { 00 00 A2 8C D0 FF BD 27 28 00 B2 AF 00 80 42 30 20 00 B0 AF 2C 00 BF AF 24 00 B1 AF 21 80 A0 00 1A 00 40 14 21 90 80 00 3B E8 03 7C 48 00 A4 8C 70 8B 71 24 08 00 83 8C 11 00 71 10 00 00 00 00 18 00 A0 AF 00 00 85 C0 06 00 A0 14 00 00 03 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 03 24 0F 00 00 00 03 00 60 14 00 00 00 00 ?? ?? ?? 0? 18 00 A5 AF 48 00 03 8E 21 20 60 00 08 00 71 AC 04 00 83 8C 01 00 63 24 04 00 83 AC 14 00 03 8E 18 00 02 8E 2B 10 62 00 27 00 40 10 01 00 62 24 14 00 02 AE FF 00 51 32 00 00 72 A0 00 00 02 8E 00 80 42 30 07 00 40 14 2C 00 BF 8F 48 00 04 8E 04 00 82 8C FF FF 42 24 08 00 40 10 04 00 82 AC 2C 00 BF 8F 21 10 20 02 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 F0 FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 2C 00 BF 8F 21 20 00 02 ?? ?? ?? 0? FF 00 45 32 ?? ?? ?? 0? 21 88 40 00 00 00 02 8E 00 80 42 30 06 00 40 14 21 88 80 00 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "__finite"
		size = 20
	strings:
		$1 = { 00 F0 A5 7C 10 80 02 3C 21 10 A2 00 08 00 E0 03 C2 17 02 00 }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "_nl_intern_locale_data"
		size = 996
		refs = "0000 __gnu_local_gp 0094 malloc 0194 free 01a8 __libc_errno 01cc $LC10 01d0 $LC1 01e0 __assert_fail 0154 __PRETTY_FUNCTION__.8345 01f4 $LC9 021c $LC8 0244 $LC7 026c $LC6 0294 $LC5 02bc $LC4 02e4 $LC3 030c $LC2 0334 $LC0 038c $LC11 03c8 $LC12"
	strings:
		$1 = { ?? ?? 1C 3C D0 FF BD 27 ?? ?? 9C 27 08 00 C2 2C 24 00 B3 AF 2C 00 BF AF 28 00 B4 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 10 00 BC AF DE 00 40 14 21 98 C0 00 03 00 03 24 21 80 80 00 21 88 A0 00 24 00 83 10 00 00 A2 8C 1F 00 80 14 03 20 03 3C 09 20 03 3C 20 07 63 24 D3 00 62 14 ?? ?? 02 3C 80 A0 10 00 ?? ?? 42 24 21 10 54 00 04 00 32 8E 00 00 42 8C 2B 10 42 02 CB 00 40 14 00 00 00 00 02 00 44 26 80 20 04 00 2B 10 93 00 C6 00 40 10 00 00 00 00 ?? ?? ?? 0? 1C 00 84 24 10 00 40 14 21 18 00 00 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 21 10 60 00 08 00 E0 03 30 00 BD 27 15 11 63 24 ?? ?? ?? 0? 26 18 83 00 05 20 03 3C ?? ?? ?? 0? 17 10 63 24 04 00 51 AC 08 00 53 AC 14 00 40 AC 10 00 40 AC 18 00 40 AC 1C 00 40 AC A2 00 40 12 20 00 52 AC 08 00 24 8E 2B 18 64 02 22 00 60 14 ?? ?? 0B 3C ?? ?? 07 3C ?? ?? 6B 25 ?? ?? E7 24 21 58 74 01 21 30 20 02 21 28 40 00 21 18 00 00 0D 00 08 2E 05 00 0A 24 21 A0 F4 00 85 00 00 11 00 00 00 00 00 00 87 8E 08 00 E0 00 00 00 00 00 10 00 67 2C 8E 00 E0 10 ?? ?? 07 3C 00 00 69 8D 80 38 03 00 21 38 27 01 00 00 E7 8C 80 00 EA 10 03 00 87 30 21 20 24 02 24 00 A4 AC 01 00 63 24 81 00 72 10 04 00 A5 24 0C 00 C4 8C 2B 38 64 02 EA FF E0 10 04 00 C6 24 ?? ?? ?? 0? 21 20 40 00 10 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC ?? ?? ?? 0? 21 18 00 00 02 00 67 2C E4 FF E0 14 ?? ?? 07 3C ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 89 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 05 00 67 2C DA FF E0 14 ?? ?? 07 3C ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 88 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 0D 00 67 2C D0 FF E0 14 ?? ?? 07 3C ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 87 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 07 00 67 2C C6 FF E0 14 ?? ?? 07 3C ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 86 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 03 00 67 2C BC FF E0 14 ?? ?? 07 3C ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 85 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 05 00 67 2C B2 FF E0 14 ?? ?? 07 3C ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 84 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 2E 00 67 2C A8 FF E0 14 ?? ?? 07 3C ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 83 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 13 00 67 2C 9E FF E0 14 ?? ?? 07 3C ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 82 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 6F 00 67 2C 94 FF E0 14 ?? ?? 07 3C ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 81 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 06 00 67 2C 8A FF E0 14 ?? ?? 07 3C ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 80 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 1D 00 00 16 ?? ?? 07 3C 47 00 67 2C 84 FF E0 10 00 00 00 00 ?? ?? ?? 0? 00 00 69 8D 89 FF E0 14 00 00 00 00 21 20 24 02 00 00 84 8C ?? ?? ?? 0? 24 00 A4 AC ?? ?? ?? 0? 21 18 40 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 8A 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC ?? ?? ?? 0? 21 18 00 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 8C 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_191_1_0 {
	meta:
		name = "_nl_load_locale"
		size = 860
		refs = "0004 __gnu_local_gp 0074 __fxstat64 0098 __libc_errno 00bc __mmap 00ec _nl_intern_locale_data 0198 malloc 0204 free 022c __munmap 027c strlen 0284 _nl_category_name_sizes 02b4 mempcpy 02bc $LC13 02d0 _nl_category_name_idxs 02e0 _nl_category_names 02f0 memcpy"
	strings:
		$1 = { 10 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 E8 00 BE AF 01 00 02 24 21 F0 A0 03 DC 00 B5 AF CC 00 B1 AF EC 00 BF AF E4 00 B7 AF E0 00 B6 AF D8 00 B4 AF D4 00 B3 AF D0 00 B2 AF C8 00 B0 AF 18 00 DC AF 21 88 80 00 21 A8 A0 00 04 00 82 AC 08 00 80 AC 08 00 05 3C 00 00 84 8C A5 0F 02 24 0C 00 00 00 36 00 E0 14 21 80 40 00 27 00 40 04 03 00 04 24 21 28 40 00 ?? ?? ?? 0? 20 00 C6 27 63 00 40 04 18 00 DC 8F 38 00 C3 8F 00 40 02 24 00 F0 63 30 77 00 62 10 21 20 00 02 ?? ?? 93 8F 3B E8 03 7C 58 00 C5 8F 21 B0 63 02 00 00 D7 8E 21 20 00 00 10 00 B0 AF 14 00 A0 AF 01 00 06 24 ?? ?? ?? 0? 02 00 07 24 21 90 40 00 FF FF 02 24 2D 00 42 12 01 00 14 24 21 20 00 02 A6 0F 02 24 0C 00 00 00 09 00 40 12 58 00 C6 8F 21 20 A0 02 ?? ?? ?? 0? 21 28 40 02 4A 00 40 10 00 00 00 00 00 00 40 AC 0C 00 54 AC 08 00 22 AE 21 E8 C0 03 EC 00 BF 8F E8 00 BE 8F E4 00 B7 8F E0 00 B6 8F DC 00 B5 8F D8 00 B4 8F D4 00 B3 8F D0 00 B2 8F CC 00 B1 8F C8 00 B0 8F 08 00 E0 03 F0 00 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 50 AC 21 E8 C0 03 EC 00 BF 8F E8 00 BE 8F E4 00 B7 8F E0 00 B6 8F DC 00 B5 8F D8 00 B4 8F D4 00 B3 8F D0 00 B2 8F CC 00 B1 8F C8 00 B0 8F 08 00 E0 03 F0 00 BD 27 00 00 C3 8E 59 00 02 24 71 00 62 14 00 00 00 00 58 00 D4 8F ?? ?? ?? 0? 21 20 80 02 6A 00 40 10 21 90 40 00 63 00 80 1A 21 20 00 02 21 28 40 00 21 30 80 02 A3 0F 02 24 0C 00 00 00 0D 00 E0 14 00 00 00 00 1E 00 40 18 21 B0 40 02 23 A0 82 02 58 00 80 1A 21 B0 C2 02 21 20 00 02 21 28 C0 02 21 30 80 02 A3 0F 02 24 0C 00 00 00 12 00 E0 10 00 00 00 00 3B E8 03 7C 21 98 63 02 21 20 40 02 ?? ?? ?? 0? 00 00 62 AE 21 20 00 02 A6 0F 02 24 0C 00 00 00 ?? ?? ?? 0? 21 E8 C0 03 B9 FF 80 12 00 00 00 00 58 00 C5 8F ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? 21 E8 C0 03 E5 FF 40 1C 23 A0 82 02 21 20 40 02 ?? ?? ?? 0? C0 00 C2 AF C0 00 C2 8F EE FF 40 14 21 20 00 02 3B E8 03 7C 21 10 63 02 16 00 03 24 ?? ?? ?? 0? 00 00 43 AC A6 0F 02 24 0C 00 00 00 00 00 30 8E ?? ?? ?? 0? 21 20 00 02 ?? ?? 03 3C ?? ?? 63 24 21 18 A3 02 00 00 72 90 21 28 00 02 21 30 40 00 21 18 42 02 14 00 63 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 B0 27 ?? ?? ?? 0? 21 20 00 02 ?? ?? 05 3C ?? ?? A5 24 21 20 40 00 ?? ?? ?? 0? 05 00 06 24 ?? ?? 03 3C ?? ?? 63 24 21 18 A3 02 00 00 63 90 ?? ?? 05 3C ?? ?? A5 24 21 28 A3 00 21 20 40 00 ?? ?? ?? 0? 01 00 46 26 18 00 DC 8F 21 20 00 02 08 00 05 3C A5 0F 02 24 0C 00 00 00 8B FF E0 14 21 80 40 00 7C FF 40 04 03 00 04 24 21 28 40 00 ?? ?? ?? 0? 20 00 C6 27 5B FF 41 04 18 00 DC 8F ?? ?? ?? 0? 21 20 00 02 3B E8 03 7C 21 10 63 02 00 00 57 AC ?? ?? ?? 0? 21 A0 00 00 ?? ?? ?? 0? 21 A0 00 00 ?? ?? ?? 0? 21 90 00 00 }
	condition:
		$1
}

rule file_191_2_0 {
	meta:
		name = "_nl_unload_locale"
		size = 128
		refs = "0040 free 0060 __munmap"
	strings:
		$1 = { 10 00 99 8C E0 FF BD 27 18 00 B0 AF 1C 00 BF AF 03 00 20 13 21 80 80 00 09 F8 20 03 00 00 00 00 0C 00 02 8E 12 00 40 10 01 00 03 24 0B 00 43 10 00 00 00 00 02 00 03 24 04 00 43 10 1C 00 BF 8F ?? ?? ?? 0? 00 00 04 8E 1C 00 BF 8F 21 20 00 02 18 00 B0 8F ?? ?? ?? 0? 20 00 BD 27 04 00 04 8E ?? ?? ?? 0? 08 00 05 8E ?? ?? ?? 0? 0C 00 02 8E ?? ?? ?? 0? 04 00 04 8E ?? ?? ?? 0? 0C 00 02 8E }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "getutmp"
		size = 88
	strings:
		$1 = { 80 01 88 24 03 00 87 88 07 00 86 88 0B 00 83 88 0F 00 82 88 00 00 87 98 04 00 86 98 08 00 83 98 0C 00 82 98 03 00 A7 A8 00 00 A7 B8 07 00 A6 A8 04 00 A6 B8 0B 00 A3 A8 08 00 A3 B8 10 00 84 24 0F 00 A2 A8 0C 00 A2 B8 EE FF 88 14 10 00 A5 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "__sysv_signal"
		size = 172
		refs = "0000 __gnu_local_gp 0040 memset 0058 __sigaction 0080 __libc_errno"
	strings:
		$1 = { ?? ?? 1C 3C C0 FE BD 27 ?? ?? 9C 27 FF FF 03 24 21 10 A0 00 3C 01 BF AF 38 01 B0 AF 16 00 A3 10 10 00 BC AF FF FF 83 24 7F 00 63 2C 12 00 60 10 21 80 80 00 B0 00 A4 27 21 28 00 00 80 00 06 24 ?? ?? ?? 0? AC 00 A2 AF 00 E0 02 3C 21 20 00 02 A8 00 A5 27 18 00 A6 27 ?? ?? ?? 0? A8 00 A2 AF 10 00 40 04 3C 01 BF 8F 1C 00 A2 8F 38 01 B0 8F 08 00 E0 03 40 01 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC FF FF 02 24 3C 01 BF 8F 38 01 B0 8F 08 00 E0 03 40 01 BD 27 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "__getsockopt"
		size = 28
	strings:
		$1 = { 4D 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "posix_spawnattr_setschedpolicy"
		size = 32
	strings:
		$1 = { 03 00 A3 2C 03 00 60 14 16 00 02 24 08 00 E0 03 00 00 00 00 0C 01 85 AC 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "erand48"
		size = 44
		refs = "0010 __erand48_r 0004 __libc_drand48_data"
	strings:
		$1 = { D8 FF BD 27 ?? ?? 05 3C 18 00 A6 27 24 00 BF AF ?? ?? ?? 0? ?? ?? A5 24 24 00 BF 8F 18 00 A2 8F 1C 00 A3 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_200_0_0 {
	meta:
		name = "__fstat"
		size = 20
		refs = "000c __fxstat"
		altNames = "fstat64"
	strings:
		$1 = { 21 10 80 00 21 30 A0 00 03 00 04 24 ?? ?? ?? 0? 21 28 40 00 }
	condition:
		$1
}

rule file_800_0_0 {
	meta:
		name = "__lstat"
		size = 20
		refs = "000c __lxstat"
	strings:
		$1 = { 21 10 80 00 21 30 A0 00 03 00 04 24 ?? ?? ?? 0? 21 28 40 00 }
	condition:
		$1
}

rule file_951_0_0 {
	meta:
		name = "__stat"
		size = 20
		refs = "000c __xstat"
	strings:
		$1 = { 21 10 80 00 21 30 A0 00 03 00 04 24 ?? ?? ?? 0? 21 28 40 00 }
	condition:
		$1
}

rule file_591_0_0 {
	meta:
		name = "lstat64"
		size = 20
		refs = "000c __lxstat64"
	strings:
		$1 = { 21 10 80 00 21 30 A0 00 03 00 04 24 ?? ?? ?? 0? 21 28 40 00 }
	condition:
		$1
}

rule file_602_0_0 {
	meta:
		name = "stat64"
		size = 20
		refs = "000c __xstat64"
	strings:
		$1 = { 21 10 80 00 21 30 A0 00 03 00 04 24 ?? ?? ?? 0? 21 28 40 00 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "revoke"
		size = 40
		refs = "0000 __gnu_local_gp 0010 __libc_errno"
		altNames = "__sigreturn fattach fdetach lchmod setlogin sstk"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 59 00 03 24 00 00 43 AC 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "_IO_obstack_xsputn"
		size = 232
		refs = "0060 memcpy 00ac _obstack_newchunk 00bc mempcpy"
	strings:
		$1 = { D0 FF BD 27 20 00 B1 AF 21 88 80 00 14 00 84 8C 18 00 22 8E 24 00 B2 AF 21 18 86 00 2B 18 43 00 1C 00 B0 AF 2C 00 BF AF 28 00 B3 AF 21 90 C0 00 22 00 60 10 A0 00 30 8E 21 98 A0 00 0C 00 05 8E 23 20 82 00 10 00 03 8E 21 20 A4 00 21 10 86 00 2B 10 62 00 14 00 40 14 0C 00 04 AE 21 28 60 02 ?? ?? ?? 0? 21 30 40 02 0C 00 03 8E 10 00 02 8E 08 00 04 8E 2C 00 BF 8F 21 18 72 00 18 00 22 AE 10 00 24 AE 14 00 23 AE 28 00 B3 8F 0C 00 02 AE 20 00 B1 8F 21 10 40 02 1C 00 B0 8F 24 00 B2 8F 08 00 E0 03 30 00 BD 27 21 20 00 02 ?? ?? ?? 0? 21 28 C0 00 ?? ?? ?? 0? 0C 00 04 8E ?? ?? ?? 0? 00 00 00 00 2C 00 BF 8F 14 00 22 AE 28 00 B3 8F 21 10 40 02 20 00 B1 8F 24 00 B2 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_202_1_0 {
	meta:
		name = "_IO_obstack_overflow"
		size = 172
		refs = "0040 _obstack_newchunk 008c $LC0 0090 $LC1 00a4 __assert_fail 0094 __PRETTY_FUNCTION__.9814"
	strings:
		$1 = { D0 FF BD 27 FF FF 03 24 21 10 A0 00 28 00 B1 AF 24 00 B0 AF 2C 00 BF AF 21 88 80 00 1B 00 A3 10 A0 00 90 8C 0C 00 03 8E 10 00 05 8E 01 00 64 24 2B 28 A4 00 07 00 A0 10 01 00 05 24 21 20 00 02 ?? ?? ?? 0? 18 00 A2 AF 0C 00 03 8E 18 00 A2 8F 01 00 64 24 0C 00 04 AE 00 00 62 A0 0C 00 04 8E 10 00 03 8E 08 00 05 8E 2C 00 BF 8F 14 00 24 AE 10 00 25 AE 18 00 23 AE 0C 00 03 AE 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 2F 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_202_2_0 {
	meta:
		name = "_IO_obstack_vprintf"
		size = 392
		refs = "003c _IO_no_init 0050 _IO_obstack_jumps 0080 _IO_str_init_static_internal 00c8 _IO_vfprintf 0108 _obstack_newchunk 0120 $LC2 0124 $LC1 0138 __assert_fail 0128 __PRETTY_FUNCTION__.9849 014c $LC4 0098 $LC3"
	strings:
		$1 = { 20 FF BD 27 21 38 00 00 D4 00 B3 AF D0 00 B2 AF C8 00 B0 AF 21 98 A0 00 21 80 80 00 00 80 05 34 20 00 A4 27 21 90 C0 00 10 00 A0 AF FF FF 06 24 CC 00 B1 AF DC 00 BF AF D8 00 B4 AF ?? ?? ?? 0? 68 00 A0 AF 10 00 11 8E 08 00 05 8E 0C 00 07 8E ?? ?? 04 3C 23 18 25 02 ?? ?? 84 24 B8 00 A4 AF 37 00 60 14 23 88 27 02 40 00 22 2A 26 00 40 14 21 20 00 02 08 00 05 8E 21 A0 20 02 20 00 A4 27 ?? ?? ?? 0? 21 30 20 02 30 00 A2 8F 38 00 A3 8F 23 18 62 00 35 00 71 14 ?? ?? 04 3C 0C 00 03 8E 08 00 04 8E 23 20 64 00 21 10 44 00 34 00 A4 8F 26 00 82 14 21 18 74 00 0C 00 03 AE 20 00 A4 27 21 28 60 02 21 30 40 02 ?? ?? ?? 0? C0 00 B0 AF 38 00 A3 8F 34 00 A5 8F 0C 00 04 8E DC 00 BF 8F 23 18 A3 00 21 18 83 00 0C 00 03 AE D8 00 B4 8F D4 00 B3 8F D0 00 B2 8F CC 00 B1 8F C8 00 B0 8F 08 00 E0 03 E0 00 BD 27 ?? ?? ?? 0? 40 00 05 24 0C 00 07 8E 10 00 11 8E 23 88 27 02 D5 FF 20 16 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 97 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 21 A0 20 02 ?? ?? ?? 0? 21 88 60 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 A2 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 9F 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "skip"
		size = 288
	strings:
		$1 = { 00 00 83 80 43 00 60 10 22 00 07 24 21 28 80 00 21 30 00 00 01 00 09 24 23 00 0A 24 20 00 0B 24 11 00 67 10 5C 00 0C 24 16 00 C9 10 01 00 88 24 00 00 A2 80 31 00 6A 10 00 00 82 A0 F7 FF 62 24 02 00 42 2C 1C 00 40 14 00 00 00 00 1A 00 6B 10 21 20 00 01 01 00 A3 80 07 00 60 10 01 00 A2 24 F1 FF 67 14 21 28 40 00 01 00 A3 80 01 00 C6 38 FB FF 60 14 01 00 A2 24 21 40 80 00 08 00 E0 03 FF FF 00 A1 05 00 6C 10 00 00 00 00 00 00 A2 80 01 00 84 24 ?? ?? ?? 0? FF FF 82 A0 01 00 A2 80 FA FF 47 14 00 00 00 00 00 00 82 A0 01 00 A5 24 ?? ?? ?? 0? 01 00 84 24 ?? ?? 02 3C ?? ?? 43 A0 00 00 A0 A0 01 00 A2 24 20 00 05 24 00 00 43 80 F7 FF 64 24 FF 00 84 30 02 00 84 2C 05 00 80 14 00 00 00 00 03 00 65 10 00 00 00 00 08 00 E0 03 FF FF 00 A1 ?? ?? ?? 0? 01 00 42 24 ?? ?? 02 3C ?? ?? 43 A0 00 00 A0 A0 21 10 A0 00 08 00 E0 03 FF FF 00 A1 21 40 80 00 ?? ?? ?? 0? 21 10 80 00 }
	condition:
		$1
}

rule file_203_1_0 {
	meta:
		name = "setttyent"
		size = 124
		refs = "0018 rewind 0034 $LC0 0040 _IO_new_fopen 0038 $LC1"
	strings:
		$1 = { E0 FF BD 27 18 00 B0 AF ?? ?? 10 3C ?? ?? 04 8E 08 00 80 10 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 01 00 02 24 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? ?? 0? ?? ?? A5 24 21 18 40 00 09 00 40 10 ?? ?? 02 AE 00 00 44 8C 1C 00 BF 8F 18 00 B0 8F 00 80 84 34 01 00 02 24 00 00 64 AC 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_203_2_0 {
	meta:
		name = "getttyent"
		size = 1048
		refs = "0010 __gnu_local_gp 0044 __libc_tsd_CTYPE_B 0068 fgets_unlocked 007c strchr 01b0 $LC2 01b4 $LC3 01b8 $LC4 0220 strncmp 02f0 $LC5 03d4 setttyent 0408 __uflow"
	strings:
		$1 = { C0 FF BD 27 20 00 B2 AF ?? ?? 12 3C ?? ?? 46 8E ?? ?? 1C 3C ?? ?? 9C 27 3C 00 BF AF 38 00 BE AF 34 00 B7 AF 30 00 B6 AF 2C 00 B5 AF 28 00 B4 AF 24 00 B3 AF 1C 00 B1 AF 18 00 B0 AF E5 00 C0 10 10 00 BC AF ?? ?? 97 8F ?? ?? 14 3C ?? ?? 91 26 3B E8 03 7C 21 98 20 02 FF FF 10 24 21 B0 E3 02 ?? ?? 15 3C 21 20 20 02 ?? ?? ?? 0? 64 00 05 24 21 00 40 10 21 10 00 00 21 20 60 02 ?? ?? ?? 0? 0A 00 05 24 28 00 40 10 ?? ?? A2 26 ?? ?? 83 82 00 00 C6 8E 40 20 03 00 21 20 C4 00 00 00 84 94 00 20 84 30 09 00 80 10 21 38 20 02 00 00 43 80 21 38 40 00 40 28 03 00 21 28 C5 00 00 00 A5 94 00 20 A5 30 F9 FF A0 14 01 00 42 24 04 00 60 10 ?? ?? 46 8E 23 00 02 24 22 00 62 14 21 20 E0 00 21 20 20 02 ?? ?? ?? 0? 64 00 05 24 E3 FF 40 14 21 20 60 02 21 10 00 00 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? 46 8E 0A 00 1E 24 04 00 C2 8C 08 00 C4 8C 2B 20 44 00 B2 00 80 10 01 00 43 24 04 00 C3 AC 00 00 42 90 C6 FF 5E 10 21 20 20 02 F6 FF 50 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 12 3C ?? ?? 16 3C ?? ?? 47 AE ?? ?? C0 A2 ?? ?? ?? 0? ?? ?? 52 26 04 00 42 AE 21 80 40 00 00 00 42 80 89 00 40 14 00 00 00 00 08 00 40 AE 04 00 40 AE 0C 00 40 AE 10 00 40 AE 00 00 11 82 38 00 20 12 ?? ?? C3 82 3B E8 03 7C ?? ?? 13 3C ?? ?? 14 3C ?? ?? 15 3C ?? ?? 73 26 ?? ?? 94 26 ?? ?? B5 26 ?? ?? 1E 3C ?? ?? ?? 0? 21 B8 E3 02 03 00 02 82 00 00 E3 8E 40 10 02 00 21 10 62 00 00 00 42 94 00 20 42 30 11 00 40 10 21 28 80 02 0C 00 43 8E FE FF 02 24 24 10 62 00 0C 00 42 AE ?? ?? ?? 0? 21 20 00 02 00 00 51 80 1C 00 20 12 21 80 40 00 21 20 00 02 21 28 60 02 ?? ?? ?? 0? 03 00 06 24 EA FF 40 10 21 20 00 02 21 28 80 02 ?? ?? ?? 0? 02 00 06 24 20 00 40 14 21 20 00 02 02 00 02 82 00 00 E3 8E 40 10 02 00 21 10 62 00 00 00 42 94 00 20 42 30 19 00 40 10 21 28 A0 02 0C 00 42 8E 21 20 00 02 01 00 42 34 ?? ?? ?? 0? 0C 00 42 AE 00 00 51 80 E6 FF 20 16 21 80 40 00 ?? ?? C3 82 23 00 02 24 31 00 62 14 00 00 00 00 20 00 03 24 09 00 04 24 01 00 10 26 00 00 02 82 FD FF 43 10 00 00 00 00 FC FF 44 10 01 00 10 26 FF FF 10 26 ?? ?? ?? 0? 14 00 50 AE 21 28 A0 02 ?? ?? ?? 0? 06 00 06 24 0D 00 40 14 21 20 00 02 06 00 02 82 00 00 E3 8E 40 10 02 00 21 10 62 00 00 00 42 94 00 20 42 30 06 00 40 10 ?? ?? C5 27 0C 00 42 8E 02 00 42 34 ?? ?? ?? 0? 0C 00 42 AE ?? ?? C5 27 ?? ?? ?? 0? 06 00 06 24 0A 00 40 14 3D 00 02 24 06 00 03 82 07 00 62 14 21 20 00 02 ?? ?? ?? 0? 3D 00 05 24 01 00 43 24 0A 18 02 00 ?? ?? ?? 0? 10 00 43 AE ?? ?? C3 82 23 00 02 24 D4 FF 62 10 20 00 03 24 D2 FF 22 12 00 00 00 00 14 00 50 AE 00 00 02 82 02 00 40 14 21 20 00 02 14 00 40 AE ?? ?? ?? 0? 0A 00 05 24 1F 00 40 10 00 00 00 00 00 00 40 A0 3C 00 BF 8F 21 10 40 02 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? ?? 0? 21 20 00 02 08 00 42 AE 21 80 40 00 00 00 42 80 0C 00 40 14 00 00 00 00 ?? ?? ?? 0? 08 00 40 AE ?? ?? ?? 0? 00 00 00 00 10 00 BC 8F 18 FF 40 14 ?? ?? 46 8E ?? ?? ?? 0? 21 10 00 00 ?? ?? ?? 0? 21 10 40 02 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 80 40 00 ?? ?? ?? 0? 21 20 C0 00 ?? ?? ?? 0? ?? ?? 46 8E }
	condition:
		$1
}

rule file_203_3_0 {
	meta:
		name = "endttyent"
		size = 80
		refs = "0018 _IO_new_fclose"
	strings:
		$1 = { E0 FF BD 27 18 00 B0 AF ?? ?? 10 3C ?? ?? 04 8E 0A 00 80 10 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 1C 00 BF 8F 01 00 42 24 ?? ?? 00 AE 2B 10 02 00 18 00 B0 8F 08 00 E0 03 20 00 BD 27 1C 00 BF 8F 18 00 B0 8F 01 00 02 24 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_203_4_0 {
	meta:
		name = "getttynam"
		size = 100
		refs = "0010 setttyent 0020 strcmp 0030 getttyent 0044 endttyent"
	strings:
		$1 = { D8 FF BD 27 20 00 B1 AF 24 00 BF AF 1C 00 B0 AF ?? ?? ?? 0? 21 88 80 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 00 00 05 8E 06 00 40 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 21 80 40 00 F8 FF 40 14 21 20 20 02 ?? ?? ?? 0? 00 00 00 00 24 00 BF 8F 21 10 00 02 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "quotactl"
		size = 28
	strings:
		$1 = { 23 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "__strchrnul"
		size = 260
	strings:
		$1 = { 03 00 82 30 09 00 40 14 FF 00 A3 30 ?? ?? ?? 0? FF 00 A5 30 09 00 40 10 21 10 80 00 01 00 84 24 03 00 82 30 07 00 40 10 00 00 00 00 00 00 82 90 F8 FF 43 14 00 00 00 00 21 10 80 00 08 00 E0 03 00 00 00 00 FF 00 A5 30 00 62 05 00 25 28 85 01 00 64 05 00 FE 7E 08 3C 01 81 0B 3C 25 60 85 01 FF FE 08 35 00 01 6B 25 04 00 85 24 FC FF A6 8C 26 38 CC 00 27 50 07 00 27 48 06 00 21 38 E8 00 21 30 C8 00 26 38 47 01 26 30 26 01 25 30 E6 00 24 30 CB 00 15 00 C0 10 01 00 82 24 FC FF A6 90 E5 FF C3 10 00 00 00 00 E3 FF C0 10 00 00 00 00 FD FF A6 90 E1 FF C3 10 00 00 00 00 DF FF C0 10 00 00 00 00 FE FF A2 90 0C 00 43 10 00 00 00 00 0A 00 40 10 00 00 00 00 FF FF A2 90 05 00 43 10 00 00 00 00 03 00 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 A0 00 08 00 E0 03 03 00 82 24 08 00 E0 03 02 00 82 24 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "do_waitid"
		size = 108
		refs = "0004 __gnu_local_gp 0058 __libc_errno"
	strings:
		$1 = { E8 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 14 00 BE AF 21 F0 A0 03 F0 FF BD 27 00 00 DC AF 08 00 DD AF 21 10 00 00 E0 FF BD 27 10 00 A2 AF B6 10 02 24 0C 00 00 00 20 00 BD 27 05 00 E0 14 00 00 00 00 21 E8 C0 03 14 00 BE 8F 08 00 E0 03 18 00 BD 27 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_206_1_0 {
	meta:
		name = "__waitid"
		size = 112
		refs = "0030 __libc_enable_asynccancel 0054 __libc_disable_asynccancel"
	strings:
		$1 = { 3B E8 03 7C 70 8B 62 8C 03 00 40 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 D0 FF BD 27 2C 00 BF AF 28 00 B0 AF 18 00 A4 AF 1C 00 A5 AF 20 00 A6 AF ?? ?? ?? 0? 24 00 A7 AF 1C 00 A5 8F 20 00 A6 8F 24 00 A7 8F 18 00 A4 8F ?? ?? ?? 0? 21 80 40 00 21 20 00 02 ?? ?? ?? 0? 18 00 A2 AF 2C 00 BF 8F 18 00 A2 8F 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "__snprintf"
		size = 40
		refs = "0014 _IO_vsnprintf"
	strings:
		$1 = { D8 FF BD 27 34 00 A2 27 34 00 A7 AF 21 38 40 00 24 00 BF AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "__asprintf_chk"
		size = 40
		refs = "0014 __vasprintf_chk"
	strings:
		$1 = { D8 FF BD 27 34 00 A2 27 34 00 A7 AF 21 38 40 00 24 00 BF AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_1063_0_0 {
	meta:
		name = "__dprintf_chk"
		size = 40
		refs = "0014 __vdprintf_chk"
	strings:
		$1 = { D8 FF BD 27 34 00 A2 27 34 00 A7 AF 21 38 40 00 24 00 BF AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_1385_1_0 {
	meta:
		name = "__obstack_printf_chk"
		size = 40
		refs = "0014 __obstack_vprintf_chk"
	strings:
		$1 = { D8 FF BD 27 34 00 A2 27 34 00 A7 AF 21 38 40 00 24 00 BF AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_1422_0_0 {
	meta:
		name = "__swprintf"
		size = 40
		refs = "0014 __vswprintf"
	strings:
		$1 = { D8 FF BD 27 34 00 A2 27 34 00 A7 AF 21 38 40 00 24 00 BF AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_888_5_0 {
	meta:
		name = "__syslog_chk"
		size = 40
		refs = "0014 __vsyslog_chk"
	strings:
		$1 = { D8 FF BD 27 34 00 A2 27 34 00 A7 AF 21 38 40 00 24 00 BF AF ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "wcwidth"
		size = 160
		refs = "0000 __gnu_local_gp 0010 _nl_current_LC_CTYPE"
	strings:
		$1 = { ?? ?? 1C 3C 3B E8 03 7C ?? ?? 9C 27 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 43 8C 00 00 63 8C 54 00 63 8C 00 00 65 8C 04 00 66 8C 06 28 A4 00 2B 30 A6 00 18 00 C0 10 FF FF 02 24 05 00 A5 24 80 28 05 00 21 28 65 00 00 00 A5 8C 12 00 A0 10 00 00 00 00 08 00 66 8C 0C 00 67 8C 06 30 C4 00 24 30 C7 00 80 30 06 00 21 28 C5 00 21 28 65 00 00 00 A5 8C 08 00 A0 10 00 00 00 00 10 00 66 8C 21 18 65 00 24 20 86 00 21 18 64 00 00 00 63 90 FF 00 64 38 0B 10 64 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_210_0_0 {
	meta:
		name = "__fcvt"
		size = 252
		refs = "0060 __fcvt_r 00e4 malloc"
	strings:
		$1 = { B8 FF BD 27 30 00 B2 AF ?? ?? 12 3C ?? ?? 42 8E 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 2C 00 B1 AF 28 00 B0 AF 44 00 BF AF 40 00 B6 AF 21 80 80 00 21 88 A0 00 21 A8 C0 00 21 A0 E0 00 15 00 40 10 58 00 B3 8F 14 00 A2 AF 48 01 02 24 10 00 B3 AF 21 20 00 02 21 28 20 02 21 30 A0 02 21 38 80 02 ?? ?? ?? 0? 18 00 A2 AF 44 00 BF 8F ?? ?? 42 8E 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 48 00 BD 27 ?? ?? 16 3C 14 00 02 24 ?? ?? D6 26 10 00 B3 AF 14 00 B6 AF ?? ?? ?? 0? 18 00 A2 AF FF FF 03 24 0B 00 43 10 21 10 C0 02 44 00 BF 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 48 00 BD 27 ?? ?? ?? 0? 48 01 04 24 D5 FF 40 14 ?? ?? 42 AE ?? ?? ?? 0? 21 10 C0 02 }
	condition:
		$1
}

rule file_210_1_0 {
	meta:
		name = "__ecvt"
		size = 68
		refs = "0028 __ecvt_r"
	strings:
		$1 = { D0 FF BD 27 40 00 A2 8F 28 00 B0 AF ?? ?? 10 3C ?? ?? 10 26 10 00 A2 AF 14 00 02 24 14 00 B0 AF 18 00 A2 AF 2C 00 BF AF ?? ?? ?? 0? 00 00 00 00 2C 00 BF 8F 21 10 00 02 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_210_2_0 {
	meta:
		name = "__gcvt"
		size = 72
		refs = "0010 $LC0 002c sprintf"
		altNames = "__qgcvt"
	strings:
		$1 = { D8 FF BD 27 11 00 03 24 12 00 C2 28 14 00 A5 AF ?? ?? 05 3C 10 00 A4 AF 0A 30 62 00 21 20 E0 00 ?? ?? A5 24 24 00 BF AF 20 00 B0 AF ?? ?? ?? 0? 21 80 E0 00 24 00 BF 8F 21 10 00 02 20 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_211_0_0 {
	meta:
		name = "ualarm"
		size = 104
		refs = "0020 __setitimer"
	strings:
		$1 = { C0 FF BD 27 18 00 A6 27 34 00 A4 AF 2C 00 A5 AF 21 20 00 00 28 00 A5 27 3C 00 BF AF 30 00 A0 AF ?? ?? ?? 0? 28 00 A0 AF 0B 00 40 04 FF FF 03 24 20 00 A2 8F 00 22 02 00 C0 18 02 00 23 18 83 00 80 21 03 00 23 18 83 00 24 00 A4 8F 21 18 62 00 80 19 03 00 21 18 64 00 3C 00 BF 8F 21 10 60 00 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_212_2_0 {
	meta:
		name = "svcraw_freeargs"
		size = 96
		refs = "0014 __rpc_thread_variables"
	strings:
		$1 = { D8 FF BD 27 20 00 B1 AF 1C 00 B0 AF 24 00 BF AF 21 80 A0 00 ?? ?? ?? 0? 21 88 C0 00 B8 00 44 8C 0A 00 80 10 24 00 BF 8F 21 28 20 02 21 C8 00 02 20 00 B1 8F 1C 00 B0 8F 02 00 02 24 94 23 82 AC 94 23 84 24 08 00 20 03 28 00 BD 27 20 00 B1 8F 1C 00 B0 8F 21 10 00 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_212_3_0 {
	meta:
		name = "svcraw_getargs"
		size = 88
		refs = "0014 __rpc_thread_variables"
	strings:
		$1 = { D8 FF BD 27 20 00 B1 AF 1C 00 B0 AF 24 00 BF AF 21 80 A0 00 ?? ?? ?? 0? 21 88 C0 00 B8 00 44 8C 08 00 80 10 24 00 BF 8F 21 28 20 02 21 C8 00 02 20 00 B1 8F 1C 00 B0 8F 94 23 84 24 08 00 20 03 28 00 BD 27 20 00 B1 8F 1C 00 B0 8F 21 10 00 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_212_4_0 {
	meta:
		name = "svcraw_reply"
		size = 156
		refs = "0014 __rpc_thread_variables 0044 xdr_replymsg"
	strings:
		$1 = { D8 FF BD 27 20 00 B2 AF 18 00 B0 AF 24 00 BF AF 1C 00 B1 AF ?? ?? ?? 0? 21 90 A0 00 B8 00 50 8C 0C 00 00 12 94 23 11 26 98 23 02 8E 21 20 20 02 14 00 59 8C 21 28 00 00 09 F8 20 03 94 23 00 AE 21 20 20 02 ?? ?? ?? 0? 21 28 40 02 08 00 40 14 00 00 00 00 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 21 10 00 00 08 00 E0 03 28 00 BD 27 98 23 02 8E 10 00 59 8C 09 F8 20 03 21 20 20 02 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 01 00 02 24 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_212_5_0 {
	meta:
		name = "svcraw_recv"
		size = 124
		refs = "0010 __rpc_thread_variables 0044 xdr_callmsg"
	strings:
		$1 = { D8 FF BD 27 20 00 B1 AF 24 00 BF AF 1C 00 B0 AF ?? ?? ?? 0? 21 88 A0 00 B8 00 42 8C 11 00 40 10 94 23 50 24 98 23 43 8C 21 20 00 02 14 00 79 8C 01 00 03 24 94 23 43 AC 09 F8 20 03 21 28 00 00 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 2B 10 02 00 08 00 E0 03 28 00 BD 27 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 21 10 00 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_212_6_0 {
	meta:
		name = "svcraw_create"
		size = 124
		refs = "000c __rpc_thread_variables 0048 xdrmem_create 0064 calloc"
	strings:
		$1 = { E0 FF BD 27 18 00 B0 AF 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 B8 00 50 8C 12 00 00 12 01 00 04 24 ?? ?? 03 3C AC 23 02 26 ?? ?? 63 24 84 22 02 AE 60 22 00 AE 64 22 00 A6 68 22 03 AE 94 23 04 26 21 28 00 02 60 22 06 24 ?? ?? ?? 0? 02 00 07 24 60 22 02 26 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? 3C 25 05 24 EC FF 40 14 21 80 40 00 ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "raise"
		size = 140
		refs = "0004 __gnu_local_gp 0078 __libc_errno"
	strings:
		$1 = { F8 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 04 00 B0 AF 21 30 80 00 3B E8 03 7C D8 8B 65 8C 21 80 60 00 0D 00 A0 14 DC 8B 64 8C 7E 10 02 24 0C 00 00 00 21 20 40 00 D8 8B 02 AE 21 28 40 00 AA 10 02 24 0C 00 00 00 0A 00 E0 14 00 00 00 00 04 00 B0 8F 08 00 E0 03 08 00 BD 27 F8 FF 80 1C 00 F0 83 7C 23 10 04 00 21 20 A0 00 ?? ?? ?? 0? 0B 20 43 00 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "plural_eval"
		size = 520
	strings:
		$1 = { D0 FF BD 27 18 00 B0 AF 21 80 80 00 00 00 02 8E 1C 00 B1 AF 01 00 11 24 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 2C 00 BF AF 21 90 A0 00 02 00 13 24 14 00 51 10 03 00 14 24 02 00 43 28 2F 00 60 14 00 00 00 00 1B 00 53 10 00 00 00 00 35 00 54 14 21 10 00 00 08 00 04 8E ?? ?? ?? 0? 21 28 40 02 21 18 20 02 0A 18 62 02 02 00 62 24 80 10 02 00 21 80 02 02 00 00 10 8E 00 00 02 8E EF FF 51 14 02 00 43 28 08 00 04 8E ?? ?? ?? 0? 21 28 40 02 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 01 00 42 2C 08 00 E0 03 30 00 BD 27 08 00 04 8E ?? ?? ?? 0? 21 28 40 02 04 00 11 8E 21 98 40 00 0F 00 02 24 1F 00 22 12 00 00 00 00 0E 00 02 24 20 00 22 16 00 00 00 00 10 00 60 12 21 10 00 00 0C 00 04 8E ?? ?? ?? 0? 21 28 40 02 ?? ?? ?? 0? 2B 10 02 00 09 00 40 14 21 10 00 00 04 00 02 8E 0E 00 40 10 01 00 03 24 03 00 43 14 00 00 00 00 ?? ?? ?? 0? 08 00 02 8E 21 10 00 00 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? ?? 0? 21 10 40 02 F5 FF 60 16 01 00 02 24 ?? ?? ?? 0? 0C 00 04 8E 0C 00 04 8E 21 28 40 02 ?? ?? ?? 0? FD FF 31 26 0B 00 23 2E EB FF 60 10 ?? ?? 03 3C ?? ?? 63 24 80 88 11 00 21 88 71 00 00 00 23 8E 08 00 60 00 00 00 00 00 26 10 62 02 ?? ?? ?? 0? 01 00 42 2C 2B 10 62 02 ?? ?? ?? 0? 01 00 42 38 2B 10 53 00 ?? ?? ?? 0? 01 00 42 38 ?? ?? ?? 0? 2B 10 53 00 ?? ?? ?? 0? 2B 10 62 02 ?? ?? ?? 0? 23 10 62 02 ?? ?? ?? 0? 21 10 53 00 1B 00 62 02 F4 01 40 00 ?? ?? ?? 0? 10 10 00 00 1B 00 62 02 F4 01 40 00 ?? ?? ?? 0? 12 10 00 00 ?? ?? ?? 0? 02 10 53 70 26 10 62 02 ?? ?? ?? 0? 2B 10 02 00 }
	condition:
		$1
}

rule file_215_1_0 {
	meta:
		name = "transcmp"
		size = 152
		refs = "0034 strcmp"
	strings:
		$1 = { 10 00 82 8C D8 FF BD 27 20 00 B1 AF 1C 00 B0 AF 24 00 BF AF 21 88 80 00 1D 00 40 10 21 80 A0 00 1C 00 84 24 10 00 02 8E 17 00 40 10 00 00 00 00 1C 00 05 26 ?? ?? ?? 0? 00 00 00 00 0E 00 40 14 24 00 BF 8F 00 00 24 8E ?? ?? ?? 0? 00 00 05 8E 09 00 40 14 24 00 BF 8F 08 00 24 8E ?? ?? ?? 0? 08 00 05 8E 04 00 40 14 24 00 BF 8F 04 00 23 8E 04 00 02 8E 23 10 62 00 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 1C 00 05 8E ?? ?? ?? 0? 1C 00 84 8C }
	condition:
		$1
}

rule file_215_2_0 {
	meta:
		name = "plural_lookup.isra.1"
		size = 156
		refs = "0048 __rawmemchr"
	strings:
		$1 = { D8 FF BD 27 18 00 B0 AF 21 80 80 00 60 00 84 8C 20 00 B2 AF 1C 00 B1 AF 21 90 C0 00 24 00 BF AF ?? ?? ?? 0? 21 88 E0 00 64 00 10 8E 21 18 40 00 21 10 40 02 2B 80 70 00 0A 18 10 00 21 80 60 00 ?? ?? ?? 0? 21 88 51 02 ?? ?? ?? 0? FF FF 10 26 01 00 42 24 2B 18 51 00 0A 00 60 10 24 00 BF 8F 21 20 40 00 F8 FF 00 16 21 28 00 00 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 21 10 40 02 1C 00 B1 8F 20 00 B2 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_215_3_0 {
	meta:
		name = "_nl_find_msg"
		size = 3080
		refs = "0008 __gnu_local_gp 0070 strlen 007c __hash_string 013c strcmp 01a0 __pthread_rwlock_unlock 01b8 free 0260 __pthread_rwlock_rdlock 0444 _nl_load_domain 047c _nl_current_LC_CTYPE 02d8 __pthread_rwlock_wrlock 05a8 getenv 05a4 $LC0 05ec malloc 0608 memcpy 0648 realloc 065c __strdup 0688 $LC1 06a0 _nl_find_msg 06c0 strstr 06b8 $LC2 073c mempcpy 078c _nl_C_locobj 085c __gconv_open 0958 __gconv 0ad0 $LC3 0b20 __lll_lock_wait_private 0bec calloc"
	strings:
		$1 = { 04 00 82 8C 88 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 70 00 BE AF 21 F0 A0 03 68 00 B6 AF 74 00 BF AF 6C 00 B7 AF 64 00 B5 AF 60 00 B4 AF 5C 00 B3 AF 58 00 B2 AF 54 00 B1 AF 50 00 B0 AF 18 00 DC AF 78 00 C4 AF 7C 00 C5 AF 21 B0 C0 00 FD 00 40 18 84 00 C7 AF 78 00 C2 8F 08 00 55 8C 59 00 A0 12 21 10 00 00 30 00 A2 8E AE 00 40 10 14 00 B1 8E ?? ?? ?? 0? 21 20 C0 02 21 20 C0 02 ?? ?? ?? 0? 21 B8 40 00 2C 00 AA 8E 18 00 DC 8F 34 00 A9 8E FE FF 46 25 1B 00 46 00 F4 01 C0 00 30 00 A7 8E 10 18 00 00 01 00 73 24 23 58 53 01 1B 00 4A 00 F4 01 40 01 23 A0 6A 02 10 90 00 00 80 10 12 00 21 10 E2 00 03 00 20 11 00 00 50 8C A0 80 10 7C 02 84 30 00 3A 00 00 12 FF FF 10 26 2B 10 11 02 23 00 40 10 23 18 11 02 18 00 A3 8E 0C 00 A4 8E C0 60 10 00 21 10 6C 00 03 00 80 10 00 00 42 8C A0 10 02 7C 02 14 22 00 2B 28 57 00 12 00 A0 14 21 10 00 00 21 18 6C 00 00 00 A5 8E 03 00 80 10 04 00 62 8C A0 10 02 7C 02 14 22 00 21 20 C0 02 21 28 A2 00 44 00 C7 AF 40 00 C9 AF ?? ?? ?? 0? 48 00 CB AF 18 00 DC 8F 48 00 CB 8F 40 00 C9 8F 44 00 C7 8F 01 00 42 2C 27 00 40 14 2B 18 4B 02 21 10 54 02 21 90 53 02 ?? ?? ?? 0? 0A 90 43 00 24 00 A2 8E C0 18 03 00 21 18 43 00 00 00 64 8C 2B 20 E4 02 F4 FF 80 10 21 10 00 00 04 00 65 8C ?? ?? ?? 0? 21 20 C0 02 5F 02 43 10 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 03 00 40 10 00 00 00 00 ?? ?? ?? 0? 40 00 A4 26 ?? ?? ?? 0? 21 20 80 02 21 10 00 00 21 E8 C0 03 74 00 BF 8F 70 00 BE 8F 6C 00 B7 8F 68 00 B6 8F 64 00 B5 8F 60 00 B4 8F 5C 00 B3 8F 58 00 B2 8F 54 00 B1 8F 50 00 B0 8F 08 00 E0 03 78 00 BD 27 2B 10 11 02 70 00 40 10 23 10 11 02 0C 00 A2 8E 00 00 A3 8E 85 00 40 10 1C 00 A4 8E C0 10 10 00 21 10 82 00 04 00 56 8C 00 00 57 8C A0 B0 16 7C 02 B4 36 00 21 B0 76 00 84 00 C3 8F A0 B8 17 7C 02 BC 37 00 38 00 D6 AF 68 00 60 10 01 00 F7 26 7C 00 C4 8F 83 00 80 10 ?? ?? 12 3C 08 00 94 8C 81 00 80 12 ?? ?? 42 8E ?? ?? 02 3C ?? ?? 42 24 03 00 40 10 00 00 00 00 ?? ?? ?? 0? 40 00 A4 26 3C 00 B6 8E 75 00 C0 12 80 20 16 00 00 11 16 00 38 00 B2 8E 23 10 44 00 F4 FF 42 24 ?? ?? ?? 0? 21 90 42 02 6D 00 C0 12 F4 FF 52 26 00 00 44 8E 21 28 80 02 ?? ?? ?? 0? FF FF D6 26 F9 FF 40 14 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 03 00 40 10 00 00 00 00 ?? ?? ?? 0? 40 00 A4 26 8C 00 40 12 ?? ?? 02 3C 04 00 43 8E FF FF 02 24 40 00 62 10 88 00 C2 8F 08 00 42 8E 19 02 40 10 ?? ?? 03 3C FF FF 03 24 80 00 43 10 80 18 10 00 21 10 43 00 00 00 42 8C 5C 01 40 10 ?? ?? 03 3C 00 00 57 8C 04 00 42 24 ?? ?? ?? 0? 38 00 C2 AF 21 A0 20 02 ?? ?? ?? 0? 21 98 00 00 04 00 85 8C 21 20 C0 02 44 00 C3 AF A0 28 05 7C 02 2C 25 00 ?? ?? ?? 0? 21 28 E5 02 18 00 DC 8F 16 00 40 04 44 00 C3 8F A7 FF 40 10 01 00 13 26 2B 10 74 02 97 FF 40 10 21 10 00 00 00 00 B7 8E 0C 00 B2 8E 18 00 A3 8E 21 80 93 02 42 80 10 00 C0 10 10 00 EA FF 40 16 21 20 62 00 04 00 85 8C 21 20 C0 02 44 00 C3 AF ?? ?? ?? 0? 21 28 E5 02 18 00 DC 8F EC FF 41 04 44 00 C3 8F 2B 10 70 02 83 FF 40 10 21 A0 00 02 ?? ?? ?? 0? 21 80 93 02 28 00 A3 8E C0 10 02 00 21 10 62 00 04 00 43 8C 00 00 57 8C 38 00 C3 AF 84 00 C3 8F 9B FF 60 14 7C 00 C4 8F 88 00 C2 8F 00 00 57 AC 21 E8 C0 03 74 00 BF 8F 38 00 C2 8F 6C 00 B7 8F 70 00 BE 8F 68 00 B6 8F 64 00 B5 8F 60 00 B4 8F 5C 00 B3 8F 58 00 B2 8F 54 00 B1 8F 50 00 B0 8F 08 00 E0 03 78 00 BD 27 C0 10 10 00 21 10 82 00 04 00 56 8C 00 00 57 8C 21 B0 76 00 38 00 D6 AF ?? ?? ?? 0? 01 00 F7 26 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 78 00 C2 8F ?? ?? ?? 0? 21 90 00 00 ?? ?? 42 8E 50 00 40 10 ?? ?? 02 3C ?? ?? 54 8C 7D FF 80 16 ?? ?? 02 3C 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 42 8C 00 00 42 8C ?? ?? ?? 0? 5C 00 54 8C 00 00 83 8E ?? ?? 02 3C 21 20 80 02 ?? ?? ?? 0? ?? ?? 43 AC 30 00 C3 8F ?? ?? 02 3C ?? ?? 40 AC ?? ?? 64 24 ?? ?? 20 AE 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 09 00 40 14 30 00 C3 8F ?? ?? 64 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? FF FF 02 24 ?? ?? 42 24 03 00 40 10 00 00 00 00 ?? ?? ?? 0? 40 00 A4 26 3C 00 A3 8E 41 00 60 10 34 00 C3 AF 38 00 A3 8E 34 00 C6 8F 3C 00 C3 AF 34 00 C3 8F 3C 00 C4 8F 80 10 03 00 00 19 03 00 23 18 62 00 F4 FF 63 24 ?? ?? ?? 0? 21 18 83 00 36 00 C0 10 F4 FF 63 24 00 00 64 8C FF FF C6 24 21 28 80 02 44 00 C3 AF ?? ?? ?? 0? 40 00 C6 AF 44 00 C3 8F 40 00 C6 8F F5 FF 40 14 21 90 60 00 ?? ?? 03 3C ?? ?? 63 24 53 FF 60 10 00 00 00 00 ?? ?? ?? 0? 40 00 A4 26 ?? ?? ?? 0? 04 00 43 8E ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 21 28 40 00 04 00 40 10 18 00 DC 8F 00 00 42 80 06 00 40 14 00 00 00 00 ?? ?? 02 3C ?? ?? 54 8C 01 00 02 24 ?? ?? ?? 0? ?? ?? 42 AE 21 20 A0 00 ?? ?? ?? 0? 40 00 C5 AF 01 00 56 24 ?? ?? ?? 0? 21 20 C0 02 21 A0 40 00 18 00 DC 8F 05 00 40 10 40 00 C5 8F 21 20 40 00 ?? ?? ?? 0? 21 30 C0 02 18 00 DC 8F ?? ?? 02 3C ?? ?? 54 AC 01 00 02 24 ?? ?? ?? 0? ?? ?? 42 AE 38 00 A3 8E 3C 00 C3 AF 34 00 C3 8F 3C 00 C4 8F 01 00 62 24 80 18 02 00 00 11 02 00 23 90 43 00 ?? ?? ?? 0? 21 28 40 02 39 01 40 10 21 20 80 02 38 00 A2 AE ?? ?? ?? 0? 44 00 C2 AF 21 A0 40 00 33 01 40 10 44 00 C3 8F F4 FF 52 26 21 90 72 00 78 00 C4 8F 7C 00 C5 8F FF FF 03 24 00 00 42 AE ?? ?? 06 3C 20 00 C2 27 04 00 43 AE ?? ?? C6 24 10 00 A2 AF 21 38 00 00 ?? ?? ?? 0? 44 00 C3 AF 44 00 C3 8F 94 FF 43 10 00 00 00 00 6D 00 40 10 ?? ?? 05 3C 21 20 40 00 ?? ?? ?? 0? ?? ?? A5 24 68 00 40 10 DF FF 04 24 08 00 43 80 24 20 64 00 15 01 80 10 08 00 45 24 F7 FF 63 24 FF 00 63 30 02 00 63 2C 0E 00 60 14 21 30 00 00 ?? ?? ?? 0? 20 00 07 24 0A 00 67 10 00 00 00 00 08 00 80 14 00 00 00 00 01 00 C6 24 21 18 46 00 08 00 63 80 F7 FF 64 24 FF 00 84 30 F6 FF 60 14 02 00 84 2C 0F 00 C2 24 C2 10 02 00 C0 10 02 00 23 E8 A2 03 18 00 B3 27 ?? ?? ?? 0? 21 20 60 02 00 00 40 A0 21 10 80 02 ?? ?? ?? 0? 21 30 00 00 01 00 42 24 21 30 C4 00 00 00 43 80 2F 00 64 38 FB FF 60 14 01 00 84 2C 23 10 54 00 19 00 42 24 C2 10 02 00 00 00 83 82 C0 10 02 00 23 E8 A2 03 D0 00 60 10 18 00 B6 27 ?? ?? 02 3C ?? ?? 44 8C 21 28 80 02 21 10 C0 02 80 18 03 00 21 18 83 00 00 00 63 8C 01 00 42 24 01 00 A5 24 FF FF 43 A0 00 00 A3 80 F9 FF 60 14 80 18 03 00 02 00 C3 2C B3 00 60 14 2F 00 03 24 00 00 40 A0 21 30 00 00 ?? ?? ?? 0? 21 10 60 02 01 00 42 24 21 30 C5 00 00 00 43 80 2F 00 65 38 FB FF 60 14 01 00 A5 2C 23 10 53 00 11 00 42 24 C2 10 02 00 00 00 63 82 C0 10 02 00 23 E8 A2 03 AC 00 60 10 18 00 A5 27 ?? ?? 02 3C ?? ?? 44 8C 21 10 A0 00 80 18 03 00 21 18 83 00 00 00 63 8C 01 00 42 24 01 00 73 26 FF FF 43 A0 00 00 63 82 F9 FF 60 14 80 18 03 00 02 00 C3 2C 96 00 60 14 2F 00 03 24 21 20 C0 02 04 00 46 26 01 00 07 24 ?? ?? ?? 0? 00 00 40 A0 4C FE 40 14 FF FF 03 24 3C 00 A2 8E 08 00 40 AE 01 00 42 24 ?? ?? ?? 0? 3C 00 A2 AE ?? ?? 64 24 30 00 C3 AF 00 00 82 C0 01 00 41 24 00 00 81 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 9F 00 40 14 00 00 00 00 ?? ?? 03 3C ?? ?? 62 8C ?? ?? 11 3C ?? ?? 26 8E 38 00 C4 8F 04 00 42 24 24 00 C2 AF 04 00 C2 2C 28 00 C4 AF 21 A8 00 00 17 00 40 10 ?? ?? 13 3C 2A 00 A0 12 F0 0F 02 24 01 00 B5 26 ?? ?? 74 8E 00 11 15 00 00 33 15 00 23 B0 C2 00 21 20 80 02 21 28 C0 02 ?? ?? ?? 0? ?? ?? 36 AE E3 FE 40 10 FC FF C6 26 ?? ?? 62 AE 04 00 44 24 08 00 42 24 ?? ?? 03 3C 24 00 C2 AF 04 00 C2 2C ?? ?? 64 AC EB FF 40 14 ?? ?? 26 AE 24 00 C2 8F FC FF C6 24 04 00 44 8E 21 10 46 00 28 00 C6 8F 10 00 A2 AF 20 00 C2 27 28 00 C5 27 21 30 D7 00 24 00 C7 27 ?? ?? ?? 0? 14 00 A2 AF FB FF 03 24 24 20 43 00 10 00 80 10 05 00 04 24 32 00 44 14 38 00 C4 8F D9 FF A0 16 28 00 C4 AF F0 0F 02 24 F0 0F 04 24 ?? ?? ?? 0? ?? ?? 22 AE C5 FE 40 10 ?? ?? 63 8E EC 0F 06 24 ?? ?? 62 AE 00 00 43 AC ?? ?? ?? 0? 01 00 15 24 ?? ?? 04 3C ?? ?? 82 8C 24 00 C4 8F 08 00 43 8E 80 80 10 00 23 20 82 00 21 18 70 00 FC FF 84 24 00 00 44 AC 00 00 62 AC 24 00 C3 8F ?? ?? 24 8E 23 10 43 00 21 10 44 00 03 00 44 30 21 18 64 00 FC FF 04 24 24 10 44 00 ?? ?? 04 3C ?? ?? 83 AC 30 00 C3 8F ?? ?? 22 AE ?? ?? 64 24 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 32 00 40 10 00 00 00 00 08 00 42 8E 21 80 50 00 ?? ?? ?? 0? 00 00 02 8E 30 00 C4 8F ?? ?? 82 24 0F 00 00 00 00 00 43 C0 00 00 01 24 00 00 41 E0 FC FF 20 10 00 00 00 00 02 00 63 28 D8 FD 60 14 21 10 00 00 30 00 C3 8F ?? ?? 64 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 21 10 00 00 0E 00 C0 10 00 00 43 A0 ?? ?? ?? 0? 01 00 42 24 04 00 C0 14 00 00 43 A0 01 00 43 A0 ?? ?? ?? 0? 02 00 42 24 ?? ?? ?? 0? 01 00 42 24 ?? ?? ?? 0? 21 10 A0 00 ?? ?? ?? 0? 21 10 C0 02 ?? ?? 05 3C 01 00 43 A0 02 00 44 24 ?? ?? A5 24 ?? ?? ?? 0? 08 00 06 24 ?? ?? ?? 0? 00 00 40 A0 ?? ?? 64 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 08 00 42 8E ?? ?? ?? 0? 04 00 42 AE ?? ?? ?? 0? ?? ?? 64 24 ?? ?? ?? 0? ?? ?? 03 3C ?? ?? ?? 0? 21 30 00 00 ?? ?? 04 3C ?? ?? 84 24 6F FE 80 10 00 00 00 00 ?? ?? ?? 0? 40 00 A4 26 ?? ?? ?? 0? FF FF 02 24 ?? ?? 64 24 30 00 C3 AF 00 00 82 C0 01 00 41 24 00 00 81 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 03 00 40 10 00 00 00 00 ?? ?? ?? 0? ?? ?? 64 24 08 00 42 8E 16 00 40 10 04 00 05 24 30 00 C3 8F ?? ?? 64 24 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 09 00 40 14 30 00 C3 8F ?? ?? 64 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 08 00 42 8E 20 00 A4 8E ?? ?? ?? 0? 21 20 24 02 2C FF 40 14 08 00 42 AE FF FF 02 24 ?? ?? ?? 0? 08 00 42 AE }
	condition:
		$1
}

rule file_215_4_0 {
	meta:
		name = "__dcigettext"
		size = 2024
		refs = "03c4 __pthread_rwlock_unlock 0004 __gnu_local_gp 0064 __pthread_rwlock_rdlock 0070 __libc_setlocale_lock 007c _nl_state_lock 00a8 __current_locale_name 00b4 strlen 00d4 memcpy 0104 __tfind 0138 _nl_msg_cat_cntr 0150 __libc_errno 015c _nl_domain_bindings 0194 _nl_default_dirname 019c strcmp 0210 __getcwd 022c __rawmemchr 0244 strcpy 0250 _nl_category_name_idxs 0260 $LC4 0264 _nl_category_names 0270 getenv 02ec stpcpy 0308 mempcpy 0310 $LC5 0368 $LC6 0388 _nl_find_domain 03ac _nl_find_msg 0544 __libc_enable_secure 0558 strchr 0090 _nl_current_default_domain 06d4 malloc 074c __pthread_rwlock_wrlock 078c __tsearch 07d0 free"
	strings:
		$1 = { 70 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 88 00 BE AF 21 F0 A0 03 74 00 B3 AF 8C 00 BF AF 84 00 B7 AF 80 00 B6 AF 7C 00 B5 AF 78 00 B4 AF 70 00 B2 AF 6C 00 B1 AF 68 00 B0 AF 18 00 DC AF 21 98 A0 00 90 00 C4 AF 98 00 C6 AF 96 01 A0 10 9C 00 C7 AF A4 00 C3 8F 0D 00 62 2C FF 00 40 10 06 00 02 24 FD 00 62 10 ?? ?? 10 3C ?? ?? 10 26 06 00 00 12 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 90 00 C5 8F 72 01 A0 10 ?? ?? 02 3C A4 00 C4 8F 90 00 C2 8F 30 00 C0 AF 24 00 C4 AF 3C 00 D3 AF ?? ?? ?? 0? 20 00 C2 AF 21 20 40 00 ?? ?? ?? 0? 21 88 40 00 0F 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 A4 27 21 28 20 02 ?? ?? ?? 0? 01 00 46 24 58 00 C2 AF 04 00 00 12 28 00 C2 AF ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? 02 3C ?? ?? 03 3C ?? ?? 45 24 20 00 C4 27 ?? ?? ?? 0? ?? ?? 66 24 ?? ?? 05 3C ?? ?? A5 24 18 00 DC 8F 05 00 A0 10 50 00 C2 AF ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 18 00 DC 8F 50 00 C2 8F 06 00 40 10 ?? ?? 03 3C 00 00 42 8C ?? ?? 63 8C 0C 00 44 8C 34 01 83 10 9C 00 C3 8F ?? ?? 82 8F 3B E8 03 7C 54 00 C2 AF ?? ?? 02 3C ?? ?? 51 8C 21 10 60 00 54 00 C3 8F 21 10 62 00 00 00 42 8C 21 01 20 12 60 00 C2 AF ?? ?? ?? 0? 90 00 D0 8F 21 01 40 04 ?? ?? 15 3C 00 00 31 8E 1C 01 20 12 ?? ?? B5 26 0C 00 25 26 ?? ?? ?? 0? 21 20 00 02 F7 FF 40 14 00 00 00 00 04 00 23 8E 2F 00 02 24 48 00 C3 AF 00 00 63 80 23 00 62 10 48 00 C4 8F 02 10 14 24 ?? ?? ?? 0? 22 00 12 24 54 00 C5 8F 3B E8 03 7C 01 00 50 24 ?? ?? ?? 0? 21 B0 A3 00 00 00 C2 8E AE 00 52 14 21 A0 83 02 21 10 90 02 0E 00 42 24 C2 10 02 00 C0 10 02 00 23 E8 A2 03 18 00 B5 27 21 28 80 02 21 20 A0 02 ?? ?? ?? 0? 00 00 C0 AE 42 18 14 00 F1 FF 40 10 20 00 63 24 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 48 00 D5 AF 2F 00 03 24 00 00 43 A0 01 00 40 A0 04 00 25 8E ?? ?? ?? 0? 01 00 44 24 A4 00 C3 8F ?? ?? 02 3C ?? ?? 42 24 21 10 62 00 00 00 42 90 ?? ?? 04 3C ?? ?? 10 3C ?? ?? 84 24 ?? ?? 10 26 ?? ?? ?? 0? 21 80 02 02 DC 00 40 10 21 90 40 00 00 00 42 80 D9 00 40 10 00 00 00 00 ?? ?? ?? 0? A4 00 C4 8F 00 00 43 90 21 B8 40 00 43 00 02 24 F0 00 62 14 00 00 00 00 01 00 E2 92 0B B8 42 02 ?? ?? ?? 0? 90 00 C4 8F 21 20 00 02 ?? ?? ?? 0? 5C 00 C2 AF 5C 00 C3 8F 21 28 00 02 3A 00 10 24 21 10 62 00 13 00 42 24 C2 10 02 00 C0 10 02 00 23 E8 A2 03 18 00 A3 27 21 20 60 00 ?? ?? ?? 0? 4C 00 C3 AF 90 00 C5 8F 5C 00 C6 8F 2F 00 03 24 01 00 44 24 00 00 43 A0 ?? ?? ?? 0? 01 00 40 A0 ?? ?? 03 3C ?? ?? 63 8C 21 20 E0 02 03 00 43 A8 ?? ?? ?? 0? 00 00 43 B8 0F 00 42 24 C2 10 02 00 C0 10 02 00 23 E8 A2 03 18 00 B2 27 00 00 E2 82 8F 00 50 10 00 00 00 00 79 00 40 14 21 18 40 02 43 00 02 24 00 00 42 A2 01 00 40 A2 01 00 42 92 51 00 40 10 ?? ?? 02 3C ?? ?? 05 3C 21 20 40 02 ?? ?? ?? 0? ?? ?? A5 24 4A 00 40 10 48 00 C4 8F 4C 00 C6 8F 21 28 40 02 ?? ?? ?? 0? 21 38 20 02 EA FF 40 10 21 A0 40 00 40 00 C3 27 10 00 A3 AF 21 20 40 00 21 28 20 02 21 30 60 02 ?? ?? ?? 0? 01 00 07 24 74 00 40 10 21 48 40 00 FF FF 02 24 39 00 22 11 ?? ?? 02 3C 50 00 C5 8F B7 00 A0 10 50 00 C3 8F 50 00 C5 8F 00 00 62 8C ?? ?? 03 3C ?? ?? 64 8C 10 00 54 AC 00 00 A3 8C 0C 00 44 AC 14 00 69 AC 00 00 A2 8C 40 00 C3 8F 18 00 43 AC 3B E8 03 7C 21 10 60 00 54 00 C3 8F 60 00 C5 8F 21 10 62 00 00 00 45 AC 9C 00 C2 8F 93 00 40 14 A0 00 C5 8F ?? ?? 03 3C ?? ?? 63 24 EC 00 60 10 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 64 00 C9 AF ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 64 00 C9 8F ?? ?? ?? 0? 21 10 20 01 9C 00 C5 8F 24 00 A0 10 A0 00 C3 8F 01 00 02 24 21 00 62 10 98 00 C2 8F 21 E8 C0 03 8C 00 BF 8F 88 00 BE 8F 84 00 B7 8F 80 00 B6 8F 7C 00 B5 8F 78 00 B4 8F 74 00 B3 8F 70 00 B2 8F 6C 00 B1 8F 68 00 B0 8F 08 00 E0 03 90 00 BD 27 ?? ?? 02 3C ?? ?? 42 24 07 00 40 10 00 00 00 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 3B E8 03 7C 21 10 60 00 54 00 C3 8F 60 00 C5 8F 21 10 62 00 00 00 45 AC 9C 00 C2 8F DE FF 40 14 A0 00 C3 8F 21 E8 C0 03 8C 00 DF 8F 21 10 60 02 88 00 BE 8F 84 00 B7 8F 80 00 B6 8F 7C 00 B5 8F 78 00 B4 8F 74 00 B3 8F 70 00 B2 8F 6C 00 B1 8F 68 00 B0 8F 08 00 E0 03 90 00 BD 27 07 00 50 10 00 00 00 00 01 00 63 24 FF FF 62 A0 01 00 F7 26 00 00 E2 82 F9 FF 40 14 ?? ?? 05 3C ?? ?? A2 8C 06 00 40 10 00 00 60 A0 21 20 40 02 ?? ?? ?? 0? 2F 00 05 24 76 FF 40 14 00 00 00 00 00 00 43 92 43 00 02 24 7D FF 62 14 00 00 00 00 ?? ?? ?? 0? 01 00 42 92 ?? ?? ?? 0? 01 00 F7 26 10 00 84 8E 6B FF 80 10 00 00 00 00 21 B0 80 02 ?? ?? ?? 0? 21 A8 00 00 10 00 C4 8E 65 FF 80 10 01 00 B5 26 40 00 C5 27 10 00 A5 AF 21 30 60 02 21 28 20 02 ?? ?? ?? 0? 01 00 07 24 FF FF 03 24 B6 FF 43 10 04 00 D6 26 F3 FF 40 10 21 48 40 00 04 00 A2 26 80 10 02 00 21 A0 82 02 ?? ?? ?? 0? 00 00 94 8E ?? ?? ?? 0? A4 00 C4 8F ?? ?? ?? 0? 21 B8 40 00 ?? ?? 15 3C ?? ?? B5 26 ?? ?? ?? 0? 48 00 D5 AF ?? ?? B5 26 21 88 00 00 ?? ?? ?? 0? 48 00 D5 AF 19 00 60 14 00 00 00 00 14 00 53 8C ?? ?? 05 3C ?? ?? A5 24 AF FF A0 10 00 00 00 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? ?? 0? 21 10 60 02 ?? ?? 42 8C ?? ?? ?? 0? 90 00 C2 AF ?? ?? ?? 0? 21 B8 40 02 08 00 84 8E 40 00 C7 8F ?? ?? ?? 0? 21 30 20 01 ?? ?? ?? 0? 21 48 40 00 10 00 43 8C 14 00 46 8C 18 00 47 8C 08 00 64 8C ?? ?? ?? 0? A0 00 C5 8F ?? ?? ?? 0? 21 98 40 00 ?? ?? ?? 0? 21 10 00 00 21 20 60 02 ?? ?? ?? 0? 64 00 C9 AF 58 00 C4 8F ?? ?? ?? 0? 01 00 51 24 5C 00 C3 8F 21 80 40 00 1E 00 64 24 21 20 82 00 ?? ?? ?? 0? 21 20 91 00 21 90 40 00 47 FF 40 10 64 00 C9 8F 21 28 60 02 21 30 20 02 ?? ?? ?? 0? 1C 00 44 24 5C 00 C3 8F 90 00 C5 8F 21 20 40 00 01 00 71 24 21 30 20 02 21 98 40 00 ?? ?? ?? 0? 21 88 51 00 58 00 C5 8F 21 20 20 02 ?? ?? ?? 0? 01 00 06 26 ?? ?? 02 3C ?? ?? 42 8C 64 00 C9 8F A4 00 C5 8F 0C 00 42 AE 40 00 C2 8F 00 00 53 AE 04 00 45 AE 18 00 42 AE ?? ?? 02 3C ?? ?? 42 24 08 00 51 AE 10 00 54 AE 06 00 40 10 14 00 49 AE ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 64 00 C9 AF 64 00 C9 8F ?? ?? 02 3C ?? ?? 03 3C ?? ?? 45 24 21 20 40 02 ?? ?? 66 24 ?? ?? ?? 0? 64 00 C9 AF ?? ?? 05 3C ?? ?? A5 24 21 80 40 00 05 00 A0 10 64 00 C9 8F ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 64 00 C9 8F 04 00 00 12 00 00 00 00 00 00 02 8E 0E FF 42 12 00 00 00 00 21 20 40 02 ?? ?? ?? 0? 64 00 C9 AF ?? ?? ?? 0? 64 00 C9 8F ?? ?? ?? 0? 21 10 20 01 }
	condition:
		$1
}

rule file_215_5_0 {
	meta:
		name = "free_mem"
		size = 208
		refs = "0008 _nl_domain_bindings 0020 _nl_default_dirname 0038 free 005c _nl_current_default_domain 0064 _nl_default_default_domain 0088 __tdestroy"
	strings:
		$1 = { D8 FF BD 27 1C 00 B1 AF ?? ?? 11 3C 18 00 B0 AF ?? ?? 30 8E 24 00 BF AF 10 00 00 12 20 00 B2 AF ?? ?? 12 3C ?? ?? 52 26 00 00 02 8E 04 00 04 8E 03 00 92 10 ?? ?? 22 AE ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 08 00 04 8E ?? ?? ?? 0? 21 20 00 02 ?? ?? 30 8E F4 FF 00 16 00 00 00 00 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 02 3C ?? ?? 42 24 03 00 82 10 ?? ?? 10 3C ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 8E ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? ?? ?? 11 3C ?? ?? 24 8E 03 00 80 14 ?? ?? 00 AE ?? ?? ?? 0? 24 00 BF 8F 00 00 90 8C ?? ?? ?? 0? ?? ?? 30 AE FC FF 00 16 21 20 00 02 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_217_0_0 {
	meta:
		name = "__gconv"
		size = 680
		refs = "00e0 _dl_mcount_wrapper_check 0268 $LC2 026c $LC1 0280 __assert_fail 0270 __PRETTY_FUNCTION__.8309 0288 $LC0"
	strings:
		$1 = { A8 FF BD 27 FF FF 02 24 40 00 B4 AF 30 00 B0 AF 54 00 BF AF 50 00 BE AF 4C 00 B7 AF 48 00 B6 AF 44 00 B5 AF 3C 00 B3 AF 38 00 B2 AF 34 00 B1 AF 21 80 80 00 4E 00 82 10 6C 00 B4 8F 00 00 95 8C 91 00 80 12 FF FF B5 26 21 88 A0 00 21 98 C0 00 21 B8 E0 00 80 00 E0 10 00 00 80 AE 00 00 E4 8C 80 18 15 00 28 00 A3 AF 28 00 A5 8F 40 C9 15 00 04 00 03 8E 21 10 B9 00 21 10 02 02 08 00 44 AC 68 00 A4 8F 2C 00 B9 AF 14 00 72 8C 46 00 20 12 0C 00 44 AC 00 00 3E 8E 43 00 C0 13 00 00 00 00 71 00 E0 12 08 00 16 26 00 00 E2 8E 0C 00 40 14 04 00 15 24 ?? ?? ?? 0? ?? ?? 04 3C 00 00 23 8E 15 00 7E 10 00 00 00 00 04 00 04 8E 24 00 84 8C 21 20 64 00 2B 20 64 02 0F 00 80 14 21 F0 60 00 ?? ?? ?? 0? 21 20 40 02 04 00 04 8E 21 28 C0 02 10 00 A0 AF 14 00 B4 AF 18 00 A0 AF 1C 00 A0 AF 21 30 20 02 21 C8 40 02 09 F8 20 03 21 38 60 02 EA FF 55 10 00 00 00 00 00 00 E3 8E 50 00 60 10 2C 00 B9 8F 28 00 A3 8F 21 F0 79 00 21 80 1E 02 08 00 04 8E 21 18 40 00 00 00 E4 AE 54 00 BF 8F 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 21 10 60 00 08 00 E0 03 58 00 BD 27 54 00 BF 8F 08 00 03 24 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 21 10 60 00 08 00 E0 03 58 00 BD 27 ?? ?? ?? 0? 21 20 40 02 28 00 B9 8F 2C 00 A3 8F 04 00 04 8E 21 30 00 00 21 10 23 03 21 10 02 02 08 00 45 8C 01 00 03 24 02 00 02 24 0B 10 65 00 10 00 A0 AF 14 00 B4 AF 18 00 A2 AF 1C 00 A0 AF 08 00 05 26 21 C8 40 02 09 F8 20 03 21 38 00 00 08 00 40 14 00 00 00 00 21 20 00 02 21 18 00 00 01 00 63 24 2B 28 A3 02 14 00 80 AC FC FF A0 10 24 00 84 24 BE FF E0 16 21 18 40 00 54 00 BF 8F 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 21 10 60 00 08 00 E0 03 58 00 BD 27 ?? ?? ?? 0? 21 20 00 00 ?? ?? ?? 0? 21 18 40 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 4A 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 2C 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "_IO_getdelim"
		size = 904
		refs = "0000 __gnu_local_gp 00ec malloc 0128 realloc 014c memcpy 0164 __underflow 018c memchr 0244 __lll_lock_wait_private 02d8 __libc_errno 0334 _Unwind_Resume"
	strings:
		$1 = { ?? ?? 1C 3C B8 FF BD 27 ?? ?? 9C 27 30 00 B4 AF 44 00 BF AF 40 00 BE AF 3C 00 B7 AF 38 00 B6 AF 34 00 B5 AF 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 10 00 BC AF 21 A0 80 00 A4 00 80 10 50 00 A6 AF A2 00 A0 10 21 A8 A0 00 00 00 E2 8C 21 88 E0 00 00 80 44 30 1A 00 80 14 21 18 40 00 3B E8 03 7C 48 00 E4 8C 70 8B 70 24 08 00 83 8C 10 00 70 10 00 00 00 00 18 00 A0 AF 00 00 83 C0 06 00 60 14 00 00 02 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 02 24 0F 00 00 00 69 00 40 10 00 00 00 00 48 00 23 8E 00 00 22 8E 21 20 60 00 08 00 70 AC 04 00 85 8C 21 18 40 00 01 00 A5 24 04 00 85 AC 20 00 42 30 45 00 40 14 FF FF 13 24 00 00 82 8E 04 00 40 10 78 00 02 24 00 00 A2 8E 06 00 40 14 78 00 02 24 00 00 A2 AE ?? ?? ?? 0? 78 00 04 24 73 00 40 10 00 00 82 AE 04 00 32 8E 08 00 30 8E 23 80 12 02 65 00 00 1A 00 00 00 00 ?? ?? ?? 0? 21 F0 00 00 2B 30 45 00 21 B0 A0 00 00 00 84 8E 0A B0 46 00 ?? ?? ?? 0? 21 28 C0 02 64 00 40 10 21 20 40 00 00 00 82 AE 04 00 32 8E 00 00 B6 AE 21 30 00 02 21 20 9E 00 ?? ?? ?? 0? 21 28 40 02 04 00 22 8E 21 80 50 00 34 00 E0 16 04 00 30 AE ?? ?? ?? 0? 21 20 20 02 FF FF 03 24 2F 00 43 10 21 F0 60 02 04 00 32 8E 08 00 30 8E 23 80 12 02 50 00 A5 8F 21 20 40 02 ?? ?? ?? 0? 21 30 00 02 21 B8 40 00 03 00 40 10 10 00 BC 8F 23 80 52 00 01 00 10 26 FF 7F 03 3C FF FF 63 34 23 10 7E 00 2A 10 02 02 4D 00 40 10 FF FF 13 24 00 00 A4 8E 21 98 D0 03 01 00 62 26 2B 28 82 00 D1 FF A0 14 40 28 04 00 ?? ?? ?? 0? 00 00 84 8E 00 80 63 30 06 00 60 14 21 10 60 02 48 00 24 8E 04 00 83 8C FF FF 63 24 16 00 60 10 04 00 83 AC 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 00 00 82 8E 21 10 53 00 00 00 40 A0 ?? ?? ?? 0? 00 00 23 8E ?? ?? ?? 0? 18 00 A3 AF ?? ?? ?? 0? 48 00 23 8E 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 E2 FF 60 14 21 10 60 02 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 21 10 60 02 ?? ?? ?? 0? 21 20 20 02 FF FF 03 24 05 00 43 10 00 00 00 00 04 00 32 8E 08 00 30 8E ?? ?? ?? 0? 23 80 12 02 00 00 23 8E ?? ?? ?? 0? FF FF 13 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 4F 00 03 24 00 00 43 AC ?? ?? ?? 0? 00 00 23 8E 00 00 22 8E 00 80 42 30 06 00 40 14 21 80 80 00 48 00 24 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 00 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "check_match.9290"
		size = 512
		refs = "0064 strcmp 01d0 _dl_name_match_p 01e0 $LC0 01e4 $LC1 01f8 __assert_fail 01e8 __PRETTY_FUNCTION__.9293"
	strings:
		$1 = { D0 FF BD 27 20 00 B1 AF 1C 00 B0 AF 2C 00 BF AF 28 00 B3 AF 24 00 B2 AF 0C 00 83 90 04 00 82 8C 21 80 80 00 21 88 E0 01 61 00 40 10 0F 00 63 30 0E 00 02 96 30 00 40 10 67 04 02 24 07 18 62 00 01 00 63 30 35 00 60 10 21 10 00 00 20 00 22 8E 08 00 02 12 00 00 00 00 1C 00 24 8E 00 00 02 8E 18 00 25 8E ?? ?? ?? 0? 21 20 82 00 2A 00 40 14 00 00 00 00 14 00 25 8E 10 00 32 8E 35 00 40 12 78 02 A2 8C 4F 00 40 10 00 00 00 00 0C 00 26 8E 44 02 A4 8C 04 00 43 8E 40 28 06 00 21 10 45 00 00 00 53 94 FF 7F 62 32 00 11 02 00 21 10 82 00 04 00 51 8C 20 00 23 12 00 00 00 00 08 00 42 8E 15 00 40 14 00 00 00 00 13 00 20 16 20 9E 13 7C 12 00 60 06 21 10 00 00 21 10 00 02 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 0D 00 02 92 08 00 42 30 06 00 40 10 21 10 00 00 24 00 22 8E 01 00 42 30 CA FF 40 10 67 04 02 24 21 10 00 00 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 00 00 44 8C ?? ?? ?? 0? 00 00 45 8E E4 FF 40 10 00 00 00 00 ?? ?? ?? 0? 08 00 42 8E E0 FF 40 10 03 00 05 24 0C 00 23 8E 08 00 26 8E 40 18 03 00 21 10 43 00 00 00 43 94 02 00 C6 30 02 00 02 24 FF 7F 64 30 0A 10 A6 00 2A 10 82 00 D5 FF 40 14 21 10 00 02 20 1E 03 7C E2 FF 60 04 21 10 00 00 04 00 22 8E 01 00 43 24 DD FF 40 14 04 00 23 AE ?? ?? ?? 0? 00 00 30 AE 06 00 02 24 9E FF 62 10 21 10 00 00 ?? ?? ?? 0? 2C 00 BF 8F 0C 00 44 8E C4 FF 80 10 21 10 00 02 ?? ?? ?? 0? 00 00 00 00 C0 FF 40 10 21 10 00 02 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 B9 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_219_1_0 {
	meta:
		name = "do_lookup_x"
		size = 2380
		refs = "0068 $LC3 0078 _dl_debug_mask 0180 _dl_name_match_p 0284 _dl_ns 02ac __pthread_mutex_lock 0348 strcmp 0378 __pthread_mutex_unlock 007c _dl_dynamic_weak 0474 _dl_higher_prime_number 0484 calloc 0544 free 0088 _dl_argv 008c $LC2 06e4 _dl_debug_printf 0878 _dl_dprintf 0870 $LC4 0880 _exit"
	strings:
		$1 = { 70 FF BD 27 AC 00 A3 8F A4 00 A2 8F 80 00 B6 AF 28 00 A3 AF B0 00 A3 8F 7C 00 B5 AF 78 00 B4 AF 20 00 A3 AF B8 00 A3 8F 68 00 B0 AF 8C 00 BF AF 88 00 BE AF 84 00 B7 AF 74 00 B3 AF 70 00 B2 AF 6C 00 B1 AF 04 00 54 8C 21 B0 A0 00 21 50 C0 00 A8 00 B0 8F B4 00 B5 8F 30 00 A4 AF 38 00 A7 AF 3C 00 A3 AF 00 00 51 8C ?? ?? 0D 3C 80 10 10 00 42 41 05 00 21 88 22 02 ?? ?? 17 3C ?? ?? 09 3C 1F 00 BE 30 ?? ?? AD 25 ?? ?? 0C 3C ?? ?? 12 3C 00 00 22 8E 1C 00 A0 AF 18 00 A0 AF 14 00 42 8C 3F 00 55 10 2C 00 A2 AF 3C 00 A3 8F 02 00 63 30 4C 00 60 14 00 00 00 00 68 02 43 8C 00 20 63 30 37 00 60 14 ?? ?? E3 8E 08 00 63 30 77 01 60 14 00 00 00 00 4C 02 43 8C 31 00 60 10 00 00 00 00 34 00 46 8C 38 00 44 8C 00 00 45 8C 04 00 C6 8C 04 00 87 8C 58 02 44 8C 21 30 C5 00 34 00 A6 AF 81 01 80 10 21 28 A7 00 50 02 47 8C 54 02 46 8C 24 38 07 01 80 38 07 00 21 20 87 00 00 00 84 8C 06 30 D6 00 06 30 C4 00 06 20 C4 03 24 20 C4 00 01 00 84 30 D6 01 80 14 00 00 00 00 24 00 A0 AF 1C 00 A3 8F 01 00 02 24 30 00 62 10 18 00 B3 8F 24 00 A2 8F 12 00 40 14 28 00 A2 8F 10 00 40 10 00 00 00 00 0C 00 44 8C 0D 00 80 10 2C 00 A5 8F 54 00 A8 AF 5C 00 A9 AF 58 00 AA AF 64 00 AC AF ?? ?? ?? 0? 60 00 AD AF 54 00 A8 8F 5C 00 A9 8F 58 00 AA 8F 64 00 AC 8F AD 01 40 14 60 00 AD 8F 01 00 10 26 2B 10 14 02 B9 FF 40 14 04 00 31 26 8C 00 BF 8F 88 00 BE 8F 84 00 B7 8F 80 00 B6 8F 7C 00 B5 8F 78 00 B4 8F 74 00 B3 8F 70 00 B2 8F 6C 00 B1 8F 68 00 B0 8F 21 10 00 00 08 00 E0 03 90 00 BD 27 68 02 43 8C 03 00 64 30 B3 FF 80 14 00 00 00 00 01 00 10 26 2B 10 14 02 A4 FF 40 14 04 00 31 26 ?? ?? ?? 0? 8C 00 BF 8F D1 FF 60 12 24 00 A2 8F 0C 00 62 92 02 00 03 24 02 11 02 00 5D 00 43 10 0A 00 03 24 15 00 43 10 01 00 03 24 C8 FF 43 14 24 00 A2 8F A0 00 A3 8F A0 00 A4 8F 01 00 02 24 00 00 73 AC 2C 00 A3 8F 04 00 83 AC 8C 00 BF 8F 88 00 BE 8F 84 00 B7 8F 80 00 B6 8F 7C 00 B5 8F 78 00 B4 8F 74 00 B3 8F 70 00 B2 8F 6C 00 B1 8F 68 00 B0 8F 08 00 E0 03 90 00 BD 27 2C 00 A2 8F ?? ?? 11 3C ?? ?? 31 26 18 00 42 8C 80 20 02 00 00 19 02 00 21 18 83 00 23 10 62 00 80 10 02 00 10 00 42 24 21 88 22 02 ?? ?? 02 3C ?? ?? 42 24 03 00 40 10 40 00 B1 AF ?? ?? ?? 0? 21 20 20 02 40 00 A3 8F 18 00 63 8C 44 00 A3 AF 40 00 A3 8F 1C 00 72 8C 44 00 A3 8F CE 00 60 10 FE FF 46 26 1B 00 C6 02 F4 01 C0 00 30 00 B7 8F 10 10 00 00 01 00 5E 24 00 A1 1E 00 1B 00 D2 02 F4 01 40 02 10 18 00 00 48 00 A3 AF 21 A8 60 00 44 00 A3 8F 00 81 15 00 21 80 70 00 00 00 02 8E 08 00 56 10 04 00 11 8E 25 00 20 12 21 A8 BE 02 2B 10 B2 02 F9 FF 40 14 21 80 14 02 ?? ?? ?? 0? 23 A8 B2 02 21 28 E0 02 ?? ?? ?? 0? 21 20 20 02 F5 FF 40 14 3C 00 A2 8F 02 00 42 30 AA 00 40 14 A0 00 A3 8F 08 00 03 8E 0C 00 02 8E A0 00 A4 8F 00 00 83 AC 04 00 82 AC ?? ?? 02 3C ?? ?? 42 24 41 01 40 10 00 00 00 00 ?? ?? ?? 0? 40 00 A4 8F ?? ?? ?? 0? 01 00 02 24 ?? ?? 22 8D A7 FF 40 10 A0 00 A3 8F 00 00 62 8C 6A FF 40 14 24 00 A2 8F 2C 00 A2 8F 00 00 73 AC ?? ?? ?? 0? 04 00 62 AC 40 00 A3 8F 20 00 67 8C 40 18 12 00 21 18 72 00 80 10 07 00 2B 10 43 00 26 00 40 10 21 30 C0 03 48 00 BE 8F 3C 00 A2 8F 02 00 42 30 64 00 40 10 00 00 00 00 00 00 62 8E 34 00 AA 8F 38 00 A9 8F 00 29 06 00 21 50 42 01 44 00 A3 8F 00 11 1E 00 21 10 62 00 ?? ?? ?? 0? 04 00 42 24 21 F0 C6 03 2B 18 D2 03 76 00 60 10 21 10 45 00 00 00 43 8C FA FF 60 14 FC FF 44 24 FC FF 56 AC 00 00 4A AC 04 00 49 AC BC 00 A2 8F 0C 00 82 AC 40 00 A3 8F ?? ?? 02 3C 01 00 E7 24 ?? ?? 42 24 76 FF 40 10 20 00 67 AC ?? ?? ?? 0? 21 20 60 00 ?? ?? ?? 0? A0 00 A3 8F ?? ?? ?? 0? 01 00 44 26 21 28 40 00 10 00 04 24 ?? ?? ?? 0? 21 80 40 00 F2 00 40 10 21 A8 40 00 23 00 40 12 FE FF 17 26 44 00 AA 8F 21 60 00 00 04 00 4D 8D 1B 00 A0 11 00 00 00 00 00 00 4B 8D 08 00 4E 8D 0C 00 42 8D 1B 00 77 01 F4 01 E0 02 10 28 00 00 01 00 A5 24 00 49 05 00 1B 00 70 01 F4 01 00 02 10 30 00 00 00 19 06 00 21 18 A3 02 ?? ?? ?? 0? 04 00 63 24 2B 38 D0 00 21 00 E0 10 21 18 69 00 00 00 67 8C FB FF E0 14 21 30 C5 00 23 30 C5 00 FC FF 6B AC 00 00 6D AC 04 00 6E AC 08 00 62 AC 01 00 8C 25 E1 FF 92 15 10 00 4A 25 40 00 A3 8F 44 00 A4 8F 24 00 79 8C 09 F8 20 03 21 90 00 02 1B 00 D0 02 F4 01 00 02 40 00 A3 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 70 AC 18 00 75 AC 24 00 62 AC 44 00 B5 AF 20 00 67 8C 10 F0 00 00 1B 00 D7 02 F4 01 E0 02 10 30 00 00 ?? ?? ?? 0? 01 00 C6 24 ?? ?? ?? 0? 23 30 D0 00 00 00 62 8E 34 00 AA 8F 2C 00 A9 8F 00 29 06 00 21 50 42 01 44 00 A3 8F 00 11 1E 00 21 10 62 00 ?? ?? ?? 0? 04 00 42 24 2B 18 D2 03 12 00 60 10 21 10 45 00 00 00 43 8C FB FF 60 14 21 F0 C6 03 23 F0 C6 03 68 02 23 8D FC FF 56 AC 00 00 4A AC 04 00 53 AC 08 00 49 AC 03 00 63 30 02 00 02 24 9B FF 62 14 40 00 A3 8F DC 02 22 8D 08 00 42 34 ?? ?? ?? 0? DC 02 22 AD ?? ?? ?? 0? 23 F0 D2 03 ?? ?? ?? 0? 23 F0 D2 03 2C 00 A2 8F 00 00 73 AC ?? ?? ?? 0? 04 00 62 AC 10 00 04 24 ?? ?? ?? 0? 1F 00 05 24 8C 00 40 10 44 00 A2 AF 42 08 03 3C 85 10 63 24 19 00 C3 02 40 00 A4 8F 1F 00 12 24 18 00 82 AC 1F 00 02 24 1C 00 82 AC ?? ?? 02 3C ?? ?? 42 24 24 00 82 AC 3D 8D 02 3C 09 CB 42 34 20 00 87 8C 10 18 00 00 23 20 C3 02 42 20 04 00 19 00 C2 02 21 18 64 00 02 19 03 00 40 21 03 00 23 18 83 00 23 F0 C3 02 10 10 00 00 02 11 02 00 80 18 02 00 40 21 02 00 23 18 83 00 21 10 62 00 23 30 C2 02 ?? ?? ?? 0? 01 00 C6 24 04 00 46 8C 00 00 C3 80 04 00 60 14 ?? ?? 84 8D ?? ?? 43 26 00 00 86 8C 0A 30 66 00 18 00 47 8C 30 00 A5 8F 21 20 A0 01 54 00 A8 AF 5C 00 A9 AF 58 00 AA AF 64 00 AC AF ?? ?? ?? 0? 60 00 AD AF 2C 00 A2 8F 60 00 AD 8F 64 00 AC 8F 58 00 AA 8F 5C 00 A9 8F ?? ?? ?? 0? 54 00 A8 8F 00 00 44 8D FF FF 06 24 28 00 86 10 30 00 A7 8F 1B 00 83 00 F4 01 60 00 10 30 00 00 80 30 06 00 60 02 42 8C 21 30 46 00 00 00 C2 8C 0B 00 40 14 24 00 A2 AF ?? ?? ?? 0? 1C 00 A3 8F 2C 00 A2 8F 5C 02 43 8C 24 00 A2 8F 80 10 02 00 21 10 62 00 00 00 42 8C 78 FE 40 10 24 00 A2 AF 00 21 02 00 21 20 A4 00 18 00 AF 27 50 00 A5 AF 54 00 A8 AF 5C 00 A9 AF 58 00 AA AF 64 00 AC AF ?? ?? ?? 0? 60 00 AD AF 21 98 40 00 50 00 A5 8F 54 00 A8 8F 5C 00 A9 8F 58 00 AA 8F 64 00 AC 8F E7 FF 40 10 60 00 AD 8F ?? ?? ?? 0? 0C 00 62 92 00 00 E4 90 23 00 80 10 21 30 00 00 01 00 E6 90 1C 00 C0 10 00 00 00 00 02 00 EE 90 00 21 04 00 18 00 C0 11 21 20 86 00 03 00 E6 90 00 21 04 00 14 00 C0 10 21 20 8E 00 04 00 EE 90 00 21 04 00 10 00 C0 11 21 20 86 00 05 00 E6 90 00 21 04 00 21 20 8E 00 0A 00 C0 10 05 00 E7 24 00 F0 0E 3C 00 21 04 00 01 00 E7 24 21 20 C4 00 00 00 E6 90 24 78 8E 00 02 7E 0F 00 F9 FF C0 14 26 20 E4 01 00 D8 84 7C 1B 00 83 00 F4 01 60 00 10 30 00 00 80 30 06 00 ?? ?? ?? 0? 00 00 44 AD ?? ?? ?? 0? FF FF 02 24 ?? ?? 02 3C ?? ?? 42 24 03 00 40 10 00 00 00 00 ?? ?? ?? 0? 40 00 A4 8F ?? ?? 05 3C 02 00 04 24 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? 7F 00 04 24 ?? ?? ?? 0? 01 00 02 24 1B 00 C3 02 F4 01 60 00 5C 02 44 8C 10 30 00 00 80 18 06 00 21 18 83 00 00 00 64 8C 23 FE 80 10 80 20 04 00 60 02 43 8C ?? ?? ?? 0? 21 18 64 00 01 00 42 30 1D FE 40 14 04 00 63 24 00 00 62 8C 26 20 56 00 42 20 04 00 FA FF 80 14 01 00 42 30 2C 00 A2 8F 18 00 AF 27 60 02 42 8C 4C 00 A3 AF 50 00 A5 AF 23 10 62 00 83 10 02 00 00 21 02 00 21 20 A4 00 54 00 A8 AF 5C 00 A9 AF 58 00 AA AF 64 00 AC AF 60 00 AD AF ?? ?? ?? 0? 24 00 A2 AF 21 98 40 00 4C 00 A3 8F 50 00 A5 8F 54 00 A8 8F 5C 00 A9 8F 58 00 AA 8F 64 00 AC 8F 35 FE 40 14 60 00 AD 8F ?? ?? ?? 0? 00 00 62 8C }
	condition:
		$1
}

rule file_219_2_0 {
	meta:
		name = "elf_machine_matches_host"
		size = 56
	strings:
		$1 = { 24 00 83 8C 20 04 63 30 07 00 60 14 21 10 00 00 12 00 83 94 08 00 04 24 05 00 64 10 0A 00 04 24 03 00 64 10 00 00 00 00 08 00 E0 03 00 00 00 00 08 00 E0 03 01 00 02 24 }
	condition:
		$1
}

rule file_219_3_0 {
	meta:
		name = "_dl_lookup_symbol_x"
		size = 2932
		refs = "0b68 _dl_debug_mask 07d4 __pthread_mutex_lock 02d4 _dl_argv 02e8 $LC2 0300 $LC14 02f8 $LC7 0308 $LC8 0310 $LC13 033c $LC6 035c strlen 0398 stpcpy 03a4 $LC15 03b4 _dl_signal_cerror 02bc $LC12 0400 $LC1 0414 __assert_fail 0404 __PRETTY_FUNCTION__.9484 0098 $LC11 0530 $LC9 0548 _dl_debug_printf 0538 $LC18 0560 _dl_debug_printf_c 055c $LC19 060c undefined_msg 068c $LC16 06c8 $LC5 0754 _dl_load_lock 0778 _dl_ns 087c __pthread_mutex_unlock 08cc _dl_lookup_symbol_x 09a0 $LC20 09fc $LC10 0ab8 $LC17 0ae8 malloc 0b24 memcpy 0b5c _dl_scope_free"
	strings:
		$1 = { 50 FF BD 27 A8 00 BE AF 9C 00 B5 AF 94 00 B3 AF 90 00 B2 AF 8C 00 B1 AF 88 00 B0 AF AC 00 BF AF A4 00 B7 AF A0 00 B6 AF 98 00 B4 AF 00 00 82 90 21 F0 A0 03 21 88 80 00 21 A8 A0 00 21 80 C0 00 BC 00 C7 AF C0 00 D2 8F 8E 00 40 10 CC 00 D3 8F 21 18 80 00 05 15 16 24 40 21 16 00 21 B0 96 00 01 00 63 24 21 B0 56 00 00 00 62 90 FB FF 40 14 40 21 16 00 FF FF 02 24 60 00 C2 AF 58 00 C0 AF 06 00 40 12 5C 00 C0 AF C8 00 C3 8F FA FF 02 24 24 10 62 00 E5 00 40 14 ?? ?? 04 3C CA 00 60 16 BC 00 C4 8F 68 00 C0 AF 00 00 82 8C 30 01 40 10 00 00 00 00 68 00 C4 8F BC 00 D4 8F ?? ?? ?? 0? 58 00 D7 27 79 00 40 14 00 00 00 00 04 00 94 26 00 00 82 8E 12 00 40 10 21 20 00 00 00 00 07 8E 14 00 A2 AF 18 00 A4 AF C4 00 C2 8F C8 00 C4 8F 10 00 B7 AF 1C 00 B2 AF 20 00 A4 AF 24 00 B3 AF 28 00 A2 AF 2C 00 B5 AF 21 20 20 02 21 28 C0 02 ?? ?? ?? 0? 60 00 C6 27 EA FF 40 18 00 00 00 00 58 00 C2 8F 12 01 40 10 00 00 00 00 00 00 07 8E 06 00 E0 10 00 00 00 00 0D 00 E3 90 03 00 02 24 03 00 63 30 1F 00 62 10 C4 00 C3 8F 5C 00 D7 8F 68 00 C0 AF 68 02 E4 8E 02 00 03 24 03 00 84 30 BD 00 83 10 21 10 E0 02 D4 02 43 8C B8 00 60 10 01 00 03 24 ?? ?? 03 3C ?? ?? 63 8C 04 08 64 30 D2 00 80 14 04 00 63 30 58 00 C3 8F 00 00 03 AE 21 E8 C0 03 AC 00 BF 8F A8 00 BE 8F A4 00 B7 8F A0 00 B6 8F 9C 00 B5 8F 98 00 B4 8F 94 00 B3 8F 90 00 B2 8F 8C 00 B1 8F 88 00 B0 8F 08 00 E0 03 B0 00 BD 27 01 00 02 24 30 00 62 10 BC 00 C4 8F 38 00 C0 AF 3C 00 C0 AF 00 00 82 8C 38 01 40 10 01 00 03 24 21 B8 80 00 38 00 C9 27 ?? ?? ?? 0? 68 00 C6 8F 04 00 F7 26 00 00 E2 8E 14 00 40 10 21 30 00 00 00 00 07 8E 14 00 A2 AF C8 00 C2 8F 10 00 A9 AF 18 00 A6 AF 28 00 A3 AF 1C 00 B2 AF 20 00 A2 AF 24 00 B3 AF 2C 00 A0 AF 21 20 20 02 21 28 C0 02 60 00 C6 27 80 00 C3 AF ?? ?? ?? 0? 7C 00 C9 AF 80 00 C3 8F EA FF 40 10 7C 00 C9 8F 38 00 C2 8F 1A 01 40 10 00 00 00 00 3C 00 C2 8F 17 01 55 10 00 00 00 00 00 00 02 8E 5C 00 D5 AF 21 B8 A0 02 58 00 C2 AF 01 00 03 24 ?? ?? ?? 0? 68 00 C3 AF ?? ?? ?? 0? 05 15 16 24 5C 00 C2 8F 62 00 55 10 01 00 03 24 58 00 C7 AF 5C 00 D5 AF 21 B8 A0 02 ?? ?? ?? 0? 68 00 C3 AF 88 FF 60 16 04 00 94 26 FC FF 94 26 51 00 40 12 ?? ?? 04 3C 02 00 A0 12 21 98 00 00 04 00 B3 8E 00 00 63 82 07 00 60 14 ?? ?? 03 3C ?? ?? 63 8C 00 00 73 8C 03 00 60 16 00 00 00 00 ?? ?? 13 3C ?? ?? 73 26 0C 00 43 8E 00 00 44 8E ?? ?? 14 3C 4C 00 C3 AF ?? ?? 03 3C ?? ?? 63 24 ?? ?? 05 3C 44 00 C4 AF ?? ?? 04 3C ?? ?? 94 26 ?? ?? A5 24 ?? ?? 84 24 50 00 C3 AF FE FF 03 24 38 00 D4 AF 3C 00 D1 AF 40 00 C5 AF E4 00 43 10 48 00 C4 AF ?? ?? 02 3C ?? ?? 42 24 54 00 C2 AF 3C 00 D1 27 07 00 02 24 ?? ?? ?? 0? 01 00 12 24 00 00 24 8E ?? ?? ?? 0? 04 00 31 26 FC FF F1 16 21 90 42 02 0E 00 42 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 30 00 B2 27 3C 00 D1 27 21 10 40 02 ?? ?? ?? 0? 21 28 80 02 00 00 25 8E 04 00 31 26 ?? ?? ?? 0? 21 20 40 00 FB FF F1 16 ?? ?? 06 3C 21 20 00 00 21 28 60 02 ?? ?? C6 24 ?? ?? ?? 0? 21 38 40 02 00 00 00 AE ?? ?? ?? 0? 21 10 00 00 BC 00 C3 8F 00 00 62 8C 00 00 43 8C 00 00 64 8C 1B 00 93 10 04 00 63 24 68 00 C0 AF 21 20 00 00 04 00 63 24 FC FF 65 8C FD FF B3 14 01 00 84 24 ?? ?? ?? 0? 68 00 C4 AF ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 FE 02 06 24 ?? ?? ?? 0? ?? ?? E7 24 01 00 04 24 21 B8 A0 02 ?? ?? ?? 0? 68 00 C4 AF ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 E8 02 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? ?? 0? 68 00 C0 AF ?? ?? ?? 0? D4 02 43 AC C8 00 C2 8F 01 00 43 30 41 FF 60 10 21 10 E0 02 AE 00 B7 12 00 00 00 00 DC 02 E3 8E 08 00 63 30 3B FF 60 14 00 00 00 00 CC 02 A3 8E 6C 00 C3 AF 0F 00 00 00 C8 02 A4 8E 90 00 80 10 70 00 C4 AF 00 00 82 8C 8D 00 40 10 00 00 00 00 30 FF 57 10 5C 00 C2 8F 04 00 82 24 00 00 43 8C 87 00 60 10 00 00 00 00 FC FF 77 14 04 00 42 24 ?? ?? ?? 0? 5C 00 C2 8F 2E FF 60 10 04 00 A5 8E 00 00 A3 80 07 00 60 14 ?? ?? 03 3C ?? ?? 63 8C 00 00 65 8C 03 00 A0 14 00 00 00 00 ?? ?? 05 3C ?? ?? A5 24 04 00 47 8C 00 00 E3 80 08 00 60 14 18 00 A6 8E ?? ?? 03 3C ?? ?? 63 8C 00 00 67 8C 04 00 E0 14 68 00 C4 8F ?? ?? 07 3C ?? ?? E7 24 68 00 C4 8F 34 01 80 10 18 00 43 8C ?? ?? 02 3C ?? ?? 42 24 ?? ?? 04 3C 10 00 A3 AF 14 00 A2 AF 18 00 B1 AF ?? ?? ?? 0? ?? ?? 84 24 13 01 40 12 00 00 00 00 00 00 45 8E ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? ?? 0? 5C 00 C2 8F 00 00 02 8E 06 00 40 10 00 00 00 00 0C 00 43 90 02 00 02 24 02 19 03 00 03 00 62 10 00 00 00 00 04 00 60 12 00 00 00 00 00 00 00 AE ?? ?? ?? 0? 21 10 00 00 ?? ?? 02 3C ?? ?? 42 8C 00 01 42 30 F9 FF 40 14 00 00 00 00 38 00 A0 12 ?? ?? 04 3C 04 00 A4 8E 22 00 40 12 00 00 00 00 00 00 42 8E ?? ?? 03 3C 03 00 40 14 ?? ?? 63 24 ?? ?? 02 3C ?? ?? 42 24 00 00 85 80 08 00 A0 14 21 90 80 00 ?? ?? 04 3C ?? ?? 84 8C 00 00 92 8C 04 00 40 16 ?? ?? 15 3C ?? ?? 12 3C ?? ?? 52 26 ?? ?? 15 3C ?? ?? B5 26 3C 00 D1 AF 44 00 C2 AF 38 00 D5 AF 40 00 C3 AF 48 00 D4 27 3C 00 D1 27 12 00 02 24 01 00 13 24 0A 00 34 12 21 98 62 02 00 00 24 8E ?? ?? ?? 0? 04 00 31 26 ?? ?? ?? 0? 00 00 00 00 ?? ?? 03 3C ?? ?? 63 24 ?? ?? ?? 0? 21 10 60 00 0E 00 62 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 30 00 B3 27 3C 00 D1 27 21 10 60 02 21 28 A0 02 ?? ?? ?? 0? 21 20 40 00 06 00 91 12 ?? ?? 06 3C 00 00 25 8E ?? ?? ?? 0? 04 00 31 26 ?? ?? ?? 0? ?? ?? 84 24 21 20 00 00 21 28 40 02 ?? ?? C6 24 ?? ?? ?? 0? 21 38 60 02 ?? ?? ?? 0? 00 00 00 AE ?? ?? ?? 0? 5C 00 D7 8F ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 42 24 6C 00 C2 8F 14 00 40 10 21 B0 00 00 00 00 56 8C 11 00 C0 12 00 00 00 00 04 00 42 8C 74 FF 57 10 6C 00 C4 8F 21 10 00 00 08 00 83 24 01 00 42 24 09 00 56 10 04 00 63 24 FC FF 64 8C FC FF 97 14 01 00 42 24 FF FF 42 24 ?? ?? ?? 0? 5C 00 C2 8F ?? ?? ?? 0? 21 10 A0 02 C8 00 C2 8F 28 03 E3 8E 2C 03 E4 8E 04 00 54 30 74 00 C3 AF 1A 00 80 16 78 00 C4 AF ?? ?? 02 3C ?? ?? 42 24 03 00 40 10 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 18 00 A2 8E 80 20 02 00 00 19 02 00 21 18 83 00 23 10 62 00 80 18 02 00 ?? ?? 02 3C ?? ?? 42 24 21 10 62 00 00 00 42 8C 06 00 40 10 00 00 00 00 88 00 57 10 74 00 C4 8F 0C 00 42 8C FC FF 40 14 00 00 00 00 ?? ?? ?? 0? FF FF 17 24 3B E8 03 7C 74 8B 63 24 0F 00 00 00 00 00 64 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 02 24 0B 00 82 14 ?? ?? 02 3C 3B E8 03 7C 74 8B 64 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? 02 3C ?? ?? 42 24 04 00 40 10 00 00 00 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 C8 02 A2 8E 70 00 C3 8F 2E 00 62 10 00 00 00 00 2C 00 40 10 00 00 00 00 00 00 43 8C 29 00 60 10 00 00 00 00 06 00 E3 12 04 00 42 24 00 00 43 8C 24 00 60 10 00 00 00 00 FC FF E3 16 04 00 42 24 28 03 E3 8E 2C 03 E2 8E 74 00 C4 8F 26 18 83 00 78 00 C4 8F 26 10 82 00 25 B8 62 00 2B B8 17 00 23 B8 17 00 ?? ?? 02 3C ?? ?? 42 24 04 00 40 10 00 00 00 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 25 00 80 16 00 00 00 00 08 FF E0 12 00 00 00 00 BC 00 C7 8F C4 00 C2 8F C8 00 C3 8F 10 00 B2 AF 14 00 A2 AF 18 00 A3 AF 1C 00 B3 AF 21 20 20 02 21 28 A0 02 ?? ?? ?? 0? 21 30 00 02 ?? ?? ?? 0? 21 E8 C0 03 CC 02 A2 8E 9F FF 40 10 6C 00 C4 8F 19 00 82 10 6C 00 C3 8F 00 00 56 8C 9A FF C0 12 00 00 00 00 04 00 43 8C D5 FF E3 12 08 00 42 24 21 18 00 00 01 00 63 24 93 FF 76 10 04 00 42 24 FC FF 44 8C FC FF E4 16 01 00 63 24 FF FF 63 24 ?? ?? ?? 0? 28 03 E3 8E 3B E8 03 7C 01 00 02 24 74 8B 62 AC 0F 00 00 00 E0 FE E0 12 00 00 00 00 ?? ?? ?? 0? A0 02 A7 8E 00 00 62 8C 2B 18 C2 02 81 FF 60 10 6C 00 C3 8F 04 00 64 24 80 18 16 00 21 18 83 00 00 00 64 8C B9 FF E4 12 00 00 00 00 01 00 D6 26 2B 20 C2 02 21 00 80 10 04 00 63 24 00 00 64 8C FB FF E4 16 01 00 D6 26 FF FF D6 26 ?? ?? ?? 0? 28 03 E3 8E ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? ?? 0? 5C 00 C2 8F 28 03 E3 8E A9 FF 83 14 2C 03 E2 8E 78 00 C4 8F A6 FF 82 14 00 00 00 00 DC 02 E5 8E 08 00 A2 30 07 00 40 14 02 00 02 24 68 02 A3 8E 03 00 63 30 0A 00 62 10 00 00 00 00 08 00 A5 34 DC 02 E5 AE ?? ?? ?? 0? 21 B8 00 00 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 42 24 ?? ?? ?? 0? 21 B0 40 00 DC 02 A2 8E 08 00 42 30 F4 FF 40 14 00 00 00 00 D0 02 A7 8E 2B 10 C7 02 29 00 40 10 80 10 16 00 CC 02 A3 8E 21 10 62 00 04 00 57 AC 0F 00 00 00 CC 02 A2 8E 01 00 C3 26 00 00 43 AC ?? ?? 02 3C ?? ?? 42 8C 40 00 42 30 E6 FF 40 10 00 00 00 00 04 00 E5 8E 00 00 A2 80 07 00 40 14 ?? ?? 02 3C ?? ?? 42 8C 00 00 45 8C 03 00 A0 14 00 00 00 00 ?? ?? 05 3C ?? ?? A5 24 04 00 A7 8E 00 00 E2 80 08 00 40 14 18 00 E6 8E ?? ?? 02 3C ?? ?? 42 8C 00 00 47 8C 03 00 E0 14 00 00 00 00 ?? ?? 07 3C ?? ?? E7 24 18 00 A2 8E ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 10 00 A2 AF ?? ?? ?? 0? 21 B8 00 00 26 00 E0 10 2C 00 04 24 40 38 07 00 01 00 E4 24 80 20 04 00 7C 00 C5 AF ?? ?? ?? 0? 84 00 C7 AF 21 18 40 00 7C 00 C5 8F BC FF 40 10 84 00 C7 8F 0D 00 C0 12 21 40 00 00 CC 02 A5 8E 80 40 16 00 21 30 00 01 04 00 44 24 04 00 A5 24 84 00 C7 AF 7C 00 C8 AF ?? ?? ?? 0? 80 00 C2 AF 7C 00 C8 8F 84 00 C7 8F 80 00 C3 8F 21 40 68 00 01 00 C2 26 04 00 17 AD 00 00 62 AC 0F 00 00 00 CC 02 A4 8E D0 02 A7 AE BD FF 80 10 CC 02 A3 AE ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? ?? ?? 02 3C ?? ?? ?? 0? 0A 00 07 24 }
	condition:
		$1
}

rule file_219_4_0 {
	meta:
		name = "_dl_setup_hash"
		size = 208
		refs = "00a8 $LC21 00ac $LC1 00c8 __assert_fail 00b0 __PRETTY_FUNCTION__.9534"
	strings:
		$1 = { 20 02 82 8C 19 00 40 10 00 00 00 00 04 00 42 8C 00 00 83 8C 21 10 62 00 00 00 46 8C 4C 02 86 AC 08 00 43 8C FF FF 67 24 24 28 E3 00 1E 00 A0 14 04 00 48 8C 10 00 45 24 50 02 87 AC 80 18 03 00 0C 00 42 8C 21 18 A3 00 80 30 06 00 21 30 66 00 80 38 08 00 23 30 C7 00 54 02 82 AC 58 02 85 AC 5C 02 83 AC 08 00 E0 03 60 02 86 AC 30 00 82 8C 0B 00 40 10 00 00 00 00 04 00 42 8C 00 00 83 8C 21 18 62 00 00 00 62 8C 08 00 63 24 60 02 83 AC 80 28 02 00 21 18 65 00 4C 02 82 AC 5C 02 83 AC 08 00 E0 03 00 00 00 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C E0 FF BD 27 ?? ?? 84 24 ?? ?? A5 24 79 03 06 24 1C 00 BF AF ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "capset"
		size = 28
	strings:
		$1 = { 6D 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "__strftime_internal"
		size = 7468
		refs = "02e4 memset 0374 memcpy 03e8 strlen 04cc $LC4 05c8 $LC2 05dc $LC1 05f0 $LC0 0b5c mktime 0bc4 $LC3 0ffc __tzname 1550 _nl_get_alt_digit 101c $LC5 1a3c _nl_get_era_entry 1b70 __tzset"
	strings:
		$1 = { 58 FF BD 27 08 00 E3 8C 90 00 B4 AF BC 00 B4 8F 58 00 A3 AF 0D 00 62 28 08 00 88 8E 28 00 E3 8C 9C 00 B7 AF 98 00 B6 AF 84 00 B1 AF 80 00 B0 AF A4 00 BF AF A0 00 BE AF 94 00 B5 AF 8C 00 B3 AF 88 00 B2 AF 21 B0 E0 00 21 88 80 00 21 B8 A0 00 21 80 C0 00 60 00 A8 AF 84 00 40 14 64 00 A3 AF 58 00 A8 8F F4 FF 08 25 58 00 A8 AF 00 00 02 82 11 00 40 10 21 98 00 00 5C 00 B6 AF 25 00 03 24 13 00 43 10 23 18 F3 02 02 00 63 2C 66 00 60 14 00 00 00 00 03 00 20 12 00 00 00 00 00 00 22 A2 01 00 31 26 01 00 73 26 21 10 00 02 01 00 42 80 F2 FF 40 14 01 00 10 26 5C 00 20 12 21 10 60 02 5B 00 E0 12 A4 00 BF 8F ?? ?? ?? 0? 00 00 20 A2 21 30 00 00 21 B0 00 00 21 F0 00 00 30 00 04 24 5E 00 07 24 5F 00 0A 24 23 00 05 24 2D 00 09 24 01 00 10 26 00 00 02 82 0A 00 44 10 00 00 00 00 31 00 43 28 09 00 60 10 00 00 00 00 0B 00 45 14 00 00 00 00 01 00 10 26 00 00 02 82 F8 FF 44 14 01 00 06 24 ?? ?? ?? 0? 21 F0 40 00 35 00 47 14 00 00 00 00 ?? ?? ?? 0? 01 00 16 24 F9 FF 49 10 D0 FF 43 24 0A 00 63 2C 1F 00 60 10 FF FF 12 24 CC 0C 04 3C CD CC 84 34 FF 7F 05 3C 21 90 00 00 FF FF A5 34 ?? ?? ?? 0? FF FF 87 24 29 00 47 12 00 00 03 82 40 10 12 00 C0 90 12 00 21 10 52 00 01 00 10 26 D0 FF 72 24 21 90 42 02 00 00 02 82 D0 FF 43 24 0A 00 63 2C 0C 00 60 10 45 00 03 24 2A 10 44 02 F1 FF 40 14 00 00 00 00 21 90 A0 00 01 00 10 26 00 00 02 82 D0 FF 43 24 0A 00 63 2C F7 FF 60 14 00 00 00 00 45 00 03 24 23 00 43 10 4F 00 03 24 21 00 43 10 21 38 00 00 FF 00 43 30 7B 00 64 2C 28 00 80 10 ?? ?? 04 3C 80 18 03 00 ?? ?? 84 24 21 18 83 00 00 00 63 8C 08 00 60 00 00 00 00 00 CF FF 4A 14 D0 FF 43 24 ?? ?? ?? 0? 21 F0 40 00 38 00 62 28 D7 FF 40 14 40 10 12 00 ?? ?? ?? 0? 21 90 A0 00 21 10 00 00 A4 00 BF 8F A0 00 BE 8F 9C 00 B7 8F 98 00 B6 8F 94 00 B5 8F 90 00 B4 8F 8C 00 B3 8F 88 00 B2 8F 84 00 B1 8F 80 00 B0 8F 08 00 E0 03 A8 00 BD 27 01 00 10 26 21 38 40 00 ?? ?? ?? 0? 00 00 02 82 58 00 A3 8F 0C 00 02 24 0A 18 43 00 ?? ?? ?? 0? 58 00 A3 AF FF FF 02 82 FF FF 10 26 25 00 03 24 2D 00 43 14 FF FF 02 26 21 48 00 02 01 00 15 24 23 90 55 02 00 00 4A 2A 21 10 00 00 0A 10 4A 02 21 50 A2 02 23 10 F3 02 2B 10 42 01 DB FF 40 10 00 00 00 00 1C 00 20 12 00 00 00 00 0B 00 40 1A 30 00 02 24 2C 00 C2 13 21 20 20 02 20 00 05 24 21 30 40 02 78 00 A9 AF ?? ?? ?? 0? 74 00 AA AF 74 00 AA 8F 78 00 A9 8F 21 88 32 02 1B 00 C0 12 21 20 20 02 FF FF A2 26 FF FF 05 24 21 18 22 01 00 00 64 90 3C 00 86 8E 21 18 22 02 80 20 04 00 21 20 C4 00 00 00 84 8C FF FF 42 24 F7 FF 45 14 00 00 64 A0 21 88 35 02 21 98 6A 02 ?? ?? ?? 0? 21 10 00 02 FF FF 02 26 01 00 15 24 25 00 04 24 21 48 40 00 FF FF 42 24 01 00 43 80 FC FF 64 14 01 00 B5 26 ?? ?? ?? 0? 23 90 55 02 21 28 20 01 21 30 A0 02 74 00 AA AF ?? ?? ?? 0? 21 88 35 02 ?? ?? ?? 0? 74 00 AA 8F 30 00 05 24 21 30 40 02 78 00 A9 AF 74 00 AA AF ?? ?? ?? 0? 21 88 32 02 78 00 A9 8F ?? ?? ?? 0? 74 00 AA 8F 01 00 03 24 5C 00 A8 8F 27 00 04 24 26 00 02 24 08 00 05 8D 60 00 A8 8F 0B B0 06 00 0C 00 A7 28 0A 10 87 00 08 00 42 24 80 10 02 00 21 10 02 01 04 00 44 8C 01 00 02 24 0B 18 46 00 70 00 A3 AF ?? ?? ?? 0? 6C 00 A5 AF 23 90 42 02 21 A8 40 00 00 00 49 2A 21 10 00 00 0A 10 49 02 21 48 55 00 23 10 F3 02 2B 10 22 01 70 00 A3 8F 84 FF 40 10 6C 00 A5 8F 28 00 20 12 00 00 00 00 0F 00 40 1A 0C 00 A5 28 30 00 02 24 F6 04 C2 13 21 20 20 02 20 00 05 24 21 30 40 02 70 00 A3 AF ?? ?? ?? 0? 78 00 A9 AF 5C 00 A8 8F 70 00 A3 8F 78 00 A9 8F 08 00 05 8D 21 88 32 02 0C 00 A5 28 B3 04 60 10 27 00 02 24 26 00 03 24 0B 10 65 00 60 00 A3 8F 08 00 42 24 80 10 02 00 21 10 62 00 04 00 46 8C FF FF A3 26 0B 00 A0 12 FF FF 02 24 21 20 C3 00 00 00 85 90 38 00 87 8E 21 20 23 02 80 28 05 00 21 28 E5 00 00 00 A5 8C FF FF 63 24 F7 FF 62 14 00 00 85 A0 21 88 35 02 21 98 69 02 ?? ?? ?? 0? 21 10 00 02 ?? ?? 03 3C ?? ?? 63 24 B8 00 A2 8F 5C 00 A7 8F 21 20 00 00 21 30 60 00 10 00 A2 AF 14 00 B4 AF FF FF 05 24 ?? ?? ?? 0? 70 00 A3 AF 23 90 42 02 00 00 49 2A 21 20 00 00 0A 20 49 02 21 48 82 00 23 38 F3 02 21 A8 40 00 2B 10 27 01 43 FF 40 10 70 00 A3 8F E7 FF 20 12 00 00 00 00 7D 04 40 1A 30 00 02 24 7D 04 C2 13 21 20 20 02 20 00 05 24 21 30 40 02 70 00 A3 AF 6C 00 A7 AF ?? ?? ?? 0? 78 00 A9 AF 70 00 A3 8F 6C 00 A7 8F 78 00 A9 8F 21 90 32 02 B8 00 A5 8F 21 20 40 02 14 00 B4 AF 10 00 A5 AF 21 28 E0 00 5C 00 A7 8F 21 30 60 00 ?? ?? ?? 0? 78 00 A9 AF 78 00 A9 8F 21 20 55 02 45 04 C0 12 21 98 69 02 2B 10 24 02 43 04 40 10 21 10 00 02 00 00 22 92 3C 00 83 8E 01 00 31 26 80 10 02 00 21 10 62 00 00 00 42 8C F9 FF 91 14 FF FF 22 A2 ?? ?? ?? 0? 21 10 00 02 ?? ?? 03 3C ?? ?? ?? 0? ?? ?? 63 24 5B FF E0 14 FF FF 02 26 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 83 24 56 FF E0 14 FF FF 02 26 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 43 24 45 00 02 24 28 05 E2 10 5C 00 A4 8F 5C 00 A8 8F EB 51 04 3C 1F 85 84 34 14 00 03 8D 2A 28 12 00 01 00 0A 24 6C 07 63 24 18 00 64 00 C3 17 03 00 0B 50 45 02 10 20 00 00 43 21 04 00 23 10 82 00 80 28 02 00 00 21 02 00 21 20 A4 00 80 28 04 00 21 20 85 00 23 18 64 00 C2 AF 03 00 23 A8 55 00 4F 00 03 24 B8 03 E3 10 21 10 A0 02 02 04 A0 06 21 38 00 00 58 00 A9 27 CC CC 06 3C 21 A8 20 01 CD CC C6 34 19 00 46 00 FF FF B5 26 10 18 00 00 C2 18 03 00 40 28 03 00 C0 20 03 00 21 20 A4 00 23 10 44 00 30 00 44 24 00 00 A4 A2 F5 FF 60 14 21 10 60 00 05 00 E0 10 2D 00 02 24 2D 00 02 24 FF FF A2 A2 FF FF B5 26 2D 00 02 24 1C 00 C2 13 23 18 A9 02 21 18 6A 00 19 00 60 18 5F 00 04 24 FD 03 C4 13 23 20 F3 02 2B 50 44 01 CF FE 40 11 00 00 00 00 06 00 E0 10 00 00 00 00 03 00 20 12 01 00 B5 26 00 00 22 A2 01 00 31 26 01 00 73 26 09 00 20 12 21 20 20 02 21 30 60 00 30 00 05 24 21 88 23 02 70 00 A3 AF ?? ?? ?? 0? 78 00 A9 AF 78 00 A9 8F 70 00 A3 8F 21 98 63 02 21 90 00 00 23 48 35 01 23 90 49 02 00 00 4A 2A 21 10 00 00 0A 10 4A 02 21 50 49 00 23 10 F3 02 2B 10 42 01 B2 FE 40 10 00 00 00 00 F3 FE 20 12 00 00 00 00 0B 00 40 1A 30 00 02 24 CE 03 C2 13 21 20 20 02 20 00 05 24 21 30 40 02 78 00 A9 AF ?? ?? ?? 0? 74 00 AA AF 74 00 AA 8F 78 00 A9 8F 21 88 32 02 B8 03 C0 12 21 20 20 02 FA 03 20 11 FF FF 22 25 FF FF 07 24 21 18 A2 02 00 00 64 90 3C 00 85 8E 21 18 22 02 80 20 04 00 21 20 A4 00 00 00 84 8C FF FF 42 24 F7 FF 47 14 00 00 64 A0 21 88 29 02 21 98 6A 02 ?? ?? ?? 0? 21 10 00 02 D6 FE E0 14 FF FF 02 26 5C 00 A8 8F 02 00 15 3C 1A 00 B5 26 10 00 02 8D 60 00 A3 8F 21 10 55 00 FF FF 42 30 08 00 42 24 80 10 02 00 21 10 62 00 04 00 45 8C 01 00 02 24 0B B0 46 00 21 20 A0 00 ?? ?? ?? 0? 6C 00 A5 AF 23 18 42 02 00 00 72 28 21 20 00 00 0A 20 72 00 21 90 82 00 21 50 40 00 23 10 F3 02 2B 10 42 02 75 FE 40 10 6C 00 A5 8F 26 00 20 12 00 00 00 00 14 00 60 18 30 00 02 24 F1 04 C2 13 21 20 20 02 21 30 60 00 20 00 05 24 70 00 A3 AF ?? ?? ?? 0? 74 00 AA AF 5C 00 A8 8F 70 00 A3 8F 10 00 02 8D 21 88 23 02 21 10 55 00 FF FF 42 30 60 00 A3 8F 08 00 42 24 80 10 02 00 21 10 62 00 04 00 45 8C 74 00 AA 8F D8 03 C0 12 00 00 00 00 FF FF 43 25 0B 00 40 11 FF FF 04 24 21 10 A3 00 00 00 46 90 3C 00 87 8E 21 10 23 02 80 30 06 00 21 30 E6 00 00 00 C6 8C FF FF 63 24 F7 FF 64 14 00 00 46 A0 21 88 2A 02 21 98 72 02 ?? ?? ?? 0? 21 10 00 02 90 FE E0 14 FF FF 02 26 5C 00 A8 8F 02 00 15 3C 07 00 B5 26 18 00 02 8D 60 00 A3 8F 21 10 55 00 FF FF 42 30 08 00 42 24 80 10 02 00 21 10 62 00 04 00 45 8C 01 00 02 24 0B B0 46 00 21 20 A0 00 ?? ?? ?? 0? 6C 00 A5 AF 23 18 42 02 00 00 72 28 21 20 00 00 0A 20 72 00 21 90 82 00 21 50 40 00 23 10 F3 02 2B 10 42 02 2F FE 40 10 6C 00 A5 8F E0 FF 20 12 00 00 00 00 14 00 60 18 30 00 02 24 A1 04 C2 13 21 20 20 02 21 30 60 00 20 00 05 24 70 00 A3 AF ?? ?? ?? 0? 74 00 AA AF 5C 00 A8 8F 70 00 A3 8F 18 00 02 8D 21 88 23 02 21 10 55 00 FF FF 42 30 60 00 A3 8F 08 00 42 24 80 10 02 00 21 10 62 00 04 00 45 8C 74 00 AA 8F 92 03 C0 12 00 00 00 00 FF FF 43 25 C5 FF 40 11 FF FF 04 24 21 10 A3 00 00 00 46 90 3C 00 87 8E 21 10 23 02 80 30 06 00 21 30 E6 00 00 00 C6 8C FF FF 63 24 F7 FF 64 14 00 00 46 A0 ?? ?? ?? 0? 21 88 2A 02 21 FE E0 14 21 48 00 02 FF FF 52 26 00 00 55 2A 21 28 00 00 0A 28 55 02 01 00 B5 24 23 18 F3 02 2B 18 A3 02 FC FD 60 10 00 00 00 00 0D 00 20 12 00 00 00 00 09 00 40 1A 00 00 00 00 30 00 02 24 96 04 C2 13 21 20 20 02 20 00 05 24 ?? ?? ?? 0? 21 30 40 02 00 00 02 82 21 88 32 02 00 00 22 A2 01 00 31 26 21 98 75 02 ?? ?? ?? 0? 21 10 00 02 FF FF 52 26 00 00 55 2A 21 10 00 00 0A 10 55 02 01 00 55 24 23 10 F3 02 2B 10 A2 02 E2 FD 40 10 00 00 00 00 F3 FF 20 12 00 00 00 00 09 00 40 1A 0A 00 02 24 30 00 02 24 C0 03 C2 13 21 20 20 02 20 00 05 24 21 30 40 02 ?? ?? ?? 0? 21 88 32 02 0A 00 02 24 00 00 22 A2 21 98 75 02 01 00 31 26 ?? ?? ?? 0? 21 10 00 02 45 00 02 24 14 FE E2 10 5C 00 A8 8F 02 00 0A 24 02 00 42 2A 10 00 15 8D 0A 50 42 02 ?? ?? ?? 0? 01 00 B5 26 5C 00 A2 8F 20 00 A3 27 20 00 44 24 00 00 48 8C 04 00 47 8C 08 00 46 8C 0C 00 45 8C 10 00 42 24 00 00 68 AC 04 00 67 AC 08 00 66 AC 0C 00 65 AC F6 FF 44 14 10 00 63 24 00 00 46 8C 04 00 45 8C 08 00 42 8C 20 00 A4 27 00 00 66 AC 04 00 65 AC ?? ?? ?? 0? 08 00 62 AC 58 00 A9 27 66 66 0A 3C C2 3F 02 00 21 A8 20 01 67 66 4A 25 18 00 4A 00 C3 27 02 00 FF FF B5 26 10 28 00 00 83 28 05 00 23 18 A4 00 40 30 03 00 C0 18 03 00 21 18 C3 00 23 18 43 00 23 10 03 00 0B 18 47 00 30 00 63 24 23 10 A4 00 F1 FF 40 14 00 00 A3 A2 ?? ?? ?? 0? 01 00 0A 24 60 00 A8 8F ?? ?? 04 3C ?? ?? 82 24 D0 00 03 8D 00 00 64 80 ?? ?? ?? 0? 0A 18 44 00 45 00 02 24 D7 FD E2 10 5C 00 A3 8F 02 00 0A 24 02 00 42 2A 0A 50 42 02 ?? ?? ?? 0? 0C 00 75 8C 4F 00 02 24 CF FD E2 10 45 00 02 24 85 02 E2 10 60 00 A8 8F ?? ?? ?? 0? C4 00 03 8D 5C 00 A3 8F 20 00 62 8C 22 FD 40 04 21 10 00 02 24 00 63 8C 45 03 60 04 FF FF 55 26 00 00 A9 2A 21 28 00 00 0A 28 A9 02 01 00 A9 24 23 10 F3 02 2B 10 22 01 76 FD 40 10 00 00 00 00 13 00 20 12 00 00 00 00 0F 00 A0 1A 2B 00 02 24 30 00 02 24 05 04 C2 13 21 20 20 02 20 00 05 24 21 30 A0 02 70 00 A3 AF 6C 00 A7 AF ?? ?? ?? 0? 78 00 A9 AF 78 00 A9 8F 6C 00 A7 8F 70 00 A3 8F 21 88 35 02 2B 00 02 24 00 00 22 A2 01 00 31 26 21 98 69 02 88 88 04 3C 89 88 84 34 18 00 64 00 C3 17 03 00 04 00 46 2A 04 00 0A 24 0A 50 46 02 10 28 00 00 21 18 A3 00 43 19 03 00 23 10 62 00 18 00 44 00 C3 1F 02 00 10 20 00 00 21 20 82 00 43 21 04 00 23 18 83 00 80 28 03 00 00 21 03 00 21 20 A4 00 80 19 03 00 80 30 04 00 23 28 65 00 21 20 86 00 23 10 45 00 ?? ?? ?? 0? 21 A8 82 00 45 00 02 24 4E 03 E2 10 5C 00 A4 8F 5C 00 A8 8F EB 51 03 3C 1F 85 63 34 14 00 02 8D 02 00 0A 24 02 00 46 2A 18 00 43 00 C3 27 02 00 0A 50 46 02 10 28 00 00 43 29 05 00 23 28 A4 00 80 20 05 00 00 29 05 00 21 20 85 00 80 28 04 00 21 20 85 00 23 10 44 00 64 00 42 24 18 00 43 00 C3 27 02 00 10 18 00 00 43 A9 03 00 23 A8 A4 02 80 18 15 00 00 A9 15 00 21 18 75 00 80 20 03 00 21 18 64 00 23 A8 43 00 4F 00 02 24 EB 01 E2 10 60 00 A5 8F ?? ?? ?? 0? 21 10 A0 02 45 00 02 24 63 FD E2 10 5C 00 A8 8F 49 92 04 3C 93 24 84 24 1C 00 03 8D 18 00 02 8D 02 00 0A 24 02 00 45 2A 23 10 62 00 07 00 42 24 18 00 44 00 C3 1F 02 00 0A 50 45 02 10 20 00 00 21 10 82 00 83 A8 02 00 ?? ?? ?? 0? 23 A8 A3 02 45 00 02 24 50 FD E2 10 02 00 0A 24 02 00 42 2A 0A 50 42 02 ?? ?? ?? 0? 58 00 B5 8F 45 00 02 24 49 FD E2 10 5C 00 A8 8F 02 00 0A 24 02 00 42 2A 0A 50 42 02 ?? ?? ?? 0? 08 00 15 8D 45 00 02 24 41 FD E2 10 02 00 0A 24 58 00 B5 8F 02 00 42 2A 0A 50 42 02 30 00 02 24 02 FE C2 13 5F 00 03 24 2D 00 DE 3B 2D 00 02 24 0B 10 7E 00 ?? ?? ?? 0? 21 F0 40 00 45 00 02 24 33 FD E2 10 5C 00 A3 8F 02 00 0A 24 02 00 42 2A 0A 50 42 02 ?? ?? ?? 0? 08 00 75 8C 45 00 02 24 2B FD E2 10 5C 00 A8 8F 03 00 0A 24 03 00 42 2A 1C 00 15 8D 0A 50 42 02 ?? ?? ?? 0? 01 00 B5 26 45 00 02 24 22 FD E2 10 5C 00 A8 8F 02 00 0A 24 02 00 42 2A 0C 00 15 8D ?? ?? ?? 0? 0A 50 42 02 ?? ?? ?? 0? 21 18 00 00 4F 00 02 24 18 FD E2 10 45 00 02 24 D5 01 E2 10 60 00 A8 8F ?? ?? ?? 0? C8 00 03 8D 45 00 02 24 11 FD E2 10 5C 00 A3 8F 01 00 0A 24 2A 10 12 00 0B 50 42 02 ?? ?? ?? 0? 18 00 75 8C 5C 00 A3 8F 49 92 04 3C 93 24 84 24 18 00 62 8C 01 00 0A 24 2A 28 12 00 06 00 42 24 18 00 44 00 C3 1F 02 00 0B 50 45 02 10 20 00 00 21 20 82 00 83 20 04 00 23 18 83 00 C0 20 03 00 23 18 83 00 23 10 43 00 ?? ?? ?? 0? 01 00 55 24 FF FF 52 26 00 00 55 2A 21 10 00 00 0A 10 55 02 01 00 55 24 23 10 F3 02 2B 10 A2 02 AA FC 40 10 00 00 00 00 BB FE 20 12 00 00 00 00 09 00 40 1A 09 00 02 24 30 00 02 24 94 02 C2 13 21 20 20 02 20 00 05 24 21 30 40 02 ?? ?? ?? 0? 21 88 32 02 09 00 02 24 00 00 22 A2 ?? ?? ?? 0? 01 00 31 26 64 00 A8 8F 2B 18 06 00 68 00 A3 AF 04 00 00 11 0B B0 06 00 00 00 02 81 11 00 40 14 00 00 00 00 5C 00 A3 8F 20 00 62 8C 0A 00 40 04 B8 00 A4 8F 00 00 83 90 DE 02 60 10 00 00 00 00 ?? ?? 05 3C }
	condition:
		$1
}

rule file_222_1_0 {
	meta:
		name = "__strftime_l"
		size = 44
		altNames = "__wcsftime_l"
	strings:
		$1 = { D0 FF BD 27 20 00 A2 27 10 00 A2 AF 40 00 A2 8F 2C 00 BF AF 20 00 A0 A3 ?? ?? ?? 0? 14 00 A2 AF 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "__atomic_preadv64_replacement"
		size = 516
		refs = "0004 __gnu_local_gp 00d8 __libc_pread64 0120 memcpy 0138 free 0180 __libc_errno 01dc __libc_alloca_cutoff 01ec malloc"
	strings:
		$1 = { B0 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 48 00 BE AF 21 F0 A0 03 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF 4C 00 BF AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 28 00 B0 AF 18 00 DC AF 21 88 C0 00 21 98 80 00 63 00 C0 18 21 90 A0 00 04 00 A2 8C 00 80 03 3C 2B 18 43 00 47 00 60 10 FF 7F 06 3C 21 38 A0 00 21 18 00 00 21 80 00 00 ?? ?? ?? 0? FF FF C6 34 04 00 E2 8C 2B 40 02 01 3E 00 00 15 00 00 00 00 21 80 02 02 01 00 63 24 08 00 E7 24 F8 FF 71 14 23 40 D0 00 01 80 02 34 2B 10 02 02 4E 00 40 10 00 00 00 00 0E 00 02 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 18 00 B5 27 21 A0 00 00 60 00 C8 8F 64 00 C9 8F 21 20 60 02 10 00 A8 AF 14 00 A9 AF 21 28 A0 02 ?? ?? ?? 0? 21 30 00 02 3A 00 40 04 21 B8 40 00 11 00 20 1A 21 80 40 00 ?? ?? ?? 0? 21 B0 00 00 0D 00 D1 12 08 00 52 26 04 00 42 8E 00 00 44 8E 21 28 A0 02 2B 98 02 02 0B 10 13 02 21 98 40 00 21 30 40 00 23 80 02 02 ?? ?? ?? 0? 01 00 D6 26 F3 FF 00 16 21 A8 B3 02 21 10 E0 02 21 20 80 02 ?? ?? ?? 0? 20 00 C2 AF 21 E8 C0 03 4C 00 BF 8F 20 00 C2 8F 44 00 B7 8F 48 00 BE 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC 21 E8 C0 03 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F FF FF 02 24 08 00 E0 03 50 00 BD 27 21 A0 00 00 ?? ?? ?? 0? FF FF 02 24 ?? ?? ?? 0? 21 80 00 00 ?? ?? ?? 0? 21 20 00 02 B1 FF 40 14 0E 00 02 26 ?? ?? ?? 0? 21 20 00 02 F4 FF 40 10 21 A8 40 00 ?? ?? ?? 0? 21 A0 40 00 }
	condition:
		$1
}

rule file_223_1_0 {
	meta:
		name = "preadv64"
		size = 392
		refs = "0004 __gnu_local_gp 008c __libc_errno 00cc __libc_enable_asynccancel 0130 __libc_disable_asynccancel"
	strings:
		$1 = { B8 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 40 00 BE AF 21 F0 A0 03 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF 44 00 BF AF 28 00 B0 AF 18 00 DC AF 21 A0 80 00 21 98 A0 00 21 90 C0 00 58 00 D5 8F 5C 00 D1 8F 3B E8 03 7C 70 8B 62 8C 1E 00 40 14 00 00 00 00 F0 FF BD 27 18 00 A2 27 24 00 C2 AF 21 38 A0 02 E0 FF BD 27 10 00 B1 AF EA 10 02 24 0C 00 00 00 20 00 BD 27 2F 00 E0 10 21 80 40 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 20 00 02 21 10 62 00 00 00 50 AC FF FF 10 24 59 00 03 24 27 00 83 14 21 10 00 02 10 00 B5 AF 14 00 B1 AF 21 20 80 02 21 28 60 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 21 E8 C0 03 ?? ?? ?? 0? 00 00 00 00 F0 FF BD 27 18 00 A3 27 18 00 DC 8F 21 F8 40 00 20 00 C3 AF 21 20 80 02 21 28 60 02 21 30 40 02 21 38 A0 02 E0 FF BD 27 10 00 B1 AF EA 10 02 24 0C 00 00 00 20 00 BD 27 07 00 E0 10 21 80 40 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 50 AC FF FF 10 24 21 20 E0 03 ?? ?? ?? 0? 00 00 00 00 18 00 DC 8F 0C 00 00 06 21 10 00 02 21 E8 C0 03 44 00 BF 8F 40 00 BE 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 48 00 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 ?? ?? ?? 0? 00 00 44 8C }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "__wcsncpy"
		size = 296
	strings:
		$1 = { 21 10 80 00 04 00 C4 2C 21 00 80 14 FC FF 43 24 ?? ?? ?? 0? 82 38 06 00 04 00 A8 8C 30 00 00 11 08 00 68 AC 10 00 A5 24 F8 FF A8 8C 35 00 00 11 0C 00 68 AC FC FF A8 8C 10 00 63 24 08 00 00 11 00 00 68 AC 12 00 E0 10 00 00 00 00 00 00 A8 8C FF FF E7 24 F0 FF 00 15 04 00 68 AC 04 00 63 24 23 20 62 00 FF FF C6 24 83 20 04 00 23 30 C4 00 19 00 C0 10 00 00 00 00 04 00 63 24 FF FF C6 24 FD FF C0 14 00 00 60 AC 08 00 E0 03 00 00 00 00 03 00 C6 30 FC FF C0 10 04 00 A5 24 FC FF A7 8C 04 00 63 24 FF FF C6 24 F7 FF C0 10 00 00 67 AC F1 FF E0 10 00 00 00 00 04 00 A5 24 FC FF A7 8C 04 00 63 24 FF FF C6 24 F9 FF C0 14 00 00 67 AC 08 00 E0 03 00 00 00 00 08 00 E0 03 00 00 00 00 08 00 63 24 23 20 62 00 FF FF C6 24 83 20 04 00 23 30 C4 00 E0 FF C0 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 0C 00 63 24 23 20 62 00 FF FF C6 24 83 20 04 00 23 30 C4 00 D7 FF C0 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_225_0_0 {
	meta:
		name = "__wcschrnul"
		size = 68
	strings:
		$1 = { 00 00 83 8C 0B 00 60 10 21 10 80 00 06 00 65 14 04 00 42 24 08 00 E0 03 FC FF 42 24 07 00 65 10 00 00 00 00 04 00 42 24 00 00 43 8C FB FF 60 14 00 00 00 00 08 00 E0 03 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_226_0_0 {
	meta:
		name = "timerfd_create"
		size = 28
	strings:
		$1 = { E1 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "lrand48_r"
		size = 24
		refs = "0008 __nrand48_r"
	strings:
		$1 = { 03 00 80 10 21 30 A0 00 ?? ?? ?? 0? 21 28 80 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_1019_0_0 {
	meta:
		name = "mrand48_r"
		size = 24
		refs = "0008 __jrand48_r"
	strings:
		$1 = { 03 00 80 10 21 30 A0 00 ?? ?? ?? 0? 21 28 80 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "getw"
		size = 56
		refs = "0014 _IO_fread"
	strings:
		$1 = { D8 FF BD 27 21 38 80 00 04 00 05 24 18 00 A4 27 24 00 BF AF ?? ?? ?? 0? 01 00 06 24 01 00 03 24 02 00 43 14 FF FF 02 24 18 00 A2 8F 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "__dcgettext"
		size = 40
		refs = "0014 __dcigettext"
	strings:
		$1 = { D8 FF BD 27 21 38 00 00 14 00 A6 AF 10 00 A0 AF 24 00 BF AF ?? ?? ?? 0? 21 30 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "tcsendbreak"
		size = 56
		refs = "0024 __ioctl"
	strings:
		$1 = { 0A 00 A0 18 EB 51 06 3C 63 00 A5 24 1F 85 C6 34 18 00 A6 00 C3 17 05 00 86 54 05 24 10 30 00 00 43 31 06 00 ?? ?? ?? 0? 23 30 C2 00 05 54 05 24 ?? ?? ?? 0? 21 30 00 00 }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "_IO_mem_sync"
		size = 108
		refs = "0054 _IO_str_overflow"
	strings:
		$1 = { 14 00 82 8C 18 00 83 8C E0 FF BD 27 18 00 B0 AF 1C 00 BF AF 0F 00 43 10 21 80 80 00 00 00 40 A0 A8 00 03 8E 10 00 04 8E 1C 00 BF 8F 21 10 00 00 00 00 64 AC 14 00 05 8E 10 00 04 8E AC 00 03 8E 18 00 B0 8F 23 20 A4 00 00 00 64 AC 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? 21 28 00 00 14 00 02 8E FF FF 42 24 ?? ?? ?? 0? 14 00 02 AE }
	condition:
		$1
}

rule file_234_1_0 {
	meta:
		name = "_IO_mem_finish"
		size = 140
		refs = "0028 realloc 0084 _IO_str_finish"
	strings:
		$1 = { 10 00 82 8C 14 00 83 8C D8 FF BD 27 20 00 B1 AF 23 28 62 00 A8 00 91 8C 1C 00 B0 AF 01 00 A5 24 21 80 80 00 24 00 BF AF ?? ?? ?? 0? 21 20 40 00 00 00 22 AE A8 00 02 8E 00 00 42 8C 0D 00 40 10 24 00 BF 8F 14 00 04 8E 10 00 03 8E 23 18 83 00 21 10 43 00 00 00 40 A0 14 00 04 8E 10 00 03 8E AC 00 02 8E 23 18 83 00 00 00 43 AC 1C 00 00 AE 24 00 BF 8F 20 00 B1 8F 21 20 00 02 1C 00 B0 8F 21 28 00 00 ?? ?? ?? 0? 28 00 BD 27 }
	condition:
		$1
}

rule file_234_2_0 {
	meta:
		name = "open_memstream"
		size = 208
		refs = "0020 malloc 003c calloc 0050 _IO_init 0070 _IO_str_init_static_internal 0098 free"
	strings:
		$1 = { D0 FF BD 27 28 00 B3 AF 21 98 80 00 78 01 04 24 24 00 B2 AF 1C 00 B0 AF 2C 00 BF AF 20 00 B1 AF ?? ?? ?? 0? 21 90 A0 00 27 00 40 10 21 80 40 00 B0 00 42 24 01 00 04 24 00 20 05 24 ?? ?? ?? 0? 48 00 02 AE 20 00 40 10 21 88 40 00 21 20 00 02 ?? ?? ?? 0? 21 28 00 00 ?? ?? 02 3C ?? ?? 42 24 21 28 20 02 21 20 00 02 00 20 06 24 21 38 20 02 ?? ?? ?? 0? 98 00 02 AE 00 00 03 8E FE FF 02 24 A8 00 13 AE 24 10 62 00 00 00 02 AE ?? ?? 02 3C ?? ?? 42 24 A0 00 02 AE ?? ?? 02 3C ?? ?? 42 24 A4 00 02 AE AC 00 12 AE 21 10 00 02 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "__getrusage"
		size = 28
	strings:
		$1 = { ED 0F 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_236_0_0 {
	meta:
		name = "profil_count"
		size = 392
	strings:
		$1 = { ?? ?? 03 3C ?? ?? 6A 24 08 00 42 8D 10 00 46 8C 2B 30 86 00 06 00 C0 14 ?? ?? 67 8C 14 00 47 8C 2B 38 87 00 1D 00 E0 14 21 30 40 00 ?? ?? 67 8C 04 00 49 8D 21 18 00 00 ?? ?? ?? 0? FF FF E7 24 14 00 C8 8C 01 00 43 24 2B 10 88 00 2A 00 40 14 00 00 00 00 2B 10 E3 00 0F 00 40 14 00 00 00 00 21 10 67 00 42 10 02 00 40 41 02 00 C0 30 02 00 23 30 06 01 21 30 26 01 10 00 C8 8C 2B 40 88 00 EF FF 00 11 00 00 00 00 FF FF 47 24 2B 10 E3 00 F4 FF 40 10 21 10 67 00 0C 00 42 8D 00 00 43 8C 08 00 42 8C 1D 00 A0 10 23 20 83 00 82 20 04 00 19 00 82 00 04 00 C4 8C 12 10 00 00 02 14 02 00 10 18 00 00 00 1C 03 00 25 10 62 00 2B 18 44 00 0C 00 60 10 80 10 02 00 0C 00 C3 8C FF FF 04 24 21 18 62 00 00 00 62 8C 25 00 44 10 01 00 42 24 08 00 E0 03 00 00 62 AC 08 00 46 AD ?? ?? ?? 0? 0C 00 42 8D 0C 00 42 8D 0C 00 42 8C 00 00 43 8C 01 00 63 24 08 00 E0 03 00 00 43 AC 42 20 04 00 19 00 82 00 04 00 C4 8C 12 10 00 00 02 14 02 00 10 18 00 00 00 1C 03 00 25 10 62 00 2B 18 44 00 09 00 60 10 40 10 02 00 0C 00 C3 8C FF FF 04 34 21 18 62 00 00 00 62 94 09 00 44 10 01 00 42 24 08 00 E0 03 00 00 62 A4 0C 00 42 8D 0C 00 42 8C 00 00 43 94 01 00 63 24 08 00 E0 03 00 00 43 A4 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_236_1_0 {
	meta:
		name = "profil_counter_ushort"
		size = 32
	strings:
		$1 = { 08 00 C4 8C E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 21 28 00 00 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_236_2_0 {
	meta:
		name = "profil_counter_uint"
		size = 32
	strings:
		$1 = { 08 00 C4 8C E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 01 00 05 24 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_236_3_0 {
	meta:
		name = "pcmp"
		size = 44
	strings:
		$1 = { 00 00 83 8C 00 00 A5 8C 08 00 64 8C 08 00 A3 8C 2B 28 83 00 03 00 A0 14 01 00 02 24 2B 10 64 00 23 10 02 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_236_4_0 {
	meta:
		name = "insert.part.0"
		size = 380
		refs = "003c malloc 010c realloc 0164 memmove"
	strings:
		$1 = { C8 FF BD 27 1C 00 B0 AF ?? ?? 10 3C ?? ?? 02 8E 30 00 B5 AF 2C 00 B4 AF 28 00 B3 AF 20 00 B1 AF 34 00 BF AF 24 00 B2 AF 21 98 80 00 21 A8 A0 00 21 A0 C0 00 30 00 40 14 21 88 E0 00 ?? ?? ?? 0? 18 00 04 24 21 90 40 00 22 00 40 12 FF FF 02 24 ?? ?? 02 8E 23 18 53 00 39 00 60 14 C0 30 03 00 C0 18 13 00 40 21 13 00 23 20 83 00 21 20 44 02 48 00 A7 8F 04 00 25 8E 02 00 06 24 04 00 03 24 0A 18 C7 00 1B 00 A3 00 F4 01 60 00 00 00 29 8E 08 00 25 8E 0C 00 27 8E 01 00 42 24 ?? ?? 08 26 00 00 85 AC 08 00 87 AC ?? ?? 02 AE 0C 00 89 AC 10 00 95 AC 14 00 94 AC 21 10 00 00 12 18 00 00 04 00 83 AC 03 00 A0 14 04 00 12 AD 13 00 E6 10 34 00 BF 8F 34 00 BF 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? 03 26 01 00 42 24 04 00 64 8C C0 28 02 00 40 11 02 00 ?? ?? ?? 0? 23 28 45 00 ?? ?? ?? 0? 21 90 40 00 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 20 00 B1 8F 1C 00 B0 8F 0C 00 12 AD 24 00 B2 8F 08 00 E0 03 38 00 BD 27 01 00 73 26 C0 10 13 00 40 99 13 00 23 20 62 02 E8 FF 93 24 21 98 53 02 40 19 03 00 21 20 44 02 21 28 60 02 ?? ?? ?? 0? 23 30 66 00 ?? ?? 02 3C ?? ?? 42 8C ?? ?? ?? 0? 21 20 60 02 }
	condition:
		$1
}

rule file_236_5_0 {
	meta:
		name = "__sprofil"
		size = 1240
		refs = "005c __profile_frequency 010c qsort 016c __udivdi3 028c free 036c __sigaction 0398 __setitimer 04b8 $LC0 04bc $LC1 04d0 __assert_fail 04c0 __PRETTY_FUNCTION__.4919"
	strings:
		$1 = { 80 10 05 00 0A 00 42 24 C2 10 02 00 00 FF BD 27 C0 10 02 00 F8 00 BE AF EC 00 B5 AF 21 F0 A0 03 DC 00 B1 AF D8 00 B0 AF FC 00 BF AF F4 00 B7 AF F0 00 B6 AF E8 00 B4 AF E4 00 B3 AF E0 00 B2 AF 23 E8 A2 03 04 01 C5 AF 21 88 C0 00 21 80 80 00 0C 01 C7 AF 17 00 C0 10 18 00 B5 27 ?? ?? ?? 0? 00 00 00 00 0F 00 03 3C 40 42 63 24 1A 00 62 00 F4 01 40 00 1B 43 03 3C 83 DE 63 34 12 10 00 00 19 00 43 00 10 18 00 00 82 1C 03 00 00 2A 03 00 C0 20 03 00 23 20 A4 00 80 29 04 00 23 20 A4 00 21 20 83 00 80 21 04 00 23 10 44 00 00 00 23 AE 04 00 22 AE ?? ?? 17 3C ?? ?? E2 8E D5 00 40 14 ?? ?? 02 3C ?? ?? F2 26 ?? ?? 42 24 0C 00 42 AE 04 01 C2 8F F0 00 40 18 04 00 40 AE 00 31 02 00 21 18 A0 02 21 10 00 00 21 28 02 02 10 00 42 24 00 00 65 AC FC FF 46 14 04 00 63 24 04 01 C5 8F ?? ?? 07 3C 21 20 A0 02 04 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 0C 01 C2 8F 04 00 03 24 C4 00 C0 AF 01 00 53 30 02 00 02 24 0A 18 53 00 C0 00 C3 AF 00 00 B1 8E 0C 00 28 8E 02 00 02 2D 70 00 40 14 C4 00 C2 8F A3 00 60 12 04 00 25 8E 08 00 29 8E 82 58 05 00 80 24 0B 00 21 30 00 01 02 2C 05 00 21 38 00 00 C8 00 C8 AF CC 00 C9 AF ?? ?? ?? 0? D0 00 CB AF CC 00 C9 8F C8 00 C8 8F D0 00 CB 8F 21 80 49 00 04 00 04 24 1B 00 44 00 F4 01 80 00 27 18 09 00 12 20 00 00 19 00 88 00 10 28 00 00 00 14 05 00 12 20 00 00 02 24 04 00 25 20 44 00 2B 20 8B 00 21 80 04 02 21 20 70 00 C0 00 C3 8F 1B 00 83 00 F4 01 60 00 12 20 00 00 19 00 88 00 12 20 00 00 02 24 04 00 10 28 00 00 00 14 05 00 25 20 44 00 2B 20 8B 00 B3 00 80 10 23 10 09 02 1B 00 43 00 F4 01 60 00 12 10 00 00 19 00 48 00 12 10 00 00 02 14 02 00 10 18 00 00 00 1C 03 00 25 10 62 00 2B 10 4B 00 A7 00 40 14 ?? ?? E2 8E 2D 00 40 10 21 20 00 00 04 00 45 8E 21 B0 00 00 ?? ?? ?? 0? 21 A0 00 00 04 00 45 8E 21 10 B6 00 01 00 94 26 14 00 49 8C 2B 10 84 02 21 00 40 10 18 00 D6 26 21 10 B6 00 10 00 46 8C 2B 20 26 01 F7 FF 80 10 ?? ?? E4 8E 2B 10 06 02 19 00 40 14 21 20 80 02 10 00 B3 AF 21 28 20 01 ?? ?? ?? 0? 21 38 20 02 EC FF 41 04 ?? ?? E4 8E ?? ?? ?? 0? 04 00 44 8E ?? ?? E0 AE 04 00 40 AE FF FF 02 24 21 E8 C0 03 FC 00 BF 8F F8 00 BE 8F F4 00 B7 8F F0 00 B6 8F EC 00 B5 8F E8 00 B4 8F E4 00 B3 8F E0 00 B2 8F DC 00 B1 8F D8 00 B0 8F 08 00 E0 03 00 01 BD 27 21 20 80 02 2B 10 30 01 08 00 40 10 C4 00 C2 8F 10 00 B3 AF 21 28 20 01 21 30 00 02 ?? ?? ?? 0? 21 38 20 02 E4 FF 40 04 C4 00 C2 8F 04 01 C3 8F 04 00 B5 26 01 00 42 24 88 FF 43 14 C4 00 C2 AF ?? ?? E3 8E E1 FF 60 10 21 10 00 00 0C 01 C4 8F 04 00 43 8E 01 00 82 30 56 00 40 14 08 00 43 AE ?? ?? 02 3C ?? ?? 42 24 24 00 C2 AF 00 10 02 3C 20 00 C2 AF 24 00 C4 27 A4 00 C2 27 FF FF 03 24 00 00 43 AC FC FF 42 24 FD FF 44 14 ?? ?? 06 3C 1D 00 04 24 20 00 C5 27 ?? ?? ?? 0? ?? ?? C6 24 C9 FF 40 04 ?? ?? 06 3C 01 00 02 24 B0 00 C5 27 02 00 04 24 ?? ?? C6 24 B8 00 C0 AF BC 00 C2 AF B0 00 C0 AF ?? ?? ?? 0? B4 00 C2 AF 21 E8 C0 03 FC 00 BF 8F F8 00 BE 8F F4 00 B7 8F F0 00 B6 8F EC 00 B5 8F E8 00 B4 8F E4 00 B3 8F E0 00 B2 8F DC 00 B1 8F D8 00 B0 8F 08 00 E0 03 00 01 BD 27 08 00 29 8E 42 58 05 00 40 24 0B 00 21 30 00 01 02 2C 05 00 21 38 00 00 C8 00 C8 AF CC 00 C9 AF ?? ?? ?? 0? D0 00 CB AF CC 00 C9 8F 02 00 04 24 C8 00 C8 8F 21 80 49 00 ?? ?? ?? 0? D0 00 CB 8F ?? ?? 05 3C 02 00 04 24 ?? ?? A5 24 ?? ?? ?? 0? 21 30 00 00 9C FF 40 04 ?? ?? 05 3C 1D 00 04 24 ?? ?? A5 24 ?? ?? ?? 0? 21 30 00 00 96 FF 40 04 ?? ?? EA 26 ?? ?? ?? 0? 04 00 44 8D 21 E8 C0 03 FC 00 BF 8F F8 00 BE 8F F4 00 B7 8F F0 00 B6 8F EC 00 B5 8F E8 00 B4 8F E4 00 B3 8F E0 00 B2 8F DC 00 B1 8F D8 00 B0 8F 21 10 00 00 08 00 E0 03 00 01 BD 27 ?? ?? 02 3C ?? ?? 42 24 ?? ?? ?? 0? 24 00 C2 AF 04 01 C5 8F ?? ?? 07 3C 21 20 A0 02 04 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? ?? 0? ?? ?? E3 8E ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 65 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "__memrchr"
		size = 320
	strings:
		$1 = { FF 00 A3 30 12 00 C0 10 21 10 86 00 03 00 44 30 19 00 80 10 00 00 00 00 FF FF 44 90 09 00 83 14 FF FF 42 24 ?? ?? ?? 0? 00 00 00 00 12 00 80 10 00 00 00 00 FF FF 42 24 00 00 44 90 3E 00 83 10 00 00 00 00 FF FF C6 24 F8 FF C0 14 03 00 44 30 21 30 00 00 23 30 46 00 2F 00 46 10 00 00 00 00 FF FF 42 24 00 00 44 90 FB FF 83 14 00 00 00 00 08 00 E0 03 00 00 00 00 FF 00 A5 30 00 52 05 00 25 28 45 01 00 54 05 00 04 00 C4 2C F1 FF 80 14 25 50 45 01 FE 7E 09 3C 01 81 08 3C FF FE 29 35 00 01 08 25 FC FF 42 24 00 00 44 8C FC FF C6 24 26 20 44 01 27 28 04 00 21 20 89 00 26 20 A4 00 24 20 88 00 0F 00 80 10 04 00 C7 2C 03 00 44 90 13 00 83 10 00 00 00 00 02 00 44 90 12 00 83 10 00 00 00 00 01 00 44 90 11 00 83 10 00 00 00 00 00 00 44 90 03 00 83 14 00 00 00 00 08 00 E0 03 00 00 00 00 E8 FF E0 10 FC FF 42 24 04 00 42 24 ?? ?? ?? 0? 23 30 46 00 08 00 E0 03 21 10 00 00 08 00 E0 03 03 00 42 24 08 00 E0 03 02 00 42 24 08 00 E0 03 01 00 42 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "rewinddir"
		size = 192
		refs = "0040 __lseek 008c __lll_lock_wait_private"
	strings:
		$1 = { D8 FF BD 27 20 00 B1 AF 1C 00 B0 AF 21 88 80 00 04 00 90 24 24 00 BF AF 00 00 02 C2 01 00 41 24 00 00 01 E2 FC FF 20 10 00 00 00 00 0F 00 00 00 16 00 40 14 00 00 00 00 00 00 24 8E 21 28 00 00 ?? ?? ?? 0? 21 30 00 00 14 00 20 AE 10 00 20 AE 0C 00 20 AE 0F 00 00 00 00 00 02 C2 00 00 01 24 00 00 01 E2 FC FF 20 10 00 00 00 00 02 00 42 28 0A 00 40 10 21 20 00 02 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 00 00 24 8E 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 24 00 BF 8F }
	condition:
		$1
}

rule file_239_0_0 {
	meta:
		name = "__fgets_unlocked_chk"
		size = 284
		refs = "0004 __gnu_local_gp 0064 _IO_getline 00b8 __libc_errno 0114 __chk_fail"
	strings:
		$1 = { 42 00 C0 18 ?? ?? 1C 3C 00 00 E2 8C C8 FF BD 27 28 00 B1 AF 21 88 80 00 DF FF 04 24 ?? ?? 9C 27 24 20 44 00 FF FF C6 24 30 00 B3 AF 2C 00 B2 AF 24 00 B0 AF 18 00 BC AF 2B 18 A6 00 34 00 BF AF 21 90 A0 00 00 00 E4 AC 01 00 04 24 21 80 E0 00 10 00 A4 AF 21 28 20 02 21 20 E0 00 0B 30 43 02 0A 00 07 24 ?? ?? ?? 0? 20 00 53 30 18 00 BC 8F 0C 00 40 14 00 00 04 8E 34 00 BF 8F 25 20 93 00 21 88 00 00 00 00 04 AE 21 10 20 02 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 20 00 83 30 09 00 60 10 00 00 00 00 3B E8 03 7C 21 28 60 00 ?? ?? 83 8F 21 28 65 00 00 00 A5 8C 0B 00 03 24 EC FF A3 14 34 00 BF 8F 2B 90 52 00 0F 00 40 12 21 10 22 02 00 00 40 A0 00 00 04 8E 34 00 BF 8F 21 10 20 02 25 20 93 00 00 00 04 AE 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 08 00 E0 03 21 10 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "ntp_gettimex"
		size = 100
		refs = "0014 __adjtimex"
	strings:
		$1 = { 60 FF BD 27 98 00 B0 AF 21 80 80 00 18 00 A4 27 9C 00 BF AF ?? ?? ?? 0? 18 00 A0 AF 3C 00 A3 8F 9C 00 BF 8F 14 00 00 AE 00 00 03 AE 40 00 A3 8F 18 00 00 AE 1C 00 00 AE 04 00 03 AE 24 00 A3 8F 20 00 00 AE 08 00 03 AE 28 00 A3 8F 0C 00 03 AE 68 00 A3 8F 10 00 03 AE 98 00 B0 8F 08 00 E0 03 A0 00 BD 27 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "__stpcpy"
		size = 44
	strings:
		$1 = { ?? ?? ?? 0? 21 10 80 00 21 10 60 00 00 00 A4 80 01 00 A5 24 00 00 44 A0 FF FF A4 80 FA FF 80 14 01 00 43 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "_dl_build_local_scope"
		size = 160
	strings:
		$1 = { D8 FF BD 27 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 24 00 BF AF 00 00 85 AC 68 02 A2 8C C8 02 B0 8C 01 00 03 24 44 31 62 7C 21 90 80 00 04 00 91 24 13 00 00 12 68 02 A2 AC 04 00 05 8E 06 00 A0 14 04 00 10 26 ?? ?? ?? 0? 24 00 BF 8F 00 00 05 8E 0C 00 A0 10 24 00 BF 8F 68 02 A2 8C 60 00 42 30 FA FF 40 14 04 00 10 26 ?? ?? ?? 0? 21 20 20 02 00 00 05 8E 80 10 02 00 F7 FF A0 14 21 88 22 02 24 00 BF 8F 23 10 32 02 18 00 B0 8F 20 00 B2 8F 1C 00 B1 8F 83 10 02 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_242_1_0 {
	meta:
		name = "openaux"
		size = 84
		refs = "0038 _dl_map_object"
	strings:
		$1 = { D8 FF BD 27 20 00 B0 AF 21 80 80 00 08 00 03 8E 00 00 84 8C 10 00 05 8E 01 00 06 24 68 02 82 8C 10 00 A3 AF 18 00 83 8C 04 00 07 8E 03 00 48 30 14 00 A3 AF 24 00 BF AF ?? ?? ?? 0? 0B 30 08 01 24 00 BF 8F 14 00 02 AE 20 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_242_2_0 {
	meta:
		name = "_dl_map_object_deps"
		size = 4424
		refs = "001c __gnu_local_gp 00dc __libc_errno 019c strchr 01c8 _dl_catch_error 0228 malloc 0248 memcpy 03a8 strlen 04ec _dl_debug_mask 060c memset 07a0 memmove 0814 _dl_scope_free 09a8 _dl_dst_count 09b8 __libc_enable_secure 09f0 _dl_platformlen 0a44 _dl_dst_substitute 0b38 $LC4 0b40 _dl_debug_printf 0b68 _dl_get_origin 0b9c _dl_signal_error 09c4 $LC1 0bb0 $LC9 0bb4 $LC3 0bc8 __assert_fail 0bb8 __PRETTY_FUNCTION__.8921 0be8 $LC8 0b64 $LC2 0c80 free 0cf4 $LC5 0d88 _dl_argv 0d84 $LC6 0d9c $LC0 0de4 $LC13 04fc _dl_ns 0eb0 $LC12 0f78 $LC11 0f90 $LC10 102c $LC7"
	strings:
		$1 = { 80 10 06 00 00 41 06 00 23 40 02 01 26 00 02 25 C2 10 02 00 50 FF BD 27 C0 10 02 00 ?? ?? 1C 3C A8 00 BE AF AC 00 BF AF A4 00 B7 AF A0 00 B6 AF 9C 00 B5 AF 98 00 B4 AF 94 00 B3 AF 90 00 B2 AF 8C 00 B1 AF 88 00 B0 AF 21 F0 A0 03 23 E8 A2 03 18 00 A9 27 24 00 A2 27 ?? ?? 9C 27 18 00 DC AF 60 00 C9 AF B0 00 C4 AF 18 00 A0 AF 1C 00 A4 AF 20 00 A2 AF 68 02 82 8C 01 00 03 24 BC 00 C7 AF 44 31 62 7C 18 00 09 25 D1 02 C0 10 68 02 82 AC 60 00 C3 8F 21 20 A0 00 01 00 07 24 18 00 62 24 21 48 69 00 00 00 83 8C F4 FF 40 AC FC FF 42 AC F8 FF 43 AC 68 02 65 8C 0C 00 42 24 04 00 84 24 44 31 E5 7C F7 FF 49 14 68 02 65 AC 60 00 C9 8F 01 00 C6 24 4C 00 C6 AF 04 00 32 8D ?? ?? 89 8F 3B E8 03 7C 3C 00 C0 AF 74 00 C9 AF 60 00 C9 8F 6C 00 C0 AF 68 00 C0 AF 21 40 28 01 74 00 C9 8F 08 00 00 AD 48 00 C8 AF 21 10 23 01 00 00 49 8C 00 00 40 AC 30 02 42 8E 70 00 C9 AF 60 00 C9 8F 01 00 03 24 ?? ?? 17 3C 58 00 C9 AF 58 00 C9 8F 21 A0 00 00 77 00 40 10 00 00 23 AD 24 00 42 8E 91 00 40 10 00 00 00 00 34 00 42 8E 08 00 51 8E BC 00 C9 8F 00 00 55 8E 04 00 43 8C 00 00 22 8E 24 00 C9 AF C0 00 C9 8F 21 A8 A3 02 20 00 D2 AF 2C 00 D5 AF 8A 00 40 10 28 00 C9 AF 58 00 C3 8F 21 98 00 00 54 00 C3 AF 01 00 03 24 BB 01 43 14 24 00 05 24 04 00 30 8E 21 80 B0 02 ?? ?? ?? 0? 21 20 00 02 00 02 40 14 21 20 40 00 20 00 C2 27 ?? ?? 07 3C 30 00 D0 AF 38 00 C4 27 10 00 A2 AF 3C 00 C5 27 40 00 C6 27 ?? ?? ?? 0? ?? ?? E7 24 3C 00 D0 8F 74 00 00 16 21 20 00 02 34 00 C2 8F 68 02 43 8C 60 00 63 30 32 00 60 10 48 00 C9 8F 04 00 80 12 80 18 13 00 21 18 83 02 00 00 62 AC 01 00 73 26 08 00 31 26 00 00 22 8E DF FF 40 14 01 00 03 24 19 00 80 12 80 88 13 00 21 10 91 02 C0 20 13 00 00 00 40 AC ?? ?? ?? 0? 0C 00 84 24 6C 02 40 10 21 80 40 00 04 00 33 26 21 28 80 02 21 30 60 02 04 00 44 24 ?? ?? ?? 0? 00 00 52 AC 08 00 24 26 21 20 04 02 21 28 00 02 ?? ?? ?? 0? 21 30 60 02 0F 00 00 00 68 02 42 8E 01 00 03 24 C8 02 50 AE 04 84 62 7C 68 02 42 AE 58 00 C3 8F 00 00 62 8C 1D 00 40 10 58 00 C9 8F ?? ?? ?? 0? 58 00 C2 8F 00 00 43 8C 15 00 60 10 00 00 00 00 08 00 42 8C FB FF 40 14 21 B0 00 00 ?? ?? ?? 0? 74 00 C9 8F E8 FF BD 27 18 00 A3 27 1C 00 A2 AF 18 00 A0 AF 20 00 A0 AF 08 00 23 AD 68 02 44 8C 4C 00 C9 8F 01 00 05 24 44 31 A4 7C 01 00 29 25 4C 00 C9 AF 68 02 44 AC ?? ?? ?? 0? 48 00 C3 AF 58 00 C2 AF 58 00 C3 8F 58 00 C9 8F 21 A0 00 00 04 00 72 8C 01 00 03 24 30 02 42 8E 8B FF 40 14 00 00 23 AD C8 02 42 8E 88 FF 40 14 00 00 00 00 B0 00 C9 8F 85 FF 32 11 00 00 00 00 2E 02 42 96 82 FF 40 10 80 10 02 00 6C 00 C9 8F 2B 18 22 01 7E FF 60 10 68 00 D4 8F F0 FF 03 24 0F 00 42 24 24 10 43 00 0E 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 68 00 C9 8F 18 00 B4 27 21 18 82 02 13 03 23 11 00 00 00 00 6C 00 C2 AF 24 00 42 8E 71 FF 40 14 68 00 D4 AF C4 01 42 8E 6E FF 40 14 00 00 00 00 BC 01 42 8E 6B FF 40 14 00 00 00 00 ?? ?? ?? 0? 21 98 00 00 ?? ?? ?? 0? 21 B0 40 00 0F 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 A4 27 21 28 00 02 ?? ?? ?? 0? 01 00 46 24 38 00 D2 8F 21 88 40 00 ?? ?? ?? 0? 21 20 40 02 0F 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 A4 27 21 28 40 02 ?? ?? ?? 0? 01 00 46 24 40 00 C3 93 EA 02 60 14 38 00 C2 AF FF FF 02 24 3C 00 D1 AF 0A B0 56 00 74 00 C9 8F 3B E8 03 7C 21 10 23 01 00 00 43 8C 06 00 60 14 B0 00 C9 8F 70 00 C9 8F 02 00 20 11 00 00 00 00 00 00 49 AC B0 00 C9 8F C8 02 29 8D 08 00 20 11 50 00 C9 AF B0 00 C9 8F 02 00 02 24 68 02 23 8D 03 00 63 30 D0 01 62 10 00 00 00 00 50 00 C0 AF 4C 00 C9 8F C0 20 09 00 ?? ?? ?? 0? 04 00 84 24 C9 02 40 10 21 88 40 00 4C 00 C9 8F 60 00 C3 8F BC 00 C7 8F 01 00 22 25 B0 00 C9 8F 80 10 02 00 21 10 22 02 30 02 22 AD 4C 00 C2 8F 21 80 00 00 21 28 20 01 34 02 22 AD 6B 02 E0 14 04 00 62 8C 30 02 A6 8C 80 20 10 00 01 00 10 26 21 20 C4 00 00 00 82 AC 04 00 62 8C 68 02 44 8C 44 31 04 7C 68 02 44 AC 08 00 63 8C F3 FF 60 14 00 00 00 00 ?? ?? 02 3C ?? ?? 42 8C 00 08 42 30 42 02 40 14 ?? ?? 02 3C B0 00 C9 8F 30 02 25 8D 00 00 B2 8C 35 02 49 16 B0 00 C9 8F CC 02 2A 8D 28 02 40 11 02 00 07 2E BD 02 E0 14 48 00 C7 AF FC FF A6 24 80 A8 10 00 21 10 A0 00 21 30 D5 00 01 00 05 24 04 00 43 8C 04 00 42 24 68 02 64 8C 44 31 A4 7C FB FF 46 14 68 02 64 AC 00 00 42 8D 04 00 54 25 10 00 40 10 21 98 00 00 4C 00 D0 AF 80 30 13 00 21 80 86 02 00 00 02 8E 68 02 42 8C 60 00 42 30 5B 00 40 14 00 00 00 00 CC 02 42 8E 00 00 42 8C 01 00 73 26 2B 10 62 02 F5 FF 40 14 80 30 13 00 4C 00 D0 8F 48 00 C9 8F 92 02 20 15 21 20 20 02 30 02 45 8E FC FF A6 24 21 10 A0 00 21 30 D5 00 04 00 43 8C 04 00 42 24 68 02 64 8C 44 31 04 7C FB FF 46 14 68 02 64 AC 21 20 20 02 21 30 A0 02 ?? ?? ?? 0? 48 00 D5 AF 40 30 10 00 08 00 C2 24 C2 10 02 00 C0 10 02 00 5C 00 DD AF 23 E8 A2 03 18 00 B3 27 80 B8 10 00 21 20 60 02 21 28 00 00 ?? ?? ?? 0? FC FF F7 26 01 00 14 24 FF FF 03 26 21 B8 37 02 02 00 15 24 58 00 D7 AF 60 00 D6 AF 64 00 D2 AF 21 B0 60 02 21 90 A0 02 4C 00 C3 AF 04 00 0F 24 2B C0 83 02 02 00 17 24 54 00 D1 AF 21 98 00 02 21 A8 80 02 21 48 D2 02 00 00 22 95 54 00 C7 8F 01 00 42 24 21 20 EF 00 00 00 90 8C 12 00 00 13 00 00 22 A5 58 00 D4 8F 4C 00 D1 8F 00 00 82 8E C8 02 42 8C 05 00 40 14 00 00 00 00 ?? ?? ?? 0? FF FF 31 26 3A 00 03 12 04 00 42 24 00 00 43 8C FC FF 60 14 00 00 00 00 FF FF 31 26 2B 10 B1 02 F2 FF 40 14 FC FF 94 26 46 00 77 12 21 A8 E0 02 23 30 77 02 40 90 17 00 21 20 D2 02 21 28 00 00 ?? ?? ?? 0? 40 30 06 00 4C 00 C9 8F 80 78 17 00 2B C0 E9 02 ?? ?? ?? 0? 01 00 F7 26 D0 02 44 8E 78 00 C6 AF 01 00 84 24 ?? ?? ?? 0? 80 20 04 00 21 B8 40 00 9F FF 40 10 78 00 C6 8F 04 00 44 24 ?? ?? ?? 0? 21 28 80 02 CC 02 42 8E 01 00 69 26 00 00 4A 8C 2B 20 2A 01 37 02 80 10 80 40 0A 00 21 40 88 02 21 18 00 02 FC FF 08 25 21 30 60 02 04 00 64 8C 68 02 87 8C 60 00 E7 30 04 00 E0 14 80 38 06 00 21 38 E7 02 04 00 E4 AC 01 00 C6 24 04 00 63 24 F6 FF 68 14 00 00 00 00 FF FF 4A 25 21 48 49 01 23 98 33 01 ?? ?? ?? 0? 00 00 E6 AE 54 00 C7 8F 23 18 35 02 04 00 E5 25 21 28 E5 00 80 30 03 00 7C 00 C3 AF 78 00 C9 AF 80 00 CF AF ?? ?? ?? 0? 84 00 D8 AF 40 28 17 00 21 28 C5 02 00 00 A4 94 23 10 75 02 00 00 90 AE 2B 10 44 00 7C 00 C3 8F 23 00 40 10 78 00 C9 8F ?? ?? ?? 0? 21 A8 E0 02 60 00 D6 8F 54 00 D1 8F 64 00 D2 8F 5C 00 DD 8F 48 00 C3 8F 21 A8 23 02 00 00 A0 AE 0F 00 00 00 68 02 42 8E 01 00 03 24 C8 02 51 AE 04 84 62 7C 68 02 42 AE 50 00 C7 8F 03 00 E0 10 00 00 00 00 ?? ?? ?? 0? 21 20 E0 00 ED 01 C0 16 AC 00 DF 8F 21 E8 C0 03 A8 00 BE 8F A4 00 B7 8F A0 00 B6 8F 9C 00 B5 8F 98 00 B4 8F 94 00 B3 8F 90 00 B2 8F 8C 00 B1 8F 88 00 B0 8F 08 00 E0 03 B0 00 BD 27 00 00 30 95 21 20 D2 02 ?? ?? ?? 0? 40 30 03 00 40 10 11 00 21 10 C2 02 00 00 50 A4 80 00 CF 8F ?? ?? ?? 0? 84 00 D8 8F FD FF 03 24 24 10 43 00 FF 7F 03 3C FD FF 63 34 5D FE 43 14 00 00 00 00 04 00 30 8E 21 80 B0 02 ?? ?? ?? 0? 21 20 00 02 6E 00 40 14 00 00 00 00 00 00 23 8E FF 7F 02 3C FD FF 42 34 F7 00 62 10 30 00 D0 AF ?? ?? E2 8E 01 00 42 30 D5 01 40 14 20 00 C2 27 ?? ?? 07 3C 10 00 A2 AF 38 00 C4 27 3C 00 C5 27 40 00 C6 27 ?? ?? ?? 0? ?? ?? E7 24 3C 00 D0 8F CA 00 00 16 21 20 00 02 54 00 C9 8F 34 00 C2 8F E8 FF BD 27 03 00 26 89 07 00 25 89 0B 00 24 89 00 00 26 99 04 00 25 99 08 00 24 99 18 00 A3 27 00 00 66 AC 04 00 65 AC 08 00 64 AC 00 00 20 AD 06 00 80 12 04 00 22 AD 80 20 13 00 21 20 84 02 00 00 82 AC 34 00 C2 8F 01 00 73 26 68 02 44 8C 60 00 84 30 E2 01 80 10 01 00 06 24 ?? ?? ?? 0? 21 20 60 00 04 00 A6 8C BE 01 C2 10 21 38 80 00 21 20 A0 00 08 00 85 8C FA FF A0 14 54 00 C9 8F 00 00 65 8C 04 00 64 8C 08 00 62 8C 03 00 25 A9 00 00 25 B9 07 00 24 A9 04 00 24 B9 0B 00 22 A9 ?? ?? ?? 0? 08 00 22 B9 ?? ?? ?? 0? 21 28 00 00 FE FD 40 10 50 00 C2 AF ?? ?? 02 3C ?? ?? 42 8C 73 00 40 14 ?? ?? 07 3C ?? ?? ?? 0? 21 20 00 02 7C 02 44 8E 60 00 80 10 21 B0 40 00 FF FF 02 24 03 00 82 10 21 10 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 03 3C ?? ?? 64 8C 03 00 03 24 03 00 86 2C 0A 18 86 00 2B 20 62 00 0B 18 44 00 05 00 62 2C 06 00 40 14 0E 00 C5 26 50 00 C5 8F FC FF 63 24 02 30 65 70 21 B0 D6 00 0E 00 C5 26 C2 28 05 00 C0 28 05 00 23 E8 A5 03 21 20 40 02 21 28 00 02 18 00 A6 27 ?? ?? ?? 0? 21 38 00 00 00 00 43 80 34 00 60 10 00 00 00 00 ?? ?? ?? 0? 21 80 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 00 00 8F FF 40 10 50 00 C2 AF ?? ?? 02 3C ?? ?? 42 8C B2 00 40 14 ?? ?? 07 3C ?? ?? ?? 0? 21 20 00 02 7C 02 44 8E 9F 00 80 10 21 B0 40 00 FF FF 02 24 03 00 82 10 21 10 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 03 3C ?? ?? 64 8C 03 00 03 24 03 00 85 2C 0A 18 85 00 2B 20 62 00 0A 10 64 00 05 00 43 2C 04 00 60 14 50 00 C3 8F FC FF 42 24 02 20 43 70 21 B0 96 00 0E 00 C2 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 21 20 40 02 21 28 00 02 18 00 A6 27 ?? ?? ?? 0? 21 38 00 00 00 00 43 80 7F 00 60 14 00 00 00 00 00 00 23 8E FF 7F 02 3C FD FF 42 34 75 00 62 10 21 20 00 00 ?? ?? E2 8E 01 00 42 30 B6 FD 40 10 08 00 31 26 F8 FF 31 26 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 21 28 00 02 ?? ?? ?? 0? 08 00 31 26 ?? ?? ?? 0? 21 10 00 00 04 00 42 8E 00 00 42 80 27 00 40 14 ?? ?? 04 3C ?? ?? ?? 0? 00 00 00 00 FF FF 43 24 FE FF 63 2C F5 FF 60 10 7C 02 42 AE ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? ?? ?? 03 3C 21 20 00 00 21 28 00 02 21 30 00 00 ?? ?? ?? 0? ?? ?? E7 24 30 02 22 8D 31 FE 40 10 4C 00 C9 8F ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 F9 01 06 24 ?? ?? ?? 0? ?? ?? E7 24 01 00 09 24 B0 00 D2 8F 21 40 00 00 ?? ?? ?? 0? 4C 00 C9 AF B0 00 C9 8F ?? ?? 07 3C 0C 00 04 24 04 00 25 8D 21 30 00 00 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 F9 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? ?? 0? 21 B0 40 00 0F 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 A4 27 21 28 00 02 ?? ?? ?? 0? 01 00 46 24 38 00 D1 8F 21 90 40 00 ?? ?? ?? 0? 21 20 20 02 0F 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 A4 27 21 28 20 02 ?? ?? ?? 0? 01 00 46 24 40 00 C3 93 03 00 60 10 38 00 C2 AF ?? ?? ?? 0? 21 20 00 02 FF FF 02 24 3C 00 D2 AF ?? ?? ?? 0? 0A B0 56 00 ?? ?? E2 8E 01 00 42 30 35 00 40 14 20 00 C2 27 ?? ?? 07 3C 38 00 C4 27 10 00 A2 AF 3C 00 C5 27 40 00 C6 27 ?? ?? ?? 0? ?? ?? E7 24 3C 00 C4 8F 0C FF 80 10 54 00 C9 8F 40 00 C2 93 4B FD 40 10 00 00 00 00 ?? ?? ?? 0? 08 00 31 26 ?? ?? ?? 0? 00 00 22 8E ?? ?? ?? 0? 21 10 00 00 ?? ?? 07 3C 21 28 00 02 21 30 00 00 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? ?? 0? 21 80 40 00 04 00 42 8E 00 00 42 80 10 00 40 14 ?? ?? 04 3C ?? ?? ?? 0? 00 00 00 00 FF FF 43 24 FE FF 63 2C EE FF 60 10 7C 02 42 AE ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? ?? ?? 03 3C 21 20 00 00 21 28 00 02 21 30 00 00 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 2D 01 06 24 ?? ?? ?? 0? ?? ?? E7 24 04 00 46 8E 00 00 C2 80 09 00 40 14 ?? ?? 04 3C ?? ?? 05 3C ?? ?? A2 8C 00 00 46 8C 05 00 C0 14 ?? ?? 84 24 ?? ?? 06 3C ?? ?? C6 24 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 21 28 00 02 ?? ?? ?? 0? 20 00 C2 27 80 18 10 00 21 20 20 02 21 30 60 00 ?? ?? ?? 0? 48 00 C3 AF 02 00 02 2E 84 FE 40 14 48 00 C3 8F ?? ?? ?? 0? 40 30 10 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 4A 02 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 57 8C B0 00 C9 8F BD FD E9 16 00 00 00 00 BB FD 00 12 21 98 00 00 01 00 15 24 30 02 E3 8E 80 10 13 00 21 10 62 00 00 00 52 8C 07 00 F2 12 00 00 00 00 A4 02 42 8E 11 00 40 10 00 00 00 00 04 00 42 8C 0E 00 40 10 00 00 00 00 01 00 73 26 F2 FF 70 16 B0 00 C9 8F ?? ?? ?? 0? 30 02 25 8D 68 02 44 8C 00 02 84 30 93 FD 80 10 00 00 00 00 34 02 A4 8C FF FF 84 24 ?? ?? ?? 0? 34 02 A4 AC C4 01 42 8E 3A 00 40 14 00 00 00 00 BC 01 42 8E 37 00 40 14 21 20 20 02 ?? ?? ?? 0? 21 28 40 02 21 A0 40 00 2B 10 02 02 2A 00 40 14 ?? ?? 04 3C 17 00 80 12 04 00 23 26 00 00 24 8E 21 10 00 00 68 02 85 8C 44 31 05 7C 68 02 85 AC 01 00 42 24 10 00 82 12 02 00 86 26 00 00 64 8C 68 02 85 8C 44 31 05 7C 08 00 40 10 68 02 85 AC 00 00 64 8C 60 00 84 8C 04 00 80 10 00 00 00 00 68 02 44 8E C4 7B A4 7E 68 02 44 AE ?? ?? ?? 0? 04 00 63 24 02 00 86 26 80 30 06 00 21 20 C0 00 ?? ?? ?? 0? 78 00 C6 AF A4 02 42 AE 17 00 40 10 78 00 C6 8F 08 00 43 24 21 20 60 00 21 28 20 02 F8 FF C6 24 04 00 54 AC ?? ?? ?? 0? 00 00 43 AC ?? ?? ?? 0? 01 00 73 26 ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 31 02 06 24 ?? ?? ?? 0? ?? ?? E7 24 04 00 45 8E ?? ?? 07 3C 16 00 04 24 21 30 00 00 ?? ?? ?? 0? ?? ?? E7 24 04 00 E5 8E ?? ?? 07 3C 0C 00 04 24 21 30 00 00 ?? ?? ?? 0? ?? ?? E7 24 B0 00 C9 8F ?? ?? ?? 0? 04 00 25 8D ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? FF FF 02 24 6C 00 C3 8F 68 00 D4 AF 21 18 62 00 ?? ?? ?? 0? 6C 00 C3 AF 27 20 16 00 38 00 C5 8F 3C 00 C7 8F 0A B0 04 00 21 20 C0 02 ?? ?? ?? 0? 21 30 00 00 30 02 45 8E 21 30 A0 02 ?? ?? ?? 0? 48 00 D5 AF }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "dlinfo_doit"
		size = 304
		refs = "00a8 _dl_rtld_di_serinfo 00dc strcpy 0114 _dl_signal_error 0104 $LC0 011c _dl_tls_get_addr_soft"
	strings:
		$1 = { 08 00 82 8C E0 FF BD 27 04 00 86 8C 0B 00 43 2C 18 00 B0 AF 1C 00 BF AF 3A 00 60 10 21 80 80 00 ?? ?? 03 3C 80 10 02 00 ?? ?? 63 24 21 10 62 00 00 00 42 8C 08 00 40 00 00 00 00 00 14 03 C3 8C 36 00 60 14 21 10 00 00 0C 00 03 8E 00 00 62 AC 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 18 00 C3 8C 0C 00 82 8C 00 00 43 AC 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 0C 00 82 8C 1C 00 BF 8F 18 00 B0 8F 00 00 46 AC 08 00 E0 03 20 00 BD 27 0C 00 85 8C 1C 00 BF 8F 18 00 B0 8F 21 20 C0 00 21 30 00 00 ?? ?? ?? 0? 20 00 BD 27 0C 00 85 8C 1C 00 BF 8F 18 00 B0 8F 21 20 C0 00 01 00 06 24 ?? ?? ?? 0? 20 00 BD 27 1C 00 BF 8F 18 00 B0 8F 0C 00 84 8C 7C 02 C5 8C ?? ?? ?? 0? 20 00 BD 27 0C 00 82 8C 00 00 40 AC 14 03 C3 8C 00 00 43 AC 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 ?? ?? 07 3C 21 20 00 00 21 28 00 00 21 30 00 00 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? ?? 0? 21 20 C0 00 0C 00 03 8E ?? ?? ?? 0? 00 00 62 AC }
	condition:
		$1
}

rule file_243_1_0 {
	meta:
		name = "__dlinfo"
		size = 60
		refs = "0020 _dlerror_run"
	strings:
		$1 = { D0 FF BD 27 1C 00 A4 AF ?? ?? 04 3C 20 00 A5 AF ?? ?? 84 24 18 00 A5 27 2C 00 BF AF 18 00 A7 AF ?? ?? ?? 0? 24 00 A6 AF 2C 00 BF 8F 2B 10 02 00 23 10 02 00 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "abs"
		size = 16
		altNames = "labs"
	strings:
		$1 = { C3 1F 04 00 26 10 64 00 08 00 E0 03 23 10 43 00 }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "_nl_init_alt_digit"
		size = 220
		refs = "0040 malloc 006c __rawmemchr 00ac _nl_cleanup_time"
	strings:
		$1 = { D0 FF BD 27 1C 00 B0 AF 2C 00 BF AF 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF 14 00 92 8C 1F 00 40 12 21 80 80 00 14 00 42 8E 16 00 40 14 2C 00 BF 8F E0 00 11 8E 01 00 02 24 11 00 20 12 14 00 42 AE ?? ?? ?? 0? 90 01 04 24 0D 00 40 10 0C 00 42 AE 21 80 00 00 ?? ?? ?? 0? 90 01 13 24 0C 00 42 8E 21 10 50 00 00 00 51 AC 21 20 20 02 ?? ?? ?? 0? 21 28 00 00 04 00 10 26 F8 FF 13 16 01 00 51 24 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? ?? 0? 1C 00 04 24 F6 FF 40 10 14 00 02 AE ?? ?? 03 3C ?? ?? 63 24 00 00 40 AC 04 00 40 AC 08 00 40 AC 0C 00 40 AC 10 00 40 AC 14 00 40 AC 18 00 40 AC 21 90 40 00 ?? ?? ?? 0? 10 00 03 AE }
	condition:
		$1
}

rule file_245_1_0 {
	meta:
		name = "_nl_get_alt_digit"
		size = 220
		refs = "002c __pthread_rwlock_wrlock 003c __libc_setlocale_lock 0074 __pthread_rwlock_unlock"
	strings:
		$1 = { D8 FF BD 27 64 00 82 2C 20 00 B1 AF 24 00 BF AF 1C 00 B0 AF 2B 00 40 10 21 88 80 00 E0 00 A2 8C 00 00 42 80 27 00 40 10 21 80 A0 00 ?? ?? 02 3C ?? ?? 42 24 04 00 40 10 00 00 00 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 14 00 02 8E 16 00 40 10 00 00 00 00 14 00 43 8C 13 00 60 10 00 00 00 00 0C 00 42 8C 15 00 40 10 80 88 11 00 21 10 51 00 00 00 50 8C ?? ?? 03 3C ?? ?? 63 24 05 00 60 10 21 10 00 02 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 21 10 00 02 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 21 20 00 02 14 00 02 8E EA FF 40 14 00 00 00 00 ?? ?? ?? 0? 21 80 00 00 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 21 10 00 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_245_2_0 {
	meta:
		name = "_nl_get_walt_digit"
		size = 376
		refs = "0038 __pthread_rwlock_wrlock 0048 __libc_setlocale_lock 0078 malloc 00a4 wcschr 00cc __pthread_rwlock_unlock 0148 _nl_cleanup_time"
	strings:
		$1 = { D0 FF BD 27 64 00 82 2C 28 00 B4 AF 2C 00 BF AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 3A 00 40 10 21 A0 80 00 AC 01 A2 8C 00 00 42 8C 36 00 40 10 21 80 A0 00 ?? ?? 02 3C ?? ?? 42 24 04 00 40 10 00 00 00 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 14 00 12 8E 35 00 40 12 00 00 00 00 18 00 42 8E 14 00 40 14 01 00 02 24 AC 01 11 8E 11 00 20 12 18 00 42 AE ?? ?? ?? 0? 90 01 04 24 2F 00 40 10 10 00 42 AE 21 80 00 00 ?? ?? ?? 0? 90 01 13 24 10 00 42 8E 21 10 50 00 00 00 51 AC 21 20 20 02 ?? ?? ?? 0? 21 28 00 00 04 00 10 26 F8 FF 13 16 04 00 51 24 10 00 42 8E 20 00 40 10 80 A0 14 00 21 10 54 00 00 00 50 8C ?? ?? 02 3C ?? ?? 42 24 05 00 40 10 21 10 00 02 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 21 10 00 02 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 21 10 00 00 08 00 E0 03 30 00 BD 27 ?? ?? ?? 0? 1C 00 04 24 03 00 40 14 14 00 02 AE ?? ?? ?? 0? 21 80 00 00 ?? ?? 03 3C ?? ?? 63 24 00 00 40 AC 04 00 40 AC 08 00 40 AC 0C 00 40 AC 10 00 40 AC 14 00 40 AC 18 00 40 AC 21 90 40 00 ?? ?? ?? 0? 10 00 03 AE }
	condition:
		$1
}

rule file_245_3_0 {
	meta:
		name = "_nl_parse_alt_digit"
		size = 344
		refs = "0040 __pthread_rwlock_wrlock 0050 __libc_setlocale_lock 0094 strlen 00b4 strncmp 00d0 __pthread_rwlock_unlock"
	strings:
		$1 = { C0 FF BD 27 38 00 B7 AF 30 00 B5 AF 1C 00 B0 AF 3C 00 BF AF 34 00 B6 AF 2C 00 B4 AF 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF AC 01 A2 8C 21 80 A0 00 21 B8 80 00 00 00 42 8C 45 00 40 10 00 00 95 8C ?? ?? 02 3C ?? ?? 42 24 04 00 40 10 00 00 00 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 14 00 02 8E 34 00 40 10 00 00 00 00 14 00 43 8C 31 00 60 10 00 00 00 00 0C 00 52 8C 33 00 40 12 21 98 00 00 21 80 00 00 FF FF 14 24 64 00 16 24 00 00 51 8E 04 00 52 26 ?? ?? ?? 0? 21 20 20 02 21 30 40 00 21 20 20 02 21 88 40 00 2B 10 62 02 05 00 40 10 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 0A A0 02 02 0A 98 22 02 01 00 10 26 F0 FF 16 16 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 05 00 40 10 FF FF 02 24 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 FF FF 02 24 05 00 82 12 3C 00 BF 8F 00 00 E2 8E 21 98 53 00 00 00 F3 AE 3C 00 BF 8F 21 10 80 02 38 00 B7 8F 34 00 B6 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? ?? 0? 21 20 00 02 14 00 02 8E CC FF 40 14 21 98 00 00 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? FF FF 14 24 }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "is_dst"
		size = 324
	strings:
		$1 = { 00 00 A8 80 7B 00 02 24 36 00 02 11 21 48 00 00 00 00 C2 80 0F 00 48 14 21 18 00 00 07 00 00 15 01 00 63 24 FF FF 63 24 ?? ?? ?? 0? 21 10 00 00 37 00 40 10 21 10 00 00 01 00 63 24 21 40 A3 00 21 10 C3 00 00 00 42 80 00 00 08 81 F8 FF 48 10 00 00 00 00 05 00 20 11 7D 00 06 24 25 00 06 11 21 10 00 00 08 00 E0 03 00 00 00 00 09 00 00 11 10 00 A6 8F 2F 00 02 24 06 00 02 11 00 00 00 00 F8 FF E0 10 21 10 00 00 3A 00 06 24 F5 FF 06 15 10 00 A6 8F F3 FF C0 10 21 10 60 00 21 10 A3 00 00 00 46 80 20 00 C0 10 2F 00 02 24 1E 00 C2 10 00 00 00 00 EB FF E0 10 21 10 00 00 3A 00 07 24 E8 FF C7 14 01 00 84 24 15 00 A4 10 00 00 00 00 FE FF A2 80 3A 00 42 38 0B 18 02 00 08 00 E0 03 21 10 60 00 01 00 A8 80 01 00 09 24 ?? ?? ?? 0? 01 00 A5 24 10 00 A6 8F 02 00 63 24 FF FF A5 24 D8 FF C0 10 21 10 60 00 ?? ?? ?? 0? 21 10 A3 00 E0 FF 20 11 10 00 A6 8F 08 00 E0 03 00 00 00 00 08 00 E0 03 21 10 60 00 01 00 84 24 FC FF A4 10 00 00 00 00 E6 FF E0 14 21 10 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_247_1_0 {
	meta:
		name = "is_trusted_path_normalize"
		size = 492
		refs = "00b8 memcmp"
	strings:
		$1 = { D0 FF BD 27 28 00 BE AF 20 00 B1 AF 2C 00 BF AF 24 00 B2 AF 1C 00 B0 AF 21 F0 A0 03 31 00 A0 10 21 88 00 00 00 00 83 80 3A 00 02 24 4E 00 62 10 2F 00 07 24 10 00 A5 24 C2 28 05 00 C0 28 05 00 23 E8 A5 03 10 00 B0 27 21 10 00 02 2E 00 08 24 09 00 60 10 00 00 00 00 2B 00 67 10 00 00 00 00 01 00 86 80 00 00 43 A0 21 18 C0 00 01 00 84 24 F9 FF 60 14 01 00 42 24 05 00 50 10 21 18 40 00 FF FF 45 80 2F 00 04 24 05 00 A4 10 23 90 50 00 2F 00 04 24 01 00 42 24 00 00 64 A0 23 90 50 00 05 00 42 2E 0F 00 40 14 21 88 00 00 ?? ?? 04 3C ?? ?? 84 24 21 28 00 02 ?? ?? ?? 0? 05 00 06 24 48 00 40 10 09 00 52 2E 06 00 40 16 ?? ?? 04 3C ?? ?? 84 24 21 28 00 02 ?? ?? ?? 0? 09 00 06 24 01 00 51 2C 21 E8 C0 03 2C 00 BF 8F 21 10 20 02 28 00 BE 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 01 00 85 80 0C 00 A8 10 00 00 00 00 2B 30 02 02 07 00 C0 10 00 00 00 00 FF FF 49 80 CF FF 27 15 21 30 A0 00 01 00 84 24 ?? ?? ?? 0? 21 18 A0 00 ?? ?? ?? 0? 21 30 A0 00 02 00 86 80 13 00 C8 10 00 00 00 00 03 00 C3 10 00 00 00 00 EF FF C0 14 00 00 00 00 02 00 84 24 ?? ?? ?? 0? 21 18 C0 00 FF FF A5 24 10 00 A5 24 C2 28 05 00 C0 28 05 00 23 E8 A5 03 10 00 B0 27 01 00 83 80 21 10 00 02 01 00 84 24 ?? ?? ?? 0? 2E 00 08 24 03 00 86 80 03 00 C3 10 00 00 00 00 DC FF C0 14 00 00 00 00 2B 18 02 02 0A 00 60 10 00 00 00 00 FF FF 43 80 07 00 67 10 FF FF 42 24 05 00 50 10 00 00 00 00 FF FF 42 24 00 00 43 80 FB FF 67 14 00 00 00 00 03 00 84 24 ?? ?? ?? 0? 21 18 C0 00 ?? ?? ?? 0? 01 00 11 24 }
	condition:
		$1
}

rule file_247_2_0 {
	meta:
		name = "local_strdup"
		size = 92
		refs = "0010 strlen 001c malloc 0040 memcpy"
		altNames = "__strdup"
	strings:
		$1 = { D8 FF BD 27 24 00 BF AF 20 00 B1 AF 1C 00 B0 AF ?? ?? ?? 0? 21 88 80 00 01 00 50 24 ?? ?? ?? 0? 21 20 00 02 08 00 40 10 21 20 40 00 24 00 BF 8F 21 28 20 02 21 30 00 02 20 00 B1 8F 1C 00 B0 8F ?? ?? ?? 0? 28 00 BD 27 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_247_3_0 {
	meta:
		name = "fillin_rpath"
		size = 932
		refs = "004c __strsep_g 005c strlen 00d0 _dl_all_dirs 00dc curwd.9209 0114 memcmp 0204 malloc 0230 mempcpy 02a0 memcpy 039c _dl_signal_error 038c $LC0"
	strings:
		$1 = { B0 FF BD 27 30 00 B2 AF 64 00 B2 8F 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 28 00 B0 AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 2C 00 B1 AF 50 00 A4 AF 21 A8 A0 00 21 A0 C0 00 5C 00 A7 AF 21 80 00 00 ?? ?? 13 3C 50 00 A4 27 ?? ?? ?? 0? 21 28 80 02 4B 00 40 10 21 B0 40 00 ?? ?? ?? 0? 21 20 C0 02 1B 00 40 10 21 B8 40 00 02 00 42 2C 10 00 40 14 FF FF E3 26 21 10 C3 02 00 00 44 80 2F 00 02 24 A8 00 82 14 01 00 04 24 09 00 64 10 2F 00 05 24 FF FF 66 24 21 10 C6 02 00 00 42 80 8B 00 45 14 21 10 C3 02 21 18 C0 00 FA FF 64 14 FF FF 66 24 00 00 C3 82 2F 00 02 24 82 00 62 14 5C 00 A4 8F E0 FF 80 14 01 00 17 24 ?? ?? ?? 0? ?? ?? 71 8E 5C 00 A4 8F DB FF 80 14 ?? ?? 02 3C ?? ?? 56 24 ?? ?? 71 8E 36 00 20 12 21 F0 20 02 ?? ?? ?? 0? 10 00 C3 8F 00 00 DE 8F 31 00 C0 13 00 00 00 00 10 00 C3 8F FB FF 77 14 21 20 C0 02 0C 00 C5 8F ?? ?? ?? 0? 21 30 E0 02 F6 FF 40 14 00 00 00 00 8A 00 00 12 21 18 00 00 00 00 A2 8E C5 FF 5E 10 04 00 A3 26 21 10 00 00 01 00 42 24 07 00 50 10 04 00 63 24 FC FF 64 8C FC FF 9E 14 01 00 42 24 FF FF 42 24 BC FF 02 16 50 00 A4 27 80 18 02 00 21 18 A3 02 01 00 50 24 00 00 7E AC 50 00 A4 27 ?? ?? ?? 0? 21 28 80 02 B7 FF 40 14 21 B0 40 00 4C 00 BF 8F 80 10 10 00 21 10 A2 02 00 00 40 AC 48 00 BE 8F 21 10 A0 02 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 56 00 40 12 00 00 00 00 ?? ?? ?? 0? 21 20 40 02 01 00 42 24 18 00 A2 AF ?? ?? 04 3C ?? ?? 89 8C 05 00 23 25 80 18 03 00 01 00 62 24 1C 00 A2 AF 21 20 57 00 18 00 A2 8F 20 00 A3 AF 24 00 A9 AF ?? ?? ?? 0? 21 20 82 00 21 F0 40 00 20 00 A3 8F 5D 00 40 10 24 00 A9 8F 21 10 43 00 21 20 40 00 0C 00 C2 AF 21 28 C0 02 21 30 E0 02 ?? ?? ?? 0? 24 00 A9 AF ?? ?? 04 3C ?? ?? 83 8C 00 00 40 A0 10 00 D7 AF 2B 18 77 00 02 00 60 10 24 00 A9 8F ?? ?? 97 AC 00 00 C2 82 02 00 05 24 21 20 C0 03 2F 00 42 38 0A 28 02 00 05 00 20 11 21 18 00 00 01 00 63 24 14 00 85 AC FD FF 69 14 04 00 84 24 60 00 A2 8F 3E 00 40 12 04 00 C2 AF 1C 00 A2 8F 18 00 A6 8F 21 28 40 02 21 20 57 00 ?? ?? ?? 0? 21 20 C4 03 08 00 C2 AF 80 10 10 00 21 10 A2 02 ?? ?? 7E AE 00 00 D1 AF 01 00 10 26 ?? ?? ?? 0? 00 00 5E AC 01 00 03 24 21 10 C3 02 01 00 77 24 2F 00 03 24 00 00 43 A0 5C 00 A2 8F 81 FF 40 10 ?? ?? 71 8E 05 00 02 24 1C 00 E2 12 09 00 02 24 55 FF E2 16 50 00 A4 27 ?? ?? 04 3C ?? ?? 84 24 21 28 C0 02 ?? ?? ?? 0? 09 00 06 24 4E FF 40 14 50 00 A4 27 ?? ?? ?? 0? ?? ?? 71 8E ?? ?? ?? 0? 18 00 A0 AF 21 18 E0 02 21 10 C3 02 01 00 77 24 2F 00 03 24 00 00 43 A0 5C 00 A2 8F 69 FF 40 10 ?? ?? 71 8E ?? ?? ?? 0? 05 00 02 24 21 18 A3 02 01 00 10 24 ?? ?? ?? 0? 00 00 7E AC ?? ?? 04 3C ?? ?? 84 24 21 28 C0 02 ?? ?? ?? 0? 05 00 06 24 35 FF 40 14 50 00 A4 27 ?? ?? ?? 0? ?? ?? 71 8E ?? ?? ?? 0? 08 00 C0 AF ?? ?? 07 3C 0C 00 04 24 21 28 00 00 21 30 00 00 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_247_4_0 {
	meta:
		name = "add_name_to_object.isra.2"
		size = 268
		refs = "0040 strcmp 0068 strlen 0074 malloc 008c memcpy 00d4 $LC2 00d8 $LC3 00ec __assert_fail 00dc __PRETTY_FUNCTION__.9190 0104 _dl_signal_error 00f4 $LC1"
	strings:
		$1 = { D0 FF BD 27 20 00 B1 AF 1C 00 B0 AF 2C 00 BF AF 28 00 B3 AF 24 00 B2 AF 21 80 80 00 07 00 80 14 21 88 A0 00 ?? ?? ?? 0? 00 00 00 00 04 00 02 8E 0D 00 40 10 00 00 00 00 21 80 40 00 00 00 05 8E ?? ?? ?? 0? 21 20 20 02 F8 FF 40 14 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? ?? 0? 21 20 20 02 0D 00 44 24 ?? ?? ?? 0? 01 00 53 24 1D 00 40 10 21 90 40 00 21 28 20 02 21 30 60 02 ?? ?? ?? 0? 0C 00 44 24 2C 00 BF 8F 00 00 42 AE 04 00 40 AE 08 00 40 AE 28 00 B3 8F 04 00 12 AE 20 00 B1 8F 24 00 B2 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? ?? 0? 21 20 A0 00 ?? ?? ?? 0? 0D 00 44 24 08 00 40 10 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 D5 01 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 07 3C 0C 00 04 24 21 28 20 02 21 30 00 00 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_247_5_0 {
	meta:
		name = "lose.isra.3"
		size = 144
		refs = "0038 __close 0054 free 0074 _dl_debug_state 0088 _dl_signal_error"
	strings:
		$1 = { D0 FF BD 27 FF FF 03 24 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 2C 00 BF AF 21 98 80 00 21 90 C0 00 21 A0 E0 00 40 00 B0 8F 03 00 A3 10 48 00 B1 8F ?? ?? ?? 0? 21 20 A0 00 06 00 00 12 FF FF 03 24 7C 02 04 8E 03 00 83 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 20 80 02 04 00 20 12 44 00 A7 8F ?? ?? ?? 0? 0C 00 20 AE 44 00 A7 8F 21 20 60 02 21 28 40 02 ?? ?? ?? 0? 21 30 00 00 }
	condition:
		$1
}

rule file_247_6_0 {
	meta:
		name = "_dl_map_object_from_fd"
		size = 3812
		refs = "0038 __gnu_local_gp 0050 _dl_debug_initialize 0064 __fxstat64 0088 _dl_ns 00fc __close 0104 free 015c _dl_debug_mask 01a4 _dl_new_object 030c _dl_use_load_bias 032c __mmap 03a0 _dl_pagesize 03fc memset 048c $LC18 0598 _dl_next_tls_modid 0808 _dl_stack_flags 0884 _dl_setup_hash 08b8 _dl_initfirst 08c0 _dl_profile 08ec _dl_add_to_namespace_list 093c __mprotect 0950 _dl_debug_state 0978 __lseek 098c __libc_read 09d8 $LC20 0a98 $LC9 0ad8 malloc 0af0 memcpy 0b10 $LC17 0b24 $LC12 0b38 $LC13 0b48 $LC6 0b58 __libc_errno 0b68 $LC7 0714 $LC23 0b74 $LC24 0b88 __assert_fail 0b78 __PRETTY_FUNCTION__.9074 0734 $LC25 0754 $LC26 0c0c __munmap 0c44 $LC10 0c70 _dl_tls_dtv_slotinfo_list 0c84 _dl_tls_setup 0ca0 _dl_allocate_tls 0cd0 _dl_deallocate_tls 0cd8 $LC15 0cec _dl_debug_printf 0ce8 $LC27 0d00 _dl_tls_max_dtv_idx 0d14 $LC14 0d54 memmove 0d94 $LC28 0dbc $LC8 0dc8 __stack_prot 0dcc _dl_make_stack_executable_hook 0de8 $LC11 0e2c $LC4 0e44 $LC21 0e58 $LC16 0e68 $LC22 0e6c $LC3 0e70 __PRETTY_FUNCTION__.9329 0e88 $LC5 0ebc $LC19"
	strings:
		$1 = { D0 FE BD 27 28 01 BE AF 21 F0 A0 03 2C 01 BF AF 24 01 B7 AF 20 01 B6 AF 1C 01 B5 AF 18 01 B4 AF 14 01 B3 AF 10 01 B2 AF 0C 01 B1 AF 08 01 B0 AF 34 01 C5 AF 50 01 C5 8F ?? ?? 1C 3C ?? ?? 9C 27 30 01 C4 AF 21 20 00 00 38 00 DC AF 21 B8 C0 00 ?? ?? ?? 0? 3C 01 C7 AF 34 01 C5 8F 03 00 04 24 40 00 C6 27 ?? ?? ?? 0? E4 00 C2 AF 6F 03 40 04 38 00 DC 8F 50 01 C5 8F 00 11 05 00 80 18 05 00 21 18 62 00 23 18 65 00 ?? ?? 02 3C 80 18 03 00 ?? ?? 42 24 21 10 62 00 00 00 51 8C 2C 00 20 12 50 00 C3 8F 54 00 C5 8F ?? ?? ?? 0? 40 00 C4 8F 0C 00 31 8E 27 00 20 12 48 01 C6 8F 68 02 22 8E 00 20 42 30 FA FF 40 14 00 00 00 00 B8 02 22 8E F7 FF 43 14 00 00 00 00 BC 02 22 8E F4 FF 45 14 00 00 00 00 B0 02 22 8E F1 FF 44 14 00 00 00 00 B4 02 22 8E EE FF 40 14 00 00 00 00 ?? ?? ?? 0? 34 01 C4 8F ?? ?? ?? 0? 3C 01 C4 8F 1C 00 24 8E ?? ?? ?? 0? 30 01 C5 8F 21 E8 C0 03 2C 01 BF 8F 21 10 20 02 28 01 BE 8F 24 01 B7 8F 20 01 B6 8F 1C 01 B5 8F 18 01 B4 8F 14 01 B3 8F 10 01 B2 8F 0C 01 B1 8F 08 01 B0 8F 08 00 E0 03 30 01 BD 27 48 01 C6 8F 08 00 C2 30 46 02 40 14 ?? ?? 03 3C ?? ?? 62 8C 40 00 42 30 35 03 40 14 30 01 C5 8F E4 00 C4 8F 0C 00 82 8C F4 01 40 10 01 00 03 24 39 03 43 14 F4 00 C0 AF 48 01 C6 8F 10 00 A6 AF 50 01 C2 8F 14 00 A2 AF 3C 01 C4 8F 30 01 C5 8F 44 01 C6 8F ?? ?? ?? 0? 40 01 C7 8F 21 88 40 00 35 03 40 10 38 00 DC 8F 30 00 E2 96 20 00 E5 8E 00 00 E3 8E 40 81 02 00 21 30 05 02 1C 00 E4 8E 2B 18 66 00 14 00 E6 96 28 02 24 AE 2C 02 22 A6 E0 01 60 14 E8 00 C6 AF 21 28 E5 02 04 00 B2 24 21 18 00 02 C0 10 02 00 23 18 62 00 08 00 63 24 21 80 50 02 F0 00 DD AF 2B 80 50 02 23 E8 A3 03 3F 02 00 12 38 00 B5 27 74 64 14 3C 51 E5 94 36 07 00 03 24 EC 00 D7 AF 21 80 40 02 21 B0 00 00 21 98 00 00 E0 00 C3 AF 01 00 85 26 ?? ?? 06 3C ?? ?? ?? 0? 07 00 17 24 DE 00 54 10 00 00 00 00 D7 00 45 10 07 00 03 24 BE 00 43 10 00 00 00 00 2C 02 22 96 20 00 10 26 40 11 02 00 21 10 42 02 2B 10 02 02 16 00 40 10 00 00 00 00 00 00 02 8E 06 00 03 24 84 00 43 10 07 00 43 2C EE FF 60 10 01 00 03 24 83 00 43 10 02 00 03 24 F0 FF 43 14 00 00 00 00 14 00 02 8E 08 00 03 8E 20 00 10 26 C2 10 02 00 2E 02 22 A6 2C 02 22 96 40 11 02 00 21 10 42 02 2B 10 02 02 EC FF 40 14 08 00 23 AE E0 00 D7 AF 0E 02 60 12 EC 00 D7 8F FF FF 62 26 C0 18 02 00 40 A1 02 00 23 A0 83 02 21 A0 B4 02 00 00 A2 8E 0C 00 90 8E E8 00 C4 8F 03 00 03 24 BC 02 83 14 23 80 02 02 34 01 C5 8F ?? ?? 03 3C ?? ?? 64 8C 14 00 A6 8E 10 00 A5 AF 10 00 A3 8E 24 20 44 00 21 28 00 02 14 00 A3 AF ?? ?? ?? 0? 02 20 07 24 FF FF 03 24 38 00 DC 8F 53 00 43 10 80 02 22 AE 00 00 A3 8E 21 20 50 00 84 02 24 AE 23 20 43 00 75 01 C0 16 00 00 24 AE 68 02 22 8E 01 00 03 24 21 A0 A0 02 84 73 62 7C 68 02 22 AE 14 00 86 8E 04 00 C2 30 99 00 40 14 00 00 00 00 24 02 22 8E 9D 00 40 10 00 00 00 00 0C 00 82 8E 08 00 83 8E 2B 20 62 00 23 00 80 10 00 00 00 00 ?? ?? 08 3C 00 00 36 8E ?? ?? 05 8D 21 18 C3 02 FF FF A7 24 21 38 E3 00 23 20 05 00 21 B0 C2 02 24 10 E4 00 2B 38 C2 02 0B 10 C7 02 21 38 40 00 2B 10 62 00 12 00 40 10 2B 10 F6 00 02 00 C2 30 AC 02 40 10 24 20 83 00 23 30 E3 00 21 20 60 00 21 28 00 00 00 01 C3 AF FC 00 C7 AF ?? ?? ?? 0? F8 00 C8 AF 14 00 86 8E 00 01 C3 8F FC 00 C7 8F 02 00 C2 30 AC 02 40 10 F8 00 C8 8F 2B 10 F6 00 62 01 40 14 FF FF 03 24 18 00 94 26 C0 10 13 00 40 19 13 00 23 10 62 00 21 10 A2 02 2B 10 82 02 80 00 40 10 00 00 00 00 04 00 85 8E 00 00 82 8E 2B 18 45 00 C6 FF 60 10 34 01 C3 8F 00 00 24 8E 14 00 86 8E 10 00 A3 AF 10 00 83 8E 21 20 44 00 23 28 A2 00 14 00 A3 AF ?? ?? ?? 0? 12 20 07 24 FF FF 03 24 BA FF 43 14 38 00 DC 8F ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 08 00 02 8E ?? ?? ?? 0? 24 02 22 AE ?? ?? C7 8C 1C 00 03 8E FF FF E4 24 24 20 64 00 9B 01 80 14 FF FF 63 24 08 00 04 8E 04 00 08 8E 23 48 88 00 24 18 69 00 9A 01 60 14 40 51 13 00 10 00 09 8E 14 00 0B 8E 21 48 89 00 C0 18 13 00 FF FF EC 24 23 18 43 01 23 38 07 00 01 00 73 26 21 60 89 01 21 18 A3 02 24 50 87 00 24 60 87 01 21 20 64 01 24 38 07 01 02 00 6B 2E 00 00 6A AC 04 00 6C AC 08 00 69 AC 0C 00 64 AC 04 00 60 15 10 00 67 AC EC FF 64 8C 26 50 44 01 0B B0 4A 00 18 00 02 8E 51 73 04 3C 40 62 84 34 80 10 02 00 07 10 44 00 0F 00 42 30 ?? ?? ?? 0? 14 00 62 AC 14 00 02 8E 41 FF 40 10 00 00 00 00 1C 00 03 8E 04 03 22 AE 18 00 60 14 08 03 23 AE 08 00 02 8E 0C 03 20 AE 68 02 23 8E 10 00 04 8E FC 02 22 AE 03 00 63 30 01 00 02 24 B8 01 62 14 00 03 24 AE F8 00 C5 AF ?? ?? ?? 0? FC 00 C6 AF 14 03 22 AE F8 00 C5 8F ?? ?? ?? 0? FC 00 C6 8F 08 00 03 8E 14 00 02 8E 1C 03 23 AE ?? ?? ?? 0? 20 03 22 AE ?? ?? ?? 0? 18 00 17 8E 08 00 02 8E FF FF 63 24 24 18 62 00 ?? ?? ?? 0? 0C 03 23 AE 04 00 83 8E 00 00 22 8E 21 10 62 00 88 02 22 AE 24 02 22 8E 65 FF 40 14 00 00 00 00 10 00 82 8E 20 00 E3 8E 2B 20 62 00 60 FF 80 14 00 00 00 00 04 00 87 8E 30 00 E5 96 00 00 84 8E 21 38 47 00 40 29 05 00 23 38 E4 00 21 28 A3 00 2B 28 E5 00 56 FF A0 14 21 18 83 00 23 10 62 00 ?? ?? ?? 0? 24 02 22 AE 08 00 22 8E 10 01 40 10 F0 00 DD 8F 00 00 23 8E 21 18 43 00 04 01 60 10 08 00 23 AE 00 00 62 8C 24 00 40 10 20 00 25 26 FF 6F 06 3C FF FF C6 34 00 10 08 3C 00 90 07 3C 00 FE CA 24 00 FF CC 24 00 C0 0B 3C 57 00 C9 24 ?? ?? ?? 0? 22 00 08 25 21 10 48 00 80 10 02 00 21 10 A2 00 00 00 43 AC 08 00 63 24 00 00 62 8C 12 00 40 10 00 00 00 00 22 00 44 2C F7 FF 80 14 21 20 47 00 35 00 84 2C F3 FF 80 14 23 20 C2 00 10 00 84 2C C5 00 80 10 40 20 02 00 23 10 22 01 80 10 02 00 21 10 A2 00 00 00 43 AC 08 00 63 24 00 00 62 8C F1 FF 40 14 22 00 44 2C 70 00 22 8E 06 00 40 10 11 00 03 24 04 00 42 8C 03 00 43 10 07 00 03 24 18 01 43 14 ?? ?? 04 3C 3C 00 22 8E 06 00 40 10 00 00 00 00 44 00 22 8E 04 00 43 8C 0C 00 02 24 17 01 62 14 ?? ?? 04 3C 64 00 22 8E 06 00 40 10 00 00 00 00 6C 00 22 8E 04 00 43 8C 08 00 02 24 16 01 62 14 ?? ?? 04 3C 98 00 23 8E 0E 00 60 10 00 00 00 00 04 00 62 8C 02 00 44 30 02 00 80 10 E0 02 22 AE 60 00 23 AE 04 00 44 30 02 00 80 10 00 00 00 00 78 00 23 AE 08 00 42 30 02 00 40 10 00 00 00 00 80 00 23 AE 8C 01 22 8E B1 00 40 10 ?? ?? 06 3C ?? ?? C5 8C 04 00 44 8C 40 00 A5 30 21 18 80 00 DC 02 24 AE 26 01 A0 14 21 10 80 00 01 00 63 30 03 00 60 10 00 00 00 00 8C 01 23 8E 80 00 23 AE 94 00 23 8E 02 00 60 10 00 00 00 00 5C 00 20 AE 40 00 42 30 04 01 40 14 48 01 C2 8F 24 02 22 8E B6 00 40 10 00 00 00 00 00 00 23 8E 21 10 43 00 24 02 22 AE ?? ?? 02 3C ?? ?? 42 8C E0 00 C3 8F 27 10 02 00 24 10 62 00 01 00 42 30 69 01 40 14 ?? ?? 02 3C FC 02 22 8E 04 00 40 10 00 00 00 00 00 00 23 8E 21 10 43 00 FC 02 22 AE ?? ?? ?? 0? 34 01 C4 8F 5C 01 40 14 38 00 DC 8F 68 02 22 8E 01 00 03 24 03 00 44 30 7B 00 83 10 E8 00 C4 8F ?? ?? 05 3C 28 02 22 8E 00 00 23 8E ?? ?? A4 8C 21 10 62 00 40 00 84 30 3B 01 80 14 28 02 22 AE ?? ?? ?? 0? 21 20 20 02 48 01 C6 8F 10 00 C2 30 04 00 40 14 00 00 00 00 60 00 22 8E 20 01 40 14 30 02 22 26 DC 02 22 8E 20 00 42 30 04 00 40 10 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 51 AC ?? ?? 02 3C ?? ?? 44 8C 40 00 C2 8F 54 00 C3 8F B4 02 20 AE B0 02 22 AE 50 00 C2 8F BC 02 23 AE B9 00 80 14 B8 02 22 AE 50 01 C5 8F ?? ?? ?? 0? 21 20 20 02 21 10 20 02 21 E8 C0 03 2C 01 BF 8F 28 01 BE 8F 24 01 B7 8F 20 01 B6 8F 1C 01 B5 8F 18 01 B4 8F 14 01 B3 8F 10 01 B2 8F 0C 01 B1 8F 08 01 B0 8F 08 00 E0 03 30 01 BD 27 04 00 A3 8E 00 00 85 8E 21 30 00 00 21 20 83 00 ?? ?? ?? 0? 23 28 A3 00 ?? ?? ?? 0? 68 02 22 8E 01 00 02 24 ?? ?? ?? 0? 0C 00 82 AC 01 00 05 24 ?? ?? ?? 0? F4 00 C5 AF 0E 00 02 26 34 01 C4 8F C2 10 02 00 C0 10 02 00 23 E8 A2 03 ?? ?? ?? 0? 21 30 00 00 34 01 C4 8F 38 00 B2 27 21 28 40 02 ?? ?? ?? 0? 21 30 00 02 6C 00 50 14 38 00 DC 8F 2C 02 22 96 40 19 02 00 ?? ?? ?? 0? 21 80 60 00 14 00 86 8E 10 00 A3 AF 21 20 E0 00 14 00 A0 AF 23 28 C7 02 00 01 C3 AF ?? ?? ?? 0? 12 08 07 24 00 01 C3 8F 95 FE 43 14 38 00 DC 8F ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? F0 00 DD 8F 43 20 04 00 FD FF 8D 2C 06 00 A0 15 00 00 00 00 27 10 04 00 80 10 02 00 21 10 A2 00 ?? ?? ?? 0? 9C 01 43 AC 23 20 42 01 0C 00 84 2C 06 00 80 10 23 20 82 01 80 10 02 00 23 10 A2 00 21 10 62 01 ?? ?? ?? 0? A4 F9 43 AC 0B 00 84 2C 1B FF 80 10 80 10 02 00 23 10 A2 00 21 10 62 01 ?? ?? ?? 0? D4 FD 43 AC 02 00 03 24 85 FF 83 14 ?? ?? 05 3C 04 08 02 7C ?? ?? ?? 0? 68 02 22 AE ?? ?? ?? 0? DC 02 22 8E ?? ?? ?? 0? DC 02 22 8E ?? ?? ?? 0? 3C 01 C4 8F ?? ?? ?? 0? 34 01 C4 8F ?? ?? ?? 0? 21 10 00 00 E8 00 C4 8F 03 00 02 24 F5 FF 82 14 ?? ?? 05 3C 21 10 00 00 ?? ?? A5 24 F4 00 C4 8F E4 00 C3 8F 10 00 B1 AF 14 00 A5 AF 0A 18 04 00 18 00 A3 AF 34 01 C5 8F 30 01 C6 8F 3C 01 C7 8F ?? ?? ?? 0? 21 20 40 00 30 00 F3 96 40 99 13 00 ?? ?? ?? 0? 21 20 60 02 21 00 40 10 38 00 DC 8F 21 20 40 00 21 28 40 02 ?? ?? ?? 0? 21 30 60 02 68 02 23 8E 24 02 22 AE 01 00 02 24 C4 39 43 7C ?? ?? ?? 0? 68 02 23 AE ?? ?? 05 3C 21 10 00 00 ?? ?? A5 24 ?? ?? ?? 0? F0 00 DD 8F ?? ?? 05 3C 21 10 00 00 ?? ?? A5 24 ?? ?? ?? 0? F0 00 DD 8F ?? ?? 05 3C 21 10 00 00 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? 05 3C ?? ?? A5 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 ?? ?? ?? 0? 00 00 42 8C ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 73 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 78 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 7C 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 58 00 22 8E 46 FF 40 10 00 00 00 00 34 00 24 8E 04 00 43 8C 00 00 22 8E 04 00 85 8C 1C 00 24 8E 21 28 A3 00 ?? ?? ?? 0? 21 28 A2 00 ?? ?? ?? 0? 50 01 C5 8F FC FE 41 04 00 00 00 00 80 02 24 8E 84 02 25 8E ?? ?? ?? 0? 23 28 A4 00 1C 00 24 8E 08 00 82 8C 03 00 40 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 68 02 22 8E 80 00 42 30 03 00 40 10 00 00 00 00 ?? ?? ?? 0? 24 02 24 8E ?? ?? 05 3C 21 10 00 00 ?? ?? ?? 0? ?? ?? A5 24 16 F7 05 24 24 28 85 00 22 00 A0 14 00 00 00 00 21 18 80 00 ?? ?? ?? 0? 21 10 80 00 ?? ?? 03 3C ?? ?? 62 8C 46 FE 40 14 00 00 00 00 F8 00 C5 AF ?? ?? ?? 0? FC 00 C6 AF F8 00 C5 8F 20 00 40 14 FC 00 C6 8F 21 20 00 00 F8 00 C5 AF ?? ?? ?? 0? FC 00 C6 AF 21 F8 40 00 F8 00 C5 8F 18 00 40 10 FC 00 C6 8F 00 70 44 24 BB 10 02 24 0C 00 00 00 0E 00 E0 10 ?? ?? 03 3C 21 20 E0 03 ?? ?? ?? 0? 01 00 05 24 ?? ?? 05 3C 21 10 00 00 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 DC 02 22 8E ?? ?? ?? 0? 21 18 40 00 ?? ?? 62 8C 01 00 42 24 ?? ?? 62 AC ?? ?? ?? 0? 14 03 22 AE ?? ?? 05 3C 0C 00 02 24 ?? ?? ?? 0? ?? ?? A5 24 A0 02 23 8E 00 00 63 8C DE FE 62 10 00 00 00 00 38 02 22 8E 9C 02 26 8E 00 00 51 AC A0 02 25 8E 01 00 02 24 80 30 06 00 3C 02 22 AE 04 00 A4 24 ?? ?? ?? 0? FC FF C6 24 A0 02 22 8E 38 02 23 26 ?? ?? ?? 0? 00 00 43 AC 08 00 04 24 08 00 26 8E 14 00 A4 AF 1C 00 A4 AF 24 00 A4 AF 10 00 A3 AF 18 00 B0 AF 20 00 A2 AF 24 02 22 8E 2C 00 A4 AF ?? ?? 04 3C 28 00 A2 AF 2C 02 22 96 ?? ?? 84 24 08 00 05 24 30 00 A2 AF ?? ?? ?? 0? 08 00 07 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 ?? ?? 43 8C ?? ?? 04 3C ?? ?? 99 8C 4C 01 C4 8F 07 00 63 34 09 F8 20 03 ?? ?? 43 AC 90 FE 40 10 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 48 01 C6 8F 40 07 C3 7C 16 00 60 10 01 00 D6 3A 00 00 24 8E 68 02 23 8E 21 10 44 00 21 20 50 00 84 73 C3 7E 80 02 22 AE 84 02 24 AE 68 02 23 AE ?? ?? ?? 0? 21 A0 A0 02 ?? ?? 05 3C F4 00 C0 AF ?? ?? A5 24 ?? ?? ?? 0? 21 88 00 00 50 01 C6 8F ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? ?? 0? E4 00 C4 8F ?? ?? 05 3C 21 10 00 00 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 1A 04 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 02 00 C6 34 00 01 C3 AF FC 00 C7 AF ?? ?? ?? 0? F8 00 C8 AF 38 00 DC 8F 00 01 C3 8F FC 00 C7 8F 4C FD 41 04 F8 00 C8 8F ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 ?? ?? 05 8D FC 00 C7 AF 23 20 05 00 ?? ?? ?? 0? 24 20 83 00 ?? ?? ?? 0? FC 00 C7 8F }
	condition:
		$1
}

rule file_247_7_0 {
	meta:
		name = "open_verify.isra.4"
		size = 1480
		refs = "03b4 $LC6 0004 __gnu_local_gp 004c __open 0064 __libc_errno 0090 __libc_read 00d0 memcmp 0134 __close 02fc _dl_osversion 0380 __lseek 0424 $LC33 0478 strlen 0498 memcpy 04a4 free 04b4 $LC39 04cc $LC30 0504 $LC31 0524 $LC32 0530 $LC38 0548 $LC37 0558 $LC29 0578 $LC34 05b0 $LC35 05bc $LC36"
	strings:
		$1 = { A8 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 50 00 BE AF 30 00 B0 AF 21 F0 A0 03 21 80 A0 00 08 00 05 3C 40 00 B4 AF 34 00 B1 AF 20 00 DC AF 54 00 BF AF 4C 00 B7 AF 48 00 B6 AF 44 00 B5 AF 3C 00 B3 AF 38 00 B2 AF 58 00 C4 AF 21 88 C0 00 ?? ?? ?? 0? 2C 00 C7 AF 21 A0 40 00 FF FF 02 24 3E 00 82 12 20 00 DC 8F ?? ?? 82 8F 3B E8 03 7C 21 30 00 00 21 20 43 00 00 00 80 AC 28 00 C2 AF 00 02 12 24 00 00 00 AE 21 28 06 02 21 20 80 02 04 00 A5 24 ?? ?? ?? 0? 23 30 46 02 D9 00 40 18 00 00 00 00 00 00 03 8E 21 10 43 00 34 00 43 2C 24 01 60 14 00 00 02 AE 21 98 40 00 34 00 62 2A D2 00 40 14 04 00 12 26 ?? ?? 05 3C 21 20 40 02 ?? ?? A5 24 ?? ?? ?? 0? 08 00 06 24 DF 00 40 14 ?? ?? 05 3C 0C 00 02 92 FC 00 40 14 ?? ?? 05 3C 0D 00 04 26 ?? ?? A5 24 ?? ?? ?? 0? 07 00 06 24 28 00 40 14 01 00 02 24 18 00 03 8E 0F 01 62 14 00 00 00 00 28 00 02 8E 20 04 42 30 06 00 40 14 08 00 03 24 16 00 02 96 28 00 43 10 0A 00 03 24 26 00 43 10 00 00 00 00 ?? ?? ?? 0? 21 20 80 02 3B E8 03 7C 21 10 60 00 28 00 C3 8F FF FF 14 24 21 B0 62 00 02 00 02 24 00 00 C2 AE 21 E8 C0 03 54 00 DF 8F 21 10 80 02 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 03 00 64 14 03 00 42 2C D4 FF 40 14 ?? ?? 05 3C 04 00 03 8E 4C 46 02 3C 7F 45 42 24 EA 00 62 14 01 00 02 24 08 00 03 92 C1 00 62 10 00 00 00 00 ?? ?? ?? 0? 00 00 22 A2 14 00 02 96 FE FF 42 24 FF FF 42 30 02 00 42 2C D5 00 40 10 20 00 02 24 2E 00 03 96 B3 00 62 14 21 88 00 00 30 00 04 96 20 00 05 8E 40 89 04 00 21 10 25 02 2B 98 62 02 6F 00 60 16 0E 00 22 26 21 28 05 02 04 00 B2 24 21 88 51 02 2B 88 51 02 CF FF 20 12 21 B0 40 02 04 00 13 24 ?? ?? ?? 0? FC FF 11 24 40 11 04 00 20 00 D6 26 21 10 42 02 2B 10 C2 02 C6 FF 40 10 00 00 00 00 00 00 C2 8E F9 FF 53 14 40 11 04 00 10 00 D5 8E 20 00 A2 2E F5 FF 40 14 40 11 04 00 1C 00 C2 8E 04 00 42 2C F1 FF 40 14 40 11 04 00 04 00 C5 8E 00 00 02 8E 21 20 B5 00 2B 10 44 00 3A 00 40 14 0E 00 A2 26 21 28 05 02 ?? ?? ?? 0? 04 00 B7 24 00 00 E5 8E 04 00 E2 8E 03 00 A5 24 03 00 42 24 24 28 B1 00 24 10 51 00 21 10 A2 00 0C 00 42 24 2B 20 82 00 2A 00 80 14 23 A8 A2 02 21 B8 E2 02 ?? ?? 05 3C 21 20 E0 02 ?? ?? A5 24 ?? ?? ?? 0? 10 00 06 24 EE FF 40 14 E0 FF A4 26 20 00 A0 12 00 00 00 00 10 00 E2 8E 14 00 E5 8E 18 00 E4 8E 8F FF 40 14 1C 00 E3 8E ?? ?? 02 3C ?? ?? 42 8C 94 FF 40 10 FF 00 A5 30 00 2A 05 00 FF 00 84 30 21 20 A4 00 00 22 04 00 FF 00 63 30 21 18 83 00 2B 10 43 00 82 FF 40 14 54 00 DF 8F 21 E8 C0 03 21 10 80 02 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 ?? ?? ?? 0? 30 00 04 96 C2 10 02 00 C0 10 02 00 23 E8 A2 03 21 20 80 02 21 30 00 00 ?? ?? ?? 0? 20 00 B7 27 21 20 80 02 21 28 E0 02 ?? ?? ?? 0? 21 30 A0 02 CB FF A2 12 ?? ?? 05 3C 3B E8 03 7C 21 10 60 00 28 00 C3 8F 21 10 62 00 00 00 51 8C ?? ?? 10 3C ?? ?? ?? 0? ?? ?? 10 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 21 20 80 02 21 30 00 00 ?? ?? ?? 0? 20 00 B2 27 21 20 80 02 21 28 40 02 ?? ?? ?? 0? 21 30 20 02 EC FF 22 16 00 00 00 00 30 00 04 96 ?? ?? ?? 0? 40 89 04 00 ?? ?? ?? 0? 00 00 13 8E 3B E8 03 7C 21 10 60 00 28 00 C3 8F 21 10 62 00 00 00 51 8C E6 FF 20 16 ?? ?? 10 3C ?? ?? 10 3C ?? ?? 10 26 2C 00 C2 8F 11 00 40 14 00 00 00 00 58 00 C6 8F 10 00 A0 AF 14 00 B0 AF 18 00 A0 AF 21 20 20 02 21 28 80 02 ?? ?? ?? 0? 21 38 00 00 21 20 40 02 ?? ?? A5 24 ?? ?? ?? 0? 08 00 06 24 1D FF 40 10 00 00 00 00 ?? ?? ?? 0? 04 00 03 8E ?? ?? ?? 0? 58 00 C4 8F 0F 00 43 24 C2 18 03 00 C0 18 03 00 58 00 C5 8F 23 E8 A3 03 20 00 A4 27 ?? ?? ?? 0? 01 00 46 24 58 00 C4 8F ?? ?? ?? 0? 58 00 C2 AF ?? ?? ?? 0? 58 00 C6 8F ?? ?? 10 3C ?? ?? ?? 0? ?? ?? 10 26 09 00 02 92 0C 00 43 10 21 88 00 00 ?? ?? 10 3C ?? ?? ?? 0? ?? ?? 10 26 0B 00 03 92 2C FF 60 14 03 00 04 24 02 00 42 2C 00 FF 40 14 ?? ?? 05 3C ?? ?? ?? 0? 04 00 03 8E 0A 00 03 92 04 00 62 10 00 00 00 00 ?? ?? 10 3C ?? ?? ?? 0? ?? ?? 10 26 0B 00 02 92 1C 00 40 10 03 00 03 24 12 00 43 10 21 88 00 00 ?? ?? 10 3C ?? ?? ?? 0? ?? ?? 10 26 ?? ?? 10 3C 21 88 00 00 ?? ?? ?? 0? ?? ?? 10 26 ?? ?? ?? 0? 21 30 40 00 ?? ?? 10 3C 21 88 00 00 ?? ?? ?? 0? ?? ?? 10 26 ?? ?? 10 3C 21 88 00 00 ?? ?? ?? 0? ?? ?? 10 26 0C 00 02 92 03 00 42 2C 09 00 40 14 ?? ?? 05 3C ?? ?? 10 3C 21 88 00 00 ?? ?? ?? 0? ?? ?? 10 26 0C 00 02 92 02 00 42 2C F9 FF 40 10 ?? ?? 05 3C 0D 00 04 26 ?? ?? A5 24 ?? ?? ?? 0? 07 00 06 24 04 00 40 10 21 88 00 00 ?? ?? 10 3C ?? ?? ?? 0? ?? ?? 10 26 ?? ?? 10 3C ?? ?? ?? 0? ?? ?? 10 26 }
	condition:
		$1
}

rule file_247_8_0 {
	meta:
		name = "open_path.isra.5"
		size = 1504
		refs = "0008 __gnu_local_gp 009c __libc_errno 00a4 _dl_debug_mask 00cc mempcpy 0268 _dl_ns 02b8 __xstat64 02f4 malloc 031c memcpy 037c $LC46 0384 _dl_debug_printf 0170 __libc_enable_secure 03ac __fxstat64 03cc __close 0400 $LC43 04d0 $LC40 04d8 $LC41 04ec _dl_debug_printf_c 0540 _dl_argv 0554 $LC42 055c $LC44 0530 $LC45 05bc free"
	strings:
		$1 = { 00 00 E2 8C F8 FE BD 27 ?? ?? 1C 3C ?? ?? 9C 27 00 01 BE AF 21 F0 A0 03 04 01 BF AF FC 00 B7 AF F8 00 B6 AF F4 00 B5 AF F0 00 B4 AF EC 00 B3 AF E8 00 B2 AF E4 00 B1 AF E0 00 B0 AF 10 00 DC AF 14 01 C7 AF BC 00 C2 AF 08 01 C4 AF 0C 01 C5 AF 6C 00 40 10 10 01 C6 AF ?? ?? 04 3C ?? ?? 83 8C ?? ?? 04 3C ?? ?? 82 8C BC 00 C4 8F C0 00 C0 AF 21 10 62 00 0C 01 C3 8F 00 00 96 8C C8 00 C0 AF 21 10 43 00 0E 00 42 24 C2 10 02 00 C0 10 02 00 3B E8 03 7C 23 E8 A2 03 21 10 60 00 ?? ?? 83 8F 10 00 B0 27 ?? ?? 13 3C 21 18 62 00 ?? ?? 12 3C C4 00 C3 AF ?? ?? 62 8E 01 00 42 30 CA 00 40 14 C8 00 C3 8F 0C 00 C5 8E 10 00 C6 8E ?? ?? ?? 0? 21 20 00 02 ?? ?? 44 8E A6 00 80 10 B8 00 C2 AF 21 A0 C0 02 21 B8 00 00 21 B0 E0 02 21 88 00 00 ?? ?? 15 3C ?? ?? ?? 0? 21 B8 80 02 C0 10 16 00 B8 00 C4 8F 21 10 A2 00 00 00 45 8C ?? ?? ?? 0? 04 00 46 8C 08 01 C5 8F 0C 01 C6 8F ?? ?? ?? 0? 21 20 40 00 ?? ?? 64 8E 01 00 84 30 93 00 80 14 23 A0 50 00 1C 01 C5 8F 24 01 C6 8F 21 20 00 02 ?? ?? ?? 0? 21 38 00 00 14 00 E4 8E 3B 00 80 14 21 38 40 00 FF FF 02 24 3F 00 E2 10 02 00 02 24 14 00 E2 AE 01 00 11 24 10 01 C2 8F 89 00 40 14 ?? ?? 02 3C FF FF 02 24 5D 00 E2 14 01 00 C8 26 ?? ?? 42 8E 21 B0 00 01 2B 10 02 01 0B 00 40 10 04 00 F7 26 14 00 E4 8E 01 00 02 24 D7 FF 82 14 ?? ?? A5 8E 01 00 C8 26 ?? ?? 42 8E 21 B0 00 01 2B 10 02 01 F7 FF 40 14 04 00 F7 26 07 00 20 12 C4 00 C3 8F 00 00 62 8C 02 00 03 24 03 00 43 10 0D 00 03 24 0C 00 43 14 FF FF 02 24 BC 00 C4 8F C0 00 C3 8F 04 00 84 24 00 00 96 8C 25 18 71 00 BC 00 C4 AF AF FF C0 16 C0 00 C3 AF EC 00 60 10 14 01 C4 8F FF FF 02 24 21 E8 C0 03 04 01 BF 8F 00 01 BE 8F FC 00 B7 8F F8 00 B6 8F F4 00 B5 8F F0 00 B4 8F EC 00 B3 8F E8 00 B2 8F E4 00 B1 8F E0 00 B0 8F 08 00 E0 03 08 01 BD 27 01 00 84 38 2B 20 04 00 FF FF 02 24 C7 FF E2 14 25 88 24 02 ?? ?? ?? 0? 01 00 C8 26 20 01 C3 8F 0F 00 60 10 00 00 00 00 18 00 62 8C ?? ?? 03 3C ?? ?? 63 24 80 30 02 00 00 29 02 00 21 28 C5 00 23 10 A2 00 80 10 02 00 21 10 43 00 00 00 42 8C 68 02 42 8C 00 08 42 30 13 00 40 14 01 00 04 24 0C 01 C4 8F 21 A0 14 02 21 28 00 02 27 10 04 00 21 A0 82 02 00 00 80 A2 03 00 04 24 ?? ?? ?? 0? 18 00 C6 27 06 00 40 14 01 00 02 24 30 00 C4 8F 00 40 02 24 00 F0 84 30 22 00 82 10 01 00 02 24 14 00 E2 AE 21 20 00 00 25 88 24 02 ?? ?? ?? 0? 01 00 C8 26 21 20 80 02 ?? ?? ?? 0? D8 00 C7 AF 18 01 C3 8F 21 B0 80 02 D8 00 C7 8F A5 00 40 10 00 00 62 AC 21 28 00 02 21 30 C0 02 21 20 40 00 ?? ?? ?? 0? D8 00 C7 AF D8 00 C7 8F 21 E8 C0 03 04 01 BF 8F 00 01 BE 8F FC 00 B7 8F F8 00 B6 8F F4 00 B5 8F F0 00 B4 8F EC 00 B3 8F E8 00 B2 8F E4 00 B1 8F E0 00 B0 8F 21 10 E0 00 08 00 E0 03 08 01 BD 27 02 00 02 24 01 00 04 24 14 00 E2 AE ?? ?? ?? 0? 25 88 24 02 ?? ?? ?? 0? 21 88 00 00 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 21 28 00 02 ?? ?? ?? 0? 1C 01 C5 8F ?? ?? 42 8C 77 FF 40 10 FF FF 02 24 21 28 E0 00 03 00 04 24 18 00 C6 27 ?? ?? ?? 0? D8 00 C7 AF 05 00 40 14 D8 00 C7 8F 30 00 C2 8F 00 08 42 30 6C FF 40 14 FF FF 02 24 ?? ?? ?? 0? 21 20 E0 00 C4 00 C3 8F 02 00 02 24 FF FF 07 24 ?? ?? ?? 0? 00 00 62 AC 04 00 D4 8E 35 FF 83 12 ?? ?? 04 3C ?? ?? 03 3C ?? ?? 85 8C ?? ?? 62 8C ?? ?? 03 3C D0 00 DD AF 21 10 A2 00 07 00 42 24 C2 10 02 00 C0 10 02 00 23 E8 A2 03 ?? ?? 64 24 ?? ?? ?? 0? 08 00 D7 8E BC 00 C4 8F 00 00 82 8C 3E 00 40 10 10 00 B5 27 04 00 44 8C 3B 00 84 16 01 00 03 24 BC 00 D1 8F B8 00 C3 AF 11 00 A3 27 CC 00 D6 AF D4 00 C3 AF C8 00 D0 AF 21 B0 A0 02 0C 00 45 8C 10 00 46 8C ?? ?? ?? 0? 21 20 C0 02 ?? ?? 44 8E 24 00 80 10 21 80 40 00 21 A8 00 00 00 00 23 8E 04 00 A2 26 80 10 02 00 21 10 62 00 04 00 42 8C 01 00 03 24 C0 28 15 00 15 00 43 10 21 20 00 02 ?? ?? 03 3C ?? ?? 62 8C 21 10 45 00 00 00 45 8C ?? ?? ?? 0? 04 00 46 8C 31 00 C2 12 D4 00 C3 8F 2C 00 43 10 2F 00 03 24 FF FF 40 A0 ?? ?? 02 3C ?? ?? 44 24 ?? ?? 02 3C ?? ?? 43 24 B8 00 C2 8F 21 28 C0 02 B8 00 C0 AF ?? ?? ?? 0? 0A 20 62 00 ?? ?? 42 8E 01 00 B5 26 2B 10 A2 02 DF FF 40 14 00 00 00 00 04 00 31 26 00 00 22 8E 04 00 40 10 00 00 00 00 04 00 44 8C D0 FF 84 12 00 00 00 00 C8 00 D0 8F CC 00 D6 8F 17 00 E0 12 ?? ?? 04 3C 00 00 E2 82 08 00 40 14 21 30 E0 02 ?? ?? 02 3C ?? ?? 42 8C 00 00 46 8C 03 00 C0 14 00 00 00 00 ?? ?? 06 3C ?? ?? C6 24 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 21 28 80 02 C8 00 D4 AF ?? ?? ?? 0? D0 00 DD 8F 00 00 C4 82 D3 FF 83 14 00 00 00 00 ?? ?? ?? 0? 00 00 40 A0 ?? ?? 84 24 ?? ?? ?? 0? 21 28 80 02 ?? ?? ?? 0? C8 00 D4 AF ?? ?? ?? 0? 21 20 E0 00 ?? ?? ?? 0? FF FF 02 24 04 00 82 8C 04 00 40 10 14 01 C3 8F ?? ?? ?? 0? 00 00 84 8C 14 01 C3 8F ?? ?? 02 3C ?? ?? 42 24 0C FF 62 10 FF FF 02 24 ?? ?? ?? 0? 00 00 62 AC }
	condition:
		$1
}

rule file_247_9_0 {
	meta:
		name = "add_path.9517.isra.1.constprop.7"
		size = 288
		refs = "00c4 mempcpy"
	strings:
		$1 = { FF FF 02 24 40 00 82 10 00 00 00 00 C8 FF BD 27 00 00 82 8C 30 00 B5 AF 2C 00 B4 AF 28 00 B3 AF 20 00 B1 AF 1C 00 B0 AF 34 00 BF AF 24 00 B2 AF 21 80 E0 01 04 00 91 24 2E 00 15 24 2F 00 14 24 ?? ?? ?? 0? 02 00 13 24 08 00 03 8E 10 00 42 8C 04 00 31 26 00 00 65 8C 02 00 46 2C 0B 10 66 02 04 00 64 8C 21 10 A2 00 00 00 62 AC FC FF 22 8E 01 00 84 24 1C 00 40 10 04 00 64 AC 0C 00 03 92 F1 FF 60 14 21 48 80 02 04 00 07 8E 10 00 45 8C 08 00 12 8E 00 00 03 8E 01 00 E7 24 C0 40 07 00 FF FF A6 24 0A 48 A5 02 21 90 48 02 02 00 A5 2C 04 00 07 AE 21 20 60 00 01 00 6A 24 14 00 A0 14 00 00 43 AE ?? ?? ?? 0? 0C 00 45 8C 01 00 43 24 00 00 03 AE 04 00 31 26 00 00 40 A0 FC FF 22 8E E6 FF 40 14 04 00 40 AE 34 00 BF 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 38 00 BD 27 08 00 E0 03 00 00 00 00 00 00 0A AE 00 00 69 A0 ?? ?? ?? 0? 00 00 02 8E }
	condition:
		$1
}

rule file_247_10_0 {
	meta:
		name = "elf_machine_matches_host"
		size = 60
	strings:
		$1 = { 24 00 83 8C 20 04 63 30 08 00 60 14 21 10 00 00 12 00 83 94 08 00 04 24 06 00 64 10 00 00 00 00 0A 00 04 24 03 00 64 10 00 00 00 00 08 00 E0 03 00 00 00 00 08 00 E0 03 01 00 02 24 }
	condition:
		$1
}

rule file_247_11_0 {
	meta:
		name = "expand_dynamic_string_token"
		size = 372
		refs = "002c strchr 0060 _dl_dst_count 0070 strlen 0098 _dl_platformlen 00c8 malloc 00fc _dl_dst_substitute 0114 _dl_get_origin 0110 $LC51 0158 $LC3 016c __assert_fail 015c __PRETTY_FUNCTION__.9168"
	strings:
		$1 = { D0 FF BD 27 18 00 B0 AF 21 80 A0 00 1C 00 B1 AF 24 00 05 24 21 88 80 00 21 20 00 02 20 00 B2 AF 2C 00 BF AF 28 00 B4 AF 24 00 B3 AF ?? ?? ?? 0? 21 90 C0 00 0A 00 40 14 21 20 40 00 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 21 20 00 02 18 00 B0 8F ?? ?? ?? 0? 30 00 BD 27 ?? ?? ?? 0? 21 28 40 02 F4 FF 40 10 21 A0 40 00 ?? ?? ?? 0? 21 20 00 02 7C 02 24 8E 21 00 80 10 21 98 40 00 FF FF 02 24 03 00 82 10 21 10 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 03 3C ?? ?? 64 8C 03 00 03 24 03 00 85 2C 0A 18 85 00 2B 20 62 00 0A 10 64 00 05 00 43 2C 03 00 60 14 FC FF 42 24 02 18 54 70 21 98 73 00 ?? ?? ?? 0? 01 00 64 26 19 00 40 10 21 30 40 00 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 21 20 20 02 21 28 00 02 1C 00 B1 8F 18 00 B0 8F 21 38 40 02 20 00 B2 8F ?? ?? ?? 0? 30 00 BD 27 04 00 22 8E 00 00 42 80 12 00 40 14 ?? ?? 04 3C ?? ?? ?? 0? 00 00 00 00 21 20 40 00 FF FF 42 24 FE FF 42 2C D9 FF 40 14 7C 02 24 AE ?? ?? ?? 0? 21 10 00 00 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 B0 01 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_247_12_0 {
	meta:
		name = "cache_rpath.part.6"
		size = 476
		refs = "0048 _dl_inhibit_rpath 009c malloc 00b0 $LC53 00cc free 0134 __libc_enable_secure 01b8 $LC0 01c8 _dl_signal_error 01d0 $LC52"
	strings:
		$1 = { 08 00 C6 24 80 30 06 00 21 30 86 00 00 00 C2 8C C8 FF BD 27 20 00 B0 AF 34 00 BF AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF 36 00 40 10 21 80 A0 00 34 00 83 8C 00 00 86 8C 21 88 E0 00 04 00 65 8C 04 00 43 8C ?? ?? 02 3C ?? ?? 42 8C 21 28 C5 00 21 28 A3 00 36 00 40 14 04 00 92 8C ?? ?? ?? 0? 01 00 06 24 59 00 40 10 21 98 40 00 00 00 43 80 22 00 60 10 21 30 40 00 21 40 00 00 01 00 C6 24 3A 00 69 38 00 00 C3 80 01 00 29 2D FB FF 60 14 21 40 09 01 02 00 04 25 ?? ?? ?? 0? 80 20 04 00 21 A0 40 00 41 00 40 10 21 20 60 02 ?? ?? 06 3C 21 28 40 00 ?? ?? C6 24 21 38 00 00 10 00 B1 AF ?? ?? ?? 0? 14 00 B2 AF ?? ?? ?? 0? 21 20 60 02 34 00 BF 8F 01 00 02 24 00 00 14 AE 04 00 02 AE 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? 21 20 40 00 34 00 BF 8F FF FF 02 24 00 00 02 AE 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 21 10 00 00 08 00 E0 03 38 00 BD 27 ?? ?? 03 3C ?? ?? 63 8C C8 FF 60 14 21 30 40 02 00 00 43 80 ?? ?? ?? 0? 3A 00 08 24 ED FF 60 10 01 00 C6 24 01 00 43 80 01 00 42 24 00 00 C7 80 FA FF E3 10 00 00 00 00 05 00 E0 14 00 00 00 00 E5 FF 60 10 34 00 BF 8F E3 FF 68 10 00 00 00 00 B6 FF 60 10 00 00 00 00 03 00 68 10 01 00 42 24 ?? ?? ?? 0? 00 00 43 80 00 00 43 80 AF FF 60 10 21 30 40 02 ?? ?? ?? 0? 00 00 C7 80 ?? ?? ?? 0? 00 00 00 00 ?? ?? 07 3C ?? ?? E7 24 0C 00 04 24 21 28 00 00 ?? ?? ?? 0? 21 30 00 00 ?? ?? 07 3C ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_247_13_0 {
	meta:
		name = "_dl_dst_count"
		size = 244
		refs = "0004 __libc_enable_secure 0014 $LC47 0018 $LC48 001c $LC49 00b8 strchr"
	strings:
		$1 = { C0 FF BD 27 ?? ?? 02 3C 38 00 B6 AF 30 00 B4 AF 2C 00 B3 AF ?? ?? 14 3C ?? ?? 13 3C ?? ?? 16 3C 34 00 B5 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF ?? ?? 55 8C 3C 00 BF AF 21 80 80 00 21 88 A0 00 21 10 80 00 21 90 00 00 ?? ?? 94 26 ?? ?? 73 26 ?? ?? D6 26 01 00 4A 24 21 20 00 02 21 28 40 01 21 30 80 02 21 38 20 02 ?? ?? ?? 0? 10 00 B5 AF 21 28 40 01 21 20 00 02 21 30 60 02 0C 00 40 14 21 38 20 02 ?? ?? ?? 0? 10 00 A0 AF 21 28 40 01 21 20 00 02 21 30 C0 02 05 00 40 14 21 38 20 02 ?? ?? ?? 0? 10 00 A0 AF 03 00 40 10 21 20 42 01 01 00 52 26 21 20 42 01 ?? ?? ?? 0? 24 00 05 24 E5 FF 40 14 01 00 4A 24 3C 00 BF 8F 21 10 40 02 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_247_14_0 {
	meta:
		name = "_dl_dst_substitute"
		size = 772
		refs = "0004 $LC47 0038 $LC48 0040 $LC49 0064 __libc_enable_secure 0210 _dl_platform 006c $LC50 02a4 stpcpy"
	strings:
		$1 = { A0 FF BD 27 ?? ?? 02 3C 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF 5C 00 BF AF 40 00 B2 AF 3C 00 B1 AF 38 00 B0 AF ?? ?? 4E 24 00 00 B0 80 ?? ?? 02 3C ?? ?? 4C 24 ?? ?? 02 3C 21 B0 A0 00 21 A0 C0 00 21 F0 80 00 21 98 E0 00 21 B8 C0 00 21 50 C0 00 21 58 A0 00 21 A8 00 00 ?? ?? 0D 3C ?? ?? 49 24 ?? ?? 08 3C 24 00 03 24 13 00 03 12 01 00 51 25 00 00 50 A1 01 00 72 25 04 00 60 12 01 00 70 81 3A 00 03 24 06 00 03 12 00 00 00 00 31 00 00 12 00 00 00 00 21 50 20 02 ?? ?? ?? 0? 21 58 40 02 3C 00 A0 16 23 28 37 02 21 B8 20 02 21 50 20 02 ?? ?? ?? 0? 21 58 40 02 ?? ?? AF 8D 01 00 72 25 21 20 C0 02 10 00 AF AF 21 28 40 02 21 30 C0 01 21 38 60 02 30 00 A8 AF ?? ?? ?? 0? 2C 00 A9 AF 21 80 40 00 30 00 A8 8F 3A 00 40 10 2C 00 A9 8F 7C 02 C5 8F 04 00 E0 11 21 A8 00 00 68 02 D5 8F 03 00 B5 32 01 00 B5 2E FF FF A2 24 FE FF 42 2C 5B 00 40 14 02 00 02 2E 45 00 40 14 24 00 02 24 21 90 50 02 00 00 42 82 0A 00 40 10 21 88 E0 02 3A 00 03 24 03 00 60 12 00 00 00 00 34 00 43 10 00 00 00 00 01 00 52 26 00 00 42 82 F9 FF 40 14 21 88 E0 02 5C 00 A0 16 00 00 00 00 00 00 20 A2 5C 00 BF 8F 21 10 80 02 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 60 00 BD 27 21 20 E0 02 30 00 A8 AF 2C 00 A9 AF 28 00 AC AF 20 00 AD AF ?? ?? ?? 0? 24 00 AE AF 0A 88 E2 02 21 A8 00 00 30 00 A8 8F 2C 00 A9 8F 28 00 AC 8F 20 00 AD 8F 24 00 AE 8F ?? ?? ?? 0? 21 B8 20 02 10 00 A0 AF 21 20 C0 02 21 28 40 02 21 30 80 01 21 38 60 02 30 00 A8 AF ?? ?? ?? 0? 2C 00 A9 AF 21 80 40 00 30 00 A8 8F 12 00 40 10 2C 00 A9 8F ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 45 8C 32 00 F4 12 00 00 00 00 00 00 50 82 9D FF 00 16 21 88 E0 02 ?? ?? ?? 0? 00 00 00 00 24 00 02 24 00 00 42 A1 01 00 70 81 96 FF 00 16 01 00 51 25 ?? ?? ?? 0? 00 00 00 00 21 30 20 01 10 00 A0 AF 21 20 C0 02 21 28 40 02 21 38 60 02 30 00 A8 AF ?? ?? ?? 0? 2C 00 A9 AF 21 80 40 00 30 00 A8 8F EE FF 40 10 2C 00 A9 8F ?? ?? ?? 0? ?? ?? 05 25 21 20 40 01 21 90 50 02 30 00 A8 AF 2C 00 A9 AF 28 00 AC AF 20 00 AD AF ?? ?? ?? 0? 24 00 AE AF 00 00 50 82 21 88 40 00 30 00 A8 8F 2C 00 A9 8F 28 00 AC 8F 20 00 AD 8F 76 FF 00 16 24 00 AE 8F ?? ?? ?? 0? 00 00 00 00 23 28 37 02 ?? ?? ?? 0? 21 20 E0 02 ?? ?? ?? 0? 0A 88 E2 02 01 00 50 82 CD FF 00 12 00 00 00 00 21 88 80 02 01 00 52 26 ?? ?? ?? 0? 21 B8 20 02 }
	condition:
		$1
}

rule file_247_15_0 {
	meta:
		name = "_dl_init_paths"
		size = 700
		refs = "0000 _dl_platformlen 000c _dl_platform 0044 _dl_important_hwcaps 0058 malloc 00a4 _dl_all_dirs 00b4 $LC55 019c strlen 01bc memcpy 020c __libc_enable_secure 0214 $LC57 021c $LC56 0274 free 0298 $LC0 02a8 _dl_signal_error 02b0 $LC54"
	strings:
		$1 = { ?? ?? 02 3C C0 FF BD 27 ?? ?? 45 8C ?? ?? 02 3C 28 00 B1 AF 21 88 80 00 ?? ?? 44 8C 24 00 B0 AF ?? ?? 07 3C ?? ?? 10 3C 38 00 BE AF ?? ?? 06 26 21 F0 A0 03 ?? ?? E7 24 3C 00 BF AF 34 00 B4 AF 2C 00 B2 AF ?? ?? ?? 0? 30 00 B3 AF ?? ?? 03 3C 0C 00 04 24 ?? ?? 62 AC ?? ?? ?? 0? ?? ?? 14 3C 21 90 40 00 92 00 40 10 ?? ?? 82 AE ?? ?? 10 8E CC CC 02 3C CD CC 42 34 80 98 10 00 27 00 73 26 19 00 62 02 10 98 00 00 02 99 13 00 00 12 13 00 80 21 13 00 ?? ?? ?? 0? 21 20 82 00 7E 00 40 10 00 00 42 AE ?? ?? 03 3C ?? ?? 62 AC ?? ?? 03 3C ?? ?? 63 24 ?? ?? 05 3C 80 20 13 00 ?? ?? 94 26 ?? ?? A5 24 00 99 13 00 0C 00 43 AC 05 00 03 24 04 00 80 AE 04 00 45 AC 08 00 40 AC 10 00 43 AC 07 00 00 12 21 20 93 00 21 30 40 00 21 18 00 00 01 00 63 24 14 00 C0 AC FD FF 70 14 04 00 C6 24 21 20 44 00 00 00 44 AC ?? ?? 02 3C ?? ?? 42 24 0C 00 82 AC 09 00 02 24 04 00 44 AE 04 00 85 AC 08 00 80 AC 10 00 82 AC 21 30 80 00 05 00 00 12 21 18 00 00 01 00 63 24 14 00 C0 AC FD FF 70 14 04 00 C6 24 09 00 03 24 ?? ?? 02 3C 00 00 80 AC ?? ?? 43 AC 04 00 20 12 08 00 40 AE 00 00 22 82 0E 00 40 14 00 00 00 00 21 E8 C0 03 3C 00 BF 8F FF FF 03 24 ?? ?? 02 3C 38 00 BE 8F 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F ?? ?? 43 AC 08 00 E0 03 40 00 BD 27 ?? ?? ?? 0? 21 20 20 02 0F 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 A4 27 21 28 20 02 ?? ?? ?? 0? 01 00 46 24 00 00 23 82 31 00 60 10 21 90 40 00 01 00 05 24 01 00 31 26 C6 FF 66 24 00 00 23 82 FF 00 C6 30 02 00 C6 2C FA FF 60 14 21 28 A6 00 01 00 A4 24 80 20 04 00 ?? ?? ?? 0? ?? ?? 10 3C 21 28 40 00 24 00 40 10 ?? ?? 02 AE ?? ?? 02 3C ?? ?? 47 8C ?? ?? 02 3C ?? ?? 42 24 ?? ?? 06 3C 21 20 40 02 10 00 A2 AF 14 00 A0 AF ?? ?? ?? 0? ?? ?? C6 24 ?? ?? 04 8E 00 00 82 8C 0D 00 40 10 00 00 00 00 ?? ?? 10 26 04 00 00 AE 21 E8 C0 03 3C 00 BF 8F 38 00 BE 8F 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? ?? 0? 00 00 00 00 FF FF 02 24 ?? ?? 02 AE ?? ?? 10 26 ?? ?? ?? 0? 04 00 00 AE ?? ?? ?? 0? 08 00 04 24 ?? ?? 07 3C ?? ?? E7 24 0C 00 04 24 21 28 00 00 ?? ?? ?? 0? 21 30 00 00 ?? ?? 07 3C ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_247_16_0 {
	meta:
		name = "_dl_map_object"
		size = 2320
		refs = "000c __gnu_local_gp 0044 _dl_nns 0064 _dl_ns 00c8 _dl_name_match_p 0108 _dl_debug_mask 0124 strchr 019c __libc_stack_end 0230 strlen 0330 _dl_inhibit_cache 0340 _dl_load_cache_lookup 03bc $LC65 03c4 _dl_debug_printf 0530 $LC63 058c strcmp 05c0 __close 0670 $LC64 06a4 memcmp 0724 _dl_new_object 073c dummy_bucket.9506 075c _dl_add_to_namespace_list 0784 $LC58 0798 _dl_argv 07ac $LC42 07e8 $LC59 07f4 free 080c _dl_signal_error 07fc $LC5 081c $LC66 0860 __libc_enable_secure 0880 __libc_errno 0884 $LC67 089c $LC62 08b8 $LC61 08bc $LC3 08d0 __assert_fail 08c0 __PRETTY_FUNCTION__.9479 08d8 $LC60"
	strings:
		$1 = { 78 FD BD 27 64 02 B1 AF 9C 02 B1 8F ?? ?? 1C 3C ?? ?? 9C 27 84 02 BF AF 80 02 BE AF 7C 02 B7 AF 78 02 B6 AF 74 02 B5 AF 70 02 B4 AF 6C 02 B3 AF 68 02 B2 AF 60 02 B0 AF 28 00 BC AF 26 02 20 06 94 02 A7 AF ?? ?? 02 3C ?? ?? 42 8C 2B 10 22 02 19 02 40 10 00 00 00 00 80 A8 11 00 00 B1 11 00 21 10 B6 02 ?? ?? 13 3C 23 10 51 00 80 10 02 00 ?? ?? 74 26 21 10 82 02 00 00 5E 8C 21 90 80 00 21 80 A0 00 0A 00 C0 17 21 B8 C0 00 ?? ?? ?? 0? ?? ?? 1E 3C 68 02 C2 8F 00 02 42 7C 32 01 40 10 00 00 00 00 0C 00 DE 8F 17 00 C0 13 00 00 00 00 68 02 C2 8F 40 02 44 7C FA FF 80 14 40 03 42 7C F8 FF 40 14 21 20 00 02 ?? ?? ?? 0? 21 28 C0 03 F0 FF 40 10 21 10 C0 03 84 02 BF 8F 80 02 BE 8F 7C 02 B7 8F 78 02 B6 8F 74 02 B5 8F 70 02 B4 8F 6C 02 B3 8F 68 02 B2 8F 64 02 B1 8F 60 02 B0 8F 08 00 E0 03 88 02 BD 27 ?? ?? 1E 3C ?? ?? C3 8F 40 00 62 30 95 01 40 14 21 20 00 02 2F 00 05 24 58 02 A3 AF ?? ?? ?? 0? 3C 02 A0 A3 3B 00 40 10 58 02 A3 8F AA 00 40 12 98 02 A3 8F 00 10 02 3C 24 10 62 00 40 02 A2 AF 21 20 40 02 21 28 00 02 ?? ?? ?? 0? 21 30 00 00 28 00 BC 8F 9E 00 40 10 38 02 A2 AF 30 00 A5 27 21 20 40 00 3C 02 A6 27 ?? ?? ?? 0? 01 00 07 24 21 28 40 00 FF FF 02 24 DD 01 A2 10 28 00 BC 8F 40 02 A3 8F FF FF 02 24 53 01 A2 10 0B 90 03 00 98 02 A3 8F ?? ?? 02 3C 38 02 A7 8F ?? ?? 42 8C 18 00 A3 AF 34 02 A3 27 10 00 B2 AF 14 00 B7 AF 1C 00 A3 AF 20 00 B1 AF 21 20 00 02 30 00 A6 27 ?? ?? ?? 0? 34 02 A2 AF 84 02 BF 8F 80 02 BE 8F 7C 02 B7 8F 78 02 B6 8F 74 02 B5 8F 70 02 B4 8F 6C 02 B3 8F 68 02 B2 8F 64 02 B1 8F 60 02 B0 8F 08 00 E0 03 88 02 BD 27 21 20 00 02 2F 00 05 24 58 02 A3 AF ?? ?? ?? 0? 3C 02 A0 A3 72 00 40 14 58 02 A3 8F 98 02 A4 8F 00 10 02 3C 24 10 82 00 40 02 A2 AF 21 20 00 02 ?? ?? ?? 0? 58 02 A3 AF 58 02 A3 8F 01 00 42 24 28 00 BC 8F 01 00 63 30 94 01 60 14 48 02 A2 AF 6B 00 40 12 ?? ?? 63 8E 94 00 42 8E 8D 00 40 10 00 04 02 3C 98 02 A3 8F 00 04 02 3C 24 10 62 00 44 02 A2 AF ?? ?? 07 3C ?? ?? E2 8C FF FF 03 24 13 00 43 10 ?? ?? 62 8E 38 02 A4 27 48 02 A5 8F 0B 10 52 02 44 02 A6 8F 10 00 A4 AF 18 00 A2 AF 30 00 A4 27 3C 02 A2 27 14 00 A4 AF 1C 00 A2 AF 21 20 00 02 ?? ?? E7 24 ?? ?? ?? 0? 58 02 A3 AF 58 02 A3 8F 28 00 BC 8F 38 00 43 14 21 28 40 00 15 00 40 12 FF FF 03 24 C0 02 42 8E 12 00 43 10 C0 02 53 26 E2 00 40 10 38 02 A2 27 10 00 A2 AF 48 02 A5 8F 30 00 A2 27 44 02 A6 8F 14 00 A2 AF 3C 02 A2 27 18 00 B2 AF 1C 00 A2 AF 21 20 00 02 ?? ?? ?? 0? 21 38 60 02 21 28 40 00 FF FF 02 24 22 00 A2 14 28 00 BC 8F 44 02 A3 8F 4C 01 60 14 ?? ?? 02 3C ?? ?? 42 8C A4 00 40 14 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 21 98 40 00 9F 00 40 10 28 00 BC 8F 06 00 40 12 30 00 A5 27 DC 02 43 8E 00 08 62 30 CC 00 40 14 ?? ?? 05 3C 30 00 A5 27 21 20 60 02 3C 02 A6 27 ?? ?? ?? 0? 21 38 00 00 21 28 40 00 FF FF 02 24 90 00 A2 10 28 00 BC 8F 21 20 60 02 ?? ?? ?? 0? 54 02 A5 AF 38 02 A2 AF 28 00 BC 8F 86 00 40 10 54 02 A5 8F ?? ?? C2 8F 01 00 42 30 75 FF 40 10 40 02 A3 8F ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 54 02 A5 AF 28 00 BC 8F ?? ?? ?? 0? 54 02 A5 8F ?? ?? ?? 0? FF FF 05 24 ?? ?? ?? 0? 21 20 00 02 98 02 A4 8F 00 10 03 3C 28 00 BC 8F 24 18 83 00 ?? ?? ?? 0? 40 02 A3 AF 00 04 02 3C 4C 02 A3 AF 98 02 A3 8F 24 10 62 00 44 02 A2 AF 4C 02 A3 8F 96 FF 60 10 02 00 02 24 68 02 63 8C 03 00 63 30 92 FF 62 10 4C 02 A3 8F FF FF 04 24 6C 02 62 8C 8E FF 44 10 6C 02 63 24 FB 00 40 10 4C 02 A2 8F 38 02 A4 27 48 02 A5 8F 0B 10 52 02 44 02 A6 8F 10 00 A4 AF 18 00 A2 AF 30 00 A4 27 3C 02 A2 27 14 00 A4 AF 1C 00 A2 AF 21 20 00 02 ?? ?? ?? 0? 21 38 60 00 21 28 40 00 FF FF 02 24 C9 FF A2 14 28 00 BC 8F ?? ?? ?? 0? ?? ?? 07 3C 50 02 A0 AF 4C 02 A3 AF 98 02 A3 8F 24 10 62 00 44 02 A2 AF ?? ?? ?? 0? 21 18 40 02 48 02 A5 8F 44 02 A6 8F 10 00 A4 AF 30 00 A2 27 3C 02 A4 27 1C 00 A4 AF 14 00 A2 AF 18 00 B2 AF 21 20 00 02 21 38 00 01 ?? ?? ?? 0? 58 02 A3 AF 21 28 40 00 FF FF 02 24 28 00 BC 8F AF FF A2 14 58 02 A3 8F 4C 02 A4 8F 26 10 64 00 50 02 A4 8F 01 00 42 2C 25 20 82 00 50 02 A4 AF 40 02 63 8C 4A 00 60 10 00 00 00 00 6C 02 62 8C FF FF 04 24 FA FF 44 10 6C 02 68 24 E1 FF 40 14 38 02 A4 27 ?? ?? 07 3C 21 20 60 00 21 28 00 01 0F 00 06 24 ?? ?? E7 24 58 02 A3 AF ?? ?? ?? 0? 54 02 A8 AF 28 00 BC 8F 58 02 A3 8F EC FF 40 10 54 02 A8 8F ?? ?? ?? 0? 38 02 A4 27 58 00 C2 8F CD FE 40 10 00 00 00 00 34 00 C4 8F 04 00 45 8C 00 00 C2 8F 04 00 86 8C 21 20 00 02 21 28 C5 00 ?? ?? ?? 0? 21 28 A2 00 C3 FE 40 14 00 00 00 00 1C 00 C4 8F ?? ?? ?? 0? 21 28 00 02 68 02 C4 8F 01 00 05 24 21 10 C0 03 04 42 A4 7C ?? ?? ?? 0? 68 02 C4 AF ?? ?? ?? 0? 21 20 A0 00 28 00 BC 8F 20 00 40 12 21 10 B6 02 DC 02 43 8E 21 10 40 02 00 08 63 30 72 FF 60 14 FF FF 05 24 ?? ?? 07 3C ?? ?? E4 8C FF FF 03 24 0F 00 83 10 38 02 A3 27 48 02 A5 8F 44 02 A6 8F 10 00 A3 AF 18 00 A2 AF 30 00 A3 27 3C 02 A2 27 14 00 A3 AF 1C 00 A2 AF 21 20 00 02 ?? ?? ?? 0? ?? ?? E7 24 21 28 40 00 ?? ?? ?? 0? 28 00 BC 8F ?? ?? ?? 0? FF FF 05 24 50 02 A3 8F 08 FF 60 14 4C 02 A3 8F ?? ?? ?? 0? 00 00 00 00 23 10 51 00 80 10 02 00 21 A0 82 02 00 00 82 8E E2 FF 40 10 ?? ?? 07 3C ?? ?? ?? 0? DC 02 43 8C ?? ?? 07 3C 21 20 40 02 21 28 60 02 1D 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 27 FF 40 10 28 00 BC 8F ?? ?? ?? 0? 38 02 A2 27 21 20 60 02 ?? ?? A5 24 05 00 06 24 ?? ?? ?? 0? 58 02 A3 AF 28 00 BC 8F C9 FF 40 10 58 02 A3 8F ?? ?? 05 3C 21 20 60 02 ?? ?? A5 24 ?? ?? ?? 0? 09 00 06 24 28 00 BC 8F 26 FF 40 14 58 02 A3 8F ?? ?? ?? 0? 21 10 40 02 94 02 A3 8F 4B 00 60 10 3C 02 A2 93 ?? ?? C2 8F 00 08 42 30 47 00 40 14 3C 02 A2 93 ?? ?? ?? 0? 21 20 00 02 3B 00 40 10 21 98 40 00 98 02 A3 8F 21 38 40 02 14 00 B1 AF 10 00 A3 AF 21 20 40 00 21 28 00 02 ?? ?? ?? 0? 21 30 E0 02 31 00 40 10 21 90 40 00 68 02 43 8C 01 00 02 24 ?? ?? 04 3C 44 4A 43 7C 84 10 43 7C ?? ?? 84 24 60 02 44 AE 4C 02 42 AE 68 02 43 AE 21 20 40 02 ?? ?? ?? 0? 21 28 20 02 ?? ?? ?? 0? 21 10 40 02 A4 FE 40 12 00 10 02 3C 98 02 A3 8F 24 10 62 00 1A 00 40 14 40 02 A2 AF ?? ?? 04 3C ?? ?? 84 24 04 00 47 8E 00 00 E2 80 07 00 40 14 ?? ?? 02 3C ?? ?? 42 8C 00 00 47 8C 03 00 E0 14 00 00 00 00 ?? ?? 07 3C ?? ?? E7 24 18 00 42 8E 21 28 00 02 21 30 20 02 ?? ?? ?? 0? 10 00 A2 AF 21 20 00 02 2F 00 05 24 ?? ?? ?? 0? 3C 02 A0 A3 5C FE 40 14 21 20 40 02 ?? ?? ?? 0? ?? ?? C3 8F ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? ?? 0? 21 20 60 02 ?? ?? 07 3C 0C 00 04 24 21 28 00 02 21 30 00 00 ?? ?? ?? 0? ?? ?? E7 24 18 00 40 10 21 28 00 02 ?? ?? 07 3C 21 20 00 00 21 30 00 00 ?? ?? ?? 0? ?? ?? E7 24 4C 02 A4 8F ?? ?? 07 3C 21 28 60 00 0F 00 06 24 ?? ?? E7 24 ?? ?? ?? 0? 58 02 A3 AF 28 00 BC 8F 88 FE 40 10 58 02 A3 8F ?? ?? ?? 0? 4C 02 A2 8F ?? ?? 02 3C ?? ?? 42 8C 58 FF 40 14 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 42 8C 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F ?? ?? 07 3C 21 10 62 00 00 00 44 8C 21 30 00 00 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 04 3C ?? ?? 84 24 21 28 00 02 ?? ?? ?? 0? 21 30 20 02 ?? ?? ?? 0? 28 00 BC 8F ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 26 08 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 25 08 06 24 ?? ?? ?? 0? ?? ?? E7 24 38 02 A4 8F ?? ?? ?? 0? 54 02 A5 AF 28 00 BC 8F ?? ?? ?? 0? 54 02 A5 8F }
	condition:
		$1
}

rule file_247_17_0 {
	meta:
		name = "_dl_rtld_di_serinfo"
		size = 528
		refs = "0100 $LC63 0148 _dl_ns 0078 $LC64"
	strings:
		$1 = { C0 FF BD 27 FF 00 C6 30 2C 00 B1 AF 3C 00 BF AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 28 00 B0 AF 21 88 80 00 20 00 A5 AF 2B 00 C0 14 24 00 A6 A3 04 00 A3 8C 94 00 22 8E 1C 00 A0 AF 01 00 63 24 C0 18 03 00 21 28 A3 00 2D 00 40 10 18 00 A5 AF 18 00 B2 27 ?? ?? 02 3C ?? ?? 44 8C ?? ?? ?? 0? 21 78 40 02 C0 02 24 8E FF FF 02 24 05 00 82 10 00 00 00 00 54 00 80 10 ?? ?? 07 3C ?? ?? ?? 0? 21 78 40 02 DC 02 22 8E 00 08 42 30 41 00 40 10 ?? ?? 02 3C 24 00 A2 93 07 00 40 10 20 00 A2 8F 04 00 43 8C 00 00 44 8C 01 00 63 24 C0 18 03 00 21 18 83 00 00 00 43 AC 3C 00 BF 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 40 00 BD 27 21 18 00 00 01 00 63 24 94 00 22 8E C0 18 03 00 04 00 A0 AC 00 00 A0 AC 21 28 A3 00 1C 00 A0 AF D5 FF 40 14 18 00 A5 AF ?? ?? 07 3C 21 80 20 02 18 00 B2 27 FF FF 13 24 ?? ?? F4 24 6C 02 02 8E 05 00 53 10 21 20 40 00 21 00 40 10 6C 02 05 26 ?? ?? ?? 0? 21 78 40 02 40 02 10 8E F7 FF 00 16 00 00 00 00 18 00 22 8E C5 FF 40 14 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 50 8C C0 FF 00 12 02 00 02 24 68 02 03 8E 03 00 63 30 BD FF 62 10 ?? ?? 02 3C BA FF 11 12 FF FF 02 24 6C 02 04 8E B8 FF 82 10 ?? ?? 02 3C 1B 00 80 10 ?? ?? 07 3C ?? ?? ?? 0? 21 78 40 02 ?? ?? ?? 0? ?? ?? 02 3C ?? ?? 44 8C ?? ?? ?? 0? 21 78 40 02 ?? ?? ?? 0? 24 00 A2 93 21 20 00 02 0F 00 06 24 ?? ?? ?? 0? 21 38 80 02 DD FF 40 10 00 00 00 00 ?? ?? ?? 0? 6C 02 04 8E 21 20 20 02 C0 02 25 26 1D 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 A9 FF 40 10 00 00 00 00 ?? ?? ?? 0? C0 02 24 8E 21 20 00 02 6C 02 05 26 0F 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 94 FF 40 10 00 00 00 00 ?? ?? ?? 0? 6C 02 04 8E }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "ppoll"
		size = 692
		refs = "0004 __gnu_local_gp 00a4 __libc_errno 0160 __sigprocmask 0170 __poll 0194 __libc_enable_asynccancel 01fc __libc_disable_asynccancel"
	strings:
		$1 = { 30 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 C8 00 BE AF 21 F0 A0 03 C4 00 B4 AF C0 00 B3 AF BC 00 B2 AF B4 00 B0 AF CC 00 BF AF B8 00 B1 AF 10 00 DC AF 21 80 C0 00 21 A0 80 00 21 98 A0 00 80 00 C0 10 21 90 E0 00 00 00 C3 8C 04 00 C2 8C 98 00 D0 27 98 00 C3 AF 9C 00 C2 AF 21 30 00 02 3B E8 03 7C 70 8B 62 8C 4B 00 40 14 00 00 00 00 F0 FF BD 27 10 00 A2 27 A4 00 C2 AF 21 20 80 02 21 28 60 02 21 38 40 02 10 00 02 24 E0 FF BD 27 10 00 A2 AF CE 10 02 24 0C 00 00 00 20 00 BD 27 5A 00 E0 10 21 88 40 00 ?? ?? 82 8F 3B E8 03 7C 21 20 60 00 21 20 44 00 21 18 20 02 00 00 91 AC 59 00 04 24 54 00 64 14 FF FF 11 24 64 00 00 12 00 00 00 00 00 00 03 8E 6D 00 60 04 9A 3B 05 3C 04 00 04 8E 00 CA A5 34 2B 28 85 00 68 00 A0 10 00 00 00 00 20 00 02 3C 9C C4 42 34 2A 28 62 00 14 00 A0 10 FF FF 10 24 FF FF 42 24 58 00 62 10 90 26 02 3C 0F 00 02 3C 3F 42 42 24 21 20 82 00 1B 43 02 3C 83 DE 42 34 18 00 82 00 80 28 03 00 C0 81 03 00 23 80 05 02 21 80 03 02 C3 27 04 00 C0 80 10 00 10 10 00 00 83 14 02 00 23 20 44 00 21 80 04 02 3D 00 40 12 21 20 80 02 03 00 04 24 21 28 40 02 ?? ?? ?? 0? 18 00 C6 27 21 20 80 02 21 28 60 02 ?? ?? ?? 0? 21 30 00 02 03 00 04 24 18 00 C5 27 21 30 00 00 ?? ?? ?? 0? 21 88 40 00 ?? ?? ?? 0? 21 E8 C0 03 ?? ?? ?? 0? A8 00 C6 AF F0 FF BD 27 10 00 A3 27 21 F8 40 00 10 00 DC 8F A0 00 C3 AF 21 20 80 02 21 28 60 02 A8 00 C6 8F 21 38 40 02 10 00 02 24 E0 FF BD 27 10 00 A2 AF CE 10 02 24 0C 00 00 00 20 00 BD 27 07 00 E0 10 21 88 40 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 51 AC FF FF 11 24 21 20 E0 03 ?? ?? ?? 0? 00 00 00 00 10 00 DC 8F FF FF 02 24 25 00 22 12 ?? ?? 82 8F 21 E8 C0 03 CC 00 BF 8F 21 10 20 02 C8 00 BE 8F C4 00 B4 8F C0 00 B3 8F BC 00 B2 8F B8 00 B1 8F B4 00 B0 8F 08 00 E0 03 D0 00 BD 27 ?? ?? ?? 0? 21 30 00 00 21 28 60 02 ?? ?? ?? 0? 21 30 00 02 ?? ?? ?? 0? 21 88 40 00 BE FF 40 16 FF FF 10 24 ?? ?? ?? 0? 21 20 80 02 C1 6F 42 24 2A 10 82 00 A7 FF 40 14 0F 00 02 3C B6 FF 40 16 21 20 80 02 ?? ?? ?? 0? 21 28 60 02 3B E8 03 7C 21 10 43 00 16 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 11 24 3B E8 03 7C 21 20 43 00 ?? ?? ?? 0? 00 00 83 8C }
	condition:
		$1
}

rule file_249_0_0 {
	meta:
		name = "__atomic_readv_replacement"
		size = 532
		refs = "0004 __gnu_local_gp 00c8 __read 0110 memcpy 0128 free 0170 __libc_errno 01cc __libc_alloca_cutoff 01dc malloc 0200 _Unwind_Resume"
	strings:
		$1 = { B8 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 40 00 BE AF 21 F0 A0 03 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF 44 00 BF AF 3C 00 B7 AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 20 00 B0 AF 10 00 DC AF 21 88 C0 00 21 98 80 00 5F 00 C0 18 21 90 A0 00 04 00 A2 8C 00 80 03 3C 2B 18 43 00 43 00 60 10 FF 7F 04 3C 21 38 A0 00 21 18 00 00 21 80 00 00 ?? ?? ?? 0? FF FF 84 34 08 00 E7 24 04 00 E2 8C 23 40 90 00 2B 40 02 01 38 00 00 15 00 00 00 00 01 00 63 24 F8 FF 71 14 21 80 02 02 01 80 02 34 2B 10 02 02 4A 00 40 10 00 00 00 00 0E 00 02 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 10 00 B4 27 21 A8 00 00 21 20 60 02 21 28 80 02 ?? ?? ?? 0? 21 30 00 02 3A 00 40 04 21 B0 40 00 11 00 20 1A 21 80 40 00 ?? ?? ?? 0? 21 B8 00 00 0D 00 F1 12 08 00 52 26 04 00 42 8E 00 00 44 8E 21 28 80 02 2B 98 02 02 0B 10 13 02 21 98 40 00 21 30 40 00 23 80 02 02 ?? ?? ?? 0? 21 A0 93 02 F3 FF 00 16 01 00 F7 26 21 10 C0 02 21 20 A0 02 ?? ?? ?? 0? 18 00 C2 AF 21 E8 C0 03 44 00 BF 8F 18 00 C2 8F 3C 00 B7 8F 40 00 BE 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC 21 E8 C0 03 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F FF FF 02 24 08 00 E0 03 48 00 BD 27 21 A8 00 00 ?? ?? ?? 0? FF FF 02 24 ?? ?? ?? 0? 21 80 00 00 ?? ?? ?? 0? 21 20 00 02 B5 FF 40 14 0E 00 02 26 ?? ?? ?? 0? 21 20 00 02 F4 FF 40 10 21 A0 40 00 ?? ?? ?? 0? 21 A8 40 00 21 80 80 00 ?? ?? ?? 0? 21 20 A0 02 ?? ?? ?? 0? 21 20 00 02 21 A8 00 00 ?? ?? ?? 0? 21 80 80 00 }
	condition:
		$1
}

rule file_249_1_0 {
	meta:
		name = "__libc_readv"
		size = 292
		refs = "0000 __gnu_local_gp 0054 __libc_errno 0098 __libc_enable_asynccancel 00e0 __libc_disable_asynccancel"
	strings:
		$1 = { ?? ?? 1C 3C D0 FF BD 27 ?? ?? 9C 27 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 2C 00 BF AF 10 00 BC AF 21 90 80 00 21 88 A0 00 21 80 C0 00 3B E8 03 7C 70 8B 62 8C 18 00 40 14 00 00 00 00 31 10 02 24 0C 00 00 00 2A 00 E0 10 21 28 40 00 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC FF FF 02 24 16 00 03 24 23 00 A3 14 2C 00 BF 8F 09 00 03 2A 20 00 60 14 21 20 40 02 21 28 20 02 28 00 B2 8F 24 00 B1 8F 21 30 00 02 20 00 B0 8F ?? ?? ?? 0? 30 00 BD 27 ?? ?? ?? 0? 00 00 00 00 21 F8 40 00 10 00 BC 8F 21 20 40 02 21 28 20 02 21 30 00 02 31 10 02 24 0C 00 00 00 08 00 E0 10 21 20 E0 03 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC FF FF 02 24 21 20 E0 03 ?? ?? ?? 0? 18 00 A2 AF 10 00 BC 8F 18 00 A2 8F 06 00 40 04 2C 00 BF 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 ?? ?? ?? 0? 00 00 85 8C }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "__umask"
		size = 16
	strings:
		$1 = { DC 0F 02 24 0C 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_251_0_0 {
	meta:
		name = "__seed48_r"
		size = 108
	strings:
		$1 = { 03 00 A2 88 21 18 A0 00 06 00 A5 24 00 00 62 98 09 00 62 A8 00 00 A2 B8 04 00 66 90 21 10 00 00 04 00 A6 A0 05 00 66 90 05 00 A6 A0 04 00 85 94 04 00 65 A4 02 00 85 94 02 00 65 A4 00 00 86 94 EC DE 04 3C 6D E6 84 34 10 00 64 AC 0B 00 04 24 05 00 05 24 0C 00 64 A4 01 00 04 24 14 00 65 AC 00 00 66 A4 08 00 E0 03 0E 00 64 A4 }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "sethostname"
		size = 28
	strings:
		$1 = { EA 0F 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "iruserfopen"
		size = 476
		refs = "0020 __lxstat64 003c _libc_intl_domainname 0040 $LC1 0050 __dcgettext 0060 __rcmd_errstr 006c _IO_new_fclose 0090 $LC0 00f0 _IO_new_fopen 00e8 $LC2 0100 fileno 0110 __fxstat64 0130 $LC5 0168 $LC7 0184 $LC6 01a4 $LC3 01c0 $LC4"
	strings:
		$1 = { 38 FF BD 27 BC 00 B0 AF 21 80 80 00 C0 00 B1 AF 03 00 04 24 21 88 A0 00 18 00 A6 27 C4 00 BF AF ?? ?? ?? 0? 21 28 00 02 18 00 40 14 30 00 A3 8F 00 80 02 34 00 F0 63 30 2B 00 62 10 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 05 00 06 24 ?? ?? ?? 0? 21 80 00 00 14 00 40 10 00 00 00 00 ?? ?? 03 3C 1A 00 00 12 ?? ?? 62 AC ?? ?? ?? 0? 21 20 00 02 C4 00 BF 8F C0 00 B1 8F BC 00 B0 8F 21 10 00 00 08 00 E0 03 C8 00 BD 27 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 EE FF 40 14 21 80 00 00 00 00 03 8E C4 00 BF 8F 21 10 00 02 00 80 63 34 00 00 03 AE C0 00 B1 8F BC 00 B0 8F 08 00 E0 03 C8 00 BD 27 C4 00 BF 8F C0 00 B1 8F BC 00 B0 8F 21 10 00 00 08 00 E0 03 C8 00 BD 27 ?? ?? 05 3C 21 20 00 02 ?? ?? ?? 0? ?? ?? A5 24 29 00 40 10 21 80 40 00 ?? ?? ?? 0? 21 20 40 00 21 28 40 00 03 00 04 24 ?? ?? ?? 0? 18 00 A6 27 29 00 40 04 ?? ?? 04 3C 38 00 A2 8F 09 00 40 10 00 00 00 00 07 00 51 10 ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? ?? 0? 00 00 00 00 30 00 A2 8F 12 00 42 30 0B 00 40 14 ?? ?? 04 3C 34 00 A2 8F 02 00 42 2C D1 FF 40 14 ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_253_1_0 {
	meta:
		name = "__validuser2_sa"
		size = 1224
		refs = "0000 __gnu_local_gp 0008 __libc_tsd_CTYPE_B 000c __libc_tsd_CTYPE_TOLOWER 0080 __getline 0154 $LC8 0160 strncmp 016c $LC9 0210 free 024c strcmp 0300 getnameinfo 0350 getaddrinfo 0398 memcmp 03ac freeaddrinfo 0414 innetgr"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 ?? ?? 82 8F ?? ?? 89 8F 40 FF BD 27 3B E8 03 7C B8 00 BE AF B4 00 B7 AF A8 00 B4 AF A4 00 B3 AF 9C 00 B1 AF BC 00 BF AF B0 00 B6 AF AC 00 B5 AF A0 00 B2 AF 98 00 B0 AF 20 00 BC AF 88 00 A2 AF 21 A0 60 00 21 88 80 00 21 98 A0 00 C8 00 A6 AF CC 00 A7 AF 80 00 A0 AF 7C 00 A0 AF 21 B8 23 01 21 F0 43 00 88 00 A3 8F 23 00 12 24 21 80 74 00 80 00 A4 27 7C 00 A5 27 ?? ?? ?? 0? 21 30 20 02 77 00 40 18 80 00 A3 8F 7C 00 A2 8F 21 10 62 00 FF FF 40 A0 80 00 B6 8F 00 00 C4 82 F4 FF 80 10 40 10 04 00 00 00 06 8E 21 10 C2 00 00 00 47 94 00 20 E7 30 FF FF E7 30 0C 00 E0 10 21 18 80 00 21 10 C0 02 01 00 42 24 00 00 43 80 40 28 03 00 E7 FF 60 10 21 28 C5 00 00 00 A5 94 00 20 A5 30 F9 FF A0 14 01 00 42 24 FF FF 42 24 E0 FF 72 10 00 00 00 00 09 00 E0 10 00 00 00 00 ?? ?? ?? 0? 20 00 02 24 00 00 C3 8F 21 10 62 00 00 00 42 94 00 20 42 30 54 00 40 14 00 00 00 00 00 00 E2 8E 80 20 04 00 01 00 D6 26 21 20 44 00 00 00 82 8C 00 00 C4 82 FF FF C2 A2 F2 FF 80 14 40 10 04 00 21 10 C0 02 00 00 40 A0 80 00 B0 8F ?? ?? 03 3C ?? ?? 64 24 02 00 06 24 ?? ?? ?? 0? 21 28 00 02 A7 00 40 10 ?? ?? 02 3C ?? ?? 44 24 21 28 00 02 ?? ?? ?? 0? 02 00 06 24 AC 00 40 10 2D 00 03 24 00 00 02 92 A5 00 43 10 2B 00 03 24 52 00 43 14 01 00 03 24 01 00 02 92 4F 00 40 14 00 00 00 00 00 00 C2 82 CC 00 A3 8F ?? ?? 04 3C ?? ?? 84 24 0A B0 62 00 02 00 06 24 ?? ?? ?? 0? 21 28 C0 02 A3 00 40 10 ?? ?? 02 3C ?? ?? 44 24 21 28 C0 02 ?? ?? ?? 0? 02 00 06 24 A6 00 40 10 2D 00 03 24 00 00 C2 92 AD 00 43 10 2B 00 03 24 15 00 43 14 D0 00 A4 8F 01 00 C2 92 12 00 40 14 00 00 00 00 21 10 00 00 80 00 A4 8F ?? ?? ?? 0? 94 00 A2 AF BC 00 BF 8F 94 00 A2 8F B8 00 BE 8F B4 00 B7 8F B0 00 B6 8F AC 00 B5 8F A8 00 B4 8F A4 00 B3 8F A0 00 B2 8F 9C 00 B1 8F 98 00 B0 8F 08 00 E0 03 C0 00 BD 27 ?? ?? ?? 0? 21 28 C0 02 01 00 42 2C EB FF 40 1C 00 00 00 00 83 FF 40 10 88 00 A3 8F ?? ?? ?? 0? FF FF 02 24 20 00 02 24 60 00 82 14 09 00 02 24 01 00 C3 82 01 00 C2 26 14 00 60 10 00 00 C0 A2 00 00 C4 8F 40 18 03 00 21 18 83 00 00 00 63 94 00 20 63 30 09 00 60 14 01 00 42 24 FF FF 42 24 ?? ?? ?? 0? 21 B0 40 00 00 00 A3 94 00 20 63 30 47 00 60 10 21 B0 40 00 01 00 42 24 00 00 43 80 40 28 03 00 F8 FF 60 14 21 28 85 00 ?? ?? ?? 0? 21 B0 40 00 90 00 A3 AF C8 00 A5 8F 01 00 02 24 10 00 A0 AF 14 00 A0 AF 18 00 A2 AF 21 20 60 02 28 00 A6 27 ?? ?? ?? 0? 2E 00 07 24 05 00 40 14 28 00 A4 27 ?? ?? ?? 0? 21 28 00 02 4D 00 40 10 00 00 00 00 00 00 62 96 21 20 00 02 21 28 00 00 58 00 A6 27 78 00 A7 27 58 00 A0 AF 60 00 A0 AF 64 00 A0 AF 68 00 A0 AF 6C 00 A0 AF 70 00 A0 AF 74 00 A0 AF ?? ?? ?? 0? 5C 00 A2 AF 44 FF 40 14 21 90 40 00 78 00 A3 8F 11 00 60 10 8C 00 A3 AF 00 00 75 96 ?? ?? ?? 0? 21 80 60 00 1C 00 10 8E 0B 00 00 12 00 00 00 00 04 00 04 8E FB FF 95 14 00 00 00 00 14 00 04 8E 10 00 06 8E ?? ?? ?? 0? 21 28 60 02 F5 FF 40 14 00 00 00 00 90 00 B2 8F ?? ?? ?? 0? 8C 00 A4 8F 95 FF 40 06 FF FF 02 24 2C FF 40 12 88 00 A3 8F ?? ?? ?? 0? 00 00 C2 82 00 00 A3 94 00 20 63 30 5D FF 60 14 00 00 00 00 01 00 42 24 00 00 43 80 40 28 03 00 F8 FF 60 14 21 28 85 00 ?? ?? ?? 0? 00 00 40 A0 A0 FF 82 10 21 10 C0 02 ?? ?? ?? 0? 00 00 40 A0 D4 00 A5 8F 02 00 04 26 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 ?? ?? ?? 0? 21 90 40 00 FF FF 03 24 01 00 10 26 ?? ?? ?? 0? 90 00 A3 AF D4 00 A5 8F 02 00 04 26 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 ?? ?? ?? 0? 23 90 02 00 ?? ?? ?? 0? 90 00 B2 8F D0 00 A6 8F 02 00 C4 26 21 28 00 00 ?? ?? ?? 0? 21 38 00 00 7C FF 40 18 00 00 00 00 ?? ?? ?? 0? 21 10 00 00 D0 00 A6 8F 02 00 C4 26 21 28 00 00 ?? ?? ?? 0? 21 38 00 00 23 10 02 00 72 FF 40 18 00 00 00 00 ?? ?? ?? 0? 21 10 00 00 D0 00 A5 8F ?? ?? ?? 0? 01 00 C4 26 01 00 42 2C 23 10 02 00 ED FE 40 10 88 00 A3 8F ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_253_2_0 {
	meta:
		name = "ruserok2_sa"
		size = 544
		refs = "0048 __check_rhosts_file 005c __sysconf 0088 __getpwnam_r 00a8 strlen 00cc mempcpy 00d4 $LC11 00fc __geteuid 010c seteuid 0150 _IO_new_fclose 0198 $LC10"
	strings:
		$1 = { 98 FF BD 27 60 00 BE AF 21 F0 A0 03 58 00 B5 AF 54 00 B4 AF 50 00 B3 AF 48 00 B1 AF 44 00 B0 AF 64 00 BF AF 5C 00 B6 AF 4C 00 B2 AF 21 80 C0 00 21 A8 80 00 21 A0 A0 00 21 98 E0 00 56 00 C0 10 78 00 D1 8F FF FF 12 24 ?? ?? 02 3C ?? ?? 42 8C 25 80 02 02 70 00 00 12 00 00 00 00 ?? ?? ?? 0? 46 00 04 24 0E 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 3C 00 C3 27 10 00 A3 AF 21 20 20 02 20 00 C5 27 18 00 A6 27 ?? ?? ?? 0? 21 38 40 00 34 00 40 14 FF FF 03 24 3C 00 C2 8F 31 00 40 10 00 00 00 00 14 00 56 8C ?? ?? ?? 0? 21 20 C0 02 17 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 B0 27 21 30 40 00 21 28 C0 02 ?? ?? ?? 0? 21 20 00 02 ?? ?? 05 3C ?? ?? A4 8C ?? ?? A5 24 21 18 40 00 04 00 A2 8C 03 00 64 A8 08 00 A5 90 00 00 64 B8 07 00 62 A8 04 00 62 B8 ?? ?? ?? 0? 08 00 65 A0 21 B0 40 00 3C 00 C2 8F ?? ?? ?? 0? 08 00 44 8C 3C 00 C2 8F 21 20 00 02 ?? ?? ?? 0? 08 00 45 8C 0C 00 40 10 21 80 40 00 21 20 40 00 7C 00 C2 8F 21 28 A0 02 21 30 80 02 21 38 20 02 10 00 B3 AF ?? ?? ?? 0? 14 00 A2 AF 21 20 00 02 ?? ?? ?? 0? 21 90 40 00 ?? ?? ?? 0? 21 20 C0 02 21 18 40 02 21 E8 C0 03 64 00 DF 8F 60 00 BE 8F 5C 00 B6 8F 58 00 B5 8F 54 00 B4 8F 50 00 B3 8F 4C 00 B2 8F 48 00 B1 8F 44 00 B0 8F 21 10 60 00 08 00 E0 03 68 00 BD 27 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 21 28 00 00 A6 FF 40 10 21 B0 40 00 21 20 40 00 7C 00 C2 8F 21 28 A0 02 21 30 80 02 21 38 20 02 10 00 B3 AF ?? ?? ?? 0? 14 00 A2 AF 21 90 40 00 ?? ?? ?? 0? 21 20 C0 02 9A FF 40 16 21 18 00 00 21 E8 C0 03 64 00 BF 8F 60 00 BE 8F 5C 00 B6 8F 58 00 B5 8F 54 00 B4 8F 50 00 B3 8F 4C 00 B2 8F 48 00 B1 8F 44 00 B0 8F 21 10 60 00 08 00 E0 03 68 00 BD 27 ?? ?? ?? 0? FF FF 03 24 }
	condition:
		$1
}

rule file_253_3_0 {
	meta:
		name = "rresvport_af"
		size = 524
		refs = "0004 __gnu_local_gp 0054 __socket 006c memset 0094 __libc_errno 00ec __bind 018c __close"
	strings:
		$1 = { 48 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 A8 00 B4 AF 02 00 02 24 FF FF B4 30 98 00 B0 AF B4 00 BF AF B0 00 B6 AF AC 00 B5 AF A4 00 B3 AF A0 00 B2 AF 9C 00 B1 AF 10 00 BC AF 4C 00 82 12 21 80 80 00 0A 00 02 24 38 00 82 16 1C 00 13 24 21 20 80 02 02 00 05 24 ?? ?? ?? 0? 21 30 00 00 69 00 40 04 21 90 40 00 18 00 A4 27 21 28 00 00 ?? ?? ?? 0? 80 00 06 24 00 00 11 8E 10 00 BC 8F 00 02 22 2A 3C 00 40 10 18 00 B4 A7 00 02 02 24 00 00 02 AE 00 02 11 24 ?? ?? 95 8F 3B E8 03 7C 21 B0 60 00 21 B0 B6 02 21 18 20 02 ?? ?? ?? 0? 7D 00 14 24 00 00 C2 8E 35 00 54 14 00 00 00 00 00 00 05 8E FF FF A2 24 00 02 A5 38 0B 18 45 00 3C 00 23 12 00 00 03 AE 00 3A 62 7C 00 1A 03 00 25 18 43 00 21 20 40 02 18 00 A5 27 21 30 60 02 ?? ?? ?? 0? 1A 00 A3 A7 EE FF 40 04 FF 03 03 24 B4 00 BF 8F 21 10 40 02 B0 00 B6 8F AC 00 B5 8F A8 00 B4 8F A4 00 B3 8F A0 00 B2 8F 9C 00 B1 8F 98 00 B0 8F 08 00 E0 03 B8 00 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 7C 00 03 24 00 00 43 AC FF FF 02 24 B4 00 BF 8F B0 00 B6 8F AC 00 B5 8F A8 00 B4 8F A4 00 B3 8F A0 00 B2 8F 9C 00 B1 8F 98 00 B0 8F 08 00 E0 03 B8 00 BD 27 ?? ?? ?? 0? 10 00 13 24 00 04 22 2A C6 FF 40 14 FF 03 02 24 00 00 02 AE ?? ?? ?? 0? FF 03 11 24 ?? ?? ?? 0? 21 20 40 02 B4 00 BF 8F B0 00 B6 8F AC 00 B5 8F A8 00 B4 8F A4 00 B3 8F A0 00 B2 8F 9C 00 B1 8F 98 00 B0 8F FF FF 02 24 08 00 E0 03 B8 00 BD 27 ?? ?? ?? 0? 21 20 40 02 B4 00 BF 8F 3B E8 03 7C 21 10 A3 02 0B 00 03 24 00 00 43 AC B0 00 B6 8F AC 00 B5 8F A8 00 B4 8F A4 00 B3 8F A0 00 B2 8F 9C 00 B1 8F 98 00 B0 8F FF FF 02 24 08 00 E0 03 B8 00 BD 27 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_253_4_0 {
	meta:
		name = "rcmd_af"
		size = 2476
		refs = "000c __gnu_local_gp 0060 __getpid 0070 $LC12 00ac __snprintf 00c4 getaddrinfo 00f0 free 00fc __strdup 011c __libc_errno 0128 __sigblock 0154 _libc_intl_domainname 013c $LC19 0164 rresvport_af 0180 __fcntl 0190 __connect 01a0 __close 01ec getnameinfo 0200 __dcgettext 0210 __asprintf 0228 __fxprintf 021c $LC16 023c perror 015c $LC20 02e0 $LC18 02f0 __sigsetmask 02f8 freeaddrinfo 0348 $LC13 03b0 __sleep 03ec __strerror_r 03f4 $LC21 041c gai_strerror 0424 $LC14 04a0 __listen 04c4 strlen 04d4 __write 0514 __poll 0554 accept 061c __writev 0658 __read 06d4 $LC29 0748 $LC17 047c $LC22 07bc $LC23 0910 $LC24 08a0 $LC27 08d4 $LC25 0914 $LC26 0930 $LC15 0974 $LC28"
	strings:
		$1 = { 48 FE BD 27 90 01 B0 AF D0 01 B0 97 ?? ?? 1C 3C ?? ?? 9C 27 0A 00 02 24 94 01 B1 AF B4 01 BF AF B0 01 BE AF AC 01 B7 AF A8 01 B6 AF A4 01 B5 AF A0 01 B4 AF 9C 01 B3 AF 98 01 B2 AF 20 00 BC AF B8 01 A4 AF C0 01 A6 AF C4 01 A7 AF 04 00 02 12 FF FF B1 30 FD FF 02 32 C7 01 40 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 02 3A 11 00 00 8A 11 00 ?? ?? 08 3C 25 38 F1 00 02 00 03 24 ?? ?? 06 25 68 01 A4 27 08 00 05 24 FF FF E7 30 20 01 A3 AF 28 01 A3 AF 21 A0 40 00 2C 01 A0 AF 30 01 A0 AF 34 01 A0 AF 38 01 A0 AF 3C 01 A0 AF ?? ?? ?? 0? 24 01 B0 AF B8 01 A8 8F 68 01 A5 27 20 01 A6 27 00 00 04 8D ?? ?? ?? 0? 7C 01 A7 27 99 00 40 14 20 00 BC 8F 7C 01 B0 8F 01 00 02 24 5C 01 A2 A7 18 00 03 8E 76 01 60 10 64 01 A2 A7 ?? ?? 10 3C ?? ?? ?? 0? ?? ?? 04 8E 7C 01 A2 8F ?? ?? ?? 0? 18 00 44 8C ?? ?? 02 AE 08 02 40 10 20 00 BC 8F B8 01 A8 8F 7C 01 B0 8F 00 00 02 AD ?? ?? 88 8F 10 00 04 3C ?? ?? 15 3C ?? ?? ?? 0? 84 01 A8 AF 84 01 A8 8F 3B E8 03 7C 88 01 A2 AF ?? ?? 17 3C FF 03 02 24 78 01 A2 AF 80 01 A0 AF 01 00 16 24 21 98 03 01 ?? ?? B5 26 ?? ?? F7 26 ?? ?? 1E 3C 04 00 05 96 ?? ?? ?? 0? 78 01 A4 27 21 88 40 00 54 00 40 04 20 00 BC 8F 21 20 40 00 18 00 05 24 ?? ?? ?? 0? 21 30 80 02 14 00 05 8E 10 00 06 8E ?? ?? ?? 0? 21 20 20 02 B4 00 41 04 78 01 A2 8F ?? ?? ?? 0? 21 20 20 02 00 00 71 8E 7D 00 02 24 76 00 22 12 92 00 02 24 E6 01 22 12 01 00 03 24 1C 00 02 8E 75 00 40 10 80 01 A3 8F 28 00 A0 AF 14 00 04 8E 10 00 05 8E 01 00 02 24 2E 00 07 24 F0 00 A6 27 10 00 A0 AF 14 00 A0 AF ?? ?? ?? 0? 18 00 A2 AF 21 20 A0 02 21 28 E0 02 05 00 06 24 ?? ?? ?? 0? 28 00 B2 27 21 28 40 00 21 20 40 02 ?? ?? ?? 0? F0 00 A6 27 07 00 40 04 ?? ?? 05 3C 28 00 A6 8F 21 20 00 00 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? 28 00 A4 8F 21 20 00 00 ?? ?? ?? 0? 00 00 71 AE 1C 00 10 8E 01 00 02 24 2E 00 07 24 14 00 04 8E 10 00 05 8E F0 00 A6 27 10 00 A0 AF 14 00 A0 AF ?? ?? ?? 0? 18 00 A2 AF 21 20 A0 02 ?? ?? C5 27 ?? ?? ?? 0? 05 00 06 24 21 28 40 00 21 20 40 02 ?? ?? ?? 0? F0 00 A6 27 B4 FF 40 04 28 00 A6 8F ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? 21 20 00 00 ?? ?? ?? 0? 28 00 A4 8F 04 00 05 96 ?? ?? ?? 0? 78 01 A4 27 21 88 40 00 AE FF 41 04 20 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 43 8C 0B 00 02 24 19 01 62 10 ?? ?? 05 3C 21 20 00 00 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? 88 01 A4 8F ?? ?? ?? 0? 7C 01 A4 8F FF FF 02 24 B4 01 BF 8F B0 01 BE 8F AC 01 B7 8F A8 01 B6 8F A4 01 B5 8F A0 01 B4 8F 9C 01 B3 8F 98 01 B2 8F 94 01 B1 8F 90 01 B0 8F 08 00 E0 03 B8 01 BD 27 FE FF 03 24 38 00 43 14 B8 01 A8 8F 00 00 06 8D 35 00 C0 10 ?? ?? 05 3C 21 20 00 00 ?? ?? ?? 0? ?? ?? A5 24 FF FF 02 24 B4 01 BF 8F B0 01 BE 8F AC 01 B7 8F A8 01 B6 8F A4 01 B5 8F A0 01 B4 8F 9C 01 B3 8F 98 01 B2 8F 94 01 B1 8F 90 01 B0 8F 08 00 E0 03 B8 01 BD 27 78 01 A2 8F FF FF 42 24 ?? ?? ?? 0? 78 01 A2 AF 0A 00 60 10 00 00 00 00 11 00 C2 2A 07 00 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 C0 02 40 B0 16 00 7C 01 B0 8F ?? ?? ?? 0? 80 01 A0 AF ?? ?? ?? 0? 7C 01 A4 8F 84 01 A8 8F 3B E8 03 7C 28 00 A5 27 21 10 03 01 B8 01 A8 8F 00 00 44 8C C8 00 06 24 ?? ?? ?? 0? 00 00 10 8D ?? ?? 05 3C 21 20 00 00 ?? ?? A5 24 21 30 00 02 ?? ?? ?? 0? 21 38 40 00 ?? ?? ?? 0? 88 01 A4 8F ?? ?? ?? 0? FF FF 02 24 ?? ?? ?? 0? 21 20 40 00 ?? ?? 05 3C 21 20 00 00 ?? ?? A5 24 ?? ?? ?? 0? 21 30 40 00 B4 01 BF 8F B0 01 BE 8F AC 01 B7 8F A8 01 B6 8F A4 01 B5 8F A0 01 B4 8F 9C 01 B3 8F 98 01 B2 8F 94 01 B1 8F 90 01 B0 8F FF FF 02 24 08 00 E0 03 B8 01 BD 27 FF FF 42 24 78 01 A2 AF CC 01 A2 8F C7 00 40 10 ?? ?? 05 3C 04 00 05 96 ?? ?? ?? 0? 78 01 A4 27 10 00 03 8E 21 98 40 00 A3 00 40 04 74 01 A3 AF 21 20 40 00 ?? ?? ?? 0? 01 00 05 24 78 01 A7 8F ?? ?? 03 3C 40 01 B0 27 ?? ?? 66 24 08 00 05 24 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 20 00 02 01 00 46 24 21 20 20 02 ?? ?? ?? 0? 21 28 00 02 21 20 00 02 ?? ?? ?? 0? 21 90 40 00 01 00 42 24 B2 00 42 16 20 00 BC 8F ?? ?? 94 8F 3B E8 03 7C 58 01 A4 27 21 A8 83 02 02 00 05 24 FF FF 06 24 00 00 A0 AE 58 01 B1 AF ?? ?? ?? 0? 60 01 B3 AF CC 00 40 18 66 01 A2 97 28 00 B2 27 01 00 42 30 C8 00 40 10 74 01 B6 27 FF FF 14 24 ?? ?? ?? 0? 04 00 1E 24 00 00 A2 8E 08 00 5E 14 28 00 A2 97 21 20 60 02 21 28 40 02 ?? ?? ?? 0? 21 30 C0 02 F8 FF 54 10 21 B8 40 00 28 00 A2 97 02 00 03 24 03 00 43 10 0A 00 03 24 06 00 43 14 21 90 00 00 2A 00 A2 97 00 3A 52 7C 00 12 02 00 25 90 42 02 FF FF 52 32 ?? ?? ?? 0? 21 20 60 02 DE 00 E0 06 CC 01 A8 8F 00 FE 42 26 00 02 42 2C BC 00 40 10 00 00 17 AD C0 01 A4 8F FF FF 12 24 04 00 13 24 ?? ?? ?? 0? 40 01 A4 AF C4 01 A4 8F 01 00 42 24 44 01 A2 AF ?? ?? ?? 0? 48 01 A4 AF C8 01 A4 8F 01 00 42 24 4C 01 A2 AF ?? ?? ?? 0? 50 01 A4 AF 20 00 BC 8F 01 00 42 24 3B E8 03 7C ?? ?? 94 8F 54 01 A2 AF ?? ?? ?? 0? 21 A0 83 02 00 00 82 8E 07 00 53 14 00 00 00 00 21 20 20 02 21 28 00 02 ?? ?? ?? 0? 03 00 06 24 F8 FF 52 10 20 00 BC 8F ?? ?? 93 8F 3B E8 03 7C FF FF 10 24 21 98 63 02 ?? ?? ?? 0? 04 00 12 24 00 00 62 8E 20 00 52 14 00 00 00 00 21 20 20 02 21 28 C0 02 ?? ?? ?? 0? 01 00 06 24 F8 FF 50 10 01 00 03 24 BF 00 43 14 00 00 00 00 74 01 A2 83 6B 00 40 14 0A 00 10 24 ?? ?? ?? 0? 88 01 A4 8F ?? ?? ?? 0? 7C 01 A4 8F B4 01 BF 8F 21 10 20 02 B0 01 BE 8F AC 01 B7 8F A8 01 B6 8F A4 01 B5 8F A0 01 B4 8F 9C 01 B3 8F 98 01 B2 8F 94 01 B1 8F 90 01 B0 8F 08 00 E0 03 B8 01 BD 27 B8 01 A8 8F ?? ?? ?? 0? 00 00 00 AD 70 01 A0 AF B8 01 A8 8F ?? ?? 05 3C 70 01 A4 27 00 00 06 8D ?? ?? ?? 0? ?? ?? A5 24 09 00 40 04 78 01 A2 8F 70 01 A6 8F ?? ?? 05 3C 21 20 00 00 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? 70 01 A4 8F 78 01 A2 8F 04 00 40 10 00 00 00 00 CC 01 A2 8F ?? ?? ?? 0? 00 00 44 8C ?? ?? ?? 0? 21 20 20 02 ?? ?? ?? 0? 88 01 A4 8F ?? ?? ?? 0? 7C 01 A4 8F ?? ?? ?? 0? FF FF 02 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? 05 3C 21 20 00 00 ?? ?? A5 24 ?? ?? ?? 0? 21 30 40 00 ?? ?? ?? 0? 00 00 00 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 7C 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 21 20 20 02 ?? ?? A5 24 ?? ?? ?? 0? 01 00 06 24 40 01 B0 27 78 01 A0 AF ?? ?? ?? 0? 74 01 B6 27 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 05 00 06 24 ?? ?? ?? 0? 28 00 A0 AF 21 28 40 00 ?? ?? ?? 0? 28 00 A4 27 07 00 40 04 28 00 A6 8F ?? ?? 05 3C 21 20 00 00 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? 28 00 A4 8F ?? ?? ?? 0? 21 20 60 02 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 74 01 A2 83 BC FF 50 10 78 01 A2 8F 21 20 20 02 21 28 C0 02 ?? ?? ?? 0? 01 00 06 24 01 00 03 24 02 00 04 24 21 28 C0 02 F3 FF 43 10 01 00 06 24 ?? ?? ?? 0? 78 01 A2 8F 3B E8 03 7C 21 A0 83 02 00 00 82 8E 28 00 A0 AF 1C 00 40 14 ?? ?? 10 3C 28 00 B2 27 ?? ?? 05 3C ?? ?? 04 26 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 21 28 40 00 ?? ?? ?? 0? 21 20 40 02 D6 FF 41 04 28 00 A6 8F ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 05 00 06 24 ?? ?? ?? 0? 70 01 A0 AF 21 28 40 00 ?? ?? ?? 0? 70 01 A4 27 8B FF 41 04 70 01 A6 8F ?? ?? ?? 0? 78 01 A2 8F ?? ?? 05 3C ?? ?? 04 26 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 28 00 B2 27 21 20 40 02 ?? ?? ?? 0? 21 28 40 00 BB FF 41 04 28 00 A6 8F 00 00 82 8E BE FF 40 14 00 00 00 00 ?? ?? ?? 0? ?? ?? 05 3C ?? ?? 05 3C 21 20 00 00 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? 78 01 A0 AF ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? 05 3C 21 20 00 00 ?? ?? ?? 0? ?? ?? A5 24 1C 00 02 8E 1C FE 40 14 80 01 A3 AF ?? ?? ?? 0? 11 00 C2 2A 59 FF 40 14 70 01 A0 AF ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 B8 01 A8 8F 70 01 A4 27 21 28 40 00 ?? ?? ?? 0? 00 00 06 8D 55 FF 41 04 70 01 A6 8F ?? ?? ?? 0? 78 01 A2 8F }
	condition:
		$1
}

rule file_253_5_0 {
	meta:
		name = "rcmd"
		size = 52
		refs = "0020 rcmd_af"
	strings:
		$1 = { D0 FF BD 27 40 00 A2 8F FF FF A5 30 2C 00 BF AF 10 00 A2 AF 44 00 A2 8F 14 00 A2 AF 02 00 02 24 ?? ?? ?? 0? 18 00 A2 AF 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_253_7_0 {
	meta:
		name = "ruserok_af"
		size = 232
		refs = "0058 getaddrinfo 00ac freeaddrinfo"
	strings:
		$1 = { A0 FF BD 27 70 00 A2 97 58 00 B4 AF 54 00 B3 AF 50 00 B2 AF 21 98 C0 00 21 90 A0 00 21 A0 E0 00 21 28 00 00 20 00 A6 27 40 00 A7 27 4C 00 B1 AF 5C 00 BF AF 48 00 B0 AF 21 88 80 00 20 00 A0 AF 28 00 A0 AF 2C 00 A0 AF 30 00 A0 AF 34 00 A0 AF 38 00 A0 AF 3C 00 A0 AF ?? ?? ?? 0? 24 00 A2 AF 1F 00 40 14 40 00 B0 8F 06 00 00 16 21 20 00 00 ?? ?? ?? 0? FF FF 10 24 1C 00 10 8E 16 00 00 12 00 00 00 00 14 00 04 8E 10 00 05 8E 21 30 40 02 10 00 B4 AF 14 00 B1 AF ?? ?? ?? 0? 21 38 60 02 F5 FF 40 14 40 00 A4 8F 21 80 00 00 ?? ?? ?? 0? 00 00 00 00 21 10 00 02 5C 00 BF 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 08 00 E0 03 60 00 BD 27 ?? ?? ?? 0? FF FF 10 24 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_253_8_0 {
	meta:
		name = "ruserok"
		size = 36
		refs = "0010 ruserok_af"
	strings:
		$1 = { D8 FF BD 27 02 00 02 24 10 00 A2 AF 24 00 BF AF ?? ?? ?? 0? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_253_9_0 {
	meta:
		name = "iruserok_af"
		size = 260
		refs = "0038 memset 008c $LC30"
	strings:
		$1 = { 48 FF BD 27 A4 00 B1 AF C8 00 B1 97 AC 00 B3 AF A8 00 B2 AF A0 00 B0 AF 21 98 A0 00 21 80 80 00 21 90 C0 00 20 00 A4 27 21 28 00 00 80 00 06 24 B0 00 B4 AF B4 00 BF AF ?? ?? ?? 0? 21 A0 E0 00 02 00 02 24 29 00 22 12 0A 00 02 24 1F 00 22 16 B4 00 BF 8F 03 00 05 8A 07 00 04 8A 0B 00 03 8A 0F 00 02 8A 00 00 05 9A 04 00 04 9A 08 00 03 9A 0C 00 02 9A 28 00 A5 AF 20 00 B1 A7 2C 00 A4 AF 30 00 A3 AF 34 00 A2 AF 1C 00 05 24 ?? ?? 02 3C ?? ?? 42 24 10 00 B4 AF 20 00 A4 27 21 30 60 02 21 38 40 02 ?? ?? ?? 0? 14 00 A2 AF B4 00 BF 8F B0 00 B4 8F AC 00 B3 8F A8 00 B2 8F A4 00 B1 8F A0 00 B0 8F 08 00 E0 03 B8 00 BD 27 B0 00 B4 8F AC 00 B3 8F A8 00 B2 8F A4 00 B1 8F A0 00 B0 8F 21 10 00 00 08 00 E0 03 B8 00 BD 27 03 00 02 8A 20 00 B1 A7 10 00 05 24 00 00 02 9A ?? ?? ?? 0? 24 00 A2 AF }
	condition:
		$1
}

rule file_253_10_0 {
	meta:
		name = "iruserok"
		size = 40
		refs = "0014 iruserok_af"
	strings:
		$1 = { D8 FF BD 27 02 00 02 24 28 00 A4 AF 10 00 A2 AF 24 00 BF AF ?? ?? ?? 0? 28 00 A4 27 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_253_11_0 {
	meta:
		name = "__ivaliduser"
		size = 80
		refs = "0000 $LC30"
	strings:
		$1 = { ?? ?? 03 3C C8 FF BD 27 21 10 C0 00 ?? ?? 63 24 10 00 06 24 24 00 A5 AF 10 00 A7 AF 14 00 A3 AF 20 00 A5 27 21 38 40 00 02 00 02 24 34 00 BF AF 20 00 A0 AF 28 00 A0 AF 2C 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_254_1_0 {
	meta:
		name = "hsearch"
		size = 52
		refs = "001c hsearch_r"
	strings:
		$1 = { ?? ?? 02 3C D0 FF BD 27 ?? ?? 42 24 20 00 A7 27 10 00 A2 AF 2C 00 BF AF 30 00 A4 AF ?? ?? ?? 0? 34 00 A5 AF 2C 00 BF 8F 20 00 A2 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "psiginfo"
		size = 1184
		refs = "0004 __gnu_local_gp 0038 fmemopen 0008 $LC11 0068 _sys_siglist 0080 _libc_intl_domainname 0088 __dcgettext 0090 $LC25 009c fprintf 00f4 $LC2 016c $LC18 01b8 $LC23 01d4 $LC24 01f8 _IO_new_fclose 0200 strlen 0228 __libc_errno 0058 $LC13 0288 $LC6 0294 $LC19 02b0 $LC20 02d8 $LC0 02dc $LC1 02f8 __fxprintf 02e8 $LC12 0328 $LC3 0340 $LC4 034c $LC22 0364 __libc_current_sigrtmin 0378 __libc_current_sigrtmax 03c8 $LC15 0400 $LC17 041c $LC8 0428 $LC10 0434 $LC5 00e0 $LC7 0448 $LC9 0460 $LC21 03bc $LC14 0488 fwrite 03f0 $LC16"
	strings:
		$1 = { C8 FD BD 27 ?? ?? 1C 3C ?? ?? 06 3C ?? ?? 9C 27 2C 02 B2 AF 28 02 B1 AF 21 90 A0 00 21 88 80 00 00 02 05 24 20 00 A4 27 24 02 B0 AF 34 02 BF AF 30 02 B3 AF 18 00 BC AF ?? ?? ?? 0? ?? ?? C6 24 A1 00 40 10 21 80 40 00 04 00 40 12 00 00 00 00 00 00 42 82 7E 00 40 14 ?? ?? 05 3C 00 00 32 8E 80 00 42 2E 5A 00 40 10 ?? ?? 03 3C 80 10 12 00 ?? ?? 63 24 21 10 43 00 00 00 45 8C B9 00 A0 10 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? 05 3C 21 20 00 02 ?? ?? A5 24 ?? ?? ?? 0? 21 30 40 00 00 00 22 8E FC FF 42 24 13 00 43 2C 13 00 60 14 ?? ?? 03 3C 04 00 26 8E FD FF 02 24 D6 00 C2 10 FE FF C2 28 67 00 40 14 FA FF 02 24 FF FF 02 24 DC 00 C2 10 FF FF C2 28 D8 00 40 14 ?? ?? 05 3C D0 00 C0 10 80 00 02 24 69 00 C2 14 00 00 00 00 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 80 10 02 00 ?? ?? 63 24 21 18 43 00 ?? ?? 04 3C ?? ?? 05 3C 00 00 63 8C ?? ?? 84 24 ?? ?? A5 24 21 20 44 00 21 10 45 00 00 00 84 8C E2 FF 60 10 00 00 42 8C 04 00 26 8E E0 FF C0 18 2B 10 46 00 DF FF 40 14 FD FF 02 24 21 18 66 00 FF FF 65 90 21 28 85 00 4F 00 A0 10 00 00 00 00 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 05 00 06 24 ?? ?? 05 3C 21 20 00 02 ?? ?? A5 24 ?? ?? ?? 0? 21 30 40 00 00 00 22 8E 04 00 03 24 48 00 43 10 08 00 03 24 46 00 43 10 F6 FF 43 24 02 00 63 2C 43 00 60 14 12 00 03 24 AB 00 43 10 16 00 03 24 67 00 43 10 0C 00 26 8E 10 00 27 8E ?? ?? 05 3C 21 20 00 02 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 00 00 26 8E 21 20 00 02 ?? ?? ?? 0? 21 28 40 00 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 20 00 A4 27 21 30 40 00 18 00 BC 8F A4 0F 02 24 0C 00 00 00 07 00 E0 10 34 02 BF 8F 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC 34 02 BF 8F 30 02 B3 8F 2C 02 B2 8F 28 02 B1 8F 24 02 B0 8F 08 00 E0 03 38 02 BD 27 21 20 00 02 ?? ?? A5 24 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 00 00 32 8E 72 00 C2 10 FB FF C2 28 30 00 40 14 FB FF 02 24 2B 00 C2 10 FC FF 02 24 04 00 C2 14 00 00 00 00 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 ?? ?? 05 3C 21 20 00 02 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? 00 00 22 8E 0C 00 26 8E ?? ?? 05 3C 21 20 00 02 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? 00 00 00 00 14 00 40 12 ?? ?? 07 3C 00 00 42 82 12 00 40 10 ?? ?? E7 24 ?? ?? 07 3C ?? ?? E7 24 00 00 22 8E ?? ?? 05 3C 21 30 40 02 21 20 00 00 10 00 A2 AF ?? ?? ?? 0? ?? ?? A5 24 34 02 BF 8F 30 02 B3 8F 2C 02 B2 8F 28 02 B1 8F 24 02 B0 8F 08 00 E0 03 38 02 BD 27 ?? ?? E7 24 ?? ?? ?? 0? 21 90 E0 00 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 C4 FF 02 24 D6 FF C2 14 00 00 00 00 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 ?? ?? 05 3C 21 20 00 02 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 2A 10 42 02 98 FF 40 14 ?? ?? 04 3C ?? ?? ?? 0? 00 00 32 8E 2A 10 42 02 93 FF 40 10 ?? ?? 04 3C ?? ?? ?? 0? 00 00 33 8E ?? ?? ?? 0? 23 98 62 02 00 00 32 8E 23 10 52 00 2A 98 62 02 0E 00 60 12 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 30 00 42 12 ?? ?? 04 3C ?? ?? ?? 0? 00 00 32 8E ?? ?? 05 3C 21 20 00 02 ?? ?? A5 24 ?? ?? ?? 0? 23 30 42 02 ?? ?? ?? 0? 00 00 22 8E ?? ?? ?? 0? 00 00 00 00 2A 00 42 12 ?? ?? 04 3C ?? ?? ?? 0? 00 00 00 00 00 00 26 8E ?? ?? 05 3C 21 20 00 02 ?? ?? A5 24 ?? ?? ?? 0? 23 30 46 00 ?? ?? ?? 0? 00 00 22 8E ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 10 00 22 8E 0C 00 26 8E 14 00 27 8E ?? ?? 05 3C 21 20 00 02 10 00 A2 AF ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? 84 24 01 00 05 24 0A 00 06 24 ?? ?? ?? 0? 21 38 00 02 ?? ?? ?? 0? 00 00 22 8E ?? ?? ?? 0? ?? ?? 84 24 }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "__strndup"
		size = 100
		refs = "0010 __strnlen 001c malloc 0048 memcpy"
	strings:
		$1 = { D8 FF BD 27 24 00 BF AF 20 00 B1 AF 1C 00 B0 AF ?? ?? ?? 0? 21 88 80 00 01 00 44 24 ?? ?? ?? 0? 21 80 40 00 0A 00 40 10 21 20 40 00 21 10 50 00 00 00 40 A0 24 00 BF 8F 21 28 20 02 21 30 00 02 20 00 B1 8F 1C 00 B0 8F ?? ?? ?? 0? 28 00 BD 27 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "__libc_init_first"
		size = 164
		refs = "0000 _dl_starting_up 0038 __fpu_control 0044 __setfpucw 0040 __libc_multiple_libcs 004c __libc_argc 0054 __libc_argv 0060 __libc_init_secure 005c __environ 0068 _dl_non_dynamic_init 0078 __init_misc 0090 __ctype_init"
	strings:
		$1 = { ?? ?? 02 3C D8 FF BD 27 ?? ?? 43 24 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 24 00 BF AF 21 80 80 00 21 88 A0 00 04 00 60 10 21 90 C0 00 ?? ?? 42 8C 19 00 40 10 01 00 03 24 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 40 AC ?? ?? 02 3C ?? ?? 50 AC ?? ?? 02 3C ?? ?? 51 AC ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 52 AC ?? ?? ?? 0? 00 00 00 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 21 30 40 02 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F ?? ?? ?? 0? 28 00 BD 27 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "getspnam"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getspnam_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { B0 FF BD 27 ?? ?? 1C 3C 44 00 B7 AF ?? ?? 17 3C 34 00 B3 AF ?? ?? 9C 27 21 98 80 00 ?? ?? E3 26 4C 00 BF AF 48 00 BE AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 55 00 40 14 00 00 00 00 ?? ?? 12 3C ?? ?? 46 8E ?? ?? 11 3C 3E 00 C0 10 ?? ?? 27 8E ?? ?? 15 3C ?? ?? B5 26 22 00 14 24 ?? ?? ?? 0? ?? ?? 16 3C ?? ?? C2 AE 21 38 00 02 20 00 A2 27 21 20 60 02 21 28 A0 02 ?? ?? ?? 0? 10 00 A2 AF 16 00 54 14 ?? ?? 30 8E ?? ?? 5E 8E 40 80 10 00 21 20 C0 03 21 28 00 02 ?? ?? ?? 0? ?? ?? 30 AE F0 FF 40 14 21 30 40 00 ?? ?? ?? 0? 21 20 C0 03 18 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 0C 00 03 24 00 00 43 AC ?? ?? 02 3C ?? ?? 40 AC ?? ?? ?? 0? 20 00 A0 AF ?? ?? 42 8E FC FF 40 10 00 00 00 00 ?? ?? E3 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 17 00 40 10 ?? ?? E4 26 4C 00 BF 8F 20 00 A2 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 00 04 02 24 00 04 04 24 ?? ?? ?? 0? ?? ?? 22 AE DF FF 40 10 ?? ?? 42 AE 21 30 40 00 ?? ?? ?? 0? 00 04 07 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 4C 00 BF 8F ?? ?? ?? 0? ?? ?? E4 26 ?? ?? ?? 0? ?? ?? 12 3C }
	condition:
		$1
}

rule file_1347_0_0 {
	meta:
		name = "getaliasbyname"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getaliasbyname_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { B0 FF BD 27 ?? ?? 1C 3C 44 00 B7 AF ?? ?? 17 3C 34 00 B3 AF ?? ?? 9C 27 21 98 80 00 ?? ?? E3 26 4C 00 BF AF 48 00 BE AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 55 00 40 14 00 00 00 00 ?? ?? 12 3C ?? ?? 46 8E ?? ?? 11 3C 3E 00 C0 10 ?? ?? 27 8E ?? ?? 15 3C ?? ?? B5 26 22 00 14 24 ?? ?? ?? 0? ?? ?? 16 3C ?? ?? C2 AE 21 38 00 02 20 00 A2 27 21 20 60 02 21 28 A0 02 ?? ?? ?? 0? 10 00 A2 AF 16 00 54 14 ?? ?? 30 8E ?? ?? 5E 8E 40 80 10 00 21 20 C0 03 21 28 00 02 ?? ?? ?? 0? ?? ?? 30 AE F0 FF 40 14 21 30 40 00 ?? ?? ?? 0? 21 20 C0 03 18 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 0C 00 03 24 00 00 43 AC ?? ?? 02 3C ?? ?? 40 AC ?? ?? ?? 0? 20 00 A0 AF ?? ?? 42 8E FC FF 40 10 00 00 00 00 ?? ?? E3 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 17 00 40 10 ?? ?? E4 26 4C 00 BF 8F 20 00 A2 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 00 04 02 24 00 04 04 24 ?? ?? ?? 0? ?? ?? 22 AE DF FF 40 10 ?? ?? 42 AE 21 30 40 00 ?? ?? ?? 0? 00 04 07 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 4C 00 BF 8F ?? ?? ?? 0? ?? ?? E4 26 ?? ?? ?? 0? ?? ?? 12 3C }
	condition:
		$1
}

rule file_1025_0_0 {
	meta:
		name = "getgrgid"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getgrgid_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { B0 FF BD 27 ?? ?? 1C 3C 44 00 B7 AF ?? ?? 17 3C 34 00 B3 AF ?? ?? 9C 27 21 98 80 00 ?? ?? E3 26 4C 00 BF AF 48 00 BE AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 55 00 40 14 00 00 00 00 ?? ?? 12 3C ?? ?? 46 8E ?? ?? 11 3C 3E 00 C0 10 ?? ?? 27 8E ?? ?? 15 3C ?? ?? B5 26 22 00 14 24 ?? ?? ?? 0? ?? ?? 16 3C ?? ?? C2 AE 21 38 00 02 20 00 A2 27 21 20 60 02 21 28 A0 02 ?? ?? ?? 0? 10 00 A2 AF 16 00 54 14 ?? ?? 30 8E ?? ?? 5E 8E 40 80 10 00 21 20 C0 03 21 28 00 02 ?? ?? ?? 0? ?? ?? 30 AE F0 FF 40 14 21 30 40 00 ?? ?? ?? 0? 21 20 C0 03 18 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 0C 00 03 24 00 00 43 AC ?? ?? 02 3C ?? ?? 40 AC ?? ?? ?? 0? 20 00 A0 AF ?? ?? 42 8E FC FF 40 10 00 00 00 00 ?? ?? E3 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 17 00 40 10 ?? ?? E4 26 4C 00 BF 8F 20 00 A2 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 00 04 02 24 00 04 04 24 ?? ?? ?? 0? ?? ?? 22 AE DF FF 40 10 ?? ?? 42 AE 21 30 40 00 ?? ?? ?? 0? 00 04 07 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 4C 00 BF 8F ?? ?? ?? 0? ?? ?? E4 26 ?? ?? ?? 0? ?? ?? 12 3C }
	condition:
		$1
}

rule file_516_0_0 {
	meta:
		name = "getgrnam"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getgrnam_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { B0 FF BD 27 ?? ?? 1C 3C 44 00 B7 AF ?? ?? 17 3C 34 00 B3 AF ?? ?? 9C 27 21 98 80 00 ?? ?? E3 26 4C 00 BF AF 48 00 BE AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 55 00 40 14 00 00 00 00 ?? ?? 12 3C ?? ?? 46 8E ?? ?? 11 3C 3E 00 C0 10 ?? ?? 27 8E ?? ?? 15 3C ?? ?? B5 26 22 00 14 24 ?? ?? ?? 0? ?? ?? 16 3C ?? ?? C2 AE 21 38 00 02 20 00 A2 27 21 20 60 02 21 28 A0 02 ?? ?? ?? 0? 10 00 A2 AF 16 00 54 14 ?? ?? 30 8E ?? ?? 5E 8E 40 80 10 00 21 20 C0 03 21 28 00 02 ?? ?? ?? 0? ?? ?? 30 AE F0 FF 40 14 21 30 40 00 ?? ?? ?? 0? 21 20 C0 03 18 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 0C 00 03 24 00 00 43 AC ?? ?? 02 3C ?? ?? 40 AC ?? ?? ?? 0? 20 00 A0 AF ?? ?? 42 8E FC FF 40 10 00 00 00 00 ?? ?? E3 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 17 00 40 10 ?? ?? E4 26 4C 00 BF 8F 20 00 A2 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 00 04 02 24 00 04 04 24 ?? ?? ?? 0? ?? ?? 22 AE DF FF 40 10 ?? ?? 42 AE 21 30 40 00 ?? ?? ?? 0? 00 04 07 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 4C 00 BF 8F ?? ?? ?? 0? ?? ?? E4 26 ?? ?? ?? 0? ?? ?? 12 3C }
	condition:
		$1
}

rule file_434_0_0 {
	meta:
		name = "getprotobyname"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getprotobyname_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { B0 FF BD 27 ?? ?? 1C 3C 44 00 B7 AF ?? ?? 17 3C 34 00 B3 AF ?? ?? 9C 27 21 98 80 00 ?? ?? E3 26 4C 00 BF AF 48 00 BE AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 55 00 40 14 00 00 00 00 ?? ?? 12 3C ?? ?? 46 8E ?? ?? 11 3C 3E 00 C0 10 ?? ?? 27 8E ?? ?? 15 3C ?? ?? B5 26 22 00 14 24 ?? ?? ?? 0? ?? ?? 16 3C ?? ?? C2 AE 21 38 00 02 20 00 A2 27 21 20 60 02 21 28 A0 02 ?? ?? ?? 0? 10 00 A2 AF 16 00 54 14 ?? ?? 30 8E ?? ?? 5E 8E 40 80 10 00 21 20 C0 03 21 28 00 02 ?? ?? ?? 0? ?? ?? 30 AE F0 FF 40 14 21 30 40 00 ?? ?? ?? 0? 21 20 C0 03 18 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 0C 00 03 24 00 00 43 AC ?? ?? 02 3C ?? ?? 40 AC ?? ?? ?? 0? 20 00 A0 AF ?? ?? 42 8E FC FF 40 10 00 00 00 00 ?? ?? E3 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 17 00 40 10 ?? ?? E4 26 4C 00 BF 8F 20 00 A2 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 00 04 02 24 00 04 04 24 ?? ?? ?? 0? ?? ?? 22 AE DF FF 40 10 ?? ?? 42 AE 21 30 40 00 ?? ?? ?? 0? 00 04 07 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 4C 00 BF 8F ?? ?? ?? 0? ?? ?? E4 26 ?? ?? ?? 0? ?? ?? 12 3C }
	condition:
		$1
}

rule file_1446_0_0 {
	meta:
		name = "getprotobynumber"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getprotobynumber_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { B0 FF BD 27 ?? ?? 1C 3C 44 00 B7 AF ?? ?? 17 3C 34 00 B3 AF ?? ?? 9C 27 21 98 80 00 ?? ?? E3 26 4C 00 BF AF 48 00 BE AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 55 00 40 14 00 00 00 00 ?? ?? 12 3C ?? ?? 46 8E ?? ?? 11 3C 3E 00 C0 10 ?? ?? 27 8E ?? ?? 15 3C ?? ?? B5 26 22 00 14 24 ?? ?? ?? 0? ?? ?? 16 3C ?? ?? C2 AE 21 38 00 02 20 00 A2 27 21 20 60 02 21 28 A0 02 ?? ?? ?? 0? 10 00 A2 AF 16 00 54 14 ?? ?? 30 8E ?? ?? 5E 8E 40 80 10 00 21 20 C0 03 21 28 00 02 ?? ?? ?? 0? ?? ?? 30 AE F0 FF 40 14 21 30 40 00 ?? ?? ?? 0? 21 20 C0 03 18 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 0C 00 03 24 00 00 43 AC ?? ?? 02 3C ?? ?? 40 AC ?? ?? ?? 0? 20 00 A0 AF ?? ?? 42 8E FC FF 40 10 00 00 00 00 ?? ?? E3 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 17 00 40 10 ?? ?? E4 26 4C 00 BF 8F 20 00 A2 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 00 04 02 24 00 04 04 24 ?? ?? ?? 0? ?? ?? 22 AE DF FF 40 10 ?? ?? 42 AE 21 30 40 00 ?? ?? ?? 0? 00 04 07 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 4C 00 BF 8F ?? ?? ?? 0? ?? ?? E4 26 ?? ?? ?? 0? ?? ?? 12 3C }
	condition:
		$1
}

rule file_304_0_0 {
	meta:
		name = "getpwnam"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getpwnam_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { B0 FF BD 27 ?? ?? 1C 3C 44 00 B7 AF ?? ?? 17 3C 34 00 B3 AF ?? ?? 9C 27 21 98 80 00 ?? ?? E3 26 4C 00 BF AF 48 00 BE AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 55 00 40 14 00 00 00 00 ?? ?? 12 3C ?? ?? 46 8E ?? ?? 11 3C 3E 00 C0 10 ?? ?? 27 8E ?? ?? 15 3C ?? ?? B5 26 22 00 14 24 ?? ?? ?? 0? ?? ?? 16 3C ?? ?? C2 AE 21 38 00 02 20 00 A2 27 21 20 60 02 21 28 A0 02 ?? ?? ?? 0? 10 00 A2 AF 16 00 54 14 ?? ?? 30 8E ?? ?? 5E 8E 40 80 10 00 21 20 C0 03 21 28 00 02 ?? ?? ?? 0? ?? ?? 30 AE F0 FF 40 14 21 30 40 00 ?? ?? ?? 0? 21 20 C0 03 18 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 0C 00 03 24 00 00 43 AC ?? ?? 02 3C ?? ?? 40 AC ?? ?? ?? 0? 20 00 A0 AF ?? ?? 42 8E FC FF 40 10 00 00 00 00 ?? ?? E3 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 17 00 40 10 ?? ?? E4 26 4C 00 BF 8F 20 00 A2 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 00 04 02 24 00 04 04 24 ?? ?? ?? 0? ?? ?? 22 AE DF FF 40 10 ?? ?? 42 AE 21 30 40 00 ?? ?? ?? 0? 00 04 07 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 4C 00 BF 8F ?? ?? ?? 0? ?? ?? E4 26 ?? ?? ?? 0? ?? ?? 12 3C }
	condition:
		$1
}

rule file_1077_0_0 {
	meta:
		name = "getpwuid"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getpwuid_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { B0 FF BD 27 ?? ?? 1C 3C 44 00 B7 AF ?? ?? 17 3C 34 00 B3 AF ?? ?? 9C 27 21 98 80 00 ?? ?? E3 26 4C 00 BF AF 48 00 BE AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 55 00 40 14 00 00 00 00 ?? ?? 12 3C ?? ?? 46 8E ?? ?? 11 3C 3E 00 C0 10 ?? ?? 27 8E ?? ?? 15 3C ?? ?? B5 26 22 00 14 24 ?? ?? ?? 0? ?? ?? 16 3C ?? ?? C2 AE 21 38 00 02 20 00 A2 27 21 20 60 02 21 28 A0 02 ?? ?? ?? 0? 10 00 A2 AF 16 00 54 14 ?? ?? 30 8E ?? ?? 5E 8E 40 80 10 00 21 20 C0 03 21 28 00 02 ?? ?? ?? 0? ?? ?? 30 AE F0 FF 40 14 21 30 40 00 ?? ?? ?? 0? 21 20 C0 03 18 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 0C 00 03 24 00 00 43 AC ?? ?? 02 3C ?? ?? 40 AC ?? ?? ?? 0? 20 00 A0 AF ?? ?? 42 8E FC FF 40 10 00 00 00 00 ?? ?? E3 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 17 00 40 10 ?? ?? E4 26 4C 00 BF 8F 20 00 A2 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 00 04 02 24 00 04 04 24 ?? ?? ?? 0? ?? ?? 22 AE DF FF 40 10 ?? ?? 42 AE 21 30 40 00 ?? ?? ?? 0? 00 04 07 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 4C 00 BF 8F ?? ?? ?? 0? ?? ?? E4 26 ?? ?? ?? 0? ?? ?? 12 3C }
	condition:
		$1
}

rule file_353_0_0 {
	meta:
		name = "getrpcbyname"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getrpcbyname_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { B0 FF BD 27 ?? ?? 1C 3C 44 00 B7 AF ?? ?? 17 3C 34 00 B3 AF ?? ?? 9C 27 21 98 80 00 ?? ?? E3 26 4C 00 BF AF 48 00 BE AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 55 00 40 14 00 00 00 00 ?? ?? 12 3C ?? ?? 46 8E ?? ?? 11 3C 3E 00 C0 10 ?? ?? 27 8E ?? ?? 15 3C ?? ?? B5 26 22 00 14 24 ?? ?? ?? 0? ?? ?? 16 3C ?? ?? C2 AE 21 38 00 02 20 00 A2 27 21 20 60 02 21 28 A0 02 ?? ?? ?? 0? 10 00 A2 AF 16 00 54 14 ?? ?? 30 8E ?? ?? 5E 8E 40 80 10 00 21 20 C0 03 21 28 00 02 ?? ?? ?? 0? ?? ?? 30 AE F0 FF 40 14 21 30 40 00 ?? ?? ?? 0? 21 20 C0 03 18 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 0C 00 03 24 00 00 43 AC ?? ?? 02 3C ?? ?? 40 AC ?? ?? ?? 0? 20 00 A0 AF ?? ?? 42 8E FC FF 40 10 00 00 00 00 ?? ?? E3 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 17 00 40 10 ?? ?? E4 26 4C 00 BF 8F 20 00 A2 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 00 04 02 24 00 04 04 24 ?? ?? ?? 0? ?? ?? 22 AE DF FF 40 10 ?? ?? 42 AE 21 30 40 00 ?? ?? ?? 0? 00 04 07 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 4C 00 BF 8F ?? ?? ?? 0? ?? ?? E4 26 ?? ?? ?? 0? ?? ?? 12 3C }
	condition:
		$1
}

rule file_530_0_0 {
	meta:
		name = "getrpcbynumber"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getrpcbynumber_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { B0 FF BD 27 ?? ?? 1C 3C 44 00 B7 AF ?? ?? 17 3C 34 00 B3 AF ?? ?? 9C 27 21 98 80 00 ?? ?? E3 26 4C 00 BF AF 48 00 BE AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 55 00 40 14 00 00 00 00 ?? ?? 12 3C ?? ?? 46 8E ?? ?? 11 3C 3E 00 C0 10 ?? ?? 27 8E ?? ?? 15 3C ?? ?? B5 26 22 00 14 24 ?? ?? ?? 0? ?? ?? 16 3C ?? ?? C2 AE 21 38 00 02 20 00 A2 27 21 20 60 02 21 28 A0 02 ?? ?? ?? 0? 10 00 A2 AF 16 00 54 14 ?? ?? 30 8E ?? ?? 5E 8E 40 80 10 00 21 20 C0 03 21 28 00 02 ?? ?? ?? 0? ?? ?? 30 AE F0 FF 40 14 21 30 40 00 ?? ?? ?? 0? 21 20 C0 03 18 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 0C 00 03 24 00 00 43 AC ?? ?? 02 3C ?? ?? 40 AC ?? ?? ?? 0? 20 00 A0 AF ?? ?? 42 8E FC FF 40 10 00 00 00 00 ?? ?? E3 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 17 00 40 10 ?? ?? E4 26 4C 00 BF 8F 20 00 A2 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 00 04 02 24 00 04 04 24 ?? ?? ?? 0? ?? ?? 22 AE DF FF 40 10 ?? ?? 42 AE 21 30 40 00 ?? ?? ?? 0? 00 04 07 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 4C 00 BF 8F ?? ?? ?? 0? ?? ?? E4 26 ?? ?? ?? 0? ?? ?? 12 3C }
	condition:
		$1
}

rule file_498_0_0 {
	meta:
		name = "getsgnam"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getsgnam_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { B0 FF BD 27 ?? ?? 1C 3C 44 00 B7 AF ?? ?? 17 3C 34 00 B3 AF ?? ?? 9C 27 21 98 80 00 ?? ?? E3 26 4C 00 BF AF 48 00 BE AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 55 00 40 14 00 00 00 00 ?? ?? 12 3C ?? ?? 46 8E ?? ?? 11 3C 3E 00 C0 10 ?? ?? 27 8E ?? ?? 15 3C ?? ?? B5 26 22 00 14 24 ?? ?? ?? 0? ?? ?? 16 3C ?? ?? C2 AE 21 38 00 02 20 00 A2 27 21 20 60 02 21 28 A0 02 ?? ?? ?? 0? 10 00 A2 AF 16 00 54 14 ?? ?? 30 8E ?? ?? 5E 8E 40 80 10 00 21 20 C0 03 21 28 00 02 ?? ?? ?? 0? ?? ?? 30 AE F0 FF 40 14 21 30 40 00 ?? ?? ?? 0? 21 20 C0 03 18 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 0C 00 03 24 00 00 43 AC ?? ?? 02 3C ?? ?? 40 AC ?? ?? ?? 0? 20 00 A0 AF ?? ?? 42 8E FC FF 40 10 00 00 00 00 ?? ?? E3 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 17 00 40 10 ?? ?? E4 26 4C 00 BF 8F 20 00 A2 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 00 04 02 24 00 04 04 24 ?? ?? ?? 0? ?? ?? 22 AE DF FF 40 10 ?? ?? 42 AE 21 30 40 00 ?? ?? ?? 0? 00 04 07 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 4C 00 BF 8F ?? ?? ?? 0? ?? ?? E4 26 ?? ?? ?? 0? ?? ?? 12 3C }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "timerfd_settime"
		size = 28
	strings:
		$1 = { E3 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_260_0_0 {
	meta:
		name = "init_module"
		size = 28
	strings:
		$1 = { 20 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_261_0_0 {
	meta:
		name = "print_errno_message"
		size = 52
		refs = "000c __strerror_r 0014 $LC0 0020 __fxprintf"
	strings:
		$1 = { E0 FB BD 27 18 00 A5 27 1C 04 BF AF ?? ?? ?? 0? 00 04 06 24 ?? ?? 05 3C 21 20 00 00 ?? ?? A5 24 ?? ?? ?? 0? 21 30 40 00 1C 04 BF 8F 08 00 E0 03 20 04 BD 27 }
	condition:
		$1
}

rule file_261_1_0 {
	meta:
		name = "error_tail"
		size = 580
		refs = "0008 stderr 0050 strlen 00bc __mbsrtowcs 00d8 __vfwprintf 00e8 free 00f0 error_message_count 010c __fxprintf 0194 $LC2 0114 _IO_fflush 0168 $LC3 01a0 vfprintf 01c0 __libc_alloca_cutoff 01d4 realloc 0200 fputws_unlocked 01fc $LC1 023c exit"
	strings:
		$1 = { A8 FF BD 27 44 00 B5 AF ?? ?? 15 3C ?? ?? A2 8E 50 00 BE AF 21 F0 A0 03 6C 00 43 8C 48 00 B6 AF 34 00 B1 AF 54 00 BF AF 4C 00 B7 AF 40 00 B4 AF 3C 00 B3 AF 38 00 B2 AF 30 00 B0 AF 58 00 C4 AF 21 B0 A0 00 21 88 C0 00 53 00 60 18 64 00 C7 AF ?? ?? ?? 0? 21 20 C0 00 FF 7F 13 3C 01 00 50 24 21 A0 00 00 21 B8 00 00 01 80 12 34 ?? ?? ?? 0? FF FF 73 36 2B 10 13 02 37 00 40 10 40 80 10 00 80 28 10 00 2B 10 B2 00 4D 00 40 10 21 20 A0 00 0E 00 A3 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 10 00 B7 27 21 20 E0 02 20 00 C5 27 21 30 00 02 18 00 C7 27 18 00 C0 AF 1C 00 C0 AF ?? ?? ?? 0? 20 00 D1 AF EB FF 02 12 FF FF 03 24 22 00 43 10 ?? ?? A4 8E 64 00 C6 8F ?? ?? ?? 0? 21 28 E0 02 04 00 80 12 ?? ?? 02 3C ?? ?? ?? 0? 21 20 E0 02 ?? ?? 02 3C ?? ?? 43 8C 01 00 63 24 22 00 C0 16 ?? ?? 43 AC ?? ?? 05 3C 21 20 00 00 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? ?? ?? A4 8E 58 00 C2 8F 46 00 40 14 54 00 DF 8F 21 E8 C0 03 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 15 00 80 16 00 00 00 00 ?? ?? A4 8E 64 00 C6 8F ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 ?? ?? 02 3C ?? ?? 43 8C 01 00 63 24 E0 FF C0 12 ?? ?? 43 AC ?? ?? ?? 0? 21 20 C0 02 ?? ?? ?? 0? ?? ?? 05 3C 21 28 C0 00 21 20 40 00 ?? ?? ?? 0? 21 30 E0 00 ?? ?? ?? 0? ?? ?? 02 3C ?? ?? ?? 0? 21 20 E0 02 ?? ?? ?? 0? ?? ?? A4 8E ?? ?? ?? 0? 28 00 C5 AF B1 FF 40 14 28 00 C5 8F 0A B8 14 00 ?? ?? ?? 0? 21 20 E0 02 21 A0 E0 02 03 00 40 10 21 B8 40 00 ?? ?? ?? 0? 01 00 14 24 ?? ?? ?? 0? 21 20 80 02 ?? ?? A5 8E ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 21 E8 C0 03 54 00 BF 8F 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 ?? ?? ?? 0? 21 20 40 00 }
	condition:
		$1
}

rule file_261_2_0 {
	meta:
		name = "__error"
		size = 204
		refs = "0008 pthread_setcancelstate 0048 _IO_fflush 0044 stdout 0050 error_print_progname 005c program_invocation_name 00bc __fxprintf 00b4 $LC4"
	strings:
		$1 = { C8 FF BD 27 24 00 B0 AF ?? ?? 10 3C ?? ?? 10 26 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 34 00 BF AF 21 98 80 00 21 90 A0 00 44 00 A7 AF 21 88 C0 00 04 00 00 12 18 00 A0 AF 01 00 04 24 ?? ?? ?? 0? 18 00 A5 27 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 44 8C ?? ?? 02 3C ?? ?? 59 8C 15 00 20 13 ?? ?? 02 3C 09 F8 20 03 00 00 00 00 44 00 A2 27 21 20 60 02 21 28 40 02 21 30 20 02 21 38 40 00 ?? ?? ?? 0? 1C 00 A2 AF 03 00 00 12 18 00 A4 8F ?? ?? ?? 0? 21 28 00 00 34 00 BF 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? 46 8C ?? ?? 05 3C 21 20 00 00 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? 44 00 A2 27 }
	condition:
		$1
}

rule file_261_3_0 {
	meta:
		name = "__error_at_line"
		size = 348
		refs = "0000 error_one_per_line 0054 pthread_setcancelstate 0074 _IO_fflush 0070 stdout 007c error_print_progname 009c $LC5 00ac __fxprintf 0120 strcmp 0098 $LC6 0088 program_invocation_name 0144 $LC7"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C C0 FF BD 27 34 00 B4 AF 30 00 B3 AF 28 00 B1 AF 24 00 B0 AF 3C 00 BF AF 38 00 B5 AF 2C 00 B2 AF 21 A0 80 00 21 98 A0 00 21 80 C0 00 07 00 40 10 21 88 E0 00 ?? ?? 12 3C ?? ?? 42 8E 2F 00 47 10 ?? ?? 15 3C ?? ?? B0 AE ?? ?? 51 AE ?? ?? 12 3C ?? ?? 52 26 04 00 40 12 18 00 A0 AF 01 00 04 24 ?? ?? ?? 0? 18 00 A5 27 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 44 8C ?? ?? 02 3C ?? ?? 59 8C 2E 00 20 13 ?? ?? 02 3C 09 F8 20 03 00 00 00 00 28 00 00 12 ?? ?? 05 3C ?? ?? 05 3C ?? ?? A5 24 21 20 00 00 21 30 00 02 ?? ?? ?? 0? 21 38 20 02 50 00 A6 8F 54 00 A2 27 21 20 80 02 21 28 60 02 21 38 40 00 ?? ?? ?? 0? 1C 00 A2 AF 03 00 40 12 18 00 A4 8F ?? ?? ?? 0? 21 28 00 00 3C 00 BF 8F 38 00 B5 8F 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? A4 8E F6 FF C4 10 3C 00 BF 8F CE FF 80 10 00 00 00 00 CC FF C0 10 00 00 00 00 ?? ?? ?? 0? 21 28 C0 00 EE FF 40 10 3C 00 BF 8F ?? ?? ?? 0? ?? ?? B0 AE ?? ?? ?? 0? ?? ?? A5 24 ?? ?? 46 8C ?? ?? 05 3C 21 20 00 00 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_262_0_0 {
	meta:
		name = "__sched_getparam"
		size = 28
	strings:
		$1 = { 3F 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "object_compare"
		size = 168
	strings:
		$1 = { 08 00 86 8C 08 00 A3 8C 2B 10 66 00 2B 18 C3 00 23 10 43 00 0C 00 40 14 00 00 00 00 04 00 83 8C 04 00 A6 8C 00 00 87 8C 00 00 A8 8C 2B 10 C3 00 0C 00 40 10 01 00 04 24 2B 28 66 00 04 00 A0 10 01 00 02 24 23 10 82 00 08 00 E0 03 00 00 00 00 10 00 C3 10 00 00 00 00 21 10 00 00 08 00 E0 03 23 10 82 00 06 00 66 10 2B 28 66 00 21 20 00 00 F4 FF A0 14 01 00 02 24 ?? ?? ?? 0? 00 00 00 00 2B 10 07 01 EC FF 40 14 00 00 00 00 ?? ?? ?? 0? 21 20 00 00 2B 38 E8 00 EF FF E0 10 00 00 00 00 08 00 E0 03 23 10 82 00 }
	condition:
		$1
}

rule file_263_1_0 {
	meta:
		name = "add_object.isra.1"
		size = 124
		refs = "0020 malloc 004c __tsearch"
	strings:
		$1 = { D8 FF BD 27 18 00 B0 AF 21 80 80 00 10 00 04 24 20 00 B2 AF 1C 00 B1 AF 24 00 BF AF 21 88 A0 00 ?? ?? ?? 0? 21 90 C0 00 12 00 40 10 ?? ?? 06 3C 00 00 27 8E 00 00 43 8E 21 20 40 00 30 00 05 26 ?? ?? C6 24 00 00 47 AC 04 00 40 AC ?? ?? ?? 0? 08 00 43 AC 01 00 42 2C 23 10 02 00 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_263_2_0 {
	meta:
		name = "process_entry"
		size = 864
		refs = "0000 __gnu_local_gp 0064 mempcpy 009c __fxstatat 0118 realloc 01a0 __lxstat 01b8 __libc_errno 023c __xstat 0314 __tfind"
	strings:
		$1 = { ?? ?? 1C 3C 20 FF BD 27 ?? ?? 9C 27 D4 00 B2 AF D0 00 B1 AF CC 00 B0 AF DC 00 BF AF D8 00 B3 AF 18 00 BC AF 00 00 C2 80 2E 00 03 24 21 88 C0 00 21 80 80 00 40 00 43 10 21 90 A0 00 14 00 03 8E 10 00 04 8E 02 00 62 24 21 10 47 00 2B 20 82 00 2F 00 80 14 40 28 02 00 0C 00 04 8E 21 28 20 02 21 20 83 00 ?? ?? ?? 0? 21 30 E0 00 00 00 40 A0 04 00 45 8E FF FF 02 24 3F 00 A2 10 00 01 02 24 1C 00 04 8E 20 00 B3 27 01 00 84 30 0A 10 04 00 10 00 A2 AF 03 00 04 24 21 30 20 02 ?? ?? ?? 0? 21 38 60 02 18 00 BC 8F 41 00 40 04 00 00 00 00 34 00 A2 8F 00 40 03 24 00 F0 42 30 7E 00 43 10 00 A0 03 34 7F 00 43 10 00 00 00 00 1C 00 02 8E 21 20 00 00 02 00 43 30 45 00 60 10 01 00 03 24 28 00 05 8E 20 00 A3 8F 3D 00 A3 10 21 18 00 00 21 10 60 00 DC 00 BF 8F D8 00 B3 8F D4 00 B2 8F D0 00 B1 8F CC 00 B0 8F 08 00 E0 03 E0 00 BD 27 0C 00 04 8E 10 00 05 AE ?? ?? ?? 0? C0 00 A7 AF 8D 00 40 10 C0 00 A7 8F 14 00 03 8E 0C 00 02 AE ?? ?? ?? 0? 21 20 40 00 01 00 C3 80 06 00 60 10 00 00 00 00 BD FF 62 14 00 00 00 00 02 00 C2 80 BA FF 40 14 00 00 00 00 21 10 00 00 DC 00 BF 8F D8 00 B3 8F D4 00 B2 8F D0 00 B1 8F CC 00 B0 8F 08 00 E0 03 E0 00 BD 27 1C 00 02 8E 04 00 43 30 02 00 60 14 20 00 B3 27 0C 00 11 8E 01 00 42 30 03 00 04 24 21 28 20 02 28 00 40 10 21 30 60 02 ?? ?? ?? 0? 00 00 00 00 C1 FF 41 04 18 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 42 8C 0D 00 03 24 20 00 43 10 02 00 03 24 1E 00 43 10 FF FF 03 24 ?? ?? ?? 0? 21 10 60 00 2C 00 03 8E C2 FF 60 14 21 18 00 00 01 00 03 24 37 00 83 14 80 18 04 00 01 00 42 30 3E 00 40 10 ?? ?? 06 3C 21 20 00 02 21 28 60 02 ?? ?? ?? 0? 21 30 40 02 21 18 40 00 1C 00 04 8E 10 00 84 30 CE FF 80 10 21 10 60 00 02 00 02 24 CA FF 62 10 21 10 60 00 ?? ?? ?? 0? DC 00 BF 8F ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 18 00 BC 8F 1C 00 02 8E 01 00 43 30 1E 00 60 14 0C 00 03 24 F0 00 A4 8F 0A 00 03 24 9B FF 83 10 06 00 04 24 04 00 45 8E FF FF 02 24 33 00 A2 10 03 00 04 24 00 01 02 24 10 00 A2 AF 21 30 20 02 ?? ?? ?? 0? 21 38 60 02 0F 00 40 14 0C 00 03 24 34 00 A3 8F 00 A0 02 34 00 F0 63 30 0A 00 62 14 0C 00 03 24 1C 00 02 8E ?? ?? ?? 0? 06 00 04 24 1C 00 02 8E ?? ?? ?? 0? 01 00 04 24 1C 00 02 8E ?? ?? ?? 0? 04 00 04 24 20 00 02 8E 24 00 19 8E 0C 00 04 8E 21 10 43 00 00 00 46 8C 21 28 60 02 09 F8 20 03 14 00 07 26 ?? ?? ?? 0? 21 18 40 00 20 00 A2 8F B0 00 A4 27 B0 00 A2 AF 30 00 A2 8F 30 00 05 26 ?? ?? C6 24 B4 00 A0 AF ?? ?? ?? 0? B8 00 A2 AF 74 FF 40 14 21 18 00 00 21 20 00 02 21 28 60 02 ?? ?? ?? 0? 30 00 A6 27 B3 FF 40 10 21 18 40 00 ?? ?? ?? 0? 1C 00 04 8E 21 28 20 02 ?? ?? ?? 0? 21 30 60 02 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_263_3_0 {
	meta:
		name = "ftw_dir"
		size = 1868
		refs = "0020 __gnu_local_gp 0070 malloc 009c strlen 00d4 realloc 00f0 mempcpy 0100 __readdir64 015c __closedir 01c8 __openat64_nocancel 01e0 __fdopendir 0270 __rawmemchr 0358 __libc_errno 0364 free 0398 $LC0 03a0 __opendir 04b8 __fchdir 06a0 __chdir 069c $LC6 06c0 $LC5 06f0 $LC4 06f4 $LC2 0708 __assert_fail 06f8 __PRETTY_FUNCTION__.8352 019c $LC1 0714 __PRETTY_FUNCTION__.8316 072c $LC3"
	strings:
		$1 = { 04 00 83 8C 00 00 82 8C 98 FF BD 27 80 18 03 00 21 10 43 00 14 00 83 8C 40 00 B0 AF 00 00 50 8C ?? ?? 1C 3C 04 00 C2 24 ?? ?? 9C 27 0A 10 06 00 5C 00 B7 AF 4C 00 B3 AF 64 00 BF AF 60 00 BE AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 48 00 B2 AF 44 00 B1 AF 18 00 BC AF 21 98 80 00 21 B8 C0 00 6C 00 A5 AF 34 00 A3 AF 4D 00 00 12 30 00 A2 AF ?? ?? ?? 0? 00 04 04 24 21 A0 40 00 4F 01 40 10 18 00 BC 8F 00 00 15 8E 00 04 12 24 21 80 00 00 ?? ?? ?? 0? 00 04 16 24 13 00 51 24 ?? ?? ?? 0? 21 20 20 02 21 F0 50 00 21 30 40 00 02 00 C2 27 2B 10 52 00 0E 00 40 14 21 20 90 02 40 10 06 00 00 04 44 2C 0B 10 C4 02 21 90 42 02 21 20 80 02 21 28 40 02 ?? ?? ?? 0? 38 00 A6 AF 18 00 BC 8F 12 01 40 10 38 00 A6 8F 21 A0 40 00 21 20 90 02 ?? ?? ?? 0? 21 28 20 02 00 00 40 A0 01 00 D0 27 ?? ?? ?? 0? 21 20 A0 02 E3 FF 40 14 21 20 80 02 21 10 90 02 00 00 40 A0 04 00 62 8E 00 00 63 8E 80 10 02 00 21 10 62 00 01 00 05 26 ?? ?? ?? 0? 00 00 50 8C 04 00 64 8E 00 00 63 8E 18 00 BC 8F 80 20 04 00 08 00 02 AE 21 18 64 00 00 00 62 8C 08 00 42 8C F5 00 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 A0 02 04 00 63 8E 00 00 62 8E FF FF 05 24 80 18 03 00 21 10 43 00 00 00 44 8C 00 00 80 AC 00 00 44 8C 04 00 85 AC 00 00 40 AC 00 00 62 8E 21 18 43 00 00 00 62 8C 5D 01 40 14 ?? ?? 04 3C 30 00 A3 8F 73 00 60 10 FF FF 10 24 00 00 64 8C 70 00 90 10 01 00 06 3C 0C 00 65 8E 14 00 62 8E 80 00 C6 24 21 28 A2 00 ?? ?? ?? 0? 21 38 00 00 21 88 40 00 18 00 BC 8F F8 00 50 10 20 00 A0 AF ?? ?? ?? 0? 21 20 40 00 20 00 A2 AF 07 00 40 14 18 00 BC 8F 21 20 20 02 A6 0F 02 24 0C 00 00 00 20 00 A2 8F ED 00 40 10 00 00 00 00 04 00 63 8E 00 00 65 8E 00 00 46 8C 08 00 64 8E 80 10 03 00 21 28 A2 00 20 00 B2 27 01 00 62 24 24 00 A6 AF 28 00 A0 AF 00 00 B2 AC 1F 01 44 10 04 00 62 AE 1C 00 62 8E 08 00 43 30 E2 00 60 10 6C 00 A5 8F 04 00 42 30 E9 00 40 14 20 00 A2 8F 18 00 62 8E 0C 00 70 8E 21 28 00 00 01 00 42 24 18 00 62 AE ?? ?? ?? 0? 21 20 00 02 2C 01 02 12 18 00 BC 8F FF FF 44 80 2F 00 03 24 04 00 83 10 00 00 00 00 00 00 43 A0 0C 00 70 8E 01 00 42 24 23 80 50 00 ?? ?? ?? 0? 14 00 70 AE ?? ?? ?? 0? 00 00 00 00 21 80 40 00 3F 00 40 10 18 00 BC 8F 13 00 11 26 ?? ?? ?? 0? 21 20 20 02 12 00 03 92 21 20 60 02 21 28 40 02 10 00 A3 AF 21 30 20 02 ?? ?? ?? 0? 21 38 40 00 21 80 40 00 32 00 40 14 18 00 BC 8F 20 00 A4 8F EC FF 80 14 28 00 B4 8F 00 00 82 82 06 00 40 14 21 20 80 02 ?? ?? ?? 0? 21 80 00 00 01 00 22 82 10 00 40 10 28 00 A4 8F 21 20 80 02 ?? ?? ?? 0? 21 28 00 00 23 38 54 00 21 30 80 02 10 00 A0 AF 21 20 60 02 21 28 40 02 ?? ?? ?? 0? 21 88 40 00 21 80 40 00 18 00 BC 8F F0 FF 40 10 01 00 34 26 28 00 A4 8F ?? ?? 91 8F 3B E8 03 7C 21 88 23 02 ?? ?? ?? 0? 00 00 32 8E ?? ?? ?? 0? 00 00 32 AE 1C 00 62 8E 04 00 42 30 08 00 40 10 0C 00 64 8E 14 00 62 8E 21 20 82 00 00 00 82 80 03 00 40 14 00 00 00 00 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 00 00 00 00 20 00 A2 AF ?? ?? ?? 0? 18 00 BC 8F 20 00 A4 8F C8 00 80 10 ?? ?? 91 8F 28 00 A2 8F 3B E8 03 7C 21 88 23 02 C8 00 40 14 00 00 32 8E ?? ?? ?? 0? 00 00 00 00 04 00 62 8E FF FF 03 24 24 00 A3 AF FF FF 43 24 00 00 32 AE 67 00 40 10 04 00 63 AE 00 00 62 8E 80 18 03 00 21 18 43 00 00 00 60 AC 1C 00 62 8E 10 00 42 30 3A 00 40 10 03 00 02 24 38 00 02 16 00 00 00 00 14 00 62 8E 0C 00 63 8E 21 10 62 00 FF FF 40 A0 18 00 62 8E 34 00 A3 8F FF FF 42 24 14 00 63 AE 18 00 62 AE 1C 00 62 8E 08 00 42 30 08 00 40 10 21 80 00 00 24 00 79 8E 0C 00 64 8E 6C 00 A5 8F 05 00 06 24 09 F8 20 03 14 00 67 26 21 80 40 00 16 00 E0 12 64 00 BF 8F 1C 00 62 8E 04 00 43 30 12 00 60 10 00 00 00 00 08 00 00 12 10 00 42 30 0F 00 40 10 21 10 00 02 FF FF 02 24 2F 00 02 12 01 00 02 24 0A 00 02 12 21 10 00 02 00 00 E2 8E 76 00 40 10 00 00 00 00 ?? ?? ?? 0? 00 00 44 8C 72 00 40 14 00 00 00 00 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 14 00 62 8E 0C 00 63 8E 21 10 62 00 FF FF 40 A0 18 00 62 8E 34 00 A3 8F FF FF 42 24 14 00 63 AE D4 FF 00 16 18 00 62 AE ?? ?? ?? 0? 1C 00 62 8E ?? ?? 91 8F 3B E8 03 7C 21 20 80 02 21 88 23 02 ?? ?? ?? 0? 00 00 30 8E 00 00 30 AE 21 18 00 02 0D 00 02 24 13 00 62 10 6C 00 A5 8F 64 00 BF 8F FF FF 10 24 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 08 00 63 8E FF FF 63 24 ?? ?? ?? 0? 04 00 63 AE 24 00 79 8E 0C 00 64 8E 02 00 06 24 09 F8 20 03 14 00 67 26 ?? ?? ?? 0? 21 80 40 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 ?? ?? ?? 0? 00 00 43 8C 24 00 79 8E 0C 00 64 8E 01 00 06 24 09 F8 20 03 14 00 67 26 21 80 40 00 08 00 40 14 18 00 BC 8F ?? ?? ?? 0? 1C 00 62 8E ?? ?? ?? 0? 00 00 44 8C 15 FF 41 04 18 00 BC 8F FF FF 10 24 ?? ?? 91 8F 20 00 A4 8F 3B E8 03 7C 21 88 23 02 ?? ?? ?? 0? 00 00 32 8E 04 00 62 8E 00 00 32 AE FF FF 43 24 04 00 40 14 04 00 63 AE 08 00 63 8E FF FF 63 24 04 00 63 AE 00 00 62 8E 64 00 BF 8F 80 18 03 00 21 10 43 00 00 00 40 AC 60 00 BE 8F 21 10 00 02 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 14 00 63 8E 01 00 02 24 0A 00 62 10 00 00 00 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 87 FF 41 04 64 00 BF 8F ?? ?? ?? 0? FF FF 10 24 ?? ?? ?? 0? 04 00 60 AE ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 7E FF 41 04 64 00 BF 8F ?? ?? ?? 0? FF FF 10 24 28 00 B4 8F 1D FF 00 16 21 20 80 02 ?? ?? ?? 0? 00 00 82 82 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 30 02 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 52 01 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 1A 02 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_263_4_0 {
	meta:
		name = "ftw_startup"
		size = 1316
		refs = "0004 __gnu_local_gp 0088 memset 0090 strlen 00ac malloc 00c4 stpcpy 0184 __libc_errno 01c4 __lxstat 0200 $LC0 0208 __open 0264 __chdir 02b0 free 02c8 __xstat 0348 __fchdir 0370 __tdestroy 0474 $LC5 0508 __getcwd"
	strings:
		$1 = { F8 FE BD 27 ?? ?? 1C 3C ?? ?? 9C 27 00 01 BE AF 21 F0 A0 03 F0 00 B4 AF E4 00 B1 AF 04 01 BF AF FC 00 B7 AF F8 00 B6 AF F4 00 B5 AF EC 00 B3 AF E8 00 B2 AF E0 00 B0 AF 10 00 DC AF 00 00 82 80 21 A0 80 00 FD 00 40 10 18 01 D1 8F 2A 18 07 00 01 00 02 24 0B 10 E3 00 21 98 C0 00 80 30 02 00 0E 00 C3 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 10 00 A3 27 21 20 60 00 21 90 A0 00 21 28 00 00 A8 00 C3 AF B0 00 C2 AF ?? ?? ?? 0? AC 00 C0 AF ?? ?? ?? 0? 21 20 80 02 40 10 02 00 00 10 44 2C 00 10 03 24 0B 10 64 00 21 20 40 00 ?? ?? ?? 0? B8 00 C2 AF 21 80 40 00 FE 00 40 10 B4 00 C2 AF 21 20 40 00 ?? ?? ?? 0? 21 28 80 02 21 18 40 00 01 00 02 26 2B 20 43 00 0E 00 80 10 10 00 DC 8F FF FF 65 80 2F 00 04 24 08 00 A4 10 FF FF 63 24 01 00 63 24 ?? ?? ?? 0? 2B 10 03 02 FF FF 67 80 04 00 E4 14 00 00 00 00 FF FF 63 24 FB FF 62 14 00 00 00 00 2B 10 03 02 00 00 60 A0 0E 00 40 10 C0 00 C0 AF FF FF 64 80 2F 00 02 24 08 00 82 14 FF FF 63 24 01 00 63 24 ?? ?? ?? 0? 23 18 70 00 FF FF 67 80 04 00 E2 10 00 00 00 00 FF FF 63 24 FB FF 70 14 00 00 00 00 23 18 70 00 BC 00 C3 AF C4 00 D1 AF 20 00 40 16 CC 00 D3 AF ?? ?? 02 3C ?? ?? 42 24 04 00 23 32 C8 00 C2 AF 20 00 60 14 D8 00 C0 AF ?? ?? 92 8F 21 A8 00 00 FF FF 13 24 07 00 60 10 18 00 D6 27 BC 00 C2 8F 21 80 02 02 00 00 02 82 87 00 40 10 00 00 00 00 18 00 D6 27 01 00 34 32 03 00 04 24 21 28 00 02 42 00 80 12 21 30 C0 02 ?? ?? ?? 0? 00 00 00 00 43 00 41 04 2C 00 C2 8F 3B E8 03 7C 21 10 43 02 00 00 54 8C ?? ?? ?? 0? FF FF 10 24 ?? ?? 02 3C ?? ?? 42 24 04 00 23 32 C8 00 C2 AF E2 FF 60 10 D8 00 C0 AF ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 01 00 05 3C 21 98 40 00 FF FF 02 24 74 00 62 12 10 00 DC 8F B0 00 C2 8F 02 00 43 2C 8F 00 60 14 FF FF 42 24 ?? ?? 92 8F B0 00 C2 AF 21 A8 00 00 BC 00 C2 8F 86 00 40 18 C4 00 C3 8F 01 00 03 24 89 00 43 10 B4 00 C3 8F FF FF 42 24 21 10 62 00 00 00 54 80 00 00 40 A0 ?? ?? ?? 0? B4 00 C4 8F 21 80 40 00 B4 00 C3 8F BC 00 C2 8F 21 10 62 00 FF FF 54 A0 76 00 00 12 C4 00 C3 8F 3B E8 03 7C 21 10 43 02 00 00 54 8C FF FF 02 24 2B 00 62 16 00 00 00 00 31 00 A0 12 00 00 00 00 ?? ?? ?? 0? 21 20 A0 02 ?? ?? ?? 0? 21 20 A0 02 3B E8 03 7C 21 10 43 02 ?? ?? ?? 0? 00 00 54 AC ?? ?? ?? 0? 00 00 00 00 3F 00 40 04 02 00 02 24 2C 00 C2 8F 00 40 03 24 00 F0 42 30 4A 00 43 10 00 A0 43 38 10 00 02 24 0B 10 03 00 C8 00 C3 8F B4 00 C4 8F CC 00 D9 8F 21 10 62 00 00 00 46 8C 21 28 C0 02 09 F8 20 03 BC 00 C7 27 3B E8 03 7C 21 20 43 02 00 00 94 8C 21 80 40 00 10 00 31 32 05 00 20 12 FF FF 02 24 FE FF 02 26 02 00 42 2C 0B 80 02 00 FF FF 02 24 D7 FF 62 12 00 00 00 00 ?? ?? ?? 0? 21 20 60 02 21 20 60 02 A6 0F 02 24 0C 00 00 00 3B E8 03 7C 21 10 43 02 00 00 54 AC D8 00 C4 8F ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? B4 00 C4 8F 3B E8 03 7C 21 90 43 02 00 00 54 AE 21 10 00 02 21 E8 C0 03 04 01 BF 8F 00 01 BE 8F FC 00 B7 8F F8 00 B6 8F F4 00 B5 8F F0 00 B4 8F EC 00 B3 8F E8 00 B2 8F E4 00 B1 8F E0 00 B0 8F 08 00 E0 03 08 01 BD 27 ?? ?? 10 3C ?? ?? ?? 0? ?? ?? 10 26 3B E8 03 7C 21 B8 43 02 00 00 F4 8E 37 00 82 12 03 00 04 24 ?? ?? ?? 0? FF FF 10 24 ?? ?? 92 8F 3B E8 03 7C 0D 00 02 24 21 80 43 02 00 00 14 8E 40 00 82 12 00 00 00 00 ?? ?? ?? 0? 21 80 00 00 18 00 C2 8F D4 00 C0 AF 1B 00 80 12 D0 00 C2 AF A8 00 D4 27 21 20 80 02 21 28 C0 02 ?? ?? ?? 0? 21 30 00 00 ?? ?? ?? 0? 00 00 00 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 02 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 B4 00 D0 8F ?? ?? ?? 0? 04 00 63 30 ?? ?? 92 8F ?? ?? ?? 0? 21 A8 00 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? ?? 0? 21 80 40 00 A8 00 D4 27 21 20 80 02 21 28 C0 02 ?? ?? ?? 0? 28 00 C6 27 E1 FF 40 10 21 80 40 00 3B E8 03 7C 21 10 43 02 ?? ?? ?? 0? 00 00 54 8C ?? ?? ?? 0? FF FF 02 24 21 28 00 02 ?? ?? ?? 0? 21 30 C0 02 42 FF 40 14 2C 00 C3 8F 00 A0 02 34 00 F0 63 30 3E FF 62 14 C8 00 C2 8F B4 00 C4 8F CC 00 D9 8F 18 00 46 8C 21 28 C0 02 09 F8 20 03 BC 00 C7 27 21 80 40 00 ?? ?? ?? 0? 00 00 F4 8E 21 20 00 00 ?? ?? ?? 0? 21 28 00 00 4A FF 40 14 21 A8 40 00 00 00 14 8E ?? ?? ?? 0? 21 80 00 00 }
	condition:
		$1
}

rule file_263_5_0 {
	meta:
		name = "ftw"
		size = 44
		altNames = "ftw64"
	strings:
		$1 = { D8 FF BD 27 21 10 A0 00 21 38 C0 00 10 00 A0 AF 21 28 00 00 24 00 BF AF ?? ?? ?? 0? 21 30 40 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_263_6_0 {
	meta:
		name = "__new_nftw"
		size = 104
		refs = "0000 __gnu_local_gp 0050 __libc_errno"
		altNames = "__new_nftw64"
	strings:
		$1 = { ?? ?? 1C 3C E0 FF 02 24 D8 FF BD 27 ?? ?? 9C 27 24 10 E2 00 24 00 BF AF 0B 00 40 14 18 00 BC AF 21 40 A0 00 21 18 C0 00 10 00 A7 AF 01 00 05 24 21 30 00 01 ?? ?? ?? 0? 21 38 60 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "pmap_getmaps"
		size = 340
		refs = "0000 __gnu_local_gp 0038 __get_socket 0068 clnttcp_create 007c xdr_pmaplist 0098 xdr_void 0100 __libc_errno 00c4 _libc_intl_domainname 012c $LC0 0138 __dcgettext 0144 clnt_perror"
	strings:
		$1 = { ?? ?? 1C 3C B8 FF BD 27 ?? ?? 9C 27 00 6F 02 24 20 00 BC AF 44 00 BF AF 40 00 B2 AF 3C 00 B1 AF 38 00 B0 AF 02 00 82 A4 3C 00 02 24 21 88 80 00 34 00 A0 AF 28 00 A2 AF ?? ?? ?? 0? 2C 00 A0 AF 21 90 40 00 32 00 02 24 10 00 A2 AF 01 00 05 3C F4 01 02 24 14 00 A2 AF 21 20 20 02 A0 86 A5 34 02 00 06 24 30 00 A7 27 ?? ?? ?? 0? 30 00 B2 AF 21 80 40 00 19 00 40 10 20 00 BC 8F ?? ?? 03 3C ?? ?? 63 24 04 00 42 8C 10 00 A3 AF 34 00 A3 27 14 00 A3 AF 28 00 A3 8F ?? ?? 06 3C 21 20 00 02 18 00 A3 AF 2C 00 A3 8F 04 00 05 24 ?? ?? C6 24 1C 00 A3 AF 00 00 59 8C 09 F8 20 03 21 38 00 00 1A 00 40 14 ?? ?? 04 3C 04 00 02 8E 10 00 59 8C 09 F8 20 03 21 20 00 02 20 00 BC 8F FF FF 02 24 0A 00 42 12 30 00 A4 8F A6 0F 02 24 0C 00 00 00 07 00 E0 10 44 00 BF 8F 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC 44 00 BF 8F 34 00 A2 8F 02 00 20 A6 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 48 00 BD 27 ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 21 28 40 00 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 04 00 02 8E }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "fputws_unlocked"
		size = 140
		refs = "0018 __wcslen 0028 _IO_fwide"
	strings:
		$1 = { D8 FF BD 27 18 00 B0 AF 21 80 A0 00 24 00 BF AF 20 00 B2 AF 1C 00 B1 AF ?? ?? ?? 0? 21 90 80 00 21 20 00 02 01 00 05 24 ?? ?? ?? 0? 21 88 40 00 01 00 03 24 0E 00 43 14 21 20 00 02 98 00 02 8E 21 28 40 02 1C 00 59 8C 09 F8 20 03 21 30 20 02 07 00 51 14 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 01 00 02 24 08 00 E0 03 28 00 BD 27 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F FF FF 02 24 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_266_1_0 {
	meta:
		name = "updwtmp_file"
		size = 628
		refs = "0000 __gnu_local_gp 0050 __libc_errno 0090 alarm 00b0 memset 00c4 __sigaction 0108 __fcntl_nocancel 0128 __lseek64 0144 __moddi3 0194 __ftruncate64"
	strings:
		$1 = { ?? ?? 1C 3C 78 FE BD 27 ?? ?? 9C 27 78 01 B4 AF 84 01 BF AF 21 A0 A0 00 80 01 B6 AF 7C 01 B5 AF 74 01 B3 AF 70 01 B2 AF 6C 01 B1 AF 68 01 B0 AF 18 00 BC AF 01 20 05 24 A5 0F 02 24 0C 00 00 00 11 00 E0 10 21 80 40 00 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F FF FF 02 24 21 20 64 00 00 00 90 AC 84 01 BF 8F 80 01 B6 8F 7C 01 B5 8F 78 01 B4 8F 74 01 B3 8F 70 01 B2 8F 6C 01 B1 8F 68 01 B0 8F 08 00 E0 03 88 01 BD 27 F5 FF 00 06 FF FF 02 24 ?? ?? ?? 0? 21 20 00 00 21 90 40 00 ?? ?? 02 3C B8 00 A4 27 21 28 00 00 80 00 06 24 ?? ?? 42 24 ?? ?? ?? 0? B4 00 A2 AF B0 00 A5 27 20 00 A6 27 0E 00 04 24 ?? ?? ?? 0? B0 00 A0 AF ?? ?? ?? 0? 0A 00 04 24 01 00 02 24 21 20 00 02 07 00 05 24 40 01 A6 27 40 01 A0 AF 44 01 A0 AF 48 01 A0 AF 4C 01 A0 AF 50 01 A0 AF 54 01 A0 AF 58 01 A0 AF 5C 01 A0 AF 60 01 A0 AF ?? ?? ?? 0? 40 01 A2 A7 28 00 40 04 FF FF 11 24 02 00 16 24 21 20 00 02 21 30 00 00 21 38 00 00 ?? ?? ?? 0? 10 00 B6 AF 21 20 40 00 21 28 60 00 80 01 06 24 21 38 00 00 21 98 40 00 ?? ?? ?? 0? 21 A8 60 00 25 20 62 00 36 00 80 14 18 00 BC 8F 21 20 00 02 21 28 80 02 80 01 06 24 A4 0F 02 24 0C 00 00 00 2B 00 E0 10 80 01 03 24 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC 21 20 00 02 21 30 60 02 21 38 A0 02 ?? ?? ?? 0? FF FF 11 24 02 00 02 24 21 20 00 02 07 00 05 24 40 01 A6 27 ?? ?? ?? 0? 40 01 A2 A7 ?? ?? ?? 0? 21 20 00 00 0E 00 04 24 20 00 A5 27 ?? ?? ?? 0? 21 30 00 00 0F 00 40 16 00 00 00 00 21 20 00 02 A6 0F 02 24 0C 00 00 00 84 01 BF 8F 21 10 20 02 80 01 B6 8F 7C 01 B5 8F 78 01 B4 8F 74 01 B3 8F 70 01 B2 8F 6C 01 B1 8F 68 01 B0 8F 08 00 E0 03 88 01 BD 27 ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? 21 20 00 02 DF FF 43 10 21 88 00 00 ?? ?? ?? 0? 21 20 00 02 23 10 62 02 2B 98 62 02 23 A8 A3 02 23 A8 B3 02 21 20 00 02 21 30 40 00 21 38 A0 02 ?? ?? ?? 0? 21 98 40 00 10 00 B6 AF 21 20 00 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 BC FF 61 04 18 00 BC 8F ?? ?? ?? 0? 02 00 02 24 }
	condition:
		$1
}

rule file_266_2_0 {
	meta:
		name = "setutent_file"
		size = 612
		refs = "0010 __gnu_local_gp 0040 __lseek64 0090 __libc_utmp_file_name 0098 $LC2 00a0 strcmp 00bc $LC3 00d4 $LC1 00ec $LC0 0124 __libc_errno 0170 __have_o_cloexec 0184 __fcntl_nocancel 01e4 __access"
	strings:
		$1 = { C0 FF BD 27 24 00 B0 AF ?? ?? 10 3C ?? ?? 04 8E ?? ?? 1C 3C ?? ?? 9C 27 3C 00 BF AF 38 00 B5 AF 34 00 B4 AF 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 17 00 80 04 18 00 BC AF 10 00 A0 AF 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 ?? ?? 02 3C 21 20 00 00 21 28 00 00 ?? ?? 44 AC ?? ?? 45 AC FF FF 03 24 ?? ?? 02 3C ?? ?? 43 A4 01 00 02 24 3C 00 BF 8F 38 00 B5 8F 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? 12 3C ?? ?? 51 8E ?? ?? 13 3C ?? ?? 65 26 ?? ?? ?? 0? 21 20 20 02 4C 00 40 10 00 00 00 00 ?? ?? 14 3C 21 20 20 02 ?? ?? ?? 0? ?? ?? 85 26 4F 00 40 10 00 00 00 00 ?? ?? 15 3C 21 20 20 02 ?? ?? ?? 0? ?? ?? A5 26 52 00 40 10 00 00 00 00 ?? ?? 13 3C 21 20 20 02 ?? ?? ?? 0? ?? ?? 65 26 18 00 BC 8F 53 00 40 10 21 20 20 02 ?? ?? 02 3C 08 00 05 3C ?? ?? 40 A0 00 20 A5 24 A5 0F 02 24 0C 00 00 00 12 00 E0 10 21 28 40 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 3C 00 BF 8F 38 00 B5 8F 21 10 62 00 00 00 45 AC FF FF 02 24 ?? ?? 02 AE 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 21 10 00 00 08 00 E0 03 40 00 BD 27 FF FF 12 24 ?? ?? 02 AE C0 FF B2 10 21 10 00 00 ?? ?? 11 3C ?? ?? 22 8E AF FF 40 1C 21 20 A0 00 01 00 05 24 ?? ?? ?? 0? 21 30 00 00 0C 00 40 04 ?? ?? 23 8E 05 00 60 14 00 00 00 00 01 00 44 30 01 00 03 24 0A 18 44 02 ?? ?? 23 AE A2 FF 61 04 ?? ?? 04 8E 01 00 46 34 ?? ?? ?? 0? 02 00 05 24 FF FF 03 24 9C FF 43 14 ?? ?? 04 8E A6 0F 02 24 0C 00 00 00 ?? ?? ?? 0? 21 10 00 00 ?? ?? 11 3C ?? ?? 24 26 ?? ?? ?? 0? 21 28 00 00 18 00 BC 8F C2 FF 40 10 ?? ?? 24 26 ?? ?? ?? 0? ?? ?? 51 8E ?? ?? 11 3C ?? ?? 24 26 ?? ?? ?? 0? 21 28 00 00 18 00 BC 8F B9 FF 40 10 ?? ?? 24 26 ?? ?? ?? 0? ?? ?? 51 8E ?? ?? A4 26 ?? ?? ?? 0? 21 28 00 00 18 00 BC 8F B1 FF 40 14 ?? ?? 64 26 ?? ?? ?? 0? ?? ?? 51 8E ?? ?? 64 26 ?? ?? ?? 0? 21 28 00 00 ?? ?? 43 8E ?? ?? 84 26 18 00 BC 8F ?? ?? ?? 0? 0A 20 62 00 }
	condition:
		$1
}

rule file_266_3_0 {
	meta:
		name = "__utmp_equal"
		size = 148
		refs = "0058 strncmp"
	strings:
		$1 = { 00 00 83 94 FB FF 63 24 FF FF 63 30 04 00 63 2C 16 00 60 10 21 10 00 00 00 00 A3 94 FB FF 63 24 FF FF 63 30 04 00 63 2C 10 00 60 10 00 00 00 00 E0 FF BD 27 1C 00 BF AF 28 00 82 80 0D 00 40 10 00 00 00 00 28 00 A2 80 0A 00 40 10 00 00 00 00 28 00 84 24 28 00 A5 24 ?? ?? ?? 0? 04 00 06 24 01 00 42 2C 1C 00 BF 8F 20 00 BD 27 08 00 E0 03 00 00 00 00 08 00 84 24 08 00 A5 24 ?? ?? ?? 0? 20 00 06 24 01 00 42 2C 1C 00 BF 8F ?? ?? ?? 0? 20 00 BD 27 }
	condition:
		$1
}

rule file_266_4_0 {
	meta:
		name = "getutline_r_file"
		size = 672
		refs = "0010 __gnu_local_gp 0060 alarm 0080 memset 0094 __sigaction 00d0 __fcntl_nocancel 011c __libc_errno 01f0 strncmp 0280 $LC4 0284 $LC5 0298 __assert_fail 0288 __PRETTY_FUNCTION__.9086"
	strings:
		$1 = { 78 FE BD 27 64 01 B1 AF ?? ?? 11 3C ?? ?? 22 8E ?? ?? 1C 3C ?? ?? 9C 27 84 01 BF AF 80 01 BE AF 7C 01 B7 AF 78 01 B6 AF 74 01 B5 AF 70 01 B4 AF 6C 01 B3 AF 68 01 B2 AF 60 01 B0 AF 10 00 BC AF 8F 00 40 04 8C 01 A5 AF ?? ?? 10 3C ?? ?? 02 8E FF FF 03 24 21 A8 80 00 84 00 43 10 21 B0 C0 00 ?? ?? ?? 0? 21 20 00 00 21 B8 40 00 ?? ?? 02 3C B0 00 A4 27 21 28 00 00 80 00 06 24 ?? ?? 42 24 ?? ?? ?? 0? AC 00 A2 AF A8 00 A5 27 18 00 A6 27 0E 00 04 24 ?? ?? ?? 0? A8 00 A0 AF ?? ?? ?? 0? 0A 00 04 24 ?? ?? 24 8E 07 00 05 24 38 01 A6 27 38 01 A0 AF 3C 01 A0 AF 40 01 A0 AF 44 01 A0 AF 48 01 A0 AF 4C 01 A0 AF 50 01 A0 AF 54 01 A0 AF ?? ?? ?? 0? 58 01 A0 AF 62 00 40 04 10 00 BC 8F ?? ?? 12 3C ?? ?? 5E 26 ?? ?? 14 3C 21 98 C0 03 08 00 B5 26 ?? ?? 94 26 ?? ?? 24 8E 21 28 60 02 80 01 06 24 A3 0F 02 24 0C 00 00 00 29 00 E0 10 80 01 03 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 03 00 03 24 00 00 43 AC FF FF 02 24 FF FF 03 24 ?? ?? 02 AE ?? ?? 03 AE 00 00 C0 AE ?? ?? 24 8E 02 00 02 24 07 00 05 24 38 01 A6 27 ?? ?? ?? 0? 38 01 A2 A7 ?? ?? ?? 0? 21 20 00 00 0E 00 04 24 18 00 A5 27 ?? ?? ?? 0? 21 30 00 00 38 00 E0 16 00 00 00 00 00 00 C2 8E 01 00 42 2C 23 10 02 00 84 01 BF 8F 80 01 BE 8F 7C 01 B7 8F 78 01 B6 8F 74 01 B5 8F 70 01 B4 8F 6C 01 B3 8F 68 01 B2 8F 64 01 B1 8F 60 01 B0 8F 08 00 E0 03 88 01 BD 27 D7 FF 43 14 ?? ?? 03 8E ?? ?? 44 96 ?? ?? 05 8E 80 01 62 24 FA FF 84 24 2B 18 43 00 FF FF 84 30 21 18 65 00 02 00 84 2C ?? ?? 02 AE C5 FF 80 10 ?? ?? 03 AE 21 20 A0 02 21 28 80 02 ?? ?? ?? 0? 20 00 06 24 BF FF 40 14 10 00 BC 8F 8C 01 A2 8F 21 18 C0 03 80 01 C8 27 00 00 67 8C 04 00 66 8C 08 00 65 8C 0C 00 64 8C 03 00 47 A8 00 00 47 B8 07 00 46 A8 04 00 46 B8 0B 00 45 A8 08 00 45 B8 0F 00 44 A8 10 00 63 24 0C 00 44 B8 F2 FF 68 14 10 00 42 24 8C 01 A2 8F ?? ?? ?? 0? 00 00 C2 AE ?? ?? ?? 0? 21 20 E0 02 ?? ?? ?? 0? 00 00 C2 8E ?? ?? ?? 0? 00 00 C0 AE ?? ?? 03 8E 7B FF 62 14 FF FF 02 24 ?? ?? ?? 0? 00 00 C0 AC ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 59 01 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_266_5_0 {
	meta:
		name = "getutent_r_file"
		size = 624
		refs = "0010 __gnu_local_gp 0050 alarm 0070 memset 0084 __sigaction 00c0 __fcntl_nocancel 01cc __libc_errno 0250 $LC4 0254 $LC5 0268 __assert_fail 0258 __PRETTY_FUNCTION__.9017"
	strings:
		$1 = { 80 FE BD 27 68 01 B1 AF ?? ?? 11 3C ?? ?? 22 8E ?? ?? 1C 3C ?? ?? 9C 27 7C 01 BF AF 78 01 B5 AF 74 01 B4 AF 70 01 B3 AF 6C 01 B2 AF 64 01 B0 AF 87 00 40 04 10 00 BC AF ?? ?? 10 3C ?? ?? 02 8E FF FF 03 24 21 A0 80 00 7C 00 43 10 21 98 A0 00 ?? ?? ?? 0? 21 20 00 00 21 A8 40 00 ?? ?? 02 3C B0 00 A4 27 21 28 00 00 80 00 06 24 ?? ?? 42 24 ?? ?? ?? 0? AC 00 A2 AF A8 00 A5 27 18 00 A6 27 0E 00 04 24 ?? ?? ?? 0? A8 00 A0 AF ?? ?? ?? 0? 0A 00 04 24 ?? ?? 24 8E 07 00 05 24 38 01 A6 27 38 01 A0 AF 3C 01 A0 AF 40 01 A0 AF 44 01 A0 AF 48 01 A0 AF 4C 01 A0 AF 50 01 A0 AF 54 01 A0 AF ?? ?? ?? 0? 58 01 A0 AF 5A 00 40 04 10 00 BC 8F ?? ?? 02 3C ?? ?? 05 3C ?? ?? 44 8C ?? ?? A5 24 80 01 06 24 A3 0F 02 24 0C 00 00 00 35 00 E0 14 21 90 40 00 ?? ?? 24 8E 02 00 02 24 07 00 05 24 38 01 A6 27 ?? ?? ?? 0? 38 01 A2 A7 ?? ?? ?? 0? 21 20 00 00 0E 00 04 24 18 00 A5 27 ?? ?? ?? 0? 21 30 00 00 2E 00 A0 16 80 01 02 24 31 00 42 16 ?? ?? 03 8E ?? ?? 04 8E 80 01 62 24 2B 18 43 00 21 20 64 00 ?? ?? 03 3C ?? ?? 63 24 ?? ?? 02 AE ?? ?? 04 AE 21 10 80 02 80 01 68 24 00 00 67 8C 04 00 66 8C 08 00 65 8C 0C 00 64 8C 03 00 47 A8 00 00 47 B8 07 00 46 A8 04 00 46 B8 0B 00 45 A8 08 00 45 B8 0F 00 44 A8 10 00 63 24 0C 00 44 B8 F2 FF 68 14 10 00 42 24 7C 01 BF 8F 00 00 74 AE 78 01 B5 8F 74 01 B4 8F 70 01 B3 8F 6C 01 B2 8F 68 01 B1 8F 64 01 B0 8F 21 10 00 00 08 00 E0 03 80 01 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 52 AC ?? ?? ?? 0? FF FF 12 24 ?? ?? ?? 0? 21 20 A0 02 80 01 02 24 D1 FF 42 12 ?? ?? 03 8E 04 00 40 12 FF FF 02 24 FF FF 03 24 ?? ?? 02 AE ?? ?? 03 AE 00 00 60 AE FF FF 02 24 7C 01 BF 8F 78 01 B5 8F 74 01 B4 8F 70 01 B3 8F 6C 01 B2 8F 68 01 B1 8F 64 01 B0 8F 08 00 E0 03 80 01 BD 27 ?? ?? ?? 0? 21 90 00 00 ?? ?? 03 8E 83 FF 62 14 FF FF 02 24 ?? ?? ?? 0? 00 00 60 AE ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 CC 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_266_6_0 {
	meta:
		name = "endutent_file"
		size = 72
		refs = "0024 $LC4 0028 $LC5 0040 __assert_fail 000c __PRETTY_FUNCTION__.9218"
	strings:
		$1 = { ?? ?? 05 3C ?? ?? A4 8C 06 00 80 04 ?? ?? 07 3C A6 0F 02 24 0C 00 00 00 FF FF 02 24 08 00 E0 03 ?? ?? A2 AC ?? ?? 04 3C ?? ?? 05 3C E0 FF BD 27 ?? ?? 84 24 ?? ?? A5 24 10 02 06 24 1C 00 BF AF ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_266_7_0 {
	meta:
		name = "internal_getut_r.constprop.2"
		size = 536
		refs = "0004 __gnu_local_gp 0034 alarm 0054 memset 006c __sigaction 00a8 __fcntl_nocancel 00f8 __libc_errno"
	strings:
		$1 = { 88 FE BD 27 ?? ?? 1C 3C ?? ?? 9C 27 70 01 B4 AF 21 A0 80 00 21 20 00 00 10 00 BC AF 74 01 BF AF 6C 01 B3 AF 68 01 B2 AF 64 01 B1 AF 60 01 B0 AF 21 88 A0 00 ?? ?? ?? 0? 21 80 C0 00 21 98 40 00 ?? ?? 02 3C B0 00 A4 27 21 28 00 00 80 00 06 24 ?? ?? 42 24 ?? ?? ?? 0? AC 00 A2 AF A8 00 A5 27 18 00 A6 27 0E 00 04 24 A8 00 A0 AF ?? ?? ?? 0? ?? ?? 12 3C ?? ?? ?? 0? 0A 00 04 24 ?? ?? 44 8E 07 00 05 24 38 01 A6 27 38 01 A0 AF 3C 01 A0 AF 40 01 A0 AF 44 01 A0 AF 48 01 A0 AF 4C 01 A0 AF 50 01 A0 AF 54 01 A0 AF ?? ?? ?? 0? 58 01 A0 AF 55 00 40 04 10 00 BC 8F 00 00 82 96 FF FF 42 24 FF FF 42 30 04 00 42 2C 2D 00 40 14 ?? ?? 10 3C ?? ?? 44 8E 21 28 20 02 80 01 06 24 A3 0F 02 24 0C 00 00 00 21 20 20 02 39 00 E0 10 21 28 80 02 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F FF FF 06 24 FF FF 07 24 21 10 62 00 03 00 03 24 ?? ?? 06 AE ?? ?? 07 AE 00 00 43 AC FF FF 10 24 ?? ?? 44 8E 02 00 02 24 07 00 05 24 38 01 A6 27 ?? ?? ?? 0? 38 01 A2 A7 ?? ?? ?? 0? 21 20 00 00 0E 00 04 24 18 00 A5 27 ?? ?? ?? 0? 21 30 00 00 04 00 60 12 74 01 BF 8F ?? ?? ?? 0? 21 20 60 02 74 01 BF 8F 21 10 00 02 70 01 B4 8F 6C 01 B3 8F 68 01 B2 8F 64 01 B1 8F 60 01 B0 8F 08 00 E0 03 78 01 BD 27 ?? ?? 44 8E 21 28 20 02 80 01 06 24 A3 0F 02 24 0C 00 00 00 D6 FF E0 14 80 01 03 24 D4 FF 43 14 ?? ?? 02 8E ?? ?? 04 8E 00 00 87 86 80 01 43 24 00 00 26 86 2B 10 62 00 21 10 44 00 ?? ?? 03 AE EF FF E6 14 ?? ?? 02 AE ?? ?? ?? 0? 21 80 00 00 80 01 03 24 C6 FF 43 14 ?? ?? 03 8E ?? ?? 06 8E 80 01 62 24 2B 18 43 00 21 18 66 00 ?? ?? 02 AE ?? ?? ?? 0? ?? ?? 03 AE B5 FF 40 10 10 00 BC 8F ?? ?? ?? 0? 21 80 00 00 01 00 02 24 00 00 02 A2 ?? ?? ?? 0? FF FF 10 24 }
	condition:
		$1
}

rule file_266_8_0 {
	meta:
		name = "getutid_r_file"
		size = 244
		refs = "00d4 $LC4 00d8 $LC5 00ec __assert_fail 00dc __PRETTY_FUNCTION__.9079"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C D0 FF BD 27 2C 00 BF AF 28 00 B2 AF 24 00 B1 AF 2E 00 40 04 20 00 B0 AF ?? ?? 03 3C ?? ?? 62 8C 21 88 A0 00 FF FF 05 24 22 00 45 10 21 90 C0 00 ?? ?? 10 3C ?? ?? 05 26 18 00 A6 27 ?? ?? ?? 0? 18 00 A0 A3 1E 00 40 04 00 00 00 00 ?? ?? 03 26 21 10 20 02 80 01 65 24 00 00 69 8C 04 00 68 8C 08 00 67 8C 0C 00 64 8C 03 00 49 A8 00 00 49 B8 07 00 48 A8 04 00 48 B8 0B 00 47 A8 08 00 47 B8 0F 00 44 A8 10 00 63 24 0C 00 44 B8 F2 FF 65 14 10 00 42 24 00 00 51 AE 21 10 00 00 2C 00 BF 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? 63 8C DE FF 62 14 ?? ?? 10 3C 00 00 40 AE ?? ?? ?? 0? FF FF 02 24 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 3B 01 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_266_9_0 {
	meta:
		name = "pututline_file"
		size = 1588
		refs = "0010 __gnu_local_gp 0054 __libc_utmp_file_name 005c $LC2 0064 strcmp 0080 $LC3 0098 $LC1 00b0 $LC0 00e0 __libc_errno 012c __have_o_cloexec 0148 __lseek64 0170 __dup2 01ec alarm 020c memset 0220 __sigaction 0268 __fcntl_nocancel 044c __moddi3 047c __access 0598 __ftruncate64 05f4 $LC4 05f8 $LC5 060c __assert_fail 05fc __PRETTY_FUNCTION__.9122"
	strings:
		$1 = { E8 FC BD 27 F0 02 B0 AF ?? ?? 10 3C ?? ?? 02 8E ?? ?? 1C 3C ?? ?? 9C 27 14 03 BF AF 10 03 BE AF 0C 03 B7 AF 08 03 B6 AF 04 03 B5 AF 00 03 B4 AF FC 02 B3 AF F8 02 B2 AF F4 02 B1 AF 6D 01 40 04 18 00 BC AF ?? ?? 11 3C ?? ?? 22 92 50 00 40 14 21 90 80 00 ?? ?? 14 3C ?? ?? 93 8E ?? ?? 15 3C ?? ?? A5 26 ?? ?? ?? 0? 21 20 60 02 01 01 40 10 00 00 00 00 ?? ?? 16 3C 21 20 60 02 ?? ?? ?? 0? ?? ?? C5 26 1A 01 40 10 00 00 00 00 ?? ?? 17 3C 21 20 60 02 ?? ?? ?? 0? ?? ?? E5 26 25 01 40 10 00 00 00 00 ?? ?? 15 3C 21 20 60 02 ?? ?? ?? 0? ?? ?? A5 26 18 00 BC 8F 26 01 40 10 21 20 60 02 08 00 05 3C 02 20 A5 24 A5 0F 02 24 0C 00 00 00 13 00 E0 10 21 98 40 00 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 10 00 00 21 20 64 00 00 00 93 AC 14 03 BF 8F 10 03 BE 8F 0C 03 B7 8F 08 03 B6 8F 04 03 B5 8F 00 03 B4 8F FC 02 B3 8F F8 02 B2 8F F4 02 B1 8F F0 02 B0 8F 08 00 E0 03 18 03 BD 27 FF FF 15 24 F2 FF 75 12 21 10 00 00 ?? ?? 14 3C ?? ?? 82 8E D8 00 40 18 ?? ?? 04 8E 01 00 02 24 21 30 00 00 21 38 00 00 ?? ?? ?? 0? 10 00 A2 AF 21 30 40 00 21 20 60 02 21 38 60 00 ?? ?? ?? 0? 10 00 A0 AF FF FF 04 24 02 01 44 10 ?? ?? 05 8E ?? ?? ?? 0? 21 20 60 02 00 01 40 04 21 20 60 02 A6 0F 02 24 0C 00 00 00 01 00 02 24 ?? ?? 22 A2 ?? ?? 13 3C ?? ?? 62 8E E0 00 40 18 ?? ?? 04 3C ?? ?? 83 84 00 00 42 86 79 00 43 10 FF FF 42 24 ?? ?? 84 24 ?? ?? ?? 0? 21 28 40 02 78 00 40 14 00 00 00 00 A0 01 B4 27 21 20 40 02 20 00 A5 27 21 30 80 02 ?? ?? ?? 0? A0 01 A0 A3 A0 01 A3 93 18 00 BC 8F 0B 01 60 14 21 B0 40 00 ?? ?? ?? 0? 21 20 00 00 21 A8 40 00 ?? ?? 02 3C 38 02 A4 27 21 28 00 00 80 00 06 24 ?? ?? 42 24 ?? ?? ?? 0? 34 02 A2 AF 30 02 A5 27 21 30 80 02 0E 00 04 24 ?? ?? ?? 0? 30 02 A0 AF ?? ?? ?? 0? 0A 00 04 24 ?? ?? 04 8E C0 02 B1 27 C0 02 A0 AF 01 00 02 24 07 00 05 24 21 30 20 02 04 00 20 AE 08 00 20 AE 0C 00 20 AE 10 00 20 AE 14 00 20 AE 18 00 20 AE 1C 00 20 AE 20 00 20 AE ?? ?? ?? 0? C0 02 A2 A7 A8 00 40 04 ?? ?? 17 3C 6A 00 C0 06 ?? ?? E4 8E ?? ?? 62 8E ?? ?? 65 8E ?? ?? 04 8E 80 FE 43 24 2B 10 62 00 FF FF A5 24 21 10 45 00 10 00 A0 AF 21 30 60 00 21 38 40 00 ?? ?? 63 AE ?? ?? ?? 0? ?? ?? 62 AE 18 00 BC 8F ?? ?? 04 8E 21 28 40 02 80 01 06 24 A4 0F 02 24 0C 00 00 00 27 00 E0 10 80 01 03 24 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC A9 00 C0 06 21 90 00 00 ?? ?? 04 8E 02 00 02 24 07 00 05 24 21 30 20 02 ?? ?? ?? 0? C0 02 A2 A7 ?? ?? ?? 0? 21 20 00 00 0E 00 04 24 21 28 80 02 ?? ?? ?? 0? 21 30 00 00 0E 00 A0 16 00 00 00 00 21 10 40 02 14 03 BF 8F 10 03 BE 8F 0C 03 B7 8F 08 03 B6 8F 04 03 B5 8F 00 03 B4 8F FC 02 B3 8F F8 02 B2 8F F4 02 B1 8F F0 02 B0 8F 08 00 E0 03 18 03 BD 27 ?? ?? ?? 0? 21 20 A0 02 ?? ?? ?? 0? 21 10 40 02 DE FF 43 14 ?? ?? 63 8E ?? ?? 64 8E 80 01 62 24 2B 18 43 00 21 18 64 00 ?? ?? 62 AE ?? ?? ?? 0? ?? ?? 63 AE FF FF 42 30 04 00 42 2C 85 FF 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 00 00 21 A8 40 00 ?? ?? 02 3C 38 02 A4 27 21 28 00 00 80 00 06 24 ?? ?? 42 24 A0 01 B4 27 ?? ?? ?? 0? 34 02 A2 AF 30 02 A5 27 21 30 80 02 0E 00 04 24 C0 02 B1 27 ?? ?? ?? 0? 30 02 A0 AF ?? ?? ?? 0? 0A 00 04 24 21 20 20 02 21 28 00 00 ?? ?? ?? 0? 24 00 06 24 ?? ?? 04 8E 01 00 02 24 07 00 05 24 21 30 20 02 ?? ?? ?? 0? C0 02 A2 A7 3F 00 40 04 01 00 16 24 ?? ?? ?? 0? ?? ?? 62 8E 02 00 1E 24 21 30 00 00 21 38 00 00 ?? ?? ?? 0? 10 00 BE AF 21 20 40 00 21 28 60 00 80 01 06 24 21 38 00 00 E8 02 A2 AF ?? ?? ?? 0? EC 02 A3 AF 25 20 62 00 18 00 BC 8F E8 02 A8 8F 51 00 80 14 EC 02 A9 8F ?? ?? 68 AE ?? ?? ?? 0? ?? ?? 69 AE ?? ?? 13 3C ?? ?? 64 26 ?? ?? ?? 0? 21 28 00 00 18 00 BC 8F 0D FF 40 10 ?? ?? 64 26 ?? ?? ?? 0? ?? ?? 93 8E 01 00 05 24 ?? ?? ?? 0? 21 30 00 00 0B 00 40 04 ?? ?? 83 8E 04 00 60 14 01 00 44 30 01 00 03 24 0A 18 A4 02 ?? ?? 83 AE 1E FF 61 04 ?? ?? 04 8E 01 00 46 34 ?? ?? ?? 0? 02 00 05 24 FF FF 03 24 18 FF 43 14 ?? ?? 04 8E A6 0F 02 24 0C 00 00 00 ?? ?? ?? 0? 21 10 00 00 ?? ?? 13 3C ?? ?? 64 26 ?? ?? ?? 0? 21 28 00 00 18 00 BC 8F EE FE 40 10 ?? ?? 64 26 ?? ?? ?? 0? ?? ?? 93 8E ?? ?? ?? 0? 21 90 00 00 29 FF 40 14 ?? ?? 62 8E 1E FF 40 14 ?? ?? 04 3C ?? ?? ?? 0? A0 01 B4 27 ?? ?? E4 26 ?? ?? ?? 0? 21 28 00 00 18 00 BC 8F DE FE 40 14 ?? ?? A4 26 ?? ?? ?? 0? ?? ?? 93 8E ?? ?? A4 26 ?? ?? ?? 0? 21 28 00 00 ?? ?? 83 8E ?? ?? C4 26 18 00 BC 8F ?? ?? ?? 0? 0A 20 62 00 FE FE 62 14 00 00 00 00 21 20 60 02 A6 0F 02 24 0C 00 00 00 ?? ?? ?? 0? 21 10 00 00 ?? ?? 04 8E ?? ?? 66 8E ?? ?? ?? 0? ?? ?? 67 8E ?? ?? ?? 0? ?? ?? 04 8E 23 10 02 01 2B 40 02 01 23 18 23 01 ?? ?? E4 8E 23 18 68 00 21 38 60 00 21 30 40 00 ?? ?? 63 AE ?? ?? ?? 0? ?? ?? 62 AE ?? ?? E4 8E 10 00 BE AF 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 34 FF 61 04 18 00 BC 8F ?? ?? ?? 0? 21 90 00 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 90 01 06 24 ?? ?? ?? 0? ?? ?? E7 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 0B 00 03 24 00 00 43 AC ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_267_0_0 {
	meta:
		name = "cfsetspeed"
		size = 232
		refs = "0004 __gnu_local_gp 0060 __libc_errno 0088 cfsetispeed 0094 cfsetospeed"
	strings:
		$1 = { D8 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 18 00 B0 AF ?? ?? 02 3C 21 80 A0 00 ?? ?? 05 3C 20 00 B2 AF 24 00 BF AF 1C 00 B1 AF 10 00 BC AF 21 90 80 00 ?? ?? 42 24 ?? ?? A5 24 00 00 51 8C 12 00 30 12 21 20 40 02 FC FF 43 8C 1B 00 70 10 08 00 42 24 F9 FF 45 14 24 00 BF 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 20 00 B2 8F 21 10 62 00 16 00 03 24 00 00 43 AC 1C 00 B1 8F 18 00 B0 8F FF FF 02 24 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 21 28 00 02 21 20 40 02 ?? ?? ?? 0? 21 28 00 02 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 21 10 00 00 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 21 28 20 02 21 20 40 02 ?? ?? ?? 0? 21 28 20 02 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 21 10 00 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "strcpy"
		size = 36
	strings:
		$1 = { 21 10 80 00 23 38 85 00 01 00 A5 24 FF FF A3 80 21 30 A7 00 FC FF 60 14 FF FF C3 A0 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_269_0_0 {
	meta:
		name = "_IO_fflush"
		size = 432
		refs = "006c __lll_lock_wait_private 0128 _IO_flush_all 015c _Unwind_Resume"
	strings:
		$1 = { D0 FF BD 27 24 00 B0 AF 2C 00 BF AF 28 00 B1 AF 45 00 80 10 21 80 80 00 00 00 82 8C 00 80 42 30 1A 00 40 14 00 00 00 00 3B E8 03 7C 48 00 84 8C 70 8B 71 24 08 00 82 8C 11 00 51 10 00 00 00 00 18 00 A0 AF 00 00 83 C0 06 00 60 14 00 00 02 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 02 24 0F 00 00 00 03 00 40 14 00 00 00 00 ?? ?? ?? 0? 18 00 A3 AF 48 00 02 8E 21 20 40 00 08 00 51 AC 04 00 82 8C 01 00 42 24 04 00 82 AC 98 00 02 8E 30 00 59 8C 09 F8 20 03 21 20 00 02 00 00 03 8E 2B 10 02 00 00 80 63 30 06 00 60 14 23 88 02 00 48 00 04 8E 04 00 82 8C FF FF 42 24 07 00 40 10 04 00 82 AC 2C 00 BF 8F 21 10 20 02 24 00 B0 8F 28 00 B1 8F 08 00 E0 03 30 00 BD 27 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 F1 FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 2C 00 BF 8F ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 88 40 00 00 00 02 8E 00 80 42 30 06 00 40 14 21 88 80 00 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_270_0_0 {
	meta:
		name = "__setgid"
		size = 112
		refs = "0000 __gnu_local_gp 0004 __nptl_setxid 005c __libc_errno"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 02 3C C8 FF BD 27 ?? ?? 9C 27 ?? ?? 42 24 34 00 BF AF 0A 00 40 10 10 00 BC AF 21 18 80 00 CE 0F 02 24 18 00 A4 27 18 00 A2 AF ?? ?? ?? 0? 1C 00 A3 AF 34 00 BF 8F 08 00 E0 03 38 00 BD 27 CE 0F 02 24 0C 00 00 00 FB FF E0 10 34 00 BF 8F 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "msort_with_tmp.part.0"
		size = 828
		refs = "0188 memcpy 0208 mempcpy"
	strings:
		$1 = { 00 00 87 8C B8 FF BD 27 20 00 B0 AF 42 80 06 00 02 18 07 72 02 00 02 2E 3C 00 B7 AF 38 00 B6 AF 34 00 B5 AF 44 00 BF AF 40 00 BE AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF 21 A8 80 00 1C 00 A6 AF 18 00 A5 AF 23 B8 D0 00 03 00 40 14 21 B0 65 00 ?? ?? ?? 0? 21 30 00 02 02 00 E2 2E 04 00 40 14 21 20 A0 02 21 28 C0 02 ?? ?? ?? 0? 21 30 E0 02 04 00 A2 8E 01 00 03 24 10 00 BE 8E 00 00 B4 8E 08 00 B2 8E 80 00 43 10 0C 00 B3 8E 64 00 40 10 02 00 03 24 1D 00 43 10 03 00 03 24 4C 00 43 14 00 00 00 00 3A 00 00 12 21 28 C0 03 0B 00 E0 16 18 00 B1 8F ?? ?? ?? 0? 02 30 14 72 00 00 C2 8E FF FF F7 26 04 00 D6 26 00 00 C2 AF 2F 00 00 12 04 00 DE 27 29 00 E0 12 02 30 14 72 00 00 24 8E 00 00 C5 8E 21 C8 40 02 09 F8 20 03 21 30 60 02 F2 FF 40 1C 00 00 00 00 00 00 22 8E FF FF 10 26 04 00 31 26 ?? ?? ?? 0? 00 00 C2 AF 20 00 00 12 21 28 C0 03 18 00 E0 12 18 00 B1 8F 21 28 C0 02 21 20 20 02 21 C8 40 02 09 F8 20 03 21 30 60 02 73 00 40 18 21 28 D4 03 21 10 C0 02 FF FF F7 26 21 B0 D4 02 2B 18 C5 03 07 00 60 10 00 00 00 00 04 00 42 24 FC FF 44 8C 04 00 DE 27 2B 18 C5 03 FB FF 60 14 FC FF C4 AF 08 00 00 12 00 00 00 00 EA FF E0 16 21 F0 A0 00 02 30 14 72 21 20 C0 03 21 28 20 02 ?? ?? ?? 0? 21 B8 00 00 10 00 A5 8E 1C 00 A3 8F 18 00 A4 8F 44 00 BF 8F 23 30 77 00 02 30 D4 70 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F ?? ?? ?? 0? 48 00 BD 27 EF FF 00 12 21 28 C0 03 E7 FF E0 12 18 00 B1 8F 21 20 20 02 21 28 C0 02 21 C8 40 02 09 F8 20 03 21 30 60 02 21 20 C0 03 21 28 C0 02 44 00 40 18 21 30 80 02 ?? ?? ?? 0? FF FF F7 26 21 F0 40 00 F3 FF E0 16 21 B0 D4 02 ?? ?? ?? 0? 02 30 14 72 DB FF 00 12 21 28 C0 03 0B 00 E0 16 18 00 B1 8F ?? ?? ?? 0? 02 30 14 72 00 00 C2 8E FF FF F7 26 04 00 D6 26 00 00 C2 AF D0 FF 00 12 04 00 DE 27 CA FF E0 12 02 30 14 72 21 20 20 02 21 28 C0 02 21 C8 40 02 09 F8 20 03 21 30 60 02 F2 FF 40 1C 00 00 00 00 00 00 22 8E FF FF 10 26 04 00 31 26 ?? ?? ?? 0? 00 00 C2 AF C1 FF 00 12 21 28 C0 03 0D 00 E0 16 18 00 B1 8F ?? ?? ?? 0? 02 30 14 72 00 00 C8 8E 04 00 C9 8E FF FF F7 26 08 00 D6 26 00 00 C8 AF 04 00 C9 AF B4 FF 00 12 08 00 DE 27 AE FF E0 12 02 30 14 72 21 20 20 02 21 28 C0 02 21 C8 40 02 09 F8 20 03 21 30 60 02 F0 FF 40 1C 00 00 00 00 00 00 28 8E 04 00 29 8E FF FF 10 26 08 00 31 26 00 00 C8 AF ?? ?? ?? 0? 04 00 C9 AF 21 10 20 02 FF FF 10 26 ?? ?? ?? 0? 21 88 34 02 ?? ?? ?? 0? 21 28 20 02 FF FF 10 26 21 F0 40 00 9A FF 00 12 21 88 34 02 AE FF E0 16 21 20 20 02 ?? ?? ?? 0? 02 30 14 72 }
	condition:
		$1
}

rule file_271_1_0 {
	meta:
		name = "qsort_r"
		size = 916
		refs = "0004 __gnu_local_gp 0094 __libc_errno 00a0 malloc 015c memcpy 01d8 free 02d4 _quicksort 0310 __sysconf"
	strings:
		$1 = { 98 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 60 00 BE AF 44 00 B1 AF 21 F0 A0 03 21 00 D1 2C 5C 00 B7 AF 4C 00 B3 AF 48 00 B2 AF 64 00 BF AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 40 00 B0 AF 18 00 DC AF 21 B8 C0 00 21 98 80 00 6C 00 C5 AF 71 00 20 12 21 90 E0 00 02 80 A6 70 00 04 02 2E 74 00 40 14 0E 00 02 26 ?? ?? 14 3C ?? ?? 82 8E A8 00 40 10 ?? ?? 15 3C 1B 00 02 02 F4 01 40 00 ?? ?? A3 8E 12 10 00 00 2B 10 62 00 8E 00 40 14 78 00 C2 8F 21 20 00 02 ?? ?? 90 8F 3B E8 03 7C 21 80 03 02 ?? ?? ?? 0? 00 00 14 8E 38 00 C2 AF 84 00 40 10 00 00 14 AE 78 00 C3 8F 30 00 C2 AF 04 00 02 24 20 00 D7 AF 24 00 C2 AF 28 00 D2 AF 65 00 20 16 2C 00 C3 AF 6C 00 C2 8F 30 00 D1 8F 80 28 02 00 21 88 25 02 21 A8 25 02 2B 10 35 02 A5 00 40 10 21 10 20 02 21 18 60 02 04 00 42 24 2B 20 55 00 FC FF 43 AC FC FF 80 14 21 18 77 00 30 00 C2 8F 21 28 45 00 6C 00 C3 8F 02 00 62 2C 04 00 03 24 20 00 C3 AF 03 00 03 24 89 00 40 14 24 00 C3 AF 6C 00 C6 8F ?? ?? ?? 0? 20 00 C4 27 21 90 60 02 21 A0 00 00 80 10 14 00 21 10 22 02 00 00 50 8C 1D 00 12 12 21 20 A0 02 21 30 E0 02 ?? ?? ?? 0? 21 28 40 02 21 20 40 02 ?? ?? ?? 0? 21 30 80 02 21 80 40 00 23 18 13 02 1B 00 77 00 F4 01 E0 02 80 30 06 00 21 30 26 02 00 00 C4 AC 21 28 00 02 21 30 E0 02 ?? ?? ?? 0? 12 B0 00 00 80 28 16 00 21 28 25 02 00 00 A2 8C 21 20 00 02 F0 FF 52 14 21 30 C0 02 00 00 B0 AC 21 20 00 02 21 28 A0 02 ?? ?? ?? 0? 21 30 E0 02 6C 00 C2 8F 01 00 94 26 DC FF 82 16 21 90 57 02 ?? ?? ?? 0? 38 00 C4 8F 21 E8 C0 03 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 6C 00 C2 8F C0 80 02 00 21 80 06 02 00 04 02 2E 90 FF 40 10 ?? ?? 14 3C 0E 00 02 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 78 00 C3 8F 18 00 A2 27 30 00 C2 AF 04 00 02 24 38 00 C0 AF 20 00 D7 AF 24 00 C2 AF 28 00 D2 AF 9D FF 20 12 2C 00 C3 AF 03 00 E3 32 0B 00 60 14 6C 00 C3 8F 03 00 63 32 07 00 60 14 00 00 00 00 43 00 E2 12 08 00 02 24 3A 00 E2 12 07 00 62 32 02 00 02 24 24 00 C2 AF 6C 00 C3 8F 02 00 62 2C CE FF 40 14 20 00 C4 27 21 28 60 02 ?? ?? ?? 0? 21 30 60 00 ?? ?? ?? 0? 38 00 C4 8F ?? ?? ?? 0? 21 E8 C0 03 78 00 C2 8F 6C 00 C5 8F 21 20 60 02 10 00 A2 AF 21 30 E0 02 ?? ?? ?? 0? 21 38 40 02 21 E8 C0 03 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 ?? ?? ?? 0? 55 00 04 24 FF FF 03 24 11 00 43 10 03 00 43 24 00 00 44 28 0B 10 64 00 83 10 02 00 ?? ?? 15 3C ?? ?? A2 AE 0F 00 00 00 ?? ?? ?? 0? 1E 00 04 24 ?? ?? 82 AE ?? ?? ?? 0? 18 00 DC 8F 6C 00 C2 8F 7A FF 40 14 21 90 60 02 ?? ?? ?? 0? 00 00 00 00 FF 1F 02 3C ?? ?? ?? 0? FF FF 42 34 C7 FF 40 14 02 00 02 24 01 00 02 24 ?? ?? ?? 0? 24 00 C2 AF ?? ?? ?? 0? 21 28 20 02 ?? ?? ?? 0? 24 00 C0 AF }
	condition:
		$1
}

rule file_271_2_0 {
	meta:
		name = "qsort"
		size = 32
		refs = "000c qsort_r"
	strings:
		$1 = { D8 FF BD 27 10 00 A0 AF 24 00 BF AF ?? ?? ?? 0? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_272_0_0 {
	meta:
		name = "__nrand48_r"
		size = 84
		refs = "0014 __drand48_iterate"
	strings:
		$1 = { D8 FF BD 27 20 00 B1 AF 1C 00 B0 AF 24 00 BF AF 21 80 80 00 ?? ?? ?? 0? 21 88 C0 00 08 00 40 04 FF FF 02 24 02 00 04 96 04 00 03 96 21 10 00 00 42 20 04 00 C0 1B 03 00 25 18 83 00 00 00 23 AE 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_273_0_0 {
	meta:
		name = "__get_sol"
		size = 136
		refs = "0064 $LC0 0068 $LC1 0080 __assert_fail 002c __PRETTY_FUNCTION__.6834"
	strings:
		$1 = { ?? ?? 03 3C ?? ?? 63 24 54 00 69 24 FF FF 02 24 ?? ?? ?? 0? FF FF 08 24 0C 00 63 24 0D 00 69 10 00 00 00 00 00 00 66 8C 0E 00 C8 10 ?? ?? 07 3C 08 00 67 8C F8 FF E5 14 00 00 00 00 04 00 67 8C 06 00 E4 10 27 38 02 00 0C 00 63 24 F5 FF 69 14 0A 10 C7 00 08 00 E0 03 00 00 00 00 08 00 E0 03 21 10 C0 00 ?? ?? 04 3C ?? ?? 05 3C E0 FF BD 27 ?? ?? 84 24 ?? ?? A5 24 45 00 06 24 1C 00 BF AF ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_273_1_0 {
	meta:
		name = "getsourcefilter"
		size = 480
		refs = "0018 __gnu_local_gp 008c memcpy 00a0 __get_sol 00c8 __getsockopt 0118 __libc_errno 0138 free 01ac __libc_alloca_cutoff 01c0 malloc"
	strings:
		$1 = { A8 FF BD 27 50 00 BE AF 21 F0 A0 03 38 00 B1 AF 6C 00 D1 8F 34 00 B0 AF ?? ?? 1C 3C 00 00 30 8E 01 80 02 34 ?? ?? 9C 27 C0 81 10 00 8C 00 10 26 2B 10 02 02 4C 00 B6 AF 48 00 B5 AF 40 00 B3 AF 3C 00 B2 AF 54 00 BF AF 44 00 B4 AF 18 00 DC AF 21 A8 80 00 21 B0 A0 00 21 90 C0 00 21 98 E0 00 52 00 40 10 20 00 D0 AF 0E 00 10 26 C2 80 10 00 C0 80 10 00 23 E8 B0 03 18 00 B0 27 01 00 14 24 04 00 04 26 21 28 40 02 21 30 60 02 ?? ?? ?? 0? 00 00 16 AE 00 00 22 8E 00 00 44 96 21 28 60 02 ?? ?? ?? 0? 88 00 02 AE FF FF 03 24 18 00 43 10 18 00 DC 8F 20 00 C3 27 10 00 A3 AF 21 20 A0 02 21 28 40 00 30 00 06 24 ?? ?? ?? 0? 21 38 00 02 28 00 40 10 21 90 40 00 16 00 80 12 21 10 40 02 21 E8 C0 03 54 00 BF 8F 50 00 BE 8F 4C 00 B6 8F 48 00 B5 8F 44 00 B4 8F 40 00 B3 8F 3C 00 B2 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 58 00 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F FF FF 12 24 21 10 62 00 16 00 03 24 00 00 43 AC EC FF 80 16 21 10 40 02 21 20 00 02 ?? ?? ?? 0? 28 00 D2 AF 21 E8 C0 03 54 00 BF 8F 28 00 C2 8F 4C 00 B6 8F 50 00 BE 8F 48 00 B5 8F 44 00 B4 8F 40 00 B3 8F 3C 00 B2 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 58 00 BD 27 84 00 03 8E 68 00 C2 8F 70 00 C4 8F 8C 00 05 26 00 00 43 AC 88 00 02 8E 00 00 23 8E 2B 30 43 00 0A 10 66 00 ?? ?? ?? 0? C0 31 02 00 88 00 02 8E ?? ?? ?? 0? 00 00 22 AE ?? ?? ?? 0? 21 20 00 02 AD FF 40 14 0E 00 10 26 F2 FF 10 26 ?? ?? ?? 0? 21 20 00 02 03 00 40 10 21 80 40 00 ?? ?? ?? 0? 21 A0 00 00 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_274_0_0 {
	meta:
		name = "__strfmon"
		size = 80
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 003c __vstrfmon_l"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D0 FF BD 27 3C 00 A7 AF 21 10 62 00 00 00 42 8C 3C 00 A3 27 21 38 C0 00 10 00 A3 AF 21 30 40 00 2C 00 BF AF 18 00 BC AF ?? ?? ?? 0? 20 00 A3 AF 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "mknodat"
		size = 56
		refs = "0024 __xmknodat"
	strings:
		$1 = { D8 FF BD 27 21 18 80 00 21 10 A0 00 38 00 A4 27 21 38 C0 00 10 00 A4 AF 21 28 60 00 01 00 04 24 24 00 BF AF ?? ?? ?? 0? 21 30 40 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "__msync_nocancel"
		size = 28
	strings:
		$1 = { 30 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_277_1_0 {
	meta:
		name = "__libc_msync"
		size = 148
		refs = "0040 __libc_enable_asynccancel 006c __libc_disable_asynccancel"
	strings:
		$1 = { 3B E8 03 7C 70 8B 63 8C 08 00 03 14 00 00 00 00 30 10 02 24 0C 00 00 00 F0 FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 D0 FF BD 27 1C 00 BF AF 00 00 A4 AF 04 00 A5 AF 08 00 A6 AF ?? ?? ?? 0? 00 00 00 00 2C 00 A2 AF 00 00 A4 8F 04 00 A5 8F 08 00 A6 8F 30 10 02 24 0C 00 00 00 24 00 A2 AF 28 00 A7 AF 2C 00 A4 8F ?? ?? ?? 0? 00 00 00 00 24 00 A2 8F 28 00 A7 8F 1C 00 BF 8F D6 FF E0 14 30 00 BD 27 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_78_1_2 {
	meta:
		name = "__libc_msync"
		size = 148
		refs = "0040 __pthread_enable_asynccancel 006c __pthread_disable_asynccancel"
	strings:
		$1 = { 3B E8 03 7C 70 8B 63 8C 08 00 03 14 00 00 00 00 30 10 02 24 0C 00 00 00 F0 FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 D0 FF BD 27 1C 00 BF AF 00 00 A4 AF 04 00 A5 AF 08 00 A6 AF ?? ?? ?? 0? 00 00 00 00 2C 00 A2 AF 00 00 A4 8F 04 00 A5 8F 08 00 A6 8F 30 10 02 24 0C 00 00 00 24 00 A2 AF 28 00 A7 AF 2C 00 A4 8F ?? ?? ?? 0? 00 00 00 00 24 00 A2 8F 28 00 A7 8F 1C 00 BF 8F D6 FF E0 14 30 00 BD 27 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "__sendmsg_nocancel"
		size = 28
	strings:
		$1 = { 53 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_278_1_0 {
	meta:
		name = "__libc_sendmsg"
		size = 148
		refs = "0040 __libc_enable_asynccancel 006c __libc_disable_asynccancel"
	strings:
		$1 = { 3B E8 03 7C 70 8B 63 8C 08 00 03 14 00 00 00 00 53 10 02 24 0C 00 00 00 F0 FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 D0 FF BD 27 1C 00 BF AF 00 00 A4 AF 04 00 A5 AF 08 00 A6 AF ?? ?? ?? 0? 00 00 00 00 2C 00 A2 AF 00 00 A4 8F 04 00 A5 8F 08 00 A6 8F 53 10 02 24 0C 00 00 00 24 00 A2 AF 28 00 A7 AF 2C 00 A4 8F ?? ?? ?? 0? 00 00 00 00 24 00 A2 8F 28 00 A7 8F 1C 00 BF 8F D6 FF E0 14 30 00 BD 27 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_73_1_2 {
	meta:
		name = "__libc_sendmsg"
		size = 148
		refs = "0040 __pthread_enable_asynccancel 006c __pthread_disable_asynccancel"
	strings:
		$1 = { 3B E8 03 7C 70 8B 63 8C 08 00 03 14 00 00 00 00 53 10 02 24 0C 00 00 00 F0 FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 D0 FF BD 27 1C 00 BF AF 00 00 A4 AF 04 00 A5 AF 08 00 A6 AF ?? ?? ?? 0? 00 00 00 00 2C 00 A2 AF 00 00 A4 8F 04 00 A5 8F 08 00 A6 8F 53 10 02 24 0C 00 00 00 24 00 A2 AF 28 00 A7 AF 2C 00 A4 8F ?? ?? ?? 0? 00 00 00 00 24 00 A2 8F 28 00 A7 8F 1C 00 BF 8F D6 FF E0 14 30 00 BD 27 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "mkostemps64"
		size = 56
		refs = "0008 __gen_tempname 0010 __gnu_local_gp 0020 __libc_errno"
	strings:
		$1 = { 03 00 A0 04 00 20 C6 34 ?? ?? ?? 0? 21 38 00 00 ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_281_0_0 {
	meta:
		name = "posix_spawnattr_setflags"
		size = 40
	strings:
		$1 = { 20 2E 05 7C 80 FF 03 24 24 18 A3 00 03 00 60 10 16 00 02 24 08 00 E0 03 00 00 00 00 00 00 85 A4 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "__fdelt_chk"
		size = 36
		refs = "001c __chk_fail"
	strings:
		$1 = { 00 04 82 2C 03 00 40 10 43 11 04 00 08 00 E0 03 00 00 00 00 E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_283_0_0 {
	meta:
		name = "__wmemcpy_chk"
		size = 36
		refs = "000c memcpy 001c __chk_fail"
	strings:
		$1 = { 2B 38 E6 00 03 00 E0 14 00 00 00 00 ?? ?? ?? 0? 80 30 06 00 E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_1002_0_0 {
	meta:
		name = "__wmemmove_chk"
		size = 36
		refs = "000c memmove 001c __chk_fail"
	strings:
		$1 = { 2B 38 E6 00 03 00 E0 14 00 00 00 00 ?? ?? ?? 0? 80 30 06 00 E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_1055_0_0 {
	meta:
		name = "__wmempcpy_chk"
		size = 36
		refs = "000c mempcpy 001c __chk_fail"
	strings:
		$1 = { 2B 38 E6 00 03 00 E0 14 00 00 00 00 ?? ?? ?? 0? 80 30 06 00 E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_284_0_0 {
	meta:
		name = "strcspn"
		size = 112
		refs = "003c strchr"
	strings:
		$1 = { D8 FF BD 27 18 00 B0 AF 24 00 BF AF 20 00 B2 AF 1C 00 B1 AF 00 00 83 80 13 00 60 10 21 80 80 00 21 90 A0 00 ?? ?? ?? 0? 21 88 00 00 00 00 03 82 06 00 60 10 01 00 31 26 21 28 60 00 ?? ?? ?? 0? 21 20 40 02 F9 FF 40 10 01 00 10 26 24 00 BF 8F 21 10 20 02 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 21 88 00 00 }
	condition:
		$1
}

rule file_285_0_0 {
	meta:
		name = "__vwprintf_chk"
		size = 540
		refs = "0008 stdout 00b4 _IO_vfwprintf 0138 __lll_lock_wait_private 01c8 _Unwind_Resume"
	strings:
		$1 = { C0 FF BD 27 28 00 B1 AF ?? ?? 11 3C 24 00 B0 AF ?? ?? 30 8E 34 00 B4 AF 30 00 B3 AF 00 00 02 8E 2C 00 B2 AF 3C 00 BF AF 00 80 42 30 38 00 B5 AF 21 98 80 00 21 A0 A0 00 3D 00 40 14 21 90 C0 00 3B E8 03 7C 48 00 02 8E 70 8B 75 24 08 00 43 8C 10 00 75 10 21 20 00 02 18 00 A0 AF 00 00 45 C0 06 00 A0 14 00 00 03 24 01 00 01 24 00 00 41 E0 FA FF 20 10 01 00 03 24 0F 00 00 00 2E 00 60 10 21 20 40 00 48 00 03 8E ?? ?? 24 8E 21 10 60 00 08 00 75 AC 04 00 43 8C 01 00 63 24 04 00 43 AC 04 00 60 1A 21 28 80 02 3C 00 82 8C 04 00 42 34 3C 00 82 AC ?? ?? ?? 0? 21 30 40 02 06 00 60 1A 21 90 40 00 ?? ?? 22 8E FB FF 03 24 3C 00 44 8C 24 18 83 00 3C 00 43 AC 3C 00 04 8E 00 00 02 8E EB FF 03 24 24 18 83 00 00 80 42 30 06 00 40 14 3C 00 03 AE 48 00 04 8E 04 00 82 8C FF FF 42 24 11 00 40 10 04 00 82 AC 3C 00 BF 8F 21 10 40 02 38 00 B5 8F 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 18 00 A5 AF ?? ?? ?? 0? 48 00 03 8E 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 E7 FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 3C 00 BF 8F 3C 00 05 8E 00 00 02 8E EB FF 03 24 24 18 A3 00 00 80 42 30 21 88 80 00 06 00 40 14 3C 00 03 AE 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_452_0_0 {
	meta:
		name = "___vprintf_chk"
		size = 540
		refs = "0008 stdout 00b4 vfprintf 0138 __lll_lock_wait_private 01c8 _Unwind_Resume"
	strings:
		$1 = { C0 FF BD 27 28 00 B1 AF ?? ?? 11 3C 24 00 B0 AF ?? ?? 30 8E 34 00 B4 AF 30 00 B3 AF 00 00 02 8E 2C 00 B2 AF 3C 00 BF AF 00 80 42 30 38 00 B5 AF 21 98 80 00 21 A0 A0 00 3D 00 40 14 21 90 C0 00 3B E8 03 7C 48 00 02 8E 70 8B 75 24 08 00 43 8C 10 00 75 10 21 20 00 02 18 00 A0 AF 00 00 45 C0 06 00 A0 14 00 00 03 24 01 00 01 24 00 00 41 E0 FA FF 20 10 01 00 03 24 0F 00 00 00 2E 00 60 10 21 20 40 00 48 00 03 8E ?? ?? 24 8E 21 10 60 00 08 00 75 AC 04 00 43 8C 01 00 63 24 04 00 43 AC 04 00 60 1A 21 28 80 02 3C 00 82 8C 04 00 42 34 3C 00 82 AC ?? ?? ?? 0? 21 30 40 02 06 00 60 1A 21 90 40 00 ?? ?? 22 8E FB FF 03 24 3C 00 44 8C 24 18 83 00 3C 00 43 AC 3C 00 04 8E 00 00 02 8E EB FF 03 24 24 18 83 00 00 80 42 30 06 00 40 14 3C 00 03 AE 48 00 04 8E 04 00 82 8C FF FF 42 24 11 00 40 10 04 00 82 AC 3C 00 BF 8F 21 10 40 02 38 00 B5 8F 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 18 00 A5 AF ?? ?? ?? 0? 48 00 03 8E 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 E7 FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 3C 00 BF 8F 3C 00 05 8E 00 00 02 8E EB FF 03 24 24 18 A3 00 00 80 42 30 21 88 80 00 06 00 40 14 3C 00 03 AE 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "__alloc_dir"
		size = 412
		refs = "0004 __gnu_local_gp 0044 __fcntl 0078 malloc 00bc __have_o_cloexec 0168 __libc_errno"
	strings:
		$1 = { D0 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 24 00 B2 AF FF 00 B2 30 20 00 B1 AF 1C 00 B0 AF 2C 00 BF AF 28 00 B3 AF 10 00 BC AF 21 80 80 00 23 00 40 16 21 88 E0 00 C0 04 C6 7C 20 00 C0 14 21 20 00 02 02 00 05 24 ?? ?? ?? 0? 01 00 06 24 41 00 40 04 10 00 BC 8F 37 00 20 12 18 80 04 34 58 00 22 8E 10 00 04 3C 2B 18 44 00 22 00 60 14 00 80 03 34 18 00 84 24 10 00 11 3C ?? ?? ?? 0? 00 00 00 00 2E 00 40 10 00 00 00 00 00 00 50 AC 04 00 40 AC 08 00 51 AC 0C 00 40 AC 10 00 40 AC 14 00 40 AC 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? 13 3C ?? ?? 62 8E 10 00 40 10 21 20 00 02 E1 FF 40 1C 00 00 00 00 21 20 00 02 02 00 05 24 ?? ?? ?? 0? 01 00 06 24 DB FF 41 04 10 00 BC 8F ?? ?? ?? 0? 21 10 00 00 2B 88 43 00 0A 18 51 00 21 88 60 00 ?? ?? ?? 0? 18 00 64 24 01 00 05 24 ?? ?? ?? 0? 21 30 00 00 01 00 44 30 01 00 03 24 FF FF 02 24 0B 10 64 00 EB FF 40 18 ?? ?? 62 AE ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 00 80 11 34 ?? ?? ?? 0? 18 20 04 24 03 00 40 10 10 00 BC 8F ?? ?? ?? 0? 00 20 11 24 21 10 00 00 D2 FF 40 12 2C 00 BF 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 20 00 02 21 10 62 00 00 00 45 8C A6 0F 02 24 0C 00 00 00 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 10 00 00 21 20 64 00 ?? ?? ?? 0? 00 00 85 AC }
	condition:
		$1
}

rule file_288_1_0 {
	meta:
		name = "__opendirat"
		size = 120
		refs = "0000 __gnu_local_gp 0024 __openat_nocancel 0048 __alloc_dir 0058 __libc_errno"
	strings:
		$1 = { ?? ?? 1C 3C E0 FF BD 27 ?? ?? 9C 27 1C 00 BF AF 10 00 BC AF 00 00 A2 80 0D 00 40 10 09 00 06 3C 80 20 C6 24 ?? ?? ?? 0? 21 38 00 00 0E 00 40 04 10 00 BC 8F 1C 00 BF 8F 21 20 40 00 01 00 05 24 21 30 00 00 21 38 00 00 ?? ?? ?? 0? 20 00 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 02 00 03 24 00 00 43 AC 1C 00 BF 8F 21 10 00 00 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "__updwtmp"
		size = 440
		refs = "0008 $LC2 0028 strcmp 0044 $LC3 005c $LC1 0074 $LC0 007c __libc_utmp_file_functions 00b0 __access"
	strings:
		$1 = { D0 FF BD 27 1C 00 B1 AF ?? ?? 11 3C 20 00 B2 AF 21 90 A0 00 ?? ?? 25 26 18 00 B0 AF 2C 00 BF AF 28 00 B4 AF 24 00 B3 AF ?? ?? ?? 0? 21 80 80 00 1E 00 40 10 ?? ?? 13 3C ?? ?? 13 3C 21 20 00 02 ?? ?? ?? 0? ?? ?? 65 26 29 00 40 10 ?? ?? 14 3C ?? ?? 14 3C 21 20 00 02 ?? ?? ?? 0? ?? ?? 85 26 34 00 40 10 ?? ?? 84 26 ?? ?? 11 3C 21 20 00 02 ?? ?? ?? 0? ?? ?? 25 26 3E 00 40 10 ?? ?? 02 3C 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 1C 00 B1 8F 21 20 00 02 21 28 40 02 18 00 B0 8F 20 00 B2 8F ?? ?? 59 8C 08 00 20 03 30 00 BD 27 ?? ?? 64 26 ?? ?? ?? 0? 21 28 00 00 DF FF 40 14 ?? ?? 02 3C ?? ?? 70 26 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 1C 00 B1 8F 21 20 00 02 21 28 40 02 18 00 B0 8F 20 00 B2 8F ?? ?? 59 8C 08 00 20 03 30 00 BD 27 ?? ?? 84 26 ?? ?? ?? 0? 21 28 00 00 D4 FF 40 14 ?? ?? 02 3C ?? ?? 90 26 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 1C 00 B1 8F 21 20 00 02 21 28 40 02 18 00 B0 8F 20 00 B2 8F ?? ?? 59 8C 08 00 20 03 30 00 BD 27 ?? ?? ?? 0? 21 28 00 00 CA FF 40 10 ?? ?? 02 3C ?? ?? 30 26 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 1C 00 B1 8F 21 20 00 02 21 28 40 02 18 00 B0 8F 20 00 B2 8F ?? ?? 59 8C 08 00 20 03 30 00 BD 27 ?? ?? 24 26 ?? ?? ?? 0? 21 28 00 00 ?? ?? 73 26 0B 80 62 02 ?? ?? 02 3C 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 1C 00 B1 8F 21 20 00 02 21 28 40 02 18 00 B0 8F 20 00 B2 8F ?? ?? 59 8C 08 00 20 03 30 00 BD 27 }
	condition:
		$1
}

rule file_290_0_0 {
	meta:
		name = "__fchdir"
		size = 28
	strings:
		$1 = { 25 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "__clock_gettime"
		size = 56
		refs = "0000 __gnu_local_gp 0020 __libc_errno"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 A7 10 02 24 0C 00 00 00 07 00 E0 10 00 00 00 00 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC FF FF 02 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_292_0_0 {
	meta:
		name = "__assert_fail_base"
		size = 396
		refs = "0000 pthread_setcancelstate 0048 __progname 005c $LC0 0090 __asprintf 00a0 $LC2 00a8 __fxprintf 00b0 stderr 00b8 _IO_fflush 00c0 _dl_pagesize 00f0 __mmap 010c strcpy 0114 __abort_msg 013c __munmap 0144 free 014c abort 0154 $LC1 0170 errstr.10390 017c __libc_write"
	strings:
		$1 = { ?? ?? 02 3C B0 FF BD 27 ?? ?? 42 24 48 00 B4 AF 44 00 B3 AF 40 00 B2 AF 3C 00 B1 AF 38 00 B0 AF 4C 00 BF AF 21 88 80 00 21 90 A0 00 21 98 C0 00 21 A0 E0 00 04 00 40 10 60 00 B0 8F 01 00 04 24 ?? ?? ?? 0? 21 28 00 00 ?? ?? 02 3C ?? ?? 46 8C 00 00 C3 80 3F 00 60 10 00 00 00 00 ?? ?? 07 3C 3F 00 00 12 ?? ?? E7 24 ?? ?? 03 3C ?? ?? 63 24 1C 00 A3 AF 30 00 A3 27 10 00 B3 AF 14 00 B4 AF 18 00 B0 AF 20 00 B2 AF 24 00 A3 AF 34 00 A4 27 ?? ?? ?? 0? 21 28 20 02 35 00 40 04 34 00 A6 8F ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? 21 20 00 00 ?? ?? 02 3C ?? ?? 44 8C ?? ?? ?? 0? FF FF 11 24 ?? ?? 02 3C ?? ?? 43 8C 30 00 A2 8F 10 00 B1 AF 23 20 03 00 21 10 62 00 24 10 44 00 14 00 A0 AF 21 20 00 00 21 28 40 00 03 00 06 24 02 08 07 24 ?? ?? ?? 0? 30 00 A2 AF 12 00 51 10 21 80 40 00 04 00 44 24 30 00 A2 8F 34 00 A5 8F ?? ?? ?? 0? 00 00 02 AE ?? ?? 02 3C ?? ?? 42 24 00 00 44 C0 21 08 00 02 00 00 41 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 85 8C ?? ?? ?? 0? 34 00 A4 8F ?? ?? ?? 0? 00 00 00 00 ?? ?? 07 3C C3 FF 00 16 ?? ?? E7 24 ?? ?? 10 3C ?? ?? 10 26 ?? ?? ?? 0? 21 18 00 02 ?? ?? 05 3C 02 00 04 24 ?? ?? A5 24 ?? ?? ?? 0? 12 00 06 24 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_292_1_0 {
	meta:
		name = "__assert_fail"
		size = 88
		refs = "0014 _libc_intl_domainname 0018 $LC3 0038 __dcgettext 0050 __assert_fail_base"
	strings:
		$1 = { C8 FF BD 27 2C 00 B2 AF 28 00 B1 AF 21 90 80 00 21 88 A0 00 ?? ?? 04 3C ?? ?? 05 3C 24 00 B0 AF ?? ?? 84 24 21 80 C0 00 ?? ?? A5 24 05 00 06 24 30 00 B3 AF 34 00 BF AF ?? ?? ?? 0? 21 98 E0 00 21 20 40 00 10 00 B3 AF 21 28 40 02 21 30 20 02 ?? ?? ?? 0? 21 38 00 02 }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "getpgrp"
		size = 16
	strings:
		$1 = { E1 0F 02 24 0C 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_296_0_0 {
	meta:
		name = "__lll_lock_wait_private"
		size = 92
	strings:
		$1 = { 00 00 83 8C F8 FF BD 27 02 00 02 24 04 00 B0 AF 07 00 62 14 21 80 80 00 3B E8 03 7C 02 00 06 24 78 8B 65 8C 21 38 00 00 8E 10 02 24 0C 00 00 00 00 00 02 C2 02 00 01 24 00 00 01 E2 FC FF 20 10 00 00 00 00 0F 00 00 00 F3 FF 40 14 21 20 00 02 04 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_297_0_0 {
	meta:
		name = "setegid"
		size = 168
		refs = "0000 __gnu_local_gp 0020 __nptl_setxid 005c __libc_errno"
	strings:
		$1 = { ?? ?? 1C 3C C8 FF BD 27 ?? ?? 9C 27 FF FF 02 24 21 28 80 00 34 00 BF AF 0E 00 82 10 10 00 BC AF ?? ?? 03 3C ?? ?? 63 24 12 00 60 10 5E 10 03 24 18 00 A4 27 18 00 A3 AF 1C 00 A2 AF 20 00 A5 AF ?? ?? ?? 0? 24 00 A2 AF 34 00 BF 8F 08 00 E0 03 38 00 BD 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 FF FF 04 24 FF FF 06 24 5E 10 02 24 0C 00 00 00 F1 FF E0 10 34 00 BF 8F 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "__printf_fphex"
		size = 5268
		refs = "000c __gnu_local_gp 0064 _nl_current_LC_NUMERIC 00a0 __isnan 00b8 __libc_tsd_CTYPE_B 00e0 $LC6 00e4 $LC7 0124 _IO_padn 01f8 _IO_wpadn 023c _nl_current_LC_MONETARY 025c __isinf 029c $LC0 02a0 $LC1 035c $LC4 0360 $LC5 0374 __signbit 03a0 _itowa 03c8 _itoa 0538 _itoa_word 0550 _itowa_lower_digits 05f8 strlen 0298 $LC2 0a40 $LC3 0a90 __overflow 0f00 __libc_tsd_CTYPE_TOLOWER 0084 $LC8 1068 $LC9 107c __assert_fail 106c __PRETTY_FUNCTION__.11976 1090 __woverflow"
	strings:
		$1 = { D0 FE BD 27 24 01 B7 AF 0C 00 B7 8C ?? ?? 1C 3C ?? ?? 9C 27 80 02 EA 7E 00 01 E2 32 28 01 BE AF 20 01 B6 AF 10 01 B2 AF 08 01 B0 AF 2C 01 BF AF 1C 01 B5 AF 18 01 B4 AF 14 01 B3 AF 0C 01 B1 AF 18 00 BC AF 21 F0 A0 00 21 80 80 00 00 00 B6 8C 04 00 B2 8C 3B E8 03 7C 77 00 40 14 E0 00 AA AF 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 42 8C 00 00 42 8C 24 00 54 8C 30 00 55 8C 00 00 82 82 F9 03 40 10 ?? ?? 04 3C F8 03 A0 12 ?? ?? 05 3C 00 00 C2 8C 04 00 51 8C 00 00 53 8C 21 28 20 02 ?? ?? ?? 0? 21 20 60 02 6B 00 40 10 18 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 08 00 C4 8F 21 10 62 00 00 00 43 8C 40 10 04 00 21 10 62 00 00 00 42 94 00 01 42 30 A0 00 40 14 C2 8F 11 00 ?? ?? 15 3C ?? ?? 16 3C ?? ?? B5 26 ?? ?? D6 26 71 00 20 16 50 00 E2 32 6F 00 40 14 00 00 00 00 20 00 F7 32 70 00 E0 16 FD FF 52 26 6E 00 40 1A E0 00 AA 8F 21 20 00 02 20 00 05 24 44 02 40 15 21 30 40 02 ?? ?? ?? 0? 21 A0 40 02 62 02 52 14 00 00 00 00 66 00 20 12 00 00 00 00 E0 00 AA 8F 1E 02 40 11 00 00 00 00 5C 00 02 8E D6 03 40 10 21 20 00 02 10 00 43 8C 14 00 44 8C 2B 20 64 00 D0 03 80 10 04 00 64 24 10 00 44 AC 2D 00 02 24 00 00 62 AC 01 00 94 26 E0 00 AA 8F 67 00 40 11 21 88 C0 02 03 00 91 26 21 98 80 02 5C 00 02 8E 04 00 B5 26 BE 03 40 10 FC FF A5 8E 10 00 43 8C 14 00 44 8C 2B 20 64 00 B9 03 80 10 04 00 66 24 01 00 A4 24 10 00 46 AC 01 00 82 2C 00 00 65 AC 3D 02 40 14 01 00 73 26 F0 FF 71 16 00 00 00 00 0C 00 C3 8F 20 00 63 30 0B 00 60 10 21 10 60 02 09 00 40 1A E0 00 AA 8F 21 20 00 02 20 00 05 24 0B 02 40 11 21 30 40 02 ?? ?? ?? 0? 00 00 00 00 2D 02 52 14 21 10 62 02 2C 01 BF 8F 28 01 BE 8F 24 01 B7 8F 20 01 B6 8F 1C 01 B5 8F 18 01 B4 8F 14 01 B3 8F 10 01 B2 8F 0C 01 B1 8F 08 01 B0 8F 08 00 E0 03 30 01 BD 27 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 42 8C 00 00 42 8C 2C 00 54 8C ?? ?? ?? 0? D0 00 55 8C 21 20 60 02 ?? ?? ?? 0? 21 28 20 02 42 00 40 10 18 00 BC 8F ?? ?? 85 8F 3B E8 03 7C 21 20 60 00 21 20 A4 00 08 00 C3 8F 00 00 84 8C 40 18 03 00 21 18 83 00 00 00 63 94 00 01 63 30 EA 01 60 10 ?? ?? 15 3C ?? ?? 15 3C ?? ?? 16 3C ?? ?? B5 26 ?? ?? D6 26 C2 8F 02 00 91 FF 20 12 50 00 E2 32 FF FF 52 26 20 00 F7 32 92 FF E0 12 FD FF 52 26 9C FF 20 16 21 A0 00 00 0C 00 C2 8F 40 00 43 30 C1 01 60 10 10 00 42 30 E0 00 AA 8F DB 01 40 11 00 00 00 00 5C 00 02 8E 86 03 40 10 21 20 00 02 10 00 43 8C 14 00 44 8C 2B 20 64 00 80 03 80 10 04 00 64 24 10 00 44 AC 2B 00 02 24 ?? ?? ?? 0? 00 00 62 AC 03 00 D5 26 FF FF 17 24 14 00 02 8E 18 00 03 8E 01 00 31 26 2B 18 43 00 64 03 60 10 FF FF 25 82 01 00 43 24 14 00 03 AE 00 00 45 A0 23 98 36 02 F5 FF 35 16 21 98 74 02 ?? ?? ?? 0? 0C 00 C3 8F ?? ?? 15 3C ?? ?? 16 3C ?? ?? B5 26 ?? ?? ?? 0? ?? ?? D6 26 21 20 60 02 ?? ?? ?? 0? 21 28 20 02 08 00 C3 8F 00 98 37 7E 21 20 60 02 41 00 63 38 01 00 63 2C 21 28 E0 02 A0 00 A6 27 10 00 07 24 10 00 A3 AF ?? ?? ?? 0? E4 00 A2 AF 08 00 C3 8F 21 20 60 02 21 28 E0 02 41 00 63 38 01 00 63 2C 10 00 A3 AF C0 00 A6 27 10 00 07 24 ?? ?? ?? 0? 00 01 A2 AF 00 01 A8 8F 6C 00 A3 27 18 00 BC 8F 2B 20 68 00 13 00 80 10 21 48 40 00 03 00 02 24 23 10 43 00 FC FF 03 25 21 10 62 00 82 10 02 00 27 20 02 00 80 20 04 00 21 40 04 01 30 00 05 24 ?? ?? ?? 0? 21 20 20 01 FC FF 63 24 FF FF 84 24 00 00 65 AC FC FF 68 14 00 00 85 A0 27 10 02 00 21 48 22 01 F0 7F 04 3C 24 20 91 00 30 00 0C 24 25 10 F3 02 31 00 03 24 00 55 31 7E 0B 60 64 00 B0 01 20 16 01 00 42 2C FE 01 40 14 21 B8 00 00 01 00 0A 24 FE 03 17 24 E8 00 AA AF 9C 00 A3 8F 30 00 02 24 E6 02 62 14 A0 00 A2 27 C0 00 AD 27 30 00 04 24 FC FF 42 24 FC FF 43 8C FD FF 64 10 FF FF AD 25 FF FF 02 24 44 02 C2 12 23 10 A9 01 2A 18 C2 02 1D 00 60 10 00 00 00 00 D6 02 C0 1A 21 18 80 01 21 20 36 01 FF FF 83 80 FF 00 65 30 BF FF A6 24 06 00 C6 2C 7E 02 C0 10 00 00 84 80 C9 FF 65 24 FF 00 83 30 BF FF 66 24 06 00 C6 2C 73 02 C0 10 9F FF 63 24 C9 FF 83 24 07 00 64 30 03 00 80 14 01 00 06 24 01 00 C6 26 2A 30 C2 00 08 00 63 28 05 00 60 14 01 00 A5 30 7C 02 A0 14 FF FF C2 26 7A 02 C0 14 00 00 00 00 D9 00 B1 27 21 28 20 02 0A 00 06 24 21 20 E0 02 21 38 00 00 00 01 A8 AF FC 00 A9 AF F4 00 AC AF ?? ?? ?? 0? F8 00 AD AF F8 00 AD 8F F4 00 AC 8F FC 00 A9 8F 00 01 A8 8F ?? ?? 06 3C CC CC 05 3C 21 70 40 00 D4 00 B3 27 ?? ?? C6 24 CD CC A5 34 19 00 E5 02 FC FF 73 26 10 18 00 00 C2 18 03 00 40 20 03 00 C0 10 03 00 21 10 82 00 23 B8 E2 02 80 B8 17 00 21 B8 D7 00 00 00 E4 8E 21 B8 60 00 F3 FF 60 14 00 00 64 AE E4 00 AA 8F 23 18 D1 01 0C 00 D7 8F 05 00 40 15 FC FF 02 24 50 00 E2 32 2B 10 02 00 FD FF 04 24 23 10 82 00 23 10 56 00 FE FF 42 24 21 10 62 00 9A 01 C0 1A 21 90 52 00 E0 00 AA 8F 0D 00 40 15 01 00 02 24 21 20 80 02 00 01 A8 AF FC 00 A9 AF F4 00 AC AF F8 00 AD AF ?? ?? ?? 0? F0 00 AE AF F0 00 AE 8F F8 00 AD 8F F4 00 AC 8F FC 00 A9 8F 00 01 A8 8F 23 90 42 02 20 00 F7 32 58 01 E0 16 30 00 02 24 10 00 C3 8F 55 01 62 10 00 00 00 00 53 01 40 1A E0 00 AA 8F 21 20 00 02 20 00 05 24 21 30 40 02 00 01 A8 AF FC 00 A9 AF F4 00 AC AF F8 00 AD AF EB 01 40 11 F0 00 AE AF ?? ?? ?? 0? 00 00 00 00 00 01 A8 8F FC 00 A9 8F F4 00 AC 8F F8 00 AD 8F F0 00 AE 8F 0F 01 52 14 21 B8 40 02 E4 00 AA 8F 40 01 40 11 E0 00 AA 8F 76 01 40 11 21 20 00 02 5C 00 02 8E 2D 03 40 10 2D 00 05 24 10 00 43 8C 14 00 44 8C 2B 20 64 00 26 03 80 10 04 00 64 24 10 00 44 AC 2D 00 02 24 00 00 62 AC 01 00 F7 26 E0 00 AA 8F 43 01 40 11 00 00 00 00 5C 00 02 8E 01 03 40 10 21 20 00 02 10 00 43 8C 14 00 44 8C 2B 20 64 00 FB 02 80 10 04 00 64 24 10 00 44 AC 30 00 02 24 00 00 62 AC 08 00 C2 8F E0 00 AA 8F 3D 01 40 11 17 00 45 24 5C 00 03 8E E3 02 60 10 21 20 00 02 10 00 64 8C 14 00 66 8C 2B 30 86 00 DD 02 C0 10 04 00 86 24 18 00 42 24 10 00 66 AC 01 00 42 2C 00 00 85 AC DF 00 40 14 FF FF 02 24 0C 00 C2 8F 20 00 42 30 05 00 40 14 02 00 E7 26 10 00 C3 8F 30 00 02 24 BB 01 62 10 00 00 00 00 E0 00 AA 8F 2C 01 40 11 00 00 00 00 5C 00 02 8E 01 03 40 10 21 20 00 02 10 00 43 8C 14 00 44 8C 2B 20 64 00 FB 02 80 10 04 00 64 24 10 00 44 AC 00 00 6C AC 4E 01 C0 1A 01 00 F7 24 E0 00 AA 8F E6 00 40 15 21 20 80 02 00 01 A8 AF FC 00 A9 AF F8 00 AD AF ?? ?? ?? 0? F0 00 AE AF 21 A8 40 00 FF FF 06 24 00 01 A8 8F FC 00 A9 8F F8 00 AD 8F 0D 00 40 10 F0 00 AE 8F 14 00 02 8E 18 00 03 8E 01 00 94 26 2B 18 43 00 F5 02 60 10 FF FF 85 82 01 00 43 24 14 00 03 AE 00 00 45 A0 FF FF B5 26 F5 FF A0 16 01 00 F7 26 23 00 C0 1A E0 00 AA 8F 23 10 A9 01 2A 18 C2 02 23 68 2D 01 21 A8 B6 01 31 01 40 15 0A B0 43 00 21 A0 20 01 FF FF 06 24 0E 00 C0 12 21 18 E0 02 14 00 02 8E 18 00 03 8E 01 00 94 26 2B 18 43 00 87 02 60 10 FF FF 85 82 01 00 43 24 14 00 03 AE 00 00 45 A0 23 10 89 02 FF FF D6 26 F4 FF C0 16 21 18 57 00 3A 01 A0 1A 21 20 00 02 30 00 05 24 21 30 A0 02 EC 00 A3 AF ?? ?? ?? 0? F0 00 AE AF F0 00 AE 8F EC 00 A3 8F 88 00 55 14 21 B8 62 00 08 00 C5 8F E0 00 AA 8F 30 01 40 11 0F 00 A5 24 5C 00 02 8E DF 02 40 10 21 20 00 02 10 00 43 8C 14 00 44 8C 2B 20 64 00 D9 02 80 10 04 00 66 24 01 00 A4 24 10 00 46 AC 01 00 82 2C 00 00 65 AC 77 00 40 14 FF FF 02 24 E8 00 AA 8F 2D 00 05 24 2B 00 02 24 0A 28 4A 00 E0 00 AA 8F 23 01 40 11 00 00 00 00 5C 00 02 8E 44 02 40 10 21 20 00 02 10 00 43 8C 14 00 44 8C 2B 20 64 00 3E 02 80 10 04 00 64 24 10 00 44 AC 00 00 65 AC E0 00 AA 8F 02 00 F7 26 1F 01 40 15 23 88 2E 02 0D 00 20 12 FF FF 13 24 14 00 02 8E 18 00 03 8E 01 00 CE 25 2B 18 43 00 C0 02 60 10 FF FF C5 81 01 00 43 24 14 00 03 AE 00 00 45 A0 FF FF 31 26 F5 FF 20 16 01 00 F7 26 0C 00 C3 8F 20 00 63 30 23 FE 60 10 21 10 E0 02 10 00 C5 8F 30 00 03 24 1F FE A3 10 00 00 00 00 1D FE 40 1A E0 00 AA 8F 21 20 00 02 AE 01 40 11 21 30 40 02 ?? ?? ?? 0? 00 00 00 00 42 00 52 14 21 10 E2 02 ?? ?? ?? 0? 2C 01 BF 8F 14 00 02 8E 18 00 03 8E 2B 18 43 00 C6 01 60 10 01 00 43 24 14 00 03 AE 2D 00 03 24 ?? ?? ?? 0? 00 00 43 A0 E6 FD 40 10 E0 00 AA 8F 40 00 40 11 00 00 00 00 5C 00 02 8E 18 02 40 10 21 20 00 02 10 00 43 8C 14 00 44 8C 2B 20 64 00 12 02 80 10 04 00 64 24 10 00 44 AC 20 00 02 24 ?? ?? ?? 0? 00 00 62 AC ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 A0 40 02 ?? ?? ?? 0? 00 00 00 00 ?? ?? 16 3C ?? ?? B5 26 ?? ?? D6 26 ?? ?? ?? 0? C2 8F 02 00 14 00 02 8E 18 00 03 8E 2B 18 43 00 F6 01 60 10 01 00 43 24 14 00 03 AE 2B 00 03 24 ?? ?? ?? 0? 00 00 43 A0 21 20 00 02 20 00 05 24 00 01 A8 AF FC 00 A9 AF F4 00 AC AF F8 00 AD AF ?? ?? ?? 0? F0 00 AE AF 01 00 42 24 01 00 42 2C 00 01 A8 8F FC 00 A9 8F F4 00 AC 8F F8 00 AD 8F 03 FF 40 10 F0 00 AE 8F FF FF 02 24 2C 01 BF 8F 28 01 BE 8F 24 01 B7 8F 20 01 B6 8F 1C 01 B5 8F 18 01 B4 8F 14 01 B3 8F 10 01 B2 8F 0C 01 B1 8F 08 01 B0 8F 08 00 E0 03 30 01 BD 27 14 00 02 8E 18 00 03 8E 2B 18 43 00 A0 01 60 10 01 00 43 24 14 00 03 AE 20 00 03 24 ?? ?? ?? 0? 00 00 43 A0 FF 03 23 2A 50 00 60 14 FF 03 17 24 01 FC 37 26 E8 00 A0 AF 51 FE 40 10 9C 00 A3 8F FF FF 02 24 79 FE C2 16 21 68 20 01 ?? ?? ?? 0? 21 B0 00 00 5C 00 02 8E 7A 01 40 10 21 20 00 02 10 00 43 8C 14 00 44 8C 2B 20 64 00 74 01 80 10 04 00 65 24 01 00 A4 26 10 00 45 AC 01 00 82 2C 00 00 75 AC D1 FF 40 14 02 00 F7 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 B8 00 00 0C 00 C2 8F 40 00 43 30 3F 00 60 10 10 00 42 30 E0 00 AA 8F A1 00 40 11 21 20 00 02 5C 00 02 8E E9 01 40 10 2B 00 05 24 10 00 43 8C 14 00 44 8C 2B 20 64 00 EC 01 80 10 21 20 00 02 04 00 64 24 10 00 44 AC 2B 00 02 24 ?? ?? ?? 0? 00 00 62 AC 14 00 02 8E 18 00 03 8E 2B 18 43 00 CE 01 60 10 01 00 43 24 14 00 03 AE 30 00 03 24 ?? ?? ?? 0? 00 00 43 A0 14 00 02 8E 18 00 03 8E 2B 18 43 00 FE 01 60 10 01 00 43 24 14 00 03 AE ?? ?? ?? 0? 00 00 45 A0 14 00 02 8E 18 00 03 8E 2B 18 43 00 5A 01 60 10 01 00 43 24 14 00 03 AE ?? ?? ?? 0? 00 00 4C A0 08 00 E2 32 75 FE 40 10 E0 00 AA 8F ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? E8 00 A0 AF 01 00 0A 24 23 B8 F1 02 ?? ?? ?? 0? E8 00 AA AF 14 00 02 8E 18 00 03 8E 2B 18 43 00 82 FF 60 10 2D 00 05 24 01 00 43 24 14 00 03 AE 2D 00 03 24 ?? ?? ?? 0? 00 00 43 A0 8D FE 40 10 E0 00 AA 8F 8F 00 40 11 00 00 00 00 5C 00 02 8E C5 01 40 10 21 20 00 02 10 00 43 8C 14 00 44 8C 2B 20 64 00 C0 01 80 10 21 20 00 02 04 00 64 24 10 00 44 AC 20 00 02 24 ?? ?? ?? 0? 00 00 62 AC 0C 00 C2 8F 08 00 42 30 EF FE 40 10 E0 00 AA 8F ?? ?? ?? 0? 00 00 00 00 12 00 C0 12 00 00 00 00 5C 00 02 8E 04 00 08 25 3C 01 40 10 FC FF 05 8D 10 00 43 8C 14 00 44 8C 2B 20 64 00 37 01 80 10 04 00 66 24 01 00 A4 24 10 00 46 AC 01 00 82 2C 00 00 65 AC 63 FF 40 14 FF FF D6 26 F0 FF C0 16 01 00 F7 26 C3 01 A0 1A 21 20 00 02 30 00 05 24 21 30 A0 02 ?? ?? ?? 0? F0 00 AE AF 21 18 E0 02 ?? ?? ?? 0? F0 00 AE 8F 08 00 C5 8F 21 B8 60 00 0F 00 A5 24 14 00 02 8E 18 00 03 8E 2B 18 43 00 BF 01 60 10 01 00 43 24 14 00 03 AE ?? ?? ?? 0? 00 00 45 A0 14 00 02 8E 18 00 03 8E 2B 18 43 00 82 01 60 10 01 00 43 24 14 00 03 AE ?? ?? ?? 0? 00 00 45 A0 ?? ?? ?? 0? 23 B0 A9 01 EF FE 20 12 00 00 00 00 5C 00 02 8E 04 00 73 26 06 01 40 10 FC FF 65 8E 10 00 43 8C 14 00 44 8C 2B 20 64 00 01 01 80 10 04 00 66 24 01 00 A4 24 10 00 46 AC 01 00 82 2C 00 00 65 AC 32 FF 40 14 FF FF 31 26 F0 FF 20 16 01 00 F7 26 ?? ?? ?? 0? 0C 00 C3 8F ?? ?? ?? 0? 00 00 00 00 F0 00 AE 8F F8 00 AD 8F F4 00 AC 8F FC 00 A9 8F ?? ?? ?? 0? 00 01 A8 8F 14 00 02 8E 18 00 03 8E 2B 18 43 00 13 FF 60 10 2B 00 05 24 01 00 43 24 14 00 03 AE 2B 00 03 24 ?? ?? ?? 0? 00 00 43 A0 45 FE 40 1A E0 00 AA 8F 21 20 00 02 30 00 05 24 21 30 40 02 EC 00 A7 AF 00 01 A8 AF FC 00 A9 AF F4 00 AC AF F8 00 AD AF 67 00 40 11 F0 00 AE AF ?? ?? ?? 0? 00 00 00 00 EC 00 A7 8F 00 01 A8 8F FC 00 A9 8F F4 00 AC 8F F8 00 AD 8F F0 00 AE 8F 06 FF 52 14 21 38 F2 00 ?? ?? ?? 0? E0 00 AA 8F 06 00 66 2C A9 FF 83 24 D0 FF 84 24 ?? ?? ?? 0? 0A 18 86 00 9F FF A5 24 06 00 A6 2C A9 FF 65 24 D0 FF 63 24 ?? ?? ?? 0? 0A 28 66 00 14 00 02 8E 18 00 03 8E 2B 18 43 00 E4 FE 60 10 01 00 43 24 14 00 03 AE 20 00 03 24 ?? ?? ?? 0? 00 00 43 A0 26 00 40 04 ?? ?? 98 8F 21 28 22 01 00 00 A4 80 39 00 03 24 35 00 83 10 00 00 00 00 3B E8 03 7C 21 C8 60 00 21 C8 19 03 00 00 26 8F 80 18 04 00 21 18 C3 00 00 00 63 8C 66 00 63 28 23 00 60 14 FE FF C3 26 21 18 23 01 30 00 0E 24 30 00 07 24 FF FF 06 24 ?? ?? ?? 0? 39 00 0F 24 00 00 64 80 22 00 8F 10 21 28 60 00 00 00 2A 8F 80 88 04 00 21 88 51 01 00 00 31 8E 66 00 31 2A 13 00 20 16 FF FF 63 24 80 20 02 00 21 20 04 01 FF FF 42 24 00 00 AE A0 F1 FF 46 14 00 00 87 AC 3B E8 03 7C 21 10 03 03 00 00 43 8C 80 10 0C 00 21 10 62 00 00 00 42 8C 66 00 42 28 20 00 40 10 E8 00 AA 8F 01 00 8C 25 ?? ?? ?? 0? 20 64 0C 7C 01 00 84 24 80 10 02 00 00 00 A4 A0 21 10 02 01 00 00 43 8C 01 00 63 24 ?? ?? ?? 0? 00 00 43 AC 08 00 C3 8F 80 10 02 00 21 10 02 01 00 00 43 AC 08 00 C2 8F ?? ?? ?? 0? }
	condition:
		$1
}

rule file_300_0_0 {
	meta:
		name = "__sched_setscheduler"
		size = 28
	strings:
		$1 = { 40 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_301_0_0 {
	meta:
		name = "__dl_runtime_resolve"
		size = 808
		refs = "0000 _dl_mips_gnu_objects 0038 _dl_ns 0164 _dl_lookup_symbol_x 01e8 _dl_signal_error 01d8 $LC0"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C B8 FF BD 27 30 00 B0 AF 44 00 BF AF 40 00 B4 AF 3C 00 B3 AF 38 00 B2 AF 34 00 B1 AF 04 00 40 10 21 80 80 00 14 80 C5 8C 6F 00 A0 04 00 00 00 00 ?? ?? 02 3C ?? ?? 49 8C 65 00 20 11 01 00 04 24 2C 02 23 95 5F 00 60 10 24 02 22 8D FF FF 63 24 FF FF 63 30 20 00 45 24 40 19 03 00 ?? ?? ?? 0? 21 28 A3 00 20 00 42 24 56 00 45 10 00 00 00 00 00 00 43 8C FB FF 64 14 00 00 00 00 00 00 26 8D 08 00 43 8C 21 18 C3 00 2B 40 E3 00 F5 FF 00 15 14 00 4A 8C 21 18 6A 00 2B 18 E3 00 F2 FF 60 10 20 00 42 24 21 28 20 01 38 00 A2 8C 2C 00 A7 8C 34 00 A4 8C 04 00 43 8C 00 11 10 00 04 00 F1 8C 21 18 C3 00 21 10 62 00 0D 00 43 90 04 00 84 8C D0 00 A8 8C F4 00 A7 8C 03 00 63 30 21 20 C4 00 21 88 D1 00 04 00 13 8D 04 00 F2 8C 89 00 60 14 28 00 A2 AF B8 01 A3 8C 0C 00 60 10 40 38 10 00 04 00 63 8C 21 30 E6 00 21 18 C3 00 00 00 63 94 44 02 A6 8C FF 7F 63 30 00 19 03 00 21 30 C3 00 04 00 C3 8C 4D 00 60 14 00 00 00 00 3B E8 03 7C 70 8B 66 8C 54 00 C0 14 01 00 03 24 01 00 06 24 00 00 42 8C A0 02 A7 8C 10 00 A0 AF 14 00 A6 AF 18 00 A3 AF 1C 00 A0 AF 21 20 82 00 ?? ?? ?? 0? 28 00 A6 27 21 A0 40 00 3B E8 03 7C 70 8B 62 8C 52 00 40 14 00 00 00 00 28 00 A3 8F 04 00 60 10 21 10 00 00 04 00 63 8C 00 00 82 8E 21 10 62 00 23 18 72 02 44 00 BF 8F 21 18 70 00 80 18 03 00 21 88 23 02 00 00 22 AE 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 48 00 BD 27 0C 00 29 8D 9D FF 20 15 00 00 00 00 ?? ?? 07 3C 21 20 00 00 21 28 00 00 21 30 00 00 ?? ?? ?? 0? ?? ?? E7 24 00 F0 A5 7C 2C 02 A3 94 8F FF 60 10 24 02 A2 8C FF FF 63 24 FF FF 63 30 20 00 46 24 40 19 03 00 21 30 C3 00 ?? ?? ?? 0? 01 00 04 24 20 00 42 24 85 FF 46 10 00 00 00 00 00 00 43 8C FB FF 64 14 00 00 00 00 00 00 A8 8C 08 00 43 8C 21 18 03 01 2B 48 E3 00 F5 FF 20 15 14 00 4A 8C 21 18 6A 00 2B 18 E3 00 F2 FF 60 10 20 00 42 24 ?? ?? ?? 0? 21 30 00 01 3B E8 03 7C 70 8B 63 8C 0F 00 60 14 00 00 00 00 01 00 03 24 00 00 42 8C A0 02 A7 8C 10 00 A6 AF 14 00 A3 AF ?? ?? ?? 0? 18 00 A0 AF 3B E8 03 7C 01 00 02 24 74 8B 62 AC 0F 00 00 00 05 00 03 24 ?? ?? ?? 0? 28 00 A2 8F 3B E8 03 7C 01 00 02 24 74 8B 62 AC 0F 00 00 00 ?? ?? ?? 0? 28 00 A2 8F 3B E8 03 7C 74 8B 63 24 0F 00 00 00 00 00 64 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 02 24 A5 FF 82 14 00 00 00 00 3B E8 03 7C 74 8B 64 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 28 00 A3 8F 04 00 42 8C ?? ?? ?? 0? 21 10 C2 00 }
	condition:
		$1
}

rule file_301_2_0 {
	meta:
		name = "_dl_runtime_resolve"
		size = 92
	strings:
		$1 = { 21 18 80 03 D8 FF BD 27 0C 00 39 27 21 10 E0 03 24 00 AF AF 10 00 A4 AF 14 00 A5 AF 18 00 A6 AF 1C 00 A7 AF 21 20 00 03 21 28 E0 01 21 30 60 00 ?? ?? ?? 0? 21 38 40 00 24 00 BF 8F 10 00 A4 8F 14 00 A5 8F 18 00 A6 8F 1C 00 A7 8F 28 00 BD 27 21 C8 40 00 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_301_3_0 {
	meta:
		name = "_dl_runtime_pltresolve"
		size = 92
		refs = "002c _dl_fixup"
	strings:
		$1 = { D0 FF BD 27 04 00 8D 8F 0C 00 39 27 24 00 AF AF 10 00 A4 AF 14 00 A5 AF 18 00 A6 AF 1C 00 A7 AF 28 00 A2 AF 2C 00 A3 AF 21 20 A0 01 ?? ?? ?? 0? C0 28 18 00 21 C8 40 00 24 00 BF 8F 10 00 A4 8F 14 00 A5 8F 18 00 A6 8F 1C 00 A7 8F 28 00 A2 8F 2C 00 A3 8F 08 00 20 03 30 00 BD 27 }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "__difftime"
		size = 80
		refs = "0010 __floatsidf 0034 __subdf3"
	strings:
		$1 = { D8 FF BD 27 1C 00 B0 AF 21 80 A0 00 24 00 BF AF ?? ?? ?? 0? 20 00 B1 AF 21 20 00 02 21 88 60 00 ?? ?? ?? 0? 21 80 40 00 21 30 40 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 21 38 60 00 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_303_0_0 {
	meta:
		name = "__correctly_grouped_prefixmb"
		size = 644
		refs = "0030 strlen"
	strings:
		$1 = { D0 FF BD 27 28 00 B4 AF 20 00 B2 AF 2C 00 BF AF 24 00 B3 AF 1C 00 B1 AF 18 00 B0 AF 21 A0 E0 00 42 00 E0 10 21 90 A0 00 21 80 80 00 21 20 C0 00 ?? ?? ?? 0? 21 98 C0 00 2B 18 12 02 2E 00 60 10 2C 00 BF 8F FF FF 4E 24 FF FF 04 26 7F 00 0F 24 FF FF 49 26 2B 10 30 01 35 00 40 14 2C 00 BF 8F 00 00 6D 82 ?? ?? ?? 0? 21 58 4E 02 FF FF 29 25 2E 00 24 11 FF FF 6B 25 FF FF 62 81 FB FF 4D 14 00 00 00 00 01 00 62 82 0C 00 40 10 00 00 00 00 FE FF 63 81 F5 FF 62 14 02 00 62 26 ?? ?? ?? 0? 21 40 60 01 FD FF 0A 81 F0 FF 6A 14 FF FF 08 25 00 00 43 80 FB FF 60 14 01 00 42 24 2B 10 30 01 1A 00 40 14 21 C8 20 01 00 00 82 82 23 18 49 02 01 00 42 24 1E 00 62 10 2A 18 43 00 21 90 20 01 21 10 22 01 0B 90 43 00 2B 10 12 02 D9 FF 40 14 FF FF 49 26 2C 00 BF 8F 2B 10 50 02 0A 80 42 02 21 10 00 02 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 FF FF 6B 25 3B 00 8B 14 FF FF 4A 25 2C 00 BF 8F 21 10 40 02 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 21 C0 80 02 01 00 11 83 27 00 20 12 FF FF 2B 25 01 00 18 27 27 00 2F 12 2B 10 70 01 25 00 20 06 00 00 00 00 3D 00 40 14 00 00 00 00 35 00 A0 11 21 50 2E 01 21 60 60 01 FF FF 42 81 11 00 4D 14 01 00 62 26 ?? ?? ?? 0? 21 40 40 01 FE FF 09 81 0C 00 69 14 FF FF 08 25 00 00 43 80 FB FF 60 14 01 00 42 24 2B 10 90 01 2A 00 40 14 21 48 80 01 23 58 6C 01 E3 FF 71 11 00 00 00 00 ?? ?? ?? 0? FF FF 32 27 FF FF 8C 25 EB FF 8C 14 FF FF 4A 25 23 58 64 01 2A 58 2B 02 D1 FF 60 11 2C 00 BF 8F ?? ?? ?? 0? FF FF 32 27 00 00 11 83 DB FF 2F 16 2B 10 70 01 CA FF 40 14 2C 00 BF 8F 19 00 A0 11 21 50 2E 01 FF FF 42 81 C1 FF 4D 14 01 00 62 26 ?? ?? ?? 0? 21 40 40 01 FE FF 09 81 BC FF 69 14 FF FF 08 25 00 00 43 80 FB FF 60 14 01 00 42 24 2B 10 70 01 C3 FF 40 10 21 48 60 01 ?? ?? ?? 0? 2C 00 BF 8F 21 60 60 01 2B 10 90 01 D8 FF 40 10 21 48 60 01 ?? ?? ?? 0? 23 58 69 01 ?? ?? ?? 0? 21 58 00 00 B7 FF 40 10 21 48 60 01 ?? ?? ?? 0? 2C 00 BF 8F }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "add_pad"
		size = 176
		refs = "0064 memset"
	strings:
		$1 = { 00 00 82 8C D8 FF BD 27 01 00 03 24 20 00 B1 AF 1C 00 B0 AF 24 00 BF AF 21 80 80 00 21 88 A0 00 1A 00 A3 10 F4 FF 44 24 07 00 A0 14 24 00 BF 8F 21 10 51 00 00 00 02 AE 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 FC FF 42 24 21 10 02 02 FE FF A6 24 21 20 04 02 0C 00 83 A0 21 28 00 00 06 00 44 24 ?? ?? ?? 0? 05 00 46 A0 00 00 02 8E 24 00 BF 8F 21 10 51 00 00 00 02 AE 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 21 20 04 02 0C 00 80 A0 24 00 BF 8F 21 10 51 00 00 00 02 AE 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_305_1_0 {
	meta:
		name = "option_alloc"
		size = 280
		refs = "00a0 $LC0 00f0 $LC1 0104 __assert_fail 00f4 __PRETTY_FUNCTION__.3472"
	strings:
		$1 = { FF FF C2 24 D8 FF BD 27 02 00 48 2C 20 00 B2 AF 18 00 B0 AF 24 00 BF AF 1C 00 B1 AF 21 80 80 00 06 00 00 15 21 90 A0 00 04 00 03 24 03 00 C3 10 08 00 03 24 28 00 C3 14 24 00 BF 8F 08 00 E3 2C 25 00 60 10 24 00 BF 8F 00 00 04 8E F4 FF 83 24 2E 00 60 10 02 00 84 24 24 18 62 00 23 30 C3 00 24 28 C2 00 21 28 A7 00 ?? ?? ?? 0? 21 20 00 02 00 00 11 8E 21 20 00 02 21 18 51 02 F4 FF 65 24 23 28 05 00 00 00 03 AE ?? ?? ?? 0? 07 00 A5 30 00 00 03 8E F4 FF 63 24 07 00 62 30 14 00 40 14 ?? ?? 04 3C C2 18 03 00 FF FF 63 24 00 01 62 28 08 00 40 10 21 10 11 02 0D 00 03 A2 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 21 10 00 00 08 00 E0 03 28 00 BD 27 ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 D4 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 00 00 04 AE ?? ?? ?? 0? 02 00 03 24 }
	condition:
		$1
}

rule file_305_2_0 {
	meta:
		name = "get_opt_end"
		size = 96
	strings:
		$1 = { 2B 10 A6 00 14 00 40 10 00 00 00 00 00 00 A2 90 0E 00 40 10 00 00 00 00 02 00 A2 24 2B 10 C2 00 0D 00 40 14 00 00 00 00 01 00 A2 90 02 00 42 24 21 28 A2 00 2B 30 C5 00 07 00 C0 14 00 00 00 00 00 00 85 AC 08 00 E0 03 21 10 00 00 01 00 A5 24 08 00 E0 03 00 00 85 AC 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_305_3_0 {
	meta:
		name = "inet6_option_space"
		size = 20
	strings:
		$1 = { 09 00 84 24 F8 FF 02 24 24 10 82 00 08 00 E0 03 0C 00 42 24 }
	condition:
		$1
}

rule file_305_4_0 {
	meta:
		name = "inet6_option_init"
		size = 64
	strings:
		$1 = { 36 00 02 24 05 00 C2 10 0C 00 02 24 3B 00 02 24 09 00 C2 14 00 00 00 00 0C 00 02 24 00 00 82 AC 29 00 02 24 04 00 82 AC 08 00 86 AC 21 10 00 00 08 00 E0 03 00 00 A4 AC 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_305_5_0 {
	meta:
		name = "inet6_option_append"
		size = 100
		refs = "003c memcpy"
	strings:
		$1 = { D8 FF BD 27 20 00 B1 AF 1C 00 B0 AF 24 00 BF AF 00 00 A2 90 21 88 A0 00 03 00 40 10 01 00 10 24 01 00 B0 90 02 00 10 26 ?? ?? ?? 0? 21 28 00 02 0A 00 40 10 21 20 40 00 21 28 20 02 ?? ?? ?? 0? 21 30 00 02 21 10 00 00 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_305_7_0 {
	meta:
		name = "inet6_option_next"
		size = 200
	strings:
		$1 = { 04 00 82 8C D8 FF BD 27 21 18 A0 00 29 00 05 24 25 00 45 14 24 00 BF AF 08 00 82 8C 36 00 05 24 03 00 45 10 3B 00 05 24 1F 00 45 14 00 00 00 00 00 00 82 8C 0E 00 45 2C 1B 00 A0 14 00 00 00 00 0D 00 86 90 01 00 C6 24 C0 30 06 00 0C 00 C5 24 2B 10 45 00 14 00 40 14 21 30 86 00 00 00 65 8C 15 00 A0 10 0C 00 C7 24 0E 00 84 24 2B 20 A4 00 0D 00 80 14 18 00 A8 27 21 20 00 01 ?? ?? ?? 0? 21 30 E0 00 08 00 40 14 18 00 A5 8F 00 00 65 AC 21 20 00 01 ?? ?? ?? 0? 21 30 E0 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 24 00 BF 8F FF FF 02 24 08 00 E0 03 28 00 BD 27 0E 00 85 24 18 00 A5 AF ?? ?? ?? 0? 18 00 A8 27 }
	condition:
		$1
}

rule file_305_8_0 {
	meta:
		name = "inet6_option_find"
		size = 228
	strings:
		$1 = { 04 00 82 8C D8 FF BD 27 29 00 03 24 2D 00 43 14 24 00 BF AF 08 00 82 8C 36 00 03 24 21 58 A0 00 04 00 43 10 21 50 C0 00 3B 00 03 24 25 00 43 14 00 00 00 00 00 00 82 8C 0E 00 43 2C 21 00 60 14 00 00 00 00 0D 00 88 90 01 00 08 25 C0 40 08 00 0C 00 03 25 2B 10 43 00 1A 00 40 14 21 40 88 00 00 00 65 8D 1B 00 A0 10 0C 00 08 25 0E 00 84 24 2B 20 A4 00 13 00 80 14 18 00 A9 27 21 20 20 01 ?? ?? ?? 0? 21 30 00 01 0F 00 40 14 24 00 BF 8F 18 00 A3 8F 21 28 60 00 21 20 20 01 ?? ?? ?? 0? 21 30 00 01 08 00 40 14 24 00 BF 8F 00 00 67 90 F7 FF EA 14 00 00 00 00 00 00 63 AD 08 00 E0 03 28 00 BD 27 24 00 BF 8F FF FF 02 24 08 00 E0 03 28 00 BD 27 0E 00 83 24 18 00 A3 AF ?? ?? ?? 0? 18 00 A9 27 }
	condition:
		$1
}

rule file_306_0_0 {
	meta:
		name = "wcsrchr"
		size = 32
	strings:
		$1 = { 21 10 00 00 00 00 83 8C 26 30 65 00 0A 10 86 00 FC FF 60 14 04 00 84 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_307_0_0 {
	meta:
		name = "__getcontext"
		size = 112
		refs = "0068 __syscall_error"
	strings:
		$1 = { 01 00 03 24 28 00 83 AC 68 00 90 AC 6C 00 91 AC 70 00 92 AC 74 00 93 AC 78 00 94 AC 7C 00 95 AC 80 00 96 AC 84 00 97 AC 98 00 9C AC 9C 00 9D AC A0 00 9E AC A4 00 9F AC 20 00 9F AC 10 00 07 24 68 02 86 24 21 28 00 00 01 00 04 24 63 10 02 24 0C 00 00 00 04 00 E0 14 00 00 00 00 21 10 00 00 08 00 E0 03 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "__splice_nocancel"
		size = 28
	strings:
		$1 = { D0 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_308_1_0 {
	meta:
		name = "splice"
		size = 172
		refs = "0054 __libc_enable_asynccancel 0084 __libc_disable_asynccancel"
	strings:
		$1 = { 3B E8 03 7C 70 8B 63 8C 08 00 03 14 00 00 00 00 D0 10 02 24 0C 00 00 00 F0 FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 10 00 A8 8F 14 00 A9 8F D0 FF BD 27 10 00 A8 AF 14 00 A9 AF 1C 00 BF AF 00 00 A4 AF 04 00 A5 AF 08 00 A6 AF 0C 00 A7 AF ?? ?? ?? 0? 00 00 00 00 2C 00 A2 AF 00 00 A4 8F 04 00 A5 8F 08 00 A6 8F 0C 00 A7 8F D0 10 02 24 0C 00 00 00 24 00 A2 AF 28 00 A7 AF 2C 00 A4 8F ?? ?? ?? 0? 00 00 00 00 24 00 A2 8F 28 00 A7 8F 1C 00 BF 8F D0 FF E0 14 30 00 BD 27 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_309_0_0 {
	meta:
		name = "__wcsrtombs"
		size = 812
		refs = "0000 __gnu_local_gp 005c _nl_current_LC_CTYPE 0098 __wcsnlen 00b4 _dl_mcount_wrapper_check 016c __wcslen 0224 $LC4 0114 $LC1 023c __assert_fail 022c __PRETTY_FUNCTION__.8870 024c __libc_errno 029c $LC0 02c8 _nl_C_LC_CTYPE 02d8 __wcsmbs_load_conv 0124 $LC3 0304 $LC2 0320 __wcsmbs_gconv_fcts_c"
	strings:
		$1 = { ?? ?? 1C 3C 78 FE BD 27 01 00 02 24 ?? ?? 9C 27 74 01 B4 AF 6C 01 B2 AF 64 01 B0 AF 84 01 BF AF 80 01 B7 AF 7C 01 B6 AF 78 01 B5 AF 70 01 B3 AF 68 01 B1 AF 20 00 BC AF 21 90 80 00 21 A0 A0 00 21 80 C0 00 34 01 A0 AF 38 01 A2 AF 9B 00 E0 10 30 01 A2 AF 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 3C 01 A7 AF 48 01 A0 AF 21 10 62 00 00 00 42 8C 00 00 51 8C 14 00 22 8E 93 00 40 10 00 00 00 00 08 00 53 8C 36 00 40 12 14 00 71 8E 00 00 95 8E 21 28 00 02 21 80 50 02 ?? ?? ?? 0? 21 20 A0 02 01 00 42 24 80 10 02 00 21 20 20 02 21 A8 A2 02 2C 01 B0 AF ?? ?? ?? 0? 28 01 B2 AF 28 00 A2 27 14 00 A2 AF 01 00 02 24 21 20 60 02 10 00 A0 AF 18 00 A0 AF 1C 00 A2 AF 28 01 A5 27 21 30 80 02 21 C8 20 02 09 F8 20 03 21 38 A0 02 28 01 A3 8F FB FF 04 24 24 20 44 00 20 00 BC 8F 43 00 80 14 23 80 72 00 FF FF 62 90 0A 00 40 14 84 01 BF 8F 7C 00 43 12 ?? ?? 05 3C 3C 01 A2 8F 00 00 42 8C 71 00 40 14 ?? ?? 04 3C 00 00 80 AE FF FF 10 26 84 01 BF 8F 21 10 00 02 80 01 B7 8F 7C 01 B6 8F 78 01 B5 8F 74 01 B4 8F 70 01 B3 8F 6C 01 B2 8F 68 01 B1 8F 64 01 B0 8F 08 00 E0 03 88 01 BD 27 00 00 90 8E 28 01 B7 27 28 00 B2 27 ?? ?? ?? 0? 21 20 00 02 3C 01 A3 8F 01 00 42 24 80 B0 02 00 04 00 62 8C 00 00 64 8C 21 B0 16 02 50 01 A2 AF 4C 01 A2 27 58 01 B0 AF 4C 01 A4 AF 3C 01 A2 AF 2C 01 B7 AF 21 80 00 00 01 00 15 24 05 00 14 24 21 20 20 02 ?? ?? ?? 0? 28 01 B2 AF 54 01 A2 27 21 20 60 02 10 00 A0 AF 14 00 A2 AF 18 00 A0 AF 1C 00 B5 AF 21 28 E0 02 58 01 A6 27 21 C8 20 02 09 F8 20 03 21 38 C0 02 28 01 A3 8F 20 00 BC 8F 23 20 72 00 EE FF 54 10 21 80 04 02 FB FF 04 24 24 20 44 00 22 00 80 10 00 00 00 00 FA FF 43 24 02 00 63 2C 0B 00 60 14 05 00 03 24 C5 FF 43 10 84 01 BF 8F ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 8B 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 84 01 BF 8F FF FF 10 24 21 10 62 00 58 00 03 24 00 00 43 AC 80 01 B7 8F 21 10 00 02 7C 01 B6 8F 78 01 B5 8F 74 01 B4 8F 70 01 B3 8F 6C 01 B2 8F 68 01 B1 8F 64 01 B0 8F 08 00 E0 03 88 01 BD 27 FF FF 62 90 A6 FF 40 10 FF FF 10 26 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 63 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 07 3C ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 02 3C ?? ?? 42 24 13 00 22 12 00 00 00 00 ?? ?? ?? 0? 21 20 20 02 ?? ?? ?? 0? 14 00 22 8E ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 80 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 04 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 7F 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 42 24 }
	condition:
		$1
}

rule file_310_0_0 {
	meta:
		name = "__brk"
		size = 76
		refs = "0008 __curbrk 0024 __gnu_local_gp 0034 __libc_errno"
	strings:
		$1 = { CD 0F 02 24 0C 00 00 00 ?? ?? 03 3C 2B 28 44 00 ?? ?? 62 AC 03 00 A0 14 21 10 00 00 08 00 E0 03 00 00 00 00 ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 0C 00 03 24 00 00 43 AC 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "putw"
		size = 52
		refs = "0018 _IO_fwrite"
	strings:
		$1 = { E0 FF BD 27 21 38 A0 00 04 00 05 24 20 00 A4 AF 01 00 06 24 1C 00 BF AF ?? ?? ?? 0? 20 00 A4 27 1C 00 BF 8F 01 00 42 2C 23 10 02 00 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "__wctype_l"
		size = 224
		refs = "0024 strlen 006c memcmp"
	strings:
		$1 = { C8 FF BD 27 1C 00 B0 AF 21 80 A0 00 30 00 B5 AF 2C 00 B4 AF 28 00 B3 AF 24 00 B2 AF 34 00 BF AF 20 00 B1 AF ?? ?? ?? 0? 21 A0 80 00 00 00 15 8E 21 98 40 00 21 90 00 00 ?? ?? ?? 0? 4C 00 B0 8E 01 00 31 26 21 80 11 02 00 00 03 82 1A 00 60 10 01 00 52 26 ?? ?? ?? 0? 21 20 00 02 F8 FF 62 16 21 88 40 00 21 28 00 02 21 20 80 02 ?? ?? ?? 0? 21 30 60 02 F3 FF 40 14 01 00 31 26 68 00 A2 8E 34 00 BF 8F 2C 00 B4 8F 21 10 42 02 08 00 42 24 80 10 02 00 21 A8 A2 02 04 00 A2 8E 28 00 B3 8F 30 00 B5 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 38 00 BD 27 34 00 BF 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 21 10 00 00 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "known_compare"
		size = 28
		refs = "000c strcmp"
	strings:
		$1 = { 04 00 85 10 00 00 00 00 00 00 84 8C ?? ?? ?? 0? 00 00 A5 8C 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_314_1_0 {
	meta:
		name = "nss_parse_service_list"
		size = 1196
		refs = "0000 __gnu_local_gp 0008 __libc_tsd_CTYPE_B 00c8 malloc 00e8 mempcpy 0264 $LC2 0270 __strncasecmp 0280 $LC3 0350 $LC5 03cc $LC0 03e8 $LC1 040c $LC4 043c free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 ?? ?? 82 8F B0 FF BD 27 3B E8 03 7C 20 00 A2 AF 21 10 60 00 20 00 A3 8F 40 00 B6 AF 44 00 B7 AF 21 10 62 00 00 00 56 8C 2C 00 B1 AF 4C 00 BF AF 48 00 BE AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 28 00 B0 AF 10 00 BC AF 21 B8 80 00 18 00 A0 AF 18 00 B1 27 00 00 E2 82 40 18 02 00 21 18 C3 02 00 00 63 94 00 20 63 30 44 00 60 14 00 00 00 00 FE 00 40 10 5B 00 03 24 FC 00 43 10 21 80 E0 02 ?? ?? ?? 0? 5B 00 04 24 00 00 63 94 00 20 63 30 08 00 60 14 00 00 00 00 06 00 44 10 00 00 00 00 01 00 10 26 00 00 02 82 40 18 02 00 F6 FF 40 14 21 18 C3 02 ED 00 F0 12 23 90 17 02 ?? ?? ?? 0? 25 00 44 26 E9 00 40 10 21 F0 40 00 24 00 42 24 21 28 E0 02 21 20 40 00 21 30 40 02 ?? ?? ?? 0? 20 00 C2 AF 01 00 03 24 00 00 40 A0 1C 00 C0 AF 04 00 C0 AF 08 00 C0 AF 0C 00 C0 AF 10 00 C3 AF 14 00 C3 AF 18 00 C0 AF 00 00 C0 AF 00 00 03 82 40 10 03 00 21 10 C2 02 00 00 42 94 00 20 42 30 0A 00 40 10 21 B8 00 02 01 00 F7 26 00 00 E3 82 40 28 03 00 21 28 C5 02 00 00 A5 94 00 20 A5 30 FA FF A0 14 01 00 F7 26 FF FF F7 26 5B 00 02 24 10 00 62 10 00 00 00 00 00 00 3E AE 21 88 C0 03 00 00 E2 82 40 18 02 00 21 18 C3 02 00 00 63 94 00 20 63 30 BE FF 60 10 00 00 00 00 ?? ?? ?? 0? 01 00 F7 26 00 00 63 94 00 20 63 30 06 00 60 10 00 00 00 00 01 00 F7 26 00 00 E2 82 40 18 02 00 F8 FF 40 14 21 18 C3 02 3B E8 03 7C 21 20 60 00 20 00 A3 8F 3D 00 14 24 5D 00 15 24 21 20 64 00 00 00 96 8C 21 00 50 38 01 00 10 2E 03 00 00 12 00 00 00 00 01 00 E2 82 01 00 F7 26 94 00 40 10 40 18 02 00 21 18 C3 02 00 00 63 94 00 20 63 30 8F 00 60 14 00 00 00 00 8D 00 54 10 00 00 00 00 8B 00 55 10 21 98 E0 02 ?? ?? ?? 0? 01 00 73 26 00 00 42 94 00 20 42 30 0A 00 40 14 00 00 00 00 08 00 B4 10 00 00 00 00 06 00 B5 10 00 00 00 00 01 00 73 26 00 00 65 82 40 10 05 00 F4 FF A0 14 21 10 C2 02 23 10 77 02 07 00 03 24 5C 00 43 10 08 00 03 24 76 00 43 14 ?? ?? 05 3C 21 20 E0 02 ?? ?? A5 24 ?? ?? ?? 0? 08 00 06 24 08 00 40 10 21 90 00 00 ?? ?? 05 3C 21 20 E0 02 ?? ?? A5 24 ?? ?? ?? 0? 08 00 06 24 69 00 40 14 FE FF 12 24 00 00 62 82 40 20 02 00 21 20 C4 02 00 00 84 94 00 20 84 30 FA FF 80 14 01 00 73 26 60 00 54 14 FF FF 73 26 01 00 73 26 00 00 62 82 40 20 02 00 21 20 C4 02 00 00 84 94 00 20 84 30 FA FF 80 14 01 00 73 26 FF FF 73 26 55 00 40 10 21 20 60 02 53 00 54 10 00 00 00 00 0C 00 55 14 01 00 73 26 ?? ?? ?? 0? 00 00 00 00 00 00 42 94 00 20 42 30 0A 00 40 14 00 00 00 00 08 00 B4 10 00 00 00 00 06 00 B5 10 00 00 00 00 01 00 73 26 00 00 65 82 40 10 05 00 F4 FF A0 14 21 10 C2 02 23 10 64 02 06 00 03 24 32 00 43 10 08 00 03 24 3C 00 43 14 21 B8 60 02 ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? 08 00 06 24 36 00 40 14 00 00 00 00 02 00 44 26 80 20 04 00 14 00 00 12 21 20 C4 03 04 00 85 8C 04 00 C2 AF 08 00 C2 AF 0C 00 C2 AF 10 00 C2 AF 04 00 85 AC ?? ?? ?? 0? 00 00 62 82 00 00 E2 82 40 18 02 00 21 18 C3 02 00 00 63 94 00 20 63 30 FA FF 60 14 01 00 F7 26 1D 00 55 10 FF FF F7 26 ?? ?? ?? 0? 00 00 E2 82 ?? ?? ?? 0? 04 00 82 AC ?? ?? 05 3C 21 20 E0 02 ?? ?? A5 24 ?? ?? ?? 0? 07 00 06 24 AE FF 40 10 01 00 12 24 ?? ?? 05 3C 21 20 E0 02 ?? ?? A5 24 ?? ?? ?? 0? 07 00 06 24 0F 00 40 14 FF FF 12 24 ?? ?? ?? 0? 00 00 62 82 ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? 06 00 06 24 07 00 40 14 21 B8 60 02 ?? ?? ?? 0? 01 00 02 24 00 00 3E AE 01 00 F7 26 ?? ?? ?? 0? 21 88 C0 03 ?? ?? ?? 0? 21 20 C0 03 4C 00 BF 8F 18 00 A2 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 4C 00 BF 8F 18 00 A2 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_314_2_0 {
	meta:
		name = "free_database_entries"
		size = 148
		refs = "0020 free 0048 __tdestroy"
	strings:
		$1 = { D0 FF BD 27 28 00 B3 AF 2C 00 BF AF 24 00 B2 AF 20 00 B1 AF 1C 00 B0 AF 17 00 80 10 21 98 80 00 ?? ?? 12 3C ?? ?? 52 26 04 00 70 8E 03 00 00 16 00 00 00 00 ?? ?? ?? 0? 00 00 70 8E 1C 00 04 8E 03 00 80 10 21 28 40 02 ?? ?? ?? 0? 00 00 00 00 00 00 11 8E ?? ?? ?? 0? 21 20 00 02 F7 FF 20 16 21 80 20 02 00 00 70 8E ?? ?? ?? 0? 21 20 60 02 ED FF 00 16 21 98 00 02 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_314_3_0 {
	meta:
		name = "__nss_database_lookup"
		size = 1164
		refs = "0004 __gnu_local_gp 00f0 strcmp 01e4 malloc 0200 $LC9 00dc $LC7 0220 _IO_new_fopen 0218 $LC8 026c __libc_tsd_CTYPE_B 02a0 __getline 02c4 __strchrnul 0374 strlen 03a8 memcpy 03f4 free 03fc _IO_new_fclose 0410 $LC6 0454 __lll_lock_wait_private"
	strings:
		$1 = { A0 FF BD 27 ?? ?? 1C 3C 38 00 B0 AF ?? ?? 10 3C 48 00 B4 AF 44 00 B3 AF 40 00 B2 AF 3C 00 B1 AF ?? ?? 9C 27 21 90 80 00 21 98 A0 00 21 A0 C0 00 21 88 E0 00 ?? ?? 03 26 5C 00 BF AF 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 10 00 BC AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 FA 00 40 14 00 00 00 00 00 00 22 8E 16 00 40 10 ?? ?? 02 26 0F 00 00 00 00 00 43 C0 00 00 01 24 00 00 41 E0 FC FF 20 10 00 00 00 00 02 00 63 28 E4 00 60 10 21 10 00 00 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 60 00 BD 27 ?? ?? 16 3C ?? ?? D5 8E 4F 00 A0 12 ?? ?? 04 3C 00 00 B6 8E 0B 00 C0 12 00 00 00 00 08 00 C5 8E ?? ?? ?? 0? 21 20 40 02 03 00 40 14 00 00 00 00 04 00 C2 8E 00 00 22 AE 00 00 D6 8E F7 FF C0 16 00 00 00 00 00 00 22 8E 1A 00 40 10 00 00 00 00 ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 C8 00 40 10 00 00 00 00 00 00 22 8E 5C 00 BF 8F 58 00 BE 8F 01 00 42 2C 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 23 10 02 00 08 00 E0 03 60 00 BD 27 11 00 60 12 00 00 00 00 00 00 B2 8E 0E 00 40 12 00 00 00 00 08 00 45 8E ?? ?? ?? 0? 21 20 60 02 03 00 40 14 00 00 00 00 04 00 42 8E 00 00 22 AE 00 00 52 8E F7 FF 40 16 00 00 00 00 00 00 22 8E D7 FF 40 14 ?? ?? 03 26 90 00 80 12 21 20 80 02 ?? ?? ?? 0? 00 00 00 00 D0 FF 40 10 00 00 22 AE ?? ?? ?? 0? 0D 00 04 24 CC FF 40 10 ?? ?? 03 3C 00 00 24 8E ?? ?? 65 8C 04 00 44 AC ?? ?? 04 3C ?? ?? 84 24 00 00 45 AC 08 00 44 AC ?? ?? ?? 0? ?? ?? 62 AC ?? ?? 05 3C ?? ?? 84 24 ?? ?? ?? 0? ?? ?? A5 24 7E 00 40 10 21 B8 40 00 00 00 42 8C 08 00 04 24 00 80 42 34 ?? ?? ?? 0? 00 00 E2 AE 24 00 A2 AF 74 00 40 10 10 00 BC 8F 3B E8 03 7C 21 10 60 00 24 00 A3 8F 1C 00 A0 AF 18 00 A0 AF 00 00 60 AC 04 00 60 AC ?? ?? 83 8F 20 00 A0 AF 0A 00 1E 24 21 18 62 00 2C 00 A3 AF ?? ?? ?? 0? 3A 00 15 24 00 00 E2 8E 10 00 42 30 58 00 40 14 00 00 00 00 1C 00 A4 27 18 00 A5 27 ?? ?? ?? 0? 21 30 E0 02 52 00 40 04 1C 00 A4 8F FF FF 42 24 21 10 82 00 00 00 43 80 4A 00 7E 10 00 00 00 00 ?? ?? ?? 0? 23 00 05 24 00 00 40 A0 1C 00 A5 8F 00 00 A2 80 EB FF 40 10 2C 00 A3 8F 00 00 64 8C 40 18 02 00 21 18 83 00 00 00 63 94 00 20 63 30 0B 00 60 10 00 00 00 00 01 00 A5 24 00 00 A2 80 40 18 02 00 21 18 83 00 00 00 63 94 00 20 63 30 FA FF 60 14 01 00 A5 24 DA FF 40 10 FF FF A5 24 D8 FF 55 10 21 18 A0 00 ?? ?? ?? 0? 01 00 63 24 0A 00 55 10 00 00 00 00 01 00 63 24 00 00 62 80 40 30 02 00 CF FF 40 10 21 30 86 00 00 00 C6 94 00 20 C6 30 F6 FF C0 10 00 00 00 00 C9 FF 65 10 21 20 A0 00 00 00 60 A0 01 00 63 24 28 00 A3 AF ?? ?? ?? 0? 34 00 A5 AF 01 00 46 24 0D 00 44 24 ?? ?? ?? 0? 30 00 A6 AF 21 18 40 00 34 00 A5 8F BC FF 40 10 30 00 A6 8F 0C 00 42 24 08 00 62 AC 21 20 40 00 ?? ?? ?? 0? 30 00 A3 AF ?? ?? ?? 0? 28 00 A4 8F 30 00 A3 8F 04 00 62 AC 20 00 A2 8F 04 00 40 10 00 00 60 AC 00 00 43 AC ?? ?? ?? 0? 20 00 A3 AF 24 00 A2 8F 00 00 43 AC ?? ?? ?? 0? 20 00 A3 AF 00 00 40 A0 ?? ?? ?? 0? 1C 00 A4 8F ?? ?? ?? 0? 1C 00 A4 8F ?? ?? ?? 0? 21 20 E0 02 24 00 B5 8F ?? ?? ?? 0? ?? ?? D5 AE ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? ?? 0? 21 20 E0 02 ?? ?? ?? 0? ?? ?? C0 AE ?? ?? 04 26 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 21 10 00 00 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? 00 00 22 8E ?? ?? 04 26 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 22 8E }
	condition:
		$1
}

rule file_314_4_0 {
	meta:
		name = "__nss_configure_lookup"
		size = 404
		refs = "0004 __gnu_local_gp 004c strcmp 0074 __libc_errno 00f8 __nss_database_custom 0160 __lll_lock_wait_private"
	strings:
		$1 = { C0 FF BD 27 ?? ?? 1C 3C 34 00 B4 AF ?? ?? 14 3C ?? ?? 9C 27 ?? ?? 94 26 38 00 B5 AF 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 24 00 B0 AF 3C 00 BF AF 10 00 BC AF 21 90 80 00 21 A8 A0 00 21 88 80 02 21 80 00 00 0E 00 13 24 21 28 20 02 ?? ?? ?? 0? 21 20 40 02 15 00 40 10 10 00 BC 8F 03 00 40 04 01 00 10 26 F8 FF 13 16 10 00 31 26 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 3C 00 BF 8F 38 00 B5 8F 21 10 62 00 16 00 03 24 00 00 43 AC 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F FF FF 02 24 08 00 E0 03 40 00 BD 27 00 11 10 00 21 A0 82 02 0C 00 92 8E 20 00 40 12 21 10 00 00 ?? ?? ?? 0? 21 20 A0 02 E8 FF 40 10 10 00 BC 8F ?? ?? 11 3C ?? ?? 24 26 00 00 83 C0 01 00 61 24 00 00 81 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 1B 00 60 14 ?? ?? 24 26 ?? ?? 03 3C ?? ?? 63 24 21 80 03 02 00 00 42 AE ?? ?? 23 26 01 00 02 24 00 00 02 A2 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 0F 00 40 10 ?? ?? 24 26 21 10 00 00 3C 00 BF 8F 38 00 B5 8F 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? ?? 0? 18 00 A2 AF ?? ?? ?? 0? 18 00 A2 8F 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_314_5_0 {
	meta:
		name = "__nss_lookup_function"
		size = 932
		refs = "0004 __gnu_local_gp 0080 __tsearch 0100 malloc 0140 strlen 015c $LC12 0194 stpcpy 01ac strcpy 01bc __libc_dlsym 0220 strcmp 0244 __tdelete 0250 free 0274 $LC10 02a0 __libc_errno 02c0 $LC11 02f4 __libc_dlopen_mode 0394 __lll_lock_wait_private"
	strings:
		$1 = { C0 FF BD 27 ?? ?? 1C 3C 18 00 B0 AF ?? ?? 10 3C 38 00 BE AF 24 00 B3 AF 21 F0 A0 03 ?? ?? 9C 27 21 98 80 00 ?? ?? 03 26 3C 00 BF AF 34 00 B7 AF 30 00 B6 AF 2C 00 B5 AF 28 00 B4 AF 20 00 B2 AF 1C 00 B1 AF 10 00 DC AF 44 00 C5 AF 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 CB 00 40 14 00 00 00 00 1C 00 74 26 44 00 D2 27 ?? ?? 15 3C 21 20 40 02 21 28 80 02 ?? ?? ?? 0? ?? ?? A6 26 55 00 40 10 21 88 40 00 00 00 42 8C 1A 00 52 10 00 00 00 00 04 00 51 8C ?? ?? 03 26 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 AB 00 40 10 ?? ?? 04 26 21 E8 C0 03 3C 00 BF 8F 21 10 20 02 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? ?? 0? 08 00 04 24 4C 00 40 10 21 B0 40 00 00 00 22 AE 18 00 71 8E 44 00 C2 8F 32 00 20 12 00 00 C2 AE 04 00 22 8E 4D 00 40 10 00 00 00 00 FF FF 03 24 27 00 43 10 00 00 00 00 20 00 64 8E ?? ?? ?? 0? 21 90 A0 03 44 00 C4 8F ?? ?? ?? 0? 21 88 40 00 21 10 22 02 0E 00 44 24 ?? ?? 03 3C C2 20 04 00 ?? ?? 62 8C C0 20 04 00 ?? ?? 63 24 23 E8 A4 03 04 00 64 90 05 00 63 90 10 00 B1 27 13 00 A2 AB 00 00 22 BA 04 00 24 A2 05 00 23 A2 20 00 65 8E ?? ?? ?? 0? 15 00 A4 27 5F 00 03 24 00 00 43 A0 01 00 40 A0 44 00 C5 8F ?? ?? ?? 0? 01 00 44 24 18 00 62 8E 21 28 20 02 ?? ?? ?? 0? 04 00 44 8C 21 88 40 00 21 E8 40 02 ?? ?? ?? 0? 04 00 D1 AE 21 88 00 00 ?? ?? ?? 0? 04 00 D1 AE ?? ?? ?? 0? 21 88 00 00 ?? ?? 02 3C ?? ?? 42 8C 59 00 40 10 00 00 00 00 04 00 51 8C 07 00 20 16 20 00 77 8E ?? ?? ?? 0? 04 00 51 24 08 00 22 8E 43 00 40 10 08 00 31 26 21 88 40 00 00 00 24 8E ?? ?? ?? 0? 21 28 E0 02 F8 FF 40 14 00 00 00 00 ?? ?? ?? 0? 18 00 71 AE 18 00 60 AE 21 20 40 02 21 28 80 02 ?? ?? ?? 0? ?? ?? A6 26 21 20 C0 02 ?? ?? ?? 0? 21 88 00 00 ?? ?? ?? 0? ?? ?? 03 26 20 00 64 8E ?? ?? ?? 0? 21 A8 A0 03 14 00 42 24 C2 20 02 00 ?? ?? 02 3C ?? ?? 43 8C C0 20 04 00 ?? ?? 42 24 23 E8 A4 03 04 00 42 8C 10 00 DC 8F 10 00 B1 27 13 00 A3 AB 00 00 23 BA 07 00 22 AA ?? ?? 94 8F 04 00 22 BA 20 00 65 8E 3B E8 03 7C 17 00 A4 27 21 A0 83 02 ?? ?? ?? 0? 00 00 92 8E ?? ?? 03 3C ?? ?? 63 8C 03 00 44 24 00 80 05 3C 03 00 43 A8 00 00 43 B8 2E 00 03 24 03 00 43 A0 32 00 02 24 01 00 82 A0 02 00 80 A0 18 00 77 8E 21 20 20 02 ?? ?? ?? 0? 01 00 A5 24 04 00 E2 AE 18 00 62 8E 04 00 43 8C 16 00 60 10 FF FF 03 24 18 00 62 8E 21 E8 A0 02 ?? ?? ?? 0? 04 00 42 8C ?? ?? ?? 0? 0C 00 04 24 C3 FF 40 10 00 00 22 AE 00 00 57 AC 00 00 22 8E 04 00 40 AC 00 00 22 8E 08 00 40 AC 00 00 31 8E 76 FF 20 16 18 00 71 AE ?? ?? ?? 0? 21 20 40 02 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 42 24 04 00 43 AC ?? ?? ?? 0? 00 00 92 AE 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 21 E8 C0 03 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? 1C 00 74 26 }
	condition:
		$1
}

rule file_314_6_0 {
	meta:
		name = "__nss_lookup"
		size = 272
		refs = "0028 __nss_lookup_function"
	strings:
		$1 = { D0 FF BD 27 1C 00 B0 AF 21 80 80 00 00 00 84 8C 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF 2C 00 BF AF 21 88 E0 00 21 90 A0 00 ?? ?? ?? 0? 21 98 C0 00 30 00 40 10 00 00 22 AE 14 00 40 14 2C 00 BF 8F 00 00 02 8E 08 00 43 8C 17 00 60 14 21 28 40 02 00 00 42 8C 1F 00 40 10 21 20 40 00 ?? ?? ?? 0? 00 00 02 AE F4 FF 40 14 00 00 22 AE F4 FF 60 12 00 00 00 00 00 00 04 8E ?? ?? ?? 0? 21 28 60 02 EF FF 40 10 00 00 22 AE 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 21 10 00 00 08 00 E0 03 30 00 BD 27 00 00 44 8C 2C 00 BF 8F FF FF 03 24 01 00 02 24 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 0B 10 64 00 08 00 E0 03 30 00 BD 27 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 01 00 02 24 08 00 E0 03 30 00 BD 27 D0 FF 60 12 00 00 00 00 00 00 04 8E ?? ?? ?? 0? 21 28 60 02 ?? ?? ?? 0? 00 00 22 AE }
	condition:
		$1
}

rule file_314_7_0 {
	meta:
		name = "__nss_next2"
		size = 336
		refs = "0054 __nss_lookup_function 0148 __libc_fatal 0144 $LC13"
	strings:
		$1 = { D0 FF BD 27 44 00 A2 8F 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF 1C 00 B0 AF 2C 00 BF AF 21 80 80 00 21 90 A0 00 21 98 C0 00 28 00 40 10 21 88 E0 00 00 00 82 8C 01 00 04 24 04 00 43 8C 36 00 64 10 00 00 00 00 00 00 44 8C 19 00 80 10 2C 00 BF 8F 00 00 04 AE ?? ?? ?? 0? 21 28 40 02 09 00 40 10 00 00 22 AE 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 21 10 00 00 08 00 E0 03 30 00 BD 27 06 00 60 12 00 00 00 00 00 00 04 8E ?? ?? ?? 0? 21 28 60 02 F2 FF 40 14 00 00 22 AE 00 00 02 8E 08 00 43 8C E6 FF 60 10 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F FF FF 02 24 08 00 E0 03 30 00 BD 27 40 00 A3 8F 02 00 63 24 05 00 62 2C 1A 00 40 10 80 18 03 00 00 00 82 8C 21 18 43 00 04 00 64 8C 01 00 03 24 D4 FF 83 14 00 00 00 00 01 00 02 24 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 08 00 44 8C C9 FF 83 14 00 00 00 00 0C 00 43 8C C6 FF 64 14 00 00 00 00 10 00 44 8C C3 FF 83 14 00 00 00 00 ?? ?? ?? 0? 01 00 02 24 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 }
	condition:
		$1
}

rule file_314_8_0 {
	meta:
		name = "free_defconfig"
		size = 32
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 44 8C 03 00 80 10 00 00 00 00 ?? ?? ?? 0? ?? ?? 40 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_314_9_0 {
	meta:
		name = "free_mem"
		size = 188
		refs = "0044 free 006c __libc_dlclose"
	strings:
		$1 = { D8 FF BD 27 ?? ?? 02 3C 20 00 B2 AF ?? ?? 52 8C 24 00 BF AF 1C 00 B1 AF 22 00 40 12 18 00 B0 AF 00 00 44 8E ?? ?? ?? 0? ?? ?? 40 AC 04 00 50 8E 09 00 00 16 24 00 BF 8F ?? ?? ?? 0? 1C 00 B1 8F 08 00 11 8E ?? ?? ?? 0? 21 20 00 02 0F 00 20 12 24 00 BF 8F 21 80 20 02 04 00 04 8E FF FF 82 24 FE FF 42 2C F6 FF 40 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 11 8E ?? ?? ?? 0? 21 20 00 02 F5 FF 20 16 21 80 20 02 24 00 BF 8F 1C 00 B1 8F 18 00 B0 8F 21 20 40 02 20 00 B2 8F ?? ?? ?? 0? 28 00 BD 27 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_314_10_0 {
	meta:
		name = "__nss_next"
		size = 48
		refs = "001c __nss_next2"
	strings:
		$1 = { D8 FF BD 27 38 00 A3 8F 21 10 C0 00 10 00 A7 AF 14 00 A3 AF 21 30 00 00 24 00 BF AF ?? ?? ?? 0? 21 38 40 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_315_0_0 {
	meta:
		name = "__sleep"
		size = 700
		refs = "0000 __gnu_local_gp 005c memset 0070 __sigaction 0094 __sigprocmask 00a0 __nanosleep 0158 __libc_errno 02b4 __pthread_unwind"
	strings:
		$1 = { ?? ?? 1C 3C 38 FE BD 27 ?? ?? 9C 27 B4 01 B0 AF C4 01 BF AF C0 01 B3 AF BC 01 B2 AF B8 01 B1 AF 10 00 BC AF 88 00 80 10 21 80 80 00 FF 7F 13 3C AC 01 A0 AF 21 18 00 00 FF FF 73 36 00 80 12 3C ?? ?? ?? 0? 02 00 11 3C 24 10 51 00 14 00 40 14 A8 01 A4 27 28 01 A4 27 21 28 00 00 ?? ?? ?? 0? 80 00 06 24 12 00 04 24 21 28 00 00 18 00 A6 27 ?? ?? ?? 0? 28 01 B1 AF 57 00 40 04 10 00 BC 8F 1C 00 A3 8F 01 00 02 24 24 00 62 10 03 00 04 24 A8 00 A5 27 ?? ?? ?? 0? 21 30 00 00 A8 01 A4 27 ?? ?? ?? 0? 21 28 80 00 35 00 40 14 AC 01 A3 8F 41 00 00 12 A8 01 A3 8F 2B 10 12 02 21 20 60 02 0B 20 02 02 21 10 83 00 21 28 00 00 28 01 A4 27 80 00 06 24 A8 01 A2 AF ?? ?? ?? 0? 23 80 02 02 01 00 04 24 28 01 A5 27 A8 00 A6 27 ?? ?? ?? 0? 28 01 B1 AF D4 FF 40 10 A8 00 A2 8F FF FF 02 24 C4 01 BF 8F C0 01 B3 8F BC 01 B2 8F B8 01 B1 8F B4 01 B0 8F 08 00 E0 03 C8 01 BD 27 FF 7F 11 3C ?? ?? ?? 0? FF FF 31 36 3C 00 00 12 21 18 00 02 2B 10 11 02 0A 18 22 02 AC 01 A2 8F A8 01 A3 AF 23 80 02 02 A8 01 A4 27 ?? ?? ?? 0? 21 28 80 00 F5 FF 40 10 10 00 BC 8F ?? ?? 91 8F 3B E8 03 7C 03 00 04 24 21 88 23 02 00 00 32 8E A8 00 A5 27 ?? ?? ?? 0? 21 30 00 00 00 00 32 AE AC 01 A3 8F CD 1D 02 3C 00 65 42 24 2A 18 62 00 A8 01 A2 8F C4 01 BF 8F 01 00 63 38 21 10 62 00 21 10 50 00 C0 01 B3 8F BC 01 B2 8F B8 01 B1 8F B4 01 B0 8F 08 00 E0 03 C8 01 BD 27 C4 01 BF 8F C0 01 B3 8F BC 01 B2 8F B8 01 B1 8F B4 01 B0 8F 21 10 00 00 08 00 E0 03 C8 01 BD 27 ?? ?? 90 8F 3B E8 03 7C A8 00 A5 27 21 80 03 02 03 00 04 24 21 30 00 00 ?? ?? ?? 0? 00 00 11 8E C4 01 BF 8F 00 00 11 AE C0 01 B3 8F BC 01 B2 8F B8 01 B1 8F B4 01 B0 8F FF FF 02 24 08 00 E0 03 C8 01 BD 27 ?? ?? 90 8F 3B E8 03 7C 03 00 04 24 21 80 03 02 00 00 11 8E A8 00 A5 27 ?? ?? ?? 0? 21 30 00 00 00 00 11 AE ?? ?? ?? 0? 21 10 00 00 3B E8 03 7C F4 8B 63 8C B9 FF 02 24 24 18 62 00 08 00 02 24 D7 FF 62 14 C4 01 BF 8F 3B E8 03 7C FF FF 02 24 90 8D 62 AC 3B E8 03 7C F4 8B 62 24 F4 8B 64 8C 10 00 87 34 18 00 A4 AF 00 00 45 C0 06 00 A4 14 00 00 06 24 21 08 E0 00 00 00 41 E0 FA FF 20 10 01 00 06 24 0F 00 00 00 03 00 C0 14 00 00 00 00 ?? ?? ?? 0? 18 00 A5 AF ?? ?? ?? 0? F0 8B 64 8C }
	condition:
		$1
}

rule file_316_0_0 {
	meta:
		name = "posix_spawnattr_getschedparam"
		size = 28
	strings:
		$1 = { 08 01 84 24 03 00 83 88 21 10 00 00 00 00 83 98 03 00 A3 A8 08 00 E0 03 00 00 A3 B8 }
	condition:
		$1
}

rule file_317_0_0 {
	meta:
		name = "skip_string"
		size = 148
		refs = "000c __gnu_local_gp 0014 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 21 10 80 00 00 00 84 80 20 00 80 10 ?? ?? 1C 3C ?? ?? 9C 27 ?? ?? 86 8F 3B E8 03 7C 21 28 60 00 21 28 C5 00 00 00 A5 8C 40 18 04 00 21 18 A3 00 00 00 63 94 00 20 63 30 14 00 60 14 23 00 03 24 12 00 83 10 2C 00 03 24 10 00 83 10 23 00 06 24 ?? ?? ?? 0? 2C 00 07 24 00 00 84 94 00 20 84 30 0A 00 80 14 00 00 00 00 08 00 66 10 00 00 00 00 06 00 67 10 00 00 00 00 01 00 42 24 00 00 43 80 40 20 03 00 F4 FF 60 14 21 20 A4 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_317_1_0 {
	meta:
		name = "arg_trimdomain_list"
		size = 576
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_CTYPE_B 0018 _res_hconf 0088 __strndup 017c _libc_intl_domainname 0180 $LC0 018c __dcgettext 01a8 __asprintf 01c4 __fxprintf 01bc $LC1 01cc free 0208 $LC2"
	strings:
		$1 = { ?? ?? 1C 3C B0 FF BD 27 ?? ?? 9C 27 34 00 B2 AF ?? ?? 92 8F 30 00 B1 AF ?? ?? 11 3C ?? ?? 31 26 3B E8 03 7C 40 00 B5 AF 3C 00 B4 AF 38 00 B3 AF 2C 00 B0 AF 4C 00 BF AF 48 00 B7 AF 44 00 B6 AF 18 00 BC AF 21 A8 80 00 21 A0 A0 00 21 40 C0 00 21 80 20 02 21 90 43 02 01 00 13 24 ?? ?? ?? 0? 21 20 00 01 18 00 36 8E 21 B8 40 00 23 28 48 00 04 00 C2 2A 41 00 40 10 01 00 C2 26 06 00 D6 26 21 20 00 01 18 00 02 AE ?? ?? ?? 0? 80 B0 16 00 21 B0 16 02 04 00 C2 AE 00 00 E3 82 00 00 44 8E 40 10 03 00 21 10 82 00 00 00 42 94 00 20 42 30 0A 00 40 10 21 40 E0 02 01 00 08 25 00 00 03 81 40 10 03 00 21 10 82 00 00 00 42 94 00 20 42 30 FA FF 40 14 01 00 08 25 FF FF 08 25 D4 FF 63 24 FF 00 63 30 10 00 62 2C 13 00 40 10 04 18 73 00 01 C0 63 30 10 00 60 10 00 00 00 00 01 00 02 81 ?? ?? ?? 0? 01 00 08 25 00 00 02 81 40 18 02 00 21 18 83 00 00 00 63 94 00 20 63 30 FA FF 60 14 01 00 08 25 FF FF 08 25 36 00 40 10 23 00 03 24 34 00 43 10 00 00 00 00 00 00 02 81 04 00 40 10 4C 00 BF 8F 23 00 03 24 C4 FF 43 14 00 00 00 00 48 00 B7 8F 44 00 B6 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 21 10 00 01 08 00 E0 03 50 00 BD 27 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 04 00 03 24 10 00 A3 AF 20 00 A4 27 21 28 40 00 21 30 A0 02 ?? ?? ?? 0? 21 38 80 02 09 00 40 04 4C 00 BF 8F 20 00 A6 8F ?? ?? 05 3C 21 20 00 00 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? 20 00 A4 8F 4C 00 BF 8F 48 00 B7 8F 44 00 B6 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 21 10 00 00 08 00 E0 03 50 00 BD 27 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 21 28 40 00 20 00 A4 27 21 30 A0 02 ?? ?? ?? 0? 21 38 80 02 E2 FF 41 04 20 00 A6 8F ?? ?? ?? 0? 4C 00 BF 8F }
	condition:
		$1
}

rule file_317_2_0 {
	meta:
		name = "arg_spoof.isra.0"
		size = 244
		refs = "002c _res_hconf 0048 $LC4 0080 __strncasecmp 0098 $LC3"
	strings:
		$1 = { D8 FF BD 27 21 40 80 00 18 00 B0 AF 24 00 BF AF 20 00 B2 AF ?? ?? ?? 0? 1C 00 B1 AF 21 80 40 00 03 00 03 24 23 10 48 00 1B 00 43 10 ?? ?? 11 3C ?? ?? 31 26 2C 00 32 8E 06 00 43 36 2C 00 23 AE 04 00 03 24 0C 00 43 10 ?? ?? 05 3C FB FF 02 24 24 90 42 02 02 00 52 36 2C 00 32 AE 24 00 BF 8F 21 10 00 02 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 21 20 00 01 ?? ?? A5 24 ?? ?? ?? 0? 04 00 06 24 F1 FF 40 14 FB FF 02 24 ?? ?? ?? 0? 24 00 BF 8F ?? ?? 05 3C 21 20 00 01 ?? ?? A5 24 ?? ?? ?? 0? 03 00 06 24 04 00 40 10 ?? ?? 11 3C ?? ?? 31 26 ?? ?? ?? 0? 2C 00 32 8E ?? ?? 02 3C ?? ?? 42 24 2C 00 44 8C 24 00 BF 8F F9 FF 03 24 24 18 83 00 2C 00 43 AC 20 00 B2 8F 21 10 00 02 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_317_3_0 {
	meta:
		name = "arg_bool"
		size = 284
		refs = "000c $LC5 0034 __strncasecmp 0044 _res_hconf 0040 $LC3 00c4 _libc_intl_domainname 00c8 $LC6 00d4 __dcgettext 00ec __asprintf 0104 __fxprintf 00fc $LC1 010c free"
	strings:
		$1 = { C0 FF BD 27 34 00 B2 AF 21 90 A0 00 ?? ?? 05 3C 38 00 B3 AF 2C 00 B0 AF 21 98 80 00 21 80 C0 00 21 20 C0 00 ?? ?? A5 24 02 00 06 24 30 00 B1 AF 3C 00 BF AF ?? ?? ?? 0? 21 88 E0 00 0E 00 40 14 ?? ?? 05 3C ?? ?? 03 3C ?? ?? 63 24 2C 00 64 8C 02 00 02 26 25 88 24 02 2C 00 71 AC 3C 00 BF 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 21 20 00 02 ?? ?? A5 24 ?? ?? ?? 0? 03 00 06 24 0E 00 40 14 ?? ?? 03 3C ?? ?? 63 24 2C 00 64 8C 3C 00 BF 8F 27 88 11 00 24 88 24 02 03 00 02 26 38 00 B3 8F 34 00 B2 8F 2C 00 B0 8F 2C 00 71 AC 30 00 B1 8F 08 00 E0 03 40 00 BD 27 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? 0? 05 00 06 24 21 28 40 00 10 00 B0 AF 20 00 A4 27 21 30 60 02 ?? ?? ?? 0? 21 38 40 02 07 00 40 04 20 00 A6 8F ?? ?? 05 3C 21 20 00 00 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? ?? 0? 20 00 A4 8F ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_317_4_0 {
	meta:
		name = "do_init"
		size = 1032
		refs = "0008 __gnu_local_gp 000c $LC8 001c _res_hconf 0074 getenv 008c _IO_new_fopen 0088 $LC9 00a0 __libc_tsd_CTYPE_B 00d4 fgets_unlocked 00e8 __strchrnul 016c __strncasecmp 017c strlen 019c $LC16 0198 _libc_intl_domainname 01a8 __dcgettext 01c0 __asprintf 01d0 $LC1 01d8 __fxprintf 01e0 free 0200 _IO_new_fclose 0208 $LC11 0218 $LC12 0250 $LC13 0274 $LC14 0294 $LC15 03a8 $LC10 03f8 $LC7"
	strings:
		$1 = { A8 FE BD 27 ?? ?? 02 3C ?? ?? 1C 3C ?? ?? 04 3C ?? ?? 9C 27 40 01 B4 AF ?? ?? 84 24 ?? ?? 54 24 ?? ?? 40 AC 54 01 BF AF 50 01 BE AF 4C 01 B7 AF 48 01 B6 AF 44 01 B5 AF 3C 01 B3 AF 38 01 B2 AF 34 01 B1 AF 30 01 B0 AF 18 00 BC AF 04 00 80 AE 08 00 80 AE 0C 00 80 AE 10 00 80 AE 14 00 80 AE 18 00 80 AE 1C 00 80 AE 20 00 80 AE 24 00 80 AE 28 00 80 AE ?? ?? ?? 0? 2C 00 80 AE DE 00 40 10 2C 01 A2 AF 2C 01 A4 8F ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 21 98 40 00 5B 00 40 10 18 00 BC 8F ?? ?? 95 8F 00 00 44 8C 3B E8 03 7C 21 A8 A3 02 ?? ?? 03 3C 00 80 84 34 ?? ?? 63 24 00 00 64 AE 21 88 00 00 28 01 B5 AF 70 00 72 24 20 00 A4 27 00 01 05 24 ?? ?? ?? 0? 21 30 60 02 48 00 40 10 00 00 00 00 20 00 A4 27 ?? ?? ?? 0? 0A 00 05 24 00 00 40 A0 28 01 A2 8F 20 00 A3 83 00 00 55 8C 40 10 03 00 21 10 A2 02 00 00 42 94 00 20 42 30 AD 00 40 10 01 00 31 26 21 00 A2 27 00 00 43 80 21 F0 40 00 40 28 03 00 21 28 A5 02 00 00 A5 94 00 20 A5 30 F9 FF A0 14 01 00 42 24 E3 FF 60 10 23 00 02 24 E1 FF 62 10 00 00 00 00 ?? ?? ?? 0? 21 20 C0 03 ?? ?? 16 3C 21 B8 40 00 23 80 5E 00 ?? ?? D6 26 21 20 C0 03 21 28 C0 02 ?? ?? ?? 0? 21 30 00 02 05 00 40 14 21 20 C0 02 ?? ?? ?? 0? 00 00 00 00 59 00 02 12 00 00 00 00 10 00 D6 26 F5 FF D2 16 21 20 C0 03 ?? ?? 04 3C ?? ?? 05 3C ?? ?? A5 24 ?? ?? 84 24 ?? ?? ?? 0? 05 00 06 24 21 28 40 00 10 00 BE AF 2C 01 A6 8F 20 01 A4 27 ?? ?? ?? 0? 21 38 20 02 C0 FF 40 04 20 01 A6 8F ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? 21 20 00 00 ?? ?? ?? 0? 20 01 A4 8F 20 00 A4 27 00 01 05 24 ?? ?? ?? 0? 21 30 60 02 BA FF 40 14 00 00 00 00 ?? ?? ?? 0? 21 20 60 02 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 04 00 40 10 ?? ?? 10 3C ?? ?? ?? 0? 21 20 40 00 ?? ?? 10 3C ?? ?? ?? 0? ?? ?? 04 26 05 00 40 10 ?? ?? 04 26 01 00 05 24 21 30 40 00 ?? ?? ?? 0? 10 00 07 24 ?? ?? 10 3C ?? ?? ?? 0? ?? ?? 04 26 05 00 40 10 ?? ?? 04 26 01 00 05 24 21 30 40 00 ?? ?? ?? 0? 08 00 07 24 ?? ?? 10 3C ?? ?? ?? 0? ?? ?? 04 26 04 00 40 10 ?? ?? 04 26 01 00 05 24 ?? ?? ?? 0? 21 30 40 00 ?? ?? 10 3C ?? ?? ?? 0? ?? ?? 04 26 05 00 40 10 ?? ?? 04 26 01 00 05 24 21 30 40 00 ?? ?? ?? 0? 18 00 80 AE 54 01 BF 8F 01 00 02 24 ?? ?? 03 3C 50 01 BE 8F 4C 01 B7 8F 48 01 B6 8F 44 01 B5 8F 40 01 B4 8F 3C 01 B3 8F 38 01 B2 8F 34 01 B1 8F 30 01 B0 8F ?? ?? 62 AC 08 00 E0 03 58 01 BD 27 00 00 E2 82 40 10 02 00 21 10 A2 02 00 00 42 94 00 20 42 30 FA FF 40 14 01 00 F7 26 FF FF F7 26 0B 00 C2 92 01 00 04 24 2E 00 44 10 02 00 04 24 32 00 44 10 03 00 04 24 6A FF 44 14 20 00 A4 27 0C 00 C7 8E 2C 01 A4 8F 21 28 20 02 ?? ?? ?? 0? 21 30 E0 02 21 80 40 00 62 FF 00 12 20 00 A4 27 00 00 03 82 5F FF 60 10 28 01 A2 8F 00 00 44 8C 40 10 03 00 21 10 82 00 00 00 42 94 00 20 42 30 0B 00 40 10 00 00 00 00 01 00 10 26 00 00 03 82 40 10 03 00 52 FF 60 10 21 10 82 00 00 00 42 94 00 20 42 30 F9 FF 40 14 01 00 10 26 FF FF 10 26 23 00 02 24 4A FF 62 10 ?? ?? 04 3C ?? ?? 05 3C ?? ?? A5 24 ?? ?? 84 24 ?? ?? ?? 0? 05 00 06 24 21 28 40 00 ?? ?? ?? 0? 10 00 B0 AF ?? ?? ?? 0? 20 00 BE 27 2C 01 A4 8F 21 28 20 02 ?? ?? ?? 0? 21 30 E0 02 ?? ?? ?? 0? 21 80 40 00 ?? ?? ?? 0? 21 20 E0 02 ?? ?? ?? 0? 21 80 40 00 ?? ?? 16 3C ?? ?? D6 26 ?? ?? ?? 0? 2C 01 B6 AF }
	condition:
		$1
}

rule file_317_5_0 {
	meta:
		name = "_res_hconf_init"
		size = 92
		refs = "0000 __pthread_once"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 05 00 40 10 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? ?? 0? ?? ?? A5 24 E0 FF BD 27 18 00 B0 AF ?? ?? 10 3C ?? ?? 02 8E 06 00 40 14 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 02 8E 02 00 42 34 ?? ?? 02 AE 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_317_6_0 {
	meta:
		name = "_res_hconf_reorder_addrs"
		size = 936
		refs = "0000 _res_hconf 0018 __gnu_local_gp 0098 __libc_errno 0174 __socket 01b8 __close 01d8 __ifreq 01f8 malloc 0298 __ioctl 02e0 realloc 02f4 free 0378 __lll_lock_wait_private 0388 $LC17 038c $LC18 03a0 __assert_fail 0390 __PRETTY_FUNCTION__.12955"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C 08 00 42 30 1D 00 40 10 02 00 02 24 08 00 83 8C ?? ?? 1C 3C A0 FF BD 27 ?? ?? 9C 27 38 00 B0 AF 5C 00 BF AF 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF 40 00 B2 AF 3C 00 B1 AF 10 00 BC AF 0E 00 62 10 21 80 80 00 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 60 00 BD 27 08 00 E0 03 00 00 00 00 ?? ?? 11 3C ?? ?? 28 8E 32 00 00 19 ?? ?? 95 8F 10 00 0B 8E 00 00 6D 8D EC FF A0 11 ?? ?? 02 3C ?? ?? 49 8C 04 00 6C 25 21 50 A0 01 13 00 00 19 00 00 00 00 00 00 44 8D 04 00 22 8D 08 00 23 8D 26 10 82 00 24 10 43 00 13 00 40 10 21 18 20 01 ?? ?? ?? 0? 21 10 00 00 10 00 67 8C 14 00 66 8C 26 28 87 00 24 28 A6 00 0B 00 A0 10 0C 00 63 24 01 00 42 24 F8 FF 48 14 00 00 00 00 21 58 80 01 04 00 8C 25 FC FF 8A 8D E8 FF 40 15 5C 00 BF 8F ?? ?? ?? 0? 58 00 BE 8F 00 00 6D AD 10 00 02 8E 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 00 00 4A AC ?? ?? ?? 0? 60 00 BD 27 3B E8 03 7C 02 00 04 24 21 10 A3 02 01 00 05 24 21 30 00 00 ?? ?? ?? 0? 00 00 56 8C B6 FF 40 04 21 A0 40 00 ?? ?? 1E 3C ?? ?? C3 27 00 00 62 C0 01 00 41 24 00 00 61 E0 FC FF 20 10 00 00 00 00 0F 00 00 00 74 00 40 14 00 00 00 00 ?? ?? 22 8E 08 00 40 18 1C 00 A4 27 ?? ?? ?? 0? 21 20 80 02 ?? ?? 28 8E A5 FF 00 11 5C 00 BF 8F ?? ?? ?? 0? 10 00 0B 8E 18 00 A5 27 ?? ?? ?? 0? 21 30 80 02 1C 00 AA 8F 60 00 40 11 18 00 A2 8F 30 00 AA AF 80 20 02 00 00 11 02 00 ?? ?? ?? 0? 23 20 44 00 ?? ?? 04 3C ?? ?? 82 AC 59 00 40 10 30 00 AA 8F 18 00 A5 8F 30 00 A0 18 21 20 40 00 10 00 43 25 21 90 40 01 21 B8 00 00 21 98 00 00 02 00 09 24 ?? ?? ?? 0? 20 00 A3 AF 00 19 17 00 23 18 62 00 01 00 73 26 2A 10 65 02 25 00 40 10 20 00 52 26 10 00 42 96 F8 FF 49 14 80 10 17 00 00 19 17 00 23 18 62 00 21 10 83 00 20 00 A4 8F 23 58 4A 02 00 00 49 AC 21 58 64 01 04 00 66 8D 21 20 80 02 1B 89 05 34 04 00 46 AC 21 30 40 02 28 00 A3 AF 2C 00 A9 AF 30 00 AA AF ?? ?? ?? 0? 24 00 AB AF 28 00 A3 8F 2C 00 A9 8F 30 00 AA 8F 2A 00 40 04 24 00 AB 8F ?? ?? 02 3C ?? ?? 44 8C 04 00 66 8D 18 00 A5 8F 21 10 83 00 08 00 46 AC 01 00 F7 26 ?? ?? ?? 0? 0C 00 63 24 21 18 00 00 21 B8 00 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 03 3C 26 00 40 10 ?? ?? 62 AC ?? ?? ?? 0? 1C 00 A4 8F 3B E8 03 7C 21 10 A3 02 ?? ?? C4 27 00 00 56 AC ?? ?? 37 AE 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 A2 FF 40 14 ?? ?? C4 27 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 02 3C ?? ?? 44 8C ?? ?? ?? 0? 18 00 A5 8F ?? ?? ?? 0? 21 B8 00 00 ?? ?? ?? 0? 21 B8 00 00 ?? ?? ?? 0? ?? ?? C4 27 ?? ?? ?? 0? ?? ?? 22 8E ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 C6 01 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_317_7_0 {
	meta:
		name = "_res_hconf_trim_domain"
		size = 224
		refs = "0024 strlen 002c _res_hconf 0074 __strcasecmp"
	strings:
		$1 = { C8 FF BD 27 30 00 B6 AF 2C 00 B5 AF 34 00 BF AF 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF ?? ?? ?? 0? 21 B0 80 00 ?? ?? 03 3C ?? ?? 75 8C 15 00 A0 1A ?? ?? 10 3C 21 98 40 00 ?? ?? 10 26 21 88 00 00 00 00 12 8E 01 00 31 26 04 00 10 26 ?? ?? ?? 0? 21 20 40 02 23 A0 62 02 21 A0 D4 02 2B 10 53 00 21 20 80 02 05 00 40 10 21 28 40 02 ?? ?? ?? 0? 00 00 00 00 0D 00 40 10 00 00 00 00 F0 FF 35 16 00 00 00 00 34 00 BF 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 38 00 BD 27 00 00 80 A2 34 00 BF 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_317_8_0 {
	meta:
		name = "_res_hconf_trim_domains"
		size = 116
		refs = "0000 _res_hconf 002c _res_hconf_trim_domain"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C 03 00 40 14 00 00 00 00 08 00 E0 03 00 00 00 00 D8 FF BD 27 20 00 B1 AF 21 88 80 00 00 00 84 8C 24 00 BF AF ?? ?? ?? 0? 1C 00 B0 AF 04 00 22 8E 00 00 44 8C 08 00 80 10 04 00 10 24 ?? ?? ?? 0? 00 00 00 00 04 00 22 8E 21 10 50 00 00 00 44 8C FA FF 80 14 04 00 10 26 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_318_0_0 {
	meta:
		name = "__isoc99_vswscanf"
		size = 156
		refs = "0000 _IO_wstr_jumps 003c _IO_no_init 0048 _IO_fwide 005c _IO_wstr_init_static 007c _IO_vfwscanf"
	strings:
		$1 = { ?? ?? 02 3C 68 FE BD 27 ?? ?? 42 24 20 00 A7 27 90 01 B2 AF 8C 01 B1 AF 88 01 B0 AF 21 90 80 00 21 88 A0 00 21 80 C0 00 E0 00 A4 27 21 30 00 00 10 00 A2 AF 00 80 05 34 94 01 BF AF ?? ?? ?? 0? 28 01 A0 AF E0 00 A4 27 ?? ?? ?? 0? 01 00 05 24 E0 00 A4 27 21 28 40 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 1C 01 A2 8F E0 00 A4 27 21 28 20 02 21 30 00 02 10 00 42 34 21 38 00 00 ?? ?? ?? 0? 1C 01 A2 AF 94 01 BF 8F 90 01 B2 8F 8C 01 B1 8F 88 01 B0 8F 08 00 E0 03 98 01 BD 27 }
	condition:
		$1
}

rule file_320_0_0 {
	meta:
		name = "flush_cleanup"
		size = 232
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C 0B 00 40 10 ?? ?? 04 3C 00 00 43 8C 00 80 63 30 07 00 60 14 00 00 00 00 48 00 44 8C 04 00 82 8C FF FF 42 24 1B 00 40 10 04 00 82 AC ?? ?? 04 3C ?? ?? 82 24 04 00 43 8C FF FF 63 24 13 00 60 14 04 00 43 AC 21 18 40 00 08 00 40 AC 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 08 00 40 14 ?? ?? 84 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 08 00 E0 03 00 00 00 00 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 DD FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? ?? ?? 04 3C }
	condition:
		$1
}

rule file_320_1_0 {
	meta:
		name = "save_for_backup"
		size = 472
		refs = "00e8 malloc 0108 memcpy 0114 free 0174 memmove 01b0 mempcpy"
	strings:
		$1 = { C0 FF BD 27 30 00 82 8C 28 00 B4 AF 0C 00 94 8C 24 00 B3 AF 1C 00 B1 AF 3C 00 BF AF 38 00 BE AF 34 00 B7 AF 30 00 B6 AF 2C 00 B5 AF 20 00 B2 AF 18 00 B0 AF 21 88 80 00 21 98 A0 00 46 00 40 10 23 40 B4 00 21 80 00 01 21 18 40 00 08 00 66 8C 00 00 63 8C 2A 38 D0 00 FC FF 60 14 0B 80 C7 00 2C 00 36 8E 24 00 24 8E 23 90 10 01 23 18 C4 02 2B 28 72 00 1C 00 A0 14 64 00 5E 26 3B 00 00 06 23 A8 72 00 2B 00 40 16 21 28 90 02 21 A8 95 00 21 28 00 01 07 00 40 10 28 00 35 AE 08 00 43 8C 23 18 65 00 08 00 43 AC 00 00 42 8C FB FF 40 14 00 00 00 00 21 10 00 00 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? ?? 0? 21 20 C0 03 37 00 40 10 21 B8 40 00 64 00 55 24 2B 00 00 06 21 20 A0 02 21 28 90 02 ?? ?? ?? 0? 21 30 40 02 24 00 24 8E ?? ?? ?? 0? 21 F0 FE 02 0C 00 25 8E 24 00 37 AE 2C 00 3E AE 23 28 65 02 ?? ?? ?? 0? 30 00 22 8E 21 20 95 00 ?? ?? ?? 0? 21 30 40 02 0C 00 25 8E 24 00 24 8E 30 00 22 8E 23 28 65 02 ?? ?? ?? 0? 21 A8 95 00 2C 00 96 8C 24 00 84 8C CA FF 01 05 23 A8 C4 02 21 80 00 01 21 20 95 00 21 28 D0 02 ?? ?? ?? 0? 23 30 10 00 0C 00 25 8E 24 00 24 8E 23 80 B0 02 23 30 65 02 ?? ?? ?? 0? 21 20 90 00 0C 00 25 8E 24 00 23 8E 30 00 22 8E 23 28 65 02 ?? ?? ?? 0? 21 A8 75 00 21 28 D0 02 ?? ?? ?? 0? 23 30 10 00 0C 00 25 8E 21 20 40 00 ?? ?? ?? 0? 23 30 65 02 ?? ?? ?? 0? 24 00 24 8E ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_320_2_0 {
	meta:
		name = "_IO_un_link"
		size = 768
		refs = "0030 _pthread_cleanup_push_defer 009c __lll_lock_wait_private 012c _IO_list_all 01bc _pthread_cleanup_pop_restore"
	strings:
		$1 = { 00 00 82 8C B0 FF BD 27 34 00 B0 AF 80 00 42 30 4C 00 BF AF 48 00 B5 AF 44 00 B4 AF 40 00 B3 AF 3C 00 B2 AF 38 00 B1 AF 66 00 40 10 21 80 80 00 ?? ?? 13 3C ?? ?? 73 26 2B 98 13 00 AB 00 60 12 ?? ?? 05 3C 18 00 A4 27 ?? ?? A5 24 ?? ?? ?? 0? 21 30 00 00 3B E8 03 7C ?? ?? 12 3C ?? ?? 51 26 08 00 22 8E 70 8B 74 24 0F 00 54 10 00 00 00 00 28 00 A0 AF 00 00 23 C2 06 00 60 14 00 00 02 24 01 00 01 24 00 00 21 E2 FA FF 20 10 01 00 02 24 0F 00 00 00 03 00 40 14 ?? ?? 44 26 ?? ?? ?? 0? 28 00 A3 AF 08 00 34 AE 04 00 22 8E 00 00 05 8E ?? ?? 14 3C 01 00 42 24 00 80 A4 30 04 00 22 AE 1A 00 80 14 ?? ?? 90 AE 3B E8 03 7C 48 00 04 8E 70 8B 75 24 08 00 82 8C 0F 00 55 10 00 00 00 00 28 00 A0 AF 00 00 83 C0 06 00 60 14 00 00 02 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 02 24 0F 00 00 00 4D 00 40 10 00 00 00 00 48 00 02 8E 21 20 40 00 08 00 55 AC 04 00 82 8C 00 00 05 8E 01 00 42 24 04 00 82 AC 00 80 A4 30 ?? ?? 03 3C ?? ?? 62 8C 10 00 40 10 00 00 00 00 56 00 02 12 00 00 00 00 34 00 43 8C 0B 00 60 10 00 00 00 00 06 00 03 16 00 00 00 00 ?? ?? ?? 0? 34 00 43 24 54 00 02 12 34 00 63 24 21 18 40 00 34 00 62 8C FB FF 40 14 00 00 00 00 7F FF 02 24 24 28 A2 00 06 00 80 14 00 00 05 AE 48 00 04 8E 04 00 82 8C FF FF 42 24 2D 00 40 10 04 00 82 AC 04 00 22 8E ?? ?? 80 AE ?? ?? 03 3C FF FF 42 24 0E 00 40 10 04 00 22 AE 03 00 60 12 18 00 A4 27 ?? ?? ?? 0? 21 28 00 00 4C 00 BF 8F 48 00 B5 8F 44 00 B4 8F 40 00 B3 8F 3C 00 B2 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 50 00 BD 27 ?? ?? 63 24 08 00 20 AE 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 E9 FF 40 14 00 00 00 00 ?? ?? 44 26 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 28 00 A3 AF ?? ?? ?? 0? 48 00 02 8E 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 CB FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 04 00 22 8E ?? ?? 02 3C ?? ?? 46 8C 34 00 07 8E 01 00 C6 24 ?? ?? 67 AC ?? ?? ?? 0? ?? ?? 46 AC ?? ?? 06 3C ?? ?? C7 8C 34 00 08 8E 7F FF 02 24 01 00 E7 24 24 28 A2 00 00 00 68 AC ?? ?? C7 AC B1 FF 80 14 00 00 05 AE ?? ?? ?? 0? 48 00 04 8E ?? ?? ?? 0? ?? ?? 06 3C ?? ?? 02 3C ?? ?? 42 24 18 00 A2 AF ?? ?? ?? 0? 1C 00 A0 AF }
	condition:
		$1
}

rule file_320_3_0 {
	meta:
		name = "_IO_link_in"
		size = 652
		refs = "0030 _pthread_cleanup_push_defer 00a4 __lll_lock_wait_private 0134 _IO_list_all 023c _pthread_cleanup_pop_restore"
	strings:
		$1 = { 00 00 82 8C B0 FF BD 27 34 00 B0 AF 80 00 43 30 4C 00 BF AF 48 00 B5 AF 44 00 B4 AF 40 00 B3 AF 3C 00 B2 AF 38 00 B1 AF 86 00 60 14 21 80 80 00 ?? ?? 13 3C ?? ?? 73 26 80 00 42 34 2B 98 13 00 8D 00 60 12 00 00 82 AC ?? ?? 05 3C 18 00 A4 27 ?? ?? A5 24 ?? ?? ?? 0? 21 30 00 00 3B E8 03 7C ?? ?? 12 3C ?? ?? 51 26 08 00 22 8E 70 8B 74 24 0F 00 54 10 00 00 00 00 28 00 A0 AF 00 00 23 C2 06 00 60 14 00 00 02 24 01 00 01 24 00 00 21 E2 FA FF 20 10 01 00 02 24 0F 00 00 00 03 00 40 14 ?? ?? 44 26 ?? ?? ?? 0? 28 00 A3 AF 08 00 34 AE 04 00 24 8E 00 00 02 8E ?? ?? 14 3C 01 00 84 24 00 80 43 30 04 00 24 AE 3A 00 60 14 ?? ?? 90 AE 3B E8 03 7C 48 00 04 8E 70 8B 75 24 08 00 83 8C 11 00 75 10 ?? ?? 03 3C 28 00 A0 AF 00 00 83 C0 06 00 60 14 00 00 02 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 02 24 0F 00 00 00 56 00 40 10 00 00 00 00 48 00 03 8E 00 00 02 8E 21 20 60 00 08 00 75 AC ?? ?? 03 3C 04 00 88 8C ?? ?? 05 3C ?? ?? 66 8C ?? ?? A7 8C 01 00 08 25 01 00 C6 24 00 80 42 30 04 00 88 AC ?? ?? B0 AC 34 00 07 AE 20 00 40 14 ?? ?? 66 AC 04 00 82 8C FF FF 42 24 1C 00 40 14 04 00 82 AC 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 12 00 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 04 00 22 8E ?? ?? 02 3C ?? ?? 03 3C ?? ?? 45 8C ?? ?? 64 8C ?? ?? 70 AC 01 00 A3 24 34 00 04 AE ?? ?? 43 AC 04 00 22 8E ?? ?? 80 AE ?? ?? 03 3C FF FF 42 24 13 00 40 14 04 00 22 AE ?? ?? 63 24 08 00 20 AE 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 08 00 40 14 ?? ?? 44 26 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 03 00 60 12 18 00 A4 27 ?? ?? ?? 0? 21 28 00 00 4C 00 BF 8F 48 00 B5 8F 44 00 B4 8F 40 00 B3 8F 3C 00 B2 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 50 00 BD 27 ?? ?? ?? 0? 28 00 A3 AF ?? ?? ?? 0? 48 00 03 8E ?? ?? 02 3C ?? ?? 42 24 18 00 A2 AF ?? ?? ?? 0? 1C 00 A0 AF }
	condition:
		$1
}

rule file_320_4_0 {
	meta:
		name = "_IO_least_marker"
		size = 44
	strings:
		$1 = { 0C 00 82 8C 30 00 83 8C 06 00 60 10 23 10 A2 00 08 00 64 8C 00 00 63 8C 2A 28 82 00 FC FF 60 14 0B 10 85 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_320_5_0 {
	meta:
		name = "_IO_switch_to_main_get_area"
		size = 56
	strings:
		$1 = { 00 00 88 8C 24 00 82 8C 08 00 85 8C 2C 00 86 8C 0C 00 83 8C FF FE 07 24 24 38 07 01 00 00 87 AC 08 00 86 AC 2C 00 85 AC 0C 00 82 AC 24 00 83 AC 08 00 E0 03 04 00 82 AC }
	condition:
		$1
}

rule file_320_6_0 {
	meta:
		name = "_IO_switch_to_backup_area"
		size = 52
	strings:
		$1 = { 00 00 87 8C 2C 00 82 8C 08 00 86 8C 0C 00 83 8C 24 00 85 8C 00 01 E7 34 00 00 87 AC 08 00 82 AC 2C 00 86 AC 0C 00 85 AC 24 00 83 AC 08 00 E0 03 04 00 82 AC }
	condition:
		$1
}

rule file_320_7_0 {
	meta:
		name = "_IO_switch_to_get_mode"
		size = 164
	strings:
		$1 = { 14 00 82 8C 10 00 83 8C E0 FF BD 27 18 00 B0 AF 2B 18 62 00 1C 00 BF AF 19 00 60 14 21 80 80 00 00 00 03 8E 00 01 64 30 12 00 80 14 00 00 00 00 08 00 04 8E 1C 00 05 8E 2B 20 82 00 02 00 80 10 0C 00 05 AE 08 00 02 AE FF F7 04 24 24 18 64 00 04 00 02 AE 18 00 02 AE 10 00 02 AE 00 00 03 AE 21 10 00 00 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 28 00 04 8E ?? ?? ?? 0? 0C 00 04 AE 98 00 82 8C 0C 00 59 8C 09 F8 20 03 FF FF 05 24 FF FF 03 24 F4 FF 43 10 1C 00 BF 8F ?? ?? ?? 0? 14 00 02 8E }
	condition:
		$1
}

rule file_320_8_0 {
	meta:
		name = "_IO_free_backup_area"
		size = 120
		refs = "004c free"
	strings:
		$1 = { 00 00 82 8C E0 FF BD 27 18 00 B0 AF 00 01 43 30 1C 00 BF AF 16 00 60 10 21 80 80 00 0C 00 84 8C 24 00 03 8E 08 00 05 8E 2C 00 06 8E FF FE 07 24 24 10 47 00 00 00 02 AE 08 00 06 AE 2C 00 05 AE 0C 00 03 AE 24 00 04 AE 04 00 03 AE ?? ?? ?? 0? 00 00 00 00 1C 00 BF 8F 24 00 00 AE 2C 00 00 AE 28 00 00 AE 18 00 B0 8F 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? 24 00 84 8C }
	condition:
		$1
}

rule file_320_9_0 {
	meta:
		name = "__overflow"
		size = 32
	strings:
		$1 = { 6C 00 82 8C 02 00 40 14 FF FF 02 24 6C 00 82 AC 98 00 82 8C 0C 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_320_10_0 {
	meta:
		name = "__underflow"
		size = 312
		refs = "0100 _IO_switch_to_get_mode 0128 _IO_free_backup_area"
	strings:
		$1 = { 6C 00 82 8C E0 FF BD 27 18 00 B0 AF 1C 00 BF AF 1F 00 40 14 21 80 80 00 FF FF 02 24 6C 00 82 AC 00 00 02 8E 00 08 42 30 35 00 40 14 00 00 00 00 04 00 02 8E 08 00 03 8E 2B 20 43 00 2C 00 80 14 1C 00 BF 8F 00 00 02 8E 00 01 44 30 17 00 80 14 FF FE 06 24 30 00 02 8E 30 00 40 10 00 00 00 00 08 00 05 8E ?? ?? ?? 0? 21 20 00 02 0B 00 40 14 FF FF 02 24 98 00 02 8E 1C 00 BF 8F 21 20 00 02 10 00 59 8C 18 00 B0 8F 08 00 20 03 20 00 BD 27 FF FF 03 24 E2 FF 43 10 FF FF 02 24 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 24 00 04 8E 2C 00 05 8E 0C 00 07 8E 24 10 46 00 2B 30 85 00 00 00 02 AE 08 00 05 AE 2C 00 03 AE 0C 00 04 AE 24 00 07 AE DF FF C0 10 04 00 04 AE 1C 00 BF 8F 00 00 82 90 18 00 B0 8F 08 00 E0 03 20 00 BD 27 00 00 42 90 18 00 B0 8F 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? 21 20 00 02 FF FF 03 24 C8 FF 43 14 FF FF 02 24 ?? ?? ?? 0? 1C 00 BF 8F 24 00 02 8E D4 FF 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 98 00 02 8E }
	condition:
		$1
}

rule file_320_11_0 {
	meta:
		name = "__uflow"
		size = 336
		refs = "00f0 _IO_free_backup_area 0118 _IO_switch_to_get_mode"
	strings:
		$1 = { 6C 00 82 8C E0 FF BD 27 18 00 B0 AF 1C 00 BF AF 1F 00 40 14 21 80 80 00 FF FF 02 24 6C 00 82 AC 00 00 02 8E 00 08 42 30 3B 00 40 14 00 00 00 00 04 00 02 8E 08 00 03 8E 2B 20 43 00 30 00 80 14 1C 00 BF 8F 00 00 02 8E 00 01 44 30 17 00 80 14 FF FE 06 24 30 00 02 8E 22 00 40 10 00 00 00 00 08 00 05 8E ?? ?? ?? 0? 21 20 00 02 0B 00 40 14 FF FF 02 24 98 00 02 8E 1C 00 BF 8F 21 20 00 02 14 00 59 8C 18 00 B0 8F 08 00 20 03 20 00 BD 27 FF FF 03 24 E2 FF 43 10 FF FF 02 24 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 2C 00 05 8E 24 00 04 8E 0C 00 07 8E 24 10 46 00 2B 30 85 00 00 00 02 AE 08 00 05 AE 2C 00 03 AE 0C 00 04 AE 18 00 C0 14 24 00 07 AE 30 00 02 8E E0 FF 40 14 04 00 04 AE 24 00 02 8E E2 FF 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 98 00 02 8E 01 00 43 24 04 00 03 AE 00 00 42 90 18 00 B0 8F 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? 21 20 00 02 FF FF 03 24 C2 FF 43 14 FF FF 02 24 ?? ?? ?? 0? 1C 00 BF 8F 1C 00 BF 8F 01 00 82 24 04 00 02 AE 00 00 82 90 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_320_12_0 {
	meta:
		name = "_IO_setb"
		size = 172
		refs = "0094 __munmap"
	strings:
		$1 = { D0 FF BD 27 24 00 B0 AF 21 80 80 00 1C 00 84 8C 28 00 B1 AF 2C 00 BF AF 21 88 A0 00 04 00 80 10 00 00 02 8E 01 00 43 30 13 00 60 10 00 00 00 00 1C 00 11 AE 08 00 E0 14 20 00 06 AE 2C 00 BF 8F 01 00 42 34 00 00 02 AE 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 2C 00 BF 8F FE FF 03 24 24 10 43 00 00 00 02 AE 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 20 00 05 8E FF FF 02 34 18 00 A6 AF 23 28 A4 00 21 28 A2 00 FF FF 02 3C 24 28 A2 00 ?? ?? ?? 0? 1C 00 A7 AF 00 00 02 8E 1C 00 A7 8F ?? ?? ?? 0? 18 00 A6 8F }
	condition:
		$1
}

rule file_320_13_0 {
	meta:
		name = "_IO_doallocbuf"
		size = 124
		refs = "0074 _IO_setb"
	strings:
		$1 = { 1C 00 82 8C E0 FF BD 27 18 00 B0 AF 1C 00 BF AF 05 00 40 10 21 80 80 00 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 00 00 82 8C 02 00 42 30 04 00 40 10 00 00 00 00 6C 00 82 8C 08 00 40 18 1C 00 BF 8F 98 00 02 8E 34 00 59 8C 09 F8 20 03 21 20 00 02 FF FF 03 24 F0 FF 43 14 1C 00 BF 8F 21 20 00 02 47 00 05 26 48 00 06 26 18 00 B0 8F 21 38 00 00 ?? ?? ?? 0? 20 00 BD 27 }
	condition:
		$1
}

rule file_320_15_0 {
	meta:
		name = "_IO_default_uflow"
		size = 72
	strings:
		$1 = { 98 00 82 8C E0 FF BD 27 18 00 B0 AF 10 00 59 8C 1C 00 BF AF 09 F8 20 03 21 80 80 00 FF FF 03 24 05 00 43 10 FF FF 02 24 04 00 02 8E 01 00 43 24 04 00 03 AE 00 00 42 90 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_320_16_0 {
	meta:
		name = "_IO_default_xsputn"
		size = 264
		refs = "00c8 mempcpy"
	strings:
		$1 = { C8 FF BD 27 21 10 00 00 2C 00 B4 AF 34 00 BF AF 30 00 B5 AF 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF 1C 00 B0 AF 2F 00 C0 10 21 A0 C0 00 21 88 80 00 21 90 A0 00 21 80 C0 00 FF FF 13 24 14 00 23 8E 18 00 22 8E 2B 20 62 00 13 00 80 10 23 10 43 00 2B A8 50 00 0A 10 15 02 21 A8 40 00 15 00 42 2C 18 00 40 10 21 28 40 02 0A 00 A0 12 00 00 00 00 21 20 75 00 21 38 40 02 01 00 E7 24 FF FF E2 80 01 00 63 24 FC FF 64 14 FF FF 62 A0 21 90 55 02 14 00 23 AE 23 80 15 02 11 00 00 12 21 20 20 02 98 00 22 8E 00 00 45 92 0C 00 59 8C 09 F8 20 03 01 00 52 26 0B 00 53 10 23 10 90 02 ?? ?? ?? 0? FF FF 10 26 21 20 60 00 ?? ?? ?? 0? 21 30 A0 02 14 00 22 AE 21 90 55 02 ?? ?? ?? 0? 23 80 15 02 23 10 90 02 34 00 BF 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_320_17_0 {
	meta:
		name = "_IO_sgetn"
		size = 16
	strings:
		$1 = { 98 00 82 8C 20 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_320_18_0 {
	meta:
		name = "_IO_default_xsgetn"
		size = 236
		refs = "0094 __underflow 00cc mempcpy"
	strings:
		$1 = { C8 FF BD 27 2C 00 B4 AF 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF 1C 00 B0 AF 34 00 BF AF 30 00 B5 AF 21 A0 C0 00 21 80 80 00 21 98 A0 00 21 88 C0 00 FF FF 12 24 04 00 05 8E 08 00 03 8E 2B 10 A3 00 12 00 40 10 00 00 00 00 23 18 65 00 2B A8 71 00 0A 18 35 02 15 00 62 2C 1B 00 40 10 21 A8 60 00 09 00 60 10 21 10 A3 00 21 18 60 02 01 00 A5 24 FF FF A7 80 01 00 63 24 FC FF A2 14 FF FF 67 A0 21 98 75 02 04 00 05 AE 23 88 35 02 05 00 20 12 34 00 BF 8F ?? ?? ?? 0? 21 20 00 02 E5 FF 52 14 34 00 BF 8F 23 10 91 02 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 38 00 BD 27 21 20 60 02 ?? ?? ?? 0? 21 30 60 00 04 00 03 8E 21 98 40 00 23 88 35 02 21 18 75 00 ?? ?? ?? 0? 04 00 03 AE }
	condition:
		$1
}

rule file_320_19_0 {
	meta:
		name = "_IO_default_setbuf"
		size = 204
		refs = "0060 _IO_setb"
	strings:
		$1 = { 98 00 82 8C D8 FF BD 27 20 00 B2 AF 30 00 59 8C 1C 00 B1 AF 18 00 B0 AF 24 00 BF AF 21 80 80 00 21 88 A0 00 09 F8 20 03 21 90 C0 00 FF FF 03 24 24 00 43 10 00 00 00 00 03 00 20 12 00 00 00 00 16 00 40 16 FD FF 02 24 00 00 02 8E 21 20 00 02 47 00 05 26 02 00 42 34 00 00 02 AE 48 00 06 26 ?? ?? ?? 0? 21 38 00 00 18 00 00 AE 14 00 00 AE 10 00 00 AE 08 00 00 AE 04 00 00 AE 0C 00 00 AE 21 10 00 02 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 00 00 03 8E 21 28 20 02 24 10 62 00 00 00 02 AE 21 20 00 02 21 30 32 02 ?? ?? ?? 0? 21 38 00 00 ?? ?? ?? 0? 18 00 00 AE ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_320_20_0 {
	meta:
		name = "_IO_default_seekpos"
		size = 48
	strings:
		$1 = { D8 FF BD 27 38 00 A3 8F 98 00 82 8C 10 00 A0 AF 14 00 A3 AF 24 00 59 8C 24 00 BF AF 09 F8 20 03 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_320_21_0 {
	meta:
		name = "_IO_default_doallocate"
		size = 108
		refs = "002c __mmap 0044 _IO_setb"
	strings:
		$1 = { D0 FF BD 27 24 00 B0 AF FF FF 10 24 28 00 B1 AF 10 00 B0 AF 21 88 80 00 14 00 A0 AF 21 20 00 00 01 00 05 3C 03 00 06 24 2C 00 BF AF ?? ?? ?? 0? 02 08 07 24 0B 00 50 10 21 28 40 00 00 20 46 24 21 20 20 02 ?? ?? ?? 0? 01 00 07 24 01 00 02 24 2C 00 BF 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_320_22_0 {
	meta:
		name = "_IO_old_init"
		size = 100
	strings:
		$1 = { 48 00 82 8C AD FB 03 3C 25 28 A3 00 00 00 85 AC 3C 00 80 AC 1C 00 80 AC 20 00 80 AC 0C 00 80 AC 04 00 80 AC 08 00 80 AC 10 00 80 AC 14 00 80 AC 18 00 80 AC 34 00 80 AC 24 00 80 AC 28 00 80 AC 2C 00 80 AC 30 00 80 AC 04 00 40 10 44 00 80 A4 00 00 40 AC 04 00 40 AC 08 00 40 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_320_23_0 {
	meta:
		name = "_IO_init"
		size = 44
		refs = "0008 _IO_old_init"
	strings:
		$1 = { E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 21 38 80 00 1C 00 BF 8F FF FF 02 24 6C 00 E2 AC 5C 00 E2 AC 60 00 E0 AC 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_320_24_0 {
	meta:
		name = "_IO_no_init"
		size = 124
		refs = "000c _IO_old_init"
	strings:
		$1 = { E0 FF BD 27 21 40 80 00 1C 00 BF AF ?? ?? ?? 0? 21 48 C0 00 13 00 20 05 6C 00 09 AD 30 00 A2 8F 1C 00 BF 8F 5C 00 07 AD 18 00 E0 AC 1C 00 E0 AC 08 00 E0 AC 00 00 E0 AC 04 00 E0 AC 0C 00 E0 AC 10 00 E0 AC 14 00 E0 AC 20 00 E0 AC 24 00 E0 AC 28 00 E0 AC B8 00 E2 AC 60 00 00 AD 08 00 E0 03 20 00 BD 27 1C 00 BF 8F FF FF 02 24 5C 00 02 AD 60 00 00 AD 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_320_26_0 {
	meta:
		name = "_IO_default_finish"
		size = 148
		refs = "0050 free 0068 _IO_un_link 0080 __munmap"
	strings:
		$1 = { E0 FF BD 27 18 00 B0 AF 21 80 80 00 1C 00 84 8C 05 00 80 10 1C 00 BF AF 00 00 02 8E 01 00 42 30 13 00 40 10 FF FF 02 34 30 00 02 8E 05 00 40 10 00 00 00 00 04 00 40 AC 00 00 42 8C FD FF 40 14 00 00 00 00 24 00 04 8E 04 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 24 00 00 AE 1C 00 BF 8F 21 20 00 02 18 00 B0 8F ?? ?? ?? 0? 20 00 BD 27 20 00 05 8E 23 28 A4 00 21 28 A2 00 FF FF 02 3C ?? ?? ?? 0? 24 28 A2 00 20 00 00 AE ?? ?? ?? 0? 1C 00 00 AE }
	condition:
		$1
}

rule file_320_28_0 {
	meta:
		name = "_IO_sputbackc"
		size = 120
	strings:
		$1 = { 04 00 83 8C 0C 00 82 8C E0 FF BD 27 18 00 B0 AF 2B 10 43 00 1C 00 BF AF 05 00 40 10 21 80 80 00 FF FF 64 90 FF 00 A2 30 10 00 82 10 FF FF 63 24 98 00 02 8E 18 00 59 8C 09 F8 20 03 21 20 00 02 FF FF 03 24 06 00 43 10 1C 00 BF 8F 00 00 04 8E EF FF 03 24 24 18 83 00 00 00 03 AE 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 04 00 03 AE ?? ?? ?? 0? FF 00 A2 30 }
	condition:
		$1
}

rule file_320_29_0 {
	meta:
		name = "_IO_sungetc"
		size = 116
	strings:
		$1 = { 04 00 82 8C 0C 00 83 8C E0 FF BD 27 18 00 B0 AF 2B 18 62 00 1C 00 BF AF 0C 00 60 10 21 80 80 00 FF FF 43 24 04 00 83 AC FF FF 42 90 00 00 04 8E 1C 00 BF 8F EF FF 03 24 24 18 83 00 00 00 03 AE 18 00 B0 8F 08 00 E0 03 20 00 BD 27 98 00 82 8C 18 00 59 8C 09 F8 20 03 FF FF 05 24 FF FF 03 24 F2 FF 43 14 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_320_30_0 {
	meta:
		name = "_IO_adjust_column"
		size = 80
	strings:
		$1 = { 21 48 A6 00 2B 18 A9 00 0F 00 60 10 00 00 00 00 FF FF 28 81 0A 00 07 24 08 00 07 11 FF FF 23 25 0A 00 08 24 08 00 65 10 00 00 00 00 FF FF 63 24 00 00 67 80 FB FF E8 14 00 00 00 00 23 10 23 01 08 00 E0 03 FF FF 42 24 08 00 E0 03 21 10 C4 00 }
	condition:
		$1
}

rule file_320_31_0 {
	meta:
		name = "_IO_flush_all_lockp"
		size = 820
		refs = "0038 _pthread_cleanup_push_defer 00b4 _IO_list_all 012c __lll_lock_wait_private 0200 _pthread_cleanup_pop_restore"
	strings:
		$1 = { A8 FF BD 27 4C 00 B7 AF 34 00 B1 AF 54 00 BF AF 50 00 BE AF 48 00 B6 AF 44 00 B5 AF 40 00 B4 AF 3C 00 B3 AF 38 00 B2 AF 30 00 B0 AF 21 88 80 00 20 00 80 10 21 B8 00 00 ?? ?? 02 3C ?? ?? 42 24 B7 00 40 10 ?? ?? 05 3C 18 00 A4 27 ?? ?? A5 24 21 30 00 00 ?? ?? ?? 0? 01 00 17 24 3B E8 03 7C ?? ?? 04 3C ?? ?? 90 24 08 00 02 8E 70 8B 72 24 0D 00 52 10 ?? ?? 85 24 28 00 A0 AF 00 00 A3 C0 06 00 60 14 00 00 02 24 01 00 01 24 00 00 A1 E0 FA FF 20 10 01 00 02 24 0F 00 00 00 86 00 40 10 00 00 00 00 08 00 12 AE 04 00 02 8E 01 00 42 24 04 00 02 AE ?? ?? 16 3C ?? ?? D0 8E ?? ?? 14 3C ?? ?? 93 8E 43 00 00 12 21 A8 00 00 ?? ?? 12 3C 1E 00 20 12 ?? ?? 50 AE 00 00 02 8E 00 80 42 30 1A 00 40 14 00 00 00 00 3B E8 03 7C 48 00 04 8E 70 8B 7E 24 08 00 82 8C 11 00 5E 10 21 10 00 00 28 00 A0 AF 00 00 85 C0 06 00 A2 14 00 00 03 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 03 24 0F 00 00 00 03 00 60 14 00 00 00 00 ?? ?? ?? 0? 28 00 A5 AF 48 00 02 8E 21 20 40 00 08 00 5E AC 04 00 82 8C 01 00 42 24 04 00 82 AC 6C 00 02 8E 3F 00 40 18 00 00 00 00 5C 00 02 8E 10 00 43 8C 0C 00 42 8C 2B 10 43 00 09 00 40 10 00 00 00 00 98 00 02 8E 21 20 00 02 0C 00 59 8C 09 F8 20 03 FF FF 05 24 27 10 02 00 FF FF 03 24 0A A8 62 00 0B 00 20 12 ?? ?? 83 8E 00 00 02 8E 00 80 42 30 07 00 40 14 00 00 00 00 48 00 04 8E 04 00 82 8C FF FF 42 24 2D 00 40 10 04 00 82 AC ?? ?? 83 8E 1E 00 63 12 ?? ?? 40 AE ?? ?? D0 8E C0 FF 00 16 21 98 60 00 07 00 20 12 00 00 00 00 ?? ?? 04 3C ?? ?? 82 24 04 00 43 8C FF FF 63 24 37 00 60 10 04 00 43 AC 05 00 E0 12 54 00 BF 8F 18 00 A4 27 ?? ?? ?? 0? 21 28 00 00 54 00 BF 8F 21 10 A0 02 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 34 00 10 8E A3 FF 00 16 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 14 00 03 8E 10 00 02 8E 2B 10 43 00 C4 FF 40 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 CB FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? ?? ?? 83 8E ?? ?? 84 24 ?? ?? ?? 0? 28 00 A3 AF ?? ?? ?? 0? 08 00 12 AE 21 18 40 00 08 00 40 AC 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 C0 FF 40 14 00 00 00 00 ?? ?? 84 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 18 00 A2 AF ?? ?? ?? 0? 1C 00 A0 AF }
	condition:
		$1
}

rule file_320_32_0 {
	meta:
		name = "_IO_cleanup"
		size = 564
		refs = "0028 _IO_flush_all_lockp 0030 _IO_list_all 0160 __sched_yield"
	strings:
		$1 = { B8 FF BD 27 21 20 00 00 34 00 B4 AF 24 00 B0 AF 44 00 BF AF 40 00 B7 AF 3C 00 B6 AF 38 00 B5 AF 30 00 B3 AF 2C 00 B2 AF ?? ?? ?? 0? 28 00 B1 AF ?? ?? 03 3C ?? ?? 70 8C 3D 00 00 12 21 A0 40 00 08 00 12 24 02 00 13 24 ?? ?? 15 3C ?? ?? 16 3C FF FF 11 24 00 00 03 8E 02 00 62 30 30 00 40 14 08 10 63 30 2E 00 72 10 00 00 00 00 6C 00 02 8E 2B 00 40 10 21 B8 00 00 48 00 04 8E 1A 00 80 10 ?? ?? A2 92 3B E8 03 7C 08 00 82 8C 70 8B 63 24 39 00 62 10 00 00 00 00 18 00 A0 AF 00 00 85 C0 06 00 A0 14 00 00 02 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 02 24 0F 00 00 00 03 00 40 14 18 00 A2 8F 18 00 A5 AF 18 00 A2 8F 24 00 40 14 00 00 00 00 48 00 04 8E 08 00 83 AC 01 00 03 24 04 00 83 AC ?? ?? A2 92 05 00 40 14 00 00 00 00 00 00 02 8E 01 00 43 30 23 00 60 10 01 00 42 34 98 00 02 8E 21 20 00 02 21 28 00 00 2C 00 59 8C 09 F8 20 03 21 30 00 00 2C 00 F3 16 00 00 00 00 6C 00 11 AE 34 00 10 8E CA FF 00 16 00 00 00 00 44 00 BF 8F 21 10 80 02 40 00 B7 8F 3C 00 B6 8F 38 00 B5 8F 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 48 00 BD 27 ?? ?? ?? 0? 01 00 F7 26 DF FF F3 12 ?? ?? A2 92 ?? ?? ?? 0? 48 00 04 8E 04 00 82 8C 01 00 42 24 ?? ?? ?? 0? 04 00 82 AC 00 00 02 AE 98 00 02 8E 1C 00 03 8E 20 00 04 8E ?? ?? C5 8E 2C 00 59 8C 23 20 83 00 60 00 05 AE 68 00 04 AE ?? ?? D0 AE 64 00 03 AE 21 20 00 02 21 28 00 00 09 F8 20 03 21 30 00 00 D6 FF F3 12 00 00 00 00 48 00 04 8E D3 FF 80 10 00 00 00 00 04 00 82 8C FF FF 42 24 CF FF 40 14 04 00 82 AC 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 C5 FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 6C 00 11 AE }
	condition:
		$1
}

rule file_320_34_0 {
	meta:
		name = "_IO_flush_all_linebuffered"
		size = 720
		refs = "0008 _pthread_cleanup_push_defer 00a4 _IO_list_all 011c __lll_lock_wait_private 01a8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { A0 FF BD 27 58 00 BE AF ?? ?? 1E 3C ?? ?? DE 27 2B F0 1E 00 5C 00 BF AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF 40 00 B2 AF 3C 00 B1 AF 38 00 B0 AF A0 00 C0 13 30 00 BE AF ?? ?? 05 3C 18 00 A4 27 ?? ?? A5 24 ?? ?? ?? 0? 21 30 00 00 3B E8 03 7C ?? ?? 17 3C ?? ?? F6 26 08 00 C2 8E 70 8B 70 24 0D 00 50 10 00 00 00 00 28 00 A0 AF 00 00 C3 C2 06 00 60 14 00 00 02 24 01 00 01 24 00 00 C1 E2 FA FF 20 10 01 00 02 24 0F 00 00 00 70 00 40 10 ?? ?? E4 26 08 00 D0 AE 04 00 C2 8E ?? ?? 15 3C ?? ?? B0 8E 01 00 42 24 ?? ?? 13 3C 04 00 C2 AE 34 00 00 12 ?? ?? 72 8E ?? ?? 11 3C 00 02 14 24 00 00 02 8E 00 80 42 30 1A 00 40 14 ?? ?? 30 AE 3B E8 03 7C 48 00 04 8E 70 8B 7E 24 08 00 82 8C 11 00 5E 10 21 10 00 00 28 00 A0 AF 00 00 86 C0 06 00 C2 14 00 00 05 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 05 24 0F 00 00 00 03 00 A0 14 00 00 00 00 ?? ?? ?? 0? 28 00 A6 AF 48 00 02 8E 21 20 40 00 08 00 5E AC 04 00 82 8C 01 00 42 24 04 00 82 AC 00 00 02 8E 08 02 42 30 3E 00 54 10 21 20 00 02 00 00 02 8E 00 80 42 30 07 00 40 14 ?? ?? 62 8E 48 00 04 8E 04 00 82 8C FF FF 42 24 22 00 40 10 04 00 82 AC ?? ?? 62 8E 1A 00 42 12 ?? ?? 20 AE ?? ?? B0 8E D1 FF 00 16 21 90 40 00 04 00 C2 8E FF FF 42 24 ?? ?? 03 3C 34 00 40 10 04 00 C2 AE 30 00 A2 8F 03 00 40 10 18 00 A4 27 ?? ?? ?? 0? 21 28 00 00 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 60 00 BD 27 34 00 10 8E B8 FF 00 16 00 00 00 00 ?? ?? ?? 0? 04 00 C2 8E 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 D6 FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? ?? ?? 62 8E 98 00 02 8E 0C 00 59 8C 09 F8 20 03 FF FF 05 24 ?? ?? ?? 0? 00 00 02 8E ?? ?? ?? 0? 28 00 A3 AF ?? ?? ?? 0? 08 00 D0 AE ?? ?? 63 24 08 00 C0 AE 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 C3 FF 40 14 00 00 00 00 ?? ?? E4 26 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 30 00 A2 8F ?? ?? 02 3C ?? ?? 42 24 18 00 A2 AF ?? ?? ?? 0? 1C 00 A0 AF }
	condition:
		$1
}

rule file_320_35_0 {
	meta:
		name = "_IO_init_marker"
		size = 148
		refs = "0080 _IO_switch_to_get_mode"
	strings:
		$1 = { 00 00 A2 8C D8 FF BD 27 20 00 B0 AF 00 08 43 30 24 00 BF AF 21 80 80 00 18 00 60 14 04 00 85 AC 00 01 42 30 0B 00 40 14 04 00 A3 8C 0C 00 A2 8C 24 00 BF 8F 23 10 62 00 08 00 02 AE 30 00 A2 8C 00 00 02 AE 30 00 B0 AC 20 00 B0 8F 08 00 E0 03 28 00 BD 27 08 00 A2 8C 24 00 BF 8F 23 10 62 00 08 00 02 AE 30 00 A2 8C 00 00 02 AE 30 00 B0 AC 20 00 B0 8F 08 00 E0 03 28 00 BD 27 21 20 A0 00 ?? ?? ?? 0? 18 00 A5 AF 18 00 A5 8F ?? ?? ?? 0? 00 00 A2 8C }
	condition:
		$1
}

rule file_320_36_0 {
	meta:
		name = "_IO_remove_marker"
		size = 76
	strings:
		$1 = { 04 00 82 8C 30 00 43 8C 0B 00 60 10 00 00 00 00 06 00 83 14 00 00 00 00 ?? ?? ?? 0? 30 00 43 24 07 00 82 10 00 00 00 00 21 18 40 00 00 00 62 8C FB FF 40 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 84 8C 08 00 E0 03 00 00 64 AC }
	condition:
		$1
}

rule file_320_37_0 {
	meta:
		name = "_IO_marker_difference"
		size = 16
	strings:
		$1 = { 08 00 82 8C 08 00 A3 8C 08 00 E0 03 23 10 43 00 }
	condition:
		$1
}

rule file_320_38_0 {
	meta:
		name = "_IO_marker_delta"
		size = 76
	strings:
		$1 = { 04 00 83 8C 0F 00 60 10 00 00 00 00 00 00 62 8C 00 01 42 30 06 00 40 14 04 00 65 8C 0C 00 62 8C 08 00 83 8C 23 10 A2 00 08 00 E0 03 23 10 62 00 08 00 62 8C 08 00 83 8C 23 10 A2 00 08 00 E0 03 23 10 62 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_320_39_0 {
	meta:
		name = "_IO_seekmark"
		size = 200
	strings:
		$1 = { 04 00 A2 8C 2E 00 44 14 00 00 00 00 08 00 A3 8C 00 00 45 8C 16 00 60 04 00 01 A4 30 0F 00 80 10 FF FE 09 24 24 00 44 8C 08 00 47 8C 2C 00 48 8C 0C 00 46 8C 24 28 A9 00 21 18 83 00 00 00 45 AC 08 00 48 AC 2C 00 47 AC 0C 00 44 AC 24 00 46 AC 04 00 43 AC 08 00 E0 03 21 10 00 00 0C 00 44 8C 21 18 83 00 04 00 43 AC 08 00 E0 03 21 10 00 00 0E 00 80 14 00 01 A5 34 2C 00 44 8C 08 00 48 8C 0C 00 46 8C 24 00 47 8C 21 18 83 00 00 00 45 AC 08 00 44 AC 2C 00 48 AC 0C 00 47 AC 24 00 46 AC 04 00 43 AC 08 00 E0 03 21 10 00 00 08 00 44 8C 21 18 83 00 04 00 43 AC 08 00 E0 03 21 10 00 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_320_40_0 {
	meta:
		name = "_IO_unsave_markers"
		size = 44
		refs = "001c _IO_free_backup_area"
	strings:
		$1 = { 30 00 82 8C 02 00 40 10 00 00 00 00 30 00 80 AC 24 00 82 8C 03 00 40 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_1115_23_0 {
	meta:
		name = "_IO_unsave_wmarkers"
		size = 44
		refs = "001c _IO_free_wbackup_area"
	strings:
		$1 = { 30 00 82 8C 02 00 40 10 00 00 00 00 30 00 80 AC 24 00 82 8C 03 00 40 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_320_41_0 {
	meta:
		name = "_IO_default_pbackfail"
		size = 384
		refs = "0108 malloc 0124 memcpy 0130 free"
	strings:
		$1 = { C8 FF BD 27 28 00 B3 AF 20 00 B1 AF 0C 00 93 8C 04 00 91 8C 24 00 B2 AF 1C 00 B0 AF 2B 10 71 02 34 00 BF AF 30 00 B5 AF 2C 00 B4 AF 21 80 80 00 1D 00 40 14 21 90 A0 00 00 00 84 8C 00 01 82 30 2F 00 40 14 00 00 00 00 24 00 02 8E 41 00 40 10 21 28 20 02 2C 00 11 8E 08 00 03 8E 00 01 84 34 00 00 04 AE 08 00 11 AE 2C 00 03 AE 0C 00 02 AE 24 00 05 AE FF FF 22 26 04 00 02 AE FF FF 32 A2 FF 00 42 32 34 00 BF 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 38 00 BD 27 00 00 82 8C 00 01 42 30 F1 FF 40 14 FF FF 22 26 FF FF 22 92 0D 00 45 10 00 00 00 00 24 00 82 8C 22 00 40 10 00 00 00 00 ?? ?? ?? 0? 21 28 20 02 27 00 40 14 00 00 00 00 04 00 05 8E 00 00 04 8E 2C 00 11 8E ?? ?? ?? 0? 24 00 02 8E FF FF 31 26 ?? ?? ?? 0? 04 00 91 AC 08 00 14 8E 23 A0 93 02 ?? ?? ?? 0? 40 20 14 00 19 00 40 10 21 A8 40 00 21 88 54 00 21 30 80 02 21 20 20 02 ?? ?? ?? 0? 21 28 60 02 0C 00 04 8E ?? ?? ?? 0? 21 A0 34 02 FF FF 22 26 0C 00 15 AE 08 00 14 AE 28 00 11 AE 04 00 02 AE ?? ?? ?? 0? FF FF 32 A2 ?? ?? ?? 0? 80 00 04 24 06 00 40 10 80 00 43 24 21 28 20 02 00 00 04 8E 28 00 03 AE ?? ?? ?? 0? 21 88 60 00 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_320_52_0 {
	meta:
		name = "_IO_list_lock"
		size = 144
		refs = "0080 __lll_lock_wait_private"
	strings:
		$1 = { D0 FF BD 27 2C 00 BF AF 28 00 B1 AF 24 00 B0 AF 3B E8 03 7C ?? ?? 04 3C ?? ?? 90 24 08 00 02 8E 70 8B 71 24 0D 00 51 10 00 00 00 00 18 00 A0 AF 00 00 03 C2 06 00 60 14 00 00 02 24 01 00 01 24 00 00 01 E2 FA FF 20 10 01 00 02 24 0F 00 00 00 0A 00 40 10 00 00 00 00 08 00 11 AE 04 00 02 8E 2C 00 BF 8F 28 00 B1 8F 01 00 42 24 04 00 02 AE 24 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? 84 24 ?? ?? ?? 0? 18 00 A3 AF ?? ?? ?? 0? 08 00 11 AE }
	condition:
		$1
}

rule file_320_53_0 {
	meta:
		name = "_IO_list_unlock"
		size = 108
	strings:
		$1 = { ?? ?? 04 3C ?? ?? 82 24 04 00 43 8C FF FF 63 24 14 00 60 14 04 00 43 AC 21 18 40 00 08 00 40 AC 0F 00 00 00 00 00 62 C0 00 00 01 24 00 00 61 E0 FC FF 20 10 00 00 00 00 02 00 42 28 09 00 40 14 00 00 00 00 ?? ?? 84 24 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_320_54_0 {
	meta:
		name = "_IO_list_resetlock"
		size = 24
	strings:
		$1 = { ?? ?? 03 3C ?? ?? 62 24 ?? ?? 60 AC 04 00 40 AC 08 00 E0 03 08 00 40 AC }
	condition:
		$1
}

rule file_320_55_0 {
	meta:
		name = "buffer_free"
		size = 112
		refs = "0040 __munmap"
	strings:
		$1 = { D8 FF BD 27 18 00 B0 AF ?? ?? 10 3C ?? ?? 02 8E 01 00 04 24 ?? ?? 03 3C 20 00 B2 AF 1C 00 B1 AF 24 00 BF AF ?? ?? 64 A0 FF FF 12 34 0A 00 40 10 FF FF 11 3C 68 00 45 8C 64 00 44 8C 21 28 B2 00 ?? ?? ?? 0? 24 28 B1 00 ?? ?? 02 8E 60 00 42 8C F8 FF 40 14 ?? ?? 02 AE 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_321_0_0 {
	meta:
		name = "truncate64"
		size = 60
		refs = "0010 __gnu_local_gp 0028 __libc_errno"
	strings:
		$1 = { 21 28 00 00 73 10 02 24 0C 00 00 00 03 00 E0 14 ?? ?? 1C 3C 08 00 E0 03 00 00 00 00 ?? ?? 9C 27 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_322_0_0 {
	meta:
		name = "__write_nocancel"
		size = 28
	strings:
		$1 = { A4 0F 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_322_1_0 {
	meta:
		name = "__libc_write"
		size = 148
		refs = "0040 __libc_enable_asynccancel 006c __libc_disable_asynccancel"
	strings:
		$1 = { 3B E8 03 7C 70 8B 63 8C 08 00 03 14 00 00 00 00 A4 0F 02 24 0C 00 00 00 F0 FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 D0 FF BD 27 1C 00 BF AF 00 00 A4 AF 04 00 A5 AF 08 00 A6 AF ?? ?? ?? 0? 00 00 00 00 2C 00 A2 AF 00 00 A4 8F 04 00 A5 8F 08 00 A6 8F A4 0F 02 24 0C 00 00 00 24 00 A2 AF 28 00 A7 AF 2C 00 A4 8F ?? ?? ?? 0? 00 00 00 00 24 00 A2 8F 28 00 A7 8F 1C 00 BF 8F D6 FF E0 14 30 00 BD 27 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_142_1_2 {
	meta:
		name = "__libc_write"
		size = 148
		refs = "0040 __pthread_enable_asynccancel 006c __pthread_disable_asynccancel"
	strings:
		$1 = { 3B E8 03 7C 70 8B 63 8C 08 00 03 14 00 00 00 00 A4 0F 02 24 0C 00 00 00 F0 FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 D0 FF BD 27 1C 00 BF AF 00 00 A4 AF 04 00 A5 AF 08 00 A6 AF ?? ?? ?? 0? 00 00 00 00 2C 00 A2 AF 00 00 A4 8F 04 00 A5 8F 08 00 A6 8F A4 0F 02 24 0C 00 00 00 24 00 A2 AF 28 00 A7 AF 2C 00 A4 8F ?? ?? ?? 0? 00 00 00 00 24 00 A2 8F 28 00 A7 8F 1C 00 BF 8F D6 FF E0 14 30 00 BD 27 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_323_0_0 {
	meta:
		name = "wctomb"
		size = 160
		refs = "0008 __wcrtomb 000c __wctomb_state 0010 __gnu_local_gp 0020 _nl_current_LC_CTYPE 0074 _nl_C_LC_CTYPE 0084 __wcsmbs_load_conv 0094 __wcsmbs_gconv_fcts_c"
	strings:
		$1 = { 03 00 80 10 ?? ?? 06 3C ?? ?? ?? 0? ?? ?? C6 24 ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F E0 FF BD 27 18 00 B0 AF 21 10 62 00 00 00 42 8C 1C 00 BF AF 10 00 BC AF 00 00 50 8C 14 00 02 8E 0B 00 40 10 00 00 00 00 ?? ?? 03 3C ?? ?? 64 24 04 00 80 AC 08 00 42 8C 1C 00 BF 8F 18 00 B0 8F 34 00 42 8C ?? ?? 60 AC 08 00 E0 03 20 00 BD 27 ?? ?? 02 3C ?? ?? 42 24 05 00 02 12 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 14 00 02 8E ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 42 24 }
	condition:
		$1
}

rule file_324_0_0 {
	meta:
		name = "sigrelse"
		size = 92
		refs = "0018 __sigprocmask 0028 sigdelset"
	strings:
		$1 = { 60 FF BD 27 21 28 00 00 18 00 A6 27 98 00 B0 AF 21 80 80 00 9C 00 BF AF ?? ?? ?? 0? 03 00 04 24 0C 00 40 04 18 00 A4 27 ?? ?? ?? 0? 21 28 00 02 08 00 40 04 03 00 04 24 18 00 A5 27 ?? ?? ?? 0? 21 30 00 00 9C 00 BF 8F 98 00 B0 8F 08 00 E0 03 A0 00 BD 27 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_668_0_0 {
	meta:
		name = "sighold"
		size = 92
		refs = "0018 __sigprocmask 0028 sigaddset"
	strings:
		$1 = { 60 FF BD 27 21 28 00 00 18 00 A6 27 98 00 B0 AF 21 80 80 00 9C 00 BF AF ?? ?? ?? 0? 03 00 04 24 0C 00 40 04 18 00 A4 27 ?? ?? ?? 0? 21 28 00 02 08 00 40 04 03 00 04 24 18 00 A5 27 ?? ?? ?? 0? 21 30 00 00 9C 00 BF 8F 98 00 B0 8F 08 00 E0 03 A0 00 BD 27 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_325_0_0 {
	meta:
		name = "__mempcpy"
		size = 40
		refs = "000c memcpy"
	strings:
		$1 = { E0 FF BD 27 1C 00 BF AF 18 00 B0 AF ?? ?? ?? 0? 21 80 C0 00 1C 00 BF 8F 21 10 50 00 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_327_0_0 {
	meta:
		name = "l64a"
		size = 80
		refs = "0044 $LC0"
	strings:
		$1 = { 10 00 80 10 ?? ?? 07 3C ?? ?? 02 3C 21 18 00 00 ?? ?? 42 24 ?? ?? E7 24 3F 00 85 30 21 28 E5 00 00 00 A6 90 82 21 04 00 21 28 43 00 00 00 A6 A0 F9 FF 80 14 01 00 63 24 21 18 62 00 08 00 E0 03 00 00 60 A0 ?? ?? 02 3C 08 00 E0 03 ?? ?? 42 24 }
	condition:
		$1
}

rule file_328_0_0 {
	meta:
		name = "rexec_af"
		size = 1368
		refs = "0018 __gnu_local_gp 0020 $LC0 006c __snprintf 00a8 getaddrinfo 00cc free 00d8 __strdup 0100 ruserpass 0114 __libc_errno 012c __socket 0148 __connect 016c __close 0178 __sleep 0188 perror 01c4 $LC2 0204 __listen 021c __getsockname 022c __libc_sa_len 0264 getnameinfo 0280 $LC5 028c sprintf 029c strlen 02ac __write 02e8 accept 0388 __writev 03c4 __read 03e4 freeaddrinfo 03fc strtol 0424 $LC6 0468 $LC3 050c $LC1 0228 $LC4"
	strings:
		$1 = { 30 FE BD 27 00 3A A2 7C 00 2A 05 00 25 10 45 00 B8 01 B4 AF D8 01 A6 AF ?? ?? 1C 3C 21 A0 C0 00 ?? ?? 06 3C ?? ?? 9C 27 B4 01 B3 AF A8 01 B0 AF DC 01 A7 AF 21 80 80 00 20 00 05 24 48 01 A4 27 ?? ?? C6 24 21 98 E0 00 FF FF 47 30 20 00 BC AF CC 01 BF AF B0 01 B2 AF AC 01 B1 AF E8 01 B2 97 C8 01 BE AF C4 01 B7 AF C0 01 B6 AF ?? ?? ?? 0? BC 01 B5 AF 00 00 04 8E 02 00 11 24 48 01 A5 27 68 01 A6 27 90 01 A7 27 67 01 A0 A3 74 01 A0 AF 78 01 A0 AF 7C 01 A0 AF 80 01 A0 AF 84 01 A0 AF 6C 01 B2 AF 70 01 B1 AF ?? ?? ?? 0? 68 01 B1 AF D8 00 40 14 20 00 BC 8F 90 01 A2 8F 18 00 42 8C E1 00 40 10 00 00 00 00 ?? ?? 11 3C ?? ?? ?? 0? ?? ?? 24 8E 90 01 A2 8F ?? ?? ?? 0? 18 00 44 8C 0A 01 40 10 ?? ?? 22 AE 00 00 02 AE 90 01 A2 8F D8 01 A5 27 DC 01 A6 27 18 00 44 8C 06 00 11 24 ?? ?? ?? 0? 01 00 12 24 20 00 BC 8F 3B E8 03 7C 92 00 15 24 ?? ?? 96 8F 21 B0 C3 02 90 01 A2 8F 21 30 00 00 FF FF 31 26 04 00 44 8C ?? ?? ?? 0? 08 00 45 8C 21 F0 40 00 22 00 40 04 21 20 40 00 90 01 A2 8F 14 00 45 8C ?? ?? ?? 0? 10 00 46 8C 21 00 41 04 21 20 C0 03 00 00 C2 8E 0A 00 55 14 90 01 A2 8F 08 00 20 12 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 21 20 40 02 ?? ?? ?? 0? 40 90 12 00 ?? ?? ?? 0? 90 01 A2 8F ?? ?? ?? 0? 18 00 44 8C FF FF 02 24 CC 01 BF 8F C8 01 BE 8F C4 01 B7 8F C0 01 B6 8F BC 01 B5 8F B8 01 B4 8F B4 01 B3 8F B0 01 B2 8F AC 01 B1 8F A8 01 B0 8F 08 00 E0 03 D0 01 BD 27 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? ?? 0? FF FF 02 24 E4 01 A2 8F A2 00 40 10 90 01 A2 8F 21 30 00 00 04 00 44 8C ?? ?? ?? 0? 08 00 45 8C D4 00 40 04 21 90 40 00 21 20 40 00 01 00 05 24 ?? ?? ?? 0? 28 00 B1 27 80 00 02 24 21 20 40 02 21 28 20 02 8C 01 A6 27 ?? ?? ?? 0? 8C 01 A2 AF C2 00 40 04 ?? ?? 04 3C ?? ?? ?? 0? 28 00 A4 97 8C 01 A3 8F 95 00 43 14 20 00 BC 8F 48 01 A3 27 10 00 A3 AF 20 00 03 24 14 00 A3 AF 02 00 03 24 18 00 A3 AF 21 20 20 02 21 28 40 00 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 61 00 40 10 00 00 00 00 21 30 00 00 9C 01 A0 AF 28 01 A2 27 ?? ?? 05 3C ?? ?? A5 24 21 20 40 00 ?? ?? ?? 0? 98 01 A2 AF 98 01 A4 8F FF FF 15 24 ?? ?? ?? 0? 04 00 16 24 98 01 A5 8F 01 00 46 24 ?? ?? ?? 0? 21 20 C0 03 20 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 97 8F 80 00 03 24 88 01 A3 AF ?? ?? ?? 0? 21 B8 E2 02 00 00 E2 8E 50 00 56 14 00 00 00 00 21 20 40 02 A8 00 A5 27 ?? ?? ?? 0? 88 01 A6 27 F8 FF 55 10 21 20 40 02 ?? ?? ?? 0? A0 01 A2 AF A0 01 A3 8F 48 00 60 04 ?? ?? 04 3C E4 01 A2 8F 00 00 43 AC D8 01 A2 8F FF FF 12 24 04 00 16 24 21 20 40 00 ?? ?? ?? 0? 28 00 A2 AF DC 01 A3 8F 01 00 42 24 2C 00 A2 AF 21 20 60 00 ?? ?? ?? 0? 30 00 A3 AF E0 01 A4 8F 01 00 42 24 34 00 A2 AF ?? ?? ?? 0? 38 00 A4 AF 20 00 BC 8F 01 00 42 24 3B E8 03 7C ?? ?? 95 8F 3C 00 A2 AF ?? ?? ?? 0? 21 A8 A3 02 00 00 A2 8E 07 00 56 14 00 00 00 00 21 20 C0 03 21 28 20 02 ?? ?? ?? 0? 03 00 06 24 F8 FF 52 10 D8 01 A4 8F 03 00 94 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 DC 01 A4 8F 04 00 93 10 98 01 A5 8F ?? ?? ?? 0? 00 00 00 00 98 01 A5 8F 21 20 C0 03 ?? ?? ?? 0? 01 00 06 24 01 00 03 24 53 00 43 14 00 00 00 00 28 01 A2 83 3B 00 40 14 0A 00 10 24 ?? ?? ?? 0? 90 01 A4 8F ?? ?? ?? 0? 21 10 C0 03 0A 00 06 24 48 01 A4 27 ?? ?? ?? 0? 21 28 00 00 FF FF 43 30 9C 01 A3 AF ?? ?? ?? 0? FF FF 46 30 ?? ?? ?? 0? FF FF 02 24 ?? ?? ?? 0? 21 20 40 02 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? ?? 0? 21 20 C0 03 ?? ?? ?? 0? 90 01 A4 8F ?? ?? ?? 0? FF FF 02 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 00 00 00 AE 21 10 62 00 00 00 51 AC ?? ?? ?? 0? FF FF 02 24 ?? ?? 05 3C 21 20 C0 03 ?? ?? A5 24 ?? ?? ?? 0? 01 00 06 24 28 01 A3 27 9C 01 A0 AF 28 00 B1 27 ?? ?? ?? 0? 98 01 A3 AF 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 20 40 02 21 10 62 00 16 00 03 24 ?? ?? ?? 0? 00 00 43 AC ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 28 01 A2 83 0B 00 50 10 9C 01 A2 8F 98 01 A5 8F 21 20 C0 03 ?? ?? ?? 0? 01 00 06 24 01 00 03 24 02 00 04 24 98 01 A5 8F F3 FF 43 10 01 00 06 24 9C 01 A2 8F CE FF 40 10 E4 01 A3 8F ?? ?? ?? 0? 00 00 64 8C ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? ?? 0? FF FF 02 24 ?? ?? ?? 0? 00 00 04 8E ?? ?? ?? 0? 9C 01 A2 8F ?? ?? ?? 0? ?? ?? 84 24 ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 20 C0 03 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_328_1_0 {
	meta:
		name = "rexec"
		size = 48
		refs = "001c rexec_af"
	strings:
		$1 = { D0 FF BD 27 40 00 A2 8F 2C 00 BF AF 10 00 A2 AF 44 00 A2 8F 14 00 A2 AF 02 00 02 24 ?? ?? ?? 0? 18 00 A2 AF 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_330_0_0 {
	meta:
		name = "__posix_fadvise64_l64"
		size = 100
	strings:
		$1 = { E0 FF BD 27 1C 00 BE AF 18 00 B1 AF 21 F0 A0 03 14 00 B0 AF F0 FF BD 27 08 00 DD AF 21 28 00 00 34 00 C2 8F 30 00 D0 8F 38 00 D1 8F E0 FF BD 27 10 00 B0 AF 14 00 A2 AF 18 00 B1 AF 9E 10 02 24 0C 00 00 00 20 00 BD 27 21 E8 C0 03 1C 00 BE 8F 18 00 B1 8F 14 00 B0 8F 0A 10 07 00 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_331_0_0 {
	meta:
		name = "__ctype_get_mb_cur_max"
		size = 40
		refs = "0000 __gnu_local_gp 0010 _nl_current_LC_CTYPE"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 42 8C 00 00 42 8C 08 00 E0 03 58 00 42 8C }
	condition:
		$1
}

rule file_332_0_0 {
	meta:
		name = "map_newlink"
		size = 136
	strings:
		$1 = { 11 00 E0 18 FF FF 03 24 00 00 C2 8C 10 00 43 10 00 00 00 00 0F 00 44 10 04 00 C6 24 21 10 00 00 ?? ?? ?? 0? FF FF 08 24 00 00 C3 8C 0C 00 68 10 00 00 00 00 08 00 64 10 04 00 C6 24 01 00 42 24 F9 FF 47 14 00 00 00 00 08 00 E0 03 FF FF 02 24 00 00 C4 AC 21 10 00 00 08 00 E0 03 00 00 00 00 FD FF 40 18 00 00 C4 AC C0 20 02 00 40 19 02 00 21 18 83 00 23 18 62 00 80 18 03 00 21 28 A3 00 08 00 E0 03 64 FF A5 AC }
	condition:
		$1
}

rule file_332_1_0 {
	meta:
		name = "getifaddrs_internal"
		size = 3104
		refs = "004c __netlink_open 005c __netlink_request 0188 __netlink_free_handle 0298 calloc 02ec memset 0790 mempcpy 092c memcpy 0be8 free 0bf8 abort 0c00 $LC0 0c04 $LC1 0c18 __assert_fail 0c08 __PRETTY_FUNCTION__.8565"
	strings:
		$1 = { 70 FF BD 27 88 00 BE AF 21 F0 A0 03 8C 00 BF AF 84 00 B7 AF 80 00 B6 AF 7C 00 B5 AF 78 00 B4 AF 74 00 B3 AF 70 00 B2 AF 6C 00 B1 AF 68 00 B0 AF 90 00 C4 AF 00 00 80 AC 18 00 C4 27 18 00 C0 AF 1C 00 C0 AF 20 00 C0 AF 24 00 C0 AF ?? ?? ?? 0? 28 00 C0 AF DF 02 40 04 18 00 C4 27 ?? ?? ?? 0? 12 00 05 24 7C 00 40 04 20 00 C2 8F 18 00 C4 27 16 00 05 24 01 00 42 24 ?? ?? ?? 0? 20 00 C2 AF 75 00 40 04 24 00 D3 8F 79 00 60 12 1C 00 C7 8F 21 58 60 02 21 C0 00 00 21 68 00 00 34 00 C0 AF 03 00 0E 24 10 00 0F 24 07 00 0C 24 FC FF 06 24 21 50 00 00 04 00 62 8D 2C 00 40 10 08 00 63 8D 10 00 64 2C 29 00 80 14 00 00 00 00 00 00 44 8C 10 00 85 2C 25 00 A0 14 2B 28 64 00 0F 00 A0 10 00 00 00 00 ?? ?? ?? 0? 00 00 6B 8D 03 00 84 24 24 20 86 00 23 18 64 00 10 00 65 2C 1B 00 A0 14 21 10 44 00 00 00 44 8C 10 00 85 2C 17 00 A0 14 2B 28 64 00 15 00 A0 14 00 00 00 00 0C 00 45 8C F2 FF A7 14 00 00 00 00 08 00 48 8C 0C 00 65 8D EE FF 05 15 00 00 00 00 04 00 45 94 0B 00 AE 10 00 00 00 00 23 00 AF 10 14 00 A5 38 03 00 84 24 24 20 86 00 01 00 A5 2C 23 18 64 00 21 68 A5 01 10 00 65 2C E7 FF A0 10 21 10 44 00 00 00 6B 8D D0 FF 60 15 00 00 00 00 21 68 4D 01 34 00 CA AF 3D 00 A0 15 21 80 00 00 ?? ?? ?? 0? 18 00 C4 27 18 00 C4 8F A6 0F 02 24 0C 00 00 00 21 10 00 02 21 E8 C0 03 8C 00 BF 8F 88 00 BE 8F 84 00 B7 8F 80 00 B6 8F 7C 00 B5 8F 78 00 B4 8F 74 00 B3 8F 70 00 B2 8F 6C 00 B1 8F 68 00 B0 8F 08 00 E0 03 90 00 BD 27 E0 FF 85 24 04 00 A8 2C 1C 00 00 15 20 00 49 24 20 00 48 94 04 00 19 2D 18 00 20 17 2B C8 A8 00 16 00 20 17 00 00 00 00 22 00 59 94 0E 00 2C 17 03 00 08 25 FD FF 08 25 ?? ?? ?? 0? FC FF 08 25 00 00 28 95 04 00 19 2D 0C 00 20 17 2B C8 A8 00 0A 00 20 17 00 00 00 00 02 00 39 95 0B 00 2C 13 00 00 00 00 03 00 08 25 24 40 06 01 23 28 A8 00 04 00 B9 2C F2 FF 20 13 21 48 28 01 ?? ?? ?? 0? 01 00 4A 25 ?? ?? ?? 0? FF FF 10 24 FC FF 08 25 21 C0 08 03 ?? ?? ?? 0? 01 00 4A 25 ?? ?? ?? 0? 21 80 00 00 C0 18 0D 00 40 11 0D 00 21 10 62 00 23 68 4D 00 80 88 0D 00 21 C0 38 02 01 00 04 24 21 28 00 03 ?? ?? ?? 0? 60 00 D8 AF ED FF 40 10 38 00 C2 AF 34 00 C3 8F FF FF 05 24 03 00 15 24 80 30 03 00 0E 00 C2 24 C2 10 02 00 C0 10 02 00 23 E8 A2 03 10 00 A3 27 50 00 C3 AF 21 20 60 00 38 00 C3 8F 10 00 10 24 02 00 14 24 21 88 71 00 21 90 60 02 54 00 D1 AF ?? ?? ?? 0? 48 00 C0 AF 04 00 56 8E BC 00 C0 12 08 00 51 8E 10 00 22 2E B9 00 40 14 00 00 00 00 00 00 C2 8E 10 00 44 2C B5 00 80 14 2B 20 22 02 11 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 52 8E 00 00 C2 8E FC FF 03 24 03 00 42 24 24 10 43 00 23 88 22 02 10 00 23 2E A9 00 60 14 21 B0 C2 02 00 00 C2 8E 10 00 43 2C A5 00 60 14 2B 18 22 02 A3 00 60 14 00 00 00 00 0C 00 C4 8E 1C 00 C3 8F EF FF 83 14 00 00 00 00 08 00 C4 8E 0C 00 43 8E EB FF 83 14 00 00 00 00 04 00 C3 96 98 00 75 10 00 00 00 00 33 01 70 10 14 00 04 24 E4 FF 64 14 38 00 C5 8F 14 00 C4 8E 50 00 C6 8F 34 00 C7 8F E8 FF 48 24 FF FF 84 24 ?? ?? ?? 0? 64 00 C8 AF 48 00 C5 8F 34 00 C6 8F 18 00 C3 26 21 20 A6 00 FF FF 05 24 04 02 45 10 64 00 C8 8F C0 30 02 00 40 29 02 00 21 28 C5 00 38 00 C6 8F 23 10 A2 00 C0 48 04 00 40 29 04 00 80 10 02 00 21 48 25 01 21 10 C2 00 23 48 24 01 08 00 42 8C 80 48 09 00 21 B8 C9 00 02 00 80 18 08 00 E2 AE 64 FF F7 AE 48 00 C4 8F 04 00 02 2D 01 00 84 24 E9 00 40 14 48 00 C4 AF 18 00 C4 96 04 00 82 2C E5 00 40 14 2B 10 04 01 E3 00 40 14 1E 00 E5 26 64 00 F3 26 1C 00 EA 26 3C 00 E6 26 88 00 E2 26 40 00 D1 AF 44 00 D2 AF 21 48 60 02 21 90 E0 02 4C 00 C5 AF 21 B8 C0 02 3C 00 C6 AF 30 00 C2 AF 21 B0 00 01 21 88 40 01 ?? ?? ?? 0? 21 98 60 00 BC 00 55 10 04 00 03 24 17 00 43 14 00 00 00 00 14 00 42 8E 0A 00 40 10 00 00 00 00 00 00 20 AD 04 00 20 AD 08 00 20 AD 0C 00 20 AD 10 00 20 AD 14 00 20 AD 18 00 20 AD 1C 00 20 AD 20 00 20 AD 14 00 49 AE 10 00 E2 92 64 00 42 A6 10 00 E2 92 77 01 54 10 0A 00 03 24 6E 01 43 14 25 00 C2 2C 8A 01 D0 10 FE 80 02 34 00 00 62 96 FC FF 03 24 03 00 42 24 24 10 43 00 23 B0 C2 02 04 00 C3 2E AD 00 60 14 21 98 62 02 00 00 64 96 04 00 82 2C A9 00 40 14 2B 10 C4 02 A7 00 40 14 00 00 00 00 02 00 62 96 04 00 65 26 52 00 54 10 FC FF 86 24 03 00 43 2C D2 FF 60 10 01 00 03 24 EA FF 43 14 00 00 00 00 0C 00 42 8E 6E 01 40 10 21 20 20 02 21 20 20 01 14 00 49 AE 10 00 E2 92 00 00 82 A4 10 00 E2 92 44 01 54 10 0A 00 03 24 3B 01 43 14 25 00 C2 2C DC FF D0 14 FE 80 02 34 03 00 AD 88 07 00 AC 88 0B 00 A6 88 0F 00 A3 88 00 00 AD 98 04 00 AC 98 0C 00 A3 98 08 00 A6 98 08 00 8D AC 0C 00 8C AC 10 00 86 AC 14 00 83 AC 04 00 63 8E FF C0 63 30 08 00 62 10 FF 00 02 24 04 00 63 92 C9 FF 62 14 00 00 00 00 05 00 62 92 0F 00 42 30 C5 FF 54 14 00 00 00 00 14 00 E2 8E ?? ?? ?? 0? 18 00 82 AC 00 00 52 8E 40 FF 40 16 38 00 C3 8F 60 00 C4 8F 21 10 64 00 54 00 C3 8F 2B 88 43 00 7D 01 20 16 48 00 C3 8F 15 00 60 10 34 00 C3 8F 13 00 60 10 40 11 03 00 C0 28 03 00 21 28 A2 00 23 28 A3 00 38 00 C3 8F 80 28 05 00 38 00 C2 8F 21 28 65 00 FF FF 06 24 ?? ?? ?? 0? 50 00 C3 8F 9C 00 42 24 06 00 A2 10 04 00 63 24 00 00 64 8C FB FF 86 14 00 00 00 00 ?? ?? ?? 0? 64 FF 45 AC 38 00 C4 8F 90 00 C3 8F 21 80 00 00 ?? ?? ?? 0? 00 00 64 AC 0C 00 42 8E 1A 00 40 10 21 10 20 02 21 18 20 01 0C 00 44 8C 00 00 4A 8C 04 00 48 8C 08 00 47 8C 00 00 6A AC 04 00 68 AC 08 00 67 AC 0C 00 64 AC 3C 00 C4 8F 10 00 42 24 F5 FF 44 14 10 00 63 24 00 00 82 8C 00 00 62 AC 14 00 49 AE 00 00 20 AE 04 00 20 AE 08 00 20 AE 0C 00 20 AE 10 00 20 AE 14 00 20 AE 18 00 20 AE 1C 00 20 AE 20 00 20 AE 0C 00 51 AE 10 00 E2 92 1C 00 42 A6 10 00 E2 92 FC 00 54 10 0A 00 03 24 F3 00 43 14 25 00 C2 2C 78 FF D0 14 FE 80 02 34 03 00 AC 88 07 00 A6 88 0B 00 A4 88 0F 00 A3 88 00 00 AC 98 04 00 A6 98 0C 00 A3 98 08 00 A4 98 24 00 4C AE 28 00 46 AE 2C 00 44 AE 30 00 43 AE 04 00 63 8E FF C0 63 30 08 00 62 10 FF 00 02 24 04 00 63 92 65 FF 62 14 00 00 00 00 05 00 62 92 0F 00 42 30 61 FF 54 14 00 00 00 00 14 00 E2 8E ?? ?? ?? 0? 34 00 42 AE FD FF 84 24 12 00 84 2C 1C 01 80 10 30 00 C4 8F 04 00 44 AE ?? ?? ?? 0? 64 00 C9 AF 00 00 40 A0 00 00 62 96 FC FF 03 24 64 00 C9 8F 03 00 42 24 24 10 43 00 23 B0 C2 02 04 00 C3 2E 55 FF 60 10 21 98 62 02 21 B0 E0 02 40 00 D1 8F 21 B8 40 02 44 00 D2 8F 04 00 E2 8E EE 00 40 10 38 00 C5 8F 0C 00 E2 8E D2 FE 40 10 00 00 00 00 00 00 43 94 CF FE 60 10 11 00 02 24 CD FE 62 10 40 00 E2 26 E1 00 74 10 10 00 E2 AE 0A 00 02 24 DC 00 62 14 48 00 E2 26 80 00 06 24 40 00 E3 A6 11 00 C3 92 FF FF 04 24 2B 28 66 00 0A 18 C5 00 C2 30 03 00 21 28 60 00 EA 00 C0 10 21 18 46 00 01 00 42 24 FE FF 43 14 FF FF 44 A0 07 00 A5 30 08 00 02 24 23 10 45 00 FF FF 04 24 04 10 44 00 ?? ?? ?? 0? 00 00 62 A0 14 00 C4 8E 38 00 C5 8F 50 00 C6 8F 34 00 C7 8F FF FF 84 24 ?? ?? ?? 0? E0 FF 53 24 FF FF 04 24 D8 00 44 10 20 00 C3 26 C0 28 02 00 40 21 02 00 21 20 A4 00 38 00 C5 8F 23 10 82 00 18 00 C4 8E 80 48 02 00 21 B8 A9 00 04 00 62 2E 9F FE 40 14 08 00 E4 AE 20 00 C4 96 04 00 82 2C 9B FE 40 14 2B 10 64 02 99 FE 40 14 70 00 E6 26 64 00 E2 26 88 00 E5 26 44 00 C6 AF 4C 00 C2 AF 28 00 E6 26 1C 00 E2 26 3C 00 D1 AF 40 00 D2 AF 21 88 E0 02 21 90 60 02 30 00 C5 AF 58 00 C6 AF 5C 00 C2 AF 21 B8 60 00 ?? ?? ?? 0? 54 00 D3 8F 3C 00 55 10 FD FF 84 24 07 00 04 24 06 00 44 14 21 10 67 02 18 00 33 AE 21 20 60 02 21 30 E0 00 ?? ?? ?? 0? 21 98 40 00 00 00 E2 96 FC FF 04 24 03 00 42 24 24 10 44 00 23 90 42 02 04 00 44 2E 28 00 80 14 21 B8 E2 02 00 00 E4 96 04 00 82 2C 24 00 40 14 2B 10 44 02 22 00 40 14 00 00 00 00 02 00 E2 96 04 00 E5 26 2A 00 54 10 FC FF 87 24 03 00 46 2C E2 FF C0 10 00 00 00 00 01 00 04 24 E9 FF 44 14 25 00 E2 2C E7 FF 40 10 58 00 C4 8F 11 00 02 24 21 30 E0 00 1C 00 22 A6 ?? ?? ?? 0? 64 00 C7 AF 64 00 C7 8F FC FF 04 24 5C 00 C3 8F 27 00 27 A2 14 00 C2 8E 20 00 22 AE 12 00 C2 96 0C 00 23 AE 24 00 22 A6 00 00 E2 96 03 00 42 24 24 10 44 00 23 90 42 02 04 00 44 2E DA FF 80 10 21 B8 E2 02 54 00 D3 AF 3C 00 D1 8F ?? ?? ?? 0? 40 00 D2 8F 12 00 84 2C CB FF 80 10 30 00 C4 8F 21 30 E0 00 ?? ?? ?? 0? 04 00 24 AE ?? ?? ?? 0? 00 00 40 A0 25 00 E2 2C C3 FF 40 10 44 00 C4 8F 11 00 02 24 21 30 E0 00 64 00 22 A6 ?? ?? ?? 0? 64 00 C7 AF 64 00 C7 8F 4C 00 C3 8F 6F 00 27 A2 14 00 C2 8E 68 00 22 AE 12 00 C2 96 14 00 23 AE ?? ?? ?? 0? 6C 00 22 A6 A2 FE 40 10 00 00 00 00 02 00 84 24 ?? ?? ?? 0? 64 00 C9 AF ?? ?? ?? 0? 64 00 C9 8F 04 00 02 24 9A FE C2 14 00 00 00 00 03 00 A2 88 00 00 A2 98 ?? ?? ?? 0? 04 00 82 AC 94 FE 40 10 00 00 00 00 66 00 44 26 ?? ?? ?? 0? 64 00 C9 AF ?? ?? ?? 0? 64 00 C9 8F 04 00 02 24 8C FE C2 14 00 00 00 00 03 00 A2 88 00 00 A2 98 ?? ?? ?? 0? 68 00 42 AE 86 FE 40 10 00 00 00 00 4C 00 C4 8F ?? ?? ?? 0? 64 00 C9 AF ?? ?? ?? 0? 64 00 C9 8F 04 00 02 24 7E FE C2 14 00 00 00 00 03 00 A2 88 00 00 A2 98 ?? ?? ?? 0? 20 00 42 AE ?? ?? ?? 0? 0C 00 51 AE 03 00 AC 88 07 00 A6 88 0B 00 A4 88 0F 00 A3 88 00 00 AC 98 04 00 A6 98 0C 00 A3 98 08 00 A4 98 6C 00 4C AE 70 00 46 AE 74 00 44 AE 78 00 43 AE 04 00 63 8E FF C0 63 30 08 00 62 10 FF 00 02 24 04 00 63 92 65 FE 62 14 00 00 00 00 05 00 62 92 0F 00 42 30 61 FE 54 14 00 00 00 00 14 00 E2 8E ?? ?? ?? 0? 7C 00 42 AE ?? ?? ?? 0? 40 00 E3 A6 44 00 E2 26 ?? ?? ?? 0? 20 00 06 24 14 00 C4 8E 50 00 C6 8F 34 00 C7 8F ?? ?? ?? 0? FF FF 84 24 FF FF 05 24 0E 00 45 10 40 19 02 00 C0 20 02 00 21 18 83 00 23 10 62 00 38 00 C3 8F 80 10 02 00 21 10 62 00 04 00 42 8C ?? ?? ?? 0? 04 00 E2 AE ?? ?? ?? 0? FF FF 02 24 ?? ?? ?? 0? 21 18 40 00 38 00 C4 8F ?? ?? ?? 0? F5 FF 10 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 1A 03 06 24 ?? ?? ?? 0? ?? ?? E7 24 }
	condition:
		$1
}

rule file_332_2_0 {
	meta:
		name = "__netlink_free_handle"
		size = 116
		refs = "0000 __gnu_local_gp 0010 __libc_errno 0040 free"
	strings:
		$1 = { ?? ?? 1C 3C D8 FF BD 27 ?? ?? 9C 27 1C 00 B1 AF ?? ?? 91 8F 0C 00 84 8C 3B E8 03 7C 21 10 23 02 20 00 B2 AF 24 00 BF AF 18 00 B0 AF 10 00 BC AF 03 00 80 14 00 00 52 8C ?? ?? ?? 0? 24 00 BF 8F ?? ?? ?? 0? 00 00 90 8C FD FF 00 16 21 20 00 02 24 00 BF 8F 3B E8 03 7C 21 88 23 02 00 00 32 AE 18 00 B0 8F 20 00 B2 8F 1C 00 B1 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_332_3_0 {
	meta:
		name = "__netlink_request"
		size = 888
		refs = "0008 __gnu_local_gp 0060 __libc_errno 00e0 __sendto 0150 __recvmsg 02c4 malloc 02e0 memcpy 032c time"
	strings:
		$1 = { 80 FF BD 27 08 00 82 8C ?? ?? 1C 3C 78 00 BE AF 60 00 B2 AF 21 F0 A0 03 58 00 B0 AF 7C 00 BF AF 74 00 B7 AF 70 00 B6 AF 6C 00 B5 AF 68 00 B4 AF 64 00 B3 AF 5C 00 B1 AF F8 EF BD 27 ?? ?? 9C 27 18 00 B2 27 00 10 03 24 18 00 DC AF 21 80 80 00 48 00 D2 AF B4 00 40 10 4C 00 C3 AF 3B E8 03 7C ?? ?? 94 8F 21 20 60 00 14 00 03 24 20 00 C3 AF 28 00 C2 AF 01 03 03 24 10 00 02 24 3C 00 C0 AF 24 00 C5 A7 26 00 C3 A7 2C 00 C0 AF 30 00 C0 A3 31 00 C0 A3 32 00 C0 A3 33 00 C0 A3 40 00 C0 AF 44 00 C0 AF 3C 00 C2 A7 0C 00 13 24 FF FF 11 24 ?? ?? ?? 0? 21 A0 84 02 00 00 83 8E 04 00 02 24 5F 00 62 14 FF FF 03 24 00 00 04 8E 3C 00 C2 27 10 00 A2 AF 14 00 B3 AF 20 00 C5 27 14 00 06 24 ?? ?? ?? 0? 21 38 00 00 F3 FF 51 10 18 00 DC 8F 53 00 40 04 FF FF 03 24 ?? ?? 91 8F 3B E8 03 7C 0C 00 14 24 01 00 13 24 21 88 23 02 3C 00 C2 27 20 00 C2 AF 48 00 C2 27 24 00 D4 AF 28 00 C2 AF 2C 00 D3 AF 30 00 C0 AF 34 00 C0 AF 38 00 C0 AF FF FF 16 24 ?? ?? ?? 0? 04 00 17 24 00 00 22 8E 3F 00 57 14 FF FF 03 24 00 00 04 8E 20 00 C5 27 ?? ?? ?? 0? 21 30 00 00 21 A8 40 00 F7 FF 56 10 18 00 DC 8F 35 00 40 04 40 00 C2 8F E8 FF 40 14 3C 00 C2 27 38 00 C2 8F 20 00 42 30 2F 00 40 14 10 00 A2 2E E2 FF 40 14 3C 00 C2 27 00 00 47 8E 10 00 E2 2C DD FF 40 14 2B 10 A7 02 DB FF 40 14 21 40 A0 02 04 00 09 8E 21 18 40 02 21 58 00 00 03 00 0C 24 02 00 0D 24 ?? ?? ?? 0? FC FF 06 24 2D 00 A0 14 21 18 62 00 00 00 67 8C 10 00 E2 2C 29 00 40 14 2B 20 07 01 27 00 80 14 00 00 00 00 03 00 E2 24 0C 00 64 8C 24 10 46 00 23 40 02 01 F3 FF 24 15 10 00 05 2D 08 00 6A 8C 08 00 04 8E EF FF 44 15 00 00 00 00 04 00 64 94 4D 00 8C 10 01 00 6B 25 EA FF 8D 14 24 00 E7 2C 4D 00 E0 10 00 00 00 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 05 00 03 24 00 00 43 AC FF FF 03 24 21 E8 C0 03 7C 00 BF 8F 78 00 BE 8F 74 00 B7 8F 70 00 B6 8F 6C 00 B5 8F 68 00 B4 8F 64 00 B3 8F 60 00 B2 8F 5C 00 B1 8F 58 00 B0 8F 21 10 60 00 08 00 E0 03 80 00 BD 27 12 00 60 15 21 B0 00 00 A3 FF C0 12 3C 00 C2 27 21 E8 C0 03 7C 00 BF 8F 21 18 00 00 78 00 BE 8F 74 00 B7 8F 70 00 B6 8F 6C 00 B5 8F 68 00 B4 8F 64 00 B3 8F 60 00 B2 8F 5C 00 B1 8F 58 00 B0 8F 21 10 60 00 08 00 E0 03 80 00 BD 27 ?? ?? ?? 0? 10 00 A4 26 DB FF 40 10 21 B8 40 00 10 00 44 24 21 28 40 02 21 30 A0 02 ?? ?? ?? 0? 00 00 40 AC 08 00 04 8E 0C 00 03 8E 04 00 E2 AE 08 00 F5 AE 08 00 60 10 0C 00 E4 AE 10 00 02 8E 00 00 57 AC 10 00 17 AE 80 FF C0 12 3C 00 C2 27 ?? ?? ?? 0? 21 E8 C0 03 0C 00 17 AE ?? ?? ?? 0? 10 00 17 AE 21 20 00 00 ?? ?? ?? 0? 50 00 C5 AF 18 00 DC 8F 08 00 02 AE ?? ?? ?? 0? 50 00 C5 8F CE FF 60 11 01 00 16 24 ?? ?? ?? 0? 00 00 00 00 10 00 62 8C 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 23 10 02 00 21 20 64 00 00 00 82 AC ?? ?? ?? 0? FF FF 03 24 }
	condition:
		$1
}

rule file_332_4_0 {
	meta:
		name = "__netlink_close"
		size = 20
	strings:
		$1 = { 00 00 84 8C A6 0F 02 24 0C 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_332_5_0 {
	meta:
		name = "__netlink_open"
		size = 164
		refs = "0018 __socket 0044 __bind 0060 __getsockname"
	strings:
		$1 = { D0 FF BD 27 03 00 05 24 21 30 00 00 28 00 B0 AF 21 80 80 00 2C 00 BF AF ?? ?? ?? 0? 10 00 04 24 1E 00 40 04 00 00 02 AE 21 20 40 00 18 00 A5 27 10 00 02 24 0C 00 06 24 18 00 A0 AF 1C 00 A0 AF 20 00 A0 AF ?? ?? ?? 0? 18 00 A2 A7 0E 00 40 04 18 00 A5 27 00 00 04 8E 0C 00 02 24 24 00 A6 27 ?? ?? ?? 0? 24 00 A2 AF 07 00 40 04 1C 00 A3 8F 21 10 00 00 04 00 03 AE 2C 00 BF 8F 28 00 B0 8F 08 00 E0 03 30 00 BD 27 00 00 04 8E A6 0F 02 24 0C 00 00 00 ?? ?? ?? 0? FF FF 02 24 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_332_6_0 {
	meta:
		name = "getifaddrs"
		size = 56
	strings:
		$1 = { D8 FF BD 27 20 00 B1 AF 1C 00 B0 AF 24 00 BF AF 21 88 80 00 F5 FF 10 24 ?? ?? ?? 0? 21 20 20 02 FD FF 50 10 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_333_0_0 {
	meta:
		name = "putwchar"
		size = 496
		refs = "0008 _IO_stdout 010c __lll_lock_wait_private 0168 __woverflow 019c _Unwind_Resume"
	strings:
		$1 = { C8 FF BD 27 28 00 B1 AF ?? ?? 11 3C 24 00 B0 AF ?? ?? 30 8E 2C 00 B2 AF 34 00 BF AF 00 00 02 8E 30 00 B3 AF 00 80 42 30 1A 00 40 14 21 90 80 00 3B E8 03 7C 48 00 02 8E 70 8B 73 24 08 00 43 8C 10 00 73 10 21 20 00 02 18 00 A0 AF 00 00 45 C0 06 00 A0 14 00 00 03 24 01 00 01 24 00 00 41 E0 FA FF 20 10 01 00 03 24 0F 00 00 00 26 00 60 10 00 00 00 00 48 00 03 8E ?? ?? 24 8E 21 10 60 00 08 00 73 AC 04 00 43 8C 01 00 63 24 ?? ?? ?? 0? 04 00 43 AC 21 20 00 02 5C 00 82 8C 32 00 40 10 00 00 00 00 10 00 43 8C 14 00 45 8C 2B 28 65 00 2D 00 A0 10 21 88 40 02 04 00 64 24 10 00 44 AC 00 00 72 AC 00 00 02 8E 00 80 42 30 07 00 40 14 34 00 BF 8F 48 00 04 8E 04 00 82 8C FF FF 42 24 0E 00 40 10 04 00 82 AC 34 00 BF 8F 21 10 20 02 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 21 20 40 00 ?? ?? ?? 0? 18 00 A5 AF ?? ?? ?? 0? 48 00 03 8E 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 EA FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 34 00 BF 8F ?? ?? ?? 0? 21 28 40 02 ?? ?? ?? 0? 21 88 40 00 00 00 02 8E 00 80 42 30 06 00 40 14 21 88 80 00 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_334_0_0 {
	meta:
		name = "futimesat"
		size = 440
		refs = "0008 __have_atfcts 0010 __gnu_local_gp 0064 __libc_errno 00d4 strlen 00f8 procfd.7576 0110 __snprintf 0134 __atfct_seterrno 014c __futimes 00b8 procfd.7573"
	strings:
		$1 = { C8 FF BD 27 24 00 B1 AF ?? ?? 11 3C ?? ?? 22 8E ?? ?? 1C 3C 30 00 BE AF ?? ?? 9C 27 21 F0 A0 03 2C 00 B3 AF 28 00 B2 AF 20 00 B0 AF 34 00 BF AF 18 00 DC AF 21 90 80 00 21 80 A0 00 1D 00 40 04 21 98 C0 00 41 00 A0 10 00 00 00 00 C4 10 02 24 0C 00 00 00 0C 00 E0 10 FF FF 03 24 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 28 40 00 21 20 64 00 00 00 82 AC 59 00 03 24 05 00 A3 14 FF FF 02 24 ?? ?? ?? 0? ?? ?? 22 AE 45 00 43 10 00 00 00 00 21 E8 C0 03 34 00 BF 8F 30 00 BE 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 29 00 A0 10 ?? ?? 06 3C 9C FF 02 24 20 00 42 12 2F 00 02 24 00 00 03 82 12 00 62 10 21 88 00 00 ?? ?? ?? 0? 21 20 00 02 28 00 40 10 18 00 DC 8F 2E 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 B1 27 ?? ?? 06 3C 10 00 B0 AF 21 20 20 02 20 00 45 24 ?? ?? C6 24 21 38 40 02 ?? ?? ?? 0? 21 80 20 02 21 20 00 02 21 28 60 02 AB 10 02 24 0C 00 00 00 D9 FF E0 10 21 20 40 00 21 28 40 02 ?? ?? ?? 0? 21 30 20 02 ?? ?? ?? 0? FF FF 02 24 ?? ?? ?? 0? 21 88 00 00 ?? ?? ?? 0? 21 28 C0 00 ?? ?? ?? 0? 21 E8 C0 03 D8 FF BD 27 18 00 B0 27 21 20 00 02 1D 00 05 24 ?? ?? C6 24 ?? ?? ?? 0? 21 38 40 02 ?? ?? ?? 0? 21 88 00 02 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 02 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 ?? ?? ?? 0? 00 00 45 8C }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "__getpeername"
		size = 28
	strings:
		$1 = { 4B 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_336_0_0 {
	meta:
		name = "__lxstat"
		size = 188
		refs = "0004 __gnu_local_gp 0044 __xstat_conv 0064 __libc_errno"
	strings:
		$1 = { 50 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 A8 00 B0 AF 01 00 02 24 21 80 80 00 AC 00 BF AF 10 00 BC AF 18 00 02 12 21 20 A0 00 18 00 A5 27 0B 10 02 24 0C 00 00 00 09 00 E0 14 21 20 40 00 03 00 40 14 21 20 00 02 ?? ?? ?? 0? 18 00 A5 27 AC 00 BF 8F A8 00 B0 8F 08 00 E0 03 B0 00 BD 27 3B E8 03 7C 21 28 60 00 ?? ?? 83 8F AC 00 BF 8F A8 00 B0 8F 21 28 65 00 FF FF 02 24 00 00 A4 AC 08 00 E0 03 B0 00 BD 27 21 28 C0 00 0B 10 02 24 0C 00 00 00 EE FF E0 10 AC 00 BF 8F 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F A8 00 B0 8F 21 20 64 00 00 00 82 AC FF FF 02 24 08 00 E0 03 B0 00 BD 27 }
	condition:
		$1
}

rule file_337_0_0 {
	meta:
		name = "do_sigpause"
		size = 136
		refs = "0034 __sigsuspend 005c __sigprocmask 0070 sigdelset"
	strings:
		$1 = { 58 FF BD 27 A0 00 B1 AF A4 00 BF AF 9C 00 B0 AF 0F 00 A0 14 21 88 80 00 18 00 A4 AF 1C 00 A2 27 98 00 A3 27 04 00 42 24 FE FF 43 14 FC FF 40 AC 18 00 B0 27 ?? ?? ?? 0? 21 20 00 02 A4 00 BF 8F A0 00 B1 8F 9C 00 B0 8F 08 00 E0 03 A8 00 BD 27 18 00 B0 27 21 20 00 00 21 28 00 00 ?? ?? ?? 0? 21 30 00 02 F5 FF 40 04 FF FF 02 24 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 EE FF 41 04 FF FF 02 24 ?? ?? ?? 0? A4 00 BF 8F }
	condition:
		$1
}

rule file_337_1_0 {
	meta:
		name = "__sigpause"
		size = 96
		refs = "0028 __libc_enable_asynccancel 0044 __libc_disable_asynccancel"
		altNames = "__sigwait __sigwaitinfo"
	strings:
		$1 = { 3B E8 03 7C 70 8B 62 8C 03 00 40 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 D8 FF BD 27 24 00 BF AF 20 00 B0 AF 18 00 A4 AF ?? ?? ?? 0? 1C 00 A5 AF 1C 00 A5 8F 18 00 A4 8F ?? ?? ?? 0? 21 80 40 00 21 20 00 02 ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 18 00 A2 8F 20 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_74_1_2 {
	meta:
		name = "__sigwait"
		size = 96
		refs = "0028 __pthread_enable_asynccancel 0044 __pthread_disable_asynccancel"
	strings:
		$1 = { 3B E8 03 7C 70 8B 62 8C 03 00 40 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 D8 FF BD 27 24 00 BF AF 20 00 B0 AF 18 00 A4 AF ?? ?? ?? 0? 1C 00 A5 AF 1C 00 A5 8F 18 00 A4 8F ?? ?? ?? 0? 21 80 40 00 21 20 00 02 ?? ?? ?? 0? 18 00 A2 AF 24 00 BF 8F 18 00 A2 8F 20 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_338_0_0 {
	meta:
		name = "_nl_explode_name"
		size = 708
		refs = "016c _nl_normalize_codeset 0184 strcmp 01f8 __rawmemchr 0220 free"
	strings:
		$1 = { C0 FF BD 27 30 00 B4 AF 28 00 B2 AF 50 00 B4 8F 54 00 B2 8F 3C 00 BF AF 38 00 B6 AF 34 00 B5 AF 2C 00 B3 AF 24 00 B1 AF 20 00 B0 AF 00 00 C0 AC 00 00 E0 AC 00 00 80 AE 00 00 40 AE 00 00 A4 AC 00 00 82 80 BF FF 03 24 24 18 43 00 68 00 60 10 00 00 00 00 5F 00 03 24 66 00 43 10 21 28 00 00 2E 00 03 24 63 00 43 10 40 00 08 24 21 18 80 00 5F 00 05 24 ?? ?? ?? 0? 2E 00 09 24 6E 00 45 10 00 00 00 00 8A 00 48 10 00 00 00 00 21 00 49 10 00 00 00 00 01 00 63 24 00 00 62 80 F7 FF 40 14 00 00 00 00 52 00 83 10 00 00 00 00 21 98 00 00 00 00 E2 8C 05 00 40 10 00 00 00 00 00 00 42 80 02 00 40 14 FB FF 02 24 24 98 62 02 00 00 82 8E 3D 00 40 10 3C 00 BF 8F 00 00 43 80 04 00 60 14 21 10 60 02 FD FF 03 24 24 10 63 02 3C 00 BF 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 40 00 BD 27 36 00 83 10 21 A8 00 00 02 00 13 24 01 00 64 24 00 00 60 A0 00 00 84 AE 01 00 63 80 BF FF 02 24 24 10 62 00 37 00 40 10 21 88 80 00 ?? ?? ?? 0? BF FF 02 24 21 88 00 02 01 00 23 82 24 28 62 00 FC FF A0 14 01 00 30 26 11 00 90 10 40 00 02 24 23 28 04 02 18 00 A6 AF ?? ?? ?? 0? 1C 00 A7 AF 21 B0 40 00 4B 00 40 10 00 00 42 AE 00 00 84 8E ?? ?? ?? 0? 21 28 40 00 18 00 A6 8F 23 00 40 10 1C 00 A7 8F 01 00 23 82 03 00 B3 36 40 00 02 24 C2 FF 62 14 00 00 00 00 01 00 02 26 00 00 00 A2 00 00 C2 AC 01 00 03 82 08 00 62 36 ?? ?? ?? 0? 0B 98 43 00 21 10 60 02 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 40 00 BD 27 21 28 00 00 18 00 A6 AF ?? ?? ?? 0? 1C 00 A7 AF 21 80 40 00 00 00 43 80 21 98 00 00 18 00 A6 8F ?? ?? ?? 0? 1C 00 A7 8F ?? ?? ?? 0? 21 80 80 00 ?? ?? ?? 0? 21 20 C0 02 01 00 23 82 18 00 A6 8F ?? ?? ?? 0? 1C 00 A7 8F EE FF 83 10 21 28 00 00 01 00 70 24 00 00 60 A0 00 00 F0 AC 01 00 63 80 0F 00 60 10 2E 00 02 24 0F 00 62 10 40 00 02 24 0B 00 62 10 2E 00 02 24 ?? ?? ?? 0? 40 00 04 24 09 00 62 10 00 00 00 00 C9 FF 64 10 04 00 13 24 01 00 10 26 00 00 03 82 F9 FF 60 14 00 00 00 00 ?? ?? ?? 0? 04 00 13 24 21 18 00 02 06 00 13 24 ?? ?? ?? 0? 04 00 15 24 ?? ?? ?? 0? FF FF 02 24 CF FF 83 10 00 00 00 00 21 80 60 00 ?? ?? ?? 0? 21 98 00 00 }
	condition:
		$1
}

rule file_339_0_0 {
	meta:
		name = "fseeko"
		size = 452
		refs = "0074 __lll_lock_wait_private 00a8 _IO_seekoff_unlocked 0170 _Unwind_Resume"
		altNames = "fseek"
	strings:
		$1 = { 00 00 82 8C C0 FF BD 27 34 00 B2 AF 00 80 42 30 30 00 B1 AF 2C 00 B0 AF 3C 00 BF AF 38 00 B3 AF 21 80 80 00 21 90 A0 00 1A 00 40 14 21 88 C0 00 3B E8 03 7C 48 00 84 8C 70 8B 73 24 08 00 82 8C 11 00 53 10 00 00 00 00 20 00 A0 AF 00 00 83 C0 06 00 60 14 00 00 02 24 01 00 01 24 00 00 81 E0 FA FF 20 10 01 00 02 24 0F 00 00 00 03 00 40 14 00 00 00 00 ?? ?? ?? 0? 20 00 A3 AF 48 00 02 8E 21 20 40 00 08 00 53 AC 04 00 82 8C 01 00 42 24 04 00 82 AC 03 00 02 24 21 30 40 02 10 00 B1 AF 14 00 A2 AF 21 20 00 02 ?? ?? ?? 0? C3 3F 12 00 00 00 04 8E 24 10 43 00 01 00 51 24 01 00 31 2E 00 80 84 30 06 00 80 14 23 88 11 00 48 00 04 8E 04 00 82 8C FF FF 42 24 09 00 40 10 04 00 82 AC 3C 00 BF 8F 21 10 20 02 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 08 00 80 AC 0F 00 00 00 00 00 82 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 42 28 EF FF 40 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 3C 00 BF 8F 00 00 02 8E 00 80 42 30 06 00 40 14 21 88 80 00 48 00 04 8E 04 00 83 8C FF FF 63 24 03 00 60 10 04 00 83 AC ?? ?? ?? 0? 21 20 20 02 08 00 80 AC 0F 00 00 00 00 00 83 C0 00 00 01 24 00 00 81 E0 FC FF 20 10 00 00 00 00 02 00 63 28 F5 FF 60 14 00 00 00 00 3B E8 03 7C 78 8B 65 8C 01 00 06 24 21 38 00 00 01 00 A5 34 8E 10 02 24 0C 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_340_0_0 {
	meta:
		name = "_dl_discover_osversion"
		size = 328
		refs = "0010 __uname 00e8 $LC0 00f0 __open 0108 __read 0114 __close"
	strings:
		$1 = { 10 FE BD 27 18 00 A4 27 EC 01 BF AF E8 01 B1 AF ?? ?? ?? 0? E4 01 B0 AF 33 00 40 14 9A 00 A4 27 21 38 00 00 21 10 00 00 2E 00 08 24 03 00 09 24 00 00 85 80 D0 FF A5 24 FF 00 A3 30 0A 00 63 2C 21 00 60 10 EC 01 BF 8F 01 00 83 80 D0 FF 66 24 FF 00 C6 30 0A 00 C6 2C 0C 00 C0 10 01 00 84 24 40 30 05 00 C0 28 05 00 21 28 C5 00 01 00 84 24 21 28 A3 00 00 00 83 80 D0 FF 66 24 FF 00 C6 30 0A 00 C6 2C F6 FF C0 14 D0 FF A5 24 00 12 02 00 01 00 E7 24 25 10 A2 00 08 00 68 14 01 00 84 24 E3 FF E9 14 00 00 00 00 EC 01 BF 8F E8 01 B1 8F E4 01 B0 8F 08 00 E0 03 F0 01 BD 27 03 00 03 24 F9 FF E3 10 EC 01 BF 8F 03 00 03 24 23 38 67 00 C0 38 07 00 E8 01 B1 8F E4 01 B0 8F 04 10 E2 00 08 00 E0 03 F0 01 BD 27 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 21 28 00 00 11 00 40 04 21 80 40 00 21 20 40 00 A0 01 A5 27 ?? ?? ?? 0? 40 00 06 24 21 88 40 00 ?? ?? ?? 0? 21 20 00 02 08 00 20 1A 40 00 23 2A 3F 00 02 24 0B 10 23 02 18 00 A3 27 21 10 62 00 88 01 40 A0 ?? ?? ?? 0? A0 01 A4 27 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_341_0_0 {
	meta:
		name = "__gconv_open"
		size = 2104
		refs = "0004 __gnu_local_gp 004c strchr 00e4 _nl_current_LC_CTYPE 00f8 strlen 011c mempcpy 0164 __gconv_find_transform 0190 __gconv_translit_find 01c8 malloc 01dc __libc_errno 01f8 __gconv_close_transform 0264 memset 0274 _nl_C_locobj 02dc __strcasecmp_l 040c memcpy 04a4 $LC0 04a8 __gconv_transliterate 05a4 $LC1 06f4 free"
	strings:
		$1 = { 98 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 60 00 BE AF 40 00 B0 AF 21 F0 A0 03 21 80 A0 00 2F 00 05 24 48 00 B2 AF 64 00 BF AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 44 00 B1 AF 18 00 DC AF 21 90 80 00 70 00 C6 AF ?? ?? ?? 0? 74 00 C7 AF 08 00 40 10 01 00 44 24 ?? ?? ?? 0? 2F 00 05 24 05 00 40 10 21 B8 00 00 01 00 43 80 DD 00 60 14 01 00 51 24 21 B8 00 00 34 00 C0 AF 21 20 00 02 ?? ?? ?? 0? 2F 00 05 24 09 00 40 10 18 00 DC 8F 01 00 44 24 ?? ?? ?? 0? 2F 00 05 24 04 00 40 10 18 00 DC 8F 01 00 43 80 9F 01 60 14 01 00 42 24 00 00 42 92 2F 00 03 24 1D 00 43 14 00 00 00 00 01 00 51 92 1A 00 22 16 00 00 00 00 02 00 42 92 17 00 40 14 00 00 00 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 42 8C 00 00 42 8C 5C 00 53 8C ?? ?? ?? 0? 21 20 60 02 11 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 B2 27 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 21 30 40 00 18 00 DC 8F 00 00 51 A0 01 00 51 A0 02 00 40 A0 00 00 02 92 2F 00 03 24 04 00 43 14 00 00 00 00 01 00 11 92 3C 01 22 12 00 00 00 00 74 00 C2 8F 21 20 40 02 21 28 00 02 10 00 A2 AF 28 00 C6 27 ?? ?? ?? 0? 24 00 C7 27 30 00 C2 AF 27 00 40 14 21 A0 00 00 0E 00 E0 12 21 A8 E0 02 21 80 00 00 00 00 E2 8E 05 00 40 10 21 20 E0 02 ?? ?? ?? 0? 00 00 00 00 9C 01 40 14 00 00 00 00 04 00 E2 8E 04 00 40 10 21 80 E0 02 ?? ?? ?? 0? 21 B8 40 00 21 A8 00 00 24 00 D0 8F 40 11 10 00 80 88 10 00 21 88 22 02 ?? ?? ?? 0? 08 00 24 26 21 A0 40 00 1E 00 40 14 18 00 DC 8F ?? ?? 92 8F 3B E8 03 7C 21 28 00 02 21 10 43 02 00 00 55 8C 28 00 C4 8F 03 00 02 24 ?? ?? ?? 0? 30 00 C2 AF 3B E8 03 7C 21 10 43 02 00 00 55 AC 21 A0 00 00 70 00 C3 8F 30 00 C2 8F 00 00 74 AC 21 E8 C0 03 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 00 00 50 AC 08 00 44 24 28 00 C2 8F 21 28 00 00 21 30 20 02 ?? ?? ?? 0? 04 00 82 AE 24 00 C2 8F E7 FF 40 10 ?? ?? 11 3C 28 00 92 26 21 80 00 00 21 98 00 00 ?? ?? 31 26 F8 FF 42 26 3A 00 A0 12 F4 FF 42 AE 21 B8 A0 02 0C 00 E2 8E 33 00 40 10 21 B0 00 00 ?? ?? ?? 0? 08 00 E5 8E 0C 00 E2 8E 2B 10 C2 02 2D 00 40 10 00 00 00 00 08 00 E5 8E 28 00 C4 8F 80 10 16 00 21 10 A2 00 21 20 90 00 0C 00 84 8C 00 00 45 8C 21 30 20 02 ?? ?? ?? 0? 01 00 D6 26 F1 FF 40 14 00 00 00 00 18 00 F9 8E 08 00 20 13 20 00 C0 AF 28 00 C2 8F 20 00 C4 27 21 10 50 00 09 F8 20 03 10 00 45 8C 17 00 40 14 00 00 00 00 ?? ?? ?? 0? 14 00 04 24 E2 00 40 10 18 00 DC 8F 1C 00 E3 8E 10 00 E6 8E 14 00 E5 8E 00 00 44 8E 08 00 43 AC 20 00 C3 8F 00 00 46 AC 04 00 45 AC 0C 00 43 AC 04 00 80 14 10 00 40 AC ?? ?? ?? 0? 21 20 40 02 21 20 60 00 10 00 83 8C FD FF 60 14 10 00 84 24 00 00 82 AC 04 00 F7 8E C9 FF E0 16 00 00 00 00 24 00 D7 8F FF FF E2 26 2B 10 62 02 1A 01 40 10 34 00 C3 8F 28 00 C2 8F E8 FF 43 AE 21 10 50 00 30 00 42 8C 40 21 02 00 40 13 02 00 23 28 44 00 21 20 A0 00 ?? ?? ?? 0? 38 00 C5 AF 18 00 DC 8F E0 FF 42 AE BA 00 40 10 38 00 C5 8F 01 00 73 26 21 10 45 00 2B 18 77 02 E4 FF 42 AE 3C 00 10 26 AB FF 60 14 24 00 52 26 ?? ?? ?? 0? 70 00 C3 8F 23 10 32 02 0F 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 A4 27 21 30 40 00 21 10 82 00 21 28 40 02 ?? ?? ?? 0? 00 00 40 A0 21 20 20 02 ?? ?? ?? 0? 21 90 40 00 0F 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 A4 27 21 28 20 02 ?? ?? ?? 0? 01 00 46 24 21 A8 40 00 00 00 42 80 2C 00 03 24 06 00 43 14 00 00 00 00 01 00 B5 26 00 00 A2 82 FE FF 43 10 01 00 B5 26 FF FF B5 26 04 FF 40 10 21 B8 00 00 01 00 B3 26 ?? ?? ?? 0? 2C 00 05 24 CA 00 45 10 00 00 00 00 21 98 80 00 00 00 62 82 FB FF 40 14 01 00 64 26 21 B8 00 00 F9 FE A0 12 34 00 C0 AF ?? ?? 02 3C ?? ?? 05 3C ?? ?? 07 3C 21 20 A0 02 ?? ?? A5 24 ?? ?? 46 24 ?? ?? ?? 0? ?? ?? F6 24 39 00 40 14 ?? ?? 05 3C AA 00 E0 12 ?? ?? 02 3C 10 00 E2 8E 16 00 56 10 21 20 E0 02 ?? ?? ?? 0? 04 00 82 8C 10 00 45 8C 11 00 B6 10 21 20 40 00 04 00 82 8C FB FF 40 14 ?? ?? 03 3C D8 FF BD 27 18 00 A2 27 ?? ?? 63 24 01 00 05 24 18 00 A0 AF 1C 00 A0 AF 2C 00 A0 AF 30 00 A0 AF 34 00 A0 AF 20 00 A3 AF 24 00 A5 AF 28 00 B6 AF 04 00 82 AC 00 00 62 82 2C 00 04 24 06 00 44 14 00 00 00 00 01 00 73 26 00 00 62 82 FE FF 44 10 01 00 73 26 FF FF 73 26 CA FE 40 10 01 00 65 26 ?? ?? ?? 0? 2C 00 06 24 7E 00 46 10 00 00 00 00 21 28 80 00 00 00 A2 80 FB FF 40 14 01 00 A4 24 C0 FE 60 12 21 A8 60 02 ?? ?? 02 3C 21 98 A0 00 ?? ?? 05 3C 21 20 A0 02 ?? ?? A5 24 ?? ?? ?? 0? ?? ?? 46 24 C9 FF 40 10 ?? ?? 05 3C ?? ?? 06 3C 21 20 A0 02 ?? ?? A5 24 ?? ?? ?? 0? ?? ?? C6 24 6B 00 40 10 02 00 03 24 7B 00 E0 12 ?? ?? 11 3C 21 A0 E0 02 ?? ?? ?? 0? ?? ?? 31 26 21 A0 40 00 00 00 82 8E 21 20 A0 02 21 30 20 02 05 00 40 10 21 28 40 00 ?? ?? ?? 0? 00 00 00 00 CD FF 40 10 00 00 00 00 04 00 82 8E F4 FF 40 14 00 00 00 00 D8 FF BD 27 18 00 A2 27 1C 00 A0 AF 20 00 A0 AF 24 00 A0 AF 28 00 A0 AF 2C 00 A0 AF 30 00 A0 AF 34 00 A0 AF 18 00 B5 AF ?? ?? ?? 0? 04 00 82 AE 02 00 02 92 C4 FE 40 14 74 00 C2 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 42 8C 00 00 42 8C 5C 00 53 8C ?? ?? ?? 0? 21 20 60 02 11 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 B0 27 21 20 00 02 21 28 60 02 ?? ?? ?? 0? 21 30 40 00 00 00 51 A0 01 00 51 A0 ?? ?? ?? 0? 02 00 40 A0 ?? ?? ?? 0? 00 00 82 AC ?? ?? 92 8F 3B E8 03 7C FF FF 62 26 21 20 43 02 18 00 60 12 00 00 95 8C 80 B0 02 00 40 11 02 00 21 B0 C2 02 28 00 D6 26 21 B0 96 02 00 00 D0 8E 03 00 00 16 00 00 00 00 ?? ?? ?? 0? E0 FF C4 8E 08 00 19 8E 3C 00 20 17 10 00 11 8E ?? ?? ?? 0? 21 20 00 02 FA FF 20 16 21 80 20 02 E0 FF C4 8E FF FF 73 26 ?? ?? ?? 0? DC FF D6 26 EF FF 60 16 00 00 00 00 ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 24 00 C5 8F 23 30 50 00 0F 00 C2 24 C2 10 02 00 C0 10 02 00 23 E8 A2 03 18 00 A4 27 21 10 86 00 21 28 00 02 ?? ?? ?? 0? 00 00 40 A0 21 80 40 00 ?? ?? ?? 0? 18 00 DC 8F 00 00 A0 A0 ?? ?? ?? 0? 21 28 80 00 ?? ?? ?? 0? 34 00 C3 AF D8 FF BD 27 18 00 B7 27 ?? ?? 42 24 08 00 E2 AE 01 00 02 24 00 00 E0 AE 04 00 E0 AE 14 00 E0 AE 18 00 E0 AE 1C 00 E0 AE 0C 00 E2 AE ?? ?? ?? 0? 10 00 F6 AE 00 00 60 A2 ?? ?? ?? 0? 21 98 80 00 D8 FF BD 27 18 00 B7 27 04 00 E0 AE 08 00 E0 AE 0C 00 E0 AE 10 00 E0 AE 14 00 E0 AE 18 00 E0 AE 1C 00 E0 AE ?? ?? ?? 0? 00 00 F5 AE 09 F8 20 03 0C 00 04 8E ?? ?? ?? 0? 00 00 00 00 80 10 13 00 40 99 13 00 21 10 53 00 21 10 82 02 01 00 77 34 ?? ?? ?? 0? 10 00 57 AC 06 00 00 12 00 00 00 00 04 00 E2 8E 04 00 02 AE 04 00 E2 8E ?? ?? ?? 0? 21 B8 00 02 04 00 F5 8E 21 B8 00 00 ?? ?? ?? 0? 21 10 A0 02 }
	condition:
		$1
}

rule file_344_0_0 {
	meta:
		name = "atexit"
		size = 36
		refs = "0000 __dso_handle 0014 __cxa_atexit"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 24 04 00 60 10 00 00 00 00 ?? ?? 46 8C ?? ?? ?? 0? 21 28 00 00 ?? ?? ?? 0? 21 30 00 00 }
	condition:
		$1
}

rule file_345_0_0 {
	meta:
		name = "utime"
		size = 28
	strings:
		$1 = { BE 0F 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_346_0_0 {
	meta:
		name = "strchr"
		size = 268
	strings:
		$1 = { 03 00 82 30 08 00 40 14 FF 00 A3 30 ?? ?? ?? 0? FF 00 A5 30 33 00 40 10 01 00 84 24 03 00 82 30 06 00 40 10 00 00 00 00 00 00 82 90 F9 FF 43 14 00 00 00 00 08 00 E0 03 21 10 80 00 FF 00 A5 30 00 5A 05 00 25 28 65 01 00 5C 05 00 FE 7E 07 3C 01 81 0A 3C 25 58 65 01 FF FE E7 34 00 01 4A 25 04 00 82 24 FC FF 45 8C 26 30 AB 00 27 48 06 00 27 40 05 00 21 30 C7 00 21 28 A7 00 26 30 26 01 26 28 05 01 25 28 C5 00 24 28 AA 00 17 00 A0 10 00 00 00 00 FC FF 45 90 E6 FF A3 10 00 00 00 00 10 00 A0 10 00 00 00 00 FD FF 45 90 11 00 A3 10 00 00 00 00 0B 00 A0 10 00 00 00 00 FE FF 45 90 0E 00 A3 10 00 00 00 00 06 00 A0 10 00 00 00 00 FF FF 45 90 0B 00 A3 10 00 00 00 00 E0 FF A0 14 21 20 40 00 08 00 E0 03 21 10 00 00 ?? ?? ?? 0? 21 20 40 00 08 00 E0 03 01 00 82 24 08 00 E0 03 02 00 82 24 08 00 E0 03 03 00 82 24 }
	condition:
		$1
}

rule file_347_0_0 {
	meta:
		name = "mbrtoc16"
		size = 744
		refs = "0000 __gnu_local_gp 0070 _nl_current_LC_CTYPE 00b4 _dl_mcount_wrapper_check 0188 $LC1 018c $LC2 01a0 __assert_fail 0190 __PRETTY_FUNCTION__.8888 023c $LC0 0258 __libc_errno 0098 _nl_C_LC_CTYPE 02a4 __wcsmbs_load_conv 02bc $LC3 02dc __wcsmbs_gconv_fcts_c"
	strings:
		$1 = { ?? ?? 1C 3C 80 FF BD 27 ?? ?? 9C 27 68 00 B2 AF 64 00 B1 AF 60 00 B0 AF 7C 00 BF AF 78 00 B6 AF 74 00 B5 AF 70 00 B4 AF 6C 00 B3 AF 20 00 BC AF 21 80 E0 00 21 90 80 00 8D 00 E0 10 21 88 A0 00 00 00 02 8E 58 00 40 04 00 F0 42 7C 01 00 02 24 34 00 A0 AF 38 00 A2 AF 30 00 A2 AF 3C 00 B0 AF 76 00 20 12 48 00 A0 AF 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 54 00 B6 27 28 00 B6 AF 21 10 62 00 00 00 42 8C 58 00 A3 27 2C 00 A3 AF 00 00 53 8C 14 00 74 8E 80 00 80 12 ?? ?? 02 3C 21 98 26 02 2B 10 71 02 77 00 40 14 4C 00 B1 AF 00 00 82 8E 14 00 55 8C ?? ?? ?? 0? 21 20 A0 02 00 00 84 8E 50 00 A2 27 14 00 A2 AF 01 00 02 24 10 00 A0 AF 18 00 A0 AF 1C 00 A2 AF 28 00 A5 27 4C 00 A6 27 21 C8 A0 02 09 F8 20 03 21 38 60 02 FB FF 03 24 24 18 43 00 1D 00 60 14 20 00 BC 8F 54 00 A3 8F 4C 00 A2 8F 01 00 04 3C 2A 20 64 00 35 00 80 10 23 10 51 00 03 00 40 12 28 00 A4 8F 00 00 43 A6 28 00 A4 8F 08 00 96 10 7C 00 BF 8F 07 00 60 14 78 00 B6 8F 3C 00 A3 8F 00 00 63 8C 5F 00 60 14 21 10 00 00 7C 00 BF 8F 78 00 B6 8F 74 00 B5 8F 70 00 B4 8F 6C 00 B3 8F 68 00 B2 8F 64 00 B1 8F 60 00 B0 8F 08 00 E0 03 80 00 BD 27 06 00 03 24 37 00 43 10 07 00 03 24 40 00 43 10 05 00 03 24 DF FF 43 10 54 00 A3 8F ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 71 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 04 00 03 8E 00 00 02 AE 00 00 43 A6 04 00 00 AE 7C 00 BF 8F 78 00 B6 8F 74 00 B5 8F 70 00 B4 8F 6C 00 B3 8F 68 00 B2 8F 64 00 B1 8F 60 00 B0 8F FD FF 02 24 08 00 E0 03 80 00 BD 27 03 00 40 12 83 22 03 00 C0 D7 84 24 00 00 44 A6 00 00 05 8E 00 80 04 3C FF 03 63 30 25 20 A4 00 00 DC 05 34 21 18 65 00 04 00 03 AE 7C 00 BF 8F 00 00 04 AE 78 00 B6 8F 74 00 B5 8F 70 00 B4 8F 6C 00 B3 8F 68 00 B2 8F 64 00 B1 8F 60 00 B0 8F 08 00 E0 03 80 00 BD 27 ?? ?? 11 3C 01 00 06 24 ?? ?? 31 26 ?? ?? ?? 0? 21 90 00 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 58 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 ?? ?? 10 3C ?? ?? ?? 0? ?? ?? 10 26 ?? ?? ?? 0? FE FF 02 24 FF FF 02 24 F1 FF 22 12 FF FF 13 24 ?? ?? ?? 0? 00 00 82 8E ?? ?? 42 24 0F 00 62 12 21 20 60 02 ?? ?? ?? 0? 58 00 A6 AF 20 00 BC 8F 14 00 74 8E ?? ?? ?? 0? 58 00 A6 8F ?? ?? 04 3C ?? ?? 05 3C ?? ?? 07 3C ?? ?? 84 24 ?? ?? A5 24 80 00 06 24 ?? ?? ?? 0? ?? ?? E7 24 ?? ?? 14 3C ?? ?? ?? 0? ?? ?? 94 26 }
	condition:
		$1
}

rule file_348_0_0 {
	meta:
		name = "__posix_openpt"
		size = 344
		refs = "0010 __gnu_local_gp 0034 __open 0030 $LC0 0080 $LC1 0088 __statfs 00a4 $LC2 00c8 __close 00dc __libc_errno"
	strings:
		$1 = { 90 FF BD 27 64 00 B1 AF ?? ?? 11 3C ?? ?? 22 8E ?? ?? 1C 3C ?? ?? 9C 27 6C 00 BF AF 68 00 B2 AF 60 00 B0 AF 44 00 40 14 10 00 BC AF 21 28 80 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 21 80 40 00 FF FF 02 24 2D 00 02 12 10 00 BC 8F ?? ?? 12 3C ?? ?? 42 8E 0A 00 40 10 00 00 00 00 01 00 02 24 ?? ?? 42 AE 21 10 00 02 6C 00 BF 8F 68 00 B2 8F 64 00 B1 8F 60 00 B0 8F 08 00 E0 03 70 00 BD 27 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 18 00 A5 27 04 00 40 14 18 00 A3 8F D1 1C 02 24 F0 FF 62 10 01 00 02 24 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 18 00 A5 27 04 00 40 14 18 00 A3 8F 73 13 02 24 E6 FF 62 10 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 10 00 BC 8F 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 01 00 03 24 ?? ?? 23 AE 02 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 00 00 43 8C 02 00 02 24 04 00 62 10 00 00 00 00 13 00 04 24 D1 FF 64 14 FF FF 02 24 01 00 02 24 ?? ?? 22 AE ?? ?? ?? 0? FF FF 02 24 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 02 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_348_1_0 {
	meta:
		name = "__bsd_getpt"
		size = 280
		refs = "0004 __gnu_local_gp 0008 $LC3 0038 mempcpy 004c __libc_errno 0048 __libc_ptyname1 0050 __libc_ptyname2 00a0 __open"
	strings:
		$1 = { B8 FF BD 27 ?? ?? 1C 3C ?? ?? 05 3C ?? ?? 9C 27 18 00 A4 27 ?? ?? A5 24 08 00 06 24 40 00 B5 AF 3C 00 B4 AF 38 00 B3 AF 34 00 B2 AF 30 00 B1 AF 10 00 BC AF 44 00 BF AF ?? ?? ?? 0? 2C 00 B0 AF 10 00 BC 8F 3B E8 03 7C ?? ?? 13 3C ?? ?? 95 8F ?? ?? 14 3C 21 88 40 00 02 00 40 A0 ?? ?? 73 26 70 00 02 24 ?? ?? 94 26 FF FF 12 24 21 A8 A3 02 00 00 22 A2 21 80 80 02 ?? ?? ?? 0? 30 00 03 24 00 00 A3 8E 1B 00 64 10 44 00 BF 8F FF FF 03 82 11 00 60 10 00 00 00 00 18 00 A4 27 01 00 23 A2 ?? ?? ?? 0? 02 00 05 24 01 00 10 26 F4 FF 52 10 02 00 04 24 44 00 BF 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 48 00 BD 27 01 00 73 26 FF FF 62 82 E3 FF 40 14 00 00 00 00 00 00 A4 AE ?? ?? ?? 0? FF FF 02 24 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F FF FF 02 24 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_348_2_0 {
	meta:
		name = "__getpt"
		size = 44
		refs = "0008 __posix_openpt 0024 __bsd_getpt"
	strings:
		$1 = { E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 02 00 04 24 FF FF 03 24 03 00 43 10 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? 20 00 BD 27 }
	condition:
		$1
}

rule file_349_0_0 {
	meta:
		name = "__bb_exit_func"
		size = 644
		refs = "000c $LC0 0004 $LC1 0034 _IO_new_fopen 0074 fwrite_unlocked 007c __bb_head 0108 __overflow 01c0 _IO_new_fclose 01f4 perror"
	strings:
		$1 = { A0 FF BD 27 ?? ?? 05 3C 40 00 B1 AF ?? ?? 11 3C ?? ?? 24 26 ?? ?? A5 24 3C 00 B0 AF 5C 00 BF AF 58 00 B7 AF 54 00 B6 AF 50 00 B5 AF 4C 00 B4 AF 48 00 B3 AF ?? ?? ?? 0? 44 00 B2 AF 6D 00 40 10 21 80 40 00 00 00 42 8C 6F 6E 03 3C 67 6D 63 24 00 80 42 34 00 00 02 AE 18 00 A4 27 01 00 02 24 14 00 05 24 01 00 06 24 21 38 00 02 18 00 A3 AF 30 00 A2 AF ?? ?? ?? 0? 1C 00 A2 AF ?? ?? 02 3C ?? ?? 56 8C 02 00 17 24 4D 00 C0 12 FF FF 13 24 14 00 02 8E 18 00 03 8E 0C 00 C4 8E 2B 18 43 00 73 00 60 10 2C 00 A4 AF 01 00 43 24 14 00 03 AE 00 00 57 A0 14 00 02 8E 18 00 05 8E 2C 00 A3 27 04 00 11 24 2B 28 45 00 01 00 72 24 0D 00 A0 10 01 00 44 24 00 00 63 90 14 00 04 AE 00 00 43 A0 FF FF 31 26 0C 00 20 12 21 18 40 02 14 00 02 8E 18 00 05 8E 01 00 72 24 2B 28 45 00 F5 FF A0 14 01 00 44 24 00 00 65 90 ?? ?? ?? 0? 21 20 00 02 F3 FF 53 14 00 00 00 00 2C 00 A2 8F 25 00 40 10 21 A0 00 00 14 00 D2 8E 80 A8 14 00 04 00 11 24 21 90 55 02 01 00 52 26 14 00 02 8E 18 00 03 8E FF FF 31 26 2B 18 43 00 37 00 60 10 01 00 44 24 14 00 04 AE FF FF 43 82 00 00 43 A0 F6 FF 20 16 01 00 52 26 08 00 D2 8E 04 00 11 24 21 90 55 02 01 00 52 26 14 00 02 8E 18 00 03 8E FF FF 31 26 2B 18 43 00 2F 00 60 10 01 00 44 24 14 00 04 AE FF FF 43 82 00 00 43 A0 F6 FF 20 16 01 00 52 26 2C 00 A2 8F 01 00 94 26 2B 10 82 02 DD FF 40 14 00 00 00 00 10 00 D6 8E B5 FF C0 16 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 5C 00 BF 8F 58 00 B7 8F 54 00 B6 8F 50 00 B5 8F 4C 00 B4 8F 48 00 B3 8F 44 00 B2 8F 40 00 B1 8F 3C 00 B0 8F 08 00 E0 03 60 00 BD 27 ?? ?? ?? 0? ?? ?? 24 26 5C 00 BF 8F 58 00 B7 8F 54 00 B6 8F 50 00 B5 8F 4C 00 B4 8F 48 00 B3 8F 44 00 B2 8F 40 00 B1 8F 3C 00 B0 8F 08 00 E0 03 60 00 BD 27 FF FF 45 92 ?? ?? ?? 0? 21 20 00 02 CB FF 53 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 FF FF 45 92 ?? ?? ?? 0? 21 20 00 02 D1 FF 53 14 2C 00 A2 8F 01 00 94 26 2B 10 82 02 B0 FF 40 14 00 00 00 00 ?? ?? ?? 0? 10 00 D6 8E 21 20 00 02 ?? ?? ?? 0? 02 00 05 24 ?? ?? ?? 0? 14 00 02 8E }
	condition:
		$1
}

rule file_350_0_0 {
	meta:
		name = "accept4"
		size = 200
		refs = "0000 __gnu_local_gp 0040 __libc_errno 006c __libc_enable_asynccancel 00b8 __libc_disable_asynccancel"
	strings:
		$1 = { ?? ?? 1C 3C D0 FF BD 27 ?? ?? 9C 27 2C 00 BF AF 28 00 B0 AF 10 00 BC AF 3B E8 03 7C 70 8B 62 8C 0F 00 40 14 00 00 00 00 EE 10 02 24 0C 00 00 00 08 00 E0 10 2C 00 BF 8F 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F 21 20 64 00 00 00 82 AC FF FF 02 24 2C 00 BF 8F 28 00 B0 8F 08 00 E0 03 30 00 BD 27 18 00 A4 AF 1C 00 A5 AF 20 00 A6 AF ?? ?? ?? 0? 24 00 A7 AF 21 F8 40 00 10 00 BC 8F 18 00 A4 8F 1C 00 A5 8F 20 00 A6 8F 24 00 A7 8F EE 10 02 24 0C 00 00 00 07 00 E0 10 21 80 40 00 3B E8 03 7C 21 20 60 00 ?? ?? 83 8F FF FF 10 24 21 20 64 00 00 00 82 AC 21 20 E0 03 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 10 00 02 }
	condition:
		$1
}

rule file_351_0_0 {
	meta:
		name = "dysize"
		size = 116
	strings:
		$1 = { 03 00 83 30 19 00 60 14 6D 01 02 24 EB 51 07 3C 1F 85 E7 34 18 00 87 00 C3 37 04 00 10 38 00 00 43 29 07 00 23 28 A6 00 80 18 05 00 00 29 05 00 21 18 65 00 80 28 03 00 21 18 65 00 0B 00 83 14 6E 01 02 24 C3 39 07 00 23 30 E6 00 00 19 06 00 80 31 06 00 21 30 66 00 80 18 06 00 21 30 C3 00 23 20 86 00 6D 01 03 24 0B 10 64 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_352_0_0 {
	meta:
		name = "__statvfs64"
		size = 128
		refs = "0020 __statfs64 003c __xstat64 0058 __internal_statvfs64"
	strings:
		$1 = { D0 FE BD 27 24 01 B2 AF 21 90 A0 00 B8 00 A5 27 20 01 B1 AF 1C 01 B0 AF 2C 01 BF AF 28 01 B3 AF ?? ?? ?? 0? 21 88 80 00 0D 00 40 14 21 80 40 00 18 00 B3 27 03 00 04 24 21 28 20 02 ?? ?? ?? 0? 21 30 60 02 27 10 02 00 21 38 00 00 21 20 20 02 21 28 40 02 B8 00 A6 27 ?? ?? ?? 0? 0B 38 62 02 2C 01 BF 8F 21 10 00 02 28 01 B3 8F 24 01 B2 8F 20 01 B1 8F 1C 01 B0 8F 08 00 E0 03 30 01 BD 27 }
	condition:
		$1
}

rule file_354_0_0 {
	meta:
		name = "__scalbn"
		size = 384
		refs = "0090 $LC3 00a0 $LC4 00b0 __muldf3 00c4 $LC1 00d4 $LC2 00fc __adddf3 0124 $LC0 0164 $LC5"
		altNames = "__scalbln"
	strings:
		$1 = { E0 FF BD 27 00 55 A2 7C 21 38 A0 00 18 00 B0 AF 1C 00 BF AF 3E 00 40 10 21 80 C0 00 21 18 A0 00 FF 07 05 24 34 00 45 10 21 48 80 00 FF FF 05 3C B0 3C A5 24 2A 28 05 02 22 00 A0 14 00 00 00 00 51 C3 05 34 2A 28 05 02 11 00 A0 10 21 10 50 00 FF 07 45 28 0E 00 A0 10 00 00 00 00 39 00 40 18 CB FF 45 28 0F 80 07 3C FF FF E7 34 00 15 02 00 24 18 67 00 25 38 43 00 1C 00 BF 8F 18 00 B0 8F 21 10 80 00 21 18 E0 00 08 00 E0 03 20 00 BD 27 ?? ?? 02 3C ?? ?? 44 8C 04 00 E1 04 ?? ?? 45 8C ?? ?? 03 3C ?? ?? 64 8C ?? ?? 65 8C ?? ?? 47 8C ?? ?? ?? 0? ?? ?? 46 8C 21 20 40 00 ?? ?? ?? 0? 21 38 60 00 ?? ?? 02 3C ?? ?? 44 8C 04 00 E1 04 ?? ?? 45 8C ?? ?? 03 3C ?? ?? 64 8C ?? ?? 65 8C ?? ?? 47 8C ?? ?? ?? 0? ?? ?? 46 8C 21 20 40 00 ?? ?? ?? 0? 21 38 60 00 21 28 E0 00 ?? ?? ?? 0? 21 30 20 01 21 20 40 00 ?? ?? ?? 0? 21 38 60 00 00 F0 A2 7C 25 10 44 00 D8 FF 40 10 1C 00 BF 8F ?? ?? 06 3C ?? ?? C7 8C ?? ?? ?? 0? ?? ?? C6 8C 00 55 65 7C 21 20 40 00 21 38 60 00 ?? ?? ?? 0? CA FF A2 24 DF FF A0 14 36 00 42 24 0F 80 05 3C FF FF A5 34 24 18 65 00 00 15 02 00 25 10 43 00 ?? ?? 03 3C ?? ?? 67 8C ?? ?? 66 8C ?? ?? ?? 0? 21 28 40 00 21 20 40 00 ?? ?? ?? 0? 21 38 60 00 }
	condition:
		$1
}

rule file_355_0_0 {
	meta:
		name = "mkstemp"
		size = 16
		refs = "0008 __gen_tempname"
	strings:
		$1 = { 21 28 00 00 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 }
	condition:
		$1
}

rule file_356_0_0 {
	meta:
		name = "svc_find"
		size = 136
		refs = "001c __rpc_thread_variables"
	strings:
		$1 = { D8 FF BD 27 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 24 00 BF AF 21 80 80 00 21 88 A0 00 ?? ?? ?? 0? 21 90 C0 00 B4 00 43 8C 15 00 60 10 21 20 00 00 ?? ?? ?? 0? 04 00 62 8C 00 00 62 8C 09 00 40 10 21 20 60 00 21 18 40 00 04 00 62 8C FA FF 50 14 00 00 00 00 08 00 62 8C F7 FF 51 14 21 10 60 00 21 18 80 00 24 00 BF 8F 00 00 43 AE 1C 00 B1 8F 20 00 B2 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_356_1_0 {
	meta:
		name = "xprt_register"
		size = 384
		refs = "0014 __rpc_thread_variables 002c _rpc_dtablesize 0054 __rpc_thread_svc_max_pollfd 005c __rpc_thread_svc_pollfd 00a0 realloc 0104 __rpc_thread_svc_fdset 0168 malloc"
	strings:
		$1 = { D8 FF BD 27 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 24 00 BF AF ?? ?? ?? 0? 21 90 80 00 21 88 40 00 B0 00 42 8C 4E 00 40 10 00 00 50 8E ?? ?? ?? 0? 00 00 00 00 2A 10 02 02 2C 00 40 10 80 18 10 00 B0 00 24 8E 00 04 02 2A 21 18 83 00 2D 00 40 14 00 00 72 AC ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 88 40 00 00 00 44 8C 21 90 40 00 00 00 27 8E 21 28 00 00 21 18 80 00 ?? ?? ?? 0? FF FF 09 24 F8 FF 66 8C 2D 00 C9 10 01 00 A5 24 2A 30 A7 00 21 40 60 00 FA FF C0 14 08 00 63 24 01 00 E5 24 ?? ?? ?? 0? C0 28 05 00 10 00 40 10 FF 1F 03 3C 00 00 24 8E FF FF 63 34 01 00 84 24 21 28 83 00 C0 28 05 00 21 28 45 00 00 00 42 AE 00 00 24 AE 00 00 B0 AC 00 00 24 8E 21 18 83 00 C0 18 03 00 21 10 43 00 C3 00 03 24 04 00 43 A4 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 00 00 00 00 00 00 04 2A 1F 00 03 26 0A 18 04 02 43 19 03 00 80 18 03 00 21 10 43 00 00 00 44 8C 01 00 03 24 04 18 03 02 25 18 83 00 ?? ?? ?? 0? 00 00 43 AC 24 00 BF 8F C3 00 02 24 00 00 10 AD 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 04 00 02 A5 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 80 20 02 00 AE FF 40 14 B0 00 22 AE ?? ?? ?? 0? 24 00 BF 8F }
	condition:
		$1
}

rule file_356_2_0 {
	meta:
		name = "xprt_unregister"
		size = 256
		refs = "0020 _rpc_dtablesize 0034 __rpc_thread_variables 007c __rpc_thread_svc_fdset 00b4 __rpc_thread_svc_max_pollfd 00d4 __rpc_thread_svc_pollfd"
	strings:
		$1 = { D0 FF BD 27 1C 00 B1 AF 00 00 91 8C 18 00 B0 AF 2C 00 BF AF 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF ?? ?? ?? 0? 21 80 80 00 2A 10 22 02 0A 00 40 10 2C 00 BF 8F ?? ?? ?? 0? 00 00 00 00 B0 00 43 8C 80 10 11 00 21 10 62 00 00 00 43 8C 09 00 70 10 00 04 23 2A 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 0F 00 60 10 00 00 40 AC ?? ?? ?? 0? 00 00 00 00 00 00 24 2A 1F 00 23 26 0A 18 24 02 43 19 03 00 80 18 03 00 21 10 43 00 00 00 44 8C 01 00 03 24 04 18 23 02 27 18 03 00 24 18 83 00 00 00 43 AC ?? ?? ?? 0? 21 80 00 00 00 00 52 8C 21 98 40 00 FF FF 14 24 2A 18 12 02 E2 FF 60 10 2C 00 BF 8F ?? ?? ?? 0? 00 00 00 00 00 00 42 8C C0 18 10 00 21 18 43 00 00 00 64 8C F6 FF 91 14 01 00 10 26 00 00 74 AC ?? ?? ?? 0? 00 00 72 8E }
	condition:
		$1
}

rule file_356_3_0 {
	meta:
		name = "svc_register"
		size = 216
		refs = "0078 malloc 0090 __rpc_thread_variables 00c0 pmap_set"
	strings:
		$1 = { C8 FF BD 27 28 00 B2 AF 21 90 A0 00 30 00 B4 AF 24 00 B1 AF 21 28 C0 00 21 88 C0 00 21 A0 80 00 18 00 A6 27 21 20 40 02 2C 00 B3 AF 20 00 B0 AF 34 00 BF AF ?? ?? ?? 0? 21 98 E0 00 0E 00 40 10 21 80 40 00 0C 00 42 8C 18 00 53 10 48 00 A2 8F 21 98 00 00 34 00 BF 8F 21 10 60 02 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? 14 00 04 24 F3 FF 40 10 21 80 40 00 04 00 52 AC 08 00 51 AC ?? ?? ?? 0? 0C 00 53 AC B4 00 43 8C 10 00 00 AE 00 00 03 AE B4 00 50 AC 48 00 A2 8F E9 FF 40 10 01 00 13 24 04 00 87 96 21 20 40 02 21 28 20 02 ?? ?? ?? 0? 21 30 40 00 E1 FF 40 10 00 00 00 00 ?? ?? ?? 0? 10 00 13 AE }
	condition:
		$1
}

rule file_356_4_0 {
	meta:
		name = "svc_unregister"
		size = 164
		refs = "0044 free 0070 pmap_unset 0090 __rpc_thread_variables"
	strings:
		$1 = { D0 FF BD 27 1C 00 A6 27 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 2C 00 BF AF 21 90 80 00 ?? ?? ?? 0? 21 88 A0 00 14 00 40 10 21 80 40 00 1C 00 A2 8F 17 00 40 10 00 00 00 00 00 00 03 8E 00 00 43 AC 21 20 00 02 ?? ?? ?? 0? 00 00 00 AE 21 20 40 02 21 28 20 02 ?? ?? ?? 0? 18 00 A6 27 04 00 40 10 21 20 40 02 10 00 42 8C 04 00 40 14 2C 00 BF 8F ?? ?? ?? 0? 21 28 20 02 2C 00 BF 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? ?? 0? 00 00 00 00 00 00 03 8E ?? ?? ?? 0? B4 00 43 AC }
	condition:
		$1
}

rule file_356_5_0 {
	meta:
		name = "svc_sendreply"
		size = 84
	strings:
		$1 = { 20 00 88 8C 24 00 87 8C 28 00 83 8C 08 00 82 8C B0 FF BD 27 38 00 A5 AF 24 00 A8 AF 28 00 A7 AF 2C 00 A3 AF 34 00 A6 AF 30 00 A0 AF 0C 00 59 8C 01 00 02 24 4C 00 BF AF 18 00 A5 27 1C 00 A2 AF 09 F8 20 03 20 00 A0 AF 4C 00 BF 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_356_6_0 {
	meta:
		name = "svcerr_noproc"
		size = 80
	strings:
		$1 = { 28 00 83 8C 24 00 85 8C 20 00 86 8C B0 FF BD 27 08 00 82 8C 2C 00 A3 AF 03 00 03 24 24 00 A6 AF 28 00 A5 AF 30 00 A3 AF 0C 00 59 8C 01 00 02 24 4C 00 BF AF 18 00 A5 27 1C 00 A2 AF 09 F8 20 03 20 00 A0 AF 4C 00 BF 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_356_7_0 {
	meta:
		name = "svcerr_decode"
		size = 80
	strings:
		$1 = { 28 00 83 8C 24 00 85 8C 20 00 86 8C B0 FF BD 27 08 00 82 8C 2C 00 A3 AF 04 00 03 24 24 00 A6 AF 28 00 A5 AF 30 00 A3 AF 0C 00 59 8C 01 00 02 24 4C 00 BF AF 18 00 A5 27 1C 00 A2 AF 09 F8 20 03 20 00 A0 AF 4C 00 BF 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_356_8_0 {
	meta:
		name = "svcerr_systemerr"
		size = 80
	strings:
		$1 = { 28 00 83 8C 24 00 85 8C 20 00 86 8C B0 FF BD 27 08 00 82 8C 2C 00 A3 AF 05 00 03 24 24 00 A6 AF 28 00 A5 AF 30 00 A3 AF 0C 00 59 8C 01 00 02 24 4C 00 BF AF 18 00 A5 27 1C 00 A2 AF 09 F8 20 03 20 00 A0 AF 4C 00 BF 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_356_9_0 {
	meta:
		name = "svcerr_auth"
		size = 56
	strings:
		$1 = { 08 00 83 8C B0 FF BD 27 01 00 02 24 28 00 A5 AF 24 00 A2 AF 0C 00 79 8C 4C 00 BF AF 18 00 A5 27 1C 00 A2 AF 09 F8 20 03 20 00 A2 AF 4C 00 BF 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_356_10_0 {
	meta:
		name = "svcerr_weakauth"
		size = 60
	strings:
		$1 = { 08 00 83 8C B0 FF BD 27 01 00 02 24 05 00 05 24 28 00 A5 AF 24 00 A2 AF 0C 00 79 8C 4C 00 BF AF 18 00 A5 27 1C 00 A2 AF 09 F8 20 03 20 00 A2 AF 4C 00 BF 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_356_11_0 {
	meta:
		name = "svcerr_noprog"
		size = 76
	strings:
		$1 = { 28 00 85 8C 20 00 87 8C 24 00 86 8C 08 00 83 8C B0 FF BD 27 01 00 02 24 24 00 A7 AF 28 00 A6 AF 2C 00 A5 AF 30 00 A2 AF 0C 00 79 8C 4C 00 BF AF 18 00 A5 27 1C 00 A2 AF 09 F8 20 03 20 00 A0 AF 4C 00 BF 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_356_12_0 {
	meta:
		name = "svcerr_progvers"
		size = 88
	strings:
		$1 = { 28 00 83 8C 20 00 88 8C 24 00 87 8C B0 FF BD 27 08 00 82 8C 2C 00 A3 AF 02 00 03 24 34 00 A5 AF 24 00 A8 AF 28 00 A7 AF 30 00 A3 AF 38 00 A6 AF 0C 00 59 8C 01 00 02 24 4C 00 BF AF 18 00 A5 27 1C 00 A2 AF 09 F8 20 03 20 00 A0 AF 4C 00 BF 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_356_13_0 {
	meta:
		name = "svc_getreq_common"
		size = 496
		refs = "0024 __rpc_thread_variables 0044 _null_auth 0110 svcerr_progvers 0150 svcerr_noprog 019c _authenticate"
	strings:
		$1 = { A8 FA BD 27 18 00 A2 27 14 05 A2 AF A8 01 A2 27 4C 05 B1 AF 48 05 B0 AF 54 05 BF AF 21 80 80 00 50 05 B2 AF ?? ?? ?? 0? 20 05 A2 AF 21 88 40 00 B0 00 42 8C 80 80 10 00 21 10 50 00 00 00 50 8C 3D 00 00 12 ?? ?? 12 3C 08 00 02 8E 21 20 00 02 00 00 59 8C 09 F8 20 03 F8 04 A5 27 2E 00 40 10 38 03 A3 27 40 05 A3 AF 04 05 A3 8F 10 05 A2 8F 44 05 B0 AF 28 05 A3 AF 08 05 A3 8F 34 05 A2 AF 2C 05 A3 AF 0C 05 A3 8F 30 05 A3 AF 14 05 A3 8F 38 05 A3 AF 18 05 A3 8F 3F 00 40 14 3C 05 A3 AF ?? ?? 42 8E 28 00 00 AE 20 00 02 AE B4 00 23 8E 27 00 60 10 28 05 A8 8F 2C 05 AA 8F 21 48 00 00 21 30 00 00 ?? ?? ?? 0? FF FF 05 24 00 00 63 8C 0D 00 60 10 00 00 00 00 04 00 67 8C FB FF 07 15 00 00 00 00 08 00 67 8C 01 00 09 24 2B 20 E5 00 39 00 EA 10 2B 10 C7 00 00 00 63 8C 0B 28 E4 00 F5 FF 60 14 0B 30 E2 00 11 00 20 11 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 08 00 02 8E 04 00 59 8C 09 F8 20 03 21 20 00 02 11 00 40 10 01 00 03 24 C5 FF 43 10 00 00 00 00 54 05 BF 8F 50 05 B2 8F 4C 05 B1 8F 48 05 B0 8F 08 00 E0 03 58 05 BD 27 ?? ?? ?? 0? 21 20 00 02 08 00 02 8E 04 00 59 8C 09 F8 20 03 21 20 00 02 F1 FF 40 14 01 00 03 24 08 00 02 8E 14 00 59 8C 09 F8 20 03 21 20 00 02 54 05 BF 8F 50 05 B2 8F 4C 05 B1 8F 48 05 B0 8F 08 00 E0 03 58 05 BD 27 28 05 A4 27 ?? ?? ?? 0? F8 04 A5 27 C1 FF 40 10 01 00 03 24 D4 04 A3 AF D8 04 A2 AF D0 04 A3 AF 08 00 02 8E CC 04 A3 AF 21 20 00 02 0C 00 59 8C 09 F8 20 03 C8 04 A5 27 ?? ?? ?? 0? 08 00 02 8E 0C 00 79 8C 28 05 A4 27 09 F8 20 03 21 28 00 02 ?? ?? ?? 0? 08 00 02 8E }
	condition:
		$1
}

rule file_356_14_0 {
	meta:
		name = "svc_getreqset"
		size = 184
		refs = "0024 _rpc_dtablesize 0058 svc_getreq_common"
	strings:
		$1 = { C8 FF BD 27 30 00 B6 AF 2C 00 B5 AF 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 34 00 BF AF 1C 00 B1 AF 18 00 B0 AF ?? ?? ?? 0? 21 A8 80 00 00 04 16 24 01 04 43 28 0B B0 43 00 21 90 00 00 1F 00 13 24 13 00 C0 1A 01 00 14 24 04 00 B5 26 ?? ?? ?? 0? FC FF B0 8E 04 88 34 02 ?? ?? ?? 0? 26 80 11 02 23 88 10 00 24 88 11 02 20 88 31 72 23 88 71 02 01 00 23 26 21 20 43 02 F6 FF 60 14 FF FF 84 24 20 00 52 26 2A 10 56 02 F0 FF 40 14 04 00 B5 26 34 00 BF 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_356_15_0 {
	meta:
		name = "svc_getreq"
		size = 56
		refs = "0024 svc_getreqset"
	strings:
		$1 = { 60 FF BD 27 21 28 80 00 18 00 A2 27 9C 00 BF AF 98 00 A3 27 00 00 40 AC 04 00 42 24 FD FF 43 14 18 00 A4 27 ?? ?? ?? 0? 18 00 A5 AF 9C 00 BF 8F 08 00 E0 03 A0 00 BD 27 }
	condition:
		$1
}

rule file_356_16_0 {
	meta:
		name = "svc_getreq_poll"
		size = 228
		refs = "002c __rpc_thread_svc_max_pollfd 0070 __rpc_thread_variables 0080 xprt_unregister 00d4 svc_getreq_common"
	strings:
		$1 = { C8 FF BD 27 28 00 B4 AF 34 00 BF AF 30 00 B6 AF 2C 00 B5 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 21 00 A0 10 21 A0 A0 00 ?? ?? ?? 0? 21 80 80 00 00 00 46 8C 21 88 00 00 21 A8 40 00 2A 18 26 02 21 98 00 00 18 00 60 10 FF FF 16 24 00 00 12 8E 11 00 56 12 00 00 00 00 06 00 03 86 0E 00 60 10 20 00 62 30 1A 00 40 10 00 00 00 00 ?? ?? ?? 0? 80 90 12 00 B0 00 42 8C 21 90 52 00 ?? ?? ?? 0? 00 00 44 8E 01 00 73 26 2A 10 74 02 07 00 40 10 34 00 BF 8F 00 00 A6 8E 01 00 31 26 2A 18 26 02 EA FF 60 14 08 00 10 26 34 00 BF 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? 01 00 73 26 }
	condition:
		$1
}

rule file_356_17_0 {
	meta:
		name = "__svc_accept_failed"
		size = 100
		refs = "0000 __gnu_local_gp 0010 __libc_errno 0050 __nanosleep"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F D8 FF BD 27 24 00 BF AF 21 10 62 00 00 00 43 8C 18 00 02 24 04 00 62 10 10 00 BC AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 FA 02 02 3C 18 00 A4 27 21 28 00 00 80 F0 42 34 18 00 A0 AF ?? ?? ?? 0? 1C 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_356_18_0 {
	meta:
		name = "__rpc_thread_svc_cleanup"
		size = 64
		refs = "000c __rpc_thread_variables 0020 svc_unregister"
	strings:
		$1 = { E0 FF BD 27 18 00 B0 AF 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 80 40 00 04 00 64 8C ?? ?? ?? 0? 08 00 65 8C B4 00 03 8E FB FF 60 14 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_357_0_0 {
	meta:
		name = "__fxstatat64"
		size = 456
		refs = "0004 __gnu_local_gp 003c __have_atfcts 0088 __libc_errno 00e8 strlen 010c procfd.7592 0124 __snprintf 0150 __atfct_seterrno"
	strings:
		$1 = { C0 FF BD 27 ?? ?? 1C 3C ?? ?? 9C 27 38 00 BE AF 03 00 02 24 21 F0 A0 03 28 00 B1 AF 3C 00 BF AF 34 00 B4 AF 30 00 B3 AF 2C 00 B2 AF 24 00 B0 AF 18 00 DC AF 52 00 82 14 50 00 D1 8F ?? ?? 13 3C ?? ?? 62 8E 21 90 A0 00 21 80 C0 00 1C 00 40 04 21 A0 E0 00 21 20 A0 00 21 28 C0 00 21 30 E0 00 21 38 20 02 C5 10 02 24 0C 00 00 00 4C 00 E0 10 21 20 40 00 59 00 02 24 10 00 82 10 FF FF 02 24 3B E8 03 7C 21 28 60 00 ?? ?? 83 8F 21 28 65 00 00 00 A4 AC 21 E8 C0 03 3C 00 DF 8F 38 00 BE 8F 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? 62 AE FF FE 02 24 24 10 22 02 2D 00 40 14 00 00 00 00 9C FF 02 24 28 00 42 12 2F 00 02 24 00 00 03 82 12 00 62 10 21 98 00 00 ?? ?? ?? 0? 21 20 00 02 2D 00 40 10 18 00 DC 8F 2E 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 18 00 B3 27 ?? ?? 06 3C 10 00 B0 AF 21 20 60 02 20 00 45 24 ?? ?? C6 24 21 38 40 02 ?? ?? ?? 0? 21 80 60 02 00 01 31 32 21 20 00 02 0A 00 20 12 21 28 80 02 76 10 02 24 0C 00 00 00 D3 FF E0 10 21 20 40 00 21 28 40 02 ?? ?? ?? 0? 21 30 60 02 ?? ?? ?? 0? FF FF 02 24 75 10 02 24 0C 00 00 00 CA FF E0 10 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 ?? ?? ?? 0? 21 98 00 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 16 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 ?? ?? ?? 0? 21 10 00 00 3B E8 03 7C 21 10 60 00 ?? ?? 83 8F 21 10 62 00 02 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_358_0_0 {
	meta:
		name = "setdomainname"
		size = 28
	strings:
		$1 = { 19 10 02 24 0C 00 00 00 FB FF E0 14 00 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_359_0_0 {
	meta:
		name = "__posix_spawn"
		size = 44
		refs = "0018 __spawni"
	strings:
		$1 = { D0 FF BD 27 40 00 A2 8F 18 00 A0 AF 2C 00 BF AF 10 00 A2 AF 44 00 A2 8F ?? ?? ?? 0? 14 00 A2 AF 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_360_1_0 {
	meta:
		name = "svcudp_getargs"
		size = 20
	strings:
		$1 = { 30 00 84 8C 21 C8 A0 00 21 28 C0 00 08 00 20 03 08 00 84 24 }
	condition:
		$1
}

rule file_360_2_0 {
	meta:
		name = "svcudp_freeargs"
		size = 28
	strings:
		$1 = { 30 00 84 8C 02 00 02 24 21 C8 A0 00 08 00 82 AC 21 28 C0 00 08 00 20 03 08 00 84 24 }
	condition:
		$1
}

rule file_360_3_0 {
	meta:
		name = "svcudp_destroy"
		size = 100
		refs = "0014 xprt_unregister 001c __close 003c free"
	strings:
		$1 = { D8 FF BD 27 1C 00 B0 AF 21 80 80 00 24 00 BF AF 20 00 B1 AF ?? ?? ?? 0? 30 00 91 8C ?? ?? ?? 0? 00 00 04 8E 0C 00 22 8E 1C 00 59 8C 03 00 20 13 00 00 00 00 09 F8 20 03 08 00 24 26 ?? ?? ?? 0? 2C 00 04 8E ?? ?? ?? 0? 21 20 20 02 24 00 BF 8F 20 00 B1 8F 21 20 00 02 1C 00 B0 8F ?? ?? ?? 0? 28 00 BD 27 }
	condition:
		$1
}

rule file_360_4_0 {
	meta:
		name = "svcudp_recv"
		size = 972
		refs = "0000 __gnu_local_gp 0010 __libc_errno 00a8 __recvmsg 0174 xdr_callmsg 0220 memcmp 0250 __sendto 0274 __recvfrom 02a0 __svc_accept_failed 03bc __sendmsg"
	strings:
		$1 = { ?? ?? 1C 3C B0 FF BD 27 ?? ?? 9C 27 3C 00 B4 AF ?? ?? 94 8F 34 00 B2 AF 30 00 92 8C 3B E8 03 7C 48 00 B7 AF 44 00 B6 AF 40 00 B5 AF 38 00 B3 AF 30 00 B1 AF 2C 00 B0 AF 4C 00 BF AF 18 00 BC AF 21 80 80 00 21 B8 A0 00 34 00 96 24 3C 00 93 24 10 00 91 24 58 00 95 24 21 A0 83 02 48 00 03 8E 10 00 02 24 21 28 60 02 21 30 00 00 21 38 00 00 7B 00 60 10 20 00 A2 AF 2C 00 03 8E 00 00 47 8E 00 00 04 8E 34 00 03 AE 40 00 02 AE 01 00 03 24 DC 00 02 24 38 00 07 AE 44 00 16 AE 48 00 03 AE 3C 00 11 AE 4C 00 15 AE ?? ?? ?? 0? 50 00 02 AE 73 00 40 04 20 00 A3 8F 50 00 05 8E 40 00 04 8E 0C 00 A3 2C 1D 00 60 14 20 00 A4 AF 4C 00 03 8E 1A 00 60 10 00 00 00 00 00 00 66 8C 0C 00 C7 2C 10 00 E0 14 03 00 C7 24 FC FF 08 24 24 38 E8 00 21 38 67 00 21 28 65 00 0C 00 E9 24 2B 48 A9 00 08 00 20 15 00 00 00 00 00 00 E9 8C 03 00 29 25 24 40 28 01 21 38 E8 00 2B 28 A7 00 07 00 A0 10 00 00 00 00 04 00 65 8C 04 00 A0 14 08 00 05 24 08 00 67 8C 74 00 E5 10 00 00 00 00 4C 00 00 AE 50 00 00 AE 0C 00 04 AE 10 00 42 28 62 00 40 14 08 00 54 26 0C 00 42 8E 21 20 80 02 14 00 59 8C 01 00 02 24 21 28 00 00 09 F8 20 03 08 00 42 AE 21 20 80 02 ?? ?? ?? 0? 21 28 E0 02 57 00 40 10 4C 00 BF 8F 00 00 E3 8E B0 01 42 8E 63 00 40 10 04 00 43 AE 30 00 02 8E B0 01 56 8C 04 00 54 8C 00 00 C2 8E 04 00 C3 8E 80 10 02 00 1B 00 82 02 F4 01 40 00 10 20 00 00 80 10 04 00 21 10 62 00 00 00 52 8C 06 00 40 16 1C 00 D5 26 ?? ?? ?? 0? 14 00 E3 8E 28 00 52 8E 52 00 40 12 00 00 00 00 00 00 42 8E FB FF 82 16 00 00 00 00 04 00 43 8E 18 00 C2 8E F7 FF 62 14 00 00 00 00 08 00 43 8E 14 00 C2 8E F3 FF 62 14 00 00 00 00 0C 00 43 8E 10 00 C2 8E EF FF 62 14 10 00 44 26 21 28 A0 02 ?? ?? ?? 0? 10 00 06 24 EA FF 40 14 00 00 00 00 48 00 02 8E 20 00 45 8E 5C 00 40 14 24 00 46 8E 20 00 A2 8F 00 00 04 8E 21 38 00 00 10 00 B1 AF ?? ?? ?? 0? 14 00 A2 AF ?? ?? ?? 0? 01 00 02 24 00 00 46 8E 00 00 04 8E 2C 00 05 8E 20 00 A2 27 10 00 B1 AF ?? ?? ?? 0? 14 00 A2 AF 20 00 A3 8F 0C 00 03 AE FF FF 03 24 B0 FF 43 14 10 00 42 28 00 00 83 8E 04 00 02 24 70 FF 62 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 21 10 00 00 4C 00 BF 8F 48 00 B7 8F 44 00 B6 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 50 00 BD 27 4C 00 BF 8F 48 00 B7 8F 44 00 B6 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 21 10 00 00 08 00 E0 03 50 00 BD 27 18 00 C6 2C 8B FF C0 14 00 00 00 00 ?? ?? ?? 0? 0C 00 60 AC ?? ?? ?? 0? 01 00 02 24 14 00 E3 8E 01 00 02 24 18 00 C3 AE 10 00 E3 8E 14 00 C3 AE 0C 00 E3 8E 10 00 C3 AE 03 00 26 8A 07 00 25 8A 0B 00 24 8A 0F 00 23 8A 00 00 26 9A 04 00 25 9A 0C 00 23 9A 08 00 24 9A 03 00 A6 AA 00 00 A6 BA 07 00 A5 AA 04 00 A5 BA 0B 00 A4 AA 08 00 A4 BA 0F 00 A3 AA 0C 00 A3 BA 4C 00 BF 8F 48 00 B7 8F 44 00 B6 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 50 00 BD 27 00 00 04 8E 34 00 05 AE 38 00 06 AE 21 28 60 02 ?? ?? ?? 0? 21 30 00 00 ?? ?? ?? 0? 01 00 02 24 }
	condition:
		$1
}

rule file_360_5_0 {
	meta:
		name = "svcudp_reply"
		size = 780
		refs = "0054 xdr_replymsg 00b8 __sendmsg 02e0 _libc_intl_domainname 015c $LC3 016c __dcgettext 0174 $LC1 0180 __fxprintf 01cc __sendto 0204 xdrmem_create 02b4 malloc 02d8 free 02e4 $LC2 02fc $LC0"
	strings:
		$1 = { C0 FF BD 27 24 00 B0 AF 30 00 90 8C 2C 00 B2 AF 3C 00 BF AF 0C 00 02 8E 08 00 12 26 30 00 B3 AF 14 00 59 8C 28 00 B1 AF 21 98 A0 00 38 00 B5 AF 34 00 B4 AF 21 28 00 00 21 88 80 00 08 00 00 AE 09 F8 20 03 21 20 40 02 04 00 02 8E 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 00 00 62 AE 0A 00 40 14 21 10 00 00 3C 00 BF 8F 38 00 B5 8F 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 40 00 BD 27 0C 00 02 8E 10 00 59 8C 09 F8 20 03 21 20 40 02 48 00 23 8E 44 00 60 10 21 90 40 00 2C 00 22 8E 00 00 24 8E 38 00 32 AE 34 00 22 AE 3C 00 25 26 ?? ?? ?? 0? 21 30 00 00 E8 FF 52 14 21 10 00 00 B0 01 02 8E 2F 00 40 10 3C 00 BF 8F 2E 00 40 06 38 00 B5 8F 30 00 34 8E B0 01 93 8E 0C 00 62 8E 08 00 63 8E 80 10 02 00 21 10 62 00 00 00 50 8C 6E 00 00 12 00 00 00 00 00 00 62 8E 00 00 03 8E 04 00 64 8E 80 10 02 00 1B 00 62 00 F4 01 40 00 10 28 00 00 80 10 05 00 21 10 82 00 00 00 44 8C 0B 00 80 10 00 00 00 00 06 00 04 16 00 00 00 00 ?? ?? ?? 0? 28 00 03 8E 26 00 03 12 28 00 82 24 21 20 60 00 28 00 83 8C FB FF 60 14 00 00 00 00 ?? 