#/*##########################################################################
# Copyright (C) 2019 European Synchrotron Radiation Facility
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
#############################################################################*/
__author__ = "V.A. Sole - ESRF Data Analysis"
__contact__ = "sole@esrf.fr"
__license__ = "MIT"
__copyright__ = "European Synchrotron Radiation Facility, Grenoble, France"


folder = [
"30 30 24 1 ",
"  c #626365",
". c #9A7B59",
"X c #ED9124",
"o c #F7992D",
"O c #B68D5D",
"+ c #F6A851",
"@ c #D29E64",
"# c #F4B56E",
"$ c #7E7E81",
"% c #7F8083",
"& c #908F91",
"* c #AEA397",
"= c #B2B2B3",
"- c #F2BD82",
"; c #CAB7A3",
": c #F5C794",
"> c #D1C4B5",
", c #F1D3B0",
"< c #BCBDC1",
"1 c #BFC0C3",
"2 c #D2D2D3",
"3 c #F4E2CD",
"4 c #DEDFE3",
"5 c None",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555454555555555555",
"555555555545555454454555555555",
"555555544544442==&%*4555555555",
"555554442221=*&&$$  4445555335",
"55442221222==&&%    *>:-+oXX+5",
"5224444422==&&%OOO.XXXoooXXX:5",
"424444442<=**@@#+++++oXXooXX35",
"52444442==;-:###++ooooooXoo#55",
"44244421==-:###+++++oooXXXo:55",
"5424421<=*:::###++ooooooXoo355",
"441422<=*;:::##+++o+ooooXo#555",
"54222<==&:::-##++++oooXoXo:555",
"44212==&*,::###+++ooooooXo4555",
"554==**&;,:::##++++++oooX#5555",
"5442==&&,,::-###+++oooooX,4455",
"5442&&&*,,::-##++++ooooo+45555",
"5543=%%>,,::-###+o+ooooo#44555",
"5542<$&3,,::-##+++++ooXO445555",
"55542&;33,:,-###+OOO@=12445555",
"55544&23,,:@OOO;==111222445555",
"55554>>;;;==11<1>2222444355555",
"555544422222>22224224445555555",
"555545443424244444445455555555",
"555555554444454455555555555555",
"555555555554555555555555555555",
"555555555555555555555555555555"
]

draw_pencil = [
"30 30 22 1 ",
"  c #404040",
". c #01A652",
"X c #22AA5A",
"o c #1AAD62",
"O c #32B672",
"+ c #53B66D",
"@ c #F7941E",
"# c #F39828",
"$ c #D8A23E",
"% c #A9B363",
"& c #D0B15D",
"* c #F5C07B",
"= c #50BC84",
"- c #5DC690",
"; c #6DCA97",
": c #9B9B9B",
"> c #9CD5AB",
", c #D9CB95",
"< c #ACE2C6",
"1 c #D4D6D5",
"2 c #D3EEDE",
"3 c None",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"3333333333333333333332-XO23333",
"333333333333333333332-O..o3333",
"3333333333333333333,*%....<333",
"333333333333333333,*#@%...<333",
"33333333333333333&*#@@#+.O3333",
"3333333333333333>*@@@@@#;33333",
"333333333333333;-%@@@@@%333333",
"33333333333332;=..&@@@&3333333",
"3333333333332;O...o$@,33333333",
"333333333332;o.....+,333333333",
"3333333333<-......o23333333333",
"333333333>=......=233333333333",
"33333333;o......=3333333333333",
"3333333=.......;33333333333333",
"3333331+......<333333333333333",
"33333322O....<3333333333333333",
"333331331o.o233333333333333333",
"33333:3331O2333333333333333333",
"3333  111133333333333333333333",
"3332 :133333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333"
]

image_select_box = [
"30 30 24 1 ",
"  c #25572D",
". c #6A6F2E",
"X c #4A4B42",
"o c #A6241F",
"O c #CF3F24",
"+ c #9E6025",
"@ c #728C38",
"# c #29994D",
"$ c #629066",
"% c #A19C33",
"& c #CB9B2A",
"* c #8D7C93",
"= c #7E8280",
"- c #7DAE96",
"; c #868888",
": c #8EAB9D",
"> c #8CB0AA",
", c #AAAFAD",
"< c #9BCFA2",
"1 c #93CEAE",
"2 c #B8D5C3",
"3 c #CED3CC",
"4 c #DBE6D0",
"5 c None",
"555554554555455454554554554555",
"55,====*===;;,;;=====*==*=**55",
"55,=*=**=*=><2<=*======*===;55",
"55,=**333344444433333333,=*:55",
"55,==,5,2242444333444325,==;55",
"55,==,3  #@@@@..X+&+.@#5*==,55",
"55,;=;5   @@..+ooo+o+%@5;==;55",
"55,;=,5   ....oXooooO+%5,==;55",
"55,==:5   ....ooooooOO%5>>*;55",
"55,*=,5   ..++oooooOOO%5>->:55",
"55,==,5  .@+++ooooooo+&5,>1>55",
"55,=*,5 @@@%+oooooOOO&%5,-1,55",
"55,;;25X%@.%++oooooOO%%5>-1>55",
"55,;;,5   %.++ooOoOO+&%5,11:55",
"55,=;<5  ..+++oOOoOO+%@5,:1:55",
"55,==,5  +@+++OoOO++%&#5,:1,55",
"55,;=,5.@@%+&+&O+O&%%@#4,:1:55",
"55,;;<5$@@&.&+O&+&&&@##5<:,;55",
"55,;:<5#@%&+%&++&%&%@##4,:*;55",
"55,;:2532443344444222425,,;,55",
"55>>-1432333333333334242;**;55",
"55,>>--$$$$$$$$$$$$$$$$$***:55",
"55,*>>-=----:-<--1-<>-1>,=;;55",
"55>->>1>1-<:<<<<1<11<>,,*=;:55",
"55,==*:1>>1>11<<-<1-,,**===;55",
"55,;==*:>11111><1:>,;***===,55",
"55,=====*->1:1;>:;;========;55",
"55,===*==**-;;;**;=========,55",
"55,*=;====*===;*==*====**=;,55",
"55,::;,;;-*>;:3,,;:;:;,;;;;,55"
]

math_sigma = [
"30 30 15 1 ",
"  c #565656",
". c #747474",
"X c #F7941E",
"o c #F79928",
"O c #F8A139",
"+ c #FAB86A",
"@ c #FAC07C",
"# c gray51",
"$ c #B2B2B2",
"% c #FBC88C",
"& c #FCDEBA",
"* c #D3D3D3",
"= c #EBDBC9",
"- c #FDE9D1",
"; c None",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;-++++++++++++-;;;;;;;;;;;",
";;;;;&XXXXXXXXXXoX=**$##.;;;;;",
";;;;;&oXXXoooooooo-;;;;* ;;;;;",
";;;;;;%XXX-;;;;;;;;;;;;; ;;;;;",
";;;;;;;%XXo-;;;;;;;;;;;; ;;;;;",
";;;;;;;;%XXo-;;;;;;;;;;* ;;;;;",
";;;;;;;;;@XXO-;;;;;;;;;; ;;;;;",
";;;;;;;;;;@oXO-;;;;;;;;; ;;;;;",
";;;;;;;;;;;+XXO;;;;;;;;; ;;;;;",
";;;;;;;;;;;+XX%;;;;;;;;- ;;;;;",
";;;;;;;;;;&XXO;;;;;;;;;; ;;;;;",
";;;;;;;;;;oXX-;;;;;;;;;; ;;;;;",
";;;;;;;;;+XX%;;;;;;;;;;- ;;;;;",
";;;;;;;;&XXO;;;;;;;;;;;; ;;;;;",
";;;;;;;;OXo-;;;;;;;;;;;* ;;;;;",
";;;;;;;+XX%;;;;;;;;;;;;; ;;;;;",
";;;;;;&XXO;;;;;;;;;;;;;- ;;;;;",
";;;;;-oXX%&&&&&&&&;;;;;; ;;;;;",
";;;;;-XXXXXXXXXXXX&;**$$ ;;;;;",
";;;;;-XXXXXXXXXXXX&*=**$$;;;;;",
";;;;;;&&&&&&&&&-&&;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
]

compare_mode_hline = [
"30 30 19 1 ",
"  c #040302",
". c #201E0C",
"X c #27271C",
"o c #493F24",
"O c #606525",
"+ c #865D2B",
"@ c #9A6B31",
"# c #738730",
"$ c #A3A03D",
"% c #DA9745",
"& c #F8AC4F",
"* c #B9D94D",
"= c #D4F958",
"- c #0504AA",
"; c #2C28B8",
": c #4531BE",
"> c #523BC3",
", c #4854C6",
"< c None",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<. .        .  .          .<<",
"<< o++++++@+++++++++++@+++o <<",
"<<.+&&&&&&&&%%@%%%%&&&&&&&+ <<",
"<< +&&&&&&&&.    .&&&&&&&&+ <<",
"<< +&&&&&&&@      %&&&&&&&+.<<",
"<< +&&&&&&&o      o&&&&&&&+ <<",
"<< +&&&&&&%        %&&&&&&+ <<",
"<< +&&&&&&@   .X   @&&&&&&+ <<",
"<<.+&&&&&&o   @+   X&&&&&&+ <<",
"<< +&&&&&%    %%    %&&&&&O <<",
"<< +&&&&&O   X&&X   +&&&&&+ <<",
"<< +&&&&&.   @&&@   X&&&&&+.<<",
"<<-;>>>::----:>::----:>>>>;-<<",
"<<-;,,,,-----------;,,,,,,;-<<",
"<<X#===*            o=====#X<<",
"<<X#===*    #$$$O    #====#X<<",
"<<X#===*    #====O   .====#X<<",
"<<X#===*    $====#    *===#X<<",
"<<X#===*    $*===O    ====#X<<",
"<<X#====    #**$O    .====#X<<",
"<<X#===*             #====#X<<",
"<<X#===*            #=====#.<<",
"<<XO===*XXXX.XXXXO#*======#X<<",
"<<X#======================#X<<",
"<<Xo######################oX<<",
"<<oXXXXXXXXXXXXXXXXXXXXXXXXo<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<"
]

median_filter = [
"30 30 16 1 ",
"  c #060606",
". c #181818",
"X c #2A2A2A",
"o c #464646",
"O c #5B5B5B",
"+ c #717171",
"@ c #888888",
"# c #9B9B9B",
"$ c #A8A8A8",
"% c #B7B7B7",
"& c #C6C6C6",
"* c #D7D7D7",
"= c #E9E9E9",
"- c #F3F3F3",
"; c #F9F9F9",
": c None",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
":::::::::::::::-;;-:::::::::::",
"-.O:&X+::::::::X#$X:::::::::::",
"=  *O O:$+@:;+@X@&@:@O+;=+$+*:",
"- +o.O+& $X@@.% @$.:%#X+& @X+:",
"= &.+OO# oo+OO:X@$X=.OXO& =+O:",
"= &&=OO* ++#$ + @$X* +.O& ;+O:",
";%-::**:=$%=:%&&*=&:&%**-%:&*:",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
":::::=&:&=::::::::::::::::::::",
"=   +&O:.%$O::::::::::::::::::",
"= $=:%O:.$X o=+XO;%OO$::::::::",
"-  .$$.:.$@X*% $X+# %=::::::::",
"= %::$.:.%#X:# ++$#X::::::::::",
"= &::$.:.$% X=Xoo@#X::::::::::",
":*;::-=:*;:-=:;**:-=::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::"
]

arrow_keys = [
"30 30 15 1 ",
"  c #040404",
". c #2F2F2F",
"X c #4D4D4D",
"o c #6A6A6A",
"O c #F89B2E",
"+ c #F9AC51",
"@ c #FAB768",
"# c #FAC27E",
"$ c #8D8D8D",
"% c #ADADAD",
"& c #FBCB92",
"* c #FCD8AD",
"= c #CFCFCF",
"- c #FDE5C8",
"; c None",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;@OOOOOOOO@;;;;;;;;;;",
";;;;;;;;;;@-;;;;;;-@;;;;;;;;;;",
";;;;;;;;;;@-;;.o;;-@;;;;;;;;;;",
";;;;;;;;;;@-;X  o;-@;;;;;;;;;;",
";;;;;;;;;;@-o.  .$-@;;;;;;;;;;",
";;;;;;;;;;@-;;  ;;-@;;;;;;;;;;",
";;;;;;;;;;@-;-  ;;-@;;;;;;;;;;",
";;;;;;;;;;@-;=XX;;-@;;;;;;;;;;",
";;;;;;;;;;@&&&&*&&#@;;;;;;;;;;",
";;;;;;;;;;*&&&&*&&&*;;;;;;;;;;",
"&&&&&&&&&-**&&&&&&*--&&&&&&&&&",
"O&&&&&&&+*@@&&&&&*@@*+&&&&&&&O",
"O;;;%;;;#*@-;;XX;;-@*&;;;%;;;O",
"O;;$X;;;#*@*;;  =;-@*#;;;.X;;O",
"O;$  .X$#*@-;;  -;-@*#o..  o;O",
"O-.    X#*@-$.  .o-+&#X    .;O",
"O;= .%%=#*@-;o  .;-@*&===..=;O",
"O;;=X;;;#*@-;;o.;;-@*#;;;o=;;O",
"O;;;;;;;#*@-;;;;;;-@*#;;;;;;;O",
"OOOOOOOOO*@OOOOOOOO@*OOOOOOOOO",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
]

item_0dim = [
"30 30 19 1 ",
"  c #0034FF",
". c #1E4CFF",
"X c #1F4DFF",
"o c #204DFF",
"O c #214EFF",
"+ c #5F80FF",
"@ c #6080FF",
"# c #6181FF",
"$ c #97ACFF",
"% c #98ADFF",
"& c #99AEFF",
"* c #9AAFFF",
"= c #D3DCFF",
"- c #D4DDFF",
"; c #D5DEFF",
": c #F4F6FF",
"> c #F5F7FF",
", c #F6F8FF",
"< c None",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<:%++%><<<<<<<<<<<<",
"<<<<<<<<<<<=.    o-<<<<<<<<<<<",
"<<<<<<<<<<:.      X><<<<<<<<<<",
"<<<<<<<<<<$        &<<<<<<<<<<",
"<<<<<<<<<<@        #<<<<<<<<<<",
"<<<<<<<<<<@        #<<<<<<<<<<",
"<<<<<<<<<<%        *<<<<<<<<<<",
"<<<<<<<<<<>o      O,<<<<<<<<<<",
"<<<<<<<<<<<-X    O;<<<<<<<<<<<",
"<<<<<<<<<<<<>&@@*,<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<"
]

add_shape_unknown = [
"30 30 22 1 ",
"  c #5BA03E",
". c #09A957",
"X c #1CB064",
"o c #2AB56E",
"O c #F7941E",
"+ c #F79A2A",
"@ c #EB9E34",
"# c #F9AD52",
"$ c #FAB869",
"% c #FAC27F",
"& c #45BE80",
"* c #60C892",
"= c #8FD8B3",
"- c #A1DFBF",
"; c #FBC98E",
": c #FCDBB2",
"> c #F4DFBD",
", c #B8E6CE",
"< c #CEEEDD",
"1 c #FEEAD3",
"2 c #D8F1E5",
"3 c None",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"3333333333331::133333333333333",
"3333333331$OOOOO+#:33333333333",
"33333333;OOOOOOOOOO#1333333333",
"3333333#OOO%:311;+OO+333333333",
"333333$OO#33333333;OO#33333333",
"33333;OO$333,*&=333$OO#3333333",
"33331+O#333&....o333$OO#333333",
"3333%O+1333oX==..,333$OO@13333",
"3333+O$3333,332.X,3333;O+@1333",
"3331OO13333333X.X333333;OO+133",
"333:OO1333333&..23331::1$O++13",
"333:OO3333333..<331#OOOOOOOO;3",
"333:OO1333332..331@OOOOOOO#;33",
"3331OO:333333*-33+OO;31>133333",
"3333+O;3333332<33OO:3333333333",
"3333#O#333332X.31OO:333,<33333",
"3333;O+133332..23@O#33,.X33333",
"33333OO$33333==33;OO:3,.X33333",
"33333%OO;333333333@O+3,.X33333",
"333333@OO:33333333: ........23",
"3333331+OO%333333:# .....X..23",
"33333331@OO+%::;+OO@@,=.X<<<33",
"333333333#O+OOOOOO+%13,.X33333",
"3333333333>$OOOO$>3333,.X33333",
"33333333333333133333332*=33333",
"333333333333333333333333333333",
"333333333333333333333333333333"
]

math_phase_color = [
"30 30 24 1 ",
"  c #040302",
". c #28231E",
"X c #583D20",
"o c #616161",
"O c #EA1B1D",
"+ c #E35422",
"@ c #FB1E62",
"# c #7C981D",
"$ c #25FF1C",
"% c #5DFF2A",
"& c #25FF5E",
"* c #9EFB26",
"= c #CCC131",
"- c #EAE120",
"; c #552EFB",
": c #FF299F",
"> c #A029FD",
", c #F021EB",
"< c #B561F2",
"1 c #3FE9C9",
"2 c #A6A6A5",
"3 c #BBCEE9",
"4 c #D3D7DC",
"5 c None",
"555555555555555555554225555555",
"55555555555555555555X  2555555",
"55555555555555555554   o555555",
"5555555555542****-4o o. 455555",
"5555555552%$%%***--. 4o 255555",
"55555554$$$$%%%***# .-2  55555",
"5555554&$$$%%%***-X #--. 25555",
"555554&&&$$$$%%**-  ---# o5555",
"555541&&&&&$%%***# X---+  5555",
"55551&1&&&&%$%**-. =-=+-. 2555",
"55551&&1&&&&&%%**  -+=++X .555",
"5555111111&&&&**X  .. .    455",
"5554o44oXo41&&%*  ....  .  o55",
"55o  4o    23&%#  +++++OOO .55",
"52  25 .5o  411X X++O+OOOO  25",
"5X o13 .33o o1;  @O@OOOOOOX X5",
"4  413 .312 .3o .::@@@+@OO@  5",
"4  313 .313  3;>,:::@@@@@@:445",
"2 .513 .1;3  3>>,,,::@@@@@4555",
"4  513 .3;3  3>>,,,:::::@:5555",
"5  4<3 .3;2 .3>>,,,,,:::::5555",
"5. 233 .33. o<>><,,,:,:::55555",
"52  24 .4o  3;>>>,,,,,,:555555",
"55o        4;;>>>,,,,,,4555555",
"5552o.  .o3;;;>>>>,,,,55555555",
"555554 .53;;;;>>>,>,<555555555",
"555554 .5553<<>>,<455555555555",
"555554 .5555555555555555555555",
"555554 .5555555555555555555555",
"555555245555555555555555555555"
]

clipboard = [
"30 30 17 1 ",
"  c #4F4E50",
". c #6E6E70",
"X c #F7941E",
"o c #F89A2B",
"O c #F8A038",
"+ c #F8A848",
"@ c #FAB86A",
"# c #FAC17C",
"$ c #7E7F80",
"% c #919192",
"& c #AEAEAF",
"* c #FBCA8E",
"= c #FCD6A8",
"- c #C0BFC0",
"; c #CECECF",
": c #FEEDD9",
"> c None",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>#@>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>Xo>>>>>>>>>>>>>>",
">>>>>>>>>>>>>:XX:>>>>>>>>>>>>>",
">>>>>>>>>>>>>@*=@>>>>>>>>>>>>>",
">>>>>>>>>>>>:+>>@=>>>>>>>>>>>>",
">>>>>>>::::>Oo:>+o>::::>>>>>>>",
">>>>>>#XoX@*XXXoXX*@XXX@>>>>>>",
">>>>>>oo+@:XXXXXXXX:@+oX>>>>>>",
">>>>>>XO>>>========:>>+X>>>>>>",
">>>>>>XO>>>>>>>>>>>>>>+X>>>>>>",
">>>>>>XO>>>>>>>>>>>>>>+X:>>>>>",
">>>>>>XO>>;;;;:;;-&;>>+X>>>>>>",
">>>>>>XO>>$.    ..%;>>+X>>>>>>",
">>>>>>XO>>>>>>>>>>>>>>OX>>>>>>",
">>>>>>XO>>>;;;----&>>>+X:>>>>>",
">>>>>>XO>>.       .>>>+X>>>>>>",
">>>>>>XO>>;:>>>>>>>>>>+X>>>>>>",
">>>>>>XO>>>;&:>>>>>>>>+X>>>>>>",
">>>>>>XO>>%%%>>>>>>>>>+X:>>>>>",
">>>>>>XO>>>>>>>>>>>>>>+X>>>>>>",
">>>>>>XO>>;........&>>+X>>>>>>",
">>>>>>XO>>%%&%&&&%%;>>+X>>>>>>",
">>>>>>XO>>>>>>>>>>>>>>+X>>>>>>",
">>>>>>XO>>>>>>>>>>>>>>+X>>>>>>",
">>>>>>XO>>>>>>>>>>>>>>+X>>>>>>",
">>>>>>oXooooooooooooooXX:>>>>>",
">>>>>>=OooooooooooooooO#>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
]

plot_window = [
"30 30 15 1 ",
"  c #181818",
". c #2B2B2B",
"X c #525252",
"o c #6A6B6B",
"O c #7EAC93",
"+ c #939695",
"@ c #96ABA0",
"# c #B3B3B4",
"$ c #9BD8B7",
"% c #BED1C7",
"& c #ADE1C5",
"* c #CFD0CF",
"= c #D1EEDF",
"- c #DFE5E3",
"; c None",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";##*******#*******#*********#-",
"-**-*#;****;**-%;;;;;;;;;;;;--",
"--*;-*;*--*;*--*;;;;;;;;;;;;--",
"-#*#*#*##**#*#*#*#*#**#****##-",
";------%**=%%&*&=%%&*&&-------",
";-;-;;&&==============&%;----;",
"---;--%=;;;;;##;;;;;;;=%---;-;",
";---;-&=;;;;;  ;;;;;;;==------",
";-;-;-*@;;;;*X++;;;;;;-%--;--;",
"------%=;;;;X@*X;;;;;;=%------",
"-;;-;-==;;;o.;;.;;;;;;-*-----;",
";-----%@;;oo-;;X#**;;;-*-;----",
"---;--*-;;o%;;;@o..;;;==--;-;-",
"-;----*-;;.*;;;- ..;;;=%-----;",
";---;-%+;.o;;;;;+#X*;;=%-;---;",
";-----%=@o;;;;;;;;++;;=&--;--;",
";;-;--%-o*;;;;;;;;* .;==------",
"-----;%oX;;;;;;;;;;oo+=%;-;-;;",
";----;&=;;;;;;;;;;;;;*=%---;-;",
";-;---%=;;;;;;;;;;;;;;=&;-----",
"--;-;-*$$$O$&@$$O$$@&$$%---;-;",
";*---------------------------;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
]

plot_roi_reset = [
"30 30 24 1 ",
"  c #252526",
". c #175832",
"X c #43513F",
"o c #564F50",
"O c #644E50",
"+ c #6B6B6D",
"@ c #AE2B2F",
"# c #EC1C24",
"$ c #CF282E",
"% c #E22A31",
"& c #A54238",
"* c #A1605F",
"= c #D3575C",
"- c #189C56",
"; c #619478",
": c #7E7E80",
"> c #68B68D",
", c #6CC999",
"< c #8D8E90",
"1 c #A4989A",
"2 c #A9A9AB",
"3 c #B5C7B5",
"4 c #D2CFCF",
"5 c None",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555<55555555555555",
"55555555555555+ +5555555555555",
"55555555,45555 1 4555,35555555",
"55555555-,5552+2o<555-,5555555",
"555555==-,555O>2:X555-<3=55555",
"555544=%&,555 222 555-*%#45555",
"5555541$#=452o222o254o#%*45555",
"5555542*@#=1 <222++41##*245555",
"55555541.$#@>12222 =##o1455555",
"55555554.X$#$<222<@#%.X4555555",
"55555554-X $#=1<1&#$*..2555555",
"55555555-.oo$#&<@#$ 2--+555555",
"55555555-.O+O$#$#$O 2-> 555555",
"55555555-.>:Oo###o+  -, 555555",
"5555555+--1<+@###@:<o-> 555555",
"5555552X->1<$#$ $#@12-,o455555",
"555555+2-><$#$ooo$#$2-,:<55555",
"555555X5-;$#@o++Oo$#*-,2X<:555",
"555554X5-$#@+:<<:+O$#&>5   455",
"55555o14@#@o+<121:+o$#&5<+2<55",
"55552<4%#@+:<22221:+o$#=455o45",
"555554##=<34555555441+%#=55555",
"555553$@<2455555555541<%%45555",
"555553114455555555554421245555",
"555554444555555555555542445555",
"555555555555555555555555555555",
"555555555555555555555555555555"
]

selected = [
"30 30 24 1 ",
"  c #131313",
". c #2E2E2E",
"X c #076B38",
"o c #1E7E4D",
"O c #2B704D",
"+ c #4D4E4D",
"@ c #51695D",
"# c #707170",
"$ c #139753",
"% c #2B8C5A",
"& c #03A552",
"* c #2AAC69",
"= c #478867",
"- c #5D9D7C",
"; c #6EA187",
": c #7BC29E",
"> c #999A99",
", c #8FB3A1",
"< c #B3B4B3",
"1 c #9ECAB3",
"2 c #B0D2C1",
"3 c #D1D2D2",
"4 c #CFE4D9",
"5 c None",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555445555",
"555555555555555555555551&,3555",
"55555555555555555555551&&;<555",
"555554>>>>>>>>>>>>>>>;$&&%<555",
"55555<.############@+%&&&O<455",
"55555<@5555555555555-&&&X@<555",
"55555<+5555555555551&&$O.#3555",
"55555<+555555555553&&&O#.>4555",
"55555<@55555555554-&&o@>.<5555",
"55555<+*:345555552&&$@>3+35555",
"55555<+&&*<455555*&&@><4.<5555",
"55555<+&&&$<3555,&&O#<45+35555",
"55555,+&&&&$<444$&o#>355.35555",
"55555<+$&&&&-34<&&@>3555+35555",
"55555<+<@$&&&><-&%#<5555.35555",
"55555<+3<#$&&$>$$->35555+35555",
"55555<+533>o&&=&=><55555+<5555",
"55555<+554<>&&&&#<455555+35555",
"55555<@55543-&&%>3455555.35555",
"55555<+55554<%&@>3555555+35555",
"55555<@555553>$;<3555555+<5555",
"55555<+5555553;<35555555+35555",
"55555< ................. 35555",
"555555444533433333534453355555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555"
]

item_object = [
"30 30 13 1 ",
"  c #0034FF",
". c #1646FF",
"X c #325CFF",
"o c #3961FF",
"O c #5D7EFF",
"+ c #5F80FF",
"@ c #7490FF",
"# c #99AEFF",
"$ c #A7B9FF",
"% c #B8C6FF",
"& c #CDD7FF",
"* c #DCE3FF",
"= c None",
"==============================",
"==============================",
"==============================",
"==============================",
"=============$@@@*============",
"=============o   %============",
"========#O===.   #==*$========",
"=======#  X*&    @=&. #=======",
"======$    .      X    #======",
"=======.               O======",
"=======%              X=======",
"========X            .*=======",
"====*&$@     X##X     &=======",
"====@       X====X      o$====",
"====@       #====#       @====",
"====@       #====#       @====",
"====$X      o====X       @====",
"=======&     X##X     @#&*====",
"=======*.            o========",
"=======o              $=======",
"======+                =======",
"======#    o      .    $======",
"=======# .%=@    &*X  #=======",
"========$*==#    ===O#========",
"============%   O=============",
"============*@@@#=============",
"==============================",
"==============================",
"==============================",
"=============================="
]

item_2dim = [
"30 30 4 1 ",
"  c #0034FF",
". c #2854FF",
"X c #4B70FF",
"o c None",
"oooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooo",
"ooooooX................Xoooooo",
"oooooo.                .oooooo",
"oooooo.                .oooooo",
"oooooo.                .oooooo",
"oooooo.                .oooooo",
"oooooo.                .oooooo",
"oooooo.                .oooooo",
"oooooo.                .oooooo",
"oooooo.                .oooooo",
"oooooo.                .oooooo",
"oooooo.                .oooooo",
"oooooo.                .oooooo",
"oooooo.                .oooooo",
"oooooo.                .oooooo",
"oooooo.                .oooooo",
"oooooo.                .oooooo",
"oooooo.                .oooooo",
"ooooooX................Xoooooo",
"oooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooo"
]

crosshair = [
"30 30 20 1 ",
"  c #010101",
". c #333333",
"X c #5B5B5B",
"o c #CA7A1A",
"O c #9E7C54",
"+ c #F5931E",
"@ c #E3902D",
"# c #F69726",
"$ c #AE8657",
"% c #80807F",
"& c #C8955A",
"* c #F7A747",
"= c #949494",
"- c #B2B2B2",
"; c #CEB596",
": c #FBCF9A",
"> c #DDC8AF",
", c #FBD7AD",
"< c #D2D2D2",
"1 c None",
"11111##*1111111111111111111111",
"11111+#*1111111111111111111111",
"11111++*1111111111111111111111",
",::::++@::::::::::::::::::::::",
"*+++++*@++++++++++++++++++++++",
"#++++@&,o+++++++++++++++++++++",
",,,,:o$<<;>:,,,,,,,,,,,,,,,,,,",
"11111oOXX<<1111111111111111111",
"11111o$% X<<111111111111111111",
"11111oO%  X<<<1111111111111111",
"11111o$%   X<<1111111111111111",
"11111o$X    X<<<11111111111111",
"11111oO=     X<<11111111111111",
"11111oOX      .<<1111111111111",
"11111o$=       .<<111111111111",
"11111oOX    .XXX=<<11111111111",
"11111oOX  X .<---<111111111111",
"11111oO= =1. -=-<<<11111111111",
"11111o$%=-== .<<11111111111111",
"11111@$<-==<  <<<1111111111111",
"11111o$;<<-=X .<<1111111111111",
"11111@@@1<<=1  -<1111111111111",
"11111++@111--X X<<111111111111",
"11111#+*111<=<-<<1111111111111",
"11111++*1111-<--<1111111111111",
"11111#+*11111<<111111111111111",
"11111++*1111111111111111111111",
"11111#+*1111111111111111111111",
"11111+#*1111111111111111111111",
"11111##*1111111111111111111111"
]

cube_top = [
"30 30 15 1 ",
"  c #13120F",
". c #21180C",
"X c #2F271D",
"o c #3B3938",
"O c #4B4B4B",
"+ c #6E6E6E",
"@ c #BB741F",
"# c #B37A36",
"$ c #D88C31",
"% c #F09F3E",
"& c #F9A847",
"* c #959595",
"= c #ACACAC",
"- c #CBCBCB",
"; c None",
";;;;;;;;;;;;;-;;;;-;;-;-;;-;-;",
";;;;;;;;;;-.     ...... ..   ;",
";;;;;;;;;-X@%&%&&&&&&&&&&%@o ;",
";;;;;;;;-X%$%&&&&&&&&&&&&#X;X-",
";;;;;;;-X$%@%&&&&&&&&&&&#o;; ;",
";;;;;;-X$&&$%&&&&&&&&&&#X;;; ;",
";;;;;-X$&&&$%&&&&&&&&&#X;;;; ;",
";;;;-X%&&&%$%&&&&&&&&#X;;;;;X;",
";;;-X$&&&&&$%&&&&&&&#X;;;;;; ;",
";;-X$&&&&&%$%%&&&&&#X;;;;;;; ;",
";-.$&&&&&&&@%%&&%&#X;;;;;;;; ;",
"-                 X;;;;;;;;; ;",
"; ---------o*----=O;;;;;;;;; ;",
"; ;;;;;;;;;o-;;;;-o;;;;;;;;; ;",
"; ;;;;;;;;;O-;;;;-O;;;;;;;;; ;",
";X;;;;;;;;;O-;;;;-o;;;;;;;;; ;",
"; ;;;;;;;;;O-;;;;-o;;;;;;;;;X;",
"; ;;;;;;;;;o*----*X--==----= ;",
";X;;;;;;;;;X                 -",
"-X;;;;;;;;o=;;;;;-o;;;;;;;-X-;",
"; ;;;;;;;o=;;;;;;-O;;;;;;;X-;;",
";X;;;;;;O=;;;;;;;-o;;;;;;o-;;;",
"; ;;;;;O=;;;;;;;;-o;;;;;O=;;;;",
"; ;;;;O*;;;;;;;;;-o;;;;o=;;;;;",
";X;;;O*;;;;;;;;;;-O;;;o=;;;;;;",
"-X;;O*;;;;;;;;;;;-O;;O=;;;;;;;",
";X;++;;;;;;;;;;;;-o;O=;;;;;;;;",
"; ++;;;;;;;;;;;;;-oO*;;;;;;;;;",
"-                  *;;;;;;;;;;",
";;-;;-;;-;;;;--;-;;;;;;;;;;;;;"
]

shape_diagonal = [
"30 30 8 1 ",
"  c #F7941E",
". c #F79827",
"X c #F9B15A",
"o c #F9B360",
"O c #FBCA90",
"+ c #FCD6A9",
"@ c #FDE3C5",
"# c None",
"##############################",
"##############################",
"##############################",
"##############################",
"##############################",
"##############################",
"##############################",
"########+@####################",
"#######+ .@###################",
"#######X  .@##################",
"########o  .@#################",
"#########o  .@################",
"##########X  .@###############",
"###########X  .@##############",
"############o  .@#############",
"#############o  .+############",
"##############X  .@###########",
"###############X  .@##########",
"################X   @#########",
"#################X  .@########",
"##################X  .@#######",
"###################X  .@######",
"####################X  .######",
"#####################X.O######",
"######################O#######",
"##############################",
"##############################",
"##############################",
"##############################",
"##############################"
]

plot_symbols = [
"30 30 13 1 ",
"  c #02A752",
". c #1DB064",
"X c #37BA77",
"o c #58C58D",
"O c #67CA97",
"+ c #7CD1A6",
"@ c #8ED8B2",
"# c #A0DEBE",
"$ c #A3DFC0",
"% c #B0E3C9",
"& c #D0EFDF",
"* c #D9F2E5",
"= c None",
"==============================",
"==============================",
"==============================",
"==============================",
"==============================",
"==============================",
"==============================",
"==============================",
"======================*&======",
"======================o.======",
"=====================%  o=====",
"==========*+o+*=====*.   %====",
"=========#     #====o    .====",
"==#XXX===       ===#      o===",
"==O  .*=$       %=*.       %==",
"==O  .*=#       $==.       @==",
"==O.  *=&       &==&      X===",
"===*=*===o     o====@     *===",
"==========@. .@======.   @====",
"=====================&  X=====",
"======================@ *=====",
"=======================#======",
"==============================",
"==============================",
"==============================",
"==============================",
"==============================",
"==============================",
"==============================",
"=============================="
]

cube_back = [
"30 30 14 1 ",
"  c #120F0D",
". c #261A0B",
"X c #392711",
"o c #3A3835",
"O c #4B4B4B",
"+ c #6E6E6E",
"@ c #AE7631",
"# c #C98739",
"$ c #E79C42",
"% c #F9A847",
"& c #919191",
"* c gray68",
"= c #D2D2D2",
"- c None",
"------------=-=--=-=--=--=--=-",
"----------=                  -",
"---------=oo#%$%%%%%$%%%%%@. -",
"--------=o=o#%%%%%%%%%%%%@X$.=",
"-------=o=-o#%%%%%%%%%%%@X$%.-",
"------=o=--o#%%%%%%%%%%@X$%%.=",
"-----=o=---o#%%%%%%%%%@X$%%%.-",
"----=o=----o#%%%%%%%%@X$%%%%.-",
"---=o=-----o#%%%%%%%@X$%%%%%.=",
"--=o=------o#%%%%%%@X$%%%%%%.-",
"-=o=-------o#$%%%%@X$%%%%%%% -",
"=                 .$%%%%%%%% -",
"- =========X@####@X%%%%%%%%%.-",
"- ---------o#$%%%#X%%%%%%%%%.=",
"-.---------o#%%%%#X%%%%%%%%% -",
"-.---------o#%%%%#X%%%%%%%%% -",
"- ---------o#%%%%#X%%%%%%%%%.-",
"- ---------o@####@X######### -",
"- ---------o . .     .  .    =",
"=o-------=o*-----=o-------=o=-",
"-.-------o*------=o-------o=--",
"-.------o*-------=O------o*---",
"- -----O*--------=O-----O*----",
"- ----O&---------=o----o*-----",
"- ---O&----------=o---o*------",
"=o--O&-----------=O--O*-------",
"-o-+&------------=o-O*--------",
"= ++-------------=oO&---------",
"-                  &----------",
"-=---==-=----==-=-------------"
]

add_shape_arc = [
"30 30 21 1 ",
"  c #0BA752",
". c #1BB064",
"X c #5BAD5B",
"o c #B6992B",
"O c #F7941E",
"+ c #CF9827",
"@ c #F79827",
"# c #F8A23B",
"$ c #F9AB4F",
"% c #CCB463",
"& c #FAB96C",
"* c #FAC17D",
"= c #71CE9E",
"- c #9ED4A9",
"; c #FBC98E",
": c #FADAB2",
"> c #FDE0BD",
", c #B8E6CE",
"< c #FDE8D0",
"1 c #D4F0E2",
"2 c None",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"2222222222*@;22222222222222222",
"222222222<@OO$<222222222222222",
"222222222&OOOOO;22222222222222",
"22222222<OO;>#OO&2222222222222",
"22222222$O#222$OO$222222222222",
"2222222:OO:2222*OO$22222222222",
"2222222$O$222222;OO$2222222222",
"222222;@O<2222222;OO;222222222",
"222222@O&222222222&OO:22222222",
"22222;OO<2222222222$O@<2222222",
"2222<OO*22222222222<@O&2222222",
"2222&O@2222222222222;@O<222222",
"222<OO&22222222222222$O$222222",
"222;OOO&2222222222222>OO>22222",
"2222<$O@$2222222222222$O$22222",
"222222&@O$222222222222:o+<2222",
"2222222;OO;22222222222,  ;2222",
"22222222&OO<2222222222,  $2222",
"222222222@O$2222222222-  O<222",
"222222222:OO<22222<X        12",
"2222222222#O&22>*$OX     .  12",
"2222222222;@@$OOO@O+%%- .11,22",
"2222222222<OOOOO#&:222, .22222",
"22222222222#@&:<222222, .22222",
"22222222222222222222221=-22222",
"222222222222222222222222222222",
"222222222222222222222222222222"
]

math_substract = [
"30 30 13 1 ",
"  c #636363",
". c #F7941E",
"X c #F79929",
"o c #F8A139",
"O c #F9AA4D",
"+ c #FABC71",
"@ c #8E8E8E",
"# c #ADADAD",
"$ c #FBCA8F",
"% c #FCD7AC",
"& c #D3D3D3",
"* c #FDE5C9",
"= c None",
"==============================",
"==============================",
"==============================",
"===============&&=&=&&&&&&&===",
"=======*=*&&&&####@@@@@    ===",
"======*%****%&**=========& ===",
"=====............+=======& ===",
"=====.............O======& ===",
"=====..+%%%%*%%%O..*=====& ===",
"=====..+========*..$=====& ===",
"=====..+=========..$=====& ===",
"=====..+========$..%=====& ===",
"=====..XOOOOOOOo...======& ===",
"=====.............o*=====& ===",
"=====..XOOOOOOOO...O=====& ===",
"=====..+=========+..*====& ===",
"=====..+=========*..$====& ===",
"=====..+==========X.+====& ===",
"=====..+==========X.+====& ===",
"=====.X+=========*..$====& ===",
"=====..+=========+..*====& ===",
"=====.XO%******%O..O=====& ===",
"=====.............o======& ===",
"=====..........X.+*======& ===",
"=====*%$%%$%%%$%*========& ===",
"========&=&&&&&######@@@   ===",
"============&==&&&&&&&&&#&&===",
"==============================",
"==============================",
"=============================="
]

add_shape_rectangle = [
"30 30 20 1 ",
"  c #0BA752",
". c #20A955",
"X c #1BB064",
"o c #5BA040",
"O c #F7941E",
"+ c #F7992A",
"@ c #F8A23C",
"# c #B3A342",
"$ c #C5B667",
"% c #FABA6D",
"& c #71CE9E",
"* c #92D9B5",
"= c #FBCD97",
"- c #FCD9B0",
"; c #FDE0BD",
": c #B9E6CF",
"> c #D0EFDF",
", c #FEEDD8",
"< c #D7F1E4",
"1 c None",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"1111;%%%%%%%%%%%%%%%%%%%%%%,11",
"1111=OOOOOOOOOOOOOOOOOOOOOO,11",
"1111=OOOOOOOOOOOOOOOOOOOOOO,11",
"1111=OO=,,,,,,,,,,,,,,,,%OO,11",
"1111=OO-1111111111111111%OO,11",
"1111=OO-1111111111111111%OO,11",
"1111=OO-1111111111111111%OO,11",
"1111=OO-1111111111111111%OO,11",
"1111=OO-1111111111111111%OO,11",
"1111=OO-111111111111111:$OO,11",
"1111=OO-11111111111111: .OO,11",
"1111=OO-11111111111111: .OO,11",
"1111=OO+@@@@@@@@@@@@@@# .OO,11",
"1111=OOOOOOOOOOOOOOo        >1",
"1111=+++++++++++++Oo        >1",
"1111111111111111111<>>* X>>>11",
"1111111111111111111111: X11111",
"1111111111111111111111: X11111",
"1111111111111111111111<&*11111",
"111111111111111111111111111111",
"111111111111111111111111111111"
]

item_ndim = [
"30 30 17 1 ",
"  c #0106FF",
". c #0233FF",
"X c #0450FF",
"o c #3058FF",
"O c #0163FF",
"+ c #326DFF",
"@ c #5353FF",
"# c #4D70FF",
"$ c #626EFF",
"% c #3382FF",
"& c #4F91FF",
"* c #9D9DFF",
"= c #90ACFF",
"- c #A5ACFF",
"; c #A5C8FF",
": c #D2DDFF",
"> c None",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>**>>>>>>>>>>>>>>",
">>>>>>>>>>>*@    @*>>>>>>>>>>>",
">>>>>>>>:@          $:>>>>>>>>",
">>>>>>>>=.oo     .@+O;>>>>>>>>",
">>>>>>>>=....o@#+OOOO;>>>>>>>>",
">>>>>>>>=......OOOOOO;>>>>>>>>",
">>>>>>-$ ......OOOOOO.@*>>>>>>",
">>>-$   ......XOOOOOO.   @*>>>",
">>#@     ......OOOOOO    .+&>>",
">>o.ooo. ......OOOOOO .#+OO%>>",
">>o.... . .....OOOOX...OOOO%>>",
">>o..        ..OX.       .O+>>",
">>.           X.          .+>>",
">>....     XXOO....     XOOO>>",
">>X......XOOOOO......XOOOOOO>>",
">>X.....XOOOOOO......XOOOOOO>>",
">>o......OOOOOO......OOOOOO+>>",
">>o.....XOOOOOX......XOOOOO%>>",
">>o.....oOOOOOO......+OOOOO%>>",
">>o.....oOOOOOO......+OOOOO%>>",
">>>=#...oOOOXXXOXX...+OOO&=>>>",
">>>>>>-#oOX....OOOOX.+%=:>>>>>",
">>>>>>>>=......OOOOOO;>>>>>>>>",
">>>>>>>>=......OOOOOO;>>>>>>>>",
">>>>>>>>=......OOOOOO;>>>>>>>>",
">>>>>>>>:#.....OOOOO&:>>>>>>>>",
">>>>>>>>>>>-#.XOO&->>>>>>>>>>>",
">>>>>>>>>>>>>:-;>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
]

first = [
"30 30 20 1 ",
"  c #092B39",
". c #20343C",
"X c #0E3151",
"o c #1B3967",
"O c #243C62",
"+ c #354349",
"@ c #284278",
"# c #5C6572",
"$ c #354B8D",
"% c #4F5E9C",
"& c #4A5AA7",
"* c #5765B8",
"= c #6666A7",
"- c #6B75CD",
"; c #7D84DC",
": c #999CAC",
"> c #A8A8CD",
", c #9599E2",
"< c #CACBDE",
"1 c None",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"11111111111111111111111:111111",
"111111111111111111111<+ 111111",
"11111>=1111111111111#.  111111",
"11111>=11111111111:+   .111111",
"11111>=111111111<%.     111111",
"11111>=11111111:@o     .111111",
"11111>=111111<$@ooX     111111",
"11111>=11111,&$$@oX     111111",
"11111>=111<-&&&$@ooX   .111111",
"11111>=1<,--*&&$$@oX   .111111",
"11111>-,,---**&&$@oX    111111",
"11111>*,,,;--*&&$$@X    111111",
"11111>=1>,----*&$$ooo   111111",
"11111>=111,---*&&$$ooX .111111",
"11111>=1111<--*&&$$oXX .111111",
"11111>=111111,-*&$$@oXX.111111",
"11111>=1111111<,&&$@ooX.111111",
"11111>=111111111<=$$@oXX111111",
"11111>=11111111111:$@OX+111111",
"11111>=1111111111111=@XO111111",
"11111<>11111111111111<#X111111",
"11111111111111111111111:111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111"
]

view_1d = [
"30 30 17 1 ",
"  c #0A0804",
". c #2C1E0D",
"X c #343230",
"o c #483014",
"O c #67451D",
"+ c #714C20",
"@ c #545250",
"# c gray47",
"$ c #845926",
"% c #90612A",
"& c #AA7331",
"* c #BE8036",
"= c #CE8B3B",
"- c #E39941",
"; c #F9A847",
": c #FAB460",
"> c None",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>@&::::::::::::::::::::::::>>",
">>X%;;;;;;;;;;;;;;;;;;;;;;;;>>",
">>X%;;;;;;;;;;;;;;;;;;;;;;;;>>",
">>X$;;;;;;;;;;;;;;;;;;;;;;;;>>",
">>X%;;;;;;;;;;;;;;;;;;;;;;;;>>",
">>X%;;;;;;;;;;;;;;;;;;;;;;;;>>",
">>X%;;;;&O+=;;;;;;;;;;;;;;;;>>",
">>X%;;=     O;;;;;;;;;;;;;;;>>",
">>X%;& .=;;+ o;;;;;;;;;;;;;;>>",
">>X%& o;;;;;$ %;;;;;;;;;;;-->>",
">>X+ o-;;;;;;o =;;;;;;;;;;;;>>",
">>X. -;;;;;;;;. -;;;;;;;;;;;>>",
">>. &;;;;;;;;;= o;;;;;;;;;*$:>",
">> o;;;;;;;;;;;& +;;;;;;-O  >>",
">>X%;;;;;;;;;;;;+ $;;;;-. $;>>",
">>X%;;;;;;;;;;;;;O o=;&  *;;>>",
">>X%;;;;;;;;;;;;;;%    o-;;;>>",
">>X%;;;;;;;;;;;;;;;-%+&-;;;;>>",
">>X%;;;;;;;;;;;;;;;;;;;;;;;;>>",
">>X%;;;;;;;;;;;;;;;;;;;;;;;;>>",
">>X%;;;;;;;;;;;;;;;;;;;;;;;->>",
">>X%;;;;;;;;;;;;;;;;;;;;;;;=>>",
">>X%;;;;;;;;;;;;;;;;;;;;;;;;>>",
">>X%;;;;;;;;;;;;;;;;;;;;;;;;>>",
">>Xo+O+O++++++++++++++++++++>>",
">>#@@@@@@@@@@@@@@@@@@@@@@@@@>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
]

rudder = [
"30 30 15 1 ",
"  c #03A753",
". c #1BAF63",
"X c #2FB771",
"o c #41BD7D",
"O c #48BF82",
"+ c #56C48C",
"@ c #6CCC9B",
"# c #7BD1A5",
"$ c #8AD6AF",
"% c #A1DEBF",
"& c #A4DFC1",
"* c #B6E6CD",
"= c #C6EBD8",
"- c #D9F1E5",
"; c None",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;-&-;;;;;;;;;;;;;",
";;;;;;;;;;;;;;# *;;;;;;;;;;;;;",
";;;;;;;;;;;;;;# *;;;;;;;;;;;;;",
";;;;;;;-;;;;;;# *;;;;;;-;;;;;;",
";;;;;;@.-;;-$o. .+%;;;* &;;;;;",
";;;;;;$ .-#        .&*. *;;;;;",
";;;;;;;$   .$-$ *-@    *;;;;;;",
";;;;;;;;X  =;;# *;;$  @;;;;;;;",
";;;;;;;$ . .-;# =;*  . -;;;;;;",
";;;;;;;. -$ .-# **  *& +;;;;;;",
";;;;;;* @;;$ .+ @  *;;. ;;;;;;",
";;;;;;# *;;;$     *;;;@ *;;;;;",
";;;XXX. .XXXX    .XXXX. XXX+;;",
";;;                        X;;",
";;;;;;@ =;;;&    .-;;;# *;;;;;",
";;;;;;& @;;& .X o .-;;X ;;;;;;",
";;;;;;; .;*  *# *$ .-= o;;;;;;",
";;;;;;;$ X  =;$ =;# .. =;;;;;;",
";;;;;;;;.  =;;# *;;#  @;;;;;;;",
";;;;;;;%   X*;# *;%.  .-;;;;;;",
";;;;;;&  *O  .. .   #$ .-;;;;;",
";;;;;;+ =;;=+.   X#-;;# $;;;;;",
";;;;;;;=;;;;;;# *;;;;;;*;;;;;;",
";;;;;;;;;;;;;;# *;;;;;;;;;;;;;",
";;;;;;;;;;;;;;# *;;;;;;;;;;;;;",
";;;;;;;;;;;;;;*#-;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
]

math_phase = [
"30 30 24 1 ",
"  c #020202",
". c #2C2C2C",
"X c #606060",
"o c #EA1515",
"O c #FE6128",
"+ c #FF1965",
"@ c #3BFF24",
"# c #23FF5C",
"$ c #CCD63B",
"% c #F3E925",
"& c #221CFF",
"* c #582DFF",
"= c #205AFF",
"- c #FF27A2",
"; c #F11DEC",
": c #BB4EEE",
"> c #1EFFA3",
", c #1E9EFF",
"< c #20F0F2",
"1 c #60F0F0",
"2 c #A5A6A5",
"3 c #D3D0D4",
"4 c #DDE2D9",
"5 c None",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"5555555555542$@$$$445555555555",
"555555555#@@@@@$$$$$4555555555",
"55555554#@@@@$@$$$$%%%44555555",
"5555554#@@@424$3224%%%%3555555",
"555554####3. 22    3%%%%455555",
"55555>###3  X4. $X  4%%OO55555",
"55551>>#>X .44  44. X$%O%$5555",
"5555>#>>4. 2@4  4%2 .3OOOO5555",
"5554>>>>4  3#4  4%4  4O%OO3555",
"5551<>>>4  4#4  4%4  3OOOO$555",
"5551<<<<4  4>4  4%3  2OoooO555",
"555<<<<11. 4<4  4O3  3ooooo555",
"5551<<<11. X14  5-X XOooooo555",
"5551<<<<12  35  52  3O++oo+555",
"5551,,,,,1X  .  .  X-+++++2555",
"5554,,,,,,32.    .23--++++3555",
"5555,,,,====33  43;;---++-5555",
"55551,=====&*3  5;;;-----34555",
"55555,==&=&&*3  3;;;;----55555",
"555554,==&*&&3  3;;;;;;-355555",
"5555553=&&&*&3XX3;;;;;;3555555",
"55555554=&&&**::;;;;;;45555555",
"555555555:*&**::*;;;3555555555",
"555555555553:*::::345555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555"
]

pixel_intensities = [
"30 30 14 1 ",
"  c #0C1115",
". c #131D24",
"X c #1C242A",
"o c #2C3439",
"O c #2C3942",
"+ c #3D4448",
"@ c #3A5364",
"# c #54585A",
"$ c #426F8C",
"% c #66AAD7",
"& c #979898",
"* c #A7A7A7",
"= c #CCCCCC",
"- c None",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"---------------=--------------",
"------------ o+OOX------------",
"------------o%%%%o------------",
"------------o%%%%o------------",
"------------o%%%%o------------",
"------------o%%%%o------------",
"------------o%%%% ooooo-------",
"------------o%%%%.%%%%o-------",
"------------o%%%%.%%%%o-------",
"-------&&&&&X%%%%.%%%%o-------",
"-------.$$$$.%%%%.%%%%o-------",
"-------o%%%%.%%%%.%%%%o-------",
"-------o%%%%.%%%%.%%%%O-------",
"-------o%%%%X%%%%.%%%%o-------",
"--#O#o+.%%%%.%%%%.%%%%o-------",
"--o%%%%.%%%%.%%%%.%%%%o-------",
"--o%%%% %%%%.%%%%.%%%%o-------",
"--o%%%% %%%%.%%%%.%%%% oOOoo--",
"--o%%%%.%%%%.%%%%.%%%%.%%%%o--",
"--o%%%%.%%%%X%%%%.%%%%.%%%%o--",
"--o%%%%.%%%%.%%%%.%%%% %%%%o--",
"--o%%%%.%%%%.%%%%.%%%%.%%%%o--",
"--o%%%%.%%%%.%%%%.%%%%.%%%%o--",
"--X@@@@ @@@@ @@@@ @@@@ @@@@o--",
"--=====*====*====*====*=====--",
"------------------------------"
]

view_nofullscreen = [
"30 30 22 1 ",
"  c #1D1D1D",
". c #262626",
"X c #525252",
"o c #6C5D5E",
"O c #707070",
"+ c #EC1C24",
"@ c #D42E34",
"# c #E7252C",
"$ c #C93B40",
"% c #AF4E52",
"& c #936062",
"* c #B26F71",
"= c #D45C61",
"- c #908F8F",
"; c #BA8B8D",
": c #B2B2B2",
"> c #DC979A",
", c #D3ACAD",
"< c #D9BFC0",
"1 c #CECDCD",
"2 c #E5D1D2",
"3 c None",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"33:XXXXXXXXXXXXXXXXXXXXXXXXX23",
"33OO:1111:11111:11:1,1:111:X13",
"33O-33333333333333333333333.13",
"33O-11111111111111111111111X13",
"33O:3><33333333333333333<>3X13",
"33O:<++;133333333333332>++1X13",
"33O:2*@+$,>>3333333<>1=++*1X13",
"33O:2:&$+##=1333333=#@+@&:1X13",
"33O:22:-%++#,333331@++$O:13X13",
"33O:333:&+++;33333:+++%:133X13",
"33O:3331*&oO:133331*&%*1333X13",
"33O:33331::12333331:--:1333o13",
"33O13333,>>,2333332,,>,2333o13",
"33O:3332=+++1333331+#+=2233X13",
"33O:3331*+#@:233331@++*1333X13",
"33O:331=+@#%1333331%+@+=133o13",
"33O:31#+%o&*1333331;%o$+@,3X13",
"33O:2@+%O::123333331:--%+#2X13",
"33O:2=*-:2233333333322:-*%1X13",
"33O..  .......... ......  . 13",
"333332333333333333333333233333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333"
]

shape_circle = [
"30 30 11 1 ",
"  c #F7941E",
". c #F79929",
"X c #F8A23A",
"o c #F9AB4F",
"O c #FABA6E",
"+ c #FAC17B",
"@ c #FBCA90",
"# c #FCD8AE",
"$ c #FDE1BF",
"% c #FDE8CF",
"& c None",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&%&&&&&&&&&&&&&&",
"&&&&&&&&&&&#o.    o#&&&&&&&&&&",
"&&&&&&&&&#X         o%&&&&&&&&",
"&&&&&&&&@   o#%%%@o   @&&&&&&&",
"&&&&&&&@  X%&&&&&&&%X  #&&&&&&",
"&&&&&&$  o&&&&&&&&&&&o .%&&&&&",
"&&&&&&X o&&&&&&&&&&&&%. o&&&&&",
"&&&&&#  $&&&&&&&&&&&&&# .%&&&&",
"&&&&&O o&&&&&&&&&&&&&&&X @&&&&",
"&&&&&X @&&&&&&&&&&&&&&&O o&&&&",
"&&&&&  #&&&&&&&&&&&&&&&@ o&&&&",
"&&&&&  $&&&&&&&&&&&&&&&@ .&&&&",
"&&&&&. #&&&&&&&&&&&&&&&@ o&&&&",
"&&&&&o O&&&&&&&&&&&&&&&o O&&&&",
"&&&&&@ .&&&&&&&&&&&&&&&  @&&&&",
"&&&&&%  @&&&&&&&&&&&&&O  &&&&&",
"&&&&&&O .%&&&&&&&&&&&$  @&&&&&",
"&&&&&&&X .%&&&&&&&&&#. o&&&&&&",
"&&&&&&&%...O%&&&&&%O  .%&&&&&&",
"&&&&&&&&%X  .oO+Oo   X&&&&&&&&",
"&&&&&&&&&&@        .@&&&&&&&&&",
"&&&&&&&&&&&&#OOoo@#&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&"
]

_d_plane_normal_x = [
"30 30 21 1 ",
"  c #2A3032",
". c #4F361E",
"X c #7A562B",
"o c #67655C",
"O c red",
"+ c #95611A",
"@ c #AE7532",
"# c #F27A1F",
"$ c #817C78",
"% c #E94948",
"& c #008000",
"* c #59AC59",
"= c #D99828",
"- c #F99433",
"; c #F8A847",
": c #0F0FFF",
"> c #2A2AFF",
", c #989892",
"< c #B2ABE3",
"1 c #DCD7DB",
"2 c None",
"22222222222,122222222222222222",
"22222222221&*2222222,$22222222",
"22222222221&*222222, ,22222222",
"22222222221&*22222,.+o22222222",
"22222222221&*2222,.;@$22222222",
"22222222221&*222,.;;@$22222222",
"22222222221&*22,.;;;@$22222222",
"22222222221&*2,.;;;;@$22222222",
"22222222221&*,.;;;;;@$22222222",
"22222222221& .;;;;;;@$22222222",
"22222222221& ;;;;;;;@$22222222",
"2222222222*.=;;;;;;;@$22222222",
"2222222222*+=;;;;;;;@$22222222",
"2222222222o+=;;;;;;;@$22222222",
"2222222222o+=;;;;;;;@$22222222",
"2222222222o+=;;;;;;;@$22222222",
"2222222222o+#;;;;;;;@$22222222",
"2222222222o+##-##-#-+X%%%%%%%1",
"2222222222oX@#######.OOOOOOOO;",
"222222221< X;;-;-;-+X111111112",
"22222222<: @;;;;;-Xo2222222222",
"2222222<:>$$;;;;;Xo22222222222",
"222222<:>2$@;;;;Xo222222222222",
"22222<:>12$@;;;Xo2222222222222",
"2222<:>122o@;;Xo22222222222222",
"222<:>1222,@;Xo222222222222222",
"221::12222o@Xo2222222222222222",
"21::122222$.o22222222222222222",
"1::1222222oo222222222222222222",
"2<2222222222222222222222222222"
]

remove = [
"30 30 13 1 ",
"  c #ED1C24",
". c #EE2B32",
"X c #EF3B42",
"o c #F14C52",
"O c #F25D63",
"+ c #F36C71",
"@ c #F57D82",
"# c #F68E92",
"$ c #F79EA1",
"% c #F9B2B4",
"& c #FBD1D3",
"* c #FCDFE0",
"= c None",
"==============================",
"==============================",
"==============================",
"==============================",
"==============================",
"======================*=======",
"========O============&O=======",
"=======& +==========& .=======",
"=======%  +========&.  =======",
"=======$   @======*.   *======",
"=======*X   #====*.   $=======",
"========*X   #==*.   #========",
"=========*X   #*.   #=========",
"==========*.   .   #==========",
"===========&.     +===========",
"============&    o============",
"============o     %===========",
"===========o      .%==========",
"==========O   O%    %=========",
"=========+   o==%.  .&========",
"========+   o====%    &=======",
"=======$   o*=====%   .*======",
"=======#  o*=======$   %======",
"=======$ o*=========$  &======",
"=======&.*===========# =======",
"=======**=============#=======",
"==============================",
"==============================",
"==============================",
"=============================="
]

document_open = [
"30 30 24 1 ",
"  c #775A39",
". c #6B6B6B",
"X c #AF7D43",
"o c #04A553",
"O c #27A263",
"+ c #4AAF7C",
"@ c #E6922E",
"# c #F7992C",
"$ c #AE8E68",
"% c #D59B58",
"& c #F6A64C",
"* c #F4B46C",
"= c #67B78E",
"- c #999592",
"; c #B0B2B4",
": c #E7BC8C",
"> c #96C7AE",
", c #F1C696",
"< c #F1D0AA",
"1 c #B9C5C2",
"2 c #D2D3D4",
"3 c #ECE1D2",
"4 c #DEDFE3",
"5 c None",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555552>>2555555555",
"555555555555555>OooooO15555555",
"5555555555554=++===+ooo>555555",
"55555555552>145555553>Oo>=O555",
"5555555554455555555555>ooo>555",
"5555555555555555545551Oooo4555",
"555555555553544444452=+oo=5555",
"555555445444444342144555255555",
"5554444422221;;-...-2445555555",
"55554421221;;---....22443<,*55",
"55222244421;;--...  %&######55",
"55244444221---$$%@%########*55",
"552444442;;:*:***&&&#######<55",
"542444421;:,,***&&##&#####&555",
"54324422;;:,****&&##&#####:555",
"5542422;;-,,,:*&&&&&######3555",
"554242;;-;,,*****&&######&5555",
"544211;--,<,,***&&&######<4455",
"54541;;--<,,::*&&&&&####@44555",
"5554;;--;<<,:****&######*45555",
"55441--.<<,,*:*&&&&#####<25555",
"55544---3<<,,***&&&####@244555",
"55554;.:3<<,****&&#@@XX;454555",
"555531.33<<,:*%%$$-1;222445555",
"555544-3::$-$;11;2222344455555",
"555555312222222223224454555555",
"555555454444344444445535555555",
"555555555444545455555555555555"
]

tree_collapse_all = [
"30 30 15 1 ",
"  c #000000",
". c #090909",
"X c #141414",
"o c #2F2F2F",
"O c #696969",
"+ c #888888",
"@ c #949494",
"# c #A9A9A9",
"$ c #B3B3B3",
"% c #BABABA",
"& c #CFCFCF",
"* c #EAEAEA",
"= c #F4F4F4",
"- c #F9F9F9",
"; c None",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;%XXXXXXXXXXXXXXXXXX&;;;;;;;",
";;;% +++@++++++@++++O &;;;;;;;",
";;;$ *;;;;;;;;;;;;;;* %;;;;;;;",
";;;$ *;;;;;;;;;;;;;;& &;;;;;;;",
";;;$ *;*.....X.....X.....X;;;;",
";;;% *;= O@@@@@@@@@@@@@@OX;;;;",
";;;$ *;= #;;;;;;;;;;;;;;+.;;;;",
";;;$ *-= $;;;;;;;;;;;;;;@.;;;;",
";;;$ *;= #;;;;;;;;;;;;;;@X;;;;",
";;;$ *;= $;;;;;;;;;;;;;;+X;;;;",
";;;$ *-= $;;;;;;;;;;;;;;@X;;;;",
";;;% *;= $;;;;;;;;;;;;;;+.;;;;",
";;;$ =;= #;o..        %;@.;;;;",
";;;% *;* $;o          %;@.;;;;",
";;;$ *;= $=Ooooooooooo%;@X;;;;",
";;;$ *-= #;;;;;;;;;;;;;;+X;;;;",
";;;$ #%# $;;;;;;;;;;;;;;@.;;;;",
";;;$     $;;;;;;;;;;;;;;@.;;;;",
";;;-***& #;;;;;;;;;;;;;;@X;;;;",
";;;;;;;= $;;;;;;;;;;;;;;+X;;;;",
";;;;;;;= O##############OX;;;;",
";;;;;;;=   .             .;;;;",
";;;;;;;;-=-==--=-==-=--=-=;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
]

plot_toggle_points = [
"30 30 12 1 ",
"  c #01A550",
". c #1BAF63",
"X c #28B46C",
"o c #52C389",
"O c #62C894",
"+ c #7BD1A5",
"@ c #9BDCBA",
"# c #A7DFC1",
"$ c #A9E1C4",
"% c #C7EBD8",
"& c #D5F1E3",
"* c None",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"*******$******%&**************",
"******* @***** $**************",
"******* #***** @**************",
"******& #***** @**************",
"******& #***** @**************",
"******* #***** #**************",
"******* #***&* @&*****&**&****",
"******& #**&     +***     O***",
"******* #**& +#$.+**&     O***",
"******& #**& %**.+***     O***",
"******* #**& %**.+**&     O***",
"******& #**& oOO.+***     O***",
"******* #**&XX .X@***XXXXX+***",
"******& #***** @**************",
"******* #***** @**************",
"******& #***** #**************",
"******* #***** @**************",
"******& @***** @**************",
"*******+%*****+&**************",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************"
]

colormap = [
"30 30 21 1 ",
"  c #4B4A4C",
". c #EE2A7B",
"X c #13AC5E",
"o c #F89D32",
"O c #F8A139",
"+ c #F9AB4F",
"@ c #FAB96C",
"# c #E0DE46",
"$ c #693293",
"% c #A15FA8",
"& c #F15395",
"* c #04AFEF",
"= c #64CCD0",
"- c #B5AAB4",
"; c #FBC88C",
": c #FCD9AF",
"> c #F3EBAB",
", c #ABE4EE",
"< c #FDEAD0",
"1 c #E1D6E0",
"2 c None",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"2222222222222<2222222222222222",
"2222222222<;o+O@22222222222222",
"222222222;o;222+<2222222:@+:22",
"2222222<+@22222+<22222;o@<<+:2",
"222222<O:222222O2222:O;2222:@2",
"22222:O121%$%1>@22<+@<222222o2",
"2222<o<2$$$$$1:;<;O:22222222o2",
"222<O<2%$$$%12<O+;2222===,22o2",
"222+:221--1222222222,****,21+2",
"22:@2222222222<>#>22****,22>@2",
"22O<22222222<#####221,,2222@:2",
"2:@222222222#####>22222222<O22",
"2@>2,=XX>222<##>2222---122@:22",
"2o<=XXXX=222222222-    12:+222",
"<+2XXXX>222222222-    -2<O<222",
":@2211222222222221   ,2>O<2222",
":;222222221&&122222222<o<22222",
">+222222<&..&&2222222;+<222222",
"2o222222&....122222:+@22222222",
"2;@22222&.&&22222<@+:222222222",
"22+;2222222222<;++:22222222222",
"222@O;<<<<<:;++;<2222222222222",
"2222<:@++++;:<2222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222"
]

sliders_on = [
"30 30 13 1 ",
"  c #07A350",
". c #30B36D",
"X c #44BA7B",
"o c #4DBD82",
"O c #5CC38C",
"+ c #69C795",
"@ c #7BCFA2",
"# c #8BD4AD",
"$ c #A3DDBE",
"% c #AEE1C6",
"& c #C8EBD8",
"* c #D5F0E2",
"= c None",
"==============================",
"==============================",
"==============================",
"==============================",
"==============================",
"==============================",
"========$@+@#=====#+@@#=======",
"====*&&&. .  %&&&&  . .%&&====",
"====+    O=#       #=X    ====",
"====**&&.    **&**    .***====",
"========$##@#=====####$=======",
"==============================",
"======#$$$&========*$$$$*=====",
"======    X*=**=*==@    %=====",
"====+  #=..          =*   ====",
"====&# .. X$$%$%$$$o .. +$====",
"======OOOO#========%OOOO&=====",
"==============================",
"=======&&&**====***&&=========",
"======%    $====#    %========",
"====&   %&  . .   &%  .  .====",
"====*#O O+ o@@@@X +O o@#@#====",
"======&....$====$....&========",
"==============================",
"==============================",
"==============================",
"==============================",
"==============================",
"==============================",
"=============================="
]

plot_roi_below = [
"30 30 22 1 ",
"  c #0B0B0B",
". c #2F2F30",
"X c #643C0D",
"o c #754C1B",
"O c #4E4F50",
"+ c #6E6F70",
"@ c #825725",
"# c #AC783B",
"$ c #E29C47",
"% c #F2AB55",
"& c #C39A6A",
"* c #CAA070",
"= c #FAB360",
"- c #919294",
"; c #9EA0A3",
": c #A7A9AC",
"> c #E7BF91",
", c #F9CF9B",
"< c #FCD4A6",
"1 c #D0D0D0",
"2 c #FDE9D1",
"3 c None",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"3<<<<<<<<233333333333333333333",
"3======%$,33332333333333333333",
"3<<<<,<<=,3333  33333333333333",
"3<<<<<<<=,333-..-3333333333333",
"3<<<<<<<=,333.++.3333333333333",
"3<<<<<<<=,332 -- 1333333333333",
"3<<<<<<<=,33;.::O+333333333333",
"3<<<<<<<=,33.O::+.333333333333",
"3<<<<<<<=,1+.;::; 133333333333",
"3<<<<<<<=& .-::::.;33333333333",
"3<<<<<<<=@+:;::::O+31+23333333",
"3<<<<<<<=o+::::::+ 3+ +3333333",
"3<<<<<<<=o-::::::; 1...3333333",
"3<<<<<<<%o-:::::::O+ - 2333333",
"3<<<<<<*#@::::::::+ .; 1333333",
"3<<<<<&o#$:::::::::-;:.;333333",
"3<<<<<o#$*:::::::::::;O+333333",
"3<<<<,X&$*::::::::::::+.::3333",
"3<<<<*o&$*::::::::::::;   1333",
"3<<<,o#;$*:::::::::::;:O.OO333",
"3<<<,#>,%$%%%$%%%%$%%%$$$$#%=3",
"332332332222222222222222222223",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333"
]

silx = [
"30 30 22 1 ",
"  c #131313",
". c #333334",
"X c #535355",
"o c #65615E",
"O c #6F6F70",
"+ c #907F6D",
"@ c #F7941E",
"# c #F6992A",
"$ c #AE9372",
"% c #E0A053",
"& c #CEA573",
"* c #F0B56E",
"= c #7E7F80",
"- c #8C8C8E",
"; c #A7A099",
": c #ADADAF",
"> c #CDB18E",
", c #E9C69C",
"< c #EACEAC",
"1 c #D5D5D5",
"2 c #E4DACB",
"3 c None",
"333333333333333333333333333333",
"333333333333333133333333333333",
"333333333333311113333333333333",
"333333333333113111333333333333",
"333333333331111:-O133333333333",
"33333333333131;;;OO=3333333333",
"3333333333333:--;OOO1333333333",
"3333333333333:-:-OOO-333333333",
"33333333333311-;-XO=O333333333",
"33333333333333;#>XXOO;33333333",
"33333333133333>#$OOoXo13333333",
"33333333331321;#$XXXoX=3333333",
"333333311331*%>@&Xooo+X;333333",
"333333133131*#>@&OO=oX.X333333",
"33333313311111>@&:;-X..X:33333",
"3333332<<<,2<,<@>>::.Xo+-33333",
"33333<##@@@**#<@&##>Oo#@&33333",
"33333*@,,,,<*#<@>&@@&%@%-33333",
"33333*@*,,<1*#<@&=>#@@#$o33333",
"333332#@@@#,*#&@&=-%@@;XX33333",
"33331112<<@*%#$@&-*##@@$o13333",
"33333,***%@%%#$@&%@#$&@#$:3333",
"33333,@###%O&%-#$%#;-o&@$:3333",
"33333:;-;--XXoXOX$-oXoOO 33333",
"333333-=====XXXXoO=XXX  ;33333",
"3333331====;==O......  1333333",
"3333333:==-OXoX..... o33333333",
"33333333:=-XoXXo...O1333333333",
"3333333331;XXooO--133333333333",
"333333333333333333333333333333"
]

profile_clear = [
"30 30 23 1 ",
"  c #913332",
". c #A82A23",
"X c #FB0404",
"o c #DE3021",
"O c #C45D24",
"+ c #AF4E4E",
"@ c #AE6666",
"# c #E35553",
"$ c #DC6969",
"% c #EC7071",
"& c #F5931E",
"* c #E7932F",
"= c #F7AB4F",
"- c #CCA06D",
"; c #F5B76E",
": c #909090",
"> c #ACACAC",
", c #F8C993",
"< c #FCDBB2",
"1 c #CFCFCF",
"2 c #E7DEDE",
"3 c #FCE6CC",
"4 c None",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444424444444244444444444",
"444444444%X%44444%X-2444444444",
"444444444$XX$244%XX+2444444444",
"4444444441.XX$2%XX >4444434444",
"44444444441+XXoXX.@-;==&&,4444",
"444443<,,;=*.XXX. &&&&&&&;4444",
"4443&&&&&&&&oXXXoO&&&&&==,4444",
"4443&&&&&&&oXX.XXo,<2444444444",
"4444;,,<<3#XX :+XX#14444444444",
"444444444$XX >21@XX#2444444444",
"444444444$o >4441@o+2444444444",
"4444444442>>244442>>4444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444"
]

math_average = [
"30 30 9 1 ",
"  c #0E0E0E",
". c #262626",
"X c #F7941E",
"o c #F89E32",
"O c #F9AC50",
"+ c #F9B461",
"@ c #D4D4D4",
"# c #FEEEDC",
"$ c None",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$",
"$$$$$$#ooooooooooooooooo+$$$$$",
"$$$$$$#XXXXXXXXXXXXXXXXXO$$$$$",
"$$$$$$$################$#$$$$$",
"$$$$$$$$@@$$$$$$$$$$$$@@$$$$$$",
"$$$$$$$@ .@$$$$$$$$$$#..@$$$$$",
"$$$$$$$@  .@$$$$$$$$@.  @$$$$$",
"$$$$$$$$@.  @$$$$$$#.  @$$$$$$",
"$$$$$$$$$@. .@$$$$@.  @$$$$$$$",
"$$$$$$$$$$@  .@$$@.  @$$$$$$$$",
"$$$$$$$$$$$@. .@@.  @$$$$$$$$$",
"$$$$$$$$$$$$@   .  @$$$$$$$$$$",
"$$$$$$$$$$$$$@    @$$$$$$$$$$$",
"$$$$$$$$$$$$$@   @$$$$$$$$$$$$",
"$$$$$$$$$$$$@  .@$$$$$$$$$$$$$",
"$$$$$$$$$$$@  .@$$$$$$$$$$$$$$",
"$$$$$$$$$$@  .@$$$$$$$$$$$$$$$",
"$$$$$$$$$@  .@$$$$$$$$$$$$$$$$",
"$$$$$$$$@  .@$$$$$$$$$$$$$$$$$",
"$$$$$$$@  .@$$$$$$$$$$$$$$$$$$",
"$$$$$$$@ .$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$@#$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$"
]

cube_rotate = [
"30 30 21 1 ",
"  c gray2",
". c #303030",
"X c #5B3F1E",
"o c #624726",
"O c #6C5131",
"+ c #515151",
"@ c #706150",
"# c #6B6A69",
"$ c #815F37",
"% c #896539",
"& c #987447",
"* c #8B7964",
"= c #DD8D2D",
"- c #E79635",
"; c #94826D",
": c #E69D44",
"> c #F9A847",
", c #908F8F",
"< c #B7B7B7",
"1 c #D3D2D2",
"2 c None",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"22222222222222222221++++,22222",
"222222<2222222222222+   <22222",
"2221+  #2222222222221    +1222",
"221   #12222222222222, +   122",
"22# #22222222222222222#22# #22",
"22,  ,222222222222222222,  ,22",
"222#   .+,<11112111<,+.   #222",
"22221#                  #12222",
"22222222<,#++...+++#,<22222222",
"222222222222222222222222222222",
"2222222222222#@@@@@@@,22222222",
"222222222222*=>>>>>>$@22222222",
"22222222222*:->>>>>%:*22222222",
"2222222222*:>->>>>%:>*22222222",
"222222222;:>>->>>%:>>*22222222",
"22222222@OOOOXOOo:>>>*22222222",
"22222222*>>>>=>>%>>>>*22222222",
"22222222;>>>>->>%>>>>#22222222",
"22222222*>>>>===o==-=O22222222",
"22222222*>>>->>>%>>>&122222222",
"22222222*>>-->>>%>>&1222222222",
"22222222*>->>>>>%>&12222222222",
"22222222*->>>>>>%&122222222222",
"22222222*oOOOOOOX1222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222"
]

plot_grid = [
"30 30 12 1 ",
"  c #01A14B",
". c #30B36D",
"X c #42BA79",
"o c #4BBD80",
"O c #56C188",
"+ c #67C894",
"@ c #97D9B6",
"# c #A4DDBF",
"$ c #A7DFC1",
"% c #ABE0C4",
"& c #D8F1E4",
"* c None",
"******************************",
"******************************",
"******************************",
"******************************",
"*******+&*****$#*****%#*******",
"******* @*****oo*****O.*******",
"******& $*****oo*****O.*******",
"****@@@ O@@@@@..@@@@@..@@#****",
"***&                     .****",
"******* $*****oo*****OX*******",
"******& $*****oo*****OX*******",
"******* $*****oo*****OX*******",
"******* #*****oo*****OX*******",
"******& #*****oo*****OX*******",
"*****&& @***&*XX*&&**X.*&*****",
"***&                     .****",
"****#$# +%%%$%..%%%$%..%$%****",
"******* $*****oo*****OX*******",
"******& #*****oo*****OX*******",
"******* #*****oo*****OX*******",
"******& #*****oo*****OX*******",
"******* #*****XX*****o.*******",
"***&                     .****",
"****@@@ +#@@#@..@@@#@..##%****",
"******& #*****oo*****OX*******",
"******* $*****oo*****OX*******",
"*******@&*****$%*****%$*******",
"******************************",
"******************************",
"******************************"
]

profile1D = [
"30 30 21 1 ",
"  c black",
". c #040404",
"X c gray2",
"o c #070605",
"O c gray3",
"+ c #181817",
"@ c #181818",
"# c gray46",
"$ c #947147",
"% c gray66",
"& c gray70",
"* c #FBC584",
"= c #FBC686",
"- c #FCCA8F",
"; c #FBCB90",
": c gray76",
"> c #E9E9E9",
", c gray94",
"< c #F1F1F1",
"1 c gray99",
"2 c None",
"222222222222222222222222222222",
"22:%%%%%%%%%%%%%%%%%%%%%%%%%%,",
"22@.OOOOOOOOOOOOOOOOOOOOOOOO &",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22+$*******************-;;;;o&",
"22+$***********************=o&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@#222222222222222222222222X&",
"22@                          &",
"22<>>>>>>>>>>>>>>>>>>>>>>>>>>1",
"222222222222222222222222222222"
]

view_raw = [
"30 30 16 1 ",
"  c #090706",
". c #281B0B",
"X c #39260F",
"o c #353434",
"O c #4B3316",
"+ c #6B481E",
"@ c #7D5424",
"# c #4D4D4D",
"$ c #656565",
"% c #845926",
"& c #94642A",
"* c #A87230",
"= c #CD8A3A",
"- c #E49A41",
"; c #F9A847",
": c None",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::$                       ::::",
"::$.****&O *&*&*& .*&***+ ::::",
"::$O;;;;;+ ;;;;;- O;;;;;&.::::",
"::$O;;;;;+ ;;;;;- O;;;;;* ::::",
"::$O;;;;;+ ;;;;;- O;;;;;&.::::",
"::$O;;;;;+ ;;;;;= O;;;;;& ::::",
"::$O;;;;;+ ;;;;;- O;;;;;& ::::",
"::# XXXXX  XXXXXX  XXXXX. ::::",
"::o                       ::::",
"::$O;;;;;+ ;;;;;= O;;;;;* ::::",
"::$O;;;;;+ ;;;;;- O;;;;;&.::::",
"::$O;;;;;+ ;;;;;- O;;;;;& ::::",
"::$O;;;;;+ ;;;;;= O;;;;;& ::::",
"::$O;;;;;+ ;;;;;= O;;;;;* ::::",
"::$X=====O ====== X=====@ ::::",
"::o                       ::::",
"::$ OOOOO. OOOOXO  OOOOO. ::::",
"::$O;;;;;+ ;;;;;= O;;;;;&.::::",
"::$X;;;;;+ ;;;;;- O;;;;;& ::::",
"::$O;;;;;+ ;;;;;= O;;;;;& ::::",
"::$O;;;;;+ ;;;;;- O;;;;;&o::::",
"::$O;;;;;+ ;;;;;- O;;;;;& ::::",
"::$.%%&%&X %@&&%% .&&&&&O ::::",
"::$.o ...  .o ...  . .. .o::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::"
]

view_nexus = [
"30 30 18 1 ",
"  c #040302",
". c #271A0B",
"X c #322412",
"o c #33312F",
"O c #493216",
"+ c #64441D",
"@ c #69481E",
"# c #717171",
"$ c #895D27",
"% c #98672B",
"& c #B57B33",
"* c #D08D3B",
"= c #E69B41",
"- c #F8A846",
"; c #9D9D9D",
": c #A8A8A8",
"> c #CFCFCF",
", c None",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,>;####:>,,,,,,,,,,,",
",,,,,,,,,:o ..OXX. o:,,,,,,,,,",
",,,,,,,>o +&------&+ o>,,,,,,,",
",,,,,,:.O*----------=O :,,,,,,",
",,,,,: @--------------@ :,,,,,",
",,,,> @----------------@ >,,,,",
",,,,oO------------------Oo,,,,",
",,,: *------------------* :,,,",
",,,oO-%OO*--+O*=OO*--%OO-Oo,,,",
",,> *-$  O--. &-@ X-=. %-& >,,",
",,; --$   *-. &-=. %+ O--- :,,",
",,#X--$ . @-. &--&    *---X#,,",
",,#O--$ OO *. &---O  $----O#,,",
",,#O--$ O* @. &---X  O----O#,,",
",,#X--% +-O   &--$ .  &---X#,,",
",,: --$ O-&   &-=  *$ .--- :,,",
",,> &-$ O--X  &-O +--X @-& >,,",
",,,o+-&+%--*++**++=--*@@-@o,,,",
",,,: *------------------* :,,,",
",,,,oX------------------Oo,,,,",
",,,,>.@----------------@ >,,,,",
",,,,,: @--------------@ :,,,,,",
",,,,,,: O*----------*O :,,,,,,",
",,,,,,,>o +&------&+ o>,,,,,,,",
",,,,,,,,,:o  XOOX. o:,,,,,,,,,",
",,,,,,,,,,,>;####:>,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,"
]

shape_polygon = [
"30 30 11 1 ",
"  c #F7941E",
". c #F79928",
"X c #F8A23A",
"o c #F9AA4D",
"O c #FAB96C",
"+ c #FAC17D",
"@ c #FBCB92",
"# c #FCD8AE",
"$ c #FDE0BE",
"% c #FDE8CE",
"& c None",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&%@&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&#.o&&&&&&&&&&&&&&&",
"&&&&&&&&&&&@   &&&&&&&&&&&&&&&",
"&&&&&&&&&&#    $&&&&&&&&&&&&&&",
"&&&&&&&&&@  oX O&&&&&&&&&&&&&&",
"&&&&&&&&@  o&O o&&&&&&&&&&&&&&",
"&&&&&&&@  X&&#  &&&&&&&&&&&&&&",
"&&&&&&O .o&&&&  @&&&&&&&&&&&&&",
"&&&&&O  O&&&&&o O&&&&&&&&&&&&&",
"&&&&O  o&&&&&&@ .&&&&&&&&&&&&&",
"&&&&X .&&&&&&&%  %&&&&&&&&&&&&",
"&&&&$  @&&&&&&&X .@&&&&&&&&&&&",
"&&&&&O  %&&&&&&@   X#&&&&&&&&&",
"&&&&&&X X&&&&&&&&O   X#&&&&&&&",
"&&&&&&%  O&&&&&&&&%o.  o%&&&&&",
"&&&&&&&+  %&&&&&&&&&%o   O%&&&",
"&&&&&&&&X X&&&&&&&&&&&#.  O&&&",
"&&&&&&&&%  O&&&&&&&&&&&X .&&&&",
"&&&&&&&&&O  %&&&&&&&&&o. %&&&&",
"&&&&&&&&%. o&&&&&&&&&@  @&&&&&",
"&&&&&&&%. X%&&&&&&&&%. o&&&&&&",
"&&&&&&&o  @%&&&&&&&&X .&&&&&&&",
"&&&&&&o      XoO@@%O  $&&&&&&&",
"&&&&&%OoX.           @&&&&&&&&",
"&&&&&&&&&&&%#@@Oo   o&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&%&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&"
]

math_imaginary = [
"30 30 16 1 ",
"  c #010101",
". c #0C0C0C",
"X c #191919",
"o c #2D2D2D",
"O c #525252",
"+ c #727272",
"@ c #8A8A8A",
"# c #979797",
"$ c #A6A6A6",
"% c #B3B3B3",
"& c #C6C6C6",
"* c #D9D9D9",
"= c #E7E7E7",
"- c #F3F3F3",
"; c #FAFAFA",
": c None",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
":::::::#++++&:::::::::::::::::",
":::::::-% O-::::::::::::::::::",
"::::::::# $:::::::::::::::::::",
"::::::::O *:::::::::::::::::::",
"::::::::XX:::;*O%;-++:;#o-;:::",
":::::::& O::-+  *$X #%o o:::::",
":::::::# $::&*O O$$ o#-.O:::::",
":::::::O *::::oo-:+.=:= %:::::",
":::::::.o::::= #::OO-:$ =:::::",
"::::::& O::::# *:;.@;:+o:;::::",
"::::::@ #::::OX::& &::oO:--:::",
"::::::O =::::o+::+.;:; O#+-:::",
"::::*$..$&::= $::oO::* X%:::::",
":::;%$%$$=::*&::;$-::;$;::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::"
]

item_3dim = [
"30 30 15 1 ",
"  c #0101FF",
". c #0034FF",
"X c #2D39FF",
"o c #1544FF",
"O c #3759FF",
"+ c #0163FF",
"@ c #3372FF",
"# c #5356FF",
"$ c #4A6FFF",
"% c #478EFF",
"& c #7BAEFF",
"* c #859BFF",
"= c #ABABFF",
"- c #ABC4FF",
"; c None",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;=##=;;;;;;;;;;;;;",
";;;;;;;;;;=#      #=;;;;;;;;;;",
";;;;;;;-#            #=;;;;;;;",
";;;;=#                  #=;;;;",
";;*X                      X*;;",
";;$.oOO                XO@+%;;",
";;$....o$X          X$@++++%;;",
";;$.......o#X    .O@+++++++%;;",
";;$..........oO$@++++++++++%;;",
";;$............++++++++++++%;;",
";;$............++++++++++++%;;",
";;$............@+++++++++++%;;",
";;$............++++++++++++%;;",
";;@............++++++++++++%;;",
";;#...........o++++++++++++%;;",
";;$............++++++++++++%;;",
";;$............++++++++++++%;;",
";;$............++++++++++++%;;",
";;$.......o....++++++++++++%;;",
";;*............@+++++++++++&;;",
";;;;-%.........+++++++++%-;;;;",
";;;;;;;-$......++++++%-;;;;;;;",
";;;;;;;;;;-%o..+++%=;;;;;;;;;;",
";;;;;;;;;;;;;=%%-;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
]

spec = [
"30 30 13 1 ",
"  c #090909",
". c #2E2E2E",
"X c #3F4040",
"o c #4E4E4F",
"O c #6B6C6C",
"+ c #7F8080",
"@ c #8E8F8F",
"# c #ACACAD",
"$ c #BEBFC0",
"% c #CFD0D0",
"& c #DEDFE0",
"* c #DFE0E1",
"= c None",
"==============================",
"==============================",
"==============================",
"==============================",
"==#%%$%%%%%%%%%%%%%%%%%%%%%%#=",
"==%=========================%=",
"==%=========================%=",
"==%#%#%$#%%#%%#%%#%%#%$$%#%$$=",
"==*****==*=***=**=***==*=****=",
"==**==***=**=*=**=*==*****====",
"==&**%&*****=*****=**=*=*&%**=",
"==&#.  O=o. .O*% .  X**@.  .*=",
"==*..OO@=..Oo O% .OOO*@ .OOO*=",
"==# O==**..=&..% O**=&. %&***=",
"==%  O&*=..*& o% .@@## O***===",
"==&#  .#=. o. @%    o@ O==***=",
"==**&O .=. .o#*% o##%@ O*****=",
"==*=*=o *..==**% O*==% .&*=**=",
"==%o@O..*X.=***% .+O+=O .@@O*=",
"==#   .#*..**==%     **o   .*=",
"==*&##*=*%%*=***%$$%%**=&##**=",
"==***=**=**=**==*=***=***=***=",
"==*==*=*=****=***=*==*=***=**=",
"==****=***==**=****=**=*=**=*=",
"==&&**&*&*&&**&*&*&&**&*&*&&&=",
"==============================",
"==============================",
"==============================",
"==============================",
"=============================="
]

layer_nx = [
"30 30 16 1 ",
"  c #000000",
". c gray2",
"X c gray4",
"o c #161616",
"O c #282828",
"+ c #444444",
"@ c #727272",
"# c #8B8B8B",
"$ c #939393",
"% c #B7B7B7",
"& c #C6C6C6",
"* c #DCDCDC",
"= c #E5E5E5",
"- c #F3F3F3",
"; c #F9F9F9",
": c None",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::-**:*&-::=*=::;*=-::::::",
"::::::# o@  X&:&..%;@ O-::::::",
"::::::#  O@o +::# O$Xo*:::::::",
"::::::#  *:# o:::O   $::::::::",
"::::::# o::$ o:::*  O:::::::::",
"::::::# o::# o:::O   #::::::::",
"::::::# o::$ X::@ o% .&:::::::",
"::::::# o::$ o:&X.&:@ O-::::::",
"::::::=%&::=%&:&%&::;%%=::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::"
]

compare_mode_b = [
"30 30 15 1 ",
"  c #010100",
". c #23241F",
"X c #3E491A",
"o c #47531D",
"O c #556423",
"+ c #5C6C26",
"@ c #434442",
"# c #738730",
"$ c #819836",
"% c #8EA73B",
"& c #9DB841",
"* c #B9DA4D",
"= c #BFE14F",
"- c #D4F958",
"; c None",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;@........................@;;",
";;.X###+##################X.;;",
";;.#----------------------#.;;",
";;.#----------------------#.;;",
";;.#----oooooooO+$*-------#.;;",
";;.#---=           X------#.;;",
";;.#---*            X-----#.;;",
";;.#---*    O#$#     *----#.;;",
";;.#---*    %---*    $----#.;;",
";;.#---*    %---=    %----#.;;",
";;.#---*    %---O    -----#.;;",
";;.#----            #-----#.;;",
";;.#---*           O------#.;;",
";;.#---=            .-----#.;;",
";;.#---=    $--*#    +----#.;;",
";;.#---*    $----+    ----#.;;",
";;.#---=    %----%    ----#.;;",
";;.#---*    %----o    ----#.;;",
";;.#----    +#$#X    .----#.;;",
";;.#---*             %----#.;;",
";;.#---*           .%-----#.;;",
";;.#---=oooooooOO#&-------#.;;",
";;.#----------------------#.;;",
";;.#----------------------#.;;",
";;.X######################o.;;",
";;@........................@;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
]

compare_mode_rbneg_channel = [
"30 30 24 1 ",
"  c #FE7F01",
". c #FF8001",
"X c #EE8E2E",
"o c #B1804E",
"O c #FFA851",
"+ c #FFB871",
"@ c #7E7F81",
"# c #77808A",
"$ c #5981A9",
"% c #0280FE",
"& c #2E93F7",
"* c #54A5F6",
"= c #72B8FD",
"- c #818181",
"; c #B9AA9A",
": c #B7B7B6",
"> c #FFD2A5",
", c #8CABC9",
"< c #A2D1FF",
"1 c #CECECE",
"2 c #FFE4C9",
"3 c #CDD7E0",
"4 c #C9E4FF",
"5 c None",
"555555555555555555555555555555",
"555555555555555555555555555555",
"55555555522>>2553<<<5555555555",
"55555552O... X#$%%%%%*45555555",
"555555+.    o#@@$%%%%%%=555555",
"55555O..   o@@@@o#&%%%%%*55555",
"5555+...  X#@#@@##o%%%%%%=5555",
"5552....  #@###o###$%%%%%%4555",
"555X.... o@@@@@@###o%%%%%%&555",
"552..... ###@@@@#o-#$%%%%%%455",
"55+.....X:::@#@@-::::=&%%%%=55",
"55X.....;555-##o-355555<%%%&55",
"55......1555:@@--351-,55&%%%55",
"52......55:55@@--351-,55%%%%45",
"52.....+53@55;---255555=%%%%45",
"52.....25:#151---3531355&%%%45",
"52....X5524555##o451@#45<%%%45",
"55....>5532455:##351-=55=%%%55",
"55X...25;@@@:53#-3555554%%%&55",
"55+..X++X@@@-1:o-::::=*%%%%=55",
"552 .... $@@#@##-@@@$%%%%%%455",
"555O.... o@@@##o---@&%%%%%&555",
"5552....  ##o#-@@-@$%%%%%%4555",
"5555+...  X###@---@%%%%%%=5555",
"55555O.....o##--@-&%%%%%*55555",
"555555+.....o#--@%%%%%%=555555",
"55555552O ....#$%%%%%*45555555",
"5555555555>>>2553<=35555555555",
"555555555555555555555555555555",
"555555555555555555555555555555"
]

cube_front = [
"30 30 13 1 ",
"  c #14110E",
". c #3A3835",
"X c #484848",
"o c #AA691A",
"O c #A46F2F",
"+ c #CE7D1C",
"@ c #CF8733",
"# c #EA9938",
"$ c #F9A847",
"% c gray60",
"& c #B3B3B3",
"* c #CECECE",
"= c None",
"=============*===*=*==*==*====",
"==========*                  =",
"=========*..*=============&. =",
"========*.*X*============&.* =",
"=======*.*=X*===========&X== =",
"======*.===.*==========&.=== =",
"=====*.*===X*=========&.*=== *",
"====*.*====X*========&.=====.=",
"===*.*=====X*=======&X====== =",
"==*.=======X*======&.======= =",
"=*.*=======.*=====&.======== =",
"*                 .========= =",
"= @@@@@@@@@o@@@@@O.========= =",
"= $$$$$$$$$@#$$$$@X========= =",
"= $$$$$$$$$@$$$$$@.========= =",
"= $$$$$$$$$@#$$$$@.========= =",
"= $$$$$$$$$+#$$$$@.========= =",
"= $$$$$$$$$@#####@.&*&&**&*& =",
"= $$$$$$$$$++++++o           *",
"* $$$$$$$$@#$$$$$@.=======*.*=",
"= $$$$$$$+#$$$$$$@.======*.*==",
"= $$$$$$+#$$$$$$$@.======.*===",
"= $$$$$@#$$$$$$$$@.=====.*====",
"= $$$$@#$$$$$$$$$@.====.&=====",
"= $$#@#$$$$$$$$$$@X===.&======",
"* $$@#$$$$$$$$$$$@.==X%=======",
"= $##$$$$$$$$$$$$@.=X&========",
"= @#$$$$$$$$$$$#$@.X%=========",
"=                  %==========",
"=*===**=*====*====*==========="
]

compare_mode_a_minus_b = [
"45 45 14 1 ",
"  c #030303",
". c #050505",
"X c #0C0C0C",
"o c #151515",
"O c #2D2D2D",
"+ c #505050",
"@ c #6D6D6D",
"# c #909090",
"$ c #B0B0B0",
"% c #CFCFCF",
"& c #E8E8E8",
"* c #F4F4F4",
"= c #FAFAFA",
"- c None",
"---------------------------------------------",
"---------------------------------------------",
"---------------------------------------------",
"---------------------------------------------",
"---------------------------------------------",
"---------------------------------------------",
"---------------------------------------------",
"---------------------------------------------",
"---------------=-*-=-------------------------",
"-----------$#@@@#%*=-------%#@+@@#%----------",
"--------%@o       X@%-=-*#o        o@&-------",
"------&+            .+&%O .         ..#*-----",
"-----$X               #O               O&----",
"----$X              .$-*+               o&---",
"---%                #---&O               O*--",
"--&o              .+-----%X               +--",
"-=+      oo       o&------#   oX  o.       $-",
"-&X      $#       #-------*o  @%=&#%&$O   .O=",
"-@      o=*X      &=-------#   @-@  O*&X    %",
"=X     .@$-+     +---------%   +-@   #-@    @",
"%      .%o*$     #----------o  +-@   @=@    O",
"#      O# $-O   .$----------+  +-@   $&X     ",
"@     .#O +*@.  .&----------@  +-#O+#%o      ",
"@     o%   &&    &--&++OO#==#  +-$#$%-$X     ",
"@     @&%%&&-+   &--&##$$&--@. +-@   @-%    .",
"#     %o   O*$   %--=-------@. +-@    %-+    ",
"$    O$     %*X  $----------+  +-@    $-+   X",
"%.   $+     @*@  @---------=X  +-@    $=O   +",
"=O  o=o.   .o-%  o---------$   +-@.  O*$    #",
"-# @&*$+   o$=*%O %--------@  +$-%@@#&@    X&",
"-*oX   .    .   . O-------&.  O++O+Oo      @-",
"--#              ..$------+    .          o&-",
"--=+.              o&----$                $--",
"--=&o               O*--%X              .@---",
"----&O              XO*%o               #----",
"-----&+               #O              X$-----",
"------=$O          .O$-*#X.       ...@&------",
"--------*$@o     o+$=----*#+X     O#&=-------",
"------------&%$%*------------&%%&=-----------",
"--------------------------------=------------",
"---------------------------------------------",
"---------------------------------------------",
"---------------------------------------------",
"---------------------------------------------",
"---------------------------------------------"
]

math_ymin_to_zero = [
"30 30 20 1 ",
"  c gray5",
". c #3C3C3C",
"X c #2D5943",
"o c gray35",
"O c #6F6F6F",
"+ c #07A956",
"@ c #18AE61",
"# c #31B772",
"$ c #43BD7F",
"% c #56C48B",
"& c #6BCB9A",
"* c #76CFA2",
"= c #AAAAAA",
"- c #93D9B5",
"; c #A0DEBE",
": c #AFE3C9",
"> c #CFD0CF",
", c #C8EAD9",
"< c #D9F2E5",
"1 c None",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"1111111:%#,1111111111111<,1111",
"111111:+##@<111<%#;11111%@1111",
"11111<+%11@%11<@@%+-111-+:1111",
"11111%@111-+<1#@<1*+,1:+&11111",
"1111<+-1111+&&+,111#@%+$111111",
"1111*@11111-++;11111%#-1111111",
"1111@%111111,<1111111111111111",
"111,+X.......................1",
"1111:>>>>>>>>>>>>>>>>>>>>>>>>1",
"111111111111111111111111111111",
"1111>..<1111111111111111111111",
"1111.o.o1111111111111111111111",
"1111 =O.1111111111111111111111",
"111< =O.1111111111111111111111",
"1111 =oo1111111111111111111111",
"1111O  =1111111111111111111111",
"11111=>11111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111"
]

pick = [
"30 30 18 1 ",
"  c #050505",
". c #2B2B2B",
"X c #525252",
"o c #767676",
"O c #F8A13A",
"+ c #E4A152",
"@ c #F9B86B",
"# c #919191",
"$ c #B3A390",
"% c #B3B3B3",
"& c #C6BAAC",
"* c #FBC688",
"= c #F7D9B6",
"- c #FDE0BD",
"; c #CFCFCE",
": c #EAD7C0",
"> c #FDE8D0",
", c None",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,>,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,-@,>,,,,,,,,,,,,,,,,,",
",,,,,,,O*>*-O>,,,,,,,,,,,,,,,,",
",,,,,,,,*,,=>,,,,,,,,,,,,,,,,,",
",,,,,,@@>,;,*@>,,,,,,,,,,,,,,,",
",,,,,,>>,;,;::,,,,,,,,,,,,,,,,",
",,,,,,,>O%;;+>,,,,,,,,,,,,,,,,",
",,,,,,,@=$;.;%>,,,,,,,,,,,,,,,",
",,,,,,,,,$; .,%,,,,,,,,,,,,,,,",
",,,,,,,,>%%  .;;;,,,,,,,,,,,,,",
",,,,,,,,,%;   .;;>,,,,,,,,,,,,",
",,,,,,,,>%;    .;;,,,,,,,,,,,,",
",,,,,,,,,%;     .;;;,,,,,,,,,,",
",,,,,,,,;%;       ;;>,,,,,,,,,",
",,,,,,,,,%;       .;;;,,,,,,,,",
",,,,,,,,,%;        .;;;,,,,,,,",
",,,,,,,,;%;   . ;;;;;,,,,,,,,,",
",,,,,,,,,%;  %# X%#%;;;,,,,,,,",
",,,,,,,,,%; %#;  ;%>,,,,,,,,,,",
",,,,,,,,,%;;%##o X;,,,,,,,,,,,",
",,,,,,,,,;;%;;#;  ;;>,,,,,,,,,",
",,,,,,,,;;;;;,%#X X;;,,,,,,,,,",
",,,,,,,,,,,,,,;#%  ;;,,,,,,,,,",
",,,,,,,,,,,,,,>%;X#;;,,,,,,,,,",
",,,,,,,,,,,,,,,;%&%;>,,,,,,,,,",
",,,,,,,,,,,,,,,,;%;,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,"
]

next = [
"30 30 21 1 ",
"  c #012839",
". c #20353E",
"X c #0D3151",
"o c #1B3967",
"O c #243E6A",
"+ c #354349",
"@ c #27427A",
"# c #4A546D",
"$ c #687075",
"% c #354B8D",
"& c #576394",
"* c #495AA8",
"= c #5865B6",
"- c #5F6CC1",
"; c #6B75CC",
": c #7D8285",
"> c #7D83DC",
", c #9EA1B6",
"< c #9A9DE3",
"1 c #D6D6E9",
"2 c None",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222,12222222222222222222222",
"222222$.:222222222222222222222",
"222222$  +,2222222222222222222",
"222222$    $122222222222222222",
"222222$     +,2222222222222222",
"222222#     Xo#122222222222222",
"222222$    XXoo@,1222222222222",
"222222$     oO%%&=<22222222222",
"222222$   XXo@%%*==>2222222222",
"222222$   XXo@%**=-;;<22222222",
"222222$   Xo@@%**-;>><<1222222",
"222222$  XXo@%**=;;;;><<222222",
"222222$  XXo%%**=-;<;>12222222",
"222222$ XXo@%%**-;;>1222222222",
"222222$ XXo@%**=-;<12222222222",
"222222$ Xoo%%**=;1222222222222",
"222222$XXo@%%%-,22222222222222",
"222222$Xoo@%*,2222222222222222",
"222222$Xo@%&122222222222222222",
"222222$Xo#,2222222222222222222",
"222222&+&222222222222222222222",
"222222,22222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222"
]

shape_ellipse = [
"30 30 10 1 ",
"  c #F7941E",
". c #F79929",
"X c #F8A23B",
"o c #F9AE55",
"O c #FABA6C",
"+ c #FAC27E",
"@ c #FBCB92",
"# c #FCD7AB",
"$ c #FDE9D1",
"% c None",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%$$$$%%%%%%%%%%%%%",
"%%%%%%%%%#OX      XO@%%%%%%%%%",
"%%%%%%%O              O$%%%%%%",
"%%%%%@       .XX.      .#%%%%%",
"%%%%@    o@$%%%%%%$@o    @%%%%",
"%%%#   o$%%%%%%%%%%%%$o   #%%%",
"%%%.  @%%%%%%%%%%%%%%%%@  X%%%",
"%%#  @%%%%%%%%%%%%%%%%%%O  #%%",
"%%@..$%%%%%%%%%%%%%%%%%%%  @%%",
"%%@ .$%%%%%%%%%%%%%%%%%%$  @%%",
"%%#  +%%%%%%%%%%%%%%%%%%O  #%%",
"%%%X  @%%%%%%%%%%%%%%%%@  X%%%",
"%%%#   o$%%%%%%%%%%%%$o   #%%%",
"%%%%@    o@$%%%%%%$@o    @%%%%",
"%%%%%#       .oX.      .#%%%%%",
"%%%%%%$O              +$%%%%%%",
"%%%%%%%%%@OX      Xo#%%%%%%%%%",
"%%%%%%%%%%%%%$$$$%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
]

zoom_original = [
"30 30 24 1 ",
"  c #433539",
". c #5E5357",
"X c #B32F36",
"o c #ED1D25",
"O c #DA2932",
"+ c #E92B32",
"@ c #D03943",
"# c #EA3A41",
"$ c #A55D61",
"% c #EC4950",
"& c #D75F67",
"* c #787E80",
"= c #A87D82",
"- c #A49BA5",
"; c #B4AAAE",
": c #DB9298",
"> c #F7ACAF",
", c #BDBDC6",
"< c #A6D2E7",
"1 c #B6E2F4",
"2 c #D5D2D5",
"3 c #EED9DB",
"4 c #D0E9F4",
"5 c None",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"5555555:355555555555553>555555",
"555555:oo:--2555555555+o:55555",
"555555>ooO-*..;555555+oo>55555",
"555552;:oo+34- *5553%oo>555555",
"55554;21;oo#<5< -53%oo>5555555",
"5555;3411;Oo@<4- 2#oo>55555555",
"5555,44411-oo@14 +oo>555555555",
"5553344411<-oo+,Ooo>5555555555",
"555234441111;ooooo>55555555555",
"5553255444111:ooo$555555555555",
"5555;35444412#ooo+555555555555",
"5555;3543443+o+@oo%55555555555",
"55555-23533%oo$ $o+%3555555555",
"555553-,22+oo$...@oo%555555555",
"5555555;-+oo$.22. @oo%35555555",
"55555553#oo:35553- @oo&3555555",
"5555553%o+>5555555; Xoo%355555",
"555555%oo>5555555552.Xoo&33555",
"5555553+>555555555554$XO$;4555",
"5555555555555555555555; .;5555",
"555555555555555555555552=55555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555"
]

math_peak = [
"30 30 20 1 ",
"  c #131313",
". c #2C2C2C",
"X c #285840",
"o c #515251",
"O c #767676",
"+ c #0A964E",
"@ c #02A652",
"# c #32B773",
"$ c #42BD7E",
"% c #48BF82",
"& c #50C288",
"* c #7DD2A6",
"= c #909090",
"- c #90A198",
"; c #B1B2B2",
": c #94D6B4",
"> c #ACE1C6",
", c #CECECE",
"< c #D3F0E1",
"1 c None",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"11111111111111XX11111111111111",
"1111111111111;@@=1111111111111",
"1111111111111+@@+1111111111111",
"111111111111>@@@@:111111111111",
"111111111111+@@@@@<11111111111",
"111111111111o;%$;.111111111111",
"1111111111<OX1&%1 <11111111111",
"111111111-.O11%%1o;11111111111",
"111111111o;111%%1-O11O11111111",
"111111111o<111%%1,.1= O1111111",
"111111111o<111%%11.<o=.1111111",
"111111111o1111&%11OO.1 1111111",
"1111111<Oo1111%%11, O1.,111111",
"111111, O11111&%111111o,111111",
"111111o;111<::##::<111==111111",
"111111.11111#@@@@#1111,.,;1111",
"11111,o11111<@@+@<11111.. 1111",
"11111o;111111:@@*111111=o==111",
"1111;=11111111##1111111111.111",
"11111111111111<<11111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111"
]

plot_roi = [
"30 30 20 1 ",
"  c #0C0C0C",
". c #0C311D",
"X c #2E2F2F",
"o c #145031",
"O c #107843",
"+ c #505051",
"@ c #6F7070",
"# c #158C50",
"$ c #00A14B",
"% c #36B876",
"& c #51BA85",
"* c #78A690",
"= c #5FC792",
"- c #919394",
"; c #88AD9B",
": c #A7A9AC",
"> c #B7E4CC",
", c #CCD8D2",
"< c #DFF3E8",
"1 c None",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"11111111111111<111111111111111",
"1111111111111<  <1111111111111",
"11111111>1111@XX*111<<11111111",
"1111111<$>111X@@X111=%11111111",
"1111111<$>11< -- ,11=%11111111",
"1111111<$>11-X::X@11=%11111111",
"1111111<$>11X+::@X11=%11111111",
"1111111<$>:+ :::- <1=%11111111",
"1111111<$@ X-::::X:1=%11111111",
"1111111<$o@::::::++1&#<1111111",
"1111111<$o@::::::@ 1##@1111111",
"1111111<$o-::::::: ,O#X1111111",
"1111111<$.-:::::::X@o% <111111",
"1111111;$o::::::::@ #% ,111111",
"111111-X$*:::::::::;&%X:111111",
"111111X-$*::::::::::&%@@111111",
"11111< ,$;::::::::::&%:X::1111",
"11111:X<$*::::::::::&%1   ,111",
"11111X-<$;::::::::::&%1@X@+111",
"1111<@<<$*::::::::::&%11<<+111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111"
]

sliders_off = [
"30 30 24 1 ",
"  c #ED1D24",
". c #CF302C",
"X c #EA292F",
"o c #AE4D3C",
"O c #9F6D54",
"+ c #E75E60",
"@ c #179447",
"# c #08A450",
"$ c #32B26D",
"% c #4AA76B",
"& c #B88977",
"* c #50BE82",
"= c #5CC38C",
"- c #64C692",
"; c #7BCFA2",
": c #B6B5A0",
"> c #E7A6A3",
", c #89D1A9",
"< c #A4DDBE",
"1 c #AFE2C7",
"2 c #F3D9D7",
"3 c #C8EAD7",
"4 c #D4EFE1",
"5 c None",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"55555552&;-;;55555;;;;&5555555",
"5555533+ O$##33333###o.+335555",
"55553##@. >,###@###;> .###5555",
"55555433@. O#33344#o .$3445555",
"55555555<,. &55555+ .;<5555555",
"55555555555X >555+ +5555555555",
"555555<<<<35XX>5+ +4<<<<455555",
"555554####*42X + +2,####155555",
"55553##,4*$##@  .@###44##$5555",
"55555,#$$#%<<+   :<-#$$#-15555",
"555555==*=,5+ +2XX>4-===355555",
"55555555555+ +552XX>5555555555",
"5555555333+X+55553X >555555555",
"5555551#@o +5555,#@  :55555555",
"55553###+ o#$#$###3:. %@#$5555",
"55554,=. o#$;;;;=#-=@  &;,5555",
"5555553OO$$<5555<$$$*:X2555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555"
]

item_1dim = [
"30 30 12 1 ",
"  c #0135FF",
". c #1646FF",
"X c #2F5AFF",
"o c #3B63FF",
"O c #5074FF",
"+ c #6D8BFF",
"@ c #96ACFF",
"# c #A9BAFF",
"$ c #B9C7FF",
"% c #CDD7FF",
"& c #DCE3FF",
"* c None",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"********&#@@%*****************",
"******&+     +************+.@*",
"*****$.       X&*********$   *",
"****@    .OX   o*********X  O*",
"***#   .@***+   +*******@   %*",
"**$   .%*****+   @*****&   O**",
"*&.  .&*******o   %****O  .&**",
"*+   %********&.  .%**+   @***",
"*#  $**********%   .@O   O****",
"**%&************#       X&****",
"*****************#     O******",
"******************&@OO#*******",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************"
]

compare_mode_a = [
"30 30 15 1 ",
"  c #020201",
". c #2C1E0E",
"X c #25221E",
"o c #4E3619",
"O c #5D411E",
"+ c #704E24",
"@ c #444342",
"# c #865D2B",
"$ c #91642E",
"% c #AD7837",
"& c #BB823B",
"* c #CE8F42",
"= c #E29D48",
"- c #F8AC4F",
"; c None",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;@XXXXXXXXXXXXXXXXXXXXXXXX@;;",
";;Xo###############$######oX;;",
";;X#----------------------#X;;",
";;X#----------------------#X;;",
";;X#--------+oooo+--------#X;;",
";;X#-------=      =-------#X;;",
";;X#-------#      #-------+X;;",
";;X#-------.      .-------$X;;",
";;X#------*        *------#X;;",
";;X#------+   O+   +------#X;;",
";;X#------    &%    ------#X;;",
";;X#-----%    --    %-----#X;;",
";;X#-----o   +--+   o-----#X;;",
";;X#-----    &--&    =----#X;;",
";;X#----$   .=---.   $----#X;;",
";;X#----.    o.oo    .----#X;;",
";;X#---*              *---#X;;",
";;X#---+              +---#X;;",
";;X#---.   o######o   .---#X;;",
";;X#--%    *------*    %--#X;;",
";;X#--o   .--------.   o--#X;;",
";;X#--+oOo$--------%oooO--#X;;",
";;X#----------------------#X;;",
";;X#----------------------#X;;",
";;Xo##$+##################oX;;",
";;@XXXXXXXXXXXXXXXXXXXXXXXX@;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
]

cube = [
"30 30 16 1 ",
"  c #181108",
". c #21180C",
"X c #372816",
"o c #4B3418",
"O c #AE6B1A",
"+ c #B07834",
"@ c #CD7C1B",
"# c #C17F31",
"$ c #D18933",
"% c #EC9C3B",
"& c #E59B41",
"* c #F9A847",
"= c #989898",
"- c #B0B0B0",
"; c #CDCDCD",
": c None",
":::::::::::::::;::::;:::;:::;:",
"::::::::::;.   .        .    :",
":::::::::;XO%*************OXX:",
"::::::::;X&$%************+X&X:",
":::::::;X%%$************+X&*X:",
"::::::;X$**@%**********+X&**X:",
":::::;X&***$%*********+o&***X;",
"::::;X&****$*********+X&****X:",
":::;X$*****$%*******+X&*****o:",
"::;X&*****%$%******+o&******X;",
":;X$*******$%*****+o&*******X:",
";                 X&********o;",
": $#$$#$$$$O$$$$$+o*********X:",
":.*********$%****$o*********.:",
":.*********$&****$o*********X:",
":.*********$&****$o*********o:",
": *********$%%***$o*********o:",
": *********$%%%%%$o%%%%%&&%%.:",
":.*********@@@@@@OX$@$$@@@@O ;",
";.*******%$%****%$o*%**%**$X;:",
":.*******$%******$o******$X;::",
":.******$%%******$o*****&X;:::",
": *****$$********$o****%o;::::",
": ****$&*********$o**%%o-:::::",
":.***$%**********$o**&o-::::::",
";.**$%%**********$o**o-:::::::",
":.*$$**&*********$o*o=::::::::",
":.$$***&*******%*&oo=:::::::::",
":                  =::::::::::",
":::;:;:::::;;:::::::::::::::::"
]

_d_plane_normal_z = [
"30 30 21 1 ",
"  c #10100B",
". c #201A15",
"X c #503B23",
"o c #54531B",
"O c #716F6A",
"+ c red",
"@ c #966629",
"# c #F2791D",
"$ c #E5684F",
"% c #2C962C",
"& c #DC9A2A",
"* c #F69332",
"= c #D38246",
"- c #E89B43",
"; c #F9A847",
": c #1414F9",
"> c #848382",
", c #BBBBBC",
"< c #BFB2C7",
"1 c #DBD5E1",
"2 c None",
"22222222221,,22222222222222222",
"2222222222,%%22222222222222222",
"22222222221%%22222222222222222",
"2222222222,%>22222222222222222",
"2222222222,%%22222222222222222",
"2222222222,%>22222222222222222",
"222222OOOOO XOOOOOOOOOO>222222",
"222222 @@@@o@@@@@@@@@@@.222222",
"222222 ;&;&&&;;;;;;;;;-.222222",
"222222 ;;;&&&&;;;;;;;;;.222222",
"222222 ;;;-&&;;;;;;;;;-.222222",
"222222 ;;;;&&;;;;;;;;;-.222222",
"222222 ;;;&&&;;;;;;;;;-.222222",
"222222 -;-&&&&;;;;;;;;-.222222",
"222222 ;;;;&&;;;;;;;;;-.222222",
"222222 ;;;&&&;;;;;;;;;-.222222",
"222222 ;;;-&&-*;;;**;**.222222",
"222222 ;;;-&#&********&.$$$$$1",
"222222 ;;;==$####*#*### +++++$",
"222222 ;;-==&;*;*******.111112",
"222222 --=$;;;;;;;;;;;*.222222",
"222222 *==-;;;;;;;;;;;-.222222",
"222222 $=-;;;;-;;;;;;;-.222222",
"22222< .XXXXXXXXXXXXXXX.222222",
"22221::,,,,,,,,,,,,,,,,,222222",
"2221::122222222222222222222222",
"22<::1222222222222222222222222",
"21::12222222222222222222222222",
"1::122222222222222222222222222",
"1<2222222222222222222222222222"
]

zoom_out = [
"30 30 23 1 ",
"  c #323132",
". c #4D3940",
"X c #534C51",
"o c #68565C",
"O c #716B6F",
"+ c #ED1C24",
"@ c #EF333B",
"# c #85777C",
"$ c #F47176",
"% c #78D3F5",
"& c #948E91",
"* c #A19DA2",
"= c #B4AAAD",
"- c #CCAFB1",
"; c #C8BCC2",
": c #90D9F5",
"> c #AAD8EA",
", c #B5E1F4",
"< c #D4CED1",
"1 c #FCD7D8",
"2 c #E5DDE3",
"3 c #CFE8F4",
"4 c None",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"44444442;==<444444444444444444",
"444442=**&OOo=4444-$$$$$$$-444",
"44442*;>334,*X#444+++++++++444",
"4444*<,,::::4> &44@+++++++@444",
"444=23,,::%%%4= 24111111111444",
"444=23,,,:::%,3 *4444444444444",
"4442233,,::::,:Xo4444444444444",
"44222333,,:,,,,OX4444444444444",
"444<4333,3,,,,,Oo4444444444444",
"444=2443333333, *4444444444444",
"444=2243433333& <2444444444444",
"4444*<4234234= O=<144444444444",
"44442*;<244<#XoX#*;24444444444",
"444444=&&&OOO=<X.#&-2244444444",
"44444444<;<<4444#.o&=<24444444",
"44444444444444444*.o#&;1444444",
"444444444444444444<o.#&-<24444",
"44444444444444444442#.o&=24444",
"444444444444444444444*.o=44444",
"4444444444444444444444<O444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444444444444444444444444"
]

add_shape_vertical = [
"30 30 15 1 ",
"  c #09A957",
". c #1CB164",
"X c #F7941E",
"o c #F79A2B",
"O c #F8A847",
"+ c #FAB96D",
"@ c #55C38B",
"# c #6CCC9A",
"$ c #92D9B5",
"% c #FBC688",
"& c #B9E6CF",
"* c #CFEFDE",
"= c #FEEEDB",
"- c #D7F1E4",
"; c None",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;=OO%;;;;;;;;;;;;;",
";;;;;;;;;;;;;=XX+;;;;;;;;;;;;;",
";;;;;;;;;;;;;=XX+;;;;;;;;;;;;;",
";;;;;;;;;;;;;=XX+;;;;;;;;;;;;;",
";;;;;;;;;;;;;=XX+;;;;;;;;;;;;;",
";;;;;;;;;;;;;=XX+;;;;;;;;;;;;;",
";;;;;;;;;;;;;=XX+;;;;;;;;;;;;;",
";;;;;;;;;;;;;=XX+;;;;;;;;;;;;;",
";;;;;;;;;;;;;=XX+;;;;;;;;;;;;;",
";;;;;;;;;;;;;=XX+;;;;;;;;;;;;;",
";;;;;;;;;;;;;=XX+;;;;;;;;;;;;;",
";;;;;;;;;;;;;=XX+;;;;;;&*;;;;;",
";;;;;;;;;;;;;=XX+;;;;;& .;;;;;",
";;;;;;;;;;;;;=XX+;;;;;& .;;;;;",
";;;;;;;;;;;;;=XX+;;;;;& .;;;;;",
";;;;;;;;;;;;;=XX+;;#        *;",
";;;;;;;;;;;;;=XX+;;@     .  -;",
";;;;;;;;;;;;;=XX+;;-**$ .***;;",
";;;;;;;;;;;;;=oo+;;;;;& .;;;;;",
";;;;;;;;;;;;;;;;;;;;;;& .;;;;;",
";;;;;;;;;;;;;;;;;;;;;;-#$;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
]

item_none = [
"30 30 10 1 ",
"  c #0034FF",
". c #1545FF",
"X c #2450FF",
"o c #456BFF",
"O c #6D8CFF",
"+ c #819BFF",
"@ c #8CA3FF",
"# c #B7C6FF",
"$ c #CDD7FF",
"% c None",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%@$%%%%%%%",
"%%%%%%%%%%%%$@OO@$%%@ .%%%%%%%",
"%%%%%%%%%%$o      oO   @%%%%%%",
"%%%%%%%%%#.           +%%%%%%%",
"%%%%%%%%$   X+$$@    O%%%%%%%%",
"%%%%%%%%o  o%%%%+    o%%%%%%%%",
"%%%%%%%$  .%%%%+   .  $%%%%%%%",
"%%%%%%%@  @%%%+   +@  @%%%%%%%",
"%%%%%%%O  #%%@   +%#  O%%%%%%%",
"%%%%%%%O  $%+   +%%$  O%%%%%%%",
"%%%%%%%@  @+   +%%%+  @%%%%%%%",
"%%%%%%%$  .   +%%%%.  $%%%%%%%",
"%%%%%%%%o    O%%%%o  o%%%%%%%%",
"%%%%%%%%O   .@$#@X  .$%%%%%%%%",
"%%%%%%%@           .#%%%%%%%%%",
"%%%%%%@   Oo      o$%%%%%%%%%%",
"%%%%%%%X +%%$@OO@$%%%%%%%%%%%%",
"%%%%%%%$@%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
]

document_save = [
"30 30 12 1 ",
"  c black",
". c #0D0D0D",
"X c #1A1A1A",
"o c #2C2C2C",
"O c #4D4D4D",
"+ c #6C6C6C",
"@ c #727272",
"# c #939393",
"$ c #B1B1B1",
"% c #CCCCCC",
"& c #DDDDDD",
"* c None",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"*****$#$&&&&&&$@$&&$#%********",
"*****X @******@ #**# .%*******",
"*****X +******@ #**#  .%******",
"*****X +******@ #**#.  .%*****",
"*****X +******$+$**#    .&****",
"*****X +&&&&&&&&&&&#     O****",
"*****X                   O****",
"*****X                   O****",
"*****X                   O****",
"*****X                   O****",
"*****X                   o****",
"*****X O%%%%%%%%%%%%%%%@ O****",
"*****X @***************# o****",
"*****X @***************# O****",
"*****X @***************# O****",
"*****X @***************# O****",
"*****X +***************# o****",
"*****X @***************# O****",
"*****X XOOO+OOOOOOOOO+Oo O****",
"*****X          .        O****",
"*****X                   O****",
"*****&%%%%%%%%%%%%%%%%%%%&****",
"******************************",
"******************************",
"******************************"
]

math_peak_search = [
"30 30 23 1 ",
"  c #171717",
". c #2B2B2B",
"X c #145634",
"o c #346049",
"O c #4C4C4C",
"+ c #5E7266",
"@ c #6D6E6D",
"# c #229F5F",
"$ c #05A553",
"% c #349A66",
"& c #509572",
"* c #579E7A",
"= c #63A784",
"- c #6DB18E",
"; c #919392",
": c #90A89C",
"> c #ACACAC",
", c #8FC4A9",
"< c #B1C7BB",
"1 c #B9CBC2",
"2 c #D1D3D2",
"3 c #DEE1E0",
"4 c None",
"444444444444444444444444444444",
"444444444443213334444444444444",
"444444444<%$$$$$=1344444444444",
"44444444-$#*&=*%$$-24444444444",
"4444444,$+;;;>;;;%$*2344444444",
"4444443#%;>233321:&$:344444444",
"4444443$&:2343;432>#%234444444",
"4444442$&>244. @442%#>34444444",
"4444442*$;23>O4 343##>24444444",
"4444442=$$-2.>4O;3-$=>34444444",
"44443<%$$$$%X>2:o%$&:244444444",
"4441=$$$o+&$$$$$$#&;>344444444",
"43-$$$o@;;>Oo=*&O+;>3344444444",
"4*$$%@;:122 ;>>>;O223213344444",
"4<**;;1234@O33333.,%$$$$%,3444",
"43<<12342O.344443$$#****#$*234",
"4333444+.:444444*$o;:>:>;&$*34",
"4444443 44444441$%.>22222>%$>3",
"4444443O4444444-$;.233 O32:$;2",
"4444443O4444443=#;O>4>OO23,$=2",
"4444443@4444444-$;;@4@;;@3-$;2",
"4444442@44444431$%> 4O1>o<$%;2",
"444444@>44444442-$#o@ 31X$#;>3",
"44441+.4444444431=#$$$#$$$+;24",
"444;O>444444444432;;&%&&$$#;34",
"4443444444444444432>>>;;.$$*23",
"444444444444444444433222;%$$:3",
"4444444444444444444443443>#$#<",
"44444444444444444444444442;$$*",
"444444444444444444444444432*$%"
]

camera = [
"30 30 14 1 ",
"  c black",
". c #010101",
"X c #0C0C0C",
"o c gray11",
"O c #2E2E2E",
"+ c gray28",
"@ c #555555",
"# c #676767",
"$ c #777777",
"% c #878787",
"& c #D1D1D1",
"* c #E9E9E9",
"= c #F3F3F3",
"- c None",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"---*#@@@@@@@@@@@#&------------",
"---O.            O-----&%OO---",
"---X              =-&%O   X---",
"---X              =%      X---",
"---X              =$      X---",
"---X              =$      X---",
"---X              =$      X---",
"---X              =$      X---",
"---X              =*$O    X---",
"---X              =---&$o o---",
"---+             O------=&&---",
"---*%###########$*------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------"
]

image_select_add = [
"30 30 24 1 ",
"  c #040807",
". c #14242C",
"X c #262928",
"o c #14502A",
"O c #1F6A33",
"+ c #67692C",
"@ c #4B3349",
"# c #13625C",
"$ c #A02E24",
"% c #B35C3C",
"& c #996328",
"* c #28883C",
"= c #698E39",
"- c #178C46",
"; c #289655",
": c #32AC4C",
"> c #55A84D",
", c #9B9C32",
"< c #BBAB37",
"1 c #454C86",
"2 c #28A38D",
"3 c #BCB4A0",
"4 c #DADAD4",
"5 c None",
"5X          oo              55",
"5X        X>>:o    X@       55",
"5X       o>>>>:X  +553      55",
"5X      o*>><>=oO 3554      55",
"5X      O*>,,=++$&3554#.    55",
"5X      *>====++$%3554#@    55",
"5X      O*==+&+$$$3554o##   55",
"5X     .OO++&+X$$$3554O#2.  55",
"5X    .oo+=++@$$$$3554+O22# 55",
"5X   .#oo++&&%$$$$3555+;;2#X55",
"5X  .#ooO+<5555555555555555554",
"5X  ##Xo,,45555555555555555555",
"5X  ooo+,+35555555555555555554",
"5X .#oooO++&%11%+$3555==>1>113",
"5. .#ooo++,+$$$$$$3554oO**O.34",
"5X .oooo+,+&&%&$%$3554oO:>:.55",
"5X  ooO=,=,<&&%$%%3554O*:>2.55",
"5X  #-*==,,&<&%<%<3554o>::2 55",
"5X oO-O===<,<<%%<&3554o*>:@ 55",
"5X O--O*,=<,&<,<<<3554o:>2@ 55",
"5.oO---*===<,,,==>>553O:21X 55",
"5o#--O-O*======::-:33O*:1$  55",
"5X###OOO--***:--:-::--*:1X  55",
"5X.###OoOO*--::-::-::-;@@   55",
"5X ##2###--:;:>O::*-;11@    55",
"5X  .#2#;2-::-::-:;-#@@     55",
"5X    ##2;;->;:;#O#1@       55",
"5X      ##2#2##;.@          55",
"5X      . . .               55",
"5X                          55"
]

image_select_brush = [
"30 30 24 1 ",
"  c #2A582C",
". c #6A6A2C",
"X c #484C49",
"o c #9E2820",
"O c #9A6226",
"+ c #C75237",
"@ c #168A3F",
"# c #6C8E38",
"$ c #1F974B",
"% c #30B04B",
"& c #54AA4D",
"* c #A49D31",
"= c #B2A54C",
"- c #6DA992",
"; c #848686",
": c #9DACA6",
"> c #8BB4AE",
", c #91C9AF",
"< c #A9D4A9",
"1 c #CEC3B1",
"2 c #A8D6C8",
"3 c #CED0CF",
"4 c #D8E4DC",
"5 c None",
"553333313333333333333333333355",
"55;;;;;;;;;;<<:<3131;;;;;;;;55",
"55;;;X;;;;,<14551:155;;;X;;;55",
"54;;;;;;;;<454<&    34;;;;;;55",
"55;;;;;;;,55<*# ..O*<5>:;;;;55",
"55;;;;;;-45=*#...o*OO52>;;;;55",
"55;;;X;;15&#...Ooo+oO53,:;;;55",
"55;;;;;:5, .*. ooooo15<<>>;;55",
"54;;;;;45  #..ooooo+531<42>;55",
"54;;;>>5- ..OOoooo+53155554;55",
"55;;;>35  ..OOoooo44155=$,5>55",
"55;;;>5: ****Oooo15154=#$%5455",
"55;;;25X.#..OOoo+5355+*&%%,555",
"55;;-34   ..OOoo4555O*=%%%2455",
"55;;:5>   O*OO++451++*&%%%2455",
"54;;:5$  =:*OO+O+++***&%%%4455",
"55;;35  #551*O++O+****%%%%4455",
"55;;4,@$355=*=O++****&@%&%-555",
"55;:5-$5554*O*******&%%%%&>555",
"55;:5>5535=********&@&&%&&5355",
"55>>554>45##*#**#<4&@%&%$25;55",
"55;>>,>>42&&&&-4554%%@%&-51;55",
"55;>>>--44&&<55445-&%$%%53;;55",
"55;;>>,,255544<,25%@&%$45;;;55",
"55;;;;;>>>2,2>,,44%@X$35;;;;55",
"55;;;;;>2>2,>2,<5,%@X14:;;;;55",
"55;;;;;;;->>:>;>5;XX15:;;;;;55",
"54;;;;;;;;;-;;;;43;45:;;;;;;55",
"55;;;;;;;;;;;;;;;553;;;;;;;;55",
"55:;;;;::;:;:;1::;:;:;:;;;;;55"
]

axis = [
"30 30 15 1 ",
"  c #050505",
". c #171717",
"X c #2D2D2D",
"o c #525252",
"O c #666666",
"+ c #767676",
"@ c #7D7D7D",
"# c #8A8A8A",
"$ c #999999",
"% c #AEAEAE",
"& c #CFCFCF",
"* c #E8E8E8",
"= c #F3F3F3",
"- c gray98",
"; c None",
";-;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";@;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
"% =;;;;;;;;;;;;;;;;;;;;;;;;;;;",
"o $;;;;;;;;;;;;;;;;;;;;;;;;;;;",
". X;;;;;;;;;;;;;;;;;;;;;;;;;;;",
"   *;;;;;;;;;;;;;;;;;;;;;;;;;;",
"$.$%;;;;;;;;;;;;;;;;;;;;;;;;;;",
"*.;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
"=.;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
"=.;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
"=.;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
"-.;;;;;;;;;;;;;;;;;*#=;;;;;;;;",
"-.;;;;;;;;;;;;;;;;;&.&;;;;;;;;",
"=.;;;-;;;;;;;;;;;;;;-;;;;;;;;;",
"=.;;*&=;;;;;;;;;;;-=&;;;;*&==;",
"-.*o$%X%-=O.o&*O.#&o ;;;@O%OX*",
"-.+o=;&X;;;@o-;+&;;* ;;*X;;;O&",
"-.*&;;= ;;;-o#$%;;;* ;-=.%;;*=",
"-.=$O+O ;;;;*.+;;;;= ;;;%XX#=;",
";.OO=;- ;;;;&O.*;;;= ;;==-&o.*",
";  =;;= ;;;*O;$X;;-= -;%%-;;O$",
";..%;;#.=;*o=;;oO-;* =;%X=;;O%",
";.%ooO%+o%oo%;&ooo&ooO&&#OOO+;",
"; ;;;;;;;;;;;;;;;;;;=;;=;;-;;;",
"; ;;;;;;;;;;;;;;;;;;;;;&X#*;;;",
";.$$$$$$$$$$$$$$$$$$$$$$   X#=",
";+++++++++++++++++++++++   .+*",
";;;;;;;;;;;;;;;;;;;;;;;&.+&-;;",
";;;;;;;;;;;;;;;;;;;;;;;*;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
]

stats_whole_data = [
"30 30 12 1 ",
"  c #F7941E",
". c #F79726",
"X c #F8A23B",
"o c #F9AC51",
"O c #F7B76A",
"+ c #DEBF99",
"@ c #FBCC94",
"# c #D9C7B1",
"$ c #FCD6A9",
"% c #D8D8D8",
"& c #FDE9D2",
"* c None",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"*******&%******%***%%*********",
"*******%%%%%%%%%%%%%%%%%*&$&**",
"*******%**************%**X  &*",
"*******%**************%*o   &*",
"*******%**************%o   O**",
"*******#**************O   o***",
"*******%*************@   X****",
"*******%************$   X&****",
"*******+XO&********$   .&*****",
"******&   .$******&.  .&******",
"******o    .o&***&.   +*******",
"*****O        $*&o   $%*******",
"****@   O&o    oo   @*%*******",
"***&   X***@       O**%*******",
"***X  .#****&o    o***%*******",
"**O   $%******@. o****%&******",
"*&   O*%*******&$*****%*******",
"*&  o&*%**************%*******",
"**&$&**%%%%%%%%%%%%%%%%*******",
"*********%****%**%****%*******",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************"
]

shape_horizontal = [
"30 30 7 1 ",
"  c #F7941E",
". c #F79929",
"X c #FCD3A3",
"o c #FCD6A9",
"O c #FDDFBC",
"+ c #FEF2E5",
"@ c None",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@oXXXXXXXXXXXXXXXXXXXX+@@@",
"@@@@@.                    O@@@",
"@@@@@.                    O@@@",
"@@@@@oXXXXXXXXXXXXXXXXXXXX+@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
]

stats_active_items = [
"30 30 11 1 ",
"  c #F7941E",
". c #F79A2A",
"X c #F8A139",
"o c #F9AB4E",
"O c #FABA6E",
"+ c #FAC07B",
"@ c #FBC98E",
"# c #FCD9AF",
"$ c #FDE0BF",
"% c #FDE8CF",
"& c None",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&$&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&$&&&",
"&&&&&&&&&&&&&&&&&&&&&&&%$&&&&&",
"&&&&&&&&&&&&&&&&&&&&$&$%$&&&&&",
"&&&&&&&&&&&&&&&&&&&$&$&&&&&&&&",
"&&&&&&%&%%&%&&&&&&$&$&&&&&&&&&",
"&&&&$&$&&%&$&$&$&%&$&&&&$. #&&",
"&&&$&$&&&&%&$&&&%%&&&&&%.  +&&",
"&&&&&&&&&&&&&$#&&&&&&&&.  .%&&",
"&&&&&&&&&&&&&&&&&&&&&&.  .%&&&",
"&&&&&&&&&&&&&&&&&&&&&o   #&&&&",
"&&&&&&&&&&&&&&&&&&&&O   @&&&&&",
"&&&&&&&&o.#&&&&&&&&+   @&&&&&&",
"&&&&&&&o   o&&&&&&@   O&&&&&&&",
"&&&&&&+.    .#&&&#   o&&&$&&&&",
"&&&&&#   .    O&#   X&&&&%$&&&",
"&&&&&.  X&@    ..  .$&&&%&&&&&",
"&&&&X  .&&&&o.    .&&&&$%&&&&&",
"&&&+   $&&&&&@    #&&&$&&&&&&&",
"&&#   @&&&&&&&&X.@&&&##&&&&&&&",
"&&O  o&&&&&&&&&&&&&$&#&&&&&&&&",
"&&%Xo&&&$&#&$&&&&&$&$&&&&&&&&&",
"&&&&&&$&$$&$&$&&##&#&&&&&&&&&&",
"&&&&$&&$&&&&$&&#&&$&&&&&&&&&&&",
"&&&%&%%&&&&&&&&&&#&&&&&&&&&&&&",
"&&&&%&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&"
]

colorbar = [
"30 30 19 1 ",
"  c #191919",
". c #303030",
"X c #4B3010",
"o c #515151",
"O c #727272",
"+ c #905B1B",
"@ c #D48B36",
"# c #EB9833",
"$ c #F3A13E",
"% c #E29A45",
"& c #F0A852",
"* c #F8B76A",
"= c #8E8E8E",
"- c #AFAFAF",
"; c #EDBC82",
": c #EECAA0",
"> c #D0D0D0",
", c #FDE9D1",
"< c None",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<,:******:<<<<<<<<<<<<",
"<<<<<<<<<&;::>:::*&<<<<<<<<<<<",
"<<<<<<<<,&>>>>,>>>&*&,<<<<<<<<",
"<<<<<<<<,&>>>>>>>>$,,<<<<<<<<<",
"<<<<<<<<,&>>>>>>>-$,<<<<<<<<<<",
"<<<<<<<<,&>--->->-$<<<<<<<<<<<",
"<<<<<<<<,%--------#,<<<<<<<<<<",
"<<<<<<<<,%--------#<<<<<<<<<<<",
"<<<<<<<<,%--=--=--$,<<<<<<<<<<",
"<<<<<<<<,%====-===$&$,<<<<<<<<",
"<<<<<<<<,%========#,<<<<<<<<<<",
"<<<<<<<<,%O===O===#<<<<<<<<<<<",
"<<<<<<<<,%=OOOO=OO#<<<<<<<<<<<",
"<<<<<<<<,%OOOOOOOO#,<<<<<<<<<<",
"<<<<<<<<,@OOOoOOoO#<<<<<<<<<<<",
"<<<<<<<<,@oOoOOoOo#,<<<<<<<<<<",
"<<<<<<<<,@oooooooo@&#,<<<<<<<<",
"<<<<<<<<,@oooooooo#,<<<<<<<<<<",
"<<<<<<<<,@.o.o.oo.#<<<<<<<<<<<",
"<<<<<<<<,@...o....#,<<<<<<<<<<",
"<<<<<<<<,@........@<<<<<<<<<<<",
"<<<<<<<<,@. ... ..#,<<<<<<<<<<",
"<<<<<<<<,@        @,,<<<<<<<<<",
"<<<<<<<<,@        #&&,<<<<<<<<",
"<<<<<<<<<#+X.XXXX+$<<<<<<<<<<<",
"<<<<<<<<<<;%&&&&&;<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<"
]

shape_rectangle = [
"30 30 16 1 ",
"  c #F7941E",
". c #F79929",
"X c #F89D31",
"o c #F8A23C",
"O c #F9B360",
"+ c #FABA6D",
"@ c #FABA6E",
"# c #FBCD97",
"$ c #FBD09C",
"% c #FCD9B0",
"& c #FDE0BD",
"* c #FEEDD8",
"= c #FEEDD9",
"- c #FEEEDC",
"; c #FEF4E7",
": c None",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::&@@@@@@@@@@@@@@@@@@@@@@;::",
"::::#                      =::",
"::::#                      =::",
"::::#  #****************O  =::",
"::::#  %::::::::::::::::+  =::",
"::::#  %::::::::::::::::+  =::",
"::::#  %::::::::::::::::+  =::",
"::::#  %::::::::::::::::+  =::",
"::::#  %::::::::::::::::+  =::",
"::::#  %::::::::::::::::+  =::",
"::::#  %::::::::::::::::+  =::",
"::::#  %::::::::::::::::+  =::",
"::::#  Xoooooooooooooooo.  =::",
"::::#                      =::",
"::::$......................-::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::"
]

add_shape_point = [
"30 30 13 1 ",
"  c #09A957",
". c #1CB164",
"X c #F7941E",
"o c #F9AD52",
"O c #FAB96D",
"+ c #55C38B",
"@ c #6CCC9A",
"# c #92D9B5",
"$ c #FCD5A7",
"% c #B9E6CF",
"& c #CFEFDE",
"* c #D7F1E4",
"= c None",
"==============================",
"==============================",
"==============================",
"==============================",
"==============================",
"==============================",
"==============================",
"=============$oo$=============",
"=============$XX$=============",
"=============$XX$=============",
"=============$XX$=============",
"=============$XX$=============",
"=============$XX$=============",
"=======$$$$$$OXXO$$$$$$=======",
"=======oXXXXXXXXXXXXXXo=======",
"=======oXXXXXXXXXXXXXXo=======",
"=======$$$$$$OXXo$$$$$$=======",
"=============$XX$=============",
"=============$XX$=====*&&=====",
"=============$XX$=====% .=====",
"=============$XX$=====% .=====",
"=============$XX$=====% .=====",
"=============$oo$==@        *=",
"===================+     .  &=",
"===================*&&# .&&&==",
"======================% .=====",
"======================% .=====",
"======================*@#=====",
"==============================",
"=============================="
]

compare_align_auto = [
"30 30 20 1 ",
"  c #070705",
". c #221E0F",
"X c #2A2D11",
"o c #4D4D38",
"O c #6D4D26",
"+ c #586724",
"@ c #5F6626",
"# c #986B36",
"$ c #9D6F37",
"% c #748830",
"& c #8BA43A",
"* c #AA9648",
"= c #D09349",
"- c #F6AD57",
"; c #B3D34A",
": c #D3F857",
"> c #939393",
", c #BEBEBE",
"< c gray76",
"1 c None",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"11<<<,,,,,,,,,,,,,,,,,,,,11111",
"11                       ,1111",
"11 #--=--=-----=-----=-= ,1111",
"11.#-----------XO$------ ,1111",
"11.#-----=####$ .  O*--- ,1111",
"11 #-----X    ..:;%X .O$ ,1111",
"11 $-----      @:;;:;%X  o,111",
"11.*----#      ;:+  @;:;%.  *1",
"11 $----.     .::     X:::;.o1",
"11.#---=   OO @:&  ;;X X::; ,1",
"11 #---O   =# ;:+  ;:+ .::% 11",
"11 $---   .-O.::    .  +::.>11",
"11 #--*   O-.@:&  %+  %::; <11",
"11.#--X   == ;:+ .::% X::%.111",
"11 #-=    O..::  X;:+  ::Xo111",
"11.#-#      +::@.     +:; <111",
"11.#-.       .@;:;%X.+::%.1111",
"11 #=   .*$=#o.  +;:::::.o1111",
"11 #O   #------O   .+;:; >1111",
"11.#    --------      XX ,1111",
"11 $--=---------=----=O. ,1111",
"11.$-------------------- ,1111",
"11 O$$$$#$$$$#######$### ,1111",
"11.   . . .. .  . .  .   ,1111",
"111111111111111111111111111111",
"111111111111111111111111111111"
]

edit_copy = [
"30 30 24 1 ",
"  c #523A1D",
". c #515052",
"X c #6C665D",
"o c #6F7071",
"O c #A36923",
"+ c #A0784A",
"@ c #F6931E",
"# c #DE8924",
"$ c #F29930",
"% c #B99467",
"& c #D09957",
"* c #F4A74D",
"= c #F1BA77",
"- c #7F8081",
"; c #8F908F",
": c #ABA299",
"> c #ADAEAE",
", c #CFB494",
"< c #E0CAAF",
"1 c #F5D6B1",
"2 c #BEC0C1",
"3 c #D1D2D3",
"4 c #EFE0CE",
"5 c None",
"555555555555555555555555555555",
"555555545555554555555555555555",
"551$@@@$@@@@@@@@@@@15555555555",
"55*@******$*******@=5555555555",
"55*@45535555554551@=5555555555",
"55*@455223343<>254@=5555555555",
"55*@45oX.....oo251@=5555555555",
"55$@3553354$@@@$@@@@@@@@@@$455",
"55#@253533=#===%,,,==,,==,$=55",
"53#@,3-...O@33333333333334$=55",
"52##&33335<@332>>>>>>:;>33$=55",
"53O$$23223<@32oX.o.oXo-333$=55",
"53+@@,--;41@33333333333333$=55",
"53O#$$3455=@23333333333333*=55",
"54+#=*&o-o+@=2-XX.....X333$=55",
"55OO@5*&--%#1<-;;;>;>:2334$=55",
"55& @451*,=O15323333333333*=55",
"55#OO*5551=*155,X333333333$=55",
"55*OX#1555555555<333333333$=55",
"55*#-+$5555555555>;;;:>334$=55",
"55*#%XO*5555555555;....>33*=55",
"55=@#O O&455555555>2332343$=55",
"555=*&+  O#=55553o;2333333$=55",
"5555554>-.  <552.o;2333333$=55",
"555555533>X <5,..;23333333$=55",
"5555555553&O1% X;>2<3<<3<<$=55",
"5555555555<OO OO#@@@$@@@@@$155",
"55555555555,%-,,11111111111555",
"555555555554345555555555555555",
"555555555555555555555555555555"
]

draw_rubber = [
"30 30 14 1 ",
"  c #111111",
". c #272727",
"X c #393939",
"o c #505050",
"O c #666666",
"+ c #787878",
"@ c #8F8F8F",
"# c #B0B0B0",
"$ c #C8C8C8",
"% c #D9D9D9",
"& c #E8E8E8",
"* c #F4F4F4",
"= c #FAFAFA",
"- c None",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------&@----------",
"-----------------*ooO=--------",
"-----------------o#$OX*-------",
"----------------O@$#@O.&------",
"---------------++%#@@OX.%-----",
"--------------@O&##@Oo.  $----",
"-------------#o&$#@+o.  .%----",
"------------$X&$#@+oX.  $-----",
"-----------&X%%#@+OX.  #------",
"----------&X%%##@Oo.  @-------",
"---------*o#&##@+oX  O--------",
"--------=o#&$#@OoX  o---------",
"--------#oO$#@+oX. X=---------",
"------=$@*OX@@Oo. .*----------",
"------%@--=O.ooX .&-----------",
"------O*----@..  %------------",
"------$@=----@..$-------------",
"-------%+=---*+#--------------",
"--------&+@@@+&---------------",
"---------=*-------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------"
]

shape_vertical = [
"30 30 10 1 ",
"  c #F7941E",
". c #F79A2B",
"X c #F8A847",
"o c #FAB96C",
"O c #FABE75",
"+ c #FBC688",
"@ c #FEEEDB",
"# c #FEEFDD",
"$ c #FEF1E2",
"% c None",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%$XX+%%%%%%%%%%%%%",
"%%%%%%%%%%%%%@  o%%%%%%%%%%%%%",
"%%%%%%%%%%%%%@  o%%%%%%%%%%%%%",
"%%%%%%%%%%%%%@  o%%%%%%%%%%%%%",
"%%%%%%%%%%%%%@  o%%%%%%%%%%%%%",
"%%%%%%%%%%%%%@  o%%%%%%%%%%%%%",
"%%%%%%%%%%%%%@  o%%%%%%%%%%%%%",
"%%%%%%%%%%%%%@  o%%%%%%%%%%%%%",
"%%%%%%%%%%%%%@  o%%%%%%%%%%%%%",
"%%%%%%%%%%%%%@  o%%%%%%%%%%%%%",
"%%%%%%%%%%%%%@  o%%%%%%%%%%%%%",
"%%%%%%%%%%%%%@  o%%%%%%%%%%%%%",
"%%%%%%%%%%%%%@  o%%%%%%%%%%%%%",
"%%%%%%%%%%%%%@  o%%%%%%%%%%%%%",
"%%%%%%%%%%%%%@  o%%%%%%%%%%%%%",
"%%%%%%%%%%%%%@  o%%%%%%%%%%%%%",
"%%%%%%%%%%%%%@  o%%%%%%%%%%%%%",
"%%%%%%%%%%%%%@  o%%%%%%%%%%%%%",
"%%%%%%%%%%%%%#..O%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
]

colormap_range = [
"30 30 16 1 ",
"  c black",
". c #63431C",
"X c #494846",
"o c #AB7331",
"O c #F9A847",
"+ c #A7A099",
"@ c #C9B398",
"# c #C1C0BF",
"$ c #E2C9AB",
"% c #FDE1BF",
"& c #F1F0EE",
"* c #F7F3ED",
"= c #F6F6F6",
"- c #FBF7F1",
"; c #FFFBF5",
": c None",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::+$%%%%%%%%%%%%%%%%%%%%%%@#::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
":: oOOOOOOOOOOOOOOOOOOOOOO.X::",
"::&-;;;;;;;;;;;;;;;;;;;;;;*=::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::"
]

plot_yauto = [
"30 30 18 1 ",
"  c #040404",
". c #2B2B2B",
"X c gray31",
"o c #6B6B6B",
"O c #11A757",
"+ c #2EB26B",
"@ c #50BE83",
"# c #5CC38C",
"$ c #69C895",
"% c #7BCEA2",
"& c #919191",
"* c #B2B2B2",
"= c #8AD4AD",
"- c #B7E4CC",
"; c #D0D0D0",
": c #C9EBD9",
"> c #D8F1E4",
", c None",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,>%,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,+O>,,,,,,,,,,,,,,,,,,,,",
",,,,,,-OO@,,,,,,,,,,,,,,,,,,,,",
",,,,,,OOOO-,,,,,,,,,,,,,,,,,,,",
",,,,,-+OO+#,,,,,,,,,,,,,,,,,,,",
",,,,,,,%O,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,%O,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,%O,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,%+,,,;ooo>,,,*ooo,,,,,,",
",,,,,,,%O,,,,X  o,,,.  *,,,,,,",
",,,,,,,%O,,,,>   ;,o  &,,,,,,,",
",,,,,,,%O,,,,,;  .>  o,,,,,,,,",
",,,,,,,%+,,,,,,&  . .,,,,,,,,,",
",,,,,,,=O,,,,,,,X   >,,,,,,,,,",
",,,,,,,%O,,,,,,,*  X,,,,,,,,,,",
",,,,,,,%O,,,,,,,*  X,,,,,,,,,,",
",,,,,,,%+,,,,,,,*  X,,,,,,,,,,",
",,,,,,,%O,,,,,,,*..X,,,,,,,,,,",
",,,,,,,%O,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,%O,,,,,,,,,,,,,,,,,,,,,",
",,,,,>-#O--,,,,,,,,,,,,,,,,,,,",
",,,,,-OOOO$,,,,,,,,,,,,,,,,,,,",
",,,,,,#O+O,,,,,,,,,,,,,,,,,,,,",
",,,,,,>OO=,,,,,,,,,,,,,,,,,,,,",
",,,,,,,%+,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,:,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,"
]

zoom_in = [
"30 30 24 1 ",
"  c #2F2F30",
". c #49393E",
"X c #503C43",
"o c #5C5055",
"O c #726C6F",
"+ c #84747A",
"@ c #05A854",
"# c #2EB671",
"$ c #43BD7F",
"% c #8E7D84",
"& c #66CA96",
"* c #7AB3C8",
"= c #958E91",
"- c #A19A9F",
"; c #B1A8AB",
": c #B4BFBE",
"> c #ACDBC6",
", c #92D9F5",
"< c #A9DDF2",
"1 c #B6E2F4",
"2 c #D2CCCF",
"3 c #E2DCDF",
"4 c #D0E9F4",
"5 c None",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"55555553;;;:5555555555>#>55555",
"555553---=+Oo-55555555&@&55555",
"55553;:>1514*.+5555555&@&55555",
"5555;241,,,,44 =555>>>&@#>>>55",
"555;441<<,,,,4: 355@@@@@@@@@55",
"555;3441<,,,,,4 -55&##@@@##$55",
"55524441<<,,,,1OO55555&@&55555",
"55333444111<11<OX55555&@&55555",
"555255444111111oO55555&@&55555",
"555;34544444411 ;5555554555555",
"555:3353444445=.:3555555555555",
"5555-33553534- +;2355555555555",
"55553-224532%Xoo+-:35555555555",
"555555;=-=+OO23ooO=;2355555555",
"5555555522235555-Xo%;235555555",
"55555555555555555;Xo+-;3555555",
"5555555555555555552oX+=;335555",
"55555555555555555555+X+%;35555",
"555555555555555555555;Xo;55555",
"55555555555555555555553%555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555"
]

nxdata_create = [
"30 30 19 1 ",
"  c #010101",
". c #2F2F2F",
"X c #575757",
"o c #676767",
"O c #01A24C",
"+ c #29B068",
"@ c #50BE84",
"# c #5AC28A",
"$ c #66C693",
"% c #79CEA0",
"& c #8A8A8A",
"* c #AFAFAF",
"= c #92D7B2",
"- c #A7DEC1",
"; c #B9E5CE",
": c #D7D7D7",
"> c #CBECDA",
", c #DAF1E5",
"< c None",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<;;>>><<<<<<<<<<<<<<<<<<<<<",
"<<<<OOOOO;<<<<<<<<<<<<<<<<<<<<",
"<<<,O=>>><<<<<<<<<<<<<<<<<<<<<",
"<<<<O%;,<<<<<<<<<<<<<<<<<<<<<<",
"<<<<OOO#<<<<<<<<<<<<<<<<<<<<<<",
"<<<<O=><<<<<<<<<<<<<<<<<<<<<<<",
"<<<,O$;><<<<<<<<<<<<<<<<<<<<<<",
"<<<<OOO#<<<<<<<<<<<<,<<<<<<<<<",
"<<<<O=,<<<<<<<<<<<<* &<<<<<<<<",
"<<<<O$-><<<<<<<<<<<& o<<<<<<<<",
"<<<<OOO$<<<<<<<<<<<& X,<<<<<<<",
"<<<<O=,<<<<<<<<<*&oX .o&*<<<<<",
"<<<,O$-><<<<<<<,         :<<<<",
"<<<<OOO$<<<<<<<<&oX. .Xo&,<<<<",
"<<<,O=<<<<<<<<<<<<,& X:<<<<<<<",
"<<<<O#=;<<<<<<<<<<<& X<<<<<<<<",
"<<<<OOO$<<<<<<<<<<<* &,<<<<<<<",
"<<<<O=<<<<<<<<<<<<<<:,<<,=<<<<",
"<<<,O$<<<<<<<<<<<<<<<<<<-O<<<<",
"<<<<O$<<<,+>,+>>+,>+,;+<-O<<<<",
"<<<,O$<<<,O;,O;>O,;O,;O,-O,<<<",
"<<<,O+++@#O##O##O#@O$@O$@O,<<<",
"<<<<OOOOO+++++++++++++++++<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<"
]

image_mask = [
"30 30 15 1 ",
"  c black",
". c #070707",
"X c #0C0C0C",
"o c #161616",
"O c #2C2C2C",
"+ c #474747",
"@ c #565656",
"# c #707070",
"$ c #8E8E8E",
"% c #ADADAD",
"& c #D2D2D2",
"* c gray91",
"= c #F5F5F5",
"- c #FAFAFA",
"; c None",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;*$*;;;;;;;;;;;;;;;;;;;;;",
";;;;;;@  O#%&=;;;;;&%#O+;;;;;;",
";;;;;%    .   .Ooo    . %;;;;;",
";;;;;O                  o-;;;;",
";;;;%                    %;;;;",
";;;;@   .Oo        XOo.. +;;;;",
";;;-X .$-;-*@    O%;;;%O .-;;;",
";;-&  $;;;;;;+. .&;;;;;*o &;;;",
";;-$ .;;;;;;;$  +;;;;;;;@ $;;;",
";;;#  *;;;;;;#  O-;;;;;;O #;;;",
";;;@  O*;;;;%.   #;;;;;#  @;;;",
";;;+   o#$$@X o+  O#$$O   +;;;",
";;;+    .   . @%          +;;;",
";;;@          &=o         @;;;",
";;;#         o--#        .#;;;",
";;;$         #;;&         $;;;",
";;;&        .$;;*o        &;;;",
";;;;o       . oO         o;;;;",
";;;;@                   .@;;;;",
";;;;&     +&&*&*&*&$    .&-;;;",
";;;;;O    *-;;;;;;;;+   O-;;;;",
";;;;;%.                 &=;;;;",
";;;;;-#   @@@@@@@@@+O  #;;;;;;",
";;;;;;=O. &---;=;=;-O O=;;;;;;",
";;;;;;;*O X#$$$$$$$O O=;;;;;;;",
";;;;;;;;=@          +=;;;;;;;;",
";;;;;;;;-=%O      O%;;;;;;;;;;",
";;;;;;;;;;;;&$##$&;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
]

compare_mode_rb_channel = [
"30 30 23 1 ",
"  c #070707",
". c #292C2E",
"X c #2D4257",
"o c #484848",
"O c #716E6B",
"+ c #8A4500",
"@ c #E87809",
"# c #FF8000",
"$ c #F1902F",
"% c #B1804E",
"& c #FFB163",
"* c #1C5791",
"= c #0073E5",
"- c #77808A",
"; c #5981A9",
": c #0280FE",
"> c #2F91F3",
", c #63B2FF",
"< c #808080",
"1 c #FFD4A8",
"2 c #A5D2FF",
"3 c #E2E4E5",
"4 c None",
"444444444444444444444444444444",
"444444444444444444444444444444",
"444444444311134432223444444444",
"44444441&@##@#-;:::::>24444444",
"444444&###@@%<<<->==:::,444444",
"44444&#####%<<<<<<>=::::,44444",
"4444&#####$-<<<<<<<:::::=,4444",
"4441######-<<<<<<<<;::::::2444",
"444$#####%<<<<<<<<<<>:::::>444",
"441######-<-<<<<<<<<;::=:::344",
"44&#####@ooo<<<<<oooo*==:::,44",
"44$#####o   O<<<<      .:::>44",
"44@#####.   o<<<<. .O*  =:::44",
"43#####@  o  <<<O. .<X  =:::34",
"41####@+  O  O<<<.     *::::24",
"41####@. o<. .<<<  ...  =:::24",
"43####@   .   O-<. .<;. *==:34",
"44####+  . .  O<O. .O*  *:::44",
"44$#@@  o<<<. .O<.      :::>44",
"44&#@@++@-<<OooO<oooo*==:::,44",
"441@@####--<<<<<<<<<;::::::244",
"444&#####%-<<<<<<<<<==::::,444",
"4441#####@-<<<<<<<<;::::::2444",
"4444&#####$<<<<<<<-::::::,4444",
"44444&@####%-O<<<O>=::::,44444",
"444444&#####%-<<->:::::,444444",
"44444441$@####-;::::=>24444444",
"444444444411134432224444444444",
"444444444444444444444444444444",
"444444444444444444444444444444"
]

view_fullscreen = [
"30 30 21 1 ",
"  c #4D3C3D",
". c #555555",
"X c #795D5E",
"o c #777373",
"O c #BB3136",
"+ c #EC1C24",
"@ c #D32C33",
"# c #E62A31",
"$ c #E53F45",
"% c #996C6E",
"& c #D5585D",
"* c #D27D81",
"= c #909090",
"- c #AE9294",
"; c #AEAEAE",
": c #DC8D90",
"> c #CFB1B3",
", c #D1BFC0",
"< c #D4D3D3",
"1 c #E5D2D3",
"2 c None",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"22.=========================X2",
"22X2222222222222222222222222.2",
"22.<12<121<21<21<21<21<<12<1.2",
"22.2<221122<22<2212212<21221.2",
"22.2222222222222222222222222.2",
"22.221##@:22222222222<$$$:22.2",
"22.22>++@,22222222222,&++-22.2",
"22.22;@++&<2222222221:+++-12.2",
"22.22;@.O#$122222222:+# @-12.2",
"22.22<==XO#$1222222&+@oo=,22.2",
"22.222<<;=O&<22222<&@o=,<222.2",
"22.222221<;;<222221;;;122222.2",
"22.2222221>:2222222>><222222.2",
"22.222222>#+<222222$+>222222.2",
"22.222:1:+#%<12222<-##&<*222.2",
"22.22<$#+#%;1222221;%@+@+122.2",
"22.22<#+@o=<2222222<;oO++:22.2",
"22.22;+++%<222222222<-@+#%12.2",
"22.21,=.=;12222222222>=.o;22.2",
"22.....   .............   ..X2",
"222222122222222222222212222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222"
]

add_shape_polygon = [
"30 30 21 1 ",
"  c #0CA853",
". c #1BB064",
"X c #B59D35",
"o c #F7941E",
"O c #C79828",
"+ c #F79928",
"@ c #F8A23A",
"# c #B4B15E",
"$ c #F9AA4D",
"% c #DEB463",
"& c #FABA6D",
"* c #FAC17D",
"= c #64C893",
"- c #91D1A3",
"; c #FBCB92",
": c #FBD8AD",
"> c #FDE0BE",
", c #B8E4CB",
"< c #FDE8CF",
"1 c #D4F0E2",
"2 c None",
"222222222222222222222222222222",
"222222222222222222222222222222",
"2222222222222<;222222222222222",
"222222222222:+$222222222222222",
"22222222222;ooo222222222222222",
"2222222222:oooo>22222222222222",
"222222222;oo$@o&22222222222222",
"22222222;oo$2&o$22222222222222",
"2222222;oo@22:oo<2222222222222",
"222222&o+$2222oo;2222222222222",
"22222&oo&22222$o&2222222222222",
"2222&oo$222222;o+2222222222222",
"2222@o+2222222<oo<222222222222",
"2222>oo;2222222@o+;22222222222",
"22222&oo<222222;ooo@:222222222",
"222222@o@22222222&ooo@:2222222",
"222222<oo*22222222<$+oo$<22222",
"2222222*oo<222222222<$ooo&<222",
"22222222@o@22222222222;XOo&222",
"22222222<oo&2222222222,  @<222",
"222222222&oo<222222222#  <2222",
"22222222<+o@<22222222;X .22222",
"2222222<@o$<2222222=        12",
"222222<$oo;<2222221=      . 12",
"222222$oooooo@$&;;>%OO- .11122",
"22222<&$@+ooooooooooo;, .22222",
"22222222222<:;;&$+oo$2, .22222",
"2222222222222222222<221=-22222",
"222222222222222222222222222222",
"222222222222222222222222222222"
]

math_real = [
"30 30 15 1 ",
"  c #010101",
". c #0B0B0B",
"X c #171717",
"o c #303030",
"O c gray30",
"+ c #6C6C6C",
"@ c #8D8D8D",
"# c #979797",
"$ c #AEAEAE",
"% c #C9C9C9",
"& c #D5D5D5",
"* c #E8E8E8",
"= c #F4F4F4",
"- c #F9F9F9",
"; c None",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;&%;;-;;;;;;;;;;;;;",
";;;;;;;;;&#O Ooo+=;;;;;;;;;;;;",
";;;;;;;&O@*O.;;@ +-;;;;;;;;;;;",
";;;;;;%.$;;XO;;% O;;;;;;;;;;;;",
";;;;;;oX;;& @;;# #;;;;;==;;;;;",
";;;;;& o;;# %;=XO-;;;=+X.%;;;;",
";;;;;% o;;O.&#O$;;;;=o%$ $;;;;",
";;;;;*X#;;Xo.o;;;;;;O+;@X-;;;;",
";;;;;;-;;& #O *;;;;& &%o&;;;;;",
";;;;;;;;-@.*# #;;;;+X#+=;;;;;;",
";;;;;;;;;o+;* o;;;;oX$;;;;;;;;",
";;;;;;;;&o;;-o *;;;XO;;;%#;;;;",
";;;;;;;%O=;;-+ @;;;.X*-@+=;;;;",
";;;;&X  Xo@;;% o;;;O .X#;;;;;;",
";;;;=&*=*;;;;;o $;;-$$-;;;;;;;",
";;;;;;;;;;;;;;& o-;;$$;;;;;;;;",
";;;;;;;;;;;;;;;$.O&$Xo-;;;;;;;",
";;;;;;;;;;;;;;;;*#++$;;;;;;;;;",
";;;;;;;;;;;;;;;;-;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
]

math_derive = [
"30 30 17 1 ",
"  c #000000",
". c #050505",
"X c #0C0C0C",
"o c #171717",
"O c #222222",
"+ c #3A3A3A",
"@ c #484848",
"# c #575757",
"$ c #707070",
"% c #919191",
"& c #ACACAC",
"* c #B8B8B8",
"= c #D2D2D2",
"- c #E7E7E7",
"; c #F3F3F3",
": c #FAFAFA",
"> c None",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>:-:>>>>>>>>>>>>>>>>>>>",
">>>>>>>&X #>;=->>>>>>>>>>>>>>>",
">>>>>>-X  #:# =>>>>>>>>>>>>>>>",
">>>>>>% o&=;OX>>>>>>>>>>>>>>>>",
">>>>>:$ %>>:X@>>>>>>>>>>>>>>>>",
">>>>>>@ &:>- %>>>>>>>>>>>>>>>>",
">>>>>%O #%;& ->;@;>>>>>%%>>>>>",
">>>>>O    -$+>>%@>>>>>>&O>>>>>",
">>>>>@X O+-;:>>#$:>>>>>;.=>>>>",
">>>>>>+ &>>>>>>O&=@%:@$>o&>>>>",
">>>>>>@ &>>>>>>.=>+O* *>@%>>>>",
">>>>>>+ &>>>>>; =>& O+::#$>>>>",
">>>>>>+ &>>>>>; =>>O &>>#$>>>>",
">>>>>>@ &>>>>>; =:;X.$>>@$>>>>",
">>>>>>+ &>>>>>>X=:% @o;>+%>>>>",
">>>>>>+ &>>>>>>+%:O@& %>o*>>>>",
">>>>>>+ &>>>>>>$#=$*:$%= ;>>>>",
">>>>>>@ &>>>>>>*o>>>>>>%@>>>>>",
">>>>>>%%=>>>>>>>&;>>>>:==>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
]

view_2d_stack = [
"30 30 18 1 ",
"  c #0A0908",
". c #291A08",
"X c #65441C",
"o c #754F21",
"O c #494846",
"+ c #6F6F6F",
"@ c #AD6A1A",
"# c #8C5F28",
"$ c #936023",
"% c #CA7918",
"& c #F6941E",
"* c #D1872F",
"= c #F49524",
"- c #F1A03F",
"; c #F8A747",
": c #9F9F9F",
"> c #CFCFCF",
", c None",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,:  .. ...   ..  . +,,",
",,,,,,,,,: ##########$###$.O,,",
",,,,,,,,,:.;;;;;;;;;;;;;;;XO,,",
",,,,,,>>>+ ************%;;XO,,",
",,,,,>                  ;;oO,,",
",,,,,> @*%@*%*****%**%$ ;;XO,,",
",,,,,> *;*%&&&&&&&&&&&@ -;XO,,",
",,:::+ o#oXo$$$ooo$$%&@ ;;XO,,",
",,.  . ........ ... @&@ -;XO,,",
",,.#--%===&&&&&&&&& @&@ ;;XO,,",
",, #;-%=&&&&&&&&&&& @&@ ;;XO,,",
",, #;-%==&&&&&&&&&& @=@ -;XO,,",
",,.#;-%==&&&&&&&&&& @=@ ;;XO,,",
",,.#;;%==&&&&&&&&&& @=@ -;XO,,",
",,.+;-%===&&&&&&&&& @=@ ;;XO,,",
",,.#;-%===&&&&&&&&& @&@ -;XO,,",
",, #;-%==&&&&&&&&&& @&@ --XO,,",
",,.#;-%==&&&&&&&&&& $@$    O,,",
",,.#;-%========&=&& @-$ :>:>,,",
",,.#;-%==&=====&&== @;@ ,,,,,,",
",,.#--%*&&&&=*&&=*& o$o ,,,,,,",
",,.$--%%%%@%%%*@%%%     ,,,,,,",
",, #;;;;;;;;;;;;;;; :,,,,,,,,,",
",,.#;;;;;;;;;;;;;;- :,,,,,,,,,",
",,..XXXXXXXXXXXXXXX :,,,,,,,,,",
",,+OOOOOOOOOOOOOOOOO>,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,"
]

rotate_3d = [
"30 30 16 1 ",
"  c #000000",
". c #060606",
"X c #0B0B0B",
"o c #161616",
"O c #2E2E2E",
"+ c #484848",
"@ c #5A5A5A",
"# c #6D6D6D",
"$ c #898989",
"% c #989898",
"& c #B1B1B1",
"* c #D0D0D0",
"= c #E7E7E7",
"- c #F3F3F3",
"; c #F9F9F9",
": c None",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
":::::::::::::*#$;:::::::::::::",
"::::::::::::=o .@:::::::::::::",
"::::::::::::@ #o *::::::::::::",
":::::::::::-.o;% #;-::::::::::",
":::::::::::&.@=% .X&::::::::::",
":::::::::::# %=o  o;::::::::::",
":::::::::::+ *;*X.@:::::::::::",
"::::::::::;O ;;;%.&:::::::::::",
"::::::::::; o::::#;$++OO=:::::",
"::::;*&:::= O:::::;*. .O;:::::",
"::;$o. =::= +:::::::$   o$::::",
"::#. +%::;* +:::::::;OO+  @:::",
":- o*:::::&.@::::::::**:*o =::",
"::o +&;:::* @::::::::;:&@ o;::",
"::*O .XO#$$ +*=**&&%#Oo .O*;::",
":::;%+o.        ..    o+%;;;::",
":::::::=&$# o+O+@@#$&=::::::::",
":::::::::;; O;::::::;:::::::::",
":::::::::::O -::::::::::::::::",
":::::::::::+ *::::::::::::::::",
":::::::::::# %::%%::::::::::::",
":::::::::::&.@:- O::::::::::::",
":::::::::::-.o-% #;:::::::::::",
"::::::::::::@ #o *::::::::::::",
"::::::::::::=o  @:::::::::::::",
":::::::::::::*#$;:::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::"
]

math_energy = [
"30 30 13 1 ",
"  c DimGray",
". c #F7941E",
"X c #F79827",
"o c #F8A13B",
"O c #F9AD53",
"+ c #FAB86A",
"@ c #9B9B9B",
"# c #A8A8A8",
"$ c #FBC88C",
"% c #FCD2A1",
"& c #D2D2D2",
"* c #FEECD7",
"= c None",
"==============================",
"==============================",
"==============================",
"==============================",
"=====$$$$$$$$$$$$$%===========",
"====*...X......X..o&&&&#@@&===",
"====*...........XXo=&=*&& #===",
"=====X.O**=***=****======@#===",
"=====o.O=================##===",
"=====o.O=================@@===",
"=====o.O=================@#===",
"=====o.O=================@#===",
"=====o.O=================##===",
"=====o.O=*=*=*===========@#===",
"=====o.X......o==========@@===",
"=====o.X......o==========@#===",
"=====o.o$$$+$$$==========##===",
"=====oXO=================@@===",
"=====o.O=================@#===",
"=====o.O=================@#===",
"=====o.O=================@#===",
"=====o.O=================@#===",
"=====o.O=================@#===",
"=====oXO=================@@===",
"====*X..XXXXXXX.XXO=*===&@@===",
"====*X............o&&&@@@ #===",
"====*++++++++++++++===========",
"==============================",
"==============================",
"=============================="
]

view_3d = [
"30 30 16 1 ",
"  c #110E09",
". c #332311",
"X c #2C2A28",
"o c #593812",
"O c #643E10",
"+ c #413E3C",
"@ c #78501F",
"# c #525252",
"$ c #946021",
"% c #956429",
"& c #B6762A",
"* c #CD7C1B",
"= c #DA8928",
"- c #EA9938",
"; c #F9A847",
": c None",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
":::::::::::X               X::",
"::::::::::X.$&&&&&&&&&&&%  X::",
":::::::::#o==;;;;;;;;;;;.  X::",
"::::::::X.-==;;;;;;;;;;  $o ::",
":::::::Xo-;==;;;;;;;;;. $;oX::",
"::::::Xo;;;==;;;;;;;;. $-;oX::",
":::::Xo;;;;==;;;;;;;. $;;;o ::",
"::::#X;;;;;==;;;;;;. $;;;;OX::",
":::X.;;;;;;==;;;-;. @;;;;;o.::",
"::                 $;;;;;;oX::",
":: .oooOoooooOooo  ;;;;;;;oX::",
":: %;;;;;;;==;;;;  ;;;;;;;oX::",
":: %;;;;;;;==;;;;. ;;;;;;;o.::",
":: %;;;;;;;=-;;;;  ;;;;;;-oX::",
":: %;;;;;;;==;;;;  ;;;;;;;o.::",
":: %;;;;;;;=*****  =******. ::",
":: %;;;;;;-*=====  ======o #::",
":: %;;;;;-*-;;;;;  ;;;;;@ #:::",
":: %;;;;-*-;;;;;;  ;;;;$ #::::",
":: %;;;;=-;;;;;;;  ;;;$ #:::::",
":: %;;;*-;;;;;;;;. ;;$ X::::::",
":: %;-*-;;;;;;;;;  ;% +:::::::",
":: %-*-;;;;;;;;;;. % X::::::::",
":: %*-;;;;;;;;;;;   X:::::::::",
":: .oOooooooOoooo  X::::::::::",
"::XX X X X X X X  #:::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::"
]

math_square_amplitude = [
"30 30 16 1 ",
"  c #010101",
". c #0B0B0B",
"X c #161616",
"o c #2F2F2F",
"O c #464646",
"+ c #585858",
"@ c #646464",
"# c #787878",
"$ c #8E8E8E",
"% c #A5A5A5",
"& c gray",
"* c #D4D4D4",
"= c #E7E7E7",
"- c #F3F3F3",
"; c #FBFBFB",
": c None",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
":::::::::::::::::::::::;::::::",
"::::::::::::::::::::::*%%;::::",
"::::::::::::::::::::::o@Xo::::",
"::::::::::;::::::::-;:;:$.::::",
":::-#:::::%+#:::::%*:::*X%::::",
":::-o:::::X .*::::#&::&.%-::::",
":::-O::::&.O $::::#&::X.oX-:::",
":::-O::::+.*Xo::::#&::=***::::",
":::-O:::-.O:# *:::#&::::::::::",
":::-O:::$.%:* +;::#*::::::::::",
":::-O:::o.-::o.-:-#&::::::::::",
":::-O::* @:::$.%;:#&;:::::::::",
":::-O:;# %-=-=.o::#&;:::::::::",
":::-O:;X        *:#&::::::::::",
":::-O:% O$$$$$@ #:#*::::::::::",
":::-O:O *;::::;.X;#&::::::::::",
":::-O=.o:::::::@ &#&::::::::::",
":::-O$X$:::::::*X@#&::::::::::",
":::::::::::::::::::;::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::"
]

cube_bottom = [
"30 30 18 1 ",
"  c #100F0F",
". c #201C18",
"X c #3B2A16",
"o c #393939",
"O c #453728",
"+ c #644F36",
"@ c #5B5650",
"# c #8D622F",
"$ c #A97434",
"% c #CC893B",
"& c #E79C42",
"* c #F9A847",
"= c #9C9B9A",
"- c #A29F9B",
"; c #B4B4B3",
": c #C1C0BF",
"> c #CECECE",
", c None",
",,,,,,,,,,,,,>,,,>,>,,>,,>,,>,",
",,,,,,,,,,>                  ,",
",,,,,,,,,>oo>,,,,,,,,,,,,,;o.,",
",,,,,,,,>o>o>,,,,,,,,,,,,;o> ,",
",,,,,,,>o>,@>,,,,,,,,,,,;o,,.,",
",,,,,,>o>,,o>,,,,,,,,,,;o,,,.>",
",,,,,>o>,,,o>,,,,,,,,,;o,,,,.,",
",,,,>o>,,,,o>,,,,,,,,;o,,,,,.,",
",,,>o>,,,,,o>,,,,,,,;o,,,,,,.,",
",,>o,,,,,,,o>,,,,,,;o,,,,,,,.>",
",>.>,,,,,,,o>,,,,,;o,,,,,,,,.,",
">                 .,,,,,,,,, ,",
", >>>>>>>>>o->>>>;o,,,,,,,,,.,",
",.,,,,,,,,,o>,,,,>o,,,,,,,,, ,",
",.,,,,,,,,,o>,,,,>o,,,,,,,,,.,",
",.,,,,,,,,,o>,,,,>o,,,,,,,,, ,",
", ,,,,,,,,,o>,,,,>O,,,,,,,,,.,",
",.,,,,,,,,,O=>::>-o;>;;>::>; ,",
">.,,,,,,,,,.                 >",
",.,,,,,,,,X$*****%X&******%.>,",
",.,,,,,,,o$******%X*****&&X>,,",
",.,,,,,,o$*******%X*****&X:,,,",
", ,,,,,o$********%X****&X>,,,,",
",.,,,,o$*********%X***&X;,,,,,",
">.,,,+#**********%X***X;,,,,,,",
",.,,@#***********%X*&O-,,,,,,,",
",.,@+************%X*O-,,,,,,,,",
",o@+*************%XX=,,,,,,,,,",
",                  =,,,,,,,,,,",
",>,,,>>,>,,,,>>,>,,,,,,,,,,,,,"
]

math_swap_sign = [
"30 30 22 1 ",
"  c #1E1E1E",
". c #503E3F",
"X c #474646",
"o c #717171",
"O c #EF3138",
"+ c #F03B42",
"@ c #F14B52",
"# c #F4777B",
"$ c #12AC5E",
"% c #2FB671",
"& c #45BE80",
"* c #69CA98",
"= c #929292",
"- c #B3B3B3",
"; c #F79DA0",
": c #91D9B4",
"> c #FABFC1",
", c #AFE3C9",
"< c #D0D0D0",
"1 c #FBD2D3",
"2 c #D0EFDF",
"3 c None",
"333333333333333333333333333333",
"33333333**23333333333333333333",
"3333333:&*%3333333333333333333",
"3333333$23**333333333333333333",
"333333,%332$333333333333333333",
"333333&:333&*332$$*33333333333",
"333332$33333$23$:3%:3333333333",
"33333**33333,$$*332$2333333333",
"3333:%2333333233333*%333333333",
"332*$233333333333333&&,,,33333",
"33:*33333333333333333:&&*33333",
"3o..XXX.XXXX XX.XXXXXX...o3333",
"33;O;3333333333333331@OO@33333",
"3331O;33333333333331O;33333333",
"33333O1333333;;1333@;333333333",
"33333;@33333#@#@33;@3333333333",
"333333O1333>O33#@;O13333333333",
"333333#;333+>333;#133333333333",
"3333331O33;@333333333333333333",
"3333333@;3O>3333=33333333-<333",
"33333331OO;3333<X3333-X 3<X333",
"333333331133333o-3333=X 33 333",
"333333333333333X<33333= 33X<33",
"33333333<o-o333X-2==<3= 33X<33",
"333333333  -333o=<Xo<3= 33 233",
"333333333X 23332.33333= 3-o333",
"33333333< .o3333<33333<-3<1333",
"33333333<-<-333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333"
]

image_select_erase_rubber = [
"30 30 24 1 ",
"  c #141E1A",
". c #1B5C2F",
"X c #2A4F40",
"o c #434244",
"O c #6C6A6C",
"+ c #BE5039",
"@ c #A0692A",
"# c #D8702C",
"$ c #698B38",
"% c #2D8553",
"& c #608E5F",
"* c #9A8D2F",
"= c #CD9A2B",
"- c #999861",
"; c #C9A34E",
": c #597781",
"> c #59A284",
", c #8F8F8F",
"< c #ADACA1",
"1 c #C3BCAA",
"2 c #DDCEAB",
"3 c #CCCCCC",
"4 c #EAE3D1",
"5 c None",
"555555555555555355555555555555",
"555555555555553o15555555555555",
"5555555555553Oooo4555555555555",
"55555555554<ooooo,555555555555",
"5555555555Oooooooo355555555555",
"55555555553oooooooO55555555555",
"55555555555Oooooooo35555555555",
"555555555553oooooooo3555555555",
"555555555555<Xoooooo,555555555",
"5555555555554Oooooooo355555555",
"55555555555551ooooooo,55555555",
"5555555555<355OoooooO335555555",
"555555555:. X-<oooO3,oO4555555",
"55555555XX.. .o-o,<oooo<555555",
"5555555X XX....-1OoooooO1;2555",
"555555o  :>&&>-<,ooooo,+++#@-4",
"55555545555555554:OO,455;++#45",
"5555555555555555555555555#@255",
"5555555555555555555555554@4555",
"5555555553<1<<112222221-#45555",
"555555O   ..$$$**@=@+#+#455555",
"555555   .%%%$$*=@=@@##4555555",
"55555553,>%%%$$*=$==@*45555555",
"55555555555421<-=**=-455555555",
"5555555555555555542;5555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555"
]

colormap_histogram = [
"30 30 13 1 ",
"  c black",
". c #494949",
"X c #656565",
"o c #F9A847",
"O c #FAB86A",
"+ c #FBC27F",
"@ c #AFAEAE",
"# c #FCCB91",
"$ c #FCD7AB",
"% c #FDE1BF",
"& c #C6C6C6",
"* c #FDE7CB",
"= c None",
"==============================",
"==============================",
"==@*==========**==========&&==",
"== @========#oooo%========X.==",
"== @=======#oooooo*=======X.==",
"== @=======oooooooO=======X.==",
"== @======#oooooooo*======X.==",
"== @======ooooooooo#======X.==",
"== @=====*oooooooooo======X.==",
"== @=====$oooooooooo*=====X.==",
"== @=====+oooooooooo*=====X.==",
"== @=====Ooooooooooo$=====X.==",
"== @=====ooooooooooo#=====X.==",
"== @====*oooooooooooO=====X.==",
"== @====*oooooooooooo=====X.==",
"== @====$oooooooooooo=====X.==",
"== @====#oooooooooooo*====X.==",
"== @====+oooooooooooo$====X.==",
"== @====ooooooooooooo#====X.==",
"== @====ooooooooooooo#====X.==",
"== @===*oooooooooooooo====X.==",
"== @===$oooooooooooooo====X.==",
"== @===Ooooooooooooooo$===X.==",
"== @===oooooooooooooooO===X.==",
"== @==#oooooooooooooooo*==X.==",
"== @=*oooooooooooooooooO==X.==",
"== @$oooooooooooooooooooO%X.==",
"==*=*===*===*=====*=*=====*===",
"==============================",
"=============================="
]

plot_widget = [
"30 30 17 1 ",
"  c #0D0D0D",
". c #2C2C2C",
"X c #3F3F40",
"o c #505050",
"O c #5F5F60",
"+ c #6E7170",
"@ c #73857C",
"# c #768D81",
"$ c #7DCAA2",
"% c #8D8F8F",
"& c #B1B2B2",
"* c #84CFA7",
"= c #B6D6C7",
"- c #B5E3CA",
"; c #CAD4D0",
": c #DDE5E2",
"> c None",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>:$***********&********>>",
">>>>>>--:::>>::>::>:::::>::*>>",
">>>>>>-=:>:::>:&%>:>>:>::>:$>>",
">>>>>>-=>:>:::;  &:::::>::>*>>",
">>>>>>:@::::>:%.Oo>:::::>::*>>",
">>>>>>-=::::::o+& ;:>::>:::$>>",
">>>>>>:=::::>; &> %>>:::>>:$>>",
">>>>>>-=>>::;X.>>Oo>:>:::::*>>",
">;&>;&-@;::& X&::& ::::>:>>*>>",
">; ; &;=:::Oo::>:; ;%.::::>*>>",
">>% %>--::>X+>:::>.+. %:>::%>>",
">>> ;>;;>:>.+>:>>:O. XO>:>>$>>",
">>>+:>;+;;O ;:::::& .%X>:::$>>",
">>>>>>-->X.&>::::>:;:&.:::>*>>",
">>>>>>-;: &::>:>:::::: &;::*>>",
">>>>>>--&.::::>:>::::>X .::$>>",
">>>>>>-#.+>>>:::::>::>% .%>$>>",
">>>>>>-%O:>::::>>:>:::>;&.:$>>",
">>>>>>--:>::>>::::::>:::>::*>>",
">>>>>>:-:::;:::;:>>;:>:;>::$>>",
">>>>>>-*;;;@;;-@;;;+;;;+;-;$>>",
">>>>>>>---------====-------->>",
">>>>>>>>>>>>>>>o+;.:>>>>>>>>>>",
">>>>>>>>>>>>>>>: .&>>>>>>>>>>>",
">>>>>>>>>>>>>>>:. &>>>>>>>>>>>",
">>>>>>>>>>>>>>>o+& :>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
]

math_peak_reset = [
"30 30 24 1 ",
"  c #212222",
". c #682928",
"X c #135D37",
"o c #535144",
"O c #665D5D",
"+ c #EB1D25",
"@ c #D2262C",
"# c #E7262D",
"$ c #A34243",
"% c #D9676C",
"& c #179253",
"* c #05A553",
"= c #4CB37E",
"- c #DD7D81",
"; c #74BE96",
": c #75CEA1",
"> c #929090",
", c #A69795",
"< c #B1B1B1",
"1 c #DB9EA1",
"2 c #BACEC4",
"3 c #D3D3D3",
"4 c #D4EEE1",
"5 c None",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"55555555555555oX55555555555555",
"55555555555552**<5555555555555",
"5555555555555&**X5555555555555",
"5555555555555****2555555555555",
"555555555555=****=555555555555",
"555555555555o<::< 555555555555",
"55555555554Oo5::5 455555555555",
"555555555> O55::5O,54555555555",
"55555555%@-555::5,O3#@45555555",
"55555553%@+-55::53.++.O5555555",
"55555555, ++%5::5-++.O 5555555",
"555555554 O#+%;;%++. 3 4555555",
"55555554Oo<O#+@$+#. O5 4555555",
"5555552 O54<O@++@O<355O3555555",
"555555O,5553,#++@,5555>>555555",
"555555 55551++..+#1555<o2<5555",
"555553O5551++.XX.+#1555   5555",
"55555O<54%++$X&XX.@+-55>O>>555",
"5555<>54%++O<&**&>$@+%5555 555",
"55555553%@O<44**43>O+%45555555",
"55555554,><555;=554<><55555555",
"555555554355555455543455555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555"
]

stats_whole_items = [
"30 30 11 1 ",
"  c #F7941E",
". c #F79826",
"X c #F8A23C",
"o c #F9AB4E",
"O c #FAB96C",
"+ c #FAC27E",
"@ c #FBCB91",
"# c #FCD8AE",
"$ c #FDE0BE",
"% c #FDE8D0",
"& c None",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&# .%&&&",
"&&&&&&&&&&&&&&&&&&&&&%o   @&&&",
"&&&&&&&&&&&&&&&&&&&&+    O&&&&",
"&&&&&&&&&&&&&&&&&&#X   X$&&&&&",
"&&&&&&%#OXO@&&&&%o.  .@&&&&&&&",
"&&&&+X       o@@.   o%&&#@&&&&",
"&&&#              X#&&&@..@&&&",
"&&&%..o@%&%+o   .+&&&&#   %&&&",
"&&&&%&&&&&&&&%@O%&&&&$   @&&&&",
"&&&&&&&&&&&&&&&&&&&&%.  O&&&&&",
"&&&&&&&&&&&&&&&&&&&%.  o&&&&&&",
"&&&&&&&&#X+&&&&&&&%X  o&&&&&&&",
"&&&&&&&%.  X%&&&&&o  o&&@@&&&&",
"&&&&&&&X     +&&&o  X%&O  @&&&",
"&&&&&&O  oo   X%O  .%&O. .%&&&",
"&&&&&@  .%&@.   . .$&O   #&&&&",
"&&&&%.  #&&&%o    #&O  .$&&&&&",
"&&&&X  O&&&&&&@. @&O   #&&&&&&",
"&&&@. o&&$%&&&&%%&O  .$&&&&&&&",
"&&&%.X%#.   oO@$%O  .$&&&&&&&&",
"&&&&&%o.           .$&&&&&&&&&",
"&&&&O    oOo.     .$&&&&&&&&&&",
"&&&@   X$&&&&%#+oo%&&&&&&&&&&&",
"&&&% .@&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&"
]

add_shape_diagonal = [
"30 30 15 1 ",
"  c #09A855",
". c #1CB164",
"X c #B29C34",
"o c #F7941E",
"O c #F79826",
"+ c #F9B15A",
"@ c #F9B360",
"# c #64C894",
"$ c #9DCFA0",
"% c #FCD5A7",
"& c #B9E7D0",
"* c #CFEEDD",
"= c #FDE3C5",
"- c #D7F1E4",
"; c None",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;%=;;;;;;;;;;;;;;;;;;;;",
";;;;;;;%oO=;;;;;;;;;;;;;;;;;;;",
";;;;;;;+ooO=;;;;;;;;;;;;;;;;;;",
";;;;;;;;@ooO=;;;;;;;;;;;;;;;;;",
";;;;;;;;;@ooO=;;;;;;;;;;;;;;;;",
";;;;;;;;;;@ooO=;;;;;;;;;;;;;;;",
";;;;;;;;;;;+ooO=;;;;;;;;;;;;;;",
";;;;;;;;;;;;@ooO=;;;;;;;;;;;;;",
";;;;;;;;;;;;;@ooO=;;;;;;;;;;;;",
";;;;;;;;;;;;;;+ooo=;;;;;;;;;;;",
";;;;;;;;;;;;;;;+ooO=;;;;;;;;;;",
";;;;;;;;;;;;;;;;+ooo=;;&*;;;;;",
";;;;;;;;;;;;;;;;;+ooo=& .;;;;;",
";;;;;;;;;;;;;;;;;=+ooO$ .;;;;;",
";;;;;;;;;;;;;;;;;;;+ooX .;;;;;",
";;;;;;;;;;;;;;;;;;;#        *;",
";;;;;;;;;;;;;;;;;;;#      . *;",
";;;;;;;;;;;;;;;;;;;-**$  ***;;",
";;;;;;;;;;;;;;;;;;;;;;& .;;;;;",
";;;;;;;;;;;;;;;;;;;;;;& .;;;;;",
";;;;;;;;;;;;;;;;;;;;;;-#$;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
]

image_select_erase = [
"30 30 24 1 ",
"  c #23612F",
". c #696D2D",
"X c #514A43",
"o c #A0241F",
"O c #B42D25",
"+ c #D11F25",
"@ c #EC1C24",
"# c #D22A29",
"$ c #E9252B",
"% c #A16026",
"& c #D65338",
"* c #9D6E53",
"= c #678E3A",
"- c #379C4E",
"; c #33A050",
": c #57A661",
"> c #9F9B32",
", c #B69A3D",
"< c #8F7F80",
"1 c #6BA18B",
"2 c #A1A0A0",
"3 c #E99699",
"4 c #D4CECE",
"5 c None",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"5552X X:=>=***&***,:1555555555",
"555X    ==.oXoOOo&,:;555555555",
"555X    .%%oo+ooOO>>;555555555",
"555<   ...Xooooo#$%,-555555555",
"5551  ..%%%ooo+oO%,>:555555555",
"555X  >=>%%o+oo@@%,>-555555555",
"5551 %>.>%%oooo+##>>-555555555",
"555X  ...%o%+o++O%,>:555555555",
"555:  .%%%oO##oO&>>=;555555555",
"5551  =.=%%%o#O%,,>;;555555555",
"555:X=>%%,%&%O&,>&>;;555553455",
"5551-==,>,%%,%,,&@@%:55553$$$5",
"5551-=>>>>,>&,>>@@@@%5553@@@@4",
"5551-==>,>>>>>>>#@@@+&5&@@@@$4",
"5551  >=>>>>===; +@$@@$$@@@+<2",
"5551 -=:==-=:; ;- +$@@@@@@+<24",
"5551  ; ;;;;;;;;;; #@@@@$$X245",
"5551--;;::;:;;:-::;o@@@@$#<445",
"5555555555555555553@@@@@@@&455",
"555555555555555553@@@@@@@@$&55",
"55555555555555553@@@@@X+@@$$&4",
"5555555555555555$@@@@X<<$@@$@4",
"5555555555555555$@@$X2442$$$$4",
"55555555555555554$O*244542#$<2"
]

plot_xauto = [
"30 30 17 1 ",
"  c #060606",
". c #303030",
"X c #565656",
"o c gray46",
"O c #07A450",
"+ c #30B36D",
"@ c #47BB7D",
"# c #6AC896",
"$ c #959595",
"% c #A9A9A9",
"& c #8FD6B0",
"* c #A1DCBD",
"= c #BBE6CF",
"- c #CACACA",
"; c #C5EAD6",
": c #DBF2E5",
"> c None",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>-oo$:>>>ooo->>>>>>>>>",
">>>>>>>>>>.  o>>o  .>>>>>>>>>>",
">>>>>>>>>>:   --  .:>>>>>>>>>>",
">>>>>>>>>>>-  ..  ->>>>>>>>>>>",
">>>>>>>>>>>>$    %>>>>>>>>>>>>",
">>>>>>>>>>>>-    ->>>>>>>>>>>>",
">>>>>>>>>>>:  .   :>>>>>>>>>>>",
">>>>>>>>>>>X  %$  .>>>>>>>>>>>",
">>>>>>>>>>X  X>>X  X>>>>>>>>>>",
">>>>>>>>>% ..:>>>   $>>>>>>>>>",
">>>>>>::>>>>>>>>>>>>>>>=>>>>>>",
">>>>>#O=>>>>>>>>>>>>>>>++;>>>>",
">>>*OOO#&&&&&&&&&&&&&&&OOO@:>>",
">>;OO@OOOOOOOOOOOOOOOOOO+OO#>>",
">>>>&OO=>>>>>>>>>>>>>>>+O+;>>>",
">>>>>:@=>>>>>>>>>>>>>>>@*>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
]

image = [
"30 30 21 1 ",
"  c #040807",
". c #14212B",
"X c #1B6131",
"o c #6A6B2B",
"O c #4D2D45",
"+ c #136155",
"@ c #A52820",
"# c #D12B23",
"$ c #9A6326",
"% c #D06A26",
"& c #25863D",
"* c #6E8F39",
"= c #209658",
"- c #30AD4A",
"; c #53AE47",
": c #9C9C33",
"> c #BEAB2E",
", c #2E4F8A",
"< c #1D9D92",
"1 c #B4B5B5",
"2 c None",
"222222222222222222222222222222",
"222212222112222112222112222222",
"2221        .-X           1222",
"2221       &;;;           1222",
"2221      X;;;;&X  .      1222",
"2221     .&;>:o*o$>*+,.   1222",
"2221     X&:*oooo%o$:<,   1222",
"2221     X&o*oo@@@@@:*<<  1222",
"2221    .XXo:o@@#@@@$:=<+ 1222",
"2221   .X.Xoo@@@@@##%:-=<.1222",
"2221  .+XXoo$$@@@@@#%>--=+1222",
"2221  +X.**:$$@@@###%*=-<<1222",
"2221  +.Xoo*$@@@@@@@:>--<<1222",
"2221  +XXXo$$o@###%$:;--;+1222",
"2221 .XXX.*$o@%##@$%>;--;+1222",
"2221  .XX**:%$%$#%:>*=--;=1222",
"2221  XXo**>:%$%%:>:--;-=O1222",
"2221 X&&;**>$>$>>::;-=-;=O1222",
"2221 +&=&**::>>:::-&;--;,.1222",
"2221+&&&X&;*:**;*&-&-;-=O 1222",
"2221X++&+X&-;-&=-&-----,. 1222",
"2221 +++XX&X&&-&-&-;--,O  1222",
"2221 +=<+==X-&-=--=-+,O   1222",
"2221   .<===----&-+,OO    1222",
"2221    ++=<+-+-++.O      1222",
"2221      .<.+..          1222",
"2221                      1222",
"2221          oO          1222",
"222222212122122222212212222222",
"222222222222222222222222222222"
]

cube_right = [
"30 30 12 1 ",
"  c #151310",
". c #21160A",
"X c #30281E",
"o c #393836",
"O c #B5711E",
"+ c #BA7E37",
"@ c #D58A30",
"# c #F09F3E",
"$ c #F9A847",
"% c #B2B2B2",
"& c #D0D0D0",
"* c None",
"***********&**&*****&***&*&***",
"**********%  XX  X  X  XXXX  &",
"*********&o &**************X *",
"********&o& &*************X+.*",
"*******&o&* &***********&o+$ *",
"******&o&** %**********&o+$$ &",
"*****&o&*** &**********X+$$$.&",
"****&o&**** &*********X+$$$$.*",
"***&o&***** &*******&o+$$$$$.*",
"**&o&****** &*******o@$$$$$$.&",
"*&o******** &******X+$$$$$$$.*",
"* ooooooooo oooooo.+$$$$$$$$.&",
"* &&&&&&&&& %&&&&%.$$$$$$$$$.*",
"& ********* &****&.$$$$$$$$$.&",
"& ********* &****&.$$$$$$$$$.*",
"* ********* &****&.$$$$$$$$$ *",
"* ********* &****&.#$$$$$$$$.*",
"& ********* %&&&&%.#########.&",
"* ********%Xoooooo.@@@@@@@@O.*",
"* *******%o&*****&.$#$$#$$@X&*",
"& ******%o*******&.$#$$$$@X&**",
"* *****%o********&.$$$$$#X&***",
"* ****%o*********&.$$$$@X&****",
"& ***%o**********&.$$$@X&*****",
"* **%o***********&.$$@X&******",
"* *%o&***********&.$#X&*******",
"& %o*************&.@X&********",
"* o**************& X&*********",
"*    X XX X X  XX  &**********",
"*&*****&**&****&**&***********"
]

plot_ydown = [
"30 30 16 1 ",
"  c #040404",
". c #313131",
"X c #555555",
"o c gray43",
"O c #02A24D",
"+ c #32B46F",
"@ c #41B979",
"# c #51BF84",
"$ c #74CC9D",
"% c #B3B3B3",
"& c #93D7B3",
"* c #A4DEBF",
"= c #B4E4CA",
"- c #D1D1D1",
"; c #CDEDDC",
": c None",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::-%::;*:::;---:::::::----::",
":::%.XX:#O;:::.  o:::::%   -::",
":::X%: :#O;:::-   %:::;.  %:::",
":::.%: -#O;::::%  .:::o  o::::",
":::X%; :#O;:::::o  o:-  X:::::",
":::-.Xo:#O;::::::.  -. .;:::::",
"::::--::#O;::::::;     ;::::::",
"::::::::#O;:::::::-   %:::::::",
"::::::::#O;::::::::   ;:::::::",
"::::::::#O;::::::::   ::::::::",
"::::::::#O;::::::::   -:::::::",
"::::::::#O;::::::::   ::::::::",
"::::::;;@O*;:::::::...::::::::",
"::::::$OOOOO;:::::::::::::::::",
":::::::OOOO$::::::::::::::::::",
":::::::&OOO:::::::::::::::::::",
"::::::::+O*:::::::::::::::::::",
"::::::::=+::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::"
]

nxdata_remove = [
"30 30 21 1 ",
"  c #7B4F4F",
". c #B32B2C",
"X c #F90505",
"o c #DF2D2D",
"O c #A05656",
"+ c #DF595A",
"@ c #01A24C",
"# c #29B068",
"$ c #50BE84",
"% c #5EC48D",
"& c #66C693",
"* c #B4B4B4",
"= c #DF8D8D",
"- c #92D7B2",
"; c #A7DEC1",
": c #B9E5CE",
"> c #CDCCCC",
", c #F2D5D5",
"< c #CBECDA",
"1 c #DAF1E5",
"2 c None",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"2222::<<<222222222222222222222",
"2221@@@@@:22222222222222222222",
"2222@-<<<222222222222222222222",
"2222@&<12222222222222222222222",
"2222@@@%2222222222222222222222",
"2221@-11222,2222222,,222222222",
"2222@&:<22oX=2222,+X+222222222",
"2222@@@%21+XX=221+XX=122222222",
"2222@-1222>.XX+,oXXO;122222222",
"2222@&;<221>.XXoXX *2222222222",
"2222@@@&2222>.XXX *12222222222",
"2222@-122222,oXXX+,22222222222",
"2221@&;<222,oXX.XX+12222222222",
"2221@@@&22,oXX *.XX+,222222222",
"2222@-2222oXo >1>OXX+222222222",
"2222@&-:21+o >222>OoO122222222",
"2222@@@&22>*>22222,*<222222222",
"2222@-2222222222222222221-2222",
"2221@&222222222222222222;@2222",
"2222@&2221#<1#<1#1<#1:#2;@2222",
"2221@&2221@:1@:<@1<@1:@1;@1222",
"2221@###$$@$%@%$@%$@&$@%$@1222",
"2222@@@@@#################2222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222"
]

plot_window_image = [
"30 30 22 1 ",
"  c #030707",
". c #2E2F31",
"X c #1C6231",
"o c #656A2C",
"O c #653D51",
"+ c #106055",
"@ c #A92720",
"# c #AB6826",
"$ c #D24425",
"% c #29883D",
"& c #6F923A",
"* c #1E9754",
"= c #2EAB49",
"- c #54B048",
"; c #A0A333",
": c #D4922A",
"> c #355692",
", c #22A68B",
"< c #B9BBBB",
"1 c #BFC0C0",
"2 c #CFCFCF",
"3 c None",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"3<22122222222222222222222222<3",
"322222322213222233333333333322",
"222322323223223233333333333332",
"3<212<11<2<22<<2<22<22<<2221<3",
"322323333323323333233233233323",
"3333332<     XX       <2332233",
"3332322<    ---X      <3323323",
"3232333<   X&;oo#;->  <3333233",
"3332332<   Xooo@@@#=, <2223333",
"3233233<  XXoo@@@$$&,,13333223",
"3332332< + X&#.@@@#;*,<3333233",
"3233233< .Xoo#@$@@;-*,<3223323",
"32233321 +XX##$$@#;==-13332323",
"3333233< XX&;:#@#:-===<3233333",
"3322233< %%&;;;;;&-=*O<3233323",
"3233332<+*%X&;;&%==-*.<3332233",
"3333332<+++X%%**=-**> 23233323",
"2322233< +,+*-=*-*+O  <3332333",
"3333233<  +,=*+*+.    <3323323",
"3223332<              <2332233",
"33323231......O&......22333233",
"322333233223333333323323232333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333"
]

zoom_back = [
"30 30 24 1 ",
"  c #503C43",
". c #5E4F55",
"X c #73696E",
"o c #FE0404",
"O c #F72F30",
"+ c #957275",
"@ c #F85B5D",
"# c #987A85",
"$ c #7AD3F5",
"% c #9B9094",
"& c #A59AA0",
"* c #B1AAAE",
"= c #FF9797",
"- c #C9B8BD",
"; c #A6B8C8",
": c #BBC2C6",
"> c #91D8F4",
", c #A7DDF3",
"< c #B8E2F4",
"1 c #D5CFD3",
"2 c #F6D7D8",
"3 c #E2DDE0",
"4 c #D0E8F4",
"5 c None",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555522555555555555",
"555555555555555@oO555555555555",
"555555555:*;1@OooO255555555555",
"5555553&%**@ooooooooO@55555555",
"555553%:,>-oooooooooooo=555555",
"55555%1<,>>#oooooooooooo=55555",
"5555*14<,,>$;OoooOooooooo25555",
"5555*34<,,>>$$+ooO552-@oo@5555",
"55531444<,,>>,<-oO555552Oo2555",
"555333544<,,,,<<XX5555552@=555",
"5553135444<4<<<<X%55555552@555",
"5555&54444444444.*55555555=555",
"5555&1554444444*.1355555552555",
"55555%135545341.+*135555555555",
"555553%135545&X..%&-3555555555",
"5555553%&&&%+X*: .+%-135555555",
"5555555531**15553X X%*13555555",
"555555555555555555% .#&-155555",
"5555555555555555555* .+%-13555",
"555555555555555555553X X%*1555",
"5555555555555555555555% .&5555",
"55555555555555555555555-X55555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555"
]

math_amplitude = [
"30 30 17 1 ",
"  c #000000",
". c #060606",
"X c gray6",
"o c #161616",
"O c #292929",
"+ c #4C4C4C",
"@ c #555555",
"# c #6F6F6F",
"$ c #8E8E8E",
"% c #B0B0B0",
"& c #C2C2C2",
"* c #CCCCCC",
"= c #D6D6D6",
"- c #E9E9E9",
"; c #F3F3F3",
": c #F9F9F9",
"> c None",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>-&>>>>>>;**;>>>>>>&->>>>>",
">>>>>&+>>>>>>#  #>>>>>>+&>>>>>",
">>>>>&+>>>>>>o. o>>>>>>+&>>>>>",
">>>>>&+>>>>>% OO %>>>>>+&>>>>>",
">>>>>&+>>>>>@.$$ @>>>>>+&>>>>>",
">>>>>&+>>>>-..-;..->>>>+&>>>>>",
">>>>>&+>>>>$ +>>+ $>>>>+&>>>>>",
">>>>>&+>>>>O %>>% O>>>>+&>>>>>",
">>>>>&+>>>* X;>>:o *>>>+&>>>>>",
">>>>>&+>>># #>>>:# #>>>@%>>>>>",
">>>>>&+>::o &>>>>& o;>>+&>>>>>",
">>>>>&+>:%  oOoOOO  %:>+&>>>>>",
">>>>>&+>>+          +:>+&>>>>>",
">>>>>&+>-. =>>>>>>-  ->+&>>>>>",
">>>>>&+>$ O>>>>>>>>+ #>+&>>>>>",
">>>>>&+>O $>>>>>>>>$ O>+&>>>>>",
">>>>>&+%  ->>>>>>>>-. &+&>>>>>",
">>>>>-*-*=>>>>>>>>>>=*-&->>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
]

shape_ellipse_solid = [
"30 30 11 1 ",
"  c #F7941E",
". c #F79A2A",
"X c #F8A23C",
"o c #F9AB4E",
"O c #FABA6F",
"+ c #FAC27F",
"@ c #FBCD96",
"# c #FCDAB0",
"$ c #FDE0BD",
"% c #FEEAD3",
"& c None",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&%%%%&&&&&&&&&&&&&",
"&&&&&&&&&$Oo      .o@%&&&&&&&&",
"&&&&&&&@.             O%&&&&&&",
"&&&&&%o                 +&&&&&",
"&&&&%.                   O&&&&",
"&&&&X                     @&&&",
"&&&#                      .&&&",
"&&&O                       %&&",
"&&&O                       %&&",
"&&&@                       &&&",
"&&&&.                     +&&&",
"&&&&%                    o&&&&",
"&&&&&$.                 O&&&&&",
"&&&&&&&O.             X#&&&&&&",
"&&&&&&&&%@o       ..O#&&&&&&&&",
"&&&&&&&&&&&&%####%%&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&"
]

_d_plane_normal_y = [
"30 30 24 1 ",
"  c #372A1A",
". c #5C491E",
"X c #524B44",
"o c #666360",
"O c #B21F1E",
"+ c red",
"@ c #8B612D",
"# c #F0791E",
"$ c #F25F53",
"% c #008000",
"& c #58AC58",
"* c #BD8523",
"= c #DD9A2A",
"- c #D89338",
"; c #F59131",
": c #E59743",
"> c #F9A847",
", c #3131AA",
"< c #1616FF",
"1 c #A9979B",
"2 c #AEADAD",
"3 c #BCB1D2",
"4 c #DCD7DB",
"5 c None",
"55555555555&555555555555555555",
"55555555554%&55555555555555555",
"55555555554%&55555555555555555",
"55555555554%&55555555555555555",
"55555555554%&55555555555555555",
"55555555554%&55555555555555555",
"55555555554%&55555555555555555",
"55555555554%&55555555555555555",
"55555555554%&55555555555555555",
"55555555554%&55555555555555555",
"55555555554% XXXXXXXXXXXXXXXo5",
"5555555554 .*----:-:--:---- 25",
"555555555X@*=>>>>>>>>>>>>: 255",
"55555555X*===>>>>>>>>>>>: 2555",
"5555555X@>>*=>>>>>>>>>>: 25555",
"555555X@>>=*=>>>>>>>>>> 255555",
"55554X@>>>:*=>;>>>;>>; 2555555",
"5555X@>>>>>=#;;;;;;;; O$$$$$$4",
"555X@>>>>>:-#;###;## ++++++++$",
"55.@>>>>>-$$::;>;;; 1444444445",
"5X @@@@@.X.X@@@@@@ 15555555555",
"4212223o,,11122222455555555555",
"5555553<<555555555555555555555",
"555553<<4555555555555555555555",
"55553<<45555555555555555555555",
"5553<<455555555555555555555555",
"553<<4555555555555555555555555",
"54<<45555555555555555555555555",
"4<<455555555555555555555555555",
"535555555555555555555555555555"
]

view_refresh = [
"30 30 23 1 ",
"  c #04A754",
". c #28B46C",
"X c #43BD7E",
"o c #F7941E",
"O c #F79929",
"+ c #F8A23C",
"@ c #F9AA4C",
"# c #FAB869",
"$ c #FBC17C",
"% c #47BF81",
"& c #54C38B",
"* c #67CA97",
"= c #75D0A1",
"- c #8FD8B3",
"; c #A0DEBE",
": c #FBCC93",
"> c #FCD9AF",
", c #FDE1BF",
"< c #A3DFC0",
"1 c #B3E4CB",
"2 c #CFEEDE",
"3 c #FDE8CF",
"4 c None",
"444444444444444444444444444444",
"4444444444<*.   .%-24444444444",
"44444444*           &244444444",
"444444<               -4444444",
"44444*                 &444444",
"4444*          X&X      *444<2",
"444-        &2444442&    <4* 2",
"442        14444444441.   .  4",
"44.       2444444444442.     4",
"41       -4444444444-X       4",
"4= .    .44444444444X       .4",
"4331&   1444444444444X      .4",
"43O3442-44444444444444&     &4",
"4>oO>444444444444444444&    *4",
"4:ooO$444444444444444444*   -4",
"4:oooO@444444444444444444&  ;4",
"4$ooooO+444444444444444444& 14",
"4#ooooooO3444444444444:3444&24",
"4@oooooO#344444444444,OOo#>444",
"4@oooo+34444444444444@oOoooO#4",
"4+oooo#4444444444444:OoooooO>4",
"4OO#OoO#44444444444>OooooooO44",
"4#34#OOO@344444444:OooooooO344",
"44444Ooooo#34443:+Oooooooo:444",
"444443OOoooOOOoOOoooooooO#4444",
"4444443OoooooooooooooooO:44444",
"44444443@OoooooooooooOO,444444",
"444444444>@OooooooOOO:44444444",
"444444444443>#@+@@:34444444444",
"444444444444444444444444444444"
]

document_print = [
"30 30 16 1 ",
"  c gray1",
". c #070707",
"X c gray5",
"o c #121212",
"O c #303030",
"+ c gray27",
"@ c #575757",
"# c #6C6C6C",
"$ c gray53",
"% c #AAAAAA",
"& c #B6B6B6",
"* c #D0D0D0",
"= c #E9E9E9",
"- c #F4F4F4",
"; c #F9F9F9",
": c None",
"::::::::::-::;::-;:;::::::::::",
"::::::::;============;::::::::",
"::::::::&XOOoOOOOOOOX&::::::::",
"::::::::&@;:::;-:;-:@&::::::::",
"::::::::&@::::::::::@&::::::::",
"::::::::&@::::::::::@&::::::::",
"::::::::&@::::::::::@&::::::::",
"::::::::&@::::::::::@&::::::::",
"::::::::&@::::::::::@&::::::::",
":::::::;&@::::::::::@&::::::::",
":::&@+++OoOOOOOOOOOOoO+++@&:::",
"::=         .  .        #O.=::",
"::*                    @:= *::",
"::*                    O*# *::",
"::*                        *::",
":-*                        *::",
"::*                        *-;",
"::*                        *::",
"::*     XooXXoooXoooo      *::",
"::*      =*==**==**=%X     *::",
"::=.    O:*&&&&&&&&*-X     =::",
":::%+OOo#:#@@@@@@@@#:OOOO+&:::",
":::::::@&;::::::::::;$#:::::::",
"::::::;O=::::::::::::*+:::::::",
"::::::=O;OoXXXoXXXoXO:o-::::::",
"::::::%@::::::::::::;;@&::::::",
"::::::#O@####@##@#####O#::::::",
"::::::*%%%%%%%%%%%%%%%%*::::::",
"::::::::::::::::::::::::::::::",
"::::::::::::::::::::::::::::::"
]

draw_brush = [
"30 30 24 1 ",
"  c #0A0A0A",
". c #323232",
"X c #514034",
"o c #505050",
"O c #7A704A",
"+ c #717171",
"@ c #E7753D",
"# c #B1705D",
"$ c #D17450",
"% c #F3A62E",
"& c #F3A92A",
"* c #FDC911",
"= c #FFD920",
"- c #B39C67",
"; c #D0985B",
": c #CFC26C",
"> c #807F81",
", c #908F90",
"< c #AEA093",
"1 c #B2B2B2",
"2 c #CBBAA1",
"3 c #D2D2D1",
"4 c #E1C9C9",
"5 c None",
"555555555555555555555555555555",
"555555555553555555555555555555",
"555555555311155555555555555555",
"555555555,<>135555555555555555",
"555555555,1,115555555555555555",
"555555555,,,115555555555555555",
"555555555<>,,11555555555555555",
"5555555551+>,,<555555555555555",
"5555555555+++,,555555555555555",
"5555555555,o+>>555555555555555",
"55555555553oo++555555555555555",
"55555555555+oo+355555555555555",
"555555555553ooo355555555555555",
"555555555555+oo,55555555555555",
"555555555555+..o,1355555555555",
"555555555553...o,<1>5555555555",
"5555555555,. .+++o+33555555555",
"555555555+      ...51555555555",
"555555553.       ..o,555555555",
"555555555o      XOOO-555555555",
"555555555+   X#%***%-355555555",
"5555555551 X$@%%&***;255555555",
"5555555554#@@%%%&***=:55555555",
"5555555555$@@@;%&***=:55555555",
"5555555555#$;$%%&&**=:55555555",
"55555555552##$;%&&*&-<55555555",
"55555555554#$#;;<<,15555555555",
"55555555555<,<1155555555555555",
"555555555555455555555555555555",
"555555555555555555555555555555"
]

previous = [
"30 30 20 1 ",
"  c #092B39",
". c #20343C",
"X c #0E3151",
"o c #27394B",
"O c #1B3967",
"+ c #233E71",
"@ c #354349",
"# c #284278",
"$ c #5C6572",
"% c #354B8D",
"& c #495AA7",
"* c #5461A2",
"= c #5765B8",
"- c #6B75CD",
"; c #7D84DC",
": c #999CAC",
"> c #A2A5DD",
", c #8B8FE6",
"< c #CCCDE3",
"1 c None",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"11111111111111111111111:111111",
"111111111111111111111<@ 111111",
"11111111111111111111$.  111111",
"111111111111111111:@   .111111",
"1111111111111111<*.     111111",
"111111111111111:+XX    .111111",
"1111111111111<%++OX     111111",
"111111111111,&%%+OX     111111",
"1111111111<-*&&%#+OX   .111111",
"11111111<,--==&%%+OX   .111111",
"1111111<,,;-==&%%#+X    111111",
"111111<,,,---==&%%+X    111111",
"11111111>,;;--=&%%+OXX  111111",
"1111111111,--==&&%%OXX .111111",
"11111111111<--==&%%+XX .111111",
"1111111111111>==&%%#OXX.111111",
"11111111111111<,*&%#+OX.111111",
"1111111111111111<*%%+OXo111111",
"111111111111111111:%#OXo111111",
"11111111111111111111*+Oo111111",
"111111111111111111111<$o111111",
"11111111111111111111111:111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111"
]

last = [
"30 30 21 1 ",
"  c #012738",
". c #0E3050",
"X c #1B1B7A",
"o c #1B3A67",
"O c #223D69",
"+ c #3C494E",
"@ c #29427A",
"# c #586177",
"$ c #354C8D",
"% c #4A5BA8",
"& c #5360A0",
"* c #5664B8",
"= c #5F6CC1",
"- c #6D75CC",
"; c #7C83DC",
": c #94989A",
"> c #9396A8",
", c #A8AAAC",
"< c #999CDC",
"1 c #D1D1E2",
"2 c None",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222221122222222222222222222222",
"22222: #2222222222222222222222",
"22222:   :2222222222222X222222",
"22222:    +122222222222X222222",
"22222:     +#2222222222X222222",
"22222:     .o+,22222222X222222",
"22222:     .oO$=1222222X222222",
"22222:     .O@$&%<22222X122222",
"22222:    .o@$$$**-1222X222222",
"22222,   ..o@$%%*=--<22X222222",
"22222:   .oo$$$*=--;<;1X222222",
"22222:  ..oo$$%*----;<<X122222",
"22222,  ..o@$$%*=-;<<12X122222",
"22222,  .oo$$%%=--;<122X222222",
"22222:  .o@$$%*=-<12222X222222",
"22222, .oO@$%%*=<222222X222222",
"22222, .o@$$%&<22222222X122222",
"22222,..o@$$=1222222222X222222",
"22222,..O$&,22222222222X222222",
"22222,.o@>2222222222222X222222",
"22222,.#122222222222222>222222",
"222221122222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222"
]

compare_align_stretch = [
"30 30 17 1 ",
"  c #010201",
". c #252C0F",
"X c #3B451B",
"o c #5E6E27",
"O c #686868",
"+ c #768A31",
"@ c #8DA53A",
"# c #B8D84C",
"$ c #D4F958",
"% c #DBD472",
"& c #D9E467",
"* c #FE04FC",
"= c #F828E4",
"- c gray65",
"; c #E5989A",
": c #E2AD8C",
"> c None",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>-OOOOOOOOOOOOOOOOOOOOOO->>>",
">>>O XXXXXXXXXXXXXXXXXXXX O>>>",
">>>OX$:%%%%$$$$$$$$%%%:%&XO>>>",
">>>OX&****:$$$$$$$$&=***;XO>>>",
">>>OX&***:$$$$$$$$$$&=**;XO>>>",
">>>OX&**:$#####$$$$$$&=*;XO>>>",
">>>OX&*:$$       X@$$$&=;XO>>>",
">>>OX&:$$&         #$$$&:XO>>>",
">>>OX$$$$$   #$#.  +$$$$$XO>>>",
">>>OX$$$$$   #$$X  +$$$$$XO>>>",
">>>OX$$$$$   +@o   #$$$$$XO>>>",
">>>OX$$$$$        @$$$$$$XO>>>",
">>>O.$$$$$   ...   @$$$$$XO>>>",
">>>OX$$$$$   #$$+  .$$$$$XO>>>",
">>>OX$$$$$   #$$#   $$$$$XO>>>",
">>>OX$$$$$   #$$o  .$$$$$XO>>>",
">>>OX&:$$$         o$$$%:XO>>>",
">>>OX&*;$$       .+$$$%=;XO>>>",
">>>OX&**:$#####$$$$$$&=*;XO>>>",
">>>OX&***;$$$$$$$$$$%=**;XO>>>",
">>>OX&****;$$$$$$$$%=***;XO>>>",
">>>OX$%%&%&$$$$$$$$&%&%%$XO>>>",
">>>O XXXXXXXXXXXXXXXXXXXX O>>>",
">>>-OOOOOOOOOOOOOOOOOOOOOO->>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
]

compare_keypoints = [
"30 30 14 1 ",
"  c #24211F",
". c #493115",
"X c #444342",
"o c #875B26",
"O c #FB7A79",
"+ c #F99C54",
"@ c #F9A847",
"# c #FA8969",
"$ c #FC5D99",
"% c #FB6C89",
"& c #FC4CAC",
"* c #FD31CA",
"= c #FF03FB",
"- c None",
"------------------------------",
"------------------------------",
"--X                        X--",
"-- .oooooooooooooooooooooo. --",
"-- o@@@@@@@@@@@@@@@@@@@@@@o --",
"-- o@@@@@@@@@@@@@@@@@@@@@@o --",
"-- o@@@@@@@@@@@@@@@@@@@@@@o --",
"-- o@@@@@@@@@@@@@@@@@@@@@@o --",
"-- o@@@*=%@@@@@@@@@@@@@@@@o --",
"-- o@@%===+@@@@@@@@@@@@@@@o --",
"-- o@@O===+@@@@@@@@@@@@@@@o --",
"-- o@@+%&O@@@@@@@@@@@@@@@@o --",
"-- o@@@@@@@@@@@@@@@@@@@@@@o --",
"-- o@@@@@@@@@@@O$#@@@@@@@@o --",
"-- o@@@@@@@@@@#===@@@@@@@@o --",
"-- o@@@@@@@@@@%===+@@@@@@@o --",
"-- o@@@@@@@@@@@*=&@@@@@@@@o --",
"-- o@@@@@@O&#@@@+@@@@@@@@@o --",
"-- o@@@@@#===+@@@@@@@@@@@@o --",
"-- o@@@@@%===#@@@@@@@@@@@@o --",
"-- o@@@@@@*=&@@@@@@@@@@@@@o --",
"-- o@@@@@@@@@@@@@@@@@@@@@@o --",
"-- o@@@@@@@@@@@@@@@@@@@@@@o --",
"-- o@@@@@@@@@@@@@@@@@@@@@@o --",
"-- o@@@@@@@@@@@@@@@@@@@@@@o --",
"-- o@@@@@@@@@@@@@@@@@@@@@@o --",
"-- .oooooooooooooooooooooo. --",
"--X                        X--",
"------------------------------",
"------------------------------"
]

compare_align_origin = [
"30 30 17 1 ",
"  c #090803",
". c #221E0D",
"X c #282E10",
"o c #323232",
"O c #45321B",
"+ c #3A4417",
"@ c #546323",
"# c #686868",
"$ c #70832E",
"% c #819735",
"& c #95AE3E",
"* c #A2BD43",
"= c #FAB058",
"- c #B3D24A",
"; c #D4F958",
": c gray65",
"> c None",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>#oooooooooooooooooo####:>>>",
">>>o XXXXXX.XXXXXXXX. OOO #>>>",
">>>oX;;;;;;;;;;;;;;;% ===O#>>>",
">>>oX;;-%%%%%&-;;;;;%.===O#>>>",
">>>oX;;&       .*;;;% ===O#>>>",
">>>oX;;&   ++   .;;;% ===O#>>>",
">>>oX;;&  X;;-   -;;% ===O#>>>",
">>>oX;;&  .;;;   -;;% ===O#>>>",
">>>oX;;&   ++   @;;;%.===O#>>>",
">>>oX;;&        *;;;% ===O#>>>",
">>>oX;;&   $$@   *;;% ===O#>>>",
">>>oX;;&  X;;;@  @;;%.===O#>>>",
">>>oX;;&  X;;;@  @;;% ===O#>>>",
">>>oX;;&   %&@   @;;%.===O#>>>",
">>>oX;;&        X;;;% ===O#>>>",
">>>oX;;*+++X++@%;;;;% ===O#>>>",
">>>oX;;;;;;;;;;;;;;;% ===O#>>>",
">>>o.%%%%%%%%%%%%%%%@.===O#>>>",
">>>o   . . .  .   .  .===O#>>>",
">>>#O====================O#>>>",
">>>#O====================O#>>>",
">>>#O====================O#>>>",
">>># OOOOOOOOOOOOOOOOOOOO #>>>",
">>>:######################:>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
]

shape_circle_solid = [
"30 30 11 1 ",
"  c #F7941E",
". c #F79928",
"X c #F8A33E",
"o c #F9AC51",
"O c #FAB96C",
"+ c #FAC27E",
"@ c #FBC98D",
"# c #FCD5A7",
"$ c #FDE0BE",
"% c #FEEDD9",
"& c None",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&%@o. Xo@%&&&&&&&&&&",
"&&&&&&&&&&+         @&&&&&&&&&",
"&&&&&&&&%o           o&&&&&&&&",
"&&&&&&&&o             O&&&&&&&",
"&&&&&&&@               #&&&&&&",
"&&&&&&%                X&&&&&&",
"&&&&&&#                 $&&&&&",
"&&&&&&O                 +&&&&&",
"&&&&&&o                 O&&&&&",
"&&&&&&X                 o&&&&&",
"&&&&&&o                 O&&&&&",
"&&&&&&O                 @&&&&&",
"&&&&&&%                 %&&&&&",
"&&&&&&&X               o&&&&&&",
"&&&&&&&$              .%&&&&&&",
"&&&&&&&&@             #&&&&&&&",
"&&&&&&&&&#          .#&&&&&&&&",
"&&&&&&&&&&%O       O%&&&&&&&&&",
"&&&&&&&&&&&&%#@O@#&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&"
]

compare_align_center = [
"30 30 15 1 ",
"  c #010100",
". c #1C200B",
"X c #2C3312",
"o c #45321B",
"O c #394317",
"+ c #4F5C21",
"@ c #686868",
"# c #778C31",
"$ c #8AA239",
"% c #C38945",
"& c #EEA854",
"* c #B2D149",
"= c #CCEF54",
"- c gray65",
"; c None",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;-@@@@@@@@@@@@@@@@@@@@@@-;;;",
";;;@.oooooooooooooooooooo @;;;",
";;;@o&%%%%%%%%%%%%%%%%%%&o@;;;",
";;;@o%                  %o@;;;",
";;;@o% **===*=*==*==*=* %o@;;;",
";;;@o% ================ %o@;;;",
";;;@o% *==      .O*==== %o@;;;",
";;;@o% ===.        *=== %o@;;;",
";;;@o% ===   *=*.  $===.%o@;;;",
";;;@o% ===   *==+  $=== %o@;;;",
";;;@o% ===   #$#   *==* %o@;;;",
";;;@o% ===        $===* %o@;;;",
";;;@o% ===   XO.  .*=== %o@;;;",
";;;@o% ===.  ===$  X=== %o@;;;",
";;;@o% *==   *==*   === %o@;;;",
";;;@o% ===   *=*+  .=== %o@;;;",
";;;@o% *==         $=== %o@;;;",
";;;@o% ===.     .O$====.%o@;;;",
";;;@o% *=============== %o@;;;",
";;;@o% *=**=*=*====**=* %o@;;;",
";;;@o%                  %o@;;;",
";;;@o&%%%%%%%%%%%%%%%%%%&o@;;;",
";;;@.oooooooooooooooooooo @;;;",
";;;-@@@@@@@@@@@@@@@@@@@@@@-;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
]

cube_left = [
"30 30 9 1 ",
"  c #100F0F",
". c #362818",
"X c #393736",
"o c #B37A36",
"O c #D18D3C",
"+ c #F9A847",
"@ c #B7B7B7",
"# c #D0D0D0",
"$ c None",
"$$$$$$$$$$$#$$$#$$$$$#$$$$$##$",
"$$$$$$$$$$#    . .   . .  X  $",
"$$$$$$$$$#. #$$$$$$$$$$$$$$X #",
"$$$$$$$$#.O #$$$$$$$$$$$$#X@ $",
"$$$$$$$#.O+ #$$$$$$$$$$$$X#$ #",
"$$$$$$#.O++ #$$$$$$$$$$#X@$$ $",
"$$$$$#.O+++ #$$$$$$$$$$X@$$$ $",
"$$$$#.O++++ #$$$$$$$$$X@$$$$ #",
"$$$#.O+++++ @$$$$$$$#X#$$$$$ $",
"$$#.O++++++ #$$$$$$$X#$$$$$$ $",
"$#.O+++++++ #$$$$$$X@$$$$$$$ #",
"$ ......... XXXXXX @$$$$$$$$ $",
"$ OOoOOOOOo @####@ $$$$$$$$$ #",
"# +++++++++ @$$$$# $$$$$$$$$ $",
"# +++++++++ #$$$$# $$$$$$$$$ #",
"$ +++++++++ #$$$$# $$$$$$$$$ $",
"$ +++++++++ #$$$$# $$$$$$$$$ $",
"# +++++++++ @####@ ######### #",
"$ ++++++++o.XXXXXX XXXXXXXXX $",
"$ +++++++oX#$$$$$# $$$$$$$#X#$",
"$ ++++++oX$$$$$$$# $$$$$$#X#$$",
"# +++++o.$$$$$$$$# $$$$$#X#$$$",
"$ ++++o.$$$$$$$$$# $$$$#X#$$$$",
"# +++oX#$$$$$$$$$# $$$#X#$$$$$",
"$ ++oX#$$$$$$$$$$# $$#X#$$$$$$",
"$ +o.$$$$$$$$$$$$# $#X#$$$$$$$",
"$ o.$$$$$$$$$$$$$# #X#$$$$$$$$",
"# X#$$$$$$$$$$$$$# X#$$$$$$$$$",
"$   . . .  X . X.  #$$$$$$$$$$",
"$#$$$$#$$$#$$$$#$$#$$$$$$$$$$$"
]

_d_plane = [
"30 30 24 1 ",
"  c #17140D",
". c #2C231A",
"X c #023C21",
"o c #4E2C16",
"O c #694B26",
"+ c #686462",
"@ c #D8230F",
"# c #9B6728",
"$ c #F1781C",
"% c #D9744F",
"& c #349834",
"* c #BE8036",
"= c #DA9928",
"- c #D79430",
"; c #F79131",
": c #E29344",
"> c #F8A747",
", c #6B6BBB",
"< c #0707F5",
"1 c #A5A7A4",
"2 c #E6B0A8",
"3 c #ADADFE",
"4 c #D3D6CD",
"5 c None",
"555555555541455555555555555555",
"55555555554&&55555555555555555",
"55555555554&&55555555555555555",
"55555555554X&55555555555555555",
"55555555554X.55555555555555555",
"55555555554XOo5555555555555555",
"55555555551 =O.555555555555555",
"5555555555+O=>o+55555555555555",
"5555555555 #=>>O+5555555555555",
"5555555554 ==>>=O+555555555555",
"555555555+#*=>>>;.155555555555",
"555555555 -==>>>>- 15555555555",
"555555554.===>>>>>- 1555555555",
"55555555+#===>>>>>>: 155555555",
"55555555.=>==>>>>>>>: 25555555",
"55555554.>===>>>>>>>>% 4555555",
"5555555+#>:*=>>>>>;>>>#.255555",
"5555555.:>>-=;;;;;;;;;;#.%%%%4",
"5555554.>>:*$$$$$$$;$$$O o@@@2",
"555555+#::%%->;;;;;;#o O222225",
"555555 -:%*>>>>>:#O O155555555",
"555554.:*%:>>>-O.O155555555555",
"55555+#%%:>*O..155555555555555",
"55555 **:#..145555555555555555",
"5555, O..+45555555555555555555",
"5553  +35555555555555555555555",
"553<<3555555555555555555555555",
"53<<35555555555555555555555555",
"5<<355555555555555555555555555",
"533555555555555555555555555555"
]

pan = [
"30 30 15 1 ",
"  c #000000",
". c #060606",
"X c gray11",
"o c #232323",
"O c #2D2D2D",
"+ c #373737",
"@ c #494949",
"# c #707070",
"$ c gray54",
"% c #ACACAC",
"& c #CFCFCF",
"* c #ECECEC",
"= c #F3F3F3",
"- c #FAFAFA",
"; c None",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;&*;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;@#=;;;;;;;;;;;;;",
";;;;;;;;;;;;;%  &;;;;;;;;;;;;;",
";;;;;;;;;;;;=o  O-;;;;;;;;;;;;",
";;;;;;;;;;;-$    $;;;;;;;;;;;;",
";;;;;;;;;;;*++..O@=;;;;;;;;;;;",
";;;;;;;;;;;;;;oo;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;oo;;;;;;;;;;;;;;",
";;;;;;;;=;;;;;oo;;;;;=;;;;;;;;",
";;;;;;-$+;;;;;oo;;;;;+#-;;;;;;",
";;;;;&O +;;;;;oo;;;;;+.O&=;;;;",
";;;*#   .ooooo..oXooo.   #*;;;",
";;;&@   .oXooo..ooooo.   @&;;;",
";;;;;%o O;;;;;oo;;;;;+ X%--;;;",
";;;;;;;$@;;;;;oo;;;;;+#-;;;;;;",
";;;;;;;;*;;;;;oo;;;;;=;;;;;;;;",
";;;;;;;;;;;;;;oo;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;oo;;;;;;;;;;;;;;",
";;;;;;;;;;;=++..++=;;;;;;;;;;;",
";;;;;;;;;;;;$    $;;;;;;;;;;;;",
";;;;;;;;;;;;=o  O-;;;;;;;;;;;;",
";;;;;;;;;;;;;%  &;;;;;;;;;;;;;",
";;;;;;;;;;;;;;@#--;;;;;;;;;;;;",
";;;;;;;;;;;;;;&*;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
]

stats_visible_data = [
"30 30 14 1 ",
"  c black",
". c #343434",
"X c #F7941E",
"o c #F79826",
"O c #F8A33D",
"+ c #F9AC51",
"@ c #F9B86C",
"# c #B4B4B4",
"$ c #FAC98F",
"% c #FBD5A8",
"& c #FDE0BE",
"* c #D1D1D1",
"= c #FEECD7",
"- c None",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"-------################-------",
"------= .............. =--=---",
"------- -------------- --***--",
"------- -------------- =****--",
"------* -------------- ****=--",
"------= -------------- #***---",
"------- -------------$ ***----",
"------* ------------%X *------",
"------- o@=--------&oo *------",
"------= XXo$------=oXX *------",
"------* XXXo+=---=oXXo =------",
"-----** XXXXXo%-=+XXX% =------",
"----=** @=OXXXo++XXX$- -------",
"----**# ---$XXXXXXX@-- =------",
"---**** ----=OXXXX+--- -------",
"--***** ------$oX+---- =------",
"--***-- -------=%----- -------",
"--***-* -------------- =------",
"---=--- .............. -------",
"-------################-------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------"
]

plot_xlog = [
"30 30 17 1 ",
"  c #050505",
". c #313131",
"X c #4B4B4B",
"o c #717171",
"O c #07A450",
"+ c #30B36D",
"@ c #47BB7D",
"# c #6AC896",
"$ c #999999",
"% c #AFAFAF",
"& c #8FD6B0",
"* c #A1DCBD",
"= c #BBE6CF",
"- c #D2D2D2",
"; c #C5EAD6",
": c #DBF2E5",
"> c None",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>> X>>>>>>>>>>>>>>>>>>>>>",
">>>>>>: .>>>>>>>>>>>>>>>>>>>>>",
">>>>>>: .>>>>-$->>>%%-%>>>>>>>",
">>>>>>> .>>>$   %>$    ->>>>>>",
">>>>>>: X>>> .: .>. -  :>>>>>>",
">>>>>>: .>>: X>. : .>X :>>>>>>",
">>>>>>> .>>- X>. - X>X ->>>>>>",
">>>>>>: .>>: .> .>  :. :>>>>>>",
">>>>>>>    -o   $>o    :>>>>>>",
">>>>>>>oooo:>$o$>>>$%X >>>>>>>",
">>>>>>>>>>>>>>>>>>:-% .>>>>>>>",
">>>>>>::>>>>>>>>>>o   $=>>>>>>",
">>>>>#O=>>>>>>>>>>:%%:>++;>>>>",
">>>*OOO#&&&&&&&&&&&&&&&+OO#:>>",
">>;OO@OOOOOOOOOOOOOOOOOO+OO#>>",
">>>>&OO=>>>>>>>>>>>>>>>+O+;>>>",
">>>>>:@=>>>>>>>>>>>>>>>@*>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
]

add_shape_horizontal = [
"30 30 12 1 ",
"  c #09A957",
". c #1CB164",
"X c #F7941E",
"o c #F79929",
"O c #55C38B",
"+ c #6CCC9A",
"@ c #92D9B5",
"# c #FCD4A4",
"$ c #B9E6CF",
"% c #CFEFDE",
"& c #D7F1E4",
"* c None",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"******************************",
"*****#####################****",
"*****oXXXXXXXXXXXXXXXXXXXX#***",
"*****oXXXXXXXXXXXXXXXXXXXo#***",
"*****#####################&***",
"******************************",
"**********************&%%*****",
"**********************$ .*****",
"**********************$ .*****",
"**********************$ .*****",
"*******************O        &*",
"*******************O     .  %*",
"*******************&%%@ .%%%**",
"**********************$ .*****",
"**********************$ .*****",
"**********************&+@*****",
"******************************",
"******************************"
]

shape_square = [
"30 30 17 1 ",
"  c #F7941E",
". c #F79725",
"X c #F8A33D",
"o c #F8A440",
"O c #F8A644",
"+ c #F8A847",
"@ c #FBC687",
"# c #FBC88B",
"$ c #FCDCB6",
"% c #FDE2C1",
"& c #FDEBD5",
"* c #FEEDD8",
"= c #FEEEDC",
"- c #FEF5EB",
"; c #FEF7ED",
": c #FFFCFA",
"> c None",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>%@@@@@@@@@@@@@@@@@@@->>>>",
">>>>>#                   *>>>>",
">>>>># .++++++++++++++o  *>>>>",
">>>>># O>>>>>>>>>>>>>>*  *>>>>",
">>>>># O>>>>>>>>>>>>>>*  *>>>>",
">>>>># O>>>>>>>>>>>>>>*  *>>>>",
">>>>># O>>>>>>>>>>>>>>*  *>>>>",
">>>>># O>>>>>>>>>>>>>>*  *>>>>",
">>>>># O>>>>>>>>>>>>>>*  *>>>>",
">>>>># O>>>>>>>>>>>>>>*  *>>>>",
">>>>># O>>>>>>>>>>>>>>*  *>>>>",
">>>>># O>>>>>>>>>>>>>>*  *>>>>",
">>>>># O>>>>>>>>>>>>>>*  *>>>>",
">>>>># O>>>>>>>>>>>>>>*  *>>>>",
">>>>># O>>>>>>>>>>>>>>*  *>>>>",
">>>>># O>>>>>>>>>>>>>>*  *>>>>",
">>>>># O>>>>>>>>>>>>>>*  *>>>>",
">>>>># X&&&&&&&&&&&&&&$  *>>>>",
">>>>>#                   *>>>>",
">>>>>#                   *>>>>",
">>>>>;===================:>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
]

view_2d = [
"30 30 11 1 ",
"  c black",
". c #271A0B",
"X c #442E13",
"o c #63431C",
"O c #754F21",
"+ c #494846",
"@ c #494948",
"# c #7E7E7E",
"$ c #AB7331",
"% c #F9A847",
"& c None",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&                         @&&",
"&& O$$$$$$$$$$$$$$$$$$$$$$X+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& $%%%%%%%%%%%%%%%%%%%%%%o+&&",
"&& Xoooooooooooooooooooooo.+&&",
"&&@++++++++++++++++++++++++#&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&"
]

view_text = [
"30 30 18 1 ",
"  c #0F0B06",
". c #251B0E",
"X c #352513",
"o c #383633",
"O c #4E3516",
"+ c #66451D",
"@ c #744F21",
"# c #747474",
"$ c #845926",
"% c #98672C",
"& c #B07732",
"* c #BE8036",
"= c #D28E3C",
"- c #E49A41",
"; c #F8A847",
": c #868686",
"> c #B5B5B5",
", c None",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,>oooooooooooooooooooooooo:,,",
",,: +@@@@+@@@@@@@@@@@@@@@@ :,,",
",,:.;;;;;;;;;;;;;;;;;;;;;;X#,,",
",,:.;;;;;;;;;;;;;;;;;;;;;;.:,,",
",,:.;;;;-=;;;;;;;;;;;;;;;;.:,,",
",,:.;;;;&@;;;;;;&$;;;;;;;;.:,,",
",,:.;;%$%@;&$$-;@X$-=@$=;;X:,,",
",,:.;$@=O@;&=&X;%+=-&==X;;.:,,",
",,:.;X-;%@;=@+ ;&@;;=@+ =;.:,,",
",,:.;.;;&@;X=;X-&@;;.=;O=;.:,,",
",,:.;@$-O@;.-& -=X=;.=* =;.:,,",
",,:.;;$@&*;&+%%-;&@=*+$&-;.:,,",
",,:.;;;;;;;;;;;;;;;;;;;;;;.:,,",
",,:.;;;;;;;;;;;;;;;;;;;;;;X#,,",
",,:.;;;;;;;;;;;;;;;;;;;;;;X:,,",
",,: XXXXXXXXXXXXXXXXXXXOXX :,,",
",,>########################>,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,"
]

normal = [
"30 30 15 1 ",
"  c #000000",
". c #0B0B0B",
"X c #1E1E1E",
"o c #272727",
"O c #505050",
"+ c #747474",
"@ c #8B8B8B",
"# c #9B9B9B",
"$ c #AEAEAE",
"% c #C8C8C8",
"& c #D4D4D4",
"* c #E9E9E9",
"= c None",
"- c None",
"; c None",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;-;--;;;;;;;;;;;;;;;;;;;;",
";;;;;;-=*=---;;;;;;;;;;;;;;;;;",
";;;;;--*&&&--;;;;;;;;;;;;;;;;;",
";;;;;;=&$-&&=-;;;;;;;;;;;;;;;;",
";;;;;;=%##$$&*-;;;;;;;;;;;;;;;",
";;;;;;=%## $%&*-;;;;;;;;;;;;;;",
";;;;;-=%@#  #$&=-;;;;;;;;;;;;;",
";;;;;-*%@#   #%&*--;;;;;;;;;;;",
";;;;;-=%##    @%&*-;;;;;;;;;;;",
";;;;;;=%@#     +&%*-;;;;;;;;;;",
";;;;;;-%@#      +&%*--;;;;;;;;",
";;;;;;=$@#       +&%*--;;;;;;;",
";;;;;;=%@#        +%%*-;;;;;;;",
";;;;;-=%@#         +&%*-;;;;;;",
";;;;;;*%@$          O&&=-;;;;;",
";;;;;;=%@#     .%&&&&-**-;;;;;",
";;;;;-*%@#  o@  #++@#$&*-;;;;;",
";;;;;;=%## X&%X X%#%&&*-;;;;;;",
";;;;;-*%@#X&++@  $$*-=--;;;;;;",
";;;;;-=%#$&##+&. o%&=-;;;;;;;;",
";;;;;;=&$*$%&##O  $%*-;;;;;;;;",
";;;;;;-&%%&**%@%  o&&=-;;;;;;;",
";;;;;;--**=--&#$O  $%*-;;;;;;;",
";;;;;;;----;-*$@$  O&&;;;;;;;;",
";;;;;;;;;-;;;=&#$+$&%*-;;;;;;;",
";;;;;;;;;;;;;-=$$$#$&=-;;;;;;;",
";;;;;;;;;;;;;;-*&%&*=-;;;;;;;;",
";;;;;;;;;;;;;;;-===--;;;;;;;;;",
";;;;;;;;;;;;;;;;-;;;;;;;;;;;;;"
]

plot_roi_between = [
"30 30 22 1 ",
"  c #181819",
". c #653D0E",
"X c #754D1E",
"o c #5D5E5F",
"O c #9D6728",
"+ c #C67E27",
"@ c #9F7749",
"# c #DB9036",
"$ c #B48D5F",
"% c #D9994E",
"& c #E69F48",
"* c #F5AE58",
"= c #CC9D65",
"- c #C7A073",
"; c #FAB96B",
": c #A5A6A7",
"> c #E1BA8C",
", c #F7C68B",
"< c #FCD5A6",
"1 c #CBCBCB",
"2 c #FDE9D1",
"3 c None",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333332<<<<<<<<<<<<233333333",
"33333333,&;;;;******&,33333333",
"33333333,;<<<,.X<<<<;,33333333",
"33333333,;<<<$XO$<<<;,33333333",
"33333333,;<<<X@@X<<<;,33333333",
"33333333,;<<,.$-.><<;,33333333",
"33333333,;<<=X--O$<<;,33333333",
"33333333,;<<X@--@X<<;,33333333",
"33333333;;>@X---$.><;,33333333",
"33333333,#XX$----X-<;,33333333",
"33333333,O$------@@<*@23333333",
"33333333,O$------@X<%Xo3333333",
"33333333,O$-------.;OO 3333333",
"33333333;O$-------X@O$ 2333333",
"3333333:O+--------$.+% 1333333",
"333333: @&----------%= :333333",
"333333 o=%----------%=oo333333",
"333332 :=&----------%=o ::3333",
"33333: :=%----------%=:   1333",
"33333 o:%&----=-----&%:o oo333",
"3****#*%&=,>,>>>>>>>*#&&&#+**3",
"322222222232323333232222222223",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333"
]

nxdata_axis_add = [
"30 30 18 1 ",
"  c #030303",
". c #323232",
"X c #555555",
"o c gray46",
"O c #00A14B",
"+ c #58C189",
"@ c #6DC998",
"# c #7DCFA4",
"$ c #969696",
"% c #B7B7B7",
"& c #87D2AA",
"* c #A3DDBE",
"= c #A6DEC0",
"- c #B4E3CA",
"; c #CCCCCC",
": c #CCECDB",
"> c #D9F1E4",
", c None",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,>,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,OOOOO-,,,,,,,,,,,,",
",,,,,,,,,,,,O+**=>,,,,,,,,,,,,",
",,,,,,,,,,,,O&>,,,,,,,,,,,,,,,",
",,,,,,,,,,,,OOO+,,,,,,,,,,,,,,",
",,,,,,,,,,,,O@=:,,,,,,,,,,,,,,",
",,,,,,,,,,,,O&>>,,,,,,,,,,,,,,",
",,,,,,,,,,,,OOO@,,,,,,,,,,,,,,",
",,,,,,,,,,,,O@-:,,,,,,,,,,,,,,",
",,,,,,,,,,,,O&>>,,,,,>,,,,,,,,",
",,,,,,,,,,,,OOO+,,,,; $,,,,,,,",
",,,,,,,,,,,,O#:>,,,,$ X,,,,,,,",
",,,,,,,,,,,,O@:>,,,,$ X>,,,,,,",
",,,,,,,,,,,,OOO+,;$$X .$$%,,,,",
",,,,,,,,,,,,O#>>>         ;,,,",
",,,,,,,,,,,,O@->,$XX. ..Xo>,,,",
",,,,,,,,,,,,OOO+,,>>$ X>>,,,,,",
",,,,,,,,,,,,O&>>,,,,$ X>,,,,,,",
",,,,,,,,,,,,O@-:,,,,% o,,,,,,,",
",,,,,,,,,,,,OOO+,,,,,%>,,,,,,,",
",,,,,,,,,,,,O&>,,,,,,,,,,,,,,,",
",,,,,,,,,,,,O@**=>,,,,,,,,,,,,",
",,,,,,,,,,,,OOOOO-,,,,,,,,,,,,",
",,,,,,,,,,,,,>>,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,",
",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,"
]

profile2D = [
"30 30 19 1 ",
"  c #0F0F0E",
". c #271E13",
"X c #2E2D2C",
"o c #4B3923",
"O c #534330",
"+ c #654A2A",
"@ c #4B4B4A",
"# c #655F57",
"$ c #6B6B6B",
"% c #A16823",
"& c #B27832",
"* c #BE8138",
"= c #D3882F",
"- c #ED9C3B",
"; c #F9A847",
": c #878787",
"> c #B5B5B5",
", c #CECECE",
"< c None",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<,,,,,,,,,,,,,,,,,<",
"<<<<<<<<<<>                 .<",
"<<<<<<<<<,X@,<<<<<<<<<<<<<$$X<",
"<<<<<<<<,X,@,<<<<<<<<<<<<$$,X<",
"<<<<<<<>X<<@,<<<<<<<<<<<$:<<X<",
"<<<<<<>X<<<@,<<<<<<<<<<$$<<,X<",
"<<<<<,@<<<<@,<<<<<<<<<$:<<<<X<",
"<<<<>X<<<<<@,<<<<<<<<$:<<<<,X<",
"<<<,X<<<<<<@,<<<<<<<$:<<<<<<X<",
"<<,X<<<<<<<@,<<<<<<$$<<<<<<,X<",
"<>X,,,,,,,,@>,,,,,#:<<<<<<<<X<",
"<                 X<<<<<<<<<X<",
"<.<<<<<<<<<@>>,,,:@,,,,,,,,>X<",
"< <<<<<<<<,.++o++o.+++++++o. <",
"< <<<<<<<,.%-;;;;&o;;;;;;;%XX<",
"<.<<<<<<,o*=-;;;;=o-;;;;;&@,X<",
"<X<<<<<,o*;=-;;--&+-;;;;&X<,X<",
"< <<<<<X*;-======%o====%X###X<",
"<.<<<<X*;--=-=-==%o=-=%.$$$ $<",
"<.<<<O&;;-=;;;;;;&o;-*o,<<#:<<",
"< <<X&;;;=;;;;;;;*o;=o<<<$:<<<",
"<.<X%;;-=;;;;;;;;*o=.<<<$:<<<<",
"<.@+*=*%*=**=**==%Xo,<<$$<<<<<",
"< #$#@.##########@.<<<$$<<<<<<",
"<.<<,X,<<<<<<<<<<>@<<:$<<<<<<<",
"<X<,X<<<<<<<<<<<<,@<:$<<<<<<<<",
"< ,X,<<<<<<<<<<<<>#:#<<<<<<<<<",
"<  X@@@@@@X@@@@X@XX#<<<<<<<<<<",
"<:$$$$$$$$$$$$$$$$:<<<<<<<<<<<"
]

math_smooth = [
"30 30 22 1 ",
"  c #111010",
". c #241213",
"X c #2D2D2D",
"o c #582224",
"O c #4E4D4D",
"+ c #6E6E6E",
"@ c #A72B2F",
"# c #EC1C24",
"$ c #D12A30",
"% c #EB282F",
"& c #EA3E45",
"* c #A35457",
"= c #EC4950",
"- c #E76A6F",
"; c #8B8A8A",
": c #B18D8F",
"> c #B3B3B3",
", c #E99EA0",
"< c #D8D7D7",
"1 c #FBD4D5",
"2 c #FCDFE0",
"3 c None",
"333333333333333333233333333333",
"33333333333333333-#,3333333333",
"33333333333333332##&3<33333333",
"3333333333333333,#$#:O33333333",
"3333333333333333=#o#*X33333333",
"3333333333333333#@X#& 33333333",
"3333333333333331#@O&% 33333333",
"333333333333333,#o+*# <3333333",
"333333333333333=$O>*#o>3333333",
"333333333333332#-+< #*>3333333",
"33333333333333,#:+3 $#:3333333",
"33333333333333&&+;3O:#*3333333",
"333333333333>1#,O>332#*3333333",
"33333333333> =#1X2333&#2333333",
"33333333333*o#=3 3333-#1+>3333",
"33333333333O$#1<X3333>#,O+3333",
"3333333332,$#@<>O3333<%=XO3333",
"3333333,=%##-;++;33332@#.X3333",
"333333,%%-*:33 O>33333o#* 3333",
"333333=#13 333+ <33333o#*O<333",
"333333#=3<X333< 333333X#-+>333",
"333333#=+;;33332333333O@&;*333",
"333333#@ X>33333333333;@#>O333",
"333332#@> <33333333333<<#,.333",
"3333; %@3>33333333333333%-X233",
"3333O*#-3333333333333333-%O>33",
"333<X-#23333333333333333,#@>33",
"333:$#-333333333333333333#$:33",
"333@%-3333333333333333333,%%,3",
"333O>333333333333333333333**33"
]

crop = [
"30 30 11 1 ",
"  c #029E4E",
". c #03A652",
"X c #2CAF6B",
"o c #4AB87F",
"O c #57BC89",
"+ c #6BC497",
"@ c #8ACFAC",
"# c #A3D9BE",
"$ c #B0DEC6",
"% c #CEE9DB",
"& c None",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&@o&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&X $&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&X.#&&&&&&",
"&&&&&&&&+oooooooooooo .XoO%&&&",
"&&&&&&&%.. .. ....... . ..#&&&",
"&&&&&&&%..@@@@+@+@@@@..O@@&&&&",
"&&&&&&&%..&&&&&&&&&&&X.$&&&&&&",
"&&&&&&&%..&&&&&&&&&&&X.$&&&&&&",
"&&&&&&&%..&&&&&&&&&&&X.$&&&&&&",
"&&&&&&&%..&&&&&&&&&&&X.$&&&&&&",
"&&&&&&&%..&&&&&&&&&&&X.$&&&&&&",
"&&&&&&&%..&&&&&&&&&&&X.$&&&&&&",
"&&&&&&&%..&&&&&&&&&&&X.$&&&&&&",
"&&&&&&&%..&&&&&&&&&&&X.$&&&&&&",
"&&&&&&&%..&&&&&&&&&&&X.$&&&&&&",
"&&&&&&&%..&&&&&&&&&&&X.$&&&&&&",
"&&&&&#@+ .@@@@@@@@@@@..$&&&&&&",
"&&&&% .................$&&&&&&",
"&&&&&+OX  ooOOoooooooo+&&&&&&&",
"&&&&&&&%..&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&% .&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&O+&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&"
]

nxdata_axis_remove = [
"30 30 20 1 ",
"  c #464E32",
". c #9E2B25",
"X c #FB0404",
"o c #D8302F",
"O c #A95C5C",
"+ c #E16968",
"@ c #019546",
"# c #00A14B",
"$ c #5FBC8A",
"% c #62C590",
"& c #A4A2A0",
"* c #CA8F8F",
"= c #F28A8B",
"- c #87D2AA",
"; c #A3DDBE",
": c #ABDBC2",
"> c #B3E2C9",
", c #E7D8D8",
"< c #D3E3DA",
"1 c None",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"1111111111111<1111111111111111",
"111111111111#####>111111111111",
"111111111111#%;;><111111111111",
"111111111111#-1<11111111111111",
"111111111111###%11111111111111",
"111111111111#%><11111111111111",
"111111111==,#-<11=+11111111111",
"11111111,XX+###%=XX*1111111111",
"11111111,+XX.%>+XX.&1111111111",
"111111111<OXXo+XX.&<1111111111",
"111111111,,OXXXX.&,11111111111",
"11111111111,.XX.&<111111111111",
"11111111111+XXXXo,111111111111",
"1111111111+XX. XXo,11111111111",
"111111111+XX. &OXXo,1111111111",
"11111111<XX.@$>:OXX*1111111111",
"111111111OO&@@#$1&O&1111111111",
"111111111,<1#%<11,,11111111111",
"111111111111#%><11111111111111",
"111111111111###%11111111111111",
"111111111111#;<111111111111111",
"111111111111#%;;:<111111111111",
"111111111111#####>111111111111",
"111111111111<11111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111"
]

plot_yup = [
"30 30 14 1 ",
"  c #040404",
". c #2F2F2F",
"X c #4A4A4A",
"o c #6F6F6F",
"O c #0CA553",
"+ c #24AE64",
"@ c #54C086",
"# c #65C692",
"$ c #929292",
"% c #B6B6B6",
"& c #89D3AC",
"* c #AFE2C7",
"= c #CFCFCF",
"- c None",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"---------**-------------------",
"---------++-------------------",
"--------&OO#------------------",
"--------OOOO------------------",
"-------#OOOO@-----------------",
"-------#@OO##-=%%=-------%%%=-",
"---------OO---=.  $-----o  .--",
"---------OO----%   =---=  .=--",
"---------OO-----o  X---.  =---",
"---------OO------.  $-o  $----",
"---------OO-------  .=  o-----",
"---------OO-------=    .------",
"----=XX=-OO--------$   -------",
"----.%$o-OO--------%  .-------",
"---- -=.-OO--------%  .-------",
"---- -=.-OO--------%  .-------",
"----.%$o-OO--------%  .-------",
"----=Xo=-@@--------=X.o-------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------",
"------------------------------"
]

plot_ylog = [
"30 30 17 1 ",
"  c #040404",
". c #313131",
"X c #4E4E4E",
"o c #6F6F6F",
"O c #09A451",
"+ c #1FAC61",
"@ c #2CB16A",
"# c #41B979",
"$ c #56C088",
"% c #6CC997",
"& c #8F8F8F",
"* c #B0B0B0",
"= c #8CD5AE",
"- c #B0E2C7",
"; c #D2D2D2",
": c #CBECDA",
"> c None",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>$->>>>>>>>>>>>>>>>>>>>>>",
">>>>>:O+>>>>>>>>>>>>>>>>>>>>>>",
">>>>>#+O=>>>>>>>>>>>>>>>>>>>>>",
">>>>-O+OO>>>>>>>>>>>>>>>>>>>>>",
">>>>%$O@$=>>>>>>>>>>>>>>>>>>>>",
">>>>>>@%>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>@%>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>@%>>;;>>>>>>>>>>>>>>>>>>",
">>>>>>@%>>. >>>>>>>>>>>>>>>>>>",
">>>>>>@%>>. >>>>>>>>>>>>>>>>>>",
">>>>>>@%>>. :>>>*Xo>>>&o*o*>>>",
">>>>>>@%>>. >>>* . X>*    &>>>",
">>>>>>@%>>. >>>X >X ;X ;o *>>>",
">>>>>>@%>>. >>>  >o *. >& &>>>",
">>>>>>@%>>. >>>. >o *. >& *>>>",
">>>>>>@%>>. **;X ;. :o &. *>>>",
">>>>>>@%>>.   &;   &>;  . &>>>",
">>>>>>@%>>;***;>;**>>>>;o ;>>>",
">>>>>>@%>>>>>>>>>>>>>:&&  ;>>>",
">>>>>>@%>>>>>>>>>>>>>*  .*>>>>",
">>>>-=+@=->>>>>>>>>>>>>>>>>>>>",
">>>>=OOOO:>>>>>>>>>>>>>>>>>>>>",
">>>>>@@+$>>>>>>>>>>>>>>>>>>>>>",
">>>>>-OO>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>$%>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
]

_d_plane_pan = [
"30 30 20 1 ",
"  c #070606",
". c #312B24",
"X c #48341D",
"o c #674926",
"O c #565049",
"+ c #615D57",
"@ c #727271",
"# c #845C2C",
"$ c #84633D",
"% c #CD7C1B",
"& c #D68C33",
"* c #E79635",
"= c #948675",
"- c #D6964A",
"; c #F6A647",
": c #8E8E8E",
"> c #A4A19E",
", c #AAAAAA",
"< c #D4D4D4",
"1 c None",
"111111111111111111111111111111",
"1111111111<::@:@@:@::@::@@:@@1",
"111111111<>:<1@+1111111111<>:1",
"111111111:1>1<  <11111111<>1:1",
"11111111:11><O  .1111111<>11:1",
"111111<:111>>    :11111<>111:1",
"11111<>1111>.    .1111<>1111:1",
"11111:11111>11. 11111<>11111:1",
"1111:111111><1. 1111<,111111:1",
"11<:1111111>11. 111<>1111111:1",
"11:11111111+OO  OO+@OOOOOOOO.1",
"1@:@::::::@=@:@@=:=-&-&&-&&.O1",
"1:<11<1<1+#&-;..;-:;;;;;;;X>:1",
"1:111111O#;*;;. ;-=;;;;;;X>1:1",
"1:11111O#;;*;;. ;;=;;;;;X,11:1",
"1:1111+#;;;*;;%%;;=;;;;X>111:1",
"1:111O#;;;;*;;&%*;=;;;X>1111:1",
"1:11+#;;;;;*;;%%;*=;*X:<<<<1:1",
"1:1O#;;;;;;***&%*&=*.+::::::@1",
"1:O#;;;;;;**;;%%;-=X>111111><1",
"1@.###########oo#$@>111111><11",
"1=,,,,,,@:>,,,. ,,:111111><111",
"1:11111,<11111. 11>11111,<1111",
"1:1111,<1111.    .>1111><11111",
"1:111,<11111,    :>111><111111",
"1:11><1111111O  .<>11><1111111",
"1:1,<11111111<  ,1>1,<11111111",
"1:,<1111111111@+1<>,<111111111",
"1@@:@:@:::@@:@@:::@<1111111111",
"111111111111111111111111111111"
]

math_normalize = [
"30 30 12 1 ",
"  c #060606",
". c #353535",
"X c #545454",
"o c #737373",
"O c #F7941E",
"+ c #FABA6E",
"@ c #8B8B8B",
"# c #B1B1B1",
"$ c #FCD7AB",
"% c #D1D1D1",
"& c #FDE6CA",
"* c None",
"******************************",
"******************************",
"********o@o*******************",
"*******%   *******************",
"********o @*******************",
"********o @*******************",
"********o o*******************",
"********o @***##*o%*o%%@******",
"********o @***o**XX@X**o******",
"********o @***X***  %**X******",
"********@ o***X***. ***X******",
"********o o***o**#..@**o******",
"*******%   %**##* ## %&o******",
"********%%%*******************",
"********$&&&&&&&&&&&&&&&******",
"*******$OOOOOOOOOOOOOOOO******",
"*******&++++++++++++++++******",
"******************************",
"***********#@#****%@%*********",
"***********X  @***@ o*********",
"***********X   %**@ @*********",
"***********X #  %*@ o*********",
"***********X %@ X*@ o*********",
"***********X #*. ## @*********",
"***********X #*%  @ @*********",
"***********X #**#   o*********",
"***********X #***o  o*********",
"***********@X%****oX#*********",
"******************************",
"******************************"
]

math_mean = [
"30 30 17 1 ",
"  c #565656",
". c #AB7739",
"X c #F7941E",
"o c #F79828",
"O c #F8A23C",
"+ c #F9AB4E",
"@ c #D3AC7E",
"# c #F9BA6E",
"$ c #FAC17C",
"% c #B2AEA9",
"& c #DBB486",
"* c #FBCB93",
"= c #FCD8AD",
"- c #FDE1BF",
"; c #D5D5D5",
": c #FDE8D0",
"> c None",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>:++++O++++#>>>>>>>>>>>>>>>>>",
">>:XXXXXXXXX+>>>>>>>>>>>>>>>>>",
">>>+Xo*::-:-:>>>>>>>>>>>>:>>>>",
">>>>#XX->>>>>>>>>>>>>>>>=X*>>>",
">>>>>#Xo->>>>>>>>>>>>>>:oo:>>>",
">>>>>>$XX=>>>>>>>;;;;%%XX*>>>>",
">>>>>>>#XX:>>>>>>>>>>>+X.>>>>>",
">>>>>>>OX#>>>>>>>>>>>$X+ >>>>>",
">>>>>>#XO>>>>>>>>>>>*X+; >>>>>",
">>>>>=XX:>>>>>>>>>>:oo:: >>>>>",
">>>>:oX*>>>>>>>>>>:OX=>> >>>>>",
">>>>+o+>>>>>>>>>>>+X*>>> >>>>>",
">>>*Xo>>>>>>>>>>>#X+>>>; >>>>>",
">>:oX+#++#+##>>>*X+:>>>> >>>>>",
">>:oXXXXXXXXO>>:Xo:>>>>> >>>>>",
">>>===-===-=:>:oX=>:>>>> >:::>",
">>>>>>>>>>>>>>OX*>+XO>>: >oX#>",
">>>>>>>>>>>>>+X#>>oXX=>> >oX#>",
">>>>>>>>>>>>$X+>>>OXXX=; >OX#>",
">>>>>>>>>>>=Xo:>>>+XXXX* >OX#>",
">>>>>>>>>>:oX:>>>>OX+XXX.>OX+>",
">>>>>>>>>>OX*>>>>>+X#=oXX=+X+>",
">>>>>>>>>+X#>>>>>>+X+;&XXXOX+>",
">>>>>>>>#X+>>>>>>>oX#;;@XXXX+>",
">>>>>>>=XO:>>>>>>>OX#>>>*XXX+>",
">>>>>>>$o:>>>>>>>>+o#>>>>*+XO>",
">>>>>>>>:>>>>>>>>>>>>>>>>>:-:>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
]

colormap_none = [
"30 30 13 1 ",
"  c black",
". c #494949",
"X c #656565",
"o c #A7A7A7",
"O c #AFAFAF",
"+ c #C1C1C1",
"@ c #CBCBCB",
"# c #E4E4E4",
"$ c #F1F1F1",
"% c #F6F6F6",
"& c gray97",
"* c #FBFBFB",
"= c None",
"==============================",
"==============================",
"==o#======================@+==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"== O======================X.==",
"==$*======================&%==",
"==============================",
"=============================="
]

compare_mode_vline = [
"30 30 19 1 ",
"  c #040302",
". c #261A0C",
"X c #25251D",
"o c #4D3518",
"O c #404827",
"+ c #5A5E23",
"@ c #865D2B",
"# c #A27034",
"$ c #738730",
"% c #8D9C38",
"& c #E09943",
"* c #F8AC4E",
"= c #B6C848",
"- c #D4F958",
"; c #0F0BAD",
": c #2F23B7",
"> c #553BC3",
", c #5042C3",
"< c None",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<.  .        ;;XXXXXXXXXXXO<<",
"<< o@@@@@@@@@+::$$$$$$$$$$OX<<",
"<<.@**********>,----------$X<<",
"<< @**********>,----------$X<<",
"<< @******@ooo::+++$=-----$X<<",
"<< @******.   ;;     O----$X<<",
"<< @*****#    ;;      X---$X<<",
"<< @*****+    ;;$$.    =--$X<<",
"<<.@*****    .;;--=    %--$X<<",
"<< @****#   .@;;--=    %--$X<<",
"<< @****o   @&;;--+    =--$X<<",
"<< @***&    &*;;      $---$X<<",
"<< @***+   .**:;     +----$X<<",
"<<.@***.   @**>;      X---$X<<",
"<<.@**#    &*&>:-=$    +--$X<<",
"<< @**+    ooo;:---$    --$X<<",
"<< @**.       ;;---$    =-$X<<",
"<< @*#        ;;---O    --$X<<",
"<< @*o   X@@@@::$$O    X--$X<<",
"<<.@&    #****>:       %--$X<<",
"<< @@    *****>:     .%---$X<<",
"<<.@+ooo@*****,:O++$=-----$X<<",
"<< @**********>,----------$X<<",
"<< @**********>,----------$X<<",
"<< o@@@@@+@@@@::$$$$$$$$$$OX<<",
"<<. .   ..    ;;XXXXXXXXXXXO<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<"
]

tree_expand_all = [
"30 30 15 1 ",
"  c #000000",
". c #0A0A0A",
"X c #141414",
"o c #2F2F2F",
"O c #606060",
"+ c #888888",
"@ c #949494",
"# c #A9A9A9",
"$ c #B3B3B3",
"% c #BABABA",
"& c #D4D4D4",
"* c #E9E9E9",
"= c #F4F4F4",
"- c #F9F9F9",
"; c None",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;%XXXXXXXXXXXXXXXXXX&;;;;;;;",
";;;% +++@++++++@++++O &-;;;;;;",
";;;$ *;;;;;;;;;;;;;;* &=;;;;;;",
";;;$ *;;;;;;;;;;;;;;& &;;;;;;;",
";;;% *;=...........X. ...X;;;;",
";;;$ *;* O@@@@@@@@@@@@@@OX;;;;",
";;;$ *;= $;;;;;;;;;;;;;;+X;;;;",
";;;% *;= $;;;;;*&*-;;;;;@.;;;;",
";;;$ *;* $;;;;;O  &;;;;;+.;;;;",
";;;$ *;= #;;;;=O  &;;;;;@X;;;;",
";;;$ *;= $;;;;-O  &;;;;;@.;;;;",
";;;% *;= #;;;-=O  &;;;;;+X;;;;",
";;;$ *;= $;o.         %;+X;;;;",
";;;% *;* $;o          %;@.;;;;",
";;;$ *;= $-Oooo.  oooo&=@X;;;;",
";;;$ *;* #;;;;;O  &;-;;;+X;;;;",
";;;$ #%# $;;;;=O  &;;;;;+X;;;;",
";;;$     $;;;;-O  &;;;;;@.;;;;",
";;;-***& $;;;;;OX.&;;;;;@X;;;;",
";;;;;;;= #;;;;;;;;;;;;;;+X;;;;",
";;;;;;;* O$$############O.;;;;",
";;;;;;;=                 X;;;;",
";;;;;;;;-=--=--=-==-=--==-;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;",
";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
]

math_phase_color_log = [
"30 30 24 1 ",
"  c #050403",
". c #26271B",
"X c #1C5A14",
"o c #564420",
"O c #5B5C5B",
"+ c #EA1B1D",
"@ c #E35422",
"# c #FB1E62",
"$ c #3DCE25",
"% c #27FB62",
"& c #C7C920",
"* c #EAE120",
"= c #552EFB",
"- c #FF299F",
"; c #A029FD",
": c #F021EB",
"> c #B561F2",
", c #42E6D0",
"< c #A7A7A6",
"1 c #C9BDE2",
"2 c #ABDDF1",
"3 c #CED2D4",
"4 c #DEDDED",
"5 c None",
"435555555555555555554<<5555555",
"<O555555555555555555o  <555555",
"<O555555555555555554   O555555",
"<o55O..O455O XoX**3O O  455555",
"<O53.45OO%$X$$XX$**. 3O O55555",
"<O5OO552 $XX$&$X&&$ o*< .55555",
"<O5O<53% %X$$$&.&&o &**. 35555",
"<O5<o2%$X$$X$$X.&&  &**o O5555",
"<O55..X $%$XXXX.&$ .***@  4555",
"4355,%%%%%%%$$$X*. &@*@*. <555",
"5555,%%,%%%X$$ &&  ***@@@ o555",
"5554,,,,,,%$XX$&o  .  .    355",
"5553O42OOO3,%%$*  ....     O55",
"55O  4O    <,%%& .@@@@@+++ .55",
"5<  <2 .4O  4,%. o@++@++++  <5",
"5..O23 .22O O,=  +##++++++. O5",
"4  2,2 .2,< .2O .-###@#+++#  4",
"3 .4,2 .2=2  1=:::---#####-435",
"< .4,2 .,,1  1;;::---##-##1555",
"3  5,1 .2=1  1=;::::---###4555",
"4  4>1 .2=< .1;;:::::----15555",
"5. <22 .21. <>;;>::::-:--55555",
"5<  <3 .4O .1==;;:::::--455555",
"55O        <==;;;::::::1555555",
"5553O.  .O1===;;;;::::45555555",
"555553 .51====;;;:;:1555555555",
"555554 .5551>>>;:>155555555555",
"555553 .5555555555555555555555",
"555553 .5555555555555555555555",
"555555<35555555555555555555555"
]

plot_roi_above = [
"30 30 22 1 ",
"  c #0D0D0D",
". c #2D2E2E",
"X c #653D0E",
"o c #724A1A",
"O c #535455",
"+ c #6E6F70",
"@ c #93652E",
"# c #A67D4B",
"$ c #DE9237",
"% c #AA8355",
"& c #F3AB55",
"* c #D29F64",
"= c #FAB360",
"- c #929495",
"; c #9D9FA2",
": c #A7A9AC",
"> c #DEB686",
", c #FAD09C",
"< c #FCD4A6",
"1 c #CECECE",
"2 c #FDE9D1",
"3 c None",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333332<<<<<<<<3",
"33333333333333233333,&=======3",
"33333333333333  2333,=,<<<<<,3",
"3333333333333-..-333,&<<<<<<<3",
"3333333333333.++.333,=<<<<<<<3",
"3333333333332 -; 133,=<<<,<<<3",
"333333333333;.:;.+33,=<<<<<<<3",
"333333333333.O::+.33,=<<<<<<<3",
"33333333331O.;::- 23,=<<<<<<<3",
"333333333+ .-::::.;3,=<<<<<<<3",
"333333333.+:;::::OO3=#,<<<,<<3",
"333333333.+::::::+ 3%@%<<<<<<3",
"333333333 -::::::: 1o$o<<<<<<3",
"333333333 -:::::::.+o$X<<<<<<3",
"3333333:..::::::::+ @$X><<<<<3",
"333333; O;:::::::::-*$o*<<<<<3",
"333333.+::::::::::::>*@%<<<<<3",
"333333 -::::::::::::*$%o>*<<,3",
"33333;.;::::::::::::**-XXX><<3",
"33332.O:;:::::;:::;:*$*@X@@<<3",
"3&=&&$&&&&&&&&&&&&*&&&>>>>@<<3",
"322222222222222222222232332333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333",
"333333333333333333333333333333"
]

close = [
"30 30 24 1 ",
"  c #3A3734",
". c #4B3E2F",
"X c #5C4832",
"o c #413F41",
"O c #434142",
"+ c #6C6156",
"@ c #A36B2B",
"# c #C97A1D",
"$ c #9B7851",
"% c #F4931E",
"& c #F5992D",
"* c #EF9B38",
"= c #D79D5B",
"- c #F7A94F",
"; c #D1A471",
": c #F8B76D",
"> c #A9A49F",
", c #E1BA8E",
"< c #FBC88E",
"1 c #F9D6AE",
"2 c #EFD3B7",
"3 c #F3DBC2",
"4 c #FCE9D3",
"5 c None",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"5555555555551<<:<1555555555555",
"5555555551-&-:<<111<1555555555",
"55555554-&-::<1444555<45555555",
"5555554&&-:<<144555554<3555555",
"555554%*$=:<14444545>>2:455555",
"55555&&$oo$,1444544>oo+<-55555",
"5555<%*+ooO+,34455+OooO,-<5555",
"5554%%*#.oOO+2444+oooO+,:*4555",
"5551%&-=$ Ooo+23+ooo O><:-1555",
"555:%&--=$OOoo++OoO O><<:-:555",
"555&%---;;$OoooooO +>,<<:-*555",
"555%%&--::;$ooooo X>,<<<:-&555",
"555&&&---::;Ooooo $,<<<:-*%555",
"555&%&--:::+ o OOo+;,<::-&-555",
"555:%&&--=+ oo  ooOO=::--&-555",
"555<%%&--Xo.o.X+.OOOO=--*&1555",
"5555&%&&Xoo  X@=$XoOoX$*&&4555",
"5555<%%@. o.X@--=$.oooX%%<5555",
"55555&%X . X*=----@.oo.#*55555",
"555554&#X.X@**---**@X.@#455555",
"5555553&###*%*&&&&%%#@%2555555",
"55555554-%%%%&&&&&%%%-45555555",
"5555555553-%%%%%&%%-3555555555",
"5555555555551<<:<1555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555",
"555555555555555555555555555555"
]

window_new = [
"30 30 10 1 ",
"  c #F7941E",
". c #F79928",
"X c #F8A23B",
"o c #F9AB4E",
"O c #FABD75",
"+ c #FAC27E",
"@ c #FBC88C",
"# c #FCD9AE",
"$ c #FDE8CF",
"% c None",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%# O%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%#.  O%%%",
"%%%%%%%%%%%%%%%%%%$@oX..  ..@%",
"%%%%$ooooooooo%%%O          .O",
"%%%%o        #%$o      .   .X$",
"%%%%o.o@@@@+@%%O       .  .O%%",
"%%%%o @%%%%%%%$  XO#$$#...$%%%",
"%%%%X @%%%%%%%o.@%%%%%# O%%%%%",
"%%%%o @%%%%%%%X#%%%%%%%$%%%%%%",
"%%%%X @%%%%%%$@%%%%%%%%%%@%%%%",
"%%%%o @%%%%%%@%%%%%%%%%$XX%%%%",
"%%%%o @%%%%%%$%%%%%%%%%@ o%%%%",
"%%%%X @%%%%%%%%%%%%%%%%@ X%%%%",
"%%%%o @%%%%%%%%%%%%%%%%@ o%%%%",
"%%%%X @%%%%%%%%%%%%%%%%@ X%%%%",
"%%%%o @%%%%%%%%%%%%%%%%@ o%%%%",
"%%%%X @%%%%%%%%%%%%%%%%@ X%%%%",
"%%%%o oO+OOOO++OO+OOOOOo o%%%%",
"%%%%o          .        .o%%%%",
"%%%%$OooOooOoOooooOooOooO$%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
]

zoom = [
"30 30 21 1 ",
"  c #503C43",
". c #584C50",
"X c #68575C",
"o c #726A6F",
"O c #85797C",
"+ c #707C82",
"@ c #8B7980",
"# c #79D3F5",
"$ c #9B9094",
"% c #A49BA0",
"& c #B2ABAE",
"* c #C3B9BC",
"= c #C3BFC0",
"- c #BBC2C6",
"; c #91D9F5",
": c #A7DDF3",
"> c #B8E2F4",
", c #D4CFD3",
"< c #E1DBDF",
"1 c #D1E9F4",
"2 c None",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222-&-<22222222222222222",
"222222<%$%&%oo,222222222222222",
"22222<$-:;122,o%22222222222222",
"22222$,>:;;#;11o&2222222222222",
"2222&,1>::;###11X2222222222222",
"2222&11>::;;#;:2o*222222222222",
"222<,<11>:;;;;:1+$222222222222",
"222<,2<11>>::::>+O222222222222",
"222<,2111>>>>>>>o$222222222222",
"2222&<2111111111.&222222222222",
"2222%<2<1<11111&.,<22222222222",
"22222$,2222121,.O&,<2222222222",
"22222<$,<222<&XXX@%*<<22222222",
"222222<$%%%$+o*=..O$*<<2222222",
"22222222<,&&,222<o o@*,<222222",
"222222222222222222$ X@%,,22222",
"2222222222222222222& .O$*,<222",
"22222222222222222222<o O$&,222",
"2222222222222222222222$ X%2222",
"22222222222222222222222&o22222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222",
"222222222222222222222222222222"
]

view_hdf5 = [
"30 30 17 1 ",
"  c #040302",
". c #2B1E0F",
"X c #33312F",
"o c #493317",
"O c #5F411C",
"+ c #62431C",
"@ c #724D21",
"# c #717171",
"$ c #94642A",
"% c #B27932",
"& c #D28E3B",
"* c #E29940",
"= c #F8A846",
"- c #9D9D9D",
"; c #A8A8A8",
": c #CFCFCF",
"> c None",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>:-####;:>>>>>>>>>>>",
">>>>>>>>>;X ..o... X;>>>>>>>>>",
">>>>>>>:X +%======%+ X:>>>>>>>",
">>>>>>; o&==========&o ;>>>>>>",
">>>>>; @==============@ ;>>>>>",
">>>>: @================@ :>>>>",
">>>>Xo==================oX>>>>",
">>>; &==================& ;>>>",
">>>Xo=&  &======$+++++%==oX>>>",
">>: &=&  &======O     $==% :>>",
">>- ==&  *%$&===+ $&&&&=== ;>>",
">>-.==&  o   $==+ o@$*====o#>>",
">>#.==&  .%o .==+     %===o#>>",
">>#o==&  %=$  ==$$&%. .===.#>>",
">>#o==&  &=%  ======$  *==.->>",
">>- ==&  &=%  ==%===@  === ;>>",
">>: %=&  &=%  ==  oo  O==% :>>",
">>>X+=&..*=%..==@.  .$===@X>>>",
">>>; &==================& ;>>>",
">>>>Xo==================oX>>>>",
">>>>: +================+ :>>>>",
">>>>>; @==============@ ;>>>>>",
">>>>>>; o&==========&o ;>>>>>>",
">>>>>>>:X +%======%o X:>>>>>>>",
">>>>>>>>>-X  .oo.  X;>>>>>>>>>",
">>>>>>>>>>>>-####->>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
]

math_fit = [
"30 30 19 1 ",
"  c #000000",
". c #3A2021",
"X c #4F2B2C",
"o c #505050",
"O c #B43035",
"+ c #C43A3F",
"@ c #EF3037",
"# c #E53C43",
"$ c #B75B5F",
"% c #F14C52",
"& c #F25C62",
"* c #F36C71",
"= c #B5B2B2",
"- c #F69195",
"; c #F9B1B4",
": c #FABFC1",
"> c #CCCCCC",
", c #FBCDCF",
"< c None",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<%%<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<,&*;<<<<<<<<<<<<<",
"<<<<<<<<<<<<<*;<%<<<<<<<<<<<<<",
"<<<<<<<<<<<<<#<<%,<<<<<<<<<<<<",
"<<<<<<<<<<<<,*<<--<<<<<<<<<<<<",
"<<<<<<<<<<<<*;<<,%<<<<<<<<<<<<",
"<<<<<<<<<<<*&<<<<@<<<<<<<<<<<<",
"<<<<<<<<<;#-<<<<<*;<<<<<<<<<<<",
"<<<<<<<<<&:<<<<<<;*<<-<<<<<<<<",
"<<<<<<<<<&,<<<<<<,@<-@-<<<<<<<",
"<<<<<<<<>$=>=<>><>O=$$+<<<<<<<",
"<<<<<<<<o    <o ,     .<<<<<<<",
"<<<<<<<<X ,>><o <>= X>+,<<<<<<",
"<<<<<<:@o >><<o <<< o<*,<<<<<<",
"<<<<<<*;o   .<o <<< o<--<<<<<<",
"<<<<<<%<o ===<o <<< o<,&,,<<<<",
"<<<<<,*<o <<<<o <<< o<<%#@<<<<",
"<<<<<*;<o <<<<o <<< o<<-*--<<<",
"<<<<,-<<==<<<<>=<<<=><<<<<%<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<"
]

IconDict = {
            "folder" : folder,
            "draw-pencil" : draw_pencil,
            "image-select-box" : image_select_box,
            "math-sigma" : math_sigma,
            "compare-mode-hline" : compare_mode_hline,
            "median-filter" : median_filter,
            "arrow-keys" : arrow_keys,
            "item-0dim" : item_0dim,
            "add-shape-unknown" : add_shape_unknown,
            "math-phase-color" : math_phase_color,
            "clipboard" : clipboard,
            "plot-window" : plot_window,
            "plot-roi-reset" : plot_roi_reset,
            "selected" : selected,
            "item-object" : item_object,
            "item-2dim" : item_2dim,
            "crosshair" : crosshair,
            "cube-top" : cube_top,
            "shape-diagonal" : shape_diagonal,
            "plot-symbols" : plot_symbols,
            "cube-back" : cube_back,
            "add-shape-arc" : add_shape_arc,
            "math-substract" : math_substract,
            "add-shape-rectangle" : add_shape_rectangle,
            "item-ndim" : item_ndim,
            "first" : first,
            "view-1d" : view_1d,
            "rudder" : rudder,
            "math-phase" : math_phase,
            "pixel-intensities" : pixel_intensities,
            "view-nofullscreen" : view_nofullscreen,
            "shape-circle" : shape_circle,
            "-d-plane-normal-x" : _d_plane_normal_x,
            "remove" : remove,
            "document-open" : document_open,
            "tree-collapse-all" : tree_collapse_all,
            "plot-toggle-points" : plot_toggle_points,
            "colormap" : colormap,
            "sliders-on" : sliders_on,
            "plot-roi-below" : plot_roi_below,
            "silx" : silx,
            "profile-clear" : profile_clear,
            "math-average" : math_average,
            "cube-rotate" : cube_rotate,
            "plot-grid" : plot_grid,
            "profile1D" : profile1D,
            "view-raw" : view_raw,
            "view-nexus" : view_nexus,
            "shape-polygon" : shape_polygon,
            "math-imaginary" : math_imaginary,
            "item-3dim" : item_3dim,
            "spec" : spec,
            "layer-nx" : layer_nx,
            "compare-mode-b" : compare_mode_b,
            "compare-mode-rbneg-channel" : compare_mode_rbneg_channel,
            "cube-front" : cube_front,
            "compare-mode-a-minus-b" : compare_mode_a_minus_b,
            "math-ymin-to-zero" : math_ymin_to_zero,
            "pick" : pick,
            "next" : next,
            "shape-ellipse" : shape_ellipse,
            "zoom-original" : zoom_original,
            "math-peak" : math_peak,
            "plot-roi" : plot_roi,
            "sliders-off" : sliders_off,
            "item-1dim" : item_1dim,
            "compare-mode-a" : compare_mode_a,
            "cube" : cube,
            "-d-plane-normal-z" : _d_plane_normal_z,
            "zoom-out" : zoom_out,
            "add-shape-vertical" : add_shape_vertical,
            "item-none" : item_none,
            "document-save" : document_save,
            "math-peak-search" : math_peak_search,
            "camera" : camera,
            "image-select-add" : image_select_add,
            "image-select-brush" : image_select_brush,
            "axis" : axis,
            "stats-whole-data" : stats_whole_data,
            "shape-horizontal" : shape_horizontal,
            "stats-active-items" : stats_active_items,
            "colorbar" : colorbar,
            "shape-rectangle" : shape_rectangle,
            "add-shape-point" : add_shape_point,
            "compare-align-auto" : compare_align_auto,
            "edit-copy" : edit_copy,
            "draw-rubber" : draw_rubber,
            "shape-vertical" : shape_vertical,
            "colormap-range" : colormap_range,
            "plot-yauto" : plot_yauto,
            "zoom-in" : zoom_in,
            "nxdata-create" : nxdata_create,
            "image-mask" : image_mask,
            "compare-mode-rb-channel" : compare_mode_rb_channel,
            "view-fullscreen" : view_fullscreen,
            "add-shape-polygon" : add_shape_polygon,
            "math-real" : math_real,
            "math-derive" : math_derive,
            "view-2d-stack" : view_2d_stack,
            "rotate-3d" : rotate_3d,
            "math-energy" : math_energy,
            "view-3d" : view_3d,
            "math-square-amplitude" : math_square_amplitude,
            "cube-bottom" : cube_bottom,
            "math-swap-sign" : math_swap_sign,
            "image-select-erase-rubber" : image_select_erase_rubber,
            "colormap-histogram" : colormap_histogram,
            "plot-widget" : plot_widget,
            "math-peak-reset" : math_peak_reset,
            "stats-whole-items" : stats_whole_items,
            "add-shape-diagonal" : add_shape_diagonal,
            "image-select-erase" : image_select_erase,
            "plot-xauto" : plot_xauto,
            "image" : image,
            "cube-right" : cube_right,
            "plot-ydown" : plot_ydown,
            "nxdata-remove" : nxdata_remove,
            "plot-window-image" : plot_window_image,
            "zoom-back" : zoom_back,
            "math-amplitude" : math_amplitude,
            "shape-ellipse-solid" : shape_ellipse_solid,
            "-d-plane-normal-y" : _d_plane_normal_y,
            "view-refresh" : view_refresh,
            "document-print" : document_print,
            "draw-brush" : draw_brush,
            "previous" : previous,
            "last" : last,
            "compare-align-stretch" : compare_align_stretch,
            "compare-keypoints" : compare_keypoints,
            "compare-align-origin" : compare_align_origin,
            "shape-circle-solid" : shape_circle_solid,
            "compare-align-center" : compare_align_center,
            "cube-left" : cube_left,
            "-d-plane" : _d_plane,
            "pan" : pan,
            "stats-visible-data" : stats_visible_data,
            "plot-xlog" : plot_xlog,
            "add-shape-horizontal" : add_shape_horizontal,
            "shape-square" : shape_square,
            "view-2d" : view_2d,
            "view-text" : view_text,
            "normal" : normal,
            "plot-roi-between" : plot_roi_between,
            "nxdata-axis-add" : nxdata_axis_add,
            "profile2D" : profile2D,
            "math-smooth" : math_smooth,
            "crop" : crop,
            "nxdata-axis-remove" : nxdata_axis_remove,
            "plot-yup" : plot_yup,
            "plot-ylog" : plot_ylog,
            "-d-plane-pan" : _d_plane_pan,
            "math-normalize" : math_normalize,
            "math-mean" : math_mean,
            "colormap-none" : colormap_none,
            "compare-mode-vline" : compare_mode_vline,
            "tree-expand-all" : tree_expand_all,
            "math-phase-color-log" : math_phase_color_log,
            "plot-roi-above" : plot_roi_above,
            "close" : close,
            "window-new" : window_new,
            "zoom" : zoom,
            "view-hdf5" : view_hdf5,
            "math-fit" : math_fit,
}

def showIcons():
    w = qt.QWidget()
    g = qt.QGridLayout(w)

    idx = 0
    keyList = list(IconDict.keys())
    keyList.sort()
    for key in keyList:
        name = key
        icon = IconDict[name]
        column = int(idx / 20)
        row = idx % 20
        #print "name",name
        lab = qt.QLabel(w)
        lab.setText(str(name))
        g.addWidget(lab, row, 2 * column + 1)
        lab = qt.QLabel(w)
        lab.setPixmap(qt.QPixmap(icon))
        g.addWidget(lab, row, 2 * column)
        idx += 1

    w.show()
    return w

if __name__ == '__main__':
    import sys
    from PyMca5.PyMcaGui import PyMcaQt as qt
    app = qt.QApplication(sys.argv)
    app.lastWindowClosed.connect(app.quit)
    w = showIcons()
    app.exec()
    app = None
