# __init__.py - initialization for control systems toolbox
#
# Author: Richard M. Murray
# Date: 24 May 09
#
# This file contains the initialization information from the control package.
#
# Copyright (c) 2009 by California Institute of Technology
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# 3. Neither the name of the California Institute of Technology nor
#    the names of its contributors may be used to endorse or promote
#    products derived from this software without specific prior
#    written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL CALTECH
# OR THE CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
# USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
# OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id$

"""
The Python Control Systems Library :mod:`control` provides common functions
for analyzing and designing feedback control systems.

Documentation is available in two forms: docstrings provided with the code,
and the python-control users guide, available from `the python-control
homepage <https://www.python-control.org>`_.

The docstring examples assume that the following import commands::

  >>> import numpy as np
  >>> import control as ct

Available subpackages
---------------------

The main control package includes the most common functions used in
analysis, design, and simulation of feedback control systems.  Several
additional subpackages are available that provide more specialized
functionality:

* :mod:`~control.flatsys`: Differentially flat systems
* :mod:`~control.matlab`: MATLAB compatibility module
* :mod:`~control.optimal`: Optimization-based control
* :mod:`~control.phaseplot`: 2D phase plane diagrams

"""

# Import functions from within the control system library
# Note: the functions we use are specified as __all__ variables in the modules

# Input/output system modules
from .iosys import *
from .nlsys import *
from .lti import *
from .statesp import *
from .xferfcn import *
from .frdata import *

# Time responses and plotting
from .timeresp import *
from .timeplot import *

from .bdalg import *
from .ctrlplot import *
from .delay import *
from .descfcn import *
from .dtime import *
from .freqplot import *
from .margins import *
from .mateqn import *
from .modelsimp import *
from .nichols import *
from .phaseplot import *
from .pzmap import *
from .rlocus import *
from .statefbk import *
from .stochsys import *
from .ctrlutil import *
from .canonical import *
from .robust import *
from .config import *
from .sisotool import *
from .passivity import *
from .sysnorm import *

# Allow access to phase_plane functions as ct.phaseplot.fcn or ct.pp.fcn
from . import phaseplot
from . import phaseplot as pp

# Exceptions
from .exception import *

# Version information
try:
    from ._version import __version__
except ImportError:
    __version__ = "dev"

# Initialize default parameter values
reset_defaults()
