=head1 NAME

iPE::FeatureMap - a group of iPE::FeatureMappings of a feature name in an annotation to a state in an HMM.

=head1 DESCRIPTION

Data structure for map state to a relative position in a format-specific feature

=head1 FUNCTIONS

=over 8

=cut

package iPE::FeatureMap;
use iPE;
use iPE::Globals;
use iPE::FeatureMapping;
use iPE::XML::Wrappers;
use base ("iPE::XML::DocObject");

=item new ()

Creates an empty new feature map.  Call parse_file (in L<iPE::XML::DocObject>) to populate the object with a file's data.

=cut
sub new {
	my($class) = shift;
	my $this = $class->SUPER::new(@_);

    $this->{author_}          = "";
    $this->{date_}            = "";
	$this->{title_}           = "";			
    $this->{fileType_}        = "";
    $this->{extension_}       = "";
    $this->{featureMappings_} = [];

    return $this;
}

=item author (), date (), title (), fileType (), extension (), featureMappings ()

Accessor functions for the various elements in the feature map XML file.  The fileType and extension refer to the type of file and the extension (after the '.' in the filename) of the features we're mapping.  The featureMappings are the actualy L<iPE::FeatureMapping> objects in the feature map.

=cut
sub author          { shift->{author_} }
sub date            { shift->{date_}   }
sub title           { shift->{title_}   }
sub fileType        { shift->{fileType_} }
sub extension       { shift->{extension_} }
sub featureMappings { shift->{featureMappings_} }
#sub featureMapping  { $_[0]->{featureMappings_}->{$_[1]} }

sub init {}

sub handle_subelement {
    my $this = shift;
    my ($tag, $att, $data, $element) = @_;

    chomp($data) if defined $data;

    $this->{handled_tag_} = 1;
    for($tag) {
        if(/^feature_mappings$/)         { $this->handle_children($element) }
        elsif(/^feature_mapping$/) { 
            #if (not defined $this->featureMapping($att->{feature})) {
                #$this->{featureMappings_}->{$att->{feature}} = [];
            #}
            push (@{$this->{featureMappings_}}, new iPE::FeatureMapping(@_));
        }
        elsif(/^author$/)                { $this->{author_}    = $data; }
        elsif(/^date$/)                  { $this->{date_}      = $data; }
        elsif(/^title$/)                 { $this->{title_}     = $data; }
        elsif(/^file_type_description$/) { $this->{fileType_}  = $data; }
        elsif(/^filename_extension$/)    { $this->{extension_} = $data; }
        else { Warn("Unrecognized tag $tag in feature map\n"); }
    }
}

=back

=head1 SEE ALSO

L<iPE::FeatureMapping>

=head1 AUTHOR

Bob Zimmermann (rpz@cse.wustl.edu)

=cut
1;
