/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.util.AbstractStatusProvider;

public abstract class Input
extends AbstractStatusProvider
implements IInput {
    private final String m_key;
    private final String m_name;
    private Setting m_setting;
    private boolean m_inRefresh;

    protected Input(String key, String name) {
        this.m_key = key;
        this.m_name = name;
    }

    @Override
    public abstract void refresh();

    protected void markStale() {
        if (!this.m_inRefresh) {
            this.m_inRefresh = true;
            this.refresh();
            this.m_inRefresh = false;
            this.fireChange(IInput.STATUS_SETTING_CHANGE);
            this.fireChange(this.getStatus());
        }
    }

    protected final String getKey() {
        return this.m_key;
    }

    @Override
    public final String getName() {
        return this.m_name;
    }

    public final Setting getSetting() {
        return this.m_setting;
    }

    @Override
    public void setSetting(Setting setting) {
        this.m_setting = setting;
        this.refresh();
    }

    @Override
    public void dispose() {
        this.clearListeners();
    }

    protected String getPropertyValue() {
        return (String)this.m_setting.getChildObject(this.m_key, String.class);
    }

    protected void setPropertyValue(String value) {
        this.m_setting.setChildObject(this.m_key, (Object)value);
    }

    @Override
    public boolean isEnabled() {
        return this.m_setting != null;
    }
}

