/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_so extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "Jarmal";
        final String metaValue_FR = "Faransiis";
        final String metaValue_IT = "Talyaani";
        final String metaValue_NR = "Nauru";
        final String metaValue_RU = "Ruush";
        final String metaValue_ar = "Carabi";
        final String metaValue_hy = "Armeeniyaan";
        final String metaValue_ccp = "Jakma";
        final String metaValue_ET = "Itoobiya";
        final String metaValue_GE = "Joorjiya";
        final String metaValue_el = "Giriik";
        final String metaValue_gu = "Gujaraati";
        final String metaValue_he = "Cibraani";
        final String metaValue_ja = "Jabaaniis";
        final String metaValue_CA = "Kanada";
        final String metaValue_ko = "Kuuriyaan";
        final String metaValue_la = "Laatiin";
        final String metaValue_mak = "Makasar";
        final String metaValue_men = "Mende";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_or = "Oodhiya";
        final Object[][] data = new Object[][] {
            { "001", "Dunida" },
            { "002", "Afrika" },
            { "003", "Waqooyi Ameerika" },
            { "005", "Koonfur Ameerika" },
            { "009", "Osheeniya" },
            { "011", "Galbeeka Afrika" },
            { "013", "Bartamaha Ameerika" },
            { "014", "Afrikada Bari" },
            { "015", "Waqooyiga Afrika" },
            { "017", "Afrikada Dhexe" },
            { "018", "Afrikada Koonfureed" },
            { "019", "Ameerikaas" },
            { "021", "Waqooyiga Ameerika" },
            { "029", "Karibiyaan" },
            { "030", "Aasiyada Bari" },
            { "034", "Aasiyada Koonfureed" },
            { "035", "Aasiyada Koonfur-galbeed" },
            { "039", "Yurubta Koonfureed" },
            { "053", "Austraalaasiya" },
            { "054", "Melaneesiya" },
            { "057", "Gobolka Aasiyada yar" },
            { "061", "Booliyneesiya" },
            { "142", "Aasiya" },
            { "143", "Bartamaha Aasiya" },
            { "145", "Aasiyada Galbeed" },
            { "150", "Yurub" },
            { "151", "Yurubta Bari" },
            { "154", "Yurubta Waqooyi" },
            { "155", "Yurubta Galbeed" },
            { "202", "Afrikada ka hooseysa Saxaraha" },
            { "419", "Laatiin Ameerika" },
            { "AC", "Jasiiradda Asensiyoon" },
            { "AD", "Andora" },
            { "AE", "Midawga Imaaraatka Carabta" },
            { "AF", "Afgaanistaan" },
            { "AG", "Antigua & Barbuuda" },
            { "AI", "Anguula" },
            { "AL", "Albaaniya" },
            { "AM", "Armeeniya" },
            { "AO", "Angoola" },
            { "AQ", "Antaarktika" },
            { "AR", "Arjentiina" },
            { "AS", "Samowa Ameerika" },
            { "AT", "Awsteriya" },
            { "AU", "Awstaraaliya" },
            { "AW", "Aruba" },
            { "AX", "Jasiiradda Aland" },
            { "AZ", "Asarbajan" },
            { "BA", "Boosniya & Harsegofina" },
            { "BB", "Baarbadoos" },
            { "BD", "Bangaladhesh" },
            { "BE", "Biljam" },
            { "BF", "Burkiina Faaso" },
            { "BG", "Bulgaariya" },
            { "BH", "Baxreyn" },
            { "BI", "Burundi" },
            { "BJ", "Biniin" },
            { "BL", "St. Baathelemiy" },
            { "BM", "Barmuuda" },
            { "BN", "Buruneey" },
            { "BO", "Boliifiya" },
            { "BQ", "Karibiyaan Nadarlands" },
            { "BR", "Baraasiil" },
            { "BS", "Bahaamas" },
            { "BT", "Buutan" },
            { "BV", "Buufet Island" },
            { "BW", "Botuswaana" },
            { "BY", "Belarus" },
            { "BZ", "Beliis" },
            { "CA", metaValue_CA },
            { "CC", "Jasiiradda Kookoos" },
            { "CD", "Jamhuuriyadda Dimuquraadiga Kongo" },
            { "CF", "Jamhuuriyadda Afrikada Dhexe" },
            { "CG", "Kongo" },
            { "CH", "Swiiserlaand" },
            { "CI", "Ayfori Koost" },
            { "CK", "Jasiiradda Kook" },
            { "CL", "Jili" },
            { "CM", "Kaameruun" },
            { "CN", "Shiinaha" },
            { "CO", "Koloombiya" },
            { "CP", "Jasiiradda Kilibarton" },
            { "CR", "Costa Rica" },
            { "CU", "Kuuba" },
            { "CV", "Jasiiradda Kayb Faarde" },
            { "CW", "Kurakaaw" },
            { "CX", "Jasiiradda Kirismas" },
            { "CY", "Qubrus" },
            { "CZ", "Jekiya" },
            { "DE", metaValue_DE },
            { "DG", "Diyeego Karsiya" },
            { "DJ", "Jabuuti" },
            { "DK", "Denmark" },
            { "DM", "Dominika" },
            { "DO", "Jamhuuriyaddda Dominika" },
            { "DZ", "Aljeeriya" },
            { "EA", "Seyuta & Meliila" },
            { "EC", "Ikuwadoor" },
            { "EE", "Estooniya" },
            { "EG", "Masar" },
            { "EH", "Saxaraha Galbeed" },
            { "ER", "Eritreeya" },
            { "ES", "Isbeyn" },
            { "ET", metaValue_ET },
            { "EU", "Midowga Yurub" },
            { "EZ", "Yurusoon" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Jaziiradaha Fooklaan" },
            { "FM", "Mikroneesiya" },
            { "FO", "Jasiiradda Faroo" },
            { "FR", metaValue_FR },
            { "GA", "Gaaboon" },
            { "GB", "Boqortooyada Midowday" },
            { "GD", "Giriinaada" },
            { "GE", metaValue_GE },
            { "GF", "Faransiis Gini" },
            { "GG", "Guurnsey" },
            { "GH", "Gaana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambiya" },
            { "GN", "Gini" },
            { "GP", "Guadeluub" },
            { "GQ", "Ekuwatooriyal Gini" },
            { "GR", "Giriig" },
            { "GS", "Jasiiradda Joorjiyada Koonfureed & Sandwij" },
            { "GT", "Guwaatamaala" },
            { "GU", "Guaam" },
            { "GW", "Gini-Bisaaw" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong" },
            { "HM", "Jasiiradda Haad & MakDonald" },
            { "HN", "Honduras" },
            { "HR", "Korweeshiya" },
            { "HT", "Haiti" },
            { "HU", "Hangari" },
            { "IC", "Jasiiradda Kanari" },
            { "ID", "Indoneesiya" },
            { "IE", "Ayrlaand" },
            { "IL", "Israa\u02bciil" },
            { "IM", "Jasiiradda Isle of Man" },
            { "IN", "Hindiya" },
            { "IO", "Dhul xadeedka Badweynta Hindiya ee Ingiriiska" },
            { "IQ", "Ciraaq" },
            { "IR", "Iiraan" },
            { "IS", "Ayslaand" },
            { "IT", metaValue_IT },
            { "JE", "Jaarsey" },
            { "JM", "Jamaaika" },
            { "JO", "Urdun" },
            { "JP", "Jabaan" },
            { "KE", "Kenya" },
            { "KG", "Kirgistaan" },
            { "KH", "Kamboodiya" },
            { "KI", "Kiribati" },
            { "KM", "Komooros" },
            { "KN", "St. Kitts iyo Nevis" },
            { "KP", "Kuuriyada Waqooyi" },
            { "KR", "Kuuriyada Koonfureed" },
            { "KW", "Kuwayt" },
            { "KY", "Cayman Islands" },
            { "KZ", "Kasaakhistaan" },
            { "LA", "Laos" },
            { "LB", "Lubnaan" },
            { "LC", "St. Lusia" },
            { "LI", "Liyjtensteyn" },
            { "LK", "Sirilaanka" },
            { "LR", "Laybeeriya" },
            { "LS", "Losooto" },
            { "LT", "Lituweeniya" },
            { "LU", "Luksemboorg" },
            { "LV", "Latfiya" },
            { "LY", "Liibya" },
            { "MA", "Morooko" },
            { "MC", "Moonako" },
            { "MD", "Moldofa" },
            { "ME", "Moontenegro" },
            { "MF", "St. Maartin" },
            { "MG", "Madagaskar" },
            { "MH", "Jasiiradda Maarshal" },
            { "MK", "Masedooniya Waqooyi" },
            { "ML", "Maali" },
            { "MM", "Mayanmar" },
            { "MN", "Mongooliya" },
            { "MO", "Makaaw" },
            { "MP", "Jasiiradda Waqooyiga Mariaana" },
            { "MQ", "Maartinik" },
            { "MR", "Muritaaniya" },
            { "MS", "Montserrat" },
            { "MT", "Maalta" },
            { "MU", "Mawrishiyaas" },
            { "MV", "Maaldiifis" },
            { "MW", "Malaawi" },
            { "MX", "Meksiko" },
            { "MY", "Malaysiya" },
            { "MZ", "Musambiik" },
            { "NA", "Namiibiya" },
            { "NC", "Jasiiradda Niyuu Kaledooniya" },
            { "NE", "Nayjer" },
            { "NF", "Jasiiradda Noorfolk" },
            { "NG", "Nayjeeriya" },
            { "NI", "Nikaraaguwa" },
            { "NL", "Nederlaands" },
            { "NO", "Noorweey" },
            { "NP", "Nebaal" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "NZ", "Niyuusiilaand" },
            { "OM", "Cumaan" },
            { "PA", "Baanama" },
            { "PE", "Beeru" },
            { "PF", "Booliyneesiya Faransiiska" },
            { "PG", "Babwa Niyuu Gini" },
            { "PH", "Filibiin" },
            { "PK", "Bakistaan" },
            { "PL", "Booland" },
            { "PM", "St. Pierre iyo Miquelon" },
            { "PN", "Bitkairn" },
            { "PR", "Bueerto Riiko" },
            { "PS", "Dhulka Falastiiniyiinta daanta galbeed iyo marinka qasa" },
            { "PT", "Bortugaal" },
            { "PW", "Balaaw" },
            { "PY", "Baraguaay" },
            { "QA", "Qadar" },
            { "QO", "Dhulxeebeedka Osheeniya" },
            { "RE", "Riyuuniyon" },
            { "RO", "Rumaaniya" },
            { "RS", "Seerbiya" },
            { "RU", metaValue_RU },
            { "RW", "Ruwanda" },
            { "SA", "Sacuudi Carabiya" },
            { "SB", "Jasiiradda Solomon" },
            { "SC", "Sishelis" },
            { "SD", "Suudaan" },
            { "SE", "Iswidhan" },
            { "SG", "Singaboor" },
            { "SH", "Saynt Helena" },
            { "SI", "Islofeeniya" },
            { "SJ", "Jasiiradda Sfaldbaad & Jaan Mayen" },
            { "SK", "Islofaakiya" },
            { "SL", "Siraaliyoon" },
            { "SM", "San Marino" },
            { "SN", "Sinigaal" },
            { "SO", "Soomaaliya" },
            { "SR", "Surineym" },
            { "SS", "Koonfur Suudaan" },
            { "ST", "Sao Tome & Birincibal" },
            { "SV", "El Salfadoor" },
            { "SX", "Siint Maarteen" },
            { "SY", "Suuriya" },
            { "SZ", "Eswaatiini" },
            { "TA", "Tiristan da Kunha" },
            { "TC", "Turks & Kaikos Island" },
            { "TD", "Jaad" },
            { "TF", "Dhul xadeedka Koonfureed ee Faransiiska" },
            { "TG", "Toogo" },
            { "TH", "Taylaand" },
            { "TJ", "Tajikistan" },
            { "TK", "Tokelaaw" },
            { "TL", "Timoor" },
            { "TM", "Turkmenistan" },
            { "TN", "Tuniisiya" },
            { "TO", "Tonga" },
            { "TR", "Turki" },
            { "TT", "Tirinidaad & Tobago" },
            { "TV", "Tufaalu" },
            { "TW", "Taywaan" },
            { "TZ", "Tansaaniya" },
            { "UA", "Yukrayn" },
            { "UG", "Ugaanda" },
            { "UM", "Jasiiradaha ka baxsan Maraykanka" },
            { "UN", "Qaramada Midoobay" },
            { "US", "Maraykanka" },
            { "UY", "Uruguwaay" },
            { "UZ", "Usbakistan" },
            { "VA", "Faatikaan" },
            { "VC", "St. Finsent & Girenadiins" },
            { "VE", "Fenisuweela" },
            { "VG", "Biritish Farjin Island" },
            { "VI", "U.S Fargin Island" },
            { "VN", "Fiyetnaam" },
            { "VU", "Fanuaatu" },
            { "WF", "Walis & Futuna" },
            { "WS", "Samoowa" },
            { "XA", "Lahjadaha Pseudo" },
            { "XB", "Pseudo-Bidi" },
            { "XK", "Koosofo" },
            { "YE", "Yaman" },
            { "YT", "Mayotte" },
            { "ZA", "Koonfur Afrika" },
            { "ZM", "Saambiya" },
            { "ZW", "Simbaabwe" },
            { "ZZ", "Gobol aan la aqoonin" },
            { "ab", "U dhashay Abkhazia" },
            { "af", "Afrikaanka" },
            { "ak", "Akan" },
            { "am", "Axmaar" },
            { "an", "U dhashay Aragon" },
            { "ar", metaValue_ar },
            { "as", "Asaamiis" },
            { "av", "U dhashay Avar" },
            { "ay", "U dhashay Aymar" },
            { "az", "Asarbayjan" },
            { "ba", "Bashkir" },
            { "be", "Beleruusiyaan" },
            { "bg", "Bulgeeriyaan" },
            { "bi", "U dhashay Bislam" },
            { "bm", "Bambaara" },
            { "bn", "Bangladesh" },
            { "bo", "Tibeetaan" },
            { "br", "Biriton" },
            { "bs", "Bosniyaan" },
            { "ca", "Katalaan" },
            { "ce", "Jejen" },
            { "ch", "Chamorro" },
            { "co", "Korsikan" },
            { "cs", "Jeeg" },
            { "cu", "Kaniisadda Islaafik" },
            { "cv", "Chuvash" },
            { "cy", "Welsh" },
            { "da", "Dhaanish" },
            { "de", metaValue_DE },
            { "dv", "Divehi" },
            { "dz", "D\u2019zongqa" },
            { "ee", "Eewe" },
            { "el", metaValue_el },
            { "en", "Ingiriisi" },
            { "eo", "Isberaanto" },
            { "es", "Isbaanish" },
            { "et", "Istooniyaan" },
            { "eu", "Basquu" },
            { "fa", "Faarisi" },
            { "ff", "Fuulah" },
            { "fi", "Finishka" },
            { "fj", "Fijian" },
            { "fo", "Farowsi" },
            { "fr", metaValue_FR },
            { "fy", "Firiisiyan Galbeed" },
            { "ga", "Ayrish" },
            { "gd", "Iskot Giilik" },
            { "gl", "Galiisiyaan" },
            { "gn", "Guarani" },
            { "gu", metaValue_gu },
            { "gv", "Mankis" },
            { "ha", "Hawsa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hr", "Koro\u2019eeshiyaan" },
            { "ht", "Heeytiyaan Karawle" },
            { "hu", "Hangariyaan" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "ia", "Interlinguwa" },
            { "id", "Indunusiyaan" },
            { "ig", "Igbo" },
            { "ii", "Sijuwan Yi" },
            { "io", "Ido" },
            { "is", "Ayslandays" },
            { "it", metaValue_IT },
            { "iu", "Inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "Jafaaniis" },
            { "ka", "Joorijiyaan" },
            { "ki", "Kikuuyu" },
            { "kj", "Kuanyama" },
            { "kk", "Kasaaq" },
            { "kl", "Kalaallisuut" },
            { "km", "Kamboodhian" },
            { "kn", "Kannadays" },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kaashmiir" },
            { "ku", "Kurdishka" },
            { "kv", "Komi" },
            { "kw", "Kornish" },
            { "ky", "Kirgiis" },
            { "la", metaValue_la },
            { "lb", "Luksaamboorgish" },
            { "lg", "Gandha" },
            { "li", "Limburgish" },
            { "ln", "Lingala" },
            { "lo", "Lao" },
            { "lt", "Lituwaanays" },
            { "lu", "Luuba-kataanga" },
            { "lv", "Laatfiyaan" },
            { "mg", "Malagaasi" },
            { "mh", "Marshallese" },
            { "mi", "Maaoori" },
            { "mk", "Masadooniyaan" },
            { "ml", "Malayalam" },
            { "mn", "Mangooli" },
            { "mr", "Maarati" },
            { "ms", "Malaay" },
            { "mt", "Maltiis" },
            { "my", "Burmese" },
            { "na", metaValue_NR },
            { "nb", "Nawrijii Bokm\u00e5l" },
            { "nd", "Indhebeele Waqooyi" },
            { "ne", "Nebaali" },
            { "ng", "Ndonga" },
            { "nl", "Holandays" },
            { "nn", "Nawriijiga Nynorsk" },
            { "no", "Nawriiji" },
            { "nr", "South Ndebele" },
            { "nv", "Navajo" },
            { "ny", "Inyaanja" },
            { "oc", "Occitan" },
            { "om", "Oromo" },
            { "or", metaValue_or },
            { "os", "Oseetic" },
            { "pa", "Bunjaabi" },
            { "pl", "Boolish" },
            { "ps", "Bashtuu" },
            { "pt", "Boortaqiis" },
            { "qu", "Quwejuwa" },
            { "rm", "Romaanis" },
            { "rn", "Rundhi" },
            { "ro", "Romanka" },
            { "ru", metaValue_RU },
            { "rw", "Ruwaandha" },
            { "sa", "Sanskrit" },
            { "sc", "Sardinian" },
            { "sd", "Siindhi" },
            { "se", "Sami Waqooyi" },
            { "sg", "Sango" },
            { "si", "Sinhaleys" },
            { "sk", "Isloofaak" },
            { "sl", "Islofeeniyaan" },
            { "sm", "Samowan" },
            { "sn", "Shoona" },
            { "so", "Soomaali" },
            { "sq", "Albeeniyaan" },
            { "sr", "Seerbiyaan" },
            { "ss", "Swati" },
            { "st", "Sesooto" },
            { "su", "Suudaaniis" },
            { "sv", "Iswiidhish" },
            { "sw", "Sawaaxili" },
            { "ta", "Tamiil" },
            { "te", "Teluugu" },
            { "tg", "Taajik" },
            { "th", "Taaylandays" },
            { "ti", "Tigrinya" },
            { "tk", "Turkumaanish" },
            { "tn", "Tswana" },
            { "to", "Toongan" },
            { "tr", "Turkish" },
            { "ts", "Tsonga" },
            { "tt", "Taatar" },
            { "ty", "Tahitian" },
            { "ug", "Uighur" },
            { "uk", "Yukreeniyaan" },
            { "ur", "Urduu" },
            { "uz", "Usbakis" },
            { "ve", "Venda" },
            { "vi", "Fiitnaamays" },
            { "vo", "Folabuuk" },
            { "wa", "Walloon" },
            { "wo", "Woolof" },
            { "xh", "Hoosta" },
            { "yi", "Yadhish" },
            { "yo", "Yoruuba" },
            { "zh", "Shiinaha Mandarin" },
            { "zu", "Zuulu" },
            { "ace", "Shiinays" },
            { "ada", "Adangme" },
            { "ady", "U dhashay Ady" },
            { "agq", "Ageem" },
            { "ain", "U dhashay Ain" },
            { "ale", "U dhashay Ale" },
            { "alt", "Southern Altai" },
            { "ann", "Obolo" },
            { "anp", "U dhashay Anp" },
            { "arn", "Mapuche" },
            { "arp", "U dhashay Arap" },
            { "ars", "Najdi Arabic" },
            { "asa", "Asu" },
            { "ast", "Astuuriyaan" },
            { "atj", "Atikamekw" },
            { "awa", "Awa" },
            { "ban", "U dhashay Baline" },
            { "bas", "Basaa" },
            { "bem", "Bemba" },
            { "bez", "Bena" },
            { "bgc", "Haryanvi" },
            { "bho", "U dhashay Bhohp" },
            { "bin", "U dhashay Bin" },
            { "bla", "Siksik\u00e1" },
            { "brx", "Bodo" },
            { "bug", "U dhashay Bugin" },
            { "byn", "U dhashay Byn" },
            { "cay", "Cayuga" },
            { "ccp", metaValue_ccp },
            { "ceb", "Sebuano" },
            { "cgg", "Jiga" },
            { "chk", "Chuukese" },
            { "chm", "Mari" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", "Jerookee" },
            { "chy", "Cheyenne" },
            { "ckb", "Bartamaha Kurdish" },
            { "clc", "Chilcotin" },
            { "crg", "Michif" },
            { "crj", "Southern East Cree" },
            { "crk", "Plains Cree" },
            { "crl", "Northern East Cree" },
            { "crm", "Moose Cree" },
            { "crr", "Carolina Algonquian" },
            { "csw", "Swampy Cree" },
            { "dak", "Dakota" },
            { "dar", "Dargwa" },
            { "dav", "Taiita" },
            { "dgr", "Dogrib" },
            { "dje", "Sarma" },
            { "doi", "Dogri" },
            { "dsb", "Soorbiyaanka Hoose" },
            { "dua", "Duaala" },
            { "dyo", "Joola-Foonyi" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "eka", "Ekajuk" },
            { "ewo", "Eewondho" },
            { "fil", "Filibiino" },
            { "fon", "Fon" },
            { "frc", "Faransiiska Cajun" },
            { "frr", "Northern Frisian" },
            { "fur", "Firiyuuliyaan" },
            { "gaa", "Ga" },
            { "gez", "Geez" },
            { "gil", "Gilbertese" },
            { "gor", "Gorontalo" },
            { "gsw", "Jarmal Iswiis" },
            { "guz", "Guusii" },
            { "gwi", "Gwich\u02bcin" },
            { "hai", "Haida" },
            { "haw", "Hawaay" },
            { "hax", "Southern Haida" },
            { "hil", "Hiligaynon" },
            { "hmn", "Hamong" },
            { "hsb", "Sorobiyaanka Sare" },
            { "hup", "Hupa" },
            { "hur", "Halkomelem" },
            { "iba", "Iban" },
            { "ibb", "Ibibio" },
            { "ikt", "Western Canadian Inuktitut" },
            { "ilo", "Iloko" },
            { "inh", "Ingush" },
            { "jbo", "Lojban" },
            { "jgo", "Ingoomba" },
            { "jmc", "Chaga" },
            { "kab", "Kabayle" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Kaamba" },
            { "kbd", "U dhashay Kabardia" },
            { "kcg", "Tyap" },
            { "kde", "Kimakonde" },
            { "kea", "Kabuferdiyanu" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "Khasi" },
            { "khq", "Koyra Jiini" },
            { "kkj", "Kaako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "kok", "Konkani" },
            { "kpe", "Kpelle" },
            { "krc", "Karachay-Balkar" },
            { "krl", "Karelian" },
            { "kru", "Kurukh" },
            { "ksb", "Shambaala" },
            { "ksf", "Bafia" },
            { "ksh", "Kologniyaan" },
            { "kum", "Kumyk" },
            { "kwk", "Kwak\u02bcwala" },
            { "lad", "Ladino" },
            { "lag", "Laangi" },
            { "lez", "Lezghian" },
            { "lil", "Lillooet" },
            { "lkt", "Laakoota" },
            { "lou", "Louisiana Creole" },
            { "loz", "Lozi" },
            { "lrc", "Luri Waqooyi" },
            { "lsm", "Saamia" },
            { "lua", "Luba-Lulua" },
            { "lun", "Lunda" },
            { "luo", "Luwada" },
            { "lus", "Mizo" },
            { "luy", "Luyia" },
            { "mad", "Madurese" },
            { "mag", "Magahi" },
            { "mai", "Dadka Maithili" },
            { "mak", metaValue_mak },
            { "mas", "Masaay" },
            { "mdf", "Moksha" },
            { "men", metaValue_men },
            { "mer", "Meeru" },
            { "mfe", "Moorisayn" },
            { "mgh", "Makhuwa" },
            { "mgo", "Meetaa" },
            { "mic", "Mi'kmaq" },
            { "min", "Minangkabau" },
            { "mni", "Maniburi" },
            { "moe", "Innu-aimun" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mua", "Miyundhaang" },
            { "mul", "Luuqado kala duwan" },
            { "mus", "Muscogee" },
            { "mwl", "Mirandese" },
            { "myv", "Erzya" },
            { "mzn", "Masanderaani" },
            { "nap", "Neapolitan" },
            { "naq", "Nama" },
            { "nds", "Jarmal Hooseeya" },
            { "new", "Newari" },
            { "nia", "Nias" },
            { "niu", "Niuean" },
            { "nmg", "Kuwaasiyo" },
            { "nnh", "Ingiyembuun" },
            { "nog", "Nogai" },
            { "nqo", metaValue_nqo },
            { "nso", "Northern Sotho" },
            { "nus", "Nuweer" },
            { "nyn", "Inyankoole" },
            { "ojb", "Northwestern Ojibwa" },
            { "ojc", "Central Ojibwa" },
            { "ojs", "Oji-Cree" },
            { "ojw", "Western Ojibwa" },
            { "oka", "Okanagan" },
            { "pag", "Pangasinan" },
            { "pam", "Pampanga" },
            { "pap", "Papiamento" },
            { "pau", "Palauan" },
            { "pcm", "Bidjinka Nayjeeriya" },
            { "pis", "Pijin" },
            { "pqm", "Maliseet-Passamaquoddy" },
            { "prg", "Brashiyaanki Hore" },
            { "raj", "Rajasthani" },
            { "rap", "Rapanui" },
            { "rar", "Rarotongan" },
            { "rhg", "Rohingya" },
            { "rof", "Rombo" },
            { "rup", "U dhashay Aromania" },
            { "rwk", "Raawa" },
            { "sad", "Sandawe" },
            { "sah", "Saaqa" },
            { "saq", "Sambuuru" },
            { "sat", "Santali" },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Sicilian" },
            { "sco", "Scots" },
            { "seh", "Seena" },
            { "ses", "Koyraboro Seenni" },
            { "shi", "Shilha" },
            { "shn", "Shan" },
            { "slh", "Southern Lushootseed" },
            { "smn", "Inaari Saami" },
            { "sms", "Skolt Sami" },
            { "snk", "Soninke" },
            { "srn", "Sranan Tongo" },
            { "str", "Straits Salish" },
            { "suk", "Sukuma" },
            { "swb", "Comorian" },
            { "syr", "Syria" },
            { "tce", "Southern Tutchone" },
            { "tem", "Timne" },
            { "teo", "Teeso" },
            { "tet", "Tetum" },
            { "tgx", "Tagish" },
            { "tht", "Tahltan" },
            { "tig", "Tigre" },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tok", "Toki Pona" },
            { "tpi", "Tok Pisin" },
            { "trv", "Taroko" },
            { "ttm", "Northern Tutchone" },
            { "tum", "Tumbuka" },
            { "tvl", "Tuvalu" },
            { "twq", "Tasaawaq" },
            { "tyv", "Tuvinia" },
            { "tzm", "Bartamaha Atlaas Tamasayt" },
            { "udm", "Udmurt" },
            { "umb", "Umbundu" },
            { "und", "Af aan la aqoon ama aan sax ahayn" },
            { "vai", "Faayi" },
            { "vun", "Fuunjo" },
            { "wae", "Walseer" },
            { "wal", "Wolaytta" },
            { "war", "Waray" },
            { "wuu", "Wu Chinese" },
            { "xal", "Kalmyk" },
            { "xog", "Sooga" },
            { "yav", "Yaangbeen" },
            { "ybb", "Yemba" },
            { "yrl", "Nheengatu" },
            { "yue", "Kantoneese" },
            { "zgh", "Morokaanka Tamasayt Rasmiga" },
            { "zun", "Zuni" },
            { "zxx", "Luuqad Looma Hayo" },
            { "zza", "Zaza" },
            { "Adlm", "Adlam" },
            { "Aghb", "Qoraalka Luuqada Caucasian Albanian" },
            { "Ahom", "Dadka Ahom" },
            { "Arab", metaValue_ar },
            { "Aran", "Farta Luuqada Faarsiga" },
            { "Armi", "Luuqada Imperial Aramaic" },
            { "Armn", metaValue_hy },
            { "Avst", "Luuqada Avestan" },
            { "Bali", "Baliniis" },
            { "Bamu", "Bamum" },
            { "Bass", "Qoraalka Vah" },
            { "Batk", "Batak" },
            { "Beng", "Baangla" },
            { "Bhks", "Qoraalka Bhaiksuki" },
            { "Bopo", "Bobomofo" },
            { "Brah", "Dhirta Brahmi" },
            { "Brai", "Qoraalka Indhoolaha" },
            { "Bugi", "Luuqada Buginiiska" },
            { "Buhd", "Luuqada Buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Qoraalka Luuqada Aborajiinka ee Kanada" },
            { "Cari", "Luuqada kaariyaanka" },
            { "Cham", "Jam" },
            { "Cher", "Jerokee" },
            { "Chrs", "Luuqada Korasmiyaanka" },
            { "Copt", "Dadka Kotiga" },
            { "Cprt", "sibraas dhalad ah" },
            { "Cyrl", "Siriylik" },
            { "Deva", "Dhefangaari" },
            { "Diak", "Luuqadaha Dives Akuru" },
            { "Dogr", "Dadka Dogra" },
            { "Dsrt", "Gobalka Deseret" },
            { "Dupl", "Qoraalka Duployan shorthand" },
            { "Egyp", "Fartii hore ee Masaarida" },
            { "Elba", "Magaalada Elbasan" },
            { "Elym", "Qoraalka Elymaic" },
            { "Ethi", metaValue_ET },
            { "Geor", metaValue_GE },
            { "Glag", "Qoraalka Glagolitic" },
            { "Gong", "Gumjala Gondi" },
            { "Gonm", "Qoraalka Masaram Gondi" },
            { "Goth", "Dadka Gothic" },
            { "Gran", "Qoraalka Grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "Luuqada gujarati" },
            { "Hanb", "Han iyo Bobomofo" },
            { "Hang", "Hanguul" },
            { "Hani", "Han" },
            { "Hano", "Qoraalka Hanunoo" },
            { "Hans", "La fududeeyay" },
            { "Hant", "Hore" },
            { "Hatr", "Qoraalka Hatran" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana" },
            { "Hluw", "Qoraalka Anatolian Hieroglyphs" },
            { "Hmng", "Hmonga pahawh" },
            { "Hmnp", "Hmonga Nyiakeng Puachue" },
            { "Hrkt", "Qoraalka Xuruufta Jabaaniiska" },
            { "Hung", "Hangariyaankii Hore" },
            { "Ital", "Itaaliggii Hore" },
            { "Jamo", "Jaamo" },
            { "Java", "Jafaniis" },
            { "Jpan", metaValue_ja },
            { "Kali", "Kayah LI" },
            { "Kana", "Katakaana" },
            { "Khar", "Koraalka kharooshi" },
            { "Khmr", "Khamer" },
            { "Khoj", "Qoraalka Khojki" },
            { "Kits", "Qoraalka yar ee Khitan" },
            { "Knda", metaValue_CA },
            { "Kore", metaValue_ko },
            { "Kthi", "kaithi" },
            { "Lana", "Lanna" },
            { "Laoo", "Dalka Lao" },
            { "Latn", metaValue_la },
            { "Lepc", "Lebja" },
            { "Limb", "Limbu" },
            { "Lina", "Nidaamka qoraalka Linear A" },
            { "Linb", "Nidaamka qoraalka Linear B" },
            { "Lisu", "Wabiga Fraser" },
            { "Lyci", "Lyciantii Hore" },
            { "Lydi", "Lydian" },
            { "Mahj", "Mahajani" },
            { "Maka", metaValue_mak },
            { "Mand", "Luuqada Mandaean" },
            { "Mani", "Manichaean" },
            { "Marc", "Marchen" },
            { "Medf", "Madefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "Meroitic Curve" },
            { "Mero", "Meroitic" },
            { "Mlym", "Maalayalam" },
            { "Modi", "Moodi" },
            { "Mong", "Mongooliyaan" },
            { "Mroo", "Mro" },
            { "Mtei", "Qoraalka Luuqada Meitei" },
            { "Mult", "Multani" },
            { "Mymr", "Mayanmaar" },
            { "Nand", "Nandinagari" },
            { "Narb", "Carabiyadii Hore ee Wuqooye" },
            { "Nbat", "Nabataean" },
            { "Newa", "Newa" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "N\u00fcshu" },
            { "Ogam", "Ogham" },
            { "Olck", "Ol Jiki" },
            { "Orkh", "Orkhon" },
            { "Orya", metaValue_or },
            { "Osge", "Osage" },
            { "Osma", "Osmanya" },
            { "Palm", "Palmyrene" },
            { "Pauc", "Baaw Sin Haaw" },
            { "Perm", "Permic gii hore" },
            { "Phag", "Qoraalka Phags-pa" },
            { "Phli", "Qoraaladii hore ee Pahlavi" },
            { "Phlp", "Qoraalka midig laga bilaabo ee faarsiyiintii" },
            { "Phnx", "Luuqada Phoenicianka" },
            { "Plrd", "Shibanaha" },
            { "Prti", "Qoraalka Parthian" },
            { "Qaag", "Qoraalka Sawgiga" },
            { "Rjng", "Dadka Rejan" },
            { "Rohg", "Hanifi Rohingya" },
            { "Runr", "Dadka Rejang" },
            { "Samr", "Dadka Samaritan" },
            { "Sarb", "Crabiyaankii Hore ee Wuqooyi" },
            { "Saur", "Sawrashtra" },
            { "Sgnw", "Qaabka dhagoolka loola hadlo" },
            { "Shaw", "calaamad qoris" },
            { "Shrd", "Sharada" },
            { "Sidd", "Siddham" },
            { "Sind", "khudwadi" },
            { "Sinh", "Sinhaala" },
            { "Sogd", "Sogdiyaan" },
            { "Sogo", "Sogdiyaankii Hore" },
            { "Sora", "Qoraalka Sora Sompeng" },
            { "Soyo", "Soyombo" },
            { "Sund", "Dadka Sundaniiska" },
            { "Sylo", "Qoraalka Luuqada Sylheti" },
            { "Syrc", "Lahjada Syriac" },
            { "Tagb", "Tagbanwa" },
            { "Takr", "Takri" },
            { "Tale", "Tai Le" },
            { "Talu", "Tai Lue cusub" },
            { "Taml", "Taamiil" },
            { "Tang", "Luuqada Tangut" },
            { "Tavt", "Farta lagu Qoro Luuqadaha Tai" },
            { "Telu", "Teeluguu" },
            { "Tfng", "Farta Tifinagh" },
            { "Tglg", "Luuqada Tagalog" },
            { "Thaa", "Daana" },
            { "Thai", "Taay" },
            { "Tibt", "Tibetaan" },
            { "Tirh", "Qoraalka Luuqada Maithili" },
            { "Ugar", "Luuqada Ugaritic" },
            { "Vaii", "Dadka Vai" },
            { "Wara", "Nidaamka Qoraalka Luuqada Ho" },
            { "Wcho", "Dadka wanjo" },
            { "Xpeo", "Faarsigii Hore" },
            { "Xsux", "Qoraalkii Hore ee dadka Sumaariyiinta ee dhulka mesobataamiya" },
            { "Yezi", "Dadka Yesiidiga" },
            { "Yiii", "Tiknoolajiyada Yi" },
            { "Zanb", "Xarafka laba jibaaran ee kujira Xarfaha Zanabazar" },
            { "Zinh", "Dhaxlay" },
            { "Zmth", "Aqoonsiga Xisaabta" },
            { "Zsye", "Calaamad Dareen Muujin" },
            { "Zsym", "Calaamado" },
            { "Zxxx", "Aan la qorin" },
            { "Zyyy", "Caadi ahaan" },
            { "Zzzz", "Far aan la aqoon amase aan saxnayn" },
            { "de_AT", "Jarmal Awsteeriya" },
            { "de_CH", "Iswiiska Sare ee Jarmal" },
            { "en_AU", "Ingiriis Austaraaliyaan" },
            { "en_CA", "Ingiriis Kanadiyaan" },
            { "en_GB", "Ingiriis Biritish" },
            { "en_US", "Ingiriis Maraykan" },
            { "es_ES", "Isbaanish (Isbayn)" },
            { "es_MX", "Isbaanishka Mexico" },
            { "fa_AF", "Faarsi" },
            { "fr_CA", "Faransiiska Kanada" },
            { "fr_CH", "Faransiis (Iswiiserlaand)" },
            { "nl_BE", "Af faleemi" },
            { "pt_BR", "Boortaqiiska Baraasiil" },
            { "pt_PT", "Boortaqiis (Boortuqaal)" },
            { "%%1901", "orthofraphygii hore ee Jarmalka" },
            { "%%1994", "Heerka orthographyga Resiyaanka" },
            { "%%1996", "Orthigraphygii jarmal ee 1996" },
            { "ar_001", "Carabiga rasmiga ah" },
            { "es_419", "Isbaanishka Laatiin Ameerika" },
            { "key.ca", "Habeentiris" },
            { "key.cf", "Habka Lacagta" },
            { "key.co", "Kala Soocidda Dalabka" },
            { "key.cu", "Lacagta" },
            { "key.hc", "Wareegga Saacadda (12 ilaa 24)" },
            { "key.lb", "Habka Jebinta Xariiqda" },
            { "key.ms", "Nidaamka Cabbiraadda" },
            { "key.nu", "Tirooyinka" },
            { "%%ALUKU", "Lahjada Aluku" },
            { "%%BARLA", "lahjada kooxda Barlavento ee kabuverdianu" },
            { "%%BISKE", "Lahjada San Giorgio/Bila" },
            { "%%BOONT", "Luuqada Boontling" },
            { "%%KKCOR", "orhographyga caadiga ah" },
            { "%%KSCOR", "heerka orthographyga" },
            { "%%LIPAW", "Lahjada Lipavaz ee Resiyaanka" },
            { "%%NEDIS", "lahjada Natisone" },
            { "%%NJIVA", "lahjada Gniva/Njiva" },
            { "%%NULIK", "Folabuka casriga ah" },
            { "%%OSOJS", "lahjada Oseacco/Osojane" },
            { "%%POSIX", "Kombiyuutar" },
            { "%%SAAHO", "Saaho" },
            { "%%SOLBA", "lahjada Stolvizza/Solbica" },
            { "%%UCCOR", "orthograpghyga mideeysan" },
            { "hi_Latn", "Hindi (Latin)" },
            { "zh_Hans", "Shiinaha Rasmiga ah" },
            { "zh_Hant", "Shiinahii Hore" },
            { "%%AO1990", "Heshiiska luuqada orthografiga burtuqiiska 1990" },
            { "%%DAJNKO", "alfabeetka Dajnko" },
            { "%%EKAVSK", "dhaqyada isku jirka ah ee Serbiyaanka iyo Ekviyaan" },
            { "%%NDYUKA", "lahjada Ndyuka" },
            { "%%NICARD", "KAARKANI" },
            { "%%SCOUSE", "GARAACID" },
            { "%%SIMPLE", "Fudud" },
            { "%%TARASK", "orthographyga Taraskievica" },
            { "%%UCRCOR", "orthographyga mideeysan ee hadana ladul maray" },
            { "%%ABL1943", "Qaacideeynta orthographygii 1943" },
            { "%%ALALC97", "ALA-LC Romanization, 1997 daabacaad" },
            { "%%BALANKA", "Lahjada Balanka ee Anii" },
            { "%%BOHORIC", "Farta Bohori\u010d" },
            { "%%EMODENG", "Ingiriiskii hore ee casriga ahaa" },
            { "%%METELKO", "alfaabeetka nmetelko" },
            { "%%MONOTON", "MOONOTOONIK" },
            { "%%1606NICT", "Fransiiskii dhexe ee ugu dambeeyay ilaa 1606" },
            { "%%1694ACAD", "Faransiiskii Hore" },
            { "%%1959ACAD", "Tacliin" },
            { "%%BAKU1926", "Farta Latin Turkiga ee Mideeysan" },
            { "%%BORNHOLM", "BOONHOLM" },
            { "%%COLB1945", "Shirkii orthografiga ee Portuguese-Brazilian 1945" },
            { "%%IJEKAVSK", "dhawaaqyada Serbiyaanka iyo Ijekaviyaan" },
            { "%%LENGADOC", "LENGADOK" },
            { "%%LUNA1918", "LUUNA1918" },
            { "%%NEWFOUND", "HELITAANCUSUB" },
            { "%%OXENDICT", "hinggaadinta Qaamuuska Ingiriisiga Oxford" },
            { "%%SCOTLAND", "Heerka Ingiriisiga Iskootishka" },
            { "%%VALENCIA", "Faleensiyaawi" },
            { "type.ca.roc", "Habeentiriska Minguwo" },
            { "type.co.eor", "Xeerarka Dalabka Yurub" },
            { "type.hc.h11", "12 Saac ee Nidaamka Saacadda (0\u201312)" },
            { "type.hc.h12", "12 Saac ee Nidaamka Saacadda (1\u201312)" },
            { "type.hc.h23", "24 Saac ee Nidaamka Saacadda (0\u201323)" },
            { "type.hc.h24", "24 Saac ee Nidaamka Saacadda (1\u201324)" },
            { "type.nu.ahom", "Godadka Ahom" },
            { "type.nu.arab", "Gdadka Carabi-Hindiya" },
            { "type.nu.armn", "Nidaam Tireedka Armeeniya" },
            { "type.nu.bali", "Godadka Balinese" },
            { "type.nu.beng", "Godadka Banglaa" },
            { "type.nu.brah", "Godadka Brahmi" },
            { "type.nu.cakm", "Godadka Chakma" },
            { "type.nu.cham", "Godadka cham" },
            { "type.nu.cyrl", "Lambarada Cyrillic" },
            { "type.nu.deva", "Godadka Defangaari" },
            { "type.nu.diak", "Godadka Dives Akuru" },
            { "type.nu.ethi", "Nidaam Tireedka Itoobiya" },
            { "type.nu.geor", "Nidaam Tireedka Giyoorgiyaanka" },
            { "type.nu.gong", "Godadka Gunjala Gondi" },
            { "type.nu.gonm", "Lambarada Masaram Gondi" },
            { "type.nu.grek", "Nidaam Tireedka Giriiga" },
            { "type.nu.gujr", "Godadka Gujaraati" },
            { "type.nu.guru", "Godadka Gurmukhi" },
            { "type.nu.hans", "Nidaam Tireedka Hore La Fududeeyay ee Shiinaha" },
            { "type.nu.hant", "Nidaam Tireedka Hore ee Shiinaha" },
            { "type.nu.hebr", "Nidaam Tireedka Cibraanka" },
            { "type.nu.hmng", "Nidaam Tireedka Hebrew" },
            { "type.nu.hmnp", "Godadka Nyiakeng Puachue Hmong" },
            { "type.nu.java", "Godadka Javanese" },
            { "type.nu.jpan", "Nidaam Tireedka Jabbaanka" },
            { "type.nu.kali", "Godadka Kayah Li" },
            { "type.nu.khmr", "Godadka Khamer" },
            { "type.nu.knda", "Godadka Kanada" },
            { "type.nu.lana", "Godadka Tai Tham Hora" },
            { "type.nu.laoo", "Godadka Laao" },
            { "type.nu.latn", "Godadka Ree Galbeedka" },
            { "type.nu.lepc", "Godadka Lepcha" },
            { "type.nu.limb", "Godadka Limbu" },
            { "type.nu.mlym", "Godadka Malayalam" },
            { "type.nu.modi", "Godadka Modi" },
            { "type.nu.mong", "Godadka Mongooliyaanka" },
            { "type.nu.mroo", "Godadka Mro" },
            { "type.nu.mtei", "Godadka Meetei Mayek" },
            { "type.nu.mymr", "Godadka Mayanmaar" },
            { "type.nu.nkoo", "Godadka N\u2019Ko" },
            { "type.nu.olck", "Godadka Ol Chiki" },
            { "type.nu.orya", "Godadka Oodhiya" },
            { "type.nu.osma", "Godadka Osmanya" },
            { "type.nu.rohg", "Godadka Hanifi Rohingya" },
            { "type.nu.saur", "Godadka Saurashtra" },
            { "type.nu.shrd", "Godadka Sharada" },
            { "type.nu.sind", "Godadka Khudawadi" },
            { "type.nu.sinh", "Godadka Sinhala Lith" },
            { "type.nu.sora", "Godadka Sora Sompeng" },
            { "type.nu.sund", "Godadka Sundaniiska" },
            { "type.nu.takr", "Godadka Takri" },
            { "type.nu.talu", "Godadka cusub ee Tai Lue" },
            { "type.nu.taml", "Nidaam Tireedki Hore ee Taaamiil" },
            { "type.nu.telu", "Godka Tirada Telugu" },
            { "type.nu.thai", "Godka Tirada Thai" },
            { "type.nu.tibt", "Godka Tirada Tibetan" },
            { "type.nu.tirh", "Godadka Tirhuta" },
            { "type.nu.vaii", "Godadka Vai" },
            { "type.nu.wara", "Godadka Warang Citi" },
            { "type.nu.wcho", "Godadka Wancho" },
            { "type.ca.dangi", "Habeetiriska Dangi" },
            { "type.co.ducet", "Lambar Sireedka Caalamiga ee Kala Soocidda Dalabka" },
            { "type.co.emoji", "Isku hagaajinta Emojiga" },
            { "type.lb.loose", "Habka Jabinta Xariiqda Dabacsan" },
            { "type.nu.roman", "Nidaam Tireedka Roomaanka" },
            { "type.ca.coptic", "Habeentiriska Koptiga" },
            { "type.ca.hebrew", "Habeentiriska yuhuudda" },
            { "type.ca.indian", "Habeentiris Qarameedka Hindiya" },
            { "type.co.compat", "Iswaafajinta Isku hajintii hore" },
            { "type.co.pinyin", "Isku hagaajinta Pinyin" },
            { "type.co.search", "Raadinta Guud" },
            { "type.co.stroke", "Isku hagaajinta Farta" },
            { "type.co.unihan", "Isku hagaajinta Farta Radical-Stroke" },
            { "type.co.zhuyin", "Isku hagaajinta Farta Zhuyin" },
            { "type.lb.normal", "Habka Jabinta Xariiqda Caadiga ah" },
            { "type.lb.strict", "Habka Jabinta Xariiqda Adag" },
            { "type.ms.metric", "Nidaamka Metric" },
            { "type.ca.chinese", "Habeetiriska Shiinaha" },
            { "type.ca.islamic", "Habeentiriska islaamka" },
            { "type.ca.iso8601", "Habeentiriska ISO-8601" },
            { "type.ca.persian", "Habeentiriska Baarshiyaanka" },
            { "type.cf.account", "Habka Xisaabinta Lacagta" },
            { "type.co.big5han", "Isku hagaajinta Shiineeskii Hore - Big5" },
            { "type.nu.arabext", "Tirooyinka Dheeraadka ah ee Godadka Carabi-Hindiya" },
            { "type.nu.armnlow", "Nidaam Tireedka Yaryar ee Armeeniya" },
            { "type.nu.greklow", "Nidaam Tireedka Yaryar ee Giriiga" },
            { "type.nu.hanidec", "Nidaamka Tireedka Tobanle ee Shiinaha" },
            { "type.nu.hansfin", "Nidaam Tireedka Hore La Fududeeyay ee Dhaqaalaha Shiinaha" },
            { "type.nu.hantfin", "Nidaam Tireedkii Hore ee Dhaqaalaha Shiinaha" },
            { "type.nu.jpanfin", "Nidaam Tireedka Dhaqaalaha Jabbaanka" },
            { "type.nu.mathdbl", "Godad Xisaabeedka Labalaabma" },
            { "type.nu.tamldec", "Godka Tirada Taamiil" },
            { "type.ca.buddhist", "Habeentiriska Buudhist" },
            { "type.ca.ethiopic", "Habeentiriska Itoobiya" },
            { "type.ca.japanese", "Habeentiriska jabbaanka" },
            { "type.cf.standard", "Habka Heerka Lacagta" },
            { "type.co.reformed", "Isku hagaajinta Reformed" },
            { "type.co.searchjl", "Raadinta Shibanaha Hangul" },
            { "type.co.standard", "Amarka Kala Soocidda Caadiga ah" },
            { "type.ms.uksystem", "Nidaamka Cabbirka Imperial-ka" },
            { "type.ms.ussystem", "Nidaamka Cabbirka ee US" },
            { "type.nu.fullwide", "Ballac Godadka Buuxa" },
            { "type.nu.lanatham", "Godadka Tai Tham" },
            { "type.nu.mathbold", "Godad Xisaabeedka Waaweeyn" },
            { "type.nu.mathmono", "Godad Xisaabeedka Monospace" },
            { "type.nu.mathsanb", "Godad xisaabeedka waaweeyn ee Sans-Serif" },
            { "type.nu.mathsans", "Godad xisaabeedka Sans-Serif" },
            { "type.nu.mymrshan", "Godadka Myanmar Shan" },
            { "type.nu.mymrtlng", "Godadka Myanmar Tai Laing" },
            { "type.nu.romanlow", "Nidaam Tireedka yaryar ee Roomaanka" },
            { "type.ca.gregorian", "Habeetiriska Geregoriyaan" },
            { "type.co.gb2312han", "Isku hagaajinta Farta shiineeska" },
            { "type.co.phonebook", "Isku hagaajinta foonbuuga" },
            { "type.co.dictionary", "Isku hagaajinta Qaamuuska" },
            { "type.co.traditional", "Isku hagaajin Fareedkii Hore" },
            { "type.ca.islamic-tbla", "Taariikhda Islaamiga (shax ahaan, waayo xiddigeed)" },
            { "type.ca.islamic-civil", "Taariikhda Islaamiga (shax ahaan, waayo madaniyeed)" },
            { "type.ca.islamic-umalqura", "Taariikhda Islaamiga(Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Taariikhda Itoobiya ee Amete Alem" },
        };
        return data;
    }
}
