/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ks extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TO = "\u0679\u0648\u0646\u06af\u0627";
        final String metaValue_ar = "\u0639\u0631\u0628\u06cc";
        final String metaValue_ae = "\u0627\u064e\u0648\u06cc\u0633\u062a\u064e\u0646";
        final String metaValue_chr = "\u0686\u06cc\u0631\u0648\u06a9\u06cc";
        final String metaValue_cop = "\u06a9\u0627\u067e\u0679\u0650\u06a9";
        final String metaValue_ka = "\u062c\u0627\u0631\u062c\u0650\u06cc\u064e\u0646";
        final String metaValue_got = "\u06af\u0648\u062a\u06be\u0650\u06a9";
        final String metaValue_ko = "\u06a9\u0648\u0631\u06cc\u064e\u0646";
        final String metaValue_lo = "\u0644\u0627\u0648";
        final String metaValue_nqo = "\u0627\u06cc\u0646 \u06a9\u0648";
        final String metaValue_si = "\u0633\u0650\u0646\u06c1\u0627\u0644\u0627";
        final String metaValue_su = "\u0633\u064e\u0646\u0688\u064e\u0646\u06cc\u0656\u0632";
        final String metaValue_ta = "\u062a\u064e\u0645\u0650\u0644";
        final String metaValue_te = "\u062a\u06cc\u0644\u06af\u0648\u0657";
        final String metaValue_th = "\u062a\u06be\u0627\u06d2";
        final String metaValue_bo = "\u062a\u0650\u0628\u062a\u06cc";
        final String metaValue_vai = "\u0648\u0627\u06d2";
        final String metaValue_peo = "\u067e\u0631\u0648\u0646 \u0641\u0627\u0631\u0633\u06cc";
        final String metaValue_ru = "\u0631\u0648\u0657\u0633\u06cc";
        final Object[][] data = new Object[][] {
            { "001", "\u062f\u064f\u0646\u06cc\u0627" },
            { "002", "\u0627\u064e\u0641\u0631\u06cc\u0656\u06a9\u0627" },
            { "003", "\u0634\u064f\u0645\u0672\u0644\u06cc \u0627\u064e\u0645\u0631\u06cc\u0656\u06a9\u0627" },
            { "005", "\u062c\u064e\u0646\u0648\u0657\u0646\u06cc \u0627\u064e\u0645\u0631\u0656\u06cc\u0656\u06a9\u0627" },
            { "009", "\u0627\u0648\u0634\u064e\u0646\u06cc\u0627" },
            { "011", "\u0645\u064e\u063a\u0631\u06cc\u0656\u0628\u06cc \u0627\u064e\u0641\u0631\u06cc\u0656\u06a9\u0627" },
            { "013", "\u0645\u0631\u06a9\u0654\u0632\u06cc \u0627\u064e\u0645\u0631\u06cc\u0656\u06a9\u0627" },
            { "014", "\u0645\u064e\u0634\u0631\u0650\u0642\u06cc \u0627\u064e\u0641\u0631\u06cc\u0656\u06a9\u0627" },
            { "015", "\u0634\u064f\u0645\u0672\u0644\u06cc \u0627\u064e\u0641\u0631\u06cc\u0656\u06a9\u0627" },
            { "017", "\u0648\u0633\u0637\u06cc \u0627\u064e\u0641\u0631\u06cc\u0656\u06a9\u0627" },
            { "018", "\u062c\u0646\u0648\u0657\u0628\u06cc \u0627\u064e\u0641\u0631\u06cc\u0656\u06a9\u0627" },
            { "019", "\u0627\u064e\u0645\u0631\u06cc\u0656\u06a9\u064e\u0633" },
            { "021", "\u0634\u064f\u0645\u0672\u0644\u06cc \u0627\u064e\u0645\u0631\u06cc\u0656\u06a9\u0627 \u062e\u0655\u0637\u06c1\u0655" },
            { "029", "\u06a9\u064e\u0631\u0650\u0628\u0628\u06cc\u0656\u0646" },
            { "030", "\u0645\u064e\u0634\u0631\u0650\u0642\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "034", "\u062c\u0646\u0648\u0657\u0628\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "035", "\u062c\u0646\u0648\u0657\u0628\u06c1\u0650 \u0645\u064e\u0634\u0631\u0650\u0642\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "039", "\u062c\u0646\u0648\u0657\u0628\u06cc \u06cc\u0648\u0657\u0631\u064e\u067e" },
            { "053", "\u0622\u0633\u0679\u0631\u06cc\u0644\u06cc\u0634\u06cc\u0627" },
            { "054", "\u0645\u0620\u0644\u064e\u0646\u06cc\u0656\u0634\u0650\u06cc\u0627" },
            { "057", "\u0645\u064e\u06cc\u06a9\u0631\u0648\u0646\u064e\u06cc\u0634\u0650\u06cc\u064e\u0646 \u062e\u0655\u0637\u06c1\u0655" },
            { "061", "\u067e\u0627\u0644\u0646\u06cc\u0634\u0650\u06cc\u0627" },
            { "142", "\u0627\u06cc\u0634\u06cc\u0627" },
            { "143", "\u0645\u0631\u06a9\u0654\u0632\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "145", "\u0645\u064e\u063a\u0631\u0650\u0628\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "150", "\u06cc\u0648\u0657\u0631\u064e\u067e" },
            { "151", "\u0645\u0634\u0631\u0650\u0642\u06cc \u06cc\u0648\u0657\u0631\u064e\u067e" },
            { "154", "\u0634\u064f\u0645\u0672\u0644\u06cc \u06cc\u0648\u0657\u0631\u064e\u067e" },
            { "155", "\u0645\u063a\u0631\u0650\u0628\u06cc \u06cc\u0648\u0657\u0631\u064e\u067e" },
            { "202", "\u0630\u06cc\u0644\u06cc \u0633\u06c1\u0627\u0631\u0646 \u0627\u0641\u0631\u06cc\u0642\u06c1" },
            { "419", "\u0644\u0627\u0637\u06cc\u0656\u0646\u06cc \u0627\u064e\u0645\u0631\u06cc\u0656\u06a9\u0627" },
            { "AC", "\u0627\u06cc\u0633\u0646\u0634\u0646 \u062c\u0632\u06cc\u0631\u0655" },
            { "AD", "\u0627\u06cc\u0646\u0688\u0648\u0631\u0627" },
            { "AE", "\u0645\u064f\u062a\u062d\u062f\u06c1 \u0639\u0631\u064e\u0628 \u0627\u0645\u0627\u0631\u0627\u062a" },
            { "AF", "\u0627\u064e\u0641\u063a\u0627\u0646\u064e\u0633\u062a\u0627\u0646" },
            { "AG", "\u0627\u0620\u0646\u0679\u0650\u06af\u064f\u0648\u0627 \u062a\u06c1\u0655 \u0628\u0627\u0631\u0628\u0648\u0691\u0627" },
            { "AI", "\u0627\u0646\u06af\u0648\u0626\u06cc\u0644\u0627" },
            { "AL", "\u0627\u0644\u0628\u0627\u0646\u06cc\u0627" },
            { "AM", "\u0627\u064e\u0631\u0645\u0627\u0646\u0650\u06cc\u0627" },
            { "AO", "\u0627\u0646\u06af\u0648\u0644\u0627" },
            { "AQ", "\u0627\u06cc\u0646\u0679\u0627\u0631\u0679\u0650\u06a9\u0627" },
            { "AR", "\u0623\u0631\u062c\u064e\u0646\u0679\u06cc\u0646\u0627" },
            { "AS", "\u0627\u064e\u0645\u0631\u06cc\u0656\u06a9\u064e\u0646 \u0633\u064e\u0645\u0648\u0627" },
            { "AT", "\u0622\u0633\u0679\u0631\u06cc\u0627" },
            { "AU", "\u0622\u0633\u0679\u0631\u06cc\u0644\u0650\u06cc\u0627" },
            { "AW", "\u0627\u064e\u0631\u0648\u0657\u0628\u0627" },
            { "AX", "\u0627\u06cc\u0644\u06cc\u0646\u0691 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "AZ", "\u0622\u0630\u0631\u0628\u0627\u0626\u06cc\u062c\u0627\u0646" },
            { "BA", "\u0628\u0648\u0633\u0646\u0650\u06cc\u0627 \u062a\u06c1\u0655 \u06c1\u064e\u0631\u0632\u0650\u06af\u0648\u0648\u0650\u0646\u0627" },
            { "BB", "\u0628\u0627\u0631\u0628\u06cc\u0688\u0648\u0633" },
            { "BD", "\u0628\u064e\u0646\u06af\u0644\u0627\u062f\u06cc\u0634" },
            { "BE", "\u0628\u06cc\u0644\u062c\u0650\u06cc\u064e\u0645" },
            { "BF", "\u0628\u064f\u0631\u06a9\u0650\u0646\u0627 \u0641\u06cc\u0633\u0648" },
            { "BG", "\u0628\u064e\u0644\u062c\u06cc\u0631\u0650\u06cc\u0627" },
            { "BH", "\u0628\u062d\u0631\u06cc\u0656\u0646" },
            { "BI", "\u0628\u0648\u0631\u064e\u0646\u0688\u0650" },
            { "BJ", "\u0628\u0650\u0646\u0650\u0646" },
            { "BL", "\u0633\u06cc\u0646\u0679 \u0628\u0627\u0631\u062a\u064e\u06be\u06cc\u0644\u0645\u06cc" },
            { "BM", "\u0628\u0631\u0645\u0648\u062f\u0627" },
            { "BN", "\u0628\u0631\u0648\u0646\u06d2" },
            { "BO", "\u0628\u0648\u0644\u0650\u0648\u0650\u06cc\u0627" },
            { "BQ", "\u06a9\u06cc\u0631\u06cc\u0628\u06cc\u0646 \u0646\u06cc\u062f\u0631\u0644\u06cc\u0646\u0688\u0633" },
            { "BR", "\u0628\u0631\u0627\u0632\u0650\u0644" },
            { "BS", "\u0628\u064e\u06c1\u0627\u0645\u064e\u0633" },
            { "BT", "\u0628\u0648\u0657\u0679\u0627\u0646" },
            { "BV", "\u0628\u0648\u0648\u064e\u0679 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "BW", "\u0628\u0648\u062a\u064e\u0633\u0648\u0627\u0646\u0627" },
            { "BY", "\u0628\u06cc\u0644\u0627\u0631\u0648\u0657\u0633" },
            { "BZ", "\u0628\u06cc\u0644\u0632" },
            { "CA", "\u06a9\u06cc\u0646\u06cc\u0688\u0627" },
            { "CC", "\u06a9\u0648\u06a9\u064e\u0633 (\u06a9\u06cc\u0656\u0644\u0650\u0646\u06af) \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "CD", "\u06a9\u0648\u0646\u06af\u0648 \u06a9\u0650\u0646\u0634\u0627\u0633\u0627" },
            { "CF", "\u0645\u0631\u06a9\u0654\u0632\u06cc \u0627\u064e\u0641\u0631\u06cc\u0656\u06a9\u06cc \u062c\u0645\u0648\u0657\u0631\u06cc\u064e\u062a" },
            { "CG", "\u06a9\u0648\u0646\u06af\u0648 \u0628\u0654\u0631\u0632\u0627\u0648\u0650\u0644\u06cc" },
            { "CH", "\u0633\u064f\u0648\u0650\u0632\u064e\u0631\u0644\u06cc\u0646\u0691" },
            { "CI", "\u06a9\u0648\u0679 \u0688\u0644\u0648\u0627\u0626\u0631" },
            { "CK", "\u06a9\u064f\u06a9 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "CL", "\u0686\u0650\u0644\u06cc" },
            { "CM", "\u06a9\u06cc\u0645\u0650\u0631\u0648\u0657\u0646" },
            { "CN", "\u0686\u06cc\u0656\u0646" },
            { "CO", "\u06a9\u0648\u0644\u064e\u0645\u0628\u0650\u06cc\u0627" },
            { "CP", "\u06a9\u0644\u06cc\u067e\u0631\u0679\u0646 \u062c\u0632\u06cc\u0631\u0655" },
            { "CR", "\u06a9\u0648\u0633\u0679\u0627 \u0631\u06cc\u06a9\u0627" },
            { "CU", "\u06a9\u06cc\u0648\u0657\u0628\u0627" },
            { "CV", "\u06a9\u06cc\u067e \u0624\u0631\u0691\u06cc" },
            { "CW", "\u06a9\u06cc\u0648\u0631\u0627\u06a9\u0648" },
            { "CX", "\u06a9\u0631\u0650\u0633\u0645\u064e\u0633 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "CY", "\u0633\u0627\u0626\u067e\u0631\u0633" },
            { "CZ", "\u0686\u06cc\u06a9\u06cc\u0627" },
            { "DE", "\u062c\u0631\u0645\u0654\u0646\u06cc" },
            { "DG", "\u0688\u06cc\u06af\u0648 \u06af\u0631\u06cc\u0634\u06cc\u0627" },
            { "DJ", "\u062c\u0650\u0628\u0648\u0657\u062a\u06cc" },
            { "DK", "\u0688\u06cc\u0646\u0645\u0627\u0631\u0655\u06a9" },
            { "DM", "\u0688\u0648\u0645\u0650\u0646\u0650\u06a9\u0627" },
            { "DO", "\u0688\u0648\u0645\u0650\u0646\u0650\u06a9\u064e\u0646 \u062c\u0645\u0648\u0657\u0631\u0650\u06cc\u064e\u062a" },
            { "DZ", "\u0627\u0620\u0644\u062c\u06cc\u0631\u0650\u06cc\u0627" },
            { "EA", "\u0633\u06cc\u0648\u0679\u0627 \u062a\u0655\u06c1 \u0645\u0654\u0644\u06cc\u0644\u0627" },
            { "EC", "\u0627\u0650\u06a9\u0648\u0627\u0691\u0648\u0631" },
            { "EE", "\u0627\u06cc\u0633\u0679\u0648\u0646\u0650\u06cc\u0627" },
            { "EG", "\u0645\u0635\u0631" },
            { "EH", "\u0645\u0634\u0631\u0650\u0642\u06cc \u0633\u064e\u06c1\u0627\u0631\u0627" },
            { "ER", "\u0627\u0650\u0631\u0655\u0679\u0650\u06cc\u0627" },
            { "ES", "\u0633\u0655\u067e\u06cc\u0646" },
            { "ET", "\u0627\u0650\u062a\u06be\u0648\u067e\u0650\u06cc\u0627" },
            { "EU", "\u06cc\u0648\u0657\u0631\u067e\u06cc \u06cc\u0648\u0646\u06cc\u0646" },
            { "EZ", "\u06cc\u0648\u0657\u0631\u0648 \u0632\u0648\u0646" },
            { "FI", "\u0641\u0650\u0646 \u0644\u06cc\u0646\u0688" },
            { "FJ", "\u0641\u0650\u062c\u06cc" },
            { "FK", "\u0641\u0655\u0644\u0627\u06a9\u0644\u06cc\u0646\u0691 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "FM", "\u0645\u0627\u0626\u06cc\u06a9\u0631\u0648\u0646\u06cc\u0634\u06cc\u0627" },
            { "FO", "\u0641\u0627\u0631\u0648 \u062c\u0632\u06cc\u0631\u06c1" },
            { "FR", "\u0641\u0631\u0627\u0646\u0633" },
            { "GA", "\u06af\u06cc\u0628\u0627\u0646" },
            { "GB", "\u0645\u062a\u062d\u062f\u06c1 \u0645\u0645\u0644\u0650\u06a9\u062a" },
            { "GD", "\u06af\u0631\u06cc\u0646\u06cc\u0688\u0627" },
            { "GE", "\u062c\u0627\u0631\u062c\u0650\u06cc\u0627" },
            { "GF", "\u0641\u0631\u0627\u0646\u0633\u0650\u0633\u06cc \u06af\u0650\u0627\u0646\u0627" },
            { "GG", "\u06af\u0648\u0631\u0646\u0633\u06d2" },
            { "GH", "\u06af\u0627\u0646\u0627" },
            { "GI", "\u062c\u0650\u0628\u0631\u0627\u0644\u0679\u064e\u0631" },
            { "GL", "\u06af\u0631\u06cc\u0646 \u0644\u06cc\u0646\u0688" },
            { "GM", "\u06af\u064e\u0645\u0628\u0650\u06cc\u0627" },
            { "GN", "\u06af\u0650\u0646\u06cc" },
            { "GP", "\u06af\u0648\u0627\u0688\u0644\u0648\u067e" },
            { "GQ", "\u0627\u0650\u06a9\u0648\u0650\u0679\u0648\u0631\u0650\u06cc\u064e\u0644 \u06af\u0650\u0646\u06cc" },
            { "GR", "\u06af\u0631\u06cc\u0656\u0633" },
            { "GS", "\u062c\u0646\u0648\u0657\u0628\u06cc \u062c\u0627\u0631\u062c\u0650\u06cc\u0627 \u062a\u06c1\u0655 \u062c\u0646\u0648\u0657\u0628\u06cc \u0633\u06cc\u0646\u0691\u0648\u0655\u0686 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "GT", "\u06af\u0648\u0627\u0679\u0645\u0627\u0644\u0627" },
            { "GU", "\u06af\u064f\u0648\u0627\u0645" },
            { "GW", "\u06af\u06cc\u0656\u0646\u06cc \u0628\u0650\u0633\u0627\u0648" },
            { "GY", "\u06af\u064f\u06cc\u0627\u0646\u0627" },
            { "HK", "\u06c1\u0627\u0646\u06af \u06a9\u0627\u0646\u06af \u0627\u06cc\u0633 \u0627\u06d2 \u0622\u0631 \u0686\u06cc\u0656\u0646" },
            { "HM", "\u06c1\u064e\u0631\u0655\u0691 \u062a\u06c1\u0655 \u0645\u0620\u06a9\u0688\u0648\u0646\u0627\u0644\u0691\u0655 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "HN", "\u06c1\u0648\u0646\u0688\u0648\u0631\u0633" },
            { "HR", "\u06a9\u0631\u0648\u0634\u0650\u06cc\u0627" },
            { "HT", "\u06c1\u06cc\u062a\u06cc" },
            { "HU", "\u06c1\u064e\u0646\u06af\u0631\u06cc" },
            { "IC", "\u06a9\u06cc\u0646\u0631\u06cc \u062c\u0632\u06cc\u0631\u0655" },
            { "ID", "\u0627\u0646\u0688\u0648\u0646\u06cc\u0634\u06cc\u0627" },
            { "IE", "\u0627\u064e\u06cc\u064e\u0631\u0644\u06cc\u0646\u0691" },
            { "IL", "\u0627\u0633\u0631\u0627 \u06cc\u06cc\u0644" },
            { "IM", "\u0622\u06cc\u0650\u0644 \u0622\u0641 \u0645\u06cc\u0646" },
            { "IN", "\u06c1\u0650\u0646\u062f\u0648\u0633\u062a\u0627\u0646" },
            { "IQ", "\u0627\u06cc\u0656\u0631\u0627\u0642" },
            { "IR", "\u0627\u06cc\u0656\u0631\u0627\u0646" },
            { "IS", "\u0627\u064e\u06cc\u0650\u0633\u0644\u06cc\u0646\u0691" },
            { "IT", "\u0627\u0650\u0679\u0644\u06cc" },
            { "JE", "\u062c\u0654\u0631\u0633\u06cc" },
            { "JM", "\u062c\u064e\u0645\u0627\u06cc\u06a9\u0627" },
            { "JO", "\u062c\u0648\u0631\u0688\u0646" },
            { "JP", "\u062c\u0627\u067e\u0627\u0646" },
            { "KE", "\u06a9\u0650\u0646\u06cc\u0627" },
            { "KG", "\u06a9\u0631\u063a\u0632\u0633\u062a\u0627\u0646" },
            { "KH", "\u06a9\u064e\u0645\u0628\u0648\u0691\u0650\u06cc\u0627" },
            { "KI", "\u06a9\u0650\u0631\u0655\u0628\u0627\u062a\u06cc" },
            { "KM", "\u06a9\u064e\u0645\u0648\u0631\u064e\u0633" },
            { "KN", "\u0633\u06cc\u0646\u0679 \u06a9\u0650\u0679\u064e\u0633 \u062a\u06c1\u0655 \u0646\u06cc\u0648\u0650\u0633" },
            { "KP", "\u0634\u064f\u0645\u0672\u0644\u06cc \u06a9\u0648\u0631\u0650\u06cc\u0627" },
            { "KR", "\u062c\u0646\u0648\u0657\u0628\u06cc \u06a9\u0648\u0631\u0650\u06cc\u0627" },
            { "KW", "\u06a9\u064f\u0648\u06cc\u062a" },
            { "KY", "\u06a9\u06cc\u0645\u064e\u0646 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "KZ", "\u0642\u0627\u0632\u0642\u0633\u062a\u0627\u0646" },
            { "LA", "\u0644\u0627\u0633" },
            { "LB", "\u0644\u0620\u0628\u0646\u0627\u0646" },
            { "LC", "\u0633\u06cc\u0646\u0679 \u0644\u0648\u0657\u0633\u0650\u06cc\u0627" },
            { "LI", "\u0644\u0650\u06a9\u0679\u06cc\u0633\u0679\u06cc\u0656\u0646" },
            { "LK", "\u0633\u0631\u06cc \u0644\u0646\u06a9\u0627" },
            { "LR", "\u0644\u0627\u06cc\u0628\u06cc\u0631\u0650\u06cc\u0627" },
            { "LS", "\u0644\u06cc\u0633\u0648\u062a\u06be\u0648" },
            { "LT", "\u0644\u0650\u062a\u06be\u064f\u0648\u0627\u0646\u0650\u06cc\u0627" },
            { "LU", "\u0644\u064e\u06a9\u0633\u064e\u0645\u0628\u0654\u0631\u0655\u06af" },
            { "LV", "\u0644\u06cc\u0679\u0648\u0650\u06cc\u0627" },
            { "LY", "\u0644\u0650\u0628\u06cc\u0627" },
            { "MA", "\u0645\u0648\u0631\u0648\u06a9\u0648" },
            { "MC", "\u0645\u0648\u0646\u06cc\u06a9\u0648" },
            { "MD", "\u0645\u0648\u0644\u0688\u0648\u0648\u0627" },
            { "ME", "\u0645\u0648\u0679\u0648\u0646\u06cc\u06af\u0650\u0631\u06cc\u0648" },
            { "MF", "\u0633\u06cc\u0646\u0679 \u0645\u0627\u0631\u0679\u0650\u0646" },
            { "MG", "\u0645\u06cc\u0688\u0627\u06af\u0627\u0633\u06a9\u0627\u0631" },
            { "MH", "\u0645\u0627\u0631\u0634\u064e\u0644 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "MK", "\u0634\u064f\u0645\u0627\u0644\u06cc \u0645\u06cc\u0633\u0688\u0648\u0646\u06cc\u0627" },
            { "ML", "\u0645\u0627\u0644\u06cc" },
            { "MM", "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631 (\u0628\u0631\u0645\u0627)" },
            { "MN", "\u0645\u064e\u0646\u06af\u0648\u0644\u0650\u06cc\u0627" },
            { "MO", "\u0645\u064e\u06a9\u0627\u0648\u0648 \u0627\u06cc\u0633 \u0627\u06d2 \u0622\u0631 \u0686\u06cc\u0656\u0646" },
            { "MP", "\u0634\u064f\u0645\u0672\u0644\u06cc \u0645\u0627\u0631\u0650\u06cc\u0627\u0646\u0627 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "MQ", "\u0645\u0627\u0631\u0679\u0650\u0646\u0650\u06a9" },
            { "MR", "\u0645\u0627\u0631\u0655\u0679\u0627\u0646\u0650\u06cc\u0627" },
            { "MS", "\u0645\u0627\u0646\u0679\u0633\u06cc\u0631\u0627\u0679" },
            { "MT", "\u0645\u0627\u0644\u0679\u0627" },
            { "MU", "\u0645\u0648\u0631\u0650\u0634\u064e\u0633" },
            { "MV", "\u0645\u0627\u0644\u062f\u06cc\u0656\u0648" },
            { "MW", "\u0645\u0644\u0627\u0648\u06cc" },
            { "MX", "\u0645\u0620\u06a9\u0633\u0650\u06a9\u0648" },
            { "MY", "\u0645\u064e\u0644\u06cc\u0634\u0650\u06cc\u0627" },
            { "MZ", "\u0645\u0648\u0632\u064e\u0645\u0628\u0650\u06a9" },
            { "NA", "\u0646\u0627\u0645\u0650\u0628\u0650\u06cc\u0627" },
            { "NC", "\u0646\u0650\u0648 \u06a9\u06cc\u0644\u0650\u0691\u0648\u0646\u0650\u06cc\u0627" },
            { "NE", "\u0646\u0627\u06cc\u062c\u064e\u0631" },
            { "NF", "\u0646\u0627\u0631\u0641\u0627\u06a9 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "NG", "\u0646\u0627\u06cc\u062c\u06cc\u0631\u0650\u06cc\u0627" },
            { "NI", "\u0646\u0627\u06a9\u0627\u0631\u0627\u06af\u064f\u0648\u0627" },
            { "NL", "\u0646\u06cc\u0656\u062f\u064e\u0631\u0644\u06cc\u0646\u0691" },
            { "NO", "\u0646\u0627\u0631\u0648\u06d2" },
            { "NP", "\u0646\u06cc\u067e\u0627\u0644" },
            { "NR", "\u0646\u0627\u0631\u0648\u0648\u0657" },
            { "NU", "\u0646\u06cc\u0648\u0657" },
            { "NZ", "\u0646\u06cc\u0648\u0632\u06cc \u0644\u06cc\u0646\u0688" },
            { "OM", "\u0627\u0648\u0645\u0627\u0646" },
            { "PA", "\u067e\u064e\u0646\u0627\u0645\u0627" },
            { "PE", "\u067e\u06cc\u0656\u0631\u0648\u0657" },
            { "PF", "\u0641\u0631\u0627\u0646\u0633\u06cc \u067e\u0648\u0644\u0650\u0646\u06cc\u0634\u0650\u06cc\u0627" },
            { "PG", "\u067e\u0627\u067e\u064f\u0648\u0627 \u0646\u06cc\u0648\u0657 \u06af\u06cc\u0656\u0646\u06cc" },
            { "PH", "\u0641\u0644\u067e\u0627\u0626\u0646" },
            { "PK", "\u067e\u0627\u06a9\u0650\u0633\u062a\u0627\u0646" },
            { "PL", "\u067e\u0648\u0644\u06cc\u0646\u0688" },
            { "PM", "\u0633\u06cc\u0646\u0679 \u067e\u06cc\u0656\u0631\u06cc \u062a\u06c1\u0655 \u0645\u0648\u06a9\u06cc\u0644\u0650\u06cc\u064e\u0646" },
            { "PN", "\u067e\u0650\u0679\u06a9\u06cc\u0631\u0655\u0646\u06cd \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "PR", "\u067e\u0654\u0631\u0679\u0648 \u0631\u0650\u06a9\u0648" },
            { "PS", "\u0641\u0644\u0633\u0637\u06cc\u0646\u06cc \u0639\u0644\u0627\u0642\u0655\u06c1" },
            { "PT", "\u067e\u064f\u0631\u062a\u0650\u06af\u0627\u0644" },
            { "PW", "\u067e\u064e\u0644\u0627\u0648" },
            { "PY", "\u067e\u064e\u0631\u0627\u06af\u064f\u06d2" },
            { "QA", "\u0642\u064e\u0637\u0650\u0631" },
            { "QO", "\u0622\u0648\u064f\u0679\u0644\u0627\u06cc\u0646\u0650\u06af \u0627\u0648\u0634\u06cc\u0646\u0650\u06cc\u0627" },
            { "RE", "\u0631\u0650\u06cc\u0648\u0657\u0646\u0650\u06cc\u064e\u0646" },
            { "RO", "\u0631\u0648\u0645\u0627\u0646\u0650\u06cc\u0627" },
            { "RS", "\u0633\u064e\u0631\u0628\u0650\u06cc\u0627" },
            { "RU", "\u0631\u0648\u0657\u0633" },
            { "RW", "\u0631\u0648\u0657\u0648\u0627\u0646\u0688\u0627" },
            { "SA", "\u0633\u0639\u0648\u062f\u06cc \u0639\u0631\u0628" },
            { "SB", "\u0633\u0648\u0644\u0627\u0645\u0627\u0646 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "SC", "\u0633\u06cc\u0634\u064e\u0644\u0650\u0633" },
            { "SD", "\u0633\u0648\u0657\u0688\u0627\u0646" },
            { "SE", "\u0633\u0648\u06cc\u0688\u0646" },
            { "SG", "\u0633\u0650\u0646\u06af\u0627\u067e\u0648\u0657\u0631" },
            { "SH", "\u0633\u06cc\u0646\u0679 \u06c1\u0620\u0644\u0650\u0646\u0627" },
            { "SI", "\u0633\u064e\u0644\u0648\u0648\u06cc\u0646\u0650\u06cc\u0627" },
            { "SJ", "\u0633\u064e\u0648\u0627\u0644\u0628\u0631\u06cc\u0691 \u062a\u06c1\u0655 \u062c\u0627\u0646 \u0645\u0627\u06cc\u06cc\u0691" },
            { "SK", "\u0633\u064e\u0644\u0648\u0648\u0627\u06a9\u0650\u06cc\u0627" },
            { "SL", "\u0633\u06cc\u0631\u0627 \u0644\u06cc\u0648\u0646" },
            { "SM", "\u0633\u06cc\u0646 \u0645\u06cc\u0631\u0650\u0646\u0648" },
            { "SN", "\u0633\u06cc\u0646\u06cc\u06af\u064e\u0644" },
            { "SO", "\u0633\u0648\u0645\u0627\u0644\u0650\u06cc\u0627" },
            { "SR", "\u0633\u064f\u0631\u0650\u0646\u0627\u0645" },
            { "SS", "\u062c\u0646\u0648\u0628\u06cc \u0633\u0648\u0688\u0627\u0646" },
            { "ST", "\u0633\u0627\u0648 \u062a\u0648\u0645 \u062a\u06c1\u0655 \u067e\u0631\u0646\u0633\u0650\u067e\u06cc" },
            { "SV", "\u0627\u06cc\u0644 \u0633\u0644\u0648\u06cc\u0688\u0631" },
            { "SX", "\u0633\u0650\u0646\u0679 \u0645\u0627\u0631\u0679\u0650\u0646" },
            { "SY", "\u0634\u0627\u0645" },
            { "SZ", "\u0627\u06cc\u0633\u0648\u0627\u062a\u0646\u06cc" },
            { "TA", "\u0679\u0631\u06cc\u0633\u0679\u0646 \u0688\u0627 \u06a9\u0646\u06c1\u0627" },
            { "TC", "\u062a\u064f\u0631\u06a9\u0633 \u062a\u0655\u06c1 \u06a9\u06cc\u06a9\u0648 \u062c\u0632\u06cc\u0631\u0655" },
            { "TD", "\u0686\u0627\u0691" },
            { "TF", "\u0641\u0631\u0627\u0646\u0633\u0650\u0633\u06cc \u062c\u064e\u0646\u0648\u0657\u0628\u06cc \u0639\u064e\u0644\u0627\u0642\u06c1\u0655" },
            { "TG", "\u0679\u0648\u06af\u0648" },
            { "TH", "\u062a\u06be\u0627\u0626\u06cc \u0644\u06cc\u0646\u0688" },
            { "TJ", "\u062a\u0627\u062c\u06a9\u0650\u0633\u062a\u0627\u0646" },
            { "TK", "\u0679\u0648\u06a9\u0644\u0648" },
            { "TL", "\u062a\u06cc\u0645\u0648\u0631-\u0644\u06cc\u0633\u0679" },
            { "TM", "\u062a\u064f\u0631\u06a9\u0645\u0646\u0633\u062a\u0627\u0646" },
            { "TN", "\u0679\u0648\u0646\u06cc\u0634\u0650\u06cc\u0627" },
            { "TO", metaValue_TO },
            { "TR", "\u062a\u064f\u0631\u06a9\u06cc" },
            { "TT", "\u0679\u0631\u0646\u0650\u0646\u062f\u0627\u062f \u062a\u06c1\u0655 \u0679\u0648\u0628\u06cc\u06af\u0648" },
            { "TV", "\u062a\u0648\u0657\u0648\u0627\u0644\u0648\u0657" },
            { "TW", "\u062a\u0627\u06cc\u0648\u0627\u0646" },
            { "TZ", "\u062a\u064e\u0646\u062c\u0627\u0646\u0650\u06cc\u0627" },
            { "UA", "\u06cc\u0648\u0657\u0631\u0650\u06a9\u06cc\u0646" },
            { "UG", "\u06cc\u0648\u0657\u06af\u0627\u0646\u0691\u0627" },
            { "UM", "\u06cc\u0648\u0657\u0646\u0627\u06cc\u0679\u0650\u0691 \u0633\u0650\u0679\u06cc\u0679\u0650\u0633 \u0645\u0627\u06cc\u0646\u064e\u0631 \u0622\u0648\u064f\u0679\u0644\u06cc\u06cc\u0650\u0646\u06af \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "UN", "\u0645\u062a\u062d\u062f\u06c1 \u0645\u064f\u0645\u0672\u0644\u06a9" },
            { "US", "\u06cc\u0648\u0657\u0646\u0627\u06cc\u0679\u0650\u0691 \u0633\u0650\u0679\u06cc\u0679\u0650\u0633" },
            { "UY", "\u06cc\u0648\u0657\u0631\u0648\u06af\u06d2" },
            { "UZ", "\u0627\u064f\u0632\u0628\u0650\u06a9\u0650\u0633\u062a\u0627\u0646" },
            { "VA", "\u0648\u06cc\u0679\u0650\u06a9\u064e\u0646 \u0633\u0650\u0679\u06cc" },
            { "VC", "\u0633\u06cc\u0646\u0679 \u0648\u06cc\u0646\u0633\u0620\u0679 \u062a\u06c1\u0655 \u06af\u0631\u06cc\u0646\u0627\u0691\u0627\u06cc\u0646\u0655\u0632" },
            { "VE", "\u0648\u06cc\u0646\u0627\u0632\u0648\u0657\u0644\u0627" },
            { "VG", "\u0628\u064e\u0631\u0637\u0627\u0646\u0648\u06cc \u0624\u0631\u062c\u0650\u0646 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "VI", "\u06cc\u0648\u0657 \u0627\u06cc\u0633 \u0624\u0631\u062c\u0650\u0646 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "VN", "\u0648\u06cc\u062a\u0646\u0627\u0645" },
            { "VU", "\u0648\u0627\u0646\u0648\u0657\u062a\u0648\u0657" },
            { "WF", "\u0648\u0627\u0644\u0650\u0633 \u062a\u06c1\u0655 \u0641\u06cc\u0648\u0657\u0686\u0648\u0657\u0646\u0627" },
            { "WS", "\u0633\u0627\u0645\u0648" },
            { "XA", "\u0633\u0648\u0688\u0648-\u0627\u06cc\u0633\u0646\u0679\u0633" },
            { "XB", "\u0633\u0648\u0688\u0648-\u0628\u06cc\u0688\u06cc" },
            { "XK", "\u06a9\u0648\u0633\u0648\u0648" },
            { "YE", "\u06cc\u064e\u0645\u064e\u0646" },
            { "YT", "\u0645\u064e\u06cc\u06cc\u0679" },
            { "ZA", "\u062c\u0646\u0648\u0628\u06cc \u0627\u0641\u0631\u06cc\u0642\u06c1" },
            { "ZM", "\u0632\u06cc\u0645\u0628\u06cc\u0627" },
            { "ZW", "\u0632\u0650\u0645\u0628\u0627\u0628\u06d2" },
            { "ZZ", "\u0646\u0627\u0645\u0648\u0644\u0648\u0657\u0645 \u0639\u0644\u0627\u0642\u0655\u06c1" },
            { "aa", "\u0627\u064e\u0641\u0627\u0631" },
            { "ab", "\u0627\u064e\u0628\u062e\u0627\u0632\u0650\u06cc\u0627\u0646" },
            { "ae", metaValue_ae },
            { "af", "\u0627\u064e\u0641\u0631\u06cc\u0656\u06a9\u0627\u0646\u0632" },
            { "ak", "\u0627\u064e\u06a9\u0627\u0646" },
            { "am", "\u0627\u064e\u0645\u06c1\u0627\u0631\u06cc" },
            { "an", "\u0627\u064e\u0631\u0627\u06af\u0648\u0646\u06cc" },
            { "ar", metaValue_ar },
            { "as", "\u0627\u0633\u0672\u0645\u06cd" },
            { "av", "\u0627\u064e\u0648\u0627\u0631\u0650\u06a9" },
            { "ay", "\u0627\u06cc\u0645\u0627\u0631\u0627" },
            { "az", "\u0627\u064e\u0632\u064e\u0631\u0628\u06cc\u062c\u0627\u0646\u06cc" },
            { "ba", "\u0628\u064e\u0634\u06a9\u06cc\u0656\u0631" },
            { "be", "\u0628\u06cc\u0644\u064e\u0631\u0648\u0657\u0634\u06cc\u064e\u0646" },
            { "bg", "\u0628\u06cc\u0646\u0627" },
            { "bi", "\u0628\u0650\u0633\u0644\u0627\u0645\u0627" },
            { "bm", "\u0628\u064e\u0645\u0628\u0627\u0631\u0627" },
            { "bn", "\u0628\u064e\u0646\u06af\u0672\u0644\u06cd" },
            { "bo", metaValue_bo },
            { "br", "\u0628\u0631\u06cc\u0679\u064e\u0646" },
            { "bs", "\u0628\u0648\u0633\u0646\u0650\u06cc\u064e\u0646" },
            { "ca", "\u06a9\u064e\u062a\u0644\u0627\u0646" },
            { "ce", "\u0686\u06cc\u0686\u064e\u0646" },
            { "ch", "\u06a9\u064e\u0645\u0648\u0631\u0648" },
            { "co", "\u06a9\u0627\u0631\u0633\u0650\u06a9\u064e\u0646" },
            { "cr", "\u06a9\u0631\u06cc" },
            { "cs", "\u0686\u06cc\u06a9" },
            { "cu", "\u0686\u0654\u0631\u0686 \u0633\u0644\u0627\u0648\u0650\u06a9" },
            { "cv", "\u0686\u064f\u0648\u0627\u0634" },
            { "cy", "\u0648\u06cc\u0644\u0634" },
            { "da", "\u0688\u06cc\u0646\u0650\u0634" },
            { "de", "\u062c\u0654\u0631\u0645\u064e\u0646" },
            { "dv", "\u062f\u0650\u0648\u06cc\u06c1\u06cc" },
            { "dz", "\u0632\u0648\u0646\u06af\u06a9\u06be\u0627" },
            { "ee", "\u0627\u06cc\u0656\u0648" },
            { "el", "\u06cc\u0648\u0657\u0646\u0672\u0646\u06cc" },
            { "en", "\u0627\u064e\u0646\u06af\u06cc\u0656\u0632\u06cd" },
            { "eo", "\u0627\u06cc\u0633\u067e\u064e\u0631\u06cc\u0646\u0679\u0648" },
            { "es", "\u06c1\u0633\u067e\u0627\u0646\u0648\u06cc" },
            { "et", "\u0627\u06cc\u0633\u0679\u0648\u0646\u06cc\u064e\u0646" },
            { "eu", "\u0628\u0627\u0633\u06a9" },
            { "fa", "\u0641\u0627\u0631\u0633\u06cc" },
            { "ff", "\u0641\u064f\u0644\u0627\u06c1" },
            { "fi", "\u0641\u0650\u0646\u0650\u0634" },
            { "fj", "\u0641\u0650\u062c\u06cc\u064e\u0646" },
            { "fo", "\u0641\u064e\u0631\u0648\u0633" },
            { "fr", "\u0641\u0631\u0627\u0646\u0633\u06cc\u0633\u06cc" },
            { "fy", "\u0645\u063a\u0631\u0628\u06cc \u0641\u0631\u0650\u0634\u06cc\u064e\u0646" },
            { "ga", "\u0627\u064e\u06cc\u0631\u0650\u0634" },
            { "gd", "\u0633\u06a9\u0648\u0679\u0650\u0634 \u06af\u06cc\u06d2\u0644\u0650\u06a9" },
            { "gl", "\u06af\u06cc\u0644\u0650\u0634\u0650\u06cc\u064e\u0646" },
            { "gn", "\u06af\u064f\u0648\u0627\u0631\u064e\u0646\u06cc" },
            { "gu", "\u06af\u064f\u062c\u0631\u0672\u062a\u06cc" },
            { "gv", "\u0645\u06cc\u0646\u06a9\u0633" },
            { "ha", "\u06c1\u0627\u0648\u0633\u0627" },
            { "he", "\u0639\u0628\u0631\u0672\u0646\u06cd" },
            { "hi", "\u06c1\u0650\u0646\u062f\u06cc" },
            { "ho", "\u06c1\u0650\u0631\u06cc \u0645\u0648\u062a\u0648\u0657" },
            { "hr", "\u06a9\u0631\u0648\u0634\u0650\u06cc\u064e\u0646" },
            { "ht", "\u06c1\u06cc\u062a\u0650\u06cc\u0627\u06ba" },
            { "hu", "\u06c1\u064e\u0646\u06af\u06cc\u0631\u06cc\u064e\u0646" },
            { "hy", "\u0627\u064e\u0631\u0645\u06cc\u0646\u06cc\u064e\u0646" },
            { "hz", "\u06c1\u06cc\u0631\u06cc\u0656\u0631\u0648" },
            { "ia", "\u0627\u0650\u0646\u0679\u064e\u0631\u0644\u0650\u0646\u06af\u0648\u0627" },
            { "id", "\u0627\u0650\u0646\u0688\u0648\u0646\u06cc\u0634\u06cc\u0627" },
            { "ie", "\u0627\u0650\u0646\u0679\u064e\u0631 \u0644\u0650\u0646\u0646\u06af\u0648\u06cc\u06d2" },
            { "ig", "\u0627\u0650\u06af\u0628\u0648" },
            { "ii", "\u0633\u0650\u0686\u0648\u0627\u0646 \u06cc\u0656\u06cc" },
            { "ik", "\u0627\u0650\u0646\u064f\u067e\u0650\u06cc\u0627\u06a9" },
            { "io", "\u0627\u0650\u0688\u0648" },
            { "is", "\u0622\u06cc\u0650\u0633\u0644\u06cc\u0646\u0688\u0650\u06a9" },
            { "it", "\u0627\u0650\u0637\u0627\u0644\u0648\u06cc" },
            { "iu", "\u0627\u0650\u0646\u064f\u06a9\u062a\u0650\u062a\u0648\u0657" },
            { "ja", "\u062c\u0627\u067e\u0672\u0646\u06cd" },
            { "jv", "\u062c\u064e\u0648\u064e\u0646\u06cc\u0656\u0632" },
            { "ka", metaValue_ka },
            { "kg", "\u06a9\u0648\u0646\u06af\u0648" },
            { "ki", "\u06a9\u0650\u06a9\u064f\u06cc\u0648\u0657" },
            { "kj", "\u06a9\u064f\u0648\u0627\u0646\u06cc\u0627\u0645\u0627" },
            { "kk", "\u06a9\u0627\u0632\u064e\u062e" },
            { "kl", "\u06a9\u064e\u0644\u0627\u0644\u0650\u0633\u064f\u062a" },
            { "km", "\u062e\u064e\u0645\u06cc\u0631" },
            { "kn", "\u06a9\u064e\u0646\u064e\u0691" },
            { "ko", metaValue_ko },
            { "kr", "\u06a9\u064e\u0646\u0648\u0657\u0631\u06cc" },
            { "ks", "\u06a9\u0672\u0634\u064f\u0631" },
            { "ku", "\u06a9\u064f\u0631\u062f\u0650\u0634" },
            { "kv", "\u06a9\u0648\u0645\u06cc" },
            { "kw", "\u06a9\u0648\u0631\u0646\u0650\u0634" },
            { "ky", "\u06a9\u0650\u0631\u06af\u0650\u0632" },
            { "la", "\u0644\u0627\u062a\u06cc\u0656\u0646\u06cc" },
            { "lb", "\u0644\u064f\u06a9\u06be\u0632\u06cc\u0645\u0628\u0648\u0631\u06af\u0650\u0634" },
            { "lg", "\u06af\u0627\u0646\u062f\u0627" },
            { "li", "\u0644\u0650\u0645\u0628\u0654\u0631\u06af\u0650\u0634" },
            { "ln", "\u0644\u0650\u0646\u06af\u0627\u0644\u0627" },
            { "lo", metaValue_lo },
            { "lt", "\u0644\u0650\u062a\u06be\u0648\u0627\u0646\u0650\u06cc\u064e\u0646" },
            { "lu", "\u0644\u0648\u064f\u0628\u0627 \u06a9\u064e\u062a\u064e\u0646\u06af\u0627" },
            { "lv", "\u0644\u064e\u062a\u0648\u0650\u06cc\u064e\u0646" },
            { "mg", "\u0645\u064e\u0644\u0627\u06af\u064e\u0633\u06cc" },
            { "mh", "\u0645\u0627\u0631\u0634\u064e\u0644\u06cc\u0656\u0632" },
            { "mi", "\u0645\u0627\u0648\u0631\u06cc" },
            { "mk", "\u0645\u06cc\u06a9\u064e\u0688\u0648\u0646\u06cc\u064e\u0646" },
            { "ml", "\u0645\u0654\u0644\u06cc\u0627\u0644\u064e\u0645" },
            { "mn", "\u0645\u064e\u0646\u06af\u0648\u0644\u06cc" },
            { "mr", "\u0645\u064e\u0631\u0672\u0679\u06be\u06cd" },
            { "ms", "\u0645\u064e\u0644\u064e\u06d2" },
            { "mt", "\u0645\u064e\u0644\u062a\u06cc\u0656\u0633" },
            { "my", "\u0628\u0654\u0645\u06cc\u0656\u0632" },
            { "na", "\u0646\u0627\u0648\u0631\u064f" },
            { "nb", "\u0646\u0627\u0631\u0648\u06cc\u06cc\u064e\u0646 \u0628\u0648\u06a9\u0645\u0627\u0644" },
            { "nd", "\u0634\u064f\u0645\u0627\u0644 \u0688\u064e\u0628\u06cc\u0644" },
            { "ne", "\u0646\u06cc\u067e\u0672\u0644\u06cd" },
            { "ng", "\u0688\u0648\u0646\u06af\u0627" },
            { "nl", "\u0688\u064e\u0686" },
            { "nn", "\u0646\u0627\u0631\u0648\u06cc\u06cc\u064e\u0646 \u0646\u064e\u06d2 \u0646\u0648\u0631\u0633\u06a9" },
            { "no", "\u0646\u0627\u0631\u0648\u06cc\u06cc\u064e\u0646" },
            { "nr", "\u062c\u0646\u0648\u0628 \u0688\u06cc\u0628\u06cc\u0644" },
            { "nv", "\u0646\u064e\u0648\u0627\u062c\u0648" },
            { "ny", "\u0646\u0650\u06cc\u064e\u0646\u062c\u0627" },
            { "oc", "\u0627\u0648\u06a9\u0633\u06cc\u0656\u0679\u064e\u0646" },
            { "oj", "\u0627\u0648\u062c\u0650\u0628\u0648\u0627" },
            { "om", "\u0627\u06c6\u0631\u0648\u0645\u0648" },
            { "or", "\u0627\u06c6\u0631\u0650\u06cc\u0627" },
            { "os", "\u0627\u06c6\u0633\u06cc\u0679\u0650\u06a9" },
            { "pa", "\u067e\u064e\u0646\u062c\u0672\u0628\u06cd" },
            { "pi", "\u067e\u0627\u0644\u06cc" },
            { "pl", "\u067e\u0627\u0644\u0650\u0634" },
            { "ps", "\u067e\u064e\u0634\u062a\u0648\u0657" },
            { "pt", "\u067e\u064f\u0631\u062a\u064e\u06af\u06cc\u0656\u0632" },
            { "qu", "\u06a9\u064f\u0648\u06cc\u0634\u064f\u0648\u0627" },
            { "rm", "\u0631\u0648\u0645\u0627\u0646\u0634" },
            { "rn", "\u0631\u064f\u0646\u062f\u06cc" },
            { "ro", "\u0631\u0648\u0645\u0672\u0646\u06cc" },
            { "ru", metaValue_ru },
            { "rw", "\u06a9\u0650\u0646\u06cc\u0627\u0648\u0650\u0646\u062f\u0627" },
            { "sa", "\u0633\u064e\u0646\u0633\u06a9\u0631\u0655\u062a" },
            { "sc", "\u0633\u0631\u0627\u0688\u06cc\u0656\u0646\u06cc" },
            { "sd", "\u0633\u0650\u0646\u062f\u06cc" },
            { "se", "\u0634\u064f\u0645\u0672\u0644\u06cc \u0633\u064e\u0645\u06cc" },
            { "sg", "\u0633\u064e\u0646\u06af\u0648" },
            { "sh", "\u0633\u06cc\u0631\u0628\u0648 \u06a9\u0631\u0648\u0634\u0650\u06cc\u064e\u0646" },
            { "si", metaValue_si },
            { "sk", "\u0633\u0644\u0648\u0648\u064e\u06a9" },
            { "sl", "\u0633\u0644\u0648\u0648\u06cc\u0646\u06cc\u064e\u0646" },
            { "sm", "\u0633\u064e\u0645\u0648\u0627\u064e\u0646" },
            { "sn", "\u0634\u0648\u0646\u0627" },
            { "so", "\u0633\u0648\u0645\u0672\u0644\u06cc" },
            { "sq", "\u0627\u0644\u0628\u0627\u0646\u0650\u06cc\u064e\u0646" },
            { "sr", "\u0633\u0654\u0631\u0628\u0650\u06cc\u064e\u0646" },
            { "ss", "\u0633\u0648\u0627\u062a\u06cc" },
            { "st", "\u062c\u0646\u0648\u0628\u06cc \u0633\u062a\u06be\u0648" },
            { "su", metaValue_su },
            { "sv", "\u0633\u0648\u06cc\u0656\u0688\u0650\u0634" },
            { "sw", "\u0633\u0648\u0627\u06c1\u0650\u0644\u06cc" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "\u062a\u0627\u062c\u0650\u06a9" },
            { "th", metaValue_th },
            { "ti", "\u0679\u0650\u06af\u0631\u0650\u0646\u06cc\u0627" },
            { "tk", "\u062a\u064f\u0631\u06a9\u0645\u06cc\u0646" },
            { "tl", "\u062a\u064e\u0645\u0627\u0634\u06cc\u06a9" },
            { "tn", "\u0633\u0648\u0627\u0646\u0627" },
            { "to", metaValue_TO },
            { "tr", "\u062a\u064f\u0631\u06a9\u0650\u0634" },
            { "ts", "\u0698\u0648\u0646\u06af\u0627" },
            { "tt", "\u062a\u064e\u062a\u0627\u0631" },
            { "tw", "\u062a\u0648\u06cc" },
            { "ty", "\u062a\u0627\u06c1\u06cc\u0634\u0650\u06cc\u064e\u0646" },
            { "uk", "\u06cc\u0648\u0657\u06a9\u0631\u06cc\u0646\u06cc\u0672\u06cc\u06cc" },
            { "ur", "\u0627\u064f\u0631\u062f\u0648\u0657" },
            { "uz", "\u0627\u064f\u0632\u0628\u06cc\u06a9" },
            { "ve", "\u0648\u06cc\u0646\u062f\u0627" },
            { "vi", "\u0648\u0650\u06cc\u064e\u062a\u0646\u064e\u0645\u06cc\u0656\u0632" },
            { "vo", "\u0648\u0648\u0644\u064e\u067e\u064f\u06a9" },
            { "wa", "\u0648\u064e\u0644\u0648\u0657\u0646" },
            { "wo", "\u0648\u0648\u0644\u0648\u0641" },
            { "xh", "\u06a9\u06be\u0648\u0633\u0627" },
            { "yi", "\u06cc\u0650\u062f\u0650\u0634" },
            { "yo", "\u06cc\u0648\u0631\u064f\u0628\u0627" },
            { "za", "\u0632\u064f\u06c1\u0627\u0646\u06af" },
            { "zh", "\u0686\u06cc\u0656\u0646\u06cc \ufd3f\u062a\u0631\u062c\u0645\u0639 \u0627\u0650\u0634\u0627\u0631\u0655: \u062e\u0627\u0635 \u0637\u0648\u0631\u060c \u0645\u06cc\u0646\u0688\u0627\u0631\u0646 \u0686\u06cc\u0656\u0646\u06cc\u06d4\ufd3e" },
            { "zu", "\u0632\u064f\u0644\u0648\u0657" },
            { "ace", "\u0627\u064e\u0686\u064e\u06d2\u0646\u06cc\u0656\u0632" },
            { "ach", "\u0627\u064e\u06a9\u0648\u0644\u06cc" },
            { "ada", "\u0627\u064e\u062f\u064e\u0646\u06af\u0645\u06cc\u06d2" },
            { "ady", "\u0627\u064e\u062f\u064e\u06cc\u0656\u06af\u06cc\u06d2" },
            { "afh", "\u0627\u064e\u0641\u0631\u0650\u06c1\u0650\u0644\u06cc" },
            { "ain", "\u0627\u06cc\u0646\u0648\u0657" },
            { "akk", "\u0627\u064e\u06a9\u0627\u062f\u0650\u06cc\u064e\u0646" },
            { "ale", "\u0627\u064e\u0644\u0648\u06cc\u062a\u06cc" },
            { "alt", "\u062c\u0646\u0648\u0657\u0628\u06cc \u0627\u064e\u0644\u062a\u0627\u06cc\u06cc" },
            { "ang", "\u067e\u0631\u0648\u0646 \u0627\u064e\u0646\u06af\u0631\u06cc\u0656\u0632\u06cc" },
            { "anp", "\u0627\u064e\u0646\u06af\u0650\u06a9\u0627" },
            { "arc", "\u0627\u064e\u0631\u064e\u0645\u06cc\u06a9" },
            { "arn", "\u0627\u06cc\u0631\u0648 \u06a9\u0648\u0646\u0650\u06cc\u064e\u0646" },
            { "arp", "\u0627\u064e\u0631\u0627\u067e\u0627\u06c1\u0648" },
            { "arw", "\u0627\u064e\u0631\u0627\u0648\u064e\u06a9" },
            { "ast", "\u0627\u06cc\u0633\u0679\u0648\u0657\u0631\u06cc\u064e\u0646" },
            { "awa", "\u0627\u064e\u0648\u064e\u062f\u06cc" },
            { "bal", "\u0628\u064e\u0644\u0648\u0657\u0686\u06cc" },
            { "ban", "\u0628\u0627\u0644\u0650\u0646\u06cc\u0656\u0632" },
            { "bas", "\u0628\u0627\u0633\u0627" },
            { "bej", "\u0628\u06cc\u062c\u0627" },
            { "bem", "\u0628\u06cc\u0645\u0628\u0627" },
            { "bho", "\u0628\u0648\u062c\u067e\u0648\u0657\u0631\u06cc" },
            { "bik", "\u0628\u0650\u06a9\u0648\u0644" },
            { "bin", "\u0628\u0650\u0646\u06cc" },
            { "bla", "\u0633\u0650\u06a9\u0633\u0650\u06a9\u0627" },
            { "bra", "\u0628\u0631\u062c" },
            { "bua", "\u0628\u064f\u0631\u0650\u06cc\u064e\u062a" },
            { "bug", "\u0628\u064e\u06af\u0646\u06cc\u0656\u0632" },
            { "byn", "\u0628\u0655\u0644\u0650\u0646" },
            { "cad", "\u06a9\u0627\u0688\u0648" },
            { "car", "\u06a9\u0627\u0631\u0650\u0628" },
            { "cch", "\u0627\u062a\u0633\u064e\u0645" },
            { "ceb", "\u0633\u06cc\u0628\u0627\u0648\u0646\u0648" },
            { "chb", "\u0686\u06cc\u0656\u0628\u0686\u0627" },
            { "chg", "\u0686\u06be\u064e\u06af\u062a\u0627\u06d2" },
            { "chk", "\u0686\u064f\u06a9\u06cc\u0656\u0632" },
            { "chm", "\u0645\u0627\u0631\u06cc" },
            { "chn", "\u0686\u0650\u0646\u0648\u0657\u06a9 \u062c\u0627\u0631\u06af\u064e\u0646" },
            { "cho", "\u0686\u0648\u06a9\u062a\u064e\u0648" },
            { "chp", "\u0634\u06cc\u067e\u0648\u06cc\u0627\u0646" },
            { "chr", metaValue_chr },
            { "chy", "\u0634\u06cc\u06cc\u0648\u0646" },
            { "cop", metaValue_cop },
            { "crh", "\u06a9\u0631\u0655\u0645\u06cc\u0656\u0646 \u062a\u064f\u0631\u06a9\u06cc" },
            { "csb", "\u06a9\u064e\u0634\u0648\u0657\u0628\u0650\u06cc\u064e\u0646" },
            { "dak", "\u0688\u06a9\u0648\u0679\u0627" },
            { "dar", "\u062f\u064e\u0631\u06af\u0648\u0627" },
            { "del", "\u0688\u06cc\u0644\u0648\u06cc\u06cc\u064e\u0631" },
            { "den", "\u0633\u0644\u06cc\u0648" },
            { "dgr", "\u0688\u0627\u06af\u0631\u0650\u0628" },
            { "din", "\u0688\u0650\u0646\u06a9\u0627" },
            { "doi", "\u0688\u0648\u06af\u0631\u06cc" },
            { "dsb", "\u0628\u06c6\u0646\u0650\u0645 \u0633\u0627\u0631\u0628\u0650\u06cc\u064e\u0646" },
            { "dua", "\u062f\u064f\u0648\u0627\u0644\u0627" },
            { "dum", "\u0648\u064e\u0633\u062a\u06cc \u067e\u064f\u0631\u062a\u064f\u06af\u0627\u0644\u06cc" },
            { "dyu", "\u0688\u0650\u06cc\u0648\u0657\u0644\u0627" },
            { "efi", "\u0627\u06cc\u0641\u0650\u06a9" },
            { "egy", "\u0642\u062f\u06cc\u0656\u0645\u06cc \u0645\u0650\u0635\u0631\u06cc" },
            { "eka", "\u0627\u06cc\u06a9\u0627\u062c\u064f\u06a9" },
            { "elx", "\u0627\u06cc\u0644\u0627\u0645\u0627\u06cc\u0650\u0679" },
            { "enm", "\u0648\u064e\u0633\u0637\u06cc \u0627\u064e\u0646\u06af\u0631\u06cc\u0656\u0632\u06cd" },
            { "ewo", "\u0627\u06cc\u0648\u0648\u0646\u0688\u0648" },
            { "fan", "\u0641\u06cc\u0646\u06af" },
            { "fat", "\u0641\u0627\u0646\u0679\u06cc" },
            { "fil", "\u0641\u0650\u0644\u0650\u067e\u06cc\u0656\u0646\u0648" },
            { "fon", "\u0641\u0648\u0646" },
            { "frm", "\u0648\u0633\u0637\u06cc \u0641\u0631\u06cc\u0646\u0686" },
            { "fro", "\u067e\u0631\u0648\u0646 \u0641\u0631\u06cc\u0646\u0686" },
            { "frr", "\u0634\u064f\u0645\u0672\u0644\u06cc \u0641\u0631\u0650\u0634\u06cc\u064e\u0646" },
            { "frs", "\u0645\u0634\u0631\u0650\u0642\u06cc \u0641\u0631\u0650\u0634\u06cc\u064e\u0646" },
            { "fur", "\u0641\u0631\u0648\u0657\u0644\u0650\u06cc\u064e\u0646" },
            { "gaa", "\u06af\u0627" },
            { "gay", "\u06af\u06cc\u06d2\u06cc\u0648" },
            { "gba", "\u06af\u0628\u0627\u06cc\u0627" },
            { "gez", "\u06af\u06cc\u0656\u0632" },
            { "gil", "\u06af\u0650\u0644\u0628\u0654\u0631\u0679\u06cc\u0656\u0632" },
            { "gmh", "\u0648\u064e\u0633\u0637\u06cc \u06c1\u0627\u06d2 \u062c\u0654\u0631\u0645\u064e\u0646" },
            { "goh", "\u067e\u0631\u0648\u0646 \u06c1\u0627\u06d2 \u062c\u0654\u0631\u0645\u064e\u0646" },
            { "gon", "\u06af\u0648\u0646\u062f\u06cc" },
            { "gor", "\u06af\u0648\u0631\u06cc\u0646\u0679\u06cc\u0644\u0648" },
            { "got", metaValue_got },
            { "grb", "\u06af\u0631\u0650\u0628\u0648" },
            { "grc", "\u0642\u062f\u06cc\u0656\u0645 \u06cc\u0648\u0657\u0646\u0672\u0646\u06cc" },
            { "gsw", "\u0633\u0655\u0648\u0650\u0633 \u062c\u0654\u0631\u0645\u064e\u0646" },
            { "gwi", "\u06af\u064f\u0648\u0650\u0686 \u0627\u0650\u0646" },
            { "hai", "\u06c1\u064e\u06cc\u062f\u0627" },
            { "haw", "\u06c1\u0648\u0627\u06cc\u0650\u06cc\u064e\u0646" },
            { "hil", "\u06c1\u0650\u0644\u06cc\u0656\u06af\u06cc\u0646\u064e\u0646" },
            { "hit", "\u06c1\u0650\u062a\u0627\u06cc\u0650\u062a" },
            { "hmn", "\u06c1\u0645\u0648\u0646\u06af" },
            { "hsb", "\u06c1\u06cc\u0631\u0650\u0645 \u0633\u0627\u0631\u0628\u0650\u06cc\u064e\u0646" },
            { "hup", "\u06c1\u064f\u067e\u0627" },
            { "iba", "\u0627\u0650\u0628\u0627\u0646" },
            { "ilo", "\u0627\u0650\u0644\u0648\u06a9\u0648" },
            { "inh", "\u0627\u0650\u0646\u06af\u064f\u0634" },
            { "jbo", "\u0644\u0648\u062c\u0628\u0627\u0646" },
            { "jpr", "\u062c\u0648\u0688\u06cc\u0648 \u0641\u0627\u0631\u0633\u06cc" },
            { "jrb", "\u062c\u0648\u0688\u06cc\u0648 \u0639\u0631\u0628\u06cc" },
            { "kaa", "\u06a9\u0627\u0631\u0627 \u06a9\u064e\u0644\u067e\u064e\u06a9" },
            { "kab", "\u06a9\u064e\u0628\u0627\u06cc\u0650\u0644" },
            { "kac", "\u06a9\u0627\u0686\u0650\u0646" },
            { "kaj", "\u062c\u064f\u0648\u0657" },
            { "kam", "\u06a9\u0627\u0645\u0628\u0627" },
            { "kaw", "\u06a9\u064e\u0648\u06cc" },
            { "kbd", "\u06a9\u064e\u0628\u0627\u0631\u0688\u0650\u06cc\u064e\u0646" },
            { "kcg", "\u062a\u064e\u06cc\u064e\u067e" },
            { "kfo", "\u06a9\u0648\u0631\u0648" },
            { "kha", "\u06a9\u06be\u0627\u0633\u06cc" },
            { "kho", "\u06a9\u06be\u0648\u062a\u064e\u0646\u06cc\u0656\u0632" },
            { "kmb", "\u06a9\u0650\u0645\u0628\u064f\u0646\u062f\u0648\u0657" },
            { "kok", "\u06a9\u0648\u0646\u06a9\u064e\u0646\u06cc" },
            { "kos", "\u06a9\u0648\u0633\u0631\u06cc\u06cc\u064e\u0646" },
            { "kpe", "\u06a9\u064e\u067e\u06cc\u0644\u06cc" },
            { "krc", "\u06a9\u0631\u0627\u0686\u06cc\u06d2 \u0628\u064e\u0644\u06a9\u0627\u0631" },
            { "krl", "\u06a9\u064e\u0631\u06cc\u0644\u0650\u06cc\u064e\u0646" },
            { "kru", "\u06a9\u064f\u0631\u064f\u06a9\u06be" },
            { "kum", "\u06a9\u064f\u0645\u0650\u06a9" },
            { "kut", "\u06a9\u064f\u062a\u06cc\u0646\u064e\u06d2" },
            { "lad", "\u0644\u06cc\u0688\u0650\u0646\u0648" },
            { "lah", "\u0644\u064e\u06c1\u064e\u0646\u062f\u0627" },
            { "lam", "\u0644\u064e\u0645\u0628\u0627" },
            { "lez", "\u0644\u06cc\u0632\u06af\u0650\u06cc\u064e\u0646" },
            { "lol", "\u0645\u0648\u0646\u06af\u0648" },
            { "loz", "\u0644\u0648\u0632\u06cc" },
            { "lua", "\u0644\u0648\u0657\u0628\u0627 \u0644\u0648\u0657\u0644\u064f\u0648\u0627" },
            { "lui", "\u0644\u0648\u06cc\u0650\u0633\u06cc\u0646\u0648" },
            { "lun", "\u0644\u064f\u0646\u062f\u0627" },
            { "luo", "\u0644\u064f\u0648\u0648" },
            { "lus", "\u0644\u064f\u0633\u06c1\u0627\u06d2" },
            { "mad", "\u0645\u064e\u062f\u064f\u0631\u06cc\u0656\u0632" },
            { "mag", "\u0645\u064e\u06af\u0627\u06d2" },
            { "mai", "\u0645\u06cc\u062a\u064e\u06be\u0644\u06cc" },
            { "mak", "\u0645\u064e\u06a9\u064e\u0633\u0627\u0631" },
            { "man", "\u0645\u064e\u0646\u062f\u0650\u0646\u06af\u0648" },
            { "mas", "\u0645\u064e\u0633\u0627\u06d2" },
            { "mdf", "\u0645\u0648\u06a9\u0634\u0627" },
            { "mdr", "\u0645\u064e\u0646\u062f\u064e\u0631" },
            { "men", "\u0645\u06cc\u0646\u062f\u06cc\u06d2" },
            { "mga", "\u0648\u064e\u0633\u062a\u06cc \u0627\u06cc\u0631\u0650\u0634" },
            { "mic", "\u0645\u0650\u06a9\u0645\u06cc\u06a9" },
            { "min", "\u0645\u0650\u0646\u064e\u0646\u06af\u06a9\u064e\u0628\u0627\u0648" },
            { "mnc", "\u0645\u0627\u0646\u0686\u0648\u0657" },
            { "mni", "\u0645\u064e\u0646\u06cc\u067e\u0648\u0657\u0631\u06cc" },
            { "moh", "\u0645\u0648\u06c1\u0627\u06a9" },
            { "mos", "\u0645\u0648\u0633\u06cc" },
            { "mul", "\u0648\u0627\u0631\u06cc\u0627\u06c1 \u0632\u0628\u0627\u0646" },
            { "mus", "\u06a9\u0631\u06cc\u0656\u06a9" },
            { "mwl", "\u0645\u0650\u0631\u0627\u0646\u062f\u06cc\u0656\u0632" },
            { "mwr", "\u0645\u0627\u0631\u0648\u0627\u0691\u06cc" },
            { "myv", "\u0627\u06cc\u0631\u0632\u0650\u06cc\u0627" },
            { "nap", "\u0646\u06cc\u0656\u067e\u0627\u0644\u06cc\u0679\u064e\u0646" },
            { "nds", "\u0628\u06c6\u0646\u0650\u0645 \u062c\u0654\u0631\u0645\u064e\u0646" },
            { "new", "\u0646\u06cc\u0648\u0627\u0631\u06cc" },
            { "nia", "\u0646\u0650\u06cc\u0627\u0633" },
            { "niu", "\u0646\u0650\u06cc\u0648\u06cc\u064e\u0646" },
            { "nog", "\u0646\u0648\u06af\u0627\u06d2" },
            { "non", "\u067e\u0631\u0648\u0646 \u0646\u0627\u0631\u0633\u06cc" },
            { "nqo", metaValue_nqo },
            { "nso", "\u0634\u0645\u0627\u0644\u06cc \u0633\u062a\u06be\u0648" },
            { "nwc", "\u06a9\u0644\u0627\u0633\u0650\u06a9\u064e\u0644 \u0646\u06cc\u0648\u0627\u0631\u06cc" },
            { "nym", "\u0646\u0650\u06cc\u064e\u0645\u0648\u06cc\u0632\u06cc" },
            { "nyn", "\u0646\u0650\u06cc\u064e\u0646\u06a9\u0648\u0644" },
            { "nyo", "\u0646\u0650\u06cc\u0648\u0631\u0648" },
            { "nzi", "\u0646\u064e\u0638\u06cc\u0656\u0645\u0627" },
            { "osa", "\u0627\u06c6\u0633\u06cc\u062c" },
            { "ota", "\u0627\u0648\u0679\u0648\u0645\u064e\u0646 \u062a\u064f\u0631\u06a9\u0650\u0634" },
            { "pag", "\u067e\u064e\u0646\u06af\u0627\u0633\u0650\u0646\u064e\u0646" },
            { "pal", "\u067e\u064e\u06c1\u0644\u064e\u0648\u06cc" },
            { "pam", "\u067e\u064e\u0645\u067e\u064e\u0646\u06af\u0627" },
            { "pap", "\u067e\u064e\u067e\u0650\u06cc\u0627\u0645\u06cc\u0646\u0679\u0648" },
            { "pau", "\u067e\u064e\u0644\u0627\u0627\u064f\u0648\u0627\u06ba" },
            { "peo", metaValue_peo },
            { "phn", "\u0641\u0648\u0646\u06cc\u0656\u0634\u06cc\u064e\u0646" },
            { "pon", "\u067e\u0627\u0646\u067e\u06cc\u06cc\u064e\u0646" },
            { "pro", "\u067e\u0631\u0648\u0646 \u067e\u0631\u0648\u0648\u06cc\u0646\u0686\u064e\u0644" },
            { "raj", "\u0631\u0627\u062c\u0650\u0633\u062a\u06be\u0672\u0646\u06cd" },
            { "rap", "\u0631\u064e\u067e\u0627\u0646\u0648\u06cc" },
            { "rar", "\u0631\u064e\u0631\u0648\u0679\u0648\u0646\u06af\u064e\u0646" },
            { "rom", "\u0631\u0648\u0645\u064e\u0646\u06cc" },
            { "rup", "\u0627\u064e\u0631\u0648\u0645\u0627\u0646\u06cc" },
            { "sad", "\u0633\u064e\u0646\u062f\u064e\u0648\u06cc\u06d2" },
            { "sah", "\u06cc\u0627\u06a9\u064f\u062a" },
            { "sam", "\u0633\u064e\u0645\u0627\u0631\u0650\u062a\u064e\u0646 \u0627\u064e\u0631\u0627\u0645\u06cc\u06a9" },
            { "sas", "\u0633\u064e\u0633\u064e\u06a9" },
            { "sat", "\u0633\u064e\u0646\u062a\u0627\u0644\u06cc" },
            { "scn", "\u0633\u0650\u0686\u0650\u0644\u0650\u06cc\u064e\u0646" },
            { "sco", "\u0633\u06a9\u0627\u0679\u0633" },
            { "sel", "\u0633\u06cc\u0644\u06a9\u064f\u067e" },
            { "sga", "\u067e\u0631\u0648\u0646 \u0627\u06cc\u0631\u0650\u0634" },
            { "shn", "\u0634\u0627\u0646" },
            { "sid", "\u0633\u0650\u062f\u0627\u0645\u0648" },
            { "sma", "\u062c\u0646\u0648\u0657\u0628\u06cc \u0633\u064e\u0645\u06cc" },
            { "smj", "\u0644\u0648\u0644\u06cc\u06d2 \u0633\u064e\u0645\u06cc" },
            { "smn", "\u0627\u0650\u0646\u0627\u0631\u06cc \u0633\u064e\u0645\u06cc" },
            { "sms", "\u0633\u06a9\u0648\u0644\u0679 \u0633\u064e\u0645\u06cc" },
            { "snk", "\u0633\u0648\u0646\u0650\u0646\u06a9\u06cc\u06d2" },
            { "sog", "\u0633\u0648\u06af\u0688\u0650\u06cc\u064e\u0646" },
            { "srn", "\u0633\u0631\u0627\u0646\u064e\u0646 \u0679\u0648\u0646\u06af\u0648" },
            { "srr", "\u0633\u06cc\u0631\u06cc\u0631" },
            { "suk", "\u0633\u064f\u06a9\u064f\u0645\u0627" },
            { "sus", "\u0633\u064f\u0633\u0648\u0657" },
            { "sux", "\u0633\u064f\u0645\u06cc\u0631\u06cc\u064e\u0646" },
            { "syr", "\u0633\u06cc\u0656\u0631\u06cc\u0672\u06cc\u06cc" },
            { "tem", "\u0679\u0650\u0645\u0646\u06cc\u06d2" },
            { "ter", "\u0679\u06cc\u0631\u06cc\u0646\u0648" },
            { "tet", "\u0679\u06cc\u0679\u064e\u0645" },
            { "tig", "\u0679\u0627\u06d2\u06af\u0631\u06cc\u06d2" },
            { "tiv", "\u062a\u06cc\u0656\u0648" },
            { "tkl", "\u0679\u0648\u06a9\u06cc\u0656\u0644\u0627\u0648" },
            { "tlh", "\u06a9\u0650\u0644\u0650\u0646\u06af\u0648\u0646" },
            { "tli", "\u0679\u0650\u0644\u0650\u0646\u06af\u0650\u062a" },
            { "tmh", "\u062a\u0627\u0645\u0627\u0634\u06cc\u06a9" },
            { "tog", "\u0646\u06cc\u0627\u0633\u0627 \u0679\u0648\u0646\u06af\u0627" },
            { "tpi", "\u0679\u0627\u06a9 \u067e\u0650\u0633\u0650\u0646" },
            { "tsi", "\u0698\u06be\u0650\u0645\u0634\u0650\u06cc\u0627\u0646" },
            { "tum", "\u062a\u064f\u0645\u0628\u064f\u06a9\u0627" },
            { "tvl", "\u062a\u064f\u0648\u0627\u0644\u0648\u0657" },
            { "tyv", "\u062a\u064f\u0648\u06cc\u0656\u0646\u06cc\u064e\u0646" },
            { "udm", "\u0627\u064f\u062f\u0645\u064f\u0631\u062a" },
            { "uga", "\u0627\u064f\u06af\u0627\u0631\u062a\u0650\u06a9" },
            { "umb", "\u06cc\u064f\u0645\u0628\u064f\u0646\u062f\u0648\u0657" },
            { "und", "\u0627\u064e\u0646\u0632\u0672\u0646\u06cd \u06cc\u0627 \u0646\u064e\u06c1 \u0644\u064e\u06af\u06c1\u0655\u06c1\u0627\u0631 \u0632\u0628\u0627\u0646" },
            { "vai", metaValue_vai },
            { "vot", "\u0648\u0648\u062a\u0650\u06a9" },
            { "wal", "\u0648\u0627\u0644\u0627\u0645\u0648" },
            { "war", "\u0648\u064e\u0631\u06cc\u06d2" },
            { "was", "\u0648\u0627\u0634\u0648" },
            { "xal", "\u06a9\u0627\u0644\u0645\u0650\u06a9" },
            { "yao", "\u06cc\u0627\u0648" },
            { "yap", "\u06cc\u064e\u067e\u06cc\u0656\u0632" },
            { "zap", "\u0632\u064e\u067e\u0648\u062a\u06cc\u06a9" },
            { "zen", "\u0632\u06cc\u0646\u0627\u06af\u0627" },
            { "zun", "\u0632\u0648\u0657\u0646\u06cc" },
            { "zxx", "\u06a9\u0627\u0646\u06c1\u06c1 \u062a\u06c1\u0650 \u0644\u0650\u0633\u0627\u0646\u06cc\u0627\u062a\u06cc \u0645\u0648\u0627\u062f \u0646\u06c1\u0655" },
            { "zza", "\u0632\u0627\u0632\u0627" },
            { "Arab", metaValue_ar },
            { "Aran", "\u0646\u0633\u062a\u0639\u0644\u06cc\u0642" },
            { "Armn", "\u0627\u064e\u0631\u0645\u0627\u0646\u06cc\u064e\u0646" },
            { "Avst", metaValue_ae },
            { "Bali", "\u0628\u0627\u0644\u064e\u0646\u06cc\u0656\u0632" },
            { "Batk", "\u0628\u0627\u062a\u064e\u06a9" },
            { "Beng", "\u0628\u06cc\u0646\u06af\u0672\u0644\u06cd" },
            { "Blis", "\u0628\u0650\u0644\u0650\u0633 \u0633\u0650\u0645\u0628\u0644\u0632" },
            { "Bopo", "\u0628\u0648\u067e\u0648\u0645\u0648\u0641\u0648" },
            { "Brah", "\u0628\u0631\u0627\u06c1\u0645\u06cc" },
            { "Brai", "\u0628\u0631\u06cc\u0644" },
            { "Bugi", "\u0628\u064f\u06af\u0650\u0646\u06cc\u0656\u0632" },
            { "Buhd", "\u0628\u064f\u06c1\u0650\u062f" },
            { "Cans", "\u06cc\u064f\u0646\u0650\u0641\u0627\u06cc\u0650\u0691 \u06a9\u0646\u06cc\u0691\u0650\u06cc\u064e\u0646 \u0627\u06cc\u0628 \u0622\u0631\u062c\u0650\u0646\u064e\u0644 \u0633\u0650\u0644\u06cc\u0628\u0650\u06a9" },
            { "Cari", "\u06a9\u0627\u0631\u06cc\u064e\u0646" },
            { "Cham", "\u0686\u064e\u0645" },
            { "Cher", metaValue_chr },
            { "Cirt", "\u06a9\u0650\u0631\u062a\u06be" },
            { "Copt", metaValue_cop },
            { "Cprt", "\u06a9\u0650\u067e\u0631\u0627\u06cc\u0650\u0679" },
            { "Cyrl", "\u0633\u064e\u06cc\u0631\u0650\u0644\u0650\u06a9" },
            { "Cyrs", "\u067e\u0631\u0648\u0646 \u0686\u0654\u0631\u0686\u0633\u0644\u06cc\u0648\u0648\u0646\u0650\u06a9 \u0633\u064e\u06cc\u0631\u0650\u0644\u0650\u06a9" },
            { "Deva", "\u062f\u06cc\u0648\u0646\u0627\u06af\u0631\u06cc" },
            { "Dsrt", "\u0688\u06cc\u0633\u0654\u0631\u06cc\u0679" },
            { "Egyd", "\u0627\u0650\u062c\u067e\u0634\u0650\u06cc\u064e\u0646 \u0688\u0650\u0645\u0627\u0679\u0650\u06a9" },
            { "Egyh", "\u0627\u0650\u062c\u0650\u067e\u0634\u064e\u0646 \u06c1\u064e\u06cc\u0631\u06cc\u0679\u0650\u06a9" },
            { "Egyp", "\u0627\u0650\u062c\u0650\u067e\u0634\u064e\u0646 \u06c1\u064e\u06cc\u0631\u0648\u06af\u0644\u0650\u067e\u06be\u0633" },
            { "Ethi", "\u0627\u0650\u062a\u06be\u06cc\u0648\u067e\u0650\u06a9" },
            { "Geok", "\u062c\u0627\u0631\u062c\u0650\u06cc\u064e\u0646 \u06a9\u06be\u062a\u0633\u0648\u0631\u06cc" },
            { "Geor", metaValue_ka },
            { "Glag", "\u06af\u0644\u06cc\u06af\u0648\u0644\u0650\u0679\u0650\u06a9" },
            { "Goth", metaValue_got },
            { "Grek", "\u06af\u0631\u064e\u0646\u062a\u06be\u0627" },
            { "Gujr", "\u06af\u0631\u06cc\u0656\u06a9" },
            { "Guru", "\u06af\u064f\u062c\u0631\u0672\u062a\u06cd" },
            { "Hang", "\u06c1\u0627\u0646\u06af\u064f\u0644" },
            { "Hani", "\u06c1\u0627\u0646" },
            { "Hano", "\u06c1\u0627\u0646\u064f\u0646\u0648\u0657" },
            { "Hans", "\u0633\u064e\u06c1\u0644 \ufd3f\u062a\u0631\u062c\u0645\u0639 \u0627\u0650\u0634\u0627\u0631\u0655: \u06cc\u0650\u0645 \u0648\u0631\u0698\u0646 \u0631\u064e\u0633\u0645 \u0627\u0644\u062e\u0637 \u06c1\u064f\u06a9 \u0646\u0627\u0624 \u0686\u06be\u064f \u0686\u06cc\u0656\u0646\u06cc \u0628\u0627\u067e\u062a\u06be \u0632\u064e\u0628\u0627\u0646\u0655 \u0646\u0627\u0624 \u06a9\u0650\u0633 \u0645\u062c\u0645\u0648\u0639\u064e\u0633 \u0633\u0655\u062a\u06cd \u0627\u0650\u0633\u062a\u0639\u0645\u0627\u0644 \u06cc\u0650\u0648\u0627\u0646 \u06a9\u0631\u0646\u0655\u06c1\u06d4\ufd3e" },
            { "Hant", "\u0631\u0650\u0648\u0672\u062c\u06cc \ufd3f\u062a\u0631\u062c\u0645\u0639 \u0627\u0650\u0634\u0627\u0631\u0655: \u06cc\u0650\u0645 \u0648\u0631\u0698\u0646 \u0631\u064e\u0633\u0645 \u0627\u0644\u062e\u0637 \u06c1\u064f\u06a9 \u0646\u0627\u0624 \u0686\u06be\u064f \u0686\u06cc\u0656\u0646\u06cc \u0628\u0627\u067e\u062a\u06be \u0632\u064e\u0628\u0627\u0646\u0655 \u0646\u0627\u0624 \u06a9\u0650\u0633 \u0645\u062c\u0645\u0648\u0639\u064e\u0633 \u0633\u0655\u062a\u06cd \u0627\u0650\u0633\u062a\u0639\u0645\u0627\u0644 \u06cc\u0650\u0648\u0627\u0646 \u06a9\u0631\u0646\u0655\u06c1\u06d4\ufd3e" },
            { "Hebr", "\u06c1\u0650\u0628\u0631\u0650\u0648" },
            { "Hira", "\u06c1\u06cc\u0656\u0631\u0627\u06af\u0627\u0646\u0627" },
            { "Hmng", "\u067e\u064e\u06c1\u0627\u0648 \u0645\u0627\u0646\u06af" },
            { "Hrkt", "\u06a9\u064e\u0679\u0627\u06a9\u0627\u0646\u0627 \u06cc\u0627 \u06c1\u0650\u0631\u0627\u06af\u0627\u0646\u0627" },
            { "Hung", "\u067e\u0631\u0648\u0646 \u06c1\u064e\u0646\u06af\u06cc\u0631\u06cc\u064e\u0646" },
            { "Inds", "\u0627\u0650\u0646\u0688\u064e\u0633" },
            { "Ital", "\u0627\u0648\u0644\u0688 \u0627\u0650\u0679\u06cc\u0644\u0650\u06a9" },
            { "Java", "\u062c\u0627\u0648\u064e\u0646\u06cc\u0656\u0632" },
            { "Jpan", "\u062c\u0627\u067e\u0672\u0646\u06cc" },
            { "Kali", "\u06a9\u0627\u06cc\u0627 \u0644\u06cc" },
            { "Kana", "\u06a9\u064e\u062a\u0627\u06a9\u0627\u0646\u0627" },
            { "Khar", "\u062e\u064e\u0631\u0648\u0634\u062a\u06be\u06cc" },
            { "Khmr", "\u06a9\u06be\u0655\u0645\u06cc\u0631" },
            { "Knda", "\u06a9\u064e\u0646\u064e\u0691\u0627" },
            { "Kore", metaValue_ko },
            { "Lana", "\u0644\u0627\u0646\u0627" },
            { "Laoo", metaValue_lo },
            { "Latf", "\u0641\u0631\u06a9\u062a\u064f\u0631 \u0644\u06cc\u0679\u0650\u0646" },
            { "Latg", "\u06af\u06cc\u0644\u0650\u06a9 \u0644\u06cc\u0679\u064e\u0646" },
            { "Latn", "\u0644\u0627\u0637\u06cc\u0656\u0646\u06cc" },
            { "Lepc", "\u0644\u06cc\u067e\u06a9\u0627" },
            { "Limb", "\u0644\u0650\u0645\u0628\u0648\u0657" },
            { "Lina", "\u0644\u06cc\u0656\u0646\u06cc\u064e\u0631 \u0627\u06d2" },
            { "Linb", "\u0644\u06cc\u0656\u0646\u06cc\u064e\u0631 \u0628\u06cc" },
            { "Lyci", "\u0644\u06cc\u0633\u0650\u06cc\u064e\u0646" },
            { "Lydi", "\u0644\u06cc\u062f\u0650\u06cc\u064e\u0646" },
            { "Mand", "\u0645\u064e\u0646\u062f\u06cc\u06cc\u064e\u0646" },
            { "Mani", "\u0645\u0627\u0646\u06cc\u0634\u06cc\u06cc\u064e\u0646" },
            { "Maya", "\u0645\u0627\u06cc\u064e\u0646 \u06c1\u06cc\u0656\u0631\u0648\u06af\u0644\u0650\u067e\u06be" },
            { "Mero", "\u0645\u0650\u0631\u0627\u06cc\u0679\u0650\u06a9" },
            { "Mlym", "\u0645\u064e\u0644\u06cc\u0627\u0644\u064e\u0645" },
            { "Mong", "\u0645\u064e\u0646\u06af\u0648\u0644\u06cc\u064e\u0646" },
            { "Moon", "\u0645\u0648\u0657\u0646" },
            { "Mtei", "\u0645\u06cc\u062a\u06cc \u0645\u0627\u06cc\u064e\u06a9" },
            { "Mymr", "\u0645\u064e\u06cc\u064e\u0646\u0645\u0627\u0631" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "\u0627\u0648\u06af\u06c1\u0627\u0645" },
            { "Olck", "\u0627\u0648\u0644 \u0686\u0650\u06a9\u06cc" },
            { "Orkh", "\u0627\u0648\u0631\u06a9\u06be\u0648\u0646" },
            { "Orya", "\u0627\u0648\u0631\u0650\u06cc\u0627" },
            { "Osma", "\u0627\u0648\u0633\u0645\u0627\u0646\u06cc\u0627" },
            { "Perm", "\u0627\u0648\u0644\u0688 \u067e\u0654\u0631\u0645\u0650\u06a9" },
            { "Phag", "\u067e\u06be\u0627\u06af\u0633 \u067e\u0627" },
            { "Phlv", "\u0628\u0648\u0657\u06a9 \u067e\u064e\u06c1\u064e\u0644\u0648\u06cc" },
            { "Phnx", "\u067e\u06be\u0648\u0646\u0650\u0634\u0650\u06cc\u064e\u0646" },
            { "Plrd", "\u067e\u0648\u0644\u0627\u0691 \u067e\u06be\u0648\u0646\u0650\u0679\u0650\u06a9" },
            { "Rjng", "\u0631\u06cc\u062c\u064e\u0646\u06af" },
            { "Roro", "\u0631\u0648\u0646\u06af\u0648 \u0631\u0648\u0646\u06af\u0648" },
            { "Runr", "\u0631\u064e\u0646\u0650\u06a9" },
            { "Samr", "\u0633\u064e\u0645\u0627\u0631\u0650\u0679\u064e\u0646" },
            { "Sara", "\u0633\u064e\u0631\u0627\u062a\u06cc" },
            { "Saur", "\u0633\u0648\u0631\u0627\u0634\u0679\u0631\u0627" },
            { "Sgnw", "\u0627\u0650\u0634\u0627\u0631\u0672\u062a\u06cc \u0644\u0650\u06a9\u06be\u0672\u06d2" },
            { "Shaw", "\u0634\u0627\u0648\u06cc\u064e\u0646" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Sylo", "\u0633\u06cc\u0644\u0648\u062a\u06cc \u0646\u0627\u06af\u0631\u06cc" },
            { "Syrc", "\u0633\u06cc\u0656\u0631\u0650\u06cc\u064e\u06a9" },
            { "Syre", "\u0627\u06cc\u0633\u0679\u0631\u06cc\u0646\u062c\u0650\u0644\u0648 \u0633\u06cc\u0656\u0631\u0650\u06cc\u064e\u06a9" },
            { "Syrj", "\u0645\u063a\u0631\u0650\u0628\u06cc \u0633\u06cc\u0656\u0631\u06cc\u064e\u06a9" },
            { "Syrn", "\u0645\u0634\u0631\u064e\u0642\u06cc \u0633\u06cc\u0656\u0631\u06cc\u064e\u06a9" },
            { "Tagb", "\u062a\u064e\u06af\u0628\u064e\u0646\u0648\u0627" },
            { "Tale", "\u062a\u064e\u06cc\u0644\u06cc\u06d2" },
            { "Talu", "\u0646\u06c6\u0648 \u062a\u06cc\u0644\u0648" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Teng", "\u062a\u06cc\u0646\u06af\u0648\u0627\u0631" },
            { "Tfng", "\u062a\u0650\u0641\u0650\u0646\u0627\u06af" },
            { "Tglg", "\u062a\u064e\u06af\u064e\u0644\u0648\u06af" },
            { "Thaa", "\u062a\u06be\u0627\u0646\u0627" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "\u0627\u064f\u06af\u0627\u0631\u0650\u0679\u0650\u06a9" },
            { "Vaii", metaValue_vai },
            { "Visp", "\u0648\u0650\u0632\u0650\u0628\u0655\u0644 \u0633\u067e\u06cc\u0656\u0686" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "\u0633\u064f\u0645\u06cc\u0631\u0648 \u0627\u06a9\u0627\u062f\u06cc\u064e\u0646 \u06a9\u0648\u0657\u0646\u0650\u0641\u0627\u0645" },
            { "Yiii", "\u06cc\u0656\u06cc" },
            { "Zxxx", "\u0644\u06cc\u06a9\u06be\u0646\u064e\u06d2" },
            { "Zyyy", "\u0639\u0627\u0645" },
            { "Zzzz", "\u0646\u0627\u0645\u0648\u0644\u0648\u0657\u0645 \u0631\u064e\u0633\u0645 \u0627\u0644\u062e\u0637" },
            { "de_AT", "\u0622\u0633\u0679\u0631\u0650\u06cc\u064e\u0646 \u062c\u0654\u0631\u0645\u064e\u0646" },
            { "de_CH", "\u0633\u0655\u0648\u0650\u0633 \u06c1\u0627\u0626\u06cc \u062c\u0654\u0631\u0645\u064e\u0646" },
            { "en_AU", "\u0622\u0633\u0679\u0631\u06cc\u0644\u06cc\u064e\u0646 \u0627\u064e\u0646\u06af\u0631\u06cc\u0656\u0632\u06cd" },
            { "en_CA", "\u06a9\u06cc\u0646\u064e\u0688\u0650\u06cc\u0672\u06cc\u06cc \u0627\u064e\u0646\u06af\u0631\u06cc\u0656\u0632\u06cd" },
            { "en_GB", "\u0628\u064e\u0631\u0637\u0627\u0646\u0648\u06cc \u0627\u064e\u0646\u06af\u0631\u06cc\u0656\u0632\u06cd" },
            { "en_US", "\u0627\u0645\u0631\u06cc\u0656\u06a9\u06cc \u0627\u064e\u0646\u065b\u06af\u0631\u06cc\u0656\u0632\u06cd" },
            { "es_ES", "\u06cc\u0648\u0657\u0631\u067e\u06cc \u06c1\u0633\u067e\u0627\u0646\u0648\u06cc" },
            { "es_MX", "\u0645\u06cc\u06a9\u0633\u06cc\u06a9\u0646 \u06c1\u0633\u067e\u0627\u0646\u0648\u06cc" },
            { "fr_CA", "\u06a9\u064e\u0646\u06cc\u0688\u06cc\u064e\u0646 \u0641\u0631\u0627\u0646\u0633\u06cc\u0633\u06cc" },
            { "fr_CH", "\u0633\u0655\u0648\u0655\u0633 \u0641\u0631\u0627\u0646\u0633\u06cc\u0633\u06cc" },
            { "nl_BE", "\u0641\u0644\u06cc\u0645\u0650\u0634" },
            { "pt_BR", "\u0628\u0631\u0627\u0632\u06cc\u0656\u0644\u06cc \u067e\u064f\u0631\u062a\u064e\u06af\u06cc\u0656\u0632" },
            { "pt_PT", "\u06cc\u0648\u0657\u0631\u067e\u06cc \u067e\u064f\u0631\u062a\u064e\u06af\u06cc\u0656\u0632" },
            { "ro_MD", "\u0645\u0648\u0644\u062f\u0627\u0648\u0650\u06cc\u064e\u0646" },
            { "%%1901", "\u0631\u0620\u0648\u0672\u062a\u06cc \u062c\u0654\u0631\u0645\u064e\u0646 \u0639\u0650\u0644\u0645\u06c1\u0650 \u06c1\u0650\u062c\u0627" },
            { "%%1994", "\u0645\u064e\u06cc\u0639\u0672\u0631\u06cc \u0631\u0648\u0657\u0633\u06cc \u0639\u0650\u0644\u0645\u06c1\u0650 \u06c1\u0650\u062c\u0627" },
            { "%%1996", "\u062c\u0654\u0631\u0645\u064e\u0646 \u0639\u0650\u0644\u0645\u06c1\u0650 \u06c1\u0650\u062c\u0627 \u06f1\u06f9\u06f9\u06f6\u0633\u064f\u06a9" },
            { "ar_001", "\u0645\u0627\u0688\u0631\u0646 \u0645\u0639\u06cc\u0672\u0631\u06cc \u0639\u0631\u0628\u06cc" },
            { "es_419", "\u0644\u0627\u0637\u06cc\u0656\u0646\u06cc \u0627\u0645\u0631\u06cc\u0656\u06a9\u06cc \u06c1\u0633\u067e\u0627\u0646\u0648\u06cc" },
            { "key.ca", "\u06a9\u06cc\u0644\u0646\u0691\u0631" },
            { "key.cu", "\u0636\u064e\u0631\u0628" },
            { "%%BISKE", "\u0633\u06cc\u0646 \u062c\u0627\u0631\u062c\u0650\u06cc\u0648/\u0628\u0650\u0644\u0627 \u0628\u0648\u0657\u0644\u06cd" },
            { "%%LIPAW", "\u0631\u0648\u0657\u0633\u06cc \u0632\u064e\u0628\u0627\u0646\u06c1\u0650 \u06c1\u0650\u0646\u0632 \u0644\u0650\u067e\u0648\u0648\u0627\u0632 \u0628\u0648\u0657\u0644\u06cd" },
            { "%%NEDIS", "\u0646\u0620\u0679\u0650\u0633\u0648\u0646 \u0628\u0648\u0657\u0644\u06cd" },
            { "%%NJIVA", "\u0646\u06cc\u062c\u0650\u0648\u0627 \u0628\u0648\u0657\u0644\u06cd" },
            { "%%OSOJS", "\u0627\u064f\u0634\u06cc\u06a9\u0648/\u0627\u0648\u0633\u0648\u062c\u06cc\u0646 \u0628\u0648\u0657\u0644\u06cd" },
            { "%%POSIX", "\u06a9\u064e\u0645\u067e\u06cc\u0648\u0657\u0679\u064e\u0631" },
            { "%%ROZAJ", metaValue_ru },
            { "%%SAAHO", "\u0633\u0648\u06c1\u0648" },
            { "%%SOLBA", "\u062b\u0679\u0648\u0644\u0648\u0650\u0632\u0627/\u0633\u0648\u0644\u0628\u0650\u06a9\u0627 \u0628\u0648\u0657\u0644\u06cd" },
            { "zh_Hans", "\u0633\u064e\u06c1\u0644 \u0686\u06cc\u0656\u0646\u06cc" },
            { "zh_Hant", "\u0631\u0650\u0648\u0672\u062c\u06cc \u0686\u06cc\u0656\u0646\u06cc" },
            { "%%FONIPA", "\u0622\u0648\u0627\u0632\u06cc\u0627\u062a" },
            { "%%FONUPA", "\u06cc\u0648\u0657 \u067e\u06cc \u0627\u06d2 \u0622\u0648\u0627\u0632\u0650\u06cc\u0627\u062a" },
            { "%%SCOUSE", "\u0633\u0650\u06a9\u0648\u0633" },
            { "%%TARASK", "\u062a\u0627\u0631\u0627\u0633\u06a9\u06cc\u0656\u0648\u0650\u06a9\u0627 \u0639\u0644\u0645\u06c1 \u06c1\u0650\u062c\u0627\u0650" },
            { "%%AREVELA", "\u0645\u064e\u0634\u0631\u0650\u0642\u06cc \u0627\u064e\u0645\u0631\u06cc\u0656\u06a9\u0627" },
            { "%%MONOTON", "\u0627\u064e\u06a9\u0654\u06d2 \u0644\u06c1\u062c\u06c1\u0655 \u0648\u0627\u062c\u0620\u0646 \u0632\u064e\u0628\u0627\u0646" },
            { "%%POLYTON", "\u0648\u0627\u0631\u06cc\u0627\u06c1 \u0644\u06c1\u062c\u06c1\u0655 \u0648\u0627\u062c\u0620\u0646 \u0632\u064e\u0628\u0627\u0646" },
            { "%%REVISED", "\u062f\u064f\u0628\u0627\u0631\u0655 \u062f\u06c4\u06c1\u0631\u0627\u0648\u0646\u06c1\u0655 \u0622\u0645\u064f\u062a \u0639\u0650\u0644\u0645\u06c1\u0650 \u06c1\u0650\u062c\u0627" },
            { "%%1606NICT", "\u0628\u0639\u062f \u0648\u064e\u0642\u062a \u0648\u064e\u0633\u0637\u06cc \u0641\u0631\u0627\u0646\u0633 \u067e\u0620\u0679\u06be \u06f1\u06f6\u0660\u06f6 \u062a\u0627\u0645" },
            { "%%BAKU1926", "\u062c\u0654\u0645\u0639 \u06a9\u0654\u0631\u0650\u062a\u06be \u062a\u064f\u0631\u06a9\u06cc \u0644\u0627\u0637\u06cc\u0656\u0646\u06cc \u0627\u064e\u0686\u06be\u0631" },
            { "%%SCOTLAND", "\u0633\u064f\u06a9\u0627\u0679\u0650\u0634 \u0645\u064e\u06cc\u0639\u0672\u0631\u06cc \u0627\u064e\u0646\u06af\u0631\u06cc\u0656\u0632\u06cd" },
            { "type.ca.roc", "\u062c\u0645\u0648\u0657\u0631\u06cc\u0672\u062a\u06cc \u0686\u06cc\u0656\u0646\u06cc \u06a9\u06cc\u0644\u064e\u0646\u0691\u064e\u0631" },
            { "type.nu.arab", "\u0627\u064e\u0631\u0628\u06cc-\u0627\u0650\u0646\u0688\u0650\u06a9 \u06c1\u0646\u062f\u0633\u0655\u06c1" },
            { "type.nu.deva", "\u062f\u06cc\u0648\u0646\u0627\u06af\u0631\u06cc \u06c1\u0646\u062f\u0633\u0655\u06c1" },
            { "type.nu.latn", "\u0645\u063a\u0631\u0628\u06cc \u06c1\u0646\u062f\u0633\u0655\u06c1" },
            { "type.ca.hebrew", "\u06c1\u0650\u0628\u0631\u0650\u0648 \u06a9\u06cc\u0644\u0646\u0691\u064e\u0631" },
            { "type.ca.indian", "\u0627\u0646\u0688\u06cc\u0646 \u0646\u06cc\u0634\u0646\u0644 \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "type.co.pinyin", "\u0622\u0633\u0627\u0646 \u0628\u064e\u0646\u0627\u0648\u0646\u06c1\u0655 \u0622\u0645\u064f\u062a \u0686\u06cc\u0656\u0646\u06cc \u067e\u06cc\u0656\u0646\u06cc\u064e\u0646 \u062a\u064e\u0631\u062a\u06cc\u0656\u0628" },
            { "type.co.stroke", "\u0631\u0620\u0648\u0672\u062a\u06cc \u0686\u06cc\u0656\u0646\u06cc \u0633\u0679\u0631\u0648\u06a9 \u062a\u064e\u0631\u062a\u06cc\u0656\u0628" },
            { "type.ca.chinese", "\u0686\u06cc\u0656\u0646\u06cc \u06a9\u06cc\u0644\u064e\u0646\u0691\u064e\u0631" },
            { "type.ca.iso8601", "ISO-8601 \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "type.co.big5han", "\u0631\u0620\u0648\u0672\u062a\u06cc \u0686\u06cc\u0656\u0646\u06cc \u062a\u0650\u0631\u062a\u06cc\u0656\u0628" },
            { "type.nu.arabext", "\u062a\u0648\u0633\u06cc\u0656\u0639 \u0634\u064f\u062f\u06c1 \u0627\u064e\u0631\u0628\u06cc-\u0627\u0650\u0646\u0688\u0650\u06a9 \u06c1\u0646\u062f\u0633\u0655\u06c1" },
            { "type.ca.buddhist", "\u0628\u064f\u062f\u064e\u0646 \u06c1\u064f\u0646\u062f \u06a9\u06cc\u0644\u0646\u0691\u064e\u0631" },
            { "type.ca.japanese", "\u062c\u0627\u067e\u0672\u0646\u06cd \u06a9\u06cc\u0644\u0646\u0691\u064e\u0631" },
            { "type.co.standard", "\u0645\u0639\u06cc\u0672\u0631\u06cc \u062a\u0631\u062a\u06cc\u0656\u0628 \u0622\u0688\u0631" },
            { "type.ca.gregorian", "\u06af\u0631\u06af\u0648\u0631\u06cc\u064e\u0646 \u06a9\u06cc\u0644\u0646\u0691\u064e\u0631" },
            { "type.co.phonebook", "\u0641\u0648\u0646 \u0628\u064f\u06a9 \u062a\u064e\u0631\u062a\u06cc\u0656\u0628" },
            { "type.co.traditional", "\u0631\u0620\u0648\u0672\u062a\u06cc \u062a\u064e\u0631\u062a\u06cc\u0656\u0628" },
        };
        return data;
    }
}
