# 12 "lib/Literal_lexer.mll"
 
open Stdlib

(* To buffer string literals *)

let string_buffer = Buffer.create 256
let reset_string_buffer () = Buffer.reset string_buffer
let get_stored_string () = Buffer.contents string_buffer

let store_string_char c = Buffer.add_char string_buffer c
let store_string s = Buffer.add_string string_buffer s

exception Parse_error


# 18 "lib/Literal_lexer.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base =
   "\000\000\254\255\255\255\001\000\242\255\243\255\244\255\002\000\
    \251\255\006\000\255\255\245\255\001\000\079\000\000\000\016\000\
    \250\255\252\255\253\255\000\000\007\000\008\000\026\000\249\255\
    \036\000\057\000\248\255\102\000\247\255\140\000\166\000\246\255\
    \012\000";
  Lexing.lex_backtrk =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\013\000\
    \255\255\013\000\255\255\255\255\010\000\010\000\010\000\010\000\
    \255\255\255\255\255\255\001\000\010\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255";
  Lexing.lex_default =
   "\001\000\000\000\000\000\004\000\000\000\000\000\000\000\255\255\
    \000\000\011\000\000\000\000\000\255\255\255\255\255\255\255\255\
    \000\000\000\000\000\000\255\255\255\255\255\255\255\255\000\000\
    \255\255\255\255\000\000\255\255\000\000\255\255\255\255\000\000\
    \255\255";
  Lexing.lex_trans =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\019\000\008\000\006\000\006\000\000\000\007\000\032\000\
    \019\000\019\000\019\000\020\000\021\000\021\000\006\000\000\000\
    \000\000\032\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \019\000\000\000\002\000\010\000\000\000\000\000\017\000\000\000\
    \018\000\000\000\000\000\000\000\000\000\018\000\000\000\000\000\
    \024\000\024\000\024\000\024\000\000\000\000\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \022\000\022\000\022\000\022\000\022\000\022\000\022\000\022\000\
    \022\000\022\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\023\000\023\000\025\000\025\000\025\000\025\000\
    \025\000\025\000\025\000\025\000\000\000\009\000\000\000\000\000\
    \000\000\000\000\018\000\000\000\000\000\000\000\000\000\000\000\
    \018\000\026\000\026\000\026\000\026\000\026\000\026\000\026\000\
    \026\000\000\000\000\000\000\000\016\000\014\000\000\000\000\000\
    \018\000\000\000\018\000\012\000\029\000\000\000\013\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\028\000\028\000\
    \028\000\028\000\028\000\028\000\028\000\028\000\028\000\028\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\028\000\
    \028\000\028\000\028\000\028\000\028\000\000\000\000\000\000\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\030\000\030\000\030\000\030\000\
    \030\000\030\000\030\000\030\000\030\000\030\000\000\000\028\000\
    \028\000\028\000\028\000\028\000\028\000\030\000\030\000\030\000\
    \030\000\030\000\030\000\000\000\000\000\000\000\030\000\030\000\
    \030\000\030\000\030\000\030\000\030\000\030\000\030\000\030\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\030\000\
    \030\000\030\000\030\000\030\000\030\000\030\000\030\000\030\000\
    \030\000\030\000\030\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \255\255\005\000\000\000\000\000\000\000\000\000\255\255\030\000\
    \030\000\030\000\030\000\030\000\030\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\031\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_check =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\019\000\003\000\003\000\007\000\255\255\003\000\007\000\
    \009\000\020\000\021\000\009\000\020\000\021\000\032\000\255\255\
    \255\255\032\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \019\000\255\255\000\000\003\000\255\255\255\255\009\000\255\255\
    \009\000\255\255\255\255\255\255\255\255\009\000\255\255\255\255\
    \014\000\014\000\014\000\014\000\255\255\255\255\009\000\009\000\
    \009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\022\000\022\000\022\000\022\000\022\000\022\000\
    \022\000\022\000\022\000\022\000\024\000\024\000\024\000\024\000\
    \024\000\024\000\024\000\024\000\255\255\003\000\255\255\255\255\
    \255\255\255\255\009\000\255\255\255\255\255\255\255\255\255\255\
    \009\000\025\000\025\000\025\000\025\000\025\000\025\000\025\000\
    \025\000\255\255\255\255\255\255\009\000\009\000\255\255\255\255\
    \009\000\255\255\009\000\009\000\012\000\255\255\009\000\013\000\
    \013\000\013\000\013\000\013\000\013\000\013\000\013\000\013\000\
    \013\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \013\000\013\000\013\000\013\000\013\000\013\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\027\000\
    \027\000\027\000\027\000\027\000\027\000\255\255\255\255\255\255\
    \013\000\013\000\013\000\013\000\013\000\013\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\029\000\029\000\029\000\029\000\
    \029\000\029\000\029\000\029\000\029\000\029\000\255\255\027\000\
    \027\000\027\000\027\000\027\000\027\000\029\000\029\000\029\000\
    \029\000\029\000\029\000\255\255\255\255\255\255\030\000\030\000\
    \030\000\030\000\030\000\030\000\030\000\030\000\030\000\030\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\030\000\
    \030\000\030\000\030\000\030\000\030\000\029\000\029\000\029\000\
    \029\000\029\000\029\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\003\000\255\255\255\255\255\255\255\255\009\000\030\000\
    \030\000\030\000\030\000\030\000\030\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\030\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255";
  Lexing.lex_base_code =
   "";
  Lexing.lex_backtrk_code =
   "";
  Lexing.lex_default_code =
   "";
  Lexing.lex_trans_code =
   "";
  Lexing.lex_check_code =
   "";
  Lexing.lex_code =
   "";
}

let rec string mode lexbuf =
   __ocaml_lex_string_rec mode lexbuf 0
and __ocaml_lex_string_rec mode lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 34 "lib/Literal_lexer.mll"
      ( reset_string_buffer ();
        string_aux mode lexbuf;
        get_stored_string () )
# 169 "lib/Literal_lexer.ml"

  | 1 ->
# 37 "lib/Literal_lexer.mll"
      ( raise Parse_error )
# 174 "lib/Literal_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_string_rec mode lexbuf __ocaml_lex_state

and string_aux mode lexbuf =
   __ocaml_lex_string_aux_rec mode lexbuf 3
and __ocaml_lex_string_aux_rec mode lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 42 "lib/Literal_lexer.mll"
      ( () )
# 186 "lib/Literal_lexer.ml"

  | 1 ->
# 44 "lib/Literal_lexer.mll"
      ( string_aux mode lexbuf )
# 191 "lib/Literal_lexer.ml"

  | 2 ->
# 46 "lib/Literal_lexer.mll"
      ( store_string (Lexing.lexeme lexbuf);
        string_aux mode lexbuf )
# 197 "lib/Literal_lexer.ml"

  | 3 ->
# 49 "lib/Literal_lexer.mll"
      ( begin match mode with
          | `Normalize -> store_string " "
          | `Preserve -> store_string "\\ " end;
        string_aux mode lexbuf )
# 205 "lib/Literal_lexer.ml"

  | 4 ->
# 54 "lib/Literal_lexer.mll"
      ( begin match mode with
          | `Normalize -> store_string "\\t"
          | `Preserve -> store_string "\t" end;
        string_aux mode lexbuf )
# 213 "lib/Literal_lexer.ml"

  | 5 ->
# 59 "lib/Literal_lexer.mll"
      ( begin match mode with
          | `Normalize -> store_string "\n"
          | `Preserve -> store_string "\\n" end;
        string_aux mode lexbuf )
# 221 "lib/Literal_lexer.ml"

  | 6 ->
# 64 "lib/Literal_lexer.mll"
      ( store_string (Lexing.lexeme lexbuf);
        string_aux mode lexbuf )
# 227 "lib/Literal_lexer.ml"

  | 7 ->
# 67 "lib/Literal_lexer.mll"
      ( store_string (Lexing.lexeme lexbuf);
        string_aux mode lexbuf )
# 233 "lib/Literal_lexer.ml"

  | 8 ->
# 70 "lib/Literal_lexer.mll"
      ( store_string (Lexing.lexeme lexbuf);
        string_aux mode lexbuf )
# 239 "lib/Literal_lexer.ml"

  | 9 ->
# 73 "lib/Literal_lexer.mll"
      ( store_string (Lexing.lexeme lexbuf);
        string_aux mode lexbuf )
# 245 "lib/Literal_lexer.ml"

  | 10 ->
# 76 "lib/Literal_lexer.mll"
      ( (*  Should be an error, but we are very lax.
            raise (Error (Illegal_escape (Lexing.lexeme lexbuf),
            Location.curr lexbuf))
        *)
        store_string (Lexing.lexeme lexbuf);
        string_aux mode lexbuf
      )
# 256 "lib/Literal_lexer.ml"

  | 11 ->
# 84 "lib/Literal_lexer.mll"
      ( (* See store_normalized_newline in vendor/parser-standard/lexer.mll. *)
        (match Lexing.lexeme lexbuf with
        | "\n" -> store_string "\n"
        | s -> store_string (String.sub s 1 (String.length s - 1)));
        string_aux mode lexbuf )
# 265 "lib/Literal_lexer.ml"

  | 12 ->
# 90 "lib/Literal_lexer.mll"
      ( raise Parse_error )
# 270 "lib/Literal_lexer.ml"

  | 13 ->
# 92 "lib/Literal_lexer.mll"
      ( store_string_char (Lexing.lexeme_char lexbuf 0);
        string_aux mode lexbuf )
# 276 "lib/Literal_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_string_aux_rec mode lexbuf __ocaml_lex_state

;;

# 95 "lib/Literal_lexer.mll"
 
  let string mode s =
    let lexbuf = Lexing.from_string s in
    match string mode lexbuf with
    | s -> Some s
    | exception Parse_error -> None

# 291 "lib/Literal_lexer.ml"
