/*  shout.h
**
**  api for libshout, the streaming library for icecast
*/
#ifndef __LIBSHOUT_SHOUT_H
#define __LIBSHOUT_SHOUT_H

#ifdef __cplusplus
extern "C" {
#endif

#define SHOUTERR_INSANE		1
#define SHOUTERR_NOCONNECT	2
#define SHOUTERR_NOLOGIN	3
#define SHOUTERR_SOCKET		4
#define SHOUTERR_MALLOC		5
#define SHOUTERR_METADATA	6

typedef struct {
	char *ip;		/* ip of the icecast server (CAN NOT BE A HOSTNAME) */
	int port;		/* port of the icecast server */
	char *mount;		/* mountpoint for this stream */

	int connected;		/* are we connected to a server? */
	int _socket;		/* internal - socket the connection is on */

	char *password;		/* login password for the server */
	int icy_compat;		/* turn on icy (shoutcast) compatibility */
	char *aim;		/* Nullsoft requires this.  silly them. */
	char *icq;		/* icy extension */
	char *irc;		/* another icy extension */
	char *dumpfile;		/* dumpfile to use on the server */
	char *name;		/* name of the stream */
	char *url;		/* url of the stream */
	char *genre;		/* genre of the stream */
	char *description;	/* description of the stream */
	int bitrate;		/* bitrate of this stream */
	int ispublic;		/* is this stream private? */
	int error;
	int frames;		/* total frames broadcasted */

	long long _starttime;	/* start of this period's timeclock */
	long long _senttime;	/* amout of data we've sent (in milliseconds) */
	int _frame_samples;	/* the number of samples for the current frame */
	int _frame_samplerate;  /* the samplerate of the current frame */
	int _frame_left;	/* how many bytes for teh rest of this frame */
	int _header_bridges;	/* is the header bridged?? */
	unsigned char _header_bridge[3];	/* put part of header here if it spans a boundary */
	char _servermsg [4096];  /* Server response on login */
} shout_conn_t;


/*
** shout_init_connection
**
** initializes the shout_conn_t structure
*/
void shout_init_connection(shout_conn_t *self);

/*
** shout_connect
**  
** opens a connection to an icecast server, and logs in
*/
int shout_connect(shout_conn_t *self);

/*
** shout_disconnect
**
** closes a connection to an icecast server
*/
int shout_disconnect(shout_conn_t *self);

/*
** shout_send_data
** 
** sends a block of data (buffsize bytes in buff) to the icecast
** server at the correct rate (calculated by the bitrate in the mp3
** frame headers
*/
int shout_send_data(shout_conn_t *self, unsigned char *buff, unsigned long len);

/*
** shout_sleep
**
** sleeps if need be
**
*/
void shout_sleep(shout_conn_t *self);

/*
** shout_update_metadata
**
** the metadata info for the stream.  meta is in block format
*/
int shout_update_metadata(shout_conn_t *self, char *metadata);

/*
** shout_strerror
**
** Formats the error code to a user readable string, like strerror()
** Returns pointer to dest.
*/
char *shout_strerror(shout_conn_t *self, int error, char *dest, int maxlen);

#ifdef __cplusplus
}
#endif

#endif /* __LIBSHOUT_SHOUT_H */
