# - Find the QtXdg include and library dirs and define a some macros
#
# The module defines the following variables
#  QTXDG_FOUND         - Set to TRUE if all of the above has been found
#
#  QTXDG_INCLUDE_DIR   - The QtXdg include directory
#
#  QTXDG_INCLUDE_DIRS  - The QtXdg lib and it's dependencies include directories
#
#  QTXDG_LIBRARY_DIRS  - The QtXdg lib and it's dependencies linker search paths
#
#  QTXDG_LIBRARY       - The QtXdg library itself
#  QTXDG_LIBRARIES     - The QtXdg library and all it's dependencies
#
#  QTXDG_USE_FILE      - The variable QTXDG_USE_FILE is set which is the path
#                        to a CMake file that can be included to compile qtxdg
#                        applications and libraries. It sets up the compilation
#                        environment for include directories and populates a
#                        QTXDG_LIBRARIES variable.
#
# QTXDG_QT_LIBRARIES   - The QtXdg Qt dependencies libraries
#
# Typical usage:
#    option(USE_QT5 "Build using Qt5. Default off" OFF)
#    if (USE_QT5)
#        find_package(QT5XDG)
#    else()
#        find_package(QTXDG)
#    endif()
#
#    include(${QTXDG_USE_FILE})
#    add_executable(use-qtxdg main.cpp)
#    target_link_libraries(use-qtxdg ${QTXDG_LIBRARIES})

set(QTXDG_INCLUDE_DIR   "/opt/local/include/qtxdg")
set(QTXDG_PRIVATE_INCLUDE_DIR "")
set(QTXDG_LIBRARY       qtxdg)

set(QTXDG_LIBRARIES     ${QTXDG_LIBRARY})
set(QTXDG_INCLUDE_DIRS  "${QTXDG_INCLUDE_DIR}")

set(QTXDG_LIBRARY_DIRS  "/opt/local/lib")

set(QTXDG_USE_FILE      "${CMAKE_CURRENT_LIST_DIR}/qtxdg_use.cmake")
set(QTXDG_FOUND 1)
set(QTXDG_QTMIMETYPES   ON)

set(QTXDG_MAJOR_VERSION 1)
set(QTXDG_MINOR_VERSION 2)
set(QTXDG_PATCH_VERSION 0)
set(QTXDG_VERSION 1.2.0)

mark_as_advanced(QTXDG_LIBRARY QTXDG_INCLUDE_DIR)
