/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.nexus2.api;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class NexusAPIException
extends RuntimeException {
    private static final long serialVersionUID = -6684289853549902181L;
    private final int status;
    private final String reason;
    private final Map<String, Collection<String>> headers;

    public NexusAPIException(int status, String reason) {
        this(status, reason, Collections.emptyMap());
    }

    public NexusAPIException(int status, String reason, Map<String, Collection<String>> headers) {
        super(status + ": " + reason);
        this.status = status;
        this.reason = reason;
        this.headers = headers;
    }

    public int getStatus() {
        return this.status;
    }

    public String getReason() {
        return this.reason;
    }

    public Map<String, Collection<String>> getHeaders() {
        return this.headers;
    }

    public boolean isNotFound() {
        return 404 == this.status;
    }

    public boolean isForbidden() {
        return 403 == this.status;
    }

    public boolean isUnauthorized() {
        return 401 == this.status;
    }
}

