/*
 * Decompiled with CFR 0.152.
 */
package com.danga.MemCached.test;

import com.danga.MemCached.MemCachedClient;
import com.danga.MemCached.SockIOPool;
import java.util.Map;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MemCachedBench {
    private static Logger log = Logger.getLogger((String)MemCachedBench.class.getName());

    public static void main(String[] args) {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.OFF);
        int runs = Integer.parseInt(args[0]);
        int start = Integer.parseInt(args[1]);
        String[] serverlist = new String[]{"192.168.1.50:1624"};
        SockIOPool pool = SockIOPool.getInstance("test");
        pool.setServers(serverlist);
        pool.setInitConn(100);
        pool.setMinConn(100);
        pool.setMaxConn(500);
        pool.setMaintSleep(20L);
        pool.setNagle(false);
        pool.initialize();
        MemCachedClient mc = new MemCachedClient("test");
        mc.setCompressEnable(false);
        String keyBase = "testKey";
        String object = "This is a test of an object blah blah es, serialization does not seem to slow things down so much.  The gzip compression is horrible horrible performance, so we only use it for very large objects.  I have not done any heavy benchmarking recently";
        long begin = System.currentTimeMillis();
        for (int i = start; i < start + runs; ++i) {
            mc.set(keyBase + i, object);
        }
        long end = System.currentTimeMillis();
        long time = end - begin;
        System.out.println(runs + " sets: " + time + "ms");
        begin = System.currentTimeMillis();
        for (int i = start; i < start + runs; ++i) {
            String string = (String)mc.get(keyBase + i);
        }
        end = System.currentTimeMillis();
        time = end - begin;
        System.out.println(runs + " gets: " + time + "ms");
        String[] keys = new String[runs];
        int j = 0;
        for (int i = start; i < start + runs; ++i) {
            keys[j] = keyBase + i;
            ++j;
        }
        begin = System.currentTimeMillis();
        Map<String, Object> vals = mc.getMulti(keys);
        end = System.currentTimeMillis();
        time = end - begin;
        System.out.println(runs + " getMulti: " + time + "ms");
        begin = System.currentTimeMillis();
        for (int i = start; i < start + runs; ++i) {
            mc.delete(keyBase + i);
        }
        end = System.currentTimeMillis();
        time = end - begin;
        System.out.println(runs + " deletes: " + time + "ms");
        SockIOPool.getInstance("test").shutDown();
    }
}

