/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.reporting;

import org.kordamp.jarviz.reporting.Formatter;
import org.kordamp.jarviz.reporting.Node;
import org.kordamp.jarviz.reporting.Report;
import org.kordamp.jarviz.util.StringUtils;

public class TxtFormatter
extends Formatter {
    public static final TxtFormatter INSTANCE = new TxtFormatter();
    private static final String COLON = ":";

    private TxtFormatter() {
    }

    @Override
    public String write(Node node) {
        Report report = new Report();
        for (Node child : node.getChildren()) {
            this.append(report, child);
        }
        return report.toString();
    }

    @Override
    protected void append(Report report, Node node) {
        report.indent(this.indentationFor(node)).append(this.element(node.getName()));
        if (StringUtils.isNotBlank(node.getValue())) {
            report.append(COLON).append(" ").append(this.formatValue(node));
        } else if (!node.getChildren().isEmpty()) {
            report.append(COLON).newLine();
            for (Node child : node.getChildren()) {
                this.append(report, child);
            }
            report.indent(this.indentationFor(node));
        }
        report.newLine();
    }

    private String element(String str) {
        return str;
    }

    @Override
    protected int indentAdjustment() {
        return 1;
    }
}

