/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.resolvers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarFile;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.internal.GavAwareJarFile;
import org.kordamp.jarviz.core.model.Gav;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.util.StringUtils;

public class GavBasedJarFileResolver
implements JarFileResolver {
    private final Gav gav;
    private final Path cacheDirectory;
    private JarFile jarFile;

    public GavBasedJarFileResolver(Path cacheDirectory, String gav) {
        this.cacheDirectory = cacheDirectory;
        this.gav = new Gav(gav);
    }

    @Override
    public Set<JarFile> resolveJarFiles() {
        if (null != this.jarFile) {
            return Collections.singleton(this.jarFile);
        }
        String filename = this.gav.getArtifactId() + "-" + this.gav.getVersion() + (String)(StringUtils.isNotBlank(this.gav.getClassifier()) ? "-" + this.gav.getClassifier() : "") + ".jar";
        String str = "https://repo1.maven.org/maven2/" + this.gav.getGroupId() + "/" + this.gav.getArtifactId() + "/" + this.gav.getVersion() + "/" + filename;
        String mavenLocal = String.join((CharSequence)File.separator, List.of(System.getProperty("user.home"), ".m2", "repository", this.gav.getGroupId().replace("/", File.separator), this.gav.getArtifactId(), this.gav.getVersion(), filename));
        URL url = null;
        try {
            url = new URI(str).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new JarvizException(RB.$("ERROR_INVALID_URL", str));
        }
        Instant remoteLastModified = null;
        try {
            remoteLastModified = Instant.ofEpochMilli(url.openConnection().getLastModified());
        }
        catch (IOException e) {
            throw new JarvizException(RB.$("ERROR_HEAD_URL", url));
        }
        Optional<Path> file = this.checkCachedFile(remoteLastModified, Path.of(mavenLocal, new String[0]));
        if (file.isEmpty()) {
            file = this.checkCachedFile(remoteLastModified, this.cacheDirectory.resolve(filename));
        }
        if (file.isPresent()) {
            return this.createJarFile(file.get());
        }
        Path path = this.cacheDirectory.resolve(filename);
        try (InputStream stream = url.openStream();){
            Files.copy(stream, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new JarvizException(RB.$("ERROR_DOWNLOADING_URL", url), e);
        }
        return this.createJarFile(path);
    }

    private Optional<Path> checkCachedFile(Instant remoteLastModified, Path file) {
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Instant localLastModified = Files.getLastModifiedTime(file, new LinkOption[0]).toInstant();
                if (localLastModified.isAfter(remoteLastModified)) {
                    return Optional.of(file);
                }
            }
            catch (IOException e) {
                throw new JarvizException(RB.$("ERROR_FILE_LAST_MODIFIED", file.toAbsolutePath()));
            }
        }
        return Optional.empty();
    }

    private Set<JarFile> createJarFile(Path file) {
        try {
            this.jarFile = new GavAwareJarFile(file.toFile(), this.gav);
            return Collections.singleton(this.jarFile);
        }
        catch (IOException e) {
            throw new JarvizException(RB.$("ERROR_OPENING_JAR", file.toAbsolutePath()));
        }
    }
}

