/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.processors;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.model.Checksum;
import org.kordamp.jarviz.core.model.Gav;
import org.kordamp.jarviz.core.model.GavAware;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.util.Algorithm;
import org.kordamp.jarviz.util.ChecksumUtils;

public class ChecksumJarProcessor
implements JarProcessor<Set<Checksum>> {
    private static final Pattern CHECKSUM = Pattern.compile("^([a-fA-F0-9]+).*$");
    private static final String MAVEN_METADATA = "META-INF/maven/";
    private final JarFileResolver jarFileResolver;

    public ChecksumJarProcessor(JarFileResolver jarFileResolver) {
        this.jarFileResolver = jarFileResolver;
    }

    @Override
    public Set<JarProcessor.JarFileResult<Set<Checksum>>> getResult() throws JarvizException {
        TreeSet<JarProcessor.JarFileResult<Set<Checksum>>> set = new TreeSet<JarProcessor.JarFileResult<Set<Checksum>>>();
        Set<JarFile> jarFiles = this.jarFileResolver.resolveJarFiles();
        for (JarFile jarFile : jarFiles) {
            try {
                JarFile jarFile2 = jarFile;
                try {
                    if (jarFile instanceof GavAware) {
                        this.checksum(jarFile, ((GavAware)((Object)jarFile)).getGav(), set);
                        continue;
                    }
                    Set<JarEntry> candidates = jarFile.stream().filter(entry -> entry.getName().endsWith(".properties") && entry.getName().startsWith(MAVEN_METADATA)).collect(Collectors.toSet());
                    this.findGav(jarFile, candidates).ifPresent(gav -> this.checksum(jarFile, (Gav)gav, (Set<JarProcessor.JarFileResult<Set<Checksum>>>)set));
                }
                finally {
                    if (jarFile2 == null) continue;
                    jarFile2.close();
                }
            }
            catch (IOException e) {
                throw new JarvizException(RB.$("ERROR_OPENING_JAR", jarFile.getName()));
            }
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Gav> findGav(JarFile jarFile, Set<JarEntry> candidates) {
        String fileName = Path.of(jarFile.getName(), new String[0]).getFileName().toString();
        fileName = fileName.substring(0, fileName.length() - 4);
        Iterator<JarEntry> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            JarEntry candidate = iterator.next();
            try {
                InputStream in = jarFile.getInputStream(candidate);
                try {
                    String version;
                    Properties props = new Properties();
                    props.load(in);
                    String artifactId = props.getProperty("artifactId");
                    if (!fileName.startsWith(artifactId + "-" + (version = props.getProperty("version")))) continue;
                    Optional<Gav> optional = Optional.of(new Gav(props));
                    return optional;
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e) {
                throw new JarvizException(RB.$("ERROR_OPENING_JAR", jarFile.getName()));
            }
        }
        return Optional.empty();
    }

    private void checksum(JarFile jarFile, Gav gav, Set<JarProcessor.JarFileResult<Set<Checksum>>> set) {
        String groupId = gav.getGroupId().replace(".", "/");
        String artifactId = gav.getArtifactId();
        String version = gav.getVersion();
        String filename = artifactId + "-" + version + ".jar";
        String baseUrl = "https://repo1.maven.org/maven2/" + groupId + "/" + artifactId + "/" + version + "/" + filename;
        TreeSet<Checksum> checksums = new TreeSet<Checksum>();
        for (Algorithm algorithm : Algorithm.values()) {
            checksums.add(this.check(jarFile, algorithm, baseUrl));
        }
        set.add(JarProcessor.JarFileResult.of(jarFile, checksums));
    }

    private Checksum check(JarFile jarFile, Algorithm algorithm, String baseUrl) {
        String str = baseUrl + algorithm.extension();
        URL url = null;
        try {
            url = new URI(str).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new JarvizException(RB.$("ERROR_INVALID_URL", str));
        }
        Path localJar = Path.of(jarFile.getName(), new String[0]);
        Path remoteJar = null;
        try {
            remoteJar = Files.createTempFile(localJar.getFileName().toString(), algorithm.toString(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new JarvizException(RB.$("ERROR_UNEXPECTED", new Object[0]), e);
        }
        try (InputStream stream = url.openStream();){
            Files.copy(stream, remoteJar, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (FileNotFoundException ignored) {
            return Checksum.unavailable(algorithm);
        }
        catch (IOException e) {
            throw new JarvizException(RB.$("ERROR_DOWNLOADING_URL", url), e);
        }
        try {
            String localChecksum = ChecksumUtils.checksum(algorithm, localJar);
            String remoteChecksum = this.sanitize(new String(Files.readAllBytes(remoteJar)).trim());
            return localChecksum.equals(remoteChecksum) ? Checksum.success(algorithm) : Checksum.failure(algorithm);
        }
        catch (IOException e) {
            throw new JarvizException(RB.$("ERROR_UNEXPECTED", new Object[0]), e);
        }
    }

    private String sanitize(String input) {
        Matcher matcher = CHECKSUM.matcher(input);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }
}

