/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.commands;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Manifest;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.Format;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.internal.AbstractCommand;
import org.kordamp.jarviz.core.internal.AbstractConfiguration;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.processors.ManifestShowJarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.reporting.Node;

public class ManifestShowCommand
extends AbstractCommand<Configuration> {
    public static Configuration config() {
        return new Configuration();
    }

    @Override
    public int execute(Configuration configuration) {
        JarFileResolver jarFileResolver = this.createJarFileResolver(configuration);
        ManifestShowJarProcessor processor = new ManifestShowJarProcessor(jarFileResolver);
        Set<JarProcessor.JarFileResult<Optional<Manifest>>> results = processor.getResult();
        if (results.isEmpty()) {
            return 1;
        }
        this.output(configuration, results);
        this.report(configuration, results);
        return 0;
    }

    private void output(Configuration configuration, Set<JarProcessor.JarFileResult<Optional<Manifest>>> results) {
        Node root = this.createRootNode();
        Format outputFormat = configuration.getOutputFormat();
        for (JarProcessor.JarFileResult<Optional<Manifest>> result : results) {
            if (null == outputFormat) {
                this.output(configuration, result);
                continue;
            }
            this.buildReport(root, result);
        }
        if (null != outputFormat) {
            this.writeOutput(configuration, this.resolveFormatter(outputFormat).write(root));
        }
    }

    private void output(Configuration configuration, JarProcessor.JarFileResult<Optional<Manifest>> result) {
        if (result.getResult().isPresent()) {
            configuration.getOut().println(this.$$("output.subject", result.getJarFileName()));
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                result.getResult().get().write(baos);
                baos.flush();
                baos.close();
                configuration.getOut().println(baos);
            }
            catch (IOException e) {
                throw new JarvizException(RB.$("ERROR_UNEXPECTED_WRITE", new Object[0]), e);
            }
        }
    }

    private void report(Configuration configuration, Set<JarProcessor.JarFileResult<Optional<Manifest>>> results) {
        if (null == configuration.getReportPath()) {
            return;
        }
        for (Format format : configuration.getReportFormats()) {
            Node root = this.createRootNode();
            for (JarProcessor.JarFileResult<Optional<Manifest>> result : results) {
                if (!result.getResult().isPresent()) continue;
                this.buildReport(root, result);
            }
            this.writeReport(configuration, this.resolveFormatter(format).write(root), format);
        }
    }

    private void buildReport(Node root, JarProcessor.JarFileResult<Optional<Manifest>> result) {
        this.appendSubject(root, result.getJarPath(), "manifest show", resultNode -> resultNode.node(RB.$("report.key.manifest", new Object[0])).value(((Optional)result.getResult()).get()).end());
    }

    public static class Configuration
    extends AbstractConfiguration<Configuration> {
    }
}

