/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Properties;
import net.sf.swarmcache.CacheConfiguration;
import net.sf.swarmcache.CacheConfigurationManager;
import net.sf.swarmcache.CacheFactory;
import net.sf.swarmcache.ObjectCache;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.SwarmCache;

public class SwarmCacheProvider
implements CacheProvider {
    private CacheFactory factory;

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        ObjectCache cache = this.factory.createCache(regionName);
        if (cache == null) {
            throw new CacheException("SwarmCache did not create a cache: " + regionName);
        }
        return new SwarmCache(cache, regionName);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public void start(Properties properties) throws CacheException {
        CacheConfiguration config = CacheConfigurationManager.getConfig((Properties)properties);
        this.factory = new CacheFactory(config);
    }

    public void stop() {
        if (this.factory != null) {
            this.factory.shutdown();
            this.factory = null;
        }
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }
}

