/*
 * Decompiled with CFR 0.152.
 */
package net.sf.swarmcache;

import java.io.Serializable;
import net.sf.swarmcache.MultiCacheManager;
import net.sf.swarmcache.ObjectCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiCache
implements ObjectCache {
    Log log = LogFactory.getLog(this.getClass());
    public static final String CACHE_TYPE_PROPERTY = "multi.cache.type";
    private ObjectCache cache;
    private MultiCacheManager manager;

    public MultiCache(ObjectCache cache, MultiCacheManager manager) {
        this.cache = cache;
        this.manager = manager;
    }

    public String getType() {
        return this.cache.getType();
    }

    public void setType(String type) {
        this.cache.setType(type);
        this.manager.addCache(this);
    }

    public void put(Serializable key, Object object) {
        if (this.cache.get(key) != null) {
            this.clear(key);
        }
        this.cache.put(key, object);
    }

    public Object get(Serializable key) {
        return this.cache.get(key);
    }

    public Object clear(Serializable key) {
        Object returnValue = this.cache.clear(key);
        this.manager.sendClear(this.getType(), key);
        return returnValue;
    }

    public void doClear(Serializable key) {
        this.cache.clear(key);
    }

    public void clearAll() {
        this.cache.clearAll();
        this.manager.sendClear(this.getType(), (Serializable)((Object)"(ALL)"));
    }

    public void doClearAll() {
        this.cache.clearAll();
    }
}

