/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import org.infinispan.util.BidirectionalLinkedHashMap;
import org.infinispan.util.ReversibleOrderedSet;

public class VisitableBidirectionalLinkedHashSet<E>
extends AbstractSet<E>
implements ReversibleOrderedSet<E>,
Cloneable {
    private transient BidirectionalLinkedHashMap<E, Object> map;
    private static final Object DUMMY_VALUE = new Object();

    public VisitableBidirectionalLinkedHashSet(boolean visitable, int initialCapacity, float loadFactor) {
        this.map = new BidirectionalLinkedHashMap(initialCapacity, loadFactor, visitable);
    }

    public VisitableBidirectionalLinkedHashSet(boolean visitable, int initialCapacity) {
        this(visitable, initialCapacity, 0.75f);
    }

    public VisitableBidirectionalLinkedHashSet(boolean visitable) {
        this(visitable, 16, 0.75f);
    }

    public VisitableBidirectionalLinkedHashSet(boolean visitable, Collection<? extends E> c) {
        this(visitable, Math.max(2 * c.size(), 11), 0.75f);
        this.addAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Iterator<E> reverseIterator() {
        return this.map.keySet().reverseIterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, DUMMY_VALUE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == DUMMY_VALUE;
    }

    public void visit(E key) {
        this.map.get(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public VisitableBidirectionalLinkedHashSet clone() {
        VisitableBidirectionalLinkedHashSet result;
        try {
            result = (VisitableBidirectionalLinkedHashSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Should never happen", e);
        }
        result.map = this.map.clone();
        return result;
    }
}

