/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.asm.util;

import java.io.PrintWriter;
import org.logicalcobwebs.asm.Attribute;
import org.logicalcobwebs.asm.ClassReader;
import org.logicalcobwebs.asm.ClassVisitor;
import org.logicalcobwebs.asm.CodeVisitor;
import org.logicalcobwebs.asm.util.PrintClassVisitor;
import org.logicalcobwebs.asm.util.TraceCodeVisitor;

public class TraceClassVisitor
extends PrintClassVisitor {
    protected final ClassVisitor cv;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Prints a disassembled view of the given class.");
            System.err.println("Usage: TraceClassVisitor <fully qualified class name>");
            System.exit(-1);
        }
        ClassReader cr = new ClassReader(args[0]);
        cr.accept(new TraceClassVisitor(null, new PrintWriter(System.out)), true);
    }

    public TraceClassVisitor(ClassVisitor cv, PrintWriter pw) {
        super(pw);
        this.cv = cv;
    }

    public void visit(int access, String name, String superName, String[] interfaces, String sourceFile) {
        this.buf.setLength(0);
        if ((access & 0x20000) != 0) {
            this.buf.append("// DEPRECATED\n");
        }
        if (sourceFile != null) {
            this.buf.append("// compiled from ").append(sourceFile).append("\n");
        }
        this.appendAccess(access & 0xFFFFFFDF);
        if ((access & 0x200) != 0) {
            this.buf.append("interface ");
        } else {
            this.buf.append("class ");
        }
        this.buf.append(name).append(" ");
        if (superName != null && !superName.equals("java/lang/Object")) {
            this.buf.append("extends ").append(superName).append(" ");
        }
        if (interfaces != null && interfaces.length > 0) {
            this.buf.append("implements ");
            for (int i = 0; i < interfaces.length; ++i) {
                this.buf.append(interfaces[i]).append(" ");
            }
        }
        this.buf.append("{\n\n");
        this.text.add(this.buf.toString());
        if (this.cv != null) {
            this.cv.visit(access, name, superName, interfaces, sourceFile);
        }
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.buf.setLength(0);
        this.buf.append("  INNERCLASS ").append(name).append(" ").append(outerName).append(" ").append(innerName).append(" ").append(access).append("\n");
        this.text.add(this.buf.toString());
        if (this.cv != null) {
            this.cv.visitInnerClass(name, outerName, innerName, access);
        }
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        this.buf.setLength(0);
        if ((access & 0x20000) != 0) {
            this.buf.append("  // DEPRECATED\n");
        }
        this.buf.append("  ");
        this.appendAccess(access);
        this.buf.append(desc).append(" ").append(name);
        if (value != null) {
            this.buf.append(" = ");
            if (value instanceof String) {
                this.buf.append("\"").append(value).append("\"");
            } else {
                this.buf.append(value);
            }
        }
        Attribute attr = attrs;
        while (attr != null) {
            this.buf.append(" , FIELD ATTRIBUTE ").append(attr.type);
            attr = attr.next;
        }
        this.buf.append("\n\n");
        this.text.add(this.buf.toString());
        if (this.cv != null) {
            this.cv.visitField(access, name, desc, value, attrs);
        }
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        this.buf.setLength(0);
        if ((access & 0x20000) != 0) {
            this.buf.append("  // DEPRECATED\n");
        }
        this.buf.append("  ");
        this.appendAccess(access);
        this.buf.append(name).append(" ").append(desc);
        if (exceptions != null && exceptions.length > 0) {
            this.buf.append(" throws ");
            for (int i = 0; i < exceptions.length; ++i) {
                this.buf.append(exceptions[i]).append(" ");
            }
        }
        this.buf.append("\n");
        this.text.add(this.buf.toString());
        Attribute attr = attrs;
        while (attr != null) {
            this.buf.setLength(0);
            this.buf.append("    METHOD ATTRIBUTE ").append(attr.type).append("\n");
            this.text.add(this.buf.toString());
            attr = attr.next;
        }
        CodeVisitor cv = this.cv != null ? this.cv.visitMethod(access, name, desc, exceptions, attrs) : null;
        TraceCodeVisitor pcv = new TraceCodeVisitor(cv);
        this.text.add(pcv.getText());
        return pcv;
    }

    public void visitAttribute(Attribute attr) {
        this.buf.setLength(0);
        this.buf.append("  CLASS ATTRIBUTE ").append(attr.type).append("\n");
        this.text.add(this.buf.toString());
        if (this.cv != null) {
            this.cv.visitAttribute(attr);
        }
    }

    public void visitEnd() {
        this.text.add("}\n");
        if (this.cv != null) {
            this.cv.visitEnd();
        }
        super.visitEnd();
    }

    private void appendAccess(int access) {
        if ((access & 1) != 0) {
            this.buf.append("public ");
        }
        if ((access & 2) != 0) {
            this.buf.append("private ");
        }
        if ((access & 4) != 0) {
            this.buf.append("protected ");
        }
        if ((access & 0x10) != 0) {
            this.buf.append("final ");
        }
        if ((access & 8) != 0) {
            this.buf.append("static ");
        }
        if ((access & 0x20) != 0) {
            this.buf.append("synchronized ");
        }
        if ((access & 0x40) != 0) {
            this.buf.append("volatile ");
        }
        if ((access & 0x80) != 0) {
            this.buf.append("transient ");
        }
        if ((access & 0x100) != 0) {
            this.buf.append("native ");
        }
        if ((access & 0x400) != 0) {
            this.buf.append("abstract ");
        }
        if ((access & 0x800) != 0) {
            this.buf.append("strictfp ");
        }
    }
}

