/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.asm.util;

import java.io.PrintWriter;
import org.logicalcobwebs.asm.Attribute;
import org.logicalcobwebs.asm.ClassReader;
import org.logicalcobwebs.asm.CodeVisitor;
import org.logicalcobwebs.asm.util.DumpCodeVisitor;
import org.logicalcobwebs.asm.util.PrintClassVisitor;

public class DumpClassVisitor
extends PrintClassVisitor {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Prints the ASM code to generate the given class.");
            System.err.println("Usage: DumpClassVisitor <fully qualified class name>");
            System.exit(-1);
        }
        ClassReader cr = new ClassReader(args[0]);
        cr.accept(new DumpClassVisitor(new PrintWriter(System.out)), true);
    }

    public DumpClassVisitor(PrintWriter pw) {
        super(pw);
    }

    public void visit(int access, String name, String superName, String[] interfaces, String sourceFile) {
        this.text.add("import org.logicalcobwebs.asm.*;\n");
        this.text.add("import java.io.FileOutputStream;\n\n");
        this.text.add("public class Dump implements Constants {\n\n");
        this.text.add("public static void main (String[] args) throws Exception {\n\n");
        this.text.add("ClassWriter cw = new ClassWriter(false);\n");
        this.text.add("CodeVisitor cv;\n\n");
        this.buf.setLength(0);
        this.buf.append("cw.visit(");
        this.appendAccess(access | 0x40000);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, name);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, superName);
        this.buf.append(", ");
        if (interfaces != null && interfaces.length > 0) {
            this.buf.append("new String[] {");
            for (int i = 0; i < interfaces.length; ++i) {
                this.buf.append(i == 0 ? " " : ", ");
                DumpClassVisitor.appendConstant(this.buf, interfaces[i]);
            }
            this.buf.append(" }");
        } else {
            this.buf.append("null");
        }
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, sourceFile);
        this.buf.append(");\n\n");
        this.text.add(this.buf.toString());
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.buf.setLength(0);
        this.buf.append("cw.visitInnerClass(");
        DumpClassVisitor.appendConstant(this.buf, name);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, outerName);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, innerName);
        this.buf.append(", ");
        this.appendAccess(access);
        this.buf.append(");\n\n");
        this.text.add(this.buf.toString());
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        this.buf.setLength(0);
        this.buf.append("cw.visitField(");
        this.appendAccess(access);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, name);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, desc);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, value);
        this.buf.append(", null);\n\n");
        if (attrs != null) {
            this.buf.append("// WARNING! skipped some non standard field attributes\n");
        }
        this.text.add(this.buf.toString());
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        this.buf.setLength(0);
        this.buf.append("{\n").append("cv = cw.visitMethod(");
        this.appendAccess(access);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, name);
        this.buf.append(", ");
        DumpClassVisitor.appendConstant(this.buf, desc);
        this.buf.append(", ");
        if (exceptions != null && exceptions.length > 0) {
            this.buf.append("new String[] {");
            for (int i = 0; i < exceptions.length; ++i) {
                this.buf.append(i == 0 ? " " : ", ");
                DumpClassVisitor.appendConstant(this.buf, exceptions[i]);
            }
            this.buf.append(" }");
        } else {
            this.buf.append("null");
        }
        this.buf.append(", null);\n");
        if (attrs != null) {
            this.buf.append("// WARNING! skipped some non standard method attributes\n");
        }
        this.text.add(this.buf.toString());
        DumpCodeVisitor pcv = new DumpCodeVisitor();
        this.text.add(pcv.getText());
        this.text.add("}\n");
        return pcv;
    }

    public void visitAttribute(Attribute attr) {
        this.buf.setLength(0);
        this.buf.append("// WARNING! skipped a non standard class attribute of type \"");
        this.buf.append(attr.type);
        this.buf.append("\"\n");
        this.text.add(this.buf.toString());
    }

    public void visitEnd() {
        this.text.add("cw.visitEnd();\n\n");
        this.text.add("FileOutputStream os = new FileOutputStream(\"Dumped.class\");\n");
        this.text.add("os.write(cw.toByteArray());\n");
        this.text.add("os.close();\n");
        this.text.add("}\n");
        this.text.add("}\n");
        super.visitEnd();
    }

    void appendAccess(int access) {
        boolean first = true;
        if ((access & 1) != 0) {
            this.buf.append("ACC_PUBLIC");
            first = false;
        }
        if ((access & 2) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_PRIVATE");
            first = false;
        }
        if ((access & 4) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_PROTECTED");
            first = false;
        }
        if ((access & 0x10) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_FINAL");
            first = false;
        }
        if ((access & 8) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_STATIC");
            first = false;
        }
        if ((access & 0x20) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            if ((access & 0x40000) != 0) {
                this.buf.append("ACC_SUPER");
            } else {
                this.buf.append("ACC_SYNCHRONIZED");
            }
            first = false;
        }
        if ((access & 0x40) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_VOLATILE");
            first = false;
        }
        if ((access & 0x80) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_TRANSIENT");
            first = false;
        }
        if ((access & 0x100) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_NATIVE");
            first = false;
        }
        if ((access & 0x400) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_ABSTRACT");
            first = false;
        }
        if ((access & 0x200) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_INTERFACE");
            first = false;
        }
        if ((access & 0x800) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_STRICT");
            first = false;
        }
        if ((access & 0x10000) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_SYNTHETIC");
            first = false;
        }
        if ((access & 0x20000) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_DEPRECATED");
            first = false;
        }
        if (first) {
            this.buf.append("0");
        }
    }

    static void appendConstant(StringBuffer buf, Object cst) {
        if (cst == null) {
            buf.append("null");
        } else if (cst instanceof String) {
            String s = (String)cst;
            buf.append("\"");
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\n') {
                    buf.append("\\n");
                    continue;
                }
                if (c == '\\') {
                    buf.append("\\\\");
                    continue;
                }
                if (c == '\"') {
                    buf.append("\\\"");
                    continue;
                }
                buf.append(c);
            }
            buf.append("\"");
        } else if (cst instanceof Integer) {
            buf.append("new Integer(").append(cst).append(")");
        } else if (cst instanceof Float) {
            buf.append("new Float(").append(cst).append("F)");
        } else if (cst instanceof Long) {
            buf.append("new Long(").append(cst).append("L)");
        } else if (cst instanceof Double) {
            buf.append("new Double(").append(cst).append(")");
        }
    }
}

