/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.logging.impl;

import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.logicalcobwebs.logging.Log;

public final class Log4JCategoryLog
implements Log {
    private static final String FQCN = (class$org$logicalcobwebs$logging$impl$Log4JCategoryLog == null ? (class$org$logicalcobwebs$logging$impl$Log4JCategoryLog = Log4JCategoryLog.class$("org.logicalcobwebs.logging.impl.Log4JCategoryLog")) : class$org$logicalcobwebs$logging$impl$Log4JCategoryLog).getName();
    private static boolean initialized = false;
    private static final String LAYOUT = "%r [%t] %p %c{2} %x - %m%n";
    private Category category = null;
    static /* synthetic */ Class class$org$logicalcobwebs$logging$impl$Log4JCategoryLog;

    public Log4JCategoryLog() {
        if (!initialized) {
            this.initialize();
        }
    }

    public Log4JCategoryLog(String name) {
        if (!initialized) {
            this.initialize();
        }
        this.category = Category.getInstance((String)name);
    }

    public Log4JCategoryLog(Category category) {
        if (!initialized) {
            this.initialize();
        }
        this.category = category;
    }

    private void initialize() {
        Category root = Category.getRoot();
        Enumeration appenders = root.getAllAppenders();
        if (appenders == null || !appenders.hasMoreElements()) {
            ConsoleAppender app = new ConsoleAppender((Layout)new PatternLayout(LAYOUT), "System.err");
            app.setName("commons-logging");
            root.addAppender((Appender)app);
            root.setLevel(Level.INFO);
        }
        initialized = true;
    }

    public void trace(Object message) {
        this.category.log(FQCN, Priority.DEBUG, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.category.log(FQCN, Priority.DEBUG, message, t);
    }

    public void debug(Object message) {
        this.category.log(FQCN, Priority.DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.category.log(FQCN, Priority.DEBUG, message, t);
    }

    public void info(Object message) {
        this.category.log(FQCN, Priority.INFO, message, null);
    }

    public void info(Object message, Throwable t) {
        this.category.log(FQCN, Priority.INFO, message, t);
    }

    public void warn(Object message) {
        this.category.log(FQCN, Priority.WARN, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.category.log(FQCN, Priority.WARN, message, t);
    }

    public void error(Object message) {
        this.category.log(FQCN, Priority.ERROR, message, null);
    }

    public void error(Object message, Throwable t) {
        this.category.log(FQCN, Priority.ERROR, message, t);
    }

    public void fatal(Object message) {
        this.category.log(FQCN, Priority.FATAL, message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.category.log(FQCN, Priority.FATAL, message, t);
    }

    public boolean isDebugEnabled() {
        return this.category.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.category.isEnabledFor(Priority.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.category.isEnabledFor(Priority.FATAL);
    }

    public boolean isInfoEnabled() {
        return this.category.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.category.isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return this.category.isEnabledFor(Priority.WARN);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

