/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.revisioninfo;

import java.util.Date;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionInfoQueryCreator {
    private final String revisionDateQuery;
    private final String revisionNumberForDateQuery;
    private final String revisionsQuery;
    private final boolean timestampAsDate;

    public RevisionInfoQueryCreator(String revisionInfoEntityName, String revisionInfoIdName, String revisionInfoTimestampName, boolean timestampAsDate) {
        this.timestampAsDate = timestampAsDate;
        this.revisionDateQuery = "select rev." + revisionInfoTimestampName + " from " + revisionInfoEntityName + " rev where " + revisionInfoIdName + " = :_revision_number";
        this.revisionNumberForDateQuery = "select max(rev." + revisionInfoIdName + ") from " + revisionInfoEntityName + " rev where " + revisionInfoTimestampName + " <= :_revision_date";
        this.revisionsQuery = "select rev from " + revisionInfoEntityName + " rev where " + revisionInfoIdName + " in (:_revision_numbers)";
    }

    public Query getRevisionDateQuery(Session session, Number revision) {
        return session.createQuery(this.revisionDateQuery).setParameter("_revision_number", (Object)revision);
    }

    public Query getRevisionNumberForDateQuery(Session session, Date date) {
        return session.createQuery(this.revisionNumberForDateQuery).setParameter("_revision_date", (Object)(this.timestampAsDate ? date : Long.valueOf(date.getTime())));
    }

    public Query getRevisionsQuery(Session session, Set<Number> revisions) {
        return session.createQuery(this.revisionsQuery).setParameterList("_revision_numbers", revisions);
    }
}

