/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.reader;

import java.util.Map;
import org.hibernate.envers.tools.Tools;
import org.hibernate.envers.tools.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirstLevelCache {
    private static final Logger log = LoggerFactory.getLogger(FirstLevelCache.class);
    private final Map<Triple<String, Number, Object>, Object> cache = Tools.newHashMap();
    private final Map<Triple<Object, Number, Object>, String> entityNameCache = Tools.newHashMap();

    public Object get(String entityName, Number revision, Object id) {
        if (log.isDebugEnabled()) {
            log.debug("Resolving object from First Level Cache: EntytiName:" + entityName + " - primaryKey:" + id + " - revision:" + revision);
        }
        return this.cache.get(Triple.make(entityName, revision, id));
    }

    public void put(String entityName, Number revision, Object id, Object entity) {
        if (log.isDebugEnabled()) {
            log.debug("Caching entity on First Level Cache:  - primaryKey:" + id + " - revision:" + revision + " - entityName:" + entityName);
        }
        this.cache.put(Triple.make(entityName, revision, id), entity);
    }

    public boolean contains(String entityName, Number revision, Object id) {
        return this.cache.containsKey(Triple.make(entityName, revision, id));
    }

    public void putOnEntityNameCache(Object id, Number revision, Object entity, String entityName) {
        if (log.isDebugEnabled()) {
            log.debug("Caching entityName on First Level Cache:  - primaryKey:" + id + " - revision:" + revision + " - entity:" + entity.getClass().getName() + " -> entityName:" + entityName);
        }
        this.entityNameCache.put(Triple.make(id, revision, entity), entityName);
    }

    public String getFromEntityNameCache(Object id, Number revision, Object entity) {
        if (log.isDebugEnabled()) {
            log.debug("Trying to resolve entityName from First Level Cache: - primaryKey:" + id + " - revision:" + revision + " - entity:" + entity);
        }
        return this.entityNameCache.get(Triple.make(id, revision, entity));
    }

    public boolean containsEntityName(Object id, Number revision, Object entity) {
        return this.entityNameCache.containsKey(Triple.make(id, revision, entity));
    }
}

