/*
 * Decompiled with CFR 0.152.
 */
package net.sf.swarmcache;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnboundedLRUMap
implements Map {
    Log log = LogFactory.getLog(this.getClass());
    public static final int MINIMUM_SIZE = 100;
    private LRUMap map = new LRUMap(this.size);
    int size = 100;

    public void clear() {
        if (this.size > 100) {
            this.map = new LRUMap(100);
            this.size = 100;
        } else {
            this.map.clear();
        }
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public boolean equals(Object obj) {
        return this.map.equals((Object)((UnboundedLRUMap)obj).map);
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object put(Object key, Object value) {
        if (value == null) {
            if (this.map.get(key) != null) {
                if (this.map.size() == this.size / 4 && this.size > 100) {
                    this.size /= 2;
                    this.log.debug((Object)("Map capacity has shrunk to " + this.size + ", size is " + (this.map.size() - 1) + "."));
                    LRUMap newMap = new LRUMap(this.size);
                    newMap.putAll((Map)this.map);
                    this.map = newMap;
                }
                return this.map.put(key, value);
            }
            return null;
        }
        if (this.map.get(key) != null) {
            return this.map.put(key, value);
        }
        if (this.map.size() == this.size) {
            this.size *= 2;
            this.log.debug((Object)("Map capacity has grown to " + this.size + ", size is " + (this.map.size() + 1) + "."));
            LRUMap newMap = new LRUMap(this.size);
            newMap.putAll((Map)this.map);
            this.map = newMap;
        }
        return this.map.put(key, value);
    }

    public void putAll(Map t) {
        Iterator keys = t.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            this.put(key, t.get(key));
        }
    }

    public Object remove(Object key) {
        if (this.map.get(key) != null) {
            if (this.map.size() == this.size / 4 && this.size > 100) {
                this.size /= 2;
                this.log.debug((Object)("Map capacity has shrunk to " + this.size + ", size is " + (this.map.size() - 1) + "."));
                LRUMap newMap = new LRUMap(this.size);
                newMap.putAll((Map)this.map);
                this.map = newMap;
            }
            return this.map.remove(key);
        }
        return null;
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return this.map.values();
    }

    public Object getFirstKey() {
        return this.map.getFirstKey();
    }
}

