/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.Map;
import java.util.Properties;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.infinispan.config.TypedPropertiesAdapter;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.util.StringPropertyReplacer;

@XmlJavaTypeAdapter(value=TypedPropertiesAdapter.class)
@XmlType(name="properties")
public class TypedProperties
extends Properties {
    private static final long serialVersionUID = 3799321248100686287L;
    private static final Log log = LogFactory.getLog(TypedProperties.class);

    public TypedProperties(Properties p) {
        if (p != null && !p.isEmpty()) {
            this.putAll((Map<?, ?>)p);
        }
    }

    public TypedProperties() {
    }

    public static TypedProperties toTypedProperties(Properties p) {
        if (p instanceof TypedProperties) {
            return (TypedProperties)p;
        }
        return new TypedProperties(p);
    }

    public int getIntProperty(String key, int defaultValue) {
        return this.getIntProperty(key, defaultValue, false);
    }

    public int getIntProperty(String key, int defaultValue, boolean doStringReplace) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim()).length() == 0) {
            return defaultValue;
        }
        if (doStringReplace) {
            value = StringPropertyReplacer.replaceProperties((String)value);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to convert string property [" + value + "] to an int!  Using default value of " + defaultValue);
            return defaultValue;
        }
    }

    public long getLongProperty(String key, long defaultValue) {
        return this.getLongProperty(key, defaultValue, false);
    }

    public long getLongProperty(String key, long defaultValue, boolean doStringReplace) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim()).length() == 0) {
            return defaultValue;
        }
        if (doStringReplace) {
            value = StringPropertyReplacer.replaceProperties((String)value);
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to convert string property [" + value + "] to a long!  Using default value of " + defaultValue);
            return defaultValue;
        }
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        return this.getBooleanProperty(key, defaultValue, false);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue, boolean doStringReplace) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim()).length() == 0) {
            return defaultValue;
        }
        if (doStringReplace) {
            value = StringPropertyReplacer.replaceProperties((String)value);
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            log.warn("Unable to convert string property [" + value + "] to a boolean!  Using default value of " + defaultValue);
            return defaultValue;
        }
    }

    public String getProperty(String key, String defaultValue, boolean doStringReplace) {
        if (doStringReplace) {
            return StringPropertyReplacer.replaceProperties((String)this.getProperty(key, defaultValue));
        }
        return this.getProperty(key, defaultValue);
    }
}

