/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats;

import java.util.List;
import net.jcip.annotations.Immutable;
import org.infinispan.interceptors.CacheMgmtInterceptor;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.stats.Stats;

@Immutable
public class StatsImpl
implements Stats {
    final long timeSinceStart;
    final int currentNumberOfEntries;
    final long totalNumberOfEntries;
    final long retrievals;
    final long stores;
    final long hits;
    final long misses;
    final long removeHits;
    final long removeMisses;
    final long evictions;

    public StatsImpl(InterceptorChain chain) {
        List<CommandInterceptor> interceptors = chain.getInterceptorsWhichExtend(CacheMgmtInterceptor.class);
        if (!interceptors.isEmpty()) {
            CacheMgmtInterceptor mgmtInterceptor = (CacheMgmtInterceptor)interceptors.get(0);
            this.timeSinceStart = mgmtInterceptor.getElapsedTime();
            this.currentNumberOfEntries = mgmtInterceptor.getNumberOfEntries();
            this.totalNumberOfEntries = mgmtInterceptor.getStores();
            this.retrievals = mgmtInterceptor.getHits() + mgmtInterceptor.getMisses();
            this.stores = mgmtInterceptor.getStores();
            this.hits = mgmtInterceptor.getHits();
            this.misses = mgmtInterceptor.getMisses();
            this.removeHits = mgmtInterceptor.getRemoveHits();
            this.removeMisses = mgmtInterceptor.getRemoveMisses();
            this.evictions = mgmtInterceptor.getEvictions();
        } else {
            this.timeSinceStart = -1L;
            this.currentNumberOfEntries = -1;
            this.totalNumberOfEntries = -1L;
            this.retrievals = -1L;
            this.stores = -1L;
            this.hits = -1L;
            this.misses = -1L;
            this.removeHits = -1L;
            this.removeMisses = -1L;
            this.evictions = -1L;
        }
    }

    @Override
    public long getTimeSinceStart() {
        return this.timeSinceStart;
    }

    @Override
    public int getCurrentNumberOfEntries() {
        return this.currentNumberOfEntries;
    }

    @Override
    public long getTotalNumberOfEntries() {
        return this.totalNumberOfEntries;
    }

    @Override
    public long getRetrievals() {
        return this.retrievals;
    }

    @Override
    public long getStores() {
        return this.stores;
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    @Override
    public long getMisses() {
        return this.misses;
    }

    @Override
    public long getRemoveHits() {
        return this.removeHits;
    }

    @Override
    public long getRemoveMisses() {
        return this.removeMisses;
    }

    @Override
    public long getEvictions() {
        return this.evictions;
    }
}

