/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.NotSerializableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.CacheException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.remoting.InboundInvocationHandler;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.ExtendedResponse;
import org.infinispan.remoting.responses.RequestIgnoredResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.DistributedSync;
import org.infinispan.remoting.transport.jgroups.JGroupsDistSync;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.Buffer;
import org.jgroups.util.FutureListener;
import org.jgroups.util.NotifyingFuture;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class CommandAwareRpcDispatcher
extends RpcDispatcher {
    protected boolean trace;
    ExecutorService asyncExecutor;
    InboundInvocationHandler inboundInvocationHandler;
    JGroupsDistSync distributedSync;
    long distributedSyncTimeout;
    private Log log = LogFactory.getLog(CommandAwareRpcDispatcher.class);
    AtomicBoolean newCacheStarting = new AtomicBoolean(false);
    AtomicBoolean newCacheStarted = new AtomicBoolean(false);
    private static final boolean FORCE_MCAST = Boolean.getBoolean("infinispan.unsafe.force_multicast");

    public CommandAwareRpcDispatcher() {
    }

    public CommandAwareRpcDispatcher(Channel channel, JGroupsTransport transport, ExecutorService asyncExecutor, InboundInvocationHandler inboundInvocationHandler, JGroupsDistSync distributedSync, long distributedSyncTimeout) {
        super(channel, (MessageListener)transport, (MembershipListener)transport, (Object)transport);
        this.asyncExecutor = asyncExecutor;
        this.inboundInvocationHandler = inboundInvocationHandler;
        this.distributedSync = distributedSync;
        this.trace = this.log.isTraceEnabled();
        this.distributedSyncTimeout = distributedSyncTimeout;
    }

    protected final boolean isValid(Message req) {
        if (req == null || req.getLength() == 0) {
            this.log.error("message or message buffer is null");
            return false;
        }
        return true;
    }

    public RspList invokeRemoteCommands(Vector<Address> dests, ReplicableCommand command, int mode, long timeout, boolean anycasting, boolean oob, RspFilter filter, boolean supportReplay, boolean asyncMarshalling, boolean broadcast) throws NotSerializableException, ExecutionException, InterruptedException {
        RspList response;
        ReplicationTask task = new ReplicationTask(command, oob, dests, mode, timeout, anycasting, filter, supportReplay, broadcast);
        if (asyncMarshalling) {
            this.asyncExecutor.submit(task);
            return null;
        }
        try {
            response = task.call();
        }
        catch (Exception e) {
            throw Util.rewrapAsCacheException(e);
        }
        if (mode == 6) {
            return null;
        }
        if (response.isEmpty() || this.containsOnlyNulls(response)) {
            return null;
        }
        return response;
    }

    private boolean containsOnlyNulls(RspList l) {
        for (Rsp r : l.values()) {
            if (r.getValue() == null && r.wasReceived() && !r.wasSuspected()) continue;
            return false;
        }
        return true;
    }

    public Object handle(Message req) {
        if (this.isValid(req)) {
            try {
                ReplicableCommand cmd = (ReplicableCommand)this.req_marshaller.objectFromByteBuffer(req.getBuffer(), req.getOffset(), req.getLength());
                if (cmd instanceof CacheRpcCommand) {
                    return this.executeCommand((CacheRpcCommand)cmd, req);
                }
                return cmd.perform(null);
            }
            catch (Throwable x) {
                if (this.trace) {
                    this.log.trace((Object)"Problems invoking command.", x);
                }
                return new ExceptionResponse(new CacheException("Problems invoking command.", x));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response executeCommand(CacheRpcCommand cmd, Message req) throws Throwable {
        if (cmd == null) {
            throw new NullPointerException("Unable to execute a null command!  Message was " + req);
        }
        if (this.trace) {
            this.log.trace((Object)"Attempting to execute command: {0} [sender={1}]", cmd, req.getSrc());
        }
        boolean unlock = false;
        try {
            this.distributedSync.acquireProcessingLock(false, this.distributedSyncTimeout, TimeUnit.MILLISECONDS);
            unlock = true;
            DistributedSync.SyncResponse sr = this.distributedSync.blockUntilReleased(this.distributedSyncTimeout, TimeUnit.MILLISECONDS);
            boolean replayIgnored = sr == DistributedSync.SyncResponse.STATE_ACHIEVED;
            Response resp = this.inboundInvocationHandler.handle(cmd);
            if (resp == null || resp.isValid()) {
                if (replayIgnored) {
                    resp = new ExtendedResponse(resp, true);
                }
            } else {
                this.newCacheStarting.set(true);
                if (this.trace) {
                    this.log.trace("Unable to execute command, got invalid response");
                }
            }
            Response response = resp;
            return response;
        }
        finally {
            if (unlock) {
                this.distributedSync.releaseProcessingLock();
            }
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[Outgoing marshaller: " + this.req_marshaller + "; incoming marshaller: " + this.rsp_marshaller + "]";
    }

    class FutureCollator
    implements FutureListener<Object> {
        final RspFilter filter;
        volatile RspList retval;
        final Map<Future<Object>, Address> futures = new HashMap<Future<Object>, Address>(4);
        volatile Exception exception;
        volatile int expectedResponses;
        final long timeout;

        FutureCollator(RspFilter filter, int expectedResponses, long timeout) {
            this.filter = filter;
            this.expectedResponses = expectedResponses;
            this.timeout = timeout;
        }

        public void watchFuture(NotifyingFuture<Object> f, Address address) {
            this.futures.put((Future<Object>)f, address);
            f.setListener((FutureListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RspList getResponseList() throws Exception {
            long giveupTime = System.currentTimeMillis() + this.timeout;
            FutureCollator futureCollator = this;
            synchronized (futureCollator) {
                while (giveupTime > System.currentTimeMillis() && this.expectedResponses > 0 && this.retval == null) {
                    this.wait(this.timeout);
                }
            }
            if (this.retval != null) {
                return this.retval;
            }
            if (this.exception != null) {
                throw this.exception;
            }
            throw new org.infinispan.util.concurrent.TimeoutException(String.format("TImed out waiting for %s for valid responses from either of %s", Util.prettyPrintTime(this.timeout), this.futures.values()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void futureDone(Future<Object> objectFuture) {
            FutureCollator futureCollator = this;
            synchronized (futureCollator) {
                Address sender = this.futures.get(objectFuture);
                try {
                    if (this.retval == null) {
                        Object response = objectFuture.get();
                        this.filter.isAcceptable(response, sender);
                        if (!this.filter.needMoreResponses()) {
                            this.retval = new RspList(Collections.singleton(new Rsp(sender, response)));
                        }
                        if (CommandAwareRpcDispatcher.this.log.isTraceEnabled()) {
                            CommandAwareRpcDispatcher.this.log.trace((Object)"Received response: {0} from {1}", response, sender);
                        }
                    } else if (CommandAwareRpcDispatcher.this.log.isDebugEnabled()) {
                        CommandAwareRpcDispatcher.this.log.debug((Object)"Skipping response from {0} since a valid response for this request has already been received", sender);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof org.jgroups.TimeoutException) {
                        this.exception = new org.infinispan.util.concurrent.TimeoutException("Timeout!", e);
                    } else if (e.getCause() instanceof Exception) {
                        this.exception = (Exception)e.getCause();
                    } else {
                        CommandAwareRpcDispatcher.this.log.info((Object)"Caught a Throwable.", e.getCause());
                    }
                    if (CommandAwareRpcDispatcher.this.log.isDebugEnabled()) {
                        CommandAwareRpcDispatcher.this.log.debug((Object)"Caught exception {0} from sender {1}.  Will skip this response.", this.exception.getClass().getName(), sender);
                    }
                    if (CommandAwareRpcDispatcher.this.trace) {
                        CommandAwareRpcDispatcher.this.log.trace((Object)"Exception caught: ", this.exception);
                    }
                }
                finally {
                    --this.expectedResponses;
                    this.notify();
                }
            }
        }
    }

    private class ReplicationTask
    implements Callable<RspList> {
        private ReplicableCommand command;
        private boolean oob;
        private Vector<Address> dests;
        private int mode;
        private long timeout;
        private boolean anycasting;
        private RspFilter filter;
        boolean supportReplay = false;
        boolean broadcast = false;

        private ReplicationTask(ReplicableCommand command, boolean oob, Vector<Address> dests, int mode, long timeout, boolean anycasting, RspFilter filter, boolean supportReplay, boolean broadcast) {
            this.command = command;
            this.oob = oob;
            this.dests = dests;
            this.mode = mode;
            this.timeout = timeout;
            this.anycasting = anycasting;
            this.filter = filter;
            this.supportReplay = supportReplay;
            this.broadcast = broadcast;
        }

        private Message constructMessage(Buffer buf, Address recipient) {
            Message msg = new Message();
            msg.setBuffer(buf);
            if (this.oob) {
                msg.setFlag((byte)1);
            }
            if (this.mode != 6) {
                msg.setFlag((byte)4);
                msg.setFlag((byte)8);
            }
            if (recipient != null) {
                msg.setDest(recipient);
            }
            return msg;
        }

        private Buffer marshallCall() {
            Buffer buf;
            try {
                buf = CommandAwareRpcDispatcher.this.req_marshaller.objectToBuffer((Object)this.command);
            }
            catch (Exception e) {
                throw new RuntimeException("Failure to marshal argument(s)", e);
            }
            return buf;
        }

        @Override
        public RspList call() throws Exception {
            Buffer buf;
            if (CommandAwareRpcDispatcher.this.log.isTraceEnabled()) {
                CommandAwareRpcDispatcher.this.log.trace("Replication task sending " + this.command + " to addresses " + this.dests);
            }
            int mode = this.supportReplay ? 2 : this.mode;
            CommandAwareRpcDispatcher.this.distributedSync.blockUntilNoJoinsInProgress();
            if (this.filter != null) {
                mode = 1;
            }
            RspList retval = null;
            if (this.broadcast || FORCE_MCAST) {
                RequestOptions opts = new RequestOptions();
                opts.setMode(mode);
                opts.setTimeout(this.timeout);
                opts.setRspFilter(this.filter);
                opts.setAnycasting(false);
                buf = this.marshallCall();
                retval = CommandAwareRpcDispatcher.this.castMessage(this.dests, this.constructMessage(buf, null), opts);
            } else {
                HashSet<Address> targets = new HashSet<Address>(this.dests);
                RequestOptions opts = new RequestOptions();
                opts.setMode(mode);
                opts.setTimeout(this.timeout);
                targets.remove(CommandAwareRpcDispatcher.this.channel.getAddress());
                if (targets.isEmpty()) {
                    return new RspList();
                }
                buf = this.marshallCall();
                if (this.filter != null) {
                    FutureCollator futureCollator = new FutureCollator(this.filter, targets.size(), this.timeout);
                    for (Address address : targets) {
                        NotifyingFuture f = CommandAwareRpcDispatcher.this.sendMessageWithFuture(this.constructMessage(buf, address), opts);
                        futureCollator.watchFuture((NotifyingFuture<Object>)f, address);
                    }
                    retval = futureCollator.getResponseList();
                } else if (mode == 2) {
                    HashMap<Address, NotifyingFuture> futures = new HashMap<Address, NotifyingFuture>(targets.size());
                    for (Address address : targets) {
                        futures.put(address, CommandAwareRpcDispatcher.this.sendMessageWithFuture(this.constructMessage(buf, address), opts));
                    }
                    retval = new RspList();
                    for (Map.Entry entry : futures.entrySet()) {
                        try {
                            retval.addRsp((Address)entry.getKey(), ((Future)entry.getValue()).get(this.timeout, TimeUnit.MILLISECONDS));
                        }
                        catch (TimeoutException te) {
                            throw new org.infinispan.util.concurrent.TimeoutException(Util.formatString("Timed out after {0} waiting for a response from {1}", Util.prettyPrintTime(this.timeout), entry.getKey()));
                        }
                    }
                } else if (mode == 6) {
                    for (Address dest : targets) {
                        CommandAwareRpcDispatcher.this.sendMessage(this.constructMessage(buf, dest), opts);
                    }
                }
            }
            if (mode != 6) {
                if (CommandAwareRpcDispatcher.this.trace) {
                    CommandAwareRpcDispatcher.this.log.trace((Object)"Responses: {0}", retval);
                }
                if (retval == null) {
                    throw new NotSerializableException("RpcDispatcher returned a null.  This is most often caused by args for " + this.command.getClass().getSimpleName() + " not being serializable.");
                }
                if (this.supportReplay) {
                    boolean replay = false;
                    Vector ignorers = new Vector();
                    for (Map.Entry entry : retval.entrySet()) {
                        Object object = ((Rsp)entry.getValue()).getValue();
                        if (object instanceof RequestIgnoredResponse) {
                            ignorers.add(entry.getKey());
                            continue;
                        }
                        if (!(object instanceof ExtendedResponse)) continue;
                        ExtendedResponse extended = (ExtendedResponse)object;
                        replay |= extended.isReplayIgnoredRequests();
                        ((Rsp)entry.getValue()).setValue((Object)extended.getResponse());
                    }
                    if (replay && !ignorers.isEmpty()) {
                        Message msg = this.constructMessage(buf, null);
                        msg.setFlag((byte)4);
                        if (CommandAwareRpcDispatcher.this.trace) {
                            CommandAwareRpcDispatcher.this.log.trace("Replaying message to ignoring senders: " + ignorers);
                        }
                        RequestOptions opts = new RequestOptions();
                        opts.setMode(2);
                        opts.setTimeout(this.timeout);
                        opts.setAnycasting(this.anycasting);
                        opts.setRspFilter(this.filter);
                        RspList rspList = CommandAwareRpcDispatcher.this.castMessage(ignorers, msg, opts);
                        if (rspList != null) {
                            retval.putAll((Map)rspList);
                        }
                    }
                }
            }
            return retval;
        }
    }
}

