/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.marshall.Externalizer;
import org.infinispan.marshall.Marshallable;
import org.infinispan.remoting.transport.Address;

@Marshallable(externalizer=NodeTopologyInfoExternalizer.class, id=60)
public class NodeTopologyInfo {
    private final String machineId;
    private final String rackId;
    private final String siteId;
    private final Address address;

    public NodeTopologyInfo(String machineId, String rackId, String siteId, Address address) {
        this.machineId = machineId;
        this.rackId = rackId;
        this.siteId = siteId;
        this.address = address;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public String getRackId() {
        return this.rackId;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public boolean sameSite(NodeTopologyInfo info2) {
        return this.equalObjects(this.siteId, info2.siteId);
    }

    public boolean sameRack(NodeTopologyInfo info2) {
        return this.sameSite(info2) && this.equalObjects(this.rackId, info2.rackId);
    }

    public boolean sameMachine(NodeTopologyInfo info2) {
        return this.sameRack(info2) && this.equalObjects(this.machineId, info2.machineId);
    }

    private boolean equalObjects(Object first, Object second) {
        return first == null ? second == null : first.equals(second);
    }

    public Address getAddress() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeTopologyInfo that = (NodeTopologyInfo)o;
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        if (this.machineId != null ? !this.machineId.equals(that.machineId) : that.machineId != null) {
            return false;
        }
        if (this.rackId != null ? !this.rackId.equals(that.rackId) : that.rackId != null) {
            return false;
        }
        return !(this.siteId != null ? !this.siteId.equals(that.siteId) : that.siteId != null);
    }

    public int hashCode() {
        int result = this.machineId != null ? this.machineId.hashCode() : 0;
        result = 31 * result + (this.rackId != null ? this.rackId.hashCode() : 0);
        result = 31 * result + (this.siteId != null ? this.siteId.hashCode() : 0);
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "NodeTopologyInfo{machineId='" + this.machineId + '\'' + ", rackId='" + this.rackId + '\'' + ", siteId='" + this.siteId + '\'' + ", address=" + this.address + '}';
    }

    public static class NodeTopologyInfoExternalizer
    implements Externalizer {
        @Override
        public void writeObject(ObjectOutput output, Object object) throws IOException {
            NodeTopologyInfo nti = (NodeTopologyInfo)object;
            output.writeObject(nti.siteId);
            output.writeObject(nti.rackId);
            output.writeObject(nti.machineId);
            output.writeObject(nti.address);
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String siteId = (String)input.readObject();
            String rackId = (String)input.readObject();
            String machineId = (String)input.readObject();
            Address address = (Address)input.readObject();
            return new NodeTopologyInfo(machineId, rackId, siteId, address);
        }
    }
}

