/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.FastMath;
import healpix.essentials.HealpixUtils;
import healpix.essentials.Vec3;
import healpix.essentials.Zphi;

public class Pointing {
    public double theta;
    public double phi;

    public Pointing() {
    }

    public Pointing(Pointing ptg) {
        this.theta = ptg.theta;
        this.phi = ptg.phi;
    }

    public Pointing(double theta, double phi) {
        this.theta = theta;
        this.phi = phi;
    }

    public Pointing(Vec3 vec) {
        this.theta = FastMath.atan2(Math.sqrt(vec.x * vec.x + vec.y * vec.y), vec.z);
        this.phi = FastMath.atan2(vec.y, vec.x);
        if (this.phi < 0.0) {
            this.phi += Math.PI * 2;
        }
        if (this.phi >= Math.PI * 2) {
            this.phi -= Math.PI * 2;
        }
    }

    public Pointing(Zphi zphi) {
        double xy = Math.sqrt((1.0 - zphi.z) * (1.0 + zphi.z));
        this.theta = FastMath.atan2(xy, zphi.z);
        this.phi = zphi.phi;
    }

    public void normalizeTheta() {
        this.theta = HealpixUtils.fmodulo(this.theta, Math.PI * 2);
        if (this.theta > Math.PI) {
            this.phi += Math.PI;
            this.theta = Math.PI * 2 - this.theta;
        }
    }

    public void normalize() {
        this.normalizeTheta();
        this.phi = HealpixUtils.fmodulo(this.phi, Math.PI * 2);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("ptg(");
        s.append(this.theta);
        s.append(",");
        s.append(this.phi);
        s.append(")");
        return s.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pointing pointing = (Pointing)o;
        if (Double.compare(pointing.phi, this.phi) != 0) {
            return false;
        }
        return Double.compare(pointing.theta, this.theta) == 0;
    }

    public int hashCode() {
        int result = Double.valueOf(this.theta).hashCode();
        result = 31 * result + Double.valueOf(this.phi).hashCode();
        return result;
    }
}

