/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.HealpixUtils;
import healpix.essentials.Vec3;

final class CircleFinder {
    private Vec3 center;
    private double cosrad;

    private void getCircle(Vec3[] point, int q1, int q2) {
        this.center = point[q1].add(point[q2]);
        this.center.normalize();
        this.cosrad = point[q1].dot(this.center);
        for (int i = 0; i < q1; ++i) {
            if (!(point[i].dot(this.center) < this.cosrad)) continue;
            this.center = point[q1].sub(point[i]).cross(point[q2].sub(point[i]));
            this.center.normalize();
            this.cosrad = point[i].dot(this.center);
            if (!(this.cosrad < 0.0)) continue;
            this.center.flip();
            this.cosrad = -this.cosrad;
        }
    }

    private void getCircle(Vec3[] point, int q) {
        this.center = point[0].add(point[q]);
        this.center.normalize();
        this.cosrad = point[0].dot(this.center);
        for (int i = 1; i < q; ++i) {
            if (!(point[i].dot(this.center) < this.cosrad)) continue;
            this.getCircle(point, i, q);
        }
    }

    public CircleFinder(Vec3[] point) throws Exception {
        int np = point.length;
        HealpixUtils.check(np >= 2, "too few points");
        this.center = point[0].add(point[1]);
        this.center.normalize();
        this.cosrad = point[0].dot(this.center);
        for (int i = 2; i < np; ++i) {
            if (!(point[i].dot(this.center) < this.cosrad)) continue;
            this.getCircle(point, i);
        }
    }

    public Vec3 getCenter() {
        return new Vec3(this.center);
    }

    public double getCosrad() {
        return this.cosrad;
    }
}

