/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.gradle.api.internal.tasks.options.FieldOptionElement;
import org.gradle.api.internal.tasks.options.InstanceOptionDescriptor;
import org.gradle.api.internal.tasks.options.MethodOptionElement;
import org.gradle.api.internal.tasks.options.MethodSignature;
import org.gradle.api.internal.tasks.options.OptionDescriptor;
import org.gradle.api.internal.tasks.options.OptionElement;
import org.gradle.api.internal.tasks.options.OptionValidationException;
import org.gradle.api.internal.tasks.options.OptionValueNotationParserFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.options.Option;
import org.gradle.api.tasks.options.OptionValues;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.internal.CollectionUtils;
import org.jspecify.annotations.Nullable;

@ServiceScope(value={Scope.Build.class})
public class OptionReader {
    private final ListMultimap<Class<?>, OptionElement> cachedOptionElements = ArrayListMultimap.create();
    private final Map<OptionElement, JavaMethod<Object, ?>> cachedOptionValueMethods = new HashMap();
    private final OptionValueNotationParserFactory optionValueNotationParserFactory = new OptionValueNotationParserFactory();

    public Map<String, OptionDescriptor> getOptions(Object target) {
        Class<?> targetClass = target.getClass();
        HashMap<String, OptionDescriptor> options = new HashMap<String, OptionDescriptor>();
        if (!this.cachedOptionElements.containsKey(targetClass)) {
            this.loadClassDescriptorInCache(target);
        }
        for (OptionElement optionElement : this.cachedOptionElements.get(targetClass)) {
            JavaMethod<Object, ?> optionValueMethod = this.cachedOptionValueMethods.get(optionElement);
            options.put(optionElement.getOptionName(), new InstanceOptionDescriptor(target, optionElement, optionValueMethod));
        }
        return options;
    }

    private void loadClassDescriptorInCache(Object target) {
        Collection<OptionElementAndSignature> optionElements = this.getOptionElements(target);
        List<JavaMethod<Object, ?>> optionValueMethods = OptionReader.loadValueMethodForOption(target.getClass());
        HashMap<String, MethodSignature> processedOptionElements = new HashMap<String, MethodSignature>();
        for (OptionElementAndSignature optionElementAndSignature : optionElements) {
            OptionElement optionElement = optionElementAndSignature.element;
            MethodSignature signature = optionElementAndSignature.signature;
            if (processedOptionElements.containsKey(optionElement.getOptionName())) {
                MethodSignature existingSignature = (MethodSignature)processedOptionElements.get(optionElement.getOptionName());
                if (Objects.equals(signature, existingSignature)) continue;
                throw new OptionValidationException(String.format("@Option '%s' linked to multiple elements in class '%s'.", optionElement.getOptionName(), target.getClass().getName()));
            }
            processedOptionElements.put(optionElement.getOptionName(), signature);
            JavaMethod<Object, ?> optionValueMethodForOption = OptionReader.getOptionValueMethodForOption(optionValueMethods, optionElement);
            this.cachedOptionElements.put(target.getClass(), (Object)optionElement);
            this.cachedOptionValueMethods.put(optionElement, optionValueMethodForOption);
        }
    }

    private static JavaMethod<Object, ?> getOptionValueMethodForOption(List<JavaMethod<Object, ?>> optionValueMethods, OptionElement optionElement) {
        JavaMethod<Object, ?> valueMethod = null;
        for (JavaMethod<Object, ?> optionValueMethod : optionValueMethods) {
            Object[] optionNames = OptionReader.getOptionNames(optionValueMethod);
            if (!CollectionUtils.toList((Object[])optionNames).contains(optionElement.getOptionName())) continue;
            if (valueMethod == null) {
                valueMethod = optionValueMethod;
                continue;
            }
            throw new OptionValidationException(String.format("@OptionValues for '%s' cannot be attached to multiple methods in class '%s'.", optionElement.getOptionName(), optionValueMethod.getMethod().getDeclaringClass().getName()));
        }
        return valueMethod;
    }

    private static String[] getOptionNames(JavaMethod<Object, ?> optionValueMethod) {
        OptionValues optionValues = optionValueMethod.getMethod().getAnnotation(OptionValues.class);
        return optionValues.value();
    }

    private Collection<OptionElementAndSignature> getOptionElements(Object target) {
        Class type;
        ArrayList<OptionElementAndSignature> allOptionElements = new ArrayList<OptionElementAndSignature>();
        HashSet visitedInterfaces = new HashSet();
        ArrayDeque interfacesToCheck = new ArrayDeque();
        for (type = target.getClass(); type != Object.class && type != null; type = type.getSuperclass()) {
            interfacesToCheck.addAll(Arrays.asList(type.getInterfaces()));
            allOptionElements.addAll(this.getMethodAnnotations(type));
            for (OptionElement element : this.getFieldAnnotations(type)) {
                allOptionElements.add(new OptionElementAndSignature(element, null));
            }
        }
        while (interfacesToCheck.size() > 0) {
            type = (Class)interfacesToCheck.pop();
            if (!visitedInterfaces.add(type)) continue;
            interfacesToCheck.addAll(Arrays.asList(type.getInterfaces()));
            allOptionElements.addAll(this.getMethodAnnotations(type));
        }
        return allOptionElements;
    }

    private List<OptionElement> getFieldAnnotations(Class<?> type) {
        ArrayList<OptionElement> fieldOptionElements = new ArrayList<OptionElement>();
        for (Field field : type.getDeclaredFields()) {
            Option option = this.findOption(field);
            if (option == null) continue;
            fieldOptionElements.add(FieldOptionElement.create(option, field, this.optionValueNotationParserFactory));
        }
        return fieldOptionElements;
    }

    private Option findOption(Field field) {
        Option option = field.getAnnotation(Option.class);
        if (option != null && Modifier.isStatic(field.getModifiers())) {
            throw new OptionValidationException(String.format("@Option on static field '%s' not supported in class '%s'.", field.getName(), field.getDeclaringClass().getName()));
        }
        return option;
    }

    private List<OptionElementAndSignature> getMethodAnnotations(Class<?> type) {
        ArrayList<OptionElementAndSignature> methodOptionElements = new ArrayList<OptionElementAndSignature>();
        for (Method method : type.getDeclaredMethods()) {
            Option option = this.findOption(method);
            if (option == null) continue;
            OptionElement methodOptionDescriptor = MethodOptionElement.create(option, method, this.optionValueNotationParserFactory);
            methodOptionElements.add(new OptionElementAndSignature(methodOptionDescriptor, MethodSignature.from(method)));
        }
        return methodOptionElements;
    }

    private Option findOption(Method method) {
        Option option = method.getAnnotation(Option.class);
        if (option != null && Modifier.isStatic(method.getModifiers())) {
            throw new OptionValidationException(String.format("@Option on static method '%s' not supported in class '%s'.", method.getName(), method.getDeclaringClass().getName()));
        }
        return option;
    }

    private static List<JavaMethod<Object, ?>> loadValueMethodForOption(Class<?> declaredClass) {
        ArrayList methods = new ArrayList();
        for (Class<?> type = declaredClass; type != Object.class && type != null; type = type.getSuperclass()) {
            for (Method method : type.getDeclaredMethods()) {
                JavaMethod<Object, ?> optionValuesMethod = OptionReader.getAsOptionValuesMethod(type, method);
                if (optionValuesMethod == null) continue;
                methods.add(optionValuesMethod);
            }
        }
        return methods;
    }

    private static JavaMethod<Object, ?> getAsOptionValuesMethod(Class<?> type, Method method) {
        OptionValues optionValues = method.getAnnotation(OptionValues.class);
        if (optionValues == null) {
            return null;
        }
        if (method.getParameterTypes().length == 0 && !Modifier.isStatic(method.getModifiers())) {
            if (Collection.class.isAssignableFrom(method.getReturnType())) {
                return JavaMethod.of(Collection.class, (Method)method);
            }
            if (Provider.class.equals(method.getReturnType()) && Collection.class.isAssignableFrom(OptionReader.getProviderNestedRawType(method.getGenericReturnType()))) {
                return JavaMethod.of(Provider.class, (Method)method);
            }
        }
        throw new OptionValidationException(String.format("@OptionValues annotation not supported on method '%s' in class '%s'. Supported method must be non-static, return a Collection<String> or Provider<Collection<String>> and take no parameters.", method.getName(), type.getName()));
    }

    private static Class<?> getProviderNestedRawType(Type providerType) {
        TypeToken typeToken = TypeToken.of((Type)providerType);
        return JavaReflectionUtil.extractNestedType((TypeToken)typeToken, Provider.class, (int)0).getRawType();
    }

    private static final class OptionElementAndSignature {
        final OptionElement element;
        final @Nullable MethodSignature signature;

        OptionElementAndSignature(OptionElement element, @Nullable MethodSignature signature) {
            this.element = element;
            this.signature = signature;
        }
    }
}

